<?php


namespace Common\Model;
use Think\Model;
class ShopLoginModel extends Model{
    protected $tableName = 'shops';
	public function _initialize(){
		parent::_initialize ();
       	$forward=I('shop_forward')?I('shop_forward'):cookie('shop_forward');
      	$this->jumpUrl = $forward? $forward: U('Shop/Index/index');
    }
    
    public function check_login($param){
        $return=array('status'=>0,'info'=>'');
        if(empty($param)){$return['info']='参数错误';return $return;}
		
        $username=$param['name'];
		$password=$param['password'];
		$verify=$param['verify'];
		
        if(empty($username) || empty($password)){$return['info']='请输入用户名或密码'; return $return;}
        if(empty($verify)){
			$return['info']='请输入验证码';return $return;
		}elseif(!check_verify($verify,'Member')){
            $return['info']=L('verify_error');return $return;
        }
        $map['username|mobile']= array($username,$username,'_multi'=>true);
        $map['status'] = 1;
		$map['shop_id'] = array('gt',0);
        $userinfo = M('Member')->where($map)->field('salt,password,shop_id')->find();
        if($userinfo){
			$postpassword = creatpwd($password,'HANCHAO'.$userinfo['salt']);
			if($postpassword==$userinfo['password']){
				$s_map['id']=$userinfo['shop_id'];
				$s_map['status']=1;
				$shopinfo=M('Shops')->where($s_map)->field(true)->find();
				if(empty($shopinfo)){$return['info']='此店铺已禁止使用';return $return;}
				$return['status']=1;
				$return['info']='登录成功';
				$return['url']=$this->jumpUrl;
				if(cookie('shop_forward')){cookie('shop_forward',null);}
			}else{
				$return['info']='密码错误';return $return;
			}
        }else{
			$sub_map['username|mobile']= array($username,$username,'_multi'=>true);
			$sub_map['status'] = 1;
			$uid = M('Member')->where($sub_map)->getField('id');
			if($uid){
				$sub_info=M('ShopsSubmit')->where('uid='.$uid)->order('id desc')->field('id,publish_wait')->find();
				if(empty($sub_info)){
					$return['url']=U('Home/Login/index');
					$return['info']='您还不是店铺，请到会员登录处登录';
				}elseif($sub_info['publish_wait']==0){
					$return['info']='店铺正在审核，暂时不可以登录';
				}elseif($sub_info['publish_wait']==2){
					$return['info']='该店铺未通过审核，不可以登录';
				}
			}else{
				$return['info']='用户不存在,或者被删除!';
			}
        }
        if($return['status']==1){
            $this->loginupdate($shopinfo['id']);
            action_log('shop_login', 'Shop', $shopinfo['id'],$shopinfo['id']);//店铺登录日志
        }
        return $return;
    }
	
	
    public function loginupdate($shop_id){
        if(!$shop_id)return false;
        $savedata['login_count'] = array('exp', 'login_count+1');
        $savedata['last_login'] = NOW_TIME;
        $savedata['last_ip'] = get_client_ip(1);
        M('Shops')->where('id='.$shop_id)->save($savedata);
        $shopinfo=M('Shops')->where('id='.$shop_id)->field(true)->find();
        $shopinfo['shop_info_auth_sign'] = data_auth_sign($shopinfo);
        session('shop_info', $shopinfo);
    }
	
    public function logout(){
        $shop_info=session('shop_info');
        $url=U('Shop/Register/shop_login');
        if(isset($shop_info)){
            session('shop_info',null);
            $return['status']=1;
            $return['info']='退出成功';
            $return['url']=$url;
        }else{
            $return['status']=0;
            $return['info']='已经退出登录！';
            $return['url']=$url;
        }
        return $return;
    }
	
	 public function resetpwd($data){
		$return=array('status'=>0,'info'=>'');
		$shop_info=session('shop_info');
		
		if(empty($shop_info)){$return['info']='登录超时，请重新登录!';return $return;}
		if(empty($data['password'])){$return['info']='请输入原密码!';return $return;}
		if(!$data['new_password'] || !$data['yes_password'] || $data['new_password']!=$data['yes_password']){
			$return['info']='您输入的新密码为空或不一致,请重新输入!';return $return;
		}
		$userinfo=M('Member')->where('id='.$shop_info['uid'])->field('password,salt')->find();
		
		
		$old_psw=creatpwd($data['password'], 'HANCHAO'.$userinfo['salt']);
		if($old_psw != $userinfo['password']){$return['info']='旧密码不正确!';return $return;}
		
		//修改密码
		$save['salt'] = randStr();
		$save['password'] = creatpwd($data['new_password'], 'HANCHAO'.$save['salt']);
		$result=M('Member')->where('id='.$shop_info['uid'])->save($save);
		
		if($result){
			session('shop_info',null);
			action_log('shop_resetpwd', 'Shop', $shop_info['id'], $shop_info['id']);//日志
			$return['status']=1;
			$return['info']='修改密码成功！请重新登录';
		}else{
			$return['info']='修改失败';
		}
		return $return;
	}
	
	 public function get_shop($data){
		$return=array('status'=>0,'info'=>'');
		
		$is_true = check_verify_code($data['mobile'],$data['mobilecode'],0);
		if($is_true == false){$return['info']='短信验证码错误!';return $return;}
		
		$u_map['mobile']=$data['mobile'];
		$userinfo=M('Member')->where($u_map)->field('id,status,shop_id')->find();
		if(empty($userinfo) || $userinfo['status']==0){$return['info']='会员不存在或已禁用';return $return;}
		
		$shop_info=M('Shops')->where('id='.$userinfo['shop_id'])->field('id,status')->find();
		if(empty($shop_info) || $shop_info['status']==0){$return['info']='店铺不存在或已禁用';return $return;}
		
		$return['status']=1;
		$return['uid'] =$userinfo['id'];
		return $return;
	}
	
	 public function getpwd($data){
		$return=array('status'=>0,'info'=>'');
		
		if(!$data['uid']){$return['info']='店铺信息错误';return $return;}
		if(!$data['password'] || !$data['repassword'] || $data['password']!=$data['repassword']){
			$return['info']='您输入的新密码为空或不一致,请重新输入!';return $return;
		}
		$save['salt'] = randStr();
		$save['password'] = creatpwd($data['password'], 'HANCHAO'.$save['salt']);
		$result=M('Member')->where('id='.$data['uid'])->save($save);
		if($result !== false){
			$return['status']=1;
			$return['info']='找回密码成功！';
			$shop_id=idtoname($data['uid'],'Member','shop_id');
			action_log('shop_getpwd', 'Shop', $shop_id, $shop_id);//日志
		}else{
			$return['info']='找回密码失败！';
		}
		return $return;
	}
    
    public function register($postdata){
        $return=array('status'=>0,'info'=>'');
		if(empty($postdata['cate_ids'])){$return['info']='请选择经营类目';return $return;}
		
		$memberinfo=checkuserauthtype();
		$uid=$memberinfo['id'];
		
		if(!$uid){//注册会员
			$user_data['username']=$postdata['username'];unset($postdata['username']);
			$user_data['mobile']=$postdata['mobile'];unset($postdata['mobile']);
			$user_data['password']=$postdata['u_password'];unset($postdata['u_password']);
			$user_data['repassword']=$postdata['u_repassword'];unset($postdata['u_repassword']);
			$user_data['mobilecode']=$postdata['mobilecode'];unset($postdata['mobilecode']);
			$user_data['verify']=$postdata['verify'];unset($postdata['verify']);
			$result=D('Common/Login')->do_register($user_data);
			if($result['status']!=1){$return['info']=$result['info'];return $return;}
			$uid=$result['data']['id'];
		}
		
		if(!$uid){$return['info']='会员信息不存在';return $return;}
		
		//检测名称重复
		$name_map['name']=$postdata['name'];
		$name_map['publish_wait']=array('neq',2);
		$name_map['uid']=array('neq',$uid);
		$is_shop=M('ShopsSubmit')->where($name_map)->find();
		if($is_shop){$return['info']='公司名称已被申请，请换个其他名称';return $return;}
		
		//店铺地址
		$str='';
		if($postdata['province'])$str.=$postdata['province'];
		if($postdata['city_id'])$str.=','.$postdata['city_id'];
		if($postdata['district'])$str.=','.$postdata['district'];
		
		//经营品类
		if(!empty($postdata['cate_ids'])){$postdata['cate_ids']=implode(',',$postdata['cate_ids']);}
		
		$postdata['uid']=$uid;
		$postdata['publish_wait']=0;
		$postdata['updatetime']=NOW_TIME;
		$postdata['licence_start']=strtotime($postdata['licence_start']);
		$postdata['licence_end']=strtotime($postdata['licence_end']);
		$postdata['postion']=$str;
		M('ShopsSubmit')->create($postdata);
		
		if($postdata['id']){
			$res=M('ShopsSubmit')->where('id='.$postdata['id'])->save();
		}else{
			$res=M('ShopsSubmit')->add();
		}
		if($res===false){$return['info']='提交失败';return $return;}
		
		$return['status']=1;
		$return['info']='提交成功，等待后台审核';
        return $return;
    }
}
?>