<?php


namespace Common\Model;
use Think\Model;
class WithdrawalsModel extends Model{
	protected $tableName = 'member_withdrawals';
	
    public function add_bank($postdata){
		$return=array('status'=>0,'info'=>'');
		$type=$postdata['type'];
		if($type==0){//会员
			$member_info=checkuserauthtype();
			$uid=$member_info['id'];
			if(!$uid){$return['info']='登录信息错误';return $return;}
		}elseif($type==1){//店铺
			$member_info=session('shop_info');
			$uid=$member_info['id'];
			if(!$uid){$return['info']='登录信息错误';return $return;}
		}
		$map['uid']=$uid;
		$map['status']=1;
		$map['type']=$type;
		$is_bank=M('MemberBank')->where($map)->getField('id');
		if($is_bank){$return['info']='提现账号已存在';return $return;}
		if(empty($postdata['bankcode']) || empty($postdata['bankname']) || empty($postdata['name'])){
			$return['info']='必填项请不要为空';return $return;
		}
		$postdata['addtime']=NOW_TIME;
		$postdata['uid']=$uid;
		if($postdata['token']){//app提交数据
			unset($postdata['token']);
			$result=M('MemberBank')->add($postdata);
		}else{
			M('MemberBank')->create($postdata);
			$result=M('MemberBank')->add();
		}
		if($result){
			$return['status']=1;
			$return['info']='添加成功!';
			if($type==0){
				action_log('user_add_bank', 'Member', $result, $uid);//操作日志
			}else{
				action_log('shop_add_bank', 'Shop', $result, $uid);//操作日志
			}
		}else{
			$return['info']='添加失败!';
		}
		unset($postdata);
        return $return;
    }
	
    public function get_money($postdata){
		$return=array('status'=>0,'info'=>'');
		
		$member_info=checkuserauthtype();
		$uid=$member_info['id'];
		if(!$uid){$return['info']='登录信息错误';return $return;}
		
		//开启支付密码
		if(C('OPEN_PAYPSW')){
			$paypassword=idtoname($uid,'Member','paypassword');
			if($paypassword == ''){$return['status']=2;$return['info']="您没设置交易密码,请设置交易密码";return $return;}
			
			$postpassword = creatpwd($postdata['paypassword'],'HANCHAO'.$member_info['salt']);
			if($postpassword != $paypassword){$return['status']=3;$return['info']='支付密码错误!';return $return;}
		}
		//开启提现短信验证
		if(C('SMS_TX_VERIFY')){
			$is_true = check_verify_code($postdata['mobile'],$postdata['mobilecode'],0);
			if($is_true == false){$return['info']='短信验证码错误，请重新获取!';return $return;}
		}
		$member_money=idtoname($uid,'Member','money','id',false);
		if($postdata){
			//提现金额
			if(!$postdata['money']){$return['info']='提现金额不能为空';return $return;}
            if((float)$postdata['money']<(float)0){$return['info']='请正确填写提现金额';return $return;}
			$min_money=C('USER_MIN_GET_MONEY');//会员最低提现金额
			if($postdata['money'] < $min_money && (float)$min_money > (float)0){$return['info']='不能低于最低提现金额';return $return;}
			if($postdata['money'] > $member_money){$return['info']='余额不足';return $return;}
			
			//提现手续费
			$payfree=C('TIXIAN_FREE');
			if($payfree<1)$payfree=format_decimal($payfree*$postdata['money'],2,2);
			$postdata['free']=$payfree;
			if($payfree >= $postdata['money']){$return['info']='提现金额应大于手续费';return $return;}
			
			//账期
			$end_time=C('USER_ACCOUNT_DATE')*86400;
			$postdata['end_time']=NOW_TIME+$end_time;
			
			$postdata['create_time']=NOW_TIME;
			$postdata['uid']=$uid;
			$postdata['type']=0;
			$result=M('MemberWithdrawals')->add($postdata);
			if($result){
				account_change($uid,format_decimal($postdata['money']),2,2,'申请提现，冻结资金');
				account_change($uid,-format_decimal($postdata['money']),1,2,'申请提现，扣除资金');
				$return['status']=1;
				$return['info']='申请成功!';
				action_log('user_get_money', 'Member', $result, $uid);//申请提现日志
			}else{
				$return['info']='申请失败!';
			}
        }
		unset($postdata);
        return $return;
    }
	
    public function shop_get_money($postdata){
		$return=array('status'=>0,'info'=>'');
		
		$shop_info=session('shop_info');
		$uid=$shop_info['id'];
		if(!$uid){$return['info']='登录信息错误';return $return;}
		
		//开启提现短信验证
		if(C('SMS_TX_VERIFY')){
			$is_true = check_verify_code($postdata['mobile'],$postdata['mobilecode'],0);
			if($is_true == false){$return['info']='短信验证码错误，请重新获取!';return $return;}
		}
		
		$shop_money=idtoname($uid,'Shops','total_revenues','id',false);
		if($postdata){
			//提现金额
			if(!$postdata['money']){$return['info']='金额不能为空';return $return;}
			$min_money=C('SHOP_MIN_GET_MONEY');//店铺最低提现金额
			if($postdata['money'] < $min_money && $min_money > 0){$return['info']='不能低于最低提现金额';return $return;}
			if($postdata['money'] > $shop_money){$return['info']='余额不足';return $return;}
			
			//提现手续费
			$payfree=C('SHOP_TIXIAN_FREE');
			if($payfree<1)$payfree=format_decimal($payfree*$postdata['money'],2,2);
			$postdata['free']=$payfree;
			
			//账期
			$end_time=idtoname($uid,'Shops','end_date','id',false);
			if($end_time <= 0)$end_time=C('SHOP_ACCOUNT_DATE');
			$end_time=$end_time*86400;
			$postdata['end_time']=NOW_TIME+$end_time;
			
			$postdata['create_time']=NOW_TIME;
			$postdata['uid']=$uid;
			$postdata['type']=1;
			$result=M('MemberWithdrawals')->add($postdata);
			if($result){
				shop_balance_log($uid,-format_decimal($postdata['money']),1,2,'店铺提现');//减余额
				shop_balance_log($uid,format_decimal($postdata['money']),4,2,'店铺提现');//加冻结资金
				$return['status']=1;
				$return['info']='申请成功!';
				action_log('shop_get_money', 'Shop', $result, $uid);//申请提现日志
			}else{
				$return['info']='申请失败!';
			}
        }
		unset($postdata);
        return $return;
    }
	
    public function recharge($postdata){
		$return=array('status'=>0,'info'=>'');
		$type=$postdata['type'];//2会员充值，5店铺充值
		if($type==2){
			$member_info=checkuserauthtype();
			$uid=$member_info['id'];
			if(!$uid){$return['info']='登录信息错误';return $return;}
		}elseif($type==5){
			$member_info=session('shop_info');
			$uid=$member_info['id'];
			if(!$uid){$return['info']='登录信息错误';return $return;}
		}else{
			$return['info']='参数错误';return $return;
		}
		
        if(empty($postdata['paytype'])){$return['info']='请选择支付方式！';return $return;}
		if(empty($postdata['money'])){$return['info']='充值金额不能为空！';return $return;}
        if((float)$postdata['money']<(float)0){$return['info']='请正确填写充值金额';return $return;}
        $pay_info=M('Payment')->where("status=1 and id='".$postdata['paytype']."'")->field('fee')->find();
		if((float)$pay_info['fee']>(float)0)$pay_fee = getfeemoney($postdata['money'],$pay_info['fee'],0);
		
		$pay_fee = isset($pay_fee)?$pay_fee:0;
		$date['order_sn'] = createOrderNo();
		$date['type'] = $type;
		$date['uid'] = $uid;
		$date['payment_id'] = $postdata['paytype'];
		$date['pay_code'] = idtoname($postdata['paytype'],'Payment','code');
		$date['pay_fee'] = $pay_fee;
		$date['order_amount'] = $postdata['money'];
		$date['addtime'] = NOW_TIME;
		$date['confirm_time'] = NOW_TIME;
		$date['pay_status'] = 1;
		$date['status'] = 2;
		$order_id =M('OrderInfo')->add($date);
		
		if($order_id !== false){
			$map_log['user_id'] = $uid;
			$map_log['type'] = $type;
			$map_log['order_id'] = ','.$order_id.',';
			$map_log['order_sn'] = $date['order_sn'];
			$map_log['need_pay'] =$date['order_amount'];
			$map_log['pay_code'] = $date['pay_code'];
			$map_log['payment_id'] = $postdata['paytype'];
			$map_log['is_paid'] = 0;
			$map_log['create_time'] = NOW_TIME;
			$pay_log = M('PayLog')->add($map_log);
		}
		if($pay_log !== false){
			$return['status']=1;
			$return['log_id']=$pay_log;
			$return['info']='提交成功！';
			if($type==2){
				action_log('user_recharge', 'Member', $order_id, $uid);//充值日志
			}else{
				action_log('shop_recharge', 'Shop', $order_id, $uid);//充值日志
			}
		}else{
			$return['info']='提交失败！';
		}
		unset($postdata);
        return $return;
    }
}
?>