<?php
/**
 * 权限控制类
 * @Copyright (C) 2016 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */

namespace Common\Vendor;
class Auth{
    //默认配置
    protected $_config = array(
        'AUTH_ON'           => true,                      // 认证开关
        'AUTH_TYPE'         => 1,                         // 认证方式，1为实时认证；2为登录认证。
        'AUTH_GROUP'        => 'auth_group',        // 用户组数据表名
        'AUTH_GROUP_ACCESS' => 'auth_group_access', // 用户-用户组关系表
        'AUTH_RULE'         => 'auth_rule',         // 权限规则表
        'AUTH_USER'         => 'member'             // 用户信息表
    );
    public function __construct() {
        $prefix = C('DB_PREFIX');
        $this->_config['AUTH_GROUP'] = $prefix.$this->_config['AUTH_GROUP'];
        $this->_config['AUTH_RULE'] = $prefix.$this->_config['AUTH_RULE'];
        $this->_config['AUTH_USER'] = $prefix.$this->_config['AUTH_USER'];
        $this->_config['AUTH_GROUP_ACCESS'] = $prefix.$this->_config['AUTH_GROUP_ACCESS'];
        if (C('AUTH_CONFIG')) {
            //可设置配置项 AUTH_CONFIG, 此配置项为数组。
            $this->_config = array_merge($this->_config, strtoarray(C('AUTH_CONFIG')));
        }
    }
    /**
      * 检查权限
      * @param name string|array  需要验证的规则列表,支持逗号分隔的权限规则或索引数组
      * @param uid  int           认证用户的id
      * @param string mode        执行check的模式
      * @param relation string    如果为 'or' 表示满足任一条规则即通过验证;如果为 'and'则表示需满足所有规则才能通过验证
      * @return boolean           通过验证返回true;失败返回false
     */
    public function check($name, $uid, $type='', $mode='url', $relation='or') {
        if (!$this->_config['AUTH_ON']) return true;
        if(empty($type))$type='0,1,2,3';
        $cachename='getAuthList'.$name.$uid.$type.$mode.$relation;        
        $authList = $this->getAuthList($uid,$type,$cachename); //获取用户需要验证的所有有效规则列表
        if (is_string($name)) {
            $name = strtolower($name);
            if (strpos($name, ',') !== false) {$name = explode(',', $name);} else {$name = array($name);}
        }
        $list = array(); //保存验证通过的规则名
        if ($mode=='url') {$REQUEST = unserialize( strtolower(serialize($_REQUEST)) );}
        foreach ( $authList as $auth ) {
            $query = preg_replace('/^.+\?/U','',$auth);
            if ($mode=='url' && $query!=$auth ) {
                parse_str($query,$param); //解析规则中的param
                $intersect = array_intersect_assoc($REQUEST,$param);
                $auth = preg_replace('/\?.*$/U','',$auth);
                if ( in_array($auth,$name) && $intersect==$param ) {$list[] = $auth ;}  //如果节点相符且url参数满足
            }else if (in_array($auth , $name)){$list[] = $auth ;}
        }
        if ($relation == 'or' and !empty($list)) {return true;}
        $diff = array_diff($name, $list);
        if ($relation == 'and' and empty($diff)) {return true;}
        return false;
    }
    /**
     * 根据用户id获取用户组,返回值为数组
     * @param  uid int     用户id
     * @return array       用户所属的用户组 array(array('uid'=>'用户id','group_id'=>'用户组id','title'=>'用户组名称','rules'=>'用户组拥有的规则id,多个,号隔开'),
     *...)   
     */
    public function getGroups($uid) {
        static $groups = array();
        if (isset($groups[$uid]))
            return $groups[$uid];
        $user_groups = M()
            ->table($this->_config['AUTH_GROUP_ACCESS'] . ' a')
            ->where("a.uid='$uid' and g.status='1'")
            ->join($this->_config['AUTH_GROUP']." g on a.group_id=g.id")
            ->field('rules')->select();
        $groups[$uid]=$user_groups?:array();
        return $groups[$uid];
    }
    /**
     * 获得权限列表
     * @param integer $uid  用户id
     * @param integer $type 
     */
    protected function getAuthList($uid,$type,$cache=false) {
        if($cache){$cachecontent=S($cache);if($cachecontent)return $cachecontent;}
        $t = implode(',',(array)$type);
        //读取用户所属用户组
        $groups = $this->getGroups($uid);
        $ids = array();//保存用户所属用户组设置的所有权限规则id
        foreach ($groups as $g) {$ids = array_merge($ids, explode(',', trim($g['rules'], ',')));}
        $ids = array_unique($ids);
        if (empty($ids)) {return array();}
        $cacheauths=getcache('AuthRule');//读取用户组所有权限规则
        $authname=$authpubname=$authallrules=$pubauth=array();
        $contoller_name=strtolower(CONTROLLER_NAME);
        foreach($cacheauths as $k=>$v){
            $v['name']=strtolower($v['name']);
            $authname[]=$v['name'];//获取权限
            if($v['status']==1 && in_array($k,$ids)){
                if(!str_exists($v['name'],'publics/') && in_array($v['type'],explode(',',$type)))$rules[]=$v;//非公共权限
                if(str_exists($v['name'],'allrules'))$authallrules[]=str_replace('/allrules','',$v['name']);//任意权限
                if(str_exists($v['name'],'publics/'))$authpubname[]=$v['name'];//授权的公共权限
            }
        }
        $authname=array_unique($authname);
        $authpubname=array_unique($authpubname);
        if(!empty($authallrules) && in_array($contoller_name,$authallrules)){$thisauthname=$contoller_name.'/'.strtolower(ACTION_NAME);
            if(!in_array($thisauthname,$authname))$pubauth[]=$thisauthname;}//任意权限授权
        if(!empty($authpubname) && !in_array($contoller_name.'/allrules',$authname)){
            foreach($authpubname as $k=> $v){
                $thisauthname=str_replace('publics',$contoller_name,$v);
                if(!in_array($thisauthname,$authname)){$pubauth[]=$thisauthname;}
            }
        }
        $authList = $pubauth;
        foreach ($rules as $rule) {
            if (!empty($rule['condition'])) { //根据condition进行验证
                $user = $this->getUserInfo($uid);//获取用户信息,一维数组
                $command = preg_replace('/\{(\w*?)\}/', '$user[\'\\1\']', $rule['condition']);
                @(eval('$condition=(' . $command . ');'));
                if ($condition) {$authList[] = $rule['name'];}
            } else {$authList[] = $rule['name'];}//只要存在就记录
        }
        $authList=array_unique($authList);
        if($cache)S($cache,$authList);
        return $authList;
    }
    /**
     * 获得用户资料,根据自己的情况读取数据库
     */
    protected function getUserInfo($uid) {
        static $userinfo=array();
        if(!isset($userinfo[$uid])){
             $userinfo[$uid]=M()->where(array('id'=>$uid))->field(true)->table($this->_config['AUTH_USER'])->find();
        }return $userinfo[$uid];
    }
}