<?php
/**
 * 快递鸟查询类
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */
namespace Common\Vendor\Express;
class Kdniao{	
	/**
	 * API根路径
	 * @var string
     * 申请地址http://kdniao.com/reg
	 */
	protected $ApiBase = 'http://api.kdniao.cc/Ebusiness/EbusinessOrderHandle.aspx';    
    private $config;
    public function __construct($config) {
        $this->config = !empty($this->config) && !empty($config)? array_merge($this->config, $config):!empty($config)?$config:$this->config;
    }
	/**
     * 查询快递状态
     * @param string $express_num 快递订单号
     * @param string $express_com 快递公司编码
     * @return array | boolean
     */
    public function process($data){
		/* 点点网调用公共参数 */
		$data=$data[0];
        $type=$data['type'];//获取快递信息 0 json 1 url 2 html(url li))
        if(!is_numeric($type))$type=$this->config['gettype'];
        if($type==1){//url模式
            $url= $this->query_url($data['code'],$data['sn'],$data['temp']);
            if($url)return $url;else $type=2;
        }
        
        $requestData= "{'OrderCode':'','ShipperCode':'".$data['code']."','LogisticCode':'".$data['sn']."'}";	
    	$params = array(
            'EBusinessID' => $this->config['username'],
            'RequestType' => '1002',
            'RequestData' => urlencode($requestData) ,
            'DataType' => '2',
            'DataSign' =>$this->encrypt($requestData, $this->config['password'])
        );
		$data = curlget($this->ApiBase, $params,'POST');
        $result=json_decode($data, true);
        if($type==2){//html模式
            if(empty($data['class']))$data['class']='express_list';
            $html='<ul class="'.$data['class'].'">';
            if($result['Traces']){
                foreach($result['Traces'] as $v){
                    $html.='<li><span>'.$v['AcceptTime'].'</span>'.$v['AcceptStation'].'</li>';
                }
            }else{
                $html.='<li>'.($result['Reason']?$result['Reason']:'查询失败').'</li>';
            }            
            $html.='<li>查询数据由：'.$this->config['name'].' 网站提供</li>';
            $html.='</ul>';
            return $html;
        }else{//json 模式
            $return=array();            
            $array_state=array(2=>0,3=>3,4=>2);
            $list=array();
            foreach($result['Traces'] as $k=>$v){
                $list[$k]['time']=$v['AcceptTime'];
                $list[$k]['context']=$v['AcceptStation'];
            }
            if($result['Success']==1){
                $return['status']=1;
                $return['state']=$array_state[$result['State']];//0：在途1：揽件2：疑难3：签收4：退签5：派件6：退回
                $return['data']=$list;//time context
            }else{
                $return['status']=0;
                $return['msg']=$result['Reason']?$result['Reason']:'查询失败';
            }return $return;
        }
	}
	/**
     * 获取直接查询快递URL
     * @param string $code 快递订单号
     * @param string $sn 快递公司编码
     * $param string $temp 备用参数 手机页面点击"返回"跳转的地址
     * @return string
     */
    private function query_url($code,$sn,$temp=''){
        return false;
    }
    
    /**
     * 电商Sign签名生成
     * @param data 内容   
     * @param appkey Appkey
     * @return DataSign签名
     */
    private function encrypt($data, $appkey) {
        return urlencode(base64_encode(md5($data.$appkey)));
    }

    /**
      *获取快递公司编号
      */
	public function com_url(){
		return "http://www.kdniao.com/file/ExpressCode.xls";
	}
}
?>