<?php
/**
 * 快递100查询类
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */
namespace Common\Vendor\Express;
class Kuaidi100{	
	/**
	 * API根路径
	 * @var string
	 */
	protected $ApiBase = 'http://api.kuaidi100.com/api';    
    private $config;
    public function __construct($config) {
        $this->config = !empty($this->config) && !empty($config)? array_merge($this->config, $config):!empty($config)?$config:$this->config;
    }
	/**
     * 查询快递状态
     * @param string $express_num 快递订单号
     * @param string $express_com 快递公司编码
     * @return array | boolean
     */
    public function process($data){
		/* 点点网调用公共参数 */
		$data=$data[0];
        $type=$data['type'];//获取快递信息 0 json 1 url 2 html(url li))
        if(!is_numeric($type))$type=$this->config['gettype'];
        if($type==1){//url模式
            $url= $this->query_url($data['code'],$data['sn'],$data['temp']);
            if($url)return $url;else $type=2;
        }
		$params = array(
			'id' =>$this->config['username'],
            'com'=>$data['code'],
            'nu' =>$data['sn'],
            'show'=>0,//返回类型：0：返回json字符串，1：返回xml对象，2：返回html对象，3：返回text文本。
            'muti'=>1,//返回信息数量：1:返回多行完整的信息，0:只返回一行信息。不填默认返回多行。
            'order'=>'asc',//排序：desc：按时间由新到旧排列，asc：按时间由旧到新排列。 
		);
		$data = curlget($this->ApiBase, $params);
        $result=json_decode($data, true);
        if($type==2){//html模式
            if(empty($data['class']))$data['class']='express_list';
            $html='<ul class="'.$data['class'].'">';
            if($result['data']){
            foreach($result['data'] as $v){
                $html.='<li><span>'.$v['time'].'</span>'.$v['context'].'</li>';
            }}else{
                $html.='<li>'.($result['message']?$result['message']:'查询失败').'</li>';
            }
            $html.='<li>查询数据由：'.$this->config['name'].' 网站提供</li>';
            $html.='</ul>';
            return $html;
        }else{//json 模式
            $return=array();
            if($result['status']==1){
                $return['status']=1;
                $return['state']=$result['state'];//0：在途1：揽件2：疑难3：签收4：退签5：派件6：退回
                $return['data']=$result['data'];//time context
            }else{
                $return['status']=0;
                $return['msg']=$result['message']?$result['message']:'查询失败';
            }return $return;
        }
	}
	/**
     * 获取直接查询快递URL
     * @param string $code 快递订单号
     * @param string $sn 快递公司编码
     * $param string $temp 备用参数 手机页面点击"返回"跳转的地址
     * @return string
     */
    private function query_url($code,$sn,$temp=''){
        if(empty($code) || empty($sn))return false;
        if(is_mobile()){
            $url="https://m.kuaidi100.com/index_all.html?type=".$code."&postid=".$sn;
            if($temp)$url.="&callbackurl=".$temp;
        }else{
            $url="https://www.kuaidi100.com/chaxun?com=".$code."&nu=".$sn;
        }
        return $url;
    }
    /**
      *获取快递公司编号
      */
	public function com_url(){
		return "https://www.kuaidi100.com/download/api_kuaidi100_com(20140729).doc";
	}
}
?>