<?php

/* *

 * 类名：AlipaySubmit

 * 功能：支付宝各接口请求提交类

 * 详细：构造支付宝各接口表单HTML文本，获取远程HTTP数据

 * 版本：3.3

 * 日期：2012-07-23

 * 说明：

 * 以下代码只是为了方便商户测试而提供的样例代码，商户可以根据自己网站的需要，按照技术文档编写,并非一定要使用该代码。

 * 该代码仅供学习和研究支付宝接口使用，只是提供一个参考。

 */
namespace Common\Vendor\Pay\Driver\Alipay;



class AlipayRefundSubmit {



	private $alipay_config;

	/**

	 *支付宝网关地址

	 */

	private $alipay_gateway_new = 'https://mapi.alipay.com/gateway.do?';
   

	//var $alipay_gateway_new = 'http://wappaygw.alipay.com/service/rest.htm?';



	function __construct($alipay_config){

		$this->alipay_config = $alipay_config;

	}

    function AlipaySubmit($alipay_config) {

    	$this->__construct($alipay_config);

    }

	private function createLinkstring($para) {
	$arg  = "";
	while (list ($key, $val) = each ($para)) {
		$arg.=$key."=".$val."&";
	}
	//去掉最后一个&字符
	$arg = substr($arg,0,count($arg)-2);
	//如果存在转义字符，那么去掉转义
	if(get_magic_quotes_gpc()){$arg = stripslashes($arg);}
	
	return $arg;
}

	/**

	 * 生成签名结果

	 * @param $para_sort 已排序要签名的数组

	 * return 签名结果字符串

	 */

	private function buildRequestMysign($para_sort,$sign_type='MD5') {

		//把数组所有元素，按照“参数=参数值”的模式用“&”字符拼接成字符串	
		$prestr = $this->createLinkstring($para_sort);

		$mysign = "";

		switch (strtoupper(trim($sign_type))) {

			case "MD5" :

				$mysign = md5($prestr.$this->alipay_config['config_key']);

				break;

			case "RSA" :

				$mysign = rsaSign($prestr, $this->alipay_config['private_key_path']);

				break;

			case "0001" :

				$mysign = rsaSign($prestr, $this->alipay_config['private_key_path']);

				break;

			default :

				$mysign = "";
		}
		return $mysign;
	}


	/**

     * 生成要请求给支付宝的参数数组

     * @param $para_temp 请求前的参数数组

     * @return 要请求的参数数组

     */
	private function buildRequestPara($para_temp) {
		$sign_type = $para_temp['sign_type'];
		unset($para_temp['sign'],$para_temp['sign_type']);
		ksort($para_temp);
		reset($para_temp);
		//生成签名结果
		$para_sort =$para_temp;
		$mysign = $this->buildRequestMysign($para_sort,$sign_type);

		//签名结果与签名方式加入请求提交参数组中

		$para_sort['sign'] = $mysign;

		if($para_sort['service'] != 'alipay.wap.trade.create.direct' && $para_sort['service'] != 'alipay.wap.auth.authAndExecute') {
			$para_sort['sign_type'] = strtoupper(trim($sign_type));
		}
		return $para_sort;

	}


    /**

     * 建立请求，以表单HTML形式构造（默认）

     * @param $para_temp 请求参数数组

     * @param $method 提交方式。两个值可选：post、get

     * @param $button_name 确认按钮显示文字

     * @return 提交表单HTML文本

     */

	public function buildRequestForm($para_temp, $method, $button_name) {
		//待请求参数数组
		$para = $this->buildRequestPara($para_temp);
		$sHtml = "<form id='alipaysubmit' name='alipaysubmit' action='".$this->alipay_gateway_new."_input_charset=".trim(strtolower('utf-8'))."' target='blank' method='".$method."'>";
		while (list ($key, $val) = each ($para)) {
            $sHtml.= "<input type='hidden' name='".$key."' value='".$val."'/>";
        }

		//submit按钮控件请不要含有name属性

        $sHtml = $sHtml."<div style='text-align:center'><input type='submit' class='hide' value='".$button_name."'></div></form>";
		$sHtml = $sHtml."<script>document.forms['alipaysubmit'].submit();</script>";

		return $sHtml;

	}



}

?>