<?php
/**
 * 余额支付
 * @Copyright (C) 2016 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */

namespace Common\Vendor\Pay\Driver;
class Hanchao extends \Common\Vendor\Pay\Pay {
    protected $config = array('status' => '');
    public function check() {
        if (!$this->config['status']) {
            E("余额支付设置有误！");
        }return true;
    }
    public function buildRequestForm(\Common\Vendor\Pay\PayVo $vo) {
        $memberinfo=session('member_info');
        $membermoney=idtoname($memberinfo['id'],"Member",'money','id',false);
        $needpay=$vo->getFee();
        if($membermoney<$needpay)E('账户余额不足');
        $backurl=$this->config['notify_url']."?total_fee=".$needpay."&method=return&out_trade_no=".$vo->getOrderNo();        
        $sHtml='<script>location.href="'.$backurl.'"</script>';
        echo $sHtml;exit;
    }
    public function get_pay_code($info='')
	{
        $memberinfo=session('member_info');
        $membermoney=idtoname($memberinfo['id'],"Member",'money','id',false);
		if(empty($info))$info=$this->config;
        if($info && $membermoney>0)
		{
			$html = "<div style='margin: 10px 0px;color: #777; clear: both;'><input type='checkbox' name='paytype' value='".$info['id']."' class='check_box_h' id='all_use_money'>&nbsp;使用余额支付，账户余额：<em>{$membermoney}</em></div>";
			if($info['logo']!='')$html .= "<div style='float:left; padding-left:10px;'><img src='".$info['logo']."' /></div>";
			$html .= "<div style='float:left; padding-left:10px;'>".h($info['content'])."</div>";
			return $html;
		}else{return '';}
	}
    /**
     * 针对notify_url验证消息是否是合法消息
     * @return 验证结果
     */
    public function verifyNotify($notify) {
        $this->setInfo($notify);
        return true;
    }    
    protected function setInfo($notify) {
        $info = array();
        //支付状态
        $info['status'] = true;
        $info['money'] = 0.00;
        $info['out_trade_no'] = $notify['out_trade_no'];
        $this->info = $info;
    }
}
?>