<?php
/**
 * 订单数据模型
 */
namespace Common\Vendor\Pay;
class PayVo {
    protected $_orderNo;
    protected $_fee;
    protected $_title;
    protected $_body;
    protected $_callback;
    protected $_url;
    protected $_param;
	protected $_product_id;
    /**
     * 设置订单号
     * @param type $order_no
     */
    public function setOrderNo($order_no) {
        $this->_orderNo = $order_no;
        return $this;
    }
    /**
     * 设置价格
     * @param type $fee
     */
    public function setFee($fee) {
        $this->_fee = $fee;
        return $this;
    }
    /**
     * 设置名称
     * @param type $title
     */
    public function setTitle($title) {
        $this->_title = $title;
        return $this;
    }
    /**
     * 设置描述
     * @param type $body
     */
    public function setBody($body) {
        $this->_body = $body;
        return $this;
    }
    /**
     * 设置支付完成后的后续操作接口
     * @param type $callback
     */
    public function setCallback($callback) {
        $this->_callback = $callback;
        return $this;
    }
    /**
     * 设置支付完成后的跳转地址
     * @param type $url
     */
    public function setUrl($url) {
        $this->_url = $url;
        return $this;
    }
    /**
     * 设置订单的额外参数
     * @param type $param
     */
    public function setParam($param) {
        $this->_param = $param;
        return $this;
    }
	/**
	* 设置trade_type=NATIVE，此参数必传。此id为二维码中包含的商品ID，店铺自行定义。
	* @param string $value 
	**/
	public function setProduct_id($value)
	{
		$this->_product_id = $value;
	}
    /**
     * 获取订单号
     * @return type
     */
    public function getOrderNo() {
        return $this->_orderNo;
    }
    /**
     * 获取价格
     * @return type
     */
    public function getFee() {
        return $this->_fee;
    }
    /**
     * 获取名称
     * @return type
     */
    public function getTitle() {
        return $this->_title;
    }
    /**
     * 获取支付完成后的后续操作接口
     * @return type
     */
    public function getCallback() {
        return $this->_callback;
    }
    /**
     * 获取支付完成后的跳转地址
     * @return type
     */
    public function getUrl() {
        return $this->_url;
    }
    /**
     * 获取描述
     * @return type
     */
    public function getBody() {
        return $this->_body;
    }
    /**
     * 获取订单的额外参数
     * @return type
     */
    public function getParam() {
        return $this->_param;
    }
	/**
	* 获取trade_type=NATIVE，此参数必传。此id为二维码中包含的商品ID，店铺自行定义。的值
	* @return 值
	**/
	public function getProduct_id()
	{
		return $this->_product_id;
	}
}