<?php
namespace Common\Vendor\sdk;
use Common\Vendor\ThinkOauth;
class WeixinSDK extends ThinkOauth {
    /**
     * 获取requestCode的api接口
     * @var string
     */
    protected $GetRequestCodeURL = 'https://open.weixin.qq.com/connect/qrconnect';
    /**
     * 获取access_token的api接口
     * @var string
     */
    protected $GetAccessTokenURL = 'https://api.weixin.qq.com/sns/oauth2/access_token';
    /**
     * API根路径
     * @var string
     */
    protected $ApiBase = 'https://api.weixin.qq.com/';/**
     * Callback回调地址
     * @var string
     */
    //protected $Callback ='http://192.168.1.127/hctemplate/index.php?s=Member/Oauth/callback';
	
    public function getRequestCodeURL()
    {
        $this->config();
        $params = array(
                'appid' => $this->AppKey,          
                'redirect_uri'=>$this->Callback,
                'response_type'=>'code',
                'scope'=>'snsapi_login'
        );
        return $this->GetRequestCodeURL . '?' . http_build_query($params).'#wechat_redirect';
		
    }
    public function getRequestCode($id='login_container'){
        $str='<script src="http://res.wx.qq.com/connect/zh_CN/htmledition/js/wxLogin.js"></script>';
        $str.='<script type="text/javascript">';
        $str.='var obj = new WxLogin({';
        $str.='id:"'.$id.'",';
        $str.='appid: "'.$this->AppKey.'",';
        $str.='scope: "snsapi_login",';
        $str.='redirect_uri: "'.$this->Callback.'",';
        $str.='state: "state",';
        $str.='style: "",';
        $str.='href: ""';
        $str.='});';
        $str.='</script>';
    }
    /**
     * 获取access_token
     * @param string $code 上一步请求到的code
     */
    public function getAccessToken($code, $extend = null){
        $this->config();
        $params = array(
                'appid'     => $this->AppKey,
                'secret'    => $this->AppSecret,
                'grant_type'    => $this->GrantType,
                'code'          => $code,
        );
        $data = $this->http($this->GetAccessTokenURL, $params, 'POST');
        //return $data;
        $this->Token = $this->parseToken($data, $extend);
        return $this->Token;
    }
    /**
     * 组装接口调用参数 并调用接口
     * @param  string $api    微信API
     * @param  string $param  调用API的额外参数
     * @param  string $method HTTP请求方法 默认为GET
     * @return json
     */
    public function call($api, $param = '', $method = 'GET', $multi = false){
        /* 微信调用公共参数 */
        $params = array(
            'access_token'       => $this->Token['access_token'],
            'openid'             => $this->openid(),
        );
        $vars = $this->param($params, $param);
        $data = $this->http($this->url($api), $vars, $method, array(), $multi);
        return json_decode($data, true);
    }
    /**
     * 解析access_token方法请求后的返回值
     */
    protected function parseToken($result, $extend)
    {
        $data = json_decode($result,true);
        
        //parse_str($result, $data);
        if($data['access_token'] && $data['expires_in']){
            $this->Token    = $data;
            $data['openid'] = $this->openid();
            return $data;
        } else
            throw new Exception("获取微信 ACCESS_TOKEN 出错：{$result}");
    }
    /**
     * 获取当前授权应用的openid
     */
    public function openid()
    {
        $data = $this->Token;
        if(!empty($data['openid']))
            return $data['openid'];
        else
            exit('没有获取到微信用户ID！');
    }
}
?>