<?php
/**
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */

namespace Home\Controller;
use Think\Controller;
class GoodsController extends BaseController {
    public function index(){
        $goods_id=I('id');
        //获取商品基本信息
        $goods_info=D("Common/Goods")->get_goods_item($goods_id);
         //分销
        $member=session('member_info');
        $is_fx = is_fx($member['id']);
        $this->assign('is_fx',$is_fx); //获取当前会员是不是分销商

        $newval = (C('COMMISSION'));
        $this->assign('newval',$newval);//获取是否开启佣金显示
         //生成二维码链接
        $url = U('Mobile/Goods/goods_cont',array('id'=>$goods_id,'eid'=>$member['id']),true,true);
        $img_url = U('Home/qrcode/index',array('data'=>urlencode($url),'size'=>4));
        $this->assign('img_url',$img_url);
        //三级佣金显示
        $pro = unserialize((C('AFFILIATE')));
        $proone = $pro['item'][1]['level_money'];
        $protwo = $pro['item'][2]['level_money'];
        $prothree = $pro['item'][3]['level_money'];
        $supply_price = substr($goods_info['data']['supply_price'],3);
        if($goods_info['data']['is_promote']==1 && $goods_info['data']['promote_price']>0){
            $promote_price = $goods_info['data']['promote_price'];
        }else{
            $promote_price = substr($goods_info['data']['shop_price'],3);
        }
        $newdata['brokerone'] = intval($promote_price-$supply_price)*intval($proone)*0.01;
        $newdata['brokertwo']  = intval($promote_price-$supply_price)*intval($protwo)*0.01;
        $newdata['brokerthree']  = intval($promote_price-$supply_price)*intval($prothree)*0.01;
        if($newdata['brokerone']>0 && $newdata['brokertwo'] >0 &&$newdata['brokerthree']>0)
        {
            $this->assign('newdata',$newdata);
        }
        $w_url =geturl('Home/Goods/index',array('id'=>$goods_id,'eid'=>$member['id']),true,true);
        $this->assign('w_url',$w_url);
        if($goods_info['status']){
            $historyids=session('historyids');
            $historyids=empty($historyids)?array():$historyids;
            $historyids[]=$goods_id;
            $historyids=array_unique($historyids);
            session('historyids',$historyids);
            $i=1;$goods_imgs=array();
            $goods_imgs[0]['goods_img'] = $goods_info['data']['img'];
            $goods_images = M("GoodsGallery")->where("goods_id=" . $goods_id)->select();
            foreach($goods_images as $val){
                $goods_imgs[$i]=$val;
                $i++;
            }
            //获取商品属性和规格
            $data = D("Common/GoodsAttr")->getattr($goods_id);
            //判断该地区是否有货
            if(cookie('dingwei_address')){
                $address_info= cookie('dingwei_address');
            }elseif(session('dingwei_address')){
                $address_info= session('dingwei_address');
            }
            if($address_info['district']){
                $area_id=$address_info['district'];
            }else{
                $area_id=$address_info['city'];
            }
            $root=D("Common/Cart")->get_area_fee($goods_info['data']['shop_id'],$area_id);
            $price_info=D("Common/Cart")->getminprice($goods_id);//print_r($price_info);//print_r($goods_info['data']);
            //print_r($price_info);
            $this->assign($data);
            $this->assign('price_info',$price_info);
            $this->assign("is_stock",$root['is_stock']);
            $this->assign('attr_list', $data['newarr']);//属性
            $this->assign('goods_info', $goods_info['data']);//商品信息
            $this->assign('goods_imgs', $goods_imgs);//商品相册

        }else{
            $this->error($goods_info['msg'],U($goods_info['url']));
        }
        $seodata=D('Common/Goods')->format_contseotitle($goods_info['data']);
        $this->assign($seodata);
        $this->display();
    }
    
    public function ajax_active(){
        $goods_id=I('goods_id');
        $shop_price=I('shop_price');
        $activelist=D("Common/Promot")->goods_to_promot($goods_id,1);
        //判断是否有限时促销
        $active=$promotion=array();
        foreach($activelist['list'] as $key=>$val){
            if($val['style']==5){
                $active[]=$val;
                unset($activelist['list'][$key]);
            }
        }
        if($active){
            foreach($active as $k=>$v){
                if($k==count($active)-1){
                    $remarks=unserialize($v['remarks']);
                    $v['remarks']=format_decimal($remarks['promot_price'][$goods_id]);
                    $promotion=$v;
                }
            }
        }
        //优惠券
        $ecv_list=D("Common/Promot")->goods_to_ticket($goods_id,idtoname($goods_id,'Goods','shop_id'));
        //会员红包
        $member=session("member_info");
        if($member){
            $bonus_map['user_id']=$member['id'];
            $memberbonus=M("MemberBonus")->where($bonus_map)->getField('bonus_id',true);
        }

        $promotion_remarks=$promotion['remarks'];
        $return['promotion_end_time']=$promotion['end_time'];//限时促销
        $return['promotion_remarks'] = empty($promotion_remarks)?$promotion_remarks=0:$promotion_remarks;//限时促销
        $price_info=D("Common/Cart")->getminprice($goods_id);
        $return['price_type']=$price_info['type'];
        $View= new \Common\Vendor\TplView();
        $View->assign('activelist',$activelist);//活动
        $View->assign('ecv_list',$ecv_list);//优惠券
        $View->assign('memberbonus',$memberbonus);//会员红包
        $View->assign('promotion',$promotion);//限时促销
        $View->assign('price_type',$price_info['type']);//限时促销
        $return['html']=$View->fetch('pro_act');
        $this->ajaxReturn($return);
    }

    
    public function ajax_data(){
        $collect['goods_id']=I('goods_id');
        $collect['type']=I('type');
        $return['collect_info']=$this->ajax_is_collect($collect);
        $shop['shop_id']=I('shop_id');
        $shop['goods_shop_catid']=I('goods_shop_catid');
        $return['shop_info']=$this->ajax_shop_info($shop);
        $this->ajaxReturn($return);
    }

    
    public function ajax_is_collect($collect){
        $goods_id=$collect['goods_id'];
        $type=$collect['type'];
        $is_collect = D('Common/Goods')->is_collect($goods_id,$type);
        $data['is_collect'] = $is_collect;
        return $data;
    }

    
    public function ajax_shop_info($data){
        $return=array();$return['status']=0;
        $shop_id=$data['shop_id'];$shop_cat_id=$data['goods_shop_catid'];
        $member=session('member_info');
        $shop=D("Common/Shops")->get_shop($shop_id,$member['id']);
        if($shop['status']==0)return $return;
        $return['status']=1;
        $this->assign('data',$shop['data']);
        $shop_info_html = $this->fetch("ajax_shop_info");
        $return['shop_info_html'] = $shop_info_html;
        if(!empty($shop['data']['cates'])) {
            $this->assign('cate', $shop['data']['cates']);
            $this->assign('shop_cat_id',$shop_cat_id);
            $shop_cat_html = $this->fetch("ajax_shop_cat");
            $return['shop_cat_html'] = $shop_cat_html;
        }
        return $return;
    }

    
    public function ajax_pinglun(){
        $goods_id=I('goods_id');
        $type=I('type');
        $p=I('p');
        $model=D("Common/GoodsAttr");
        $dp_data=M("Goods")->where("id=".$goods_id)->field('dp_count,avg_score,dp_count_1,dp_count_2,dp_count_3,dp_count_4,dp_count_5')->find();
        $lists=$model->comment_list($goods_id,$type,$p);
        foreach ($lists['info']['list'] as $k => $v) {
            if(!empty($v['img']))
            {
                $lists['info']['list'][$k]['img']=unserialize($v['img']);
            }
        }
        $avg_score_width=$dp_data['avg_score']*20;
        $dp_count_one_width=$dp_data['dp_count_1']/$dp_data['dp_count']*100;
        $dp_count_two_width=$dp_data['dp_count_2']/$dp_data['dp_count']*100;
        $dp_count_three_width=$dp_data['dp_count_3']/$dp_data['dp_count']*100;
        $dp_count_four_width=$dp_data['dp_count_4']/$dp_data['dp_count']*100;
        $dp_count_five_width=$dp_data['dp_count_5']/$dp_data['dp_count']*100;
        $this->assign('avg_score_width',$avg_score_width);
        $this->assign('dp_count_one_width',$dp_count_one_width);
        $this->assign('dp_count_two_width',$dp_count_two_width);
        $this->assign('dp_count_three_width',$dp_count_three_width);
        $this->assign('dp_count_four_width',$dp_count_four_width);
        $this->assign('dp_count_five_width',$dp_count_five_width);
        $this->assign('type',$type);
        $this->assign('dp_data',$dp_data);
        $this->assign('pinglun_list',$lists['info']);
        $content = $this->fetch("goods_pinglun");
       // $data['html'] = format_js($content);
        $data['html'] = $content;
        $this->ajaxReturn($data);
    }

    
    public function get_ecv(){
        $bouns_id=I('id');
        $data=D("Common/Promot")->member_get_bonus($bouns_id);
        $this->ajaxReturn($data);
    }

    
    public function addcart(){
        $goods_id=I('goods_id');
        $goods_attr=I('goods_attr');
        $number=I('number');
        $name=I('name');
        $act=I('act');
        $type=I('type');
        if($type>0){
            $member_info = session('member_info');
            if(empty($member_info)){
                $ret['msg'] = '请先登录';
                $ret['status']=0;
                $ret['url'] = getjumpurl('JUMP_1');
                $this->ajaxReturn($ret);
            }
        }
        $model=D("Common/Cart");
        $return=$model->add_carts($goods_id,$goods_attr,$number,$name,$act,$type);
        $this->ajaxReturn($return);
    }

    
    public function goods_attrs(){
        $goods_id=I('goods_id');
        $number=I('number');
        if(!$goods_id){
            $result['status']=1;
            $result['msg']='参数错误';
        }
        //获取商品属性和规格
        $data = D("Common/GoodsAttr")->getattr($goods_id);
        $goods_info=D("Common/Goods")->get_goods_item($goods_id);
        //活动
        $activelist=D("Common/Promot")->goods_to_promot($goods_id,1);
        //判断是否有限时促销
        $active=array();
        foreach($activelist['list'] as $k=>$val){
            if($val['style']==5){
                $active[]=$val;
            }
        }
        if($active){
            foreach($active as $k=>$v){
                if($k==count($active)-1){
                    if(!empty($v['remarks']))$remarksarr=unserialize($v['remarks']);
                    $v['remarks']=empty($v['remarks'])?$v['remarks']=0:format_decimal($remarksarr['promot_price'][$goods_id],false,' ');
                    $promotion=$v;
                }
            }
        }
       if(empty($promotion)){$promotion=0;}
        $promotion_remarks=$promotion['remarks'];
        $member=session("member_info");
        if($member){
            $m_map['id']=$member['id'];
            $rank_id=M("Member")->where($m_map)->getField('rank_id');
            $r_map['id']=$rank_id;
            $rank=M("MemberRank")->where($r_map)->getField("goods_price");
            $member_price=format_price($goods_info['data']['shop_price']*$rank,false,' ');
        }
        $this->assign('combinationnum', $data['combinationnum']);
        $this->assign('combinationprice', $data['combinationprice']);
        $this->assign('combinationpricenum', $data['combinationpricenum']);
        $this->assign('combination', $data['combination']);
        $this->assign('attr_list', $data['newarr']);//属性
        $this->assign('activelist', $activelist);//活动
        $this->assign('promotion', $promotion);//活动
        $this->assign('promotion_remarks', empty($promotion_remarks)?$promotion_remarks=0:$promotion_remarks);//活动
        $this->assign('number', $number);//数量
        $this->assign('goods_id', $goods_id);//商品id
        $this->assign('goods_info', $goods_info['data']);//商品信息
        $this->assign('rank',empty($rank)?$rank=0:$rank);//会员价
        $this->display();
    }

    
    public function add_cartlist(){
        $goods_id=I('goods_id');
        $number=I('number');
        $act=I('act');
        $pre_id = idtoname($goods_id,'Goods','pre_id');
        if($pre_id > 0){
            $return['status'] = 4;
            $return['msg'] = '预售商品不能加入购物车';
            $this->ajaxReturn($return);
        }
        $pt_id = idtoname($goods_id,'Goods','pt_id');
        if($pt_id > 0){
            $return['status'] = 4;
            $return['msg'] = '拼团商品不能加入购物车';
            $this->ajaxReturn($return);
        }
        // print_r(I('post.'));exit;
        $model=D("Common/Cart");
        $return=$model->add_cartlist($goods_id,$number,$act);
        $this->ajaxReturn($return);
    }

    
    public function buy_now(){
        $return=I("get.");
        $goods_id=I('goods_id');
        $goods_attr=I('goods_attr');
        $number=I('number');
        $name=I('name');
        if(cookie('dingwei_address')){
            $address_info = cookie('dingwei_address');//获取定位信息
        }elseif(session('dingwei_address')){
            $address_info = session('dingwei_address');
        }
        if (empty($address_info)) {
            $return['status'] = 3;
            $return['msg'] = '请选择配送地区';
            $this->ajaxReturn($return);
        }
        $model=D("Common/Cart");
        $return_link=$model->check_cart($goods_id,$goods_attr,$number,$name);
        $return=array_merge($return,$return_link);
        $this->ajaxReturn($return);
    }
}
?>