<?php
/**
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */

namespace Home\Controller;
use Think\Controller;
class IntegralController extends BaseController {
    public function index(){
        $map=array();
        $join='';
        $order='';
        $param=I('param.');
        if(empty($param['cat_id']))$param['cat_id']=0;
        if(empty($param['brand_id']))$param['brand_id']=0;
        $p=$param['p'];
        $catid=$param['cat_id'];
        
        $orders=D('Common/Goods')->cate_order($param);
        
        //价格分级开始
        $price_list = get_price_map($catid,$param['price']);
        if(!empty($price_list['shop_price']))$map['shop_price']=$price_list['shop_price'];
        //价格分级结束
        
        $type_id=get_cate_type($catid);//类型ID
        $attr_list=D('Common/GoodsAttr')->get_attr($param,$type_id);
        if(!empty($attr_list)){
            $map['_string']=$attr_list['_string'];
        }
        //属性筛选结束
        //关键词筛选
        if(!empty($param['keyword']))$map['goods_name']=array('like','%'.$param['keyword'].'%');
        //分类筛选
        if(!empty($param['cat_id']))$map['cat_id']=$param['cat_id'];
        //品牌筛选
        if(!empty($param['brand_id']))$map['brand_id']=$param['brand_id'];
        //排序
        if($param[$param['order_name']]==1){$order_type='desc';
		}elseif($param[$param['order_name']]==2){$order_type='asc';}
        if(!empty($param['order_name']) && $order_type)$order=$param['order_name'].' '.$order_type;
        if(I('is_integral')){
            $goodslist=D('Common/GoodsIntegral')->get_integral_list($map,$join,$order,$p);
            $seodata=D('Common/Goods')->format_listseotile($param['brand_id'],$catid,1);
            $catpos_title='积分商城';
        }elseif(I('is_hot')){
            $map['is_hot']=1;
            $goodslist=D('Common/Goods')->get_goods_list('',$map,$join,$order,$p);
            $seodata=D('Common/Goods')->format_listseotile($param['brand_id'],$catid,0,0,1);
            $catpos_title='热销商品';
        }elseif(I('is_new')){
            $map['is_new']=1;
            $goodslist=D('Common/Goods')->get_goods_list('',$map,$join,$order,$p);
            $seodata=D('Common/Goods')->format_listseotile($param['brand_id'],$catid,0,1);
            $catpos_title='新品';
        }
        //分类
        $where['pid']=0;
        $where['status']=1;
        $cat_list=M('GoodsCategory')->where($where)->field('id,name')->select();
        $this->assign('cat_list',$cat_list);
        $this->assign('catpos_title',$catpos_title);
        $this->assign('pricelist', empty($price_list['pricelist'])?array():$price_list['pricelist']);
        $this->assign($goodslist);
        $this->assign('orders',$orders);
        $this->assign('type_id',$type_id);
        $this->assign($seodata);
        $this->assign('param',$param);
        $this->assign($param);
        $this->display();
    }
    public function cont(){
        $id = intval(I('get.id'));
        $info=D('Common/GoodsIntegral')->get_integral($id);
        //print_r($info);
        if($info['status']==0)$this->error($info['msg']);
        $goods_id=M('GoodsIntegral')->where('id='.$id)->getField('goods_id');
        //浏览历史
        $historyids=session('historyids');
        $historyids=empty($historyids)?array():$historyids;
        $historyids[]=$goods_id;
        $historyids=array_unique($historyids);
        session('historyids',$historyids);
        //获取商品属性和规格
        $data = D("Common/GoodsAttr")->getattr($goods_id);
        //判断该地区是否有货
        if(cookie('dingwei_address')){
            $address_info= cookie('dingwei_address');
        }elseif(session('dingwei_address')){
            $address_info= session('dingwei_address');
        }
        if($address_info['district']){
            $area_id=$address_info['district'];
        }else{
            $area_id=$address_info['city'];
        }
        $root=D("Common/Cart")->get_area_fee($info['data']['shop_id'],$area_id);
        $this->assign("is_stock",$root['is_stock']);
        //seo
        $seodata=D('Common/Goods')->format_contseotitle($info['data'],1);
        $catpos_title='积分商城';
        $this->assign('catpos_title',$catpos_title);
        $this->assign('goods_info',$info['data']);
        $this->assign($data);
        $this->assign('attr_list', $data['newarr']);//属性
        $this->assign('is_integral',I('is_integral'));
        $this->assign($seodata);
        $this->display();
    }
    
    public function favorite(){
        $goods_id=I('id');
        $type=I('type');
        $is_on=I('is_on');
        $data=D('Common/Goods')->favorite($goods_id,$type,$is_on);
        $this->ajaxReturn($data);
    }
    public function add_integra(){
        $goods_id=I('goods_id');
        $attr=I('goods_attr');
        $number=I('number');
        $name=I('name');
        $integra=I('integra');
        $result=D("Common/Cart")->add_integra_cart($goods_id,$number,$attr,$name,$integra);
      //  print_r($result);exit;
        $this->ajaxReturn($result);
    }
}