<?php
/**
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */
namespace Home\Controller;
use Think\Controller;
class IntroController extends BaseController {
	public function _initialize() {
        parent::_initialize();  //RBAC 验证接口初始化
        $this->contr=strtolower(ACTION_NAME);
        if(!method_exists($this,$this->contr)){$this->index();exit;}
    }
    public function index(){
		$id=I('id');
        if($this->contr!='index'){
            $info=idtoname($this->contr,'Intro','*','dirname');
        }
		if(empty($info) && !empty($id))$info=idtoname($id,'Intro','*');
		if(empty($info))$this->error('您查看的内容不存在');
		if(empty($info['content'])){
            $checkson=M('Intro')->where(array('pid'=>$info['id']))->count();
            if($checkson){$info=idtoname($id,'Intro','*','pid');}
        }
		$template= $this->gettemplate($info);
		
		$this->assign ($info);
        $this->assign ('catpos',$this->catpos($info));
        $this->introlist($info);

        $this->assign('tplseo_title',(empty($info['seotitle'])?$info['name']:$info['seotitle']).'_'.C('WEB_SITE_TITLE'));
        $this->assign('tplseo_keywords',empty($info['seokeywords'])?$info['name']:$info['seokeywords']);
        $this->assign('tplseo_description',empty($info['seodescription'])?$info['name']:$info['seodescription']);
		$this->display($template);
	}
	private function introlist($info){
        if(empty($info)){return false;}
        $cachename='introlist'.$info['id'];
        $introlist=S($cachename);
        if(empty($introlist)){            
            $checkson=M('Intro')->where(array('pid'=>$info['id']))->count();
            if($checkson)$pid=$info['id'];else $pid=$info['pid'];
            $pid_pid=idtoname($pid,'Intro','pid');
            $map['id|pid']=$pid;
            $introlist=M('Intro')->where($map)->field('content',true)->select();
        	$Tree = new \Common\Vendor\Tree();
            $Tree->init($introlist);
            $introlist = $Tree->get_tree_array($pid_pid);
            S($cachename,$introlist);
        }$this->assign ('introlist',$introlist);
    }
    private function catpos($info){
        if(empty($info)){return false;}
        $cachename='introcatpos'.$info['id'];
        $cachecontent=S($cachename);
        if($cachecontent)return $cachecontent;
        $symbol=' &gt; ';
    	$pos = '';
    	$arrparentid = getallparent($info['id'],$info['id'],'Intro');
        if(empty($arrparentid))return false;
        $arrparentid=explode(',',$arrparentid);asort($arrparentid);
        foreach($arrparentid as $v) {
            if(empty($v))continue;
            $introinfo=idtoname($v,'Intro','id,dirname,name');
            if(empty($introinfo))continue;
    		$url = !empty($introinfo['dirname'])?geturl("Intro/".$introinfo['dirname']):geturl("Intro/index",array('id'=>$v));
    		$pos .= '<a href="'.$url.'" title="'.$introinfo['name'].'">'.$introinfo['name'].'</a>'.$symbol;
    	}
        $pos=substr($pos,0,-strlen($symbol));
        S($cachename,$pos);
        return $pos;
    }
	private function gettemplate($info='',$type='show'){
        if(empty($type))$type='show';
        $tpl=$type;
        if(!empty($info['tplname']))$tpl=$info['tplname'];
        $tplfile=MODULE_PATH.C('DEFAULT_V_LAYER').'/'.C('DEFAULT_THEME').'/Intro/'.$tpl.'.html';
        if(!file_exists($tplfile)){$tpl=$type;}
        return $tpl;
    }

}
?>
