<?php
/**
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */
namespace Home\Controller;
use Think\Controller;
class OrderController extends BaseController {
    public function _initialize(){
        parent::_initialize ();
        if(!$this->member_info['id']){$this->redirect('Home/Login/index');}
    }
    public function index(){
        $user_info=idtoname($this->member_info['id'],'Member','*');
        $ids = I('ids');
        $goods_id=I("goods_id");
        $type=I("type");
        $data=I("get.");
        $addre_id=I("addre_id")?I("addre_id"):0;
        $this->assign('order_datas',json_encode($data));
        if($type==6 || $type==7){
            $buy_limit = M('PromotAct')->alias('a')->join('__PROMOT_EXT__ e on a.id=e.act_id')->where('e.style_ext_id='.$goods_id)->order('e.id desc')->getField('buy_limit');
            if($data['number'] > $buy_limit && $buy_limit > 0){
                if($type == 6){
                    $this->error('按拼团价格买每人限购'.$buy_limit.'件，不得超过数量限制');
                }else{
                    $this->error('每人限购'.$buy_limit.'件，不得超过数量限制');
                }
            }
            $now_time = NOW_TIME;
            $end_time = M('PromotAct')->alias('a')->join('__PROMOT_EXT__ e on a.id=e.act_id')->where('e.style_ext_id='.$goods_id)->order('e.id desc')->getField('end_time');
            if($end_time<$now){
                if($type == 6){
                    $this->error('该团已过期，不能购买此商品');
                }else{
                    $this->error('活动已过期，不能购买此商品');
                }
            }
        }
        $result = D('Common/OrderInfo')->order_list($ids,$goods_id,$type,$addre_id);//获取订单信息
        
        if($result['data']['status']<=0){
            $this->error($result['data']['msg']);
        }
        if(empty($result['data']['list'])){
            $this->redirect('Home/Index/index');
        }
        $shop_goods=$result['data']['shopgoods'];
        foreach($shop_goods as $key=>$val){
            if($key>0){
                foreach($val['goods_ids'] as $kk=>$v){
                    $map['id']=$v;
                    $goods_info=M("Goods")->where($map)->field('goods_name,img')->find();
                    $goods[$kk]['goods_id']=$v;
                    $goods[$kk]['goods_name']=$goods_info['goods_name'];
                    $goods[$kk]['goods_img']=$goods_info['img'];
                }
                $shop_goodsinfo[$key]=$goods;

            }
        }
       //print_r($result);exit;
        $this->assign($result);
        $this->assign('shop_goods',$shop_goodsinfo);
        $this->assign('member_info',$user_info);
		$this->assign('type',$type);
        $this->assign('ids',$ids);
        $this->assign('addre_id',$addre_id);
        $this->assign('tplseo_title','订单提交_'.C('WEB_SITE_TITLE'));
        $this->display();
    }
	//添加,修改收货地址
	public function modify_address(){
		$param = I('param.');
		$result = D('Common/Member')->modify_address($param);
		$this->ajaxReturn($result);
	}
	//收货地址
	public function address(){
		$id=I('id');
		if($id>0){
			$address=M('MemberAddress')->where('id='.$id)->find();
			$this->assign('address',$address);
		}
		$this->assign('title',I('title'));
        $this->assign('tplseo_title','收货地址_'.C('WEB_SITE_TITLE'));
		$this->display();
	}
	//计算订单详细列表
	public function count_total(){
		$return=array();
		$param = I('param.');
		$cart_ids=I('ids');
		$data=I('order_info');
		$payment_id=I('payment_id');
		$delivery_id=I('addr_id');
		$score=I('score')?1:0;
        $bonus=I('bouns');
        $shop_id=I('shop_id');
        $bonu=array_combine($shop_id,$bonus);
		$use_account=I('use_account')?1:0;
		$account_money=I('account_money');
		$type=I('type');

		$result = D('Common/OrderInfo')->count_total($cart_ids,$data,$type,$bonu,$score,$use_account,$account_money,$payment_id,$delivery_id);
        //print_r($result);exit;
		$this->assign($result['total_info']);
		$html=$this->fetch('cart_total');
		$return['html']=$html;
		$return['total_info']=$result['total_info'];
		//print_r($result);
		$this->ajaxReturn($return);
	}

    
    public function sub_order(){
        $cart_ids=I('ids');
        $param = I('post.');
        $param['data']=I("order_info");
        $bonus=I('bouns');
        $shop_id=I('shop_id');
        $param['boun']=array_combine($shop_id,$bonus);
       // print_r($param);exit;
        $result= D("Common/OrderInfo")->sub_order($param);
      // print_r($result);
        $this->ajaxReturn($result);

    }

    
    public function continu_pay(){
        $type=I("type");
        $pay_id=I('pay_id');
        if($type>0){
            $map['id']=$pay_id;
            $order_ids=M("PayLog")->where($map)->getField('order_id');
            $order_id=explode(',',$order_ids);
        }else{
            $order_id=I("order_id");
        }
        $res=D("Common/OrderInfo")->continu_pay($order_id);
        $this->ajaxReturn($res);
    }

    
    public function continue_payhtml(){
        $order_id=I("order_id");
        if(empty($order_id)){
            $this->error("参数错误",U("Member/OrderInfo/index"));
        }
        $where['id']=array("in",$order_id);
        $order_info=M("OrderInfo")->where($where)->field(true)->select();
        foreach($order_info as $key=>$val){
            $g_map['order_id']=$val['id'];
            $order_info[$key]['goods_list']=M("OrderGoods")->where($g_map)->field('goods_id,goods_name,goods_number,goods_price,goods_attr,goods_integral')->select();
            if($order_info[$key]['goods_list']){
                foreach($order_info[$key]['goods_list'] as $gk=>$gv){
                    $order_info[$key]['goods_list'][$gk]['format_goods_attr']=unserialize($gv['goods_attr']);
                    $map['id']=$gv['goods_id'];
                    $goods_info=M("Goods")->where($map)->Field('goods_weight,img')->find();
                    $order_info[$key]['goods_list'][$gk]['img']=$goods_info['img'];
                    $order_info[$key]['goods_list'][$gk]['goods_weight']=$goods_info['goods_weight'];
                    if($val['type']==3){
                        $is_addcart=3;
                        $order_info[$key]['goods_list'][$gk]['goods_total_price'] =format_price($gv['goods_price'] * $gv['goods_number'])." + ".$gv['goods_integral']*$gv['goods_number']."分";
                    }else if($val['type'] == 6){
                        $is_addcart=6;
                        $order_info[$key]['goods_list'][$gk]['goods_total_price'] = format_decimal($gv['goods_price'] * $gv['goods_number']);
                    }else if($val['type'] == 7){
                        $is_addcart=7;
                        $order_info[$key]['goods_list'][$gk]['goods_total_price'] = format_decimal($gv['goods_price'] * $gv['goods_number']);
                    }else {
                        $is_addcart=1;
                        $order_info[$key]['goods_list'][$gk]['goods_total_price'] = format_decimal($gv['goods_price'] * $gv['goods_number']);
                    }
                    
                }
            }
        }
        $this->assign('order_info',$order_info);
        $this->assign('order_id',$order_id);
        $this->assign('is_addcart',$is_addcart);
        $this->display("continue_pay");
    }

    
    public function count_order_total(){
        $order_id=I("ids");
        $payment_id=I('payment_id');
        $use_account=I('use_account')?1:0;
        $score=I('score')?1:0;
        $type=I('type');
        $account_money=I('account_money');
        $result = D('Common/OrderInfo')->count_order_total($order_id,$type,$score,$use_account,$account_money,$payment_id);
        $this->assign($result['total_info']);
        $html=$this->fetch('cart_total');
        $return['html']=$html;
        $return['total_info']=$result['total_info'];
        //print_r($result);
        $this->ajaxReturn($return);
    }
    public function sub_continue_order(){
        $param=I("post.");
        $result= D("Common/OrderInfo")->sub_continue_order($param);
        $this->ajaxReturn($result);
    }
    public function vat_invoice(){
        $user_info=idtoname($this->member_info['id'],'Member','*');
        $invoce_map['uid']=$user_info['id'];
        $invoce_map['type']=3;
        $invoce_info=M("MemberInvoice")->where($invoce_map)->field(true)->find();
        if($invoce_info) {
            $ticket = unserialize($invoce_info['invoice_info']);

            $this->assign($ticket);
        }
        $this->display();
    }
    public function sub_vat(){
        $root=array('status'=>0,'msg'=>'');
        $post=I("post.");
        $user_info=idtoname($this->member_info['id'],'Member','*');
        $invoce_map['uid']=$user_info['id'];
        $invoce_map['type']=3;
        $data['invoice_info']=serialize($post);
        $data['type']=3;
        $invoce_info=M("MemberInvoice")->where($invoce_map)->field(true)->find();
        if($invoce_info){
            $info=M("MemberInvoice")->where($invoce_map)->save($data);
        }else{
            $data['uid']=$user_info['id'];
            $info=M("MemberInvoice")->add($data);
        }
        if($info){
            $root['status']=1;
            $root['msg']="保存成功";
        }else{
            $root['msg']="保存失败";
        }
        $this->ajaxReturn($root);
    }
}
?>