<?php
/**
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */
namespace Home\Controller;
use Think\Controller;
class PromotActController extends BaseController
{
    //活动列表
    public function index()
    {
        $map = array();
        $map['start_time'] = array('lt', NOW_TIME);
        $map['end_time'] = array('gt', NOW_TIME);
        $map['act_type'] = array('in', array(1, 2));//排除拼团，限时促销
        //$pagesize=empty($pagesize)?C('WEB_ACTIVE_PAGE'):$pagesize;
        //$list = page_list('PromotAct', $map, 'sort desc', '', $pagesize, '', 1);
        $list['list']=M('PromotAct')->where($map)->order('sort desc')->field(true)->select();
        foreach ($list['list'] as $k => $v) {
			if ($v['max_amount'] == 0) {$height = ',上不封顶';}else{$height = ',上限'.$v['max_amount'];}
            if ($v['act_type'] == 1) {
                $list['list'][$k]['title_name'] = '满' . $v['min_amount'] . '减' . $v['act_type_ext'] . $height;
            } elseif ($v['act_type'] == 2) {
                $list['list'][$k]['title_name'] = '满' . $v['min_amount'] . '享' . ($v['act_type_ext'] / 10) . '折' . $height;
            }
        }
        $this->assign($list);
        $this->assign('tplseo_title', '优惠活动_' . C('WEB_SITE_TITLE'));
        $this->display();
    }

    //活动内容
    public function cont()
    {
        $getdata = I('param.');
        $id = $getdata['id'];
        $Actinfo = M('PromotAct')->where('id=' . $id)->field('id,end_time,act_type,min_amount,act_type_ext,big_img,act_name')->find();
        if ($Actinfo['act_type'] == 1) {
            $Actinfo['title_name'] = '满' . $Actinfo['min_amount'] . '享受现金减免' . $Actinfo['act_type_ext'];
        } elseif ($Actinfo['act_type'] == 2) {
            $Actinfo['title_name'] = '满' . $Actinfo['min_amount'] . '享受折扣' . ($Actinfo['act_type_ext'] / 10) . '折';
        } else {
            $Actinfo['title_name'] = $Actinfo['act_name'];
        }
        $this->assign('act_info', $Actinfo);

        //活动下的商品
        $data = D('Common/Promot')->get_active_goods($getdata);

        $this->assign($data['goods_info']);
        $this->assign('order', $data['order']);
        $this->assign($getdata);
        $this->assign('tplseo_title', $Actinfo['act_name'] . '_促销活动' . '_' . C('WEB_SITE_TITLE'));
        $this->assign('tplseo_keywords', $Actinfo['act_name'] . '_促销活动' . '_' . C('WEB_SITE_TITLE'));
        $this->assign('tplseo_description', $Actinfo['act_name'] . '_促销活动' . '_' . C('WEB_SITE_TITLE'));
        $this->display();
    }
}
?>