<?php
/**
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */
namespace Home\Controller;
use Think\Controller;
class ShopsController extends BaseController {
    public function _initialize(){
		parent::_initialize();
		$param=I('param.');
		$this->assign('request',$param);
		$shop_id=I('id');
		$param['mid']=MID;
		$result=D('Common/Shops')->get_common($param);
		if($result['status']==0){$this->error($result['msg']);}
        $this->assign($result);
        $this->assign('tplseo_title',$result['data']['name'].'_'.C('WEB_SITE_TITLE'));
        $this->assign('tplseo_keywords',$result['data']['name']);
        $this->assign('tplseo_description',$result['data']['name']);
    }
    public function index(){
		$new_goods=D('Common/Shops')->get_shop_index_goods($this->shop_id,2);
        $best_goods=D('Common/Shops')->get_shop_index_goods($this->shop_id,3);
        $result['new_list']=$new_goods['list'];
        $result['best_list']=$best_goods['list'];
        $this->assign($result);
        $this->display();
    }
	public function lists(){
		$param=I('param.');
		$result=D('Common/Shops')->get_lists($this->shop_id,$param);
		$this->assign($result);
        $this->display();
    }
	public function activity_list(){
        $request['p']=I('request.p');
        $map['shop_id']=$this->shop_id;
    	$map['status']=1;
    	$order='id desc';
    	$field='id,title,content,addtime,updatetime';
        $pagesize=empty($pagesize)?C('WEB_ARTICLE_PAGE'):$pagesize;
    	$list=page_list('ShopsArticle',$map,$order,$field,$pagesize,'',$request);
    	$this->assign($list);
    	$this->display();
    }
    public function activity_cont(){
    	$id=I('aid');
    	if(empty($id)) $this->error(L('PARAM_ERR'));
    	$where['id']=$id;
    	$info=M('ShopsArticle')->where($where)->field('title,content,addtime')->find();
    	$this->assign($info);
    	$this->display();
    }
	public function collect(){
        $id=I('id');
        $data=D('Common/Shops')->collect_shop($id);
        $this->ajaxReturn($data);
	}
}
?>