<?php
/**
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */

namespace Home\Controller;
class WeixinController extends BaseController {
    public function _initialize() {
		parent::_initialize ();
        $this->model = M ('WxKeywords');
        $this->get_token();
	}
    public function index()
    {
     $weixin = new \Common\Vendor\WeixinChat;
     $data=$weixin->request();
     if($data){
     $backdata=$this->reply($data);
     if($backdata['type'] && $backdata['content'])$weixin->response($backdata['content'],$backdata['type']);
     }
    }
    private function get_token($token=''){
        $wxid=I('request.wxid');
        if(!empty($wxid)){
            $token=idtoname($wxid,'MemberPublic','token');session('token',$token);
        }elseif(!empty($_REQUEST['token'])){
            $token=$_REQUEST['token'];session('token',$token);
        }elseif(!empty($token)){
            session('token',$token);
        }elseif(empty($token)){
            $token=session('token');
        }if(empty($token))$token=C('WX_TOKEN');
        $this->token=$token;
    }
	private function reply($data) {
		if($data['Content']=='openid'){
			$backdata['type']='text';
            $backdata['content']=$data['FromUserName'];
            return $backdata;
		}
        // 消息类型
		switch ($data['MsgType']) {
			case 'text': // 类型是文本的
				return $this->getContent($data);
			case 'event' : // 类型是事件的
				switch ($data['Event']) {
					case 'subscribe': return $this->getfirst($data);break;// 首次关注                    
					case 'CLICK': $data['Content']=$data['EventKey'];return $this->getContent($data);break;//响应菜单关键词
					default :return $this->getdefault($data);break;//默认回复
				}break;
			default:return $this->getdefault($data);break;
		}
	}
    
	private function getContent($content) {
        $key    = $content['Content'];
		$cache_key = 'WXCONTENT_'.md5($key.$content['FromUserName']);
	//	$backdata = S($cache_key);
		if (empty($backdata)) {			
            $where['keyword']=$key;$where['type']=0;$where['status']=1;
            $where['keytype']='text';//精确定位文本关键词
            $keydata[0]= $this->model->where($where)->field('id,keytype')->cache(true)->order('sort,id desc')->find();
            if(!$keydata[0]['id']){
            $where['keytype']=array('neq','text');//精确定位非文本关键词
			$keydata= $this->model->where($where)->field('id,keytype')->cache(true)->order('sort,id desc')->select();
            }
            if(!$keydata[0]['id']){//模糊匹配
			    $like['type']= array('gt',0);$like['status']=1;//$like['token']=$this->token;
			    $list = $this->model->where($like)->field('id,keyword,keytype')->cache(true)->order('sort,id desc')->select();
                foreach($list as $keywordInfo) {
                    $keywordArr=$this->_contain_keyword($keywordInfo,$key);  
    			    if($keywordArr)$keydata[]=$keywordArr;
    		    }unset($list);
            }
            if(!$keydata[0]['id']){//匹配生活服务
                $keydata[0]=$this->getdefault($content);
                $keydata[0]['keytype']=$keydata[0]['type'];
            }
           if($keydata){//生成回复内容
           $nkeytype='';$backdata=array();
            foreach($keydata as $k => $v){
                if(!$v['keytype'])continue;
                if(!$nkeytype)$nkeytype=$v['keytype'];
                if($nkeytype!=$v['keytype'])return false;//当所有关键词类型不一致时跳出
                if($v['id']){$keyinfo=M('Wx'.ucfirst($v['keytype']))->field(true)->find($v['id']);//关键词
                if($keyinfo)$v=array_merge($v,$keyinfo);}
                $backdata['type']=$v['keytype'];
                $backdata['id']=$v['id'];
                switch($v['keytype']){
                    case "text":
                    $backdata['content']=$v['content'];
                    break;
                    case "news":
                    if($v['cover'] && !str_exists($v['cover'],'http://'))$v['cover']='http://'.$_SERVER['HTTP_HOST'].$v['cover'];
                    $v['jump_url']=U('Weixin/jump',array('id'=>$v['id'],'openid'=>$content['FromUserName']),true,true);//.=str_exists($v['jump_url'],'?')?'&openid='.$content['FromUserName']:'?openid='.$content['FromUserName'];
                    $backdata['content'][]=array($v['title'],$v['intro'],$v['cover'],$v['jump_url']);
                    break;
                }
            } 
            if($backdata)S($cache_key, $backdata,100);//缓存
	       }
       }
        $this->request_count($backdata);
        return $backdata;
	}
    // 处理关键词包含的算法
	private function _contain_keyword($keywordInfo, $key) {
	   $keyArr='';
       $keyword=$keywordInfo['keyword'];
       switch($keywordInfo['type']){
        case "4"://正则匹配
        if (preg_match ($keyword,$key))$keyArr = $keywordInfo;break;
        case "3"://模糊匹配
        if (str_exists($keyword,$key))$keyArr = $keywordInfo;break;
        case "0":break;//不支持完全匹配
        default://左右匹配
            $arr = explode ($keyword,$key);
            if (count($arr)>1){// 在关键词不相等的情况下进行左右匹配判断，否则相等的情况肯定都匹配    			
    			if ($keyword!=$key){
    				if($keywordInfo['type']==1 && ! empty($arr[0]))return false;// 左边匹配
    				if($keywordInfo['type']==2 && ! empty($arr[1]))return false;// 右边 匹配
    			}$keyArr = $keywordInfo;
    			$keyArr['prefix']= trim($arr[0]); // 关键词前缀，即包含关键词的前面部分
    			$keyArr['suffix']= trim($arr[1]); // 关键词后缀，即包含关键词的后面部分
    		}
        break;
       }
       if($keyArr){return $keyArr;}else{return false;}
	}
	private function request_count($data){//关键词的请求数批量+1
        if(!$data)return false;
        foreach($data as $v){if($v['id'])$this->model->where(array('id'=>$v['id']))->setInc('count');}
	}
	private function getfirst($data){//获取首次关注
		//$where['token']=$this->token;
        $first=M('WxFirst')->field('keyword,content')->find(1);
        $firstdata='';
        if($first['keyword']){
            $data['Content']=$first['keyword'];
            $firstdata=$this->getContent($data);
        }
        if(!$firstdata && $first['content']){
            $firstdata['type']='text';
            $firstdata['content']=$first['content'];
        }
        return $firstdata;
	}
    private function getdefault($data){//获取默认值或者 生活服务
        if(!$data['Content'])return false;
        if(C('WX_AUTOCHAT')){
        $url="http://we.onexin.com/?mod=dialog&do=talk&title=".urlencode($data['Content']);
        $content=json_decode(curlget($url),true);
        if(in_array($content['result'],array('200','300'))){
            $backdata['type']='text';
            $backdata['content']=$content['message'];
            return $backdata;
        }
        }
        return false;
    }
    public function jump(){
        $id=I('id');
        $openid=I('openid');
        if(!empty($openid)){session('openid',$openid);cookie('openid',$openid);}
        $info=M('WxNews')->where('id='.$id)->field(true)->find();
		$getaddons=M('WxKeywords')->where('id='.$id)->field('addon,aim_id,token')->find();
		if(!empty($getaddons['addon']) && !empty($getaddons['aim_id'])){
            $addonscheck=M($getaddons['addon'])->where('id='.$getaddons['aim_id'])->count();
            if($addonscheck){
                $param['_addons']=$getaddons['addon'];
                $param['_controller']=$getaddons['addon'];
                $param['_action']='preview';
                $param['token']=$getaddons['token'];
                $param['id']=$getaddons['aim_id'];
                $info['jump_url']=U('Admin/AddonsAdmin/execute',$param,true,true);
			}            
        }
        if(!empty($info['jump_url'])){
            redirect($info['jump_url']);
        }else{
            $this->assign($info);
            $this->display('Public/weixin');
        }
    }
   

}