<?php
/**
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */

namespace Member\Controller;
use Think\Controller;
class OrderCommentController extends BaseController{
    public function index(){
        $this->display();
    }
	
    public function comment(){
        $order_id = I('param.order_id');
        $info = M('OrderInfo')->where('id=' . $order_id)->field('shop_id,is_comment')->find();
        if($info['is_comment'])$this->error('订单已评论', U('OrderInfo/no_comment'));

        $field = 'og.id,og.order_id,og.goods_id,og.goods_name,og.goods_number,og.goods_price,og.goods_attr,g.img,g.dp_count,g.avg_score,g.avg_point';
        $goods_info = M('OrderGoods')->alias('og')->where('order_id=' . $order_id)->field($field)->join('LEFT JOIN __GOODS__ g on og.goods_id=g.id')->select();
        foreach ($goods_info as $k => $v) {
            $goods_attr = unserialize($v['goods_attr']);
            $goods_info[$k]['goods_attr'] = $goods_attr['name'];
            $goods_info[$k]['avg_point'] = $v['avg_point'] * 100;
        }
        $this->assign('order_id', $order_id);
        $this->assign('list', $goods_info);
		$this->assign('shop_id', $info['shop_id']);
        $this->assign('tplseo_title', '评论列表_会员中心_' . C('WEB_SITE_TITLE'));
        $this->display();
    }
	
    public function add_comment(){
        $postdata = I('param.');
        $return = D('Common/OrderInfo')->add_comment($postdata);
        if ($return['status'] == 1) $return['url'] = U('OrderInfo/no_comment');
        $this->ajaxReturn($return);
    }
	
    public function ajax_shop_info(){
        $return=array('status'=>0);
        $shop_id=I('shop_id');
        $shop=D("Common/Shops")->get_shop($shop_id,MID);
        if($shop['status']==0)$this->ajaxReturn($return);
        $return['status']=1;
        $this->assign('data',$shop['data']);
        $shop_info_html = $this->fetch("shop_info");
        $return['shop_info_html'] = $shop_info_html;
        $this->ajaxReturn($return);
    }
	
	public function collect(){
        $id=I('id');
        $data=D('Common/Shops')->collect_shop($id);
        $this->ajaxReturn($data);
	}
}
?>