<?php
/**
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */

namespace Member\Controller;
use Think\Controller;
class OrderInfoController extends BaseController{
    public function _initialize(){
        parent::_initialize();
        $map['uid'] = MID;
        $no_group = D('Common/OrderInfo')->all_order($map, 6, 1);
        $this->assign('no_group', $no_group);
        $no_pay = D('Common/OrderInfo')->all_order($map, 2, 1);
        $this->assign('no_pay', $no_pay);
        $no_ship = D('Common/OrderInfo')->all_order($map, 3, 1);
        $this->assign('no_ship', $no_ship);
        $yes_ship = D('Common/OrderInfo')->all_order($map, 4, 1);
        $this->assign('yes_ship', $yes_ship);
        $no_comment = D('Common/OrderInfo')->all_order($map, 5, 1);
        $this->assign('no_comment', $no_comment);

        $this->assign('menu_pid', 1);
        $this->assign('menu_sid', 1);
        $this->order_field = 'id,order_sn,goods_amount,pay_status,shipping_status,status,addtime,pay_code,is_comment,shop_id,type,pre_type,pre_money,pt_id';
    }
	
    public function index(){
        $postdata = I('param.');
        $all_order = D('Common/OrderInfo')->all_order($postdata, 1, $is_num, $page_num, $this->order_field);
        $this->assign($all_order);
        $this->assign($postdata);
        $this->assign('tplseo_title', '全部订单_会员中心_' . C('WEB_SITE_TITLE'));
        $this->display();
    }
	
    public function no_pay(){
        $postdata = I('param.');
        $no_pay = D('Common/OrderInfo')->all_order($postdata, 2, '', '', $this->order_field);
        $this->assign($no_pay);
        $this->assign($postdata);
        $this->assign('tplseo_title', '待付款订单_会员中心_' . C('WEB_SITE_TITLE'));
        $this->display();
    }
	
    public function no_ship(){
        $postdata = I('param.');
        $no_ship = D('Common/OrderInfo')->all_order($postdata, 3, '', '', $this->order_field);//print_r($no_ship);
        $this->assign($no_ship);
        $this->assign($postdata);
        $this->assign('tplseo_title', '待发货订单_会员中心_' . C('WEB_SITE_TITLE'));
        $this->display();
    }
	
    public function yes_ship(){
        $postdata = I('param.');
        $yes_ship = D('Common/OrderInfo')->all_order($postdata, 4, '', '', $this->order_field);
        $this->assign($yes_ship);
        $this->assign($postdata);
        $this->assign('tplseo_title', '待收货订单_会员中心_' . C('WEB_SITE_TITLE'));
        $this->display();
    }
	
    public function no_comment(){
        $postdata = I('param.');
        $no_comment = D('Common/OrderInfo')->all_order($postdata, 5, '', '', $this->order_field);
        $this->assign($no_comment);
        $this->assign($postdata);
        $this->assign('tplseo_title', '待评论订单_会员中心_' . C('WEB_SITE_TITLE'));
        $this->display();
    }
    
    public function no_group(){
        $postdata = I('param.');
        $no_pay = D('Common/OrderInfo')->all_order($postdata, 6, '', '', $this->order_field);
        $this->assign($no_pay);
        $this->assign($postdata);
        $this->assign('tplseo_title', '待成团订单_会员中心_' . C('WEB_SITE_TITLE'));
        $this->display();
    }
	
    public function info(){
        $id = I('param.id');
		if(empty($id)){$this->redirect('OrderInfo/index');}
        $order_info = M('OrderInfo')->where('id=' . $id)->field(true)->find();
        //print_r($order_info);
        $order_info['end_time'] = $order_info['addtime'] + C('CANCEL_ORDER_TIME') * 86400;//取消订单倒计时
        $order_info['ship_time'] = M('ShipOrder')->where('order_id=' . $id)->getField('ship_time');//发货时间
        $order_info['get_time'] = M('ShipOrder')->where('order_id=' . $id)->getField('get_time');//收货时间
        $order_info['comment_time'] = M('Comment')->where('order_id=' . $id)->getField('addtime');//评论时间
        $order_goods = M('OrderGoods')->where('order_id=' . $id)->field(true)->select();
		$ordershipping=M('ShipOrder')->where('order_id='.$id)->field(true)->select();
		$ordership=array();
		foreach($ordershipping as $v){
			$goodsid=explode(',',$v['goods_id']);
			foreach($goodsid as $val){
				$ordership[$val]=$v;
			}
		}
        foreach ($order_goods as $k => $v) {
			if(!empty($v['goods_attr'])){//获取属性和货号
				$attr = unserialize($v['goods_attr']);
				$order_goods[$k]['attr_name'] = $attr['name'];
				$attr_map['attr_key']=$attr['key'];
				$attr_map['goods_id']=$v['goods_id'];
				$attr_sn=M('goods_attr_stock')->where($attr_map)->getField('goods_attr_sn');
				$order_goods[$k]['attr_sn'] = $attr_sn;
			}
            $order_goods[$k]['img'] = idtoname($v['goods_id'], 'Goods', 'img');
            $order_goods[$k]['goods_integral'] = $v['goods_integral'];
			$order_goods[$k]['shipping']=$ordership[$v['goods_id']];
        }
        $invoice=unserialize($order_info['invoice_info']);//print_r($invoice);
        $this->assign($invoice);
        $this->assign($order_info);
        $this->assign('order_goods', $order_goods);
        $this->assign('tplseo_title', '订单详情_会员中心_' . C('WEB_SITE_TITLE'));
        $this->display();
    }
	
    public function confirm_order()
    {
        $postdata['order_id'] = I('order_id');
        $postdata['admin_id'] = MID;//操作日志用
        $postdata['type'] = 'Member';//操作日志用
        $result = D('Common/OrderInfo')->confirm_order($postdata);
        $this->ajaxReturn($result);
    }
	
    public function apply_return(){
        $postdata = I('param.');
        $return = D('Common/OrderInfo')->apply_return($postdata);
        $this->ajaxReturn($return);
    }
    
    public function cancel_order(){
        $postdata['order_id'] = I('order_id');
        $postdata['admin_id'] = MID;//操作日志用
        $postdata['type'] = 'Member';//操作日志用
        $return = D('Common/OrderInfo')->cancel_order($postdata);
        $this->ajaxReturn($return);
    }
    
    public function sub_refund(){
        $data = I("post.");
        $order_info = $refund_data = array();
        $order_info[$data['data']['order_id']] = $data['data']['order_goods'];
        $refund_data['order_info'] = $order_info;
        $refund_data['content'] = $data['content'];
        $refund_data['type'] = $data['type'];
        $return = D('Common/OrderInfo')->check_refund_money($refund_data);
        $this->ajaxReturn($return);
    }
    
    public function refund_money(){
        $data = I("post.");
        $return = D('Common/OrderInfo')->refund_audit($data);
        $this->ajaxReturn($return);
    }
    
    public function refund_goods(){
        $data = I("post.");
        $return = D('Common/OrderInfo')->apply_return($data);
        $this->ajaxReturn($return);
    }
    
    public function refund_content(){
        $order_id = I("order_id");
        $order_goods = I("order_goods");
        $score = I("score");
        $this->assign("order_id", $order_id);
        $this->assign("order_goods", $order_goods);
        $this->assign("score", $score);
        $this->assign('tplseo_title', '退款审核_会员中心_' . C('WEB_SITE_TITLE'));
        $this->display();
    }
    
    public function del_order(){
        $postdata['order_id'] = I('order_id');
        $postdata['admin_id'] = MID;//操作日志用
        $postdata['type'] = 'Member';//操作日志用
        $return = D('Common/OrderInfo')->del_order($postdata);
        $this->ajaxReturn($return);
    }
}
?>