<?php
/**
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */

namespace Member\Controller;
use Think\Controller;
class WithdrawalsController extends BaseController{
    public function _initialize(){
        parent::_initialize();
        $this->assign('menu_pid', 4);
        $this->assign('menu_sid', 1);
    }
	
    public function index(){
        $this->assign('tplseo_title', '充值_会员中心_' . C('WEB_SITE_TITLE'));
        $this->display();
    }
	
    public function go_recharge(){
        $postdata = I('post.');
        //if(!check_verify($postdata['verify'], 'Member')){$data['status']=0;$data['info']=L('verify_error');$this->ajaxReturn($data);exit;}
        $result = D('Common/Withdrawals')->recharge($postdata);
        if ($result['status']) {
            $result['url'] = U('Home/Pay/go_buy', array('id' => $result['log_id']));
        }
        $this->ajaxReturn($result);
    }
	
    public function withdrawals(){
		$member_info=M('Member')->where('id='.MID)->field(true)->find();
		$this->assign('memberinfo', $member_info);
        if (!C('MEMBER_TIXIAN')) {$this->error('平台未开启提现功能！');}
        $payfree = C('TIXIAN_FREE');
        if ($payfree < 1) $num = $payfree * 100;
        $this->assign('num', $num);
        $this->getmemberbank();
        $this->assign('tplseo_title', '提现_会员中心_' . C('WEB_SITE_TITLE'));
        $this->display();
    }
    
    public function go_withdrawals(){
        $postdata = I('post.');
        $result = D('Common/Withdrawals')->get_money($postdata);
        if ($result['status'] == 1) {
            $result['url'] = U('Capital/withdraw');
        } elseif ($result['status'] == 2) {
            $result['url'] = U("Userinfo/security");
        }
        $this->ajaxReturn($result);
    }
	
    public function add_bank(){
        $postdata = I('post.');
        $result = D('Common/Withdrawals')->add_bank($postdata);
        if ($result['status']) $result['url'] = U('Withdrawals/withdrawals');
        $this->ajaxReturn($result);
    }
	
    private function getmemberbank(){
        $map['uid'] = MID;
        $map['status'] = 1;
		$map['type'] = 0;
        $bank_info = M('MemberBank')->where($map)->field('name,bankname,bankcode')->find();

        if ($bank_info['bankcode']) {
            $length = strlen($bank_info['bankcode']);
            if (str_exists('@', $bank_info['bankcode'])) {
                $bankcodearr = explode('@', $bank_info['bankcode']);
                $bank_info['bankcode'] = substr($bankcodearr[0], 0, (strlen($bankcodearr[0]) - 4)) . '****@' . $bankcodearr[1];
            } else {
                $bank_info['bankcode'] = substr($bank_info['bankcode'], 0, ($length - 4)) . '****';
            }
        }
        $this->assign('bank_info', $bank_info);
        $banks = array_unique(explode(',', C('MEMBER_BANK')));
        foreach ($banks as $v) {
            $banksarr[$v] = $v;
        }
        $this->assign('tplseo_title', '提现银行信息_会员中心_' . C('WEB_SITE_TITLE'));
        $this->assign('banks', $banksarr);
    }
	
    public function verify(){
        $config = array(
            'imageW' => '170',
            'imageH' => '50',
            'seKey' => 'chanchao' . C('HANCHAO_KEY'),
            'length' => 4,
        );
        $verify = new \Common\Vendor\Verify($config);
        $verify->entry('Member');
    }
}
?>