<?php
namespace Member\Event;
class TypeEvent {
	public function qq($token) {
		$qq = \Common\Vendor\ThinkOauth::getInstance('qq', $token);
		$data = $qq->call('user/get_user_info');
		if ($data['ret'] == 0) {
			$userInfo['type'] = 'QQ';
			$userInfo['name'] = $data['nickname'];
			$userInfo['nick'] = $data['nickname'];
			$userInfo['head'] = $data['figureurl_2'];
			return $userInfo;
		} else {
			E("获取腾讯QQ用户信息失败：{$data['msg']}");
		}
	}
	public function weixin($token) {
		$weixin = \Common\Vendor\ThinkOauth::getInstance('weixin', $token);
		$data = $weixin->call('sns/userinfo');
		if (!empty($data['openid'])) {
			$userInfo['type'] = 'WEIXIN';
			$userInfo['name'] = $data['nickname'];
			$userInfo['nick'] = $data['nickname'];
			$userInfo['head'] = $data['headimgurl'];
			return $userInfo;
		} else {
			E("获取微信用户信息失败：{$data['msg']}");
		}
	}
	public function tencent($token) {
		$tencent = \Common\Vendor\ThinkOauth::getInstance('tencent', $token);
		$data = $tencent->call('user/info');
		if ($data['ret'] == 0) {
			$userInfo['type'] = 'TENCENT';
			$userInfo['name'] = $data['data']['name'];
			$userInfo['nick'] = $data['data']['nick'];
			$userInfo['head'] = $data['data']['head'];
			return $userInfo;
		} else {
			E("获取腾讯微博用户信息失败：{$data['msg']}");
		}
	}
	public function sina($token) {
		$sina = \Common\Vendor\ThinkOauth::getInstance('sina', $token);
		$data = $sina->call('users/show', "uid={$sina->openid()}");
		if ($data['error_code'] == 0) {
			$userInfo['type'] = 'SINA';
			$userInfo['name'] = $data['name'];
			$userInfo['nick'] = $data['screen_name'];
			$userInfo['head'] = $data['avatar_large'];
			return $userInfo;
		} else {
			E("获取新浪微博用户信息失败：{$data['error']}");
		}
	}
	public function t163($token) {
		$t163 = \Common\Vendor\ThinkOauth::getInstance('t163', $token);
		$data = $t163->call('users/show');
		if ($data['error_code'] == 0) {
			$userInfo['type'] = 'T163';
			$userInfo['name'] = $data['name'];
			$userInfo['nick'] = $data['screen_name'];
			$userInfo['head'] = str_replace('w=48&h=48', 'w=180&h=180', $data['profile_image_url']);
			return $userInfo;
		} else {
			E("获取网易微博用户信息失败：{$data['error']}");
		}
	}
	public function renren($token) {
		$renren = \Common\Vendor\ThinkOauth::getInstance('renren', $token);
		$data = $renren->call('users.getInfo');
		if (!isset($data['error_code'])) {
			$userInfo['type'] = 'RENREN';
			$userInfo['name'] = $data[0]['name'];
			$userInfo['nick'] = $data[0]['name'];
			$userInfo['head'] = $data[0]['headurl'];
			return $userInfo;
		} else {
			E("获取人人网用户信息失败：{$data['error_msg']}");
		}
	}
	public function x360($token) {
		$x360 = ThinkOauth::getInstance('x360', $token);
		$data = $x360->call('user/me');
		if ($data['error_code'] == 0) {
			$userInfo['type'] = 'X360';
			$userInfo['name'] = $data['name'];
			$userInfo['nick'] = $data['name'];
			$userInfo['head'] = $data['avatar'];
			return $userInfo;
		} else {
			E("获取360用户信息失败：{$data['error']}");
		}
	}
	public function douban($token) {
		$douban = \Common\Vendor\ThinkOauth::getInstance('douban', $token);
		$data = $douban->call('user/me');
		if (empty($data['code'])) {
			$userInfo['type'] = 'DOUBAN';
			$userInfo['name'] = $data['name'];
			$userInfo['nick'] = $data['name'];
			$userInfo['head'] = $data['avatar'];
			return $userInfo;
		} else {
			E("获取豆瓣用户信息失败：{$data['msg']}");
		}
	}
	public function github($token) {
		$github = \Common\Vendor\ThinkOauth::getInstance('github', $token);
		$data = $github->call('user');
		if (empty($data['code'])) {
			$userInfo['type'] = 'GITHUB';
			$userInfo['name'] = $data['login'];
			$userInfo['nick'] = $data['name'];
			$userInfo['head'] = $data['avatar_url'];
			return $userInfo;
		} else {
			E("获取Github用户信息失败：{$data}");
		}
	}
	public function google($token) {
		$google = \Common\Vendor\ThinkOauth::getInstance('google', $token);
		$data = $google->call('userinfo');
		if (!empty($data['id'])) {
			$userInfo['type'] = 'GOOGLE';
			$userInfo['name'] = $data['name'];
			$userInfo['nick'] = $data['name'];
			$userInfo['head'] = $data['picture'];
			return $userInfo;
		} else {
			E("获取Google用户信息失败：{$data}");
		}
	}
	public function msn($token) {
		$msn = \Common\Vendor\ThinkOauth::getInstance('msn', $token);
		$data = $msn->call('me');
		if (!empty($data['id'])) {
			$userInfo['type'] = 'MSN';
			$userInfo['name'] = $data['name'];
			$userInfo['nick'] = $data['name'];
			$userInfo['head'] = '微软暂未提供头像URL，请通过 me/picture 接口下载';
			return $userInfo;
		} else {
			E("获取msn用户信息失败：{$data}");
		}
	}
	public function diandian($token) {
		$diandian = \Common\Vendor\ThinkOauth::getInstance('diandian', $token);
		$data = $diandian->call('user/info');
		if (!empty($data['meta']['status']) && $data['meta']['status'] == 200) {
			$userInfo['type'] = 'DIANDIAN';
			$userInfo['name'] = $data['response']['name'];
			$userInfo['nick'] = $data['response']['name'];
			$userInfo['head'] = "https://api.diandian.com/v1/blog/{$data['response']['blogs'][0]['blogUuid']}/avatar/144";
			return $userInfo;
		} else {
			E("获取点点用户信息失败：{$data}");
		}
	}
	public function taobao($token) {
		$taobao = \Common\Vendor\ThinkOauth::getInstance('taobao', $token);
		$fields = 'user_id,nick,sex,buyer_credit,avatar,has_shop,vip_info';
		$data = $taobao->call('taobao.user.buyer.get', "fields={$fields}");
		if (!empty($data['user_buyer_get_response']['user'])) {
			$user = $data['user_buyer_get_response']['user'];
			$userInfo['type'] = 'TAOBAO';
			$userInfo['name'] = $user['user_id'];
			$userInfo['nick'] = $user['nick'];
			$userInfo['head'] = $user['avatar'];
			return $userInfo;
		} else {
			E("获取淘宝网用户信息失败：{$data['error_response']['msg']}");
		}
	}
	public function baidu($token) {
		$baidu = \Common\Vendor\ThinkOauth::getInstance('baidu', $token);
		$data = $baidu->call('passport/users/getLoggedInUser');
		if (!empty($data['uid'])) {
			$userInfo['type'] = 'BAIDU';
			$userInfo['name'] = $data['uid'];
			$userInfo['nick'] = $data['uname'];
			$userInfo['head'] = "http://tb.himg.baidu.com/sys/portrait/item/{$data['portrait']}";
			return $userInfo;
		} else {
			E("获取百度用户信息失败：{$data['error_msg']}");
		}
	}
	public function kaixin($token) {
		$kaixin = \Common\Vendor\ThinkOauth::getInstance('kaixin', $token);
		$data = $kaixin->call('users/me');
		if (!empty($data['uid'])) {
			$userInfo['type'] = 'KAIXIN';
			$userInfo['name'] = $data['uid'];
			$userInfo['nick'] = $data['name'];
			$userInfo['head'] = $data['logo50'];
			return $userInfo;
		} else {
			E("获取开心网用户信息失败：{$data['error']}");
		}
	}
	public function sohu($token) {
		$sohu = \Common\Vendor\ThinkOauth::getInstance('sohu', $token);
		$data = $sohu->call('i/prv/1/user/get-basic-info');
		if ('success' == $data['message'] && !empty($data['data'])) {
			$userInfo['type'] = 'SOHU';
			$userInfo['name'] = $data['data']['open_id'];
			$userInfo['nick'] = $data['data']['nick'];
			$userInfo['head'] = $data['data']['icon'];
			return $userInfo;
		} else {
			E("获取搜狐用户信息失败：{$data['message']}");
		}
	}
}