;(function(window) {

  var svgSprite = '<svg>' +
    '' +
    '<symbol id="icon-shouji" viewBox="0 0 1024 1024">' +
    '' +
    '<path d="M702.699388 60.945047 321.284238 60.945047c-57.463044 0-104.022314 46.591131-104.022314 104.018052l0 693.454702c0 57.426921 46.560293 104.019075 104.022314 104.019075l381.416174 0c57.463044 0 104.022314-46.592155 104.022314-104.019075L806.722726 164.963099C806.722726 107.537202 760.163456 60.945047 702.699388 60.945047zM477.317197 95.617731l69.349233 0c9.582632 0 17.336541 7.754614 17.336541 17.33583 0 9.582239-7.753909 17.336854-17.336541 17.336854l-69.349233 0c-9.581609 0-17.336541-7.754614-17.336541-17.336854C459.980656 103.372346 467.735588 95.617731 477.317197 95.617731zM511.992325 920.077116c-24.482581 0-44.324277-19.840884-44.324277-44.322461 0-24.480554 19.84272-44.322461 44.324277-44.322461 24.481557 0 44.324277 19.84293 44.324277 44.322461C556.317626 900.237255 536.473882 920.077116 511.992325 920.077116zM737.373493 771.736603c0 9.582239-7.753909 17.33583-17.336541 17.33583L303.946674 789.072433c-9.582632 0-17.337564-7.753591-17.337564-17.33583L286.60911 182.299953c0-9.582239 7.754932-17.33583 17.337564-17.33583l416.090278 0c9.582632 0 17.336541 7.754614 17.336541 17.33583L737.373493 771.736603z"  ></path>' +
    '' +
    '</symbol>' +
    '' +
    '<symbol id="icon-recharge" viewBox="0 0 1024 1024">' +
    '' +
    '<path d="M512 64C264.96 64 64 264.96 64 512s200.96 448 448 448 448-200.96 448-448S759.04 64 512 64zM512 896C300.256 896 128 723.744 128 512 128 300.256 300.256 128 512 128c211.744 0 384 172.256 384 384C896 723.744 723.744 896 512 896z"  ></path>' +
    '' +
    '<path d="M641.088 512c17.696 0 32-14.336 32-32s-14.304-32-32-32L544 448l0-15.136 118.592-123.872c12.192-12.8 12-33.056-0.8-45.248-12.736-12.16-32.832-11.712-45.088 1.12l-101.6 106.784-107.584-107.36c-12.544-12.512-32.768-12.448-45.248 0.064-12.48 12.512-13.088 32.768-0.576 45.248L480 428.224 480 448l-94.784 0c-17.664 0-32 14.336-32 32s14.336 32 32 32L480 512l0 64-94.784 0c-17.664 0-32 14.304-32 32s14.336 32 32 32L480 640l0 95.136c0 17.696 14.336 32 32 32s32-14.304 32-32L544 640l97.088 0c17.696 0 32-14.304 32-32s-14.304-32-32-32L544 576l0-64L641.088 512z"  ></path>' +
    '' +
    '</symbol>' +
    '' +
    '<symbol id="icon-dingwei" viewBox="0 0 1024 1024">' +
    '' +
    '<path d="M512 32c-194.304 0-352 153.536-352 342.848C160 701.952 512 992 512 992s352-302.464 352-617.152C864 185.536 706.304 32 512 32zM512 576C406.016 576 320 489.984 320 384s86.016-192 192-192 192 86.016 192 192S617.984 576 512 576z"  ></path>' +
    '' +
    '</symbol>' +
    '' +
    '<symbol id="icon-redbag" viewBox="0 0 1024 1024">' +
    '' +
    '<path d="M909.871567 256.129381C901.054472 242.445729 882.815499 238.501084 869.131852 247.317 855.44938 256.134095 851.503555 274.373067 860.319471 288.055539 903.309733 354.777331 926.032115 432.206017 926.032115 511.971309 926.032115 622.55694 882.967579 726.525329 804.772599 804.721488 726.576439 882.916469 622.60923 925.981003 512.023601 925.981003 401.43797 925.981003 297.470759 882.916469 219.274601 804.721488 141.078442 726.525329 98.013908 622.556941 98.013908 511.971309 98.013908 431.960804 120.868327 354.330522 164.104983 287.470797 172.944477 273.802471 169.029305 255.556426 155.360981 246.718111 141.693835 237.878617 123.445433 241.79379 114.608296 255.462116 65.190596 331.879291 39.068229 420.579571 39.068229 511.972489 39.068229 575.8083 51.576502 637.749599 76.247627 696.077527 100.069934 752.400124 134.167652 802.977874 177.594112 846.403155 221.019394 889.829616 271.597144 923.927334 327.919741 947.749641 386.24649 972.420766 448.188966 984.929039 512.024781 984.929039 575.859412 984.929039 637.801889 972.420766 696.129817 947.749641 752.451235 923.927335 803.028988 889.829616 846.454268 846.403155 889.880728 802.977874 923.978445 752.401303 947.800754 696.077527 972.47188 637.749599 984.98015 575.8083 984.98015 511.972489 984.978971 420.858975 959.006326 332.389763 909.871567 256.129381L909.871567 256.129381ZM849.730469 191.969367C849.561884 184.968977 846.693588 178.06526 841.479251 172.674086 841.474537 172.669372 841.470999 172.664658 841.466285 172.65994 841.456852 172.650507 841.44742 172.642255 841.439171 172.632826 841.221071 172.407653 841.005329 172.18012 840.7778 171.960843 752.128212 86.230247 635.375684 39.017115 512.023601 39.017115 388.675051 39.017115 271.922524 86.229068 183.274117 171.957305 183.274117 171.957305 171.784425 180.819202 173.33116 194.598343 174.877895 208.377484 183.280012 214.336891 183.280012 214.336891 271.926061 300.060414 388.677409 347.270011 512.023601 347.270011 635.151694 347.270011 751.703806 300.224284 840.292087 214.789598 840.292087 214.788418 850.07707 206.312027 849.730469 191.969367L849.730469 191.969367ZM545.440154 561.437006 493.215387 561.437006 412.585596 421.781493C406.322157 410.932774 392.177687 407.053244 381.164095 413.411738 370.073114 419.81481 366.36098 433.827214 372.700966 444.808844L440.035878 561.437006 384.406009 561.437006C371.582194 561.437006 361.221359 571.746528 361.221359 584.464354 361.221359 597.270505 371.601541 607.491702 384.406009 607.491702L499.385454 607.491702 499.385454 676.57375 384.406009 676.57375C371.582194 676.57375 361.221359 686.883273 361.221359 699.601099 361.221359 712.40725 371.601541 722.628448 384.406009 722.628448L499.385454 722.628448 499.385454 814.680644C499.385454 827.26977 509.694976 837.765194 522.412802 837.765194 535.218953 837.765194 545.440154 827.430435 545.440154 814.680644L545.440154 722.628448 660.419595 722.628448C673.243413 722.628448 683.604249 712.318925 683.604249 699.601099 683.604249 686.794948 673.224067 676.57375 660.419595 676.57375L545.440154 676.57375 545.440154 607.491702 660.419595 607.491702C673.243413 607.491702 683.604249 597.18218 683.604249 584.464354 683.604249 571.658202 673.224067 561.437006 660.419595 561.437006L598.619659 561.437006 665.954573 444.808844C672.294559 433.828056 668.582427 419.815652 657.491445 413.411738 646.477851 407.053244 632.33338 410.932774 626.06994 421.781493L545.440154 561.437006 545.440154 561.437006ZM182.605343 172.63063C182.593213 172.642759 182.587151 172.654884 182.57502 172.667013L182.605343 172.63063ZM776.142685 193.142386C701.98784 254.728833 609.357065 288.323152 512.023601 288.323152 414.690139 288.323152 322.059361 254.728833 247.904519 193.142386 322.06054 131.555939 414.690139 97.96162 512.023601 97.96162 609.357065 97.96162 701.986661 131.555939 776.142685 193.142386L776.142685 193.142386Z"  ></path>' +
    '' +
    '</symbol>' +
    '' +
    '<symbol id="icon-shanchu" viewBox="0 0 1024 1024">' +
    '' +
    '<path d="M344.154247 793.002952c-15.451924 0-27.976168-12.57234-27.976168-28.094872L316.178079 455.790814c0-15.522532 12.524245-28.092825 27.976168-28.092825 15.473413 0 27.976168 12.570293 27.976168 28.092825l0 309.11829C372.130416 780.431635 359.62766 793.002952 344.154247 793.002952L344.154247 793.002952zM512.01228 793.002952c-15.47546 0-27.976168-12.57234-27.976168-28.094872L484.036112 455.790814c0-15.522532 12.500709-28.092825 27.976168-28.092825 15.451924 0 27.974122 12.570293 27.974122 28.092825l0 309.11829C539.986401 780.431635 527.464203 793.002952 512.01228 793.002952L512.01228 793.002952zM679.871335 793.002952c-15.47546 0-27.977191-12.57234-27.977191-28.094872L651.894144 455.790814c0-15.522532 12.502755-28.092825 27.977191-28.092825 15.451924 0 27.974122 12.570293 27.974122 28.092825l0 309.11829C707.844433 780.431635 695.322236 793.002952 679.871335 793.002952L679.871335 793.002952zM903.657144 287.206234l0 28.094872-55.95336 0 0 533.912056c0 61.946864-50.16861 112.396883-111.904673 112.396883L288.200888 961.610044c-61.71048 0-111.881137-50.450019-111.881137-112.396883L176.319751 315.300083l-55.951313 0 0-28.094872-28.001751 0 0-28.116361c0-61.9704 50.194192-112.396883 111.906719-112.396883l115.88431 0c12.500709-48.343031 55.927777-84.302011 107.926058-84.302011l167.855986 0c51.972699 0 95.42535 35.95898 107.926058 84.302011l115.861798 0c61.712527 0 111.904673 50.426483 111.904673 112.396883l0 28.116361L903.657144 287.205211 903.657144 287.206234zM288.200888 905.400858l447.598224 0c30.855752 0 55.951313-25.191752 55.951313-56.187697L791.750425 315.300083 232.273111 315.300083l-3.88754 533.912056C228.385571 880.209106 257.369695 905.400858 288.200888 905.400858L288.200888 905.400858zM595.939761 118.599142 428.083775 118.599142c-20.603247 0-38.46608 11.400654-48.15679 28.092825l264.169565 0C634.405841 129.999796 616.519472 118.599142 595.939761 118.599142L595.939761 118.599142zM819.727617 202.901153 204.273407 202.901153c-30.833239 0-55.95336 25.191752-55.95336 56.187697l66.652026 0 139.858328 0 314.339198 0 139.880841 0 66.629513 0C875.680976 228.092905 850.583368 202.901153 819.727617 202.901153L819.727617 202.901153z"  ></path>' +
    '' +
    '</symbol>' +
    '' +
    '<symbol id="icon-shangchuan" viewBox="0 0 1024 1024">' +
    '' +
    '<path d="M927.136 654.72l-98.144 0-0.672 0.768 2.496 143.552L196.48 795.008l1.056-140.512-100.864-1.088L99.04 896 928 896 927.136 654.72zM391.328 752.48l243.776 0-0.224-287.36 195.648-0.832L516.544 128 196.992 464.256l192.608 0.032L391.328 752.48z"  ></path>' +
    '' +
    '</symbol>' +
    '' +
    '<symbol id="icon-kefu" viewBox="0 0 1024 1024">' +
    '' +
    '<path d="M839.68 1006.336c-8.96 0-17.536-2.56-24.96-7.424l-40.576-26.752c-1.152-0.768-2.304-1.536-3.456-2.56l-34.816-23.168c-93.952 15.104-187.776-3.456-264.96-52.736-11.776-7.552-15.232-23.168-7.808-34.944 7.552-11.776 23.168-15.232 34.944-7.808 69.248 44.032 153.984 59.648 238.72 43.904 6.4-1.152 13.184 0.128 18.688 3.84l44.288 29.44c0.896 0.64 1.792 1.28 2.688 2.048l31.872 20.992 0-76.16c0-8.832 4.608-17.024 12.16-21.632 78.592-48 125.44-125.952 125.44-208.512 0-17.664-2.176-35.328-6.272-52.608-5.76-23.552-15.232-46.208-28.416-67.328-7.424-11.904-3.712-27.52 8.192-34.944 11.904-7.296 27.52-3.712 34.944 8.192 16 25.728 27.52 53.376 34.56 82.048 5.12 21.12 7.808 42.88 7.808 64.64 0 96-51.2 186.24-137.6 243.968l0 71.936c0 16.768-9.216 32.128-23.936 40.064C854.784 1004.416 847.232 1006.336 839.68 1006.336zM234.88 897.536c-7.552 0-15.104-1.92-21.76-5.504-14.592-7.808-23.808-23.168-23.808-39.936l0-107.392C71.296 669.056 1.28 548.736 1.28 420.096 1.28 198.272 207.488 17.664 460.928 17.664s459.648 180.48 459.648 402.432c0 221.824-206.208 402.304-459.52 402.304-28.672 0-58.112-2.56-87.68-7.68l-53.888 35.84c-1.28 1.024-2.688 2.048-4.096 2.944l-55.296 36.48C252.544 894.976 243.84 897.536 234.88 897.536zM460.928 68.352C235.52 68.352 52.096 226.176 52.096 420.096c0 114.944 65.792 222.976 175.872 288.768 7.68 4.608 12.288 12.8 12.288 21.76l0 111.744 47.36-31.232c0.896-0.768 1.536-1.28 2.432-1.92l63.616-42.368c5.504-3.712 12.288-4.992 18.816-3.84 29.824 5.76 59.648 8.576 88.448 8.576 225.408 0 408.832-157.824 408.832-351.616S686.336 68.352 460.928 68.352z"  ></path>' +
    '' +
    '</symbol>' +
    '' +
    '<symbol id="icon-giftbox" viewBox="0 0 1024 1024">' +
    '' +
    '<path d="M877.537 230.7h-37.129c13.789-21.998 26.089-50.558 23.292-80.274-1.816-19.579-11.151-47.622-45.257-70.004-28.566-18.728-65.254-23.317-105.955-13.071-69.535 17.438-149.45 77.639-200.531 147.529-51.082-69.895-130.996-130.090-200.53-147.529-40.702-10.245-77.448-5.658-105.951 13.071-34.111 22.382-43.452 50.421-45.262 70.004-2.802 29.716 9.502 58.276 23.287 80.269h-37.129c-46.522 0-84.365 37.849-84.365 84.339v112.49c0 38.888 26.583 71.402 62.504 81.097-3.957 9.724-6.208 20.271-6.208 31.362v337.461c0 46.525 37.848 84.368 84.368 84.368h309.009c0.111 0 0.163 0.053 0.274 0.053s0.163-0.053 0.274-0.053h309.12c46.521 0 84.365-37.843 84.365-84.368v-337.461c0-11.121-2.251-21.667-6.208-31.386 35.812-9.752 62.4-42.216 62.4-81.073v-112.49c0-46.492-37.843-84.335-84.368-84.335v0zM726.109 121.919c25.433-6.422 46.080-4.559 61.464 5.522 16.639 10.93 19.441 21.281 20.103 28.12 2.692 27.737-27.575 64.129-38.724 75.139h-198.059c43.389-51.713 104.739-96.122 155.216-108.781v0zM216.237 155.562c0.661-6.84 3.463-17.191 20.103-28.12 15.326-10.081 35.922-11.949 61.464-5.522 50.478 12.636 111.664 57.097 155.053 108.781h-197.897c-11.151-11.016-41.415-47.402-38.723-75.139v0zM118.253 315.036c0-15.489 12.631-28.090 28.12-28.090h337.46v168.676h-337.46c-15.49 0-28.12-12.607-28.12-28.096v-112.49zM174.55 877.445v-337.461c0-15.518 12.631-28.118 28.12-28.118h281.163v393.705h-281.163c-15.485 0-28.12-12.607-28.12-28.125v0zM849.475 877.445c0 15.518-12.635 28.125-28.124 28.125h-281.274v-393.705h281.274c15.49 0 28.124 12.607 28.124 28.118v337.461zM905.662 427.525c0 15.489-12.631 28.096-28.125 28.096h-337.461v-168.676h337.461c15.489 0 28.125 12.603 28.125 28.090v112.49z"  ></path>' +
    '' +
    '</symbol>' +
    '' +
    '<symbol id="icon-H" viewBox="0 0 1024 1024">' +
    '' +
    '<path d="M512 65.523319c-246.194168 0-446.494077 200.299909-446.494077 446.494077 0 246.194168 200.299909 446.494077 446.494077 446.494077S958.494077 758.211565 958.494077 512.017396C958.494077 265.823228 758.194168 65.523319 512 65.523319zM512 923.492912c-226.889497 0-411.474492-184.584995-411.474492-411.474492 0-226.889497 184.584995-411.474492 411.474492-411.474492s411.474492 184.584995 411.474492 411.474492C923.474492 738.906893 738.889497 923.492912 512 923.492912z"  ></path>' +
    '' +
    '<path d="M767.897158 461.420021l0.096191-0.104377-35.325553-32.849152L732.667795 306.066791c0-34.222429-27.845185-62.065568-62.067614-62.065568L353.399819 244.001223c-34.225499 0-62.067614 27.842115-62.067614 62.065568l0 125.646652-32.257681 32.257681c-2.148943 1.690502-4.025687 3.651157-5.740748 5.740748l-2.324952 2.324952 0.305969 0.305969c-4.686742 6.824429-7.268544 15.112186-7.268544 23.63121l0 284.080034c0 2.27481 0.502443 4.423753 1.370207 6.377244 3.096525 8.755408 11.362792 15.066137 21.178345 15.066137 3.326768 0 6.459109-0.763386 9.301853-2.056845 2.098801-0.762363 4.078899-1.941212 5.761214-3.624551l197.717084-197.717084c17.993816-17.983583 47.257304-17.978467 65.246003 0l195.413622 195.413622c4.122901 5.352915 10.526751 8.860808 17.806551 8.860808 11.249205 0 20.494777-8.261151 22.193465-19.032472 0.225127-1.061169 0.355087-2.158153 0.355087-3.28686L780.38968 490.331491C780.38968 479.295134 775.883039 468.63126 767.897158 461.420021zM740.256634 485.206774c1.969864-1.969864 4.084015-1.675152 5.495154-1.092891 1.421372 0.587378 3.114944 1.87265 3.114944 4.659113l0 268.992407L608.280834 617.180528 740.256634 485.206774zM275.570219 757.327428 275.570219 494.770594c0-1.472538 0.360204-2.636037 0.86981-3.588735l2.966565-2.966565c0.300852-0.164752 0.583285-0.305969 0.809435-0.400113 1.397836-0.580215 4.992711-1.577938 8.203846 1.63422l127.515209 127.511115L275.570219 757.327428zM457.087343 575.810305l-18.862603 18.862603L322.856176 479.304344 322.856176 306.066791c0-16.839527 13.70207-30.541597 30.543643-30.541597l317.199339 0c16.839527 0 30.543643 13.70207 30.543643 30.541597l0 173.673481L585.992201 594.891895l-19.081591-19.081591C536.633027 545.532721 487.36902 545.537837 457.087343 575.810305z"  ></path>' +
    '' +
    '<path d="M595.126232 465.803865c0-8.705266-7.05672-15.761985-15.761985-15.761985l-51.602262 0 0-21.639856 48.614208 0c8.705266 0 15.761985-7.05672 15.761985-15.761985s-7.05672-15.761985-15.761985-15.761985l-48.614208 0 0-14.893198 55.456033-43.095517c6.873548-5.341658 8.114818-15.244192 2.77316-22.116717l0 0c-5.341658-6.872524-15.243169-8.114818-22.116717-2.77316l-51.875484 40.311101-51.878554-40.312124c-6.873548-5.340635-16.775059-4.099365-22.115694 2.774183-5.341658 6.873548-4.100388 16.776082 2.774183 22.116717l55.458079 43.095517 0 14.893198-48.612161 0c-8.705266 0-15.761985 7.05672-15.761985 15.761985s7.05672 15.761985 15.761985 15.761985l48.612161 0 0 21.639856-51.602262 0c-8.705266 0-15.761985 7.05672-15.761985 15.761985 0 8.705266 7.05672 15.761985 15.761985 15.761985l51.602262 0 0 32.80208c0 8.705266 7.05672 15.761985 15.761985 15.761985 8.705266 0 15.761985-7.05672 15.761985-15.761985l0-32.80208 51.602262 0C588.069513 481.56585 595.126232 474.509131 595.126232 465.803865z"  ></path>' +
    '' +
    '</symbol>' +
    '' +
    '<symbol id="icon-shield" viewBox="0 0 1024 1024">' +
    '' +
    '<path d="M768 548.571429l0-365.714286-256 0 0 649.714286q68-36 121.714286-78.285714 134.285714-105.142857 134.285714-205.714286zm109.714286-438.857143l0 438.857143q0 49.142857-19.142857 97.428571t-47.428571 85.714286-67.428571 72.857143-72.285714 58.857143-69.142857 44.285714-51.142857 28.285714-24.285714 11.428571q-6.857143 3.428571-14.857143 3.428571t-14.857143-3.428571q-9.142857-4-24.285714-11.428571t-51.142857-28.285714-69.142857-44.285714-72.285714-58.857143-67.428571-72.857143-47.428571-85.714286-19.142857-97.428571l0-438.857143q0-14.857143 10.857143-25.714286t25.714286-10.857143l658.285714 0q14.857143 0 25.714286 10.857143t10.857143 25.714286z"  ></path>' +
    '' +
    '</symbol>' +
    '' +
    '<symbol id="icon-moneybag" viewBox="0 0 1024 1024">' +
    '' +
    '<path d="M656 310.4c35.2-38.4 76.8-96 76.8-156.8 0-35.2-9.6-64-32-86.4-41.6-41.6-115.2-41.6-198.4-41.6l-22.4 0c-12.8 0-25.6 0-38.4 0-76.8 0-140.8-3.2-182.4 38.4-22.4 22.4-32 51.2-32 89.6 0 86.4 76.8 163.2 112 192 12.8 12.8 35.2 9.6 44.8-3.2 12.8-12.8 9.6-35.2-3.2-44.8-54.4-48-89.6-102.4-89.6-144 0-32 9.6-41.6 12.8-44.8 22.4-19.2 76.8-19.2 137.6-19.2 12.8 0 25.6 0 41.6 0l25.6 0c67.2 0 131.2 0 153.6 22.4C662.4 115.2 672 124.8 672 153.6c0 38.4-35.2 92.8-92.8 140.8-9.6 6.4-12.8 19.2-9.6 28.8 3.2 9.6 9.6 19.2 19.2 25.6 118.4 44.8 243.2 166.4 243.2 332.8 0 156.8-96 214.4-352 214.4s-352-57.6-352-214.4c0-96 44.8-192 124.8-262.4 12.8-12.8 16-32 3.2-44.8-12.8-12.8-32-16-44.8-3.2-92.8 83.2-147.2 195.2-147.2 310.4 0 278.4 281.6 278.4 416 278.4s416 0 416-278.4C899.2 528 800 384 656 310.4z"  ></path>' +
    '' +
    '<path d="M611.2 467.2c12.8-12.8 12.8-32 0-44.8-12.8-12.8-32-12.8-44.8 0l-80 76.8-80-76.8c-12.8-12.8-32-12.8-44.8 0-12.8 12.8-12.8 32 0 44.8l89.6 86.4 0 19.2-64 0c-19.2 0-32 12.8-32 32s12.8 32 32 32l64 0 0 32-64 0c-19.2 0-32 12.8-32 32s12.8 32 32 32l64 0L451.2 800c0 19.2 12.8 32 32 32s32-12.8 32-32l0-67.2 64 0c19.2 0 32-12.8 32-32s-12.8-32-32-32l-64 0 0-32 64 0c19.2 0 32-12.8 32-32s-12.8-32-32-32l-64 0 0-12.8L611.2 467.2z"  ></path>' +
    '' +
    '</symbol>' +
    '' +
    '<symbol id="icon-edit-1" viewBox="0 0 1024 1024">' +
    '' +
    '<path d="M839.91182 959.354678 183.358563 959.354678c-65.929572 0-119.380948-53.435003-119.380948-119.379924l0-656.553257c0-65.927525 53.451376-119.380948 119.380948-119.380948l432.723446 0c8.239662 0 14.933107 6.67605 14.933107 14.915711l0 29.843702c0 8.256034-6.693446 14.932084-14.933107 14.932084L213.202265 123.732046c-49.450249 0-89.535199 40.083927-89.535199 89.533153l0 596.86483c0 49.450249 40.08495 89.535199 89.535199 89.535199l596.86483 0c49.450249 0 89.533153-40.08495 89.533153-89.535199L899.600247 407.250284c0-8.239662 6.692423-14.932084 14.932084-14.932084l29.846772 0c8.236592 0 14.912641 6.693446 14.912641 14.932084l0 432.724469C959.290721 905.919674 905.840368 959.354678 839.91182 959.354678zM892.519991 248.944815 768.484024 131.853004l37.663808-37.815257c29.123294-29.222555 77.007885-29.997198 106.986663-1.698688l15.502066 14.627139c29.964452 28.299533 30.65416 74.940806 1.533936 104.180757L892.519991 248.944815zM301.541219 600.744183l124.020618 117.094882-182.516894 62.447261L301.541219 600.744183zM862.389764 279.21012 455.675692 687.589111 331.655074 570.495252 738.370169 162.119331 862.389764 279.21012z"  ></path>' +
    '' +
    '</symbol>' +
    '' +
    '<symbol id="icon-news_light" viewBox="0 0 1024 1024">' +
    '' +
    '<path d="M896 170.666667H128c-36.266667 0-64 27.733333-64 64v554.666666c0 36.266667 27.733333 64 64 64h768c36.266667 0 64-27.733333 64-64V234.666667c0-34.133333-27.733333-64-64-64z m21.333333 618.666666c0 12.8-8.533333 21.333333-21.333333 21.333334H128c-12.8 0-21.333333-8.533333-21.333333-21.333334V234.666667c0-12.8 8.533333-21.333333 21.333333-21.333334h768c12.8 0 21.333333 8.533333 21.333333 21.333334v554.666666z"  ></path>' +
    '' +
    '<path d="M192 531.2h256c12.8 0 21.333333-8.533333 21.333333-21.333333V298.666667c0-12.8-8.533333-21.333333-21.333333-21.333334H192c-12.8 0-21.333333 8.533333-21.333333 21.333334v211.2c0 12.8 8.533333 21.333333 21.333333 21.333333z m21.333333-211.2h213.333334v168.533333H213.333333V320zM832 296.533333H554.666667c-12.8 0-21.333333 8.533333-21.333334 21.333334s8.533333 21.333333 21.333334 21.333333h277.333333c12.8 0 21.333333-8.533333 21.333333-21.333333s-8.533333-21.333333-21.333333-21.333334zM684.8 467.2c12.8 0 21.333333-8.533333 21.333333-21.333333s-8.533333-21.333333-21.333333-21.333334h-128c-12.8 0-21.333333 8.533333-21.333333 21.333334s8.533333 21.333333 21.333333 21.333333h128zM832 682.666667H192c-12.8 0-21.333333 8.533333-21.333333 21.333333s8.533333 21.333333 21.333333 21.333333h640c12.8 0 21.333333-8.533333 21.333333-21.333333s-8.533333-21.333333-21.333333-21.333333z"  ></path>' +
    '' +
    '</symbol>' +
    '' +
    '</svg>'
  var script = function() {
    var scripts = document.getElementsByTagName('script')
    return scripts[scripts.length - 1]
  }()
  var shouldInjectCss = script.getAttribute("data-injectcss")

  /**
   * document ready
   */
  var ready = function(fn) {
    if (document.addEventListener) {
      if (~["complete", "loaded", "interactive"].indexOf(document.readyState)) {
        setTimeout(fn, 0)
      } else {
        var loadFn = function() {
          document.removeEventListener("DOMContentLoaded", loadFn, false)
          fn()
        }
        document.addEventListener("DOMContentLoaded", loadFn, false)
      }
    } else if (document.attachEvent) {
      IEContentLoaded(window, fn)
    }

    function IEContentLoaded(w, fn) {
      var d = w.document,
        done = false,
        // only fire once
        init = function() {
          if (!done) {
            done = true
            fn()
          }
        }
        // polling for no errors
      var polling = function() {
        try {
          // throws errors until after ondocumentready
          d.documentElement.doScroll('left')
        } catch (e) {
          setTimeout(polling, 50)
          return
        }
        // no errors, fire

        init()
      };

      polling()
        // trying to always fire before onload
      d.onreadystatechange = function() {
        if (d.readyState == 'complete') {
          d.onreadystatechange = null
          init()
        }
      }
    }
  }

  /**
   * Insert el before target
   *
   * @param {Element} el
   * @param {Element} target
   */

  var before = function(el, target) {
    target.parentNode.insertBefore(el, target)
  }

  /**
   * Prepend el to target
   *
   * @param {Element} el
   * @param {Element} target
   */

  var prepend = function(el, target) {
    if (target.firstChild) {
      before(el, target.firstChild)
    } else {
      target.appendChild(el)
    }
  }

  function appendSvg() {
    var div, svg

    div = document.createElement('div')
    div.innerHTML = svgSprite
    svgSprite = null
    svg = div.getElementsByTagName('svg')[0]
    if (svg) {
      svg.setAttribute('aria-hidden', 'true')
      svg.style.position = 'absolute'
      svg.style.width = 0
      svg.style.height = 0
      svg.style.overflow = 'hidden'
      prepend(svg, document.body)
    }
  }

  if (shouldInjectCss && !window.__iconfont__svg__cssinject__) {
    window.__iconfont__svg__cssinject__ = true
    try {
      document.write("<style>.svgfont {display: inline-block;width: 1em;height: 1em;fill: currentColor;vertical-align: -0.1em;font-size:16px;}</style>");
    } catch (e) {
      console && console.log(e)
    }
  }

  ready(appendSvg)


})(window)