<?php
/**
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */

namespace Shop\Controller;
use Common\Controller\HanchaoController;
class BaseController extends HanchaoController{
	public function _initialize(){
		parent::_initialize ();
		$shop_info=session('shop_info');
		define('MID',$shop_info['id']);
		$this->assign('MID',MID);
        $this->assign('shop_info',$shop_info);
		$notauthmodule=array("Register","Oauth");
        if( !MID && !in_array(CONTROLLER_NAME,$notauthmodule)){// 还没登录 跳转到登录页面
			cookie('shop_forward',U('Shop/'.CONTROLLER_NAME.'/'.ACTION_NAME));
			$this->redirect('Shop/Register/shop_login');
		}
		$ismobile=is_mobile();$ismobile_cookie=$_COOKIE['ismobile'];
        if($ismobile && !$ismobile_cookie && !in_array(CONTROLLER_NAME,array('App','Pay','Weixin','Oauth','Ajax'))){ $this->redirect('Mobile/Index/index'); exit;}   

		$index_nav_list = require_once ROOT_PATH."/Public/data/shop_nav_config.php";
        $menu_moudle=CONTROLLER_NAME;
        $menu_action=ACTION_NAME;
        $menu_tab=I('param.tabid');
        $menu_param=I('param.');
        $tplseo_title=$index_nav_list[$menu_moudle]['son'][$menu_action]['name'].'_'.$index_nav_list[$menu_moudle]['name'];
        $tplseo_keywords=$shop_info['name'].','.C('WEB_SITE_TITLE');
        $tplseo_description=$shop_info['name'].','.C('WEB_SITE_TITLE');
        $this->assign('tplseo_title',$tplseo_title.'_'.$shop_info['name'].'_'.C('WEB_SITE_TITLE'));
        $this->assign('tplseo_keywords',$tplseo_keywords);
        $this->assign('tplseo_description',$tplseo_description);
		$this->assign('menu_moudle',$menu_moudle);
		$this->assign('menu_action',$menu_action);
		$this->assign('menu_tab',$menu_tab);
		$this->assign('menu_param',$menu_param);
		$this->assign('index_nav_list',$index_nav_list);

    }
    public function add() {//公共添加
        $model = D (CONTROLLER_NAME);$pk=ucfirst($model->getPk ());$id = intval(I($model->getPk ()));
        if($id){$do='getBy'.$pk;$vo = $model->$do ( $id );$this->assign ( 'info', $vo );}
        $this->display ('edit');
    }
    public function insert() {//公共插入
        $model = D (CONTROLLER_NAME);
        //echo $model;exit;
        if (false === $model->create ()) {$this->error ( $model->getError () );}
        $id = $model->add();
        if ($id !==false) {
            if(in_array(CONTROLLER_NAME,$this->cache_model)){savecache(CONTROLLER_NAME);}
            if($_POST['isajax'])$this->assign('dialog','1');
            $jumpUrl = $_POST['forward'] ? $_POST['forward'] : U(CONTROLLER_NAME.'/index');
            $this->assign ( 'jumpUrl',$jumpUrl );
            $this->success (L('ADD_OK'));
        } else {$this->error (L('ADD_ERROR').': '.$model->getDbError());}
    }
    public function edit() {//公共编辑
        $model = D (CONTROLLER_NAME);
        $pk=ucfirst($model->getPk ());
        $id = intval(I($model->getPk ()));
        // if(empty($id))   $this->error(L('do_empty'));
        $do='getBy'.$pk;
        $vo = $model->field(true)->$do ($id);
        $this->assign ($vo);
        $this->assign ('info',$vo);
        $this->display ();
    }
    
    public function update ( $model='' ,$data='', $where='1' , $msg='' ){
        if(!$model)$model=CONTROLLER_NAME;
        if(!$data)$data=D($model)->create();
        $jumpUrl = I('forward') ? I('forward') : U(CONTROLLER_NAME.'/index');
        $id    = array_unique((array)I('id',0));
        $id    = is_array($id) ? implode(',',$id) : $id;
        $where = $where=='1'?array('id' => array('in', $id )):array_merge( array('id' => array('in', $id )),(array)$where);
        $msg   = array_merge( array('success'=>L('EDIT_OK'), 'error'=>L('EDIT_ERROR'), 'url'=>$jumpUrl ,'ajax'=>IS_AJAX) , (array)$msg );
        $res=D($model)->where($where)->save($data);
        if( $res!==false ) {
            if(in_array(CONTROLLER_NAME,$this->cache_model)){savecache(CONTROLLER_NAME);}
            $this->success($msg['success'],$msg['url'],$msg['ajax']);
        }else{$this->error($msg['error'],$msg['url'],$msg['ajax']);}
    }
    public function view() {//公共查看
        $model = D (CONTROLLER_NAME);
        $pk=ucfirst($model->getPk ());
        $id = intval(I($model->getPk ()));
        if(empty($id))$this->error(L('PARAM_ERROR'));
        $do='getBy'.$pk;
        if(!empty($request))$this->assign ('views',serialize($request));
        $vo = $model->field(true)->$do($id);
        $this->assign($vo);
        $this->display ();
    }
    public function index() {//公共首页
        $map=I('param.');
        if(!empty($param_map))$map=empty($map)?$param_map:array_merge($map,$param_map);
        if(!empty($map['keyword'])){
            $keyword_fields=I('keyword_fields','name');
            if(str_exists($keyword_fields,',')){
                $map[$keyword_fields]=array('like','%'.$map['keyword'].'%');
            }else{
                $field_arr=explode(',',$keyword_fields);$where=array();
                foreach($field_arr as $v){
                    $where[$v]  = array('like', '%'.$map['keyword'].'%');
                }
                if($where){
                    $where['_logic'] = 'or';
                    $map['_complex'] = $where;
                }
            }unset($map['keyword'],$map['keyword_fields']);
        }
        $list = $this->lists(CONTROLLER_NAME,$map);
        $this->assign('list', $list);
        $this->display();
    }
    public function delete(){//公共删除
        $mod=D(CONTROLLER_NAME);
        $id=I('id');
        if (isset($id) && is_array($id)) {
            $ids = implode(',', $id);
            $result=$mod->delete($ids);
        } else {
            $id = intval($id);
            $result=$mod->delete($id);
        }
        if($result!==false){
            if(in_array(CONTROLLER_NAME,$this->cache_model)){savecache(CONTROLLER_NAME);}
            $this->success(L('DO_OK'));
        }else{$this->error(L('DO_ERROR'));}
    }
    public function status(){//公共状态
        $mod = D(CONTROLLER_NAME);
        $id     = intval(I('id'));
        $type	= I('type');
        $values = $mod->where('id='.$id)->field($type)->find();
        $data[$type]=($values[$type]+1)%2;
        $res=$mod->where('id='.$id)->save($data);
        if(in_array(CONTROLLER_NAME,$this->cache_model)){savecache(CONTROLLER_NAME);}
        $this->ajaxReturn($data[$type]);
    }
    public function sort(){//公共排序
        $model = D (CONTROLLER_NAME);$pk = $model->getPk ();
        $sorts = I('param.sort');
        $id     = intval(I('id'));
        if(!is_array($sorts) && isset($id))$sorts = array($id=>$sorts);
        if(empty($sorts))   $this->error(L('PARAM_ERROR'));
        foreach ($sorts as $id=>$sort){
            $result=$model->save(array($pk=>$id,'sort'=>intval($sort)));
        }
        if(in_array(CONTROLLER_NAME,$this->cache_model)) savecache(CONTROLLER_NAME);
        $jumpUrl = I('forward')?I('forward'):U(CONTROLLER_NAME.'/index');
        $this->assign("jumpUrl",$jumpUrl);
        if($result!==false){
            $this->success(L('EDIT_OK'));
        }else{$this->error(L('EDIT_ERROR'));}
    }
}
?>