<?php
/**
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */

namespace Shop\Controller;
use Think\Controller;
class IndexController extends BaseController {
    public function index(){
    	$shop_info=session('shop_info');
        $power=array();
        $pmap['id']=array('in','25,26,27');
        $powerinfo=M('ProjectLabel')->where($pmap)->select();
        foreach($powerinfo as $key=>$val){
            $power[$val['id']]=$val;
            $where=array();
            $where['shop_id']=MID;
            $where['label_id']=$val['id'];
            $power[$val['id']]['publish_wait']=M('ProjectLabelLink')->where($where)->getField('publish_wait');
        }
        $this->assign('powerinfo',$power);

    	//店铺等级、系统公告、单品销售排名
    	$this->other_info(MID);
    	//店铺及商品提示
            $this->shop_goods(MID);
    	//交易提示
    	$this->order(MID);
	//昨日销售量统计
	$this->sell_num(MID);
            //店铺评分
             $shop_score=D('Common/Shops')->get_shop(MID);
             $this->assign('shop_score',$shop_score['data']);
	$this->assign($shop_info);
	$this->display();
    }
    private function other_info($shop_id){
    	//店铺等级
    	$data=M('Shops')->where('id='.$shop_id)->field('rank,end_time')->find();
    	$rank=D('Common/Shops')->format_shop_item($data);
    	//系统公告
        	$m_map['catid']=2;
        	$notice=M('Article')->where($m_map)->field(true)->order('sort asc,addtime desc')->limit(6)->select();
	//单品销售排名
	$where['status']=1;
	$where['shop_id']=$shop_id;
	$hotlist=M('Goods')->where($where)->field(true)->order('sell_count desc,addtime desc')->limit(10)->select();
	$this->assign('rank_format',$rank['rank_format']);
	$this->assign('notice',$notice);
	$this->assign('hotlist',$hotlist);
    }
    //销售量统计
    private function sell_num($shop_id){
    	$day=strtotime(date('Y-m-d',strtotime("-1 day")));
    	$today=strtotime(date('Y-m-d',NOW_TIME));
    	$map['shop_id']=$shop_id;
    	$map['pay_time']=array('between',array($day,$today));
            	$sell_money=M('OrderInfo')->where($map)->sum('goods_allmoney');
    	$sell_num=M('OrderInfo')->where($map)->field('id')->count();
            	$month=strtotime(date('Y-m',strtotime("last month")));
            	$tmonth=strtotime(date('Y-m',NOW_TIME));
             $map['pay_time']=array('between',array($month,$tmonth));
    	$msell_money=M('OrderInfo')->where($map)->sum('goods_allmoney');
    	$msell_num=M('OrderInfo')->where($map)->field('id')->count();
    	$this->assign('sell_money',$sell_money);
    	$this->assign('sell_num',$sell_num);
    	$this->assign('msell_money',$msell_money);
    	$this->assign('msell_num',$msell_num);
    }
    //获取交易提示
    private function order($shop_id){
    	//待付款
    	$t_map['shop_id']=$shop_id;
	$no_pay=D('Common/Shops')->shop_all_order($t_map,2,1);
	//待发货
	$no_ship=D('Common/Shops')->shop_all_order($t_map,3,1);
	//退款中
	$t_map['pay_status']=3;
	$t_map['status']=6;
	$t_map['shipping_status']=1;
	$no_back=M('OrderInfo')->where($t_map)->field('id')->count();
	//已退款
	$t_map['status']=7;
	$all_back=M('OrderInfo')->where($t_map)->field('id')->count();
	//退货中
	$t_map['status']=6;
	$t_map['shipping_status']=array('gt',1);
	$no_refunds=M('OrderInfo')->where($t_map)->field('id')->count();
	//已退货
	$t_map['status']=7;
	$refunds=M('OrderInfo')->where($t_map)->field('id')->count();
	$this->assign('no_pay',$no_pay);
	$this->assign('no_ship',$no_ship);
	$this->assign('no_back',$no_back);
	$this->assign('all_back',$all_back);
	$this->assign('no_refunds',$no_refunds);
	$this->assign('refunds',$refunds);
    }
    //商品及店铺提示
    private function shop_goods($shop_id){
    	//所有商品
    	$map['shop_id']=$shop_id;
             $map['is_delete']=0;
    	$all_count=M('Goods')->where($map)->field('id')->count();
    	//出售商品
    	$sell_count=D('Common/Shops')->get_goods_count($shop_id);
    	//下架商品
    	$map['status']=0;
    	$usell_count=M('Goods')->where($map)->field('id')->count();
    	//待回复咨询
             unset($map['is_delete']);
    	$map['type']=2;
    	$service_count=M('Service')->where($map)->field('id')->count();
    	$this->assign('all_count',$all_count);
    	$this->assign('sell_count',$sell_count);
    	$this->assign('usell_count',$usell_count);
    	$this->assign('service_count',$service_count);
    }
    
    public function statistics(){
        //收藏店铺数
        $map['shop_id']=MID;
        $collect_shops=M('ShopsCollect')->where($map)->count();
        //收藏商品数
        $where['shop_id']=MID;
        $goods=M('Goods')->where($map)->field('id')->select();
        $collect_goods=0;
        foreach ($goods as $k => $val) {
            $g_map['goods_id']=$val['id'];
            $result=M('GoodsCollect')->where($g_map)->field('id')->count();
            $collect_goods+=$result;
        }
        //商品数量
        $goods_num=count($goods);
        //近30天下单数
        $lastdate=strtotime(date('Y-m-d',strtotime("-30 day")));
        $today=strtotime(date('Y-m-d',NOW_TIME));
        $order_map['shop_id']=MID;
        $order_map['pay_time']=array('between',array($lastdate,$today));
        $order_count=M('OrderInfo')->where($order_map)->count();
        $order_money=M('OrderInfo')->where($order_map)->sum('goods_allmoney');
        $order_avg=M('OrderInfo')->where($order_map)->avg('goods_allmoney');
        //下单会员数
        $order_member=M('OrderInfo')->where($order_map)->count();
        //销售走势
        $this->sales_trend($this->shop_info['id']);
        $this->hotgoods($this->shop_info['id']);
        $this->assign('order_member',$order_member);
        $this->assign('order_money',$order_money);
        $this->assign('order_avg',$order_avg);
        $this->assign('order_count',$order_count);
        $this->assign('collect_shops',$collect_shops);
        $this->assign('collect_goods',$collect_goods);
        $this->assign('goods_num',$goods_num);
        $tabid=I('param.tabid');
        if(!empty($tabid)) $this->display($tabid);
        else $this->display();
    }
    //店铺走势折线图
    private function sales_trend($shop_id){
        $postdata=I('param.');
        $map['shop_id']=$shop_id;
         if(empty($postdata['date_to'])){
            $today=strtotime(date('Y-m-d',NOW_TIME));
            $postdata['date_to']=time_format($today,'Y-m-d');
        }
        if(empty($postdata['date_from']))$postdata['date_from']=time_format(strtotime(date('Y-m-d',strtotime("-6 month"))),'Y-m-d');
        $map['addtime'][]=array('EGT',strtotime($postdata['date_from']));
        $map['addtime'][]=array('elt',strtotime($postdata['date_to']));
        $order_money = M('OrderInfo')->where($map)->field("sum(order_amount) as l_money,DATE_FORMAT(FROM_UNIXTIME(addtime),'%Y年%m月') as l_month")->group("DATE_FORMAT(FROM_UNIXTIME(addtime),'%Y年%m月')")->select();
        $order_num = M('OrderInfo')->where($map)->group("DATE_FORMAT(FROM_UNIXTIME(addtime),'%Y年%m月')")->count('id');
        $months[5]["time"]=time_format(NOW_TIME,'Y年m月');
        for($i=1;$i<6;$i++){$months[(5-$i)]["time"]=time_format(strtotime('-'.$i.' month'),'Y年m月');}
        foreach($order_money  as $v){
            $order_moneys[$v['l_month']] = $v['l_money'];
            $order_nums[$v['l_month']]=$order_num;
        }
        $name=array("订单金额（元）","订单数量（个）");
        $formart = array('order_moneys'=>$order_moneys,'order_nums'=>$order_nums);
        $formarttime =  array_keys($order_moneys);
        $formart = echarts_time_formarts($formart,$formarttime);
        $money_count = array(
                "legend"=>array('data'=>array($name[0],$name[1])),
                "xaxis"=>array("type"=>"category","data"=>$formarttime),     
                "series"=>array(
                    array("name"=>$name[0],"type"=>"line","stack"=>$name[0],"data"=>array_values($formart['order_moneys'])),
                    array("name"=>$name[1],"type"=>"line","stack"=>$name[1],"data"=>array_values($formart['order_nums']))
                ),
        );
        $ec = new \Common\Vendor\Echarts();
        $this->assign('Area_countm',$ec->show('Area_countm', $money_count,'line','销售额统计'));
        $this->assign($postdata);
    }
    private function hotgoods($shop_id){
        $map['shop_id']=$shop_id;
        $hot_goods=M('Goods')->where($map)->order('sell_count desc')->limit(5)->select();
        $this->assign('hot_goods',$hot_goods);
        $map['shop_id']=array('neq',0);
        $fellow_goods=M('Goods')->where($map)->order('sell_count desc')->limit(5)->select();
        $this->assign('fellow_goods',$fellow_goods);
    }
    //系统消息
    public function system_message(){
    $tabid=I('param.tabid');
             $shopinfo=session('shop_info');
    $map['touid']=$shopinfo['uid'];
            $map['type']=2;
            $pagesize=empty($pagesize)?C('WEB_DEFAULT_PAGE'):$pagesize;
            $info=page_list('Message',$map,'status asc,addtime desc',true,$pagesize);
            $this->assign($info);
    if(!empty($tabid)) $this->display($tabid);
    else $this->display();
    }
    //平台消息管理
    public function min_view(){
        $id=I('id');
        if($id){
            $where['id']=$id;
            $info=M('Message')->where($where)->field('title,content')->find();
            $this->assign($info);
        }
    $this->display();
    }
    
    public function goodsadd(){
        $this->redirect('Shop/goods/add');
    }
    
    public function orderindex(){
    	$this->redirect('Shop/Order/index');
    }
    
    public function backindex(){
    	$this->redirect('Shop/Order/back');
    }
    
    public function modifypsw(){
    	$this->redirect('Shop/Account/modify_psw');
    }
}
?>