<?php
/**
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */

namespace Shop\Controller;
use Think\Controller;
class OrderController extends BaseController {
	
    public function index(){
		$postdata=I('param.');
		$tabid=$postdata['tabid'];
		if(empty($tabid)){
			$all_order=D('Common/Shops')->shop_all_order($postdata,'','',10);
		}elseif($tabid=='no_pay'){
			$all_order=D('Common/Shops')->shop_all_order($postdata,'no_pay');
		}elseif($tabid=='no_ship'){
			$all_order=D('Common/Shops')->shop_all_order($postdata,'no_ship');
		}elseif($tabid=='yes_ship'){
			$all_order=D('Common/Shops')->shop_all_order($postdata,'yes_ship');
		}elseif($tabid=='no_comment'){
			$all_order=D('Common/Shops')->shop_all_order($postdata,'no_comment');
		}elseif($tabid=='no_group'){
			$all_order=D('Common/Shops')->shop_all_order($postdata,'no_group');
		}
		$tabid=$tabid?$tabid:'index';
		$this->assign($all_order);$this->assign($postdata);
        $this->display($tabid);
    }
	
	public function ship_info(){
		$order_id=I('id');
		$order_info=M('OrderInfo')->where('id='.$order_id)->field('order_sn,id')->find();
		$this->assign($order_info);
		$shipping_list=M('Shipping')->where('status=1')->field('code,name')->select();
        foreach($shipping_list as $k=>$v){
            $shipping_info[$v['code']]=$v['name'];
        }
        $this->assign('shipping',$shipping_info);
		$this->display();
	}
	
	public function ship(){
		$postdata=I('param.');
		$postdata['admin_id']=MID;
		$postdata['type']='Shop';//店铺发货日志
		$return=D('Common/OrderInfo')->ship_goods($postdata);
		$this->ajaxReturn($return);
	}
	
	public function change_ship_free(){
		$id=I('param.id');
		//订单信息
		$info=M('OrderInfo')->where('id='.$id)->field('id,order_sn,goods_amount,order_amount,delivery_fee')->find();
		//付款单信息
		$where['is_delete'] = 0;
		$where['order_id'] = array("like", "%," . $id . ",%");
		$need_pay = M("PayLog")->where($where)->getField('need_pay');
		$info['order_amount']=$info['order_amount']>$need_pay?$need_pay:$info['order_amount'];
		$this->assign($info);
		$this->display();
	}
	
	public function change_ship(){
		$post=I('param.');
		$post['admin_id']=MID;
		$post['type']='Shop';//店铺修改运费日志
		$return=D('Common/OrderInfo')->change_ship_free($post);
		$this->ajaxReturn($return);
	}
	
    public function shipping(){
		$postdata=I('param.');
		$tabid=$postdata['tabid'];
		if(empty($tabid)){$list=D('Shipping')->ship_list();$this->assign($list);}
		$tabid=$tabid?$tabid:'shipping';
        $this->display($tabid);
    }
	
    public function edit_shipping(){
		$postdata=I('param.');
		$tabid=$postdata['tabid'];
		if(!$postdata['id']){$this->redirect('Order/shipping');}
		$ship_info=D('Shipping')->ship_info($postdata);
		$this->assign($ship_info);
		
		$tabid=$tabid?$tabid:'edit_shipping';
		$this->assign('menu_action_current','shipping');
        $this->display($tabid);
    }
	
    public function add_ship(){
		$postdata=I('param.');
		$return=D('Shipping')->add_ship($postdata);
		if($return['status']){$return['url']=U('Shop/Order/shipping');}
        $this->ajaxReturn($return);
    }
	
    public function update_ship(){
		$postdata=I('param.');
		$return=D('Shipping')->update_ship($postdata);
		if($return['status']){$return['url']=U('Shop/Order/shipping');}
        $this->ajaxReturn($return);
    }
	
    public function del_ship(){
		$postdata=I('param.');
		$return=D('Shipping')->del_ship($postdata);
		if($return['status']){$return['url']=U('Shop/Order/shipping');}
        $this->ajaxReturn($return);
    }
	
    public function comment(){
		$postdata=I('param.');
		$tabid=$postdata['tabid'];
		if(empty($tabid)){
			$list=D('Comment')->comment_list();
			foreach ($list['list'] as $k => $v) {
            if(!empty($v['img']))
	            {
	                $list['list'][$k]['img']=unserialize($v['img']);
	            }
        	}
        	$this->assign($list);
		}
		$tabid=$tabid?$tabid:'comment';
        $this->display($tabid);
    }
	
	public function return_comment(){
		$id=I('id');
		$info=M('Comment')->where('id='.$id)->field(true)->find();
		$this->assign($info);$this->display();
	}
	
	public function do_return_comment(){
		$postdata=I('param.');
		$return=D('Comment')->return_comment($postdata);
		$this->ajaxReturn($return);
	}
	public function del_comment()
	{
		$id=I('param.id');
		if($id)
		{
			$map['status']=0;
			$where['id']=$id;
			$count=M('Comment')->where($where)->save($map);
			if($count>0)
			{
				$this->success("删除成功");
			}
			else
			{
				$this->error("删除失败");
			}
		}
	}

	
    public function back(){
		$postdata=I('param.');
		$tabid=$postdata['tabid'];
		if(empty($tabid)){
			$return=D('ReturnGoods')->return_list();$this->assign($return);
		}elseif($tabid=='refund'){
			$return=D('ReturnGoods')->refund_list();$this->assign($return);
		}
		$tabid=$tabid?$tabid:'back';
        $this->display($tabid);
    }
	
    public function confirm_goods(){
		$post['id']=I('id');
		$post['admin_id']=MID;//操作日志用
		$post['type']='Shop';//操作日志用
		$return=D('Common/OrderInfo')->confirm_goods($post);
        $this->ajaxReturn($return);
    }
    
    public function info(){
        $id = I('param.id');
        $postdata=I('param.');
        $tabid=$postdata['tabid'];
        if(empty($id)){$this->redirect('Order/index');}
        $map['shop_id']=$this->shop_info['id'];
        $map['id']=$id;
        $order_info = M('OrderInfo')->where($map)->field(true)->find();
        if($order_info) {
            //print_r($order_info);
            $order_info['end_time'] = $order_info['addtime'] + C('CANCEL_ORDER_TIME') * 86400;//取消订单倒计时
            $order_info['ship_time'] = M('ShipOrder')->where('order_id=' . $id)->getField('ship_time');//发货时间
            $order_info['get_time'] = M('ShipOrder')->where('order_id=' . $id)->getField('get_time');//收货时间
            $order_info['comment_time'] = M('Comment')->where('order_id=' . $id)->getField('addtime');//评论时间
            $order_goods = M('OrderGoods')->where('order_id=' . $id)->field(true)->select();
			$ordershipping=M('ShipOrder')->where('order_id='.$id)->field(true)->select();
			$ordership=array();
			foreach($ordershipping as $v){
				$goodsid=explode(',',$v['goods_id']);
				foreach($goodsid as $val){
					$ordership[$val]=$v;
				}
			}
			foreach ($order_goods as $k => $v) {
				if(!empty($v['goods_attr'])){//获取属性和货号
					$attr = unserialize($v['goods_attr']);
					$order_goods[$k]['attr_name'] = $attr['name'];
					$attr_map['attr_key']=$attr['key'];
					$attr_map['goods_id']=$v['goods_id'];
					$attr_sn=M('goods_attr_stock')->where($attr_map)->getField('goods_attr_sn');
					$order_goods[$k]['attr_sn'] = $attr_sn;
				}
				$order_goods[$k]['img'] = idtoname($v['goods_id'], 'Goods', 'img');
				$order_goods[$k]['goods_integral'] = $v['goods_integral'];
				$order_goods[$k]['shipping']=$ordership[$v['goods_id']];
			}
            $invoice = unserialize($order_info['invoice_info']);//print_r($invoice);
            $this->assign($invoice);
            $this->assign($order_info);
            $this->assign('order_goods', $order_goods);
        }else{
            $this->error('无此操作权限');
        }
        $this->assign('menu_action_current', 'index');
        $tabid=$tabid?$tabid:'info';
        $this->display($tabid);
    }
    
    public function confirm_order(){
    	$order_id = I('get.order_id');
    	if(empty($order_id)){
    		$return['status'] = 0;
    		$return['msg'] = '参数错误';
    		$this->ajaxReturn($return);
    	}
    	$save['status'] = 2;
    	$save['confirm_time'] = NOW_TIME;
    	$map['id'] = $order_id;
    	$update = M('OrderInfo')->where($map)->save($save);
    	if($update){
    		$return['status'] = 1;
    		$return['url'] = U('Order/index');
    		$return['msg'] = '订单确认成功';
    	}else{
    		$return['status'] = 0;
    		$return['msg'] = '订单确认失败';
    	}
    	$this->ajaxReturn($return);
    }
    public function invoice(){
        $order_id=I('request.order_id');
        $invoice_info=D('Common/OrderInfo')->get_order_invoice_info($order_id);
        $this->assign($invoice_info);
        $this->display();
    }
}
?>