<?php
/**
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */

namespace Shop\Controller;
use Think\Controller;
class RegisterController extends BaseController {
	public function _initialize(){
		parent :: _initialize();
		$map['pid']=0;
		$map['status']=1;
		$this->cate_id=M('goods_category')->where($map)->field('id,name')->select();
		$this->assign('cate_id',$this->cate_id);
		$this->is_login=session('shop_info');
	}
	
    public function index(){
		if($this->is_login)$this->redirect('Index/index');//已登录
		$member_info=session('member_info');
		$u_map['uid']=$member_info['id'];
		$u_map['status']=1;
		$is_shop=M('Shops')->where($u_map)->count();
		if($is_shop){$this->error('您已是店铺，请登录',U('Register/shop_login'));}
		if($member_info){//已提交未审核
			$map['uid']=$member_info['id'];
			$map['publish_wait']=0;
			$shop_info=M('ShopsSubmit')->where($map)->find();
			$is_cate=explode(',',$shop_info['cate_ids']);
			$cate_ids=$this->cate_id;
			if($is_cate && $cate_ids){
				foreach($cate_ids as $k=>$v){
					$cate_ids[$k]['on']=in_array($v['id'],$is_cate);
				}
				$this->assign('cate_id',$cate_ids);
			}
			$this->assign('memberinfo',$member_info);
			$this->assign($shop_info);
		}
        $this->assign('tplseo_title','店铺申请_'.C('WEB_SITE_TITLE'));
        $this->display();
    }
	
	public function add_shop(){
		$postdata=I('param.');
		$result=D('Common/ShopLogin')->register($postdata);
		if($result['status'])$result['url']=U('Member/index/index');
		$this->ajaxReturn($result);
	}
	public function content(){
		if($this->is_login)$this->redirect('Index/index');//已登录
		$art_id=I('art_id');if(empty($art_id))$this->error('参数错误');
		$info=M('Article')->where('id='.$art_id)->field(true)->find();
		$this->assign($info);
		$this->assign('art_id',$art_id);
		$this->assign('tplseo_title','入驻申请_'.C('WEB_SITE_TITLE'));
        $this->display();
    }
	
	public function shop_login(){
		if($this->is_login)$this->redirect('Index/index');//已登录
        $this->assign('tplseo_title','店铺登录_'.C('WEB_SITE_TITLE'));
		$this->display();
	}
	
	public function dologin(){
		$data=I('post.');
        $return=D("Common/ShopLogin")->check_login($data);
        $this->ajaxReturn($return);
	}
	
	public function log_out(){
        $return=D("Common/ShopLogin")->logout();
        if($return['status']==1){
            $this->success($return['info'],$return['url']);
        }else{
            $this->error($return['info'],$return['url']);
        }
	}
	
	public function modify_paw(){
        $data=I('post.');
        $return=D("Common/ShopLogin")->resetpwd($data);
		if($return['status']==1){$return['url']=U('Shop/Register/shop_login');}
        $this->ajaxReturn($return);
	}
	
	public function getpassword(){
        if($this->is_login)$this->redirect('Index/index');//已登录
        $this->assign('tplseo_title','找回密码_'.C('WEB_SITE_TITLE'));
		$this->display();
	}
	
	public function get_shop(){
		$data=I('post.');
        $return=D("Common/ShopLogin")->get_shop($data);
        $this->ajaxReturn($return);
	}
	
	public function getpwd(){
		$data=I('post.');
        $return=D("Common/ShopLogin")->getpwd($data);
		if($return['status']==1){$return['url']=U('Shop/Register/shop_login');}
        $this->ajaxReturn($return);
	}
}
?>