<?php
/**
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */

namespace Shop\Controller;
use Think\Controller;
class StatisticsController extends BaseController {
    public function _initialize()
    {
        parent::_initialize();
        $shop_info=session('shop_info');
        if(empty($shop_info['id'])) $this->error('身份过期，请重新登录',U('Shop/Register/shop_login'));
    }
    
    public function statistics(){
        //收藏店铺数
        $map['shop_id']=MID;
        $collect_shops=M('ShopsCollect')->where($map)->count();
        //收藏商品数
        $where['shop_id']=MID;
        $goods=M('Goods')->where($map)->field('id')->select();
        $collect_goods=0;
        foreach ($goods as $k => $val) {
            $g_map['goods_id']=$val['id'];
            $result=M('GoodsCollect')->where($g_map)->field('id')->count();
            $collect_goods+=$result;
        }
        //商品数量
        $goods_num=M('Goods')->where($map)->count();
        //近30天下单数
        $lastdate=strtotime(date('Y-m-d',strtotime("-30 day")));
        $today=strtotime(date('Y-m-d',NOW_TIME));
        $order_map['shop_id']=MID;
        $order_map['pay_time']=array('between',array($lastdate,$today));
        $order_count=M('OrderInfo')->where($order_map)->count();
        $order_money=M('OrderInfo')->where($order_map)->sum('goods_allmoney');
        $order_avg=M('OrderInfo')->where($order_map)->avg('goods_allmoney');
        //下单会员数
        $order_member=M('OrderInfo')->where($order_map)->count();
        //销售走势
        $this->sales_trend($this->shop_info['id']);
        $this->hotgoods($this->shop_info['id']);
        $this->assign('order_member',$order_member);
        $this->assign('order_money',$order_money);
        $this->assign('order_avg',$order_avg);
        $this->assign('order_count',$order_count);
        $this->assign('collect_shops',$collect_shops);
        $this->assign('collect_goods',$collect_goods);
        $this->assign('goods_num',$goods_num);
        $tabid=I('param.tabid');
        if(!empty($tabid)) $this->display($tabid);
        else $this->display();
    }
    //店铺走势折线图
    private function sales_trend($shop_id){
        $postdata=I('param.');
        $map['shop_id']=$shop_id;
         if(empty($postdata['date_to'])){
            $today=strtotime(date('Y-m-d',NOW_TIME));
            $postdata['date_to']=time_format($today,'Y-m-d');
        }
        if(empty($postdata['date_from']))$postdata['date_from']=time_format(strtotime(date('Y-m-d',strtotime("-6 month"))));
        $map['addtime'][]=array('EGT',strtotime($postdata['date_from']));
        $map['addtime'][]=array('elt',strtotime($postdata['date_to']));
        $order_money = M('OrderInfo')->where($map)->field("sum(order_amount) as l_money,DATE_FORMAT(FROM_UNIXTIME(addtime),'%Y年%m月') as l_month")->group("DATE_FORMAT(FROM_UNIXTIME(addtime),'%Y年%m月')")->select();
        $order_num = M('OrderInfo')->where($map)->group("DATE_FORMAT(FROM_UNIXTIME(addtime),'%Y年%m月')")->count('id');
        $months[5]["time"]=time_format(NOW_TIME,'Y年m月');
        for($i=1;$i<6;$i++){$months[(5-$i)]["time"]=time_format(strtotime('-'.$i.' month'),'Y年m月');}
        foreach($order_money  as $v){
            $order_moneys[$v['l_month']] = $v['l_money'];
            $order_nums[$v['l_month']]=$order_num;
        }
        $name=array("订单金额（元）","订单数量（个）");
        $formart = array('order_moneys'=>$order_moneys,'order_nums'=>$order_nums);
        $formarttime =  array_keys($order_moneys);
        $formart = echarts_time_formarts($formart,$formarttime);
        $money_count = array(
                "legend"=>array('data'=>array($name[0],$name[1])),
                "xaxis"=>array("type"=>"category","data"=>$formarttime),     
                "series"=>array(
                    array("name"=>$name[0],"type"=>"line","stack"=>$name[0],"data"=>array_values($formart['order_moneys'])),
                    array("name"=>$name[1],"type"=>"line","stack"=>$name[1],"data"=>array_values($formart['order_nums']))
                ),
        );
        $ec = new \Common\Vendor\Echarts();
        $this->assign('Area_countm',$ec->show('Area_countm', $money_count,'line','销售额统计'));
        $this->assign($postdata);
    }
    private function hotgoods($shop_id){
        $map['shop_id']=$shop_id;
        $hot_goods=M('Goods')->where($map)->order('sell_count desc')->limit(5)->select();
        $this->assign('hot_goods',$hot_goods);
        $map['shop_id']=array('neq',0);
        $fellow_goods=M('Goods')->where($map)->order('sell_count desc')->limit(5)->select();
        $this->assign('fellow_goods',$fellow_goods);
    }
    public function capital(){
        $list=D('Account')->account_list($post);
        $this->assign($list);$this->assign($post);
        $this->capital_trend($this->shop_info['id']);
        $tabid=I('param.tabid');
        if(!empty($tabid)) $this->display($tabid);
        else $this->display();
    }
    //折线图
    private function capital_trend($shop_id){
        $map['shop_id']=$shop_id;
        $lastdate=strtotime(date('Y-m-d',strtotime("-18 month")));
        $today=strtotime(date('Y-m-d',strtotime('first day of next month')));
        $map['change_time']=array('between',array($lastdate,$today));
        $map['change_type']=0;
        $order_infos = M('ShopbalanceLog')->where($map)->field("sum(change_num) as l_money,change_time as l_month")->group("DATE_FORMAT(FROM_UNIXTIME(change_time),'%Y年%m月')")->select();
        $map['change_type']=1;
        $order_info = M('ShopbalanceLog')->where($map)->field("sum(change_num) as l_money,change_time as l_month")->group("DATE_FORMAT(FROM_UNIXTIME(change_time),'%Y年%m月')")->select();
        $name = array("消费数","盈利数");
        foreach($order_info as $value){
            $file[date('Y-m',$value['l_month'])] = $value['l_money'];
        }
        foreach ($order_infos as $val) {
            $file_order[date('Y-m',$val['l_month'])] = $val['l_money'];
        }
        $formart = array('file'=>$file,'file_order'=>$file_order);
            $formarttime =  array_keys($file);
            $formart = echarts_time_formarts($formart,$formarttime);
            $cz_count = array(
            "legend"=>array('data'=>array($name[0],$name[1])),
            "xaxis"=>array("type"=>"category","data"=>$formarttime),     
            "series"=>array(
                0=>array("name"=>$name[0],"type"=>"line","stack"=>$name[0],"data"=>array_values($formart['file'])),
                1=>array("name"=>$name[1],"type"=>"line","stack"=>$name[1],"data"=>array_values($formart['file_order'])),
                            ),
            );
        $ec = new \Common\Vendor\Echarts();
        $this->assign('Area_countm',$ec->show('Area_countm', $cz_count,'line','账户明细统计'));
    }
    public function order(){
        $all_order=D('Common/Shops')->shop_all_order($postdata);
        $this->assign($all_order);
        $this->order_trend($this->shop_info['id']);
        $tabid=I('param.tabid');
        if(!empty($tabid)) $this->display($tabid);
        else $this->display();
    }
    private function order_trend($shop_id){
        $map['shop_id']=$shop_id;
        $lastdate=strtotime(date('Y-m-d',strtotime("-18 month")));
        $today=strtotime(date('Y-m-d',strtotime('first day of next month')));
        $map['pay_time']=array('between',array($lastdate,$today));
        //全部订单
        $order_info = M('OrderInfo')->where($map)->field("sum(order_amount) as l_money,DATE_FORMAT(FROM_UNIXTIME(pay_time),'%Y年%m月') as l_month")->group("DATE_FORMAT(FROM_UNIXTIME(pay_time),'%Y年%m月')")->select();
        //未付款
        $map['pay_status']=1;
        $map['status']=array('lt',3);
        //待发货
        $map['pay_status']=3;$map['shipping_status']=1;$map['status']=array('lt',3);
        //待收货
        $map['pay_status']=3;$map['shipping_status']=3;$map['status']=array('lt',3);
        //已完成
        $map['status']=3;
        $months[17]["time"]=time_format(NOW_TIME,'Y年m月');
        for($i=1;$i<18;$i++){$months[(17-$i)]["time"]=time_format(strtotime('-'.$i.' month'),'Y年m月');}
        foreach($order_info  as $k=>$v){
            foreach($months as $kk => $vv){
                if($vv["time"] == $v["l_month"]){
                    $montharr[$vv['time']] = $v["l_money"];$moneyarr[$vv['time']] = $v["l_money"];
                }
            }
        }
        $money_count = array(
                "legend"=>array('data'=>array("订单金额统计")),
                "xaxis"=>array("type"=>"category","data"=>array_keys($moneyarr)),     
                "series"=>array(
                    array("name"=>"订单金额统计","type"=>"line","stack"=>"订单金额统计",'itemStyle'=>array(),"data"=>array_values($moneyarr)),
                ),
            );
        $ec = new \Common\Vendor\Echarts();
        $this->assign('Area_countm',$ec->show('Area_countm', $money_count,'line','订单金额统计'));
    }
}
?>