<?php
/**
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */

namespace Shop\Model;
use Think\Model;
class PromotModel extends Model{
	protected $tableName = 'promot_act';
	
    public function sale_list($page_num){
		$shop_info=session('shop_info');
		$map['shop_id']=$shop_info['id'];
		$map['is_limit_time']=1;
		$field='id,act_name,start_time,end_time';
		$page_num=$page_num?$page_num:10;
		$list=page_list('PromotAct',$map,'id desc',$field,$page_num,'',1);
		return $list;
    }
	
	public function add_update($post){
		$return=array('status'=>0,'info'=>'');
		
		$shop_info=session('shop_info');
		$shop_id=$shop_info['id'];
		if(!$shop_id){$return['info']='登录信息错误';return $return;}
		
		$max['id']=$post['act_id'];
		$act_info= M('PromotAct')->where($max)->field(true)->find();
		
		if($post['id']){$no_map['id']=array('neq',$post['id']);}
		$no_map['pid']=$post['act_id'];
		$no_map['shop_id']=$shop_id;
		$have=M('PromotAct')->where($no_map)->count();
		if($have){$return['info']='您已添加了该促销';return $return;}
		
		//促销商品信息
		$goods_id=$post['goods_id'];
		$promot_price=$post['promot_price'];
		$promotes=array();
		foreach($goods_id as $k=>$v){
			$promotes[$k]['id']=$v;
			if(empty($promot_price[$v]) && $promot_price[$v]!=0){
				$return['info']='请填写信息';return $return;
			}elseif(!is_numeric($promot_price[$v]) || $promot_price[$v]<0){
				$return['info']='请填写正确信息！';return $return;
			}
			$promotes[$k]['promote_price']=$promot_price[$v];
		}
		//编辑或添加
		if($post){
			$data['act_name']=$act_info['act_name'];
			$data['img']=$act_info['img'];
			$data['big_img']=$act_info['big_img'];
			$data['start_time']=$act_info['start_time'];
			$data['end_time']=$act_info['end_time'];
			$data['shop_id'] = $shop_id;
			$data['is_limit_time'] = 1;
			$data['pid'] = $post['act_id'];
			if($post['id']){//修改
				$is_have['id']=$post['id'];
				$is_have['shop_id']=$shop_id;
				$res = M('PromotAct')->where($is_have)->save($data);
			//	if(!$res){$return['info']='修改失败';return $return;}
				$goods_infos=M('Goods')->where('promote_id='.$post['id'])->field(true)->select();
				foreach($goods_infos as $k=>$v){//清除商品以前的促销信息
					$goods_data=array();
					$goods_data['promote_id']=0;
					$goods_data['is_promote']=0;
					$goods_data['promote_start_time']=0;
					$goods_data['promote_end_time']=0;
					$goods_data['promote_price']=0;
					$map['id']=$v['id'];
					M('Goods')->where($map)->save($goods_data);
				}
				foreach($promotes as $k=>$v){//添加新的促销信息
					$goods_data=array();
					$goods_data['is_promote']=1;
					$goods_data['promote_id']=$post['id'];
					$goods_data['promote_start_time']=$act_info['start_time'];
					$goods_data['promote_end_time']=$act_info['end_time'];
					$goods_data['promote_price']=$promotes[$v['id']]['promote_price'];
					$map['id']=$v['id'];
					M('Goods')->where($map)->save($goods_data);
				}
			}else{//添加
				$res = M('PromotAct')->add($data);
				if($res){
					$goods_data=array();
					$goods_data['is_promote']=1;
					$goods_data['promote_id']=$res;
					$goods_data['promote_start_time']=$act_info['start_time'];
					$goods_data['promote_end_time']=$act_info['end_time'];
					foreach($promotes as $k=>$v){
						$goods_data['promote_price']=$v['promote_price'];
						$map['id']=$v['id'];
						M('Goods')->where($map)->save($goods_data);
					}
				}
			} 
			$return['status']=1;
			if($post['id']){
				$return['info']='编辑成功';
				action_log('shop_edit_sale', 'Shop', $post['id'], $shop_id);
			}else{
				$return['info']='添加成功';
				action_log('shop_add_sale', 'Shop', $res, $shop_id);
			}
			return $return;
		}		
	}
	
	
    public function promot_list($page_num){
		$shop_info=session('shop_info');
		$map['shop_id']=$shop_info['id'];
		$map['act_type']=array('in',array(1,2));
		$field='id,act_name,start_time,end_time,min_amount,max_amount';
		$page_num=$page_num?$page_num:10;
		$list=page_list('PromotAct',$map,'id desc',$field,$page_num,'',1);
		return $list;
    }
	
    public function promot_info($id){
		$act_info=M('PromotAct')->where('id='.$id)->field(true)->find();
		$ext_info=M('PromotExt')->where('act_id='.$id)->select();
		$rang_list='';
		foreach($ext_info as $k=>$v){
			if($v['style'] ==1){//分类
				$rang_list.="<label class='checkbox-inline'><input type='checkbox' checked='checked' name='act_rang_ext[]' value='".$v['style_ext_id']."' />".idtoname($v['style_ext_id'],'GoodsCategory','name','id',false)."</label>&nbsp;&nbsp;";
			}elseif($v['style'] ==2){//品牌
				$rang_list.="<label class='checkbox-inline'><input type='checkbox' checked='checked' name='act_rang_ext[]' value='".$v['style_ext_id']."' />".idtoname($v['style_ext_id'],'Brand','brand_name','id',false)."</label>&nbsp;&nbsp;";
			}elseif($v['style'] ==3){//商品
				$rang_list.="<label class='checkbox-inline'><input type='checkbox' checked='checked' name='act_rang_ext[]' value='".$v['style_ext_id']."' />".idtoname($v['style_ext_id'],'Goods','goods_name','id',false)."</label>&nbsp;&nbsp;";
			}elseif($v['style'] ==4){//拼团
				$rang_list.="<label class='checkbox-inline'><input type='checkbox' checked='checked' name='act_rang_ext[]' value='".$v['style_ext_id']."' />".idtoname($v['style_ext_id'],'Goods','goods_name','id',false)."</label>&nbsp;&nbsp;";
			}elseif($v['style'] ==6){//定金预售
				$rang_list.="<label class='checkbox-inline'><input type='checkbox' checked='checked' name='act_rang_ext[]' value='".$v['style_ext_id']."' />".idtoname($v['style_ext_id'],'Goods','goods_name','id',false)."</label>&nbsp;&nbsp;";
			}elseif($v['style'] ==7){//全额预售
				$rang_list.="<label class='checkbox-inline'><input type='checkbox' checked='checked' name='act_rang_ext[]' value='".$v['style_ext_id']."' />".idtoname($v['style_ext_id'],'Goods','goods_name','id',false)."</label>&nbsp;&nbsp;";
			}
		}
		$act_info['rang_list']=$rang_list;
		$act_info['act_rang']=$ext_info[0]['style'];
		$act_info['style_ext_id']=$ext_info[0]['style_ext_id'];
		$act_info['remarks']=$ext_info[0]['remarks'];
		return $act_info;
    }
	
    public function add_promot($post){
		$return=array('status'=>0,'info'=>'');
		
		$shop_info=session('shop_info');
		$shop_id=$shop_info['id'];
		if(!$shop_id){$return['info']='登录信息错误';return $return;}
		if(empty($post['act_name'])){$return['info']='请输入优惠名称';return $return;}
        if(empty($post['start_time']) || empty($post['end_time'])){$return['info']='请选择优惠活动时间范围';return $return;}
        if(empty($post['min_amount'])){$return['info']='请输入金额下限';return $return;}
        if(empty($post['max_amount'])){$return['info']='请输入金额上限';return $return;}
        if(empty($post['act_rang_txt'])){$return['info']='请选择商品';return $return;}
		//添加优惠活动
		$data['act_name']=$post['act_name'];
		$data['img']=$post['img'];
		$data['big_img']=$post['big_img'];
		$data['start_time']=strtotime($post['start_time']);
		$data['end_time']=strtotime($post['end_time']);
		$data['min_amount']=$post['min_amount'];
		$data['max_amount']=$post['max_amount'];
		$data['act_type'] = $post['act_type'];//减免折扣
		$data['act_type_ext'] = $post['act_type_ext'];//减免折扣的值
		$data['is_addup'] = $post['is_addup'];//叠加
		$data['is_pt'] = $post['is_pt'];//团购
		$data['is_presale'] = $post['is_presale'];//预售
		$data['group_number'] = $post['group_number'];//参团人数
		$data['group_time_limit'] = $post['group_time_limit'];//限制时间
		$data['buy_limit'] = $post['buy_limit'];//限购件数
		$data['shop_id']=$shop_id;
		$res = M('PromotAct')->add($data);
		if(!$res){$return['info']='添加失败';return $return;}
		
		//添加扩展表
		foreach($post['act_rang_ext'] as $k=>$v){
			$add['act_id']=$res;
			$add['style']=$post['act_range'];//分类、品牌、商品
			$add['style_ext_id']=$v;//分类、品牌、商品的值
			// $add['remarks'] = serialize($post['group_price']);//价格
			if($post['is_presale'] == 1){
				$price['group_price'] = $post['group_price'];
				$price['pre_money'] = $post['pre_money'];
				$add['remarks'] = serialize($price);//价格
			}else{
				$add['remarks'] = serialize($post['group_price']);//价格
			}
			M('PromotExt')->add($add);
			if($post['is_pt'] == 1){
				$mes['pt_id'] = $res;
				$map['id'] = $v;
				$update = M('Goods')->where($map)->save($mes);
			}
			if($post['is_presale'] == 1){
				$mes['pre_id'] = $res;
				$map['id'] = $v;
				$update = M('Goods')->where($map)->save($mes);
			}
		}
		$return['status']=1;
		$return['info']='添加成功';
		action_log('shop_add_promot', 'Shop', $res, $shop_id);
		return $return;
    }
	
    public function edit_promot($post){
		$return=array('status'=>0,'info'=>'');
		
		$shop_info=session('shop_info');
		$shop_id=$shop_info['id'];
		if(!$shop_id){$return['info']='登录信息错误';return $return;}
		if(!($post['id'])){$return['info']='参数错误';return $return;}
		
		//修改优惠活动
		$data['act_name']=$post['act_name'];
		$data['img']=$post['img'];
		$data['big_img']=$post['big_img'];
		$data['start_time']=strtotime($post['start_time']);
		$data['end_time']=strtotime($post['end_time']);
		$data['min_amount']=$post['min_amount'];
		$data['max_amount']=$post['max_amount'];
		$data['act_type'] = $post['act_type'];//减免折扣
		$data['act_type_ext'] = $post['act_type_ext'];//减免折扣的值
		$data['is_addup'] = $post['is_addup'];//叠加
		$data['is_pt'] = $post['is_pt'];//团购
		$data['is_presale'] = $post['is_presale'];//预售
		$data['group_number'] = $post['group_number'];//参团人数
		$data['group_time_limit'] = $post['group_time_limit'];//限制时间
		$data['buy_limit'] = $post['buy_limit'];//限购件数
		$map['shop_id']=$shop_id;
		$map['id']=$post['id'];
		$res = M('PromotAct')->where($map)->save($data);
		if($res===false){$return['info']='修改失败';return $return;}
		
		//修改扩展表
		if($post['is_pt'] == 1){
			$goodsid = M('PromotExt')->where('act_id='.$post['id'])->getField('style_ext_id');
			$goods['pt_id'] = 0;
			$save = M('Goods')->where('id='.$goodsid)->save($goods);
		}
		if($post['is_presale'] == 1){
			$goodsid = M('PromotExt')->where('act_id='.$post['id'])->getField('style_ext_id');
			$goods['pre_id'] = 0;
			$save = M('Goods')->where('id='.$goodsid)->save($goods);
		}
		M('PromotExt')->where('act_id='.$post['id'])->delete();
		foreach($post['act_rang_ext'] as $k=>$v){
			$add['act_id']=$post['id'];
			$add['style']=$post['act_range'];//分类、品牌、商品
			$add['style_ext_id']=$v;//分类、品牌、商品的值
			// $add['remarks'] = serialize($post['group_price']);//价格
			if($post['is_presale'] == 1){
				$price['group_price'] = $post['group_price'];
				$price['pre_money'] = $post['pre_money'];
				$add['remarks'] = serialize($price);//价格
			}else{
				$add['remarks'] = serialize($post['group_price']);//价格
			}
			M('PromotExt')->add($add);

			if($post['is_pt'] == 1){
				$goods_id['pt_id'] = $post['id'];
				$save = M('Goods')->where('id='.$v)->save($goods_id);
			}
			if($post['is_presale'] == 1){
				$goods_id['pre_id'] = $post['id'];
				$save = M('Goods')->where('id='.$v)->save($goods_id);
			}

		}
		$return['status']=1;
		$return['info']='修改成功';
		action_log('shop_edit_promot', 'Shop', $post['id'], $shop_id);
		return $return;
    }
	
    public function del_promot($postdata){
		$return=array('status'=>0,'info'=>'');
		
		$shop_info=session('shop_info');
		$shop_id=$shop_info['id'];
		if(!$shop_id){$return['info']='登录信息错误';return $return;}
		
		$ids=$postdata['check_id'];
		if(!$ids){$return['info']='请选择要删除的选项';return $return;}
		
		$map['id']=array('in',$ids);
		$map['shop_id']=$shop_id;
		$res=M('PromotAct')->where($map)->delete();
		if($res){
			$return['status']=1;
			$return['info']='删除成功';
			$maps['act_id']=array('in',$ids);
			if($postdata['is_pt'] == 1){
				$goodsid = M('PromotExt')->where($maps)->field('style_ext_id')->select();
				if(!empty($goodsid)){
					foreach ($goodsid as $key => $value) {
						$arr[] = $value['style_ext_id'];
					}
				}
				$where['id'] = array('IN',$arr);
				$m['pt_id'] = 0;
				$u = M('Goods')->where($where)->save($m);
			}
			if($postdata['is_presale'] == 1){
				$goodsid = M('PromotExt')->where($maps)->field('style_ext_id')->select();
				if(!empty($goodsid)){
					foreach ($goodsid as $key => $value) {
						$arr[] = $value['style_ext_id'];
					}
				}
				$where['id'] = array('IN',$arr);
				$m['pre_id'] = 0;
				$u = M('Goods')->where($where)->save($m);
			}
			M('PromotExt')->where($maps)->delete();
			if(is_array($ids)){
				foreach($ids as $k=>$v){action_log('shop_del_promot', 'Shop', $v, $shop_id);}
			}else{
				action_log('shop_del_promot', 'Shop', $ids, $shop_id);
			}
		}else{
			$return['info']='删除失败';
		}
		return $return;
    }
	
	
    public function bonus_list($page_num){
		$shop_info=session('shop_info');
		$map['shop_id']=$shop_info['id'];
		$field=true;
		$page_num=$page_num?$page_num:10;
		$list=page_list('Bonu',$map,'id desc',$field,$page_num,'',1);
		return $list;
    }
	
    public function add_bonus($post){
		$return=array('status'=>0,'info'=>'');
		
		$shop_info=session('shop_info');
		$shop_id=$shop_info['id'];
		if(!$shop_id){$return['info']='登录信息错误';return $return;}
		
		//添加
		$arr['type_name'] = $post['type_name'];
		$arr['type_money'] = $post['type_money'];
		$arr['min_goods_amount'] = $post['min_goods_amount'];
		if($post['type_value']){
			$promot_info=M('PromotAct')->where('id='.$post['type_value'])->field('start_time,end_time')->find();
			$arr['use_start_date'] = $promot_info['start_time'];
			$arr['use_end_date'] = $promot_info['end_time'];
		}else{
			$arr['use_start_date'] = strtotime($post['use_start_date']);
			$arr['use_end_date'] = strtotime($post['use_end_date']);
		}
		$arr['send_type'] = 5;//活动红包
		
		$arr['type'] = $post['type'];//适用范围:3活动
		$arr['type_value'] = $post['type_value'];
		$arr['shop_id'] = $shop_id;
		$res = M('Bonu')->add($arr);
		if($res){
			$return['status']=1;
			$return['info']='添加成功';
			action_log('shop_add_bonus', 'Shop', $res, $shop_id);
		}else{
			$return['info']='添加失败！';
		}
		return $return;
    }
	
    public function edit_bonus($post){
		$return=array('status'=>0,'info'=>'');
		
		$shop_info=session('shop_info');
		$shop_id=$shop_info['id'];
		if(!$shop_id){$return['info']='登录信息错误';return $return;}
		if(!($post['id'])){$return['info']='参数错误';return $return;}
		
		//编辑
		$arr['type_name'] = $post['type_name'];
		$arr['type_money'] = $post['type_money'];
		$arr['min_goods_amount'] = $post['min_goods_amount'];
		
		$promot_info=M('PromotAct')->where('id='.$post['type_value'])->field('start_time,end_time')->find();
		$arr['use_start_date'] = $promot_info['start_time'];
		$arr['use_end_date'] = $promot_info['end_time'];
		$arr['send_type'] = 5;//活动红包
		
		$arr['type'] = $post['type'];//适用范围:3活动
		$arr['type_value'] = $post['type_value'];
		$map['shop_id'] = $shop_id;
		$map['id']=$post['id'];
		$res = M('Bonu')->where($map)->save($arr);
		if($res!==false){
			$return['status']=1;
			$return['info']='编辑成功';
			action_log('shop_edit_bonus', 'Shop', $post['id'], $shop_id);
		}else{
			$return['info']='编辑失败！';
		}
		return $return;
    }
	
    public function del_bonus($postdata){
		$return=array('status'=>0,'info'=>'');
		
		$shop_info=session('shop_info');
		$shop_id=$shop_info['id'];
		if(!$shop_id){$return['info']='登录信息错误';return $return;}
		
		$ids=$postdata['check_id'];
		if(!$ids){$return['info']='请选择要删除的选项';return $return;}
		
		$map['id']=array('in',$ids);
		$map['shop_id']=$shop_id;
		$res=M('Bonu')->where($map)->delete();
		if($res){
			$return['status']=1;
			$return['info']='删除成功';
			if(is_array($ids)){
				foreach($ids as $k=>$v){action_log('shop_del_bonus', 'Shop', $v, $shop_id);}
			}else{
				action_log('shop_del_bonus', 'Shop', $ids, $shop_id);
			}
		}else{
			$return['info']='删除失败';
		}
		return $return;
    }
    
    public function get_sumnum($id,$pay_status){
    	$map['pt_id'] = array('eq',$id);
		$map['is_delete'] = 0;
		$map['status'] = array('neq',4);
		$map['type'] = array('eq',7);
		$map['pay_status'] = array('eq',$pay_status);

		$all_list = M('OrderInfo')->where($map)->field('id')->select();
		if(!empty($all_list)){
			foreach($all_list as $key=>$val){
				$arr[] = $val['id'];
			}
			$str_orderid = implode(',',$arr);
			$where['order_id'] = array('IN',$str_orderid);
			$num = M('OrderGoods')->where($where)->field('sum(goods_number) as num')->select();
			if(!empty($num)){
				foreach($num as $k=>$val){
					$return['sum_num'] = $val['num'];
				}
			}
		}
		return $return;
    }
}

?>