<?php
/**
 * @Copyright (C) 2017 汉潮 All rights reserved.
 * @License http://www.hanchao9999.com
 * @Author xiaogg <xiaogg@sina.cn>
 */

namespace Shop\Model;
use Think\Model;
class ShippingModel extends Model{
	
    public function ship_list($page_num){
		$shop_info=session('shop_info');
		$map['shop_id']=$shop_info['id'];
		$field=true;
		$page_num=$page_num?$page_num:10;
		$return=page_list('ShippingFee',$map,'id desc',$field,$page_num,'',1);
		if($return['list']){
			foreach($return['list'] as $k=>$v){
				$return['list'][$k]=$v;
				$return['list'][$k]['area_region']=explode(',',$v['area_region']);
			}
		}
		return $return;
    }
	
    public function ship_info($postdata){
		$id=$postdata['id'];if(!$id)return false;
		$shop_info=session('shop_info');
		$map['id']=$id;
		$map['shop_id']=$shop_info['id'];
		$ship_info=M('ShippingFee')->where($map)->find();
		if(!$ship_info)return false;
		$ship_info['configure']=unserialize($ship_info['configure']);
		$ship_info['area_region']=explode(',',$ship_info['area_region']);
		return $ship_info;
    }
	
    public function del_ship($postdata){
		$return=array('status'=>0,'info'=>'');
		$shop_info=session('shop_info');
		$ids=$postdata['check_id'];
		if(!$ids){$return['info']='请选择要删除的选项';return $return;}
		
		$map['id']=array('in',$ids);
		$map['shop_id']=$shop_info['id'];
		$res=M('ShippingFee')->where($map)->delete();
		if($res){
			$return['status']=1;
			$return['info']='删除成功';
		}else{
			$return['info']='删除失败';
		}
		return $return;
    }
	
	public function add_ship($postdata){
		$return=array('status'=>0,'info'=>'');
		
		$shop_info=session('shop_info');
		$shop_id=$shop_info['id'];
		if(!$shop_id){$return['info']='登录信息错误';return $return;}
        if(empty($postdata['regions'])){
            $return['info']='配送区域不得为空';return $return;
        }
		if($postdata['type']==1){
			$info_ship['type']=1;
			$info_ship['money']=$postdata['money'];
			$info_ship['first_weight']=$postdata['first_weight'];
			$info_ship['first_weight_money']=$postdata['first_weight_money'];
			$info_ship['x_weight']=$postdata['x_weight_1'];
			$info_ship['x_weight_money']=$postdata['x_weight_money_1'];
		}else{
			$info_ship['type']=2;
			$info_ship['money']=$postdata['money'];
			$info_ship['per_money']=$postdata['per_money'];
            $info_ship['x_weight']=$postdata['x_weight_2'];
            $info_ship['x_weight_money']=$postdata['x_weight_money_2'];
		}
		$data['configure']=serialize($info_ship);
		$data['name']=$postdata['name'];
		$regions=implode(',',$postdata['regions']);
		$data['area_region']=$regions;
		$data['shop_id']=$shop_id;
		$result=M('ShippingFee')->add($data);
		S("shop_shipping_fee_catch",'');
		if($result){
			$return['status']=1;$return['info']='添加成功';
		}else{
			$return['info']='添加失败';
		}
		return $return;
	}
	
	public function update_ship($postdata){
		$return=array('status'=>0,'info'=>'');
		
		$shop_info=session('shop_info');
		$shop_id=$shop_info['id'];
		if(!$shop_id){$return['info']='登录信息错误';return $return;}
        if(empty($postdata['regions'])){
            $return['info']='配送区域不得为空';return $return;
        }
		
		$id=$postdata['id'];if(!$id){$return['info']='参数错误';return $return;}
		
		if($postdata['type']==1){
			$info_ship['type']=1;
			$info_ship['money']=$postdata['money'];
			$info_ship['first_weight']=$postdata['first_weight'];
			$info_ship['first_weight_money']=$postdata['first_weight_money'];
			$info_ship['x_weight']=$postdata['x_weight_1'];
			$info_ship['x_weight_money']=$postdata['x_weight_money_1'];
		}else{
			$info_ship['type']=2;
			$info_ship['money']=$postdata['money'];
			$info_ship['per_money']=$postdata['per_money'];
            $info_ship['x_weight']=$postdata['x_weight_2'];
            $info_ship['x_weight_money']=$postdata['x_weight_money_2'];
		}
		$data['configure']=serialize($info_ship);
		$data['name']=$postdata['name'];
		$regions=implode(',',$postdata['regions']);
		$data['area_region']=$regions;
		$is_have['id']=$id;
		$is_have['shop_id']=$shop_id;
		$result=M('ShippingFee')->where($is_have)->save($data);
		S("shop_shipping_fee_catch",'');
		if($result !== false){
			$return['status']=1;$return['info']='修改成功';
		}else{
			$return['info']='修改失败';
		}
		return $return;
	}
    //快递打印
	public function ship_print($id){
	   $return=array('status'=>0,'info'=>'');$data=array();
	    if(empty($id)){$return['info']=L('PARAM_ERR');return $return;}
		$price='';
		$data['ship_info']=$ship_info = M('ShipOrder')->where('id='.$id)->field(true)->find();
        if(empty($ship_info)){$return['info']='发货信息不存在!';return $return;}
        
        
        $map=array();
        $map['code']=$ship_info['send_type'];
        $map['status']=1;
        $data['shipping']=$shipping=$this->where($map)->field(true)->find();
        if(empty($shipping)){$return['info']='快递方式不存在!';return $return;}
        $map=array();
        $map['id']=$ship_info['order_id'];
        $map['pay_status']=1;
		$data['order_info']=$order_info = M('OrderInfo')->where('id='.$ship_info['order_id'])->field(true)->find();
        if(empty($order_info) || $order_info['shipping_status']==1){$return['info']='订单信息不存在!';return $return;}
        
        //发货地址
        if($ship_info['shop_id']){//店铺发货
            $shopinfo=M('Shops')->where('id='.$ship_info['shop_id'])->field('name,contacts,phone,contacts_phone,postion,address')->find();
            $postion=array('','','');
            if($shopinfo){
                if($shopinfo['postion']){
                    $map=array();
                    $map['status']=1;
                    $map['id']=array('in',$shopinfo['postion']);
                    $areainfo=M('Area')->where($map)->field('id,name')->select();
                    if($areainfo){
                        $areaarr=array();
                        foreach($areainfo as $v){$areaarr[$v['id']]=$v['name'];}
                        $postarr=explode(',',$shopinfo['postion']);
                        foreach($postarr as $v){$postion[]=$areaarr[$v];}
                    }
                }
                $lable_box['t_shop_province'] = $postion[0]; //网店-省份
                $lable_box['t_shop_city'] = $postion[1]; //网店-城市
                $lable_box['t_shop_district'] = $postion[2]; //网店-区/县
                $lable_box['t_shop_name'] = $shopinfo['name']; //网店-名称
                $lable_box['t_shop_tel'] = $shopinfo['phone']?$shopinfo['phone']:$shopinfo['contacts_phone']; //网店-联系电话
                $lable_box['t_shop_address'] = $_CFG['address']; //网店-地址
            }
        }else{//自营发货
            $lable_box['t_shop_province'] =$lable_box['t_shop_city'] =$lable_box['t_shop_district'] ='';
            $lable_box['t_shop_name']=C('WEB_SITE_NAME').'自营';
            $lable_box['t_shop_tel']=C('WEB_SITE_PHONE');
            $lable_box['t_shop_address']=C('SHIPPING_ADDRESS');
        }
        //收货地址
        $region_array=$regions=array();
        if($order_info['province'])$regions[]=$order_info['province'];
        if($order_info['city'])$regions[]=$order_info['city'];
        if($order_info['district'])$regions[]=$order_info['district'];
        if($regions){        
            $map=array();
            $map['status']=1;
            $map['id']=array('in',$regions);
            $areainfo=M('Area')->where($map)->field('id,name')->select();
            if($areainfo){
                foreach($areainfo as $v){$region_array[$v['id']]=$v['name'];}
            }
        }
        
        //打印单模式
        if ($shipping['print_model'] == 2){
            
            
            $shipping['print_bg'] = empty($shipping['print_bg']) ? '' :format_url($shipping['print_bg']);
            
            if (!empty($shipping['print_bg']))
            {
                $_size = @getimagesize($shipping['print_bg']);
                if ($_size != false){$shipping['print_bg_size'] = array('width' => $_size[0], 'height' => $_size[1]);}
            }
            if (empty($shipping['print_bg_size'])){$shipping['print_bg_size'] = array('width' => '1024', 'height' => '600');}
            
            
            $lable_box = array();            
            //$lable_box['t_shop_country'] = $region_array[$_CFG['shop_country']]; //网店-国家
            if($ship_info['shop_id']){//店铺发货
                $shopinfo=M('Shops')->where('id='.$ship_info['shop_id'])->field('name,contacts,phone,contacts_phone,postion,address')->find();
                $postion=array('','','');
                if($shopinfo){
                    if($shopinfo['postion']){
                        $map=array();
                        $map['status']=1;
                        $map['id']=array('in',$shopinfo['postion']);
                        $areainfo=M('Area')->where($map)->field('id,name')->select();
                        if($areainfo){
                            $areaarr=array();
                            foreach($areainfo as $v){$areaarr[$v['id']]=$v['name'];}
                            $postarr=explode(',',$shopinfo['postion']);
                            foreach($postarr as $v){$postion[]=$areaarr[$v];}
                        }
                    }
                    $lable_box['t_shop_province'] = $postion[0]; //网店-省份
                    $lable_box['t_shop_city'] = $postion[1]; //网店-城市
                    $lable_box['t_shop_district'] = $postion[2]; //网店-区/县
                    $lable_box['t_shop_name'] = $shopinfo['name']; //网店-名称
                    $lable_box['t_shop_tel'] = $shopinfo['phone']?$shopinfo['phone']:$shopinfo['contacts_phone']; //网店-联系电话
                    $lable_box['t_shop_address'] = $_CFG['address']; //网店-地址
                }
            }else{//自营发货
                $lable_box['t_shop_province'] =$lable_box['t_shop_city'] =$lable_box['t_shop_district'] ='';
                $lable_box['t_shop_name']=C('WEB_SITE_NAME').'自营';
                $lable_box['t_shop_tel']=C('WEB_SITE_PHONE');
                $lable_box['t_shop_address']=C('SHIPPING_ADDRESS');
            }
            $region_array=$regions=array();
            if($order_info['province'])$regions[]=$order_info['province'];
            if($order_info['city'])$regions[]=$order_info['city'];
            if($order_info['district'])$regions[]=$order_info['district'];
            if($regions){        
                $map=array();
                $map['status']=1;
                $map['id']=array('in',$regions);
                $areainfo=M('Area')->where($map)->field('id,name')->select();
                if($areainfo){
                    foreach($areainfo as $v){$region_array[$v['id']]=$v['name'];}
                }
            }
            
           //$lable_box['t_customer_country'] = $region_array[$order['country']]; //收件人-国家
            $lable_box['t_customer_province'] = $region_array[$order_info['province']]; //收件人-省份
            $lable_box['t_customer_city'] = $region_array[$order_info['city']]; //收件人-城市
            $lable_box['t_customer_district'] = $region_array[$order_info['district']]; //收件人-区/县
            $lable_box['t_customer_mobel'] = $order_info['mobile']; //收件人-手机
            $lable_box['t_customer_post'] = $order_info['zipcode']; //收件人-邮编
            $lable_box['t_customer_address'] = $order_info['address']; //收件人-详细地址
            $lable_box['t_customer_name'] = $order_info['consignee']; //收件人-姓名

            $gmtime_utc_temp = NOW_TIME; //获取 UTC 时间戳
            $lable_box['t_year'] = date('Y', $gmtime_utc_temp); //年-当日日期
            $lable_box['t_months'] = date('m', $gmtime_utc_temp); //月-当日日期
            $lable_box['t_day'] = date('d', $gmtime_utc_temp); //日-当日日期

            $lable_box['t_order_no'] = $order_info['order_sn']; //订单号-订单
            $lable_box['t_order_postscript'] = $order_info['temp']; //备注-订单
            $lable_box['t_order_best_time'] = $order_info['best_time']; //送货时间-订单
            $lable_box['t_pigeon'] = '√'; //√-对号
            $lable_box['t_custom_content'] = ''; //自定义内容

            //标签替换
            $temp_config_lable = explode('||,||', $shipping['config_lable']);
            if (!is_array($temp_config_lable))
            {
                $temp_config_lable[] = $shipping['config_lable'];
            }
            foreach ($temp_config_lable as $temp_key => $temp_lable)
            {
                $temp_info = explode(',', $temp_lable);
                if (is_array($temp_info))
                {
                    $temp_info[1] = $lable_box[$temp_info[0]];
                }
                $temp_config_lable[$temp_key] = implode(',', $temp_info);
            }
            $shipping['config_lable'] = implode('||,||',  $temp_config_lable);

        } elseif($shipping['shipping_print']) {
            
            $view= new \Think\view;
            $shipping['shipping_print']= $view->fetch("" , $shipping['shipping_print']);
        }
        $data['shipping']=$shipping;
        $return['status']=1;
        $return['info']=$data;
        return $return;
	}
}

?>