/**
 * 添加提现银行
 */
function add_banks(){
	var check=check_add_banks();
	if(!check){return false;}
	
	var query = new Object;
	query = $("form[name='add_bank']").serialize();
	$.ajax({
		type:"POST",
		url:APP+"Shop/Account/add_bank",
		data:query,
		success:function(data){
			if(data.status==1){
				$.showSuccess(data.info,0,'hc');
				window.location.href=data.url;
			}else{
				$.showErr(data.info,0,'hc');
			}
		}
	});
}
/**
 * 添加验证
 */
function check_add_banks(){
	var bankname=$("select[name='bankname']").val();
	if(bankname==''){$.showErr('请选择开户行',0,'hc');return false;}
	
	var bankcode=$("input[name='bankcode']").val();
	if(bankcode==''){$.showErr('请填写银行账号',0,'hc');return false;}
	if(isNaN(bankcode)){$.showErr('请填写正确的银行账号',1,'hc');return false;}
	
	var name=$("input[name='name']").val();
	if(name==''){$.showErr('请填写真实姓名',0,'hc');return false;}
	if(!name.match(/\S/)){$.showErr('请填写正确的真实姓名',1,'hc');return false;}
	return true;
}
/**
 * 提现
 */
function go_withdrawals(){
	var money = $("#money").val();
	var param = money.match("^[0-9]*$");
	if(money<=0 || isNaN(money) || !param){$.showErr('金额应为整数',0,'hc');return false;}
	
	var is_code = $('#is_code').val();
	if(is_code == 1){
		var mobilecode = $("#mobilecode").val();
		if(!mobilecode){$.showErr('请填写短信验证码',0,'hc');return false;}
	}
	
	var query = new Object;
	query = $("form[name='withdrawals']").serialize();
	$.ajax({
		type:"POST",
		url:APP+"Shop/Account/go_withdrawals",
		data:query,
		success:function(data){
			if(data.status==1){
				$.showSuccess(data.info,1,'hc');
				window.location.href=data.url;
			}else{
				$.showErr(data.info,1,'hc');
			}
		}
	});
}
/**
 * 发送短信
 */
var InterValObj; //timer变量，控制时间
var curCount;//当前剩余秒数
function sendMessage() {
	var money = $("#money").val();
	var param = money.match("^[0-9]*$");
	if(money == ''){$.showErr('请填写金额',0,'hc');return false;}
	if(money<=0 || isNaN(money) || !param){$.showErr('金额应为整数',0,'hc');return false;}
	var min_money = $("#min_money").val();
	if(parseFloat(min_money)>0 && parseFloat(min_money)>parseFloat(money)){
		$.showErr('不能低于最低提现金额'+min_money,0,'hc');return false;
	}
	
	var time = $("#true_time").val();
	var count = parseInt(time); //间隔函数，1秒执行
    curCount = count;
    var mobile=$('#mobile').val();
    var param="mobile=" + mobile + "&unique=" + 4 + "&type=" + 3;
    $.ajax({
        type: "POST",
        dataType: "JSON",
        url: APP+"Home/Ajax/sendsms",
        data:param,
        success:function (data){
			if(data.status==0){
				$.showErr(data.msg,0,'hc');
				return false;
			}else{
				$("#btnSendCode").attr("disabled", "true");
				$("#btnSendCode").val("请在" + curCount + "秒内输入验证码");
				InterValObj = window.setInterval(SetRemainTime, 1000); //启动计时器，1秒执行一次
			}
		}
	});
}
/**
 * timer处理函数
 */
function SetRemainTime() {
    if (curCount == 0) {
        window.clearInterval(InterValObj);//停止计时器
        $("#btnSendCode").removeAttr("disabled");//启用按钮
        $("#btnSendCode").val("重新发送验证码");
    }else {
        curCount--;
        $("#btnSendCode").val("请在" + curCount + "秒内输入验证码");
    }
}