-- Adminer 2.3.2 dump
SET NAMES utf8;
SET foreign_key_checks = 0;
SET time_zone = 'SYSTEM';
SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';DROP TABLE IF EXISTS `hanchao_account_log`;
CREATE TABLE `hanchao_account_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员id',
  `adminid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '管理员id',
  `storeid` int(10) NOT NULL COMMENT '商户id(备用)',
  `change_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0加1减',
  `change_num` varchar(10) NOT NULL COMMENT '变动数量',
  `end_num` decimal(20,2) NOT NULL COMMENT '变动后数量',
  `change_time` int(10) NOT NULL DEFAULT '0' COMMENT '变更时间',
  `change_desc` varchar(255) NOT NULL DEFAULT '0' COMMENT '变更描述',
  `type` tinyint(2) NOT NULL DEFAULT '1' COMMENT '1资金2冻结资金3等级积分4消费积分',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '操作类型，1为充值，2为提现，3为管理员调节，4支付,5为其他类型6确认收货7登录赠消费积分8登录赠等级积分9注册赠消费积分10注册赠等级积分',
  `role` int(10) NOT NULL DEFAULT '0' COMMENT '角色 0会员 1店铺 2供货商 3平台等等4手续费(不计入平台资金统计)',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='用户账户变更记录';


DROP TABLE IF EXISTS `hanchao_action`;
CREATE TABLE `hanchao_action` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` char(30) NOT NULL DEFAULT '' COMMENT '行为唯一标识',
  `title` char(80) NOT NULL DEFAULT '' COMMENT '行为说明',
  `remark` char(140) NOT NULL DEFAULT '' COMMENT '行为描述',
  `rule` text NOT NULL COMMENT '行为规则',
  `log` text NOT NULL COMMENT '日志规则',
  `type` tinyint(2) unsigned NOT NULL DEFAULT '1' COMMENT '类型',
  `status` tinyint(2) NOT NULL DEFAULT '0' COMMENT '状态',
  `update_time` int(11) unsigned NOT NULL DEFAULT '0' COMMENT '修改时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=49 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='系统行为表';

INSERT INTO `hanchao_action` (`id`, `name`, `title`, `remark`, `rule`, `log`, `type`, `status`, `update_time`) VALUES
(1,	'user_login',	'用户登录',	'积分+10，每天一次',	'table:member|field:points|condition:id={$self} AND status>-1|rule:points+0|cycle:24|max:1;table:member|field:usepoints|condition:id={$self} AND status>-1|rule:usepoints+0|cycle:24|max:1;',	'[user|get_nickname]在[time|time_format]登录了后台',	2,	1,	1439804931),
(2,	'add_article',	'发布文章',	'积分+5，每天上限5次',	'table:member|field:score|condition:uid={$self}|rule:score+5|cycle:24|max:5',	'',	2,	0,	1380173180),
(3,	'review',	'评论',	'评论积分+1，无限制',	'table:member|field:score|condition:uid={$self}|rule:score+1',	'',	2,	1,	1383285646),
(5,	'add_document_topic',	'发表讨论',	'积分+5，每天上限10次',	'table:member|field:score|condition:uid={$self}|rule:score+5|cycle:24|max:10',	'',	2,	0,	1383285551),
(7,	'admin_login',	'管理员登录',	'管理员登录',	'',	'',	1,	1,	1402553899),
(8,	'update_order',	'管理员编辑订单',	'记录管理员更新订单',	'',	'',	1,	1,	1402553892),
(9,	'manage_order',	'管理员操作订单',	'对订单进行 确认 发货等操作',	'',	'',	1,	1,	1402553887),
(10,	'user_manage_order',	'用户操作订单',	'用户操作订单',	'',	'',	2,	1,	1402556650),
(11,	'shop_add_sale',	'添加限时促销',	'添加限时促销',	'',	'',	3,	1,	1490770437),
(12,	'shop_edit_sale',	'修改限时促销',	'修改限时促销',	'',	'',	3,	1,	1490771291),
(13,	'shop_add_promot',	'添加优惠活动',	'添加优惠活动',	'',	'',	3,	1,	1490771363),
(14,	'shop_edit_promot',	'编辑优惠活动',	'编辑优惠活动',	'',	'',	3,	1,	1490771415),
(15,	'shop_del_promot',	'删除活动',	'删除活动',	'',	'',	3,	1,	1490771649),
(16,	'shop_add_bonus',	'添加优惠券',	'添加优惠券',	'',	'',	3,	1,	1490771729),
(17,	'shop_edit_bonus',	'编辑优惠券',	'编辑优惠券',	'',	'',	3,	1,	1490771799),
(18,	'shop_del_bonus',	'删除优惠券',	'删除优惠券',	'',	'',	3,	1,	1490771886),
(19,	'shop_ship_order',	'订单发货',	'订单发货',	'',	'',	3,	1,	1490929002),
(20,	'admin_ship_order',	'订单发货',	'订单发货',	'',	'',	1,	1,	1490937726),
(21,	'user_confirm_order',	'确认收货',	'确认收货',	'',	'',	2,	1,	1490945654),
(22,	'user_add_comment',	'订单评论',	'订单评论',	'',	'',	2,	1,	1491039996),
(23,	'shop_ship_free',	'修改运费',	'修改运费',	'',	'',	3,	1,	1491364290),
(24,	'admin_ship_free',	'修改运费',	'修改运费',	'',	'',	1,	1,	1491368641),
(25,	'user_del_order',	'删除订单',	'删除订单',	'',	'',	2,	1,	1491533631),
(26,	'admin_del_order',	'删除订单',	'删除订单',	'',	'',	1,	1,	1491533663),
(27,	'shop_confirm_goods',	'退货确认收货',	'退货确认收货',	'',	'',	3,	1,	1491616620),
(28,	'admin_confirm_good',	'退货的确认收货',	'退货的确认收货',	'',	'',	1,	1,	1491616682),
(29,	'admin_return_goods',	'处理退货',	'处理退货',	'',	'',	1,	1,	1491622908),
(30,	'user_cancel_order',	'取消订单',	'取消订单',	'',	'',	2,	1,	1491879951),
(31,	'admin_cancel_order',	'取消订单',	'取消订单',	'',	'',	1,	1,	1491879989),
(32,	'user_apply_return',	'申请退货',	'申请退货',	'',	'',	2,	1,	1491881231),
(33,	'user_refund_audit',	'申请退款',	'申请退款',	'',	'',	2,	1,	1491881882),
(34,	'admin_do_refund',	'处理退款',	'处理退款',	'',	'',	1,	1,	1491974145),
(36,	'user_get_money',	'申请提现',	'申请提现',	'',	'',	2,	1,	1492588753),
(37,	'user_recharge',	'申请充值',	'申请充值',	'',	'',	2,	1,	1492588953),
(38,	'shop_login',	'店铺登录',	'店铺登录',	'',	'',	3,	1,	1493194906),
(39,	'shop_resetpwd',	'修改密码',	'修改密码',	'修改密码',	'',	3,	1,	1493275292),
(40,	'shop_getpwd',	'找回密码',	'找回密码',	'',	'',	3,	1,	1493285313),
(41,	'shop_get_money',	'申请提现',	'店铺提现',	'',	'',	3,	1,	1494310335),
(42,	'user_add_bank',	'添加提现银行',	'添加提现银行',	'',	'',	2,	1,	1494318375),
(43,	'shop_add_bank',	'添加提现银行',	'添加提现银行',	'',	'',	3,	1,	1494318397),
(44,	'do_shop_tixian',	'处理店铺提现',	'处理店铺提现',	'',	'',	1,	1,	1494379807),
(45,	'do_user_tixian',	'处理会员提现',	'处理会员提现',	'',	'',	1,	1,	1494379868),
(46,	'do_balance',	'店铺结算',	'店铺结算',	'',	'',	1,	1,	1494395946),
(47,	'shop_recharge',	'申请充值',	'申请充值',	'',	'',	3,	1,	1494553831),
(48,	'cesss',	'sdfsdf',	'sadf',	'asdf',	'asdf',	1,	1,	1499675552);

DROP TABLE IF EXISTS `hanchao_action_log`;
CREATE TABLE `hanchao_action_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `action_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '行为id',
  `user_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '执行用户id',
  `action_ip` bigint(20) NOT NULL COMMENT '执行行为者ip',
  `model` varchar(50) NOT NULL DEFAULT '' COMMENT '触发行为的表',
  `record_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '触发行为的数据id',
  `remark` varchar(255) NOT NULL DEFAULT '' COMMENT '日志备注',
  `mark` varchar(255) NOT NULL DEFAULT '0' COMMENT '自定义备注',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '状态',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '执行行为的时间',
  PRIMARY KEY (`id`),
  KEY `action_id_ix` (`action_id`),
  KEY `user_id_ix` (`user_id`),
  KEY `action_ip_ix` (`action_ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='行为日志表';


DROP TABLE IF EXISTS `hanchao_addons`;
CREATE TABLE `hanchao_addons` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(40) NOT NULL COMMENT '插件名或标识',
  `title` varchar(20) NOT NULL DEFAULT '' COMMENT '中文名',
  `description` varchar(255) DEFAULT NULL COMMENT '插件描述',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态',
  `config` text COMMENT '配置',
  `author` varchar(40) DEFAULT '' COMMENT '作者',
  `version` varchar(20) DEFAULT '' COMMENT '版本号',
  `create_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '安装时间',
  `has_adminlist` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '是否有后台列表',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='插件表';


DROP TABLE IF EXISTS `hanchao_admin`;
CREATE TABLE `hanchao_admin` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '用户ID',
  `username` varchar(50) NOT NULL COMMENT '用户名',
  `password` char(32) NOT NULL COMMENT '密码',
  `salt` char(6) NOT NULL DEFAULT '0' COMMENT '干扰码',
  `email` char(32) NOT NULL COMMENT '用户邮箱',
  `mobile` char(15) NOT NULL COMMENT '用户手机',
  `truename` varchar(20) NOT NULL DEFAULT '' COMMENT '姓名',
  `qq` char(10) NOT NULL DEFAULT '' COMMENT 'qq号',
  `name` varchar(255) NOT NULL COMMENT '收款人姓名',
  `bankname` varchar(255) NOT NULL COMMENT '银行名称',
  `bankcode` varchar(255) NOT NULL COMMENT '银行卡号',
  `bankkai` varchar(255) NOT NULL COMMENT '开户行',
  `login_count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '登录次数',
  `reg_ip` bigint(15) NOT NULL DEFAULT '0' COMMENT '注册IP',
  `reg_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '注册时间',
  `last_login_ip` bigint(15) NOT NULL DEFAULT '0' COMMENT '最后登录IP',
  `last_login_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '最后登录时间',
  `store_id` smallint(5) unsigned NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '会员状态',
  PRIMARY KEY (`id`),
  KEY `username` (`username`),
  KEY `email` (`email`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='会员表';

INSERT INTO `hanchao_admin` (`id`, `username`, `password`, `salt`, `email`, `mobile`, `truename`, `qq`, `name`, `bankname`, `bankcode`, `bankkai`, `login_count`, `reg_ip`, `reg_time`, `last_login_ip`, `last_login_time`, `store_id`, `status`) VALUES
(1,	'admin',	'21232f297a57a5a743894a0e4a801fc3',	'123456',	'admin@hanchao9999.com',	'15088888888',	'管理员',	'123456',	'',	'',	'',	'',	2008,	0,	0,	3232235875,	1505093695,	0,	1);

DROP TABLE IF EXISTS `hanchao_affiliate_log`;
CREATE TABLE `hanchao_affiliate_log` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `order_id` mediumint(8) NOT NULL COMMENT '订单id',
  `addtime` int(10) NOT NULL COMMENT '添加时间',
  `uid` mediumint(8) NOT NULL COMMENT '分成会员',
  `user_name` varchar(60) DEFAULT NULL COMMENT '会员名称',
  `money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '可用余额',
  `point` int(10) NOT NULL DEFAULT '0' COMMENT '积分',
  `desc` varchar(200) NOT NULL COMMENT '分成描述',
  `separate_type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0,按推荐注册，1,按订单分成',
  `is_separate` tinyint(1) NOT NULL COMMENT '0：未分成，1：已分成，2：:取消分成',
  `tiem` int(10) NOT NULL COMMENT '注册开始时效',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='分成日志表';


DROP TABLE IF EXISTS `hanchao_applyfx`;
CREATE TABLE `hanchao_applyfx` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL COMMENT '会员id',
  `name` varchar(100) NOT NULL COMMENT '用户名',
  `mobile` varchar(20) NOT NULL COMMENT '手机号',
  `reson` varchar(1000) NOT NULL COMMENT '申请理由',
  `creattime` int(10) NOT NULL COMMENT '申请时间',
  `updatetime` int(10) NOT NULL COMMENT '更新时间',
  `status` tinyint(1) NOT NULL COMMENT '0待审核1成功2失败',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='申请分销商';


DROP TABLE IF EXISTS `hanchao_area`;
CREATE TABLE `hanchao_area` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '地区ID',
  `name` char(30) NOT NULL COMMENT '地区名称',
  `pinyin` char(35) NOT NULL COMMENT '地区拼音',
  `pid` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '地区父ID',
  `status` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '状态',
  `sort` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '排序',
  `temp` varchar(255) NOT NULL COMMENT '附加参数',
  `letter` char(2) NOT NULL COMMENT '首字母',
  `is_poen` tinyint(2) NOT NULL COMMENT '是否开通城市分站',
  `level` tinyint(2) NOT NULL COMMENT '等级。1:省2:市3:县',
  `region` smallint(5) unsigned NOT NULL COMMENT '省级地理区域划分',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3364 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='地区表';

INSERT INTO `hanchao_area` (`id`, `name`, `pinyin`, `pid`, `status`, `sort`, `temp`, `letter`, `is_poen`, `level`, `region`) VALUES
(1,	'中国',	'﻿ZhongGuo',	0,	0,	0,	'',	'﻿Z',	0,	0,	0),
(2,	'北京市',	'﻿BeiJingShi',	1,	1,	0,	'',	'﻿B',	0,	1,	21),
(3,	'上海市',	'﻿ShangHaiShi',	1,	1,	0,	'',	'﻿S',	0,	1,	23),
(4,	'天津市',	'﻿TianJinShi',	1,	1,	0,	'',	'﻿T',	0,	1,	21),
(5,	'重庆市',	'﻿ChongQingShi',	1,	1,	0,	'',	'﻿Z',	0,	1,	25),
(6,	'河北省',	'﻿HeBeiSheng',	1,	1,	0,	'3',	'﻿H',	0,	1,	21),
(7,	'山西省',	'﻿ShanXiSheng',	1,	1,	0,	'',	'﻿S',	0,	1,	21),
(8,	'内蒙古',	'﻿NeiMengGu',	1,	1,	0,	'',	'﻿N',	0,	1,	21),
(9,	'辽宁省',	'﻿LiaoNingSheng',	1,	1,	0,	'',	'﻿L',	0,	1,	22),
(10,	'吉林省',	'﻿JiLinSheng',	1,	1,	0,	'',	'﻿J',	0,	1,	22),
(11,	'黑龙江省',	'﻿HeiLongJiangSheng',	1,	1,	0,	'',	'﻿H',	0,	1,	22),
(12,	'江苏省',	'﻿JiangSuSheng',	1,	1,	0,	'',	'﻿J',	0,	1,	23),
(13,	'浙江省',	'﻿ZheJiangSheng',	1,	1,	0,	'',	'﻿Z',	0,	1,	23),
(14,	'安徽省',	'﻿AnHuiSheng',	1,	1,	0,	'',	'﻿A',	0,	1,	23),
(15,	'福建省',	'﻿FuJianSheng',	1,	1,	0,	'',	'﻿F',	0,	1,	23),
(16,	'江西省',	'﻿JiangXiSheng',	1,	1,	0,	'',	'﻿J',	0,	1,	23),
(17,	'山东省',	'﻿ShanDongSheng',	1,	1,	0,	'',	'﻿S',	0,	1,	23),
(18,	'河南省',	'﻿HeNanSheng',	1,	1,	0,	'',	'﻿H',	0,	1,	27),
(19,	'湖北省',	'﻿HuBeiSheng',	1,	1,	0,	'',	'﻿H',	0,	1,	27),
(20,	'湖南省',	'﻿HuNanSheng',	1,	1,	0,	'',	'﻿H',	0,	1,	27),
(21,	'广东省',	'﻿GuangDongSheng',	1,	1,	0,	'',	'﻿G',	0,	1,	24),
(22,	'广西',	'﻿GuangXi',	1,	1,	0,	'',	'﻿G',	0,	1,	24),
(23,	'海南省',	'﻿HaiNanSheng',	1,	1,	0,	'',	'﻿H',	0,	1,	24),
(24,	'四川省',	'﻿SiChuanSheng',	1,	1,	0,	'',	'﻿S',	0,	1,	25),
(25,	'贵州省',	'﻿GuiZhouSheng',	1,	1,	0,	'',	'﻿G',	0,	1,	25),
(26,	'云南省',	'﻿YunNanSheng',	1,	1,	0,	'',	'﻿Y',	0,	1,	25),
(27,	'西藏',	'﻿XiCang',	1,	1,	0,	'',	'﻿X',	0,	1,	25),
(28,	'陕西省',	'﻿ShanXiSheng',	1,	1,	0,	'',	'﻿S',	0,	1,	26),
(29,	'甘肃省',	'﻿GanSuSheng',	1,	1,	0,	'',	'﻿G',	0,	1,	26),
(30,	'青海省',	'﻿QingHaiSheng',	1,	1,	0,	'',	'﻿Q',	0,	1,	26),
(31,	'宁夏',	'﻿NingXia',	1,	1,	0,	'',	'﻿N',	0,	1,	26),
(32,	'新疆',	'﻿XinJiang',	1,	1,	0,	'',	'﻿X',	0,	1,	26),
(33,	'台湾省',	'﻿TaiWanSheng',	1,	1,	0,	'',	'﻿T',	0,	1,	23),
(34,	'香港',	'﻿XiangGang',	1,	1,	0,	'',	'﻿X',	0,	1,	24),
(35,	'澳门',	'﻿AoMen',	1,	1,	0,	'',	'﻿A',	0,	1,	24),
(36,	'东城区',	'﻿DongChengQu',	3360,	1,	0,	'',	'﻿D',	0,	3,	0),
(37,	'西城区',	'﻿XiChengQu',	3360,	1,	0,	'',	'﻿X',	0,	3,	0),
(38,	'崇文区',	'﻿ChongWenQu',	3360,	1,	0,	'',	'﻿C',	0,	3,	0),
(39,	'宣武区',	'﻿XuanWuQu',	3360,	1,	0,	'',	'﻿X',	0,	3,	0),
(40,	'朝阳区',	'﻿ZhaoYangQu',	3360,	1,	0,	'',	'﻿Z',	0,	3,	0),
(41,	'石景山区',	'﻿ShiJingShanQu',	3360,	1,	0,	'',	'﻿S',	0,	3,	0),
(42,	'海淀区',	'﻿HaiDianQu',	3360,	1,	0,	'',	'﻿H',	0,	3,	0),
(43,	'门头沟区',	'﻿MenTouGouQu',	3360,	1,	0,	'',	'﻿M',	0,	3,	0),
(44,	'房山区',	'﻿FangShanQu',	3360,	1,	0,	'',	'﻿F',	0,	3,	0),
(45,	'通州区',	'﻿TongZhouQu',	3360,	1,	0,	'',	'﻿T',	0,	3,	0),
(46,	'顺义区',	'﻿ShunYiQu',	3360,	1,	0,	'',	'﻿S',	0,	3,	0),
(47,	'昌平区',	'﻿ChangPingQu',	3360,	1,	0,	'',	'﻿C',	0,	3,	0),
(48,	'大兴区',	'﻿DaXingQu',	3360,	1,	0,	'',	'﻿D',	0,	3,	0),
(49,	'怀柔区',	'﻿HuaiRouQu',	3360,	1,	0,	'',	'﻿H',	0,	3,	0),
(50,	'平谷区',	'﻿PingGuQu',	3360,	1,	0,	'',	'﻿P',	0,	3,	0),
(51,	'密云县',	'﻿MiYunXian',	3360,	1,	0,	'',	'﻿M',	0,	3,	0),
(52,	'延庆县',	'﻿YanQingXian',	3360,	1,	0,	'',	'﻿Y',	0,	3,	0),
(53,	'黄浦区',	'﻿HuangPuQu',	3361,	1,	0,	'',	'﻿H',	0,	3,	0),
(54,	'卢湾区',	'﻿LuWanQu',	3361,	1,	0,	'',	'﻿L',	0,	3,	0),
(55,	'徐汇区',	'﻿XuHuiQu',	3361,	1,	0,	'',	'﻿X',	0,	3,	0),
(56,	'长宁区',	'﻿ChangNingQu',	3361,	1,	0,	'',	'﻿C',	0,	3,	0),
(57,	'静安区',	'﻿JingAnQu',	3361,	1,	0,	'',	'﻿J',	0,	3,	0),
(58,	'普陀区',	'﻿PuTuoQu',	3361,	1,	0,	'',	'﻿P',	0,	3,	0),
(59,	'闸北区',	'﻿ZhaBeiQu',	3361,	1,	0,	'',	'﻿Z',	0,	3,	0),
(60,	'虹口区',	'﻿HongKouQu',	3361,	1,	0,	'',	'﻿H',	0,	3,	0),
(61,	'杨浦区',	'﻿YangPuQu',	3361,	1,	0,	'',	'﻿Y',	0,	3,	0),
(62,	'闵行区',	'﻿MinXingQu',	3361,	1,	0,	'',	'﻿M',	0,	3,	0),
(63,	'宝山区',	'﻿BaoShanQu',	3361,	1,	0,	'',	'﻿B',	0,	3,	0),
(64,	'嘉定区',	'﻿JiaDingQu',	3361,	1,	0,	'',	'﻿J',	0,	3,	0),
(65,	'浦东新区',	'﻿PuDongXinQu',	3361,	1,	0,	'',	'﻿P',	0,	3,	0),
(66,	'金山区',	'﻿JinShanQu',	3361,	1,	0,	'',	'﻿J',	0,	3,	0),
(67,	'松江区',	'﻿SongJiangQu',	3361,	1,	0,	'',	'﻿S',	0,	3,	0),
(68,	'青浦区',	'﻿QingPuQu',	3361,	1,	0,	'',	'﻿Q',	0,	3,	0),
(69,	'南汇区',	'﻿NanHuiQu',	3361,	1,	0,	'',	'﻿N',	0,	3,	0),
(70,	'奉贤区',	'﻿FengXianQu',	3361,	1,	0,	'',	'﻿F',	0,	3,	0),
(71,	'崇明县',	'﻿ChongMingXian',	3361,	1,	0,	'',	'﻿C',	0,	3,	0),
(72,	'和平区',	'﻿HePingQu',	3362,	1,	0,	'',	'﻿H',	0,	3,	0),
(73,	'河东区',	'﻿HeDongQu',	3362,	1,	0,	'',	'﻿H',	0,	3,	0),
(74,	'河西区',	'﻿HeXiQu',	3362,	1,	0,	'',	'﻿H',	0,	3,	0),
(75,	'南开区',	'﻿NanKaiQu',	3362,	1,	0,	'',	'﻿N',	0,	3,	0),
(76,	'河北区',	'﻿HeBeiQu',	3362,	1,	0,	'',	'﻿H',	0,	3,	0),
(77,	'红桥区',	'﻿HongQiaoQu',	3362,	1,	0,	'',	'﻿H',	0,	3,	0),
(78,	'塘沽区',	'﻿TangGuQu',	3362,	1,	0,	'',	'﻿T',	0,	3,	0),
(79,	'汉沽区',	'﻿HanGuQu',	3362,	1,	0,	'',	'﻿H',	0,	3,	0),
(80,	'大港区',	'﻿DaGangQu',	3362,	1,	0,	'',	'﻿D',	0,	3,	0),
(81,	'东丽区',	'﻿DongLiQu',	3362,	1,	0,	'',	'﻿D',	0,	3,	0),
(82,	'西青区',	'﻿XiQingQu',	3362,	1,	0,	'',	'﻿X',	0,	3,	0),
(83,	'津南区',	'﻿JinNanQu',	3362,	1,	0,	'',	'﻿J',	0,	3,	0),
(84,	'北辰区',	'﻿BeiChenQu',	3362,	1,	0,	'',	'﻿B',	0,	3,	0),
(85,	'武清区',	'﻿WuQingQu',	3362,	1,	0,	'',	'﻿W',	0,	3,	0),
(86,	'宝坻区',	'﻿BaoDiQu',	3362,	1,	0,	'',	'﻿B',	0,	3,	0),
(87,	'宁河县',	'﻿NingHeXian',	3362,	1,	0,	'',	'﻿N',	0,	3,	0),
(88,	'静海县',	'﻿JingHaiXian',	3362,	1,	0,	'',	'﻿J',	0,	3,	0),
(89,	'蓟县',	'﻿JiXian',	3362,	1,	0,	'',	'﻿J',	0,	3,	0),
(90,	'万州区',	'﻿WanZhouQu',	3363,	1,	0,	'',	'﻿W',	0,	3,	0),
(91,	'涪陵区',	'﻿FuLingQu',	3363,	1,	0,	'',	'﻿F',	0,	3,	0),
(92,	'渝中区',	'﻿YuZhongQu',	3363,	1,	0,	'',	'﻿Y',	0,	3,	0),
(93,	'大渡口区',	'﻿DaDuKouQu',	3363,	1,	0,	'',	'﻿D',	0,	3,	0),
(94,	'江北区',	'﻿JiangBeiQu',	3363,	1,	0,	'',	'﻿J',	0,	3,	0),
(95,	'沙坪坝区',	'﻿ShaPingBaQu',	3363,	1,	0,	'',	'﻿S',	0,	3,	0),
(96,	'九龙坡区',	'﻿JiuLongPoQu',	3363,	1,	0,	'',	'﻿J',	0,	3,	0),
(97,	'南岸区',	'﻿NanAnQu',	3363,	1,	0,	'',	'﻿N',	0,	3,	0),
(98,	'北碚区',	'﻿BeiBeiQu',	3363,	1,	0,	'',	'﻿B',	0,	3,	0),
(99,	'万盛区',	'﻿WanShengQu',	3363,	1,	0,	'',	'﻿W',	0,	3,	0),
(100,	'双桥区',	'﻿ShuangQiaoQu',	3363,	1,	0,	'',	'﻿S',	0,	3,	0),
(101,	'渝北区',	'﻿YuBeiQu',	3363,	1,	0,	'',	'﻿Y',	0,	3,	0),
(102,	'巴南区',	'﻿BaNanQu',	3363,	1,	0,	'',	'﻿B',	0,	3,	0),
(103,	'黔江区',	'﻿QianJiangQu',	3363,	1,	0,	'',	'﻿Q',	0,	3,	0),
(104,	'长寿区',	'﻿ChangShouQu',	3363,	1,	0,	'',	'﻿C',	0,	3,	0),
(105,	'綦江县',	'﻿QiJiangXian',	3363,	1,	0,	'',	'﻿Q',	0,	3,	0),
(106,	'潼南县',	'﻿TongNanXian',	3363,	1,	0,	'',	'﻿T',	0,	3,	0),
(107,	'铜梁县',	'﻿TongLiangXian',	3363,	1,	0,	'',	'﻿T',	0,	3,	0),
(108,	'大足县',	'﻿DaZuXian',	3363,	1,	0,	'',	'﻿D',	0,	3,	0),
(109,	'荣昌县',	'﻿RongChangXian',	3363,	1,	0,	'',	'﻿R',	0,	3,	0),
(110,	'璧山县',	'﻿BiShanXian',	3363,	1,	0,	'',	'﻿B',	0,	3,	0),
(111,	'梁平县',	'﻿LiangPingXian',	3363,	1,	0,	'',	'﻿L',	0,	3,	0),
(112,	'城口县',	'﻿ChengKouXian',	3363,	1,	0,	'',	'﻿C',	0,	3,	0),
(113,	'丰都县',	'﻿FengDuXian',	3363,	1,	0,	'',	'﻿F',	0,	3,	0),
(114,	'垫江县',	'﻿DianJiangXian',	3363,	1,	0,	'',	'﻿D',	0,	3,	0),
(115,	'武隆县',	'﻿WuLongXian',	3363,	1,	0,	'',	'﻿W',	0,	3,	0),
(116,	'忠县',	'﻿ZhongXian',	3363,	1,	0,	'',	'﻿Z',	0,	3,	0),
(117,	'开县',	'﻿KaiXian',	3363,	1,	0,	'',	'﻿K',	0,	3,	0),
(118,	'云阳县',	'﻿YunYangXian',	3363,	1,	0,	'',	'﻿Y',	0,	3,	0),
(119,	'奉节县',	'﻿FengJieXian',	3363,	1,	0,	'',	'﻿F',	0,	3,	0),
(120,	'巫山县',	'﻿WuShanXian',	3363,	1,	0,	'',	'﻿W',	0,	3,	0),
(121,	'巫溪县',	'﻿WuXiXian',	3363,	1,	0,	'',	'﻿W',	0,	3,	0),
(122,	'石柱县',	'﻿ShiZhuXian',	3363,	1,	0,	'',	'﻿S',	0,	3,	0),
(123,	'秀山县',	'﻿XiuShanXian',	3363,	1,	0,	'',	'﻿X',	0,	3,	0),
(124,	'酉阳县',	'﻿YouYangXian',	3363,	1,	0,	'',	'﻿Y',	0,	3,	0),
(125,	'彭水县',	'﻿PengShuiXian',	3363,	1,	0,	'',	'﻿P',	0,	3,	0),
(126,	'江津区',	'﻿JiangJinQu',	3363,	1,	0,	'',	'﻿J',	0,	3,	0),
(127,	'合川区',	'﻿HeChuanQu',	3363,	1,	0,	'',	'﻿H',	0,	3,	0),
(128,	'永川区',	'﻿YongChuanQu',	3363,	1,	0,	'',	'﻿Y',	0,	3,	0),
(129,	'南川区',	'﻿NanChuanQu',	3363,	1,	0,	'',	'﻿N',	0,	3,	0),
(130,	'石家庄市',	'﻿ShiJiaZhuangShi',	6,	1,	0,	'1003',	'﻿S',	0,	2,	0),
(131,	'唐山市',	'﻿TangShanShi',	6,	1,	0,	'',	'﻿T',	0,	2,	0),
(132,	'秦皇岛市',	'﻿QinHuangDaoShi',	6,	1,	0,	'',	'﻿Q',	0,	2,	0),
(133,	'邯郸市',	'﻿HanDanShi',	6,	1,	0,	'',	'﻿H',	0,	2,	0),
(134,	'邢台市',	'﻿XingTaiShi',	6,	1,	0,	'',	'﻿X',	0,	2,	0),
(135,	'保定市',	'﻿BaoDingShi',	6,	1,	0,	'',	'﻿B',	0,	2,	0),
(136,	'张家口市',	'﻿ZhangJiaKouShi',	6,	1,	0,	'',	'﻿Z',	0,	2,	0),
(137,	'承德市',	'﻿ChengDeShi',	6,	1,	0,	'',	'﻿C',	0,	2,	0),
(138,	'沧州市',	'﻿CangZhouShi',	6,	1,	0,	'',	'﻿C',	0,	2,	0),
(139,	'廊坊市',	'﻿LangFangShi',	6,	1,	0,	'',	'﻿L',	0,	2,	0),
(140,	'衡水市',	'﻿HengShuiShi',	6,	1,	0,	'',	'﻿H',	0,	2,	0),
(141,	'太原市',	'﻿TaiYuanShi',	7,	1,	0,	'',	'﻿T',	0,	2,	0),
(142,	'大同市',	'﻿DaTongShi',	7,	1,	0,	'',	'﻿D',	0,	2,	0),
(143,	'阳泉市',	'﻿YangQuanShi',	7,	1,	0,	'',	'﻿Y',	0,	2,	0),
(144,	'长治市',	'﻿ChangZhiShi',	7,	1,	0,	'',	'﻿C',	0,	2,	0),
(145,	'晋城市',	'﻿JinChengShi',	7,	1,	0,	'',	'﻿J',	0,	2,	0),
(146,	'朔州市',	'﻿ShuoZhouShi',	7,	1,	0,	'',	'﻿S',	0,	2,	0),
(147,	'晋中市',	'﻿JinZhongShi',	7,	1,	0,	'',	'﻿J',	0,	2,	0),
(148,	'运城市',	'﻿YunChengShi',	7,	1,	0,	'',	'﻿Y',	0,	2,	0),
(149,	'忻州市',	'﻿XinZhouShi',	7,	1,	0,	'',	'﻿X',	0,	2,	0),
(150,	'临汾市',	'﻿LinFenShi',	7,	1,	0,	'',	'﻿L',	0,	2,	0),
(151,	'吕梁市',	'﻿LvLiangShi',	7,	1,	0,	'',	'﻿L',	0,	2,	0),
(152,	'呼和浩特市',	'﻿HuHeHaoTeShi',	8,	1,	0,	'',	'﻿H',	0,	2,	0),
(153,	'包头市',	'﻿BaoTouShi',	8,	1,	0,	'',	'﻿B',	0,	2,	0),
(154,	'乌海市',	'﻿WuHaiShi',	8,	1,	0,	'',	'﻿W',	0,	2,	0),
(155,	'赤峰市',	'﻿ChiFengShi',	8,	1,	0,	'',	'﻿C',	0,	2,	0),
(156,	'通辽市',	'﻿TongLiaoShi',	8,	1,	0,	'',	'﻿T',	0,	2,	0),
(157,	'鄂尔多斯市',	'﻿EErDuoSiShi',	8,	1,	0,	'',	'﻿E',	0,	2,	0),
(158,	'呼伦贝尔市',	'﻿HuLunBeiErShi',	8,	1,	0,	'',	'﻿H',	0,	2,	0),
(159,	'巴彦淖尔市',	'﻿BaYanNaoErShi',	8,	1,	0,	'',	'﻿B',	0,	2,	0),
(160,	'乌兰察布市',	'﻿WuLanChaBuShi',	8,	1,	0,	'',	'﻿W',	0,	2,	0),
(161,	'兴安盟',	'﻿XingAnMeng',	8,	1,	0,	'',	'﻿X',	0,	2,	0),
(162,	'锡林郭勒盟',	'﻿XiLinGuoLeMeng',	8,	1,	0,	'',	'﻿X',	0,	2,	0),
(163,	'阿拉善盟',	'﻿ALaShanMeng',	8,	1,	0,	'',	'﻿A',	0,	2,	0),
(164,	'沈阳市',	'﻿ShenYangShi',	9,	1,	0,	'',	'﻿S',	0,	2,	0),
(165,	'大连市',	'﻿DaLianShi',	9,	1,	0,	'',	'﻿D',	0,	2,	0),
(166,	'鞍山市',	'﻿AnShanShi',	9,	1,	0,	'',	'﻿A',	0,	2,	0),
(167,	'抚顺市',	'﻿FuShunShi',	9,	1,	0,	'',	'﻿F',	0,	2,	0),
(168,	'本溪市',	'﻿BenXiShi',	9,	1,	0,	'',	'﻿B',	0,	2,	0),
(169,	'丹东市',	'﻿DanDongShi',	9,	1,	0,	'',	'﻿D',	0,	2,	0),
(170,	'锦州市',	'﻿JinZhouShi',	9,	1,	0,	'',	'﻿J',	0,	2,	0),
(171,	'营口市',	'﻿YingKouShi',	9,	1,	0,	'',	'﻿Y',	0,	2,	0),
(172,	'阜新市',	'﻿FuXinShi',	9,	1,	0,	'',	'﻿F',	0,	2,	0),
(173,	'辽阳市',	'﻿LiaoYangShi',	9,	1,	0,	'',	'﻿L',	0,	2,	0),
(174,	'盘锦市',	'﻿PanJinShi',	9,	1,	0,	'',	'﻿P',	0,	2,	0),
(175,	'铁岭市',	'﻿TieLingShi',	9,	1,	0,	'',	'﻿T',	0,	2,	0),
(176,	'朝阳市',	'﻿ZhaoYangShi',	9,	1,	0,	'',	'﻿Z',	0,	2,	0),
(177,	'葫芦岛市',	'﻿HuLuDaoShi',	9,	1,	0,	'',	'﻿H',	0,	2,	0),
(178,	'长春市',	'﻿ChangChunShi',	10,	1,	0,	'',	'﻿C',	0,	2,	0),
(179,	'吉林市',	'﻿JiLinShi',	10,	1,	0,	'',	'﻿J',	0,	2,	0),
(180,	'四平市',	'﻿SiPingShi',	10,	1,	0,	'',	'﻿S',	0,	2,	0),
(181,	'辽源市',	'﻿LiaoYuanShi',	10,	1,	0,	'',	'﻿L',	0,	2,	0),
(182,	'通化市',	'﻿TongHuaShi',	10,	1,	0,	'',	'﻿T',	0,	2,	0),
(183,	'白山市',	'﻿BaiShanShi',	10,	1,	0,	'',	'﻿B',	0,	2,	0),
(184,	'松原市',	'﻿SongYuanShi',	10,	1,	0,	'',	'﻿S',	0,	2,	0),
(185,	'白城市',	'﻿BaiChengShi',	10,	1,	0,	'',	'﻿B',	0,	2,	0),
(186,	'延边',	'﻿YanBian',	10,	1,	0,	'',	'﻿Y',	0,	2,	0),
(187,	'哈尔滨市',	'﻿HaErBinShi',	11,	1,	0,	'',	'﻿H',	0,	2,	0),
(188,	'齐齐哈尔市',	'﻿QiQiHaErShi',	11,	1,	0,	'',	'﻿Q',	0,	2,	0),
(189,	'鸡西市',	'﻿JiXiShi',	11,	1,	0,	'',	'﻿J',	0,	2,	0),
(190,	'鹤岗市',	'﻿HeGangShi',	11,	1,	0,	'',	'﻿H',	0,	2,	0),
(191,	'双鸭山市',	'﻿ShuangYaShanShi',	11,	1,	0,	'',	'﻿S',	0,	2,	0),
(192,	'大庆市',	'﻿DaQingShi',	11,	1,	0,	'',	'﻿D',	0,	2,	0),
(193,	'伊春市',	'﻿YiChunShi',	11,	1,	0,	'',	'﻿Y',	0,	2,	0),
(194,	'佳木斯市',	'﻿JiaMuSiShi',	11,	1,	0,	'',	'﻿J',	0,	2,	0),
(195,	'七台河市',	'﻿QiTaiHeShi',	11,	1,	0,	'',	'﻿Q',	0,	2,	0),
(196,	'牡丹江市',	'﻿MuDanJiangShi',	11,	1,	0,	'',	'﻿M',	0,	2,	0),
(197,	'黑河市',	'﻿HeiHeShi',	11,	1,	0,	'',	'﻿H',	0,	2,	0),
(198,	'绥化市',	'﻿SuiHuaShi',	11,	1,	0,	'',	'﻿S',	0,	2,	0),
(199,	'大兴安岭地区',	'﻿DaXingAnLingDiQu',	11,	1,	0,	'',	'﻿D',	0,	2,	0),
(200,	'南京市',	'﻿NanJingShi',	12,	1,	0,	'',	'﻿N',	0,	2,	0),
(201,	'无锡市',	'﻿WuXiShi',	12,	1,	0,	'',	'﻿W',	0,	2,	0),
(202,	'徐州市',	'﻿XuZhouShi',	12,	1,	0,	'',	'﻿X',	0,	2,	0),
(203,	'常州市',	'﻿ChangZhouShi',	12,	1,	0,	'',	'﻿C',	0,	2,	0),
(204,	'苏州市',	'﻿SuZhouShi',	12,	1,	0,	'',	'﻿S',	0,	2,	0),
(205,	'南通市',	'﻿NanTongShi',	12,	1,	0,	'',	'﻿N',	0,	2,	0),
(206,	'连云港市',	'﻿LianYunGangShi',	12,	1,	0,	'',	'﻿L',	0,	2,	0),
(207,	'淮安市',	'﻿HuaiAnShi',	12,	1,	0,	'',	'﻿H',	0,	2,	0),
(208,	'盐城市',	'﻿YanChengShi',	12,	1,	0,	'',	'﻿Y',	0,	2,	0),
(209,	'扬州市',	'﻿YangZhouShi',	12,	1,	0,	'',	'﻿Y',	0,	2,	0),
(210,	'镇江市',	'﻿ZhenJiangShi',	12,	1,	0,	'',	'﻿Z',	0,	2,	0),
(211,	'泰州市',	'﻿TaiZhouShi',	12,	1,	0,	'',	'﻿T',	0,	2,	0),
(212,	'宿迁市',	'﻿SuQianShi',	12,	1,	0,	'',	'﻿S',	0,	2,	0),
(213,	'杭州市',	'﻿HangZhouShi',	13,	1,	0,	'',	'﻿H',	0,	2,	0),
(214,	'宁波市',	'﻿NingBoShi',	13,	1,	0,	'',	'﻿N',	0,	2,	0),
(215,	'温州市',	'﻿WenZhouShi',	13,	1,	0,	'',	'﻿W',	0,	2,	0),
(216,	'嘉兴市',	'﻿JiaXingShi',	13,	1,	0,	'',	'﻿J',	0,	2,	0),
(217,	'湖州市',	'﻿HuZhouShi',	13,	1,	0,	'',	'﻿H',	0,	2,	0),
(218,	'绍兴市',	'﻿ShaoXingShi',	13,	1,	0,	'',	'﻿S',	0,	2,	0),
(219,	'金华市',	'﻿JinHuaShi',	13,	1,	0,	'',	'﻿J',	0,	2,	0),
(220,	'衢州市',	'﻿QuZhouShi',	13,	1,	0,	'',	'﻿Q',	0,	2,	0),
(221,	'舟山市',	'﻿ZhouShanShi',	13,	1,	0,	'',	'﻿Z',	0,	2,	0),
(222,	'台州市',	'﻿TaiZhouShi',	13,	1,	0,	'',	'﻿T',	0,	2,	0),
(223,	'丽水市',	'﻿LiShuiShi',	13,	1,	0,	'',	'﻿L',	0,	2,	0),
(224,	'合肥市',	'﻿HeFeiShi',	14,	1,	0,	'',	'﻿H',	0,	2,	0),
(225,	'芜湖市',	'﻿WuHuShi',	14,	1,	0,	'',	'﻿W',	0,	2,	0),
(226,	'蚌埠市',	'﻿BangBuShi',	14,	1,	0,	'',	'﻿B',	0,	2,	0),
(227,	'淮南市',	'﻿HuaiNanShi',	14,	1,	0,	'',	'﻿H',	0,	2,	0),
(228,	'马鞍山市',	'﻿MaAnShanShi',	14,	1,	0,	'',	'﻿M',	0,	2,	0),
(229,	'淮北市',	'﻿HuaiBeiShi',	14,	1,	0,	'',	'﻿H',	0,	2,	0),
(230,	'铜陵市',	'﻿TongLingShi',	14,	1,	0,	'',	'﻿T',	0,	2,	0),
(231,	'安庆市',	'﻿AnQingShi',	14,	1,	0,	'',	'﻿A',	0,	2,	0),
(232,	'黄山市',	'﻿HuangShanShi',	14,	1,	0,	'',	'﻿H',	0,	2,	0),
(233,	'滁州市',	'﻿ChuZhouShi',	14,	1,	0,	'',	'﻿C',	0,	2,	0),
(234,	'阜阳市',	'﻿FuYangShi',	14,	1,	0,	'',	'﻿F',	0,	2,	0),
(235,	'宿州市',	'﻿SuZhouShi',	14,	1,	0,	'',	'﻿S',	0,	2,	0),
(236,	'巢湖市',	'﻿ChaoHuShi',	14,	1,	0,	'',	'﻿C',	0,	2,	0),
(237,	'六安市',	'﻿LiuAnShi',	14,	1,	0,	'',	'﻿L',	0,	2,	0),
(238,	'亳州市',	'﻿BoZhouShi',	14,	1,	0,	'',	'﻿B',	0,	2,	0),
(239,	'池州市',	'﻿ChiZhouShi',	14,	1,	0,	'',	'﻿C',	0,	2,	0),
(240,	'宣城市',	'﻿XuanChengShi',	14,	1,	0,	'',	'﻿X',	0,	2,	0),
(241,	'福州市',	'﻿FuZhouShi',	15,	1,	0,	'',	'﻿F',	0,	2,	0),
(242,	'厦门市',	'﻿ShaMenShi',	15,	1,	0,	'',	'﻿S',	0,	2,	0),
(243,	'莆田市',	'﻿PuTianShi',	15,	1,	0,	'',	'﻿P',	0,	2,	0),
(244,	'三明市',	'﻿SanMingShi',	15,	1,	0,	'',	'﻿S',	0,	2,	0),
(245,	'泉州市',	'﻿QuanZhouShi',	15,	1,	0,	'',	'﻿Q',	0,	2,	0),
(246,	'漳州市',	'﻿ZhangZhouShi',	15,	1,	0,	'',	'﻿Z',	0,	2,	0),
(247,	'南平市',	'﻿NanPingShi',	15,	1,	0,	'',	'﻿N',	0,	2,	0),
(248,	'龙岩市',	'﻿LongYanShi',	15,	1,	0,	'',	'﻿L',	0,	2,	0),
(249,	'宁德市',	'﻿NingDeShi',	15,	1,	0,	'',	'﻿N',	0,	2,	0),
(250,	'南昌市',	'﻿NanChangShi',	16,	1,	0,	'',	'﻿N',	0,	2,	0),
(251,	'景德镇市',	'﻿JingDeZhenShi',	16,	1,	0,	'',	'﻿J',	0,	2,	0),
(252,	'萍乡市',	'﻿PingXiangShi',	16,	1,	0,	'',	'﻿P',	0,	2,	0),
(253,	'九江市',	'﻿JiuJiangShi',	16,	1,	0,	'',	'﻿J',	0,	2,	0),
(254,	'新余市',	'﻿XinYuShi',	16,	1,	0,	'',	'﻿X',	0,	2,	0),
(255,	'鹰潭市',	'﻿YingTanShi',	16,	1,	0,	'',	'﻿Y',	0,	2,	0),
(256,	'赣州市',	'﻿GanZhouShi',	16,	1,	0,	'',	'﻿G',	0,	2,	0),
(257,	'吉安市',	'﻿JiAnShi',	16,	1,	0,	'',	'﻿J',	0,	2,	0),
(258,	'宜春市',	'﻿YiChunShi',	16,	1,	0,	'',	'﻿Y',	0,	2,	0),
(259,	'抚州市',	'﻿FuZhouShi',	16,	1,	0,	'',	'﻿F',	0,	2,	0),
(260,	'上饶市',	'﻿ShangRaoShi',	16,	1,	0,	'',	'﻿S',	0,	2,	0),
(261,	'济南市',	'﻿JiNanShi',	17,	1,	0,	'',	'﻿J',	0,	2,	0),
(262,	'青岛市',	'﻿QingDaoShi',	17,	1,	0,	'',	'﻿Q',	0,	2,	0),
(263,	'淄博市',	'﻿ZiBoShi',	17,	1,	0,	'',	'﻿Z',	0,	2,	0),
(264,	'枣庄市',	'﻿ZaoZhuangShi',	17,	1,	0,	'',	'﻿Z',	0,	2,	0),
(265,	'东营市',	'﻿DongYingShi',	17,	1,	0,	'',	'﻿D',	0,	2,	0),
(266,	'烟台市',	'﻿YanTaiShi',	17,	1,	0,	'',	'﻿Y',	0,	2,	0),
(267,	'潍坊市',	'﻿WeiFangShi',	17,	1,	0,	'',	'﻿W',	0,	2,	0),
(268,	'济宁市',	'﻿JiNingShi',	17,	1,	0,	'',	'﻿J',	0,	2,	0),
(269,	'泰安市',	'﻿TaiAnShi',	17,	1,	0,	'',	'﻿T',	0,	2,	0),
(270,	'威海市',	'﻿WeiHaiShi',	17,	1,	0,	'',	'﻿W',	0,	2,	0),
(271,	'日照市',	'﻿RiZhaoShi',	17,	1,	0,	'',	'﻿R',	0,	2,	0),
(272,	'莱芜市',	'﻿LaiWuShi',	17,	1,	0,	'',	'﻿L',	0,	2,	0),
(273,	'临沂市',	'﻿LinYiShi',	17,	1,	0,	'',	'﻿L',	0,	2,	0),
(274,	'德州市',	'﻿DeZhouShi',	17,	1,	0,	'',	'﻿D',	0,	2,	0),
(275,	'聊城市',	'﻿LiaoChengShi',	17,	1,	0,	'',	'﻿L',	0,	2,	0),
(276,	'滨州市',	'﻿BinZhouShi',	17,	1,	0,	'',	'﻿B',	0,	2,	0),
(277,	'荷泽市',	'﻿HeZeShi',	17,	1,	0,	'',	'﻿H',	0,	2,	0),
(278,	'郑州市',	'﻿ZhengZhouShi',	18,	1,	0,	'',	'﻿Z',	0,	2,	0),
(279,	'开封市',	'﻿KaiFengShi',	18,	1,	0,	'',	'﻿K',	0,	2,	0),
(280,	'洛阳市',	'﻿LuoYangShi',	18,	1,	0,	'',	'﻿L',	0,	2,	0),
(281,	'平顶山市',	'﻿PingDingShanShi',	18,	1,	0,	'',	'﻿P',	0,	2,	0),
(282,	'安阳市',	'﻿AnYangShi',	18,	1,	0,	'',	'﻿A',	0,	2,	0),
(283,	'鹤壁市',	'﻿HeBiShi',	18,	1,	0,	'',	'﻿H',	0,	2,	0),
(284,	'新乡市',	'﻿XinXiangShi',	18,	1,	0,	'',	'﻿X',	0,	2,	0),
(285,	'焦作市',	'﻿JiaoZuoShi',	18,	1,	0,	'',	'﻿J',	0,	2,	0),
(286,	'濮阳市',	'﻿PuYangShi',	18,	1,	0,	'',	'﻿P',	0,	2,	0),
(287,	'许昌市',	'﻿XuChangShi',	18,	1,	0,	'',	'﻿X',	0,	2,	0),
(288,	'漯河市',	'﻿LuoHeShi',	18,	1,	0,	'',	'﻿L',	0,	2,	0),
(289,	'三门峡市',	'﻿SanMenXiaShi',	18,	1,	0,	'',	'﻿S',	0,	2,	0),
(290,	'南阳市',	'﻿NanYangShi',	18,	1,	0,	'',	'﻿N',	0,	2,	0),
(291,	'商丘市',	'﻿ShangQiuShi',	18,	1,	0,	'',	'﻿S',	0,	2,	0),
(292,	'信阳市',	'﻿XinYangShi',	18,	1,	0,	'',	'﻿X',	0,	2,	0),
(293,	'周口市',	'﻿ZhouKouShi',	18,	1,	0,	'',	'﻿Z',	0,	2,	0),
(294,	'驻马店市',	'﻿ZhuMaDianShi',	18,	1,	0,	'',	'﻿Z',	0,	2,	0),
(295,	'武汉市',	'﻿WuHanShi',	19,	1,	0,	'',	'﻿W',	0,	2,	0),
(296,	'黄石市',	'﻿HuangShiShi',	19,	1,	0,	'',	'﻿H',	0,	2,	0),
(297,	'十堰市',	'﻿ShiYanShi',	19,	1,	0,	'',	'﻿S',	0,	2,	0),
(298,	'宜昌市',	'﻿YiChangShi',	19,	1,	0,	'',	'﻿Y',	0,	2,	0),
(299,	'襄樊市',	'﻿XiangFanShi',	19,	1,	0,	'',	'﻿X',	0,	2,	0),
(300,	'鄂州市',	'﻿EZhouShi',	19,	1,	0,	'',	'﻿E',	0,	2,	0),
(301,	'荆门市',	'﻿JingMenShi',	19,	1,	0,	'',	'﻿J',	0,	2,	0),
(302,	'孝感市',	'﻿XiaoGanShi',	19,	1,	0,	'',	'﻿X',	0,	2,	0),
(303,	'荆州市',	'﻿JingZhouShi',	19,	1,	0,	'',	'﻿J',	0,	2,	0),
(304,	'黄冈市',	'﻿HuangGangShi',	19,	1,	0,	'',	'﻿H',	0,	2,	0),
(305,	'咸宁市',	'﻿XianNingShi',	19,	1,	0,	'',	'﻿X',	0,	2,	0),
(306,	'随州市',	'﻿SuiZhouShi',	19,	1,	0,	'',	'﻿S',	0,	2,	0),
(307,	'恩施土家族苗族自治州',	'﻿EnShiTuJiaZuMiaoZuZiZhiZhou',	19,	1,	0,	'',	'﻿E',	0,	2,	0),
(308,	'仙桃市',	'﻿XianTaoShi',	19,	1,	0,	'',	'﻿X',	0,	2,	0),
(309,	'潜江市',	'﻿QianJiangShi',	19,	1,	0,	'',	'﻿Q',	0,	2,	0),
(310,	'天门市',	'﻿TianMenShi',	19,	1,	0,	'',	'﻿T',	0,	2,	0),
(311,	'神农架林区',	'﻿ShenNongJiaLinQu',	19,	1,	0,	'',	'﻿S',	0,	2,	0),
(312,	'长沙市',	'﻿ChangShaShi',	20,	1,	0,	'',	'﻿C',	0,	2,	0),
(313,	'株洲市',	'﻿ZhuZhouShi',	20,	1,	0,	'',	'﻿Z',	0,	2,	0),
(314,	'湘潭市',	'﻿XiangTanShi',	20,	1,	0,	'',	'﻿X',	0,	2,	0),
(315,	'衡阳市',	'﻿HengYangShi',	20,	1,	0,	'',	'﻿H',	0,	2,	0),
(316,	'邵阳市',	'﻿ShaoYangShi',	20,	1,	0,	'',	'﻿S',	0,	2,	0),
(317,	'岳阳市',	'﻿YueYangShi',	20,	1,	0,	'',	'﻿Y',	0,	2,	0),
(318,	'常德市',	'﻿ChangDeShi',	20,	1,	0,	'',	'﻿C',	0,	2,	0),
(319,	'张家界市',	'﻿ZhangJiaJieShi',	20,	1,	0,	'',	'﻿Z',	0,	2,	0),
(320,	'益阳市',	'﻿YiYangShi',	20,	1,	0,	'',	'﻿Y',	0,	2,	0),
(321,	'郴州市',	'﻿ChenZhouShi',	20,	1,	0,	'',	'﻿C',	0,	2,	0),
(322,	'永州市',	'﻿YongZhouShi',	20,	1,	0,	'',	'﻿Y',	0,	2,	0),
(323,	'怀化市',	'Huaihuashi',	20,	1,	0,	'',	'﻿H',	0,	2,	0),
(324,	'娄底市',	'﻿LouDiShi',	20,	1,	0,	'',	'﻿L',	0,	2,	0),
(325,	'湘西土家族苗族自治州',	'﻿XiangXiTuJiaZuMiaoZuZiZhiZhou',	20,	1,	0,	'',	'﻿X',	0,	2,	0),
(326,	'广州市',	'﻿GuangZhouShi',	21,	1,	0,	'',	'﻿G',	0,	2,	0),
(327,	'韶关市',	'﻿ShaoGuanShi',	21,	1,	0,	'',	'﻿S',	0,	2,	0),
(328,	'深圳市',	'﻿ShenZhenShi',	21,	1,	0,	'',	'﻿S',	0,	2,	0),
(329,	'珠海市',	'﻿ZhuHaiShi',	21,	1,	0,	'',	'﻿Z',	0,	2,	0),
(330,	'汕头市',	'﻿ShanTouShi',	21,	1,	0,	'',	'﻿S',	0,	2,	0),
(331,	'佛山市',	'﻿FoShanShi',	21,	1,	0,	'',	'﻿F',	0,	2,	0),
(332,	'江门市',	'﻿JiangMenShi',	21,	1,	0,	'',	'﻿J',	0,	2,	0),
(333,	'湛江市',	'﻿ZhanJiangShi',	21,	1,	0,	'',	'﻿Z',	0,	2,	0),
(334,	'茂名市',	'﻿MaoMingShi',	21,	1,	0,	'',	'﻿M',	0,	2,	0),
(335,	'肇庆市',	'﻿ZhaoQingShi',	21,	1,	0,	'',	'﻿Z',	0,	2,	0),
(336,	'惠州市',	'﻿HuiZhouShi',	21,	1,	0,	'',	'﻿H',	0,	2,	0),
(337,	'梅州市',	'﻿MeiZhouShi',	21,	1,	0,	'',	'﻿M',	0,	2,	0),
(338,	'汕尾市',	'﻿ShanWeiShi',	21,	1,	0,	'',	'﻿S',	0,	2,	0),
(339,	'河源市',	'﻿HeYuanShi',	21,	1,	0,	'',	'﻿H',	0,	2,	0),
(340,	'阳江市',	'﻿YangJiangShi',	21,	1,	0,	'',	'﻿Y',	0,	2,	0),
(341,	'清远市',	'﻿QingYuanShi',	21,	1,	0,	'',	'﻿Q',	0,	2,	0),
(342,	'东莞市',	'﻿DongGuanShi',	21,	1,	0,	'',	'﻿D',	0,	2,	0),
(343,	'中山市',	'﻿ZhongShanShi',	21,	1,	0,	'',	'﻿Z',	0,	2,	0),
(344,	'潮州市',	'﻿ChaoZhouShi',	21,	1,	0,	'',	'﻿C',	0,	2,	0),
(345,	'揭阳市',	'﻿JieYangShi',	21,	1,	0,	'',	'﻿J',	0,	2,	0),
(346,	'云浮市',	'﻿YunFuShi',	21,	1,	0,	'',	'﻿Y',	0,	2,	0),
(347,	'南宁市',	'﻿NanNingShi',	22,	1,	0,	'',	'﻿N',	0,	2,	0),
(348,	'柳州市',	'﻿LiuZhouShi',	22,	1,	0,	'',	'﻿L',	0,	2,	0),
(349,	'桂林市',	'﻿GuiLinShi',	22,	1,	0,	'',	'﻿G',	0,	2,	0),
(350,	'梧州市',	'﻿WuZhouShi',	22,	1,	0,	'',	'﻿W',	0,	2,	0),
(351,	'北海市',	'﻿BeiHaiShi',	22,	1,	0,	'',	'﻿B',	0,	2,	0),
(352,	'防城港市',	'﻿FangChengGangShi',	22,	1,	0,	'',	'﻿F',	0,	2,	0),
(353,	'钦州市',	'﻿QinZhouShi',	22,	1,	0,	'',	'﻿Q',	0,	2,	0),
(354,	'贵港市',	'﻿GuiGangShi',	22,	1,	0,	'',	'﻿G',	0,	2,	0),
(355,	'玉林市',	'﻿YuLinShi',	22,	1,	0,	'',	'﻿Y',	0,	2,	0),
(356,	'百色市',	'﻿BaiSeShi',	22,	1,	0,	'',	'﻿B',	0,	2,	0),
(357,	'贺州市',	'﻿HeZhouShi',	22,	1,	0,	'',	'﻿H',	0,	2,	0),
(358,	'河池市',	'﻿HeChiShi',	22,	1,	0,	'',	'﻿H',	0,	2,	0),
(359,	'来宾市',	'﻿LaiBinShi',	22,	1,	0,	'',	'﻿L',	0,	2,	0),
(360,	'崇左市',	'﻿ChongZuoShi',	22,	1,	0,	'',	'﻿C',	0,	2,	0),
(361,	'海口市',	'﻿HaiKouShi',	23,	1,	0,	'',	'﻿H',	0,	2,	0),
(362,	'三亚市',	'﻿SanYaShi',	23,	1,	0,	'',	'﻿S',	0,	2,	0),
(363,	'五指山市',	'﻿WuZhiShanShi',	23,	1,	0,	'',	'﻿W',	0,	2,	0),
(364,	'琼海市',	'﻿QiongHaiShi',	23,	1,	0,	'',	'﻿Q',	0,	2,	0),
(365,	'儋州市',	'﻿DanZhouShi',	23,	1,	0,	'',	'﻿D',	0,	2,	0),
(366,	'文昌市',	'﻿WenChangShi',	23,	1,	0,	'',	'﻿W',	0,	2,	0),
(367,	'万宁市',	'﻿WanNingShi',	23,	1,	0,	'',	'﻿W',	0,	2,	0),
(368,	'东方市',	'﻿DongFangShi',	23,	1,	0,	'',	'﻿D',	0,	2,	0),
(369,	'定安县',	'﻿DingAnXian',	23,	1,	0,	'',	'﻿D',	0,	2,	0),
(370,	'屯昌县',	'﻿TunChangXian',	23,	1,	0,	'',	'﻿T',	0,	2,	0),
(371,	'澄迈县',	'﻿ChengMaiXian',	23,	1,	0,	'',	'﻿C',	0,	2,	0),
(372,	'临高县',	'﻿LinGaoXian',	23,	1,	0,	'',	'﻿L',	0,	2,	0),
(373,	'白沙黎族自治县',	'﻿BaiShaLiZuZiZhiXian',	23,	1,	0,	'',	'﻿B',	0,	2,	0),
(374,	'昌江黎族自治县',	'﻿ChangJiangLiZuZiZhiXian',	23,	1,	0,	'',	'﻿C',	0,	2,	0),
(375,	'乐东黎族自治县',	'﻿LeDongLiZuZiZhiXian',	23,	1,	0,	'',	'﻿L',	0,	2,	0),
(376,	'陵水黎族自治县',	'﻿LingShuiLiZuZiZhiXian',	23,	1,	0,	'',	'﻿L',	0,	2,	0),
(377,	'保亭黎族苗族自治县',	'﻿BaoTingLiZuMiaoZuZiZhiXian',	23,	1,	0,	'',	'﻿B',	0,	2,	0),
(378,	'琼中黎族苗族自治县',	'﻿QiongZhongLiZuMiaoZuZiZhiXian',	23,	1,	0,	'',	'﻿Q',	0,	2,	0),
(379,	'西沙群岛',	'﻿XiShaQunDao',	23,	1,	0,	'',	'﻿X',	0,	2,	0),
(380,	'南沙群岛',	'﻿NanShaQunDao',	23,	1,	0,	'',	'﻿N',	0,	2,	0),
(381,	'中沙群岛的岛礁及其海域',	'﻿ZhongShaQunDaoDiDaoJiaoJiQiHaiYu',	23,	1,	0,	'',	'﻿Z',	0,	2,	0),
(382,	'成都市',	'﻿ChengDuShi',	24,	1,	0,	'',	'﻿C',	0,	2,	0),
(383,	'自贡市',	'﻿ZiGongShi',	24,	1,	0,	'',	'﻿Z',	0,	2,	0),
(384,	'攀枝花市',	'﻿PanZhiHuaShi',	24,	1,	0,	'',	'﻿P',	0,	2,	0),
(385,	'泸州市',	'﻿LuZhouShi',	24,	1,	0,	'',	'﻿L',	0,	2,	0),
(386,	'德阳市',	'﻿DeYangShi',	24,	1,	0,	'',	'﻿D',	0,	2,	0),
(387,	'绵阳市',	'﻿MianYangShi',	24,	1,	0,	'',	'﻿M',	0,	2,	0),
(388,	'广元市',	'﻿GuangYuanShi',	24,	1,	0,	'',	'﻿G',	0,	2,	0),
(389,	'遂宁市',	'﻿SuiNingShi',	24,	1,	0,	'',	'﻿S',	0,	2,	0),
(390,	'内江市',	'﻿NeiJiangShi',	24,	1,	0,	'',	'﻿N',	0,	2,	0),
(391,	'乐山市',	'﻿LeShanShi',	24,	1,	0,	'',	'﻿L',	0,	2,	0),
(392,	'南充市',	'﻿NanChongShi',	24,	1,	0,	'',	'﻿N',	0,	2,	0),
(393,	'眉山市',	'﻿MeiShanShi',	24,	1,	0,	'',	'﻿M',	0,	2,	0),
(394,	'宜宾市',	'﻿YiBinShi',	24,	1,	0,	'',	'﻿Y',	0,	2,	0),
(395,	'广安市',	'﻿GuangAnShi',	24,	1,	0,	'',	'﻿G',	0,	2,	0),
(396,	'达州市',	'﻿DaZhouShi',	24,	1,	0,	'',	'﻿D',	0,	2,	0),
(397,	'雅安市',	'﻿YaAnShi',	24,	1,	0,	'',	'﻿Y',	0,	2,	0),
(398,	'巴中市',	'﻿BaZhongShi',	24,	1,	0,	'',	'﻿B',	0,	2,	0),
(399,	'资阳市',	'﻿ZiYangShi',	24,	1,	0,	'',	'﻿Z',	0,	2,	0),
(400,	'阿坝州',	'﻿ABaZhou',	24,	1,	0,	'',	'﻿A',	0,	2,	0),
(401,	'甘孜州',	'﻿GanZiZhou',	24,	1,	0,	'',	'﻿G',	0,	2,	0),
(402,	'凉山州',	'﻿LiangShanZhou',	24,	1,	0,	'',	'﻿L',	0,	2,	0),
(403,	'贵阳市',	'﻿GuiYangShi',	25,	1,	0,	'',	'﻿G',	0,	2,	0),
(404,	'六盘水市',	'﻿LiuPanShuiShi',	25,	1,	0,	'',	'﻿L',	0,	2,	0),
(405,	'遵义市',	'﻿ZunYiShi',	25,	1,	0,	'',	'﻿Z',	0,	2,	0),
(406,	'安顺市',	'﻿AnShunShi',	25,	1,	0,	'',	'﻿A',	0,	2,	0),
(407,	'铜仁地区',	'﻿TongRenDiQu',	25,	1,	0,	'',	'﻿T',	0,	2,	0),
(408,	'黔西南州',	'﻿QianXiNanZhou',	25,	1,	0,	'',	'﻿Q',	0,	2,	0),
(409,	'毕节地区',	'﻿BiJieDiQu',	25,	1,	0,	'',	'﻿B',	0,	2,	0),
(410,	'黔东南州',	'﻿QianDongNanZhou',	25,	1,	0,	'',	'﻿Q',	0,	2,	0),
(411,	'黔南州',	'﻿QianNanZhou',	25,	1,	0,	'',	'﻿Q',	0,	2,	0),
(412,	'昆明市',	'﻿KunMingShi',	26,	1,	0,	'',	'﻿K',	0,	2,	0),
(413,	'曲靖市',	'﻿QuJingShi',	26,	1,	0,	'',	'﻿Q',	0,	2,	0),
(414,	'玉溪市',	'﻿YuXiShi',	26,	1,	0,	'',	'﻿Y',	0,	2,	0),
(415,	'保山市',	'﻿BaoShanShi',	26,	1,	0,	'',	'﻿B',	0,	2,	0),
(416,	'昭通市',	'﻿ZhaoTongShi',	26,	1,	0,	'',	'﻿Z',	0,	2,	0),
(417,	'丽江市',	'﻿LiJiangShi',	26,	1,	0,	'',	'﻿L',	0,	2,	0),
(418,	'思茅市',	'﻿SiMaoShi',	26,	1,	0,	'',	'﻿S',	0,	2,	0),
(419,	'临沧市',	'﻿LinCangShi',	26,	1,	0,	'',	'﻿L',	0,	2,	0),
(420,	'楚雄州',	'﻿ChuXiongZhou',	26,	1,	0,	'',	'﻿C',	0,	2,	0),
(421,	'红河州',	'﻿HongHeZhou',	26,	1,	0,	'',	'﻿H',	0,	2,	0),
(422,	'文山州',	'﻿WenShanZhou',	26,	1,	0,	'',	'﻿W',	0,	2,	0),
(423,	'西双版纳',	'﻿XiShuangBanNa',	26,	1,	0,	'',	'﻿X',	0,	2,	0),
(424,	'大理',	'﻿DaLi',	26,	1,	0,	'',	'﻿D',	0,	2,	0),
(425,	'德宏',	'﻿DeHong',	26,	1,	0,	'',	'﻿D',	0,	2,	0),
(426,	'怒江',	'﻿NuJiang',	26,	1,	0,	'',	'﻿N',	0,	2,	0),
(427,	'迪庆',	'﻿DiQing',	26,	1,	0,	'',	'﻿D',	0,	2,	0),
(428,	'拉萨市',	'﻿LaSaShi',	27,	1,	0,	'',	'﻿L',	0,	2,	0),
(429,	'昌都',	'﻿ChangDu',	27,	1,	0,	'',	'﻿C',	0,	2,	0),
(430,	'山南',	'﻿ShanNan',	27,	1,	0,	'',	'﻿S',	0,	2,	0),
(431,	'日喀则',	'﻿RiKaZe',	27,	1,	0,	'',	'﻿R',	0,	2,	0),
(432,	'那曲',	'﻿NaQu',	27,	1,	0,	'',	'﻿N',	0,	2,	0),
(433,	'阿里',	'﻿ALi',	27,	1,	0,	'',	'﻿A',	0,	2,	0),
(434,	'林芝',	'﻿LinZhi',	27,	1,	0,	'',	'﻿L',	0,	2,	0),
(435,	'西安市',	'﻿XiAnShi',	28,	1,	0,	'',	'﻿X',	0,	2,	0),
(436,	'铜川市',	'﻿TongChuanShi',	28,	1,	0,	'',	'﻿T',	0,	2,	0),
(437,	'宝鸡市',	'﻿BaoJiShi',	28,	1,	0,	'',	'﻿B',	0,	2,	0),
(438,	'咸阳市',	'﻿XianYangShi',	28,	1,	0,	'',	'﻿X',	0,	2,	0),
(439,	'渭南市',	'﻿WeiNanShi',	28,	1,	0,	'',	'﻿W',	0,	2,	0),
(440,	'延安市',	'﻿YanAnShi',	28,	1,	0,	'',	'﻿Y',	0,	2,	0),
(441,	'汉中市',	'﻿HanZhongShi',	28,	1,	0,	'',	'﻿H',	0,	2,	0),
(442,	'榆林市',	'﻿YuLinShi',	28,	1,	0,	'',	'﻿Y',	0,	2,	0),
(443,	'安康市',	'﻿AnKangShi',	28,	1,	0,	'',	'﻿A',	0,	2,	0),
(444,	'商洛市',	'﻿ShangLuoShi',	28,	1,	0,	'',	'﻿S',	0,	2,	0),
(445,	'兰州市',	'﻿LanZhouShi',	29,	1,	0,	'',	'﻿L',	0,	2,	0),
(446,	'嘉峪关市',	'﻿JiaYuGuanShi',	29,	1,	0,	'',	'﻿J',	0,	2,	0),
(447,	'金昌市',	'﻿JinChangShi',	29,	1,	0,	'',	'﻿J',	0,	2,	0),
(448,	'白银市',	'﻿BaiYinShi',	29,	1,	0,	'',	'﻿B',	0,	2,	0),
(449,	'天水市',	'﻿TianShuiShi',	29,	1,	0,	'',	'﻿T',	0,	2,	0),
(450,	'武威市',	'﻿WuWeiShi',	29,	1,	0,	'',	'﻿W',	0,	2,	0),
(451,	'张掖市',	'﻿ZhangYeShi',	29,	1,	0,	'',	'﻿Z',	0,	2,	0),
(452,	'平凉市',	'﻿PingLiangShi',	29,	1,	0,	'',	'﻿P',	0,	2,	0),
(453,	'酒泉市',	'﻿JiuQuanShi',	29,	1,	0,	'',	'﻿J',	0,	2,	0),
(454,	'庆阳市',	'﻿QingYangShi',	29,	1,	0,	'',	'﻿Q',	0,	2,	0),
(455,	'定西市',	'﻿DingXiShi',	29,	1,	0,	'',	'﻿D',	0,	2,	0),
(456,	'陇南市',	'﻿LongNanShi',	29,	1,	0,	'',	'﻿L',	0,	2,	0),
(457,	'临夏州',	'﻿LinXiaZhou',	29,	1,	0,	'',	'﻿L',	0,	2,	0),
(458,	'甘州',	'﻿GanZhou',	29,	1,	0,	'',	'﻿G',	0,	2,	0),
(459,	'西宁市',	'﻿XiNingShi',	30,	1,	0,	'',	'﻿X',	0,	2,	0),
(460,	'海东地区',	'﻿HaiDongDiQu',	30,	1,	0,	'',	'﻿H',	0,	2,	0),
(461,	'海州',	'﻿HaiZhou',	30,	1,	0,	'',	'﻿H',	0,	2,	0),
(462,	'黄南州',	'﻿HuangNanZhou',	30,	1,	0,	'',	'﻿H',	0,	2,	0),
(463,	'海南州',	'﻿HaiNanZhou',	30,	1,	0,	'',	'﻿H',	0,	2,	0),
(464,	'果洛州',	'﻿GuoLuoZhou',	30,	1,	0,	'',	'﻿G',	0,	2,	0),
(465,	'玉树州',	'﻿YuShuZhou',	30,	1,	0,	'',	'﻿Y',	0,	2,	0),
(466,	'海西州',	'﻿HaiXiZhou',	30,	1,	0,	'',	'﻿H',	0,	2,	0),
(467,	'银川市',	'﻿YinChuanShi',	31,	1,	0,	'',	'﻿Y',	0,	2,	0),
(468,	'石嘴山市',	'﻿ShiZuiShanShi',	31,	1,	0,	'',	'﻿S',	0,	2,	0),
(469,	'吴忠市',	'﻿WuZhongShi',	31,	1,	0,	'',	'﻿W',	0,	2,	0),
(470,	'固原市',	'﻿GuYuanShi',	31,	1,	0,	'',	'﻿G',	0,	2,	0),
(471,	'中卫市',	'﻿ZhongWeiShi',	31,	1,	0,	'',	'﻿Z',	0,	2,	0),
(472,	'乌鲁木齐市',	'﻿WuLuMuQiShi',	32,	1,	0,	'',	'﻿W',	0,	2,	0),
(473,	'克拉玛依市',	'﻿KeLaMaYiShi',	32,	1,	0,	'',	'﻿K',	0,	2,	0),
(474,	'吐鲁番地区',	'﻿TuLuFanDiQu',	32,	1,	0,	'',	'﻿T',	0,	2,	0),
(475,	'哈密地区',	'﻿HaMiDiQu',	32,	1,	0,	'',	'﻿H',	0,	2,	0),
(476,	'昌吉州',	'﻿ChangJiZhou',	32,	1,	0,	'',	'﻿C',	0,	2,	0),
(477,	'博尔州',	'﻿BoErZhou',	32,	1,	0,	'',	'﻿B',	0,	2,	0),
(478,	'巴音郭楞州',	'﻿BaYinGuoLengZhou',	32,	1,	0,	'',	'﻿B',	0,	2,	0),
(479,	'阿克苏地区',	'﻿AKeSuDiQu',	32,	1,	0,	'',	'﻿A',	0,	2,	0),
(480,	'克孜勒苏柯尔克孜自治州',	'﻿KeZiLeSuKeErKeZiZiZhiZhou',	32,	1,	0,	'',	'﻿K',	0,	2,	0),
(481,	'喀什地区',	'﻿KaShiDiQu',	32,	1,	0,	'',	'﻿K',	0,	2,	0),
(482,	'和田地区',	'﻿HeTianDiQu',	32,	1,	0,	'',	'﻿H',	0,	2,	0),
(483,	'伊犁州',	'﻿YiLiZhou',	32,	1,	0,	'',	'﻿Y',	0,	2,	0),
(484,	'塔城地区',	'﻿TaChengDiQu',	32,	1,	0,	'',	'﻿T',	0,	2,	0),
(485,	'阿勒泰地区',	'﻿ALeTaiDiQu',	32,	1,	0,	'',	'﻿A',	0,	2,	0),
(486,	'石河子市',	'﻿ShiHeZiShi',	32,	1,	0,	'',	'﻿S',	0,	2,	0),
(487,	'阿拉尔市',	'﻿ALaErShi',	32,	1,	0,	'',	'﻿A',	0,	2,	0),
(488,	'图木舒克市',	'﻿TuMuShuKeShi',	32,	1,	0,	'',	'﻿T',	0,	2,	0),
(489,	'五家渠市',	'﻿WuJiaQuShi',	32,	1,	0,	'',	'﻿W',	0,	2,	0),
(490,	'台北市',	'﻿TaiBeiShi',	33,	1,	0,	'',	'﻿T',	0,	2,	0),
(491,	'高雄市',	'﻿GaoXiongShi',	33,	1,	0,	'',	'﻿G',	0,	2,	0),
(492,	'基隆市',	'﻿JiLongShi',	33,	1,	0,	'',	'﻿J',	0,	2,	0),
(493,	'新竹市',	'﻿XinZhuShi',	33,	1,	0,	'',	'﻿X',	0,	2,	0),
(494,	'台中市',	'﻿TaiZhongShi',	33,	1,	0,	'',	'﻿T',	0,	2,	0),
(495,	'嘉义市',	'﻿JiaYiShi',	33,	1,	0,	'',	'﻿J',	0,	2,	0),
(496,	'台南市',	'﻿TaiNanShi',	33,	1,	0,	'',	'﻿T',	0,	2,	0),
(497,	'台北县',	'﻿TaiBeiXian',	33,	1,	0,	'',	'﻿T',	0,	2,	0),
(498,	'桃园县',	'﻿TaoYuanXian',	33,	1,	0,	'',	'﻿T',	0,	2,	0),
(499,	'新竹县',	'﻿XinZhuXian',	33,	1,	0,	'',	'﻿X',	0,	2,	0),
(500,	'苗栗县',	'﻿MiaoLiXian',	33,	1,	0,	'',	'﻿M',	0,	2,	0),
(501,	'台中县',	'﻿TaiZhongXian',	33,	1,	0,	'',	'﻿T',	0,	2,	0),
(502,	'彰化县',	'﻿ZhangHuaXian',	33,	1,	0,	'',	'﻿Z',	0,	2,	0),
(503,	'南投县',	'﻿NanTouXian',	33,	1,	0,	'',	'﻿N',	0,	2,	0),
(504,	'云林县',	'﻿YunLinXian',	33,	1,	0,	'',	'﻿Y',	0,	2,	0),
(505,	'嘉义县',	'﻿JiaYiXian',	33,	1,	0,	'',	'﻿J',	0,	2,	0),
(506,	'台南县',	'﻿TaiNanXian',	33,	1,	0,	'',	'﻿T',	0,	2,	0),
(507,	'高雄县',	'﻿GaoXiongXian',	33,	1,	0,	'',	'﻿G',	0,	2,	0),
(508,	'屏东县',	'﻿PingDongXian',	33,	1,	0,	'',	'﻿P',	0,	2,	0),
(509,	'宜兰县',	'﻿YiLanXian',	33,	1,	0,	'',	'﻿Y',	0,	2,	0),
(510,	'花莲县',	'﻿HuaLianXian',	33,	1,	0,	'',	'﻿H',	0,	2,	0),
(511,	'台东县',	'﻿TaiDongXian',	33,	1,	0,	'',	'﻿T',	0,	2,	0),
(512,	'澎湖县',	'﻿PengHuXian',	33,	1,	0,	'',	'﻿P',	0,	2,	0),
(513,	'金门县',	'﻿JinMenXian',	33,	1,	0,	'',	'﻿J',	0,	2,	0),
(514,	'连江县',	'﻿LianJiangXian',	33,	1,	0,	'',	'﻿L',	0,	2,	0),
(515,	'中西区',	'﻿ZhongXiQu',	34,	1,	0,	'',	'﻿Z',	0,	2,	0),
(516,	'东区',	'﻿DongQu',	34,	1,	0,	'',	'﻿D',	0,	2,	0),
(517,	'南区',	'﻿NanQu',	34,	1,	0,	'',	'﻿N',	0,	2,	0),
(518,	'湾仔区',	'﻿WanZiQu',	34,	1,	0,	'',	'﻿W',	0,	2,	0),
(519,	'九龙城区',	'﻿JiuLongChengQu',	34,	1,	0,	'',	'﻿J',	0,	2,	0),
(520,	'观塘区',	'﻿GuanTangQu',	34,	1,	0,	'',	'﻿G',	0,	2,	0),
(521,	'深水埗区',	'﻿ShenShui',	34,	1,	0,	'',	'﻿S',	0,	2,	0),
(522,	'黄大仙区',	'﻿HuangDaXianQu',	34,	1,	0,	'',	'﻿H',	0,	2,	0),
(523,	'油尖旺区',	'﻿YouJianWangQu',	34,	1,	0,	'',	'﻿Y',	0,	2,	0),
(524,	'离岛区',	'﻿LiDaoQu',	34,	1,	0,	'',	'﻿L',	0,	2,	0),
(525,	'葵青区',	'﻿KuiQingQu',	34,	1,	0,	'',	'﻿K',	0,	2,	0),
(526,	'北区',	'﻿BeiQu',	34,	1,	0,	'',	'﻿B',	0,	2,	0),
(527,	'西贡区',	'﻿XiGongQu',	34,	1,	0,	'',	'﻿X',	0,	2,	0),
(528,	'沙田区',	'﻿ShaTianQu',	34,	1,	0,	'',	'﻿S',	0,	2,	0),
(529,	'大埔区',	'﻿DaPuQu',	34,	1,	0,	'',	'﻿D',	0,	2,	0),
(530,	'荃湾区',	'﻿QuanWanQu',	34,	1,	0,	'',	'﻿Q',	0,	2,	0),
(531,	'屯门区',	'﻿TunMenQu',	34,	1,	0,	'',	'﻿T',	0,	2,	0),
(532,	'元朗区',	'﻿YuanLangQu',	34,	1,	0,	'',	'﻿Y',	0,	2,	0),
(533,	'花地玛堂区',	'﻿HuaDiMaTangQu',	35,	1,	0,	'',	'﻿H',	0,	2,	0),
(534,	'市圣安多尼堂区',	'﻿ShiShengAnDuoNiTangQu',	35,	1,	0,	'',	'﻿S',	0,	2,	0),
(535,	'大堂区',	'﻿DaTangQu',	35,	1,	0,	'',	'﻿D',	0,	2,	0),
(536,	'望德堂区',	'﻿WangDeTangQu',	35,	1,	0,	'',	'﻿W',	0,	2,	0),
(537,	'风顺堂区',	'﻿FengShunTangQu',	35,	1,	0,	'',	'﻿F',	0,	2,	0),
(538,	'嘉模堂区',	'﻿JiaMoTangQu',	35,	1,	0,	'',	'﻿J',	0,	2,	0),
(539,	'圣方济各堂区',	'﻿ShengFangJiGeTangQu',	35,	1,	0,	'',	'﻿S',	0,	2,	0),
(540,	'长安区',	'﻿ChangAnQu',	130,	1,	0,	'',	'﻿C',	0,	3,	0),
(541,	'桥东区',	'﻿QiaoDongQu',	130,	1,	0,	'',	'﻿Q',	0,	3,	0),
(542,	'桥西区',	'﻿QiaoXiQu',	130,	1,	0,	'',	'﻿Q',	0,	3,	0),
(543,	'新华区',	'﻿XinHuaQu',	130,	1,	0,	'',	'﻿X',	0,	3,	0),
(544,	'井陉矿区',	'﻿JingXingKuangQu',	130,	1,	0,	'',	'﻿J',	0,	3,	0),
(545,	'裕华区',	'﻿YuHuaQu',	130,	1,	0,	'',	'﻿Y',	0,	3,	0),
(546,	'井陉县',	'﻿JingXingXian',	130,	1,	0,	'',	'﻿J',	0,	3,	0),
(547,	'正定县',	'﻿ZhengDingXian',	130,	1,	0,	'',	'﻿Z',	0,	3,	0),
(548,	'栾城县',	'﻿LuanChengXian',	130,	1,	0,	'',	'﻿L',	0,	3,	0),
(549,	'行唐县',	'﻿XingTangXian',	130,	1,	0,	'',	'﻿X',	0,	3,	0),
(550,	'灵寿县',	'﻿LingShouXian',	130,	1,	0,	'',	'﻿L',	0,	3,	0),
(551,	'高邑县',	'﻿GaoYiXian',	130,	1,	0,	'',	'﻿G',	0,	3,	0),
(552,	'深泽县',	'﻿ShenZeXian',	130,	1,	0,	'',	'﻿S',	0,	3,	0),
(553,	'赞皇县',	'﻿ZanHuangXian',	130,	1,	0,	'',	'﻿Z',	0,	3,	0),
(554,	'无极县',	'﻿WuJiXian',	130,	1,	0,	'',	'﻿W',	0,	3,	0),
(555,	'平山县',	'﻿PingShanXian',	130,	1,	0,	'',	'﻿P',	0,	3,	0),
(556,	'元氏县',	'﻿YuanShiXian',	130,	1,	0,	'',	'﻿Y',	0,	3,	0),
(557,	'赵县',	'﻿ZhaoXian',	130,	1,	0,	'',	'﻿Z',	0,	3,	0),
(558,	'辛集市',	'﻿XinJiShi',	130,	1,	0,	'',	'﻿X',	0,	3,	0),
(559,	'藁城市',	'﻿GaoChengShi',	130,	1,	0,	'',	'﻿G',	0,	3,	0),
(560,	'晋州市',	'﻿JinZhouShi',	130,	1,	0,	'',	'﻿J',	0,	3,	0),
(561,	'新乐市',	'﻿XinLeShi',	130,	1,	0,	'',	'﻿X',	0,	3,	0),
(562,	'鹿泉市',	'﻿LuQuanShi',	130,	1,	0,	'',	'﻿L',	0,	3,	0),
(563,	'路南区',	'﻿LuNanQu',	131,	1,	0,	'',	'﻿L',	0,	3,	0),
(564,	'路北区',	'﻿LuBeiQu',	131,	1,	0,	'',	'﻿L',	0,	3,	0),
(565,	'古冶区',	'﻿GuYeQu',	131,	1,	0,	'',	'﻿G',	0,	3,	0),
(566,	'开平区',	'﻿KaiPingQu',	131,	1,	0,	'',	'﻿K',	0,	3,	0),
(567,	'丰南区',	'﻿FengNanQu',	131,	1,	0,	'',	'﻿F',	0,	3,	0),
(568,	'丰润区',	'﻿FengRunQu',	131,	1,	0,	'',	'﻿F',	0,	3,	0),
(569,	'滦县',	'﻿LuanXian',	131,	1,	0,	'',	'﻿L',	0,	3,	0),
(570,	'滦南县',	'﻿LuanNanXian',	131,	1,	0,	'',	'﻿L',	0,	3,	0),
(571,	'乐亭县',	'﻿LeTingXian',	131,	1,	0,	'',	'﻿L',	0,	3,	0),
(572,	'迁西县',	'﻿QianXiXian',	131,	1,	0,	'',	'﻿Q',	0,	3,	0),
(573,	'玉田县',	'﻿YuTianXian',	131,	1,	0,	'',	'﻿Y',	0,	3,	0),
(574,	'唐海县',	'﻿TangHaiXian',	131,	1,	0,	'',	'﻿T',	0,	3,	0),
(575,	'遵化市',	'﻿ZunHuaShi',	131,	1,	0,	'',	'﻿Z',	0,	3,	0),
(576,	'迁安市',	'﻿QianAnShi',	131,	1,	0,	'',	'﻿Q',	0,	3,	0),
(577,	'海港区',	'﻿HaiGangQu',	132,	1,	0,	'',	'﻿H',	0,	3,	0),
(578,	'山海关区',	'﻿ShanHaiGuanQu',	132,	1,	0,	'',	'﻿S',	0,	3,	0),
(579,	'北戴河区',	'﻿BeiDaiHeQu',	132,	1,	0,	'',	'﻿B',	0,	3,	0),
(580,	'青龙县',	'﻿QingLongXian',	132,	1,	0,	'',	'﻿Q',	0,	3,	0),
(581,	'昌黎县',	'﻿ChangLiXian',	132,	1,	0,	'',	'﻿C',	0,	3,	0),
(582,	'抚宁县',	'﻿FuNingXian',	132,	1,	0,	'',	'﻿F',	0,	3,	0),
(583,	'卢龙县',	'﻿LuLongXian',	132,	1,	0,	'',	'﻿L',	0,	3,	0),
(584,	'邯山区',	'﻿HanShanQu',	133,	1,	0,	'',	'﻿H',	0,	3,	0),
(585,	'丛台区',	'﻿CongTaiQu',	133,	1,	0,	'',	'﻿C',	0,	3,	0),
(586,	'复兴区',	'﻿FuXingQu',	133,	1,	0,	'',	'﻿F',	0,	3,	0),
(587,	'峰峰矿区',	'﻿FengFengKuangQu',	133,	1,	0,	'',	'﻿F',	0,	3,	0),
(588,	'邯郸县',	'﻿HanDanXian',	133,	1,	0,	'',	'﻿H',	0,	3,	0),
(589,	'临漳县',	'﻿LinZhangXian',	133,	1,	0,	'',	'﻿L',	0,	3,	0),
(590,	'成安县',	'﻿ChengAnXian',	133,	1,	0,	'',	'﻿C',	0,	3,	0),
(591,	'大名县',	'﻿DaMingXian',	133,	1,	0,	'',	'﻿D',	0,	3,	0),
(592,	'涉县',	'﻿SheXian',	133,	1,	0,	'',	'﻿S',	0,	3,	0),
(593,	'磁县',	'﻿CiXian',	133,	1,	0,	'',	'﻿C',	0,	3,	0),
(594,	'肥乡县',	'﻿FeiXiangXian',	133,	1,	0,	'',	'﻿F',	0,	3,	0),
(595,	'永年县',	'﻿YongNianXian',	133,	1,	0,	'',	'﻿Y',	0,	3,	0),
(596,	'邱县',	'﻿QiuXian',	133,	1,	0,	'',	'﻿Q',	0,	3,	0),
(597,	'鸡泽县',	'﻿JiZeXian',	133,	1,	0,	'',	'﻿J',	0,	3,	0),
(598,	'广平县',	'﻿GuangPingXian',	133,	1,	0,	'',	'﻿G',	0,	3,	0),
(599,	'馆陶县',	'﻿GuanTaoXian',	133,	1,	0,	'',	'﻿G',	0,	3,	0),
(600,	'魏县',	'﻿WeiXian',	133,	1,	0,	'',	'﻿W',	0,	3,	0),
(601,	'曲周县',	'﻿QuZhouXian',	133,	1,	0,	'',	'﻿Q',	0,	3,	0),
(602,	'武安市',	'﻿WuAnShi',	133,	1,	0,	'',	'﻿W',	0,	3,	0),
(603,	'桥东区',	'﻿QiaoDongQu',	134,	1,	0,	'',	'﻿Q',	0,	3,	0),
(604,	'桥西区',	'﻿QiaoXiQu',	134,	1,	0,	'',	'﻿Q',	0,	3,	0),
(605,	'邢台县',	'﻿XingTaiXian',	134,	1,	0,	'',	'﻿X',	0,	3,	0),
(606,	'临城县',	'﻿LinChengXian',	134,	1,	0,	'',	'﻿L',	0,	3,	0),
(607,	'内丘县',	'﻿NeiQiuXian',	134,	1,	0,	'',	'﻿N',	0,	3,	0),
(608,	'柏乡县',	'﻿BaiXiangXian',	134,	1,	0,	'',	'﻿B',	0,	3,	0),
(609,	'隆尧县',	'﻿LongYaoXian',	134,	1,	0,	'',	'﻿L',	0,	3,	0),
(610,	'任县',	'﻿RenXian',	134,	1,	0,	'',	'﻿R',	0,	3,	0),
(611,	'南和县',	'﻿NanHeXian',	134,	1,	0,	'',	'﻿N',	0,	3,	0),
(612,	'宁晋县',	'﻿NingJinXian',	134,	1,	0,	'',	'﻿N',	0,	3,	0),
(613,	'巨鹿县',	'﻿JuLuXian',	134,	1,	0,	'',	'﻿J',	0,	3,	0),
(614,	'新河县',	'﻿XinHeXian',	134,	1,	0,	'',	'﻿X',	0,	3,	0),
(615,	'广宗县',	'﻿GuangZongXian',	134,	1,	0,	'',	'﻿G',	0,	3,	0),
(616,	'平乡县',	'﻿PingXiangXian',	134,	1,	0,	'',	'﻿P',	0,	3,	0),
(617,	'威县',	'﻿WeiXian',	134,	1,	0,	'',	'﻿W',	0,	3,	0),
(618,	'清河县',	'﻿QingHeXian',	134,	1,	0,	'',	'﻿Q',	0,	3,	0),
(619,	'临西县',	'﻿LinXiXian',	134,	1,	0,	'',	'﻿L',	0,	3,	0),
(620,	'南宫市',	'﻿NanGongShi',	134,	1,	0,	'',	'﻿N',	0,	3,	0),
(621,	'沙河市',	'﻿ShaHeShi',	134,	1,	0,	'',	'﻿S',	0,	3,	0),
(622,	'新市区',	'﻿XinShiQu',	135,	1,	0,	'',	'﻿X',	0,	3,	0),
(623,	'北市区',	'﻿BeiShiQu',	135,	1,	0,	'',	'﻿B',	0,	3,	0),
(624,	'南市区',	'﻿NanShiQu',	135,	1,	0,	'',	'﻿N',	0,	3,	0),
(625,	'满城县',	'﻿ManChengXian',	135,	1,	0,	'',	'﻿M',	0,	3,	0),
(626,	'清苑县',	'﻿QingYuanXian',	135,	1,	0,	'',	'﻿Q',	0,	3,	0),
(627,	'涞水县',	'﻿LaiShuiXian',	135,	1,	0,	'',	'﻿L',	0,	3,	0),
(628,	'阜平县',	'﻿FuPingXian',	135,	1,	0,	'',	'﻿F',	0,	3,	0),
(629,	'徐水县',	'﻿XuShuiXian',	135,	1,	0,	'',	'﻿X',	0,	3,	0),
(630,	'定兴县',	'﻿DingXingXian',	135,	1,	0,	'',	'﻿D',	0,	3,	0),
(631,	'唐县',	'﻿TangXian',	135,	1,	0,	'',	'﻿T',	0,	3,	0),
(632,	'高阳县',	'﻿GaoYangXian',	135,	1,	0,	'',	'﻿G',	0,	3,	0),
(633,	'容城县',	'﻿RongChengXian',	135,	1,	0,	'',	'﻿R',	0,	3,	0),
(634,	'涞源县',	'﻿LaiYuanXian',	135,	1,	0,	'',	'﻿L',	0,	3,	0),
(635,	'望都县',	'﻿WangDuXian',	135,	1,	0,	'',	'﻿W',	0,	3,	0),
(636,	'安新县',	'﻿AnXinXian',	135,	1,	0,	'',	'﻿A',	0,	3,	0),
(637,	'易县',	'﻿YiXian',	135,	1,	0,	'',	'﻿Y',	0,	3,	0),
(638,	'曲阳县',	'﻿QuYangXian',	135,	1,	0,	'',	'﻿Q',	0,	3,	0),
(639,	'蠡县',	'﻿LiXian',	135,	1,	0,	'',	'﻿L',	0,	3,	0),
(640,	'顺平县',	'﻿ShunPingXian',	135,	1,	0,	'',	'﻿S',	0,	3,	0),
(641,	'博野县',	'﻿BoYeXian',	135,	1,	0,	'',	'﻿B',	0,	3,	0),
(642,	'雄县',	'﻿XiongXian',	135,	1,	0,	'',	'﻿X',	0,	3,	0),
(643,	'涿州市',	'﻿ZhuoZhouShi',	135,	1,	0,	'',	'﻿Z',	0,	3,	0),
(644,	'定州市',	'﻿DingZhouShi',	135,	1,	0,	'',	'﻿D',	0,	3,	0),
(645,	'安国市',	'﻿AnGuoShi',	135,	1,	0,	'',	'﻿A',	0,	3,	0),
(646,	'高碑店市',	'﻿GaoBeiDianShi',	135,	1,	0,	'',	'﻿G',	0,	3,	0),
(647,	'桥东区',	'﻿QiaoDongQu',	136,	1,	0,	'',	'﻿Q',	0,	3,	0),
(648,	'桥西区',	'﻿QiaoXiQu',	136,	1,	0,	'',	'﻿Q',	0,	3,	0),
(649,	'宣化区',	'﻿XuanHuaQu',	136,	1,	0,	'',	'﻿X',	0,	3,	0),
(650,	'下花园区',	'﻿XiaHuaYuanQu',	136,	1,	0,	'',	'﻿X',	0,	3,	0),
(651,	'宣化县',	'﻿XuanHuaXian',	136,	1,	0,	'',	'﻿X',	0,	3,	0),
(652,	'张北县',	'﻿ZhangBeiXian',	136,	1,	0,	'',	'﻿Z',	0,	3,	0),
(653,	'康保县',	'﻿KangBaoXian',	136,	1,	0,	'',	'﻿K',	0,	3,	0),
(654,	'沽源县',	'﻿GuYuanXian',	136,	1,	0,	'',	'﻿G',	0,	3,	0),
(655,	'尚义县',	'﻿ShangYiXian',	136,	1,	0,	'',	'﻿S',	0,	3,	0),
(656,	'蔚县',	'﻿WeiXian',	136,	1,	0,	'',	'﻿W',	0,	3,	0),
(657,	'阳原县',	'﻿YangYuanXian',	136,	1,	0,	'',	'﻿Y',	0,	3,	0),
(658,	'怀安县',	'﻿HuaiAnXian',	136,	1,	0,	'',	'﻿H',	0,	3,	0),
(659,	'万全县',	'﻿WanQuanXian',	136,	1,	0,	'',	'﻿W',	0,	3,	0),
(660,	'怀来县',	'﻿HuaiLaiXian',	136,	1,	0,	'',	'﻿H',	0,	3,	0),
(661,	'涿鹿县',	'﻿ZhuoLuXian',	136,	1,	0,	'',	'﻿Z',	0,	3,	0),
(662,	'赤城县',	'﻿ChiChengXian',	136,	1,	0,	'',	'﻿C',	0,	3,	0),
(663,	'崇礼县',	'﻿ChongLiXian',	136,	1,	0,	'',	'﻿C',	0,	3,	0),
(664,	'双桥区',	'﻿ShuangQiaoQu',	137,	1,	0,	'',	'﻿S',	0,	3,	0),
(665,	'双滦区',	'﻿ShuangLuanQu',	137,	1,	0,	'',	'﻿S',	0,	3,	0),
(666,	'鹰手营子矿区',	'﻿YingShouYingZiKuangQu',	137,	1,	0,	'',	'﻿Y',	0,	3,	0),
(667,	'承德县',	'﻿ChengDeXian',	137,	1,	0,	'',	'﻿C',	0,	3,	0),
(668,	'兴隆县',	'﻿XingLongXian',	137,	1,	0,	'',	'﻿X',	0,	3,	0),
(669,	'平泉县',	'﻿PingQuanXian',	137,	1,	0,	'',	'﻿P',	0,	3,	0),
(670,	'滦平县',	'﻿LuanPingXian',	137,	1,	0,	'',	'﻿L',	0,	3,	0),
(671,	'隆化县',	'﻿LongHuaXian',	137,	1,	0,	'',	'﻿L',	0,	3,	0),
(672,	'丰宁县',	'﻿FengNingXian',	137,	1,	0,	'',	'﻿F',	0,	3,	0),
(673,	'宽城县',	'﻿KuanChengXian',	137,	1,	0,	'',	'﻿K',	0,	3,	0),
(674,	'围场县',	'﻿WeiChangXian',	137,	1,	0,	'',	'﻿W',	0,	3,	0),
(675,	'新华区',	'﻿XinHuaQu',	138,	1,	0,	'',	'﻿X',	0,	3,	0),
(676,	'运河区',	'﻿YunHeQu',	138,	1,	0,	'',	'﻿Y',	0,	3,	0),
(677,	'沧县',	'﻿CangXian',	138,	1,	0,	'',	'﻿C',	0,	3,	0),
(678,	'青县',	'﻿QingXian',	138,	1,	0,	'',	'﻿Q',	0,	3,	0),
(679,	'东光县',	'﻿DongGuangXian',	138,	1,	0,	'',	'﻿D',	0,	3,	0),
(680,	'海兴县',	'﻿HaiXingXian',	138,	1,	0,	'',	'﻿H',	0,	3,	0),
(681,	'盐山县',	'﻿YanShanXian',	138,	1,	0,	'',	'﻿Y',	0,	3,	0),
(682,	'肃宁县',	'﻿SuNingXian',	138,	1,	0,	'',	'﻿S',	0,	3,	0),
(683,	'南皮县',	'﻿NanPiXian',	138,	1,	0,	'',	'﻿N',	0,	3,	0),
(684,	'吴桥县',	'﻿WuQiaoXian',	138,	1,	0,	'',	'﻿W',	0,	3,	0),
(685,	'献县',	'﻿XianXian',	138,	1,	0,	'',	'﻿X',	0,	3,	0),
(686,	'孟村县',	'﻿MengCunXian',	138,	1,	0,	'',	'﻿M',	0,	3,	0),
(687,	'泊头市',	'﻿BoTouShi',	138,	1,	0,	'',	'﻿B',	0,	3,	0),
(688,	'任丘市',	'﻿RenQiuShi',	138,	1,	0,	'',	'﻿R',	0,	3,	0),
(689,	'黄骅市',	'﻿HuangHuaShi',	138,	1,	0,	'',	'﻿H',	0,	3,	0),
(690,	'河间市',	'﻿HeJianShi',	138,	1,	0,	'',	'﻿H',	0,	3,	0),
(691,	'安次区',	'﻿AnCiQu',	139,	1,	0,	'',	'﻿A',	0,	3,	0),
(692,	'广阳区',	'﻿GuangYangQu',	139,	1,	0,	'',	'﻿G',	0,	3,	0),
(693,	'固安县',	'﻿GuAnXian',	139,	1,	0,	'',	'﻿G',	0,	3,	0),
(694,	'永清县',	'﻿YongQingXian',	139,	1,	0,	'',	'﻿Y',	0,	3,	0),
(695,	'香河县',	'﻿XiangHeXian',	139,	1,	0,	'',	'﻿X',	0,	3,	0),
(696,	'大城县',	'﻿DaChengXian',	139,	1,	0,	'',	'﻿D',	0,	3,	0),
(697,	'文安县',	'﻿WenAnXian',	139,	1,	0,	'',	'﻿W',	0,	3,	0),
(698,	'大厂县',	'﻿DaChangXian',	139,	1,	0,	'',	'﻿D',	0,	3,	0),
(699,	'霸州市',	'﻿BaZhouShi',	139,	1,	0,	'',	'﻿B',	0,	3,	0),
(700,	'三河市',	'﻿SanHeShi',	139,	1,	0,	'',	'﻿S',	0,	3,	0),
(701,	'桃城区',	'﻿TaoChengQu',	140,	1,	0,	'',	'﻿T',	0,	3,	0),
(702,	'枣强县',	'﻿ZaoQiangXian',	140,	1,	0,	'',	'﻿Z',	0,	3,	0),
(703,	'武邑县',	'﻿WuYiXian',	140,	1,	0,	'',	'﻿W',	0,	3,	0),
(704,	'武强县',	'﻿WuQiangXian',	140,	1,	0,	'',	'﻿W',	0,	3,	0),
(705,	'饶阳县',	'﻿RaoYangXian',	140,	1,	0,	'',	'﻿R',	0,	3,	0),
(706,	'安平县',	'﻿AnPingXian',	140,	1,	0,	'',	'﻿A',	0,	3,	0),
(707,	'故城县',	'﻿GuChengXian',	140,	1,	0,	'',	'﻿G',	0,	3,	0),
(708,	'景县',	'﻿JingXian',	140,	1,	0,	'',	'﻿J',	0,	3,	0),
(709,	'阜城县',	'﻿FuChengXian',	140,	1,	0,	'',	'﻿F',	0,	3,	0),
(710,	'冀州市',	'﻿JiZhouShi',	140,	1,	0,	'',	'﻿J',	0,	3,	0),
(711,	'深州市',	'﻿ShenZhouShi',	140,	1,	0,	'',	'﻿S',	0,	3,	0),
(712,	'小店区',	'﻿XiaoDianQu',	141,	1,	0,	'',	'﻿X',	0,	3,	0),
(713,	'迎泽区',	'﻿YingZeQu',	141,	1,	0,	'',	'﻿Y',	0,	3,	0),
(714,	'杏花岭区',	'﻿XingHuaLingQu',	141,	1,	0,	'',	'﻿X',	0,	3,	0),
(715,	'尖草坪区',	'﻿JianCaoPingQu',	141,	1,	0,	'',	'﻿J',	0,	3,	0),
(716,	'万柏林区',	'﻿WanBaiLinQu',	141,	1,	0,	'',	'﻿W',	0,	3,	0),
(717,	'晋源区',	'﻿JinYuanQu',	141,	1,	0,	'',	'﻿J',	0,	3,	0),
(718,	'清徐县',	'﻿QingXuXian',	141,	1,	0,	'',	'﻿Q',	0,	3,	0),
(719,	'阳曲县',	'﻿YangQuXian',	141,	1,	0,	'',	'﻿Y',	0,	3,	0),
(720,	'娄烦县',	'﻿LouFanXian',	141,	1,	0,	'',	'﻿L',	0,	3,	0),
(721,	'古交市',	'﻿GuJiaoShi',	141,	1,	0,	'',	'﻿G',	0,	3,	0),
(722,	'城区',	'﻿ChengQu',	142,	1,	0,	'',	'﻿C',	0,	3,	0),
(723,	'矿区',	'﻿KuangQu',	142,	1,	0,	'',	'﻿K',	0,	3,	0),
(724,	'南郊区',	'﻿NanJiaoQu',	142,	1,	0,	'',	'﻿N',	0,	3,	0),
(725,	'新荣区',	'﻿XinRongQu',	142,	1,	0,	'',	'﻿X',	0,	3,	0),
(726,	'阳高县',	'﻿YangGaoXian',	142,	1,	0,	'',	'﻿Y',	0,	3,	0),
(727,	'天镇县',	'﻿TianZhenXian',	142,	1,	0,	'',	'﻿T',	0,	3,	0),
(728,	'广灵县',	'﻿GuangLingXian',	142,	1,	0,	'',	'﻿G',	0,	3,	0),
(729,	'灵丘县',	'﻿LingQiuXian',	142,	1,	0,	'',	'﻿L',	0,	3,	0),
(730,	'浑源县',	'﻿HunYuanXian',	142,	1,	0,	'',	'﻿H',	0,	3,	0),
(731,	'左云县',	'﻿ZuoYunXian',	142,	1,	0,	'',	'﻿Z',	0,	3,	0),
(732,	'大同县',	'﻿DaTongXian',	142,	1,	0,	'',	'﻿D',	0,	3,	0),
(733,	'城区',	'﻿ChengQu',	143,	1,	0,	'',	'﻿C',	0,	3,	0),
(734,	'矿区',	'﻿KuangQu',	143,	1,	0,	'',	'﻿K',	0,	3,	0),
(735,	'郊区',	'﻿JiaoQu',	143,	1,	0,	'',	'﻿J',	0,	3,	0),
(736,	'平定县',	'﻿PingDingXian',	143,	1,	0,	'',	'﻿P',	0,	3,	0),
(737,	'盂县',	'﻿YuXian',	143,	1,	0,	'',	'﻿Y',	0,	3,	0),
(738,	'城区',	'﻿ChengQu',	144,	1,	0,	'',	'﻿C',	0,	3,	0),
(739,	'郊区',	'﻿JiaoQu',	144,	1,	0,	'',	'﻿J',	0,	3,	0),
(740,	'长治县',	'﻿ChangZhiXian',	144,	1,	0,	'',	'﻿C',	0,	3,	0),
(741,	'襄垣县',	'﻿XiangYuanXian',	144,	1,	0,	'',	'﻿X',	0,	3,	0),
(742,	'屯留县',	'﻿TunLiuXian',	144,	1,	0,	'',	'﻿T',	0,	3,	0),
(743,	'平顺县',	'﻿PingShunXian',	144,	1,	0,	'',	'﻿P',	0,	3,	0),
(744,	'黎城县',	'﻿LiChengXian',	144,	1,	0,	'',	'﻿L',	0,	3,	0),
(745,	'壶关县',	'﻿HuGuanXian',	144,	1,	0,	'',	'﻿H',	0,	3,	0),
(746,	'长子县',	'﻿ChangZiXian',	144,	1,	0,	'',	'﻿C',	0,	3,	0),
(747,	'武乡县',	'﻿WuXiangXian',	144,	1,	0,	'',	'﻿W',	0,	3,	0),
(748,	'沁县',	'﻿QinXian',	144,	1,	0,	'',	'﻿Q',	0,	3,	0),
(749,	'沁源县',	'﻿QinYuanXian',	144,	1,	0,	'',	'﻿Q',	0,	3,	0),
(750,	'潞城市',	'﻿LuChengShi',	144,	1,	0,	'',	'﻿L',	0,	3,	0),
(751,	'城区',	'﻿ChengQu',	145,	1,	0,	'',	'﻿C',	0,	3,	0),
(752,	'沁水县',	'﻿QinShuiXian',	145,	1,	0,	'',	'﻿Q',	0,	3,	0),
(753,	'阳城县',	'﻿YangChengXian',	145,	1,	0,	'',	'﻿Y',	0,	3,	0),
(754,	'陵川县',	'﻿LingChuanXian',	145,	1,	0,	'',	'﻿L',	0,	3,	0),
(755,	'泽州县',	'﻿ZeZhouXian',	145,	1,	0,	'',	'﻿Z',	0,	3,	0),
(756,	'高平市',	'﻿GaoPingShi',	145,	1,	0,	'',	'﻿G',	0,	3,	0),
(757,	'朔城区',	'﻿ShuoChengQu',	146,	1,	0,	'',	'﻿S',	0,	3,	0),
(758,	'平鲁区',	'﻿PingLuQu',	146,	1,	0,	'',	'﻿P',	0,	3,	0),
(759,	'山阴县',	'﻿ShanYinXian',	146,	1,	0,	'',	'﻿S',	0,	3,	0),
(760,	'应县',	'﻿YingXian',	146,	1,	0,	'',	'﻿Y',	0,	3,	0),
(761,	'右玉县',	'﻿YouYuXian',	146,	1,	0,	'',	'﻿Y',	0,	3,	0),
(762,	'怀仁县',	'﻿HuaiRenXian',	146,	1,	0,	'',	'﻿H',	0,	3,	0),
(763,	'榆次区',	'﻿YuCiQu',	147,	1,	0,	'',	'﻿Y',	0,	3,	0),
(764,	'榆社县',	'﻿YuSheXian',	147,	1,	0,	'',	'﻿Y',	0,	3,	0),
(765,	'左权县',	'﻿ZuoQuanXian',	147,	1,	0,	'',	'﻿Z',	0,	3,	0),
(766,	'和顺县',	'﻿HeShunXian',	147,	1,	0,	'',	'﻿H',	0,	3,	0),
(767,	'昔阳县',	'﻿XiYangXian',	147,	1,	0,	'',	'﻿X',	0,	3,	0),
(768,	'寿阳县',	'﻿ShouYangXian',	147,	1,	0,	'',	'﻿S',	0,	3,	0),
(769,	'太谷县',	'﻿TaiGuXian',	147,	1,	0,	'',	'﻿T',	0,	3,	0),
(770,	'祁县',	'﻿QiXian',	147,	1,	0,	'',	'﻿Q',	0,	3,	0),
(771,	'平遥县',	'﻿PingYaoXian',	147,	1,	0,	'',	'﻿P',	0,	3,	0),
(772,	'灵石县',	'﻿LingShiXian',	147,	1,	0,	'',	'﻿L',	0,	3,	0),
(773,	'介休市',	'﻿JieXiuShi',	147,	1,	0,	'',	'﻿J',	0,	3,	0),
(774,	'盐湖区',	'﻿YanHuQu',	148,	1,	0,	'',	'﻿Y',	0,	3,	0),
(775,	'临猗县',	'﻿LinYiXian',	148,	1,	0,	'',	'﻿L',	0,	3,	0),
(776,	'万荣县',	'﻿WanRongXian',	148,	1,	0,	'',	'﻿W',	0,	3,	0),
(777,	'闻喜县',	'﻿WenXiXian',	148,	1,	0,	'',	'﻿W',	0,	3,	0),
(778,	'稷山县',	'﻿JiShanXian',	148,	1,	0,	'',	'﻿J',	0,	3,	0),
(779,	'新绛县',	'﻿XinJiangXian',	148,	1,	0,	'',	'﻿X',	0,	3,	0),
(780,	'绛县',	'﻿JiangXian',	148,	1,	0,	'',	'﻿J',	0,	3,	0),
(781,	'垣曲县',	'﻿YuanQuXian',	148,	1,	0,	'',	'﻿Y',	0,	3,	0),
(782,	'夏县',	'﻿XiaXian',	148,	1,	0,	'',	'﻿X',	0,	3,	0),
(783,	'平陆县',	'﻿PingLuXian',	148,	1,	0,	'',	'﻿P',	0,	3,	0),
(784,	'芮城县',	'﻿RuiChengXian',	148,	1,	0,	'',	'﻿R',	0,	3,	0),
(785,	'永济市',	'﻿YongJiShi',	148,	1,	0,	'',	'﻿Y',	0,	3,	0),
(786,	'河津市',	'﻿HeJinShi',	148,	1,	0,	'',	'﻿H',	0,	3,	0),
(787,	'忻府区',	'﻿XinFuQu',	149,	1,	0,	'',	'﻿X',	0,	3,	0),
(788,	'定襄县',	'﻿DingXiangXian',	149,	1,	0,	'',	'﻿D',	0,	3,	0),
(789,	'五台县',	'﻿WuTaiXian',	149,	1,	0,	'',	'﻿W',	0,	3,	0),
(790,	'代县',	'﻿DaiXian',	149,	1,	0,	'',	'﻿D',	0,	3,	0),
(791,	'繁峙县',	'﻿FanZhiXian',	149,	1,	0,	'',	'﻿F',	0,	3,	0),
(792,	'宁武县',	'﻿NingWuXian',	149,	1,	0,	'',	'﻿N',	0,	3,	0),
(793,	'静乐县',	'﻿JingLeXian',	149,	1,	0,	'',	'﻿J',	0,	3,	0),
(794,	'神池县',	'﻿ShenChiXian',	149,	1,	0,	'',	'﻿S',	0,	3,	0),
(795,	'五寨县',	'﻿WuZhaiXian',	149,	1,	0,	'',	'﻿W',	0,	3,	0),
(796,	'岢岚县',	'﻿KeLanXian',	149,	1,	0,	'',	'﻿K',	0,	3,	0),
(797,	'河曲县',	'﻿HeQuXian',	149,	1,	0,	'',	'﻿H',	0,	3,	0),
(798,	'保德县',	'﻿BaoDeXian',	149,	1,	0,	'',	'﻿B',	0,	3,	0),
(799,	'偏关县',	'﻿PianGuanXian',	149,	1,	0,	'',	'﻿P',	0,	3,	0),
(800,	'原平市',	'﻿YuanPingShi',	149,	1,	0,	'',	'﻿Y',	0,	3,	0),
(801,	'尧都区',	'﻿YaoDuQu',	150,	1,	0,	'',	'﻿Y',	0,	3,	0),
(802,	'曲沃县',	'﻿QuWoXian',	150,	1,	0,	'',	'﻿Q',	0,	3,	0),
(803,	'翼城县',	'﻿YiChengXian',	150,	1,	0,	'',	'﻿Y',	0,	3,	0),
(804,	'襄汾县',	'﻿XiangFenXian',	150,	1,	0,	'',	'﻿X',	0,	3,	0),
(805,	'洪洞县',	'﻿HongDongXian',	150,	1,	0,	'',	'﻿H',	0,	3,	0),
(806,	'古县',	'﻿GuXian',	150,	1,	0,	'',	'﻿G',	0,	3,	0),
(807,	'安泽县',	'﻿AnZeXian',	150,	1,	0,	'',	'﻿A',	0,	3,	0),
(808,	'浮山县',	'﻿FuShanXian',	150,	1,	0,	'',	'﻿F',	0,	3,	0),
(809,	'吉县',	'﻿JiXian',	150,	1,	0,	'',	'﻿J',	0,	3,	0),
(810,	'乡宁县',	'﻿XiangNingXian',	150,	1,	0,	'',	'﻿X',	0,	3,	0),
(811,	'大宁县',	'﻿DaNingXian',	150,	1,	0,	'',	'﻿D',	0,	3,	0),
(812,	'隰县',	'﻿XiXian',	150,	1,	0,	'',	'﻿X',	0,	3,	0),
(813,	'永和县',	'﻿YongHeXian',	150,	1,	0,	'',	'﻿Y',	0,	3,	0),
(814,	'蒲县',	'﻿PuXian',	150,	1,	0,	'',	'﻿P',	0,	3,	0),
(815,	'汾西县',	'﻿FenXiXian',	150,	1,	0,	'',	'﻿F',	0,	3,	0),
(816,	'侯马市',	'﻿HouMaShi',	150,	1,	0,	'',	'﻿H',	0,	3,	0),
(817,	'霍州市',	'﻿HuoZhouShi',	150,	1,	0,	'',	'﻿H',	0,	3,	0),
(818,	'离石区',	'﻿LiShiQu',	151,	1,	0,	'',	'﻿L',	0,	3,	0),
(819,	'文水县',	'﻿WenShuiXian',	151,	1,	0,	'',	'﻿W',	0,	3,	0),
(820,	'交城县',	'﻿JiaoChengXian',	151,	1,	0,	'',	'﻿J',	0,	3,	0),
(821,	'兴县',	'﻿XingXian',	151,	1,	0,	'',	'﻿X',	0,	3,	0),
(822,	'临县',	'﻿LinXian',	151,	1,	0,	'',	'﻿L',	0,	3,	0),
(823,	'柳林县',	'﻿LiuLinXian',	151,	1,	0,	'',	'﻿L',	0,	3,	0),
(824,	'石楼县',	'﻿ShiLouXian',	151,	1,	0,	'',	'﻿S',	0,	3,	0),
(825,	'岚县',	'﻿LanXian',	151,	1,	0,	'',	'﻿L',	0,	3,	0),
(826,	'方山县',	'﻿FangShanXian',	151,	1,	0,	'',	'﻿F',	0,	3,	0),
(827,	'中阳县',	'﻿ZhongYangXian',	151,	1,	0,	'',	'﻿Z',	0,	3,	0),
(828,	'交口县',	'﻿JiaoKouXian',	151,	1,	0,	'',	'﻿J',	0,	3,	0),
(829,	'孝义市',	'﻿XiaoYiShi',	151,	1,	0,	'',	'﻿X',	0,	3,	0),
(830,	'汾阳市',	'﻿FenYangShi',	151,	1,	0,	'',	'﻿F',	0,	3,	0),
(831,	'新城区',	'﻿XinChengQu',	152,	1,	0,	'',	'﻿X',	0,	3,	0),
(832,	'回民区',	'﻿HuiMinQu',	152,	1,	0,	'',	'﻿H',	0,	3,	0),
(833,	'玉泉区',	'﻿YuQuanQu',	152,	1,	0,	'',	'﻿Y',	0,	3,	0),
(834,	'赛罕区',	'﻿SaiHanQu',	152,	1,	0,	'',	'﻿S',	0,	3,	0),
(835,	'土默特左旗',	'﻿TuMoTeZuoQi',	152,	1,	0,	'',	'﻿T',	0,	3,	0),
(836,	'托克托县',	'﻿TuoKeTuoXian',	152,	1,	0,	'',	'﻿T',	0,	3,	0),
(837,	'和林格尔县',	'﻿HeLinGeErXian',	152,	1,	0,	'',	'﻿H',	0,	3,	0),
(838,	'清水河县',	'﻿QingShuiHeXian',	152,	1,	0,	'',	'﻿Q',	0,	3,	0),
(839,	'武川县',	'﻿WuChuanXian',	152,	1,	0,	'',	'﻿W',	0,	3,	0),
(840,	'东河区',	'﻿DongHeQu',	153,	1,	0,	'',	'﻿D',	0,	3,	0),
(841,	'昆都仑区',	'﻿KunDuLunQu',	153,	1,	0,	'',	'﻿K',	0,	3,	0),
(842,	'青山区',	'﻿QingShanQu',	153,	1,	0,	'',	'﻿Q',	0,	3,	0),
(843,	'石拐区',	'﻿ShiGuaiQu',	153,	1,	0,	'',	'﻿S',	0,	3,	0),
(844,	'白云矿区',	'﻿BaiYunKuangQu',	153,	1,	0,	'',	'﻿B',	0,	3,	0),
(845,	'九原区',	'﻿JiuYuanQu',	153,	1,	0,	'',	'﻿J',	0,	3,	0),
(846,	'土默特右旗',	'﻿TuMoTeYouQi',	153,	1,	0,	'',	'﻿T',	0,	3,	0),
(847,	'固阳县',	'﻿GuYangXian',	153,	1,	0,	'',	'﻿G',	0,	3,	0),
(848,	'达尔罕茂明安联合旗',	'﻿DaErHanMaoMingAnLianHeQi',	153,	1,	0,	'',	'﻿D',	0,	3,	0),
(849,	'海勃湾区',	'﻿HaiBoWanQu',	154,	1,	0,	'',	'﻿H',	0,	3,	0),
(850,	'海南区',	'﻿HaiNanQu',	154,	1,	0,	'',	'﻿H',	0,	3,	0),
(851,	'乌达区',	'﻿WuDaQu',	154,	1,	0,	'',	'﻿W',	0,	3,	0),
(852,	'红山区',	'﻿HongShanQu',	155,	1,	0,	'',	'﻿H',	0,	3,	0),
(853,	'元宝山区',	'﻿YuanBaoShanQu',	155,	1,	0,	'',	'﻿Y',	0,	3,	0),
(854,	'松山区',	'﻿SongShanQu',	155,	1,	0,	'',	'﻿S',	0,	3,	0),
(855,	'阿鲁科尔沁旗',	'﻿ALuKeErQinQi',	155,	1,	0,	'',	'﻿A',	0,	3,	0),
(856,	'巴林左旗',	'﻿BaLinZuoQi',	155,	1,	0,	'',	'﻿B',	0,	3,	0),
(857,	'巴林右旗',	'﻿BaLinYouQi',	155,	1,	0,	'',	'﻿B',	0,	3,	0),
(858,	'林西县',	'﻿LinXiXian',	155,	1,	0,	'',	'﻿L',	0,	3,	0),
(859,	'克什克腾旗',	'﻿KeShiKeTengQi',	155,	1,	0,	'',	'﻿K',	0,	3,	0),
(860,	'翁牛特旗',	'﻿WengNiuTeQi',	155,	1,	0,	'',	'﻿W',	0,	3,	0),
(861,	'喀喇沁旗',	'﻿KaLaQinQi',	155,	1,	0,	'',	'﻿K',	0,	3,	0),
(862,	'宁城县',	'﻿NingChengXian',	155,	1,	0,	'',	'﻿N',	0,	3,	0),
(863,	'敖汉旗',	'﻿AoHanQi',	155,	1,	0,	'',	'﻿A',	0,	3,	0),
(864,	'科尔沁区',	'﻿KeErQinQu',	156,	1,	0,	'',	'﻿K',	0,	3,	0),
(865,	'科尔沁左翼中旗',	'﻿KeErQinZuoYiZhongQi',	156,	1,	0,	'',	'﻿K',	0,	3,	0),
(866,	'科尔沁左翼后旗',	'﻿KeErQinZuoYiHouQi',	156,	1,	0,	'',	'﻿K',	0,	3,	0),
(867,	'开鲁县',	'﻿KaiLuXian',	156,	1,	0,	'',	'﻿K',	0,	3,	0),
(868,	'库伦旗',	'﻿KuLunQi',	156,	1,	0,	'',	'﻿K',	0,	3,	0),
(869,	'奈曼旗',	'﻿NaiManQi',	156,	1,	0,	'',	'﻿N',	0,	3,	0),
(870,	'扎鲁特旗',	'﻿ZaLuTeQi',	156,	1,	0,	'',	'﻿Z',	0,	3,	0),
(871,	'霍林郭勒市',	'﻿HuoLinGuoLeShi',	156,	1,	0,	'',	'﻿H',	0,	3,	0),
(872,	'东胜区',	'﻿DongShengQu',	157,	1,	0,	'',	'﻿D',	0,	3,	0),
(873,	'达拉特旗',	'﻿DaLaTeQi',	157,	1,	0,	'',	'﻿D',	0,	3,	0),
(874,	'准格尔旗',	'﻿ZhunGeErQi',	157,	1,	0,	'',	'﻿Z',	0,	3,	0),
(875,	'鄂托克前旗',	'﻿ETuoKeQianQi',	157,	1,	0,	'',	'﻿E',	0,	3,	0),
(876,	'鄂托克旗',	'﻿ETuoKeQi',	157,	1,	0,	'',	'﻿E',	0,	3,	0),
(877,	'杭锦旗',	'﻿HangJinQi',	157,	1,	0,	'',	'﻿H',	0,	3,	0),
(878,	'乌审旗',	'﻿WuShenQi',	157,	1,	0,	'',	'﻿W',	0,	3,	0),
(879,	'伊金霍洛旗',	'﻿YiJinHuoLuoQi',	157,	1,	0,	'',	'﻿Y',	0,	3,	0),
(880,	'海拉尔区',	'﻿HaiLaErQu',	158,	1,	0,	'',	'﻿H',	0,	3,	0),
(881,	'阿荣旗',	'﻿ARongQi',	158,	1,	0,	'',	'﻿A',	0,	3,	0),
(882,	'莫力达瓦达斡尔族自治旗',	'﻿MoLiDaWaDaWoErZuZiZhiQi',	158,	1,	0,	'',	'﻿M',	0,	3,	0),
(883,	'鄂伦春自治旗',	'﻿ELunChunZiZhiQi',	158,	1,	0,	'',	'﻿E',	0,	3,	0),
(884,	'鄂温克族自治旗',	'﻿EWenKeZuZiZhiQi',	158,	1,	0,	'',	'﻿E',	0,	3,	0),
(885,	'陈巴尔虎旗',	'﻿ChenBaErHuQi',	158,	1,	0,	'',	'﻿C',	0,	3,	0),
(886,	'新巴尔虎左旗',	'﻿XinBaErHuZuoQi',	158,	1,	0,	'',	'﻿X',	0,	3,	0),
(887,	'新巴尔虎右旗',	'﻿XinBaErHuYouQi',	158,	1,	0,	'',	'﻿X',	0,	3,	0),
(888,	'满洲里市',	'﻿ManZhouLiShi',	158,	1,	0,	'',	'﻿M',	0,	3,	0),
(889,	'牙克石市',	'﻿YaKeShiShi',	158,	1,	0,	'',	'﻿Y',	0,	3,	0),
(890,	'扎兰屯市',	'﻿ZaLanTunShi',	158,	1,	0,	'',	'﻿Z',	0,	3,	0),
(891,	'额尔古纳市',	'﻿EErGuNaShi',	158,	1,	0,	'',	'﻿E',	0,	3,	0),
(892,	'根河市',	'﻿GenHeShi',	158,	1,	0,	'',	'﻿G',	0,	3,	0),
(893,	'临河区',	'﻿LinHeQu',	159,	1,	0,	'',	'﻿L',	0,	3,	0),
(894,	'五原县',	'﻿WuYuanXian',	159,	1,	0,	'',	'﻿W',	0,	3,	0),
(895,	'磴口县',	'﻿DengKouXian',	159,	1,	0,	'',	'﻿D',	0,	3,	0),
(896,	'乌拉特前旗',	'﻿WuLaTeQianQi',	159,	1,	0,	'',	'﻿W',	0,	3,	0),
(897,	'乌拉特中旗',	'﻿WuLaTeZhongQi',	159,	1,	0,	'',	'﻿W',	0,	3,	0),
(898,	'乌拉特后旗',	'﻿WuLaTeHouQi',	159,	1,	0,	'',	'﻿W',	0,	3,	0),
(899,	'杭锦后旗',	'﻿HangJinHouQi',	159,	1,	0,	'',	'﻿H',	0,	3,	0),
(900,	'集宁区',	'﻿JiNingQu',	160,	1,	0,	'',	'﻿J',	0,	3,	0),
(901,	'卓资县',	'﻿ZhuoZiXian',	160,	1,	0,	'',	'﻿Z',	0,	3,	0),
(902,	'化德县',	'﻿HuaDeXian',	160,	1,	0,	'',	'﻿H',	0,	3,	0),
(903,	'商都县',	'﻿ShangDuXian',	160,	1,	0,	'',	'﻿S',	0,	3,	0),
(904,	'兴和县',	'﻿XingHeXian',	160,	1,	0,	'',	'﻿X',	0,	3,	0),
(905,	'凉城县',	'﻿LiangChengXian',	160,	1,	0,	'',	'﻿L',	0,	3,	0),
(906,	'察哈尔右翼前旗',	'﻿ChaHaErYouYiQianQi',	160,	1,	0,	'',	'﻿C',	0,	3,	0),
(907,	'察哈尔右翼中旗',	'﻿ChaHaErYouYiZhongQi',	160,	1,	0,	'',	'﻿C',	0,	3,	0),
(908,	'察哈尔右翼后旗',	'﻿ChaHaErYouYiHouQi',	160,	1,	0,	'',	'﻿C',	0,	3,	0),
(909,	'四子王旗',	'﻿SiZiWangQi',	160,	1,	0,	'',	'﻿S',	0,	3,	0),
(910,	'丰镇市',	'﻿FengZhenShi',	160,	1,	0,	'',	'﻿F',	0,	3,	0),
(911,	'乌兰浩特市',	'﻿WuLanHaoTeShi',	161,	1,	0,	'',	'﻿W',	0,	3,	0),
(912,	'阿尔山市',	'﻿AErShanShi',	161,	1,	0,	'',	'﻿A',	0,	3,	0),
(913,	'科尔沁右翼前旗',	'﻿KeErQinYouYiQianQi',	161,	1,	0,	'',	'﻿K',	0,	3,	0),
(914,	'科尔沁右翼中旗',	'﻿KeErQinYouYiZhongQi',	161,	1,	0,	'',	'﻿K',	0,	3,	0),
(915,	'扎赉特旗',	'﻿ZaLaiTeQi',	161,	1,	0,	'',	'﻿Z',	0,	3,	0),
(916,	'突泉县',	'﻿TuQuanXian',	161,	1,	0,	'',	'﻿T',	0,	3,	0),
(917,	'二连浩特市',	'﻿ErLianHaoTeShi',	162,	1,	0,	'',	'﻿E',	0,	3,	0),
(918,	'锡林浩特市',	'﻿XiLinHaoTeShi',	162,	1,	0,	'',	'﻿X',	0,	3,	0),
(919,	'阿巴嘎旗',	'﻿ABaGaQi',	162,	1,	0,	'',	'﻿A',	0,	3,	0),
(920,	'苏尼特左旗',	'﻿SuNiTeZuoQi',	162,	1,	0,	'',	'﻿S',	0,	3,	0),
(921,	'苏尼特右旗',	'﻿SuNiTeYouQi',	162,	1,	0,	'',	'﻿S',	0,	3,	0),
(922,	'东乌珠穆沁旗',	'﻿DongWuZhuMuQinQi',	162,	1,	0,	'',	'﻿D',	0,	3,	0),
(923,	'西乌珠穆沁旗',	'﻿XiWuZhuMuQinQi',	162,	1,	0,	'',	'﻿X',	0,	3,	0),
(924,	'太仆寺旗',	'﻿TaiPuSiQi',	162,	1,	0,	'',	'﻿T',	0,	3,	0),
(925,	'镶黄旗',	'﻿XiangHuangQi',	162,	1,	0,	'',	'﻿X',	0,	3,	0),
(926,	'正镶白旗',	'﻿ZhengXiangBaiQi',	162,	1,	0,	'',	'﻿Z',	0,	3,	0),
(927,	'正蓝旗',	'﻿ZhengLanQi',	162,	1,	0,	'',	'﻿Z',	0,	3,	0),
(928,	'多伦县',	'﻿DuoLunXian',	162,	1,	0,	'',	'﻿D',	0,	3,	0),
(929,	'阿拉善左旗',	'﻿ALaShanZuoQi',	163,	1,	0,	'',	'﻿A',	0,	3,	0),
(930,	'阿拉善右旗',	'﻿ALaShanYouQi',	163,	1,	0,	'',	'﻿A',	0,	3,	0),
(931,	'额济纳旗',	'﻿EJiNaQi',	163,	1,	0,	'',	'﻿E',	0,	3,	0),
(932,	'和平区',	'﻿HePingQu',	164,	1,	0,	'',	'﻿H',	0,	3,	0),
(933,	'沈河区',	'﻿ShenHeQu',	164,	1,	0,	'',	'﻿S',	0,	3,	0),
(934,	'大东区',	'﻿DaDongQu',	164,	1,	0,	'',	'﻿D',	0,	3,	0),
(935,	'皇姑区',	'﻿HuangGuQu',	164,	1,	0,	'',	'﻿H',	0,	3,	0),
(936,	'铁西区',	'﻿TieXiQu',	164,	1,	0,	'',	'﻿T',	0,	3,	0),
(937,	'苏家屯区',	'﻿SuJiaTunQu',	164,	1,	0,	'',	'﻿S',	0,	3,	0),
(938,	'东陵区',	'﻿DongLingQu',	164,	1,	0,	'',	'﻿D',	0,	3,	0),
(939,	'新城子区',	'﻿XinChengZiQu',	164,	1,	0,	'',	'﻿X',	0,	3,	0),
(940,	'于洪区',	'﻿YuHongQu',	164,	1,	0,	'',	'﻿Y',	0,	3,	0),
(941,	'辽中县',	'﻿LiaoZhongXian',	164,	1,	0,	'',	'﻿L',	0,	3,	0),
(942,	'康平县',	'﻿KangPingXian',	164,	1,	0,	'',	'﻿K',	0,	3,	0),
(943,	'法库县',	'﻿FaKuXian',	164,	1,	0,	'',	'﻿F',	0,	3,	0),
(944,	'新民市',	'﻿XinMinShi',	164,	1,	0,	'',	'﻿X',	0,	3,	0),
(945,	'中山区',	'﻿ZhongShanQu',	165,	1,	0,	'',	'﻿Z',	0,	3,	0),
(946,	'西岗区',	'﻿XiGangQu',	165,	1,	0,	'',	'﻿X',	0,	3,	0),
(947,	'沙河口区',	'﻿ShaHeKouQu',	165,	1,	0,	'',	'﻿S',	0,	3,	0),
(948,	'甘井子区',	'﻿GanJingZiQu',	165,	1,	0,	'',	'﻿G',	0,	3,	0),
(949,	'旅顺口区',	'﻿LvShunKouQu',	165,	1,	0,	'',	'﻿L',	0,	3,	0),
(950,	'金州区',	'﻿JinZhouQu',	165,	1,	0,	'',	'﻿J',	0,	3,	0),
(951,	'长海县',	'﻿ChangHaiXian',	165,	1,	0,	'',	'﻿C',	0,	3,	0),
(952,	'瓦房店市',	'﻿WaFangDianShi',	165,	1,	0,	'',	'﻿W',	0,	3,	0),
(953,	'普兰店市',	'﻿PuLanDianShi',	165,	1,	0,	'',	'﻿P',	0,	3,	0),
(954,	'庄河市',	'﻿ZhuangHeShi',	165,	1,	0,	'',	'﻿Z',	0,	3,	0),
(955,	'铁东区',	'﻿TieDongQu',	166,	1,	0,	'',	'﻿T',	0,	3,	0),
(956,	'铁西区',	'﻿TieXiQu',	166,	1,	0,	'',	'﻿T',	0,	3,	0),
(957,	'立山区',	'﻿LiShanQu',	166,	1,	0,	'',	'﻿L',	0,	3,	0),
(958,	'千山区',	'﻿QianShanQu',	166,	1,	0,	'',	'﻿Q',	0,	3,	0),
(959,	'台安县',	'﻿TaiAnXian',	166,	1,	0,	'',	'﻿T',	0,	3,	0),
(960,	'岫岩满族自治县',	'﻿XiuYanManZuZiZhiXian',	166,	1,	0,	'',	'﻿X',	0,	3,	0),
(961,	'海城市',	'﻿HaiChengShi',	166,	1,	0,	'',	'﻿H',	0,	3,	0),
(962,	'新抚区',	'﻿XinFuQu',	167,	1,	0,	'',	'﻿X',	0,	3,	0),
(963,	'东洲区',	'﻿DongZhouQu',	167,	1,	0,	'',	'﻿D',	0,	3,	0),
(964,	'望花区',	'﻿WangHuaQu',	167,	1,	0,	'',	'﻿W',	0,	3,	0),
(965,	'顺城区',	'﻿ShunChengQu',	167,	1,	0,	'',	'﻿S',	0,	3,	0),
(966,	'抚顺县',	'﻿FuShunXian',	167,	1,	0,	'',	'﻿F',	0,	3,	0),
(967,	'新宾满族自治县',	'﻿XinBinManZuZiZhiXian',	167,	1,	0,	'',	'﻿X',	0,	3,	0),
(968,	'清原满族自治县',	'﻿QingYuanManZuZiZhiXian',	167,	1,	0,	'',	'﻿Q',	0,	3,	0),
(969,	'平山区',	'﻿PingShanQu',	168,	1,	0,	'',	'﻿P',	0,	3,	0),
(970,	'溪湖区',	'﻿XiHuQu',	168,	1,	0,	'',	'﻿X',	0,	3,	0),
(971,	'明山区',	'﻿MingShanQu',	168,	1,	0,	'',	'﻿M',	0,	3,	0),
(972,	'南芬区',	'﻿NanFenQu',	168,	1,	0,	'',	'﻿N',	0,	3,	0),
(973,	'本溪满族自治县',	'﻿BenXiManZuZiZhiXian',	168,	1,	0,	'',	'﻿B',	0,	3,	0),
(974,	'桓仁满族自治县',	'﻿HuanRenManZuZiZhiXian',	168,	1,	0,	'',	'﻿H',	0,	3,	0),
(975,	'元宝区',	'﻿YuanBaoQu',	169,	1,	0,	'',	'﻿Y',	0,	3,	0),
(976,	'振兴区',	'﻿ZhenXingQu',	169,	1,	0,	'',	'﻿Z',	0,	3,	0),
(977,	'振安区',	'﻿ZhenAnQu',	169,	1,	0,	'',	'﻿Z',	0,	3,	0),
(978,	'宽甸满族自治县',	'﻿KuanDianManZuZiZhiXian',	169,	1,	0,	'',	'﻿K',	0,	3,	0),
(979,	'东港市',	'﻿DongGangShi',	169,	1,	0,	'',	'﻿D',	0,	3,	0),
(980,	'凤城市',	'﻿FengChengShi',	169,	1,	0,	'',	'﻿F',	0,	3,	0),
(981,	'古塔区',	'﻿GuTaQu',	170,	1,	0,	'',	'﻿G',	0,	3,	0),
(982,	'凌河区',	'﻿LingHeQu',	170,	1,	0,	'',	'﻿L',	0,	3,	0),
(983,	'太和区',	'﻿TaiHeQu',	170,	1,	0,	'',	'﻿T',	0,	3,	0),
(984,	'黑山县',	'﻿HeiShanXian',	170,	1,	0,	'',	'﻿H',	0,	3,	0),
(985,	'义县',	'﻿YiXian',	170,	1,	0,	'',	'﻿Y',	0,	3,	0),
(986,	'凌海市',	'﻿LingHaiShi',	170,	1,	0,	'',	'﻿L',	0,	3,	0),
(987,	'北镇市',	'﻿BeiZhenShi',	170,	1,	0,	'',	'﻿B',	0,	3,	0),
(988,	'站前区',	'﻿ZhanQianQu',	171,	1,	0,	'',	'﻿Z',	0,	3,	0),
(989,	'西市区',	'﻿XiShiQu',	171,	1,	0,	'',	'﻿X',	0,	3,	0),
(990,	'鲅鱼圈区',	'﻿BaYuQuanQu',	171,	1,	0,	'',	'﻿B',	0,	3,	0),
(991,	'老边区',	'﻿LaoBianQu',	171,	1,	0,	'',	'﻿L',	0,	3,	0),
(992,	'盖州市',	'﻿GaiZhouShi',	171,	1,	0,	'',	'﻿G',	0,	3,	0),
(993,	'大石桥市',	'﻿DaShiQiaoShi',	171,	1,	0,	'',	'﻿D',	0,	3,	0),
(994,	'海州区',	'﻿HaiZhouQu',	172,	1,	0,	'',	'﻿H',	0,	3,	0),
(995,	'新邱区',	'﻿XinQiuQu',	172,	1,	0,	'',	'﻿X',	0,	3,	0),
(996,	'太平区',	'﻿TaiPingQu',	172,	1,	0,	'',	'﻿T',	0,	3,	0),
(997,	'清河门区',	'﻿QingHeMenQu',	172,	1,	0,	'',	'﻿Q',	0,	3,	0),
(998,	'细河区',	'﻿XiHeQu',	172,	1,	0,	'',	'﻿X',	0,	3,	0),
(999,	'阜新蒙古族自治县',	'﻿FuXinMengGuZuZiZhiXian',	172,	1,	0,	'',	'﻿F',	0,	3,	0),
(1000,	'彰武县',	'﻿ZhangWuXian',	172,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1001,	'白塔区',	'﻿BaiTaQu',	173,	1,	0,	'',	'﻿B',	0,	3,	0),
(1002,	'文圣区',	'﻿WenShengQu',	173,	1,	0,	'',	'﻿W',	0,	3,	0),
(1003,	'宏伟区',	'﻿HongWeiQu',	173,	1,	0,	'',	'﻿H',	0,	3,	0),
(1004,	'弓长岭区',	'﻿GongChangLingQu',	173,	1,	0,	'',	'﻿G',	0,	3,	0),
(1005,	'太子河区',	'﻿TaiZiHeQu',	173,	1,	0,	'',	'﻿T',	0,	3,	0),
(1006,	'辽阳县',	'﻿LiaoYangXian',	173,	1,	0,	'',	'﻿L',	0,	3,	0),
(1007,	'灯塔市',	'﻿DengTaShi',	173,	1,	0,	'',	'﻿D',	0,	3,	0),
(1008,	'双台子区',	'﻿ShuangTaiZiQu',	174,	1,	0,	'',	'﻿S',	0,	3,	0),
(1009,	'兴隆台区',	'﻿XingLongTaiQu',	174,	1,	0,	'',	'﻿X',	0,	3,	0),
(1010,	'大洼县',	'﻿DaWaXian',	174,	1,	0,	'',	'﻿D',	0,	3,	0),
(1011,	'盘山县',	'﻿PanShanXian',	174,	1,	0,	'',	'﻿P',	0,	3,	0),
(1012,	'银州区',	'﻿YinZhouQu',	175,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1013,	'清河区',	'﻿QingHeQu',	175,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1014,	'铁岭县',	'﻿TieLingXian',	175,	1,	0,	'',	'﻿T',	0,	3,	0),
(1015,	'西丰县',	'﻿XiFengXian',	175,	1,	0,	'',	'﻿X',	0,	3,	0),
(1016,	'昌图县',	'﻿ChangTuXian',	175,	1,	0,	'',	'﻿C',	0,	3,	0),
(1017,	'调兵山市',	'﻿DiaoBingShanShi',	175,	1,	0,	'',	'﻿D',	0,	3,	0),
(1018,	'开原市',	'﻿KaiYuanShi',	175,	1,	0,	'',	'﻿K',	0,	3,	0),
(1019,	'双塔区',	'﻿ShuangTaQu',	176,	1,	0,	'',	'﻿S',	0,	3,	0),
(1020,	'龙城区',	'﻿LongChengQu',	176,	1,	0,	'',	'﻿L',	0,	3,	0),
(1021,	'朝阳县',	'﻿ZhaoYangXian',	176,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1022,	'建平县',	'﻿JianPingXian',	176,	1,	0,	'',	'﻿J',	0,	3,	0),
(1023,	'喀喇沁左翼蒙古族自治县',	'﻿KaLaQinZuoYiMengGuZuZiZhiXian',	176,	1,	0,	'',	'﻿K',	0,	3,	0),
(1024,	'北票市',	'﻿BeiPiaoShi',	176,	1,	0,	'',	'﻿B',	0,	3,	0),
(1025,	'凌源市',	'﻿LingYuanShi',	176,	1,	0,	'',	'﻿L',	0,	3,	0),
(1026,	'连山区',	'﻿LianShanQu',	177,	1,	0,	'',	'﻿L',	0,	3,	0),
(1027,	'龙港区',	'﻿LongGangQu',	177,	1,	0,	'',	'﻿L',	0,	3,	0),
(1028,	'南票区',	'﻿NanPiaoQu',	177,	1,	0,	'',	'﻿N',	0,	3,	0),
(1029,	'绥中县',	'﻿SuiZhongXian',	177,	1,	0,	'',	'﻿S',	0,	3,	0),
(1030,	'建昌县',	'﻿JianChangXian',	177,	1,	0,	'',	'﻿J',	0,	3,	0),
(1031,	'兴城市',	'﻿XingChengShi',	177,	1,	0,	'',	'﻿X',	0,	3,	0),
(1032,	'南关区',	'﻿NanGuanQu',	178,	1,	0,	'',	'﻿N',	0,	3,	0),
(1033,	'宽城区',	'﻿KuanChengQu',	178,	1,	0,	'',	'﻿K',	0,	3,	0),
(1034,	'朝阳区',	'﻿ZhaoYangQu',	178,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1035,	'二道区',	'﻿ErDaoQu',	178,	1,	0,	'',	'﻿E',	0,	3,	0),
(1036,	'绿园区',	'﻿LvYuanQu',	178,	1,	0,	'',	'﻿L',	0,	3,	0),
(1037,	'双阳区',	'﻿ShuangYangQu',	178,	1,	0,	'',	'﻿S',	0,	3,	0),
(1038,	'农安县',	'﻿NongAnXian',	178,	1,	0,	'',	'﻿N',	0,	3,	0),
(1039,	'九台市',	'﻿JiuTaiShi',	178,	1,	0,	'',	'﻿J',	0,	3,	0),
(1040,	'榆树市',	'﻿YuShuShi',	178,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1041,	'德惠市',	'﻿DeHuiShi',	178,	1,	0,	'',	'﻿D',	0,	3,	0),
(1042,	'昌邑区',	'﻿ChangYiQu',	179,	1,	0,	'',	'﻿C',	0,	3,	0),
(1043,	'龙潭区',	'﻿LongTanQu',	179,	1,	0,	'',	'﻿L',	0,	3,	0),
(1044,	'船营区',	'﻿ChuanYingQu',	179,	1,	0,	'',	'﻿C',	0,	3,	0),
(1045,	'丰满区',	'﻿FengManQu',	179,	1,	0,	'',	'﻿F',	0,	3,	0),
(1046,	'永吉县',	'﻿YongJiXian',	179,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1047,	'蛟河市',	'﻿JiaoHeShi',	179,	1,	0,	'',	'﻿J',	0,	3,	0),
(1048,	'桦甸市',	'﻿HuaDianShi',	179,	1,	0,	'',	'﻿H',	0,	3,	0),
(1049,	'舒兰市',	'﻿ShuLanShi',	179,	1,	0,	'',	'﻿S',	0,	3,	0),
(1050,	'磐石市',	'﻿PanShiShi',	179,	1,	0,	'',	'﻿P',	0,	3,	0),
(1051,	'铁西区',	'﻿TieXiQu',	180,	1,	0,	'',	'﻿T',	0,	3,	0),
(1052,	'铁东区',	'﻿TieDongQu',	180,	1,	0,	'',	'﻿T',	0,	3,	0),
(1053,	'梨树县',	'﻿LiShuXian',	180,	1,	0,	'',	'﻿L',	0,	3,	0),
(1054,	'伊通满族自治县',	'﻿YiTongManZuZiZhiXian',	180,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1055,	'公主岭市',	'﻿GongZhuLingShi',	180,	1,	0,	'',	'﻿G',	0,	3,	0),
(1056,	'双辽市',	'﻿ShuangLiaoShi',	180,	1,	0,	'',	'﻿S',	0,	3,	0),
(1057,	'龙山区',	'﻿LongShanQu',	181,	1,	0,	'',	'﻿L',	0,	3,	0),
(1058,	'西安区',	'﻿XiAnQu',	181,	1,	0,	'',	'﻿X',	0,	3,	0),
(1059,	'东丰县',	'﻿DongFengXian',	181,	1,	0,	'',	'﻿D',	0,	3,	0),
(1060,	'东辽县',	'﻿DongLiaoXian',	181,	1,	0,	'',	'﻿D',	0,	3,	0),
(1061,	'东昌区',	'﻿DongChangQu',	182,	1,	0,	'',	'﻿D',	0,	3,	0),
(1062,	'二道江区',	'﻿ErDaoJiangQu',	182,	1,	0,	'',	'﻿E',	0,	3,	0),
(1063,	'通化县',	'﻿TongHuaXian',	182,	1,	0,	'',	'﻿T',	0,	3,	0),
(1064,	'辉南县',	'﻿HuiNanXian',	182,	1,	0,	'',	'﻿H',	0,	3,	0),
(1065,	'柳河县',	'﻿LiuHeXian',	182,	1,	0,	'',	'﻿L',	0,	3,	0),
(1066,	'梅河口市',	'﻿MeiHeKouShi',	182,	1,	0,	'',	'﻿M',	0,	3,	0),
(1067,	'集安市',	'﻿JiAnShi',	182,	1,	0,	'',	'﻿J',	0,	3,	0),
(1068,	'八道江区',	'﻿BaDaoJiangQu',	183,	1,	0,	'',	'﻿B',	0,	3,	0),
(1069,	'抚松县',	'﻿FuSongXian',	183,	1,	0,	'',	'﻿F',	0,	3,	0),
(1070,	'靖宇县',	'﻿JingYuXian',	183,	1,	0,	'',	'﻿J',	0,	3,	0),
(1071,	'长白朝鲜族自治县',	'﻿ChangBaiZhaoXianZuZiZhiXian',	183,	1,	0,	'',	'﻿C',	0,	3,	0),
(1072,	'江源县',	'﻿JiangYuanXian',	183,	1,	0,	'',	'﻿J',	0,	3,	0),
(1073,	'临江市',	'﻿LinJiangShi',	183,	1,	0,	'',	'﻿L',	0,	3,	0),
(1074,	'宁江区',	'﻿NingJiangQu',	184,	1,	0,	'',	'﻿N',	0,	3,	0),
(1075,	'前郭尔罗斯蒙古族自治县',	'﻿QianGuoErLuoSiMengGuZuZiZhiXian',	184,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1076,	'长岭县',	'﻿ChangLingXian',	184,	1,	0,	'',	'﻿C',	0,	3,	0),
(1077,	'乾安县',	'﻿QianAnXian',	184,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1078,	'扶余县',	'﻿FuYuXian',	184,	1,	0,	'',	'﻿F',	0,	3,	0),
(1079,	'洮北区',	'﻿TaoBeiQu',	185,	1,	0,	'',	'﻿T',	0,	3,	0),
(1080,	'镇赉县',	'﻿ZhenLaiXian',	185,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1081,	'通榆县',	'﻿TongYuXian',	185,	1,	0,	'',	'﻿T',	0,	3,	0),
(1082,	'洮南市',	'﻿TaoNanShi',	185,	1,	0,	'',	'﻿T',	0,	3,	0),
(1083,	'大安市',	'﻿DaAnShi',	185,	1,	0,	'',	'﻿D',	0,	3,	0),
(1084,	'延吉市',	'﻿YanJiShi',	186,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1085,	'图们市',	'﻿TuMenShi',	186,	1,	0,	'',	'﻿T',	0,	3,	0),
(1086,	'敦化市',	'﻿DunHuaShi',	186,	1,	0,	'',	'﻿D',	0,	3,	0),
(1087,	'珲春市',	'﻿HunChunShi',	186,	1,	0,	'',	'﻿H',	0,	3,	0),
(1088,	'龙井市',	'﻿LongJingShi',	186,	1,	0,	'',	'﻿L',	0,	3,	0),
(1089,	'和龙市',	'﻿HeLongShi',	186,	1,	0,	'',	'﻿H',	0,	3,	0),
(1090,	'汪清县',	'﻿WangQingXian',	186,	1,	0,	'',	'﻿W',	0,	3,	0),
(1091,	'安图县',	'﻿AnTuXian',	186,	1,	0,	'',	'﻿A',	0,	3,	0),
(1092,	'道里区',	'﻿DaoLiQu',	187,	1,	0,	'',	'﻿D',	0,	3,	0),
(1093,	'南岗区',	'﻿NanGangQu',	187,	1,	0,	'',	'﻿N',	0,	3,	0),
(1094,	'道外区',	'﻿DaoWaiQu',	187,	1,	0,	'',	'﻿D',	0,	3,	0),
(1095,	'香坊区',	'﻿XiangFangQu',	187,	1,	0,	'',	'﻿X',	0,	3,	0),
(1096,	'动力区',	'﻿DongLiQu',	187,	1,	0,	'',	'﻿D',	0,	3,	0),
(1097,	'平房区',	'﻿PingFangQu',	187,	1,	0,	'',	'﻿P',	0,	3,	0),
(1098,	'松北区',	'﻿SongBeiQu',	187,	1,	0,	'',	'﻿S',	0,	3,	0),
(1099,	'呼兰区',	'﻿HuLanQu',	187,	1,	0,	'',	'﻿H',	0,	3,	0),
(1100,	'依兰县',	'﻿YiLanXian',	187,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1101,	'方正县',	'﻿FangZhengXian',	187,	1,	0,	'',	'﻿F',	0,	3,	0),
(1102,	'宾县',	'﻿BinXian',	187,	1,	0,	'',	'﻿B',	0,	3,	0),
(1103,	'巴彦县',	'﻿BaYanXian',	187,	1,	0,	'',	'﻿B',	0,	3,	0),
(1104,	'木兰县',	'﻿MuLanXian',	187,	1,	0,	'',	'﻿M',	0,	3,	0),
(1105,	'通河县',	'﻿TongHeXian',	187,	1,	0,	'',	'﻿T',	0,	3,	0),
(1106,	'延寿县',	'﻿YanShouXian',	187,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1107,	'阿城市',	'﻿AChengShi',	187,	1,	0,	'',	'﻿A',	0,	3,	0),
(1108,	'双城市',	'﻿ShuangChengShi',	187,	1,	0,	'',	'﻿S',	0,	3,	0),
(1109,	'尚志市',	'﻿ShangZhiShi',	187,	1,	0,	'',	'﻿S',	0,	3,	0),
(1110,	'五常市',	'﻿WuChangShi',	187,	1,	0,	'',	'﻿W',	0,	3,	0),
(1111,	'龙沙区',	'﻿LongShaQu',	188,	1,	0,	'',	'﻿L',	0,	3,	0),
(1112,	'建华区',	'﻿JianHuaQu',	188,	1,	0,	'',	'﻿J',	0,	3,	0),
(1113,	'铁锋区',	'﻿TieFengQu',	188,	1,	0,	'',	'﻿T',	0,	3,	0),
(1114,	'昂昂溪区',	'﻿AngAngXiQu',	188,	1,	0,	'',	'﻿A',	0,	3,	0),
(1115,	'富拉尔基区',	'﻿FuLaErJiQu',	188,	1,	0,	'',	'﻿F',	0,	3,	0),
(1116,	'碾子山区',	'﻿NianZiShanQu',	188,	1,	0,	'',	'﻿N',	0,	3,	0),
(1117,	'梅里斯达斡尔族区',	'﻿MeiLiSiDaWoErZuQu',	188,	1,	0,	'',	'﻿M',	0,	3,	0),
(1118,	'龙江县',	'﻿LongJiangXian',	188,	1,	0,	'',	'﻿L',	0,	3,	0),
(1119,	'依安县',	'﻿YiAnXian',	188,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1120,	'泰来县',	'﻿TaiLaiXian',	188,	1,	0,	'',	'﻿T',	0,	3,	0),
(1121,	'甘南县',	'﻿GanNanXian',	188,	1,	0,	'',	'﻿G',	0,	3,	0),
(1122,	'富裕县',	'﻿FuYuXian',	188,	1,	0,	'',	'﻿F',	0,	3,	0),
(1123,	'克山县',	'﻿KeShanXian',	188,	1,	0,	'',	'﻿K',	0,	3,	0),
(1124,	'克东县',	'﻿KeDongXian',	188,	1,	0,	'',	'﻿K',	0,	3,	0),
(1125,	'拜泉县',	'﻿BaiQuanXian',	188,	1,	0,	'',	'﻿B',	0,	3,	0),
(1126,	'讷河市',	'﻿NeHeShi',	188,	1,	0,	'',	'﻿N',	0,	3,	0),
(1127,	'鸡冠区',	'﻿JiGuanQu',	189,	1,	0,	'',	'﻿J',	0,	3,	0),
(1128,	'恒山区',	'﻿HengShanQu',	189,	1,	0,	'',	'﻿H',	0,	3,	0),
(1129,	'滴道区',	'﻿DiDaoQu',	189,	1,	0,	'',	'﻿D',	0,	3,	0),
(1130,	'梨树区',	'﻿LiShuQu',	189,	1,	0,	'',	'﻿L',	0,	3,	0),
(1131,	'城子河区',	'﻿ChengZiHeQu',	189,	1,	0,	'',	'﻿C',	0,	3,	0),
(1132,	'麻山区',	'﻿MaShanQu',	189,	1,	0,	'',	'﻿M',	0,	3,	0),
(1133,	'鸡东县',	'﻿JiDongXian',	189,	1,	0,	'',	'﻿J',	0,	3,	0),
(1134,	'虎林市',	'﻿HuLinShi',	189,	1,	0,	'',	'﻿H',	0,	3,	0),
(1135,	'密山市',	'﻿MiShanShi',	189,	1,	0,	'',	'﻿M',	0,	3,	0),
(1136,	'向阳区',	'﻿XiangYangQu',	190,	1,	0,	'',	'﻿X',	0,	3,	0),
(1137,	'工农区',	'﻿GongNongQu',	190,	1,	0,	'',	'﻿G',	0,	3,	0),
(1138,	'南山区',	'﻿NanShanQu',	190,	1,	0,	'',	'﻿N',	0,	3,	0),
(1139,	'兴安区',	'﻿XingAnQu',	190,	1,	0,	'',	'﻿X',	0,	3,	0),
(1140,	'东山区',	'﻿DongShanQu',	190,	1,	0,	'',	'﻿D',	0,	3,	0),
(1141,	'兴山区',	'﻿XingShanQu',	190,	1,	0,	'',	'﻿X',	0,	3,	0),
(1142,	'萝北县',	'﻿LuoBeiXian',	190,	1,	0,	'',	'﻿L',	0,	3,	0),
(1143,	'绥滨县',	'﻿SuiBinXian',	190,	1,	0,	'',	'﻿S',	0,	3,	0),
(1144,	'尖山区',	'﻿JianShanQu',	191,	1,	0,	'',	'﻿J',	0,	3,	0),
(1145,	'岭东区',	'﻿LingDongQu',	191,	1,	0,	'',	'﻿L',	0,	3,	0),
(1146,	'四方台区',	'﻿SiFangTaiQu',	191,	1,	0,	'',	'﻿S',	0,	3,	0),
(1147,	'宝山区',	'﻿BaoShanQu',	191,	1,	0,	'',	'﻿B',	0,	3,	0),
(1148,	'集贤县',	'﻿JiXianXian',	191,	1,	0,	'',	'﻿J',	0,	3,	0),
(1149,	'友谊县',	'﻿YouYiXian',	191,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1150,	'宝清县',	'﻿BaoQingXian',	191,	1,	0,	'',	'﻿B',	0,	3,	0),
(1151,	'饶河县',	'',	191,	1,	0,	'',	'0',	0,	3,	0),
(1152,	'萨尔图区',	'﻿SaErTuQu',	192,	1,	0,	'',	'﻿S',	0,	3,	0),
(1153,	'龙凤区',	'﻿LongFengQu',	192,	1,	0,	'',	'﻿L',	0,	3,	0),
(1154,	'让胡路区',	'﻿RangHuLuQu',	192,	1,	0,	'',	'﻿R',	0,	3,	0),
(1155,	'红岗区',	'﻿HongGangQu',	192,	1,	0,	'',	'﻿H',	0,	3,	0),
(1156,	'大同区',	'﻿DaTongQu',	192,	1,	0,	'',	'﻿D',	0,	3,	0),
(1157,	'肇州县',	'﻿ZhaoZhouXian',	192,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1158,	'肇源县',	'﻿ZhaoYuanXian',	192,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1159,	'林甸县',	'﻿LinDianXian',	192,	1,	0,	'',	'﻿L',	0,	3,	0),
(1160,	'杜尔伯特蒙古族自治县',	'﻿DuErBoTeMengGuZuZiZhiXian',	192,	1,	0,	'',	'﻿D',	0,	3,	0),
(1161,	'伊春区',	'﻿YiChunQu',	193,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1162,	'南岔区',	'﻿NanChaQu',	193,	1,	0,	'',	'﻿N',	0,	3,	0),
(1163,	'友好区',	'﻿YouHaoQu',	193,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1164,	'西林区',	'﻿XiLinQu',	193,	1,	0,	'',	'﻿X',	0,	3,	0),
(1165,	'翠峦区',	'﻿CuiLuanQu',	193,	1,	0,	'',	'﻿C',	0,	3,	0),
(1166,	'新青区',	'﻿XinQingQu',	193,	1,	0,	'',	'﻿X',	0,	3,	0),
(1167,	'美溪区',	'﻿MeiXiQu',	193,	1,	0,	'',	'﻿M',	0,	3,	0),
(1168,	'金山屯区',	'﻿JinShanTunQu',	193,	1,	0,	'',	'﻿J',	0,	3,	0),
(1169,	'五营区',	'﻿WuYingQu',	193,	1,	0,	'',	'﻿W',	0,	3,	0),
(1170,	'乌马河区',	'﻿WuMaHeQu',	193,	1,	0,	'',	'﻿W',	0,	3,	0),
(1171,	'汤旺河区',	'﻿TangWangHeQu',	193,	1,	0,	'',	'﻿T',	0,	3,	0),
(1172,	'带岭区',	'﻿DaiLingQu',	193,	1,	0,	'',	'﻿D',	0,	3,	0),
(1173,	'乌伊岭区',	'﻿WuYiLingQu',	193,	1,	0,	'',	'﻿W',	0,	3,	0),
(1174,	'红星区',	'﻿HongXingQu',	193,	1,	0,	'',	'﻿H',	0,	3,	0),
(1175,	'上甘岭区',	'﻿ShangGanLingQu',	193,	1,	0,	'',	'﻿S',	0,	3,	0),
(1176,	'嘉荫县',	'﻿JiaYinXian',	193,	1,	0,	'',	'﻿J',	0,	3,	0),
(1177,	'铁力市',	'﻿TieLiShi',	193,	1,	0,	'',	'﻿T',	0,	3,	0),
(1178,	'永红区',	'﻿YongHongQu',	194,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1179,	'向阳区',	'﻿XiangYangQu',	194,	1,	0,	'',	'﻿X',	0,	3,	0),
(1180,	'前进区',	'﻿QianJinQu',	194,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1181,	'东风区',	'﻿DongFengQu',	194,	1,	0,	'',	'﻿D',	0,	3,	0),
(1182,	'郊区',	'﻿JiaoQu',	194,	1,	0,	'',	'﻿J',	0,	3,	0),
(1183,	'桦南县',	'﻿HuaNanXian',	194,	1,	0,	'',	'﻿H',	0,	3,	0),
(1184,	'桦川县',	'﻿HuaChuanXian',	194,	1,	0,	'',	'﻿H',	0,	3,	0),
(1185,	'汤原县',	'﻿TangYuanXian',	194,	1,	0,	'',	'﻿T',	0,	3,	0),
(1186,	'抚远县',	'﻿FuYuanXian',	194,	1,	0,	'',	'﻿F',	0,	3,	0),
(1187,	'同江市',	'﻿TongJiangShi',	194,	1,	0,	'',	'﻿T',	0,	3,	0),
(1188,	'富锦市',	'﻿FuJinShi',	194,	1,	0,	'',	'﻿F',	0,	3,	0),
(1189,	'新兴区',	'﻿XinXingQu',	195,	1,	0,	'',	'﻿X',	0,	3,	0),
(1190,	'桃山区',	'﻿TaoShanQu',	195,	1,	0,	'',	'﻿T',	0,	3,	0),
(1191,	'茄子河区',	'﻿QieZiHeQu',	195,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1192,	'勃利县',	'﻿BoLiXian',	195,	1,	0,	'',	'﻿B',	0,	3,	0),
(1193,	'东安区',	'﻿DongAnQu',	196,	1,	0,	'',	'﻿D',	0,	3,	0),
(1194,	'阳明区',	'﻿YangMingQu',	196,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1195,	'爱民区',	'﻿AiMinQu',	196,	1,	0,	'',	'﻿A',	0,	3,	0),
(1196,	'西安区',	'﻿XiAnQu',	196,	1,	0,	'',	'﻿X',	0,	3,	0),
(1197,	'东宁县',	'﻿DongNingXian',	196,	1,	0,	'',	'﻿D',	0,	3,	0),
(1198,	'林口县',	'﻿LinKouXian',	196,	1,	0,	'',	'﻿L',	0,	3,	0),
(1199,	'绥芬河市',	'﻿SuiFenHeShi',	196,	1,	0,	'',	'﻿S',	0,	3,	0),
(1200,	'海林市',	'﻿HaiLinShi',	196,	1,	0,	'',	'﻿H',	0,	3,	0),
(1201,	'宁安市',	'﻿NingAnShi',	196,	1,	0,	'',	'﻿N',	0,	3,	0),
(1202,	'穆棱市',	'﻿MuLengShi',	196,	1,	0,	'',	'﻿M',	0,	3,	0),
(1203,	'爱辉区',	'﻿AiHuiQu',	197,	1,	0,	'',	'﻿A',	0,	3,	0),
(1204,	'嫩江县',	'﻿NenJiangXian',	197,	1,	0,	'',	'﻿N',	0,	3,	0),
(1205,	'逊克县',	'﻿XunKeXian',	197,	1,	0,	'',	'﻿X',	0,	3,	0),
(1206,	'孙吴县',	'﻿SunWuXian',	197,	1,	0,	'',	'﻿S',	0,	3,	0),
(1207,	'北安市',	'﻿BeiAnShi',	197,	1,	0,	'',	'﻿B',	0,	3,	0),
(1208,	'五大连池市',	'﻿WuDaLianChiShi',	197,	1,	0,	'',	'﻿W',	0,	3,	0),
(1209,	'北林区',	'﻿BeiLinQu',	198,	1,	0,	'',	'﻿B',	0,	3,	0),
(1210,	'望奎县',	'﻿WangKuiXian',	198,	1,	0,	'',	'﻿W',	0,	3,	0),
(1211,	'兰西县',	'﻿LanXiXian',	198,	1,	0,	'',	'﻿L',	0,	3,	0),
(1212,	'青冈县',	'﻿QingGangXian',	198,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1213,	'庆安县',	'﻿QingAnXian',	198,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1214,	'明水县',	'﻿MingShuiXian',	198,	1,	0,	'',	'﻿M',	0,	3,	0),
(1215,	'绥棱县',	'﻿SuiLengXian',	198,	1,	0,	'',	'﻿S',	0,	3,	0),
(1216,	'安达市',	'﻿AnDaShi',	198,	1,	0,	'',	'﻿A',	0,	3,	0),
(1217,	'肇东市',	'﻿ZhaoDongShi',	198,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1218,	'海伦市',	'﻿HaiLunShi',	198,	1,	0,	'',	'﻿H',	0,	3,	0),
(1219,	'呼玛县',	'﻿HuMaXian',	199,	1,	0,	'',	'﻿H',	0,	3,	0),
(1220,	'塔河县',	'﻿TaHeXian',	199,	1,	0,	'',	'﻿T',	0,	3,	0),
(1221,	'漠河县',	'﻿MoHeXian',	199,	1,	0,	'',	'﻿M',	0,	3,	0),
(1222,	'玄武区',	'﻿XuanWuQu',	200,	1,	0,	'',	'﻿X',	0,	3,	0),
(1223,	'白下区',	'﻿BaiXiaQu',	200,	1,	0,	'',	'﻿B',	0,	3,	0),
(1224,	'秦淮区',	'﻿QinHuaiQu',	200,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1225,	'建邺区',	'﻿JianYeQu',	200,	1,	0,	'',	'﻿J',	0,	3,	0),
(1226,	'鼓楼区',	'﻿GuLouQu',	200,	1,	0,	'',	'﻿G',	0,	3,	0),
(1227,	'下关区',	'﻿XiaGuanQu',	200,	1,	0,	'',	'﻿X',	0,	3,	0),
(1228,	'浦口区',	'﻿PuKouQu',	200,	1,	0,	'',	'﻿P',	0,	3,	0),
(1229,	'栖霞区',	'﻿QiXiaQu',	200,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1230,	'雨花台区',	'﻿YuHuaTaiQu',	200,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1231,	'江宁区',	'﻿JiangNingQu',	200,	1,	0,	'',	'﻿J',	0,	3,	0),
(1232,	'六合区',	'﻿LiuHeQu',	200,	1,	0,	'',	'﻿L',	0,	3,	0),
(1233,	'溧水县',	'﻿LiShuiXian',	200,	1,	0,	'',	'﻿L',	0,	3,	0),
(1234,	'高淳县',	'﻿GaoChunXian',	200,	1,	0,	'',	'﻿G',	0,	3,	0),
(1235,	'崇安区',	'﻿ChongAnQu',	201,	1,	0,	'',	'﻿C',	0,	3,	0),
(1236,	'南长区',	'﻿NanChangQu',	201,	1,	0,	'',	'﻿N',	0,	3,	0),
(1237,	'北塘区',	'﻿BeiTangQu',	201,	1,	0,	'',	'﻿B',	0,	3,	0),
(1238,	'锡山区',	'﻿XiShanQu',	201,	1,	0,	'',	'﻿X',	0,	3,	0),
(1239,	'惠山区',	'﻿HuiShanQu',	201,	1,	0,	'',	'﻿H',	0,	3,	0),
(1240,	'滨湖区',	'﻿BinHuQu',	201,	1,	0,	'',	'﻿B',	0,	3,	0),
(1241,	'江阴市',	'﻿JiangYinShi',	201,	1,	0,	'',	'﻿J',	0,	3,	0),
(1242,	'宜兴市',	'﻿YiXingShi',	201,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1243,	'鼓楼区',	'﻿GuLouQu',	202,	1,	0,	'',	'﻿G',	0,	3,	0),
(1244,	'云龙区',	'﻿YunLongQu',	202,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1245,	'九里区',	'﻿JiuLiQu',	202,	1,	0,	'',	'﻿J',	0,	3,	0),
(1246,	'贾汪区',	'﻿JiaWangQu',	202,	1,	0,	'',	'﻿J',	0,	3,	0),
(1247,	'泉山区',	'﻿QuanShanQu',	202,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1248,	'丰县',	'﻿FengXian',	202,	1,	0,	'',	'﻿F',	0,	3,	0),
(1249,	'沛县',	'﻿PeiXian',	202,	1,	0,	'',	'﻿P',	0,	3,	0),
(1250,	'铜山县',	'﻿TongShanXian',	202,	1,	0,	'',	'﻿T',	0,	3,	0),
(1251,	'睢宁县',	'﻿SuiNingXian',	202,	1,	0,	'',	'﻿S',	0,	3,	0),
(1252,	'新沂市',	'﻿XinYiShi',	202,	1,	0,	'',	'﻿X',	0,	3,	0),
(1253,	'邳州市',	'﻿PiZhouShi',	202,	1,	0,	'',	'﻿P',	0,	3,	0),
(1254,	'天宁区',	'﻿TianNingQu',	203,	1,	0,	'',	'﻿T',	0,	3,	0),
(1255,	'钟楼区',	'﻿ZhongLouQu',	203,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1256,	'戚墅堰区',	'﻿QiShuYanQu',	203,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1257,	'新北区',	'﻿XinBeiQu',	203,	1,	0,	'',	'﻿X',	0,	3,	0),
(1258,	'武进区',	'﻿WuJinQu',	203,	1,	0,	'',	'﻿W',	0,	3,	0),
(1259,	'溧阳市',	'﻿LiYangShi',	203,	1,	0,	'',	'﻿L',	0,	3,	0),
(1260,	'金坛市',	'﻿JinTanShi',	203,	1,	0,	'',	'﻿J',	0,	3,	0),
(1261,	'沧浪区',	'﻿CangLangQu',	204,	1,	0,	'',	'﻿C',	0,	3,	0),
(1262,	'平江区',	'﻿PingJiangQu',	204,	1,	0,	'',	'﻿P',	0,	3,	0),
(1263,	'金阊区',	'﻿JinChangQu',	204,	1,	0,	'',	'﻿J',	0,	3,	0),
(1264,	'虎丘区',	'﻿HuQiuQu',	204,	1,	0,	'',	'﻿H',	0,	3,	0),
(1265,	'吴中区',	'﻿WuZhongQu',	204,	1,	0,	'',	'﻿W',	0,	3,	0),
(1266,	'相城区',	'﻿XiangChengQu',	204,	1,	0,	'',	'﻿X',	0,	3,	0),
(1267,	'常熟市',	'﻿ChangShuShi',	204,	1,	0,	'',	'﻿C',	0,	3,	0),
(1268,	'张家港市',	'﻿ZhangJiaGangShi',	204,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1269,	'昆山市',	'﻿KunShanShi',	204,	1,	0,	'',	'﻿K',	0,	3,	0),
(1270,	'吴江市',	'﻿WuJiangShi',	204,	1,	0,	'',	'﻿W',	0,	3,	0),
(1271,	'太仓市',	'﻿TaiCangShi',	204,	1,	0,	'',	'﻿T',	0,	3,	0),
(1272,	'崇川区',	'﻿ChongChuanQu',	205,	1,	0,	'',	'﻿C',	0,	3,	0),
(1273,	'港闸区',	'﻿GangZhaQu',	205,	1,	0,	'',	'﻿G',	0,	3,	0),
(1274,	'海安县',	'﻿HaiAnXian',	205,	1,	0,	'',	'﻿H',	0,	3,	0),
(1275,	'如东县',	'﻿RuDongXian',	205,	1,	0,	'',	'﻿R',	0,	3,	0),
(1276,	'启东市',	'﻿QiDongShi',	205,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1277,	'如皋市',	'﻿RuGaoShi',	205,	1,	0,	'',	'﻿R',	0,	3,	0),
(1278,	'通州市',	'﻿TongZhouShi',	205,	1,	0,	'',	'﻿T',	0,	3,	0),
(1279,	'海门市',	'﻿HaiMenShi',	205,	1,	0,	'',	'﻿H',	0,	3,	0),
(1280,	'连云区',	'﻿LianYunQu',	206,	1,	0,	'',	'﻿L',	0,	3,	0),
(1281,	'新浦区',	'﻿XinPuQu',	206,	1,	0,	'',	'﻿X',	0,	3,	0),
(1282,	'海州区',	'﻿HaiZhouQu',	206,	1,	0,	'',	'﻿H',	0,	3,	0),
(1283,	'赣榆县',	'﻿GanYuXian',	206,	1,	0,	'',	'﻿G',	0,	3,	0),
(1284,	'东海县',	'﻿DongHaiXian',	206,	1,	0,	'',	'﻿D',	0,	3,	0),
(1285,	'灌云县',	'﻿GuanYunXian',	206,	1,	0,	'',	'﻿G',	0,	3,	0),
(1286,	'灌南县',	'﻿GuanNanXian',	206,	1,	0,	'',	'﻿G',	0,	3,	0),
(1287,	'清河区',	'﻿QingHeQu',	207,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1288,	'楚州区',	'﻿ChuZhouQu',	207,	1,	0,	'',	'﻿C',	0,	3,	0),
(1289,	'淮阴区',	'﻿HuaiYinQu',	207,	1,	0,	'',	'﻿H',	0,	3,	0),
(1290,	'清浦区',	'﻿QingPuQu',	207,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1291,	'涟水县',	'﻿LianShuiXian',	207,	1,	0,	'',	'﻿L',	0,	3,	0),
(1292,	'洪泽县',	'﻿HongZeXian',	207,	1,	0,	'',	'﻿H',	0,	3,	0),
(1293,	'盱眙县',	'﻿XuYiXian',	207,	1,	0,	'',	'﻿X',	0,	3,	0),
(1294,	'金湖县',	'﻿JinHuXian',	207,	1,	0,	'',	'﻿J',	0,	3,	0),
(1295,	'亭湖区',	'﻿TingHuQu',	208,	1,	0,	'',	'﻿T',	0,	3,	0),
(1296,	'盐都区',	'﻿YanDuQu',	208,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1297,	'响水县',	'﻿XiangShuiXian',	208,	1,	0,	'',	'﻿X',	0,	3,	0),
(1298,	'滨海县',	'﻿BinHaiXian',	208,	1,	0,	'',	'﻿B',	0,	3,	0),
(1299,	'阜宁县',	'﻿FuNingXian',	208,	1,	0,	'',	'﻿F',	0,	3,	0),
(1300,	'射阳县',	'﻿SheYangXian',	208,	1,	0,	'',	'﻿S',	0,	3,	0),
(1301,	'建湖县',	'﻿JianHuXian',	208,	1,	0,	'',	'﻿J',	0,	3,	0),
(1302,	'东台市',	'﻿DongTaiShi',	208,	1,	0,	'',	'﻿D',	0,	3,	0),
(1303,	'大丰市',	'﻿DaFengShi',	208,	1,	0,	'',	'﻿D',	0,	3,	0),
(1304,	'广陵区',	'﻿GuangLingQu',	209,	1,	0,	'',	'﻿G',	0,	3,	0),
(1305,	'邗江区',	'﻿HanJiangQu',	209,	1,	0,	'',	'﻿H',	0,	3,	0),
(1306,	'维扬区',	'﻿WeiYangQu',	209,	1,	0,	'',	'﻿W',	0,	3,	0),
(1307,	'宝应县',	'﻿BaoYingXian',	209,	1,	0,	'',	'﻿B',	0,	3,	0),
(1308,	'仪征市',	'﻿YiZhengShi',	209,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1309,	'高邮市',	'﻿GaoYouShi',	209,	1,	0,	'',	'﻿G',	0,	3,	0),
(1310,	'江都市',	'﻿JiangDuShi',	209,	1,	0,	'',	'﻿J',	0,	3,	0),
(1311,	'京口区',	'﻿JingKouQu',	210,	1,	0,	'',	'﻿J',	0,	3,	0),
(1312,	'润州区',	'﻿RunZhouQu',	210,	1,	0,	'',	'﻿R',	0,	3,	0),
(1313,	'丹徒区',	'﻿DanTuQu',	210,	1,	0,	'',	'﻿D',	0,	3,	0),
(1314,	'丹阳市',	'﻿DanYangShi',	210,	1,	0,	'',	'﻿D',	0,	3,	0),
(1315,	'扬中市',	'﻿YangZhongShi',	210,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1316,	'句容市',	'﻿JuRongShi',	210,	1,	0,	'',	'﻿J',	0,	3,	0),
(1317,	'海陵区',	'﻿HaiLingQu',	211,	1,	0,	'',	'﻿H',	0,	3,	0),
(1318,	'高港区',	'﻿GaoGangQu',	211,	1,	0,	'',	'﻿G',	0,	3,	0),
(1319,	'兴化市',	'﻿XingHuaShi',	211,	1,	0,	'',	'﻿X',	0,	3,	0),
(1320,	'靖江市',	'﻿JingJiangShi',	211,	1,	0,	'',	'﻿J',	0,	3,	0),
(1321,	'泰兴市',	'﻿TaiXingShi',	211,	1,	0,	'',	'﻿T',	0,	3,	0),
(1322,	'姜堰市',	'﻿JiangYanShi',	211,	1,	0,	'',	'﻿J',	0,	3,	0),
(1323,	'宿城区',	'﻿SuChengQu',	212,	1,	0,	'',	'﻿S',	0,	3,	0),
(1324,	'宿豫区',	'﻿SuYuQu',	212,	1,	0,	'',	'﻿S',	0,	3,	0),
(1325,	'沭阳县',	'﻿ShuYangXian',	212,	1,	0,	'',	'﻿S',	0,	3,	0),
(1326,	'泗阳县',	'﻿SiYangXian',	212,	1,	0,	'',	'﻿S',	0,	3,	0),
(1327,	'泗洪县',	'﻿SiHongXian',	212,	1,	0,	'',	'﻿S',	0,	3,	0),
(1328,	'上城区',	'﻿ShangChengQu',	213,	1,	0,	'',	'﻿S',	0,	3,	0),
(1329,	'下城区',	'﻿XiaChengQu',	213,	1,	0,	'',	'﻿X',	0,	3,	0),
(1330,	'江干区',	'﻿JiangGanQu',	213,	1,	0,	'',	'﻿J',	0,	3,	0),
(1331,	'拱墅区',	'﻿GongShuQu',	213,	1,	0,	'',	'﻿G',	0,	3,	0),
(1332,	'西湖区',	'﻿XiHuQu',	213,	1,	0,	'',	'﻿X',	0,	3,	0),
(1333,	'滨江区',	'﻿BinJiangQu',	213,	1,	0,	'',	'﻿B',	0,	3,	0),
(1334,	'萧山区',	'﻿XiaoShanQu',	213,	1,	0,	'',	'﻿X',	0,	3,	0),
(1335,	'余杭区',	'﻿YuHangQu',	213,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1336,	'桐庐县',	'﻿TongLuXian',	213,	1,	0,	'',	'﻿T',	0,	3,	0),
(1337,	'淳安县',	'',	213,	1,	0,	'',	'0',	0,	3,	0),
(1338,	'建德市',	'﻿JianDeShi',	213,	1,	0,	'',	'﻿J',	0,	3,	0),
(1339,	'富阳市',	'﻿FuYangShi',	213,	1,	0,	'',	'﻿F',	0,	3,	0),
(1340,	'临安市',	'﻿LinAnShi',	213,	1,	0,	'',	'﻿L',	0,	3,	0),
(1341,	'海曙区',	'﻿HaiShuQu',	214,	1,	0,	'',	'﻿H',	0,	3,	0),
(1342,	'江东区',	'﻿JiangDongQu',	214,	1,	0,	'',	'﻿J',	0,	3,	0),
(1343,	'江北区',	'﻿JiangBeiQu',	214,	1,	0,	'',	'﻿J',	0,	3,	0),
(1344,	'北仑区',	'﻿BeiLunQu',	214,	1,	0,	'',	'﻿B',	0,	3,	0),
(1345,	'镇海区',	'﻿ZhenHaiQu',	214,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1346,	'鄞州区',	'﻿YinZhouQu',	214,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1347,	'象山县',	'﻿XiangShanXian',	214,	1,	0,	'',	'﻿X',	0,	3,	0),
(1348,	'宁海县',	'﻿NingHaiXian',	214,	1,	0,	'',	'﻿N',	0,	3,	0),
(1349,	'余姚市',	'﻿YuYaoShi',	214,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1350,	'慈溪市',	'﻿CiXiShi',	214,	1,	0,	'',	'﻿C',	0,	3,	0),
(1351,	'奉化市',	'﻿FengHuaShi',	214,	1,	0,	'',	'﻿F',	0,	3,	0),
(1352,	'鹿城区',	'﻿LuChengQu',	215,	1,	0,	'',	'﻿L',	0,	3,	0),
(1353,	'龙湾区',	'﻿LongWanQu',	215,	1,	0,	'',	'﻿L',	0,	3,	0),
(1354,	'瓯海区',	'﻿OuHaiQu',	215,	1,	0,	'',	'﻿O',	0,	3,	0),
(1355,	'洞头县',	'﻿DongTouXian',	215,	1,	0,	'',	'﻿D',	0,	3,	0),
(1356,	'永嘉县',	'﻿YongJiaXian',	215,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1357,	'平阳县',	'﻿PingYangXian',	215,	1,	0,	'',	'﻿P',	0,	3,	0),
(1358,	'苍南县',	'﻿CangNanXian',	215,	1,	0,	'',	'﻿C',	0,	3,	0),
(1359,	'文成县',	'﻿WenChengXian',	215,	1,	0,	'',	'﻿W',	0,	3,	0),
(1360,	'泰顺县',	'﻿TaiShunXian',	215,	1,	0,	'',	'﻿T',	0,	3,	0),
(1361,	'瑞安市',	'﻿RuiAnShi',	215,	1,	0,	'',	'﻿R',	0,	3,	0),
(1362,	'乐清市',	'﻿LeQingShi',	215,	1,	0,	'',	'﻿L',	0,	3,	0),
(1363,	'秀城区',	'﻿XiuChengQu',	216,	1,	0,	'',	'﻿X',	0,	3,	0),
(1364,	'秀洲区',	'﻿XiuZhouQu',	216,	1,	0,	'',	'﻿X',	0,	3,	0),
(1365,	'嘉善县',	'﻿JiaShanXian',	216,	1,	0,	'',	'﻿J',	0,	3,	0),
(1366,	'海盐县',	'﻿HaiYanXian',	216,	1,	0,	'',	'﻿H',	0,	3,	0),
(1367,	'海宁市',	'﻿HaiNingShi',	216,	1,	0,	'',	'﻿H',	0,	3,	0),
(1368,	'平湖市',	'﻿PingHuShi',	216,	1,	0,	'',	'﻿P',	0,	3,	0),
(1369,	'桐乡市',	'﻿TongXiangShi',	216,	1,	0,	'',	'﻿T',	0,	3,	0),
(1370,	'吴兴区',	'﻿WuXingQu',	217,	1,	0,	'',	'﻿W',	0,	3,	0),
(1371,	'南浔区',	'﻿NanXunQu',	217,	1,	0,	'',	'﻿N',	0,	3,	0),
(1372,	'德清县',	'﻿DeQingXian',	217,	1,	0,	'',	'﻿D',	0,	3,	0),
(1373,	'长兴县',	'﻿ChangXingXian',	217,	1,	0,	'',	'﻿C',	0,	3,	0),
(1374,	'安吉县',	'﻿AnJiXian',	217,	1,	0,	'',	'﻿A',	0,	3,	0),
(1375,	'越城区',	'﻿YueChengQu',	218,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1376,	'绍兴县',	'﻿ShaoXingXian',	218,	1,	0,	'',	'﻿S',	0,	3,	0),
(1377,	'新昌县',	'﻿XinChangXian',	218,	1,	0,	'',	'﻿X',	0,	3,	0),
(1378,	'诸暨市',	'﻿ZhuJiShi',	218,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1379,	'上虞市',	'﻿ShangYuShi',	218,	1,	0,	'',	'﻿S',	0,	3,	0),
(1380,	'嵊州市',	'﻿ShengZhouShi',	218,	1,	0,	'',	'﻿S',	0,	3,	0),
(1381,	'婺城区',	'﻿WuChengQu',	219,	1,	0,	'',	'﻿W',	0,	3,	0),
(1382,	'金东区',	'﻿JinDongQu',	219,	1,	0,	'',	'﻿J',	0,	3,	0),
(1383,	'武义县',	'﻿WuYiXian',	219,	1,	0,	'',	'﻿W',	0,	3,	0),
(1384,	'浦江县',	'﻿PuJiangXian',	219,	1,	0,	'',	'﻿P',	0,	3,	0),
(1385,	'磐安县',	'﻿PanAnXian',	219,	1,	0,	'',	'﻿P',	0,	3,	0),
(1386,	'兰溪市',	'﻿LanXiShi',	219,	1,	0,	'',	'﻿L',	0,	3,	0),
(1387,	'义乌市',	'﻿YiWuShi',	219,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1388,	'东阳市',	'﻿DongYangShi',	219,	1,	0,	'',	'﻿D',	0,	3,	0),
(1389,	'永康市',	'﻿YongKangShi',	219,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1390,	'柯城区',	'﻿KeChengQu',	220,	1,	0,	'',	'﻿K',	0,	3,	0),
(1391,	'衢江区',	'﻿QuJiangQu',	220,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1392,	'常山县',	'﻿ChangShanXian',	220,	1,	0,	'',	'﻿C',	0,	3,	0),
(1393,	'开化县',	'﻿KaiHuaXian',	220,	1,	0,	'',	'﻿K',	0,	3,	0),
(1394,	'龙游县',	'﻿LongYouXian',	220,	1,	0,	'',	'﻿L',	0,	3,	0),
(1395,	'江山市',	'﻿JiangShanShi',	220,	1,	0,	'',	'﻿J',	0,	3,	0),
(1396,	'定海区',	'﻿DingHaiQu',	221,	1,	0,	'',	'﻿D',	0,	3,	0),
(1397,	'普陀区',	'﻿PuTuoQu',	221,	1,	0,	'',	'﻿P',	0,	3,	0),
(1398,	'岱山县',	'﻿DaiShanXian',	221,	1,	0,	'',	'﻿D',	0,	3,	0),
(1399,	'嵊泗县',	'﻿ShengSiXian',	221,	1,	0,	'',	'﻿S',	0,	3,	0),
(1400,	'椒江区',	'﻿JiaoJiangQu',	222,	1,	0,	'',	'﻿J',	0,	3,	0),
(1401,	'黄岩区',	'﻿HuangYanQu',	222,	1,	0,	'',	'﻿H',	0,	3,	0),
(1402,	'路桥区',	'﻿LuQiaoQu',	222,	1,	0,	'',	'﻿L',	0,	3,	0),
(1403,	'玉环县',	'﻿YuHuanXian',	222,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1404,	'三门县',	'﻿SanMenXian',	222,	1,	0,	'',	'﻿S',	0,	3,	0),
(1405,	'天台县',	'﻿TianTaiXian',	222,	1,	0,	'',	'﻿T',	0,	3,	0),
(1406,	'仙居县',	'﻿XianJuXian',	222,	1,	0,	'',	'﻿X',	0,	3,	0),
(1407,	'温岭市',	'﻿WenLingShi',	222,	1,	0,	'',	'﻿W',	0,	3,	0),
(1408,	'临海市',	'﻿LinHaiShi',	222,	1,	0,	'',	'﻿L',	0,	3,	0),
(1409,	'莲都区',	'﻿LianDuQu',	223,	1,	0,	'',	'﻿L',	0,	3,	0),
(1410,	'青田县',	'﻿QingTianXian',	223,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1411,	'缙云县',	'﻿JinYunXian',	223,	1,	0,	'',	'﻿J',	0,	3,	0),
(1412,	'遂昌县',	'﻿SuiChangXian',	223,	1,	0,	'',	'﻿S',	0,	3,	0),
(1413,	'松阳县',	'﻿SongYangXian',	223,	1,	0,	'',	'﻿S',	0,	3,	0),
(1414,	'云和县',	'﻿YunHeXian',	223,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1415,	'庆元县',	'﻿QingYuanXian',	223,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1416,	'景宁畲族自治县',	'﻿JingNingSheZuZiZhiXian',	223,	1,	0,	'',	'﻿J',	0,	3,	0),
(1417,	'龙泉市',	'﻿LongQuanShi',	223,	1,	0,	'',	'﻿L',	0,	3,	0),
(1418,	'瑶海区',	'﻿YaoHaiQu',	224,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1419,	'庐阳区',	'﻿LuYangQu',	224,	1,	0,	'',	'﻿L',	0,	3,	0),
(1420,	'蜀山区',	'﻿ShuShanQu',	224,	1,	0,	'',	'﻿S',	0,	3,	0),
(1421,	'包河区',	'﻿BaoHeQu',	224,	1,	0,	'',	'﻿B',	0,	3,	0),
(1422,	'长丰县',	'﻿ChangFengXian',	224,	1,	0,	'',	'﻿C',	0,	3,	0),
(1423,	'肥东县',	'﻿FeiDongXian',	224,	1,	0,	'',	'﻿F',	0,	3,	0),
(1424,	'肥西县',	'﻿FeiXiXian',	224,	1,	0,	'',	'﻿F',	0,	3,	0),
(1425,	'镜湖区',	'﻿JingHuQu',	225,	1,	0,	'',	'﻿J',	0,	3,	0),
(1426,	'弋江区',	'﻿YiJiangQu',	225,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1427,	'鸠江区',	'﻿JiuJiangQu',	225,	1,	0,	'',	'﻿J',	0,	3,	0),
(1428,	'三山区',	'﻿SanShanQu',	225,	1,	0,	'',	'﻿S',	0,	3,	0),
(1429,	'芜湖县',	'﻿WuHuXian',	225,	1,	0,	'',	'﻿W',	0,	3,	0),
(1430,	'繁昌县',	'﻿FanChangXian',	225,	1,	0,	'',	'﻿F',	0,	3,	0),
(1431,	'南陵县',	'﻿NanLingXian',	225,	1,	0,	'',	'﻿N',	0,	3,	0),
(1432,	'龙子湖区',	'﻿LongZiHuQu',	226,	1,	0,	'',	'﻿L',	0,	3,	0),
(1433,	'蚌山区',	'﻿BangShanQu',	226,	1,	0,	'',	'﻿B',	0,	3,	0),
(1434,	'禹会区',	'﻿YuHuiQu',	226,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1435,	'淮上区',	'﻿HuaiShangQu',	226,	1,	0,	'',	'﻿H',	0,	3,	0),
(1436,	'怀远县',	'﻿HuaiYuanXian',	226,	1,	0,	'',	'﻿H',	0,	3,	0),
(1437,	'五河县',	'﻿WuHeXian',	226,	1,	0,	'',	'﻿W',	0,	3,	0),
(1438,	'固镇县',	'﻿GuZhenXian',	226,	1,	0,	'',	'﻿G',	0,	3,	0),
(1439,	'大通区',	'﻿DaTongQu',	227,	1,	0,	'',	'﻿D',	0,	3,	0),
(1440,	'田家庵区',	'﻿TianJiaAnQu',	227,	1,	0,	'',	'﻿T',	0,	3,	0),
(1441,	'谢家集区',	'﻿XieJiaJiQu',	227,	1,	0,	'',	'﻿X',	0,	3,	0),
(1442,	'八公山区',	'﻿BaGongShanQu',	227,	1,	0,	'',	'﻿B',	0,	3,	0),
(1443,	'潘集区',	'﻿PanJiQu',	227,	1,	0,	'',	'﻿P',	0,	3,	0),
(1444,	'凤台县',	'﻿FengTaiXian',	227,	1,	0,	'',	'﻿F',	0,	3,	0),
(1445,	'金家庄区',	'﻿JinJiaZhuangQu',	228,	1,	0,	'',	'﻿J',	0,	3,	0),
(1446,	'花山区',	'﻿HuaShanQu',	228,	1,	0,	'',	'﻿H',	0,	3,	0),
(1447,	'雨山区',	'﻿YuShanQu',	228,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1448,	'当涂县',	'﻿DangTuXian',	228,	1,	0,	'',	'﻿D',	0,	3,	0),
(1449,	'杜集区',	'﻿DuJiQu',	229,	1,	0,	'',	'﻿D',	0,	3,	0),
(1450,	'相山区',	'﻿XiangShanQu',	229,	1,	0,	'',	'﻿X',	0,	3,	0),
(1451,	'烈山区',	'﻿LieShanQu',	229,	1,	0,	'',	'﻿L',	0,	3,	0),
(1452,	'濉溪县',	'﻿SuiXiXian',	229,	1,	0,	'',	'﻿S',	0,	3,	0),
(1453,	'铜官山区',	'﻿TongGuanShanQu',	230,	1,	0,	'',	'﻿T',	0,	3,	0),
(1454,	'狮子山区',	'﻿ShiZiShanQu',	230,	1,	0,	'',	'﻿S',	0,	3,	0),
(1455,	'郊区',	'﻿JiaoQu',	230,	1,	0,	'',	'﻿J',	0,	3,	0),
(1456,	'铜陵县',	'﻿TongLingXian',	230,	1,	0,	'',	'﻿T',	0,	3,	0),
(1457,	'迎江区',	'﻿YingJiangQu',	231,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1458,	'大观区',	'﻿DaGuanQu',	231,	1,	0,	'',	'﻿D',	0,	3,	0),
(1459,	'宜秀区',	'﻿YiXiuQu',	231,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1460,	'怀宁县',	'﻿HuaiNingXian',	231,	1,	0,	'',	'﻿H',	0,	3,	0),
(1461,	'枞阳县',	'﻿CongYangXian',	231,	1,	0,	'',	'﻿C',	0,	3,	0),
(1462,	'潜山县',	'﻿QianShanXian',	231,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1463,	'太湖县',	'﻿TaiHuXian',	231,	1,	0,	'',	'﻿T',	0,	3,	0),
(1464,	'宿松县',	'﻿SuSongXian',	231,	1,	0,	'',	'﻿S',	0,	3,	0),
(1465,	'望江县',	'﻿WangJiangXian',	231,	1,	0,	'',	'﻿W',	0,	3,	0),
(1466,	'岳西县',	'﻿YueXiXian',	231,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1467,	'桐城市',	'﻿TongChengShi',	231,	1,	0,	'',	'﻿T',	0,	3,	0),
(1468,	'屯溪区',	'﻿TunXiQu',	232,	1,	0,	'',	'﻿T',	0,	3,	0),
(1469,	'黄山区',	'﻿HuangShanQu',	232,	1,	0,	'',	'﻿H',	0,	3,	0),
(1470,	'徽州区',	'﻿HuiZhouQu',	232,	1,	0,	'',	'﻿H',	0,	3,	0),
(1471,	'歙县',	'﻿XiXian',	232,	1,	0,	'',	'﻿X',	0,	3,	0),
(1472,	'休宁县',	'﻿XiuNingXian',	232,	1,	0,	'',	'﻿X',	0,	3,	0),
(1473,	'黟县',	'﻿YiXian',	232,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1474,	'祁门县',	'﻿QiMenXian',	232,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1475,	'琅琊区',	'﻿LangYaQu',	233,	1,	0,	'',	'﻿L',	0,	3,	0),
(1476,	'南谯区',	'﻿NanQiaoQu',	233,	1,	0,	'',	'﻿N',	0,	3,	0),
(1477,	'来安县',	'﻿LaiAnXian',	233,	1,	0,	'',	'﻿L',	0,	3,	0),
(1478,	'全椒县',	'﻿QuanJiaoXian',	233,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1479,	'定远县',	'﻿DingYuanXian',	233,	1,	0,	'',	'﻿D',	0,	3,	0),
(1480,	'凤阳县',	'﻿FengYangXian',	233,	1,	0,	'',	'﻿F',	0,	3,	0),
(1481,	'天长市',	'﻿TianChangShi',	233,	1,	0,	'',	'﻿T',	0,	3,	0),
(1482,	'明光市',	'﻿MingGuangShi',	233,	1,	0,	'',	'﻿M',	0,	3,	0),
(1483,	'颍州区',	'﻿YingZhouQu',	234,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1484,	'颍东区',	'﻿YingDongQu',	234,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1485,	'颍泉区',	'﻿YingQuanQu',	234,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1486,	'临泉县',	'﻿LinQuanXian',	234,	1,	0,	'',	'﻿L',	0,	3,	0),
(1487,	'太和县',	'﻿TaiHeXian',	234,	1,	0,	'',	'﻿T',	0,	3,	0),
(1488,	'阜南县',	'﻿FuNanXian',	234,	1,	0,	'',	'﻿F',	0,	3,	0),
(1489,	'颍上县',	'﻿YingShangXian',	234,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1490,	'界首市',	'﻿JieShouShi',	234,	1,	0,	'',	'﻿J',	0,	3,	0),
(1491,	'埇桥区',	'﻿',	235,	1,	0,	'',	'﻿',	0,	3,	0),
(1492,	'砀山县',	'﻿DangShanXian',	235,	1,	0,	'',	'﻿D',	0,	3,	0),
(1493,	'萧县',	'﻿XiaoXian',	235,	1,	0,	'',	'﻿X',	0,	3,	0),
(1494,	'灵璧县',	'﻿LingBiXian',	235,	1,	0,	'',	'﻿L',	0,	3,	0),
(1495,	'泗县',	'﻿SiXian',	235,	1,	0,	'',	'﻿S',	0,	3,	0),
(1496,	'居巢区',	'﻿JuChaoQu',	236,	1,	0,	'',	'﻿J',	0,	3,	0),
(1497,	'庐江县',	'﻿LuJiangXian',	236,	1,	0,	'',	'﻿L',	0,	3,	0),
(1498,	'无为县',	'﻿WuWeiXian',	236,	1,	0,	'',	'﻿W',	0,	3,	0),
(1499,	'含山县',	'﻿HanShanXian',	236,	1,	0,	'',	'﻿H',	0,	3,	0),
(1500,	'和县',	'﻿HeXian',	236,	1,	0,	'',	'﻿H',	0,	3,	0),
(1501,	'金安区',	'﻿JinAnQu',	237,	1,	0,	'',	'﻿J',	0,	3,	0),
(1502,	'裕安区',	'﻿YuAnQu',	237,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1503,	'寿县',	'﻿ShouXian',	237,	1,	0,	'',	'﻿S',	0,	3,	0),
(1504,	'霍邱县',	'﻿HuoQiuXian',	237,	1,	0,	'',	'﻿H',	0,	3,	0),
(1505,	'舒城县',	'﻿ShuChengXian',	237,	1,	0,	'',	'﻿S',	0,	3,	0),
(1506,	'金寨县',	'﻿JinZhaiXian',	237,	1,	0,	'',	'﻿J',	0,	3,	0),
(1507,	'霍山县',	'﻿HuoShanXian',	237,	1,	0,	'',	'﻿H',	0,	3,	0),
(1508,	'谯城区',	'﻿QiaoChengQu',	238,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1509,	'涡阳县',	'﻿WoYangXian',	238,	1,	0,	'',	'﻿W',	0,	3,	0),
(1510,	'蒙城县',	'﻿MengChengXian',	238,	1,	0,	'',	'﻿M',	0,	3,	0),
(1511,	'利辛县',	'﻿LiXinXian',	238,	1,	0,	'',	'﻿L',	0,	3,	0),
(1512,	'贵池区',	'﻿GuiChiQu',	239,	1,	0,	'',	'﻿G',	0,	3,	0),
(1513,	'东至县',	'﻿DongZhiXian',	239,	1,	0,	'',	'﻿D',	0,	3,	0),
(1514,	'石台县',	'﻿ShiTaiXian',	239,	1,	0,	'',	'﻿S',	0,	3,	0),
(1515,	'青阳县',	'﻿QingYangXian',	239,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1516,	'宣州区',	'﻿XuanZhouQu',	240,	1,	0,	'',	'﻿X',	0,	3,	0),
(1517,	'郎溪县',	'﻿LangXiXian',	240,	1,	0,	'',	'﻿L',	0,	3,	0),
(1518,	'广德县',	'﻿GuangDeXian',	240,	1,	0,	'',	'﻿G',	0,	3,	0),
(1519,	'泾县',	'﻿JingXian',	240,	1,	0,	'',	'﻿J',	0,	3,	0),
(1520,	'绩溪县',	'﻿JiXiXian',	240,	1,	0,	'',	'﻿J',	0,	3,	0),
(1521,	'旌德县',	'﻿JingDeXian',	240,	1,	0,	'',	'﻿J',	0,	3,	0),
(1522,	'宁国市',	'﻿NingGuoShi',	240,	1,	0,	'',	'﻿N',	0,	3,	0),
(1523,	'鼓楼区',	'﻿GuLouQu',	241,	1,	0,	'',	'﻿G',	0,	3,	0),
(1524,	'台江区',	'﻿TaiJiangQu',	241,	1,	0,	'',	'﻿T',	0,	3,	0),
(1525,	'仓山区',	'﻿CangShanQu',	241,	1,	0,	'',	'﻿C',	0,	3,	0),
(1526,	'马尾区',	'﻿MaWeiQu',	241,	1,	0,	'',	'﻿M',	0,	3,	0),
(1527,	'晋安区',	'﻿JinAnQu',	241,	1,	0,	'',	'﻿J',	0,	3,	0),
(1528,	'闽侯县',	'﻿MinHouXian',	241,	1,	0,	'',	'﻿M',	0,	3,	0),
(1529,	'连江县',	'﻿LianJiangXian',	241,	1,	0,	'',	'﻿L',	0,	3,	0),
(1530,	'罗源县',	'﻿LuoYuanXian',	241,	1,	0,	'',	'﻿L',	0,	3,	0),
(1531,	'闽清县',	'﻿MinQingXian',	241,	1,	0,	'',	'﻿M',	0,	3,	0),
(1532,	'永泰县',	'﻿YongTaiXian',	241,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1533,	'平潭县',	'﻿PingTanXian',	241,	1,	0,	'',	'﻿P',	0,	3,	0),
(1534,	'福清市',	'﻿FuQingShi',	241,	1,	0,	'',	'﻿F',	0,	3,	0),
(1535,	'长乐市',	'﻿ChangLeShi',	241,	1,	0,	'',	'﻿C',	0,	3,	0),
(1536,	'思明区',	'﻿SiMingQu',	242,	1,	0,	'',	'﻿S',	0,	3,	0),
(1537,	'海沧区',	'﻿HaiCangQu',	242,	1,	0,	'',	'﻿H',	0,	3,	0),
(1538,	'湖里区',	'﻿HuLiQu',	242,	1,	0,	'',	'﻿H',	0,	3,	0),
(1539,	'集美区',	'﻿JiMeiQu',	242,	1,	0,	'',	'﻿J',	0,	3,	0),
(1540,	'同安区',	'﻿TongAnQu',	242,	1,	0,	'',	'﻿T',	0,	3,	0),
(1541,	'翔安区',	'﻿XiangAnQu',	242,	1,	0,	'',	'﻿X',	0,	3,	0),
(1542,	'城厢区',	'﻿ChengXiangQu',	243,	1,	0,	'',	'﻿C',	0,	3,	0),
(1543,	'涵江区',	'﻿HanJiangQu',	243,	1,	0,	'',	'﻿H',	0,	3,	0),
(1544,	'荔城区',	'﻿LiChengQu',	243,	1,	0,	'',	'﻿L',	0,	3,	0),
(1545,	'秀屿区',	'﻿XiuYuQu',	243,	1,	0,	'',	'﻿X',	0,	3,	0),
(1546,	'仙游县',	'﻿XianYouXian',	243,	1,	0,	'',	'﻿X',	0,	3,	0),
(1547,	'梅列区',	'﻿MeiLieQu',	244,	1,	0,	'',	'﻿M',	0,	3,	0),
(1548,	'三元区',	'﻿SanYuanQu',	244,	1,	0,	'',	'﻿S',	0,	3,	0),
(1549,	'明溪县',	'﻿MingXiXian',	244,	1,	0,	'',	'﻿M',	0,	3,	0),
(1550,	'清流县',	'﻿QingLiuXian',	244,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1551,	'宁化县',	'﻿NingHuaXian',	244,	1,	0,	'',	'﻿N',	0,	3,	0),
(1552,	'大田县',	'﻿DaTianXian',	244,	1,	0,	'',	'﻿D',	0,	3,	0),
(1553,	'尤溪县',	'﻿YouXiXian',	244,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1554,	'沙县',	'﻿ShaXian',	244,	1,	0,	'',	'﻿S',	0,	3,	0),
(1555,	'将乐县',	'﻿JiangLeXian',	244,	1,	0,	'',	'﻿J',	0,	3,	0),
(1556,	'泰宁县',	'﻿TaiNingXian',	244,	1,	0,	'',	'﻿T',	0,	3,	0),
(1557,	'建宁县',	'﻿JianNingXian',	244,	1,	0,	'',	'﻿J',	0,	3,	0),
(1558,	'永安市',	'﻿YongAnShi',	244,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1559,	'鲤城区',	'﻿LiChengQu',	245,	1,	0,	'',	'﻿L',	0,	3,	0),
(1560,	'丰泽区',	'﻿FengZeQu',	245,	1,	0,	'',	'﻿F',	0,	3,	0),
(1561,	'洛江区',	'﻿LuoJiangQu',	245,	1,	0,	'',	'﻿L',	0,	3,	0),
(1562,	'泉港区',	'﻿QuanGangQu',	245,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1563,	'惠安县',	'﻿HuiAnXian',	245,	1,	0,	'',	'﻿H',	0,	3,	0),
(1564,	'安溪县',	'﻿AnXiXian',	245,	1,	0,	'',	'﻿A',	0,	3,	0),
(1565,	'永春县',	'﻿YongChunXian',	245,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1566,	'德化县',	'﻿DeHuaXian',	245,	1,	0,	'',	'﻿D',	0,	3,	0),
(1567,	'金门县',	'﻿JinMenXian',	245,	1,	0,	'',	'﻿J',	0,	3,	0),
(1568,	'石狮市',	'﻿ShiShiShi',	245,	1,	0,	'',	'﻿S',	0,	3,	0),
(1569,	'晋江市',	'﻿JinJiangShi',	245,	1,	0,	'',	'﻿J',	0,	3,	0),
(1570,	'南安市',	'﻿NanAnShi',	245,	1,	0,	'',	'﻿N',	0,	3,	0),
(1571,	'芗城区',	'﻿XiangChengQu',	246,	1,	0,	'',	'﻿X',	0,	3,	0),
(1572,	'龙文区',	'﻿LongWenQu',	246,	1,	0,	'',	'﻿L',	0,	3,	0),
(1573,	'云霄县',	'﻿YunXiaoXian',	246,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1574,	'漳浦县',	'﻿ZhangPuXian',	246,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1575,	'诏安县',	'﻿ZhaoAnXian',	246,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1576,	'长泰县',	'﻿ChangTaiXian',	246,	1,	0,	'',	'﻿C',	0,	3,	0),
(1577,	'东山县',	'﻿DongShanXian',	246,	1,	0,	'',	'﻿D',	0,	3,	0),
(1578,	'南靖县',	'﻿NanJingXian',	246,	1,	0,	'',	'﻿N',	0,	3,	0),
(1579,	'平和县',	'﻿PingHeXian',	246,	1,	0,	'',	'﻿P',	0,	3,	0),
(1580,	'华安县',	'﻿HuaAnXian',	246,	1,	0,	'',	'﻿H',	0,	3,	0),
(1581,	'龙海市',	'﻿LongHaiShi',	246,	1,	0,	'',	'﻿L',	0,	3,	0),
(1582,	'延平区',	'﻿YanPingQu',	247,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1583,	'顺昌县',	'﻿ShunChangXian',	247,	1,	0,	'',	'﻿S',	0,	3,	0),
(1584,	'浦城县',	'﻿PuChengXian',	247,	1,	0,	'',	'﻿P',	0,	3,	0),
(1585,	'光泽县',	'﻿GuangZeXian',	247,	1,	0,	'',	'﻿G',	0,	3,	0),
(1586,	'松溪县',	'﻿SongXiXian',	247,	1,	0,	'',	'﻿S',	0,	3,	0),
(1587,	'政和县',	'﻿ZhengHeXian',	247,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1588,	'邵武市',	'﻿ShaoWuShi',	247,	1,	0,	'',	'﻿S',	0,	3,	0),
(1589,	'武夷山市',	'﻿WuYiShanShi',	247,	1,	0,	'',	'﻿W',	0,	3,	0),
(1590,	'建瓯市',	'﻿JianOuShi',	247,	1,	0,	'',	'﻿J',	0,	3,	0),
(1591,	'建阳市',	'﻿JianYangShi',	247,	1,	0,	'',	'﻿J',	0,	3,	0),
(1592,	'新罗区',	'﻿XinLuoQu',	248,	1,	0,	'',	'﻿X',	0,	3,	0),
(1593,	'长汀县',	'﻿ChangTingXian',	248,	1,	0,	'',	'﻿C',	0,	3,	0),
(1594,	'永定县',	'﻿YongDingXian',	248,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1595,	'上杭县',	'﻿ShangHangXian',	248,	1,	0,	'',	'﻿S',	0,	3,	0),
(1596,	'武平县',	'﻿WuPingXian',	248,	1,	0,	'',	'﻿W',	0,	3,	0),
(1597,	'连城县',	'﻿LianChengXian',	248,	1,	0,	'',	'﻿L',	0,	3,	0),
(1598,	'漳平市',	'﻿ZhangPingShi',	248,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1599,	'蕉城区',	'﻿JiaoChengQu',	249,	1,	0,	'',	'﻿J',	0,	3,	0),
(1600,	'霞浦县',	'﻿XiaPuXian',	249,	1,	0,	'',	'﻿X',	0,	3,	0),
(1601,	'古田县',	'﻿GuTianXian',	249,	1,	0,	'',	'﻿G',	0,	3,	0),
(1602,	'屏南县',	'﻿PingNanXian',	249,	1,	0,	'',	'﻿P',	0,	3,	0),
(1603,	'寿宁县',	'﻿ShouNingXian',	249,	1,	0,	'',	'﻿S',	0,	3,	0),
(1604,	'周宁县',	'﻿ZhouNingXian',	249,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1605,	'柘荣县',	'﻿ZheRongXian',	249,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1606,	'福安市',	'﻿FuAnShi',	249,	1,	0,	'',	'﻿F',	0,	3,	0),
(1607,	'福鼎市',	'﻿FuDingShi',	249,	1,	0,	'',	'﻿F',	0,	3,	0),
(1608,	'东湖区',	'﻿DongHuQu',	250,	1,	0,	'',	'﻿D',	0,	3,	0),
(1609,	'西湖区',	'﻿XiHuQu',	250,	1,	0,	'',	'﻿X',	0,	3,	0),
(1610,	'青云谱区',	'﻿QingYunPuQu',	250,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1611,	'湾里区',	'﻿WanLiQu',	250,	1,	0,	'',	'﻿W',	0,	3,	0),
(1612,	'青山湖区',	'﻿QingShanHuQu',	250,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1613,	'南昌县',	'﻿NanChangXian',	250,	1,	0,	'',	'﻿N',	0,	3,	0),
(1614,	'新建县',	'﻿XinJianXian',	250,	1,	0,	'',	'﻿X',	0,	3,	0),
(1615,	'安义县',	'﻿AnYiXian',	250,	1,	0,	'',	'﻿A',	0,	3,	0),
(1616,	'进贤县',	'﻿JinXianXian',	250,	1,	0,	'',	'﻿J',	0,	3,	0),
(1617,	'昌江区',	'﻿ChangJiangQu',	251,	1,	0,	'',	'﻿C',	0,	3,	0),
(1618,	'珠山区',	'﻿ZhuShanQu',	251,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1619,	'浮梁县',	'﻿FuLiangXian',	251,	1,	0,	'',	'﻿F',	0,	3,	0),
(1620,	'乐平市',	'﻿LePingShi',	251,	1,	0,	'',	'﻿L',	0,	3,	0),
(1621,	'安源区',	'﻿AnYuanQu',	252,	1,	0,	'',	'﻿A',	0,	3,	0),
(1622,	'湘东区',	'﻿XiangDongQu',	252,	1,	0,	'',	'﻿X',	0,	3,	0),
(1623,	'莲花县',	'﻿LianHuaXian',	252,	1,	0,	'',	'﻿L',	0,	3,	0),
(1624,	'上栗县',	'﻿ShangLiXian',	252,	1,	0,	'',	'﻿S',	0,	3,	0),
(1625,	'芦溪县',	'﻿LuXiXian',	252,	1,	0,	'',	'﻿L',	0,	3,	0),
(1626,	'庐山区',	'﻿LuShanQu',	253,	1,	0,	'',	'﻿L',	0,	3,	0),
(1627,	'浔阳区',	'﻿XunYangQu',	253,	1,	0,	'',	'﻿X',	0,	3,	0),
(1628,	'九江县',	'﻿JiuJiangXian',	253,	1,	0,	'',	'﻿J',	0,	3,	0),
(1629,	'武宁县',	'﻿WuNingXian',	253,	1,	0,	'',	'﻿W',	0,	3,	0),
(1630,	'修水县',	'﻿XiuShuiXian',	253,	1,	0,	'',	'﻿X',	0,	3,	0),
(1631,	'永修县',	'﻿YongXiuXian',	253,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1632,	'德安县',	'﻿DeAnXian',	253,	1,	0,	'',	'﻿D',	0,	3,	0),
(1633,	'星子县',	'﻿XingZiXian',	253,	1,	0,	'',	'﻿X',	0,	3,	0),
(1634,	'都昌县',	'﻿DuChangXian',	253,	1,	0,	'',	'﻿D',	0,	3,	0),
(1635,	'湖口县',	'﻿HuKouXian',	253,	1,	0,	'',	'﻿H',	0,	3,	0),
(1636,	'彭泽县',	'﻿PengZeXian',	253,	1,	0,	'',	'﻿P',	0,	3,	0),
(1637,	'瑞昌市',	'﻿RuiChangShi',	253,	1,	0,	'',	'﻿R',	0,	3,	0),
(1638,	'渝水区',	'﻿YuShuiQu',	254,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1639,	'分宜县',	'﻿FenYiXian',	254,	1,	0,	'',	'﻿F',	0,	3,	0),
(1640,	'月湖区',	'﻿YueHuQu',	255,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1641,	'余江县',	'﻿YuJiangXian',	255,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1642,	'贵溪市',	'﻿GuiXiShi',	255,	1,	0,	'',	'﻿G',	0,	3,	0),
(1643,	'章贡区',	'﻿ZhangGongQu',	256,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1644,	'赣县',	'﻿GanXian',	256,	1,	0,	'',	'﻿G',	0,	3,	0),
(1645,	'信丰县',	'﻿XinFengXian',	256,	1,	0,	'',	'﻿X',	0,	3,	0),
(1646,	'大余县',	'﻿DaYuXian',	256,	1,	0,	'',	'﻿D',	0,	3,	0),
(1647,	'上犹县',	'﻿ShangYouXian',	256,	1,	0,	'',	'﻿S',	0,	3,	0),
(1648,	'崇义县',	'﻿ChongYiXian',	256,	1,	0,	'',	'﻿C',	0,	3,	0),
(1649,	'安远县',	'﻿AnYuanXian',	256,	1,	0,	'',	'﻿A',	0,	3,	0),
(1650,	'龙南县',	'﻿LongNanXian',	256,	1,	0,	'',	'﻿L',	0,	3,	0),
(1651,	'定南县',	'﻿DingNanXian',	256,	1,	0,	'',	'﻿D',	0,	3,	0),
(1652,	'全南县',	'﻿QuanNanXian',	256,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1653,	'宁都县',	'﻿NingDuXian',	256,	1,	0,	'',	'﻿N',	0,	3,	0),
(1654,	'于都县',	'﻿YuDuXian',	256,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1655,	'兴国县',	'﻿XingGuoXian',	256,	1,	0,	'',	'﻿X',	0,	3,	0),
(1656,	'会昌县',	'﻿HuiChangXian',	256,	1,	0,	'',	'﻿H',	0,	3,	0),
(1657,	'寻乌县',	'﻿XunWuXian',	256,	1,	0,	'',	'﻿X',	0,	3,	0),
(1658,	'石城县',	'﻿ShiChengXian',	256,	1,	0,	'',	'﻿S',	0,	3,	0),
(1659,	'瑞金市',	'﻿RuiJinShi',	256,	1,	0,	'',	'﻿R',	0,	3,	0),
(1660,	'南康市',	'﻿NanKangShi',	256,	1,	0,	'',	'﻿N',	0,	3,	0),
(1661,	'吉州区',	'﻿JiZhouQu',	257,	1,	0,	'',	'﻿J',	0,	3,	0),
(1662,	'青原区',	'﻿QingYuanQu',	257,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1663,	'吉安县',	'﻿JiAnXian',	257,	1,	0,	'',	'﻿J',	0,	3,	0),
(1664,	'吉水县',	'﻿JiShuiXian',	257,	1,	0,	'',	'﻿J',	0,	3,	0),
(1665,	'峡江县',	'﻿XiaJiangXian',	257,	1,	0,	'',	'﻿X',	0,	3,	0),
(1666,	'新干县',	'﻿XinGanXian',	257,	1,	0,	'',	'﻿X',	0,	3,	0),
(1667,	'永丰县',	'﻿YongFengXian',	257,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1668,	'泰和县',	'﻿TaiHeXian',	257,	1,	0,	'',	'﻿T',	0,	3,	0),
(1669,	'遂川县',	'﻿SuiChuanXian',	257,	1,	0,	'',	'﻿S',	0,	3,	0),
(1670,	'万安县',	'﻿WanAnXian',	257,	1,	0,	'',	'﻿W',	0,	3,	0),
(1671,	'安福县',	'﻿AnFuXian',	257,	1,	0,	'',	'﻿A',	0,	3,	0),
(1672,	'永新县',	'﻿YongXinXian',	257,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1673,	'井冈山市',	'﻿JingGangShanShi',	257,	1,	0,	'',	'﻿J',	0,	3,	0),
(1674,	'袁州区',	'﻿YuanZhouQu',	258,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1675,	'奉新县',	'﻿FengXinXian',	258,	1,	0,	'',	'﻿F',	0,	3,	0),
(1676,	'万载县',	'﻿WanZaiXian',	258,	1,	0,	'',	'﻿W',	0,	3,	0),
(1677,	'上高县',	'﻿ShangGaoXian',	258,	1,	0,	'',	'﻿S',	0,	3,	0),
(1678,	'宜丰县',	'﻿YiFengXian',	258,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1679,	'靖安县',	'﻿JingAnXian',	258,	1,	0,	'',	'﻿J',	0,	3,	0),
(1680,	'铜鼓县',	'﻿TongGuXian',	258,	1,	0,	'',	'﻿T',	0,	3,	0),
(1681,	'丰城市',	'﻿FengChengShi',	258,	1,	0,	'',	'﻿F',	0,	3,	0),
(1682,	'樟树市',	'﻿ZhangShuShi',	258,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1683,	'高安市',	'﻿GaoAnShi',	258,	1,	0,	'',	'﻿G',	0,	3,	0),
(1684,	'临川区',	'﻿LinChuanQu',	259,	1,	0,	'',	'﻿L',	0,	3,	0),
(1685,	'南城县',	'﻿NanChengXian',	259,	1,	0,	'',	'﻿N',	0,	3,	0),
(1686,	'黎川县',	'﻿LiChuanXian',	259,	1,	0,	'',	'﻿L',	0,	3,	0),
(1687,	'南丰县',	'﻿NanFengXian',	259,	1,	0,	'',	'﻿N',	0,	3,	0),
(1688,	'崇仁县',	'﻿ChongRenXian',	259,	1,	0,	'',	'﻿C',	0,	3,	0),
(1689,	'乐安县',	'﻿LeAnXian',	259,	1,	0,	'',	'﻿L',	0,	3,	0),
(1690,	'宜黄县',	'﻿YiHuangXian',	259,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1691,	'金溪县',	'﻿JinXiXian',	259,	1,	0,	'',	'﻿J',	0,	3,	0),
(1692,	'资溪县',	'﻿ZiXiXian',	259,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1693,	'东乡县',	'﻿DongXiangXian',	259,	1,	0,	'',	'﻿D',	0,	3,	0),
(1694,	'广昌县',	'﻿GuangChangXian',	259,	1,	0,	'',	'﻿G',	0,	3,	0),
(1695,	'信州区',	'﻿XinZhouQu',	260,	1,	0,	'',	'﻿X',	0,	3,	0),
(1696,	'上饶县',	'﻿ShangRaoXian',	260,	1,	0,	'',	'﻿S',	0,	3,	0),
(1697,	'广丰县',	'﻿GuangFengXian',	260,	1,	0,	'',	'﻿G',	0,	3,	0),
(1698,	'玉山县',	'﻿YuShanXian',	260,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1699,	'铅山县',	'﻿QianShanXian',	260,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1700,	'横峰县',	'﻿HengFengXian',	260,	1,	0,	'',	'﻿H',	0,	3,	0),
(1701,	'弋阳县',	'﻿YiYangXian',	260,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1702,	'余干县',	'﻿YuGanXian',	260,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1703,	'鄱阳县',	'﻿PoYangXian',	260,	1,	0,	'',	'﻿P',	0,	3,	0),
(1704,	'万年县',	'﻿WanNianXian',	260,	1,	0,	'',	'﻿W',	0,	3,	0),
(1705,	'婺源县',	'﻿WuYuanXian',	260,	1,	0,	'',	'﻿W',	0,	3,	0),
(1706,	'德兴市',	'﻿DeXingShi',	260,	1,	0,	'',	'﻿D',	0,	3,	0),
(1707,	'历下区',	'﻿LiXiaQu',	261,	1,	0,	'',	'﻿L',	0,	3,	0),
(1708,	'市中区',	'﻿ShiZhongQu',	261,	1,	0,	'',	'﻿S',	0,	3,	0),
(1709,	'槐荫区',	'﻿HuaiYinQu',	261,	1,	0,	'',	'﻿H',	0,	3,	0),
(1710,	'天桥区',	'﻿TianQiaoQu',	261,	1,	0,	'',	'﻿T',	0,	3,	0),
(1711,	'历城区',	'﻿LiChengQu',	261,	1,	0,	'',	'﻿L',	0,	3,	0),
(1712,	'长清区',	'﻿ChangQingQu',	261,	1,	0,	'',	'﻿C',	0,	3,	0),
(1713,	'平阴县',	'﻿PingYinXian',	261,	1,	0,	'',	'﻿P',	0,	3,	0),
(1714,	'济阳县',	'﻿JiYangXian',	261,	1,	0,	'',	'﻿J',	0,	3,	0),
(1715,	'商河县',	'﻿ShangHeXian',	261,	1,	0,	'',	'﻿S',	0,	3,	0),
(1716,	'章丘市',	'﻿ZhangQiuShi',	261,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1717,	'市南区',	'﻿ShiNanQu',	262,	1,	0,	'',	'﻿S',	0,	3,	0),
(1718,	'市北区',	'﻿ShiBeiQu',	262,	1,	0,	'',	'﻿S',	0,	3,	0),
(1719,	'四方区',	'﻿SiFangQu',	262,	1,	0,	'',	'﻿S',	0,	3,	0),
(1720,	'黄岛区',	'﻿HuangDaoQu',	262,	1,	0,	'',	'﻿H',	0,	3,	0),
(1721,	'崂山区',	'﻿LaoShanQu',	262,	1,	0,	'',	'﻿L',	0,	3,	0),
(1722,	'李沧区',	'﻿LiCangQu',	262,	1,	0,	'',	'﻿L',	0,	3,	0),
(1723,	'城阳区',	'﻿ChengYangQu',	262,	1,	0,	'',	'﻿C',	0,	3,	0),
(1724,	'胶州市',	'﻿JiaoZhouShi',	262,	1,	0,	'',	'﻿J',	0,	3,	0),
(1725,	'即墨市',	'﻿JiMoShi',	262,	1,	0,	'',	'﻿J',	0,	3,	0),
(1726,	'平度市',	'﻿PingDuShi',	262,	1,	0,	'',	'﻿P',	0,	3,	0),
(1727,	'胶南市',	'﻿JiaoNanShi',	262,	1,	0,	'',	'﻿J',	0,	3,	0),
(1728,	'莱西市',	'﻿LaiXiShi',	262,	1,	0,	'',	'﻿L',	0,	3,	0),
(1729,	'淄川区',	'﻿ZiChuanQu',	263,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1730,	'张店区',	'﻿ZhangDianQu',	263,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1731,	'博山区',	'﻿BoShanQu',	263,	1,	0,	'',	'﻿B',	0,	3,	0),
(1732,	'临淄区',	'﻿LinZiQu',	263,	1,	0,	'',	'﻿L',	0,	3,	0),
(1733,	'周村区',	'﻿ZhouCunQu',	263,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1734,	'桓台县',	'﻿HuanTaiXian',	263,	1,	0,	'',	'﻿H',	0,	3,	0),
(1735,	'高青县',	'﻿GaoQingXian',	263,	1,	0,	'',	'﻿G',	0,	3,	0),
(1736,	'沂源县',	'﻿YiYuanXian',	263,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1737,	'市中区',	'﻿ShiZhongQu',	264,	1,	0,	'',	'﻿S',	0,	3,	0),
(1738,	'薛城区',	'﻿XueChengQu',	264,	1,	0,	'',	'﻿X',	0,	3,	0),
(1739,	'峄城区',	'﻿YiChengQu',	264,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1740,	'台儿庄区',	'﻿TaiErZhuangQu',	264,	1,	0,	'',	'﻿T',	0,	3,	0),
(1741,	'山亭区',	'﻿ShanTingQu',	264,	1,	0,	'',	'﻿S',	0,	3,	0),
(1742,	'滕州市',	'﻿TengZhouShi',	264,	1,	0,	'',	'﻿T',	0,	3,	0),
(1743,	'东营区',	'﻿DongYingQu',	265,	1,	0,	'',	'﻿D',	0,	3,	0),
(1744,	'河口区',	'﻿HeKouQu',	265,	1,	0,	'',	'﻿H',	0,	3,	0),
(1745,	'垦利县',	'﻿KenLiXian',	265,	1,	0,	'',	'﻿K',	0,	3,	0),
(1746,	'利津县',	'﻿LiJinXian',	265,	1,	0,	'',	'﻿L',	0,	3,	0),
(1747,	'广饶县',	'﻿GuangRaoXian',	265,	1,	0,	'',	'﻿G',	0,	3,	0),
(1748,	'芝罘区',	'﻿ZhiFuQu',	266,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1749,	'福山区',	'﻿FuShanQu',	266,	1,	0,	'',	'﻿F',	0,	3,	0),
(1750,	'牟平区',	'﻿MouPingQu',	266,	1,	0,	'',	'﻿M',	0,	3,	0),
(1751,	'莱山区',	'﻿LaiShanQu',	266,	1,	0,	'',	'﻿L',	0,	3,	0),
(1752,	'长岛县',	'﻿ChangDaoXian',	266,	1,	0,	'',	'﻿C',	0,	3,	0),
(1753,	'龙口市',	'﻿LongKouShi',	266,	1,	0,	'',	'﻿L',	0,	3,	0),
(1754,	'莱阳市',	'﻿LaiYangShi',	266,	1,	0,	'',	'﻿L',	0,	3,	0),
(1755,	'莱州市',	'﻿LaiZhouShi',	266,	1,	0,	'',	'﻿L',	0,	3,	0),
(1756,	'蓬莱市',	'﻿PengLaiShi',	266,	1,	0,	'',	'﻿P',	0,	3,	0),
(1757,	'招远市',	'﻿ZhaoYuanShi',	266,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1758,	'栖霞市',	'﻿QiXiaShi',	266,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1759,	'海阳市',	'﻿HaiYangShi',	266,	1,	0,	'',	'﻿H',	0,	3,	0),
(1760,	'潍城区',	'﻿WeiChengQu',	267,	1,	0,	'',	'﻿W',	0,	3,	0),
(1761,	'寒亭区',	'﻿HanTingQu',	267,	1,	0,	'',	'﻿H',	0,	3,	0),
(1762,	'坊子区',	'﻿FangZiQu',	267,	1,	0,	'',	'﻿F',	0,	3,	0),
(1763,	'奎文区',	'﻿KuiWenQu',	267,	1,	0,	'',	'﻿K',	0,	3,	0),
(1764,	'临朐县',	'﻿LinQuXian',	267,	1,	0,	'',	'﻿L',	0,	3,	0),
(1765,	'昌乐县',	'﻿ChangLeXian',	267,	1,	0,	'',	'﻿C',	0,	3,	0),
(1766,	'青州市',	'﻿QingZhouShi',	267,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1767,	'诸城市',	'﻿ZhuChengShi',	267,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1768,	'寿光市',	'﻿ShouGuangShi',	267,	1,	0,	'',	'﻿S',	0,	3,	0),
(1769,	'安丘市',	'﻿AnQiuShi',	267,	1,	0,	'',	'﻿A',	0,	3,	0),
(1770,	'高密市',	'﻿GaoMiShi',	267,	1,	0,	'',	'﻿G',	0,	3,	0),
(1771,	'昌邑市',	'﻿ChangYiShi',	267,	1,	0,	'',	'﻿C',	0,	3,	0),
(1772,	'市中区',	'﻿ShiZhongQu',	268,	1,	0,	'',	'﻿S',	0,	3,	0),
(1773,	'任城区',	'﻿RenChengQu',	268,	1,	0,	'',	'﻿R',	0,	3,	0),
(1774,	'微山县',	'﻿WeiShanXian',	268,	1,	0,	'',	'﻿W',	0,	3,	0),
(1775,	'鱼台县',	'﻿YuTaiXian',	268,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1776,	'金乡县',	'﻿JinXiangXian',	268,	1,	0,	'',	'﻿J',	0,	3,	0),
(1777,	'嘉祥县',	'﻿JiaXiangXian',	268,	1,	0,	'',	'﻿J',	0,	3,	0),
(1778,	'汶上县',	'﻿WenShangXian',	268,	1,	0,	'',	'﻿W',	0,	3,	0),
(1779,	'泗水县',	'﻿SiShuiXian',	268,	1,	0,	'',	'﻿S',	0,	3,	0),
(1780,	'梁山县',	'﻿LiangShanXian',	268,	1,	0,	'',	'﻿L',	0,	3,	0),
(1781,	'曲阜市',	'﻿QuFuShi',	268,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1782,	'兖州市',	'﻿YanZhouShi',	268,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1783,	'邹城市',	'﻿ZouChengShi',	268,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1784,	'泰山区',	'﻿TaiShanQu',	269,	1,	0,	'',	'﻿T',	0,	3,	0),
(1785,	'岱岳区',	'﻿DaiYueQu',	269,	1,	0,	'',	'﻿D',	0,	3,	0),
(1786,	'宁阳县',	'﻿NingYangXian',	269,	1,	0,	'',	'﻿N',	0,	3,	0),
(1787,	'东平县',	'﻿DongPingXian',	269,	1,	0,	'',	'﻿D',	0,	3,	0),
(1788,	'新泰市',	'﻿XinTaiShi',	269,	1,	0,	'',	'﻿X',	0,	3,	0),
(1789,	'肥城市',	'﻿FeiChengShi',	269,	1,	0,	'',	'﻿F',	0,	3,	0),
(1790,	'环翠区',	'﻿HuanCuiQu',	270,	1,	0,	'',	'﻿H',	0,	3,	0),
(1791,	'文登市',	'﻿WenDengShi',	270,	1,	0,	'',	'﻿W',	0,	3,	0),
(1792,	'荣成市',	'﻿RongChengShi',	270,	1,	0,	'',	'﻿R',	0,	3,	0),
(1793,	'乳山市',	'﻿RuShanShi',	270,	1,	0,	'',	'﻿R',	0,	3,	0),
(1794,	'东港区',	'﻿DongGangQu',	271,	1,	0,	'',	'﻿D',	0,	3,	0),
(1795,	'岚山区',	'﻿LanShanQu',	271,	1,	0,	'',	'﻿L',	0,	3,	0),
(1796,	'五莲县',	'﻿WuLianXian',	271,	1,	0,	'',	'﻿W',	0,	3,	0),
(1797,	'莒县',	'﻿JuXian',	271,	1,	0,	'',	'﻿J',	0,	3,	0),
(1798,	'莱城区',	'﻿LaiChengQu',	272,	1,	0,	'',	'﻿L',	0,	3,	0),
(1799,	'钢城区',	'﻿GangChengQu',	272,	1,	0,	'',	'﻿G',	0,	3,	0),
(1800,	'兰山区',	'﻿LanShanQu',	273,	1,	0,	'',	'﻿L',	0,	3,	0),
(1801,	'罗庄区',	'﻿LuoZhuangQu',	273,	1,	0,	'',	'﻿L',	0,	3,	0),
(1802,	'河东区',	'﻿HeDongQu',	273,	1,	0,	'',	'﻿H',	0,	3,	0),
(1803,	'沂南县',	'﻿YiNanXian',	273,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1804,	'郯城县',	'﻿TanChengXian',	273,	1,	0,	'',	'﻿T',	0,	3,	0),
(1805,	'沂水县',	'﻿YiShuiXian',	273,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1806,	'苍山县',	'﻿CangShanXian',	273,	1,	0,	'',	'﻿C',	0,	3,	0),
(1807,	'费县',	'﻿FeiXian',	273,	1,	0,	'',	'﻿F',	0,	3,	0),
(1808,	'平邑县',	'﻿PingYiXian',	273,	1,	0,	'',	'﻿P',	0,	3,	0),
(1809,	'莒南县',	'﻿JuNanXian',	273,	1,	0,	'',	'﻿J',	0,	3,	0),
(1810,	'蒙阴县',	'﻿MengYinXian',	273,	1,	0,	'',	'﻿M',	0,	3,	0),
(1811,	'临沭县',	'﻿LinShuXian',	273,	1,	0,	'',	'﻿L',	0,	3,	0),
(1812,	'德城区',	'﻿DeChengQu',	274,	1,	0,	'',	'﻿D',	0,	3,	0),
(1813,	'陵县',	'﻿LingXian',	274,	1,	0,	'',	'﻿L',	0,	3,	0),
(1814,	'宁津县',	'﻿NingJinXian',	274,	1,	0,	'',	'﻿N',	0,	3,	0),
(1815,	'庆云县',	'﻿QingYunXian',	274,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1816,	'临邑县',	'﻿LinYiXian',	274,	1,	0,	'',	'﻿L',	0,	3,	0),
(1817,	'齐河县',	'﻿QiHeXian',	274,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1818,	'平原县',	'﻿PingYuanXian',	274,	1,	0,	'',	'﻿P',	0,	3,	0),
(1819,	'夏津县',	'﻿XiaJinXian',	274,	1,	0,	'',	'﻿X',	0,	3,	0),
(1820,	'武城县',	'﻿WuChengXian',	274,	1,	0,	'',	'﻿W',	0,	3,	0),
(1821,	'乐陵市',	'﻿LeLingShi',	274,	1,	0,	'',	'﻿L',	0,	3,	0),
(1822,	'禹城市',	'﻿YuChengShi',	274,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1823,	'东昌府区',	'﻿DongChangFuQu',	275,	1,	0,	'',	'﻿D',	0,	3,	0),
(1824,	'阳谷县',	'﻿YangGuXian',	275,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1825,	'莘县',	'﻿ShenXian',	275,	1,	0,	'',	'﻿S',	0,	3,	0),
(1826,	'茌平县',	'﻿ChiPingXian',	275,	1,	0,	'',	'﻿C',	0,	3,	0),
(1827,	'东阿县',	'﻿DongAXian',	275,	1,	0,	'',	'﻿D',	0,	3,	0),
(1828,	'冠县',	'﻿GuanXian',	275,	1,	0,	'',	'﻿G',	0,	3,	0),
(1829,	'高唐县',	'﻿GaoTangXian',	275,	1,	0,	'',	'﻿G',	0,	3,	0),
(1830,	'临清市',	'﻿LinQingShi',	275,	1,	0,	'',	'﻿L',	0,	3,	0),
(1831,	'滨城区',	'﻿BinChengQu',	276,	1,	0,	'',	'﻿B',	0,	3,	0),
(1832,	'惠民县',	'﻿HuiMinXian',	276,	1,	0,	'',	'﻿H',	0,	3,	0),
(1833,	'阳信县',	'﻿YangXinXian',	276,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1834,	'无棣县',	'﻿WuDiXian',	276,	1,	0,	'',	'﻿W',	0,	3,	0),
(1835,	'沾化县',	'﻿ZhanHuaXian',	276,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1836,	'博兴县',	'﻿BoXingXian',	276,	1,	0,	'',	'﻿B',	0,	3,	0),
(1837,	'邹平县',	'﻿ZouPingXian',	276,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1838,	'牡丹区',	'﻿MuDanQu',	277,	1,	0,	'',	'﻿M',	0,	3,	0),
(1839,	'曹县',	'﻿CaoXian',	277,	1,	0,	'',	'﻿C',	0,	3,	0),
(1840,	'单县',	'﻿DanXian',	277,	1,	0,	'',	'﻿D',	0,	3,	0),
(1841,	'成武县',	'﻿ChengWuXian',	277,	1,	0,	'',	'﻿C',	0,	3,	0),
(1842,	'巨野县',	'﻿JuYeXian',	277,	1,	0,	'',	'﻿J',	0,	3,	0),
(1843,	'郓城县',	'﻿YunChengXian',	277,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1844,	'鄄城县',	'﻿JuanChengXian',	277,	1,	0,	'',	'﻿J',	0,	3,	0),
(1845,	'定陶县',	'﻿DingTaoXian',	277,	1,	0,	'',	'﻿D',	0,	3,	0),
(1846,	'东明县',	'﻿DongMingXian',	277,	1,	0,	'',	'﻿D',	0,	3,	0),
(1847,	'中原区',	'﻿ZhongYuanQu',	278,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1848,	'二七区',	'﻿ErQiQu',	278,	1,	0,	'',	'﻿E',	0,	3,	0),
(1849,	'管城回族区',	'﻿GuanChengHuiZuQu',	278,	1,	0,	'',	'﻿G',	0,	3,	0),
(1850,	'金水区',	'﻿JinShuiQu',	278,	1,	0,	'',	'﻿J',	0,	3,	0),
(1851,	'上街区',	'﻿ShangJieQu',	278,	1,	0,	'',	'﻿S',	0,	3,	0),
(1852,	'惠济区',	'﻿HuiJiQu',	278,	1,	0,	'',	'﻿H',	0,	3,	0),
(1853,	'中牟县',	'﻿ZhongMouXian',	278,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1854,	'巩义市',	'﻿GongYiShi',	278,	1,	0,	'',	'﻿G',	0,	3,	0),
(1855,	'荥阳市',	'﻿XingYangShi',	278,	1,	0,	'',	'﻿X',	0,	3,	0),
(1856,	'新密市',	'﻿XinMiShi',	278,	1,	0,	'',	'﻿X',	0,	3,	0),
(1857,	'新郑市',	'﻿XinZhengShi',	278,	1,	0,	'',	'﻿X',	0,	3,	0),
(1858,	'登封市',	'﻿DengFengShi',	278,	1,	0,	'',	'﻿D',	0,	3,	0),
(1859,	'龙亭区',	'﻿LongTingQu',	279,	1,	0,	'',	'﻿L',	0,	3,	0),
(1860,	'顺河回族区',	'﻿ShunHeHuiZuQu',	279,	1,	0,	'',	'﻿S',	0,	3,	0),
(1861,	'鼓楼区',	'﻿GuLouQu',	279,	1,	0,	'',	'﻿G',	0,	3,	0),
(1862,	'禹王台区',	'﻿YuWangTaiQu',	279,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1863,	'金明区',	'﻿JinMingQu',	279,	1,	0,	'',	'﻿J',	0,	3,	0),
(1864,	'杞县',	'﻿QiXian',	279,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1865,	'通许县',	'﻿TongXuXian',	279,	1,	0,	'',	'﻿T',	0,	3,	0),
(1866,	'尉氏县',	'﻿WeiShiXian',	279,	1,	0,	'',	'﻿W',	0,	3,	0),
(1867,	'开封县',	'﻿KaiFengXian',	279,	1,	0,	'',	'﻿K',	0,	3,	0),
(1868,	'兰考县',	'﻿LanKaoXian',	279,	1,	0,	'',	'﻿L',	0,	3,	0),
(1869,	'老城区',	'﻿LaoChengQu',	280,	1,	0,	'',	'﻿L',	0,	3,	0),
(1870,	'西工区',	'﻿XiGongQu',	280,	1,	0,	'',	'﻿X',	0,	3,	0),
(1871,	'廛河回族区',	'﻿ChanHeHuiZuQu',	280,	1,	0,	'',	'﻿C',	0,	3,	0),
(1872,	'涧西区',	'﻿JianXiQu',	280,	1,	0,	'',	'﻿J',	0,	3,	0),
(1873,	'吉利区',	'﻿JiLiQu',	280,	1,	0,	'',	'﻿J',	0,	3,	0),
(1874,	'洛龙区',	'﻿LuoLongQu',	280,	1,	0,	'',	'﻿L',	0,	3,	0),
(1875,	'孟津县',	'﻿MengJinXian',	280,	1,	0,	'',	'﻿M',	0,	3,	0),
(1876,	'新安县',	'﻿XinAnXian',	280,	1,	0,	'',	'﻿X',	0,	3,	0),
(1877,	'栾川县',	'﻿LuanChuanXian',	280,	1,	0,	'',	'﻿L',	0,	3,	0),
(1878,	'嵩县',	'﻿SongXian',	280,	1,	0,	'',	'﻿S',	0,	3,	0),
(1879,	'汝阳县',	'﻿RuYangXian',	280,	1,	0,	'',	'﻿R',	0,	3,	0),
(1880,	'宜阳县',	'﻿YiYangXian',	280,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1881,	'洛宁县',	'﻿LuoNingXian',	280,	1,	0,	'',	'﻿L',	0,	3,	0),
(1882,	'伊川县',	'﻿YiChuanXian',	280,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1883,	'偃师市',	'﻿YanShiShi',	280,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1884,	'新华区',	'﻿XinHuaQu',	281,	1,	0,	'',	'﻿X',	0,	3,	0),
(1885,	'卫东区',	'﻿WeiDongQu',	281,	1,	0,	'',	'﻿W',	0,	3,	0),
(1886,	'石龙区',	'﻿ShiLongQu',	281,	1,	0,	'',	'﻿S',	0,	3,	0),
(1887,	'湛河区',	'﻿ZhanHeQu',	281,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1888,	'宝丰县',	'﻿BaoFengXian',	281,	1,	0,	'',	'﻿B',	0,	3,	0),
(1889,	'叶县',	'﻿YeXian',	281,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1890,	'鲁山县',	'﻿LuShanXian',	281,	1,	0,	'',	'﻿L',	0,	3,	0),
(1891,	'郏县',	'﻿JiaXian',	281,	1,	0,	'',	'﻿J',	0,	3,	0),
(1892,	'舞钢市',	'﻿WuGangShi',	281,	1,	0,	'',	'﻿W',	0,	3,	0),
(1893,	'汝州市',	'﻿RuZhouShi',	281,	1,	0,	'',	'﻿R',	0,	3,	0),
(1894,	'文峰区',	'﻿WenFengQu',	282,	1,	0,	'',	'﻿W',	0,	3,	0),
(1895,	'北关区',	'﻿BeiGuanQu',	282,	1,	0,	'',	'﻿B',	0,	3,	0),
(1896,	'殷都区',	'﻿YinDuQu',	282,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1897,	'龙安区',	'﻿LongAnQu',	282,	1,	0,	'',	'﻿L',	0,	3,	0),
(1898,	'安阳县',	'﻿AnYangXian',	282,	1,	0,	'',	'﻿A',	0,	3,	0),
(1899,	'汤阴县',	'﻿TangYinXian',	282,	1,	0,	'',	'﻿T',	0,	3,	0),
(1900,	'滑县',	'﻿HuaXian',	282,	1,	0,	'',	'﻿H',	0,	3,	0),
(1901,	'内黄县',	'﻿NeiHuangXian',	282,	1,	0,	'',	'﻿N',	0,	3,	0),
(1902,	'林州市',	'﻿LinZhouShi',	282,	1,	0,	'',	'﻿L',	0,	3,	0),
(1903,	'鹤山区',	'﻿HeShanQu',	283,	1,	0,	'',	'﻿H',	0,	3,	0),
(1904,	'山城区',	'﻿ShanChengQu',	283,	1,	0,	'',	'﻿S',	0,	3,	0),
(1905,	'淇滨区',	'﻿QiBinQu',	283,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1906,	'浚县',	'﻿JunXian',	283,	1,	0,	'',	'﻿J',	0,	3,	0),
(1907,	'淇县',	'﻿QiXian',	283,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1908,	'红旗区',	'﻿HongQiQu',	284,	1,	0,	'',	'﻿H',	0,	3,	0),
(1909,	'卫滨区',	'﻿WeiBinQu',	284,	1,	0,	'',	'﻿W',	0,	3,	0),
(1910,	'凤泉区',	'﻿FengQuanQu',	284,	1,	0,	'',	'﻿F',	0,	3,	0),
(1911,	'牧野区',	'﻿MuYeQu',	284,	1,	0,	'',	'﻿M',	0,	3,	0),
(1912,	'新乡县',	'﻿XinXiangXian',	284,	1,	0,	'',	'﻿X',	0,	3,	0),
(1913,	'获嘉县',	'﻿HuoJiaXian',	284,	1,	0,	'',	'﻿H',	0,	3,	0),
(1914,	'原阳县',	'﻿YuanYangXian',	284,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1915,	'延津县',	'﻿YanJinXian',	284,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1916,	'封丘县',	'﻿FengQiuXian',	284,	1,	0,	'',	'﻿F',	0,	3,	0),
(1917,	'长垣县',	'﻿ChangYuanXian',	284,	1,	0,	'',	'﻿C',	0,	3,	0),
(1918,	'卫辉市',	'﻿WeiHuiShi',	284,	1,	0,	'',	'﻿W',	0,	3,	0),
(1919,	'辉县市',	'﻿HuiXianShi',	284,	1,	0,	'',	'﻿H',	0,	3,	0),
(1920,	'解放区',	'﻿JieFangQu',	285,	1,	0,	'',	'﻿J',	0,	3,	0),
(1921,	'中站区',	'﻿ZhongZhanQu',	285,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1922,	'马村区',	'﻿MaCunQu',	285,	1,	0,	'',	'﻿M',	0,	3,	0),
(1923,	'山阳区',	'﻿ShanYangQu',	285,	1,	0,	'',	'﻿S',	0,	3,	0),
(1924,	'修武县',	'﻿XiuWuXian',	285,	1,	0,	'',	'﻿X',	0,	3,	0),
(1925,	'博爱县',	'﻿BoAiXian',	285,	1,	0,	'',	'﻿B',	0,	3,	0),
(1926,	'武陟县',	'﻿WuZhiXian',	285,	1,	0,	'',	'﻿W',	0,	3,	0),
(1927,	'温县',	'﻿WenXian',	285,	1,	0,	'',	'﻿W',	0,	3,	0),
(1928,	'济源市',	'﻿JiYuanShi',	285,	1,	0,	'',	'﻿J',	0,	3,	0),
(1929,	'沁阳市',	'﻿QinYangShi',	285,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1930,	'孟州市',	'﻿MengZhouShi',	285,	1,	0,	'',	'﻿M',	0,	3,	0),
(1931,	'华龙区',	'﻿HuaLongQu',	286,	1,	0,	'',	'﻿H',	0,	3,	0),
(1932,	'清丰县',	'﻿QingFengXian',	286,	1,	0,	'',	'﻿Q',	0,	3,	0),
(1933,	'南乐县',	'﻿NanLeXian',	286,	1,	0,	'',	'﻿N',	0,	3,	0),
(1934,	'范县',	'﻿FanXian',	286,	1,	0,	'',	'﻿F',	0,	3,	0),
(1935,	'台前县',	'﻿TaiQianXian',	286,	1,	0,	'',	'﻿T',	0,	3,	0),
(1936,	'濮阳县',	'﻿PuYangXian',	286,	1,	0,	'',	'﻿P',	0,	3,	0),
(1937,	'魏都区',	'﻿WeiDuQu',	287,	1,	0,	'',	'﻿W',	0,	3,	0),
(1938,	'许昌县',	'﻿XuChangXian',	287,	1,	0,	'',	'﻿X',	0,	3,	0),
(1939,	'鄢陵县',	'﻿YanLingXian',	287,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1940,	'襄城县',	'﻿XiangChengXian',	287,	1,	0,	'',	'﻿X',	0,	3,	0),
(1941,	'禹州市',	'﻿YuZhouShi',	287,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1942,	'长葛市',	'﻿ChangGeShi',	287,	1,	0,	'',	'﻿C',	0,	3,	0),
(1943,	'源汇区',	'﻿YuanHuiQu',	288,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1944,	'郾城区',	'﻿YanChengQu',	288,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1945,	'召陵区',	'﻿ZhaoLingQu',	288,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1946,	'舞阳县',	'﻿WuYangXian',	288,	1,	0,	'',	'﻿W',	0,	3,	0),
(1947,	'临颍县',	'﻿LinYingXian',	288,	1,	0,	'',	'﻿L',	0,	3,	0),
(1948,	'湖滨区',	'﻿HuBinQu',	289,	1,	0,	'',	'﻿H',	0,	3,	0),
(1949,	'渑池县',	'﻿MianChiXian',	289,	1,	0,	'',	'﻿M',	0,	3,	0),
(1950,	'陕县',	'﻿ShanXian',	289,	1,	0,	'',	'﻿S',	0,	3,	0),
(1951,	'卢氏县',	'﻿LuShiXian',	289,	1,	0,	'',	'﻿L',	0,	3,	0),
(1952,	'义马市',	'﻿YiMaShi',	289,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1953,	'灵宝市',	'﻿LingBaoShi',	289,	1,	0,	'',	'﻿L',	0,	3,	0),
(1954,	'宛城区',	'﻿WanChengQu',	290,	1,	0,	'',	'﻿W',	0,	3,	0),
(1955,	'卧龙区',	'﻿WoLongQu',	290,	1,	0,	'',	'﻿W',	0,	3,	0),
(1956,	'南召县',	'﻿NanZhaoXian',	290,	1,	0,	'',	'﻿N',	0,	3,	0),
(1957,	'方城县',	'﻿FangChengXian',	290,	1,	0,	'',	'﻿F',	0,	3,	0),
(1958,	'西峡县',	'﻿XiXiaXian',	290,	1,	0,	'',	'﻿X',	0,	3,	0),
(1959,	'镇平县',	'﻿ZhenPingXian',	290,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1960,	'内乡县',	'﻿NeiXiangXian',	290,	1,	0,	'',	'﻿N',	0,	3,	0),
(1961,	'淅川县',	'﻿XiChuanXian',	290,	1,	0,	'',	'﻿X',	0,	3,	0),
(1962,	'社旗县',	'﻿SheQiXian',	290,	1,	0,	'',	'﻿S',	0,	3,	0),
(1963,	'唐河县',	'﻿TangHeXian',	290,	1,	0,	'',	'﻿T',	0,	3,	0),
(1964,	'新野县',	'﻿XinYeXian',	290,	1,	0,	'',	'﻿X',	0,	3,	0),
(1965,	'桐柏县',	'﻿TongBaiXian',	290,	1,	0,	'',	'﻿T',	0,	3,	0),
(1966,	'邓州市',	'﻿DengZhouShi',	290,	1,	0,	'',	'﻿D',	0,	3,	0),
(1967,	'梁园区',	'﻿LiangYuanQu',	291,	1,	0,	'',	'﻿L',	0,	3,	0),
(1968,	'睢阳区',	'﻿SuiYangQu',	291,	1,	0,	'',	'﻿S',	0,	3,	0),
(1969,	'民权县',	'﻿MinQuanXian',	291,	1,	0,	'',	'﻿M',	0,	3,	0),
(1970,	'睢县',	'﻿SuiXian',	291,	1,	0,	'',	'﻿S',	0,	3,	0),
(1971,	'宁陵县',	'﻿NingLingXian',	291,	1,	0,	'',	'﻿N',	0,	3,	0),
(1972,	'柘城县',	'﻿ZheChengXian',	291,	1,	0,	'',	'﻿Z',	0,	3,	0),
(1973,	'虞城县',	'﻿YuChengXian',	291,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1974,	'夏邑县',	'﻿XiaYiXian',	291,	1,	0,	'',	'﻿X',	0,	3,	0),
(1975,	'永城市',	'﻿YongChengShi',	291,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1976,	'浉河区',	'﻿',	292,	1,	0,	'',	'﻿',	0,	3,	0),
(1977,	'平桥区',	'﻿PingQiaoQu',	292,	1,	0,	'',	'﻿P',	0,	3,	0),
(1978,	'罗山县',	'﻿LuoShanXian',	292,	1,	0,	'',	'﻿L',	0,	3,	0),
(1979,	'光山县',	'﻿GuangShanXian',	292,	1,	0,	'',	'﻿G',	0,	3,	0),
(1980,	'新县',	'﻿XinXian',	292,	1,	0,	'',	'﻿X',	0,	3,	0),
(1981,	'商城县',	'﻿ShangChengXian',	292,	1,	0,	'',	'﻿S',	0,	3,	0),
(1982,	'固始县',	'﻿GuShiXian',	292,	1,	0,	'',	'﻿G',	0,	3,	0),
(1983,	'潢川县',	'﻿HuangChuanXian',	292,	1,	0,	'',	'﻿H',	0,	3,	0),
(1984,	'淮滨县',	'﻿HuaiBinXian',	292,	1,	0,	'',	'﻿H',	0,	3,	0),
(1985,	'息县',	'﻿XiXian',	292,	1,	0,	'',	'﻿X',	0,	3,	0),
(1986,	'川汇区',	'﻿ChuanHuiQu',	293,	1,	0,	'',	'﻿C',	0,	3,	0),
(1987,	'扶沟县',	'﻿FuGouXian',	293,	1,	0,	'',	'﻿F',	0,	3,	0),
(1988,	'西华县',	'﻿XiHuaXian',	293,	1,	0,	'',	'﻿X',	0,	3,	0),
(1989,	'商水县',	'﻿ShangShuiXian',	293,	1,	0,	'',	'﻿S',	0,	3,	0),
(1990,	'沈丘县',	'﻿ShenQiuXian',	293,	1,	0,	'',	'﻿S',	0,	3,	0),
(1991,	'郸城县',	'﻿DanChengXian',	293,	1,	0,	'',	'﻿D',	0,	3,	0),
(1992,	'淮阳县',	'﻿HuaiYangXian',	293,	1,	0,	'',	'﻿H',	0,	3,	0),
(1993,	'太康县',	'﻿TaiKangXian',	293,	1,	0,	'',	'﻿T',	0,	3,	0),
(1994,	'鹿邑县',	'﻿LuYiXian',	293,	1,	0,	'',	'﻿L',	0,	3,	0),
(1995,	'项城市',	'﻿XiangChengShi',	293,	1,	0,	'',	'﻿X',	0,	3,	0),
(1996,	'驿城区',	'﻿YiChengQu',	294,	1,	0,	'',	'﻿Y',	0,	3,	0),
(1997,	'西平县',	'﻿XiPingXian',	294,	1,	0,	'',	'﻿X',	0,	3,	0),
(1998,	'上蔡县',	'﻿ShangCaiXian',	294,	1,	0,	'',	'﻿S',	0,	3,	0),
(1999,	'平舆县',	'﻿PingYuXian',	294,	1,	0,	'',	'﻿P',	0,	3,	0),
(2000,	'正阳县',	'﻿ZhengYangXian',	294,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2001,	'确山县',	'﻿QueShanXian',	294,	1,	0,	'',	'﻿Q',	0,	3,	0),
(2002,	'泌阳县',	'﻿MiYangXian',	294,	1,	0,	'',	'﻿M',	0,	3,	0),
(2003,	'汝南县',	'﻿RuNanXian',	294,	1,	0,	'',	'﻿R',	0,	3,	0),
(2004,	'遂平县',	'﻿SuiPingXian',	294,	1,	0,	'',	'﻿S',	0,	3,	0),
(2005,	'新蔡县',	'﻿XinCaiXian',	294,	1,	0,	'',	'﻿X',	0,	3,	0),
(2006,	'江岸区',	'﻿JiangAnQu',	295,	1,	0,	'',	'﻿J',	0,	3,	0),
(2007,	'江汉区',	'﻿JiangHanQu',	295,	1,	0,	'',	'﻿J',	0,	3,	0),
(2008,	'硚口区',	'﻿',	295,	1,	0,	'',	'﻿',	0,	3,	0),
(2009,	'汉阳区',	'﻿HanYangQu',	295,	1,	0,	'',	'﻿H',	0,	3,	0),
(2010,	'武昌区',	'﻿WuChangQu',	295,	1,	0,	'',	'﻿W',	0,	3,	0),
(2011,	'青山区',	'﻿QingShanQu',	295,	1,	0,	'',	'﻿Q',	0,	3,	0),
(2012,	'洪山区',	'﻿HongShanQu',	295,	1,	0,	'',	'﻿H',	0,	3,	0),
(2013,	'东西湖区',	'﻿DongXiHuQu',	295,	1,	0,	'',	'﻿D',	0,	3,	0),
(2014,	'汉南区',	'﻿HanNanQu',	295,	1,	0,	'',	'﻿H',	0,	3,	0),
(2015,	'蔡甸区',	'﻿CaiDianQu',	295,	1,	0,	'',	'﻿C',	0,	3,	0),
(2016,	'江夏区',	'﻿JiangXiaQu',	295,	1,	0,	'',	'﻿J',	0,	3,	0),
(2017,	'黄陂区',	'﻿HuangBeiQu',	295,	1,	0,	'',	'﻿H',	0,	3,	0),
(2018,	'新洲区',	'﻿XinZhouQu',	295,	1,	0,	'',	'﻿X',	0,	3,	0),
(2019,	'黄石港区',	'﻿HuangShiGangQu',	296,	1,	0,	'',	'﻿H',	0,	3,	0),
(2020,	'西塞山区',	'﻿XiSaiShanQu',	296,	1,	0,	'',	'﻿X',	0,	3,	0),
(2021,	'下陆区',	'﻿XiaLuQu',	296,	1,	0,	'',	'﻿X',	0,	3,	0),
(2022,	'铁山区',	'﻿TieShanQu',	296,	1,	0,	'',	'﻿T',	0,	3,	0),
(2023,	'阳新县',	'﻿YangXinXian',	296,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2024,	'大冶市',	'﻿DaYeShi',	296,	1,	0,	'',	'﻿D',	0,	3,	0),
(2025,	'茅箭区',	'﻿MaoJianQu',	297,	1,	0,	'',	'﻿M',	0,	3,	0),
(2026,	'张湾区',	'﻿ZhangWanQu',	297,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2027,	'郧县',	'﻿YunXian',	297,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2028,	'郧西县',	'﻿YunXiXian',	297,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2029,	'竹山县',	'﻿ZhuShanXian',	297,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2030,	'竹溪县',	'﻿ZhuXiXian',	297,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2031,	'房县',	'﻿FangXian',	297,	1,	0,	'',	'﻿F',	0,	3,	0),
(2032,	'丹江口市',	'﻿DanJiangKouShi',	297,	1,	0,	'',	'﻿D',	0,	3,	0),
(2033,	'西陵区',	'﻿XiLingQu',	298,	1,	0,	'',	'﻿X',	0,	3,	0),
(2034,	'伍家岗区',	'﻿WuJiaGangQu',	298,	1,	0,	'',	'﻿W',	0,	3,	0),
(2035,	'点军区',	'﻿DianJunQu',	298,	1,	0,	'',	'﻿D',	0,	3,	0),
(2036,	'猇亭区',	'﻿',	298,	1,	0,	'',	'﻿',	0,	3,	0),
(2037,	'夷陵区',	'﻿YiLingQu',	298,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2038,	'远安县',	'﻿YuanAnXian',	298,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2039,	'兴山县',	'﻿XingShanXian',	298,	1,	0,	'',	'﻿X',	0,	3,	0),
(2040,	'秭归县',	'﻿ZiGuiXian',	298,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2041,	'长阳土家族自治县',	'﻿ChangYangTuJiaZuZiZhiXian',	298,	1,	0,	'',	'﻿C',	0,	3,	0),
(2042,	'五峰土家族自治县',	'﻿WuFengTuJiaZuZiZhiXian',	298,	1,	0,	'',	'﻿W',	0,	3,	0),
(2043,	'宜都市',	'﻿YiDuShi',	298,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2044,	'当阳市',	'﻿DangYangShi',	298,	1,	0,	'',	'﻿D',	0,	3,	0),
(2045,	'枝江市',	'﻿ZhiJiangShi',	298,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2046,	'襄城区',	'﻿XiangChengQu',	299,	1,	0,	'',	'﻿X',	0,	3,	0),
(2047,	'樊城区',	'﻿FanChengQu',	299,	1,	0,	'',	'﻿F',	0,	3,	0),
(2048,	'襄阳区',	'﻿XiangYangQu',	299,	1,	0,	'',	'﻿X',	0,	3,	0),
(2049,	'南漳县',	'﻿NanZhangXian',	299,	1,	0,	'',	'﻿N',	0,	3,	0),
(2050,	'谷城县',	'﻿GuChengXian',	299,	1,	0,	'',	'﻿G',	0,	3,	0),
(2051,	'保康县',	'﻿BaoKangXian',	299,	1,	0,	'',	'﻿B',	0,	3,	0),
(2052,	'老河口市',	'﻿LaoHeKouShi',	299,	1,	0,	'',	'﻿L',	0,	3,	0),
(2053,	'枣阳市',	'﻿ZaoYangShi',	299,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2054,	'宜城市',	'﻿YiChengShi',	299,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2055,	'梁子湖区',	'﻿LiangZiHuQu',	300,	1,	0,	'',	'﻿L',	0,	3,	0),
(2056,	'华容区',	'﻿HuaRongQu',	300,	1,	0,	'',	'﻿H',	0,	3,	0),
(2057,	'鄂城区',	'﻿EChengQu',	300,	1,	0,	'',	'﻿E',	0,	3,	0),
(2058,	'东宝区',	'﻿DongBaoQu',	301,	1,	0,	'',	'﻿D',	0,	3,	0),
(2059,	'掇刀区',	'﻿DuoDaoQu',	301,	1,	0,	'',	'﻿D',	0,	3,	0),
(2060,	'京山县',	'﻿JingShanXian',	301,	1,	0,	'',	'﻿J',	0,	3,	0),
(2061,	'沙洋县',	'﻿ShaYangXian',	301,	1,	0,	'',	'﻿S',	0,	3,	0),
(2062,	'钟祥市',	'﻿ZhongXiangShi',	301,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2063,	'孝南区',	'﻿XiaoNanQu',	302,	1,	0,	'',	'﻿X',	0,	3,	0),
(2064,	'孝昌县',	'﻿XiaoChangXian',	302,	1,	0,	'',	'﻿X',	0,	3,	0),
(2065,	'大悟县',	'﻿DaWuXian',	302,	1,	0,	'',	'﻿D',	0,	3,	0),
(2066,	'云梦县',	'﻿YunMengXian',	302,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2067,	'应城市',	'﻿YingChengShi',	302,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2068,	'安陆市',	'﻿AnLuShi',	302,	1,	0,	'',	'﻿A',	0,	3,	0),
(2069,	'汉川市',	'﻿HanChuanShi',	302,	1,	0,	'',	'﻿H',	0,	3,	0),
(2070,	'沙市区',	'﻿ShaShiQu',	303,	1,	0,	'',	'﻿S',	0,	3,	0),
(2071,	'荆州区',	'﻿JingZhouQu',	303,	1,	0,	'',	'﻿J',	0,	3,	0),
(2072,	'公安县',	'﻿GongAnXian',	303,	1,	0,	'',	'﻿G',	0,	3,	0),
(2073,	'监利县',	'﻿JianLiXian',	303,	1,	0,	'',	'﻿J',	0,	3,	0),
(2074,	'江陵县',	'﻿JiangLingXian',	303,	1,	0,	'',	'﻿J',	0,	3,	0),
(2075,	'石首市',	'﻿ShiShouShi',	303,	1,	0,	'',	'﻿S',	0,	3,	0),
(2076,	'洪湖市',	'﻿HongHuShi',	303,	1,	0,	'',	'﻿H',	0,	3,	0),
(2077,	'松滋市',	'﻿SongZiShi',	303,	1,	0,	'',	'﻿S',	0,	3,	0),
(2078,	'黄州区',	'﻿HuangZhouQu',	304,	1,	0,	'',	'﻿H',	0,	3,	0),
(2079,	'团风县',	'﻿TuanFengXian',	304,	1,	0,	'',	'﻿T',	0,	3,	0),
(2080,	'红安县',	'﻿HongAnXian',	304,	1,	0,	'',	'﻿H',	0,	3,	0),
(2081,	'罗田县',	'﻿LuoTianXian',	304,	1,	0,	'',	'﻿L',	0,	3,	0),
(2082,	'英山县',	'﻿YingShanXian',	304,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2083,	'浠水县',	'﻿XiShuiXian',	304,	1,	0,	'',	'﻿X',	0,	3,	0),
(2084,	'蕲春县',	'﻿QiChunXian',	304,	1,	0,	'',	'﻿Q',	0,	3,	0),
(2085,	'黄梅县',	'﻿HuangMeiXian',	304,	1,	0,	'',	'﻿H',	0,	3,	0),
(2086,	'麻城市',	'﻿MaChengShi',	304,	1,	0,	'',	'﻿M',	0,	3,	0),
(2087,	'武穴市',	'﻿WuXueShi',	304,	1,	0,	'',	'﻿W',	0,	3,	0),
(2088,	'咸安区',	'﻿XianAnQu',	305,	1,	0,	'',	'﻿X',	0,	3,	0),
(2089,	'嘉鱼县',	'﻿JiaYuXian',	305,	1,	0,	'',	'﻿J',	0,	3,	0),
(2090,	'通城县',	'﻿TongChengXian',	305,	1,	0,	'',	'﻿T',	0,	3,	0),
(2091,	'崇阳县',	'﻿ChongYangXian',	305,	1,	0,	'',	'﻿C',	0,	3,	0),
(2092,	'通山县',	'﻿TongShanXian',	305,	1,	0,	'',	'﻿T',	0,	3,	0),
(2093,	'赤壁市',	'﻿ChiBiShi',	305,	1,	0,	'',	'﻿C',	0,	3,	0),
(2094,	'曾都区',	'﻿ZengDuQu',	306,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2095,	'广水市',	'﻿GuangShuiShi',	306,	1,	0,	'',	'﻿G',	0,	3,	0),
(2096,	'恩施市',	'﻿EnShiShi',	307,	1,	0,	'',	'﻿E',	0,	3,	0),
(2097,	'利川市',	'﻿LiChuanShi',	307,	1,	0,	'',	'﻿L',	0,	3,	0),
(2098,	'建始县',	'﻿JianShiXian',	307,	1,	0,	'',	'﻿J',	0,	3,	0),
(2099,	'巴东县',	'﻿BaDongXian',	307,	1,	0,	'',	'﻿B',	0,	3,	0),
(2100,	'宣恩县',	'﻿XuanEnXian',	307,	1,	0,	'',	'﻿X',	0,	3,	0),
(2101,	'咸丰县',	'﻿XianFengXian',	307,	1,	0,	'',	'﻿X',	0,	3,	0),
(2102,	'来凤县',	'﻿LaiFengXian',	307,	1,	0,	'',	'﻿L',	0,	3,	0),
(2103,	'鹤峰县',	'﻿HeFengXian',	307,	1,	0,	'',	'﻿H',	0,	3,	0),
(2104,	'芙蓉区',	'﻿FuRongQu',	312,	1,	0,	'',	'﻿F',	0,	3,	0),
(2105,	'天心区',	'﻿TianXinQu',	312,	1,	0,	'',	'﻿T',	0,	3,	0),
(2106,	'岳麓区',	'﻿YueLuQu',	312,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2107,	'开福区',	'﻿KaiFuQu',	312,	1,	0,	'',	'﻿K',	0,	3,	0),
(2108,	'雨花区',	'﻿YuHuaQu',	312,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2109,	'长沙县',	'﻿ChangShaXian',	312,	1,	0,	'',	'﻿C',	0,	3,	0),
(2110,	'望城县',	'﻿WangChengXian',	312,	1,	0,	'',	'﻿W',	0,	3,	0),
(2111,	'宁乡县',	'﻿NingXiangXian',	312,	1,	0,	'',	'﻿N',	0,	3,	0),
(2112,	'浏阳市',	'﻿LiuYangShi',	312,	1,	0,	'',	'﻿L',	0,	3,	0),
(2113,	'荷塘区',	'﻿HeTangQu',	313,	1,	0,	'',	'﻿H',	0,	3,	0),
(2114,	'芦淞区',	'﻿LuSongQu',	313,	1,	0,	'',	'﻿L',	0,	3,	0),
(2115,	'石峰区',	'﻿ShiFengQu',	313,	1,	0,	'',	'﻿S',	0,	3,	0),
(2116,	'天元区',	'﻿TianYuanQu',	313,	1,	0,	'',	'﻿T',	0,	3,	0),
(2117,	'株洲县',	'﻿ZhuZhouXian',	313,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2118,	'攸县',	'﻿YouXian',	313,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2119,	'茶陵县',	'﻿ChaLingXian',	313,	1,	0,	'',	'﻿C',	0,	3,	0),
(2120,	'炎陵县',	'﻿YanLingXian',	313,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2121,	'醴陵市',	'﻿LiLingShi',	313,	1,	0,	'',	'﻿L',	0,	3,	0),
(2122,	'雨湖区',	'﻿YuHuQu',	314,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2123,	'岳塘区',	'﻿YueTangQu',	314,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2124,	'湘潭县',	'﻿XiangTanXian',	314,	1,	0,	'',	'﻿X',	0,	3,	0),
(2125,	'湘乡市',	'﻿XiangXiangShi',	314,	1,	0,	'',	'﻿X',	0,	3,	0),
(2126,	'韶山市',	'﻿ShaoShanShi',	314,	1,	0,	'',	'﻿S',	0,	3,	0),
(2127,	'珠晖区',	'﻿ZhuHuiQu',	315,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2128,	'雁峰区',	'﻿YanFengQu',	315,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2129,	'石鼓区',	'﻿ShiGuQu',	315,	1,	0,	'',	'﻿S',	0,	3,	0),
(2130,	'蒸湘区',	'﻿ZhengXiangQu',	315,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2131,	'南岳区',	'﻿NanYueQu',	315,	1,	0,	'',	'﻿N',	0,	3,	0),
(2132,	'衡阳县',	'﻿HengYangXian',	315,	1,	0,	'',	'﻿H',	0,	3,	0),
(2133,	'衡南县',	'﻿HengNanXian',	315,	1,	0,	'',	'﻿H',	0,	3,	0),
(2134,	'衡山县',	'﻿HengShanXian',	315,	1,	0,	'',	'﻿H',	0,	3,	0),
(2135,	'衡东县',	'﻿HengDongXian',	315,	1,	0,	'',	'﻿H',	0,	3,	0),
(2136,	'祁东县',	'﻿QiDongXian',	315,	1,	0,	'',	'﻿Q',	0,	3,	0),
(2137,	'耒阳市',	'﻿LeiYangShi',	315,	1,	0,	'',	'﻿L',	0,	3,	0),
(2138,	'常宁市',	'﻿ChangNingShi',	315,	1,	0,	'',	'﻿C',	0,	3,	0),
(2139,	'双清区',	'﻿ShuangQingQu',	316,	1,	0,	'',	'﻿S',	0,	3,	0),
(2140,	'大祥区',	'﻿DaXiangQu',	316,	1,	0,	'',	'﻿D',	0,	3,	0),
(2141,	'北塔区',	'﻿BeiTaQu',	316,	1,	0,	'',	'﻿B',	0,	3,	0),
(2142,	'邵东县',	'﻿ShaoDongXian',	316,	1,	0,	'',	'﻿S',	0,	3,	0),
(2143,	'新邵县',	'﻿XinShaoXian',	316,	1,	0,	'',	'﻿X',	0,	3,	0),
(2144,	'邵阳县',	'﻿ShaoYangXian',	316,	1,	0,	'',	'﻿S',	0,	3,	0),
(2145,	'隆回县',	'﻿LongHuiXian',	316,	1,	0,	'',	'﻿L',	0,	3,	0),
(2146,	'洞口县',	'﻿DongKouXian',	316,	1,	0,	'',	'﻿D',	0,	3,	0),
(2147,	'绥宁县',	'﻿SuiNingXian',	316,	1,	0,	'',	'﻿S',	0,	3,	0),
(2148,	'新宁县',	'﻿XinNingXian',	316,	1,	0,	'',	'﻿X',	0,	3,	0),
(2149,	'城步苗族自治县',	'﻿ChengBuMiaoZuZiZhiXian',	316,	1,	0,	'',	'﻿C',	0,	3,	0),
(2150,	'武冈市',	'﻿WuGangShi',	316,	1,	0,	'',	'﻿W',	0,	3,	0),
(2151,	'岳阳楼区',	'﻿YueYangLouQu',	317,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2152,	'云溪区',	'﻿YunXiQu',	317,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2153,	'君山区',	'﻿JunShanQu',	317,	1,	0,	'',	'﻿J',	0,	3,	0),
(2154,	'岳阳县',	'﻿YueYangXian',	317,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2155,	'华容县',	'﻿HuaRongXian',	317,	1,	0,	'',	'﻿H',	0,	3,	0),
(2156,	'湘阴县',	'﻿XiangYinXian',	317,	1,	0,	'',	'﻿X',	0,	3,	0),
(2157,	'平江县',	'﻿PingJiangXian',	317,	1,	0,	'',	'﻿P',	0,	3,	0),
(2158,	'汨罗市',	'﻿MiLuoShi',	317,	1,	0,	'',	'﻿M',	0,	3,	0),
(2159,	'临湘市',	'﻿LinXiangShi',	317,	1,	0,	'',	'﻿L',	0,	3,	0),
(2160,	'武陵区',	'﻿WuLingQu',	318,	1,	0,	'',	'﻿W',	0,	3,	0),
(2161,	'鼎城区',	'﻿DingChengQu',	318,	1,	0,	'',	'﻿D',	0,	3,	0),
(2162,	'安乡县',	'﻿AnXiangXian',	318,	1,	0,	'',	'﻿A',	0,	3,	0),
(2163,	'汉寿县',	'﻿HanShouXian',	318,	1,	0,	'',	'﻿H',	0,	3,	0),
(2164,	'澧县',	'﻿LiXian',	318,	1,	0,	'',	'﻿L',	0,	3,	0),
(2165,	'临澧县',	'﻿LinLiXian',	318,	1,	0,	'',	'﻿L',	0,	3,	0),
(2166,	'桃源县',	'﻿TaoYuanXian',	318,	1,	0,	'',	'﻿T',	0,	3,	0),
(2167,	'石门县',	'﻿ShiMenXian',	318,	1,	0,	'',	'﻿S',	0,	3,	0),
(2168,	'津市市',	'﻿JinShiShi',	318,	1,	0,	'',	'﻿J',	0,	3,	0),
(2169,	'永定区',	'﻿YongDingQu',	319,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2170,	'武陵源区',	'﻿WuLingYuanQu',	319,	1,	0,	'',	'﻿W',	0,	3,	0),
(2171,	'慈利县',	'﻿CiLiXian',	319,	1,	0,	'',	'﻿C',	0,	3,	0),
(2172,	'桑植县',	'﻿SangZhiXian',	319,	1,	0,	'',	'﻿S',	0,	3,	0),
(2173,	'资阳区',	'﻿ZiYangQu',	320,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2174,	'赫山区',	'﻿HeShanQu',	320,	1,	0,	'',	'﻿H',	0,	3,	0),
(2175,	'南县',	'﻿NanXian',	320,	1,	0,	'',	'﻿N',	0,	3,	0),
(2176,	'桃江县',	'﻿TaoJiangXian',	320,	1,	0,	'',	'﻿T',	0,	3,	0),
(2177,	'安化县',	'﻿AnHuaXian',	320,	1,	0,	'',	'﻿A',	0,	3,	0),
(2178,	'沅江市',	'﻿YuanJiangShi',	320,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2179,	'北湖区',	'﻿BeiHuQu',	321,	1,	0,	'',	'﻿B',	0,	3,	0),
(2180,	'苏仙区',	'﻿SuXianQu',	321,	1,	0,	'',	'﻿S',	0,	3,	0),
(2181,	'桂阳县',	'﻿GuiYangXian',	321,	1,	0,	'',	'﻿G',	0,	3,	0),
(2182,	'宜章县',	'﻿YiZhangXian',	321,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2183,	'永兴县',	'﻿YongXingXian',	321,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2184,	'嘉禾县',	'﻿JiaHeXian',	321,	1,	0,	'',	'﻿J',	0,	3,	0),
(2185,	'临武县',	'﻿LinWuXian',	321,	1,	0,	'',	'﻿L',	0,	3,	0),
(2186,	'汝城县',	'﻿RuChengXian',	321,	1,	0,	'',	'﻿R',	0,	3,	0),
(2187,	'桂东县',	'﻿GuiDongXian',	321,	1,	0,	'',	'﻿G',	0,	3,	0),
(2188,	'安仁县',	'﻿AnRenXian',	321,	1,	0,	'',	'﻿A',	0,	3,	0),
(2189,	'资兴市',	'﻿ZiXingShi',	321,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2190,	'零陵区',	'﻿LingLingQu',	322,	1,	0,	'',	'﻿L',	0,	3,	0),
(2191,	'冷水滩区',	'﻿LengShuiTanQu',	322,	1,	0,	'',	'﻿L',	0,	3,	0),
(2192,	'祁阳县',	'﻿QiYangXian',	322,	1,	0,	'',	'﻿Q',	0,	3,	0),
(2193,	'东安县',	'﻿DongAnXian',	322,	1,	0,	'',	'﻿D',	0,	3,	0),
(2194,	'双牌县',	'﻿ShuangPaiXian',	322,	1,	0,	'',	'﻿S',	0,	3,	0),
(2195,	'道县',	'﻿DaoXian',	322,	1,	0,	'',	'﻿D',	0,	3,	0),
(2196,	'江永县',	'﻿JiangYongXian',	322,	1,	0,	'',	'﻿J',	0,	3,	0),
(2197,	'宁远县',	'﻿NingYuanXian',	322,	1,	0,	'',	'﻿N',	0,	3,	0),
(2198,	'蓝山县',	'﻿LanShanXian',	322,	1,	0,	'',	'﻿L',	0,	3,	0),
(2199,	'新田县',	'﻿XinTianXian',	322,	1,	0,	'',	'﻿X',	0,	3,	0),
(2200,	'江华瑶族自治县',	'﻿JiangHuaYaoZuZiZhiXian',	322,	1,	0,	'',	'﻿J',	0,	3,	0),
(2201,	'鹤城区',	'﻿HeChengQu',	323,	1,	0,	'',	'﻿H',	0,	3,	0),
(2202,	'中方县',	'﻿ZhongFangXian',	323,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2203,	'沅陵县',	'﻿YuanLingXian',	323,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2204,	'辰溪县',	'﻿ChenXiXian',	323,	1,	0,	'',	'﻿C',	0,	3,	0),
(2205,	'溆浦县',	'﻿XuPuXian',	323,	1,	0,	'',	'﻿X',	0,	3,	0),
(2206,	'会同县',	'﻿HuiTongXian',	323,	1,	0,	'',	'﻿H',	0,	3,	0),
(2207,	'麻阳苗族自治县',	'﻿MaYangMiaoZuZiZhiXian',	323,	1,	0,	'',	'﻿M',	0,	3,	0),
(2208,	'新晃侗族自治县',	'﻿XinHuangDongZuZiZhiXian',	323,	1,	0,	'',	'﻿X',	0,	3,	0),
(2209,	'芷江侗族自治县',	'﻿ZhiJiangDongZuZiZhiXian',	323,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2210,	'靖州苗族侗族自治县',	'﻿JingZhouMiaoZuDongZuZiZhiXian',	323,	1,	0,	'',	'﻿J',	0,	3,	0),
(2211,	'通道侗族自治县',	'﻿TongDaoDongZuZiZhiXian',	323,	1,	0,	'',	'﻿T',	0,	3,	0),
(2212,	'洪江市',	'﻿HongJiangShi',	323,	1,	0,	'',	'﻿H',	0,	3,	0),
(2213,	'娄星区',	'﻿LouXingQu',	324,	1,	0,	'',	'﻿L',	0,	3,	0),
(2214,	'双峰县',	'﻿ShuangFengXian',	324,	1,	0,	'',	'﻿S',	0,	3,	0),
(2215,	'新化县',	'﻿XinHuaXian',	324,	1,	0,	'',	'﻿X',	0,	3,	0),
(2216,	'冷水江市',	'﻿LengShuiJiangShi',	324,	1,	0,	'',	'﻿L',	0,	3,	0),
(2217,	'涟源市',	'﻿LianYuanShi',	324,	1,	0,	'',	'﻿L',	0,	3,	0),
(2218,	'吉首市',	'﻿JiShouShi',	325,	1,	0,	'',	'﻿J',	0,	3,	0),
(2219,	'泸溪县',	'﻿LuXiXian',	325,	1,	0,	'',	'﻿L',	0,	3,	0),
(2220,	'凤凰县',	'﻿FengHuangXian',	325,	1,	0,	'',	'﻿F',	0,	3,	0),
(2221,	'花垣县',	'﻿HuaYuanXian',	325,	1,	0,	'',	'﻿H',	0,	3,	0),
(2222,	'保靖县',	'﻿BaoJingXian',	325,	1,	0,	'',	'﻿B',	0,	3,	0),
(2223,	'古丈县',	'﻿GuZhangXian',	325,	1,	0,	'',	'﻿G',	0,	3,	0),
(2224,	'永顺县',	'﻿YongShunXian',	325,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2225,	'龙山县',	'﻿LongShanXian',	325,	1,	0,	'',	'﻿L',	0,	3,	0),
(2226,	'荔湾区',	'﻿LiWanQu',	326,	1,	0,	'',	'﻿L',	0,	3,	0),
(2227,	'越秀区',	'﻿YueXiuQu',	326,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2228,	'海珠区',	'﻿HaiZhuQu',	326,	1,	0,	'',	'﻿H',	0,	3,	0),
(2229,	'天河区',	'﻿TianHeQu',	326,	1,	0,	'',	'﻿T',	0,	3,	0),
(2230,	'白云区',	'﻿BaiYunQu',	326,	1,	0,	'',	'﻿B',	0,	3,	0),
(2231,	'黄埔区',	'﻿HuangPuQu',	326,	1,	0,	'',	'﻿H',	0,	3,	0),
(2232,	'番禺区',	'﻿FanYuQu',	326,	1,	0,	'',	'﻿F',	0,	3,	0),
(2233,	'花都区',	'﻿HuaDuQu',	326,	1,	0,	'',	'﻿H',	0,	3,	0),
(2234,	'南沙区',	'﻿NanShaQu',	326,	1,	0,	'',	'﻿N',	0,	3,	0),
(2235,	'萝岗区',	'﻿LuoGangQu',	326,	1,	0,	'',	'﻿L',	0,	3,	0),
(2236,	'增城市',	'﻿ZengChengShi',	326,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2237,	'从化市',	'﻿CongHuaShi',	326,	1,	0,	'',	'﻿C',	0,	3,	0),
(2238,	'武江区',	'﻿WuJiangQu',	327,	1,	0,	'',	'﻿W',	0,	3,	0),
(2239,	'浈江区',	'﻿ZhenJiangQu',	327,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2240,	'曲江区',	'﻿QuJiangQu',	327,	1,	0,	'',	'﻿Q',	0,	3,	0),
(2241,	'始兴县',	'﻿ShiXingXian',	327,	1,	0,	'',	'﻿S',	0,	3,	0),
(2242,	'仁化县',	'﻿RenHuaXian',	327,	1,	0,	'',	'﻿R',	0,	3,	0),
(2243,	'翁源县',	'﻿WengYuanXian',	327,	1,	0,	'',	'﻿W',	0,	3,	0),
(2244,	'乳源瑶族自治县',	'﻿RuYuanYaoZuZiZhiXian',	327,	1,	0,	'',	'﻿R',	0,	3,	0),
(2245,	'新丰县',	'﻿XinFengXian',	327,	1,	0,	'',	'﻿X',	0,	3,	0),
(2246,	'乐昌市',	'﻿LeChangShi',	327,	1,	0,	'',	'﻿L',	0,	3,	0),
(2247,	'南雄市',	'﻿NanXiongShi',	327,	1,	0,	'',	'﻿N',	0,	3,	0),
(2248,	'罗湖区',	'﻿LuoHuQu',	328,	1,	0,	'',	'﻿L',	0,	3,	0),
(2249,	'福田区',	'﻿FuTianQu',	328,	1,	0,	'',	'﻿F',	0,	3,	0),
(2250,	'南山区',	'﻿NanShanQu',	328,	1,	0,	'',	'﻿N',	0,	3,	0),
(2251,	'宝安区',	'﻿BaoAnQu',	328,	1,	0,	'',	'﻿B',	0,	3,	0),
(2252,	'龙岗区',	'﻿LongGangQu',	328,	1,	0,	'',	'﻿L',	0,	3,	0),
(2253,	'盐田区',	'﻿YanTianQu',	328,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2254,	'香洲区',	'﻿XiangZhouQu',	329,	1,	0,	'',	'﻿X',	0,	3,	0),
(2255,	'斗门区',	'﻿DouMenQu',	329,	1,	0,	'',	'﻿D',	0,	3,	0),
(2256,	'金湾区',	'﻿JinWanQu',	329,	1,	0,	'',	'﻿J',	0,	3,	0),
(2257,	'龙湖区',	'﻿LongHuQu',	330,	1,	0,	'',	'﻿L',	0,	3,	0),
(2258,	'金平区',	'﻿JinPingQu',	330,	1,	0,	'',	'﻿J',	0,	3,	0),
(2259,	'濠江区',	'﻿HaoJiangQu',	330,	1,	0,	'',	'﻿H',	0,	3,	0),
(2260,	'潮阳区',	'﻿ChaoYangQu',	330,	1,	0,	'',	'﻿C',	0,	3,	0),
(2261,	'潮南区',	'﻿ChaoNanQu',	330,	1,	0,	'',	'﻿C',	0,	3,	0),
(2262,	'澄海区',	'﻿ChengHaiQu',	330,	1,	0,	'',	'﻿C',	0,	3,	0),
(2263,	'南澳县',	'﻿NanAoXian',	330,	1,	0,	'',	'﻿N',	0,	3,	0),
(2264,	'禅城区',	'﻿ChanChengQu',	331,	1,	0,	'',	'﻿C',	0,	3,	0),
(2265,	'南海区',	'﻿NanHaiQu',	331,	1,	0,	'',	'﻿N',	0,	3,	0),
(2266,	'顺德区',	'﻿ShunDeQu',	331,	1,	0,	'',	'﻿S',	0,	3,	0),
(2267,	'三水区',	'﻿SanShuiQu',	331,	1,	0,	'',	'﻿S',	0,	3,	0),
(2268,	'高明区',	'﻿GaoMingQu',	331,	1,	0,	'',	'﻿G',	0,	3,	0),
(2269,	'蓬江区',	'﻿PengJiangQu',	332,	1,	0,	'',	'﻿P',	0,	3,	0),
(2270,	'江海区',	'﻿JiangHaiQu',	332,	1,	0,	'',	'﻿J',	0,	3,	0),
(2271,	'新会区',	'﻿XinHuiQu',	332,	1,	0,	'',	'﻿X',	0,	3,	0),
(2272,	'台山市',	'﻿TaiShanShi',	332,	1,	0,	'',	'﻿T',	0,	3,	0),
(2273,	'开平市',	'﻿KaiPingShi',	332,	1,	0,	'',	'﻿K',	0,	3,	0),
(2274,	'鹤山市',	'﻿HeShanShi',	332,	1,	0,	'',	'﻿H',	0,	3,	0),
(2275,	'恩平市',	'﻿EnPingShi',	332,	1,	0,	'',	'﻿E',	0,	3,	0),
(2276,	'赤坎区',	'﻿ChiKanQu',	333,	1,	0,	'',	'﻿C',	0,	3,	0),
(2277,	'霞山区',	'﻿XiaShanQu',	333,	1,	0,	'',	'﻿X',	0,	3,	0),
(2278,	'坡头区',	'﻿PoTouQu',	333,	1,	0,	'',	'﻿P',	0,	3,	0),
(2279,	'麻章区',	'﻿MaZhangQu',	333,	1,	0,	'',	'﻿M',	0,	3,	0),
(2280,	'遂溪县',	'﻿SuiXiXian',	333,	1,	0,	'',	'﻿S',	0,	3,	0),
(2281,	'徐闻县',	'﻿XuWenXian',	333,	1,	0,	'',	'﻿X',	0,	3,	0),
(2282,	'廉江市',	'﻿LianJiangShi',	333,	1,	0,	'',	'﻿L',	0,	3,	0),
(2283,	'雷州市',	'﻿LeiZhouShi',	333,	1,	0,	'',	'﻿L',	0,	3,	0),
(2284,	'吴川市',	'﻿WuChuanShi',	333,	1,	0,	'',	'﻿W',	0,	3,	0),
(2285,	'茂南区',	'﻿MaoNanQu',	334,	1,	0,	'',	'﻿M',	0,	3,	0),
(2286,	'茂港区',	'﻿MaoGangQu',	334,	1,	0,	'',	'﻿M',	0,	3,	0),
(2287,	'电白县',	'﻿DianBaiXian',	334,	1,	0,	'',	'﻿D',	0,	3,	0),
(2288,	'高州市',	'﻿GaoZhouShi',	334,	1,	0,	'',	'﻿G',	0,	3,	0),
(2289,	'化州市',	'﻿HuaZhouShi',	334,	1,	0,	'',	'﻿H',	0,	3,	0),
(2290,	'信宜市',	'﻿XinYiShi',	334,	1,	0,	'',	'﻿X',	0,	3,	0),
(2291,	'端州区',	'﻿DuanZhouQu',	335,	1,	0,	'',	'﻿D',	0,	3,	0),
(2292,	'鼎湖区',	'﻿DingHuQu',	335,	1,	0,	'',	'﻿D',	0,	3,	0),
(2293,	'广宁县',	'﻿GuangNingXian',	335,	1,	0,	'',	'﻿G',	0,	3,	0),
(2294,	'怀集县',	'﻿HuaiJiXian',	335,	1,	0,	'',	'﻿H',	0,	3,	0),
(2295,	'封开县',	'﻿FengKaiXian',	335,	1,	0,	'',	'﻿F',	0,	3,	0),
(2296,	'德庆县',	'﻿DeQingXian',	335,	1,	0,	'',	'﻿D',	0,	3,	0),
(2297,	'高要市',	'﻿GaoYaoShi',	335,	1,	0,	'',	'﻿G',	0,	3,	0),
(2298,	'四会市',	'﻿SiHuiShi',	335,	1,	0,	'',	'﻿S',	0,	3,	0),
(2299,	'惠城区',	'﻿HuiChengQu',	336,	1,	0,	'',	'﻿H',	0,	3,	0),
(2300,	'惠阳区',	'﻿HuiYangQu',	336,	1,	0,	'',	'﻿H',	0,	3,	0),
(2301,	'博罗县',	'﻿BoLuoXian',	336,	1,	0,	'',	'﻿B',	0,	3,	0),
(2302,	'惠东县',	'﻿HuiDongXian',	336,	1,	0,	'',	'﻿H',	0,	3,	0),
(2303,	'龙门县',	'﻿LongMenXian',	336,	1,	0,	'',	'﻿L',	0,	3,	0),
(2304,	'梅江区',	'﻿MeiJiangQu',	337,	1,	0,	'',	'﻿M',	0,	3,	0),
(2305,	'梅县',	'﻿MeiXian',	337,	1,	0,	'',	'﻿M',	0,	3,	0),
(2306,	'大埔县',	'﻿DaPuXian',	337,	1,	0,	'',	'﻿D',	0,	3,	0),
(2307,	'丰顺县',	'﻿FengShunXian',	337,	1,	0,	'',	'﻿F',	0,	3,	0),
(2308,	'五华县',	'﻿WuHuaXian',	337,	1,	0,	'',	'﻿W',	0,	3,	0),
(2309,	'平远县',	'﻿PingYuanXian',	337,	1,	0,	'',	'﻿P',	0,	3,	0),
(2310,	'蕉岭县',	'﻿JiaoLingXian',	337,	1,	0,	'',	'﻿J',	0,	3,	0),
(2311,	'兴宁市',	'﻿XingNingShi',	337,	1,	0,	'',	'﻿X',	0,	3,	0),
(2312,	'城区',	'﻿ChengQu',	338,	1,	0,	'',	'﻿C',	0,	3,	0),
(2313,	'海丰县',	'﻿HaiFengXian',	338,	1,	0,	'',	'﻿H',	0,	3,	0),
(2314,	'陆河县',	'﻿LuHeXian',	338,	1,	0,	'',	'﻿L',	0,	3,	0),
(2315,	'陆丰市',	'﻿LuFengShi',	338,	1,	0,	'',	'﻿L',	0,	3,	0),
(2316,	'源城区',	'﻿YuanChengQu',	339,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2317,	'紫金县',	'﻿ZiJinXian',	339,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2318,	'龙川县',	'﻿LongChuanXian',	339,	1,	0,	'',	'﻿L',	0,	3,	0),
(2319,	'连平县',	'﻿LianPingXian',	339,	1,	0,	'',	'﻿L',	0,	3,	0),
(2320,	'和平县',	'﻿HePingXian',	339,	1,	0,	'',	'﻿H',	0,	3,	0),
(2321,	'东源县',	'﻿DongYuanXian',	339,	1,	0,	'',	'﻿D',	0,	3,	0),
(2322,	'江城区',	'﻿JiangChengQu',	340,	1,	0,	'',	'﻿J',	0,	3,	0),
(2323,	'阳西县',	'﻿YangXiXian',	340,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2324,	'阳东县',	'﻿YangDongXian',	340,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2325,	'阳春市',	'﻿YangChunShi',	340,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2326,	'清城区',	'﻿QingChengQu',	341,	1,	0,	'',	'﻿Q',	0,	3,	0),
(2327,	'佛冈县',	'﻿FoGangXian',	341,	1,	0,	'',	'﻿F',	0,	3,	0),
(2328,	'阳山县',	'﻿YangShanXian',	341,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2329,	'连山壮族瑶族自治县',	'﻿LianShanZhuangZuYaoZuZiZhiXian',	341,	1,	0,	'',	'﻿L',	0,	3,	0),
(2330,	'连南瑶族自治县',	'﻿LianNanYaoZuZiZhiXian',	341,	1,	0,	'',	'﻿L',	0,	3,	0),
(2331,	'清新县',	'﻿QingXinXian',	341,	1,	0,	'',	'﻿Q',	0,	3,	0),
(2332,	'英德市',	'﻿YingDeShi',	341,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2333,	'连州市',	'﻿LianZhouShi',	341,	1,	0,	'',	'﻿L',	0,	3,	0),
(2334,	'湘桥区',	'﻿XiangQiaoQu',	344,	1,	0,	'',	'﻿X',	0,	3,	0),
(2335,	'潮安县',	'﻿ChaoAnXian',	344,	1,	0,	'',	'﻿C',	0,	3,	0),
(2336,	'饶平县',	'﻿RaoPingXian',	344,	1,	0,	'',	'﻿R',	0,	3,	0),
(2337,	'榕城区',	'﻿RongChengQu',	345,	1,	0,	'',	'﻿R',	0,	3,	0),
(2338,	'揭东县',	'﻿JieDongXian',	345,	1,	0,	'',	'﻿J',	0,	3,	0),
(2339,	'揭西县',	'﻿JieXiXian',	345,	1,	0,	'',	'﻿J',	0,	3,	0),
(2340,	'惠来县',	'﻿HuiLaiXian',	345,	1,	0,	'',	'﻿H',	0,	3,	0),
(2341,	'普宁市',	'﻿PuNingShi',	345,	1,	0,	'',	'﻿P',	0,	3,	0),
(2342,	'云城区',	'﻿YunChengQu',	346,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2343,	'新兴县',	'﻿XinXingXian',	346,	1,	0,	'',	'﻿X',	0,	3,	0),
(2344,	'郁南县',	'﻿YuNanXian',	346,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2345,	'云安县',	'﻿YunAnXian',	346,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2346,	'罗定市',	'﻿LuoDingShi',	346,	1,	0,	'',	'﻿L',	0,	3,	0),
(2347,	'兴宁区',	'﻿XingNingQu',	347,	1,	0,	'',	'﻿X',	0,	3,	0),
(2348,	'青秀区',	'﻿QingXiuQu',	347,	1,	0,	'',	'﻿Q',	0,	3,	0),
(2349,	'江南区',	'﻿JiangNanQu',	347,	1,	0,	'',	'﻿J',	0,	3,	0),
(2350,	'西乡塘区',	'﻿XiXiangTangQu',	347,	1,	0,	'',	'﻿X',	0,	3,	0),
(2351,	'良庆区',	'﻿LiangQingQu',	347,	1,	0,	'',	'﻿L',	0,	3,	0),
(2352,	'邕宁区',	'﻿YongNingQu',	347,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2353,	'武鸣县',	'﻿WuMingXian',	347,	1,	0,	'',	'﻿W',	0,	3,	0),
(2354,	'隆安县',	'﻿LongAnXian',	347,	1,	0,	'',	'﻿L',	0,	3,	0),
(2355,	'马山县',	'﻿MaShanXian',	347,	1,	0,	'',	'﻿M',	0,	3,	0),
(2356,	'上林县',	'﻿ShangLinXian',	347,	1,	0,	'',	'﻿S',	0,	3,	0),
(2357,	'宾阳县',	'﻿BinYangXian',	347,	1,	0,	'',	'﻿B',	0,	3,	0),
(2358,	'横县',	'﻿HengXian',	347,	1,	0,	'',	'﻿H',	0,	3,	0),
(2359,	'城中区',	'﻿ChengZhongQu',	348,	1,	0,	'',	'﻿C',	0,	3,	0),
(2360,	'鱼峰区',	'﻿YuFengQu',	348,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2361,	'柳南区',	'﻿LiuNanQu',	348,	1,	0,	'',	'﻿L',	0,	3,	0),
(2362,	'柳北区',	'﻿LiuBeiQu',	348,	1,	0,	'',	'﻿L',	0,	3,	0),
(2363,	'柳江县',	'﻿LiuJiangXian',	348,	1,	0,	'',	'﻿L',	0,	3,	0),
(2364,	'柳城县',	'﻿LiuChengXian',	348,	1,	0,	'',	'﻿L',	0,	3,	0),
(2365,	'鹿寨县',	'﻿LuZhaiXian',	348,	1,	0,	'',	'﻿L',	0,	3,	0),
(2366,	'融安县',	'﻿RongAnXian',	348,	1,	0,	'',	'﻿R',	0,	3,	0),
(2367,	'融水苗族自治县',	'﻿RongShuiMiaoZuZiZhiXian',	348,	1,	0,	'',	'﻿R',	0,	3,	0),
(2368,	'三江侗族自治县',	'﻿SanJiangDongZuZiZhiXian',	348,	1,	0,	'',	'﻿S',	0,	3,	0),
(2369,	'秀峰区',	'﻿XiuFengQu',	349,	1,	0,	'',	'﻿X',	0,	3,	0),
(2370,	'叠彩区',	'﻿DieCaiQu',	349,	1,	0,	'',	'﻿D',	0,	3,	0),
(2371,	'象山区',	'﻿XiangShanQu',	349,	1,	0,	'',	'﻿X',	0,	3,	0),
(2372,	'七星区',	'﻿QiXingQu',	349,	1,	0,	'',	'﻿Q',	0,	3,	0),
(2373,	'雁山区',	'﻿YanShanQu',	349,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2374,	'阳朔县',	'﻿YangShuoXian',	349,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2375,	'临桂县',	'﻿LinGuiXian',	349,	1,	0,	'',	'﻿L',	0,	3,	0),
(2376,	'灵川县',	'﻿LingChuanXian',	349,	1,	0,	'',	'﻿L',	0,	3,	0),
(2377,	'全州县',	'﻿QuanZhouXian',	349,	1,	0,	'',	'﻿Q',	0,	3,	0),
(2378,	'兴安县',	'﻿XingAnXian',	349,	1,	0,	'',	'﻿X',	0,	3,	0),
(2379,	'永福县',	'﻿YongFuXian',	349,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2380,	'灌阳县',	'﻿GuanYangXian',	349,	1,	0,	'',	'﻿G',	0,	3,	0),
(2381,	'龙胜各族自治县',	'﻿LongShengGeZuZiZhiXian',	349,	1,	0,	'',	'﻿L',	0,	3,	0),
(2382,	'资源县',	'﻿ZiYuanXian',	349,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2383,	'平乐县',	'﻿PingLeXian',	349,	1,	0,	'',	'﻿P',	0,	3,	0),
(2384,	'荔蒲县',	'﻿LiPuXian',	349,	1,	0,	'',	'﻿L',	0,	3,	0),
(2385,	'恭城瑶族自治县',	'﻿GongChengYaoZuZiZhiXian',	349,	1,	0,	'',	'﻿G',	0,	3,	0),
(2386,	'万秀区',	'﻿WanXiuQu',	350,	1,	0,	'',	'﻿W',	0,	3,	0),
(2387,	'蝶山区',	'﻿DieShanQu',	350,	1,	0,	'',	'﻿D',	0,	3,	0),
(2388,	'长洲区',	'﻿ChangZhouQu',	350,	1,	0,	'',	'﻿C',	0,	3,	0),
(2389,	'苍梧县',	'﻿CangWuXian',	350,	1,	0,	'',	'﻿C',	0,	3,	0),
(2390,	'藤县',	'﻿TengXian',	350,	1,	0,	'',	'﻿T',	0,	3,	0),
(2391,	'蒙山县',	'﻿MengShanXian',	350,	1,	0,	'',	'﻿M',	0,	3,	0),
(2392,	'岑溪市',	'﻿CenXiShi',	350,	1,	0,	'',	'﻿C',	0,	3,	0),
(2393,	'海城区',	'﻿HaiChengQu',	351,	1,	0,	'',	'﻿H',	0,	3,	0),
(2394,	'银海区',	'﻿YinHaiQu',	351,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2395,	'铁山港区',	'﻿TieShanGangQu',	351,	1,	0,	'',	'﻿T',	0,	3,	0),
(2396,	'合浦县',	'﻿HePuXian',	351,	1,	0,	'',	'﻿H',	0,	3,	0),
(2397,	'港口区',	'﻿GangKouQu',	352,	1,	0,	'',	'﻿G',	0,	3,	0),
(2398,	'防城区',	'﻿FangChengQu',	352,	1,	0,	'',	'﻿F',	0,	3,	0),
(2399,	'上思县',	'﻿ShangSiXian',	352,	1,	0,	'',	'﻿S',	0,	3,	0),
(2400,	'东兴市',	'﻿DongXingShi',	352,	1,	0,	'',	'﻿D',	0,	3,	0),
(2401,	'钦南区',	'﻿QinNanQu',	353,	1,	0,	'',	'﻿Q',	0,	3,	0),
(2402,	'钦北区',	'﻿QinBeiQu',	353,	1,	0,	'',	'﻿Q',	0,	3,	0),
(2403,	'灵山县',	'﻿LingShanXian',	353,	1,	0,	'',	'﻿L',	0,	3,	0),
(2404,	'浦北县',	'﻿PuBeiXian',	353,	1,	0,	'',	'﻿P',	0,	3,	0),
(2405,	'港北区',	'﻿GangBeiQu',	354,	1,	0,	'',	'﻿G',	0,	3,	0),
(2406,	'港南区',	'﻿GangNanQu',	354,	1,	0,	'',	'﻿G',	0,	3,	0),
(2407,	'覃塘区',	'﻿TanTangQu',	354,	1,	0,	'',	'﻿T',	0,	3,	0),
(2408,	'平南县',	'﻿PingNanXian',	354,	1,	0,	'',	'﻿P',	0,	3,	0),
(2409,	'桂平市',	'﻿GuiPingShi',	354,	1,	0,	'',	'﻿G',	0,	3,	0),
(2410,	'玉州区',	'﻿YuZhouQu',	355,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2411,	'容县',	'﻿RongXian',	355,	1,	0,	'',	'﻿R',	0,	3,	0),
(2412,	'陆川县',	'﻿LuChuanXian',	355,	1,	0,	'',	'﻿L',	0,	3,	0),
(2413,	'博白县',	'﻿BoBaiXian',	355,	1,	0,	'',	'﻿B',	0,	3,	0),
(2414,	'兴业县',	'﻿XingYeXian',	355,	1,	0,	'',	'﻿X',	0,	3,	0),
(2415,	'北流市',	'﻿BeiLiuShi',	355,	1,	0,	'',	'﻿B',	0,	3,	0),
(2416,	'右江区',	'﻿YouJiangQu',	356,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2417,	'田阳县',	'﻿TianYangXian',	356,	1,	0,	'',	'﻿T',	0,	3,	0),
(2418,	'田东县',	'﻿TianDongXian',	356,	1,	0,	'',	'﻿T',	0,	3,	0),
(2419,	'平果县',	'﻿PingGuoXian',	356,	1,	0,	'',	'﻿P',	0,	3,	0),
(2420,	'德保县',	'﻿DeBaoXian',	356,	1,	0,	'',	'﻿D',	0,	3,	0),
(2421,	'靖西县',	'﻿JingXiXian',	356,	1,	0,	'',	'﻿J',	0,	3,	0),
(2422,	'那坡县',	'﻿NaPoXian',	356,	1,	0,	'',	'﻿N',	0,	3,	0),
(2423,	'凌云县',	'﻿LingYunXian',	356,	1,	0,	'',	'﻿L',	0,	3,	0),
(2424,	'乐业县',	'﻿LeYeXian',	356,	1,	0,	'',	'﻿L',	0,	3,	0),
(2425,	'田林县',	'﻿TianLinXian',	356,	1,	0,	'',	'﻿T',	0,	3,	0),
(2426,	'西林县',	'﻿XiLinXian',	356,	1,	0,	'',	'﻿X',	0,	3,	0),
(2427,	'隆林各族自治县',	'﻿LongLinGeZuZiZhiXian',	356,	1,	0,	'',	'﻿L',	0,	3,	0),
(2428,	'八步区',	'﻿BaBuQu',	357,	1,	0,	'',	'﻿B',	0,	3,	0),
(2429,	'昭平县',	'﻿ZhaoPingXian',	357,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2430,	'钟山县',	'﻿ZhongShanXian',	357,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2431,	'富川瑶族自治县',	'﻿FuChuanYaoZuZiZhiXian',	357,	1,	0,	'',	'﻿F',	0,	3,	0),
(2432,	'金城江区',	'﻿JinChengJiangQu',	358,	1,	0,	'',	'﻿J',	0,	3,	0),
(2433,	'南丹县',	'﻿NanDanXian',	358,	1,	0,	'',	'﻿N',	0,	3,	0),
(2434,	'天峨县',	'﻿TianEXian',	358,	1,	0,	'',	'﻿T',	0,	3,	0),
(2435,	'凤山县',	'﻿FengShanXian',	358,	1,	0,	'',	'﻿F',	0,	3,	0),
(2436,	'东兰县',	'﻿DongLanXian',	358,	1,	0,	'',	'﻿D',	0,	3,	0),
(2437,	'罗城仫佬族自治县',	'﻿LuoChengMuLaoZuZiZhiXian',	358,	1,	0,	'',	'﻿L',	0,	3,	0),
(2438,	'环江毛南族自治县',	'﻿HuanJiangMaoNanZuZiZhiXian',	358,	1,	0,	'',	'﻿H',	0,	3,	0),
(2439,	'巴马瑶族自治县',	'﻿BaMaYaoZuZiZhiXian',	358,	1,	0,	'',	'﻿B',	0,	3,	0),
(2440,	'都安瑶族自治县',	'﻿DuAnYaoZuZiZhiXian',	358,	1,	0,	'',	'﻿D',	0,	3,	0),
(2441,	'大化瑶族自治县',	'﻿DaHuaYaoZuZiZhiXian',	358,	1,	0,	'',	'﻿D',	0,	3,	0),
(2442,	'宜州市',	'﻿YiZhouShi',	358,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2443,	'兴宾区',	'﻿XingBinQu',	359,	1,	0,	'',	'﻿X',	0,	3,	0),
(2444,	'忻城县',	'﻿XinChengXian',	359,	1,	0,	'',	'﻿X',	0,	3,	0),
(2445,	'象州县',	'﻿XiangZhouXian',	359,	1,	0,	'',	'﻿X',	0,	3,	0),
(2446,	'武宣县',	'﻿WuXuanXian',	359,	1,	0,	'',	'﻿W',	0,	3,	0),
(2447,	'金秀瑶族自治县',	'﻿JinXiuYaoZuZiZhiXian',	359,	1,	0,	'',	'﻿J',	0,	3,	0),
(2448,	'合山市',	'﻿HeShanShi',	359,	1,	0,	'',	'﻿H',	0,	3,	0),
(2449,	'江洲区',	'﻿JiangZhouQu',	360,	1,	0,	'',	'﻿J',	0,	3,	0),
(2450,	'扶绥县',	'﻿FuSuiXian',	360,	1,	0,	'',	'﻿F',	0,	3,	0),
(2451,	'宁明县',	'﻿NingMingXian',	360,	1,	0,	'',	'﻿N',	0,	3,	0),
(2452,	'龙州县',	'﻿LongZhouXian',	360,	1,	0,	'',	'﻿L',	0,	3,	0),
(2453,	'大新县',	'﻿DaXinXian',	360,	1,	0,	'',	'﻿D',	0,	3,	0),
(2454,	'天等县',	'﻿TianDengXian',	360,	1,	0,	'',	'﻿T',	0,	3,	0),
(2455,	'凭祥市',	'﻿PingXiangShi',	360,	1,	0,	'',	'﻿P',	0,	3,	0),
(2456,	'秀英区',	'﻿XiuYingQu',	361,	1,	0,	'',	'﻿X',	0,	3,	0),
(2457,	'龙华区',	'﻿LongHuaQu',	361,	1,	0,	'',	'﻿L',	0,	3,	0),
(2458,	'琼山区',	'﻿QiongShanQu',	361,	1,	0,	'',	'﻿Q',	0,	3,	0),
(2459,	'美兰区',	'﻿MeiLanQu',	361,	1,	0,	'',	'﻿M',	0,	3,	0),
(2460,	'锦江区',	'﻿JinJiangQu',	382,	1,	0,	'',	'﻿J',	0,	3,	0),
(2461,	'青羊区',	'﻿QingYangQu',	382,	1,	0,	'',	'﻿Q',	0,	3,	0),
(2462,	'金牛区',	'﻿JinNiuQu',	382,	1,	0,	'',	'﻿J',	0,	3,	0),
(2463,	'武侯区',	'﻿WuHouQu',	382,	1,	0,	'',	'﻿W',	0,	3,	0),
(2464,	'成华区',	'﻿ChengHuaQu',	382,	1,	0,	'',	'﻿C',	0,	3,	0),
(2465,	'龙泉驿区',	'﻿LongQuanYiQu',	382,	1,	0,	'',	'﻿L',	0,	3,	0),
(2466,	'青白江区',	'﻿QingBaiJiangQu',	382,	1,	0,	'',	'﻿Q',	0,	3,	0),
(2467,	'新都区',	'﻿XinDuQu',	382,	1,	0,	'',	'﻿X',	0,	3,	0),
(2468,	'温江区',	'﻿WenJiangQu',	382,	1,	0,	'',	'﻿W',	0,	3,	0),
(2469,	'金堂县',	'﻿JinTangXian',	382,	1,	0,	'',	'﻿J',	0,	3,	0),
(2470,	'双流县',	'﻿ShuangLiuXian',	382,	1,	0,	'',	'﻿S',	0,	3,	0),
(2471,	'郫县',	'﻿PiXian',	382,	1,	0,	'',	'﻿P',	0,	3,	0),
(2472,	'大邑县',	'﻿DaYiXian',	382,	1,	0,	'',	'﻿D',	0,	3,	0),
(2473,	'蒲江县',	'﻿PuJiangXian',	382,	1,	0,	'',	'﻿P',	0,	3,	0),
(2474,	'新津县',	'﻿XinJinXian',	382,	1,	0,	'',	'﻿X',	0,	3,	0),
(2475,	'都江堰市',	'﻿DuJiangYanShi',	382,	1,	0,	'',	'﻿D',	0,	3,	0),
(2476,	'彭州市',	'﻿PengZhouShi',	382,	1,	0,	'',	'﻿P',	0,	3,	0),
(2477,	'邛崃市',	'﻿QiongLaiShi',	382,	1,	0,	'',	'﻿Q',	0,	3,	0),
(2478,	'崇州市',	'﻿ChongZhouShi',	382,	1,	0,	'',	'﻿C',	0,	3,	0),
(2479,	'自流井区',	'﻿ZiLiuJingQu',	383,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2480,	'贡井区',	'﻿GongJingQu',	383,	1,	0,	'',	'﻿G',	0,	3,	0),
(2481,	'大安区',	'﻿DaAnQu',	383,	1,	0,	'',	'﻿D',	0,	3,	0),
(2482,	'沿滩区',	'﻿YanTanQu',	383,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2483,	'荣县',	'﻿RongXian',	383,	1,	0,	'',	'﻿R',	0,	3,	0),
(2484,	'富顺县',	'﻿FuShunXian',	383,	1,	0,	'',	'﻿F',	0,	3,	0),
(2485,	'东区',	'﻿DongQu',	384,	1,	0,	'',	'﻿D',	0,	3,	0),
(2486,	'西区',	'﻿XiQu',	384,	1,	0,	'',	'﻿X',	0,	3,	0),
(2487,	'仁和区',	'﻿RenHeQu',	384,	1,	0,	'',	'﻿R',	0,	3,	0),
(2488,	'米易县',	'﻿MiYiXian',	384,	1,	0,	'',	'﻿M',	0,	3,	0),
(2489,	'盐边县',	'﻿YanBianXian',	384,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2490,	'江阳区',	'﻿JiangYangQu',	385,	1,	0,	'',	'﻿J',	0,	3,	0),
(2491,	'纳溪区',	'﻿NaXiQu',	385,	1,	0,	'',	'﻿N',	0,	3,	0),
(2492,	'龙马潭区',	'﻿LongMaTanQu',	385,	1,	0,	'',	'﻿L',	0,	3,	0),
(2493,	'泸县',	'﻿LuXian',	385,	1,	0,	'',	'﻿L',	0,	3,	0),
(2494,	'合江县',	'﻿HeJiangXian',	385,	1,	0,	'',	'﻿H',	0,	3,	0),
(2495,	'叙永县',	'﻿XuYongXian',	385,	1,	0,	'',	'﻿X',	0,	3,	0),
(2496,	'古蔺县',	'﻿GuLinXian',	385,	1,	0,	'',	'﻿G',	0,	3,	0),
(2497,	'旌阳区',	'﻿JingYangQu',	386,	1,	0,	'',	'﻿J',	0,	3,	0),
(2498,	'中江县',	'﻿ZhongJiangXian',	386,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2499,	'罗江县',	'﻿LuoJiangXian',	386,	1,	0,	'',	'﻿L',	0,	3,	0),
(2500,	'广汉市',	'﻿GuangHanShi',	386,	1,	0,	'',	'﻿G',	0,	3,	0),
(2501,	'什邡市',	'﻿ShiFangShi',	386,	1,	0,	'',	'﻿S',	0,	3,	0),
(2502,	'绵竹市',	'﻿MianZhuShi',	386,	1,	0,	'',	'﻿M',	0,	3,	0),
(2503,	'涪城区',	'﻿FuChengQu',	387,	1,	0,	'',	'﻿F',	0,	3,	0),
(2504,	'游仙区',	'﻿YouXianQu',	387,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2505,	'三台县',	'﻿SanTaiXian',	387,	1,	0,	'',	'﻿S',	0,	3,	0),
(2506,	'盐亭县',	'﻿YanTingXian',	387,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2507,	'安县',	'﻿AnXian',	387,	1,	0,	'',	'﻿A',	0,	3,	0),
(2508,	'梓潼县',	'﻿ZiTongXian',	387,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2509,	'北川羌族自治县',	'﻿BeiChuanQiangZuZiZhiXian',	387,	1,	0,	'',	'﻿B',	0,	3,	0),
(2510,	'平武县',	'﻿PingWuXian',	387,	1,	0,	'',	'﻿P',	0,	3,	0),
(2511,	'江油市',	'﻿JiangYouShi',	387,	1,	0,	'',	'﻿J',	0,	3,	0),
(2512,	'市中区',	'﻿ShiZhongQu',	388,	1,	0,	'',	'﻿S',	0,	3,	0),
(2513,	'元坝区',	'﻿YuanBaQu',	388,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2514,	'朝天区',	'﻿ZhaoTianQu',	388,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2515,	'旺苍县',	'﻿WangCangXian',	388,	1,	0,	'',	'﻿W',	0,	3,	0),
(2516,	'青川县',	'﻿QingChuanXian',	388,	1,	0,	'',	'﻿Q',	0,	3,	0),
(2517,	'剑阁县',	'﻿JianGeXian',	388,	1,	0,	'',	'﻿J',	0,	3,	0),
(2518,	'苍溪县',	'﻿CangXiXian',	388,	1,	0,	'',	'﻿C',	0,	3,	0),
(2519,	'船山区',	'﻿ChuanShanQu',	389,	1,	0,	'',	'﻿C',	0,	3,	0),
(2520,	'安居区',	'﻿AnJuQu',	389,	1,	0,	'',	'﻿A',	0,	3,	0),
(2521,	'蓬溪县',	'﻿PengXiXian',	389,	1,	0,	'',	'﻿P',	0,	3,	0),
(2522,	'射洪县',	'﻿SheHongXian',	389,	1,	0,	'',	'﻿S',	0,	3,	0),
(2523,	'大英县',	'﻿DaYingXian',	389,	1,	0,	'',	'﻿D',	0,	3,	0),
(2524,	'市中区',	'﻿ShiZhongQu',	390,	1,	0,	'',	'﻿S',	0,	3,	0),
(2525,	'东兴区',	'﻿DongXingQu',	390,	1,	0,	'',	'﻿D',	0,	3,	0),
(2526,	'威远县',	'﻿WeiYuanXian',	390,	1,	0,	'',	'﻿W',	0,	3,	0),
(2527,	'资中县',	'﻿ZiZhongXian',	390,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2528,	'隆昌县',	'﻿LongChangXian',	390,	1,	0,	'',	'﻿L',	0,	3,	0),
(2529,	'市中区',	'﻿ShiZhongQu',	391,	1,	0,	'',	'﻿S',	0,	3,	0),
(2530,	'沙湾区',	'﻿ShaWanQu',	391,	1,	0,	'',	'﻿S',	0,	3,	0),
(2531,	'五通桥区',	'﻿WuTongQiaoQu',	391,	1,	0,	'',	'﻿W',	0,	3,	0),
(2532,	'金口河区',	'﻿JinKouHeQu',	391,	1,	0,	'',	'﻿J',	0,	3,	0),
(2533,	'犍为县',	'﻿JianWeiXian',	391,	1,	0,	'',	'﻿J',	0,	3,	0),
(2534,	'井研县',	'﻿JingYanXian',	391,	1,	0,	'',	'﻿J',	0,	3,	0),
(2535,	'夹江县',	'﻿JiaJiangXian',	391,	1,	0,	'',	'﻿J',	0,	3,	0),
(2536,	'沐川县',	'﻿MuChuanXian',	391,	1,	0,	'',	'﻿M',	0,	3,	0),
(2537,	'峨边彝族自治县',	'﻿EBianYiZuZiZhiXian',	391,	1,	0,	'',	'﻿E',	0,	3,	0),
(2538,	'马边彝族自治县',	'﻿MaBianYiZuZiZhiXian',	391,	1,	0,	'',	'﻿M',	0,	3,	0),
(2539,	'峨眉山市',	'﻿EMeiShanShi',	391,	1,	0,	'',	'﻿E',	0,	3,	0),
(2540,	'顺庆区',	'﻿ShunQingQu',	392,	1,	0,	'',	'﻿S',	0,	3,	0),
(2541,	'高坪区',	'﻿GaoPingQu',	392,	1,	0,	'',	'﻿G',	0,	3,	0),
(2542,	'嘉陵区',	'﻿JiaLingQu',	392,	1,	0,	'',	'﻿J',	0,	3,	0),
(2543,	'南部县',	'﻿NanBuXian',	392,	1,	0,	'',	'﻿N',	0,	3,	0),
(2544,	'营山县',	'﻿YingShanXian',	392,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2545,	'蓬安县',	'﻿PengAnXian',	392,	1,	0,	'',	'﻿P',	0,	3,	0),
(2546,	'仪陇县',	'﻿YiLongXian',	392,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2547,	'西充县',	'﻿XiChongXian',	392,	1,	0,	'',	'﻿X',	0,	3,	0),
(2548,	'阆中市',	'﻿LangZhongShi',	392,	1,	0,	'',	'﻿L',	0,	3,	0),
(2549,	'东坡区',	'﻿DongPoQu',	393,	1,	0,	'',	'﻿D',	0,	3,	0),
(2550,	'仁寿县',	'﻿RenShouXian',	393,	1,	0,	'',	'﻿R',	0,	3,	0),
(2551,	'彭山县',	'﻿PengShanXian',	393,	1,	0,	'',	'﻿P',	0,	3,	0),
(2552,	'洪雅县',	'﻿HongYaXian',	393,	1,	0,	'',	'﻿H',	0,	3,	0),
(2553,	'丹棱县',	'﻿DanLengXian',	393,	1,	0,	'',	'﻿D',	0,	3,	0),
(2554,	'青神县',	'﻿QingShenXian',	393,	1,	0,	'',	'﻿Q',	0,	3,	0),
(2555,	'翠屏区',	'﻿CuiPingQu',	394,	1,	0,	'',	'﻿C',	0,	3,	0),
(2556,	'宜宾县',	'﻿YiBinXian',	394,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2557,	'南溪县',	'﻿NanXiXian',	394,	1,	0,	'',	'﻿N',	0,	3,	0),
(2558,	'江安县',	'﻿JiangAnXian',	394,	1,	0,	'',	'﻿J',	0,	3,	0),
(2559,	'长宁县',	'﻿ChangNingXian',	394,	1,	0,	'',	'﻿C',	0,	3,	0),
(2560,	'高县',	'﻿GaoXian',	394,	1,	0,	'',	'﻿G',	0,	3,	0),
(2561,	'珙县',	'﻿GongXian',	394,	1,	0,	'',	'﻿G',	0,	3,	0),
(2562,	'筠连县',	'﻿YunLianXian',	394,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2563,	'兴文县',	'﻿XingWenXian',	394,	1,	0,	'',	'﻿X',	0,	3,	0),
(2564,	'屏山县',	'﻿PingShanXian',	394,	1,	0,	'',	'﻿P',	0,	3,	0),
(2565,	'广安区',	'﻿GuangAnQu',	395,	1,	0,	'',	'﻿G',	0,	3,	0),
(2566,	'岳池县',	'﻿YueChiXian',	395,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2567,	'武胜县',	'﻿WuShengXian',	395,	1,	0,	'',	'﻿W',	0,	3,	0),
(2568,	'邻水县',	'﻿LinShuiXian',	395,	1,	0,	'',	'﻿L',	0,	3,	0),
(2569,	'华蓥市',	'﻿HuaYingShi',	395,	1,	0,	'',	'﻿H',	0,	3,	0),
(2570,	'通川区',	'﻿TongChuanQu',	396,	1,	0,	'',	'﻿T',	0,	3,	0),
(2571,	'达县',	'﻿DaXian',	396,	1,	0,	'',	'﻿D',	0,	3,	0),
(2572,	'宣汉县',	'﻿XuanHanXian',	396,	1,	0,	'',	'﻿X',	0,	3,	0),
(2573,	'开江县',	'﻿KaiJiangXian',	396,	1,	0,	'',	'﻿K',	0,	3,	0),
(2574,	'大竹县',	'﻿DaZhuXian',	396,	1,	0,	'',	'﻿D',	0,	3,	0),
(2575,	'渠县',	'﻿QuXian',	396,	1,	0,	'',	'﻿Q',	0,	3,	0),
(2576,	'万源市',	'﻿WanYuanShi',	396,	1,	0,	'',	'﻿W',	0,	3,	0),
(2577,	'雨城区',	'﻿YuChengQu',	397,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2578,	'名山县',	'﻿MingShanXian',	397,	1,	0,	'',	'﻿M',	0,	3,	0),
(2579,	'荥经县',	'﻿XingJingXian',	397,	1,	0,	'',	'﻿X',	0,	3,	0),
(2580,	'汉源县',	'﻿HanYuanXian',	397,	1,	0,	'',	'﻿H',	0,	3,	0),
(2581,	'石棉县',	'﻿ShiMianXian',	397,	1,	0,	'',	'﻿S',	0,	3,	0),
(2582,	'天全县',	'﻿TianQuanXian',	397,	1,	0,	'',	'﻿T',	0,	3,	0),
(2583,	'芦山县',	'﻿LuShanXian',	397,	1,	0,	'',	'﻿L',	0,	3,	0),
(2584,	'宝兴县',	'﻿BaoXingXian',	397,	1,	0,	'',	'﻿B',	0,	3,	0),
(2585,	'巴州区',	'﻿BaZhouQu',	398,	1,	0,	'',	'﻿B',	0,	3,	0),
(2586,	'通江县',	'﻿TongJiangXian',	398,	1,	0,	'',	'﻿T',	0,	3,	0),
(2587,	'南江县',	'﻿NanJiangXian',	398,	1,	0,	'',	'﻿N',	0,	3,	0),
(2588,	'平昌县',	'﻿PingChangXian',	398,	1,	0,	'',	'﻿P',	0,	3,	0),
(2589,	'雁江区',	'﻿YanJiangQu',	399,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2590,	'安岳县',	'﻿AnYueXian',	399,	1,	0,	'',	'﻿A',	0,	3,	0),
(2591,	'乐至县',	'﻿LeZhiXian',	399,	1,	0,	'',	'﻿L',	0,	3,	0),
(2592,	'简阳市',	'﻿JianYangShi',	399,	1,	0,	'',	'﻿J',	0,	3,	0),
(2593,	'汶川县',	'﻿WenChuanXian',	400,	1,	0,	'',	'﻿W',	0,	3,	0),
(2594,	'理县',	'﻿LiXian',	400,	1,	0,	'',	'﻿L',	0,	3,	0),
(2595,	'茂县',	'﻿MaoXian',	400,	1,	0,	'',	'﻿M',	0,	3,	0),
(2596,	'松潘县',	'﻿SongPanXian',	400,	1,	0,	'',	'﻿S',	0,	3,	0),
(2597,	'九寨沟县',	'﻿JiuZhaiGouXian',	400,	1,	0,	'',	'﻿J',	0,	3,	0),
(2598,	'金川县',	'﻿JinChuanXian',	400,	1,	0,	'',	'﻿J',	0,	3,	0),
(2599,	'小金县',	'﻿XiaoJinXian',	400,	1,	0,	'',	'﻿X',	0,	3,	0),
(2600,	'黑水县',	'﻿HeiShuiXian',	400,	1,	0,	'',	'﻿H',	0,	3,	0),
(2601,	'马尔康县',	'﻿MaErKangXian',	400,	1,	0,	'',	'﻿M',	0,	3,	0),
(2602,	'壤塘县',	'﻿RangTangXian',	400,	1,	0,	'',	'﻿R',	0,	3,	0),
(2603,	'阿坝县',	'﻿ABaXian',	400,	1,	0,	'',	'﻿A',	0,	3,	0),
(2604,	'若尔盖县',	'﻿RuoErGaiXian',	400,	1,	0,	'',	'﻿R',	0,	3,	0),
(2605,	'红原县',	'﻿HongYuanXian',	400,	1,	0,	'',	'﻿H',	0,	3,	0),
(2606,	'康定县',	'﻿KangDingXian',	401,	1,	0,	'',	'﻿K',	0,	3,	0),
(2607,	'泸定县',	'﻿LuDingXian',	401,	1,	0,	'',	'﻿L',	0,	3,	0),
(2608,	'丹巴县',	'﻿DanBaXian',	401,	1,	0,	'',	'﻿D',	0,	3,	0),
(2609,	'九龙县',	'﻿JiuLongXian',	401,	1,	0,	'',	'﻿J',	0,	3,	0),
(2610,	'雅江县',	'﻿YaJiangXian',	401,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2611,	'道孚县',	'﻿DaoFuXian',	401,	1,	0,	'',	'﻿D',	0,	3,	0),
(2612,	'炉霍县',	'﻿LuHuoXian',	401,	1,	0,	'',	'﻿L',	0,	3,	0),
(2613,	'甘孜县',	'﻿GanZiXian',	401,	1,	0,	'',	'﻿G',	0,	3,	0),
(2614,	'新龙县',	'﻿XinLongXian',	401,	1,	0,	'',	'﻿X',	0,	3,	0),
(2615,	'德格县',	'﻿DeGeXian',	401,	1,	0,	'',	'﻿D',	0,	3,	0),
(2616,	'白玉县',	'﻿BaiYuXian',	401,	1,	0,	'',	'﻿B',	0,	3,	0),
(2617,	'石渠县',	'﻿ShiQuXian',	401,	1,	0,	'',	'﻿S',	0,	3,	0),
(2618,	'色达县',	'﻿SeDaXian',	401,	1,	0,	'',	'﻿S',	0,	3,	0),
(2619,	'理塘县',	'﻿LiTangXian',	401,	1,	0,	'',	'﻿L',	0,	3,	0),
(2620,	'巴塘县',	'﻿BaTangXian',	401,	1,	0,	'',	'﻿B',	0,	3,	0),
(2621,	'乡城县',	'﻿XiangChengXian',	401,	1,	0,	'',	'﻿X',	0,	3,	0),
(2622,	'稻城县',	'﻿DaoChengXian',	401,	1,	0,	'',	'﻿D',	0,	3,	0),
(2623,	'得荣县',	'﻿DeRongXian',	401,	1,	0,	'',	'﻿D',	0,	3,	0),
(2624,	'西昌市',	'﻿XiChangShi',	402,	1,	0,	'',	'﻿X',	0,	3,	0),
(2625,	'木里藏族自治县',	'﻿MuLiCangZuZiZhiXian',	402,	1,	0,	'',	'﻿M',	0,	3,	0),
(2626,	'盐源县',	'﻿YanYuanXian',	402,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2627,	'德昌县',	'﻿DeChangXian',	402,	1,	0,	'',	'﻿D',	0,	3,	0),
(2628,	'会理县',	'﻿HuiLiXian',	402,	1,	0,	'',	'﻿H',	0,	3,	0),
(2629,	'会东县',	'﻿HuiDongXian',	402,	1,	0,	'',	'﻿H',	0,	3,	0),
(2630,	'宁南县',	'﻿NingNanXian',	402,	1,	0,	'',	'﻿N',	0,	3,	0),
(2631,	'普格县',	'﻿PuGeXian',	402,	1,	0,	'',	'﻿P',	0,	3,	0),
(2632,	'布拖县',	'﻿BuTuoXian',	402,	1,	0,	'',	'﻿B',	0,	3,	0),
(2633,	'金阳县',	'﻿JinYangXian',	402,	1,	0,	'',	'﻿J',	0,	3,	0),
(2634,	'昭觉县',	'﻿ZhaoJueXian',	402,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2635,	'喜德县',	'﻿XiDeXian',	402,	1,	0,	'',	'﻿X',	0,	3,	0),
(2636,	'冕宁县',	'﻿MianNingXian',	402,	1,	0,	'',	'﻿M',	0,	3,	0),
(2637,	'越西县',	'﻿YueXiXian',	402,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2638,	'甘洛县',	'﻿GanLuoXian',	402,	1,	0,	'',	'﻿G',	0,	3,	0),
(2639,	'美姑县',	'﻿MeiGuXian',	402,	1,	0,	'',	'﻿M',	0,	3,	0),
(2640,	'雷波县',	'﻿LeiBoXian',	402,	1,	0,	'',	'﻿L',	0,	3,	0),
(2641,	'南明区',	'﻿NanMingQu',	403,	1,	0,	'',	'﻿N',	0,	3,	0),
(2642,	'云岩区',	'﻿YunYanQu',	403,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2643,	'花溪区',	'﻿HuaXiQu',	403,	1,	0,	'',	'﻿H',	0,	3,	0),
(2644,	'乌当区',	'﻿WuDangQu',	403,	1,	0,	'',	'﻿W',	0,	3,	0),
(2645,	'白云区',	'﻿BaiYunQu',	403,	1,	0,	'',	'﻿B',	0,	3,	0),
(2646,	'小河区',	'﻿XiaoHeQu',	403,	1,	0,	'',	'﻿X',	0,	3,	0),
(2647,	'开阳县',	'﻿KaiYangXian',	403,	1,	0,	'',	'﻿K',	0,	3,	0),
(2648,	'息烽县',	'﻿XiFengXian',	403,	1,	0,	'',	'﻿X',	0,	3,	0),
(2649,	'修文县',	'﻿XiuWenXian',	403,	1,	0,	'',	'﻿X',	0,	3,	0),
(2650,	'清镇市',	'﻿QingZhenShi',	403,	1,	0,	'',	'﻿Q',	0,	3,	0),
(2651,	'钟山区',	'﻿ZhongShanQu',	404,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2652,	'六枝特区',	'﻿LiuZhiTeQu',	404,	1,	0,	'',	'﻿L',	0,	3,	0),
(2653,	'水城县',	'﻿ShuiChengXian',	404,	1,	0,	'',	'﻿S',	0,	3,	0),
(2654,	'盘县',	'﻿PanXian',	404,	1,	0,	'',	'﻿P',	0,	3,	0),
(2655,	'红花岗区',	'﻿HongHuaGangQu',	405,	1,	0,	'',	'﻿H',	0,	3,	0),
(2656,	'汇川区',	'﻿HuiChuanQu',	405,	1,	0,	'',	'﻿H',	0,	3,	0),
(2657,	'遵义县',	'﻿ZunYiXian',	405,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2658,	'桐梓县',	'﻿TongZiXian',	405,	1,	0,	'',	'﻿T',	0,	3,	0),
(2659,	'绥阳县',	'﻿SuiYangXian',	405,	1,	0,	'',	'﻿S',	0,	3,	0),
(2660,	'正安县',	'﻿ZhengAnXian',	405,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2661,	'道真仡佬族苗族自治县',	'﻿DaoZhenYiLaoZuMiaoZuZiZhiXian',	405,	1,	0,	'',	'﻿D',	0,	3,	0),
(2662,	'务川仡佬族苗族自治县',	'﻿WuChuanYiLaoZuMiaoZuZiZhiXian',	405,	1,	0,	'',	'﻿W',	0,	3,	0),
(2663,	'凤冈县',	'﻿FengGangXian',	405,	1,	0,	'',	'﻿F',	0,	3,	0),
(2664,	'湄潭县',	'﻿MeiTanXian',	405,	1,	0,	'',	'﻿M',	0,	3,	0),
(2665,	'余庆县',	'﻿YuQingXian',	405,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2666,	'习水县',	'﻿XiShuiXian',	405,	1,	0,	'',	'﻿X',	0,	3,	0),
(2667,	'赤水市',	'﻿ChiShuiShi',	405,	1,	0,	'',	'﻿C',	0,	3,	0),
(2668,	'仁怀市',	'﻿RenHuaiShi',	405,	1,	0,	'',	'﻿R',	0,	3,	0),
(2669,	'西秀区',	'﻿XiXiuQu',	406,	1,	0,	'',	'﻿X',	0,	3,	0),
(2670,	'平坝县',	'﻿PingBaXian',	406,	1,	0,	'',	'﻿P',	0,	3,	0),
(2671,	'普定县',	'﻿PuDingXian',	406,	1,	0,	'',	'﻿P',	0,	3,	0),
(2672,	'镇宁布依族苗族自治县',	'﻿ZhenNingBuYiZuMiaoZuZiZhiXian',	406,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2673,	'关岭布依族苗族自治县',	'﻿GuanLingBuYiZuMiaoZuZiZhiXian',	406,	1,	0,	'',	'﻿G',	0,	3,	0),
(2674,	'紫云苗族布依族自治县',	'﻿ZiYunMiaoZuBuYiZuZiZhiXian',	406,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2675,	'铜仁市',	'﻿TongRenShi',	407,	1,	0,	'',	'﻿T',	0,	3,	0),
(2676,	'江口县',	'﻿JiangKouXian',	407,	1,	0,	'',	'﻿J',	0,	3,	0),
(2677,	'玉屏侗族自治县',	'﻿YuPingDongZuZiZhiXian',	407,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2678,	'石阡县',	'﻿ShiQianXian',	407,	1,	0,	'',	'﻿S',	0,	3,	0),
(2679,	'思南县',	'﻿SiNanXian',	407,	1,	0,	'',	'﻿S',	0,	3,	0),
(2680,	'印江土家族苗族自治县',	'﻿YinJiangTuJiaZuMiaoZuZiZhiXian',	407,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2681,	'德江县',	'﻿DeJiangXian',	407,	1,	0,	'',	'﻿D',	0,	3,	0),
(2682,	'沿河土家族自治县',	'﻿YanHeTuJiaZuZiZhiXian',	407,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2683,	'松桃苗族自治县',	'﻿SongTaoMiaoZuZiZhiXian',	407,	1,	0,	'',	'﻿S',	0,	3,	0),
(2684,	'万山特区',	'﻿WanShanTeQu',	407,	1,	0,	'',	'﻿W',	0,	3,	0),
(2685,	'兴义市',	'﻿XingYiShi',	408,	1,	0,	'',	'﻿X',	0,	3,	0),
(2686,	'兴仁县',	'﻿XingRenXian',	408,	1,	0,	'',	'﻿X',	0,	3,	0),
(2687,	'普安县',	'﻿PuAnXian',	408,	1,	0,	'',	'﻿P',	0,	3,	0),
(2688,	'晴隆县',	'﻿QingLongXian',	408,	1,	0,	'',	'﻿Q',	0,	3,	0),
(2689,	'贞丰县',	'﻿ZhenFengXian',	408,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2690,	'望谟县',	'﻿WangMoXian',	408,	1,	0,	'',	'﻿W',	0,	3,	0),
(2691,	'册亨县',	'﻿CeHengXian',	408,	1,	0,	'',	'﻿C',	0,	3,	0),
(2692,	'安龙县',	'﻿AnLongXian',	408,	1,	0,	'',	'﻿A',	0,	3,	0),
(2693,	'毕节市',	'﻿BiJieShi',	409,	1,	0,	'',	'﻿B',	0,	3,	0),
(2694,	'大方县',	'﻿DaFangXian',	409,	1,	0,	'',	'﻿D',	0,	3,	0),
(2695,	'黔西县',	'﻿QianXiXian',	409,	1,	0,	'',	'﻿Q',	0,	3,	0),
(2696,	'金沙县',	'﻿JinShaXian',	409,	1,	0,	'',	'﻿J',	0,	3,	0),
(2697,	'织金县',	'﻿ZhiJinXian',	409,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2698,	'纳雍县',	'﻿NaYongXian',	409,	1,	0,	'',	'﻿N',	0,	3,	0),
(2699,	'威宁彝族回族苗族自治县',	'﻿WeiNingYiZuHuiZuMiaoZuZiZhiXian',	409,	1,	0,	'',	'﻿W',	0,	3,	0),
(2700,	'赫章县',	'﻿HeZhangXian',	409,	1,	0,	'',	'﻿H',	0,	3,	0),
(2701,	'凯里市',	'﻿KaiLiShi',	410,	1,	0,	'',	'﻿K',	0,	3,	0),
(2702,	'黄平县',	'﻿HuangPingXian',	410,	1,	0,	'',	'﻿H',	0,	3,	0),
(2703,	'施秉县',	'﻿ShiBingXian',	410,	1,	0,	'',	'﻿S',	0,	3,	0),
(2704,	'三穗县',	'﻿SanSuiXian',	410,	1,	0,	'',	'﻿S',	0,	3,	0),
(2705,	'镇远县',	'﻿ZhenYuanXian',	410,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2706,	'岑巩县',	'﻿CenGongXian',	410,	1,	0,	'',	'﻿C',	0,	3,	0),
(2707,	'天柱县',	'﻿TianZhuXian',	410,	1,	0,	'',	'﻿T',	0,	3,	0),
(2708,	'锦屏县',	'﻿JinPingXian',	410,	1,	0,	'',	'﻿J',	0,	3,	0),
(2709,	'剑河县',	'﻿JianHeXian',	410,	1,	0,	'',	'﻿J',	0,	3,	0),
(2710,	'台江县',	'﻿TaiJiangXian',	410,	1,	0,	'',	'﻿T',	0,	3,	0),
(2711,	'黎平县',	'﻿LiPingXian',	410,	1,	0,	'',	'﻿L',	0,	3,	0),
(2712,	'榕江县',	'﻿RongJiangXian',	410,	1,	0,	'',	'﻿R',	0,	3,	0),
(2713,	'从江县',	'﻿CongJiangXian',	410,	1,	0,	'',	'﻿C',	0,	3,	0),
(2714,	'雷山县',	'﻿LeiShanXian',	410,	1,	0,	'',	'﻿L',	0,	3,	0),
(2715,	'麻江县',	'﻿MaJiangXian',	410,	1,	0,	'',	'﻿M',	0,	3,	0),
(2716,	'丹寨县',	'﻿DanZhaiXian',	410,	1,	0,	'',	'﻿D',	0,	3,	0),
(2717,	'都匀市',	'﻿DuYunShi',	411,	1,	0,	'',	'﻿D',	0,	3,	0),
(2718,	'福泉市',	'﻿FuQuanShi',	411,	1,	0,	'',	'﻿F',	0,	3,	0),
(2719,	'荔波县',	'﻿LiBoXian',	411,	1,	0,	'',	'﻿L',	0,	3,	0),
(2720,	'贵定县',	'﻿GuiDingXian',	411,	1,	0,	'',	'﻿G',	0,	3,	0),
(2721,	'瓮安县',	'﻿WengAnXian',	411,	1,	0,	'',	'﻿W',	0,	3,	0),
(2722,	'独山县',	'﻿DuShanXian',	411,	1,	0,	'',	'﻿D',	0,	3,	0),
(2723,	'平塘县',	'﻿PingTangXian',	411,	1,	0,	'',	'﻿P',	0,	3,	0),
(2724,	'罗甸县',	'﻿LuoDianXian',	411,	1,	0,	'',	'﻿L',	0,	3,	0),
(2725,	'长顺县',	'﻿ChangShunXian',	411,	1,	0,	'',	'﻿C',	0,	3,	0),
(2726,	'龙里县',	'﻿LongLiXian',	411,	1,	0,	'',	'﻿L',	0,	3,	0),
(2727,	'惠水县',	'﻿HuiShuiXian',	411,	1,	0,	'',	'﻿H',	0,	3,	0),
(2728,	'三都水族自治县',	'﻿SanDuShuiZuZiZhiXian',	411,	1,	0,	'',	'﻿S',	0,	3,	0),
(2729,	'五华区',	'﻿WuHuaQu',	412,	1,	0,	'',	'﻿W',	0,	3,	0),
(2730,	'盘龙区',	'﻿PanLongQu',	412,	1,	0,	'',	'﻿P',	0,	3,	0),
(2731,	'官渡区',	'﻿GuanDuQu',	412,	1,	0,	'',	'﻿G',	0,	3,	0),
(2732,	'西山区',	'﻿XiShanQu',	412,	1,	0,	'',	'﻿X',	0,	3,	0),
(2733,	'东川区',	'﻿DongChuanQu',	412,	1,	0,	'',	'﻿D',	0,	3,	0),
(2734,	'呈贡县',	'﻿ChengGongXian',	412,	1,	0,	'',	'﻿C',	0,	3,	0),
(2735,	'晋宁县',	'﻿JinNingXian',	412,	1,	0,	'',	'﻿J',	0,	3,	0),
(2736,	'富民县',	'﻿FuMinXian',	412,	1,	0,	'',	'﻿F',	0,	3,	0),
(2737,	'宜良县',	'﻿YiLiangXian',	412,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2738,	'石林彝族自治县',	'﻿ShiLinYiZuZiZhiXian',	412,	1,	0,	'',	'﻿S',	0,	3,	0),
(2739,	'嵩明县',	'﻿SongMingXian',	412,	1,	0,	'',	'﻿S',	0,	3,	0),
(2740,	'禄劝彝族苗族自治县',	'﻿LuQuanYiZuMiaoZuZiZhiXian',	412,	1,	0,	'',	'﻿L',	0,	3,	0),
(2741,	'寻甸回族彝族自治县',	'﻿XunDianHuiZuYiZuZiZhiXian',	412,	1,	0,	'',	'﻿X',	0,	3,	0),
(2742,	'安宁市',	'﻿AnNingShi',	412,	1,	0,	'',	'﻿A',	0,	3,	0),
(2743,	'麒麟区',	'﻿QiLinQu',	413,	1,	0,	'',	'﻿Q',	0,	3,	0),
(2744,	'马龙县',	'﻿MaLongXian',	413,	1,	0,	'',	'﻿M',	0,	3,	0),
(2745,	'陆良县',	'﻿LuLiangXian',	413,	1,	0,	'',	'﻿L',	0,	3,	0),
(2746,	'师宗县',	'﻿ShiZongXian',	413,	1,	0,	'',	'﻿S',	0,	3,	0),
(2747,	'罗平县',	'﻿LuoPingXian',	413,	1,	0,	'',	'﻿L',	0,	3,	0),
(2748,	'富源县',	'﻿FuYuanXian',	413,	1,	0,	'',	'﻿F',	0,	3,	0),
(2749,	'会泽县',	'﻿HuiZeXian',	413,	1,	0,	'',	'﻿H',	0,	3,	0),
(2750,	'沾益县',	'﻿ZhanYiXian',	413,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2751,	'宣威市',	'﻿XuanWeiShi',	413,	1,	0,	'',	'﻿X',	0,	3,	0),
(2752,	'红塔区',	'﻿HongTaQu',	414,	1,	0,	'',	'﻿H',	0,	3,	0),
(2753,	'江川县',	'﻿JiangChuanXian',	414,	1,	0,	'',	'﻿J',	0,	3,	0),
(2754,	'澄江县',	'﻿ChengJiangXian',	414,	1,	0,	'',	'﻿C',	0,	3,	0),
(2755,	'通海县',	'﻿TongHaiXian',	414,	1,	0,	'',	'﻿T',	0,	3,	0),
(2756,	'华宁县',	'﻿HuaNingXian',	414,	1,	0,	'',	'﻿H',	0,	3,	0),
(2757,	'易门县',	'﻿YiMenXian',	414,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2758,	'峨山彝族自治县',	'﻿EShanYiZuZiZhiXian',	414,	1,	0,	'',	'﻿E',	0,	3,	0),
(2759,	'新平彝族傣族自治县',	'﻿XinPingYiZuDaiZuZiZhiXian',	414,	1,	0,	'',	'﻿X',	0,	3,	0),
(2760,	'元江哈尼族彝族傣族自治县',	'﻿YuanJiangHaNiZuYiZuDaiZuZiZhiXian',	414,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2761,	'隆阳区',	'﻿LongYangQu',	415,	1,	0,	'',	'﻿L',	0,	3,	0),
(2762,	'施甸县',	'﻿ShiDianXian',	415,	1,	0,	'',	'﻿S',	0,	3,	0),
(2763,	'腾冲县',	'﻿TengChongXian',	415,	1,	0,	'',	'﻿T',	0,	3,	0),
(2764,	'龙陵县',	'﻿LongLingXian',	415,	1,	0,	'',	'﻿L',	0,	3,	0),
(2765,	'昌宁县',	'﻿ChangNingXian',	415,	1,	0,	'',	'﻿C',	0,	3,	0),
(2766,	'昭阳区',	'﻿ZhaoYangQu',	416,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2767,	'鲁甸县',	'﻿LuDianXian',	416,	1,	0,	'',	'﻿L',	0,	3,	0),
(2768,	'巧家县',	'﻿QiaoJiaXian',	416,	1,	0,	'',	'﻿Q',	0,	3,	0),
(2769,	'盐津县',	'﻿YanJinXian',	416,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2770,	'大关县',	'﻿DaGuanXian',	416,	1,	0,	'',	'﻿D',	0,	3,	0),
(2771,	'永善县',	'﻿YongShanXian',	416,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2772,	'绥江县',	'﻿SuiJiangXian',	416,	1,	0,	'',	'﻿S',	0,	3,	0),
(2773,	'镇雄县',	'﻿ZhenXiongXian',	416,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2774,	'彝良县',	'﻿YiLiangXian',	416,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2775,	'威信县',	'﻿WeiXinXian',	416,	1,	0,	'',	'﻿W',	0,	3,	0),
(2776,	'水富县',	'﻿ShuiFuXian',	416,	1,	0,	'',	'﻿S',	0,	3,	0),
(2777,	'古城区',	'﻿GuChengQu',	417,	1,	0,	'',	'﻿G',	0,	3,	0),
(2778,	'玉龙纳西族自治县',	'﻿YuLongNaXiZuZiZhiXian',	417,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2779,	'永胜县',	'﻿YongShengXian',	417,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2780,	'华坪县',	'﻿HuaPingXian',	417,	1,	0,	'',	'﻿H',	0,	3,	0),
(2781,	'宁蒗彝族自治县',	'﻿NingLangYiZuZiZhiXian',	417,	1,	0,	'',	'﻿N',	0,	3,	0),
(2782,	'翠云区',	'﻿CuiYunQu',	418,	1,	0,	'',	'﻿C',	0,	3,	0),
(2783,	'普洱哈尼族彝族自治县',	'﻿PuErHaNiZuYiZuZiZhiXian',	418,	1,	0,	'',	'﻿P',	0,	3,	0),
(2784,	'墨江哈尼族自治县',	'﻿MoJiangHaNiZuZiZhiXian',	418,	1,	0,	'',	'﻿M',	0,	3,	0),
(2785,	'景东彝族自治县',	'﻿JingDongYiZuZiZhiXian',	418,	1,	0,	'',	'﻿J',	0,	3,	0),
(2786,	'景谷傣族彝族自治县',	'﻿JingGuDaiZuYiZuZiZhiXian',	418,	1,	0,	'',	'﻿J',	0,	3,	0),
(2787,	'镇沅彝族哈尼族拉祜族自治县',	'﻿ZhenYuanYiZuHaNiZuLaHuZuZiZhiXian',	418,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2788,	'江城哈尼族彝族自治县',	'﻿JiangChengHaNiZuYiZuZiZhiXian',	418,	1,	0,	'',	'﻿J',	0,	3,	0),
(2789,	'孟连傣族拉祜族佤族自治县',	'﻿MengLianDaiZuLaHuZuWaZuZiZhiXian',	418,	1,	0,	'',	'﻿M',	0,	3,	0),
(2790,	'澜沧拉祜族自治县',	'﻿LanCangLaHuZuZiZhiXian',	418,	1,	0,	'',	'﻿L',	0,	3,	0),
(2791,	'西盟佤族自治县',	'﻿XiMengWaZuZiZhiXian',	418,	1,	0,	'',	'﻿X',	0,	3,	0),
(2792,	'临翔区',	'﻿LinXiangQu',	419,	1,	0,	'',	'﻿L',	0,	3,	0),
(2793,	'凤庆县',	'﻿FengQingXian',	419,	1,	0,	'',	'﻿F',	0,	3,	0),
(2794,	'云县',	'﻿YunXian',	419,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2795,	'永德县',	'﻿YongDeXian',	419,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2796,	'镇康县',	'﻿ZhenKangXian',	419,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2797,	'双江拉祜族佤族布朗族傣族自治县',	'﻿ShuangJiangLaHuZuWaZuBuLangZuDaiZu',	419,	1,	0,	'',	'﻿S',	0,	3,	0),
(2798,	'耿马傣族佤族自治县',	'﻿GengMaDaiZuWaZuZiZhiXian',	419,	1,	0,	'',	'﻿G',	0,	3,	0),
(2799,	'沧源佤族自治县',	'﻿CangYuanWaZuZiZhiXian',	420,	1,	0,	'',	'﻿C',	0,	3,	0),
(2800,	'楚雄市',	'﻿ChuXiongShi',	420,	1,	0,	'',	'﻿C',	0,	3,	0),
(2801,	'双柏县',	'﻿ShuangBaiXian',	420,	1,	0,	'',	'﻿S',	0,	3,	0),
(2802,	'牟定县',	'﻿MouDingXian',	420,	1,	0,	'',	'﻿M',	0,	3,	0),
(2803,	'南华县',	'﻿NanHuaXian',	420,	1,	0,	'',	'﻿N',	0,	3,	0),
(2804,	'姚安县',	'﻿YaoAnXian',	420,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2805,	'大姚县',	'﻿DaYaoXian',	420,	1,	0,	'',	'﻿D',	0,	3,	0),
(2806,	'永仁县',	'﻿YongRenXian',	420,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2807,	'元谋县',	'﻿YuanMouXian',	420,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2808,	'武定县',	'﻿WuDingXian',	420,	1,	0,	'',	'﻿W',	0,	3,	0),
(2809,	'禄丰县',	'﻿LuFengXian',	420,	1,	0,	'',	'﻿L',	0,	3,	0),
(2810,	'个旧市',	'﻿GeJiuShi',	421,	1,	0,	'',	'﻿G',	0,	3,	0),
(2811,	'开远市',	'﻿KaiYuanShi',	421,	1,	0,	'',	'﻿K',	0,	3,	0),
(2812,	'蒙自县',	'﻿MengZiXian',	421,	1,	0,	'',	'﻿M',	0,	3,	0),
(2813,	'屏边苗族自治县',	'﻿PingBianMiaoZuZiZhiXian',	421,	1,	0,	'',	'﻿P',	0,	3,	0),
(2814,	'建水县',	'﻿JianShuiXian',	421,	1,	0,	'',	'﻿J',	0,	3,	0),
(2815,	'石屏县',	'﻿ShiPingXian',	421,	1,	0,	'',	'﻿S',	0,	3,	0),
(2816,	'弥勒县',	'﻿MiLeXian',	421,	1,	0,	'',	'﻿M',	0,	3,	0),
(2817,	'泸西县',	'﻿LuXiXian',	421,	1,	0,	'',	'﻿L',	0,	3,	0),
(2818,	'元阳县',	'﻿YuanYangXian',	421,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2819,	'红河县',	'﻿HongHeXian',	421,	1,	0,	'',	'﻿H',	0,	3,	0),
(2820,	'金平苗族瑶族傣族自治县',	'﻿JinPingMiaoZuYaoZuDaiZuZiZhiXian',	421,	1,	0,	'',	'﻿J',	0,	3,	0),
(2821,	'绿春县',	'﻿LvChunXian',	421,	1,	0,	'',	'﻿L',	0,	3,	0),
(2822,	'河口瑶族自治县',	'﻿HeKouYaoZuZiZhiXian',	421,	1,	0,	'',	'﻿H',	0,	3,	0),
(2823,	'文山县',	'﻿WenShanXian',	422,	1,	0,	'',	'﻿W',	0,	3,	0),
(2824,	'砚山县',	'﻿YanShanXian',	422,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2825,	'西畴县',	'﻿XiChouXian',	422,	1,	0,	'',	'﻿X',	0,	3,	0),
(2826,	'麻栗坡县',	'﻿MaLiPoXian',	422,	1,	0,	'',	'﻿M',	0,	3,	0),
(2827,	'马关县',	'﻿MaGuanXian',	422,	1,	0,	'',	'﻿M',	0,	3,	0),
(2828,	'丘北县',	'﻿QiuBeiXian',	422,	1,	0,	'',	'﻿Q',	0,	3,	0),
(2829,	'广南县',	'﻿GuangNanXian',	422,	1,	0,	'',	'﻿G',	0,	3,	0),
(2830,	'富宁县',	'﻿FuNingXian',	422,	1,	0,	'',	'﻿F',	0,	3,	0),
(2831,	'景洪市',	'﻿JingHongShi',	423,	1,	0,	'',	'﻿J',	0,	3,	0),
(2832,	'勐海县',	'﻿MengHaiXian',	423,	1,	0,	'',	'﻿M',	0,	3,	0),
(2833,	'勐腊县',	'﻿MengXiXian',	423,	1,	0,	'',	'﻿M',	0,	3,	0),
(2834,	'大理市',	'﻿DaLiShi',	424,	1,	0,	'',	'﻿D',	0,	3,	0),
(2835,	'漾濞彝族自治县',	'﻿YangBiYiZuZiZhiXian',	424,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2836,	'祥云县',	'﻿XiangYunXian',	424,	1,	0,	'',	'﻿X',	0,	3,	0),
(2837,	'宾川县',	'﻿BinChuanXian',	424,	1,	0,	'',	'﻿B',	0,	3,	0),
(2838,	'弥渡县',	'﻿MiDuXian',	424,	1,	0,	'',	'﻿M',	0,	3,	0),
(2839,	'南涧彝族自治县',	'﻿NanJianYiZuZiZhiXian',	424,	1,	0,	'',	'﻿N',	0,	3,	0),
(2840,	'巍山彝族回族自治县',	'﻿WeiShanYiZuHuiZuZiZhiXian',	424,	1,	0,	'',	'﻿W',	0,	3,	0),
(2841,	'永平县',	'﻿YongPingXian',	424,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2842,	'云龙县',	'﻿YunLongXian',	424,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2843,	'洱源县',	'﻿ErYuanXian',	424,	1,	0,	'',	'﻿E',	0,	3,	0),
(2844,	'剑川县',	'﻿JianChuanXian',	424,	1,	0,	'',	'﻿J',	0,	3,	0),
(2845,	'鹤庆县',	'﻿HeQingXian',	424,	1,	0,	'',	'﻿H',	0,	3,	0),
(2846,	'瑞丽市',	'﻿RuiLiShi',	425,	1,	0,	'',	'﻿R',	0,	3,	0),
(2847,	'潞西市',	'﻿LuXiShi',	425,	1,	0,	'',	'﻿L',	0,	3,	0),
(2848,	'梁河县',	'﻿LiangHeXian',	425,	1,	0,	'',	'﻿L',	0,	3,	0),
(2849,	'盈江县',	'﻿YingJiangXian',	425,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2850,	'陇川县',	'﻿LongChuanXian',	425,	1,	0,	'',	'﻿L',	0,	3,	0),
(2851,	'泸水县',	'﻿LuShuiXian',	426,	1,	0,	'',	'﻿L',	0,	3,	0),
(2852,	'福贡县',	'﻿FuGongXian',	426,	1,	0,	'',	'﻿F',	0,	3,	0),
(2853,	'贡山独龙族怒族自治县',	'﻿GongShanDuLongZuNuZuZiZhiXian',	426,	1,	0,	'',	'﻿G',	0,	3,	0),
(2854,	'兰坪白族普米族自治县',	'﻿LanPingBaiZuPuMiZuZiZhiXian',	426,	1,	0,	'',	'﻿L',	0,	3,	0),
(2855,	'香格里拉县',	'﻿XiangGeLiLaXian',	427,	1,	0,	'',	'﻿X',	0,	3,	0),
(2856,	'德钦县',	'﻿DeQinXian',	427,	1,	0,	'',	'﻿D',	0,	3,	0),
(2857,	'维西傈僳族自治县',	'﻿WeiXiLiSuZuZiZhiXian',	427,	1,	0,	'',	'﻿W',	0,	3,	0),
(2858,	'城关区',	'﻿ChengGuanQu',	428,	1,	0,	'',	'﻿C',	0,	3,	0),
(2859,	'林周县',	'﻿LinZhouXian',	428,	1,	0,	'',	'﻿L',	0,	3,	0),
(2860,	'当雄县',	'﻿DangXiongXian',	428,	1,	0,	'',	'﻿D',	0,	3,	0),
(2861,	'尼木县',	'﻿NiMuXian',	428,	1,	0,	'',	'﻿N',	0,	3,	0),
(2862,	'曲水县',	'﻿QuShuiXian',	428,	1,	0,	'',	'﻿Q',	0,	3,	0),
(2863,	'堆龙德庆县',	'﻿DuiLongDeQingXian',	428,	1,	0,	'',	'﻿D',	0,	3,	0),
(2864,	'达孜县',	'﻿DaZiXian',	428,	1,	0,	'',	'﻿D',	0,	3,	0),
(2865,	'墨竹工卡县',	'﻿MoZhuGongQiaXian',	428,	1,	0,	'',	'﻿M',	0,	3,	0),
(2866,	'昌都县',	'﻿ChangDuXian',	429,	1,	0,	'',	'﻿C',	0,	3,	0),
(2867,	'江达县',	'﻿JiangDaXian',	429,	1,	0,	'',	'﻿J',	0,	3,	0),
(2868,	'贡觉县',	'﻿GongJueXian',	429,	1,	0,	'',	'﻿G',	0,	3,	0),
(2869,	'类乌齐县',	'﻿LeiWuQiXian',	429,	1,	0,	'',	'﻿L',	0,	3,	0),
(2870,	'丁青县',	'﻿DingQingXian',	429,	1,	0,	'',	'﻿D',	0,	3,	0),
(2871,	'察雅县',	'﻿ChaYaXian',	429,	1,	0,	'',	'﻿C',	0,	3,	0),
(2872,	'八宿县',	'﻿BaSuXian',	429,	1,	0,	'',	'﻿B',	0,	3,	0),
(2873,	'左贡县',	'﻿ZuoGongXian',	429,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2874,	'芒康县',	'﻿MangKangXian',	429,	1,	0,	'',	'﻿M',	0,	3,	0),
(2875,	'洛隆县',	'﻿LuoLongXian',	429,	1,	0,	'',	'﻿L',	0,	3,	0),
(2876,	'边坝县',	'﻿BianBaXian',	429,	1,	0,	'',	'﻿B',	0,	3,	0),
(2877,	'乃东县',	'﻿NaiDongXian',	430,	1,	0,	'',	'﻿N',	0,	3,	0),
(2878,	'扎囊县',	'﻿ZaNangXian',	430,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2879,	'贡嘎县',	'﻿GongGaXian',	430,	1,	0,	'',	'﻿G',	0,	3,	0),
(2880,	'桑日县',	'﻿SangRiXian',	430,	1,	0,	'',	'﻿S',	0,	3,	0),
(2881,	'琼结县',	'﻿QiongJieXian',	430,	1,	0,	'',	'﻿Q',	0,	3,	0),
(2882,	'曲松县',	'﻿QuSongXian',	430,	1,	0,	'',	'﻿Q',	0,	3,	0),
(2883,	'措美县',	'﻿CuoMeiXian',	430,	1,	0,	'',	'﻿C',	0,	3,	0),
(2884,	'洛扎县',	'﻿LuoZaXian',	430,	1,	0,	'',	'﻿L',	0,	3,	0),
(2885,	'加查县',	'﻿JiaChaXian',	430,	1,	0,	'',	'﻿J',	0,	3,	0),
(2886,	'隆子县',	'﻿LongZiXian',	430,	1,	0,	'',	'﻿L',	0,	3,	0),
(2887,	'错那县',	'﻿CuoNaXian',	430,	1,	0,	'',	'﻿C',	0,	3,	0),
(2888,	'浪卡子县',	'﻿LangQiaZiXian',	430,	1,	0,	'',	'﻿L',	0,	3,	0),
(2889,	'日喀则市',	'﻿RiKaZeShi',	431,	1,	0,	'',	'﻿R',	0,	3,	0),
(2890,	'南木林县',	'﻿NanMuLinXian',	431,	1,	0,	'',	'﻿N',	0,	3,	0),
(2891,	'江孜县',	'﻿JiangZiXian',	431,	1,	0,	'',	'﻿J',	0,	3,	0),
(2892,	'定日县',	'﻿DingRiXian',	431,	1,	0,	'',	'﻿D',	0,	3,	0),
(2893,	'萨迦县',	'﻿SaJiaXian',	431,	1,	0,	'',	'﻿S',	0,	3,	0),
(2894,	'拉孜县',	'﻿LaZiXian',	431,	1,	0,	'',	'﻿L',	0,	3,	0),
(2895,	'昂仁县',	'﻿AngRenXian',	431,	1,	0,	'',	'﻿A',	0,	3,	0),
(2896,	'谢通门县',	'﻿XieTongMenXian',	431,	1,	0,	'',	'﻿X',	0,	3,	0),
(2897,	'白朗县',	'﻿BaiLangXian',	431,	1,	0,	'',	'﻿B',	0,	3,	0),
(2898,	'仁布县',	'﻿RenBuXian',	431,	1,	0,	'',	'﻿R',	0,	3,	0),
(2899,	'康马县',	'﻿KangMaXian',	431,	1,	0,	'',	'﻿K',	0,	3,	0),
(2900,	'定结县',	'﻿DingJieXian',	431,	1,	0,	'',	'﻿D',	0,	3,	0),
(2901,	'仲巴县',	'﻿ZhongBaXian',	431,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2902,	'亚东县',	'﻿YaDongXian',	431,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2903,	'吉隆县',	'﻿JiLongXian',	431,	1,	0,	'',	'﻿J',	0,	3,	0),
(2904,	'聂拉木县',	'﻿NieLaMuXian',	431,	1,	0,	'',	'﻿N',	0,	3,	0),
(2905,	'萨嘎县',	'﻿SaGaXian',	431,	1,	0,	'',	'﻿S',	0,	3,	0),
(2906,	'岗巴县',	'﻿GangBaXian',	431,	1,	0,	'',	'﻿G',	0,	3,	0),
(2907,	'那曲县',	'﻿NaQuXian',	432,	1,	0,	'',	'﻿N',	0,	3,	0),
(2908,	'嘉黎县',	'﻿JiaLiXian',	432,	1,	0,	'',	'﻿J',	0,	3,	0),
(2909,	'比如县',	'﻿BiRuXian',	432,	1,	0,	'',	'﻿B',	0,	3,	0),
(2910,	'聂荣县',	'﻿NieRongXian',	432,	1,	0,	'',	'﻿N',	0,	3,	0),
(2911,	'安多县',	'﻿AnDuoXian',	432,	1,	0,	'',	'﻿A',	0,	3,	0),
(2912,	'申扎县',	'﻿ShenZaXian',	432,	1,	0,	'',	'﻿S',	0,	3,	0),
(2913,	'索县',	'﻿SuoXian',	432,	1,	0,	'',	'﻿S',	0,	3,	0),
(2914,	'班戈县',	'﻿BanGeXian',	432,	1,	0,	'',	'﻿B',	0,	3,	0),
(2915,	'巴青县',	'﻿BaQingXian',	432,	1,	0,	'',	'﻿B',	0,	3,	0),
(2916,	'尼玛县',	'﻿NiMaXian',	432,	1,	0,	'',	'﻿N',	0,	3,	0),
(2917,	'普兰县',	'﻿PuLanXian',	433,	1,	0,	'',	'﻿P',	0,	3,	0),
(2918,	'札达县',	'﻿ZhaDaXian',	433,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2919,	'噶尔县',	'﻿GaErXian',	433,	1,	0,	'',	'﻿G',	0,	3,	0),
(2920,	'日土县',	'﻿RiTuXian',	433,	1,	0,	'',	'﻿R',	0,	3,	0),
(2921,	'革吉县',	'﻿GeJiXian',	433,	1,	0,	'',	'﻿G',	0,	3,	0),
(2922,	'改则县',	'﻿GaiZeXian',	433,	1,	0,	'',	'﻿G',	0,	3,	0),
(2923,	'措勤县',	'﻿CuoQinXian',	433,	1,	0,	'',	'﻿C',	0,	3,	0),
(2924,	'林芝县',	'﻿LinZhiXian',	434,	1,	0,	'',	'﻿L',	0,	3,	0),
(2925,	'工布江达县',	'﻿GongBuJiangDaXian',	434,	1,	0,	'',	'﻿G',	0,	3,	0),
(2926,	'米林县',	'﻿MiLinXian',	434,	1,	0,	'',	'﻿M',	0,	3,	0),
(2927,	'墨脱县',	'﻿MoTuoXian',	434,	1,	0,	'',	'﻿M',	0,	3,	0),
(2928,	'波密县',	'﻿BoMiXian',	434,	1,	0,	'',	'﻿B',	0,	3,	0),
(2929,	'察隅县',	'﻿ChaYuXian',	434,	1,	0,	'',	'﻿C',	0,	3,	0),
(2930,	'朗县',	'﻿LangXian',	434,	1,	0,	'',	'﻿L',	0,	3,	0),
(2931,	'新城区',	'﻿XinChengQu',	435,	1,	0,	'',	'﻿X',	0,	3,	0),
(2932,	'碑林区',	'﻿BeiLinQu',	435,	1,	0,	'',	'﻿B',	0,	3,	0),
(2933,	'莲湖区',	'﻿LianHuQu',	435,	1,	0,	'',	'﻿L',	0,	3,	0),
(2934,	'灞桥区',	'﻿BaQiaoQu',	435,	1,	0,	'',	'﻿B',	0,	3,	0),
(2935,	'未央区',	'﻿WeiYangQu',	435,	1,	0,	'',	'﻿W',	0,	3,	0),
(2936,	'雁塔区',	'﻿YanTaQu',	435,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2937,	'阎良区',	'﻿YanLiangQu',	435,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2938,	'临潼区',	'﻿LinTongQu',	435,	1,	0,	'',	'﻿L',	0,	3,	0),
(2939,	'长安区',	'﻿ChangAnQu',	435,	1,	0,	'',	'﻿C',	0,	3,	0),
(2940,	'蓝田县',	'﻿LanTianXian',	435,	1,	0,	'',	'﻿L',	0,	3,	0),
(2941,	'周至县',	'﻿ZhouZhiXian',	435,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2942,	'户县',	'﻿HuXian',	435,	1,	0,	'',	'﻿H',	0,	3,	0),
(2943,	'高陵县',	'﻿GaoLingXian',	435,	1,	0,	'',	'﻿G',	0,	3,	0),
(2944,	'王益区',	'﻿WangYiQu',	436,	1,	0,	'',	'﻿W',	0,	3,	0),
(2945,	'印台区',	'﻿YinTaiQu',	436,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2946,	'耀州区',	'﻿YaoZhouQu',	436,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2947,	'宜君县',	'﻿YiJunXian',	436,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2948,	'渭滨区',	'﻿WeiBinQu',	437,	1,	0,	'',	'﻿W',	0,	3,	0),
(2949,	'金台区',	'﻿JinTaiQu',	437,	1,	0,	'',	'﻿J',	0,	3,	0),
(2950,	'陈仓区',	'﻿ChenCangQu',	437,	1,	0,	'',	'﻿C',	0,	3,	0),
(2951,	'凤翔县',	'﻿FengXiangXian',	437,	1,	0,	'',	'﻿F',	0,	3,	0),
(2952,	'岐山县',	'﻿QiShanXian',	437,	1,	0,	'',	'﻿Q',	0,	3,	0),
(2953,	'扶风县',	'﻿FuFengXian',	437,	1,	0,	'',	'﻿F',	0,	3,	0),
(2954,	'眉县',	'﻿MeiXian',	437,	1,	0,	'',	'﻿M',	0,	3,	0),
(2955,	'陇县',	'﻿LongXian',	437,	1,	0,	'',	'﻿L',	0,	3,	0),
(2956,	'千阳县',	'﻿QianYangXian',	437,	1,	0,	'',	'﻿Q',	0,	3,	0),
(2957,	'麟游县',	'﻿LinYouXian',	437,	1,	0,	'',	'﻿L',	0,	3,	0),
(2958,	'凤县',	'﻿FengXian',	437,	1,	0,	'',	'﻿F',	0,	3,	0),
(2959,	'太白县',	'﻿TaiBaiXian',	437,	1,	0,	'',	'﻿T',	0,	3,	0),
(2960,	'秦都区',	'﻿QinDuQu',	438,	1,	0,	'',	'﻿Q',	0,	3,	0),
(2961,	'杨凌区',	'﻿YangLingQu',	438,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2962,	'渭城区',	'﻿WeiChengQu',	438,	1,	0,	'',	'﻿W',	0,	3,	0),
(2963,	'三原县',	'﻿SanYuanXian',	438,	1,	0,	'',	'﻿S',	0,	3,	0),
(2964,	'泾阳县',	'﻿JingYangXian',	438,	1,	0,	'',	'﻿J',	0,	3,	0),
(2965,	'乾县',	'﻿QianXian',	438,	1,	0,	'',	'﻿Q',	0,	3,	0),
(2966,	'礼泉县',	'﻿LiQuanXian',	438,	1,	0,	'',	'﻿L',	0,	3,	0),
(2967,	'永寿县',	'﻿YongShouXian',	438,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2968,	'彬县',	'﻿BinXian',	438,	1,	0,	'',	'﻿B',	0,	3,	0),
(2969,	'长武县',	'﻿ChangWuXian',	438,	1,	0,	'',	'﻿C',	0,	3,	0),
(2970,	'旬邑县',	'﻿XunYiXian',	438,	1,	0,	'',	'﻿X',	0,	3,	0),
(2971,	'淳化县',	'﻿ChunHuaXian',	438,	1,	0,	'',	'﻿C',	0,	3,	0),
(2972,	'武功县',	'﻿WuGongXian',	438,	1,	0,	'',	'﻿W',	0,	3,	0),
(2973,	'兴平市',	'﻿XingPingShi',	438,	1,	0,	'',	'﻿X',	0,	3,	0),
(2974,	'临渭区',	'﻿LinWeiQu',	439,	1,	0,	'',	'﻿L',	0,	3,	0),
(2975,	'华县',	'﻿HuaXian',	439,	1,	0,	'',	'﻿H',	0,	3,	0),
(2976,	'潼关县',	'﻿TongGuanXian',	439,	1,	0,	'',	'﻿T',	0,	3,	0),
(2977,	'大荔县',	'﻿DaLiXian',	439,	1,	0,	'',	'﻿D',	0,	3,	0),
(2978,	'合阳县',	'﻿HeYangXian',	439,	1,	0,	'',	'﻿H',	0,	3,	0),
(2979,	'澄城县',	'﻿ChengChengXian',	439,	1,	0,	'',	'﻿C',	0,	3,	0),
(2980,	'蒲城县',	'﻿PuChengXian',	439,	1,	0,	'',	'﻿P',	0,	3,	0),
(2981,	'白水县',	'﻿BaiShuiXian',	439,	1,	0,	'',	'﻿B',	0,	3,	0),
(2982,	'富平县',	'﻿FuPingXian',	439,	1,	0,	'',	'﻿F',	0,	3,	0),
(2983,	'韩城市',	'﻿HanChengShi',	439,	1,	0,	'',	'﻿H',	0,	3,	0),
(2984,	'华阴市',	'﻿HuaYinShi',	439,	1,	0,	'',	'﻿H',	0,	3,	0),
(2985,	'宝塔区',	'﻿BaoTaQu',	440,	1,	0,	'',	'﻿B',	0,	3,	0),
(2986,	'延长县',	'﻿YanChangXian',	440,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2987,	'延川县',	'﻿YanChuanXian',	440,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2988,	'子长县',	'﻿ZiChangXian',	440,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2989,	'安塞县',	'﻿AnSaiXian',	440,	1,	0,	'',	'﻿A',	0,	3,	0),
(2990,	'志丹县',	'﻿ZhiDanXian',	440,	1,	0,	'',	'﻿Z',	0,	3,	0),
(2991,	'吴起县',	'﻿WuQiXian',	440,	1,	0,	'',	'﻿W',	0,	3,	0),
(2992,	'甘泉县',	'﻿GanQuanXian',	440,	1,	0,	'',	'﻿G',	0,	3,	0),
(2993,	'富县',	'﻿FuXian',	440,	1,	0,	'',	'﻿F',	0,	3,	0),
(2994,	'洛川县',	'﻿LuoChuanXian',	440,	1,	0,	'',	'﻿L',	0,	3,	0),
(2995,	'宜川县',	'﻿YiChuanXian',	440,	1,	0,	'',	'﻿Y',	0,	3,	0),
(2996,	'黄龙县',	'﻿HuangLongXian',	440,	1,	0,	'',	'﻿H',	0,	3,	0),
(2997,	'黄陵县',	'﻿HuangLingXian',	440,	1,	0,	'',	'﻿H',	0,	3,	0),
(2998,	'汉台区',	'﻿HanTaiQu',	441,	1,	0,	'',	'﻿H',	0,	3,	0),
(2999,	'南郑县',	'﻿NanZhengXian',	441,	1,	0,	'',	'﻿N',	0,	3,	0),
(3000,	'城固县',	'﻿ChengGuXian',	441,	1,	0,	'',	'﻿C',	0,	3,	0),
(3001,	'洋县',	'﻿YangXian',	441,	1,	0,	'',	'﻿Y',	0,	3,	0),
(3002,	'西乡县',	'﻿XiXiangXian',	441,	1,	0,	'',	'﻿X',	0,	3,	0),
(3003,	'勉县',	'﻿MianXian',	441,	1,	0,	'',	'﻿M',	0,	3,	0),
(3004,	'宁强县',	'﻿NingQiangXian',	441,	1,	0,	'',	'﻿N',	0,	3,	0),
(3005,	'略阳县',	'﻿L<eYangXian',	441,	1,	0,	'',	'﻿L',	0,	3,	0),
(3006,	'镇巴县',	'﻿ZhenBaXian',	441,	1,	0,	'',	'﻿Z',	0,	3,	0),
(3007,	'留坝县',	'﻿LiuBaXian',	441,	1,	0,	'',	'﻿L',	0,	3,	0),
(3008,	'佛坪县',	'﻿FoPingXian',	441,	1,	0,	'',	'﻿F',	0,	3,	0),
(3009,	'榆阳区',	'﻿YuYangQu',	442,	1,	0,	'',	'﻿Y',	0,	3,	0),
(3010,	'神木县',	'﻿ShenMuXian',	442,	1,	0,	'',	'﻿S',	0,	3,	0),
(3011,	'府谷县',	'﻿FuGuXian',	442,	1,	0,	'',	'﻿F',	0,	3,	0),
(3012,	'横山县',	'﻿HengShanXian',	442,	1,	0,	'',	'﻿H',	0,	3,	0),
(3013,	'靖边县',	'﻿JingBianXian',	442,	1,	0,	'',	'﻿J',	0,	3,	0),
(3014,	'定边县',	'﻿DingBianXian',	442,	1,	0,	'',	'﻿D',	0,	3,	0),
(3015,	'绥德县',	'﻿SuiDeXian',	442,	1,	0,	'',	'﻿S',	0,	3,	0),
(3016,	'米脂县',	'﻿MiZhiXian',	442,	1,	0,	'',	'﻿M',	0,	3,	0),
(3017,	'佳县',	'﻿JiaXian',	442,	1,	0,	'',	'﻿J',	0,	3,	0),
(3018,	'吴堡县',	'﻿WuBaoXian',	442,	1,	0,	'',	'﻿W',	0,	3,	0),
(3019,	'清涧县',	'﻿QingJianXian',	442,	1,	0,	'',	'﻿Q',	0,	3,	0),
(3020,	'子洲县',	'﻿ZiZhouXian',	442,	1,	0,	'',	'﻿Z',	0,	3,	0),
(3021,	'汉滨区',	'﻿HanBinQu',	443,	1,	0,	'',	'﻿H',	0,	3,	0),
(3022,	'汉阴县',	'﻿HanYinXian',	443,	1,	0,	'',	'﻿H',	0,	3,	0),
(3023,	'石泉县',	'﻿ShiQuanXian',	443,	1,	0,	'',	'﻿S',	0,	3,	0),
(3024,	'宁陕县',	'﻿NingShanXian',	443,	1,	0,	'',	'﻿N',	0,	3,	0),
(3025,	'紫阳县',	'﻿ZiYangXian',	443,	1,	0,	'',	'﻿Z',	0,	3,	0),
(3026,	'岚皋县',	'﻿LanGaoXian',	443,	1,	0,	'',	'﻿L',	0,	3,	0),
(3027,	'平利县',	'﻿PingLiXian',	443,	1,	0,	'',	'﻿P',	0,	3,	0),
(3028,	'镇坪县',	'﻿ZhenPingXian',	443,	1,	0,	'',	'﻿Z',	0,	3,	0),
(3029,	'旬阳县',	'﻿XunYangXian',	443,	1,	0,	'',	'﻿X',	0,	3,	0),
(3030,	'白河县',	'﻿BaiHeXian',	443,	1,	0,	'',	'﻿B',	0,	3,	0),
(3031,	'商州区',	'﻿ShangZhouQu',	444,	1,	0,	'',	'﻿S',	0,	3,	0),
(3032,	'洛南县',	'﻿LuoNanXian',	444,	1,	0,	'',	'﻿L',	0,	3,	0),
(3033,	'丹凤县',	'﻿DanFengXian',	444,	1,	0,	'',	'﻿D',	0,	3,	0),
(3034,	'商南县',	'﻿ShangNanXian',	444,	1,	0,	'',	'﻿S',	0,	3,	0),
(3035,	'山阳县',	'﻿ShanYangXian',	444,	1,	0,	'',	'﻿S',	0,	3,	0),
(3036,	'镇安县',	'﻿ZhenAnXian',	444,	1,	0,	'',	'﻿Z',	0,	3,	0),
(3037,	'柞水县',	'﻿ZuoShuiXian',	444,	1,	0,	'',	'﻿Z',	0,	3,	0),
(3038,	'城关区',	'﻿ChengGuanQu',	445,	1,	0,	'',	'﻿C',	0,	3,	0),
(3039,	'七里河区',	'﻿QiLiHeQu',	445,	1,	0,	'',	'﻿Q',	0,	3,	0),
(3040,	'西固区',	'﻿XiGuQu',	445,	1,	0,	'',	'﻿X',	0,	3,	0),
(3041,	'安宁区',	'﻿AnNingQu',	445,	1,	0,	'',	'﻿A',	0,	3,	0),
(3042,	'红古区',	'﻿HongGuQu',	445,	1,	0,	'',	'﻿H',	0,	3,	0),
(3043,	'永登县',	'﻿YongDengXian',	445,	1,	0,	'',	'﻿Y',	0,	3,	0),
(3044,	'皋兰县',	'﻿GaoLanXian',	445,	1,	0,	'',	'﻿G',	0,	3,	0),
(3045,	'榆中县',	'﻿YuZhongXian',	445,	1,	0,	'',	'﻿Y',	0,	3,	0),
(3046,	'金川区',	'﻿JinChuanQu',	447,	1,	0,	'',	'﻿J',	0,	3,	0),
(3047,	'永昌县',	'﻿YongChangXian',	447,	1,	0,	'',	'﻿Y',	0,	3,	0),
(3048,	'白银区',	'﻿BaiYinQu',	448,	1,	0,	'',	'﻿B',	0,	3,	0),
(3049,	'平川区',	'﻿PingChuanQu',	448,	1,	0,	'',	'﻿P',	0,	3,	0),
(3050,	'靖远县',	'﻿JingYuanXian',	448,	1,	0,	'',	'﻿J',	0,	3,	0),
(3051,	'会宁县',	'﻿HuiNingXian',	448,	1,	0,	'',	'﻿H',	0,	3,	0),
(3052,	'景泰县',	'﻿JingTaiXian',	448,	1,	0,	'',	'﻿J',	0,	3,	0),
(3053,	'秦城区',	'﻿QinChengQu',	449,	1,	0,	'',	'﻿Q',	0,	3,	0),
(3054,	'北道区',	'﻿BeiDaoQu',	449,	1,	0,	'',	'﻿B',	0,	3,	0),
(3055,	'清水县',	'﻿QingShuiXian',	449,	1,	0,	'',	'﻿Q',	0,	3,	0),
(3056,	'秦安县',	'﻿QinAnXian',	449,	1,	0,	'',	'﻿Q',	0,	3,	0),
(3057,	'甘谷县',	'﻿GanGuXian',	449,	1,	0,	'',	'﻿G',	0,	3,	0),
(3058,	'武山县',	'﻿WuShanXian',	449,	1,	0,	'',	'﻿W',	0,	3,	0),
(3059,	'张家川回族自治县',	'﻿ZhangJiaChuanHuiZuZiZhiXian',	449,	1,	0,	'',	'﻿Z',	0,	3,	0),
(3060,	'凉州区',	'﻿LiangZhouQu',	450,	1,	0,	'',	'﻿L',	0,	3,	0),
(3061,	'民勤县',	'﻿MinQinXian',	450,	1,	0,	'',	'﻿M',	0,	3,	0),
(3062,	'古浪县',	'﻿GuLangXian',	450,	1,	0,	'',	'﻿G',	0,	3,	0),
(3063,	'天祝藏族自治县',	'﻿TianZhuCangZuZiZhiXian',	450,	1,	0,	'',	'﻿T',	0,	3,	0),
(3064,	'甘州区',	'﻿GanZhouQu',	451,	1,	0,	'',	'﻿G',	0,	3,	0),
(3065,	'肃南裕固族自治县',	'﻿SuNanYuGuZuZiZhiXian',	451,	1,	0,	'',	'﻿S',	0,	3,	0),
(3066,	'民乐县',	'﻿MinLeXian',	451,	1,	0,	'',	'﻿M',	0,	3,	0),
(3067,	'临泽县',	'﻿LinZeXian',	451,	1,	0,	'',	'﻿L',	0,	3,	0),
(3068,	'高台县',	'﻿GaoTaiXian',	451,	1,	0,	'',	'﻿G',	0,	3,	0),
(3069,	'山丹县',	'﻿ShanDanXian',	451,	1,	0,	'',	'﻿S',	0,	3,	0),
(3070,	'崆峒区',	'﻿KongTongQu',	452,	1,	0,	'',	'﻿K',	0,	3,	0),
(3071,	'泾川县',	'﻿JingChuanXian',	452,	1,	0,	'',	'﻿J',	0,	3,	0),
(3072,	'灵台县',	'﻿LingTaiXian',	452,	1,	0,	'',	'﻿L',	0,	3,	0),
(3073,	'崇信县',	'﻿ChongXinXian',	452,	1,	0,	'',	'﻿C',	0,	3,	0),
(3074,	'华亭县',	'﻿HuaTingXian',	452,	1,	0,	'',	'﻿H',	0,	3,	0),
(3075,	'庄浪县',	'﻿ZhuangLangXian',	452,	1,	0,	'',	'﻿Z',	0,	3,	0),
(3076,	'静宁县',	'﻿JingNingXian',	452,	1,	0,	'',	'﻿J',	0,	3,	0),
(3077,	'肃州区',	'﻿SuZhouQu',	453,	1,	0,	'',	'﻿S',	0,	3,	0),
(3078,	'金塔县',	'﻿JinTaXian',	453,	1,	0,	'',	'﻿J',	0,	3,	0),
(3079,	'瓜州县',	'﻿GuaZhouXian',	453,	1,	0,	'',	'﻿G',	0,	3,	0),
(3080,	'肃北蒙古族自治县',	'﻿SuBeiMengGuZuZiZhiXian',	453,	1,	0,	'',	'﻿S',	0,	3,	0),
(3081,	'阿克塞哈萨克族自治县',	'﻿AKeSaiHaSaKeZuZiZhiXian',	453,	1,	0,	'',	'﻿A',	0,	3,	0),
(3082,	'玉门市',	'﻿YuMenShi',	453,	1,	0,	'',	'﻿Y',	0,	3,	0),
(3083,	'敦煌市',	'﻿DunHuangShi',	453,	1,	0,	'',	'﻿D',	0,	3,	0),
(3084,	'西峰区',	'﻿XiFengQu',	454,	1,	0,	'',	'﻿X',	0,	3,	0),
(3085,	'庆城县',	'﻿QingChengXian',	454,	1,	0,	'',	'﻿Q',	0,	3,	0),
(3086,	'环县',	'﻿HuanXian',	454,	1,	0,	'',	'﻿H',	0,	3,	0),
(3087,	'华池县',	'﻿HuaChiXian',	454,	1,	0,	'',	'﻿H',	0,	3,	0),
(3088,	'合水县',	'﻿HeShuiXian',	454,	1,	0,	'',	'﻿H',	0,	3,	0),
(3089,	'正宁县',	'﻿ZhengNingXian',	454,	1,	0,	'',	'﻿Z',	0,	3,	0),
(3090,	'宁县',	'﻿NingXian',	454,	1,	0,	'',	'﻿N',	0,	3,	0),
(3091,	'镇原县',	'﻿ZhenYuanXian',	454,	1,	0,	'',	'﻿Z',	0,	3,	0),
(3092,	'安定区',	'﻿AnDingQu',	455,	1,	0,	'',	'﻿A',	0,	3,	0),
(3093,	'通渭县',	'﻿TongWeiXian',	455,	1,	0,	'',	'﻿T',	0,	3,	0),
(3094,	'陇西县',	'﻿LongXiXian',	455,	1,	0,	'',	'﻿L',	0,	3,	0),
(3095,	'渭源县',	'﻿WeiYuanXian',	455,	1,	0,	'',	'﻿W',	0,	3,	0),
(3096,	'临洮县',	'﻿LinTaoXian',	455,	1,	0,	'',	'﻿L',	0,	3,	0),
(3097,	'漳县',	'﻿ZhangXian',	455,	1,	0,	'',	'﻿Z',	0,	3,	0),
(3098,	'岷县',	'﻿MinXian',	455,	1,	0,	'',	'﻿M',	0,	3,	0),
(3099,	'武都区',	'﻿WuDuQu',	456,	1,	0,	'',	'﻿W',	0,	3,	0),
(3100,	'成县',	'﻿ChengXian',	456,	1,	0,	'',	'﻿C',	0,	3,	0),
(3101,	'文县',	'﻿WenXian',	456,	1,	0,	'',	'﻿W',	0,	3,	0),
(3102,	'宕昌县',	'﻿DangChangXian',	456,	1,	0,	'',	'﻿D',	0,	3,	0),
(3103,	'康县',	'﻿KangXian',	456,	1,	0,	'',	'﻿K',	0,	3,	0),
(3104,	'西和县',	'﻿XiHeXian',	456,	1,	0,	'',	'﻿X',	0,	3,	0),
(3105,	'礼县',	'﻿LiXian',	456,	1,	0,	'',	'﻿L',	0,	3,	0),
(3106,	'徽县',	'﻿HuiXian',	456,	1,	0,	'',	'﻿H',	0,	3,	0),
(3107,	'两当县',	'﻿LiangDangXian',	456,	1,	0,	'',	'﻿L',	0,	3,	0),
(3108,	'临夏市',	'﻿LinXiaShi',	457,	1,	0,	'',	'﻿L',	0,	3,	0),
(3109,	'临夏县',	'﻿LinXiaXian',	457,	1,	0,	'',	'﻿L',	0,	3,	0),
(3110,	'康乐县',	'﻿KangLeXian',	457,	1,	0,	'',	'﻿K',	0,	3,	0),
(3111,	'永靖县',	'﻿YongJingXian',	457,	1,	0,	'',	'﻿Y',	0,	3,	0),
(3112,	'广河县',	'﻿GuangHeXian',	457,	1,	0,	'',	'﻿G',	0,	3,	0),
(3113,	'和政县',	'﻿HeZhengXian',	457,	1,	0,	'',	'﻿H',	0,	3,	0),
(3114,	'东乡族自治县',	'﻿DongXiangZuZiZhiXian',	457,	1,	0,	'',	'﻿D',	0,	3,	0),
(3115,	'积石山保安族东乡族撒拉族自治县',	'﻿JiShiShanBaoAnZuDongXiangZuSaLaZuZ',	457,	1,	0,	'',	'﻿J',	0,	3,	0),
(3116,	'合作市',	'﻿HeZuoShi',	458,	1,	0,	'',	'﻿H',	0,	3,	0),
(3117,	'临潭县',	'﻿LinTanXian',	458,	1,	0,	'',	'﻿L',	0,	3,	0),
(3118,	'卓尼县',	'﻿ZhuoNiXian',	458,	1,	0,	'',	'﻿Z',	0,	3,	0),
(3119,	'舟曲县',	'﻿ZhouQuXian',	458,	1,	0,	'',	'﻿Z',	0,	3,	0),
(3120,	'迭部县',	'﻿DieBuXian',	458,	1,	0,	'',	'﻿D',	0,	3,	0),
(3121,	'玛曲县',	'﻿MaQuXian',	458,	1,	0,	'',	'﻿M',	0,	3,	0),
(3122,	'碌曲县',	'﻿LuQuXian',	458,	1,	0,	'',	'﻿L',	0,	3,	0),
(3123,	'夏河县',	'﻿XiaHeXian',	458,	1,	0,	'',	'﻿X',	0,	3,	0),
(3124,	'城东区',	'﻿ChengDongQu',	459,	1,	0,	'',	'﻿C',	0,	3,	0),
(3125,	'城中区',	'﻿ChengZhongQu',	459,	1,	0,	'',	'﻿C',	0,	3,	0),
(3126,	'城西区',	'﻿ChengXiQu',	459,	1,	0,	'',	'﻿C',	0,	3,	0),
(3127,	'城北区',	'﻿ChengBeiQu',	459,	1,	0,	'',	'﻿C',	0,	3,	0),
(3128,	'大通回族土族自治县',	'﻿DaTongHuiZuTuZuZiZhiXian',	459,	1,	0,	'',	'﻿D',	0,	3,	0),
(3129,	'湟中县',	'﻿HuangZhongXian',	459,	1,	0,	'',	'﻿H',	0,	3,	0),
(3130,	'湟源县',	'﻿HuangYuanXian',	459,	1,	0,	'',	'﻿H',	0,	3,	0),
(3131,	'平安县',	'﻿PingAnXian',	460,	1,	0,	'',	'﻿P',	0,	3,	0),
(3132,	'民和回族土族自治县',	'﻿MinHeHuiZuTuZuZiZhiXian',	460,	1,	0,	'',	'﻿M',	0,	3,	0),
(3133,	'乐都县',	'﻿LeDuXian',	460,	1,	0,	'',	'﻿L',	0,	3,	0),
(3134,	'互助土族自治县',	'﻿HuZhuTuZuZiZhiXian',	460,	1,	0,	'',	'﻿H',	0,	3,	0),
(3135,	'化隆回族自治县',	'﻿HuaLongHuiZuZiZhiXian',	460,	1,	0,	'',	'﻿H',	0,	3,	0),
(3136,	'循化撒拉族自治县',	'﻿XunHuaSaLaZuZiZhiXian',	460,	1,	0,	'',	'﻿X',	0,	3,	0),
(3137,	'门源回族自治县',	'﻿MenYuanHuiZuZiZhiXian',	461,	1,	0,	'',	'﻿M',	0,	3,	0),
(3138,	'祁连县',	'﻿QiLianXian',	461,	1,	0,	'',	'﻿Q',	0,	3,	0),
(3139,	'海晏县',	'﻿HaiYanXian',	461,	1,	0,	'',	'﻿H',	0,	3,	0),
(3140,	'刚察县',	'﻿GangChaXian',	461,	1,	0,	'',	'﻿G',	0,	3,	0),
(3141,	'同仁县',	'﻿TongRenXian',	462,	1,	0,	'',	'﻿T',	0,	3,	0),
(3142,	'尖扎县',	'﻿JianZaXian',	462,	1,	0,	'',	'﻿J',	0,	3,	0),
(3143,	'泽库县',	'﻿ZeKuXian',	462,	1,	0,	'',	'﻿Z',	0,	3,	0),
(3144,	'河南蒙古族自治县',	'﻿HeNanMengGuZuZiZhiXian',	462,	1,	0,	'',	'﻿H',	0,	3,	0),
(3145,	'共和县',	'﻿GongHeXian',	463,	1,	0,	'',	'﻿G',	0,	3,	0),
(3146,	'同德县',	'﻿TongDeXian',	463,	1,	0,	'',	'﻿T',	0,	3,	0),
(3147,	'贵德县',	'﻿GuiDeXian',	463,	1,	0,	'',	'﻿G',	0,	3,	0),
(3148,	'兴海县',	'﻿XingHaiXian',	463,	1,	0,	'',	'﻿X',	0,	3,	0),
(3149,	'贵南县',	'﻿GuiNanXian',	463,	1,	0,	'',	'﻿G',	0,	3,	0),
(3150,	'玛沁县',	'﻿MaQinXian',	464,	1,	0,	'',	'﻿M',	0,	3,	0),
(3151,	'班玛县',	'﻿BanMaXian',	464,	1,	0,	'',	'﻿B',	0,	3,	0),
(3152,	'甘德县',	'﻿GanDeXian',	464,	1,	0,	'',	'﻿G',	0,	3,	0),
(3153,	'达日县',	'﻿DaRiXian',	464,	1,	0,	'',	'﻿D',	0,	3,	0),
(3154,	'久治县',	'﻿JiuZhiXian',	464,	1,	0,	'',	'﻿J',	0,	3,	0),
(3155,	'玛多县',	'﻿MaDuoXian',	464,	1,	0,	'',	'﻿M',	0,	3,	0),
(3156,	'玉树县',	'﻿YuShuXian',	465,	1,	0,	'',	'﻿Y',	0,	3,	0),
(3157,	'杂多县',	'﻿ZaDuoXian',	465,	1,	0,	'',	'﻿Z',	0,	3,	0),
(3158,	'称多县',	'﻿ChengDuoXian',	465,	1,	0,	'',	'﻿C',	0,	3,	0),
(3159,	'治多县',	'﻿ZhiDuoXian',	465,	1,	0,	'',	'﻿Z',	0,	3,	0),
(3160,	'囊谦县',	'﻿NangQianXian',	465,	1,	0,	'',	'﻿N',	0,	3,	0),
(3161,	'曲麻莱县',	'﻿QuMaLaiXian',	465,	1,	0,	'',	'﻿Q',	0,	3,	0),
(3162,	'格尔木市',	'﻿GeErMuShi',	466,	1,	0,	'',	'﻿G',	0,	3,	0),
(3163,	'德令哈市',	'﻿DeLingHaShi',	466,	1,	0,	'',	'﻿D',	0,	3,	0),
(3164,	'乌兰县',	'﻿WuLanXian',	466,	1,	0,	'',	'﻿W',	0,	3,	0),
(3165,	'都兰县',	'﻿DuLanXian',	466,	1,	0,	'',	'﻿D',	0,	3,	0),
(3166,	'天峻县',	'﻿TianJunXian',	466,	1,	0,	'',	'﻿T',	0,	3,	0),
(3167,	'兴庆区',	'﻿XingQingQu',	467,	1,	0,	'',	'﻿X',	0,	3,	0),
(3168,	'西夏区',	'﻿XiXiaQu',	467,	1,	0,	'',	'﻿X',	0,	3,	0),
(3169,	'金凤区',	'﻿JinFengQu',	467,	1,	0,	'',	'﻿J',	0,	3,	0),
(3170,	'永宁县',	'﻿YongNingXian',	467,	1,	0,	'',	'﻿Y',	0,	3,	0),
(3171,	'贺兰县',	'﻿HeLanXian',	467,	1,	0,	'',	'﻿H',	0,	3,	0),
(3172,	'灵武市',	'﻿LingWuShi',	467,	1,	0,	'',	'﻿L',	0,	3,	0),
(3173,	'大武口区',	'﻿DaWuKouQu',	468,	1,	0,	'',	'﻿D',	0,	3,	0),
(3174,	'惠农区',	'﻿HuiNongQu',	468,	1,	0,	'',	'﻿H',	0,	3,	0),
(3175,	'平罗县',	'﻿PingLuoXian',	468,	1,	0,	'',	'﻿P',	0,	3,	0),
(3176,	'利通区',	'﻿LiTongQu',	469,	1,	0,	'',	'﻿L',	0,	3,	0),
(3177,	'盐池县',	'﻿YanChiXian',	469,	1,	0,	'',	'﻿Y',	0,	3,	0),
(3178,	'同心县',	'﻿TongXinXian',	469,	1,	0,	'',	'﻿T',	0,	3,	0),
(3179,	'青铜峡市',	'﻿QingTongXiaShi',	469,	1,	0,	'',	'﻿Q',	0,	3,	0),
(3180,	'原州区',	'﻿YuanZhouQu',	470,	1,	0,	'',	'﻿Y',	0,	3,	0),
(3181,	'西吉县',	'﻿XiJiXian',	470,	1,	0,	'',	'﻿X',	0,	3,	0),
(3182,	'隆德县',	'﻿LongDeXian',	470,	1,	0,	'',	'﻿L',	0,	3,	0),
(3183,	'泾源县',	'﻿JingYuanXian',	470,	1,	0,	'',	'﻿J',	0,	3,	0),
(3184,	'彭阳县',	'﻿PengYangXian',	470,	1,	0,	'',	'﻿P',	0,	3,	0),
(3185,	'沙坡头区',	'﻿ShaPoTouQu',	471,	1,	0,	'',	'﻿S',	0,	3,	0),
(3186,	'中宁县',	'﻿ZhongNingXian',	471,	1,	0,	'',	'﻿Z',	0,	3,	0),
(3187,	'海原县',	'﻿HaiYuanXian',	471,	1,	0,	'',	'﻿H',	0,	3,	0),
(3188,	'天山区',	'﻿TianShanQu',	472,	1,	0,	'',	'﻿T',	0,	3,	0),
(3189,	'沙依巴克区',	'﻿ShaYiBaKeQu',	472,	1,	0,	'',	'﻿S',	0,	3,	0),
(3190,	'新市区',	'﻿XinShiQu',	472,	1,	0,	'',	'﻿X',	0,	3,	0),
(3191,	'水磨沟区',	'﻿ShuiMoGouQu',	472,	1,	0,	'',	'﻿S',	0,	3,	0),
(3192,	'头屯河区',	'﻿TouTunHeQu',	472,	1,	0,	'',	'﻿T',	0,	3,	0),
(3193,	'达坂城区',	'﻿DaBanChengQu',	472,	1,	0,	'',	'﻿D',	0,	3,	0),
(3194,	'东山区',	'﻿DongShanQu',	472,	1,	0,	'',	'﻿D',	0,	3,	0),
(3195,	'乌鲁木齐县',	'﻿WuLuMuQiXian',	472,	1,	0,	'',	'﻿W',	0,	3,	0),
(3196,	'独山子区',	'﻿DuShanZiQu',	473,	1,	0,	'',	'﻿D',	0,	3,	0),
(3197,	'克拉玛依区',	'﻿KeLaMaYiQu',	473,	1,	0,	'',	'﻿K',	0,	3,	0),
(3198,	'白碱滩区',	'﻿BaiJianTanQu',	473,	1,	0,	'',	'﻿B',	0,	3,	0),
(3199,	'乌尔禾区',	'﻿WuErHeQu',	473,	1,	0,	'',	'﻿W',	0,	3,	0),
(3200,	'吐鲁番市',	'﻿TuLuFanShi',	474,	1,	0,	'',	'﻿T',	0,	3,	0),
(3201,	'鄯善县',	'﻿ShanShanXian',	474,	1,	0,	'',	'﻿S',	0,	3,	0),
(3202,	'托克逊县',	'﻿TuoKeXunXian',	474,	1,	0,	'',	'﻿T',	0,	3,	0),
(3203,	'哈密市',	'﻿HaMiShi',	475,	1,	0,	'',	'﻿H',	0,	3,	0),
(3204,	'巴里坤哈萨克自治县',	'﻿BaLiKunHaSaKeZiZhiXian',	475,	1,	0,	'',	'﻿B',	0,	3,	0),
(3205,	'伊吾县',	'﻿YiWuXian',	475,	1,	0,	'',	'﻿Y',	0,	3,	0),
(3206,	'昌吉市',	'﻿ChangJiShi',	476,	1,	0,	'',	'﻿C',	0,	3,	0),
(3207,	'阜康市',	'﻿FuKangShi',	476,	1,	0,	'',	'﻿F',	0,	3,	0),
(3208,	'米泉市',	'﻿MiQuanShi',	476,	1,	0,	'',	'﻿M',	0,	3,	0),
(3209,	'呼图壁县',	'﻿HuTuBiXian',	476,	1,	0,	'',	'﻿H',	0,	3,	0),
(3210,	'玛纳斯县',	'﻿MaNaSiXian',	476,	1,	0,	'',	'﻿M',	0,	3,	0),
(3211,	'奇台县',	'﻿QiTaiXian',	476,	1,	0,	'',	'﻿Q',	0,	3,	0),
(3212,	'吉木萨尔县',	'﻿JiMuSaErXian',	476,	1,	0,	'',	'﻿J',	0,	3,	0),
(3213,	'木垒哈萨克自治县',	'﻿MuLeiHaSaKeZiZhiXian',	476,	1,	0,	'',	'﻿M',	0,	3,	0),
(3214,	'博乐市',	'﻿BoLeShi',	477,	1,	0,	'',	'﻿B',	0,	3,	0),
(3215,	'精河县',	'﻿JingHeXian',	477,	1,	0,	'',	'﻿J',	0,	3,	0),
(3216,	'温泉县',	'﻿WenQuanXian',	477,	1,	0,	'',	'﻿W',	0,	3,	0),
(3217,	'库尔勒市',	'﻿KuErLeShi',	478,	1,	0,	'',	'﻿K',	0,	3,	0),
(3218,	'轮台县',	'﻿LunTaiXian',	478,	1,	0,	'',	'﻿L',	0,	3,	0),
(3219,	'尉犁县',	'﻿WeiLiXian',	478,	1,	0,	'',	'﻿W',	0,	3,	0),
(3220,	'若羌县',	'﻿RuoQiangXian',	478,	1,	0,	'',	'﻿R',	0,	3,	0),
(3221,	'且末县',	'﻿QieMoXian',	478,	1,	0,	'',	'﻿Q',	0,	3,	0),
(3222,	'焉耆回族自治县',	'﻿YanQiHuiZuZiZhiXian',	478,	1,	0,	'',	'﻿Y',	0,	3,	0),
(3223,	'和静县',	'﻿HeJingXian',	478,	1,	0,	'',	'﻿H',	0,	3,	0),
(3224,	'和硕县',	'﻿HeShuoXian',	478,	1,	0,	'',	'﻿H',	0,	3,	0),
(3225,	'博湖县',	'﻿BoHuXian',	478,	1,	0,	'',	'﻿B',	0,	3,	0),
(3226,	'阿克苏市',	'﻿AKeSuShi',	479,	1,	0,	'',	'﻿A',	0,	3,	0),
(3227,	'温宿县',	'﻿WenSuXian',	479,	1,	0,	'',	'﻿W',	0,	3,	0),
(3228,	'库车县',	'﻿KuCheXian',	479,	1,	0,	'',	'﻿K',	0,	3,	0),
(3229,	'沙雅县',	'﻿ShaYaXian',	479,	1,	0,	'',	'﻿S',	0,	3,	0),
(3230,	'新和县',	'﻿XinHeXian',	479,	1,	0,	'',	'﻿X',	0,	3,	0),
(3231,	'拜城县',	'﻿BaiChengXian',	479,	1,	0,	'',	'﻿B',	0,	3,	0),
(3232,	'乌什县',	'﻿WuShiXian',	479,	1,	0,	'',	'﻿W',	0,	3,	0),
(3233,	'阿瓦提县',	'﻿AWaTiXian',	479,	1,	0,	'',	'﻿A',	0,	3,	0),
(3234,	'柯坪县',	'﻿KePingXian',	479,	1,	0,	'',	'﻿K',	0,	3,	0),
(3235,	'阿图什市',	'﻿ATuShiShi',	480,	1,	0,	'',	'﻿A',	0,	3,	0),
(3236,	'阿克陶县',	'﻿AKeTaoXian',	480,	1,	0,	'',	'﻿A',	0,	3,	0),
(3237,	'阿合奇县',	'﻿AHeQiXian',	480,	1,	0,	'',	'﻿A',	0,	3,	0),
(3238,	'乌恰县',	'﻿WuQiaXian',	480,	1,	0,	'',	'﻿W',	0,	3,	0),
(3239,	'喀什市',	'﻿KaShiShi',	481,	1,	0,	'',	'﻿K',	0,	3,	0),
(3240,	'疏附县',	'﻿ShuFuXian',	481,	1,	0,	'',	'﻿S',	0,	3,	0),
(3241,	'疏勒县',	'﻿ShuLeXian',	481,	1,	0,	'',	'﻿S',	0,	3,	0),
(3242,	'英吉沙县',	'﻿YingJiShaXian',	481,	1,	0,	'',	'﻿Y',	0,	3,	0),
(3243,	'泽普县',	'﻿ZePuXian',	481,	1,	0,	'',	'﻿Z',	0,	3,	0),
(3244,	'莎车县',	'﻿SuoCheXian',	481,	1,	0,	'',	'﻿S',	0,	3,	0),
(3245,	'叶城县',	'﻿YeChengXian',	481,	1,	0,	'',	'﻿Y',	0,	3,	0),
(3246,	'麦盖提县',	'﻿MaiGaiTiXian',	481,	1,	0,	'',	'﻿M',	0,	3,	0),
(3247,	'岳普湖县',	'﻿YuePuHuXian',	481,	1,	0,	'',	'﻿Y',	0,	3,	0),
(3248,	'伽师县',	'﻿QieShiXian',	481,	1,	0,	'',	'﻿Q',	0,	3,	0),
(3249,	'巴楚县',	'﻿BaChuXian',	481,	1,	0,	'',	'﻿B',	0,	3,	0),
(3250,	'塔什库尔干塔吉克自治县',	'﻿TaShiKuErGanTaJiKeZiZhiXian',	481,	1,	0,	'',	'﻿T',	0,	3,	0),
(3251,	'和田市',	'﻿HeTianShi',	482,	1,	0,	'',	'﻿H',	0,	3,	0),
(3252,	'和田县',	'﻿HeTianXian',	482,	1,	0,	'',	'﻿H',	0,	3,	0),
(3253,	'墨玉县',	'﻿MoYuXian',	482,	1,	0,	'',	'﻿M',	0,	3,	0),
(3254,	'皮山县',	'﻿PiShanXian',	482,	1,	0,	'',	'﻿P',	0,	3,	0),
(3255,	'洛浦县',	'﻿LuoPuXian',	482,	1,	0,	'',	'﻿L',	0,	3,	0),
(3256,	'策勒县',	'﻿CeLeXian',	482,	1,	0,	'',	'﻿C',	0,	3,	0),
(3257,	'于田县',	'﻿YuTianXian',	482,	1,	0,	'',	'﻿Y',	0,	3,	0),
(3258,	'民丰县',	'﻿MinFengXian',	482,	1,	0,	'',	'﻿M',	0,	3,	0),
(3259,	'伊宁市',	'﻿YiNingShi',	483,	1,	0,	'',	'﻿Y',	0,	3,	0),
(3260,	'奎屯市',	'﻿KuiTunShi',	483,	1,	0,	'',	'﻿K',	0,	3,	0),
(3261,	'伊宁县',	'﻿YiNingXian',	483,	1,	0,	'',	'﻿Y',	0,	3,	0),
(3262,	'察布查尔锡伯自治县',	'﻿ChaBuChaErXiBoZiZhiXian',	483,	1,	0,	'',	'﻿C',	0,	3,	0),
(3263,	'霍城县',	'﻿HuoChengXian',	483,	1,	0,	'',	'﻿H',	0,	3,	0),
(3264,	'巩留县',	'﻿GongLiuXian',	483,	1,	0,	'',	'﻿G',	0,	3,	0),
(3265,	'新源县',	'﻿XinYuanXian',	483,	1,	0,	'',	'﻿X',	0,	3,	0),
(3266,	'昭苏县',	'﻿ZhaoSuXian',	483,	1,	0,	'',	'﻿Z',	0,	3,	0),
(3267,	'特克斯县',	'﻿TeKeSiXian',	483,	1,	0,	'',	'﻿T',	0,	3,	0),
(3268,	'尼勒克县',	'﻿NiLeKeXian',	483,	1,	0,	'',	'﻿N',	0,	3,	0),
(3269,	'塔城市',	'﻿TaChengShi',	484,	1,	0,	'',	'﻿T',	0,	3,	0),
(3270,	'乌苏市',	'﻿WuSuShi',	484,	1,	0,	'',	'﻿W',	0,	3,	0),
(3271,	'额敏县',	'﻿EMinXian',	484,	1,	0,	'',	'﻿E',	0,	3,	0),
(3272,	'沙湾县',	'﻿ShaWanXian',	484,	1,	0,	'',	'﻿S',	0,	3,	0),
(3273,	'托里县',	'﻿TuoLiXian',	484,	1,	0,	'',	'﻿T',	0,	3,	0),
(3274,	'裕民县',	'﻿YuMinXian',	484,	1,	0,	'',	'﻿Y',	0,	3,	0),
(3275,	'和布克赛尔蒙古自治县',	'﻿HeBuKeSaiErMengGuZiZhiXian',	484,	1,	0,	'',	'﻿H',	0,	3,	0),
(3276,	'阿勒泰市',	'﻿ALeTaiShi',	485,	1,	0,	'',	'﻿A',	0,	3,	0),
(3277,	'布尔津县',	'﻿BuErJinXian',	485,	1,	0,	'',	'﻿B',	0,	3,	0),
(3278,	'富蕴县',	'﻿FuYunXian',	485,	1,	0,	'',	'﻿F',	0,	3,	0),
(3279,	'福海县',	'﻿FuHaiXian',	485,	1,	0,	'',	'﻿F',	0,	3,	0),
(3280,	'哈巴河县',	'﻿HaBaHeXian',	485,	1,	0,	'',	'﻿H',	0,	3,	0),
(3281,	'青河县',	'﻿QingHeXian',	485,	1,	0,	'',	'﻿Q',	0,	3,	0),
(3282,	'吉木乃县',	'﻿JiMuNaiXian',	485,	1,	0,	'',	'﻿J',	0,	3,	0),
(3358,	'钓鱼岛',	'DiaoYuDao',	1,	1,	0,	'',	'﻿D',	0,	1,	23),
(3359,	'钓鱼岛',	'DiaoYuDao',	3358,	1,	0,	'',	'﻿D',	0,	2,	0),
(3360,	'北京市',	'﻿BeiJingShi',	2,	1,	0,	'',	'﻿B',	0,	2,	0),
(3361,	'上海市',	'﻿ShangHaiShi',	3,	1,	0,	'',	'﻿S',	0,	2,	0),
(3362,	'天津市',	'﻿TianJinShi',	4,	1,	0,	'',	'﻿T',	0,	2,	0),
(3363,	'重庆市',	'﻿ZhongQingShi',	5,	1,	0,	'',	'﻿Z',	0,	2,	0);

DROP TABLE IF EXISTS `hanchao_article`;
CREATE TABLE `hanchao_article` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文章ID',
  `catid` smallint(5) unsigned NOT NULL COMMENT '属性ID',
  `title` varchar(200) NOT NULL COMMENT '文章标题',
  `thumb` varchar(200) NOT NULL COMMENT '文章图片',
  `content` text NOT NULL COMMENT '文章内容',
  `uid` int(10) unsigned NOT NULL COMMENT '文章作者关联会有',
  `fileurl` varchar(255) NOT NULL COMMENT '文件url',
  `addtime` int(10) NOT NULL DEFAULT '0' COMMENT '文章添加时间',
  `updatetime` int(10) NOT NULL DEFAULT '0' COMMENT '文章更新时间',
  `count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点击量',
  `sort` smallint(5) NOT NULL DEFAULT '10' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否显示',
  `seotitle` varchar(255) NOT NULL COMMENT 'Seo标题',
  `seokeywords` varchar(255) NOT NULL COMMENT 'Seo关键字',
  `seodescription` varchar(255) NOT NULL COMMENT 'Seo描述',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='文章表';

INSERT INTO `hanchao_article` (`id`, `catid`, `title`, `thumb`, `content`, `uid`, `fileurl`, `addtime`, `updatetime`, `count`, `sort`, `status`, `seotitle`, `seokeywords`, `seodescription`) VALUES
(10,	4,	'商城问答',	'',	'商城正在如火如荼的举行着双十一购物狂欢节的时候商城问答在这段时间里正式要修炼内功的时候，将会产生大量的精华知识小报，然后输送到各个频道页面和资源位上，让咱们的知识无处不在！\r\n',	1,	'',	1433141203,	1433145643,	7,	10,	1,	'商城问答',	'商城问答',	'商城问答'),
(11,	4,	'活动专区',	'',	'商城12周年年中促;每年仅次于双11和双12的大促，是上半年中商城;牛B的官方招商活动。\r\n本次大促针对：商城集市卖家本次参加大促的淘宝行业：女装、男装、内衣、男女鞋、箱包、服饰配件、运动户外',	1,	'',	1433141708,	1433141708,	6,	10,	1,	'活动专区',	'活动专区',	'活动专区'),
(12,	7,	'联系客服',	'',	'&lt;p&gt;\r\n	&amp;nbsp;服务时间：每日08：00-18：00\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;客服热线：0311-82039068\r\n&lt;/p&gt;',	1,	'',	1433229510,	1440119757,	32,	20,	1,	'联系客服',	'联系客服',	'联系客服'),
(13,	7,	'购物流程',	'',	'&lt;p&gt;\r\n	（1）您可以通过在首页输入关键字的方法来搜索您想要购买的商品。\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	（2）挑选商品后，在商品详细页面点击“购买”按钮，将商品放入购物车中。\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	（3）在购物车中，系统默认每件商品的订购数量为1件，如果您想购买多件商品，可修改购买数量。\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	（4）再提交订单后，选择“付款方式”进行多种方式进行支付。\r\n&lt;/p&gt;',	1,	'',	1433229597,	1440118875,	13,	10,	1,	'购物流程',	'购物流程',	'购物流程'),
(14,	7,	'注册会员',	'',	'&lt;p&gt;\r\n	&amp;nbsp;&lt;span style=&quot;color:#333333;&quot;&gt;新会员注册：请点击首页顶部右上角“注册”进入注册页面后输入用户名、密码、手机号及验证码，按照提示完成注册。&lt;/span&gt;\r\n&lt;/p&gt;',	1,	'',	1433229645,	1440119898,	12,	10,	1,	'注册会员',	'注册会员',	'注册会员'),
(15,	8,	'到体验厅支付',	'',	'到体验厅支付',	1,	'',	1433229684,	1440123798,	13,	10,	1,	'到体验厅支付',	'到体验厅支付',	'到体验厅支付'),
(16,	8,	'支付方式说明',	'',	'&lt;p&gt;\r\n	提供多种支付方式，订购过程中您可以选择：\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot; class=&quot;txt_indent&quot;&gt;\r\n	（1）微信支付\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot; class=&quot;txt_indent&quot;&gt;\r\n	（2）支付宝转账\r\n&lt;/p&gt;\r\n支付方式具体请以订单提交页信息为准。',	1,	'',	1433229737,	1448336153,	16,	10,	1,	'支付方式说明',	'支付方式说明',	'支付方式说明'),
(17,	8,	'配送费用查询',	'',	'订单金额达到一定数量，免运费；否则运费需支付一定的费用，具体请关注网站最新信息。',	1,	'',	1433229786,	1448335971,	12,	10,	1,	'配送费用查询',	'配送费用查询',	'配送费用查询'),
(18,	9,	'售后保修条款',	'',	'&lt;p&gt;\r\n	无理由退货政策\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	1. 汉潮承诺，对于您（作为消费者）通过网站购买的商品，若商品能够保持出售时原状，则自商品收货之日起，可享受“7天无理由退货”政策，您可&lt;a class=&quot;blue_link&quot; href=&quot;http://www.hanchao9999.com;&quot;&gt;在线进行申请退货&lt;/a&gt;；并需自行将商品寄回且承担相关运费；&lt;span style=&quot; color:#cc0000;&quot; =&quot;&quot;=&quot;&quot;&gt;但根据法律规定及商品性质，如下商品不享受“7天无理由退货”政策： &lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot; class=&quot;txt_indent&quot;&gt;\r\n	&lt;a class=&quot;blue_link&quot; href=&quot;http://www.hanchao9999.com;&gt;在线进行申请退货&lt;/a&gt;；并需自行将商品寄回且承担相关运费；&lt;span style=&quot; color:#cc0000;&quot;=&quot;&quot;&gt;（1）消费者定作商品；&lt;/a&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot; class=&quot;txt_indent&quot;&gt;\r\n	&lt;a class=&quot;blue_link&quot; href=&quot;http://www.hanchao9999.com;&gt;在线进行申请退货&lt;/a&gt;；并需自行将商品寄回且承担相关运费；&lt;span style=&quot; color:#cc0000;&quot;=&quot;&quot;&gt;（2）鲜活易腐商品，例如鲜花、绿植、果蔬、低温乳品、速冻食品等；&lt;/a&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot; class=&quot;txt_indent&quot;&gt;\r\n	&lt;a class=&quot;blue_link&quot; href=&quot;http://www.hanchao9999.com;&gt;在线进行申请退货&lt;/a&gt;；并需自行将商品寄回且承担相关运费；&lt;span style=&quot; color:#cc0000;&quot;=&quot;&quot;&gt;（3）在线下载或消费者拆封的音像制品、计算机软件等数字化商品；&lt;/a&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot; class=&quot;txt_indent&quot;&gt;\r\n	&lt;a class=&quot;blue_link&quot; href=&quot;http://www.hanchao9999.com;&gt;在线进行申请退货&lt;/a&gt;；并需自行将商品寄回且承担相关运费；&lt;span style=&quot; color:#cc0000;&quot;=&quot;&quot;&gt;（4）交付的报纸、期刊类商品；&lt;/a&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot; class=&quot;txt_indent&quot;&gt;\r\n	&lt;a class=&quot;blue_link&quot; href=&quot;http://www.hanchao9999.com;&gt;在线进行申请退货&lt;/a&gt;；并需自行将商品寄回且承担相关运费；&lt;span style=&quot; color:#cc0000;&quot;=&quot;&quot;&gt;（5）食用类商品，例如食品、保健品、饮料、药品、酒类、奶粉、婴儿辅食等；&lt;/a&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot; class=&quot;txt_indent&quot;&gt;\r\n	&lt;a class=&quot;blue_link&quot; href=&quot;http://www.hanchao9999.com;&gt;在线进行申请退货&lt;/a&gt;；并需自行将商品寄回且承担相关运费；&lt;span style=&quot; color:#cc0000;&quot;=&quot;&quot;&gt;（6）贵重类商品，例如钻石、贵金属、手表、珠宝、奢侈品等；&lt;/a&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot; class=&quot;txt_indent&quot;&gt;\r\n	&lt;a class=&quot;blue_link&quot; href=&quot;http://www.hanchao9999.com;&gt;在线进行申请退货&lt;/a&gt;；并需自行将商品寄回且承担相关运费；&lt;span style=&quot; color:#cc0000;&quot;=&quot;&quot;&gt;（7）个人护理、贴身类商品，例如计生用品、美护、内衣、贴身袜裤等；；&lt;/a&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot; class=&quot;txt_indent&quot;&gt;\r\n	&lt;a class=&quot;blue_link&quot; href=&quot;http://www.hanchao9999.com;&gt;在线进行申请退货&lt;/a&gt;；并需自行将商品寄回且承担相关运费；&lt;span style=&quot; color:#cc0000;&quot;=&quot;&quot;&gt;（8）虚拟类商品，例如礼品卡、手机充值、游戏点卡等充值类商品，以及门票、机票、旅游套餐等一次性消费服务类商品等；&lt;/a&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot; class=&quot;txt_indent&quot;&gt;\r\n	&lt;a class=&quot;blue_link&quot; href=&quot;http://www.hanchao9999.com;&gt;在线进行申请退货&lt;/a&gt;；并需自行将商品寄回且承担相关运费；&lt;span style=&quot; color:#cc0000;&quot;=&quot;&quot;&gt;（9）特殊类商品，例如运营商合约手机以及二手品、处理品等；&lt;/a&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot; class=&quot;txt_indent&quot;&gt;\r\n	&lt;a class=&quot;blue_link&quot; href=&quot;http://www.hanchao9999.com;&gt;在线进行申请退货&lt;/a&gt;；并需自行将商品寄回且承担相关运费；&lt;span style=&quot; color:#cc0000;&quot;=&quot;&quot;&gt;（10）其他根据商品性质不宜退货的商品。&lt;/a&gt; \r\n&lt;/p&gt;',	1,	'',	1433230050,	1503474724,	22,	10,	1,	'售后保修条款',	'售后保修条款',	'售后保修条款'),
(19,	9,	'产品质量保证',	'',	'&lt;p&gt;\r\n	正品保障\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp; 严格挑选授权供应商，所有销售商品均为正品行货，请您放心选购。如出现非正品情况，您可以凭质检部门出具的鉴定函，通过“在线投诉”提交申请。经客服核实确认后，将退还您为该商品支付的金额，并按照该商品的金额给予三倍返利至您的账户。\r\n&lt;/p&gt;',	1,	'',	1433230096,	1440120880,	9,	10,	1,	'产品质量保证',	'产品质量保证',	'产品质量保证'),
(20,	9,	'发票制度说明',	'',	'&lt;p&gt;\r\n	一、 发票开具\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp; 1、所有商品发票均由所属销售商家负责开具，且所有开具的发票均为合法有效。\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp; 2、顾客在结算过程中可以选择是否开具发票，商家会按照顾客的选择为顾客开具发票。\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp; 3、所有商品仅按顾客实付现金金额开具发票，不包括抵用券、返利金额、礼品卡等金额部分。\r\n&lt;/p&gt;',	1,	'',	1433230144,	1440121318,	15,	10,	1,	'发票制度说明',	'发票制度说明',	'发票制度说明'),
(22,	10,	'我的收藏',	'',	'&lt;p&gt;\r\n	查看我的收藏\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp; 会员登录后可以可以在“收藏夹”页面点击查询\r\n&lt;/p&gt;',	1,	'',	1433230224,	1440121971,	16,	10,	1,	'我的收藏',	'我的收藏',	'我的收藏'),
(23,	10,	'积分兑换',	'',	'&lt;p&gt;\r\n	积分可以兑换商家指定商品。\r\n&lt;/p&gt;',	1,	'',	1433230267,	1440123904,	15,	10,	1,	'积分兑换',	'积分兑换',	'积分兑换'),
(24,	7,	'常见问题',	'',	'&lt;p&gt;\r\n	1：登录网站总是无法链接，这是怎么回事？\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&amp;nbsp;&amp;nbsp;请您先刷新一下；或者检查一下网络是否正常，能否登录其它网站，如果以上两种方式都无效，还有一种情况是网页正在更新，可能会影响您的浏览，还望能谅解。\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	2：网站上面显示商品已售完请问什么时候可以在到货？\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&amp;nbsp;&amp;nbsp;一般补货时间是7-15个工作日，具体还是以网站信息为准。\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	3：此类商品的规格是什么？性能怎样？\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&amp;nbsp;&amp;nbsp;具体商品规格参数及性能问题请您关注商品页面信息，也可以联系厂家电话咨询，或者在商品页面下方发表商品咨询，会有专业人员为您解答！\r\n&lt;/p&gt;',	1,	'',	1433231202,	1440121689,	16,	10,	1,	'集团购买',	'集团购买',	'集团购买'),
(25,	8,	'配货发货时间',	'',	'&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-family:宋体;font-size:10.5pt;&quot;&gt;&lt;span style=&quot;font-size:12px;&quot;&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 送货时间每天早&lt;/span&gt;&lt;span style=&quot;font-size:12px;&quot;&gt;8:00--&amp;nbsp;19:00,&lt;/span&gt;&lt;span style=&quot;font-size:12px;&quot;&gt;以系统的付款时间为准，&lt;/span&gt;&lt;span style=&quot;font-size:12px;&quot;&gt;19&lt;/span&gt;&lt;span style=&quot;font-size:12px;&quot;&gt;：&lt;/span&gt;&lt;span style=&quot;font-size:12px;&quot;&gt;00&lt;/span&gt;&lt;span style=&quot;font-size:12px;&quot;&gt;以后付款的订单，按照付款时间第二天的第一时间为您安排配送！&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-family:宋体;font-size:10.5pt;&quot;&gt;&lt;/span&gt;\r\n&lt;/p&gt;',	1,	'',	1433231301,	1440124917,	23,	10,	1,	'配货发货时间',	'配货发货时间',	'配货发货时间'),
(27,	10,	'我的订单',	'',	'&lt;p&gt;\r\n	查看订单\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp; 登录后，您可以点击页面中间的&quot;我的订单&quot;查看&quot;。\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	取消订单\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp; 当订单为&quot;待支付&quot;、&quot;待处理&quot;状态时您可以进入&quot;我的订单&quot;页面点击&quot;取消订单&quot;即可。\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	修改订单\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp; 当订单为&quot;待支付&quot;的状态时您可以进入&quot;我的订单&quot;页面点击&quot;修改订单&quot;进行修改。\r\n&lt;/p&gt;',	1,	'',	1433231397,	1440121838,	19,	10,	1,	'我的订单',	'我的订单',	'我的订单'),
(35,	10,	'商家入驻流程',	'',	'登录汉潮网站,注册会员登录，进入会员中心，申请商家入驻。',	1,	'',	1446190636,	1467788855,	46,	10,	1,	'',	'',	''),
(36,	9,	'24小时发货',	'',	'&lt;span style=&quot;color:#666666;font-family:宋体;line-height:24px;font-size:16px;&quot;&gt; \r\n&lt;div&gt;\r\n	汉潮承诺，下单后24小时之内发货\r\n&lt;/div&gt;\r\n&lt;/span&gt;',	1,	'',	1447483247,	1448335900,	22,	10,	1,	'24小时发货',	'24小时发货',	'24小时发货'),
(45,	4,	'服务协议',	'',	'&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;&lt;span&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp; &lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:宋体;color:black;&quot;&gt;汉潮电子商务服务协议&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;&amp;nbsp;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-size:13.5pt;font-family:宋体;color:black;&quot;&gt;账户注册与使用&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;1&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:宋体;color:black;&quot;&gt;、&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt; &lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:宋体;color:black;&quot;&gt;用户资格&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot; style=&quot;text-indent:20.25pt;&quot;&gt;\r\n	&lt;span style=&quot;font-size:13.5pt;font-family:宋体;color:black;&quot;&gt;您确认在您开始注册程序使用汉潮平台服务前，您应当具备中华人民共和国法律规定的与您行为相适应的民事行为能力。若您不具备前述与您行为相适应的民事行为能力，则您及您的监护人应依照法律规定承担因此而导致的一切后果。&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;2&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:宋体;color:black;&quot;&gt;、&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt; &lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:宋体;color:black;&quot;&gt;账户说明&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;:&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot; style=&quot;text-indent:20.25pt;&quot;&gt;\r\n	&lt;span style=&quot;font-size:13.5pt;font-family:宋体;color:black;&quot;&gt;【账户获得】当您按照注册页面提示填写信息、阅读并同意本协议且完成全部注册程序后，您可获得汉潮平台账户并成为汉潮平台用户。&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot; style=&quot;text-indent:20.25pt;&quot;&gt;\r\n	&lt;span style=&quot;font-size:13.5pt;font-family:宋体;color:black;&quot;&gt;【账户使用】您有权使用您设置或确认的汉潮会员名、邮箱、手机号码（以下简称&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;“&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:宋体;color:black;&quot;&gt;账户名称&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;”&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:宋体;color:black;&quot;&gt;）或第三方合作方式（腾讯&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;QQ&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:宋体;color:black;&quot;&gt;、微信号）及您设置的密码（账户名称及密码合称&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;“&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:宋体;color:black;&quot;&gt;账户&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;”&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:宋体;color:black;&quot;&gt;）登录汉潮平台。&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot; style=&quot;text-indent:20.25pt;&quot;&gt;\r\n	&lt;span style=&quot;font-size:13.5pt;font-family:宋体;color:black;&quot;&gt;【账户转让】由于用户账户关联用户信用信息，仅当有法律明文规定、司法裁定或经汉潮同意，并符合汉潮平台规则规定的用户账户转让流程的情况下，您可进行账户的转让。您的账户一经转让，该账户项下权利义务一并转移。除此外，您的账户不得以任何方式转让，否则由此产生的一切责任均由您承担。&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot; style=&quot;text-indent:20.25pt;&quot;&gt;\r\n	&lt;span style=&quot;font-size:13.5pt;font-family:宋体;color:black;&quot;&gt;【实名认证】作为汉潮平台经营者，法律并未赋予汉潮强制要求所有用户进行支付宝实名认证的权力，但为使您更好地使用汉潮平台的各项服务，汉潮建议您按照支付宝公司要求及我国法律规定完成实名认证。&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot; style=&quot;text-indent:6.75pt;&quot;&gt;\r\n	&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;3&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:宋体;color:black;&quot;&gt;、&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt; &lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:宋体;color:black;&quot;&gt;注册信息管理&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot; style=&quot;text-indent:13.5pt;&quot;&gt;\r\n	&lt;span style=&quot;font-size:13.5pt;font-family:宋体;color:black;&quot;&gt;【信息真实】在使用汉潮平台服务时，您应当按汉潮平台页面的提示准确完整地提供您的信息（包括您的姓名及电子邮件地址、联系电话、联系地址等），以便汉潮或其他用户与您联系。您了解并同意，您有义务保持您提供信息的真实性及有效性。&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot; style=&quot;text-indent:13.5pt;&quot;&gt;\r\n	&lt;span style=&quot;font-size:13.5pt;font-family:宋体;color:black;&quot;&gt;【合法性】您设置的汉潮会员名不得违反国家法律法规及汉潮网规则关于会员名的管理规定，否则汉潮可回收您的汉潮会员名。汉潮会员名的回收不影响您以邮箱、手机号码登录汉潮平台并使用汉潮平台服务。&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot; style=&quot;text-indent:13.5pt;&quot;&gt;\r\n	&lt;span style=&quot;font-size:13.5pt;font-family:宋体;color:black;&quot;&gt;【账户安全保管义务】您的账户为您自行设置并由您保管，汉潮任何时候均不会主动要求您提供您的账户。因此，建议您务必保管好您的账户，&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt; &lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:宋体;color:black;&quot;&gt;并确保您在每个上网时段结束时退出登录并以正确步骤离开汉潮平台。账户因您主动泄露或遭受他人攻击、诈骗等行为导致的损失及后果，均由您自行承担。&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot; style=&quot;text-indent:13.5pt;&quot;&gt;\r\n	&lt;span style=&quot;font-size:13.5pt;font-family:宋体;color:black;&quot;&gt;【账户行为责任自负】除汉潮存在过错外，您应对您账户项下的所有行为结果（包括但不限于在线签署各类协议、发布信息、购买商品及服务及披露信息等）负责。&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot; style=&quot;text-indent:13.5pt;&quot;&gt;\r\n	&lt;span style=&quot;font-size:13.5pt;font-family:宋体;color:black;&quot;&gt;【日常维护须知】如发现任何未经授权使用您账户登录汉潮平台或其他可能导致您账户遭窃、遗失的情况，建议您立即通知汉潮，并授权汉潮将该信息同步平台。您理解汉潮对您的任何请求采取行动均需要合理时间，除汉潮存在过错外，汉潮对在采取行动前已经产生的后果不承担任何责任。&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot; style=&quot;text-indent:13.5pt;&quot;&gt;\r\n	&lt;span style=&quot;font-size:13.5pt;font-family:宋体;color:black;&quot;&gt; &lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;div style=&quot;font-family:宋体;font-size:14px;text-align:center;&quot;&gt;\r\n	&lt;span style=&quot;line-height:2;font-size:10.5pt;&quot;&gt;&amp;nbsp;Copyright&lt;/span&gt;&lt;span style=&quot;line-height:2;font-size:10.5pt;&quot;&gt;&amp;copy;&lt;/span&gt;&lt;span style=&quot;line-height:2;font-size:10.5pt;&quot;&gt;2017-2020&lt;/span&gt; \r\n&lt;/div&gt;\r\n&lt;div style=&quot;font-family:宋体;font-size:14px;text-align:center;&quot;&gt;\r\n	&lt;span style=&quot;line-height:2;font-size:10.5pt;&quot;&gt;石家庄久途网络科技有限公司&amp;nbsp;&lt;/span&gt; \r\n&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;p&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;',	1,	'',	1448499723,	1503473957,	20,	10,	1,	'服务协议',	'服务协议',	'服务协议'),
(46,	2,	'汉潮商城系统定制流程介绍',	'',	'&lt;div class=&quot;takeaway&quot; style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;b&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;导读：&lt;/span&gt;&lt;/b&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;定制业务是在汉潮P2P系统的基础上,为高端客户实现个性化的定制开发服务,包含UI设计、个性化功能开发、APP定制开发、微信及微博认证开发、服务器门户级部署、开源码授权等一系列定制服务。&lt;/span&gt; \r\n&lt;/div&gt;\r\n&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;img src=&quot;http://hanchao9999.com/uploads/image/20151204/15491521069.png&quot; /&gt; \r\n&lt;/div&gt;\r\n&lt;p style=&quot;text-align:justify;text-indent:0pt;&quot; class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-family:宋体;font-size:10.5pt;font-weight:normal;&quot;&gt;&lt;strong&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;&amp;nbsp; 汉潮&lt;/span&gt;&lt;/strong&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;&lt;strong&gt;P2P&lt;/strong&gt;&lt;/span&gt;&lt;span&gt;&lt;strong&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;系统&lt;/span&gt;&lt;/strong&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;是久途网络旗下开发的一款针对&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;P2P&lt;/span&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;平台的&lt;/span&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;P2P&lt;/span&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;系统软件。很多用户对汉潮&lt;/span&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;P2P&lt;/span&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;系统不是很了解也不太了解汉潮&lt;/span&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;P2P&lt;/span&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;系统的定制流程是怎样的，那么就这个问题久途网络在这里解答一下，这里着重介绍一下汉潮&lt;/span&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;P2P&lt;/span&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;系统定制版的业务。&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-family:宋体;font-size:10.5pt;font-weight:normal;&quot;&gt;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;text-indent:0pt;&quot; class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-family:宋体;font-size:10.5pt;font-weight:normal;&quot;&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;定制业务是在&lt;/span&gt;&lt;strong&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;汉潮&lt;/span&gt;&lt;/strong&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;&lt;strong&gt;P2P&lt;/strong&gt;&lt;/span&gt;&lt;span&gt;&lt;strong&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;系统&lt;/span&gt;&lt;/strong&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;的基础上&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;,&lt;/span&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;为高端客户实现个性化的定制开发服务&lt;/span&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;,&lt;/span&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;包含&lt;/span&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;UI&lt;/span&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;设计、个性化功能开发、&lt;/span&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;APP&lt;/span&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;定制开发、微信及微博认证开发、服务器门户级部署、开源码授权等一系列定制服务。&lt;/span&gt;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;span style=&quot;font-family:宋体;font-size:10.5pt;font-weight:normal;&quot;&gt; \r\n&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;strong&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';color:#333333;line-height:2;&quot;&gt;汉潮P2P系统&lt;/span&gt;&lt;/strong&gt;&lt;span style=&quot;line-height:2;font-family:\'Microsoft YaHei\';color:#333333;&quot;&gt;为您提供一站式服务，为您私人定制P2P系统。&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;span style=&quot;line-height:2;font-family:\'Microsoft YaHei\';color:#333333;&quot;&gt; &lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;div&gt;\r\n	&amp;nbsp;\r\n	&lt;div&gt;\r\n		&lt;div style=&quot;text-align:center;&quot;&gt;\r\n			&lt;span style=&quot;line-height:2;font-size:10.5pt;&quot;&gt;&amp;nbsp;Copyright&lt;/span&gt;&lt;span style=&quot;line-height:2;font-size:10.5pt;&quot;&gt;&amp;copy;&lt;/span&gt;&lt;span style=&quot;line-height:2;font-size:10.5pt;&quot;&gt;2017-2020&lt;/span&gt; \r\n		&lt;/div&gt;\r\n		&lt;div style=&quot;text-align:center;&quot;&gt;\r\n			&lt;span style=&quot;line-height:2;font-size:10.5pt;&quot;&gt;石家庄久途网络科技有限公司&amp;nbsp;&lt;/span&gt; \r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/span&gt; \r\n&lt;p&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;',	1,	'',	1450769818,	1503474356,	1,	10,	1,	'',	'',	''),
(47,	2,	'如何选择网上商城系统',	'',	'&lt;div class=&quot;takeaway&quot; style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;b&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;导读：&lt;/span&gt;&lt;/b&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;国内的网络市场如火如荼的发展着，面对如此巨大的网购市场，许多企业都希望搭建自己的网上商城，把生意拓展到网上去，在这其中，首要的就是选择好的网店系统，使用一款好的商城系统来搭建自己的官方平台，以此来开拓市场。&lt;/span&gt;\r\n&lt;/div&gt;\r\n&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;\r\n&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;img src=&quot;http://hanchao9999.com/uploads/image/20151218/10035186693.jpg&quot; /&gt;\r\n&lt;/div&gt;\r\n&lt;p style=&quot;text-align:justify;text-indent:0pt;&quot; class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-family:宋体;font-size:10.5pt;font-weight:normal;&quot;&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp;随着网上购物的流行与火爆，人们对于&lt;/span&gt;&lt;strong&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;网上商城系统&lt;/span&gt;&lt;/strong&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;的建设和开发充满了些许的好奇心，那么石家庄&lt;/span&gt;&lt;strong&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;网上商城系统&lt;/span&gt;&lt;/strong&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;汉潮&lt;/span&gt;&lt;strong&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;网上商城系统&lt;/span&gt;&lt;/strong&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;为您解答一二。&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-family:宋体;font-size:10.5pt;font-weight:normal;&quot;&gt;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;text-indent:0pt;&quot; class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-family:宋体;font-size:10.5pt;font-weight:normal;&quot;&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;&amp;nbsp; 国内的网络市场如火如荼的发展着，面对如此巨大的网购市场，许多企业都希望搭建自己的网上商城，把生意拓展到网上去，在这其中，首要的就是选择好的网店系统，使用一款好的商城系统来搭建自己的官方平台，以此来开拓市场。如今&lt;/span&gt;&lt;strong&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;网上商城系统&lt;/span&gt;&lt;/strong&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;可\r\n谓是五花八门，专门负责开发商城系统的企业也不胜枚举。因而企业在购买网上商城软件时，难免会感到头疼：究竟什么样的商城系统才算好呢？一般来说，评判一\r\n套在线商城系统的优劣，主要参考指标有系统的安全性、易用性、功能、速度、存储容量、搜索引擎友好性以及营销方案的多样性。作为企业级SaaS独立电商服\r\n务提供商，汉潮商城系统以优质的电商软件系统获得业界的一致好评！除了这几点以外还要注意营销方案的多样性，如今促销优惠活动已成为吸引消费者、提高商城\r\n流量和订单量最常见的做法。汉潮电商系统软件，其内置丰富的营销方案，如站内信、短信及邮件、积分奖励、团购、限时秒杀、满额包邮、自定义主题促销等。在\r\n同类型的网店系统中有着无可比拟的优势。&amp;nbsp;&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-family:宋体;font-size:10.5pt;font-weight:normal;&quot;&gt;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;span style=&quot;font-family:宋体;font-size:10.5pt;font-weight:normal;&quot;&gt;\r\n&lt;div style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';color:#333333;line-height:2;&quot;&gt;&amp;nbsp; 选择&lt;/span&gt;&lt;strong&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';color:#333333;line-height:2;&quot;&gt;网上商城系统&lt;/span&gt;&lt;/strong&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';color:#333333;line-height:2;&quot;&gt;汉潮&lt;/span&gt;&lt;strong&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';color:#333333;line-height:2;&quot;&gt;网上商城系统&lt;/span&gt;&lt;/strong&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';color:#333333;line-height:2;&quot;&gt;提醒用户一定要谨慎，要找一家专业高效的网站来做，这样才能达到双赢。&lt;/span&gt;\r\n&lt;/div&gt;\r\n&lt;/span&gt;',	1,	'',	1450769940,	1500283749,	1,	10,	1,	'',	'',	''),
(48,	2,	'网上商城系统中有关代码的问题',	'',	'&lt;div class=&quot;takeaway&quot; style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;b&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;导读：&lt;/span&gt;&lt;/b&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;网上商城系统现如今对大多数人来说已经不是很陌生了，随着互联网技术的发展，人们在网\r\n上的活动越来越多，从定义上严格来讲网上商城系统又称在线商城系统，是一个功能完善的在线购物系统，主要为在线销售和在线购物服务。其功能主要包含商品的\r\n管理、会员的管理、订单的管理、库存的管理、优惠的管理、在线支付等。&lt;/span&gt;\r\n&lt;/div&gt;\r\n&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;\r\n&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;img src=&quot;http://hanchao9999.com/uploads/image/20151128/10590677903.jpg&quot; /&gt;\r\n&lt;/div&gt;\r\n&lt;p style=&quot;text-align:justify;text-indent:2em;&quot; class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-size:14px;&quot;&gt;&lt;strong&gt;&lt;span style=&quot;color:#333333;font-family:\'Microsoft YaHei\';font-size:14px;line-height:2;&quot;&gt;网上商城系统&lt;/span&gt;&lt;/strong&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;现\r\n如今对大多数人来说已经不是很陌生了，随着互联网技术的发展，人们在网上的活动越来越多，从定义上严格来讲网上商城系统又称在线商城系统，是一个功能完善\r\n的在线购物系统，主要为在线销售和在线购物服务。其功能主要包含商品的管理、会员的管理、订单的管理、库存的管理、优惠的管理、在线支付等。&lt;/span&gt;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;text-indent:2em;&quot; class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-size:14px;&quot;&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;对于&lt;/span&gt;&lt;strong&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;网上商城系统&lt;/span&gt;&lt;/strong&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;的影响到底是如何的呢？网上商城系\r\n统是中小企业营销的利器，通过网络销售不但省去了开发代理商等中间环节的费用，而且是直接面对消费者，可以直接得到客户对产品的反馈。虽然有免费的开源\r\nEcommerce商城程序，但是功能和再开发都有限制，对于那些真正要做网上商城的公司企业来说肯定不可取。汉潮网上商城系统&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:14px;font-family:\'Microsoft YaHei\';color:#333333;line-height:2;&quot;&gt;发现，网上商城系统代码对大家来说相对比较陌生，我们网购所看到的各种精美的商城页面，商城商品，其实都是由后台的商城系统代码来实现的，用代码完成对商城页面的设计、排版等，&lt;/span&gt;&lt;span style=&quot;font-size:14px;font-family:\'Microsoft YaHei\';color:#333333;line-height:2;&quot;&gt;那么有关网上商城系统的代码是怎么回事呢？&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;text-indent:2em;&quot; class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-size:14px;&quot;&gt;&lt;strong&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;网上商城系统&lt;/span&gt;&lt;/strong&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;的代码是可以分成开源代码跟闭源代码，\r\n其作用都是用来开发商城系统系统，其功能就是完善的网上销售系统，主要包括产品发布、在线订购、在线支付、在线客服等功能模块。商城系统代码的日常管理\r\n如：商品添加修改、订单管理、回复客户留言等都是在线操作的，操作简单。使用网上商城代码是很正确的选择，因为商城系统代码具有成本低、节省开发时间、性\r\n能稳定成熟、服务有保障、等优点，是中小公司或个人网上开店的不二选择。&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:14px;&quot;&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;汉潮网上商城系统拥有成熟的技术经验，能够满足市场上用户的需求，在业界获得一致好评。&lt;/span&gt;&lt;strong&gt;&lt;span style=&quot;color:#333333;font-family:\'Microsoft YaHei\';font-size:14px;line-height:2;&quot;&gt;网上商城系统&lt;/span&gt;&lt;/strong&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;汉潮您的首选！&lt;/span&gt;&lt;/span&gt; \r\n&lt;/p&gt;',	1,	'',	1450769974,	1500283674,	0,	10,	1,	'',	'',	''),
(49,	20,	'qq第三方登录流程',	'',	'&lt;div class=&quot;takeaway&quot;&gt;\r\n	&lt;b&gt;导读：&lt;/b&gt;qq第三方登录流程\r\n&lt;/div&gt;\r\n&lt;p&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;vertical-align:baseline;font-size:16px;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;a name=&quot;1..E5.BC.80.E5.8F.91.E8.80.85.E6.B3.A8.E5.86.8C&quot;&gt;&lt;/a&gt;1. 开发者注册\r\n&lt;/p&gt;\r\n&lt;p style=&quot;vertical-align:baseline;font-size:16px;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;line-height:24px;font-size:12px;&quot;&gt;1. 在QQ互联开放平台首页&amp;nbsp;&lt;/span&gt;&lt;a href=&quot;http://connect.qq.com/&quot; target=&quot;_blank&quot;&gt;http://connect.qq.com/&lt;/a&gt;&lt;span style=&quot;line-height:24px;font-size:12px;&quot;&gt;&amp;nbsp;，点击右上角的“登录”按钮，使用QQ帐号登录，如下图所示：&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;div style=&quot;padding:0px;margin:0px;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;b&gt;重要提示：&lt;/b&gt;&lt;br /&gt;\r\n开发者QQ号码一旦注册不能变更，&lt;span style=&quot;color:#FF0000;&quot;&gt;建议使用公司公共QQ号码&lt;/span&gt;而不是员工私人号码注册，以免遇到员工离职等情况造成不必要的麻烦。\r\n&lt;/div&gt;\r\n&lt;p style=&quot;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;http://pub.idqqimg.com/pc/misc/connect/files/20130816/8a0b8bcb408105a6014085be2c3c001a.jpg&quot; height=&quot;95&quot; width=&quot;640&quot; /&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;http://pub.idqqimg.com/pc/misc/connect/files/20130816/8a0b8bcb408105a6014085be4c23001b.jpg&quot; height=&quot;324&quot; width=&quot;485&quot; /&gt;&lt;br /&gt;\r\n2. 登录成功后会跳转到开发者注册页面，在注册页面需要提交公司或个人的基本资料。下图所示的是公司注册页面：\r\n&lt;/p&gt;\r\n&lt;p style=&quot;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;img alt=&quot;web_access_procedure_2.png&quot; src=&quot;http://qzonestyle.gtimg.cn/qzone/vas/opensns/res/img/web_access_procedure_2.png&quot; /&gt; \r\n&lt;/p&gt;\r\n&lt;h2 style=&quot;vertical-align:baseline;font-size:16px;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;a name=&quot;2..E7.BD.91.E7.AB.99.E6.8E.A5.E5.85.A5.E7.94.B3.E8.AF.B7&quot;&gt;&lt;/a&gt;2. 网站接入申请\r\n&lt;/h2&gt;\r\n&lt;p style=&quot;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	网站接入前，需首先进行申请，获得对应的appid与appkey，以保证后续流程中可正确对网站与用户进行验证与授权。\r\n&lt;/p&gt;\r\n&lt;h3 style=&quot;vertical-align:baseline;font-size:14px;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;a name=&quot;2.1.E6.B7.BB.E5.8A.A0.E7.BD.91.E7.AB.99&quot;&gt;&lt;/a&gt;2.1 添加网站\r\n&lt;/h3&gt;\r\n&lt;p style=&quot;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	开发者注册成功后，会跳转到“管理中心”页面。点击添加网站，填写相应的信息，如下图所示：\r\n&lt;/p&gt;\r\n&lt;p style=&quot;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;http://pub.idqqimg.com/pc/misc/connect/files/20130816/8a0b8bcb408105a6014085be8f00001d.jpg&quot; height=&quot;638&quot; width=&quot;644&quot; /&gt;&lt;br /&gt;\r\n网站信息填写完成，点击“确定”后，网站注册完成，进入管理中心，在管理中心可以查看到网站获取的appid和appkey，如下图所示：\r\n&lt;/p&gt;\r\n&lt;p style=&quot;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	&amp;nbsp;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;http://pub.idqqimg.com/pc/misc/connect/files/20130816/8a0b8bcb408105a6014085d9325e0034.jpg&quot; height=&quot;155&quot; width=&quot;640&quot; /&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	&amp;nbsp;\r\n&lt;/p&gt;\r\n&lt;h3 style=&quot;vertical-align:baseline;font-size:14px;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;a name=&quot;2.2.E7.BD.91.E7.AB.99.E4.BF.A1.E6.81.AF.E5.AE.8C.E5.96.84&quot;&gt;&lt;/a&gt;2.2 网站信息完善\r\n&lt;/h3&gt;\r\n&lt;p style=&quot;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	在管理中心，点击申请的网站下的“编辑信息”，进入编辑页面，点击右上角的“编辑”按钮，页面进入编辑状态，即可对网站信息进行修改和完善，如下图所示：\r\n&lt;/p&gt;\r\n&lt;p style=&quot;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;http://pub.idqqimg.com/pc/misc/connect/files/20130816/8a0b8bcb408105a6014085d95f7a0035.jpg&quot; height=&quot;375&quot; width=&quot;640&quot; /&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	&amp;nbsp;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	&amp;nbsp;\r\n&lt;/p&gt;\r\n&lt;h2 style=&quot;vertical-align:baseline;font-size:16px;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;a name=&quot;3..E7.BD.91.E7.AB.99.E5.BC.80.E5.8F.91&quot;&gt;&lt;/a&gt;3. 网站开发\r\n&lt;/h2&gt;\r\n&lt;p style=&quot;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	进入控制台页面，可以看到网站申请处于“开发”状态。网站上线，首先需对网站进行开发，即完成QQ登录功能并正常放置QQ登录按钮，如下图所示：\r\n&lt;/p&gt;\r\n&lt;p style=&quot;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;http://pub.idqqimg.com/pc/misc/connect/files/20130816/8a0b8bcb408105a6014085bef02d001f.jpg&quot; height=&quot;408&quot; width=&quot;640&quot; /&gt; \r\n&lt;/p&gt;\r\n&lt;h3 style=&quot;vertical-align:baseline;font-size:14px;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;a name=&quot;3.1.E5.BC.80.E5.8F.91.E6.B5.81.E7.A8.8B.E6.A6.82.E8.BF.B0&quot;&gt;&lt;/a&gt;3.1 开发流程概述\r\n&lt;/h3&gt;\r\n&lt;p style=&quot;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	开发流程主要包括如下几个步骤：\r\n&lt;/p&gt;\r\n&lt;h4 style=&quot;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;a name=&quot;3.1.1.E7.BD.91.E7.AB.99.E4.B8.8A.E8.AE.BE.E7.BD.AEQQ.E7.99.BB.E5.BD.95.E5.85.A5.E5.8F.A3&quot;&gt;&lt;/a&gt;3.1.1 网站上设置QQ登录入口\r\n&lt;/h4&gt;\r\n&lt;p style=&quot;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	网站主可以在自己的网站首页入口和主要的登录、注册页面上放置“QQ登录”标识（见红色方框标记处）：\r\n&lt;/p&gt;\r\n&lt;p style=&quot;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;img alt=&quot;connect_summary_1.png&quot; src=&quot;http://qzonestyle.gtimg.cn/qzone/vas/opensns/res/img/connect_summary_1.png&quot; /&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	网站需要下载官方提供的“QQ登录”按钮图片，并按照UI规范将按钮放置在页面合适的位置。&lt;a href=&quot;http://wiki.connect.qq.com/%e7%bd%91%e7%ab%99%e5%89%8d%e7%ab%af%e9%a1%b5%e9%9d%a2%e8%a7%84%e8%8c%83#1..E4.BD.BF.E7.94.A8.E8.85.BE.E8.AE.AF.E6.8F.90.E4.BE.9B.E7.9A.84.E6.A0.87.E5.87.86.E2.80.9CQQ.E7.99.BB.E5.BD.95.E2.80.9D.E6.A0.87.E8.AF.86&quot;&gt;按钮图标下载&lt;/a&gt;&amp;nbsp;&lt;a href=&quot;http://wiki.connect.qq.com/%E7%BD%91%E7%AB%99%E5%89%8D%E7%AB%AF%E9%A1%B5%E9%9D%A2%E8%A7%84%E8%8C%83#2..E6.A0.87.E8.AF.86.E6.94.BE.E7.BD.AE.E4.BD.8D.E7.BD.AE.E8.A7.84.E8.8C.83&quot;&gt;按钮放置规范&lt;/a&gt; \r\n&lt;/p&gt;\r\n&lt;h4 style=&quot;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;a name=&quot;3.1.2.E7.94.A8.E6.88.B7.E7.99.BB.E5.BD.95.E9.AA.8C.E8.AF.81.E5.92.8C.E6.8E.88.E6.9D.83&quot;&gt;&lt;/a&gt;3.1.2 用户登录验证和授权\r\n&lt;/h4&gt;\r\n&lt;p style=&quot;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	1. 用户点击QQ登录按钮之后，弹出QQ登录窗口，在登录窗口中将显示网站自己的Logo标识，网站名称以及首页链接地址。&lt;br /&gt;\r\n如果用户已登录QQ软件，也可以一键快速登录。&lt;br /&gt;\r\n如下图所示：\r\n&lt;/p&gt;\r\n&lt;p style=&quot;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;img alt=&quot;OAuth_guide_V2_3.png&quot; src=&quot;http://qzonestyle.gtimg.cn/qzone/vas/opensns/res/img/OAuth_guide_V2_3.png&quot; /&gt;&lt;br /&gt;\r\n2. 成功登录后，弹出授权框引导用户授权（仅在第一次成功登录，以及第一次访问某个未授权的OpenAPI时会出现授权页），如下图所示：\r\n&lt;/p&gt;\r\n&lt;p style=&quot;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;img alt=&quot;OAuth_guide_V2_6.png&quot; src=&quot;http://qzonestyle.gtimg.cn/qzone/vas/opensns/res/img/OAuth_guide_V2_6.png&quot; /&gt;&lt;br /&gt;\r\n授权框中的授权列表由网站自行配置，详见&lt;a href=&quot;http://wiki.connect.qq.com/%E4%BD%BF%E7%94%A8authorization_code%E8%8E%B7%E5%8F%96access_token#Step1.EF.BC.9A.E8.8E.B7.E5.8F.96AuthorizationCode&quot;&gt;scope参数说明&lt;/a&gt;。建议控制授权项的数量，只传入必要的接口名称，因为授权项越多，用户越可能拒绝进行任何授权。&lt;br /&gt;\r\n具体实现详见：&amp;nbsp;&lt;a href=&quot;http://wiki.connect.qq.com/%E5%BC%80%E5%8F%91%E6%94%BB%E7%95%A5_server-side#Step2.EF.BC.9A.E8.8E.B7.E5.8F.96AuthorizationCode&quot;&gt;开发攻略_Server-side的Step2和Step3&lt;/a&gt;&amp;nbsp;&amp;nbsp;&lt;a href=&quot;http://wiki.connect.qq.com/%E5%BC%80%E5%8F%91%E6%94%BB%E7%95%A5_client-side#Step2.EF.BC.9A.E8.8E.B7.E5.8F.96AccessToken&quot;&gt;开发攻略_Client-side的Step2&lt;/a&gt; \r\n&lt;/p&gt;\r\n&lt;h4 style=&quot;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;a name=&quot;3.1.3.E7.99.BB.E5.BD.95.E5.92.8C.E6.8E.88.E6.9D.83.E5.AE.8C.E6.88.90.E5.90.8E.EF.BC.8C.E8.B7.B3.E8.BD.AC.E5.9B.9E.E7.BD.91.E7.AB.99&quot;&gt;&lt;/a&gt;3.1.3 登录和授权完成后，跳转回网站\r\n&lt;/h4&gt;\r\n&lt;p style=&quot;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	如果用户成功登录并授权，则跳转到指定的回调地址，该回调地址由第三方网站自行配置（在上一步的请求中传入），回调地址建议设置为网站首页或网站的用户中心。\r\n&lt;/p&gt;\r\n&lt;h4 style=&quot;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;a name=&quot;3.1.4.E8.8E.B7.E5.8F.96.E5.B9.B6.E5.AD.98.E5.82.A8accesstoken.E4.BB.A5.E5.8F.8Aopenid&quot;&gt;&lt;/a&gt;3.1.4 获取并存储access token以及openid\r\n&lt;/h4&gt;\r\n&lt;p style=&quot;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	成功登录后，即可发送请求来获取access token以及openid，这两个参数在调用OpenAPI访问和修改用户数据时必须传入，网站需自行绑定或存储：&amp;nbsp;&lt;span style=&quot;color:#FF0000;&quot;&gt;（1）access token用来判断用户在本网站上的登录状态，具有3个月有效期，用户再次登录时自动刷新。&lt;/span&gt;（2）openid是此网站上唯一对应用户身份的标识，网站可将此ID进行存储便于用户下次登录时辨识其身份，或将其与用户在网站上的原有帐号进行绑定。\r\n&lt;/p&gt;\r\n&lt;h4 style=&quot;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;a name=&quot;3.1.5.E5.9C.A8.E7.BD.91.E7.AB.99.E4.B8.8A.E6.98.BE.E7.A4.BA.E7.94.A8.E6.88.B7.E7.99.BB.E5.BD.95.E6.98.B5.E7.A7.B0.E4.B8.8EQQ.E5.A4.B4.E5.83.8F&quot;&gt;&lt;/a&gt;3.1.5 在网站上显示用户登录昵称与QQ头像\r\n&lt;/h4&gt;\r\n&lt;p style=&quot;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	建议网站调用get_user_info接口，在首页或顶部显示用户通过QQ帐号的登录状态，使用户体验一致，包括用户昵称、QQ头像，如下图所示：\r\n&lt;/p&gt;\r\n&lt;p style=&quot;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;img alt=&quot;connect_summary_5.png&quot; src=&quot;http://qzonestyle.gtimg.cn/qzone/vas/opensns/res/img/connect_summary_5.png&quot; /&gt;&lt;br /&gt;\r\n详见：&lt;a href=&quot;http://wiki.connect.qq.com/get_user_info&quot;&gt;get_user_info&lt;/a&gt;。\r\n&lt;/p&gt;\r\n&lt;h3 style=&quot;vertical-align:baseline;font-size:14px;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;a name=&quot;3.2.E5.BC.80.E5.8F.91.E8.AF.B4.E6.98.8E&quot;&gt;&lt;/a&gt;3.2 开发说明\r\n&lt;/h3&gt;\r\n&lt;p style=&quot;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	QQ登录功能使用国际通用的OAuth2.0协议进行验证与授权，可通过以下两种方式进行网站开发：&lt;br /&gt;\r\n（1）使用QQ互联提供的SDK包，用户体验统一，只需要修改少量代码，不需要理解验证授权流程，需要快速接入QQ登录的应用可选用此方法。&lt;br /&gt;\r\n详见：&lt;a href=&quot;http://wiki.connect.qq.com/sdk%e4%b8%8b%e8%bd%bd&quot;&gt;SDK下载&lt;/a&gt;&amp;nbsp;JS SDK详见：&lt;a href=&quot;http://wiki.connect.qq.com/js_sdk%e4%bd%bf%e7%94%a8%e8%af%b4%e6%98%8e&quot;&gt;JS SDK使用说明&lt;/a&gt;&lt;br /&gt;\r\n（2）根据QQ登录OAuth2.0协议，自主开发，此方法自定义程度较高，需要与现有系统进行整合的网站可选用此方法。&lt;br /&gt;\r\n详见：&lt;a href=&quot;http://wiki.connect.qq.com/oauth2-0%e5%bc%80%e5%8f%91%e6%96%87%e6%a1%a3&quot;&gt;OAuth2.0开发文档&lt;/a&gt;&lt;br /&gt;\r\n（3）社区类网站可以使用集成插件快速接入QQ登录。&lt;br /&gt;\r\n详见&lt;a href=&quot;http://wiki.connect.qq.com/%e9%9b%86%e6%88%90%e6%8f%92%e4%bb%b6&quot;&gt;集成插件&lt;/a&gt;。\r\n&lt;/p&gt;\r\n&lt;h2 style=&quot;vertical-align:baseline;font-size:16px;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;a name=&quot;4..E4.BD.BF.E7.94.A8QQ.E4.BA.92.E8.81.94.E6.8F.90.E4.BE.9B.E7.9A.84OpenAPI&quot;&gt;&lt;/a&gt;4. 使用QQ互联提供的OpenAPI\r\n&lt;/h2&gt;\r\n&lt;p style=&quot;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	完成网站的开发后，即可在“管理中心”的“控制台”页面，点击“当前流程”下的“申请上线”，流程处于“审核”状态。&lt;br /&gt;\r\n提交审核后，腾讯会在两个工作日完成审核，审核通过后，网站即正式上线。&lt;br /&gt;\r\n网站上线后，可以使用QQ互联提供的丰富的API资源：&lt;br /&gt;\r\n1. 我们提供了各种OpenAPI给开发者，网站可以调用这些API来实现需要的功能，使登录用户在网站上即可访问和修改QQ空间受保护的资源。&lt;br /&gt;\r\n详见：&lt;a href=&quot;http://wiki.connect.qq.com/api%e5%88%97%e8%a1%a8&quot;&gt;API列表&lt;/a&gt;&amp;nbsp;&lt;a href=&quot;http://wiki.connect.qq.com/openapi%e8%b0%83%e7%94%a8%e8%af%b4%e6%98%8e_oauth2-0&quot;&gt;API调用说明&lt;/a&gt;&lt;br /&gt;\r\n2. 为方便网站快速使用这些API，QQ互联提供了JS-widget， JS-widget是JS封装的SDK，只需要在网站引入JS文件，就可以用封装好的方法访问对应的API，开发简单。&lt;br /&gt;\r\n详见：&lt;a href=&quot;http://wiki.connect.qq.com/js_sdk%e4%bd%bf%e7%94%a8%e8%af%b4%e6%98%8e&quot;&gt;JS SDK使用说明&lt;/a&gt; \r\n&lt;/p&gt;\r\n&lt;h2 style=&quot;vertical-align:baseline;font-size:16px;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;a name=&quot;5.WAP.E7.BD.91.E7.AB.99.E6.8E.A5.E5.85.A5&quot;&gt;&lt;/a&gt;5. WAP网站接入\r\n&lt;/h2&gt;\r\n&lt;p style=&quot;vertical-align:baseline;color:#5D6161;font-family:\'Microsoft YaHei\', arial;background-color:#FFFFFF;&quot;&gt;\r\n	上述文档主要是针对WEB以及XHTML格式的网站。&lt;br /&gt;\r\nWAP网站接入QQ登录可基于OAuth1.0协议和OAuth2.0协议。&lt;br /&gt;\r\n基于OAuth1.0协议：接入过程详见&lt;a href=&quot;http://wiki.connect.qq.com/%e5%bc%80%e5%8f%91%e6%94%bb%e7%95%a5_oauth1-0&quot;&gt;开发攻略&lt;/a&gt;。该攻略对于一般网站和WAP网站接入都适用，每一步中WAP网站接入时需特别注意的地方特别用红色标注。\r\n&lt;/p&gt;',	1,	'',	1450771171,	1450771171,	3,	10,	1,	'',	'',	''),
(50,	20,	'万网中，如何查看邮箱账号登录网页版日志',	'',	'&lt;div class=&quot;takeaway&quot;&gt;\r\n	&lt;b&gt;导读：&lt;/b&gt;请您先用需要查询日志的员工账号和密码登录网页版邮箱，登录成功后，在页面最上方的“帮助”下拉菜单中选择“历史记录”，即可查询此账号网页版邮箱登录日志和IP地址信息。\r\n&lt;/div&gt;\r\n&lt;p&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;\r\n&lt;img src=&quot;http://hanchao9999.com/uploads/image/20151016/10293087821.jpg&quot; /&gt;&lt;span style=&quot;font-family:SimSun;font-size:14px;&quot;&gt;请您先用需要查询日志的员工账号和密码登录网页版邮箱，登录成功后，在页面最上方的“帮助”下拉菜单中选择“历史记录”，即可查询此账号网页版邮箱登录日志和IP地址信息。&lt;/span&gt;',	1,	'',	1450771211,	1450771211,	3,	10,	1,	'',	'',	''),
(51,	17,	'我就是测试一下',	'',	'你能不能出来呢',	1,	'',	1464176134,	1464176134,	2,	10,	1,	'',	'',	''),
(52,	9,	'如实描述',	'',	'消费者购买支持此服务的商品，如果被发现和卖家描述的不一样，可以申请赔付。',	1,	'',	1491380384,	1491380384,	0,	10,	1,	'',	'',	''),
(53,	9,	'七天无理由退换货',	'',	'消费者购买支持此服务的商品后，如果在签收货物后的7天内不想买了，卖家有义务向客户提供退换货服务。',	1,	'',	1491380524,	1491380743,	0,	10,	1,	'',	'',	''),
(54,	9,	'假一赔三',	'',	'消费者购买支持此服务的商品，如果被发现是假货，就能申请三倍赔偿。&lt;br /&gt;',	1,	'',	1491380679,	1491380679,	0,	10,	1,	'',	'',	''),
(55,	9,	'闪电发货',	'',	'消费者购买支持此服务的商品，能够享受“闪电发货”，要是卖家发货不及时，买家可以申请赔偿。',	1,	'',	1491380702,	1491380702,	0,	10,	1,	'',	'',	''),
(56,	9,	'正品保障',	'',	'卖家承诺提供“正品保障”服务，可以使顾客放心购买！',	1,	'',	1491380727,	1491380750,	0,	10,	1,	'',	'',	''),
(57,	21,	'入驻流程',	'',	'入驻流程',	1,	'',	1492067076,	1492067076,	0,	10,	1,	'入驻流程',	'入驻流程',	'入驻流程'),
(58,	21,	'签订入驻协议',	'',	'签订入驻协议',	1,	'',	1492067100,	1492067100,	0,	10,	1,	'签订入驻协议',	'签订入驻协议',	'签订入驻协议'),
(59,	21,	'合同签订及缴费',	'',	'合同签订及缴费',	1,	'',	1492067120,	1492067120,	0,	10,	1,	'合同签订及缴费',	'合同签订及缴费',	'合同签订及缴费'),
(60,	21,	'店铺开通',	'',	'店铺开通',	1,	'',	1492067148,	1492067148,	0,	10,	1,	'店铺开通',	'店铺开通',	'店铺开通'),
(63,	2,	'万网中，如何查看邮箱账号登录网页版日志',	'',	'&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;span style=&quot;font-size:14px;font-family:\'Microsoft YaHei\';color:#333333;line-height:2;&quot;&gt;&amp;nbsp; 请您先用需要查询日志的员工账号和密码登录网页版邮箱，登录成功后，在页面最上方的“帮助”下拉菜单中选择“历史记录”，即可查询此账号网页版邮箱登录日志和IP地址信息。&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;&lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:center;&quot;&gt;\r\n	&lt;img src=&quot;http://hanchao9999.com/uploads/image/20151016/10293087821.jpg&quot; /&gt;&lt;span style=&quot;font-family:SimSun;font-size:14px;&quot;&gt;&lt;br /&gt;\r\n&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;请您先用需要查询日志的员工账号和密码登录网页版邮箱，登录成功后，在页面最上方的“帮助”下拉菜单中选择“历史记录”，即可查询此账号网页版邮箱登录日志和IP地址信息。&lt;/span&gt; \r\n&lt;/p&gt;',	1,	'',	1492156134,	1500283625,	0,	10,	1,	'',	'',	''),
(64,	2,	'如何才能在网站建设的过程中做到内容丰富呢？',	'',	'&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;span style=&quot;font-size:14px;font-family:\'Microsoft YaHei\';color:#333333;line-height:2;&quot;&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp; 一个内容丰富的网站，不仅是上传一些漂亮的文章，美丽的图片，更需要的是外链上的丰富。 \r\n网站建设内容不仅要做到多，更要做到精。图文并茂，排版专业清晰，文字通顺合理，遣词造句体现功底，体现专业权威这些都是最基本的要求。&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:center;&quot;&gt;\r\n	&lt;img src=&quot;http://hanchao9999.com/uploads/image/20151016/10300859021.jpg&quot; /&gt;&lt;span style=&quot;font-family:SimSun;font-size:14px;&quot;&gt;&lt;br /&gt;\r\n&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;&amp;nbsp;一个内容丰富的网站，不仅是上传一些漂亮的文章，美丽的图片，更需要的是外链上的丰富。&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;网站建设内容不仅要做到多，更要做到精。图文并茂，排版专业清晰，文字通顺合理，遣词造句体现功底，体现专业权威这些都是最基本的要求。&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;其实外链也是尤为重要的，外链一般要做到一下几点：&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;第一点，多样化。进一步分析可以理解为文本多样化，形式多样化，平台多样化。&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;span style=&quot;line-height:2;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;&quot;&gt;第二点，广泛性。更好的从另一个方面来理解也可以解释为平台多样化。&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;第三点，质量度。我们在选择平台进行外链发布时一定要注意此平台的访问量、权威性以及展示位置。&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;第四点，相关度。石家庄网站建设公司在线设计网络认为这是取得客户信任的一大因素，要和本公司有一定的相关度。&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;第五点，执行力。掌握了要点，拥有了资源，能不能成功就要看执行力。&lt;/span&gt; \r\n&lt;/p&gt;',	1,	'',	1492156347,	1500283596,	0,	10,	1,	'',	'',	''),
(65,	2,	'网站建设之前的策划',	'',	'&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;span style=&quot;font-size:14px;font-family:\'Microsoft YaHei\';color:#333333;line-height:2;&quot;&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 企业要实现网络营销和品牌销售，拥有自己的品牌网站是必不可少的。而在网站建设之初，网站设计的规划也是势在必行，很重要的。石家庄网络公司认为，大量成功的网站之所以在运营上做得很好，其中之一的特点就是在网站策划和运营目标上赢在了先机。&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:center;&quot;&gt;\r\n	&lt;img src=&quot;http://hanchao9999.com/uploads/image/20151016/10312670060.jpg&quot; /&gt;&lt;span style=&quot;font-family:SimSun;font-size:14px;&quot;&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;&lt;/span&gt;&lt;br /&gt;\r\n&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;&amp;nbsp; 企业要实现网络营销和品牌销售，拥有自己的品牌网站是必不可少的。而在网站建设之初，网站设计的规划也是势在必行，很重要的。&lt;/span&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;石家庄&lt;/span&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;网络公司&lt;/span&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;认为，大量成功的网站之所以在运营上做得很好，其中之一的特点就是在网站策划和运营目标上赢在了先机。所谓网站赢在策划，可以通过网站的定位、行业分析、程序和结构设计、美工设计处理等各方面，从而在未来的网站运营中给线上营销提供了强有力的营销的数据支持，最大保障了网站后续盈利情况。&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; 关于网站的定位和策划分析，在于建站之前是否对行业和竞争对手做过一系列的分析和数据掌握，能根据自己的优势最好网站定位，制定出&lt;/span&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;网站优化&lt;/span&gt;&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;方案和营销运营策划。在网站设计和制作中做好布局设计，在功能实现上尽量减少页面的代码量，利于搜索引擎抓取的，更多的让搜索引擎抓取深入页面上的内容，而不是被冗余杂乱的结构代码绕晕。页面结构越精简，越突出主题，就越容易赢得搜索引擎的青睐。同时这也有利于普通用户的访问，提升了网站加载速度，加快了网页打开速度，这就要求制作一个非常有优化基础的网站。在网站的结构和导航规划上，可以多参考三层结构，也就是从主页到网站的任何页面，最多需要点击三次以内就可到达。大量的实践表明，这样最有利于让搜索引擎访问，不会因为目录和链接的层次太深而丧失爬行的兴趣，从而丢失收录率；三层目录对加快搜索利于收录有很大的好处。&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; \r\n石家庄网站设计公司久途网络认为，网站策划和运营需要涉及的问题不少，一旦在建站之初做好较清晰的策划考虑，在网站后期运营中就有明确的目标，在实施执行上也会更有目的性和工作连贯性。在网络营销领域，搜索引擎优化和营销推广占据着很重要的地位。同时网络营销属于拼时间拼精力的工程，做好策划占有运营先机，坚持不懈的努力执行，就能给未来的网站营销打下良好的基础。另外在网站的定位上，要跟选择网站优化中的关键词一样，选取适合自己的关键词，定位好自己的网站，对于接下来的优化和营销工作有着核心的指导意义。很多时候建站之前就应该有一套网站运营和营销的策划方案。定位好网站，做好网站分析才是建站之前策划的要点所在。&lt;/span&gt; \r\n&lt;/p&gt;',	1,	'',	1492156448,	1500283551,	0,	10,	1,	'',	'',	''),
(66,	0,	'服务协议',	'',	'&lt;h3 class=&quot;help_title&quot; style=&quot;font-size:24px;font-weight:normal;color:#333333;font-family:微软雅黑;background-color:#FFFFFF;&quot;&gt;\r\n	服务协议\r\n&lt;/h3&gt;\r\n&lt;div class=&quot;help_content&quot; style=&quot;padding:20px 40px 20px 35px;margin:0px auto;font-size:14px;color:#666666;font-family:微软雅黑;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;p class=&quot;MsoNormal&quot; style=&quot;font-size:12px;font-family:宋体;text-align:justify;vertical-align:baseline;&quot;&gt;\r\n		&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;color:black;&quot;&gt;汉潮电子商务服务协议&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;&lt;/span&gt; \r\n	&lt;/p&gt;\r\n	&lt;p class=&quot;MsoNormal&quot; style=&quot;font-size:12px;font-family:宋体;text-align:justify;vertical-align:baseline;&quot;&gt;\r\n		&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;&amp;nbsp;&lt;/span&gt; \r\n	&lt;/p&gt;\r\n	&lt;p class=&quot;MsoNormal&quot; style=&quot;font-size:12px;font-family:宋体;text-align:justify;vertical-align:baseline;&quot;&gt;\r\n		&lt;span style=&quot;font-size:13.5pt;color:black;&quot;&gt;账户注册与使用&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;&lt;/span&gt; \r\n	&lt;/p&gt;\r\n	&lt;p class=&quot;MsoNormal&quot; style=&quot;font-size:12px;font-family:宋体;text-align:justify;vertical-align:baseline;&quot;&gt;\r\n		&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;1&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;color:black;&quot;&gt;、&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;color:black;&quot;&gt;用户资格&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;&lt;/span&gt; \r\n	&lt;/p&gt;\r\n	&lt;p class=&quot;MsoNormal&quot; style=&quot;font-size:12px;font-family:宋体;text-align:justify;vertical-align:baseline;text-indent:20.25pt;&quot;&gt;\r\n		&lt;span style=&quot;font-size:13.5pt;color:black;&quot;&gt;您确认在您开始注册程序使用汉潮平台服务前，您应当具备中华人民共和国法律规定的与您行为相适应的民事行为能力。若您不具备前述与您行为相适应的民事行为能力，则您及您的监护人应依照法律规定承担因此而导致的一切后果。&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;&lt;/span&gt; \r\n	&lt;/p&gt;\r\n	&lt;p class=&quot;MsoNormal&quot; style=&quot;font-size:12px;font-family:宋体;text-align:justify;vertical-align:baseline;&quot;&gt;\r\n		&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;2&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;color:black;&quot;&gt;、&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;color:black;&quot;&gt;账户说明&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;:&lt;/span&gt; \r\n	&lt;/p&gt;\r\n	&lt;p class=&quot;MsoNormal&quot; style=&quot;font-size:12px;font-family:宋体;text-align:justify;vertical-align:baseline;text-indent:20.25pt;&quot;&gt;\r\n		&lt;span style=&quot;font-size:13.5pt;color:black;&quot;&gt;【账户获得】当您按照注册页面提示填写信息、阅读并同意本协议且完成全部注册程序后，您可获得汉潮平台账户并成为汉潮平台用户。&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;&lt;/span&gt; \r\n	&lt;/p&gt;\r\n	&lt;p class=&quot;MsoNormal&quot; style=&quot;font-size:12px;font-family:宋体;text-align:justify;vertical-align:baseline;text-indent:20.25pt;&quot;&gt;\r\n		&lt;span style=&quot;font-size:13.5pt;color:black;&quot;&gt;【账户使用】您有权使用您设置或确认的汉潮会员名、邮箱、手机号码（以下简称&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;“&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;color:black;&quot;&gt;账户名称&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;”&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;color:black;&quot;&gt;）或第三方合作方式（腾讯&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;QQ&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;color:black;&quot;&gt;、微信号）及您设置的密码（账户名称及密码合称&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;“&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;color:black;&quot;&gt;账户&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;”&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;color:black;&quot;&gt;）登录汉潮平台。&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;&lt;/span&gt; \r\n	&lt;/p&gt;\r\n	&lt;p class=&quot;MsoNormal&quot; style=&quot;font-size:12px;font-family:宋体;text-align:justify;vertical-align:baseline;text-indent:20.25pt;&quot;&gt;\r\n		&lt;span style=&quot;font-size:13.5pt;color:black;&quot;&gt;【账户转让】由于用户账户关联用户信用信息，仅当有法律明文规定、司法裁定或经汉潮同意，并符合汉潮平台规则规定的用户账户转让流程的情况下，您可进行账户的转让。您的账户一经转让，该账户项下权利义务一并转移。除此外，您的账户不得以任何方式转让，否则由此产生的一切责任均由您承担。&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;&lt;/span&gt; \r\n	&lt;/p&gt;\r\n	&lt;p class=&quot;MsoNormal&quot; style=&quot;font-size:12px;font-family:宋体;text-align:justify;vertical-align:baseline;text-indent:20.25pt;&quot;&gt;\r\n		&lt;span style=&quot;font-size:13.5pt;color:black;&quot;&gt;【实名认证】作为汉潮平台经营者，法律并未赋予汉潮强制要求所有用户进行支付宝实名认证的权力，但为使您更好地使用汉潮平台的各项服务，汉潮建议您按照支付宝公司要求及我国法律规定完成实名认证。&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;&lt;/span&gt; \r\n	&lt;/p&gt;\r\n	&lt;p class=&quot;MsoNormal&quot; style=&quot;font-size:12px;font-family:宋体;text-align:justify;vertical-align:baseline;text-indent:6.75pt;&quot;&gt;\r\n		&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;3&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;color:black;&quot;&gt;、&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;color:black;&quot;&gt;注册信息管理&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;&lt;/span&gt; \r\n	&lt;/p&gt;\r\n	&lt;p class=&quot;MsoNormal&quot; style=&quot;font-size:12px;font-family:宋体;text-align:justify;vertical-align:baseline;text-indent:13.5pt;&quot;&gt;\r\n		&lt;span style=&quot;font-size:13.5pt;color:black;&quot;&gt;【信息真实】在使用汉潮平台服务时，您应当按汉潮平台页面的提示准确完整地提供您的信息（包括您的姓名及电子邮件地址、联系电话、联系地址等），以便汉潮或其他用户与您联系。您了解并同意，您有义务保持您提供信息的真实性及有效性。&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;&lt;/span&gt; \r\n	&lt;/p&gt;\r\n	&lt;p class=&quot;MsoNormal&quot; style=&quot;font-size:12px;font-family:宋体;text-align:justify;vertical-align:baseline;text-indent:13.5pt;&quot;&gt;\r\n		&lt;span style=&quot;font-size:13.5pt;color:black;&quot;&gt;【合法性】您设置的汉潮会员名不得违反国家法律法规及汉潮网规则关于会员名的管理规定，否则汉潮可回收您的汉潮会员名。汉潮会员名的回收不影响您以邮箱、手机号码登录汉潮平台并使用汉潮平台服务。&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;&lt;/span&gt; \r\n	&lt;/p&gt;\r\n	&lt;p class=&quot;MsoNormal&quot; style=&quot;font-size:12px;font-family:宋体;text-align:justify;vertical-align:baseline;text-indent:13.5pt;&quot;&gt;\r\n		&lt;span style=&quot;font-size:13.5pt;color:black;&quot;&gt;【账户安全保管义务】您的账户为您自行设置并由您保管，汉潮任何时候均不会主动要求您提供您的账户。因此，建议您务必保管好您的账户，&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;color:black;&quot;&gt;并确保您在每个上网时段结束时退出登录并以正确步骤离开汉潮平台。账户因您主动泄露或遭受他人攻击、诈骗等行为导致的损失及后果，均由您自行承担。&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;&lt;/span&gt; \r\n	&lt;/p&gt;\r\n	&lt;p class=&quot;MsoNormal&quot; style=&quot;font-size:12px;font-family:宋体;text-align:justify;vertical-align:baseline;text-indent:13.5pt;&quot;&gt;\r\n		&lt;span style=&quot;font-size:13.5pt;color:black;&quot;&gt;【账户行为责任自负】除汉潮存在过错外，您应对您账户项下的所有行为结果（包括但不限于在线签署各类协议、发布信息、购买商品及服务及披露信息等）负责。&lt;/span&gt;&lt;span style=&quot;font-size:13.5pt;font-family:Simsun;color:black;&quot;&gt;&lt;/span&gt; \r\n	&lt;/p&gt;\r\n	&lt;p class=&quot;MsoNormal&quot; style=&quot;font-size:12px;font-family:宋体;text-align:justify;vertical-align:baseline;text-indent:13.5pt;&quot;&gt;\r\n		&lt;span style=&quot;font-size:13.5pt;color:black;&quot;&gt;【日常维护须知】如发现任何未经授权使用您账户登录汉潮平台或其他可能导致您账户遭窃、遗失的情况，建议您立即通知汉潮，并授权汉潮将该信息同步平台。您理解汉潮对您的任何请求采取行动均需要合理时间，除汉潮存在过错外，汉潮对在采取行动前已经产生的后果不承担任何责任。&lt;/span&gt; \r\n	&lt;/p&gt;\r\n&lt;/div&gt;',	1,	'',	1493083228,	1501726067,	0,	10,	1,	'',	'',	''),
(70,	21,	'限时促销',	'',	'限时促销',	21,	'',	1502332332,	1502332332,	0,	10,	1,	'',	'',	''),
(71,	21,	'优惠活动',	'',	'优惠活动',	21,	'',	1502332710,	1502332727,	0,	10,	1,	'',	'',	''),
(72,	21,	'代金券',	'',	'代金券',	21,	'',	1502332738,	1502332738,	0,	10,	1,	'',	'',	'');

DROP TABLE IF EXISTS `hanchao_article_cat`;
CREATE TABLE `hanchao_article_cat` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '类别ID',
  `name` varchar(60) NOT NULL COMMENT '分类名称 ',
  `pid` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '父ID',
  `img` char(200) NOT NULL COMMENT '分类图片',
  `sort` smallint(5) NOT NULL DEFAULT '10' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否在导航条显示',
  `seotitle` varchar(255) NOT NULL COMMENT 'Seo题目',
  `seokeywords` varchar(255) NOT NULL COMMENT 'Seo关键字',
  `seodescription` varchar(255) NOT NULL COMMENT 'Seo描述',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='文章分类表';

INSERT INTO `hanchao_article_cat` (`id`, `name`, `pid`, `img`, `sort`, `status`, `seotitle`, `seokeywords`, `seodescription`) VALUES
(1,	'关于我们',	1,	'',	1,	1,	'关于我们',	'关于我们',	'关于我们'),
(2,	'公告信息',	0,	'',	10,	1,	'',	'',	''),
(3,	'最新活动',	0,	'',	10,	1,	'',	'',	''),
(4,	'帮助中心',	0,	'',	1,	1,	'',	'',	''),
(7,	'购物指南',	4,	'',	10,	1,	'购物指南',	'购物指南',	'购物指南'),
(8,	'配送与支付',	4,	'',	10,	1,	'配送与支付',	'配送与支付',	'配送与支付'),
(9,	'服务保证',	4,	'',	10,	1,	'服务保证',	'服务保证',	'服务保证'),
(10,	'服务中心',	4,	'',	10,	1,	'配送范围',	'配送范围',	'配送范围'),
(16,	'关于我们',	1,	'',	10,	1,	'',	'',	''),
(17,	'优惠活动',	0,	'',	10,	1,	'',	'',	''),
(20,	'常见问题',	0,	'',	8,	1,	'',	'',	''),
(21,	'商家入驻',	0,	'',	5,	1,	'商家入驻',	'商家入驻',	'商家入驻'),
(23,	'服务协议',	0,	'',	20,	1,	'',	'',	'');

DROP TABLE IF EXISTS `hanchao_audit_log`;
CREATE TABLE `hanchao_audit_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '日志id',
  `pro_id` int(10) NOT NULL COMMENT '商品/商家/活动ID',
  `param` int(10) NOT NULL COMMENT '额外参数',
  `type` tinyint(2) NOT NULL COMMENT '类型：1商品2商家3活动4店铺经营类目加入5店铺经营类目退出6店铺标签',
  `remark` varchar(255) NOT NULL COMMENT '备注',
  `status` tinyint(1) NOT NULL COMMENT '1通过/2不通过3审核中',
  `author` int(10) NOT NULL COMMENT '审核人id',
  `creat_time` int(10) NOT NULL COMMENT '审核时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='审核日志';


DROP TABLE IF EXISTS `hanchao_auth_group`;
CREATE TABLE `hanchao_auth_group` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `title` char(100) NOT NULL DEFAULT '' COMMENT '管理组名称',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态',
  `rules` text COMMENT '管理权限',
  `nav_rules` text NOT NULL COMMENT '栏目权限',
  `content` char(100) DEFAULT NULL COMMENT '描述',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='管理组表';

INSERT INTO `hanchao_auth_group` (`id`, `title`, `status`, `rules`, `nav_rules`, `content`) VALUES
(1,	'管理员',	1,	'24,25,26,110,322,1,2,49,50,51,441,316,317,165,70,69,131,274,269,218,219,220,270,271,330,48,52,53,453,452,442,333,205,204,358,357,332,331,201,200,54,81,82,83,42,44,43,336,337,124,125,96,126,340,455,458,457,456,272,348,347,346,141,74,142,227,120,288,350,349,238,353,352,351,240,440,119,290,446,355,360,354,289,443,356,447,122,359,235,234,444,361,113,114,94,365,188,187,186,185,184,183,182,367,366,181,180,179,363,364,178,68,369,368,313,370,281,226,374,373,371,372,230,376,375,302,377,72,98,76,378,97,100,380,379,312,384,383,382,381,299,300,385,301,102,109,106,104,103,144,145,151,152,150,149,148,147,146,92,216,217,386,47,45,388,293,389,57,59,390,58,391,63,65,394,393,392,64,395,60,61,396,62,397,3,29,34,46,400,399,398,287,401,242,402,111,451,450,449,101,403,86,282,405,409,407,408,406,404,30,4,5,11,412,17,229,55,112,414,308,418,417,416,419,415,286,420,278,424,423,422,421,130,425,426,279,431,430,429,448,432,309,311,445,310,433,280,275,276,434,277,35,243,247,305,306,468,467,295,246,255,249,254,253,77,307,80,435,79,436,78,438,437,800,801,805,804,802,808,807,806,803,809',	'',	''),
(2,	'编辑',	1,	'24,25,26,49,50,51,70,69,72,92,216,217,47,45,293,57,59,58,63,65,64,60,61,62',	'',	'编辑人员专用分组'),
(4,	'财务',	1,	'24,25,26,110,113,98,76,97,100,312,144,145,151,152,150,149,148,147,146',	'',	''),
(5,	'运营',	1,	'24,25,26,227,120,288,238,240,119,290,289,122,235,234,35,243,247,305,306,295,246,255,249,254,253,77,307,80,79,78,291,239',	'',	''),
(9,	'超级管理员',	1,	NULL,	'',	''),
(10,	'客服',	1,	'24,25,26,110,322,49,50,51,441,318,316,317,314,165,70,69,131,274,319,269,218,219,320,220,321,270,271,330,48,52,53,453,452,442,333,206,205,204,358,357,332,331,203,202,201,200,54,334,81,82,335,83,42,44,43,338,336,337,124,125,339,96,126,340,455,458,460,459,457,456,272,348,347,346,141,341,74,142,345',	'',	'管理咨询');

DROP TABLE IF EXISTS `hanchao_auth_group_access`;
CREATE TABLE `hanchao_auth_group_access` (
  `uid` mediumint(8) unsigned NOT NULL COMMENT '管理员ID',
  `group_id` mediumint(8) unsigned NOT NULL COMMENT '管理组ID',
  UNIQUE KEY `uid_group_id` (`uid`,`group_id`),
  KEY `uid` (`uid`),
  KEY `group_id` (`group_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='管理组权限关联表';

INSERT INTO `hanchao_auth_group_access` (`uid`, `group_id`) VALUES
(1,	1);

DROP TABLE IF EXISTS `hanchao_auth_rule`;
CREATE TABLE `hanchao_auth_rule` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(80) NOT NULL DEFAULT '' COMMENT '规则名称',
  `title` char(20) NOT NULL DEFAULT '' COMMENT '节点名称',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态',
  `condition` char(100) NOT NULL DEFAULT '' COMMENT '规则条件',
  `show_status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '显示状态',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '节点类型',
  `pid` mediumint(8) NOT NULL DEFAULT '0' COMMENT '父级ID',
  `sort` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  `content` varchar(100) NOT NULL COMMENT '备注',
  PRIMARY KEY (`id`),
  KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=468 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='权限规则表';

INSERT INTO `hanchao_auth_rule` (`id`, `name`, `title`, `status`, `condition`, `show_status`, `type`, `pid`, `sort`, `content`) VALUES
(1,	'Index/index',	'后台框架',	1,	'',	0,	0,	0,	1,	''),
(2,	'Index/index',	'后台界面',	1,	'',	0,	0,	1,	2,	''),
(3,	'Index/index',	'系统',	1,	'',	1,	0,	0,	900,	''),
(4,	'Admin/index',	'管理设置',	1,	'',	1,	1,	3,	4,	''),
(11,	'AuthGroup/index',	'管理员组',	1,	'',	1,	0,	4,	11,	''),
(17,	'Admin/index',	'管理员',	1,	'',	1,	0,	4,	17,	''),
(22,	'AuthGroup/memberrule',	'权限设置',	1,	'',	1,	3,	11,	22,	''),
(24,	'Index/index',	'我的面板',	1,	'',	1,	0,	0,	0,	''),
(25,	'Public/main',	'我的信息',	1,	'',	1,	1,	24,	0,	''),
(26,	'Public/main',	'我的信息',	1,	'',	1,	1,	25,	0,	''),
(29,	'Config/index',	'系统设置',	1,	'',	1,	0,	3,	1,	''),
(34,	'Config/group',	'系统设置',	1,	'',	1,	0,	29,	1,	''),
(35,	'Weixin/index',	'移动端',	1,	'',	1,	1,	0,	999,	''),
(42,	'Action/actionlog',	'会员日志',	1,	'',	1,	1,	52,	10,	''),
(43,	'Action/index',	'日志规则',	1,	'',	0,	0,	42,	10,	''),
(44,	'Action/actionlog',	'日志管理',	1,	'',	0,	0,	42,	10,	''),
(45,	'Template/index',	'模板设置',	1,	'',	1,	0,	216,	12,	''),
(46,	'Area/index',	'地区管理',	1,	'',	1,	0,	29,	8,	''),
(47,	'Nav/index',	'导航管理',	1,	'',	1,	0,	216,	11,	''),
(48,	'User/index',	'会员',	1,	'',	1,	0,	0,	4,	''),
(49,	'Goods/index',	'商品',	1,	'',	1,	1,	0,	3,	''),
(50,	'Goods/index',	'商品管理',	1,	'',	1,	0,	49,	10,	''),
(51,	'Goods/index',	'商品列表',	1,	'',	1,	0,	50,	1,	''),
(52,	'Member/index',	'会员管理',	1,	'',	1,	1,	48,	1,	''),
(53,	'Member/index',	'会员列表',	1,	'',	1,	0,	52,	1,	''),
(54,	'MemberRank/index',	'等级积分',	1,	'',	1,	0,	52,	2,	''),
(55,	'Shops/index',	'店铺管理',	1,	'',	1,	0,	229,	9,	''),
(57,	'Article/index',	'文章管理',	1,	'',	1,	0,	92,	10,	''),
(58,	'Article/index',	'文章列表',	1,	'',	1,	0,	57,	10,	''),
(59,	'ArticleCat/index',	'文章分类',	1,	'',	1,	0,	57,	10,	''),
(60,	'Friendlink/index',	'友情链接管理',	1,	'',	1,	0,	92,	30,	''),
(61,	'Friendlink/index',	'友情链接',	1,	'',	1,	0,	60,	10,	''),
(62,	'FriendlinkCat/index',	'链接分类',	1,	'',	1,	0,	60,	20,	''),
(63,	'Poster/index',	'广告管理',	1,	'',	1,	0,	92,	20,	''),
(64,	'Poster/index',	'广告列表',	1,	'',	1,	0,	63,	10,	''),
(65,	'PosterPosition/index?device=0',	'广告位列表',	1,	'',	1,	0,	63,	10,	''),
(68,	'Shipping/index',	'配送方式',	1,	'',	1,	0,	114,	10,	''),
(69,	'GoodsType/index',	'商品类型',	1,	'',	1,	0,	50,	7,	''),
(70,	'GoodsCategory/index',	'商品分类',	1,	'',	1,	0,	50,	4,	''),
(72,	'Comment/index?type=1&pid=0',	'商品评论',	1,	'',	1,	0,	114,	16,	''),
(74,	'Message/index',	'消息管理',	1,	'',	1,	0,	272,	10,	''),
(76,	'Payment/index',	'支付方式',	1,	'',	1,	0,	98,	10,	''),
(77,	'WxKeywords/index',	'微信管理',	1,	'',	1,	0,	35,	10,	''),
(78,	'WxMenu/index',	'自定义菜单',	1,	'',	1,	0,	77,	10,	''),
(79,	'WxKeywords/index',	'关键词列表',	1,	'',	1,	0,	77,	10,	''),
(80,	'WxKeywords/first',	'首次关注',	1,	'',	1,	0,	77,	10,	''),
(81,	'Oauth/index',	'信任登录',	1,	'',	1,	0,	52,	10,	''),
(82,	'Oauth/index',	'第三方列表',	1,	'',	0,	0,	81,	10,	''),
(83,	'OauthMember/index',	'第三方会员',	1,	'',	0,	0,	81,	11,	''),
(86,	'Urlrule/config',	'URL设置',	1,	'',	1,	0,	29,	10,	''),
(89,	'Create/index',	'生成首页',	1,	'',	1,	0,	88,	10,	''),
(92,	'Url/index',	'前端',	1,	'',	1,	0,	0,	100,	''),
(94,	'OrderInfo/index',	'订单管理',	1,	'',	1,	0,	114,	10,	''),
(96,	'Member/extension_list',	'推广列表',	1,	'',	1,	0,	124,	10,	''),
(97,	'MemberBank/index',	'提现账号',	1,	'',	0,	0,	98,	11,	''),
(98,	'AccountLog/index',	'财务管理',	1,	'',	1,	0,	113,	10,	''),
(100,	'MemberWithdrawals/index',	'会员提现列表',	1,	'',	1,	0,	98,	12,	''),
(101,	'Type/index',	'类别管理',	1,	'',	1,	0,	29,	10,	''),
(102,	'publics/index',	'公共配置',	1,	'',	0,	0,	0,	10,	''),
(103,	'publics/index',	'列表',	1,	'',	0,	0,	102,	10,	''),
(104,	'publics/add',	'添加',	1,	'',	0,	0,	102,	10,	''),
(105,	'publics/insert',	'插入',	1,	'',	0,	0,	102,	10,	''),
(106,	'publics/edit',	'编辑',	1,	'',	0,	0,	102,	10,	''),
(107,	'publics/save',	'保存',	1,	'',	0,	0,	102,	10,	''),
(108,	'publics/delete',	'删除',	1,	'',	0,	0,	102,	10,	''),
(109,	'publics/sort',	'排序',	1,	'',	0,	0,	102,	10,	''),
(110,	'Admin/reset',	'修改密码',	1,	'',	1,	0,	25,	10,	''),
(111,	'Database/index',	'数据库管理',	1,	'',	1,	0,	29,	10,	''),
(112,	'Shops/index',	'店铺列表',	1,	'',	1,	0,	55,	9,	''),
(113,	'Index/index',	'订单财务',	1,	'',	1,	0,	0,	10,	''),
(114,	'OrderInfo/index',	'订单管理',	1,	'',	1,	0,	113,	10,	''),
(116,	'Bonu/index',	'红包类型',	1,	'',	1,	0,	117,	10,	''),
(119,	'Action/index',	'促销管理',	1,	'',	1,	0,	227,	11,	''),
(120,	'Bonu/index',	'红包类型',	1,	'',	1,	0,	227,	10,	''),
(122,	'PromotAct/index',	'优惠活动',	1,	'',	1,	0,	119,	10,	''),
(124,	'Extension/index',	'推荐管理',	1,	'',	1,	0,	48,	5,	''),
(125,	'ExtensionSetting/index',	'推荐设置',	1,	'',	1,	0,	124,	10,	''),
(126,	'ExtensionList/index',	'分成管理',	1,	'',	1,	0,	124,	11,	''),
(130,	'Audit/index',	'店铺审核',	1,	'',	1,	0,	55,	10,	''),
(131,	'Audit/goods',	'商品审核',	1,	'',	1,	0,	50,	8,	''),
(134,	'Sale/index',	'销售明细',	1,	'',	1,	0,	132,	10,	''),
(135,	'MemberOrder/index',	'订单概况统计',	1,	'',	1,	0,	132,	10,	''),
(136,	'SaleMoney/index',	'销售额统计',	1,	'',	1,	0,	132,	10,	''),
(137,	'MemberTong/index',	'会员统计',	1,	'',	1,	0,	132,	10,	''),
(138,	'MemberTong/cnzz',	'站长统计',	1,	'',	1,	0,	132,	10,	''),
(139,	'Tongji/supply',	'供应商统计',	1,	'',	1,	0,	132,	10,	''),
(141,	'Sms/index',	'信息接口',	1,	'',	1,	0,	272,	10,	''),
(142,	'SmsTheme/index',	'信息模板',	1,	'',	1,	0,	272,	11,	''),
(144,	'TableTong/index',	'统计',	1,	'',	1,	0,	0,	51,	''),
(145,	'Table/index',	'报表统计',	1,	'',	1,	0,	144,	10,	''),
(146,	'Guest/index',	'客户统计',	1,	'',	1,	0,	145,	10,	''),
(147,	'Sale/index',	'销售明细',	1,	'',	1,	0,	145,	10,	''),
(148,	'MemberOrder/index',	'订单概况统计',	1,	'',	1,	0,	145,	10,	''),
(149,	'SaleMoney/index',	'销售额统计',	1,	'',	1,	0,	145,	10,	''),
(150,	'MemberTong/index',	'会员统计',	1,	'',	1,	0,	145,	10,	''),
(151,	'MemberTong/cnzz',	'站长统计',	1,	'',	1,	0,	145,	9,	''),
(152,	'Tongji/supply',	'供应商统计',	1,	'',	1,	0,	145,	10,	''),
(165,	'Goods/index',	'列表',	1,	'',	0,	0,	51,	10,	''),
(178,	'OrderInfo/index',	'列表',	1,	'',	0,	0,	94,	10,	''),
(179,	'OrderInfo/view',	'查看',	1,	'',	0,	0,	94,	10,	''),
(180,	'OrderInfo/edit',	'编辑',	1,	'',	0,	0,	94,	10,	''),
(181,	'OrderInfo/update',	'更新',	1,	'',	0,	0,	94,	10,	''),
(182,	'OrderInfo/ordergoods',	'编辑商品',	1,	'',	0,	0,	94,	10,	''),
(183,	'OrderInfo/new_og',	'编辑商品2',	1,	'',	0,	0,	94,	10,	''),
(184,	'OrderInfo/new_og_edit',	'确认编辑',	1,	'',	0,	0,	94,	10,	''),
(185,	'OrderInfo/updateordergoods',	'更新价格',	1,	'',	0,	0,	94,	10,	''),
(186,	'OrderInfo/order_add_goods',	'更新商品',	1,	'',	0,	0,	94,	10,	''),
(187,	'OrderInfo/manage',	'状态',	1,	'',	0,	0,	94,	10,	''),
(188,	'OrderInfo/order_print',	'打印',	1,	'',	0,	0,	94,	10,	''),
(189,	'OrderInfo/add_user',	'添加会员',	1,	'',	0,	0,	153,	10,	''),
(190,	'OrderInfo/change_user',	'会员搜索',	1,	'',	0,	0,	153,	10,	''),
(191,	'OrderInfo/change_address',	'收货地址',	1,	'',	0,	0,	153,	10,	''),
(192,	'OrderInfo/add_addre',	'添加地址',	1,	'',	0,	0,	153,	10,	''),
(193,	'OrderInfo/add_goods',	'添加商品',	1,	'',	0,	0,	153,	10,	''),
(194,	'OrderInfo/search_goods',	'商品搜索',	1,	'',	0,	0,	153,	10,	''),
(195,	'OrderInfo/change_goods',	'商品切换',	1,	'',	0,	0,	153,	10,	''),
(196,	'OrderInfo/add_info',	'添加订单',	1,	'',	0,	0,	153,	10,	''),
(197,	'OrderInfo/order_all_info',	'确定添加',	1,	'',	0,	0,	153,	10,	''),
(198,	'OrderInfo/add_order_goods',	'添加订单商品',	1,	'',	0,	0,	153,	10,	''),
(199,	'OrderInfo/add_order_goods_order',	'提交添加订单',	1,	'',	0,	0,	153,	10,	''),
(200,	'Member/index',	'列表',	1,	'',	0,	0,	53,	10,	''),
(201,	'Member/add',	'编辑',	1,	'',	0,	0,	53,	10,	''),
(202,	'Member/insert',	'插入',	1,	'',	0,	0,	53,	10,	''),
(203,	'Member/deletes',	'删除',	1,	'',	0,	0,	53,	10,	''),
(204,	'Member/edit',	'编辑',	1,	'',	0,	0,	53,	10,	''),
(205,	'Member/view',	'查看',	1,	'',	0,	0,	53,	10,	''),
(206,	'Member/update',	'更新',	1,	'',	0,	0,	53,	10,	''),
(216,	'Intro/index',	'基础配置',	1,	'',	1,	0,	92,	10,	''),
(217,	'Intro/index',	'简介管理',	1,	'',	1,	0,	216,	10,	''),
(218,	'Brand/index',	'品牌管理',	1,	'',	1,	0,	49,	11,	''),
(219,	'Brand/index',	'品牌列表',	1,	'',	1,	0,	218,	10,	''),
(220,	'BrandCategory/index',	'品牌分类',	1,	'',	1,	0,	218,	11,	''),
(222,	'AccountLog/index',	'账户管理',	0,	'',	0,	0,	113,	11,	''),
(223,	'AccountLog/index',	'账户变更记录',	1,	'',	1,	0,	222,	10,	''),
(224,	'PointsRule/index',	'变更规则',	1,	'',	1,	0,	222,	10,	''),
(226,	'TuiHuan/index',	'退货列表',	1,	'',	1,	0,	114,	12,	''),
(227,	'Promote/index',	'营销',	1,	'',	1,	0,	0,	10,	''),
(229,	'Shanghu/index',	'店铺',	1,	'',	1,	0,	0,	998,	''),
(230,	'TuiHuan/refund',	'退款列表',	1,	'',	1,	0,	114,	13,	''),
(233,	'Integral/index',	'积分商品管理',	1,	'',	1,	0,	232,	10,	''),
(234,	'GoodsIntegral/index',	'积分商品列表',	1,	'',	1,	0,	235,	10,	''),
(235,	'GoodsIntegral/index',	'积分商城',	1,	'',	1,	0,	227,	15,	''),
(238,	'Bonu/down_index',	'线下红包',	1,	'',	1,	0,	120,	10,	''),
(240,	'Bonu/push_bonu',	'红包提醒',	1,	'',	1,	0,	120,	11,	''),
(243,	'ConfigMobile/index',	'基本配置',	1,	'',	1,	0,	35,	1,	''),
(246,	'Push/index',	'推送管理',	1,	'',	1,	0,	35,	4,	''),
(247,	'ConfigMobile/group?is_content=8',	'基本配置',	1,	'',	1,	0,	243,	10,	''),
(249,	'Poster/index',	'广告位管理',	1,	'',	1,	0,	35,	10,	''),
(253,	'Poster/mobileindex',	'广告列表',	1,	'',	1,	0,	249,	10,	''),
(254,	'PosterPosition/index?device=1',	'广告位列表',	1,	'',	1,	0,	249,	10,	''),
(255,	'PushSet/edit',	'推送设置',	1,	'',	1,	0,	246,	10,	''),
(269,	'Goods/recycle',	'商品回收站',	1,	'',	1,	0,	50,	10,	''),
(270,	'Suppliers/index',	'供货商管理',	1,	'',	1,	0,	49,	12,	''),
(271,	'Suppliers/index',	'供货商列表',	1,	'',	1,	0,	270,	12,	''),
(272,	'Message/index',	'消息管理',	1,	'3',	1,	0,	48,	10,	''),
(274,	'ProjectLabel/index?type=0',	'商品标签',	1,	'',	1,	0,	50,	10,	''),
(275,	'Goods/index_shops',	'商品列表',	1,	'',	1,	0,	280,	1,	''),
(276,	'Audit/goods_shops',	'商品审核',	1,	'',	1,	0,	280,	2,	''),
(277,	'Goods/recycle_shops',	'商品回收站',	1,	'',	1,	0,	280,	3,	''),
(278,	'GoodsCategory/shops_cateadd?type=4',	'经营类目',	1,	'',	1,	0,	55,	10,	''),
(279,	'Contract/citemlist',	'消费者保障服务',	1,	'',	1,	0,	55,	11,	''),
(280,	'Goods/index_shops',	'店铺商品',	1,	'',	1,	0,	229,	10,	''),
(281,	'ShippingFee/index',	'运费设置',	1,	'',	1,	0,	114,	11,	''),
(282,	'Addons/index',	'插件管理',	1,	'',	1,	0,	29,	12,	''),
(286,	'Shops_Rank/index',	'店铺等级',	1,	'',	1,	0,	55,	10,	''),
(287,	'Cron/index',	'计划任务',	1,	'',	1,	0,	29,	10,	''),
(288,	'Bonu/promot_index',	'活动红包',	1,	'',	1,	0,	120,	10,	''),
(290,	'PromotAct/limit_time',	'限时促销',	1,	'',	1,	0,	119,	10,	''),
(293,	'Floor/index',	'楼层列表',	1,	'',	1,	0,	216,	13,	''),
(295,	'Floor/index?device=1',	'楼层列表',	1,	'',	1,	0,	243,	13,	''),
(299,	'CustomerService/complaint',	'客户服务',	1,	'',	1,	0,	113,	11,	''),
(300,	'CustomerService/complaint',	'投诉列表',	1,	'',	1,	0,	299,	10,	''),
(301,	'CustomerService/platformservice',	'咨询列表',	1,	'',	1,	0,	299,	11,	''),
(302,	'ShipOrder/index',	'发货列表',	1,	'',	1,	0,	114,	14,	''),
(303,	'Intro/mobileindex',	'简介管理',	0,	'',	0,	0,	35,	6,	''),
(304,	'Nav/index',	'导航管理',	0,	'',	0,	0,	35,	8,	''),
(305,	'Intro/mobileindex',	'简介管理',	1,	'',	1,	0,	243,	11,	''),
(306,	'Nav/mobileindex',	'导航管理',	1,	'',	1,	0,	243,	12,	''),
(307,	'ConfigMobile/group?is_content=7',	'微信配置',	1,	'',	1,	0,	77,	10,	''),
(308,	'ShopsPower/powerlist',	'店铺权限',	1,	'',	1,	0,	55,	10,	''),
(309,	'PromotAct/index',	'营销',	1,	'',	1,	0,	229,	10,	''),
(310,	'PromotAct/index_shops',	'优惠活动',	1,	'',	1,	0,	309,	10,	''),
(311,	'PromotAct/limit_time_shop',	'限时促销',	1,	'',	1,	0,	309,	10,	''),
(312,	'MemberWithdrawals/shop_index',	'店铺提现列表',	1,	'',	1,	0,	98,	13,	''),
(313,	'Express/index',	'快递接口',	1,	'',	1,	0,	114,	11,	''),
(314,	'Goods/update',	'商品编辑提交',	1,	'',	1,	0,	51,	10,	''),
(316,	'Goods/stock',	'货品',	1,	'',	1,	0,	51,	10,	''),
(317,	'Goods/stock_update',	'提交',	1,	'',	1,	0,	316,	10,	''),
(318,	'Goods/recycling',	'删除',	1,	'',	1,	0,	51,	10,	''),
(319,	'ProjectLabel/update',	'编辑提交',	1,	'',	1,	0,	274,	10,	''),
(320,	'Brand/update',	'编辑提交',	1,	'',	1,	0,	219,	10,	''),
(321,	'BrandCategory/update',	'编辑提交',	1,	'',	1,	0,	220,	10,	''),
(322,	'cache/allrules',	'更新缓存',	1,	'',	0,	0,	24,	10,	''),
(330,	'Suppliers/update',	'编辑提交',	1,	'',	1,	0,	271,	10,	''),
(331,	'MemberCollect/goods',	'收藏商品',	1,	'',	1,	0,	204,	10,	''),
(332,	'MemberCollect/shops',	'收藏店铺',	1,	'',	1,	0,	204,	10,	''),
(333,	'AccountLog/change_money',	'账号变更提交',	1,	'',	1,	0,	53,	10,	''),
(334,	'MemberRank/update',	'编辑提交',	1,	'',	1,	0,	54,	10,	''),
(335,	'Oauth/update',	'编辑提交',	1,	'',	1,	0,	82,	10,	''),
(336,	'Action/addaction',	'添加行为',	1,	'',	1,	0,	43,	10,	''),
(337,	'Action/saveaction',	'提交',	1,	'',	1,	0,	336,	10,	''),
(338,	'Action/editaction',	'编辑',	1,	'',	1,	0,	43,	10,	''),
(339,	'ExtensionSetting/update',	'提交',	1,	'',	1,	0,	125,	10,	''),
(340,	'ExtensionList/del',	'取消分成',	1,	'',	1,	0,	126,	10,	''),
(341,	'Sms/update',	'编辑提交',	1,	'',	1,	0,	141,	10,	''),
(345,	'SmsTheme/update',	'编辑提交',	1,	'',	1,	0,	142,	10,	''),
(346,	'SmsLogs/index',	'短信邮件',	1,	'',	1,	0,	272,	10,	''),
(347,	'PushLog/index',	'app消息',	1,	'',	1,	0,	272,	10,	''),
(348,	'OauthMember/message',	'微信消息',	1,	'',	1,	0,	272,	10,	''),
(349,	'Bonu/wx_bonu_view',	'查看',	1,	'',	1,	0,	288,	10,	''),
(350,	'Bonu/update',	'编辑提交',	1,	'',	1,	0,	288,	10,	''),
(351,	'Bonu/down_index_add',	'生成线下红包',	1,	'',	1,	0,	238,	10,	''),
(352,	'Bonu/send_oline',	'生成提交',	1,	'',	1,	0,	238,	10,	''),
(353,	'Bonu/delete_user',	'删除',	1,	'',	1,	0,	238,	10,	''),
(354,	'PromotAct/add_limit_time',	'添加限时促销',	1,	'',	1,	0,	290,	10,	''),
(355,	'PromotAct/add_limit_time',	'编辑',	1,	'',	1,	0,	290,	10,	''),
(356,	'PromotAct/view',	'查看',	1,	'',	1,	0,	289,	10,	''),
(357,	'MemberBank/update',	'提现账号的编辑提交',	1,	'',	1,	0,	204,	10,	''),
(358,	'MemberAddress/update',	'收货地址的编辑提交',	1,	'',	1,	0,	204,	10,	''),
(359,	'PromotAct/update',	'编辑提交',	1,	'',	1,	0,	122,	10,	''),
(360,	'PromotAct/insert_limit_time',	'提交',	1,	'',	1,	0,	355,	10,	''),
(361,	'GoodsIntegral/update',	'编辑提交',	1,	'',	1,	0,	234,	10,	''),
(363,	'OrderInfo/ship',	'发货',	1,	'',	0,	0,	179,	10,	''),
(364,	'OrderInfo/deliver_goods',	'发货',	1,	'',	1,	0,	363,	10,	''),
(365,	'OrderInfo/store_shou',	'签收',	1,	'',	1,	0,	94,	10,	''),
(366,	'OrderInfo/search_goods',	'搜索',	1,	'',	0,	0,	182,	10,	''),
(367,	'OrderInfo/add_order_goods_order',	'加入订单',	1,	'',	0,	0,	182,	10,	''),
(368,	'Shipping/update',	'编辑',	1,	'',	1,	0,	68,	10,	''),
(369,	'Shipping/shipping_template',	'编辑打印模板',	1,	'',	1,	0,	68,	10,	''),
(370,	'Express/update',	'编辑提交',	1,	'',	1,	0,	313,	10,	''),
(371,	'TuiHuan/content',	'拒绝',	1,	'',	1,	0,	226,	10,	''),
(372,	'TuiHuan/notagree',	'拒绝理由提交',	1,	'',	1,	0,	371,	10,	''),
(373,	'TuiHuan/confirm_goods',	'收货',	1,	'',	1,	0,	226,	10,	''),
(374,	'TuiHuan/agree',	'同意',	1,	'',	1,	0,	226,	10,	''),
(375,	'TuiHuan/edit_refund',	'推款提交',	1,	'',	1,	0,	230,	10,	''),
(376,	'TuiHuan/refund',	'搜索',	1,	'',	1,	0,	230,	10,	''),
(377,	'ShipOrder/edit_ship',	'修改提交',	1,	'',	1,	0,	302,	10,	''),
(378,	'Payment/update',	'编辑提交',	1,	'',	1,	0,	76,	10,	''),
(379,	'AccountLog/show_account',	'查看会员账号日志',	1,	'',	1,	0,	100,	10,	''),
(380,	'MemberWithdrawals/do_tixian',	'处理',	1,	'',	1,	0,	100,	10,	''),
(381,	'Shops/searchuser',	'店铺搜索',	1,	'',	1,	0,	312,	10,	''),
(382,	'Suppliers/index_shops',	'供货商',	1,	'',	1,	0,	312,	10,	''),
(383,	'ShippingFee/shop_list',	'运费设置',	1,	'',	1,	0,	312,	10,	''),
(384,	'ShopsArticle/update',	'店铺动态编辑提交',	1,	'',	1,	0,	312,	10,	''),
(385,	'CustomerService/update',	'回复提交',	1,	'',	1,	0,	300,	10,	''),
(386,	'Intro/update',	'编辑提交',	1,	'',	1,	0,	217,	10,	''),
(388,	'Template/setting',	'设计风格',	1,	'',	1,	0,	45,	10,	''),
(389,	'Floor/update',	'编辑提交',	1,	'',	1,	0,	293,	10,	''),
(390,	'ArticleCat/update',	'编辑提交',	1,	'',	1,	0,	59,	10,	''),
(391,	'Article/update',	'编辑提交',	1,	'',	1,	0,	58,	10,	''),
(392,	'Cache/clearcache',	'跟新缓存',	1,	'',	1,	0,	65,	10,	''),
(393,	'PosterPosition/update',	'编辑提交',	1,	'',	1,	0,	65,	10,	''),
(394,	'PosterPosition/call',	'调用',	1,	'',	1,	0,	65,	10,	''),
(395,	'poster/update',	'编辑提交',	1,	'',	1,	0,	64,	10,	''),
(396,	'FriendLink/update',	'编辑提交',	1,	'',	1,	0,	61,	10,	''),
(397,	'FriendlinkCat/update',	'编辑提交',	1,	'',	1,	0,	62,	10,	''),
(398,	'area/updatecache',	'跟新缓存',	1,	'',	1,	0,	46,	10,	''),
(399,	'area/update',	'修改提交',	1,	'',	1,	0,	46,	10,	''),
(400,	'config/sitting2',	'地区设置',	1,	'',	1,	0,	46,	10,	''),
(401,	'cron/update',	'编辑提交',	1,	'',	1,	0,	287,	10,	''),
(402,	'UrlRules/update',	'编辑提交',	1,	'',	1,	0,	242,	10,	''),
(403,	'type/update',	'编辑提交',	1,	'',	1,	0,	101,	10,	''),
(404,	'addons/create',	'快速创建',	1,	'',	1,	0,	282,	10,	''),
(405,	'addons/hooks',	'钩子管理',	1,	'',	1,	0,	282,	10,	''),
(406,	'addons/addhook',	'新增钩子',	1,	'',	1,	0,	405,	10,	''),
(407,	'addons/edithook',	'编辑',	1,	'',	1,	0,	405,	10,	''),
(408,	'addons/UpdateHook',	'编辑提交',	1,	'',	1,	0,	407,	10,	''),
(409,	'addons/delhook',	'删除',	1,	'',	1,	0,	405,	10,	''),
(412,	'AuthGroup/edit',	'编辑',	1,	'',	1,	0,	11,	10,	''),
(413,	'AuthGroup/update',	'提交',	1,	'',	1,	0,	412,	10,	''),
(414,	'ShopbalanceLog/re_js',	'结算',	1,	'',	1,	0,	112,	10,	''),
(415,	'ShopsPower/update',	'编辑提交',	1,	'',	1,	0,	308,	10,	''),
(416,	'ShopsPower/applylist',	'权限加入申请',	1,	'',	1,	0,	308,	10,	''),
(417,	'ShopsPower/quitlist',	'权限退出申请',	1,	'',	1,	0,	308,	10,	''),
(418,	'ShopsPower/contractlist',	'店铺权限',	1,	'',	1,	0,	308,	10,	''),
(419,	'ShopsPower/audit',	'通过',	1,	'',	1,	0,	416,	10,	''),
(420,	'ShopsRank/update',	'编辑提交',	1,	'',	1,	0,	286,	10,	''),
(421,	'GoodsCategory/del_cateadd',	'删除',	1,	'',	1,	0,	278,	10,	''),
(422,	'GoodsCategory/operate_shops_cateadd',	'审核',	1,	'',	1,	0,	278,	10,	''),
(423,	'GoodsCategory/check_cates',	'审核拒绝',	1,	'',	1,	0,	278,	10,	''),
(424,	'GoodsCategory/balance_shops',	'结算设置',	1,	'',	1,	0,	278,	10,	''),
(425,	'audit/edit_shops',	'查看',	1,	'',	1,	0,	130,	10,	''),
(426,	'audit/audit_shops',	'审核通过',	1,	'',	1,	0,	425,	10,	''),
(427,	'audit/audit_shop',	'审核通过',	1,	'',	1,	0,	130,	10,	''),
(428,	'audit/audit_shop',	'审核不通过',	1,	'',	1,	0,	130,	10,	''),
(429,	'contract/applylist',	'服务加入申请',	1,	'',	1,	0,	279,	10,	''),
(430,	'contract/quitlist',	'服务退出申请',	1,	'',	1,	0,	279,	10,	''),
(431,	'contract/contractlist',	'店铺保障服务',	1,	'',	1,	0,	279,	10,	''),
(432,	'contract/audit',	'通过',	1,	'',	1,	0,	429,	10,	''),
(433,	'OrderInfo/search_goods',	'搜索',	1,	'',	1,	0,	310,	10,	''),
(434,	'audit/audit',	'审核不通过',	1,	'',	1,	0,	276,	10,	''),
(435,	'WxKeywords/updatefirst',	'提交',	1,	'',	1,	0,	80,	10,	''),
(436,	'WxKeywords/update',	'编辑提交',	1,	'',	1,	0,	79,	10,	''),
(437,	'WxMenu/update',	'编辑提交',	1,	'',	1,	0,	78,	10,	''),
(438,	'WxMenu/updatemenu',	'生成微信自定义菜单',	1,	'',	1,	0,	78,	10,	''),
(440,	'bonu/tixing',	'批量提醒',	1,	'',	1,	0,	240,	10,	''),
(441,	'Goods/export',	'导出',	1,	'',	1,	0,	51,	10,	''),
(442,	'Member/export',	'导出',	1,	'',	1,	0,	53,	10,	''),
(443,	'PromotAct/ajaxgetshopgoods',	'商品搜索',	1,	'',	1,	0,	289,	10,	''),
(444,	'GoodsIntegral/search_goods',	'商品搜索',	1,	'',	1,	0,	234,	10,	''),
(445,	'PromotAct/ajaxgetgoods',	'商品搜索',	1,	'',	1,	0,	311,	10,	''),
(446,	'PromotAct/ajaxgetgoods',	'商品搜索',	1,	'',	1,	0,	290,	10,	''),
(447,	'PromotAct/view_son',	'查看',	1,	'',	1,	0,	356,	10,	''),
(448,	'Audit/nopass_reason',	'不通过',	1,	'',	1,	0,	429,	10,	''),
(449,	'database/docommand',	'分析',	1,	'',	1,	0,	111,	10,	''),
(450,	'database/docommand',	'检查',	1,	'',	1,	0,	111,	10,	''),
(451,	'database/backup',	'执行备份',	1,	'',	1,	0,	111,	10,	''),
(452,	'config/sitting7',	'奖励配置',	1,	'',	1,	0,	53,	10,	''),
(453,	'config/sitting1',	'会员配置',	1,	'',	1,	0,	53,	10,	''),
(455,	'DistributionSetting/index',	'分销管理',	1,	'',	1,	0,	48,	10,	''),
(456,	'DistributionSetting/index',	'分销设置',	1,	'',	1,	0,	455,	10,	''),
(457,	'DistributionSetting/check',	'分销商审核',	1,	'',	1,	0,	455,	10,	''),
(458,	'DistributionSetting/fx_list',	'分销商列表',	1,	'',	1,	0,	455,	10,	''),
(459,	'DistributionSetting/chexiao',	'撤销分销商',	1,	'',	1,	0,	458,	10,	''),
(460,	'DistributionSetting/禁止分销商',	'禁止分销商',	1,	'',	1,	0,	458,	10,	''),
(465,	'Nav/mobileindex',	'手机端导航',	1,	'',	1,	0,	304,	10,	''),
(467,	'Nav/mobileindex',	'手机端导航',	1,	'',	1,	0,	306,	10,	'');

DROP TABLE IF EXISTS `hanchao_bonu`;
CREATE TABLE `hanchao_bonu` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `type_name` varchar(60) NOT NULL DEFAULT '' COMMENT '红包名称',
  `type_money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '红包金额',
  `send_type` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '发放类型',
  `every_num` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL COMMENT '发放数量，针对微信红包',
  `odds` varchar(255) CHARACTER SET utf8 COLLATE utf8_unicode_ci NOT NULL COMMENT '中奖率，针对微信红包',
  `use_start_date` int(11) NOT NULL DEFAULT '0' COMMENT '开始使用时间',
  `use_end_date` int(11) NOT NULL DEFAULT '0' COMMENT '结束使用时间',
  `min_goods_amount` decimal(10,2) unsigned NOT NULL DEFAULT '0.00' COMMENT '使用下限',
  `type` tinyint(5) unsigned NOT NULL COMMENT '适用范围：1,分类;2,品牌;3,活动',
  `type_value` int(10) unsigned NOT NULL COMMENT '类型值',
  `shop_id` int(10) unsigned NOT NULL COMMENT '店铺ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=29 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='红包表';

INSERT INTO `hanchao_bonu` (`id`, `type_name`, `type_money`, `send_type`, `every_num`, `odds`, `use_start_date`, `use_end_date`, `min_goods_amount`, `type`, `type_value`, `shop_id`) VALUES
(26,	'5元代金券',	5.00,	5,	'',	'',	1501731546,	1533267548,	100.00,	3,	108,	38),
(27,	'20元代金券',	20.00,	5,	'',	'',	1504073041,	1506751452,	50.00,	3,	155,	44),
(28,	'50元代金券',	50.00,	5,	'',	'',	1504073041,	1506751452,	100.00,	3,	155,	44);

DROP TABLE IF EXISTS `hanchao_brand`;
CREATE TABLE `hanchao_brand` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '品牌主键',
  `brand_cat_id` int(10) NOT NULL DEFAULT '0' COMMENT '品牌分类',
  `brand_name` varchar(60) NOT NULL COMMENT '品牌名字',
  `brand_logo` varchar(80) NOT NULL COMMENT '品牌log',
  `brand_img` varchar(80) NOT NULL COMMENT '品牌图片',
  `brand_infoimg` varchar(80) NOT NULL COMMENT '品牌介绍图片',
  `site_url` varchar(255) NOT NULL COMMENT '品牌网址',
  `content` text NOT NULL,
  `shop_id` int(11) NOT NULL COMMENT '店铺id',
  `price` decimal(20,2) NOT NULL COMMENT '保证金',
  `sort` smallint(5) NOT NULL DEFAULT '10' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否显示',
  `updatetime` int(10) NOT NULL COMMENT '更新时间',
  `seotitle` varchar(255) NOT NULL COMMENT 'seo题目',
  `seokeywords` varchar(255) NOT NULL COMMENT 'seo关键字',
  `seodescription` varchar(255) NOT NULL COMMENT 'Seo描述',
  `brand_phone` varchar(32) NOT NULL COMMENT '品牌电话',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='品牌表';

INSERT INTO `hanchao_brand` (`id`, `brand_cat_id`, `brand_name`, `brand_logo`, `brand_img`, `brand_infoimg`, `site_url`, `content`, `shop_id`, `price`, `sort`, `status`, `updatetime`, `seotitle`, `seokeywords`, `seodescription`, `brand_phone`) VALUES
(32,	12,	'mi',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170802/5981b6d0a105f.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170802/5981babed23bf.png',	'http://',	'',	0,	0.00,	10,	1,	1501746074,	'',	'',	'',	''),
(33,	12,	'韩都衣舍',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170802/5981bbb589eda.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170802/5981bbc3e01a7.png',	'http://',	'',	0,	0.00,	10,	1,	1501746052,	'',	'',	'',	''),
(34,	12,	'对白',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170802/5981bd791ba5d.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170802/5981bd80ba4f2.png',	'http://',	'',	0,	0.00,	10,	1,	1501746044,	'',	'',	'',	''),
(35,	12,	'AIOV',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170802/5981be0e03345.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170802/5981be183b1a0.png',	'http://',	'',	0,	0.00,	10,	1,	1501746036,	'',	'',	'',	''),
(36,	12,	'一米阳光',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170802/5981bec217117.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170802/5981becac5884.png',	'http://',	'',	0,	0.00,	10,	1,	1501746027,	'',	'',	'',	''),
(37,	12,	'丝柏舍',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170802/5981bfa71c1fd.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170802/5981bf7f441c8.png',	'http://',	'',	0,	0.00,	10,	1,	1501746018,	'',	'',	'',	''),
(38,	12,	'依嬅莎',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170802/5981c0f42b638.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170802/5981c0fe6acd8.png',	'http://',	'',	0,	0.00,	10,	1,	1501746006,	'',	'',	'',	''),
(39,	12,	'美特斯邦威',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170802/5981c1ffbbfac.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170802/5981c20b78454.png',	'http://',	'',	0,	0.00,	10,	1,	1501745996,	'',	'',	'',	''),
(40,	11,	'大嘴猴',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170802/5981c3c009b77.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170802/5981c3c831e07.png',	'http://',	'',	0,	0.00,	10,	1,	1501676469,	'',	'',	'',	''),
(41,	11,	'CAMEL',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170802/5981c46517499.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170802/5981c46f50ddb.png',	'http://',	'',	0,	0.00,	10,	1,	1501676581,	'',	'',	'',	''),
(42,	11,	'361度',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170802/5981c54c8670d.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170802/5981c557ad28b.png',	'http://',	'',	0,	0.00,	10,	1,	1501676848,	'',	'',	'',	''),
(43,	10,	'奥尼橄榄油',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982ce4cba228.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982ce55bff05.png',	'http://',	'',	0,	0.00,	10,	1,	1501745984,	'',	'',	'',	''),
(44,	10,	'bestjoy',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982d174aa15a.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982d17fa8953.png',	'http://',	'',	0,	0.00,	10,	1,	1501745974,	'',	'',	'',	''),
(45,	10,	'艾吉适瑞厨卫',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982d59dcee78.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982d5a8d46ce.png',	'http://',	'',	0,	0.00,	10,	1,	1501746460,	'',	'',	'',	''),
(47,	12,	'VEE',	'',	'',	'',	'http://',	'',	0,	0.00,	10,	1,	1502073809,	'',	'',	'',	''),
(48,	10,	'太祖食品',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170809/598abf8b013df.jpg',	'',	'',	'http://',	'',	0,	0.00,	10,	1,	1502265187,	'',	'',	'',	''),
(49,	0,	'富安娜',	'',	'',	'',	'',	'',	43,	0.00,	10,	1,	0,	'',	'',	'',	''),
(50,	0,	'爱仕达',	'',	'',	'',	'',	'',	43,	0.00,	10,	1,	0,	'',	'',	'',	''),
(51,	0,	'西瓜刀',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/5997ee3ec2fc5.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/5997ee470cec4.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/5997ee5978051.jpg',	'',	'',	48,	0.00,	10,	1,	0,	'',	'',	'',	''),
(52,	0,	'绝世好刀',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/5997ef33130ef.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/5997ef383aa3b.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/5997ef3e414bc.jpg',	'',	'',	48,	0.00,	10,	1,	0,	'',	'',	'',	''),
(53,	0,	'艾玛',	'',	'',	'',	'',	'',	44,	0.00,	10,	1,	0,	'',	'',	'',	''),
(54,	0,	'奔驰',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170906/59afa2363831c.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170906/59afa2952b6e0.jpg',	'',	'',	'',	49,	0.00,	10,	1,	0,	'',	'',	'',	''),
(55,	0,	'宝马',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170906/59afa37ee719b.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170906/59afa386ecb86.jpg',	'',	'',	'',	49,	0.00,	10,	1,	0,	'',	'',	'',	''),
(56,	0,	'奥迪',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170906/59afa3faa0317.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170906/59afa401872e6.jpg',	'',	'',	'',	49,	0.00,	10,	1,	0,	'',	'',	'',	'');

DROP TABLE IF EXISTS `hanchao_brand_category`;
CREATE TABLE `hanchao_brand_category` (
  `id` int(100) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `name` varchar(255) NOT NULL COMMENT '品牌分类名称',
  `pid` tinyint(10) NOT NULL COMMENT '父id',
  `is_home` tinyint(1) NOT NULL COMMENT '是否首页推荐（0否，1是）',
  `sort` smallint(5) NOT NULL COMMENT '排序',
  `status` tinyint(1) NOT NULL COMMENT '状态（0禁用，1启用）',
  `price` decimal(20,2) NOT NULL COMMENT '申请品牌需缴纳的费用',
  PRIMARY KEY (`id`),
  KEY `is_home` (`is_home`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='品牌分类表';

INSERT INTO `hanchao_brand_category` (`id`, `name`, `pid`, `is_home`, `sort`, `status`, `price`) VALUES
(10,	'生活居家',	0,	1,	100,	1,	0.00),
(11,	'运动',	0,	0,	90,	1,	0.00),
(12,	'女装',	0,	1,	10,	1,	0.00);

DROP TABLE IF EXISTS `hanchao_cart`;
CREATE TABLE `hanchao_cart` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `user_id` int(255) NOT NULL COMMENT '会员id',
  `cookie_id` varchar(255) NOT NULL COMMENT 'cookie_id',
  `goods_id` int(255) NOT NULL COMMENT '商品id',
  `goods_name` varchar(255) NOT NULL COMMENT '商品名称',
  `goods_sn` varchar(255) NOT NULL COMMENT '商品码',
  `shop_price` decimal(10,2) NOT NULL COMMENT '本店价',
  `price_goods_attr` decimal(10,2) NOT NULL COMMENT '商品属性价',
  `shop_id` int(255) NOT NULL COMMENT '店铺id',
  `all_price` decimal(10,2) NOT NULL COMMENT '总价',
  `goods_num` tinyint(10) NOT NULL COMMENT '库存',
  `cart_integral` int(255) NOT NULL COMMENT '积分',
  `goods_attr` varchar(255) NOT NULL COMMENT '商品属性',
  `goods_img` varchar(255) NOT NULL COMMENT '商品相册',
  `is_group_goods` tinyint(10) NOT NULL COMMENT '是否是组合购买',
  `brand_id` int(10) NOT NULL COMMENT '品牌id',
  `catid` int(11) NOT NULL COMMENT '分类id',
  `cart_id` int(11) NOT NULL COMMENT '优惠活动id',
  `price_type` int(10) NOT NULL COMMENT '1原价2会员价3促销价4活动价5积分商城',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=370 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='购物车表';


DROP TABLE IF EXISTS `hanchao_category`;
CREATE TABLE `hanchao_category` (
  `cat_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类id',
  `cat_name` varchar(90) NOT NULL DEFAULT '' COMMENT '分类名称',
  `keywords` varchar(255) NOT NULL DEFAULT '' COMMENT '关键词',
  `cat_desc` varchar(255) NOT NULL DEFAULT '' COMMENT '暂无（备用字段）',
  `parent_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '父id',
  `sort_order` tinyint(1) unsigned NOT NULL DEFAULT '50' COMMENT '排序',
  `template_file` varchar(50) NOT NULL DEFAULT '' COMMENT '暂无（备用字段）',
  `measure_unit` varchar(15) NOT NULL DEFAULT '' COMMENT '暂无（备用字段）',
  `show_in_nav` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否展示在导航',
  `style` varchar(150) NOT NULL COMMENT '暂无（备用字段）',
  `is_show` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '是否显示',
  `grade` tinyint(4) NOT NULL DEFAULT '0' COMMENT '品牌等级',
  `filter_attr` varchar(255) NOT NULL DEFAULT '0' COMMENT '过滤属性',
  PRIMARY KEY (`cat_id`),
  KEY `parent_id` (`parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='分类备用表';

INSERT INTO `hanchao_category` (`cat_id`, `cat_name`, `keywords`, `cat_desc`, `parent_id`, `sort_order`, `template_file`, `measure_unit`, `show_in_nav`, `style`, `is_show`, `grade`, `filter_attr`) VALUES
(1,	'女士上装',	'',	'',	0,	50,	'',	'',	0,	'',	1,	5,	'172,185,178'),
(2,	'女士下装',	'',	'',	1,	50,	'',	'',	0,	'',	1,	0,	'6'),
(3,	'女士配件',	'',	'',	1,	50,	'',	'台',	1,	'',	1,	4,	'185,189,173,178'),
(4,	'女士内衣',	'',	'',	1,	50,	'',	'',	1,	'',	1,	0,	'28'),
(5,	'居家创意',	'',	'',	1,	50,	'',	'',	0,	'',	1,	5,	'18'),
(6,	'美妆护肤',	'',	'',	0,	50,	'',	'',	1,	'',	1,	0,	'0'),
(7,	'眼镜配饰',	'',	'',	6,	50,	'',	'',	0,	'',	1,	0,	'0'),
(8,	'珠宝名表',	'',	'',	6,	50,	'',	'',	0,	'',	1,	0,	'0'),
(9,	'鞋靴箱包',	'',	'',	6,	50,	'',	'',	0,	'',	1,	0,	'0'),
(11,	'纯棉',	'',	'',	6,	50,	'',	'',	0,	'',	1,	0,	'0'),
(12,	'女装流行',	'',	'',	0,	50,	'',	'',	0,	'',	1,	0,	'0'),
(13,	'品牌女装',	'',	'',	12,	50,	'',	'',	0,	'',	1,	0,	'0');

DROP TABLE IF EXISTS `hanchao_comment`;
CREATE TABLE `hanchao_comment` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '评论类型1商品，2文章',
  `vid` int(10) NOT NULL DEFAULT '0' COMMENT '文章或者商品的id',
  `pid` int(10) NOT NULL DEFAULT '0' COMMENT '回复id',
  `email` varchar(60) NOT NULL COMMENT '邮箱',
  `uid` int(10) NOT NULL DEFAULT '0' COMMENT '会员id',
  `content` text NOT NULL COMMENT '评论的内容',
  `rank` tinyint(1) NOT NULL DEFAULT '0' COMMENT '评论星级',
  `score` tinyint(1) NOT NULL COMMENT '评分',
  `img` text NOT NULL COMMENT '评论图片',
  `ip` bigint(15) NOT NULL COMMENT '评论时的ip',
  `order_id` int(10) NOT NULL COMMENT '订单ID',
  `addtime` int(10) NOT NULL DEFAULT '0' COMMENT '评论的时间',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否批准显示',
  `shop_id` int(10) NOT NULL COMMENT '店铺id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='评论表';


DROP TABLE IF EXISTS `hanchao_config`;
CREATE TABLE `hanchao_config` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '配置ID',
  `name` varchar(30) NOT NULL COMMENT '配置名称',
  `type` tinyint(3) unsigned NOT NULL COMMENT '配置类型，0数字,1字符,2文本,3数组,4下拉,5密码,6图片,7表格',
  `title` varchar(50) NOT NULL COMMENT '配置说明',
  `group` tinyint(3) NOT NULL COMMENT '配置分组,0隐藏,1内容,2显示,3附件,4系统',
  `extra` varchar(255) NOT NULL COMMENT '配置值',
  `remark` varchar(255) NOT NULL COMMENT '配置说明',
  `create_time` int(10) NOT NULL COMMENT '创建时间 ',
  `update_time` int(10) NOT NULL COMMENT '更新时间',
  `status` tinyint(1) NOT NULL COMMENT '状态',
  `value` text NOT NULL COMMENT '配置值',
  `sort` smallint(3) NOT NULL COMMENT '排序',
  `device` tinyint(3) NOT NULL COMMENT '设备（0系统1会员2地区3订单4信息5微信6移动端7奖励）',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=163 DEFAULT CHARSET=utf8 COMMENT='配置表';

INSERT INTO `hanchao_config` (`id`, `name`, `type`, `title`, `group`, `extra`, `remark`, `create_time`, `update_time`, `status`, `value`, `sort`, `device`) VALUES
(1,	'WEB_SITE_NAME',	1,	'网站名称',	1,	'',	'网站简称',	1378898976,	1379235274,	1,	'汉潮B2B2C多用户商城系统',	0,	0),
(2,	'WEB_SITE_TITLE',	1,	'网站标题',	1,	'',	'显示在浏览器的标题栏',	1378898976,	1379235274,	1,	'汉潮B2B2C多用户商城系统 V2.1.2',	0,	0),
(3,	'WEB_SITE_KEYWORD',	2,	'网站关键字',	1,	'',	'网站搜索引擎关键字',	1378898976,	1379235274,	1,	'汉潮,多用户商城系统,汉潮B2B2C',	1,	0),
(4,	'WEB_SITE_DESCRIPTION',	2,	'网站描述',	1,	'',	'网站搜索引擎描述',	1378898976,	1379235274,	1,	'汉潮多用户商城系统，支持平台自营与多商家店铺共存模式，能全面支持IOS/Android/Wap/微信等移动平台。以其丰富的营销功能，精细化的用户运营，解决电商引流、推广难题，帮助企业打造生态级B2B2C盈利模式商业平台。完备的电商功能，为企业提升了行业电商品牌的美誉度。系统安全、稳定、快速，便捷的功能扩展及可以进行二次开发的商城源码，为企业电商业务长线快速发展提供了强有力的保障。\r\n适用企业：各类百货MALL、行业实体市场、电商产业园、行业协会、行业门户网站等。',	0,	0),
(5,	'WEB_SITE_LOGO',	6,	'网站LOGO',	1,	'',	'',	1378898976,	1379235274,	1,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170606/59366ece3da2f.png',	1,	0),
(6,	'WEB_SITE_PHONE',	1,	'客服电话',	1,	'',	'',	0,	0,	1,	'4000311340',	150,	0),
(7,	'WEB_SITE_QQ',	1,	'客服QQ',	1,	'',	'多个客服QQ，请在每个号码之间使用半角逗号（,）分隔',	0,	0,	1,	'2647927826',	150,	0),
(8,	'WEB_SITE_EMAIL',	1,	'客服邮件',	1,	'',	'',	0,	0,	1,	'sevice@hanchao9999.com',	150,	0),
(9,	'WEB_WORKER_TIME',	1,	'工作时间',	1,	'',	'',	0,	0,	1,	'9:00 - 18:00',	30,	0),
(10,	'CONTENT_SEARCH',	2,	'热门搜索',	1,	'',	'多个热门搜索词之间使用半角逗号（,）分隔.',	0,	0,	1,	'干果,三只松鼠,韩都衣舍,拖鞋,洁丽雅,抱枕,床上用品',	25,	0),
(11,	'WEB_SITE_CLOSE',	4,	'关闭站点',	1,	'0:关闭,1:开启',	'站点关闭后其他用户不能访问，管理员可以正常访问',	0,	0,	1,	'1',	10,	0),
(12,	'WEB_SITE_ICP',	2,	'版权信息',	1,	'',	'设置在网站底部显示版权和备案号等信息',	0,	0,	1,	'石家庄久途网络有限公司版权所有',	2,	0),
(13,	'STATS_CODE',	2,	'统计代码',	1,	'',	'显示在&lt;body&gt;&lt;/body&gt;之间.',	0,	0,	1,	'<script type=\"text/javascript\">var cnzz_protocol = ((\"https:\" == document.location.protocol) ? \" https://\" : \" http://\");document.write(unescape(\"%3Cspan id=\'cnzz_stat_icon_1261724804\'%3E%3C/span%3E%3Cscript src=\'\" + cnzz_protocol + \"s11.cnzz.com/z_stat.php%3Fid%3D1261724804%26show%3Dpic\' type=\'text/javascript\'%3E%3C/script%3E\"));</script>',	20,	0),
(14,	'WEB_SITE_HEADER',	2,	'头部代码',	1,	'',	'显示在&lt;head&gt;&lt;meta name=&quot;__hash__&quot; content=&quot;66edcb08fc383a745ebd5e0ef3c31413_ba1e2fd6e5e8679aa7bbb1f371677441&quot; /&gt;&lt;/head&gt;之间',	0,	0,	1,	'',	20,	0),
(15,	'MARKET_PRICE_RATIO',	1,	'市场价格比例',	1,	'',	'输入商品售价时将自动根据该比例计算市场价格',	0,	0,	1,	'120',	26,	0),
(17,	'WEB_INTEGRAL_RATIO',	0,	'积分换算比例',	1,	'',	'每100积分可抵多少元现金',	0,	0,	1,	'10',	105,	0),
(18,	'INTGRAL_PAY_RATIO',	1,	'积分支付比例',	1,	'',	'每100元商品最多可以使用多少元积分',	0,	0,	1,	'10',	105,	0),
(19,	'GOODS_NUM_PREFIX',	1,	'商品货号前缀',	1,	'',	'',	0,	0,	1,	'HC',	26,	0),
(20,	'WEB_DEFAULT_PAGE',	1,	'默认分页数',	2,	'',	'列表页每页显示记录数.',	0,	0,	1,	'15',	200,	0),
(21,	'WEB_GOODS_PAGE',	1,	'商品分页数',	2,	'',	'商品列表页和积分商城列表页每页显示记录数',	0,	0,	1,	'20',	200,	0),
(22,	'WEB_BUSINESS_PAGE',	1,	'商家分页数',	2,	'',	'',	0,	0,	1,	'15',	200,	0),
(23,	'WEB_ARTICLE_PAGE',	1,	'文章分页数',	2,	'',	'文章列表页每页显示记录数.',	0,	0,	1,	'8',	200,	0),
(24,	'WEB_ACTIVE_PAGE',	1,	'优惠活动分页数',	2,	'',	'优惠活动列表页每页显示记录数',	0,	0,	1,	'8',	200,	0),
(25,	'RECOMMENDED_MERCHANT_NUM',	1,	'首页推荐商家个数',	2,	'',	'',	0,	0,	1,	'10',	200,	0),
(26,	'BROWSING_HISTORY_NUM',	0,	'浏览历史显示个数',	2,	'',	'',	0,	0,	1,	'20',	200,	0),
(27,	'RELATE_GOODS_NUM',	1,	'相关商品显示个数',	2,	'',	'显示多少个购买此商品的人还买过哪些商品',	0,	0,	1,	'8',	200,	0),
(28,	'WEB_SALES_NUM',	1,	'销量排行显示个数',	2,	'',	'',	0,	0,	1,	'6',	200,	0),
(29,	'NEW_ARTICLE_NUM',	1,	'最新文章显示数量',	2,	'',	'',	0,	0,	1,	'10',	200,	0),
(30,	'UPLOAD_EXTS',	1,	'文件后缀',	3,	'',	'',	0,	0,	1,	'jpg,gif,png,jpeg,zip,rar,tar,gz,7z,doc,docx,txt,xml',	300,	0),
(31,	'UPLOAD_IMGEXTS',	1,	'图片后缀',	3,	'',	'',	0,	0,	1,	'jpg,gif,png,jpeg',	300,	0),
(32,	'UPLOAD_MAXSIZE',	0,	'上传大小',	3,	'',	'单位:M',	0,	0,	1,	'5',	300,	0),
(33,	'UPLOAD_PATH',	1,	'附件目录',	3,	'',	'',	0,	0,	1,	'uploads/',	300,	0),
(34,	'UPLOAD_FILEMANAGE',	4,	'编辑器文件管理',	3,	'1:启用, 0:禁用',	'',	0,	0,	1,	'1',	300,	0),
(35,	'THUMB_TYPE',	4,	'水印类型',	3,	'0:关闭, 1:图片, 2:文字,',	'',	0,	0,	1,	'0',	300,	0),
(36,	'IMAGE_WATERMARK',	6,	'图片水印',	3,	'',	'',	0,	0,	1,	'',	300,	0),
(37,	'TEXT_WATERMARK',	1,	'文字水印',	3,	'',	'文字|字号|颜色|字体',	0,	0,	1,	'HANCHAO|12',	300,	0),
(38,	'THUMB_PALACE',	4,	'水印位置',	3,	'1|左上角水印, 2|上居中水印, 3|右上角水印, 4|左居中水印, 5|居中水印, 6|右居中水印, 7|左下角水印, 8|下居中水印, 9|右下角水印,',	'',	0,	0,	1,	'7',	300,	0),
(39,	'GOODS_DEFAULT_IMG',	6,	'商品默认图',	3,	'',	'请上传小于2M的图片',	0,	0,	1,	'',	300,	0),
(40,	'HEAD_DEFAULT_IMG',	6,	'头像默认图',	3,	'',	'  请上传小于2M的图片',	0,	0,	1,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/598958d78f09a.png',	300,	0),
(41,	'WE_SAFE_PROTECT',	4,	'安全防护',	4,	'1:启用, 0:禁用',	'',	0,	0,	1,	'1',	400,	0),
(42,	'DB_SQL_BUILD_CACHE',	4,	'SQL解析缓存',	4,	'TRUE:开启, FALSE:关闭,',	'',	0,	0,	1,	'TRUE',	400,	0),
(43,	'DB_SQL_BUILD_LENGTH',	0,	'SQL缓存队列长度',	4,	'',	'',	0,	0,	1,	'20',	400,	0),
(44,	'DATA_CACHE_TIME',	0,	'SQL缓存有效期',	4,	'',	'单位:秒',	0,	0,	1,	'300',	400,	0),
(45,	'DEFAULT_FILTER',	1,	'数据过滤',	4,	'',	'',	0,	0,	1,	'htmlspecialchars,trim',	400,	0),
(46,	'CONTENT_LABEL_FILTER',	2,	'内容标签过滤',	4,	'',	'内容页内容保留标签用|分隔，如:p|span|ul|li.',	0,	0,	1,	'',	400,	0),
(47,	'OUTPUT_ENCODE',	4,	'GZIP压缩',	4,	'0:禁用, 1:启用,',	'',	0,	0,	1,	'1',	400,	0),
(48,	'URL_HTML_SUFFIX',	1,	'URL后缀',	4,	'',	'',	0,	0,	1,	'html',	400,	0),
(49,	'URL_PATHINFO_DEPR',	1,	'PATHINFO分割符',	4,	'',	'',	0,	0,	1,	'/',	400,	0),
(50,	'SHOW_PAGE_TRACE',	4,	'是否显示页面Trace',	4,	'0:关闭, 1:开启,',	'',	0,	0,	1,	'0',	400,	0),
(51,	'DATA_BACKUP_PATH',	1,	'数据库备份根路径',	4,	'',	'路径必须以 / 结尾',	0,	0,	1,	'Backup/',	400,	0),
(52,	'ADMIN_ALLOW_IP',	2,	'后台允许访问IP',	4,	'',	'多个用逗号分隔，如果不配置表示不限制IP访问',	0,	0,	1,	'',	400,	0),
(53,	'NOT_ALLOW_IP',	2,	'禁止访问IP',	4,	'',	'多个用逗号分隔，如果不配置表示不限制IP访问.',	0,	0,	1,	'',	400,	0),
(54,	'MEMBER_UC',	4,	'Ucenter整合',	1,	'0:禁用, 1:启用,',	'',	0,	0,	1,	'0',	100,	1),
(55,	'MEMBER_UCONFIG',	2,	'Ucenter整合参数',	1,	'',	'',	0,	0,	1,	'',	100,	1),
(56,	'MEMBER_AUTOLOGIN',	0,	'自动登录',	1,	'',	'自动登录超时时间,单位秒',	0,	0,	1,	'60400',	30,	1),
(57,	'MEMBER_TIXIAN',	4,	'会员提现',	1,	'1:允许, 0:不允许',	'',	0,	0,	1,	'1',	100,	1),
(58,	'EXTENSION_SETTING',	4,	'推广设置',	1,	'0:关闭,1:开启',	'',	0,	0,	1,	'1',	100,	1),
(59,	'SMS_REG_VERIFY',	4,	'注册短信验证',	1,	'0:关闭,1:开启',	'',	0,	0,	1,	'1',	100,	1),
(60,	'MEMBER_ALLOW_REGISTER',	4,	'是否允许用户注册',	1,	'0:关闭, 1:允许',	'',	0,	0,	1,	'1',	90,	1),
(65,	'NOT_ADD_CART',	4,	'是否允许未登录加入购物车',	1,	'0:禁止, 1:允许',	'',	0,	0,	1,	'1',	90,	3),
(66,	'ORDER_SHOW_NUM',	0,	'订单列表显示数量',	1,	'',	'',	0,	0,	1,	'8',	100,	3),
(67,	'OPEN_INVOICE',	4,	'能否开发票',	1,	'0:不能, 1:能',	'',	0,	0,	1,	'1',	100,	3),
(68,	'INVOICE_CONTENT',	2,	'发票内容',	1,	'',	'客户要求开发票时可以选择的内容。例如：办公用品。每一行代表一个选项',	0,	0,	1,	'',	100,	3),
(69,	'ZONE_LEVEL',	4,	'区域显示级别',	1,	'1|一级,2|二级,3|三级,4|四级,5|五级',	'',	0,	0,	1,	'3',	100,	2),
(70,	'ONE_REGION',	1,	'一级区域名称',	1,	'',	'',	0,	0,	1,	'国',	100,	2),
(71,	'TWO_REGION',	1,	'二级区域名称',	1,	'',	'',	0,	0,	1,	'省',	100,	2),
(72,	'THREE_REGION',	1,	'三级区域名称',	1,	'',	'',	0,	0,	1,	'市',	100,	2),
(73,	'FOUR_REGION',	1,	'四级区域名称',	1,	'',	'',	0,	0,	1,	'区县',	100,	2),
(74,	'FIVE_REGION',	1,	'五级区域名称',	1,	'',	'',	0,	0,	1,	'乡镇',	100,	2),
(77,	'CONFIG_TYPE_LIST',	0,	'配置类型列表',	0,	'',	'主要用于数据解析和页面表单的生成',	1378898976,	1379235348,	1,	'0:数字,\r\n1:字符,\r\n2:文本,\r\n3:编辑器,\r\n4:下拉,\r\n5:密码,\r\n6:图片,\r\n7:表格',	0,	0),
(78,	'CONFIG_GROUP_LIST',	0,	'配置分组',	0,	'',	'配置分组',	1379228036,	1384418383,	1,	'1:内容,\r\n2:显示,\r\n3:附件,\r\n4:系统,\r\n5: 邮件',	0,	0),
(79,	'AUTH_CONFIG',	3,	'Auth配置',	0,	'',	'自定义Auth.class.php类配置',	1379409310,	1379409564,	1,	'AUTH_ON:1,\r\nAUTH_TYPE:1,',	0,	0),
(80,	'TEMPLATE_PATH',	4,	'模板设置',	0,	'',	'',	0,	0,	1,	'Home:前台模板\r\nMobile:手机模板',	0,	0),
(81,	'NAV_SETTING',	2,	'导航选项',	0,	'',	'',	0,	0,	1,	'0|头部导航,\r\n2|顶部导航,\r\n1|底部导航,\r\n3|手机导航,\r\n5|APP导航',	0,	0),
(83,	'INVOICE_TYPE',	7,	'发票类型及税率',	1,	'0:类型,1:税率',	'',	0,	0,	1,	'增值税专用发票:0.1,\r\n增值税普通发票:0.08,\r\n普通发票:0.08',	100,	3),
(84,	'DEVICE_GROUP_LIST',	4,	'设备分组',	0,	'',	'设备分组',	1379228036,	1384418383,	1,	'0:系统,1:会员,2:地区,3:订单,4:信息,5:微信,6:移动端,7:奖励',	0,	0),
(85,	'AFFILIATE',	0,	'',	0,	'',	'',	0,	0,	1,	'a:2:{s:6:\"config\";a:8:{s:6:\"expire\";s:1:\"2\";s:11:\"expire_unit\";s:1:\"1\";s:5:\"point\";s:2:\"10\";s:4:\"bonu\";N;s:5:\"money\";s:2:\"10\";s:11:\"bonu_expire\";N;s:16:\"bonu_expire_unit\";N;s:7:\"buy_num\";s:1:\"0\";}s:4:\"item\";a:3:{i:1;a:2:{s:11:\"level_point\";s:1:\"5\";s:11:\"level_money\";s:1:\"5\";}i:2;a:2:{s:11:\"level_point\";s:1:\"8\";s:11:\"level_money\";s:1:\"8\";}i:3;a:2:{s:11:\"level_point\";s:2:\"10\";s:11:\"level_money\";s:2:\"10\";}}}',	0,	0),
(86,	'SELL_INTEGRAL_NAME',	1,	'消费积分名称',	1,	'',	'您可以将消费积分重新命名。例如：积分',	0,	0,	1,	'积分',	105,	0),
(87,	'RANK_INTEGRAL_NAME',	1,	'等级积分名称',	1,	'',	'您可以将等级积分重新命名，例如：积分',	0,	0,	1,	'等级积分',	105,	0),
(88,	'SMTP_FTP_ADDRESS',	2,	'SMTP服务器地址',	5,	'',	'如：smtp.163.com',	0,	0,	1,	'smtp.126.com',	0,	0),
(89,	'SMTP_FTP_NAME',	2,	'SMTP服务帐户名',	5,	'',	'',	0,	0,	1,	'liqingbd@126.com',	0,	0),
(91,	'SMTP_FTP_PWD',	2,	' SMTP服务密码',	5,	'',	'',	0,	0,	1,	'',	0,	0),
(93,	'SEND_EMAIL_ADDRESS',	2,	'发信人邮件地址',	5,	'',	'',	0,	0,	1,	'',	0,	0),
(94,	'SMTP_SHORT',	0,	'SMTP 端口',	5,	'',	'默认：25',	0,	0,	1,	'25',	0,	0),
(95,	'USER_CHECK_EMAIL',	4,	'用户注册时自动发送验证邮件',	5,	'0:关闭,1:开启',	'是否开启会员邮件验证”设为开启时才可使用此功能',	0,	0,	1,	'1',	0,	0),
(96,	'BAIDU_MAP_KEY',	1,	'百度地图APPKEY',	1,	'',	'',	0,	0,	1,	'ydA0u9OSRkdNv8Gs8dF3EdNL',	25,	0),
(97,	'HOOKS_TYPE',	3,	'钩子的类型',	0,	'',	'类型 1-用于扩展显示内容，2-用于扩展业务处理',	1379313397,	1379313407,	1,	'1:视图,\r\n2:控制器,',	6,	0),
(98,	'WE_TASK_METHOD',	4,	'计划任务触发形式',	4,	'1:客户端触发, 0:服务器触发',	'',	0,	0,	1,	'1',	400,	0),
(99,	'WE_TASK_METHOD_TIME',	0,	'触发时间间隔',	4,	'',	'计划任务触发的时间间隔，单位s/秒',	0,	0,	1,	'10',	400,	0),
(100,	'LOGIN_GAIN_SELL_INTEGRAL',	0,	'登录赠消费积分',	1,	'',	'',	0,	0,	1,	'20',	100,	7),
(101,	'SALES_GAIN_SELL_INTEGRAL',	1,	'消费赠消费积分(封顶)',	1,	'',	'',	0,	0,	1,	'1000',	102,	7),
(102,	'REG_GAIN_SELL_INREGRAL',	0,	'注册赠消费积分',	1,	'',	'',	0,	0,	1,	'120',	104,	7),
(103,	'COMMENT_GAIN_SELL_INREGRAL',	0,	'评论商品赠消费积分',	1,	'',	'',	0,	0,	1,	'30',	106,	7),
(104,	'LOGIN_GAIN_RANK_INTEGRAL',	0,	'登录赠等级积分',	1,	'',	'',	0,	0,	1,	'15',	101,	7),
(105,	'SALES_GAIN_RANK_INTEGRAL',	1,	'消费赠等级积分(封顶)',	1,	'',	'',	0,	0,	1,	'1000',	103,	7),
(106,	'REG_GAIN_RANK_INREGRAL',	1,	'注册赠等级积分',	1,	'',	'',	0,	0,	1,	'80',	105,	7),
(107,	'COMMENT_GAIN_RANK_INREGRAL',	0,	'评论商品赠等级积分',	1,	'',	'',	0,	0,	1,	'20',	107,	7),
(108,	'SALES_GAIN_RANK_INTEGRAL_RATE',	1,	'消费赠等级积分比例',	1,	'',	'',	0,	0,	1,	'100',	109,	7),
(109,	'SALES_GAIN_SELL_INTEGRAL_RATE',	1,	'消费赠消费积分比例',	1,	'',	'',	0,	0,	1,	'10',	108,	7),
(110,	'WX_ACCOUNT',	1,	'用户名',	7,	'',	'微信公众平台的用户名',	0,	0,	1,	'久途网络',	0,	5),
(111,	'WX_ID',	1,	'原始id',	7,	'',	'公众号原始id如:gh_123456',	0,	0,	1,	'gh_8b59084bd44e',	0,	5),
(112,	'WX_TOKEN',	1,	'TOKEN码',	7,	'',	'开发模式的TOKEN码&lt;a href=&quot;?s=Public/wxtoken.html&quot; target=&quot;_blank&quot;&gt;生成&lt;/a&gt;',	0,	0,	1,	'qweqw0q4522',	0,	5),
(113,	'WX_APPID',	1,	'公众号AppId',	7,	'',	'',	0,	0,	1,	'wx2919d1f504432992',	0,	5),
(114,	'WX_APPSECRET',	1,	'公众号AppSecret',	7,	'',	'',	0,	0,	1,	'4d547519a3aeba5131bcd6e335791824',	0,	5),
(115,	'WEB_SITE_MOBILE_LOGO',	6,	'手机LOGO',	8,	'',	'',	0,	0,	1,	'',	0,	0),
(116,	'APP_ANDROID_DOWNURL',	1,	'安卓下载链接',	8,	'',	'',	0,	0,	1,	'',	0,	0),
(117,	'APP_IOS_DOWNURL',	1,	'苹果下载链接',	8,	'',	'',	0,	0,	1,	'',	0,	0),
(118,	'WEB_SITE_ICP_MOBILE',	2,	'版权信息',	8,	'',	'设置在网站底部显示的备案号，如“沪ICP备12007941号-2',	1378900335,	1379235859,	1,	'石家庄久途网络有限公司版权所有',	9,	1),
(119,	'WX_TYPE',	4,	'微信',	7,	'1:订阅号,\r\n2:认证订阅号,\r\n3:服务号,\r\n4:认证服务号,',	'',	0,	0,	1,	'1',	0,	0),
(120,	'CONFIG_GROUP_MOBILE_LIST',	0,	'配置分组',	0,	'',	'配置分组（移动端）',	0,	0,	1,	'7:微信\r\n8:内容',	0,	0),
(121,	'IS_FILL_RECOMMEND',	4,	'是否填写推荐人',	1,	'0:关闭,1:开启',	'',	0,	0,	1,	'1',	90,	0),
(122,	'MEMBER_BANK',	1,	'提现银行',	1,	'工商银行,建设银行,农业银行,中信银行',	'',	0,	0,	1,	'工商银行,建设银行,农业银行,中信银行',	100,	0),
(123,	'TIXIAN_FREE',	0,	'提现手续费',	1,	'0.01',	'0为无手续费,小于1为百分比,大于1为固定值',	0,	0,	1,	'5',	100,	0),
(124,	'MEMBER_RECRIVE_ADDRESS_NUM',	0,	'收货地址个数',	1,	'',	'会员最多创建的收货地址个数',	0,	0,	1,	'2',	100,	1),
(125,	'ORDER_TYPE',	2,	'订单分类',	0,	'1:商品,2:充值,3:其它,',	'',	0,	0,	1,	'1:商品,\r\n3:其它,\r\n6:拼团\r\n7:预售',	0,	3),
(126,	'ORDER_STATUS',	2,	'订单状态',	0,	'',	'',	0,	0,	1,	'1:未确认,\r\n2:已确认,\r\n3:已完成,\r\n4:已取消,\r\n5:做废,\r\n6:退款中,\r\n7:已退款,\r\n8:退货中,\r\n9:已退货,\r\n10:已过期,',	0,	3),
(127,	'ORDER_PAY',	2,	'支付状态',	0,	'',	'',	0,	0,	1,	'1:未支付,\r\n2:支付中,\r\n3:已支付,\r\n4:部分支付,\r\n5:已付定金,',	0,	3),
(128,	'ORDER_SHIPPING',	2,	'配送状态',	0,	'',	'',	0,	0,	1,	'1:未发货,\r\n2:部分发货,\r\n3:已发货,\r\n4:已收货,\r\n5:待成团,',	0,	3),
(129,	'ACCOUNT_TYPE',	2,	'账户变更类型',	0,	'',	'',	0,	0,	1,	'1:资金,\r\n2:冻结资金,\r\n3:等级积分,\r\n4:消费积分,',	0,	3),
(130,	'ACCOUNT_STATUS',	2,	'账户操作类型',	0,	'',	'',	0,	0,	1,	'1:充值,\r\n2:提现,\r\n3:管理员调节,\r\n4:支付,\r\n5:其他,\r\n6:确认收货,\r\n7:登录赠消费积分,\r\n8:登录赠等级积分,\r\n9:注册赠消费积分,\r\n10:注册赠等级积分,',	0,	3),
(131,	'IS_BALANCE',	4,	'是否自动结算',	1,	'0:关闭,1:开启',	'',	0,	0,	1,	'1',	90,	0),
(132,	'IS_REBATE',	4,	'是否自动分成',	1,	'0:关闭,1:开启',	'',	0,	0,	1,	'1',	90,	0),
(133,	'CANCEL_ORDER_TIME',	0,	'自动取消订单时间',	1,	'',	'单位天',	0,	0,	1,	'7',	30,	0),
(134,	'WEB_CNZZ_SITEID',	1,	'站点ID',	1,	'',	'',	0,	0,	1,	'1261724804',	10,	0),
(135,	'SMS_TX_VERIFY',	4,	'提现短信验证',	1,	'0:关闭,1:开启',	'',	0,	0,	1,	'1',	100,	0),
(136,	'OPEN_PAYPSW',	4,	'支付密码',	1,	'0:关闭,1:开启',	'',	0,	0,	1,	'1',	25,	0),
(137,	'SMS_SEND_TYPE',	4,	'消息发送',	5,	'1:即时发送,\r\n0:关闭发送',	'',	0,	0,	1,	'1',	0,	0),
(138,	'MOBILE_TURE_TIME',	0,	'短信验证码有效时间',	1,	'',	'单位/秒',	0,	0,	1,	'120',	30,	0),
(139,	'IS_MEMBER_UPGRADE',	4,	'是否自动升会员等级',	1,	'0:否,1:是',	'',	0,	0,	1,	'1',	90,	1),
(140,	'USER_ACCOUNT_DATE',	0,	'会员账期',	1,	'',	'账期/天',	0,	0,	1,	'7',	0,	1),
(141,	'SHOP_ACCOUNT_DATE',	0,	'店铺账期',	1,	'',	'店铺提现账期/天',	0,	0,	1,	'7',	100,	0),
(142,	'USER_MIN_GET_MONEY',	0,	'会员最低提现金额',	1,	'',	'单位：元',	0,	0,	1,	'1',	100,	1),
(143,	'SHOP_MIN_GET_MONEY',	0,	'店铺最低提现金额',	1,	'',	'单位：元',	0,	0,	1,	'1',	100,	0),
(144,	'SHOP_TIXIAN_FREE',	0,	'店铺提现手续费',	1,	'',	'0为无手续费,小于1为百分比,大于1为固定值',	0,	0,	1,	'0.015',	100,	0),
(145,	'SAFE_VERIFY',	4,	'验证码安全',	4,	'1:最简,\r\n2:曲线,\r\n3:杂点,\r\n4:曲线杂点,\r\n5:背景图',	'',	0,	0,	1,	'3',	100,	0),
(148,	'APPLY_DISTRIBU',	1,	'申请分销商',	0,	'',	'',	0,	0,	1,	'1',	0,	0),
(149,	'COORDINATE',	0,	'海报头像、昵称和二维码的坐标',	0,	'',	'依次是头像、昵称，二维码，用|隔开',	0,	0,	1,	'100,100|435,660|315,855',	0,	0),
(150,	'BOTTOM_IMG',	6,	'海报底图',	0,	'',	'',	0,	0,	1,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170809/598a726d1aa23.jpg',	0,	0),
(151,	'FONT_SIZE',	0,	'海报字号设置',	0,	'',	'',	0,	0,	1,	'50',	0,	0),
(152,	'RECORDS',	0,	'分销记录',	0,	'',	'',	0,	0,	1,	'1',	0,	0),
(153,	'COMMISSION',	0,	'非分销商佣金记录显示',	0,	'',	'',	0,	0,	1,	'1',	0,	0),
(154,	'WEB_PROMOT_PAGE',	1,	'限时促销分页数',	2,	'',	'限时促销列表页每页显示记录数',	0,	0,	1,	'20',	200,	0),
(155,	'WEB_GROUPS_PAGE',	1,	'拼团分页数',	2,	'',	'拼团列表页每页显示记录数',	0,	0,	1,	'20',	200,	0),
(156,	'WEB_PRESELL_PAGE',	1,	'预售分页数',	2,	'',	'预售列表页每页显示记录数',	0,	0,	1,	'20',	200,	0),
(157,	'ERWEIMA',	0,	'二维码宽高设置',	0,	'',	'',	0,	0,	1,	'450',	0,	0),
(158,	'PERMANENT',	0,	'永久临时二维码',	0,	'',	'',	0,	0,	1,	'1',	0,	0),
(159,	'TOUXIANG',	0,	'海报头像大小',	0,	'',	'',	0,	0,	1,	'300',	0,	0),
(160,	'TUI_WRIT',	3,	'推广奖励规则',	0,	'',	'',	0,	0,	1,	'&lt;p&gt;\r\n	1.会员申请分销商通过后推荐会员注册才可获得获得奖励。\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	2.给予优惠。\r\n&lt;/p&gt;\r\n&lt;p&gt;\r\n	3.特定商品。\r\n&lt;/p&gt;',	0,	0),
(161,	'SHOW_LIVE_MODEL',	4,	'是否开启直播功能',	4,	'0:关闭, 1:开启,',	'',	0,	0,	1,	'0',	400,	0),
(162,	'DIS_CON',	0,	'分销条件',	0,	'',	'',	0,	0,	1,	'',	0,	0);

DROP TABLE IF EXISTS `hanchao_cron`;
CREATE TABLE `hanchao_cron` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键自增索引',
  `name` varchar(50) NOT NULL COMMENT '计划名称',
  `classname` varchar(50) NOT NULL COMMENT '计划任务标识',
  `type` tinyint(1) NOT NULL COMMENT '预留',
  `interval_time` int(10) NOT NULL COMMENT '时间基数',
  `execute_time` int(10) NOT NULL COMMENT '时间值',
  `start_time` int(11) unsigned NOT NULL COMMENT '开始执行时间',
  `last_time` int(11) unsigned NOT NULL COMMENT '最后执行时间',
  `next_time` int(11) unsigned NOT NULL COMMENT '下次执行时间',
  `param1` varchar(50) NOT NULL COMMENT '预留参数1',
  `param2` varchar(50) NOT NULL COMMENT '预留参数2',
  `remark` varchar(255) NOT NULL COMMENT '备注',
  `is_result` tinyint(1) NOT NULL COMMENT '是否返回状态',
  `status` tinyint(1) NOT NULL COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='计划任务表';

INSERT INTO `hanchao_cron` (`id`, `name`, `classname`, `type`, `interval_time`, `execute_time`, `start_time`, `last_time`, `next_time`, `param1`, `param2`, `remark`, `is_result`, `status`) VALUES
(1,	'定时清理缓存',	'ClearCache',	0,	1,	86400,	0,	1,	2,	'0',	'0',	'',	1,	0),
(2,	'定时弹窗',	'Popup',	0,	20,	1,	1491981787,	1504912508,	1504912528,	'',	'',	'',	1,	1),
(3,	'自动取消订单',	'CancelOrder',	0,	5,	86400,	1491981903,	1495178703,	1495610703,	'7',	'',	'',	1,	1),
(4,	'自动确认收货',	'ConfirmOrder',	0,	7,	86400,	1491981971,	1495005971,	1495610771,	'7',	'',	'',	1,	1);

DROP TABLE IF EXISTS `hanchao_express`;
CREATE TABLE `hanchao_express` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `name` varchar(255) NOT NULL COMMENT '名称',
  `img` varchar(255) NOT NULL COMMENT '图片',
  `code` varchar(100) NOT NULL COMMENT '代号',
  `username` varchar(100) NOT NULL COMMENT '会员名称',
  `password` varchar(255) NOT NULL COMMENT '密码',
  `param1` text NOT NULL COMMENT '参数1',
  `param2` varchar(255) NOT NULL COMMENT '参数2',
  `gettype` tinyint(1) NOT NULL DEFAULT '0' COMMENT '请求方式1 url 2 接口',
  `content` text NOT NULL COMMENT '内容',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='快递接口';

INSERT INTO `hanchao_express` (`id`, `name`, `img`, `code`, `username`, `password`, `param1`, `param2`, `gettype`, `content`, `status`) VALUES
(1,	'快递100',	'',	'Kuaidi100',	'free',	'',	'',	'',	1,	'',	1);

DROP TABLE IF EXISTS `hanchao_floor`;
CREATE TABLE `hanchao_floor` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `name` varchar(20) NOT NULL COMMENT '楼层名称',
  `floor_code` varchar(20) NOT NULL COMMENT '楼层标识',
  `background_img` varchar(80) NOT NULL COMMENT '楼层图标',
  `background_color` varchar(20) NOT NULL COMMENT '背景色',
  `theme` varchar(80) NOT NULL COMMENT '主题模板',
  `hot_searching` text NOT NULL COMMENT '楼层热搜',
  `bind_cateid` int(10) NOT NULL COMMENT '绑定的分类',
  `recommend_cate` varchar(255) NOT NULL COMMENT '推荐分类',
  `is_show_children` tinyint(1) NOT NULL COMMENT '是否显示子分类商品',
  `is_show_brand` tinyint(1) NOT NULL COMMENT '是否显示品牌',
  `sort` smallint(5) NOT NULL DEFAULT '10' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态',
  `device` tinyint(1) NOT NULL COMMENT '0电脑端1手机端',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='楼层表';

INSERT INTO `hanchao_floor` (`id`, `name`, `floor_code`, `background_img`, `background_color`, `theme`, `hot_searching`, `bind_cateid`, `recommend_cate`, `is_show_children`, `is_show_brand`, `sort`, `status`, `device`) VALUES
(1,	'F1食品饮料',	'F1',	'',	'#f15453',	'FloorTheme_1',	'三只松鼠,牛轧糖,芒果酥,橄榄油,干果,巴灵猴,新农哥,开心果,太祖',	1,	'9',	1,	1,	1,	1,	0),
(2,	'F2家居生活',	'F2',	'',	'black',	'FloorTheme_2',	'洁丽雅,春笑,内野,毛巾,拖鞋,空调被,四件套,六件套,保温杯,牙膏,修护霜,保湿霜,换肤水,乐我家纺',	153,	'157',	1,	1,	2,	1,	0),
(16,	'F3服装配饰',	'F3',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170518/591d485eeddda.png',	'black',	'FloorTheme_3',	'韩都衣舍,韩版女装,连衣裙,外套,雪纺衫,风衣,连体裤,T恤,衬衫,休闲百搭',	115,	'116',	0,	0,	10,	1,	0),
(22,	'食品饮料',	'F1',	'',	'red',	'',	'',	1,	'9',	0,	0,	100,	1,	1),
(23,	'家居生活',	'F2',	'',	'red',	'',	'',	157,	'',	0,	0,	10,	1,	1),
(24,	'服装配饰',	'F3',	'',	'red',	'',	'',	116,	'',	0,	0,	50,	1,	1);

DROP TABLE IF EXISTS `hanchao_friendlink`;
CREATE TABLE `hanchao_friendlink` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `catid` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '链接分类ID',
  `title` varchar(200) NOT NULL COMMENT '标题',
  `content` varchar(255) NOT NULL COMMENT '联系人',
  `url` varchar(255) NOT NULL COMMENT '链接地址',
  `logo` varchar(255) NOT NULL COMMENT '链接logo ',
  `sort` smallint(5) NOT NULL DEFAULT '10' COMMENT '排序',
  `status` tinyint(1) NOT NULL COMMENT '是否在导航条显示',
  `addtime` int(10) NOT NULL COMMENT '添加时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='友情链接';

INSERT INTO `hanchao_friendlink` (`id`, `catid`, `title`, `content`, `url`, `logo`, `sort`, `status`, `addtime`) VALUES
(1,	2,	'O2O智慧门店系统',	'O2O智慧门店系统',	'http://www.hanchao9999.com/',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170726/597865ca91c6c.png',	10,	1,	1401185572),
(2,	2,	'百度',	'百度',	'http://www.baidu.com',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170415/58f1b01f1fbd9.png',	10,	1,	1433147199),
(3,	2,	'汉潮B2B2C',	'汉潮B2B2C',	'http://b2b2b.hanchao9999.com',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170726/597865ca91c6c.png',	10,	1,	1433147416),
(4,	2,	'天猫',	'天猫',	'http://tmall.com',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170602/5931168382c59.png',	10,	1,	1433147486),
(14,	2,	'支付宝',	'支付宝',	'http://alipay.com',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170602/59311638947db.gif',	10,	1,	1433148080);

DROP TABLE IF EXISTS `hanchao_friendlink_cat`;
CREATE TABLE `hanchao_friendlink_cat` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '分类ID',
  `name` varchar(255) NOT NULL COMMENT '分类名称',
  `sort` smallint(5) NOT NULL DEFAULT '10' COMMENT '排序',
  `status` tinyint(1) NOT NULL COMMENT '是否在导航条显示',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='友情链接分类表';

INSERT INTO `hanchao_friendlink_cat` (`id`, `name`, `sort`, `status`) VALUES
(1,	'默认分类',	10,	1),
(2,	'底部链接',	10,	1);

DROP TABLE IF EXISTS `hanchao_goods`;
CREATE TABLE `hanchao_goods` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '商品ID',
  `cat_id` int(10) NOT NULL DEFAULT '0' COMMENT '分类ID',
  `shop_cat_id` int(10) NOT NULL COMMENT '店铺分类',
  `goods_sn` char(20) NOT NULL COMMENT '商品货号',
  `goods_name` varchar(120) NOT NULL COMMENT '商品名称',
  `brand_id` int(10) NOT NULL DEFAULT '0' COMMENT '品牌ID',
  `shop_id` int(10) NOT NULL COMMENT '店铺ID',
  `suppliers_id` int(10) NOT NULL COMMENT '供货商ID',
  `goods_number` smallint(5) NOT NULL DEFAULT '0' COMMENT '商品库存',
  `goods_weight` decimal(10,3) NOT NULL DEFAULT '0.000' COMMENT '商品重量',
  `market_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '市场售价',
  `shop_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '本店售价',
  `supply_price` decimal(10,2) NOT NULL COMMENT '结算价',
  `user_min_bought` int(10) NOT NULL COMMENT '会员下单的最小量',
  `user_max_bought` int(10) NOT NULL COMMENT '每个会员购买的上限',
  `img` char(100) NOT NULL COMMENT '商品图片',
  `is_shipping` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否为免运费商品',
  `is_prop` tinyint(1) NOT NULL COMMENT '是否为自营商品',
  `is_integral` tinyint(1) NOT NULL COMMENT '是否参与积分抵现',
  `is_best` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否为精品',
  `is_new` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否为新品',
  `is_hot` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否热卖',
  `is_index` tinyint(1) NOT NULL DEFAULT '0' COMMENT '推荐到首页',
  `is_promote` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否促销',
  `promote_id` int(11) NOT NULL COMMENT '促销id',
  `promote_start_time` int(10) NOT NULL COMMENT '促销活动开始时间',
  `promote_end_time` int(10) NOT NULL COMMENT '促销活动的结束时间',
  `promote_price` decimal(20,2) NOT NULL COMMENT '促销价',
  `is_referral` tinyint(1) NOT NULL COMMENT '是否参与返利',
  `is_delete` tinyint(1) NOT NULL COMMENT '删除标识，回收站',
  `count` int(10) NOT NULL DEFAULT '0' COMMENT '商品点击数',
  `avg_point` float(14,4) NOT NULL COMMENT '用户评分的好评率',
  `sell_count` int(10) NOT NULL COMMENT '销量',
  `addtime` int(10) NOT NULL DEFAULT '0' COMMENT '添加商品时间',
  `updatetime` int(10) NOT NULL DEFAULT '0' COMMENT '上次商品更新时间',
  `sort` smallint(5) NOT NULL DEFAULT '10' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否上架',
  `publish_wait` tinyint(1) NOT NULL COMMENT '商家提交的产品 0:等待审核 1:已审核 2:审核不通过',
  `dp_count` int(10) NOT NULL COMMENT '总参与的点评人数 ',
  `avg_score` int(10) NOT NULL COMMENT '用户评分的平均分 ',
  `dp_count_1` int(10) NOT NULL COMMENT '1星点评数',
  `dp_count_2` int(10) NOT NULL COMMENT '2星点评数',
  `dp_count_3` int(10) NOT NULL COMMENT '3星点评数',
  `dp_count_4` int(10) NOT NULL COMMENT '4星点评数',
  `dp_count_5` int(10) NOT NULL COMMENT '5星点评数',
  `pt_id` int(10) NOT NULL COMMENT '拼团活动id ',
  `pre_id` int(10) NOT NULL COMMENT '预售活动id ',
  PRIMARY KEY (`id`),
  KEY `goods_name` (`goods_name`)
) ENGINE=InnoDB AUTO_INCREMENT=263 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='商品表';

INSERT INTO `hanchao_goods` (`id`, `cat_id`, `shop_cat_id`, `goods_sn`, `goods_name`, `brand_id`, `shop_id`, `suppliers_id`, `goods_number`, `goods_weight`, `market_price`, `shop_price`, `supply_price`, `user_min_bought`, `user_max_bought`, `img`, `is_shipping`, `is_prop`, `is_integral`, `is_best`, `is_new`, `is_hot`, `is_index`, `is_promote`, `promote_id`, `promote_start_time`, `promote_end_time`, `promote_price`, `is_referral`, `is_delete`, `count`, `avg_point`, `sell_count`, `addtime`, `updatetime`, `sort`, `status`, `publish_wait`, `dp_count`, `avg_score`, `dp_count_1`, `dp_count_2`, `dp_count_3`, `dp_count_4`, `dp_count_5`, `pt_id`, `pre_id`) VALUES
(7,	49,	0,	'SHOP_SN0000007',	'夏威夷果干果',	0,	0,	0,	96,	0.000,	37.90,	36.90,	35.90,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/58eece707633a.jpg',	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.6000,	1,	0,	1499838543,	10,	1,	1,	2,	3,	1,	0,	0,	0,	1,	0,	0),
(8,	49,	0,	'SHOP_SN0000008',	'果仁干果礼盒',	0,	0,	0,	11,	0.000,	99.00,	98.00,	96.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/58eed1823c46c.jpg',	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	1.0000,	2,	0,	1500451681,	10,	1,	1,	2,	5,	0,	0,	0,	0,	2,	0,	0),
(9,	99,	5,	'SHOP_SN0000009',	'华为 HUAWEI nova 青春版',	0,	1,	0,	10,	0.000,	1999.00,	1999.00,	1000.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/58eed42853faa.jpg',	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	0,	1492047063,	10,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(13,	78,	17,	'SHOP_SN0000013',	'得宝Tempo迷你4层天然无味手帕纸商务长款大包面巾纸巾10包/条T0139',	0,	2,	0,	1,	0.000,	11.00,	10.60,	10.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/58ef24d062df8.jpg',	0,	0,	1,	1,	1,	1,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	0,	0,	10,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(35,	109,	48,	'SHOP_SN0000035',	'威克多(VICTOR)羽毛球大师6号/金黄1号球/特惠级鹅毛鸭毛球稳定耐打训练比赛用球 粉特惠级 鸭毛球(1桶装)',	0,	7,	0,	98,	0.500,	86.00,	76.00,	66.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170424/58fd951c69a43.png',	1,	0,	1,	1,	1,	1,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	1.0000,	1,	0,	1495691203,	10,	1,	1,	1,	5,	0,	0,	0,	0,	1,	0,	0),
(36,	109,	48,	'SHOP_SN0000036',	'威克多（Victor）羽毛球粉胜利特惠红胜利练习级羽毛球金黄比赛训练球 特惠级3筒装',	24,	7,	6,	89,	1.000,	256.00,	226.00,	200.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170424/58fdb9be3d021.png',	1,	0,	1,	1,	1,	1,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	1.0000,	7,	0,	1495691543,	10,	1,	1,	1,	5,	0,	0,	0,	0,	1,	0,	0),
(37,	0,	29,	'SHOP_SN0000037',	'ceshi',	0,	6,	0,	1,	0.000,	0.00,	0.00,	0.00,	0,	0,	'',	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	0,	0,	10,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(58,	0,	0,	'SHOP_SN0000058',	'dsfds',	0,	17,	0,	1,	0.000,	0.00,	0.00,	0.00,	0,	0,	'',	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	0,	0,	10,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(78,	157,	0,	'SHOP_SN0000078',	'馨牌 苏格兰纯棉毛巾3条件装',	0,	0,	0,	99,	0.000,	36.00,	30.00,	25.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/592930b47c23a.jpg',	1,	0,	1,	1,	1,	1,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	0,	1495871629,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(79,	157,	0,	'SHOP_SN0000079',	'金号 素色提缎纯棉毛巾 6条装 68×33.5cm GA1238 绿桔紫各2条',	0,	0,	0,	99,	0.000,	60.00,	50.00,	40.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/592931453a2bd.jpg',	1,	0,	1,	1,	1,	1,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	0,	1495871768,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(80,	157,	0,	'SHOP_SN0000080',	'洁丽雅 纯棉毛巾6条组强吸水 条纹情侣清爽面巾舒适柔软3红3灰 6410',	0,	0,	0,	67,	0.000,	60.00,	50.00,	40.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/59293276d06a1.png',	1,	0,	1,	1,	1,	1,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.2000,	32,	0,	1495872038,	10,	1,	1,	2,	1,	2,	0,	0,	0,	0,	0,	0),
(81,	157,	0,	'SHOP_SN0000081',	'馨牌 英国格 纯棉 浴巾 咖色',	0,	0,	0,	100,	0.000,	48.00,	40.00,	35.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/592932fe4f6a7.jpg',	1,	0,	1,	1,	1,	1,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	0,	1495872196,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(82,	157,	0,	'SHOP_SN0000082',	'Gumila 春夏秋季情侣拖鞋 居家可爱猫咪亲子款 地板防滑凉拖鞋米色女大码：适合38-39脚',	0,	0,	0,	97,	0.000,	48.00,	40.00,	35.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/592933f6c8ecc.png',	1,	0,	1,	1,	1,	1,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	1.0000,	2,	0,	1495872416,	10,	1,	1,	1,	5,	0,	0,	0,	0,	1,	0,	0),
(83,	157,	0,	'SHOP_SN0000083',	'内野Uchino 素色 绣字 纯棉 面巾2件装 UUH02789D*2 1蓝色1粉色',	0,	0,	0,	96,	0.000,	36.00,	30.00,	25.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/5929345ff1796.jpg',	1,	0,	1,	1,	1,	1,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.5000,	3,	0,	1503976888,	10,	1,	1,	4,	2,	2,	0,	1,	0,	1,	0,	0),
(84,	157,	0,	'SHOP_SN0000084',	'lovo 乐我家纺罗莱公司出品 床上用品新品 抱枕靠枕靠垫子小黄鸭系列靠垫 小黄鸭系列靠垫-印象时光50*50cm',	0,	0,	0,	98,	0.000,	84.00,	70.00,	60.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/59293539da4f6.png',	1,	0,	1,	1,	1,	1,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	0,	1495872783,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(85,	157,	0,	'SHOP_SN0000085',	'春笑 抱枕空调被 节日礼物 多用靠垫空调毯子珊瑚绒毛毯 靠枕 毛绒 三合一 小号',	0,	0,	0,	73,	0.000,	72.00,	60.00,	50.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/592935ded3d2d.png',	1,	0,	1,	1,	1,	1,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	20,	0,	1495872949,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(86,	49,	0,	'SHOP_SN0000086',	'【三只松鼠】森林坚果大礼包6袋装 1208g',	0,	0,	0,	0,	0.000,	99.60,	83.00,	75.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/5929370b53b71.jpg',	1,	0,	1,	1,	1,	1,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	0,	1495873217,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(87,	49,	0,	'SHOP_SN0000087',	'【三只松鼠】开心果225gx2',	0,	0,	0,	90,	0.000,	66.00,	55.00,	50.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/592938b62f794.jpg',	1,	0,	1,	1,	1,	1,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	0,	1495873639,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(88,	49,	0,	'SHOP_SN0000088',	'新农哥 每日坚果 缤纷果仁30gx7包 混合坚果仁干果零食特产 独立小包 每日果仁坚果礼品',	0,	0,	0,	98,	0.000,	42.00,	35.00,	30.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/592939895d70d.png',	1,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	0,	1495873837,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(89,	49,	0,	'SHOP_SN0000089',	'三只松鼠 能量果仁182g 休闲零食每日坚果混合坚果果仁奥运会定制版三只松鼠 能量果仁182g 休闲零食每日坚果混合坚果果仁奥运会定制版三只松鼠 能量果仁182g 休闲零食每日坚果混合坚果果仁奥运会定制版三只松鼠 能量果仁182g 休闲零食',	0,	0,	0,	98,	0.000,	36.00,	30.00,	25.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/59293a3666066.png',	1,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	1,	0,	1495873987,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(90,	49,	0,	'SHOP_SN0000090',	'【三只松鼠】纸皮核桃210gx2',	0,	0,	0,	238,	0.000,	0.60,	0.50,	0.10,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/59293ae6f2290.jpg',	1,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	1,	0,	1502191479,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(91,	49,	0,	'SHOP_SN0000091',	'巴灵猴 -忆童年A29大礼包1668g 17袋坚果礼盒节日礼品干果零食组合',	0,	0,	0,	96,	0.000,	118.80,	99.00,	88.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/59293b7a655a6.png',	1,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	0,	1495874387,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(92,	116,	0,	'SHOP_SN0000092',	'Etam 艾格色驳领西装外套本白色36S',	0,	0,	0,	90,	0.000,	238.80,	199.00,	150.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/592941390f898.png',	1,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.4000,	10,	0,	1495875711,	10,	1,	1,	2,	2,	1,	0,	1,	0,	0,	0,	0),
(93,	116,	0,	'SHOP_SN0000093',	'E&amp;joy by Etam 艾格新品纯色休闲百搭T恤本白色40L',	0,	0,	0,	100,	0.000,	94.80,	79.00,	65.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/592941df0db98.png',	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	0,	0,	0,	0.0000,	0,	0,	1495876005,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(94,	116,	0,	'SHOP_SN0000094',	'HSTYLE韩都衣舍 韩都衣舍2017韩版女装夏装新款时尚修身显瘦圆领条纹T恤OGY7711娋白色L',	0,	0,	0,	100,	0.000,	122.40,	102.00,	80.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/592942e61685c.png',	1,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	0,	1495876218,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(95,	116,	0,	'SHOP_SN0000095',	'HSTYLE韩都衣舍 韩都衣舍2017韩版女装春装新款立领直筒显瘦印花长袖衬衫LU6755荃白色S',	0,	0,	0,	99,	0.000,	105.60,	88.00,	70.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/592944c4089dc.png',	1,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.2000,	1,	0,	1495876453,	10,	0,	1,	1,	1,	1,	0,	0,	0,	0,	0,	0),
(96,	116,	0,	'SHOP_SN0000096',	'HSTYLE韩都衣舍 韩都衣舍2017韩版女装春装新款拼接蕾丝镂空长袖雪纺衫NF6349潤白色S',	0,	0,	0,	93,	0.000,	70.80,	59.00,	40.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/59294773627e4.png',	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	0,	0,	0,	0.0000,	4,	0,	1495877399,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(97,	116,	0,	'SHOP_SN0000097',	'韩都衣舍2017韩版女装春装新款纯色宽松显瘦无袖连衣裙粉色S',	0,	0,	0,	94,	0.000,	58.80,	49.00,	30.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/59294830d590d.png',	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	0,	0,	0,	0.0000,	0,	0,	1498805287,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(98,	116,	0,	'SHOP_SN0000098',	'韩都衣舍2017韩版女装春装新款假两件A字长袖连衣裙NH6401煜灰色S',	0,	0,	0,	19,	0.000,	189.60,	158.00,	130.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/592948fe7a60a.png',	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	0,	0,	0,	0.0000,	76,	0,	1500284637,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(99,	116,	0,	'SHOP_SN0000099',	'HSTYLE韩都衣舍 韩都衣舍2017韩版女装春新款宽松圆领镂空荷叶袖打底T恤AA7152玎粉色AM',	0,	0,	0,	93,	0.000,	81.60,	68.00,	50.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/59294975f0cb2.png',	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	0,	0,	0,	0.2000,	2,	0,	1503627868,	10,	1,	1,	1,	1,	1,	0,	0,	0,	0,	0,	0),
(115,	166,	67,	'SHOP_SN0000115',	'BESTJOY可爱创意便携萌系列真空保温杯',	44,	38,	0,	100,	0.000,	198.00,	79.00,	60.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982bb6dca874.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501739907,	1501745750,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(116,	166,	67,	'SHOP_SN0000116',	'BESTJOY商务便携带滤网双层玻璃杯隔热防烫',	44,	38,	0,	100,	0.000,	98.00,	35.00,	30.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982bc8d12e98.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501740191,	1501745733,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(117,	166,	67,	'SHOP_SN0000117',	'BESTJOY时尚萌宠猫杯系列便携可爱学生保温杯',	44,	38,	0,	100,	0.000,	798.00,	79.00,	60.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982bdc73d5a3.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501740499,	1501745712,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(118,	166,	67,	'SHOP_SN0000118',	'BESTJOY双层玻璃杯耐热便携水杯创意带盖过滤',	44,	38,	0,	100,	0.000,	128.00,	49.00,	40.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982bed46a240.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501740767,	1501745690,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(119,	166,	67,	'SHOP_SN0000119',	'BESTJOY时尚萌宠系列小白可爱真空保温杯',	44,	38,	0,	99,	0.000,	198.00,	969.00,	60.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982c11076f5e.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501741348,	1501745661,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(120,	27,	69,	'SHOP_SN0000120',	'奥尼Olitalia意大利原装进口初榨橄榄油1L',	43,	38,	0,	100,	0.000,	168.00,	128.00,	110.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982c6730a025.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501742716,	1501745047,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(121,	27,	69,	'SHOP_SN0000121',	'奥尼Olitalia意大利原装进口葡萄籽油1L',	43,	38,	0,	100,	0.000,	138.00,	98.00,	90.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982c955b6211.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501743458,	1501745023,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(122,	27,	69,	'SHOP_SN0000122',	'奥尼Olitalia意大利原装进口葵花籽油500ml',	43,	38,	0,	100,	0.000,	68.00,	39.00,	30.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982c9d0c3c3a.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501743581,	1501744943,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(123,	27,	69,	'SHOP_SN0000123',	'奥尼Olitalia意大利原装进口米糠油500ml',	43,	38,	0,	100,	0.000,	88.00,	56.00,	50.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982ca49c1e44.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501743700,	1501744911,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(124,	27,	69,	'SHOP_SN0000124',	'奥尼Olitalia意大利原装进口米糠油1L',	43,	38,	0,	100,	0.000,	108.00,	88.00,	80.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982cab290943.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501743809,	1501744862,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(125,	155,	70,	'SHOP_SN0000125',	'大容量随心装,高硼硅油壶580ml',	45,	38,	0,	91,	0.000,	189.00,	89.00,	80.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982d853cadd6.jpg',	0,	0,	1,	0,	0,	0,	0,	1,	111,	1501746958,	1533282960,	80.00,	1,	0,	0,	0.0000,	4,	1501747298,	1501749523,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(126,	155,	70,	'SHOP_SN0000126',	'精致美观，家用电子体重秤 多色可选',	45,	38,	0,	94,	0.000,	179.00,	59.00,	50.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982d9d375811.jpg',	0,	0,	1,	0,	0,	0,	0,	1,	111,	1501746958,	1533282960,	50.00,	1,	0,	0,	1.0000,	2,	1501747668,	1501749474,	10,	1,	1,	1,	5,	0,	0,	0,	0,	1,	0,	0),
(127,	155,	70,	'SHOP_SN0000127',	'匠心制作，简洁实用，日式天妇罗家用油炸锅',	45,	38,	0,	99,	0.000,	169.00,	79.00,	70.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982dde3cf913.jpg',	0,	0,	1,	0,	0,	0,	0,	1,	111,	1501746958,	1533282960,	70.00,	1,	0,	0,	0.0000,	0,	1501748725,	1501749452,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(128,	155,	70,	'SHOP_SN0000128',	'304不锈钢，欧式保温壶2L，多色可选',	45,	38,	0,	97,	0.000,	239.00,	99.00,	90.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982dfeeea2e9.jpg',	0,	0,	1,	0,	0,	0,	0,	1,	111,	1501746958,	1533282960,	90.00,	1,	0,	0,	0.0000,	0,	1501749244,	1501749429,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(129,	155,	70,	'SHOP_SN0000129',	'雅颂梅花，一壶四杯清酒壶套装 多色可选',	45,	38,	0,	100,	0.000,	129.00,	59.00,	50.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982e03c6550a.jpg',	0,	0,	1,	0,	0,	0,	0,	1,	111,	1501746958,	1533282960,	50.00,	1,	0,	0,	0.0000,	0,	1501749325,	1501749402,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(130,	158,	71,	'SHOP_SN0000130',	'纽西小精灵多莓亮采紧肤保湿霜',	46,	38,	0,	100,	0.000,	228.00,	158.00,	140.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/5983df0f25939.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501814572,	1501826127,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	112,	0),
(131,	158,	71,	'SHOP_SN0000131',	'纽西小精灵奇异果舒缓焕肤水',	46,	38,	0,	88,	0.000,	158.00,	109.00,	90.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/5983e0180ad78.jpg',	0,	0,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	10,	1501814820,	1501826107,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	113,	0),
(132,	158,	71,	'SHOP_SN0000132',	'纽西小精灵紫草手部滋润修护霜',	46,	38,	0,	97,	0.000,	98.00,	68.00,	60.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59840d62536f7.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501826743,	1501826940,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	114,	0),
(133,	158,	71,	'SHOP_SN0000133',	'纽西小精灵儿童牙膏2支装（蜂蜜+多莓）',	0,	38,	0,	97,	0.000,	40.00,	32.00,	30.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/5984137e158ed.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.2000,	1,	1501828054,	1501828071,	10,	1,	1,	1,	1,	1,	0,	0,	0,	0,	115,	0),
(134,	166,	67,	'SHOP_SN0000134',	'BESTJOY时尚运动户外水壶Tritan安全防摔',	44,	38,	0,	100,	0.000,	138.00,	58.00,	30.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59841fa99422a.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501831093,	1502083422,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(135,	166,	67,	'SHOP_SN0000135',	'BESTJOY时尚运动户外水壶Tritan安全防摔',	44,	38,	0,	100,	0.000,	138.00,	58.00,	30.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/5984201b2f4a2.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501831205,	1502083453,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(136,	166,	67,	'SHOP_SN0000136',	'BESTJOY智能温控55度高档商务水杯',	44,	38,	0,	100,	0.000,	998.00,	398.00,	350.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/598420aec4988.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501831352,	1502083683,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(137,	166,	67,	'SHOP_SN0000137',	'BESTJOY一件开启安全车载保温杯',	44,	38,	0,	100,	0.000,	168.00,	59.00,	30.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/598421835dc3c.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501831556,	1502083652,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(138,	166,	67,	'SHOP_SN0000138',	'BESTJOY家用保温壶1.5L大容量安全健康',	44,	38,	0,	100,	0.000,	318.00,	148.00,	100.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/598422642eaf3.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501831788,	1502083624,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(139,	166,	67,	'SHOP_SN0000139',	'BESTJOY方便实用玻璃杯壶套装',	44,	38,	0,	100,	0.000,	458.00,	168.00,	120.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/5984237681a7f.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501832063,	1502083598,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(140,	166,	67,	'SHOP_SN0000140',	'BESTJOY时尚运动户外水壶健康安全防摔',	44,	38,	0,	100,	0.000,	88.00,	58.00,	30.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/598423fb0bf47.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501832197,	1502083535,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(141,	166,	67,	'SHOP_SN0000141',	'BESTJOY男女士轻便携创意不锈钢保温杯',	44,	38,	0,	100,	0.000,	178.00,	128.00,	100.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/5984248537463.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501832337,	1502083487,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(142,	166,	67,	'SHOP_SN0000142',	'BESTJOY男女士商务时尚便携保温茶杯',	44,	38,	0,	100,	0.000,	118.00,	88.00,	70.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/598424d80e30d.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501832419,	1502077893,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(143,	166,	67,	'SHOP_SN0000143',	'BESTJOY超级保温焖煮杯煮绿豆红豆粥方便实用',	44,	38,	0,	100,	0.000,	368.00,	288.00,	250.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59842596714b1.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501832608,	1502077872,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(144,	166,	67,	'SHOP_SN0000144',	'BESTJOY便携双层塑玻小蛮腰带盖过滤塑玻杯',	44,	38,	0,	100,	0.000,	138.00,	98.00,	70.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/5984270b34663.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501832980,	1502077852,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(145,	166,	67,	'SHOP_SN0000145',	'BESTJOY轻便携不锈钢保温杯高档',	44,	38,	0,	100,	0.000,	356.00,	298.00,	250.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/598427cd0c2c1.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501833173,	1502077823,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(146,	166,	67,	'SHOP_SN0000146',	'BESTJOY女士便携提绳不锈钢保温杯',	44,	38,	0,	100,	0.000,	198.00,	168.00,	150.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59842843ba7c2.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501833292,	1502076242,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(147,	166,	67,	'SHOP_SN0000147',	'BESTJOY弹跳盖轻钢高档健康安全保温杯',	44,	38,	0,	100,	0.000,	298.00,	268.00,	220.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/598428bdbf8a2.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501833416,	1502076202,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(148,	166,	67,	'SHOP_SN0000148',	'BESTJOY男女式直身手绘繁花不锈钢真空保温杯',	44,	38,	0,	100,	0.000,	298.00,	268.00,	200.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59842943e6442.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501833548,	1502076224,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(149,	27,	69,	'SHOP_SN0000149',	'奥尼Olitalia意大利原装进口初榨橄榄油500ml',	43,	38,	0,	100,	0.000,	98.00,	88.00,	70.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59842ade7a209.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501833960,	1502076130,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(150,	27,	69,	'SHOP_SN0000150',	'奥尼Olitalia意大利原装进口葵花籽油500ml',	43,	38,	0,	100,	0.000,	68.00,	48.00,	30.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59842bb019e1b.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501834173,	1502076147,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(151,	27,	69,	'SHOP_SN0000151',	'奥尼Olitalia意大利原装进口初榨橄榄油1L',	43,	38,	0,	100,	0.000,	168.00,	138.00,	100.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59842be9a82c7.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501834228,	1502076165,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(152,	27,	69,	'SHOP_SN0000152',	'奥尼Olitalia意大利原装进口米糠油1L',	43,	38,	0,	100,	0.000,	108.00,	98.00,	60.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59842c23544c3.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501834289,	1502076098,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(153,	27,	69,	'SHOP_SN0000153',	'奥尼Olitalia意大利原装进口葡萄籽油500ml',	43,	38,	0,	100,	0.000,	88.00,	58.00,	30.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59842ca2af914.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501834419,	1502076073,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(154,	27,	69,	'SHOP_SN0000154',	'奥尼Olitalia意大利原装进口葵花籽油1L',	43,	38,	0,	100,	0.000,	98.00,	78.00,	60.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59842ce1adb2b.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501834481,	1502075879,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(155,	27,	69,	'SHOP_SN0000155',	'奥尼Olitalia意大利原装进口米糠油1L',	43,	38,	0,	100,	0.000,	108.00,	88.00,	60.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59842d1b979ae.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501834538,	1502076050,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(156,	27,	69,	'SHOP_SN0000156',	'奥尼Olitalia意大利原装进口葵花籽油1L',	43,	38,	0,	100,	0.000,	98.00,	88.00,	60.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59842d714e4fc.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501834618,	1502075854,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(157,	27,	69,	'SHOP_SN0000157',	'奥尼Olitalia意大利原装进口葡萄籽油1L',	43,	38,	0,	100,	0.000,	138.00,	118.00,	90.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59842da913ad5.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501834680,	1502075837,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(158,	27,	69,	'SHOP_SN0000158',	'奥尼Olitalia意大利原装进口葵花籽油500ml',	43,	38,	0,	100,	0.000,	68.00,	58.00,	30.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59842dee68051.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501834744,	1502075812,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(159,	27,	69,	'SHOP_SN0000159',	'奥尼Olitalia意大利原装进口葵花籽油1L',	43,	38,	0,	100,	0.000,	98.00,	88.00,	60.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59842f042a585.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501835022,	1502075790,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(160,	27,	69,	'SHOP_SN0000160',	'奥尼Olitalia意大利原装进口葡萄籽油1L',	43,	38,	0,	100,	0.000,	138.00,	118.00,	90.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59842f48c8d19.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501835098,	1502075770,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(161,	27,	69,	'SHOP_SN0000161',	'奥尼Olitalia意大利原装进口初榨橄榄油1L',	43,	38,	0,	100,	0.000,	168.00,	138.00,	120.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59842f8eda102.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501835162,	1502075752,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(162,	27,	69,	'SHOP_SN0000162',	'奥尼Olitalia意大利原装进口葡萄籽油500ml',	43,	38,	0,	100,	0.000,	88.00,	78.00,	50.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59842feb5d73b.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501835359,	1502075479,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(163,	27,	69,	'SHOP_SN0000163',	'奥尼Olitalia意大利原装进口葵花籽油500ml',	43,	38,	0,	100,	0.000,	68.00,	58.00,	30.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59843117cb8a7.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501835555,	1502075428,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(164,	116,	73,	'SHOP_SN0000164',	'翻领双排扣中长款风衣配腰带',	47,	38,	0,	1,	0.000,	1599.00,	580.00,	500.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/598432f1939a4.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501836030,	1502074086,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(165,	116,	73,	'SHOP_SN0000165',	'翻领双排扣系带中长款风衣',	47,	38,	0,	1,	0.000,	499.00,	480.00,	400.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/5984339f9d541.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501836202,	1502074046,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(166,	116,	73,	'SHOP_SN0000166',	'翻领双排扣中长款风衣配腰带',	47,	38,	0,	1,	0.000,	1599.00,	580.00,	500.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/598434012f611.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501836299,	1502074017,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(167,	116,	73,	'SHOP_SN0000167',	'立领条纹下摆斜裁连衣裙',	47,	38,	0,	100,	0.000,	799.00,	399.00,	300.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59843461b8014.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501836395,	1502074950,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(168,	116,	73,	'SHOP_SN0000168',	'V领薄款针织修身长袖连衣裙',	47,	38,	0,	100,	0.000,	599.00,	480.00,	300.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/598434bdf2d4c.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501836622,	1502074924,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(169,	116,	73,	'SHOP_SN0000169',	'个性拼接假两件棒球服外套',	47,	38,	0,	97,	0.000,	999.00,	588.00,	200.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/598435a567a2d.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	1,	1501836717,	1502074898,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(170,	116,	73,	'SHOP_SN0000170',	'轻薄舒适印花雪纺衫',	47,	38,	0,	100,	0.000,	399.00,	288.00,	200.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/598436012e7e1.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501836811,	1502074360,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(171,	116,	73,	'SHOP_SN0000171',	'翻领抽绳长款风衣',	47,	38,	0,	100,	0.000,	999.00,	688.00,	500.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/5984366175b8f.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501836909,	1502074344,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(172,	116,	73,	'SHOP_SN0000172',	'黑色平驳领七分袖外套',	47,	38,	0,	100,	0.000,	599.00,	466.00,	400.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/598436c8df5b2.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501837010,	1502074327,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(173,	116,	73,	'SHOP_SN0000173',	'大胆撞色连体裤',	47,	38,	0,	100,	0.000,	799.00,	588.00,	400.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/598437342bf74.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501837116,	1502074308,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(174,	116,	73,	'SHOP_SN0000174',	'气质条纹显瘦连衣裙',	47,	38,	0,	95,	0.000,	999.00,	688.00,	400.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/5984386a03507.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501837427,	1502074289,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(175,	116,	73,	'SHOP_SN0000175',	'经典基础款短袖T恤',	47,	38,	0,	100,	0.000,	299.00,	188.00,	100.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/598438cfd0de5.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501837529,	1502074274,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(176,	116,	73,	'SHOP_SN0000176',	'压褶系带上衣+短款套装',	47,	38,	0,	100,	0.000,	799.00,	688.00,	400.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59843934e9bb9.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501837630,	1502074256,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(177,	116,	73,	'SHOP_SN0000177',	'粉色圆领浪漫荷叶边袖口短袖T恤',	47,	38,	0,	100,	0.000,	299.00,	188.00,	100.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/5984398bd921e.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501837717,	1502074240,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(178,	116,	73,	'SHOP_SN0000178',	'前开叉半裙',	47,	38,	0,	100,	0.000,	499.00,	366.00,	200.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59843a11ae63a.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501837850,	1502074224,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	156,	0),
(179,	116,	73,	'SHOP_SN0000179',	'本白色立领撞色衬衫',	47,	38,	0,	1,	0.000,	799.00,	588.00,	400.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59843fa335d37.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501839275,	1502074209,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(180,	116,	73,	'SHOP_SN0000180',	'翻领条纹蕾丝拼接连衣裙',	47,	38,	0,	100,	0.000,	599.00,	388.00,	200.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59843ff8ccd30.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501839362,	1502074185,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(181,	116,	73,	'SHOP_SN0000181',	'本白色绣花短袖T恤',	47,	38,	0,	83,	0.000,	299.00,	188.00,	100.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59844273ee669.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501839450,	1502074166,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(182,	116,	73,	'SHOP_SN0000182',	'本白色系带喇叭袖口衬衫',	47,	38,	0,	96,	0.000,	399.00,	288.00,	200.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/598440f999b34.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501839616,	1502074150,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	154),
(183,	116,	73,	'SHOP_SN0000183',	'个性撞色松紧腰长半裙',	47,	38,	0,	100,	0.000,	588.00,	398.00,	300.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/5984416026090.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501839722,	1502074119,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(184,	116,	73,	'SHOP_SN0000184',	'时尚简约衬衫撞色领中长款连衣裙',	0,	38,	0,	100,	0.000,	988.00,	688.00,	500.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/598443539d065.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501840238,	1501840242,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(185,	116,	73,	'SHOP_SN0000185',	'V领超舒适Ｔ恤＋背带碎花收腰连体裤套装',	0,	38,	0,	100,	0.000,	1298.00,	688.00,	500.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/598443cc48dba.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1501840349,	1501840352,	10,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(186,	5,	77,	'SHOP_SN0000186',	'NINE CAULDRONS Apple Lightning 编织充电数据线 红黑色',	0,	40,	0,	5,	20.000,	22.00,	19.00,	50.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/598806d1cb882.jpg',	1,	0,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1502072555,	1502086968,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(187,	5,	78,	'SHOP_SN0000187',	'Apple 苹果 iPhone 7 Plus (A1661) 128G 亮黑色 移动联通电信4G手机',	0,	40,	0,	10,	0.520,	7500.00,	6588.00,	7000.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/59880a4f80d34.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	1,	1502087792,	1502157572,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(188,	30,	79,	'SHOP_SN0000188',	'Midea 美的 20L 电脑版微波炉 M1-L202B 黑色',	0,	40,	0,	0,	0.000,	650.00,	359.00,	500.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/59880bcb5a0d8.jpg',	0,	0,	1,	0,	0,	0,	0,	1,	126,	1501746958,	1533282960,	358.00,	1,	0,	0,	1.0000,	1,	1502088225,	1502088328,	10,	1,	1,	1,	5,	0,	0,	0,	0,	1,	0,	0),
(189,	5,	80,	'SHOP_SN0000189',	'SAMSUNG 三星 55英寸 超高清 LED 液晶4K智能网络平面 HDR 电视机 UA55KUF30ZJXXZ 黑色',	0,	40,	0,	1,	0.000,	55000.00,	3498.00,	5000.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/59880d50daa66.jpg',	0,	0,	1,	1,	1,	1,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1502088578,	1502155425,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(190,	5,	85,	'SHOP_SN0000190',	'Philips 飞利浦 电动剃须刀 PQ206',	0,	40,	0,	0,	0.000,	80.00,	79.00,	85.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/59880f60293c1.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1502089084,	1502154449,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(193,	9,	90,	'SHOP_SN0000193',	'百变牛轧糖系列 绿茶味220g',	48,	44,	0,	100,	2.200,	49.00,	35.00,	30.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/59881c944b833.jpg',	1,	0,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1502092474,	1503381311,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	143,	0),
(194,	9,	91,	'SHOP_SN0000194',	'【2件起售】牛轧糖青豆味200g',	48,	44,	0,	100,	200.000,	39.00,	23.00,	20.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/598821bd88c15.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1502093782,	1503304655,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(195,	9,	92,	'SHOP_SN0000195',	'瓜果飘香系列芒果酥240g',	48,	44,	0,	99,	0.240,	49.00,	35.00,	30.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/598828e7000df.jpg',	0,	0,	1,	1,	1,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1502095607,	1502264131,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(196,	9,	96,	'SHOP_SN0000196',	'太祖千层松塔192g',	48,	44,	0,	100,	0.300,	49.00,	35.00,	30.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/59882a4749123.jpg',	0,	0,	1,	1,	1,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	4,	1502095970,	1503373674,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(197,	9,	90,	'SHOP_SN0000197',	'【2件起售】牛轧糖椰香味200kg',	48,	44,	0,	100,	0.200,	39.00,	19.00,	15.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/59882b8224854.jpg',	0,	0,	1,	0,	1,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	1.0000,	31,	1502096277,	1503382007,	10,	1,	1,	2,	5,	0,	0,	0,	0,	2,	0,	0),
(204,	9,	92,	'SHOP_SN0000204',	'太祖冰心绿豆糕原味208g(2件起售）',	48,	44,	12,	100,	0.208,	49.00,	35.00,	30.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170809/598aac1337fb1.jpg',	1,	0,	1,	0,	1,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	2,	1502260267,	1502264194,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(216,	116,	116,	'SHOP_SN0000216',	'春装欧美',	0,	43,	0,	1,	0.100,	75.00,	68.00,	64.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170817/59950332036ba.png',	1,	0,	1,	1,	1,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1502937921,	1502949884,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(217,	116,	116,	'SHOP_SN0000217',	'新款韩版修身铅笔裤',	0,	43,	0,	100,	0.100,	100.00,	65.00,	59.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170817/5995052c044ee.png',	1,	0,	1,	0,	1,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1502938417,	1502938448,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(218,	116,	113,	'SHOP_SN0000218',	'欧美新款半裙',	0,	43,	0,	100,	0.100,	70.00,	65.00,	58.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170817/599505f9c3d5f.png',	1,	0,	1,	0,	1,	1,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1502938620,	1503391158,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(219,	116,	113,	'SHOP_SN0000219',	'韩版小清新碎花套装',	0,	43,	0,	100,	0.200,	130.00,	120.00,	100.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170817/59953bf7e6a4e.png',	1,	0,	1,	0,	1,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1502938785,	1502952441,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(220,	116,	114,	'SHOP_SN0000220',	'简约新款针织上衣',	0,	43,	0,	100,	0.200,	55.00,	40.00,	36.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170817/5995070cbe6fd.png',	0,	0,	1,	1,	1,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1502938894,	1502938950,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(221,	116,	114,	'SHOP_SN0000221',	'夏季新款T恤衫',	0,	43,	0,	100,	0.100,	75.00,	70.00,	63.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170817/5995079a2ad28.png',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1502939036,	1502939056,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(222,	153,	115,	'SHOP_SN0000222',	'家居印花纯棉被套',	0,	43,	0,	100,	0.100,	299.00,	280.00,	268.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170817/5995082098141.png',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1502939170,	1502939193,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(223,	153,	115,	'SHOP_SN0000223',	'粉色家居空气棉被套',	0,	43,	0,	100,	0.200,	189.00,	170.00,	159.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170817/5995089560917.png',	1,	0,	1,	0,	1,	1,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1502939287,	1502939308,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(224,	115,	117,	'SHOP_SN0000224',	'韩版休闲黑色高跟鞋',	0,	43,	0,	100,	0.100,	75.00,	65.00,	56.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170817/5995091d9fe46.png',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1502939423,	1502939440,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	150,	0),
(225,	115,	117,	'SHOP_SN0000225',	'韩版女神范绑带休闲鞋',	0,	43,	0,	100,	0.100,	85.00,	75.00,	69.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170817/599509915b661.png',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1502939539,	1502939557,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(226,	116,	118,	'SHOP_SN0000226',	'2017早秋新款明星迪丽热巴同款蓝色条纹v领宽松收腰褶皱衬衫女潮',	0,	43,	0,	100,	0.100,	130.00,	115.00,	108.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170817/59950ae751b27.jpg',	1,	0,	1,	1,	1,	1,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1502939882,	1502939905,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(227,	115,	119,	'SHOP_SN0000227',	'韩版OL风休闲链包',	0,	43,	0,	100,	0.100,	160.00,	120.00,	100.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170817/59950bdd08295.png',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1502940148,	1502940151,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(228,	115,	119,	'SHOP_SN0000228',	'真皮黑色扣带链包',	0,	43,	0,	100,	0.200,	320.00,	300.00,	288.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170817/59950ce041038.png',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1502940386,	1502940659,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(229,	116,	116,	'SHOP_SN0000229',	'新款韩版针织上衣',	0,	43,	0,	100,	0.200,	55.00,	45.00,	36.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170817/59950e84953bc.png',	0,	0,	1,	1,	1,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1502940806,	1502940945,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(230,	116,	121,	'SHOP_SN0000230',	'【预售】2017新款秋季双排扣麂皮绒显瘦风衣女韩版休闲收腰外套',	0,	43,	0,	100,	0.100,	265.00,	10.00,	239.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170817/59952ef80e2b1.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1502949116,	1502957215,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(232,	116,	114,	'SHOP_SN0000232',	'条纹衬衫女夏季新款短袖宽松蓝色竖条纹显瘦防嗮空调衫',	0,	43,	0,	100,	0.100,	135.00,	125.00,	119.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170818/599649fb1fcf1.png',	1,	0,	1,	1,	1,	1,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1503021589,	1503021630,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(233,	116,	114,	'SHOP_SN0000233',	'卫衣女韩版宽松学生连帽bf长袖短款字母印花上衣潮',	0,	43,	0,	1,	0.100,	145.00,	125.00,	109.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170818/59964b77d9116.png',	1,	0,	1,	1,	1,	1,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1503021993,	1503022065,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(234,	116,	113,	'SHOP_SN0000234',	'半身裙女夏季新款不规则印花长款开叉显瘦学生雪纺长裙',	0,	43,	0,	100,	0.100,	160.00,	145.00,	129.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170818/59964f1c693f1.png',	1,	0,	1,	1,	1,	1,	0,	1,	152,	1501746958,	1533282960,	120.00,	1,	0,	0,	0.0000,	0,	1503022904,	1503022931,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(235,	116,	113,	'SHOP_SN0000235',	'针织连衣裙女夏新款冰丝拼色短袖中长款韩版显瘦T恤裙',	0,	43,	0,	1,	0.100,	150.00,	135.00,	129.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170818/5996518c332e0.png',	1,	0,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1503023578,	1503023610,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(236,	116,	113,	'SHOP_SN0000236',	'2017新款收腰V领荷叶边裙子女露肩碎花雪纺短袖连衣裙',	0,	43,	0,	100,	0.100,	200.00,	180.00,	168.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170818/599652dad3207.png',	0,	0,	1,	1,	1,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1503023877,	1503023923,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(237,	122,	114,	'SHOP_SN0000237',	'印花短袖',	0,	43,	0,	100,	0.500,	50.00,	49.00,	30.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/59979c7655106.jpg',	1,	0,	1,	0,	1,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1503108276,	1503108303,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(238,	49,	123,	'zhenlaoban-005',	'榛子',	0,	46,	0,	100,	200.000,	40.00,	30.00,	10.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/5997d08a9a454.jpg',	1,	0,	1,	1,	1,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1503121588,	1503282881,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(239,	47,	125,	'zhenlaoban-004',	'牛奶饼干',	0,	46,	0,	1,	500.000,	15.00,	10.00,	5.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/5997d4bd841d6.jpg',	1,	0,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1503122644,	1503282809,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(240,	49,	126,	'zhenlaoban-003',	'多味瓜子',	0,	46,	0,	100,	500.000,	80.00,	30.00,	10.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/5997dca972523.jpg',	1,	0,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1503124670,	1503282777,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(241,	49,	128,	'zhenlaoban-002',	'话梅味西瓜子',	0,	46,	13,	500,	500.000,	40.00,	20.00,	10.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/5997e51f9bb8a.jpg',	1,	0,	1,	0,	1,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1503126836,	1503282761,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(242,	1,	127,	'zhenlaoban-001',	'青柠檬',	0,	46,	13,	10000,	100.000,	16.00,	12.00,	1.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/5997ec51a615c.jpg',	1,	0,	1,	1,	1,	1,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1503128681,	1503449623,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(244,	165,	130,	'0001',	'西瓜刀',	0,	48,	0,	20,	10000.000,	1.00,	1.00,	0.01,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/5997f04f0dfd3.jpg',	1,	0,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1503129684,	1503713193,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(245,	165,	130,	'0002',	'剁肉刀',	0,	48,	0,	1,	1.000,	1.00,	1.00,	1.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/5997f9178bd90.jpg',	1,	0,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1503131932,	1503450061,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(246,	165,	130,	'0003',	'小刀',	0,	48,	0,	1,	2.000,	5.00,	4.00,	3.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170820/5998e02f0a228.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1503191098,	0,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(247,	154,	130,	'0004',	'小刀',	0,	48,	0,	1,	1.000,	4.00,	0.10,	2.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170820/5998e1212e367.jpg',	0,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1503191338,	1503450038,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(249,	116,	116,	'SHOP_SN0000249',	'赠品换购',	0,	43,	0,	100,	0.100,	5.00,	1.00,	0.10,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170821/599a44fe8d1bd.jpg',	1,	0,	1,	0,	1,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1503282443,	1503391554,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(250,	162,	130,	'0004',	'支架',	0,	48,	14,	1,	1.000,	1.00,	0.10,	1.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170821/599a46e3b8665.jpg',	1,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1503282992,	1503391055,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(251,	116,	113,	'SHOP_SN0000251',	'小裙子',	0,	43,	0,	1,	0.100,	0.50,	0.10,	0.10,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170822/599bf02564832.jpg',	1,	0,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1503391808,	1503391885,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(252,	168,	0,	'SHOP_SN0000252',	'照相机',	0,	0,	0,	15,	1.000,	120.00,	100.00,	200.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170826/59a10ab304856.jpg',	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	0,	0,	0,	0.0000,	1,	1503726164,	1505100208,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(253,	116,	0,	'SHOP_SN0000253',	'2017秋装新款女装上衣白衬衫V领修身OL长袖雪纺衫衬衣百搭打底衫',	0,	0,	0,	12,	2.000,	60.00,	50.00,	23.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170826/59a11b5356c47.png',	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0,	0.00,	0,	0,	0,	0.0000,	0,	1503730450,	1503911875,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(254,	99,	132,	'SHOP_SN0000254',	'三星（SAMSUNG）Galaxy S8（SM-G9500）4GB+64GB版 烟晶灰 移动联通电信4G手机 双卡双待',	0,	44,	0,	100,	1.000,	1500.00,	1100.00,	1000.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170829/59a4c6853ac3a.png',	0,	0,	1,	0,	1,	0,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1503970587,	1503971014,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(255,	99,	132,	'SHOP_SN0000255',	'Apple iPhone 6s Plus (A1699) 32G 玫瑰金色 移动联通电信4G手机',	0,	44,	0,	254,	2.000,	4200.00,	3999.00,	3000.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170829/59a4cccfdd37f.png',	0,	0,	1,	0,	0,	1,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1503972637,	1503978125,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(256,	126,	134,	'SHOP_SN0000256',	'席琳贝儿 卫衣女连帽的套头春装宽松棒球服',	0,	44,	0,	254,	2.000,	160.00,	155.00,	100.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170829/59a4d4de26733.png',	0,	0,	1,	0,	1,	0,	0,	1,	153,	1501746958,	1533282960,	150.00,	1,	0,	0,	0.8000,	1,	1503974804,	1503978143,	10,	1,	1,	1,	4,	0,	0,	0,	1,	0,	0,	0),
(257,	1,	95,	'SHOP_SN0000257',	'大别山黑毛土猪肉1000g袋 农家散养 现杀 前腿肉1000g',	48,	44,	12,	1000,	0.500,	80.00,	70.00,	60.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170829/59a4ddc823edc.jpg',	1,	0,	1,	1,	0,	0,	0,	1,	153,	1501746958,	1533282960,	60.00,	1,	0,	0,	0.0000,	0,	1503977046,	1504150089,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(259,	10,	95,	'SHOP_SN0000259',	'紫薯 约1KG',	48,	44,	12,	100,	1.000,	20.00,	15.00,	10.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170831/59a77c5ae9668.jpg',	1,	0,	1,	1,	0,	1,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1504148995,	1504149034,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(260,	147,	155,	'SHOP_SN0000260',	'汽车头枕护颈枕 车载真皮枕头 车用座椅腰靠枕记 奥迪A4LA3A6L5A7Q3Q58 黑色头枕加腰靠一对价 奥迪A6L A4L Q5 Q3 A3 Q7 A8',	56,	49,	0,	99,	1000.000,	250.00,	200.00,	180.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170906/59afa9d8b345f.jpg',	1,	0,	1,	1,	1,	1,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1504684506,	1504684538,	10,	1,	1,	0,	0,	0,	0,	0,	0,	0,	163,	0),
(261,	147,	147,	'SHOP_SN0000261',	'香佰汇 汽车挂件 车载挂件车内饰品 出入平安汽车挂饰吊坠挂件摆件 车饰装饰 双面吸金貔貅活结款',	0,	49,	0,	100,	0.250,	70.00,	60.00,	50.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170906/59afb57ea90f0.jpg',	1,	0,	1,	1,	1,	1,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1504687521,	1504687542,	2,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(262,	147,	153,	'SHOP_SN0000262',	'山水（SANSUI）E19无线蓝牙音箱手机免提通话器平板外放车载电脑小音响低音炮插卡收音机 蓝牙版蓝色',	0,	49,	0,	100,	2.000,	100.00,	90.00,	80.00,	0,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170906/59afb6bf1d3c9.jpg',	1,	0,	1,	1,	1,	1,	0,	0,	0,	0,	0,	0.00,	1,	0,	0,	0.0000,	0,	1504687841,	1504687871,	3,	1,	1,	0,	0,	0,	0,	0,	0,	0,	0,	160);

DROP TABLE IF EXISTS `hanchao_goods_attr`;
CREATE TABLE `hanchao_goods_attr` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `goods_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID',
  `attr_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '属性ID',
  `attr_value` text NOT NULL COMMENT '属性值',
  `attr_price` decimal(10,2) NOT NULL COMMENT '属性递加价格',
  `supplier_price` decimal(10,2) NOT NULL COMMENT '结算递加价格',
  `attr_img` text NOT NULL COMMENT '图片',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=654 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='商品属性中间表';

INSERT INTO `hanchao_goods_attr` (`id`, `goods_id`, `attr_id`, `attr_value`, `attr_price`, `supplier_price`, `attr_img`) VALUES
(1,	2,	1,	'0',	100.00,	100.00,	''),
(2,	2,	1,	'3',	50.00,	50.00,	''),
(3,	2,	1,	'2',	150.00,	150.00,	''),
(4,	2,	1,	'1',	200.00,	200.00,	''),
(5,	2,	2,	'0',	500.00,	500.00,	''),
(6,	2,	2,	'1',	1000.00,	500.00,	''),
(7,	9,	1,	'2',	100.00,	100.00,	''),
(8,	9,	2,	'0',	100.00,	100.00,	''),
(12,	14,	7,	'1',	2.00,	1.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170414/58f0419b3ba4a.jpg'),
(13,	14,	7,	'0',	1.00,	0.50,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170414/58f041d704adc.jpg'),
(14,	14,	9,	'0',	3.00,	2.00,	''),
(15,	14,	9,	'1',	2.00,	1.00,	''),
(16,	14,	10,	'0',	2.00,	1.00,	''),
(17,	16,	51,	'实惠装',	0.00,	0.00,	''),
(25,	29,	3,	'0',	5.00,	5.00,	''),
(26,	29,	1,	'0',	5.00,	1.00,	''),
(27,	29,	2,	'0',	5.00,	1.00,	''),
(28,	29,	2,	'1',	3.00,	2.00,	''),
(29,	29,	53,	'0',	4.00,	0.00,	''),
(30,	29,	53,	'1',	5.00,	2.00,	''),
(37,	6,	49,	'0',	1.00,	0.10,	''),
(44,	10,	6,	'1',	1.00,	1.00,	''),
(45,	10,	7,	'1',	2.00,	2.00,	''),
(46,	36,	54,	'4',	10.00,	210.00,	''),
(63,	46,	11,	'0',	0.00,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/5901628c9f462.jpg'),
(64,	46,	12,	'14',	0.00,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/5901629f765f9.jpg'),
(65,	46,	12,	'15',	0.00,	0.00,	''),
(66,	46,	12,	'16',	0.00,	0.00,	''),
(67,	46,	13,	'0',	0.00,	0.00,	''),
(68,	46,	14,	'0',	0.00,	0.00,	''),
(69,	46,	15,	'3',	0.00,	0.00,	''),
(70,	46,	16,	'2',	0.00,	0.00,	''),
(79,	45,	11,	'2',	0.00,	0.00,	''),
(80,	45,	12,	'17',	0.00,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/59016096b2ea0.jpg'),
(81,	45,	12,	'15',	0.00,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/590163011bc65.jpg'),
(82,	45,	12,	'16',	0.00,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/590162f03f787.jpg'),
(83,	45,	13,	'0',	0.00,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/590160a18bdcf.jpg'),
(84,	45,	14,	'0',	0.00,	0.00,	''),
(85,	45,	15,	'3',	0.00,	0.00,	''),
(86,	45,	16,	'2',	0.00,	0.00,	''),
(91,	43,	11,	'2',	0.00,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/59016346dac94.jpg'),
(92,	43,	12,	'14',	0.00,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/5901634ddb3a7.jpg'),
(93,	43,	12,	'15',	0.00,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/590163573e927.jpg'),
(94,	43,	12,	'16',	0.00,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/5901635e46d19.jpg'),
(95,	43,	12,	'17',	0.00,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/590163667ae01.jpg'),
(96,	43,	13,	'0',	0.00,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/5901636d1819a.jpg'),
(97,	43,	14,	'0',	0.00,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/590163746e254.jpg'),
(98,	43,	15,	'1',	0.00,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/5901638ec9a1d.jpg'),
(99,	43,	16,	'0',	0.00,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/5901639812e97.jpg'),
(110,	48,	3,	'0',	50.00,	30.00,	''),
(111,	48,	1,	'0',	30.00,	20.00,	''),
(112,	48,	1,	'1',	30.00,	15.00,	''),
(113,	48,	2,	'0',	30.00,	20.00,	''),
(114,	48,	2,	'1',	50.00,	30.00,	''),
(115,	48,	53,	'0',	30.00,	20.00,	''),
(116,	48,	53,	'2',	35.00,	20.00,	''),
(138,	49,	3,	'0',	50.00,	20.00,	''),
(139,	49,	1,	'0',	50.00,	20.00,	''),
(140,	49,	1,	'2',	50.00,	20.00,	''),
(141,	49,	2,	'0',	20.00,	5.00,	''),
(142,	49,	2,	'1',	30.00,	10.00,	''),
(143,	49,	51,	'0.025kg',	0.00,	0.00,	''),
(144,	44,	12,	'5',	0.00,	39.00,	''),
(145,	44,	12,	'9',	0.00,	39.00,	''),
(146,	44,	12,	'7',	0.00,	39.00,	''),
(147,	44,	12,	'6',	0.00,	39.00,	''),
(148,	44,	14,	'0',	0.00,	0.00,	''),
(149,	57,	49,	'0',	1.00,	0.00,	''),
(150,	57,	50,	'0',	1.00,	0.00,	''),
(181,	39,	6,	'3',	10.00,	60.00,	''),
(182,	39,	7,	'1',	0.00,	0.00,	''),
(183,	39,	8,	'6',	0.00,	0.00,	''),
(192,	47,	12,	'14',	0.00,	0.00,	''),
(193,	47,	12,	'16',	0.00,	0.00,	''),
(194,	40,	6,	'4',	29.80,	20.00,	''),
(195,	40,	7,	'0',	0.00,	0.00,	''),
(202,	63,	12,	'14',	0.00,	0.00,	''),
(203,	63,	12,	'15',	0.00,	0.00,	''),
(204,	63,	12,	'16',	0.00,	0.00,	''),
(205,	63,	12,	'17',	0.00,	0.00,	''),
(206,	63,	55,	'蓝色，粉色',	0.00,	0.00,	''),
(207,	63,	56,	'M,L',	0.00,	0.00,	''),
(208,	68,	6,	'5',	0.00,	0.00,	''),
(209,	67,	6,	'1',	0.00,	0.00,	''),
(210,	66,	6,	'5',	0.00,	0.00,	''),
(211,	65,	6,	'6',	0.00,	0.00,	''),
(212,	52,	6,	'3',	0.00,	0.00,	''),
(216,	69,	6,	'0',	0.10,	0.00,	''),
(217,	69,	7,	'0',	0.10,	0.00,	''),
(218,	69,	9,	'0',	0.00,	0.00,	''),
(222,	70,	6,	'0',	10.00,	0.00,	''),
(223,	70,	6,	'1',	5.00,	0.00,	''),
(224,	70,	7,	'0',	5.00,	0.00,	''),
(225,	71,	13,	'1',	5.00,	2.00,	''),
(226,	71,	18,	'23',	5.00,	3.00,	''),
(227,	71,	18,	'25',	10.00,	5.00,	''),
(228,	71,	18,	'24',	8.00,	4.00,	''),
(229,	71,	36,	'0',	0.00,	0.00,	''),
(230,	72,	2,	'0',	8.00,	4.00,	''),
(231,	72,	2,	'1',	10.00,	5.00,	''),
(232,	72,	53,	'1',	8.00,	4.00,	''),
(233,	72,	53,	'0',	5.00,	2.00,	''),
(234,	72,	53,	'2',	7.00,	3.00,	''),
(237,	12,	1,	'0',	100.00,	0.00,	''),
(238,	12,	1,	'1',	200.00,	0.00,	''),
(257,	74,	3,	'0',	0.10,	0.00,	''),
(258,	74,	63,	'0',	0.10,	0.00,	''),
(259,	74,	63,	'2',	0.30,	0.00,	''),
(260,	74,	63,	'1',	0.20,	0.00,	''),
(261,	74,	64,	'1',	0.60,	0.00,	''),
(262,	34,	1,	'1',	6.00,	1.00,	''),
(263,	34,	2,	'0',	6.00,	1.00,	''),
(264,	34,	3,	'0',	5.00,	1.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/590163fb61b26.png'),
(265,	34,	53,	'0',	5.00,	1.00,	''),
(266,	8,	6,	'2',	0.00,	0.00,	''),
(267,	8,	7,	'1',	0.00,	0.00,	''),
(273,	186,	69,	'0',	0.00,	0.00,	''),
(274,	186,	69,	'1',	10.00,	10.00,	''),
(275,	186,	68,	'180*180',	0.00,	0.00,	''),
(336,	192,	71,	'0',	5.00,	2.00,	''),
(337,	192,	71,	'1',	8.00,	2.00,	''),
(338,	198,	81,	'0',	8.00,	2.00,	''),
(339,	198,	81,	'2',	7.00,	3.00,	''),
(340,	198,	81,	'1',	8.00,	2.00,	''),
(341,	199,	81,	'0',	5.00,	1.00,	''),
(342,	199,	81,	'2',	6.00,	3.00,	''),
(343,	201,	81,	'0',	6.00,	2.00,	''),
(344,	201,	81,	'2',	8.00,	4.00,	''),
(345,	201,	82,	'0',	6.00,	4.00,	''),
(346,	201,	82,	'1',	10.00,	2.00,	''),
(347,	193,	6,	'3',	0.00,	0.00,	''),
(348,	193,	7,	'0',	0.00,	0.00,	''),
(349,	193,	9,	'1',	0.00,	0.00,	''),
(350,	193,	73,	'5',	0.00,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/59881d1b12def.jpg'),
(351,	193,	74,	'太祖',	0.00,	0.00,	''),
(352,	193,	75,	'百变牛轧糖系列 绿茶味220g',	0.00,	0.00,	''),
(353,	193,	76,	'中国',	0.00,	0.00,	''),
(354,	193,	77,	'麦芽糖、花生、乳粉、海藻糖、奶油、白砂糖等',	0.00,	0.00,	''),
(355,	193,	78,	'袋装',	0.00,	0.00,	''),
(356,	193,	79,	'商品规格：220g 生产日期：2017年5月以后(具体以实物为准） 保质期：270天',	0.00,	0.00,	''),
(357,	193,	80,	'SHOP_SN0000193',	0.00,	0.00,	''),
(358,	194,	6,	'5',	0.00,	0.00,	''),
(359,	194,	7,	'0',	0.00,	0.00,	''),
(360,	194,	9,	'1',	0.00,	0.00,	''),
(361,	194,	73,	'2',	0.00,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/5988223e9bb5d.jpg'),
(362,	194,	74,	'太祖',	0.00,	0.00,	''),
(363,	194,	75,	'牛轧糖青豆味200g',	0.00,	0.00,	''),
(364,	194,	76,	'中国',	0.00,	0.00,	''),
(365,	194,	77,	'麦芽糖、花生、乳粉、海藻糖、奶油、白砂糖等',	0.00,	0.00,	''),
(366,	194,	79,	'商品规格：200g 生产日期：2017年5月以后(具体以实物为准） 保质期：270天',	0.00,	0.00,	''),
(367,	194,	80,	'SHOP_SN0000194',	0.00,	0.00,	''),
(368,	195,	6,	'0',	0.00,	0.00,	''),
(369,	195,	7,	'0',	0.00,	0.00,	''),
(370,	195,	9,	'1',	0.00,	0.00,	''),
(371,	195,	73,	'9',	0.00,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/59882934961f1.jpg'),
(372,	195,	74,	'太祖',	0.00,	0.00,	''),
(373,	195,	75,	'瓜果飘香系列芒果酥240g',	0.00,	0.00,	''),
(374,	195,	76,	'中国',	0.00,	0.00,	''),
(375,	195,	77,	'芒果馅、小麦粉、奶油、白砂糖、鸡蛋、乳粉等',	0.00,	0.00,	''),
(376,	195,	79,	'商品规格：240g 生产日期：2017年6月以后(具体以实物为准） 保质期：180天',	0.00,	0.00,	''),
(377,	196,	6,	'0',	0.00,	0.00,	''),
(378,	196,	7,	'0',	0.00,	0.00,	''),
(379,	196,	9,	'1',	0.00,	0.00,	''),
(380,	196,	73,	'6',	0.00,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/59882aaaf1628.jpg'),
(381,	196,	74,	'太祖',	0.00,	0.00,	''),
(382,	196,	75,	'太祖千层松塔192g',	0.00,	0.00,	''),
(383,	196,	76,	'中国',	0.00,	0.00,	''),
(384,	196,	77,	'小麦粉、奶油、植物油、白砂糖、乳粉等',	0.00,	0.00,	''),
(385,	196,	79,	'商品规格：192g 生产日期：2017年4月以后(具体以实物为准） 保质期：365天',	0.00,	0.00,	''),
(386,	196,	80,	'SHOP_SN0000196',	0.00,	0.00,	''),
(387,	197,	6,	'5',	0.00,	0.00,	''),
(388,	197,	7,	'0',	0.00,	0.00,	''),
(389,	197,	9,	'1',	0.00,	0.00,	''),
(390,	197,	73,	'2',	0.00,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/59882bf4b7c18.jpg'),
(391,	197,	74,	'太祖',	0.00,	0.00,	''),
(392,	197,	75,	'牛轧糖椰香味200g',	0.00,	0.00,	''),
(393,	197,	76,	'中国',	0.00,	0.00,	''),
(394,	197,	77,	'麦芽糖、花生、乳粉、海藻糖、奶油、白砂糖等',	0.00,	0.00,	''),
(395,	197,	78,	'袋装',	0.00,	0.00,	''),
(396,	197,	79,	'商品规格：200g 生产日期：2017年5月以后(具体以实物为准） 保质期：270天',	0.00,	0.00,	''),
(397,	197,	80,	'SHOP_SN0000197',	0.00,	0.00,	''),
(401,	190,	53,	'0',	10.00,	0.00,	''),
(402,	189,	53,	'0',	100.00,	0.00,	''),
(408,	187,	1,	'0',	20.00,	0.00,	''),
(409,	187,	1,	'2',	20.00,	0.00,	''),
(410,	187,	1,	'1',	20.00,	0.00,	''),
(411,	187,	2,	'0',	20.00,	0.00,	''),
(412,	204,	6,	'0',	0.00,	0.00,	''),
(413,	204,	7,	'0',	0.00,	0.00,	''),
(414,	204,	9,	'1',	0.00,	0.00,	''),
(415,	204,	10,	'0',	0.00,	0.00,	''),
(416,	204,	73,	'10',	0.00,	0.00,	''),
(417,	204,	74,	'太祖',	0.00,	0.00,	''),
(418,	204,	75,	'太祖冰心绿豆糕原味208g(2件起售）',	0.00,	0.00,	''),
(419,	204,	76,	'中国',	0.00,	0.00,	''),
(420,	204,	77,	'绿豆、小麦粉、奶油、白砂糖等',	0.00,	0.00,	''),
(421,	204,	79,	'商品规格：208g 生产日期：2017年7月以后(具体以实物为准） 保质期：90天',	0.00,	0.00,	''),
(422,	204,	80,	'6942031811399',	0.00,	0.00,	''),
(423,	206,	70,	'1',	0.00,	0.00,	''),
(424,	216,	11,	'0',	0.00,	0.00,	''),
(425,	216,	13,	'0',	0.00,	0.00,	''),
(426,	216,	14,	'0',	0.00,	0.00,	''),
(427,	216,	15,	'0',	0.00,	0.00,	''),
(428,	216,	16,	'2',	0.00,	0.00,	''),
(430,	222,	71,	'1',	0.00,	0.00,	''),
(432,	217,	11,	'11',	0.00,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170817/5995057f71058.png'),
(438,	231,	11,	'0',	10.00,	20.00,	''),
(442,	226,	11,	'21',	10.00,	20.00,	''),
(443,	226,	85,	'0',	20.00,	30.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170817/59953d3cddd12.jpg'),
(444,	237,	11,	'2',	0.00,	0.00,	''),
(445,	237,	12,	'14',	0.00,	0.00,	''),
(446,	237,	13,	'1',	0.00,	0.00,	''),
(447,	237,	14,	'0',	0.00,	0.00,	''),
(448,	237,	16,	'0',	0.00,	0.00,	''),
(449,	238,	6,	'0',	0.00,	0.00,	''),
(450,	238,	7,	'0',	0.00,	0.00,	''),
(451,	238,	8,	'5',	0.00,	0.00,	''),
(452,	238,	9,	'1',	0.00,	0.00,	''),
(453,	238,	10,	'0',	0.00,	0.00,	''),
(480,	249,	11,	'0',	0.00,	0.00,	''),
(481,	249,	12,	'1',	0.00,	0.00,	''),
(482,	249,	12,	'3',	0.00,	0.00,	''),
(483,	249,	12,	'4',	0.00,	0.00,	''),
(484,	249,	13,	'0',	0.00,	0.00,	''),
(485,	249,	14,	'1',	0.00,	0.00,	''),
(486,	249,	15,	'0',	0.00,	0.00,	''),
(487,	242,	3,	'2',	0.00,	0.00,	''),
(488,	242,	6,	'0',	0.00,	0.00,	''),
(489,	242,	6,	'2',	0.00,	0.00,	''),
(490,	242,	7,	'1',	0.00,	0.00,	''),
(491,	242,	7,	'0',	0.00,	0.00,	''),
(492,	242,	8,	'6',	0.00,	0.00,	''),
(493,	242,	9,	'0',	0.00,	0.00,	''),
(494,	242,	9,	'1',	0.00,	0.00,	''),
(495,	242,	10,	'0',	0.00,	0.00,	''),
(496,	242,	10,	'2',	0.00,	0.00,	''),
(497,	242,	49,	'0',	0.00,	0.00,	''),
(498,	242,	49,	'1',	0.00,	0.00,	''),
(499,	242,	50,	'1',	0.00,	0.00,	''),
(500,	242,	50,	'0',	0.00,	0.00,	''),
(512,	250,	87,	'0',	0.00,	0.00,	''),
(513,	250,	87,	'1',	0.00,	0.00,	''),
(514,	241,	6,	'3',	0.00,	0.00,	''),
(515,	241,	6,	'0',	0.00,	0.00,	''),
(516,	241,	6,	'2',	0.00,	0.00,	''),
(517,	241,	7,	'0',	0.00,	0.00,	''),
(518,	241,	8,	'8',	0.00,	0.00,	''),
(519,	241,	8,	'2',	0.00,	0.00,	''),
(520,	241,	9,	'0',	0.00,	0.00,	''),
(521,	241,	9,	'1',	0.00,	0.00,	''),
(522,	241,	10,	'0',	0.00,	0.00,	''),
(523,	241,	10,	'16',	0.00,	0.00,	''),
(524,	240,	6,	'3',	0.00,	0.00,	''),
(525,	240,	6,	'4',	10.00,	0.00,	''),
(526,	240,	7,	'0',	0.00,	0.00,	''),
(527,	240,	8,	'2',	0.00,	0.00,	''),
(528,	240,	9,	'1',	0.00,	0.00,	''),
(529,	240,	9,	'0',	0.00,	0.00,	''),
(530,	240,	10,	'0',	0.00,	0.00,	''),
(531,	240,	10,	'2',	0.00,	0.00,	''),
(532,	240,	10,	'3',	0.00,	0.00,	''),
(533,	239,	6,	'3',	0.00,	0.00,	''),
(534,	239,	6,	'2',	0.00,	0.00,	''),
(535,	239,	7,	'0',	0.00,	0.00,	''),
(536,	239,	8,	'5',	0.00,	0.00,	''),
(537,	239,	9,	'1',	0.00,	0.00,	''),
(538,	239,	10,	'0',	0.00,	0.00,	''),
(539,	253,	12,	'15',	0.00,	0.00,	''),
(540,	253,	12,	'17',	0.00,	0.00,	''),
(541,	253,	12,	'16',	0.00,	0.00,	''),
(542,	253,	12,	'14',	0.00,	0.00,	''),
(543,	254,	1,	'0',	100.00,	0.00,	''),
(544,	254,	2,	'0',	0.00,	0.00,	''),
(545,	254,	2,	'1',	0.00,	0.00,	''),
(546,	254,	74,	'三星',	0.00,	0.00,	''),
(547,	254,	75,	'三星手机',	0.00,	0.00,	''),
(548,	255,	1,	'4',	100.00,	0.00,	''),
(549,	255,	1,	'5',	0.00,	0.00,	''),
(550,	255,	2,	'0',	0.00,	0.00,	''),
(551,	255,	3,	'0',	0.00,	0.00,	''),
(552,	255,	74,	'苹果',	0.00,	0.00,	''),
(553,	256,	11,	'8',	0.00,	0.00,	''),
(554,	256,	12,	'16',	0.00,	0.00,	''),
(555,	256,	12,	'15',	0.00,	0.00,	''),
(556,	256,	13,	'1',	0.00,	0.00,	''),
(557,	256,	14,	'0',	0.00,	0.00,	''),
(558,	256,	15,	'0',	0.00,	0.00,	''),
(559,	256,	16,	'0',	0.00,	0.00,	''),
(586,	257,	6,	'3',	10.00,	0.00,	''),
(587,	257,	7,	'0',	0.00,	0.00,	''),
(588,	257,	89,	'0',	0.00,	0.00,	''),
(589,	257,	89,	'1',	2.00,	0.00,	''),
(590,	257,	89,	'2',	4.00,	0.00,	''),
(591,	257,	51,	'1000',	0.00,	0.00,	''),
(592,	257,	74,	'太湖馆',	0.00,	0.00,	''),
(593,	257,	75,	'大别山黑毛土猪',	0.00,	0.00,	''),
(594,	257,	76,	'大别山',	0.00,	0.00,	''),
(595,	257,	78,	'袋装',	0.00,	0.00,	''),
(625,	258,	90,	'0',	0.00,	0.00,	''),
(626,	258,	90,	'1',	0.00,	0.00,	''),
(627,	258,	91,	'0',	-200.00,	0.00,	''),
(628,	258,	92,	'0',	0.00,	0.00,	''),
(629,	258,	92,	'1',	0.00,	0.00,	''),
(630,	258,	92,	'2',	0.00,	0.00,	''),
(631,	258,	92,	'3',	0.00,	0.00,	''),
(632,	258,	74,	'Apple',	0.00,	0.00,	''),
(633,	258,	75,	'Apple iPhone 6s Plus (A1699) 32G',	0.00,	0.00,	''),
(634,	258,	76,	'中国大陆',	0.00,	0.00,	''),
(635,	258,	78,	'盒装',	0.00,	0.00,	''),
(636,	259,	6,	'1',	2.00,	0.00,	''),
(637,	259,	7,	'0',	0.00,	0.00,	''),
(638,	259,	9,	'1',	0.00,	0.00,	''),
(639,	259,	74,	'绿鲜知',	0.00,	0.00,	''),
(640,	259,	75,	'紫薯',	0.00,	0.00,	''),
(641,	259,	76,	'云南',	0.00,	0.00,	''),
(642,	259,	78,	'袋装',	0.00,	0.00,	''),
(643,	260,	94,	'0',	0.00,	0.00,	''),
(644,	260,	94,	'1',	-5.00,	0.00,	''),
(645,	260,	95,	'1',	-10.00,	0.00,	''),
(647,	262,	94,	'0',	0.00,	0.00,	''),
(648,	262,	95,	'0',	0.00,	0.00,	''),
(649,	262,	95,	'2',	0.00,	0.00,	''),
(650,	262,	95,	'1',	0.00,	0.00,	''),
(651,	185,	13,	'0',	0.00,	0.00,	''),
(652,	185,	13,	'2',	0.00,	0.00,	''),
(653,	185,	13,	'1',	0.00,	0.00,	'');

DROP TABLE IF EXISTS `hanchao_goods_attr_stock`;
CREATE TABLE `hanchao_goods_attr_stock` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `goods_id` int(11) NOT NULL COMMENT '商品id',
  `attr_key` varchar(100) NOT NULL COMMENT '属性ID以下划线从小到大排序的key',
  `stock_cfg` int(10) NOT NULL COMMENT '该属性组合的库存数',
  `sell_count` int(11) DEFAULT '0' COMMENT '当前属性组合的已卖的量，用于库存验证',
  `goods_attr_sn` char(20) NOT NULL COMMENT '商品属性货号',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=173 DEFAULT CHARSET=utf8 COMMENT='商品属性库存表';

INSERT INTO `hanchao_goods_attr_stock` (`id`, `goods_id`, `attr_key`, `stock_cfg`, `sell_count`, `goods_attr_sn`) VALUES
(8,	9,	'7_8',	30,	0,	'1238975p'),
(10,	14,	'12_14_16',	50,	0,	''),
(11,	14,	'13_14_16',	30,	0,	''),
(12,	0,	'',	20,	0,	''),
(13,	0,	'',	20,	0,	''),
(14,	29,	'25_26_27_29',	4,	0,	'SHOP_SN0000030'),
(15,	29,	'25_26_28_30',	9,	1,	'SHOP_SN0000036'),
(16,	29,	'25_26_27_30',	8,	0,	'SHOP_SN0000032'),
(17,	29,	'25_26_28_29',	9,	0,	'SHOP_SN0000031'),
(23,	48,	'110_111_113_115',	18,	6,	'SHOP_SN0000049'),
(24,	48,	'110_112_114_116',	19,	0,	'SHOP_SN0000052'),
(25,	48,	'110_112_114_115',	19,	0,	'SHOP_SN0000051'),
(26,	48,	'110_111_113_116',	20,	0,	'SHOP_SN0000050'),
(30,	46,	'63_64_67_68_69_70',	20,	0,	'001'),
(31,	46,	'63_65_67_68_69_70',	20,	0,	'002'),
(32,	46,	'63_66_67_68_69_70',	20,	0,	'003'),
(33,	49,	'138_139_141',	32,	5,	'005'),
(34,	49,	'138_140_142',	49,	0,	'020'),
(35,	49,	'138_140_141',	49,	0,	'007'),
(36,	49,	'138_139_142',	20,	0,	'006'),
(37,	44,	'144_148',	93,	3,	'010'),
(38,	44,	'145_148',	72,	28,	'013'),
(39,	44,	'146_148',	100,	0,	'012'),
(40,	44,	'147_148',	76,	17,	'011'),
(44,	43,	'91_92_96_97_98_99',	30,	0,	'01'),
(45,	43,	'91_93_96_97_98_99',	30,	0,	'02'),
(46,	43,	'91_94_96_97_98_99',	40,	0,	'03'),
(47,	45,	'79_81_83_84_85_86',	26,	2,	'04'),
(48,	45,	'79_82_83_84_85_86',	28,	0,	'05'),
(49,	0,	'',	30,	0,	'06'),
(60,	47,	'192',	100,	0,	'0161'),
(61,	47,	'193',	100,	0,	'0162'),
(62,	68,	'208',	499,	0,	'999888001'),
(63,	67,	'209',	800,	0,	'999888002'),
(64,	66,	'210',	999,	0,	'999888003'),
(65,	65,	'211',	999,	0,	'999888004'),
(66,	52,	'212',	1500,	0,	'999888005'),
(70,	0,	'',	15,	0,	'11117777'),
(71,	71,	'225_226_229',	7,	1,	'11115555'),
(72,	71,	'225_227_229',	0,	0,	'11118888'),
(73,	71,	'225_228_229',	14,	0,	'11116666'),
(74,	72,	'230_232',	3,	3,	'1122'),
(75,	72,	'231_233',	15,	0,	'1199'),
(76,	72,	'231_234',	9,	1,	'1177'),
(77,	72,	'231_232',	20,	0,	'1188'),
(78,	72,	'230_234',	1,	1,	'1133'),
(79,	72,	'230_233',	16,	14,	'1155'),
(83,	70,	'222_224',	100,	0,	'13331205'),
(84,	10,	'44_45',	98,	3,	'00001'),
(85,	2,	'1_5',	8,	9,	'123456'),
(86,	2,	'3_6',	28,	0,	'k145456'),
(87,	2,	'4_6',	16,	1,	'456789p'),
(88,	2,	'1_6',	17,	0,	'h54654'),
(89,	2,	'2_5',	5,	1,	'78952134'),
(90,	2,	'3_5',	18,	0,	'01274895'),
(91,	2,	'4_5',	18,	0,	'456789'),
(96,	8,	'266_267',	10,	0,	'123465789'),
(104,	199,	'341',	40,	0,	'12314241'),
(105,	199,	'342',	60,	0,	'678768'),
(107,	193,	'347_348_349_350',	100,	0,	'SHOP_SN0000193'),
(108,	194,	'358_359_360_361',	100,	0,	'SHOP_SN0000194'),
(109,	195,	'368_369_370_371',	96,	0,	'SHOP_SN0000195'),
(110,	196,	'377_378_379_380',	91,	4,	'SHOP_SN0000196'),
(112,	197,	'387_388_389_390',	54,	31,	'SHOP_SN0000197'),
(113,	190,	'401',	0,	0,	'0003'),
(114,	189,	'402',	0,	0,	'00036'),
(119,	187,	'408_411',	6,	1,	'00263'),
(120,	187,	'410_411',	10,	0,	'00236'),
(122,	186,	'273',	100,	0,	'11111'),
(123,	237,	'444_445_446_447_448',	100,	0,	'SHOP_SN0000237'),
(124,	204,	'412_413_414_415_416',	92,	2,	'hanchao000006'),
(128,	250,	'513',	100,	0,	'emotianshi0001'),
(129,	0,	'',	100,	0,	'emotianshi0002'),
(130,	242,	'487_489_490_492_493_495_497_499',	10,	0,	'yeyuefei000001'),
(131,	242,	'487_489_491_492_494_496_498_499',	10,	0,	'yeyuefei000002'),
(132,	241,	'514_517_518_520_522',	100,	0,	'heihuafeihuihuifa001'),
(133,	241,	'516_517_519_521_523',	100,	0,	'heihuafeihuihuifa002'),
(134,	240,	'524_526_527_528_530',	120,	0,	'heihuafeihuihuifa000'),
(135,	240,	'525_526_527_529_532',	120,	0,	'heihuafeihuihuifa000'),
(136,	239,	'533_535_536_537_538',	0,	0,	'heihuafeihuifahui000'),
(137,	239,	'534_535_536_537_538',	0,	0,	'heihuafeihuihuifa000'),
(139,	254,	'543_544',	221,	0,	'111'),
(140,	254,	'543_545',	555,	0,	'222'),
(141,	256,	'553_554_556_557_558_559',	2540,	1,	'10'),
(142,	256,	'553_555_556_557_558_559',	3698,	0,	'11'),
(143,	255,	'548_550_551',	589,	0,	'21'),
(144,	255,	'549_550_551',	14785,	0,	'20'),
(148,	257,	'586_587_588',	888888,	0,	'999999'),
(149,	257,	'586_587_589',	50,	0,	'777777'),
(150,	257,	'586_587_590',	30,	0,	'666666'),
(153,	0,	'',	100,	0,	'010235982017'),
(158,	0,	'',	100,	0,	'010015'),
(159,	0,	'',	100,	0,	'010016'),
(160,	0,	'',	100,	0,	'010017'),
(161,	0,	'',	100,	0,	'010018'),
(162,	258,	'625_627_628',	100,	0,	'0100012'),
(163,	258,	'625_627_629',	100,	0,	'0100013'),
(164,	258,	'625_627_630',	100,	0,	'0100014'),
(165,	258,	'625_627_631',	100,	0,	'0100015'),
(166,	0,	'',	100,	0,	'0100016'),
(167,	0,	'',	100,	0,	'0100017'),
(168,	0,	'',	100,	0,	'0100018'),
(169,	0,	'',	100,	0,	'0100019'),
(170,	259,	'636_637_638',	90,	0,	'11660213'),
(172,	262,	'647_648',	100,	0,	'102030223');

DROP TABLE IF EXISTS `hanchao_goods_attribute`;
CREATE TABLE `hanchao_goods_attribute` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '属性主键',
  `type_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品类型ID',
  `name` varchar(60) NOT NULL COMMENT '属性名字',
  `type` varchar(20) NOT NULL COMMENT '表单属性',
  `is_img` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否自定义图片',
  `options` text NOT NULL COMMENT '属性值',
  `is_search` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否搜索项',
  `sort` smallint(5) NOT NULL DEFAULT '10' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态',
  `shop_id` int(10) unsigned NOT NULL COMMENT '店铺id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=96 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='商品属性表';

INSERT INTO `hanchao_goods_attribute` (`id`, `type_id`, `name`, `type`, `is_img`, `options`, `is_search`, `sort`, `status`, `shop_id`) VALUES
(1,	20,	'颜色',	'checkbox',	1,	'钻雕金,钻雕蓝,玫瑰金,陶瓷白,玫瑰金,灰色,黑色,红色',	1,	10,	1,	0),
(2,	20,	'版本',	'checkbox',	1,	'全网通4G+64G标配,全网通4G+128G标配,全网通4G+32G标配',	1,	10,	1,	0),
(3,	19,	'材质',	'checkbox',	1,	'铝合金,不锈钢,其他',	1,	10,	1,	0),
(4,	18,	'适用年龄',	'checkbox',	1,	'0-6个月,1-3岁,4-6岁,4-12岁,6岁以上,其它,7-12个月,7-13岁,12个月以下,12岁以上,12以上,14岁以上',	1,	10,	1,	0),
(5,	18,	'包装',	'checkbox',	1,	'盒装,礼盒,罐装,其它',	1,	10,	1,	0),
(6,	10,	'包装单位',	'checkbox',	1,	'盒装,箱装,罐装,袋装,分享装,其它,其它',	1,	10,	1,	0),
(7,	10,	'国产进口',	'checkbox',	0,	'国产,进口,其它',	1,	10,	1,	0),
(8,	10,	'产品产地',	'checkbox',	0,	'韩国,印尼,港澳台,日本,德国,美国,泰国,马来西亚,其它,越南',	1,	10,	1,	0),
(9,	10,	'是否含糖',	'checkbox',	0,	'无糖,含糖,其它',	1,	10,	1,	0),
(10,	10,	'口味',	'checkbox',	1,	'原味,香辣味,甜味,五香味,麻辣味,奶油味,混合味,混合口味,巧克力味,咸味,其它,烧烤味,盐焗味,果味,椒盐味,芝士味,泡椒味,葱香味,芝麻味,柠檬味,蔬果味,XO酱味,孜然味,海苔味,蒜香味,咖喱味,香芋味,芥末味,蜂蜜味,黑椒味,番茄味,其他',	1,	10,	1,	0),
(11,	21,	'款式',	'checkbox',	0,	'连衣裙,短外套,T恤,衬衫,风衣,针织衫,毛呢大衣,大码女装,卫衣,雪纺衫,中老年女装,休闲裤,牛仔裤,打底衫,半身裙,小西装,羽绒服,打底裤,棉服,旗袍/唐装,马甲,短裤,仿皮皮衣,吊带/背心,羊毛衫,真皮皮衣,皮草,婚纱,设计师/潮牌,礼服,羊绒衫,正装裤,加绒裤',	1,	10,	1,	0),
(12,	21,	'尺码',	'checkbox',	0,	'25\r\n26\r\n27\r\n28\r\n29\r\n30\r\n31\r\n32\r\n33\r\n34\r\n35\r\n36\r\nXXS\r\nXS\r\nS\r\nM\r\nL\r\nXL\r\nXXL\r\n3XL\r\n4XL\r\n5XL\r\n6XL',	1,	10,	1,	0),
(13,	21,	'版型',	'checkbox',	1,	'修身型\r\n宽松型\r\n直筒型\r\n其它',	1,	10,	1,	0),
(14,	21,	'上市时间',	'checkbox',	0,	'2017春季\r\n2016春季\r\n2017夏季\r\n2016秋季\r\n2016夏季\r\n2016冬季\r\n2015春季\r\n2015秋季\r\n2015夏季\r\n2015冬季\r\n往季',	1,	10,	1,	0),
(15,	21,	'衣长',	'checkbox',	1,	'中长款\r\n常规款\r\n短款\r\n长款\r\n其它',	1,	10,	1,	0),
(16,	21,	'适应类型',	'checkbox',	0,	'学生\r\n胖mm\r\n轻熟女\r\n亲子\r\n成熟\r\n少女\r\n孕妇',	1,	10,	1,	0),
(17,	22,	'款式',	'checkbox',	0,	'夹克\r\nT恤\r\n衬衫\r\n休闲裤\r\n牛仔裤\r\n西服\r\n风衣\r\n卫衣\r\n卫裤/运动裤\r\n针织衫\r\n短裤\r\n羽绒服\r\n中老年男装\r\n毛呢大衣\r\n棉服\r\nPOLO衫\r\n西裤\r\n唐装/中山装\r\n大码男装\r\n马甲/背心\r\n西服套装\r\n设计师/潮牌\r\n真皮皮衣\r\n羊毛衫\r\n羊绒衫\r\n工装\r\n仿皮皮衣\r\n加绒裤',	1,	10,	1,	0),
(18,	22,	'尺寸',	'checkbox',	0,	'27\r\n28\r\n29\r\n30\r\n31\r\n32\r\n33\r\n34\r\n35\r\n36\r\n37\r\n38\r\n39\r\n40\r\n41\r\n42\r\n43\r\n44\r\n45\r\n46\r\nXXS\r\nXS\r\nS\r\nM\r\nL\r\nXL\r\nXXL\r\n3XL\r\n4XL\r\n5XL\r\n6XL\r\n7XL\r\n8XL',	1,	10,	1,	0),
(19,	22,	'人群',	'checkbox',	1,	'青年\r\n中年\r\n青少年\r\n老年\r\n大码人群\r\n情侣装\r\n其它',	1,	10,	1,	0),
(20,	22,	'风格',	'checkbox',	1,	'商务休闲\r\n青春休闲\r\n商务正装\r\n日韩风格\r\n欧美简约\r\n时尚休闲\r\n中国风\r\n军旅工装\r\n原创设计\r\n朋克潮流\r\n嘻哈风格\r\n复古风\r\n英式学院\r\n原生态\r\n英伦学院',	1,	10,	1,	0),
(21,	22,	'袖型',	'checkbox',	1,	'长袖\r\n短袖\r\n无袖\r\n七分袖\r\n五分袖\r\n其它',	1,	10,	1,	0),
(22,	22,	'主要材质',	'checkbox',	1,	'棉\r\n涤纶\r\n羊毛\r\n锦纶\r\n麻\r\n羊绒\r\n粘胶纤维\r\nPU人造革\r\n蚕丝\r\n腈纶\r\n莫代尔\r\n苎麻\r\nLYCRA莱卡\r\n亚麻\r\n桑蚕丝\r\n大麻\r\n莱赛尔纤维\r\n莫代尔纤维\r\n氨纶\r\n榨蚕丝\r\n醋纤\r\n其它',	1,	10,	1,	0),
(23,	22,	'裤型',	'checkbox',	1,	'修身裤\r\n直筒裤\r\n宽松裤\r\n哈伦裤\r\n锥形裤\r\n喇叭裤\r\n背带裤\r\n低裆垮裤\r\n连体裤',	1,	10,	1,	0),
(24,	23,	'翡翠玉石',	'checkbox',	1,	'项链/吊坠\r\n手镯/手串\r\n耳饰\r\n挂件/摆件/把件\r\n戒指\r\n玉石孤品',	1,	10,	1,	0),
(25,	23,	'钻石',	'checkbox',	1,	'钻戒\r\n钻石项链/吊坠\r\n钻石耳饰\r\n钻石手镯/手链\r\n裸钻',	1,	10,	1,	0),
(26,	23,	'珍珠',	'checkbox',	1,	'珍珠项链\r\n珍珠吊坠\r\n珍珠手链\r\n珍珠耳饰\r\n珍珠戒指\r\n珍珠胸针',	1,	10,	1,	0),
(27,	23,	'材质',	'checkbox',	1,	'和田玉\r\n翡翠\r\n水晶\r\n玛瑙\r\n碧玺\r\n玉石\r\n宝石\r\n其它',	1,	10,	1,	0),
(28,	23,	'款式',	'checkbox',	1,	'女款\r\n宽边\r\n窄边\r\n圆柱\r\n对戒\r\n贵妃\r\n男款\r\n金镶玉\r\n其它',	1,	10,	1,	0),
(29,	23,	'主石重量',	'checkbox',	1,	'1克拉以上\r\n2克拉以上\r\n10分以下\r\n11-20分\r\n21-40分\r\n41-50分\r\n51-70分\r\n71分-1克拉\r\n无主石',	1,	10,	1,	0),
(30,	23,	'适用人群',	'checkbox',	1,	'女\r\n男\r\n情侣',	1,	10,	1,	0),
(31,	23,	'图案',	'checkbox',	1,	'貔貅\r\n观音\r\n佛\r\n生肖\r\n动物\r\n人物\r\n花草\r\n关公\r\n其它',	1,	10,	1,	0),
(32,	23,	'用途',	'checkbox',	1,	'送女友\r\n情侣\r\n求婚戒指\r\n其它',	1,	10,	1,	0),
(33,	23,	'分类',	'checkbox',	1,	'手镯\r\n淡水珍珠\r\n大溪地黑珍珠\r\n日本海水珍珠\r\n南洋珍珠\r\n手串\r\n其它',	1,	10,	1,	0),
(34,	23,	'证书',	'checkbox',	1,	'国检NGTC\r\n国首\r\n工商联\r\nNGTC\r\n北大证书\r\n地大证书\r\n美国宝石学院GIA\r\n省级证书\r\n中维质检\r\n无证书\r\n中工\r\n其它\r\n其他国内证书',	1,	10,	1,	0),
(35,	23,	'切工',	'checkbox',	1,	'Very Good很好\r\n不分级\r\nExcellent极好\r\nGood好',	1,	10,	1,	0),
(36,	24,	'人群',	'checkbox',	1,	'男士\r\n女士\r\n情侣\r\n儿童\r\n中性',	1,	10,	1,	0),
(37,	24,	'钟表',	'checkbox',	1,	'国表\r\n瑞表\r\n日韩表\r\n欧美表\r\n德表\r\n智能手表\r\n钟表配件\r\n赠品\r\n座钟挂钟\r\n闹钟',	1,	10,	1,	0),
(38,	24,	'机芯',	'checkbox',	1,	'石英\r\n自动机械\r\n机械\r\n光能\r\n其它\r\n手动机械\r\n电波\r\n人动电能',	1,	10,	1,	0),
(39,	25,	'分类',	'checkbox',	1,	'葡萄酒\r\n餐边柜\r\n清洁工具\r\n一次性用品\r\n亲子幼教\r\n绿植\r\n礼品文具\r\n工艺礼品\r\n厨房DIY/小工具\r\n储物/置物架\r\n烹饪/美食\r\n管理\r\n玻璃杯\r\n酒杯/酒具\r\n塑料杯\r\n收纳架/篮\r\n收纳袋/包\r\n冷柜/冰吧\r\n装饰摆件\r\n墙贴/装饰贴\r\n创意家居\r\n饮用水\r\n冲饮谷物\r\n自助餐炉\r\n净化除味\r\n文件管理\r\n办公文具\r\n中国文学\r\n供应链管理\r\n市场营销\r\n茶杯\r\n内蒙古\r\n教学/展示用品\r\n其它厨房电器\r\n餐边柜\r\n餐具用品\r\n餐车\r\n文件夹/袋\r\n厨房小工具\r\n检测\r\n墙贴\r\n玻璃杯\r\n垃圾桶\r\n时尚设计\r\n白葡萄酒\r\n其它\r\n陶艺摆件\r\n压水器/滤水器\r\n红葡萄酒',	1,	10,	1,	0),
(40,	25,	'容量',	'checkbox',	1,	'31-50ml\r\n50ml及以下\r\n201-300ml\r\n100ml以下\r\n301-400ml\r\n750ml',	1,	10,	1,	0),
(41,	25,	'温控方式',	'checkbox',	1,	'电子控温\r\n机械控温',	1,	10,	1,	0),
(42,	25,	'制冷方式',	'checkbox',	1,	'风冷\r\n直冷',	1,	10,	1,	0),
(43,	25,	'材质',	'checkbox',	1,	'板材\r\n铁\r\n塑料\r\n不锈钢\r\n亚克力\r\n金属\r\n实木\r\n玻璃\r\n其它',	1,	10,	1,	0),
(44,	25,	'风格',	'checkbox',	1,	'中式\r\n现代简约\r\n欧式\r\n简约\r\n古典欧式\r\n其它',	1,	10,	1,	0),
(45,	25,	'压缩机',	'checkbox',	1,	'定频\r\n变频',	1,	10,	1,	0),
(46,	25,	'产品类型',	'checkbox',	1,	'展示柜\r\n商用冷柜',	1,	10,	1,	0),
(47,	25,	'类型',	'checkbox',	1,	'酒\r\n茶\r\n咖啡\r\n其它',	1,	10,	1,	0),
(48,	25,	'使用场景',	'checkbox',	1,	'冰箱\r\n其它',	1,	10,	1,	0),
(49,	11,	'包装单位',	'checkbox',	1,	'箱装\r\n提装\r\n包装\r\n其它',	1,	-100,	1,	0),
(50,	11,	'层数',	'checkbox',	1,	'2层\r\n3层\r\n4层\r\n其它',	1,	10,	1,	0),
(51,	11,	'净含量',	'text',	1,	'',	1,	1000,	1,	0),
(52,	26,	'养生套餐',	'checkbox',	1,	'套餐一\r\n套餐二\r\n套餐三',	1,	10,	1,	0),
(53,	27,	'颜色',	'checkbox',	1,	'红色,黄色,黑色',	1,	10,	1,	0),
(54,	28,	'颜色',	'checkbox',	1,	'比赛8号 鸭毛球（1桶装）\r\n金毛1号 鸭毛球（1桶装）\r\n金毛5号 鸭毛球（1桶装）\r\n粉特惠级 鸭毛球（1桶装）\r\n大师号 鹅毛球（1桶装）',	1,	10,	1,	0),
(55,	21,	'颜色',	'text',	1,	'蓝色\r\n粉色\r\n黑色\r\n红色',	1,	10,	1,	0),
(56,	21,	'尺码',	'text',	1,	'S\r\nM\r\nL\r\nXL',	1,	10,	1,	0),
(59,	29,	'颜色',	'checkbox',	1,	'红\r\n白\r\n蓝\r\n黑',	0,	10,	1,	4),
(61,	29,	'尺寸',	'checkbox',	1,	'14\r\n15\r\n16',	0,	10,	1,	4),
(62,	29,	'版本',	'checkbox',	1,	'移动\r\n联通\r\n电信',	0,	10,	1,	4),
(63,	30,	'尺寸',	'checkbox',	1,	'12\r\n14\r\n16',	0,	10,	1,	34),
(64,	30,	'材质',	'checkbox',	1,	'不锈钢\r\n碳合金\r\n铝合金',	0,	10,	1,	34),
(66,	31,	'羽毛球类型',	'checkbox',	1,	'鹅毛\r\n鸭毛',	0,	10,	1,	7),
(68,	34,	'尺寸',	'text',	1,	'180*180\r\n200*200',	0,	10,	1,	40),
(69,	34,	'尺寸',	'checkbox',	1,	'180*180\r\n200*200\r\n220*220',	0,	10,	1,	40),
(70,	35,	'颜色',	'checkbox',	1,	'点点星光,情定罗马蓝,高空谱曲',	0,	10,	1,	43),
(71,	35,	'夏凉被颜色',	'checkbox',	1,	'蓝\r\n米白\r\n红',	0,	10,	1,	43),
(72,	34,	'颜色',	'checkbox',	0,	'红色\r\n黑色',	0,	10,	1,	40),
(73,	36,	'尺寸',	'checkbox',	1,	'88g/袋\r\n150g/袋\r\n200g/包\r\n45g/包\r\n128g/盒\r\n220g/包\r\n均码\r\n200g/盒\r\n32g/瓶\r\n240g/盒\r\n其他尺码',	0,	10,	1,	44),
(74,	36,	'品牌名称',	'text',	1,	'',	0,	10,	1,	44),
(75,	36,	'商品名称',	'text',	1,	'',	0,	10,	1,	44),
(76,	36,	'产地',	'text',	1,	'',	0,	10,	1,	44),
(77,	36,	'材质',	'text',	1,	'',	0,	10,	1,	44),
(78,	36,	'包装',	'text',	1,	'',	0,	10,	1,	44),
(79,	36,	'配件备注',	'text',	1,	'',	0,	10,	1,	44),
(80,	36,	'商品编号',	'text',	1,	'',	0,	10,	1,	44),
(81,	35,	'尺码',	'checkbox',	1,	'1.8米床（230*229cm）\r\n1.2米床（152*210cm）\r\n1.5米床（203*229cm）',	0,	10,	1,	43),
(82,	35,	'颜色3',	'checkbox',	1,	'汐颜\r\n时光正好\r\n芳菲四月',	0,	10,	1,	43),
(84,	35,	'衬衫加抹胸',	'text',	1,	'',	0,	10,	1,	43),
(85,	35,	'款式',	'checkbox',	1,	'衬衫+内搭',	0,	10,	1,	43),
(86,	37,	'= =',	'text',	1,	'= =',	0,	10,	1,	48),
(87,	37,	'大刀',	'checkbox',	1,	'没花纹,有花纹',	0,	10,	1,	48),
(88,	37,	'尺寸',	'checkbox',	1,	'小刀,大刀,中刀',	0,	10,	1,	48),
(89,	36,	'猪肉类别',	'checkbox',	1,	'前腿肉,五花肉,后腿肉·',	0,	10,	1,	44),
(90,	36,	'购买方式',	'checkbox',	1,	'官方标配,移动优惠购',	0,	10,	1,	44),
(91,	36,	'优惠类型',	'checkbox',	1,	'老用户优惠购机,买手机省话费',	0,	10,	1,	44),
(92,	36,	'选择颜色',	'checkbox',	1,	'金色,玫瑰金,炫黑,银白色',	0,	10,	1,	44),
(93,	38,	'车身颜色',	'text',	1,	'黄色,红色,蓝色,黑色,紫色,桔色',	0,	10,	1,	49),
(94,	38,	'车型',	'checkbox',	1,	'官方标配,二手车',	0,	10,	1,	49),
(95,	38,	'购买方式',	'checkbox',	1,	'现金,刷卡,贷款',	0,	10,	1,	49);

DROP TABLE IF EXISTS `hanchao_goods_cat`;
CREATE TABLE `hanchao_goods_cat` (
  `goods_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID',
  `catid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '分类ID',
  PRIMARY KEY (`goods_id`,`catid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='商品分类中间表';

INSERT INTO `hanchao_goods_cat` (`goods_id`, `catid`) VALUES
(14,	8),
(19,	47),
(21,	145),
(22,	145),
(37,	0),
(49,	99),
(54,	0),
(71,	117),
(71,	127),
(101,	4),
(102,	154),
(103,	115),
(105,	153),
(107,	4),
(108,	115),
(110,	116),
(111,	68),
(187,	99),
(190,	94),
(207,	155),
(247,	165);

DROP TABLE IF EXISTS `hanchao_goods_category`;
CREATE TABLE `hanchao_goods_category` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `name` varchar(90) NOT NULL COMMENT '分类名称',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父ID',
  `type_id` smallint(5) NOT NULL DEFAULT '0' COMMENT '属性ID',
  `class` varchar(255) NOT NULL COMMENT '类名',
  `is_home` tinyint(1) NOT NULL DEFAULT '0' COMMENT '首页推荐',
  `sort` smallint(5) NOT NULL DEFAULT '10' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否显示',
  `seotitle` varchar(255) NOT NULL COMMENT 'seo题目',
  `seokeywords` varchar(255) NOT NULL COMMENT 'seo关键字',
  `seodescription` varchar(255) NOT NULL COMMENT 'Seo描述',
  `measure_unit` varchar(15) NOT NULL COMMENT '数量单位',
  `show_in_nav` tinyint(1) NOT NULL COMMENT '是否显示在导航栏',
  `grade` tinyint(4) NOT NULL COMMENT '价格分级',
  `price` decimal(20,2) NOT NULL COMMENT '保证金',
  `icon` varchar(255) NOT NULL COMMENT '图标',
  `img` varchar(255) NOT NULL COMMENT '分类图片',
  `balance_rate` decimal(10,2) NOT NULL DEFAULT '1.00' COMMENT '商家佣金比，只适用于一级分类',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=171 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='商品分类表';

INSERT INTO `hanchao_goods_category` (`id`, `name`, `pid`, `type_id`, `class`, `is_home`, `sort`, `status`, `seotitle`, `seokeywords`, `seodescription`, `measure_unit`, `show_in_nav`, `grade`, `price`, `icon`, `img`, `balance_rate`) VALUES
(1,	'食品饮料',	0,	10,	'',	1,	5,	1,	'食品饮料',	'食品饮料',	'食品饮料',	'',	0,	6,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170411/58ec9d2eb3dfb.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170411/58ec9d37d9abf.jpg',	0.00),
(2,	'牛奶乳品',	23,	10,	'',	0,	1500,	1,	'',	'',	'',	'',	0,	4,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170411/58ec9ee31b90a.jpg',	20.00),
(3,	'家庭清洁',	0,	12,	'',	0,	100,	1,	'',	'',	'',	'',	0,	4,	100.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ed7b421b537.jpg',	10.00),
(4,	'汽车用品',	1,	0,	'',	0,	4,	0,	'汽车用品',	'汽车用品',	'汽车用品',	'',	0,	4,	100.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ed936d56002.jpg',	10.00),
(5,	'数码电器',	0,	19,	'',	0,	1,	1,	'数码电器',	'数码电器',	'数码电器',	'',	0,	5,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ed7d187fb04.jpg',	80.00),
(6,	'母婴/洗护',	8,	11,	'',	0,	6,	0,	'母婴/洗护',	'母婴/洗护',	'母婴/洗护',	'',	0,	4,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170513/5916a659b8b5b.png',	0.00),
(7,	'运动健康',	0,	13,	'',	0,	2,	1,	'运动健康',	'运动健康',	'运动健康',	'',	0,	3,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ed94c1bf827.jpg',	0.00),
(8,	'饮料酒水',	1,	10,	'',	1,	1,	1,	'饮料酒水',	'饮料酒水',	'饮料酒水',	'',	0,	4,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ed7f28c1780.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ed7f2fb49f4.jpg',	0.00),
(9,	'干果糕点',	1,	10,	'',	1,	2,	1,	'干果糕点',	'干果糕点',	'干果糕点',	'',	0,	3,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ed7fd697366.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ed7fdc7ed11.jpg',	0.00),
(10,	'米面粮油',	1,	10,	'',	1,	3,	1,	'米面粮油',	'米面粮油',	'米面粮油',	'',	0,	4,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ed8068346e7.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ed806fac6fa.jpg',	0.00),
(11,	'厨房调料',	1,	11,	'',	1,	4,	1,	'厨房调料',	'厨房调料',	'厨房调料',	'',	0,	4,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ed810ed5261.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ed81149dde8.jpg',	0.00),
(12,	'方便速食',	1,	10,	'',	0,	5,	1,	'方便速食',	'方便速食',	'方便速食',	'',	0,	3,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ed82140e314.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ed821a06c51.jpg',	0.00),
(20,	'纸制品/卫生纸',	3,	11,	'',	0,	13,	1,	'纸制品/卫生纸',	'纸制品/卫生纸',	'纸制品/卫生纸',	'',	0,	3,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ed9ada70713.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ed9ae07e96f.jpg',	0.00),
(21,	'清洁剂',	3,	11,	'',	0,	14,	1,	'清洁剂',	'清洁剂',	'清洁剂',	'',	0,	3,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ed9b68bf152.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ed9b6ecf048.jpg',	0.00),
(22,	'衣物护理',	3,	11,	'',	0,	15,	1,	'衣物护理',	'衣物护理',	'衣物护理',	'',	0,	4,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ed9bc5294ae.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ed9bcb4942f.jpg',	0.00),
(23,	'驱虫驱蚊',	3,	11,	'',	0,	200,	1,	'驱虫驱蚊',	'驱虫驱蚊',	'驱虫驱蚊',	'',	0,	2,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ed9c55f3a28.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ed9c5c72d1b.jpg',	0.00),
(27,	'橄榄油',	10,	0,	'',	0,	19,	1,	'',	'',	'',	'',	0,	6,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/598963331112c.png',	0.00),
(29,	'摄影摄像',	5,	13,	'',	0,	21,	1,	'摄影摄像',	'摄影摄像',	'摄影摄像',	'',	0,	4,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58eda35d3d614.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58eda36455d12.jpg',	0.00),
(30,	'厨房电器',	5,	19,	'',	0,	22,	1,	'厨房电器',	'厨房电器',	'厨房电器',	'',	0,	5,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edba26d3798.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edba2ec627d.jpg',	0.00),
(31,	'个护健康',	5,	19,	'',	0,	23,	1,	'个护健康',	'个护健康',	'个护健康',	'',	0,	6,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edbacf8848c.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edbad89aa67.jpg',	0.00),
(32,	'电脑配件',	5,	19,	'',	0,	24,	1,	'电脑配件',	'电脑配件',	'电脑配件',	'',	0,	5,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edbb3fa1a9c.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edbb46b2c83.jpg',	0.00),
(33,	'营养辅食',	6,	10,	'',	0,	25,	0,	'营养辅食',	'营养辅食',	'营养辅食',	'',	0,	6,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edbeddaeac5.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edbee4e99ca.jpg',	0.00),
(34,	'尿裤湿巾',	6,	11,	'',	0,	26,	0,	'尿裤湿巾',	'尿裤湿巾',	'尿裤湿巾',	'',	0,	3,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edc11d90a80.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edc1236b340.jpg',	0.00),
(36,	'户外装备',	7,	13,	'',	0,	28,	1,	'户外装备',	'户外装备',	'户外装备',	'',	0,	6,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edc3f4c8b3a.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edc3fd7cfdb.jpg',	0.00),
(37,	'纤体瑜伽',	7,	12,	'',	0,	10,	1,	'纤体瑜伽',	'纤体瑜伽',	'纤体瑜伽',	'',	0,	5,	0.00,	'',	'',	0.00),
(38,	'体育娱乐',	7,	13,	'',	0,	10,	1,	'体育娱乐',	'体育娱乐',	'体育娱乐',	'',	0,	4,	0.00,	'',	'',	0.00),
(40,	'矿泉水',	8,	10,	'',	0,	2,	1,	'矿泉水',	'矿泉水',	'矿泉水',	'',	0,	2,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59896737ca422.png',	0.00),
(42,	'葡萄酒',	8,	10,	'',	0,	4,	1,	'葡萄酒',	'葡萄酒',	'葡萄酒',	'',	0,	5,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59896809e52ea.png',	0.00),
(43,	'啤酒',	8,	10,	'',	0,	5,	1,	'啤酒',	'啤酒',	'啤酒',	'',	0,	2,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/598968943c324.png',	0.00),
(44,	'白酒',	8,	10,	'',	0,	6,	1,	'白酒',	'白酒',	'白酒',	'',	0,	3,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59896917ac019.png',	0.00),
(46,	'月饼',	9,	10,	'',	0,	2,	1,	'月饼',	'月饼',	'月饼',	'',	0,	2,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59896b1107b77.png',	0.00),
(47,	'饼干',	9,	10,	'',	0,	3,	1,	'饼干',	'饼干',	'饼干',	'',	0,	3,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59896a8701936.png',	0.00),
(48,	'蛋卷',	9,	10,	'',	0,	4,	1,	'蛋卷',	'蛋卷',	'蛋卷',	'',	0,	3,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59896b8950b04.png',	0.00),
(49,	'坚果炒货',	9,	10,	'',	0,	5,	1,	'坚果炒货',	'坚果炒货',	'坚果炒货',	'',	0,	3,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59896c5c08fe0.png',	0.00),
(50,	'米面杂粮',	10,	10,	'',	0,	6,	1,	'米面杂粮',	'米面杂粮',	'米面杂粮',	'',	0,	3,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59896cf62304c.png',	0.00),
(51,	'大米',	10,	10,	'',	0,	7,	1,	'大米',	'大米',	'大米',	'',	0,	2,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59896d7e1d02f.png',	0.00),
(52,	'小米',	10,	10,	'',	0,	8,	1,	'小米',	'小米',	'小米',	'',	0,	2,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59896dde6bb26.png',	0.00),
(53,	'花生油',	10,	10,	'',	0,	9,	1,	'花生油',	'花生油',	'花生油',	'',	0,	3,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59896e333a28a.png',	0.00),
(54,	'芝麻油',	10,	10,	'',	0,	10,	1,	'芝麻油',	'芝麻油',	'芝麻油',	'',	0,	3,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59896e821f1a9.png',	0.00),
(55,	'白糖',	11,	12,	'',	0,	11,	1,	'白糖',	'白糖',	'白糖',	'',	0,	2,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59896f277dbe7.png',	0.00),
(56,	'酱油/醋',	11,	12,	'',	0,	12,	1,	'酱油/醋',	'酱油/醋',	'酱油/醋',	'',	0,	2,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59896f88ceb5b.png',	0.00),
(57,	'豆瓣酱',	11,	10,	'',	0,	13,	1,	'豆瓣酱',	'豆瓣酱',	'豆瓣酱',	'',	0,	2,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59896ffcd5c82.png',	0.00),
(58,	'味精鸡精',	11,	12,	'',	0,	14,	1,	'味精鸡精',	'味精鸡精',	'味精鸡精',	'',	0,	2,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/5989705ed7e01.png',	0.00),
(59,	'料酒',	11,	12,	'',	0,	15,	1,	'料酒',	'料酒',	'料酒',	'',	0,	2,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/598970df45328.png',	0.00),
(60,	'粉丝',	12,	10,	'',	0,	16,	1,	'粉丝',	'粉丝',	'粉丝',	'',	0,	4,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59897164c2755.png',	0.00),
(61,	'火锅鸡',	12,	10,	'',	0,	17,	1,	'火锅鸡',	'火锅鸡',	'火锅鸡',	'',	0,	2,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/598971d558292.png',	0.00),
(62,	'方便面',	12,	10,	'',	0,	18,	1,	'方便面',	'方便面',	'方便面',	'',	0,	2,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59897237e25a3.png',	0.00),
(63,	'八宝粥',	12,	10,	'',	0,	19,	1,	'八宝粥',	'八宝粥',	'八宝粥',	'',	0,	2,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/5989728c8dd1e.png',	0.00),
(64,	'火腿肠',	12,	10,	'',	0,	20,	1,	'火腿肠',	'火腿肠',	'火腿肠',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/598972f32f601.png',	0.00),
(65,	'罐头',	12,	10,	'',	0,	21,	1,	'罐头',	'罐头',	'罐头',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/5989734884d07.png',	0.00),
(66,	'挂面',	12,	10,	'',	0,	22,	1,	'挂面',	'挂面',	'挂面',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/598973afcff80.png',	0.00),
(71,	'驱虫气雾剂',	23,	11,	'',	0,	27,	1,	'驱虫气雾剂',	'驱虫气雾剂',	'驱虫气雾剂',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59897b8cc7b02.png',	0.00),
(72,	'驱蚊',	23,	11,	'',	0,	28,	1,	'驱蚊',	'驱蚊',	'驱蚊',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59897bd2828d4.png',	0.00),
(73,	'杀螨虫',	23,	11,	'',	0,	1,	1,	'杀螨虫',	'杀螨虫',	'杀螨虫',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59897c04435dd.png',	0.00),
(74,	'软包抽纸',	20,	11,	'',	0,	30,	1,	'软包抽纸',	'软包抽纸',	'软包抽纸',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/5989754886f93.png',	0.00),
(75,	'盒装抽纸',	20,	11,	'',	0,	31,	1,	'盒装抽纸',	'盒装抽纸',	'盒装抽纸',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59897676da746.png',	0.00),
(76,	'手帕纸',	20,	11,	'',	0,	32,	1,	'手帕纸',	'手帕纸',	'手帕纸',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/598976f71d13b.png',	0.00),
(77,	'湿巾',	20,	11,	'',	0,	33,	1,	'湿巾',	'湿巾',	'湿巾',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/5989775f25053.png',	0.00),
(78,	'卫生纸',	20,	11,	'',	0,	34,	1,	'卫生纸',	'卫生纸',	'卫生纸',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/598977da4c51a.png',	0.00),
(79,	'柔顺剂',	21,	11,	'',	0,	35,	1,	'柔顺剂',	'柔顺剂',	'柔顺剂',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/5989782f87421.png',	0.00),
(80,	'洗衣液',	21,	11,	'',	0,	36,	1,	'洗衣液',	'洗衣液',	'洗衣液',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/5989787663ed4.png',	0.00),
(81,	'洗衣粉',	21,	11,	'',	0,	37,	1,	'洗衣粉',	'洗衣粉',	'洗衣粉',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59897903ba8a5.png',	0.00),
(82,	'洗衣皂',	21,	11,	'',	0,	38,	1,	'洗衣皂',	'洗衣皂',	'洗衣皂',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/5989796e40062.png',	0.00),
(83,	'衣物柔顺剂',	22,	11,	'',	0,	39,	1,	'衣物柔顺剂',	'衣物柔顺剂',	'衣物柔顺剂',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/598979d7e762e.png',	0.00),
(84,	'衣物消毒液',	22,	11,	'',	0,	40,	1,	'衣物消毒液',	'衣物消毒液',	'衣物消毒液',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59897a318eddc.png',	0.00),
(85,	'衣物除菌液',	22,	11,	'',	0,	41,	1,	'衣物除菌液',	'衣物除菌液',	'衣物除菌液',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59897a6f83792.png',	0.00),
(86,	'漂白/彩漂',	22,	11,	'',	0,	42,	1,	'漂白/彩漂',	'漂白/彩漂',	'漂白/彩漂',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59897b02c0dad.png',	0.00),
(92,	'料理/榨汁机',	33,	19,	'',	0,	48,	1,	'料理/榨汁机',	'料理/榨汁机',	'料理/榨汁机',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59895ed2ab550.jpg',	0.00),
(93,	'豆浆机',	34,	19,	'',	0,	49,	1,	'豆浆机',	'豆浆机',	'豆浆机',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59895f13e3686.jpg',	0.00),
(94,	'剃须刀',	34,	19,	'',	0,	50,	1,	'剃须刀',	'剃须刀',	'剃须刀',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59895f61f2572.jpg',	0.00),
(95,	'剃/脱毛器',	38,	11,	'',	0,	51,	1,	'剃/脱毛器',	'剃/脱毛器',	'剃/脱毛器',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/598963ad5dd2b.png',	0.00),
(96,	'剃须刀',	31,	11,	'',	0,	52,	1,	'口腔护理',	'口腔护理',	'口腔护理',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59897e4ce00da.png',	0.00),
(97,	'CPU',	32,	19,	'',	0,	53,	1,	'CPU',	'CPU',	'CPU',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59897f20b2d32.png',	0.00),
(98,	'主板',	32,	19,	'',	0,	54,	1,	'主板',	'主板',	'主板',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59897f7882cf8.png',	0.00),
(99,	'手机通讯',	32,	20,	'',	0,	10,	1,	'手机',	'手机',	'手机',	'',	0,	0,	50.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/5989802501540.png',	0.00),
(100,	'显卡',	32,	19,	'',	0,	55,	1,	'显卡',	'显卡',	'显卡',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/598980a5a9abe.png',	0.00),
(101,	'初乳',	33,	10,	'',	0,	56,	0,	'初乳',	'初乳',	'初乳',	'',	0,	0,	0.00,	'',	'',	0.00),
(102,	'米粉/菜粉',	33,	10,	'',	0,	57,	0,	'米粉/菜粉',	'米粉/菜粉',	'米粉/菜粉',	'',	0,	0,	0.00,	'',	'',	0.00),
(103,	'果泥/果汁',	33,	10,	'',	0,	58,	0,	'果泥/果汁',	'果泥/果汁',	'果泥/果汁',	'',	0,	0,	0.00,	'',	'',	0.00),
(104,	'品牌尿裤',	34,	11,	'',	0,	59,	0,	'品牌尿裤',	'品牌尿裤',	'品牌尿裤',	'',	0,	0,	0.00,	'',	'',	0.00),
(105,	'裤型尿裤',	34,	11,	'',	0,	60,	0,	'裤型尿裤',	'裤型尿裤',	'裤型尿裤',	'',	0,	0,	0.00,	'',	'',	0.00),
(109,	'羽毛球',	38,	28,	'',	0,	64,	1,	'羽毛球',	'羽毛球',	'羽毛球',	'',	0,	5,	50.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/598982cba4bfb.png',	0.00),
(110,	'乒乓球',	38,	13,	'',	0,	65,	1,	'乒乓球',	'乒乓球',	'乒乓球',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/5989831b96062.png',	0.00),
(111,	'瑜伽垫',	37,	11,	'',	0,	66,	1,	'瑜伽垫',	'瑜伽垫',	'瑜伽垫',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/598981f3d7583.png',	0.00),
(112,	'瑜伽服',	37,	11,	'',	0,	67,	1,	'瑜伽服',	'瑜伽服',	'瑜伽服',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59898250d531d.png',	0.00),
(113,	'帐篷',	36,	13,	'',	0,	68,	1,	'帐篷',	'帐篷',	'帐篷',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59898106afbc7.png',	0.00),
(114,	'睡袋',	36,	13,	'',	0,	69,	1,	'睡袋',	'睡袋',	'睡袋',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/598981757ab23.png',	0.00),
(115,	'服装配饰',	0,	0,	'',	0,	3,	1,	'服装配饰',	'服装配饰',	'服装配饰',	'',	0,	0,	100.00,	'',	'',	10.00),
(116,	'女装',	115,	21,	'',	0,	70,	1,	'女装',	'女装',	'女装',	'',	0,	0,	0.00,	'',	'',	0.00),
(117,	'男装',	115,	22,	'',	0,	71,	1,	'男装',	'男装',	'男装',	'',	0,	4,	0.00,	'',	'',	0.00),
(118,	'运动',	115,	21,	'',	0,	72,	1,	'运动',	'运动',	'运动',	'',	0,	0,	0.00,	'',	'',	0.00),
(119,	'童装',	115,	21,	'',	0,	73,	1,	'童装',	'童装',	'童装',	'',	0,	0,	0.00,	'',	'',	0.00),
(120,	'手表',	115,	24,	'',	0,	74,	1,	'手表',	'手表',	'手表',	'',	0,	0,	0.00,	'',	'',	0.00),
(122,	'T恤',	116,	21,	'',	0,	76,	1,	'T恤',	'T恤',	'T恤',	'',	0,	2,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/598984e3f0da7.png',	0.00),
(123,	'衬衫',	116,	21,	'',	0,	77,	1,	'衬衫',	'衬衫',	'衬衫',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/5989855bd5802.png',	0.00),
(124,	'针织衫',	116,	21,	'',	0,	78,	1,	'针织衫',	'针织衫',	'针织衫',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/598985c6d0838.png',	0.00),
(125,	'雪纺衫',	116,	21,	'',	0,	79,	1,	'雪纺衫',	'雪纺衫',	'雪纺衫',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/598986265a9ce.png',	0.00),
(126,	'卫衣',	116,	21,	'',	0,	80,	1,	'卫衣',	'卫衣',	'卫衣',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/5989868b70ad4.png',	0.00),
(127,	'衬衫',	117,	22,	'',	0,	81,	1,	'衬衫',	'衬衫',	'衬衫',	'',	0,	4,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/598986f46000f.png',	0.00),
(128,	'POLO衫',	117,	22,	'',	0,	82,	1,	'POLO衫',	'POLO衫',	'POLO衫',	'',	0,	2,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/5989873a7dad7.png',	0.00),
(129,	'羊绒衫',	117,	22,	'',	0,	83,	1,	'羊绒衫',	'羊绒衫',	'羊绒衫',	'',	0,	3,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/598987c01aca6.png',	0.00),
(130,	'休闲鞋',	118,	21,	'',	0,	84,	1,	'休闲鞋',	'休闲鞋',	'休闲鞋',	'',	0,	3,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/5989884fd31eb.png',	0.00),
(131,	'套装',	118,	22,	'',	0,	85,	1,	'套装',	'套装',	'套装',	'',	0,	4,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/598988aad9a31.png',	0.00),
(132,	'运动裤',	118,	22,	'',	0,	86,	1,	'运动裤',	'运动裤',	'运动裤',	'',	0,	3,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/5989897041a21.png',	0.00),
(133,	'上衣',	119,	21,	'',	0,	87,	1,	'上衣',	'上衣',	'上衣',	'',	0,	5,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170809/598a5ce30ce1a.png',	0.00),
(134,	'裤子',	119,	22,	'',	0,	1,	1,	'裤子',	'裤子',	'裤子',	'',	0,	4,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170809/598a5de80ab7d.png',	0.00),
(135,	'裙子',	119,	21,	'',	0,	89,	1,	'裙子',	'裙子',	'裙子',	'',	0,	3,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170809/598a5e0d8cee0.png',	0.00),
(136,	'瑞士品牌',	120,	24,	'',	0,	90,	1,	'瑞士手表',	'瑞士手表',	'瑞士手表',	'',	0,	4,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170809/598a61ad67d73.png',	0.00),
(137,	'国产品牌',	120,	24,	'',	0,	91,	1,	'国产品牌',	'国产品牌',	'国产品牌',	'',	0,	5,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170809/598a61c2468ee.png',	0.00),
(138,	'时尚品牌',	120,	24,	'',	0,	92,	1,	'时尚品牌',	'时尚品牌',	'时尚品牌',	'',	0,	6,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170809/598a61e63a1e0.png',	0.00),
(145,	'移动电源',	99,	27,	'',	1,	10,	1,	'',	'',	'',	'',	0,	0,	0.00,	'',	'',	0.00),
(147,	'汽车服务',	0,	0,	'',	0,	10,	1,	'',	'',	'',	'',	0,	5,	0.00,	'',	'',	0.00),
(153,	'家居生活',	0,	0,	'',	0,	4,	1,	'',	'',	'',	'',	0,	0,	0.00,	'',	'',	1.00),
(154,	'餐具水具',	153,	0,	'',	0,	10,	1,	'',	'',	'',	'',	0,	0,	0.00,	'',	'',	1.00),
(155,	'厨具锅具',	153,	0,	'',	0,	10,	1,	'',	'',	'',	'',	0,	0,	0.00,	'',	'',	1.00),
(156,	'床上用品',	153,	0,	'',	0,	10,	1,	'',	'',	'',	'',	0,	0,	0.00,	'',	'',	1.00),
(157,	'家纺布艺',	153,	0,	'',	0,	10,	1,	'',	'',	'',	'',	0,	0,	0.00,	'',	'',	1.00),
(158,	'居家日用',	153,	0,	'',	0,	10,	1,	'',	'',	'',	'',	0,	0,	0.00,	'',	'',	1.00),
(160,	'收纳洗晒',	153,	0,	'',	0,	10,	1,	'',	'',	'',	'',	0,	0,	0.00,	'',	'',	1.00),
(161,	'宠物用品',	153,	0,	'',	0,	10,	1,	'',	'',	'',	'',	0,	0,	0.00,	'',	'',	1.00),
(162,	'家装建材',	153,	0,	'',	0,	10,	1,	'',	'',	'',	'',	0,	0,	0.00,	'',	'',	1.00),
(165,	'餐具',	154,	0,	'',	0,	10,	1,	'',	'',	'',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170809/598a79916875d.png',	1.00),
(166,	'水具',	154,	0,	'',	0,	10,	1,	'',	'',	'',	'',	0,	0,	0.00,	'',	'',	1.00),
(167,	'摄像机',	29,	0,	'',	0,	10,	1,	'',	'',	'',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59897c69b60a0.png',	1.00),
(168,	'照相机',	29,	0,	'',	0,	10,	1,	'',	'',	'',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59897cd2f158a.png',	1.00),
(169,	'微波炉',	30,	0,	'',	0,	10,	1,	'',	'',	'',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59897d41da0f0.png',	1.00),
(170,	'电饼铛',	30,	0,	'',	0,	10,	1,	'',	'',	'',	'',	0,	0,	0.00,	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59897dbf56979.png',	1.00);

DROP TABLE IF EXISTS `hanchao_goods_collect`;
CREATE TABLE `hanchao_goods_collect` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '收藏ID',
  `goods_id` int(10) unsigned NOT NULL COMMENT '商品ID',
  `integral_id` int(10) unsigned NOT NULL COMMENT '积分商品ID',
  `shop_id` int(10) unsigned NOT NULL COMMENT '店铺ID',
  `uid` int(10) unsigned NOT NULL COMMENT '会员ID',
  `addtime` int(11) NOT NULL COMMENT '收藏时间',
  `status` tinyint(1) NOT NULL COMMENT '状态',
  `type` tinyint(1) NOT NULL COMMENT '0普通商品1积分商品',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=233 DEFAULT CHARSET=utf8 COMMENT='商品收藏表';

INSERT INTO `hanchao_goods_collect` (`id`, `goods_id`, `integral_id`, `shop_id`, `uid`, `addtime`, `status`, `type`) VALUES
(1,	5,	0,	0,	20,	1492146927,	1,	0),
(14,	6,	0,	0,	27,	1492855734,	1,	0),
(18,	29,	0,	0,	27,	1492856418,	1,	0),
(23,	10,	0,	0,	32,	1493018883,	1,	0),
(51,	59,	0,	0,	51,	1493789276,	1,	0),
(66,	7,	1,	0,	51,	1493792183,	1,	1),
(68,	57,	0,	0,	51,	1493792294,	1,	0),
(78,	8,	0,	0,	1,	1493972971,	1,	0),
(91,	35,	0,	0,	29,	1494299524,	1,	0),
(92,	70,	0,	0,	5,	1494325703,	1,	0),
(93,	36,	0,	0,	29,	1494466302,	1,	0),
(94,	49,	0,	0,	66,	1494486982,	1,	0),
(95,	32,	0,	0,	66,	1494487177,	1,	0),
(101,	68,	0,	0,	73,	1494815005,	1,	0),
(102,	49,	0,	0,	73,	1494815147,	1,	0),
(104,	70,	0,	0,	73,	1494830447,	1,	0),
(105,	66,	0,	0,	73,	1494832411,	1,	0),
(106,	51,	0,	0,	73,	1494832936,	1,	0),
(107,	34,	0,	0,	73,	1494836748,	1,	0),
(108,	72,	0,	0,	73,	1494836835,	1,	0),
(109,	67,	0,	0,	73,	1494836878,	1,	0),
(110,	65,	0,	0,	73,	1494836888,	1,	0),
(111,	7,	0,	0,	73,	1494836899,	1,	0),
(112,	5,	0,	0,	73,	1494836905,	1,	0),
(113,	63,	0,	0,	73,	1494837337,	1,	0),
(114,	47,	0,	0,	73,	1494837343,	1,	0),
(115,	29,	0,	0,	73,	1494837347,	1,	0),
(116,	26,	0,	0,	73,	1494837352,	1,	0),
(117,	35,	0,	0,	73,	1494837363,	1,	0),
(118,	69,	0,	0,	73,	1494837368,	1,	0),
(119,	64,	0,	0,	73,	1494837373,	1,	0),
(120,	52,	0,	0,	73,	1494837377,	1,	0),
(121,	44,	0,	0,	73,	1494837408,	1,	0),
(122,	39,	0,	0,	73,	1494837494,	1,	0),
(123,	40,	0,	0,	73,	1494837727,	1,	0),
(125,	72,	0,	0,	74,	1494900037,	1,	0),
(126,	2,	0,	0,	73,	1494900532,	1,	0),
(127,	24,	0,	0,	73,	1494900534,	1,	0),
(129,	41,	0,	0,	73,	1494900540,	1,	0),
(131,	72,	0,	0,	75,	1494904526,	1,	0),
(133,	7,	1,	0,	73,	1495000148,	1,	1),
(135,	2,	0,	0,	27,	1495069149,	1,	0),
(136,	41,	0,	0,	27,	1495069188,	1,	0),
(137,	7,	1,	0,	29,	1495077914,	1,	1),
(138,	7,	1,	0,	67,	1495078297,	1,	1),
(140,	7,	1,	0,	10,	1495276868,	1,	1),
(146,	94,	0,	0,	24,	1499148399,	1,	0),
(148,	98,	0,	0,	24,	1499149362,	1,	0),
(154,	97,	0,	0,	24,	1499159634,	1,	0),
(169,	97,	0,	0,	67,	1499224371,	1,	0),
(171,	45,	0,	0,	24,	1499247273,	1,	0),
(172,	106,	0,	0,	73,	1499396280,	1,	0),
(174,	71,	0,	0,	73,	1499396360,	1,	0),
(175,	86,	0,	0,	73,	1499493651,	1,	0),
(177,	95,	0,	0,	73,	1499651152,	1,	0),
(189,	84,	0,	0,	78,	1499683450,	1,	0),
(191,	98,	0,	0,	89,	1499847324,	1,	0),
(192,	99,	0,	0,	89,	1499847332,	1,	0),
(193,	78,	6,	0,	73,	1499852588,	1,	1),
(194,	86,	0,	0,	89,	1500103489,	1,	0),
(196,	23,	0,	0,	73,	1500105299,	1,	0),
(197,	90,	0,	0,	89,	1500108517,	1,	0),
(204,	79,	0,	0,	110,	1500770151,	1,	0),
(206,	91,	0,	0,	99,	1501229900,	1,	0),
(207,	89,	0,	0,	99,	1501229905,	1,	0),
(209,	197,	0,	0,	140,	1502103855,	1,	0),
(210,	189,	0,	0,	134,	1502162683,	1,	0),
(213,	197,	0,	0,	142,	1502173598,	1,	0),
(214,	196,	0,	0,	142,	1502173638,	1,	0),
(215,	195,	0,	0,	142,	1502173659,	1,	0),
(216,	194,	0,	0,	142,	1502173666,	1,	0),
(217,	193,	0,	0,	142,	1502173673,	1,	0),
(218,	201,	0,	0,	144,	1502175185,	1,	0),
(219,	200,	0,	0,	144,	1502193554,	1,	0),
(220,	125,	0,	0,	132,	1502509832,	1,	0),
(221,	126,	0,	0,	132,	1502515612,	1,	0),
(222,	128,	0,	0,	147,	1502530409,	1,	0),
(223,	125,	0,	0,	148,	1502702745,	1,	0),
(224,	197,	0,	0,	153,	1503284345,	1,	0),
(225,	98,	0,	0,	153,	1503287353,	1,	0),
(227,	7,	0,	0,	142,	1503293856,	1,	0),
(228,	125,	0,	0,	153,	1503302976,	1,	0),
(229,	188,	0,	0,	24,	1503363496,	1,	0),
(232,	8,	0,	0,	154,	1504511065,	1,	0);

DROP TABLE IF EXISTS `hanchao_goods_content`;
CREATE TABLE `hanchao_goods_content` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `goods_id` int(10) NOT NULL COMMENT '商品id',
  `content` text NOT NULL COMMENT '商品详情',
  `seotitle` varchar(255) NOT NULL COMMENT 'seo题目 ',
  `seokeywords` varchar(255) NOT NULL COMMENT 'seo关键字 ',
  `seodescription` varchar(255) NOT NULL COMMENT 'seo描述 ',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=263 DEFAULT CHARSET=utf8 COMMENT='商品详情表';

INSERT INTO `hanchao_goods_content` (`id`, `goods_id`, `content`, `seotitle`, `seokeywords`, `seodescription`) VALUES
(1,	1,	'&lt;p style=&quot;color:#404040;font-family:tahoma, arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-size:36px;&quot;&gt;&lt;span style=&quot;font-weight:700;&quot;&gt;&lt;span style=&quot;color:#FF0000;&quot;&gt;&lt;img align=&quot;absmiddle&quot; src=&quot;https://img.alicdn.com/imgextra/i4/1642619502/TB2FA.EiElnpuFjSZFjXXXTaVXa_!!1642619502.jpg&quot; class=&quot;img-ks-lazyload&quot; /&gt;&lt;img align=&quot;absmiddle&quot; src=&quot;https://img.alicdn.com/imgextra/i2/1642619502/TB23QEtirJmpuFjSZFwXXaE4VXa_!!1642619502.jpg&quot; class=&quot;img-ks-lazyload&quot; /&gt;&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#404040;font-family:tahoma, arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;img align=&quot;absmiddle&quot; src=&quot;https://img.alicdn.com/imgextra/i1/1642619502/TB2OPSciYxmpuFjSZJiXXXauVXa_!!1642619502.jpg&quot; class=&quot;img-ks-lazyload&quot; /&gt;&lt;img align=&quot;absmiddle&quot; src=&quot;https://img.alicdn.com/imgextra/i1/1642619502/TB2Ptx8hl0lpuFjSszdXXcdxFXa_!!1642619502.jpg&quot; class=&quot;img-ks-lazyload&quot; /&gt;&lt;img align=&quot;absmiddle&quot; src=&quot;https://img.alicdn.com/imgextra/i2/1642619502/TB2z6dXltBopuFjSZPcXXc9EpXa_!!1642619502.jpg&quot; class=&quot;img-ks-lazyload&quot; /&gt;&lt;img align=&quot;absmiddle&quot; src=&quot;https://img.alicdn.com/imgextra/i4/1642619502/TB2wNJWjYBmpuFjSZFAXXaQ0pXa_!!1642619502.jpg&quot; class=&quot;img-ks-lazyload&quot; /&gt;&lt;img align=&quot;absmiddle&quot; src=&quot;https://img.alicdn.com/imgextra/i4/1642619502/TB235mDjbRkpuFjSspmXXc.9XXa_!!1642619502.jpg&quot; class=&quot;img-ks-lazyload&quot; /&gt;&lt;img align=&quot;absmiddle&quot; src=&quot;https://img.alicdn.com/imgextra/i4/1642619502/TB2.9evhl8kpuFjSspeXXc7IpXa_!!1642619502.jpg&quot; class=&quot;img-ks-lazyload&quot; /&gt;&lt;img align=&quot;absmiddle&quot; src=&quot;https://img.alicdn.com/imgextra/i2/1642619502/TB2SxOthChlpuFjSspkXXa1ApXa_!!1642619502.jpg&quot; class=&quot;img-ks-lazyload&quot; /&gt;&lt;img align=&quot;absmiddle&quot; src=&quot;https://img.alicdn.com/imgextra/i4/1642619502/TB2rGuOhrtlpuFjSspoXXbcDpXa_!!1642619502.jpg&quot; class=&quot;img-ks-lazyload&quot; /&gt;&lt;img align=&quot;absmiddle&quot; src=&quot;https://img.alicdn.com/imgextra/i2/1642619502/TB250vCdncCL1FjSZFPXXXZgpXa_!!1642619502.jpg&quot; class=&quot;img-ks-lazyload&quot; /&gt;\r\n	&lt;p style=&quot;color:#404040;font-family:tahoma, arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;&quot;&gt;\r\n		&lt;img align=&quot;absmiddle&quot; src=&quot;https://img.alicdn.com/imgextra/i4/1642619502/TB2nBqrhrBkpuFjy1zkXXbSpFXa_!!1642619502.jpg&quot; class=&quot;img-ks-lazyload&quot; /&gt;&lt;img align=&quot;absmiddle&quot; src=&quot;https://img.alicdn.com/imgextra/i3/1642619502/TB2doiCjhtmpuFjSZFqXXbHFpXa_!!1642619502.jpg&quot; class=&quot;img-ks-lazyload&quot; /&gt;&lt;img align=&quot;absmiddle&quot; src=&quot;https://img.alicdn.com/imgextra/i4/1642619502/TB2uR2Mi.hnpuFjSZFEXXX0PFXa_!!1642619502.jpg&quot; class=&quot;img-ks-lazyload&quot; /&gt;\r\n	&lt;/p&gt;\r\n	&lt;p style=&quot;color:#404040;font-family:tahoma, arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;&quot;&gt;\r\n		&amp;nbsp;\r\n	&lt;/p&gt;\r\n&lt;/p&gt;',	'茶叶',	'一级红茶散装',	'一级红茶散装'),
(2,	2,	'&lt;div&gt;\r\n	&lt;img alt=&quot;华为 HUAWEI P10 4G智能手机&quot; src=&quot;https://img30.360buyimg.com/sku/jfs/t4693/110/2578671444/275243/369d6b04/58f079faNc080d45a.jpg&quot; /&gt; \r\n&lt;/div&gt;\r\n&lt;div&gt;\r\n	&lt;img alt=&quot;华为 HUAWEI P10 4G智能手机&quot; src=&quot;https://img30.360buyimg.com/sku/jfs/t4483/58/2562000796/256506/a6003e3a/58f079faN8bb7fdec.jpg&quot; /&gt; \r\n&lt;/div&gt;\r\n&lt;div&gt;\r\n	&lt;img alt=&quot;华为 HUAWEI P10 4G智能手机&quot; src=&quot;https://img30.360buyimg.com/sku/jfs/t4543/135/2561634921/258718/e4727bbc/58f079faN7581428d.jpg&quot; /&gt; \r\n&lt;/div&gt;\r\n&lt;div&gt;\r\n	&lt;img alt=&quot;华为 HUAWEI P10 4G智能手机&quot; src=&quot;https://img30.360buyimg.com/sku/jfs/t4471/214/2507475582/93163/4263f28b/58f07af9N80397632.jpg&quot; /&gt; \r\n&lt;/div&gt;\r\n&lt;div&gt;\r\n	&lt;img alt=&quot;华为 HUAWEI P10 4G智能手机&quot; src=&quot;https://img30.360buyimg.com/sku/jfs/t4756/268/1386220277/71104/3402cc39/58f07b4eN28917bb4.jpg&quot; /&gt; \r\n&lt;/div&gt;\r\n&lt;div&gt;\r\n	&lt;img alt=&quot;华为 HUAWEI P10 4G智能手机&quot; src=&quot;https://img30.360buyimg.com/sku/jfs/t4702/149/2525351088/82734/9242d465/58f07bb3N49266b89.jpg&quot; /&gt; \r\n&lt;/div&gt;\r\n&lt;div&gt;\r\n	&lt;img alt=&quot;华为 HUAWEI P10 4G智能手机&quot; src=&quot;https://img30.360buyimg.com/sku/jfs/t4447/187/2586127555/181541/87eb33b5/58f079faN329288fe.jpg&quot; /&gt; \r\n&lt;/div&gt;\r\n&lt;div&gt;\r\n	&lt;img alt=&quot;华为 HUAWEI P10 4G智能手机&quot; src=&quot;https://img30.360buyimg.com/sku/jfs/t5029/364/1436863082/272435/6202894b/58f079faN1616941f.jpg&quot; /&gt; \r\n&lt;/div&gt;\r\n&lt;br /&gt;',	'华为p10',	'华为p10',	'华为p10'),
(3,	3,	'&lt;div align=&quot;center&quot;&gt;\r\n	&lt;img alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t2800/138/1947363022/123109/3c73a67c/5750e00fNb8c11cf3.jpg&quot; width=&quot;750&quot; height=&quot;200&quot; border=&quot;0&quot; /&gt;&lt;img alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t2731/23/2759527006/316568/7ff771e/577325c2N21181cd3.jpg&quot; width=&quot;750&quot; height=&quot;500&quot; border=&quot;0&quot; /&gt;&lt;br /&gt;\r\n&lt;/div&gt;\r\n&lt;div class=&quot;ssd-module-wrap&quot; align=&quot;center&quot;&gt;\r\n	&lt;div class=&quot;ssd-module M14697617684071&quot;&gt;\r\n		&lt;div class=&quot;ssd-widget-pic W146978752476030&quot;&gt;\r\n			&lt;img alt=&quot;【京东超市】净安（Cleafe）洗衣机槽清洗剂300g/盒滚筒波轮洗衣机清洁剂-京东&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/sku/jfs/t3763/188/752863475/372554/3a4906f2/5812c19eNd4fac5a2.jpg&quot; /&gt; \r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W14776243143791&quot;&gt;\r\n			净安家电清洁系列\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W14776244411063&quot;&gt;\r\n			剥离机槽污垢&amp;nbsp;防止衣物二次污染\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W14776245746644&quot;&gt;\r\n			洗衣机槽清洁剂300g/盒\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W14776246200505&quot;&gt;\r\n			滚筒式\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W14776246596896&quot;&gt;\r\n			涡轮式\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W14776247907767&quot;&gt;\r\n			各类洗衣机槽清洁\r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;ssd-module M14697749474464&quot;&gt;\r\n		&lt;div class=&quot;ssd-widget-pic W14776248891528&quot;&gt;\r\n			&lt;img alt=&quot;【京东超市】净安（Cleafe）洗衣机槽清洗剂300g/盒滚筒波轮洗衣机清洁剂-京东&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/sku/jfs/t3313/229/716690180/517721/345525e7/5812c44bNf2a864c2.png&quot; /&gt; \r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W147762500924310&quot;&gt;\r\n			机槽污垢造成的二次污染\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W147762505279311&quot;&gt;\r\n			真的很脏\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W147762510152112&quot;&gt;\r\n			你还敢用吗？\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W147762522312913&quot;&gt;\r\n			洗衣机槽污垢多多&amp;nbsp;&amp;nbsp;&lt;br /&gt;\r\n附着在内壁\r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;ssd-module M146977643661722&quot;&gt;\r\n		&lt;div class=&quot;ssd-widget-pic W147762539637714&quot;&gt;\r\n			&lt;img alt=&quot;【京东超市】净安（Cleafe）洗衣机槽清洗剂300g/盒滚筒波轮洗衣机清洁剂-京东&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/sku/jfs/t3844/139/493273865/934649/6838e2b6/5812c65cN45fbe790.png&quot; /&gt; \r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W147763424982415&quot;&gt;\r\n			净安洗衣机清洁剂\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W147763429723716&quot;&gt;\r\n			防止衣物二次污染！\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W147763439392417&quot;&gt;\r\n			有效剥离机槽污垢\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W147763571451218&quot;&gt;\r\n			藏污纳垢，健康隐患！\r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;ssd-module M14767716700532&quot;&gt;\r\n		&lt;div class=&quot;ssd-widget-pic W147763578686919&quot;&gt;\r\n			&lt;img alt=&quot;【京东超市】净安（Cleafe）洗衣机槽清洗剂300g/盒滚筒波轮洗衣机清洁剂-京东&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/sku/jfs/t3790/271/756686191/1066092/7ffe231a/5812ef16N0ea30dfd.png&quot; /&gt; \r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W147763600490220&quot;&gt;\r\n			1、将本品直接倒入洗衣机筒内，塑袋开封后，请一次全用完。\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W147763613010621&quot;&gt;\r\n			2、注入清水后，运转5分钟，然后关闭电源，浸泡1小时。\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W147763691105622&quot;&gt;\r\n			3、打开电源，按日常洗涤标准模式（洗涤-漂洗-脱水）清洗一遍。\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W147763704080523&quot;&gt;\r\n			4、使用干毛巾擦干洗衣机内筒，如筒壁上有残留碎片，属于正常现象。\r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;ssd-module M146977833439363&quot;&gt;\r\n		&lt;div class=&quot;ssd-widget-pic W147763712592624&quot;&gt;\r\n			&lt;img alt=&quot;【京东超市】净安（Cleafe）洗衣机槽清洗剂300g/盒滚筒波轮洗衣机清洁剂-京东&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/sku/jfs/t3508/286/722535435/842171/83ffbf22/5812f433N8c904325.png&quot; /&gt; \r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W147763731018525&quot;&gt;\r\n			1、将本品直接倒入洗衣机筒内，塑袋开封后，请一次全用完。\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W147763749526726&quot;&gt;\r\n			2、注入清水后运转5分钟，然后按下“暂停”键，浸泡1小时。\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W147763756784727&quot;&gt;\r\n			3、打开电源，按日常洗涤标准模式（洗涤-漂洗-脱水）清洗一遍。\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W147763762736028&quot;&gt;\r\n			4、使用干毛巾擦干洗衣机内筒，如筒壁上有残留碎片，属于正常现象。\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W147763775246329&quot;&gt;\r\n			干净的洗衣机槽\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W147763779896130&quot;&gt;\r\n			才能洗出干净的衣物\r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;ssd-module M14767719457013&quot;&gt;\r\n		&lt;div class=&quot;ssd-widget-pic W14767719457013I7&quot;&gt;\r\n			&lt;img alt=&quot;【京东超市】净安（Cleafe）洗衣机槽清洗剂300g/盒滚筒波轮洗衣机清洁剂-京东&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/sku/jfs/t3748/273/780880236/122892/323cdfc/5812f700Na38454be.jpg&quot; /&gt; \r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W147763793643331&quot;&gt;\r\n			Cleafe/净安\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W147763798073032&quot;&gt;\r\n			洗衣机槽清洁剂（原味）\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W147763803590933&quot;&gt;\r\n			各类洗衣机槽清洁\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W147763807190834&quot;&gt;\r\n			300g/盒&amp;nbsp;\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W147763811209535&quot;&gt;\r\n			36个月\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W147763814565736&quot;&gt;\r\n			见瓶底\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W147763817270637&quot;&gt;\r\n			放于阴凉干燥处，儿童不易接触处\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W147763819943238&quot;&gt;\r\n			品牌名称\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W147763823738239&quot;&gt;\r\n			产品名称\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W147763827292840&quot;&gt;\r\n			适用范围&amp;nbsp;\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W147763831876741&quot;&gt;\r\n			商品规格\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W147763836054342&quot;&gt;\r\n			保质期限\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W147763839877543&quot;&gt;\r\n			生产日期\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;ssd-widget-text W147763845291244&quot;&gt;\r\n			储存方法\r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;ssd-module M146977870406867&quot;&gt;\r\n		&lt;div class=&quot;ssd-widget-pic W146978265211487&quot;&gt;\r\n			&lt;img alt=&quot;【京东超市】净安（Cleafe）洗衣机槽清洗剂300g/盒滚筒波轮洗衣机清洁剂-京东&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/sku/jfs/t3802/43/758163048/1180009/85e7f5e6/5812f96aN8495f865.png&quot; /&gt; \r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;ssd-module M146978316594293&quot;&gt;\r\n		&lt;div class=&quot;ssd-widget-pic W146978367438198&quot;&gt;\r\n			&lt;img alt=&quot;【京东超市】净安（Cleafe）洗衣机槽清洗剂300g/盒滚筒波轮洗衣机清洁剂-京东&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/sku/jfs/t3754/361/645853158/919490/8043c1e3/5812f9a8N08082b6b.png&quot; /&gt; \r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(4,	4,	'&lt;p class=&quot;more-par&quot;&gt;\r\n	&lt;a href=&quot;https://item.jd.com/1119016.html?jd_pop=21306223-353c-4dd8-b012-3ab6bd8db0de&amp;amp;abt=0#product-detail&quot; class=&quot;J-more-param&quot;&gt;更多参数&lt;s class=&quot;txt-arr&quot;&gt;&amp;gt;&amp;gt;&lt;/s&gt;&lt;/a&gt; \r\n&lt;/p&gt;\r\n&lt;div id=&quot;activity_header&quot;&gt;\r\n	&lt;img alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t2800/138/1947363022/123109/3c73a67c/5750e00fNb8c11cf3.jpg&quot; width=&quot;750&quot; height=&quot;200&quot; border=&quot;0&quot; /&gt;&lt;img alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t2731/23/2759527006/316568/7ff771e/577325c2N21181cd3.jpg&quot; width=&quot;750&quot; height=&quot;500&quot; border=&quot;0&quot; /&gt; \r\n&lt;/div&gt;\r\n&lt;div class=&quot;content_tpl&quot;&gt;\r\n	&lt;div class=&quot;formwork&quot;&gt;\r\n		&lt;div class=&quot;formwork_img&quot;&gt;\r\n			&lt;img class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t2842/82/2353139872/340979/254db7d0/57627670Nf770f75e.jpg&quot; /&gt; \r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;formwork_bt&quot; id=&quot;detail-tag-id-1&quot;&gt;\r\n		&lt;div class=&quot;formwork_bt_rb&quot;&gt;\r\n			&lt;span&gt;产品功能&lt;/span&gt; &lt;span class=&quot;s2&quot;&gt;Product Function&lt;/span&gt; \r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;formwork&quot;&gt;\r\n		&lt;div class=&quot;formwork_img&quot;&gt;\r\n			&lt;img class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t2638/36/2362234337/390452/57341eff/57627773Nd5b8ebf5.jpg&quot; /&gt; \r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;formwork&quot;&gt;\r\n		&lt;div class=&quot;formwork_img&quot;&gt;\r\n			&lt;img class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t2773/82/2388082275/134593/d3be26fd/5762777fN3641a783.jpg&quot; /&gt; \r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;formwork_bt&quot; id=&quot;detail-tag-id-4&quot;&gt;\r\n		&lt;div class=&quot;formwork_bt_rb&quot;&gt;\r\n			&lt;span&gt;使用说明&lt;/span&gt; &lt;span class=&quot;s2&quot;&gt;Instructions&lt;/span&gt; \r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;formwork&quot;&gt;\r\n		&lt;div class=&quot;formwork_img&quot;&gt;\r\n			&lt;img class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t2782/202/2305959970/259030/875e41/5762778eNc424923e.jpg&quot; /&gt; \r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;formwork_bt&quot; id=&quot;detail-tag-id-6&quot;&gt;\r\n		&lt;div class=&quot;formwork_bt_rb&quot;&gt;\r\n			&lt;span&gt;产品信息&lt;/span&gt; &lt;span class=&quot;s2&quot;&gt;Product Information&lt;/span&gt; \r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;formwork&quot;&gt;\r\n		&lt;div class=&quot;formwork_img&quot;&gt;\r\n			&lt;img class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t2953/347/648592156/144398/ff56da7f/5762779fN006c4e6a.jpg&quot; /&gt; \r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;formwork&quot;&gt;\r\n		&lt;div class=&quot;formwork_img&quot;&gt;\r\n			&lt;img class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t2722/224/2386845096/175741/6ef7b702/576277aeN4468591b.jpg&quot; /&gt; \r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;formwork&quot;&gt;\r\n		&lt;div class=&quot;formwork_img&quot;&gt;\r\n			&lt;img class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t2986/175/656458502/152307/1ad088a1/576277b7N7d99aaf1.jpg&quot; /&gt; \r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;formwork_bt&quot; id=&quot;detail-tag-id-10&quot;&gt;\r\n		&lt;div class=&quot;formwork_bt_rb&quot;&gt;\r\n			&lt;span&gt;品牌介绍&lt;/span&gt; &lt;span class=&quot;s2&quot;&gt;Brand Introduction&lt;/span&gt; \r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;formwork&quot;&gt;\r\n		&lt;div class=&quot;formwork_img&quot;&gt;\r\n			&lt;img class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t2677/87/2391126454/304964/1d22add0/576277c7N1b894f8d.jpg&quot; /&gt; \r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n&lt;/div&gt;\r\n&lt;div align=&quot;center&quot;&gt;\r\n	&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(5,	5,	'&lt;div style=&quot;margin:0 auto;&quot; align=&quot;center&quot;&gt;\r\n	&lt;img class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t2116/175/2230631080/125264/f729421c/56b026afN53910e38.jpg&quot; /&gt; &lt;img class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t2170/150/2176866124/84333/67039ff8/56b026beN067d400d.jpg&quot; /&gt; &lt;img class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t2653/113/1846394611/253912/d4a760c7/574c74daN8407e125.jpg&quot; /&gt; &lt;img class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t2701/8/1820812067/148037/225e7f77/574c74ecN4cd226d9.jpg&quot; /&gt; &lt;img class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t2194/154/1522244710/55977/c60de25e/56b026e2Ne36240c2.jpg&quot; /&gt; &lt;img class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t2317/30/2123812050/85670/986b6278/56b026ebNe9bf3743.jpg&quot; /&gt; &lt;img class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t1942/257/2077620725/113257/384a2cf1/56b026f4Nac91f0c2.jpg&quot; /&gt; &lt;img class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t2545/52/1309275075/79292/6c8a96b4/56b026fcNc60d41fc.jpg&quot; /&gt; &lt;img class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t2434/335/1521949012/83066/e6bdd91b/56b02706Nb9476fbc.jpg&quot; /&gt; &lt;img class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t2212/155/2257052199/52305/f289fd7c/56b0270dNa722d259.jpg&quot; /&gt; &lt;img class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t2380/276/2153549209/46027/350a6402/56b02715N5356897f.jpg&quot; /&gt; &lt;img class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t2302/141/1432938092/78903/1ad824c9/56b02721N52c67df0.jpg&quot; /&gt; &lt;img class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t2038/304/2159153157/108816/89bebf16/56b0272bNfe1b1792.jpg&quot; /&gt; &lt;img class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t1858/309/1553690818/64855/4a74d39e/56b02733N9f3993a1.jpg&quot; /&gt; &lt;img class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t2521/56/1312905269/89936/b814793f/56b0273cNc5f6dc84.jpg&quot; /&gt; &lt;img class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t2608/159/1894240602/328981/6d14cd95/574c50baNc8be28ea.jpg&quot; /&gt; &lt;img class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t1900/348/2197024809/82743/b61729f1/56b0274cNc1108d4d.jpg&quot; /&gt; \r\n&lt;/div&gt;',	'',	'',	''),
(6,	6,	'&lt;span style=&quot;font-size:x-large;color:#ff0000;&quot;&gt;&lt;strong&gt;购买说明：铁质捕鼠夹 尺寸是 &amp;nbsp;17厘米*9厘米。质量好 价格优！是理想的捕鼠产品！&lt;/strong&gt;&lt;/span&gt; &lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;b8787b97aade482690ba279c51b5b107&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t2674/222/468867573/159277/2b896041/5714aab5N7c311244.jpg&quot; /&gt; &lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;3f430b4605e743d9be360e57e7a3f359&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t2338/111/2697628049/58395/ab3e06af/5714aab6N5e8a8b85.jpg&quot; /&gt; &lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;20c9d8dfce184676a4a69f46cb91ba54&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t2482/93/2753538628/231939/d0f0ce74/5714aab7N2493657c.jpg&quot; /&gt; &lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;9403c443280b44b0b6a34f1a97010bc2&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t2836/127/451531281/83583/dc28ad78/5714aab7Nf4acc2e4.jpg&quot; /&gt; &lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;3466989fb8b848b796371fd720954a12&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t2431/215/2705605780/133319/521f2a2b/5714aab7N1d6f7970.jpg&quot; /&gt; &lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;21cf35eac85e4943a84af2326550cebd&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t1906/132/2649563397/54546/17fbcd3e/5714aab8N3a8b16e9.jpg&quot; /&gt; &lt;br /&gt;\r\n&amp;nbsp;&amp;nbsp; &lt;br /&gt;\r\n&amp;nbsp;&amp;nbsp; &lt;br /&gt;\r\n&amp;nbsp;&amp;nbsp; &lt;br /&gt;\r\n&lt;br /&gt;\r\n&lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;c7dba57b9b574436b68b304f36d90342&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t2107/127/954318257/142478/302d84b8/5635a4d4Ndfd57c82.jpg&quot; /&gt; &lt;br /&gt;\r\n&lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;32f4b98256c74869b305340f09ab6d4c&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t2350/88/910536266/64496/a5a5e019/5635a4d5N5b6843dd.jpg&quot; /&gt; &lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;19aa4da86b5e4906aa853614d61eadf4&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t2059/136/936507659/127579/12803cfb/5635a4d5Nb293e506.jpg&quot; /&gt; &lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;23456a6a105347dbba0aa298d1fb8253&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t1870/119/950103443/68957/b18722dd/5635a4e0N363a6f91.jpg&quot; /&gt; &lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;2e659174452a46eaa291dd9cae5a9168&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t1882/123/913589168/113759/38cf32b0/5635a4e0N49fd99c1.jpg&quot; /&gt; &lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;3cdf931477674d6eb4eb2c1df9ecee04&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t2437/119/930954171/195243/e5dce9c/5635a4e0Na8f772f6.jpg&quot; /&gt; &lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;4a0541789cf64a548cfe4952614a8db1&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t2260/164/942014874/62748/d8985fb4/5635a4e1N6ab51cd2.jpg&quot; /&gt; &lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;d140f1a9ab904b0ca3b78055581e3dfc&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t2359/109/959297107/86502/90b3b231/5635a4e1N7192c81c.jpg&quot; /&gt; &lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;4d21ec069bdd4cedbab0b7f5671f76fc&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t2515/33/58381819/34387/83702d01/5635a4e2N171f32e4.jpg&quot; /&gt; &lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;b1fa24e41e4e4652b187e53af8e4a40e&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t2263/183/930089551/79604/404b49ae/5635a4e2N83e7880a.jpg&quot; /&gt; &lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;ac8204ba102e4457bd6d4b8f1618d7df&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t2548/32/69285038/63468/408f1b4a/5635a4e2N9c632b1d.jpg&quot; /&gt; &lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;b5ca95c6d641427093480a364e1bffed&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t2542/122/64702199/530807/b35703a3/5635a553Nc79e3023.gif&quot; /&gt; &lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;bb7cee610ad94d059a0eea5c013e533f&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t2542/30/54003697/45130/fe193162/5635a4e2N4a646ec9.jpg&quot; /&gt; &lt;br /&gt;\r\n&lt;br /&gt;\r\n&lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;587f80405bfc4fc78161d2f54142278f&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t2314/111/939323519/201838/b66bc294/5635a4e3Nd13f21e0.jpg&quot; /&gt;',	'',	'',	''),
(7,	7,	'&lt;div class=&quot;tb-validity&quot;&gt;\r\n	&lt;br /&gt;\r\n&lt;/div&gt;\r\n&lt;div id=&quot;mall-banner&quot;&gt;\r\n	&lt;div&gt;\r\n	&lt;/div&gt;\r\n	&lt;div id=&quot;J_DescTMS1&quot;&gt;\r\n	&lt;/div&gt;\r\n&lt;/div&gt;\r\n&lt;div id=&quot;J_DcTopRightWrap&quot;&gt;\r\n&lt;/div&gt;\r\n&lt;div class=&quot;content ke-post&quot;&gt;\r\n	&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2899519374/TB2wfJAl00opuFjSZFxXXaDNVXa_%21%212899519374.jpg&quot; class=&quot;img-ks-lazyload&quot; align=&quot;absmiddle&quot; height=&quot;956&quot; width=&quot;790&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2899519374/TB2HKi2j9hlpuFjSspkXXa1ApXa_%21%212899519374.jpg&quot; class=&quot;img-ks-lazyload&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2899519374/TB29qJol4BmpuFjSZFsXXcXpFXa_%21%212899519374.jpg&quot; class=&quot;img-ks-lazyload&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2899519374/TB2ncDxjYRkpuFjSspmXXc.9XXa_%21%212899519374.jpg&quot; class=&quot;img-ks-lazyload&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2899519374/TB2R6v8j3xlpuFjy0FoXXa.lXXa_%21%212899519374.jpg&quot; class=&quot;img-ks-lazyload&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2899519374/TB2HQ_CjY8kpuFjy0FcXXaUhpXa_%21%212899519374.jpg&quot; class=&quot;img-ks-lazyload&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2899519374/TB2x5pBl.hnpuFjSZFEXXX0PFXa_%21%212899519374.jpg&quot; class=&quot;img-ks-lazyload&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2899519374/TB2YKncj3xlpuFjSszgXXcJdpXa_%21%212899519374.jpg&quot; class=&quot;img-ks-lazyload&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2899519374/TB2nQZ1lNtmpuFjSZFqXXbHFpXa_%21%212899519374.jpg&quot; class=&quot;img-ks-lazyload&quot; align=&quot;absmiddle&quot; /&gt;&lt;img class=&quot;desc_anchor img-ks-lazyload&quot; id=&quot;desc-module-2&quot; src=&quot;https://assets.alicdn.com/kissy/1.0.0/build/imglazyload/spaceball.gif&quot; /&gt; \r\n	&lt;p&gt;\r\n		&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2899519374/TB2dQ03c4xmpuFjSZFNXXXrRXXa_%21%212899519374.jpg&quot; class=&quot;img-ks-lazyload&quot; align=&quot;absmiddle&quot; /&gt; \r\n	&lt;/p&gt;\r\n&lt;img class=&quot;desc_anchor img-ks-lazyload&quot; id=&quot;desc-module-3&quot; src=&quot;https://assets.alicdn.com/kissy/1.0.0/build/imglazyload/spaceball.gif&quot; /&gt; \r\n	&lt;p&gt;\r\n		&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2899519374/TB2l885cYJmpuFjSZFBXXXaZXXa_%21%212899519374.jpg&quot; class=&quot;img-ks-lazyload&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2899519374/TB2Rbh6c4BmpuFjSZFDXXXD8pXa_%21%212899519374.jpg&quot; class=&quot;img-ks-lazyload&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2899519374/TB2yu3qcmBjpuFjSsplXXa5MVXa_%21%212899519374.jpg&quot; class=&quot;img-ks-lazyload&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2899519374/TB2jlIncbBkpuFjy1zkXXbSpFXa_%21%212899519374.jpg&quot; class=&quot;img-ks-lazyload&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2899519374/TB2HPZocg0kpuFjSspdXXX4YXXa_%21%212899519374.jpg&quot; class=&quot;img-ks-lazyload&quot; align=&quot;absmiddle&quot; /&gt; \r\n	&lt;/p&gt;\r\n&lt;/div&gt;\r\n&lt;br /&gt;',	'',	'',	''),
(8,	8,	'&lt;br /&gt;\r\n&lt;div id=&quot;J_DcTopRight&quot; class=&quot;J_DcAsyn tb-shop&quot;&gt;\r\n	&lt;div class=&quot;J_TModule&quot; id=&quot;shop15711457424&quot;&gt;\r\n		&lt;div class=&quot;skin-box tb-module tshop-pbsm tshop-pbsm-shop-self-defined&quot;&gt;\r\n			&lt;div class=&quot;skin-box-bd clear-fix&quot;&gt;\r\n				&lt;span&gt;&lt;a href=&quot;https://zhenwei.tmall.com/p/rd299287.htm?spm=a1z10.1-b.w5001-14582462334.6.QUUdrH&amp;amp;scene=taobao_shop&quot; target=&quot;_blank&quot;&gt;&lt;img src=&quot;https://gdp.alicdn.com/imgextra/i3/1699225083/TB23ddEb5pnpuFjSZFIXXXh2VXa_%21%211699225083.jpg&quot; alt=&quot;&quot; class=&quot;img-ks-lazyload&quot; height=&quot;276&quot; width=&quot;790&quot; /&gt;&lt;/a&gt; &lt;/span&gt; \r\n			&lt;/div&gt;\r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n&lt;/div&gt;\r\n&lt;img class=&quot;desc_anchor img-ks-lazyload&quot; id=&quot;desc-module-1&quot; src=&quot;https://assets.alicdn.com/kissy/1.0.0/build/imglazyload/spaceball.gif&quot; /&gt; \r\n&lt;p&gt;\r\n	&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/1699225083/TB2cjqvXYBmpuFjSZFuXXaG_XXa_%21%211699225083.jpg&quot; class=&quot;img-ks-lazyload&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/1699225083/TB2nC5emUhnpuFjSZFEXXX0PFXa_%21%211699225083.jpg&quot; class=&quot;img-ks-lazyload&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/1699225083/TB2XVEsXR0kpuFjy1XaXXaFkVXa_%21%211699225083.jpg&quot; class=&quot;img-ks-lazyload&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/1699225083/TB2SW5vX0XnpuFjSZFoXXXLcpXa_%21%211699225083.jpg&quot; class=&quot;img-ks-lazyload&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/1699225083/TB2YwZqXNXlpuFjSsphXXbJOXXa_%21%211699225083.jpg&quot; class=&quot;img-ks-lazyload&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/1699225083/TB2z0muX4xmpuFjSZFNXXXrRXXa_%21%211699225083.jpg&quot; class=&quot;img-ks-lazyload&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/1699225083/TB27SspXNdkpuFjy0FbXXaNnpXa_%21%211699225083.jpg&quot; class=&quot;img-ks-lazyload&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/1699225083/TB22eevX98mpuFjSZFMXXaxpVXa_%21%211699225083.jpg&quot; class=&quot;img-ks-lazyload&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/1699225083/TB2ec7pXM0kpuFjSspdXXX4YXXa_%21%211699225083.jpg&quot; class=&quot;img-ks-lazyload&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/1699225083/TB2jncqXHtlpuFjSspfXXXLUpXa_%21%211699225083.jpg&quot; class=&quot;img-ks-lazyload&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/1699225083/TB2zM7qXNXlpuFjSsphXXbJOXXa_%21%211699225083.jpg&quot; class=&quot;img-ks-lazyload&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/1699225083/TB2_HssXHRkpuFjSspmXXc.9XXa_%21%211699225083.jpg&quot; class=&quot;img-ks-lazyload&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/1699225083/TB2N9ApXNdkpuFjy0FbXXaNnpXa_%21%211699225083.jpg&quot; class=&quot;img-ks-lazyload&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/1699225083/TB2QZ.pXM0kpuFjSspdXXX4YXXa_%21%211699225083.jpg&quot; class=&quot;img-ks-lazyload&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/1699225083/TB2uPcqXHFlpuFjy0FgXXbRBVXa_%21%211699225083.jpg&quot; class=&quot;img-ks-lazyload&quot; align=&quot;absmiddle&quot; /&gt; \r\n&lt;/p&gt;',	'',	'',	''),
(9,	9,	'&lt;img alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t4456/38/1337556943/1156981/c32b0426/58dce136N81d37179.jpg&quot; /&gt;',	'',	'',	''),
(10,	10,	'&lt;p&gt;\r\n	&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2547621781/TB2u0zbhNXkpuFjy0FiXXbUfFXa_%21%212547621781.jpg&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2547621781/TB2kVpVd_cCL1FjSZFPXXXZgpXa_%21%212547621781.jpg&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2547621781/TB2ZVDchStkpuFjy0FhXXXQzFXa_%21%212547621781.jpg&quot; class=&quot;&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2547621781/TB2sO1IjbBnpuFjSZFGXXX51pXa_%21%212547621781.jpg&quot; class=&quot;&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2547621781/TB2jne_johnpuFjSZFEXXX0PFXa_%21%212547621781.jpg&quot; class=&quot;&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2547621781/TB2Qom5jdFopuFjSZFHXXbSlXXa_%21%212547621781.jpg&quot; class=&quot;&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2547621781/TB2boq5jdFopuFjSZFHXXbSlXXa_%21%212547621781.jpg&quot; class=&quot;&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2547621781/TB231e8jiRnpuFjSZFCXXX2DXXa_%21%212547621781.jpg&quot; class=&quot;&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2547621781/TB22lO1hRNkpuFjy0FaXXbRCVXa_%21%212547621781.jpg&quot; class=&quot;&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2547621781/TB2WvrbjhhmpuFjSZFyXXcLdFXa_%21%212547621781.jpg&quot; class=&quot;&quot; width=&quot;750&quot; align=&quot;absmiddle&quot; height=&quot;614&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2547621781/TB2JEfihSxjpuFjSszeXXaeMVXa_%21%212547621781.jpg&quot; class=&quot;&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2547621781/TB27AHAhH8kpuFjy0FcXXaUhpXa_%21%212547621781.jpg&quot; class=&quot;&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2547621781/TB20zK.jilnpuFjSZFgXXbi7FXa_%21%212547621781.jpg&quot; class=&quot;&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2547621781/TB2rsCYjhBmpuFjSZFsXXcXpFXa_%21%212547621781.jpg&quot; class=&quot;&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2547621781/TB2sTrojb4npuFjSZFmXXXl4FXa_%21%212547621781.jpg&quot; class=&quot;&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2547621781/TB27rjsjhlmpuFjSZPfXXc9iXXa_%21%212547621781.jpg&quot; class=&quot;&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2547621781/TB2P3YohMxlpuFjSszbXXcSVpXa_%21%212547621781.jpg&quot; class=&quot;&quot; align=&quot;absmiddle&quot; /&gt; \r\n&lt;/p&gt;\r\n&lt;div style=&quot;font-size:0.0px;&quot;&gt;\r\n	模板保护代码\r\n&lt;/div&gt;\r\n&lt;p&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;',	'',	'',	''),
(11,	11,	'&lt;h1&gt;\r\n	&lt;img src=&quot;/uploads/image/20170413/58eedb36a5351.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170413/58eedbb90c440.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170413/58eedbcac0277.jpg&quot; alt=&quot;&quot; /&gt;&lt;br /&gt;\r\n&lt;/h1&gt;',	'',	'',	''),
(12,	12,	'',	'',	'',	''),
(13,	13,	'&lt;p class=&quot;more-par&quot; align=&quot;center&quot;&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;\r\n&lt;div id=&quot;J-detail-pop-tpl-top-new&quot; align=&quot;center&quot;&gt;\r\n	&lt;p&gt;\r\n		&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t3097/314/6124732018/402661/94a63869/589ac956N457ab018.jpg&quot; width=&quot;990&quot; height=&quot;500&quot; /&gt; &amp;nbsp; &amp;nbsp;&amp;nbsp; &amp;nbsp;&amp;nbsp;\r\n	&lt;/p&gt;\r\n	&lt;p&gt;\r\n		&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2998/32/1981126201/266895/de941dc2/57d0c117N1a9e9a2f.jpg&quot; alt=&quot;&quot; width=&quot;990&quot; height=&quot;500&quot; /&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t5056/284/1061639657/63444/12c16fa6/58ec7f45Nfe079154.png&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4768/165/682238555/1174742/d7d635d0/58e605d5Nf6c21a9b.jpg&quot; alt=&quot;&quot; width=&quot;990&quot; height=&quot;1380&quot; /&gt; &amp;nbsp; &amp;nbsp;\r\n	&lt;/p&gt;\r\n&lt;/div&gt;\r\n&lt;div align=&quot;center&quot;&gt;\r\n	&lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;c3aba8a4bb794b5eb294149bd300f059 &quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2380/249/2046922990/79902/b27edf26/56960b74N715dfc48.jpg&quot; /&gt;&amp;nbsp;&amp;nbsp; &lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;1ffb38f82fe5476dbd24264240236a0d &quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2098/202/16114605/152343/67c06ada/55e684fdN2435a65f.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;190832b8f2ac43fa92daa21f1d9e03c5 &quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t1978/128/18456154/173722/ef494784/55e684fdN6e12e5f3.jpg&quot; /&gt; \r\n&lt;/div&gt;',	'',	'',	''),
(14,	14,	'&lt;img src=&quot;/uploads/image/20170414/58f040c177d94.jpg&quot; alt=&quot;&quot; /&gt;',	'牛奶',	'牛奶',	'牛奶'),
(15,	15,	'',	'',	'',	''),
(16,	16,	'',	'',	'',	''),
(17,	17,	'',	'',	'',	''),
(18,	18,	'',	'鲜花，婚庆',	'鲜花，婚庆',	'鲜花，婚庆'),
(19,	19,	'&lt;h1 style=&quot;color:#666666;font-family:微软雅黑;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;ul class=&quot;attributes-list&quot; style=&quot;font-family:tahoma, arial, \'Hiragino Sans GB\', 宋体, sans-serif;&quot;&gt;\r\n		&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n			生产许可证编号:&amp;nbsp;\r\n		&lt;/li&gt;\r\n	&lt;/ul&gt;\r\n	&lt;ul class=&quot;attributes-list&quot; style=&quot;font-family:tahoma, arial, \'Hiragino Sans GB\', 宋体, sans-serif;&quot;&gt;\r\n		&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n			产品标准号:&amp;nbsp;\r\n		&lt;/li&gt;\r\n	&lt;/ul&gt;\r\n	&lt;ul class=&quot;attributes-list&quot; style=&quot;font-family:tahoma, arial, \'Hiragino Sans GB\', 宋体, sans-serif;&quot;&gt;\r\n		&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n			厂名:&amp;nbsp;邢台美的客食品股份有限公司\r\n		&lt;/li&gt;\r\n	&lt;/ul&gt;\r\n	&lt;ul class=&quot;attributes-list&quot; style=&quot;font-family:tahoma, arial, \'Hiragino Sans GB\', 宋体, sans-serif;&quot;&gt;\r\n		&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n			厂址:&amp;nbsp;河北省邢台市临西县吕寨乡王铎寺村东(县城泰山西路路北侧)\r\n		&lt;/li&gt;\r\n	&lt;/ul&gt;\r\n	&lt;ul class=&quot;attributes-list&quot; style=&quot;font-family:tahoma, arial, \'Hiragino Sans GB\', 宋体, sans-serif;&quot;&gt;\r\n		&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n			厂家联系方式:&amp;nbsp;\r\n		&lt;/li&gt;\r\n	&lt;/ul&gt;\r\n	&lt;ul class=&quot;attributes-list&quot; style=&quot;font-family:tahoma, arial, \'Hiragino Sans GB\', 宋体, sans-serif;&quot;&gt;\r\n		&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n			配料表:&amp;nbsp;详情见包装\r\n		&lt;/li&gt;\r\n	&lt;/ul&gt;\r\n	&lt;ul class=&quot;attributes-list&quot; style=&quot;font-family:tahoma, arial, \'Hiragino Sans GB\', 宋体, sans-serif;&quot;&gt;\r\n		&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n			储藏方法:&amp;nbsp;\r\n		&lt;/li&gt;\r\n	&lt;/ul&gt;\r\n	&lt;ul class=&quot;attributes-list&quot; style=&quot;font-family:tahoma, arial, \'Hiragino Sans GB\', 宋体, sans-serif;&quot;&gt;\r\n		&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n			保质期:&amp;nbsp;180\r\n		&lt;/li&gt;\r\n	&lt;/ul&gt;\r\n	&lt;ul class=&quot;attributes-list&quot; style=&quot;font-family:tahoma, arial, \'Hiragino Sans GB\', 宋体, sans-serif;&quot;&gt;\r\n		&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n			食品添加剂:&amp;nbsp;详情见包装\r\n		&lt;/li&gt;\r\n	&lt;/ul&gt;\r\n	&lt;ul class=&quot;attributes-list&quot; style=&quot;font-family:tahoma, arial, \'Hiragino Sans GB\', 宋体, sans-serif;&quot;&gt;\r\n		&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n			包装方式:&amp;nbsp;散装\r\n		&lt;/li&gt;\r\n	&lt;/ul&gt;\r\n	&lt;ul class=&quot;attributes-list&quot; style=&quot;font-family:tahoma, arial, \'Hiragino Sans GB\', 宋体, sans-serif;&quot;&gt;\r\n		&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n			品牌:&amp;nbsp;美的客\r\n		&lt;/li&gt;\r\n	&lt;/ul&gt;\r\n	&lt;ul class=&quot;attributes-list&quot; style=&quot;font-family:tahoma, arial, \'Hiragino Sans GB\', 宋体, sans-serif;&quot;&gt;\r\n		&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n			系列:&amp;nbsp;涂饰蛋糕\r\n		&lt;/li&gt;\r\n	&lt;/ul&gt;\r\n	&lt;ul class=&quot;attributes-list&quot; style=&quot;font-family:tahoma, arial, \'Hiragino Sans GB\', 宋体, sans-serif;&quot;&gt;\r\n		&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n			产地:&amp;nbsp;中国大陆\r\n		&lt;/li&gt;\r\n	&lt;/ul&gt;\r\n&lt;/h1&gt;\r\n&lt;ul class=&quot;attributes-list&quot; style=&quot;color:#666666;font-family:tahoma, arial, \'Hiragino Sans GB\', 宋体, sans-serif;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n		省份:&amp;nbsp;湖南省\r\n	&lt;/li&gt;\r\n&lt;/ul&gt;',	'',	'',	''),
(20,	20,	'',	'',	'',	''),
(21,	21,	'&lt;img src=&quot;/uploads/image/20170414/58f07989d692a.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(22,	22,	'&lt;img src=&quot;/uploads/image/20170414/58f07ba237770.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170414/58f07ba290fb5.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170414/58f07ba2c28f5.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(23,	23,	'&lt;img src=&quot;/uploads/image/20170414/58f07e7c81a26.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(24,	24,	'&lt;img src=&quot;/uploads/image/20170414/58f07ff97ef6d.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(25,	25,	'&lt;img src=&quot;uploads/image/20170414/58f0823f37c65.png&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;uploads/image/20170414/58f0823fa086e.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(26,	26,	'&lt;img src=&quot;uploads/image/20170414/58f083d72e887.png&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;uploads/image/20170414/58f083d7a4036.png&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;uploads/image/20170414/58f083d830efd.png&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;uploads/image/20170414/58f083d88eb69.png&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;uploads/image/20170414/58f083d90f713.png&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(27,	27,	'',	'',	'',	''),
(28,	28,	'&lt;img src=&quot;uploads/image/20170414/58f08a7994ca1.png&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;uploads/image/20170414/58f08a7a1b077.png&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;uploads/image/20170414/58f08a7a4efd7.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;uploads/image/20170414/58f08a7aaa615.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;uploads/image/20170414/58f08a7add988.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;uploads/image/20170414/58f08a7b32637.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(29,	29,	'&lt;img src=&quot;uploads/image/20170414/58f08d8ed5473.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;uploads/image/20170414/58f08d8f67ba1.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;uploads/image/20170414/58f08d8fec518.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;uploads/image/20170414/58f08d908182e.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;uploads/image/20170414/58f08d90e704e.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;uploads/image/20170414/58f08d915dad0.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(30,	30,	'',	'',	'',	''),
(31,	31,	'',	'',	'',	''),
(32,	32,	'',	'',	'',	''),
(33,	33,	'&lt;img src=&quot;/uploads/image/20170418/58f561b03d0c6.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(34,	34,	'手机',	'',	'',	''),
(35,	35,	'&lt;div class=&quot;p-parameter&quot; style=&quot;margin:0px 0px 10px;padding:0px 10px 10px;color:#666666;font-family:tahoma, arial, \'Microsoft YaHei\', \'Hiragino Sans GB\', u5b8bu4f53, sans-serif;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;p class=&quot;more-par&quot; style=&quot;text-align:right;&quot;&gt;\r\n		&lt;span style=&quot;line-height:1.5;&quot;&gt;&amp;nbsp;&lt;/span&gt; \r\n	&lt;/p&gt;\r\n&lt;/div&gt;\r\n&lt;div class=&quot;detail-content clearfix&quot; style=&quot;margin:10px 0px;padding:0px;color:#666666;font-family:tahoma, arial, \'Microsoft YaHei\', \'Hiragino Sans GB\', u5b8bu4f53, sans-serif;background:#F7F7F7;&quot;&gt;\r\n	&lt;div class=&quot;detail-content-wrap&quot; style=&quot;margin:0px;padding:0px;background-color:#FFFFFF;&quot;&gt;\r\n		&lt;div class=&quot;detail-content-item&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n			&lt;div id=&quot;J-detail-content&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n				&lt;div style=&quot;margin:0px;padding:0px;text-align:center;&quot;&gt;\r\n					&lt;img alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4330/32/3332689214/428273/f6b2461b/58df4025Na66ffb5e.jpg&quot; /&gt; \r\n				&lt;/div&gt;\r\n				&lt;div style=&quot;margin:0px;padding:0px;text-align:center;&quot;&gt;\r\n					&lt;img alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4471/95/1438293732/563332/89f20952/58df4025N44eaaebb.jpg&quot; /&gt; \r\n				&lt;/div&gt;\r\n				&lt;div style=&quot;margin:0px;padding:0px;text-align:center;&quot;&gt;\r\n					&lt;img alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4291/311/3343721731/515013/7521e71c/58df4025N068a79a8.jpg&quot; /&gt; \r\n				&lt;/div&gt;\r\n				&lt;div style=&quot;margin:0px;padding:0px;text-align:center;&quot;&gt;\r\n					&lt;img alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4603/83/1479383453/285672/2999b3c9/58df4024N684e3f1d.jpg&quot; /&gt; \r\n				&lt;/div&gt;\r\n				&lt;div style=&quot;margin:0px;padding:0px;text-align:center;&quot;&gt;\r\n					&lt;img alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4921/25/321966500/423831/f8ff4ac0/58df4025N013f970e.jpg&quot; /&gt; \r\n				&lt;/div&gt;\r\n				&lt;div style=&quot;margin:0px;padding:0px;text-align:center;&quot;&gt;\r\n					&lt;img alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4867/17/324059198/208690/5c7ccd5c/58df4025N6cf5d63f.jpg&quot; /&gt; \r\n				&lt;/div&gt;\r\n				&lt;div style=&quot;margin:0px;padding:0px;text-align:center;&quot;&gt;\r\n					&lt;img alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4969/361/336136212/186358/c4fee78e/58df4025N8c05ec62.jpg&quot; /&gt; \r\n				&lt;/div&gt;\r\n				&lt;div style=&quot;margin:0px;padding:0px;text-align:center;&quot;&gt;\r\n					&lt;img alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4843/359/342736823/291019/e6db6d4/58df4025Nf555fa15.jpg&quot; /&gt; \r\n				&lt;/div&gt;\r\n				&lt;div style=&quot;margin:0px;padding:0px;text-align:center;&quot;&gt;\r\n					&lt;img alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4144/219/3302254488/328412/17d9db00/58df4025N64d70715.jpg&quot; /&gt; \r\n				&lt;/div&gt;\r\n				&lt;div style=&quot;margin:0px;padding:0px;text-align:center;&quot;&gt;\r\n					&lt;img alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4795/363/340172752/303230/fedc1113/58df4021Nf8702495.jpg&quot; /&gt; \r\n				&lt;/div&gt;\r\n				&lt;div style=&quot;margin:0px;padding:0px;text-align:center;&quot;&gt;\r\n					&lt;img alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4486/39/1445354363/286267/854f4f88/58df4026N4e1180c1.jpg&quot; /&gt; \r\n				&lt;/div&gt;\r\n				&lt;div style=&quot;margin:0px;padding:0px;text-align:center;&quot;&gt;\r\n					&lt;img alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4516/102/1444858229/256606/c3fa98fe/58df4026N95f34a75.jpg&quot; /&gt; \r\n				&lt;/div&gt;\r\n				&lt;div style=&quot;margin:0px;padding:0px;text-align:center;&quot;&gt;\r\n					&lt;img alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4399/140/1435528248/272215/35b0a50a/58df4027Nc1cab01c.jpg&quot; /&gt; \r\n				&lt;/div&gt;\r\n				&lt;div style=&quot;margin:0px;padding:0px;text-align:center;&quot;&gt;\r\n					&lt;img alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4816/17/344115383/318698/701fc017/58df4026N0ae2c746.jpg&quot; /&gt; \r\n				&lt;/div&gt;\r\n				&lt;div style=&quot;margin:0px;padding:0px;text-align:center;&quot;&gt;\r\n					&lt;br /&gt;\r\n				&lt;/div&gt;\r\n&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&amp;nbsp;\r\n			&lt;/div&gt;\r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(36,	36,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;img src=&quot;https://img10.360buyimg.com/imgzone/jfs/t4951/342/1803866601/216881/7b6931f0/58f43171Ne785c47e.jpg&quot; /&gt; \r\n&lt;/div&gt;',	'',	'',	''),
(37,	37,	'',	'',	'',	''),
(38,	38,	'',	'',	'',	''),
(39,	39,	'&lt;img src=&quot;/uploads/image/20170506/590d6b1171a37.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170506/590d6b11c9f28.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170506/590d6b1230819.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170506/590d6b1298231.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170506/590d6b14105f2.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170506/590d6b1445d22.jpg&quot; alt=&quot;&quot; /&gt; \r\n&lt;h1 style=&quot;font-size:16px;font-family:\'microsoft yahei\';background-color:#FFFFFF;&quot;&gt;\r\n	&lt;br /&gt;\r\n&lt;/h1&gt;',	'',	'',	''),
(40,	40,	'&lt;img src=&quot;/uploads/image/20170506/590d6cb93d68f.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170506/590d6cc3dbcc2.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170506/590d6cc4722ab.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170506/590d6cc52f5ef.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170506/590d6cc5ba4d9.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170506/590d6cc67b78a.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170506/590d6cc769a3e.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(41,	41,	'&lt;img src=&quot;/uploads/image/20170427/59014cf8caa8a.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170427/59014cf906fcf.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170427/59014cf944184.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170427/59014cf9855f9.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170427/59014cf9d0fc0.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170427/59014cfa0c987.jpg&quot; alt=&quot;&quot; /&gt;&lt;br /&gt;',	'',	'',	''),
(42,	42,	'&lt;img src=&quot;/uploads/image/20170427/59014f277e908.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170427/59014f27b9f00.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170427/59014f280c676.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170427/59014f2a6e09d.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170427/59014f2abd00e.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170427/59014f2af0226.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(43,	43,	'&lt;p class=&quot;attr-list-hd tm-clear&quot; style=&quot;color:#999999;font-family:tahoma, arial, 微软雅黑, sans-serif;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-weight:700;&quot;&gt;&lt;strong&gt;产品参数&lt;/strong&gt;&lt;strong&gt;：&lt;/strong&gt;&lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;ul id=&quot;J_AttrUL&quot; style=&quot;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\r\n		材质成分:&amp;nbsp;棉95% 聚氨酯弹性纤维(氨纶)5% &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&lt;span style=&quot;line-height:1.5;&quot;&gt;流行元素:&amp;nbsp;印花 &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;line-height:1.5;&quot;&gt;袖长:&amp;nbsp;短袖&lt;/span&gt;\r\n	&lt;/li&gt;\r\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\r\n		销售渠道类型:&amp;nbsp;纯电商(只在线上销售) &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&amp;nbsp;&lt;span style=&quot;line-height:1.5;&quot;&gt;货号:&amp;nbsp;0289 &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&lt;/span&gt;&lt;span style=&quot;line-height:1.5;&quot;&gt;服装版型:&amp;nbsp;修身&lt;/span&gt;\r\n	&lt;/li&gt;\r\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\r\n		衣长:&amp;nbsp;常规款 &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &lt;span style=&quot;line-height:1.5;&quot;&gt;领型:&amp;nbsp;圆领 &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&lt;/span&gt;&lt;span style=&quot;line-height:1.5;&quot;&gt;袖型:&amp;nbsp;常规&lt;/span&gt;\r\n	&lt;/li&gt;\r\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\r\n		品牌:&amp;nbsp;奇黛依 &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&amp;nbsp;&lt;span style=&quot;line-height:1.5;&quot;&gt;图案:&amp;nbsp;卡通动漫 &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&lt;/span&gt;&lt;span style=&quot;line-height:1.5;&quot;&gt;图案文化:&amp;nbsp;创意&lt;/span&gt;\r\n	&lt;/li&gt;\r\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\r\n		适用年龄:&amp;nbsp;18-24周岁 &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&lt;span style=&quot;line-height:1.5;&quot;&gt;风格:&amp;nbsp;通勤 &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&lt;/span&gt;&lt;span style=&quot;line-height:1.5;&quot;&gt;通勤:&amp;nbsp;韩版 &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&amp;nbsp;&lt;/span&gt;\r\n	&lt;/li&gt;\r\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\r\n		&lt;span style=&quot;line-height:1.5;&quot;&gt;年份季节:&amp;nbsp;2017年夏季 &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&lt;/span&gt;&lt;span style=&quot;line-height:1.5;&quot;&gt;主要颜色:&amp;nbsp;0289修身白色&amp;nbsp;0289修身粉色&amp;nbsp;0289修身红色&amp;nbsp;0289修身黑色&amp;nbsp;0289-修身-蓝色&amp;nbsp;0289-修身-黄色&amp;nbsp;0476修身白色&amp;nbsp;0476修身粉色&amp;nbsp;0476修身红色&amp;nbsp;0476修身蓝色&amp;nbsp;0476修身黑色&amp;nbsp;0476-修身-黄色&amp;nbsp;0486修身白色&amp;nbsp;0486修身粉色&amp;nbsp;0486修身黑色&amp;nbsp;0486修身红色&amp;nbsp;0486-修身-黄色&amp;nbsp;0514修身粉色&amp;nbsp;0514修身白色&amp;nbsp;0514修身蓝色&amp;nbsp;0514修身红色&amp;nbsp;0552-修身-粉色&amp;nbsp;0552-修身-白色&amp;nbsp;0552-修身-红色&amp;nbsp;0552-修身-黑色&amp;nbsp;0552-修身-黄色&amp;nbsp;0552-修身-蓝色&amp;nbsp;0551-修身-粉色&amp;nbsp;0551-修身-白色&amp;nbsp;0551-修身-红色&amp;nbsp;0551-修身-黄色&amp;nbsp;0551-修身-蓝色&amp;nbsp;0551-修身-黑色&amp;nbsp;0436修身粉色&amp;nbsp;0436修身白色&amp;nbsp;0436修身黑色&amp;nbsp;0436修身红色&amp;nbsp;0550修身粉色&amp;nbsp;0550修身白色&amp;nbsp;0550修身蓝色&amp;nbsp;0550修身红色&amp;nbsp;0555-修身-红色&amp;nbsp;0555-修身-黑色&amp;nbsp;0395修身白色&amp;nbsp;0395修身蓝色&amp;nbsp;0395修身粉色&amp;nbsp;0395修身红色&amp;nbsp;0395修身黑色&amp;nbsp;0397修身红色&amp;nbsp;0397修身粉色&amp;nbsp;0397修身黑色&amp;nbsp;0397修身白色&amp;nbsp;0397修身蓝色&amp;nbsp;0464修身粉色&amp;nbsp;0464修身蓝色&amp;nbsp;0464修身红色&amp;nbsp;0464修身白色&amp;nbsp;0464修身黑色&amp;nbsp;0002修身白色&amp;nbsp;0002修身红色&amp;nbsp;0002修身蓝色&amp;nbsp;0002修身粉色&amp;nbsp;0002修身黑色&amp;nbsp;0556-修身-白色&amp;nbsp;0556-修身-红色&amp;nbsp;0556-修身-蓝色&amp;nbsp;0556-修身-黑色&amp;nbsp;0556-修身-粉色&amp;nbsp;0560-修身-白色&amp;nbsp;0560-修身-红色&amp;nbsp;0560-修身-蓝色&amp;nbsp;0560-修身-黑色&amp;nbsp;0560-修身-粉色&amp;nbsp;0561-修身-白色&amp;nbsp;0561-修身-红色&amp;nbsp;0561-修身-蓝色&amp;nbsp;0561-修身-粉色&amp;nbsp;0562-修身-黑色&amp;nbsp;0562-修身-红色&amp;nbsp;0563-修身-白色&amp;nbsp;0563-修身-粉色&amp;nbsp;0563-修身-红色&amp;nbsp;0563-修身-蓝色&amp;nbsp;0395-修身-黄色&amp;nbsp;0002-修身-黄色&amp;nbsp;563-修身-黄色&amp;nbsp;0550-修身-黄色&amp;nbsp;0289-修身-灰色&amp;nbsp;0476-修身-灰色&amp;nbsp;0551-修身-灰色&amp;nbsp;0552-修身-灰色&amp;nbsp;0556-修身-灰色&amp;nbsp;0560-修身-灰色&amp;nbsp;0563-修身-灰色&lt;/span&gt;\r\n	&lt;/li&gt;\r\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\r\n		尺码:&amp;nbsp;S&amp;nbsp;M&amp;nbsp;L&amp;nbsp;XL&amp;nbsp;2XL&amp;nbsp;3XL\r\n	&lt;/li&gt;\r\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\r\n		&lt;img src=&quot;/uploads/image/20170427/59018228e0703.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170427/590182297dd00.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170427/5901822a044c5.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170427/5901822a7729b.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170427/5901822ac0b10.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170427/5901822b7046a.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170427/5901824d2d221.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170427/590182514443d.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170427/59018252142bd.jpg&quot; alt=&quot;&quot; /&gt;&lt;br /&gt;\r\n	&lt;/li&gt;\r\n&lt;/ul&gt;',	'',	'',	''),
(44,	44,	'&lt;h1 style=&quot;font-size:16px;font-family:\'microsoft yahei\';background-color:#FFFFFF;&quot;&gt;\r\n	夏季男鞋透气网鞋男休闲运动鞋男士网布鞋韩版潮套脚懒人网面鞋子\r\n&lt;/h1&gt;',	'',	'',	''),
(45,	45,	'&lt;ul class=&quot;attributes-list&quot; style=&quot;font-family:tahoma, arial, \'Hiragino Sans GB\', 宋体, sans-serif;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n		风格:&amp;nbsp;通勤\r\n	&lt;/li&gt;\r\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n		货号:&amp;nbsp;8868\r\n	&lt;/li&gt;\r\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n		服装版型:&amp;nbsp;修身\r\n	&lt;/li&gt;\r\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n		款式:&amp;nbsp;吊带\r\n	&lt;/li&gt;\r\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n		组合形式:&amp;nbsp;单件\r\n	&lt;/li&gt;\r\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n		衣长:&amp;nbsp;中长款\r\n	&lt;/li&gt;\r\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n		年份季节:&amp;nbsp;2017年春季\r\n	&lt;/li&gt;\r\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n		颜色分类:&amp;nbsp;条纹色 酒红色 蓝色 黑色\r\n	&lt;/li&gt;\r\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n		&lt;img src=&quot;/uploads/image/20170427/59017eae01622.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170427/5901663507dca.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170427/590166377d568.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170427/5901663eafd52.jpg&quot; alt=&quot;&quot; /&gt; \r\n	&lt;/li&gt;\r\n&lt;/ul&gt;',	'',	'',	''),
(46,	46,	'&lt;p class=&quot;attr-list-hd tm-clear&quot; style=&quot;color:#999999;font-family:tahoma, arial, 微软雅黑, sans-serif;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-weight:700;&quot;&gt;产品参数：&lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;ul id=&quot;J_AttrUL&quot; style=&quot;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\r\n		材质成分:&amp;nbsp;聚酯纤维93.8% 聚氨酯弹性纤维(氨纶)6.2 &amp;nbsp; &amp;nbsp; &amp;nbsp;&lt;span style=&quot;line-height:1.5;&quot;&gt;销售渠道类型:&amp;nbsp;纯电商(只在线上销售)&lt;/span&gt;\r\n	&lt;/li&gt;\r\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\r\n		货号:&amp;nbsp;17A12 &amp;nbsp; &amp;nbsp; &amp;nbsp;&amp;nbsp;&lt;span style=&quot;line-height:1.5;&quot;&gt;风格:&amp;nbsp;通勤 &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&lt;/span&gt;&lt;span style=&quot;line-height:1.5;&quot;&gt;通勤:&amp;nbsp;韩版 &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&lt;/span&gt;&lt;span style=&quot;line-height:1.5;&quot;&gt;组合形式:&amp;nbsp;单件&lt;/span&gt;\r\n	&lt;/li&gt;\r\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\r\n		裙长:&amp;nbsp;中长裙 &amp;nbsp; &amp;nbsp; &amp;nbsp;&amp;nbsp;&lt;span style=&quot;line-height:1.5;&quot;&gt;袖长:&amp;nbsp;短袖 &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&lt;/span&gt;&lt;span style=&quot;line-height:1.5;&quot;&gt;领型:&amp;nbsp;圆领 &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&lt;/span&gt;&lt;span style=&quot;line-height:1.5;&quot;&gt;图案:&amp;nbsp;人物&lt;/span&gt;\r\n	&lt;/li&gt;\r\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\r\n		品牌:&amp;nbsp;俏姬兰 &amp;nbsp; &amp;nbsp; &amp;nbsp;&amp;nbsp;&lt;span style=&quot;line-height:1.5;&quot;&gt;适用年龄:&amp;nbsp;25-29周岁 &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&lt;/span&gt;&lt;span style=&quot;line-height:1.5;&quot;&gt;年份季节:&amp;nbsp;2017年春季&lt;/span&gt;\r\n	&lt;/li&gt;\r\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\r\n		颜色分类:&amp;nbsp;黑色 &amp;nbsp; &amp;nbsp;&lt;span style=&quot;line-height:1.5;&quot;&gt;尺码:&amp;nbsp;S&amp;nbsp;M&amp;nbsp;L&amp;nbsp;XL&amp;nbsp;XXL&amp;nbsp;3XL&lt;/span&gt;\r\n	&lt;/li&gt;\r\n&lt;/ul&gt;\r\n&lt;p&gt;\r\n	&lt;span&gt;&lt;img src=&quot;/uploads/image/20170427/59018370a44fe.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170427/590183a3283da.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170427/590183a39b4dc.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170427/590183fee833f.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170427/5901844f811ef.jpg&quot; alt=&quot;&quot; /&gt;&lt;br /&gt;\r\n&lt;/span&gt;\r\n&lt;/p&gt;',	'',	'',	''),
(47,	47,	'&lt;h1 style=&quot;font-size:16px;font-family:\'microsoft yahei\';background-color:#FFFFFF;&quot;&gt;\r\n	&lt;p class=&quot;attr-list-hd tm-clear&quot; style=&quot;color:#999999;font-family:tahoma, arial, 微软雅黑, sans-serif;background-color:#FFFFFF;&quot;&gt;\r\n		&lt;span style=&quot;font-weight:700;&quot;&gt;产品参数：&lt;/span&gt; \r\n	&lt;/p&gt;\r\n	&lt;ul id=&quot;J_AttrUL&quot; style=&quot;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;background-color:#FFFFFF;&quot;&gt;\r\n		&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\r\n			廓形:&amp;nbsp;H型 &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&amp;nbsp;&lt;span style=&quot;font-weight:normal;line-height:1.5;&quot;&gt;材质成分:&amp;nbsp;桑蚕丝100% &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-weight:normal;line-height:1.5;&quot;&gt;货号:&amp;nbsp;F040701&lt;/span&gt; \r\n		&lt;/li&gt;\r\n		&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\r\n			风格:&amp;nbsp;通勤 &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&lt;span style=&quot;font-weight:normal;line-height:1.5;&quot;&gt;通勤:&amp;nbsp;OL风格 &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &lt;/span&gt;&lt;span style=&quot;font-weight:normal;line-height:1.5;&quot;&gt;组合形式:&amp;nbsp;两件套&lt;/span&gt; \r\n		&lt;/li&gt;\r\n		&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\r\n			裙长:&amp;nbsp;中长裙 &amp;nbsp; &amp;nbsp;&amp;nbsp;&lt;span style=&quot;font-weight:normal;line-height:1.5;&quot;&gt;袖长:&amp;nbsp;五分袖 &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-weight:normal;line-height:1.5;&quot;&gt;领型:&amp;nbsp;圆领&lt;/span&gt; \r\n		&lt;/li&gt;\r\n		&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\r\n			袖型:&amp;nbsp;其他 &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&amp;nbsp;&lt;span style=&quot;font-weight:normal;line-height:1.5;&quot;&gt;腰型:&amp;nbsp;中腰 &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-weight:normal;line-height:1.5;&quot;&gt;衣门襟:&amp;nbsp;拉链&lt;/span&gt; \r\n		&lt;/li&gt;\r\n		&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\r\n			裙型:&amp;nbsp;不规则裙 &amp;nbsp;&lt;span style=&quot;font-weight:normal;line-height:1.5;&quot;&gt;图案:&amp;nbsp;纯色&lt;/span&gt; \r\n		&lt;/li&gt;\r\n		&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\r\n			流行元素/工艺:&amp;nbsp;荷叶边&amp;nbsp;抽褶&amp;nbsp;不对称&amp;nbsp;绑带\r\n		&lt;/li&gt;\r\n		&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\r\n			品牌:&amp;nbsp;Helene＆Co &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&lt;span style=&quot;font-weight:normal;line-height:1.5;&quot;&gt;面料:&amp;nbsp;其他&lt;/span&gt; \r\n		&lt;/li&gt;\r\n		&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\r\n			适用年龄:&amp;nbsp;30-34周岁 &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &lt;span style=&quot;font-weight:normal;line-height:1.5;&quot;&gt;年份季节:&amp;nbsp;2017年夏季&lt;/span&gt; \r\n		&lt;/li&gt;\r\n		&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\r\n			颜色分类:&amp;nbsp;兰色&amp;nbsp;黄色 &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&amp;nbsp;&lt;span style=&quot;font-weight:normal;line-height:1.5;&quot;&gt;尺码:&amp;nbsp;155/S&amp;nbsp;160/M&amp;nbsp;165/L&amp;nbsp;170/XL&lt;/span&gt; \r\n		&lt;/li&gt;\r\n	&lt;/ul&gt;\r\n&lt;/h1&gt;\r\n&lt;p class=&quot;newp&quot; style=&quot;color:#DD2727;font-family:\'microsoft yahei\';font-size:14px;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;img src=&quot;/uploads/image/20170427/59016504d4dff.png&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170427/59016505908fb.png&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170427/5901650708367.png&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170427/5901650891806.png&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170427/590165097e898.png&quot; alt=&quot;&quot; /&gt; \r\n&lt;/p&gt;',	'',	'',	''),
(48,	48,	'&lt;img src=&quot;/uploads/image/20170427/59017dc43b0a0.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170427/59017ef051a51.png&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170427/59017ef0a1b02.png&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170427/59017ef0e9dd8.png&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(49,	49,	'&lt;img src=&quot;/uploads/image/20170427/5901945922fc2.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170427/590194598ec4d.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170427/59019459dc59f.jpg&quot; alt=&quot;&quot; /&gt;',	'小米手机',	'小米手机',	'小米手机'),
(50,	50,	'',	'',	'',	''),
(51,	51,	'',	'',	'',	''),
(52,	52,	'&lt;img src=&quot;/uploads/image/20170428/5902e238deba8.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170428/5902e23955dd7.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170428/5902e239b9870.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170428/5902e23a32af6.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170428/5902e23a9daea.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(53,	53,	'',	'',	'',	''),
(54,	54,	'',	'',	'',	''),
(55,	55,	'',	'',	'',	''),
(56,	56,	'',	'',	'',	''),
(57,	57,	'',	'',	'',	''),
(58,	58,	'',	'',	'',	''),
(59,	59,	'',	'',	'',	''),
(60,	60,	'&lt;div class=&quot;main-wrap J_TRegion&quot; id=&quot;J_MainWrap&quot;&gt;\r\n	&lt;div class=&quot;sub-wrap&quot; id=&quot;J_SubWrap&quot;&gt;\r\n		&lt;div id=&quot;description&quot; class=&quot;J_DetailSection tshop-psm ke-post&quot;&gt;\r\n			&lt;div id=&quot;J_DivItemDesc&quot; class=&quot;content&quot;&gt;\r\n				&lt;p&gt;\r\n					&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2605037466/TB2boOmjEhnpuFjSZFEXXX0PFXa_%21%212605037466.jpg&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/2605037466/TB2RPiijt0opuFjSZFxXXaDNVXa_%21%212605037466.jpg&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2605037466/TB2JY5DjrBmpuFjSZFAXXaQ0pXa_%21%212605037466.jpg&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2605037466/TB2d_asjypnpuFjSZFkXXc4ZpXa_%21%212605037466.jpg&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i2/2605037466/TB2hxaXjxBmpuFjSZFsXXcXpFXa_%21%212605037466.jpg&quot; class=&quot;&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2605037466/TB24nGXjstnpuFjSZFKXXalFFXa_%21%212605037466.jpg&quot; class=&quot;&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2605037466/TB2iT9kjypnpuFjSZFIXXXh2VXa_%21%212605037466.jpg&quot; class=&quot;&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2605037466/TB2aMWpjxBmpuFjSZFDXXXD8pXa_%21%212605037466.jpg&quot; class=&quot;&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i3/2605037466/TB2GtyyjrxmpuFjSZJiXXXauVXa_%21%212605037466.jpg&quot; class=&quot;&quot; align=&quot;absmiddle&quot; /&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i1/2605037466/TB2BNuxjC8mpuFjSZFMXXaxpVXa_%21%212605037466.jpg&quot; class=&quot;&quot; align=&quot;absmiddle&quot; /&gt; \r\n				&lt;/p&gt;\r\n			&lt;/div&gt;\r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;J_AsyncDC tb-custom-area tb-shop&quot; id=&quot;J_AsyncDCMain&quot;&gt;\r\n		&lt;div class=&quot;J_TModule&quot; id=&quot;shop14478623551&quot;&gt;\r\n			&lt;div class=&quot;skin-box tb-module tshop-pbsm tshop-pbsm-shop-self-defined&quot;&gt;\r\n				&lt;s class=&quot;skin-box-tp&quot;&gt;&lt;b&gt;&lt;/b&gt;&lt;/s&gt; \r\n				&lt;div class=&quot;skin-box-bd clear-fix&quot;&gt;\r\n					&lt;p&gt;\r\n						&lt;img src=&quot;https://gdp.alicdn.com/imgextra/i4/2605037466/TB2MiHTopXXXXXyXpXXXXXXXXXX_%21%212605037466.jpg&quot; /&gt;&lt;img src=&quot;https://gdp.alicdn.com/imgextra/i3/2605037466/TB2C9cviXXXXXXpXFXXXXXXXXXX_%21%212605037466.jpg&quot; /&gt;&lt;img src=&quot;https://gdp.alicdn.com/imgextra/i4/2605037466/TB2EoMZiXXXXXaBXpXXXXXXXXXX_%21%212605037466.jpg&quot; /&gt;&lt;img src=&quot;https://gdp.alicdn.com/imgextra/i4/2605037466/TB2EvtbipXXXXbnXXXXXXXXXXXX_%21%212605037466.jpg&quot; /&gt;&lt;img src=&quot;https://gdp.alicdn.com/imgextra/i3/2605037466/TB2GF3WiXXXXXabXXXXXXXXXXXX_%21%212605037466.jpg&quot; /&gt;&lt;img src=&quot;https://gdp.alicdn.com/imgextra/i3/2605037466/TB2OfJjipXXXXXFXXXXXXXXXXXX_%21%212605037466.jpg&quot; /&gt;&lt;img src=&quot;https://gdp.alicdn.com/imgextra/i3/2605037466/TB2aBwSiXXXXXb6XpXXXXXXXXXX_%21%212605037466.jpg&quot; /&gt; \r\n					&lt;/p&gt;\r\n				&lt;/div&gt;\r\n&lt;s class=&quot;skin-box-bt&quot;&gt;&lt;b&gt;&lt;/b&gt;&lt;/s&gt; \r\n			&lt;/div&gt;\r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n&lt;/div&gt;\r\n&lt;div class=&quot;tb-price-spec&quot;&gt;\r\n	&lt;h3 class=&quot;spec-title&quot;&gt;\r\n		价格说明\r\n	&lt;/h3&gt;\r\n	&lt;p class=&quot;title&quot;&gt;\r\n		划线价格\r\n	&lt;/p&gt;\r\n	&lt;p class=&quot;info&quot;&gt;\r\n		指商品的专柜价、吊牌价、正品零售价、厂商指导价或该商品的曾经展示过的销售价等，&lt;strong&gt;并非原价&lt;/strong&gt;，仅供参考。\r\n	&lt;/p&gt;\r\n	&lt;p class=&quot;title&quot;&gt;\r\n		未划线价格\r\n	&lt;/p&gt;\r\n	&lt;p class=&quot;info&quot;&gt;\r\n		指商品的&lt;strong&gt;实时标价&lt;/strong&gt;，不因表述的差异改变性质。具体成交价格根据商品参加活动，或会员使用优惠券、积分等发生变化，最终以订单结算页价格为准。\r\n	&lt;/p&gt;\r\n	&lt;p class=&quot;info&quot;&gt;\r\n		此说明仅当出现价格比较时有效，具体请参见《淘宝价格发布规范》。若商家单独对划线价格进行说明的，以商家的表述为准。\r\n	&lt;/p&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(61,	61,	'',	'',	'',	''),
(62,	62,	'',	'',	'',	''),
(63,	63,	'&lt;p class=&quot;attr-list-hd tm-clear&quot; style=&quot;color:#999999;font-family:tahoma, arial, 微软雅黑, sans-serif;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-weight:700;&quot;&gt;产品参数：&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;ul id=&quot;J_AttrUL&quot; style=&quot;color:#404040;font-family:tahoma, arial, 微软雅黑, sans-serif;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;vertical-align:top;color:#666666;&quot;&gt;\r\n		品牌:&amp;nbsp;Helene＆Co &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&amp;nbsp;&lt;span style=&quot;line-height:1.5;&quot;&gt;材质成分:&amp;nbsp;桑蚕丝50% 聚酯纤维27% 亚麻23%&lt;/span&gt; \r\n	&lt;/li&gt;\r\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\r\n		货号:&amp;nbsp;F040502 &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&amp;nbsp; &amp;nbsp; &amp;nbsp;&lt;span style=&quot;line-height:1.5;&quot;&gt;颜色分类:&amp;nbsp;兰色&amp;nbsp;裸粉&lt;/span&gt; \r\n	&lt;/li&gt;\r\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\r\n		尺码:&amp;nbsp;S&amp;nbsp;M&amp;nbsp;L&amp;nbsp;XL &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&lt;span style=&quot;line-height:1.5;&quot;&gt;上市年份季节:&amp;nbsp;2017年夏季&lt;/span&gt; \r\n	&lt;/li&gt;\r\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\r\n		适用年龄:&amp;nbsp;25-35周岁\r\n	&lt;/li&gt;\r\n	&lt;li style=&quot;vertical-align:top;color:#666666;&quot;&gt;\r\n		&lt;img src=&quot;/uploads/image/20170506/590d47561ed27.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170506/590d4756aa91f.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170506/590d4756de05e.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170506/590d4757433cf.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170506/590d475770906.jpg&quot; alt=&quot;&quot; /&gt;&lt;br /&gt;\r\n	&lt;/li&gt;\r\n&lt;/ul&gt;',	'',	'',	''),
(64,	64,	'1111111',	'',	'',	''),
(65,	65,	'&lt;img src=&quot;/uploads/image/20170506/590d69b035e1c.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170506/590d69b092a11.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170506/590d69b0f2b7b.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(66,	66,	'&lt;img src=&quot;/uploads/image/20170506/590d6a5bd132a.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170506/590d6a5c45000.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170506/590d6a5c6bb74.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170506/590d6a5cb96d3.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(67,	67,	'&lt;img src=&quot;/uploads/image/20170506/590d6b88ca7ea.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170506/590d6b8973226.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170506/590d6b8a179b3.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170506/590d6b8a66a50.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170506/590d6b8adab55.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(68,	68,	'&lt;img src=&quot;/uploads/image/20170506/590d6cb524726.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170506/590d6cb598d57.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170506/590d6cb5df316.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170506/590d6cb62cceb.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170506/590d6cb6734eb.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170506/590d6cb6c5e2e.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170506/590d6cb70f359.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(69,	69,	'&lt;img src=&quot;/uploads/image/20170506/590d983e73ad7.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170506/590d9846b2bef.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170506/590d985ba43bc.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(70,	70,	'',	'',	'',	''),
(71,	71,	'&lt;img src=&quot;/uploads/image/20170509/591174946c591.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170509/5911749535394.png&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170509/59117495b4c2d.png&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170509/5911749668416.png&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170509/5911749705445.png&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(72,	72,	'&lt;img src=&quot;/uploads/image/20170513/591670a654b1e.png&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170513/591670a6a79b7.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170513/591670a6dd99f.jpg&quot; alt=&quot;&quot; /&gt;',	'插座',	'插座',	'插座'),
(73,	73,	'',	'',	'',	''),
(74,	74,	'',	'',	'',	''),
(75,	75,	'&lt;img src=&quot;/uploads/image/20170524/5924eb80d712a.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170524/5924eb8136cce.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170524/5924eb819077f.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170524/5924eb81c580e.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170524/5924eb82461a3.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170524/5924eb828010e.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(76,	76,	'&lt;img src=&quot;/uploads/image/20170524/5924ec74e2bb0.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170524/5924ec758a45e.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170524/5924ec75d319f.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170524/5924ec7653a51.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(77,	77,	'&lt;img src=&quot;/uploads/image/20170524/5924edccefc95.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170524/5924edcd8c409.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170524/5924edce4e6bb.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170524/5924edceb65b5.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(78,	78,	'&lt;img src=&quot;/uploads/image/20170527/592930be4d356.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170527/592930bece8dd.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(79,	79,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;img src=&quot;/uploads/image/20170527/5929316c9027b.jpg&quot; alt=&quot;&quot; /&gt;&lt;span style=&quot;line-height:1.5;&quot;&gt;&lt;/span&gt;&lt;img src=&quot;/uploads/image/20170527/5929316d5df17.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170527/5929316dc4ebf.jpg&quot; alt=&quot;&quot; /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(80,	80,	'&lt;p style=&quot;text-align:center;&quot;&gt;\r\n	&lt;img src=&quot;http://d9.yihaodianimg.com/N11/M09/9D/A6/ChEwolkKn2eAMh1RAAUepEIbfec20600.webp&quot; /&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:center;&quot;&gt;\r\n	&lt;img src=&quot;http://d9.yihaodianimg.com/N11/M00/9D/C9/ChEwolkKrGSAXRiFAAc-D30Qj1Q23700.webp&quot; /&gt;\r\n&lt;/p&gt;',	'',	'',	''),
(81,	81,	'&lt;p style=&quot;text-align:center;&quot;&gt;\r\n	&lt;img src=&quot;http://d9.yihaodianimg.com/N08/M0A/CD/4D/ChEi1VaxlfaADTzJAAHLewZl4VM854.jpg&quot; /&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:center;&quot;&gt;\r\n	&lt;img src=&quot;http://d8.yihaodianimg.com/N07/M06/B0/A1/CgQI0FZBk7iAYjMQAAI_T42XW28152.jpg&quot; /&gt;\r\n&lt;/p&gt;',	'',	'',	''),
(82,	82,	'&lt;p style=&quot;text-align:center;&quot;&gt;\r\n	&lt;img src=&quot;http://d10.yihaodianimg.com/N09/M09/FA/18/ChEi11bfuwqAWrlfAAIKRzw2gO883300.jpg&quot; /&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:center;&quot;&gt;\r\n	&lt;img src=&quot;http://d7.yihaodianimg.com/N10/M0A/FD/90/ChEi3FbfuwqACOHuAAMSaBY_sRw32700.jpg&quot; /&gt;\r\n&lt;/p&gt;',	'',	'',	''),
(83,	83,	'&lt;p style=&quot;text-align:center;&quot;&gt;\r\n	&lt;img src=&quot;http://d6.yihaodianimg.com/N05/M03/D3/45/CgQI01c-vwSAUmU0AAIeJRZnazE125.jpg&quot; /&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:center;&quot;&gt;\r\n	&lt;img src=&quot;http://d6.yihaodianimg.com/N05/M03/D3/45/CgQI01c-vwSAUmU0AAIeJRZnazE125.jpg&quot; /&gt; \r\n&lt;/p&gt;',	'',	'',	''),
(84,	84,	'&lt;p style=&quot;text-align:center;&quot;&gt;\r\n	&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; height=&quot;1600&quot; id=&quot;__01&quot; width=&quot;750&quot; style=&quot;color:#333333;font-family:\'microsoft yahei\';font-size:14px;&quot; class=&quot;ke-zeroborder&quot;&gt;\r\n		&lt;tbody&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n					&lt;a href=&quot;http://coupon.yhd.com/merchantCoupon/couponReceiveN-1325-463244202-b41b3de8ac0426764eed&quot; target=&quot;_blank&quot;&gt;&lt;img alt=&quot;&quot; height=&quot;142&quot; src=&quot;http://d9.yihaodianimg.com/N08/M07/34/3B/ChEi1lklTgOAIXa_AAAlX02om-k57800.webp&quot; width=&quot;187&quot; /&gt;&lt;/a&gt;\r\n				&lt;/td&gt;\r\n				&lt;td colspan=&quot;2&quot;&gt;\r\n					&lt;a href=&quot;http://coupon.yhd.com/merchantCoupon/couponReceiveN-1325-463241691-5e859b3f3e2cca7932c4&quot; target=&quot;_blank&quot;&gt;&lt;img alt=&quot;&quot; height=&quot;142&quot; src=&quot;http://d8.yihaodianimg.com/N11/M05/CF/70/ChEwoFklTgOAROm6AAAlhXW6MY419500.webp&quot; width=&quot;188&quot; /&gt;&lt;/a&gt;\r\n				&lt;/td&gt;\r\n				&lt;td colspan=&quot;2&quot;&gt;\r\n					&lt;a href=&quot;http://coupon.yhd.com/merchantCoupon/couponReceiveN-1325-463247166-9f1a9331489ee6477acb&quot; target=&quot;_blank&quot;&gt;&lt;img alt=&quot;&quot; height=&quot;142&quot; src=&quot;http://d7.yihaodianimg.com/N11/M01/CF/70/ChEwoFklTgOADlOJAAAnhPLjW-k60500.webp&quot; width=&quot;188&quot; /&gt;&lt;/a&gt;\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					&lt;a href=&quot;http://coupon.yhd.com/merchantCoupon/couponReceiveN-1325-463248119-3a04094e34ad0bc9ef93&quot; target=&quot;_blank&quot;&gt;&lt;img alt=&quot;&quot; height=&quot;142&quot; src=&quot;http://d9.yihaodianimg.com/N11/M01/CD/38/ChEwoVklTgOAZ_PSAAApYrGI-_Y23500.webp&quot; width=&quot;187&quot; /&gt;&lt;/a&gt;\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td colspan=&quot;3&quot;&gt;\r\n					&lt;img alt=&quot;&quot; height=&quot;329&quot; src=&quot;http://d7.yihaodianimg.com/N09/M01/03/97/ChEi2FklTgOAZPjAAADH08DXGMI12200.webp&quot; width=&quot;375&quot; /&gt;\r\n				&lt;/td&gt;\r\n				&lt;td colspan=&quot;3&quot;&gt;\r\n					&lt;img alt=&quot;&quot; height=&quot;329&quot; src=&quot;http://d9.yihaodianimg.com/N08/M00/33/F4/ChEi1FklTgSAG5_2AAC06jSpR5055100.webp&quot; width=&quot;375&quot; /&gt;\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n					&lt;a href=&quot;http://item.yhd.com/item/62869470?tp=2123.1325.0.0.0.Lktj41O-10-93p46&amp;amp;ti=NEU7EL&quot; target=&quot;_blank&quot;&gt;&lt;img alt=&quot;&quot; height=&quot;246&quot; src=&quot;http://d9.yihaodianimg.com/N09/M02/03/84/ChEi11klTgOAfq-uAABFQremGi484100.webp&quot; width=&quot;187&quot; /&gt;&lt;/a&gt;\r\n				&lt;/td&gt;\r\n				&lt;td colspan=&quot;2&quot;&gt;\r\n					&lt;a href=&quot;http://item.yhd.com/item/69121028?tp=2123.1325.0.0.0.Lktj41O-10-93p46&amp;amp;ti=7C2GEV&quot; target=&quot;_blank&quot;&gt;&lt;img alt=&quot;&quot; height=&quot;246&quot; src=&quot;http://d8.yihaodianimg.com/N09/M05/03/C3/ChEi11klWiuAd_SaAABZpH1YByE91600.webp&quot; width=&quot;188&quot; /&gt;&lt;/a&gt;\r\n				&lt;/td&gt;\r\n				&lt;td colspan=&quot;2&quot;&gt;\r\n					&lt;a href=&quot;http://item.yhd.com/item/52366541?tp=2123.1325.0.0.0.Lktj41O-10-93p46&amp;amp;ti=XX4QEe&quot; target=&quot;_blank&quot;&gt;&lt;img alt=&quot;&quot; height=&quot;246&quot; src=&quot;http://d8.yihaodianimg.com/N09/M03/03/C3/ChEi11klWiuAe2c4AABQUqc__AI13900.webp&quot; width=&quot;188&quot; /&gt;&lt;/a&gt;\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					&lt;a href=&quot;http://item.yhd.com/item/52537424?tp=2123.1325.0.0.0.Lktj41O-10-93p46&amp;amp;ti=AEE6Eo&quot; target=&quot;_blank&quot;&gt;&lt;img alt=&quot;&quot; height=&quot;246&quot; src=&quot;http://d9.yihaodianimg.com/N11/M0B/CD/38/ChEwoVklTgSACkn1AABSESvHmh498700.webp&quot; width=&quot;187&quot; /&gt;&lt;/a&gt;\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td colspan=&quot;6&quot;&gt;\r\n					&lt;a href=&quot;http://t.yhd.com/detail/4559806?tp=2123.1325.0.0.0.Lktj41O-10-93p46&amp;amp;ti=X766FG&quot; target=&quot;_blank&quot;&gt;&lt;img alt=&quot;&quot; height=&quot;301&quot; src=&quot;http://d9.yihaodianimg.com/N10/M06/29/05/ChEi2lklTgSAYLjBAAEW-HReQ5c21000.webp&quot; width=&quot;750&quot; /&gt;&lt;/a&gt;\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td colspan=&quot;2&quot;&gt;\r\n					&lt;a href=&quot;http://t.yhd.com/detail/4559807?tp=2123.1325.0.0.0.Lktj41O-10-93p46&amp;amp;ti=STZ2Fa&quot; target=&quot;_blank&quot;&gt;&lt;img alt=&quot;&quot; height=&quot;282&quot; src=&quot;http://d9.yihaodianimg.com/N09/M00/03/97/ChEi2FklTgSAWSOQAAB650WcjvU43400.webp&quot; width=&quot;251&quot; /&gt;&lt;/a&gt;\r\n				&lt;/td&gt;\r\n				&lt;td colspan=&quot;2&quot;&gt;\r\n					&lt;a href=&quot;http://t.yhd.com/detail/4559796?tp=2123.1325.0.0.0.Lktj41O-10-93p46&amp;amp;ti=A7CUFp&quot; target=&quot;_blank&quot;&gt;&lt;img alt=&quot;&quot; height=&quot;282&quot; src=&quot;http://d9.yihaodianimg.com/N09/M03/03/85/ChEi11klTgSAfWJIAAB2drCPhMc61100.webp&quot; width=&quot;249&quot; /&gt;&lt;/a&gt;\r\n				&lt;/td&gt;\r\n				&lt;td colspan=&quot;2&quot;&gt;\r\n					&lt;a href=&quot;http://t.yhd.com/detail/4559808?tp=2123.1325.0.0.0.Lktj41O-10-93p46&amp;amp;ti=HRC3G9&quot; target=&quot;_blank&quot;&gt;&lt;img alt=&quot;&quot; height=&quot;282&quot; src=&quot;http://d9.yihaodianimg.com/N10/M00/36/33/ChEi21klTgWAUufYAAB5q6BXdKI93500.webp&quot; width=&quot;250&quot; /&gt;&lt;/a&gt;\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td colspan=&quot;2&quot;&gt;\r\n					&lt;a href=&quot;http://t.yhd.com/detail/4559814?tp=2123.1325.0.0.0.Lktj41O-10-93p46&amp;amp;ti=ED7ZGS&quot; target=&quot;_blank&quot;&gt;&lt;img alt=&quot;&quot; height=&quot;288&quot; src=&quot;http://d7.yihaodianimg.com/N11/M08/CF/EB/ChEwolklTgWAFmhDAACCecEfuSU76400.webp&quot; width=&quot;251&quot; /&gt;&lt;/a&gt;\r\n				&lt;/td&gt;\r\n				&lt;td colspan=&quot;2&quot;&gt;\r\n					&lt;a href=&quot;http://t.yhd.com/detail/4559809?tp=2123.1325.0.0.0.Lktj41O-10-93p46&amp;amp;ti=51A8H3&quot; target=&quot;_blank&quot;&gt;&lt;img alt=&quot;&quot; height=&quot;288&quot; src=&quot;http://d9.yihaodianimg.com/N10/M03/36/5D/ChEi3FklTgWACPxuAAB1TYNGCUg78000.webp&quot; width=&quot;249&quot; /&gt;&lt;/a&gt;\r\n				&lt;/td&gt;\r\n				&lt;td colspan=&quot;2&quot;&gt;\r\n					&lt;a href=&quot;http://t.yhd.com/detail/4559812?tp=2123.1325.0.0.0.Lktj41O-10-93p46&amp;amp;ti=TXSGHD&quot; target=&quot;_blank&quot;&gt;&lt;img alt=&quot;&quot; height=&quot;288&quot; src=&quot;http://d7.yihaodianimg.com/N10/M07/29/05/ChEi2lklTgWAFeLUAAB579hnl7g66900.webp&quot; width=&quot;250&quot; /&gt;&lt;/a&gt;\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n		&lt;/tbody&gt;\r\n	&lt;/table&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:center;&quot;&gt;\r\n&lt;/p&gt;',	'',	'',	''),
(85,	85,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;br /&gt;\r\n&lt;img border=&quot;0&quot; class=&quot;blogimg&quot; src=&quot;http://d9.yihaodianimg.com/N08/M0B/E0/BD/ChEi1lbP8eWAef0LAAmeXYPB8iQ68400.webp&quot; /&gt;&amp;nbsp;&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(86,	86,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div id=&quot;module_121361352&quot; style=&quot;color:#333333;font-family:Arial, Helvetica, sans-serif;background-color:#FFFFFF;&quot;&gt;\r\n		&lt;div class=&quot;layout770&quot;&gt;\r\n			&lt;div class=&quot;yhd-sm-shop-user-define shop-moudle mt10&quot; style=&quot;background:none;&quot;&gt;\r\n				&lt;div class=&quot;shop-con&quot; style=&quot;border:0px none;background:inherit;&quot;&gt;\r\n					&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; height=&quot;208&quot; id=&quot;__01&quot; width=&quot;770&quot; class=&quot;ke-zeroborder&quot;&gt;\r\n						&lt;tbody&gt;\r\n							&lt;tr&gt;\r\n								&lt;td&gt;\r\n									&lt;a href=&quot;http://t.yhd.com/detailBrand/42846&quot; target=&quot;_blank&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;http://d8.yihaodianimg.com/N08/M04/2D/20/ChEi1lkifs-AC9_UAADZQr8NNEk31000.webp&quot; style=&quot;width:239px;height:208px;&quot; /&gt;&lt;/a&gt;\r\n								&lt;/td&gt;\r\n								&lt;td&gt;\r\n									&lt;a href=&quot;http://t.yhd.com/detailBrand/42846&quot; target=&quot;_blank&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;http://d8.yihaodianimg.com/N10/M00/2F/2F/ChEi21kifs-AWVgiAAFIgSGo1oU51900.webp&quot; style=&quot;width:274px;height:208px;&quot; /&gt;&lt;/a&gt;\r\n								&lt;/td&gt;\r\n								&lt;td&gt;\r\n									&lt;a href=&quot;http://t.yhd.com/detailBrand/42846&quot; target=&quot;_blank&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;http://d9.yihaodianimg.com/N11/M02/C5/51/ChEwoFkifs-AdukzAADyusrKhRY03800.webp&quot; style=&quot;width:257px;height:208px;&quot; /&gt;&lt;/a&gt;\r\n								&lt;/td&gt;\r\n							&lt;/tr&gt;\r\n						&lt;/tbody&gt;\r\n					&lt;/table&gt;\r\n				&lt;/div&gt;\r\n			&lt;/div&gt;\r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n	&lt;div id=&quot;module_121361348&quot; style=&quot;color:#333333;font-family:Arial, Helvetica, sans-serif;background-color:#FFFFFF;&quot;&gt;\r\n		&lt;div class=&quot;layout770&quot;&gt;\r\n			&lt;div class=&quot;yhd-sm-shop-user-define shop-moudle mt10&quot; style=&quot;background:none;&quot;&gt;\r\n				&lt;div class=&quot;shop-con&quot; style=&quot;border:0px none;background:inherit;&quot;&gt;\r\n					&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; height=&quot;1422&quot; id=&quot;__01&quot; width=&quot;770&quot; class=&quot;ke-zeroborder&quot;&gt;\r\n						&lt;tbody&gt;\r\n							&lt;tr&gt;\r\n								&lt;td colspan=&quot;4&quot;&gt;\r\n									&lt;img alt=&quot;&quot; src=&quot;http://d8.yihaodianimg.com/N10/M09/29/B2/ChEi2lkmP46AKqEAAAQYWfLAIj402900.webp&quot; style=&quot;width:770px;height:383px;&quot; /&gt;\r\n								&lt;/td&gt;\r\n							&lt;/tr&gt;\r\n						&lt;/tbody&gt;\r\n					&lt;/table&gt;\r\n				&lt;/div&gt;\r\n			&lt;/div&gt;\r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(87,	87,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div id=&quot;module_121361352&quot; style=&quot;color:#333333;font-family:Arial, Helvetica, sans-serif;background-color:#FFFFFF;&quot;&gt;\r\n		&lt;div class=&quot;layout770&quot;&gt;\r\n			&lt;div class=&quot;yhd-sm-shop-user-define shop-moudle mt10&quot; style=&quot;background:none;&quot;&gt;\r\n				&lt;div class=&quot;shop-con&quot; style=&quot;border:0px none;background:inherit;&quot;&gt;\r\n					&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; height=&quot;208&quot; id=&quot;__01&quot; width=&quot;770&quot; class=&quot;ke-zeroborder&quot;&gt;\r\n						&lt;tbody&gt;\r\n							&lt;tr&gt;\r\n								&lt;td&gt;\r\n									&lt;a href=&quot;http://t.yhd.com/detailBrand/42846&quot; target=&quot;_blank&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;http://d8.yihaodianimg.com/N08/M04/2D/20/ChEi1lkifs-AC9_UAADZQr8NNEk31000.webp&quot; style=&quot;width:239px;height:208px;&quot; /&gt;&lt;/a&gt;\r\n								&lt;/td&gt;\r\n								&lt;td&gt;\r\n									&lt;a href=&quot;http://t.yhd.com/detailBrand/42846&quot; target=&quot;_blank&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;http://d8.yihaodianimg.com/N10/M00/2F/2F/ChEi21kifs-AWVgiAAFIgSGo1oU51900.webp&quot; style=&quot;width:274px;height:208px;&quot; /&gt;&lt;/a&gt;\r\n								&lt;/td&gt;\r\n								&lt;td&gt;\r\n									&lt;a href=&quot;http://t.yhd.com/detailBrand/42846&quot; target=&quot;_blank&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;http://d9.yihaodianimg.com/N11/M02/C5/51/ChEwoFkifs-AdukzAADyusrKhRY03800.webp&quot; style=&quot;width:257px;height:208px;&quot; /&gt;&lt;/a&gt;\r\n								&lt;/td&gt;\r\n							&lt;/tr&gt;\r\n						&lt;/tbody&gt;\r\n					&lt;/table&gt;\r\n				&lt;/div&gt;\r\n			&lt;/div&gt;\r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n	&lt;div id=&quot;module_121361348&quot; style=&quot;color:#333333;font-family:Arial, Helvetica, sans-serif;background-color:#FFFFFF;&quot;&gt;\r\n		&lt;div class=&quot;layout770&quot;&gt;\r\n			&lt;div class=&quot;yhd-sm-shop-user-define shop-moudle mt10&quot; style=&quot;background:none;&quot;&gt;\r\n				&lt;div class=&quot;shop-con&quot; style=&quot;border:0px none;background:inherit;&quot;&gt;\r\n					&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; height=&quot;1422&quot; id=&quot;__01&quot; width=&quot;770&quot; class=&quot;ke-zeroborder&quot;&gt;\r\n						&lt;tbody&gt;\r\n							&lt;tr&gt;\r\n								&lt;td colspan=&quot;4&quot;&gt;\r\n									&lt;img alt=&quot;&quot; src=&quot;http://d8.yihaodianimg.com/N10/M09/29/B2/ChEi2lkmP46AKqEAAAQYWfLAIj402900.webp&quot; style=&quot;width:770px;height:383px;&quot; /&gt;\r\n								&lt;/td&gt;\r\n							&lt;/tr&gt;\r\n						&lt;/tbody&gt;\r\n					&lt;/table&gt;\r\n				&lt;/div&gt;\r\n			&lt;/div&gt;\r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(88,	88,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; width=&quot;750&quot; style=&quot;color:#333333;font-family:\'microsoft yahei\';font-size:14px;&quot; class=&quot;ke-zeroborder&quot;&gt;\r\n		&lt;tbody&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n					&lt;a href=&quot;http://t.yhd.com/detail/4577215&quot; target=&quot;_blank&quot;&gt;&lt;img src=&quot;http://d8.yihaodianimg.com/N09/M07/07/12/ChEi2FkniPmAdTHAAAKksPed3Lg13900.webp&quot; style=&quot;width:750px;height:300px;&quot; /&gt;&lt;/a&gt;\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n		&lt;/tbody&gt;\r\n	&lt;/table&gt;\r\n	&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; height=&quot;186&quot; width=&quot;750&quot; style=&quot;color:#333333;font-family:\'microsoft yahei\';font-size:14px;&quot; class=&quot;ke-zeroborder&quot;&gt;\r\n		&lt;tbody&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n					&lt;a href=&quot;http://coupon.yhd.com/merchantCoupon/couponReceiveN-423-465196956-af5c9296abc5f3c15404&quot; target=&quot;_blank&quot;&gt;&lt;img src=&quot;http://d9.yihaodianimg.com/N10/M02/1B/00/ChEi2lkdVZuAdk3kAABC7x7mU1g08700.webp&quot; style=&quot;width:198px;height:80px;&quot; /&gt;&lt;/a&gt;\r\n				&lt;/td&gt;\r\n				&lt;td rowspan=&quot;2&quot;&gt;\r\n					&lt;a href=&quot;http://item.yhd.com/item/61158683?ref=ad.14427_146225_471742_392380_5266_52588975_4_423_7_61158683_1_1_7018200_423_4_1.886775_0.0&amp;amp;tc=13.0.12.61158683.1&amp;amp;tp=52.5266.108.31.1.Ll90s0W-10-FKvAo&amp;amp;ti=5Y6WXF&quot; target=&quot;&quot;&gt;&lt;img src=&quot;http://d8.yihaodianimg.com/N09/M08/F3/81/ChEi2Fkeq8OABuxdAACTOgj3jTE94600.webp&quot; style=&quot;width:276px;height:186px;&quot; /&gt;&lt;/a&gt;\r\n				&lt;/td&gt;\r\n				&lt;td rowspan=&quot;2&quot;&gt;\r\n					&lt;a href=&quot;http://item.yhd.com/item/61158683?ref=ad.14427_146225_471742_392380_5266_52588975_4_423_7_61158683_1_1_7018200_423_4_1.886775_0.0&amp;amp;tc=13.0.12.61158683.1&amp;amp;tp=52.5266.108.31.1.Ll90s0W-10-FKvAo&amp;amp;ti=5Y6WXF&quot; target=&quot;&quot;&gt;&lt;img src=&quot;http://d8.yihaodianimg.com/N10/M04/2A/FC/ChEi3Fkeq9WAQK3bAACWjfZVscg02100.webp&quot; style=&quot;width:276px;height:186px;&quot; /&gt;&lt;/a&gt;\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n					&lt;a href=&quot;http://coupon.yhd.com/merchantCoupon/couponReceiveN-423-465197361-4e89bcdd791dbc73b813&quot; target=&quot;_blank&quot;&gt;&lt;img src=&quot;http://d9.yihaodianimg.com/N09/M08/7E/90/ChEi2VkdVZuAEi5wAABQ44haMn830100.webp&quot; style=&quot;width:198px;height:106px;&quot; /&gt;&lt;/a&gt;&lt;br /&gt;\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n		&lt;/tbody&gt;\r\n	&lt;/table&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(89,	89,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div id=&quot;module_121361352&quot; style=&quot;color:#333333;font-family:\'microsoft yahei\';font-size:14px;&quot;&gt;\r\n		&lt;div class=&quot;layout770&quot;&gt;\r\n			&lt;div class=&quot;yhd-sm-shop-user-define shop-moudle mt10&quot;&gt;\r\n				&lt;div class=&quot;shop-con&quot; style=&quot;border:0px none;&quot;&gt;\r\n					&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; height=&quot;208&quot; id=&quot;__01&quot; width=&quot;770&quot; class=&quot;ke-zeroborder&quot;&gt;\r\n						&lt;tbody&gt;\r\n							&lt;tr&gt;\r\n								&lt;td&gt;\r\n									&lt;a href=&quot;http://t.yhd.com/detailBrand/42846&quot; target=&quot;_blank&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;http://d8.yihaodianimg.com/N08/M04/2D/20/ChEi1lkifs-AC9_UAADZQr8NNEk31000.webp&quot; style=&quot;width:239px;height:208px;&quot; /&gt;&lt;/a&gt;\r\n								&lt;/td&gt;\r\n								&lt;td&gt;\r\n									&lt;a href=&quot;http://t.yhd.com/detailBrand/42846&quot; target=&quot;_blank&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;http://d8.yihaodianimg.com/N10/M00/2F/2F/ChEi21kifs-AWVgiAAFIgSGo1oU51900.webp&quot; style=&quot;width:274px;height:208px;&quot; /&gt;&lt;/a&gt;\r\n								&lt;/td&gt;\r\n								&lt;td&gt;\r\n									&lt;a href=&quot;http://t.yhd.com/detailBrand/42846&quot; target=&quot;_blank&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;http://d9.yihaodianimg.com/N11/M02/C5/51/ChEwoFkifs-AdukzAADyusrKhRY03800.webp&quot; style=&quot;width:257px;height:208px;&quot; /&gt;&lt;/a&gt;\r\n								&lt;/td&gt;\r\n							&lt;/tr&gt;\r\n						&lt;/tbody&gt;\r\n					&lt;/table&gt;\r\n				&lt;/div&gt;\r\n			&lt;/div&gt;\r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n	&lt;div id=&quot;module_121361348&quot; style=&quot;color:#333333;font-family:\'microsoft yahei\';font-size:14px;&quot;&gt;\r\n		&lt;div class=&quot;layout770&quot;&gt;\r\n			&lt;div class=&quot;yhd-sm-shop-user-define shop-moudle mt10&quot;&gt;\r\n				&lt;div class=&quot;shop-con&quot; style=&quot;border:0px none;&quot;&gt;\r\n					&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; height=&quot;1422&quot; id=&quot;__01&quot; width=&quot;770&quot; class=&quot;ke-zeroborder&quot;&gt;\r\n						&lt;tbody&gt;\r\n							&lt;tr&gt;\r\n								&lt;td colspan=&quot;4&quot;&gt;\r\n									&lt;img alt=&quot;&quot; src=&quot;http://d8.yihaodianimg.com/N10/M09/29/B2/ChEi2lkmP46AKqEAAAQYWfLAIj402900.webp&quot; style=&quot;width:770px;height:383px;&quot; /&gt;\r\n								&lt;/td&gt;\r\n							&lt;/tr&gt;\r\n						&lt;/tbody&gt;\r\n					&lt;/table&gt;\r\n				&lt;/div&gt;\r\n			&lt;/div&gt;\r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(90,	90,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div id=&quot;module_121361352&quot; style=&quot;color:#333333;font-family:Arial, Helvetica, sans-serif;background-color:#FFFFFF;&quot;&gt;\r\n		&lt;div class=&quot;layout770&quot;&gt;\r\n			&lt;div class=&quot;yhd-sm-shop-user-define shop-moudle mt10&quot; style=&quot;background:none;&quot;&gt;\r\n				&lt;div class=&quot;shop-con&quot; style=&quot;border:0px none;background:inherit;&quot;&gt;\r\n					&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; height=&quot;208&quot; id=&quot;__01&quot; width=&quot;770&quot; class=&quot;ke-zeroborder&quot;&gt;\r\n						&lt;tbody&gt;\r\n							&lt;tr&gt;\r\n								&lt;td&gt;\r\n									&lt;a href=&quot;http://t.yhd.com/detailBrand/42846&quot; target=&quot;_blank&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;http://d8.yihaodianimg.com/N08/M04/2D/20/ChEi1lkifs-AC9_UAADZQr8NNEk31000.webp&quot; style=&quot;width:239px;height:208px;&quot; /&gt;&lt;/a&gt; \r\n								&lt;/td&gt;\r\n								&lt;td&gt;\r\n									&lt;a href=&quot;http://t.yhd.com/detailBrand/42846&quot; target=&quot;_blank&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;http://d8.yihaodianimg.com/N10/M00/2F/2F/ChEi21kifs-AWVgiAAFIgSGo1oU51900.webp&quot; style=&quot;width:274px;height:208px;&quot; /&gt;&lt;/a&gt; \r\n								&lt;/td&gt;\r\n								&lt;td&gt;\r\n									&lt;a href=&quot;http://t.yhd.com/detailBrand/42846&quot; target=&quot;_blank&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;http://d9.yihaodianimg.com/N11/M02/C5/51/ChEwoFkifs-AdukzAADyusrKhRY03800.webp&quot; style=&quot;width:257px;height:208px;&quot; /&gt;&lt;/a&gt; \r\n								&lt;/td&gt;\r\n							&lt;/tr&gt;\r\n						&lt;/tbody&gt;\r\n					&lt;/table&gt;\r\n				&lt;/div&gt;\r\n			&lt;/div&gt;\r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n	&lt;div id=&quot;module_121361348&quot; style=&quot;color:#333333;font-family:Arial, Helvetica, sans-serif;background-color:#FFFFFF;&quot;&gt;\r\n		&lt;div class=&quot;layout770&quot;&gt;\r\n			&lt;div class=&quot;yhd-sm-shop-user-define shop-moudle mt10&quot; style=&quot;background:none;&quot;&gt;\r\n				&lt;div class=&quot;shop-con&quot; style=&quot;border:0px none;background:inherit;&quot;&gt;\r\n					&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; height=&quot;1422&quot; id=&quot;__01&quot; width=&quot;770&quot; class=&quot;ke-zeroborder&quot;&gt;\r\n						&lt;tbody&gt;\r\n							&lt;tr&gt;\r\n								&lt;td colspan=&quot;4&quot;&gt;\r\n									&lt;img alt=&quot;&quot; src=&quot;http://d8.yihaodianimg.com/N10/M09/29/B2/ChEi2lkmP46AKqEAAAQYWfLAIj402900.webp&quot; style=&quot;width:770px;height:383px;&quot; /&gt; \r\n								&lt;/td&gt;\r\n							&lt;/tr&gt;\r\n						&lt;/tbody&gt;\r\n					&lt;/table&gt;\r\n				&lt;/div&gt;\r\n			&lt;/div&gt;\r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(91,	91,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; width=&quot;750 &quot; style=&quot;color:#333333;font-family:\'microsoft yahei\';font-size:14px;&quot; class=&quot;ke-zeroborder&quot;&gt;\r\n		&lt;tbody&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n					&lt;img border=&quot;0&quot; height=&quot;68&quot; src=&quot;http://d6.yihaodianimg.com/N04/M02/10/A0/ChEiBlfjccSAa9fdAADxB6ZxplQ78500.webp&quot; width=&quot;750&quot; /&gt;\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n					&lt;img border=&quot;0&quot; height=&quot;384&quot; src=&quot;http://d7.yihaodianimg.com/N11/M05/0A/F1/ChEwoVi1FtSAS5ZyAASWQrtfDns08500.webp&quot; width=&quot;750&quot; /&gt;\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n					&lt;img border=&quot;0&quot; height=&quot;169&quot; src=&quot;http://d9.yihaodianimg.com/N10/M09/68/1A/ChEi2li1FtSAMw8EAAFUoOkDAm460600.webp&quot; width=&quot;750&quot; /&gt;\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n					&lt;img border=&quot;0&quot; height=&quot;79&quot; src=&quot;http://d7.yihaodianimg.com/N10/M05/75/7B/ChEi3Fi1FtSAB2eLAADZPE4x1Kk76000.webp&quot; width=&quot;750&quot; /&gt;\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n					&lt;img border=&quot;0&quot; height=&quot;113&quot; src=&quot;http://d9.yihaodianimg.com/N08/M09/72/EF/ChEi1Fi1FtWAZxxpAAEkvbbxKSo02700.webp&quot; width=&quot;750&quot; /&gt;\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n					&lt;img border=&quot;0&quot; height=&quot;184&quot; src=&quot;http://d9.yihaodianimg.com/N11/M0A/0D/A8/ChEwoli1FtaAGAXnAAJaFZirZcY93900.webp&quot; width=&quot;750&quot; /&gt;\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n					&lt;img border=&quot;0&quot; height=&quot;187&quot; src=&quot;http://d9.yihaodianimg.com/N11/M0B/0D/77/ChEwoFi1FtaAHYx3AAJft-Cslrw83800.webp&quot; width=&quot;750&quot; /&gt;\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n		&lt;/tbody&gt;\r\n	&lt;/table&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(92,	92,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;img src=&quot;http://d6.yihaodianimg.com/N05/M07/ED/B6/CgQI0ldNZ6uAdqm5AAC6a5CQ1Ug45200.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(93,	93,	'&lt;p style=&quot;text-align:center;&quot;&gt;\r\n	&lt;img src=&quot;http://d10.yihaodianimg.com/N09/M00/28/DB/ChEi2FgUL6aARG_cAAC0FNjRkLo67000.jpg&quot; /&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:center;&quot;&gt;\r\n	&lt;img src=&quot;http://d10.yihaodianimg.com/N09/M06/29/12/ChEi11gUL6uAWorJAACp2DiQiCE38400.jpg&quot; /&gt;\r\n&lt;/p&gt;',	'',	'',	''),
(94,	94,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;img src=&quot;/uploads/image/20170527/592942f0795a7.jpg&quot; alt=&quot;&quot; /&gt;&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(95,	95,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;http://d8.yihaodianimg.com/N09/M0B/BA/5D/ChEi11ikGsCAWTXSAAIMEOJDl7463700.jpg&quot; style=&quot;width:750px;height:1044px;&quot; /&gt;&lt;img alt=&quot;&quot; src=&quot;http://d9.yihaodianimg.com/N09/M09/BA/31/ChEi2FikGsSAI4-YAAI8aZu1X6g35000.jpg&quot; /&gt;&lt;img alt=&quot;&quot; src=&quot;http://d9.yihaodianimg.com/N10/M02/58/04/ChEi3FikGsiARM7uAAEHxyfI7NI39300.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(96,	96,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;img class=&quot;img-ks-lazyload&quot; alt=&quot;&quot; src=&quot;http://img.alicdn.com/imgextra/i2/263817957/TB2K.VYhMFkpuFjSspnXXb4qFXa-263817957.jpg&quot; /&gt;&lt;img class=&quot;img-ks-lazyload&quot; alt=&quot;&quot; src=&quot;http://img.alicdn.com/imgextra/i4/263817957/TB2OqxAhMNlpuFjy0FfXXX3CpXa-263817957.jpg&quot; /&gt;&lt;img class=&quot;img-ks-lazyload&quot; alt=&quot;&quot; src=&quot;http://img.alicdn.com/imgextra/i4/263817957/TB2dokXdTcCL1FjSZFPXXXZgpXa-263817957.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img class=&quot;img-ks-lazyload&quot; alt=&quot;&quot; src=&quot;http://img.alicdn.com/imgextra/i3/263817957/TB2VIRtdbBnpuFjSZFGXXX51pXa-263817957.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(97,	97,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;p style=&quot;color:#333333;font-family:\'microsoft yahei\';font-size:14px;&quot;&gt;\r\n		&lt;img align=&quot;absmiddle&quot; alt=&quot;&quot; src=&quot;http://d6.yihaodianimg.com/N02/M04/A3/EE/ChEiBFe1bKOAGgvWAAL-MePRDOU45500.jpg&quot; /&gt; \r\n	&lt;/p&gt;\r\n	&lt;p style=&quot;color:#333333;font-family:\'microsoft yahei\';font-size:14px;&quot;&gt;\r\n		&amp;nbsp;\r\n	&lt;/p&gt;\r\n	&lt;p style=&quot;color:#333333;font-family:\'microsoft yahei\';font-size:14px;&quot;&gt;\r\n		&amp;nbsp;\r\n	&lt;/p&gt;\r\n	&lt;p style=&quot;color:#333333;font-family:\'microsoft yahei\';font-size:14px;&quot;&gt;\r\n		&amp;nbsp;\r\n	&lt;/p&gt;\r\n	&lt;p style=&quot;color:#333333;font-family:\'microsoft yahei\';font-size:14px;&quot;&gt;\r\n		&lt;br /&gt;\r\n&lt;img align=&quot;absmiddle&quot; alt=&quot;&quot; src=&quot;http://d7.yihaodianimg.com/N10/M06/5B/99/ChEi21e1bKaAKcqgAAF94TSgGNs09900.jpg&quot; /&gt; \r\n	&lt;/p&gt;\r\n	&lt;p style=&quot;color:#333333;font-family:\'microsoft yahei\';font-size:14px;&quot;&gt;\r\n		&amp;nbsp;\r\n	&lt;/p&gt;\r\n	&lt;p style=&quot;color:#333333;font-family:\'microsoft yahei\';font-size:14px;&quot;&gt;\r\n		&amp;nbsp;\r\n	&lt;/p&gt;\r\n	&lt;p style=&quot;color:#333333;font-family:\'microsoft yahei\';font-size:14px;&quot;&gt;\r\n		&lt;br /&gt;\r\n&lt;img align=&quot;absmiddle&quot; alt=&quot;&quot; src=&quot;http://d6.yihaodianimg.com/N04/M09/95/AF/ChEiBle1bKuAGYZpAALxRB9QMXU46900.jpg&quot; /&gt; \r\n	&lt;/p&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(98,	98,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;http://d9.yihaodianimg.com/N08/M06/73/59/ChEi1lgz9UuAO_QqAAC6bEInglU67400.jpg&quot; /&gt;&lt;span style=&quot;color:#333333;font-family:\'microsoft yahei\';font-size:14px;line-height:normal;&quot;&gt;&lt;/span&gt;&lt;img alt=&quot;&quot; src=&quot;http://d10.yihaodianimg.com/N09/M08/74/A0/ChEi11gz9U-AcSM5AAC1gtWMQps28700.jpg&quot; /&gt;&lt;span style=&quot;color:#333333;font-family:\'microsoft yahei\';font-size:14px;line-height:normal;&quot;&gt;&lt;/span&gt;&lt;img alt=&quot;&quot; src=&quot;http://d7.yihaodianimg.com/N10/M01/75/84/ChEi21gz9VSAJjn1AAEcMLyUslg92000.jpg&quot; /&gt;&lt;span style=&quot;color:#333333;font-family:\'microsoft yahei\';font-size:14px;line-height:normal;&quot;&gt;&lt;/span&gt;&lt;img alt=&quot;&quot; src=&quot;http://d7.yihaodianimg.com/N10/M0B/68/20/ChEi2lgz9VeASW0eAAEAaaE3NG870700.jpg&quot; /&gt;&lt;span style=&quot;color:#333333;font-family:\'microsoft yahei\';font-size:14px;line-height:normal;&quot;&gt;&lt;/span&gt;&lt;img alt=&quot;&quot; src=&quot;http://d7.yihaodianimg.com/N10/M07/75/85/ChEi21gz9V2AdVA_AAD4_qfsZRU26900.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(99,	99,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div style=&quot;margin:0px auto;padding:0px;color:#333333;font-family:\'microsoft yahei\';font-size:14px;&quot;&gt;\r\n		&lt;p&gt;\r\n			&lt;img class=&quot;img-ks-lazyload&quot; alt=&quot;&quot; src=&quot;http://img.alicdn.com/imgextra/i4/263817957/TB2BqzthHBkpuFjy1zkXXbSpFXa-263817957.jpg&quot; /&gt; \r\n		&lt;/p&gt;\r\n	&lt;/div&gt;\r\n&lt;img class=&quot;desc_anchor img-ks-lazyload&quot; id=&quot;desc-module-2&quot; alt=&quot;&quot; src=&quot;http://assets.alicdn.com/kissy/1.0.0/build/imglazyload/spaceball.gif&quot; /&gt;&lt;span style=&quot;color:#333333;font-family:\'microsoft yahei\';font-size:14px;line-height:normal;&quot;&gt;&lt;/span&gt; \r\n	&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; width=&quot;750&quot; style=&quot;margin:0px auto 20px;padding:0px;font-family:\'microsoft yahei\';text-align:center;color:#5C5C5C;font-size:20px;background:#FFFFFF;&quot; class=&quot;ke-zeroborder&quot;&gt;\r\n		&lt;tbody&gt;\r\n			&lt;tr&gt;\r\n				&lt;td colspan=&quot;2&quot; style=&quot;font-size:25px;color:#000000;&quot;&gt;\r\n					产品信息\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td width=&quot;111&quot; style=&quot;color:#000000;&quot;&gt;\r\n					货号\r\n				&lt;/td&gt;\r\n				&lt;td align=&quot;left&quot;&gt;\r\n					AA7152\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td style=&quot;color:#000000;&quot;&gt;\r\n					尺码\r\n				&lt;/td&gt;\r\n				&lt;td align=&quot;left&quot;&gt;\r\n					S M L\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td style=&quot;color:#000000;&quot;&gt;\r\n					颜色\r\n				&lt;/td&gt;\r\n				&lt;td align=&quot;left&quot;&gt;\r\n					粉色A 抹茶绿色A\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td style=&quot;color:#000000;&quot;&gt;\r\n					成分\r\n				&lt;/td&gt;\r\n				&lt;td align=&quot;left&quot;&gt;\r\n					95%棉5%氨纶\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td style=&quot;color:#000000;&quot;&gt;\r\n					季节\r\n				&lt;/td&gt;\r\n				&lt;td align=&quot;left&quot;&gt;\r\n					春季 夏季 秋季\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n		&lt;/tbody&gt;\r\n	&lt;/table&gt;\r\n	&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; width=&quot;750&quot; style=&quot;margin:0px auto 40px;padding:0px;font-family:\'microsoft yahei\';text-align:center;color:#5C5C5C;font-size:20px;background:#FFFFFF;&quot; class=&quot;ke-zeroborder&quot;&gt;\r\n		&lt;tbody&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td width=&quot;80&quot;&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td width=&quot;80&quot;&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td width=&quot;80&quot;&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td width=&quot;10&quot;&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td style=&quot;color:#000000;&quot;&gt;\r\n					面料弹性\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					无弹性\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td bgcolor=&quot;#CCCCCC&quot;&gt;\r\n					轻微弹性\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td bgcolor=&quot;#FFFFFF&quot;&gt;\r\n					高弹力\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td colspan=&quot;8&quot;&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td style=&quot;color:#000000;&quot;&gt;\r\n					厚薄指数\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					厚款\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td bgcolor=&quot;#d6d6d6&quot;&gt;\r\n					厚薄适中\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					薄款\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td colspan=&quot;8&quot;&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td style=&quot;color:#000000;&quot;&gt;\r\n					版型\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					紧身\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					修身\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td bgcolor=&quot;#d6d6d6&quot;&gt;\r\n					宽松\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td colspan=&quot;8&quot;&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td style=&quot;color:#000000;&quot;&gt;\r\n					长度\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					短款\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td bgcolor=&quot;#d6d6d6&quot;&gt;\r\n					长度适中\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					长款\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n		&lt;/tbody&gt;\r\n	&lt;/table&gt;\r\n	&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; width=&quot;750&quot; style=&quot;margin:0px auto 40px;padding:0px;color:#333333;font-family:\'microsoft yahei\';font-size:20px;text-align:center;background:#FFFFFF;&quot; class=&quot;ke-zeroborder&quot;&gt;\r\n		&lt;tbody&gt;\r\n			&lt;tr&gt;\r\n				&lt;td colspan=&quot;2&quot; style=&quot;font-size:25px;color:#000000;&quot;&gt;\r\n					尺码说明\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n					&lt;img alt=&quot;&quot; class=&quot;img-ks-lazyload&quot; src=&quot;http://img.alicdn.com/imgextra/i4/263817957/TB2LnjIgodnpuFjSZPhXXbChpXa-263817957.png&quot; /&gt; \r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; width=&quot;100%&quot; style=&quot;margin:0px;padding:0px;font-family:\'microsoft yahei\';font-size:20px;color:#333333;&quot; class=&quot;ke-zeroborder&quot;&gt;\r\n						&lt;tbody&gt;\r\n							&lt;tr&gt;\r\n								&lt;td align=&quot;center&quot; width=&quot;30&quot;&gt;\r\n									1.\r\n								&lt;/td&gt;\r\n								&lt;td&gt;\r\n									肩宽（平铺后左肩端点到右肩端点的距离）\r\n								&lt;/td&gt;\r\n							&lt;/tr&gt;\r\n							&lt;tr&gt;\r\n								&lt;td align=&quot;center&quot;&gt;\r\n									2.\r\n								&lt;/td&gt;\r\n								&lt;td&gt;\r\n									胸围/2（平铺腋下直量）\r\n								&lt;/td&gt;\r\n							&lt;/tr&gt;\r\n							&lt;tr&gt;\r\n								&lt;td align=&quot;center&quot;&gt;\r\n									3.\r\n								&lt;/td&gt;\r\n								&lt;td&gt;\r\n									袖长（肩端点至袖口直量）\r\n								&lt;/td&gt;\r\n							&lt;/tr&gt;\r\n							&lt;tr&gt;\r\n								&lt;td align=&quot;center&quot;&gt;\r\n									4.\r\n								&lt;/td&gt;\r\n								&lt;td&gt;\r\n									前衣长（肩颈点至前下摆底端的垂直长度）\r\n								&lt;/td&gt;\r\n							&lt;/tr&gt;\r\n							&lt;tr&gt;\r\n								&lt;td align=&quot;center&quot;&gt;\r\n									5.\r\n								&lt;/td&gt;\r\n								&lt;td&gt;\r\n									后中长（后领中底部至下摆的垂直长度）\r\n								&lt;/td&gt;\r\n							&lt;/tr&gt;\r\n							&lt;tr&gt;\r\n								&lt;td align=&quot;center&quot;&gt;\r\n									6.\r\n								&lt;/td&gt;\r\n								&lt;td&gt;\r\n									下摆围/2（底摆左至右平量）\r\n								&lt;/td&gt;\r\n							&lt;/tr&gt;\r\n						&lt;/tbody&gt;\r\n					&lt;/table&gt;\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n		&lt;/tbody&gt;\r\n	&lt;/table&gt;\r\n	&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; width=&quot;750&quot; style=&quot;margin:0px auto 40px;padding:0px;color:#333333;font-family:\'microsoft yahei\';font-size:20px;text-align:center;background:#FFFFFF;&quot; class=&quot;ke-zeroborder&quot;&gt;\r\n		&lt;tbody&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n					上衣尺码\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					肩宽\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					胸围\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					下摆围\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					衣长\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					袖长\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					袖肥\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					袖口底摆围\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n					S\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					36.5\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					90\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					90\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					59.5\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					22\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					30.6\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					71\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n					M\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					37.5\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					94\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					94\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					61\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					23.5\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					32\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					72\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td&gt;\r\n					L\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					38.5\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					98\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					98\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					62.5\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					25\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					33.4\r\n				&lt;/td&gt;\r\n				&lt;td&gt;\r\n					73\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n		&lt;/tbody&gt;\r\n	&lt;/table&gt;\r\n	&lt;table align=&quot;center&quot; border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; width=&quot;750&quot; style=&quot;margin:20px auto;padding:0px;color:#333333;font-family:\'microsoft yahei\';font-size:20px;text-align:center;border:1px solid #E6E6E6;background:#FFFFFF;&quot; class=&quot;ke-zeroborder&quot;&gt;\r\n		&lt;tbody&gt;\r\n			&lt;tr&gt;\r\n				&lt;td align=&quot;left&quot; bgcolor=&quot;#fff&quot; valign=&quot;top&quot; width=&quot;118&quot; style=&quot;border:1px solid #E6E6E6;font-size:16px;&quot;&gt;\r\n					&lt;span&gt;身高(cm)&lt;/span&gt;&lt;span&gt;体重(kg)&lt;/span&gt; \r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					150\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					153\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					155\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					158\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					160\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					163\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					165\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					168\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					170\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					41\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#D9D9D9;&quot;&gt;\r\n					S\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#D9D9D9;&quot;&gt;\r\n					S\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#D9D9D9;&quot;&gt;\r\n					S\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#D9D9D9;&quot;&gt;\r\n					S\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#D9D9D9;&quot;&gt;\r\n					S\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					43\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#D9D9D9;&quot;&gt;\r\n					S\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#D9D9D9;&quot;&gt;\r\n					S\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#D9D9D9;&quot;&gt;\r\n					S\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#D9D9D9;&quot;&gt;\r\n					S\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#D9D9D9;&quot;&gt;\r\n					S\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#D9D9D9;&quot;&gt;\r\n					S\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#D9D9D9;&quot;&gt;\r\n					S\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					45\r\n				&lt;/td&gt;\r\n				&lt;td bgcolor=&quot;#d9d9d9&quot; style=&quot;border:1px solid #E6E6E6;background:#BABABA;&quot;&gt;\r\n					M\r\n				&lt;/td&gt;\r\n				&lt;td bgcolor=&quot;#d9d9d9&quot; style=&quot;border:1px solid #E6E6E6;background:#D9D9D9;&quot;&gt;\r\n					S\r\n				&lt;/td&gt;\r\n				&lt;td bgcolor=&quot;#d9d9d9&quot; style=&quot;border:1px solid #E6E6E6;background:#D9D9D9;&quot;&gt;\r\n					S\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#D9D9D9;&quot;&gt;\r\n					S\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#D9D9D9;&quot;&gt;\r\n					S\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#D9D9D9;&quot;&gt;\r\n					S\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#D9D9D9;&quot;&gt;\r\n					S\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#D9D9D9;&quot;&gt;\r\n					S\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					47\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#BABABA;&quot;&gt;\r\n					M\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#BABABA;&quot;&gt;\r\n					S/M\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#BABABA;&quot;&gt;\r\n					S/M\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#BABABA;&quot;&gt;\r\n					S/M\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#D9D9D9;&quot;&gt;\r\n					S\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#D9D9D9;&quot;&gt;\r\n					S\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#D9D9D9;&quot;&gt;\r\n					S\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#D9D9D9;&quot;&gt;\r\n					S\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#D9D9D9;&quot;&gt;\r\n					S\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					49\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#BABABA;&quot;&gt;\r\n					M\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#BABABA;&quot;&gt;\r\n					M\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#BABABA;&quot;&gt;\r\n					M\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#BABABA;&quot;&gt;\r\n					M\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#BABABA;&quot;&gt;\r\n					M\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#BABABA;&quot;&gt;\r\n					M\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#D9D9D9;&quot;&gt;\r\n					S\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#D9D9D9;&quot;&gt;\r\n					S\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#D9D9D9;&quot;&gt;\r\n					S\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					51\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					L\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#BABABA;&quot;&gt;\r\n					M\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#BABABA;&quot;&gt;\r\n					M\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#BABABA;&quot;&gt;\r\n					M\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#BABABA;&quot;&gt;\r\n					M\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#BABABA;&quot;&gt;\r\n					M\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#BABABA;&quot;&gt;\r\n					M\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#BABABA;&quot;&gt;\r\n					S/M\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#BABABA;&quot;&gt;\r\n					S/M\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					53\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					L\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					L\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					L\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					M/L\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#BABABA;&quot;&gt;\r\n					M\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#BABABA;&quot;&gt;\r\n					M\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#BABABA;&quot;&gt;\r\n					M\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#BABABA;&quot;&gt;\r\n					M\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#BABABA;&quot;&gt;\r\n					M\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					55\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					L\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					L\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					L\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					L\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					M/L\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					M/L\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					M/L\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#BABABA;&quot;&gt;\r\n					M\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#BABABA;&quot;&gt;\r\n					M\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					57\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					L\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					L\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					L\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					L\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					L\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					L\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					L\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					M/L\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					M/L\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					59\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					L\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					L\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					L\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					L\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					L\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					L\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					L\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					L\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					61\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					L\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					L\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					L\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					L\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					L\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					63\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;&quot;&gt;\r\n					&amp;nbsp;\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					L\r\n				&lt;/td&gt;\r\n				&lt;td style=&quot;border:1px solid #E6E6E6;background:#8D8D8D;&quot;&gt;\r\n					L\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n			&lt;tr&gt;\r\n				&lt;td colspan=&quot;10&quot; style=&quot;border:1px solid #E6E6E6;text-align:left;font-size:18px;color:#5C5C5C;&quot;&gt;\r\n					温馨提示：由于个人体型差异及穿衣习惯的不同，此推荐表仅供参考，请亲们同时结合产品尺码表和自身习惯选择合适尺码。\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n		&lt;/tbody&gt;\r\n	&lt;/table&gt;\r\n&lt;img class=&quot;desc_anchor img-ks-lazyload&quot; id=&quot;desc-module-3&quot; alt=&quot;&quot; src=&quot;http://assets.alicdn.com/kissy/1.0.0/build/imglazyload/spaceball.gif&quot; /&gt;&lt;span style=&quot;color:#333333;font-family:\'microsoft yahei\';font-size:14px;line-height:normal;&quot;&gt;&lt;/span&gt; \r\n	&lt;div style=&quot;margin:0px auto;padding:0px;color:#333333;font-family:\'microsoft yahei\';font-size:14px;&quot;&gt;\r\n		&lt;img alt=&quot;AA7152-设计解读改_01.jpg&quot; class=&quot;img-ks-lazyload&quot; src=&quot;http://img.alicdn.com/imgextra/i4/263817957/TB2or1TqEhnpuFjSZFEXXX0PFXa-263817957.jpg&quot; /&gt;&lt;img alt=&quot;AA7152-设计解读改_02.jpg&quot; class=&quot;img-ks-lazyload&quot; src=&quot;http://img.alicdn.com/imgextra/i2/263817957/TB2F8WRqypnpuFjSZFIXXXh2VXa-263817957.jpg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div style=&quot;margin:0px auto;padding:0px;color:#333333;font-family:\'microsoft yahei\';font-size:14px;&quot;&gt;\r\n		&lt;img class=&quot;img-ks-lazyload&quot; alt=&quot;&quot; src=&quot;http://img.alicdn.com/imgextra/i1/263817957/TB2y0aZh5RnpuFjSZFCXXX2DXXa-263817957.jpg&quot; /&gt;&lt;img class=&quot;img-ks-lazyload&quot; alt=&quot;&quot; src=&quot;http://img.alicdn.com/imgextra/i1/263817957/TB2WGTqhM0kpuFjSspdXXX4YXXa-263817957.jpg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(100,	100,	'',	'',	'',	''),
(101,	101,	'',	'',	'',	''),
(102,	102,	'测试商品',	'',	'',	''),
(103,	103,	'1111',	'',	'',	''),
(104,	104,	'',	'',	'',	''),
(105,	105,	'11111111111',	'',	'',	''),
(106,	106,	'&lt;div id=&quot;attributes&quot; class=&quot;attributes&quot; style=&quot;padding:10px;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;ul class=&quot;attributes-list&quot;&gt;\r\n		&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n			流行元素:&amp;nbsp;3D 印花\r\n		&lt;/li&gt;\r\n		&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n			袖长:&amp;nbsp;短袖\r\n		&lt;/li&gt;\r\n		&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n			服装版型:&amp;nbsp;宽松\r\n		&lt;/li&gt;\r\n		&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n			衣长:&amp;nbsp;常规款\r\n		&lt;/li&gt;\r\n		&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n			领型:&amp;nbsp;圆领\r\n		&lt;/li&gt;\r\n		&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n			袖型:&amp;nbsp;常规\r\n		&lt;/li&gt;\r\n		&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n			成分含量:&amp;nbsp;96%及以上\r\n		&lt;/li&gt;\r\n		&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n			面料:&amp;nbsp;棉\r\n		&lt;/li&gt;\r\n		&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n			图案:&amp;nbsp;几何图案 字母 拼色\r\n		&lt;/li&gt;\r\n		&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n			风格:&amp;nbsp;通勤\r\n		&lt;/li&gt;\r\n		&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n			通勤:&amp;nbsp;韩版\r\n		&lt;/li&gt;\r\n		&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n			年份季节:&amp;nbsp;2017年夏季\r\n		&lt;/li&gt;\r\n		&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n			主要颜色:&amp;nbsp;白色 灰色 黑色\r\n		&lt;/li&gt;\r\n		&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n			尺码:&amp;nbsp;S M L XL\r\n		&lt;/li&gt;\r\n	&lt;/ul&gt;\r\n&lt;/div&gt;\r\n&lt;div id=&quot;tad_second_area&quot; class=&quot;tad-stage&quot; style=&quot;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;\r\n&lt;/div&gt;\r\n&lt;div id=&quot;description&quot; class=&quot;J_DetailSection tshop-psm ke-post&quot; style=&quot;font-size:14px;font-family:tahoma, arial, 宋体, sans-serif;background:#FFFFFF !important;&quot;&gt;\r\n	&lt;p&gt;\r\n		&lt;br /&gt;\r\n	&lt;/p&gt;\r\n	&lt;p&gt;\r\n		&amp;nbsp;\r\n	&lt;/p&gt;\r\n	&lt;p&gt;\r\n		S &amp;nbsp; &amp;nbsp; 胸围：94cm &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;衣长：64cm\r\n	&lt;/p&gt;\r\n	&lt;p&gt;\r\n		&lt;span style=&quot;line-height:1.5;&quot;&gt;M &amp;nbsp; &amp;nbsp;胸围：98cm &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp; 衣长：65cm&lt;/span&gt; \r\n	&lt;/p&gt;\r\n	&lt;p&gt;\r\n		&lt;span style=&quot;line-height:1.5;&quot;&gt;L &amp;nbsp; &amp;nbsp; 胸围：102cm &amp;nbsp; &amp;nbsp; &amp;nbsp;衣长：66cm&lt;/span&gt; \r\n	&lt;/p&gt;\r\n	&lt;p&gt;\r\n		&lt;span style=&quot;line-height:1.5;&quot;&gt;XL &amp;nbsp; 胸围：106cm &amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;衣长：66cm&lt;/span&gt; \r\n	&lt;/p&gt;\r\n	&lt;p&gt;\r\n		&lt;span style=&quot;line-height:1.5;&quot;&gt;【正常尺码，稍宽松版型，可按照平时穿衣尺码拍，喜欢合身一些可以选择小一尺码】&lt;/span&gt; \r\n	&lt;/p&gt;\r\n	&lt;p&gt;\r\n		&lt;span style=&quot;line-height:1.5;&quot;&gt;&lt;img src=&quot;https://img.alicdn.com/imgextra/i4/930820988/TB2qxeBq80kpuFjSsziXXa.oVXa_!!930820988.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;/span&gt; \r\n	&lt;/p&gt;\r\n	&lt;p&gt;\r\n		&lt;br /&gt;\r\n	&lt;/p&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(107,	107,	'测试',	'',	'',	''),
(108,	108,	'11',	'',	'',	''),
(109,	109,	'',	'',	'',	''),
(110,	110,	'',	'',	'',	''),
(111,	111,	'',	'',	'',	''),
(112,	112,	'',	'',	'',	''),
(113,	113,	'',	'',	'',	''),
(114,	114,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/87/34e45408-79ea-4f95-9205-1a499ee16417.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/25/2d40a59c-05b9-4563-8d7b-9be4ce56427d.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/15/6213aa96-0bee-43de-8e16-0e3d8af4df43.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/97/10d47807-f4d1-4604-b709-ac8e72f9450e.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(115,	115,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/4/01ec4bb3-5bbf-4e8b-bdcf-ea8425428d4b.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/169/c9f03718-bc37-4f5c-aa72-8ca5e3a12ff6.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/159/9d343ec7-8e36-4c6d-a11b-8b094d49fdcf.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/189/c7af8633-74e8-48ca-be16-3a48e9f2cc5c.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/67/c8092082-770b-4628-b85e-1bdca80092d9.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(116,	116,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0705/37/101690f1-5518-4c7b-ab09-e6b7c8bd90d9.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0705/18/592527f5-601b-4b0d-a801-19e29f4ce726.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0705/57/1d18be7d-a756-41de-8832-870d520a4e0a.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0705/74/c305e6d1-ffa0-4b5d-9222-4394d05cb70f.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0705/151/57c4d8b9-3aa9-4045-b584-c9936f05fc1c.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(117,	117,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/87/34e45408-79ea-4f95-9205-1a499ee16417.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/25/2d40a59c-05b9-4563-8d7b-9be4ce56427d.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/15/6213aa96-0bee-43de-8e16-0e3d8af4df43.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(118,	118,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/60/b5125b90-6c96-446b-8b6a-f3e9f2a1b99a.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/157/e34a84d8-4a38-41ad-bb18-63062eac8f31.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/171/2d20b3fb-739e-4563-a712-b52e497a08f4.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/8/434a8c8f-57f3-41c6-9406-b1350326540c.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(119,	119,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/65/bd27681d-a041-4f0e-8fd1-24bed46aee79.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(120,	120,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/481/947/963565131596947481/4/8007150904860-601.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/481/947/963565131596947481/4/8007150904860-602.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/481/947/963565131596947481/4/8007150904860-603.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/481/947/963565131596947481/4/8007150904860-604.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/481/947/963565131596947481/4/8007150904860-605.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(121,	121,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/728/865/233137721633865728/3/8007150900326-601.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/728/865/233137721633865728/3/8007150900326-602.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/728/865/233137721633865728/3/8007150900326-603.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/728/865/233137721633865728/3/8007150900326-604.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/728/865/233137721633865728/3/8007150900326-605.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(122,	122,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/380/252/939921233553252380/4/8007150904808-601.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/380/252/939921233553252380/4/8007150904808-602.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/380/252/939921233553252380/4/8007150904808-603.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/380/252/939921233553252380/4/8007150904808-604.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/380/252/939921233553252380/4/8007150904808-605.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(123,	123,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/530/424/970883480991424530/4/8007150907557-601.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/530/424/970883480991424530/4/8007150907557-602.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/530/424/970883480991424530/4/8007150907557-603.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/530/424/970883480991424530/4/8007150907557-604.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/530/424/970883480991424530/4/8007150907557-605.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(124,	124,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/203/653/953150557458653203/4/8007150907175-601.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/203/653/953150557458653203/4/8007150907175-602.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/203/653/953150557458653203/4/8007150907175-603.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/203/653/953150557458653203/4/8007150907175-604.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/203/653/953150557458653203/4/8007150907175-605.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(125,	125,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2016/12/02/62/526dbc97-fc25-402c-b5e9-0d175b88a335.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2016/12/02/14/5b0c2366-e482-42e6-b095-6ea887fca3e0.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2016/12/02/32/cc3927c7-7f2e-4498-b37a-02c96db01d00.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(126,	126,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/2017/05/27/169/8759c182-5474-4cb1-bd29-d4e4cef9d5db.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/2017/05/27/13/c5168e9e-3c0e-497c-a4ad-24e38a97bb27.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/2017/05/27/153/9c40150c-7dd2-4fc0-8cf5-dd12f092a37e.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/2017/05/27/81/ec94c320-0833-4969-acae-473be654132f.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(127,	127,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/2017/06/22/134/bf42bb5f-5c2f-4495-954b-96c3c7c3b9db.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/2017/06/22/194/ab821bb7-a436-47f5-9829-e1b724afd4ee.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/2017/06/22/174/0f474e9a-1e91-44d9-ab8c-69a9c5f59fe3.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/2017/06/22/153/57661e48-7a5b-429c-93c4-5c59574cd865.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/2017/06/22/30/6e918908-ac5d-470e-ad8a-55d098bf8d9f.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(128,	128,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/2017/05/10/168/28e99c93-d481-40a6-ba3c-8c1af0cca56d.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/2017/05/10/151/9263e9bc-5f84-4189-9400-3068f4fc9e3e.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/2017/05/10/149/68905600-84e1-44cd-9627-f9dcd747a82a.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(129,	129,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/2017/03/30/97/bfbe7a1c-bf41-4e89-aaab-22d14532b81b.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/2017/03/30/188/4e7499b1-e1fe-4219-b062-77c274cd14d6.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/2017/03/30/72/07400e54-753d-4442-ae6a-a2b31a8a3c01.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(130,	130,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2017/06/15/31/8f6af7b2b95b4f1bb936d1659b90ecc2-651.jpg&quot; /&gt;&lt;span style=&quot;color:#333333;font-family:tahoma, arial, \'Hiragino Sans GB\', \'WenQuanYi Micro Hei\', 微软雅黑, 宋体, sans-serif;&quot;&gt;&lt;/span&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2017/06/14/133/99b86a311be04c289674961c4aca1856-651.jpg&quot; /&gt;&lt;span style=&quot;color:#333333;font-family:tahoma, arial, \'Hiragino Sans GB\', \'WenQuanYi Micro Hei\', 微软雅黑, 宋体, sans-serif;&quot;&gt;&lt;/span&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2017/06/14/97/8994564b4f76493bb701feb6b4d1fb14-651.jpg&quot; /&gt;&lt;span style=&quot;color:#333333;font-family:tahoma, arial, \'Hiragino Sans GB\', \'WenQuanYi Micro Hei\', 微软雅黑, 宋体, sans-serif;&quot;&gt;&lt;/span&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2017/06/14/156/8a67191388204ff2900d31c8bd8b252a-651.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(131,	131,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2017/06/15/78/8c9950d7fe7b4c58bf2139cf5a5a0109-651.jpg&quot; /&gt;&lt;span style=&quot;color:#333333;font-family:tahoma, arial, \'Hiragino Sans GB\', \'WenQuanYi Micro Hei\', 微软雅黑, 宋体, sans-serif;&quot;&gt;&lt;/span&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2017/06/14/159/0b61187d8ed44ff583faa5b98ee5e13a-651.jpg&quot; /&gt;&lt;span style=&quot;color:#333333;font-family:tahoma, arial, \'Hiragino Sans GB\', \'WenQuanYi Micro Hei\', 微软雅黑, 宋体, sans-serif;&quot;&gt;&lt;/span&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2017/06/14/179/d8a74d57205945f686e3ea696b5b31f2-651.jpg&quot; /&gt;&lt;span style=&quot;color:#333333;font-family:tahoma, arial, \'Hiragino Sans GB\', \'WenQuanYi Micro Hei\', 微软雅黑, 宋体, sans-serif;&quot;&gt;&lt;/span&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2017/06/14/169/4f062a7a5e584c40a5e8c38e4582d2ba-651.jpg&quot; /&gt;&lt;span style=&quot;color:#333333;font-family:tahoma, arial, \'Hiragino Sans GB\', \'WenQuanYi Micro Hei\', 微软雅黑, 宋体, sans-serif;&quot;&gt;&lt;/span&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2017/06/14/10/e55393a647534a33aa5fb425cf2a26cb-651.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(132,	132,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2017/06/15/120/889acb4247434a88b378ab6ecab35046-651.jpg&quot; /&gt;&lt;span style=&quot;color:#333333;font-family:tahoma, arial, \'Hiragino Sans GB\', \'WenQuanYi Micro Hei\', 微软雅黑, 宋体, sans-serif;&quot;&gt;&lt;/span&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2017/06/14/174/56402e4b20444b029ee1fc69943bbd5f-651.jpg&quot; /&gt;&lt;span style=&quot;color:#333333;font-family:tahoma, arial, \'Hiragino Sans GB\', \'WenQuanYi Micro Hei\', 微软雅黑, 宋体, sans-serif;&quot;&gt;&lt;/span&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2017/06/14/88/d940ce86fe8740ba8f237b83a87e87ba-651.jpg&quot; /&gt;&lt;span style=&quot;color:#333333;font-family:tahoma, arial, \'Hiragino Sans GB\', \'WenQuanYi Micro Hei\', 微软雅黑, 宋体, sans-serif;&quot;&gt;&lt;/span&gt;&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdcvis/2017/06/15/60/18056661531d48b2861237eb61d58ec2-651.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(133,	133,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdc/850/078/323209721712078850/5/1-UK-07-0018-601.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdc/850/078/323209721712078850/5/1-UK-07-0018-602.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdc/850/078/323209721712078850/5/1-UK-07-0018-603.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdc/850/078/323209721712078850/5/1-UK-07-0018-604.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;http://a.vpimg3.com/upload/merchandise/pdc/850/078/323209721712078850/5/1-UK-07-0018-605.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;\r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(134,	134,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/34/6f8f1033-875e-4e55-aa1f-fe27c65967d5.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/71/b685eb07-e8a1-40d8-9e91-ef217452c7ea.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/5/91197173-c773-4125-ae1a-ea28cb8c6b42.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(135,	135,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/169/6e978373-a453-40a6-9cbf-66e54a2bf8f0.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/110/ba0ff6d5-3c41-4f63-9f14-1cfbfbaca25a.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/170/6cf408d3-1176-4024-88d4-c2059a03c0f3.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(136,	136,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0705/52/5bb68603-06fd-44e4-89be-c372be45e41d.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0705/152/c425a410-8cda-4db1-a4f3-081851cef152.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0705/21/bb455fef-b0b3-478d-b7f8-ee60c7f3e0cb.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0705/157/237235ac-7c59-4141-b294-b4e138e97828.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(137,	137,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0705/181/bc5a3115-c402-4f1d-81ed-6d064b780194.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0705/154/2cfae726-b252-4629-ae37-75cdefd626f5.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0705/173/c54972c9-7384-44fa-9562-e28da6f7726b.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0705/125/77eb7fea-5760-4096-a453-57855ac05703.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(138,	138,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;FW-wrap fwr&quot; style=&quot;margin:0px auto;padding:0px;font-family:微软雅黑, sans-serif;color:#333333;&quot;&gt;\r\n		&lt;div id=&quot;J-FW-detail&quot; class=&quot;FW-detail clearfix J-data-module&quot; style=&quot;margin:0px 0px 30px;padding:0px;&quot;&gt;\r\n			&lt;div class=&quot;M-detail&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n				&lt;div class=&quot;M-detailCon&quot; style=&quot;margin:0px;padding:20px 0px 0px;font-size:14px;&quot;&gt;\r\n					&lt;div class=&quot;dc-img&quot; style=&quot;margin:0px;padding:20px 0px;&quot;&gt;\r\n						&lt;div class=&quot;dc-img-detail&quot; style=&quot;margin:0px 0px 20px;padding:10px 0px 0px;text-align:center;&quot;&gt;\r\n							&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n								&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/178/a93eed87-e4a8-4bab-9ca3-b799d50b172c.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n							&lt;/div&gt;\r\n							&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n								&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/12/aad57f0c-c2b0-472b-872e-10726b3548f8.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n							&lt;/div&gt;\r\n							&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n								&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/41/817bc9ce-d5bb-4b71-a7a7-80b15e2ab8a9.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n							&lt;/div&gt;\r\n							&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n								&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/12/169753af-d2fa-416c-81c2-1d75d0054cd1.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n							&lt;/div&gt;\r\n							&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n								&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/134/b1fade63-e6fb-4b4e-80d7-ddf94b754505.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n							&lt;/div&gt;\r\n							&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n								&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/194/02cc9bd8-7da7-4be5-a816-3786cc5979f0.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n							&lt;/div&gt;\r\n							&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n								&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/165/1d4e0f09-3afc-49a4-bc1d-8d7a8fe8ac64.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n							&lt;/div&gt;\r\n							&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n								&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/24/1c526f07-a40d-4aa8-acb0-f339eb80b867.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n							&lt;/div&gt;\r\n							&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n								&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/74/ff66cdcc-be48-47ba-aa38-bc1175a2599c.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n							&lt;/div&gt;\r\n						&lt;/div&gt;\r\n						&lt;div class=&quot;dc-img-con&quot; style=&quot;margin:0px;padding:0px;text-align:center;&quot;&gt;\r\n							&lt;img width=&quot;495&quot; height=&quot;626&quot; src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/105/f0aeb2db-d1b8-4165-a752-7d44a8413233.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;&amp;nbsp;&lt;img width=&quot;495&quot; height=&quot;626&quot; src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/135/0d97acf6-582c-4bc9-bf4a-34129bd3b60c.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;&lt;img width=&quot;495&quot; height=&quot;626&quot; src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/67/d7473c83-630a-442f-8ef0-9bb88ceb1885.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;&amp;nbsp;&lt;img width=&quot;495&quot; height=&quot;626&quot; src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/171/7770f9b3-7f60-4a23-b676-ca2f73681286.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n						&lt;/div&gt;\r\n						&lt;div class=&quot;dc-txt-con&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n						&lt;/div&gt;\r\n					&lt;/div&gt;\r\n				&lt;/div&gt;\r\n			&lt;/div&gt;\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;pro-comment J-detail-commentCnt&quot; id=&quot;J-FW-prdComment&quot; style=&quot;margin:0px 0px 20px;padding:0px;&quot;&gt;\r\n			&lt;div class=&quot;M-detailTitle&quot; style=&quot;margin:0px;padding:0px 0px 0px 15px;background-color:#EAE8EB;&quot;&gt;\r\n				&lt;h3 class=&quot;detail-title&quot; style=&quot;font-size:14px;font-weight:400;&quot;&gt;\r\n					商品评价\r\n				&lt;/h3&gt;\r\n			&lt;/div&gt;\r\n			&lt;div class=&quot;product-comment-content&quot; style=&quot;margin:0px;padding:0px 0px 20px;&quot;&gt;\r\n				&lt;div id=&quot;J-FW-prdCommentList&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n					&lt;div id=&quot;J_comment_summary_wrapper&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n					&lt;/div&gt;\r\n					&lt;div id=&quot;J_comment_tabs_wrapper&quot; class=&quot;comment-tabs-wrapper&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n					&lt;/div&gt;\r\n					&lt;div id=&quot;J_comment_list_wrapper&quot; class=&quot;comment-list-wrapper&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n						&lt;div class=&quot;product-hasnocoment&quot; style=&quot;margin:0px;padding:50px;text-align:center;vertical-align:top;&quot;&gt;\r\n							&lt;span class=&quot;vipFont if-sigh if-size-32&quot; style=&quot;font-family:vipFont;font-size:32px;color:#F9A123;vertical-align:middle;&quot;&gt;&lt;/span&gt;&amp;nbsp;&lt;span class=&quot;has-no-comment&quot; style=&quot;vertical-align:middle;&quot;&gt;暂时没有评价&lt;/span&gt; \r\n						&lt;/div&gt;\r\n					&lt;/div&gt;\r\n					&lt;div id=&quot;J_page_plugin_wrapper&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n					&lt;/div&gt;\r\n				&lt;/div&gt;\r\n			&lt;/div&gt;\r\n		&lt;/div&gt;\r\n		&lt;div id=&quot;J-footprint-mod&quot; class=&quot;g-footprint&quot; style=&quot;margin:0px 0px 32px;padding:0px;&quot;&gt;\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;FW-recomBox J-data-module clearfix&quot; id=&quot;J-FW-recomBox&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n			&lt;div class=&quot;recom-new-top clearfix&quot; id=&quot;J_recommend_goods_box&quot; style=&quot;margin:0px 0px 20px;padding:0px;&quot;&gt;\r\n			&lt;/div&gt;\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;FW-question J-data-module&quot; id=&quot;J-FW-question&quot; style=&quot;margin:0px 0px 30px;padding:0px;&quot;&gt;\r\n			&lt;div class=&quot;M-detailTitle&quot; style=&quot;margin:0px;padding:0px 0px 0px 15px;background-color:#EAE8EB;&quot;&gt;\r\n				&lt;h3 class=&quot;detail-title&quot; style=&quot;font-size:14px;font-weight:400;&quot;&gt;\r\n					商品咨询\r\n				&lt;/h3&gt;\r\n			&lt;/div&gt;\r\n			&lt;div class=&quot;M-question&quot; style=&quot;margin:0px;padding:35px 20px;&quot;&gt;\r\n				&lt;div class=&quot;q-tit&quot; style=&quot;margin:0px;padding:0px;font-weight:700;font-size:14px;&quot;&gt;\r\n					购买前如有问题，请向唯品会咨询。&lt;a href=&quot;https://acs.vip.com/&quot; class=&quot;q-tit-btn&quot; target=&quot;_blank&quot;&gt;&lt;span style=&quot;font-size:12px;color:#FB4892;&quot;&gt;联系客服&lt;/span&gt;&lt;/a&gt; \r\n				&lt;/div&gt;\r\n&lt;span class=&quot;qti-question&quot;&gt;&lt;/span&gt; \r\n				&lt;p class=&quot;qti-txt&quot; style=&quot;margin-left:25px;&quot;&gt;\r\n					商品都是正品吗？\r\n				&lt;/p&gt;\r\n&lt;span class=&quot;qti-answer&quot;&gt;&lt;/span&gt; \r\n				&lt;p class=&quot;qti-txt&quot; style=&quot;margin-left:25px;&quot;&gt;\r\n					请你放心，唯品会www.vip.com上所售卖的商品均确保正品，并由中国人民财产保险股份有限公司为你购买的每一件商品进行承保。\r\n				&lt;/p&gt;\r\n&lt;span class=&quot;qti-question&quot;&gt;&lt;/span&gt; \r\n				&lt;p class=&quot;qti-txt&quot; style=&quot;margin-left:25px;&quot;&gt;\r\n					衣服图片上搭配的腰带、项链等配件，会连商品一同送货吗？\r\n				&lt;/p&gt;\r\n&lt;span class=&quot;qti-answer&quot;&gt;&lt;/span&gt; \r\n				&lt;p class=&quot;qti-txt&quot; style=&quot;margin-left:25px;&quot;&gt;\r\n					这点请注意咯，如非特别说明，服装类商品图片中的腰带、饰品等配件均为拍摄搭配之用，是不包含在所售商品中的。\r\n				&lt;/p&gt;\r\n&lt;span class=&quot;qti-question&quot;&gt;&lt;/span&gt; \r\n				&lt;p class=&quot;qti-txt&quot; style=&quot;margin-left:25px;&quot;&gt;\r\n					尺码表上的尺码标准吗？\r\n				&lt;/p&gt;\r\n&lt;span class=&quot;qti-answer&quot;&gt;&lt;/span&gt; \r\n				&lt;p class=&quot;qti-txt&quot; style=&quot;margin-left:25px;&quot;&gt;\r\n					唯品会所售商品尺寸均为人工测量，可能会存在1-2cm的正常误差范围。\r\n				&lt;/p&gt;\r\n&lt;span class=&quot;qti-question&quot;&gt;&lt;/span&gt; \r\n				&lt;p class=&quot;qti-txt&quot; style=&quot;margin-left:25px;&quot;&gt;\r\n					图片颜色和实物颜色是否相同？\r\n				&lt;/p&gt;\r\n&lt;span class=&quot;qti-answer&quot;&gt;&lt;/span&gt; \r\n				&lt;p class=&quot;qti-txt&quot; style=&quot;margin-left:25px;&quot;&gt;\r\n					唯品会所有商品均采用专业拍摄，力求将最真实的信息传达至你的视线。但由于个人显示器不同，可能导致实物与图片存在色差，最终颜色以实物为准。\r\n				&lt;/p&gt;\r\n&lt;span class=&quot;qti-question&quot;&gt;&lt;/span&gt; \r\n				&lt;p class=&quot;qti-txt&quot; style=&quot;margin-left:25px;&quot;&gt;\r\n					为什么我收到的商品包装和图片显示的不一致？\r\n				&lt;/p&gt;\r\n&lt;span class=&quot;qti-answer&quot;&gt;&lt;/span&gt; \r\n				&lt;p class=&quot;qti-txt&quot; style=&quot;margin-left:25px;&quot;&gt;\r\n					由于部分商品生产批次不一，你收到货品的包装有可能与网站上图片不完全一致，但唯品会保证所售商品均为正品，商品包装请以实物为准。\r\n				&lt;/p&gt;\r\n&lt;span class=&quot;qti-question&quot;&gt;&lt;/span&gt; \r\n				&lt;p class=&quot;qti-txt&quot; style=&quot;margin-left:25px;&quot;&gt;\r\n					唯品会的对比价格：\r\n				&lt;/p&gt;\r\n&lt;span class=&quot;qti-answer&quot;&gt;&lt;/span&gt; \r\n				&lt;p class=&quot;qti-txt&quot; style=&quot;margin-left:25px;&quot;&gt;\r\n					唯品会展示的中间未划横线价格（显示如¥799）为唯品会销售价，该价格是交易成交价，是您最终决定是否购买商品的依据。&lt;br /&gt;\r\n唯品会展示的中间划横线价格（显示如&amp;nbsp;&lt;del&gt;¥2899&lt;/del&gt;）为参考价，采集自品牌专柜标价、商品吊牌价或由品牌供应商提供的正品零售价；由于地区、时间的差异性和市场行情波动，品牌专柜标价、商品吊牌价可能会与您购物时展示的不一致。该价格仅供您参考。&lt;br /&gt;\r\n折扣比为唯品会销售价与参考价的对比（该值四舍五入后采小数点后1位，如¥799/¥2899=0.2756=2.8折），该对比值仅供您参考，不作为结算基数。\r\n				&lt;/p&gt;\r\n&lt;span class=&quot;qti-question&quot;&gt;&lt;/span&gt; \r\n				&lt;p class=&quot;qti-txt&quot; style=&quot;margin-left:25px;&quot;&gt;\r\n					如何退货？\r\n				&lt;/p&gt;\r\n&lt;span class=&quot;qti-answer&quot;&gt;&lt;/span&gt; \r\n				&lt;p class=&quot;qti-txt&quot; style=&quot;margin-left:25px;&quot;&gt;\r\n					在你签收商品之日起的7天之内，唯品会为你提供七天无理由放心退服务，但以下情形将不能退货：1、非唯品会销售的商品，或有明显使用痕迹影响二次销售的商品；2、法律明确规定不适用七天无理由退货的商品；3、基于安全及健康的考虑，已拆封的食品、药品、保健品、化妆品、贴身用品等；4、已经激活的手机、电脑、数码产品等；5、已在线交付的充值类商品；6、未经授权的维修、误用、碰撞、疏忽、滥用、进液、事故、改动、不正确的安装所造成的商品质量问题，或撕毁、涂改标贴、机器序号、防伪标记；7、无法提供商品的发票（如已索要发票）、保修卡等三包凭证或者三包凭证信息与商品不符及被涂改的；8、礼包或套装中的商品不可以部分退换货。详见唯品会退货政策。上述退货规则，客户一经购买，视为认可。&amp;nbsp;&lt;a href=&quot;https://help.vip.com/commitment.php&quot; target=&quot;_blank&quot;&gt;查看详细退货政策»&lt;/a&gt; \r\n				&lt;/p&gt;\r\n				&lt;div class=&quot;q-return&quot; style=&quot;margin:0px;padding:20px 25px 0px;&quot;&gt;\r\n					&lt;h4 style=&quot;font-size:14px;&quot;&gt;\r\n						退货流程如下：\r\n					&lt;/h4&gt;\r\n					&lt;p&gt;\r\n						&lt;img src=&quot;https://s2.vipstatic.com/img/share/blank.png&quot; class=&quot;lazy&quot; alt=&quot;&quot; width=&quot;871&quot; height=&quot;48&quot; /&gt; \r\n					&lt;/p&gt;\r\n				&lt;/div&gt;\r\n			&lt;/div&gt;\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;FW-aboutUs J-data-module&quot; id=&quot;J-FW-aboutUs&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n			&lt;div class=&quot;M-detailTitle&quot; style=&quot;margin:0px;padding:0px 0px 0px 15px;background-color:#EAE8EB;&quot;&gt;\r\n				&lt;h3 class=&quot;detail-title&quot; style=&quot;font-size:14px;font-weight:400;&quot;&gt;\r\n					关于我们\r\n				&lt;/h3&gt;\r\n			&lt;/div&gt;\r\n			&lt;div class=&quot;M-aboutUs&quot; id=&quot;J-aboutUs-wrap&quot; style=&quot;margin:0px;padding:20px 0px 60px;background-color:#FFFFFF;&quot;&gt;\r\n				&lt;ul id=&quot;J-aboutUs-nav-wrap&quot; class=&quot;icon-list clearfix&quot; style=&quot;text-align:center;&quot;&gt;\r\n					&lt;li class=&quot;J-aboutUs-trigger&quot;&gt;\r\n						&lt;span class=&quot;li-item item-0 J_li_item&quot;&gt;&lt;/span&gt; \r\n					&lt;/li&gt;\r\n					&lt;li class=&quot;J-aboutUs-trigger&quot;&gt;\r\n						&lt;span class=&quot;li-item item-1 J_li_item&quot;&gt;&lt;/span&gt; \r\n					&lt;/li&gt;\r\n					&lt;li class=&quot;J-aboutUs-trigger&quot;&gt;\r\n						&lt;span class=&quot;li-item item-2 J_li_item&quot;&gt;&lt;/span&gt; \r\n					&lt;/li&gt;\r\n					&lt;li class=&quot;J-aboutUs-trigger&quot;&gt;\r\n						&lt;span class=&quot;li-item item-3 J_li_item&quot;&gt;&lt;/span&gt; \r\n					&lt;/li&gt;\r\n					&lt;li class=&quot;J-aboutUs-trigger&quot;&gt;\r\n						&lt;span class=&quot;li-item item-4 J_li_item&quot;&gt;&lt;/span&gt; \r\n					&lt;/li&gt;\r\n					&lt;li class=&quot;J-aboutUs-trigger&quot;&gt;\r\n						&lt;span class=&quot;li-item item-5 J_li_item&quot;&gt;&lt;/span&gt; \r\n					&lt;/li&gt;\r\n					&lt;li class=&quot;J-aboutUs-trigger&quot;&gt;\r\n						&lt;span class=&quot;li-item item-6 J_li_item&quot;&gt;&lt;/span&gt; \r\n					&lt;/li&gt;\r\n					&lt;li class=&quot;J-aboutUs-trigger&quot;&gt;\r\n						&lt;span class=&quot;li-item item-7 J_li_item&quot;&gt;&lt;/span&gt; \r\n					&lt;/li&gt;\r\n					&lt;li class=&quot;J-aboutUs-trigger&quot;&gt;\r\n						&lt;span class=&quot;li-item item-8 J_li_item&quot;&gt;&lt;/span&gt; \r\n					&lt;/li&gt;\r\n					&lt;li class=&quot;J-aboutUs-trigger&quot;&gt;\r\n						&lt;span class=&quot;li-item item-9 J_li_item&quot;&gt;&lt;/span&gt; \r\n					&lt;/li&gt;\r\n				&lt;/ul&gt;\r\n				&lt;div id=&quot;J-aboutUs-content-wrap&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n					&lt;div class=&quot;au-main J-aboutUs-content&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n						&lt;div class=&quot;&quot; id=&quot;J_au_top&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n						&lt;/div&gt;\r\n						&lt;div class=&quot;au-con&quot; id=&quot;J_au_con_wrap&quot; style=&quot;margin:0px auto;padding:0px;text-align:center;&quot;&gt;\r\n							&lt;ul class=&quot;au-con-list&quot; id=&quot;J_au_con_list_panel&quot;&gt;\r\n							&lt;/ul&gt;\r\n&lt;span class=&quot;au-con-left&quot; id=&quot;J_au_con_left&quot; style=&quot;line-height:66px;color:#E6E6E6;font-size:20px;background-color:#CCCCCC;&quot;&gt;&amp;lt;&lt;/span&gt;&lt;span class=&quot;au-con-right&quot; id=&quot;J_au_con_right&quot; style=&quot;line-height:66px;color:#E6E6E6;font-size:20px;background-color:#CCCCCC;&quot;&gt;&amp;gt;&lt;/span&gt; \r\n						&lt;/div&gt;\r\n					&lt;/div&gt;\r\n				&lt;/div&gt;\r\n			&lt;/div&gt;\r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;code-weixin hidden&quot; id=&quot;J-bottom-adCode&quot; style=&quot;margin:70px 0px 0px -645px;padding:0px;color:#333333;font-family:tahoma, arial, \'Hiragino Sans GB\', \'WenQuanYi Micro Hei\', 微软雅黑, 宋体, sans-serif;&quot;&gt;\r\n	&lt;/div&gt;\r\n	&lt;div id=&quot;J_top_adCode&quot; class=&quot;M_qrcode&quot; style=&quot;margin:-185px 0px 0px -650px;padding:0px;color:#333333;font-family:tahoma, arial, \'Hiragino Sans GB\', \'WenQuanYi Micro Hei\', 微软雅黑, 宋体, sans-serif;&quot;&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;ue_survey&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:tahoma, arial, \'Hiragino Sans GB\', \'WenQuanYi Micro Hei\', 微软雅黑, 宋体, sans-serif;&quot;&gt;\r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(139,	139,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0705/192/1aa585dd-b143-4f32-a9fa-01a914a1333b.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0705/156/19fe1a69-8739-47d7-904d-03dad6dd9a03.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(140,	140,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/108/90b15546-8ab4-4600-afeb-4edfc790cd68.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/40/d9c81fec-98e5-4b1d-a2a6-3fc6ab616422.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/84/c9aada38-0467-4119-ba48-78d9a66c39b1.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(141,	141,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/102/b8aaa651-05a0-4e6f-ba4c-d84c0719ca55.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/162/394afa99-9625-44fe-bb6d-be562c593b9f.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/183/d2d22645-8b4e-4b3a-8f6c-295ba0a58b9b.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/5/666cd873-f386-42b0-859c-545edb30b257.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(142,	142,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/26/ab8a4d9c-6e6c-42c9-aa2e-5c1d20d64479.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/80/d6251e45-b5e8-44ce-957d-bd9974c01c43.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/194/72e81509-79d1-48ba-a89c-e57824b9ea53.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/113/b30e168e-1c0d-4fe1-91a9-29d944f47337.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(143,	143,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0705/46/10ddffa2-c936-4e2e-a23d-260a9c8f580b.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0705/143/148fcab8-af06-4660-81af-01632811f717.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0705/17/053f1a37-a2fa-46eb-a666-d2a7dc0ef716.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0705/118/018126ca-3a00-483d-8490-6237e1ba7e43.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0705/75/ad40a0c0-19c5-4c52-be80-e0d7626c856c.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(144,	144,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/188/4d0333fc-f228-4994-8cfe-0ca994d7a02c.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/143/51b1ac16-4bca-4def-82cb-ff474ffe4025.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/36/0d7d4118-26bf-4e8f-b389-165e8c0318b3.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/85/3456af92-07af-46f0-ac52-973d7e9e215d.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/153/38e8448e-90fc-4bfb-a795-0832a7664b0e.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(145,	145,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0705/170/dbb53cd3-275a-493d-b3dd-c943f97e6758.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0705/90/b6091c8c-18eb-418d-ac2f-a615fa09356f.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0705/92/86b0ace6-74f4-4832-af80-9f2a187429b2.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0705/61/1566969d-df00-4b47-8270-40b6884afb4e.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(146,	146,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0705/92/87866278-fd73-4f47-81fe-bab275800f33.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0705/157/892b15b5-bd96-441c-807b-50ec2205b51e.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0705/140/66b1a976-4be5-4093-9152-24f8f4459793.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0705/14/43229059-49cb-46b0-ac4b-a569fd41f4fb.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0705/137/782dfb73-eee7-479b-b16f-0aac7a04aced.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(147,	147,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/169/cfccf0d9-77ad-4b13-8e41-a720646c49f8.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/68/3f1b31fe-6d08-484d-95ec-4267733040a9.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0704/168/2148f82f-18c2-417e-85a0-545b686440cd.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(148,	148,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0705/162/44216018-1f5e-4b79-94bf-53c1964a10bd.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0705/161/5fcfb60f-76cc-45d7-8a11-5411dfd17dde.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/607125/2017/0705/164/66cf47ba-b11f-4f83-80af-a5fdc3615543.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(149,	149,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/604256/2017/0711/7/fd8712d7-3851-4944-aaed-6e7878da13f7.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/604256/2017/0711/189/32624504-52ed-4f35-b05a-2c72193d326f.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/604256/2017/0711/115/82ed3913-2e02-4701-b987-2ea09011c27a.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/604256/2017/0711/113/00f68ba3-ef16-46a2-9d71-e0620c0aced2.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/604256/2017/0711/54/0ab55722-5599-471f-b29e-f663626a4056.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/604256/2017/0711/53/db98f69e-b6bb-4700-a905-a54c7cbaf1eb.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(150,	150,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/604256/2017/0711/153/73822d4f-45d4-4bc8-ac06-340444012fa0.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/604256/2017/0711/108/0c3b5944-749e-4c8b-b478-ed586bdac03c.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/604256/2017/0711/58/4f59296d-2c8c-4a57-9b79-4616e88fd528.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/604256/2017/0711/72/32e23c5e-45d8-47ba-bfc6-8a1755bd4043.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/604256/2017/0711/174/79d2b758-5637-4cfa-ae78-41b50ae01637.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(151,	151,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/604256/2017/0711/29/001f18cb-c2e4-4d0e-8c4c-889b4a9c310e.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/604256/2017/0711/177/03f308ed-4c5e-4d62-819e-7bb54302c029.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/604256/2017/0711/190/8cf68acc-d573-4de7-9d38-da81fd9b8d8c.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/604256/2017/0711/140/f0a06fd1-b7c6-4f72-9d9d-190564502935.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(152,	152,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/604256/2017/0711/12/27d4ac22-20b4-4a8c-aae2-778569822ff5.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/604256/2017/0711/101/024391f5-c457-4a73-baa2-d34e7ecb1412.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/604256/2017/0711/12/14e8927f-4809-41b0-9929-66d6a7e379ae.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/604256/2017/0711/4/33059167-9c02-4e6d-9825-1b87365af9df.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(153,	153,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/604256/2017/0711/168/d628b398-ef0f-4f7c-948e-d73d3f337546.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/604256/2017/0711/10/62da5b8a-4918-4a85-bf5c-e142f7a341b7.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/604256/2017/0711/17/250301db-dcb5-4b52-9a5f-649566fada7f.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/604256/2017/0711/19/80ca3cb5-b63c-42fe-81b4-6bd8544ef619.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/604256/2017/0711/187/a3bd8aab-0538-4e8e-b744-5040b6376345.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(154,	154,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/604256/2017/0711/55/2b50b843-17fc-4a63-a78c-0dc3ea86a09b.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/604256/2017/0711/100/47ef5e09-9abb-4e19-88c6-09438b395390.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/604256/2017/0711/99/8f5f617d-e887-4a42-8e24-c6a88ffeb9f8.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdcvis/604256/2017/0711/186/d83b2395-d301-424f-a3ce-4c622942f1c8.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(155,	155,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/203/653/953150557458653203/4/8007150907175-601.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/203/653/953150557458653203/4/8007150907175-602.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/203/653/953150557458653203/4/8007150907175-603.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/203/653/953150557458653203/4/8007150907175-604.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(156,	156,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/898/581/969757581084581898/4/8007150904990-601.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/898/581/969757581084581898/4/8007150904990-602.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/898/581/969757581084581898/4/8007150904990-603.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/898/581/969757581084581898/4/8007150904990-604.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(157,	157,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/728/865/233137721633865728/3/8007150900326-604.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(158,	158,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/380/252/939921233553252380/4/8007150904808-601.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/380/252/939921233553252380/4/8007150904808-602.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/380/252/939921233553252380/4/8007150904808-603.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/380/252/939921233553252380/4/8007150904808-604.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/380/252/939921233553252380/4/8007150904808-605.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(159,	159,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/898/581/969757581084581898/4/8007150904990-601.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/898/581/969757581084581898/4/8007150904990-602.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/898/581/969757581084581898/4/8007150904990-603.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/898/581/969757581084581898/4/8007150904990-604.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/898/581/969757581084581898/4/8007150904990-605.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/898/581/969757581084581898/4/8007150904990-606.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/898/581/969757581084581898/4/8007150904990-607.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(160,	160,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/728/865/233137721633865728/3/8007150900326-601.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/728/865/233137721633865728/3/8007150900326-602.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/728/865/233137721633865728/3/8007150900326-603.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/728/865/233137721633865728/3/8007150900326-604.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/728/865/233137721633865728/3/8007150900326-605.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/728/865/233137721633865728/3/8007150900326-606.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(161,	161,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/481/947/963565131596947481/4/8007150904860-601.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/481/947/963565131596947481/4/8007150904860-602.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/481/947/963565131596947481/4/8007150904860-603.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/481/947/963565131596947481/4/8007150904860-604.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/481/947/963565131596947481/4/8007150904860-605.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(162,	162,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/698/881/8441997501512881698/4/8007150900404-601.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/698/881/8441997501512881698/4/8007150900404-602.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/698/881/8441997501512881698/4/8007150900404-603.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/698/881/8441997501512881698/4/8007150900404-604.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(163,	163,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/380/252/939921233553252380/4/8007150904808-601.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/380/252/939921233553252380/4/8007150904808-602.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/380/252/939921233553252380/4/8007150904808-603.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/380/252/939921233553252380/4/8007150904808-604.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/380/252/939921233553252380/4/8007150904808-605.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg3.com/upload/merchandise/pdc/380/252/939921233553252380/4/8007150904808-606.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(164,	164,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/27/42/168650f9-e683-40e5-a0ae-c64450ef8443.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/27/79/4c9a4718-a8cb-4585-9629-4429fdcf49e4.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/27/11/62940326-f17c-4271-a1a9-c715abe69132.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/27/140/aeb3081e-f7bc-42a4-8150-96cf9fcef7b8.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(165,	165,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/17/3/c9389cad-2cf5-4c00-8f0d-3c6669c43073.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/17/9/57184a16-703c-4bed-92db-a1042170ac56.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/17/135/bbfe2aeb-8a17-4176-94e9-946ad94b9994.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/17/56/f41e7fd8-cffa-4847-859b-b081ef2ff732.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(166,	166,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/27/124/709342f7-23c6-4b42-92b2-7e9eba593681.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/27/199/283a9a04-0e80-4eeb-b375-a4892d7b199e.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/27/5/50f34fc8-e7eb-4f68-a079-489333e7e5d9.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(167,	167,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/27/66/1b2ba1a1-78ac-45a6-be36-2883b5e9e716.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/27/142/c2526495-3566-40f9-bfe8-bf2ca2df3b31.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/27/119/b3b85dc7-6668-413e-ac88-9145fc34c0f6.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(168,	168,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/27/104/3036e463-56e8-456d-b257-00b6f53b0850.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/27/88/76f956ef-bc29-425d-a4b8-25fbcaee9dc4.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/27/107/7b0728aa-9af3-48bf-a829-c7fcd9a85975.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(169,	169,	'&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n	&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/27/93/f8a908ff-c2d2-40c2-af3f-e4d09e62b466.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n&lt;/div&gt;\r\n&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n	&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/27/143/0a0a7c9b-c3d4-4a22-983a-22e8937f4f22.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n&lt;/div&gt;\r\n&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n	&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/27/69/98e6db88-2de0-4bdb-b8e5-b636e1544b6c.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n&lt;/div&gt;',	'',	'',	''),
(170,	170,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/05/17/31/49173f60-9faa-4ffe-8e0f-3b8715f0ae55.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/05/17/76/e80dff26-0301-4e15-a4dd-cca43743b9f6.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/05/17/29/c32928b2-1cc7-4f82-9bff-98e42cfd84c6.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(171,	171,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/27/73/f4339a4b-d6fb-4302-8364-b78b605d1837.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/27/64/874a10a8-fdc0-4f91-97cf-ecbf3a53ae0c.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/27/87/f528047b-4678-4cf3-b5b4-c22775db441e.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/27/156/b7ed132c-9745-473e-abd8-633da5df42e8.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(172,	172,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;dc-img-detail&quot; style=&quot;margin:0px 0px 20px;padding:10px 0px 0px;text-align:center;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;&quot;&gt;\r\n		&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n			&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/03/14/72/ab88ebb6-0b52-4d30-8635-f8b7b65ee586.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;dc-img-con&quot; style=&quot;margin:0px;padding:0px;text-align:center;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;&quot;&gt;\r\n		&lt;img width=&quot;495&quot; height=&quot;626&quot; src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/03/14/174/da38ee6b-b606-458f-8d4c-41cf36a4b92a.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;&amp;nbsp;&lt;img width=&quot;495&quot; height=&quot;626&quot; src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/03/14/153/a0e13f84-a049-484b-908e-e0d339deaf61.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(173,	173,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/603591/2017/0615/159/4363f401-7bd5-469d-bb36-e45518da1da7.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/603591/2017/0615/156/de8884ef-d8ec-4f19-b4a6-4cea8dce042b.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/603591/2017/0615/16/fee862ca-716d-47e2-b8dd-ad19ef8f6cf1.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/603591/2017/0615/78/646807b9-d8a1-4e97-b212-03401b1524cc.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(174,	174,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/27/142/6e15a0c4-2392-49b0-9435-80cc749ddd39.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/27/183/6c2c7a0c-d336-4582-b424-4e0268d7819d.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/27/139/34006cd8-3098-4fcf-9d55-739c4f2cdb89.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/27/129/842e2a3a-1b25-40bc-8776-6c2287deb8c2.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(175,	175,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/05/17/198/b4226e65-765c-4b00-8cc0-00ef04b81faf.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/05/17/48/c1149027-132c-4c42-b19e-2c0851b7f020.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/05/17/32/1400869c-5962-4c00-8d85-b7881195d437.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/05/17/135/9e2b4c5c-7744-4bd4-acf3-162d1e2b587e.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(176,	176,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/06/05/37/e3f780f3-831d-4e60-a4f0-f7840c2f25e6.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/06/05/43/a9514521-0350-4c55-b73a-5de9968c6536.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/06/05/67/8c6a81c4-7580-4f00-961c-fdaa1f95fc6d.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(177,	177,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/04/12/91/7e573b87-b538-4754-b2be-c79a19d7e3fa.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/04/12/134/4502ab52-0c66-4324-910f-7dbd71f2eb53.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/04/12/178/cb14e7db-bfb0-4c02-8e30-5f9ff0f12e57.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/04/12/96/dc799f2f-1a42-4072-892b-cf44e386f341.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(178,	178,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/05/03/198/6e5cde74-3dba-42bb-9bc8-e582b64a6899.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/05/03/38/f1e2361c-9b51-4c89-ad9c-def00eb2ce1f.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/05/03/95/f1a5a597-697a-469d-adf5-193da55d2ef7.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/05/03/158/0811f91e-7348-43e5-bbde-c2c7a63051a7.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(179,	179,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/01/20/172/2f703c3f-b628-415d-9d86-98fd19970f1c.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(180,	180,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/14/123/df70b3a9-8eb7-4289-a5be-d161530f5bc3.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/14/45/db0d072e-99ce-476b-b826-6fcad5aa153a.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/14/196/ef822af6-f6c1-4f00-be23-0038dfb9a4c4.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/14/16/27cce0c4-9b2c-4704-9533-240772390f07.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(181,	181,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/05/18/132/852fde64-56dd-4e5e-a3ab-a69b8bc440fb.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/05/18/177/e5730746-dcdd-43b7-84a2-313a18dd25f9.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/05/18/61/079bb1e7-3c44-4d75-9272-aebd618322c9.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/05/18/182/490831dd-3064-4dfc-8631-3ca1e2329876.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(182,	182,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/02/17/196/ca5f73d6-fca1-4776-878a-2db02f54bc79.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(183,	183,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/14/69/d1c543b8-b4ca-472b-892b-b6b7405c2048.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/14/71/2617931b-2447-420e-9723-4536f24d88d7.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/14/22/ce28b186-585a-497b-89d6-95f051af3e83.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/14/94/4c275831-d8e4-4453-8463-da11119f1f90.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(184,	184,	'&lt;div class=&quot;dc-img-detail&quot; style=&quot;margin:0px 0px 20px;padding:10px 0px 0px;text-align:center;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/2017/03/27/168/c343c53c-956e-49d9-8333-967c42eb13ea.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;\r\n	&lt;/div&gt;\r\n&lt;/div&gt;\r\n&lt;div class=&quot;dc-img-con&quot; style=&quot;margin:0px;padding:0px;text-align:center;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;&quot;&gt;\r\n	&lt;img width=&quot;495&quot; height=&quot;626&quot; src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/2017/03/27/89/9e6d9b19-73a9-43cb-86a7-ae8b12c3e357.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;&amp;nbsp;&lt;img width=&quot;495&quot; height=&quot;626&quot; src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/2017/03/27/148/11e744c9-9151-4a60-93b9-3e79904bbdd0.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;&lt;img width=&quot;495&quot; height=&quot;626&quot; src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/2017/03/27/141/dbb1432e-dd1f-4abc-a195-843418f7415b.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;&amp;nbsp;&lt;img width=&quot;495&quot; height=&quot;626&quot; src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/2017/03/27/145/c23b7005-b629-4370-b7e4-cf342b2235a4.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(185,	185,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/2017/06/01/33/a63be92c-899a-4980-bd5d-e378ecaf9b57.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg4.com/upload/merchandise/pdcvis/2017/06/01/99/7818292c-d313-4efd-8862-bade52043f7f.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;\r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(186,	186,	'&lt;img src=&quot;/uploads/image/20170807/598806e4182fa.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(187,	187,	'&lt;img src=&quot;/uploads/image/20170807/59880a6bef73d.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(188,	188,	'&lt;img src=&quot;/uploads/image/20170807/59880c1d9cd17.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(189,	189,	'&lt;img src=&quot;/uploads/image/20170807/59880d7fd657d.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(190,	190,	'&lt;img src=&quot;/uploads/image/20170807/59880f7a3e4aa.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(191,	191,	'&lt;img src=&quot;/uploads/image/20170807/59881541a5d1b.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(192,	192,	'&lt;img src=&quot;/uploads/image/20170807/59881a0234630.jpg&quot; alt=&quot;&quot; /&gt;',	'夏凉被',	'夏凉被',	'夏凉被'),
(193,	193,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/18/59/2e0cd6ae-a776-4770-b1c9-c54710bebb31.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/604264/2017/0803/132/c10b9db2-2d6a-4609-9c73-78ae1c4d7a7f.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/18/169/6af7f68f-f42d-4d86-ba6a-74793292c329.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/18/57/874b9aa9-487e-4312-8a7b-1efa59438c4e.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/18/8/d458b892-c54b-4eff-b592-2f228c7da21f.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(194,	194,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;dc-img-detail&quot; style=&quot;margin:0px 0px 20px;padding:10px 0px 0px;text-align:center;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;&quot;&gt;\r\n		&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n			&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/12/187/0579eea7-69c6-4198-ab5e-7b053cf07e01.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n			&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/12/14/9c3cf78d-2dff-4891-b058-4dfc36638b52.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n			&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/12/10/a8adc2e2-db8f-4ca2-ac37-2c6967a438fc.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n			&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/12/3/2dd40c28-9328-42dc-9c3e-24cd023e75e5.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n			&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/12/194/7280674e-7481-48b6-a6c1-d2184eaa101c.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n			&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/12/31/59ba4e5d-e469-400b-b7f2-1031aa52307c.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n			&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/12/44/50e82b3f-bf48-4abf-aab1-d4df32ac1f39.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;\r\n		&lt;/div&gt;\r\n		&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n			&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/12/78/c9cba7e8-9e8f-480a-a69e-5aec3fba6a83.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;\r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;dc-img-con&quot; style=&quot;margin:0px;padding:0px;text-align:center;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;&quot;&gt;\r\n		&lt;img width=&quot;495&quot; height=&quot;626&quot; src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/12/181/9d1e5389-52dc-4b68-ad1d-07e10f772697.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;&amp;nbsp;&lt;img width=&quot;495&quot; height=&quot;626&quot; src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/12/66/44b66b7e-c08b-410e-a4ba-91f818af9944.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;&lt;img width=&quot;495&quot; height=&quot;626&quot; src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/12/130/6c8ede42-b51a-404d-a699-8b019999a47c.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;&amp;nbsp;&lt;img width=&quot;495&quot; height=&quot;626&quot; src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/12/163/35c4c460-923e-49ef-92aa-d704ddf72a44.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;\r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(195,	195,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/18/2/21cdc621-534b-4e44-b54e-6f576f5b121f.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/18/140/af73d82b-bf14-41c9-80d6-8ed366cb92bd.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/18/190/152665b5-d880-4bba-a00a-db84178061cf.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/18/185/42f09a06-b1f8-46f4-9d51-aa1bf14f581b.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;\r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(196,	196,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/18/174/9c991524-44db-4de6-a639-1d10ec91b888.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/18/15/2fad3733-0845-46f5-b45c-14341e34959e.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/18/10/de732671-adef-456f-b945-6e07ae5c1f3e.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/18/93/032bd4a6-d2a4-4881-96d1-36cf1900f169.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(197,	197,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/12/7/bf15ebec-fb7f-477f-b17a-9e116c985859.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/12/30/af0905d8-bee3-448c-af83-18563d2e8430.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/12/13/a12fe28e-d78f-43a9-9bb0-1e8e5095e492.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/12/193/3b53b60c-a5bf-4466-bb79-cb185ac56e49.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/12/87/8f7a9608-2320-4bdf-8a08-f48de4dedea7.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/12/108/03c41bd6-e243-4caa-a6c2-fdc4e43c9c2e.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(198,	198,	'&lt;img src=&quot;/uploads/image/20170807/59882bcd6375e.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(199,	199,	'&lt;img src=&quot;/uploads/image/20170807/59882e3171e75.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(200,	200,	'&lt;img src=&quot;/uploads/image/20170807/59882fd07c6d7.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(201,	201,	'&lt;img src=&quot;/uploads/image/20170807/5988315f57343.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(202,	202,	'&lt;img src=&quot;/uploads/image/20170808/598917da987ee.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170808/598917db5a0c0.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170808/598917dbd216d.jpg&quot; alt=&quot;&quot; /&gt;',	'炒锅',	'炒锅',	'炒锅'),
(203,	203,	'&lt;img src=&quot;/uploads/image/20170809/598a7e84de047.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(204,	204,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/18/184/699c784b-02ba-4b86-b51e-a0249328700d.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/18/6/96020e3a-0a92-41e9-92ad-1e1f9792b5e0.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/18/64/e3a04d11-44e0-464f-ac59-59501f2e3f67.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;img-6xx-bg&quot; style=&quot;margin:0px;padding:0px;color:#333333;font-family:微软雅黑, sans-serif;font-size:14px;text-align:center;&quot;&gt;\r\n		&lt;img src=&quot;https://a.vpimg2.com/upload/merchandise/pdcvis/2017/07/18/156/4d9c8181-d3fa-4d6d-b4de-894fb162cd46.jpg&quot; class=&quot;J-mer-bigImg&quot; /&gt;\r\n	&lt;/div&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(205,	205,	'',	'',	'',	''),
(206,	206,	'',	'',	'',	''),
(207,	207,	'',	'',	'',	''),
(208,	208,	'',	'',	'',	''),
(209,	209,	'',	'',	'',	''),
(210,	210,	'',	'',	'',	''),
(211,	211,	'',	'套锅',	'',	''),
(212,	212,	'',	'不锈钢汤锅',	'汤锅',	''),
(213,	213,	'',	'生铁炒锅',	'炒锅',	''),
(214,	214,	'',	'不锈钢锅',	'锅',	''),
(215,	215,	'',	'蒸锅',	'不锈钢',	''),
(216,	216,	'&lt;ul class=&quot;attributes-list&quot; style=&quot;font-family:tahoma, arial, \'Hiragino Sans GB\', 宋体, sans-serif;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n		颜色分类:&amp;nbsp;图片色\r\n	&lt;/li&gt;\r\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n		尺码:&amp;nbsp;均码\r\n	&lt;/li&gt;\r\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n		上市年份季节:&amp;nbsp;2017年夏季\r\n	&lt;/li&gt;\r\n	&lt;li style=&quot;text-indent:5px;&quot;&gt;\r\n		&lt;img src=&quot;/uploads/image/20170817/599531f652014.png&quot; alt=&quot;&quot; /&gt;\r\n	&lt;/li&gt;\r\n&lt;/ul&gt;',	'新款',	'欧美',	''),
(217,	217,	'',	'韩版修身铅笔裤',	'铅笔裤',	''),
(218,	218,	'',	'韩版时尚半裙',	'半裙',	''),
(219,	219,	'',	'碎花套装',	'韩版碎花',	''),
(220,	220,	'',	'针织新款上衣',	'韩版针织',	''),
(221,	221,	'',	'T恤衫',	'韩版修身T恤',	''),
(222,	222,	'',	'印花纯棉被套',	'被套',	''),
(223,	223,	'',	'粉色空调被套',	'被套',	''),
(224,	224,	'',	'韩版休闲高跟鞋',	'韩版高跟鞋',	''),
(225,	225,	'',	'韩版绑带休闲鞋',	'韩版绑带',	''),
(226,	226,	'',	'迪丽热巴同款衬衫',	'迪丽热巴同款 衬衫',	''),
(227,	227,	'',	'',	'',	''),
(228,	228,	'',	'真皮包包',	'韩版休闲包',	''),
(229,	229,	'',	'韩版针织衫',	'针织衫',	''),
(230,	230,	'',	'预售 风衣',	'预售风衣',	''),
(231,	231,	'',	'',	'',	''),
(232,	232,	'&lt;img src=&quot;/uploads/image/20170818/59964a0b2fb8b.jpg&quot; alt=&quot;&quot; /&gt;',	'条纹空调衫',	'条纹 空调 防晒衣',	''),
(233,	233,	'&lt;img src=&quot;/uploads/image/20170818/59964ba4bc184.jpg&quot; alt=&quot;&quot; /&gt;',	'韩版宽松卫衣',	'韩版宽松学生连帽bf长袖短款字母印花',	''),
(234,	234,	'&lt;img src=&quot;/uploads/image/20170818/59964f309792e.jpg&quot; alt=&quot;&quot; /&gt;',	'半身裙女夏季新款不规则印花长款开叉显瘦学生雪纺长裙',	'韩版修身雪纺长裙',	''),
(235,	235,	'&lt;img src=&quot;/uploads/image/20170818/599651cbbf5b9.jpg&quot; alt=&quot;&quot; /&gt;',	'针织连衣裙女夏新款冰丝拼色短袖中长款韩版显瘦T恤裙',	'韩版针织连衣裙',	''),
(236,	236,	'&lt;img src=&quot;/uploads/image/20170818/599652e8de393.jpg&quot; alt=&quot;&quot; /&gt;',	'2017新款收腰V领荷叶边裙子女露肩碎花雪纺短袖连衣裙',	'V领荷叶边连衣裙',	''),
(237,	237,	'&lt;img src=&quot;/uploads/image/20170819/59979cafdfddf.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170819/59979cb021851.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(238,	238,	'&lt;img src=&quot;/uploads/image/20170819/5997d0ac294dd.png&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170819/5997d0ac57b12.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170819/5997d0ac834a6.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170819/5997d0acac3bb.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170819/5997d0acd3ee7.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170819/5997d0ad2184f.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170819/5997d0ad53650.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(239,	239,	'&lt;img src=&quot;/uploads/image/20170819/5997d4ca215e3.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170819/5997d4ca4cca6.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170819/5997d4ca7b451.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170819/5997d4ca9bf22.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170819/5997d4cac5cf0.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170819/5997d4caed60a.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(240,	240,	'&lt;img src=&quot;/uploads/image/20170819/5997dcb554406.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170819/5997dcb57f126.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170819/5997dcb5b2f7d.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170819/5997dcb610632.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170819/5997dcb63b30b.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170819/5997dcb67dc60.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170819/5997dcb6b2774.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(241,	241,	'&lt;img src=&quot;/uploads/image/20170819/5997e52f00e3f.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170819/5997e52f2f1c7.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170819/5997e52f4bd01.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170819/5997e52f6b071.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170819/5997e52f8b707.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170819/5997e52fac9ed.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170819/5997e52fcd7d4.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170819/5997e52feebd9.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(242,	242,	'&lt;img src=&quot;/uploads/image/20170819/5997ec670994b.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170819/5997ec673058f.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/uploads/image/20170819/5997ec675e9cd.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(243,	243,	'',	'',	'',	''),
(244,	244,	'好刀',	'',	'',	''),
(245,	245,	'哈哈',	'刀',	'刀',	''),
(246,	246,	'',	'',	'',	''),
(247,	247,	'实打实的',	'刀',	'刀',	''),
(248,	248,	'',	'',	'',	''),
(249,	249,	'单独购买不发货',	'',	'',	''),
(250,	250,	'哈哈',	'西瓜刀',	'刀',	'好刀'),
(251,	251,	'',	'',	'',	''),
(252,	252,	'&lt;div style=&quot;text-align:center;&quot;&gt;\r\n	&lt;img src=&quot;/uploads/image/20170826/59a10aef691cc.jpg&quot; alt=&quot;&quot; /&gt; \r\n&lt;/div&gt;',	'',	'',	''),
(253,	253,	'&lt;img src=&quot;/uploads/image/20170826/59a11b60d98f2.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(254,	254,	'&lt;img width=&quot;750&quot; alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t6061/66/5996285920/378201/63e0d0d8/596f384bN57f8cc17.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;br /&gt;\r\n&lt;img width=&quot;750&quot; alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t5077/66/1578946308/351816/781cef7b/591189b8N11fceb78.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;br /&gt;\r\n&lt;img width=&quot;750&quot; alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img20.360buyimg.com/vc/jfs/t4507/277/4685204233/228552/80ff7894/59127f02N4c20c959.jpg&quot; /&gt;&lt;br /&gt;',	'',	'',	''),
(255,	255,	'&lt;div id=&quot;activity_header&quot; style=&quot;margin:0px;padding:0px;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;div style=&quot;margin:0px;padding:0px;text-align:center;&quot;&gt;\r\n		&lt;a href=&quot;https://support.apple.com/zh-cn/HT204073&quot; target=&quot;_blank&quot;&gt;&lt;img alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/jgsq-productsoa/jfs/t6415/91/143490012/88326/30e3b943/593a40fcNd5352b6d.jpg&quot; /&gt;&lt;/a&gt;&lt;br /&gt;\r\n	&lt;/div&gt;\r\n&lt;/div&gt;\r\n&lt;div id=&quot;J-detail-content&quot; style=&quot;margin:0px;padding:0px;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;div style=&quot;margin:0px;padding:0px;text-align:center;&quot;&gt;\r\n		&lt;a href=&quot;https://support.apple.com/zh-cn/HT204073&quot; target=&quot;_blank&quot;&gt;&lt;img alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/jgsq-productsoa/jfs/t6082/69/2040748754/88326/30e3b943/593a489eN709664a1.jpg&quot; /&gt;&lt;/a&gt; \r\n	&lt;/div&gt;\r\n	&lt;table width=&quot;750&quot; border=&quot;0&quot; align=&quot;center&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; bgcolor=&quot;#F0F0F0&quot; class=&quot;ke-zeroborder&quot;&gt;\r\n		&lt;tbody&gt;\r\n			&lt;tr&gt;\r\n				&lt;td height=&quot;76&quot;&gt;\r\n					&lt;div style=&quot;margin:0px;padding:8px;font-size:16px;font-family:微软雅黑;&quot;&gt;\r\n						&lt;strong&gt;温馨提示：&lt;/strong&gt;&lt;br /&gt;\r\niPhone 6s 意外关机问题计划&lt;a href=&quot;https://www.apple.com/cn/support/iphone6s-unexpectedshutdown/&quot;&gt;请访问 ：https://www.apple.com/cn/support/iphone6s-unexpectedshutdown/&lt;/a&gt; \r\n					&lt;/div&gt;\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n		&lt;/tbody&gt;\r\n	&lt;/table&gt;\r\n	&lt;table width=&quot;750&quot; border=&quot;0&quot; align=&quot;center&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; bgcolor=&quot;#F0F0F0&quot; class=&quot;ke-zeroborder&quot;&gt;\r\n		&lt;tbody&gt;\r\n			&lt;tr&gt;\r\n				&lt;td height=&quot;336&quot;&gt;\r\n					&lt;div style=&quot;margin:0px;padding:8px;font-size:16px;font-family:微软雅黑;&quot;&gt;\r\n						&lt;p&gt;\r\n							5.5 英寸（对角线）显示屏，1920 x 1080 分辨率&amp;nbsp;&lt;br /&gt;\r\n3D Touch&lt;br /&gt;\r\n1200 万像素摄像头&lt;br /&gt;\r\n配备集成式 M9 运动协处理器的 A9 芯片&lt;br /&gt;\r\n4K 视频拍摄 (30 fps) 以及慢动作视频拍摄 (120 fps, 1080p)&lt;br /&gt;\r\n配备 Retina 闪光灯的 500 万像素 FaceTime HD 摄像头&lt;br /&gt;\r\nTouch ID 指纹识别传感器&amp;nbsp;&lt;br /&gt;\r\n具备 MIMO 技术的 802.11a/b/g/n/ac 无线网络\r\n						&lt;/p&gt;\r\n						&lt;p&gt;\r\n							法律免责声明&lt;br /&gt;\r\n1 4G LTE Advanced 和 4G LTE 功能适用于特定国家或地区的特定运营商。速度依据理论上的数据吞吐量，并基于现场状况和不同运营商而可能有所差异。有关 4G LTE 支持的详情，请联系你的运营商并查看 www.apple.com/iphone/LTE。&lt;br /&gt;\r\n2 电池使用时间依使用情况和设置的不同可能有所差异；请参阅 www.apple.com/cn/batteries 进一步了解详情。&lt;br /&gt;\r\n3 所有产品信息，以苹果官网为准（apple.com.cn)&lt;br /&gt;\r\n技术规格&amp;nbsp;&lt;br /&gt;\r\n请前往 www.apple.com/cn/iphone-6s/specs/ 查看完整内容。\r\n						&lt;/p&gt;\r\n					&lt;/div&gt;\r\n				&lt;/td&gt;\r\n			&lt;/tr&gt;\r\n		&lt;/tbody&gt;\r\n	&lt;/table&gt;\r\n&lt;br /&gt;\r\n&lt;/div&gt;\r\n&lt;div id=&quot;activity_footer&quot; style=&quot;margin:0px;padding:0px;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;div style=&quot;margin:0px;padding:0px;text-align:center;&quot;&gt;\r\n		&lt;img alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/jgsq-productsoa/jfs/t3577/344/1077770157/80811/316f9e36/581c7263N82a0e9fc.jpg&quot; /&gt; \r\n	&lt;/div&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(256,	256,	'&lt;div class=&quot;ETab&quot; id=&quot;detail&quot; style=&quot;margin:0px;padding:0px;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;div class=&quot;tab-con&quot; style=&quot;margin:0px;padding:10px 0px;&quot;&gt;\r\n		&lt;div style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n			&lt;div class=&quot;detail-content clearfix&quot; style=&quot;margin:10px 0px;padding:0px;background:#F7F7F7;&quot;&gt;\r\n				&lt;div class=&quot;detail-content-wrap&quot; style=&quot;margin:0px;padding:0px;background-color:#FFFFFF;&quot;&gt;\r\n					&lt;div class=&quot;detail-content-item&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n						&lt;div id=&quot;J-detail-content&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n							&lt;img id=&quot;b592738631114b55b0512e98691227d3 &quot; alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4555/150/2968061805/324289/3ff0c1e8/58f4be0aNfaf5850a.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;748de2325f3b4977bc8bd39eddf4c1f8 &quot; alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4693/112/2916354487/276829/3474e4b8/58f4be0fN8abb662f.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;dccfbdf83a2e4144899c28492ba23595 &quot; alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4870/61/1802336877/188993/b60d0f29/58f4be12N18063ad1.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;f6cdaca7638c4a6aa82a4eefc49b42e5 &quot; alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5017/87/1821795717/162871/4decd835/58f4be14N14c8b6b8.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;fd27cde86aae48d5a3544a0d9795ae8b &quot; alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4606/112/2920202074/153175/ab16a2bd/58f4be17N69c223b9.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;c2a376c6a6f44652a22d47f25d46ce00 &quot; alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4423/230/2911169240/407125/f15f8604/58f4be1dNe0b12861.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;ebbb63ff4186495eb1467a20de33c5fb &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5005/32/1826336722/539698/7a52833b/58f4be26N016186c7.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;7c150c3bb6274473a67b01bb64a0b9f1 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4948/361/1797975627/302121/dca6af21/58f4be2bNdd5014c3.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;b6a6848978bf44b3a44214ce6f4b090c &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4501/117/2973297602/162677/c0b38642/58f4be2eN48349473.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;71b7fc3353ab4e7aa462f21f452c775b &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4783/281/1821449933/432449/62a46270/58f4be35N8f5b5960.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;27f6ea6d0ee04537a8382404859e506c &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5050/156/1815031340/208547/38903461/58f4be38N504974bb.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;8cc6baabf7f4461ba5ae63b0570c8df5 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4729/281/1854708548/288597/b18b6e34/58f4be37N7763caf3.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;3b60e5bdf5eb4df28d35869d14cff55e &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5074/217/1833324197/302109/66d30496/58f4be41Na0070bc7.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;9a03580cdec04799b95d7cb9adc531ca &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4825/202/1850637970/286959/c49e72a6/58f4be41Ncd55bb29.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;10a2affecd604780beb4e134fbdc8caf &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4747/220/1789314477/631431/b2180304/58f4be50Nfc07f9c5.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;583e8f9c9b324273b4e111f0ca506373 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4474/347/2916321648/256310/e38e555f/58f4be53Nef1600b9.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;dfb4c8bd80c148bc9d0f16a8e094ea1b &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4792/232/1805900200/283568/a9e6f92e/58f4be58N169fa023.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;f5d31fc7703f487795d2fbb7d6cd8d63 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4540/26/2939443188/340754/69010d12/58f4be5dN566b7c20.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;eefbffaeaa7b4803ac642ec2b4a8974b &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4657/341/3002642095/314767/4ac07ccf/58f4be60N75bfaa35.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;dc44c0e9ca6f4593acf5c39d149dc60d &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4933/297/1855988053/319121/4762988e/58f4be68Nec7da68b.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;fbbbd89bda1043559d7ed3cce5e9c09a &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4693/34/2966095876/365923/10008dc5/58f4be6eN0dda107f.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;bd17c76939fc46f090e22e9415254e5f &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4636/51/2942970517/297177/2cace293/58f4be72N78820923.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;7cbd8db8dca446d69ab120c46cec6a74 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4879/347/1766870524/304170/7c5a3965/58f4be77Nde5081cb.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;b201113c7788422c82da06cb8c2ec12d &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4570/20/2925246857/411247/c9ec01c4/58f4be7bN37789e31.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;e13d178e848e4fb180edee1b170cd660 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4936/99/1796584224/402242/c9368ed2/58f4be84Na8db9db0.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;7ca73887961b46f2914eeaaf587a670c &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4894/188/1834430775/304760/a917f51/58f4be89N7e3757e8.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;36b9e53991a149c4b35f6ff1258d76e0 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4687/220/2924634991/304760/b8192f66/58f4be8eN57a6c845.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;262bc3a9457d43269a5c3e80a4e04a27 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4654/133/2938177754/306053/45288c37/58f4be93Ncb1cd9d7.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;1fdb6749378a40668fa16bafe6cd911f &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4579/129/2883606534/402336/c0ab3454/58f4be9aNa88ff55d.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;7a363758da054207a7829bc71c067ff9 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4711/194/2905881306/300662/354c71f4/58f4be9eN3858d371.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;b5570a8d55e342d78debf19cb7cc78ec &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5074/114/1812874516/291141/2b234d61/58f4bea3N57b1dc49.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;631b54dfe79a4386a270ac52b43601e0 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4558/216/2904854929/311698/e5cde300/58f4bea8N84638e42.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;4e24f156be064a92a2b982f16918fe17 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4651/282/2933925798/263231/520e0de5/58f4beacNdd238df4.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;65b8a12d3d624c1999dc71fa62e4ee69 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4513/228/2885938113/274379/aea49871/58f4beb1N16f180a4.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;51bd8e2665fe4e1186fc388ecfbb02b2 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5062/90/1813507660/282875/7b965889/58f4beb6N827b2e3e.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;fdd6f68cac804780b924bd0336138e33 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4840/74/1816524273/306802/48e2154/58f4bebbN04975284.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;5897b103dbeb45179e79b5717d8fb363 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4519/241/2946242299/281167/b90f22d2/58f4bec0N6dfa36d0.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;e289cfc629614fc4808c2772ecfc1f65 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4558/261/2951471661/285548/59ef01fa/58f4bec4Ndbfded1a.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;25bac2ee125a4e09a71a51e608853b7d &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4393/306/2938360022/262210/d43e461b/58f4bec9N23148dab.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;948d2f20d8e74c21a30f26088ac9c6a8 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4765/184/1800416008/271480/ca25ad2c/58f4becdN755b0d8f.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;442ce403518548bf8ca7d7e458065927 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4795/335/1847987448/269067/9a77e83c/58f4bed1Nfe94b07c.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;001ddecd00b54a97b7bd3d5283fec442 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4864/247/1798754946/285994/555a054/58f4bed6N3f0e33b9.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;407b8b1d3f124225a99e788671a5b60d &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4669/329/2724315383/292102/928ee953/58f4bedcNbbae251f.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;c648bf12dffb4f779a759f05ee468a67 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4951/356/1803441841/296020/a606567f/58f4bee1N45a5e163.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;30b3181934924dc78d6a529b5e167c35 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4972/252/1774085184/290581/9d01119b/58f4bee5N6b6119c5.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;886638b1e8284ba1ac6cf5c5600560a6 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4594/14/2920059442/299511/92d8e6c7/58f4beeaN1384f6fb.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;2d9c171bf5b64a7b9d8cf8dc17329ce2 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4702/357/2938299999/272322/72ba577c/58f4beeeNfdbb6dd2.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;770ac72352b04d2a9b811d22b224e359 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4867/331/1787865129/276323/9514d797/58f4bef2Nffc234db.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;6ed6788e815948e7a7a7241c1cdaf534 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4978/30/1804778775/279860/e6fbdfe6/58f4bef7Nf80341d2.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;2800009ae1684f90a52fc5d2ebb8fdd7 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4930/323/1793175512/200543/1a4dc6cf/58f4bef5N2d27fbe7.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;44e236dce8d14c5b9e70294b8e78afcf &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4507/233/2922682227/238552/669b6a75/58f4befeNe6c51047.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;6d93c500617b4f539fa1aaafbb6d4728 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4669/27/2758161390/246345/c76aadf7/58f4bf02N6d3f3e8c.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;85bd016677ac4aa0abc183b20ca589fa &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4555/96/2966892032/239429/6fbc77a4/58f4bf06N212aacb3.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;413702d30362406bbf406bbde0944b22 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4849/149/1778204900/205698/6d2a4328/58f4bf09N45f72250.jpg&quot; /&gt;&amp;nbsp;&lt;br /&gt;\r\n						&lt;/div&gt;\r\n						&lt;div id=&quot;activity_footer&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n						&lt;/div&gt;\r\n					&lt;/div&gt;\r\n				&lt;/div&gt;\r\n			&lt;/div&gt;\r\n			&lt;div id=&quot;J-detail-pop-tpl-bottom-new&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n			&lt;/div&gt;\r\n			&lt;div class=&quot;clb&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n			&lt;/div&gt;\r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n&lt;/div&gt;\r\n&lt;div class=&quot;m m-content guarantee&quot; id=&quot;guarantee&quot; style=&quot;margin:0px 0px 15px;padding:0px;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;div class=&quot;mt&quot; style=&quot;margin:0px;padding:10px;background-color:#F7F7F7;border:1px solid #EEEEEE;&quot;&gt;\r\n		&lt;h3 style=&quot;font-size:14px;font-family:&amp;quot;&quot;&gt;\r\n			售后保障\r\n		&lt;/h3&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;mc&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n		&lt;div class=&quot;item-detail item-detail-copyright&quot; style=&quot;margin:0px;padding:10px;&quot;&gt;\r\n			&lt;div class=&quot;serve-agree-bd&quot; style=&quot;margin:0px;padding:20px 20px 20px 62px;&quot;&gt;\r\n				&lt;span class=&quot;goods&quot; style=&quot;line-height:32px;vertical-align:bottom;background:url(&amp;quot;&quot;&gt;&lt;/span&gt;&amp;nbsp;&lt;strong&gt;卖家服务&lt;/strong&gt;&lt;span class=&quot;goods&quot; style=&quot;line-height:32px;vertical-align:bottom;background:url(&amp;quot;&quot;&gt;&lt;/span&gt;&amp;nbsp;&lt;strong&gt;京东承诺&lt;/strong&gt;京东平台卖家销售并发货的商品，由平台卖家提供发票和相应的售后服务。请您放心购买！&lt;br /&gt;\r\n注：因厂家会在没有任何提前通知的情况下更改产品包装、产地或者一些附件，本司不能确保客户收到的货物与商城图片、产地、附件说明完全一致。只能确保为原厂正货！并且保证与当时市场上同样主流新品一致。若本商城没有及时更新，请大家谅解！&lt;span class=&quot;goods&quot; style=&quot;line-height:32px;vertical-align:bottom;background:url(&amp;quot;&quot;&gt;&lt;/span&gt;&lt;strong&gt;正品行货&lt;/strong&gt;京东商城向您保证所售商品均为正品行货，京东自营商品开具机打发票或电子发票。&lt;span class=&quot;unprofor&quot; style=&quot;line-height:32px;vertical-align:bottom;background:url(&amp;quot;&quot;&gt;&lt;/span&gt;&lt;strong&gt;全国联保&lt;/strong&gt;凭质保证书及京东商城发票，可享受全国联保服务（奢侈品、钟表除外；奢侈品、钟表由京东联系保修，享受法定三包售后服务），与您亲临商场选购的商品享受相同的质量保证。京东商城还为您提供具有竞争力的商品价格和&lt;a href=&quot;https://help.jd.com/help/question-892.html&quot; target=&quot;_blank&quot;&gt;运费政策&lt;/a&gt;，请您放心购买！&amp;nbsp;&lt;br /&gt;\r\n注：因厂家会在没有任何提前通知的情况下更改产品包装、产地或者一些附件，本司不能确保客户收到的货物与商城图片、产地、附件说明完全一致。只能确保为原厂正货！并且保证与当时市场上同样主流新品一致。若本商城没有及时更新，请大家谅解！&lt;span class=&quot;no-worries&quot; style=&quot;line-height:32px;vertical-align:bottom;background:url(&amp;quot;&quot;&gt;&lt;/span&gt;&lt;strong&gt;无忧退换货&lt;/strong&gt;客户购买京东自营商品7日内（含7日，自客户收到商品之日起计算），在保证商品完好的前提下，可无理由退货。（部分商品除外，详情请见各商品细则）\r\n			&lt;/div&gt;\r\n			&lt;div id=&quot;state&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n				&lt;strong&gt;权利声明：&lt;/strong&gt;&lt;br /&gt;\r\n京东上的所有商品信息、客户评价、商品咨询、网友讨论等内容，是京东重要的经营资源，未经许可，禁止非法转载使用。\r\n				&lt;p&gt;\r\n					&lt;b&gt;注：&lt;/b&gt;本站商品信息均来自于合作方，其真实性、准确性和合法性由信息拥有者（合作方）负责。本站不提供任何保证，并不承担任何法律责任。\r\n				&lt;/p&gt;\r\n&lt;br /&gt;\r\n&lt;strong&gt;价格说明：&lt;/strong&gt;&lt;br /&gt;\r\n				&lt;p&gt;\r\n					&lt;b&gt;京东价：&lt;/b&gt;京东价为商品的销售价，是您最终决定是否购买商品的依据。\r\n				&lt;/p&gt;\r\n				&lt;p&gt;\r\n					&lt;b&gt;划线价：&lt;/b&gt;商品展示的划横线价格为参考价，该价格可能是品牌专柜标价、商品吊牌价或由品牌供应商提供的正品零售价（如厂商指导价、建议零售价等）或该商品在京东平台上曾经展示过的销售价；由于地区、时间的差异性和市场行情波动，品牌专柜标价、商品吊牌价等可能会与您购物时展示的不一致，该价格仅供您参考。\r\n				&lt;/p&gt;\r\n				&lt;p&gt;\r\n					&lt;b&gt;折扣：&lt;/b&gt;如无特殊说明，折扣指销售商在原价、或划线价（如品牌专柜标价、商品吊牌价、厂商指导价、厂商建议零售价）等某一价格基础上计算出的优惠比例或优惠金额；如有疑问，您可在购买前联系销售商进行咨询。\r\n				&lt;/p&gt;\r\n				&lt;p&gt;\r\n					&lt;b&gt;异常问题：&lt;/b&gt;商品促销信息以商品详情页“促销”栏中的信息为准；商品的具体售价以订单结算页价格为准；如您发现活动商品售价或促销信息有异常，建议购买前先联系销售商咨询。\r\n				&lt;/p&gt;\r\n			&lt;/div&gt;\r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n&lt;/div&gt;\r\n&lt;div class=&quot;ETab&quot; id=&quot;detail&quot; style=&quot;margin:0px;padding:0px;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;div class=&quot;tab-con&quot; style=&quot;margin:0px;padding:10px 0px;&quot;&gt;\r\n		&lt;div style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n			&lt;div class=&quot;detail-content clearfix&quot; style=&quot;margin:10px 0px;padding:0px;background:#F7F7F7;&quot;&gt;\r\n				&lt;div class=&quot;detail-content-wrap&quot; style=&quot;margin:0px;padding:0px;background-color:#FFFFFF;&quot;&gt;\r\n					&lt;div class=&quot;detail-content-item&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n						&lt;div id=&quot;J-detail-content&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n							&lt;img id=&quot;b592738631114b55b0512e98691227d3 &quot; alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4555/150/2968061805/324289/3ff0c1e8/58f4be0aNfaf5850a.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;748de2325f3b4977bc8bd39eddf4c1f8 &quot; alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4693/112/2916354487/276829/3474e4b8/58f4be0fN8abb662f.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;dccfbdf83a2e4144899c28492ba23595 &quot; alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4870/61/1802336877/188993/b60d0f29/58f4be12N18063ad1.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;f6cdaca7638c4a6aa82a4eefc49b42e5 &quot; alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5017/87/1821795717/162871/4decd835/58f4be14N14c8b6b8.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;fd27cde86aae48d5a3544a0d9795ae8b &quot; alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4606/112/2920202074/153175/ab16a2bd/58f4be17N69c223b9.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;c2a376c6a6f44652a22d47f25d46ce00 &quot; alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4423/230/2911169240/407125/f15f8604/58f4be1dNe0b12861.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;ebbb63ff4186495eb1467a20de33c5fb &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5005/32/1826336722/539698/7a52833b/58f4be26N016186c7.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;7c150c3bb6274473a67b01bb64a0b9f1 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4948/361/1797975627/302121/dca6af21/58f4be2bNdd5014c3.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;b6a6848978bf44b3a44214ce6f4b090c &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4501/117/2973297602/162677/c0b38642/58f4be2eN48349473.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;71b7fc3353ab4e7aa462f21f452c775b &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4783/281/1821449933/432449/62a46270/58f4be35N8f5b5960.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;27f6ea6d0ee04537a8382404859e506c &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5050/156/1815031340/208547/38903461/58f4be38N504974bb.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;8cc6baabf7f4461ba5ae63b0570c8df5 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4729/281/1854708548/288597/b18b6e34/58f4be37N7763caf3.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;3b60e5bdf5eb4df28d35869d14cff55e &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5074/217/1833324197/302109/66d30496/58f4be41Na0070bc7.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;9a03580cdec04799b95d7cb9adc531ca &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4825/202/1850637970/286959/c49e72a6/58f4be41Ncd55bb29.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;10a2affecd604780beb4e134fbdc8caf &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4747/220/1789314477/631431/b2180304/58f4be50Nfc07f9c5.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;583e8f9c9b324273b4e111f0ca506373 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4474/347/2916321648/256310/e38e555f/58f4be53Nef1600b9.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;dfb4c8bd80c148bc9d0f16a8e094ea1b &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4792/232/1805900200/283568/a9e6f92e/58f4be58N169fa023.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;f5d31fc7703f487795d2fbb7d6cd8d63 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4540/26/2939443188/340754/69010d12/58f4be5dN566b7c20.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;eefbffaeaa7b4803ac642ec2b4a8974b &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4657/341/3002642095/314767/4ac07ccf/58f4be60N75bfaa35.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;dc44c0e9ca6f4593acf5c39d149dc60d &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4933/297/1855988053/319121/4762988e/58f4be68Nec7da68b.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;fbbbd89bda1043559d7ed3cce5e9c09a &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4693/34/2966095876/365923/10008dc5/58f4be6eN0dda107f.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;bd17c76939fc46f090e22e9415254e5f &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4636/51/2942970517/297177/2cace293/58f4be72N78820923.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;7cbd8db8dca446d69ab120c46cec6a74 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4879/347/1766870524/304170/7c5a3965/58f4be77Nde5081cb.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;b201113c7788422c82da06cb8c2ec12d &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4570/20/2925246857/411247/c9ec01c4/58f4be7bN37789e31.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;e13d178e848e4fb180edee1b170cd660 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4936/99/1796584224/402242/c9368ed2/58f4be84Na8db9db0.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;7ca73887961b46f2914eeaaf587a670c &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4894/188/1834430775/304760/a917f51/58f4be89N7e3757e8.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;36b9e53991a149c4b35f6ff1258d76e0 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4687/220/2924634991/304760/b8192f66/58f4be8eN57a6c845.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;262bc3a9457d43269a5c3e80a4e04a27 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4654/133/2938177754/306053/45288c37/58f4be93Ncb1cd9d7.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;1fdb6749378a40668fa16bafe6cd911f &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4579/129/2883606534/402336/c0ab3454/58f4be9aNa88ff55d.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;7a363758da054207a7829bc71c067ff9 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4711/194/2905881306/300662/354c71f4/58f4be9eN3858d371.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;b5570a8d55e342d78debf19cb7cc78ec &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5074/114/1812874516/291141/2b234d61/58f4bea3N57b1dc49.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;631b54dfe79a4386a270ac52b43601e0 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4558/216/2904854929/311698/e5cde300/58f4bea8N84638e42.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;4e24f156be064a92a2b982f16918fe17 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4651/282/2933925798/263231/520e0de5/58f4beacNdd238df4.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;65b8a12d3d624c1999dc71fa62e4ee69 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4513/228/2885938113/274379/aea49871/58f4beb1N16f180a4.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;51bd8e2665fe4e1186fc388ecfbb02b2 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5062/90/1813507660/282875/7b965889/58f4beb6N827b2e3e.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;fdd6f68cac804780b924bd0336138e33 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4840/74/1816524273/306802/48e2154/58f4bebbN04975284.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;5897b103dbeb45179e79b5717d8fb363 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4519/241/2946242299/281167/b90f22d2/58f4bec0N6dfa36d0.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;e289cfc629614fc4808c2772ecfc1f65 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4558/261/2951471661/285548/59ef01fa/58f4bec4Ndbfded1a.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;25bac2ee125a4e09a71a51e608853b7d &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4393/306/2938360022/262210/d43e461b/58f4bec9N23148dab.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;948d2f20d8e74c21a30f26088ac9c6a8 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4765/184/1800416008/271480/ca25ad2c/58f4becdN755b0d8f.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;442ce403518548bf8ca7d7e458065927 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4795/335/1847987448/269067/9a77e83c/58f4bed1Nfe94b07c.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;001ddecd00b54a97b7bd3d5283fec442 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4864/247/1798754946/285994/555a054/58f4bed6N3f0e33b9.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;407b8b1d3f124225a99e788671a5b60d &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4669/329/2724315383/292102/928ee953/58f4bedcNbbae251f.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;c648bf12dffb4f779a759f05ee468a67 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4951/356/1803441841/296020/a606567f/58f4bee1N45a5e163.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;30b3181934924dc78d6a529b5e167c35 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4972/252/1774085184/290581/9d01119b/58f4bee5N6b6119c5.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;886638b1e8284ba1ac6cf5c5600560a6 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4594/14/2920059442/299511/92d8e6c7/58f4beeaN1384f6fb.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;2d9c171bf5b64a7b9d8cf8dc17329ce2 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4702/357/2938299999/272322/72ba577c/58f4beeeNfdbb6dd2.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;770ac72352b04d2a9b811d22b224e359 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4867/331/1787865129/276323/9514d797/58f4bef2Nffc234db.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;6ed6788e815948e7a7a7241c1cdaf534 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4978/30/1804778775/279860/e6fbdfe6/58f4bef7Nf80341d2.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;2800009ae1684f90a52fc5d2ebb8fdd7 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4930/323/1793175512/200543/1a4dc6cf/58f4bef5N2d27fbe7.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;44e236dce8d14c5b9e70294b8e78afcf &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4507/233/2922682227/238552/669b6a75/58f4befeNe6c51047.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;6d93c500617b4f539fa1aaafbb6d4728 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4669/27/2758161390/246345/c76aadf7/58f4bf02N6d3f3e8c.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;85bd016677ac4aa0abc183b20ca589fa &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4555/96/2966892032/239429/6fbc77a4/58f4bf06N212aacb3.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;413702d30362406bbf406bbde0944b22 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4849/149/1778204900/205698/6d2a4328/58f4bf09N45f72250.jpg&quot; /&gt;&amp;nbsp;&lt;br /&gt;\r\n						&lt;/div&gt;\r\n						&lt;div id=&quot;activity_footer&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n						&lt;/div&gt;\r\n					&lt;/div&gt;\r\n				&lt;/div&gt;\r\n			&lt;/div&gt;\r\n			&lt;div id=&quot;J-detail-pop-tpl-bottom-new&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n			&lt;/div&gt;\r\n			&lt;div class=&quot;clb&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n			&lt;/div&gt;\r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n&lt;/div&gt;\r\n&lt;div class=&quot;m m-content guarantee&quot; id=&quot;guarantee&quot; style=&quot;margin:0px 0px 15px;padding:0px;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;div class=&quot;mt&quot; style=&quot;margin:0px;padding:10px;background-color:#F7F7F7;border:1px solid #EEEEEE;&quot;&gt;\r\n		&lt;h3 style=&quot;font-size:14px;font-family:&amp;quot;&quot;&gt;\r\n			售后保障\r\n		&lt;/h3&gt;\r\n	&lt;/div&gt;\r\n	&lt;div class=&quot;mc&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n		&lt;div class=&quot;item-detail item-detail-copyright&quot; style=&quot;margin:0px;padding:10px;&quot;&gt;\r\n			&lt;div class=&quot;serve-agree-bd&quot; style=&quot;margin:0px;padding:20px 20px 20px 62px;&quot;&gt;\r\n				&lt;span class=&quot;goods&quot; style=&quot;line-height:32px;vertical-align:bottom;background:url(&amp;quot;&quot;&gt;&lt;/span&gt;&amp;nbsp;&lt;strong&gt;卖家服务&lt;/strong&gt;&lt;span class=&quot;goods&quot; style=&quot;line-height:32px;vertical-align:bottom;background:url(&amp;quot;&quot;&gt;&lt;/span&gt;&amp;nbsp;&lt;strong&gt;京东承诺&lt;/strong&gt;京东平台卖家销售并发货的商品，由平台卖家提供发票和相应的售后服务。请您放心购买！&lt;br /&gt;\r\n注：因厂家会在没有任何提前通知的情况下更改产品包装、产地或者一些附件，本司不能确保客户收到的货物与商城图片、产地、附件说明完全一致。只能确保为原厂正货！并且保证与当时市场上同样主流新品一致。若本商城没有及时更新，请大家谅解！&lt;span class=&quot;goods&quot; style=&quot;line-height:32px;vertical-align:bottom;background:url(&amp;quot;&quot;&gt;&lt;/span&gt;&lt;strong&gt;正品行货&lt;/strong&gt;京东商城向您保证所售商品均为正品行货，京东自营商品开具机打发票或电子发票。&lt;span class=&quot;unprofor&quot; style=&quot;line-height:32px;vertical-align:bottom;background:url(&amp;quot;&quot;&gt;&lt;/span&gt;&lt;strong&gt;全国联保&lt;/strong&gt;凭质保证书及京东商城发票，可享受全国联保服务（奢侈品、钟表除外；奢侈品、钟表由京东联系保修，享受法定三包售后服务），与您亲临商场选购的商品享受相同的质量保证。京东商城还为您提供具有竞争力的商品价格和&lt;a href=&quot;https://help.jd.com/help/question-892.html&quot; target=&quot;_blank&quot;&gt;运费政策&lt;/a&gt;，请您放心购买！&amp;nbsp;&lt;br /&gt;\r\n注：因厂家会在没有任何提前通知的情况下更改产品包装、产地或者一些附件，本司不能确保客户收到的货物与商城图片、产地、附件说明完全一致。只能确保为原厂正货！并且保证与当时市场上同样主流新品一致。若本商城没有及时更新，请大家谅解！&lt;span class=&quot;no-worries&quot; style=&quot;line-height:32px;vertical-align:bottom;background:url(&amp;quot;&quot;&gt;&lt;/span&gt;&lt;strong&gt;无忧退换货&lt;/strong&gt;客户购买京东自营商品7日内（含7日，自客户收到商品之日起计算），在保证商品完好的前提下，可无理由退货。（部分商品除外，详情请见各商品细则）\r\n			&lt;/div&gt;\r\n			&lt;div id=&quot;state&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n				&lt;strong&gt;权利声明：&lt;/strong&gt;&lt;br /&gt;\r\n京东上的所有商品信息、客户评价、商品咨询、网友讨论等内容，是京东重要的经营资源，未经许可，禁止非法转载使用。\r\n				&lt;p&gt;\r\n					&lt;b&gt;注：&lt;/b&gt;本站商品信息均来自于合作方，其真实性、准确性和合法性由信息拥有者（合作方）负责。本站不提供任何保证，并不承担任何法律责任。\r\n				&lt;/p&gt;\r\n&lt;br /&gt;\r\n&lt;strong&gt;价格说明：&lt;/strong&gt;&lt;br /&gt;\r\n				&lt;p&gt;\r\n					&lt;b&gt;京东价：&lt;/b&gt;京东价为商品的销售价，是您最终决定是否购买商品的依据。\r\n				&lt;/p&gt;\r\n				&lt;p&gt;\r\n					&lt;b&gt;划线价：&lt;/b&gt;商品展示的划横线价格为参考价，该价格可能是品牌专柜标价、商品吊牌价或由品牌供应商提供的正品零售价（如厂商指导价、建议零售价等）或该商品在京东平台上曾经展示过的销售价；由于地区、时间的差异性和市场行情波动，品牌专柜标价、商品吊牌价等可能会与您购物时展示的不一致，该价格仅供您参考。\r\n				&lt;/p&gt;\r\n				&lt;p&gt;\r\n					&lt;b&gt;折扣：&lt;/b&gt;如无特殊说明，折扣指销售商在原价、或划线价（如品牌专柜标价、商品吊牌价、厂商指导价、厂商建议零售价）等某一价格基础上计算出的优惠比例或优惠金额；如有疑问，您可在购买前联系销售商进行咨询。\r\n				&lt;/p&gt;\r\n				&lt;p&gt;\r\n					&lt;b&gt;异常问题：&lt;/b&gt;商品促销信息以商品详情页“促销”栏中的信息为准；商品的具体售价以订单结算页价格为准；如您发现活动商品售价或促销信息有异常，建议购买前先联系销售商咨询。&lt;img id=&quot;b592738631114b55b0512e98691227d3 &quot; alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4555/150/2968061805/324289/3ff0c1e8/58f4be0aNfaf5850a.jpg&quot; /&gt; \r\n				&lt;/p&gt;\r\n				&lt;div class=&quot;ETab&quot; id=&quot;detail&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n					&lt;div class=&quot;tab-con&quot; style=&quot;margin:0px;padding:10px 0px;&quot;&gt;\r\n						&lt;div style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n							&lt;div class=&quot;detail-content clearfix&quot; style=&quot;margin:10px 0px;padding:0px;background:#F7F7F7;&quot;&gt;\r\n								&lt;div class=&quot;detail-content-wrap&quot; style=&quot;margin:0px;padding:0px;background-color:#FFFFFF;&quot;&gt;\r\n									&lt;div class=&quot;detail-content-item&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n										&lt;div id=&quot;J-detail-content&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n											&lt;img id=&quot;748de2325f3b4977bc8bd39eddf4c1f8 &quot; alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4693/112/2916354487/276829/3474e4b8/58f4be0fN8abb662f.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;dccfbdf83a2e4144899c28492ba23595 &quot; alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4870/61/1802336877/188993/b60d0f29/58f4be12N18063ad1.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;f6cdaca7638c4a6aa82a4eefc49b42e5 &quot; alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5017/87/1821795717/162871/4decd835/58f4be14N14c8b6b8.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;fd27cde86aae48d5a3544a0d9795ae8b &quot; alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4606/112/2920202074/153175/ab16a2bd/58f4be17N69c223b9.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;c2a376c6a6f44652a22d47f25d46ce00 &quot; alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4423/230/2911169240/407125/f15f8604/58f4be1dNe0b12861.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;ebbb63ff4186495eb1467a20de33c5fb &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5005/32/1826336722/539698/7a52833b/58f4be26N016186c7.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;7c150c3bb6274473a67b01bb64a0b9f1 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4948/361/1797975627/302121/dca6af21/58f4be2bNdd5014c3.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;b6a6848978bf44b3a44214ce6f4b090c &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4501/117/2973297602/162677/c0b38642/58f4be2eN48349473.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;71b7fc3353ab4e7aa462f21f452c775b &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4783/281/1821449933/432449/62a46270/58f4be35N8f5b5960.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;27f6ea6d0ee04537a8382404859e506c &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5050/156/1815031340/208547/38903461/58f4be38N504974bb.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;8cc6baabf7f4461ba5ae63b0570c8df5 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4729/281/1854708548/288597/b18b6e34/58f4be37N7763caf3.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;3b60e5bdf5eb4df28d35869d14cff55e &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5074/217/1833324197/302109/66d30496/58f4be41Na0070bc7.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;9a03580cdec04799b95d7cb9adc531ca &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4825/202/1850637970/286959/c49e72a6/58f4be41Ncd55bb29.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;10a2affecd604780beb4e134fbdc8caf &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4747/220/1789314477/631431/b2180304/58f4be50Nfc07f9c5.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;583e8f9c9b324273b4e111f0ca506373 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4474/347/2916321648/256310/e38e555f/58f4be53Nef1600b9.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;dfb4c8bd80c148bc9d0f16a8e094ea1b &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4792/232/1805900200/283568/a9e6f92e/58f4be58N169fa023.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;f5d31fc7703f487795d2fbb7d6cd8d63 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4540/26/2939443188/340754/69010d12/58f4be5dN566b7c20.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;eefbffaeaa7b4803ac642ec2b4a8974b &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4657/341/3002642095/314767/4ac07ccf/58f4be60N75bfaa35.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;dc44c0e9ca6f4593acf5c39d149dc60d &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4933/297/1855988053/319121/4762988e/58f4be68Nec7da68b.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;fbbbd89bda1043559d7ed3cce5e9c09a &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4693/34/2966095876/365923/10008dc5/58f4be6eN0dda107f.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;bd17c76939fc46f090e22e9415254e5f &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4636/51/2942970517/297177/2cace293/58f4be72N78820923.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;7cbd8db8dca446d69ab120c46cec6a74 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4879/347/1766870524/304170/7c5a3965/58f4be77Nde5081cb.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;b201113c7788422c82da06cb8c2ec12d &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4570/20/2925246857/411247/c9ec01c4/58f4be7bN37789e31.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;e13d178e848e4fb180edee1b170cd660 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4936/99/1796584224/402242/c9368ed2/58f4be84Na8db9db0.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;7ca73887961b46f2914eeaaf587a670c &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4894/188/1834430775/304760/a917f51/58f4be89N7e3757e8.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;36b9e53991a149c4b35f6ff1258d76e0 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4687/220/2924634991/304760/b8192f66/58f4be8eN57a6c845.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;262bc3a9457d43269a5c3e80a4e04a27 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4654/133/2938177754/306053/45288c37/58f4be93Ncb1cd9d7.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;1fdb6749378a40668fa16bafe6cd911f &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4579/129/2883606534/402336/c0ab3454/58f4be9aNa88ff55d.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;7a363758da054207a7829bc71c067ff9 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4711/194/2905881306/300662/354c71f4/58f4be9eN3858d371.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;b5570a8d55e342d78debf19cb7cc78ec &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5074/114/1812874516/291141/2b234d61/58f4bea3N57b1dc49.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;631b54dfe79a4386a270ac52b43601e0 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4558/216/2904854929/311698/e5cde300/58f4bea8N84638e42.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;4e24f156be064a92a2b982f16918fe17 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4651/282/2933925798/263231/520e0de5/58f4beacNdd238df4.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;65b8a12d3d624c1999dc71fa62e4ee69 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4513/228/2885938113/274379/aea49871/58f4beb1N16f180a4.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;51bd8e2665fe4e1186fc388ecfbb02b2 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5062/90/1813507660/282875/7b965889/58f4beb6N827b2e3e.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;fdd6f68cac804780b924bd0336138e33 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4840/74/1816524273/306802/48e2154/58f4bebbN04975284.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;5897b103dbeb45179e79b5717d8fb363 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4519/241/2946242299/281167/b90f22d2/58f4bec0N6dfa36d0.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;e289cfc629614fc4808c2772ecfc1f65 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4558/261/2951471661/285548/59ef01fa/58f4bec4Ndbfded1a.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;25bac2ee125a4e09a71a51e608853b7d &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4393/306/2938360022/262210/d43e461b/58f4bec9N23148dab.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;948d2f20d8e74c21a30f26088ac9c6a8 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4765/184/1800416008/271480/ca25ad2c/58f4becdN755b0d8f.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;442ce403518548bf8ca7d7e458065927 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4795/335/1847987448/269067/9a77e83c/58f4bed1Nfe94b07c.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;001ddecd00b54a97b7bd3d5283fec442 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4864/247/1798754946/285994/555a054/58f4bed6N3f0e33b9.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;407b8b1d3f124225a99e788671a5b60d &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4669/329/2724315383/292102/928ee953/58f4bedcNbbae251f.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;c648bf12dffb4f779a759f05ee468a67 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4951/356/1803441841/296020/a606567f/58f4bee1N45a5e163.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;30b3181934924dc78d6a529b5e167c35 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4972/252/1774085184/290581/9d01119b/58f4bee5N6b6119c5.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;886638b1e8284ba1ac6cf5c5600560a6 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4594/14/2920059442/299511/92d8e6c7/58f4beeaN1384f6fb.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;2d9c171bf5b64a7b9d8cf8dc17329ce2 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4702/357/2938299999/272322/72ba577c/58f4beeeNfdbb6dd2.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;770ac72352b04d2a9b811d22b224e359 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4867/331/1787865129/276323/9514d797/58f4bef2Nffc234db.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;6ed6788e815948e7a7a7241c1cdaf534 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4978/30/1804778775/279860/e6fbdfe6/58f4bef7Nf80341d2.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;2800009ae1684f90a52fc5d2ebb8fdd7 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4930/323/1793175512/200543/1a4dc6cf/58f4bef5N2d27fbe7.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;44e236dce8d14c5b9e70294b8e78afcf &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4507/233/2922682227/238552/669b6a75/58f4befeNe6c51047.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;6d93c500617b4f539fa1aaafbb6d4728 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4669/27/2758161390/246345/c76aadf7/58f4bf02N6d3f3e8c.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;85bd016677ac4aa0abc183b20ca589fa &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4555/96/2966892032/239429/6fbc77a4/58f4bf06N212aacb3.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img id=&quot;413702d30362406bbf406bbde0944b22 &quot; alt=&quot;&quot; class=&quot;ELazy-loading&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4849/149/1778204900/205698/6d2a4328/58f4bf09N45f72250.jpg&quot; /&gt;&amp;nbsp;&lt;br /&gt;\r\n										&lt;/div&gt;\r\n										&lt;div id=&quot;activity_footer&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n										&lt;/div&gt;\r\n									&lt;/div&gt;\r\n								&lt;/div&gt;\r\n							&lt;/div&gt;\r\n							&lt;div id=&quot;J-detail-pop-tpl-bottom-new&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n							&lt;/div&gt;\r\n							&lt;div class=&quot;clb&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n							&lt;/div&gt;\r\n						&lt;/div&gt;\r\n					&lt;/div&gt;\r\n				&lt;/div&gt;\r\n				&lt;div class=&quot;m m-content guarantee&quot; id=&quot;guarantee&quot; style=&quot;margin:0px 0px 15px;padding:0px;&quot;&gt;\r\n					&lt;div class=&quot;mt&quot; style=&quot;margin:0px;padding:10px;background-color:#F7F7F7;border:1px solid #EEEEEE;&quot;&gt;\r\n						&lt;h3 style=&quot;font-size:14px;font-family:&amp;quot;&quot;&gt;\r\n							售后保障\r\n						&lt;/h3&gt;\r\n					&lt;/div&gt;\r\n					&lt;div class=&quot;mc&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n						&lt;div class=&quot;item-detail item-detail-copyright&quot; style=&quot;margin:0px;padding:10px;&quot;&gt;\r\n							&lt;div class=&quot;serve-agree-bd&quot; style=&quot;margin:0px;padding:20px 20px 20px 62px;&quot;&gt;\r\n								&lt;span class=&quot;goods&quot; style=&quot;line-height:32px;vertical-align:bottom;background:url(&amp;quot;&quot;&gt;&lt;/span&gt;&amp;nbsp;&lt;strong&gt;卖家服务&lt;/strong&gt;&lt;span class=&quot;goods&quot; style=&quot;line-height:32px;vertical-align:bottom;background:url(&amp;quot;&quot;&gt;&lt;/span&gt;&amp;nbsp;&lt;strong&gt;京东承诺&lt;/strong&gt;京东平台卖家销售并发货的商品，由平台卖家提供发票和相应的售后服务。请您放心购买！&lt;br /&gt;\r\n注：因厂家会在没有任何提前通知的情况下更改产品包装、产地或者一些附件，本司不能确保客户收到的货物与商城图片、产地、附件说明完全一致。只能确保为原厂正货！并且保证与当时市场上同样主流新品一致。若本商城没有及时更新，请大家谅解！&lt;span class=&quot;goods&quot; style=&quot;line-height:32px;vertical-align:bottom;background:url(&amp;quot;&quot;&gt;&lt;/span&gt;&lt;strong&gt;正品行货&lt;/strong&gt;京东商城向您保证所售商品均为正品行货，京东自营商品开具机打发票或电子发票。&lt;span class=&quot;unprofor&quot; style=&quot;line-height:32px;vertical-align:bottom;background:url(&amp;quot;&quot;&gt;&lt;/span&gt;&lt;strong&gt;全国联保&lt;/strong&gt;凭质保证书及京东商城发票，可享受全国联保服务（奢侈品、钟表除外；奢侈品、钟表由京东联系保修，享受法定三包售后服务），与您亲临商场选购的商品享受相同的质量保证。京东商城还为您提供具有竞争力的商品价格和&lt;a href=&quot;https://help.jd.com/help/question-892.html&quot; target=&quot;_blank&quot;&gt;运费政策&lt;/a&gt;，请您放心购买！&amp;nbsp;&lt;br /&gt;\r\n注：因厂家会在没有任何提前通知的情况下更改产品包装、产地或者一些附件，本司不能确保客户收到的货物与商城图片、产地、附件说明完全一致。只能确保为原厂正货！并且保证与当时市场上同样主流新品一致。若本商城没有及时更新，请大家谅解！&lt;span class=&quot;no-worries&quot; style=&quot;line-height:32px;vertical-align:bottom;background:url(&amp;quot;&quot;&gt;&lt;/span&gt;&lt;strong&gt;无忧退换货&lt;/strong&gt;客户购买京东自营商品7日内（含7日，自客户收到商品之日起计算），在保证商品完好的前提下，可无理由退货。（部分商品除外，详情请见各商品细则）\r\n							&lt;/div&gt;\r\n							&lt;div id=&quot;state&quot; style=&quot;margin:0px;padding:0px;&quot;&gt;\r\n								&lt;strong&gt;权利声明：&lt;/strong&gt;&lt;br /&gt;\r\n京东上的所有商品信息、客户评价、商品咨询、网友讨论等内容，是京东重要的经营资源，未经许可，禁止非法转载使用。\r\n								&lt;p&gt;\r\n									&lt;b&gt;注：&lt;/b&gt;本站商品信息均来自于合作方，其真实性、准确性和合法性由信息拥有者（合作方）负责。本站不提供任何保证，并不承担任何法律责任。\r\n								&lt;/p&gt;\r\n&lt;br /&gt;\r\n&lt;strong&gt;价格说明：&lt;/strong&gt;&lt;br /&gt;\r\n								&lt;p&gt;\r\n									&lt;b&gt;京东价：&lt;/b&gt;京东价为商品的销售价，是您最终决定是否购买商品的依据。\r\n								&lt;/p&gt;\r\n								&lt;p&gt;\r\n									&lt;b&gt;划线价：&lt;/b&gt;商品展示的划横线价格为参考价，该价格可能是品牌专柜标价、商品吊牌价或由品牌供应商提供的正品零售价（如厂商指导价、建议零售价等）或该商品在京东平台上曾经展示过的销售价；由于地区、时间的差异性和市场行情波动，品牌专柜标价、商品吊牌价等可能会与您购物时展示的不一致，该价格仅供您参考。\r\n								&lt;/p&gt;\r\n								&lt;p&gt;\r\n									&lt;b&gt;折扣：&lt;/b&gt;如无特殊说明，折扣指销售商在原价、或划线价（如品牌专柜标价、商品吊牌价、厂商指导价、厂商建议零售价）等某一价格基础上计算出的优惠比例或优惠金额；如有疑问，您可在购买前联系销售商进行咨询。\r\n								&lt;/p&gt;\r\n								&lt;p style=&quot;text-align:center;&quot;&gt;\r\n									&lt;b&gt;异常问题：&lt;/b&gt;商品促销信息以商品详情页“促销”栏中的信息为准；商品的具体售价以订单结算页价格为准；如您发现活动商品售价或促销信息有异常，建议购买前先联系销售商咨询。\r\n								&lt;/p&gt;\r\n							&lt;/div&gt;\r\n						&lt;/div&gt;\r\n					&lt;/div&gt;\r\n				&lt;/div&gt;\r\n			&lt;/div&gt;\r\n		&lt;/div&gt;\r\n	&lt;/div&gt;\r\n&lt;/div&gt;',	'',	'',	''),
(257,	257,	'&lt;img alt=&quot;&quot; id=&quot;15767b8aef94490a871dc3f02c7c5c30&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t3301/352/3920381974/365960/efc7f5a6/57fa0908Naddad763.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;line-height:18px;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&lt;img alt=&quot;&quot; id=&quot;c5179f24c69c430d89c1aa64d0b5dd3d&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t3103/303/3944524387/520755/f8fd417e/57fa0909N34510f2e.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;line-height:18px;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&lt;img alt=&quot;&quot; id=&quot;3e0207d4bf254338aa0f28aab001e5df&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t3214/277/3865541406/496957/d6640e94/57fa0908Nac6ef34e.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;line-height:18px;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&lt;img alt=&quot;&quot; id=&quot;a2723400dd6d42a98b3d52ccd2ec0f4c&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t1012/69/1519662480/458715/13ce7726/5731506aNb321e808.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;line-height:18px;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&lt;img alt=&quot;&quot; id=&quot;75209093e3e949d5878c763a6ab05911&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t2818/141/997044019/553239/1e310532/5731506bNa8643d0d.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;line-height:18px;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&lt;img alt=&quot;&quot; id=&quot;9df4a7d291a94cddba35b6599d2c8aaf&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t1513/317/1465035644/457489/5f1f56b7/5731506bN84752ac8.jpg&quot; /&gt;',	'',	'',	''),
(258,	258,	'&lt;img alt=&quot;&quot; class=&quot;&quot; src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2620/151/3964230083/353788/92a9e91/57a034b5Nc2a42c65.jpg&quot; /&gt;',	'',	'',	''),
(259,	259,	'&lt;img src=&quot;/uploads/image/20170831/59a77deb06e51.jpg&quot; alt=&quot;&quot; /&gt;',	'',	'',	''),
(260,	260,	'&lt;img alt=&quot;&quot; id=&quot;8e52844073f24934940dd1ed318f6733 &quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3277/191/1126579886/247292/b7089d09/57c689feN765da6f7.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;6c5d1debbef7434ca9484cdc675ce226 &quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3232/18/1093047209/132526/f3647cd1/57c689ffNa2e2e306.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;a30fe29c408145719f719c100a3ca64f &quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3289/137/1108943746/188904/586b09ac/57c68a01N32670a3b.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;f126d2acbfde44cca5ae69fcf127f9f7 &quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3112/359/1118492221/141417/df545f64/57c68a02N673fbab3.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;8a906f6022354111a141a1cb6a716191 &quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3043/131/1509546144/194611/2211ff2a/57c68a03N529e70c8.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;e04e9e85bcd042ec94d9048667ca6d77 &quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3211/27/1080112042/151219/6c304e7c/57c68a05N1a92d130.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;76d147a041f844da93d8bf69893aa5fd &quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3043/119/1539343727/138518/fddc9cb1/57c68a06N91b9aef0.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;42b251c7b0f6429eaffdde2252bb9495 &quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3151/252/1121823825/181993/1d3aa36d/57c68a07Na3121dee.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;0d972d5661434a2ab6b64efb25af9d9f &quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3241/335/1124080041/203847/92e6ef22/57c68a08N67ddde45.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;0746c9a238724cefb6e6e2d3cd9893a8 &quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3160/6/1138398380/167469/d5e04695/57c68a0aN7365c246.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;89d9f86ffd584c58a7f8473304ad1e6d &quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3238/84/1104569884/39957/2331667d/57c68a0bN8be381f4.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;781a0e75269e42bd84b8c51be8419d5a &quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3220/236/1048424056/143893/24caae96/57c68a0bNf0869884.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;ead768e4929f4ff7b7deb8c1d5ab5feb &quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3187/355/1116437912/129739/3627bddd/57c68a0cN87caa02d.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&amp;nbsp;&lt;/span&gt;',	'',	'',	''),
(261,	261,	'&lt;img alt=&quot;&quot; id=&quot;1361edf09a444f0b9276d71d25f51247&quot; class=&quot;&quot; src=&quot;https://img10.360buyimg.com/imgzone/jfs/t1750/133/1277462071/196567/e71af634/55e3ec39Ndbec9461.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&lt;img alt=&quot;&quot; id=&quot;73a98ebf41704373ab3db5e161f11c38&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t1351/311/583287144/235436/f4342083/559b3733N1554997f.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&lt;img alt=&quot;&quot; id=&quot;e81fa13fa2cc48e7ae6b44a88d169e80&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t784/260/1393985685/595988/73b8291f/559b3733N30f296d8.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&lt;img alt=&quot;&quot; id=&quot;0b193812a87f412f9636a4bda784a5d2&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t1771/207/1155372768/171154/57d7d63/55e12b2fNbe6f242f.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&lt;img alt=&quot;&quot; id=&quot;fcd409a8ea3d40b1980d5eb7ebc9caad&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t1324/312/933200146/164566/56a22b6c/55e42b78Nb2eac2a9.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&lt;img alt=&quot;&quot; id=&quot;91f042eaf4a940c0a85bc1d97f4a6e90&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t1303/221/680173963/190715/621f113a/559b3734Nc2b103b4.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&lt;img alt=&quot;&quot; id=&quot;051e0fd4513743a490c2d70cd2e6c8c6&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t1282/97/711161821/519958/56ee03f9/559b3735N88a37878.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&lt;img alt=&quot;&quot; id=&quot;9ab5667d932b4bc185e9bd20a4a6b1ff&quot; class=&quot;&quot; src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2374/117/2808045662/234966/7d72a35b/56f5ff49Ne4554ebc.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&lt;img alt=&quot;&quot; id=&quot;e780888a59064d3abe81829a55eba989&quot; class=&quot;&quot; src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2908/315/965632982/312166/349efeb1/572d5015N62d79d30.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&lt;img alt=&quot;&quot; id=&quot;8a85fcca7214417bacea3b1cb52344ac&quot; class=&quot;&quot; src=&quot;https://img10.360buyimg.com/imgzone/jfs/t1666/362/1491232275/351235/5af95b9c/572d5056Neff11fdc.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&lt;img alt=&quot;&quot; id=&quot;ea486ee2cc0545e1b35dc91c538429f4&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t1597/140/603914575/299825/8a223189/559b3736N4a884c86.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&lt;img alt=&quot;&quot; id=&quot;b7150e558306496e8897d3bc90f479be&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t934/289/1370949440/311992/6e05449e/559b3736N4d6ceaa4.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&lt;img alt=&quot;&quot; id=&quot;f1d46e491fc945769081f4af166e627a&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t1378/4/814583919/373745/ce8cf4cf/55e42b78N7152d9cf.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&lt;img alt=&quot;&quot; id=&quot;a1a1db712bc4442c866e746f22af23c5&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t1735/18/1340884528/258572/f25f14e3/55e4fe06Nddeefca2.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&lt;img alt=&quot;&quot; id=&quot;9e1cbb5347864f95ad0419f7774ecf24&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t1084/313/1406555882/163526/e91de3a9/559b3737N9a1469ce.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&lt;img alt=&quot;&quot; id=&quot;44ad4c0a727849d196f7401e2018c826&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t1102/48/1366557013/216834/bc744af3/559b3737N4cc71e21.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&lt;img alt=&quot;&quot; id=&quot;d2be55d9b3044ed0917fdb246607d8a9&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t1435/201/593804354/276312/f465ea82/559b3738Ncead965b.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&lt;img alt=&quot;&quot; id=&quot;db5d8b9c3f924212b85fc058fbd1c1f1&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t1000/302/1371250986/277674/e9880f01/559b3738Nff0e6ad2.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&lt;img alt=&quot;&quot; id=&quot;71a6be2f3b3e41ccb345ce5e1a32d2ee&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t1327/337/916281988/353727/6e57a8b2/55e42b79Nd281f746.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&lt;img alt=&quot;&quot; id=&quot;cc0d2a7653b944a783f2adf0a06e2398&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t1744/318/1290058443/99393/1e658745/55e42b79Nbabfbab0.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&lt;img alt=&quot;&quot; id=&quot;5e0fe90f6d4b422296cf507374847d90&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t1090/108/1383471301/185483/bae61eed/559b3743N7a30664d.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&lt;img alt=&quot;&quot; id=&quot;fce96911686344e6b2bec3f9497df6b2&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t1663/92/399319974/197974/d18e692e/559b3743N07bb66a4.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&lt;img alt=&quot;&quot; id=&quot;edf39cc957ea474190cd044a143db394&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t1813/12/1277279425/386929/2b13dff3/55e42b7aN56b37be6.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&lt;img alt=&quot;&quot; id=&quot;67d64c9a85e64959826f735c6e59c1bb&quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWareDetail/jfs/t1204/24/1389189319/295224/11857213/559b3744Nec1a8fc0.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&lt;img alt=&quot;&quot; id=&quot;e85220d0c0a1487ab371f721f2009447&quot; class=&quot;&quot; src=&quot;https://img10.360buyimg.com/imgzone/jfs/t2608/127/936582774/432633/d198bc82/572d511eN7323578c.jpg&quot; /&gt;',	'',	'',	''),
(262,	262,	'&lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;57fe7ec5822745cc9f68dd6275cd47de &quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2608/31/3558335758/240951/e135f6f1/579082bfNa1db012c.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;c0a1c5908c734e83999a87e165fd6806 &quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2998/270/33290668/250240/af203ff/579082c8N335aa7eb.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;br /&gt;\r\n&lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;786c8b3c998e4ebf9d51b965854a1cd5 &quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2767/8/4164368255/166848/43591057/57ad57a4N35351508.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;c7f8b32c6dbe4400bc82856a2304ea92 &quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2863/199/3477167496/134853/9635310d/579082cfNec5943b8.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;21ade3b6e63e4371983324df4589c616 &quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2827/18/3491376114/166842/14f7843e/579082d4N14fbe990.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;br /&gt;\r\n&lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;f7112d4079214e69b1210b8c63b4a723 &quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2665/32/3806777489/158773/e6e710c/579b31ccN8191d6c2.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;br /&gt;\r\n&lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;a189b9148de14d80ab33ca72fdb81c4e &quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2806/212/4118520189/226075/fd11b3/57ad57b4N911a36e4.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;16e94e08cdf64e48a6c71c9b1edb1ccb &quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2644/151/3479441108/157825/11fc47e2/579082e5N2b61c1c4.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;br /&gt;\r\n&lt;br /&gt;\r\n&lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;e9f640d508f24e4ba47e70048757a3d0 &quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t2884/352/4141366939/143706/8de2d7a1/57ad57c3N3bf80a67.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&lt;img alt=&quot;&quot; id=&quot;a61b3666101541c1a31b44af38a17bdd &quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t3292/76/252051279/139989/3d31f3dc/57ad57c4Nc74677e0.jpg&quot; /&gt;&lt;span style=&quot;color:#666666;font-family:tahoma, arial, &amp;quot;background-color:#FFFFFF;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;br /&gt;\r\n&lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;6eec1e95e33b4bf2be0258ede2a30c14 &quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4453/322/3560288706/185697/8ba81a7d/58fffe4dN1caeaf1b.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;9911313637af45e399f9743f1f5c0500 &quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5182/187/437467424/116745/bc0e34ba/58fffe4cNb530c823.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;fae11d108bf24692a9ee9ea5356ec235 &quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5539/306/447902157/392285/7a5f7b75/58fffe4eN6ed98731.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;742ce4c9c488452eb401d3b4ba627d5b &quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t5149/203/436140705/388991/267106e6/58fffe4eN7156a0c7.jpg&quot; /&gt;&lt;br /&gt;\r\n&lt;img alt=&quot;&quot; id=&quot;ca54373f5518425bbd9bd0e59a794e2c &quot; class=&quot;&quot; src=&quot;https://img30.360buyimg.com/popWaterMark/jfs/t4450/74/3545783947/403054/8055ad8e/58fffe4fN2a48d9fa.jpg&quot; /&gt;',	'',	'',	'');

DROP TABLE IF EXISTS `hanchao_goods_gallery`;
CREATE TABLE `hanchao_goods_gallery` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '相册主键',
  `goods_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品ID',
  `goods_img` char(100) NOT NULL COMMENT '图片url',
  `img_desc` varchar(100) NOT NULL COMMENT '图片描述',
  `img_sort` int(10) NOT NULL COMMENT '图片排序',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=358 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT COMMENT='商品相册表';

INSERT INTO `hanchao_goods_gallery` (`id`, `goods_id`, `goods_img`, `img_desc`, `img_sort`) VALUES
(1,	1,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/16551080809.jpg',	'',	0),
(2,	1,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/16551065808.jpg',	'',	0),
(3,	2,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/17181138192.jpg',	'',	0),
(4,	2,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/17181196514.jpg',	'',	0),
(5,	2,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/17181256224.jpg',	'',	0),
(6,	3,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/18590514445.jpg',	'',	0),
(7,	3,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/18590577286.jpg',	'',	0),
(8,	3,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/18590671851.jpg',	'',	0),
(9,	3,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/18590634582.jpg',	'',	0),
(10,	3,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/18590666389.jpg',	'',	0),
(11,	3,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/18590624557.jpg',	'',	0),
(12,	4,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/19143610528.jpg',	'',	0),
(13,	4,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/19143633695.jpg',	'',	0),
(14,	4,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/19143665483.jpg',	'',	0),
(15,	4,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/19143720479.jpg',	'',	0),
(16,	4,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/19143741031.jpg',	'',	0),
(17,	5,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/19210628387.jpg',	'',	0),
(18,	5,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/19210613915.jpg',	'',	0),
(19,	5,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/19210666435.jpg',	'',	0),
(26,	7,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/09021884286.jpg',	'',	0),
(27,	7,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/09021896287.jpg',	'',	0),
(28,	7,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/09021856228.jpg',	'',	0),
(29,	7,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/09021874408.jpg',	'',	0),
(30,	7,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/09021885181.jpg',	'',	0),
(31,	8,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/09213518992.jpg',	'',	0),
(32,	8,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/09213566319.jpg',	'',	0),
(33,	8,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/09213530110.jpg',	'',	0),
(34,	8,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/09213654052.jpg',	'',	0),
(35,	9,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/09332898264.jpg',	'',	0),
(36,	9,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/09332853846.jpg',	'',	0),
(37,	10,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/09390453465.jpg',	'',	0),
(38,	10,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/09390512807.jpg',	'',	0),
(39,	10,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/09390599172.jpg',	'',	0),
(40,	10,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/09390581861.jpg',	'',	0),
(41,	11,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/10011446027.jpg',	'',	0),
(42,	11,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/10011477168.jpg',	'',	0),
(43,	11,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/10011430688.jpg',	'',	0),
(44,	11,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/10011516921.jpg',	'',	0),
(45,	11,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/10011545099.jpg',	'',	0),
(46,	14,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170414/11322229945.jpg',	'',	1),
(47,	14,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170414/11322288318.jpg',	'',	2),
(48,	14,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170414/11322330866.jpg',	'',	3),
(49,	6,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/19255547800.jpg',	'',	0),
(50,	6,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/19255631816.jpg',	'',	0),
(51,	21,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170414/15265051509.png',	'',	2),
(52,	21,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170414/15265031714.png',	'',	1),
(53,	21,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170414/15265076441.png',	'',	3),
(54,	22,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170414/15352898877.png',	'',	2),
(55,	22,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170414/15352987332.png',	'',	1),
(56,	22,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170414/15352993824.png',	'',	3),
(57,	24,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170414/15534575566.png',	'',	2),
(58,	24,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170414/15534547461.png',	'',	1),
(59,	25,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170414/16032921941.jpg',	'',	0),
(60,	25,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170414/16033016916.png',	'',	0),
(61,	26,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170414/16102634609.png',	'',	0),
(62,	26,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170414/16102671580.png',	'',	0),
(71,	27,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170414/16143455319.jpg',	'',	2),
(72,	27,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170414/16143474315.jpg',	'',	12),
(73,	27,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170414/16143491925.jpg',	'',	12),
(74,	27,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170414/16143585317.jpg',	'',	12),
(75,	27,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170414/16143555054.jpg',	'',	11),
(76,	27,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170414/16143540896.jpg',	'11',	1),
(77,	27,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170414/16143559101.jpg',	'1',	2),
(78,	27,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170414/16143578043.jpg',	'2',	3),
(79,	28,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170414/16384067271.png',	'',	0),
(80,	28,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170414/16384184905.jpg',	'',	0),
(81,	29,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170414/16515499556.jpg',	'',	0),
(82,	29,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170414/16515538560.jpg',	'',	0),
(83,	35,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170424/14100080127.png',	'',	0),
(84,	35,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170424/14100194415.png',	'',	0),
(85,	36,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170424/16434788893.jpg',	'',	0),
(86,	36,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170424/16434736341.jpg',	'',	0),
(87,	36,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170424/16434743916.jpg',	'',	0),
(88,	40,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170426/16381439199.png',	'',	0),
(89,	40,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170426/16381473310.png',	'',	0),
(90,	40,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170426/16381419768.png',	'',	0),
(91,	40,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170426/16381573678.png',	'',	0),
(92,	41,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/09391965981.jpg',	'',	0),
(93,	41,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/09391992781.jpg',	'',	0),
(94,	42,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/09544397195.jpg',	'',	0),
(95,	42,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/09544361936.jpg',	'',	0),
(96,	42,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/09550080801.jpg',	'',	0),
(101,	39,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/10502641594.png',	'',	0),
(102,	39,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/10503672518.png',	'',	0),
(103,	39,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/10504772299.png',	'',	0),
(104,	39,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/10505426532.png',	'',	0),
(105,	43,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/10590752169.jpg',	'',	0),
(106,	43,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/10590790381.jpg',	'',	0),
(107,	43,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/10590776149.jpg',	'',	0),
(108,	44,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/11035746305.png',	'',	0),
(109,	44,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/11035734513.png',	'',	0),
(110,	44,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/11035993548.png',	'',	0),
(111,	44,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/11040010160.png',	'',	0),
(112,	45,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/11090586594.jpg',	'',	0),
(113,	45,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/11090530002.jpg',	'',	0),
(114,	45,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/11090581889.jpg',	'',	0),
(115,	45,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/11090673135.jpg',	'',	0),
(116,	45,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/11090673894.jpg',	'',	0),
(117,	45,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/11090663315.jpg',	'',	0),
(123,	47,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/11193884543.png',	'',	0),
(124,	47,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/11193987648.png',	'',	0),
(125,	47,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/11194043768.png',	'',	0),
(126,	47,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/11194065386.png',	'',	0),
(127,	47,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/11194175225.png',	'',	0),
(128,	48,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/13285795910.png',	'',	0),
(129,	48,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/13285899096.png',	'',	0),
(130,	48,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/13285840717.png',	'',	0),
(131,	48,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/13285851145.png',	'',	0),
(132,	49,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/14555945264.png',	'',	1),
(133,	49,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/14560044483.png',	'',	3),
(134,	49,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/14560055607.png',	'',	4),
(135,	49,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170427/14560047968.png',	'',	2),
(136,	52,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170428/14273046662.jpg',	'',	0),
(137,	52,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170428/14273070621.jpg',	'',	0),
(138,	52,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170428/14273038739.jpg',	'',	0),
(139,	52,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170428/14273020230.jpg',	'',	0),
(169,	63,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170506/11355470665.jpg',	'',	11),
(170,	63,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170506/11355564772.jpg',	'',	5),
(171,	63,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170506/11355520889.jpg',	'',	6),
(172,	63,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170506/11355580576.jpg',	'',	10),
(173,	63,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170506/11355550549.jpg',	'',	8),
(174,	63,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170506/11355548691.jpg',	'',	7),
(175,	63,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170506/11355673575.jpg',	'',	9),
(176,	63,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170506/13521269172.png',	'',	1),
(177,	63,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170506/13523741879.png',	'',	3),
(178,	63,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170506/13523836755.png',	'',	4),
(179,	63,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170506/13523913326.png',	'',	2),
(180,	67,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170506/14224239656.jpg',	'',	0),
(181,	67,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170506/14224328660.jpg',	'',	0),
(182,	67,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170506/14224332436.jpg',	'',	0),
(183,	67,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170506/14224427073.jpg',	'',	0),
(184,	67,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170506/14224416008.jpg',	'',	0),
(185,	68,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170506/14275561099.jpg',	'',	0),
(186,	68,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170506/14275565021.jpg',	'',	0),
(187,	68,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170506/14275574886.jpg',	'',	0),
(188,	13,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170506/17592038549.png',	'',	0),
(189,	13,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170506/17592078120.png',	'',	0),
(190,	71,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170509/15523771388.jpg',	'',	0),
(191,	71,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170509/15523760975.jpg',	'',	0),
(192,	71,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170509/15523855837.png',	'',	0),
(193,	71,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170509/15523873483.png',	'',	0),
(198,	72,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170513/10412319046.png',	'',	0),
(199,	72,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170513/10412411467.png',	'',	0),
(200,	72,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170513/10412449414.png',	'',	0),
(201,	72,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170513/10412416933.png',	'',	0),
(202,	77,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170524/10233740434.jpg',	'',	0),
(203,	77,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170524/10233711530.jpg',	'',	0),
(204,	77,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170524/10233785850.jpg',	'',	0),
(208,	75,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170524/10280333987.png',	'',	0),
(209,	75,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170524/10280367224.jpg',	'',	0),
(210,	75,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170524/10280355857.jpg',	'',	0),
(211,	76,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170524/10304674302.png',	'',	0),
(212,	76,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170524/10304640143.jpg',	'',	0),
(213,	76,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170524/10304696957.jpg',	'',	0),
(214,	78,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/15550485192.jpg',	'',	0),
(215,	79,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/15581152438.jpg',	'',	0),
(216,	80,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/16030775668.png',	'',	0),
(217,	81,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/16050963316.jpg',	'',	0),
(218,	82,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/16090290596.png',	'',	0),
(219,	83,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/16110361530.jpg',	'',	0),
(220,	84,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/16144369488.png',	'',	0),
(221,	85,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/16170626149.png',	'',	0),
(222,	86,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/16221017102.jpg',	'',	0),
(223,	87,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/16291666780.jpg',	'',	0),
(224,	88,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/16323613872.png',	'',	0),
(225,	89,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/16354252886.png',	'',	0),
(226,	90,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/16382341731.jpg',	'',	0),
(227,	91,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/16405036666.png',	'',	0),
(228,	92,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/17060274647.png',	'',	0),
(229,	92,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/17060346536.png',	'',	0),
(230,	93,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/17091444278.png',	'',	0),
(231,	94,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/17124242483.png',	'',	0),
(232,	95,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/17204659381.png',	'',	0),
(233,	96,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/17320423858.png',	'',	0),
(234,	97,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/17351688661.png',	'',	0),
(235,	98,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/17381716899.png',	'',	0),
(236,	99,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/17401999769.png',	'',	0),
(237,	192,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/15461740600.png',	'',	0),
(238,	192,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/15461889243.png',	'',	0),
(239,	192,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/15461918495.png',	'',	0),
(240,	192,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/15462037451.png',	'',	0),
(241,	194,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/16202797394.jpg',	'',	0),
(242,	194,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/16202813592.jpg',	'',	0),
(243,	194,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/16202810818.jpg',	'',	0),
(244,	193,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/16224187113.jpg',	'',	0),
(245,	193,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/16224232513.jpg',	'',	0),
(246,	193,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/16224265126.jpg',	'',	0),
(247,	195,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/16500628767.jpg',	'',	0),
(248,	195,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/16500683394.jpg',	'',	0),
(249,	195,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/16500721734.jpg',	'',	0),
(250,	196,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/16551569771.jpg',	'',	0),
(251,	196,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/16551566137.jpg',	'',	0),
(252,	196,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/16551589044.jpg',	'',	0),
(253,	198,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/17044465917.png',	'',	0),
(254,	198,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/17044459109.png',	'',	0),
(255,	198,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/17044576433.png',	'',	0),
(256,	199,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/17114480998.png',	'',	0),
(257,	199,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/17114452554.png',	'',	0),
(258,	200,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/17164591716.png',	'',	0),
(259,	200,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/17164615223.png',	'',	0),
(260,	201,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/17241516633.png',	'',	0),
(261,	201,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/17241611439.png',	'',	0),
(262,	201,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/17241666680.png',	'',	0),
(263,	197,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/19032530609.jpg',	'',	0),
(264,	197,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/19032586744.jpg',	'',	0),
(268,	187,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/09570318282.jpg',	'',	0),
(272,	202,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/09473677717.png',	'',	2),
(273,	202,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/09473624047.png',	'',	1),
(274,	202,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/09473739479.png',	'',	3),
(275,	203,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170809/11184057028.png',	'',	0),
(276,	203,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170809/11184016839.png',	'',	0),
(277,	203,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170809/11184097388.png',	'',	0),
(281,	240,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/14403757350.jpg',	'',	0),
(282,	240,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/14403763001.gif',	'',	0),
(283,	240,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/14403745652.gif',	'',	0),
(284,	240,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/14403766515.gif',	'',	0),
(285,	240,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/14403825320.gif',	'',	0),
(286,	240,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/14403839126.jpg',	'',	0),
(287,	240,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/14403877426.jpg',	'',	0),
(288,	240,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/14403873960.jpg',	'',	0),
(289,	239,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/14415023969.jpg',	'',	0),
(290,	239,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/14415086414.jpg',	'',	0),
(291,	239,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/14415067086.jpg',	'',	0),
(292,	239,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/14415077480.jpg',	'',	0),
(293,	239,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/14415151934.jpg',	'',	0),
(294,	239,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/14415180792.jpg',	'',	0),
(295,	239,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/14415175632.jpg',	'',	0),
(296,	239,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/14415186469.jpg',	'',	0),
(297,	239,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/14415127113.jpg',	'',	0),
(298,	239,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/14415119722.jpg',	'',	0),
(299,	239,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/14415111754.jpg',	'',	0),
(300,	238,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/14432061590.jpg',	'',	0),
(301,	238,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/14432066798.jpg',	'',	0),
(302,	238,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/14432132039.jpg',	'',	0),
(303,	238,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/14432119892.jpg',	'',	0),
(304,	238,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/14432134388.jpg',	'',	0),
(305,	238,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/14432151039.jpg',	'',	0),
(306,	238,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/14432188853.jpg',	'',	0),
(307,	238,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/14432181751.jpg',	'',	0),
(308,	238,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/14432237836.jpg',	'',	0),
(309,	238,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/14432273254.jpg',	'',	0),
(310,	238,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/14432277409.jpg',	'',	0),
(311,	241,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/15165797665.jpg',	'',	1),
(312,	241,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/15165749114.jpg',	'',	2),
(313,	241,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/15165892488.jpg',	'',	3),
(314,	241,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/15165843263.jpg',	'',	4),
(315,	241,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/15165845706.jpg',	'',	5),
(316,	241,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/15165885221.jpg',	'',	6),
(317,	241,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/15165816272.jpg',	'',	7),
(318,	241,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/15165818912.jpg',	'',	8),
(319,	242,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/15470922245.jpg',	'',	0),
(320,	242,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/15470964159.jpg',	'',	0),
(321,	242,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/15470999749.jpg',	'',	0),
(322,	242,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/15470938869.jpg',	'',	0),
(323,	242,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/15471020696.jpg',	'',	0),
(324,	242,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/15471096648.jpg',	'',	0),
(325,	242,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/15471046079.jpg',	'',	0),
(326,	242,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/15471050316.jpg',	'',	0),
(327,	242,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/15471057275.jpg',	'',	0),
(328,	242,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/15471134130.jpg',	'',	0),
(329,	242,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/15471126573.jpg',	'',	0),
(330,	242,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/15471176093.jpg',	'',	0),
(331,	242,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/15471177444.jpg',	'',	0),
(332,	242,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/15471118879.jpg',	'',	0),
(333,	242,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/15471166630.jpg',	'',	0),
(337,	204,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170809/14340578699.jpg',	'',	1),
(338,	204,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170809/14340519908.jpg',	'',	10),
(339,	204,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170809/14340584733.jpg',	'',	1),
(340,	253,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170826/14562299930.png',	'',	0),
(341,	253,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170826/14562326844.png',	'',	0),
(342,	253,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170826/14562369109.png',	'',	0),
(356,	259,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170831/11232567861.jpg',	'',	0),
(357,	259,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170831/11232633543.jpg',	'',	0);

DROP TABLE IF EXISTS `hanchao_goods_integral`;
CREATE TABLE `hanchao_goods_integral` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `goods_id` int(10) NOT NULL COMMENT '商品id',
  `integral` int(11) NOT NULL COMMENT '积分',
  `only_integral` int(11) NOT NULL COMMENT '纯积分',
  `money` decimal(10,2) NOT NULL COMMENT '金额',
  `is_hot` tinyint(2) NOT NULL COMMENT '是否热销',
  `status` tinyint(2) NOT NULL COMMENT '是否可兑换',
  `catid` int(10) NOT NULL COMMENT '商品分类id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 COMMENT='积分商品表';

INSERT INTO `hanchao_goods_integral` (`id`, `goods_id`, `integral`, `only_integral`, `money`, `is_hot`, `status`, `catid`) VALUES
(1,	7,	100,	1000,	0.01,	1,	1,	49),
(5,	87,	50,	550,	50.00,	1,	1,	49),
(6,	78,	50,	300,	25.00,	1,	1,	157),
(7,	81,	50,	500,	45.00,	1,	1,	157),
(11,	94,	5200,	0,	50.00,	0,	1,	116);

DROP TABLE IF EXISTS `hanchao_goods_type`;
CREATE TABLE `hanchao_goods_type` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '类型主键',
  `name` varchar(60) NOT NULL COMMENT '类型名字',
  `sort` smallint(5) NOT NULL DEFAULT '10' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否关闭禁用',
  `attr_group` tinyint(1) NOT NULL COMMENT '属性组',
  `shop_id` int(10) unsigned NOT NULL COMMENT '店铺ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=39 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='商品类型表';

INSERT INTO `hanchao_goods_type` (`id`, `name`, `sort`, `status`, `attr_group`, `shop_id`) VALUES
(10,	'食品',	10,	1,	0,	0),
(11,	'生活用品',	10,	1,	0,	0),
(12,	'生活服务',	10,	1,	0,	0),
(13,	'户外用品',	10,	1,	0,	0),
(14,	'重量',	10,	1,	0,	0),
(15,	'卫生巾',	10,	1,	0,	0),
(18,	'玩具',	10,	1,	0,	0),
(19,	'电器',	10,	1,	0,	0),
(20,	'手机',	10,	1,	0,	0),
(21,	'女装',	10,	1,	0,	0),
(22,	'男装',	10,	1,	0,	0),
(23,	'珠宝',	10,	1,	0,	0),
(24,	'手表',	10,	1,	0,	0),
(25,	'饮料酒水',	10,	1,	0,	0),
(27,	'移动电源',	10,	1,	0,	0),
(28,	'羽毛球',	10,	1,	0,	0),
(29,	'久途测试店铺自定义属性',	10,	1,	0,	4),
(30,	'小旺手机专卖店自定义属性',	10,	1,	0,	34),
(31,	'石家庄跃翔体育用品销售有限公司自定义属性',	10,	1,	0,	7),
(32,	'鲜花礼品',	10,	1,	0,	0),
(34,	'河北每天惠连锁超市自定义属性',	10,	1,	0,	40),
(35,	'鸿瑞品牌馆自定义属性',	10,	1,	0,	43),
(36,	'河北好实惠生活超市有限公司自定义属性',	10,	1,	0,	44),
(37,	'旺财自定义属性',	10,	1,	0,	48),
(38,	'沃兴沃速自定义属性',	10,	1,	0,	49);

DROP TABLE IF EXISTS `hanchao_group_goods`;
CREATE TABLE `hanchao_group_goods` (
  `parent_id` mediumint(8) NOT NULL COMMENT '父类id',
  `goods_id` mediumint(8) NOT NULL COMMENT '关联配件id',
  `goods_price` decimal(10,2) NOT NULL COMMENT '关联配件价格',
  `admin_id` tinyint(3) NOT NULL COMMENT '操作员id',
  PRIMARY KEY (`parent_id`,`goods_id`,`admin_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='商品关联配件备用表';


DROP TABLE IF EXISTS `hanchao_hooks`;
CREATE TABLE `hanchao_hooks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `name` varchar(40) NOT NULL DEFAULT '' COMMENT '钩子名称',
  `description` text NOT NULL COMMENT '描述',
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '类型',
  `update_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '更新时间',
  `addons` varchar(255) NOT NULL DEFAULT '' COMMENT '钩子挂载的插件 ''，''分割',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='钩子表';

INSERT INTO `hanchao_hooks` (`id`, `name`, `description`, `type`, `update_time`, `addons`, `status`) VALUES
(13,	'AdminIndex',	'首页小格子个性化显示',	1,	1382596073,	'',	1),
(16,	'app_begin',	'应用开始',	2,	1384481614,	'',	1),
(17,	'empty_hook',	'空白钩子',	1,	1400550325,	'',	1),
(19,	'weixin',	'微信插件必须加载的钩子',	1,	1400550325,	'',	1);

DROP TABLE IF EXISTS `hanchao_intro`;
CREATE TABLE `hanchao_intro` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文章ID',
  `pid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '父ID',
  `name` varchar(200) NOT NULL COMMENT '标题',
  `dirname` varchar(255) NOT NULL COMMENT '目录名称',
  `content` text NOT NULL COMMENT '文章内容',
  `uid` int(10) unsigned NOT NULL COMMENT '文章作者关联会有',
  `addtime` int(10) NOT NULL DEFAULT '0' COMMENT '文章添加时间',
  `updatetime` int(10) NOT NULL DEFAULT '0' COMMENT '文章更新时间',
  `count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点击量',
  `sort` smallint(5) NOT NULL DEFAULT '10' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否显示',
  `seotitle` varchar(255) NOT NULL COMMENT 'Seo标题',
  `seokeywords` varchar(255) NOT NULL COMMENT 'Seo关键字',
  `seodescription` varchar(255) NOT NULL COMMENT 'Seo描述',
  `tplname` varchar(50) NOT NULL DEFAULT '0' COMMENT '模板名称',
  `device` tinyint(3) unsigned NOT NULL COMMENT '设备（0:电脑端,1:移动端,2:其他）',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='简介表';

INSERT INTO `hanchao_intro` (`id`, `pid`, `name`, `dirname`, `content`, `uid`, `addtime`, `updatetime`, `count`, `sort`, `status`, `seotitle`, `seokeywords`, `seodescription`, `tplname`, `device`) VALUES
(1,	0,	'关于我们',	'aboutus',	'',	1,	1450768157,	1450852567,	0,	0,	1,	'',	'',	'',	'0',	0),
(2,	1,	'公司简介',	'introduce',	'&lt;p style=&quot;text-align:justify;text-indent:21.25pt;margin-left:0pt;&quot; class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-family:宋体;font-size:10.5pt;&quot;&gt;石家庄久途网络科技有限公司（简称JUMTOP）成\r\n立于2009年，是国内电商系统及服务提供的领导品牌。公司现有总员工近百人，共设8个职能部门，主要职能部门有：总经办、财务部、业务部、行政部、项目\r\n部、研发部、客户部，培训部。总部坐于河北省石家庄拥有600余平米的超现代化办公场地。经过多年的积累，公司汇聚了一大批高水平的专业人才，是业内富有\r\n实力和经验的专业团队。&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;text-indent:21.25pt;margin-left:0pt;&quot; class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-family:宋体;font-size:10.5pt;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-family:\'Times New Roman\';font-size:10.5pt;&quot;&gt;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;text-indent:21.25pt;margin-left:0pt;&quot; class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-family:宋体;font-size:10.5pt;&quot;&gt;JUMTOP始终秉承着“科技改变未来”的理念，&amp;nbsp;旗下拥有汉潮O2O商城类系列产品、汉潮互联网金融类系列产品、微信营销类系列产品及为用户提供移动端“定制”开发的解决方案。&lt;/span&gt;&lt;span style=&quot;font-family:宋体;font-size:12pt;&quot;&gt;&amp;nbsp;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;text-indent:21.25pt;margin-left:0pt;&quot; class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-family:宋体;font-size:12pt;&quot;&gt;&lt;/span&gt;&lt;span style=&quot;font-family:\'Times New Roman\';font-size:10.5pt;&quot;&gt;&lt;/span&gt;&amp;nbsp;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;text-indent:21.25pt;margin-left:0pt;&quot; class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-family:宋体;font-size:10.5pt;&quot;&gt;“JUMTOP”作为较早且持续时间久的电子商务解\r\n决方案服务提供商，历经多年的积极进取与自主创新，JUMTOP已成为众多知名电商企业选择的品牌，服务客户遍及金融、电商、保险、地产、教育等数十个行\r\n业，拥有超过2000的用户量，拥有极高的市场占有率。持续领跑中国电子商务软件及服务行业。&lt;/span&gt;&lt;span style=&quot;font-family:宋体;font-size:12pt;&quot;&gt;&amp;nbsp;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;text-indent:21.25pt;margin-left:0pt;&quot; class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-family:宋体;font-size:12pt;&quot;&gt;&lt;/span&gt;&lt;span style=&quot;font-family:\'Times New Roman\';font-size:10.5pt;&quot;&gt;&lt;/span&gt;&amp;nbsp;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;margin-left:0pt;&quot; class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-family:宋体;font-size:10.5pt;&quot;&gt;&amp;nbsp;&amp;nbsp; JUMTOP凭借优质的服务、创新进取的精神、专业的团队倍受客户青睐。创立至今获得：河北省百佳优秀服务软件企业、高新技术企业、&quot;&amp;nbsp;双软认证&quot;软件企业、“汉潮”系列的数个软件著作权。&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;margin-left:0pt;&quot; class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-family:宋体;font-size:10.5pt;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-family:\'Times New Roman\';font-size:10.5pt;&quot;&gt;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot; class=&quot;p&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Times New Roman\';font-size:12pt;&quot;&gt;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot; class=&quot;p&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Times New Roman\';font-size:10.5pt;&quot;&gt;&amp;nbsp;&amp;nbsp; 为迎合广大互联网企业对互联网&lt;span&gt;IT&lt;/span&gt;&lt;span&gt;人才的迫切需求并弥补各大院校对互联网&lt;/span&gt;&lt;span&gt;IT&lt;/span&gt;&lt;span&gt;人才输出的不足，我们在&lt;/span&gt;&lt;span&gt;2013&lt;/span&gt;&lt;span&gt;年与多家企业合作成立&lt;/span&gt;&lt;span&gt;IT&lt;/span&gt;&lt;span&gt;人才培训部。凭借多年来对市场的敏锐洞察力和丰富的实战经验，公司建立起完善的课程体系，让学员在学习中就可以掌握工作当中遇到问题的解决办法。课程覆盖&amp;nbsp;&lt;/span&gt;&lt;span&gt;PHP&lt;/span&gt;&lt;span&gt;工程师、前端设计师、安卓及&lt;/span&gt;&lt;span&gt;IOS&lt;/span&gt;&lt;span&gt;工程师等，已为数十家企业输送了大量的&lt;/span&gt;&lt;span&gt;IT&lt;/span&gt;&lt;span&gt;人才。&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-family:\'Times New Roman\';font-size:12pt;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-family:\'Times New Roman\';font-size:12pt;&quot;&gt;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot; class=&quot;p&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Times New Roman\';font-size:10.5pt;&quot;&gt;&lt;br /&gt;\r\n&lt;/span&gt;&lt;span style=&quot;font-family:\'Times New Roman\';font-size:10.5pt;&quot;&gt;&amp;nbsp;&amp;nbsp; 公司以技术为本，始终以卓越的市场前瞻性和技术创新性推动着互联网及移动互联网领域的产品创新发展进程。我们追求卓越的产品品质以及完美的用户体验，提倡&lt;span&gt;&quot;&lt;/span&gt;&lt;span&gt;以顾客体验为根本导向&lt;/span&gt;&lt;span&gt;&quot;&lt;/span&gt;&lt;span&gt;。首先将目标客户群体的用户体验科学的通过人机交互自然完美、友好的呈现出来。旨在为客户创作具有革新性用户体验、简单方便、安全的、实用的产品及解决方案。&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-family:\'Times New Roman\';font-size:12pt;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-family:\'Times New Roman\';font-size:12pt;&quot;&gt;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;margin-left:0pt;&quot; class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Times New Roman\';font-size:10.5pt;&quot;&gt;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:center;&quot;&gt;\r\n	&amp;nbsp;\r\n&lt;/p&gt;\r\n&lt;p align=&quot;center&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;http://hanchao9999.com/uploads/image/20151016/18384846848.jpg&quot; /&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; &lt;img alt=&quot;&quot; src=&quot;http://hanchao9999.com/uploads/image/20151016/18391726758.jpg&quot; /&gt; \r\n&lt;/p&gt;\r\n&lt;p align=&quot;center&quot;&gt;\r\n	&amp;nbsp; &amp;nbsp;&amp;nbsp;&lt;img alt=&quot;&quot; src=&quot;http://hanchao9999.com/uploads/image/20151016/18400346900.jpg&quot; /&gt; \r\n&lt;/p&gt;\r\n&lt;p align=&quot;center&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;http://hanchao9999.com/uploads/image/20151016/18402263197.jpg&quot; /&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&lt;img alt=&quot;&quot; src=&quot;http://hanchao9999.com/uploads/image/20151016/18403425861.jpg&quot; /&gt; \r\n&lt;/p&gt;',	1,	1450770074,	1450852650,	0,	1,	1,	'',	'',	'',	'0',	0),
(3,	1,	'公司资质',	'aptitude',	'&lt;p style=&quot;text-align:left;&quot; align=&quot;center&quot;&gt;\r\n	&amp;nbsp;&lt;img title=&quot;&quot; src=&quot;http://hanchao9999.com/uploads/image/20151016/15463625987.jpg&quot; alt=&quot;&quot; align=&quot;&quot; height=&quot;276&quot; width=&quot;400&quot; /&gt;&amp;nbsp;&amp;nbsp; &lt;img title=&quot;&quot; src=&quot;http://hanchao9999.com/uploads/image/20151016/15470916507.jpg&quot; alt=&quot;&quot; align=&quot;&quot; height=&quot;276&quot; width=&quot;400&quot; /&gt;&amp;nbsp;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:left;&quot; align=&quot;center&quot;&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:left;&quot; align=&quot;center&quot;&gt;\r\n	&amp;nbsp;&lt;img title=&quot;&quot; src=&quot;http://hanchao9999.com/uploads/image/20151016/15481473559.jpg&quot; alt=&quot;&quot; align=&quot;&quot; height=&quot;276&quot; width=&quot;400&quot; /&gt; &amp;nbsp; &lt;img title=&quot;&quot; src=&quot;http://hanchao9999.com/uploads/image/20151016/15485688634.jpg&quot; alt=&quot;&quot; align=&quot;&quot; height=&quot;276&quot; width=&quot;400&quot; /&gt;&amp;nbsp; &amp;nbsp;&amp;nbsp;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:left;&quot;&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:left;&quot;&gt;\r\n	&lt;img title=&quot;&quot; src=&quot;http://hanchao9999.com/uploads/image/20151016/18490537674.jpg&quot; alt=&quot;&quot; align=&quot;&quot; height=&quot;549&quot; width=&quot;400&quot; /&gt;&amp;nbsp; &lt;img title=&quot;&quot; src=&quot;http://hanchao9999.com/uploads/image/20151016/18492873922.jpg&quot; alt=&quot;&quot; align=&quot;&quot; height=&quot;549&quot; width=&quot;400&quot; /&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:left;&quot;&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:left;&quot;&gt;\r\n	&lt;img title=&quot;&quot; src=&quot;http://hanchao9999.com/uploads/image/20151016/18522752997.png&quot; alt=&quot;&quot; align=&quot;&quot; height=&quot;553&quot; width=&quot;400&quot; /&gt;&amp;nbsp; &lt;img title=&quot;&quot; src=&quot;http://hanchao9999.com/uploads/image/20151016/18524178086.png&quot; alt=&quot;&quot; align=&quot;&quot; height=&quot;541&quot; width=&quot;400&quot; /&gt; \r\n&lt;/p&gt;',	1,	1450770137,	1450852605,	0,	2,	1,	'',	'',	'',	'0',	0),
(4,	1,	'联系我们',	'contactus',	'&lt;span style=&quot;font-size:14px;&quot;&gt;久途汉潮：&lt;/span&gt;&lt;span style=&quot;line-height:150%;font-size:14px;&quot;&gt;河北省石家庄市桥西区中华南大街壹江国际B座1206-1210室&lt;/span&gt; \r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-size:14px;&quot;&gt;&amp;nbsp;邮编：050000&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-size:14px;&quot;&gt;&amp;nbsp;邮箱：&lt;/span&gt;&lt;a href=&quot;mailto:sevice@thinkoao.com&quot;&gt;&lt;span style=&quot;font-size:14px;&quot;&gt;sevice@thinkoao.com&lt;/span&gt;&lt;/a&gt; \r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;line-height:150%;font-size:14px;&quot;&gt;电话：400-0311-340&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-size:14px;&quot;&gt;客服：&lt;a target=&quot;_blank&quot; href=&quot;http://wpa.qq.com/msgrd?v=3&amp;amp;uin=2880926116&amp;amp;site=qq&amp;amp;menu=yes&quot;&gt;&lt;img src=&quot;http://wpa.qq.com/pa?p=2:2880926116:41&quot; alt=&quot;2880926116&quot; title=&quot;2880926116&quot; border=&quot;0&quot; /&gt;&lt;/a&gt;&amp;nbsp;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-size:14px;&quot;&gt;工作时间：周一~周六&amp;nbsp;08:30~18:00&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-size:14px;&quot;&gt;乘车路线：1环1路，1环2路，8路，13路，&amp;nbsp;22路，36路，9路，&amp;nbsp;20路，59路，319路，344路&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	&amp;nbsp;&lt;img src=&quot;http://hanchao9999.com/uploads/image/20151015/17203180285.jpg&quot; alt=&quot;&quot; width=&quot;935px&quot; /&gt; \r\n&lt;/p&gt;',	1,	1450770223,	1465367185,	0,	3,	1,	'',	'',	'',	'0',	0),
(5,	0,	'关于我们',	'aboutus_d',	'',	1,	1450768157,	1450852567,	0,	0,	1,	'',	'',	'',	'0',	1),
(6,	5,	'公司简介',	'introduce_d',	'&lt;p style=&quot;text-align:justify;text-indent:21.25pt;margin-left:0pt;&quot; class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-family:宋体;font-size:10.5pt;&quot;&gt;石家庄久途网络科技有限公司（简称JUMTOP）成\r\n立于2009年，是国内电商系统及服务提供的领导品牌。公司现有总员工近百人，共设8个职能部门，主要职能部门有：总经办、财务部、业务部、行政部、项目\r\n部、研发部、客户部，培训部。总部坐于河北省石家庄拥有600余平米的超现代化办公场地。经过多年的积累，公司汇聚了一大批高水平的专业人才，是业内富有\r\n实力和经验的专业团队。&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;text-indent:21.25pt;margin-left:0pt;&quot; class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-family:宋体;font-size:10.5pt;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-family:\'Times New Roman\';font-size:10.5pt;&quot;&gt;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;text-indent:21.25pt;margin-left:0pt;&quot; class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-family:宋体;font-size:10.5pt;&quot;&gt;JUMTOP始终秉承着“科技改变未来”的理念，&amp;nbsp;旗下拥有汉潮O2O商城类系列产品、汉潮互联网金融类系列产品、微信营销类系列产品及为用户提供移动端“定制”开发的解决方案。&lt;/span&gt;&lt;span style=&quot;font-family:宋体;font-size:12pt;&quot;&gt;&amp;nbsp;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;text-indent:21.25pt;margin-left:0pt;&quot; class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-family:宋体;font-size:12pt;&quot;&gt;&lt;/span&gt;&lt;span style=&quot;font-family:\'Times New Roman\';font-size:10.5pt;&quot;&gt;&lt;/span&gt;&amp;nbsp;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;text-indent:21.25pt;margin-left:0pt;&quot; class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-family:宋体;font-size:10.5pt;&quot;&gt;“JUMTOP”作为较早且持续时间久的电子商务解\r\n决方案服务提供商，历经多年的积极进取与自主创新，JUMTOP已成为众多知名电商企业选择的品牌，服务客户遍及金融、电商、保险、地产、教育等数十个行\r\n业，拥有超过2000的用户量，拥有极高的市场占有率。持续领跑中国电子商务软件及服务行业。&lt;/span&gt;&lt;span style=&quot;font-family:宋体;font-size:12pt;&quot;&gt;&amp;nbsp;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;text-indent:21.25pt;margin-left:0pt;&quot; class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-family:宋体;font-size:12pt;&quot;&gt;&lt;/span&gt;&lt;span style=&quot;font-family:\'Times New Roman\';font-size:10.5pt;&quot;&gt;&lt;/span&gt;&amp;nbsp;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;margin-left:0pt;&quot; class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-family:宋体;font-size:10.5pt;&quot;&gt;&amp;nbsp;&amp;nbsp; JUMTOP凭借优质的服务、创新进取的精神、专业的团队倍受客户青睐。创立至今获得：河北省百佳优秀服务软件企业、高新技术企业、&quot;&amp;nbsp;双软认证&quot;软件企业、“汉潮”系列的数个软件著作权。&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;margin-left:0pt;&quot; class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-family:宋体;font-size:10.5pt;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-family:\'Times New Roman\';font-size:10.5pt;&quot;&gt;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot; class=&quot;p&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Times New Roman\';font-size:12pt;&quot;&gt;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot; class=&quot;p&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Times New Roman\';font-size:10.5pt;&quot;&gt;&amp;nbsp;&amp;nbsp; 为迎合广大互联网企业对互联网&lt;span&gt;IT&lt;/span&gt;&lt;span&gt;人才的迫切需求并弥补各大院校对互联网&lt;/span&gt;&lt;span&gt;IT&lt;/span&gt;&lt;span&gt;人才输出的不足，我们在&lt;/span&gt;&lt;span&gt;2013&lt;/span&gt;&lt;span&gt;年与多家企业合作成立&lt;/span&gt;&lt;span&gt;IT&lt;/span&gt;&lt;span&gt;人才培训部。凭借多年来对市场的敏锐洞察力和丰富的实战经验，公司建立起完善的课程体系，让学员在学习中就可以掌握工作当中遇到问题的解决办法。课程覆盖&amp;nbsp;&lt;/span&gt;&lt;span&gt;PHP&lt;/span&gt;&lt;span&gt;工程师、前端设计师、安卓及&lt;/span&gt;&lt;span&gt;IOS&lt;/span&gt;&lt;span&gt;工程师等，已为数十家企业输送了大量的&lt;/span&gt;&lt;span&gt;IT&lt;/span&gt;&lt;span&gt;人才。&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-family:\'Times New Roman\';font-size:12pt;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-family:\'Times New Roman\';font-size:12pt;&quot;&gt;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot; class=&quot;p&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Times New Roman\';font-size:10.5pt;&quot;&gt;&lt;br /&gt;\r\n&lt;/span&gt;&lt;span style=&quot;font-family:\'Times New Roman\';font-size:10.5pt;&quot;&gt;&amp;nbsp;&amp;nbsp; 公司以技术为本，始终以卓越的市场前瞻性和技术创新性推动着互联网及移动互联网领域的产品创新发展进程。我们追求卓越的产品品质以及完美的用户体验，提倡&lt;span&gt;&quot;&lt;/span&gt;&lt;span&gt;以顾客体验为根本导向&lt;/span&gt;&lt;span&gt;&quot;&lt;/span&gt;&lt;span&gt;。首先将目标客户群体的用户体验科学的通过人机交互自然完美、友好的呈现出来。旨在为客户创作具有革新性用户体验、简单方便、安全的、实用的产品及解决方案。&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-family:\'Times New Roman\';font-size:12pt;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-family:\'Times New Roman\';font-size:12pt;&quot;&gt;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;margin-left:0pt;&quot; class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Times New Roman\';font-size:10.5pt;&quot;&gt;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:center;&quot;&gt;\r\n	&amp;nbsp;\r\n&lt;/p&gt;\r\n&lt;p align=&quot;center&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;http://hanchao9999.com/uploads/image/20151016/18384846848.jpg&quot; /&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp; &lt;img alt=&quot;&quot; src=&quot;http://hanchao9999.com/uploads/image/20151016/18391726758.jpg&quot; /&gt; \r\n&lt;/p&gt;\r\n&lt;p align=&quot;center&quot;&gt;\r\n	&amp;nbsp; &amp;nbsp;&amp;nbsp;&lt;img alt=&quot;&quot; src=&quot;http://hanchao9999.com/uploads/image/20151016/18400346900.jpg&quot; /&gt; \r\n&lt;/p&gt;\r\n&lt;p align=&quot;center&quot;&gt;\r\n	&lt;img alt=&quot;&quot; src=&quot;http://hanchao9999.com/uploads/image/20151016/18402263197.jpg&quot; /&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&lt;img alt=&quot;&quot; src=&quot;http://hanchao9999.com/uploads/image/20151016/18403425861.jpg&quot; /&gt; \r\n&lt;/p&gt;',	1,	1450770074,	1450852650,	0,	1,	1,	'',	'',	'',	'0',	1),
(7,	5,	'公司资质',	'aptitude_d',	'&lt;p style=&quot;text-align:left;&quot; align=&quot;center&quot;&gt;\r\n	&amp;nbsp;&lt;img title=&quot;&quot; src=&quot;http://hanchao9999.com/uploads/image/20151016/15463625987.jpg&quot; alt=&quot;&quot; align=&quot;&quot; height=&quot;276&quot; width=&quot;400&quot; /&gt;&amp;nbsp;&amp;nbsp; &lt;img title=&quot;&quot; src=&quot;http://hanchao9999.com/uploads/image/20151016/15470916507.jpg&quot; alt=&quot;&quot; align=&quot;&quot; height=&quot;276&quot; width=&quot;400&quot; /&gt;&amp;nbsp;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:left;&quot; align=&quot;center&quot;&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:left;&quot; align=&quot;center&quot;&gt;\r\n	&amp;nbsp;&lt;img title=&quot;&quot; src=&quot;http://hanchao9999.com/uploads/image/20151016/15481473559.jpg&quot; alt=&quot;&quot; align=&quot;&quot; height=&quot;276&quot; width=&quot;400&quot; /&gt; &amp;nbsp; &lt;img title=&quot;&quot; src=&quot;http://hanchao9999.com/uploads/image/20151016/15485688634.jpg&quot; alt=&quot;&quot; align=&quot;&quot; height=&quot;276&quot; width=&quot;400&quot; /&gt;&amp;nbsp; &amp;nbsp;&amp;nbsp;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:left;&quot;&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:left;&quot;&gt;\r\n	&lt;img title=&quot;&quot; src=&quot;http://hanchao9999.com/uploads/image/20151016/18490537674.jpg&quot; alt=&quot;&quot; align=&quot;&quot; height=&quot;549&quot; width=&quot;400&quot; /&gt;&amp;nbsp; &lt;img title=&quot;&quot; src=&quot;http://hanchao9999.com/uploads/image/20151016/18492873922.jpg&quot; alt=&quot;&quot; align=&quot;&quot; height=&quot;549&quot; width=&quot;400&quot; /&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:left;&quot;&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:left;&quot;&gt;\r\n	&lt;img title=&quot;&quot; src=&quot;http://hanchao9999.com/uploads/image/20151016/18522752997.png&quot; alt=&quot;&quot; align=&quot;&quot; height=&quot;553&quot; width=&quot;400&quot; /&gt;&amp;nbsp; &lt;img title=&quot;&quot; src=&quot;http://hanchao9999.com/uploads/image/20151016/18524178086.png&quot; alt=&quot;&quot; align=&quot;&quot; height=&quot;541&quot; width=&quot;400&quot; /&gt; \r\n&lt;/p&gt;',	1,	1450770137,	1450852605,	0,	2,	1,	'',	'',	'',	'0',	1),
(8,	5,	'联系我们',	'contactus_d',	'&lt;span style=&quot;font-size:14px;&quot;&gt;久途汉潮：&lt;/span&gt;&lt;span style=&quot;line-height:150%;font-size:14px;&quot;&gt;河北省石家庄市桥西区中华南大街壹江国际B座1206-1210室&lt;/span&gt; \r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-size:14px;&quot;&gt;&amp;nbsp;邮编：050000&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-size:14px;&quot;&gt;&amp;nbsp;邮箱：&lt;/span&gt;&lt;a href=&quot;mailto:sevice@thinkoao.com&quot;&gt;&lt;span style=&quot;font-size:14px;&quot;&gt;sevice@thinkoao.com&lt;/span&gt;&lt;/a&gt; \r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;line-height:150%;font-size:14px;&quot;&gt;电话：400-0311-340&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-size:14px;&quot;&gt;客服：&lt;a target=&quot;_blank&quot; href=&quot;http://wpa.qq.com/msgrd?v=3&amp;amp;uin=2880926116&amp;amp;site=qq&amp;amp;menu=yes&quot;&gt;&lt;img src=&quot;http://wpa.qq.com/pa?p=2:2880926116:41&quot; alt=&quot;2880926116&quot; title=&quot;2880926116&quot; border=&quot;0&quot; /&gt;&lt;/a&gt;&amp;nbsp;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-size:14px;&quot;&gt;工作时间：周一~周六&amp;nbsp;08:30~18:00&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	&lt;span style=&quot;font-size:14px;&quot;&gt;乘车路线：1环1路，1环2路，8路，13路，&amp;nbsp;22路，36路，9路，&amp;nbsp;20路，59路，319路，344路&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	&amp;nbsp;&lt;img src=&quot;http://hanchao9999.com/uploads/image/20151015/17203180285.jpg&quot; alt=&quot;&quot; width=&quot;935px&quot; /&gt; \r\n&lt;/p&gt;',	1,	1450770223,	1450852593,	0,	1,	1,	'',	'',	'',	'0',	1),
(15,	5,	'手机端简介',	'',	'手机端简介手机端简介手机端简介手机端简介手机端简介手机端简介手机端简介手机端简介手机端简介手机端简介',	1,	1465369360,	1465370018,	0,	10,	1,	'',	'',	'',	'0',	1),
(16,	5,	'手机端测试',	'',	'手机端测试手机端测试手机端测试',	1,	1465370047,	1465370047,	0,	10,	1,	'',	'',	'',	'0',	1),
(17,	1,	'公司荣誉',	'',	'&lt;p style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;text-align:justify;text-indent:2em;&quot;&gt;\r\n	&lt;span style=&quot;font-size:16px;color:#333333;line-height:2;&quot;&gt;汉潮隶属于石家庄久途网络科技有限公司（简称JUMTOP）成立于2009年，是国内电商系统及服务提供的领导品牌。公司现有总员工近百人，共设8个职能部门，主要职能部门有：总经办、财务部、业务部、行政部、项目部、研发部、客户部，培训部。总部坐于河北省石家庄拥有600余平米的超现代化办公场地。经过多年的积累，公司汇聚了一大批高水平的专业人才，是业内富有实力和经验的专业团队。&lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;text-align:justify;text-indent:2em;&quot;&gt;\r\n	&lt;span style=&quot;font-size:16px;color:#333333;line-height:2;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; JUMTOP始终秉承着“科技改变未来”的理念，&amp;nbsp;旗下拥有汉潮O2O商城类系列产品、汉潮互联网金融类系列产品、微信营销类系列产品及为用户提供移动端“定制”开发的解决方案。&amp;nbsp;&lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;text-align:justify;text-indent:2em;&quot;&gt;\r\n	&lt;span style=&quot;font-size:16px;color:#333333;line-height:2;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp;“JUMTOP”作为较早且持续时间久的电子商务解决方案服务提供商，历经多年的积极进取与自主创新，JUMTOP已成为众多知名电商企业选择的品牌，服务客户遍及金融、电商、保险、地产、教育等数十个行业，拥有超过2000的用户量，拥有极高的市场占有率。持续领跑中国电子商务软件及服务行业。&amp;nbsp;&lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;text-align:justify;text-indent:2em;&quot;&gt;\r\n	&lt;span style=&quot;font-size:16px;color:#333333;line-height:2;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;JUMTOP凭借优质的服务、创新进取的精神、专业的团队倍受客户青睐。创立至今获得：河北省百佳优秀服务软件企业、高新技术企业、&quot;&amp;nbsp;双软认证&quot;软件企业、“汉潮”系列的数个软件著作权。&lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;text-align:justify;text-indent:2em;&quot;&gt;\r\n	&lt;span style=&quot;font-size:16px;color:#333333;line-height:2;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;为迎合广大互联网企业对互联网IT人才的迫切需求并弥补各大院校对互联网IT人才输出的不足，我们在2013年与多家企业合作成立IT人才培训部。凭借多年来对市场的敏锐洞察力和丰富的实战经验，公司建立起完善的课程体系，让学员在学习中就可以掌握工作当中遇到问题的解决办法。课程覆盖&amp;nbsp;PHP工程师、前端设计师、安卓及IOS工程师等，已为数十家企业输送了大量的IT人才。&amp;nbsp;&lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;text-align:justify;text-indent:2em;&quot;&gt;\r\n	&lt;span style=&quot;font-size:16px;color:#333333;line-height:2;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; 公司以技术为本，始终以卓越的市场前瞻性和技术创新性推动着互联网及移动互联网领域的产品创新发展进程。我们追求卓越的产品品质以及完美的用户体验，提倡&quot;以顾客体验为根本导向&quot;。首先将目标客户群体的用户体验科学的通过人机交互自然完美、友好的呈现出来。旨在为客户创作具有革新性用户体验、简单方便、安全的、实用的产品及解决方案。&amp;nbsp;&lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;text-indent:2em;&quot;&gt;\r\n	&lt;span style=&quot;line-height:2;&quot;&gt;&lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;text-align:center;text-indent:2em;&quot;&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-indent:2em;&quot;&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;',	1,	1492224821,	1492224821,	0,	10,	1,	'公司简介',	'汉潮久途网络',	'汉潮久途网络',	'0',	0),
(19,	5,	'公司简介',	'',	'&lt;p style=&quot;text-indent:2em;&quot;&gt;\r\n	公司简介 &amp;nbsp;公司简介 &amp;nbsp;&lt;span&gt;公司简介 &amp;nbsp;公司简介&lt;/span&gt;&lt;span&gt;公司简介 &amp;nbsp;公司简介&lt;/span&gt;&lt;span&gt;公司简介 &amp;nbsp;公司简介&lt;/span&gt;&lt;span&gt;公司简介 &amp;nbsp;公司简介&lt;/span&gt;\r\n&lt;/p&gt;',	1,	1492414623,	1492414623,	0,	10,	1,	'关于我们公司简介',	'关于我们公司简介',	'关于我们公司简介',	'0',	0),
(20,	5,	'公司简介',	'',	'ass飞洒撒地方撒地方是打发的',	1,	1492415131,	1492415131,	0,	10,	1,	'公司简介',	'公司简介',	'公司简介',	'0',	0),
(21,	5,	'123456',	'',	'',	1,	1492415447,	1492415447,	0,	10,	1,	'',	'',	'',	'0',	0),
(22,	16,	'123456',	'',	'',	1,	1492416096,	1492416096,	0,	10,	1,	'',	'',	'',	'0',	0);

DROP TABLE IF EXISTS `hanchao_member`;
CREATE TABLE `hanchao_member` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `username` varchar(60) NOT NULL COMMENT '用户名字',
  `password` varchar(32) NOT NULL COMMENT '用户密码',
  `paypassword` varchar(32) NOT NULL COMMENT '用户交易密码，使用平台余额时使用',
  `store_id` int(10) NOT NULL COMMENT '商户id(备用)',
  `salt` char(10) NOT NULL DEFAULT '0' COMMENT '干扰码',
  `email` varchar(60) NOT NULL COMMENT '邮箱',
  `question` tinyint(1) NOT NULL DEFAULT '0' COMMENT '安全问题ID',
  `answer` varchar(50) NOT NULL COMMENT '安全问题答案',
  `sex` tinyint(1) NOT NULL DEFAULT '0' COMMENT '性别0保密1男2女',
  `birthday` date NOT NULL DEFAULT '0000-00-00' COMMENT '生日日期',
  `shop_id` int(10) NOT NULL COMMENT '店铺id',
  `money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '可用资金',
  `frozen_money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '冻结资金',
  `reg_time` int(10) NOT NULL DEFAULT '0' COMMENT '注册时间',
  `last_login` int(10) NOT NULL DEFAULT '0' COMMENT '最后一次登录时间',
  `login_count` int(10) NOT NULL DEFAULT '0' COMMENT '登录次数',
  `last_ip` bigint(15) NOT NULL COMMENT '最后一次登录IP',
  `reg_ip` bigint(15) NOT NULL COMMENT '注册时ip',
  `rank_id` tinyint(3) unsigned NOT NULL COMMENT '会员等级id',
  `points` int(10) NOT NULL DEFAULT '0' COMMENT '等级积分',
  `usepoints` int(10) NOT NULL DEFAULT '0' COMMENT '消费积分',
  `parent_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '推荐会员ID',
  `is_tmp` tinyint(1) unsigned NOT NULL COMMENT '表示是否为临时用户',
  `nickname` varchar(60) NOT NULL COMMENT '昵称',
  `qq` varchar(20) NOT NULL COMMENT 'QQ',
  `MSN` varchar(20) NOT NULL COMMENT 'MSN',
  `tel` varchar(20) NOT NULL COMMENT '固定电话',
  `work_tel` varchar(20) NOT NULL COMMENT '办公电话',
  `mobile` varchar(20) NOT NULL COMMENT '手机',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否禁用',
  `wxid` varchar(32) NOT NULL COMMENT '微信ID',
  `push_android_registrationid` varchar(32) NOT NULL COMMENT 'android推送id',
  `push_ios_registrationid` varchar(32) NOT NULL COMMENT 'ios推送id',
  `header_img` varchar(255) NOT NULL COMMENT '会员头像',
  `updatetime` int(10) NOT NULL COMMENT '更新时间',
  `is_fx` tinyint(1) NOT NULL COMMENT '是否是分销商0否1是2禁止',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='会员表';

INSERT INTO `hanchao_member` (`id`, `username`, `password`, `paypassword`, `store_id`, `salt`, `email`, `question`, `answer`, `sex`, `birthday`, `shop_id`, `money`, `frozen_money`, `reg_time`, `last_login`, `login_count`, `last_ip`, `reg_ip`, `rank_id`, `points`, `usepoints`, `parent_id`, `is_tmp`, `nickname`, `qq`, `MSN`, `tel`, `work_tel`, `mobile`, `status`, `wxid`, `push_android_registrationid`, `push_ios_registrationid`, `header_img`, `updatetime`, `is_fx`) VALUES
(1,	'hanchao',	'e10adc3949ba59abbe56e057f20f883e',	'123456',	0,	'5f4at6',	'',	0,	'',	0,	'0000-00-00',	0,	0.00,	0.00,	1505109115,	1505109136,	1,	3232235875,	3232235875,	1,	15,	20,	0,	0,	'',	'',	'',	'',	'',	'15012345678',	1,	'',	'',	'',	'',	0,	0);

DROP TABLE IF EXISTS `hanchao_member_address`;
CREATE TABLE `hanchao_member_address` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员ID',
  `store_id` int(10) NOT NULL COMMENT '提货点id',
  `consignee` varchar(60) NOT NULL COMMENT '收货人名字',
  `email` varchar(60) NOT NULL COMMENT '邮箱',
  `province` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '收货省份Id',
  `city` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '收货城市ID',
  `district` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '收货地区ID',
  `address` varchar(120) NOT NULL COMMENT '收货详细地址',
  `zipcode` varchar(60) NOT NULL COMMENT '收货邮编',
  `mobile` varchar(60) NOT NULL COMMENT '收货电话',
  `sign_building` varchar(120) NOT NULL COMMENT '收货地点标志性建筑',
  `best_time` varchar(120) NOT NULL COMMENT '送货最佳时间',
  `updatetime` int(10) NOT NULL DEFAULT '0' COMMENT '更新时间',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否默认',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='会员地址表';


DROP TABLE IF EXISTS `hanchao_member_bank`;
CREATE TABLE `hanchao_member_bank` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `uid` int(10) NOT NULL COMMENT '会员id',
  `name` varchar(100) NOT NULL COMMENT '姓名',
  `bankname` varchar(255) NOT NULL COMMENT '银行名称',
  `bankcode` varchar(255) NOT NULL COMMENT '银行卡号',
  `bankkai` varchar(255) NOT NULL COMMENT '开户行',
  `temp` varchar(255) NOT NULL COMMENT '备注',
  `addtime` int(10) NOT NULL COMMENT '添加时间',
  `updatetime` int(10) NOT NULL COMMENT '修改时间',
  `adminid` int(10) NOT NULL COMMENT '操作管理员',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态(0不可用，1可用)',
  `type` tinyint(1) NOT NULL COMMENT '0会员1店铺',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='会员提现账号';


DROP TABLE IF EXISTS `hanchao_member_bonus`;
CREATE TABLE `hanchao_member_bonus` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `bonus_id` mediumint(8) unsigned NOT NULL COMMENT '活动红包id（用于领券）',
  `bonus_name` varchar(255) NOT NULL COMMENT '红包名称',
  `bonus_type_id` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '红包类型',
  `bonus_sn` bigint(20) unsigned NOT NULL DEFAULT '0' COMMENT '红包序列号，针对线下红包',
  `user_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '会员id',
  `money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '红包金额',
  `min_goods_money` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '最小订单金额',
  `used_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '使用时间',
  `send_time` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '发放时间',
  `start_time` int(10) NOT NULL DEFAULT '0' COMMENT '开始使用时间',
  `end_time` int(10) NOT NULL DEFAULT '0' COMMENT '结束使用时间',
  `order_id` mediumint(8) unsigned NOT NULL DEFAULT '0' COMMENT '订单id',
  `type` tinyint(5) unsigned NOT NULL DEFAULT '0' COMMENT '绑定类型1:分类2:品牌3:活动',
  `type_value` int(10) NOT NULL COMMENT '类型值',
  `shop_id` int(10) unsigned NOT NULL COMMENT '店铺ID',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='会员红包表';


DROP TABLE IF EXISTS `hanchao_member_collect`;
CREATE TABLE `hanchao_member_collect` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `uid` int(10) unsigned DEFAULT '0' COMMENT '会员id',
  `item_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '(商品/店铺、其他)id',
  `type` tinyint(1) NOT NULL COMMENT '收藏类型0商品1店铺2其他',
  `addtime` int(10) NOT NULL DEFAULT '0' COMMENT '添加时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='会员收藏表';


DROP TABLE IF EXISTS `hanchao_member_invoice`;
CREATE TABLE `hanchao_member_invoice` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `uid` int(10) NOT NULL COMMENT '会员id',
  `type` tinyint(1) NOT NULL COMMENT '发票类型1：普通发票（个人）2，普通发票（单位）3.增值税发票',
  `invoice_info` text NOT NULL COMMENT '发票序列化信息',
  `update_time` int(10) NOT NULL COMMENT '更改时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='会员发票表';


DROP TABLE IF EXISTS `hanchao_member_price`;
CREATE TABLE `hanchao_member_price` (
  `price_id` mediumint(8) NOT NULL AUTO_INCREMENT COMMENT '价格id',
  `goods_id` mediumint(8) NOT NULL COMMENT '商品id',
  `user_rank` tinyint(3) NOT NULL COMMENT '会员等级',
  `user_price` decimal(10,2) NOT NULL COMMENT '会员价',
  PRIMARY KEY (`price_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='会员价格表';


DROP TABLE IF EXISTS `hanchao_member_rank`;
CREATE TABLE `hanchao_member_rank` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `name` varchar(30) NOT NULL COMMENT '等级名字',
  `min_points` int(10) NOT NULL DEFAULT '0' COMMENT '该等级的最低积分',
  `max_points` int(10) NOT NULL DEFAULT '0' COMMENT '该等级的最高积分',
  `special_rank` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否是特殊会员等级组',
  `goods_price` decimal(10,2) NOT NULL COMMENT '商品价格折扣率',
  `price` decimal(10,2) NOT NULL COMMENT '价格',
  `rank_img` char(100) NOT NULL COMMENT '等级图标',
  `sort` smallint(5) NOT NULL DEFAULT '10' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否开启',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='会员等级表';

INSERT INTO `hanchao_member_rank` (`id`, `name`, `min_points`, `max_points`, `special_rank`, `goods_price`, `price`, `rank_img`, `sort`, `status`) VALUES
(1,	'普通会员',	0,	500,	1,	100.00,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170517/591c186ccd653.png',	10,	1),
(2,	'vip会员',	501,	1000,	0,	90.00,	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170517/591bee63d3891.png',	10,	1),
(4,	'黄金vip',	1001,	1500,	0,	80.00,	0.00,	'',	10,	1),
(5,	'钻石vip',	1501,	2000,	0,	10.00,	0.00,	'',	10,	1);

DROP TABLE IF EXISTS `hanchao_member_withdrawals`;
CREATE TABLE `hanchao_member_withdrawals` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `uid` int(10) NOT NULL COMMENT '提现人',
  `money` decimal(20,2) NOT NULL COMMENT '提现金额',
  `free` decimal(20,2) NOT NULL COMMENT '手续费',
  `create_time` int(10) NOT NULL COMMENT '提交日期',
  `end_time` int(10) NOT NULL COMMENT '账期',
  `status` tinyint(1) NOT NULL COMMENT '0未处理，1处理，2关闭',
  `update_time` int(10) NOT NULL COMMENT '处理时间',
  `msg` varchar(255) NOT NULL COMMENT '操作通知内容',
  `desc` varchar(255) NOT NULL COMMENT '备注',
  `adminid` int(10) NOT NULL COMMENT '处理管理员',
  `type` tinyint(1) NOT NULL COMMENT '0会员1店铺',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='会员提现表';


DROP TABLE IF EXISTS `hanchao_message`;
CREATE TABLE `hanchao_message` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `title` varchar(100) NOT NULL COMMENT '信息标题',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '类型1系统(会员)2系统(店铺)3会员4店铺5其他',
  `content` varchar(255) NOT NULL COMMENT '信息内容',
  `fromuid` int(10) NOT NULL DEFAULT '0' COMMENT '来自会员ID',
  `touid` int(10) NOT NULL DEFAULT '0' COMMENT '接收会员ID',
  `addtime` int(10) NOT NULL DEFAULT '0' COMMENT '发送时间',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否已读',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='站内信';


DROP TABLE IF EXISTS `hanchao_nav`;
CREATE TABLE `hanchao_nav` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `cid` smallint(5) unsigned DEFAULT NULL COMMENT '分类商品Id',
  `shop_id` int(10) unsigned NOT NULL COMMENT '店铺id',
  `name` varchar(50) NOT NULL DEFAULT '' COMMENT '栏目名称',
  `navtype` tinyint(1) NOT NULL DEFAULT '0' COMMENT '栏目类型',
  `icon` varchar(255) NOT NULL COMMENT '图标',
  `url_modulename` varchar(255) NOT NULL COMMENT '模块名称',
  `url_param` varchar(255) NOT NULL COMMENT '额外参数',
  `url` varchar(255) NOT NULL COMMENT '栏目URL',
  `is_blank` tinyint(1) NOT NULL COMMENT '是否新窗口打开',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态',
  `show_status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '显示状态',
  `pid` mediumint(8) NOT NULL DEFAULT '0' COMMENT '父id',
  `sort` int(10) NOT NULL DEFAULT '0' COMMENT '排序',
  `device` tinyint(3) unsigned NOT NULL COMMENT '设备（0:电脑端,1:移动端,2:其他,3:APP）',
  `new_open` tinyint(3) unsigned NOT NULL COMMENT '是否新窗口打开',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=149 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='栏目表';

INSERT INTO `hanchao_nav` (`id`, `cid`, `shop_id`, `name`, `navtype`, `icon`, `url_modulename`, `url_param`, `url`, `is_blank`, `status`, `show_status`, `pid`, `sort`, `device`, `new_open`) VALUES
(1,	NULL,	0,	'首页',	0,	'',	'',	'',	'url:5::',	0,	1,	1,	0,	1,	0,	0),
(2,	NULL,	0,	'我的订单',	2,	'',	'',	'',	'url:17::',	1,	1,	1,	0,	1,	0,	0),
(3,	NULL,	0,	'我的收藏',	2,	'',	'',	'',	'url:42::',	0,	1,	1,	0,	10,	0,	0),
(4,	NULL,	0,	'优惠活动',	0,	'',	'',	'',	'url:39::',	0,	1,	1,	0,	7,	0,	0),
(5,	NULL,	0,	'关于我们',	1,	'',	'1',	'1',	'url:43:1:1',	0,	1,	1,	0,	10,	0,	0),
(7,	NULL,	0,	'积分商城',	0,	'',	'',	'',	'url:15::',	0,	1,	1,	0,	8,	0,	0),
(8,	136,	0,	'帮助中心',	0,	'',	'4',	'4',	'url:16:4:4',	0,	1,	0,	0,	110,	0,	0),
(10,	NULL,	0,	'公司简介',	1,	'',	'2',	'2',	'url:43:2:2',	0,	1,	1,	0,	10,	0,	0),
(11,	NULL,	0,	'公司资质',	1,	'',	'3',	'3',	'url:43:3:3',	0,	1,	1,	0,	10,	0,	0),
(12,	NULL,	0,	'联系我们',	1,	'',	'4',	'4',	'url:43:4:4',	0,	1,	1,	0,	10,	0,	0),
(13,	NULL,	0,	'常见问题',	1,	'',	'24',	'',	'url:19:24:',	0,	1,	1,	0,	10,	0,	0),
(14,	NULL,	0,	'店铺中心',	2,	'',	'',	'',	'url:29::',	0,	1,	1,	62,	10,	0,	0),
(15,	NULL,	0,	'店铺入驻',	2,	'',	'',	'',	'url:30::',	0,	1,	1,	62,	9,	0,	0),
(16,	NULL,	0,	'帮助中心',	2,	'',	'',	'',	'url:16:4:id=4',	0,	1,	1,	0,	10,	0,	0),
(17,	NULL,	0,	'积分商城',	3,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edd1b9c70c0.png',	'',	'',	'url:44::',	1,	1,	1,	0,	90,	1,	0),
(18,	NULL,	0,	'家居生活',	3,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edd207225f4.jpg',	'153',	'',	'url:45:153:',	0,	1,	1,	0,	20,	1,	0),
(19,	NULL,	0,	'服装配饰',	3,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edd24366c05.jpg',	'115',	'',	'url:45:115:',	0,	1,	1,	0,	30,	1,	0),
(20,	NULL,	0,	'运动健康',	3,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edd25d75fe9.jpg',	'7',	'',	'url:45:7:',	0,	1,	1,	0,	40,	1,	0),
(21,	NULL,	0,	'拼团',	3,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edd29735e63.jpg',	'',	'',	'http://b2b2c.hanchao9999.com/index.php/mobile/fight_group/index.html',	0,	1,	1,	0,	60,	1,	0),
(25,	NULL,	0,	'品牌中心',	0,	'',	'',	'',	'url:41::',	0,	0,	0,	0,	10,	0,	0),
(26,	NULL,	0,	'预售',	3,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edd2ac60892.png',	'',	'',	'http://b2b2c.hanchao9999.com/index.php/mobile/pre_sale/index.html',	0,	1,	1,	0,	70,	1,	0),
(27,	NULL,	0,	'食品饮料',	3,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edd2c58f01c.png',	'1',	'',	'url:45:1:',	0,	1,	1,	0,	10,	1,	0),
(28,	NULL,	0,	'数码电器',	3,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edd3019468b.png',	'5',	'',	'url:45:5:',	0,	1,	1,	0,	50,	1,	0),
(29,	NULL,	0,	'优惠活动',	3,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edd32594140.jpg',	'',	'',	'url:21::',	0,	1,	1,	0,	80,	1,	0),
(30,	NULL,	0,	'我的推广',	3,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edcedb65878.png',	'1',	'',	'url:26:1:',	0,	1,	1,	0,	100,	1,	0),
(54,	145,	0,	'限时促销',	0,	'',	'',	'',	'url:48::',	1,	1,	0,	0,	100,	0,	0),
(56,	NULL,	0,	'积分兑换',	0,	'',	'',	'',	'',	0,	1,	1,	17,	10,	0,	0),
(57,	NULL,	0,	'123456',	0,	'',	'',	'',	'',	0,	1,	1,	17,	10,	0,	0),
(62,	NULL,	0,	'店铺管理',	2,	'',	'',	'',	'Home/Index/index',	1,	1,	1,	0,	10,	0,	0),
(64,	NULL,	6,	'测试导航',	4,	'',	'',	'',	'',	0,	1,	1,	0,	1,	0,	1),
(66,	NULL,	8,	'新品热销',	4,	'',	'',	'',	'',	0,	1,	1,	0,	10,	0,	1),
(67,	NULL,	0,	'店铺登录',	2,	'',	'',	'',	'url:47::',	0,	1,	1,	62,	10,	0,	0),
(72,	NULL,	0,	'订单管理',	2,	'',	'',	'',	'url:17::',	1,	1,	1,	2,	10,	0,	0),
(73,	NULL,	0,	'最新活动',	2,	'',	'3',	'3',	'url:16:3:3',	0,	1,	1,	16,	10,	0,	0),
(74,	NULL,	9,	'商品分类',	4,	'',	'',	'',	'',	0,	1,	1,	0,	10,	0,	1),
(75,	NULL,	14,	'牛奶',	4,	'',	'',	'',	'',	0,	1,	1,	0,	10,	0,	1),
(76,	NULL,	7,	'羽毛球',	4,	'',	'',	'',	'',	0,	1,	1,	0,	10,	0,	1),
(77,	NULL,	7,	'羽毛球拍',	4,	'',	'',	'',	'',	0,	1,	1,	76,	10,	0,	1),
(78,	NULL,	7,	'白色球拍',	4,	'',	'',	'',	'',	0,	1,	1,	77,	10,	0,	1),
(79,	NULL,	31,	'华为手机',	4,	'',	'',	'',	'',	0,	1,	1,	0,	10,	0,	1),
(80,	NULL,	31,	'美食',	4,	'',	'',	'',	'',	0,	1,	1,	0,	10,	0,	1),
(81,	NULL,	15,	'联系我们',	4,	'',	'',	'',	'',	0,	1,	1,	81,	10,	0,	1),
(85,	NULL,	15,	'矿泉水',	4,	'',	'',	'',	'',	0,	1,	1,	0,	10,	0,	1),
(86,	NULL,	15,	'方便面',	4,	'',	'',	'',	'',	0,	1,	1,	0,	10,	0,	1),
(89,	NULL,	17,	'测试',	4,	'',	'',	'',	'',	0,	1,	1,	0,	10,	0,	1),
(96,	NULL,	0,	'12313',	0,	'',	'',	'',	'',	1,	0,	1,	0,	110,	1,	0),
(97,	NULL,	0,	'拼团',	0,	'',	'',	'',	'http://b2b2c.hanchao9999.com/index.php/home/FightGroup/index.html',	0,	1,	1,	0,	5,	0,	0),
(98,	NULL,	0,	'食品饮料',	0,	'',	'1',	'1',	'url:40:1:1',	0,	1,	1,	0,	2,	0,	0),
(99,	NULL,	0,	'家居生活',	0,	'',	'153',	'',	'url:40:153:',	0,	1,	1,	0,	3,	0,	0),
(100,	NULL,	0,	'服装配饰',	0,	'',	'115',	'',	'url:40:115:',	0,	1,	1,	0,	4,	0,	0),
(101,	NULL,	38,	'橄榄油',	4,	'',	'',	'',	'',	0,	1,	1,	0,	10,	0,	1),
(103,	NULL,	38,	'厨卫',	4,	'',	'',	'',	'',	0,	1,	1,	0,	10,	0,	1),
(104,	NULL,	0,	'预售',	0,	'',	'',	'',	'http://b2b2c.hanchao9999.com/index.php/home/PreSale/index.html',	0,	1,	1,	0,	6,	0,	0),
(105,	NULL,	0,	'帮助中心',	0,	'',	'',	'',	'http://b2b2c.hanchao9999.com/index.php/home/article/index/id/4.html',	0,	0,	1,	0,	10,	0,	0),
(106,	NULL,	44,	'牛轧糖',	4,	'',	'',	'',	'http://b2b2c.hanchao9999.com/index.php/home/shop/lists/id/44/shop_cid/90.html',	0,	1,	1,	0,	10,	0,	0),
(107,	NULL,	44,	'凤梨酥',	4,	'',	'',	'',	'http://b2b2c.hanchao9999.com/index.php/home/shop/lists/id/44/shop_cid/98.html',	0,	1,	1,	0,	10,	0,	0),
(108,	NULL,	44,	'糖果巧克力',	4,	'',	'',	'',	'http://b2b2c.hanchao9999.com/index.php/home/shop/lists/id/44/shop_cid/91.html',	0,	1,	1,	0,	10,	0,	0),
(109,	NULL,	44,	'饼干糕点',	4,	'',	'',	'',	'http://b2b2c.hanchao9999.com/index.php/home/shop/lists/id/44/shop_cid/92.html',	0,	1,	1,	0,	10,	0,	0),
(110,	NULL,	44,	'千层酥',	4,	'',	'',	'',	'http://b2b2c.hanchao9999.com/index.php/home/shop/lists/id/44/shop_cid/96.html',	0,	1,	1,	0,	10,	0,	0),
(127,	NULL,	0,	'食品饮料',	5,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edcedb65878.png',	'1',	'name=食品饮料',	'url:45:1:name=食品饮料',	0,	1,	1,	0,	10,	3,	0),
(128,	NULL,	0,	'积分商城',	4,	'',	'',	'',	'',	0,	0,	1,	0,	100,	1,	0),
(129,	NULL,	0,	'积分商城',	4,	'',	'',	'',	'',	0,	0,	1,	0,	100,	1,	0),
(130,	NULL,	0,	'积分商城',	5,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edd1b9c70c0.png',	'',	'',	'url:44::',	0,	1,	1,	0,	10,	3,	0),
(131,	NULL,	0,	'家居生活',	5,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edd207225f4.jpg',	'153',	'name=家居生活',	'url:45:153:name=家居生活',	0,	1,	1,	0,	20,	3,	0),
(132,	NULL,	0,	'服装配饰',	5,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edd24366c05.jpg',	'115',	'name=服装配饰',	'url:45:115:name=服装配饰',	0,	1,	1,	0,	30,	3,	0),
(133,	NULL,	0,	'运动健康',	5,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edd25d75fe9.jpg',	'7',	'name=运动健康',	'url:45:7:name=运动健康',	0,	1,	1,	0,	40,	3,	0),
(134,	NULL,	0,	'数码电器',	5,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edd3019468b.png',	'5',	'name=数码电器',	'url:45:5:name=数码电器',	0,	1,	1,	0,	50,	3,	0),
(135,	NULL,	0,	'优惠活动',	5,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edd32594140.jpg',	'',	'',	'url:21::',	0,	1,	1,	0,	80,	3,	0),
(136,	NULL,	0,	'我的推广',	5,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edcedb65878.png',	'1',	'',	'url:26:1:',	0,	1,	1,	0,	100,	3,	0),
(137,	NULL,	0,	'拼团',	5,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edd29735e63.jpg',	'',	'',	'http://b2b2c.hanchao9999.com/index.php/mobile/fight_group/index.html',	0,	1,	1,	0,	60,	3,	0),
(138,	NULL,	0,	'预售',	5,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edd2ac60892.png',	'',	'',	'http://b2b2c.hanchao9999.com/index.php/mobile/pre_sale/index.html',	0,	1,	1,	0,	70,	3,	0),
(142,	NULL,	43,	'买家必看',	4,	'',	'',	'',	'www.taobao.com',	0,	1,	1,	0,	10,	0,	1),
(143,	NULL,	46,	'新品',	4,	'',	'',	'',	'http://b2b2c.hanchao9999.com/index.php/goods/index/id/238.html',	0,	1,	1,	0,	10,	0,	1),
(146,	NULL,	49,	'汽车类别',	4,	'',	'',	'',	'',	0,	1,	1,	0,	1,	0,	1),
(147,	NULL,	49,	'汽车配件',	4,	'',	'',	'',	'',	0,	1,	1,	0,	2,	0,	1),
(148,	NULL,	49,	'汽车维修',	4,	'',	'',	'',	'',	0,	1,	1,	0,	3,	0,	1);

DROP TABLE IF EXISTS `hanchao_oauth`;
CREATE TABLE `hanchao_oauth` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `code` varchar(20) NOT NULL COMMENT '代号',
  `name` varchar(120) NOT NULL COMMENT '名称',
  `appkey` varchar(100) NOT NULL COMMENT '授权APPkey',
  `appsecret` varchar(100) NOT NULL COMMENT '授权APPsecret',
  `appother` varchar(100) NOT NULL COMMENT '授权其它参数',
  `callback` varchar(255) NOT NULL COMMENT '回调地址',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='第三方登录配置';

INSERT INTO `hanchao_oauth` (`id`, `code`, `name`, `appkey`, `appsecret`, `appother`, `callback`, `status`) VALUES
(1,	'qq',	'QQ互联',	'101400038',	'd3c43012a861be3d5454cd27723e005f',	'',	'http://b2b2c.hanchao9999.com/index.php/member/oauth/callback/type/qq.html',	1),
(2,	'weixin',	'微信登录',	'wx48646ad9e0fbcc18',	'cf8b71fb7d56fa6f1be13417d31f199f',	'',	'http://b2b2c.hanchao9999.com/index.php/member/oauth/callback/type/weixin.html',	1),
(3,	'sina',	'新浪',	'1365771434',	'1b8130b6d13eb6e8145e1159e0a16b34',	'',	'http://b2b2c.hanchao9999.com/index.php/member/oauth/callback/type/sina.html',	1);

DROP TABLE IF EXISTS `hanchao_oauth_member`;
CREATE TABLE `hanchao_oauth_member` (
  `id` int(20) NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `_from` varchar(20) NOT NULL COMMENT '第三方类型',
  `_name` varchar(30) NOT NULL COMMENT '用户名',
  `head_img` varchar(200) NOT NULL COMMENT '头象',
  `lock_to_id` int(20) NOT NULL COMMENT '绑定时间',
  `create_time` int(12) NOT NULL COMMENT '绑定会员ID',
  `last_login_time` int(12) NOT NULL COMMENT '上次登录时间',
  `last_login_ip` bigint(16) NOT NULL DEFAULT '0' COMMENT '上次登录ip',
  `login_times` int(6) NOT NULL COMMENT '登录次数',
  `status` tinyint(2) NOT NULL DEFAULT '1' COMMENT '状态',
  `access_token` varchar(60) NOT NULL COMMENT '授权码',
  `expires_date` int(12) NOT NULL COMMENT '授权到期',
  `openid` varchar(40) NOT NULL COMMENT 'openid',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='第三方登录会员';


DROP TABLE IF EXISTS `hanchao_order_goods`;
CREATE TABLE `hanchao_order_goods` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `order_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '订单id',
  `goods_id` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '商品id',
  `goods_name` varchar(120) NOT NULL COMMENT '商品名字',
  `goods_sn` varchar(60) NOT NULL COMMENT '商品货号',
  `goods_number` smallint(5) unsigned NOT NULL DEFAULT '1' COMMENT '商品数量',
  `attr_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '属性价格',
  `goods_price` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '商品价格（实际支付）',
  `goods_attr` text NOT NULL COMMENT '购买选择的属性',
  `promot_id` int(10) NOT NULL DEFAULT '0' COMMENT '活动id',
  `bonus_id` int(10) NOT NULL COMMENT '红包id',
  `shop_id` int(10) NOT NULL COMMENT '商户id',
  `suppliers_id` int(10) NOT NULL COMMENT '供货商ID',
  `addtime` int(10) NOT NULL COMMENT '添加时间',
  `goods_integral` decimal(10,2) NOT NULL COMMENT '商品积分',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0未发货1已发货2已收货3退货中退款中4已退货已退款5拒绝退货',
  `is_balance` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否结算',
  `is_pro_enable` tinyint(1) NOT NULL COMMENT '活动是否失效',
  `is_bonus_enable` tinyint(1) NOT NULL COMMENT '红包是否失效',
  `supply_price` decimal(10,2) NOT NULL COMMENT '有商家id时：该商品的分类佣金比，否则是：该商品的结算价（属性递加结算价+商品结算价）*商品数量',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='订单商品中间表';


DROP TABLE IF EXISTS `hanchao_order_info`;
CREATE TABLE `hanchao_order_info` (
  `id` int(255) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `order_sn` varchar(255) NOT NULL COMMENT '订单号',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '订单类型1商品2会员充值3积分4其它5店铺充值6拼团7预售 ',
  `uid` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '会员id',
  `consignee` varchar(60) NOT NULL COMMENT '收货人的姓名',
  `province` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '收货人的省份',
  `city` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '收货人的城市 ',
  `district` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '收货人的地区',
  `address` varchar(255) NOT NULL COMMENT '详细地址',
  `zipcode` varchar(60) NOT NULL COMMENT '收货邮编',
  `mobile` varchar(60) NOT NULL COMMENT '收货人手机',
  `email` varchar(60) NOT NULL COMMENT '收货人邮箱',
  `best_time` varchar(120) NOT NULL COMMENT '最佳送货时间',
  `sign_building` varchar(120) NOT NULL COMMENT '收货地址标志性建筑 ',
  `shop_id` int(10) NOT NULL COMMENT '店铺id',
  `shipping_status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '配送状态1未发货,2部分发货,3已发货,4已收货5待成团',
  `pay_code` varchar(20) NOT NULL DEFAULT '0' COMMENT '支付方式code',
  `payment_id` int(10) NOT NULL COMMENT '支付方式id',
  `pay_sn` varchar(50) NOT NULL COMMENT '支付接口返回的订单号',
  `pay_status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '支付状态1未付款；2，付款中；3，已付款；4，部分付款；5:已付定金',
  `pay_time` int(10) NOT NULL DEFAULT '0' COMMENT '订单支付时间',
  `pay_fee` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '支付手续费',
  `goods_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '商品实际金额（-折扣后）',
  `goods_allmoney` decimal(10,2) NOT NULL COMMENT '商品总金额',
  `order_amount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '应付款金额',
  `order_money` decimal(10,2) NOT NULL COMMENT '订单商品总金额',
  `pay_amount` decimal(10,2) NOT NULL COMMENT '线上支付金额',
  `delivery_fee` decimal(10,2) NOT NULL COMMENT '运费',
  `promot_id` decimal(10,2) NOT NULL COMMENT '活动id',
  `discount` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '折扣金额',
  `bonus_money` decimal(10,2) NOT NULL COMMENT '使用红包金额',
  `bonus_id` int(10) NOT NULL COMMENT '红包id',
  `to_buyer` varchar(255) NOT NULL COMMENT '商家留言',
  `temp` varchar(255) NOT NULL COMMENT '订单附言',
  `addtime` int(10) NOT NULL DEFAULT '0' COMMENT '订单生成时间 ',
  `confirm_time` int(10) NOT NULL DEFAULT '0' COMMENT '订单确认时间',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '订单状态 1未确认,2已确认,3已完成,4已取消,5做废6,退款中 7已退款 8退货中 9已退货10已过期',
  `is_delete` tinyint(2) NOT NULL COMMENT '删除状态 0未删除,1已删除',
  `used_money` decimal(10,2) NOT NULL COMMENT '使用余额',
  `used_score` decimal(10,2) NOT NULL COMMENT '使用积分',
  `used_score_money` decimal(10,2) NOT NULL COMMENT '积分抵扣的金额',
  `auto_time` int(10) NOT NULL COMMENT '自动收货时间',
  `source` tinyint(2) NOT NULL COMMENT '0电脑，1手机版，2app',
  `is_comment` tinyint(2) NOT NULL COMMENT '0未评论1已评论',
  `invoice_info` text NOT NULL COMMENT '发票信息',
  `pid` int(10) NOT NULL COMMENT '团长的id ',
  `pt_id` int(10) NOT NULL COMMENT '参加的活动id ',
  `pre_sn` varchar(50) NOT NULL COMMENT '定金-支付接口返回的订单号 ',
  `pre_time` int(10) NOT NULL COMMENT '定金支付时间 ',
  `pre_fee` decimal(10,2) NOT NULL COMMENT '支付手续费 ',
  `pre_money` decimal(10,2) NOT NULL COMMENT '定金金额 ',
  `pre_type` int(10) NOT NULL COMMENT '1:一次性支付，2:付定金 ',
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_sn` (`order_sn`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='订单列表';


DROP TABLE IF EXISTS `hanchao_pay_log`;
CREATE TABLE `hanchao_pay_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `user_id` int(10) NOT NULL COMMENT '会员id',
  `type` tinyint(1) NOT NULL COMMENT '订单类型1商品2充值3积分4其它',
  `pay_sn` varchar(50) NOT NULL COMMENT '支付接口返回的支付单号',
  `order_sn` varchar(255) NOT NULL COMMENT '支付单号',
  `order_id` varchar(255) NOT NULL DEFAULT '0' COMMENT '订单id',
  `use_money` decimal(20,2) NOT NULL COMMENT '使用的余额',
  `need_pay` decimal(20,2) NOT NULL COMMENT '还需支付的金额',
  `use_score` decimal(20,2) NOT NULL COMMENT '使用的积分',
  `use_score_money` decimal(20,2) NOT NULL COMMENT '积分抵扣的金额',
  `order_total_price` decimal(20,2) NOT NULL COMMENT '订单总金额=商品总价+总运费-活动折扣-红包折扣',
  `pay_amount` decimal(20,2) NOT NULL COMMENT '线上支付金额',
  `payment_fee` decimal(20,2) NOT NULL COMMENT '支付手续费',
  `payment_id` tinyint(4) NOT NULL COMMENT '支付方式id',
  `pay_code` varchar(20) NOT NULL COMMENT '支付方式code',
  `is_paid` tinyint(1) unsigned NOT NULL DEFAULT '0' COMMENT '0未完成1已完成',
  `create_time` int(10) unsigned NOT NULL COMMENT '支付日志生成时间',
  `update_time` int(10) unsigned NOT NULL COMMENT '支付日志更新时间',
  `is_delete` tinyint(1) unsigned NOT NULL COMMENT '是否为作废单,1是0否',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='支付日志表';


DROP TABLE IF EXISTS `hanchao_payment`;
CREATE TABLE `hanchao_payment` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `code` varchar(20) NOT NULL COMMENT '支付方式英文缩写',
  `name` varchar(120) NOT NULL COMMENT '支付方式名称',
  `fee` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '费率',
  `content` varchar(255) NOT NULL COMMENT '支付方式描述',
  `config_account` varchar(50) NOT NULL COMMENT '支付账号',
  `config_key` varchar(50) NOT NULL COMMENT '支付密钥',
  `config_partner` varchar(50) NOT NULL COMMENT '合作身份(Pid)',
  `config_other` varchar(50) NOT NULL COMMENT '支付备用参数',
  `is_wap` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否手机调用',
  `is_online` tinyint(1) NOT NULL DEFAULT '0' COMMENT '是否在线支付',
  `is_return` tinyint(1) NOT NULL COMMENT '是否原路返回',
  `sort` smallint(5) NOT NULL DEFAULT '10' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否可用',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='支付方式表';

INSERT INTO `hanchao_payment` (`id`, `code`, `name`, `fee`, `content`, `config_account`, `config_key`, `config_partner`, `config_other`, `is_wap`, `is_online`, `is_return`, `sort`, `status`) VALUES
(1,	'Hanchao',	'余额支付',	0.00,	'',	'',	'',	'',	'',	1,	1,	0,	1,	1),
(2,	'Hanchaobank',	'网银转账',	0.00,	'',	'',	'',	'',	'',	0,	1,	0,	1,	0),
(3,	'alipay',	'支付宝支付',	0.00,	'',	'service@hanchao9999.com',	'6pqpcv2islqabvridguokgpyuc1ne9xb',	'2088221731895525',	'',	0,	1,	0,	1,	1),
(6,	'weixinpay',	'微信支付',	0.00,	'',	'wx35fcfd1219959d74',	'D2Ffwerq2c3242cc2F3RFSDW3gret3wr',	'1460766702',	'2e011f193d888e98088a6ed273fb79aa',	1,	0,	0,	1,	1),
(7,	'weixincode',	'微信扫码',	0.00,	'',	'wx35fcfd1219959d74',	'D2Ffwerq2c3242cc2F3RFSDW3gret3wr',	'1460766702',	'2e011f193d888e98088a6ed273fb79aa',	0,	1,	0,	1,	1),
(8,	'Alipayapi',	'支付宝WAP',	0.00,	'',	'service@hanchao9999.com',	'6pqpcv2islqabvridguokgpyuc1ne9xb',	'2088221731895525',	'',	1,	0,	0,	10,	1),
(11,	'weixinapppay',	'微信APP支付',	0.00,	'',	'wx5a9abdceebd3c7bc',	'JIUTUMINGTIYjiutuneiwangmiyao123',	'1486161372',	'2e011f193d888e98088a6ed273fb79aa',	0,	0,	0,	1,	0);

DROP TABLE IF EXISTS `hanchao_payment_refund`;
CREATE TABLE `hanchao_payment_refund` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `refund_sn` varchar(255) NOT NULL COMMENT '退款号',
  `uid` int(11) NOT NULL COMMENT '会员id',
  `shop_id` int(11) NOT NULL COMMENT '商家id',
  `order_id` int(11) NOT NULL COMMENT '订单id',
  `money` decimal(10,2) NOT NULL COMMENT '退款金额',
  `payment_id` int(11) NOT NULL COMMENT '支付方式',
  `payment_code` varchar(30) NOT NULL COMMENT '支付code',
  `trade_no` varchar(30) NOT NULL COMMENT '第三方支付平台的单号',
  `addtime` int(11) NOT NULL COMMENT '创建时间',
  `update_time` int(11) NOT NULL COMMENT '更新时间',
  `deal_time` varchar(50) NOT NULL COMMENT '处理时间',
  `refund_fee` int(11) NOT NULL COMMENT '处理金额',
  `type` tinyint(1) NOT NULL COMMENT '退款类型 1退款 2退货',
  `refund_reason` text NOT NULL COMMENT '退款原因',
  `status` tinyint(1) NOT NULL COMMENT '退款状态 0申请中 1已退款 2拒绝',
  `is_effect` tinyint(1) NOT NULL COMMENT '是否有效 0无效 1有效',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='退款';


DROP TABLE IF EXISTS `hanchao_points_rule`;
CREATE TABLE `hanchao_points_rule` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `name` varchar(100) NOT NULL COMMENT '标题',
  `type` tinyint(1) NOT NULL DEFAULT '1' COMMENT '类型1积分2金额',
  `value` int(10) NOT NULL COMMENT '数值',
  `sort` smallint(5) NOT NULL COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='积分余额变更规则';

INSERT INTO `hanchao_points_rule` (`id`, `name`, `type`, `value`, `sort`, `status`) VALUES
(1,	'网站推广',	1,	2,	10,	1);

DROP TABLE IF EXISTS `hanchao_poster`;
CREATE TABLE `hanchao_poster` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `position_id` smallint(5) unsigned NOT NULL DEFAULT '0' COMMENT '位置ID',
  `catid` int(10) NOT NULL COMMENT '绑定分类',
  `type` smallint(1) NOT NULL DEFAULT '0' COMMENT '广告类型',
  `name` varchar(60) NOT NULL COMMENT '广告名称',
  `url` varchar(255) NOT NULL COMMENT '广告链接地址',
  `url_navtype` tinyint(1) NOT NULL COMMENT '栏目类型',
  `url_modulename` varchar(255) NOT NULL COMMENT '模块名称',
  `url_param` varchar(255) NOT NULL COMMENT '额外参数',
  `code` text NOT NULL COMMENT '广告链接的表现',
  `start_time` int(10) NOT NULL DEFAULT '0' COMMENT '广告开始时间',
  `end_time` int(10) NOT NULL DEFAULT '0' COMMENT '广告结束时间',
  `description` varchar(20) NOT NULL COMMENT '广告联系人',
  `contact` varchar(60) NOT NULL COMMENT '广告联系方式',
  `background_color` varchar(20) NOT NULL COMMENT '背景色',
  `count` int(10) NOT NULL DEFAULT '0' COMMENT '点击量',
  `sort` smallint(5) NOT NULL DEFAULT '10' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '该广告是否关闭',
  `device` tinyint(3) unsigned NOT NULL COMMENT '设备（0:电脑端,1:移动端,2:其他）',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=126 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='广告表';

INSERT INTO `hanchao_poster` (`id`, `position_id`, `catid`, `type`, `name`, `url`, `url_navtype`, `url_modulename`, `url_param`, `code`, `start_time`, `end_time`, `description`, `contact`, `background_color`, `count`, `sort`, `status`, `device`) VALUES
(1,	20,	0,	0,	'美丽女人 滋润由内而外',	'http://b2b2c.hanchao9999.com/',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ed8307bd02b.png',	0,	0,	'',	'',	'#fff',	263,	10,	1,	0),
(3,	21,	0,	0,	'包包',	'http://b2b2c.hanchao9999.com/',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/59294c9918b5e.png',	0,	0,	'',	'',	'',	28,	10,	1,	0),
(4,	22,	0,	0,	'今日必团',	'http://b2b2c.hanchao9999.com/',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ed83cb00514.jpg',	0,	0,	'',	'',	'',	25,	10,	1,	0),
(5,	23,	0,	0,	'进口美食',	'http://b2b2c.hanchao9999.com/',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ed8408d5b26.jpg',	0,	0,	'圣诞优惠',	'',	'',	161,	10,	1,	0),
(6,	24,	0,	0,	'特产中国 老字号美味',	'http://b2b2c.hanchao9999.com/',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ed843ad4c4c.jpg',	0,	0,	'立日有 芝麻海苔肉松',	'',	'',	65,	10,	1,	0),
(7,	25,	0,	0,	'1号3C数码城',	'http://b2b2c.hanchao9999.com/',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ed846de13ca.jpg',	0,	0,	'精选爆款 每日特惠',	'',	'',	138,	10,	1,	0),
(8,	26,	0,	0,	'新品上市 0元试用',	'http://b2b2c.hanchao9999.com/',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ed84ae505f6.jpg',	0,	0,	'五行配方杂粮礼盒',	'',	'',	49,	10,	1,	0),
(9,	27,	0,	0,	'超级闪购',	'http://b2b2c.hanchao9999.com/',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ed84ee4ccfc.jpg',	0,	0,	'',	'',	'',	50,	10,	1,	0),
(10,	28,	0,	0,	'手机电器城',	'http://b2b2c.hanchao9999.com/',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ed85169b55d.jpg',	0,	0,	'美图新品M6s',	'',	'',	33,	10,	1,	0),
(11,	29,	0,	0,	'山姆会员商店',	'http://b2b2c.hanchao9999.com/',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ed85439f8f0.jpg',	0,	0,	'优质进口 橄榄油',	'',	'',	18,	10,	1,	0),
(12,	30,	0,	0,	'百草味 全场一元起',	'http://b2b2c.hanchao9999.com/',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170626/59506db9c6ed2.jpg',	0,	0,	'',	'',	'',	59,	10,	1,	0),
(13,	18,	0,	0,	'登录页广告',	'http://b2b2c.hanchao9999.com/',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ed87579d822.png',	0,	0,	'',	'',	'',	0,	10,	1,	0),
(14,	19,	0,	0,	'暖冬必备',	'http://b2b2c.hanchao9999.com/',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ed888b33d40.png',	0,	0,	'',	'',	'',	1,	10,	1,	0),
(15,	1,	1,	0,	'元气森林',	'http://b2b2c.hanchao9999.com/',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170525/59269c814a44d.jpg',	0,	0,	'',	'',	'',	0,	10,	1,	0),
(16,	1,	153,	0,	'享你',	'http://b2b2c.hanchao9999.com/',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/5928d550deef7.jpg',	0,	0,	'',	'',	'',	0,	10,	1,	0),
(18,	2,	1,	3,	'饮料酒水',	'http://b2b2c.hanchao9999.com/index.php/cate/index/id/8.html',	0,	'',	'',	'',	0,	0,	'',	'',	'',	16,	10,	1,	0),
(21,	3,	1,	0,	'双12提前抢购',	'http://b2b2c.hanchao9999.com/',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170526/5927f76937611.png',	0,	0,	'',	'',	'',	147,	10,	1,	0),
(22,	3,	153,	0,	'双12提前抢购',	'http://b2b2c.hanchao9999.com/',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/5928d89484b40.png',	0,	0,	'',	'',	'',	95,	10,	1,	0),
(24,	4,	1,	0,	'休闲零食',	'http://b2b2c.hanchao9999.com/',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/5928d37585c47.png',	0,	0,	'',	'',	'',	24,	10,	1,	0),
(25,	4,	1,	0,	'粽子',	'http://b2b2c.hanchao9999.com/',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/5928d234394ae.png',	0,	0,	'',	'',	'',	26,	10,	1,	0),
(26,	4,	153,	0,	'家居',	'http://b2b2c.hanchao9999.com/',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/5928e499830a2.png',	0,	0,	'',	'',	'',	19,	10,	1,	0),
(29,	6,	153,	0,	'堡出家的味道',	'http://b2b2c.hanchao9999.com/',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170627/595205c1dbddb.jpg',	0,	0,	'',	'',	'',	10,	10,	1,	0),
(30,	6,	153,	0,	'富安娜6月钜惠',	'http://b2b2c.hanchao9999.com/',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/5928e2b9d5cd8.png',	0,	0,	'',	'',	'',	15,	10,	1,	0),
(31,	7,	1,	0,	'进口咖啡',	'http://b2b2c.hanchao9999.com/',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/5928cfd9bb79f.png',	0,	0,	'',	'',	'',	28,	10,	1,	0),
(32,	7,	1,	0,	'进口零食精选',	'http://b2b2c.hanchao9999.com/',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/5928ceed7a864.png',	0,	0,	'',	'',	'',	42,	10,	1,	0),
(33,	8,	1,	0,	'进口热销酒',	'http://b2b2c.hanchao9999.com/',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/5928cd5724d86.png',	0,	0,	'',	'',	'',	16,	10,	1,	0),
(34,	8,	1,	0,	'进口品质团',	'http://b2b2c.hanchao9999.com/',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170526/5927fa7002d77.png',	0,	0,	'',	'',	'',	15,	10,	1,	0),
(35,	9,	153,	0,	'家居清凉焕夏',	'http://b2b2c.hanchao9999.com/',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/5928dd59b6388.png',	0,	0,	'',	'',	'',	39,	10,	1,	0),
(36,	9,	153,	0,	'收纳箱',	'http://b2b2c.hanchao9999.com/',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170627/595212b691586.jpg',	0,	0,	'',	'',	'',	21,	10,	1,	0),
(41,	12,	153,	0,	'夏季联合特惠',	'http://b2b2c.hanchao9999.com/',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/5928e0ad9320f.png',	0,	0,	'',	'',	'',	14,	10,	1,	0),
(42,	12,	153,	0,	'冰蚕夏凉被',	'http://b2b2c.hanchao9999.com/',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170627/5952120c9e91f.jpg',	0,	0,	'',	'',	'',	27,	10,	1,	0),
(43,	13,	0,	0,	'掌握装修辅材选购技巧',	'http://b2b2c.hanchao9999.com/mobile',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edb97723f2e.jpg',	0,	0,	'',	'',	'',	8,	10,	1,	1),
(44,	13,	0,	0,	'家装一站式 一切都不是个事',	'http://b2b2c.hanchao9999.com/mobile',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edc020b78ca.jpg',	0,	0,	'',	'',	'',	10,	10,	1,	1),
(45,	13,	0,	0,	'699Plus',	'http://b2b2c.hanchao9999.com/mobile',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edc5ae6043a.jpg',	0,	0,	'',	'',	'',	12,	10,	1,	1),
(46,	13,	0,	0,	'家装峰惠',	'http://b2b2c.hanchao9999.com/mobile',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edc5f1b0579.jpg',	0,	0,	'',	'',	'',	23,	10,	1,	1),
(47,	14,	0,	0,	'小食代',	'http://b2b2c.hanchao9999.com/mobile',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edc68b21ea1.jpg',	0,	0,	'',	'',	'',	60,	10,	1,	1),
(48,	15,	5,	0,	'潮3C',	'http://b2b2c.hanchao9999.com/index.php/mobile/shop/index/id/40.html',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edc76ea8e13.jpg',	0,	0,	'',	'',	'',	30,	10,	1,	1),
(49,	15,	0,	0,	'爱逛',	'http://b2b2c.hanchao9999.com/mobile',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edc795d3ddd.jpg',	0,	0,	'',	'',	'',	27,	10,	1,	1),
(50,	16,	5,	0,	'全城热恋',	'http://b2b2c.hanchao9999.com/index.php/mobile/shop/index/id/40.html',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edc7e8941bf.jpg',	0,	0,	'',	'',	'',	45,	10,	1,	1),
(51,	17,	5,	0,	'全城热恋',	'http://b2b2c.hanchao9999.com/index.php/mobile/shop/index/id/40.html',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edd5f446dfb.jpg',	0,	0,	'',	'',	'',	0,	10,	1,	1),
(52,	17,	5,	0,	'全城热恋',	'http://b2b2c.hanchao9999.com/index.php/mobile/shop/index/id/40.html',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edd612cbdde.jpg',	0,	0,	'',	'',	'',	0,	10,	1,	1),
(53,	31,	0,	0,	'今日特惠',	'',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170802/59819d36f1ee7.png',	0,	0,	'',	'',	'',	9,	10,	1,	0),
(54,	32,	0,	0,	'家居馆',	'',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170802/5981ae2dca688.jpg',	0,	0,	'',	'',	'',	5,	10,	1,	0),
(55,	32,	0,	0,	'24小时挑战',	'',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170802/5981aaf950acc.jpg',	0,	0,	'',	'',	'',	6,	10,	1,	0),
(56,	32,	0,	0,	'七彩消暑饮品 清凉一夏',	'http://b2b2c.hanchao9999.com/',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170802/5981abd4f1836.jpg',	0,	0,	'',	'',	'',	11,	10,	1,	0),
(57,	32,	0,	0,	'夏日靓骨汤',	'',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170802/5981adb1c74c6.jpg',	0,	0,	'',	'',	'',	17,	10,	1,	0),
(65,	33,	0,	0,	'首页头部引导图1',	'',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170414/58f07930d45f5.jpg',	0,	0,	'',	'',	'',	58,	10,	1,	0),
(66,	33,	0,	0,	'首页头部引导图2',	'url:16:2:',	16,	'2',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170420/58f8417c83e54.jpg',	0,	0,	'',	'',	'',	133,	10,	1,	0),
(67,	1,	115,	0,	'服装',	'',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170525/5926a8193f7c3.jpg',	1494604800,	1526140800,	'',	'',	'red',	0,	10,	1,	0),
(101,	3,	115,	0,	'服装1',	'',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/5928e6eb7bebd.png',	0,	0,	'',	'',	'',	80,	10,	1,	0),
(102,	5,	115,	0,	'琥珀蜜蜡低价特卖',	'',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170627/5951fa597f046.jpg',	0,	0,	'',	'',	'',	37,	10,	1,	0),
(103,	5,	115,	0,	'海瞳珍珠低价特卖',	'',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/5928e8beae8e6.png',	0,	0,	'',	'',	'',	51,	10,	1,	0),
(104,	10,	115,	0,	'辣妈时代当道',	'',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/5928f265e5493.png',	0,	0,	'',	'',	'',	0,	10,	1,	0),
(105,	10,	115,	0,	'轻感运动',	'',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/5928f3fb14801.png',	0,	0,	'',	'',	'',	0,	10,	1,	0),
(106,	11,	115,	0,	'辣妈时代当道',	'',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/5928f28aaf9a4.png',	0,	0,	'',	'',	'',	0,	10,	1,	0),
(107,	11,	115,	0,	'轻感运动',	'',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170527/5928f40c3f3e9.png',	0,	0,	'',	'',	'',	0,	10,	1,	0),
(108,	2,	1,	0,	'干果糕点',	'http://b2b2c.hanchao9999.com/index.php/cate/index/id/9.html',	0,	'',	'',	'',	0,	0,	'',	'',	'',	10,	10,	1,	0),
(109,	2,	1,	0,	'米面粮油',	'http://b2b2c.hanchao9999.com/index.php/cate/index/id/10.html',	0,	'',	'',	'',	0,	0,	'',	'',	'',	11,	10,	1,	0),
(110,	2,	1,	0,	'厨房调料',	'http://b2b2c.hanchao9999.com/index.php/cate/index/id/11.html',	0,	'',	'',	'',	0,	0,	'',	'',	'',	12,	10,	1,	0),
(111,	2,	1,	0,	'方便速食',	'url:40:12:',	40,	'12',	'',	'',	0,	0,	'',	'',	'',	12,	10,	1,	0),
(112,	2,	153,	0,	'餐具水具',	'url:40:154:',	40,	'154',	'',	'',	0,	0,	'',	'',	'',	7,	10,	1,	0),
(113,	2,	153,	0,	'厨具锅具',	'url:40:155:',	40,	'155',	'',	'',	0,	0,	'',	'',	'',	10,	10,	1,	0),
(114,	2,	153,	0,	'床上用品',	'url:40:156:',	40,	'156',	'',	'',	0,	0,	'',	'',	'',	11,	10,	1,	0),
(115,	2,	153,	0,	'家纺布艺',	'url:40:157:',	40,	'157',	'',	'',	0,	0,	'',	'',	'',	11,	10,	1,	0),
(116,	2,	153,	0,	'居家日用',	'url:40:158:',	40,	'158',	'',	'',	0,	0,	'',	'',	'',	9,	10,	1,	0),
(117,	2,	153,	0,	'收纳洗晒',	'url:40:160:',	40,	'160',	'',	'',	0,	0,	'',	'',	'',	11,	10,	1,	0),
(118,	2,	115,	0,	'男装',	'url:40:117:',	40,	'117',	'',	'',	0,	0,	'',	'',	'',	7,	10,	1,	0),
(119,	2,	115,	0,	'女装',	'url:40:116:keyword=女装',	40,	'116',	'keyword=女装',	'',	0,	0,	'',	'',	'',	13,	10,	1,	0),
(120,	2,	115,	0,	'运动',	'url:40:118:',	40,	'118',	'',	'',	0,	0,	'',	'',	'',	10,	10,	1,	0),
(121,	2,	119,	0,	'童装',	'url:40:119:',	40,	'119',	'',	'',	0,	0,	'',	'',	'',	14,	10,	1,	0),
(122,	2,	120,	0,	'手表',	'url:40:120:',	40,	'120',	'',	'',	0,	0,	'',	'',	'',	15,	10,	1,	0),
(123,	2,	121,	0,	'珠宝',	'url:40:121:',	40,	'121',	'',	'',	0,	0,	'',	'',	'',	11,	10,	1,	0),
(124,	10,	115,	0,	'复古民族风女装',	'',	0,	'',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170627/59520dfa4ffa8.jpg',	1498492800,	0,	'',	'',	'',	0,	10,	1,	0),
(125,	10,	115,	0,	'时尚手表',	'url:40::keyword=手表',	40,	'',	'keyword=手表',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170627/59520e70941d6.jpg',	0,	0,	'',	'',	'',	0,	10,	1,	0);

DROP TABLE IF EXISTS `hanchao_poster_position`;
CREATE TABLE `hanchao_poster_position` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `name` varchar(60) NOT NULL COMMENT '广告位名称',
  `width` smallint(5) NOT NULL DEFAULT '0' COMMENT '广告位宽度',
  `height` smallint(5) NOT NULL DEFAULT '0' COMMENT '广告位高度',
  `content` varchar(255) NOT NULL COMMENT '广告位描述',
  `tpl` text NOT NULL COMMENT '广告位模板代码',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '状态',
  `device` tinyint(3) unsigned NOT NULL COMMENT '设备（0:电脑端,1:移动端,2:其他）',
  `code` varchar(255) NOT NULL COMMENT '标识',
  `number` tinyint(10) NOT NULL COMMENT '广告数',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='广告位表';

INSERT INTO `hanchao_poster_position` (`id`, `name`, `width`, `height`, `content`, `tpl`, `status`, `device`, `code`, `number`) VALUES
(1,	'分类左侧大图',	313,	390,	'楼层上左图',	'floor_style_1',	1,	0,	'',	1),
(2,	'楼层大图下文本',	314,	147,	'楼层左侧分类',	'floor_style_2',	1,	0,	'',	15),
(3,	'首页楼层样式3',	404,	267,	'楼层中间上层广告',	'floor_style_3',	1,	0,	'',	1),
(4,	'首页楼层样式4',	404,	131,	'楼层中间下层竖排',	'floor_style_4',	1,	0,	'',	2),
(5,	'首页楼层样式5',	201,	262,	'楼层中间下层横排',	'floor_style_5',	1,	0,	'',	2),
(6,	'首页楼层样式6',	201,	136,	'楼层中间下层小横排',	'floor_style_6',	1,	0,	'',	2),
(7,	'首页楼层样式7',	239,	268,	'楼层右左',	'floor_style_7',	1,	0,	'',	2),
(8,	'首页楼层样式8',	239,	268,	'楼层右右',	'floor_style_8',	1,	0,	'',	2),
(9,	'首页楼层样式9',	480,	134,	'楼层右侧上竖排',	'floor_style_9',	1,	0,	'',	2),
(10,	'首页楼层样式10',	0,	0,	'楼层广告右左不同大小',	'floor_style_10',	1,	0,	'',	2),
(11,	'首页楼层样式11',	0,	0,	'楼层右右不同大小',	'floor_style_11',	1,	0,	'',	2),
(12,	'首页楼层样式12',	0,	0,	'',	'floor_style_12',	1,	0,	'',	2),
(13,	'首页轮播图',	0,	0,	'首页轮播图',	'mobile_banner1',	1,	1,	'',	4),
(14,	'首页广告位1',	0,	0,	'公告下的左侧广告位',	'mobile_cate',	1,	1,	'',	1),
(15,	'首页广告位2',	0,	0,	'首页公告下的右侧广告位',	'mobile_banner3',	1,	1,	'',	2),
(16,	'首页广告位3',	0,	0,	'限时秒杀下的广告位',	'mobile_banner4',	1,	1,	'',	1),
(17,	'分类广告位',	0,	0,	'',	'mobile_cate',	1,	1,	'',	1),
(18,	'登陆广告',	0,	0,	'登陆左侧广告',	'login',	1,	0,	'',	1),
(19,	'弹窗登录广告',	0,	0,	'弹窗登录广告',	'min_login',	1,	0,	'',	1),
(20,	'首页轮播图',	0,	0,	'',	'index_slide',	1,	0,	'',	5),
(21,	'首页公告下广告',	240,	156,	'',	'index_notice',	1,	0,	'',	1),
(22,	'首页中间样式1',	0,	0,	'',	'index_middle_style_1',	1,	0,	'',	1),
(23,	'首页中间样式2',	0,	0,	'',	'index_middle_style_2',	1,	0,	'',	1),
(24,	'首页中间样式3',	0,	0,	'',	'index_middle_style_3',	1,	0,	'',	1),
(25,	'首页中间样式4',	0,	0,	'',	'index_middle_style_4',	1,	0,	'',	1),
(26,	'首页中间样式5',	0,	0,	'',	'index_middle_style_5',	1,	0,	'',	1),
(27,	'首页中间样式6',	0,	0,	'',	'index_middle_style_6',	1,	0,	'',	1),
(28,	'首页中间样式7',	0,	0,	'',	'index_middle_style_7',	1,	0,	'',	1),
(29,	'首页中间样式8',	0,	0,	'',	'index_middle_style_8',	1,	0,	'',	1),
(30,	'首页中间底部样式',	0,	0,	'',	'index_middle_bottom',	1,	0,	'',	6),
(31,	'优惠活动轮播',	1423,	412,	'',	'promot_banner',	1,	0,	'',	3),
(32,	'优惠轮播下',	291,	178,	'',	'promot_bottom',	1,	0,	'',	4),
(33,	'首页头部引导图',	0,	0,	'',	'top_poster',	1,	0,	'',	2);

DROP TABLE IF EXISTS `hanchao_project_label`;
CREATE TABLE `hanchao_project_label` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '类型主键',
  `label_name` varchar(60) NOT NULL COMMENT '标签名字',
  `price` decimal(10,2) unsigned NOT NULL COMMENT '保证金，店铺等级金额等',
  `images` char(100) NOT NULL COMMENT '列表缩略图',
  `brief_img` char(100) NOT NULL COMMENT '标签简介图',
  `brief_url` varchar(255) NOT NULL COMMENT '标签简介链接',
  `brief_info` varchar(255) NOT NULL COMMENT '标签简介信息',
  `sort` smallint(5) NOT NULL DEFAULT '10' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否关闭禁用',
  `type` tinyint(1) NOT NULL DEFAULT '0' COMMENT '标签类型0商品1店铺服务保障2店铺等级3店铺权限',
  `power` varchar(50) CHARACTER SET utf32 NOT NULL COMMENT '权限(1限时促销，2优惠活动，3代金券)',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='项目标签表';

INSERT INTO `hanchao_project_label` (`id`, `label_name`, `price`, `images`, `brief_img`, `brief_url`, `brief_info`, `sort`, `status`, `type`, `power`) VALUES
(1,	'钻石',	9.00,	'',	'',	'',	'',	10,	1,	2,	'1'),
(2,	'皇冠',	99.00,	'',	'',	'',	'',	10,	1,	2,	'2,1'),
(3,	'金冠',	999.00,	'',	'',	'',	'',	10,	1,	2,	'3,2,1'),
(4,	'如实描述',	100.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58edffdd0825d.jpg',	'',	'index.php?s=/article/show/id/52.html',	'消费者购买支持此服务的商品，如果被发现和卖家描述的不一样，可以申请赔付。',	10,	1,	1,	''),
(5,	'七天无理由退换货',	100.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ee0027c3e89.jpg',	'',	'index.php?s=/article/show/id/53.html',	'消费者购买支持此服务的商品后，如果在签收货物后的7天内不想买了，卖家有义务向客户提供退换货服务。',	10,	1,	1,	''),
(6,	'假一赔三',	100.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ee0059b1482.jpg',	'',	'index.php?s=/article/show/id/54.html',	'消费者购买支持此服务的商品，如果被发现是假货，就能申请三倍赔偿。',	10,	1,	1,	''),
(7,	'闪电发货',	100.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ee007fe4966.jpg',	'',	'index.php?s=/article/show/id/55.html',	'消费者购买支持此服务的商品，能够享受“闪电发货”，要是卖家发货不及时，买家可以申请赔偿。',	10,	1,	1,	''),
(8,	'正品保障',	100.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170412/58ee00dbe51ad.jpg',	'',	'index.php?s=/article/show/id/56.html',	'卖家承诺提供“正品保障”服务，可以使顾客放心购买！',	10,	1,	1,	''),
(9,	'新到商品',	0.00,	'',	'',	'',	'',	10,	1,	0,	''),
(10,	'包邮',	0.00,	'',	'',	'',	'',	10,	1,	0,	''),
(11,	'折扣',	0.00,	'',	'',	'',	'',	10,	1,	0,	''),
(12,	'细节实拍',	0.00,	'',	'',	'',	'',	10,	1,	0,	''),
(13,	'搭配减价',	0.00,	'',	'',	'',	'',	10,	1,	0,	''),
(14,	'满就减',	0.00,	'',	'',	'',	'',	10,	1,	0,	''),
(15,	'满折',	0.00,	'',	'',	'',	'',	10,	1,	0,	''),
(16,	'9.9包邮',	0.00,	'',	'',	'',	'',	10,	1,	0,	''),
(17,	'淘宝精品',	0.00,	'',	'',	'',	'',	10,	1,	0,	''),
(18,	'特卖',	0.00,	'',	'',	'',	'',	10,	1,	0,	''),
(19,	'特惠',	0.00,	'',	'',	'',	'',	10,	1,	0,	''),
(20,	'精品折扣',	0.00,	'',	'',	'',	'',	10,	1,	0,	''),
(21,	'热抢商品',	0.00,	'',	'',	'',	'',	10,	0,	0,	''),
(22,	'享实惠',	0.00,	'',	'',	'',	'',	10,	0,	0,	''),
(23,	'买多赠',	0.00,	'',	'',	'',	'',	10,	0,	0,	''),
(24,	'巨实惠',	0.00,	'',	'',	'',	'',	10,	0,	0,	''),
(25,	'限时促销',	100.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170508/591048bb2448f.jpg',	'',	'http://b2b2c.hanchao9999.com/index.php/home/article/show/id/70.html',	'限时促销',	10,	1,	3,	''),
(26,	'优惠活动',	50.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170513/59169b14c5ea2.png',	'',	'http://b2b2c.hanchao9999.com/index.php/home/article/show/id/71.html',	'优惠活动',	10,	1,	3,	''),
(27,	'代金券',	0.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170508/591048d2502f1.jpg',	'',	'http://b2b2c.hanchao9999.com/index.php/home/article/show/id/72.html',	'',	10,	1,	3,	''),
(31,	'权限测试',	1.00,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170711/596482c4ca143.jpg',	'',	'',	'',	10,	0,	3,	''),
(32,	'王者',	0.00,	'',	'',	'',	'',	10,	0,	2,	'');

DROP TABLE IF EXISTS `hanchao_project_label_link`;
CREATE TABLE `hanchao_project_label_link` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `goods_id` int(10) NOT NULL COMMENT '商品名称',
  `label_id` int(10) NOT NULL DEFAULT '10' COMMENT '标签id',
  `shop_id` int(10) NOT NULL COMMENT '店铺id',
  `deposit` decimal(10,2) NOT NULL COMMENT '保证金（店铺服务保障）',
  `update_time` int(10) NOT NULL COMMENT '生成时间（店铺服务保障）',
  `apply_time` int(10) NOT NULL COMMENT '申请时间（店铺服务保障）',
  `publish_wait` tinyint(1) NOT NULL COMMENT '0:等待审核 1:已审核 2:审核不通过 [加入|退出] 3待审核 4通过 5不通过 （店铺标签）',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='项目标签关联表';


DROP TABLE IF EXISTS `hanchao_promot_act`;
CREATE TABLE `hanchao_promot_act` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT 'id',
  `pid` smallint(5) unsigned NOT NULL COMMENT '父id',
  `act_name` varchar(255) NOT NULL COMMENT '活动名称',
  `start_time` int(10) unsigned NOT NULL COMMENT '开始时间',
  `end_time` int(10) unsigned NOT NULL COMMENT '结束时间',
  `user_rank` varchar(200) NOT NULL COMMENT '会员等级',
  `min_amount` decimal(10,2) unsigned NOT NULL COMMENT '订单下限',
  `max_amount` decimal(10,2) unsigned NOT NULL COMMENT '订单上限',
  `act_type` tinyint(3) unsigned NOT NULL COMMENT '1减免,2折扣',
  `act_type_ext` decimal(10,2) unsigned NOT NULL COMMENT '减免或折扣的数值',
  `sort` tinyint(3) unsigned NOT NULL DEFAULT '50' COMMENT '排序',
  `is_addup` tinyint(3) unsigned NOT NULL COMMENT '减免或折扣是否累加:0否;1:是',
  `img` varchar(200) NOT NULL COMMENT '封面图',
  `big_img` varchar(200) NOT NULL COMMENT '活动大图',
  `is_group` tinyint(5) NOT NULL COMMENT '是否为团购活动',
  `is_limit_time` tinyint(5) NOT NULL COMMENT '是否为限时促销',
  `is_pt` tinyint(5) NOT NULL COMMENT '是否为拼团活动',
  `is_presale` tinyint(5) NOT NULL COMMENT '是否是预售 ',
  `group_number` tinyint(5) NOT NULL COMMENT '成团人数',
  `group_time_limit` tinyint(5) NOT NULL COMMENT '成团时限，小时',
  `buy_limit` tinyint(5) NOT NULL COMMENT '购买限制，0表示没有限制',
  `head_commission_rate` int(5) NOT NULL COMMENT '团长佣金比例，100%时为免单',
  `shop_id` int(5) unsigned NOT NULL COMMENT '店铺id',
  `status` tinyint(1) unsigned NOT NULL COMMENT '0不开放，1开放',
  PRIMARY KEY (`id`),
  KEY `act_name` (`act_name`)
) ENGINE=InnoDB AUTO_INCREMENT=164 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='促销活动表';

INSERT INTO `hanchao_promot_act` (`id`, `pid`, `act_name`, `start_time`, `end_time`, `user_rank`, `min_amount`, `max_amount`, `act_type`, `act_type_ext`, `sort`, `is_addup`, `img`, `big_img`, `is_group`, `is_limit_time`, `is_pt`, `is_presale`, `group_number`, `group_time_limit`, `buy_limit`, `head_commission_rate`, `shop_id`, `status`) VALUES
(94,	0,	'拼团1',	1500357734,	1500364938,	'',	0.00,	0.00,	0,	0.00,	50,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170718/596da43bba7b4.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170718/596da445c128b.jpg',	0,	0,	1,	0,	2,	2,	0,	0,	9,	0),
(100,	0,	'平台2',	1501230302,	1501316703,	'',	0.00,	0.00,	0,	0.00,	50,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170728/597af4d61b08d.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170728/597af4db048f1.jpg',	0,	0,	0,	1,	0,	25,	0,	0,	0,	0),
(108,	0,	'一“杯”子的温暖-BESTJOY水具专场',	1501731546,	1533267548,	'',	50.00,	0.00,	2,	2.00,	50,	1,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/59829a8b0d61a.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/59829c1885dc7.png',	0,	0,	0,	0,	0,	0,	0,	0,	38,	0),
(109,	0,	'意大利奥尼原装进口橄榄油专场',	1501741757,	1533277759,	'',	199.00,	0.00,	1,	40.00,	50,	1,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982c28176112.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982c3221316b.png',	0,	0,	0,	0,	0,	0,	0,	0,	38,	0),
(110,	0,	'H&amp;3精致厨卫专场',	1501746958,	1533282960,	'',	0.00,	0.00,	0,	0.00,	50,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982d6833196e.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982d7574bb66.png',	0,	1,	0,	0,	0,	0,	0,	0,	0,	1),
(111,	110,	'H&amp;3精致厨卫专场',	1501746958,	1533282960,	'',	0.00,	0.00,	0,	0.00,	50,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982d6833196e.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982d7574bb66.png',	0,	1,	0,	0,	0,	0,	0,	0,	38,	0),
(112,	0,	'拼出优惠，爱拼才会赢！',	1501815091,	1533351093,	'',	0.00,	0.00,	0,	0.00,	50,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/5983edd2e6b86.png',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/5983e09a7ec1b.png',	0,	0,	1,	0,	2,	48,	0,	0,	38,	0),
(113,	0,	'拼出新优惠，爱拼才会赢！',	1501826306,	1533362308,	'',	0.00,	0.00,	0,	0.00,	50,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59840cb46dba9.png',	'',	0,	0,	1,	0,	2,	48,	0,	0,	38,	0),
(114,	0,	'拼出新优惠',	1501828309,	1533364311,	'',	0.00,	0.00,	0,	0.00,	50,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/5984145b791b1.jpg',	'',	0,	0,	1,	0,	2,	48,	0,	0,	38,	0),
(115,	0,	'拼出新优惠',	1501828361,	1533364363,	'',	0.00,	0.00,	0,	0.00,	50,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/598414b98bcc2.jpg',	'',	0,	0,	1,	0,	2,	48,	0,	0,	38,	0),
(116,	0,	'VEE女装专场',	1501828774,	1533364776,	'',	100.00,	0.00,	2,	85.00,	50,	1,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59841652e4ada.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59843eec9ac04.png',	0,	0,	0,	0,	0,	0,	0,	0,	38,	0),
(117,	0,	'沙发SOFA女装专场',	1501829070,	1533365072,	'',	100.00,	0.00,	2,	60.00,	50,	1,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/5984173871b65.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59843c7598acd.png',	0,	0,	0,	0,	0,	0,	0,	0,	38,	0),
(118,	0,	'贝亲Pigeon婴童用品专场',	1501829384,	1533365385,	'',	100.00,	0.00,	2,	4.80,	50,	1,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/598418826f893.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59843cc574c03.png',	0,	0,	0,	0,	0,	0,	0,	0,	38,	0),
(119,	0,	'可米熊camibear婴童混合专场',	1501829692,	1533365693,	'',	300.00,	0.00,	1,	50.00,	50,	1,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/5984199f1dbb4.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59843d1b16b63.png',	0,	0,	0,	0,	0,	0,	0,	0,	38,	0),
(120,	0,	'优雅旗下清仓专场',	1501830024,	1533366026,	'',	1000.00,	0.00,	2,	5.00,	50,	1,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59841b0982eeb.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59843d7b273de.png',	0,	0,	0,	0,	0,	0,	0,	0,	38,	0),
(121,	0,	'洁丽雅·兰 德国高端百货同款',	1501830266,	1533366267,	'',	50.00,	0.00,	1,	1.30,	50,	1,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59841bbe5c4f7.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59843ddf02836.png',	0,	0,	0,	0,	0,	0,	0,	0,	38,	0),
(122,	0,	'新农哥健康坚果专场',	1501830512,	1533366514,	'',	300.00,	0.00,	1,	50.00,	50,	1,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59841d2881198.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59843e3cf170b.png',	0,	0,	0,	0,	0,	0,	0,	0,	38,	0),
(123,	0,	'良品铺子休闲零食专场',	1501830710,	1533366711,	'',	300.00,	0.00,	1,	50.00,	50,	1,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59841de27495e.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/59843e7e97f41.png',	0,	0,	0,	0,	0,	0,	0,	0,	38,	0),
(124,	0,	'七夕订货会',	1502102863,	1504781265,	'',	0.00,	0.00,	0,	0.00,	50,	0,	'',	'',	0,	0,	0,	1,	0,	30,	10,	0,	44,	0),
(126,	110,	'H&amp;3精致厨卫专场',	1501746958,	1533282960,	'',	0.00,	0.00,	0,	0.00,	50,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982d6833196e.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982d7574bb66.png',	0,	1,	0,	0,	0,	0,	0,	0,	40,	0),
(127,	0,	'',	1502158882,	1504146084,	'',	10000.00,	0.00,	2,	99.00,	50,	1,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/5989206dda1d2.png',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59892a568ccd7.jpg',	0,	0,	0,	0,	0,	0,	0,	0,	40,	0),
(128,	0,	'清仓大降价',	1502160325,	1502333127,	'',	0.00,	0.00,	0,	0.00,	50,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/598925d149124.jpg',	'',	0,	0,	0,	1,	0,	20,	0,	0,	40,	0),
(130,	0,	'三星电器促销啦',	1502163543,	1502177944,	'',	0.00,	0.00,	0,	0.00,	50,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59893276445aa.jpg',	'',	0,	0,	1,	0,	8,	5,	0,	0,	40,	0),
(137,	0,	'夏季清仓',	1502948561,	1503466963,	'',	100.00,	1000.00,	2,	80.00,	50,	1,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170817/59952b3d219d4.png',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170817/59952b5773d3c.png',	0,	0,	0,	0,	0,	0,	0,	0,	43,	0),
(138,	0,	'时尚拼团',	1502949032,	1503467434,	'',	0.00,	0.00,	0,	0.00,	50,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170817/59952d15939a0.png',	'',	0,	0,	1,	0,	8,	72,	2,	0,	43,	0),
(139,	0,	'2017新款秋季双排扣麂皮绒显瘦风衣女韩版休闲收腰外套',	1502949873,	1503468274,	'',	0.00,	0.00,	0,	0.00,	50,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170817/5995305dd35db.jpg',	'',	0,	0,	0,	1,	0,	20,	10,	0,	43,	0),
(140,	110,	'H&amp;3精致厨卫专场',	1501746958,	1533282960,	'',	0.00,	0.00,	0,	0.00,	50,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982d6833196e.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982d7574bb66.png',	0,	1,	0,	0,	0,	0,	0,	0,	48,	0),
(141,	0,	'大甩卖',	2017,	2017,	'',	0.00,	0.00,	2,	100.00,	50,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170821/599a3fc68d2e2.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170821/599a3fced2413.jpg',	0,	0,	0,	0,	0,	0,	0,	0,	0,	0),
(142,	0,	'兰老板的绝世好刀',	1503281573,	1503540775,	'',	0.00,	0.00,	2,	100.00,	50,	1,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170821/599a411f8b4d6.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170821/599a41265b9f6.jpg',	0,	0,	0,	0,	0,	0,	0,	0,	48,	0),
(143,	0,	'拼出优惠',	1503299041,	1513839846,	'',	0.00,	0.00,	0,	0.00,	50,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170821/599a86795b767.jpg',	'',	0,	0,	1,	0,	2,	48,	5,	0,	44,	0),
(144,	0,	'拼团',	1503363313,	1503622518,	'',	0.00,	0.00,	0,	0.00,	50,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170822/599b800e262f3.jpg',	'',	0,	0,	1,	0,	5,	8,	1,	0,	48,	0),
(145,	0,	'限时包邮',	1503364115,	1504141720,	'',	0.00,	0.00,	0,	0.00,	50,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170822/599b83f93e1b9.jpg',	'',	0,	0,	1,	0,	5,	30,	1,	0,	46,	0),
(146,	0,	'预售青柠檬',	1503367168,	1504749573,	'',	0.00,	0.00,	0,	0.00,	50,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170822/599b8fc546ea1.jpg',	'',	0,	0,	0,	1,	0,	120,	1,	0,	46,	0),
(148,	0,	'活动',	1503389877,	1504167486,	'',	0.00,	0.00,	0,	0.00,	50,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170822/599be7eae9c31.jpg',	'',	0,	0,	0,	1,	0,	6,	1,	0,	48,	0),
(149,	0,	'七夕情人节特惠',	1503566642,	1504171442,	'',	100.00,	1000.00,	2,	8.00,	50,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170822/599bf66cda45e.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170822/599bf6a03b7b0.png',	0,	0,	0,	0,	0,	0,	0,	0,	43,	0),
(150,	0,	'韩版淑女休闲高跟鞋',	1504171733,	1504776533,	'',	0.00,	0.00,	0,	0.00,	50,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170822/599bf7be96521.png',	'',	0,	0,	1,	0,	5,	72,	2,	0,	43,	0),
(151,	0,	'韩版碎花连衣裙',	1503394226,	1504776628,	'',	0.00,	0.00,	0,	0.00,	50,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170822/599bf9a61756d.png',	'',	0,	0,	0,	1,	0,	20,	2,	0,	43,	0),
(152,	110,	'H&amp;3精致厨卫专场',	1501746958,	1533282960,	'',	0.00,	0.00,	0,	0.00,	50,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982d6833196e.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982d7574bb66.png',	0,	1,	0,	0,	0,	0,	0,	0,	43,	0),
(153,	110,	'H&amp;3精致厨卫专场',	1501746958,	1533282960,	'',	0.00,	0.00,	0,	0.00,	50,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982d6833196e.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982d7574bb66.png',	0,	1,	0,	0,	0,	0,	0,	0,	44,	0),
(154,	0,	'秋冬尚新',	1504159401,	1536224113,	'',	0.00,	0.00,	0,	0.00,	50,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170831/59a7a6846c777.png',	'',	0,	0,	0,	1,	0,	3,	0,	0,	38,	0),
(155,	0,	'采摘专场',	1504073041,	1506751452,	'',	50.00,	0.00,	1,	10.00,	50,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170831/59a7afcbae94e.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170831/59a7b0acc1c27.jpg',	0,	0,	0,	0,	0,	0,	0,	0,	44,	0),
(156,	0,	'前开叉半裙拼团活动',	1504165885,	1535701887,	'',	0.00,	0.00,	0,	0.00,	50,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170831/59a7bfe44a15d.jpg',	'',	0,	0,	1,	0,	10,	12,	0,	0,	38,	0),
(160,	0,	'预售汽车音响',	1504688037,	1506761639,	'',	0.00,	0.00,	0,	0.00,	50,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170906/59afb7814bd53.jpg',	'',	0,	0,	0,	1,	0,	2,	0,	0,	49,	0),
(163,	0,	'汽车头枕护颈枕 车载真皮枕头 车用座椅腰靠枕记 奥迪A4LA3A6L5A7Q3Q58 黑色头枕加腰靠一对价 奥迪A6L A4L Q5 Q3 A3 Q7 A8',	1504688841,	1506762443,	'',	0.00,	0.00,	0,	0.00,	50,	0,	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170906/59afbac09b5d6.jpg',	'',	0,	0,	1,	0,	2,	48,	0,	0,	49,	0);

DROP TABLE IF EXISTS `hanchao_promot_ext`;
CREATE TABLE `hanchao_promot_ext` (
  `id` int(10) NOT NULL AUTO_INCREMENT COMMENT 'id',
  `act_id` int(10) NOT NULL COMMENT '活动ID',
  `style` tinyint(5) NOT NULL COMMENT '活动类型1分类2品牌3商品4拼团5促销6定金预售7全额预售 ',
  `style_ext_id` int(10) NOT NULL COMMENT '活动中的类型值',
  `remarks` varchar(200) NOT NULL COMMENT '拼团备用字段',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=641 DEFAULT CHARSET=utf8 COMMENT='活动关联表';

INSERT INTO `hanchao_promot_ext` (`id`, `act_id`, `style`, `style_ext_id`, `remarks`) VALUES
(3,	2,	1,	49,	''),
(17,	17,	1,	1,	''),
(18,	19,	3,	41,	''),
(19,	19,	3,	42,	''),
(27,	26,	1,	5,	''),
(28,	26,	1,	99,	''),
(31,	28,	1,	99,	''),
(34,	20,	1,	62,	''),
(37,	31,	3,	41,	''),
(40,	37,	3,	41,	''),
(41,	30,	1,	1,	''),
(44,	42,	1,	62,	''),
(73,	49,	3,	74,	''),
(74,	52,	3,	72,	''),
(76,	40,	1,	5,	''),
(82,	43,	3,	36,	''),
(83,	46,	3,	85,	''),
(84,	46,	3,	84,	''),
(85,	46,	3,	86,	''),
(86,	46,	3,	87,	''),
(89,	70,	4,	72,	's:1:\"1\";'),
(90,	71,	4,	2,	's:1:\"2\";'),
(94,	72,	4,	99,	's:2:\"35\";'),
(95,	73,	4,	72,	's:2:\"10\";'),
(96,	74,	4,	74,	's:3:\"0.1\";'),
(102,	77,	4,	103,	's:5:\"0.008\";'),
(104,	76,	4,	102,	's:2:\"15\";'),
(107,	79,	4,	3,	's:1:\"1\";'),
(109,	78,	4,	104,	's:3:\"3.5\";'),
(110,	81,	4,	105,	's:1:\"9\";'),
(113,	84,	1,	148,	''),
(115,	82,	4,	7,	's:3:\"111\";'),
(116,	86,	4,	6,	's:2:\"11\";'),
(118,	80,	4,	5,	's:2:\"11\";'),
(122,	22,	3,	7,	''),
(123,	22,	3,	41,	''),
(124,	22,	3,	10,	''),
(125,	22,	3,	90,	''),
(149,	90,	4,	104,	's:1:\"3\";'),
(168,	91,	3,	94,	''),
(169,	91,	3,	80,	''),
(170,	91,	3,	78,	''),
(171,	91,	3,	92,	''),
(172,	91,	3,	99,	''),
(173,	92,	3,	6,	''),
(174,	92,	3,	21,	''),
(175,	92,	3,	24,	''),
(176,	92,	3,	30,	''),
(306,	94,	4,	44,	's:5:\"25.00\";'),
(307,	89,	3,	21,	''),
(308,	89,	3,	22,	''),
(309,	89,	3,	24,	''),
(310,	89,	3,	26,	''),
(311,	89,	3,	28,	''),
(312,	89,	3,	29,	''),
(313,	89,	3,	82,	''),
(314,	89,	3,	83,	''),
(315,	89,	3,	84,	''),
(316,	89,	3,	2,	''),
(317,	89,	3,	30,	''),
(318,	89,	3,	32,	''),
(319,	89,	3,	3,	''),
(320,	89,	3,	64,	''),
(329,	96,	6,	0,	'a:2:{s:11:\"group_price\";s:2:\"10\";s:9:\"pre_money\";s:1:\"5\";}'),
(333,	100,	6,	29,	'a:2:{s:11:\"group_price\";s:3:\"100\";s:9:\"pre_money\";s:2:\"48\";}'),
(353,	107,	6,	72,	'a:2:{s:11:\"group_price\";s:1:\"5\";s:9:\"pre_money\";s:1:\"3\";}'),
(368,	112,	4,	130,	's:3:\"145\";'),
(369,	113,	4,	131,	's:2:\"99\";'),
(370,	114,	4,	132,	's:2:\"55\";'),
(446,	109,	3,	120,	'N;'),
(447,	109,	3,	121,	'N;'),
(448,	109,	3,	122,	'N;'),
(449,	109,	3,	123,	'N;'),
(450,	109,	3,	124,	'N;'),
(451,	109,	3,	149,	'N;'),
(452,	109,	3,	150,	'N;'),
(453,	109,	3,	151,	'N;'),
(454,	109,	3,	152,	'N;'),
(455,	109,	3,	153,	'N;'),
(456,	109,	3,	155,	'N;'),
(457,	109,	3,	156,	'N;'),
(458,	109,	3,	157,	'N;'),
(459,	109,	3,	158,	'N;'),
(460,	109,	3,	154,	'N;'),
(461,	109,	3,	159,	'N;'),
(462,	109,	3,	160,	'N;'),
(463,	109,	3,	161,	'N;'),
(464,	109,	3,	162,	'N;'),
(465,	109,	3,	163,	'N;'),
(540,	116,	3,	164,	'N;'),
(541,	116,	3,	165,	'N;'),
(542,	116,	3,	166,	'N;'),
(543,	116,	3,	171,	'N;'),
(544,	116,	3,	167,	'N;'),
(545,	116,	3,	168,	'N;'),
(546,	116,	3,	169,	'N;'),
(547,	116,	3,	172,	'N;'),
(548,	116,	3,	170,	'N;'),
(549,	116,	3,	173,	'N;'),
(550,	116,	3,	178,	'N;'),
(551,	116,	3,	174,	'N;'),
(552,	116,	3,	177,	'N;'),
(553,	116,	3,	175,	'N;'),
(554,	116,	3,	176,	'N;'),
(555,	116,	3,	179,	'N;'),
(556,	116,	3,	180,	'N;'),
(557,	116,	3,	182,	'N;'),
(558,	116,	3,	181,	'N;'),
(559,	116,	3,	183,	'N;'),
(563,	128,	6,	188,	'a:2:{s:11:\"group_price\";s:3:\"359\";s:9:\"pre_money\";s:3:\"250\";}'),
(569,	130,	4,	189,	's:4:\"3500\";'),
(591,	139,	6,	230,	'a:2:{s:11:\"group_price\";s:3:\"239\";s:9:\"pre_money\";s:2:\"10\";}'),
(592,	138,	4,	219,	's:2:\"40\";'),
(593,	142,	3,	244,	'N;'),
(597,	143,	4,	193,	's:2:\"10\";'),
(598,	124,	6,	195,	'a:2:{s:11:\"group_price\";s:2:\"30\";s:9:\"pre_money\";s:2:\"20\";}'),
(599,	144,	4,	244,	's:3:\"199\";'),
(600,	145,	4,	242,	's:2:\"10\";'),
(601,	146,	7,	238,	'a:2:{s:11:\"group_price\";s:3:\"100\";s:9:\"pre_money\";s:0:\"\";}'),
(602,	148,	6,	245,	'a:2:{s:11:\"group_price\";s:3:\"188\";s:9:\"pre_money\";s:2:\"88\";}'),
(605,	150,	4,	224,	's:2:\"50\";'),
(606,	151,	6,	234,	'a:2:{s:11:\"group_price\";s:3:\"100\";s:9:\"pre_money\";s:2:\"10\";}'),
(610,	115,	4,	133,	's:2:\"28\";'),
(612,	155,	3,	259,	'N;'),
(613,	156,	4,	178,	's:3:\"300\";'),
(614,	108,	3,	115,	'N;'),
(615,	108,	3,	116,	'N;'),
(616,	108,	3,	117,	'N;'),
(617,	108,	3,	118,	'N;'),
(618,	108,	3,	119,	'N;'),
(619,	108,	3,	134,	'N;'),
(620,	108,	3,	135,	'N;'),
(621,	108,	3,	136,	'N;'),
(622,	108,	3,	137,	'N;'),
(623,	108,	3,	138,	'N;'),
(624,	108,	3,	139,	'N;'),
(625,	108,	3,	140,	'N;'),
(626,	108,	3,	141,	'N;'),
(627,	108,	3,	142,	'N;'),
(628,	108,	3,	143,	'N;'),
(629,	108,	3,	144,	'N;'),
(630,	108,	3,	145,	'N;'),
(631,	108,	3,	146,	'N;'),
(632,	108,	3,	147,	'N;'),
(633,	108,	3,	148,	'N;'),
(636,	160,	6,	262,	'a:2:{s:11:\"group_price\";s:2:\"90\";s:9:\"pre_money\";s:2:\"50\";}'),
(638,	154,	6,	182,	'a:2:{s:11:\"group_price\";s:3:\"288\";s:9:\"pre_money\";s:2:\"10\";}'),
(640,	163,	4,	260,	's:3:\"150\";');

DROP TABLE IF EXISTS `hanchao_push_log`;
CREATE TABLE `hanchao_push_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `content` text NOT NULL COMMENT '推送内容',
  `addtime` int(11) NOT NULL COMMENT '添加时间',
  `updatetime` int(11) NOT NULL COMMENT '更新时间',
  `uid` int(11) NOT NULL COMMENT '会员id',
  `adminid` int(11) NOT NULL COMMENT '管理员组id',
  `allid` int(11) NOT NULL COMMENT '默认为1为广播',
  `result` text NOT NULL COMMENT '结果',
  `errmsg` text NOT NULL COMMENT '报错原因',
  `is_success` tinyint(1) NOT NULL COMMENT '是否成功',
  `title` text NOT NULL COMMENT '标题',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='推送日志表';


DROP TABLE IF EXISTS `hanchao_push_set`;
CREATE TABLE `hanchao_push_set` (
  `id` tinyint(4) NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `appkey` varchar(200) NOT NULL COMMENT 'AppKey',
  `master_secret` varchar(200) NOT NULL COMMENT 'master_secret',
  `group` varchar(255) NOT NULL COMMENT '''PushSetOrderSend''=>''订单发货'',''PushSetOrderRefund''=>''退款订单'',''PushSetOrderReturn''=>''退货订单''',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='推送设置表';

INSERT INTO `hanchao_push_set` (`id`, `appkey`, `master_secret`, `group`) VALUES
(1,	'b589734caa5deb171986a5f3',	'dfde779642f70403455ee627',	'');

DROP TABLE IF EXISTS `hanchao_refund_order`;
CREATE TABLE `hanchao_refund_order` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `uid` int(10) unsigned NOT NULL COMMENT '会员id',
  `shop_id` int(10) unsigned NOT NULL COMMENT '店铺ID',
  `order_id` int(10) NOT NULL COMMENT '订单id',
  `order_goods` varchar(255) NOT NULL COMMENT '订单商品id,以逗号分隔',
  `money` decimal(10,2) NOT NULL COMMENT '退款金额',
  `refund_money` decimal(10,2) NOT NULL COMMENT '退款到余额',
  `refund_scores` decimal(10,2) NOT NULL COMMENT '退款到积分',
  `refund_web` decimal(10,2) NOT NULL COMMENT '退款到网银',
  `payment_id` int(11) NOT NULL COMMENT '支付方式id',
  `payment_code` varchar(30) NOT NULL COMMENT '支付code',
  `addtime` int(11) unsigned NOT NULL COMMENT '提交时间',
  `update_time` int(11) unsigned NOT NULL COMMENT '处理时间',
  `reason` varchar(255) NOT NULL COMMENT '退款原因',
  `status` tinyint(1) NOT NULL COMMENT '0未确认,1已确认，2拒绝',
  `is_delete` tinyint(1) NOT NULL COMMENT '是否作废,1是0否',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='退款单表';


DROP TABLE IF EXISTS `hanchao_return_goods`;
CREATE TABLE `hanchao_return_goods` (
  `id` int(255) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键',
  `uid` int(255) unsigned NOT NULL COMMENT '会员id',
  `shop_id` int(255) unsigned NOT NULL COMMENT '店铺id',
  `order_id` int(255) unsigned NOT NULL COMMENT '订单id',
  `org_id` varchar(255) NOT NULL COMMENT '订单商品id',
  `goods_info` varchar(255) NOT NULL COMMENT '商品信息(商品id和退款数量)',
  `reason` varchar(255) NOT NULL COMMENT '退货原因',
  `money` decimal(10,2) unsigned NOT NULL COMMENT '退货金额',
  `add_time` int(10) NOT NULL COMMENT '添加时间',
  `status` tinyint(1) NOT NULL COMMENT '0未处理，1已同意，2已拒绝',
  `shop_status` tinyint(1) NOT NULL COMMENT '店铺:0未收货，1已收货',
  `update_time` int(10) NOT NULL COMMENT '修改时间',
  `content` varchar(255) NOT NULL COMMENT '拒绝理由',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='退货单表';


DROP TABLE IF EXISTS `hanchao_service`;
CREATE TABLE `hanchao_service` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `type` tinyint(1) NOT NULL COMMENT '1为投诉，2为商品咨询，3为订单咨询',
  `goods_id` int(10) NOT NULL COMMENT '商品Id',
  `order_id` int(10) NOT NULL COMMENT '订单ID',
  `shop_id` int(10) NOT NULL COMMENT '店铺ID',
  `img` char(100) NOT NULL COMMENT '图片',
  `pid` int(10) NOT NULL COMMENT '回复的客服ID',
  `p_content` text NOT NULL COMMENT '回复的内容',
  `uid` int(10) NOT NULL COMMENT '会员ID',
  `content` text NOT NULL COMMENT '内容',
  `mobile` int(11) NOT NULL COMMENT '联系电话',
  `email` varchar(60) NOT NULL COMMENT '邮箱',
  `addtime` int(10) NOT NULL COMMENT '添加时间',
  `updatetime` int(10) NOT NULL COMMENT '回复时间',
  `status` tinyint(1) NOT NULL COMMENT '状态',
  `is_delete` tinyint(1) NOT NULL COMMENT '是否删除，0未删除，1删除',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='客户服务表';


DROP TABLE IF EXISTS `hanchao_ship_order`;
CREATE TABLE `hanchao_ship_order` (
  `id` int(255) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `notice_sn` varchar(255) NOT NULL COMMENT '快递单号',
  `ship_time` int(11) NOT NULL COMMENT '发货时间',
  `get_time` int(11) NOT NULL COMMENT '收货时间',
  `status` tinyint(1) NOT NULL COMMENT '0:未收货1:已收货',
  `org_id` varchar(255) NOT NULL COMMENT '订单商品ID',
  `uid` int(10) NOT NULL COMMENT '会员id',
  `remark` text NOT NULL COMMENT '发货备注',
  `express_id` int(11) NOT NULL COMMENT '快递接口ID（用于查询快递与打印快递单）',
  `send_type` varchar(50) NOT NULL COMMENT '发货方式',
  `shop_id` int(11) NOT NULL COMMENT '发货商家ID',
  `goods_id` varchar(255) NOT NULL COMMENT '商品ID',
  `order_id` int(11) NOT NULL COMMENT '订单id',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='发货单表';


DROP TABLE IF EXISTS `hanchao_shipping`;
CREATE TABLE `hanchao_shipping` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `shop_id` int(11) NOT NULL COMMENT '店铺id',
  `code` varchar(20) NOT NULL COMMENT '配送方式的字符串代号',
  `name` varchar(120) NOT NULL COMMENT '配送方式名字',
  `code_fee` decimal(10,2) NOT NULL COMMENT '配送费用',
  `content` varchar(255) NOT NULL COMMENT '描述',
  `sort` smallint(5) NOT NULL DEFAULT '10' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '0' COMMENT '该配送方式是否被禁用',
  `is_ping` tinyint(1) NOT NULL COMMENT '该配送方式是否为平台默认',
  `insure` varchar(10) NOT NULL COMMENT '保价',
  `support_cod` tinyint(1) NOT NULL COMMENT '支持货到付款',
  `enabled` tinyint(1) NOT NULL COMMENT '暂无（备用字段）',
  `shipping_print` text NOT NULL COMMENT '代码模式',
  `print_bg` varchar(255) NOT NULL COMMENT '打印配送背景图',
  `config_lable` text NOT NULL COMMENT '所见即所得模式',
  `print_model` tinyint(1) NOT NULL COMMENT '模板模式（1代码模式，2所见即所得模式）',
  `shipping_order` tinyint(3) NOT NULL COMMENT '配送订单',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=52 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='配送方式表';

INSERT INTO `hanchao_shipping` (`id`, `shop_id`, `code`, `name`, `code_fee`, `content`, `sort`, `status`, `is_ping`, `insure`, `support_cod`, `enabled`, `shipping_print`, `print_bg`, `config_lable`, `print_model`, `shipping_order`) VALUES
(2,	46,	'huitongkuaidi',	'百世汇通',	0.00,	'',	10,	1,	0,	'',	0,	0,	'',	'/Public/images/receipt/dly_bs.jpg',	't_shop_address,店铺-地址,343,52,74,196,b_shop_address||,||t_shop_province,店铺-省份,139,37,153,167,b_shop_province||,||t_shop_city,店铺-城市,126,37,209,167,b_shop_city||,||t_shop_district,店铺-区/县,152,38,265,167,b_shop_district||,||t_shop_name,店铺-名称,184,29,124,136,b_shop_name||,||t_customer_province,收件人-省份,144,39,511,165,b_customer_province||,||t_customer_city,收件人-城市,132,39,582,165,b_customer_city||,||t_customer_district,收件人-区/县,146,42,648,163,b_customer_district||,||t_customer_address,收件人-详细地址,357,45,439,203,b_customer_address||,||t_customer_mobel,收件人-手机,159,25,539,253,b_customer_mobel||,||t_customer_name,收件人-姓名,150,50,491,112,b_customer_name||,||t_order_postscript,备注-订单,150,50,642,389,b_order_postscript||,||',	2,	0),
(3,	27,	'debangwuliu',	'德邦物流',	0.00,	'',	11,	1,	0,	'',	0,	0,	'',	'/Public/images/receipt/dly_db.jpg',	'',	0,	0),
(5,	34,	'shunfeng',	'顺丰',	0.00,	'',	10,	1,	0,	'',	0,	0,	'',	'/Public/images/receipt/dly_sf_express.jpg',	't_shop_tel,店铺-联系电话,150,50,270,226,b_shop_tel||,||t_shop_address,店铺-地址,295,47,70,190,b_shop_address||,||t_shop_province,店铺-省份,150,50,92,164,b_shop_province||,||t_shop_city,店铺-城市,150,50,157,164,b_shop_city||,||t_shop_district,店铺-区/县,150,50,229,166,b_shop_district||,||t_shop_name,店铺-名称,150,50,123,134,b_shop_name||,||t_customer_province,收件人-省份,150,50,99,295,b_customer_province||,||t_customer_city,收件人-城市,150,50,158,295,b_customer_city||,||t_customer_district,收件人-区/县,150,50,217,296,b_customer_district||,||t_customer_address,收件人-详细地址,302,57,67,325,b_customer_address||,||t_customer_mobel,收件人-手机,150,50,241,399,b_customer_mobel||,||t_customer_post,收件人-邮编,150,50,91,392,b_customer_post||,||t_customer_name,收件人-姓名,150,50,241,263,b_customer_name||,||',	2,	0),
(11,	0,	'huitongkuaidi',	'汇通快运',	0.00,	'',	10,	1,	0,	'',	0,	0,	'',	'/Public/images/receipt/dly_hto.jpg',	't_shop_tel,店铺-联系电话,152,26,176,265,b_shop_tel||,||t_shop_province,店铺-省份,136,34,123,179,b_shop_province||,||t_shop_city,店铺-城市,137,34,191,179,b_shop_city||,||t_shop_district,店铺-区/县,147,35,261,178,b_shop_district||,||t_shop_address,店铺-地址,330,47,78,214,b_shop_address||,||t_shop_name,店铺-名称,154,37,123,143,b_shop_name||,||t_customer_name,收件人-姓名,150,50,495,118,b_customer_name||,||t_customer_province,收件人-省份,150,50,482,178,b_customer_province||,||t_customer_city,收件人-城市,150,50,555,178,b_customer_city||,||t_customer_district,收件人-区/县,150,50,628,178,b_customer_district||,||t_customer_address,收件人-详细地址,346,34,435,227,b_customer_address||,||t_customer_tel,收件人-电话,161,30,541,262,b_customer_tel||,||t_year,年-当日日期,98,28,71,404,b_year||,||t_months,月-当日日期,88,28,117,404,b_months||,||t_day,日-当日日期,88,28,139,404,b_day||,||',	2,	0),
(15,	0,	'zhaijisong',	'宅急送',	0.00,	'',	10,	1,	0,	'',	0,	0,	'',	'/Public/images/receipt/dly_zjs.jpg',	't_shop_province,店铺-省份,65,39,253,162,b_shop_province||,||t_shop_city,店铺-城市,57,39,305,162,b_shop_city||,||t_shop_district,店铺-区/县,64,39,358,162,b_shop_district||,||t_shop_name,店铺-名称,100,41,131,161,b_shop_name||,||t_shop_address,店铺-地址,169,37,252,201,b_shop_address||,||t_shop_tel,店铺-联系电话,126,29,253,244,b_shop_tel||,||t_customer_name,收件人-姓名,100,32,130,301,b_customer_name||,||t_customer_province,收件人-省份,74,34,250,300,b_customer_province||,||t_customer_city,收件人-城市,68,35,316,300,b_customer_city||,||t_customer_district,收件人-区/县,50,36,381,300,b_customer_district||,||t_customer_address,收件人-详细地址,180,43,249,336,b_customer_address||,||t_customer_tel,收件人-电话,130,26,103,382,b_customer_tel||,||t_customer_mobel,收件人-手机,155,28,251,381,b_customer_mobel||,||',	2,	0),
(19,	0,	'yunda',	'韵达快运',	0.00,	'',	10,	1,	0,	'',	0,	0,	'',	'/Public/images/receipt/dly_yda.jpg',	't_shop_name,店铺-名称,106,48,142,105,b_shop_name||,||t_shop_province,店铺-省份,150,50,130,158,b_shop_province||,||t_shop_city,店铺-城市,150,50,219,158,b_shop_city||,||t_shop_district,店铺-区/县,150,50,309,158,b_shop_district||,||t_shop_address,店铺-地址,330,40,129,208,b_shop_address||,||t_shop_tel,店铺-联系电话,112,37,174,248,b_shop_tel||,||t_customer_post,收件人-邮编,107,31,735,249,b_customer_post||,||t_customer_name,收件人-姓名,109,47,531,109,b_customer_name||,||t_customer_province,收件人-省份,150,50,518,156,b_customer_province||,||t_customer_city,收件人-城市,150,50,614,156,b_customer_city||,||t_customer_district,收件人-区/县,150,50,696,156,b_customer_district||,||t_customer_address,收件人-详细地址,329,32,517,205,b_customer_address||,||t_customer_tel,收件人-电话,146,44,523,237,b_customer_tel||,||t_year,年-当日日期,86,28,235,423,b_year||,||t_day,日-当日日期,76,28,384,421,b_day||,||t_months,月-当日日期,77,27,309,423,b_months||,||',	2,	0),
(22,	0,	'yuantong',	'圆通速递',	0.00,	'',	10,	1,	0,	'',	0,	0,	'',	'/Public/images/receipt/dly_yto.jpg',	't_shop_province,店铺-省份,126,38,137,161,b_shop_province||,||t_shop_city,店铺-城市,129,40,207,161,b_shop_city||,||t_shop_district,店铺-区/县,129,41,275,161,b_shop_district||,||t_shop_name,店铺-名称,147,51,131,108,b_shop_name||,||t_shop_tel,店铺-联系电话,132,21,154,239,b_shop_tel||,||t_shop_address,店铺-地址,269,39,135,198,b_shop_address||,||t_customer_province,收件人-省份,138,29,486,175,b_customer_province||,||t_customer_city,收件人-城市,149,29,566,175,b_customer_city||,||t_customer_district,收件人-区/县,142,28,649,176,b_customer_district||,||t_customer_tel,收件人-电话,129,50,660,119,b_customer_tel||,||t_customer_post,收件人-邮编,95,30,697,228,b_customer_post||,||t_customer_address,收件人-详细地址,153,42,485,204,b_customer_address||,||t_customer_name,收件人-姓名,97,51,491,122,b_customer_name||,||t_order_no,订单号-订单,197,25,453,90,b_order_no||,||',	2,	0),
(24,	0,	'xinbangwuliu',	'新邦物流',	0.00,	'',	10,	1,	0,	'',	0,	0,	'',	'/Public/images/receipt/dly_xb.jpg',	't_shop_name,店铺-名称,150,50,112,116,b_shop_name||,||t_shop_tel,店铺-联系电话,177,25,323,141,b_shop_tel||,||t_customer_name,收件人-姓名,142,33,351,177,b_customer_name||,||t_customer_tel,收件人-电话,155,25,113,210,b_customer_tel||,||t_customer_province,收件人-省份,95,23,361,212,b_customer_province||,||t_customer_city,收件人-城市,74,23,431,212,b_customer_city||,||t_customer_district,收件人-区/县,120,24,63,235,b_customer_district||,||t_customer_address,收件人-详细地址,318,24,182,235,b_customer_address||,||',	2,	0),
(27,	0,	'guotongkuaidi',	'国通快递',	0.00,	'',	10,	1,	0,	'',	0,	0,	'',	'/Public/images/receipt/dly_gto.jpg',	't_shop_province,店铺-省份,121,27,102,120,b_shop_province||,||t_shop_city,店铺-城市,120,28,215,120,b_shop_city||,||t_shop_district,店铺-区/县,96,30,330,120,b_shop_district||,||t_shop_address,店铺-地址,324,26,101,148,b_shop_address||,||t_shop_name,店铺-名称,150,50,108,179,b_shop_name||,||t_shop_tel,店铺-联系电话,157,29,142,235,b_shop_tel||,||t_customer_province,收件人-省份,123,31,489,121,b_customer_province||,||t_customer_city,收件人-城市,109,31,598,121,b_customer_city||,||t_customer_district,收件人-区/县,123,32,691,121,b_customer_district||,||t_customer_address,收件人-详细地址,326,23,488,152,b_customer_address||,||t_customer_name,收件人-姓名,150,50,504,179,b_customer_name||,||t_customer_tel,收件人-电话,162,23,534,239,b_customer_tel||,||t_order_postscript,备注-订单,142,73,675,379,b_order_postscript||,||t_year,年-当日日期,77,22,46,432,b_year||,||t_months,月-当日日期,68,23,87,432,b_months||,||t_day,日-当日日期,77,22,129,432,b_day||,||',	2,	0),
(28,	0,	'youshuwuliu',	'优速物流',	0.00,	'',	10,	1,	0,	'',	0,	0,	'',	'/Public/images/receipt/dly_ys.jpg',	't_shop_city,店铺-城市,63,21,130,106,b_shop_city||,||t_customer_city,收件人-城市,78,21,418,106,b_customer_city||,||t_customer_address,收件人-详细地址,102,21,374,202,b_customer_address||,||t_shop_name,店铺-名称,65,21,118,161,b_shop_name||,||t_shop_address,店铺-地址,68,21,112,204,b_shop_address||,||t_shop_tel,店铺-联系电话,87,21,214,273,b_shop_tel||,||t_customer_name,收件人-姓名,73,21,369,283,b_customer_name||,||t_customer_mobel,收件人-手机,75,21,482,271,b_customer_mobel||,||t_customer_tel,收件人-电话,80,21,480,297,b_customer_tel||,||',	2,	0),
(29,	0,	'tiantian',	'天天快递',	0.00,	'',	10,	1,	0,	'',	0,	0,	'',	'/Public/images/receipt/dly_ttkd.jpg',	't_shop_city,店铺-城市,61,21,344,117,b_shop_city||,||t_shop_address,店铺-地址,155,46,159,144,b_shop_address||,||t_customer_tel,收件人-电话,111,21,485,216,b_customer_tel||,||t_shop_tel,店铺-联系电话,118,21,127,217,b_shop_tel||,||t_shop_name,店铺-名称,77,21,124,242,b_shop_name||,||t_customer_city,收件人-城市,71,21,497,115,b_customer_city||,||t_customer_address,收件人-详细地址,100,21,510,140,b_customer_address||,||t_customer_name,收件人-姓名,78,21,499,263,b_customer_name||,||t_customer_post,收件人-邮编,71,21,678,192,b_customer_post||,||t_customer_mobel,收件人-手机,77,21,676,220,b_customer_mobel||,||',	2,	0),
(31,	0,	'tiandihuayu',	'天地华宇',	0.00,	'',	10,	1,	0,	'',	0,	0,	'',	'/Public/images/receipt/dly_tdhy.jpg',	't_shop_name,店铺-名称,63,21,130,109,b_shop_name||,||t_customer_province,收件人-省份,73,21,127,247,b_customer_province||,||t_customer_city,收件人-城市,75,21,248,250,b_customer_city||,||t_shop_district,店铺-区/县,67,21,344,128,b_shop_district||,||t_customer_tel,收件人-电话,75,21,245,288,b_customer_tel||,||t_customer_mobel,收件人-手机,73,21,348,288,b_customer_mobel||,||t_customer_name,收件人-姓名,76,21,128,222,b_customer_name||,||t_shop_province,店铺-省份,64,21,131,130,b_shop_province||,||t_shop_city,店铺-城市,60,21,256,128,b_shop_city||,||t_customer_district,收件人-区/县,82,21,333,248,b_customer_district||,||t_shop_tel,店铺-联系电话,87,21,238,177,b_shop_tel||,||',	2,	0),
(34,	0,	'hengluwuliu',	'恒路物流',	0.00,	'',	10,	1,	0,	'',	0,	0,	'',	'/Public/images/receipt/dly_hl.jpg',	't_shop_name,店铺-名称,116,25,137,93,b_shop_name||,||t_shop_tel,店铺-联系电话,126,25,123,118,b_shop_tel||,||t_shop_address,店铺-地址,137,26,110,144,b_shop_address||,||t_customer_name,收件人-姓名,79,21,145,217,b_customer_name||,||t_customer_tel,收件人-电话,74,21,126,242,b_customer_tel||,||t_customer_province,收件人-省份,72,21,85,283,b_customer_province||,||t_customer_city,收件人-城市,70,21,168,274,b_customer_city||,||t_customer_district,收件人-区/县,79,21,244,286,b_customer_district||,||t_customer_address,收件人-详细地址,98,21,341,289,b_customer_address||,||',	2,	0),
(41,	0,	'jinguangsudikuaijian',	'京广速递',	0.00,	'',	10,	1,	0,	'',	0,	0,	'',	'/Public/images/receipt/dly_jg.png',	't_shop_name,店铺-名称,104,28,121,117,b_shop_name||,||t_shop_address,店铺-地址,136,34,123,150,b_shop_address||,||t_shop_tel,店铺-联系电话,96,25,106,214,b_shop_tel||,||t_customer_name,收件人-姓名,81,27,530,118,b_customer_name||,||t_customer_address,收件人-详细地址,130,35,389,147,b_customer_address||,||t_customer_tel,收件人-电话,101,34,370,212,b_customer_tel||,||t_customer_mobel,收件人-手机,112,28,502,213,b_customer_mobel||,||',	2,	0),
(50,	0,	'ems',	'EMS',	0.00,	'',	10,	1,	0,	'',	0,	0,	'',	'/Public/images/receipt/dly_ems.jpg',	't_shop_name,店铺-名称,97,23,141,141,b_shop_name||,||t_shop_tel,店铺-联系电话,121,23,293,140,b_shop_tel||,||t_shop_address,店铺-地址,142,42,119,219,b_shop_address||,||t_customer_name,收件人-姓名,101,22,496,142,b_customer_name||,||t_customer_tel,收件人-电话,104,21,665,142,b_customer_tel||,||t_customer_address,收件人-详细地址,142,40,463,230,b_customer_address||,||t_shop_province,店铺-省份,124,29,145,191,b_shop_province||,||t_shop_city,店铺-城市,130,31,217,191,b_shop_city||,||t_shop_district,店铺-区/县,110,33,287,190,b_shop_district||,||t_customer_province,收件人-省份,134,36,499,195,b_customer_province||,||t_customer_city,收件人-城市,146,36,580,196,b_customer_city||,||t_customer_district,收件人-区/县,123,35,663,197,b_customer_district||,||t_order_postscript,备注-订单,204,30,488,404,b_order_postscript||,||t_year,年-当日日期,143,28,444,374,b_year||,||t_months,月-当日日期,152,29,522,373,b_months||,||t_day,日-当日日期,146,31,619,372,b_day||,||',	2,	0),
(51,	0,	'zhongtong',	'中通速递',	0.00,	'',	10,	1,	0,	'',	0,	0,	'',	'/Public/images/receipt/dly_zto.jpg',	't_shop_district,店铺-区/县,128,27,308,123,b_shop_district||,||t_shop_name,店铺-名称,105,33,152,124,b_shop_name||,||t_shop_address,店铺-地址,149,29,163,161,b_shop_address||,||t_shop_tel,店铺-联系电话,124,23,154,280,b_shop_tel||,||t_customer_name,收件人-姓名,117,29,535,125,b_customer_name||,||t_customer_city,收件人-城市,105,31,718,124,b_customer_city||,||t_customer_address,收件人-详细地址,127,32,542,160,b_customer_address||,||t_customer_tel,收件人-电话,136,26,531,281,b_customer_tel||,||t_customer_post,收件人-邮编,107,29,715,279,b_customer_post||,||',	2,	0);

DROP TABLE IF EXISTS `hanchao_shipping_fee`;
CREATE TABLE `hanchao_shipping_fee` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `name` varchar(150) NOT NULL DEFAULT '' COMMENT '配送区域名称',
  `shop_id` tinyint(3) unsigned NOT NULL DEFAULT '0' COMMENT '店铺id',
  `configure` text NOT NULL COMMENT '运费规则，type：1按重量，type：2按商品件数',
  `area_region` varchar(155) NOT NULL COMMENT '配送区域id',
  PRIMARY KEY (`id`),
  KEY `shipping_id` (`shop_id`)
) ENGINE=InnoDB AUTO_INCREMENT=43 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='配送费用表';

INSERT INTO `hanchao_shipping_fee` (`id`, `name`, `shop_id`, `configure`, `area_region`) VALUES
(2,	'石家庄桥西区',	1,	'a:3:{s:4:\"type\";i:2;s:5:\"money\";s:1:\"2\";s:9:\"per_money\";s:2:\"10\";}',	'542'),
(3,	'华北',	0,	'a:6:{s:4:\"type\";s:1:\"1\";s:5:\"money\";s:4:\"1000\";s:12:\"first_weight\";s:3:\"0.1\";s:18:\"first_weight_money\";s:2:\"10\";s:8:\"x_weight\";s:3:\"0.1\";s:14:\"x_weight_money\";s:1:\"5\";}',	'6,55,2,3,4'),
(5,	'河北省',	7,	'a:3:{s:4:\"type\";i:2;s:5:\"money\";s:3:\"100\";s:9:\"per_money\";s:2:\"10\";}',	'542,130'),
(7,	'河北',	8,	'a:6:{s:4:\"type\";i:1;s:5:\"money\";s:2:\"50\";s:12:\"first_weight\";s:4:\"1000\";s:18:\"first_weight_money\";s:2:\"30\";s:8:\"x_weight\";s:1:\"5\";s:14:\"x_weight_money\";s:2:\"10\";}',	'130,131,134,2,6'),
(8,	'上海',	8,	'a:3:{s:4:\"type\";i:2;s:5:\"money\";s:2:\"50\";s:9:\"per_money\";s:3:\"100\";}',	'3'),
(9,	'sf',	6,	'a:6:{s:4:\"type\";i:1;s:5:\"money\";s:2:\"12\";s:12:\"first_weight\";s:2:\"12\";s:18:\"first_weight_money\";s:2:\"12\";s:8:\"x_weight\";s:2:\"12\";s:14:\"x_weight_money\";s:2:\"12\";}',	'542'),
(10,	'桥东配送',	3,	'a:3:{s:4:\"type\";i:2;s:5:\"money\";s:2:\"10\";s:9:\"per_money\";s:1:\"2\";}',	'541'),
(11,	'河北省石家庄市',	13,	'a:3:{s:4:\"type\";i:2;s:5:\"money\";s:1:\"1\";s:9:\"per_money\";s:1:\"0\";}',	'542'),
(16,	'石家庄',	9,	'a:3:{s:4:\"type\";i:2;s:5:\"money\";s:4:\"1000\";s:9:\"per_money\";s:4:\"1000\";}',	'6'),
(17,	'',	16,	'a:6:{s:4:\"type\";i:1;s:5:\"money\";s:0:\"\";s:12:\"first_weight\";s:0:\"\";s:18:\"first_weight_money\";s:0:\"\";s:8:\"x_weight\";s:0:\"\";s:14:\"x_weight_money\";s:0:\"\";}',	'6'),
(18,	'gg',	18,	'a:6:{s:4:\"type\";i:1;s:5:\"money\";s:2:\"12\";s:12:\"first_weight\";s:2:\"10\";s:18:\"first_weight_money\";s:1:\"1\";s:8:\"x_weight\";s:2:\"10\";s:14:\"x_weight_money\";s:0:\"\";}',	'542'),
(19,	'河北配送',	17,	'a:6:{s:4:\"type\";i:1;s:5:\"money\";s:1:\"0\";s:12:\"first_weight\";s:1:\"0\";s:18:\"first_weight_money\";s:1:\"0\";s:8:\"x_weight\";s:1:\"0\";s:14:\"x_weight_money\";s:1:\"0\";}',	'6'),
(20,	'',	13,	'a:3:{s:4:\"type\";i:2;s:5:\"money\";s:1:\"2\";s:9:\"per_money\";s:1:\"5\";}',	'542'),
(21,	'',	15,	'a:6:{s:4:\"type\";i:1;s:5:\"money\";s:0:\"\";s:12:\"first_weight\";s:0:\"\";s:18:\"first_weight_money\";s:0:\"\";s:8:\"x_weight\";s:0:\"\";s:14:\"x_weight_money\";s:0:\"\";}',	'6,2,4'),
(22,	'测测',	10,	'a:6:{s:4:\"type\";i:1;s:5:\"money\";s:2:\"10\";s:12:\"first_weight\";s:2:\"10\";s:18:\"first_weight_money\";s:2:\"10\";s:8:\"x_weight\";s:2:\"10\";s:14:\"x_weight_money\";s:2:\"10\";}',	'2'),
(23,	'222221',	10,	'a:5:{s:4:\"type\";s:1:\"2\";s:5:\"money\";s:3:\"666\";s:9:\"per_money\";s:2:\"77\";s:8:\"x_weight\";s:0:\"\";s:14:\"x_weight_money\";s:0:\"\";}',	'3'),
(24,	'河北配送',	31,	'a:6:{s:4:\"type\";i:1;s:5:\"money\";s:4:\"1000\";s:12:\"first_weight\";s:1:\"1\";s:18:\"first_weight_money\";s:1:\"5\";s:8:\"x_weight\";s:1:\"1\";s:14:\"x_weight_money\";s:2:\"10\";}',	'6'),
(25,	'石家庄桥西区',	34,	'a:5:{s:4:\"type\";i:2;s:5:\"money\";s:3:\"2.2\";s:9:\"per_money\";s:2:\"12\";s:8:\"x_weight\";s:2:\"11\";s:14:\"x_weight_money\";s:2:\"22\";}',	'542'),
(26,	'桥西区',	35,	'a:6:{s:4:\"type\";i:1;s:5:\"money\";s:3:\"100\";s:12:\"first_weight\";s:1:\"1\";s:18:\"first_weight_money\";s:1:\"1\";s:8:\"x_weight\";s:0:\"\";s:14:\"x_weight_money\";s:0:\"\";}',	'542'),
(27,	'桥东',	35,	'a:5:{s:4:\"type\";i:2;s:5:\"money\";s:3:\"100\";s:9:\"per_money\";s:2:\"10\";s:8:\"x_weight\";s:0:\"\";s:14:\"x_weight_money\";s:0:\"\";}',	'541'),
(29,	'河北省',	38,	'a:5:{s:4:\"type\";i:2;s:5:\"money\";s:3:\"100\";s:9:\"per_money\";s:2:\"10\";s:8:\"x_weight\";s:1:\"1\";s:14:\"x_weight_money\";s:1:\"5\";}',	'6'),
(30,	'华北地区',	40,	'a:5:{s:4:\"type\";i:2;s:5:\"money\";s:3:\"100\";s:9:\"per_money\";s:2:\"10\";s:8:\"x_weight\";s:1:\"1\";s:14:\"x_weight_money\";s:2:\"15\";}',	'6,130'),
(31,	'华北地区',	44,	'a:6:{s:4:\"type\";i:1;s:5:\"money\";s:4:\"1000\";s:12:\"first_weight\";s:3:\"0.1\";s:18:\"first_weight_money\";s:2:\"10\";s:8:\"x_weight\";s:3:\"0.1\";s:14:\"x_weight_money\";s:1:\"5\";}',	'6,2,4,7,8'),
(37,	'七匹狼衬衫',	48,	'a:5:{s:4:\"type\";i:2;s:5:\"money\";s:2:\"50\";s:9:\"per_money\";s:2:\"50\";s:8:\"x_weight\";s:1:\"1\";s:14:\"x_weight_money\";s:1:\"1\";}',	'201,1235'),
(38,	'浙江上虞',	43,	'a:6:{s:4:\"type\";i:1;s:5:\"money\";s:1:\"0\";s:12:\"first_weight\";s:1:\"6\";s:18:\"first_weight_money\";s:1:\"5\";s:8:\"x_weight\";s:1:\"1\";s:14:\"x_weight_money\";s:1:\"1\";}',	'1379'),
(39,	'中国',	46,	'a:6:{s:4:\"type\";i:1;s:5:\"money\";s:2:\"10\";s:12:\"first_weight\";s:1:\"5\";s:18:\"first_weight_money\";s:2:\"10\";s:8:\"x_weight\";s:1:\"1\";s:14:\"x_weight_money\";s:1:\"5\";}',	'1379,1378,1375,1376,1380'),
(40,	'试一下哦',	48,	'a:5:{s:4:\"type\";i:2;s:5:\"money\";s:2:\"60\";s:9:\"per_money\";s:2:\"10\";s:8:\"x_weight\";s:1:\"5\";s:14:\"x_weight_money\";s:1:\"1\";}',	'1379'),
(41,	'浙江省绍兴市上虞区',	48,	'a:5:{s:4:\"type\";i:2;s:5:\"money\";s:3:\"0.1\";s:9:\"per_money\";s:1:\"1\";s:8:\"x_weight\";s:1:\"1\";s:14:\"x_weight_money\";s:1:\"1\";}',	'1379'),
(42,	'河北',	49,	'a:5:{s:4:\"type\";i:2;s:5:\"money\";s:3:\"100\";s:9:\"per_money\";s:2:\"10\";s:8:\"x_weight\";s:1:\"1\";s:14:\"x_weight_money\";s:1:\"1\";}',	'6');

DROP TABLE IF EXISTS `hanchao_shop_cate_link`;
CREATE TABLE `hanchao_shop_cate_link` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `shop_id` int(11) NOT NULL COMMENT '店铺id',
  `cat_id` int(11) NOT NULL COMMENT '商品一级分类id',
  `brand_id` int(11) NOT NULL COMMENT '品牌id',
  `brand_cat_id` int(11) NOT NULL COMMENT '品牌一级id',
  `type` tinyint(1) NOT NULL COMMENT '1品牌2商品3新增品牌',
  `status` tinyint(1) NOT NULL COMMENT '1申请2通过3拒绝4申请退出5已退出',
  `remark` varchar(255) NOT NULL COMMENT '备注',
  `addtime` int(10) NOT NULL COMMENT '添加时间',
  `update_time` int(10) NOT NULL COMMENT '更新时间',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=183 DEFAULT CHARSET=utf8 COMMENT='店铺分类链接表';

INSERT INTO `hanchao_shop_cate_link` (`id`, `shop_id`, `cat_id`, `brand_id`, `brand_cat_id`, `type`, `status`, `remark`, `addtime`, `update_time`) VALUES
(79,	7,	7,	0,	0,	2,	2,	'',	1495004722,	1495004722),
(80,	7,	4,	0,	0,	2,	2,	'',	1495004731,	1495004731),
(81,	7,	115,	0,	0,	2,	2,	'',	1495005406,	1495005406),
(82,	7,	149,	0,	0,	2,	2,	'',	1495006064,	1495006064),
(83,	7,	150,	0,	0,	2,	2,	'',	1495007229,	1495007229),
(84,	7,	0,	24,	0,	1,	2,	'',	1495007963,	1495007963),
(85,	7,	14,	0,	0,	2,	2,	'',	1495012820,	1495012820),
(86,	7,	3,	0,	0,	2,	2,	'',	1495088873,	1495088873),
(87,	7,	151,	0,	0,	2,	2,	'',	1495089218,	1495089218),
(88,	7,	5,	0,	0,	2,	2,	'',	1495164018,	1495164018),
(105,	38,	1,	0,	0,	2,	2,	'',	1501730962,	1501730962),
(106,	38,	153,	0,	0,	2,	2,	'',	1501738320,	1501738281),
(107,	38,	0,	43,	0,	1,	2,	'',	1501744832,	1501744832),
(108,	38,	0,	44,	0,	1,	2,	'',	1501745632,	1501745632),
(109,	38,	0,	45,	0,	1,	2,	'',	1501749386,	1501749386),
(110,	38,	0,	46,	0,	1,	2,	'',	1501826050,	1501826050),
(111,	38,	115,	0,	0,	2,	2,	'',	1501835928,	1501835928),
(112,	39,	1,	0,	0,	2,	1,	'',	1502070819,	1502070819),
(113,	39,	3,	0,	0,	2,	1,	'',	1502070819,	1502070819),
(114,	39,	5,	0,	0,	2,	1,	'',	1502070819,	1502070819),
(115,	39,	7,	0,	0,	2,	1,	'',	1502070819,	1502070819),
(116,	39,	115,	0,	0,	2,	1,	'',	1502070819,	1502070819),
(117,	39,	153,	0,	0,	2,	1,	'',	1502070819,	1502070819),
(118,	40,	1,	0,	0,	2,	2,	'',	1502070819,	1502070819),
(119,	40,	3,	0,	0,	2,	2,	'',	1502070819,	1502070819),
(120,	40,	5,	0,	0,	2,	2,	'',	1502070819,	1502070819),
(121,	40,	7,	0,	0,	2,	2,	'',	1502070819,	1502070819),
(122,	40,	115,	0,	0,	2,	2,	'',	1502070819,	1502070819),
(123,	40,	153,	0,	0,	2,	2,	'',	1502070819,	1502070819),
(124,	40,	147,	0,	0,	2,	2,	'',	1502071867,	1502071867),
(125,	40,	2,	0,	0,	2,	2,	'',	1502071870,	1502071870),
(127,	38,	0,	47,	0,	1,	2,	'',	1502073957,	1502073957),
(128,	43,	153,	0,	0,	2,	2,	'',	1502089278,	1502089278),
(129,	44,	1,	0,	0,	2,	2,	'',	1502089925,	1502089925),
(130,	44,	153,	0,	0,	2,	2,	'',	1502089925,	1502089925),
(131,	43,	115,	0,	0,	2,	2,	'',	1502089928,	1502089928),
(132,	44,	2,	0,	0,	2,	1,	'',	1502090335,	1502090335),
(133,	44,	3,	0,	0,	2,	2,	'',	1502090337,	1502090337),
(134,	44,	5,	0,	0,	2,	2,	'',	1502090340,	1502090340),
(135,	44,	7,	0,	0,	2,	2,	'',	1502090342,	1502090342),
(136,	44,	115,	0,	0,	2,	2,	'',	1502090346,	1502090346),
(137,	44,	147,	0,	0,	2,	2,	'',	1502090348,	1502090348),
(139,	44,	0,	47,	0,	1,	2,	'所申请品牌与经营范围不符',	1502092103,	1502265053),
(140,	44,	0,	48,	0,	1,	2,	'',	1502092220,	1502092220),
(141,	43,	0,	49,	0,	3,	0,	'',	1502095860,	1502095860),
(142,	43,	0,	49,	0,	1,	2,	'',	1502096460,	1502157122),
(143,	43,	0,	50,	0,	3,	0,	'',	1502157393,	1502157393),
(144,	43,	0,	50,	0,	1,	2,	'',	1502157410,	1502157410),
(145,	43,	0,	39,	0,	1,	2,	'品牌不符',	1502161125,	1502161208),
(146,	40,	0,	45,	0,	1,	2,	'',	1502161778,	1502161778),
(151,	43,	3,	0,	0,	2,	2,	'',	1502867345,	1502867345),
(152,	44,	0,	49,	0,	1,	2,	'',	1502940135,	1502940135),
(153,	46,	1,	0,	0,	2,	2,	'',	1503119165,	1503119165),
(157,	48,	153,	0,	0,	2,	2,	'',	1503128572,	1503128572),
(158,	48,	115,	0,	0,	2,	2,	'',	1503128575,	1503128575),
(159,	48,	7,	0,	0,	2,	2,	'',	1503128576,	1503128576),
(161,	48,	0,	52,	0,	3,	0,	'',	1503129413,	1503129413),
(162,	46,	0,	41,	0,	1,	2,	'',	1503129857,	1503129857),
(163,	46,	0,	48,	0,	1,	2,	'',	1503129866,	1503129866),
(164,	47,	153,	0,	0,	2,	2,	'',	1503130702,	1503130702),
(165,	47,	1,	0,	0,	2,	2,	'',	1503130705,	1503130705),
(166,	47,	2,	0,	0,	2,	2,	'',	1503130710,	1503130710),
(167,	47,	3,	0,	0,	2,	2,	'',	1503130716,	1503130716),
(169,	46,	2,	0,	0,	2,	2,	'',	1503393392,	1503393392),
(170,	46,	5,	0,	0,	2,	2,	'',	1503393474,	1503393474),
(171,	49,	1,	0,	0,	2,	2,	'',	1504677089,	1504677089),
(172,	49,	3,	0,	0,	2,	2,	'',	1504677089,	1504677089),
(173,	49,	5,	0,	0,	2,	2,	'',	1504677089,	1504677089),
(174,	49,	7,	0,	0,	2,	2,	'',	1504677089,	1504677089),
(175,	49,	115,	0,	0,	2,	2,	'',	1504677089,	1504677089),
(176,	49,	153,	0,	0,	2,	2,	'',	1504677089,	1504677089),
(177,	49,	0,	54,	0,	1,	2,	'',	1504682696,	1504682696),
(178,	49,	0,	55,	0,	1,	2,	'',	1504682889,	1504682889),
(179,	49,	0,	56,	0,	1,	2,	'',	1504683012,	1504683012),
(181,	49,	147,	0,	0,	2,	2,	'',	1504683334,	1504683334),
(182,	49,	2,	0,	0,	2,	3,	'拒绝',	1504683474,	1504683474);

DROP TABLE IF EXISTS `hanchao_shopbalance_log`;
CREATE TABLE `hanchao_shopbalance_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '主键索引',
  `shop_id` int(10) NOT NULL COMMENT '店铺id',
  `order_id` int(10) NOT NULL COMMENT '订单id',
  `change_type` tinyint(2) NOT NULL COMMENT '0：加，1：减',
  `change_num` decimal(10,2) NOT NULL COMMENT '变更数量',
  `end_num` decimal(10,2) NOT NULL COMMENT '变动后数量',
  `change_desc` varchar(200) NOT NULL COMMENT '变更描述',
  `change_time` int(10) NOT NULL COMMENT '变更时间',
  `type` tinyint(2) NOT NULL COMMENT '1营业总额2未结算3待结算,4冻结5:deduct_price代扣服务费,6,店铺销售额',
  `status` tinyint(2) NOT NULL COMMENT '操作类型，1为充值，2为提现，3为订单结算，4为系统结算',
  `adminid` int(10) NOT NULL COMMENT '管理员ID',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='商铺账户变更日志';


DROP TABLE IF EXISTS `hanchao_shops`;
CREATE TABLE `hanchao_shops` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '商铺ID',
  `uid` int(10) NOT NULL COMMENT '会员id',
  `name` varchar(255) NOT NULL COMMENT '会员名称',
  `password` varchar(32) NOT NULL COMMENT '密码',
  `salt` char(10) NOT NULL COMMENT '干扰码',
  `contacts` varchar(20) NOT NULL COMMENT '联系人姓名',
  `phone` varchar(20) NOT NULL COMMENT '商铺电话',
  `contacts_phone` varchar(20) NOT NULL COMMENT '联系人电话',
  `qq` int(16) NOT NULL COMMENT '商铺QQ',
  `weixin` varchar(32) NOT NULL COMMENT '商铺微信',
  `postion` varchar(255) NOT NULL COMMENT '店铺的省,市,区,镇,乡',
  `address` varchar(100) NOT NULL COMMENT '商铺联系地址',
  `thumb` varchar(100) NOT NULL COMMENT '商铺图片(logo)',
  `thumb_img` varchar(100) NOT NULL COMMENT '商铺图片(头像)',
  `content` text NOT NULL COMMENT '店铺详情',
  `updatetime` int(10) unsigned NOT NULL COMMENT '添加时间',
  `sort` smallint(5) NOT NULL DEFAULT '10' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '状态',
  `total_revenues` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '营业总额',
  `sale_total_money` decimal(10,2) NOT NULL COMMENT '销售总额',
  `unbalance` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '未结算（已付款，未确认收货）',
  `onbalance` decimal(10,2) NOT NULL DEFAULT '0.00' COMMENT '待结算（已付款，已确认收货）',
  `rank` int(10) NOT NULL COMMENT '店铺等级（取label类型为2的字段）',
  `deduct_price` decimal(10,2) NOT NULL COMMENT '待扣服务费',
  `freeze_price` decimal(10,2) NOT NULL COMMENT '店铺的冻结资金',
  `end_time` int(10) NOT NULL COMMENT '店铺等级结束时间',
  `point` varchar(255) NOT NULL COMMENT '店铺的x,y坐标',
  `catids` varchar(255) NOT NULL COMMENT '店铺绑定的类目',
  `employee_count` int(10) NOT NULL COMMENT '员工总数',
  `registered_capital` int(10) NOT NULL COMMENT '注册资金',
  `email` varchar(60) NOT NULL COMMENT '电子邮箱',
  `business_licence_number` varchar(60) NOT NULL COMMENT '营业执照号',
  `licence_start` int(10) unsigned NOT NULL COMMENT '营业执照有效期',
  `licence_end` int(10) unsigned NOT NULL COMMENT '营业执照有效期',
  `business_sphere` text NOT NULL COMMENT '法定经营范围',
  `licence_address` varchar(255) NOT NULL COMMENT '营业执照所在地 ',
  `business_licence_img` varchar(100) NOT NULL COMMENT '营业执照电子版',
  `general_taxpayer` varchar(100) NOT NULL COMMENT '一般纳税人证明',
  `organization_code` varchar(100) NOT NULL COMMENT '组织机构代码',
  `organization_code_img` varchar(100) NOT NULL COMMENT '组织机构代码证',
  `cate_ids` varchar(100) NOT NULL COMMENT '经营种类',
  `dp_count_1` int(10) NOT NULL COMMENT '差评数',
  `dp_count_2` int(10) NOT NULL COMMENT '中评数',
  `dp_count_3` int(10) NOT NULL COMMENT '好评数',
  `dp_count` int(10) NOT NULL COMMENT '总评数',
  `login_count` int(10) NOT NULL COMMENT '登录次数 ',
  `last_ip` bigint(15) NOT NULL COMMENT '最后一次登录IP',
  `last_login` int(10) NOT NULL COMMENT '最后一次登录时间',
  `end_date` int(10) NOT NULL COMMENT '提现账期/天',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=50 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='商铺表';

INSERT INTO `hanchao_shops` (`id`, `uid`, `name`, `password`, `salt`, `contacts`, `phone`, `contacts_phone`, `qq`, `weixin`, `postion`, `address`, `thumb`, `thumb_img`, `content`, `updatetime`, `sort`, `status`, `total_revenues`, `sale_total_money`, `unbalance`, `onbalance`, `rank`, `deduct_price`, `freeze_price`, `end_time`, `point`, `catids`, `employee_count`, `registered_capital`, `email`, `business_licence_number`, `licence_start`, `licence_end`, `business_sphere`, `licence_address`, `business_licence_img`, `general_taxpayer`, `organization_code`, `organization_code_img`, `cate_ids`, `dp_count_1`, `dp_count_2`, `dp_count_3`, `dp_count`, `login_count`, `last_ip`, `last_login`, `end_date`) VALUES
(1,	24,	'喵星人旗舰店',	'd8342402c6d27413183c1cb62bc6c2db',	'n4uzdf',	'冯小宝',	'0311-8556521',	'15533961491',	0,	'',	'6,130,541',	'河北省石家庄市桥东区万达广场B座',	'',	'',	'',	1494208458,	10,	0,	0.00,	0.00,	0.00,	0.00,	0,	0.00,	0.00,	0,	'116.636067,21.4',	'',	100,	1000,	'fengxb@qq.com',	'440301103072002',	1489334400,	1657641600,	'数码电器',	'河北省石家庄市',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/58eecde4e6a22.jpg',	'L1832212-3',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/58eecda6e91ff.jpg',	'5',	1,	0,	1,	2,	3,	3739204329,	1499759659,	0),
(2,	7,	'天兴欣业家居专营店',	'd8342402c6d27413183c1cb62bc6c2db',	'n4uzdf',	'董小姐',	'400-610-1360转686168',	'13000000000',	0,	'',	'2,3360,36',	'红旗街234号',	'',	'',	'',	1492045710,	10,	0,	9.00,	0.00,	0.00,	0.00,	0,	9.00,	-9.00,	0,	'',	'',	50,	50,	'13000000000@139.com',	'fr55gerg4r5de5ve',	1491926400,	1523462400,	'家庭清洁类',	'北京派出所',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/58eece5bdeab9.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/58eecf5b59924.jpg',	'fewe656',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/58eecf30651dc.jpg',	'3',	0,	0,	0,	0,	4,	3739204329,	1494064731,	0),
(3,	5,	'小常股份有限公司',	'',	'',	'小常',	'13331202938',	'13331202938',	879602797,	'',	'6,130,541,,',	'一江大厦整栋',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170428/5902b6ee8766e.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170428/5902a8cf898fd.jpg',	'',	1499762801,	10,	0,	1000.00,	0.00,	1000.00,	0.00,	0,	9.00,	0.00,	0,	',',	'',	100,	100,	'13331202938@126.com',	'110120119',	1970,	1970,	'各种都有',	'石家庄',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/58eecf91392c9.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/58eecfb7d00f3.jpg',	'0312',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/58eecfa87cca6.jpg',	'1,2,3,4,5,6,7',	2,	2,	3,	7,	19,	3739204329,	1496372935,	0),
(4,	1,	'久途测试店铺',	'd8342402c6d27413183c1cb62bc6c2db',	'n4uzdf',	'测试',	'13012332114',	'13013012121',	0,	'',	'6,130,542',	'一江国际',	'',	'',	'',	1492049221,	10,	0,	0.00,	0.00,	0.00,	0.00,	0,	0.00,	0.00,	0,	'',	'',	10,	100,	'app@hanchao9999.com',	'123',	1492012800,	1493827200,	'电器',	'石家庄',	'',	'',	'123',	'',	'5',	0,	0,	0,	0,	6,	3739204329,	1494923577,	0),
(5,	6,	'喵星人',	'd8342402c6d27413183c1cb62bc6c2db',	'n4uzdf',	'冯小宝',	'0311-8556521',	'15533961491',	0,	'',	'6,130,541',	'河北省石家庄市桥东区万达广场B座',	'',	'',	'',	1492583599,	10,	0,	0.00,	0.00,	0.00,	0.00,	0,	0.00,	0.00,	0,	'',	'',	100,	1000,	'fengxb@qq.com',	'440301103072002',	1489334580,	1657642020,	'数码电器',	'河北省石家庄市',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/58eedae381954.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/58eecde4e6a22.jpg',	'L1832212-3',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170413/58eecda6e91ff.jpg',	'5',	0,	0,	0,	0,	0,	0,	0,	0),
(6,	27,	'柯锐达商城',	'd8342402c6d27413183c1cb62bc6c2db',	'n4uzdf',	'久途',	'18830102889',	'',	12345,	'',	'',	'中华南大街',	'',	'',	'',	1493185777,	10,	0,	9.00,	0.00,	0.00,	0.00,	0,	0.00,	-18.00,	0,	'',	'',	0,	0,	'',	'',	0,	0,	'',	'',	'',	'',	'',	'',	'',	0,	0,	0,	0,	19,	3739204329,	1501549501,	0),
(7,	29,	'石家庄汉潮体育用品销售有限公司',	'd8342402c6d27413183c1cb62bc6c2db',	'n4uzdf',	'汉潮',	'400-0311-340',	'15888888888',	305711819,	'szy305711819',	'6,130,542',	'河北省石家庄市长安区光华路175号',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170712/5965dbdf7caba.png',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170712/5965dbe6092f8.png',	'',	1501306712,	10,	0,	1301.60,	0.00,	-290.36,	0.00,	0,	100.00,	0.00,	0,	'114.529615,38.064893',	'',	100,	500,	'30578888@qq.com',	'91130104336191111X',	1488297780,	1645977720,	'体育用品及器械、文具用品、日用百货、服装鞋帽的批发及零售，投资咨询（期货、金融、证券、教育咨询除外），企业形象策划，房屋出租。（依法须经批准的项目，经相关部门批准后方可开展经营活动）',	'河北省石家庄市桥西区中华南大街18号保艺大厦裙楼4层',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170424/58fd8f7f57f67.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170424/58fd8fd60d6f2.jpg',	'91130104336191111X',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170424/58fd8fae894e4.jpg',	'1,7,4,115,149,150,14,3,151,5',	1,	0,	2,	3,	59,	3739204329,	1501306029,	0),
(8,	73,	'手机维修',	'199d21a52931ce1b2d52a3bf6fefe480',	'jfd1ts',	'小兴兴',	'15833935130',	'15533225512',	0,	'23',	'6,130,542',	'河北省石家庄市桥西区长青路8',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170511/59142a30912d8.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170511/59142a401d913.png',	'',	1499676623,	10,	0,	5111.82,	0.00,	17940.21,	0.00,	1,	0.00,	0.00,	1628585452,	'114.512815,38.069936',	'',	3,	200,	'12345@163.com',	'yy123456',	1456761780,	1488902580,	'手机专卖，手机维修',	'石家庄',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170426/59001534c7c74.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170426/5900155f1af91.png',	'zz123456',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170426/5900154cd579f.jpg',	'5',	2,	1,	2,	5,	10,	3739204329,	1494492348,	0),
(9,	43,	'久途网络',	'd8342402c6d27413183c1cb62bc6c2db',	'n4uzdf',	'齐女士',	'18332411983',	'18332411983',	364266627,	'364266627',	'6,130,542',	'石家庄市桥西区一江国际大厦',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170720/59701ee110018.png',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170720/59701ed498d05.jpg',	'',	1500520022,	10,	0,	1794.00,	0.00,	393.90,	0.00,	0,	0.00,	0.00,	0,	',',	'',	50,	500,	'1505293842@qq.com',	'91130104582442852U',	1316448540,	1947514140,	'计算机软件',	'石家庄',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170426/5900464450f83.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170426/5900465754a6e.jpg',	'91130104582442852U',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170426/5900464f2d6ad.jpg',	'1,2,115',	4,	1,	3,	8,	14,	3739204329,	1500702988,	0),
(10,	42,	'小店铺',	'e5dedfd6f7cd570cbbb86a9d31bba797',	'x65gck',	'赵',	'15032233578',	'15032233578',	1234555,	'111111',	'6,130,541',	'北京市东城区北池子大街72号',	'',	'',	'',	1499741114,	10,	0,	9956.01,	0.00,	0.00,	0.00,	0,	0.00,	-1000.00,	0,	'116.409365,39.92349',	'',	12000,	15000,	'1354@qq.com',	'10-4515-111',	1493136000,	1524672000,	'',	'保定新市区',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170426/59003a0daae24.jpg',	'',	'daima',	'',	'1,3',	0,	0,	0,	0,	45,	3739204329,	1495183756,	3),
(12,	41,	'桥东烟酒专卖',	'19575ab9f03778901a8497b5c54114cf',	'cf5shj',	'赵',	'15032233546',	'',	33333,	'2222',	'',	'的',	'',	'',	'',	1493259754,	10,	0,	0.00,	0.00,	0.00,	0.00,	0,	0.00,	0.00,	0,	'',	'',	0,	0,	'',	'',	0,	0,	'',	'',	'',	'',	'',	'',	'',	0,	0,	0,	0,	2,	3739204329,	1493286056,	0),
(13,	39,	'石家庄久途网络科技有限公司',	'',	'3e486a',	'赵丽',	'15227189576',	'15227189576',	0,	'',	'6,130,542',	'石家庄市桥西区一江国际大厦',	'',	'',	'',	1493260842,	10,	0,	10.62,	0.00,	21.83,	0.00,	0,	0.00,	0.00,	0,	'',	'',	5,	50,	'937539210@qq.com',	'91130104582442852',	0,	0,	'',	'',	'',	'',	'',	'',	'115',	1,	0,	0,	1,	5,	3739204329,	1494039565,	0),
(14,	45,	'宗周',	'8db3da79c5e8d0d64721d548427f3013',	'iwnekv',	'温',	'13756502795',	'',	0,	'',	'',	'河北省石家庄市桥东区槐北路',	'',	'',	'',	1493286250,	10,	0,	0.00,	0.00,	0.00,	0.00,	0,	0.00,	0.00,	0,	'',	'',	0,	0,	'',	'',	0,	0,	'',	'',	'',	'',	'',	'',	'',	0,	0,	0,	0,	1,	3739204329,	1494061910,	0),
(15,	36,	'石家庄久途测试公司',	'08d68654fb456de72662309046af50c2',	'1vwij6',	'刘敬蕾',	'13832366058',	'',	362674820,	'13832366058',	'',	'石家庄市桥西区国大36524便利店',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170428/5902dbf18e858.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170428/5902dbfc53c93.jpg',	'石家庄久途测试公司狠狠测',	1499657167,	10,	0,	0.00,	0.00,	-74.64,	0.00,	0,	0.00,	0.00,	2147483647,	'114.465479,38.02461',	'',	0,	0,	'',	'',	0,	0,	'',	'',	'',	'',	'',	'',	'1,2',	0,	0,	0,	0,	16,	3739204329,	1501323462,	0),
(16,	53,	'大常零食店',	'',	'',	'大常',	'13331202911',	'13331202911',	0,	'',	'6,130,540',	'五四大街',	'',	'',	'',	1493703611,	10,	0,	0.00,	0.00,	408.00,	0.00,	0,	0.00,	0.00,	0,	'',	'',	50,	50,	'13331202938@126.com',	'123456',	1493654700,	1497024360,	'登山队',	'石家庄',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170502/59081b9aa1bd0.jpg',	'',	'',	'',	'1,2',	0,	0,	0,	0,	6,	3739204329,	1494314139,	0),
(17,	54,	'暧暧',	'',	'',	'暧暧',	'5000004',	'13000000004',	0,	'',	'5,3363,92',	'明海路138号',	'',	'',	'',	1493704661,	10,	0,	0.00,	0.00,	0.00,	0.00,	0,	0.00,	0.00,	0,	'',	'',	50,	50,	'123@qq.com',	'MT345r34542232jijio3',	1493568300,	1525017840,	'多种',	'重庆市公安局',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170502/59081d71434ba.jpg',	'',	'ifjs2Ujfjew',	'',	'2,3,6,7',	0,	0,	0,	0,	15,	3739204329,	1496375071,	0),
(31,	72,	'华丽生活',	'',	'',	'王五',	'18855552217',	'18855552217',	0,	'',	'6,130,542',	'河北省石家庄市桥西区城角街699号',	'',	'',	'',	1494655540,	10,	0,	1479.30,	0.00,	1254.02,	0.00,	1,	0.00,	-9.00,	0,	'114.450688,38.02356',	'',	5,	500,	'123@qq.com',	'445381600190918',	1356998493,	1672531303,	'批发零售',	'石家庄',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170512/59157d56e1a1d.jpg',	'',	'11112222',	'',	'1,5',	3,	0,	3,	6,	46,	3739204329,	1501659664,	5),
(34,	10,	'小旺手机专卖店',	'',	'',	'444',	'15032235461',	'15032233579',	0,	'',	'3,3361,54',	'444',	'',	'',	'',	1494900318,	10,	0,	11.19,	0.00,	-11.19,	0.00,	0,	0.00,	0.00,	0,	'',	'',	10,	10,	'123@qq.com',	'123456789123456789',	1493654700,	1496851560,	'111',	'111',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170502/5908629ad8864.jpg',	'',	'',	'',	'1,5',	0,	0,	0,	0,	30,	2013284040,	1501655878,	0),
(35,	78,	'久途',	'',	'',	'xyy',	'0311-1234567',	'15123456788',	0,	'',	'6,130,542',	'一江大厦',	'',	'',	'',	1499051286,	10,	0,	51945.01,	0.00,	2127.62,	0.00,	0,	0.00,	0.00,	0,	'',	'',	20,	10,	'15123456788@qq.com',	'370214230036945',	1498838820,	1530374820,	'电子，服装，食品',	'河北省',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170703/5959b31faa5b2.jpg',	'',	'',	'',	'28,115,153',	0,	0,	0,	0,	10,	3739204329,	1500448769,	0),
(38,	134,	'河北每天生活超市有限公司',	'',	'',	'宋朝阳',	'18688888888',	'15831995737',	0,	'szy305711819',	'6,130,542',	'一江国际B座底商',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/59894d19a2bd9.png',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170804/598406f15a5f1.png',	'',	1502170285,	10,	1,	1626.92,	4292.14,	4094.64,	0.00,	0,	0.00,	0.00,	0,	',',	'',	50,	500,	'305711819@qq.com',	'911301234567891011a',	1501516800,	2132582400,	'经营保健食品；零售酒、食盐、定型包装食品、散装直接入口食品（含乳冷食品）、粮油制品、熟食制品、鲜肉、水产品、禽蛋、蔬菜、干鲜果品；现场制售：炸烤制品、主食、面包、冷食糕点；加工熟肉制品。',	'河北省石家庄市桥西区一江国际B座底商',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/5982984f7162b.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/59829868182d0.jpg',	'641361311-1',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170803/598298605c0a8.jpg',	'1,153,115',	1,	0,	1,	2,	34,	606819889,	1504849897,	0),
(40,	138,	'河北每天惠连锁超市',	'',	'',	'高先生',	'0311-69019517',	'18000000001',	0,	'97994794',	'6,130,542',	'槐安路与广平街交口南行50米',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/598957689f8bc.png',	'',	'',	1502264125,	10,	1,	1234.60,	6628.00,	-4854.38,	0.00,	0,	0.00,	0.00,	0,	',',	'',	50,	500,	'3387567465@qq.com',	'911130105698785245',	1502035680,	1605802260,	'日用百货销售',	'石家庄',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/5987c797b3b3c.png',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/5987c79f08c36.png',	'',	'',	'1,3,5,7,115,153,147,2',	0,	0,	1,	1,	6,	3739204329,	1502263698,	0),
(43,	139,	'富安娜',	'',	'',	'张先生',	'0311-63025412',	'15633677432',	0,	'15233665541',	'6,130,542',	'友谊大街南二环交口',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/5989516f2cf9a.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170808/5989590441c11.jpg',	'',	1502267190,	10,	1,	1567.20,	1654.10,	2806.10,	0.00,	0,	100.00,	0.00,	0,	',',	'',	3,	200,	'654985@163.com',	'510106000167012',	1489334580,	1647100980,	'家具，家纺，日用品。',	'石家庄',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/59880c1d29257.png',	'',	'',	'',	'153,115,3',	0,	0,	1,	1,	35,	3739204329,	1503568124,	0),
(44,	140,	'河北好实惠生活超市有限公司',	'',	'',	'宋朝阳',	'15066666666',	'15066666666',	0,	'123121',	'6,130,542',	'石家庄市桥西区恒丰大酒店',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/59884a2d88dca.png',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/59884196a7777.png',	'',	1503298399,	10,	1,	681.00,	1176.40,	640.90,	0.00,	0,	0.00,	0.00,	0,	'114.48411,38.024755',	'',	50,	500,	'305711899@qq.com',	'9113012345678911',	1502035680,	2101565280,	'经营保健食品；零售酒、食盐、定型包装食品、散装直接入口食品（含乳冷食品）、粮油制品、熟食制品、鲜肉、水产品、禽蛋、蔬菜、干鲜果品',	'河北省石家庄市桥西区一江国际B座底商',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/598811b78abe8.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/598811cf4aa37.jpg',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170807/598811c84126a.jpg',	'1,153,3,5,7,115,147',	0,	0,	3,	3,	57,	3739204329,	1504680743,	10),
(46,	149,	'黑化肥会挥发',	'',	'',	'甄老板',	'0575-84447734',	'18778776767',	695530274,	'dada695530274',	'',	'惠普广场',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/5997ae362ce2e.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/5997ae5754442.jpg',	'&lt;span style=&quot;color:#333333;font-family:arial, 宋体, sans-serif;font-size:14px;line-height:24px;background-color:#FFFFFF;&quot;&gt;黑化黑灰化肥灰会挥发发灰黑讳为黑灰花会回飞，灰化灰黑化肥灰会挥发发黑灰为讳飞花回化为灰&lt;/span&gt;',	1503275897,	10,	1,	0.00,	0.00,	0.00,	0.00,	0,	150.00,	0.00,	1530843977,	',',	'',	0,	0,	'695530274@qq.com',	'510106000167012',	1970,	1970,	'中国',	'石家庄',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/5997aec9b45e3.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/5997a464353f4.jpg',	'',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/5997a45398750.jpg',	'1,2,5',	0,	0,	0,	0,	12,	3086536017,	1504158593,	0),
(47,	150,	'凛冬已至',	'',	'',	'王昭君',	'15258535769',	'15258535769',	2147483647,	'xiahwife999',	'',	'石家庄市长安区玉米红薯蔬菜批发',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/5997dafb37adc.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/5997db0b7eb27.jpg',	'',	1503124007,	10,	1,	0.00,	0.00,	0.00,	0.00,	0,	100.00,	0.00,	1506753445,	'',	'',	0,	0,	'2640431014@qq.com',	'510106000167012',	2017,	2017,	'',	'石家庄',	'',	'',	'',	'',	'153,1,2,3',	0,	0,	0,	0,	3,	3086536427,	1503277588,	0),
(48,	151,	'旺财',	'',	'',	'兰陵王',	'13646751330',	'13646751330',	690255987,	'li82657599',	'',	'百官官场',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/5997dbeaa774b.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/5997dc14ccbdc.jpg',	'hhhhhh',	1503124092,	10,	1,	0.10,	0.00,	0.00,	0.00,	0,	250.00,	0.00,	1502865480,	'',	'',	0,	0,	'690255987@qq.com',	'510106000167012',	2017,	2018,	'中国',	'石家庄',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/5997dc8f829d8.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/5997dcab2f445.jpg',	'11086',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170819/5997dcb34262f.jpg',	'153,115,7',	0,	0,	0,	0,	11,	1972724324,	1503557536,	0),
(49,	168,	'沃兴沃速',	'',	'',	'霍千里',	'18833669999',	'18833669999',	0,	'',	'6,130,542,,',	'一江大厦',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170906/59af9142b3e14.jpg',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170906/59af93da5f8bc.jpg',	'',	1504678922,	10,	1,	150.00,	0.00,	0.00,	0.00,	0,	200.00,	-150.00,	0,	',',	'',	50,	300,	'963852@qq.com',	'526365632587998',	1435680000,	1756656000,	'汽车，鲜花，服装，化妆品等销售',	'河北省石家庄市',	'http://7xpbjg.com1.z0.glb.clouddn.com/image/20170901/59a8f4c11209c.gif',	'',	'',	'',	'1,3,5,7,115,153,147',	0,	0,	0,	0,	6,	3739204329,	1504768709,	0);

DROP TABLE IF EXISTS `hanchao_shops_article`;
CREATE TABLE `hanchao_shops_article` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT COMMENT '文章ID',
  `catid` smallint(5) unsigned NOT NULL COMMENT '属性ID（预留）',
  `title` varchar(200) NOT NULL COMMENT '文章标题',
  `thumb` varchar(200) NOT NULL COMMENT '文章图片',
  `content` text NOT NULL COMMENT '文章内容',
  `shop_id` int(10) unsigned NOT NULL COMMENT '店铺id',
  `fileurl` varchar(255) NOT NULL COMMENT '文件url',
  `addtime` int(10) NOT NULL DEFAULT '0' COMMENT '文章添加时间',
  `updatetime` int(10) NOT NULL DEFAULT '0' COMMENT '文章更新时间',
  `count` int(10) unsigned NOT NULL DEFAULT '0' COMMENT '点击量',
  `sort` smallint(5) NOT NULL DEFAULT '10' COMMENT '排序',
  `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '是否显示',
  `seotitle` varchar(255) NOT NULL COMMENT 'Seo标题',
  `seokeywords` varchar(255) NOT NULL COMMENT 'Seo关键字',
  `seodescription` varchar(255) NOT NULL COMMENT 'Seo描述',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='店铺动态';

INSERT INTO `hanchao_shops_article` (`id`, `catid`, `title`, `thumb`, `content`, `shop_id`, `fileurl`, `addtime`, `updatetime`, `count`, `sort`, `status`, `seotitle`, `seokeywords`, `seodescription`) VALUES
(2,	0,	'测试动态',	'',	'测试动态',	4,	'',	1492065087,	0,	0,	10,	1,	'',	'',	''),
(3,	0,	'感恩消费',	'',	'&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	在今天之前的二十五年里，我们没有遇到过对方，我们在各自不同的地方\r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	成长、经历、遇到不同的人，经过不同的事\r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	慢慢长大，慢慢懂得珍惜，知道我们遇到对方\r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	这是不是我们遇到对方最好的时机呢，我不知道\r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	我不知道将来的某一天我们会不会就这么走散呢，我也不知道\r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	我只知道，在和亲在一起的每一天里，我都在感谢上天让我遇到亲\r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	我不善于表达，更多的时间里我会写，但是我说不出口\r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	我只想让你知道，在心里我是多么多么在乎，多么多么害怕失去您\r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	原谅我的打折，原谅我偶然的粗心\r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	我想我会用我此后的每一天，用我渐渐成熟的时间，来更好地为亲提供满意的产品和服务\r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	来让亲知道我有多么在乎亲\r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	我们身处的这个时代已经足够现实\r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	因为金钱，因为物质，因为距离，因为各种各样匪夷所思的东西、\r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	我们会生生错过那个彼此珍惜的事物，变成一辈子的遗憾\r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	如果这个世界上还有一样东西我们可以把握\r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	那么就在我们彼此相处的时间，用足够的真心，用足够的话语告诉对方\r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	我是真的真的非常在乎亲\r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	哪怕降低自尊，哪怕会有风险被打击自信\r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	但足够好过因为误会而不言不语\r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	我们能够相遇已经非常神奇\r\n&lt;/p&gt;\r\n&lt;p class=&quot;MsoNormal&quot;&gt;\r\n	我只想告诉亲，我再也不想错过亲 &amp;nbsp;\r\n&lt;/p&gt;',	3,	'',	1492657930,	0,	0,	10,	1,	'',	'',	''),
(4,	0,	'你好你好你好你好你好你好你好你好你好你好你好你好你好你好你好你好你好你好你好你好你好你好你好你好你好你好你好你好你好你好你好你好',	'',	'你好你好&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;你好你好&lt;span&gt;你好你好&lt;/span&gt;你好你好&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;&lt;span&gt;你好你好&lt;/span&gt;',	6,	'',	1493101841,	0,	0,	10,	1,	'',	'',	''),
(5,	0,	'新店开业！',	'',	'新店开业优惠多多，欢迎新老顾客光临。',	8,	'',	1493187860,	0,	0,	10,	1,	'',	'',	''),
(6,	0,	'牛奶',	'',	'店铺上新，牛奶半价',	14,	'',	1494062854,	0,	0,	10,	1,	'',	'',	''),
(7,	0,	'开业大优惠！！',	'',	'开业钜惠',	17,	'',	1494582590,	1496371969,	0,	10,	1,	'',	'',	''),
(8,	0,	'&quot;中国电商帮我们打开了局面&quot;(一带一路·互联互通)',	'',	'两千多年前，陆上和海上两条丝绸之路将中国与世界相连。如今，崭新的“网上丝绸之路”，更缩短了世界各国、各地区民众的距离。2016年，《“十三五”国家信息化规划》首次提出网上丝绸之路建设优先行动，作为中国未来五年的优先战略，目标是到2020年，中国与“一带一路”沿线国家形成基于跨境电商、数字贸易的多双边经贸合作大通道。&lt;br /&gt;\r\n历史上，西班牙曾是古丝绸之路和海上丝绸之路的双重沿线国家；如今，西班牙人也正积极为网上丝绸之路的建设作出贡献，无论是全球买还是全球卖，西班牙都是双向贸易最热门的欧洲国家之一。&lt;br /&gt;\r\n网购改变西班牙人生活&lt;br /&gt;\r\n中国商务部统计数据显示，近十年来中国跨境电商交易额年增长一直保持在30%左右，2016年交易规模达到6.3万亿元人民币，其中出口额约占交易总额的80%。&lt;br /&gt;\r\n&lt;br /&gt;\r\n“自敦煌网进入西班牙市场以来，来自西班牙的订单数量每年都在大幅增长，买家大多为西班牙当地人。”敦煌网海外市场经理李航向本报记者表示。&lt;br /&gt;\r\n据西班牙驻沪总领馆经济商务参赞阿丰索·诺力尔加介绍，西班牙是阿里巴巴海外平台全球速卖通的第三大市场，中国产品在西班牙很受欢迎。“当前电子商务的重要性显而易见，西中双方在该领域的合作前景十分美好。”诺力尔加说。&lt;br /&gt;\r\n去年，速卖通在西班牙首次举办“双11”折扣日，一小时内就接到了6500份订单，2000多部小米手机瞬间售罄，速卖通在马德里的整个海外仓被一扫而空。今年4月，速卖通的海外买家数量突破1亿，在其覆盖的220多个国家和地区中，俄罗斯、巴西、美国、西班牙、法国是购买力最强的五个国家，服装配饰、化妆品、家装家居、电子产品等都深受海外“剁手党”的喜爱。&lt;br /&gt;\r\n巴科·加尔西亚是一位西班牙能源工程师，他因病在家休养，利用专业知识改造房子成为了巴科的新乐趣。他在速卖通上大量购买节能灯泡、电线、开关、集成器等，订单数甚至超过了一些批发商户。&lt;br /&gt;\r\n“我们一度以为，他是在西班牙开五金店的人。”一位速卖通员工告诉记者。巴科重新设计了自己两所住房的照明系统，“我的家是全西班牙最亮的地方。”巴科说。不久前，巴科在社交网站上分享了在速卖通抢到的红包，他说：“在速卖通买东西，真是停不下来。”&lt;br /&gt;\r\n推动双方企业全球化步伐&lt;br /&gt;\r\n中国电商的蓬勃发展不仅为国内中小企业打开了通往海外的大门，也让更多海外企业有机会进入中国市场，走向全球。&lt;br /&gt;\r\n2016年12月发布的《中国跨境电子商务发展报告》指出，随着国内市场对海外商品的需求日益增长，中国跨境电子商务进口交易额逐年扩大，预计未来几年内中国跨境电子商务进口占比将不断提升。&lt;br /&gt;\r\n目前，入驻天猫的西班牙品牌已经有53个，领域包括服装、化妆品、红酒、火腿等西班牙“特产”，一改此前西班牙中小品牌难以进入中国市场的状况。&lt;br /&gt;\r\n怡思丁是西班牙一家拥有40多年历史的药妆品牌，2015年入驻天猫国际。“通过电商模式进入中国市场后，我们的销售额骤然增长，网店开业第一天就卖了100多件产品。2016年，我们的销售额达到1.8亿欧元，这在以前是不敢想象的。”怡思丁大中华区负责人胡佳在接受本报记者采访时说。&lt;br /&gt;\r\n目前，怡思丁40%的销售来自国际业务，“虽然怡思丁在西班牙占据市场份额第一，但要在中国从零开始并打开知名度并非易事，跨境电商帮我们打开了局面，快速开拓了市场，我们对未来很有信心。”胡佳说。&lt;br /&gt;\r\n助力西班牙本地电商发展&lt;br /&gt;\r\n据联合国贸易和发展会议上个月公布的数据显示，全球电子商务市场规模已经达到25万亿美元，美国、日本和中国在该市场占据领先地位，西班牙排在第九位。&lt;br /&gt;\r\n近几年，跨境电商大大推动了西班牙市场发展，亚马逊、阿里速卖通等大型跨境电商的到来不仅刺激了西班牙市场的电子化，也让更多西班牙人开始接受和习惯网上购物方式，为西班牙本地电商发展培育了土壤。西班牙政府开始重视本国电商发展，首相拉霍伊在去年杭州G20峰会上表示，希望今后西班牙经济能实现市场电子化的创新与转型，G20应该且有必要对全球经济困难下的电子化创新提供借鉴与指导。&lt;br /&gt;\r\n“速卖通改变了海外不少国家和地区用户的消费习惯。”速卖通西班牙籍员工苏尼加·佩雷斯告诉记者，最典型的例子是，过去没有西班牙人会在网上买婚纱，人们都要去婚纱店订制并反复试穿，如今则有越来越多西班牙女性在速卖通上购买婚纱。&lt;br /&gt;\r\n另一方面，跨境电商的先行也促进了西班牙物流业的发展与完善。2015年，阿里巴巴与西班牙邮政局建立物流合作，并设立海外仓库，将中国包裹送抵西班牙消费者手中的时间缩短了一半。&lt;br /&gt;\r\n新加坡隆道研究院总裁、南洋国际商学院院长许振义对阿里巴巴在西班牙市场的“一带一路”实践进行了考察，他对本报记者表示，在电商和现代物流、金融的推动下，优质的中国商品得以迅速进入欧洲市场，受到欧洲消费者欢迎；同样，通过在电商网站上建立旗舰店，中国消费者能够享受到火腿、葡萄酒等优质的欧洲商品。这样的互联互通，最终受益的是广大消费群体。&lt;br /&gt;\r\n“经济全球化的特点是越开放就越能创新、越能擦出合作共赢的火花。中国无疑是当前世界经济增长的主要动力。”许振义说。&lt;br /&gt;\r\n&lt;br /&gt;\r\n&lt;br /&gt;\r\n&lt;br /&gt;\r\n&lt;br /&gt;',	15,	'',	1495593503,	0,	0,	10,	1,	'',	'',	''),
(10,	0,	'测试',	'',	'121212',	17,	'',	1496371906,	1496371936,	0,	10,	1,	'',	'',	''),
(12,	0,	'123',	'',	'feshafrh场v第三空间发货时刻大年初三两三分',	9,	'',	1499850117,	0,	0,	10,	1,	'',	'',	''),
(13,	0,	'​​​浪浪薯霸王”限时抢“鲜”上市！',	'',	'&lt;div style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;span style=&quot;line-height:1.5;font-family:\'Microsoft YaHei\';&quot;&gt;&lt;span style=&quot;font-size:14px;color:#333333;line-height:2;&quot;&gt;&lt;/span&gt;&lt;span style=&quot;font-size:14px;&quot;&gt;&lt;span style=&quot;color:#333333;line-height:2;&quot;&gt;&lt;/span&gt;&lt;span style=&quot;color:#333333;line-height:2;&quot;&gt;&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;&lt;span style=&quot;font-size:14px;color:#333333;line-height:2;&quot;&gt;浪浪薯霸王”限时抢“鲜”上市！为了给大家呈现“有味更有型”的薯条，汉堡王正在进行“浪浪薯霸王”的限时推广，推广期间所有售出薯&lt;/span&gt;&lt;span style=&quot;font-size:14px;color:#333333;line-height:2;&quot;&gt;条均为“浪浪薯霸王”，为期约一个月。&lt;/span&gt;\r\n&lt;/div&gt;',	7,	'',	1500278525,	0,	0,	10,	1,	'',	'',	''),
(14,	0,	'商家公告：餐厅食品',	'',	'&lt;div style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;span style=&quot;color:#333333;font-family:\'Microsoft YaHei\';font-size:14px;line-height:2;&quot;&gt;顾客您好，餐厅食品主食鱼香茄子、香辣牛肉饭、香辣牛肉面是带辣味的，凉菜系列的红油肚丝、麻辣黄瓜、红油腐竹是带辣味。&lt;/span&gt; \r\n&lt;/div&gt;',	7,	'',	1500278751,	1500280266,	0,	10,	1,	'',	'',	''),
(15,	0,	'优惠活动丨一“杯”子的温暖-BESTJOY水具专场',	'',	'&lt;span style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;line-height:19.2px;background-color:#FFFFFF;&quot;&gt;一“杯”子的温暖-BESTJOY水具专场优惠促销活动开始了，欢迎大家参与！&lt;/span&gt;',	38,	'',	1501750996,	0,	0,	10,	1,	'',	'',	''),
(16,	0,	'优惠活动丨意大利奥尼原装进口橄榄油专场',	'',	'&lt;span style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;line-height:19.2px;background-color:#FFFFFF;&quot;&gt;意大利奥尼原装进口橄榄油专场优惠促销活动开始了，欢迎大家参与！&lt;/span&gt;',	38,	'',	1501751058,	0,	0,	10,	1,	'',	'',	''),
(17,	0,	'新春年底礼箱产品火热上市',	'',	'&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;春节的脚步越来越近，又要开始准备囤年货、新春伴手礼咯。亲朋好友送礼，自己家人团聚，怎么能少得了年货礼箱呢？即日起太祖食品给您精心准备了源自台湾好滋味的大礼箱，为您的团圆时刻带来更多的幸福好滋味。&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;&lt;br /&gt;\r\n&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:center;&quot;&gt;\r\n	&lt;img src=&quot;http://www.taizu.com/upload/edit/image/20170712/20170712054955_66546.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;http://www.taizu.com/upload/edit/image/20170712/20170712055012_70614.jpg&quot; alt=&quot;&quot; width=&quot;872&quot; height=&quot;638&quot; title=&quot;&quot; align=&quot;&quot; /&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;太祖年货礼箱，让您过年不用愁~~丰富组合~~要买要快哦！&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;~更多美味尽在太祖食品~&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;欢迎致电或到店了解更多详情。&lt;/span&gt; \r\n&lt;/p&gt;',	44,	'',	1502098571,	1502433798,	0,	10,	1,	'',	'',	''),
(18,	0,	'开业钜惠！',	'',	'富安娜新店开业，促销多多。',	43,	'',	1502099067,	1502948021,	0,	10,	1,	'',	'',	''),
(19,	0,	'台企太祖食品六一儿童节献爱心',	'',	'&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;&quot;&gt;今年六一，源自台湾（圣祖食品旗下）的厦门太祖食品有限公司代表分别给厦门市滨北小学、莲前小学、滨海小学、翔安新圩学校、滨海幼儿园等10所学校的孩子们送上节日礼物---太祖食品“六一礼包”，给他们带去了不一样的欢乐。&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;在这些学校里，小朋友分别领到太祖食品的牛轧糖、挑嘴绿豆糕、牛轧饼和张大点海苔片组成的特色礼包。在尝到一颗颗奶香浓郁的牛轧糖；绵柔清香、细腻冰爽的绿豆糕；外酥内脆不粘牙，越冰越好吃的牛轧饼；以及绿色天然、健康美味的海苔片后，小朋友们都深深迷恋上这地道口感的台湾滋味，天真稚嫩的欢笑声荡漾不绝。&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;据悉，太祖食品自2008年以来，一直坚持“六一儿童节献爱心”公益活动，每年都献给孩子们上万份的“六一节礼物”；也连续多年在滨海小学设立爱心助学基金。&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:center;&quot;&gt;\r\n	&lt;img src=&quot;http://www.taizu.com/style/images/img22.jpg&quot; /&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; 企业走到哪里，爱心也跟随到那里。这是太祖食品以公益事业来回馈社会的表达方式。值得一提的是，太祖食品在厦门翔安拥有占地2万多平米的食品工厂，也连续多年给翔安新圩学校进行六一献爱心活动。目前，太祖食品拥有牛轧糖、肉制品、海苔制品、点心面制品、传统糕点等系列产品；企业也从传统的特产业，转型升级到休闲食品和面向全国发展的新领域，为今后的发展迎来更多机遇。&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;此外，位于厦门岛内环岛路的太祖食品台湾精品馆，一直是广大游客所喜欢的参观、旅游和购物的好地方。目前，仍保留了原有手工DIY体验项目，并设立台湾进口商品区、金门名特产区、厦门伴手礼区以及台湾小吃的乔安牧场美食。让更多的消费者，不用去台湾、不用去金门，也能买得到地道的台湾、金门名特产，感受不一样的休闲购物与美食体验。&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;text-align:justify;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;color:#333333;line-height:2;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;同时，台湾圣祖食品创办20多年来，也不断积极投身公益事业，在台湾地区设立八所学校奖助学金，并长期资助贫困儿童。台湾圣祖及旗下厦门太祖食品，不断关心、关爱孩子们的成长，用实际行动践行一个爱心企业的德善胸怀与社会责任。&lt;/span&gt; \r\n&lt;/p&gt;',	44,	'',	1502099128,	1502099163,	0,	10,	1,	'',	'',	''),
(20,	0,	'台企太祖食品六一儿童节献爱心',	'',	'&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;&quot;&gt;今年六一，源自台湾（圣祖食品旗下）的厦门太祖食品有限公司代表分别给厦门市滨北小学、莲前小学、滨海小学、翔安新圩学校、滨海幼儿园等10所学校的孩子们送上节日礼物---太祖食品“六一礼包”，给他们带去了不一样的欢乐。&lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;在这些学校里，小朋友分别领到太祖食品的牛轧糖、挑嘴绿豆糕、牛轧饼和张大点海苔片组成的特色礼包。在尝到一颗颗奶香浓郁的牛轧糖；绵柔清香、细腻冰爽的绿豆糕；外酥内脆不粘牙，越冰越好吃的牛轧饼；以及绿色天然、健康美味的海苔片后，小朋友们都深深迷恋上这地道口感的台湾滋味，天真稚嫩的欢笑声荡漾不绝。&lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;据悉，太祖食品自2008年以来，一直坚持“六一儿童节献爱心”公益活动，每年都献给孩子们上万份的“六一节礼物”；也连续多年在滨海小学设立爱心助学基金。&lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:center;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;img src=&quot;http://www.taizu.com/style/images/img22.jpg&quot; /&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; 企业走到哪里，爱心也跟随到那里。这是太祖食品以公益事业来回馈社会的表达方式。值得一提的是，太祖食品在厦门翔安拥有占地2万多平米的食品工厂，也连续多年给翔安新圩学校进行六一献爱心活动。目前，太祖食品拥有牛轧糖、肉制品、海苔制品、点心面制品、传统糕点等系列产品；企业也从传统的特产业，转型升级到休闲食品和面向全国发展的新领域，为今后的发展迎来更多机遇。&lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;此外，位于厦门岛内环岛路的太祖食品台湾精品馆，一直是广大游客所喜欢的参观、旅游和购物的好地方。目前，仍保留了原有手工DIY体验项目，并设立台湾进口商品区、金门名特产区、厦门伴手礼区以及台湾小吃的乔安牧场美食。让更多的消费者，不用去台湾、不用去金门，也能买得到地道的台湾、金门名特产，感受不一样的休闲购物与美食体验。&lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;line-height:2;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;同时，台湾圣祖食品创办20多年来，也不断积极投身公益事业，在台湾地区设立八所学校奖助学金，并长期资助贫困儿童。台湾圣祖及旗下厦门太祖食品，不断关心、关爱孩子们的成长，用实际行动践行一个爱心企业的德善胸怀与社会责任。&lt;/span&gt;\r\n&lt;/p&gt;',	44,	'',	1502107452,	0,	0,	10,	1,	'',	'',	''),
(21,	0,	'台企太祖食品六一儿童节献爱心',	'',	'&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;&quot;&gt;今年六一，源自台湾（圣祖食品旗下）的厦门太祖食品有限公司代表分别给厦门市滨北小学、莲前小学、滨海小学、翔安新圩学校、滨海幼儿园等10所学校的孩子们送上节日礼物---太祖食品“六一礼包”，给他们带去了不一样的欢乐。&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;在这些学校里，小朋友分别领到太祖食品的牛轧糖、挑嘴绿豆糕、牛轧饼和张大点海苔片组成的特色礼包。在尝到一颗颗奶香浓郁的牛轧糖；绵柔清香、细腻冰爽的绿豆糕；外酥内脆不粘牙，越冰越好吃的牛轧饼；以及绿色天然、健康美味的海苔片后，小朋友们都深深迷恋上这地道口感的台湾滋味，天真稚嫩的欢笑声荡漾不绝。&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;据悉，太祖食品自2008年以来，一直坚持“六一儿童节献爱心”公益活动，每年都献给孩子们上万份的“六一节礼物”；也连续多年在滨海小学设立爱心助学基金。&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:center;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;img src=&quot;http://www.taizu.com/style/images/img22.jpg&quot; /&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; 企业走到哪里，爱心也跟随到那里。这是太祖食品以公益事业来回馈社会的表达方式。值得一提的是，太祖食品在厦门翔安拥有占地2万多平米的食品工厂，也连续多年给翔安新圩学校进行六一献爱心活动。目前，太祖食品拥有牛轧糖、肉制品、海苔制品、点心面制品、传统糕点等系列产品；企业也从传统的特产业，转型升级到休闲食品和面向全国发展的新领域，为今后的发展迎来更多机遇。&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;此外，位于厦门岛内环岛路的太祖食品台湾精品馆，一直是广大游客所喜欢的参观、旅游和购物的好地方。目前，仍保留了原有手工DIY体验项目，并设立台湾进口商品区、金门名特产区、厦门伴手礼区以及台湾小吃的乔安牧场美食。让更多的消费者，不用去台湾、不用去金门，也能买得到地道的台湾、金门名特产，感受不一样的休闲购物与美食体验。&lt;/span&gt; \r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;line-height:2;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;同时，台湾圣祖食品创办20多年来，也不断积极投身公益事业，在台湾地区设立八所学校奖助学金，并长期资助贫困儿童。台湾圣祖及旗下厦门太祖食品，不断关心、关爱孩子们的成长，用实际行动践行一个爱心企业的德善胸怀与社会责任。&lt;/span&gt; \r\n&lt;/p&gt;',	44,	'',	1502107464,	1502433788,	0,	10,	1,	'',	'',	''),
(22,	0,	'台企太祖食品六一儿童节献爱心',	'',	'&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;&quot;&gt;今年六一，源自台湾（圣祖食品旗下）的厦门太祖食品有限公司代表分别给厦门市滨北小学、莲前小学、滨海小学、翔安新圩学校、滨海幼儿园等10所学校的孩子们送上节日礼物---太祖食品“六一礼包”，给他们带去了不一样的欢乐。&lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;在这些学校里，小朋友分别领到太祖食品的牛轧糖、挑嘴绿豆糕、牛轧饼和张大点海苔片组成的特色礼包。在尝到一颗颗奶香浓郁的牛轧糖；绵柔清香、细腻冰爽的绿豆糕；外酥内脆不粘牙，越冰越好吃的牛轧饼；以及绿色天然、健康美味的海苔片后，小朋友们都深深迷恋上这地道口感的台湾滋味，天真稚嫩的欢笑声荡漾不绝。&lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;据悉，太祖食品自2008年以来，一直坚持“六一儿童节献爱心”公益活动，每年都献给孩子们上万份的“六一节礼物”；也连续多年在滨海小学设立爱心助学基金。&lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:center;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;img src=&quot;http://www.taizu.com/style/images/img22.jpg&quot; /&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; 企业走到哪里，爱心也跟随到那里。这是太祖食品以公益事业来回馈社会的表达方式。值得一提的是，太祖食品在厦门翔安拥有占地2万多平米的食品工厂，也连续多年给翔安新圩学校进行六一献爱心活动。目前，太祖食品拥有牛轧糖、肉制品、海苔制品、点心面制品、传统糕点等系列产品；企业也从传统的特产业，转型升级到休闲食品和面向全国发展的新领域，为今后的发展迎来更多机遇。&lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;此外，位于厦门岛内环岛路的太祖食品台湾精品馆，一直是广大游客所喜欢的参观、旅游和购物的好地方。目前，仍保留了原有手工DIY体验项目，并设立台湾进口商品区、金门名特产区、厦门伴手礼区以及台湾小吃的乔安牧场美食。让更多的消费者，不用去台湾、不用去金门，也能买得到地道的台湾、金门名特产，感受不一样的休闲购物与美食体验。&lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;line-height:2;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;同时，台湾圣祖食品创办20多年来，也不断积极投身公益事业，在台湾地区设立八所学校奖助学金，并长期资助贫困儿童。台湾圣祖及旗下厦门太祖食品，不断关心、关爱孩子们的成长，用实际行动践行一个爱心企业的德善胸怀与社会责任。&lt;/span&gt;\r\n&lt;/p&gt;',	44,	'',	1502107502,	0,	0,	10,	1,	'',	'',	''),
(23,	0,	'台企太祖食品六一儿童节献爱心',	'',	'&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;&quot;&gt;今年六一，源自台湾（圣祖食品旗下）的厦门太祖食品有限公司代表分别给厦门市滨北小学、莲前小学、滨海小学、翔安新圩学校、滨海幼儿园等10所学校的孩子们送上节日礼物---太祖食品“六一礼包”，给他们带去了不一样的欢乐。&lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;在这些学校里，小朋友分别领到太祖食品的牛轧糖、挑嘴绿豆糕、牛轧饼和张大点海苔片组成的特色礼包。在尝到一颗颗奶香浓郁的牛轧糖；绵柔清香、细腻冰爽的绿豆糕；外酥内脆不粘牙，越冰越好吃的牛轧饼；以及绿色天然、健康美味的海苔片后，小朋友们都深深迷恋上这地道口感的台湾滋味，天真稚嫩的欢笑声荡漾不绝。&lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;据悉，太祖食品自2008年以来，一直坚持“六一儿童节献爱心”公益活动，每年都献给孩子们上万份的“六一节礼物”；也连续多年在滨海小学设立爱心助学基金。&lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:center;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;img src=&quot;http://www.taizu.com/style/images/img22.jpg&quot; /&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; 企业走到哪里，爱心也跟随到那里。这是太祖食品以公益事业来回馈社会的表达方式。值得一提的是，太祖食品在厦门翔安拥有占地2万多平米的食品工厂，也连续多年给翔安新圩学校进行六一献爱心活动。目前，太祖食品拥有牛轧糖、肉制品、海苔制品、点心面制品、传统糕点等系列产品；企业也从传统的特产业，转型升级到休闲食品和面向全国发展的新领域，为今后的发展迎来更多机遇。&lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;此外，位于厦门岛内环岛路的太祖食品台湾精品馆，一直是广大游客所喜欢的参观、旅游和购物的好地方。目前，仍保留了原有手工DIY体验项目，并设立台湾进口商品区、金门名特产区、厦门伴手礼区以及台湾小吃的乔安牧场美食。让更多的消费者，不用去台湾、不用去金门，也能买得到地道的台湾、金门名特产，感受不一样的休闲购物与美食体验。&lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;line-height:2;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;同时，台湾圣祖食品创办20多年来，也不断积极投身公益事业，在台湾地区设立八所学校奖助学金，并长期资助贫困儿童。台湾圣祖及旗下厦门太祖食品，不断关心、关爱孩子们的成长，用实际行动践行一个爱心企业的德善胸怀与社会责任。&lt;/span&gt;\r\n&lt;/p&gt;',	44,	'',	1502107520,	0,	0,	10,	1,	'',	'',	''),
(24,	0,	'台企太祖食品六一儿童节献爱心',	'',	'&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;&quot;&gt;今年六一，源自台湾（圣祖食品旗下）的厦门太祖食品有限公司代表分别给厦门市滨北小学、莲前小学、滨海小学、翔安新圩学校、滨海幼儿园等10所学校的孩子们送上节日礼物---太祖食品“六一礼包”，给他们带去了不一样的欢乐。&lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;在这些学校里，小朋友分别领到太祖食品的牛轧糖、挑嘴绿豆糕、牛轧饼和张大点海苔片组成的特色礼包。在尝到一颗颗奶香浓郁的牛轧糖；绵柔清香、细腻冰爽的绿豆糕；外酥内脆不粘牙，越冰越好吃的牛轧饼；以及绿色天然、健康美味的海苔片后，小朋友们都深深迷恋上这地道口感的台湾滋味，天真稚嫩的欢笑声荡漾不绝。&lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;据悉，太祖食品自2008年以来，一直坚持“六一儿童节献爱心”公益活动，每年都献给孩子们上万份的“六一节礼物”；也连续多年在滨海小学设立爱心助学基金。&lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;br /&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:center;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;img src=&quot;http://www.taizu.com/style/images/img22.jpg&quot; /&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;&lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; 企业走到哪里，爱心也跟随到那里。这是太祖食品以公益事业来回馈社会的表达方式。值得一提的是，太祖食品在厦门翔安拥有占地2万多平米的食品工厂，也连续多年给翔安新圩学校进行六一献爱心活动。目前，太祖食品拥有牛轧糖、肉制品、海苔制品、点心面制品、传统糕点等系列产品；企业也从传统的特产业，转型升级到休闲食品和面向全国发展的新领域，为今后的发展迎来更多机遇。&lt;/span&gt;\r\n&lt;/p&gt;\r\n&lt;p style=&quot;color:#333333;font-family:\'Microsoft Yahei\', \'Hiragino Sans GB\', \'Helvetica Neue\', Helvetica, tahoma, arial, \'WenQuanYi Micro Hei\', Verdana, sans-serif, 宋体;text-align:justify;background-color:#FFFFFF;&quot;&gt;\r\n	&lt;span style=&quot;font-family:\'Microsoft YaHei\';font-size:14px;&quot;&gt;&amp;nbsp; &amp;nbsp; &amp;nbsp; &amp;nbsp;此外，位于厦门岛内环岛路的太祖食品台湾精品馆，一直是广大游客所喜欢的参观、旅游和购物的好地方。目前，仍