//app.js
var util = require('./utils/utils.js');
var api = require('./api.js');
App({
    onLaunch: function () {
        console.log(wx.getSystemInfoSync());
        this.getStoreData();
        this.getCatList();
        var access_token = wx.getStorageSync("access_token");
        if (!access_token)
            this.login();
    },

    getStoreData: function () {
        this.request({
            url: api.default.store,
            success: function (res) {
                if (res.code == 0) {
                    wx.setStorageSync("store", res.data.store);
                    wx.setStorageSync("store_name", res.data.store_name);
                    wx.setStorageSync("show_customer_service", res.data.show_customer_service);
                    wx.setStorageSync("contact_tel", res.data.contact_tel);
                }
            }
        });
    },

    getCatList: function () {
        this.request({
            url: api.default.cat_list,
            success: function (res) {
                if (res.code == 0) {
                    var cat_list = res.data.list || [];
                    wx.setStorageSync("cat_list", cat_list);
                }
            }
        });
    },

    login: function () {
        var pages = getCurrentPages();
        var page = pages[(pages.length - 1)];
        //console.log(page);
        wx.showLoading({
            title: "正在登录",
            mask: true,
        });
        wx.login({
            success: function (res) {
                if (res.code) {
                    var code = res.code;
                    wx.getUserInfo({
                        success: function (res) {
                            //console.log(res);
                            getApp().request({
                                url: api.passport.login,
                                method: "post",
                                data: {
                                    code: code,
                                    user_info: res.rawData,
                                    encrypted_data: res.encryptedData,
                                    iv: res.iv,
                                    signature: res.signature
                                },
                                success: function (res) {
                                    wx.hideLoading();
                                    if (res.code == 0) {
                                        wx.setStorageSync("access_token", res.data.access_token);
                                        wx.setStorageSync("user_info", {
                                            nickname: res.data.nickname,
                                            avatar_url: res.data.avatar_url,
                                        });
                                        if (page == undefined)
                                            return;
                                        wx.redirectTo({
                                            url: "/" + page.route + "?" + util.objectToUrlParams(page.options),
                                            fail: function () {
                                                wx.switchTab({
                                                    url: "/" + page.route,
                                                });
                                            },
                                        });
                                    } else {
                                        wx.showToast({
                                            title: res.msg
                                        });
                                    }
                                }
                            });
                        }
                    });
                } else {
                    //console.log(res);
                }

            }
        });
    },
    request: function (object) {
        var access_token = wx.getStorageSync("access_token");
        //console.log(object);
        //console.log(access_token);
        if (access_token) {
            if (!object.data)
                object.data = {};
            object.data.access_token = access_token;
        }
        wx.request({
            url: object.url,
            header: object.header || {
                'content-type': 'application/x-www-form-urlencoded'
            },
            data: object.data || {},
            method: object.method || "GET",
            dataType: object.dataType || "json",
            success: function (res) {
                if (res.data.code == -1) {
                    getApp().login();
                } else {
                    if (object.success)
                        object.success(res.data);
                }
            },
            fail: function (res) {
                if (object.fail)
                    object.fail(res);
            },
            complete: function (res) {
                if (object.complete)
                    object.complete(res);
            }
        });
    },
    saveFormId: function (form_id) {
        this.request({
            url: api.user.save_form_id,
            data: {
                form_id: form_id,
            }
        });
    },
});