var api = require('../../api.js');
var app = getApp();
Page({

    /**
     * 页面的初始数据
     */
    data: {
        address_list: [],
    },

    /**
     * 生命周期函数--监听页面加载
     */
    onLoad: function (options) {
    },

    /**
     * 生命周期函数--监听页面初次渲染完成
     */
    onReady: function () {

    },

    /**
     * 生命周期函数--监听页面显示
     */
    onShow: function () {
        var page = this;
        wx.showNavigationBarLoading();
        app.request({
            url: api.user.address_list,
            success: function (res) {
                wx.hideNavigationBarLoading();
                if (res.code == 0) {
                    page.setData({
                        address_list: res.data.list,
                    });
                }
            }
        });
    },

    pickAddress: function (e) {
        var page = this;
        var index = e.currentTarget.dataset.index;
        var address = page.data.address_list[index];
        wx.setStorageSync("picker_address", address);
        wx.navigateBack();
    },
});