<?php
// +----------------------------------------------------------------------
// | OnlineRetailers [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2003-2023 www.yisu.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 王强 <13052079525>
// +----------------------------------------------------------------------
namespace Common\TraitClass;

use Common\Model\BaseModel;
use Home\Model\OrderModel;
use Common\Model\OrderWxpayModel;
use Common\Model\OrderGoodsModel;
use Home\Logical\AmountLogic;
use Think\Hook;

/**
 * 支付通知
 * 
 * @author Administrator
 */
trait OrderNoticeTrait 
{
    /**
     * 支付宝流水号
     * @var int
     */
    protected $tradeNo = 0;
    
    private function orderNotice($orderId)
    {
        $orderModel = BaseModel::getInstance(OrderModel::class);
        
        $status = $orderModel->paySuccessEditStatus($orderId);
        
        if (empty($status)) {
            return false;
        }
        
        $param = [
            'order_sn_id' => $orderId,
            'trade_no' => $this->tradeNo,
            'wx_order_id' => $orderId,
            'type'        => 0
        ];
       
        Hook::listen('aplipaySerial', $param);
       
        if (empty($param)) {
            return false;
        }

        $orderGoodsModel = BaseModel::getInstance(OrderGoodsModel::class);
        
        $status = $orderGoodsModel->updateOrderGoodsStatus($orderId);
       
        if (empty($status)) {
            return false;
        }
        
        // 减库存
        
        $amountModel = new AmountLogic($orderId, $orderGoodsModel);
        
        $status = $amountModel->amountParse();
        if (empty($status)) {
            return false;
        }
        
      
        return true;
    }
}