<?php
// +----------------------------------------------------------------------
// | OnlineRetailers [ WE CAN DO IT JUST THINK IT ]
// +----------------------------------------------------------------------
// | Copyright (c) 2003-2023 www.yisu.cn All rights reserved.
// +----------------------------------------------------------------------
// | Licensed ( http://www.apache.org/licenses/LICENSE-2.0 )
// +----------------------------------------------------------------------
// | Author: 王强 <opjklu@126.com>
// +----------------------------------------------------------------------

namespace Home\Model;
use Think\Model;

/**
 * 广告模型 
 */
class AdModel extends Model
{
    private static $obj;
    
    public static function getInitnation()
    {
        $name = __CLASS__;
        return self::$obj = !(self::$obj instanceof $name) ? new self() : self::$obj;
    }


    /**
     * 获取 首页 banner图 
     */
    public function select($options = array(), Model $model)
    {
        if ( !($model instanceof Model) || !is_object($model) ) {
            return array();
        }
        $data = parent::select($options);

        if (!empty($data)) {
            foreach ($data as $key => &$value)
            {
                $value['product'] = $model->select(array(
                   'where' => array('shelves' => 1, 'selling' => 1),
                   'limit' => 3,
                   'field' => array('id','title')
                ));
            }
        }
        return $data;
    }


    /**
     * 获取banner图
     * @param $str导航的名字
     * @return mixed
     */
    public function getNavBanner($str){
        //查出广告位置管理
        $ad_space_id = M("AdSpace")->where(['name'=>$str])->getField('id');
        $ad_details = M("Ad")
            ->field("ad_link,pic_url,id")
            ->where(['ad_space_id'=>$ad_space_id])
            ->limit(4)
            ->order("id")
            ->select();
        return $ad_details;
    }
} 