SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for `wst_communitys`
-- ----------------------------
DROP TABLE IF EXISTS `wst_communitys`;
CREATE TABLE `wst_communitys` (
  `communityId` int(11) NOT NULL AUTO_INCREMENT,
  `areaId1` int(11) NOT NULL,
  `areaId2` int(11) NOT NULL,
  `areaId3` int(11) NOT NULL,
  `isShow` tinyint(4) NOT NULL DEFAULT '1',
  `isService` tinyint(4) NOT NULL DEFAULT '0',
  `communityName` varchar(80) NOT NULL,
  `communitySort` int(11) NOT NULL DEFAULT '0',
  `communityKey` char(255) NOT NULL,
  `communityFlag` tinyint(4) NOT NULL DEFAULT '1',
  `latitude` char(30) DEFAULT NULL,
  `longitude` char(30) DEFAULT NULL,
  `mapLevel` int(11) DEFAULT '13',
  PRIMARY KEY (`communityId`),
  KEY `isShow` (`isShow`,`communityFlag`),
  KEY `areaId1` (`areaId1`) USING BTREE,
  KEY `areaId2` (`areaId2`),
  KEY `areaId3` (`areaId3`)
) ENGINE=InnoDB AUTO_INCREMENT=45057 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of wst_communitys
-- ----------------------------
INSERT INTO `wst_communitys` VALUES ('15', '440000', '440100', '440106', '1', '1', '五山岑村社区', '1', '', '1', null, null, '13'),
('16', '440000', '440100', '440106', '1', '1', '华南农业大学社区', '2', '', '1', null, null, '13'),
('17', '440000', '440100', '440106', '1', '1', '华南理工大学社区', '3', '', '1', null, null, '13'),
('18', '440000', '440100', '440106', '1', '1', '暨南大学社区', '4', '', '1', null, null, '13'),
('19', '440000', '440100', '440106', '1', '1', '华南师范大学社区', '5', '', '1', null, null, '13'),
('20', '440000', '440100', '440106', '1', '1', '石牌桥社区', '8', '', '1', null, null, '13'),
('21', '440000', '440100', '440106', '1', '1', '岗顶社区', '6', '', '1', null, null, '13'),
('22', '440000', '440100', '440106', '1', '1', '五羊新村', '6', '', '1', null, null, '13'),
('23', '440000', '440100', '440106', '1', '1', '天河体育中心', '7', '', '1', null, null, '13'),
('1764', '130000', '130100', '130102', '1', '1', '建北街道', '0', '', '1', '0', '0', '10'),
('1765', '130000', '130100', '130102', '1', '1', '青园街道', '0', '', '1', '0', '0', '10'),
('1766', '130000', '130100', '130102', '1', '1', '广安街道', '0', '', '1', '0', '0', '10'),
('1767', '130000', '130100', '130102', '1', '1', '育才街道', '0', '', '1', '0', '0', '10'),
('1768', '130000', '130100', '130102', '1', '1', '跃进街道', '0', '', '1', '0', '0', '10'),
('1769', '130000', '130100', '130102', '1', '1', '河东街道', '0', '', '1', '0', '0', '10'),
('1770', '130000', '130100', '130102', '1', '1', '长丰街道', '0', '', '1', '0', '0', '10'),
('1771', '130000', '130100', '130102', '1', '1', '谈固街道', '0', '', '1', '0', '0', '10'),
('1772', '130000', '130100', '130102', '1', '1', '西兆通镇', '0', '', '1', '0', '0', '10'),
('1773', '130000', '130100', '130102', '1', '1', '南村镇', '0', '', '1', '0', '0', '10'),
('1774', '130000', '130100', '130102', '1', '1', '高营镇', '0', '', '1', '0', '0', '10'),
('1775', '130000', '130100', '130103', '1', '1', '中山东路街道', '0', '', '1', '0', '0', '10'),
('1776', '130000', '130100', '130103', '1', '1', '彭后街道', '0', '', '1', '0', '0', '10'),
('1777', '130000', '130100', '130103', '1', '1', '东风街道', '0', '', '1', '0', '0', '10'),
('1778', '130000', '130100', '130103', '1', '1', '东华街道', '0', '', '1', '0', '0', '10'),
('1779', '130000', '130100', '130103', '1', '1', '休门街道', '0', '', '1', '0', '0', '10'),
('1780', '130000', '130100', '130103', '1', '1', '阜康街道', '0', '', '1', '0', '0', '10'),
('1781', '130000', '130100', '130103', '1', '1', '建安街道', '0', '', '1', '0', '0', '10'),
('1782', '130000', '130100', '130103', '1', '1', '胜利北街道', '0', '', '1', '0', '0', '10'),
('1783', '130000', '130100', '130103', '1', '1', '汇通街道', '0', '', '1', '0', '0', '10'),
('1784', '130000', '130100', '130103', '1', '1', '桃园镇', '0', '', '1', '0', '0', '10'),
('1785', '130000', '130100', '130104', '1', '1', '东里街道', '0', '', '1', '0', '0', '10'),
('1786', '130000', '130100', '130104', '1', '1', '中山路街道', '0', '', '1', '0', '0', '10'),
('1787', '130000', '130100', '130104', '1', '1', '南长街道', '0', '', '1', '0', '0', '10'),
('1788', '130000', '130100', '130104', '1', '1', '维明街道', '0', '', '1', '0', '0', '10'),
('1789', '130000', '130100', '130104', '1', '1', '裕西街道', '0', '', '1', '0', '0', '10'),
('1790', '130000', '130100', '130104', '1', '1', '友谊街道', '0', '', '1', '0', '0', '10'),
('1791', '130000', '130100', '130104', '1', '1', '红旗街道', '0', '', '1', '0', '0', '10'),
('1792', '130000', '130100', '130104', '1', '1', '新石街道', '0', '', '1', '0', '0', '10'),
('1793', '130000', '130100', '130104', '1', '1', '苑东街道', '0', '', '1', '0', '0', '10'),
('1794', '130000', '130100', '130104', '1', '1', '西里街道', '0', '', '1', '0', '0', '10'),
('1795', '130000', '130100', '130104', '1', '1', '振头街道', '0', '', '1', '0', '0', '10'),
('1796', '130000', '130100', '130104', '1', '1', '留营乡', '0', '', '1', '0', '0', '10'),
('1797', '130000', '130100', '130105', '1', '1', '革新街街道', '0', '', '1', '0', '0', '10'),
('1798', '130000', '130100', '130105', '1', '1', '新华路街道', '0', '', '1', '0', '0', '10'),
('1799', '130000', '130100', '130105', '1', '1', '宁安路街道', '0', '', '1', '0', '0', '10'),
('1800', '130000', '130100', '130105', '1', '1', '东焦街道', '0', '', '1', '0', '0', '10'),
('1801', '130000', '130100', '130105', '1', '1', '西苑街道', '0', '', '1', '0', '0', '10'),
('1802', '130000', '130100', '130105', '1', '1', '合作路街道', '0', '', '1', '0', '0', '10'),
('1803', '130000', '130100', '130105', '1', '1', '联盟路街道', '0', '', '1', '0', '0', '10'),
('1804', '130000', '130100', '130105', '1', '1', '石岗大街街道', '0', '', '1', '0', '0', '10'),
('1805', '130000', '130100', '130105', '1', '1', '五七路街道', '0', '', '1', '0', '0', '10'),
('1806', '130000', '130100', '130105', '1', '1', '天苑街道', '0', '', '1', '0', '0', '10'),
('1807', '130000', '130100', '130105', '1', '1', '北苑街道', '0', '', '1', '0', '0', '10'),
('1808', '130000', '130100', '130105', '1', '1', '大郭镇', '0', '', '1', '0', '0', '10'),
('1809', '130000', '130100', '130105', '1', '1', '赵陵铺镇', '0', '', '1', '0', '0', '10'),
('1810', '130000', '130100', '130105', '1', '1', '西三庄乡', '0', '', '1', '0', '0', '10'),
('1811', '130000', '130100', '130105', '1', '1', '杜北乡', '0', '', '1', '0', '0', '10'),
('1812', '130000', '130100', '130107', '1', '1', '矿市街街道', '0', '', '1', '0', '0', '10'),
('1813', '130000', '130100', '130107', '1', '1', '四微街道', '0', '', '1', '0', '0', '10'),
('1814', '130000', '130100', '130107', '1', '1', '贾庄镇', '0', '', '1', '0', '0', '10'),
('1815', '130000', '130100', '130107', '1', '1', '凤山镇', '0', '', '1', '0', '0', '10'),
('1816', '130000', '130100', '130107', '1', '1', '横涧乡', '0', '', '1', '0', '0', '10'),
('1817', '130000', '130100', '130108', '1', '1', '裕兴街道', '0', '', '1', '0', '0', '10'),
('1818', '130000', '130100', '130108', '1', '1', '裕强街道', '0', '', '1', '0', '0', '10'),
('1819', '130000', '130100', '130108', '1', '1', '东苑街道', '0', '', '1', '0', '0', '10'),
('1820', '130000', '130100', '130108', '1', '1', '建通街道', '0', '', '1', '0', '0', '10'),
('1821', '130000', '130100', '130108', '1', '1', '槐底街道', '0', '', '1', '0', '0', '10'),
('1822', '130000', '130100', '130108', '1', '1', '裕华路街道', '0', '', '1', '0', '0', '10'),
('1823', '130000', '130100', '130108', '1', '1', '裕东街道', '0', '', '1', '0', '0', '10'),
('1824', '130000', '130100', '130108', '1', '1', '长江街道办事处(高新区)', '0', '', '1', '0', '0', '10'),
('1825', '130000', '130100', '130108', '1', '1', '宋营镇', '0', '', '1', '0', '0', '10'),
('1826', '130000', '130100', '130108', '1', '1', '方村镇', '0', '', '1', '0', '0', '10'),
('1827', '130000', '130100', '130121', '1', '1', '微水镇', '0', '', '1', '0', '0', '10'),
('1828', '130000', '130100', '130121', '1', '1', '上安镇', '0', '', '1', '0', '0', '10'),
('1829', '130000', '130100', '130121', '1', '1', '天长镇', '0', '', '1', '0', '0', '10'),
('1830', '130000', '130100', '130121', '1', '1', '秀林镇', '0', '', '1', '0', '0', '10'),
('1831', '130000', '130100', '130121', '1', '1', '南峪镇', '0', '', '1', '0', '0', '10'),
('1832', '130000', '130100', '130121', '1', '1', '威州镇', '0', '', '1', '0', '0', '10'),
('1833', '130000', '130100', '130121', '1', '1', '小作镇', '0', '', '1', '0', '0', '10'),
('1834', '130000', '130100', '130121', '1', '1', '南障城镇', '0', '', '1', '0', '0', '10'),
('1835', '130000', '130100', '130121', '1', '1', '苍岩山镇', '0', '', '1', '0', '0', '10'),
('1836', '130000', '130100', '130121', '1', '1', '测鱼镇', '0', '', '1', '0', '0', '10'),
('1837', '130000', '130100', '130121', '1', '1', '吴家窑乡', '0', '', '1', '0', '0', '10'),
('1838', '130000', '130100', '130121', '1', '1', '北正乡', '0', '', '1', '0', '0', '10'),
('1839', '130000', '130100', '130121', '1', '1', '于家乡', '0', '', '1', '0', '0', '10'),
('1840', '130000', '130100', '130121', '1', '1', '孙庄乡', '0', '', '1', '0', '0', '10'),
('1841', '130000', '130100', '130121', '1', '1', '南陉乡', '0', '', '1', '0', '0', '10'),
('1842', '130000', '130100', '130121', '1', '1', '辛庄乡', '0', '', '1', '0', '0', '10'),
('1843', '130000', '130100', '130121', '1', '1', '南王庄乡', '0', '', '1', '0', '0', '10'),
('1844', '130000', '130100', '130123', '1', '1', '正定镇', '0', '', '1', '0', '0', '10'),
('1845', '130000', '130100', '130123', '1', '1', '诸福屯镇', '0', '', '1', '0', '0', '10'),
('1846', '130000', '130100', '130123', '1', '1', '新城铺镇', '0', '', '1', '0', '0', '10'),
('1847', '130000', '130100', '130123', '1', '1', '新安镇', '0', '', '1', '0', '0', '10'),
('1848', '130000', '130100', '130123', '1', '1', '南牛乡', '0', '', '1', '0', '0', '10'),
('1849', '130000', '130100', '130123', '1', '1', '南楼乡', '0', '', '1', '0', '0', '10'),
('1850', '130000', '130100', '130123', '1', '1', '西平乐乡', '0', '', '1', '0', '0', '10'),
('1851', '130000', '130100', '130123', '1', '1', '北早现乡', '0', '', '1', '0', '0', '10'),
('1852', '130000', '130100', '130123', '1', '1', '曲阳桥乡', '0', '', '1', '0', '0', '10'),
('1853', '130000', '130100', '130124', '1', '1', '栾城镇', '0', '', '1', '0', '0', '10'),
('1854', '130000', '130100', '130124', '1', '1', '郄马镇', '0', '', '1', '0', '0', '10'),
('1855', '130000', '130100', '130124', '1', '1', '冶河镇', '0', '', '1', '0', '0', '10'),
('1856', '130000', '130100', '130124', '1', '1', '窦妪镇', '0', '', '1', '0', '0', '10'),
('1857', '130000', '130100', '130124', '1', '1', '楼底镇', '0', '', '1', '0', '0', '10'),
('1858', '130000', '130100', '130124', '1', '1', '南高乡', '0', '', '1', '0', '0', '10'),
('1859', '130000', '130100', '130124', '1', '1', '柳林屯乡', '0', '', '1', '0', '0', '10'),
('1860', '130000', '130100', '130124', '1', '1', '西营乡', '0', '', '1', '0', '0', '10'),
('1861', '130000', '130100', '130125', '1', '1', '龙州镇', '0', '', '1', '0', '0', '10'),
('1862', '130000', '130100', '130125', '1', '1', '南桥镇', '0', '', '1', '0', '0', '10'),
('1863', '130000', '130100', '130125', '1', '1', '上碑镇', '0', '', '1', '0', '0', '10'),
('1864', '130000', '130100', '130125', '1', '1', '口头镇', '0', '', '1', '0', '0', '10'),
('1865', '130000', '130100', '130125', '1', '1', '独羊岗乡', '0', '', '1', '0', '0', '10'),
('1866', '130000', '130100', '130125', '1', '1', '安香乡', '0', '', '1', '0', '0', '10'),
('1867', '130000', '130100', '130125', '1', '1', '只里乡', '0', '', '1', '0', '0', '10'),
('1868', '130000', '130100', '130125', '1', '1', '市同乡', '0', '', '1', '0', '0', '10'),
('1869', '130000', '130100', '130125', '1', '1', '翟营乡', '0', '', '1', '0', '0', '10'),
('1870', '130000', '130100', '130125', '1', '1', '城寨乡', '0', '', '1', '0', '0', '10'),
('1871', '130000', '130100', '130125', '1', '1', '上方乡', '0', '', '1', '0', '0', '10'),
('1872', '130000', '130100', '130125', '1', '1', '玉亭乡', '0', '', '1', '0', '0', '10'),
('1873', '130000', '130100', '130125', '1', '1', '北河乡', '0', '', '1', '0', '0', '10'),
('1874', '130000', '130100', '130125', '1', '1', '上闫庄乡', '0', '', '1', '0', '0', '10'),
('1875', '130000', '130100', '130125', '1', '1', '九口子乡', '0', '', '1', '0', '0', '10'),
('1876', '130000', '130100', '130126', '1', '1', '灵寿镇', '0', '', '1', '0', '0', '10'),
('1877', '130000', '130100', '130126', '1', '1', '青同镇', '0', '', '1', '0', '0', '10'),
('1878', '130000', '130100', '130126', '1', '1', '塔上镇', '0', '', '1', '0', '0', '10'),
('1879', '130000', '130100', '130126', '1', '1', '陈庄镇', '0', '', '1', '0', '0', '10'),
('1880', '130000', '130100', '130126', '1', '1', '慈峪镇', '0', '', '1', '0', '0', '10'),
('1881', '130000', '130100', '130126', '1', '1', '岔头镇', '0', '', '1', '0', '0', '10'),
('1882', '130000', '130100', '130126', '1', '1', '三圣院乡', '0', '', '1', '0', '0', '10'),
('1883', '130000', '130100', '130126', '1', '1', '北洼乡', '0', '', '1', '0', '0', '10'),
('1884', '130000', '130100', '130126', '1', '1', '牛城乡', '0', '', '1', '0', '0', '10'),
('1885', '130000', '130100', '130126', '1', '1', '狗台乡', '0', '', '1', '0', '0', '10'),
('1886', '130000', '130100', '130126', '1', '1', '南寨乡', '0', '', '1', '0', '0', '10'),
('1887', '130000', '130100', '130126', '1', '1', '南燕川乡', '0', '', '1', '0', '0', '10'),
('1888', '130000', '130100', '130126', '1', '1', '北谭庄乡', '0', '', '1', '0', '0', '10'),
('1889', '130000', '130100', '130126', '1', '1', '寨头乡', '0', '', '1', '0', '0', '10'),
('1890', '130000', '130100', '130126', '1', '1', '南营乡', '0', '', '1', '0', '0', '10'),
('1891', '130000', '130100', '130127', '1', '1', '高邑镇', '0', '', '1', '0', '0', '10'),
('1892', '130000', '130100', '130127', '1', '1', '大营乡', '0', '', '1', '0', '0', '10'),
('1893', '130000', '130100', '130127', '1', '1', '中韩乡', '0', '', '1', '0', '0', '10'),
('1894', '130000', '130100', '130127', '1', '1', '万城乡', '0', '', '1', '0', '0', '10'),
('1895', '130000', '130100', '130127', '1', '1', '西富村乡', '0', '', '1', '0', '0', '10'),
('1896', '130000', '130100', '130128', '1', '1', '深泽镇', '0', '', '1', '0', '0', '10'),
('1897', '130000', '130100', '130128', '1', '1', '铁杆镇', '0', '', '1', '0', '0', '10'),
('1898', '130000', '130100', '130128', '1', '1', '白庄乡', '0', '', '1', '0', '0', '10'),
('1899', '130000', '130100', '130128', '1', '1', '留村乡', '0', '', '1', '0', '0', '10'),
('1900', '130000', '130100', '130128', '1', '1', '赵八乡', '0', '', '1', '0', '0', '10'),
('1901', '130000', '130100', '130128', '1', '1', '桥头乡', '0', '', '1', '0', '0', '10'),
('1902', '130000', '130100', '130129', '1', '1', '赞皇镇', '0', '', '1', '0', '0', '10'),
('1903', '130000', '130100', '130129', '1', '1', '院头镇', '0', '', '1', '0', '0', '10'),
('1904', '130000', '130100', '130129', '1', '1', '西龙门乡', '0', '', '1', '0', '0', '10'),
('1905', '130000', '130100', '130129', '1', '1', '南邢郭乡', '0', '', '1', '0', '0', '10'),
('1906', '130000', '130100', '130129', '1', '1', '南清河乡', '0', '', '1', '0', '0', '10'),
('1907', '130000', '130100', '130129', '1', '1', '西阳泽乡', '0', '', '1', '0', '0', '10'),
('1908', '130000', '130100', '130129', '1', '1', '土门乡', '0', '', '1', '0', '0', '10'),
('1909', '130000', '130100', '130129', '1', '1', '黄北坪乡', '0', '', '1', '0', '0', '10'),
('1910', '130000', '130100', '130129', '1', '1', '嶂石岩乡', '0', '', '1', '0', '0', '10'),
('1911', '130000', '130100', '130129', '1', '1', '许亭乡', '0', '', '1', '0', '0', '10'),
('1912', '130000', '130100', '130129', '1', '1', '张楞乡', '0', '', '1', '0', '0', '10'),
('1913', '130000', '130100', '130130', '1', '1', '无极镇', '0', '', '1', '0', '0', '10'),
('1914', '130000', '130100', '130130', '1', '1', '七汲镇', '0', '', '1', '0', '0', '10'),
('1915', '130000', '130100', '130130', '1', '1', '张段固镇', '0', '', '1', '0', '0', '10'),
('1916', '130000', '130100', '130130', '1', '1', '北苏镇', '0', '', '1', '0', '0', '10'),
('1917', '130000', '130100', '130130', '1', '1', '郭庄镇', '0', '', '1', '0', '0', '10'),
('1918', '130000', '130100', '130130', '1', '1', '大陈镇', '0', '', '1', '0', '0', '10'),
('1919', '130000', '130100', '130130', '1', '1', '高头乡', '0', '', '1', '0', '0', '10'),
('1920', '130000', '130100', '130130', '1', '1', '郝庄乡', '0', '', '1', '0', '0', '10'),
('1921', '130000', '130100', '130130', '1', '1', '东侯坊乡', '0', '', '1', '0', '0', '10'),
('1922', '130000', '130100', '130130', '1', '1', '里城道乡', '0', '', '1', '0', '0', '10'),
('1923', '130000', '130100', '130130', '1', '1', '南流乡', '0', '', '1', '0', '0', '10'),
('1924', '130000', '130100', '130131', '1', '1', '平山镇', '0', '', '1', '0', '0', '10'),
('1925', '130000', '130100', '130131', '1', '1', '东回舍镇', '0', '', '1', '0', '0', '10'),
('1926', '130000', '130100', '130131', '1', '1', '温塘镇', '0', '', '1', '0', '0', '10'),
('1927', '130000', '130100', '130131', '1', '1', '南甸镇', '0', '', '1', '0', '0', '10'),
('1928', '130000', '130100', '130131', '1', '1', '岗南镇', '0', '', '1', '0', '0', '10'),
('1929', '130000', '130100', '130131', '1', '1', '中古月镇', '0', '', '1', '0', '0', '10'),
('1930', '130000', '130100', '130131', '1', '1', '下槐镇', '0', '', '1', '0', '0', '10'),
('1931', '130000', '130100', '130131', '1', '1', '孟家庄镇', '0', '', '1', '0', '0', '10'),
('1932', '130000', '130100', '130131', '1', '1', '小觉镇', '0', '', '1', '0', '0', '10'),
('1933', '130000', '130100', '130131', '1', '1', '蛟潭庄镇', '0', '', '1', '0', '0', '10'),
('1934', '130000', '130100', '130131', '1', '1', '西柏坡镇', '0', '', '1', '0', '0', '10'),
('1935', '130000', '130100', '130131', '1', '1', '下口镇', '0', '', '1', '0', '0', '10'),
('1936', '130000', '130100', '130131', '1', '1', '西大吾乡', '0', '', '1', '0', '0', '10'),
('1937', '130000', '130100', '130131', '1', '1', '上三汲乡', '0', '', '1', '0', '0', '10'),
('1938', '130000', '130100', '130131', '1', '1', '两河乡', '0', '', '1', '0', '0', '10'),
('1939', '130000', '130100', '130131', '1', '1', '东王坡乡', '0', '', '1', '0', '0', '10'),
('1940', '130000', '130100', '130131', '1', '1', '苏家庄乡', '0', '', '1', '0', '0', '10'),
('1941', '130000', '130100', '130131', '1', '1', '宅北乡', '0', '', '1', '0', '0', '10'),
('1942', '130000', '130100', '130131', '1', '1', '北冶乡', '0', '', '1', '0', '0', '10'),
('1943', '130000', '130100', '130131', '1', '1', '上观音堂乡', '0', '', '1', '0', '0', '10'),
('1944', '130000', '130100', '130131', '1', '1', '杨家桥乡', '0', '', '1', '0', '0', '10'),
('1945', '130000', '130100', '130131', '1', '1', '营里乡', '0', '', '1', '0', '0', '10'),
('1946', '130000', '130100', '130131', '1', '1', '合河口乡', '0', '', '1', '0', '0', '10'),
('1947', '130000', '130100', '130132', '1', '1', '槐阳镇', '0', '', '1', '0', '0', '10'),
('1948', '130000', '130100', '130132', '1', '1', '因村镇', '0', '', '1', '0', '0', '10'),
('1949', '130000', '130100', '130132', '1', '1', '南佐镇', '0', '', '1', '0', '0', '10'),
('1950', '130000', '130100', '130132', '1', '1', '宋曹镇', '0', '', '1', '0', '0', '10'),
('1951', '130000', '130100', '130132', '1', '1', '南因镇', '0', '', '1', '0', '0', '10'),
('1952', '130000', '130100', '130132', '1', '1', '姬村镇', '0', '', '1', '0', '0', '10'),
('1953', '130000', '130100', '130132', '1', '1', '马村乡', '0', '', '1', '0', '0', '10'),
('1954', '130000', '130100', '130132', '1', '1', '东张乡', '0', '', '1', '0', '0', '10'),
('1955', '130000', '130100', '130132', '1', '1', '赵同乡', '0', '', '1', '0', '0', '10'),
('1956', '130000', '130100', '130132', '1', '1', '北褚乡', '0', '', '1', '0', '0', '10'),
('1957', '130000', '130100', '130132', '1', '1', '苏村乡', '0', '', '1', '0', '0', '10'),
('1958', '130000', '130100', '130132', '1', '1', '苏阳乡', '0', '', '1', '0', '0', '10'),
('1959', '130000', '130100', '130132', '1', '1', '北正乡', '0', '', '1', '0', '0', '10'),
('1960', '130000', '130100', '130132', '1', '1', '前仙乡', '0', '', '1', '0', '0', '10'),
('1961', '130000', '130100', '130132', '1', '1', '黑水河乡', '0', '', '1', '0', '0', '10'),
('1962', '130000', '130100', '130133', '1', '1', '赵州镇', '0', '', '1', '0', '0', '10'),
('1963', '130000', '130100', '130133', '1', '1', '范庄镇', '0', '', '1', '0', '0', '10'),
('1964', '130000', '130100', '130133', '1', '1', '北王里镇', '0', '', '1', '0', '0', '10'),
('1965', '130000', '130100', '130133', '1', '1', '新寨店镇', '0', '', '1', '0', '0', '10'),
('1966', '130000', '130100', '130133', '1', '1', '韩村镇', '0', '', '1', '0', '0', '10'),
('1967', '130000', '130100', '130133', '1', '1', '南柏舍镇', '0', '', '1', '0', '0', '10'),
('1968', '130000', '130100', '130133', '1', '1', '沙河店镇', '0', '', '1', '0', '0', '10'),
('1969', '130000', '130100', '130133', '1', '1', '前大章乡', '0', '', '1', '0', '0', '10'),
('1970', '130000', '130100', '130133', '1', '1', '谢庄乡', '0', '', '1', '0', '0', '10'),
('1971', '130000', '130100', '130133', '1', '1', '高村乡', '0', '', '1', '0', '0', '10'),
('1972', '130000', '130100', '130133', '1', '1', '王西章乡', '0', '', '1', '0', '0', '10'),
('1973', '130000', '130100', '130181', '1', '1', '辛集镇', '0', '', '1', '0', '0', '10'),
('1974', '130000', '130100', '130181', '1', '1', '旧城镇', '0', '', '1', '0', '0', '10'),
('1975', '130000', '130100', '130181', '1', '1', '张古庄镇', '0', '', '1', '0', '0', '10'),
('1976', '130000', '130100', '130181', '1', '1', '位伯镇', '0', '', '1', '0', '0', '10'),
('1977', '130000', '130100', '130181', '1', '1', '新垒头镇', '0', '', '1', '0', '0', '10'),
('1978', '130000', '130100', '130181', '1', '1', '新城镇', '0', '', '1', '0', '0', '10'),
('1979', '130000', '130100', '130181', '1', '1', '南智丘镇', '0', '', '1', '0', '0', '10'),
('1980', '130000', '130100', '130181', '1', '1', '王口镇', '0', '', '1', '0', '0', '10'),
('1981', '130000', '130100', '130181', '1', '1', '天宫营乡', '0', '', '1', '0', '0', '10'),
('1982', '130000', '130100', '130181', '1', '1', '前营乡', '0', '', '1', '0', '0', '10'),
('1983', '130000', '130100', '130181', '1', '1', '马庄乡', '0', '', '1', '0', '0', '10'),
('1984', '130000', '130100', '130181', '1', '1', '和睦井乡', '0', '', '1', '0', '0', '10'),
('1985', '130000', '130100', '130181', '1', '1', '田家庄乡', '0', '', '1', '0', '0', '10'),
('1986', '130000', '130100', '130181', '1', '1', '中里厢乡', '0', '', '1', '0', '0', '10'),
('1987', '130000', '130100', '130181', '1', '1', '小辛庄乡', '0', '', '1', '0', '0', '10'),
('1988', '130000', '130100', '130182', '1', '1', '廉州镇', '0', '', '1', '0', '0', '10'),
('1989', '130000', '130100', '130182', '1', '1', '兴安镇', '0', '', '1', '0', '0', '10'),
('1990', '130000', '130100', '130182', '1', '1', '贾市庄镇', '0', '', '1', '0', '0', '10'),
('1991', '130000', '130100', '130182', '1', '1', '南营镇', '0', '', '1', '0', '0', '10'),
('1992', '130000', '130100', '130182', '1', '1', '梅花镇', '0', '', '1', '0', '0', '10'),
('1993', '130000', '130100', '130182', '1', '1', '岗上镇', '0', '', '1', '0', '0', '10'),
('1994', '130000', '130100', '130182', '1', '1', '邱头镇', '0', '', '1', '0', '0', '10'),
('1995', '130000', '130100', '130182', '1', '1', '南董镇', '0', '', '1', '0', '0', '10'),
('1996', '130000', '130100', '130182', '1', '1', '张家庄镇', '0', '', '1', '0', '0', '10'),
('1997', '130000', '130100', '130182', '1', '1', '南孟镇', '0', '', '1', '0', '0', '10'),
('1998', '130000', '130100', '130182', '1', '1', '增村镇', '0', '', '1', '0', '0', '10'),
('1999', '130000', '130100', '130182', '1', '1', '小常安镇', '0', '', '1', '0', '0', '10'),
('2000', '130000', '130100', '130182', '1', '1', '前西关镇', '0', '', '1', '0', '0', '10'),
('2001', '130000', '130100', '130182', '1', '1', '九门回族乡', '0', '', '1', '0', '0', '10'),
('2002', '130000', '130100', '130182', '1', '1', '石家庄经济技术开发区虚拟乡', '0', '', '1', '0', '0', '10'),
('2003', '130000', '130100', '130183', '1', '1', '晋州镇', '0', '', '1', '0', '0', '10'),
('2004', '130000', '130100', '130183', '1', '1', '总十庄镇', '0', '', '1', '0', '0', '10'),
('2005', '130000', '130100', '130183', '1', '1', '营里镇', '0', '', '1', '0', '0', '10'),
('2006', '130000', '130100', '130183', '1', '1', '桃园镇', '0', '', '1', '0', '0', '10'),
('2007', '130000', '130100', '130183', '1', '1', '东卓宿镇', '0', '', '1', '0', '0', '10'),
('2008', '130000', '130100', '130183', '1', '1', '马于镇', '0', '', '1', '0', '0', '10'),
('2009', '130000', '130100', '130183', '1', '1', '小樵镇', '0', '', '1', '0', '0', '10'),
('2010', '130000', '130100', '130183', '1', '1', '槐树镇', '0', '', '1', '0', '0', '10'),
('2011', '130000', '130100', '130183', '1', '1', '东里庄乡', '0', '', '1', '0', '0', '10'),
('2012', '130000', '130100', '130183', '1', '1', '周家庄乡', '0', '', '1', '0', '0', '10'),
('2013', '130000', '130100', '130184', '1', '1', '长寿街道', '0', '', '1', '0', '0', '10'),
('2014', '130000', '130100', '130184', '1', '1', '化皮镇', '0', '', '1', '0', '0', '10'),
('2015', '130000', '130100', '130184', '1', '1', '承安镇', '0', '', '1', '0', '0', '10'),
('2016', '130000', '130100', '130184', '1', '1', '正莫镇', '0', '', '1', '0', '0', '10'),
('2017', '130000', '130100', '130184', '1', '1', '南大岳镇', '0', '', '1', '0', '0', '10'),
('2018', '130000', '130100', '130184', '1', '1', '杜固镇', '0', '', '1', '0', '0', '10'),
('2019', '130000', '130100', '130184', '1', '1', '邯邰镇', '0', '', '1', '0', '0', '10'),
('2020', '130000', '130100', '130184', '1', '1', '东王镇', '0', '', '1', '0', '0', '10'),
('2021', '130000', '130100', '130184', '1', '1', '马头铺镇', '0', '', '1', '0', '0', '10'),
('2022', '130000', '130100', '130184', '1', '1', '协神乡', '0', '', '1', '0', '0', '10'),
('2023', '130000', '130100', '130184', '1', '1', '木村乡', '0', '', '1', '0', '0', '10'),
('2024', '130000', '130100', '130184', '1', '1', '彭家庄乡', '0', '', '1', '0', '0', '10'),
('2025', '130000', '130100', '130185', '1', '1', '获鹿镇', '0', '', '1', '0', '0', '10'),
('2026', '130000', '130100', '130185', '1', '1', '铜冶镇', '0', '', '1', '0', '0', '10'),
('2027', '130000', '130100', '130185', '1', '1', '寺家庄镇', '0', '', '1', '0', '0', '10'),
('2028', '130000', '130100', '130185', '1', '1', '上庄镇', '0', '', '1', '0', '0', '10'),
('2029', '130000', '130100', '130185', '1', '1', '李村镇', '0', '', '1', '0', '0', '10'),
('2030', '130000', '130100', '130185', '1', '1', '宜安镇', '0', '', '1', '0', '0', '10'),
('2031', '130000', '130100', '130185', '1', '1', '黄壁庄镇', '0', '', '1', '0', '0', '10'),
('2032', '130000', '130100', '130185', '1', '1', '大河镇', '0', '', '1', '0', '0', '10'),
('2033', '130000', '130100', '130185', '1', '1', '石井乡', '0', '', '1', '0', '0', '10'),
('2034', '130000', '130100', '130185', '1', '1', '白鹿泉乡', '0', '', '1', '0', '0', '10'),
('2035', '130000', '130100', '130185', '1', '1', '上寨乡', '0', '', '1', '0', '0', '10'),
('2036', '130000', '130100', '130185', '1', '1', '山尹村乡', '0', '', '1', '0', '0', '10'),
('2037', '130000', '130100', '130185', '1', '1', '高新技术产业园区虚拟乡', '0', '', '1', '0', '0', '10'),
('2038', '130000', '130200', '130202', '1', '1', '学院南路', '0', '', '1', '0', '0', '10'),
('2039', '130000', '130200', '130202', '1', '1', '友谊', '0', '', '1', '0', '0', '10'),
('2040', '130000', '130200', '130202', '1', '1', '广场', '0', '', '1', '0', '0', '10'),
('2041', '130000', '130200', '130202', '1', '1', '永红桥街道', '0', '', '1', '0', '0', '10'),
('2042', '130000', '130200', '130202', '1', '1', '小山街道', '0', '', '1', '0', '0', '10'),
('2043', '130000', '130200', '130202', '1', '1', '文北', '0', '', '1', '0', '0', '10'),
('2044', '130000', '130200', '130202', '1', '1', '钱营', '0', '', '1', '0', '0', '10'),
('2045', '130000', '130200', '130202', '1', '1', '芦台开发区海北镇', '0', '', '1', '0', '0', '10'),
('2046', '130000', '130200', '130202', '1', '1', '汉沽管理区汉丰镇', '0', '', '1', '0', '0', '10'),
('2047', '130000', '130200', '130202', '1', '1', '女织寨乡', '0', '', '1', '0', '0', '10'),
('2048', '130000', '130200', '130202', '1', '1', '芦台开发区街道', '0', '', '1', '0', '0', '10'),
('2049', '130000', '130200', '130202', '1', '1', '汉沽管理区兴农', '0', '', '1', '0', '0', '10'),
('2050', '130000', '130200', '130202', '1', '1', '汉沽管理区振兴街道', '0', '', '1', '0', '0', '10'),
('2051', '130000', '130200', '130203', '1', '1', '乔屯街道', '0', '', '1', '0', '0', '10'),
('2052', '130000', '130200', '130203', '1', '1', '文化路街道', '0', '', '1', '0', '0', '10'),
('2053', '130000', '130200', '130203', '1', '1', '钓鱼台街道', '0', '', '1', '0', '0', '10'),
('2054', '130000', '130200', '130203', '1', '1', '东新村街道', '0', '', '1', '0', '0', '10'),
('2055', '130000', '130200', '130203', '1', '1', '缸窑街道', '0', '', '1', '0', '0', '10'),
('2056', '130000', '130200', '130203', '1', '1', '机场路街道', '0', '', '1', '0', '0', '10'),
('2057', '130000', '130200', '130203', '1', '1', '河北路街道', '0', '', '1', '0', '0', '10'),
('2058', '130000', '130200', '130203', '1', '1', '龙东街道', '0', '', '1', '0', '0', '10'),
('2059', '130000', '130200', '130203', '1', '1', '大里街道', '0', '', '1', '0', '0', '10'),
('2060', '130000', '130200', '130203', '1', '1', '光明街道', '0', '', '1', '0', '0', '10'),
('2061', '130000', '130200', '130203', '1', '1', '果园乡', '0', '', '1', '0', '0', '10'),
('2062', '130000', '130200', '130203', '1', '1', '河北唐山高新技术产业园区', '0', '', '1', '0', '0', '10'),
('2063', '130000', '130200', '130204', '1', '1', '林西街道', '0', '', '1', '0', '0', '10'),
('2064', '130000', '130200', '130204', '1', '1', '唐家庄街道', '0', '', '1', '0', '0', '10'),
('2065', '130000', '130200', '130204', '1', '1', '古冶街道', '0', '', '1', '0', '0', '10'),
('2066', '130000', '130200', '130204', '1', '1', '赵各庄街道', '0', '', '1', '0', '0', '10'),
('2067', '130000', '130200', '130204', '1', '1', '吕家坨街道', '0', '', '1', '0', '0', '10'),
('2068', '130000', '130200', '130204', '1', '1', '南范各庄街道', '0', '', '1', '0', '0', '10'),
('2069', '130000', '130200', '130204', '1', '1', '卑家店乡', '0', '', '1', '0', '0', '10'),
('2070', '130000', '130200', '130204', '1', '1', '王辇庄乡', '0', '', '1', '0', '0', '10'),
('2071', '130000', '130200', '130204', '1', '1', '习家套乡', '0', '', '1', '0', '0', '10'),
('2072', '130000', '130200', '130204', '1', '1', '大庄坨乡', '0', '', '1', '0', '0', '10'),
('2073', '130000', '130200', '130204', '1', '1', '范各庄乡', '0', '', '1', '0', '0', '10'),
('2074', '130000', '130200', '130205', '1', '1', '马家沟', '0', '', '1', '0', '0', '10'),
('2075', '130000', '130200', '130205', '1', '1', '开平', '0', '', '1', '0', '0', '10'),
('2076', '130000', '130200', '130205', '1', '1', '税务庄', '0', '', '1', '0', '0', '10'),
('2077', '130000', '130200', '130205', '1', '1', '陡电', '0', '', '1', '0', '0', '10'),
('2078', '130000', '130200', '130205', '1', '1', '荆各庄', '0', '', '1', '0', '0', '10'),
('2079', '130000', '130200', '130205', '1', '1', '开平镇', '0', '', '1', '0', '0', '10'),
('2080', '130000', '130200', '130205', '1', '1', '栗园镇', '0', '', '1', '0', '0', '10'),
('2081', '130000', '130200', '130205', '1', '1', '越河乡', '0', '', '1', '0', '0', '10'),
('2082', '130000', '130200', '130205', '1', '1', '双桥乡', '0', '', '1', '0', '0', '10'),
('2083', '130000', '130200', '130205', '1', '1', '郑庄子乡', '0', '', '1', '0', '0', '10'),
('2084', '130000', '130200', '130205', '1', '1', '洼里乡', '0', '', '1', '0', '0', '10'),
('2085', '130000', '130200', '130207', '1', '1', '稻地镇', '0', '', '1', '0', '0', '10'),
('2086', '130000', '130200', '130207', '1', '1', '小集镇', '0', '', '1', '0', '0', '10'),
('2087', '130000', '130200', '130207', '1', '1', '黄各庄镇', '0', '', '1', '0', '0', '10'),
('2088', '130000', '130200', '130207', '1', '1', '西葛镇', '0', '', '1', '0', '0', '10'),
('2089', '130000', '130200', '130207', '1', '1', '大新庄镇', '0', '', '1', '0', '0', '10'),
('2090', '130000', '130200', '130207', '1', '1', '钱营镇', '0', '', '1', '0', '0', '10'),
('2091', '130000', '130200', '130207', '1', '1', '唐坊镇', '0', '', '1', '0', '0', '10'),
('2092', '130000', '130200', '130207', '1', '1', '王兰庄镇', '0', '', '1', '0', '0', '10'),
('2093', '130000', '130200', '130207', '1', '1', '柳树酄镇', '0', '', '1', '0', '0', '10'),
('2094', '130000', '130200', '130207', '1', '1', '黑沿子镇', '0', '', '1', '0', '0', '10'),
('2095', '130000', '130200', '130207', '1', '1', '滨海镇', '0', '', '1', '0', '0', '10'),
('2096', '130000', '130200', '130207', '1', '1', '丰南镇', '0', '', '1', '0', '0', '10'),
('2097', '130000', '130200', '130207', '1', '1', '大齐镇', '0', '', '1', '0', '0', '10'),
('2098', '130000', '130200', '130207', '1', '1', '南孙庄乡', '0', '', '1', '0', '0', '10'),
('2099', '130000', '130200', '130207', '1', '1', '东田庄乡', '0', '', '1', '0', '0', '10'),
('2100', '130000', '130200', '130207', '1', '1', '尖字沽乡', '0', '', '1', '0', '0', '10'),
('2101', '130000', '130200', '130207', '1', '1', '河北唐山南堡经济开发区', '0', '', '1', '0', '0', '10'),
('2102', '130000', '130200', '130208', '1', '1', '太平路', '0', '', '1', '0', '0', '10'),
('2103', '130000', '130200', '130208', '1', '1', '燕山路', '0', '', '1', '0', '0', '10'),
('2104', '130000', '130200', '130208', '1', '1', '浭阳', '0', '', '1', '0', '0', '10'),
('2105', '130000', '130200', '130208', '1', '1', '丰润镇', '0', '', '1', '0', '0', '10'),
('2106', '130000', '130200', '130208', '1', '1', '老庄子镇', '0', '', '1', '0', '0', '10'),
('2107', '130000', '130200', '130208', '1', '1', '任各庄镇', '0', '', '1', '0', '0', '10'),
('2108', '130000', '130200', '130208', '1', '1', '左家坞镇', '0', '', '1', '0', '0', '10'),
('2109', '130000', '130200', '130208', '1', '1', '泉河头镇', '0', '', '1', '0', '0', '10'),
('2110', '130000', '130200', '130208', '1', '1', '王官营镇', '0', '', '1', '0', '0', '10'),
('2111', '130000', '130200', '130208', '1', '1', '火石营镇', '0', '', '1', '0', '0', '10'),
('2112', '130000', '130200', '130208', '1', '1', '韩城镇', '0', '', '1', '0', '0', '10'),
('2113', '130000', '130200', '130208', '1', '1', '岔河镇', '0', '', '1', '0', '0', '10'),
('2114', '130000', '130200', '130208', '1', '1', '新军屯镇', '0', '', '1', '0', '0', '10'),
('2115', '130000', '130200', '130208', '1', '1', '小张各庄镇', '0', '', '1', '0', '0', '10'),
('2116', '130000', '130200', '130208', '1', '1', '丰登坞镇', '0', '', '1', '0', '0', '10'),
('2117', '130000', '130200', '130208', '1', '1', '李钊庄镇', '0', '', '1', '0', '0', '10'),
('2118', '130000', '130200', '130208', '1', '1', '白官屯镇', '0', '', '1', '0', '0', '10'),
('2119', '130000', '130200', '130208', '1', '1', '石各庄镇', '0', '', '1', '0', '0', '10'),
('2120', '130000', '130200', '130208', '1', '1', '沙流河镇', '0', '', '1', '0', '0', '10'),
('2121', '130000', '130200', '130208', '1', '1', '七树庄镇', '0', '', '1', '0', '0', '10'),
('2122', '130000', '130200', '130208', '1', '1', '杨官林镇', '0', '', '1', '0', '0', '10'),
('2123', '130000', '130200', '130208', '1', '1', '姜家营乡', '0', '', '1', '0', '0', '10'),
('2124', '130000', '130200', '130208', '1', '1', '欢喜庄乡', '0', '', '1', '0', '0', '10'),
('2125', '130000', '130200', '130208', '1', '1', '银城铺乡', '0', '', '1', '0', '0', '10'),
('2126', '130000', '130200', '130208', '1', '1', '刘家营乡', '0', '', '1', '0', '0', '10'),
('2127', '130000', '130200', '130208', '1', '1', '常庄乡', '0', '', '1', '0', '0', '10'),
('2128', '130000', '130200', '130223', '1', '1', '城区街道', '0', '', '1', '0', '0', '10'),
('2129', '130000', '130200', '130223', '1', '1', '滦州镇', '0', '', '1', '0', '0', '10'),
('2130', '130000', '130200', '130223', '1', '1', '响堂镇', '0', '', '1', '0', '0', '10'),
('2131', '130000', '130200', '130223', '1', '1', '东安各庄镇', '0', '', '1', '0', '0', '10'),
('2132', '130000', '130200', '130223', '1', '1', '雷庄镇', '0', '', '1', '0', '0', '10'),
('2133', '130000', '130200', '130223', '1', '1', '茨榆坨镇', '0', '', '1', '0', '0', '10'),
('2134', '130000', '130200', '130223', '1', '1', '榛子镇', '0', '', '1', '0', '0', '10'),
('2135', '130000', '130200', '130223', '1', '1', '杨柳庄镇', '0', '', '1', '0', '0', '10'),
('2136', '130000', '130200', '130223', '1', '1', '油榨镇', '0', '', '1', '0', '0', '10'),
('2137', '130000', '130200', '130223', '1', '1', '古马镇', '0', '', '1', '0', '0', '10'),
('2138', '130000', '130200', '130223', '1', '1', '小马庄镇', '0', '', '1', '0', '0', '10'),
('2139', '130000', '130200', '130223', '1', '1', '九百户镇', '0', '', '1', '0', '0', '10'),
('2140', '130000', '130200', '130223', '1', '1', '王店子镇', '0', '', '1', '0', '0', '10'),
('2141', '130000', '130200', '130224', '1', '1', '奔城街道', '0', '', '1', '0', '0', '10'),
('2142', '130000', '130200', '130224', '1', '1', '奔城镇', '0', '', '1', '0', '0', '10'),
('2143', '130000', '130200', '130224', '1', '1', '宋道口镇', '0', '', '1', '0', '0', '10'),
('2144', '130000', '130200', '130224', '1', '1', '长凝镇', '0', '', '1', '0', '0', '10'),
('2145', '130000', '130200', '130224', '1', '1', '胡各庄镇', '0', '', '1', '0', '0', '10'),
('2146', '130000', '130200', '130224', '1', '1', '坨里镇', '0', '', '1', '0', '0', '10'),
('2147', '130000', '130200', '130224', '1', '1', '姚王庄镇', '0', '', '1', '0', '0', '10'),
('2148', '130000', '130200', '130224', '1', '1', '司各庄镇', '0', '', '1', '0', '0', '10'),
('2149', '130000', '130200', '130224', '1', '1', '安各庄镇', '0', '', '1', '0', '0', '10'),
('2150', '130000', '130200', '130224', '1', '1', '扒齿港镇', '0', '', '1', '0', '0', '10'),
('2151', '130000', '130200', '130224', '1', '1', '程庄镇', '0', '', '1', '0', '0', '10'),
('2152', '130000', '130200', '130224', '1', '1', '青坨营镇', '0', '', '1', '0', '0', '10'),
('2153', '130000', '130200', '130224', '1', '1', '柏各庄镇', '0', '', '1', '0', '0', '10'),
('2154', '130000', '130200', '130224', '1', '1', '柳赞镇', '0', '', '1', '0', '0', '10'),
('2155', '130000', '130200', '130224', '1', '1', '南堡镇', '0', '', '1', '0', '0', '10'),
('2156', '130000', '130200', '130224', '1', '1', '方各庄镇', '0', '', '1', '0', '0', '10'),
('2157', '130000', '130200', '130224', '1', '1', '东黄坨镇', '0', '', '1', '0', '0', '10'),
('2158', '130000', '130200', '130224', '1', '1', '马城镇', '0', '', '1', '0', '0', '10'),
('2159', '130000', '130200', '130225', '1', '1', '城区街道', '0', '', '1', '0', '0', '10'),
('2160', '130000', '130200', '130225', '1', '1', '乐亭镇', '0', '', '1', '0', '0', '10'),
('2161', '130000', '130200', '130225', '1', '1', '汤家河镇', '0', '', '1', '0', '0', '10'),
('2162', '130000', '130200', '130225', '1', '1', '胡家坨镇', '0', '', '1', '0', '0', '10'),
('2163', '130000', '130200', '130225', '1', '1', '王滩镇', '0', '', '1', '0', '0', '10'),
('2164', '130000', '130200', '130225', '1', '1', '闫各庄镇', '0', '', '1', '0', '0', '10'),
('2165', '130000', '130200', '130225', '1', '1', '马头营镇', '0', '', '1', '0', '0', '10'),
('2166', '130000', '130200', '130225', '1', '1', '新寨镇', '0', '', '1', '0', '0', '10'),
('2167', '130000', '130200', '130225', '1', '1', '汀流河镇', '0', '', '1', '0', '0', '10'),
('2168', '130000', '130200', '130225', '1', '1', '姜各庄镇', '0', '', '1', '0', '0', '10'),
('2169', '130000', '130200', '130225', '1', '1', '毛庄乡', '0', '', '1', '0', '0', '10'),
('2170', '130000', '130200', '130225', '1', '1', '庞各庄乡', '0', '', '1', '0', '0', '10'),
('2171', '130000', '130200', '130225', '1', '1', '大相各庄乡', '0', '', '1', '0', '0', '10'),
('2172', '130000', '130200', '130225', '1', '1', '古河乡', '0', '', '1', '0', '0', '10'),
('2173', '130000', '130200', '130225', '1', '1', '中堡王庄乡', '0', '', '1', '0', '0', '10'),
('2174', '130000', '130200', '130225', '1', '1', '长芦大清河盐场', '0', '', '1', '0', '0', '10'),
('2175', '130000', '130200', '130225', '1', '1', '海港区', '0', '', '1', '0', '0', '10'),
('2176', '130000', '130200', '130227', '1', '1', '栗乡街道', '0', '', '1', '0', '0', '10'),
('2177', '130000', '130200', '130227', '1', '1', '兴城镇', '0', '', '1', '0', '0', '10'),
('2178', '130000', '130200', '130227', '1', '1', '金厂峪镇', '0', '', '1', '0', '0', '10'),
('2179', '130000', '130200', '130227', '1', '1', '洒河桥镇', '0', '', '1', '0', '0', '10'),
('2180', '130000', '130200', '130227', '1', '1', '太平寨镇', '0', '', '1', '0', '0', '10'),
('2181', '130000', '130200', '130227', '1', '1', '罗家屯镇', '0', '', '1', '0', '0', '10'),
('2182', '130000', '130200', '130227', '1', '1', '东荒峪镇', '0', '', '1', '0', '0', '10'),
('2183', '130000', '130200', '130227', '1', '1', '新集镇', '0', '', '1', '0', '0', '10'),
('2184', '130000', '130200', '130227', '1', '1', '三屯营镇', '0', '', '1', '0', '0', '10'),
('2185', '130000', '130200', '130227', '1', '1', '滦阳镇', '0', '', '1', '0', '0', '10'),
('2186', '130000', '130200', '130227', '1', '1', '白庙子乡', '0', '', '1', '0', '0', '10'),
('2187', '130000', '130200', '130227', '1', '1', '上营乡', '0', '', '1', '0', '0', '10'),
('2188', '130000', '130200', '130227', '1', '1', '汉儿庄乡', '0', '', '1', '0', '0', '10'),
('2189', '130000', '130200', '130227', '1', '1', '渔户寨乡', '0', '', '1', '0', '0', '10'),
('2190', '130000', '130200', '130227', '1', '1', '旧城乡', '0', '', '1', '0', '0', '10'),
('2191', '130000', '130200', '130227', '1', '1', '尹庄乡', '0', '', '1', '0', '0', '10'),
('2192', '130000', '130200', '130227', '1', '1', '东莲花院乡', '0', '', '1', '0', '0', '10'),
('2193', '130000', '130200', '130227', '1', '1', '新庄子乡', '0', '', '1', '0', '0', '10'),
('2194', '130000', '130200', '130229', '1', '1', '玉田镇', '0', '', '1', '0', '0', '10'),
('2195', '130000', '130200', '130229', '1', '1', '亮甲店镇', '0', '', '1', '0', '0', '10'),
('2196', '130000', '130200', '130229', '1', '1', '鸦鸿桥镇', '0', '', '1', '0', '0', '10'),
('2197', '130000', '130200', '130229', '1', '1', '窝洛沽镇', '0', '', '1', '0', '0', '10'),
('2198', '130000', '130200', '130229', '1', '1', '石臼窝镇', '0', '', '1', '0', '0', '10'),
('2199', '130000', '130200', '130229', '1', '1', '虹桥镇', '0', '', '1', '0', '0', '10'),
('2200', '130000', '130200', '130229', '1', '1', '散水头镇', '0', '', '1', '0', '0', '10'),
('2201', '130000', '130200', '130229', '1', '1', '林南仓镇', '0', '', '1', '0', '0', '10'),
('2202', '130000', '130200', '130229', '1', '1', '林西镇', '0', '', '1', '0', '0', '10'),
('2203', '130000', '130200', '130229', '1', '1', '杨家板桥镇', '0', '', '1', '0', '0', '10'),
('2204', '130000', '130200', '130229', '1', '1', '彩亭桥镇', '0', '', '1', '0', '0', '10'),
('2205', '130000', '130200', '130229', '1', '1', '孤树镇', '0', '', '1', '0', '0', '10'),
('2206', '130000', '130200', '130229', '1', '1', '大安镇', '0', '', '1', '0', '0', '10'),
('2207', '130000', '130200', '130229', '1', '1', '唐自头镇', '0', '', '1', '0', '0', '10'),
('2208', '130000', '130200', '130229', '1', '1', '郭家屯乡', '0', '', '1', '0', '0', '10'),
('2209', '130000', '130200', '130229', '1', '1', '林头屯乡', '0', '', '1', '0', '0', '10'),
('2210', '130000', '130200', '130229', '1', '1', '杨家套乡', '0', '', '1', '0', '0', '10'),
('2211', '130000', '130200', '130229', '1', '1', '潮洛窝乡', '0', '', '1', '0', '0', '10'),
('2212', '130000', '130200', '130229', '1', '1', '陈家铺乡', '0', '', '1', '0', '0', '10'),
('2213', '130000', '130200', '130229', '1', '1', '郭家桥乡', '0', '', '1', '0', '0', '10'),
('2214', '130000', '130200', '130230', '1', '1', '唐海镇', '0', '', '1', '0', '0', '10'),
('2215', '130000', '130200', '130230', '1', '1', '一农场', '0', '', '1', '0', '0', '10'),
('2216', '130000', '130200', '130230', '1', '1', '三农场', '0', '', '1', '0', '0', '10'),
('2217', '130000', '130200', '130230', '1', '1', '四农场', '0', '', '1', '0', '0', '10'),
('2218', '130000', '130200', '130230', '1', '1', '五农场', '0', '', '1', '0', '0', '10'),
('2219', '130000', '130200', '130230', '1', '1', '六农场', '0', '', '1', '0', '0', '10'),
('2220', '130000', '130200', '130230', '1', '1', '七农场', '0', '', '1', '0', '0', '10'),
('2221', '130000', '130200', '130230', '1', '1', '八农场', '0', '', '1', '0', '0', '10'),
('2222', '130000', '130200', '130230', '1', '1', '九农场', '0', '', '1', '0', '0', '10'),
('2223', '130000', '130200', '130230', '1', '1', '十农场', '0', '', '1', '0', '0', '10'),
('2224', '130000', '130200', '130230', '1', '1', '十一农场', '0', '', '1', '0', '0', '10'),
('2225', '130000', '130200', '130230', '1', '1', '八里滩养殖场', '0', '', '1', '0', '0', '10'),
('2226', '130000', '130200', '130230', '1', '1', '十里海养殖场', '0', '', '1', '0', '0', '10'),
('2227', '130000', '130200', '130230', '1', '1', '曹妃甸工业区', '0', '', '1', '0', '0', '10'),
('2228', '130000', '130200', '130281', '1', '1', '路南街道', '0', '', '1', '0', '0', '10'),
('2229', '130000', '130200', '130281', '1', '1', '路北街道', '0', '', '1', '0', '0', '10'),
('2230', '130000', '130200', '130281', '1', '1', '遵化镇', '0', '', '1', '0', '0', '10'),
('2231', '130000', '130200', '130281', '1', '1', '堡子店镇', '0', '', '1', '0', '0', '10'),
('2232', '130000', '130200', '130281', '1', '1', '马兰峪镇', '0', '', '1', '0', '0', '10'),
('2233', '130000', '130200', '130281', '1', '1', '平安城镇', '0', '', '1', '0', '0', '10'),
('2234', '130000', '130200', '130281', '1', '1', '东新庄镇', '0', '', '1', '0', '0', '10'),
('2235', '130000', '130200', '130281', '1', '1', '新店子镇', '0', '', '1', '0', '0', '10'),
('2236', '130000', '130200', '130281', '1', '1', '党峪镇', '0', '', '1', '0', '0', '10'),
('2237', '130000', '130200', '130281', '1', '1', '地北头镇', '0', '', '1', '0', '0', '10'),
('2238', '130000', '130200', '130281', '1', '1', '东旧寨镇', '0', '', '1', '0', '0', '10'),
('2239', '130000', '130200', '130281', '1', '1', '铁厂镇', '0', '', '1', '0', '0', '10'),
('2240', '130000', '130200', '130281', '1', '1', '苏家洼镇', '0', '', '1', '0', '0', '10'),
('2241', '130000', '130200', '130281', '1', '1', '建明镇', '0', '', '1', '0', '0', '10'),
('2242', '130000', '130200', '130281', '1', '1', '石门镇', '0', '', '1', '0', '0', '10');
INSERT INTO `wst_communitys` VALUES ('2243', '130000', '130200', '130281', '1', '1', '西留村乡', '0', '', '1', '0', '0', '10'),
('2244', '130000', '130200', '130281', '1', '1', '崔家庄乡', '0', '', '1', '0', '0', '10'),
('2245', '130000', '130200', '130281', '1', '1', '兴旺寨乡', '0', '', '1', '0', '0', '10'),
('2246', '130000', '130200', '130281', '1', '1', '西下营满族乡', '0', '', '1', '0', '0', '10'),
('2247', '130000', '130200', '130281', '1', '1', '汤泉满族乡', '0', '', '1', '0', '0', '10'),
('2248', '130000', '130200', '130281', '1', '1', '东陵满族乡', '0', '', '1', '0', '0', '10'),
('2249', '130000', '130200', '130281', '1', '1', '刘备寨乡', '0', '', '1', '0', '0', '10'),
('2250', '130000', '130200', '130281', '1', '1', '团瓢庄乡', '0', '', '1', '0', '0', '10'),
('2251', '130000', '130200', '130281', '1', '1', '娘娘庄乡', '0', '', '1', '0', '0', '10'),
('2252', '130000', '130200', '130281', '1', '1', '西三里乡', '0', '', '1', '0', '0', '10'),
('2253', '130000', '130200', '130281', '1', '1', '候家寨乡', '0', '', '1', '0', '0', '10'),
('2254', '130000', '130200', '130281', '1', '1', '小厂乡', '0', '', '1', '0', '0', '10'),
('2255', '130000', '130200', '130283', '1', '1', '迁安镇', '0', '', '1', '0', '0', '10'),
('2256', '130000', '130200', '130283', '1', '1', '夏官营镇', '0', '', '1', '0', '0', '10'),
('2257', '130000', '130200', '130283', '1', '1', '杨各庄镇', '0', '', '1', '0', '0', '10'),
('2258', '130000', '130200', '130283', '1', '1', '建昌营镇', '0', '', '1', '0', '0', '10'),
('2259', '130000', '130200', '130283', '1', '1', '赵店子镇', '0', '', '1', '0', '0', '10'),
('2260', '130000', '130200', '130283', '1', '1', '野鸡坨镇', '0', '', '1', '0', '0', '10'),
('2261', '130000', '130200', '130283', '1', '1', '大崔庄镇', '0', '', '1', '0', '0', '10'),
('2262', '130000', '130200', '130283', '1', '1', '杨店子镇', '0', '', '1', '0', '0', '10'),
('2263', '130000', '130200', '130283', '1', '1', '蔡园镇', '0', '', '1', '0', '0', '10'),
('2264', '130000', '130200', '130283', '1', '1', '马兰庄镇', '0', '', '1', '0', '0', '10'),
('2265', '130000', '130200', '130283', '1', '1', '沙河驿镇', '0', '', '1', '0', '0', '10'),
('2266', '130000', '130200', '130283', '1', '1', '木厂口镇', '0', '', '1', '0', '0', '10'),
('2267', '130000', '130200', '130283', '1', '1', '扣庄乡', '0', '', '1', '0', '0', '10'),
('2268', '130000', '130200', '130283', '1', '1', '彭店子乡', '0', '', '1', '0', '0', '10'),
('2269', '130000', '130200', '130283', '1', '1', '上射雁庄乡', '0', '', '1', '0', '0', '10'),
('2270', '130000', '130200', '130283', '1', '1', '闫家店乡', '0', '', '1', '0', '0', '10'),
('2271', '130000', '130200', '130283', '1', '1', '五重安乡', '0', '', '1', '0', '0', '10'),
('2272', '130000', '130200', '130283', '1', '1', '大五里乡', '0', '', '1', '0', '0', '10'),
('2273', '130000', '130200', '130283', '1', '1', '太平庄乡', '0', '', '1', '0', '0', '10'),
('2274', '130000', '130300', '130302', '1', '1', '文化路街道', '0', '', '1', '0', '0', '10'),
('2275', '130000', '130300', '130302', '1', '1', '海滨路街道', '0', '', '1', '0', '0', '10'),
('2276', '130000', '130300', '130302', '1', '1', '北环路街道', '0', '', '1', '0', '0', '10'),
('2277', '130000', '130300', '130302', '1', '1', '建设大街街道', '0', '', '1', '0', '0', '10'),
('2278', '130000', '130300', '130302', '1', '1', '河东街道', '0', '', '1', '0', '0', '10'),
('2279', '130000', '130300', '130302', '1', '1', '西港路街道', '0', '', '1', '0', '0', '10'),
('2280', '130000', '130300', '130302', '1', '1', '燕山大街街道', '0', '', '1', '0', '0', '10'),
('2281', '130000', '130300', '130302', '1', '1', '港城大街街道', '0', '', '1', '0', '0', '10'),
('2282', '130000', '130300', '130302', '1', '1', '东环路街道', '0', '', '1', '0', '0', '10'),
('2283', '130000', '130300', '130302', '1', '1', '白塔岭街道', '0', '', '1', '0', '0', '10'),
('2284', '130000', '130300', '130302', '1', '1', '秦皇岛经济技术开发区珠江道街道', '0', '', '1', '0', '0', '10'),
('2285', '130000', '130300', '130302', '1', '1', '东港镇', '0', '', '1', '0', '0', '10'),
('2286', '130000', '130300', '130302', '1', '1', '海港镇', '0', '', '1', '0', '0', '10'),
('2287', '130000', '130300', '130302', '1', '1', '西港镇', '0', '', '1', '0', '0', '10'),
('2288', '130000', '130300', '130302', '1', '1', '海阳镇', '0', '', '1', '0', '0', '10'),
('2289', '130000', '130300', '130302', '1', '1', '北港镇', '0', '', '1', '0', '0', '10'),
('2290', '130000', '130300', '130302', '1', '1', '秦皇岛经济技术开发区', '0', '', '1', '0', '0', '10'),
('2291', '130000', '130300', '130303', '1', '1', '南关街道', '0', '', '1', '0', '0', '10'),
('2292', '130000', '130300', '130303', '1', '1', '东街街道', '0', '', '1', '0', '0', '10'),
('2293', '130000', '130300', '130303', '1', '1', '西街街道', '0', '', '1', '0', '0', '10'),
('2294', '130000', '130300', '130303', '1', '1', '路南街道', '0', '', '1', '0', '0', '10'),
('2295', '130000', '130300', '130303', '1', '1', '船厂路街道', '0', '', '1', '0', '0', '10'),
('2296', '130000', '130300', '130303', '1', '1', '第一关镇', '0', '', '1', '0', '0', '10'),
('2297', '130000', '130300', '130303', '1', '1', '石河镇', '0', '', '1', '0', '0', '10'),
('2298', '130000', '130300', '130303', '1', '1', '孟姜镇', '0', '', '1', '0', '0', '10'),
('2299', '130000', '130300', '130303', '1', '1', '渤海乡', '0', '', '1', '0', '0', '10'),
('2300', '130000', '130300', '130304', '1', '1', '西山街道', '0', '', '1', '0', '0', '10'),
('2301', '130000', '130300', '130304', '1', '1', '东山街道', '0', '', '1', '0', '0', '10'),
('2302', '130000', '130300', '130304', '1', '1', '海滨镇', '0', '', '1', '0', '0', '10'),
('2303', '130000', '130300', '130304', '1', '1', '戴河镇', '0', '', '1', '0', '0', '10'),
('2304', '130000', '130300', '130321', '1', '1', '青龙镇', '0', '', '1', '0', '0', '10'),
('2305', '130000', '130300', '130321', '1', '1', '祖山镇', '0', '', '1', '0', '0', '10'),
('2306', '130000', '130300', '130321', '1', '1', '木头凳镇', '0', '', '1', '0', '0', '10'),
('2307', '130000', '130300', '130321', '1', '1', '双山子镇', '0', '', '1', '0', '0', '10'),
('2308', '130000', '130300', '130321', '1', '1', '马圈子镇', '0', '', '1', '0', '0', '10'),
('2309', '130000', '130300', '130321', '1', '1', '肖营子镇', '0', '', '1', '0', '0', '10'),
('2310', '130000', '130300', '130321', '1', '1', '凤凰山乡', '0', '', '1', '0', '0', '10'),
('2311', '130000', '130300', '130321', '1', '1', '龙王庙乡', '0', '', '1', '0', '0', '10'),
('2312', '130000', '130300', '130321', '1', '1', '三星口乡', '0', '', '1', '0', '0', '10'),
('2313', '130000', '130300', '130321', '1', '1', '干沟乡', '0', '', '1', '0', '0', '10'),
('2314', '130000', '130300', '130321', '1', '1', '大巫岚乡', '0', '', '1', '0', '0', '10'),
('2315', '130000', '130300', '130321', '1', '1', '土门子乡', '0', '', '1', '0', '0', '10'),
('2316', '130000', '130300', '130321', '1', '1', '大石岭乡', '0', '', '1', '0', '0', '10'),
('2317', '130000', '130300', '130321', '1', '1', '隔河头乡', '0', '', '1', '0', '0', '10'),
('2318', '130000', '130300', '130321', '1', '1', '官场乡', '0', '', '1', '0', '0', '10'),
('2319', '130000', '130300', '130321', '1', '1', '茨榆山乡', '0', '', '1', '0', '0', '10'),
('2320', '130000', '130300', '130321', '1', '1', '平方子乡', '0', '', '1', '0', '0', '10'),
('2321', '130000', '130300', '130321', '1', '1', '安子岭乡', '0', '', '1', '0', '0', '10'),
('2322', '130000', '130300', '130321', '1', '1', '朱杖子乡', '0', '', '1', '0', '0', '10'),
('2323', '130000', '130300', '130321', '1', '1', '草碾乡', '0', '', '1', '0', '0', '10'),
('2324', '130000', '130300', '130321', '1', '1', '七道河乡', '0', '', '1', '0', '0', '10'),
('2325', '130000', '130300', '130321', '1', '1', '八道河乡', '0', '', '1', '0', '0', '10'),
('2326', '130000', '130300', '130321', '1', '1', '娄杖子乡', '0', '', '1', '0', '0', '10'),
('2327', '130000', '130300', '130321', '1', '1', '三拨子乡', '0', '', '1', '0', '0', '10'),
('2328', '130000', '130300', '130321', '1', '1', '凉水河乡', '0', '', '1', '0', '0', '10'),
('2329', '130000', '130300', '130322', '1', '1', '昌黎镇', '0', '', '1', '0', '0', '10'),
('2330', '130000', '130300', '130322', '1', '1', '靖安镇', '0', '', '1', '0', '0', '10'),
('2331', '130000', '130300', '130322', '1', '1', '安山镇', '0', '', '1', '0', '0', '10'),
('2332', '130000', '130300', '130322', '1', '1', '龙家店镇', '0', '', '1', '0', '0', '10'),
('2333', '130000', '130300', '130322', '1', '1', '泥井镇', '0', '', '1', '0', '0', '10'),
('2334', '130000', '130300', '130322', '1', '1', '大蒲河镇', '0', '', '1', '0', '0', '10'),
('2335', '130000', '130300', '130322', '1', '1', '新集镇', '0', '', '1', '0', '0', '10'),
('2336', '130000', '130300', '130322', '1', '1', '刘台庄镇', '0', '', '1', '0', '0', '10'),
('2337', '130000', '130300', '130322', '1', '1', '茹荷镇', '0', '', '1', '0', '0', '10'),
('2338', '130000', '130300', '130322', '1', '1', '朱各庄镇', '0', '', '1', '0', '0', '10'),
('2339', '130000', '130300', '130322', '1', '1', '团林乡', '0', '', '1', '0', '0', '10'),
('2340', '130000', '130300', '130322', '1', '1', '葛条港乡', '0', '', '1', '0', '0', '10'),
('2341', '130000', '130300', '130322', '1', '1', '马坨店乡', '0', '', '1', '0', '0', '10'),
('2342', '130000', '130300', '130322', '1', '1', '荒佃庄乡', '0', '', '1', '0', '0', '10'),
('2343', '130000', '130300', '130322', '1', '1', '两山乡', '0', '', '1', '0', '0', '10'),
('2344', '130000', '130300', '130322', '1', '1', '十里铺乡', '0', '', '1', '0', '0', '10'),
('2345', '130000', '130300', '130323', '1', '1', '抚宁镇', '0', '', '1', '0', '0', '10'),
('2346', '130000', '130300', '130323', '1', '1', '留守营镇', '0', '', '1', '0', '0', '10'),
('2347', '130000', '130300', '130323', '1', '1', '榆关镇', '0', '', '1', '0', '0', '10'),
('2348', '130000', '130300', '130323', '1', '1', '牛头崖镇', '0', '', '1', '0', '0', '10'),
('2349', '130000', '130300', '130323', '1', '1', '石门寨镇', '0', '', '1', '0', '0', '10'),
('2350', '130000', '130300', '130323', '1', '1', '台营镇', '0', '', '1', '0', '0', '10'),
('2351', '130000', '130300', '130323', '1', '1', '大新寨镇', '0', '', '1', '0', '0', '10'),
('2352', '130000', '130300', '130323', '1', '1', '驻操营镇', '0', '', '1', '0', '0', '10'),
('2353', '130000', '130300', '130323', '1', '1', '茶棚乡', '0', '', '1', '0', '0', '10'),
('2354', '130000', '130300', '130323', '1', '1', '杜庄乡', '0', '', '1', '0', '0', '10'),
('2355', '130000', '130300', '130323', '1', '1', '深河乡', '0', '', '1', '0', '0', '10'),
('2356', '130000', '130300', '130324', '1', '1', '卢龙镇', '0', '', '1', '0', '0', '10'),
('2357', '130000', '130300', '130324', '1', '1', '潘庄镇', '0', '', '1', '0', '0', '10'),
('2358', '130000', '130300', '130324', '1', '1', '燕河营镇', '0', '', '1', '0', '0', '10'),
('2359', '130000', '130300', '130324', '1', '1', '双望镇', '0', '', '1', '0', '0', '10'),
('2360', '130000', '130300', '130324', '1', '1', '刘田各庄镇', '0', '', '1', '0', '0', '10'),
('2361', '130000', '130300', '130324', '1', '1', '石门镇', '0', '', '1', '0', '0', '10'),
('2362', '130000', '130300', '130324', '1', '1', '下寨乡', '0', '', '1', '0', '0', '10'),
('2363', '130000', '130300', '130324', '1', '1', '刘家营乡', '0', '', '1', '0', '0', '10'),
('2364', '130000', '130300', '130324', '1', '1', '陈官屯乡', '0', '', '1', '0', '0', '10'),
('2365', '130000', '130300', '130324', '1', '1', '印庄乡', '0', '', '1', '0', '0', '10'),
('2366', '130000', '130300', '130324', '1', '1', '蛤泊乡', '0', '', '1', '0', '0', '10'),
('2367', '130000', '130300', '130324', '1', '1', '木井乡', '0', '', '1', '0', '0', '10'),
('2368', '130000', '130400', '130402', '1', '1', '火磨街道', '0', '', '1', '0', '0', '10'),
('2369', '130000', '130400', '130402', '1', '1', '陵园路街道', '0', '', '1', '0', '0', '10'),
('2370', '130000', '130400', '130402', '1', '1', '光明路街道', '0', '', '1', '0', '0', '10'),
('2371', '130000', '130400', '130402', '1', '1', '滏东街道', '0', '', '1', '0', '0', '10'),
('2372', '130000', '130400', '130402', '1', '1', '罗城头街道', '0', '', '1', '0', '0', '10'),
('2373', '130000', '130400', '130402', '1', '1', '渚河路街道', '0', '', '1', '0', '0', '10'),
('2374', '130000', '130400', '130402', '1', '1', '浴新南街道', '0', '', '1', '0', '0', '10'),
('2375', '130000', '130400', '130402', '1', '1', '农林路街道', '0', '', '1', '0', '0', '10'),
('2376', '130000', '130400', '130402', '1', '1', '贸东街道', '0', '', '1', '0', '0', '10'),
('2377', '130000', '130400', '130402', '1', '1', '贸西街道', '0', '', '1', '0', '0', '10'),
('2378', '130000', '130400', '130402', '1', '1', '马头镇', '0', '', '1', '0', '0', '10'),
('2379', '130000', '130400', '130402', '1', '1', '北张庄镇', '0', '', '1', '0', '0', '10'),
('2380', '130000', '130400', '130402', '1', '1', '马庄乡', '0', '', '1', '0', '0', '10'),
('2381', '130000', '130400', '130403', '1', '1', '丛台西街道', '0', '', '1', '0', '0', '10'),
('2382', '130000', '130400', '130403', '1', '1', '联纺西街道', '0', '', '1', '0', '0', '10'),
('2383', '130000', '130400', '130403', '1', '1', '联纺东街道', '0', '', '1', '0', '0', '10'),
('2384', '130000', '130400', '130403', '1', '1', '光明桥街道', '0', '', '1', '0', '0', '10'),
('2385', '130000', '130400', '130403', '1', '1', '丛台东街道', '0', '', '1', '0', '0', '10'),
('2386', '130000', '130400', '130403', '1', '1', '四季青街道', '0', '', '1', '0', '0', '10'),
('2387', '130000', '130400', '130403', '1', '1', '和平街道', '0', '', '1', '0', '0', '10'),
('2388', '130000', '130400', '130403', '1', '1', '中华街道', '0', '', '1', '0', '0', '10'),
('2389', '130000', '130400', '130403', '1', '1', '人民路街道', '0', '', '1', '0', '0', '10'),
('2390', '130000', '130400', '130403', '1', '1', '柳林桥街道', '0', '', '1', '0', '0', '10'),
('2391', '130000', '130400', '130403', '1', '1', '苏曹乡', '0', '', '1', '0', '0', '10'),
('2392', '130000', '130400', '130404', '1', '1', '胜利桥街道', '0', '', '1', '0', '0', '10'),
('2393', '130000', '130400', '130404', '1', '1', '百家村街道', '0', '', '1', '0', '0', '10'),
('2394', '130000', '130400', '130404', '1', '1', '铁路大院街道', '0', '', '1', '0', '0', '10'),
('2395', '130000', '130400', '130404', '1', '1', '化林路街道', '0', '', '1', '0', '0', '10'),
('2396', '130000', '130400', '130404', '1', '1', '庞村街道', '0', '', '1', '0', '0', '10'),
('2397', '130000', '130400', '130404', '1', '1', '二六七二街道', '0', '', '1', '0', '0', '10'),
('2398', '130000', '130400', '130404', '1', '1', '石化街道', '0', '', '1', '0', '0', '10'),
('2399', '130000', '130400', '130404', '1', '1', '彭家寨乡', '0', '', '1', '0', '0', '10'),
('2400', '130000', '130400', '130404', '1', '1', '华北冶金建设公司', '0', '', '1', '0', '0', '10'),
('2401', '130000', '130400', '130406', '1', '1', '临水镇', '0', '', '1', '0', '0', '10'),
('2402', '130000', '130400', '130406', '1', '1', '峰峰镇', '0', '', '1', '0', '0', '10'),
('2403', '130000', '130400', '130406', '1', '1', '新坡镇', '0', '', '1', '0', '0', '10'),
('2404', '130000', '130400', '130406', '1', '1', '大社镇', '0', '', '1', '0', '0', '10'),
('2405', '130000', '130400', '130406', '1', '1', '和村镇', '0', '', '1', '0', '0', '10'),
('2406', '130000', '130400', '130406', '1', '1', '义井镇', '0', '', '1', '0', '0', '10'),
('2407', '130000', '130400', '130406', '1', '1', '彭城镇', '0', '', '1', '0', '0', '10'),
('2408', '130000', '130400', '130406', '1', '1', '界城镇', '0', '', '1', '0', '0', '10'),
('2409', '130000', '130400', '130406', '1', '1', '大峪镇', '0', '', '1', '0', '0', '10'),
('2410', '130000', '130400', '130421', '1', '1', '尚璧镇', '0', '', '1', '0', '0', '10'),
('2411', '130000', '130400', '130421', '1', '1', '黄粱梦镇', '0', '', '1', '0', '0', '10'),
('2412', '130000', '130400', '130421', '1', '1', '河沙镇镇', '0', '', '1', '0', '0', '10'),
('2413', '130000', '130400', '130421', '1', '1', '户村镇', '0', '', '1', '0', '0', '10'),
('2414', '130000', '130400', '130421', '1', '1', '南堡乡', '0', '', '1', '0', '0', '10'),
('2415', '130000', '130400', '130421', '1', '1', '南吕固乡', '0', '', '1', '0', '0', '10'),
('2416', '130000', '130400', '130421', '1', '1', '兼庄乡', '0', '', '1', '0', '0', '10'),
('2417', '130000', '130400', '130421', '1', '1', '代召乡', '0', '', '1', '0', '0', '10'),
('2418', '130000', '130400', '130421', '1', '1', '康庄乡', '0', '', '1', '0', '0', '10'),
('2419', '130000', '130400', '130421', '1', '1', '三陵乡', '0', '', '1', '0', '0', '10'),
('2420', '130000', '130400', '130423', '1', '1', '临漳镇', '0', '', '1', '0', '0', '10'),
('2421', '130000', '130400', '130423', '1', '1', '南东坊镇', '0', '', '1', '0', '0', '10'),
('2422', '130000', '130400', '130423', '1', '1', '孙陶集镇', '0', '', '1', '0', '0', '10'),
('2423', '130000', '130400', '130423', '1', '1', '柳园镇', '0', '', '1', '0', '0', '10'),
('2424', '130000', '130400', '130423', '1', '1', '称勾集镇', '0', '', '1', '0', '0', '10'),
('2425', '130000', '130400', '130423', '1', '1', '狄邱乡', '0', '', '1', '0', '0', '10'),
('2426', '130000', '130400', '130423', '1', '1', '张村集乡', '0', '', '1', '0', '0', '10'),
('2427', '130000', '130400', '130423', '1', '1', '西羊羔乡', '0', '', '1', '0', '0', '10'),
('2428', '130000', '130400', '130423', '1', '1', '香菜营乡', '0', '', '1', '0', '0', '10'),
('2429', '130000', '130400', '130423', '1', '1', '杜村集乡', '0', '', '1', '0', '0', '10'),
('2430', '130000', '130400', '130423', '1', '1', '章里集乡', '0', '', '1', '0', '0', '10'),
('2431', '130000', '130400', '130423', '1', '1', '习文乡', '0', '', '1', '0', '0', '10'),
('2432', '130000', '130400', '130423', '1', '1', '砖寨营乡', '0', '', '1', '0', '0', '10'),
('2433', '130000', '130400', '130423', '1', '1', '柏鹤集乡', '0', '', '1', '0', '0', '10'),
('2434', '130000', '130400', '130424', '1', '1', '成安镇', '0', '', '1', '0', '0', '10'),
('2435', '130000', '130400', '130424', '1', '1', '商城镇', '0', '', '1', '0', '0', '10'),
('2436', '130000', '130400', '130424', '1', '1', '漳河店镇', '0', '', '1', '0', '0', '10'),
('2437', '130000', '130400', '130424', '1', '1', '李家疃镇', '0', '', '1', '0', '0', '10'),
('2438', '130000', '130400', '130424', '1', '1', '辛义乡', '0', '', '1', '0', '0', '10'),
('2439', '130000', '130400', '130424', '1', '1', '柏寺营乡', '0', '', '1', '0', '0', '10'),
('2440', '130000', '130400', '130424', '1', '1', '道东堡乡', '0', '', '1', '0', '0', '10'),
('2441', '130000', '130400', '130424', '1', '1', '北乡义乡', '0', '', '1', '0', '0', '10'),
('2442', '130000', '130400', '130424', '1', '1', '长巷乡', '0', '', '1', '0', '0', '10'),
('2443', '130000', '130400', '130425', '1', '1', '大名镇', '0', '', '1', '0', '0', '10'),
('2444', '130000', '130400', '130425', '1', '1', '杨桥镇', '0', '', '1', '0', '0', '10'),
('2445', '130000', '130400', '130425', '1', '1', '万堤镇', '0', '', '1', '0', '0', '10'),
('2446', '130000', '130400', '130425', '1', '1', '龙王庙镇', '0', '', '1', '0', '0', '10'),
('2447', '130000', '130400', '130425', '1', '1', '束馆镇', '0', '', '1', '0', '0', '10'),
('2448', '130000', '130400', '130425', '1', '1', '金滩镇', '0', '', '1', '0', '0', '10'),
('2449', '130000', '130400', '130425', '1', '1', '沙圪塔乡', '0', '', '1', '0', '0', '10'),
('2450', '130000', '130400', '130425', '1', '1', '王村乡', '0', '', '1', '0', '0', '10'),
('2451', '130000', '130400', '130425', '1', '1', '铺上乡', '0', '', '1', '0', '0', '10'),
('2452', '130000', '130400', '130425', '1', '1', '黄金堤乡', '0', '', '1', '0', '0', '10'),
('2453', '130000', '130400', '130425', '1', '1', '大街乡', '0', '', '1', '0', '0', '10'),
('2454', '130000', '130400', '130425', '1', '1', '旧治乡', '0', '', '1', '0', '0', '10'),
('2455', '130000', '130400', '130425', '1', '1', '西未庄乡', '0', '', '1', '0', '0', '10'),
('2456', '130000', '130400', '130425', '1', '1', '孙甘店乡', '0', '', '1', '0', '0', '10'),
('2457', '130000', '130400', '130425', '1', '1', '西付集乡', '0', '', '1', '0', '0', '10'),
('2458', '130000', '130400', '130425', '1', '1', '埝头乡', '0', '', '1', '0', '0', '10'),
('2459', '130000', '130400', '130425', '1', '1', '北峰乡', '0', '', '1', '0', '0', '10'),
('2460', '130000', '130400', '130425', '1', '1', '张集乡', '0', '', '1', '0', '0', '10'),
('2461', '130000', '130400', '130425', '1', '1', '红庙乡', '0', '', '1', '0', '0', '10'),
('2462', '130000', '130400', '130425', '1', '1', '营镇回族乡', '0', '', '1', '0', '0', '10'),
('2463', '130000', '130400', '130426', '1', '1', '涉城镇', '0', '', '1', '0', '0', '10'),
('2464', '130000', '130400', '130426', '1', '1', '河南店镇', '0', '', '1', '0', '0', '10'),
('2465', '130000', '130400', '130426', '1', '1', '索堡镇', '0', '', '1', '0', '0', '10'),
('2466', '130000', '130400', '130426', '1', '1', '西戌镇', '0', '', '1', '0', '0', '10'),
('2467', '130000', '130400', '130426', '1', '1', '井店镇', '0', '', '1', '0', '0', '10'),
('2468', '130000', '130400', '130426', '1', '1', '更乐镇', '0', '', '1', '0', '0', '10'),
('2469', '130000', '130400', '130426', '1', '1', '固新镇', '0', '', '1', '0', '0', '10'),
('2470', '130000', '130400', '130426', '1', '1', '西达镇', '0', '', '1', '0', '0', '10'),
('2471', '130000', '130400', '130426', '1', '1', '偏城镇', '0', '', '1', '0', '0', '10'),
('2472', '130000', '130400', '130426', '1', '1', '神头乡', '0', '', '1', '0', '0', '10'),
('2473', '130000', '130400', '130426', '1', '1', '辽城乡', '0', '', '1', '0', '0', '10'),
('2474', '130000', '130400', '130426', '1', '1', '偏店乡', '0', '', '1', '0', '0', '10'),
('2475', '130000', '130400', '130426', '1', '1', '龙虎乡', '0', '', '1', '0', '0', '10'),
('2476', '130000', '130400', '130426', '1', '1', '木井乡', '0', '', '1', '0', '0', '10'),
('2477', '130000', '130400', '130426', '1', '1', '关防乡', '0', '', '1', '0', '0', '10'),
('2478', '130000', '130400', '130426', '1', '1', '合漳乡', '0', '', '1', '0', '0', '10'),
('2479', '130000', '130400', '130426', '1', '1', '鹿头乡', '0', '', '1', '0', '0', '10'),
('2480', '130000', '130400', '130427', '1', '1', '磁州镇', '0', '', '1', '0', '0', '10'),
('2481', '130000', '130400', '130427', '1', '1', '高臾镇', '0', '', '1', '0', '0', '10'),
('2482', '130000', '130400', '130427', '1', '1', '西光禄镇', '0', '', '1', '0', '0', '10'),
('2483', '130000', '130400', '130427', '1', '1', '讲武城镇', '0', '', '1', '0', '0', '10'),
('2484', '130000', '130400', '130427', '1', '1', '岳城镇', '0', '', '1', '0', '0', '10'),
('2485', '130000', '130400', '130427', '1', '1', '观台镇', '0', '', '1', '0', '0', '10'),
('2486', '130000', '130400', '130427', '1', '1', '林坦镇', '0', '', '1', '0', '0', '10'),
('2487', '130000', '130400', '130427', '1', '1', '白土镇', '0', '', '1', '0', '0', '10'),
('2488', '130000', '130400', '130427', '1', '1', '黄沙镇', '0', '', '1', '0', '0', '10'),
('2489', '130000', '130400', '130427', '1', '1', '路村营乡', '0', '', '1', '0', '0', '10'),
('2490', '130000', '130400', '130427', '1', '1', '西固义乡', '0', '', '1', '0', '0', '10'),
('2491', '130000', '130400', '130427', '1', '1', '辛庄营乡', '0', '', '1', '0', '0', '10'),
('2492', '130000', '130400', '130427', '1', '1', '花官营乡', '0', '', '1', '0', '0', '10'),
('2493', '130000', '130400', '130427', '1', '1', '时村营乡', '0', '', '1', '0', '0', '10'),
('2494', '130000', '130400', '130427', '1', '1', '南城乡', '0', '', '1', '0', '0', '10'),
('2495', '130000', '130400', '130427', '1', '1', '台城乡', '0', '', '1', '0', '0', '10'),
('2496', '130000', '130400', '130427', '1', '1', '陶泉乡', '0', '', '1', '0', '0', '10'),
('2497', '130000', '130400', '130427', '1', '1', '都党乡', '0', '', '1', '0', '0', '10'),
('2498', '130000', '130400', '130427', '1', '1', '北贾壁乡', '0', '', '1', '0', '0', '10'),
('2499', '130000', '130400', '130428', '1', '1', '肥乡镇', '0', '', '1', '0', '0', '10'),
('2500', '130000', '130400', '130428', '1', '1', '天台山镇', '0', '', '1', '0', '0', '10'),
('2501', '130000', '130400', '130428', '1', '1', '大西韩乡', '0', '', '1', '0', '0', '10'),
('2502', '130000', '130400', '130428', '1', '1', '辛安镇乡', '0', '', '1', '0', '0', '10'),
('2503', '130000', '130400', '130428', '1', '1', '毛演堡乡', '0', '', '1', '0', '0', '10'),
('2504', '130000', '130400', '130428', '1', '1', '元固乡', '0', '', '1', '0', '0', '10'),
('2505', '130000', '130400', '130428', '1', '1', '屯庄营乡', '0', '', '1', '0', '0', '10'),
('2506', '130000', '130400', '130428', '1', '1', '东漳堡乡', '0', '', '1', '0', '0', '10'),
('2507', '130000', '130400', '130428', '1', '1', '旧店乡', '0', '', '1', '0', '0', '10'),
('2508', '130000', '130400', '130429', '1', '1', '临洺关镇', '0', '', '1', '0', '0', '10'),
('2509', '130000', '130400', '130429', '1', '1', '大北汪镇', '0', '', '1', '0', '0', '10'),
('2510', '130000', '130400', '130429', '1', '1', '张西堡镇', '0', '', '1', '0', '0', '10'),
('2511', '130000', '130400', '130429', '1', '1', '广府镇', '0', '', '1', '0', '0', '10'),
('2512', '130000', '130400', '130429', '1', '1', '南沿村镇', '0', '', '1', '0', '0', '10'),
('2513', '130000', '130400', '130429', '1', '1', '永合会镇', '0', '', '1', '0', '0', '10'),
('2514', '130000', '130400', '130429', '1', '1', '西苏乡', '0', '', '1', '0', '0', '10'),
('2515', '130000', '130400', '130429', '1', '1', '界河店乡', '0', '', '1', '0', '0', '10'),
('2516', '130000', '130400', '130429', '1', '1', '刘营乡', '0', '', '1', '0', '0', '10'),
('2517', '130000', '130400', '130429', '1', '1', '刘汉乡', '0', '', '1', '0', '0', '10'),
('2518', '130000', '130400', '130429', '1', '1', '正西乡', '0', '', '1', '0', '0', '10'),
('2519', '130000', '130400', '130429', '1', '1', '讲武乡', '0', '', '1', '0', '0', '10'),
('2520', '130000', '130400', '130429', '1', '1', '曲陌乡', '0', '', '1', '0', '0', '10'),
('2521', '130000', '130400', '130429', '1', '1', '辛庄堡乡', '0', '', '1', '0', '0', '10'),
('2522', '130000', '130400', '130429', '1', '1', '小龙马乡', '0', '', '1', '0', '0', '10'),
('2523', '130000', '130400', '130429', '1', '1', '东杨庄乡', '0', '', '1', '0', '0', '10'),
('2524', '130000', '130400', '130429', '1', '1', '小西堡乡', '0', '', '1', '0', '0', '10'),
('2525', '130000', '130400', '130429', '1', '1', '西河庄乡', '0', '', '1', '0', '0', '10'),
('2526', '130000', '130400', '130429', '1', '1', '姚寨乡', '0', '', '1', '0', '0', '10'),
('2527', '130000', '130400', '130429', '1', '1', '西阳城乡', '0', '', '1', '0', '0', '10'),
('2528', '130000', '130400', '130430', '1', '1', '新马头镇', '0', '', '1', '0', '0', '10'),
('2529', '130000', '130400', '130430', '1', '1', '邱城镇', '0', '', '1', '0', '0', '10'),
('2530', '130000', '130400', '130430', '1', '1', '梁二庄乡', '0', '', '1', '0', '0', '10'),
('2531', '130000', '130400', '130430', '1', '1', '南辛店乡', '0', '', '1', '0', '0', '10'),
('2532', '130000', '130400', '130430', '1', '1', '香城固乡', '0', '', '1', '0', '0', '10'),
('2533', '130000', '130400', '130430', '1', '1', '古城营乡', '0', '', '1', '0', '0', '10'),
('2534', '130000', '130400', '130430', '1', '1', '陈村回族乡', '0', '', '1', '0', '0', '10'),
('2535', '130000', '130400', '130431', '1', '1', '鸡泽镇', '0', '', '1', '0', '0', '10'),
('2536', '130000', '130400', '130431', '1', '1', '小寨镇', '0', '', '1', '0', '0', '10'),
('2537', '130000', '130400', '130431', '1', '1', '双塔镇', '0', '', '1', '0', '0', '10'),
('2538', '130000', '130400', '130431', '1', '1', '浮图店乡', '0', '', '1', '0', '0', '10'),
('2539', '130000', '130400', '130431', '1', '1', '吴官营乡', '0', '', '1', '0', '0', '10'),
('2540', '130000', '130400', '130431', '1', '1', '风正乡', '0', '', '1', '0', '0', '10'),
('2541', '130000', '130400', '130431', '1', '1', '曹庄乡', '0', '', '1', '0', '0', '10'),
('2542', '130000', '130400', '130432', '1', '1', '广平镇', '0', '', '1', '0', '0', '10'),
('2543', '130000', '130400', '130432', '1', '1', '平固店镇', '0', '', '1', '0', '0', '10'),
('2544', '130000', '130400', '130432', '1', '1', '双庙乡', '0', '', '1', '0', '0', '10'),
('2545', '130000', '130400', '130432', '1', '1', '十里铺乡', '0', '', '1', '0', '0', '10'),
('2546', '130000', '130400', '130432', '1', '1', '南韩村乡', '0', '', '1', '0', '0', '10'),
('2547', '130000', '130400', '130432', '1', '1', '南阳堡乡', '0', '', '1', '0', '0', '10'),
('2548', '130000', '130400', '130432', '1', '1', '东张孟乡', '0', '', '1', '0', '0', '10'),
('2549', '130000', '130400', '130433', '1', '1', '馆陶镇', '0', '', '1', '0', '0', '10'),
('2550', '130000', '130400', '130433', '1', '1', '房寨镇', '0', '', '1', '0', '0', '10'),
('2551', '130000', '130400', '130433', '1', '1', '柴堡镇', '0', '', '1', '0', '0', '10'),
('2552', '130000', '130400', '130433', '1', '1', '魏僧寨镇', '0', '', '1', '0', '0', '10'),
('2553', '130000', '130400', '130433', '1', '1', '寿山寺乡', '0', '', '1', '0', '0', '10'),
('2554', '130000', '130400', '130433', '1', '1', '王桥乡', '0', '', '1', '0', '0', '10'),
('2555', '130000', '130400', '130433', '1', '1', '南徐村乡', '0', '', '1', '0', '0', '10'),
('2556', '130000', '130400', '130433', '1', '1', '路桥乡', '0', '', '1', '0', '0', '10'),
('2557', '130000', '130400', '130434', '1', '1', '魏城镇', '0', '', '1', '0', '0', '10'),
('2558', '130000', '130400', '130434', '1', '1', '德政镇', '0', '', '1', '0', '0', '10'),
('2559', '130000', '130400', '130434', '1', '1', '北皋镇', '0', '', '1', '0', '0', '10'),
('2560', '130000', '130400', '130434', '1', '1', '双井镇', '0', '', '1', '0', '0', '10'),
('2561', '130000', '130400', '130434', '1', '1', '牙里镇', '0', '', '1', '0', '0', '10'),
('2562', '130000', '130400', '130434', '1', '1', '车往镇', '0', '', '1', '0', '0', '10'),
('2563', '130000', '130400', '130434', '1', '1', '回隆镇', '0', '', '1', '0', '0', '10'),
('2564', '130000', '130400', '130434', '1', '1', '东代固乡', '0', '', '1', '0', '0', '10'),
('2565', '130000', '130400', '130434', '1', '1', '棘针寨乡', '0', '', '1', '0', '0', '10'),
('2566', '130000', '130400', '130434', '1', '1', '沙口集乡', '0', '', '1', '0', '0', '10'),
('2567', '130000', '130400', '130434', '1', '1', '野胡拐乡', '0', '', '1', '0', '0', '10'),
('2568', '130000', '130400', '130434', '1', '1', '仕望集乡', '0', '', '1', '0', '0', '10'),
('2569', '130000', '130400', '130434', '1', '1', '前大磨乡', '0', '', '1', '0', '0', '10'),
('2570', '130000', '130400', '130434', '1', '1', '院堡乡', '0', '', '1', '0', '0', '10'),
('2571', '130000', '130400', '130434', '1', '1', '南双庙乡', '0', '', '1', '0', '0', '10'),
('2572', '130000', '130400', '130434', '1', '1', '大辛庄乡', '0', '', '1', '0', '0', '10'),
('2573', '130000', '130400', '130434', '1', '1', '大马村乡', '0', '', '1', '0', '0', '10'),
('2574', '130000', '130400', '130434', '1', '1', '边马乡', '0', '', '1', '0', '0', '10'),
('2575', '130000', '130400', '130434', '1', '1', '张二庄乡', '0', '', '1', '0', '0', '10'),
('2576', '130000', '130400', '130434', '1', '1', '北台头乡', '0', '', '1', '0', '0', '10'),
('2577', '130000', '130400', '130434', '1', '1', '泊口乡', '0', '', '1', '0', '0', '10'),
('2578', '130000', '130400', '130435', '1', '1', '曲周镇', '0', '', '1', '0', '0', '10'),
('2579', '130000', '130400', '130435', '1', '1', '安寨镇', '0', '', '1', '0', '0', '10'),
('2580', '130000', '130400', '130435', '1', '1', '侯村镇', '0', '', '1', '0', '0', '10'),
('2581', '130000', '130400', '130435', '1', '1', '河南疃镇', '0', '', '1', '0', '0', '10'),
('2582', '130000', '130400', '130435', '1', '1', '槐桥乡', '0', '', '1', '0', '0', '10'),
('2583', '130000', '130400', '130435', '1', '1', '南里岳乡', '0', '', '1', '0', '0', '10'),
('2584', '130000', '130400', '130435', '1', '1', '白寨乡', '0', '', '1', '0', '0', '10'),
('2585', '130000', '130400', '130435', '1', '1', '大河道乡', '0', '', '1', '0', '0', '10'),
('2586', '130000', '130400', '130435', '1', '1', '依庄乡', '0', '', '1', '0', '0', '10'),
('2587', '130000', '130400', '130435', '1', '1', '第四疃乡', '0', '', '1', '0', '0', '10'),
('2588', '130000', '130400', '130481', '1', '1', '武安镇', '0', '', '1', '0', '0', '10'),
('2589', '130000', '130400', '130481', '1', '1', '康二城镇', '0', '', '1', '0', '0', '10'),
('2590', '130000', '130400', '130481', '1', '1', '午汲镇', '0', '', '1', '0', '0', '10'),
('2591', '130000', '130400', '130481', '1', '1', '磁山镇', '0', '', '1', '0', '0', '10'),
('2592', '130000', '130400', '130481', '1', '1', '伯延镇', '0', '', '1', '0', '0', '10'),
('2593', '130000', '130400', '130481', '1', '1', '淑村镇', '0', '', '1', '0', '0', '10'),
('2594', '130000', '130400', '130481', '1', '1', '大同镇', '0', '', '1', '0', '0', '10'),
('2595', '130000', '130400', '130481', '1', '1', '邑城镇', '0', '', '1', '0', '0', '10'),
('2596', '130000', '130400', '130481', '1', '1', '矿山镇', '0', '', '1', '0', '0', '10'),
('2597', '130000', '130400', '130481', '1', '1', '贺进镇', '0', '', '1', '0', '0', '10'),
('2598', '130000', '130400', '130481', '1', '1', '阳邑镇', '0', '', '1', '0', '0', '10'),
('2599', '130000', '130400', '130481', '1', '1', '徘徊镇', '0', '', '1', '0', '0', '10'),
('2600', '130000', '130400', '130481', '1', '1', '冶陶镇', '0', '', '1', '0', '0', '10'),
('2601', '130000', '130400', '130481', '1', '1', '上团城乡', '0', '', '1', '0', '0', '10'),
('2602', '130000', '130400', '130481', '1', '1', '北安庄乡', '0', '', '1', '0', '0', '10'),
('2603', '130000', '130400', '130481', '1', '1', '北安乐乡', '0', '', '1', '0', '0', '10'),
('2604', '130000', '130400', '130481', '1', '1', '西土山乡', '0', '', '1', '0', '0', '10'),
('2605', '130000', '130400', '130481', '1', '1', '西寺庄乡', '0', '', '1', '0', '0', '10'),
('2606', '130000', '130400', '130481', '1', '1', '活水乡', '0', '', '1', '0', '0', '10'),
('2607', '130000', '130400', '130481', '1', '1', '石洞乡', '0', '', '1', '0', '0', '10'),
('2608', '130000', '130400', '130481', '1', '1', '管陶乡', '0', '', '1', '0', '0', '10'),
('2609', '130000', '130400', '130481', '1', '1', '马家庄乡', '0', '', '1', '0', '0', '10'),
('2610', '130000', '130500', '130502', '1', '1', '南长街街道', '0', '', '1', '0', '0', '10'),
('2611', '130000', '130500', '130502', '1', '1', '北大街街道', '0', '', '1', '0', '0', '10'),
('2612', '130000', '130500', '130502', '1', '1', '西大街街道', '0', '', '1', '0', '0', '10'),
('2613', '130000', '130500', '130502', '1', '1', '西门里街道', '0', '', '1', '0', '0', '10'),
('2614', '130000', '130500', '130502', '1', '1', '大梁庄乡', '0', '', '1', '0', '0', '10'),
('2615', '130000', '130500', '130502', '1', '1', '东郭村乡', '0', '', '1', '0', '0', '10'),
('2616', '130000', '130500', '130502', '1', '1', '市高新技术开发区', '0', '', '1', '0', '0', '10'),
('2617', '130000', '130500', '130503', '1', '1', '钢铁路街道', '0', '', '1', '0', '0', '10'),
('2618', '130000', '130500', '130503', '1', '1', '中兴路街道', '0', '', '1', '0', '0', '10'),
('2619', '130000', '130500', '130503', '1', '1', '达活泉街道', '0', '', '1', '0', '0', '10'),
('2620', '130000', '130500', '130503', '1', '1', '张宽街道', '0', '', '1', '0', '0', '10'),
('2621', '130000', '130500', '130503', '1', '1', '章村街道', '0', '', '1', '0', '0', '10'),
('2622', '130000', '130500', '130503', '1', '1', '南大郭乡', '0', '', '1', '0', '0', '10'),
('2623', '130000', '130500', '130503', '1', '1', '李村乡', '0', '', '1', '0', '0', '10'),
('2624', '130000', '130500', '130521', '1', '1', '豫让桥街道', '0', '', '1', '0', '0', '10'),
('2625', '130000', '130500', '130521', '1', '1', '东汪镇', '0', '', '1', '0', '0', '10'),
('2626', '130000', '130500', '130521', '1', '1', '王快镇', '0', '', '1', '0', '0', '10'),
('2627', '130000', '130500', '130521', '1', '1', '祝村镇', '0', '', '1', '0', '0', '10'),
('2628', '130000', '130500', '130521', '1', '1', '晏家屯镇', '0', '', '1', '0', '0', '10'),
('2629', '130000', '130500', '130521', '1', '1', '南石门镇', '0', '', '1', '0', '0', '10'),
('2630', '130000', '130500', '130521', '1', '1', '羊范镇', '0', '', '1', '0', '0', '10'),
('2631', '130000', '130500', '130521', '1', '1', '皇寺镇', '0', '', '1', '0', '0', '10'),
('2632', '130000', '130500', '130521', '1', '1', '会宁镇', '0', '', '1', '0', '0', '10'),
('2633', '130000', '130500', '130521', '1', '1', '西黄村镇', '0', '', '1', '0', '0', '10'),
('2634', '130000', '130500', '130521', '1', '1', '路罗镇', '0', '', '1', '0', '0', '10'),
('2635', '130000', '130500', '130521', '1', '1', '将军墓镇', '0', '', '1', '0', '0', '10'),
('2636', '130000', '130500', '130521', '1', '1', '浆水镇', '0', '', '1', '0', '0', '10'),
('2637', '130000', '130500', '130521', '1', '1', '宋家庄镇', '0', '', '1', '0', '0', '10'),
('2638', '130000', '130500', '130521', '1', '1', '太子井乡', '0', '', '1', '0', '0', '10'),
('2639', '130000', '130500', '130521', '1', '1', '龙泉寺乡', '0', '', '1', '0', '0', '10'),
('2640', '130000', '130500', '130521', '1', '1', '北小庄乡', '0', '', '1', '0', '0', '10'),
('2641', '130000', '130500', '130521', '1', '1', '城计头乡', '0', '', '1', '0', '0', '10'),
('2642', '130000', '130500', '130521', '1', '1', '白岸乡', '0', '', '1', '0', '0', '10'),
('2643', '130000', '130500', '130521', '1', '1', '冀家村乡', '0', '', '1', '0', '0', '10'),
('2644', '130000', '130500', '130522', '1', '1', '临城镇', '0', '', '1', '0', '0', '10'),
('2645', '130000', '130500', '130522', '1', '1', '东镇镇', '0', '', '1', '0', '0', '10'),
('2646', '130000', '130500', '130522', '1', '1', '西竖镇', '0', '', '1', '0', '0', '10'),
('2647', '130000', '130500', '130522', '1', '1', '郝庄镇', '0', '', '1', '0', '0', '10'),
('2648', '130000', '130500', '130522', '1', '1', '黑城乡', '0', '', '1', '0', '0', '10'),
('2649', '130000', '130500', '130522', '1', '1', '鸭鸽营乡', '0', '', '1', '0', '0', '10'),
('2650', '130000', '130500', '130522', '1', '1', '石城乡', '0', '', '1', '0', '0', '10'),
('2651', '130000', '130500', '130522', '1', '1', '赵庄乡', '0', '', '1', '0', '0', '10'),
('2652', '130000', '130500', '130523', '1', '1', '内邱镇', '0', '', '1', '0', '0', '10'),
('2653', '130000', '130500', '130523', '1', '1', '大孟村镇', '0', '', '1', '0', '0', '10'),
('2654', '130000', '130500', '130523', '1', '1', '金店镇', '0', '', '1', '0', '0', '10'),
('2655', '130000', '130500', '130523', '1', '1', '官庄镇', '0', '', '1', '0', '0', '10'),
('2656', '130000', '130500', '130523', '1', '1', '柳林镇', '0', '', '1', '0', '0', '10'),
('2657', '130000', '130500', '130523', '1', '1', '五郭店乡', '0', '', '1', '0', '0', '10'),
('2658', '130000', '130500', '130523', '1', '1', '南赛乡', '0', '', '1', '0', '0', '10'),
('2659', '130000', '130500', '130523', '1', '1', '獐么乡', '0', '', '1', '0', '0', '10'),
('2660', '130000', '130500', '130523', '1', '1', '侯家庄乡', '0', '', '1', '0', '0', '10'),
('2661', '130000', '130500', '130524', '1', '1', '柏乡镇', '0', '', '1', '0', '0', '10'),
('2662', '130000', '130500', '130524', '1', '1', '固城店镇', '0', '', '1', '0', '0', '10'),
('2663', '130000', '130500', '130524', '1', '1', '王家庄乡', '0', '', '1', '0', '0', '10'),
('2664', '130000', '130500', '130524', '1', '1', '西汪乡', '0', '', '1', '0', '0', '10'),
('2665', '130000', '130500', '130524', '1', '1', '龙华乡', '0', '', '1', '0', '0', '10'),
('2666', '130000', '130500', '130524', '1', '1', '内步乡', '0', '', '1', '0', '0', '10'),
('2667', '130000', '130500', '130525', '1', '1', '隆尧镇', '0', '', '1', '0', '0', '10'),
('2668', '130000', '130500', '130525', '1', '1', '魏家庄镇', '0', '', '1', '0', '0', '10'),
('2669', '130000', '130500', '130525', '1', '1', '尹村镇', '0', '', '1', '0', '0', '10'),
('2670', '130000', '130500', '130525', '1', '1', '山口镇', '0', '', '1', '0', '0', '10'),
('2671', '130000', '130500', '130525', '1', '1', '莲子镇', '0', '', '1', '0', '0', '10'),
('2672', '130000', '130500', '130525', '1', '1', '固城镇', '0', '', '1', '0', '0', '10'),
('2673', '130000', '130500', '130525', '1', '1', '北楼乡', '0', '', '1', '0', '0', '10'),
('2674', '130000', '130500', '130525', '1', '1', '东良乡', '0', '', '1', '0', '0', '10'),
('2675', '130000', '130500', '130525', '1', '1', '双碑乡', '0', '', '1', '0', '0', '10'),
('2676', '130000', '130500', '130525', '1', '1', '牛家桥乡', '0', '', '1', '0', '0', '10'),
('2677', '130000', '130500', '130525', '1', '1', '千户营乡', '0', '', '1', '0', '0', '10'),
('2678', '130000', '130500', '130525', '1', '1', '大张庄乡', '0', '', '1', '0', '0', '10'),
('2679', '130000', '130500', '130525', '1', '1', '柳行农场', '0', '', '1', '0', '0', '10'),
('2680', '130000', '130500', '130526', '1', '1', '任城镇', '0', '', '1', '0', '0', '10'),
('2681', '130000', '130500', '130526', '1', '1', '邢家湾镇', '0', '', '1', '0', '0', '10'),
('2682', '130000', '130500', '130526', '1', '1', '辛店镇', '0', '', '1', '0', '0', '10'),
('2683', '130000', '130500', '130526', '1', '1', '西固城乡', '0', '', '1', '0', '0', '10'),
('2684', '130000', '130500', '130526', '1', '1', '永福庄乡', '0', '', '1', '0', '0', '10'),
('2685', '130000', '130500', '130526', '1', '1', '大屯乡', '0', '', '1', '0', '0', '10'),
('2686', '130000', '130500', '130526', '1', '1', '天口乡', '0', '', '1', '0', '0', '10'),
('2687', '130000', '130500', '130526', '1', '1', '骆庄乡', '0', '', '1', '0', '0', '10'),
('2688', '130000', '130500', '130527', '1', '1', '和阳镇', '0', '', '1', '0', '0', '10'),
('2689', '130000', '130500', '130527', '1', '1', '贾宋镇', '0', '', '1', '0', '0', '10'),
('2690', '130000', '130500', '130527', '1', '1', '郝桥镇', '0', '', '1', '0', '0', '10'),
('2691', '130000', '130500', '130527', '1', '1', '东三召乡', '0', '', '1', '0', '0', '10'),
('2692', '130000', '130500', '130527', '1', '1', '阎里乡', '0', '', '1', '0', '0', '10'),
('2693', '130000', '130500', '130527', '1', '1', '河郭乡', '0', '', '1', '0', '0', '10'),
('2694', '130000', '130500', '130527', '1', '1', '史召乡', '0', '', '1', '0', '0', '10'),
('2695', '130000', '130500', '130527', '1', '1', '三思乡', '0', '', '1', '0', '0', '10'),
('2696', '130000', '130500', '130528', '1', '1', '凤凰镇', '0', '', '1', '0', '0', '10'),
('2697', '130000', '130500', '130528', '1', '1', '河渠镇', '0', '', '1', '0', '0', '10'),
('2698', '130000', '130500', '130528', '1', '1', '北河庄镇', '0', '', '1', '0', '0', '10'),
('2699', '130000', '130500', '130528', '1', '1', '耿庄桥镇', '0', '', '1', '0', '0', '10'),
('2700', '130000', '130500', '130528', '1', '1', '东汪镇', '0', '', '1', '0', '0', '10'),
('2701', '130000', '130500', '130528', '1', '1', '贾家口镇', '0', '', '1', '0', '0', '10'),
('2702', '130000', '130500', '130528', '1', '1', '四芝兰镇', '0', '', '1', '0', '0', '10'),
('2703', '130000', '130500', '130528', '1', '1', '大陆村镇', '0', '', '1', '0', '0', '10'),
('2704', '130000', '130500', '130528', '1', '1', '苏家庄镇', '0', '', '1', '0', '0', '10'),
('2705', '130000', '130500', '130528', '1', '1', '换马店镇', '0', '', '1', '0', '0', '10'),
('2706', '130000', '130500', '130528', '1', '1', '侯口乡', '0', '', '1', '0', '0', '10'),
('2707', '130000', '130500', '130528', '1', '1', '纪昌庄乡', '0', '', '1', '0', '0', '10'),
('2708', '130000', '130500', '130528', '1', '1', '唐邱乡', '0', '', '1', '0', '0', '10'),
('2709', '130000', '130500', '130528', '1', '1', '北鱼乡', '0', '', '1', '0', '0', '10'),
('2710', '130000', '130500', '130528', '1', '1', '徐家河乡', '0', '', '1', '0', '0', '10'),
('2711', '130000', '130500', '130528', '1', '1', '大曹庄乡', '0', '', '1', '0', '0', '10'),
('2712', '130000', '130500', '130528', '1', '1', '大曹庄管理区', '0', '', '1', '0', '0', '10'),
('2713', '130000', '130500', '130529', '1', '1', '巨鹿镇', '0', '', '1', '0', '0', '10'),
('2714', '130000', '130500', '130529', '1', '1', '王虎寨镇', '0', '', '1', '0', '0', '10'),
('2715', '130000', '130500', '130529', '1', '1', '西郭城镇', '0', '', '1', '0', '0', '10'),
('2716', '130000', '130500', '130529', '1', '1', '官亭镇', '0', '', '1', '0', '0', '10'),
('2717', '130000', '130500', '130529', '1', '1', '阎疃镇', '0', '', '1', '0', '0', '10'),
('2718', '130000', '130500', '130529', '1', '1', '小吕寨镇', '0', '', '1', '0', '0', '10'),
('2719', '130000', '130500', '130529', '1', '1', '堤村乡', '0', '', '1', '0', '0', '10'),
('2720', '130000', '130500', '130529', '1', '1', '张王疃乡', '0', '', '1', '0', '0', '10'),
('2721', '130000', '130500', '130529', '1', '1', '观寨乡', '0', '', '1', '0', '0', '10'),
('2722', '130000', '130500', '130529', '1', '1', '苏家营乡', '0', '', '1', '0', '0', '10'),
('2723', '130000', '130500', '130530', '1', '1', '新河镇', '0', '', '1', '0', '0', '10'),
('2724', '130000', '130500', '130530', '1', '1', '寻寨镇', '0', '', '1', '0', '0', '10'),
('2725', '130000', '130500', '130530', '1', '1', '白神首乡', '0', '', '1', '0', '0', '10'),
('2726', '130000', '130500', '130530', '1', '1', '荆家庄乡', '0', '', '1', '0', '0', '10'),
('2727', '130000', '130500', '130530', '1', '1', '西流乡', '0', '', '1', '0', '0', '10'),
('2728', '130000', '130500', '130530', '1', '1', '仁让里乡', '0', '', '1', '0', '0', '10'),
('2729', '130000', '130500', '130531', '1', '1', '广宗镇', '0', '', '1', '0', '0', '10'),
('2730', '130000', '130500', '130531', '1', '1', '葫芦乡', '0', '', '1', '0', '0', '10'),
('2731', '130000', '130500', '130531', '1', '1', '大平台乡', '0', '', '1', '0', '0', '10'),
('2732', '130000', '130500', '130531', '1', '1', '件只乡', '0', '', '1', '0', '0', '10'),
('2733', '130000', '130500', '130531', '1', '1', '核桃园乡', '0', '', '1', '0', '0', '10'),
('2734', '130000', '130500', '130531', '1', '1', '东召乡', '0', '', '1', '0', '0', '10'),
('2735', '130000', '130500', '130531', '1', '1', '北塘疃乡', '0', '', '1', '0', '0', '10'),
('2736', '130000', '130500', '130531', '1', '1', '冯家寨乡', '0', '', '1', '0', '0', '10'),
('2737', '130000', '130500', '130532', '1', '1', '丰州镇', '0', '', '1', '0', '0', '10'),
('2738', '130000', '130500', '130532', '1', '1', '平乡镇', '0', '', '1', '0', '0', '10'),
('2739', '130000', '130500', '130532', '1', '1', '河古庙镇', '0', '', '1', '0', '0', '10'),
('2740', '130000', '130500', '130532', '1', '1', '节固乡', '0', '', '1', '0', '0', '10'),
('2741', '130000', '130500', '130532', '1', '1', '油召乡', '0', '', '1', '0', '0', '10'),
('2742', '130000', '130500', '130532', '1', '1', '田付村乡', '0', '', '1', '0', '0', '10'),
('2743', '130000', '130500', '130532', '1', '1', '寻召乡', '0', '', '1', '0', '0', '10'),
('2744', '130000', '130500', '130533', '1', '1', '名州镇', '0', '', '1', '0', '0', '10'),
('2745', '130000', '130500', '130533', '1', '1', '梨元屯镇', '0', '', '1', '0', '0', '10'),
('2746', '130000', '130500', '130533', '1', '1', '章台镇', '0', '', '1', '0', '0', '10'),
('2747', '130000', '130500', '130533', '1', '1', '侯贯镇', '0', '', '1', '0', '0', '10'),
('2748', '130000', '130500', '130533', '1', '1', '七级镇', '0', '', '1', '0', '0', '10'),
('2749', '130000', '130500', '130533', '1', '1', '方家营乡', '0', '', '1', '0', '0', '10'),
('2750', '130000', '130500', '130533', '1', '1', '第什营乡', '0', '', '1', '0', '0', '10'),
('2751', '130000', '130500', '130533', '1', '1', '枣园乡', '0', '', '1', '0', '0', '10'),
('2752', '130000', '130500', '130533', '1', '1', '固献乡', '0', '', '1', '0', '0', '10'),
('2753', '130000', '130500', '130533', '1', '1', '贺钊乡', '0', '', '1', '0', '0', '10'),
('2754', '130000', '130500', '130533', '1', '1', '贺营乡', '0', '', '1', '0', '0', '10'),
('2755', '130000', '130500', '130533', '1', '1', '张营乡', '0', '', '1', '0', '0', '10'),
('2756', '130000', '130500', '130533', '1', '1', '常屯乡', '0', '', '1', '0', '0', '10'),
('2757', '130000', '130500', '130533', '1', '1', '常庄乡', '0', '', '1', '0', '0', '10'),
('2758', '130000', '130500', '130533', '1', '1', '高公庄乡', '0', '', '1', '0', '0', '10'),
('2759', '130000', '130500', '130533', '1', '1', '赵村乡', '0', '', '1', '0', '0', '10'),
('2760', '130000', '130500', '130534', '1', '1', '葛仙庄镇', '0', '', '1', '0', '0', '10'),
('2761', '130000', '130500', '130534', '1', '1', '连庄镇', '0', '', '1', '0', '0', '10'),
('2762', '130000', '130500', '130534', '1', '1', '油坊镇', '0', '', '1', '0', '0', '10'),
('2763', '130000', '130500', '130534', '1', '1', '谢炉镇', '0', '', '1', '0', '0', '10'),
('2764', '130000', '130500', '130534', '1', '1', '王官庄镇', '0', '', '1', '0', '0', '10'),
('2765', '130000', '130500', '130534', '1', '1', '坝营镇', '0', '', '1', '0', '0', '10'),
('2766', '130000', '130500', '130535', '1', '1', '临西镇', '0', '', '1', '0', '0', '10'),
('2767', '130000', '130500', '130535', '1', '1', '河西镇', '0', '', '1', '0', '0', '10'),
('2768', '130000', '130500', '130535', '1', '1', '下堡寺镇', '0', '', '1', '0', '0', '10'),
('2769', '130000', '130500', '130535', '1', '1', '尖冢镇', '0', '', '1', '0', '0', '10'),
('2770', '130000', '130500', '130535', '1', '1', '东枣园乡', '0', '', '1', '0', '0', '10'),
('2771', '130000', '130500', '130535', '1', '1', '老官寨乡', '0', '', '1', '0', '0', '10'),
('2772', '130000', '130500', '130535', '1', '1', '吕寨乡', '0', '', '1', '0', '0', '10'),
('2773', '130000', '130500', '130535', '1', '1', '摇鞍镇乡', '0', '', '1', '0', '0', '10'),
('2774', '130000', '130500', '130535', '1', '1', '大刘庄乡', '0', '', '1', '0', '0', '10'),
('2775', '130000', '130500', '130581', '1', '1', '凤岗街道', '0', '', '1', '0', '0', '10'),
('2776', '130000', '130500', '130581', '1', '1', '南杜街道', '0', '', '1', '0', '0', '10'),
('2777', '130000', '130500', '130581', '1', '1', '北胡街道', '0', '', '1', '0', '0', '10'),
('2778', '130000', '130500', '130581', '1', '1', '西丁街道', '0', '', '1', '0', '0', '10'),
('2779', '130000', '130500', '130581', '1', '1', '苏村镇', '0', '', '1', '0', '0', '10'),
('2780', '130000', '130500', '130581', '1', '1', '大高村镇', '0', '', '1', '0', '0', '10'),
('2781', '130000', '130500', '130581', '1', '1', '垂杨镇', '0', '', '1', '0', '0', '10'),
('2782', '130000', '130500', '130581', '1', '1', '明化镇', '0', '', '1', '0', '0', '10'),
('2783', '130000', '130500', '130581', '1', '1', '段芦头镇', '0', '', '1', '0', '0', '10'),
('2784', '130000', '130500', '130581', '1', '1', '紫冢镇', '0', '', '1', '0', '0', '10'),
('2785', '130000', '130500', '130581', '1', '1', '大村乡', '0', '', '1', '0', '0', '10'),
('2786', '130000', '130500', '130581', '1', '1', '南便村乡', '0', '', '1', '0', '0', '10'),
('2787', '130000', '130500', '130581', '1', '1', '大屯乡', '0', '', '1', '0', '0', '10'),
('2788', '130000', '130500', '130581', '1', '1', '王道寨乡', '0', '', '1', '0', '0', '10'),
('2789', '130000', '130500', '130581', '1', '1', '薛吴村乡', '0', '', '1', '0', '0', '10'),
('2790', '130000', '130500', '130582', '1', '1', '褡裢街道', '0', '', '1', '0', '0', '10'),
('2791', '130000', '130500', '130582', '1', '1', '桥东街道', '0', '', '1', '0', '0', '10'),
('2792', '130000', '130500', '130582', '1', '1', '桥西街道', '0', '', '1', '0', '0', '10'),
('2793', '130000', '130500', '130582', '1', '1', '赞善街道', '0', '', '1', '0', '0', '10'),
('2794', '130000', '130500', '130582', '1', '1', '周庄街道', '0', '', '1', '0', '0', '10'),
('2795', '130000', '130500', '130582', '1', '1', '沙河城镇', '0', '', '1', '0', '0', '10'),
('2796', '130000', '130500', '130582', '1', '1', '新城镇', '0', '', '1', '0', '0', '10'),
('2797', '130000', '130500', '130582', '1', '1', '白塔镇', '0', '', '1', '0', '0', '10'),
('2798', '130000', '130500', '130582', '1', '1', '十里亭镇', '0', '', '1', '0', '0', '10'),
('2799', '130000', '130500', '130582', '1', '1', '綦村镇', '0', '', '1', '0', '0', '10'),
('2800', '130000', '130500', '130582', '1', '1', '留村乡', '0', '', '1', '0', '0', '10'),
('2801', '130000', '130500', '130582', '1', '1', '册井乡', '0', '', '1', '0', '0', '10'),
('2802', '130000', '130500', '130582', '1', '1', '刘石岗乡', '0', '', '1', '0', '0', '10'),
('2803', '130000', '130500', '130582', '1', '1', '柴关乡', '0', '', '1', '0', '0', '10'),
('2804', '130000', '130500', '130582', '1', '1', '蝉房乡', '0', '', '1', '0', '0', '10'),
('2805', '130000', '130500', '130582', '1', '1', '华北冶金矿山建设公司', '0', '', '1', '0', '0', '10'),
('2806', '130000', '130500', '130582', '1', '1', '华北冶金设备制造厂', '0', '', '1', '0', '0', '10'),
('2807', '130000', '130600', '130602', '1', '1', '先锋街道', '0', '', '1', '0', '0', '10'),
('2808', '130000', '130600', '130602', '1', '1', '新市场街道', '0', '', '1', '0', '0', '10'),
('2809', '130000', '130600', '130602', '1', '1', '东风街道', '0', '', '1', '0', '0', '10'),
('2810', '130000', '130600', '130602', '1', '1', '建南街道', '0', '', '1', '0', '0', '10'),
('2811', '130000', '130600', '130602', '1', '1', '韩村北路街道', '0', '', '1', '0', '0', '10'),
('2812', '130000', '130600', '130602', '1', '1', '颉庄乡', '0', '', '1', '0', '0', '10'),
('2813', '130000', '130600', '130602', '1', '1', '富昌乡', '0', '', '1', '0', '0', '10'),
('2814', '130000', '130600', '130602', '1', '1', '韩村乡', '0', '', '1', '0', '0', '10'),
('2815', '130000', '130600', '130602', '1', '1', '南奇乡', '0', '', '1', '0', '0', '10'),
('2816', '130000', '130600', '130602', '1', '1', '江城乡', '0', '', '1', '0', '0', '10'),
('2817', '130000', '130600', '130602', '1', '1', '大马坊乡', '0', '', '1', '0', '0', '10'),
('2818', '130000', '130600', '130602', '1', '1', '保定国家高新区', '0', '', '1', '0', '0', '10'),
('2819', '130000', '130600', '130603', '1', '1', '和平里街道', '0', '', '1', '0', '0', '10'),
('2820', '130000', '130600', '130603', '1', '1', '五四路街道', '0', '', '1', '0', '0', '10'),
('2821', '130000', '130600', '130603', '1', '1', '西关街道', '0', '', '1', '0', '0', '10'),
('2822', '130000', '130600', '130603', '1', '1', '中华路街道', '0', '', '1', '0', '0', '10'),
('2823', '130000', '130600', '130603', '1', '1', '东关街道', '0', '', '1', '0', '0', '10'),
('2824', '130000', '130600', '130603', '1', '1', '韩庄乡', '0', '', '1', '0', '0', '10'),
('2825', '130000', '130600', '130603', '1', '1', '东金庄乡', '0', '', '1', '0', '0', '10'),
('2826', '130000', '130600', '130603', '1', '1', '百楼乡', '0', '', '1', '0', '0', '10'),
('2827', '130000', '130600', '130604', '1', '1', '联盟街道', '0', '', '1', '0', '0', '10'),
('2828', '130000', '130600', '130604', '1', '1', '红星街道', '0', '', '1', '0', '0', '10'),
('2829', '130000', '130600', '130604', '1', '1', '裕华街道', '0', '', '1', '0', '0', '10'),
('2830', '130000', '130600', '130604', '1', '1', '永华街道', '0', '', '1', '0', '0', '10'),
('2831', '130000', '130600', '130604', '1', '1', '南关街道', '0', '', '1', '0', '0', '10'),
('2832', '130000', '130600', '130604', '1', '1', '杨庄乡', '0', '', '1', '0', '0', '10'),
('2833', '130000', '130600', '130604', '1', '1', '南大园乡', '0', '', '1', '0', '0', '10'),
('2834', '130000', '130600', '130604', '1', '1', '焦庄乡', '0', '', '1', '0', '0', '10'),
('2835', '130000', '130600', '130604', '1', '1', '五尧乡', '0', '', '1', '0', '0', '10'),
('2836', '130000', '130600', '130621', '1', '1', '惠阳街道', '0', '', '1', '0', '0', '10'),
('2837', '130000', '130600', '130621', '1', '1', '满城镇', '0', '', '1', '0', '0', '10'),
('2838', '130000', '130600', '130621', '1', '1', '大册营镇', '0', '', '1', '0', '0', '10'),
('2839', '130000', '130600', '130621', '1', '1', '神星镇', '0', '', '1', '0', '0', '10'),
('2840', '130000', '130600', '130621', '1', '1', '南韩村镇', '0', '', '1', '0', '0', '10'),
('2841', '130000', '130600', '130621', '1', '1', '方顺桥乡', '0', '', '1', '0', '0', '10'),
('2842', '130000', '130600', '130621', '1', '1', '于家庄乡', '0', '', '1', '0', '0', '10'),
('2843', '130000', '130600', '130621', '1', '1', '贤台乡', '0', '', '1', '0', '0', '10'),
('2844', '130000', '130600', '130621', '1', '1', '要庄乡', '0', '', '1', '0', '0', '10'),
('2845', '130000', '130600', '130621', '1', '1', '白龙乡', '0', '', '1', '0', '0', '10'),
('2846', '130000', '130600', '130621', '1', '1', '石井乡', '0', '', '1', '0', '0', '10'),
('2847', '130000', '130600', '130621', '1', '1', '坨南乡', '0', '', '1', '0', '0', '10'),
('2848', '130000', '130600', '130621', '1', '1', '刘家台乡', '0', '', '1', '0', '0', '10'),
('2849', '130000', '130600', '130622', '1', '1', '清苑镇', '0', '', '1', '0', '0', '10'),
('2850', '130000', '130600', '130622', '1', '1', '冉庄镇', '0', '', '1', '0', '0', '10'),
('2851', '130000', '130600', '130622', '1', '1', '阳城镇', '0', '', '1', '0', '0', '10'),
('2852', '130000', '130600', '130622', '1', '1', '魏村镇', '0', '', '1', '0', '0', '10'),
('2853', '130000', '130600', '130622', '1', '1', '温仁镇', '0', '', '1', '0', '0', '10'),
('2854', '130000', '130600', '130622', '1', '1', '张登镇', '0', '', '1', '0', '0', '10'),
('2855', '130000', '130600', '130622', '1', '1', '大庄镇', '0', '', '1', '0', '0', '10'),
('2856', '130000', '130600', '130622', '1', '1', '臧村镇', '0', '', '1', '0', '0', '10'),
('2857', '130000', '130600', '130622', '1', '1', '白团乡', '0', '', '1', '0', '0', '10'),
('2858', '130000', '130600', '130622', '1', '1', '北店乡', '0', '', '1', '0', '0', '10'),
('2859', '130000', '130600', '130622', '1', '1', '石桥乡', '0', '', '1', '0', '0', '10'),
('2860', '130000', '130600', '130622', '1', '1', '李庄乡', '0', '', '1', '0', '0', '10'),
('2861', '130000', '130600', '130622', '1', '1', '北王力乡', '0', '', '1', '0', '0', '10'),
('2862', '130000', '130600', '130622', '1', '1', '东吕乡', '0', '', '1', '0', '0', '10'),
('2863', '130000', '130600', '130622', '1', '1', '何桥乡', '0', '', '1', '0', '0', '10'),
('2864', '130000', '130600', '130622', '1', '1', '孙村乡', '0', '', '1', '0', '0', '10'),
('2865', '130000', '130600', '130622', '1', '1', '阎庄乡', '0', '', '1', '0', '0', '10'),
('2866', '130000', '130600', '130622', '1', '1', '望亭乡', '0', '', '1', '0', '0', '10'),
('2867', '130000', '130600', '130623', '1', '1', '城区社区管理办公室街道', '0', '', '1', '0', '0', '10'),
('2868', '130000', '130600', '130623', '1', '1', '涞水镇', '0', '', '1', '0', '0', '10'),
('2869', '130000', '130600', '130623', '1', '1', '永阳镇', '0', '', '1', '0', '0', '10'),
('2870', '130000', '130600', '130623', '1', '1', '义安镇', '0', '', '1', '0', '0', '10'),
('2871', '130000', '130600', '130623', '1', '1', '石亭镇', '0', '', '1', '0', '0', '10'),
('2872', '130000', '130600', '130623', '1', '1', '赵各庄镇', '0', '', '1', '0', '0', '10'),
('2873', '130000', '130600', '130623', '1', '1', '九龙镇', '0', '', '1', '0', '0', '10'),
('2874', '130000', '130600', '130623', '1', '1', '三坡镇', '0', '', '1', '0', '0', '10'),
('2875', '130000', '130600', '130623', '1', '1', '明义乡', '0', '', '1', '0', '0', '10'),
('2876', '130000', '130600', '130623', '1', '1', '王村乡', '0', '', '1', '0', '0', '10'),
('2877', '130000', '130600', '130623', '1', '1', '东文山乡', '0', '', '1', '0', '0', '10'),
('2878', '130000', '130600', '130623', '1', '1', '娄村满族乡', '0', '', '1', '0', '0', '10'),
('2879', '130000', '130600', '130623', '1', '1', '宋各庄乡', '0', '', '1', '0', '0', '10'),
('2880', '130000', '130600', '130623', '1', '1', '其中口乡', '0', '', '1', '0', '0', '10'),
('2881', '130000', '130600', '130623', '1', '1', '龙门乡', '0', '', '1', '0', '0', '10'),
('2882', '130000', '130600', '130623', '1', '1', '胡家庄乡', '0', '', '1', '0', '0', '10'),
('2883', '130000', '130600', '130624', '1', '1', '阜平镇', '0', '', '1', '0', '0', '10'),
('2884', '130000', '130600', '130624', '1', '1', '龙泉关镇', '0', '', '1', '0', '0', '10'),
('2885', '130000', '130600', '130624', '1', '1', '平阳镇', '0', '', '1', '0', '0', '10'),
('2886', '130000', '130600', '130624', '1', '1', '城南庄镇', '0', '', '1', '0', '0', '10'),
('2887', '130000', '130600', '130624', '1', '1', '东下关乡', '0', '', '1', '0', '0', '10'),
('2888', '130000', '130600', '130624', '1', '1', '王林口乡', '0', '', '1', '0', '0', '10'),
('2889', '130000', '130600', '130624', '1', '1', '台峪乡', '0', '', '1', '0', '0', '10'),
('2890', '130000', '130600', '130624', '1', '1', '大台乡', '0', '', '1', '0', '0', '10'),
('2891', '130000', '130600', '130624', '1', '1', '史家寨乡', '0', '', '1', '0', '0', '10'),
('2892', '130000', '130600', '130624', '1', '1', '砂窝乡', '0', '', '1', '0', '0', '10'),
('2893', '130000', '130600', '130624', '1', '1', '吴王口乡', '0', '', '1', '0', '0', '10'),
('2894', '130000', '130600', '130624', '1', '1', '下庄乡', '0', '', '1', '0', '0', '10'),
('2895', '130000', '130600', '130624', '1', '1', '北果元乡', '0', '', '1', '0', '0', '10'),
('2896', '130000', '130600', '130625', '1', '1', '安肃镇', '0', '', '1', '0', '0', '10'),
('2897', '130000', '130600', '130625', '1', '1', '崔庄镇', '0', '', '1', '0', '0', '10'),
('2898', '130000', '130600', '130625', '1', '1', '大因镇', '0', '', '1', '0', '0', '10'),
('2899', '130000', '130600', '130625', '1', '1', '遂城镇', '0', '', '1', '0', '0', '10'),
('2900', '130000', '130600', '130625', '1', '1', '高林村镇', '0', '', '1', '0', '0', '10'),
('2901', '130000', '130600', '130625', '1', '1', '大王店镇', '0', '', '1', '0', '0', '10'),
('2902', '130000', '130600', '130625', '1', '1', '漕河镇', '0', '', '1', '0', '0', '10'),
('2903', '130000', '130600', '130625', '1', '1', '东史端乡', '0', '', '1', '0', '0', '10'),
('2904', '130000', '130600', '130625', '1', '1', '留村乡', '0', '', '1', '0', '0', '10'),
('2905', '130000', '130600', '130625', '1', '1', '正村乡', '0', '', '1', '0', '0', '10'),
('2906', '130000', '130600', '130625', '1', '1', '户木乡', '0', '', '1', '0', '0', '10'),
('2907', '130000', '130600', '130625', '1', '1', '瀑河乡', '0', '', '1', '0', '0', '10'),
('2908', '130000', '130600', '130625', '1', '1', '东釜山乡', '0', '', '1', '0', '0', '10'),
('2909', '130000', '130600', '130625', '1', '1', '义联庄乡', '0', '', '1', '0', '0', '10'),
('2910', '130000', '130600', '130626', '1', '1', '定兴镇', '0', '', '1', '0', '0', '10'),
('2911', '130000', '130600', '130626', '1', '1', '固城镇', '0', '', '1', '0', '0', '10'),
('2912', '130000', '130600', '130626', '1', '1', '贤寓镇', '0', '', '1', '0', '0', '10'),
('2913', '130000', '130600', '130626', '1', '1', '北河镇', '0', '', '1', '0', '0', '10'),
('2914', '130000', '130600', '130626', '1', '1', '东落堡乡', '0', '', '1', '0', '0', '10'),
('2915', '130000', '130600', '130626', '1', '1', '高里乡', '0', '', '1', '0', '0', '10'),
('2916', '130000', '130600', '130626', '1', '1', '张家庄乡', '0', '', '1', '0', '0', '10'),
('2917', '130000', '130600', '130626', '1', '1', '姚村乡', '0', '', '1', '0', '0', '10'),
('2918', '130000', '130600', '130626', '1', '1', '肖村乡', '0', '', '1', '0', '0', '10'),
('2919', '130000', '130600', '130626', '1', '1', '柳卓乡', '0', '', '1', '0', '0', '10'),
('2920', '130000', '130600', '130626', '1', '1', '杨村乡', '0', '', '1', '0', '0', '10'),
('2921', '130000', '130600', '130626', '1', '1', '北田乡', '0', '', '1', '0', '0', '10'),
('2922', '130000', '130600', '130626', '1', '1', '北南蔡乡', '0', '', '1', '0', '0', '10'),
('2923', '130000', '130600', '130626', '1', '1', '李郁庄乡', '0', '', '1', '0', '0', '10'),
('2924', '130000', '130600', '130626', '1', '1', '天宫寺乡', '0', '', '1', '0', '0', '10'),
('2925', '130000', '130600', '130626', '1', '1', '小朱庄乡', '0', '', '1', '0', '0', '10'),
('2926', '130000', '130600', '130627', '1', '1', '仁厚镇', '0', '', '1', '0', '0', '10'),
('2927', '130000', '130600', '130627', '1', '1', '王京镇', '0', '', '1', '0', '0', '10'),
('2928', '130000', '130600', '130627', '1', '1', '高昌镇', '0', '', '1', '0', '0', '10'),
('2929', '130000', '130600', '130627', '1', '1', '北罗镇', '0', '', '1', '0', '0', '10'),
('2930', '130000', '130600', '130627', '1', '1', '白合镇', '0', '', '1', '0', '0', '10'),
('2931', '130000', '130600', '130627', '1', '1', '军城镇', '0', '', '1', '0', '0', '10'),
('2932', '130000', '130600', '130627', '1', '1', '川里镇', '0', '', '1', '0', '0', '10'),
('2933', '130000', '130600', '130627', '1', '1', '长古城乡', '0', '', '1', '0', '0', '10'),
('2934', '130000', '130600', '130627', '1', '1', '都亭乡', '0', '', '1', '0', '0', '10'),
('2935', '130000', '130600', '130627', '1', '1', '南店头乡', '0', '', '1', '0', '0', '10'),
('2936', '130000', '130600', '130627', '1', '1', '北店头乡', '0', '', '1', '0', '0', '10'),
('2937', '130000', '130600', '130627', '1', '1', '罗庄乡', '0', '', '1', '0', '0', '10'),
('2938', '130000', '130600', '130627', '1', '1', '雹水乡', '0', '', '1', '0', '0', '10'),
('2939', '130000', '130600', '130627', '1', '1', '大洋乡', '0', '', '1', '0', '0', '10'),
('2940', '130000', '130600', '130627', '1', '1', '迷城乡', '0', '', '1', '0', '0', '10'),
('2941', '130000', '130600', '130627', '1', '1', '齐家佐乡', '0', '', '1', '0', '0', '10'),
('2942', '130000', '130600', '130627', '1', '1', '羊角乡', '0', '', '1', '0', '0', '10'),
('2943', '130000', '130600', '130627', '1', '1', '石门乡', '0', '', '1', '0', '0', '10'),
('2944', '130000', '130600', '130627', '1', '1', '黄石口乡', '0', '', '1', '0', '0', '10'),
('2945', '130000', '130600', '130627', '1', '1', '倒马关乡', '0', '', '1', '0', '0', '10'),
('2946', '130000', '130600', '130628', '1', '1', '高阳镇', '0', '', '1', '0', '0', '10'),
('2947', '130000', '130600', '130628', '1', '1', '庞口镇', '0', '', '1', '0', '0', '10'),
('2948', '130000', '130600', '130628', '1', '1', '西演镇', '0', '', '1', '0', '0', '10'),
('2949', '130000', '130600', '130628', '1', '1', '邢家南乡', '0', '', '1', '0', '0', '10'),
('2950', '130000', '130600', '130628', '1', '1', '晋庄乡', '0', '', '1', '0', '0', '10'),
('2951', '130000', '130600', '130628', '1', '1', '蒲口乡', '0', '', '1', '0', '0', '10'),
('2952', '130000', '130600', '130628', '1', '1', '小王果庄乡', '0', '', '1', '0', '0', '10'),
('2953', '130000', '130600', '130628', '1', '1', '龙化乡', '0', '', '1', '0', '0', '10'),
('2954', '130000', '130600', '130628', '1', '1', '庞家佐乡', '0', '', '1', '0', '0', '10'),
('2955', '130000', '130600', '130629', '1', '1', '容城镇', '0', '', '1', '0', '0', '10'),
('2956', '130000', '130600', '130629', '1', '1', '小里镇', '0', '', '1', '0', '0', '10'),
('2957', '130000', '130600', '130629', '1', '1', '南张镇', '0', '', '1', '0', '0', '10'),
('2958', '130000', '130600', '130629', '1', '1', '大河镇', '0', '', '1', '0', '0', '10'),
('2959', '130000', '130600', '130629', '1', '1', '八于乡', '0', '', '1', '0', '0', '10'),
('2960', '130000', '130600', '130629', '1', '1', '贾光乡', '0', '', '1', '0', '0', '10'),
('2961', '130000', '130600', '130629', '1', '1', '晾马台乡', '0', '', '1', '0', '0', '10'),
('2962', '130000', '130600', '130629', '1', '1', '平王乡', '0', '', '1', '0', '0', '10'),
('2963', '130000', '130600', '130630', '1', '1', '涞源镇', '0', '', '1', '0', '0', '10'),
('2964', '130000', '130600', '130630', '1', '1', '银坊镇', '0', '', '1', '0', '0', '10'),
('2965', '130000', '130600', '130630', '1', '1', '走马驿镇', '0', '', '1', '0', '0', '10'),
('2966', '130000', '130600', '130630', '1', '1', '水堡镇', '0', '', '1', '0', '0', '10'),
('2967', '130000', '130600', '130630', '1', '1', '王安镇', '0', '', '1', '0', '0', '10'),
('2968', '130000', '130600', '130630', '1', '1', '杨家庄镇', '0', '', '1', '0', '0', '10'),
('2969', '130000', '130600', '130630', '1', '1', '下北头乡', '0', '', '1', '0', '0', '10'),
('2970', '130000', '130600', '130630', '1', '1', '南屯乡', '0', '', '1', '0', '0', '10'),
('2971', '130000', '130600', '130630', '1', '1', '马庄乡', '0', '', '1', '0', '0', '10'),
('2972', '130000', '130600', '130630', '1', '1', '北石佛乡', '0', '', '1', '0', '0', '10'),
('2973', '130000', '130600', '130630', '1', '1', '金家井乡', '0', '', '1', '0', '0', '10'),
('2974', '130000', '130600', '130630', '1', '1', '留家庄乡', '0', '', '1', '0', '0', '10'),
('2975', '130000', '130600', '130630', '1', '1', '上庄乡', '0', '', '1', '0', '0', '10'),
('2976', '130000', '130600', '130630', '1', '1', '东团堡乡', '0', '', '1', '0', '0', '10'),
('2977', '130000', '130600', '130630', '1', '1', '塔崖驿乡', '0', '', '1', '0', '0', '10'),
('2978', '130000', '130600', '130630', '1', '1', '乌龙沟乡', '0', '', '1', '0', '0', '10'),
('2979', '130000', '130600', '130630', '1', '1', '烟煤洞乡', '0', '', '1', '0', '0', '10'),
('2980', '130000', '130600', '130631', '1', '1', '望都镇', '0', '', '1', '0', '0', '10'),
('2981', '130000', '130600', '130631', '1', '1', '固店镇', '0', '', '1', '0', '0', '10'),
('2982', '130000', '130600', '130631', '1', '1', '寺庄乡', '0', '', '1', '0', '0', '10'),
('2983', '130000', '130600', '130631', '1', '1', '赵庄乡', '0', '', '1', '0', '0', '10'),
('2984', '130000', '130600', '130631', '1', '1', '黑堡乡', '0', '', '1', '0', '0', '10'),
('2985', '130000', '130600', '130631', '1', '1', '高岭乡', '0', '', '1', '0', '0', '10'),
('2986', '130000', '130600', '130631', '1', '1', '中韩庄乡', '0', '', '1', '0', '0', '10'),
('2987', '130000', '130600', '130631', '1', '1', '贾村乡', '0', '', '1', '0', '0', '10'),
('2988', '130000', '130600', '130632', '1', '1', '安新镇', '0', '', '1', '0', '0', '10'),
('2989', '130000', '130600', '130632', '1', '1', '大王镇', '0', '', '1', '0', '0', '10'),
('2990', '130000', '130600', '130632', '1', '1', '三台镇', '0', '', '1', '0', '0', '10'),
('2991', '130000', '130600', '130632', '1', '1', '端村镇', '0', '', '1', '0', '0', '10'),
('2992', '130000', '130600', '130632', '1', '1', '赵北口镇', '0', '', '1', '0', '0', '10'),
('2993', '130000', '130600', '130632', '1', '1', '同口镇', '0', '', '1', '0', '0', '10'),
('2994', '130000', '130600', '130632', '1', '1', '刘李庄镇', '0', '', '1', '0', '0', '10'),
('2995', '130000', '130600', '130632', '1', '1', '安州镇', '0', '', '1', '0', '0', '10'),
('2996', '130000', '130600', '130632', '1', '1', '老河头镇', '0', '', '1', '0', '0', '10'),
('2997', '130000', '130600', '130632', '1', '1', '圈头乡', '0', '', '1', '0', '0', '10'),
('2998', '130000', '130600', '130632', '1', '1', '寨里乡', '0', '', '1', '0', '0', '10'),
('2999', '130000', '130600', '130632', '1', '1', '芦庄乡', '0', '', '1', '0', '0', '10'),
('3000', '130000', '130600', '130633', '1', '1', '易州镇', '0', '', '1', '0', '0', '10'),
('3001', '130000', '130600', '130633', '1', '1', '梁格庄镇', '0', '', '1', '0', '0', '10'),
('3002', '130000', '130600', '130633', '1', '1', '西陵镇', '0', '', '1', '0', '0', '10'),
('3003', '130000', '130600', '130633', '1', '1', '裴山镇', '0', '', '1', '0', '0', '10'),
('3004', '130000', '130600', '130633', '1', '1', '塘湖镇', '0', '', '1', '0', '0', '10'),
('3005', '130000', '130600', '130633', '1', '1', '狼牙山镇', '0', '', '1', '0', '0', '10'),
('3006', '130000', '130600', '130633', '1', '1', '良岗镇', '0', '', '1', '0', '0', '10'),
('3007', '130000', '130600', '130633', '1', '1', '紫荆关镇', '0', '', '1', '0', '0', '10'),
('3008', '130000', '130600', '130633', '1', '1', '桥头乡', '0', '', '1', '0', '0', '10'),
('3009', '130000', '130600', '130633', '1', '1', '白马乡', '0', '', '1', '0', '0', '10'),
('3010', '130000', '130600', '130633', '1', '1', '流井乡', '0', '', '1', '0', '0', '10'),
('3011', '130000', '130600', '130633', '1', '1', '高村乡', '0', '', '1', '0', '0', '10'),
('3012', '130000', '130600', '130633', '1', '1', '高陌乡', '0', '', '1', '0', '0', '10'),
('3013', '130000', '130600', '130633', '1', '1', '大龙华乡', '0', '', '1', '0', '0', '10'),
('3014', '130000', '130600', '130633', '1', '1', '安格庄乡', '0', '', '1', '0', '0', '10'),
('3015', '130000', '130600', '130633', '1', '1', '凌云册乡', '0', '', '1', '0', '0', '10'),
('3016', '130000', '130600', '130633', '1', '1', '西山北乡', '0', '', '1', '0', '0', '10'),
('3017', '130000', '130600', '130633', '1', '1', '尉都乡', '0', '', '1', '0', '0', '10'),
('3018', '130000', '130600', '130633', '1', '1', '独乐乡', '0', '', '1', '0', '0', '10'),
('3019', '130000', '130600', '130633', '1', '1', '七峪乡', '0', '', '1', '0', '0', '10'),
('3020', '130000', '130600', '130633', '1', '1', '富岗乡', '0', '', '1', '0', '0', '10'),
('3021', '130000', '130600', '130633', '1', '1', '坡仓乡', '0', '', '1', '0', '0', '10'),
('3022', '130000', '130600', '130633', '1', '1', '牛岗乡', '0', '', '1', '0', '0', '10'),
('3023', '130000', '130600', '130633', '1', '1', '桥家河乡', '0', '', '1', '0', '0', '10'),
('3024', '130000', '130600', '130633', '1', '1', '甘河净乡', '0', '', '1', '0', '0', '10'),
('3025', '130000', '130600', '130633', '1', '1', '蔡家峪乡', '0', '', '1', '0', '0', '10'),
('3026', '130000', '130600', '130633', '1', '1', '南城司乡', '0', '', '1', '0', '0', '10'),
('3027', '130000', '130600', '130634', '1', '1', '恒州镇', '0', '', '1', '0', '0', '10'),
('3028', '130000', '130600', '130634', '1', '1', '灵山镇', '0', '', '1', '0', '0', '10'),
('3029', '130000', '130600', '130634', '1', '1', '燕赵镇', '0', '', '1', '0', '0', '10'),
('3030', '130000', '130600', '130634', '1', '1', '羊平镇', '0', '', '1', '0', '0', '10'),
('3031', '130000', '130600', '130634', '1', '1', '路庄子乡', '0', '', '1', '0', '0', '10'),
('3032', '130000', '130600', '130634', '1', '1', '下河乡', '0', '', '1', '0', '0', '10'),
('3033', '130000', '130600', '130634', '1', '1', '庄窠乡', '0', '', '1', '0', '0', '10'),
('3034', '130000', '130600', '130634', '1', '1', '孝墓乡', '0', '', '1', '0', '0', '10'),
('3035', '130000', '130600', '130634', '1', '1', '文德乡', '0', '', '1', '0', '0', '10'),
('3036', '130000', '130600', '130634', '1', '1', '东旺乡', '0', '', '1', '0', '0', '10'),
('3037', '130000', '130600', '130634', '1', '1', '晓林乡', '0', '', '1', '0', '0', '10'),
('3038', '130000', '130600', '130634', '1', '1', '邸村乡', '0', '', '1', '0', '0', '10'),
('3039', '130000', '130600', '130634', '1', '1', '产德乡', '0', '', '1', '0', '0', '10'),
('3040', '130000', '130600', '130634', '1', '1', '齐村乡', '0', '', '1', '0', '0', '10'),
('3041', '130000', '130600', '130634', '1', '1', '党城乡', '0', '', '1', '0', '0', '10'),
('3042', '130000', '130600', '130634', '1', '1', '郎家庄乡', '0', '', '1', '0', '0', '10'),
('3043', '130000', '130600', '130634', '1', '1', '范家庄乡', '0', '', '1', '0', '0', '10'),
('3044', '130000', '130600', '130634', '1', '1', '北台乡', '0', '', '1', '0', '0', '10'),
('3045', '130000', '130600', '130635', '1', '1', '蠡吾镇', '0', '', '1', '0', '0', '10'),
('3046', '130000', '130600', '130635', '1', '1', '留史镇', '0', '', '1', '0', '0', '10'),
('3047', '130000', '130600', '130635', '1', '1', '大百尺镇', '0', '', '1', '0', '0', '10'),
('3048', '130000', '130600', '130635', '1', '1', '辛兴镇', '0', '', '1', '0', '0', '10'),
('3049', '130000', '130600', '130635', '1', '1', '北郭丹镇', '0', '', '1', '0', '0', '10'),
('3050', '130000', '130600', '130635', '1', '1', '万安镇', '0', '', '1', '0', '0', '10'),
('3051', '130000', '130600', '130635', '1', '1', '桑园镇', '0', '', '1', '0', '0', '10'),
('3052', '130000', '130600', '130635', '1', '1', '南庄镇', '0', '', '1', '0', '0', '10'),
('3053', '130000', '130600', '130635', '1', '1', '小陈乡', '0', '', '1', '0', '0', '10'),
('3054', '130000', '130600', '130635', '1', '1', '林堡乡', '0', '', '1', '0', '0', '10'),
('3055', '130000', '130600', '130635', '1', '1', '北埝头乡', '0', '', '1', '0', '0', '10'),
('3056', '130000', '130600', '130635', '1', '1', '鲍墟乡', '0', '', '1', '0', '0', '10'),
('3057', '130000', '130600', '130635', '1', '1', '大曲堤乡', '0', '', '1', '0', '0', '10'),
('3058', '130000', '130600', '130636', '1', '1', '蒲阳镇', '0', '', '1', '0', '0', '10'),
('3059', '130000', '130600', '130636', '1', '1', '高于铺镇', '0', '', '1', '0', '0', '10'),
('3060', '130000', '130600', '130636', '1', '1', '腰山镇', '0', '', '1', '0', '0', '10'),
('3061', '130000', '130600', '130636', '1', '1', '蒲上乡', '0', '', '1', '0', '0', '10'),
('3062', '130000', '130600', '130636', '1', '1', '白云乡', '0', '', '1', '0', '0', '10'),
('3063', '130000', '130600', '130636', '1', '1', '河口乡', '0', '', '1', '0', '0', '10'),
('3064', '130000', '130600', '130636', '1', '1', '安阳乡', '0', '', '1', '0', '0', '10'),
('3065', '130000', '130600', '130636', '1', '1', '台鱼乡', '0', '', '1', '0', '0', '10'),
('3066', '130000', '130600', '130636', '1', '1', '大悲乡', '0', '', '1', '0', '0', '10'),
('3067', '130000', '130600', '130636', '1', '1', '神南乡', '0', '', '1', '0', '0', '10'),
('3068', '130000', '130600', '130637', '1', '1', '博野镇', '0', '', '1', '0', '0', '10'),
('3069', '130000', '130600', '130637', '1', '1', '小店镇', '0', '', '1', '0', '0', '10'),
('3070', '130000', '130600', '130637', '1', '1', '程委镇', '0', '', '1', '0', '0', '10'),
('3071', '130000', '130600', '130637', '1', '1', '东墟乡', '0', '', '1', '0', '0', '10'),
('3072', '130000', '130600', '130637', '1', '1', '北杨村乡', '0', '', '1', '0', '0', '10'),
('3073', '130000', '130600', '130637', '1', '1', '城东乡', '0', '', '1', '0', '0', '10'),
('3074', '130000', '130600', '130637', '1', '1', '南小王乡', '0', '', '1', '0', '0', '10'),
('3075', '130000', '130600', '130638', '1', '1', '雄州镇', '0', '', '1', '0', '0', '10'),
('3076', '130000', '130600', '130638', '1', '1', '昝岗镇', '0', '', '1', '0', '0', '10'),
('3077', '130000', '130600', '130638', '1', '1', '大营镇', '0', '', '1', '0', '0', '10'),
('3078', '130000', '130600', '130638', '1', '1', '龙湾镇', '0', '', '1', '0', '0', '10'),
('3079', '130000', '130600', '130638', '1', '1', '北沙口乡', '0', '', '1', '0', '0', '10'),
('3080', '130000', '130600', '130638', '1', '1', '朱各庄乡', '0', '', '1', '0', '0', '10'),
('3081', '130000', '130600', '130638', '1', '1', '米家务乡', '0', '', '1', '0', '0', '10'),
('3082', '130000', '130600', '130638', '1', '1', '双堂乡', '0', '', '1', '0', '0', '10'),
('3083', '130000', '130600', '130638', '1', '1', '张岗乡', '0', '', '1', '0', '0', '10'),
('3084', '130000', '130600', '130681', '1', '1', '双塔街道', '0', '', '1', '0', '0', '10'),
('3085', '130000', '130600', '130681', '1', '1', '桃园街道', '0', '', '1', '0', '0', '10'),
('3086', '130000', '130600', '130681', '1', '1', '清凉寺街道', '0', '', '1', '0', '0', '10'),
('3087', '130000', '130600', '130681', '1', '1', '松林店镇', '0', '', '1', '0', '0', '10'),
('3088', '130000', '130600', '130681', '1', '1', '码头镇', '0', '', '1', '0', '0', '10'),
('3089', '130000', '130600', '130681', '1', '1', '东城坊镇', '0', '', '1', '0', '0', '10'),
('3090', '130000', '130600', '130681', '1', '1', '高官庄镇', '0', '', '1', '0', '0', '10'),
('3091', '130000', '130600', '130681', '1', '1', '东仙坡镇', '0', '', '1', '0', '0', '10'),
('3092', '130000', '130600', '130681', '1', '1', '百尺竿乡', '0', '', '1', '0', '0', '10'),
('3093', '130000', '130600', '130681', '1', '1', '义和庄乡', '0', '', '1', '0', '0', '10'),
('3094', '130000', '130600', '130681', '1', '1', '林家屯乡', '0', '', '1', '0', '0', '10'),
('3095', '130000', '130600', '130681', '1', '1', '孙庄乡', '0', '', '1', '0', '0', '10'),
('3096', '130000', '130600', '130681', '1', '1', '豆庄乡', '0', '', '1', '0', '0', '10');
INSERT INTO `wst_communitys` VALUES ('3097', '130000', '130600', '130681', '1', '1', '刁窝乡', '0', '', '1', '0', '0', '10'),
('3098', '130000', '130600', '130681', '1', '1', '开发区管理委员会', '0', '', '1', '0', '0', '10'),
('3099', '130000', '130600', '130682', '1', '1', '南城区街道', '0', '', '1', '0', '0', '10'),
('3100', '130000', '130600', '130682', '1', '1', '北城区街道', '0', '', '1', '0', '0', '10'),
('3101', '130000', '130600', '130682', '1', '1', '西城区街道', '0', '', '1', '0', '0', '10'),
('3102', '130000', '130600', '130682', '1', '1', '留早镇', '0', '', '1', '0', '0', '10'),
('3103', '130000', '130600', '130682', '1', '1', '清风店镇', '0', '', '1', '0', '0', '10'),
('3104', '130000', '130600', '130682', '1', '1', '庞村镇', '0', '', '1', '0', '0', '10'),
('3105', '130000', '130600', '130682', '1', '1', '砖路镇', '0', '', '1', '0', '0', '10'),
('3106', '130000', '130600', '130682', '1', '1', '明月店镇', '0', '', '1', '0', '0', '10'),
('3107', '130000', '130600', '130682', '1', '1', '叮咛店镇', '0', '', '1', '0', '0', '10'),
('3108', '130000', '130600', '130682', '1', '1', '东亭镇', '0', '', '1', '0', '0', '10'),
('3109', '130000', '130600', '130682', '1', '1', '大辛庄镇', '0', '', '1', '0', '0', '10'),
('3110', '130000', '130600', '130682', '1', '1', '东旺镇', '0', '', '1', '0', '0', '10'),
('3111', '130000', '130600', '130682', '1', '1', '高蓬镇', '0', '', '1', '0', '0', '10'),
('3112', '130000', '130600', '130682', '1', '1', '邢邑镇', '0', '', '1', '0', '0', '10'),
('3113', '130000', '130600', '130682', '1', '1', '李亲顾镇', '0', '', '1', '0', '0', '10'),
('3114', '130000', '130600', '130682', '1', '1', '子位镇', '0', '', '1', '0', '0', '10'),
('3115', '130000', '130600', '130682', '1', '1', '开元镇', '0', '', '1', '0', '0', '10'),
('3116', '130000', '130600', '130682', '1', '1', '赵村乡', '0', '', '1', '0', '0', '10'),
('3117', '130000', '130600', '130682', '1', '1', '周村乡', '0', '', '1', '0', '0', '10'),
('3118', '130000', '130600', '130682', '1', '1', '东留春乡', '0', '', '1', '0', '0', '10'),
('3119', '130000', '130600', '130682', '1', '1', '号头庄回族乡', '0', '', '1', '0', '0', '10'),
('3120', '130000', '130600', '130682', '1', '1', '杨家庄乡', '0', '', '1', '0', '0', '10'),
('3121', '130000', '130600', '130682', '1', '1', '大鹿庄乡', '0', '', '1', '0', '0', '10'),
('3122', '130000', '130600', '130682', '1', '1', '息冢乡', '0', '', '1', '0', '0', '10'),
('3123', '130000', '130600', '130682', '1', '1', '西城乡', '0', '', '1', '0', '0', '10'),
('3124', '130000', '130600', '130683', '1', '1', '祁州药市街道', '0', '', '1', '0', '0', '10'),
('3125', '130000', '130600', '130683', '1', '1', '祁州镇', '0', '', '1', '0', '0', '10'),
('3126', '130000', '130600', '130683', '1', '1', '伍仁桥镇', '0', '', '1', '0', '0', '10'),
('3127', '130000', '130600', '130683', '1', '1', '石佛镇', '0', '', '1', '0', '0', '10'),
('3128', '130000', '130600', '130683', '1', '1', '郑章镇', '0', '', '1', '0', '0', '10'),
('3129', '130000', '130600', '130683', '1', '1', '大五女镇', '0', '', '1', '0', '0', '10'),
('3130', '130000', '130600', '130683', '1', '1', '明官店乡', '0', '', '1', '0', '0', '10'),
('3131', '130000', '130600', '130683', '1', '1', '南娄底乡', '0', '', '1', '0', '0', '10'),
('3132', '130000', '130600', '130683', '1', '1', '西安国城乡', '0', '', '1', '0', '0', '10'),
('3133', '130000', '130600', '130683', '1', '1', '西佛落乡', '0', '', '1', '0', '0', '10'),
('3134', '130000', '130600', '130683', '1', '1', '北段村乡', '0', '', '1', '0', '0', '10'),
('3135', '130000', '130600', '130684', '1', '1', '和平街道', '0', '', '1', '0', '0', '10'),
('3136', '130000', '130600', '130684', '1', '1', '军城街道', '0', '', '1', '0', '0', '10'),
('3137', '130000', '130600', '130684', '1', '1', '东盛街道', '0', '', '1', '0', '0', '10'),
('3138', '130000', '130600', '130684', '1', '1', '北城街道', '0', '', '1', '0', '0', '10'),
('3139', '130000', '130600', '130684', '1', '1', '兴华路街道', '0', '', '1', '0', '0', '10'),
('3140', '130000', '130600', '130684', '1', '1', '方官镇', '0', '', '1', '0', '0', '10'),
('3141', '130000', '130600', '130684', '1', '1', '新城镇', '0', '', '1', '0', '0', '10'),
('3142', '130000', '130600', '130684', '1', '1', '泗庄镇', '0', '', '1', '0', '0', '10'),
('3143', '130000', '130600', '130684', '1', '1', '白沟镇', '0', '', '1', '0', '0', '10'),
('3144', '130000', '130600', '130684', '1', '1', '辛立庄镇', '0', '', '1', '0', '0', '10'),
('3145', '130000', '130600', '130684', '1', '1', '肖官营乡', '0', '', '1', '0', '0', '10'),
('3146', '130000', '130600', '130684', '1', '1', '梁家营乡', '0', '', '1', '0', '0', '10'),
('3147', '130000', '130600', '130684', '1', '1', '张六庄乡', '0', '', '1', '0', '0', '10'),
('3148', '130000', '130600', '130684', '1', '1', '东马营乡', '0', '', '1', '0', '0', '10'),
('3149', '130000', '130600', '130684', '1', '1', '辛桥乡', '0', '', '1', '0', '0', '10'),
('3150', '130000', '130700', '130702', '1', '1', '红旗楼街道', '0', '', '1', '0', '0', '10'),
('3151', '130000', '130700', '130702', '1', '1', '胜利北路街道', '0', '', '1', '0', '0', '10'),
('3152', '130000', '130700', '130702', '1', '1', '五一路街道', '0', '', '1', '0', '0', '10'),
('3153', '130000', '130700', '130702', '1', '1', '花园街街道', '0', '', '1', '0', '0', '10'),
('3154', '130000', '130700', '130702', '1', '1', '工业路街道', '0', '', '1', '0', '0', '10'),
('3155', '130000', '130700', '130702', '1', '1', '南站街道', '0', '', '1', '0', '0', '10'),
('3156', '130000', '130700', '130702', '1', '1', '马路东街道', '0', '', '1', '0', '0', '10'),
('3157', '130000', '130700', '130702', '1', '1', '老鸦庄镇', '0', '', '1', '0', '0', '10'),
('3158', '130000', '130700', '130702', '1', '1', '姚家庄镇', '0', '', '1', '0', '0', '10'),
('3159', '130000', '130700', '130703', '1', '1', '新华街街道', '0', '', '1', '0', '0', '10'),
('3160', '130000', '130700', '130703', '1', '1', '大境门街道', '0', '', '1', '0', '0', '10'),
('3161', '130000', '130700', '130703', '1', '1', '明德北街街道', '0', '', '1', '0', '0', '10'),
('3162', '130000', '130700', '130703', '1', '1', '明德南街街道', '0', '', '1', '0', '0', '10'),
('3163', '130000', '130700', '130703', '1', '1', '堡子里街道', '0', '', '1', '0', '0', '10'),
('3164', '130000', '130700', '130703', '1', '1', '南营坊街道', '0', '', '1', '0', '0', '10'),
('3165', '130000', '130700', '130703', '1', '1', '工人新村街道', '0', '', '1', '0', '0', '10'),
('3166', '130000', '130700', '130703', '1', '1', '东窑子镇', '0', '', '1', '0', '0', '10'),
('3167', '130000', '130700', '130703', '1', '1', '沈家屯镇', '0', '', '1', '0', '0', '10'),
('3168', '130000', '130700', '130705', '1', '1', '天泰寺街道', '0', '', '1', '0', '0', '10'),
('3169', '130000', '130700', '130705', '1', '1', '皇城街道', '0', '', '1', '0', '0', '10'),
('3170', '130000', '130700', '130705', '1', '1', '南关街道', '0', '', '1', '0', '0', '10'),
('3171', '130000', '130700', '130705', '1', '1', '南大街街道', '0', '', '1', '0', '0', '10'),
('3172', '130000', '130700', '130705', '1', '1', '大北街街道', '0', '', '1', '0', '0', '10'),
('3173', '130000', '130700', '130705', '1', '1', '工业街街道', '0', '', '1', '0', '0', '10'),
('3174', '130000', '130700', '130705', '1', '1', '建国街街道', '0', '', '1', '0', '0', '10'),
('3175', '130000', '130700', '130705', '1', '1', '庞家堡镇', '0', '', '1', '0', '0', '10'),
('3176', '130000', '130700', '130705', '1', '1', '河子西乡', '0', '', '1', '0', '0', '10'),
('3177', '130000', '130700', '130705', '1', '1', '春光乡', '0', '', '1', '0', '0', '10'),
('3178', '130000', '130700', '130705', '1', '1', '侯家庙乡', '0', '', '1', '0', '0', '10'),
('3179', '130000', '130700', '130706', '1', '1', '城镇街道', '0', '', '1', '0', '0', '10'),
('3180', '130000', '130700', '130706', '1', '1', '煤矿街道', '0', '', '1', '0', '0', '10'),
('3181', '130000', '130700', '130706', '1', '1', '花园乡', '0', '', '1', '0', '0', '10'),
('3182', '130000', '130700', '130706', '1', '1', '辛庄子乡', '0', '', '1', '0', '0', '10'),
('3183', '130000', '130700', '130706', '1', '1', '定方水乡', '0', '', '1', '0', '0', '10'),
('3184', '130000', '130700', '130706', '1', '1', '段家堡乡', '0', '', '1', '0', '0', '10'),
('3185', '130000', '130700', '130721', '1', '1', '洋河南镇', '0', '', '1', '0', '0', '10'),
('3186', '130000', '130700', '130721', '1', '1', '深井镇', '0', '', '1', '0', '0', '10'),
('3187', '130000', '130700', '130721', '1', '1', '崞村镇', '0', '', '1', '0', '0', '10'),
('3188', '130000', '130700', '130721', '1', '1', '沙岭子镇', '0', '', '1', '0', '0', '10'),
('3189', '130000', '130700', '130721', '1', '1', '姚家房镇', '0', '', '1', '0', '0', '10'),
('3190', '130000', '130700', '130721', '1', '1', '大仓盖镇', '0', '', '1', '0', '0', '10'),
('3191', '130000', '130700', '130721', '1', '1', '贾家营镇', '0', '', '1', '0', '0', '10'),
('3192', '130000', '130700', '130721', '1', '1', '顾家营镇', '0', '', '1', '0', '0', '10'),
('3193', '130000', '130700', '130721', '1', '1', '赵川镇', '0', '', '1', '0', '0', '10'),
('3194', '130000', '130700', '130721', '1', '1', '王家湾乡', '0', '', '1', '0', '0', '10'),
('3195', '130000', '130700', '130721', '1', '1', '塔儿村乡', '0', '', '1', '0', '0', '10'),
('3196', '130000', '130700', '130721', '1', '1', '江家屯乡', '0', '', '1', '0', '0', '10'),
('3197', '130000', '130700', '130721', '1', '1', '东望山乡', '0', '', '1', '0', '0', '10'),
('3198', '130000', '130700', '130721', '1', '1', '李家堡乡', '0', '', '1', '0', '0', '10'),
('3199', '130000', '130700', '130722', '1', '1', '张北镇', '0', '', '1', '0', '0', '10'),
('3200', '130000', '130700', '130722', '1', '1', '公会镇', '0', '', '1', '0', '0', '10'),
('3201', '130000', '130700', '130722', '1', '1', '二台镇', '0', '', '1', '0', '0', '10'),
('3202', '130000', '130700', '130722', '1', '1', '大囫囵镇', '0', '', '1', '0', '0', '10'),
('3203', '130000', '130700', '130722', '1', '1', '台路沟乡', '0', '', '1', '0', '0', '10'),
('3204', '130000', '130700', '130722', '1', '1', '油篓沟乡', '0', '', '1', '0', '0', '10'),
('3205', '130000', '130700', '130722', '1', '1', '馒头营乡', '0', '', '1', '0', '0', '10'),
('3206', '130000', '130700', '130722', '1', '1', '二泉井乡', '0', '', '1', '0', '0', '10'),
('3207', '130000', '130700', '130722', '1', '1', '单晶河乡', '0', '', '1', '0', '0', '10'),
('3208', '130000', '130700', '130722', '1', '1', '大河乡', '0', '', '1', '0', '0', '10'),
('3209', '130000', '130700', '130722', '1', '1', '海流图乡', '0', '', '1', '0', '0', '10'),
('3210', '130000', '130700', '130722', '1', '1', '两面井乡', '0', '', '1', '0', '0', '10'),
('3211', '130000', '130700', '130722', '1', '1', '大西湾乡', '0', '', '1', '0', '0', '10'),
('3212', '130000', '130700', '130722', '1', '1', '郝家营乡', '0', '', '1', '0', '0', '10'),
('3213', '130000', '130700', '130722', '1', '1', '白庙滩乡', '0', '', '1', '0', '0', '10'),
('3214', '130000', '130700', '130722', '1', '1', '小二台乡', '0', '', '1', '0', '0', '10'),
('3215', '130000', '130700', '130722', '1', '1', '战海乡', '0', '', '1', '0', '0', '10'),
('3216', '130000', '130700', '130722', '1', '1', '三号乡', '0', '', '1', '0', '0', '10'),
('3217', '130000', '130700', '130722', '1', '1', '沙沟乡', '0', '', '1', '0', '0', '10'),
('3218', '130000', '130700', '130722', '1', '1', '宇宙营乡', '0', '', '1', '0', '0', '10'),
('3219', '130000', '130700', '130722', '1', '1', '察北虚拟乡', '0', '', '1', '0', '0', '10'),
('3220', '130000', '130700', '130723', '1', '1', '康保镇', '0', '', '1', '0', '0', '10'),
('3221', '130000', '130700', '130723', '1', '1', '张纪镇', '0', '', '1', '0', '0', '10'),
('3222', '130000', '130700', '130723', '1', '1', '土城子镇', '0', '', '1', '0', '0', '10'),
('3223', '130000', '130700', '130723', '1', '1', '邓油坊镇', '0', '', '1', '0', '0', '10'),
('3224', '130000', '130700', '130723', '1', '1', '李家地镇', '0', '', '1', '0', '0', '10'),
('3225', '130000', '130700', '130723', '1', '1', '照阳河镇', '0', '', '1', '0', '0', '10'),
('3226', '130000', '130700', '130723', '1', '1', '屯垦镇', '0', '', '1', '0', '0', '10'),
('3227', '130000', '130700', '130723', '1', '1', '阎油房乡', '0', '', '1', '0', '0', '10'),
('3228', '130000', '130700', '130723', '1', '1', '丹清河乡', '0', '', '1', '0', '0', '10'),
('3229', '130000', '130700', '130723', '1', '1', '哈必嘎乡', '0', '', '1', '0', '0', '10'),
('3230', '130000', '130700', '130723', '1', '1', '二号卜乡', '0', '', '1', '0', '0', '10'),
('3231', '130000', '130700', '130723', '1', '1', '芦家营乡', '0', '', '1', '0', '0', '10'),
('3232', '130000', '130700', '130723', '1', '1', '忠义乡', '0', '', '1', '0', '0', '10'),
('3233', '130000', '130700', '130723', '1', '1', '处长地乡', '0', '', '1', '0', '0', '10'),
('3234', '130000', '130700', '130723', '1', '1', '满德堂乡', '0', '', '1', '0', '0', '10'),
('3235', '130000', '130700', '130723', '1', '1', '康保牧场虚拟乡', '0', '', '1', '0', '0', '10'),
('3236', '130000', '130700', '130724', '1', '1', '平定堡镇', '0', '', '1', '0', '0', '10'),
('3237', '130000', '130700', '130724', '1', '1', '小厂镇', '0', '', '1', '0', '0', '10'),
('3238', '130000', '130700', '130724', '1', '1', '黄盖淖镇', '0', '', '1', '0', '0', '10'),
('3239', '130000', '130700', '130724', '1', '1', '九连城镇', '0', '', '1', '0', '0', '10'),
('3240', '130000', '130700', '130724', '1', '1', '高山堡乡', '0', '', '1', '0', '0', '10'),
('3241', '130000', '130700', '130724', '1', '1', '小河子乡', '0', '', '1', '0', '0', '10'),
('3242', '130000', '130700', '130724', '1', '1', '二道渠乡', '0', '', '1', '0', '0', '10'),
('3243', '130000', '130700', '130724', '1', '1', '大二号回族乡', '0', '', '1', '0', '0', '10'),
('3244', '130000', '130700', '130724', '1', '1', '闪电河乡', '0', '', '1', '0', '0', '10'),
('3245', '130000', '130700', '130724', '1', '1', '长梁乡', '0', '', '1', '0', '0', '10'),
('3246', '130000', '130700', '130724', '1', '1', '丰源店乡', '0', '', '1', '0', '0', '10'),
('3247', '130000', '130700', '130724', '1', '1', '西辛营乡', '0', '', '1', '0', '0', '10'),
('3248', '130000', '130700', '130724', '1', '1', '莲花滩乡', '0', '', '1', '0', '0', '10'),
('3249', '130000', '130700', '130724', '1', '1', '白土窑乡', '0', '', '1', '0', '0', '10'),
('3250', '130000', '130700', '130724', '1', '1', '榆树沟虚拟乡', '0', '', '1', '0', '0', '10'),
('3251', '130000', '130700', '130724', '1', '1', '沙埌子虚拟乡', '0', '', '1', '0', '0', '10'),
('3252', '130000', '130700', '130724', '1', '1', '小城子虚拟乡', '0', '', '1', '0', '0', '10'),
('3253', '130000', '130700', '130724', '1', '1', '东大门虚拟乡', '0', '', '1', '0', '0', '10'),
('3254', '130000', '130700', '130725', '1', '1', '南壕堑镇', '0', '', '1', '0', '0', '10'),
('3255', '130000', '130700', '130725', '1', '1', '大青沟镇', '0', '', '1', '0', '0', '10'),
('3256', '130000', '130700', '130725', '1', '1', '八道沟镇', '0', '', '1', '0', '0', '10'),
('3257', '130000', '130700', '130725', '1', '1', '红土梁镇', '0', '', '1', '0', '0', '10'),
('3258', '130000', '130700', '130725', '1', '1', '小蒜沟镇', '0', '', '1', '0', '0', '10'),
('3259', '130000', '130700', '130725', '1', '1', '三工地镇', '0', '', '1', '0', '0', '10'),
('3260', '130000', '130700', '130725', '1', '1', '大营盘乡', '0', '', '1', '0', '0', '10'),
('3261', '130000', '130700', '130725', '1', '1', '大苏计乡', '0', '', '1', '0', '0', '10'),
('3262', '130000', '130700', '130725', '1', '1', '石井乡', '0', '', '1', '0', '0', '10'),
('3263', '130000', '130700', '130725', '1', '1', '炕塄乡', '0', '', '1', '0', '0', '10'),
('3264', '130000', '130700', '130725', '1', '1', '七甲乡', '0', '', '1', '0', '0', '10'),
('3265', '130000', '130700', '130725', '1', '1', '套里庄乡', '0', '', '1', '0', '0', '10'),
('3266', '130000', '130700', '130725', '1', '1', '甲石河乡', '0', '', '1', '0', '0', '10'),
('3267', '130000', '130700', '130725', '1', '1', '下马圈乡', '0', '', '1', '0', '0', '10'),
('3268', '130000', '130700', '130726', '1', '1', '蔚州镇', '0', '', '1', '0', '0', '10'),
('3269', '130000', '130700', '130726', '1', '1', '代王城镇', '0', '', '1', '0', '0', '10'),
('3270', '130000', '130700', '130726', '1', '1', '西合营镇', '0', '', '1', '0', '0', '10'),
('3271', '130000', '130700', '130726', '1', '1', '吉家庄镇', '0', '', '1', '0', '0', '10'),
('3272', '130000', '130700', '130726', '1', '1', '白乐镇', '0', '', '1', '0', '0', '10'),
('3273', '130000', '130700', '130726', '1', '1', '暖泉镇', '0', '', '1', '0', '0', '10'),
('3274', '130000', '130700', '130726', '1', '1', '南留庄镇', '0', '', '1', '0', '0', '10'),
('3275', '130000', '130700', '130726', '1', '1', '北水泉镇', '0', '', '1', '0', '0', '10'),
('3276', '130000', '130700', '130726', '1', '1', '桃花镇', '0', '', '1', '0', '0', '10'),
('3277', '130000', '130700', '130726', '1', '1', '阳眷镇', '0', '', '1', '0', '0', '10'),
('3278', '130000', '130700', '130726', '1', '1', '宋家庄镇', '0', '', '1', '0', '0', '10'),
('3279', '130000', '130700', '130726', '1', '1', '下宫村乡', '0', '', '1', '0', '0', '10'),
('3280', '130000', '130700', '130726', '1', '1', '南杨庄乡', '0', '', '1', '0', '0', '10'),
('3281', '130000', '130700', '130726', '1', '1', '柏树乡', '0', '', '1', '0', '0', '10'),
('3282', '130000', '130700', '130726', '1', '1', '常宁乡', '0', '', '1', '0', '0', '10'),
('3283', '130000', '130700', '130726', '1', '1', '涌泉庄乡', '0', '', '1', '0', '0', '10'),
('3284', '130000', '130700', '130726', '1', '1', '杨庄窠乡', '0', '', '1', '0', '0', '10'),
('3285', '130000', '130700', '130726', '1', '1', '南岭庄乡', '0', '', '1', '0', '0', '10'),
('3286', '130000', '130700', '130726', '1', '1', '陈家洼乡', '0', '', '1', '0', '0', '10'),
('3287', '130000', '130700', '130726', '1', '1', '黄梅乡', '0', '', '1', '0', '0', '10'),
('3288', '130000', '130700', '130726', '1', '1', '白草村乡', '0', '', '1', '0', '0', '10'),
('3289', '130000', '130700', '130726', '1', '1', '草沟堡乡', '0', '', '1', '0', '0', '10'),
('3290', '130000', '130700', '130727', '1', '1', '西城镇', '0', '', '1', '0', '0', '10'),
('3291', '130000', '130700', '130727', '1', '1', '东城镇', '0', '', '1', '0', '0', '10'),
('3292', '130000', '130700', '130727', '1', '1', '化稍营镇', '0', '', '1', '0', '0', '10'),
('3293', '130000', '130700', '130727', '1', '1', '揣骨疃镇', '0', '', '1', '0', '0', '10'),
('3294', '130000', '130700', '130727', '1', '1', '东井集镇', '0', '', '1', '0', '0', '10'),
('3295', '130000', '130700', '130727', '1', '1', '要家庄乡', '0', '', '1', '0', '0', '10'),
('3296', '130000', '130700', '130727', '1', '1', '东坊城堡乡', '0', '', '1', '0', '0', '10'),
('3297', '130000', '130700', '130727', '1', '1', '井儿沟乡', '0', '', '1', '0', '0', '10'),
('3298', '130000', '130700', '130727', '1', '1', '三马坊乡', '0', '', '1', '0', '0', '10'),
('3299', '130000', '130700', '130727', '1', '1', '高墙乡', '0', '', '1', '0', '0', '10'),
('3300', '130000', '130700', '130727', '1', '1', '大田洼乡', '0', '', '1', '0', '0', '10'),
('3301', '130000', '130700', '130727', '1', '1', '辛堡乡', '0', '', '1', '0', '0', '10'),
('3302', '130000', '130700', '130727', '1', '1', '马圈堡乡', '0', '', '1', '0', '0', '10'),
('3303', '130000', '130700', '130727', '1', '1', '浮图讲乡', '0', '', '1', '0', '0', '10'),
('3304', '130000', '130700', '130728', '1', '1', '柴沟堡镇', '0', '', '1', '0', '0', '10'),
('3305', '130000', '130700', '130728', '1', '1', '左卫镇', '0', '', '1', '0', '0', '10'),
('3306', '130000', '130700', '130728', '1', '1', '头百户镇', '0', '', '1', '0', '0', '10'),
('3307', '130000', '130700', '130728', '1', '1', '怀安城镇', '0', '', '1', '0', '0', '10'),
('3308', '130000', '130700', '130728', '1', '1', '渡口堡乡', '0', '', '1', '0', '0', '10'),
('3309', '130000', '130700', '130728', '1', '1', '第六屯乡', '0', '', '1', '0', '0', '10'),
('3310', '130000', '130700', '130728', '1', '1', '西湾堡乡', '0', '', '1', '0', '0', '10'),
('3311', '130000', '130700', '130728', '1', '1', '西沙城乡', '0', '', '1', '0', '0', '10'),
('3312', '130000', '130700', '130728', '1', '1', '太平庄乡', '0', '', '1', '0', '0', '10'),
('3313', '130000', '130700', '130728', '1', '1', '王虎屯乡', '0', '', '1', '0', '0', '10'),
('3314', '130000', '130700', '130728', '1', '1', '第三堡乡', '0', '', '1', '0', '0', '10'),
('3315', '130000', '130700', '130729', '1', '1', '孔家庄镇', '0', '', '1', '0', '0', '10'),
('3316', '130000', '130700', '130729', '1', '1', '万全镇', '0', '', '1', '0', '0', '10'),
('3317', '130000', '130700', '130729', '1', '1', '洗马林镇', '0', '', '1', '0', '0', '10'),
('3318', '130000', '130700', '130729', '1', '1', '郭磊庄镇', '0', '', '1', '0', '0', '10'),
('3319', '130000', '130700', '130729', '1', '1', '膳房堡乡', '0', '', '1', '0', '0', '10'),
('3320', '130000', '130700', '130729', '1', '1', '北新屯乡', '0', '', '1', '0', '0', '10'),
('3321', '130000', '130700', '130729', '1', '1', '宣平堡乡', '0', '', '1', '0', '0', '10'),
('3322', '130000', '130700', '130729', '1', '1', '高庙堡乡', '0', '', '1', '0', '0', '10'),
('3323', '130000', '130700', '130729', '1', '1', '旧堡乡', '0', '', '1', '0', '0', '10'),
('3324', '130000', '130700', '130729', '1', '1', '安家堡乡', '0', '', '1', '0', '0', '10'),
('3325', '130000', '130700', '130729', '1', '1', '北沙城乡', '0', '', '1', '0', '0', '10'),
('3326', '130000', '130700', '130730', '1', '1', '沙城镇', '0', '', '1', '0', '0', '10'),
('3327', '130000', '130700', '130730', '1', '1', '北辛堡镇', '0', '', '1', '0', '0', '10'),
('3328', '130000', '130700', '130730', '1', '1', '新保安镇', '0', '', '1', '0', '0', '10'),
('3329', '130000', '130700', '130730', '1', '1', '东花园镇', '0', '', '1', '0', '0', '10'),
('3330', '130000', '130700', '130730', '1', '1', '官厅镇', '0', '', '1', '0', '0', '10'),
('3331', '130000', '130700', '130730', '1', '1', '桑园镇', '0', '', '1', '0', '0', '10'),
('3332', '130000', '130700', '130730', '1', '1', '存瑞镇', '0', '', '1', '0', '0', '10'),
('3333', '130000', '130700', '130730', '1', '1', '土木镇', '0', '', '1', '0', '0', '10'),
('3334', '130000', '130700', '130730', '1', '1', '大黄庄镇', '0', '', '1', '0', '0', '10'),
('3335', '130000', '130700', '130730', '1', '1', '西八里镇', '0', '', '1', '0', '0', '10'),
('3336', '130000', '130700', '130730', '1', '1', '小南辛堡镇', '0', '', '1', '0', '0', '10'),
('3337', '130000', '130700', '130730', '1', '1', '狼山乡', '0', '', '1', '0', '0', '10'),
('3338', '130000', '130700', '130730', '1', '1', '鸡鸣驿乡', '0', '', '1', '0', '0', '10'),
('3339', '130000', '130700', '130730', '1', '1', '东八里乡', '0', '', '1', '0', '0', '10'),
('3340', '130000', '130700', '130730', '1', '1', '瑞云观乡', '0', '', '1', '0', '0', '10'),
('3341', '130000', '130700', '130730', '1', '1', '孙庄子乡', '0', '', '1', '0', '0', '10'),
('3342', '130000', '130700', '130730', '1', '1', '王家楼回族乡', '0', '', '1', '0', '0', '10'),
('3343', '130000', '130700', '130731', '1', '1', '涿鹿镇', '0', '', '1', '0', '0', '10'),
('3344', '130000', '130700', '130731', '1', '1', '张家堡镇', '0', '', '1', '0', '0', '10'),
('3345', '130000', '130700', '130731', '1', '1', '武家沟镇', '0', '', '1', '0', '0', '10'),
('3346', '130000', '130700', '130731', '1', '1', '五堡镇', '0', '', '1', '0', '0', '10'),
('3347', '130000', '130700', '130731', '1', '1', '保岱镇', '0', '', '1', '0', '0', '10'),
('3348', '130000', '130700', '130731', '1', '1', '矾山镇', '0', '', '1', '0', '0', '10'),
('3349', '130000', '130700', '130731', '1', '1', '大堡镇', '0', '', '1', '0', '0', '10'),
('3350', '130000', '130700', '130731', '1', '1', '河东镇', '0', '', '1', '0', '0', '10'),
('3351', '130000', '130700', '130731', '1', '1', '东小庄乡', '0', '', '1', '0', '0', '10'),
('3352', '130000', '130700', '130731', '1', '1', '栾庄乡', '0', '', '1', '0', '0', '10'),
('3353', '130000', '130700', '130731', '1', '1', '温泉屯乡', '0', '', '1', '0', '0', '10'),
('3354', '130000', '130700', '130731', '1', '1', '辉耀乡', '0', '', '1', '0', '0', '10'),
('3355', '130000', '130700', '130731', '1', '1', '黑山寺乡', '0', '', '1', '0', '0', '10'),
('3356', '130000', '130700', '130731', '1', '1', '卧佛寺乡', '0', '', '1', '0', '0', '10'),
('3357', '130000', '130700', '130731', '1', '1', '谢家堡乡', '0', '', '1', '0', '0', '10'),
('3358', '130000', '130700', '130731', '1', '1', '大河南乡', '0', '', '1', '0', '0', '10'),
('3359', '130000', '130700', '130731', '1', '1', '蟒石口乡', '0', '', '1', '0', '0', '10'),
('3360', '130000', '130700', '130732', '1', '1', '赤城镇', '0', '', '1', '0', '0', '10'),
('3361', '130000', '130700', '130732', '1', '1', '田家窑镇', '0', '', '1', '0', '0', '10'),
('3362', '130000', '130700', '130732', '1', '1', '龙关镇', '0', '', '1', '0', '0', '10'),
('3363', '130000', '130700', '130732', '1', '1', '雕鄂镇', '0', '', '1', '0', '0', '10'),
('3364', '130000', '130700', '130732', '1', '1', '独石口镇', '0', '', '1', '0', '0', '10'),
('3365', '130000', '130700', '130732', '1', '1', '白草镇', '0', '', '1', '0', '0', '10'),
('3366', '130000', '130700', '130732', '1', '1', '龙门所镇', '0', '', '1', '0', '0', '10'),
('3367', '130000', '130700', '130732', '1', '1', '后城镇', '0', '', '1', '0', '0', '10'),
('3368', '130000', '130700', '130732', '1', '1', '东卯镇', '0', '', '1', '0', '0', '10'),
('3369', '130000', '130700', '130732', '1', '1', '炮梁乡', '0', '', '1', '0', '0', '10'),
('3370', '130000', '130700', '130732', '1', '1', '大海陀乡', '0', '', '1', '0', '0', '10'),
('3371', '130000', '130700', '130732', '1', '1', '镇宁堡乡', '0', '', '1', '0', '0', '10'),
('3372', '130000', '130700', '130732', '1', '1', '马营乡', '0', '', '1', '0', '0', '10'),
('3373', '130000', '130700', '130732', '1', '1', '云州乡', '0', '', '1', '0', '0', '10'),
('3374', '130000', '130700', '130732', '1', '1', '三道川乡', '0', '', '1', '0', '0', '10'),
('3375', '130000', '130700', '130732', '1', '1', '东万口乡', '0', '', '1', '0', '0', '10'),
('3376', '130000', '130700', '130732', '1', '1', '茨营子乡', '0', '', '1', '0', '0', '10'),
('3377', '130000', '130700', '130732', '1', '1', '样田乡', '0', '', '1', '0', '0', '10'),
('3378', '130000', '130700', '130733', '1', '1', '西湾子街道办', '0', '', '1', '0', '0', '10'),
('3379', '130000', '130700', '130733', '1', '1', '西湾子镇', '0', '', '1', '0', '0', '10'),
('3380', '130000', '130700', '130733', '1', '1', '高家营镇', '0', '', '1', '0', '0', '10'),
('3381', '130000', '130700', '130733', '1', '1', '四台嘴乡', '0', '', '1', '0', '0', '10'),
('3382', '130000', '130700', '130733', '1', '1', '红旗营乡', '0', '', '1', '0', '0', '10'),
('3383', '130000', '130700', '130733', '1', '1', '石窑子乡', '0', '', '1', '0', '0', '10'),
('3384', '130000', '130700', '130733', '1', '1', '驿马图乡', '0', '', '1', '0', '0', '10'),
('3385', '130000', '130700', '130733', '1', '1', '石嘴子乡', '0', '', '1', '0', '0', '10'),
('3386', '130000', '130700', '130733', '1', '1', '狮子沟乡', '0', '', '1', '0', '0', '10'),
('3387', '130000', '130700', '130733', '1', '1', '清三营乡', '0', '', '1', '0', '0', '10'),
('3388', '130000', '130700', '130733', '1', '1', '白旗乡', '0', '', '1', '0', '0', '10'),
('3389', '130000', '130800', '130802', '1', '1', '西大街街道', '0', '', '1', '0', '0', '10'),
('3390', '130000', '130800', '130802', '1', '1', '头道牌楼街道', '0', '', '1', '0', '0', '10'),
('3391', '130000', '130800', '130802', '1', '1', '潘家沟街道', '0', '', '1', '0', '0', '10'),
('3392', '130000', '130800', '130802', '1', '1', '中华路街道', '0', '', '1', '0', '0', '10'),
('3393', '130000', '130800', '130802', '1', '1', '新华路街道', '0', '', '1', '0', '0', '10'),
('3394', '130000', '130800', '130802', '1', '1', '石洞子沟街道', '0', '', '1', '0', '0', '10'),
('3395', '130000', '130800', '130802', '1', '1', '桥东街道', '0', '', '1', '0', '0', '10'),
('3396', '130000', '130800', '130802', '1', '1', '水泉沟镇', '0', '', '1', '0', '0', '10'),
('3397', '130000', '130800', '130802', '1', '1', '狮子沟镇', '0', '', '1', '0', '0', '10'),
('3398', '130000', '130800', '130802', '1', '1', '牛圈子沟镇', '0', '', '1', '0', '0', '10'),
('3399', '130000', '130800', '130802', '1', '1', '大石庙镇', '0', '', '1', '0', '0', '10'),
('3400', '130000', '130800', '130802', '1', '1', '冯营子镇', '0', '', '1', '0', '0', '10'),
('3401', '130000', '130800', '130803', '1', '1', '双塔山街道', '0', '', '1', '0', '0', '10'),
('3402', '130000', '130800', '130803', '1', '1', '滦河街道', '0', '', '1', '0', '0', '10'),
('3403', '130000', '130800', '130803', '1', '1', '双塔山镇', '0', '', '1', '0', '0', '10'),
('3404', '130000', '130800', '130803', '1', '1', '滦河镇', '0', '', '1', '0', '0', '10'),
('3405', '130000', '130800', '130803', '1', '1', '大庙镇', '0', '', '1', '0', '0', '10'),
('3406', '130000', '130800', '130803', '1', '1', '偏桥子镇', '0', '', '1', '0', '0', '10'),
('3407', '130000', '130800', '130804', '1', '1', '鹰手营子镇', '0', '', '1', '0', '0', '10'),
('3408', '130000', '130800', '130804', '1', '1', '北马圈子镇', '0', '', '1', '0', '0', '10'),
('3409', '130000', '130800', '130804', '1', '1', '寿王坟镇', '0', '', '1', '0', '0', '10'),
('3410', '130000', '130800', '130804', '1', '1', '汪家庄镇', '0', '', '1', '0', '0', '10'),
('3411', '130000', '130800', '130821', '1', '1', '下板城镇', '0', '', '1', '0', '0', '10'),
('3412', '130000', '130800', '130821', '1', '1', '上板城镇', '0', '', '1', '0', '0', '10'),
('3413', '130000', '130800', '130821', '1', '1', '甲山镇', '0', '', '1', '0', '0', '10'),
('3414', '130000', '130800', '130821', '1', '1', '六沟镇', '0', '', '1', '0', '0', '10'),
('3415', '130000', '130800', '130821', '1', '1', '三沟镇', '0', '', '1', '0', '0', '10'),
('3416', '130000', '130800', '130821', '1', '1', '头沟镇', '0', '', '1', '0', '0', '10'),
('3417', '130000', '130800', '130821', '1', '1', '高寺台镇', '0', '', '1', '0', '0', '10'),
('3418', '130000', '130800', '130821', '1', '1', '双峰寺镇', '0', '', '1', '0', '0', '10'),
('3419', '130000', '130800', '130821', '1', '1', '东小白旗乡', '0', '', '1', '0', '0', '10'),
('3420', '130000', '130800', '130821', '1', '1', '鞍匠乡', '0', '', '1', '0', '0', '10'),
('3421', '130000', '130800', '130821', '1', '1', '刘杖子乡', '0', '', '1', '0', '0', '10'),
('3422', '130000', '130800', '130821', '1', '1', '新杖子乡', '0', '', '1', '0', '0', '10'),
('3423', '130000', '130800', '130821', '1', '1', '孟家院乡', '0', '', '1', '0', '0', '10'),
('3424', '130000', '130800', '130821', '1', '1', '大营子乡', '0', '', '1', '0', '0', '10'),
('3425', '130000', '130800', '130821', '1', '1', '八家乡', '0', '', '1', '0', '0', '10'),
('3426', '130000', '130800', '130821', '1', '1', '上谷乡', '0', '', '1', '0', '0', '10'),
('3427', '130000', '130800', '130821', '1', '1', '满杖子乡', '0', '', '1', '0', '0', '10'),
('3428', '130000', '130800', '130821', '1', '1', '石灰窑乡', '0', '', '1', '0', '0', '10'),
('3429', '130000', '130800', '130821', '1', '1', '五道河乡', '0', '', '1', '0', '0', '10'),
('3430', '130000', '130800', '130821', '1', '1', '岔沟乡', '0', '', '1', '0', '0', '10'),
('3431', '130000', '130800', '130821', '1', '1', '岗子满族乡', '0', '', '1', '0', '0', '10'),
('3432', '130000', '130800', '130821', '1', '1', '磴上乡', '0', '', '1', '0', '0', '10'),
('3433', '130000', '130800', '130821', '1', '1', '两家满族乡', '0', '', '1', '0', '0', '10'),
('3434', '130000', '130800', '130821', '1', '1', '三家乡', '0', '', '1', '0', '0', '10'),
('3435', '130000', '130800', '130821', '1', '1', '仓子乡', '0', '', '1', '0', '0', '10'),
('3436', '130000', '130800', '130822', '1', '1', '兴隆镇', '0', '', '1', '0', '0', '10'),
('3437', '130000', '130800', '130822', '1', '1', '半壁山镇', '0', '', '1', '0', '0', '10'),
('3438', '130000', '130800', '130822', '1', '1', '挂兰峪镇', '0', '', '1', '0', '0', '10'),
('3439', '130000', '130800', '130822', '1', '1', '青松岭镇', '0', '', '1', '0', '0', '10'),
('3440', '130000', '130800', '130822', '1', '1', '六道河镇', '0', '', '1', '0', '0', '10'),
('3441', '130000', '130800', '130822', '1', '1', '平安堡镇', '0', '', '1', '0', '0', '10'),
('3442', '130000', '130800', '130822', '1', '1', '北营房镇', '0', '', '1', '0', '0', '10'),
('3443', '130000', '130800', '130822', '1', '1', '南天门满族乡', '0', '', '1', '0', '0', '10'),
('3444', '130000', '130800', '130822', '1', '1', '孤山子乡', '0', '', '1', '0', '0', '10'),
('3445', '130000', '130800', '130822', '1', '1', '八卦岭满族乡', '0', '', '1', '0', '0', '10'),
('3446', '130000', '130800', '130822', '1', '1', '陡子峪乡', '0', '', '1', '0', '0', '10'),
('3447', '130000', '130800', '130822', '1', '1', '上石洞乡', '0', '', '1', '0', '0', '10'),
('3448', '130000', '130800', '130822', '1', '1', '北水泉乡', '0', '', '1', '0', '0', '10'),
('3449', '130000', '130800', '130822', '1', '1', '李家营乡', '0', '', '1', '0', '0', '10'),
('3450', '130000', '130800', '130822', '1', '1', '大杖子乡', '0', '', '1', '0', '0', '10'),
('3451', '130000', '130800', '130822', '1', '1', '蘑菇峪乡', '0', '', '1', '0', '0', '10'),
('3452', '130000', '130800', '130822', '1', '1', '三道河乡', '0', '', '1', '0', '0', '10'),
('3453', '130000', '130800', '130822', '1', '1', '蓝旗营乡', '0', '', '1', '0', '0', '10'),
('3454', '130000', '130800', '130822', '1', '1', '安子岭乡', '0', '', '1', '0', '0', '10'),
('3455', '130000', '130800', '130822', '1', '1', '大水泉乡', '0', '', '1', '0', '0', '10'),
('3456', '130000', '130800', '130823', '1', '1', '平泉镇', '0', '', '1', '0', '0', '10'),
('3457', '130000', '130800', '130823', '1', '1', '黄土梁子镇', '0', '', '1', '0', '0', '10'),
('3458', '130000', '130800', '130823', '1', '1', '榆树林子镇', '0', '', '1', '0', '0', '10'),
('3459', '130000', '130800', '130823', '1', '1', '杨树岭镇', '0', '', '1', '0', '0', '10'),
('3460', '130000', '130800', '130823', '1', '1', '七沟镇', '0', '', '1', '0', '0', '10'),
('3461', '130000', '130800', '130823', '1', '1', '小寺沟镇', '0', '', '1', '0', '0', '10'),
('3462', '130000', '130800', '130823', '1', '1', '党坝镇', '0', '', '1', '0', '0', '10'),
('3463', '130000', '130800', '130823', '1', '1', '卧龙镇', '0', '', '1', '0', '0', '10'),
('3464', '130000', '130800', '130823', '1', '1', '南五十家子镇', '0', '', '1', '0', '0', '10'),
('3465', '130000', '130800', '130823', '1', '1', '王土房乡', '0', '', '1', '0', '0', '10'),
('3466', '130000', '130800', '130823', '1', '1', '柳溪满族乡', '0', '', '1', '0', '0', '10'),
('3467', '130000', '130800', '130823', '1', '1', '七家岱满族乡', '0', '', '1', '0', '0', '10'),
('3468', '130000', '130800', '130823', '1', '1', '平房满族蒙古族乡', '0', '', '1', '0', '0', '10'),
('3469', '130000', '130800', '130823', '1', '1', '蒙和乌苏蒙古族乡', '0', '', '1', '0', '0', '10'),
('3470', '130000', '130800', '130823', '1', '1', '茅兰沟满族蒙古族乡', '0', '', '1', '0', '0', '10'),
('3471', '130000', '130800', '130823', '1', '1', '台头山乡', '0', '', '1', '0', '0', '10'),
('3472', '130000', '130800', '130823', '1', '1', '松树台乡', '0', '', '1', '0', '0', '10'),
('3473', '130000', '130800', '130823', '1', '1', '道虎沟乡', '0', '', '1', '0', '0', '10'),
('3474', '130000', '130800', '130823', '1', '1', '郭杖子满族乡', '0', '', '1', '0', '0', '10'),
('3475', '130000', '130800', '130824', '1', '1', '滦平镇', '0', '', '1', '0', '0', '10'),
('3476', '130000', '130800', '130824', '1', '1', '长山峪镇', '0', '', '1', '0', '0', '10'),
('3477', '130000', '130800', '130824', '1', '1', '红旗镇', '0', '', '1', '0', '0', '10'),
('3478', '130000', '130800', '130824', '1', '1', '金沟屯镇', '0', '', '1', '0', '0', '10'),
('3479', '130000', '130800', '130824', '1', '1', '虎什哈镇', '0', '', '1', '0', '0', '10'),
('3480', '130000', '130800', '130824', '1', '1', '巴克什营镇', '0', '', '1', '0', '0', '10'),
('3481', '130000', '130800', '130824', '1', '1', '张百湾镇', '0', '', '1', '0', '0', '10'),
('3482', '130000', '130800', '130824', '1', '1', '平坊满族乡', '0', '', '1', '0', '0', '10'),
('3483', '130000', '130800', '130824', '1', '1', '安纯沟门满族乡', '0', '', '1', '0', '0', '10'),
('3484', '130000', '130800', '130824', '1', '1', '西地满族乡', '0', '', '1', '0', '0', '10'),
('3485', '130000', '130800', '130824', '1', '1', '陈栅子乡', '0', '', '1', '0', '0', '10'),
('3486', '130000', '130800', '130824', '1', '1', '付营子乡', '0', '', '1', '0', '0', '10'),
('3487', '130000', '130800', '130824', '1', '1', '小营满族乡', '0', '', '1', '0', '0', '10'),
('3488', '130000', '130800', '130824', '1', '1', '西沟满族乡', '0', '', '1', '0', '0', '10'),
('3489', '130000', '130800', '130824', '1', '1', '邓厂满族乡', '0', '', '1', '0', '0', '10'),
('3490', '130000', '130800', '130824', '1', '1', '五道营子满族乡', '0', '', '1', '0', '0', '10'),
('3491', '130000', '130800', '130824', '1', '1', '马营子满族乡', '0', '', '1', '0', '0', '10'),
('3492', '130000', '130800', '130824', '1', '1', '付家店满族乡', '0', '', '1', '0', '0', '10'),
('3493', '130000', '130800', '130824', '1', '1', '火斗山乡', '0', '', '1', '0', '0', '10'),
('3494', '130000', '130800', '130824', '1', '1', '两间房乡', '0', '', '1', '0', '0', '10'),
('3495', '130000', '130800', '130824', '1', '1', '涝洼乡', '0', '', '1', '0', '0', '10'),
('3496', '130000', '130800', '130824', '1', '1', '大屯满族乡', '0', '', '1', '0', '0', '10'),
('3497', '130000', '130800', '130825', '1', '1', '隆化镇', '0', '', '1', '0', '0', '10'),
('3498', '130000', '130800', '130825', '1', '1', '韩麻营镇', '0', '', '1', '0', '0', '10'),
('3499', '130000', '130800', '130825', '1', '1', '中关镇', '0', '', '1', '0', '0', '10'),
('3500', '130000', '130800', '130825', '1', '1', '七家镇', '0', '', '1', '0', '0', '10'),
('3501', '130000', '130800', '130825', '1', '1', '汤头沟镇', '0', '', '1', '0', '0', '10'),
('3502', '130000', '130800', '130825', '1', '1', '张三营镇', '0', '', '1', '0', '0', '10'),
('3503', '130000', '130800', '130825', '1', '1', '唐三营镇', '0', '', '1', '0', '0', '10'),
('3504', '130000', '130800', '130825', '1', '1', '蓝旗镇', '0', '', '1', '0', '0', '10'),
('3505', '130000', '130800', '130825', '1', '1', '步古沟镇', '0', '', '1', '0', '0', '10'),
('3506', '130000', '130800', '130825', '1', '1', '郭家屯镇', '0', '', '1', '0', '0', '10'),
('3507', '130000', '130800', '130825', '1', '1', '荒地乡', '0', '', '1', '0', '0', '10'),
('3508', '130000', '130800', '130825', '1', '1', '章吉营乡', '0', '', '1', '0', '0', '10'),
('3509', '130000', '130800', '130825', '1', '1', '茅荆坝乡', '0', '', '1', '0', '0', '10'),
('3510', '130000', '130800', '130825', '1', '1', '尹家营满族乡', '0', '', '1', '0', '0', '10'),
('3511', '130000', '130800', '130825', '1', '1', '庙子沟蒙古族满族乡', '0', '', '1', '0', '0', '10'),
('3512', '130000', '130800', '130825', '1', '1', '偏坡营满族乡', '0', '', '1', '0', '0', '10'),
('3513', '130000', '130800', '130825', '1', '1', '山湾乡', '0', '', '1', '0', '0', '10'),
('3514', '130000', '130800', '130825', '1', '1', '八达营蒙古族乡', '0', '', '1', '0', '0', '10'),
('3515', '130000', '130800', '130825', '1', '1', '太平庄满族乡', '0', '', '1', '0', '0', '10'),
('3516', '130000', '130800', '130825', '1', '1', '旧屯满族乡', '0', '', '1', '0', '0', '10'),
('3517', '130000', '130800', '130825', '1', '1', '西阿超满族蒙古族乡', '0', '', '1', '0', '0', '10'),
('3518', '130000', '130800', '130825', '1', '1', '白虎沟满族蒙古族乡', '0', '', '1', '0', '0', '10'),
('3519', '130000', '130800', '130825', '1', '1', '碱房乡', '0', '', '1', '0', '0', '10'),
('3520', '130000', '130800', '130825', '1', '1', '韩家店乡', '0', '', '1', '0', '0', '10'),
('3521', '130000', '130800', '130825', '1', '1', '湾沟门乡', '0', '', '1', '0', '0', '10'),
('3522', '130000', '130800', '130826', '1', '1', '大阁镇', '0', '', '1', '0', '0', '10'),
('3523', '130000', '130800', '130826', '1', '1', '大滩镇', '0', '', '1', '0', '0', '10'),
('3524', '130000', '130800', '130826', '1', '1', '鱼儿山镇', '0', '', '1', '0', '0', '10'),
('3525', '130000', '130800', '130826', '1', '1', '土城镇', '0', '', '1', '0', '0', '10'),
('3526', '130000', '130800', '130826', '1', '1', '黄旗镇', '0', '', '1', '0', '0', '10'),
('3527', '130000', '130800', '130826', '1', '1', '凤山镇', '0', '', '1', '0', '0', '10'),
('3528', '130000', '130800', '130826', '1', '1', '波罗诺镇', '0', '', '1', '0', '0', '10'),
('3529', '130000', '130800', '130826', '1', '1', '黑山咀镇', '0', '', '1', '0', '0', '10'),
('3530', '130000', '130800', '130826', '1', '1', '天桥镇', '0', '', '1', '0', '0', '10'),
('3531', '130000', '130800', '130826', '1', '1', '万胜永乡', '0', '', '1', '0', '0', '10'),
('3532', '130000', '130800', '130826', '1', '1', '四岔口乡', '0', '', '1', '0', '0', '10'),
('3533', '130000', '130800', '130826', '1', '1', '苏家店乡', '0', '', '1', '0', '0', '10'),
('3534', '130000', '130800', '130826', '1', '1', '外沟门乡', '0', '', '1', '0', '0', '10'),
('3535', '130000', '130800', '130826', '1', '1', '草原乡', '0', '', '1', '0', '0', '10'),
('3536', '130000', '130800', '130826', '1', '1', '窟窿山乡', '0', '', '1', '0', '0', '10'),
('3537', '130000', '130800', '130826', '1', '1', '小坝子乡', '0', '', '1', '0', '0', '10'),
('3538', '130000', '130800', '130826', '1', '1', '五道营乡', '0', '', '1', '0', '0', '10'),
('3539', '130000', '130800', '130826', '1', '1', '南关蒙古族乡', '0', '', '1', '0', '0', '10'),
('3540', '130000', '130800', '130826', '1', '1', '选将营乡', '0', '', '1', '0', '0', '10'),
('3541', '130000', '130800', '130826', '1', '1', '西官营乡', '0', '', '1', '0', '0', '10'),
('3542', '130000', '130800', '130826', '1', '1', '王营乡', '0', '', '1', '0', '0', '10'),
('3543', '130000', '130800', '130826', '1', '1', '北头营乡', '0', '', '1', '0', '0', '10'),
('3544', '130000', '130800', '130826', '1', '1', '胡麻营乡', '0', '', '1', '0', '0', '10'),
('3545', '130000', '130800', '130826', '1', '1', '石人沟乡', '0', '', '1', '0', '0', '10'),
('3546', '130000', '130800', '130826', '1', '1', '汤河乡', '0', '', '1', '0', '0', '10'),
('3547', '130000', '130800', '130826', '1', '1', '杨木栅子乡', '0', '', '1', '0', '0', '10'),
('3548', '130000', '130800', '130827', '1', '1', '宽城镇', '0', '', '1', '0', '0', '10'),
('3549', '130000', '130800', '130827', '1', '1', '龙须门镇', '0', '', '1', '0', '0', '10'),
('3550', '130000', '130800', '130827', '1', '1', '峪耳崖镇', '0', '', '1', '0', '0', '10'),
('3551', '130000', '130800', '130827', '1', '1', '板城镇', '0', '', '1', '0', '0', '10'),
('3552', '130000', '130800', '130827', '1', '1', '汤道河镇', '0', '', '1', '0', '0', '10'),
('3553', '130000', '130800', '130827', '1', '1', '化皮溜子乡', '0', '', '1', '0', '0', '10'),
('3554', '130000', '130800', '130827', '1', '1', '塌山乡', '0', '', '1', '0', '0', '10'),
('3555', '130000', '130800', '130827', '1', '1', '饽罗台乡', '0', '', '1', '0', '0', '10'),
('3556', '130000', '130800', '130827', '1', '1', '孟子岭乡', '0', '', '1', '0', '0', '10'),
('3557', '130000', '130800', '130827', '1', '1', '独石沟乡', '0', '', '1', '0', '0', '10'),
('3558', '130000', '130800', '130827', '1', '1', '碾子峪乡', '0', '', '1', '0', '0', '10'),
('3559', '130000', '130800', '130827', '1', '1', '东大地乡', '0', '', '1', '0', '0', '10'),
('3560', '130000', '130800', '130827', '1', '1', '铧尖乡', '0', '', '1', '0', '0', '10'),
('3561', '130000', '130800', '130827', '1', '1', '东黄花川乡', '0', '', '1', '0', '0', '10'),
('3562', '130000', '130800', '130827', '1', '1', '亮甲台乡', '0', '', '1', '0', '0', '10'),
('3563', '130000', '130800', '130827', '1', '1', '苇子沟乡', '0', '', '1', '0', '0', '10'),
('3564', '130000', '130800', '130827', '1', '1', '大字沟门乡', '0', '', '1', '0', '0', '10'),
('3565', '130000', '130800', '130827', '1', '1', '大石柱子乡', '0', '', '1', '0', '0', '10'),
('3566', '130000', '130800', '130828', '1', '1', '围场镇', '0', '', '1', '0', '0', '10'),
('3567', '130000', '130800', '130828', '1', '1', '四合永镇', '0', '', '1', '0', '0', '10'),
('3568', '130000', '130800', '130828', '1', '1', '克勒沟镇', '0', '', '1', '0', '0', '10'),
('3569', '130000', '130800', '130828', '1', '1', '棋盘山镇', '0', '', '1', '0', '0', '10'),
('3570', '130000', '130800', '130828', '1', '1', '半截塔镇', '0', '', '1', '0', '0', '10'),
('3571', '130000', '130800', '130828', '1', '1', '朝阳地镇', '0', '', '1', '0', '0', '10'),
('3572', '130000', '130800', '130828', '1', '1', '朝阳湾镇', '0', '', '1', '0', '0', '10');
INSERT INTO `wst_communitys` VALUES ('3573', '130000', '130800', '130828', '1', '1', '道坝子乡', '0', '', '1', '0', '0', '10'),
('3574', '130000', '130800', '130828', '1', '1', '龙头山乡', '0', '', '1', '0', '0', '10'),
('3575', '130000', '130800', '130828', '1', '1', '腰站乡', '0', '', '1', '0', '0', '10'),
('3576', '130000', '130800', '130828', '1', '1', '黄土坎乡', '0', '', '1', '0', '0', '10'),
('3577', '130000', '130800', '130828', '1', '1', '四道沟乡', '0', '', '1', '0', '0', '10'),
('3578', '130000', '130800', '130828', '1', '1', '兰旗卡伦乡', '0', '', '1', '0', '0', '10'),
('3579', '130000', '130800', '130828', '1', '1', '银窝沟乡', '0', '', '1', '0', '0', '10'),
('3580', '130000', '130800', '130828', '1', '1', '新地乡', '0', '', '1', '0', '0', '10'),
('3581', '130000', '130800', '130828', '1', '1', '广发永乡', '0', '', '1', '0', '0', '10'),
('3582', '130000', '130800', '130828', '1', '1', '育太和乡', '0', '', '1', '0', '0', '10'),
('3583', '130000', '130800', '130828', '1', '1', '郭家湾乡', '0', '', '1', '0', '0', '10'),
('3584', '130000', '130800', '130828', '1', '1', '杨家湾乡', '0', '', '1', '0', '0', '10'),
('3585', '130000', '130800', '130828', '1', '1', '大唤起乡', '0', '', '1', '0', '0', '10'),
('3586', '130000', '130800', '130828', '1', '1', '哈里哈乡', '0', '', '1', '0', '0', '10'),
('3587', '130000', '130800', '130828', '1', '1', '新拨乡', '0', '', '1', '0', '0', '10'),
('3588', '130000', '130800', '130828', '1', '1', '张家湾乡', '0', '', '1', '0', '0', '10'),
('3589', '130000', '130800', '130828', '1', '1', '宝元栈乡', '0', '', '1', '0', '0', '10'),
('3590', '130000', '130800', '130828', '1', '1', '山湾子乡', '0', '', '1', '0', '0', '10'),
('3591', '130000', '130800', '130828', '1', '1', '三义永乡', '0', '', '1', '0', '0', '10'),
('3592', '130000', '130800', '130828', '1', '1', '姜家店乡', '0', '', '1', '0', '0', '10'),
('3593', '130000', '130800', '130828', '1', '1', '下伙房乡', '0', '', '1', '0', '0', '10'),
('3594', '130000', '130800', '130828', '1', '1', '燕格柏乡', '0', '', '1', '0', '0', '10'),
('3595', '130000', '130800', '130828', '1', '1', '牌楼乡', '0', '', '1', '0', '0', '10'),
('3596', '130000', '130800', '130828', '1', '1', '城子乡', '0', '', '1', '0', '0', '10'),
('3597', '130000', '130800', '130828', '1', '1', '老窝铺乡', '0', '', '1', '0', '0', '10'),
('3598', '130000', '130800', '130828', '1', '1', '御道口乡', '0', '', '1', '0', '0', '10'),
('3599', '130000', '130800', '130828', '1', '1', '石桌子乡', '0', '', '1', '0', '0', '10'),
('3600', '130000', '130800', '130828', '1', '1', '大头山乡', '0', '', '1', '0', '0', '10'),
('3601', '130000', '130800', '130828', '1', '1', '南山嘴乡', '0', '', '1', '0', '0', '10'),
('3602', '130000', '130800', '130828', '1', '1', '西龙头乡', '0', '', '1', '0', '0', '10'),
('3603', '130000', '130800', '130828', '1', '1', '塞罕坝机械林场虚拟镇', '0', '', '1', '0', '0', '10'),
('3604', '130000', '130800', '130828', '1', '1', '国营御道口牧场虚拟乡', '0', '', '1', '0', '0', '10'),
('3605', '130000', '130900', '130902', '1', '1', '建设北街街道', '0', '', '1', '0', '0', '10'),
('3606', '130000', '130900', '130902', '1', '1', '车站街道', '0', '', '1', '0', '0', '10'),
('3607', '130000', '130900', '130902', '1', '1', '南大街街道', '0', '', '1', '0', '0', '10'),
('3608', '130000', '130900', '130902', '1', '1', '东环街道', '0', '', '1', '0', '0', '10'),
('3609', '130000', '130900', '130902', '1', '1', '道东街道', '0', '', '1', '0', '0', '10'),
('3610', '130000', '130900', '130902', '1', '1', '小赵庄乡', '0', '', '1', '0', '0', '10'),
('3611', '130000', '130900', '130902', '1', '1', '沧州开发区', '0', '', '1', '0', '0', '10'),
('3612', '130000', '130900', '130903', '1', '1', '水月寺街道', '0', '', '1', '0', '0', '10'),
('3613', '130000', '130900', '130903', '1', '1', '南环中路街道', '0', '', '1', '0', '0', '10'),
('3614', '130000', '130900', '130903', '1', '1', '南湖街道', '0', '', '1', '0', '0', '10'),
('3615', '130000', '130900', '130903', '1', '1', '市场街道', '0', '', '1', '0', '0', '10'),
('3616', '130000', '130900', '130903', '1', '1', '西环中街街道', '0', '', '1', '0', '0', '10'),
('3617', '130000', '130900', '130903', '1', '1', '公园街道', '0', '', '1', '0', '0', '10'),
('3618', '130000', '130900', '130903', '1', '1', '小王庄镇', '0', '', '1', '0', '0', '10'),
('3619', '130000', '130900', '130903', '1', '1', '南陈屯乡', '0', '', '1', '0', '0', '10'),
('3620', '130000', '130900', '130921', '1', '1', '旧州镇', '0', '', '1', '0', '0', '10'),
('3621', '130000', '130900', '130921', '1', '1', '兴济镇', '0', '', '1', '0', '0', '10'),
('3622', '130000', '130900', '130921', '1', '1', '杜生镇', '0', '', '1', '0', '0', '10'),
('3623', '130000', '130900', '130921', '1', '1', '崔尔庄镇', '0', '', '1', '0', '0', '10'),
('3624', '130000', '130900', '130921', '1', '1', '薛官屯乡', '0', '', '1', '0', '0', '10'),
('3625', '130000', '130900', '130921', '1', '1', '捷地回族乡', '0', '', '1', '0', '0', '10'),
('3626', '130000', '130900', '130921', '1', '1', '张官屯乡', '0', '', '1', '0', '0', '10'),
('3627', '130000', '130900', '130921', '1', '1', '李天木回族乡', '0', '', '1', '0', '0', '10'),
('3628', '130000', '130900', '130921', '1', '1', '风化店乡', '0', '', '1', '0', '0', '10'),
('3629', '130000', '130900', '130921', '1', '1', '姚官屯乡', '0', '', '1', '0', '0', '10'),
('3630', '130000', '130900', '130921', '1', '1', '杜林回族乡', '0', '', '1', '0', '0', '10'),
('3631', '130000', '130900', '130921', '1', '1', '汪家铺乡', '0', '', '1', '0', '0', '10'),
('3632', '130000', '130900', '130921', '1', '1', '刘家庙乡', '0', '', '1', '0', '0', '10'),
('3633', '130000', '130900', '130921', '1', '1', '仵龙堂乡', '0', '', '1', '0', '0', '10'),
('3634', '130000', '130900', '130921', '1', '1', '大官厅乡', '0', '', '1', '0', '0', '10'),
('3635', '130000', '130900', '130921', '1', '1', '高川乡', '0', '', '1', '0', '0', '10'),
('3636', '130000', '130900', '130921', '1', '1', '黄递铺乡', '0', '', '1', '0', '0', '10'),
('3637', '130000', '130900', '130921', '1', '1', '大褚村回族乡', '0', '', '1', '0', '0', '10'),
('3638', '130000', '130900', '130921', '1', '1', '纸房头乡', '0', '', '1', '0', '0', '10'),
('3639', '130000', '130900', '130922', '1', '1', '清州镇', '0', '', '1', '0', '0', '10'),
('3640', '130000', '130900', '130922', '1', '1', '金牛镇', '0', '', '1', '0', '0', '10'),
('3641', '130000', '130900', '130922', '1', '1', '新兴镇', '0', '', '1', '0', '0', '10'),
('3642', '130000', '130900', '130922', '1', '1', '流河镇', '0', '', '1', '0', '0', '10'),
('3643', '130000', '130900', '130922', '1', '1', '木门店镇', '0', '', '1', '0', '0', '10'),
('3644', '130000', '130900', '130922', '1', '1', '马厂镇', '0', '', '1', '0', '0', '10'),
('3645', '130000', '130900', '130922', '1', '1', '上伍乡', '0', '', '1', '0', '0', '10'),
('3646', '130000', '130900', '130922', '1', '1', '曹寺乡', '0', '', '1', '0', '0', '10'),
('3647', '130000', '130900', '130922', '1', '1', '盘古乡', '0', '', '1', '0', '0', '10'),
('3648', '130000', '130900', '130922', '1', '1', '陈嘴乡', '0', '', '1', '0', '0', '10'),
('3649', '130000', '130900', '130922', '1', '1', '农场虚拟乡', '0', '', '1', '0', '0', '10'),
('3650', '130000', '130900', '130923', '1', '1', '东光镇', '0', '', '1', '0', '0', '10'),
('3651', '130000', '130900', '130923', '1', '1', '连镇镇', '0', '', '1', '0', '0', '10'),
('3652', '130000', '130900', '130923', '1', '1', '找王镇', '0', '', '1', '0', '0', '10'),
('3653', '130000', '130900', '130923', '1', '1', '秦村镇', '0', '', '1', '0', '0', '10'),
('3654', '130000', '130900', '130923', '1', '1', '灯明寺镇', '0', '', '1', '0', '0', '10'),
('3655', '130000', '130900', '130923', '1', '1', '南霞口镇', '0', '', '1', '0', '0', '10'),
('3656', '130000', '130900', '130923', '1', '1', '大单镇', '0', '', '1', '0', '0', '10'),
('3657', '130000', '130900', '130923', '1', '1', '龙王李乡', '0', '', '1', '0', '0', '10'),
('3658', '130000', '130900', '130923', '1', '1', '于桥乡', '0', '', '1', '0', '0', '10'),
('3659', '130000', '130900', '130924', '1', '1', '苏基镇', '0', '', '1', '0', '0', '10'),
('3660', '130000', '130900', '130924', '1', '1', '辛集镇', '0', '', '1', '0', '0', '10'),
('3661', '130000', '130900', '130924', '1', '1', '高湾镇', '0', '', '1', '0', '0', '10'),
('3662', '130000', '130900', '130924', '1', '1', '赵毛陶乡', '0', '', '1', '0', '0', '10'),
('3663', '130000', '130900', '130924', '1', '1', '香坊乡', '0', '', '1', '0', '0', '10'),
('3664', '130000', '130900', '130924', '1', '1', '小山乡', '0', '', '1', '0', '0', '10'),
('3665', '130000', '130900', '130924', '1', '1', '张会亭乡', '0', '', '1', '0', '0', '10'),
('3666', '130000', '130900', '130924', '1', '1', '海兴县农场', '0', '', '1', '0', '0', '10'),
('3667', '130000', '130900', '130924', '1', '1', '青先农场', '0', '', '1', '0', '0', '10'),
('3668', '130000', '130900', '130924', '1', '1', '青锋农场', '0', '', '1', '0', '0', '10'),
('3669', '130000', '130900', '130925', '1', '1', '盐山镇', '0', '', '1', '0', '0', '10'),
('3670', '130000', '130900', '130925', '1', '1', '望树镇', '0', '', '1', '0', '0', '10'),
('3671', '130000', '130900', '130925', '1', '1', '庆云镇', '0', '', '1', '0', '0', '10'),
('3672', '130000', '130900', '130925', '1', '1', '韩集镇', '0', '', '1', '0', '0', '10'),
('3673', '130000', '130900', '130925', '1', '1', '千童镇', '0', '', '1', '0', '0', '10'),
('3674', '130000', '130900', '130925', '1', '1', '圣佛镇', '0', '', '1', '0', '0', '10'),
('3675', '130000', '130900', '130925', '1', '1', '边务乡', '0', '', '1', '0', '0', '10'),
('3676', '130000', '130900', '130925', '1', '1', '小营乡', '0', '', '1', '0', '0', '10'),
('3677', '130000', '130900', '130925', '1', '1', '杨集乡', '0', '', '1', '0', '0', '10'),
('3678', '130000', '130900', '130925', '1', '1', '孟店乡', '0', '', '1', '0', '0', '10'),
('3679', '130000', '130900', '130925', '1', '1', '常庄乡', '0', '', '1', '0', '0', '10'),
('3680', '130000', '130900', '130925', '1', '1', '小庄乡', '0', '', '1', '0', '0', '10'),
('3681', '130000', '130900', '130926', '1', '1', '肃宁镇', '0', '', '1', '0', '0', '10'),
('3682', '130000', '130900', '130926', '1', '1', '梁家村镇', '0', '', '1', '0', '0', '10'),
('3683', '130000', '130900', '130926', '1', '1', '窝北镇', '0', '', '1', '0', '0', '10'),
('3684', '130000', '130900', '130926', '1', '1', '尚村镇', '0', '', '1', '0', '0', '10'),
('3685', '130000', '130900', '130926', '1', '1', '万里镇', '0', '', '1', '0', '0', '10'),
('3686', '130000', '130900', '130926', '1', '1', '师素乡', '0', '', '1', '0', '0', '10'),
('3687', '130000', '130900', '130926', '1', '1', '河北留善寺乡', '0', '', '1', '0', '0', '10'),
('3688', '130000', '130900', '130926', '1', '1', '付家佐乡', '0', '', '1', '0', '0', '10'),
('3689', '130000', '130900', '130926', '1', '1', '邵庄乡', '0', '', '1', '0', '0', '10'),
('3690', '130000', '130900', '130927', '1', '1', '南皮镇', '0', '', '1', '0', '0', '10'),
('3691', '130000', '130900', '130927', '1', '1', '冯家口镇', '0', '', '1', '0', '0', '10'),
('3692', '130000', '130900', '130927', '1', '1', '寨子镇', '0', '', '1', '0', '0', '10'),
('3693', '130000', '130900', '130927', '1', '1', '鲍官屯镇', '0', '', '1', '0', '0', '10'),
('3694', '130000', '130900', '130927', '1', '1', '王寺镇', '0', '', '1', '0', '0', '10'),
('3695', '130000', '130900', '130927', '1', '1', '乌马营镇', '0', '', '1', '0', '0', '10'),
('3696', '130000', '130900', '130927', '1', '1', '大浪淀乡', '0', '', '1', '0', '0', '10'),
('3697', '130000', '130900', '130927', '1', '1', '刘八里乡', '0', '', '1', '0', '0', '10'),
('3698', '130000', '130900', '130927', '1', '1', '潞灌乡', '0', '', '1', '0', '0', '10'),
('3699', '130000', '130900', '130928', '1', '1', '桑园镇', '0', '', '1', '0', '0', '10'),
('3700', '130000', '130900', '130928', '1', '1', '铁城镇', '0', '', '1', '0', '0', '10'),
('3701', '130000', '130900', '130928', '1', '1', '于集镇', '0', '', '1', '0', '0', '10'),
('3702', '130000', '130900', '130928', '1', '1', '梁集镇', '0', '', '1', '0', '0', '10'),
('3703', '130000', '130900', '130928', '1', '1', '安陵镇', '0', '', '1', '0', '0', '10'),
('3704', '130000', '130900', '130928', '1', '1', '曹家洼乡', '0', '', '1', '0', '0', '10'),
('3705', '130000', '130900', '130928', '1', '1', '宋门乡', '0', '', '1', '0', '0', '10'),
('3706', '130000', '130900', '130928', '1', '1', '杨家寺乡', '0', '', '1', '0', '0', '10'),
('3707', '130000', '130900', '130928', '1', '1', '沟店铺乡', '0', '', '1', '0', '0', '10'),
('3708', '130000', '130900', '130928', '1', '1', '何庄乡', '0', '', '1', '0', '0', '10'),
('3709', '130000', '130900', '130929', '1', '1', '乐寿镇', '0', '', '1', '0', '0', '10'),
('3710', '130000', '130900', '130929', '1', '1', '淮镇镇', '0', '', '1', '0', '0', '10'),
('3711', '130000', '130900', '130929', '1', '1', '郭庄镇', '0', '', '1', '0', '0', '10'),
('3712', '130000', '130900', '130929', '1', '1', '河城街镇', '0', '', '1', '0', '0', '10'),
('3713', '130000', '130900', '130929', '1', '1', '韩村乡', '0', '', '1', '0', '0', '10'),
('3714', '130000', '130900', '130929', '1', '1', '陌南乡', '0', '', '1', '0', '0', '10'),
('3715', '130000', '130900', '130929', '1', '1', '陈庄乡', '0', '', '1', '0', '0', '10'),
('3716', '130000', '130900', '130929', '1', '1', '徐留高乡', '0', '', '1', '0', '0', '10'),
('3717', '130000', '130900', '130929', '1', '1', '商林乡', '0', '', '1', '0', '0', '10'),
('3718', '130000', '130900', '130929', '1', '1', '段村乡', '0', '', '1', '0', '0', '10'),
('3719', '130000', '130900', '130929', '1', '1', '张村乡', '0', '', '1', '0', '0', '10'),
('3720', '130000', '130900', '130929', '1', '1', '临河乡', '0', '', '1', '0', '0', '10'),
('3721', '130000', '130900', '130929', '1', '1', '小平王乡', '0', '', '1', '0', '0', '10'),
('3722', '130000', '130900', '130929', '1', '1', '十五级乡', '0', '', '1', '0', '0', '10'),
('3723', '130000', '130900', '130929', '1', '1', '垒头乡', '0', '', '1', '0', '0', '10'),
('3724', '130000', '130900', '130929', '1', '1', '南河头乡', '0', '', '1', '0', '0', '10'),
('3725', '130000', '130900', '130929', '1', '1', '西城乡', '0', '', '1', '0', '0', '10'),
('3726', '130000', '130900', '130929', '1', '1', '本斋回族乡', '0', '', '1', '0', '0', '10'),
('3727', '130000', '130900', '130929', '1', '1', '农场', '0', '', '1', '0', '0', '10'),
('3728', '130000', '130900', '130930', '1', '1', '孟村镇', '0', '', '1', '0', '0', '10'),
('3729', '130000', '130900', '130930', '1', '1', '新县镇', '0', '', '1', '0', '0', '10'),
('3730', '130000', '130900', '130930', '1', '1', '辛店镇', '0', '', '1', '0', '0', '10'),
('3731', '130000', '130900', '130930', '1', '1', '高寨镇', '0', '', '1', '0', '0', '10'),
('3732', '130000', '130900', '130930', '1', '1', '宋庄子乡', '0', '', '1', '0', '0', '10'),
('3733', '130000', '130900', '130930', '1', '1', '牛进庄乡', '0', '', '1', '0', '0', '10'),
('3734', '130000', '130900', '130981', '1', '1', '解放街道', '0', '', '1', '0', '0', '10'),
('3735', '130000', '130900', '130981', '1', '1', '河东街道', '0', '', '1', '0', '0', '10'),
('3736', '130000', '130900', '130981', '1', '1', '古楼街道', '0', '', '1', '0', '0', '10'),
('3737', '130000', '130900', '130981', '1', '1', '泊镇', '0', '', '1', '0', '0', '10'),
('3738', '130000', '130900', '130981', '1', '1', '交河镇', '0', '', '1', '0', '0', '10'),
('3739', '130000', '130900', '130981', '1', '1', '齐桥镇', '0', '', '1', '0', '0', '10'),
('3740', '130000', '130900', '130981', '1', '1', '寺门村镇', '0', '', '1', '0', '0', '10'),
('3741', '130000', '130900', '130981', '1', '1', '郝村镇', '0', '', '1', '0', '0', '10'),
('3742', '130000', '130900', '130981', '1', '1', '富镇镇', '0', '', '1', '0', '0', '10'),
('3743', '130000', '130900', '130981', '1', '1', '文庙镇', '0', '', '1', '0', '0', '10'),
('3744', '130000', '130900', '130981', '1', '1', '洼里王镇', '0', '', '1', '0', '0', '10'),
('3745', '130000', '130900', '130981', '1', '1', '王武庄乡', '0', '', '1', '0', '0', '10'),
('3746', '130000', '130900', '130981', '1', '1', '营子乡', '0', '', '1', '0', '0', '10'),
('3747', '130000', '130900', '130981', '1', '1', '四营乡', '0', '', '1', '0', '0', '10'),
('3748', '130000', '130900', '130981', '1', '1', '西辛店乡', '0', '', '1', '0', '0', '10'),
('3749', '130000', '130900', '130982', '1', '1', '新华路街道', '0', '', '1', '0', '0', '10'),
('3750', '130000', '130900', '130982', '1', '1', '西环路街道', '0', '', '1', '0', '0', '10'),
('3751', '130000', '130900', '130982', '1', '1', '永丰路街道', '0', '', '1', '0', '0', '10'),
('3752', '130000', '130900', '130982', '1', '1', '出岸镇', '0', '', '1', '0', '0', '10'),
('3753', '130000', '130900', '130982', '1', '1', '石门桥镇', '0', '', '1', '0', '0', '10'),
('3754', '130000', '130900', '130982', '1', '1', '吕公堡镇', '0', '', '1', '0', '0', '10'),
('3755', '130000', '130900', '130982', '1', '1', '长丰镇', '0', '', '1', '0', '0', '10'),
('3756', '130000', '130900', '130982', '1', '1', '莫州镇', '0', '', '1', '0', '0', '10'),
('3757', '130000', '130900', '130982', '1', '1', '苟各庄镇', '0', '', '1', '0', '0', '10'),
('3758', '130000', '130900', '130982', '1', '1', '梁召镇', '0', '', '1', '0', '0', '10'),
('3759', '130000', '130900', '130982', '1', '1', '辛中驿镇', '0', '', '1', '0', '0', '10'),
('3760', '130000', '130900', '130982', '1', '1', '麻家坞乡', '0', '', '1', '0', '0', '10'),
('3761', '130000', '130900', '130982', '1', '1', '议论堡乡', '0', '', '1', '0', '0', '10'),
('3762', '130000', '130900', '130982', '1', '1', '青塔乡', '0', '', '1', '0', '0', '10'),
('3763', '130000', '130900', '130982', '1', '1', '北辛庄乡', '0', '', '1', '0', '0', '10'),
('3764', '130000', '130900', '130982', '1', '1', '七间房乡', '0', '', '1', '0', '0', '10'),
('3765', '130000', '130900', '130982', '1', '1', '北汉乡', '0', '', '1', '0', '0', '10'),
('3766', '130000', '130900', '130982', '1', '1', '于村乡', '0', '', '1', '0', '0', '10'),
('3767', '130000', '130900', '130982', '1', '1', '华北石油管理局虚拟街道', '0', '', '1', '0', '0', '10'),
('3768', '130000', '130900', '130982', '1', '1', '开发区管理委员会', '0', '', '1', '0', '0', '10'),
('3769', '130000', '130900', '130983', '1', '1', '骅东街道', '0', '', '1', '0', '0', '10'),
('3770', '130000', '130900', '130983', '1', '1', '骅中街道', '0', '', '1', '0', '0', '10'),
('3771', '130000', '130900', '130983', '1', '1', '骅西街道', '0', '', '1', '0', '0', '10'),
('3772', '130000', '130900', '130983', '1', '1', '黄骅镇', '0', '', '1', '0', '0', '10'),
('3773', '130000', '130900', '130983', '1', '1', '南排河镇', '0', '', '1', '0', '0', '10'),
('3774', '130000', '130900', '130983', '1', '1', '吕桥镇', '0', '', '1', '0', '0', '10'),
('3775', '130000', '130900', '130983', '1', '1', '旧城镇', '0', '', '1', '0', '0', '10'),
('3776', '130000', '130900', '130983', '1', '1', '羊二庄回族乡', '0', '', '1', '0', '0', '10'),
('3777', '130000', '130900', '130983', '1', '1', '常郭乡', '0', '', '1', '0', '0', '10'),
('3778', '130000', '130900', '130983', '1', '1', '滕庄子乡', '0', '', '1', '0', '0', '10'),
('3779', '130000', '130900', '130983', '1', '1', '官庄乡', '0', '', '1', '0', '0', '10'),
('3780', '130000', '130900', '130983', '1', '1', '齐家务乡', '0', '', '1', '0', '0', '10'),
('3781', '130000', '130900', '130983', '1', '1', '港城开发区新村乡', '0', '', '1', '0', '0', '10'),
('3782', '130000', '130900', '130983', '1', '1', '羊三木乡', '0', '', '1', '0', '0', '10'),
('3783', '130000', '130900', '130983', '1', '1', '南大港管理区虚拟乡', '0', '', '1', '0', '0', '10'),
('3784', '130000', '130900', '130983', '1', '1', '国营中捷农场虚拟乡', '0', '', '1', '0', '0', '10'),
('3785', '130000', '130900', '130983', '1', '1', '黄骅港开发区虚拟乡', '0', '', '1', '0', '0', '10'),
('3786', '130000', '130900', '130983', '1', '1', '临港化工园区', '0', '', '1', '0', '0', '10'),
('3787', '130000', '130900', '130984', '1', '1', '瀛州镇', '0', '', '1', '0', '0', '10'),
('3788', '130000', '130900', '130984', '1', '1', '米各庄镇', '0', '', '1', '0', '0', '10'),
('3789', '130000', '130900', '130984', '1', '1', '景和镇', '0', '', '1', '0', '0', '10'),
('3790', '130000', '130900', '130984', '1', '1', '卧佛堂镇', '0', '', '1', '0', '0', '10'),
('3791', '130000', '130900', '130984', '1', '1', '束城镇', '0', '', '1', '0', '0', '10'),
('3792', '130000', '130900', '130984', '1', '1', '留古寺镇', '0', '', '1', '0', '0', '10'),
('3793', '130000', '130900', '130984', '1', '1', '沙河桥镇', '0', '', '1', '0', '0', '10'),
('3794', '130000', '130900', '130984', '1', '1', '故仙乡', '0', '', '1', '0', '0', '10'),
('3795', '130000', '130900', '130984', '1', '1', '黎民居乡', '0', '', '1', '0', '0', '10'),
('3796', '130000', '130900', '130984', '1', '1', '兴村乡', '0', '', '1', '0', '0', '10'),
('3797', '130000', '130900', '130984', '1', '1', '沙洼乡', '0', '', '1', '0', '0', '10'),
('3798', '130000', '130900', '130984', '1', '1', '西九吉乡', '0', '', '1', '0', '0', '10'),
('3799', '130000', '130900', '130984', '1', '1', '北石槽乡', '0', '', '1', '0', '0', '10'),
('3800', '130000', '130900', '130984', '1', '1', '诗经村乡', '0', '', '1', '0', '0', '10'),
('3801', '130000', '130900', '130984', '1', '1', '郭家村乡', '0', '', '1', '0', '0', '10'),
('3802', '130000', '130900', '130984', '1', '1', '时村乡', '0', '', '1', '0', '0', '10'),
('3803', '130000', '130900', '130984', '1', '1', '行别营乡', '0', '', '1', '0', '0', '10'),
('3804', '130000', '130900', '130984', '1', '1', '尊祖庄乡', '0', '', '1', '0', '0', '10'),
('3805', '130000', '130900', '130984', '1', '1', '龙华店乡', '0', '', '1', '0', '0', '10'),
('3806', '130000', '130900', '130984', '1', '1', '果子洼乡', '0', '', '1', '0', '0', '10'),
('3807', '130000', '131000', '131002', '1', '1', '银河南路街道', '0', '', '1', '0', '0', '10'),
('3808', '130000', '131000', '131002', '1', '1', '光明西道街道', '0', '', '1', '0', '0', '10'),
('3809', '130000', '131000', '131002', '1', '1', '落垡镇', '0', '', '1', '0', '0', '10'),
('3810', '130000', '131000', '131002', '1', '1', '码头镇', '0', '', '1', '0', '0', '10'),
('3811', '130000', '131000', '131002', '1', '1', '葛渔城镇', '0', '', '1', '0', '0', '10'),
('3812', '130000', '131000', '131002', '1', '1', '东沽港镇', '0', '', '1', '0', '0', '10'),
('3813', '130000', '131000', '131002', '1', '1', '杨税务乡', '0', '', '1', '0', '0', '10'),
('3814', '130000', '131000', '131002', '1', '1', '仇庄乡', '0', '', '1', '0', '0', '10'),
('3815', '130000', '131000', '131002', '1', '1', '调河头乡', '0', '', '1', '0', '0', '10'),
('3816', '130000', '131000', '131002', '1', '1', '北史家务乡', '0', '', '1', '0', '0', '10'),
('3817', '130000', '131000', '131003', '1', '1', '银河北路街道', '0', '', '1', '0', '0', '10'),
('3818', '130000', '131000', '131003', '1', '1', '爱民东道街道', '0', '', '1', '0', '0', '10'),
('3819', '130000', '131000', '131003', '1', '1', '解放道街道', '0', '', '1', '0', '0', '10'),
('3820', '130000', '131000', '131003', '1', '1', '新开路街道', '0', '', '1', '0', '0', '10'),
('3821', '130000', '131000', '131003', '1', '1', '南尖塔镇', '0', '', '1', '0', '0', '10'),
('3822', '130000', '131000', '131003', '1', '1', '万庄镇', '0', '', '1', '0', '0', '10'),
('3823', '130000', '131000', '131003', '1', '1', '九州镇', '0', '', '1', '0', '0', '10'),
('3824', '130000', '131000', '131003', '1', '1', '北旺乡', '0', '', '1', '0', '0', '10'),
('3825', '130000', '131000', '131003', '1', '1', '廊坊经济技术开发区', '0', '', '1', '0', '0', '10'),
('3826', '130000', '131000', '131003', '1', '1', '新世纪步行街管理委员会', '0', '', '1', '0', '0', '10'),
('3827', '130000', '131000', '131022', '1', '1', '固安镇', '0', '', '1', '0', '0', '10'),
('3828', '130000', '131000', '131022', '1', '1', '宫村镇', '0', '', '1', '0', '0', '10'),
('3829', '130000', '131000', '131022', '1', '1', '柳泉镇', '0', '', '1', '0', '0', '10'),
('3830', '130000', '131000', '131022', '1', '1', '牛驼镇', '0', '', '1', '0', '0', '10'),
('3831', '130000', '131000', '131022', '1', '1', '马庄镇', '0', '', '1', '0', '0', '10'),
('3832', '130000', '131000', '131022', '1', '1', '东湾乡', '0', '', '1', '0', '0', '10'),
('3833', '130000', '131000', '131022', '1', '1', '彭村乡', '0', '', '1', '0', '0', '10'),
('3834', '130000', '131000', '131022', '1', '1', '渠沟乡', '0', '', '1', '0', '0', '10'),
('3835', '130000', '131000', '131022', '1', '1', '礼让店乡', '0', '', '1', '0', '0', '10'),
('3836', '130000', '131000', '131023', '1', '1', '街道', '0', '', '1', '0', '0', '10'),
('3837', '130000', '131000', '131023', '1', '1', '永清镇', '0', '', '1', '0', '0', '10'),
('3838', '130000', '131000', '131023', '1', '1', '韩村镇', '0', '', '1', '0', '0', '10'),
('3839', '130000', '131000', '131023', '1', '1', '后奕镇', '0', '', '1', '0', '0', '10'),
('3840', '130000', '131000', '131023', '1', '1', '别古庄镇', '0', '', '1', '0', '0', '10'),
('3841', '130000', '131000', '131023', '1', '1', '里澜城镇', '0', '', '1', '0', '0', '10'),
('3842', '130000', '131000', '131023', '1', '1', '管家务回族乡', '0', '', '1', '0', '0', '10'),
('3843', '130000', '131000', '131023', '1', '1', '曹家务乡', '0', '', '1', '0', '0', '10'),
('3844', '130000', '131000', '131023', '1', '1', '龙虎庄乡', '0', '', '1', '0', '0', '10'),
('3845', '130000', '131000', '131023', '1', '1', '刘街乡', '0', '', '1', '0', '0', '10'),
('3846', '130000', '131000', '131023', '1', '1', '三圣口乡', '0', '', '1', '0', '0', '10'),
('3847', '130000', '131000', '131024', '1', '1', '淑阳镇', '0', '', '1', '0', '0', '10'),
('3848', '130000', '131000', '131024', '1', '1', '蒋辛屯镇', '0', '', '1', '0', '0', '10'),
('3849', '130000', '131000', '131024', '1', '1', '渠口镇', '0', '', '1', '0', '0', '10'),
('3850', '130000', '131000', '131024', '1', '1', '安头屯镇', '0', '', '1', '0', '0', '10'),
('3851', '130000', '131000', '131024', '1', '1', '安平镇', '0', '', '1', '0', '0', '10'),
('3852', '130000', '131000', '131024', '1', '1', '刘宋镇', '0', '', '1', '0', '0', '10'),
('3853', '130000', '131000', '131024', '1', '1', '五百户镇', '0', '', '1', '0', '0', '10'),
('3854', '130000', '131000', '131024', '1', '1', '钱旺乡', '0', '', '1', '0', '0', '10'),
('3855', '130000', '131000', '131024', '1', '1', '钳屯乡', '0', '', '1', '0', '0', '10'),
('3856', '130000', '131000', '131024', '1', '1', '香河开发区', '0', '', '1', '0', '0', '10'),
('3857', '130000', '131000', '131025', '1', '1', '平舒镇', '0', '', '1', '0', '0', '10'),
('3858', '130000', '131000', '131025', '1', '1', '旺村镇', '0', '', '1', '0', '0', '10'),
('3859', '130000', '131000', '131025', '1', '1', '大尚屯镇', '0', '', '1', '0', '0', '10'),
('3860', '130000', '131000', '131025', '1', '1', '南赵扶镇', '0', '', '1', '0', '0', '10'),
('3861', '130000', '131000', '131025', '1', '1', '留各庄镇', '0', '', '1', '0', '0', '10'),
('3862', '130000', '131000', '131025', '1', '1', '权村镇', '0', '', '1', '0', '0', '10'),
('3863', '130000', '131000', '131025', '1', '1', '里坦镇', '0', '', '1', '0', '0', '10'),
('3864', '130000', '131000', '131025', '1', '1', '北位乡', '0', '', '1', '0', '0', '10'),
('3865', '130000', '131000', '131025', '1', '1', '大广安乡', '0', '', '1', '0', '0', '10'),
('3866', '130000', '131000', '131025', '1', '1', '臧屯乡', '0', '', '1', '0', '0', '10'),
('3867', '130000', '131000', '131025', '1', '1', '摩配园区管委会', '0', '', '1', '0', '0', '10'),
('3868', '130000', '131000', '131026', '1', '1', '文安镇', '0', '', '1', '0', '0', '10'),
('3869', '130000', '131000', '131026', '1', '1', '新镇镇', '0', '', '1', '0', '0', '10'),
('3870', '130000', '131000', '131026', '1', '1', '苏桥镇', '0', '', '1', '0', '0', '10'),
('3871', '130000', '131000', '131026', '1', '1', '大柳河镇', '0', '', '1', '0', '0', '10'),
('3872', '130000', '131000', '131026', '1', '1', '左各庄镇', '0', '', '1', '0', '0', '10'),
('3873', '130000', '131000', '131026', '1', '1', '滩里镇', '0', '', '1', '0', '0', '10'),
('3874', '130000', '131000', '131026', '1', '1', '史各庄镇', '0', '', '1', '0', '0', '10'),
('3875', '130000', '131000', '131026', '1', '1', '赵各庄镇', '0', '', '1', '0', '0', '10'),
('3876', '130000', '131000', '131026', '1', '1', '兴隆宫镇', '0', '', '1', '0', '0', '10'),
('3877', '130000', '131000', '131026', '1', '1', '大留镇镇', '0', '', '1', '0', '0', '10'),
('3878', '130000', '131000', '131026', '1', '1', '孙氏镇', '0', '', '1', '0', '0', '10'),
('3879', '130000', '131000', '131026', '1', '1', '德归镇', '0', '', '1', '0', '0', '10'),
('3880', '130000', '131000', '131026', '1', '1', '大围河回族满族乡', '0', '', '1', '0', '0', '10'),
('3881', '130000', '131000', '131028', '1', '1', '大厂镇', '0', '', '1', '0', '0', '10'),
('3882', '130000', '131000', '131028', '1', '1', '夏垫镇', '0', '', '1', '0', '0', '10'),
('3883', '130000', '131000', '131028', '1', '1', '祁各庄镇', '0', '', '1', '0', '0', '10'),
('3884', '130000', '131000', '131028', '1', '1', '邵府乡', '0', '', '1', '0', '0', '10'),
('3885', '130000', '131000', '131028', '1', '1', '陈府乡', '0', '', '1', '0', '0', '10'),
('3886', '130000', '131000', '131028', '1', '1', '工业园区', '0', '', '1', '0', '0', '10'),
('3887', '130000', '131000', '131081', '1', '1', '霸州镇', '0', '', '1', '0', '0', '10'),
('3888', '130000', '131000', '131081', '1', '1', '南孟镇', '0', '', '1', '0', '0', '10'),
('3889', '130000', '131000', '131081', '1', '1', '信安镇', '0', '', '1', '0', '0', '10'),
('3890', '130000', '131000', '131081', '1', '1', '堂二里镇', '0', '', '1', '0', '0', '10'),
('3891', '130000', '131000', '131081', '1', '1', '煎茶铺镇', '0', '', '1', '0', '0', '10'),
('3892', '130000', '131000', '131081', '1', '1', '胜芳镇', '0', '', '1', '0', '0', '10'),
('3893', '130000', '131000', '131081', '1', '1', '杨芬港镇', '0', '', '1', '0', '0', '10'),
('3894', '130000', '131000', '131081', '1', '1', '岔河集乡', '0', '', '1', '0', '0', '10'),
('3895', '130000', '131000', '131081', '1', '1', '康仙庄乡', '0', '', '1', '0', '0', '10'),
('3896', '130000', '131000', '131081', '1', '1', '东杨庄乡', '0', '', '1', '0', '0', '10'),
('3897', '130000', '131000', '131081', '1', '1', '王庄子乡', '0', '', '1', '0', '0', '10'),
('3898', '130000', '131000', '131081', '1', '1', '东段乡', '0', '', '1', '0', '0', '10'),
('3899', '130000', '131000', '131081', '1', '1', '霸州经济技术开发区', '0', '', '1', '0', '0', '10'),
('3900', '130000', '131000', '131082', '1', '1', '南城街道', '0', '', '1', '0', '0', '10'),
('3901', '130000', '131000', '131082', '1', '1', '北城街道', '0', '', '1', '0', '0', '10'),
('3902', '130000', '131000', '131082', '1', '1', '泃阳镇', '0', '', '1', '0', '0', '10'),
('3903', '130000', '131000', '131082', '1', '1', '李旗庄镇', '0', '', '1', '0', '0', '10'),
('3904', '130000', '131000', '131082', '1', '1', '杨庄镇', '0', '', '1', '0', '0', '10'),
('3905', '130000', '131000', '131082', '1', '1', '皇庄镇', '0', '', '1', '0', '0', '10'),
('3906', '130000', '131000', '131082', '1', '1', '新集镇', '0', '', '1', '0', '0', '10'),
('3907', '130000', '131000', '131082', '1', '1', '段甲岭镇', '0', '', '1', '0', '0', '10'),
('3908', '130000', '131000', '131082', '1', '1', '黄土庄镇', '0', '', '1', '0', '0', '10'),
('3909', '130000', '131000', '131082', '1', '1', '高楼镇', '0', '', '1', '0', '0', '10'),
('3910', '130000', '131000', '131082', '1', '1', '齐心庄镇', '0', '', '1', '0', '0', '10'),
('3911', '130000', '131000', '131082', '1', '1', '燕郊镇', '0', '', '1', '0', '0', '10'),
('3912', '130000', '131000', '131082', '1', '1', '燕郊经济技术开发区', '0', '', '1', '0', '0', '10'),
('3913', '130000', '131000', '131082', '1', '1', '三河市农业高新技术园区', '0', '', '1', '0', '0', '10'),
('3914', '130000', '131100', '131102', '1', '1', '河西街道', '0', '', '1', '0', '0', '10'),
('3915', '130000', '131100', '131102', '1', '1', '河东街道', '0', '', '1', '0', '0', '10'),
('3916', '130000', '131100', '131102', '1', '1', '路北街道', '0', '', '1', '0', '0', '10'),
('3917', '130000', '131100', '131102', '1', '1', '中华街道', '0', '', '1', '0', '0', '10'),
('3918', '130000', '131100', '131102', '1', '1', '郑家河沿镇', '0', '', '1', '0', '0', '10'),
('3919', '130000', '131100', '131102', '1', '1', '赵家圈镇', '0', '', '1', '0', '0', '10'),
('3920', '130000', '131100', '131102', '1', '1', '何家庄乡', '0', '', '1', '0', '0', '10'),
('3921', '130000', '131100', '131102', '1', '1', '大麻森乡', '0', '', '1', '0', '0', '10'),
('3922', '130000', '131100', '131102', '1', '1', '邓家庄乡', '0', '', '1', '0', '0', '10'),
('3923', '130000', '131100', '131102', '1', '1', '彭杜村乡', '0', '', '1', '0', '0', '10'),
('3924', '130000', '131100', '131102', '1', '1', '衡水高新技术产业开发区', '0', '', '1', '0', '0', '10'),
('3925', '130000', '131100', '131102', '1', '1', '衡水湖自然保护区管理处', '0', '', '1', '0', '0', '10'),
('3926', '130000', '131100', '131121', '1', '1', '枣强镇', '0', '', '1', '0', '0', '10'),
('3927', '130000', '131100', '131121', '1', '1', '恩察镇', '0', '', '1', '0', '0', '10'),
('3928', '130000', '131100', '131121', '1', '1', '大营镇', '0', '', '1', '0', '0', '10'),
('3929', '130000', '131100', '131121', '1', '1', '嘉会镇', '0', '', '1', '0', '0', '10'),
('3930', '130000', '131100', '131121', '1', '1', '马屯镇', '0', '', '1', '0', '0', '10'),
('3931', '130000', '131100', '131121', '1', '1', '肖张镇', '0', '', '1', '0', '0', '10'),
('3932', '130000', '131100', '131121', '1', '1', '张秀屯乡', '0', '', '1', '0', '0', '10'),
('3933', '130000', '131100', '131121', '1', '1', '新屯乡', '0', '', '1', '0', '0', '10'),
('3934', '130000', '131100', '131121', '1', '1', '王均乡', '0', '', '1', '0', '0', '10'),
('3935', '130000', '131100', '131121', '1', '1', '唐林乡', '0', '', '1', '0', '0', '10'),
('3936', '130000', '131100', '131121', '1', '1', '王常乡', '0', '', '1', '0', '0', '10'),
('3937', '130000', '131100', '131122', '1', '1', '武邑镇', '0', '', '1', '0', '0', '10'),
('3938', '130000', '131100', '131122', '1', '1', '清凉店镇', '0', '', '1', '0', '0', '10'),
('3939', '130000', '131100', '131122', '1', '1', '审坡镇', '0', '', '1', '0', '0', '10'),
('3940', '130000', '131100', '131122', '1', '1', '赵桥镇', '0', '', '1', '0', '0', '10'),
('3941', '130000', '131100', '131122', '1', '1', '韩庄镇', '0', '', '1', '0', '0', '10'),
('3942', '130000', '131100', '131122', '1', '1', '肖桥头镇', '0', '', '1', '0', '0', '10'),
('3943', '130000', '131100', '131122', '1', '1', '龙店乡', '0', '', '1', '0', '0', '10'),
('3944', '130000', '131100', '131122', '1', '1', '圈头乡', '0', '', '1', '0', '0', '10'),
('3945', '130000', '131100', '131122', '1', '1', '大紫塔乡', '0', '', '1', '0', '0', '10'),
('3946', '130000', '131100', '131123', '1', '1', '武强镇', '0', '', '1', '0', '0', '10'),
('3947', '130000', '131100', '131123', '1', '1', '街关镇', '0', '', '1', '0', '0', '10'),
('3948', '130000', '131100', '131123', '1', '1', '豆村乡', '0', '', '1', '0', '0', '10'),
('3949', '130000', '131100', '131123', '1', '1', '北代乡', '0', '', '1', '0', '0', '10'),
('3950', '130000', '131100', '131123', '1', '1', '孙庄乡', '0', '', '1', '0', '0', '10'),
('3951', '130000', '131100', '131123', '1', '1', '周家窝乡', '0', '', '1', '0', '0', '10'),
('3952', '130000', '131100', '131124', '1', '1', '饶阳镇', '0', '', '1', '0', '0', '10'),
('3953', '130000', '131100', '131124', '1', '1', '大尹村镇', '0', '', '1', '0', '0', '10'),
('3954', '130000', '131100', '131124', '1', '1', '五公镇', '0', '', '1', '0', '0', '10'),
('3955', '130000', '131100', '131124', '1', '1', '王同岳乡', '0', '', '1', '0', '0', '10'),
('3956', '130000', '131100', '131124', '1', '1', '大官亭乡', '0', '', '1', '0', '0', '10'),
('3957', '130000', '131100', '131124', '1', '1', '留楚乡', '0', '', '1', '0', '0', '10'),
('3958', '130000', '131100', '131124', '1', '1', '东里满乡', '0', '', '1', '0', '0', '10'),
('3959', '130000', '131100', '131125', '1', '1', '安平镇', '0', '', '1', '0', '0', '10'),
('3960', '130000', '131100', '131125', '1', '1', '马店镇', '0', '', '1', '0', '0', '10'),
('3961', '130000', '131100', '131125', '1', '1', '南王庄镇', '0', '', '1', '0', '0', '10'),
('3962', '130000', '131100', '131125', '1', '1', '大何庄乡', '0', '', '1', '0', '0', '10'),
('3963', '130000', '131100', '131125', '1', '1', '程油子乡', '0', '', '1', '0', '0', '10'),
('3964', '130000', '131100', '131125', '1', '1', '西两洼乡', '0', '', '1', '0', '0', '10'),
('3965', '130000', '131100', '131125', '1', '1', '大子文乡', '0', '', '1', '0', '0', '10'),
('3966', '130000', '131100', '131125', '1', '1', '东黄城乡', '0', '', '1', '0', '0', '10'),
('3967', '130000', '131100', '131126', '1', '1', '郑口镇', '0', '', '1', '0', '0', '10'),
('3968', '130000', '131100', '131126', '1', '1', '夏庄镇', '0', '', '1', '0', '0', '10'),
('3969', '130000', '131100', '131126', '1', '1', '青罕镇', '0', '', '1', '0', '0', '10'),
('3970', '130000', '131100', '131126', '1', '1', '故城镇', '0', '', '1', '0', '0', '10'),
('3971', '130000', '131100', '131126', '1', '1', '武官寨镇', '0', '', '1', '0', '0', '10'),
('3972', '130000', '131100', '131126', '1', '1', '饶阳店镇', '0', '', '1', '0', '0', '10'),
('3973', '130000', '131100', '131126', '1', '1', '军屯镇', '0', '', '1', '0', '0', '10'),
('3974', '130000', '131100', '131126', '1', '1', '建国镇', '0', '', '1', '0', '0', '10'),
('3975', '130000', '131100', '131126', '1', '1', '西半屯镇', '0', '', '1', '0', '0', '10'),
('3976', '130000', '131100', '131126', '1', '1', '辛庄乡', '0', '', '1', '0', '0', '10'),
('3977', '130000', '131100', '131126', '1', '1', '里老乡', '0', '', '1', '0', '0', '10'),
('3978', '130000', '131100', '131126', '1', '1', '房庄乡', '0', '', '1', '0', '0', '10'),
('3979', '130000', '131100', '131126', '1', '1', '三朗乡', '0', '', '1', '0', '0', '10'),
('3980', '130000', '131100', '131127', '1', '1', '景州镇', '0', '', '1', '0', '0', '10'),
('3981', '130000', '131100', '131127', '1', '1', '龙华镇', '0', '', '1', '0', '0', '10'),
('3982', '130000', '131100', '131127', '1', '1', '广川镇', '0', '', '1', '0', '0', '10'),
('3983', '130000', '131100', '131127', '1', '1', '王瞳镇', '0', '', '1', '0', '0', '10'),
('3984', '130000', '131100', '131127', '1', '1', '洚河流镇', '0', '', '1', '0', '0', '10'),
('3985', '130000', '131100', '131127', '1', '1', '安陵镇', '0', '', '1', '0', '0', '10'),
('3986', '130000', '131100', '131127', '1', '1', '杜桥镇', '0', '', '1', '0', '0', '10'),
('3987', '130000', '131100', '131127', '1', '1', '王谦寺镇', '0', '', '1', '0', '0', '10'),
('3988', '130000', '131100', '131127', '1', '1', '北留智镇', '0', '', '1', '0', '0', '10'),
('3989', '130000', '131100', '131127', '1', '1', '留智庙镇', '0', '', '1', '0', '0', '10'),
('3990', '130000', '131100', '131127', '1', '1', '刘集乡', '0', '', '1', '0', '0', '10'),
('3991', '130000', '131100', '131127', '1', '1', '连镇乡', '0', '', '1', '0', '0', '10'),
('3992', '130000', '131100', '131127', '1', '1', '梁集乡', '0', '', '1', '0', '0', '10'),
('3993', '130000', '131100', '131127', '1', '1', '温城乡', '0', '', '1', '0', '0', '10'),
('3994', '130000', '131100', '131127', '1', '1', '后留名府乡', '0', '', '1', '0', '0', '10'),
('3995', '130000', '131100', '131127', '1', '1', '青兰乡', '0', '', '1', '0', '0', '10'),
('3996', '130000', '131100', '131128', '1', '1', '阜城镇', '0', '', '1', '0', '0', '10'),
('3997', '130000', '131100', '131128', '1', '1', '古城镇', '0', '', '1', '0', '0', '10'),
('3998', '130000', '131100', '131128', '1', '1', '码头镇', '0', '', '1', '0', '0', '10'),
('3999', '130000', '131100', '131128', '1', '1', '霞口镇', '0', '', '1', '0', '0', '10'),
('4000', '130000', '131100', '131128', '1', '1', '崔家庙镇', '0', '', '1', '0', '0', '10'),
('4001', '130000', '131100', '131128', '1', '1', '漫河乡', '0', '', '1', '0', '0', '10'),
('4002', '130000', '131100', '131128', '1', '1', '建桥乡', '0', '', '1', '0', '0', '10'),
('4003', '130000', '131100', '131128', '1', '1', '蒋坊乡', '0', '', '1', '0', '0', '10'),
('4004', '130000', '131100', '131128', '1', '1', '大白乡', '0', '', '1', '0', '0', '10'),
('4005', '130000', '131100', '131128', '1', '1', '王集乡', '0', '', '1', '0', '0', '10'),
('4006', '130000', '131100', '131181', '1', '1', '冀州镇', '0', '', '1', '0', '0', '10'),
('4007', '130000', '131100', '131181', '1', '1', '魏屯镇', '0', '', '1', '0', '0', '10'),
('4008', '130000', '131100', '131181', '1', '1', '官道李镇', '0', '', '1', '0', '0', '10'),
('4009', '130000', '131100', '131181', '1', '1', '南午村镇', '0', '', '1', '0', '0', '10'),
('4010', '130000', '131100', '131181', '1', '1', '周村镇', '0', '', '1', '0', '0', '10'),
('4011', '130000', '131100', '131181', '1', '1', '码头李镇', '0', '', '1', '0', '0', '10'),
('4012', '130000', '131100', '131181', '1', '1', '西王镇', '0', '', '1', '0', '0', '10'),
('4013', '130000', '131100', '131181', '1', '1', '门庄乡', '0', '', '1', '0', '0', '10'),
('4014', '130000', '131100', '131181', '1', '1', '徐家庄乡', '0', '', '1', '0', '0', '10'),
('4015', '130000', '131100', '131181', '1', '1', '北漳淮乡', '0', '', '1', '0', '0', '10'),
('4016', '130000', '131100', '131181', '1', '1', '小寨乡', '0', '', '1', '0', '0', '10'),
('4017', '130000', '131100', '131182', '1', '1', '唐奉镇', '0', '', '1', '0', '0', '10'),
('4018', '130000', '131100', '131182', '1', '1', '深州镇', '0', '', '1', '0', '0', '10'),
('4019', '130000', '131100', '131182', '1', '1', '辰时镇', '0', '', '1', '0', '0', '10'),
('4020', '130000', '131100', '131182', '1', '1', '榆科镇', '0', '', '1', '0', '0', '10'),
('4021', '130000', '131100', '131182', '1', '1', '魏桥镇', '0', '', '1', '0', '0', '10'),
('4022', '130000', '131100', '131182', '1', '1', '大堤镇', '0', '', '1', '0', '0', '10'),
('4023', '130000', '131100', '131182', '1', '1', '前磨头镇', '0', '', '1', '0', '0', '10'),
('4024', '130000', '131100', '131182', '1', '1', '王家井镇', '0', '', '1', '0', '0', '10'),
('4025', '130000', '131100', '131182', '1', '1', '护驾迟镇', '0', '', '1', '0', '0', '10'),
('4026', '130000', '131100', '131182', '1', '1', '兵曹乡', '0', '', '1', '0', '0', '10'),
('4027', '130000', '131100', '131182', '1', '1', '穆村乡', '0', '', '1', '0', '0', '10'),
('4028', '130000', '131100', '131182', '1', '1', '东安庄乡', '0', '', '1', '0', '0', '10'),
('4029', '130000', '131100', '131182', '1', '1', '北溪村乡', '0', '', '1', '0', '0', '10'),
('4030', '130000', '131100', '131182', '1', '1', '大冯营乡', '0', '', '1', '0', '0', '10'),
('4031', '130000', '131100', '131182', '1', '1', '乔屯乡', '0', '', '1', '0', '0', '10'),
('4032', '130000', '131100', '131182', '1', '1', '太古庄乡', '0', '', '1', '0', '0', '10'),
('4033', '130000', '131100', '131182', '1', '1', '大屯乡', '0', '', '1', '0', '0', '10'),
('4034', '130000', '131100', '131182', '1', '1', '河北省深州监狱', '0', '', '1', '0', '0', '10'),
('4035', '140000', '140100', '140105', '1', '1', '坞城街道', '0', '', '1', '0', '0', '10'),
('4036', '140000', '140100', '140105', '1', '1', '营盘街道', '0', '', '1', '0', '0', '10'),
('4037', '140000', '140100', '140105', '1', '1', '北营街道', '0', '', '1', '0', '0', '10'),
('4038', '140000', '140100', '140105', '1', '1', '平阳路街道', '0', '', '1', '0', '0', '10'),
('4039', '140000', '140100', '140105', '1', '1', '黄陵街道', '0', '', '1', '0', '0', '10'),
('4040', '140000', '140100', '140105', '1', '1', '小店街道', '0', '', '1', '0', '0', '10'),
('4041', '140000', '140100', '140105', '1', '1', '北格镇', '0', '', '1', '0', '0', '10'),
('4042', '140000', '140100', '140105', '1', '1', '西温庄乡', '0', '', '1', '0', '0', '10'),
('4043', '140000', '140100', '140105', '1', '1', '刘家堡乡', '0', '', '1', '0', '0', '10'),
('4044', '140000', '140100', '140105', '1', '1', '太原高新技术产业开发区', '0', '', '1', '0', '0', '10'),
('4045', '140000', '140100', '140105', '1', '1', '太原经济技术开发区', '0', '', '1', '0', '0', '10'),
('4046', '140000', '140100', '140106', '1', '1', '柳巷街道', '0', '', '1', '0', '0', '10'),
('4047', '140000', '140100', '140106', '1', '1', '文庙街道', '0', '', '1', '0', '0', '10'),
('4048', '140000', '140100', '140106', '1', '1', '庙前街道', '0', '', '1', '0', '0', '10'),
('4049', '140000', '140100', '140106', '1', '1', '迎泽街道', '0', '', '1', '0', '0', '10'),
('4050', '140000', '140100', '140106', '1', '1', '桥东街道', '0', '', '1', '0', '0', '10'),
('4051', '140000', '140100', '140106', '1', '1', '老军营街道', '0', '', '1', '0', '0', '10'),
('4052', '140000', '140100', '140106', '1', '1', '郝庄镇', '0', '', '1', '0', '0', '10'),
('4053', '140000', '140100', '140106', '1', '1', '民营区', '0', '', '1', '0', '0', '10'),
('4054', '140000', '140100', '140107', '1', '1', '巨轮街道', '0', '', '1', '0', '0', '10'),
('4055', '140000', '140100', '140107', '1', '1', '三桥街道', '0', '', '1', '0', '0', '10'),
('4056', '140000', '140100', '140107', '1', '1', '鼓楼街道', '0', '', '1', '0', '0', '10'),
('4057', '140000', '140100', '140107', '1', '1', '杏花岭街道', '0', '', '1', '0', '0', '10'),
('4058', '140000', '140100', '140107', '1', '1', '坝陵桥街道', '0', '', '1', '0', '0', '10'),
('4059', '140000', '140100', '140107', '1', '1', '大东关街道', '0', '', '1', '0', '0', '10'),
('4060', '140000', '140100', '140107', '1', '1', '职工新街街道', '0', '', '1', '0', '0', '10'),
('4061', '140000', '140100', '140107', '1', '1', '敦化坊街道', '0', '', '1', '0', '0', '10'),
('4062', '140000', '140100', '140107', '1', '1', '涧河街道', '0', '', '1', '0', '0', '10'),
('4063', '140000', '140100', '140107', '1', '1', '杨家峪街道', '0', '', '1', '0', '0', '10'),
('4064', '140000', '140100', '140107', '1', '1', '中涧河乡', '0', '', '1', '0', '0', '10'),
('4065', '140000', '140100', '140107', '1', '1', '小返乡', '0', '', '1', '0', '0', '10'),
('4066', '140000', '140100', '140107', '1', '1', '民营区', '0', '', '1', '0', '0', '10'),
('4067', '140000', '140100', '140108', '1', '1', '尖草坪街道', '0', '', '1', '0', '0', '10'),
('4068', '140000', '140100', '140108', '1', '1', '光社街道', '0', '', '1', '0', '0', '10'),
('4069', '140000', '140100', '140108', '1', '1', '上兰街道', '0', '', '1', '0', '0', '10'),
('4070', '140000', '140100', '140108', '1', '1', '南寨街道', '0', '', '1', '0', '0', '10'),
('4071', '140000', '140100', '140108', '1', '1', '迎新街道', '0', '', '1', '0', '0', '10'),
('4072', '140000', '140100', '140108', '1', '1', '古城街道', '0', '', '1', '0', '0', '10'),
('4073', '140000', '140100', '140108', '1', '1', '汇丰街道', '0', '', '1', '0', '0', '10'),
('4074', '140000', '140100', '140108', '1', '1', '柴村街道', '0', '', '1', '0', '0', '10'),
('4075', '140000', '140100', '140108', '1', '1', '新城街道', '0', '', '1', '0', '0', '10'),
('4076', '140000', '140100', '140108', '1', '1', '向阳镇', '0', '', '1', '0', '0', '10'),
('4077', '140000', '140100', '140108', '1', '1', '阳曲镇', '0', '', '1', '0', '0', '10'),
('4078', '140000', '140100', '140108', '1', '1', '马头水乡', '0', '', '1', '0', '0', '10'),
('4079', '140000', '140100', '140108', '1', '1', '柏板乡', '0', '', '1', '0', '0', '10'),
('4080', '140000', '140100', '140108', '1', '1', '西焉乡', '0', '', '1', '0', '0', '10'),
('4081', '140000', '140100', '140109', '1', '1', '千峰街道', '0', '', '1', '0', '0', '10'),
('4082', '140000', '140100', '140109', '1', '1', '下元街道', '0', '', '1', '0', '0', '10'),
('4083', '140000', '140100', '140109', '1', '1', '和平街道', '0', '', '1', '0', '0', '10'),
('4084', '140000', '140100', '140109', '1', '1', '兴华街道', '0', '', '1', '0', '0', '10'),
('4085', '140000', '140100', '140109', '1', '1', '万柏林街道', '0', '', '1', '0', '0', '10'),
('4086', '140000', '140100', '140109', '1', '1', '杜儿坪街道', '0', '', '1', '0', '0', '10'),
('4087', '140000', '140100', '140109', '1', '1', '白家庄街道', '0', '', '1', '0', '0', '10'),
('4088', '140000', '140100', '140109', '1', '1', '南寒街道', '0', '', '1', '0', '0', '10'),
('4089', '140000', '140100', '140109', '1', '1', '东社街道', '0', '', '1', '0', '0', '10'),
('4090', '140000', '140100', '140109', '1', '1', '化客头街道', '0', '', '1', '0', '0', '10'),
('4091', '140000', '140100', '140109', '1', '1', '小井峪街道', '0', '', '1', '0', '0', '10'),
('4092', '140000', '140100', '140109', '1', '1', '西铭街道', '0', '', '1', '0', '0', '10'),
('4093', '140000', '140100', '140109', '1', '1', '长风街道', '0', '', '1', '0', '0', '10'),
('4094', '140000', '140100', '140109', '1', '1', '神堂沟街道', '0', '', '1', '0', '0', '10'),
('4095', '140000', '140100', '140109', '1', '1', '王封乡', '0', '', '1', '0', '0', '10'),
('4096', '140000', '140100', '140110', '1', '1', '义井街道', '0', '', '1', '0', '0', '10'),
('4097', '140000', '140100', '140110', '1', '1', '罗城街道', '0', '', '1', '0', '0', '10'),
('4098', '140000', '140100', '140110', '1', '1', '晋源街道', '0', '', '1', '0', '0', '10'),
('4099', '140000', '140100', '140110', '1', '1', '金胜镇', '0', '', '1', '0', '0', '10'),
('4100', '140000', '140100', '140110', '1', '1', '晋祠镇', '0', '', '1', '0', '0', '10'),
('4101', '140000', '140100', '140110', '1', '1', '姚村镇', '0', '', '1', '0', '0', '10'),
('4102', '140000', '140100', '140121', '1', '1', '清源镇', '0', '', '1', '0', '0', '10'),
('4103', '140000', '140100', '140121', '1', '1', '徐沟镇', '0', '', '1', '0', '0', '10'),
('4104', '140000', '140100', '140121', '1', '1', '东于镇', '0', '', '1', '0', '0', '10'),
('4105', '140000', '140100', '140121', '1', '1', '孟封镇', '0', '', '1', '0', '0', '10'),
('4106', '140000', '140100', '140121', '1', '1', '马峪乡', '0', '', '1', '0', '0', '10'),
('4107', '140000', '140100', '140121', '1', '1', '柳杜乡', '0', '', '1', '0', '0', '10'),
('4108', '140000', '140100', '140121', '1', '1', '西谷乡', '0', '', '1', '0', '0', '10'),
('4109', '140000', '140100', '140121', '1', '1', '王答乡', '0', '', '1', '0', '0', '10'),
('4110', '140000', '140100', '140121', '1', '1', '集义乡', '0', '', '1', '0', '0', '10'),
('4111', '140000', '140100', '140122', '1', '1', '黄寨镇', '0', '', '1', '0', '0', '10'),
('4112', '140000', '140100', '140122', '1', '1', '大盂镇', '0', '', '1', '0', '0', '10'),
('4113', '140000', '140100', '140122', '1', '1', '东黄水镇', '0', '', '1', '0', '0', '10'),
('4114', '140000', '140100', '140122', '1', '1', '泥屯镇', '0', '', '1', '0', '0', '10'),
('4115', '140000', '140100', '140122', '1', '1', '阳曲县社区建设管理办公室', '0', '', '1', '0', '0', '10'),
('4116', '140000', '140100', '140122', '1', '1', '高村乡', '0', '', '1', '0', '0', '10'),
('4117', '140000', '140100', '140122', '1', '1', '侯村乡', '0', '', '1', '0', '0', '10'),
('4118', '140000', '140100', '140122', '1', '1', '凌井店乡', '0', '', '1', '0', '0', '10'),
('4119', '140000', '140100', '140122', '1', '1', '西凌井乡', '0', '', '1', '0', '0', '10'),
('4120', '140000', '140100', '140122', '1', '1', '北小店乡', '0', '', '1', '0', '0', '10'),
('4121', '140000', '140100', '140122', '1', '1', '杨兴乡', '0', '', '1', '0', '0', '10'),
('4122', '140000', '140100', '140123', '1', '1', '娄烦镇', '0', '', '1', '0', '0', '10'),
('4123', '140000', '140100', '140123', '1', '1', '静游镇', '0', '', '1', '0', '0', '10'),
('4124', '140000', '140100', '140123', '1', '1', '杜交曲镇', '0', '', '1', '0', '0', '10'),
('4125', '140000', '140100', '140123', '1', '1', '庙湾乡', '0', '', '1', '0', '0', '10'),
('4126', '140000', '140100', '140123', '1', '1', '马家庄乡', '0', '', '1', '0', '0', '10'),
('4127', '140000', '140100', '140123', '1', '1', '盖家庄乡', '0', '', '1', '0', '0', '10'),
('4128', '140000', '140100', '140123', '1', '1', '米峪镇乡', '0', '', '1', '0', '0', '10'),
('4129', '140000', '140100', '140123', '1', '1', '天池店乡', '0', '', '1', '0', '0', '10'),
('4130', '140000', '140100', '140181', '1', '1', '东曲街道', '0', '', '1', '0', '0', '10'),
('4131', '140000', '140100', '140181', '1', '1', '西曲街道', '0', '', '1', '0', '0', '10'),
('4132', '140000', '140100', '140181', '1', '1', '桃园街道', '0', '', '1', '0', '0', '10'),
('4133', '140000', '140100', '140181', '1', '1', '屯兰街道', '0', '', '1', '0', '0', '10'),
('4134', '140000', '140100', '140181', '1', '1', '河口镇', '0', '', '1', '0', '0', '10'),
('4135', '140000', '140100', '140181', '1', '1', '镇城底镇', '0', '', '1', '0', '0', '10'),
('4136', '140000', '140100', '140181', '1', '1', '马兰镇', '0', '', '1', '0', '0', '10'),
('4137', '140000', '140100', '140181', '1', '1', '阁上乡', '0', '', '1', '0', '0', '10'),
('4138', '140000', '140100', '140181', '1', '1', '加乐泉乡', '0', '', '1', '0', '0', '10'),
('4139', '140000', '140100', '140181', '1', '1', '梭峪乡', '0', '', '1', '0', '0', '10'),
('4140', '140000', '140100', '140181', '1', '1', '岔口乡', '0', '', '1', '0', '0', '10'),
('4141', '140000', '140100', '140181', '1', '1', '常安乡', '0', '', '1', '0', '0', '10'),
('4142', '140000', '140100', '140181', '1', '1', '原相乡', '0', '', '1', '0', '0', '10'),
('4143', '140000', '140100', '140181', '1', '1', '邢家社乡', '0', '', '1', '0', '0', '10'),
('4144', '140000', '140200', '140202', '1', '1', '南关街道', '0', '', '1', '0', '0', '10'),
('4145', '140000', '140200', '140202', '1', '1', '北关街道', '0', '', '1', '0', '0', '10'),
('4146', '140000', '140200', '140202', '1', '1', '东街街道', '0', '', '1', '0', '0', '10'),
('4147', '140000', '140200', '140202', '1', '1', '西街街道', '0', '', '1', '0', '0', '10'),
('4148', '140000', '140200', '140202', '1', '1', '南街街道', '0', '', '1', '0', '0', '10'),
('4149', '140000', '140200', '140202', '1', '1', '北街街道', '0', '', '1', '0', '0', '10'),
('4150', '140000', '140200', '140202', '1', '1', '新建南路街道', '0', '', '1', '0', '0', '10'),
('4151', '140000', '140200', '140202', '1', '1', '新建北路街道', '0', '', '1', '0', '0', '10'),
('4152', '140000', '140200', '140202', '1', '1', '大庆路街道', '0', '', '1', '0', '0', '10'),
('4153', '140000', '140200', '140202', '1', '1', '新华街街道', '0', '', '1', '0', '0', '10'),
('4154', '140000', '140200', '140202', '1', '1', '西花园街道', '0', '', '1', '0', '0', '10'),
('4155', '140000', '140200', '140202', '1', '1', '老平旺街道', '0', '', '1', '0', '0', '10'),
('4156', '140000', '140200', '140202', '1', '1', '向阳里街道', '0', '', '1', '0', '0', '10'),
('4157', '140000', '140200', '140202', '1', '1', '振华街街道', '0', '', '1', '0', '0', '10'),
('4158', '140000', '140200', '140203', '1', '1', '新胜街道', '0', '', '1', '0', '0', '10'),
('4159', '140000', '140200', '140203', '1', '1', '新平旺街道', '0', '', '1', '0', '0', '10'),
('4160', '140000', '140200', '140203', '1', '1', '煤峪口街道', '0', '', '1', '0', '0', '10'),
('4161', '140000', '140200', '140203', '1', '1', '永定庄街道', '0', '', '1', '0', '0', '10'),
('4162', '140000', '140200', '140203', '1', '1', '同家梁街道', '0', '', '1', '0', '0', '10'),
('4163', '140000', '140200', '140203', '1', '1', '四老沟街道', '0', '', '1', '0', '0', '10'),
('4164', '140000', '140200', '140203', '1', '1', '忻州窑街道', '0', '', '1', '0', '0', '10'),
('4165', '140000', '140200', '140203', '1', '1', '白洞街道', '0', '', '1', '0', '0', '10'),
('4166', '140000', '140200', '140203', '1', '1', '雁崖街道', '0', '', '1', '0', '0', '10'),
('4167', '140000', '140200', '140203', '1', '1', '挖金湾街道', '0', '', '1', '0', '0', '10'),
('4168', '140000', '140200', '140203', '1', '1', '晋华宫街道', '0', '', '1', '0', '0', '10'),
('4169', '140000', '140200', '140203', '1', '1', '马脊梁街道', '0', '', '1', '0', '0', '10'),
('4170', '140000', '140200', '140203', '1', '1', '大斗沟街道', '0', '', '1', '0', '0', '10'),
('4171', '140000', '140200', '140203', '1', '1', '王村街道', '0', '', '1', '0', '0', '10'),
('4172', '140000', '140200', '140203', '1', '1', '姜家湾街道', '0', '', '1', '0', '0', '10'),
('4173', '140000', '140200', '140203', '1', '1', '新泉路街道', '0', '', '1', '0', '0', '10'),
('4174', '140000', '140200', '140203', '1', '1', '民胜街道', '0', '', '1', '0', '0', '10'),
('4175', '140000', '140200', '140203', '1', '1', '口泉街道', '0', '', '1', '0', '0', '10'),
('4176', '140000', '140200', '140203', '1', '1', '马口街道', '0', '', '1', '0', '0', '10'),
('4177', '140000', '140200', '140203', '1', '1', '燕子山街道', '0', '', '1', '0', '0', '10'),
('4178', '140000', '140200', '140203', '1', '1', '杏儿沟街道', '0', '', '1', '0', '0', '10'),
('4179', '140000', '140200', '140203', '1', '1', '青磁窑街道', '0', '', '1', '0', '0', '10'),
('4180', '140000', '140200', '140203', '1', '1', '平泉路街道', '0', '', '1', '0', '0', '10'),
('4181', '140000', '140200', '140203', '1', '1', '四台沟街道', '0', '', '1', '0', '0', '10'),
('4182', '140000', '140200', '140211', '1', '1', '古店镇', '0', '', '1', '0', '0', '10'),
('4183', '140000', '140200', '140211', '1', '1', '高山镇', '0', '', '1', '0', '0', '10'),
('4184', '140000', '140200', '140211', '1', '1', '云冈镇', '0', '', '1', '0', '0', '10'),
('4185', '140000', '140200', '140211', '1', '1', '口泉乡', '0', '', '1', '0', '0', '10'),
('4186', '140000', '140200', '140211', '1', '1', '新旺乡', '0', '', '1', '0', '0', '10'),
('4187', '140000', '140200', '140211', '1', '1', '水泊寺乡', '0', '', '1', '0', '0', '10'),
('4188', '140000', '140200', '140211', '1', '1', '马军营乡', '0', '', '1', '0', '0', '10'),
('4189', '140000', '140200', '140211', '1', '1', '西韩岭乡', '0', '', '1', '0', '0', '10'),
('4190', '140000', '140200', '140211', '1', '1', '平旺乡', '0', '', '1', '0', '0', '10'),
('4191', '140000', '140200', '140211', '1', '1', '鸦儿崖乡', '0', '', '1', '0', '0', '10'),
('4192', '140000', '140200', '140212', '1', '1', '新荣区社区服务管理中心', '0', '', '1', '0', '0', '10'),
('4193', '140000', '140200', '140212', '1', '1', '新荣镇', '0', '', '1', '0', '0', '10'),
('4194', '140000', '140200', '140212', '1', '1', '破鲁堡乡', '0', '', '1', '0', '0', '10'),
('4195', '140000', '140200', '140212', '1', '1', '郭家窑乡', '0', '', '1', '0', '0', '10'),
('4196', '140000', '140200', '140212', '1', '1', '花元屯乡', '0', '', '1', '0', '0', '10'),
('4197', '140000', '140200', '140212', '1', '1', '西村乡', '0', '', '1', '0', '0', '10'),
('4198', '140000', '140200', '140212', '1', '1', '上深涧乡', '0', '', '1', '0', '0', '10'),
('4199', '140000', '140200', '140212', '1', '1', '堡子湾乡', '0', '', '1', '0', '0', '10'),
('4200', '140000', '140200', '140221', '1', '1', '龙泉镇', '0', '', '1', '0', '0', '10'),
('4201', '140000', '140200', '140221', '1', '1', '罗文皂镇', '0', '', '1', '0', '0', '10'),
('4202', '140000', '140200', '140221', '1', '1', '大白登镇', '0', '', '1', '0', '0', '10'),
('4203', '140000', '140200', '140221', '1', '1', '王官屯镇', '0', '', '1', '0', '0', '10'),
('4204', '140000', '140200', '140221', '1', '1', '古城镇', '0', '', '1', '0', '0', '10'),
('4205', '140000', '140200', '140221', '1', '1', '东小村镇', '0', '', '1', '0', '0', '10'),
('4206', '140000', '140200', '140221', '1', '1', '友宰镇', '0', '', '1', '0', '0', '10'),
('4207', '140000', '140200', '140221', '1', '1', '长城乡', '0', '', '1', '0', '0', '10'),
('4208', '140000', '140200', '140221', '1', '1', '北徐屯乡', '0', '', '1', '0', '0', '10'),
('4209', '140000', '140200', '140221', '1', '1', '狮子屯乡', '0', '', '1', '0', '0', '10'),
('4210', '140000', '140200', '140221', '1', '1', '下深井乡', '0', '', '1', '0', '0', '10'),
('4211', '140000', '140200', '140221', '1', '1', '马家皂乡', '0', '', '1', '0', '0', '10'),
('4212', '140000', '140200', '140221', '1', '1', '鳌石乡', '0', '', '1', '0', '0', '10'),
('4213', '140000', '140200', '140222', '1', '1', '玉泉镇', '0', '', '1', '0', '0', '10'),
('4214', '140000', '140200', '140222', '1', '1', '谷前堡镇', '0', '', '1', '0', '0', '10'),
('4215', '140000', '140200', '140222', '1', '1', '米薪关镇', '0', '', '1', '0', '0', '10'),
('4216', '140000', '140200', '140222', '1', '1', '逯家湾镇', '0', '', '1', '0', '0', '10'),
('4217', '140000', '140200', '140222', '1', '1', '新平镇', '0', '', '1', '0', '0', '10'),
('4218', '140000', '140200', '140222', '1', '1', '卅里铺乡', '0', '', '1', '0', '0', '10'),
('4219', '140000', '140200', '140222', '1', '1', '南河堡乡', '0', '', '1', '0', '0', '10'),
('4220', '140000', '140200', '140222', '1', '1', '贾家屯乡', '0', '', '1', '0', '0', '10'),
('4221', '140000', '140200', '140222', '1', '1', '赵家沟乡', '0', '', '1', '0', '0', '10'),
('4222', '140000', '140200', '140222', '1', '1', '南高崖乡', '0', '', '1', '0', '0', '10'),
('4223', '140000', '140200', '140222', '1', '1', '张西河乡', '0', '', '1', '0', '0', '10'),
('4224', '140000', '140200', '140223', '1', '1', '壶泉镇', '0', '', '1', '0', '0', '10'),
('4225', '140000', '140200', '140223', '1', '1', '南村镇', '0', '', '1', '0', '0', '10'),
('4226', '140000', '140200', '140223', '1', '1', '斗泉乡', '0', '', '1', '0', '0', '10'),
('4227', '140000', '140200', '140223', '1', '1', '蕉山乡', '0', '', '1', '0', '0', '10'),
('4228', '140000', '140200', '140223', '1', '1', '加斗乡', '0', '', '1', '0', '0', '10'),
('4229', '140000', '140200', '140223', '1', '1', '宜兴乡', '0', '', '1', '0', '0', '10'),
('4230', '140000', '140200', '140223', '1', '1', '作疃乡', '0', '', '1', '0', '0', '10'),
('4231', '140000', '140200', '140223', '1', '1', '梁庄乡', '0', '', '1', '0', '0', '10'),
('4232', '140000', '140200', '140223', '1', '1', '望狐乡', '0', '', '1', '0', '0', '10'),
('4233', '140000', '140200', '140224', '1', '1', '武灵镇', '0', '', '1', '0', '0', '10'),
('4234', '140000', '140200', '140224', '1', '1', '东河南镇', '0', '', '1', '0', '0', '10'),
('4235', '140000', '140200', '140224', '1', '1', '上寨镇', '0', '', '1', '0', '0', '10'),
('4236', '140000', '140200', '140224', '1', '1', '落水河乡', '0', '', '1', '0', '0', '10'),
('4237', '140000', '140200', '140224', '1', '1', '史庄乡', '0', '', '1', '0', '0', '10'),
('4238', '140000', '140200', '140224', '1', '1', '赵北乡', '0', '', '1', '0', '0', '10'),
('4239', '140000', '140200', '140224', '1', '1', '石家田乡', '0', '', '1', '0', '0', '10'),
('4240', '140000', '140200', '140224', '1', '1', '柳科乡', '0', '', '1', '0', '0', '10'),
('4241', '140000', '140200', '140224', '1', '1', '白崖台乡', '0', '', '1', '0', '0', '10'),
('4242', '140000', '140200', '140224', '1', '1', '红石塄乡', '0', '', '1', '0', '0', '10'),
('4243', '140000', '140200', '140224', '1', '1', '下关乡', '0', '', '1', '0', '0', '10'),
('4244', '140000', '140200', '140224', '1', '1', '独峪乡', '0', '', '1', '0', '0', '10');
INSERT INTO `wst_communitys` VALUES ('4245', '140000', '140200', '140225', '1', '1', '永安镇', '0', '', '1', '0', '0', '10'),
('4246', '140000', '140200', '140225', '1', '1', '西坊城镇', '0', '', '1', '0', '0', '10'),
('4247', '140000', '140200', '140225', '1', '1', '蔡村镇', '0', '', '1', '0', '0', '10'),
('4248', '140000', '140200', '140225', '1', '1', '沙圪坨镇', '0', '', '1', '0', '0', '10'),
('4249', '140000', '140200', '140225', '1', '1', '王庄堡镇', '0', '', '1', '0', '0', '10'),
('4250', '140000', '140200', '140225', '1', '1', '大磁窑镇', '0', '', '1', '0', '0', '10'),
('4251', '140000', '140200', '140225', '1', '1', '东坊城乡', '0', '', '1', '0', '0', '10'),
('4252', '140000', '140200', '140225', '1', '1', '裴村乡', '0', '', '1', '0', '0', '10'),
('4253', '140000', '140200', '140225', '1', '1', '驼峰乡', '0', '', '1', '0', '0', '10'),
('4254', '140000', '140200', '140225', '1', '1', '西留村乡', '0', '', '1', '0', '0', '10'),
('4255', '140000', '140200', '140225', '1', '1', '下韩村乡', '0', '', '1', '0', '0', '10'),
('4256', '140000', '140200', '140225', '1', '1', '南榆林乡', '0', '', '1', '0', '0', '10'),
('4257', '140000', '140200', '140225', '1', '1', '吴城乡', '0', '', '1', '0', '0', '10'),
('4258', '140000', '140200', '140225', '1', '1', '黄花滩乡', '0', '', '1', '0', '0', '10'),
('4259', '140000', '140200', '140225', '1', '1', '大仁庄乡', '0', '', '1', '0', '0', '10'),
('4260', '140000', '140200', '140225', '1', '1', '千佛岭乡', '0', '', '1', '0', '0', '10'),
('4261', '140000', '140200', '140225', '1', '1', '官儿乡', '0', '', '1', '0', '0', '10'),
('4262', '140000', '140200', '140225', '1', '1', '青磁窑乡', '0', '', '1', '0', '0', '10'),
('4263', '140000', '140200', '140226', '1', '1', '云兴镇', '0', '', '1', '0', '0', '10'),
('4264', '140000', '140200', '140226', '1', '1', '鹊儿山镇', '0', '', '1', '0', '0', '10'),
('4265', '140000', '140200', '140226', '1', '1', '店湾镇', '0', '', '1', '0', '0', '10'),
('4266', '140000', '140200', '140226', '1', '1', '管家堡乡', '0', '', '1', '0', '0', '10'),
('4267', '140000', '140200', '140226', '1', '1', '张家场乡', '0', '', '1', '0', '0', '10'),
('4268', '140000', '140200', '140226', '1', '1', '三屯乡', '0', '', '1', '0', '0', '10'),
('4269', '140000', '140200', '140226', '1', '1', '马道头乡', '0', '', '1', '0', '0', '10'),
('4270', '140000', '140200', '140226', '1', '1', '小京庄乡', '0', '', '1', '0', '0', '10'),
('4271', '140000', '140200', '140226', '1', '1', '水窑乡', '0', '', '1', '0', '0', '10'),
('4272', '140000', '140200', '140227', '1', '1', '湖东街道', '0', '', '1', '0', '0', '10'),
('4273', '140000', '140200', '140227', '1', '1', '东街街道', '0', '', '1', '0', '0', '10'),
('4274', '140000', '140200', '140227', '1', '1', '西街街道', '0', '', '1', '0', '0', '10'),
('4275', '140000', '140200', '140227', '1', '1', '西坪镇', '0', '', '1', '0', '0', '10'),
('4276', '140000', '140200', '140227', '1', '1', '倍加造镇', '0', '', '1', '0', '0', '10'),
('4277', '140000', '140200', '140227', '1', '1', '周士庄镇', '0', '', '1', '0', '0', '10'),
('4278', '140000', '140200', '140227', '1', '1', '吉家庄乡', '0', '', '1', '0', '0', '10'),
('4279', '140000', '140200', '140227', '1', '1', '峰峪乡', '0', '', '1', '0', '0', '10'),
('4280', '140000', '140200', '140227', '1', '1', '杜庄乡', '0', '', '1', '0', '0', '10'),
('4281', '140000', '140200', '140227', '1', '1', '党留庄乡', '0', '', '1', '0', '0', '10'),
('4282', '140000', '140200', '140227', '1', '1', '瓜园乡', '0', '', '1', '0', '0', '10'),
('4283', '140000', '140200', '140227', '1', '1', '巨乐乡', '0', '', '1', '0', '0', '10'),
('4284', '140000', '140200', '140227', '1', '1', '许堡乡', '0', '', '1', '0', '0', '10'),
('4285', '140000', '140200', '140227', '1', '1', '经济技术开发区', '0', '', '1', '0', '0', '10'),
('4286', '140000', '140300', '140302', '1', '1', '上站街道', '0', '', '1', '0', '0', '10'),
('4287', '140000', '140300', '140302', '1', '1', '下站街道', '0', '', '1', '0', '0', '10'),
('4288', '140000', '140300', '140302', '1', '1', '北大街街道', '0', '', '1', '0', '0', '10'),
('4289', '140000', '140300', '140302', '1', '1', '南山路街道', '0', '', '1', '0', '0', '10'),
('4290', '140000', '140300', '140302', '1', '1', '义井街道', '0', '', '1', '0', '0', '10'),
('4291', '140000', '140300', '140302', '1', '1', '坡底街道', '0', '', '1', '0', '0', '10'),
('4292', '140000', '140300', '140303', '1', '1', '平潭街街道', '0', '', '1', '0', '0', '10'),
('4293', '140000', '140300', '140303', '1', '1', '桥头街道', '0', '', '1', '0', '0', '10'),
('4294', '140000', '140300', '140303', '1', '1', '蔡洼街道', '0', '', '1', '0', '0', '10'),
('4295', '140000', '140300', '140303', '1', '1', '赛鱼街道', '0', '', '1', '0', '0', '10'),
('4296', '140000', '140300', '140303', '1', '1', '沙坪街道', '0', '', '1', '0', '0', '10'),
('4297', '140000', '140300', '140303', '1', '1', '贵石沟街道', '0', '', '1', '0', '0', '10'),
('4298', '140000', '140300', '140311', '1', '1', '荫营镇', '0', '', '1', '0', '0', '10'),
('4299', '140000', '140300', '140311', '1', '1', '河底镇', '0', '', '1', '0', '0', '10'),
('4300', '140000', '140300', '140311', '1', '1', '义井镇', '0', '', '1', '0', '0', '10'),
('4301', '140000', '140300', '140311', '1', '1', '平坦镇', '0', '', '1', '0', '0', '10'),
('4302', '140000', '140300', '140311', '1', '1', '西南舁乡', '0', '', '1', '0', '0', '10'),
('4303', '140000', '140300', '140311', '1', '1', '杨家庄乡', '0', '', '1', '0', '0', '10'),
('4304', '140000', '140300', '140311', '1', '1', '李家庄乡', '0', '', '1', '0', '0', '10'),
('4305', '140000', '140300', '140311', '1', '1', '旧街乡', '0', '', '1', '0', '0', '10'),
('4306', '140000', '140300', '140311', '1', '1', '开发区', '0', '', '1', '0', '0', '10'),
('4307', '140000', '140300', '140321', '1', '1', '冠山镇', '0', '', '1', '0', '0', '10'),
('4308', '140000', '140300', '140321', '1', '1', '冶西镇', '0', '', '1', '0', '0', '10'),
('4309', '140000', '140300', '140321', '1', '1', '锁簧镇', '0', '', '1', '0', '0', '10'),
('4310', '140000', '140300', '140321', '1', '1', '张庄镇', '0', '', '1', '0', '0', '10'),
('4311', '140000', '140300', '140321', '1', '1', '东回镇', '0', '', '1', '0', '0', '10'),
('4312', '140000', '140300', '140321', '1', '1', '柏井镇', '0', '', '1', '0', '0', '10'),
('4313', '140000', '140300', '140321', '1', '1', '娘子关镇', '0', '', '1', '0', '0', '10'),
('4314', '140000', '140300', '140321', '1', '1', '巨城镇', '0', '', '1', '0', '0', '10'),
('4315', '140000', '140300', '140321', '1', '1', '石门口乡', '0', '', '1', '0', '0', '10'),
('4316', '140000', '140300', '140321', '1', '1', '岔口乡', '0', '', '1', '0', '0', '10'),
('4317', '140000', '140300', '140322', '1', '1', '秀水镇', '0', '', '1', '0', '0', '10'),
('4318', '140000', '140300', '140322', '1', '1', '孙家庄镇', '0', '', '1', '0', '0', '10'),
('4319', '140000', '140300', '140322', '1', '1', '路家村镇', '0', '', '1', '0', '0', '10'),
('4320', '140000', '140300', '140322', '1', '1', '南娄镇', '0', '', '1', '0', '0', '10'),
('4321', '140000', '140300', '140322', '1', '1', '牛村镇', '0', '', '1', '0', '0', '10'),
('4322', '140000', '140300', '140322', '1', '1', '长池镇', '0', '', '1', '0', '0', '10'),
('4323', '140000', '140300', '140322', '1', '1', '上社镇', '0', '', '1', '0', '0', '10'),
('4324', '140000', '140300', '140322', '1', '1', '西烟镇', '0', '', '1', '0', '0', '10'),
('4325', '140000', '140300', '140322', '1', '1', '仙人乡', '0', '', '1', '0', '0', '10'),
('4326', '140000', '140300', '140322', '1', '1', '北下庄乡', '0', '', '1', '0', '0', '10'),
('4327', '140000', '140300', '140322', '1', '1', '下社乡', '0', '', '1', '0', '0', '10'),
('4328', '140000', '140300', '140322', '1', '1', '梁家寨乡', '0', '', '1', '0', '0', '10'),
('4329', '140000', '140300', '140322', '1', '1', '西潘乡', '0', '', '1', '0', '0', '10'),
('4330', '140000', '140300', '140322', '1', '1', '东梁乡', '0', '', '1', '0', '0', '10'),
('4331', '140000', '140400', '140402', '1', '1', '东街街道', '0', '', '1', '0', '0', '10'),
('4332', '140000', '140400', '140402', '1', '1', '西街街道', '0', '', '1', '0', '0', '10'),
('4333', '140000', '140400', '140402', '1', '1', '英雄南路街道', '0', '', '1', '0', '0', '10'),
('4334', '140000', '140400', '140402', '1', '1', '英雄中路街道', '0', '', '1', '0', '0', '10'),
('4335', '140000', '140400', '140402', '1', '1', '紫金路街道', '0', '', '1', '0', '0', '10'),
('4336', '140000', '140400', '140402', '1', '1', '太东街道', '0', '', '1', '0', '0', '10'),
('4337', '140000', '140400', '140402', '1', '1', '太西街道', '0', '', '1', '0', '0', '10'),
('4338', '140000', '140400', '140402', '1', '1', '延安南路街道', '0', '', '1', '0', '0', '10'),
('4339', '140000', '140400', '140402', '1', '1', '常青街道', '0', '', '1', '0', '0', '10'),
('4340', '140000', '140400', '140402', '1', '1', '五马街道', '0', '', '1', '0', '0', '10'),
('4341', '140000', '140400', '140402', '1', '1', '长治市高新技术开发区', '0', '', '1', '0', '0', '10'),
('4342', '140000', '140400', '140411', '1', '1', '长北街道', '0', '', '1', '0', '0', '10'),
('4343', '140000', '140400', '140411', '1', '1', '故县街道', '0', '', '1', '0', '0', '10'),
('4344', '140000', '140400', '140411', '1', '1', '老顶山镇', '0', '', '1', '0', '0', '10'),
('4345', '140000', '140400', '140411', '1', '1', '堠北庄镇', '0', '', '1', '0', '0', '10'),
('4346', '140000', '140400', '140411', '1', '1', '大辛庄镇', '0', '', '1', '0', '0', '10'),
('4347', '140000', '140400', '140411', '1', '1', '马厂镇', '0', '', '1', '0', '0', '10'),
('4348', '140000', '140400', '140411', '1', '1', '黄碾镇', '0', '', '1', '0', '0', '10'),
('4349', '140000', '140400', '140411', '1', '1', '西白兔乡', '0', '', '1', '0', '0', '10'),
('4350', '140000', '140400', '140421', '1', '1', '韩店镇', '0', '', '1', '0', '0', '10'),
('4351', '140000', '140400', '140421', '1', '1', '苏店镇', '0', '', '1', '0', '0', '10'),
('4352', '140000', '140400', '140421', '1', '1', '荫城镇', '0', '', '1', '0', '0', '10'),
('4353', '140000', '140400', '140421', '1', '1', '西火镇', '0', '', '1', '0', '0', '10'),
('4354', '140000', '140400', '140421', '1', '1', '八义镇', '0', '', '1', '0', '0', '10'),
('4355', '140000', '140400', '140421', '1', '1', '贾掌镇', '0', '', '1', '0', '0', '10'),
('4356', '140000', '140400', '140421', '1', '1', '郝家庄乡', '0', '', '1', '0', '0', '10'),
('4357', '140000', '140400', '140421', '1', '1', '西池乡', '0', '', '1', '0', '0', '10'),
('4358', '140000', '140400', '140421', '1', '1', '北呈乡', '0', '', '1', '0', '0', '10'),
('4359', '140000', '140400', '140421', '1', '1', '东和乡', '0', '', '1', '0', '0', '10'),
('4360', '140000', '140400', '140421', '1', '1', '南宋乡', '0', '', '1', '0', '0', '10'),
('4361', '140000', '140400', '140423', '1', '1', '古韩镇', '0', '', '1', '0', '0', '10'),
('4362', '140000', '140400', '140423', '1', '1', '王桥镇', '0', '', '1', '0', '0', '10'),
('4363', '140000', '140400', '140423', '1', '1', '侯堡镇', '0', '', '1', '0', '0', '10'),
('4364', '140000', '140400', '140423', '1', '1', '夏店镇', '0', '', '1', '0', '0', '10'),
('4365', '140000', '140400', '140423', '1', '1', '虎（音si）亭镇', '0', '', '1', '0', '0', '10'),
('4366', '140000', '140400', '140423', '1', '1', '西营镇', '0', '', '1', '0', '0', '10'),
('4367', '140000', '140400', '140423', '1', '1', '王村镇', '0', '', '1', '0', '0', '10'),
('4368', '140000', '140400', '140423', '1', '1', '下良镇', '0', '', '1', '0', '0', '10'),
('4369', '140000', '140400', '140423', '1', '1', '善福乡', '0', '', '1', '0', '0', '10'),
('4370', '140000', '140400', '140423', '1', '1', '北底乡', '0', '', '1', '0', '0', '10'),
('4371', '140000', '140400', '140423', '1', '1', '上马乡', '0', '', '1', '0', '0', '10'),
('4372', '140000', '140400', '140424', '1', '1', '麟绛镇', '0', '', '1', '0', '0', '10'),
('4373', '140000', '140400', '140424', '1', '1', '上村镇', '0', '', '1', '0', '0', '10'),
('4374', '140000', '140400', '140424', '1', '1', '渔泽镇', '0', '', '1', '0', '0', '10'),
('4375', '140000', '140400', '140424', '1', '1', '余吾镇', '0', '', '1', '0', '0', '10'),
('4376', '140000', '140400', '140424', '1', '1', '吾元镇', '0', '', '1', '0', '0', '10'),
('4377', '140000', '140400', '140424', '1', '1', '张店镇', '0', '', '1', '0', '0', '10'),
('4378', '140000', '140400', '140424', '1', '1', '丰宜镇', '0', '', '1', '0', '0', '10'),
('4379', '140000', '140400', '140424', '1', '1', '李高乡', '0', '', '1', '0', '0', '10'),
('4380', '140000', '140400', '140424', '1', '1', '路村乡', '0', '', '1', '0', '0', '10'),
('4381', '140000', '140400', '140424', '1', '1', '河神庙乡', '0', '', '1', '0', '0', '10'),
('4382', '140000', '140400', '140424', '1', '1', '西贾乡', '0', '', '1', '0', '0', '10'),
('4383', '140000', '140400', '140424', '1', '1', '西流寨开发区', '0', '', '1', '0', '0', '10'),
('4384', '140000', '140400', '140424', '1', '1', '康庄工业园区', '0', '', '1', '0', '0', '10'),
('4385', '140000', '140400', '140424', '1', '1', '上莲开发区', '0', '', '1', '0', '0', '10'),
('4386', '140000', '140400', '140425', '1', '1', '青羊镇', '0', '', '1', '0', '0', '10'),
('4387', '140000', '140400', '140425', '1', '1', '龙溪镇', '0', '', '1', '0', '0', '10'),
('4388', '140000', '140400', '140425', '1', '1', '石城镇', '0', '', '1', '0', '0', '10'),
('4389', '140000', '140400', '140425', '1', '1', '苗庄镇', '0', '', '1', '0', '0', '10'),
('4390', '140000', '140400', '140425', '1', '1', '杏城镇', '0', '', '1', '0', '0', '10'),
('4391', '140000', '140400', '140425', '1', '1', '西沟乡', '0', '', '1', '0', '0', '10'),
('4392', '140000', '140400', '140425', '1', '1', '东寺头乡', '0', '', '1', '0', '0', '10'),
('4393', '140000', '140400', '140425', '1', '1', '虹梯关乡', '0', '', '1', '0', '0', '10'),
('4394', '140000', '140400', '140425', '1', '1', '阳高乡', '0', '', '1', '0', '0', '10'),
('4395', '140000', '140400', '140425', '1', '1', '北耽车乡', '0', '', '1', '0', '0', '10'),
('4396', '140000', '140400', '140425', '1', '1', '中五井乡', '0', '', '1', '0', '0', '10'),
('4397', '140000', '140400', '140425', '1', '1', '北社乡', '0', '', '1', '0', '0', '10'),
('4398', '140000', '140400', '140426', '1', '1', '黎侯镇', '0', '', '1', '0', '0', '10'),
('4399', '140000', '140400', '140426', '1', '1', '东阳关镇', '0', '', '1', '0', '0', '10'),
('4400', '140000', '140400', '140426', '1', '1', '上遥镇', '0', '', '1', '0', '0', '10'),
('4401', '140000', '140400', '140426', '1', '1', '西井镇', '0', '', '1', '0', '0', '10'),
('4402', '140000', '140400', '140426', '1', '1', '黄崖洞镇', '0', '', '1', '0', '0', '10'),
('4403', '140000', '140400', '140426', '1', '1', '西仵乡', '0', '', '1', '0', '0', '10'),
('4404', '140000', '140400', '140426', '1', '1', '停河铺乡', '0', '', '1', '0', '0', '10'),
('4405', '140000', '140400', '140426', '1', '1', '程家山乡', '0', '', '1', '0', '0', '10'),
('4406', '140000', '140400', '140426', '1', '1', '洪井乡', '0', '', '1', '0', '0', '10'),
('4407', '140000', '140400', '140427', '1', '1', '龙泉镇', '0', '', '1', '0', '0', '10'),
('4408', '140000', '140400', '140427', '1', '1', '百尺镇', '0', '', '1', '0', '0', '10'),
('4409', '140000', '140400', '140427', '1', '1', '店上镇', '0', '', '1', '0', '0', '10'),
('4410', '140000', '140400', '140427', '1', '1', '晋庄镇', '0', '', '1', '0', '0', '10'),
('4411', '140000', '140400', '140427', '1', '1', '树掌镇', '0', '', '1', '0', '0', '10'),
('4412', '140000', '140400', '140427', '1', '1', '集店乡', '0', '', '1', '0', '0', '10'),
('4413', '140000', '140400', '140427', '1', '1', '黄山乡', '0', '', '1', '0', '0', '10'),
('4414', '140000', '140400', '140427', '1', '1', '东井岭乡', '0', '', '1', '0', '0', '10'),
('4415', '140000', '140400', '140427', '1', '1', '石坡乡', '0', '', '1', '0', '0', '10'),
('4416', '140000', '140400', '140427', '1', '1', '五龙山乡', '0', '', '1', '0', '0', '10'),
('4417', '140000', '140400', '140427', '1', '1', '鹅屋乡', '0', '', '1', '0', '0', '10'),
('4418', '140000', '140400', '140427', '1', '1', '桥上乡', '0', '', '1', '0', '0', '10'),
('4419', '140000', '140400', '140427', '1', '1', '常平经济开发区', '0', '', '1', '0', '0', '10'),
('4420', '140000', '140400', '140428', '1', '1', '丹朱镇', '0', '', '1', '0', '0', '10'),
('4421', '140000', '140400', '140428', '1', '1', '鲍店镇', '0', '', '1', '0', '0', '10'),
('4422', '140000', '140400', '140428', '1', '1', '石哲镇', '0', '', '1', '0', '0', '10'),
('4423', '140000', '140400', '140428', '1', '1', '大堡头镇', '0', '', '1', '0', '0', '10'),
('4424', '140000', '140400', '140428', '1', '1', '慈林镇', '0', '', '1', '0', '0', '10'),
('4425', '140000', '140400', '140428', '1', '1', '色头镇', '0', '', '1', '0', '0', '10'),
('4426', '140000', '140400', '140428', '1', '1', '南漳镇', '0', '', '1', '0', '0', '10'),
('4427', '140000', '140400', '140428', '1', '1', '岚水乡', '0', '', '1', '0', '0', '10'),
('4428', '140000', '140400', '140428', '1', '1', '碾张乡', '0', '', '1', '0', '0', '10'),
('4429', '140000', '140400', '140428', '1', '1', '常张乡', '0', '', '1', '0', '0', '10'),
('4430', '140000', '140400', '140428', '1', '1', '南陈乡', '0', '', '1', '0', '0', '10'),
('4431', '140000', '140400', '140428', '1', '1', '宋村乡', '0', '', '1', '0', '0', '10'),
('4432', '140000', '140400', '140429', '1', '1', '丰州镇', '0', '', '1', '0', '0', '10'),
('4433', '140000', '140400', '140429', '1', '1', '洪水镇', '0', '', '1', '0', '0', '10'),
('4434', '140000', '140400', '140429', '1', '1', '蟠龙镇', '0', '', '1', '0', '0', '10'),
('4435', '140000', '140400', '140429', '1', '1', '监漳镇', '0', '', '1', '0', '0', '10'),
('4436', '140000', '140400', '140429', '1', '1', '故城镇', '0', '', '1', '0', '0', '10'),
('4437', '140000', '140400', '140429', '1', '1', '墨镫乡', '0', '', '1', '0', '0', '10'),
('4438', '140000', '140400', '140429', '1', '1', '韩北乡', '0', '', '1', '0', '0', '10'),
('4439', '140000', '140400', '140429', '1', '1', '大有乡', '0', '', '1', '0', '0', '10'),
('4440', '140000', '140400', '140429', '1', '1', '贾豁乡', '0', '', '1', '0', '0', '10'),
('4441', '140000', '140400', '140429', '1', '1', '故县乡', '0', '', '1', '0', '0', '10'),
('4442', '140000', '140400', '140429', '1', '1', '上司乡', '0', '', '1', '0', '0', '10'),
('4443', '140000', '140400', '140429', '1', '1', '石北乡', '0', '', '1', '0', '0', '10'),
('4444', '140000', '140400', '140429', '1', '1', '涌泉乡', '0', '', '1', '0', '0', '10'),
('4445', '140000', '140400', '140429', '1', '1', '分水岭乡', '0', '', '1', '0', '0', '10'),
('4446', '140000', '140400', '140430', '1', '1', '定昌镇', '0', '', '1', '0', '0', '10'),
('4447', '140000', '140400', '140430', '1', '1', '郭村镇', '0', '', '1', '0', '0', '10'),
('4448', '140000', '140400', '140430', '1', '1', '故县镇', '0', '', '1', '0', '0', '10'),
('4449', '140000', '140400', '140430', '1', '1', '新店镇', '0', '', '1', '0', '0', '10'),
('4450', '140000', '140400', '140430', '1', '1', '漳源镇', '0', '', '1', '0', '0', '10'),
('4451', '140000', '140400', '140430', '1', '1', '册村镇', '0', '', '1', '0', '0', '10'),
('4452', '140000', '140400', '140430', '1', '1', '段柳乡', '0', '', '1', '0', '0', '10'),
('4453', '140000', '140400', '140430', '1', '1', '松村乡', '0', '', '1', '0', '0', '10'),
('4454', '140000', '140400', '140430', '1', '1', '次村乡', '0', '', '1', '0', '0', '10'),
('4455', '140000', '140400', '140430', '1', '1', '牛寺乡', '0', '', '1', '0', '0', '10'),
('4456', '140000', '140400', '140430', '1', '1', '南里乡', '0', '', '1', '0', '0', '10'),
('4457', '140000', '140400', '140430', '1', '1', '南泉乡', '0', '', '1', '0', '0', '10'),
('4458', '140000', '140400', '140430', '1', '1', '杨安乡', '0', '', '1', '0', '0', '10'),
('4459', '140000', '140400', '140431', '1', '1', '沁河镇', '0', '', '1', '0', '0', '10'),
('4460', '140000', '140400', '140431', '1', '1', '郭道镇', '0', '', '1', '0', '0', '10'),
('4461', '140000', '140400', '140431', '1', '1', '灵空山镇', '0', '', '1', '0', '0', '10'),
('4462', '140000', '140400', '140431', '1', '1', '王和镇', '0', '', '1', '0', '0', '10'),
('4463', '140000', '140400', '140431', '1', '1', '李元镇', '0', '', '1', '0', '0', '10'),
('4464', '140000', '140400', '140431', '1', '1', '中峪乡', '0', '', '1', '0', '0', '10'),
('4465', '140000', '140400', '140431', '1', '1', '法中乡', '0', '', '1', '0', '0', '10'),
('4466', '140000', '140400', '140431', '1', '1', '交口乡', '0', '', '1', '0', '0', '10'),
('4467', '140000', '140400', '140431', '1', '1', '聪子峪乡', '0', '', '1', '0', '0', '10'),
('4468', '140000', '140400', '140431', '1', '1', '韩洪乡', '0', '', '1', '0', '0', '10'),
('4469', '140000', '140400', '140431', '1', '1', '官滩乡', '0', '', '1', '0', '0', '10'),
('4470', '140000', '140400', '140431', '1', '1', '景凤乡', '0', '', '1', '0', '0', '10'),
('4471', '140000', '140400', '140431', '1', '1', '赤石桥乡', '0', '', '1', '0', '0', '10'),
('4472', '140000', '140400', '140431', '1', '1', '王陶乡', '0', '', '1', '0', '0', '10'),
('4473', '140000', '140400', '140481', '1', '1', '潞华', '0', '', '1', '0', '0', '10'),
('4474', '140000', '140400', '140481', '1', '1', '成家川', '0', '', '1', '0', '0', '10'),
('4475', '140000', '140400', '140481', '1', '1', '店上镇', '0', '', '1', '0', '0', '10'),
('4476', '140000', '140400', '140481', '1', '1', '微子镇', '0', '', '1', '0', '0', '10'),
('4477', '140000', '140400', '140481', '1', '1', '辛安泉镇', '0', '', '1', '0', '0', '10'),
('4478', '140000', '140400', '140481', '1', '1', '翟店镇', '0', '', '1', '0', '0', '10'),
('4479', '140000', '140400', '140481', '1', '1', '合室乡', '0', '', '1', '0', '0', '10'),
('4480', '140000', '140400', '140481', '1', '1', '黄牛蹄乡', '0', '', '1', '0', '0', '10'),
('4481', '140000', '140400', '140481', '1', '1', '史回乡', '0', '', '1', '0', '0', '10'),
('4482', '140000', '140500', '140502', '1', '1', '东街街道', '0', '', '1', '0', '0', '10'),
('4483', '140000', '140500', '140502', '1', '1', '西街街道', '0', '', '1', '0', '0', '10'),
('4484', '140000', '140500', '140502', '1', '1', '南街街道', '0', '', '1', '0', '0', '10'),
('4485', '140000', '140500', '140502', '1', '1', '北街街道', '0', '', '1', '0', '0', '10'),
('4486', '140000', '140500', '140502', '1', '1', '矿区街道', '0', '', '1', '0', '0', '10'),
('4487', '140000', '140500', '140502', '1', '1', '钟家庄街道', '0', '', '1', '0', '0', '10'),
('4488', '140000', '140500', '140502', '1', '1', '西上庄街道', '0', '', '1', '0', '0', '10'),
('4489', '140000', '140500', '140502', '1', '1', '北石店镇', '0', '', '1', '0', '0', '10'),
('4490', '140000', '140500', '140521', '1', '1', '龙港镇', '0', '', '1', '0', '0', '10'),
('4491', '140000', '140500', '140521', '1', '1', '中村镇', '0', '', '1', '0', '0', '10'),
('4492', '140000', '140500', '140521', '1', '1', '郑庄镇', '0', '', '1', '0', '0', '10'),
('4493', '140000', '140500', '140521', '1', '1', '端氏镇', '0', '', '1', '0', '0', '10'),
('4494', '140000', '140500', '140521', '1', '1', '嘉峰镇', '0', '', '1', '0', '0', '10'),
('4495', '140000', '140500', '140521', '1', '1', '郑村镇', '0', '', '1', '0', '0', '10'),
('4496', '140000', '140500', '140521', '1', '1', '柿庄镇', '0', '', '1', '0', '0', '10'),
('4497', '140000', '140500', '140521', '1', '1', '樊村河乡', '0', '', '1', '0', '0', '10'),
('4498', '140000', '140500', '140521', '1', '1', '土沃乡', '0', '', '1', '0', '0', '10'),
('4499', '140000', '140500', '140521', '1', '1', '张村乡', '0', '', '1', '0', '0', '10'),
('4500', '140000', '140500', '140521', '1', '1', '苏庄乡', '0', '', '1', '0', '0', '10'),
('4501', '140000', '140500', '140521', '1', '1', '胡底乡', '0', '', '1', '0', '0', '10'),
('4502', '140000', '140500', '140521', '1', '1', '固县乡', '0', '', '1', '0', '0', '10'),
('4503', '140000', '140500', '140521', '1', '1', '十里乡', '0', '', '1', '0', '0', '10'),
('4504', '140000', '140500', '140522', '1', '1', '东城街道', '0', '', '1', '0', '0', '10'),
('4505', '140000', '140500', '140522', '1', '1', '凤城镇', '0', '', '1', '0', '0', '10'),
('4506', '140000', '140500', '140522', '1', '1', '北留镇', '0', '', '1', '0', '0', '10'),
('4507', '140000', '140500', '140522', '1', '1', '润城镇', '0', '', '1', '0', '0', '10'),
('4508', '140000', '140500', '140522', '1', '1', '町店镇', '0', '', '1', '0', '0', '10'),
('4509', '140000', '140500', '140522', '1', '1', '芹池镇', '0', '', '1', '0', '0', '10'),
('4510', '140000', '140500', '140522', '1', '1', '次营镇', '0', '', '1', '0', '0', '10'),
('4511', '140000', '140500', '140522', '1', '1', '横河镇', '0', '', '1', '0', '0', '10'),
('4512', '140000', '140500', '140522', '1', '1', '河北镇', '0', '', '1', '0', '0', '10'),
('4513', '140000', '140500', '140522', '1', '1', '蟒河镇', '0', '', '1', '0', '0', '10'),
('4514', '140000', '140500', '140522', '1', '1', '东冶镇', '0', '', '1', '0', '0', '10'),
('4515', '140000', '140500', '140522', '1', '1', '白桑乡', '0', '', '1', '0', '0', '10'),
('4516', '140000', '140500', '140522', '1', '1', '寺头乡', '0', '', '1', '0', '0', '10'),
('4517', '140000', '140500', '140522', '1', '1', '西河乡', '0', '', '1', '0', '0', '10'),
('4518', '140000', '140500', '140522', '1', '1', '演礼乡', '0', '', '1', '0', '0', '10'),
('4519', '140000', '140500', '140522', '1', '1', '固隆乡', '0', '', '1', '0', '0', '10'),
('4520', '140000', '140500', '140522', '1', '1', '董封乡', '0', '', '1', '0', '0', '10'),
('4521', '140000', '140500', '140522', '1', '1', '驾岭乡', '0', '', '1', '0', '0', '10'),
('4522', '140000', '140500', '140524', '1', '1', '崇文镇', '0', '', '1', '0', '0', '10'),
('4523', '140000', '140500', '140524', '1', '1', '礼义镇', '0', '', '1', '0', '0', '10'),
('4524', '140000', '140500', '140524', '1', '1', '附城镇', '0', '', '1', '0', '0', '10'),
('4525', '140000', '140500', '140524', '1', '1', '西河底镇', '0', '', '1', '0', '0', '10'),
('4526', '140000', '140500', '140524', '1', '1', '平城镇', '0', '', '1', '0', '0', '10'),
('4527', '140000', '140500', '140524', '1', '1', '杨村镇', '0', '', '1', '0', '0', '10'),
('4528', '140000', '140500', '140524', '1', '1', '潞城镇', '0', '', '1', '0', '0', '10'),
('4529', '140000', '140500', '140524', '1', '1', '夺火乡', '0', '', '1', '0', '0', '10'),
('4530', '140000', '140500', '140524', '1', '1', '马圪当乡', '0', '', '1', '0', '0', '10'),
('4531', '140000', '140500', '140524', '1', '1', '古郊乡', '0', '', '1', '0', '0', '10'),
('4532', '140000', '140500', '140524', '1', '1', '六泉乡', '0', '', '1', '0', '0', '10'),
('4533', '140000', '140500', '140524', '1', '1', '秦家庄乡', '0', '', '1', '0', '0', '10'),
('4534', '140000', '140500', '140525', '1', '1', '南村镇', '0', '', '1', '0', '0', '10'),
('4535', '140000', '140500', '140525', '1', '1', '下村镇', '0', '', '1', '0', '0', '10'),
('4536', '140000', '140500', '140525', '1', '1', '大东沟镇', '0', '', '1', '0', '0', '10'),
('4537', '140000', '140500', '140525', '1', '1', '周村镇', '0', '', '1', '0', '0', '10'),
('4538', '140000', '140500', '140525', '1', '1', '犁川镇', '0', '', '1', '0', '0', '10'),
('4539', '140000', '140500', '140525', '1', '1', '晋庙铺镇', '0', '', '1', '0', '0', '10'),
('4540', '140000', '140500', '140525', '1', '1', '金村镇', '0', '', '1', '0', '0', '10'),
('4541', '140000', '140500', '140525', '1', '1', '高都镇', '0', '', '1', '0', '0', '10'),
('4542', '140000', '140500', '140525', '1', '1', '巴公镇', '0', '', '1', '0', '0', '10'),
('4543', '140000', '140500', '140525', '1', '1', '大阳镇', '0', '', '1', '0', '0', '10'),
('4544', '140000', '140500', '140525', '1', '1', '山河镇', '0', '', '1', '0', '0', '10'),
('4545', '140000', '140500', '140525', '1', '1', '大箕镇', '0', '', '1', '0', '0', '10'),
('4546', '140000', '140500', '140525', '1', '1', '柳树口镇', '0', '', '1', '0', '0', '10'),
('4547', '140000', '140500', '140525', '1', '1', '北义城镇', '0', '', '1', '0', '0', '10'),
('4548', '140000', '140500', '140525', '1', '1', '川底乡', '0', '', '1', '0', '0', '10'),
('4549', '140000', '140500', '140525', '1', '1', '李寨乡', '0', '', '1', '0', '0', '10'),
('4550', '140000', '140500', '140525', '1', '1', '南岭乡', '0', '', '1', '0', '0', '10'),
('4551', '140000', '140500', '140581', '1', '1', '北城街道', '0', '', '1', '0', '0', '10'),
('4552', '140000', '140500', '140581', '1', '1', '东城街道', '0', '', '1', '0', '0', '10'),
('4553', '140000', '140500', '140581', '1', '1', '南城街道', '0', '', '1', '0', '0', '10'),
('4554', '140000', '140500', '140581', '1', '1', '米山镇', '0', '', '1', '0', '0', '10'),
('4555', '140000', '140500', '140581', '1', '1', '三甲镇', '0', '', '1', '0', '0', '10'),
('4556', '140000', '140500', '140581', '1', '1', '神农镇', '0', '', '1', '0', '0', '10'),
('4557', '140000', '140500', '140581', '1', '1', '陈区镇', '0', '', '1', '0', '0', '10'),
('4558', '140000', '140500', '140581', '1', '1', '北诗镇', '0', '', '1', '0', '0', '10'),
('4559', '140000', '140500', '140581', '1', '1', '河西镇', '0', '', '1', '0', '0', '10'),
('4560', '140000', '140500', '140581', '1', '1', '马村镇', '0', '', '1', '0', '0', '10'),
('4561', '140000', '140500', '140581', '1', '1', '野川镇', '0', '', '1', '0', '0', '10'),
('4562', '140000', '140500', '140581', '1', '1', '寺庄镇', '0', '', '1', '0', '0', '10'),
('4563', '140000', '140500', '140581', '1', '1', '建宁乡', '0', '', '1', '0', '0', '10'),
('4564', '140000', '140500', '140581', '1', '1', '石末乡', '0', '', '1', '0', '0', '10'),
('4565', '140000', '140500', '140581', '1', '1', '原村乡', '0', '', '1', '0', '0', '10'),
('4566', '140000', '140500', '140581', '1', '1', '永录乡', '0', '', '1', '0', '0', '10'),
('4567', '140000', '140600', '140602', '1', '1', '朔城区北城街道', '0', '', '1', '0', '0', '10'),
('4568', '140000', '140600', '140602', '1', '1', '朔城区南城街道', '0', '', '1', '0', '0', '10'),
('4569', '140000', '140600', '140602', '1', '1', '朔城区神头街道', '0', '', '1', '0', '0', '10'),
('4570', '140000', '140600', '140602', '1', '1', '朔城区北旺庄街道', '0', '', '1', '0', '0', '10'),
('4571', '140000', '140600', '140602', '1', '1', '朔城区神头镇', '0', '', '1', '0', '0', '10'),
('4572', '140000', '140600', '140602', '1', '1', '朔城区利民镇', '0', '', '1', '0', '0', '10'),
('4573', '140000', '140600', '140602', '1', '1', '朔城区下团堡乡', '0', '', '1', '0', '0', '10'),
('4574', '140000', '140600', '140602', '1', '1', '朔城区小平易乡', '0', '', '1', '0', '0', '10');
INSERT INTO `wst_communitys` VALUES ('4575', '140000', '140600', '140602', '1', '1', '朔城区滋润乡', '0', '', '1', '0', '0', '10'),
('4576', '140000', '140600', '140602', '1', '1', '朔城区福善庄乡', '0', '', '1', '0', '0', '10'),
('4577', '140000', '140600', '140602', '1', '1', '朔城区南榆林乡', '0', '', '1', '0', '0', '10'),
('4578', '140000', '140600', '140602', '1', '1', '朔城区贾庄乡', '0', '', '1', '0', '0', '10'),
('4579', '140000', '140600', '140602', '1', '1', '朔城区沙塄河乡', '0', '', '1', '0', '0', '10'),
('4580', '140000', '140600', '140602', '1', '1', '朔城区窑子头乡', '0', '', '1', '0', '0', '10'),
('4581', '140000', '140600', '140602', '1', '1', '朔城区张蔡庄乡', '0', '', '1', '0', '0', '10'),
('4582', '140000', '140600', '140602', '1', '1', '朔州市开发区管委会', '0', '', '1', '0', '0', '10'),
('4583', '140000', '140600', '140603', '1', '1', '平鲁区井坪镇', '0', '', '1', '0', '0', '10'),
('4584', '140000', '140600', '140603', '1', '1', '平鲁区凤凰城镇', '0', '', '1', '0', '0', '10'),
('4585', '140000', '140600', '140603', '1', '1', '平鲁区白堂乡', '0', '', '1', '0', '0', '10'),
('4586', '140000', '140600', '140603', '1', '1', '平鲁区陶村乡', '0', '', '1', '0', '0', '10'),
('4587', '140000', '140600', '140603', '1', '1', '平鲁区下水头乡', '0', '', '1', '0', '0', '10'),
('4588', '140000', '140600', '140603', '1', '1', '平鲁区双碾乡', '0', '', '1', '0', '0', '10'),
('4589', '140000', '140600', '140603', '1', '1', '平鲁区阻虎乡', '0', '', '1', '0', '0', '10'),
('4590', '140000', '140600', '140603', '1', '1', '平鲁区高石庄乡', '0', '', '1', '0', '0', '10'),
('4591', '140000', '140600', '140603', '1', '1', '平鲁区西水界乡', '0', '', '1', '0', '0', '10'),
('4592', '140000', '140600', '140603', '1', '1', '平鲁区下面高乡', '0', '', '1', '0', '0', '10'),
('4593', '140000', '140600', '140603', '1', '1', '平鲁区下木角乡', '0', '', '1', '0', '0', '10'),
('4594', '140000', '140600', '140603', '1', '1', '平鲁区向阳堡乡', '0', '', '1', '0', '0', '10'),
('4595', '140000', '140600', '140603', '1', '1', '平鲁区榆岭乡', '0', '', '1', '0', '0', '10'),
('4596', '140000', '140600', '140621', '1', '1', '东城管委会', '0', '', '1', '0', '0', '10'),
('4597', '140000', '140600', '140621', '1', '1', '西城管委会', '0', '', '1', '0', '0', '10'),
('4598', '140000', '140600', '140621', '1', '1', '玉井镇', '0', '', '1', '0', '0', '10'),
('4599', '140000', '140600', '140621', '1', '1', '北周庄镇', '0', '', '1', '0', '0', '10'),
('4600', '140000', '140600', '140621', '1', '1', '古城镇', '0', '', '1', '0', '0', '10'),
('4601', '140000', '140600', '140621', '1', '1', '吴马营乡', '0', '', '1', '0', '0', '10'),
('4602', '140000', '140600', '140621', '1', '1', '马营乡', '0', '', '1', '0', '0', '10'),
('4603', '140000', '140600', '140621', '1', '1', '下喇叭乡', '0', '', '1', '0', '0', '10'),
('4604', '140000', '140600', '140621', '1', '1', '合盛堡乡', '0', '', '1', '0', '0', '10'),
('4605', '140000', '140600', '140621', '1', '1', '岱岳乡', '0', '', '1', '0', '0', '10'),
('4606', '140000', '140600', '140621', '1', '1', '安荣乡', '0', '', '1', '0', '0', '10'),
('4607', '140000', '140600', '140621', '1', '1', '薛OO乡', '0', '', '1', '0', '0', '10'),
('4608', '140000', '140600', '140621', '1', '1', '后所乡', '0', '', '1', '0', '0', '10'),
('4609', '140000', '140600', '140621', '1', '1', '张家庄乡', '0', '', '1', '0', '0', '10'),
('4610', '140000', '140600', '140621', '1', '1', '马营庄乡', '0', '', '1', '0', '0', '10'),
('4611', '140000', '140600', '140622', '1', '1', '金城镇', '0', '', '1', '0', '0', '10'),
('4612', '140000', '140600', '140622', '1', '1', '南河种镇', '0', '', '1', '0', '0', '10'),
('4613', '140000', '140600', '140622', '1', '1', '下社镇', '0', '', '1', '0', '0', '10'),
('4614', '140000', '140600', '140622', '1', '1', '镇子梁乡', '0', '', '1', '0', '0', '10'),
('4615', '140000', '140600', '140622', '1', '1', '义井乡', '0', '', '1', '0', '0', '10'),
('4616', '140000', '140600', '140622', '1', '1', '藏寨乡', '0', '', '1', '0', '0', '10'),
('4617', '140000', '140600', '140622', '1', '1', '大黄巍乡', '0', '', '1', '0', '0', '10'),
('4618', '140000', '140600', '140622', '1', '1', '杏寨乡', '0', '', '1', '0', '0', '10'),
('4619', '140000', '140600', '140622', '1', '1', '下马峪乡', '0', '', '1', '0', '0', '10'),
('4620', '140000', '140600', '140622', '1', '1', '南泉乡', '0', '', '1', '0', '0', '10'),
('4621', '140000', '140600', '140622', '1', '1', '大临河乡', '0', '', '1', '0', '0', '10'),
('4622', '140000', '140600', '140622', '1', '1', '白马石乡', '0', '', '1', '0', '0', '10'),
('4623', '140000', '140600', '140623', '1', '1', '新城镇', '0', '', '1', '0', '0', '10'),
('4624', '140000', '140600', '140623', '1', '1', '右卫镇', '0', '', '1', '0', '0', '10'),
('4625', '140000', '140600', '140623', '1', '1', '威远镇', '0', '', '1', '0', '0', '10'),
('4626', '140000', '140600', '140623', '1', '1', '元堡子镇', '0', '', '1', '0', '0', '10'),
('4627', '140000', '140600', '140623', '1', '1', '牛心堡乡', '0', '', '1', '0', '0', '10'),
('4628', '140000', '140600', '140623', '1', '1', '白头里乡', '0', '', '1', '0', '0', '10'),
('4629', '140000', '140600', '140623', '1', '1', '高家堡乡', '0', '', '1', '0', '0', '10'),
('4630', '140000', '140600', '140623', '1', '1', '丁家窑乡', '0', '', '1', '0', '0', '10'),
('4631', '140000', '140600', '140623', '1', '1', '杨千河乡', '0', '', '1', '0', '0', '10'),
('4632', '140000', '140600', '140623', '1', '1', '李达窑乡', '0', '', '1', '0', '0', '10'),
('4633', '140000', '140600', '140624', '1', '1', '云中镇', '0', '', '1', '0', '0', '10'),
('4634', '140000', '140600', '140624', '1', '1', '吴家窑镇', '0', '', '1', '0', '0', '10'),
('4635', '140000', '140600', '140624', '1', '1', '金沙滩镇', '0', '', '1', '0', '0', '10'),
('4636', '140000', '140600', '140624', '1', '1', '毛家皂镇', '0', '', '1', '0', '0', '10'),
('4637', '140000', '140600', '140624', '1', '1', '何家堡乡', '0', '', '1', '0', '0', '10'),
('4638', '140000', '140600', '140624', '1', '1', '新家园乡', '0', '', '1', '0', '0', '10'),
('4639', '140000', '140600', '140624', '1', '1', '亲和乡', '0', '', '1', '0', '0', '10'),
('4640', '140000', '140600', '140624', '1', '1', '海北头乡', '0', '', '1', '0', '0', '10'),
('4641', '140000', '140600', '140624', '1', '1', '马辛庄乡', '0', '', '1', '0', '0', '10'),
('4642', '140000', '140600', '140624', '1', '1', '河头乡', '0', '', '1', '0', '0', '10'),
('4643', '140000', '140600', '140624', '1', '1', '金沙滩农牧场', '0', '', '1', '0', '0', '10'),
('4644', '140000', '140600', '140624', '1', '1', '金沙滩林场', '0', '', '1', '0', '0', '10'),
('4645', '140000', '140700', '140702', '1', '1', '北关街道', '0', '', '1', '0', '0', '10'),
('4646', '140000', '140700', '140702', '1', '1', '锦纶街道', '0', '', '1', '0', '0', '10'),
('4647', '140000', '140700', '140702', '1', '1', '新华街道', '0', '', '1', '0', '0', '10'),
('4648', '140000', '140700', '140702', '1', '1', '西南街道', '0', '', '1', '0', '0', '10'),
('4649', '140000', '140700', '140702', '1', '1', '路西街道', '0', '', '1', '0', '0', '10'),
('4650', '140000', '140700', '140702', '1', '1', '经纬街道', '0', '', '1', '0', '0', '10'),
('4651', '140000', '140700', '140702', '1', '1', '安宁街道', '0', '', '1', '0', '0', '10'),
('4652', '140000', '140700', '140702', '1', '1', '新建街道', '0', '', '1', '0', '0', '10'),
('4653', '140000', '140700', '140702', '1', '1', '晋华街道', '0', '', '1', '0', '0', '10'),
('4654', '140000', '140700', '140702', '1', '1', '乌金山镇', '0', '', '1', '0', '0', '10'),
('4655', '140000', '140700', '140702', '1', '1', '东阳镇', '0', '', '1', '0', '0', '10'),
('4656', '140000', '140700', '140702', '1', '1', '什贴镇', '0', '', '1', '0', '0', '10'),
('4657', '140000', '140700', '140702', '1', '1', '长凝镇', '0', '', '1', '0', '0', '10'),
('4658', '140000', '140700', '140702', '1', '1', '北田镇', '0', '', '1', '0', '0', '10'),
('4659', '140000', '140700', '140702', '1', '1', '修文镇', '0', '', '1', '0', '0', '10'),
('4660', '140000', '140700', '140702', '1', '1', '郭家堡乡', '0', '', '1', '0', '0', '10'),
('4661', '140000', '140700', '140702', '1', '1', '张庆乡', '0', '', '1', '0', '0', '10'),
('4662', '140000', '140700', '140702', '1', '1', '庄子乡', '0', '', '1', '0', '0', '10'),
('4663', '140000', '140700', '140702', '1', '1', '东赵乡', '0', '', '1', '0', '0', '10'),
('4664', '140000', '140700', '140702', '1', '1', '晋中经济开发区', '0', '', '1', '0', '0', '10'),
('4665', '140000', '140700', '140721', '1', '1', '城区街道管理委员会', '0', '', '1', '0', '0', '10'),
('4666', '140000', '140700', '140721', '1', '1', '箕城镇', '0', '', '1', '0', '0', '10'),
('4667', '140000', '140700', '140721', '1', '1', '云竹镇', '0', '', '1', '0', '0', '10'),
('4668', '140000', '140700', '140721', '1', '1', '郝北镇', '0', '', '1', '0', '0', '10'),
('4669', '140000', '140700', '140721', '1', '1', '社城镇', '0', '', '1', '0', '0', '10'),
('4670', '140000', '140700', '140721', '1', '1', '河峪乡', '0', '', '1', '0', '0', '10'),
('4671', '140000', '140700', '140721', '1', '1', '北寨乡', '0', '', '1', '0', '0', '10'),
('4672', '140000', '140700', '140721', '1', '1', '西马乡', '0', '', '1', '0', '0', '10'),
('4673', '140000', '140700', '140721', '1', '1', '岚峪乡', '0', '', '1', '0', '0', '10'),
('4674', '140000', '140700', '140721', '1', '1', '讲堂乡', '0', '', '1', '0', '0', '10'),
('4675', '140000', '140700', '140722', '1', '1', '县城街道社区管理委员会', '0', '', '1', '0', '0', '10'),
('4676', '140000', '140700', '140722', '1', '1', '辽阳镇', '0', '', '1', '0', '0', '10'),
('4677', '140000', '140700', '140722', '1', '1', '桐峪镇', '0', '', '1', '0', '0', '10'),
('4678', '140000', '140700', '140722', '1', '1', '麻田镇', '0', '', '1', '0', '0', '10'),
('4679', '140000', '140700', '140722', '1', '1', '芹泉镇', '0', '', '1', '0', '0', '10'),
('4680', '140000', '140700', '140722', '1', '1', '拐儿镇', '0', '', '1', '0', '0', '10'),
('4681', '140000', '140700', '140722', '1', '1', '寒王乡', '0', '', '1', '0', '0', '10'),
('4682', '140000', '140700', '140722', '1', '1', '石匣乡', '0', '', '1', '0', '0', '10'),
('4683', '140000', '140700', '140722', '1', '1', '龙泉乡', '0', '', '1', '0', '0', '10'),
('4684', '140000', '140700', '140722', '1', '1', '粟城乡', '0', '', '1', '0', '0', '10'),
('4685', '140000', '140700', '140722', '1', '1', '羊角乡', '0', '', '1', '0', '0', '10'),
('4686', '140000', '140700', '140723', '1', '1', '义兴镇', '0', '', '1', '0', '0', '10'),
('4687', '140000', '140700', '140723', '1', '1', '李阳镇', '0', '', '1', '0', '0', '10'),
('4688', '140000', '140700', '140723', '1', '1', '松烟镇', '0', '', '1', '0', '0', '10'),
('4689', '140000', '140700', '140723', '1', '1', '青城镇', '0', '', '1', '0', '0', '10'),
('4690', '140000', '140700', '140723', '1', '1', '横岭镇', '0', '', '1', '0', '0', '10'),
('4691', '140000', '140700', '140723', '1', '1', '喂马乡', '0', '', '1', '0', '0', '10'),
('4692', '140000', '140700', '140723', '1', '1', '平松乡', '0', '', '1', '0', '0', '10'),
('4693', '140000', '140700', '140723', '1', '1', '牛川乡', '0', '', '1', '0', '0', '10'),
('4694', '140000', '140700', '140723', '1', '1', '马坊乡', '0', '', '1', '0', '0', '10'),
('4695', '140000', '140700', '140723', '1', '1', '阳光占乡', '0', '', '1', '0', '0', '10'),
('4696', '140000', '140700', '140724', '1', '1', '乐平镇', '0', '', '1', '0', '0', '10'),
('4697', '140000', '140700', '140724', '1', '1', '皋落镇', '0', '', '1', '0', '0', '10'),
('4698', '140000', '140700', '140724', '1', '1', '冶头镇', '0', '', '1', '0', '0', '10'),
('4699', '140000', '140700', '140724', '1', '1', '沾尚镇', '0', '', '1', '0', '0', '10'),
('4700', '140000', '140700', '140724', '1', '1', '大寨镇', '0', '', '1', '0', '0', '10'),
('4701', '140000', '140700', '140724', '1', '1', '李家庄乡', '0', '', '1', '0', '0', '10'),
('4702', '140000', '140700', '140724', '1', '1', '界都乡', '0', '', '1', '0', '0', '10'),
('4703', '140000', '140700', '140724', '1', '1', '三都乡', '0', '', '1', '0', '0', '10'),
('4704', '140000', '140700', '140724', '1', '1', '赵壁乡', '0', '', '1', '0', '0', '10'),
('4705', '140000', '140700', '140724', '1', '1', '孔氏乡', '0', '', '1', '0', '0', '10'),
('4706', '140000', '140700', '140724', '1', '1', '阎庄乡', '0', '', '1', '0', '0', '10'),
('4707', '140000', '140700', '140724', '1', '1', '西寨乡', '0', '', '1', '0', '0', '10'),
('4708', '140000', '140700', '140725', '1', '1', '朝阳镇', '0', '', '1', '0', '0', '10'),
('4709', '140000', '140700', '140725', '1', '1', '南燕竹镇', '0', '', '1', '0', '0', '10'),
('4710', '140000', '140700', '140725', '1', '1', '宗艾镇', '0', '', '1', '0', '0', '10'),
('4711', '140000', '140700', '140725', '1', '1', '平头镇', '0', '', '1', '0', '0', '10'),
('4712', '140000', '140700', '140725', '1', '1', '松塔镇', '0', '', '1', '0', '0', '10'),
('4713', '140000', '140700', '140725', '1', '1', '西洛镇', '0', '', '1', '0', '0', '10'),
('4714', '140000', '140700', '140725', '1', '1', '尹灵芝镇', '0', '', '1', '0', '0', '10'),
('4715', '140000', '140700', '140725', '1', '1', '平舒乡', '0', '', '1', '0', '0', '10'),
('4716', '140000', '140700', '140725', '1', '1', '解愁乡', '0', '', '1', '0', '0', '10'),
('4717', '140000', '140700', '140725', '1', '1', '温家庄乡', '0', '', '1', '0', '0', '10'),
('4718', '140000', '140700', '140725', '1', '1', '景尚乡', '0', '', '1', '0', '0', '10'),
('4719', '140000', '140700', '140725', '1', '1', '上湖乡', '0', '', '1', '0', '0', '10'),
('4720', '140000', '140700', '140725', '1', '1', '羊头崖乡', '0', '', '1', '0', '0', '10'),
('4721', '140000', '140700', '140725', '1', '1', '马首乡', '0', '', '1', '0', '0', '10'),
('4722', '140000', '140700', '140726', '1', '1', '明星镇', '0', '', '1', '0', '0', '10'),
('4723', '140000', '140700', '140726', '1', '1', '胡村镇', '0', '', '1', '0', '0', '10'),
('4724', '140000', '140700', '140726', '1', '1', '范村镇', '0', '', '1', '0', '0', '10'),
('4725', '140000', '140700', '140726', '1', '1', '侯城乡', '0', '', '1', '0', '0', '10'),
('4726', '140000', '140700', '140726', '1', '1', '北汪乡', '0', '', '1', '0', '0', '10'),
('4727', '140000', '140700', '140726', '1', '1', '水秀乡', '0', '', '1', '0', '0', '10'),
('4728', '140000', '140700', '140726', '1', '1', '阳邑乡', '0', '', '1', '0', '0', '10'),
('4729', '140000', '140700', '140726', '1', '1', '小白乡', '0', '', '1', '0', '0', '10'),
('4730', '140000', '140700', '140726', '1', '1', '任村乡', '0', '', '1', '0', '0', '10'),
('4731', '140000', '140700', '140727', '1', '1', '昭馀镇', '0', '', '1', '0', '0', '10'),
('4732', '140000', '140700', '140727', '1', '1', '东观镇', '0', '', '1', '0', '0', '10'),
('4733', '140000', '140700', '140727', '1', '1', '古县镇', '0', '', '1', '0', '0', '10'),
('4734', '140000', '140700', '140727', '1', '1', '贾令镇', '0', '', '1', '0', '0', '10'),
('4735', '140000', '140700', '140727', '1', '1', '城赵镇', '0', '', '1', '0', '0', '10'),
('4736', '140000', '140700', '140727', '1', '1', '来远镇', '0', '', '1', '0', '0', '10'),
('4737', '140000', '140700', '140727', '1', '1', '西六支乡', '0', '', '1', '0', '0', '10'),
('4738', '140000', '140700', '140727', '1', '1', '峪口乡', '0', '', '1', '0', '0', '10'),
('4739', '140000', '140700', '140728', '1', '1', '古陶镇', '0', '', '1', '0', '0', '10'),
('4740', '140000', '140700', '140728', '1', '1', '段村镇', '0', '', '1', '0', '0', '10'),
('4741', '140000', '140700', '140728', '1', '1', '东泉镇', '0', '', '1', '0', '0', '10'),
('4742', '140000', '140700', '140728', '1', '1', '洪善镇', '0', '', '1', '0', '0', '10'),
('4743', '140000', '140700', '140728', '1', '1', '宁固镇', '0', '', '1', '0', '0', '10'),
('4744', '140000', '140700', '140728', '1', '1', '南政乡', '0', '', '1', '0', '0', '10'),
('4745', '140000', '140700', '140728', '1', '1', '中都乡', '0', '', '1', '0', '0', '10'),
('4746', '140000', '140700', '140728', '1', '1', '岳壁乡', '0', '', '1', '0', '0', '10'),
('4747', '140000', '140700', '140728', '1', '1', '卜宜乡', '0', '', '1', '0', '0', '10'),
('4748', '140000', '140700', '140728', '1', '1', '孟山乡', '0', '', '1', '0', '0', '10'),
('4749', '140000', '140700', '140728', '1', '1', '朱坑乡', '0', '', '1', '0', '0', '10'),
('4750', '140000', '140700', '140728', '1', '1', '襄垣乡', '0', '', '1', '0', '0', '10'),
('4751', '140000', '140700', '140728', '1', '1', '杜家庄乡', '0', '', '1', '0', '0', '10'),
('4752', '140000', '140700', '140728', '1', '1', '香乐乡', '0', '', '1', '0', '0', '10'),
('4753', '140000', '140700', '140729', '1', '1', '翠峰镇', '0', '', '1', '0', '0', '10'),
('4754', '140000', '140700', '140729', '1', '1', '静升镇', '0', '', '1', '0', '0', '10'),
('4755', '140000', '140700', '140729', '1', '1', '两渡镇', '0', '', '1', '0', '0', '10'),
('4756', '140000', '140700', '140729', '1', '1', '夏门镇', '0', '', '1', '0', '0', '10'),
('4757', '140000', '140700', '140729', '1', '1', '南关镇', '0', '', '1', '0', '0', '10'),
('4758', '140000', '140700', '140729', '1', '1', '段纯镇', '0', '', '1', '0', '0', '10'),
('4759', '140000', '140700', '140729', '1', '1', '马和乡', '0', '', '1', '0', '0', '10'),
('4760', '140000', '140700', '140729', '1', '1', '英武乡', '0', '', '1', '0', '0', '10'),
('4761', '140000', '140700', '140729', '1', '1', '王禹乡', '0', '', '1', '0', '0', '10'),
('4762', '140000', '140700', '140729', '1', '1', '坛镇乡', '0', '', '1', '0', '0', '10'),
('4763', '140000', '140700', '140729', '1', '1', '梁家焉乡', '0', '', '1', '0', '0', '10'),
('4764', '140000', '140700', '140729', '1', '1', '交口乡', '0', '', '1', '0', '0', '10'),
('4765', '140000', '140700', '140781', '1', '1', '北关街道', '0', '', '1', '0', '0', '10'),
('4766', '140000', '140700', '140781', '1', '1', '西关街道', '0', '', '1', '0', '0', '10'),
('4767', '140000', '140700', '140781', '1', '1', '东南街道', '0', '', '1', '0', '0', '10'),
('4768', '140000', '140700', '140781', '1', '1', '西南街道', '0', '', '1', '0', '0', '10'),
('4769', '140000', '140700', '140781', '1', '1', '北坛街道', '0', '', '1', '0', '0', '10'),
('4770', '140000', '140700', '140781', '1', '1', '义安镇', '0', '', '1', '0', '0', '10'),
('4771', '140000', '140700', '140781', '1', '1', '张兰镇', '0', '', '1', '0', '0', '10'),
('4772', '140000', '140700', '140781', '1', '1', '连福镇', '0', '', '1', '0', '0', '10'),
('4773', '140000', '140700', '140781', '1', '1', '洪山镇', '0', '', '1', '0', '0', '10'),
('4774', '140000', '140700', '140781', '1', '1', '龙凤镇', '0', '', '1', '0', '0', '10'),
('4775', '140000', '140700', '140781', '1', '1', '绵山镇', '0', '', '1', '0', '0', '10'),
('4776', '140000', '140700', '140781', '1', '1', '义棠镇', '0', '', '1', '0', '0', '10'),
('4777', '140000', '140700', '140781', '1', '1', '城关乡', '0', '', '1', '0', '0', '10'),
('4778', '140000', '140700', '140781', '1', '1', '宋古乡', '0', '', '1', '0', '0', '10'),
('4779', '140000', '140700', '140781', '1', '1', '三佳乡', '0', '', '1', '0', '0', '10'),
('4780', '140000', '140700', '140781', '1', '1', '山西省种羊场', '0', '', '1', '0', '0', '10'),
('4781', '140000', '140800', '140802', '1', '1', '中城街道', '0', '', '1', '0', '0', '10'),
('4782', '140000', '140800', '140802', '1', '1', '东城街道', '0', '', '1', '0', '0', '10'),
('4783', '140000', '140800', '140802', '1', '1', '西城街道', '0', '', '1', '0', '0', '10'),
('4784', '140000', '140800', '140802', '1', '1', '南城街道', '0', '', '1', '0', '0', '10'),
('4785', '140000', '140800', '140802', '1', '1', '北城街道', '0', '', '1', '0', '0', '10'),
('4786', '140000', '140800', '140802', '1', '1', '安邑街道', '0', '', '1', '0', '0', '10'),
('4787', '140000', '140800', '140802', '1', '1', '大渠街道', '0', '', '1', '0', '0', '10'),
('4788', '140000', '140800', '140802', '1', '1', '姚孟街道', '0', '', '1', '0', '0', '10'),
('4789', '140000', '140800', '140802', '1', '1', '解州镇政府', '0', '', '1', '0', '0', '10'),
('4790', '140000', '140800', '140802', '1', '1', '龙居镇政府', '0', '', '1', '0', '0', '10'),
('4791', '140000', '140800', '140802', '1', '1', '北相镇政府', '0', '', '1', '0', '0', '10'),
('4792', '140000', '140800', '140802', '1', '1', '泓芝驿镇政府', '0', '', '1', '0', '0', '10'),
('4793', '140000', '140800', '140802', '1', '1', '三路里镇政府', '0', '', '1', '0', '0', '10'),
('4794', '140000', '140800', '140802', '1', '1', '陶村镇政府', '0', '', '1', '0', '0', '10'),
('4795', '140000', '140800', '140802', '1', '1', '东郭镇政府', '0', '', '1', '0', '0', '10'),
('4796', '140000', '140800', '140802', '1', '1', '席张乡政府', '0', '', '1', '0', '0', '10'),
('4797', '140000', '140800', '140802', '1', '1', '金井乡政府', '0', '', '1', '0', '0', '10'),
('4798', '140000', '140800', '140802', '1', '1', '王范乡政府', '0', '', '1', '0', '0', '10'),
('4799', '140000', '140800', '140802', '1', '1', '冯村乡政府', '0', '', '1', '0', '0', '10'),
('4800', '140000', '140800', '140802', '1', '1', '上郭乡政府', '0', '', '1', '0', '0', '10'),
('4801', '140000', '140800', '140802', '1', '1', '上王乡政府', '0', '', '1', '0', '0', '10'),
('4802', '140000', '140800', '140802', '1', '1', '禹都经济技术开发区', '0', '', '1', '0', '0', '10'),
('4803', '140000', '140800', '140821', '1', '1', '猗氏镇', '0', '', '1', '0', '0', '10'),
('4804', '140000', '140800', '140821', '1', '1', '嵋阳镇', '0', '', '1', '0', '0', '10'),
('4805', '140000', '140800', '140821', '1', '1', '临晋镇', '0', '', '1', '0', '0', '10'),
('4806', '140000', '140800', '140821', '1', '1', '七级镇', '0', '', '1', '0', '0', '10'),
('4807', '140000', '140800', '140821', '1', '1', '东张镇', '0', '', '1', '0', '0', '10'),
('4808', '140000', '140800', '140821', '1', '1', '孙吉镇', '0', '', '1', '0', '0', '10'),
('4809', '140000', '140800', '140821', '1', '1', '三管镇', '0', '', '1', '0', '0', '10'),
('4810', '140000', '140800', '140821', '1', '1', '耽子镇', '0', '', '1', '0', '0', '10'),
('4811', '140000', '140800', '140821', '1', '1', '楚候乡', '0', '', '1', '0', '0', '10'),
('4812', '140000', '140800', '140821', '1', '1', '庙上乡', '0', '', '1', '0', '0', '10'),
('4813', '140000', '140800', '140821', '1', '1', '角杯乡', '0', '', '1', '0', '0', '10'),
('4814', '140000', '140800', '140821', '1', '1', '北辛乡', '0', '', '1', '0', '0', '10'),
('4815', '140000', '140800', '140821', '1', '1', '北景乡', '0', '', '1', '0', '0', '10'),
('4816', '140000', '140800', '140821', '1', '1', '牛杜工贸区', '0', '', '1', '0', '0', '10'),
('4817', '140000', '140800', '140821', '1', '1', '卓里工贸区', '0', '', '1', '0', '0', '10'),
('4818', '140000', '140800', '140821', '1', '1', '闫家庄工贸区', '0', '', '1', '0', '0', '10'),
('4819', '140000', '140800', '140822', '1', '1', '解店镇', '0', '', '1', '0', '0', '10'),
('4820', '140000', '140800', '140822', '1', '1', '通化镇', '0', '', '1', '0', '0', '10'),
('4821', '140000', '140800', '140822', '1', '1', '汉薛镇', '0', '', '1', '0', '0', '10'),
('4822', '140000', '140800', '140822', '1', '1', '荣河镇', '0', '', '1', '0', '0', '10'),
('4823', '140000', '140800', '140822', '1', '1', '万泉乡', '0', '', '1', '0', '0', '10'),
('4824', '140000', '140800', '140822', '1', '1', '里望乡', '0', '', '1', '0', '0', '10'),
('4825', '140000', '140800', '140822', '1', '1', '西村乡', '0', '', '1', '0', '0', '10'),
('4826', '140000', '140800', '140822', '1', '1', '南张乡', '0', '', '1', '0', '0', '10'),
('4827', '140000', '140800', '140822', '1', '1', '高村乡', '0', '', '1', '0', '0', '10'),
('4828', '140000', '140800', '140822', '1', '1', '皇甫乡', '0', '', '1', '0', '0', '10'),
('4829', '140000', '140800', '140822', '1', '1', '贾村乡', '0', '', '1', '0', '0', '10'),
('4830', '140000', '140800', '140822', '1', '1', '王显乡', '0', '', '1', '0', '0', '10'),
('4831', '140000', '140800', '140822', '1', '1', '光华乡', '0', '', '1', '0', '0', '10'),
('4832', '140000', '140800', '140822', '1', '1', '裴庄乡', '0', '', '1', '0', '0', '10'),
('4833', '140000', '140800', '140823', '1', '1', '桐城镇', '0', '', '1', '0', '0', '10'),
('4834', '140000', '140800', '140823', '1', '1', '郭家庄镇', '0', '', '1', '0', '0', '10'),
('4835', '140000', '140800', '140823', '1', '1', '凹底镇', '0', '', '1', '0', '0', '10'),
('4836', '140000', '140800', '140823', '1', '1', '薛店镇', '0', '', '1', '0', '0', '10'),
('4837', '140000', '140800', '140823', '1', '1', '东镇镇', '0', '', '1', '0', '0', '10'),
('4838', '140000', '140800', '140823', '1', '1', '礼元镇', '0', '', '1', '0', '0', '10'),
('4839', '140000', '140800', '140823', '1', '1', '河底镇', '0', '', '1', '0', '0', '10'),
('4840', '140000', '140800', '140823', '1', '1', '神柏乡', '0', '', '1', '0', '0', '10'),
('4841', '140000', '140800', '140823', '1', '1', '阳隅乡', '0', '', '1', '0', '0', '10'),
('4842', '140000', '140800', '140823', '1', '1', '侯村乡', '0', '', '1', '0', '0', '10'),
('4843', '140000', '140800', '140823', '1', '1', '裴社乡', '0', '', '1', '0', '0', '10'),
('4844', '140000', '140800', '140823', '1', '1', '后宫乡', '0', '', '1', '0', '0', '10'),
('4845', '140000', '140800', '140823', '1', '1', '石门乡', '0', '', '1', '0', '0', '10'),
('4846', '140000', '140800', '140824', '1', '1', '稷峰镇', '0', '', '1', '0', '0', '10'),
('4847', '140000', '140800', '140824', '1', '1', '西社镇', '0', '', '1', '0', '0', '10'),
('4848', '140000', '140800', '140824', '1', '1', '化峪镇', '0', '', '1', '0', '0', '10'),
('4849', '140000', '140800', '140824', '1', '1', '翟店镇', '0', '', '1', '0', '0', '10'),
('4850', '140000', '140800', '140824', '1', '1', '清河镇', '0', '', '1', '0', '0', '10'),
('4851', '140000', '140800', '140824', '1', '1', '蔡村乡', '0', '', '1', '0', '0', '10'),
('4852', '140000', '140800', '140824', '1', '1', '太阳乡', '0', '', '1', '0', '0', '10'),
('4853', '140000', '140800', '140825', '1', '1', '龙兴镇', '0', '', '1', '0', '0', '10'),
('4854', '140000', '140800', '140825', '1', '1', '三泉镇', '0', '', '1', '0', '0', '10'),
('4855', '140000', '140800', '140825', '1', '1', '泽掌镇', '0', '', '1', '0', '0', '10'),
('4856', '140000', '140800', '140825', '1', '1', '北张镇', '0', '', '1', '0', '0', '10'),
('4857', '140000', '140800', '140825', '1', '1', '横桥镇', '0', '', '1', '0', '0', '10'),
('4858', '140000', '140800', '140825', '1', '1', '万安镇', '0', '', '1', '0', '0', '10'),
('4859', '140000', '140800', '140825', '1', '1', '阳王镇', '0', '', '1', '0', '0', '10'),
('4860', '140000', '140800', '140825', '1', '1', '古交乡', '0', '', '1', '0', '0', '10'),
('4861', '140000', '140800', '140826', '1', '1', '古绛镇', '0', '', '1', '0', '0', '10'),
('4862', '140000', '140800', '140826', '1', '1', '横水镇', '0', '', '1', '0', '0', '10'),
('4863', '140000', '140800', '140826', '1', '1', '陈村镇', '0', '', '1', '0', '0', '10'),
('4864', '140000', '140800', '140826', '1', '1', '卫庄镇', '0', '', '1', '0', '0', '10'),
('4865', '140000', '140800', '140826', '1', '1', '么里镇', '0', '', '1', '0', '0', '10'),
('4866', '140000', '140800', '140826', '1', '1', '南樊镇', '0', '', '1', '0', '0', '10'),
('4867', '140000', '140800', '140826', '1', '1', '安峪镇', '0', '', '1', '0', '0', '10'),
('4868', '140000', '140800', '140826', '1', '1', '大交镇', '0', '', '1', '0', '0', '10'),
('4869', '140000', '140800', '140826', '1', '1', '郝庄乡', '0', '', '1', '0', '0', '10'),
('4870', '140000', '140800', '140826', '1', '1', '冷口乡', '0', '', '1', '0', '0', '10'),
('4871', '140000', '140800', '140827', '1', '1', '新城镇', '0', '', '1', '0', '0', '10'),
('4872', '140000', '140800', '140827', '1', '1', '历山镇', '0', '', '1', '0', '0', '10'),
('4873', '140000', '140800', '140827', '1', '1', '古城镇', '0', '', '1', '0', '0', '10'),
('4874', '140000', '140800', '140827', '1', '1', '王茅镇', '0', '', '1', '0', '0', '10'),
('4875', '140000', '140800', '140827', '1', '1', '毛家镇', '0', '', '1', '0', '0', '10'),
('4876', '140000', '140800', '140827', '1', '1', '蒲掌乡', '0', '', '1', '0', '0', '10'),
('4877', '140000', '140800', '140827', '1', '1', '英言乡', '0', '', '1', '0', '0', '10'),
('4878', '140000', '140800', '140827', '1', '1', '解峪乡', '0', '', '1', '0', '0', '10'),
('4879', '140000', '140800', '140827', '1', '1', '华峰乡', '0', '', '1', '0', '0', '10'),
('4880', '140000', '140800', '140827', '1', '1', '长直乡', '0', '', '1', '0', '0', '10'),
('4881', '140000', '140800', '140827', '1', '1', '皋落乡', '0', '', '1', '0', '0', '10'),
('4882', '140000', '140800', '140828', '1', '1', '瑶峰镇', '0', '', '1', '0', '0', '10'),
('4883', '140000', '140800', '140828', '1', '1', '庙前镇', '0', '', '1', '0', '0', '10'),
('4884', '140000', '140800', '140828', '1', '1', '裴介镇', '0', '', '1', '0', '0', '10'),
('4885', '140000', '140800', '140828', '1', '1', '水头镇', '0', '', '1', '0', '0', '10'),
('4886', '140000', '140800', '140828', '1', '1', '埝掌镇', '0', '', '1', '0', '0', '10'),
('4887', '140000', '140800', '140828', '1', '1', '泗交镇', '0', '', '1', '0', '0', '10'),
('4888', '140000', '140800', '140828', '1', '1', '尉郭乡', '0', '', '1', '0', '0', '10'),
('4889', '140000', '140800', '140828', '1', '1', '禹王乡', '0', '', '1', '0', '0', '10'),
('4890', '140000', '140800', '140828', '1', '1', '胡张乡', '0', '', '1', '0', '0', '10'),
('4891', '140000', '140800', '140828', '1', '1', '南大里乡', '0', '', '1', '0', '0', '10'),
('4892', '140000', '140800', '140828', '1', '1', '祁家河乡', '0', '', '1', '0', '0', '10'),
('4893', '140000', '140800', '140829', '1', '1', '圣人涧镇', '0', '', '1', '0', '0', '10'),
('4894', '140000', '140800', '140829', '1', '1', '常乐镇', '0', '', '1', '0', '0', '10'),
('4895', '140000', '140800', '140829', '1', '1', '张店镇', '0', '', '1', '0', '0', '10'),
('4896', '140000', '140800', '140829', '1', '1', '张村镇', '0', '', '1', '0', '0', '10'),
('4897', '140000', '140800', '140829', '1', '1', '曹川镇', '0', '', '1', '0', '0', '10'),
('4898', '140000', '140800', '140829', '1', '1', '三门镇', '0', '', '1', '0', '0', '10'),
('4899', '140000', '140800', '140829', '1', '1', '洪池乡', '0', '', '1', '0', '0', '10'),
('4900', '140000', '140800', '140829', '1', '1', '杜马乡', '0', '', '1', '0', '0', '10'),
('4901', '140000', '140800', '140829', '1', '1', '部官乡', '0', '', '1', '0', '0', '10'),
('4902', '140000', '140800', '140829', '1', '1', '坡底乡', '0', '', '1', '0', '0', '10'),
('4903', '140000', '140800', '140830', '1', '1', '古巍镇', '0', '', '1', '0', '0', '10'),
('4904', '140000', '140800', '140830', '1', '1', '风陵渡镇', '0', '', '1', '0', '0', '10'),
('4905', '140000', '140800', '140830', '1', '1', '陌南镇', '0', '', '1', '0', '0', '10'),
('4906', '140000', '140800', '140830', '1', '1', '西陌镇', '0', '', '1', '0', '0', '10'),
('4907', '140000', '140800', '140830', '1', '1', '永乐镇', '0', '', '1', '0', '0', '10'),
('4908', '140000', '140800', '140830', '1', '1', '大王镇', '0', '', '1', '0', '0', '10'),
('4909', '140000', '140800', '140830', '1', '1', '阳城镇', '0', '', '1', '0', '0', '10'),
('4910', '140000', '140800', '140830', '1', '1', '东垆乡', '0', '', '1', '0', '0', '10'),
('4911', '140000', '140800', '140830', '1', '1', '南卫乡', '0', '', '1', '0', '0', '10'),
('4912', '140000', '140800', '140830', '1', '1', '学张乡', '0', '', '1', '0', '0', '10'),
('4913', '140000', '140800', '140881', '1', '1', '城西街道', '0', '', '1', '0', '0', '10'),
('4914', '140000', '140800', '140881', '1', '1', '城北街道', '0', '', '1', '0', '0', '10'),
('4915', '140000', '140800', '140881', '1', '1', '城东街道', '0', '', '1', '0', '0', '10'),
('4916', '140000', '140800', '140881', '1', '1', '于乡镇', '0', '', '1', '0', '0', '10'),
('4917', '140000', '140800', '140881', '1', '1', '卿头镇', '0', '', '1', '0', '0', '10'),
('4918', '140000', '140800', '140881', '1', '1', '开张镇', '0', '', '1', '0', '0', '10'),
('4919', '140000', '140800', '140881', '1', '1', '栲栳镇', '0', '', '1', '0', '0', '10'),
('4920', '140000', '140800', '140881', '1', '1', '蒲州镇', '0', '', '1', '0', '0', '10'),
('4921', '140000', '140800', '140881', '1', '1', '韩阳镇', '0', '', '1', '0', '0', '10'),
('4922', '140000', '140800', '140881', '1', '1', '张营镇', '0', '', '1', '0', '0', '10'),
('4923', '140000', '140800', '140881', '1', '1', '农场虚拟区', '0', '', '1', '0', '0', '10'),
('4924', '140000', '140800', '140882', '1', '1', '城区街道', '0', '', '1', '0', '0', '10'),
('4925', '140000', '140800', '140882', '1', '1', '清涧街道', '0', '', '1', '0', '0', '10'),
('4926', '140000', '140800', '140882', '1', '1', '樊村镇', '0', '', '1', '0', '0', '10'),
('4927', '140000', '140800', '140882', '1', '1', '僧楼镇', '0', '', '1', '0', '0', '10'),
('4928', '140000', '140800', '140882', '1', '1', '小梁乡', '0', '', '1', '0', '0', '10'),
('4929', '140000', '140800', '140882', '1', '1', '柴家乡', '0', '', '1', '0', '0', '10'),
('4930', '140000', '140800', '140882', '1', '1', '赵家庄乡', '0', '', '1', '0', '0', '10'),
('4931', '140000', '140800', '140882', '1', '1', '下化乡', '0', '', '1', '0', '0', '10'),
('4932', '140000', '140800', '140882', '1', '1', '阳村乡', '0', '', '1', '0', '0', '10'),
('4933', '140000', '140800', '140882', '1', '1', '山西铝厂虚拟镇', '0', '', '1', '0', '0', '10'),
('4934', '140000', '140900', '140902', '1', '1', '南城街道', '0', '', '1', '0', '0', '10'),
('4935', '140000', '140900', '140902', '1', '1', '长征街街道', '0', '', '1', '0', '0', '10'),
('4936', '140000', '140900', '140902', '1', '1', '新建路街道', '0', '', '1', '0', '0', '10'),
('4937', '140000', '140900', '140902', '1', '1', '播明镇', '0', '', '1', '0', '0', '10'),
('4938', '140000', '140900', '140902', '1', '1', '奇村镇', '0', '', '1', '0', '0', '10'),
('4939', '140000', '140900', '140902', '1', '1', '三交镇', '0', '', '1', '0', '0', '10'),
('4940', '140000', '140900', '140902', '1', '1', '庄磨镇', '0', '', '1', '0', '0', '10'),
('4941', '140000', '140900', '140902', '1', '1', '豆罗镇', '0', '', '1', '0', '0', '10'),
('4942', '140000', '140900', '140902', '1', '1', '董村镇', '0', '', '1', '0', '0', '10'),
('4943', '140000', '140900', '140902', '1', '1', '曹张乡', '0', '', '1', '0', '0', '10'),
('4944', '140000', '140900', '140902', '1', '1', '高城乡', '0', '', '1', '0', '0', '10'),
('4945', '140000', '140900', '140902', '1', '1', '秦城乡', '0', '', '1', '0', '0', '10'),
('4946', '140000', '140900', '140902', '1', '1', '解原乡', '0', '', '1', '0', '0', '10'),
('4947', '140000', '140900', '140902', '1', '1', '合索乡', '0', '', '1', '0', '0', '10'),
('4948', '140000', '140900', '140902', '1', '1', '阳坡乡', '0', '', '1', '0', '0', '10'),
('4949', '140000', '140900', '140902', '1', '1', '兰村乡', '0', '', '1', '0', '0', '10'),
('4950', '140000', '140900', '140902', '1', '1', '紫岩乡', '0', '', '1', '0', '0', '10'),
('4951', '140000', '140900', '140902', '1', '1', '西张乡', '0', '', '1', '0', '0', '10'),
('4952', '140000', '140900', '140902', '1', '1', '东楼乡', '0', '', '1', '0', '0', '10'),
('4953', '140000', '140900', '140902', '1', '1', '北义井乡', '0', '', '1', '0', '0', '10'),
('4954', '140000', '140900', '140921', '1', '1', '晋昌镇', '0', '', '1', '0', '0', '10'),
('4955', '140000', '140900', '140921', '1', '1', '河边镇', '0', '', '1', '0', '0', '10'),
('4956', '140000', '140900', '140921', '1', '1', '宏道镇', '0', '', '1', '0', '0', '10'),
('4957', '140000', '140900', '140921', '1', '1', '杨芳乡', '0', '', '1', '0', '0', '10'),
('4958', '140000', '140900', '140921', '1', '1', '南王乡', '0', '', '1', '0', '0', '10'),
('4959', '140000', '140900', '140921', '1', '1', '蒋村乡', '0', '', '1', '0', '0', '10'),
('4960', '140000', '140900', '140921', '1', '1', '神山乡', '0', '', '1', '0', '0', '10'),
('4961', '140000', '140900', '140921', '1', '1', '季庄乡', '0', '', '1', '0', '0', '10'),
('4962', '140000', '140900', '140921', '1', '1', '受录乡', '0', '', '1', '0', '0', '10'),
('4963', '140000', '140900', '140922', '1', '1', '台城镇', '0', '', '1', '0', '0', '10'),
('4964', '140000', '140900', '140922', '1', '1', '台怀镇', '0', '', '1', '0', '0', '10'),
('4965', '140000', '140900', '140922', '1', '1', '耿镇镇', '0', '', '1', '0', '0', '10'),
('4966', '140000', '140900', '140922', '1', '1', '豆村镇', '0', '', '1', '0', '0', '10'),
('4967', '140000', '140900', '140922', '1', '1', '白家庄镇', '0', '', '1', '0', '0', '10'),
('4968', '140000', '140900', '140922', '1', '1', '东冶镇', '0', '', '1', '0', '0', '10'),
('4969', '140000', '140900', '140922', '1', '1', '沟南乡', '0', '', '1', '0', '0', '10'),
('4970', '140000', '140900', '140922', '1', '1', '东雷乡', '0', '', '1', '0', '0', '10'),
('4971', '140000', '140900', '140922', '1', '1', '高洪口乡', '0', '', '1', '0', '0', '10'),
('4972', '140000', '140900', '140922', '1', '1', '门限石乡', '0', '', '1', '0', '0', '10'),
('4973', '140000', '140900', '140922', '1', '1', '陈家庄乡', '0', '', '1', '0', '0', '10'),
('4974', '140000', '140900', '140922', '1', '1', '建安乡', '0', '', '1', '0', '0', '10'),
('4975', '140000', '140900', '140922', '1', '1', '神西乡', '0', '', '1', '0', '0', '10'),
('4976', '140000', '140900', '140922', '1', '1', '蒋坊乡', '0', '', '1', '0', '0', '10'),
('4977', '140000', '140900', '140922', '1', '1', '灵境乡', '0', '', '1', '0', '0', '10'),
('4978', '140000', '140900', '140922', '1', '1', '阳白乡', '0', '', '1', '0', '0', '10'),
('4979', '140000', '140900', '140922', '1', '1', '茹村乡', '0', '', '1', '0', '0', '10'),
('4980', '140000', '140900', '140922', '1', '1', '石咀乡', '0', '', '1', '0', '0', '10');
INSERT INTO `wst_communitys` VALUES ('4981', '140000', '140900', '140922', '1', '1', '金岗库乡', '0', '', '1', '0', '0', '10'),
('4982', '140000', '140900', '140923', '1', '1', '上馆镇', '0', '', '1', '0', '0', '10'),
('4983', '140000', '140900', '140923', '1', '1', '阳明堡镇', '0', '', '1', '0', '0', '10'),
('4984', '140000', '140900', '140923', '1', '1', '峨口镇', '0', '', '1', '0', '0', '10'),
('4985', '140000', '140900', '140923', '1', '1', '聂营镇', '0', '', '1', '0', '0', '10'),
('4986', '140000', '140900', '140923', '1', '1', '枣林镇', '0', '', '1', '0', '0', '10'),
('4987', '140000', '140900', '140923', '1', '1', '滩上镇', '0', '', '1', '0', '0', '10'),
('4988', '140000', '140900', '140923', '1', '1', '新高乡', '0', '', '1', '0', '0', '10'),
('4989', '140000', '140900', '140923', '1', '1', '峪口乡', '0', '', '1', '0', '0', '10'),
('4990', '140000', '140900', '140923', '1', '1', '磨坊乡', '0', '', '1', '0', '0', '10'),
('4991', '140000', '140900', '140923', '1', '1', '胡峪乡', '0', '', '1', '0', '0', '10'),
('4992', '140000', '140900', '140923', '1', '1', '雁门关乡', '0', '', '1', '0', '0', '10'),
('4993', '140000', '140900', '140924', '1', '1', '繁城镇', '0', '', '1', '0', '0', '10'),
('4994', '140000', '140900', '140924', '1', '1', '砂河镇', '0', '', '1', '0', '0', '10'),
('4995', '140000', '140900', '140924', '1', '1', '大营镇', '0', '', '1', '0', '0', '10'),
('4996', '140000', '140900', '140924', '1', '1', '下茹越乡', '0', '', '1', '0', '0', '10'),
('4997', '140000', '140900', '140924', '1', '1', '杏园乡', '0', '', '1', '0', '0', '10'),
('4998', '140000', '140900', '140924', '1', '1', '光裕堡乡', '0', '', '1', '0', '0', '10'),
('4999', '140000', '140900', '140924', '1', '1', '集义庄乡', '0', '', '1', '0', '0', '10'),
('5000', '140000', '140900', '140924', '1', '1', '东山乡', '0', '', '1', '0', '0', '10'),
('5001', '140000', '140900', '140924', '1', '1', '金山铺乡', '0', '', '1', '0', '0', '10'),
('5002', '140000', '140900', '140924', '1', '1', '柏家庄乡', '0', '', '1', '0', '0', '10'),
('5003', '140000', '140900', '140924', '1', '1', '横涧乡', '0', '', '1', '0', '0', '10'),
('5004', '140000', '140900', '140924', '1', '1', '神堂堡乡', '0', '', '1', '0', '0', '10'),
('5005', '140000', '140900', '140924', '1', '1', '岩头乡', '0', '', '1', '0', '0', '10'),
('5006', '140000', '140900', '140925', '1', '1', '街道', '0', '', '1', '0', '0', '10'),
('5007', '140000', '140900', '140925', '1', '1', '凤凰镇', '0', '', '1', '0', '0', '10'),
('5008', '140000', '140900', '140925', '1', '1', '阳方口镇', '0', '', '1', '0', '0', '10'),
('5009', '140000', '140900', '140925', '1', '1', '东寨镇', '0', '', '1', '0', '0', '10'),
('5010', '140000', '140900', '140925', '1', '1', '石家庄镇', '0', '', '1', '0', '0', '10'),
('5011', '140000', '140900', '140925', '1', '1', '薛家洼乡', '0', '', '1', '0', '0', '10'),
('5012', '140000', '140900', '140925', '1', '1', '余庄乡', '0', '', '1', '0', '0', '10'),
('5013', '140000', '140900', '140925', '1', '1', '涔山乡', '0', '', '1', '0', '0', '10'),
('5014', '140000', '140900', '140925', '1', '1', '化北屯乡', '0', '', '1', '0', '0', '10'),
('5015', '140000', '140900', '140925', '1', '1', '西马坊乡', '0', '', '1', '0', '0', '10'),
('5016', '140000', '140900', '140925', '1', '1', '新堡乡', '0', '', '1', '0', '0', '10'),
('5017', '140000', '140900', '140925', '1', '1', '迭台寺乡', '0', '', '1', '0', '0', '10'),
('5018', '140000', '140900', '140925', '1', '1', '圪廖乡', '0', '', '1', '0', '0', '10'),
('5019', '140000', '140900', '140925', '1', '1', '怀道乡', '0', '', '1', '0', '0', '10'),
('5020', '140000', '140900', '140925', '1', '1', '东马坊乡', '0', '', '1', '0', '0', '10'),
('5021', '140000', '140900', '140925', '1', '1', '阳方口煤矿生活区', '0', '', '1', '0', '0', '10'),
('5022', '140000', '140900', '140926', '1', '1', '鹅城镇', '0', '', '1', '0', '0', '10'),
('5023', '140000', '140900', '140926', '1', '1', '杜家村镇', '0', '', '1', '0', '0', '10'),
('5024', '140000', '140900', '140926', '1', '1', '康家会镇', '0', '', '1', '0', '0', '10'),
('5025', '140000', '140900', '140926', '1', '1', '丰润镇', '0', '', '1', '0', '0', '10'),
('5026', '140000', '140900', '140926', '1', '1', '堂尔上乡', '0', '', '1', '0', '0', '10'),
('5027', '140000', '140900', '140926', '1', '1', '中庄乡', '0', '', '1', '0', '0', '10'),
('5028', '140000', '140900', '140926', '1', '1', '双路乡', '0', '', '1', '0', '0', '10'),
('5029', '140000', '140900', '140926', '1', '1', '段家寨乡', '0', '', '1', '0', '0', '10'),
('5030', '140000', '140900', '140926', '1', '1', '辛村乡', '0', '', '1', '0', '0', '10'),
('5031', '140000', '140900', '140926', '1', '1', '王村乡', '0', '', '1', '0', '0', '10'),
('5032', '140000', '140900', '140926', '1', '1', '神峪沟乡', '0', '', '1', '0', '0', '10'),
('5033', '140000', '140900', '140926', '1', '1', '娘子神乡', '0', '', '1', '0', '0', '10'),
('5034', '140000', '140900', '140926', '1', '1', '娑婆乡', '0', '', '1', '0', '0', '10'),
('5035', '140000', '140900', '140926', '1', '1', '赤泥洼乡', '0', '', '1', '0', '0', '10'),
('5036', '140000', '140900', '140927', '1', '1', '龙泉镇', '0', '', '1', '0', '0', '10'),
('5037', '140000', '140900', '140927', '1', '1', '义井镇', '0', '', '1', '0', '0', '10'),
('5038', '140000', '140900', '140927', '1', '1', '八角镇', '0', '', '1', '0', '0', '10'),
('5039', '140000', '140900', '140927', '1', '1', '东湖乡', '0', '', '1', '0', '0', '10'),
('5040', '140000', '140900', '140927', '1', '1', '太平庄乡', '0', '', '1', '0', '0', '10'),
('5041', '140000', '140900', '140927', '1', '1', '虎北乡', '0', '', '1', '0', '0', '10'),
('5042', '140000', '140900', '140927', '1', '1', '贺职乡', '0', '', '1', '0', '0', '10'),
('5043', '140000', '140900', '140927', '1', '1', '长畛乡', '0', '', '1', '0', '0', '10'),
('5044', '140000', '140900', '140927', '1', '1', '烈堡乡', '0', '', '1', '0', '0', '10'),
('5045', '140000', '140900', '140927', '1', '1', '大严备乡', '0', '', '1', '0', '0', '10'),
('5046', '140000', '140900', '140928', '1', '1', '砚城镇', '0', '', '1', '0', '0', '10'),
('5047', '140000', '140900', '140928', '1', '1', '小河头镇', '0', '', '1', '0', '0', '10'),
('5048', '140000', '140900', '140928', '1', '1', '三岔镇', '0', '', '1', '0', '0', '10'),
('5049', '140000', '140900', '140928', '1', '1', '前所乡', '0', '', '1', '0', '0', '10'),
('5050', '140000', '140900', '140928', '1', '1', '李家坪乡', '0', '', '1', '0', '0', '10'),
('5051', '140000', '140900', '140928', '1', '1', '孙家坪乡', '0', '', '1', '0', '0', '10'),
('5052', '140000', '140900', '140928', '1', '1', '梁家坪乡', '0', '', '1', '0', '0', '10'),
('5053', '140000', '140900', '140928', '1', '1', '胡会乡', '0', '', '1', '0', '0', '10'),
('5054', '140000', '140900', '140928', '1', '1', '新寨乡', '0', '', '1', '0', '0', '10'),
('5055', '140000', '140900', '140928', '1', '1', '韩家楼乡', '0', '', '1', '0', '0', '10'),
('5056', '140000', '140900', '140928', '1', '1', '东秀庄乡', '0', '', '1', '0', '0', '10'),
('5057', '140000', '140900', '140928', '1', '1', '杏岭子乡', '0', '', '1', '0', '0', '10'),
('5058', '140000', '140900', '140929', '1', '1', '岚漪镇', '0', '', '1', '0', '0', '10'),
('5059', '140000', '140900', '140929', '1', '1', '三井镇', '0', '', '1', '0', '0', '10'),
('5060', '140000', '140900', '140929', '1', '1', '神堂坪乡', '0', '', '1', '0', '0', '10'),
('5061', '140000', '140900', '140929', '1', '1', '高家会乡', '0', '', '1', '0', '0', '10'),
('5062', '140000', '140900', '140929', '1', '1', '李家沟乡', '0', '', '1', '0', '0', '10'),
('5063', '140000', '140900', '140929', '1', '1', '水峪贯乡', '0', '', '1', '0', '0', '10'),
('5064', '140000', '140900', '140929', '1', '1', '西豹峪乡', '0', '', '1', '0', '0', '10'),
('5065', '140000', '140900', '140929', '1', '1', '温泉乡', '0', '', '1', '0', '0', '10'),
('5066', '140000', '140900', '140929', '1', '1', '阳坪乡', '0', '', '1', '0', '0', '10'),
('5067', '140000', '140900', '140929', '1', '1', '大涧乡', '0', '', '1', '0', '0', '10'),
('5068', '140000', '140900', '140929', '1', '1', '宋家沟乡', '0', '', '1', '0', '0', '10'),
('5069', '140000', '140900', '140929', '1', '1', '王家岔乡', '0', '', '1', '0', '0', '10'),
('5070', '140000', '140900', '140930', '1', '1', '文笔镇', '0', '', '1', '0', '0', '10'),
('5071', '140000', '140900', '140930', '1', '1', '楼子营镇', '0', '', '1', '0', '0', '10'),
('5072', '140000', '140900', '140930', '1', '1', '刘家塔镇', '0', '', '1', '0', '0', '10'),
('5073', '140000', '140900', '140930', '1', '1', '巡镇镇', '0', '', '1', '0', '0', '10'),
('5074', '140000', '140900', '140930', '1', '1', '鹿固乡', '0', '', '1', '0', '0', '10'),
('5075', '140000', '140900', '140930', '1', '1', '前川乡', '0', '', '1', '0', '0', '10'),
('5076', '140000', '140900', '140930', '1', '1', '单寨乡', '0', '', '1', '0', '0', '10'),
('5077', '140000', '140900', '140930', '1', '1', '土沟乡', '0', '', '1', '0', '0', '10'),
('5078', '140000', '140900', '140930', '1', '1', '旧县乡', '0', '', '1', '0', '0', '10'),
('5079', '140000', '140900', '140930', '1', '1', '沙坪乡', '0', '', '1', '0', '0', '10'),
('5080', '140000', '140900', '140930', '1', '1', '社梁乡', '0', '', '1', '0', '0', '10'),
('5081', '140000', '140900', '140930', '1', '1', '沙泉乡', '0', '', '1', '0', '0', '10'),
('5082', '140000', '140900', '140930', '1', '1', '赵家沟乡', '0', '', '1', '0', '0', '10'),
('5083', '140000', '140900', '140931', '1', '1', '东关镇', '0', '', '1', '0', '0', '10'),
('5084', '140000', '140900', '140931', '1', '1', '义门镇', '0', '', '1', '0', '0', '10'),
('5085', '140000', '140900', '140931', '1', '1', '桥头镇', '0', '', '1', '0', '0', '10'),
('5086', '140000', '140900', '140931', '1', '1', '杨家湾镇', '0', '', '1', '0', '0', '10'),
('5087', '140000', '140900', '140931', '1', '1', '腰庄乡', '0', '', '1', '0', '0', '10'),
('5088', '140000', '140900', '140931', '1', '1', '韩家川乡', '0', '', '1', '0', '0', '10'),
('5089', '140000', '140900', '140931', '1', '1', '林遮峪乡', '0', '', '1', '0', '0', '10'),
('5090', '140000', '140900', '140931', '1', '1', '冯家川乡', '0', '', '1', '0', '0', '10'),
('5091', '140000', '140900', '140931', '1', '1', '土崖塔乡', '0', '', '1', '0', '0', '10'),
('5092', '140000', '140900', '140931', '1', '1', '孙家沟乡', '0', '', '1', '0', '0', '10'),
('5093', '140000', '140900', '140931', '1', '1', '窑洼乡', '0', '', '1', '0', '0', '10'),
('5094', '140000', '140900', '140931', '1', '1', '尧圪台乡', '0', '', '1', '0', '0', '10'),
('5095', '140000', '140900', '140931', '1', '1', '南河沟乡', '0', '', '1', '0', '0', '10'),
('5096', '140000', '140900', '140932', '1', '1', '新关镇', '0', '', '1', '0', '0', '10'),
('5097', '140000', '140900', '140932', '1', '1', '天峰坪镇', '0', '', '1', '0', '0', '10'),
('5098', '140000', '140900', '140932', '1', '1', '老营镇', '0', '', '1', '0', '0', '10'),
('5099', '140000', '140900', '140932', '1', '1', '万家寨镇', '0', '', '1', '0', '0', '10'),
('5100', '140000', '140900', '140932', '1', '1', '窑头乡', '0', '', '1', '0', '0', '10'),
('5101', '140000', '140900', '140932', '1', '1', '楼沟乡', '0', '', '1', '0', '0', '10'),
('5102', '140000', '140900', '140932', '1', '1', '尚峪乡', '0', '', '1', '0', '0', '10'),
('5103', '140000', '140900', '140932', '1', '1', '南堡子乡', '0', '', '1', '0', '0', '10'),
('5104', '140000', '140900', '140932', '1', '1', '水泉乡', '0', '', '1', '0', '0', '10'),
('5105', '140000', '140900', '140932', '1', '1', '陈家营乡', '0', '', '1', '0', '0', '10'),
('5106', '140000', '140900', '140981', '1', '1', '北城街道', '0', '', '1', '0', '0', '10'),
('5107', '140000', '140900', '140981', '1', '1', '南城街道', '0', '', '1', '0', '0', '10'),
('5108', '140000', '140900', '140981', '1', '1', '东社镇', '0', '', '1', '0', '0', '10'),
('5109', '140000', '140900', '140981', '1', '1', '苏龙口镇', '0', '', '1', '0', '0', '10'),
('5110', '140000', '140900', '140981', '1', '1', '崞阳镇', '0', '', '1', '0', '0', '10'),
('5111', '140000', '140900', '140981', '1', '1', '大牛店镇', '0', '', '1', '0', '0', '10'),
('5112', '140000', '140900', '140981', '1', '1', '闫庄镇', '0', '', '1', '0', '0', '10'),
('5113', '140000', '140900', '140981', '1', '1', '长梁沟镇', '0', '', '1', '0', '0', '10'),
('5114', '140000', '140900', '140981', '1', '1', '轩岗镇', '0', '', '1', '0', '0', '10'),
('5115', '140000', '140900', '140981', '1', '1', '新原乡', '0', '', '1', '0', '0', '10'),
('5116', '140000', '140900', '140981', '1', '1', '南白乡', '0', '', '1', '0', '0', '10'),
('5117', '140000', '140900', '140981', '1', '1', '子干乡', '0', '', '1', '0', '0', '10'),
('5118', '140000', '140900', '140981', '1', '1', '中阳乡', '0', '', '1', '0', '0', '10'),
('5119', '140000', '140900', '140981', '1', '1', '沿沟乡', '0', '', '1', '0', '0', '10'),
('5120', '140000', '140900', '140981', '1', '1', '大林乡', '0', '', '1', '0', '0', '10'),
('5121', '140000', '140900', '140981', '1', '1', '西镇乡', '0', '', '1', '0', '0', '10'),
('5122', '140000', '140900', '140981', '1', '1', '解村乡', '0', '', '1', '0', '0', '10'),
('5123', '140000', '140900', '140981', '1', '1', '王家庄乡', '0', '', '1', '0', '0', '10'),
('5124', '140000', '140900', '140981', '1', '1', '楼板寨乡', '0', '', '1', '0', '0', '10'),
('5125', '140000', '140900', '140981', '1', '1', '段家堡乡', '0', '', '1', '0', '0', '10'),
('5126', '140000', '140900', '140981', '1', '1', '山西鲁能晋北铝业工矿区', '0', '', '1', '0', '0', '10'),
('5127', '140000', '140900', '140981', '1', '1', '原平市石豹沟煤矿工矿区', '0', '', '1', '0', '0', '10'),
('5128', '140000', '140900', '140981', '1', '1', '同煤集团轩岗煤电有限公司工矿区', '0', '', '1', '0', '0', '10'),
('5129', '140000', '141000', '141002', '1', '1', '解放路街道', '0', '', '1', '0', '0', '10'),
('5130', '140000', '141000', '141002', '1', '1', '鼓楼西街街道', '0', '', '1', '0', '0', '10'),
('5131', '140000', '141000', '141002', '1', '1', '水塔街街道', '0', '', '1', '0', '0', '10'),
('5132', '140000', '141000', '141002', '1', '1', '南街街道', '0', '', '1', '0', '0', '10'),
('5133', '140000', '141000', '141002', '1', '1', '乡贤街街道', '0', '', '1', '0', '0', '10'),
('5134', '140000', '141000', '141002', '1', '1', '辛寺街街道', '0', '', '1', '0', '0', '10'),
('5135', '140000', '141000', '141002', '1', '1', '铁路东街道', '0', '', '1', '0', '0', '10'),
('5136', '140000', '141000', '141002', '1', '1', '车站街街道', '0', '', '1', '0', '0', '10'),
('5137', '140000', '141000', '141002', '1', '1', '汾河街道', '0', '', '1', '0', '0', '10'),
('5138', '140000', '141000', '141002', '1', '1', '屯里镇', '0', '', '1', '0', '0', '10'),
('5139', '140000', '141000', '141002', '1', '1', '乔李镇', '0', '', '1', '0', '0', '10'),
('5140', '140000', '141000', '141002', '1', '1', '大阳镇', '0', '', '1', '0', '0', '10'),
('5141', '140000', '141000', '141002', '1', '1', '县底镇', '0', '', '1', '0', '0', '10'),
('5142', '140000', '141000', '141002', '1', '1', '刘村镇', '0', '', '1', '0', '0', '10'),
('5143', '140000', '141000', '141002', '1', '1', '金殿镇', '0', '', '1', '0', '0', '10'),
('5144', '140000', '141000', '141002', '1', '1', '吴村镇', '0', '', '1', '0', '0', '10'),
('5145', '140000', '141000', '141002', '1', '1', '土门镇', '0', '', '1', '0', '0', '10'),
('5146', '140000', '141000', '141002', '1', '1', '魏村镇', '0', '', '1', '0', '0', '10'),
('5147', '140000', '141000', '141002', '1', '1', '尧庙镇', '0', '', '1', '0', '0', '10'),
('5148', '140000', '141000', '141002', '1', '1', '段店乡', '0', '', '1', '0', '0', '10'),
('5149', '140000', '141000', '141002', '1', '1', '贾得乡', '0', '', '1', '0', '0', '10'),
('5150', '140000', '141000', '141002', '1', '1', '贺家庄乡', '0', '', '1', '0', '0', '10'),
('5151', '140000', '141000', '141002', '1', '1', '一平垣乡', '0', '', '1', '0', '0', '10'),
('5152', '140000', '141000', '141002', '1', '1', '枕头乡', '0', '', '1', '0', '0', '10'),
('5153', '140000', '141000', '141002', '1', '1', '河底乡', '0', '', '1', '0', '0', '10'),
('5154', '140000', '141000', '141002', '1', '1', '滨河办事处(临汾经济开发区)', '0', '', '1', '0', '0', '10'),
('5155', '140000', '141000', '141021', '1', '1', '乐昌镇', '0', '', '1', '0', '0', '10'),
('5156', '140000', '141000', '141021', '1', '1', '史村镇', '0', '', '1', '0', '0', '10'),
('5157', '140000', '141000', '141021', '1', '1', '曲村镇', '0', '', '1', '0', '0', '10'),
('5158', '140000', '141000', '141021', '1', '1', '高显镇', '0', '', '1', '0', '0', '10'),
('5159', '140000', '141000', '141021', '1', '1', '里村镇', '0', '', '1', '0', '0', '10'),
('5160', '140000', '141000', '141021', '1', '1', '北董乡', '0', '', '1', '0', '0', '10'),
('5161', '140000', '141000', '141021', '1', '1', '杨谈乡', '0', '', '1', '0', '0', '10'),
('5162', '140000', '141000', '141022', '1', '1', '唐兴镇', '0', '', '1', '0', '0', '10'),
('5163', '140000', '141000', '141022', '1', '1', '南梁镇', '0', '', '1', '0', '0', '10'),
('5164', '140000', '141000', '141022', '1', '1', '里寨镇', '0', '', '1', '0', '0', '10'),
('5165', '140000', '141000', '141022', '1', '1', '隆化镇', '0', '', '1', '0', '0', '10'),
('5166', '140000', '141000', '141022', '1', '1', '桥上镇', '0', '', '1', '0', '0', '10'),
('5167', '140000', '141000', '141022', '1', '1', '西闫镇', '0', '', '1', '0', '0', '10'),
('5168', '140000', '141000', '141022', '1', '1', '中卫乡', '0', '', '1', '0', '0', '10'),
('5169', '140000', '141000', '141022', '1', '1', '南唐乡', '0', '', '1', '0', '0', '10'),
('5170', '140000', '141000', '141022', '1', '1', '王庄乡', '0', '', '1', '0', '0', '10'),
('5171', '140000', '141000', '141022', '1', '1', '浇底乡', '0', '', '1', '0', '0', '10'),
('5172', '140000', '141000', '141023', '1', '1', '新城镇', '0', '', '1', '0', '0', '10'),
('5173', '140000', '141000', '141023', '1', '1', '赵康镇', '0', '', '1', '0', '0', '10'),
('5174', '140000', '141000', '141023', '1', '1', '汾城镇', '0', '', '1', '0', '0', '10'),
('5175', '140000', '141000', '141023', '1', '1', '南贾镇', '0', '', '1', '0', '0', '10'),
('5176', '140000', '141000', '141023', '1', '1', '古城镇', '0', '', '1', '0', '0', '10'),
('5177', '140000', '141000', '141023', '1', '1', '襄陵镇', '0', '', '1', '0', '0', '10'),
('5178', '140000', '141000', '141023', '1', '1', '邓庄镇', '0', '', '1', '0', '0', '10'),
('5179', '140000', '141000', '141023', '1', '1', '陶寺乡', '0', '', '1', '0', '0', '10'),
('5180', '140000', '141000', '141023', '1', '1', '永固乡', '0', '', '1', '0', '0', '10'),
('5181', '140000', '141000', '141023', '1', '1', '景毛乡', '0', '', '1', '0', '0', '10'),
('5182', '140000', '141000', '141023', '1', '1', '西贾乡', '0', '', '1', '0', '0', '10'),
('5183', '140000', '141000', '141023', '1', '1', '南辛店乡', '0', '', '1', '0', '0', '10'),
('5184', '140000', '141000', '141023', '1', '1', '大邓乡', '0', '', '1', '0', '0', '10'),
('5185', '140000', '141000', '141024', '1', '1', '大槐树镇', '0', '', '1', '0', '0', '10'),
('5186', '140000', '141000', '141024', '1', '1', '甘亭镇', '0', '', '1', '0', '0', '10'),
('5187', '140000', '141000', '141024', '1', '1', '曲亭镇', '0', '', '1', '0', '0', '10'),
('5188', '140000', '141000', '141024', '1', '1', '苏堡镇', '0', '', '1', '0', '0', '10'),
('5189', '140000', '141000', '141024', '1', '1', '广胜寺镇', '0', '', '1', '0', '0', '10'),
('5190', '140000', '141000', '141024', '1', '1', '明姜镇', '0', '', '1', '0', '0', '10'),
('5191', '140000', '141000', '141024', '1', '1', '赵城镇', '0', '', '1', '0', '0', '10'),
('5192', '140000', '141000', '141024', '1', '1', '万安镇', '0', '', '1', '0', '0', '10'),
('5193', '140000', '141000', '141024', '1', '1', '刘家垣镇', '0', '', '1', '0', '0', '10'),
('5194', '140000', '141000', '141024', '1', '1', '淹底乡', '0', '', '1', '0', '0', '10'),
('5195', '140000', '141000', '141024', '1', '1', '兴唐寺乡', '0', '', '1', '0', '0', '10'),
('5196', '140000', '141000', '141024', '1', '1', '堤村乡', '0', '', '1', '0', '0', '10'),
('5197', '140000', '141000', '141024', '1', '1', '辛村乡', '0', '', '1', '0', '0', '10'),
('5198', '140000', '141000', '141024', '1', '1', '龙马乡', '0', '', '1', '0', '0', '10'),
('5199', '140000', '141000', '141024', '1', '1', '山头乡', '0', '', '1', '0', '0', '10'),
('5200', '140000', '141000', '141024', '1', '1', '左木乡', '0', '', '1', '0', '0', '10'),
('5201', '140000', '141000', '141025', '1', '1', '岳阳镇', '0', '', '1', '0', '0', '10'),
('5202', '140000', '141000', '141025', '1', '1', '北平镇', '0', '', '1', '0', '0', '10'),
('5203', '140000', '141000', '141025', '1', '1', '古阳镇', '0', '', '1', '0', '0', '10'),
('5204', '140000', '141000', '141025', '1', '1', '旧县镇', '0', '', '1', '0', '0', '10'),
('5205', '140000', '141000', '141025', '1', '1', '石壁乡', '0', '', '1', '0', '0', '10'),
('5206', '140000', '141000', '141025', '1', '1', '永乐乡', '0', '', '1', '0', '0', '10'),
('5207', '140000', '141000', '141025', '1', '1', '南垣乡', '0', '', '1', '0', '0', '10'),
('5208', '140000', '141000', '141026', '1', '1', '府城镇', '0', '', '1', '0', '0', '10'),
('5209', '140000', '141000', '141026', '1', '1', '和川镇', '0', '', '1', '0', '0', '10'),
('5210', '140000', '141000', '141026', '1', '1', '唐城镇', '0', '', '1', '0', '0', '10'),
('5211', '140000', '141000', '141026', '1', '1', '冀氏镇', '0', '', '1', '0', '0', '10'),
('5212', '140000', '141000', '141026', '1', '1', '马必乡', '0', '', '1', '0', '0', '10'),
('5213', '140000', '141000', '141026', '1', '1', '杜村乡', '0', '', '1', '0', '0', '10'),
('5214', '140000', '141000', '141026', '1', '1', '良马乡', '0', '', '1', '0', '0', '10'),
('5215', '140000', '141000', '141027', '1', '1', '天坛镇', '0', '', '1', '0', '0', '10'),
('5216', '140000', '141000', '141027', '1', '1', '响水河镇', '0', '', '1', '0', '0', '10'),
('5217', '140000', '141000', '141027', '1', '1', '张庄乡', '0', '', '1', '0', '0', '10'),
('5218', '140000', '141000', '141027', '1', '1', '东张乡', '0', '', '1', '0', '0', '10'),
('5219', '140000', '141000', '141027', '1', '1', '槐埝乡', '0', '', '1', '0', '0', '10'),
('5220', '140000', '141000', '141027', '1', '1', '北王乡', '0', '', '1', '0', '0', '10'),
('5221', '140000', '141000', '141027', '1', '1', '北韩乡', '0', '', '1', '0', '0', '10'),
('5222', '140000', '141000', '141027', '1', '1', '米家垣乡', '0', '', '1', '0', '0', '10'),
('5223', '140000', '141000', '141027', '1', '1', '寨圪塔乡', '0', '', '1', '0', '0', '10'),
('5224', '140000', '141000', '141028', '1', '1', '吉昌镇', '0', '', '1', '0', '0', '10'),
('5225', '140000', '141000', '141028', '1', '1', '屯里镇', '0', '', '1', '0', '0', '10'),
('5226', '140000', '141000', '141028', '1', '1', '壶口镇', '0', '', '1', '0', '0', '10'),
('5227', '140000', '141000', '141028', '1', '1', '车城乡', '0', '', '1', '0', '0', '10'),
('5228', '140000', '141000', '141028', '1', '1', '文城乡', '0', '', '1', '0', '0', '10'),
('5229', '140000', '141000', '141028', '1', '1', '东城乡', '0', '', '1', '0', '0', '10'),
('5230', '140000', '141000', '141028', '1', '1', '柏山寺乡', '0', '', '1', '0', '0', '10'),
('5231', '140000', '141000', '141028', '1', '1', '中垛乡', '0', '', '1', '0', '0', '10'),
('5232', '140000', '141000', '141029', '1', '1', '昌宁镇', '0', '', '1', '0', '0', '10'),
('5233', '140000', '141000', '141029', '1', '1', '光华镇', '0', '', '1', '0', '0', '10'),
('5234', '140000', '141000', '141029', '1', '1', '台头镇', '0', '', '1', '0', '0', '10'),
('5235', '140000', '141000', '141029', '1', '1', '管头镇', '0', '', '1', '0', '0', '10'),
('5236', '140000', '141000', '141029', '1', '1', '西坡镇', '0', '', '1', '0', '0', '10'),
('5237', '140000', '141000', '141029', '1', '1', '双鹤乡', '0', '', '1', '0', '0', '10'),
('5238', '140000', '141000', '141029', '1', '1', '关王庙乡', '0', '', '1', '0', '0', '10'),
('5239', '140000', '141000', '141029', '1', '1', '尉庄乡', '0', '', '1', '0', '0', '10'),
('5240', '140000', '141000', '141029', '1', '1', '西交口乡', '0', '', '1', '0', '0', '10'),
('5241', '140000', '141000', '141029', '1', '1', '枣岭乡', '0', '', '1', '0', '0', '10'),
('5242', '140000', '141000', '141030', '1', '1', '昕水镇', '0', '', '1', '0', '0', '10'),
('5243', '140000', '141000', '141030', '1', '1', '曲峨镇', '0', '', '1', '0', '0', '10'),
('5244', '140000', '141000', '141030', '1', '1', '三多乡', '0', '', '1', '0', '0', '10'),
('5245', '140000', '141000', '141030', '1', '1', '太德乡', '0', '', '1', '0', '0', '10'),
('5246', '140000', '141000', '141030', '1', '1', '徐家垛乡', '0', '', '1', '0', '0', '10'),
('5247', '140000', '141000', '141030', '1', '1', '太古乡', '0', '', '1', '0', '0', '10'),
('5248', '140000', '141000', '141031', '1', '1', '龙泉镇', '0', '', '1', '0', '0', '10'),
('5249', '140000', '141000', '141031', '1', '1', '午城镇', '0', '', '1', '0', '0', '10'),
('5250', '140000', '141000', '141031', '1', '1', '黄土镇', '0', '', '1', '0', '0', '10'),
('5251', '140000', '141000', '141031', '1', '1', '阳头升乡', '0', '', '1', '0', '0', '10'),
('5252', '140000', '141000', '141031', '1', '1', '寨子乡', '0', '', '1', '0', '0', '10'),
('5253', '140000', '141000', '141031', '1', '1', '陡坡乡', '0', '', '1', '0', '0', '10'),
('5254', '140000', '141000', '141031', '1', '1', '下李乡', '0', '', '1', '0', '0', '10'),
('5255', '140000', '141000', '141031', '1', '1', '城南乡', '0', '', '1', '0', '0', '10'),
('5256', '140000', '141000', '141032', '1', '1', '芝河镇', '0', '', '1', '0', '0', '10'),
('5257', '140000', '141000', '141032', '1', '1', '桑壁镇', '0', '', '1', '0', '0', '10'),
('5258', '140000', '141000', '141032', '1', '1', '阁底乡', '0', '', '1', '0', '0', '10'),
('5259', '140000', '141000', '141032', '1', '1', '南庄乡', '0', '', '1', '0', '0', '10'),
('5260', '140000', '141000', '141032', '1', '1', '打石腰乡', '0', '', '1', '0', '0', '10'),
('5261', '140000', '141000', '141032', '1', '1', '坡头乡', '0', '', '1', '0', '0', '10'),
('5262', '140000', '141000', '141032', '1', '1', '交口乡', '0', '', '1', '0', '0', '10'),
('5263', '140000', '141000', '141033', '1', '1', '蒲城镇', '0', '', '1', '0', '0', '10'),
('5264', '140000', '141000', '141033', '1', '1', '薛关镇', '0', '', '1', '0', '0', '10'),
('5265', '140000', '141000', '141033', '1', '1', '黑龙关镇', '0', '', '1', '0', '0', '10'),
('5266', '140000', '141000', '141033', '1', '1', '克城镇', '0', '', '1', '0', '0', '10'),
('5267', '140000', '141000', '141033', '1', '1', '山中乡', '0', '', '1', '0', '0', '10'),
('5268', '140000', '141000', '141033', '1', '1', '古县乡', '0', '', '1', '0', '0', '10'),
('5269', '140000', '141000', '141033', '1', '1', '红道乡', '0', '', '1', '0', '0', '10'),
('5270', '140000', '141000', '141033', '1', '1', '乔家湾乡', '0', '', '1', '0', '0', '10'),
('5271', '140000', '141000', '141033', '1', '1', '太林乡', '0', '', '1', '0', '0', '10'),
('5272', '140000', '141000', '141034', '1', '1', '永安镇', '0', '', '1', '0', '0', '10'),
('5273', '140000', '141000', '141034', '1', '1', '对竹镇', '0', '', '1', '0', '0', '10'),
('5274', '140000', '141000', '141034', '1', '1', '勍香镇', '0', '', '1', '0', '0', '10'),
('5275', '140000', '141000', '141034', '1', '1', '和平镇', '0', '', '1', '0', '0', '10'),
('5276', '140000', '141000', '141034', '1', '1', '僧念镇', '0', '', '1', '0', '0', '10'),
('5277', '140000', '141000', '141034', '1', '1', '佃坪乡', '0', '', '1', '0', '0', '10'),
('5278', '140000', '141000', '141034', '1', '1', '团柏乡', '0', '', '1', '0', '0', '10'),
('5279', '140000', '141000', '141034', '1', '1', '邢家要乡', '0', '', '1', '0', '0', '10'),
('5280', '140000', '141000', '141081', '1', '1', '路东街道', '0', '', '1', '0', '0', '10'),
('5281', '140000', '141000', '141081', '1', '1', '路西街道', '0', '', '1', '0', '0', '10'),
('5282', '140000', '141000', '141081', '1', '1', '浍滨街道', '0', '', '1', '0', '0', '10'),
('5283', '140000', '141000', '141081', '1', '1', '上马街道', '0', '', '1', '0', '0', '10'),
('5284', '140000', '141000', '141081', '1', '1', '张村街道', '0', '', '1', '0', '0', '10'),
('5285', '140000', '141000', '141081', '1', '1', '新田乡', '0', '', '1', '0', '0', '10'),
('5286', '140000', '141000', '141081', '1', '1', '高村乡', '0', '', '1', '0', '0', '10'),
('5287', '140000', '141000', '141081', '1', '1', '凤城乡', '0', '', '1', '0', '0', '10'),
('5288', '140000', '141000', '141082', '1', '1', '鼓楼街道', '0', '', '1', '0', '0', '10'),
('5289', '140000', '141000', '141082', '1', '1', '北环路街道', '0', '', '1', '0', '0', '10'),
('5290', '140000', '141000', '141082', '1', '1', '南环路街道', '0', '', '1', '0', '0', '10'),
('5291', '140000', '141000', '141082', '1', '1', '开元街道办事', '0', '', '1', '0', '0', '10'),
('5292', '140000', '141000', '141082', '1', '1', '退沙街道', '0', '', '1', '0', '0', '10'),
('5293', '140000', '141000', '141082', '1', '1', '白龙镇', '0', '', '1', '0', '0', '10'),
('5294', '140000', '141000', '141082', '1', '1', '辛置镇', '0', '', '1', '0', '0', '10'),
('5295', '140000', '141000', '141082', '1', '1', '大张镇', '0', '', '1', '0', '0', '10'),
('5296', '140000', '141000', '141082', '1', '1', '李曹镇', '0', '', '1', '0', '0', '10'),
('5297', '140000', '141000', '141082', '1', '1', '陶唐峪乡', '0', '', '1', '0', '0', '10'),
('5298', '140000', '141000', '141082', '1', '1', '三教乡', '0', '', '1', '0', '0', '10'),
('5299', '140000', '141000', '141082', '1', '1', '师庄乡', '0', '', '1', '0', '0', '10'),
('5300', '140000', '141100', '141102', '1', '1', '滨河街道', '0', '', '1', '0', '0', '10'),
('5301', '140000', '141100', '141102', '1', '1', '凤山街道', '0', '', '1', '0', '0', '10'),
('5302', '140000', '141100', '141102', '1', '1', '莲花池街道', '0', '', '1', '0', '0', '10'),
('5303', '140000', '141100', '141102', '1', '1', '城北街道', '0', '', '1', '0', '0', '10'),
('5304', '140000', '141100', '141102', '1', '1', '田家会街道', '0', '', '1', '0', '0', '10'),
('5305', '140000', '141100', '141102', '1', '1', '交口街道', '0', '', '1', '0', '0', '10'),
('5306', '140000', '141100', '141102', '1', '1', '西属巴街道', '0', '', '1', '0', '0', '10'),
('5307', '140000', '141100', '141102', '1', '1', '吴城镇', '0', '', '1', '0', '0', '10'),
('5308', '140000', '141100', '141102', '1', '1', '信义镇', '0', '', '1', '0', '0', '10'),
('5309', '140000', '141100', '141102', '1', '1', '红眼川乡', '0', '', '1', '0', '0', '10'),
('5310', '140000', '141100', '141102', '1', '1', '枣林乡', '0', '', '1', '0', '0', '10'),
('5311', '140000', '141100', '141102', '1', '1', '坪头乡', '0', '', '1', '0', '0', '10'),
('5312', '140000', '141100', '141121', '1', '1', '凤城镇', '0', '', '1', '0', '0', '10'),
('5313', '140000', '141100', '141121', '1', '1', '开栅镇', '0', '', '1', '0', '0', '10'),
('5314', '140000', '141100', '141121', '1', '1', '南庄镇', '0', '', '1', '0', '0', '10'),
('5315', '140000', '141100', '141121', '1', '1', '南安镇', '0', '', '1', '0', '0', '10'),
('5316', '140000', '141100', '141121', '1', '1', '刘胡兰镇', '0', '', '1', '0', '0', '10'),
('5317', '140000', '141100', '141121', '1', '1', '下曲镇', '0', '', '1', '0', '0', '10'),
('5318', '140000', '141100', '141121', '1', '1', '孝义镇', '0', '', '1', '0', '0', '10'),
('5319', '140000', '141100', '141121', '1', '1', '南武乡', '0', '', '1', '0', '0', '10'),
('5320', '140000', '141100', '141121', '1', '1', '西城乡', '0', '', '1', '0', '0', '10'),
('5321', '140000', '141100', '141121', '1', '1', '北张乡', '0', '', '1', '0', '0', '10'),
('5322', '140000', '141100', '141121', '1', '1', '马西乡', '0', '', '1', '0', '0', '10'),
('5323', '140000', '141100', '141121', '1', '1', '西槽头乡', '0', '', '1', '0', '0', '10'),
('5324', '140000', '141100', '141122', '1', '1', '天宁镇', '0', '', '1', '0', '0', '10'),
('5325', '140000', '141100', '141122', '1', '1', '夏家营镇', '0', '', '1', '0', '0', '10'),
('5326', '140000', '141100', '141122', '1', '1', '西营镇', '0', '', '1', '0', '0', '10'),
('5327', '140000', '141100', '141122', '1', '1', '水峪贯镇', '0', '', '1', '0', '0', '10'),
('5328', '140000', '141100', '141122', '1', '1', '西社镇', '0', '', '1', '0', '0', '10'),
('5329', '140000', '141100', '141122', '1', '1', '庞泉沟镇', '0', '', '1', '0', '0', '10'),
('5330', '140000', '141100', '141122', '1', '1', '洪相乡', '0', '', '1', '0', '0', '10'),
('5331', '140000', '141100', '141122', '1', '1', '岭底乡', '0', '', '1', '0', '0', '10'),
('5332', '140000', '141100', '141122', '1', '1', '东坡底乡', '0', '', '1', '0', '0', '10'),
('5333', '140000', '141100', '141122', '1', '1', '会立乡', '0', '', '1', '0', '0', '10'),
('5334', '140000', '141100', '141123', '1', '1', '蔚汾镇', '0', '', '1', '0', '0', '10'),
('5335', '140000', '141100', '141123', '1', '1', '魏家滩镇', '0', '', '1', '0', '0', '10'),
('5336', '140000', '141100', '141123', '1', '1', '瓦塘镇', '0', '', '1', '0', '0', '10'),
('5337', '140000', '141100', '141123', '1', '1', '康宁镇', '0', '', '1', '0', '0', '10'),
('5338', '140000', '141100', '141123', '1', '1', '高家村镇', '0', '', '1', '0', '0', '10'),
('5339', '140000', '141100', '141123', '1', '1', '罗峪口镇', '0', '', '1', '0', '0', '10'),
('5340', '140000', '141100', '141123', '1', '1', '蔡家会镇', '0', '', '1', '0', '0', '10'),
('5341', '140000', '141100', '141123', '1', '1', '交楼申乡', '0', '', '1', '0', '0', '10'),
('5342', '140000', '141100', '141123', '1', '1', '恶虎滩乡', '0', '', '1', '0', '0', '10'),
('5343', '140000', '141100', '141123', '1', '1', '东会乡', '0', '', '1', '0', '0', '10'),
('5344', '140000', '141100', '141123', '1', '1', '固贤乡', '0', '', '1', '0', '0', '10'),
('5345', '140000', '141100', '141123', '1', '1', '奥家湾乡', '0', '', '1', '0', '0', '10'),
('5346', '140000', '141100', '141123', '1', '1', '蔡家崖乡', '0', '', '1', '0', '0', '10'),
('5347', '140000', '141100', '141123', '1', '1', '贺家会乡', '0', '', '1', '0', '0', '10'),
('5348', '140000', '141100', '141123', '1', '1', '孟家坪乡', '0', '', '1', '0', '0', '10'),
('5349', '140000', '141100', '141123', '1', '1', '赵家坪乡', '0', '', '1', '0', '0', '10'),
('5350', '140000', '141100', '141123', '1', '1', '圪垯上乡', '0', '', '1', '0', '0', '10'),
('5351', '140000', '141100', '141124', '1', '1', '临泉镇', '0', '', '1', '0', '0', '10'),
('5352', '140000', '141100', '141124', '1', '1', '白文镇', '0', '', '1', '0', '0', '10'),
('5353', '140000', '141100', '141124', '1', '1', '城庄镇', '0', '', '1', '0', '0', '10'),
('5354', '140000', '141100', '141124', '1', '1', '兔坂镇', '0', '', '1', '0', '0', '10'),
('5355', '140000', '141100', '141124', '1', '1', '克虎镇', '0', '', '1', '0', '0', '10'),
('5356', '140000', '141100', '141124', '1', '1', '三交镇', '0', '', '1', '0', '0', '10'),
('5357', '140000', '141100', '141124', '1', '1', '湍水头镇', '0', '', '1', '0', '0', '10'),
('5358', '140000', '141100', '141124', '1', '1', '林家坪镇', '0', '', '1', '0', '0', '10'),
('5359', '140000', '141100', '141124', '1', '1', '招贤镇', '0', '', '1', '0', '0', '10'),
('5360', '140000', '141100', '141124', '1', '1', '碛口镇', '0', '', '1', '0', '0', '10'),
('5361', '140000', '141100', '141124', '1', '1', '刘家会镇', '0', '', '1', '0', '0', '10'),
('5362', '140000', '141100', '141124', '1', '1', '丛罗峪镇', '0', '', '1', '0', '0', '10'),
('5363', '140000', '141100', '141124', '1', '1', '曲峪镇', '0', '', '1', '0', '0', '10'),
('5364', '140000', '141100', '141124', '1', '1', '木瓜坪乡', '0', '', '1', '0', '0', '10'),
('5365', '140000', '141100', '141124', '1', '1', '安业乡', '0', '', '1', '0', '0', '10'),
('5366', '140000', '141100', '141124', '1', '1', '玉坪乡', '0', '', '1', '0', '0', '10'),
('5367', '140000', '141100', '141124', '1', '1', '青凉寺乡', '0', '', '1', '0', '0', '10'),
('5368', '140000', '141100', '141124', '1', '1', '石白头乡', '0', '', '1', '0', '0', '10'),
('5369', '140000', '141100', '141124', '1', '1', '雷家碛乡', '0', '', '1', '0', '0', '10'),
('5370', '140000', '141100', '141124', '1', '1', '第八堡乡', '0', '', '1', '0', '0', '10'),
('5371', '140000', '141100', '141124', '1', '1', '大禹乡', '0', '', '1', '0', '0', '10'),
('5372', '140000', '141100', '141124', '1', '1', '车赶乡', '0', '', '1', '0', '0', '10'),
('5373', '140000', '141100', '141124', '1', '1', '安家庄乡', '0', '', '1', '0', '0', '10'),
('5374', '140000', '141100', '141125', '1', '1', '柳林镇', '0', '', '1', '0', '0', '10'),
('5375', '140000', '141100', '141125', '1', '1', '穆村镇', '0', '', '1', '0', '0', '10'),
('5376', '140000', '141100', '141125', '1', '1', '薛村镇', '0', '', '1', '0', '0', '10'),
('5377', '140000', '141100', '141125', '1', '1', '庄上镇', '0', '', '1', '0', '0', '10'),
('5378', '140000', '141100', '141125', '1', '1', '留誉镇', '0', '', '1', '0', '0', '10'),
('5379', '140000', '141100', '141125', '1', '1', '三交镇', '0', '', '1', '0', '0', '10'),
('5380', '140000', '141100', '141125', '1', '1', '成家庄镇', '0', '', '1', '0', '0', '10'),
('5381', '140000', '141100', '141125', '1', '1', '孟门镇', '0', '', '1', '0', '0', '10'),
('5382', '140000', '141100', '141125', '1', '1', '李家湾乡', '0', '', '1', '0', '0', '10'),
('5383', '140000', '141100', '141125', '1', '1', '贾家垣乡', '0', '', '1', '0', '0', '10'),
('5384', '140000', '141100', '141125', '1', '1', '陈家湾乡', '0', '', '1', '0', '0', '10'),
('5385', '140000', '141100', '141125', '1', '1', '金家庄乡', '0', '', '1', '0', '0', '10'),
('5386', '140000', '141100', '141125', '1', '1', '高家沟乡', '0', '', '1', '0', '0', '10'),
('5387', '140000', '141100', '141125', '1', '1', '石西乡', '0', '', '1', '0', '0', '10'),
('5388', '140000', '141100', '141125', '1', '1', '王家沟乡', '0', '', '1', '0', '0', '10'),
('5389', '140000', '141100', '141126', '1', '1', '灵泉镇', '0', '', '1', '0', '0', '10'),
('5390', '140000', '141100', '141126', '1', '1', '罗村镇', '0', '', '1', '0', '0', '10'),
('5391', '140000', '141100', '141126', '1', '1', '义牒镇', '0', '', '1', '0', '0', '10'),
('5392', '140000', '141100', '141126', '1', '1', '小蒜镇', '0', '', '1', '0', '0', '10'),
('5393', '140000', '141100', '141126', '1', '1', '龙交乡', '0', '', '1', '0', '0', '10'),
('5394', '140000', '141100', '141126', '1', '1', '和合乡', '0', '', '1', '0', '0', '10'),
('5395', '140000', '141100', '141126', '1', '1', '前山乡', '0', '', '1', '0', '0', '10'),
('5396', '140000', '141100', '141126', '1', '1', '曹家垣乡', '0', '', '1', '0', '0', '10'),
('5397', '140000', '141100', '141126', '1', '1', '裴沟乡', '0', '', '1', '0', '0', '10'),
('5398', '140000', '141100', '141127', '1', '1', '东村镇', '0', '', '1', '0', '0', '10'),
('5399', '140000', '141100', '141127', '1', '1', '岚城镇', '0', '', '1', '0', '0', '10'),
('5400', '140000', '141100', '141127', '1', '1', '普明镇', '0', '', '1', '0', '0', '10'),
('5401', '140000', '141100', '141127', '1', '1', '界河口镇', '0', '', '1', '0', '0', '10'),
('5402', '140000', '141100', '141127', '1', '1', '土峪乡', '0', '', '1', '0', '0', '10'),
('5403', '140000', '141100', '141127', '1', '1', '上明乡', '0', '', '1', '0', '0', '10'),
('5404', '140000', '141100', '141127', '1', '1', '王狮乡', '0', '', '1', '0', '0', '10'),
('5405', '140000', '141100', '141127', '1', '1', '梁家庄乡', '0', '', '1', '0', '0', '10'),
('5406', '140000', '141100', '141127', '1', '1', '顺会乡', '0', '', '1', '0', '0', '10'),
('5407', '140000', '141100', '141127', '1', '1', '河口乡', '0', '', '1', '0', '0', '10'),
('5408', '140000', '141100', '141127', '1', '1', '社科乡', '0', '', '1', '0', '0', '10'),
('5409', '140000', '141100', '141127', '1', '1', '大蛇头乡', '0', '', '1', '0', '0', '10'),
('5410', '140000', '141100', '141128', '1', '1', '圪洞镇', '0', '', '1', '0', '0', '10'),
('5411', '140000', '141100', '141128', '1', '1', '马坊镇', '0', '', '1', '0', '0', '10'),
('5412', '140000', '141100', '141128', '1', '1', '峪口镇', '0', '', '1', '0', '0', '10'),
('5413', '140000', '141100', '141128', '1', '1', '大武镇', '0', '', '1', '0', '0', '10'),
('5414', '140000', '141100', '141128', '1', '1', '北武当镇', '0', '', '1', '0', '0', '10'),
('5415', '140000', '141100', '141128', '1', '1', '积翠乡', '0', '', '1', '0', '0', '10'),
('5416', '140000', '141100', '141128', '1', '1', '麻地会乡', '0', '', '1', '0', '0', '10'),
('5417', '140000', '141100', '141129', '1', '1', '宁乡镇', '0', '', '1', '0', '0', '10'),
('5418', '140000', '141100', '141129', '1', '1', '金罗镇', '0', '', '1', '0', '0', '10'),
('5419', '140000', '141100', '141129', '1', '1', '枝柯镇', '0', '', '1', '0', '0', '10'),
('5420', '140000', '141100', '141129', '1', '1', '武家庄镇', '0', '', '1', '0', '0', '10'),
('5421', '140000', '141100', '141129', '1', '1', '暖泉镇', '0', '', '1', '0', '0', '10'),
('5422', '140000', '141100', '141129', '1', '1', '张子山乡', '0', '', '1', '0', '0', '10'),
('5423', '140000', '141100', '141129', '1', '1', '下枣林乡', '0', '', '1', '0', '0', '10'),
('5424', '140000', '141100', '141130', '1', '1', '水头镇', '0', '', '1', '0', '0', '10'),
('5425', '140000', '141100', '141130', '1', '1', '康城镇', '0', '', '1', '0', '0', '10'),
('5426', '140000', '141100', '141130', '1', '1', '双池镇', '0', '', '1', '0', '0', '10'),
('5427', '140000', '141100', '141130', '1', '1', '桃红坡镇', '0', '', '1', '0', '0', '10'),
('5428', '140000', '141100', '141130', '1', '1', '石口乡', '0', '', '1', '0', '0', '10'),
('5429', '140000', '141100', '141130', '1', '1', '回龙乡', '0', '', '1', '0', '0', '10'),
('5430', '140000', '141100', '141130', '1', '1', '温泉乡', '0', '', '1', '0', '0', '10'),
('5431', '140000', '141100', '141181', '1', '1', '新义街道', '0', '', '1', '0', '0', '10'),
('5432', '140000', '141100', '141181', '1', '1', '中阳楼街道', '0', '', '1', '0', '0', '10'),
('5433', '140000', '141100', '141181', '1', '1', '振兴街道', '0', '', '1', '0', '0', '10'),
('5434', '140000', '141100', '141181', '1', '1', '东许街道', '0', '', '1', '0', '0', '10'),
('5435', '140000', '141100', '141181', '1', '1', '兑镇镇', '0', '', '1', '0', '0', '10'),
('5436', '140000', '141100', '141181', '1', '1', '阳泉曲镇', '0', '', '1', '0', '0', '10'),
('5437', '140000', '141100', '141181', '1', '1', '下堡镇', '0', '', '1', '0', '0', '10'),
('5438', '140000', '141100', '141181', '1', '1', '西辛庄镇', '0', '', '1', '0', '0', '10'),
('5439', '140000', '141100', '141181', '1', '1', '高阳镇', '0', '', '1', '0', '0', '10'),
('5440', '140000', '141100', '141181', '1', '1', '梧桐镇', '0', '', '1', '0', '0', '10'),
('5441', '140000', '141100', '141181', '1', '1', '柱濮镇', '0', '', '1', '0', '0', '10'),
('5442', '140000', '141100', '141181', '1', '1', '大孝堡乡', '0', '', '1', '0', '0', '10'),
('5443', '140000', '141100', '141181', '1', '1', '下栅乡', '0', '', '1', '0', '0', '10'),
('5444', '140000', '141100', '141181', '1', '1', '驿马乡', '0', '', '1', '0', '0', '10'),
('5445', '140000', '141100', '141181', '1', '1', '南阳乡', '0', '', '1', '0', '0', '10'),
('5446', '140000', '141100', '141181', '1', '1', '杜村乡', '0', '', '1', '0', '0', '10'),
('5447', '140000', '141100', '141182', '1', '1', '文峰街道', '0', '', '1', '0', '0', '10'),
('5448', '140000', '141100', '141182', '1', '1', '太和桥街道', '0', '', '1', '0', '0', '10'),
('5449', '140000', '141100', '141182', '1', '1', '贾家庄镇', '0', '', '1', '0', '0', '10'),
('5450', '140000', '141100', '141182', '1', '1', '杏花村镇', '0', '', '1', '0', '0', '10'),
('5451', '140000', '141100', '141182', '1', '1', '冀村镇', '0', '', '1', '0', '0', '10'),
('5452', '140000', '141100', '141182', '1', '1', '肖家庄镇', '0', '', '1', '0', '0', '10'),
('5453', '140000', '141100', '141182', '1', '1', '演武镇', '0', '', '1', '0', '0', '10'),
('5454', '140000', '141100', '141182', '1', '1', '三泉镇', '0', '', '1', '0', '0', '10'),
('5455', '140000', '141100', '141182', '1', '1', '石庄镇', '0', '', '1', '0', '0', '10'),
('5456', '140000', '141100', '141182', '1', '1', '杨家庄镇', '0', '', '1', '0', '0', '10'),
('5457', '140000', '141100', '141182', '1', '1', '峪道河镇', '0', '', '1', '0', '0', '10'),
('5458', '140000', '141100', '141182', '1', '1', '西河乡', '0', '', '1', '0', '0', '10'),
('5459', '140000', '141100', '141182', '1', '1', '阳城乡', '0', '', '1', '0', '0', '10'),
('5460', '140000', '141100', '141182', '1', '1', '栗家庄乡', '0', '', '1', '0', '0', '10'),
('5461', '150000', '150100', '150102', '1', '1', '海拉尔东路街道', '0', '', '1', '0', '0', '10'),
('5462', '150000', '150100', '150102', '1', '1', '锡林路', '0', '', '1', '0', '0', '10'),
('5463', '150000', '150100', '150102', '1', '1', '中山东路街道', '0', '', '1', '0', '0', '10'),
('5464', '150000', '150100', '150102', '1', '1', '东街街道', '0', '', '1', '0', '0', '10'),
('5465', '150000', '150100', '150102', '1', '1', '西街街道', '0', '', '1', '0', '0', '10'),
('5466', '150000', '150100', '150102', '1', '1', '东风路街道', '0', '', '1', '0', '0', '10'),
('5467', '150000', '150100', '150102', '1', '1', '迎新路街道', '0', '', '1', '0', '0', '10'),
('5468', '150000', '150100', '150102', '1', '1', '毫沁营镇', '0', '', '1', '0', '0', '10'),
('5469', '150000', '150100', '150102', '1', '1', '保合少镇', '0', '', '1', '0', '0', '10'),
('5470', '150000', '150100', '150102', '1', '1', '新城区鸿盛高科技园区', '0', '', '1', '0', '0', '10'),
('5471', '150000', '150100', '150103', '1', '1', '新华西路', '0', '', '1', '0', '0', '10'),
('5472', '150000', '150100', '150103', '1', '1', '中山西路', '0', '', '1', '0', '0', '10'),
('5473', '150000', '150100', '150103', '1', '1', '光明路', '0', '', '1', '0', '0', '10'),
('5474', '150000', '150100', '150103', '1', '1', '海拉尔西路', '0', '', '1', '0', '0', '10'),
('5475', '150000', '150100', '150103', '1', '1', '环河街', '0', '', '1', '0', '0', '10'),
('5476', '150000', '150100', '150103', '1', '1', '通道街', '0', '', '1', '0', '0', '10'),
('5477', '150000', '150100', '150103', '1', '1', '钢铁路', '0', '', '1', '0', '0', '10'),
('5478', '150000', '150100', '150103', '1', '1', '攸攸板镇', '0', '', '1', '0', '0', '10'),
('5479', '150000', '150100', '150104', '1', '1', '小召前街', '0', '', '1', '0', '0', '10'),
('5480', '150000', '150100', '150104', '1', '1', '兴隆巷', '0', '', '1', '0', '0', '10'),
('5481', '150000', '150100', '150104', '1', '1', '长和廊', '0', '', '1', '0', '0', '10'),
('5482', '150000', '150100', '150104', '1', '1', '石东路', '0', '', '1', '0', '0', '10'),
('5483', '150000', '150100', '150104', '1', '1', '大南街', '0', '', '1', '0', '0', '10'),
('5484', '150000', '150100', '150104', '1', '1', '鄂尔多斯路', '0', '', '1', '0', '0', '10'),
('5485', '150000', '150100', '150104', '1', '1', '西菜园', '0', '', '1', '0', '0', '10'),
('5486', '150000', '150100', '150104', '1', '1', '小黑河镇', '0', '', '1', '0', '0', '10'),
('5487', '150000', '150100', '150105', '1', '1', '人民路街道', '0', '', '1', '0', '0', '10'),
('5488', '150000', '150100', '150105', '1', '1', '大学西路街道', '0', '', '1', '0', '0', '10'),
('5489', '150000', '150100', '150105', '1', '1', '乌兰察布路街道', '0', '', '1', '0', '0', '10'),
('5490', '150000', '150100', '150105', '1', '1', '大学东路街道', '0', '', '1', '0', '0', '10'),
('5491', '150000', '150100', '150105', '1', '1', '中专路街道', '0', '', '1', '0', '0', '10'),
('5492', '150000', '150100', '150105', '1', '1', '巧报镇', '0', '', '1', '0', '0', '10'),
('5493', '150000', '150100', '150105', '1', '1', '榆林镇', '0', '', '1', '0', '0', '10'),
('5494', '150000', '150100', '150105', '1', '1', '巴彦镇', '0', '', '1', '0', '0', '10'),
('5495', '150000', '150100', '150105', '1', '1', '黄合少镇', '0', '', '1', '0', '0', '10'),
('5496', '150000', '150100', '150105', '1', '1', '金河镇', '0', '', '1', '0', '0', '10'),
('5497', '150000', '150100', '150105', '1', '1', '西把栅乡', '0', '', '1', '0', '0', '10'),
('5498', '150000', '150100', '150105', '1', '1', '金桥经济技术开发区', '0', '', '1', '0', '0', '10'),
('5499', '150000', '150100', '150121', '1', '1', '察素齐镇', '0', '', '1', '0', '0', '10'),
('5500', '150000', '150100', '150121', '1', '1', '毕克齐镇', '0', '', '1', '0', '0', '10'),
('5501', '150000', '150100', '150121', '1', '1', '善岱镇', '0', '', '1', '0', '0', '10'),
('5502', '150000', '150100', '150121', '1', '1', '台阁牧镇', '0', '', '1', '0', '0', '10'),
('5503', '150000', '150100', '150121', '1', '1', '白庙子镇', '0', '', '1', '0', '0', '10'),
('5504', '150000', '150100', '150121', '1', '1', '沙尔沁乡', '0', '', '1', '0', '0', '10'),
('5505', '150000', '150100', '150121', '1', '1', '北什轴乡', '0', '', '1', '0', '0', '10'),
('5506', '150000', '150100', '150121', '1', '1', '塔布赛乡', '0', '', '1', '0', '0', '10'),
('5507', '150000', '150100', '150121', '1', '1', '只几梁乡', '0', '', '1', '0', '0', '10'),
('5508', '150000', '150100', '150121', '1', '1', '呼和浩特经济技术开发区金川区', '0', '', '1', '0', '0', '10'),
('5509', '150000', '150100', '150121', '1', '1', '呼和浩特金山经济技术开发区', '0', '', '1', '0', '0', '10'),
('5510', '150000', '150100', '150122', '1', '1', '双河镇', '0', '', '1', '0', '0', '10'),
('5511', '150000', '150100', '150122', '1', '1', '新营子镇', '0', '', '1', '0', '0', '10'),
('5512', '150000', '150100', '150122', '1', '1', '五申镇', '0', '', '1', '0', '0', '10'),
('5513', '150000', '150100', '150122', '1', '1', '伍什家镇', '0', '', '1', '0', '0', '10'),
('5514', '150000', '150100', '150122', '1', '1', '古城镇', '0', '', '1', '0', '0', '10'),
('5515', '150000', '150100', '150123', '1', '1', '城关镇', '0', '', '1', '0', '0', '10'),
('5516', '150000', '150100', '150123', '1', '1', '盛乐镇', '0', '', '1', '0', '0', '10'),
('5517', '150000', '150100', '150123', '1', '1', '新店子镇', '0', '', '1', '0', '0', '10'),
('5518', '150000', '150100', '150123', '1', '1', '舍必崖乡', '0', '', '1', '0', '0', '10'),
('5519', '150000', '150100', '150123', '1', '1', '大红城乡', '0', '', '1', '0', '0', '10'),
('5520', '150000', '150100', '150123', '1', '1', '羊群沟乡', '0', '', '1', '0', '0', '10'),
('5521', '150000', '150100', '150123', '1', '1', '黑老夭乡', '0', '', '1', '0', '0', '10'),
('5522', '150000', '150100', '150123', '1', '1', '盛乐经济工业园区', '0', '', '1', '0', '0', '10'),
('5523', '150000', '150100', '150124', '1', '1', '城关镇', '0', '', '1', '0', '0', '10'),
('5524', '150000', '150100', '150124', '1', '1', '宏河镇', '0', '', '1', '0', '0', '10'),
('5525', '150000', '150100', '150124', '1', '1', '喇嘛湾镇', '0', '', '1', '0', '0', '10'),
('5526', '150000', '150100', '150124', '1', '1', '窑沟乡', '0', '', '1', '0', '0', '10'),
('5527', '150000', '150100', '150124', '1', '1', '北堡乡', '0', '', '1', '0', '0', '10'),
('5528', '150000', '150100', '150124', '1', '1', '韮菜庄乡', '0', '', '1', '0', '0', '10'),
('5529', '150000', '150100', '150125', '1', '1', '可镇', '0', '', '1', '0', '0', '10'),
('5530', '150000', '150100', '150125', '1', '1', '哈乐镇', '0', '', '1', '0', '0', '10'),
('5531', '150000', '150100', '150125', '1', '1', '西乌兰不浪镇', '0', '', '1', '0', '0', '10'),
('5532', '150000', '150100', '150125', '1', '1', '大青山乡', '0', '', '1', '0', '0', '10'),
('5533', '150000', '150100', '150125', '1', '1', '上秃亥乡', '0', '', '1', '0', '0', '10'),
('5534', '150000', '150100', '150125', '1', '1', '德胜沟乡', '0', '', '1', '0', '0', '10'),
('5535', '150000', '150100', '150125', '1', '1', '二份子乡', '0', '', '1', '0', '0', '10'),
('5536', '150000', '150100', '150125', '1', '1', '哈拉合少乡', '0', '', '1', '0', '0', '10'),
('5537', '150000', '150100', '150125', '1', '1', '工业园区', '0', '', '1', '0', '0', '10'),
('5538', '150000', '150200', '150202', '1', '1', '和平街道', '0', '', '1', '0', '0', '10'),
('5539', '150000', '150200', '150202', '1', '1', '财神庙街道', '0', '', '1', '0', '0', '10'),
('5540', '150000', '150200', '150202', '1', '1', '西脑包街道', '0', '', '1', '0', '0', '10'),
('5541', '150000', '150200', '150202', '1', '1', '南门外街道', '0', '', '1', '0', '0', '10'),
('5542', '150000', '150200', '150202', '1', '1', '南圪洞街道', '0', '', '1', '0', '0', '10'),
('5543', '150000', '150200', '150202', '1', '1', '东站街道', '0', '', '1', '0', '0', '10'),
('5544', '150000', '150200', '150202', '1', '1', '回民街道', '0', '', '1', '0', '0', '10'),
('5545', '150000', '150200', '150202', '1', '1', '二里半街道', '0', '', '1', '0', '0', '10'),
('5546', '150000', '150200', '150202', '1', '1', '河东街道', '0', '', '1', '0', '0', '10'),
('5547', '150000', '150200', '150202', '1', '1', '铁西街道', '0', '', '1', '0', '0', '10'),
('5548', '150000', '150200', '150202', '1', '1', '东兴街道', '0', '', '1', '0', '0', '10'),
('5549', '150000', '150200', '150202', '1', '1', '杨圪楞街道', '0', '', '1', '0', '0', '10'),
('5550', '150000', '150200', '150202', '1', '1', '河东镇', '0', '', '1', '0', '0', '10'),
('5551', '150000', '150200', '150203', '1', '1', '少先路街道', '0', '', '1', '0', '0', '10'),
('5552', '150000', '150200', '150203', '1', '1', '张家营子街道', '0', '', '1', '0', '0', '10'),
('5553', '150000', '150200', '150203', '1', '1', '沼潭街道', '0', '', '1', '0', '0', '10'),
('5554', '150000', '150200', '150203', '1', '1', '林荫路街道', '0', '', '1', '0', '0', '10'),
('5555', '150000', '150200', '150203', '1', '1', '友谊大街街道', '0', '', '1', '0', '0', '10'),
('5556', '150000', '150200', '150203', '1', '1', '阿尔丁大街街道', '0', '', '1', '0', '0', '10'),
('5557', '150000', '150200', '150203', '1', '1', '团结大街街道', '0', '', '1', '0', '0', '10'),
('5558', '150000', '150200', '150203', '1', '1', '鞍山道街道', '0', '', '1', '0', '0', '10'),
('5559', '150000', '150200', '150203', '1', '1', '前进道街道', '0', '', '1', '0', '0', '10'),
('5560', '150000', '150200', '150203', '1', '1', '市府东路街道', '0', '', '1', '0', '0', '10'),
('5561', '150000', '150200', '150203', '1', '1', '白云路街道', '0', '', '1', '0', '0', '10'),
('5562', '150000', '150200', '150203', '1', '1', '黄河西路街道', '0', '', '1', '0', '0', '10'),
('5563', '150000', '150200', '150203', '1', '1', '昆工路街道', '0', '', '1', '0', '0', '10'),
('5564', '150000', '150200', '150203', '1', '1', '昆河镇', '0', '', '1', '0', '0', '10'),
('5565', '150000', '150200', '150203', '1', '1', '包钢厂区虚拟', '0', '', '1', '0', '0', '10'),
('5566', '150000', '150200', '150204', '1', '1', '先锋道街道', '0', '', '1', '0', '0', '10'),
('5567', '150000', '150200', '150204', '1', '1', '幸福路街道', '0', '', '1', '0', '0', '10'),
('5568', '150000', '150200', '150204', '1', '1', '万青路街道', '0', '', '1', '0', '0', '10'),
('5569', '150000', '150200', '150204', '1', '1', '富强路街道', '0', '', '1', '0', '0', '10'),
('5570', '150000', '150200', '150204', '1', '1', '科学路街道', '0', '', '1', '0', '0', '10'),
('5571', '150000', '150200', '150204', '1', '1', '青山路街道', '0', '', '1', '0', '0', '10'),
('5572', '150000', '150200', '150204', '1', '1', '自由路街道', '0', '', '1', '0', '0', '10'),
('5573', '150000', '150200', '150204', '1', '1', '乌素图街道', '0', '', '1', '0', '0', '10'),
('5574', '150000', '150200', '150204', '1', '1', '青福镇', '0', '', '1', '0', '0', '10'),
('5575', '150000', '150200', '150204', '1', '1', '万水泉镇', '0', '', '1', '0', '0', '10'),
('5576', '150000', '150200', '150204', '1', '1', '包头稀土高新区新建区虚拟', '0', '', '1', '0', '0', '10'),
('5577', '150000', '150200', '150205', '1', '1', '石拐街道', '0', '', '1', '0', '0', '10'),
('5578', '150000', '150200', '150205', '1', '1', '大发街道', '0', '', '1', '0', '0', '10'),
('5579', '150000', '150200', '150205', '1', '1', '大磁街道', '0', '', '1', '0', '0', '10'),
('5580', '150000', '150200', '150205', '1', '1', '五当沟街道', '0', '', '1', '0', '0', '10'),
('5581', '150000', '150200', '150205', '1', '1', '白狐沟街道', '0', '', '1', '0', '0', '10'),
('5582', '150000', '150200', '150205', '1', '1', '五当召镇', '0', '', '1', '0', '0', '10'),
('5583', '150000', '150200', '150206', '1', '1', '矿山路街道', '0', '', '1', '0', '0', '10'),
('5584', '150000', '150200', '150206', '1', '1', '通阳道街道', '0', '', '1', '0', '0', '10'),
('5585', '150000', '150200', '150207', '1', '1', '沙河街道', '0', '', '1', '0', '0', '10'),
('5586', '150000', '150200', '150207', '1', '1', '麻池镇', '0', '', '1', '0', '0', '10'),
('5587', '150000', '150200', '150207', '1', '1', '哈林格尔镇', '0', '', '1', '0', '0', '10'),
('5588', '150000', '150200', '150207', '1', '1', '沙尔沁镇', '0', '', '1', '0', '0', '10'),
('5589', '150000', '150200', '150207', '1', '1', '兴胜镇', '0', '', '1', '0', '0', '10'),
('5590', '150000', '150200', '150207', '1', '1', '哈业胡同镇', '0', '', '1', '0', '0', '10'),
('5591', '150000', '150200', '150207', '1', '1', '阿嘎如泰苏木乡', '0', '', '1', '0', '0', '10'),
('5592', '150000', '150200', '150207', '1', '1', '包头市国营青年农场', '0', '', '1', '0', '0', '10'),
('5593', '150000', '150200', '150207', '1', '1', '包头市奶业公司', '0', '', '1', '0', '0', '10'),
('5594', '150000', '150200', '150221', '1', '1', '萨拉齐镇', '0', '', '1', '0', '0', '10'),
('5595', '150000', '150200', '150221', '1', '1', '双龙镇', '0', '', '1', '0', '0', '10'),
('5596', '150000', '150200', '150221', '1', '1', '美岱召镇', '0', '', '1', '0', '0', '10'),
('5597', '150000', '150200', '150221', '1', '1', '沟门镇', '0', '', '1', '0', '0', '10'),
('5598', '150000', '150200', '150221', '1', '1', '将军尧镇', '0', '', '1', '0', '0', '10'),
('5599', '150000', '150200', '150221', '1', '1', '海子乡', '0', '', '1', '0', '0', '10'),
('5600', '150000', '150200', '150221', '1', '1', '明沙淖乡', '0', '', '1', '0', '0', '10'),
('5601', '150000', '150200', '150221', '1', '1', '苏波盖乡', '0', '', '1', '0', '0', '10'),
('5602', '150000', '150200', '150221', '1', '1', '九峰山生态管理委员会', '0', '', '1', '0', '0', '10'),
('5603', '150000', '150200', '150222', '1', '1', '金山镇', '0', '', '1', '0', '0', '10'),
('5604', '150000', '150200', '150222', '1', '1', '西斗铺镇', '0', '', '1', '0', '0', '10'),
('5605', '150000', '150200', '150222', '1', '1', '下湿壕镇', '0', '', '1', '0', '0', '10'),
('5606', '150000', '150200', '150222', '1', '1', '银号镇', '0', '', '1', '0', '0', '10'),
('5607', '150000', '150200', '150222', '1', '1', '怀朔镇', '0', '', '1', '0', '0', '10'),
('5608', '150000', '150200', '150222', '1', '1', '兴顺西镇', '0', '', '1', '0', '0', '10'),
('5609', '150000', '150200', '150223', '1', '1', '满都拉镇', '0', '', '1', '0', '0', '10'),
('5610', '150000', '150200', '150223', '1', '1', '希拉穆仁镇', '0', '', '1', '0', '0', '10'),
('5611', '150000', '150200', '150223', '1', '1', '百灵庙镇', '0', '', '1', '0', '0', '10'),
('5612', '150000', '150200', '150223', '1', '1', '石宝镇', '0', '', '1', '0', '0', '10'),
('5613', '150000', '150200', '150223', '1', '1', '乌克忽洞镇', '0', '', '1', '0', '0', '10'),
('5614', '150000', '150200', '150223', '1', '1', '明安镇', '0', '', '1', '0', '0', '10'),
('5615', '150000', '150200', '150223', '1', '1', '巴音花镇', '0', '', '1', '0', '0', '10'),
('5616', '150000', '150200', '150223', '1', '1', '达尔罕苏木乡', '0', '', '1', '0', '0', '10'),
('5617', '150000', '150300', '150302', '1', '1', '凤凰岭街道', '0', '', '1', '0', '0', '10'),
('5618', '150000', '150300', '150302', '1', '1', '海北街道', '0', '', '1', '0', '0', '10'),
('5619', '150000', '150300', '150302', '1', '1', '新华街道', '0', '', '1', '0', '0', '10'),
('5620', '150000', '150300', '150302', '1', '1', '新华西街道', '0', '', '1', '0', '0', '10'),
('5621', '150000', '150300', '150302', '1', '1', '卡布其街道', '0', '', '1', '0', '0', '10'),
('5622', '150000', '150300', '150302', '1', '1', '滨河街道', '0', '', '1', '0', '0', '10'),
('5623', '150000', '150300', '150302', '1', '1', '千里山镇', '0', '', '1', '0', '0', '10'),
('5624', '150000', '150300', '150303', '1', '1', '拉僧仲街道', '0', '', '1', '0', '0', '10'),
('5625', '150000', '150300', '150303', '1', '1', '西卓子山街道', '0', '', '1', '0', '0', '10'),
('5626', '150000', '150300', '150303', '1', '1', '公乌素镇', '0', '', '1', '0', '0', '10'),
('5627', '150000', '150300', '150303', '1', '1', '拉僧庙镇', '0', '', '1', '0', '0', '10'),
('5628', '150000', '150300', '150303', '1', '1', '巴音陶亥镇', '0', '', '1', '0', '0', '10'),
('5629', '150000', '150300', '150304', '1', '1', '三道坎街道', '0', '', '1', '0', '0', '10'),
('5630', '150000', '150300', '150304', '1', '1', '五虎山街道', '0', '', '1', '0', '0', '10'),
('5631', '150000', '150300', '150304', '1', '1', '新达街道', '0', '', '1', '0', '0', '10'),
('5632', '150000', '150300', '150304', '1', '1', '巴音赛街道', '0', '', '1', '0', '0', '10'),
('5633', '150000', '150300', '150304', '1', '1', '梁家沟街道', '0', '', '1', '0', '0', '10'),
('5634', '150000', '150300', '150304', '1', '1', '苏海图街道', '0', '', '1', '0', '0', '10'),
('5635', '150000', '150300', '150304', '1', '1', '滨海街道', '0', '', '1', '0', '0', '10'),
('5636', '150000', '150300', '150304', '1', '1', '乌兰淖尔镇', '0', '', '1', '0', '0', '10'),
('5637', '150000', '150400', '150402', '1', '1', '西屯街道', '0', '', '1', '0', '0', '10'),
('5638', '150000', '150400', '150402', '1', '1', '三中街街道', '0', '', '1', '0', '0', '10'),
('5639', '150000', '150400', '150402', '1', '1', '永巨街道', '0', '', '1', '0', '0', '10'),
('5640', '150000', '150400', '150402', '1', '1', '东城街道', '0', '', '1', '0', '0', '10'),
('5641', '150000', '150400', '150402', '1', '1', '南新街街道', '0', '', '1', '0', '0', '10'),
('5642', '150000', '150400', '150402', '1', '1', '站前街道', '0', '', '1', '0', '0', '10'),
('5643', '150000', '150400', '150402', '1', '1', '铁南街道', '0', '', '1', '0', '0', '10'),
('5644', '150000', '150400', '150402', '1', '1', '长青街道', '0', '', '1', '0', '0', '10'),
('5645', '150000', '150400', '150402', '1', '1', '哈达街道', '0', '', '1', '0', '0', '10'),
('5646', '150000', '150400', '150402', '1', '1', '红庙子镇', '0', '', '1', '0', '0', '10'),
('5647', '150000', '150400', '150402', '1', '1', '文钟镇', '0', '', '1', '0', '0', '10'),
('5648', '150000', '150400', '150403', '1', '1', '西露天街道', '0', '', '1', '0', '0', '10'),
('5649', '150000', '150400', '150403', '1', '1', '平庄城区街道', '0', '', '1', '0', '0', '10'),
('5650', '150000', '150400', '150403', '1', '1', '风水沟镇', '0', '', '1', '0', '0', '10'),
('5651', '150000', '150400', '150403', '1', '1', '元宝山镇', '0', '', '1', '0', '0', '10'),
('5652', '150000', '150400', '150403', '1', '1', '美丽河镇', '0', '', '1', '0', '0', '10'),
('5653', '150000', '150400', '150403', '1', '1', '平庄镇', '0', '', '1', '0', '0', '10'),
('5654', '150000', '150400', '150403', '1', '1', '五家镇', '0', '', '1', '0', '0', '10'),
('5655', '150000', '150400', '150404', '1', '1', '振兴街道', '0', '', '1', '0', '0', '10'),
('5656', '150000', '150400', '150404', '1', '1', '向阳街道', '0', '', '1', '0', '0', '10'),
('5657', '150000', '150400', '150404', '1', '1', '松州街道', '0', '', '1', '0', '0', '10'),
('5658', '150000', '150400', '150404', '1', '1', '铁东街道', '0', '', '1', '0', '0', '10'),
('5659', '150000', '150400', '150404', '1', '1', '玉龙街道', '0', '', '1', '0', '0', '10'),
('5660', '150000', '150400', '150404', '1', '1', '富河街道', '0', '', '1', '0', '0', '10'),
('5661', '150000', '150400', '150404', '1', '1', '兴安街道', '0', '', '1', '0', '0', '10'),
('5662', '150000', '150400', '150404', '1', '1', '全宁街道', '0', '', '1', '0', '0', '10'),
('5663', '150000', '150400', '150404', '1', '1', '穆家营子镇', '0', '', '1', '0', '0', '10'),
('5664', '150000', '150400', '150404', '1', '1', '初头朗镇', '0', '', '1', '0', '0', '10'),
('5665', '150000', '150400', '150404', '1', '1', '大庙镇', '0', '', '1', '0', '0', '10'),
('5666', '150000', '150400', '150404', '1', '1', '王府镇', '0', '', '1', '0', '0', '10'),
('5667', '150000', '150400', '150404', '1', '1', '老府镇', '0', '', '1', '0', '0', '10'),
('5668', '150000', '150400', '150404', '1', '1', '哈拉道口镇', '0', '', '1', '0', '0', '10'),
('5669', '150000', '150400', '150404', '1', '1', '上官地镇', '0', '', '1', '0', '0', '10'),
('5670', '150000', '150400', '150404', '1', '1', '安庆镇', '0', '', '1', '0', '0', '10'),
('5671', '150000', '150400', '150404', '1', '1', '太平地镇', '0', '', '1', '0', '0', '10'),
('5672', '150000', '150400', '150404', '1', '1', '当铺地满族乡', '0', '', '1', '0', '0', '10'),
('5673', '150000', '150400', '150404', '1', '1', '夏家店乡', '0', '', '1', '0', '0', '10'),
('5674', '150000', '150400', '150404', '1', '1', '城子乡', '0', '', '1', '0', '0', '10'),
('5675', '150000', '150400', '150404', '1', '1', '大夫营子乡', '0', '', '1', '0', '0', '10'),
('5676', '150000', '150400', '150404', '1', '1', '岗子乡', '0', '', '1', '0', '0', '10'),
('5677', '150000', '150400', '150421', '1', '1', '天山', '0', '', '1', '0', '0', '10'),
('5678', '150000', '150400', '150421', '1', '1', '天山镇', '0', '', '1', '0', '0', '10'),
('5679', '150000', '150400', '150421', '1', '1', '天山口镇', '0', '', '1', '0', '0', '10');
INSERT INTO `wst_communitys` VALUES ('5680', '150000', '150400', '150421', '1', '1', '双胜镇', '0', '', '1', '0', '0', '10'),
('5681', '150000', '150400', '150421', '1', '1', '坤都镇', '0', '', '1', '0', '0', '10'),
('5682', '150000', '150400', '150421', '1', '1', '巴彦花镇', '0', '', '1', '0', '0', '10'),
('5683', '150000', '150400', '150421', '1', '1', '绍根镇', '0', '', '1', '0', '0', '10'),
('5684', '150000', '150400', '150421', '1', '1', '新民乡', '0', '', '1', '0', '0', '10'),
('5685', '150000', '150400', '150421', '1', '1', '先锋乡', '0', '', '1', '0', '0', '10'),
('5686', '150000', '150400', '150421', '1', '1', '罕苏木苏木乡', '0', '', '1', '0', '0', '10'),
('5687', '150000', '150400', '150421', '1', '1', '赛汉塔拉苏木乡', '0', '', '1', '0', '0', '10'),
('5688', '150000', '150400', '150421', '1', '1', '巴拉奇如德苏木乡', '0', '', '1', '0', '0', '10'),
('5689', '150000', '150400', '150422', '1', '1', '林东西城街道', '0', '', '1', '0', '0', '10'),
('5690', '150000', '150400', '150422', '1', '1', '林东东城街道', '0', '', '1', '0', '0', '10'),
('5691', '150000', '150400', '150422', '1', '1', '林东镇', '0', '', '1', '0', '0', '10'),
('5692', '150000', '150400', '150422', '1', '1', '隆昌镇', '0', '', '1', '0', '0', '10'),
('5693', '150000', '150400', '150422', '1', '1', '十三敖包镇', '0', '', '1', '0', '0', '10'),
('5694', '150000', '150400', '150422', '1', '1', '碧流台镇', '0', '', '1', '0', '0', '10'),
('5695', '150000', '150400', '150422', '1', '1', '富河镇', '0', '', '1', '0', '0', '10'),
('5696', '150000', '150400', '150422', '1', '1', '白音诺尔镇', '0', '', '1', '0', '0', '10'),
('5697', '150000', '150400', '150422', '1', '1', '哈拉哈达镇', '0', '', '1', '0', '0', '10'),
('5698', '150000', '150400', '150422', '1', '1', '查干哈达苏木乡', '0', '', '1', '0', '0', '10'),
('5699', '150000', '150400', '150422', '1', '1', '乌兰达坝苏木乡', '0', '', '1', '0', '0', '10'),
('5700', '150000', '150400', '150423', '1', '1', '大板镇', '0', '', '1', '0', '0', '10'),
('5701', '150000', '150400', '150423', '1', '1', '索博日嘎镇', '0', '', '1', '0', '0', '10'),
('5702', '150000', '150400', '150423', '1', '1', '宝日勿苏镇', '0', '', '1', '0', '0', '10'),
('5703', '150000', '150400', '150423', '1', '1', '查干诺尔镇', '0', '', '1', '0', '0', '10'),
('5704', '150000', '150400', '150423', '1', '1', '查干沐沦镇', '0', '', '1', '0', '0', '10'),
('5705', '150000', '150400', '150423', '1', '1', '西拉沐沦苏木乡', '0', '', '1', '0', '0', '10'),
('5706', '150000', '150400', '150423', '1', '1', '巴彦塔拉苏木乡', '0', '', '1', '0', '0', '10'),
('5707', '150000', '150400', '150423', '1', '1', '幸福之路苏木乡', '0', '', '1', '0', '0', '10'),
('5708', '150000', '150400', '150424', '1', '1', '林西街道', '0', '', '1', '0', '0', '10'),
('5709', '150000', '150400', '150424', '1', '1', '林西镇', '0', '', '1', '0', '0', '10'),
('5710', '150000', '150400', '150424', '1', '1', '新城子镇', '0', '', '1', '0', '0', '10'),
('5711', '150000', '150400', '150424', '1', '1', '新林镇', '0', '', '1', '0', '0', '10'),
('5712', '150000', '150400', '150424', '1', '1', '五十家子镇', '0', '', '1', '0', '0', '10'),
('5713', '150000', '150400', '150424', '1', '1', '官地镇', '0', '', '1', '0', '0', '10'),
('5714', '150000', '150400', '150424', '1', '1', '大井镇', '0', '', '1', '0', '0', '10'),
('5715', '150000', '150400', '150424', '1', '1', '统部镇', '0', '', '1', '0', '0', '10'),
('5716', '150000', '150400', '150424', '1', '1', '大营子乡', '0', '', '1', '0', '0', '10'),
('5717', '150000', '150400', '150425', '1', '1', '经棚镇', '0', '', '1', '0', '0', '10'),
('5718', '150000', '150400', '150425', '1', '1', '宇宙地镇', '0', '', '1', '0', '0', '10'),
('5719', '150000', '150400', '150425', '1', '1', '土城子镇', '0', '', '1', '0', '0', '10'),
('5720', '150000', '150400', '150425', '1', '1', '同兴镇', '0', '', '1', '0', '0', '10'),
('5721', '150000', '150400', '150425', '1', '1', '万合永镇', '0', '', '1', '0', '0', '10'),
('5722', '150000', '150400', '150425', '1', '1', '芝瑞镇', '0', '', '1', '0', '0', '10'),
('5723', '150000', '150400', '150425', '1', '1', '达来诺日镇', '0', '', '1', '0', '0', '10'),
('5724', '150000', '150400', '150425', '1', '1', '新开地乡', '0', '', '1', '0', '0', '10'),
('5725', '150000', '150400', '150425', '1', '1', '红山子乡', '0', '', '1', '0', '0', '10'),
('5726', '150000', '150400', '150425', '1', '1', '达日罕乌拉苏木乡', '0', '', '1', '0', '0', '10'),
('5727', '150000', '150400', '150425', '1', '1', '巴彦查干苏木乡', '0', '', '1', '0', '0', '10'),
('5728', '150000', '150400', '150426', '1', '1', '乌丹镇', '0', '', '1', '0', '0', '10'),
('5729', '150000', '150400', '150426', '1', '1', '乌敦套海镇', '0', '', '1', '0', '0', '10'),
('5730', '150000', '150400', '150426', '1', '1', '五分地镇', '0', '', '1', '0', '0', '10'),
('5731', '150000', '150400', '150426', '1', '1', '桥头镇', '0', '', '1', '0', '0', '10'),
('5732', '150000', '150400', '150426', '1', '1', '广德公镇', '0', '', '1', '0', '0', '10'),
('5733', '150000', '150400', '150426', '1', '1', '梧桐花镇', '0', '', '1', '0', '0', '10'),
('5734', '150000', '150400', '150426', '1', '1', '海日苏镇', '0', '', '1', '0', '0', '10'),
('5735', '150000', '150400', '150426', '1', '1', '亿合公镇', '0', '', '1', '0', '0', '10'),
('5736', '150000', '150400', '150426', '1', '1', '解放营子乡', '0', '', '1', '0', '0', '10'),
('5737', '150000', '150400', '150426', '1', '1', '阿什罕苏木乡', '0', '', '1', '0', '0', '10'),
('5738', '150000', '150400', '150426', '1', '1', '白音他拉苏木乡', '0', '', '1', '0', '0', '10'),
('5739', '150000', '150400', '150426', '1', '1', '白音套海苏木乡', '0', '', '1', '0', '0', '10'),
('5740', '150000', '150400', '150428', '1', '1', '锦山镇', '0', '', '1', '0', '0', '10'),
('5741', '150000', '150400', '150428', '1', '1', '美林镇', '0', '', '1', '0', '0', '10'),
('5742', '150000', '150400', '150428', '1', '1', '王爷府镇', '0', '', '1', '0', '0', '10'),
('5743', '150000', '150400', '150428', '1', '1', '小牛群镇', '0', '', '1', '0', '0', '10'),
('5744', '150000', '150400', '150428', '1', '1', '牛家营子镇', '0', '', '1', '0', '0', '10'),
('5745', '150000', '150400', '150428', '1', '1', '乃林镇', '0', '', '1', '0', '0', '10'),
('5746', '150000', '150400', '150428', '1', '1', '西桥镇', '0', '', '1', '0', '0', '10'),
('5747', '150000', '150400', '150428', '1', '1', '十家满族乡', '0', '', '1', '0', '0', '10'),
('5748', '150000', '150400', '150428', '1', '1', '乃林果树农场', '0', '', '1', '0', '0', '10'),
('5749', '150000', '150400', '150428', '1', '1', '马鞍山羊场', '0', '', '1', '0', '0', '10'),
('5750', '150000', '150400', '150429', '1', '1', '天义镇政府', '0', '', '1', '0', '0', '10'),
('5751', '150000', '150400', '150429', '1', '1', '小城子镇政府', '0', '', '1', '0', '0', '10'),
('5752', '150000', '150400', '150429', '1', '1', '大城子镇政府', '0', '', '1', '0', '0', '10'),
('5753', '150000', '150400', '150429', '1', '1', '八里罕镇政府', '0', '', '1', '0', '0', '10'),
('5754', '150000', '150400', '150429', '1', '1', '黑里河镇政府', '0', '', '1', '0', '0', '10'),
('5755', '150000', '150400', '150429', '1', '1', '甸子镇政府', '0', '', '1', '0', '0', '10'),
('5756', '150000', '150400', '150429', '1', '1', '大双庙镇政府', '0', '', '1', '0', '0', '10'),
('5757', '150000', '150400', '150429', '1', '1', '汐子镇政府', '0', '', '1', '0', '0', '10'),
('5758', '150000', '150400', '150429', '1', '1', '大明镇政府', '0', '', '1', '0', '0', '10'),
('5759', '150000', '150400', '150429', '1', '1', '忙农镇政府', '0', '', '1', '0', '0', '10'),
('5760', '150000', '150400', '150429', '1', '1', '三座店乡政府', '0', '', '1', '0', '0', '10'),
('5761', '150000', '150400', '150429', '1', '1', '必斯营子乡政府', '0', '', '1', '0', '0', '10'),
('5762', '150000', '150400', '150429', '1', '1', '五化乡政府', '0', '', '1', '0', '0', '10'),
('5763', '150000', '150400', '150430', '1', '1', '新惠镇', '0', '', '1', '0', '0', '10'),
('5764', '150000', '150400', '150430', '1', '1', '四家子镇', '0', '', '1', '0', '0', '10'),
('5765', '150000', '150400', '150430', '1', '1', '长胜镇', '0', '', '1', '0', '0', '10'),
('5766', '150000', '150400', '150430', '1', '1', '贝子府镇', '0', '', '1', '0', '0', '10'),
('5767', '150000', '150400', '150430', '1', '1', '四道湾子镇', '0', '', '1', '0', '0', '10'),
('5768', '150000', '150400', '150430', '1', '1', '下洼镇', '0', '', '1', '0', '0', '10'),
('5769', '150000', '150400', '150430', '1', '1', '金厂沟梁镇', '0', '', '1', '0', '0', '10'),
('5770', '150000', '150400', '150430', '1', '1', '宝国吐乡', '0', '', '1', '0', '0', '10'),
('5771', '150000', '150400', '150430', '1', '1', '牛古吐乡', '0', '', '1', '0', '0', '10'),
('5772', '150000', '150400', '150430', '1', '1', '木头营子乡', '0', '', '1', '0', '0', '10'),
('5773', '150000', '150400', '150430', '1', '1', '古鲁板蒿乡', '0', '', '1', '0', '0', '10'),
('5774', '150000', '150400', '150430', '1', '1', '丰收乡', '0', '', '1', '0', '0', '10'),
('5775', '150000', '150400', '150430', '1', '1', '玛尼罕乡', '0', '', '1', '0', '0', '10'),
('5776', '150000', '150400', '150430', '1', '1', '萨力巴乡', '0', '', '1', '0', '0', '10'),
('5777', '150000', '150400', '150430', '1', '1', '敖润苏莫苏木乡', '0', '', '1', '0', '0', '10'),
('5778', '150000', '150500', '150502', '1', '1', '科尔沁街道', '0', '', '1', '0', '0', '10'),
('5779', '150000', '150500', '150502', '1', '1', '西门街道', '0', '', '1', '0', '0', '10'),
('5780', '150000', '150500', '150502', '1', '1', '永清街道', '0', '', '1', '0', '0', '10'),
('5781', '150000', '150500', '150502', '1', '1', '明仁街道', '0', '', '1', '0', '0', '10'),
('5782', '150000', '150500', '150502', '1', '1', '施介街道', '0', '', '1', '0', '0', '10'),
('5783', '150000', '150500', '150502', '1', '1', '清真街道', '0', '', '1', '0', '0', '10'),
('5784', '150000', '150500', '150502', '1', '1', '东郊街道', '0', '', '1', '0', '0', '10'),
('5785', '150000', '150500', '150502', '1', '1', '铁路街道', '0', '', '1', '0', '0', '10'),
('5786', '150000', '150500', '150502', '1', '1', '红星街道', '0', '', '1', '0', '0', '10'),
('5787', '150000', '150500', '150502', '1', '1', '霍林街道', '0', '', '1', '0', '0', '10'),
('5788', '150000', '150500', '150502', '1', '1', '建国街道', '0', '', '1', '0', '0', '10'),
('5789', '150000', '150500', '150502', '1', '1', '河西街道', '0', '', '1', '0', '0', '10'),
('5790', '150000', '150500', '150502', '1', '1', '电厂街道', '0', '', '1', '0', '0', '10'),
('5791', '150000', '150500', '150502', '1', '1', '大林镇', '0', '', '1', '0', '0', '10'),
('5792', '150000', '150500', '150502', '1', '1', '钱家店镇', '0', '', '1', '0', '0', '10'),
('5793', '150000', '150500', '150502', '1', '1', '余粮堡镇', '0', '', '1', '0', '0', '10'),
('5794', '150000', '150500', '150502', '1', '1', '木里图镇', '0', '', '1', '0', '0', '10'),
('5795', '150000', '150500', '150502', '1', '1', '丰田镇', '0', '', '1', '0', '0', '10'),
('5796', '150000', '150500', '150502', '1', '1', '清河镇', '0', '', '1', '0', '0', '10'),
('5797', '150000', '150500', '150502', '1', '1', '育新镇', '0', '', '1', '0', '0', '10'),
('5798', '150000', '150500', '150502', '1', '1', '庆和镇', '0', '', '1', '0', '0', '10'),
('5799', '150000', '150500', '150502', '1', '1', '敖力布皋镇', '0', '', '1', '0', '0', '10'),
('5800', '150000', '150500', '150502', '1', '1', '辽河镇', '0', '', '1', '0', '0', '10'),
('5801', '150000', '150500', '150502', '1', '1', '莫力庙苏木乡', '0', '', '1', '0', '0', '10'),
('5802', '150000', '150500', '150502', '1', '1', '哲南农场', '0', '', '1', '0', '0', '10'),
('5803', '150000', '150500', '150502', '1', '1', '三义堂农场', '0', '', '1', '0', '0', '10'),
('5804', '150000', '150500', '150502', '1', '1', '高林屯种畜场', '0', '', '1', '0', '0', '10'),
('5805', '150000', '150500', '150502', '1', '1', '胡力海原种繁殖场', '0', '', '1', '0', '0', '10'),
('5806', '150000', '150500', '150502', '1', '1', '莫力庙羊场', '0', '', '1', '0', '0', '10'),
('5807', '150000', '150500', '150502', '1', '1', '半截店牧场', '0', '', '1', '0', '0', '10'),
('5808', '150000', '150500', '150521', '1', '1', '保康镇', '0', '', '1', '0', '0', '10'),
('5809', '150000', '150500', '150521', '1', '1', '宝龙山镇', '0', '', '1', '0', '0', '10'),
('5810', '150000', '150500', '150521', '1', '1', '舍伯吐镇', '0', '', '1', '0', '0', '10'),
('5811', '150000', '150500', '150521', '1', '1', '巴彦塔拉镇', '0', '', '1', '0', '0', '10'),
('5812', '150000', '150500', '150521', '1', '1', '门达镇', '0', '', '1', '0', '0', '10'),
('5813', '150000', '150500', '150521', '1', '1', '架玛吐镇', '0', '', '1', '0', '0', '10'),
('5814', '150000', '150500', '150521', '1', '1', '腰林毛都镇', '0', '', '1', '0', '0', '10'),
('5815', '150000', '150500', '150521', '1', '1', '希伯花镇', '0', '', '1', '0', '0', '10'),
('5816', '150000', '150500', '150521', '1', '1', '花吐古拉镇', '0', '', '1', '0', '0', '10'),
('5817', '150000', '150500', '150521', '1', '1', '代力吉镇', '0', '', '1', '0', '0', '10'),
('5818', '150000', '150500', '150521', '1', '1', '努日木镇', '0', '', '1', '0', '0', '10'),
('5819', '150000', '150500', '150521', '1', '1', '花胡硕苏木乡', '0', '', '1', '0', '0', '10'),
('5820', '150000', '150500', '150521', '1', '1', '协代苏木乡', '0', '', '1', '0', '0', '10'),
('5821', '150000', '150500', '150521', '1', '1', '白兴吐苏木乡', '0', '', '1', '0', '0', '10'),
('5822', '150000', '150500', '150521', '1', '1', '图布信苏木乡', '0', '', '1', '0', '0', '10'),
('5823', '150000', '150500', '150521', '1', '1', '东苏林场', '0', '', '1', '0', '0', '10'),
('5824', '150000', '150500', '150522', '1', '1', '甘旗卡镇', '0', '', '1', '0', '0', '10'),
('5825', '150000', '150500', '150522', '1', '1', '吉尔嘎朗镇', '0', '', '1', '0', '0', '10'),
('5826', '150000', '150500', '150522', '1', '1', '金宝屯镇', '0', '', '1', '0', '0', '10'),
('5827', '150000', '150500', '150522', '1', '1', '常胜镇', '0', '', '1', '0', '0', '10'),
('5828', '150000', '150500', '150522', '1', '1', '查日苏镇', '0', '', '1', '0', '0', '10'),
('5829', '150000', '150500', '150522', '1', '1', '双胜镇', '0', '', '1', '0', '0', '10'),
('5830', '150000', '150500', '150522', '1', '1', '阿古拉镇', '0', '', '1', '0', '0', '10'),
('5831', '150000', '150500', '150522', '1', '1', '朝鲁吐镇', '0', '', '1', '0', '0', '10'),
('5832', '150000', '150500', '150522', '1', '1', '努古斯台镇', '0', '', '1', '0', '0', '10'),
('5833', '150000', '150500', '150522', '1', '1', '海鲁吐镇', '0', '', '1', '0', '0', '10'),
('5834', '150000', '150500', '150522', '1', '1', '阿都沁苏木乡', '0', '', '1', '0', '0', '10'),
('5835', '150000', '150500', '150522', '1', '1', '茂道吐苏木乡', '0', '', '1', '0', '0', '10'),
('5836', '150000', '150500', '150522', '1', '1', '胜利农场', '0', '', '1', '0', '0', '10'),
('5837', '150000', '150500', '150522', '1', '1', '孟根达坝牧场', '0', '', '1', '0', '0', '10'),
('5838', '150000', '150500', '150522', '1', '1', '查金台牧场', '0', '', '1', '0', '0', '10'),
('5839', '150000', '150500', '150522', '1', '1', '原种场', '0', '', '1', '0', '0', '10'),
('5840', '150000', '150500', '150522', '1', '1', '大青沟管理局', '0', '', '1', '0', '0', '10'),
('5841', '150000', '150500', '150522', '1', '1', '哈日乌苏种畜场', '0', '', '1', '0', '0', '10'),
('5842', '150000', '150500', '150522', '1', '1', '乌兰敖道渔场', '0', '', '1', '0', '0', '10'),
('5843', '150000', '150500', '150522', '1', '1', '金宝屯林场', '0', '', '1', '0', '0', '10'),
('5844', '150000', '150500', '150522', '1', '1', '朝鲁吐林场', '0', '', '1', '0', '0', '10'),
('5845', '150000', '150500', '150522', '1', '1', '茂道吐林场', '0', '', '1', '0', '0', '10'),
('5846', '150000', '150500', '150522', '1', '1', '伊胡塔林场', '0', '', '1', '0', '0', '10'),
('5847', '150000', '150500', '150522', '1', '1', '乌旦塔拉林场', '0', '', '1', '0', '0', '10'),
('5848', '150000', '150500', '150523', '1', '1', '开鲁镇', '0', '', '1', '0', '0', '10'),
('5849', '150000', '150500', '150523', '1', '1', '大榆树镇', '0', '', '1', '0', '0', '10'),
('5850', '150000', '150500', '150523', '1', '1', '黑龙坝镇', '0', '', '1', '0', '0', '10'),
('5851', '150000', '150500', '150523', '1', '1', '麦新镇', '0', '', '1', '0', '0', '10'),
('5852', '150000', '150500', '150523', '1', '1', '义和塔拉镇', '0', '', '1', '0', '0', '10'),
('5853', '150000', '150500', '150523', '1', '1', '建华镇', '0', '', '1', '0', '0', '10'),
('5854', '150000', '150500', '150523', '1', '1', '小街基镇', '0', '', '1', '0', '0', '10'),
('5855', '150000', '150500', '150523', '1', '1', '东风镇', '0', '', '1', '0', '0', '10'),
('5856', '150000', '150500', '150523', '1', '1', '吉日嘎郎吐镇', '0', '', '1', '0', '0', '10'),
('5857', '150000', '150500', '150523', '1', '1', '东来镇', '0', '', '1', '0', '0', '10'),
('5858', '150000', '150500', '150523', '1', '1', '清河牧场', '0', '', '1', '0', '0', '10'),
('5859', '150000', '150500', '150523', '1', '1', '辽河农场', '0', '', '1', '0', '0', '10'),
('5860', '150000', '150500', '150523', '1', '1', '保安农场', '0', '', '1', '0', '0', '10'),
('5861', '150000', '150500', '150524', '1', '1', '库伦镇', '0', '', '1', '0', '0', '10'),
('5862', '150000', '150500', '150524', '1', '1', '扣河子镇', '0', '', '1', '0', '0', '10'),
('5863', '150000', '150500', '150524', '1', '1', '白音花镇', '0', '', '1', '0', '0', '10'),
('5864', '150000', '150500', '150524', '1', '1', '六家子镇', '0', '', '1', '0', '0', '10'),
('5865', '150000', '150500', '150524', '1', '1', '额勒顺镇', '0', '', '1', '0', '0', '10'),
('5866', '150000', '150500', '150524', '1', '1', '茫汗苏木乡', '0', '', '1', '0', '0', '10'),
('5867', '150000', '150500', '150525', '1', '1', '大沁他拉镇', '0', '', '1', '0', '0', '10'),
('5868', '150000', '150500', '150525', '1', '1', '八仙筒镇', '0', '', '1', '0', '0', '10'),
('5869', '150000', '150500', '150525', '1', '1', '青龙山镇', '0', '', '1', '0', '0', '10'),
('5870', '150000', '150500', '150525', '1', '1', '新镇', '0', '', '1', '0', '0', '10'),
('5871', '150000', '150500', '150525', '1', '1', '治安镇', '0', '', '1', '0', '0', '10'),
('5872', '150000', '150500', '150525', '1', '1', '东明镇', '0', '', '1', '0', '0', '10'),
('5873', '150000', '150500', '150525', '1', '1', '土城子镇', '0', '', '1', '0', '0', '10'),
('5874', '150000', '150500', '150525', '1', '1', '义隆永镇', '0', '', '1', '0', '0', '10'),
('5875', '150000', '150500', '150525', '1', '1', '固日班花苏木乡', '0', '', '1', '0', '0', '10'),
('5876', '150000', '150500', '150525', '1', '1', '苇莲苏苏木乡', '0', '', '1', '0', '0', '10'),
('5877', '150000', '150500', '150525', '1', '1', '明仁苏木乡', '0', '', '1', '0', '0', '10'),
('5878', '150000', '150500', '150525', '1', '1', '黄花塔拉苏木乡', '0', '', '1', '0', '0', '10'),
('5879', '150000', '150500', '150525', '1', '1', '国有六号农场', '0', '', '1', '0', '0', '10'),
('5880', '150000', '150500', '150526', '1', '1', '鲁北镇', '0', '', '1', '0', '0', '10'),
('5881', '150000', '150500', '150526', '1', '1', '黄花山镇', '0', '', '1', '0', '0', '10'),
('5882', '150000', '150500', '150526', '1', '1', '嘎亥图镇', '0', '', '1', '0', '0', '10'),
('5883', '150000', '150500', '150526', '1', '1', '巨日合镇', '0', '', '1', '0', '0', '10'),
('5884', '150000', '150500', '150526', '1', '1', '巴雅尔图胡硕镇', '0', '', '1', '0', '0', '10'),
('5885', '150000', '150500', '150526', '1', '1', '香山镇', '0', '', '1', '0', '0', '10'),
('5886', '150000', '150500', '150526', '1', '1', '阿日昆都冷镇', '0', '', '1', '0', '0', '10'),
('5887', '150000', '150500', '150526', '1', '1', '巴彦塔拉苏木乡', '0', '', '1', '0', '0', '10'),
('5888', '150000', '150500', '150526', '1', '1', '乌力吉木仁苏木乡', '0', '', '1', '0', '0', '10'),
('5889', '150000', '150500', '150526', '1', '1', '道老杜苏木乡', '0', '', '1', '0', '0', '10'),
('5890', '150000', '150500', '150526', '1', '1', '格日朝鲁苏木乡', '0', '', '1', '0', '0', '10'),
('5891', '150000', '150500', '150526', '1', '1', '乌额格其牧场', '0', '', '1', '0', '0', '10'),
('5892', '150000', '150500', '150526', '1', '1', '香山农场', '0', '', '1', '0', '0', '10'),
('5893', '150000', '150500', '150526', '1', '1', '乌日根塔拉农场', '0', '', '1', '0', '0', '10'),
('5894', '150000', '150500', '150526', '1', '1', '嘎达苏种畜场', '0', '', '1', '0', '0', '10'),
('5895', '150000', '150500', '150581', '1', '1', '珠斯花街道', '0', '', '1', '0', '0', '10'),
('5896', '150000', '150500', '150581', '1', '1', '莫斯台街道', '0', '', '1', '0', '0', '10'),
('5897', '150000', '150500', '150581', '1', '1', '宝日呼吉尔街道', '0', '', '1', '0', '0', '10'),
('5898', '150000', '150500', '150581', '1', '1', '沙尔呼热街道', '0', '', '1', '0', '0', '10'),
('5899', '150000', '150500', '150581', '1', '1', '达来胡硕街道', '0', '', '1', '0', '0', '10'),
('5900', '150000', '150500', '150581', '1', '1', '东蒙农牧业有限责任公司', '0', '', '1', '0', '0', '10'),
('5901', '150000', '150600', '150602', '1', '1', '交通街道', '0', '', '1', '0', '0', '10'),
('5902', '150000', '150600', '150602', '1', '1', '公园街道', '0', '', '1', '0', '0', '10'),
('5903', '150000', '150600', '150602', '1', '1', '林荫街道', '0', '', '1', '0', '0', '10'),
('5904', '150000', '150600', '150602', '1', '1', '建设街道', '0', '', '1', '0', '0', '10'),
('5905', '150000', '150600', '150602', '1', '1', '富兴街道', '0', '', '1', '0', '0', '10'),
('5906', '150000', '150600', '150602', '1', '1', '天骄街道', '0', '', '1', '0', '0', '10'),
('5907', '150000', '150600', '150602', '1', '1', '哈巴格希街道', '0', '', '1', '0', '0', '10'),
('5908', '150000', '150600', '150602', '1', '1', '诃额伦街道', '0', '', '1', '0', '0', '10'),
('5909', '150000', '150600', '150602', '1', '1', '巴音孟克街道', '0', '', '1', '0', '0', '10'),
('5910', '150000', '150600', '150602', '1', '1', '泊尔江海子镇', '0', '', '1', '0', '0', '10'),
('5911', '150000', '150600', '150602', '1', '1', '罕台镇', '0', '', '1', '0', '0', '10'),
('5912', '150000', '150600', '150602', '1', '1', '塔拉壕镇', '0', '', '1', '0', '0', '10'),
('5913', '150000', '150600', '150621', '1', '1', '树林召镇', '0', '', '1', '0', '0', '10'),
('5914', '150000', '150600', '150621', '1', '1', '吉格斯太镇', '0', '', '1', '0', '0', '10'),
('5915', '150000', '150600', '150621', '1', '1', '白泥井镇', '0', '', '1', '0', '0', '10'),
('5916', '150000', '150600', '150621', '1', '1', '王爱召镇', '0', '', '1', '0', '0', '10'),
('5917', '150000', '150600', '150621', '1', '1', '昭君镇', '0', '', '1', '0', '0', '10'),
('5918', '150000', '150600', '150621', '1', '1', '恩格贝镇', '0', '', '1', '0', '0', '10'),
('5919', '150000', '150600', '150621', '1', '1', '中和西镇', '0', '', '1', '0', '0', '10'),
('5920', '150000', '150600', '150621', '1', '1', '展旦召苏木乡', '0', '', '1', '0', '0', '10'),
('5921', '150000', '150600', '150622', '1', '1', '薛家湾镇', '0', '', '1', '0', '0', '10'),
('5922', '150000', '150600', '150622', '1', '1', '沙圪堵镇', '0', '', '1', '0', '0', '10'),
('5923', '150000', '150600', '150622', '1', '1', '大路镇', '0', '', '1', '0', '0', '10'),
('5924', '150000', '150600', '150622', '1', '1', '纳日松镇', '0', '', '1', '0', '0', '10'),
('5925', '150000', '150600', '150622', '1', '1', '龙口镇', '0', '', '1', '0', '0', '10'),
('5926', '150000', '150600', '150622', '1', '1', '准格尔召镇', '0', '', '1', '0', '0', '10'),
('5927', '150000', '150600', '150622', '1', '1', '暖水乡', '0', '', '1', '0', '0', '10'),
('5928', '150000', '150600', '150622', '1', '1', '十二连城乡', '0', '', '1', '0', '0', '10'),
('5929', '150000', '150600', '150622', '1', '1', '布尔陶亥苏木乡', '0', '', '1', '0', '0', '10'),
('5930', '150000', '150600', '150623', '1', '1', '敖勒召其镇', '0', '', '1', '0', '0', '10'),
('5931', '150000', '150600', '150623', '1', '1', '上海庙镇', '0', '', '1', '0', '0', '10'),
('5932', '150000', '150600', '150623', '1', '1', '城川镇', '0', '', '1', '0', '0', '10'),
('5933', '150000', '150600', '150623', '1', '1', '昂素镇', '0', '', '1', '0', '0', '10'),
('5934', '150000', '150600', '150623', '1', '1', '上海庙经济开发区', '0', '', '1', '0', '0', '10'),
('5935', '150000', '150600', '150624', '1', '1', '乌兰镇', '0', '', '1', '0', '0', '10'),
('5936', '150000', '150600', '150624', '1', '1', '棋盘井镇', '0', '', '1', '0', '0', '10'),
('5937', '150000', '150600', '150624', '1', '1', '蒙西镇', '0', '', '1', '0', '0', '10'),
('5938', '150000', '150600', '150624', '1', '1', '木凯淖尔镇', '0', '', '1', '0', '0', '10'),
('5939', '150000', '150600', '150624', '1', '1', '苏米图苏木乡', '0', '', '1', '0', '0', '10'),
('5940', '150000', '150600', '150624', '1', '1', '阿尔巴斯苏木乡', '0', '', '1', '0', '0', '10'),
('5941', '150000', '150600', '150624', '1', '1', '鄂托克旗赛乌素草籽场', '0', '', '1', '0', '0', '10'),
('5942', '150000', '150600', '150624', '1', '1', '内蒙古白绒山羊种羊场', '0', '', '1', '0', '0', '10'),
('5943', '150000', '150600', '150625', '1', '1', '锡尼镇', '0', '', '1', '0', '0', '10'),
('5944', '150000', '150600', '150625', '1', '1', '巴拉贡镇', '0', '', '1', '0', '0', '10'),
('5945', '150000', '150600', '150625', '1', '1', '吉日嘎朗图镇', '0', '', '1', '0', '0', '10'),
('5946', '150000', '150600', '150625', '1', '1', '独贵塔拉镇', '0', '', '1', '0', '0', '10'),
('5947', '150000', '150600', '150625', '1', '1', '呼和木都镇', '0', '', '1', '0', '0', '10'),
('5948', '150000', '150600', '150625', '1', '1', '杭锦淖尔乡', '0', '', '1', '0', '0', '10'),
('5949', '150000', '150600', '150625', '1', '1', '伊和乌素苏木乡', '0', '', '1', '0', '0', '10'),
('5950', '150000', '150600', '150625', '1', '1', '哈拉淖农场', '0', '', '1', '0', '0', '10'),
('5951', '150000', '150600', '150626', '1', '1', '嘎鲁图镇', '0', '', '1', '0', '0', '10'),
('5952', '150000', '150600', '150626', '1', '1', '乌审召镇', '0', '', '1', '0', '0', '10'),
('5953', '150000', '150600', '150626', '1', '1', '图克镇', '0', '', '1', '0', '0', '10'),
('5954', '150000', '150600', '150626', '1', '1', '乌兰陶勒盖镇', '0', '', '1', '0', '0', '10'),
('5955', '150000', '150600', '150626', '1', '1', '无定河镇', '0', '', '1', '0', '0', '10'),
('5956', '150000', '150600', '150626', '1', '1', '苏力德苏木乡', '0', '', '1', '0', '0', '10'),
('5957', '150000', '150600', '150626', '1', '1', '种羊场', '0', '', '1', '0', '0', '10'),
('5958', '150000', '150600', '150626', '1', '1', '五个林场', '0', '', '1', '0', '0', '10'),
('5959', '150000', '150600', '150627', '1', '1', '阿勒腾席热镇', '0', '', '1', '0', '0', '10'),
('5960', '150000', '150600', '150627', '1', '1', '札萨克镇', '0', '', '1', '0', '0', '10'),
('5961', '150000', '150600', '150627', '1', '1', '乌兰木伦镇', '0', '', '1', '0', '0', '10'),
('5962', '150000', '150600', '150627', '1', '1', '纳林陶亥镇', '0', '', '1', '0', '0', '10'),
('5963', '150000', '150600', '150627', '1', '1', '苏布尔嘎镇', '0', '', '1', '0', '0', '10'),
('5964', '150000', '150600', '150627', '1', '1', '红庆河镇', '0', '', '1', '0', '0', '10'),
('5965', '150000', '150600', '150627', '1', '1', '伊金霍洛镇', '0', '', '1', '0', '0', '10'),
('5966', '150000', '150700', '150702', '1', '1', '正阳', '0', '', '1', '0', '0', '10'),
('5967', '150000', '150700', '150702', '1', '1', '健康街道', '0', '', '1', '0', '0', '10'),
('5968', '150000', '150700', '150702', '1', '1', '靠山街道', '0', '', '1', '0', '0', '10'),
('5969', '150000', '150700', '150702', '1', '1', '胜利街道', '0', '', '1', '0', '0', '10'),
('5970', '150000', '150700', '150702', '1', '1', '呼伦街道', '0', '', '1', '0', '0', '10'),
('5971', '150000', '150700', '150702', '1', '1', '奋斗街道', '0', '', '1', '0', '0', '10'),
('5972', '150000', '150700', '150702', '1', '1', '建设街道', '0', '', '1', '0', '0', '10'),
('5973', '150000', '150700', '150702', '1', '1', '哈克镇', '0', '', '1', '0', '0', '10'),
('5974', '150000', '150700', '150702', '1', '1', '谢尔塔拉种牛场', '0', '', '1', '0', '0', '10'),
('5975', '150000', '150700', '150702', '1', '1', '哈克牧业有限公司', '0', '', '1', '0', '0', '10'),
('5976', '150000', '150700', '150721', '1', '1', '那吉镇', '0', '', '1', '0', '0', '10'),
('5977', '150000', '150700', '150721', '1', '1', '六合镇', '0', '', '1', '0', '0', '10'),
('5978', '150000', '150700', '150721', '1', '1', '亚东镇', '0', '', '1', '0', '0', '10'),
('5979', '150000', '150700', '150721', '1', '1', '霍尔奇镇', '0', '', '1', '0', '0', '10'),
('5980', '150000', '150700', '150721', '1', '1', '向阳峪镇', '0', '', '1', '0', '0', '10'),
('5981', '150000', '150700', '150721', '1', '1', '得力其鄂温克民族乡', '0', '', '1', '0', '0', '10'),
('5982', '150000', '150700', '150721', '1', '1', '查巴奇鄂温克民族乡', '0', '', '1', '0', '0', '10'),
('5983', '150000', '150700', '150721', '1', '1', '音河达斡尔鄂温克民族乡', '0', '', '1', '0', '0', '10'),
('5984', '150000', '150700', '150721', '1', '1', '新发朝鲜民族乡', '0', '', '1', '0', '0', '10'),
('5985', '150000', '150700', '150721', '1', '1', '那吉屯农场', '0', '', '1', '0', '0', '10'),
('5986', '150000', '150700', '150721', '1', '1', '格尼河农场', '0', '', '1', '0', '0', '10'),
('5987', '150000', '150700', '150721', '1', '1', '阿荣旗林业局', '0', '', '1', '0', '0', '10'),
('5988', '150000', '150700', '150722', '1', '1', '尼尔基镇', '0', '', '1', '0', '0', '10'),
('5989', '150000', '150700', '150722', '1', '1', '红彦镇', '0', '', '1', '0', '0', '10'),
('5990', '150000', '150700', '150722', '1', '1', '宝山镇', '0', '', '1', '0', '0', '10'),
('5991', '150000', '150700', '150722', '1', '1', '哈达阳镇', '0', '', '1', '0', '0', '10'),
('5992', '150000', '150700', '150722', '1', '1', '阿尔拉镇', '0', '', '1', '0', '0', '10'),
('5993', '150000', '150700', '150722', '1', '1', '西瓦尔图镇', '0', '', '1', '0', '0', '10'),
('5994', '150000', '150700', '150722', '1', '1', '腾克镇', '0', '', '1', '0', '0', '10'),
('5995', '150000', '150700', '150722', '1', '1', '塔温敖宝镇', '0', '', '1', '0', '0', '10'),
('5996', '150000', '150700', '150722', '1', '1', '巴彦鄂温克民族乡', '0', '', '1', '0', '0', '10'),
('5997', '150000', '150700', '150722', '1', '1', '杜拉尔鄂温克民族乡', '0', '', '1', '0', '0', '10'),
('5998', '150000', '150700', '150722', '1', '1', '国营甘河农场', '0', '', '1', '0', '0', '10'),
('5999', '150000', '150700', '150722', '1', '1', '国营巴彦农场', '0', '', '1', '0', '0', '10'),
('6000', '150000', '150700', '150722', '1', '1', '国营欧肯河农场', '0', '', '1', '0', '0', '10'),
('6001', '150000', '150700', '150722', '1', '1', '国营东方红农场', '0', '', '1', '0', '0', '10'),
('6002', '150000', '150700', '150723', '1', '1', '阿里河镇', '0', '', '1', '0', '0', '10'),
('6003', '150000', '150700', '150723', '1', '1', '大杨树镇', '0', '', '1', '0', '0', '10'),
('6004', '150000', '150700', '150723', '1', '1', '甘河镇', '0', '', '1', '0', '0', '10'),
('6005', '150000', '150700', '150723', '1', '1', '托扎敏镇', '0', '', '1', '0', '0', '10'),
('6006', '150000', '150700', '150723', '1', '1', '诺敏镇', '0', '', '1', '0', '0', '10'),
('6007', '150000', '150700', '150723', '1', '1', '乌鲁布铁镇', '0', '', '1', '0', '0', '10'),
('6008', '150000', '150700', '150723', '1', '1', '古里乡', '0', '', '1', '0', '0', '10'),
('6009', '150000', '150700', '150723', '1', '1', '大兴安岭管理局诺敏河农场', '0', '', '1', '0', '0', '10'),
('6010', '150000', '150700', '150723', '1', '1', '大兴安岭农场宜里农场', '0', '', '1', '0', '0', '10'),
('6011', '150000', '150700', '150723', '1', '1', '大兴安岭农场管理局扎赉河农场', '0', '', '1', '0', '0', '10'),
('6012', '150000', '150700', '150723', '1', '1', '大兴安岭农场管理局古里农场', '0', '', '1', '0', '0', '10'),
('6013', '150000', '150700', '150723', '1', '1', '加格达奇区', '0', '', '1', '0', '0', '10'),
('6014', '150000', '150700', '150723', '1', '1', '松岭地区', '0', '', '1', '0', '0', '10'),
('6015', '150000', '150700', '150723', '1', '1', '大杨树林业局', '0', '', '1', '0', '0', '10'),
('6016', '150000', '150700', '150723', '1', '1', '甘河林业局', '0', '', '1', '0', '0', '10'),
('6017', '150000', '150700', '150723', '1', '1', '克一河林业局', '0', '', '1', '0', '0', '10'),
('6018', '150000', '150700', '150723', '1', '1', '吉文林业局', '0', '', '1', '0', '0', '10'),
('6019', '150000', '150700', '150723', '1', '1', '阿里河林业局', '0', '', '1', '0', '0', '10'),
('6020', '150000', '150700', '150723', '1', '1', '大兴安岭农工商联合公司', '0', '', '1', '0', '0', '10'),
('6021', '150000', '150700', '150723', '1', '1', '大兴安岭农场管理局东方红农场', '0', '', '1', '0', '0', '10'),
('6022', '150000', '150700', '150723', '1', '1', '大兴安岭农场管理局欧肯河农场', '0', '', '1', '0', '0', '10'),
('6023', '150000', '150700', '150723', '1', '1', '大兴安岭林管局毕拉河林业局', '0', '', '1', '0', '0', '10'),
('6024', '150000', '150700', '150723', '1', '1', '大兴安岭林管局伊图里河林业局', '0', '', '1', '0', '0', '10'),
('6025', '150000', '150700', '150723', '1', '1', '大兴安岭林管局库都尔林业局', '0', '', '1', '0', '0', '10'),
('6026', '150000', '150700', '150723', '1', '1', '大兴安岭林管局乌尔其汗林业局', '0', '', '1', '0', '0', '10'),
('6027', '150000', '150700', '150724', '1', '1', '巴彦托海镇', '0', '', '1', '0', '0', '10'),
('6028', '150000', '150700', '150724', '1', '1', '巴雁镇', '0', '', '1', '0', '0', '10'),
('6029', '150000', '150700', '150724', '1', '1', '伊敏河镇', '0', '', '1', '0', '0', '10'),
('6030', '150000', '150700', '150724', '1', '1', '锡尼河镇', '0', '', '1', '0', '0', '10'),
('6031', '150000', '150700', '150724', '1', '1', '巴彦塔拉达斡尔民族乡', '0', '', '1', '0', '0', '10');
INSERT INTO `wst_communitys` VALUES ('6032', '150000', '150700', '150724', '1', '1', '伊敏苏木乡', '0', '', '1', '0', '0', '10'),
('6033', '150000', '150700', '150724', '1', '1', '辉苏木乡', '0', '', '1', '0', '0', '10'),
('6034', '150000', '150700', '150724', '1', '1', '巴彦托海经济开发区', '0', '', '1', '0', '0', '10'),
('6035', '150000', '150700', '150724', '1', '1', '伊敏河高载能工业园区', '0', '', '1', '0', '0', '10'),
('6036', '150000', '150700', '150724', '1', '1', '大雁马铃薯高新技术示范园区', '0', '', '1', '0', '0', '10'),
('6037', '150000', '150700', '150725', '1', '1', '陈旗巴彦库仁镇', '0', '', '1', '0', '0', '10'),
('6038', '150000', '150700', '150725', '1', '1', '陈旗宝日希勒镇', '0', '', '1', '0', '0', '10'),
('6039', '150000', '150700', '150725', '1', '1', '陈旗呼和诺尔镇', '0', '', '1', '0', '0', '10'),
('6040', '150000', '150700', '150725', '1', '1', '陈旗乌珠尔苏木乡', '0', '', '1', '0', '0', '10'),
('6041', '150000', '150700', '150725', '1', '1', '陈旗鄂温克民族苏木乡', '0', '', '1', '0', '0', '10'),
('6042', '150000', '150700', '150725', '1', '1', '陈旗国营哈达图农牧场', '0', '', '1', '0', '0', '10'),
('6043', '150000', '150700', '150725', '1', '1', '陈旗国营浩特陶海农牧场', '0', '', '1', '0', '0', '10'),
('6044', '150000', '150700', '150725', '1', '1', '陈旗国营特泥河农牧场', '0', '', '1', '0', '0', '10'),
('6045', '150000', '150700', '150726', '1', '1', '阿木古郎镇', '0', '', '1', '0', '0', '10'),
('6046', '150000', '150700', '150726', '1', '1', '嵯岗镇', '0', '', '1', '0', '0', '10'),
('6047', '150000', '150700', '150726', '1', '1', '乌布尔宝力格苏木乡', '0', '', '1', '0', '0', '10'),
('6048', '150000', '150700', '150726', '1', '1', '吉布胡郎图苏木乡', '0', '', '1', '0', '0', '10'),
('6049', '150000', '150700', '150726', '1', '1', '新宝力格苏木乡', '0', '', '1', '0', '0', '10'),
('6050', '150000', '150700', '150726', '1', '1', '嵯岗镇双娃牧场', '0', '', '1', '0', '0', '10'),
('6051', '150000', '150700', '150727', '1', '1', '阿拉坦额莫勒镇', '0', '', '1', '0', '0', '10'),
('6052', '150000', '150700', '150727', '1', '1', '阿日哈沙特镇', '0', '', '1', '0', '0', '10'),
('6053', '150000', '150700', '150727', '1', '1', '新巴尔虎右旗呼伦镇', '0', '', '1', '0', '0', '10'),
('6054', '150000', '150700', '150727', '1', '1', '贝尔苏木乡', '0', '', '1', '0', '0', '10'),
('6055', '150000', '150700', '150727', '1', '1', '克尔伦苏木乡', '0', '', '1', '0', '0', '10'),
('6056', '150000', '150700', '150727', '1', '1', '敖尔金牧场', '0', '', '1', '0', '0', '10'),
('6057', '150000', '150700', '150781', '1', '1', '东山街道', '0', '', '1', '0', '0', '10'),
('6058', '150000', '150700', '150781', '1', '1', '道南街道', '0', '', '1', '0', '0', '10'),
('6059', '150000', '150700', '150781', '1', '1', '道北街道', '0', '', '1', '0', '0', '10'),
('6060', '150000', '150700', '150781', '1', '1', '兴华街道', '0', '', '1', '0', '0', '10'),
('6061', '150000', '150700', '150781', '1', '1', '满洲里市第一', '0', '', '1', '0', '0', '10'),
('6062', '150000', '150700', '150781', '1', '1', '满洲里市第二', '0', '', '1', '0', '0', '10'),
('6063', '150000', '150700', '150781', '1', '1', '满洲里市第三', '0', '', '1', '0', '0', '10'),
('6064', '150000', '150700', '150781', '1', '1', '满洲里市第四', '0', '', '1', '0', '0', '10'),
('6065', '150000', '150700', '150781', '1', '1', '满洲里市第五', '0', '', '1', '0', '0', '10'),
('6066', '150000', '150700', '150781', '1', '1', '满洲里市灵泉街道', '0', '', '1', '0', '0', '10'),
('6067', '150000', '150700', '150781', '1', '1', '新开河街道', '0', '', '1', '0', '0', '10'),
('6068', '150000', '150700', '150781', '1', '1', '满洲里市互市贸易区', '0', '', '1', '0', '0', '10'),
('6069', '150000', '150700', '150781', '1', '1', '满洲里市经济合作区', '0', '', '1', '0', '0', '10'),
('6070', '150000', '150700', '150781', '1', '1', '满洲里市东湖区', '0', '', '1', '0', '0', '10'),
('6071', '150000', '150700', '150781', '1', '1', '满洲里市扎煤公司', '0', '', '1', '0', '0', '10'),
('6072', '150000', '150700', '150781', '1', '1', '扎赉诺尔矿区', '0', '', '1', '0', '0', '10'),
('6073', '150000', '150700', '150782', '1', '1', '胜利街道', '0', '', '1', '0', '0', '10'),
('6074', '150000', '150700', '150782', '1', '1', '红旗街道', '0', '', '1', '0', '0', '10'),
('6075', '150000', '150700', '150782', '1', '1', '新工街道', '0', '', '1', '0', '0', '10'),
('6076', '150000', '150700', '150782', '1', '1', '永兴街道', '0', '', '1', '0', '0', '10'),
('6077', '150000', '150700', '150782', '1', '1', '建设街道', '0', '', '1', '0', '0', '10'),
('6078', '150000', '150700', '150782', '1', '1', '暖泉街道', '0', '', '1', '0', '0', '10'),
('6079', '150000', '150700', '150782', '1', '1', '牧原街道', '0', '', '1', '0', '0', '10'),
('6080', '150000', '150700', '150782', '1', '1', '免渡河镇', '0', '', '1', '0', '0', '10'),
('6081', '150000', '150700', '150782', '1', '1', '博克图镇', '0', '', '1', '0', '0', '10'),
('6082', '150000', '150700', '150782', '1', '1', '绰源镇', '0', '', '1', '0', '0', '10'),
('6083', '150000', '150700', '150782', '1', '1', '乌尔其汉镇', '0', '', '1', '0', '0', '10'),
('6084', '150000', '150700', '150782', '1', '1', '库都尔镇', '0', '', '1', '0', '0', '10'),
('6085', '150000', '150700', '150782', '1', '1', '图里河镇', '0', '', '1', '0', '0', '10'),
('6086', '150000', '150700', '150782', '1', '1', '莫拐农场', '0', '', '1', '0', '0', '10'),
('6087', '150000', '150700', '150782', '1', '1', '牙克石农场', '0', '', '1', '0', '0', '10'),
('6088', '150000', '150700', '150782', '1', '1', '免渡河农场', '0', '', '1', '0', '0', '10'),
('6089', '150000', '150700', '150783', '1', '1', '兴华街道', '0', '', '1', '0', '0', '10'),
('6090', '150000', '150700', '150783', '1', '1', '正阳街道', '0', '', '1', '0', '0', '10'),
('6091', '150000', '150700', '150783', '1', '1', '繁荣街道', '0', '', '1', '0', '0', '10'),
('6092', '150000', '150700', '150783', '1', '1', '向阳街道', '0', '', '1', '0', '0', '10'),
('6093', '150000', '150700', '150783', '1', '1', '高台子街道', '0', '', '1', '0', '0', '10'),
('6094', '150000', '150700', '150783', '1', '1', '铁东街道', '0', '', '1', '0', '0', '10'),
('6095', '150000', '150700', '150783', '1', '1', '河西街道', '0', '', '1', '0', '0', '10'),
('6096', '150000', '150700', '150783', '1', '1', '磨菇气镇', '0', '', '1', '0', '0', '10'),
('6097', '150000', '150700', '150783', '1', '1', '洼堤镇', '0', '', '1', '0', '0', '10'),
('6098', '150000', '150700', '150783', '1', '1', '卧牛河镇', '0', '', '1', '0', '0', '10'),
('6099', '150000', '150700', '150783', '1', '1', '成吉思汗镇', '0', '', '1', '0', '0', '10'),
('6100', '150000', '150700', '150783', '1', '1', '大河湾镇', '0', '', '1', '0', '0', '10'),
('6101', '150000', '150700', '150783', '1', '1', '浩饶山镇', '0', '', '1', '0', '0', '10'),
('6102', '150000', '150700', '150783', '1', '1', '达斡尔民族乡', '0', '', '1', '0', '0', '10'),
('6103', '150000', '150700', '150783', '1', '1', '南木鄂伦春民族乡', '0', '', '1', '0', '0', '10'),
('6104', '150000', '150700', '150783', '1', '1', '萨马街鄂温克民族乡', '0', '', '1', '0', '0', '10'),
('6105', '150000', '150700', '150783', '1', '1', '大河湾农场', '0', '', '1', '0', '0', '10'),
('6106', '150000', '150700', '150783', '1', '1', '绰尔河农场', '0', '', '1', '0', '0', '10'),
('6107', '150000', '150700', '150783', '1', '1', '扎兰屯马场', '0', '', '1', '0', '0', '10'),
('6108', '150000', '150700', '150783', '1', '1', '成吉思汗监狱农场', '0', '', '1', '0', '0', '10'),
('6109', '150000', '150700', '150783', '1', '1', '公安部后勤供应处农场', '0', '', '1', '0', '0', '10'),
('6110', '150000', '150700', '150783', '1', '1', '南木林业局', '0', '', '1', '0', '0', '10'),
('6111', '150000', '150700', '150783', '1', '1', '柴河林业局', '0', '', '1', '0', '0', '10'),
('6112', '150000', '150700', '150783', '1', '1', '扎兰屯市林业局', '0', '', '1', '0', '0', '10'),
('6113', '150000', '150700', '150783', '1', '1', '市原种场', '0', '', '1', '0', '0', '10'),
('6114', '150000', '150700', '150784', '1', '1', '拉布达林街道', '0', '', '1', '0', '0', '10'),
('6115', '150000', '150700', '150784', '1', '1', '上库力街道', '0', '', '1', '0', '0', '10'),
('6116', '150000', '150700', '150784', '1', '1', '莫尔道嘎镇', '0', '', '1', '0', '0', '10'),
('6117', '150000', '150700', '150784', '1', '1', '黑山头镇', '0', '', '1', '0', '0', '10'),
('6118', '150000', '150700', '150784', '1', '1', '三河回族乡', '0', '', '1', '0', '0', '10'),
('6119', '150000', '150700', '150784', '1', '1', '室韦俄罗斯族民族乡', '0', '', '1', '0', '0', '10'),
('6120', '150000', '150700', '150784', '1', '1', '海拉尔农垦集团有限公司拉布大林农场分公司', '0', '', '1', '0', '0', '10'),
('6121', '150000', '150700', '150784', '1', '1', '三河金騋农牧有限责任公司', '0', '', '1', '0', '0', '10'),
('6122', '150000', '150700', '150784', '1', '1', '海拉尔农垦集团有限责任公司上库力农场分公', '0', '', '1', '0', '0', '10'),
('6123', '150000', '150700', '150784', '1', '1', '海拉尔农垦集团有限责任公司苏沁牧场分公司', '0', '', '1', '0', '0', '10'),
('6124', '150000', '150700', '150784', '1', '1', '海拉尔农垦集团有限责任公司恩和牧场分公司', '0', '', '1', '0', '0', '10'),
('6125', '150000', '150700', '150784', '1', '1', '室韦牧场', '0', '', '1', '0', '0', '10'),
('6126', '150000', '150700', '150785', '1', '1', '河东街道', '0', '', '1', '0', '0', '10'),
('6127', '150000', '150700', '150785', '1', '1', '河西街道', '0', '', '1', '0', '0', '10'),
('6128', '150000', '150700', '150785', '1', '1', '森工路街道', '0', '', '1', '0', '0', '10'),
('6129', '150000', '150700', '150785', '1', '1', '金河镇', '0', '', '1', '0', '0', '10'),
('6130', '150000', '150700', '150785', '1', '1', '阿龙山镇', '0', '', '1', '0', '0', '10'),
('6131', '150000', '150700', '150785', '1', '1', '满归镇', '0', '', '1', '0', '0', '10'),
('6132', '150000', '150700', '150785', '1', '1', '敖鲁古雅乡', '0', '', '1', '0', '0', '10'),
('6133', '150000', '150800', '150802', '1', '1', '团结', '0', '', '1', '0', '0', '10'),
('6134', '150000', '150800', '150802', '1', '1', '车站', '0', '', '1', '0', '0', '10'),
('6135', '150000', '150800', '150802', '1', '1', '先锋', '0', '', '1', '0', '0', '10'),
('6136', '150000', '150800', '150802', '1', '1', '解放', '0', '', '1', '0', '0', '10'),
('6137', '150000', '150800', '150802', '1', '1', '新华', '0', '', '1', '0', '0', '10'),
('6138', '150000', '150800', '150802', '1', '1', '东环', '0', '', '1', '0', '0', '10'),
('6139', '150000', '150800', '150802', '1', '1', '铁南', '0', '', '1', '0', '0', '10'),
('6140', '150000', '150800', '150802', '1', '1', '西环路', '0', '', '1', '0', '0', '10'),
('6141', '150000', '150800', '150802', '1', '1', '北环', '0', '', '1', '0', '0', '10'),
('6142', '150000', '150800', '150802', '1', '1', '曙光', '0', '', '1', '0', '0', '10'),
('6143', '150000', '150800', '150802', '1', '1', '狼山镇', '0', '', '1', '0', '0', '10'),
('6144', '150000', '150800', '150802', '1', '1', '新华镇', '0', '', '1', '0', '0', '10'),
('6145', '150000', '150800', '150802', '1', '1', '干召庙镇', '0', '', '1', '0', '0', '10'),
('6146', '150000', '150800', '150802', '1', '1', '乌兰图克镇', '0', '', '1', '0', '0', '10'),
('6147', '150000', '150800', '150802', '1', '1', '双河镇', '0', '', '1', '0', '0', '10'),
('6148', '150000', '150800', '150802', '1', '1', '城关镇', '0', '', '1', '0', '0', '10'),
('6149', '150000', '150800', '150802', '1', '1', '白脑包镇', '0', '', '1', '0', '0', '10'),
('6150', '150000', '150800', '150802', '1', '1', '狼山农场', '0', '', '1', '0', '0', '10'),
('6151', '150000', '150800', '150802', '1', '1', '临河农场', '0', '', '1', '0', '0', '10'),
('6152', '150000', '150800', '150821', '1', '1', '隆兴昌镇', '0', '', '1', '0', '0', '10'),
('6153', '150000', '150800', '150821', '1', '1', '塔尔湖镇', '0', '', '1', '0', '0', '10'),
('6154', '150000', '150800', '150821', '1', '1', '套海镇', '0', '', '1', '0', '0', '10'),
('6155', '150000', '150800', '150821', '1', '1', '新公中镇', '0', '', '1', '0', '0', '10'),
('6156', '150000', '150800', '150821', '1', '1', '天吉太镇', '0', '', '1', '0', '0', '10'),
('6157', '150000', '150800', '150821', '1', '1', '胜丰镇', '0', '', '1', '0', '0', '10'),
('6158', '150000', '150800', '150821', '1', '1', '银定图镇', '0', '', '1', '0', '0', '10'),
('6159', '150000', '150800', '150821', '1', '1', '巴盟国营建丰农场', '0', '', '1', '0', '0', '10'),
('6160', '150000', '150800', '150821', '1', '1', '内蒙古东土城劳动教养管理所', '0', '', '1', '0', '0', '10'),
('6161', '150000', '150800', '150822', '1', '1', '巴彦高勒镇', '0', '', '1', '0', '0', '10'),
('6162', '150000', '150800', '150822', '1', '1', '隆盛合镇', '0', '', '1', '0', '0', '10'),
('6163', '150000', '150800', '150822', '1', '1', '渡口镇', '0', '', '1', '0', '0', '10'),
('6164', '150000', '150800', '150822', '1', '1', '沙金套海苏木乡', '0', '', '1', '0', '0', '10'),
('6165', '150000', '150800', '150822', '1', '1', '乌兰布和农场', '0', '', '1', '0', '0', '10'),
('6166', '150000', '150800', '150822', '1', '1', '巴彦套海农场', '0', '', '1', '0', '0', '10'),
('6167', '150000', '150800', '150822', '1', '1', '哈腾套海农场', '0', '', '1', '0', '0', '10'),
('6168', '150000', '150800', '150822', '1', '1', '包尔盖农场', '0', '', '1', '0', '0', '10'),
('6169', '150000', '150800', '150822', '1', '1', '纳林套海农场', '0', '', '1', '0', '0', '10'),
('6170', '150000', '150800', '150822', '1', '1', '沙漠林业实验中心', '0', '', '1', '0', '0', '10'),
('6171', '150000', '150800', '150823', '1', '1', '乌拉山镇', '0', '', '1', '0', '0', '10'),
('6172', '150000', '150800', '150823', '1', '1', '白彦花镇', '0', '', '1', '0', '0', '10'),
('6173', '150000', '150800', '150823', '1', '1', '先锋镇', '0', '', '1', '0', '0', '10'),
('6174', '150000', '150800', '150823', '1', '1', '新安镇', '0', '', '1', '0', '0', '10'),
('6175', '150000', '150800', '150823', '1', '1', '西小召镇', '0', '', '1', '0', '0', '10'),
('6176', '150000', '150800', '150823', '1', '1', '大佘太镇', '0', '', '1', '0', '0', '10'),
('6177', '150000', '150800', '150823', '1', '1', '明安镇', '0', '', '1', '0', '0', '10'),
('6178', '150000', '150800', '150823', '1', '1', '小佘太镇', '0', '', '1', '0', '0', '10'),
('6179', '150000', '150800', '150823', '1', '1', '额尔登布拉格苏木乡', '0', '', '1', '0', '0', '10'),
('6180', '150000', '150800', '150823', '1', '1', '巴彦淖尔市中滩农场', '0', '', '1', '0', '0', '10'),
('6181', '150000', '150800', '150823', '1', '1', '巴彦淖尔市西山咀农场', '0', '', '1', '0', '0', '10'),
('6182', '150000', '150800', '150823', '1', '1', '巴彦淖尔市新安农场', '0', '', '1', '0', '0', '10'),
('6183', '150000', '150800', '150823', '1', '1', '巴彦淖尔市苏独仑农场', '0', '', '1', '0', '0', '10'),
('6184', '150000', '150800', '150823', '1', '1', '巴彦淖尔市大佘太牧场', '0', '', '1', '0', '0', '10'),
('6185', '150000', '150800', '150823', '1', '1', '巴彦淖尔市乌梁素海渔场', '0', '', '1', '0', '0', '10'),
('6186', '150000', '150800', '150824', '1', '1', '海流图镇', '0', '', '1', '0', '0', '10'),
('6187', '150000', '150800', '150824', '1', '1', '乌加河镇', '0', '', '1', '0', '0', '10'),
('6188', '150000', '150800', '150824', '1', '1', '德岭山镇', '0', '', '1', '0', '0', '10'),
('6189', '150000', '150800', '150824', '1', '1', '石哈河镇', '0', '', '1', '0', '0', '10'),
('6190', '150000', '150800', '150824', '1', '1', '呼鲁斯太苏木乡', '0', '', '1', '0', '0', '10'),
('6191', '150000', '150800', '150824', '1', '1', '川井苏木乡', '0', '', '1', '0', '0', '10'),
('6192', '150000', '150800', '150824', '1', '1', '巴音乌兰苏木乡', '0', '', '1', '0', '0', '10'),
('6193', '150000', '150800', '150824', '1', '1', '新忽热苏木乡', '0', '', '1', '0', '0', '10'),
('6194', '150000', '150800', '150824', '1', '1', '牧羊海牧场', '0', '', '1', '0', '0', '10'),
('6195', '150000', '150800', '150824', '1', '1', '同和太种畜场', '0', '', '1', '0', '0', '10'),
('6196', '150000', '150800', '150824', '1', '1', '巴盟乌北林场', '0', '', '1', '0', '0', '10'),
('6197', '150000', '150800', '150825', '1', '1', '巴音宝力格镇', '0', '', '1', '0', '0', '10'),
('6198', '150000', '150800', '150825', '1', '1', '呼和温都尔镇', '0', '', '1', '0', '0', '10'),
('6199', '150000', '150800', '150825', '1', '1', '潮格温都尔镇', '0', '', '1', '0', '0', '10'),
('6200', '150000', '150800', '150825', '1', '1', '获各琦苏木乡', '0', '', '1', '0', '0', '10'),
('6201', '150000', '150800', '150825', '1', '1', '巴音前达门苏木乡', '0', '', '1', '0', '0', '10'),
('6202', '150000', '150800', '150826', '1', '1', '陕坝镇', '0', '', '1', '0', '0', '10'),
('6203', '150000', '150800', '150826', '1', '1', '头道桥镇', '0', '', '1', '0', '0', '10'),
('6204', '150000', '150800', '150826', '1', '1', '二道桥镇', '0', '', '1', '0', '0', '10'),
('6205', '150000', '150800', '150826', '1', '1', '三道桥镇', '0', '', '1', '0', '0', '10'),
('6206', '150000', '150800', '150826', '1', '1', '蛮会镇', '0', '', '1', '0', '0', '10'),
('6207', '150000', '150800', '150826', '1', '1', '团结镇', '0', '', '1', '0', '0', '10'),
('6208', '150000', '150800', '150826', '1', '1', '双庙镇', '0', '', '1', '0', '0', '10'),
('6209', '150000', '150800', '150826', '1', '1', '沙海镇', '0', '', '1', '0', '0', '10'),
('6210', '150000', '150800', '150826', '1', '1', '巴市太阳庙农场', '0', '', '1', '0', '0', '10'),
('6211', '150000', '150900', '150902', '1', '1', '新体路街道', '0', '', '1', '0', '0', '10'),
('6212', '150000', '150900', '150902', '1', '1', '桥东街道', '0', '', '1', '0', '0', '10'),
('6213', '150000', '150900', '150902', '1', '1', '前进路街道', '0', '', '1', '0', '0', '10'),
('6214', '150000', '150900', '150902', '1', '1', '常青街道', '0', '', '1', '0', '0', '10'),
('6215', '150000', '150900', '150902', '1', '1', '虎山街道', '0', '', '1', '0', '0', '10'),
('6216', '150000', '150900', '150902', '1', '1', '桥西街道', '0', '', '1', '0', '0', '10'),
('6217', '150000', '150900', '150902', '1', '1', '新华街街道', '0', '', '1', '0', '0', '10'),
('6218', '150000', '150900', '150902', '1', '1', '泉山街道', '0', '', '1', '0', '0', '10'),
('6219', '150000', '150900', '150902', '1', '1', '白海子镇', '0', '', '1', '0', '0', '10'),
('6220', '150000', '150900', '150902', '1', '1', '马莲渠乡', '0', '', '1', '0', '0', '10'),
('6221', '150000', '150900', '150921', '1', '1', '卓资山镇', '0', '', '1', '0', '0', '10'),
('6222', '150000', '150900', '150921', '1', '1', '旗下营镇', '0', '', '1', '0', '0', '10'),
('6223', '150000', '150900', '150921', '1', '1', '十八台镇', '0', '', '1', '0', '0', '10'),
('6224', '150000', '150900', '150921', '1', '1', '巴音锡勒镇', '0', '', '1', '0', '0', '10'),
('6225', '150000', '150900', '150921', '1', '1', '梨花镇', '0', '', '1', '0', '0', '10'),
('6226', '150000', '150900', '150921', '1', '1', '大榆树乡', '0', '', '1', '0', '0', '10'),
('6227', '150000', '150900', '150921', '1', '1', '红召乡', '0', '', '1', '0', '0', '10'),
('6228', '150000', '150900', '150922', '1', '1', '长顺镇', '0', '', '1', '0', '0', '10'),
('6229', '150000', '150900', '150922', '1', '1', '朝阳镇', '0', '', '1', '0', '0', '10'),
('6230', '150000', '150900', '150922', '1', '1', '七号镇', '0', '', '1', '0', '0', '10'),
('6231', '150000', '150900', '150922', '1', '1', '德包图乡', '0', '', '1', '0', '0', '10'),
('6232', '150000', '150900', '150922', '1', '1', '公腊胡洞乡', '0', '', '1', '0', '0', '10'),
('6233', '150000', '150900', '150923', '1', '1', '七台镇', '0', '', '1', '0', '0', '10'),
('6234', '150000', '150900', '150923', '1', '1', '十八顷镇', '0', '', '1', '0', '0', '10'),
('6235', '150000', '150900', '150923', '1', '1', '大黑沙土镇', '0', '', '1', '0', '0', '10'),
('6236', '150000', '150900', '150923', '1', '1', '西井子镇', '0', '', '1', '0', '0', '10'),
('6237', '150000', '150900', '150923', '1', '1', '屯垦队镇', '0', '', '1', '0', '0', '10'),
('6238', '150000', '150900', '150923', '1', '1', '小海子镇', '0', '', '1', '0', '0', '10'),
('6239', '150000', '150900', '150923', '1', '1', '大库伦乡', '0', '', '1', '0', '0', '10'),
('6240', '150000', '150900', '150923', '1', '1', '卯都乡', '0', '', '1', '0', '0', '10'),
('6241', '150000', '150900', '150923', '1', '1', '玻璃忽镜乡', '0', '', '1', '0', '0', '10'),
('6242', '150000', '150900', '150924', '1', '1', '城关镇', '0', '', '1', '0', '0', '10'),
('6243', '150000', '150900', '150924', '1', '1', '张皋镇', '0', '', '1', '0', '0', '10'),
('6244', '150000', '150900', '150924', '1', '1', '赛乌素镇', '0', '', '1', '0', '0', '10'),
('6245', '150000', '150900', '150924', '1', '1', '鄂尔栋镇', '0', '', '1', '0', '0', '10'),
('6246', '150000', '150900', '150924', '1', '1', '店子镇', '0', '', '1', '0', '0', '10'),
('6247', '150000', '150900', '150924', '1', '1', '大库联乡', '0', '', '1', '0', '0', '10'),
('6248', '150000', '150900', '150924', '1', '1', '民族团结乡', '0', '', '1', '0', '0', '10'),
('6249', '150000', '150900', '150924', '1', '1', '南部矿区管委会', '0', '', '1', '0', '0', '10'),
('6250', '150000', '150900', '150925', '1', '1', '岱海镇', '0', '', '1', '0', '0', '10'),
('6251', '150000', '150900', '150925', '1', '1', '六苏木镇', '0', '', '1', '0', '0', '10'),
('6252', '150000', '150900', '150925', '1', '1', '麦胡图镇', '0', '', '1', '0', '0', '10'),
('6253', '150000', '150900', '150925', '1', '1', '永兴镇', '0', '', '1', '0', '0', '10'),
('6254', '150000', '150900', '150925', '1', '1', '蛮汉镇', '0', '', '1', '0', '0', '10'),
('6255', '150000', '150900', '150925', '1', '1', '天成乡', '0', '', '1', '0', '0', '10'),
('6256', '150000', '150900', '150925', '1', '1', '曹碾满族乡', '0', '', '1', '0', '0', '10'),
('6257', '150000', '150900', '150925', '1', '1', '岱海循环工业发展区', '0', '', '1', '0', '0', '10'),
('6258', '150000', '150900', '150925', '1', '1', '蛮汉山林场', '0', '', '1', '0', '0', '10'),
('6259', '150000', '150900', '150925', '1', '1', '岱海林场', '0', '', '1', '0', '0', '10'),
('6260', '150000', '150900', '150926', '1', '1', '土贵乌拉镇', '0', '', '1', '0', '0', '10'),
('6261', '150000', '150900', '150926', '1', '1', '平地泉镇', '0', '', '1', '0', '0', '10'),
('6262', '150000', '150900', '150926', '1', '1', '玫瑰营镇', '0', '', '1', '0', '0', '10'),
('6263', '150000', '150900', '150926', '1', '1', '巴音塔拉镇', '0', '', '1', '0', '0', '10'),
('6264', '150000', '150900', '150926', '1', '1', '乌拉哈乌拉乡', '0', '', '1', '0', '0', '10'),
('6265', '150000', '150900', '150926', '1', '1', '黄茂营乡', '0', '', '1', '0', '0', '10'),
('6266', '150000', '150900', '150926', '1', '1', '三岔口乡', '0', '', '1', '0', '0', '10'),
('6267', '150000', '150900', '150926', '1', '1', '移民区管委会', '0', '', '1', '0', '0', '10'),
('6268', '150000', '150900', '150927', '1', '1', '科布尔镇', '0', '', '1', '0', '0', '10'),
('6269', '150000', '150900', '150927', '1', '1', '铁沙盖镇', '0', '', '1', '0', '0', '10'),
('6270', '150000', '150900', '150927', '1', '1', '黄羊城镇', '0', '', '1', '0', '0', '10'),
('6271', '150000', '150900', '150927', '1', '1', '广益隆镇', '0', '', '1', '0', '0', '10'),
('6272', '150000', '150900', '150927', '1', '1', '乌素图镇', '0', '', '1', '0', '0', '10'),
('6273', '150000', '150900', '150927', '1', '1', '大滩乡', '0', '', '1', '0', '0', '10'),
('6274', '150000', '150900', '150927', '1', '1', '宏盘乡', '0', '', '1', '0', '0', '10'),
('6275', '150000', '150900', '150927', '1', '1', '巴音乡', '0', '', '1', '0', '0', '10'),
('6276', '150000', '150900', '150927', '1', '1', '库联苏木乡', '0', '', '1', '0', '0', '10'),
('6277', '150000', '150900', '150927', '1', '1', '乌兰哈页苏木乡', '0', '', '1', '0', '0', '10'),
('6278', '150000', '150900', '150928', '1', '1', '白音察干镇', '0', '', '1', '0', '0', '10'),
('6279', '150000', '150900', '150928', '1', '1', '察哈尔右翼后旗土牧尔台镇', '0', '', '1', '0', '0', '10'),
('6280', '150000', '150900', '150928', '1', '1', '察哈尔右翼后旗红格尔图镇', '0', '', '1', '0', '0', '10'),
('6281', '150000', '150900', '150928', '1', '1', '察哈尔右翼后旗贲红镇', '0', '', '1', '0', '0', '10'),
('6282', '150000', '150900', '150928', '1', '1', '察哈尔右翼后旗当郎忽洞苏木乡', '0', '', '1', '0', '0', '10'),
('6283', '150000', '150900', '150928', '1', '1', '察哈尔右翼后旗乌兰哈达苏木乡', '0', '', '1', '0', '0', '10'),
('6284', '150000', '150900', '150928', '1', '1', '察哈尔右翼后旗锡勒乡', '0', '', '1', '0', '0', '10'),
('6285', '150000', '150900', '150929', '1', '1', '四子王旗乌兰花镇', '0', '', '1', '0', '0', '10'),
('6286', '150000', '150900', '150929', '1', '1', '四子王旗吉生太镇', '0', '', '1', '0', '0', '10'),
('6287', '150000', '150900', '150929', '1', '1', '四子王旗库伦图镇', '0', '', '1', '0', '0', '10'),
('6288', '150000', '150900', '150929', '1', '1', '四子王旗供济堂镇', '0', '', '1', '0', '0', '10'),
('6289', '150000', '150900', '150929', '1', '1', '四子王旗白音朝克图镇', '0', '', '1', '0', '0', '10'),
('6290', '150000', '150900', '150929', '1', '1', '四子王旗红格尔苏木乡', '0', '', '1', '0', '0', '10'),
('6291', '150000', '150900', '150929', '1', '1', '四子王旗江岸苏木乡', '0', '', '1', '0', '0', '10'),
('6292', '150000', '150900', '150929', '1', '1', '四子王旗查干补力格苏木乡', '0', '', '1', '0', '0', '10'),
('6293', '150000', '150900', '150929', '1', '1', '四子王旗脑木更苏木乡', '0', '', '1', '0', '0', '10'),
('6294', '150000', '150900', '150929', '1', '1', '四子王旗东八号乡', '0', '', '1', '0', '0', '10'),
('6295', '150000', '150900', '150929', '1', '1', '四子王旗忽鸡图乡', '0', '', '1', '0', '0', '10'),
('6296', '150000', '150900', '150929', '1', '1', '四子王旗乌兰牧场', '0', '', '1', '0', '0', '10'),
('6297', '150000', '150900', '150981', '1', '1', '新城区街道', '0', '', '1', '0', '0', '10'),
('6298', '150000', '150900', '150981', '1', '1', '旧城区街道', '0', '', '1', '0', '0', '10'),
('6299', '150000', '150900', '150981', '1', '1', '北城区街道', '0', '', '1', '0', '0', '10'),
('6300', '150000', '150900', '150981', '1', '1', '工业区街道', '0', '', '1', '0', '0', '10'),
('6301', '150000', '150900', '150981', '1', '1', '南城区街道', '0', '', '1', '0', '0', '10'),
('6302', '150000', '150900', '150981', '1', '1', '隆盛庄镇', '0', '', '1', '0', '0', '10'),
('6303', '150000', '150900', '150981', '1', '1', '黑土台镇', '0', '', '1', '0', '0', '10'),
('6304', '150000', '150900', '150981', '1', '1', '红砂坝镇', '0', '', '1', '0', '0', '10'),
('6305', '150000', '150900', '150981', '1', '1', '巨宝庄镇', '0', '', '1', '0', '0', '10'),
('6306', '150000', '150900', '150981', '1', '1', '三义泉镇', '0', '', '1', '0', '0', '10'),
('6307', '150000', '150900', '150981', '1', '1', '浑源窑乡', '0', '', '1', '0', '0', '10'),
('6308', '150000', '150900', '150981', '1', '1', '官屯堡乡', '0', '', '1', '0', '0', '10'),
('6309', '150000', '152200', '152201', '1', '1', '爱国街道', '0', '', '1', '0', '0', '10'),
('6310', '150000', '152200', '152201', '1', '1', '和平街道', '0', '', '1', '0', '0', '10'),
('6311', '150000', '152200', '152201', '1', '1', '兴安街道', '0', '', '1', '0', '0', '10'),
('6312', '150000', '152200', '152201', '1', '1', '胜利街道', '0', '', '1', '0', '0', '10'),
('6313', '150000', '152200', '152201', '1', '1', '铁西街道', '0', '', '1', '0', '0', '10'),
('6314', '150000', '152200', '152201', '1', '1', '都林街道', '0', '', '1', '0', '0', '10'),
('6315', '150000', '152200', '152201', '1', '1', '五一街道', '0', '', '1', '0', '0', '10'),
('6316', '150000', '152200', '152201', '1', '1', '永联街道', '0', '', '1', '0', '0', '10'),
('6317', '150000', '152200', '152201', '1', '1', '乌兰哈达镇', '0', '', '1', '0', '0', '10'),
('6318', '150000', '152200', '152201', '1', '1', '居力很镇', '0', '', '1', '0', '0', '10'),
('6319', '150000', '152200', '152201', '1', '1', '乌兰哈达原种场', '0', '', '1', '0', '0', '10'),
('6320', '150000', '152200', '152202', '1', '1', '林海街道', '0', '', '1', '0', '0', '10'),
('6321', '150000', '152200', '152202', '1', '1', '新城街道', '0', '', '1', '0', '0', '10'),
('6322', '150000', '152200', '152202', '1', '1', '温泉街道', '0', '', '1', '0', '0', '10'),
('6323', '150000', '152200', '152202', '1', '1', '天池镇', '0', '', '1', '0', '0', '10'),
('6324', '150000', '152200', '152202', '1', '1', '白狼镇', '0', '', '1', '0', '0', '10'),
('6325', '150000', '152200', '152202', '1', '1', '五岔沟镇', '0', '', '1', '0', '0', '10'),
('6326', '150000', '152200', '152221', '1', '1', '科尔沁镇', '0', '', '1', '0', '0', '10'),
('6327', '150000', '152200', '152221', '1', '1', '索伦镇', '0', '', '1', '0', '0', '10'),
('6328', '150000', '152200', '152221', '1', '1', '德佰斯镇', '0', '', '1', '0', '0', '10'),
('6329', '150000', '152200', '152221', '1', '1', '大石寨镇', '0', '', '1', '0', '0', '10'),
('6330', '150000', '152200', '152221', '1', '1', '归流河镇', '0', '', '1', '0', '0', '10'),
('6331', '150000', '152200', '152221', '1', '1', '葛根庙镇', '0', '', '1', '0', '0', '10'),
('6332', '150000', '152200', '152221', '1', '1', '察尔森镇', '0', '', '1', '0', '0', '10'),
('6333', '150000', '152200', '152221', '1', '1', '额尔格图镇', '0', '', '1', '0', '0', '10'),
('6334', '150000', '152200', '152221', '1', '1', '满族屯满族乡', '0', '', '1', '0', '0', '10'),
('6335', '150000', '152200', '152221', '1', '1', '乌兰毛都苏木乡', '0', '', '1', '0', '0', '10'),
('6336', '150000', '152200', '152221', '1', '1', '阿力得尔苏木乡', '0', '', '1', '0', '0', '10'),
('6337', '150000', '152200', '152221', '1', '1', '跃进马场', '0', '', '1', '0', '0', '10'),
('6338', '150000', '152200', '152221', '1', '1', '索伦牧场', '0', '', '1', '0', '0', '10'),
('6339', '150000', '152200', '152221', '1', '1', '呼和马场', '0', '', '1', '0', '0', '10'),
('6340', '150000', '152200', '152221', '1', '1', '阿力得尔牧场', '0', '', '1', '0', '0', '10'),
('6341', '150000', '152200', '152221', '1', '1', '公主陵牧场', '0', '', '1', '0', '0', '10'),
('6342', '150000', '152200', '152221', '1', '1', '绿水种畜场', '0', '', '1', '0', '0', '10'),
('6343', '150000', '152200', '152221', '1', '1', '前旗驻乌兰浩特市虚拟区域', '0', '', '1', '0', '0', '10'),
('6344', '150000', '152200', '152222', '1', '1', '巴彦呼舒镇', '0', '', '1', '0', '0', '10'),
('6345', '150000', '152200', '152222', '1', '1', '巴仁哲里木镇', '0', '', '1', '0', '0', '10'),
('6346', '150000', '152200', '152222', '1', '1', '吐列毛都镇', '0', '', '1', '0', '0', '10'),
('6347', '150000', '152200', '152222', '1', '1', '杜尔基镇', '0', '', '1', '0', '0', '10'),
('6348', '150000', '152200', '152222', '1', '1', '高力板镇', '0', '', '1', '0', '0', '10'),
('6349', '150000', '152200', '152222', '1', '1', '好腰苏木镇', '0', '', '1', '0', '0', '10'),
('6350', '150000', '152200', '152222', '1', '1', '代钦塔拉苏木乡', '0', '', '1', '0', '0', '10'),
('6351', '150000', '152200', '152222', '1', '1', '新佳木苏木乡', '0', '', '1', '0', '0', '10'),
('6352', '150000', '152200', '152222', '1', '1', '布敦化牧场', '0', '', '1', '0', '0', '10'),
('6353', '150000', '152200', '152222', '1', '1', '吐列毛杜农场', '0', '', '1', '0', '0', '10'),
('6354', '150000', '152200', '152222', '1', '1', '铅矿管理区', '0', '', '1', '0', '0', '10'),
('6355', '150000', '152200', '152222', '1', '1', '铜矿管理区', '0', '', '1', '0', '0', '10'),
('6356', '150000', '152200', '152222', '1', '1', '红星林场', '0', '', '1', '0', '0', '10'),
('6357', '150000', '152200', '152222', '1', '1', '杜尔基林场', '0', '', '1', '0', '0', '10'),
('6358', '150000', '152200', '152222', '1', '1', '义和塔拉林场', '0', '', '1', '0', '0', '10'),
('6359', '150000', '152200', '152222', '1', '1', '代钦塔拉林场', '0', '', '1', '0', '0', '10'),
('6360', '150000', '152200', '152222', '1', '1', '好腰苏木林场', '0', '', '1', '0', '0', '10'),
('6361', '150000', '152200', '152222', '1', '1', '哈日努拉防火站', '0', '', '1', '0', '0', '10'),
('6362', '150000', '152200', '152222', '1', '1', '种畜场', '0', '', '1', '0', '0', '10'),
('6363', '150000', '152200', '152222', '1', '1', '良种繁殖场', '0', '', '1', '0', '0', '10'),
('6364', '150000', '152200', '152222', '1', '1', '草籽繁殖场', '0', '', '1', '0', '0', '10'),
('6365', '150000', '152200', '152223', '1', '1', '音德尔镇', '0', '', '1', '0', '0', '10'),
('6366', '150000', '152200', '152223', '1', '1', '新林镇', '0', '', '1', '0', '0', '10'),
('6367', '150000', '152200', '152223', '1', '1', '巴彦高勒镇', '0', '', '1', '0', '0', '10'),
('6368', '150000', '152200', '152223', '1', '1', '胡尔勒镇', '0', '', '1', '0', '0', '10'),
('6369', '150000', '152200', '152223', '1', '1', '阿尔本格勒镇', '0', '', '1', '0', '0', '10'),
('6370', '150000', '152200', '152223', '1', '1', '巴达尔胡镇', '0', '', '1', '0', '0', '10'),
('6371', '150000', '152200', '152223', '1', '1', '图牧吉镇', '0', '', '1', '0', '0', '10'),
('6372', '150000', '152200', '152223', '1', '1', '好力保乡', '0', '', '1', '0', '0', '10'),
('6373', '150000', '152200', '152223', '1', '1', '巴彦乌兰苏木乡', '0', '', '1', '0', '0', '10'),
('6374', '150000', '152200', '152223', '1', '1', '图牧吉劳管所', '0', '', '1', '0', '0', '10'),
('6375', '150000', '152200', '152223', '1', '1', '内蒙劳改局东部分局', '0', '', '1', '0', '0', '10'),
('6376', '150000', '152200', '152223', '1', '1', '种畜场', '0', '', '1', '0', '0', '10'),
('6377', '150000', '152200', '152223', '1', '1', '八一牧场', '0', '', '1', '0', '0', '10'),
('6378', '150000', '152200', '152223', '1', '1', '巴达尔胡农场', '0', '', '1', '0', '0', '10'),
('6379', '150000', '152200', '152224', '1', '1', '突泉镇', '0', '', '1', '0', '0', '10'),
('6380', '150000', '152200', '152224', '1', '1', '六户镇', '0', '', '1', '0', '0', '10'),
('6381', '150000', '152200', '152224', '1', '1', '东杜尔基镇', '0', '', '1', '0', '0', '10'),
('6382', '150000', '152200', '152224', '1', '1', '永安镇', '0', '', '1', '0', '0', '10'),
('6383', '150000', '152200', '152224', '1', '1', '水泉镇', '0', '', '1', '0', '0', '10'),
('6384', '150000', '152200', '152224', '1', '1', '宝石镇', '0', '', '1', '0', '0', '10'),
('6385', '150000', '152200', '152224', '1', '1', '东杜尔基国营农场', '0', '', '1', '0', '0', '10'),
('6386', '150000', '152200', '152224', '1', '1', '东杜尔基良种场', '0', '', '1', '0', '0', '10'),
('6387', '150000', '152200', '152224', '1', '1', '莲花山铜矿', '0', '', '1', '0', '0', '10'),
('6388', '150000', '152500', '152501', '1', '1', '乌兰街道', '0', '', '1', '0', '0', '10'),
('6389', '150000', '152500', '152501', '1', '1', '锡林街道', '0', '', '1', '0', '0', '10'),
('6390', '150000', '152500', '152501', '1', '1', '东城街道', '0', '', '1', '0', '0', '10'),
('6391', '150000', '152500', '152501', '1', '1', '格日勒敖都苏木乡', '0', '', '1', '0', '0', '10'),
('6392', '150000', '152500', '152501', '1', '1', '赛乌苏科技园区', '0', '', '1', '0', '0', '10'),
('6393', '150000', '152500', '152502', '1', '1', '希日塔拉街道', '0', '', '1', '0', '0', '10'),
('6394', '150000', '152500', '152502', '1', '1', '宝力根街道', '0', '', '1', '0', '0', '10'),
('6395', '150000', '152500', '152502', '1', '1', '杭盖街道', '0', '', '1', '0', '0', '10'),
('6396', '150000', '152500', '152502', '1', '1', '楚古兰街道', '0', '', '1', '0', '0', '10'),
('6397', '150000', '152500', '152502', '1', '1', '额尔敦街道', '0', '', '1', '0', '0', '10'),
('6398', '150000', '152500', '152502', '1', '1', '南郊街道', '0', '', '1', '0', '0', '10'),
('6399', '150000', '152500', '152502', '1', '1', '阿尔善宝拉格镇', '0', '', '1', '0', '0', '10'),
('6400', '150000', '152500', '152502', '1', '1', '宝力根苏木乡乡', '0', '', '1', '0', '0', '10'),
('6401', '150000', '152500', '152502', '1', '1', '朝克乌拉苏木乡乡', '0', '', '1', '0', '0', '10'),
('6402', '150000', '152500', '152502', '1', '1', '巴彦锡勒', '0', '', '1', '0', '0', '10'),
('6403', '150000', '152500', '152502', '1', '1', '白音库伦牧场', '0', '', '1', '0', '0', '10'),
('6404', '150000', '152500', '152502', '1', '1', '贝力克牧场', '0', '', '1', '0', '0', '10'),
('6405', '150000', '152500', '152502', '1', '1', '毛登牧场', '0', '', '1', '0', '0', '10'),
('6406', '150000', '152500', '152522', '1', '1', '别力古台镇', '0', '', '1', '0', '0', '10'),
('6407', '150000', '152500', '152522', '1', '1', '洪格尔高勒镇', '0', '', '1', '0', '0', '10'),
('6408', '150000', '152500', '152522', '1', '1', '查干淖尔镇', '0', '', '1', '0', '0', '10'),
('6409', '150000', '152500', '152522', '1', '1', '那仁宝拉格苏木乡', '0', '', '1', '0', '0', '10'),
('6410', '150000', '152500', '152522', '1', '1', '伊和高勒苏木乡乡', '0', '', '1', '0', '0', '10'),
('6411', '150000', '152500', '152522', '1', '1', '吉尔嘎郎图苏木乡', '0', '', '1', '0', '0', '10'),
('6412', '150000', '152500', '152522', '1', '1', '玛尼图煤矿', '0', '', '1', '0', '0', '10'),
('6413', '150000', '152500', '152523', '1', '1', '满都拉图镇', '0', '', '1', '0', '0', '10'),
('6414', '150000', '152500', '152523', '1', '1', '查干敖包中心镇', '0', '', '1', '0', '0', '10'),
('6415', '150000', '152500', '152523', '1', '1', '巴彦淖尔镇', '0', '', '1', '0', '0', '10'),
('6416', '150000', '152500', '152523', '1', '1', '巴彦乌拉苏木乡', '0', '', '1', '0', '0', '10'),
('6417', '150000', '152500', '152523', '1', '1', '赛罕高毕苏木乡', '0', '', '1', '0', '0', '10'),
('6418', '150000', '152500', '152523', '1', '1', '恩格尔河灌区', '0', '', '1', '0', '0', '10'),
('6419', '150000', '152500', '152524', '1', '1', '赛汉塔拉镇', '0', '', '1', '0', '0', '10'),
('6420', '150000', '152500', '152524', '1', '1', '朱日和镇', '0', '', '1', '0', '0', '10'),
('6421', '150000', '152500', '152524', '1', '1', '乌日根塔拉镇', '0', '', '1', '0', '0', '10'),
('6422', '150000', '152500', '152524', '1', '1', '桑宝力格苏木乡', '0', '', '1', '0', '0', '10'),
('6423', '150000', '152500', '152524', '1', '1', '额仁淖尔苏木乡', '0', '', '1', '0', '0', '10'),
('6424', '150000', '152500', '152524', '1', '1', '赛罕乌力吉苏木乡', '0', '', '1', '0', '0', '10'),
('6425', '150000', '152500', '152525', '1', '1', '乌里雅斯太镇', '0', '', '1', '0', '0', '10'),
('6426', '150000', '152500', '152525', '1', '1', '道特淖尔镇', '0', '', '1', '0', '0', '10'),
('6427', '150000', '152500', '152525', '1', '1', '嘎达布其镇', '0', '', '1', '0', '0', '10'),
('6428', '150000', '152500', '152525', '1', '1', '满都胡宝拉格镇', '0', '', '1', '0', '0', '10'),
('6429', '150000', '152500', '152525', '1', '1', '额吉淖尔镇', '0', '', '1', '0', '0', '10'),
('6430', '150000', '152500', '152525', '1', '1', '巴音胡硕镇', '0', '', '1', '0', '0', '10'),
('6431', '150000', '152500', '152525', '1', '1', '呼热图淖尔苏木乡', '0', '', '1', '0', '0', '10'),
('6432', '150000', '152500', '152525', '1', '1', '萨麦苏木乡', '0', '', '1', '0', '0', '10'),
('6433', '150000', '152500', '152525', '1', '1', '哈拉盖图农牧场', '0', '', '1', '0', '0', '10'),
('6434', '150000', '152500', '152525', '1', '1', '贺斯格乌拉农牧场', '0', '', '1', '0', '0', '10'),
('6435', '150000', '152500', '152525', '1', '1', '乌拉盖牧场', '0', '', '1', '0', '0', '10'),
('6436', '150000', '152500', '152525', '1', '1', '水库农牧业经营公司场', '0', '', '1', '0', '0', '10'),
('6437', '150000', '152500', '152526', '1', '1', '巴拉嘎尔高勒镇', '0', '', '1', '0', '0', '10'),
('6438', '150000', '152500', '152526', '1', '1', '巴彦花镇', '0', '', '1', '0', '0', '10'),
('6439', '150000', '152500', '152526', '1', '1', '吉仁高勒镇', '0', '', '1', '0', '0', '10'),
('6440', '150000', '152500', '152526', '1', '1', '浩勒图高勒镇', '0', '', '1', '0', '0', '10'),
('6441', '150000', '152500', '152526', '1', '1', '高日罕镇', '0', '', '1', '0', '0', '10'),
('6442', '150000', '152500', '152526', '1', '1', '巴彦胡舒苏木乡', '0', '', '1', '0', '0', '10'),
('6443', '150000', '152500', '152526', '1', '1', '林业总场', '0', '', '1', '0', '0', '10'),
('6444', '150000', '152500', '152527', '1', '1', '宝昌镇', '0', '', '1', '0', '0', '10'),
('6445', '150000', '152500', '152527', '1', '1', '千斤沟镇', '0', '', '1', '0', '0', '10'),
('6446', '150000', '152500', '152527', '1', '1', '红旗镇', '0', '', '1', '0', '0', '10'),
('6447', '150000', '152500', '152527', '1', '1', '骆驼山镇', '0', '', '1', '0', '0', '10'),
('6448', '150000', '152500', '152527', '1', '1', '幸福乡', '0', '', '1', '0', '0', '10'),
('6449', '150000', '152500', '152527', '1', '1', '贡宝拉格苏木乡', '0', '', '1', '0', '0', '10'),
('6450', '150000', '152500', '152527', '1', '1', '万寿滩良种场', '0', '', '1', '0', '0', '10'),
('6451', '150000', '152500', '152528', '1', '1', '新宝拉格镇', '0', '', '1', '0', '0', '10'),
('6452', '150000', '152500', '152528', '1', '1', '巴彦塔拉镇', '0', '', '1', '0', '0', '10'),
('6453', '150000', '152500', '152528', '1', '1', '翁贡乌拉苏木乡', '0', '', '1', '0', '0', '10'),
('6454', '150000', '152500', '152529', '1', '1', '明安图镇', '0', '', '1', '0', '0', '10'),
('6455', '150000', '152500', '152529', '1', '1', '星耀镇', '0', '', '1', '0', '0', '10'),
('6456', '150000', '152500', '152529', '1', '1', '伊和淖尔苏木乡', '0', '', '1', '0', '0', '10'),
('6457', '150000', '152500', '152529', '1', '1', '乌兰查布苏木乡', '0', '', '1', '0', '0', '10'),
('6458', '150000', '152500', '152529', '1', '1', '额里图种畜场', '0', '', '1', '0', '0', '10'),
('6459', '150000', '152500', '152529', '1', '1', '哲日根图林场', '0', '', '1', '0', '0', '10'),
('6460', '150000', '152500', '152530', '1', '1', '上都镇', '0', '', '1', '0', '0', '10'),
('6461', '150000', '152500', '152530', '1', '1', '桑根达来镇', '0', '', '1', '0', '0', '10'),
('6462', '150000', '152500', '152530', '1', '1', '哈毕日嘎镇', '0', '', '1', '0', '0', '10'),
('6463', '150000', '152500', '152530', '1', '1', '宝绍岱苏木乡', '0', '', '1', '0', '0', '10'),
('6464', '150000', '152500', '152530', '1', '1', '那日图苏木乡', '0', '', '1', '0', '0', '10'),
('6465', '150000', '152500', '152530', '1', '1', '赛音胡都嘎苏木乡', '0', '', '1', '0', '0', '10'),
('6466', '150000', '152500', '152530', '1', '1', '五一种畜场总场', '0', '', '1', '0', '0', '10'),
('6467', '150000', '152500', '152530', '1', '1', '黑城子示范区', '0', '', '1', '0', '0', '10'),
('6468', '150000', '152500', '152531', '1', '1', '大北沟镇', '0', '', '1', '0', '0', '10'),
('6469', '150000', '152500', '152531', '1', '1', '多伦淖尔镇', '0', '', '1', '0', '0', '10'),
('6470', '150000', '152500', '152531', '1', '1', '大河口乡', '0', '', '1', '0', '0', '10'),
('6471', '150000', '152500', '152531', '1', '1', '蔡木山乡', '0', '', '1', '0', '0', '10'),
('6472', '150000', '152900', '152921', '1', '1', '温都尔勒图镇', '0', '', '1', '0', '0', '10'),
('6473', '150000', '152900', '152921', '1', '1', '乌斯太镇', '0', '', '1', '0', '0', '10'),
('6474', '150000', '152900', '152921', '1', '1', '巴润别立镇', '0', '', '1', '0', '0', '10'),
('6475', '150000', '152900', '152921', '1', '1', '巴彦浩特镇', '0', '', '1', '0', '0', '10'),
('6476', '150000', '152900', '152921', '1', '1', '嘉尔嘎勒赛汉镇', '0', '', '1', '0', '0', '10'),
('6477', '150000', '152900', '152921', '1', '1', '吉兰泰镇', '0', '', '1', '0', '0', '10'),
('6478', '150000', '152900', '152921', '1', '1', '宗别立镇', '0', '', '1', '0', '0', '10'),
('6479', '150000', '152900', '152921', '1', '1', '敖伦布拉格镇', '0', '', '1', '0', '0', '10'),
('6480', '150000', '152900', '152921', '1', '1', '巴彦木仁苏木乡', '0', '', '1', '0', '0', '10'),
('6481', '150000', '152900', '152921', '1', '1', '腾格里苏木乡', '0', '', '1', '0', '0', '10'),
('6482', '150000', '152900', '152921', '1', '1', '乌力吉苏木乡', '0', '', '1', '0', '0', '10'),
('6483', '150000', '152900', '152921', '1', '1', '巴彦诺尔公苏木乡', '0', '', '1', '0', '0', '10'),
('6484', '150000', '152900', '152921', '1', '1', '额尔克哈什哈苏木乡', '0', '', '1', '0', '0', '10'),
('6485', '150000', '152900', '152922', '1', '1', '额肯呼都格镇', '0', '', '1', '0', '0', '10'),
('6486', '150000', '152900', '152922', '1', '1', '雅布赖镇', '0', '', '1', '0', '0', '10');
INSERT INTO `wst_communitys` VALUES ('6487', '150000', '152900', '152922', '1', '1', '阿拉腾敖包镇', '0', '', '1', '0', '0', '10'),
('6488', '150000', '152900', '152922', '1', '1', '孟根布拉格苏木乡', '0', '', '1', '0', '0', '10'),
('6489', '150000', '152900', '152922', '1', '1', '阿拉腾朝克苏木乡', '0', '', '1', '0', '0', '10'),
('6490', '150000', '152900', '152923', '1', '1', '达来呼布镇', '0', '', '1', '0', '0', '10'),
('6491', '150000', '152900', '152923', '1', '1', '额济纳旗东风镇', '0', '', '1', '0', '0', '10'),
('6492', '150000', '152900', '152923', '1', '1', '额济纳旗赛汉陶来苏木乡', '0', '', '1', '0', '0', '10'),
('6493', '150000', '152900', '152923', '1', '1', '额济纳旗马鬃山苏木乡', '0', '', '1', '0', '0', '10'),
('6494', '150000', '152900', '152923', '1', '1', '额济纳旗苏泊淖尔苏木乡', '0', '', '1', '0', '0', '10'),
('6495', '150000', '152900', '152923', '1', '1', '额济纳旗巴彦陶来农场', '0', '', '1', '0', '0', '10'),
('6496', '210000', '210100', '210102', '1', '1', '砂山街道', '0', '', '1', '0', '0', '10'),
('6497', '210000', '210100', '210102', '1', '1', '新华街道', '0', '', '1', '0', '0', '10'),
('6498', '210000', '210100', '210102', '1', '1', '吴淞街道', '0', '', '1', '0', '0', '10'),
('6499', '210000', '210100', '210102', '1', '1', '西塔街道', '0', '', '1', '0', '0', '10'),
('6500', '210000', '210100', '210102', '1', '1', '北道口街道', '0', '', '1', '0', '0', '10'),
('6501', '210000', '210100', '210102', '1', '1', '遂川街道', '0', '', '1', '0', '0', '10'),
('6502', '210000', '210100', '210102', '1', '1', '八经街道', '0', '', '1', '0', '0', '10'),
('6503', '210000', '210100', '210102', '1', '1', '马路湾街道', '0', '', '1', '0', '0', '10'),
('6504', '210000', '210100', '210102', '1', '1', '集贤街道', '0', '', '1', '0', '0', '10'),
('6505', '210000', '210100', '210102', '1', '1', '新兴街道', '0', '', '1', '0', '0', '10'),
('6506', '210000', '210100', '210102', '1', '1', '南湖街道', '0', '', '1', '0', '0', '10'),
('6507', '210000', '210100', '210102', '1', '1', '长白街道', '0', '', '1', '0', '0', '10'),
('6508', '210000', '210100', '210102', '1', '1', '太原街街道', '0', '', '1', '0', '0', '10'),
('6509', '210000', '210100', '210102', '1', '1', '北市场街道', '0', '', '1', '0', '0', '10'),
('6510', '210000', '210100', '210102', '1', '1', '南市场街道', '0', '', '1', '0', '0', '10'),
('6511', '210000', '210100', '210102', '1', '1', '中山街道', '0', '', '1', '0', '0', '10'),
('6512', '210000', '210100', '210102', '1', '1', '沈水湾街道', '0', '', '1', '0', '0', '10'),
('6513', '210000', '210100', '210103', '1', '1', '大西街道', '0', '', '1', '0', '0', '10'),
('6514', '210000', '210100', '210103', '1', '1', '滨河街道', '0', '', '1', '0', '0', '10'),
('6515', '210000', '210100', '210103', '1', '1', '万莲街道', '0', '', '1', '0', '0', '10'),
('6516', '210000', '210100', '210103', '1', '1', '大南街道', '0', '', '1', '0', '0', '10'),
('6517', '210000', '210100', '210103', '1', '1', '山东庙街道', '0', '', '1', '0', '0', '10'),
('6518', '210000', '210100', '210103', '1', '1', '朱剪炉街道', '0', '', '1', '0', '0', '10'),
('6519', '210000', '210100', '210103', '1', '1', '新北站街道', '0', '', '1', '0', '0', '10'),
('6520', '210000', '210100', '210103', '1', '1', '风雨坛街道', '0', '', '1', '0', '0', '10'),
('6521', '210000', '210100', '210103', '1', '1', '皇城街道', '0', '', '1', '0', '0', '10'),
('6522', '210000', '210100', '210103', '1', '1', '五里河街道', '0', '', '1', '0', '0', '10'),
('6523', '210000', '210100', '210104', '1', '1', '小北街道', '0', '', '1', '0', '0', '10'),
('6524', '210000', '210100', '210104', '1', '1', '大北街道', '0', '', '1', '0', '0', '10'),
('6525', '210000', '210100', '210104', '1', '1', '万泉街道', '0', '', '1', '0', '0', '10'),
('6526', '210000', '210100', '210104', '1', '1', '洮昌街道', '0', '', '1', '0', '0', '10'),
('6527', '210000', '210100', '210104', '1', '1', '文官街道', '0', '', '1', '0', '0', '10'),
('6528', '210000', '210100', '210104', '1', '1', '二台子街道', '0', '', '1', '0', '0', '10'),
('6529', '210000', '210100', '210104', '1', '1', '津桥街道', '0', '', '1', '0', '0', '10'),
('6530', '210000', '210100', '210104', '1', '1', '东站街道', '0', '', '1', '0', '0', '10'),
('6531', '210000', '210100', '210104', '1', '1', '辽沈街道', '0', '', '1', '0', '0', '10'),
('6532', '210000', '210100', '210104', '1', '1', '珠林街道', '0', '', '1', '0', '0', '10'),
('6533', '210000', '210100', '210104', '1', '1', '长安街道', '0', '', '1', '0', '0', '10'),
('6534', '210000', '210100', '210104', '1', '1', '新东街道', '0', '', '1', '0', '0', '10'),
('6535', '210000', '210100', '210104', '1', '1', '东塔街道', '0', '', '1', '0', '0', '10'),
('6536', '210000', '210100', '210105', '1', '1', '三台子街道', '0', '', '1', '0', '0', '10'),
('6537', '210000', '210100', '210105', '1', '1', '陵北街道', '0', '', '1', '0', '0', '10'),
('6538', '210000', '210100', '210105', '1', '1', '辽河街道', '0', '', '1', '0', '0', '10'),
('6539', '210000', '210100', '210105', '1', '1', '黑龙江街道', '0', '', '1', '0', '0', '10'),
('6540', '210000', '210100', '210105', '1', '1', '泰山街道', '0', '', '1', '0', '0', '10'),
('6541', '210000', '210100', '210105', '1', '1', '祟山街道', '0', '', '1', '0', '0', '10'),
('6542', '210000', '210100', '210105', '1', '1', '长江街道', '0', '', '1', '0', '0', '10'),
('6543', '210000', '210100', '210105', '1', '1', '黄河街道', '0', '', '1', '0', '0', '10'),
('6544', '210000', '210100', '210105', '1', '1', '昆山街道', '0', '', '1', '0', '0', '10'),
('6545', '210000', '210100', '210105', '1', '1', '亚明街道', '0', '', '1', '0', '0', '10'),
('6546', '210000', '210100', '210105', '1', '1', '克俭街道', '0', '', '1', '0', '0', '10'),
('6547', '210000', '210100', '210105', '1', '1', '三洞桥街道', '0', '', '1', '0', '0', '10'),
('6548', '210000', '210100', '210105', '1', '1', '华山街道', '0', '', '1', '0', '0', '10'),
('6549', '210000', '210100', '210105', '1', '1', '寿泉街道', '0', '', '1', '0', '0', '10'),
('6550', '210000', '210100', '210105', '1', '1', '塔湾街道', '0', '', '1', '0', '0', '10'),
('6551', '210000', '210100', '210105', '1', '1', '怒江街道', '0', '', '1', '0', '0', '10'),
('6552', '210000', '210100', '210105', '1', '1', '明廉街道', '0', '', '1', '0', '0', '10'),
('6553', '210000', '210100', '210105', '1', '1', '向工街道', '0', '', '1', '0', '0', '10'),
('6554', '210000', '210100', '210105', '1', '1', '新乐街道', '0', '', '1', '0', '0', '10'),
('6555', '210000', '210100', '210105', '1', '1', '太平街道', '0', '', '1', '0', '0', '10'),
('6556', '210000', '210100', '210106', '1', '1', '卫工街道', '0', '', '1', '0', '0', '10'),
('6557', '210000', '210100', '210106', '1', '1', '工人村街道', '0', '', '1', '0', '0', '10'),
('6558', '210000', '210100', '210106', '1', '1', '七路街道', '0', '', '1', '0', '0', '10'),
('6559', '210000', '210100', '210106', '1', '1', '启工街道', '0', '', '1', '0', '0', '10'),
('6560', '210000', '210100', '210106', '1', '1', '笃工街道', '0', '', '1', '0', '0', '10'),
('6561', '210000', '210100', '210106', '1', '1', '兴华街道', '0', '', '1', '0', '0', '10'),
('6562', '210000', '210100', '210106', '1', '1', '兴工街道', '0', '', '1', '0', '0', '10'),
('6563', '210000', '210100', '210106', '1', '1', '霁虹街道', '0', '', '1', '0', '0', '10'),
('6564', '210000', '210100', '210106', '1', '1', '凌空街道', '0', '', '1', '0', '0', '10'),
('6565', '210000', '210100', '210106', '1', '1', '轻重工街道', '0', '', '1', '0', '0', '10'),
('6566', '210000', '210100', '210106', '1', '1', '艳粉路官街道', '0', '', '1', '0', '0', '10'),
('6567', '210000', '210100', '210106', '1', '1', '兴齐保工街道', '0', '', '1', '0', '0', '10'),
('6568', '210000', '210100', '210106', '1', '1', '齐贤兴顺街道', '0', '', '1', '0', '0', '10'),
('6569', '210000', '210100', '210106', '1', '1', '云峰贵和街道', '0', '', '1', '0', '0', '10'),
('6570', '210000', '210100', '210111', '1', '1', '解放街道', '0', '', '1', '0', '0', '10'),
('6571', '210000', '210100', '210111', '1', '1', '铁友街道', '0', '', '1', '0', '0', '10'),
('6572', '210000', '210100', '210111', '1', '1', '民主街道', '0', '', '1', '0', '0', '10'),
('6573', '210000', '210100', '210111', '1', '1', '临湖街道', '0', '', '1', '0', '0', '10'),
('6574', '210000', '210100', '210111', '1', '1', '中兴街道', '0', '', '1', '0', '0', '10'),
('6575', '210000', '210100', '210111', '1', '1', '湖西街道', '0', '', '1', '0', '0', '10'),
('6576', '210000', '210100', '210111', '1', '1', '城郊街道', '0', '', '1', '0', '0', '10'),
('6577', '210000', '210100', '210111', '1', '1', '八一镇', '0', '', '1', '0', '0', '10'),
('6578', '210000', '210100', '210111', '1', '1', '红菱堡镇', '0', '', '1', '0', '0', '10'),
('6579', '210000', '210100', '210111', '1', '1', '林盛堡镇', '0', '', '1', '0', '0', '10'),
('6580', '210000', '210100', '210111', '1', '1', '沙河铺镇', '0', '', '1', '0', '0', '10'),
('6581', '210000', '210100', '210111', '1', '1', '十里河镇', '0', '', '1', '0', '0', '10'),
('6582', '210000', '210100', '210111', '1', '1', '陈相屯镇', '0', '', '1', '0', '0', '10'),
('6583', '210000', '210100', '210111', '1', '1', '姚千户屯镇', '0', '', '1', '0', '0', '10'),
('6584', '210000', '210100', '210111', '1', '1', '王纲堡乡', '0', '', '1', '0', '0', '10'),
('6585', '210000', '210100', '210111', '1', '1', '永乐乡', '0', '', '1', '0', '0', '10'),
('6586', '210000', '210100', '210111', '1', '1', '大沟乡', '0', '', '1', '0', '0', '10'),
('6587', '210000', '210100', '210111', '1', '1', '白清寨乡', '0', '', '1', '0', '0', '10'),
('6588', '210000', '210100', '210111', '1', '1', '佟沟乡', '0', '', '1', '0', '0', '10'),
('6589', '210000', '210100', '210111', '1', '1', '市浑河农场', '0', '', '1', '0', '0', '10'),
('6590', '210000', '210100', '210111', '1', '1', '沈阳塔山农业科技发展有限公司', '0', '', '1', '0', '0', '10'),
('6591', '210000', '210100', '210111', '1', '1', '区示范农场', '0', '', '1', '0', '0', '10'),
('6592', '210000', '210100', '210111', '1', '1', '省稻作研究所', '0', '', '1', '0', '0', '10'),
('6593', '210000', '210100', '210111', '1', '1', '区塔山林场', '0', '', '1', '0', '0', '10'),
('6594', '210000', '210100', '210112', '1', '1', '南塔街道', '0', '', '1', '0', '0', '10'),
('6595', '210000', '210100', '210112', '1', '1', '泉园街道', '0', '', '1', '0', '0', '10'),
('6596', '210000', '210100', '210112', '1', '1', '丰乐街道', '0', '', '1', '0', '0', '10'),
('6597', '210000', '210100', '210112', '1', '1', '马官桥街道', '0', '', '1', '0', '0', '10'),
('6598', '210000', '210100', '210112', '1', '1', '东陵街道', '0', '', '1', '0', '0', '10'),
('6599', '210000', '210100', '210112', '1', '1', '英达街道', '0', '', '1', '0', '0', '10'),
('6600', '210000', '210100', '210112', '1', '1', '前进街道', '0', '', '1', '0', '0', '10'),
('6601', '210000', '210100', '210112', '1', '1', '东湖街道（浑南新区）', '0', '', '1', '0', '0', '10'),
('6602', '210000', '210100', '210112', '1', '1', '五三街道（浑南新区）', '0', '', '1', '0', '0', '10'),
('6603', '210000', '210100', '210112', '1', '1', '浑河站东街道', '0', '', '1', '0', '0', '10'),
('6604', '210000', '210100', '210112', '1', '1', '浑河站西街道', '0', '', '1', '0', '0', '10'),
('6605', '210000', '210100', '210112', '1', '1', '高坎街道（棋盘山开发区）', '0', '', '1', '0', '0', '10'),
('6606', '210000', '210100', '210112', '1', '1', '满堂街道（棋盘山）', '0', '', '1', '0', '0', '10'),
('6607', '210000', '210100', '210112', '1', '1', '深井子镇', '0', '', '1', '0', '0', '10'),
('6608', '210000', '210100', '210112', '1', '1', '祝家屯镇', '0', '', '1', '0', '0', '10'),
('6609', '210000', '210100', '210112', '1', '1', '白塔堡镇', '0', '', '1', '0', '0', '10'),
('6610', '210000', '210100', '210112', '1', '1', '桃仙镇', '0', '', '1', '0', '0', '10'),
('6611', '210000', '210100', '210112', '1', '1', '李相镇', '0', '', '1', '0', '0', '10'),
('6612', '210000', '210100', '210112', '1', '1', '王滨沟乡', '0', '', '1', '0', '0', '10'),
('6613', '210000', '210100', '210113', '1', '1', '新城子街道', '0', '', '1', '0', '0', '10'),
('6614', '210000', '210100', '210113', '1', '1', '清水台街道', '0', '', '1', '0', '0', '10'),
('6615', '210000', '210100', '210113', '1', '1', '辉山街道（农业高新区）', '0', '', '1', '0', '0', '10'),
('6616', '210000', '210100', '210113', '1', '1', '道义镇', '0', '', '1', '0', '0', '10'),
('6617', '210000', '210100', '210113', '1', '1', '兴隆台锡伯族镇', '0', '', '1', '0', '0', '10'),
('6618', '210000', '210100', '210113', '1', '1', '清水台镇', '0', '', '1', '0', '0', '10'),
('6619', '210000', '210100', '210113', '1', '1', '蒲河镇', '0', '', '1', '0', '0', '10'),
('6620', '210000', '210100', '210113', '1', '1', '虎石台镇', '0', '', '1', '0', '0', '10'),
('6621', '210000', '210100', '210113', '1', '1', '财落镇', '0', '', '1', '0', '0', '10'),
('6622', '210000', '210100', '210113', '1', '1', '新城子乡', '0', '', '1', '0', '0', '10'),
('6623', '210000', '210100', '210113', '1', '1', '黄家锡伯族乡', '0', '', '1', '0', '0', '10'),
('6624', '210000', '210100', '210113', '1', '1', '石佛寺朝鲜族锡伯族乡', '0', '', '1', '0', '0', '10'),
('6625', '210000', '210100', '210113', '1', '1', '尹家乡', '0', '', '1', '0', '0', '10'),
('6626', '210000', '210100', '210113', '1', '1', '马刚乡', '0', '', '1', '0', '0', '10'),
('6627', '210000', '210100', '210113', '1', '1', '青年农场', '0', '', '1', '0', '0', '10'),
('6628', '210000', '210100', '210113', '1', '1', '前进农场', '0', '', '1', '0', '0', '10'),
('6629', '210000', '210100', '210113', '1', '1', '育新农场', '0', '', '1', '0', '0', '10'),
('6630', '210000', '210100', '210113', '1', '1', '新城子区马刚林场', '0', '', '1', '0', '0', '10'),
('6631', '210000', '210100', '210113', '1', '1', '新城子区示范农场', '0', '', '1', '0', '0', '10'),
('6632', '210000', '210100', '210113', '1', '1', '新城子区种畜场', '0', '', '1', '0', '0', '10'),
('6633', '210000', '210100', '210114', '1', '1', '迎宾路街道', '0', '', '1', '0', '0', '10'),
('6634', '210000', '210100', '210114', '1', '1', '北塔街道', '0', '', '1', '0', '0', '10'),
('6635', '210000', '210100', '210114', '1', '1', '陵西街道', '0', '', '1', '0', '0', '10'),
('6636', '210000', '210100', '210114', '1', '1', '于洪街道', '0', '', '1', '0', '0', '10'),
('6637', '210000', '210100', '210114', '1', '1', '杨士街道', '0', '', '1', '0', '0', '10'),
('6638', '210000', '210100', '210114', '1', '1', '北陵街道', '0', '', '1', '0', '0', '10'),
('6639', '210000', '210100', '210114', '1', '1', '陵东街道', '0', '', '1', '0', '0', '10'),
('6640', '210000', '210100', '210114', '1', '1', '沙岭街道', '0', '', '1', '0', '0', '10'),
('6641', '210000', '210100', '210114', '1', '1', '平罗镇', '0', '', '1', '0', '0', '10'),
('6642', '210000', '210100', '210114', '1', '1', '马三家子镇', '0', '', '1', '0', '0', '10'),
('6643', '210000', '210100', '210114', '1', '1', '大潘镇', '0', '', '1', '0', '0', '10'),
('6644', '210000', '210100', '210114', '1', '1', '造化镇', '0', '', '1', '0', '0', '10'),
('6645', '210000', '210100', '210114', '1', '1', '翟家镇', '0', '', '1', '0', '0', '10'),
('6646', '210000', '210100', '210114', '1', '1', '彰驿站镇', '0', '', '1', '0', '0', '10'),
('6647', '210000', '210100', '210114', '1', '1', '高花镇', '0', '', '1', '0', '0', '10'),
('6648', '210000', '210100', '210114', '1', '1', '大兴朝鲜族乡', '0', '', '1', '0', '0', '10'),
('6649', '210000', '210100', '210114', '1', '1', '大青中朝友谊乡', '0', '', '1', '0', '0', '10'),
('6650', '210000', '210100', '210114', '1', '1', '光辉乡', '0', '', '1', '0', '0', '10'),
('6651', '210000', '210100', '210114', '1', '1', '马三家劳动教养院', '0', '', '1', '0', '0', '10'),
('6652', '210000', '210100', '210114', '1', '1', '光辉农场', '0', '', '1', '0', '0', '10'),
('6653', '210000', '210100', '210114', '1', '1', '北陵农场', '0', '', '1', '0', '0', '10'),
('6654', '210000', '210100', '210114', '1', '1', '监狱城', '0', '', '1', '0', '0', '10'),
('6655', '210000', '210100', '210122', '1', '1', '辽中镇', '0', '', '1', '0', '0', '10'),
('6656', '210000', '210100', '210122', '1', '1', '于家房镇', '0', '', '1', '0', '0', '10'),
('6657', '210000', '210100', '210122', '1', '1', '朱家房镇', '0', '', '1', '0', '0', '10'),
('6658', '210000', '210100', '210122', '1', '1', '冷子堡镇', '0', '', '1', '0', '0', '10'),
('6659', '210000', '210100', '210122', '1', '1', '刘二堡镇', '0', '', '1', '0', '0', '10'),
('6660', '210000', '210100', '210122', '1', '1', '茨榆坨镇', '0', '', '1', '0', '0', '10'),
('6661', '210000', '210100', '210122', '1', '1', '新民屯镇', '0', '', '1', '0', '0', '10'),
('6662', '210000', '210100', '210122', '1', '1', '满都户镇', '0', '', '1', '0', '0', '10'),
('6663', '210000', '210100', '210122', '1', '1', '杨士岗镇', '0', '', '1', '0', '0', '10'),
('6664', '210000', '210100', '210122', '1', '1', '肖寨门镇', '0', '', '1', '0', '0', '10'),
('6665', '210000', '210100', '210122', '1', '1', '长滩镇', '0', '', '1', '0', '0', '10'),
('6666', '210000', '210100', '210122', '1', '1', '四方台镇', '0', '', '1', '0', '0', '10'),
('6667', '210000', '210100', '210122', '1', '1', '城郊乡', '0', '', '1', '0', '0', '10'),
('6668', '210000', '210100', '210122', '1', '1', '六间房乡', '0', '', '1', '0', '0', '10'),
('6669', '210000', '210100', '210122', '1', '1', '养士堡乡', '0', '', '1', '0', '0', '10'),
('6670', '210000', '210100', '210122', '1', '1', '潘家堡乡', '0', '', '1', '0', '0', '10'),
('6671', '210000', '210100', '210122', '1', '1', '老观坨乡', '0', '', '1', '0', '0', '10'),
('6672', '210000', '210100', '210122', '1', '1', '老大房乡', '0', '', '1', '0', '0', '10'),
('6673', '210000', '210100', '210122', '1', '1', '大黑岗子乡', '0', '', '1', '0', '0', '10'),
('6674', '210000', '210100', '210122', '1', '1', '牛心坨乡', '0', '', '1', '0', '0', '10'),
('6675', '210000', '210100', '210122', '1', '1', '四方台子农场', '0', '', '1', '0', '0', '10'),
('6676', '210000', '210100', '210123', '1', '1', '康平镇', '0', '', '1', '0', '0', '10'),
('6677', '210000', '210100', '210123', '1', '1', '小城子镇', '0', '', '1', '0', '0', '10'),
('6678', '210000', '210100', '210123', '1', '1', '张强镇', '0', '', '1', '0', '0', '10'),
('6679', '210000', '210100', '210123', '1', '1', '方家屯镇', '0', '', '1', '0', '0', '10'),
('6680', '210000', '210100', '210123', '1', '1', '东关屯镇', '0', '', '1', '0', '0', '10'),
('6681', '210000', '210100', '210123', '1', '1', '郝官屯镇', '0', '', '1', '0', '0', '10'),
('6682', '210000', '210100', '210123', '1', '1', '二牛所口镇', '0', '', '1', '0', '0', '10'),
('6683', '210000', '210100', '210123', '1', '1', '北四家子乡', '0', '', '1', '0', '0', '10'),
('6684', '210000', '210100', '210123', '1', '1', '两家子乡', '0', '', '1', '0', '0', '10'),
('6685', '210000', '210100', '210123', '1', '1', '山东屯乡', '0', '', '1', '0', '0', '10'),
('6686', '210000', '210100', '210123', '1', '1', '海洲窝堡乡', '0', '', '1', '0', '0', '10'),
('6687', '210000', '210100', '210123', '1', '1', '沙金台蒙古族满族乡', '0', '', '1', '0', '0', '10'),
('6688', '210000', '210100', '210123', '1', '1', '柳树屯蒙古族满族乡', '0', '', '1', '0', '0', '10'),
('6689', '210000', '210100', '210123', '1', '1', '西关屯蒙古族满族乡', '0', '', '1', '0', '0', '10'),
('6690', '210000', '210100', '210123', '1', '1', '东升满族蒙古族乡', '0', '', '1', '0', '0', '10'),
('6691', '210000', '210100', '210123', '1', '1', '辽宁省康平监狱', '0', '', '1', '0', '0', '10'),
('6692', '210000', '210100', '210123', '1', '1', '三台子畜牧场', '0', '', '1', '0', '0', '10'),
('6693', '210000', '210100', '210124', '1', '1', '法库镇', '0', '', '1', '0', '0', '10'),
('6694', '210000', '210100', '210124', '1', '1', '大孤家子镇', '0', '', '1', '0', '0', '10'),
('6695', '210000', '210100', '210124', '1', '1', '三面船镇', '0', '', '1', '0', '0', '10'),
('6696', '210000', '210100', '210124', '1', '1', '秀水河子镇', '0', '', '1', '0', '0', '10'),
('6697', '210000', '210100', '210124', '1', '1', '叶茂台镇', '0', '', '1', '0', '0', '10'),
('6698', '210000', '210100', '210124', '1', '1', '登仕堡子镇', '0', '', '1', '0', '0', '10'),
('6699', '210000', '210100', '210124', '1', '1', '柏家沟镇', '0', '', '1', '0', '0', '10'),
('6700', '210000', '210100', '210124', '1', '1', '丁家房镇', '0', '', '1', '0', '0', '10'),
('6701', '210000', '210100', '210124', '1', '1', '慈恩寺乡', '0', '', '1', '0', '0', '10'),
('6702', '210000', '210100', '210124', '1', '1', '孟家乡', '0', '', '1', '0', '0', '10'),
('6703', '210000', '210100', '210124', '1', '1', '和平乡', '0', '', '1', '0', '0', '10'),
('6704', '210000', '210100', '210124', '1', '1', '十间房乡', '0', '', '1', '0', '0', '10'),
('6705', '210000', '210100', '210124', '1', '1', '冯贝堡乡', '0', '', '1', '0', '0', '10'),
('6706', '210000', '210100', '210124', '1', '1', '依牛堡子乡', '0', '', '1', '0', '0', '10'),
('6707', '210000', '210100', '210124', '1', '1', '五台子乡', '0', '', '1', '0', '0', '10'),
('6708', '210000', '210100', '210124', '1', '1', '四家子蒙古族乡', '0', '', '1', '0', '0', '10'),
('6709', '210000', '210100', '210124', '1', '1', '双台子乡', '0', '', '1', '0', '0', '10'),
('6710', '210000', '210100', '210124', '1', '1', '卧牛石乡', '0', '', '1', '0', '0', '10'),
('6711', '210000', '210100', '210124', '1', '1', '包家屯乡', '0', '', '1', '0', '0', '10'),
('6712', '210000', '210100', '210181', '1', '1', '东城街道', '0', '', '1', '0', '0', '10'),
('6713', '210000', '210100', '210181', '1', '1', '辽滨街道', '0', '', '1', '0', '0', '10'),
('6714', '210000', '210100', '210181', '1', '1', '西城街道', '0', '', '1', '0', '0', '10'),
('6715', '210000', '210100', '210181', '1', '1', '新柳街道', '0', '', '1', '0', '0', '10'),
('6716', '210000', '210100', '210181', '1', '1', '新城街道', '0', '', '1', '0', '0', '10'),
('6717', '210000', '210100', '210181', '1', '1', '大红旗镇', '0', '', '1', '0', '0', '10'),
('6718', '210000', '210100', '210181', '1', '1', '梁山镇', '0', '', '1', '0', '0', '10'),
('6719', '210000', '210100', '210181', '1', '1', '公主屯镇', '0', '', '1', '0', '0', '10'),
('6720', '210000', '210100', '210181', '1', '1', '兴隆镇', '0', '', '1', '0', '0', '10'),
('6721', '210000', '210100', '210181', '1', '1', '前当堡镇', '0', '', '1', '0', '0', '10'),
('6722', '210000', '210100', '210181', '1', '1', '大民屯镇', '0', '', '1', '0', '0', '10'),
('6723', '210000', '210100', '210181', '1', '1', '大柳屯镇', '0', '', '1', '0', '0', '10'),
('6724', '210000', '210100', '210181', '1', '1', '兴隆堡镇', '0', '', '1', '0', '0', '10'),
('6725', '210000', '210100', '210181', '1', '1', '胡台镇', '0', '', '1', '0', '0', '10'),
('6726', '210000', '210100', '210181', '1', '1', '法哈牛镇', '0', '', '1', '0', '0', '10'),
('6727', '210000', '210100', '210181', '1', '1', '柳河沟镇', '0', '', '1', '0', '0', '10'),
('6728', '210000', '210100', '210181', '1', '1', '高台子乡', '0', '', '1', '0', '0', '10'),
('6729', '210000', '210100', '210181', '1', '1', '金五台子乡', '0', '', '1', '0', '0', '10'),
('6730', '210000', '210100', '210181', '1', '1', '红旗乡', '0', '', '1', '0', '0', '10'),
('6731', '210000', '210100', '210181', '1', '1', '卢家屯乡', '0', '', '1', '0', '0', '10'),
('6732', '210000', '210100', '210181', '1', '1', '姚堡乡', '0', '', '1', '0', '0', '10'),
('6733', '210000', '210100', '210181', '1', '1', '周坨子乡', '0', '', '1', '0', '0', '10'),
('6734', '210000', '210100', '210181', '1', '1', '于家窝堡乡', '0', '', '1', '0', '0', '10'),
('6735', '210000', '210100', '210181', '1', '1', '新农乡', '0', '', '1', '0', '0', '10'),
('6736', '210000', '210100', '210181', '1', '1', '东蛇山子乡', '0', '', '1', '0', '0', '10'),
('6737', '210000', '210100', '210181', '1', '1', '陶家屯乡', '0', '', '1', '0', '0', '10'),
('6738', '210000', '210100', '210181', '1', '1', '罗家房乡', '0', '', '1', '0', '0', '10'),
('6739', '210000', '210100', '210181', '1', '1', '三道岗子乡', '0', '', '1', '0', '0', '10'),
('6740', '210000', '210100', '210181', '1', '1', '张家屯乡', '0', '', '1', '0', '0', '10'),
('6741', '210000', '210200', '210202', '1', '1', '海军广场街道', '0', '', '1', '0', '0', '10'),
('6742', '210000', '210200', '210202', '1', '1', '桂林街道', '0', '', '1', '0', '0', '10'),
('6743', '210000', '210200', '210202', '1', '1', '人民路街道', '0', '', '1', '0', '0', '10'),
('6744', '210000', '210200', '210202', '1', '1', '青泥洼桥街道', '0', '', '1', '0', '0', '10'),
('6745', '210000', '210200', '210202', '1', '1', '昆明街道', '0', '', '1', '0', '0', '10'),
('6746', '210000', '210200', '210202', '1', '1', '葵英街道', '0', '', '1', '0', '0', '10'),
('6747', '210000', '210200', '210202', '1', '1', '桃源街道', '0', '', '1', '0', '0', '10'),
('6748', '210000', '210200', '210202', '1', '1', '老虎滩街道', '0', '', '1', '0', '0', '10'),
('6749', '210000', '210200', '210203', '1', '1', '香炉礁街道', '0', '', '1', '0', '0', '10'),
('6750', '210000', '210200', '210203', '1', '1', '站北街道', '0', '', '1', '0', '0', '10'),
('6751', '210000', '210200', '210203', '1', '1', '日新街道', '0', '', '1', '0', '0', '10'),
('6752', '210000', '210200', '210203', '1', '1', '北京街道', '0', '', '1', '0', '0', '10'),
('6753', '210000', '210200', '210203', '1', '1', '八一路街道', '0', '', '1', '0', '0', '10'),
('6754', '210000', '210200', '210203', '1', '1', '人民广场街道', '0', '', '1', '0', '0', '10'),
('6755', '210000', '210200', '210203', '1', '1', '白云街道', '0', '', '1', '0', '0', '10'),
('6756', '210000', '210200', '210204', '1', '1', '中山公园街道', '0', '', '1', '0', '0', '10'),
('6757', '210000', '210200', '210204', '1', '1', '白山路街道', '0', '', '1', '0', '0', '10'),
('6758', '210000', '210200', '210204', '1', '1', '兴工街道', '0', '', '1', '0', '0', '10'),
('6759', '210000', '210200', '210204', '1', '1', '春柳街道', '0', '', '1', '0', '0', '10'),
('6760', '210000', '210200', '210204', '1', '1', '马栏街道', '0', '', '1', '0', '0', '10'),
('6761', '210000', '210200', '210204', '1', '1', '南沙河口街道', '0', '', '1', '0', '0', '10'),
('6762', '210000', '210200', '210204', '1', '1', '黑石礁街道', '0', '', '1', '0', '0', '10'),
('6763', '210000', '210200', '210204', '1', '1', '李家街道', '0', '', '1', '0', '0', '10'),
('6764', '210000', '210200', '210204', '1', '1', '星海湾街道', '0', '', '1', '0', '0', '10'),
('6765', '210000', '210200', '210211', '1', '1', '周水子街道', '0', '', '1', '0', '0', '10'),
('6766', '210000', '210200', '210211', '1', '1', '椒金山街道', '0', '', '1', '0', '0', '10'),
('6767', '210000', '210200', '210211', '1', '1', '甘井子街道', '0', '', '1', '0', '0', '10'),
('6768', '210000', '210200', '210211', '1', '1', '南关岭街道', '0', '', '1', '0', '0', '10'),
('6769', '210000', '210200', '210211', '1', '1', '泡崖街道', '0', '', '1', '0', '0', '10'),
('6770', '210000', '210200', '210211', '1', '1', '中华路街道', '0', '', '1', '0', '0', '10'),
('6771', '210000', '210200', '210211', '1', '1', '兴华街道', '0', '', '1', '0', '0', '10'),
('6772', '210000', '210200', '210211', '1', '1', '机场街道', '0', '', '1', '0', '0', '10'),
('6773', '210000', '210200', '210211', '1', '1', '辛寨子街道', '0', '', '1', '0', '0', '10'),
('6774', '210000', '210200', '210211', '1', '1', '红旗街道', '0', '', '1', '0', '0', '10'),
('6775', '210000', '210200', '210211', '1', '1', '凌水街道', '0', '', '1', '0', '0', '10'),
('6776', '210000', '210200', '210211', '1', '1', '大连湾街道', '0', '', '1', '0', '0', '10'),
('6777', '210000', '210200', '210211', '1', '1', '泉水街道', '0', '', '1', '0', '0', '10'),
('6778', '210000', '210200', '210211', '1', '1', '革镇堡镇', '0', '', '1', '0', '0', '10'),
('6779', '210000', '210200', '210211', '1', '1', '营城子镇', '0', '', '1', '0', '0', '10'),
('6780', '210000', '210200', '210211', '1', '1', '大连华侨果树农场', '0', '', '1', '0', '0', '10'),
('6781', '210000', '210200', '210211', '1', '1', '大连华侨兴达实业公司', '0', '', '1', '0', '0', '10'),
('6782', '210000', '210200', '210211', '1', '1', '大连华侨鑫山企业公司', '0', '', '1', '0', '0', '10'),
('6783', '210000', '210200', '210211', '1', '1', '大连南关岭农场', '0', '', '1', '0', '0', '10'),
('6784', '210000', '210200', '210212', '1', '1', '登峰街道', '0', '', '1', '0', '0', '10'),
('6785', '210000', '210200', '210212', '1', '1', '市场街道', '0', '', '1', '0', '0', '10'),
('6786', '210000', '210200', '210212', '1', '1', '得胜街道', '0', '', '1', '0', '0', '10'),
('6787', '210000', '210200', '210212', '1', '1', '光荣街道', '0', '', '1', '0', '0', '10'),
('6788', '210000', '210200', '210212', '1', '1', '水师营街道', '0', '', '1', '0', '0', '10'),
('6789', '210000', '210200', '210212', '1', '1', '龙王塘街道', '0', '', '1', '0', '0', '10'),
('6790', '210000', '210200', '210212', '1', '1', '铁山街道', '0', '', '1', '0', '0', '10'),
('6791', '210000', '210200', '210212', '1', '1', '江西街道', '0', '', '1', '0', '0', '10'),
('6792', '210000', '210200', '210212', '1', '1', '双岛湾街道', '0', '', '1', '0', '0', '10'),
('6793', '210000', '210200', '210212', '1', '1', '三涧堡街道', '0', '', '1', '0', '0', '10'),
('6794', '210000', '210200', '210212', '1', '1', '长城街道', '0', '', '1', '0', '0', '10'),
('6795', '210000', '210200', '210212', '1', '1', '龙头街道', '0', '', '1', '0', '0', '10'),
('6796', '210000', '210200', '210212', '1', '1', '北海街道', '0', '', '1', '0', '0', '10'),
('6797', '210000', '210200', '210212', '1', '1', '旅顺开发区', '0', '', '1', '0', '0', '10'),
('6798', '210000', '210200', '210212', '1', '1', '大连奶牛场', '0', '', '1', '0', '0', '10'),
('6799', '210000', '210200', '210213', '1', '1', '拥政街道', '0', '', '1', '0', '0', '10'),
('6800', '210000', '210200', '210213', '1', '1', '友谊街道', '0', '', '1', '0', '0', '10'),
('6801', '210000', '210200', '210213', '1', '1', '光明街道', '0', '', '1', '0', '0', '10'),
('6802', '210000', '210200', '210213', '1', '1', '马桥子街道', '0', '', '1', '0', '0', '10'),
('6803', '210000', '210200', '210213', '1', '1', '海青岛街道', '0', '', '1', '0', '0', '10'),
('6804', '210000', '210200', '210213', '1', '1', '大孤山街道', '0', '', '1', '0', '0', '10'),
('6805', '210000', '210200', '210213', '1', '1', '中长街道', '0', '', '1', '0', '0', '10'),
('6806', '210000', '210200', '210213', '1', '1', '站前街道', '0', '', '1', '0', '0', '10'),
('6807', '210000', '210200', '210213', '1', '1', '先进街道', '0', '', '1', '0', '0', '10'),
('6808', '210000', '210200', '210213', '1', '1', '董家沟街道', '0', '', '1', '0', '0', '10'),
('6809', '210000', '210200', '210213', '1', '1', '金满街道', '0', '', '1', '0', '0', '10'),
('6810', '210000', '210200', '210213', '1', '1', '湾里街道', '0', '', '1', '0', '0', '10'),
('6811', '210000', '210200', '210213', '1', '1', '大李家镇', '0', '', '1', '0', '0', '10'),
('6812', '210000', '210200', '210213', '1', '1', '得胜镇', '0', '', '1', '0', '0', '10');
INSERT INTO `wst_communitys` VALUES ('6813', '210000', '210200', '210213', '1', '1', '华家屯镇', '0', '', '1', '0', '0', '10'),
('6814', '210000', '210200', '210213', '1', '1', '二十里堡镇', '0', '', '1', '0', '0', '10'),
('6815', '210000', '210200', '210213', '1', '1', '三十里堡镇', '0', '', '1', '0', '0', '10'),
('6816', '210000', '210200', '210213', '1', '1', '亮甲店镇', '0', '', '1', '0', '0', '10'),
('6817', '210000', '210200', '210213', '1', '1', '登沙河镇', '0', '', '1', '0', '0', '10'),
('6818', '210000', '210200', '210213', '1', '1', '杏树屯镇', '0', '', '1', '0', '0', '10'),
('6819', '210000', '210200', '210213', '1', '1', '石河满族镇', '0', '', '1', '0', '0', '10'),
('6820', '210000', '210200', '210213', '1', '1', '大魏家镇', '0', '', '1', '0', '0', '10'),
('6821', '210000', '210200', '210213', '1', '1', '向应镇', '0', '', '1', '0', '0', '10'),
('6822', '210000', '210200', '210213', '1', '1', '七顶山满族乡', '0', '', '1', '0', '0', '10'),
('6823', '210000', '210200', '210224', '1', '1', '大长山岛镇', '0', '', '1', '0', '0', '10'),
('6824', '210000', '210200', '210224', '1', '1', '獐子岛镇', '0', '', '1', '0', '0', '10'),
('6825', '210000', '210200', '210224', '1', '1', '小长山乡', '0', '', '1', '0', '0', '10'),
('6826', '210000', '210200', '210224', '1', '1', '广鹿乡', '0', '', '1', '0', '0', '10'),
('6827', '210000', '210200', '210224', '1', '1', '海洋乡', '0', '', '1', '0', '0', '10'),
('6828', '210000', '210200', '210281', '1', '1', '新华', '0', '', '1', '0', '0', '10'),
('6829', '210000', '210200', '210281', '1', '1', '文兰', '0', '', '1', '0', '0', '10'),
('6830', '210000', '210200', '210281', '1', '1', '岭东', '0', '', '1', '0', '0', '10'),
('6831', '210000', '210200', '210281', '1', '1', '共济', '0', '', '1', '0', '0', '10'),
('6832', '210000', '210200', '210281', '1', '1', '铁东', '0', '', '1', '0', '0', '10'),
('6833', '210000', '210200', '210281', '1', '1', '祝华', '0', '', '1', '0', '0', '10'),
('6834', '210000', '210200', '210281', '1', '1', '岗店', '0', '', '1', '0', '0', '10'),
('6835', '210000', '210200', '210281', '1', '1', '太阳街道', '0', '', '1', '0', '0', '10'),
('6836', '210000', '210200', '210281', '1', '1', '长兴岛', '0', '', '1', '0', '0', '10'),
('6837', '210000', '210200', '210281', '1', '1', '复州城镇', '0', '', '1', '0', '0', '10'),
('6838', '210000', '210200', '210281', '1', '1', '复州湾镇', '0', '', '1', '0', '0', '10'),
('6839', '210000', '210200', '210281', '1', '1', '松树镇', '0', '', '1', '0', '0', '10'),
('6840', '210000', '210200', '210281', '1', '1', '得利寺镇', '0', '', '1', '0', '0', '10'),
('6841', '210000', '210200', '210281', '1', '1', '万家岭镇', '0', '', '1', '0', '0', '10'),
('6842', '210000', '210200', '210281', '1', '1', '许屯镇', '0', '', '1', '0', '0', '10'),
('6843', '210000', '210200', '210281', '1', '1', '永宁镇', '0', '', '1', '0', '0', '10'),
('6844', '210000', '210200', '210281', '1', '1', '谢屯镇', '0', '', '1', '0', '0', '10'),
('6845', '210000', '210200', '210281', '1', '1', '炮台镇', '0', '', '1', '0', '0', '10'),
('6846', '210000', '210200', '210281', '1', '1', '李店镇', '0', '', '1', '0', '0', '10'),
('6847', '210000', '210200', '210281', '1', '1', '老虎屯镇', '0', '', '1', '0', '0', '10'),
('6848', '210000', '210200', '210281', '1', '1', '东岗镇', '0', '', '1', '0', '0', '10'),
('6849', '210000', '210200', '210281', '1', '1', '李官镇', '0', '', '1', '0', '0', '10'),
('6850', '210000', '210200', '210281', '1', '1', '仙浴湾镇', '0', '', '1', '0', '0', '10'),
('6851', '210000', '210200', '210281', '1', '1', '赵屯乡', '0', '', '1', '0', '0', '10'),
('6852', '210000', '210200', '210281', '1', '1', '土城乡', '0', '', '1', '0', '0', '10'),
('6853', '210000', '210200', '210281', '1', '1', '阎店乡', '0', '', '1', '0', '0', '10'),
('6854', '210000', '210200', '210281', '1', '1', '西杨乡', '0', '', '1', '0', '0', '10'),
('6855', '210000', '210200', '210281', '1', '1', '驼山乡', '0', '', '1', '0', '0', '10'),
('6856', '210000', '210200', '210281', '1', '1', '三台满族乡', '0', '', '1', '0', '0', '10'),
('6857', '210000', '210200', '210281', '1', '1', '交流岛乡', '0', '', '1', '0', '0', '10'),
('6858', '210000', '210200', '210281', '1', '1', '泡崖乡', '0', '', '1', '0', '0', '10'),
('6859', '210000', '210200', '210281', '1', '1', '杨家满族乡', '0', '', '1', '0', '0', '10'),
('6860', '210000', '210200', '210282', '1', '1', '丰荣街道', '0', '', '1', '0', '0', '10'),
('6861', '210000', '210200', '210282', '1', '1', '铁西街道', '0', '', '1', '0', '0', '10'),
('6862', '210000', '210200', '210282', '1', '1', '太平街道', '0', '', '1', '0', '0', '10'),
('6863', '210000', '210200', '210282', '1', '1', '南山街道', '0', '', '1', '0', '0', '10'),
('6864', '210000', '210200', '210282', '1', '1', '皮口镇', '0', '', '1', '0', '0', '10'),
('6865', '210000', '210200', '210282', '1', '1', '城子坦镇', '0', '', '1', '0', '0', '10'),
('6866', '210000', '210200', '210282', '1', '1', '大刘家镇', '0', '', '1', '0', '0', '10'),
('6867', '210000', '210200', '210282', '1', '1', '杨树房镇', '0', '', '1', '0', '0', '10'),
('6868', '210000', '210200', '210282', '1', '1', '双塔镇', '0', '', '1', '0', '0', '10'),
('6869', '210000', '210200', '210282', '1', '1', '安波镇', '0', '', '1', '0', '0', '10'),
('6870', '210000', '210200', '210282', '1', '1', '四平镇', '0', '', '1', '0', '0', '10'),
('6871', '210000', '210200', '210282', '1', '1', '沙包镇', '0', '', '1', '0', '0', '10'),
('6872', '210000', '210200', '210282', '1', '1', '瓦窝镇', '0', '', '1', '0', '0', '10'),
('6873', '210000', '210200', '210282', '1', '1', '元台镇', '0', '', '1', '0', '0', '10'),
('6874', '210000', '210200', '210282', '1', '1', '大谭镇', '0', '', '1', '0', '0', '10'),
('6875', '210000', '210200', '210282', '1', '1', '夹河庙镇', '0', '', '1', '0', '0', '10'),
('6876', '210000', '210200', '210282', '1', '1', '莲山镇', '0', '', '1', '0', '0', '10'),
('6877', '210000', '210200', '210282', '1', '1', '星台镇', '0', '', '1', '0', '0', '10'),
('6878', '210000', '210200', '210282', '1', '1', '墨盘乡', '0', '', '1', '0', '0', '10'),
('6879', '210000', '210200', '210282', '1', '1', '同益乡', '0', '', '1', '0', '0', '10'),
('6880', '210000', '210200', '210282', '1', '1', '乐甲满族乡', '0', '', '1', '0', '0', '10'),
('6881', '210000', '210200', '210283', '1', '1', '城关街道', '0', '', '1', '0', '0', '10'),
('6882', '210000', '210200', '210283', '1', '1', '新华街道', '0', '', '1', '0', '0', '10'),
('6883', '210000', '210200', '210283', '1', '1', '兴达街道', '0', '', '1', '0', '0', '10'),
('6884', '210000', '210200', '210283', '1', '1', '昌盛街道', '0', '', '1', '0', '0', '10'),
('6885', '210000', '210200', '210283', '1', '1', '青堆镇', '0', '', '1', '0', '0', '10'),
('6886', '210000', '210200', '210283', '1', '1', '徐岭镇', '0', '', '1', '0', '0', '10'),
('6887', '210000', '210200', '210283', '1', '1', '黑岛镇', '0', '', '1', '0', '0', '10'),
('6888', '210000', '210200', '210283', '1', '1', '栗子房镇', '0', '', '1', '0', '0', '10'),
('6889', '210000', '210200', '210283', '1', '1', '大营镇', '0', '', '1', '0', '0', '10'),
('6890', '210000', '210200', '210283', '1', '1', '塔岭满族镇', '0', '', '1', '0', '0', '10'),
('6891', '210000', '210200', '210283', '1', '1', '仙人洞镇', '0', '', '1', '0', '0', '10'),
('6892', '210000', '210200', '210283', '1', '1', '蓉花山镇', '0', '', '1', '0', '0', '10'),
('6893', '210000', '210200', '210283', '1', '1', '长岭镇', '0', '', '1', '0', '0', '10'),
('6894', '210000', '210200', '210283', '1', '1', '荷花山镇', '0', '', '1', '0', '0', '10'),
('6895', '210000', '210200', '210283', '1', '1', '城山镇', '0', '', '1', '0', '0', '10'),
('6896', '210000', '210200', '210283', '1', '1', '光明山镇', '0', '', '1', '0', '0', '10'),
('6897', '210000', '210200', '210283', '1', '1', '大郑镇', '0', '', '1', '0', '0', '10'),
('6898', '210000', '210200', '210283', '1', '1', '明阳镇', '0', '', '1', '0', '0', '10'),
('6899', '210000', '210200', '210283', '1', '1', '吴炉镇', '0', '', '1', '0', '0', '10'),
('6900', '210000', '210200', '210283', '1', '1', '王家镇', '0', '', '1', '0', '0', '10'),
('6901', '210000', '210200', '210283', '1', '1', '鞍子山乡', '0', '', '1', '0', '0', '10'),
('6902', '210000', '210200', '210283', '1', '1', '太平岭满族乡', '0', '', '1', '0', '0', '10'),
('6903', '210000', '210200', '210283', '1', '1', '步云山乡', '0', '', '1', '0', '0', '10'),
('6904', '210000', '210200', '210283', '1', '1', '桂云花满族乡', '0', '', '1', '0', '0', '10'),
('6905', '210000', '210200', '210283', '1', '1', '兰店乡', '0', '', '1', '0', '0', '10'),
('6906', '210000', '210200', '210283', '1', '1', '石城乡', '0', '', '1', '0', '0', '10'),
('6907', '210000', '210300', '210302', '1', '1', '长甸', '0', '', '1', '0', '0', '10'),
('6908', '210000', '210300', '210302', '1', '1', '解放', '0', '', '1', '0', '0', '10'),
('6909', '210000', '210300', '210302', '1', '1', '山南', '0', '', '1', '0', '0', '10'),
('6910', '210000', '210300', '210302', '1', '1', '园林', '0', '', '1', '0', '0', '10'),
('6911', '210000', '210300', '210302', '1', '1', '胜利', '0', '', '1', '0', '0', '10'),
('6912', '210000', '210300', '210302', '1', '1', '站前', '0', '', '1', '0', '0', '10'),
('6913', '210000', '210300', '210302', '1', '1', '钢城', '0', '', '1', '0', '0', '10'),
('6914', '210000', '210300', '210302', '1', '1', '和平', '0', '', '1', '0', '0', '10'),
('6915', '210000', '210300', '210302', '1', '1', '对炉', '0', '', '1', '0', '0', '10'),
('6916', '210000', '210300', '210302', '1', '1', '东长甸', '0', '', '1', '0', '0', '10'),
('6917', '210000', '210300', '210302', '1', '1', '湖南', '0', '', '1', '0', '0', '10'),
('6918', '210000', '210300', '210302', '1', '1', '常青', '0', '', '1', '0', '0', '10'),
('6919', '210000', '210300', '210302', '1', '1', '新兴', '0', '', '1', '0', '0', '10'),
('6920', '210000', '210300', '210303', '1', '1', '启明街道', '0', '', '1', '0', '0', '10'),
('6921', '210000', '210300', '210303', '1', '1', '繁荣街道', '0', '', '1', '0', '0', '10'),
('6922', '210000', '210300', '210303', '1', '1', '八家子街道', '0', '', '1', '0', '0', '10'),
('6923', '210000', '210300', '210303', '1', '1', '兴盛街道', '0', '', '1', '0', '0', '10'),
('6924', '210000', '210300', '210303', '1', '1', '共和街道', '0', '', '1', '0', '0', '10'),
('6925', '210000', '210300', '210303', '1', '1', '永乐街道', '0', '', '1', '0', '0', '10'),
('6926', '210000', '210300', '210303', '1', '1', '北陶官街道', '0', '', '1', '0', '0', '10'),
('6927', '210000', '210300', '210303', '1', '1', '南华街道', '0', '', '1', '0', '0', '10'),
('6928', '210000', '210300', '210303', '1', '1', '大陆街道', '0', '', '1', '0', '0', '10'),
('6929', '210000', '210300', '210303', '1', '1', '新陶官街道', '0', '', '1', '0', '0', '10'),
('6930', '210000', '210300', '210304', '1', '1', '友好', '0', '', '1', '0', '0', '10'),
('6931', '210000', '210300', '210304', '1', '1', '双山', '0', '', '1', '0', '0', '10'),
('6932', '210000', '210300', '210304', '1', '1', '立山', '0', '', '1', '0', '0', '10'),
('6933', '210000', '210300', '210304', '1', '1', '曙光', '0', '', '1', '0', '0', '10'),
('6934', '210000', '210300', '210304', '1', '1', '灵山', '0', '', '1', '0', '0', '10'),
('6935', '210000', '210300', '210304', '1', '1', '深南', '0', '', '1', '0', '0', '10'),
('6936', '210000', '210300', '210304', '1', '1', '深北', '0', '', '1', '0', '0', '10'),
('6937', '210000', '210300', '210304', '1', '1', '沙河', '0', '', '1', '0', '0', '10'),
('6938', '210000', '210300', '210304', '1', '1', '沙河镇', '0', '', '1', '0', '0', '10'),
('6939', '210000', '210300', '210311', '1', '1', '旧堡街道', '0', '', '1', '0', '0', '10'),
('6940', '210000', '210300', '210311', '1', '1', '大孤山街道', '0', '', '1', '0', '0', '10'),
('6941', '210000', '210300', '210311', '1', '1', '东鞍山镇', '0', '', '1', '0', '0', '10'),
('6942', '210000', '210300', '210311', '1', '1', '唐家房镇', '0', '', '1', '0', '0', '10'),
('6943', '210000', '210300', '210311', '1', '1', '大孤山镇', '0', '', '1', '0', '0', '10'),
('6944', '210000', '210300', '210311', '1', '1', '千山镇', '0', '', '1', '0', '0', '10'),
('6945', '210000', '210300', '210311', '1', '1', '齐大山镇', '0', '', '1', '0', '0', '10'),
('6946', '210000', '210300', '210311', '1', '1', '达道湾镇', '0', '', '1', '0', '0', '10'),
('6947', '210000', '210300', '210311', '1', '1', '宁远镇', '0', '', '1', '0', '0', '10'),
('6948', '210000', '210300', '210311', '1', '1', '汤岗子镇', '0', '', '1', '0', '0', '10'),
('6949', '210000', '210300', '210311', '1', '1', '鞍山高新区', '0', '', '1', '0', '0', '10'),
('6950', '210000', '210300', '210311', '1', '1', '千山风景区管理委员会', '0', '', '1', '0', '0', '10'),
('6951', '210000', '210300', '210321', '1', '1', '台安镇', '0', '', '1', '0', '0', '10'),
('6952', '210000', '210300', '210321', '1', '1', '西佛镇', '0', '', '1', '0', '0', '10'),
('6953', '210000', '210300', '210321', '1', '1', '新开河镇', '0', '', '1', '0', '0', '10'),
('6954', '210000', '210300', '210321', '1', '1', '黄沙坨镇', '0', '', '1', '0', '0', '10'),
('6955', '210000', '210300', '210321', '1', '1', '高力房镇', '0', '', '1', '0', '0', '10'),
('6956', '210000', '210300', '210321', '1', '1', '桑林镇', '0', '', '1', '0', '0', '10'),
('6957', '210000', '210300', '210321', '1', '1', '富家镇', '0', '', '1', '0', '0', '10'),
('6958', '210000', '210300', '210321', '1', '1', '达牛镇', '0', '', '1', '0', '0', '10'),
('6959', '210000', '210300', '210321', '1', '1', '韭菜台镇', '0', '', '1', '0', '0', '10'),
('6960', '210000', '210300', '210321', '1', '1', '新台镇', '0', '', '1', '0', '0', '10'),
('6961', '210000', '210300', '210321', '1', '1', '桓洞镇', '0', '', '1', '0', '0', '10'),
('6962', '210000', '210300', '210321', '1', '1', '新华农场', '0', '', '1', '0', '0', '10'),
('6963', '210000', '210300', '210321', '1', '1', '洪家农牧场', '0', '', '1', '0', '0', '10'),
('6964', '210000', '210300', '210321', '1', '1', '西平林场', '0', '', '1', '0', '0', '10'),
('6965', '210000', '210300', '210323', '1', '1', '岫岩镇', '0', '', '1', '0', '0', '10'),
('6966', '210000', '210300', '210323', '1', '1', '三家子镇', '0', '', '1', '0', '0', '10'),
('6967', '210000', '210300', '210323', '1', '1', '石庙子镇', '0', '', '1', '0', '0', '10'),
('6968', '210000', '210300', '210323', '1', '1', '黄花甸镇', '0', '', '1', '0', '0', '10'),
('6969', '210000', '210300', '210323', '1', '1', '大营子镇', '0', '', '1', '0', '0', '10'),
('6970', '210000', '210300', '210323', '1', '1', '苏子沟镇', '0', '', '1', '0', '0', '10'),
('6971', '210000', '210300', '210323', '1', '1', '偏岭镇', '0', '', '1', '0', '0', '10'),
('6972', '210000', '210300', '210323', '1', '1', '哈达碑镇', '0', '', '1', '0', '0', '10'),
('6973', '210000', '210300', '210323', '1', '1', '新甸镇', '0', '', '1', '0', '0', '10'),
('6974', '210000', '210300', '210323', '1', '1', '洋河镇', '0', '', '1', '0', '0', '10'),
('6975', '210000', '210300', '210323', '1', '1', '杨家堡镇', '0', '', '1', '0', '0', '10'),
('6976', '210000', '210300', '210323', '1', '1', '汤沟镇', '0', '', '1', '0', '0', '10'),
('6977', '210000', '210300', '210323', '1', '1', '石灰窑镇', '0', '', '1', '0', '0', '10'),
('6978', '210000', '210300', '210323', '1', '1', '前营子镇', '0', '', '1', '0', '0', '10'),
('6979', '210000', '210300', '210323', '1', '1', '龙潭镇', '0', '', '1', '0', '0', '10'),
('6980', '210000', '210300', '210323', '1', '1', '牧牛乡', '0', '', '1', '0', '0', '10'),
('6981', '210000', '210300', '210323', '1', '1', '韭菜沟乡', '0', '', '1', '0', '0', '10'),
('6982', '210000', '210300', '210323', '1', '1', '大房身乡', '0', '', '1', '0', '0', '10'),
('6983', '210000', '210300', '210323', '1', '1', '朝阳乡', '0', '', '1', '0', '0', '10'),
('6984', '210000', '210300', '210323', '1', '1', '红旗营子乡', '0', '', '1', '0', '0', '10'),
('6985', '210000', '210300', '210323', '1', '1', '岭沟乡', '0', '', '1', '0', '0', '10'),
('6986', '210000', '210300', '210323', '1', '1', '哨子河乡', '0', '', '1', '0', '0', '10'),
('6987', '210000', '210300', '210381', '1', '1', '海州街道', '0', '', '1', '0', '0', '10'),
('6988', '210000', '210300', '210381', '1', '1', '兴海街道', '0', '', '1', '0', '0', '10'),
('6989', '210000', '210300', '210381', '1', '1', '响堂街道', '0', '', '1', '0', '0', '10'),
('6990', '210000', '210300', '210381', '1', '1', '东四街道', '0', '', '1', '0', '0', '10'),
('6991', '210000', '210300', '210381', '1', '1', '孤山镇', '0', '', '1', '0', '0', '10'),
('6992', '210000', '210300', '210381', '1', '1', '岔沟镇', '0', '', '1', '0', '0', '10'),
('6993', '210000', '210300', '210381', '1', '1', '接文镇', '0', '', '1', '0', '0', '10'),
('6994', '210000', '210300', '210381', '1', '1', '析木镇', '0', '', '1', '0', '0', '10'),
('6995', '210000', '210300', '210381', '1', '1', '马风镇', '0', '', '1', '0', '0', '10'),
('6996', '210000', '210300', '210381', '1', '1', '牌楼镇', '0', '', '1', '0', '0', '10'),
('6997', '210000', '210300', '210381', '1', '1', '八里镇', '0', '', '1', '0', '0', '10'),
('6998', '210000', '210300', '210381', '1', '1', '毛祁镇', '0', '', '1', '0', '0', '10'),
('6999', '210000', '210300', '210381', '1', '1', '英落镇', '0', '', '1', '0', '0', '10'),
('7000', '210000', '210300', '210381', '1', '1', '感王镇', '0', '', '1', '0', '0', '10'),
('7001', '210000', '210300', '210381', '1', '1', '西柳镇', '0', '', '1', '0', '0', '10'),
('7002', '210000', '210300', '210381', '1', '1', '中小镇', '0', '', '1', '0', '0', '10'),
('7003', '210000', '210300', '210381', '1', '1', '王石镇', '0', '', '1', '0', '0', '10'),
('7004', '210000', '210300', '210381', '1', '1', '南台镇', '0', '', '1', '0', '0', '10'),
('7005', '210000', '210300', '210381', '1', '1', '甘泉镇', '0', '', '1', '0', '0', '10'),
('7006', '210000', '210300', '210381', '1', '1', '大屯镇', '0', '', '1', '0', '0', '10'),
('7007', '210000', '210300', '210381', '1', '1', '腾鳌镇', '0', '', '1', '0', '0', '10'),
('7008', '210000', '210300', '210381', '1', '1', '东四方台温泉管理区', '0', '', '1', '0', '0', '10'),
('7009', '210000', '210300', '210381', '1', '1', '耿庄镇', '0', '', '1', '0', '0', '10'),
('7010', '210000', '210300', '210381', '1', '1', '牛庄镇', '0', '', '1', '0', '0', '10'),
('7011', '210000', '210300', '210381', '1', '1', '西四镇', '0', '', '1', '0', '0', '10'),
('7012', '210000', '210300', '210381', '1', '1', '望台镇', '0', '', '1', '0', '0', '10'),
('7013', '210000', '210300', '210381', '1', '1', '温香镇', '0', '', '1', '0', '0', '10'),
('7014', '210000', '210300', '210381', '1', '1', '高坨镇', '0', '', '1', '0', '0', '10'),
('7015', '210000', '210300', '210381', '1', '1', '海城经济开发区', '0', '', '1', '0', '0', '10'),
('7016', '210000', '210400', '210402', '1', '1', '站前街道', '0', '', '1', '0', '0', '10'),
('7017', '210000', '210400', '210402', '1', '1', '东公园街道', '0', '', '1', '0', '0', '10'),
('7018', '210000', '210400', '210402', '1', '1', '福民街道', '0', '', '1', '0', '0', '10'),
('7019', '210000', '210400', '210402', '1', '1', '新抚街道', '0', '', '1', '0', '0', '10'),
('7020', '210000', '210400', '210402', '1', '1', '榆林街道', '0', '', '1', '0', '0', '10'),
('7021', '210000', '210400', '210402', '1', '1', '永安台街道', '0', '', '1', '0', '0', '10'),
('7022', '210000', '210400', '210402', '1', '1', '千金街道', '0', '', '1', '0', '0', '10'),
('7023', '210000', '210400', '210402', '1', '1', '南阳街道', '0', '', '1', '0', '0', '10'),
('7024', '210000', '210400', '210403', '1', '1', '东洲街道', '0', '', '1', '0', '0', '10'),
('7025', '210000', '210400', '210403', '1', '1', '张甸街道', '0', '', '1', '0', '0', '10'),
('7026', '210000', '210400', '210403', '1', '1', '搭连街道', '0', '', '1', '0', '0', '10'),
('7027', '210000', '210400', '210403', '1', '1', '龙凤街道', '0', '', '1', '0', '0', '10'),
('7028', '210000', '210400', '210403', '1', '1', '新屯街道', '0', '', '1', '0', '0', '10'),
('7029', '210000', '210400', '210403', '1', '1', '万新街道', '0', '', '1', '0', '0', '10'),
('7030', '210000', '210400', '210403', '1', '1', '老虎台街道', '0', '', '1', '0', '0', '10'),
('7031', '210000', '210400', '210403', '1', '1', '平山街道', '0', '', '1', '0', '0', '10'),
('7032', '210000', '210400', '210403', '1', '1', '南花园街道', '0', '', '1', '0', '0', '10'),
('7033', '210000', '210400', '210403', '1', '1', '刘山街道', '0', '', '1', '0', '0', '10'),
('7034', '210000', '210400', '210403', '1', '1', '章党街道', '0', '', '1', '0', '0', '10'),
('7035', '210000', '210400', '210403', '1', '1', '千金乡', '0', '', '1', '0', '0', '10'),
('7036', '210000', '210400', '210403', '1', '1', '碾盘乡', '0', '', '1', '0', '0', '10'),
('7037', '210000', '210400', '210404', '1', '1', '田屯街道', '0', '', '1', '0', '0', '10'),
('7038', '210000', '210400', '210404', '1', '1', '工农街道', '0', '', '1', '0', '0', '10'),
('7039', '210000', '210400', '210404', '1', '1', '建设街道', '0', '', '1', '0', '0', '10'),
('7040', '210000', '210400', '210404', '1', '1', '和平街道', '0', '', '1', '0', '0', '10'),
('7041', '210000', '210400', '210404', '1', '1', '光明街道', '0', '', '1', '0', '0', '10'),
('7042', '210000', '210400', '210404', '1', '1', '朴屯街道', '0', '', '1', '0', '0', '10'),
('7043', '210000', '210400', '210404', '1', '1', '演武街道', '0', '', '1', '0', '0', '10'),
('7044', '210000', '210400', '210404', '1', '1', '五老屯街道', '0', '', '1', '0', '0', '10'),
('7045', '210000', '210400', '210404', '1', '1', '古城子街道', '0', '', '1', '0', '0', '10'),
('7046', '210000', '210400', '210404', '1', '1', '新民街道', '0', '', '1', '0', '0', '10'),
('7047', '210000', '210400', '210404', '1', '1', '李石街道', '0', '', '1', '0', '0', '10'),
('7048', '210000', '210400', '210404', '1', '1', '塔峪镇', '0', '', '1', '0', '0', '10'),
('7049', '210000', '210400', '210411', '1', '1', '河东街道', '0', '', '1', '0', '0', '10'),
('7050', '210000', '210400', '210411', '1', '1', '长春街道', '0', '', '1', '0', '0', '10'),
('7051', '210000', '210400', '210411', '1', '1', '葛布街道', '0', '', '1', '0', '0', '10'),
('7052', '210000', '210400', '210411', '1', '1', '将军堡街道', '0', '', '1', '0', '0', '10'),
('7053', '210000', '210400', '210411', '1', '1', '新华街道', '0', '', '1', '0', '0', '10'),
('7054', '210000', '210400', '210411', '1', '1', '抚顺城街道', '0', '', '1', '0', '0', '10'),
('7055', '210000', '210400', '210411', '1', '1', '前甸镇', '0', '', '1', '0', '0', '10'),
('7056', '210000', '210400', '210411', '1', '1', '河北乡', '0', '', '1', '0', '0', '10'),
('7057', '210000', '210400', '210411', '1', '1', '会元乡', '0', '', '1', '0', '0', '10'),
('7058', '210000', '210400', '210421', '1', '1', '石文镇', '0', '', '1', '0', '0', '10'),
('7059', '210000', '210400', '210421', '1', '1', '后安镇', '0', '', '1', '0', '0', '10'),
('7060', '210000', '210400', '210421', '1', '1', '章党镇', '0', '', '1', '0', '0', '10'),
('7061', '210000', '210400', '210421', '1', '1', '哈达镇', '0', '', '1', '0', '0', '10'),
('7062', '210000', '210400', '210421', '1', '1', '马圈子乡', '0', '', '1', '0', '0', '10'),
('7063', '210000', '210400', '210421', '1', '1', '上马乡', '0', '', '1', '0', '0', '10'),
('7064', '210000', '210400', '210421', '1', '1', '救兵乡', '0', '', '1', '0', '0', '10'),
('7065', '210000', '210400', '210421', '1', '1', '峡河乡', '0', '', '1', '0', '0', '10'),
('7066', '210000', '210400', '210421', '1', '1', '海浪乡', '0', '', '1', '0', '0', '10'),
('7067', '210000', '210400', '210421', '1', '1', '拉古满族乡', '0', '', '1', '0', '0', '10'),
('7068', '210000', '210400', '210421', '1', '1', '兰山乡', '0', '', '1', '0', '0', '10'),
('7069', '210000', '210400', '210421', '1', '1', '汤图满族乡', '0', '', '1', '0', '0', '10'),
('7070', '210000', '210400', '210422', '1', '1', '新宾镇', '0', '', '1', '0', '0', '10'),
('7071', '210000', '210400', '210422', '1', '1', '旺清门镇', '0', '', '1', '0', '0', '10'),
('7072', '210000', '210400', '210422', '1', '1', '永陵镇', '0', '', '1', '0', '0', '10'),
('7073', '210000', '210400', '210422', '1', '1', '平顶山镇', '0', '', '1', '0', '0', '10'),
('7074', '210000', '210400', '210422', '1', '1', '大四平镇', '0', '', '1', '0', '0', '10'),
('7075', '210000', '210400', '210422', '1', '1', '苇子峪镇', '0', '', '1', '0', '0', '10'),
('7076', '210000', '210400', '210422', '1', '1', '木奇镇', '0', '', '1', '0', '0', '10'),
('7077', '210000', '210400', '210422', '1', '1', '上夹河镇', '0', '', '1', '0', '0', '10'),
('7078', '210000', '210400', '210422', '1', '1', '南杂木镇', '0', '', '1', '0', '0', '10'),
('7079', '210000', '210400', '210422', '1', '1', '红升乡', '0', '', '1', '0', '0', '10'),
('7080', '210000', '210400', '210422', '1', '1', '响水河子乡', '0', '', '1', '0', '0', '10'),
('7081', '210000', '210400', '210422', '1', '1', '红庙子乡', '0', '', '1', '0', '0', '10'),
('7082', '210000', '210400', '210422', '1', '1', '北四平乡', '0', '', '1', '0', '0', '10'),
('7083', '210000', '210400', '210422', '1', '1', '榆树乡', '0', '', '1', '0', '0', '10'),
('7084', '210000', '210400', '210422', '1', '1', '下夹河乡', '0', '', '1', '0', '0', '10'),
('7085', '210000', '210400', '210423', '1', '1', '清原镇', '0', '', '1', '0', '0', '10'),
('7086', '210000', '210400', '210423', '1', '1', '红透山镇', '0', '', '1', '0', '0', '10'),
('7087', '210000', '210400', '210423', '1', '1', '草市镇', '0', '', '1', '0', '0', '10'),
('7088', '210000', '210400', '210423', '1', '1', '英额门镇', '0', '', '1', '0', '0', '10'),
('7089', '210000', '210400', '210423', '1', '1', '南口前镇', '0', '', '1', '0', '0', '10'),
('7090', '210000', '210400', '210423', '1', '1', '南山城镇', '0', '', '1', '0', '0', '10'),
('7091', '210000', '210400', '210423', '1', '1', '湾甸子镇', '0', '', '1', '0', '0', '10'),
('7092', '210000', '210400', '210423', '1', '1', '大孤家镇', '0', '', '1', '0', '0', '10'),
('7093', '210000', '210400', '210423', '1', '1', '夏家堡镇', '0', '', '1', '0', '0', '10'),
('7094', '210000', '210400', '210423', '1', '1', '土口子乡', '0', '', '1', '0', '0', '10'),
('7095', '210000', '210400', '210423', '1', '1', '北三家乡', '0', '', '1', '0', '0', '10'),
('7096', '210000', '210400', '210423', '1', '1', '敖家堡乡', '0', '', '1', '0', '0', '10'),
('7097', '210000', '210400', '210423', '1', '1', '大苏河乡', '0', '', '1', '0', '0', '10'),
('7098', '210000', '210400', '210423', '1', '1', '枸乃甸乡', '0', '', '1', '0', '0', '10'),
('7099', '210000', '210500', '210502', '1', '1', '南地街道', '0', '', '1', '0', '0', '10'),
('7100', '210000', '210500', '210502', '1', '1', '工人街道', '0', '', '1', '0', '0', '10'),
('7101', '210000', '210500', '210502', '1', '1', '平山街道', '0', '', '1', '0', '0', '10'),
('7102', '210000', '210500', '210502', '1', '1', '东明街道', '0', '', '1', '0', '0', '10'),
('7103', '210000', '210500', '210502', '1', '1', '崔东街道', '0', '', '1', '0', '0', '10'),
('7104', '210000', '210500', '210502', '1', '1', '站前街道', '0', '', '1', '0', '0', '10'),
('7105', '210000', '210500', '210502', '1', '1', '千金街道', '0', '', '1', '0', '0', '10'),
('7106', '210000', '210500', '210502', '1', '1', '北台街道', '0', '', '1', '0', '0', '10'),
('7107', '210000', '210500', '210502', '1', '1', '桥头镇', '0', '', '1', '0', '0', '10'),
('7108', '210000', '210500', '210503', '1', '1', '河东街道', '0', '', '1', '0', '0', '10'),
('7109', '210000', '210500', '210503', '1', '1', '河西街道', '0', '', '1', '0', '0', '10'),
('7110', '210000', '210500', '210503', '1', '1', '彩屯街道', '0', '', '1', '0', '0', '10'),
('7111', '210000', '210500', '210503', '1', '1', '竖井街道', '0', '', '1', '0', '0', '10'),
('7112', '210000', '210500', '210503', '1', '1', '彩北街道', '0', '', '1', '0', '0', '10'),
('7113', '210000', '210500', '210503', '1', '1', '东风街道', '0', '', '1', '0', '0', '10'),
('7114', '210000', '210500', '210503', '1', '1', '火连寨镇', '0', '', '1', '0', '0', '10'),
('7115', '210000', '210500', '210503', '1', '1', '歪头山镇', '0', '', '1', '0', '0', '10'),
('7116', '210000', '210500', '210503', '1', '1', '石桥子镇', '0', '', '1', '0', '0', '10'),
('7117', '210000', '210500', '210503', '1', '1', '张其寨乡', '0', '', '1', '0', '0', '10'),
('7118', '210000', '210500', '210504', '1', '1', '金山街道', '0', '', '1', '0', '0', '10'),
('7119', '210000', '210500', '210504', '1', '1', '北地街道', '0', '', '1', '0', '0', '10'),
('7120', '210000', '210500', '210504', '1', '1', '高峪街道', '0', '', '1', '0', '0', '10'),
('7121', '210000', '210500', '210504', '1', '1', '明山街道', '0', '', '1', '0', '0', '10'),
('7122', '210000', '210500', '210504', '1', '1', '东兴街道', '0', '', '1', '0', '0', '10'),
('7123', '210000', '210500', '210504', '1', '1', '新明街道', '0', '', '1', '0', '0', '10'),
('7124', '210000', '210500', '210504', '1', '1', '牛心台街道', '0', '', '1', '0', '0', '10'),
('7125', '210000', '210500', '210504', '1', '1', '卧龙街道', '0', '', '1', '0', '0', '10'),
('7126', '210000', '210500', '210504', '1', '1', '高台子镇', '0', '', '1', '0', '0', '10'),
('7127', '210000', '210500', '210505', '1', '1', '南芬街道', '0', '', '1', '0', '0', '10'),
('7128', '210000', '210500', '210505', '1', '1', '铁山街道', '0', '', '1', '0', '0', '10'),
('7129', '210000', '210500', '210505', '1', '1', '郭家街道', '0', '', '1', '0', '0', '10'),
('7130', '210000', '210500', '210505', '1', '1', '下马塘镇', '0', '', '1', '0', '0', '10'),
('7131', '210000', '210500', '210505', '1', '1', '思山岭满族乡', '0', '', '1', '0', '0', '10'),
('7132', '210000', '210500', '210521', '1', '1', '观音阁街道', '0', '', '1', '0', '0', '10'),
('7133', '210000', '210500', '210521', '1', '1', '小市镇', '0', '', '1', '0', '0', '10'),
('7134', '210000', '210500', '210521', '1', '1', '草河掌镇', '0', '', '1', '0', '0', '10'),
('7135', '210000', '210500', '210521', '1', '1', '草河城镇', '0', '', '1', '0', '0', '10'),
('7136', '210000', '210500', '210521', '1', '1', '草河口镇', '0', '', '1', '0', '0', '10'),
('7137', '210000', '210500', '210521', '1', '1', '连山关镇', '0', '', '1', '0', '0', '10');
INSERT INTO `wst_communitys` VALUES ('7138', '210000', '210500', '210521', '1', '1', '清河城镇', '0', '', '1', '0', '0', '10'),
('7139', '210000', '210500', '210521', '1', '1', '田师傅镇', '0', '', '1', '0', '0', '10'),
('7140', '210000', '210500', '210521', '1', '1', '南甸镇', '0', '', '1', '0', '0', '10'),
('7141', '210000', '210500', '210521', '1', '1', '碱厂镇', '0', '', '1', '0', '0', '10'),
('7142', '210000', '210500', '210521', '1', '1', '高官镇', '0', '', '1', '0', '0', '10'),
('7143', '210000', '210500', '210521', '1', '1', '东营房乡', '0', '', '1', '0', '0', '10'),
('7144', '210000', '210500', '210522', '1', '1', '江城街道', '0', '', '1', '0', '0', '10'),
('7145', '210000', '210500', '210522', '1', '1', '桓仁镇', '0', '', '1', '0', '0', '10'),
('7146', '210000', '210500', '210522', '1', '1', '普乐堡镇', '0', '', '1', '0', '0', '10'),
('7147', '210000', '210500', '210522', '1', '1', '二棚甸子镇', '0', '', '1', '0', '0', '10'),
('7148', '210000', '210500', '210522', '1', '1', '沙尖子镇', '0', '', '1', '0', '0', '10'),
('7149', '210000', '210500', '210522', '1', '1', '五里甸子镇', '0', '', '1', '0', '0', '10'),
('7150', '210000', '210500', '210522', '1', '1', '八里甸子镇', '0', '', '1', '0', '0', '10'),
('7151', '210000', '210500', '210522', '1', '1', '华来镇', '0', '', '1', '0', '0', '10'),
('7152', '210000', '210500', '210522', '1', '1', '古城镇', '0', '', '1', '0', '0', '10'),
('7153', '210000', '210500', '210522', '1', '1', '雅河朝鲜族乡', '0', '', '1', '0', '0', '10'),
('7154', '210000', '210500', '210522', '1', '1', '向阳乡', '0', '', '1', '0', '0', '10'),
('7155', '210000', '210500', '210522', '1', '1', '黑沟乡', '0', '', '1', '0', '0', '10'),
('7156', '210000', '210500', '210522', '1', '1', '北甸子乡', '0', '', '1', '0', '0', '10'),
('7157', '210000', '210600', '210602', '1', '1', '六道口街道', '0', '', '1', '0', '0', '10'),
('7158', '210000', '210600', '210602', '1', '1', '七道街道', '0', '', '1', '0', '0', '10'),
('7159', '210000', '210600', '210602', '1', '1', '八道街道', '0', '', '1', '0', '0', '10'),
('7160', '210000', '210600', '210602', '1', '1', '九道街道', '0', '', '1', '0', '0', '10'),
('7161', '210000', '210600', '210602', '1', '1', '广济街道', '0', '', '1', '0', '0', '10'),
('7162', '210000', '210600', '210602', '1', '1', '兴东街道', '0', '', '1', '0', '0', '10'),
('7163', '210000', '210600', '210602', '1', '1', '金山镇', '0', '', '1', '0', '0', '10'),
('7164', '210000', '210600', '210603', '1', '1', '头道桥街道', '0', '', '1', '0', '0', '10'),
('7165', '210000', '210600', '210603', '1', '1', '站前街道', '0', '', '1', '0', '0', '10'),
('7166', '210000', '210600', '210603', '1', '1', '临江街道', '0', '', '1', '0', '0', '10'),
('7167', '210000', '210600', '210603', '1', '1', '六道街道', '0', '', '1', '0', '0', '10'),
('7168', '210000', '210600', '210603', '1', '1', '帽盔山街道', '0', '', '1', '0', '0', '10'),
('7169', '210000', '210600', '210603', '1', '1', '纤维街道', '0', '', '1', '0', '0', '10'),
('7170', '210000', '210600', '210603', '1', '1', '永昌街道', '0', '', '1', '0', '0', '10'),
('7171', '210000', '210600', '210603', '1', '1', '花园街道', '0', '', '1', '0', '0', '10'),
('7172', '210000', '210600', '210603', '1', '1', '浪头镇', '0', '', '1', '0', '0', '10'),
('7173', '210000', '210600', '210603', '1', '1', '安民镇', '0', '', '1', '0', '0', '10'),
('7174', '210000', '210600', '210604', '1', '1', '鸭绿江街道', '0', '', '1', '0', '0', '10'),
('7175', '210000', '210600', '210604', '1', '1', '金矿街道', '0', '', '1', '0', '0', '10'),
('7176', '210000', '210600', '210604', '1', '1', '珍珠街道', '0', '', '1', '0', '0', '10'),
('7177', '210000', '210600', '210604', '1', '1', '太平湾街道', '0', '', '1', '0', '0', '10'),
('7178', '210000', '210600', '210604', '1', '1', '同兴镇', '0', '', '1', '0', '0', '10'),
('7179', '210000', '210600', '210604', '1', '1', '五龙背镇', '0', '', '1', '0', '0', '10'),
('7180', '210000', '210600', '210604', '1', '1', '楼房镇', '0', '', '1', '0', '0', '10'),
('7181', '210000', '210600', '210604', '1', '1', '九连城镇', '0', '', '1', '0', '0', '10'),
('7182', '210000', '210600', '210604', '1', '1', '汤山城镇', '0', '', '1', '0', '0', '10'),
('7183', '210000', '210600', '210624', '1', '1', '宽甸镇', '0', '', '1', '0', '0', '10'),
('7184', '210000', '210600', '210624', '1', '1', '灌水镇', '0', '', '1', '0', '0', '10'),
('7185', '210000', '210600', '210624', '1', '1', '硼海镇', '0', '', '1', '0', '0', '10'),
('7186', '210000', '210600', '210624', '1', '1', '红石镇', '0', '', '1', '0', '0', '10'),
('7187', '210000', '210600', '210624', '1', '1', '毛甸子镇', '0', '', '1', '0', '0', '10'),
('7188', '210000', '210600', '210624', '1', '1', '长甸镇', '0', '', '1', '0', '0', '10'),
('7189', '210000', '210600', '210624', '1', '1', '永甸镇', '0', '', '1', '0', '0', '10'),
('7190', '210000', '210600', '210624', '1', '1', '太平哨镇', '0', '', '1', '0', '0', '10'),
('7191', '210000', '210600', '210624', '1', '1', '青山沟镇', '0', '', '1', '0', '0', '10'),
('7192', '210000', '210600', '210624', '1', '1', '牛毛坞镇', '0', '', '1', '0', '0', '10'),
('7193', '210000', '210600', '210624', '1', '1', '大川头镇', '0', '', '1', '0', '0', '10'),
('7194', '210000', '210600', '210624', '1', '1', '青椅山镇', '0', '', '1', '0', '0', '10'),
('7195', '210000', '210600', '210624', '1', '1', '杨木川镇', '0', '', '1', '0', '0', '10'),
('7196', '210000', '210600', '210624', '1', '1', '虎山镇', '0', '', '1', '0', '0', '10'),
('7197', '210000', '210600', '210624', '1', '1', '振江镇', '0', '', '1', '0', '0', '10'),
('7198', '210000', '210600', '210624', '1', '1', '步达远镇', '0', '', '1', '0', '0', '10'),
('7199', '210000', '210600', '210624', '1', '1', '大西岔镇', '0', '', '1', '0', '0', '10'),
('7200', '210000', '210600', '210624', '1', '1', '八河川镇', '0', '', '1', '0', '0', '10'),
('7201', '210000', '210600', '210624', '1', '1', '双山子镇', '0', '', '1', '0', '0', '10'),
('7202', '210000', '210600', '210624', '1', '1', '石湖沟乡', '0', '', '1', '0', '0', '10'),
('7203', '210000', '210600', '210624', '1', '1', '古楼子乡', '0', '', '1', '0', '0', '10'),
('7204', '210000', '210600', '210624', '1', '1', '下露河朝鲜族乡', '0', '', '1', '0', '0', '10'),
('7205', '210000', '210600', '210681', '1', '1', '大东街道', '0', '', '1', '0', '0', '10'),
('7206', '210000', '210600', '210681', '1', '1', '新兴街道', '0', '', '1', '0', '0', '10'),
('7207', '210000', '210600', '210681', '1', '1', '新城街道', '0', '', '1', '0', '0', '10'),
('7208', '210000', '210600', '210681', '1', '1', '孤山镇', '0', '', '1', '0', '0', '10'),
('7209', '210000', '210600', '210681', '1', '1', '汤池镇', '0', '', '1', '0', '0', '10'),
('7210', '210000', '210600', '210681', '1', '1', '前阳镇', '0', '', '1', '0', '0', '10'),
('7211', '210000', '210600', '210681', '1', '1', '长安镇', '0', '', '1', '0', '0', '10'),
('7212', '210000', '210600', '210681', '1', '1', '十字街镇', '0', '', '1', '0', '0', '10'),
('7213', '210000', '210600', '210681', '1', '1', '长山镇', '0', '', '1', '0', '0', '10'),
('7214', '210000', '210600', '210681', '1', '1', '北井子镇', '0', '', '1', '0', '0', '10'),
('7215', '210000', '210600', '210681', '1', '1', '椅圈镇', '0', '', '1', '0', '0', '10'),
('7216', '210000', '210600', '210681', '1', '1', '黄土坎镇', '0', '', '1', '0', '0', '10'),
('7217', '210000', '210600', '210681', '1', '1', '马家店镇', '0', '', '1', '0', '0', '10'),
('7218', '210000', '210600', '210681', '1', '1', '龙王庙满族锡伯族镇', '0', '', '1', '0', '0', '10'),
('7219', '210000', '210600', '210681', '1', '1', '小甸子镇', '0', '', '1', '0', '0', '10'),
('7220', '210000', '210600', '210681', '1', '1', '菩萨庙镇', '0', '', '1', '0', '0', '10'),
('7221', '210000', '210600', '210681', '1', '1', '黑沟镇', '0', '', '1', '0', '0', '10'),
('7222', '210000', '210600', '210681', '1', '1', '新农镇', '0', '', '1', '0', '0', '10'),
('7223', '210000', '210600', '210681', '1', '1', '合隆乡', '0', '', '1', '0', '0', '10'),
('7224', '210000', '210600', '210681', '1', '1', '示范农场', '0', '', '1', '0', '0', '10'),
('7225', '210000', '210600', '210681', '1', '1', '黄土坎农场', '0', '', '1', '0', '0', '10'),
('7226', '210000', '210600', '210681', '1', '1', '海洋红农场', '0', '', '1', '0', '0', '10'),
('7227', '210000', '210600', '210681', '1', '1', '兴隆农场', '0', '', '1', '0', '0', '10'),
('7228', '210000', '210600', '210681', '1', '1', '五四农场', '0', '', '1', '0', '0', '10'),
('7229', '210000', '210600', '210682', '1', '1', '凤凰城街道', '0', '', '1', '0', '0', '10'),
('7230', '210000', '210600', '210682', '1', '1', '凤山街道', '0', '', '1', '0', '0', '10'),
('7231', '210000', '210600', '210682', '1', '1', '草河街道', '0', '', '1', '0', '0', '10'),
('7232', '210000', '210600', '210682', '1', '1', '宝山镇', '0', '', '1', '0', '0', '10'),
('7233', '210000', '210600', '210682', '1', '1', '白旗镇', '0', '', '1', '0', '0', '10'),
('7234', '210000', '210600', '210682', '1', '1', '沙里寨镇', '0', '', '1', '0', '0', '10'),
('7235', '210000', '210600', '210682', '1', '1', '红旗镇', '0', '', '1', '0', '0', '10'),
('7236', '210000', '210600', '210682', '1', '1', '蓝旗镇', '0', '', '1', '0', '0', '10'),
('7237', '210000', '210600', '210682', '1', '1', '边门镇', '0', '', '1', '0', '0', '10'),
('7238', '210000', '210600', '210682', '1', '1', '大堡蒙古族镇', '0', '', '1', '0', '0', '10'),
('7239', '210000', '210600', '210682', '1', '1', '东汤镇', '0', '', '1', '0', '0', '10'),
('7240', '210000', '210600', '210682', '1', '1', '石城镇', '0', '', '1', '0', '0', '10'),
('7241', '210000', '210600', '210682', '1', '1', '大兴镇', '0', '', '1', '0', '0', '10'),
('7242', '210000', '210600', '210682', '1', '1', '爱阳镇', '0', '', '1', '0', '0', '10'),
('7243', '210000', '210600', '210682', '1', '1', '赛马镇', '0', '', '1', '0', '0', '10'),
('7244', '210000', '210600', '210682', '1', '1', '弟兄山镇', '0', '', '1', '0', '0', '10'),
('7245', '210000', '210600', '210682', '1', '1', '鸡冠山镇', '0', '', '1', '0', '0', '10'),
('7246', '210000', '210600', '210682', '1', '1', '刘家河镇', '0', '', '1', '0', '0', '10'),
('7247', '210000', '210600', '210682', '1', '1', '通远堡镇', '0', '', '1', '0', '0', '10'),
('7248', '210000', '210600', '210682', '1', '1', '四门子镇', '0', '', '1', '0', '0', '10'),
('7249', '210000', '210600', '210682', '1', '1', '青城子镇', '0', '', '1', '0', '0', '10'),
('7250', '210000', '210700', '210702', '1', '1', '天安街道', '0', '', '1', '0', '0', '10'),
('7251', '210000', '210700', '210702', '1', '1', '石油街道', '0', '', '1', '0', '0', '10'),
('7252', '210000', '210700', '210702', '1', '1', '北街街道', '0', '', '1', '0', '0', '10'),
('7253', '210000', '210700', '210702', '1', '1', '敬业街道', '0', '', '1', '0', '0', '10'),
('7254', '210000', '210700', '210702', '1', '1', '保安街道', '0', '', '1', '0', '0', '10'),
('7255', '210000', '210700', '210702', '1', '1', '南街街道', '0', '', '1', '0', '0', '10'),
('7256', '210000', '210700', '210702', '1', '1', '饶阳街道', '0', '', '1', '0', '0', '10'),
('7257', '210000', '210700', '210702', '1', '1', '站前街道', '0', '', '1', '0', '0', '10'),
('7258', '210000', '210700', '210702', '1', '1', '士英街道', '0', '', '1', '0', '0', '10'),
('7259', '210000', '210700', '210703', '1', '1', '正大街道', '0', '', '1', '0', '0', '10'),
('7260', '210000', '210700', '210703', '1', '1', '石桥子街道', '0', '', '1', '0', '0', '10'),
('7261', '210000', '210700', '210703', '1', '1', '龙江街道', '0', '', '1', '0', '0', '10'),
('7262', '210000', '210700', '210703', '1', '1', '榴花街道', '0', '', '1', '0', '0', '10'),
('7263', '210000', '210700', '210703', '1', '1', '铁新街道', '0', '', '1', '0', '0', '10'),
('7264', '210000', '210700', '210703', '1', '1', '凌安街道', '0', '', '1', '0', '0', '10'),
('7265', '210000', '210700', '210703', '1', '1', '菊园街道', '0', '', '1', '0', '0', '10'),
('7266', '210000', '210700', '210703', '1', '1', '康宁街道', '0', '', '1', '0', '0', '10'),
('7267', '210000', '210700', '210703', '1', '1', '锦铁街道', '0', '', '1', '0', '0', '10'),
('7268', '210000', '210700', '210703', '1', '1', '马家街道', '0', '', '1', '0', '0', '10'),
('7269', '210000', '210700', '210703', '1', '1', '百股街道', '0', '', '1', '0', '0', '10'),
('7270', '210000', '210700', '210703', '1', '1', '锦州北山农工商总公司', '0', '', '1', '0', '0', '10'),
('7271', '210000', '210700', '210711', '1', '1', '太和街道', '0', '', '1', '0', '0', '10'),
('7272', '210000', '210700', '210711', '1', '1', '兴隆街道', '0', '', '1', '0', '0', '10'),
('7273', '210000', '210700', '210711', '1', '1', '汤河子街道', '0', '', '1', '0', '0', '10'),
('7274', '210000', '210700', '210711', '1', '1', '凌西街道', '0', '', '1', '0', '0', '10'),
('7275', '210000', '210700', '210711', '1', '1', '凌南街道', '0', '', '1', '0', '0', '10'),
('7276', '210000', '210700', '210711', '1', '1', '大薛街道', '0', '', '1', '0', '0', '10'),
('7277', '210000', '210700', '210711', '1', '1', '王家街道', '0', '', '1', '0', '0', '10'),
('7278', '210000', '210700', '210711', '1', '1', '天桥街道', '0', '', '1', '0', '0', '10'),
('7279', '210000', '210700', '210711', '1', '1', '杏山街道', '0', '', '1', '0', '0', '10'),
('7280', '210000', '210700', '210711', '1', '1', '女儿河乡', '0', '', '1', '0', '0', '10'),
('7281', '210000', '210700', '210711', '1', '1', '钟屯乡', '0', '', '1', '0', '0', '10'),
('7282', '210000', '210700', '210711', '1', '1', '营盘乡', '0', '', '1', '0', '0', '10'),
('7283', '210000', '210700', '210711', '1', '1', '新民乡', '0', '', '1', '0', '0', '10'),
('7284', '210000', '210700', '210711', '1', '1', '锦州市果树农场', '0', '', '1', '0', '0', '10'),
('7285', '210000', '210700', '210726', '1', '1', '黑山镇', '0', '', '1', '0', '0', '10'),
('7286', '210000', '210700', '210726', '1', '1', '芳山镇', '0', '', '1', '0', '0', '10'),
('7287', '210000', '210700', '210726', '1', '1', '白厂门镇', '0', '', '1', '0', '0', '10'),
('7288', '210000', '210700', '210726', '1', '1', '常兴镇', '0', '', '1', '0', '0', '10'),
('7289', '210000', '210700', '210726', '1', '1', '姜屯镇', '0', '', '1', '0', '0', '10'),
('7290', '210000', '210700', '210726', '1', '1', '励家镇', '0', '', '1', '0', '0', '10'),
('7291', '210000', '210700', '210726', '1', '1', '绕阳河镇', '0', '', '1', '0', '0', '10'),
('7292', '210000', '210700', '210726', '1', '1', '半拉门镇', '0', '', '1', '0', '0', '10'),
('7293', '210000', '210700', '210726', '1', '1', '无梁殿镇', '0', '', '1', '0', '0', '10'),
('7294', '210000', '210700', '210726', '1', '1', '胡家镇', '0', '', '1', '0', '0', '10'),
('7295', '210000', '210700', '210726', '1', '1', '新立屯镇', '0', '', '1', '0', '0', '10'),
('7296', '210000', '210700', '210726', '1', '1', '八道壕镇', '0', '', '1', '0', '0', '10'),
('7297', '210000', '210700', '210726', '1', '1', '大虎山镇', '0', '', '1', '0', '0', '10'),
('7298', '210000', '210700', '210726', '1', '1', '四家子镇', '0', '', '1', '0', '0', '10'),
('7299', '210000', '210700', '210726', '1', '1', '新兴镇', '0', '', '1', '0', '0', '10'),
('7300', '210000', '210700', '210726', '1', '1', '太和镇', '0', '', '1', '0', '0', '10'),
('7301', '210000', '210700', '210726', '1', '1', '英城子乡', '0', '', '1', '0', '0', '10'),
('7302', '210000', '210700', '210726', '1', '1', '镇安乡', '0', '', '1', '0', '0', '10'),
('7303', '210000', '210700', '210726', '1', '1', '段家乡', '0', '', '1', '0', '0', '10'),
('7304', '210000', '210700', '210726', '1', '1', '大兴乡', '0', '', '1', '0', '0', '10'),
('7305', '210000', '210700', '210726', '1', '1', '薛屯乡', '0', '', '1', '0', '0', '10'),
('7306', '210000', '210700', '210726', '1', '1', '辽宁省锦州市小东种畜场', '0', '', '1', '0', '0', '10'),
('7307', '210000', '210700', '210727', '1', '1', '义州镇', '0', '', '1', '0', '0', '10'),
('7308', '210000', '210700', '210727', '1', '1', '刘龙台镇', '0', '', '1', '0', '0', '10'),
('7309', '210000', '210700', '210727', '1', '1', '七里河镇', '0', '', '1', '0', '0', '10'),
('7310', '210000', '210700', '210727', '1', '1', '大榆树堡镇', '0', '', '1', '0', '0', '10'),
('7311', '210000', '210700', '210727', '1', '1', '稍户营子镇', '0', '', '1', '0', '0', '10'),
('7312', '210000', '210700', '210727', '1', '1', '九道岭镇', '0', '', '1', '0', '0', '10'),
('7313', '210000', '210700', '210727', '1', '1', '高台子镇', '0', '', '1', '0', '0', '10'),
('7314', '210000', '210700', '210727', '1', '1', '瓦子峪镇', '0', '', '1', '0', '0', '10'),
('7315', '210000', '210700', '210727', '1', '1', '城关满族乡', '0', '', '1', '0', '0', '10'),
('7316', '210000', '210700', '210727', '1', '1', '头道河满族乡', '0', '', '1', '0', '0', '10'),
('7317', '210000', '210700', '210727', '1', '1', '地藏寺满族乡', '0', '', '1', '0', '0', '10'),
('7318', '210000', '210700', '210727', '1', '1', '留龙沟满族乡', '0', '', '1', '0', '0', '10'),
('7319', '210000', '210700', '210727', '1', '1', '大定堡满族乡', '0', '', '1', '0', '0', '10'),
('7320', '210000', '210700', '210727', '1', '1', '前杨乡', '0', '', '1', '0', '0', '10'),
('7321', '210000', '210700', '210727', '1', '1', '白庙子乡', '0', '', '1', '0', '0', '10'),
('7322', '210000', '210700', '210727', '1', '1', '聚粮屯乡', '0', '', '1', '0', '0', '10'),
('7323', '210000', '210700', '210727', '1', '1', '张家堡乡', '0', '', '1', '0', '0', '10'),
('7324', '210000', '210700', '210727', '1', '1', '头台满族乡', '0', '', '1', '0', '0', '10'),
('7325', '210000', '210700', '210781', '1', '1', '大凌河街道', '0', '', '1', '0', '0', '10'),
('7326', '210000', '210700', '210781', '1', '1', '金城街道', '0', '', '1', '0', '0', '10'),
('7327', '210000', '210700', '210781', '1', '1', '石山镇', '0', '', '1', '0', '0', '10'),
('7328', '210000', '210700', '210781', '1', '1', '余积镇', '0', '', '1', '0', '0', '10'),
('7329', '210000', '210700', '210781', '1', '1', '双羊镇', '0', '', '1', '0', '0', '10'),
('7330', '210000', '210700', '210781', '1', '1', '班吉塔镇', '0', '', '1', '0', '0', '10'),
('7331', '210000', '210700', '210781', '1', '1', '沈家台镇', '0', '', '1', '0', '0', '10'),
('7332', '210000', '210700', '210781', '1', '1', '三台子镇', '0', '', '1', '0', '0', '10'),
('7333', '210000', '210700', '210781', '1', '1', '右卫满族镇', '0', '', '1', '0', '0', '10'),
('7334', '210000', '210700', '210781', '1', '1', '阎家镇', '0', '', '1', '0', '0', '10'),
('7335', '210000', '210700', '210781', '1', '1', '新庄子镇', '0', '', '1', '0', '0', '10'),
('7336', '210000', '210700', '210781', '1', '1', '娘娘宫镇', '0', '', '1', '0', '0', '10'),
('7337', '210000', '210700', '210781', '1', '1', '翠岩镇', '0', '', '1', '0', '0', '10'),
('7338', '210000', '210700', '210781', '1', '1', '松山镇', '0', '', '1', '0', '0', '10'),
('7339', '210000', '210700', '210781', '1', '1', '大业乡', '0', '', '1', '0', '0', '10'),
('7340', '210000', '210700', '210781', '1', '1', '西八千乡', '0', '', '1', '0', '0', '10'),
('7341', '210000', '210700', '210781', '1', '1', '建业乡', '0', '', '1', '0', '0', '10'),
('7342', '210000', '210700', '210781', '1', '1', '温滴楼满族乡', '0', '', '1', '0', '0', '10'),
('7343', '210000', '210700', '210781', '1', '1', '板石沟乡', '0', '', '1', '0', '0', '10'),
('7344', '210000', '210700', '210781', '1', '1', '白台子乡', '0', '', '1', '0', '0', '10'),
('7345', '210000', '210700', '210781', '1', '1', '谢屯乡', '0', '', '1', '0', '0', '10'),
('7346', '210000', '210700', '210781', '1', '1', '安屯乡', '0', '', '1', '0', '0', '10'),
('7347', '210000', '210700', '210781', '1', '1', '辽宁省金城原种场', '0', '', '1', '0', '0', '10'),
('7348', '210000', '210700', '210781', '1', '1', '大有农场', '0', '', '1', '0', '0', '10'),
('7349', '210000', '210700', '210782', '1', '1', '北镇街道', '0', '', '1', '0', '0', '10'),
('7350', '210000', '210700', '210782', '1', '1', '观音阁街道', '0', '', '1', '0', '0', '10'),
('7351', '210000', '210700', '210782', '1', '1', '大市镇', '0', '', '1', '0', '0', '10'),
('7352', '210000', '210700', '210782', '1', '1', '罗罗堡镇', '0', '', '1', '0', '0', '10'),
('7353', '210000', '210700', '210782', '1', '1', '常兴店镇', '0', '', '1', '0', '0', '10'),
('7354', '210000', '210700', '210782', '1', '1', '正安镇', '0', '', '1', '0', '0', '10'),
('7355', '210000', '210700', '210782', '1', '1', '闾阳镇', '0', '', '1', '0', '0', '10'),
('7356', '210000', '210700', '210782', '1', '1', '中安镇', '0', '', '1', '0', '0', '10'),
('7357', '210000', '210700', '210782', '1', '1', '廖屯镇', '0', '', '1', '0', '0', '10'),
('7358', '210000', '210700', '210782', '1', '1', '赵屯镇', '0', '', '1', '0', '0', '10'),
('7359', '210000', '210700', '210782', '1', '1', '青堆子镇', '0', '', '1', '0', '0', '10'),
('7360', '210000', '210700', '210782', '1', '1', '高山子镇', '0', '', '1', '0', '0', '10'),
('7361', '210000', '210700', '210782', '1', '1', '沟帮子镇', '0', '', '1', '0', '0', '10'),
('7362', '210000', '210700', '210782', '1', '1', '富屯乡', '0', '', '1', '0', '0', '10'),
('7363', '210000', '210700', '210782', '1', '1', '鲍家乡', '0', '', '1', '0', '0', '10'),
('7364', '210000', '210700', '210782', '1', '1', '大屯乡', '0', '', '1', '0', '0', '10'),
('7365', '210000', '210700', '210782', '1', '1', '吴家乡', '0', '', '1', '0', '0', '10'),
('7366', '210000', '210700', '210782', '1', '1', '柳家乡', '0', '', '1', '0', '0', '10'),
('7367', '210000', '210700', '210782', '1', '1', '广宁乡', '0', '', '1', '0', '0', '10'),
('7368', '210000', '210700', '210782', '1', '1', '新立农场', '0', '', '1', '0', '0', '10'),
('7369', '210000', '210800', '210802', '1', '1', '八田地街道', '0', '', '1', '0', '0', '10'),
('7370', '210000', '210800', '210802', '1', '1', '建丰街道', '0', '', '1', '0', '0', '10'),
('7371', '210000', '210800', '210802', '1', '1', '建设街道', '0', '', '1', '0', '0', '10'),
('7372', '210000', '210800', '210802', '1', '1', '跃进街道', '0', '', '1', '0', '0', '10'),
('7373', '210000', '210800', '210802', '1', '1', '东风街道', '0', '', '1', '0', '0', '10'),
('7374', '210000', '210800', '210802', '1', '1', '新兴街道', '0', '', '1', '0', '0', '10'),
('7375', '210000', '210800', '210802', '1', '1', '新建街道', '0', '', '1', '0', '0', '10'),
('7376', '210000', '210800', '210803', '1', '1', '胜利街道', '0', '', '1', '0', '0', '10'),
('7377', '210000', '210800', '210803', '1', '1', '清华街道', '0', '', '1', '0', '0', '10'),
('7378', '210000', '210800', '210803', '1', '1', '滨海街道', '0', '', '1', '0', '0', '10'),
('7379', '210000', '210800', '210803', '1', '1', '得胜街道', '0', '', '1', '0', '0', '10'),
('7380', '210000', '210800', '210803', '1', '1', '五台子街道', '0', '', '1', '0', '0', '10'),
('7381', '210000', '210800', '210803', '1', '1', '渔市街道', '0', '', '1', '0', '0', '10'),
('7382', '210000', '210800', '210803', '1', '1', '河北街道', '0', '', '1', '0', '0', '10'),
('7383', '210000', '210800', '210804', '1', '1', '红海街道', '0', '', '1', '0', '0', '10'),
('7384', '210000', '210800', '210804', '1', '1', '海星街道', '0', '', '1', '0', '0', '10'),
('7385', '210000', '210800', '210804', '1', '1', '望海街道', '0', '', '1', '0', '0', '10'),
('7386', '210000', '210800', '210804', '1', '1', '海东街道', '0', '', '1', '0', '0', '10'),
('7387', '210000', '210800', '210804', '1', '1', '熊岳镇', '0', '', '1', '0', '0', '10'),
('7388', '210000', '210800', '210804', '1', '1', '芦屯镇', '0', '', '1', '0', '0', '10'),
('7389', '210000', '210800', '210804', '1', '1', '红旗满族镇', '0', '', '1', '0', '0', '10'),
('7390', '210000', '210800', '210811', '1', '1', '老边街道', '0', '', '1', '0', '0', '10'),
('7391', '210000', '210800', '210811', '1', '1', '城东街道', '0', '', '1', '0', '0', '10'),
('7392', '210000', '210800', '210811', '1', '1', '路南镇', '0', '', '1', '0', '0', '10'),
('7393', '210000', '210800', '210811', '1', '1', '柳树镇', '0', '', '1', '0', '0', '10'),
('7394', '210000', '210800', '210811', '1', '1', '边城镇', '0', '', '1', '0', '0', '10'),
('7395', '210000', '210800', '210811', '1', '1', '二道镇', '0', '', '1', '0', '0', '10'),
('7396', '210000', '210800', '210881', '1', '1', '鼓楼街道', '0', '', '1', '0', '0', '10'),
('7397', '210000', '210800', '210881', '1', '1', '西城街道', '0', '', '1', '0', '0', '10'),
('7398', '210000', '210800', '210881', '1', '1', '东城街道', '0', '', '1', '0', '0', '10'),
('7399', '210000', '210800', '210881', '1', '1', '太阳升街道', '0', '', '1', '0', '0', '10'),
('7400', '210000', '210800', '210881', '1', '1', '团山街道', '0', '', '1', '0', '0', '10'),
('7401', '210000', '210800', '210881', '1', '1', '西海街道', '0', '', '1', '0', '0', '10'),
('7402', '210000', '210800', '210881', '1', '1', '高屯镇', '0', '', '1', '0', '0', '10'),
('7403', '210000', '210800', '210881', '1', '1', '沙岗镇', '0', '', '1', '0', '0', '10'),
('7404', '210000', '210800', '210881', '1', '1', '九垅地镇', '0', '', '1', '0', '0', '10'),
('7405', '210000', '210800', '210881', '1', '1', '九寨镇', '0', '', '1', '0', '0', '10'),
('7406', '210000', '210800', '210881', '1', '1', '万福镇', '0', '', '1', '0', '0', '10'),
('7407', '210000', '210800', '210881', '1', '1', '卧龙泉镇', '0', '', '1', '0', '0', '10'),
('7408', '210000', '210800', '210881', '1', '1', '青石岭镇', '0', '', '1', '0', '0', '10'),
('7409', '210000', '210800', '210881', '1', '1', '暖泉镇', '0', '', '1', '0', '0', '10'),
('7410', '210000', '210800', '210881', '1', '1', '归州满族镇', '0', '', '1', '0', '0', '10'),
('7411', '210000', '210800', '210881', '1', '1', '榜式堡镇', '0', '', '1', '0', '0', '10'),
('7412', '210000', '210800', '210881', '1', '1', '团甸镇', '0', '', '1', '0', '0', '10'),
('7413', '210000', '210800', '210881', '1', '1', '双台镇', '0', '', '1', '0', '0', '10'),
('7414', '210000', '210800', '210881', '1', '1', '杨运镇', '0', '', '1', '0', '0', '10'),
('7415', '210000', '210800', '210881', '1', '1', '徐屯镇', '0', '', '1', '0', '0', '10'),
('7416', '210000', '210800', '210881', '1', '1', '什字街镇', '0', '', '1', '0', '0', '10'),
('7417', '210000', '210800', '210881', '1', '1', '矿洞沟镇', '0', '', '1', '0', '0', '10'),
('7418', '210000', '210800', '210881', '1', '1', '陈屯镇', '0', '', '1', '0', '0', '10'),
('7419', '210000', '210800', '210881', '1', '1', '梁屯镇', '0', '', '1', '0', '0', '10'),
('7420', '210000', '210800', '210881', '1', '1', '小石棚乡', '0', '', '1', '0', '0', '10'),
('7421', '210000', '210800', '210881', '1', '1', '果园乡', '0', '', '1', '0', '0', '10'),
('7422', '210000', '210800', '210881', '1', '1', '二台乡', '0', '', '1', '0', '0', '10'),
('7423', '210000', '210800', '210882', '1', '1', '石桥街道', '0', '', '1', '0', '0', '10'),
('7424', '210000', '210800', '210882', '1', '1', '青花街道', '0', '', '1', '0', '0', '10'),
('7425', '210000', '210800', '210882', '1', '1', '金桥街道', '0', '', '1', '0', '0', '10'),
('7426', '210000', '210800', '210882', '1', '1', '钢都街道', '0', '', '1', '0', '0', '10'),
('7427', '210000', '210800', '210882', '1', '1', '南楼街道', '0', '', '1', '0', '0', '10'),
('7428', '210000', '210800', '210882', '1', '1', '水源镇', '0', '', '1', '0', '0', '10'),
('7429', '210000', '210800', '210882', '1', '1', '沟沿镇', '0', '', '1', '0', '0', '10'),
('7430', '210000', '210800', '210882', '1', '1', '石佛镇', '0', '', '1', '0', '0', '10'),
('7431', '210000', '210800', '210882', '1', '1', '高坎镇', '0', '', '1', '0', '0', '10'),
('7432', '210000', '210800', '210882', '1', '1', '旗口镇', '0', '', '1', '0', '0', '10'),
('7433', '210000', '210800', '210882', '1', '1', '虎庄镇', '0', '', '1', '0', '0', '10'),
('7434', '210000', '210800', '210882', '1', '1', '官屯镇', '0', '', '1', '0', '0', '10'),
('7435', '210000', '210800', '210882', '1', '1', '博洛铺镇', '0', '', '1', '0', '0', '10'),
('7436', '210000', '210800', '210882', '1', '1', '永安镇', '0', '', '1', '0', '0', '10'),
('7437', '210000', '210800', '210882', '1', '1', '汤池镇', '0', '', '1', '0', '0', '10'),
('7438', '210000', '210800', '210882', '1', '1', '建一镇', '0', '', '1', '0', '0', '10'),
('7439', '210000', '210800', '210882', '1', '1', '黄土岭镇', '0', '', '1', '0', '0', '10'),
('7440', '210000', '210800', '210882', '1', '1', '周家镇', '0', '', '1', '0', '0', '10'),
('7441', '210000', '210900', '210902', '1', '1', '新兴街道', '0', '', '1', '0', '0', '10'),
('7442', '210000', '210900', '210902', '1', '1', '和平街道', '0', '', '1', '0', '0', '10'),
('7443', '210000', '210900', '210902', '1', '1', '西山街道', '0', '', '1', '0', '0', '10'),
('7444', '210000', '210900', '210902', '1', '1', '河北街道', '0', '', '1', '0', '0', '10'),
('7445', '210000', '210900', '210902', '1', '1', '站前街道', '0', '', '1', '0', '0', '10'),
('7446', '210000', '210900', '210902', '1', '1', '西阜新街道', '0', '', '1', '0', '0', '10'),
('7447', '210000', '210900', '210902', '1', '1', '五龙街道', '0', '', '1', '0', '0', '10'),
('7448', '210000', '210900', '210902', '1', '1', '平安西部街道', '0', '', '1', '0', '0', '10'),
('7449', '210000', '210900', '210902', '1', '1', '工人村街道', '0', '', '1', '0', '0', '10'),
('7450', '210000', '210900', '210902', '1', '1', '东梁街道', '0', '', '1', '0', '0', '10'),
('7451', '210000', '210900', '210902', '1', '1', '韩家店镇', '0', '', '1', '0', '0', '10'),
('7452', '210000', '210900', '210903', '1', '1', '街基街道', '0', '', '1', '0', '0', '10'),
('7453', '210000', '210900', '210903', '1', '1', '中部街道', '0', '', '1', '0', '0', '10'),
('7454', '210000', '210900', '210903', '1', '1', '北部街道', '0', '', '1', '0', '0', '10'),
('7455', '210000', '210900', '210903', '1', '1', '南部街道', '0', '', '1', '0', '0', '10'),
('7456', '210000', '210900', '210903', '1', '1', '长营子蒙古族镇', '0', '', '1', '0', '0', '10'),
('7457', '210000', '210900', '210904', '1', '1', '红树街道', '0', '', '1', '0', '0', '10'),
('7458', '210000', '210900', '210904', '1', '1', '煤海街道', '0', '', '1', '0', '0', '10'),
('7459', '210000', '210900', '210904', '1', '1', '高德街道', '0', '', '1', '0', '0', '10'),
('7460', '210000', '210900', '210904', '1', '1', '孙家湾街道', '0', '', '1', '0', '0', '10'),
('7461', '210000', '210900', '210904', '1', '1', '城南街道', '0', '', '1', '0', '0', '10'),
('7462', '210000', '210900', '210904', '1', '1', '水泉镇', '0', '', '1', '0', '0', '10'),
('7463', '210000', '210900', '210905', '1', '1', '清河街道', '0', '', '1', '0', '0', '10'),
('7464', '210000', '210900', '210905', '1', '1', '六台街道', '0', '', '1', '0', '0', '10'),
('7465', '210000', '210900', '210905', '1', '1', '艾友街道', '0', '', '1', '0', '0', '10'),
('7466', '210000', '210900', '210905', '1', '1', '新北街道', '0', '', '1', '0', '0', '10'),
('7467', '210000', '210900', '210905', '1', '1', '河西镇', '0', '', '1', '0', '0', '10'),
('7468', '210000', '210900', '210905', '1', '1', '乌龙坝镇', '0', '', '1', '0', '0', '10'),
('7469', '210000', '210900', '210911', '1', '1', '西苑街道', '0', '', '1', '0', '0', '10'),
('7470', '210000', '210900', '210911', '1', '1', '北苑街道', '0', '', '1', '0', '0', '10'),
('7471', '210000', '210900', '210911', '1', '1', '东苑街道', '0', '', '1', '0', '0', '10'),
('7472', '210000', '210900', '210911', '1', '1', '学院街道', '0', '', '1', '0', '0', '10'),
('7473', '210000', '210900', '210911', '1', '1', '中苑街道', '0', '', '1', '0', '0', '10'),
('7474', '210000', '210900', '210911', '1', '1', '华东街道', '0', '', '1', '0', '0', '10'),
('7475', '210000', '210900', '210911', '1', '1', '四合镇', '0', '', '1', '0', '0', '10'),
('7476', '210000', '210900', '210921', '1', '1', '阜新镇', '0', '', '1', '0', '0', '10'),
('7477', '210000', '210900', '210921', '1', '1', '东梁镇', '0', '', '1', '0', '0', '10'),
('7478', '210000', '210900', '210921', '1', '1', '佛寺镇', '0', '', '1', '0', '0', '10'),
('7479', '210000', '210900', '210921', '1', '1', '伊吗图镇', '0', '', '1', '0', '0', '10'),
('7480', '210000', '210900', '210921', '1', '1', '旧庙镇', '0', '', '1', '0', '0', '10'),
('7481', '210000', '210900', '210921', '1', '1', '务欢池镇', '0', '', '1', '0', '0', '10'),
('7482', '210000', '210900', '210921', '1', '1', '建设镇', '0', '', '1', '0', '0', '10'),
('7483', '210000', '210900', '210921', '1', '1', '大巴镇', '0', '', '1', '0', '0', '10'),
('7484', '210000', '210900', '210921', '1', '1', '泡子镇', '0', '', '1', '0', '0', '10'),
('7485', '210000', '210900', '210921', '1', '1', '十家子镇', '0', '', '1', '0', '0', '10'),
('7486', '210000', '210900', '210921', '1', '1', '王府镇', '0', '', '1', '0', '0', '10'),
('7487', '210000', '210900', '210921', '1', '1', '于寺镇', '0', '', '1', '0', '0', '10'),
('7488', '210000', '210900', '210921', '1', '1', '富荣镇', '0', '', '1', '0', '0', '10'),
('7489', '210000', '210900', '210921', '1', '1', '新民镇', '0', '', '1', '0', '0', '10'),
('7490', '210000', '210900', '210921', '1', '1', '福兴地镇', '0', '', '1', '0', '0', '10'),
('7491', '210000', '210900', '210921', '1', '1', '平安地镇', '0', '', '1', '0', '0', '10'),
('7492', '210000', '210900', '210921', '1', '1', '沙拉镇', '0', '', '1', '0', '0', '10'),
('7493', '210000', '210900', '210921', '1', '1', '大固本镇', '0', '', '1', '0', '0', '10'),
('7494', '210000', '210900', '210921', '1', '1', '大五家子镇', '0', '', '1', '0', '0', '10'),
('7495', '210000', '210900', '210921', '1', '1', '大板镇', '0', '', '1', '0', '0', '10'),
('7496', '210000', '210900', '210921', '1', '1', '蜘蛛山乡', '0', '', '1', '0', '0', '10'),
('7497', '210000', '210900', '210921', '1', '1', '卧凤沟乡', '0', '', '1', '0', '0', '10'),
('7498', '210000', '210900', '210921', '1', '1', '八家子乡', '0', '', '1', '0', '0', '10'),
('7499', '210000', '210900', '210921', '1', '1', '哈达户稍乡', '0', '', '1', '0', '0', '10'),
('7500', '210000', '210900', '210921', '1', '1', '塔营子乡', '0', '', '1', '0', '0', '10'),
('7501', '210000', '210900', '210921', '1', '1', '扎兰营子乡', '0', '', '1', '0', '0', '10'),
('7502', '210000', '210900', '210921', '1', '1', '招束沟乡', '0', '', '1', '0', '0', '10'),
('7503', '210000', '210900', '210921', '1', '1', '苍土乡', '0', '', '1', '0', '0', '10'),
('7504', '210000', '210900', '210921', '1', '1', '老河土乡', '0', '', '1', '0', '0', '10'),
('7505', '210000', '210900', '210921', '1', '1', '七家子乡', '0', '', '1', '0', '0', '10'),
('7506', '210000', '210900', '210921', '1', '1', '红帽子乡', '0', '', '1', '0', '0', '10'),
('7507', '210000', '210900', '210921', '1', '1', '紫都台乡', '0', '', '1', '0', '0', '10'),
('7508', '210000', '210900', '210921', '1', '1', '化石戈乡', '0', '', '1', '0', '0', '10'),
('7509', '210000', '210900', '210921', '1', '1', '太平乡', '0', '', '1', '0', '0', '10'),
('7510', '210000', '210900', '210921', '1', '1', '国华乡', '0', '', '1', '0', '0', '10');
INSERT INTO `wst_communitys` VALUES ('7511', '210000', '210900', '210921', '1', '1', '泡子', '0', '', '1', '0', '0', '10'),
('7512', '210000', '210900', '210922', '1', '1', '彰武镇', '0', '', '1', '0', '0', '10'),
('7513', '210000', '210900', '210922', '1', '1', '哈尔套镇', '0', '', '1', '0', '0', '10'),
('7514', '210000', '210900', '210922', '1', '1', '章古台镇', '0', '', '1', '0', '0', '10'),
('7515', '210000', '210900', '210922', '1', '1', '五峰镇', '0', '', '1', '0', '0', '10'),
('7516', '210000', '210900', '210922', '1', '1', '冯家镇', '0', '', '1', '0', '0', '10'),
('7517', '210000', '210900', '210922', '1', '1', '后新秋镇', '0', '', '1', '0', '0', '10'),
('7518', '210000', '210900', '210922', '1', '1', '东六家子镇', '0', '', '1', '0', '0', '10'),
('7519', '210000', '210900', '210922', '1', '1', '阿尔乡镇', '0', '', '1', '0', '0', '10'),
('7520', '210000', '210900', '210922', '1', '1', '苇子沟蒙古族乡', '0', '', '1', '0', '0', '10'),
('7521', '210000', '210900', '210922', '1', '1', '二道河子蒙古族乡', '0', '', '1', '0', '0', '10'),
('7522', '210000', '210900', '210922', '1', '1', '西六家子蒙古族满族乡', '0', '', '1', '0', '0', '10'),
('7523', '210000', '210900', '210922', '1', '1', '两家子乡', '0', '', '1', '0', '0', '10'),
('7524', '210000', '210900', '210922', '1', '1', '双庙乡', '0', '', '1', '0', '0', '10'),
('7525', '210000', '210900', '210922', '1', '1', '平安乡', '0', '', '1', '0', '0', '10'),
('7526', '210000', '210900', '210922', '1', '1', '满堂红乡', '0', '', '1', '0', '0', '10'),
('7527', '210000', '210900', '210922', '1', '1', '四堡子乡', '0', '', '1', '0', '0', '10'),
('7528', '210000', '210900', '210922', '1', '1', '丰田乡', '0', '', '1', '0', '0', '10'),
('7529', '210000', '210900', '210922', '1', '1', '大德乡', '0', '', '1', '0', '0', '10'),
('7530', '210000', '210900', '210922', '1', '1', '大冷蒙古族乡', '0', '', '1', '0', '0', '10'),
('7531', '210000', '210900', '210922', '1', '1', '前福兴地乡', '0', '', '1', '0', '0', '10'),
('7532', '210000', '210900', '210922', '1', '1', '兴隆堡乡', '0', '', '1', '0', '0', '10'),
('7533', '210000', '210900', '210922', '1', '1', '兴隆山乡', '0', '', '1', '0', '0', '10'),
('7534', '210000', '210900', '210922', '1', '1', '大四家子乡', '0', '', '1', '0', '0', '10'),
('7535', '210000', '210900', '210922', '1', '1', '四合城乡', '0', '', '1', '0', '0', '10'),
('7536', '210000', '211000', '211002', '1', '1', '星火街道', '0', '', '1', '0', '0', '10'),
('7537', '210000', '211000', '211002', '1', '1', '胜利街道', '0', '', '1', '0', '0', '10'),
('7538', '210000', '211000', '211002', '1', '1', '跃进街道', '0', '', '1', '0', '0', '10'),
('7539', '210000', '211000', '211002', '1', '1', '卫国路街道', '0', '', '1', '0', '0', '10'),
('7540', '210000', '211000', '211002', '1', '1', '站前街道', '0', '', '1', '0', '0', '10'),
('7541', '210000', '211000', '211002', '1', '1', '铁西街道', '0', '', '1', '0', '0', '10'),
('7542', '210000', '211000', '211003', '1', '1', '武圣街道', '0', '', '1', '0', '0', '10'),
('7543', '210000', '211000', '211003', '1', '1', '文圣街道', '0', '', '1', '0', '0', '10'),
('7544', '210000', '211000', '211003', '1', '1', '襄平街道', '0', '', '1', '0', '0', '10'),
('7545', '210000', '211000', '211003', '1', '1', '庆阳街道', '0', '', '1', '0', '0', '10'),
('7546', '210000', '211000', '211003', '1', '1', '南门街道', '0', '', '1', '0', '0', '10'),
('7547', '210000', '211000', '211003', '1', '1', '东兴街道', '0', '', '1', '0', '0', '10'),
('7548', '210000', '211000', '211004', '1', '1', '工农街道', '0', '', '1', '0', '0', '10'),
('7549', '210000', '211000', '211004', '1', '1', '光华街道', '0', '', '1', '0', '0', '10'),
('7550', '210000', '211000', '211004', '1', '1', '新村街道', '0', '', '1', '0', '0', '10'),
('7551', '210000', '211000', '211004', '1', '1', '长征街道', '0', '', '1', '0', '0', '10'),
('7552', '210000', '211000', '211004', '1', '1', '曙光镇', '0', '', '1', '0', '0', '10'),
('7553', '210000', '211000', '211005', '1', '1', '苏家街道', '0', '', '1', '0', '0', '10'),
('7554', '210000', '211000', '211005', '1', '1', '团山街道', '0', '', '1', '0', '0', '10'),
('7555', '210000', '211000', '211005', '1', '1', '安平街道', '0', '', '1', '0', '0', '10'),
('7556', '210000', '211000', '211005', '1', '1', '汤河镇', '0', '', '1', '0', '0', '10'),
('7557', '210000', '211000', '211005', '1', '1', '安平乡', '0', '', '1', '0', '0', '10'),
('7558', '210000', '211000', '211011', '1', '1', '新华街道', '0', '', '1', '0', '0', '10'),
('7559', '210000', '211000', '211011', '1', '1', '望水台街道', '0', '', '1', '0', '0', '10'),
('7560', '210000', '211000', '211011', '1', '1', '祁家镇', '0', '', '1', '0', '0', '10'),
('7561', '210000', '211000', '211011', '1', '1', '东京陵乡', '0', '', '1', '0', '0', '10'),
('7562', '210000', '211000', '211011', '1', '1', '东宁卫乡', '0', '', '1', '0', '0', '10'),
('7563', '210000', '211000', '211021', '1', '1', '首山镇', '0', '', '1', '0', '0', '10'),
('7564', '210000', '211000', '211021', '1', '1', '刘二堡镇', '0', '', '1', '0', '0', '10'),
('7565', '210000', '211000', '211021', '1', '1', '小屯镇', '0', '', '1', '0', '0', '10'),
('7566', '210000', '211000', '211021', '1', '1', '小北河镇', '0', '', '1', '0', '0', '10'),
('7567', '210000', '211000', '211021', '1', '1', '黄泥洼镇', '0', '', '1', '0', '0', '10'),
('7568', '210000', '211000', '211021', '1', '1', '沙岭镇', '0', '', '1', '0', '0', '10'),
('7569', '210000', '211000', '211021', '1', '1', '唐马寨镇', '0', '', '1', '0', '0', '10'),
('7570', '210000', '211000', '211021', '1', '1', '穆家镇', '0', '', '1', '0', '0', '10'),
('7571', '210000', '211000', '211021', '1', '1', '柳壕镇', '0', '', '1', '0', '0', '10'),
('7572', '210000', '211000', '211021', '1', '1', '兰家镇', '0', '', '1', '0', '0', '10'),
('7573', '210000', '211000', '211021', '1', '1', '河栏镇', '0', '', '1', '0', '0', '10'),
('7574', '210000', '211000', '211021', '1', '1', '隆昌镇', '0', '', '1', '0', '0', '10'),
('7575', '210000', '211000', '211021', '1', '1', '八会镇', '0', '', '1', '0', '0', '10'),
('7576', '210000', '211000', '211021', '1', '1', '寒岭镇', '0', '', '1', '0', '0', '10'),
('7577', '210000', '211000', '211021', '1', '1', '下达河乡', '0', '', '1', '0', '0', '10'),
('7578', '210000', '211000', '211021', '1', '1', '吉洞峪满族乡', '0', '', '1', '0', '0', '10'),
('7579', '210000', '211000', '211021', '1', '1', '甜水满族乡', '0', '', '1', '0', '0', '10'),
('7580', '210000', '211000', '211081', '1', '1', '烟台街道', '0', '', '1', '0', '0', '10'),
('7581', '210000', '211000', '211081', '1', '1', '万宝桥街道', '0', '', '1', '0', '0', '10'),
('7582', '210000', '211000', '211081', '1', '1', '古城子街道', '0', '', '1', '0', '0', '10'),
('7583', '210000', '211000', '211081', '1', '1', '佟二堡镇', '0', '', '1', '0', '0', '10'),
('7584', '210000', '211000', '211081', '1', '1', '铧子镇', '0', '', '1', '0', '0', '10'),
('7585', '210000', '211000', '211081', '1', '1', '张台子镇', '0', '', '1', '0', '0', '10'),
('7586', '210000', '211000', '211081', '1', '1', '西大窑镇', '0', '', '1', '0', '0', '10'),
('7587', '210000', '211000', '211081', '1', '1', '沈旦堡镇', '0', '', '1', '0', '0', '10'),
('7588', '210000', '211000', '211081', '1', '1', '西马峰镇', '0', '', '1', '0', '0', '10'),
('7589', '210000', '211000', '211081', '1', '1', '柳条寨镇', '0', '', '1', '0', '0', '10'),
('7590', '210000', '211000', '211081', '1', '1', '柳河子镇', '0', '', '1', '0', '0', '10'),
('7591', '210000', '211000', '211081', '1', '1', '罗大台镇', '0', '', '1', '0', '0', '10'),
('7592', '210000', '211000', '211081', '1', '1', '王家镇', '0', '', '1', '0', '0', '10'),
('7593', '210000', '211000', '211081', '1', '1', '大河南镇', '0', '', '1', '0', '0', '10'),
('7594', '210000', '211000', '211081', '1', '1', '五星镇', '0', '', '1', '0', '0', '10'),
('7595', '210000', '211000', '211081', '1', '1', '鸡冠山乡', '0', '', '1', '0', '0', '10'),
('7596', '210000', '211100', '211102', '1', '1', '东风街道', '0', '', '1', '0', '0', '10'),
('7597', '210000', '211100', '211102', '1', '1', '胜利街道', '0', '', '1', '0', '0', '10'),
('7598', '210000', '211100', '211102', '1', '1', '建设街道', '0', '', '1', '0', '0', '10'),
('7599', '210000', '211100', '211102', '1', '1', '红旗街道', '0', '', '1', '0', '0', '10'),
('7600', '210000', '211100', '211102', '1', '1', '辽河街道', '0', '', '1', '0', '0', '10'),
('7601', '210000', '211100', '211102', '1', '1', '石油街道', '0', '', '1', '0', '0', '10'),
('7602', '210000', '211100', '211102', '1', '1', '化工街道', '0', '', '1', '0', '0', '10'),
('7603', '210000', '211100', '211102', '1', '1', '铁东街道', '0', '', '1', '0', '0', '10'),
('7604', '210000', '211100', '211102', '1', '1', '双盛街道', '0', '', '1', '0', '0', '10'),
('7605', '210000', '211100', '211103', '1', '1', '振兴街道', '0', '', '1', '0', '0', '10'),
('7606', '210000', '211100', '211103', '1', '1', '兴隆街道', '0', '', '1', '0', '0', '10'),
('7607', '210000', '211100', '211103', '1', '1', '渤海街道', '0', '', '1', '0', '0', '10'),
('7608', '210000', '211100', '211103', '1', '1', '新工街道', '0', '', '1', '0', '0', '10'),
('7609', '210000', '211100', '211103', '1', '1', '于楼街道', '0', '', '1', '0', '0', '10'),
('7610', '210000', '211100', '211103', '1', '1', '友谊街道', '0', '', '1', '0', '0', '10'),
('7611', '210000', '211100', '211103', '1', '1', '曙光街道', '0', '', '1', '0', '0', '10'),
('7612', '210000', '211100', '211103', '1', '1', '欢喜街道', '0', '', '1', '0', '0', '10'),
('7613', '210000', '211100', '211103', '1', '1', '平安街道', '0', '', '1', '0', '0', '10'),
('7614', '210000', '211100', '211103', '1', '1', '新生街道', '0', '', '1', '0', '0', '10'),
('7615', '210000', '211100', '211103', '1', '1', '红村街道', '0', '', '1', '0', '0', '10'),
('7616', '210000', '211100', '211103', '1', '1', '高升街道', '0', '', '1', '0', '0', '10'),
('7617', '210000', '211100', '211103', '1', '1', '沈采街道', '0', '', '1', '0', '0', '10'),
('7618', '210000', '211100', '211103', '1', '1', '锦采街道', '0', '', '1', '0', '0', '10'),
('7619', '210000', '211100', '211103', '1', '1', '茨采街道', '0', '', '1', '0', '0', '10'),
('7620', '210000', '211100', '211103', '1', '1', '创新街道', '0', '', '1', '0', '0', '10'),
('7621', '210000', '211100', '211103', '1', '1', '兴盛街道', '0', '', '1', '0', '0', '10'),
('7622', '210000', '211100', '211103', '1', '1', '兴海街道', '0', '', '1', '0', '0', '10'),
('7623', '210000', '211100', '211121', '1', '1', '大洼镇', '0', '', '1', '0', '0', '10'),
('7624', '210000', '211100', '211121', '1', '1', '田庄台镇', '0', '', '1', '0', '0', '10'),
('7625', '210000', '211100', '211121', '1', '1', '二界沟镇', '0', '', '1', '0', '0', '10'),
('7626', '210000', '211100', '211121', '1', '1', '东风镇', '0', '', '1', '0', '0', '10'),
('7627', '210000', '211100', '211121', '1', '1', '新开镇', '0', '', '1', '0', '0', '10'),
('7628', '210000', '211100', '211121', '1', '1', '田家镇', '0', '', '1', '0', '0', '10'),
('7629', '210000', '211100', '211121', '1', '1', '清水镇', '0', '', '1', '0', '0', '10'),
('7630', '210000', '211100', '211121', '1', '1', '新兴镇', '0', '', '1', '0', '0', '10'),
('7631', '210000', '211100', '211121', '1', '1', '西安镇', '0', '', '1', '0', '0', '10'),
('7632', '210000', '211100', '211121', '1', '1', '新立镇', '0', '', '1', '0', '0', '10'),
('7633', '210000', '211100', '211121', '1', '1', '王家乡', '0', '', '1', '0', '0', '10'),
('7634', '210000', '211100', '211121', '1', '1', '唐家乡', '0', '', '1', '0', '0', '10'),
('7635', '210000', '211100', '211121', '1', '1', '荣兴乡', '0', '', '1', '0', '0', '10'),
('7636', '210000', '211100', '211121', '1', '1', '平安乡', '0', '', '1', '0', '0', '10'),
('7637', '210000', '211100', '211121', '1', '1', '赵圈河乡', '0', '', '1', '0', '0', '10'),
('7638', '210000', '211100', '211121', '1', '1', '辽滨开发区', '0', '', '1', '0', '0', '10'),
('7639', '210000', '211100', '211122', '1', '1', '沙岭镇', '0', '', '1', '0', '0', '10'),
('7640', '210000', '211100', '211122', '1', '1', '高升镇', '0', '', '1', '0', '0', '10'),
('7641', '210000', '211100', '211122', '1', '1', '胡家镇', '0', '', '1', '0', '0', '10'),
('7642', '210000', '211100', '211122', '1', '1', '石新镇', '0', '', '1', '0', '0', '10'),
('7643', '210000', '211100', '211122', '1', '1', '东郭镇', '0', '', '1', '0', '0', '10'),
('7644', '210000', '211100', '211122', '1', '1', '羊圈子镇', '0', '', '1', '0', '0', '10'),
('7645', '210000', '211100', '211122', '1', '1', '古城子镇', '0', '', '1', '0', '0', '10'),
('7646', '210000', '211100', '211122', '1', '1', '坝墙子镇', '0', '', '1', '0', '0', '10'),
('7647', '210000', '211100', '211122', '1', '1', '太平镇', '0', '', '1', '0', '0', '10'),
('7648', '210000', '211100', '211122', '1', '1', '陈家乡', '0', '', '1', '0', '0', '10'),
('7649', '210000', '211100', '211122', '1', '1', '吴家乡', '0', '', '1', '0', '0', '10'),
('7650', '210000', '211100', '211122', '1', '1', '陆家乡', '0', '', '1', '0', '0', '10'),
('7651', '210000', '211100', '211122', '1', '1', '甜水乡', '0', '', '1', '0', '0', '10'),
('7652', '210000', '211100', '211122', '1', '1', '大荒乡', '0', '', '1', '0', '0', '10'),
('7653', '210000', '211100', '211122', '1', '1', '盘山县林场', '0', '', '1', '0', '0', '10'),
('7654', '210000', '211200', '211202', '1', '1', '红旗街道', '0', '', '1', '0', '0', '10'),
('7655', '210000', '211200', '211202', '1', '1', '工人街道', '0', '', '1', '0', '0', '10'),
('7656', '210000', '211200', '211202', '1', '1', '铁西街道', '0', '', '1', '0', '0', '10'),
('7657', '210000', '211200', '211202', '1', '1', '铜钟街道', '0', '', '1', '0', '0', '10'),
('7658', '210000', '211200', '211202', '1', '1', '柴河街道', '0', '', '1', '0', '0', '10'),
('7659', '210000', '211200', '211202', '1', '1', '岭东街道', '0', '', '1', '0', '0', '10'),
('7660', '210000', '211200', '211202', '1', '1', '龙山乡', '0', '', '1', '0', '0', '10'),
('7661', '210000', '211200', '211202', '1', '1', '铁岭经济开发区', '0', '', '1', '0', '0', '10'),
('7662', '210000', '211200', '211204', '1', '1', '红旗街道', '0', '', '1', '0', '0', '10'),
('7663', '210000', '211200', '211204', '1', '1', '向阳街道', '0', '', '1', '0', '0', '10'),
('7664', '210000', '211200', '211204', '1', '1', '张相镇', '0', '', '1', '0', '0', '10'),
('7665', '210000', '211200', '211204', '1', '1', '杨木林子乡', '0', '', '1', '0', '0', '10'),
('7666', '210000', '211200', '211204', '1', '1', '聂家满族乡', '0', '', '1', '0', '0', '10'),
('7667', '210000', '211200', '211221', '1', '1', '新台子镇', '0', '', '1', '0', '0', '10'),
('7668', '210000', '211200', '211221', '1', '1', '阿吉镇', '0', '', '1', '0', '0', '10'),
('7669', '210000', '211200', '211221', '1', '1', '平顶堡镇', '0', '', '1', '0', '0', '10');
INSERT INTO `wst_communitys` VALUES ('7670', '210000', '211200', '211221', '1', '1', '大甸子镇', '0', '', '1', '0', '0', '10'),
('7671', '210000', '211200', '211221', '1', '1', '凡河镇', '0', '', '1', '0', '0', '10'),
('7672', '210000', '211200', '211221', '1', '1', '腰堡镇', '0', '', '1', '0', '0', '10'),
('7673', '210000', '211200', '211221', '1', '1', '镇西堡镇', '0', '', '1', '0', '0', '10'),
('7674', '210000', '211200', '211221', '1', '1', '蔡牛乡', '0', '', '1', '0', '0', '10'),
('7675', '210000', '211200', '211221', '1', '1', '双井子乡', '0', '', '1', '0', '0', '10'),
('7676', '210000', '211200', '211221', '1', '1', '熊官屯乡', '0', '', '1', '0', '0', '10'),
('7677', '210000', '211200', '211221', '1', '1', '李千户乡', '0', '', '1', '0', '0', '10'),
('7678', '210000', '211200', '211221', '1', '1', '横道河子乡', '0', '', '1', '0', '0', '10'),
('7679', '210000', '211200', '211221', '1', '1', '鸡冠山乡', '0', '', '1', '0', '0', '10'),
('7680', '210000', '211200', '211221', '1', '1', '白旗寨满族乡', '0', '', '1', '0', '0', '10'),
('7681', '210000', '211200', '211221', '1', '1', '种畜场', '0', '', '1', '0', '0', '10'),
('7682', '210000', '211200', '211223', '1', '1', '西丰镇', '0', '', '1', '0', '0', '10'),
('7683', '210000', '211200', '211223', '1', '1', '平岗镇', '0', '', '1', '0', '0', '10'),
('7684', '210000', '211200', '211223', '1', '1', '郜家店镇', '0', '', '1', '0', '0', '10'),
('7685', '210000', '211200', '211223', '1', '1', '凉泉镇', '0', '', '1', '0', '0', '10'),
('7686', '210000', '211200', '211223', '1', '1', '振兴镇', '0', '', '1', '0', '0', '10'),
('7687', '210000', '211200', '211223', '1', '1', '安民镇', '0', '', '1', '0', '0', '10'),
('7688', '210000', '211200', '211223', '1', '1', '天德镇', '0', '', '1', '0', '0', '10'),
('7689', '210000', '211200', '211223', '1', '1', '房木镇', '0', '', '1', '0', '0', '10'),
('7690', '210000', '211200', '211223', '1', '1', '陶然乡', '0', '', '1', '0', '0', '10'),
('7691', '210000', '211200', '211223', '1', '1', '柏榆乡', '0', '', '1', '0', '0', '10'),
('7692', '210000', '211200', '211223', '1', '1', '德兴乡', '0', '', '1', '0', '0', '10'),
('7693', '210000', '211200', '211223', '1', '1', '钓鱼乡', '0', '', '1', '0', '0', '10'),
('7694', '210000', '211200', '211223', '1', '1', '明德乡', '0', '', '1', '0', '0', '10'),
('7695', '210000', '211200', '211223', '1', '1', '成平满族乡', '0', '', '1', '0', '0', '10'),
('7696', '210000', '211200', '211223', '1', '1', '和隆满族乡', '0', '', '1', '0', '0', '10'),
('7697', '210000', '211200', '211223', '1', '1', '营厂乡', '0', '', '1', '0', '0', '10'),
('7698', '210000', '211200', '211223', '1', '1', '金星乡', '0', '', '1', '0', '0', '10'),
('7699', '210000', '211200', '211223', '1', '1', '更刻乡', '0', '', '1', '0', '0', '10'),
('7700', '210000', '211200', '211224', '1', '1', '昌图镇', '0', '', '1', '0', '0', '10'),
('7701', '210000', '211200', '211224', '1', '1', '老城镇', '0', '', '1', '0', '0', '10'),
('7702', '210000', '211200', '211224', '1', '1', '八面城镇', '0', '', '1', '0', '0', '10'),
('7703', '210000', '211200', '211224', '1', '1', '三江口镇', '0', '', '1', '0', '0', '10'),
('7704', '210000', '211200', '211224', '1', '1', '金家镇', '0', '', '1', '0', '0', '10'),
('7705', '210000', '211200', '211224', '1', '1', '宝力镇', '0', '', '1', '0', '0', '10'),
('7706', '210000', '211200', '211224', '1', '1', '泉头满族镇', '0', '', '1', '0', '0', '10'),
('7707', '210000', '211200', '211224', '1', '1', '双庙子镇', '0', '', '1', '0', '0', '10'),
('7708', '210000', '211200', '211224', '1', '1', '亮中桥镇', '0', '', '1', '0', '0', '10'),
('7709', '210000', '211200', '211224', '1', '1', '马仲河镇', '0', '', '1', '0', '0', '10'),
('7710', '210000', '211200', '211224', '1', '1', '毛家店镇', '0', '', '1', '0', '0', '10'),
('7711', '210000', '211200', '211224', '1', '1', '老四平镇', '0', '', '1', '0', '0', '10'),
('7712', '210000', '211200', '211224', '1', '1', '大洼镇', '0', '', '1', '0', '0', '10'),
('7713', '210000', '211200', '211224', '1', '1', '头道镇', '0', '', '1', '0', '0', '10'),
('7714', '210000', '211200', '211224', '1', '1', '此路树镇', '0', '', '1', '0', '0', '10'),
('7715', '210000', '211200', '211224', '1', '1', '付家镇', '0', '', '1', '0', '0', '10'),
('7716', '210000', '211200', '211224', '1', '1', '四合镇', '0', '', '1', '0', '0', '10'),
('7717', '210000', '211200', '211224', '1', '1', '朝阳镇', '0', '', '1', '0', '0', '10'),
('7718', '210000', '211200', '211224', '1', '1', '古榆树镇', '0', '', '1', '0', '0', '10'),
('7719', '210000', '211200', '211224', '1', '1', '七家子镇', '0', '', '1', '0', '0', '10'),
('7720', '210000', '211200', '211224', '1', '1', '东嘎镇', '0', '', '1', '0', '0', '10'),
('7721', '210000', '211200', '211224', '1', '1', '四面城镇', '0', '', '1', '0', '0', '10'),
('7722', '210000', '211200', '211224', '1', '1', '前双井子镇', '0', '', '1', '0', '0', '10'),
('7723', '210000', '211200', '211224', '1', '1', '大兴乡', '0', '', '1', '0', '0', '10'),
('7724', '210000', '211200', '211224', '1', '1', '十八家子乡', '0', '', '1', '0', '0', '10'),
('7725', '210000', '211200', '211224', '1', '1', '通江口乡', '0', '', '1', '0', '0', '10'),
('7726', '210000', '211200', '211224', '1', '1', '大四家子乡', '0', '', '1', '0', '0', '10'),
('7727', '210000', '211200', '211224', '1', '1', '后窑乡', '0', '', '1', '0', '0', '10'),
('7728', '210000', '211200', '211224', '1', '1', '长发乡', '0', '', '1', '0', '0', '10'),
('7729', '210000', '211200', '211224', '1', '1', '太平乡', '0', '', '1', '0', '0', '10'),
('7730', '210000', '211200', '211224', '1', '1', '下二台乡', '0', '', '1', '0', '0', '10'),
('7731', '210000', '211200', '211224', '1', '1', '平安堡乡', '0', '', '1', '0', '0', '10'),
('7732', '210000', '211200', '211224', '1', '1', '曲家店乡', '0', '', '1', '0', '0', '10'),
('7733', '210000', '211200', '211224', '1', '1', '三江口农场', '0', '', '1', '0', '0', '10'),
('7734', '210000', '211200', '211224', '1', '1', '宝力农场', '0', '', '1', '0', '0', '10'),
('7735', '210000', '211200', '211224', '1', '1', '新乡农场', '0', '', '1', '0', '0', '10'),
('7736', '210000', '211200', '211224', '1', '1', '付家林场', '0', '', '1', '0', '0', '10'),
('7737', '210000', '211200', '211224', '1', '1', '忙牛马场', '0', '', '1', '0', '0', '10'),
('7738', '210000', '211200', '211224', '1', '1', '两家子农场', '0', '', '1', '0', '0', '10'),
('7739', '210000', '211200', '211281', '1', '1', '兀术街道', '0', '', '1', '0', '0', '10'),
('7740', '210000', '211200', '211281', '1', '1', '调兵山街道', '0', '', '1', '0', '0', '10'),
('7741', '210000', '211200', '211281', '1', '1', '晓明镇', '0', '', '1', '0', '0', '10'),
('7742', '210000', '211200', '211281', '1', '1', '大明镇', '0', '', '1', '0', '0', '10'),
('7743', '210000', '211200', '211281', '1', '1', '晓南镇', '0', '', '1', '0', '0', '10'),
('7744', '210000', '211200', '211282', '1', '1', '新城街道', '0', '', '1', '0', '0', '10'),
('7745', '210000', '211200', '211282', '1', '1', '老城街道', '0', '', '1', '0', '0', '10'),
('7746', '210000', '211200', '211282', '1', '1', '兴开街道', '0', '', '1', '0', '0', '10'),
('7747', '210000', '211200', '211282', '1', '1', '威远堡镇', '0', '', '1', '0', '0', '10'),
('7748', '210000', '211200', '211282', '1', '1', '庆云堡镇', '0', '', '1', '0', '0', '10'),
('7749', '210000', '211200', '211282', '1', '1', '中固镇', '0', '', '1', '0', '0', '10'),
('7750', '210000', '211200', '211282', '1', '1', '八棵树镇', '0', '', '1', '0', '0', '10'),
('7751', '210000', '211200', '211282', '1', '1', '金沟子镇', '0', '', '1', '0', '0', '10'),
('7752', '210000', '211200', '211282', '1', '1', '八宝镇', '0', '', '1', '0', '0', '10'),
('7753', '210000', '211200', '211282', '1', '1', '业民镇', '0', '', '1', '0', '0', '10'),
('7754', '210000', '211200', '211282', '1', '1', '莲花镇', '0', '', '1', '0', '0', '10'),
('7755', '210000', '211200', '211282', '1', '1', '靠山镇', '0', '', '1', '0', '0', '10'),
('7756', '210000', '211200', '211282', '1', '1', '城东乡', '0', '', '1', '0', '0', '10'),
('7757', '210000', '211200', '211282', '1', '1', '三家子乡', '0', '', '1', '0', '0', '10'),
('7758', '210000', '211200', '211282', '1', '1', '马家寨乡', '0', '', '1', '0', '0', '10'),
('7759', '210000', '211200', '211282', '1', '1', '上肥地乡', '0', '', '1', '0', '0', '10'),
('7760', '210000', '211200', '211282', '1', '1', '下肥地乡', '0', '', '1', '0', '0', '10'),
('7761', '210000', '211200', '211282', '1', '1', '黄旗寨乡', '0', '', '1', '0', '0', '10'),
('7762', '210000', '211200', '211282', '1', '1', '松山堡乡', '0', '', '1', '0', '0', '10'),
('7763', '210000', '211200', '211282', '1', '1', '李家台乡', '0', '', '1', '0', '0', '10'),
('7764', '210000', '211200', '211282', '1', '1', '林丰乡', '0', '', '1', '0', '0', '10'),
('7765', '210000', '211300', '211302', '1', '1', '南塔街道', '0', '', '1', '0', '0', '10'),
('7766', '210000', '211300', '211302', '1', '1', '北塔街道', '0', '', '1', '0', '0', '10'),
('7767', '210000', '211300', '211302', '1', '1', '前进街道', '0', '', '1', '0', '0', '10'),
('7768', '210000', '211300', '211302', '1', '1', '凌河街道', '0', '', '1', '0', '0', '10'),
('7769', '210000', '211300', '211302', '1', '1', '光明街道', '0', '', '1', '0', '0', '10'),
('7770', '210000', '211300', '211302', '1', '1', '凌凤街道', '0', '', '1', '0', '0', '10'),
('7771', '210000', '211300', '211302', '1', '1', '龙山街道', '0', '', '1', '0', '0', '10'),
('7772', '210000', '211300', '211302', '1', '1', '站南街道', '0', '', '1', '0', '0', '10'),
('7773', '210000', '211300', '211302', '1', '1', '红旗街道', '0', '', '1', '0', '0', '10'),
('7774', '210000', '211300', '211302', '1', '1', '燕北街道', '0', '', '1', '0', '0', '10'),
('7775', '210000', '211300', '211302', '1', '1', '桃花吐镇', '0', '', '1', '0', '0', '10'),
('7776', '210000', '211300', '211302', '1', '1', '他拉皋镇', '0', '', '1', '0', '0', '10'),
('7777', '210000', '211300', '211302', '1', '1', '长宝营子乡', '0', '', '1', '0', '0', '10'),
('7778', '210000', '211300', '211302', '1', '1', '孙家湾乡', '0', '', '1', '0', '0', '10'),
('7779', '210000', '211300', '211303', '1', '1', '向阳街道', '0', '', '1', '0', '0', '10'),
('7780', '210000', '211300', '211303', '1', '1', '半拉山街道', '0', '', '1', '0', '0', '10'),
('7781', '210000', '211300', '211303', '1', '1', '马山街道', '0', '', '1', '0', '0', '10'),
('7782', '210000', '211300', '211303', '1', '1', '新华街道', '0', '', '1', '0', '0', '10'),
('7783', '210000', '211300', '211303', '1', '1', '海龙街道', '0', '', '1', '0', '0', '10'),
('7784', '210000', '211300', '211303', '1', '1', '开发区龙泉街道', '0', '', '1', '0', '0', '10'),
('7785', '210000', '211300', '211303', '1', '1', '七道泉子镇', '0', '', '1', '0', '0', '10'),
('7786', '210000', '211300', '211303', '1', '1', '西大营子镇', '0', '', '1', '0', '0', '10'),
('7787', '210000', '211300', '211303', '1', '1', '召都巴镇', '0', '', '1', '0', '0', '10'),
('7788', '210000', '211300', '211303', '1', '1', '大平房镇', '0', '', '1', '0', '0', '10'),
('7789', '210000', '211300', '211303', '1', '1', '边杖子乡', '0', '', '1', '0', '0', '10'),
('7790', '210000', '211300', '211303', '1', '1', '联合乡', '0', '', '1', '0', '0', '10'),
('7791', '210000', '211300', '211321', '1', '1', '波罗赤镇', '0', '', '1', '0', '0', '10'),
('7792', '210000', '211300', '211321', '1', '1', '木头城子镇', '0', '', '1', '0', '0', '10'),
('7793', '210000', '211300', '211321', '1', '1', '二十家子镇', '0', '', '1', '0', '0', '10'),
('7794', '210000', '211300', '211321', '1', '1', '羊山镇', '0', '', '1', '0', '0', '10'),
('7795', '210000', '211300', '211321', '1', '1', '六家子镇', '0', '', '1', '0', '0', '10'),
('7796', '210000', '211300', '211321', '1', '1', '瓦房子镇', '0', '', '1', '0', '0', '10'),
('7797', '210000', '211300', '211321', '1', '1', '大庙镇', '0', '', '1', '0', '0', '10'),
('7798', '210000', '211300', '211321', '1', '1', '柳城镇', '0', '', '1', '0', '0', '10'),
('7799', '210000', '211300', '211321', '1', '1', '南双庙乡', '0', '', '1', '0', '0', '10'),
('7800', '210000', '211300', '211321', '1', '1', '古山子乡', '0', '', '1', '0', '0', '10'),
('7801', '210000', '211300', '211321', '1', '1', '西五家子乡', '0', '', '1', '0', '0', '10'),
('7802', '210000', '211300', '211321', '1', '1', '北沟门子乡', '0', '', '1', '0', '0', '10'),
('7803', '210000', '211300', '211321', '1', '1', '杨树湾乡', '0', '', '1', '0', '0', '10'),
('7804', '210000', '211300', '211321', '1', '1', '东大道乡', '0', '', '1', '0', '0', '10'),
('7805', '210000', '211300', '211321', '1', '1', '乌兰河硕蒙古族乡', '0', '', '1', '0', '0', '10'),
('7806', '210000', '211300', '211321', '1', '1', '台子乡', '0', '', '1', '0', '0', '10'),
('7807', '210000', '211300', '211321', '1', '1', '胜利乡', '0', '', '1', '0', '0', '10'),
('7808', '210000', '211300', '211321', '1', '1', '东大屯乡', '0', '', '1', '0', '0', '10'),
('7809', '210000', '211300', '211321', '1', '1', '松岭门乡', '0', '', '1', '0', '0', '10'),
('7810', '210000', '211300', '211321', '1', '1', '根德营子乡', '0', '', '1', '0', '0', '10'),
('7811', '210000', '211300', '211321', '1', '1', '西营子乡', '0', '', '1', '0', '0', '10'),
('7812', '210000', '211300', '211321', '1', '1', '七道岭乡', '0', '', '1', '0', '0', '10'),
('7813', '210000', '211300', '211321', '1', '1', '北四家子乡', '0', '', '1', '0', '0', '10'),
('7814', '210000', '211300', '211321', '1', '1', '王营子乡', '0', '', '1', '0', '0', '10'),
('7815', '210000', '211300', '211321', '1', '1', '黑牛营子乡', '0', '', '1', '0', '0', '10'),
('7816', '210000', '211300', '211321', '1', '1', '尚志乡', '0', '', '1', '0', '0', '10'),
('7817', '210000', '211300', '211321', '1', '1', '长在营子乡', '0', '', '1', '0', '0', '10'),
('7818', '210000', '211300', '211321', '1', '1', '国营贾家店农场', '0', '', '1', '0', '0', '10'),
('7819', '210000', '211300', '211322', '1', '1', '叶柏寿街道', '0', '', '1', '0', '0', '10'),
('7820', '210000', '211300', '211322', '1', '1', '红山街道', '0', '', '1', '0', '0', '10'),
('7821', '210000', '211300', '211322', '1', '1', '铁南街道', '0', '', '1', '0', '0', '10'),
('7822', '210000', '211300', '211322', '1', '1', '万寿街道', '0', '', '1', '0', '0', '10'),
('7823', '210000', '211300', '211322', '1', '1', '富山街道', '0', '', '1', '0', '0', '10'),
('7824', '210000', '211300', '211322', '1', '1', '朱碌科镇', '0', '', '1', '0', '0', '10'),
('7825', '210000', '211300', '211322', '1', '1', '建平镇', '0', '', '1', '0', '0', '10'),
('7826', '210000', '211300', '211322', '1', '1', '黑水镇', '0', '', '1', '0', '0', '10'),
('7827', '210000', '211300', '211322', '1', '1', '喀喇沁镇', '0', '', '1', '0', '0', '10'),
('7828', '210000', '211300', '211322', '1', '1', '北二十家子镇', '0', '', '1', '0', '0', '10'),
('7829', '210000', '211300', '211322', '1', '1', '沙海镇', '0', '', '1', '0', '0', '10'),
('7830', '210000', '211300', '211322', '1', '1', '哈拉道口镇', '0', '', '1', '0', '0', '10'),
('7831', '210000', '211300', '211322', '1', '1', '榆树林子镇', '0', '', '1', '0', '0', '10'),
('7832', '210000', '211300', '211322', '1', '1', '老官地镇', '0', '', '1', '0', '0', '10'),
('7833', '210000', '211300', '211322', '1', '1', '深井镇', '0', '', '1', '0', '0', '10'),
('7834', '210000', '211300', '211322', '1', '1', '奎德素镇', '0', '', '1', '0', '0', '10'),
('7835', '210000', '211300', '211322', '1', '1', '小塘镇', '0', '', '1', '0', '0', '10'),
('7836', '210000', '211300', '211322', '1', '1', '马场镇', '0', '', '1', '0', '0', '10'),
('7837', '210000', '211300', '211322', '1', '1', '昌隆镇', '0', '', '1', '0', '0', '10'),
('7838', '210000', '211300', '211322', '1', '1', '张家营子镇', '0', '', '1', '0', '0', '10'),
('7839', '210000', '211300', '211322', '1', '1', '青松岭乡', '0', '', '1', '0', '0', '10'),
('7840', '210000', '211300', '211322', '1', '1', '杨树岭乡', '0', '', '1', '0', '0', '10'),
('7841', '210000', '211300', '211322', '1', '1', '罗福沟乡', '0', '', '1', '0', '0', '10'),
('7842', '210000', '211300', '211322', '1', '1', '烧锅营子乡', '0', '', '1', '0', '0', '10'),
('7843', '210000', '211300', '211322', '1', '1', '太平庄乡', '0', '', '1', '0', '0', '10'),
('7844', '210000', '211300', '211322', '1', '1', '白山乡', '0', '', '1', '0', '0', '10'),
('7845', '210000', '211300', '211322', '1', '1', '三家蒙古族乡', '0', '', '1', '0', '0', '10'),
('7846', '210000', '211300', '211322', '1', '1', '义成功乡', '0', '', '1', '0', '0', '10'),
('7847', '210000', '211300', '211322', '1', '1', '青峰山乡', '0', '', '1', '0', '0', '10'),
('7848', '210000', '211300', '211322', '1', '1', '八家国营农场', '0', '', '1', '0', '0', '10'),
('7849', '210000', '211300', '211322', '1', '1', '热水国营畜牧农场', '0', '', '1', '0', '0', '10'),
('7850', '210000', '211300', '211324', '1', '1', '大城子镇', '0', '', '1', '0', '0', '10'),
('7851', '210000', '211300', '211324', '1', '1', '南公营子镇', '0', '', '1', '0', '0', '10'),
('7852', '210000', '211300', '211324', '1', '1', '山嘴子镇', '0', '', '1', '0', '0', '10'),
('7853', '210000', '211300', '211324', '1', '1', '南哨镇', '0', '', '1', '0', '0', '10'),
('7854', '210000', '211300', '211324', '1', '1', '公营子镇', '0', '', '1', '0', '0', '10'),
('7855', '210000', '211300', '211324', '1', '1', '白塔子镇', '0', '', '1', '0', '0', '10'),
('7856', '210000', '211300', '211324', '1', '1', '中三家镇', '0', '', '1', '0', '0', '10'),
('7857', '210000', '211300', '211324', '1', '1', '老爷庙镇', '0', '', '1', '0', '0', '10'),
('7858', '210000', '211300', '211324', '1', '1', '六官营子镇', '0', '', '1', '0', '0', '10'),
('7859', '210000', '211300', '211324', '1', '1', '平房子镇', '0', '', '1', '0', '0', '10'),
('7860', '210000', '211300', '211324', '1', '1', '十二德堡乡', '0', '', '1', '0', '0', '10'),
('7861', '210000', '211300', '211324', '1', '1', '尤杖子乡', '0', '', '1', '0', '0', '10'),
('7862', '210000', '211300', '211324', '1', '1', '东哨乡', '0', '', '1', '0', '0', '10'),
('7863', '210000', '211300', '211324', '1', '1', '羊角沟乡', '0', '', '1', '0', '0', '10'),
('7864', '210000', '211300', '211324', '1', '1', '草场乡', '0', '', '1', '0', '0', '10'),
('7865', '210000', '211300', '211324', '1', '1', '坤都营子乡', '0', '', '1', '0', '0', '10'),
('7866', '210000', '211300', '211324', '1', '1', '大营子乡', '0', '', '1', '0', '0', '10'),
('7867', '210000', '211300', '211324', '1', '1', '兴隆庄乡', '0', '', '1', '0', '0', '10'),
('7868', '210000', '211300', '211324', '1', '1', '甘招乡', '0', '', '1', '0', '0', '10'),
('7869', '210000', '211300', '211324', '1', '1', '卧虎沟乡', '0', '', '1', '0', '0', '10'),
('7870', '210000', '211300', '211324', '1', '1', '水泉乡', '0', '', '1', '0', '0', '10'),
('7871', '210000', '211300', '211324', '1', '1', '国营官大海农场', '0', '', '1', '0', '0', '10'),
('7872', '210000', '211300', '211381', '1', '1', '城关街道', '0', '', '1', '0', '0', '10'),
('7873', '210000', '211300', '211381', '1', '1', '南山街道', '0', '', '1', '0', '0', '10'),
('7874', '210000', '211300', '211381', '1', '1', '冠山街道', '0', '', '1', '0', '0', '10'),
('7875', '210000', '211300', '211381', '1', '1', '桥北街道', '0', '', '1', '0', '0', '10'),
('7876', '210000', '211300', '211381', '1', '1', '三宝街道', '0', '', '1', '0', '0', '10'),
('7877', '210000', '211300', '211381', '1', '1', '台吉街道', '0', '', '1', '0', '0', '10'),
('7878', '210000', '211300', '211381', '1', '1', '双河街道', '0', '', '1', '0', '0', '10'),
('7879', '210000', '211300', '211381', '1', '1', '西官营镇', '0', '', '1', '0', '0', '10'),
('7880', '210000', '211300', '211381', '1', '1', '大板镇', '0', '', '1', '0', '0', '10'),
('7881', '210000', '211300', '211381', '1', '1', '上园镇', '0', '', '1', '0', '0', '10'),
('7882', '210000', '211300', '211381', '1', '1', '宝国老镇', '0', '', '1', '0', '0', '10'),
('7883', '210000', '211300', '211381', '1', '1', '黑城子镇', '0', '', '1', '0', '0', '10'),
('7884', '210000', '211300', '211381', '1', '1', '五间房镇', '0', '', '1', '0', '0', '10'),
('7885', '210000', '211300', '211381', '1', '1', '台吉镇', '0', '', '1', '0', '0', '10'),
('7886', '210000', '211300', '211381', '1', '1', '长皋乡', '0', '', '1', '0', '0', '10'),
('7887', '210000', '211300', '211381', '1', '1', '常河营乡', '0', '', '1', '0', '0', '10'),
('7888', '210000', '211300', '211381', '1', '1', '小塔子乡', '0', '', '1', '0', '0', '10'),
('7889', '210000', '211300', '211381', '1', '1', '马友营蒙古族乡', '0', '', '1', '0', '0', '10'),
('7890', '210000', '211300', '211381', '1', '1', '蒙古营乡', '0', '', '1', '0', '0', '10'),
('7891', '210000', '211300', '211381', '1', '1', '泉巨永乡', '0', '', '1', '0', '0', '10'),
('7892', '210000', '211300', '211381', '1', '1', '大三家乡', '0', '', '1', '0', '0', '10'),
('7893', '210000', '211300', '211381', '1', '1', '东官营乡', '0', '', '1', '0', '0', '10'),
('7894', '210000', '211300', '211381', '1', '1', '龙潭乡', '0', '', '1', '0', '0', '10'),
('7895', '210000', '211300', '211381', '1', '1', '哈尔脑乡', '0', '', '1', '0', '0', '10'),
('7896', '210000', '211300', '211381', '1', '1', '南八家子乡', '0', '', '1', '0', '0', '10'),
('7897', '210000', '211300', '211381', '1', '1', '章吉营乡', '0', '', '1', '0', '0', '10'),
('7898', '210000', '211300', '211381', '1', '1', '三宝营乡', '0', '', '1', '0', '0', '10'),
('7899', '210000', '211300', '211381', '1', '1', '巴图营乡', '0', '', '1', '0', '0', '10'),
('7900', '210000', '211300', '211381', '1', '1', '台吉营乡', '0', '', '1', '0', '0', '10'),
('7901', '210000', '211300', '211381', '1', '1', '北塔子乡', '0', '', '1', '0', '0', '10'),
('7902', '210000', '211300', '211381', '1', '1', '娄家店乡', '0', '', '1', '0', '0', '10'),
('7903', '210000', '211300', '211381', '1', '1', '北四家乡', '0', '', '1', '0', '0', '10'),
('7904', '210000', '211300', '211381', '1', '1', '凉水河蒙古族乡', '0', '', '1', '0', '0', '10'),
('7905', '210000', '211300', '211381', '1', '1', '三宝乡', '0', '', '1', '0', '0', '10'),
('7906', '210000', '211300', '211381', '1', '1', '下府经济开发区', '0', '', '1', '0', '0', '10'),
('7907', '210000', '211300', '211381', '1', '1', '大黑山特别行政管理区', '0', '', '1', '0', '0', '10'),
('7908', '210000', '211300', '211381', '1', '1', '兴顺德国营农场', '0', '', '1', '0', '0', '10'),
('7909', '210000', '211300', '211382', '1', '1', '东城街道', '0', '', '1', '0', '0', '10'),
('7910', '210000', '211300', '211382', '1', '1', '北街街道', '0', '', '1', '0', '0', '10'),
('7911', '210000', '211300', '211382', '1', '1', '南街街道', '0', '', '1', '0', '0', '10'),
('7912', '210000', '211300', '211382', '1', '1', '红山街道', '0', '', '1', '0', '0', '10'),
('7913', '210000', '211300', '211382', '1', '1', '热水汤街道', '0', '', '1', '0', '0', '10'),
('7914', '210000', '211300', '211382', '1', '1', '工业园区街道', '0', '', '1', '0', '0', '10'),
('7915', '210000', '211300', '211382', '1', '1', '万元店镇', '0', '', '1', '0', '0', '10'),
('7916', '210000', '211300', '211382', '1', '1', '宋杖子镇', '0', '', '1', '0', '0', '10'),
('7917', '210000', '211300', '211382', '1', '1', '三十家子镇', '0', '', '1', '0', '0', '10'),
('7918', '210000', '211300', '211382', '1', '1', '杨杖子镇', '0', '', '1', '0', '0', '10'),
('7919', '210000', '211300', '211382', '1', '1', '刀尔登镇', '0', '', '1', '0', '0', '10'),
('7920', '210000', '211300', '211382', '1', '1', '松岭子镇', '0', '', '1', '0', '0', '10'),
('7921', '210000', '211300', '211382', '1', '1', '四官营子镇', '0', '', '1', '0', '0', '10'),
('7922', '210000', '211300', '211382', '1', '1', '沟门子镇', '0', '', '1', '0', '0', '10'),
('7923', '210000', '211300', '211382', '1', '1', '凌北镇', '0', '', '1', '0', '0', '10'),
('7924', '210000', '211300', '211382', '1', '1', '小城子镇', '0', '', '1', '0', '0', '10'),
('7925', '210000', '211300', '211382', '1', '1', '四合当镇', '0', '', '1', '0', '0', '10'),
('7926', '210000', '211300', '211382', '1', '1', '城关镇', '0', '', '1', '0', '0', '10'),
('7927', '210000', '211300', '211382', '1', '1', '乌兰白镇', '0', '', '1', '0', '0', '10'),
('7928', '210000', '211300', '211382', '1', '1', '大王杖子乡', '0', '', '1', '0', '0', '10'),
('7929', '210000', '211300', '211382', '1', '1', '刘杖子乡', '0', '', '1', '0', '0', '10'),
('7930', '210000', '211300', '211382', '1', '1', '前进乡', '0', '', '1', '0', '0', '10'),
('7931', '210000', '211300', '211382', '1', '1', '大河北乡', '0', '', '1', '0', '0', '10'),
('7932', '210000', '211300', '211382', '1', '1', '三道河子乡', '0', '', '1', '0', '0', '10'),
('7933', '210000', '211300', '211382', '1', '1', '牛营子乡', '0', '', '1', '0', '0', '10'),
('7934', '210000', '211300', '211382', '1', '1', '北炉乡', '0', '', '1', '0', '0', '10'),
('7935', '210000', '211300', '211382', '1', '1', '瓦房店乡', '0', '', '1', '0', '0', '10'),
('7936', '210000', '211300', '211382', '1', '1', '三家子乡', '0', '', '1', '0', '0', '10'),
('7937', '210000', '211300', '211382', '1', '1', '佛爷洞乡', '0', '', '1', '0', '0', '10'),
('7938', '210000', '211300', '211382', '1', '1', '河坎子乡', '0', '', '1', '0', '0', '10'),
('7939', '210000', '211400', '211402', '1', '1', '连山街道', '0', '', '1', '0', '0', '10'),
('7940', '210000', '211400', '211402', '1', '1', '站前街道', '0', '', '1', '0', '0', '10'),
('7941', '210000', '211400', '211402', '1', '1', '渤海街道', '0', '', '1', '0', '0', '10'),
('7942', '210000', '211400', '211402', '1', '1', '兴工街道', '0', '', '1', '0', '0', '10'),
('7943', '210000', '211400', '211402', '1', '1', '石油街道', '0', '', '1', '0', '0', '10'),
('7944', '210000', '211400', '211402', '1', '1', '化工街道', '0', '', '1', '0', '0', '10'),
('7945', '210000', '211400', '211402', '1', '1', '化机街道', '0', '', '1', '0', '0', '10'),
('7946', '210000', '211400', '211402', '1', '1', '水泥街道', '0', '', '1', '0', '0', '10'),
('7947', '210000', '211400', '211402', '1', '1', '杨家杖子街道', '0', '', '1', '0', '0', '10'),
('7948', '210000', '211400', '211402', '1', '1', '锦郊街道', '0', '', '1', '0', '0', '10'),
('7949', '210000', '211400', '211402', '1', '1', '虹螺岘镇', '0', '', '1', '0', '0', '10'),
('7950', '210000', '211400', '211402', '1', '1', '高桥镇', '0', '', '1', '0', '0', '10'),
('7951', '210000', '211400', '211402', '1', '1', '钢屯镇', '0', '', '1', '0', '0', '10'),
('7952', '210000', '211400', '211402', '1', '1', '寺儿堡镇', '0', '', '1', '0', '0', '10'),
('7953', '210000', '211400', '211402', '1', '1', '新台门蒙古族镇', '0', '', '1', '0', '0', '10'),
('7954', '210000', '211400', '211402', '1', '1', '金星镇', '0', '', '1', '0', '0', '10'),
('7955', '210000', '211400', '211402', '1', '1', '台集屯镇', '0', '', '1', '0', '0', '10'),
('7956', '210000', '211400', '211402', '1', '1', '沙河营乡', '0', '', '1', '0', '0', '10'),
('7957', '210000', '211400', '211402', '1', '1', '孤竹营子乡', '0', '', '1', '0', '0', '10'),
('7958', '210000', '211400', '211402', '1', '1', '白马石乡', '0', '', '1', '0', '0', '10'),
('7959', '210000', '211400', '211402', '1', '1', '山神庙子乡', '0', '', '1', '0', '0', '10'),
('7960', '210000', '211400', '211402', '1', '1', '塔山乡', '0', '', '1', '0', '0', '10'),
('7961', '210000', '211400', '211402', '1', '1', '张相公屯乡', '0', '', '1', '0', '0', '10'),
('7962', '210000', '211400', '211402', '1', '1', '杨郊乡', '0', '', '1', '0', '0', '10'),
('7963', '210000', '211400', '211402', '1', '1', '大兴乡', '0', '', '1', '0', '0', '10'),
('7964', '210000', '211400', '211403', '1', '1', '葫芦岛街道', '0', '', '1', '0', '0', '10'),
('7965', '210000', '211400', '211403', '1', '1', '东街道', '0', '', '1', '0', '0', '10'),
('7966', '210000', '211400', '211403', '1', '1', '西街道', '0', '', '1', '0', '0', '10'),
('7967', '210000', '211400', '211403', '1', '1', '望海寺街道', '0', '', '1', '0', '0', '10'),
('7968', '210000', '211400', '211403', '1', '1', '龙湾街道', '0', '', '1', '0', '0', '10'),
('7969', '210000', '211400', '211403', '1', '1', '滨海街道', '0', '', '1', '0', '0', '10'),
('7970', '210000', '211400', '211403', '1', '1', '双龙街道', '0', '', '1', '0', '0', '10'),
('7971', '210000', '211400', '211403', '1', '1', '玉皇街道', '0', '', '1', '0', '0', '10'),
('7972', '210000', '211400', '211403', '1', '1', '连湾街道', '0', '', '1', '0', '0', '10'),
('7973', '210000', '211400', '211403', '1', '1', '北港街道', '0', '', '1', '0', '0', '10'),
('7974', '210000', '211400', '211403', '1', '1', '双树镇', '0', '', '1', '0', '0', '10'),
('7975', '210000', '211400', '211403', '1', '1', '葫芦岛经济开发区', '0', '', '1', '0', '0', '10'),
('7976', '210000', '211400', '211403', '1', '1', '葫芦岛市专利技术园区', '0', '', '1', '0', '0', '10'),
('7977', '210000', '211400', '211404', '1', '1', '赵家屯街道', '0', '', '1', '0', '0', '10'),
('7978', '210000', '211400', '211404', '1', '1', '沙锅屯街道', '0', '', '1', '0', '0', '10'),
('7979', '210000', '211400', '211404', '1', '1', '邱皮沟街道', '0', '', '1', '0', '0', '10'),
('7980', '210000', '211400', '211404', '1', '1', '苇子沟街道', '0', '', '1', '0', '0', '10'),
('7981', '210000', '211400', '211404', '1', '1', '三家子街道', '0', '', '1', '0', '0', '10'),
('7982', '210000', '211400', '211404', '1', '1', '小凌河街道', '0', '', '1', '0', '0', '10'),
('7983', '210000', '211400', '211404', '1', '1', '九龙街道', '0', '', '1', '0', '0', '10'),
('7984', '210000', '211400', '211404', '1', '1', '缸窑岭镇', '0', '', '1', '0', '0', '10'),
('7985', '210000', '211400', '211404', '1', '1', '暖池塘镇', '0', '', '1', '0', '0', '10'),
('7986', '210000', '211400', '211404', '1', '1', '沙锅屯乡', '0', '', '1', '0', '0', '10'),
('7987', '210000', '211400', '211404', '1', '1', '黄土坎乡', '0', '', '1', '0', '0', '10'),
('7988', '210000', '211400', '211404', '1', '1', '乌金塘水库', '0', '', '1', '0', '0', '10'),
('7989', '210000', '211400', '211421', '1', '1', '绥中镇', '0', '', '1', '0', '0', '10'),
('7990', '210000', '211400', '211421', '1', '1', '西甸子镇', '0', '', '1', '0', '0', '10'),
('7991', '210000', '211400', '211421', '1', '1', '宽帮满族镇', '0', '', '1', '0', '0', '10'),
('7992', '210000', '211400', '211421', '1', '1', '大王庙满族镇', '0', '', '1', '0', '0', '10'),
('7993', '210000', '211400', '211421', '1', '1', '万家镇', '0', '', '1', '0', '0', '10'),
('7994', '210000', '211400', '211421', '1', '1', '前所镇', '0', '', '1', '0', '0', '10'),
('7995', '210000', '211400', '211421', '1', '1', '高岭镇', '0', '', '1', '0', '0', '10'),
('7996', '210000', '211400', '211421', '1', '1', '前卫镇', '0', '', '1', '0', '0', '10'),
('7997', '210000', '211400', '211421', '1', '1', '荒地满族镇', '0', '', '1', '0', '0', '10'),
('7998', '210000', '211400', '211421', '1', '1', '塔山屯镇', '0', '', '1', '0', '0', '10'),
('7999', '210000', '211400', '211421', '1', '1', '高台镇', '0', '', '1', '0', '0', '10'),
('8000', '210000', '211400', '211421', '1', '1', '王宝镇', '0', '', '1', '0', '0', '10'),
('8001', '210000', '211400', '211421', '1', '1', '沙河镇', '0', '', '1', '0', '0', '10'),
('8002', '210000', '211400', '211421', '1', '1', '小庄子镇', '0', '', '1', '0', '0', '10'),
('8003', '210000', '211400', '211421', '1', '1', '西平坡满族乡', '0', '', '1', '0', '0', '10'),
('8004', '210000', '211400', '211421', '1', '1', '葛家满族乡', '0', '', '1', '0', '0', '10'),
('8005', '210000', '211400', '211421', '1', '1', '高甸子满族乡', '0', '', '1', '0', '0', '10'),
('8006', '210000', '211400', '211421', '1', '1', '范家满族乡', '0', '', '1', '0', '0', '10'),
('8007', '210000', '211400', '211421', '1', '1', '明水满族乡', '0', '', '1', '0', '0', '10'),
('8008', '210000', '211400', '211421', '1', '1', '秋子沟乡', '0', '', '1', '0', '0', '10'),
('8009', '210000', '211400', '211421', '1', '1', '加碑岩乡', '0', '', '1', '0', '0', '10'),
('8010', '210000', '211400', '211421', '1', '1', '永安堡乡', '0', '', '1', '0', '0', '10'),
('8011', '210000', '211400', '211421', '1', '1', '李家堡乡', '0', '', '1', '0', '0', '10'),
('8012', '210000', '211400', '211421', '1', '1', '网户满族乡', '0', '', '1', '0', '0', '10'),
('8013', '210000', '211400', '211421', '1', '1', '城郊乡', '0', '', '1', '0', '0', '10'),
('8014', '210000', '211400', '211421', '1', '1', '大台山果树农场', '0', '', '1', '0', '0', '10'),
('8015', '210000', '211400', '211421', '1', '1', '前所果树农场', '0', '', '1', '0', '0', '10'),
('8016', '210000', '211400', '211422', '1', '1', '建昌镇', '0', '', '1', '0', '0', '10'),
('8017', '210000', '211400', '211422', '1', '1', '八家子镇', '0', '', '1', '0', '0', '10'),
('8018', '210000', '211400', '211422', '1', '1', '喇嘛洞镇', '0', '', '1', '0', '0', '10'),
('8019', '210000', '211400', '211422', '1', '1', '药王庙镇', '0', '', '1', '0', '0', '10'),
('8020', '210000', '211400', '211422', '1', '1', '汤神庙镇', '0', '', '1', '0', '0', '10'),
('8021', '210000', '211400', '211422', '1', '1', '玲珑塔镇', '0', '', '1', '0', '0', '10'),
('8022', '210000', '211400', '211422', '1', '1', '大屯镇', '0', '', '1', '0', '0', '10'),
('8023', '210000', '211400', '211422', '1', '1', '牛亡牛营子乡', '0', '', '1', '0', '0', '10'),
('8024', '210000', '211400', '211422', '1', '1', '素珠营子乡', '0', '', '1', '0', '0', '10'),
('8025', '210000', '211400', '211422', '1', '1', '石佛乡', '0', '', '1', '0', '0', '10'),
('8026', '210000', '211400', '211422', '1', '1', '王宝营子乡', '0', '', '1', '0', '0', '10'),
('8027', '210000', '211400', '211422', '1', '1', '老达杖子乡', '0', '', '1', '0', '0', '10'),
('8028', '210000', '211400', '211422', '1', '1', '要路沟乡', '0', '', '1', '0', '0', '10'),
('8029', '210000', '211400', '211422', '1', '1', '魏家岭乡', '0', '', '1', '0', '0', '10'),
('8030', '210000', '211400', '211422', '1', '1', '西碱厂乡', '0', '', '1', '0', '0', '10'),
('8031', '210000', '211400', '211422', '1', '1', '头道营子乡', '0', '', '1', '0', '0', '10'),
('8032', '210000', '211400', '211422', '1', '1', '新开岭乡', '0', '', '1', '0', '0', '10'),
('8033', '210000', '211400', '211422', '1', '1', '贺杖子乡', '0', '', '1', '0', '0', '10'),
('8034', '210000', '211400', '211422', '1', '1', '养马甸子乡', '0', '', '1', '0', '0', '10'),
('8035', '210000', '211400', '211422', '1', '1', '和尚房子乡', '0', '', '1', '0', '0', '10'),
('8036', '210000', '211400', '211422', '1', '1', '杨树湾子乡', '0', '', '1', '0', '0', '10'),
('8037', '210000', '211400', '211422', '1', '1', '黑山科乡', '0', '', '1', '0', '0', '10'),
('8038', '210000', '211400', '211422', '1', '1', '雷家店乡', '0', '', '1', '0', '0', '10'),
('8039', '210000', '211400', '211422', '1', '1', '小德营子乡', '0', '', '1', '0', '0', '10'),
('8040', '210000', '211400', '211422', '1', '1', '二道湾子蒙古族乡', '0', '', '1', '0', '0', '10'),
('8041', '210000', '211400', '211422', '1', '1', '巴什罕乡', '0', '', '1', '0', '0', '10'),
('8042', '210000', '211400', '211422', '1', '1', '娘娘庙乡', '0', '', '1', '0', '0', '10'),
('8043', '210000', '211400', '211422', '1', '1', '谷杖子乡', '0', '', '1', '0', '0', '10'),
('8044', '210000', '211400', '211481', '1', '1', '古城街道', '0', '', '1', '0', '0', '10'),
('8045', '210000', '211400', '211481', '1', '1', '宁远街道', '0', '', '1', '0', '0', '10'),
('8046', '210000', '211400', '211481', '1', '1', '城东街道', '0', '', '1', '0', '0', '10'),
('8047', '210000', '211400', '211481', '1', '1', '温泉街道', '0', '', '1', '0', '0', '10'),
('8048', '210000', '211400', '211481', '1', '1', '钓鱼台街道', '0', '', '1', '0', '0', '10'),
('8049', '210000', '211400', '211481', '1', '1', '华山街道', '0', '', '1', '0', '0', '10'),
('8050', '210000', '211400', '211481', '1', '1', '四家屯街道', '0', '', '1', '0', '0', '10'),
('8051', '210000', '211400', '211481', '1', '1', '曹庄镇', '0', '', '1', '0', '0', '10'),
('8052', '210000', '211400', '211481', '1', '1', '沙后所满族镇', '0', '', '1', '0', '0', '10'),
('8053', '210000', '211400', '211481', '1', '1', '东辛庄满族镇', '0', '', '1', '0', '0', '10'),
('8054', '210000', '211400', '211481', '1', '1', '郭家满族镇', '0', '', '1', '0', '0', '10'),
('8055', '210000', '211400', '211481', '1', '1', '羊安满族乡', '0', '', '1', '0', '0', '10'),
('8056', '210000', '211400', '211481', '1', '1', '元台子满族乡', '0', '', '1', '0', '0', '10'),
('8057', '210000', '211400', '211481', '1', '1', '白塔满族乡', '0', '', '1', '0', '0', '10'),
('8058', '210000', '211400', '211481', '1', '1', '望海满族乡', '0', '', '1', '0', '0', '10'),
('8059', '210000', '211400', '211481', '1', '1', '刘台子满族乡', '0', '', '1', '0', '0', '10'),
('8060', '210000', '211400', '211481', '1', '1', '大寨满族乡', '0', '', '1', '0', '0', '10'),
('8061', '210000', '211400', '211481', '1', '1', '南大山满族乡', '0', '', '1', '0', '0', '10'),
('8062', '210000', '211400', '211481', '1', '1', '围屏满族乡', '0', '', '1', '0', '0', '10'),
('8063', '210000', '211400', '211481', '1', '1', '高家岭满族乡', '0', '', '1', '0', '0', '10'),
('8064', '210000', '211400', '211481', '1', '1', '碱厂满族乡', '0', '', '1', '0', '0', '10'),
('8065', '210000', '211400', '211481', '1', '1', '三道沟满族乡', '0', '', '1', '0', '0', '10'),
('8066', '210000', '211400', '211481', '1', '1', '红崖子满族乡', '0', '', '1', '0', '0', '10'),
('8067', '210000', '211400', '211481', '1', '1', '旧门满族乡', '0', '', '1', '0', '0', '10'),
('8068', '210000', '211400', '211481', '1', '1', '药王满族乡', '0', '', '1', '0', '0', '10'),
('8069', '210000', '211400', '211481', '1', '1', '海滨满族乡', '0', '', '1', '0', '0', '10'),
('8070', '210000', '211400', '211481', '1', '1', '菊花岛乡', '0', '', '1', '0', '0', '10'),
('8071', '220000', '220100', '220102', '1', '1', '南岭街道', '0', '', '1', '0', '0', '10'),
('8072', '220000', '220100', '220102', '1', '1', '自强街道', '0', '', '1', '0', '0', '10'),
('8073', '220000', '220100', '220102', '1', '1', '民康街道', '0', '', '1', '0', '0', '10'),
('8074', '220000', '220100', '220102', '1', '1', '新春街道', '0', '', '1', '0', '0', '10'),
('8075', '220000', '220100', '220102', '1', '1', '长通街道', '0', '', '1', '0', '0', '10'),
('8076', '220000', '220100', '220102', '1', '1', '全安街道', '0', '', '1', '0', '0', '10'),
('8077', '220000', '220100', '220102', '1', '1', '曙光街道', '0', '', '1', '0', '0', '10'),
('8078', '220000', '220100', '220102', '1', '1', '永吉街道', '0', '', '1', '0', '0', '10'),
('8079', '220000', '220100', '220102', '1', '1', '桃源街道', '0', '', '1', '0', '0', '10'),
('8080', '220000', '220100', '220102', '1', '1', '鸿城街道', '0', '', '1', '0', '0', '10'),
('8081', '220000', '220100', '220102', '1', '1', '临河街道办事处（长春经济技术开发区）（国', '0', '', '1', '0', '0', '10'),
('8082', '220000', '220100', '220102', '1', '1', '永兴街道办事处（净月潭旅游经济开发区）（', '0', '', '1', '0', '0', '10'),
('8083', '220000', '220100', '220102', '1', '1', '净月街道办事处（净月潭旅游经济开发区）（', '0', '', '1', '0', '0', '10'),
('8084', '220000', '220100', '220102', '1', '1', '新立城镇（净月潭旅游经济开发区）（省级）', '0', '', '1', '0', '0', '10'),
('8085', '220000', '220100', '220102', '1', '1', '新湖镇（净月潭旅游经济开发区）（省级）', '0', '', '1', '0', '0', '10'),
('8086', '220000', '220100', '220102', '1', '1', '玉潭镇（净月潭旅游经济开发区）（省级）', '0', '', '1', '0', '0', '10'),
('8087', '220000', '220100', '220102', '1', '1', '幸福乡', '0', '', '1', '0', '0', '10'),
('8088', '220000', '220100', '220103', '1', '1', '新发街道', '0', '', '1', '0', '0', '10'),
('8089', '220000', '220100', '220103', '1', '1', '站前街道', '0', '', '1', '0', '0', '10'),
('8090', '220000', '220100', '220103', '1', '1', '南广街道', '0', '', '1', '0', '0', '10'),
('8091', '220000', '220100', '220103', '1', '1', '东广街道', '0', '', '1', '0', '0', '10'),
('8092', '220000', '220100', '220103', '1', '1', '群英街道', '0', '', '1', '0', '0', '10'),
('8093', '220000', '220100', '220103', '1', '1', '兴业街道', '0', '', '1', '0', '0', '10'),
('8094', '220000', '220100', '220103', '1', '1', '凯旋街道', '0', '', '1', '0', '0', '10'),
('8095', '220000', '220100', '220103', '1', '1', '团山街道', '0', '', '1', '0', '0', '10'),
('8096', '220000', '220100', '220103', '1', '1', '柳影街道', '0', '', '1', '0', '0', '10'),
('8097', '220000', '220100', '220103', '1', '1', '兰家镇', '0', '', '1', '0', '0', '10'),
('8098', '220000', '220100', '220103', '1', '1', '米沙子镇', '0', '', '1', '0', '0', '10'),
('8099', '220000', '220100', '220103', '1', '1', '万宝镇', '0', '', '1', '0', '0', '10'),
('8100', '220000', '220100', '220103', '1', '1', '兴隆山镇（长春经济技术开发区）（国家级）', '0', '', '1', '0', '0', '10'),
('8101', '220000', '220100', '220103', '1', '1', '合隆镇（合隆经济开发区）（省级）', '0', '', '1', '0', '0', '10'),
('8102', '220000', '220100', '220103', '1', '1', '奋进乡', '0', '', '1', '0', '0', '10'),
('8103', '220000', '220100', '220103', '1', '1', '兴业农场', '0', '', '1', '0', '0', '10'),
('8104', '220000', '220100', '220104', '1', '1', '南站街道', '0', '', '1', '0', '0', '10'),
('8105', '220000', '220100', '220104', '1', '1', '桂林街道', '0', '', '1', '0', '0', '10'),
('8106', '220000', '220100', '220104', '1', '1', '南湖街道', '0', '', '1', '0', '0', '10'),
('8107', '220000', '220100', '220104', '1', '1', '永昌街道', '0', '', '1', '0', '0', '10'),
('8108', '220000', '220100', '220104', '1', '1', '重庆街道', '0', '', '1', '0', '0', '10'),
('8109', '220000', '220100', '220104', '1', '1', '清和街道', '0', '', '1', '0', '0', '10'),
('8110', '220000', '220100', '220104', '1', '1', '红旗街道', '0', '', '1', '0', '0', '10'),
('8111', '220000', '220100', '220104', '1', '1', '湖西街道', '0', '', '1', '0', '0', '10'),
('8112', '220000', '220100', '220104', '1', '1', '富锋街道', '0', '', '1', '0', '0', '10'),
('8113', '220000', '220100', '220104', '1', '1', '乐山镇', '0', '', '1', '0', '0', '10'),
('8114', '220000', '220100', '220104', '1', '1', '永春镇', '0', '', '1', '0', '0', '10'),
('8115', '220000', '220100', '220104', '1', '1', '双德乡（长春高新技术产业开发区）（国家级', '0', '', '1', '0', '0', '10'),
('8116', '220000', '220100', '220105', '1', '1', '东盛街道', '0', '', '1', '0', '0', '10'),
('8117', '220000', '220100', '220105', '1', '1', '吉林街道', '0', '', '1', '0', '0', '10'),
('8118', '220000', '220100', '220105', '1', '1', '荣光街道', '0', '', '1', '0', '0', '10'),
('8119', '220000', '220100', '220105', '1', '1', '东站街道', '0', '', '1', '0', '0', '10'),
('8120', '220000', '220100', '220105', '1', '1', '远达街道', '0', '', '1', '0', '0', '10'),
('8121', '220000', '220100', '220105', '1', '1', '八里堡街道', '0', '', '1', '0', '0', '10'),
('8122', '220000', '220100', '220105', '1', '1', '东方广场街道办事处（长春经济技术开发区）', '0', '', '1', '0', '0', '10'),
('8123', '220000', '220100', '220105', '1', '1', '英俊镇', '0', '', '1', '0', '0', '10'),
('8124', '220000', '220100', '220105', '1', '1', '劝农山镇', '0', '', '1', '0', '0', '10'),
('8125', '220000', '220100', '220105', '1', '1', '泉眼镇', '0', '', '1', '0', '0', '10'),
('8126', '220000', '220100', '220105', '1', '1', '龙嘉镇（东湖生态经济开发区）（省级）', '0', '', '1', '0', '0', '10'),
('8127', '220000', '220100', '220105', '1', '1', '卡伦湖镇（东湖生态经济开发区）（省级）', '0', '', '1', '0', '0', '10'),
('8128', '220000', '220100', '220105', '1', '1', '东湖镇（东湖生态经济开发区）（省级）', '0', '', '1', '0', '0', '10'),
('8129', '220000', '220100', '220105', '1', '1', '四家乡', '0', '', '1', '0', '0', '10'),
('8130', '220000', '220100', '220106', '1', '1', '正阳街道', '0', '', '1', '0', '0', '10'),
('8131', '220000', '220100', '220106', '1', '1', '普阳街道', '0', '', '1', '0', '0', '10'),
('8132', '220000', '220100', '220106', '1', '1', '春城街道', '0', '', '1', '0', '0', '10'),
('8133', '220000', '220100', '220106', '1', '1', '铁西街道', '0', '', '1', '0', '0', '10'),
('8134', '220000', '220100', '220106', '1', '1', '青年街道', '0', '', '1', '0', '0', '10'),
('8135', '220000', '220100', '220106', '1', '1', '锦程街道办事处（长春汽车产业开发区）（省', '0', '', '1', '0', '0', '10'),
('8136', '220000', '220100', '220106', '1', '1', '东风街道办事处（长春汽车产业开发区）（省', '0', '', '1', '0', '0', '10'),
('8137', '220000', '220100', '220106', '1', '1', '合心镇', '0', '', '1', '0', '0', '10'),
('8138', '220000', '220100', '220106', '1', '1', '西新镇', '0', '', '1', '0', '0', '10'),
('8139', '220000', '220100', '220106', '1', '1', '城西镇', '0', '', '1', '0', '0', '10'),
('8140', '220000', '220100', '220106', '1', '1', '长春汽车产业开发区（省级）', '0', '', '1', '0', '0', '10'),
('8141', '220000', '220100', '220106', '1', '1', '绿园经济开发区（省级）', '0', '', '1', '0', '0', '10'),
('8142', '220000', '220100', '220112', '1', '1', '云山街道', '0', '', '1', '0', '0', '10'),
('8143', '220000', '220100', '220112', '1', '1', '平湖街道', '0', '', '1', '0', '0', '10'),
('8144', '220000', '220100', '220112', '1', '1', '奢岭街道', '0', '', '1', '0', '0', '10'),
('8145', '220000', '220100', '220112', '1', '1', '山河街道', '0', '', '1', '0', '0', '10'),
('8146', '220000', '220100', '220112', '1', '1', '齐家镇', '0', '', '1', '0', '0', '10'),
('8147', '220000', '220100', '220112', '1', '1', '太平镇', '0', '', '1', '0', '0', '10'),
('8148', '220000', '220100', '220112', '1', '1', '鹿乡镇', '0', '', '1', '0', '0', '10'),
('8149', '220000', '220100', '220112', '1', '1', '双营乡（梅花鹿产业经济开发区）（省级）', '0', '', '1', '0', '0', '10'),
('8150', '220000', '220100', '220122', '1', '1', '农安镇', '0', '', '1', '0', '0', '10'),
('8151', '220000', '220100', '220122', '1', '1', '伏龙泉镇', '0', '', '1', '0', '0', '10'),
('8152', '220000', '220100', '220122', '1', '1', '哈拉海镇', '0', '', '1', '0', '0', '10'),
('8153', '220000', '220100', '220122', '1', '1', '靠山镇', '0', '', '1', '0', '0', '10'),
('8154', '220000', '220100', '220122', '1', '1', '开安镇', '0', '', '1', '0', '0', '10'),
('8155', '220000', '220100', '220122', '1', '1', '烧锅镇', '0', '', '1', '0', '0', '10'),
('8156', '220000', '220100', '220122', '1', '1', '高家店镇', '0', '', '1', '0', '0', '10'),
('8157', '220000', '220100', '220122', '1', '1', '华家镇', '0', '', '1', '0', '0', '10'),
('8158', '220000', '220100', '220122', '1', '1', '三盛玉镇', '0', '', '1', '0', '0', '10'),
('8159', '220000', '220100', '220122', '1', '1', '巴吉垒镇', '0', '', '1', '0', '0', '10'),
('8160', '220000', '220100', '220122', '1', '1', '前岗乡', '0', '', '1', '0', '0', '10'),
('8161', '220000', '220100', '220122', '1', '1', '龙王乡', '0', '', '1', '0', '0', '10'),
('8162', '220000', '220100', '220122', '1', '1', '三岗乡', '0', '', '1', '0', '0', '10'),
('8163', '220000', '220100', '220122', '1', '1', '万顺乡', '0', '', '1', '0', '0', '10'),
('8164', '220000', '220100', '220122', '1', '1', '杨树林乡', '0', '', '1', '0', '0', '10'),
('8165', '220000', '220100', '220122', '1', '1', '永安乡', '0', '', '1', '0', '0', '10'),
('8166', '220000', '220100', '220122', '1', '1', '青山口乡', '0', '', '1', '0', '0', '10'),
('8167', '220000', '220100', '220122', '1', '1', '黄鱼圈乡', '0', '', '1', '0', '0', '10'),
('8168', '220000', '220100', '220122', '1', '1', '新农乡', '0', '', '1', '0', '0', '10'),
('8169', '220000', '220100', '220122', '1', '1', '万金塔乡', '0', '', '1', '0', '0', '10'),
('8170', '220000', '220100', '220122', '1', '1', '小城子乡', '0', '', '1', '0', '0', '10'),
('8171', '220000', '220100', '220122', '1', '1', '洼中高农场', '0', '', '1', '0', '0', '10'),
('8172', '220000', '220100', '220181', '1', '1', '九台街道', '0', '', '1', '0', '0', '10'),
('8173', '220000', '220100', '220181', '1', '1', '营城街道', '0', '', '1', '0', '0', '10'),
('8174', '220000', '220100', '220181', '1', '1', '九郊街道', '0', '', '1', '0', '0', '10'),
('8175', '220000', '220100', '220181', '1', '1', '沐石河镇', '0', '', '1', '0', '0', '10'),
('8176', '220000', '220100', '220181', '1', '1', '城子街镇', '0', '', '1', '0', '0', '10'),
('8177', '220000', '220100', '220181', '1', '1', '其塔木镇', '0', '', '1', '0', '0', '10'),
('8178', '220000', '220100', '220181', '1', '1', '上河湾镇', '0', '', '1', '0', '0', '10'),
('8179', '220000', '220100', '220181', '1', '1', '西营城镇', '0', '', '1', '0', '0', '10'),
('8180', '220000', '220100', '220181', '1', '1', '土们岭镇', '0', '', '1', '0', '0', '10'),
('8181', '220000', '220100', '220181', '1', '1', '苇子沟镇', '0', '', '1', '0', '0', '10'),
('8182', '220000', '220100', '220181', '1', '1', '兴隆镇', '0', '', '1', '0', '0', '10'),
('8183', '220000', '220100', '220181', '1', '1', '纪家镇', '0', '', '1', '0', '0', '10'),
('8184', '220000', '220100', '220181', '1', '1', '波泥河镇', '0', '', '1', '0', '0', '10'),
('8185', '220000', '220100', '220181', '1', '1', '胡家回族乡', '0', '', '1', '0', '0', '10'),
('8186', '220000', '220100', '220181', '1', '1', '莽卡满族乡', '0', '', '1', '0', '0', '10'),
('8187', '220000', '220100', '220182', '1', '1', '华昌街道', '0', '', '1', '0', '0', '10'),
('8188', '220000', '220100', '220182', '1', '1', '正阳街道', '0', '', '1', '0', '0', '10'),
('8189', '220000', '220100', '220182', '1', '1', '培英街道', '0', '', '1', '0', '0', '10'),
('8190', '220000', '220100', '220182', '1', '1', '城郊街道', '0', '', '1', '0', '0', '10'),
('8191', '220000', '220100', '220182', '1', '1', '五棵树镇', '0', '', '1', '0', '0', '10'),
('8192', '220000', '220100', '220182', '1', '1', '弓棚镇', '0', '', '1', '0', '0', '10'),
('8193', '220000', '220100', '220182', '1', '1', '闵家镇', '0', '', '1', '0', '0', '10'),
('8194', '220000', '220100', '220182', '1', '1', '大坡镇', '0', '', '1', '0', '0', '10'),
('8195', '220000', '220100', '220182', '1', '1', '黑林镇', '0', '', '1', '0', '0', '10'),
('8196', '220000', '220100', '220182', '1', '1', '土桥镇', '0', '', '1', '0', '0', '10'),
('8197', '220000', '220100', '220182', '1', '1', '新立镇', '0', '', '1', '0', '0', '10'),
('8198', '220000', '220100', '220182', '1', '1', '大岭镇', '0', '', '1', '0', '0', '10'),
('8199', '220000', '220100', '220182', '1', '1', '向阳镇', '0', '', '1', '0', '0', '10'),
('8200', '220000', '220100', '220182', '1', '1', '泗河镇', '0', '', '1', '0', '0', '10'),
('8201', '220000', '220100', '220182', '1', '1', '八号镇', '0', '', '1', '0', '0', '10'),
('8202', '220000', '220100', '220182', '1', '1', '刘家镇', '0', '', '1', '0', '0', '10'),
('8203', '220000', '220100', '220182', '1', '1', '秀水镇', '0', '', '1', '0', '0', '10'),
('8204', '220000', '220100', '220182', '1', '1', '保寿镇', '0', '', '1', '0', '0', '10'),
('8205', '220000', '220100', '220182', '1', '1', '新庄镇', '0', '', '1', '0', '0', '10'),
('8206', '220000', '220100', '220182', '1', '1', '育民乡', '0', '', '1', '0', '0', '10'),
('8207', '220000', '220100', '220182', '1', '1', '红星乡', '0', '', '1', '0', '0', '10'),
('8208', '220000', '220100', '220182', '1', '1', '太安乡', '0', '', '1', '0', '0', '10'),
('8209', '220000', '220100', '220182', '1', '1', '先峰乡', '0', '', '1', '0', '0', '10'),
('8210', '220000', '220100', '220182', '1', '1', '青山乡', '0', '', '1', '0', '0', '10'),
('8211', '220000', '220100', '220182', '1', '1', '延和朝鲜族乡', '0', '', '1', '0', '0', '10'),
('8212', '220000', '220100', '220182', '1', '1', '恩育乡', '0', '', '1', '0', '0', '10'),
('8213', '220000', '220100', '220182', '1', '1', '城发乡', '0', '', '1', '0', '0', '10'),
('8214', '220000', '220100', '220182', '1', '1', '环城乡', '0', '', '1', '0', '0', '10'),
('8215', '220000', '220100', '220183', '1', '1', '胜利街道', '0', '', '1', '0', '0', '10'),
('8216', '220000', '220100', '220183', '1', '1', '建设街道', '0', '', '1', '0', '0', '10'),
('8217', '220000', '220100', '220183', '1', '1', '惠发街道', '0', '', '1', '0', '0', '10'),
('8218', '220000', '220100', '220183', '1', '1', '夏家店街道', '0', '', '1', '0', '0', '10'),
('8219', '220000', '220100', '220183', '1', '1', '大青嘴镇', '0', '', '1', '0', '0', '10'),
('8220', '220000', '220100', '220183', '1', '1', '郭家镇', '0', '', '1', '0', '0', '10'),
('8221', '220000', '220100', '220183', '1', '1', '松花江镇', '0', '', '1', '0', '0', '10'),
('8222', '220000', '220100', '220183', '1', '1', '达家沟镇', '0', '', '1', '0', '0', '10'),
('8223', '220000', '220100', '220183', '1', '1', '大房身镇', '0', '', '1', '0', '0', '10'),
('8224', '220000', '220100', '220183', '1', '1', '岔路口镇', '0', '', '1', '0', '0', '10'),
('8225', '220000', '220100', '220183', '1', '1', '朱城子镇', '0', '', '1', '0', '0', '10'),
('8226', '220000', '220100', '220183', '1', '1', '布海镇', '0', '', '1', '0', '0', '10'),
('8227', '220000', '220100', '220183', '1', '1', '天台镇', '0', '', '1', '0', '0', '10'),
('8228', '220000', '220100', '220183', '1', '1', '菜园子镇', '0', '', '1', '0', '0', '10'),
('8229', '220000', '220100', '220183', '1', '1', '同太乡', '0', '', '1', '0', '0', '10'),
('8230', '220000', '220100', '220183', '1', '1', '边岗乡', '0', '', '1', '0', '0', '10'),
('8231', '220000', '220100', '220183', '1', '1', '五台乡', '0', '', '1', '0', '0', '10'),
('8232', '220000', '220100', '220183', '1', '1', '朝阳乡', '0', '', '1', '0', '0', '10'),
('8233', '220000', '220200', '220202', '1', '1', '兴华街道', '0', '', '1', '0', '0', '10'),
('8234', '220000', '220200', '220202', '1', '1', '文庙街道', '0', '', '1', '0', '0', '10'),
('8235', '220000', '220200', '220202', '1', '1', '东局子街道', '0', '', '1', '0', '0', '10'),
('8236', '220000', '220200', '220202', '1', '1', '新地号街道', '0', '', '1', '0', '0', '10'),
('8237', '220000', '220200', '220202', '1', '1', '延安街道', '0', '', '1', '0', '0', '10'),
('8238', '220000', '220200', '220202', '1', '1', '站前街道', '0', '', '1', '0', '0', '10'),
('8239', '220000', '220200', '220202', '1', '1', '民主街道', '0', '', '1', '0', '0', '10'),
('8240', '220000', '220200', '220202', '1', '1', '莲花街道', '0', '', '1', '0', '0', '10'),
('8241', '220000', '220200', '220202', '1', '1', '通江街道', '0', '', '1', '0', '0', '10'),
('8242', '220000', '220200', '220202', '1', '1', '哈达湾街道', '0', '', '1', '0', '0', '10'),
('8243', '220000', '220200', '220202', '1', '1', '新建街道', '0', '', '1', '0', '0', '10'),
('8244', '220000', '220200', '220202', '1', '1', '延江街道', '0', '', '1', '0', '0', '10'),
('8245', '220000', '220200', '220202', '1', '1', '双吉街道', '0', '', '1', '0', '0', '10'),
('8246', '220000', '220200', '220202', '1', '1', '九站街道办事处(吉林经济技术开发区)（省', '0', '', '1', '0', '0', '10'),
('8247', '220000', '220200', '220202', '1', '1', '吉林东市商贸示范区（省级）', '0', '', '1', '0', '0', '10'),
('8248', '220000', '220200', '220202', '1', '1', '孤店子镇', '0', '', '1', '0', '0', '10'),
('8249', '220000', '220200', '220202', '1', '1', '桦皮厂镇', '0', '', '1', '0', '0', '10'),
('8250', '220000', '220200', '220202', '1', '1', '左家镇', '0', '', '1', '0', '0', '10'),
('8251', '220000', '220200', '220202', '1', '1', '两家子满族乡', '0', '', '1', '0', '0', '10'),
('8252', '220000', '220200', '220202', '1', '1', '土城子满族朝鲜族乡', '0', '', '1', '0', '0', '10'),
('8253', '220000', '220200', '220202', '1', '1', '吉林哈达湾工业开发区', '0', '', '1', '0', '0', '10'),
('8254', '220000', '220200', '220202', '1', '1', '吉林市昌邑区幸福经济管理区', '0', '', '1', '0', '0', '10'),
('8255', '220000', '220200', '220203', '1', '1', '龙华街道', '0', '', '1', '0', '0', '10'),
('8256', '220000', '220200', '220203', '1', '1', '湘潭街道', '0', '', '1', '0', '0', '10'),
('8257', '220000', '220200', '220203', '1', '1', '铁东街道', '0', '', '1', '0', '0', '10'),
('8258', '220000', '220200', '220203', '1', '1', '泡子沿街道', '0', '', '1', '0', '0', '10'),
('8259', '220000', '220200', '220203', '1', '1', '龙潭街道', '0', '', '1', '0', '0', '10'),
('8260', '220000', '220200', '220203', '1', '1', '新吉林街道', '0', '', '1', '0', '0', '10'),
('8261', '220000', '220200', '220203', '1', '1', '山前街道', '0', '', '1', '0', '0', '10'),
('8262', '220000', '220200', '220203', '1', '1', '新安街道', '0', '', '1', '0', '0', '10'),
('8263', '220000', '220200', '220203', '1', '1', '遵义街道', '0', '', '1', '0', '0', '10'),
('8264', '220000', '220200', '220203', '1', '1', '榆树街道', '0', '', '1', '0', '0', '10'),
('8265', '220000', '220200', '220203', '1', '1', '靠山街道', '0', '', '1', '0', '0', '10'),
('8266', '220000', '220200', '220203', '1', '1', '东城街道', '0', '', '1', '0', '0', '10'),
('8267', '220000', '220200', '220203', '1', '1', '承德街道', '0', '', '1', '0', '0', '10'),
('8268', '220000', '220200', '220203', '1', '1', '吉林龙潭经济开发区（省级）', '0', '', '1', '0', '0', '10'),
('8269', '220000', '220200', '220203', '1', '1', '乌拉街镇', '0', '', '1', '0', '0', '10'),
('8270', '220000', '220200', '220203', '1', '1', '缸窑镇', '0', '', '1', '0', '0', '10'),
('8271', '220000', '220200', '220203', '1', '1', '江密峰镇', '0', '', '1', '0', '0', '10'),
('8272', '220000', '220200', '220203', '1', '1', '大口钦镇', '0', '', '1', '0', '0', '10'),
('8273', '220000', '220200', '220203', '1', '1', '江北乡', '0', '', '1', '0', '0', '10'),
('8274', '220000', '220200', '220203', '1', '1', '金珠乡', '0', '', '1', '0', '0', '10'),
('8275', '220000', '220200', '220204', '1', '1', '德胜街道', '0', '', '1', '0', '0', '10'),
('8276', '220000', '220200', '220204', '1', '1', '南京街道', '0', '', '1', '0', '0', '10'),
('8277', '220000', '220200', '220204', '1', '1', '大东街道', '0', '', '1', '0', '0', '10'),
('8278', '220000', '220200', '220204', '1', '1', '青岛街道', '0', '', '1', '0', '0', '10'),
('8279', '220000', '220200', '220204', '1', '1', '向阳街道', '0', '', '1', '0', '0', '10'),
('8280', '220000', '220200', '220204', '1', '1', '北极街道', '0', '', '1', '0', '0', '10'),
('8281', '220000', '220200', '220204', '1', '1', '致和街道', '0', '', '1', '0', '0', '10'),
('8282', '220000', '220200', '220204', '1', '1', '长春路街道', '0', '', '1', '0', '0', '10'),
('8283', '220000', '220200', '220204', '1', '1', '临江街道', '0', '', '1', '0', '0', '10'),
('8284', '220000', '220200', '220204', '1', '1', '北山街道', '0', '', '1', '0', '0', '10'),
('8285', '220000', '220200', '220204', '1', '1', '黄旗屯街道', '0', '', '1', '0', '0', '10'),
('8286', '220000', '220200', '220204', '1', '1', '大绥河镇', '0', '', '1', '0', '0', '10'),
('8287', '220000', '220200', '220204', '1', '1', '搜登站镇', '0', '', '1', '0', '0', '10'),
('8288', '220000', '220200', '220204', '1', '1', '越北镇', '0', '', '1', '0', '0', '10'),
('8289', '220000', '220200', '220204', '1', '1', '欢喜乡', '0', '', '1', '0', '0', '10'),
('8290', '220000', '220200', '220211', '1', '1', '泰山街道', '0', '', '1', '0', '0', '10'),
('8291', '220000', '220200', '220211', '1', '1', '江南街道', '0', '', '1', '0', '0', '10'),
('8292', '220000', '220200', '220211', '1', '1', '石井街道', '0', '', '1', '0', '0', '10'),
('8293', '220000', '220200', '220211', '1', '1', '沿丰街道', '0', '', '1', '0', '0', '10'),
('8294', '220000', '220200', '220211', '1', '1', '丰满街道', '0', '', '1', '0', '0', '10'),
('8295', '220000', '220200', '220211', '1', '1', '高新开发区街道办事处（吉林高新技术产业开', '0', '', '1', '0', '0', '10'),
('8296', '220000', '220200', '220211', '1', '1', '红旗街道办事处（丰满经济开发区）（省级）', '0', '', '1', '0', '0', '10'),
('8297', '220000', '220200', '220211', '1', '1', '旺起镇', '0', '', '1', '0', '0', '10'),
('8298', '220000', '220200', '220211', '1', '1', '江南乡', '0', '', '1', '0', '0', '10'),
('8299', '220000', '220200', '220211', '1', '1', '前二道乡', '0', '', '1', '0', '0', '10'),
('8300', '220000', '220200', '220211', '1', '1', '小白山乡（丰满经济开发区）（省级）', '0', '', '1', '0', '0', '10'),
('8301', '220000', '220200', '220211', '1', '1', '朱雀山风景区', '0', '', '1', '0', '0', '10'),
('8302', '220000', '220200', '220221', '1', '1', '口前镇', '0', '', '1', '0', '0', '10'),
('8303', '220000', '220200', '220221', '1', '1', '双河镇', '0', '', '1', '0', '0', '10'),
('8304', '220000', '220200', '220221', '1', '1', '西阳镇', '0', '', '1', '0', '0', '10'),
('8305', '220000', '220200', '220221', '1', '1', '北大湖镇', '0', '', '1', '0', '0', '10'),
('8306', '220000', '220200', '220221', '1', '1', '一拉溪镇', '0', '', '1', '0', '0', '10'),
('8307', '220000', '220200', '220221', '1', '1', '岔路河镇（岔路河特色农业经济开发区）（省', '0', '', '1', '0', '0', '10'),
('8308', '220000', '220200', '220221', '1', '1', '万昌镇（岔路河特色农业经济开发区）（省级', '0', '', '1', '0', '0', '10'),
('8309', '220000', '220200', '220221', '1', '1', '永吉经济开发区（省级）', '0', '', '1', '0', '0', '10'),
('8310', '220000', '220200', '220221', '1', '1', '金家乡', '0', '', '1', '0', '0', '10'),
('8311', '220000', '220200', '220221', '1', '1', '黄榆乡', '0', '', '1', '0', '0', '10'),
('8312', '220000', '220200', '220281', '1', '1', '民主街道', '0', '', '1', '0', '0', '10'),
('8313', '220000', '220200', '220281', '1', '1', '长安街道', '0', '', '1', '0', '0', '10'),
('8314', '220000', '220200', '220281', '1', '1', '河南街道', '0', '', '1', '0', '0', '10'),
('8315', '220000', '220200', '220281', '1', '1', '奶子山街道', '0', '', '1', '0', '0', '10'),
('8316', '220000', '220200', '220281', '1', '1', '拉法街道', '0', '', '1', '0', '0', '10'),
('8317', '220000', '220200', '220281', '1', '1', '河北街道', '0', '', '1', '0', '0', '10'),
('8318', '220000', '220200', '220281', '1', '1', '新农街道', '0', '', '1', '0', '0', '10'),
('8319', '220000', '220200', '220281', '1', '1', '新站镇', '0', '', '1', '0', '0', '10'),
('8320', '220000', '220200', '220281', '1', '1', '天岗镇', '0', '', '1', '0', '0', '10'),
('8321', '220000', '220200', '220281', '1', '1', '白石山镇', '0', '', '1', '0', '0', '10'),
('8322', '220000', '220200', '220281', '1', '1', '漂河镇', '0', '', '1', '0', '0', '10'),
('8323', '220000', '220200', '220281', '1', '1', '黄松甸镇', '0', '', '1', '0', '0', '10'),
('8324', '220000', '220200', '220281', '1', '1', '天北镇', '0', '', '1', '0', '0', '10'),
('8325', '220000', '220200', '220281', '1', '1', '松江镇', '0', '', '1', '0', '0', '10'),
('8326', '220000', '220200', '220281', '1', '1', '庆岭镇', '0', '', '1', '0', '0', '10'),
('8327', '220000', '220200', '220281', '1', '1', '乌林朝鲜族乡', '0', '', '1', '0', '0', '10'),
('8328', '220000', '220200', '220281', '1', '1', '前进乡', '0', '', '1', '0', '0', '10'),
('8329', '220000', '220200', '220282', '1', '1', '明桦街道', '0', '', '1', '0', '0', '10'),
('8330', '220000', '220200', '220282', '1', '1', '永吉街道', '0', '', '1', '0', '0', '10'),
('8331', '220000', '220200', '220282', '1', '1', '胜利街道', '0', '', '1', '0', '0', '10'),
('8332', '220000', '220200', '220282', '1', '1', '新华街道', '0', '', '1', '0', '0', '10'),
('8333', '220000', '220200', '220282', '1', '1', '启新街道', '0', '', '1', '0', '0', '10'),
('8334', '220000', '220200', '220282', '1', '1', '桦甸经济开发区（省级）', '0', '', '1', '0', '0', '10'),
('8335', '220000', '220200', '220282', '1', '1', '夹皮沟镇', '0', '', '1', '0', '0', '10'),
('8336', '220000', '220200', '220282', '1', '1', '二道甸子镇', '0', '', '1', '0', '0', '10'),
('8337', '220000', '220200', '220282', '1', '1', '红石砬子镇', '0', '', '1', '0', '0', '10'),
('8338', '220000', '220200', '220282', '1', '1', '八道河子镇', '0', '', '1', '0', '0', '10'),
('8339', '220000', '220200', '220282', '1', '1', '常山镇', '0', '', '1', '0', '0', '10'),
('8340', '220000', '220200', '220282', '1', '1', '桦郊乡', '0', '', '1', '0', '0', '10'),
('8341', '220000', '220200', '220282', '1', '1', '横道河子乡', '0', '', '1', '0', '0', '10'),
('8342', '220000', '220200', '220282', '1', '1', '金沙乡', '0', '', '1', '0', '0', '10'),
('8343', '220000', '220200', '220282', '1', '1', '桦树林子乡', '0', '', '1', '0', '0', '10'),
('8344', '220000', '220200', '220282', '1', '1', '公吉乡', '0', '', '1', '0', '0', '10'),
('8345', '220000', '220200', '220282', '1', '1', '苏密沟乡', '0', '', '1', '0', '0', '10'),
('8346', '220000', '220200', '220283', '1', '1', '北城街道', '0', '', '1', '0', '0', '10'),
('8347', '220000', '220200', '220283', '1', '1', '南城街道', '0', '', '1', '0', '0', '10'),
('8348', '220000', '220200', '220283', '1', '1', '环城街道', '0', '', '1', '0', '0', '10'),
('8349', '220000', '220200', '220283', '1', '1', '吉舒街道', '0', '', '1', '0', '0', '10'),
('8350', '220000', '220200', '220283', '1', '1', '铁东街道', '0', '', '1', '0', '0', '10'),
('8351', '220000', '220200', '220283', '1', '1', '法特镇', '0', '', '1', '0', '0', '10'),
('8352', '220000', '220200', '220283', '1', '1', '白旗镇', '0', '', '1', '0', '0', '10'),
('8353', '220000', '220200', '220283', '1', '1', '溪河镇', '0', '', '1', '0', '0', '10'),
('8354', '220000', '220200', '220283', '1', '1', '朝阳镇', '0', '', '1', '0', '0', '10'),
('8355', '220000', '220200', '220283', '1', '1', '小城镇', '0', '', '1', '0', '0', '10'),
('8356', '220000', '220200', '220283', '1', '1', '上营镇', '0', '', '1', '0', '0', '10'),
('8357', '220000', '220200', '220283', '1', '1', '水曲柳镇', '0', '', '1', '0', '0', '10'),
('8358', '220000', '220200', '220283', '1', '1', '平安镇', '0', '', '1', '0', '0', '10'),
('8359', '220000', '220200', '220283', '1', '1', '金马镇', '0', '', '1', '0', '0', '10'),
('8360', '220000', '220200', '220283', '1', '1', '开原镇', '0', '', '1', '0', '0', '10'),
('8361', '220000', '220200', '220283', '1', '1', '莲花乡', '0', '', '1', '0', '0', '10'),
('8362', '220000', '220200', '220283', '1', '1', '亮甲山乡', '0', '', '1', '0', '0', '10'),
('8363', '220000', '220200', '220283', '1', '1', '新安乡', '0', '', '1', '0', '0', '10'),
('8364', '220000', '220200', '220283', '1', '1', '七里乡', '0', '', '1', '0', '0', '10'),
('8365', '220000', '220200', '220283', '1', '1', '天德乡', '0', '', '1', '0', '0', '10'),
('8366', '220000', '220200', '220284', '1', '1', '福安街道', '0', '', '1', '0', '0', '10'),
('8367', '220000', '220200', '220284', '1', '1', '东宁街道', '0', '', '1', '0', '0', '10'),
('8368', '220000', '220200', '220284', '1', '1', '河南街道', '0', '', '1', '0', '0', '10'),
('8369', '220000', '220200', '220284', '1', '1', '磐石经济开发区（省级）', '0', '', '1', '0', '0', '10'),
('8370', '220000', '220200', '220284', '1', '1', '烟筒山镇', '0', '', '1', '0', '0', '10'),
('8371', '220000', '220200', '220284', '1', '1', '红旗岭镇', '0', '', '1', '0', '0', '10'),
('8372', '220000', '220200', '220284', '1', '1', '明城镇', '0', '', '1', '0', '0', '10'),
('8373', '220000', '220200', '220284', '1', '1', '石嘴镇', '0', '', '1', '0', '0', '10'),
('8374', '220000', '220200', '220284', '1', '1', '驿马镇', '0', '', '1', '0', '0', '10'),
('8375', '220000', '220200', '220284', '1', '1', '牛心镇', '0', '', '1', '0', '0', '10'),
('8376', '220000', '220200', '220284', '1', '1', '呼兰镇', '0', '', '1', '0', '0', '10'),
('8377', '220000', '220200', '220284', '1', '1', '吉昌镇', '0', '', '1', '0', '0', '10'),
('8378', '220000', '220200', '220284', '1', '1', '松山镇', '0', '', '1', '0', '0', '10'),
('8379', '220000', '220200', '220284', '1', '1', '黑石镇', '0', '', '1', '0', '0', '10'),
('8380', '220000', '220200', '220284', '1', '1', '朝阳山镇', '0', '', '1', '0', '0', '10'),
('8381', '220000', '220200', '220284', '1', '1', '富太镇', '0', '', '1', '0', '0', '10'),
('8382', '220000', '220200', '220284', '1', '1', '取柴河镇', '0', '', '1', '0', '0', '10'),
('8383', '220000', '220200', '220284', '1', '1', '宝山乡', '0', '', '1', '0', '0', '10'),
('8384', '220000', '220300', '220302', '1', '1', '仁兴街道', '0', '', '1', '0', '0', '10'),
('8385', '220000', '220300', '220302', '1', '1', '英雄街道', '0', '', '1', '0', '0', '10'),
('8386', '220000', '220300', '220302', '1', '1', '站前街道', '0', '', '1', '0', '0', '10'),
('8387', '220000', '220300', '220302', '1', '1', '北沟街道', '0', '', '1', '0', '0', '10'),
('8388', '220000', '220300', '220302', '1', '1', '地直街道', '0', '', '1', '0', '0', '10'),
('8389', '220000', '220300', '220302', '1', '1', '红嘴高新技术开发区（省级）', '0', '', '1', '0', '0', '10'),
('8390', '220000', '220300', '220302', '1', '1', '平西乡', '0', '', '1', '0', '0', '10'),
('8391', '220000', '220300', '220303', '1', '1', '平东街道', '0', '', '1', '0', '0', '10'),
('8392', '220000', '220300', '220303', '1', '1', '北市场街道', '0', '', '1', '0', '0', '10'),
('8393', '220000', '220300', '220303', '1', '1', '七马路街道', '0', '', '1', '0', '0', '10'),
('8394', '220000', '220300', '220303', '1', '1', '四马路街道', '0', '', '1', '0', '0', '10'),
('8395', '220000', '220300', '220303', '1', '1', '解放街道', '0', '', '1', '0', '0', '10'),
('8396', '220000', '220300', '220303', '1', '1', '北门街道', '0', '', '1', '0', '0', '10'),
('8397', '220000', '220300', '220303', '1', '1', '黄土坑街道', '0', '', '1', '0', '0', '10'),
('8398', '220000', '220300', '220303', '1', '1', '平南街道', '0', '', '1', '0', '0', '10'),
('8399', '220000', '220300', '220303', '1', '1', '山门镇', '0', '', '1', '0', '0', '10'),
('8400', '220000', '220300', '220303', '1', '1', '石岭镇', '0', '', '1', '0', '0', '10'),
('8401', '220000', '220300', '220303', '1', '1', '叶赫满族镇', '0', '', '1', '0', '0', '10'),
('8402', '220000', '220300', '220303', '1', '1', '四平经济开发区（省级）', '0', '', '1', '0', '0', '10'),
('8403', '220000', '220300', '220303', '1', '1', '城东乡', '0', '', '1', '0', '0', '10'),
('8404', '220000', '220300', '220322', '1', '1', '梨树镇', '0', '', '1', '0', '0', '10'),
('8405', '220000', '220300', '220322', '1', '1', '郭家店镇', '0', '', '1', '0', '0', '10'),
('8406', '220000', '220300', '220322', '1', '1', '榆树台镇', '0', '', '1', '0', '0', '10'),
('8407', '220000', '220300', '220322', '1', '1', '孤家子镇（四平辽河农垦管理区）', '0', '', '1', '0', '0', '10'),
('8408', '220000', '220300', '220322', '1', '1', '小城子镇', '0', '', '1', '0', '0', '10'),
('8409', '220000', '220300', '220322', '1', '1', '喇嘛甸镇', '0', '', '1', '0', '0', '10'),
('8410', '220000', '220300', '220322', '1', '1', '蔡家镇', '0', '', '1', '0', '0', '10'),
('8411', '220000', '220300', '220322', '1', '1', '刘家馆子镇', '0', '', '1', '0', '0', '10'),
('8412', '220000', '220300', '220322', '1', '1', '十家堡镇', '0', '', '1', '0', '0', '10'),
('8413', '220000', '220300', '220322', '1', '1', '孟家岭镇', '0', '', '1', '0', '0', '10'),
('8414', '220000', '220300', '220322', '1', '1', '万发镇', '0', '', '1', '0', '0', '10'),
('8415', '220000', '220300', '220322', '1', '1', '东河镇', '0', '', '1', '0', '0', '10'),
('8416', '220000', '220300', '220322', '1', '1', '沈洋镇', '0', '', '1', '0', '0', '10'),
('8417', '220000', '220300', '220322', '1', '1', '林海镇', '0', '', '1', '0', '0', '10'),
('8418', '220000', '220300', '220322', '1', '1', '小宽镇', '0', '', '1', '0', '0', '10'),
('8419', '220000', '220300', '220322', '1', '1', '白山乡', '0', '', '1', '0', '0', '10'),
('8420', '220000', '220300', '220322', '1', '1', '泉眼岭乡', '0', '', '1', '0', '0', '10'),
('8421', '220000', '220300', '220322', '1', '1', '胜利乡', '0', '', '1', '0', '0', '10'),
('8422', '220000', '220300', '220322', '1', '1', '四棵树乡', '0', '', '1', '0', '0', '10'),
('8423', '220000', '220300', '220322', '1', '1', '双河乡', '0', '', '1', '0', '0', '10'),
('8424', '220000', '220300', '220322', '1', '1', '金山乡', '0', '', '1', '0', '0', '10'),
('8425', '220000', '220300', '220322', '1', '1', '国营梨树农场（四平辽河农垦管理区）', '0', '', '1', '0', '0', '10'),
('8426', '220000', '220300', '220322', '1', '1', '梨树经济开发区', '0', '', '1', '0', '0', '10'),
('8427', '220000', '220300', '220323', '1', '1', '伊通镇', '0', '', '1', '0', '0', '10'),
('8428', '220000', '220300', '220323', '1', '1', '二道镇', '0', '', '1', '0', '0', '10'),
('8429', '220000', '220300', '220323', '1', '1', '伊丹镇', '0', '', '1', '0', '0', '10'),
('8430', '220000', '220300', '220323', '1', '1', '马鞍镇', '0', '', '1', '0', '0', '10'),
('8431', '220000', '220300', '220323', '1', '1', '景台镇', '0', '', '1', '0', '0', '10'),
('8432', '220000', '220300', '220323', '1', '1', '靠山镇', '0', '', '1', '0', '0', '10'),
('8433', '220000', '220300', '220323', '1', '1', '大孤山镇', '0', '', '1', '0', '0', '10'),
('8434', '220000', '220300', '220323', '1', '1', '小孤山镇', '0', '', '1', '0', '0', '10'),
('8435', '220000', '220300', '220323', '1', '1', '营城子镇', '0', '', '1', '0', '0', '10'),
('8436', '220000', '220300', '220323', '1', '1', '西苇镇', '0', '', '1', '0', '0', '10'),
('8437', '220000', '220300', '220323', '1', '1', '河源镇', '0', '', '1', '0', '0', '10'),
('8438', '220000', '220300', '220323', '1', '1', '黄岭子镇', '0', '', '1', '0', '0', '10'),
('8439', '220000', '220300', '220323', '1', '1', '新兴乡', '0', '', '1', '0', '0', '10'),
('8440', '220000', '220300', '220323', '1', '1', '莫里乡', '0', '', '1', '0', '0', '10'),
('8441', '220000', '220300', '220323', '1', '1', '三道乡', '0', '', '1', '0', '0', '10'),
('8442', '220000', '220300', '220323', '1', '1', '伊通经济开发区', '0', '', '1', '0', '0', '10'),
('8443', '220000', '220300', '220381', '1', '1', '河南街道', '0', '', '1', '0', '0', '10'),
('8444', '220000', '220300', '220381', '1', '1', '河北街道', '0', '', '1', '0', '0', '10'),
('8445', '220000', '220300', '220381', '1', '1', '东三街道', '0', '', '1', '0', '0', '10'),
('8446', '220000', '220300', '220381', '1', '1', '岭东街道', '0', '', '1', '0', '0', '10'),
('8447', '220000', '220300', '220381', '1', '1', '铁北街道', '0', '', '1', '0', '0', '10'),
('8448', '220000', '220300', '220381', '1', '1', '岭西街道', '0', '', '1', '0', '0', '10'),
('8449', '220000', '220300', '220381', '1', '1', '刘房子街道', '0', '', '1', '0', '0', '10'),
('8450', '220000', '220300', '220381', '1', '1', '南崴子街道', '0', '', '1', '0', '0', '10'),
('8451', '220000', '220300', '220381', '1', '1', '环岭街道', '0', '', '1', '0', '0', '10'),
('8452', '220000', '220300', '220381', '1', '1', '苇子沟街道', '0', '', '1', '0', '0', '10'),
('8453', '220000', '220300', '220381', '1', '1', '二十家子镇', '0', '', '1', '0', '0', '10'),
('8454', '220000', '220300', '220381', '1', '1', '黑林子镇', '0', '', '1', '0', '0', '10'),
('8455', '220000', '220300', '220381', '1', '1', '陶家屯镇', '0', '', '1', '0', '0', '10'),
('8456', '220000', '220300', '220381', '1', '1', '范家屯镇', '0', '', '1', '0', '0', '10'),
('8457', '220000', '220300', '220381', '1', '1', '响水镇', '0', '', '1', '0', '0', '10'),
('8458', '220000', '220300', '220381', '1', '1', '大岭镇', '0', '', '1', '0', '0', '10'),
('8459', '220000', '220300', '220381', '1', '1', '怀德镇', '0', '', '1', '0', '0', '10'),
('8460', '220000', '220300', '220381', '1', '1', '双城堡镇', '0', '', '1', '0', '0', '10'),
('8461', '220000', '220300', '220381', '1', '1', '双龙镇', '0', '', '1', '0', '0', '10'),
('8462', '220000', '220300', '220381', '1', '1', '杨大城子镇', '0', '', '1', '0', '0', '10'),
('8463', '220000', '220300', '220381', '1', '1', '毛城子镇', '0', '', '1', '0', '0', '10'),
('8464', '220000', '220300', '220381', '1', '1', '玻璃城子镇', '0', '', '1', '0', '0', '10'),
('8465', '220000', '220300', '220381', '1', '1', '朝阳坡镇', '0', '', '1', '0', '0', '10'),
('8466', '220000', '220300', '220381', '1', '1', '大榆树镇', '0', '', '1', '0', '0', '10'),
('8467', '220000', '220300', '220381', '1', '1', '秦家屯镇', '0', '', '1', '0', '0', '10'),
('8468', '220000', '220300', '220381', '1', '1', '八屋镇', '0', '', '1', '0', '0', '10'),
('8469', '220000', '220300', '220381', '1', '1', '十屋镇', '0', '', '1', '0', '0', '10'),
('8470', '220000', '220300', '220381', '1', '1', '桑树台镇', '0', '', '1', '0', '0', '10'),
('8471', '220000', '220300', '220381', '1', '1', '龙山乡', '0', '', '1', '0', '0', '10'),
('8472', '220000', '220300', '220381', '1', '1', '永发乡', '0', '', '1', '0', '0', '10'),
('8473', '220000', '220300', '220382', '1', '1', '郑家屯街道', '0', '', '1', '0', '0', '10'),
('8474', '220000', '220300', '220382', '1', '1', '辽西街道', '0', '', '1', '0', '0', '10'),
('8475', '220000', '220300', '220382', '1', '1', '辽南街道', '0', '', '1', '0', '0', '10'),
('8476', '220000', '220300', '220382', '1', '1', '辽北街道', '0', '', '1', '0', '0', '10'),
('8477', '220000', '220300', '220382', '1', '1', '辽东街道', '0', '', '1', '0', '0', '10'),
('8478', '220000', '220300', '220382', '1', '1', '红旗街道', '0', '', '1', '0', '0', '10'),
('8479', '220000', '220300', '220382', '1', '1', '茂林镇', '0', '', '1', '0', '0', '10'),
('8480', '220000', '220300', '220382', '1', '1', '双山镇', '0', '', '1', '0', '0', '10'),
('8481', '220000', '220300', '220382', '1', '1', '卧虎镇', '0', '', '1', '0', '0', '10'),
('8482', '220000', '220300', '220382', '1', '1', '服先镇', '0', '', '1', '0', '0', '10'),
('8483', '220000', '220300', '220382', '1', '1', '王奔镇', '0', '', '1', '0', '0', '10'),
('8484', '220000', '220300', '220382', '1', '1', '玻璃山镇', '0', '', '1', '0', '0', '10'),
('8485', '220000', '220300', '220382', '1', '1', '兴隆镇', '0', '', '1', '0', '0', '10'),
('8486', '220000', '220300', '220382', '1', '1', '东明镇', '0', '', '1', '0', '0', '10'),
('8487', '220000', '220300', '220382', '1', '1', '那木乡', '0', '', '1', '0', '0', '10'),
('8488', '220000', '220300', '220382', '1', '1', '柳条乡', '0', '', '1', '0', '0', '10'),
('8489', '220000', '220300', '220382', '1', '1', '新立乡', '0', '', '1', '0', '0', '10'),
('8490', '220000', '220300', '220382', '1', '1', '永加乡', '0', '', '1', '0', '0', '10'),
('8491', '220000', '220300', '220382', '1', '1', '双辽农场（四平辽河农垦管理区）', '0', '', '1', '0', '0', '10'),
('8492', '220000', '220300', '220382', '1', '1', '双辽种羊场（四平辽河农垦管理区）', '0', '', '1', '0', '0', '10'),
('8493', '220000', '220300', '220382', '1', '1', '双辽经济开发区', '0', '', '1', '0', '0', '10'),
('8494', '220000', '220400', '220402', '1', '1', '南康街道', '0', '', '1', '0', '0', '10'),
('8495', '220000', '220400', '220402', '1', '1', '北寿街道', '0', '', '1', '0', '0', '10'),
('8496', '220000', '220400', '220402', '1', '1', '东吉街道', '0', '', '1', '0', '0', '10'),
('8497', '220000', '220400', '220402', '1', '1', '西宁街道', '0', '', '1', '0', '0', '10'),
('8498', '220000', '220400', '220402', '1', '1', '站前街道', '0', '', '1', '0', '0', '10'),
('8499', '220000', '220400', '220402', '1', '1', '新兴街道', '0', '', '1', '0', '0', '10'),
('8500', '220000', '220400', '220402', '1', '1', '福镇街道', '0', '', '1', '0', '0', '10'),
('8501', '220000', '220400', '220402', '1', '1', '向阳街道', '0', '', '1', '0', '0', '10'),
('8502', '220000', '220400', '220402', '1', '1', '辽源民营经济开发区（省级）', '0', '', '1', '0', '0', '10'),
('8503', '220000', '220400', '220402', '1', '1', '寿山镇', '0', '', '1', '0', '0', '10'),
('8504', '220000', '220400', '220402', '1', '1', '工农乡', '0', '', '1', '0', '0', '10'),
('8505', '220000', '220400', '220403', '1', '1', '仙城街道', '0', '', '1', '0', '0', '10'),
('8506', '220000', '220400', '220403', '1', '1', '太安街道', '0', '', '1', '0', '0', '10'),
('8507', '220000', '220400', '220403', '1', '1', '东山街道', '0', '', '1', '0', '0', '10'),
('8508', '220000', '220400', '220403', '1', '1', '安家街道', '0', '', '1', '0', '0', '10'),
('8509', '220000', '220400', '220403', '1', '1', '先锋街道', '0', '', '1', '0', '0', '10'),
('8510', '220000', '220400', '220403', '1', '1', '富国街道', '0', '', '1', '0', '0', '10'),
('8511', '220000', '220400', '220403', '1', '1', '灯塔乡', '0', '', '1', '0', '0', '10'),
('8512', '220000', '220400', '220421', '1', '1', '东丰镇', '0', '', '1', '0', '0', '10'),
('8513', '220000', '220400', '220421', '1', '1', '大阳镇', '0', '', '1', '0', '0', '10'),
('8514', '220000', '220400', '220421', '1', '1', '横道河镇', '0', '', '1', '0', '0', '10'),
('8515', '220000', '220400', '220421', '1', '1', '那丹伯镇', '0', '', '1', '0', '0', '10'),
('8516', '220000', '220400', '220421', '1', '1', '猴石镇', '0', '', '1', '0', '0', '10'),
('8517', '220000', '220400', '220421', '1', '1', '杨木林镇', '0', '', '1', '0', '0', '10'),
('8518', '220000', '220400', '220421', '1', '1', '小四平镇', '0', '', '1', '0', '0', '10'),
('8519', '220000', '220400', '220421', '1', '1', '黄河镇', '0', '', '1', '0', '0', '10'),
('8520', '220000', '220400', '220421', '1', '1', '拉拉河镇', '0', '', '1', '0', '0', '10'),
('8521', '220000', '220400', '220421', '1', '1', '沙河镇', '0', '', '1', '0', '0', '10'),
('8522', '220000', '220400', '220421', '1', '1', '南屯基镇', '0', '', '1', '0', '0', '10'),
('8523', '220000', '220400', '220421', '1', '1', '大兴镇', '0', '', '1', '0', '0', '10'),
('8524', '220000', '220400', '220421', '1', '1', '三合满族朝鲜族乡', '0', '', '1', '0', '0', '10'),
('8525', '220000', '220400', '220421', '1', '1', '二龙山乡', '0', '', '1', '0', '0', '10'),
('8526', '220000', '220400', '220422', '1', '1', '白泉镇', '0', '', '1', '0', '0', '10'),
('8527', '220000', '220400', '220422', '1', '1', '渭津镇', '0', '', '1', '0', '0', '10'),
('8528', '220000', '220400', '220422', '1', '1', '安石镇', '0', '', '1', '0', '0', '10'),
('8529', '220000', '220400', '220422', '1', '1', '辽河源镇', '0', '', '1', '0', '0', '10'),
('8530', '220000', '220400', '220422', '1', '1', '泉太镇', '0', '', '1', '0', '0', '10'),
('8531', '220000', '220400', '220422', '1', '1', '建安镇', '0', '', '1', '0', '0', '10'),
('8532', '220000', '220400', '220422', '1', '1', '安恕镇', '0', '', '1', '0', '0', '10'),
('8533', '220000', '220400', '220422', '1', '1', '平岗镇', '0', '', '1', '0', '0', '10'),
('8534', '220000', '220400', '220422', '1', '1', '云顶镇', '0', '', '1', '0', '0', '10'),
('8535', '220000', '220400', '220422', '1', '1', '凌云乡', '0', '', '1', '0', '0', '10'),
('8536', '220000', '220400', '220422', '1', '1', '甲山乡', '0', '', '1', '0', '0', '10'),
('8537', '220000', '220400', '220422', '1', '1', '足民乡', '0', '', '1', '0', '0', '10'),
('8538', '220000', '220400', '220422', '1', '1', '金洲乡', '0', '', '1', '0', '0', '10'),
('8539', '220000', '220500', '220502', '1', '1', '东昌街道', '0', '', '1', '0', '0', '10'),
('8540', '220000', '220500', '220502', '1', '1', '民主街道', '0', '', '1', '0', '0', '10'),
('8541', '220000', '220500', '220502', '1', '1', '老站街道', '0', '', '1', '0', '0', '10'),
('8542', '220000', '220500', '220502', '1', '1', '团结街道', '0', '', '1', '0', '0', '10'),
('8543', '220000', '220500', '220502', '1', '1', '新站街道', '0', '', '1', '0', '0', '10'),
('8544', '220000', '220500', '220502', '1', '1', '光明街道', '0', '', '1', '0', '0', '10'),
('8545', '220000', '220500', '220502', '1', '1', '龙泉街道', '0', '', '1', '0', '0', '10'),
('8546', '220000', '220500', '220502', '1', '1', '金厂镇', '0', '', '1', '0', '0', '10'),
('8547', '220000', '220500', '220502', '1', '1', '环通乡', '0', '', '1', '0', '0', '10'),
('8548', '220000', '220500', '220502', '1', '1', '江东乡', '0', '', '1', '0', '0', '10'),
('8549', '220000', '220500', '220502', '1', '1', '通化市经济开发区管委会', '0', '', '1', '0', '0', '10'),
('8550', '220000', '220500', '220503', '1', '1', '桃园街道', '0', '', '1', '0', '0', '10'),
('8551', '220000', '220500', '220503', '1', '1', '东通化街道', '0', '', '1', '0', '0', '10');
INSERT INTO `wst_communitys` VALUES ('8552', '220000', '220500', '220503', '1', '1', '鸭园镇', '0', '', '1', '0', '0', '10'),
('8553', '220000', '220500', '220503', '1', '1', '铁厂镇', '0', '', '1', '0', '0', '10'),
('8554', '220000', '220500', '220503', '1', '1', '五道江镇', '0', '', '1', '0', '0', '10'),
('8555', '220000', '220500', '220503', '1', '1', '二道江乡', '0', '', '1', '0', '0', '10'),
('8556', '220000', '220500', '220521', '1', '1', '快大茂镇', '0', '', '1', '0', '0', '10'),
('8557', '220000', '220500', '220521', '1', '1', '二密镇', '0', '', '1', '0', '0', '10'),
('8558', '220000', '220500', '220521', '1', '1', '果松镇', '0', '', '1', '0', '0', '10'),
('8559', '220000', '220500', '220521', '1', '1', '石湖镇', '0', '', '1', '0', '0', '10'),
('8560', '220000', '220500', '220521', '1', '1', '大安镇', '0', '', '1', '0', '0', '10'),
('8561', '220000', '220500', '220521', '1', '1', '光华镇', '0', '', '1', '0', '0', '10'),
('8562', '220000', '220500', '220521', '1', '1', '兴林镇', '0', '', '1', '0', '0', '10'),
('8563', '220000', '220500', '220521', '1', '1', '英额布镇', '0', '', '1', '0', '0', '10'),
('8564', '220000', '220500', '220521', '1', '1', '三棵榆树镇', '0', '', '1', '0', '0', '10'),
('8565', '220000', '220500', '220521', '1', '1', '江甸镇', '0', '', '1', '0', '0', '10'),
('8566', '220000', '220500', '220521', '1', '1', '富江乡', '0', '', '1', '0', '0', '10'),
('8567', '220000', '220500', '220521', '1', '1', '四棚乡', '0', '', '1', '0', '0', '10'),
('8568', '220000', '220500', '220521', '1', '1', '东来乡', '0', '', '1', '0', '0', '10'),
('8569', '220000', '220500', '220521', '1', '1', '大泉源满族朝鲜族乡', '0', '', '1', '0', '0', '10'),
('8570', '220000', '220500', '220521', '1', '1', '金斗朝鲜族满族乡', '0', '', '1', '0', '0', '10'),
('8571', '220000', '220500', '220521', '1', '1', '通化县工业集中区', '0', '', '1', '0', '0', '10'),
('8572', '220000', '220500', '220521', '1', '1', '东宝新村', '0', '', '1', '0', '0', '10'),
('8573', '220000', '220500', '220523', '1', '1', '朝阳镇', '0', '', '1', '0', '0', '10'),
('8574', '220000', '220500', '220523', '1', '1', '辉南镇', '0', '', '1', '0', '0', '10'),
('8575', '220000', '220500', '220523', '1', '1', '样子哨镇', '0', '', '1', '0', '0', '10'),
('8576', '220000', '220500', '220523', '1', '1', '杉松岗镇', '0', '', '1', '0', '0', '10'),
('8577', '220000', '220500', '220523', '1', '1', '石道河镇', '0', '', '1', '0', '0', '10'),
('8578', '220000', '220500', '220523', '1', '1', '辉发城镇', '0', '', '1', '0', '0', '10'),
('8579', '220000', '220500', '220523', '1', '1', '抚民镇', '0', '', '1', '0', '0', '10'),
('8580', '220000', '220500', '220523', '1', '1', '金川镇', '0', '', '1', '0', '0', '10'),
('8581', '220000', '220500', '220523', '1', '1', '团林镇', '0', '', '1', '0', '0', '10'),
('8582', '220000', '220500', '220523', '1', '1', '庆阳镇', '0', '', '1', '0', '0', '10'),
('8583', '220000', '220500', '220523', '1', '1', '楼街朝鲜族乡', '0', '', '1', '0', '0', '10'),
('8584', '220000', '220500', '220524', '1', '1', '柳河镇', '0', '', '1', '0', '0', '10'),
('8585', '220000', '220500', '220524', '1', '1', '三源浦朝鲜族镇', '0', '', '1', '0', '0', '10'),
('8586', '220000', '220500', '220524', '1', '1', '五道沟镇', '0', '', '1', '0', '0', '10'),
('8587', '220000', '220500', '220524', '1', '1', '驼腰岭镇', '0', '', '1', '0', '0', '10'),
('8588', '220000', '220500', '220524', '1', '1', '孤山子镇', '0', '', '1', '0', '0', '10'),
('8589', '220000', '220500', '220524', '1', '1', '圣水河子镇', '0', '', '1', '0', '0', '10'),
('8590', '220000', '220500', '220524', '1', '1', '罗通山镇', '0', '', '1', '0', '0', '10'),
('8591', '220000', '220500', '220524', '1', '1', '安口镇', '0', '', '1', '0', '0', '10'),
('8592', '220000', '220500', '220524', '1', '1', '向阳镇', '0', '', '1', '0', '0', '10'),
('8593', '220000', '220500', '220524', '1', '1', '红石镇', '0', '', '1', '0', '0', '10'),
('8594', '220000', '220500', '220524', '1', '1', '凉水河子镇', '0', '', '1', '0', '0', '10'),
('8595', '220000', '220500', '220524', '1', '1', '亨通镇', '0', '', '1', '0', '0', '10'),
('8596', '220000', '220500', '220524', '1', '1', '柳南乡', '0', '', '1', '0', '0', '10'),
('8597', '220000', '220500', '220524', '1', '1', '时家店乡', '0', '', '1', '0', '0', '10'),
('8598', '220000', '220500', '220524', '1', '1', '姜家店朝鲜族乡', '0', '', '1', '0', '0', '10'),
('8599', '220000', '220500', '220581', '1', '1', '新华街道', '0', '', '1', '0', '0', '10'),
('8600', '220000', '220500', '220581', '1', '1', '光明街道', '0', '', '1', '0', '0', '10'),
('8601', '220000', '220500', '220581', '1', '1', '和平街道办事处（梅河口市经济贸易开发区）', '0', '', '1', '0', '0', '10'),
('8602', '220000', '220500', '220581', '1', '1', '解放街道办事处（梅河口市经济贸易开发区）', '0', '', '1', '0', '0', '10'),
('8603', '220000', '220500', '220581', '1', '1', '福民街道办事处（梅河口市经济贸易开发区）', '0', '', '1', '0', '0', '10'),
('8604', '220000', '220500', '220581', '1', '1', '山城镇', '0', '', '1', '0', '0', '10'),
('8605', '220000', '220500', '220581', '1', '1', '红梅镇', '0', '', '1', '0', '0', '10'),
('8606', '220000', '220500', '220581', '1', '1', '海龙镇', '0', '', '1', '0', '0', '10'),
('8607', '220000', '220500', '220581', '1', '1', '新合镇', '0', '', '1', '0', '0', '10'),
('8608', '220000', '220500', '220581', '1', '1', '曙光镇', '0', '', '1', '0', '0', '10'),
('8609', '220000', '220500', '220581', '1', '1', '中和镇', '0', '', '1', '0', '0', '10'),
('8610', '220000', '220500', '220581', '1', '1', '黑山头镇', '0', '', '1', '0', '0', '10'),
('8611', '220000', '220500', '220581', '1', '1', '水道镇', '0', '', '1', '0', '0', '10'),
('8612', '220000', '220500', '220581', '1', '1', '进化镇', '0', '', '1', '0', '0', '10'),
('8613', '220000', '220500', '220581', '1', '1', '一座营镇', '0', '', '1', '0', '0', '10'),
('8614', '220000', '220500', '220581', '1', '1', '康大营镇', '0', '', '1', '0', '0', '10'),
('8615', '220000', '220500', '220581', '1', '1', '牛心顶镇', '0', '', '1', '0', '0', '10'),
('8616', '220000', '220500', '220581', '1', '1', '杏岭乡', '0', '', '1', '0', '0', '10'),
('8617', '220000', '220500', '220581', '1', '1', '李炉乡', '0', '', '1', '0', '0', '10'),
('8618', '220000', '220500', '220581', '1', '1', '湾龙乡', '0', '', '1', '0', '0', '10'),
('8619', '220000', '220500', '220581', '1', '1', '双兴乡', '0', '', '1', '0', '0', '10'),
('8620', '220000', '220500', '220581', '1', '1', '兴华乡', '0', '', '1', '0', '0', '10'),
('8621', '220000', '220500', '220581', '1', '1', '小杨满族朝鲜族乡', '0', '', '1', '0', '0', '10');
INSERT INTO `wst_communitys` VALUES ('8622', '220000', '220500', '220581', '1', '1', '吉乐乡', '0', '', '1', '0', '0', '10'),
('8623', '220000', '220500', '220582', '1', '1', '团结街道', '0', '', '1', '0', '0', '10'),
('8624', '220000', '220500', '220582', '1', '1', '黎明街道', '0', '', '1', '0', '0', '10'),
('8625', '220000', '220500', '220582', '1', '1', '通胜街道', '0', '', '1', '0', '0', '10'),
('8626', '220000', '220500', '220582', '1', '1', '青石镇', '0', '', '1', '0', '0', '10'),
('8627', '220000', '220500', '220582', '1', '1', '榆林镇', '0', '', '1', '0', '0', '10'),
('8628', '220000', '220500', '220582', '1', '1', '花甸镇', '0', '', '1', '0', '0', '10'),
('8629', '220000', '220500', '220582', '1', '1', '头道镇', '0', '', '1', '0', '0', '10'),
('8630', '220000', '220500', '220582', '1', '1', '清河镇', '0', '', '1', '0', '0', '10'),
('8631', '220000', '220500', '220582', '1', '1', '台上镇', '0', '', '1', '0', '0', '10'),
('8632', '220000', '220500', '220582', '1', '1', '财源镇', '0', '', '1', '0', '0', '10'),
('8633', '220000', '220500', '220582', '1', '1', '大路镇', '0', '', '1', '0', '0', '10'),
('8634', '220000', '220500', '220582', '1', '1', '太王镇', '0', '', '1', '0', '0', '10'),
('8635', '220000', '220500', '220582', '1', '1', '麻线乡', '0', '', '1', '0', '0', '10'),
('8636', '220000', '220500', '220582', '1', '1', '凉水朝鲜族乡', '0', '', '1', '0', '0', '10'),
('8637', '220000', '220600', '220602', '1', '1', '新建街道', '0', '', '1', '0', '0', '10'),
('8638', '220000', '220600', '220602', '1', '1', '通沟街道', '0', '', '1', '0', '0', '10'),
('8639', '220000', '220600', '220602', '1', '1', '东兴街道', '0', '', '1', '0', '0', '10'),
('8640', '220000', '220600', '220602', '1', '1', '红旗街道', '0', '', '1', '0', '0', '10'),
('8641', '220000', '220600', '220602', '1', '1', '城南街道', '0', '', '1', '0', '0', '10'),
('8642', '220000', '220600', '220602', '1', '1', '江北街道', '0', '', '1', '0', '0', '10'),
('8643', '220000', '220600', '220602', '1', '1', '河口街道', '0', '', '1', '0', '0', '10'),
('8644', '220000', '220600', '220602', '1', '1', '板石街道', '0', '', '1', '0', '0', '10'),
('8645', '220000', '220600', '220602', '1', '1', '七道江镇', '0', '', '1', '0', '0', '10'),
('8646', '220000', '220600', '220602', '1', '1', '六道江镇', '0', '', '1', '0', '0', '10'),
('8647', '220000', '220600', '220602', '1', '1', '红土崖镇', '0', '', '1', '0', '0', '10'),
('8648', '220000', '220600', '220602', '1', '1', '三道沟镇', '0', '', '1', '0', '0', '10'),
('8649', '220000', '220600', '220604', '1', '1', '孙家堡子镇', '0', '', '1', '0', '0', '10'),
('8650', '220000', '220600', '220604', '1', '1', '三岔子镇', '0', '', '1', '0', '0', '10'),
('8651', '220000', '220600', '220604', '1', '1', '湾沟镇', '0', '', '1', '0', '0', '10'),
('8652', '220000', '220600', '220604', '1', '1', '松树镇', '0', '', '1', '0', '0', '10'),
('8653', '220000', '220600', '220604', '1', '1', '砟子镇', '0', '', '1', '0', '0', '10');
INSERT INTO `wst_communitys` VALUES ('8654', '220000', '220600', '220604', '1', '1', '石人镇', '0', '', '1', '0', '0', '10'),
('8655', '220000', '220600', '220604', '1', '1', '大阳岔镇', '0', '', '1', '0', '0', '10'),
('8656', '220000', '220600', '220604', '1', '1', '大石人镇', '0', '', '1', '0', '0', '10'),
('8657', '220000', '220600', '220621', '1', '1', '抚松镇', '0', '', '1', '0', '0', '10'),
('8658', '220000', '220600', '220621', '1', '1', '松江河镇', '0', '', '1', '0', '0', '10'),
('8659', '220000', '220600', '220621', '1', '1', '泉阳镇', '0', '', '1', '0', '0', '10'),
('8660', '220000', '220600', '220621', '1', '1', '露水河镇', '0', '', '1', '0', '0', '10'),
('8661', '220000', '220600', '220621', '1', '1', '仙人桥镇', '0', '', '1', '0', '0', '10'),
('8662', '220000', '220600', '220621', '1', '1', '万良镇', '0', '', '1', '0', '0', '10'),
('8663', '220000', '220600', '220621', '1', '1', '新屯子镇', '0', '', '1', '0', '0', '10'),
('8664', '220000', '220600', '220621', '1', '1', '东岗镇', '0', '', '1', '0', '0', '10'),
('8665', '220000', '220600', '220621', '1', '1', '漫江镇', '0', '', '1', '0', '0', '10'),
('8666', '220000', '220600', '220621', '1', '1', '北岗镇', '0', '', '1', '0', '0', '10'),
('8667', '220000', '220600', '220621', '1', '1', '兴参镇', '0', '', '1', '0', '0', '10'),
('8668', '220000', '220600', '220621', '1', '1', '兴隆乡', '0', '', '1', '0', '0', '10'),
('8669', '220000', '220600', '220621', '1', '1', '抽水乡', '0', '', '1', '0', '0', '10'),
('8670', '220000', '220600', '220621', '1', '1', '沿江乡', '0', '', '1', '0', '0', '10'),
('8671', '220000', '220600', '220622', '1', '1', '靖宇镇', '0', '', '1', '0', '0', '10'),
('8672', '220000', '220600', '220622', '1', '1', '三道湖镇', '0', '', '1', '0', '0', '10'),
('8673', '220000', '220600', '220622', '1', '1', '龙泉镇', '0', '', '1', '0', '0', '10'),
('8674', '220000', '220600', '220622', '1', '1', '那尔轰镇', '0', '', '1', '0', '0', '10'),
('8675', '220000', '220600', '220622', '1', '1', '花园口镇', '0', '', '1', '0', '0', '10'),
('8676', '220000', '220600', '220622', '1', '1', '景山镇', '0', '', '1', '0', '0', '10'),
('8677', '220000', '220600', '220622', '1', '1', '赤松乡', '0', '', '1', '0', '0', '10'),
('8678', '220000', '220600', '220622', '1', '1', '蒙江乡', '0', '', '1', '0', '0', '10'),
('8679', '220000', '220600', '220623', '1', '1', '长白镇', '0', '', '1', '0', '0', '10'),
('8680', '220000', '220600', '220623', '1', '1', '八道沟镇', '0', '', '1', '0', '0', '10'),
('8681', '220000', '220600', '220623', '1', '1', '十四道沟镇', '0', '', '1', '0', '0', '10'),
('8682', '220000', '220600', '220623', '1', '1', '马鹿沟镇', '0', '', '1', '0', '0', '10'),
('8683', '220000', '220600', '220623', '1', '1', '宝泉山镇', '0', '', '1', '0', '0', '10'),
('8684', '220000', '220600', '220623', '1', '1', '新房子镇', '0', '', '1', '0', '0', '10'),
('8685', '220000', '220600', '220623', '1', '1', '金华乡', '0', '', '1', '0', '0', '10'),
('8686', '220000', '220600', '220623', '1', '1', '十二道沟乡', '0', '', '1', '0', '0', '10'),
('8687', '220000', '220600', '220623', '1', '1', '长白县南坡旅游开发区（长白山保护开发区管', '0', '', '1', '0', '0', '10'),
('8688', '220000', '220600', '220681', '1', '1', '建国街道', '0', '', '1', '0', '0', '10'),
('8689', '220000', '220600', '220681', '1', '1', '新市街道', '0', '', '1', '0', '0', '10'),
('8690', '220000', '220600', '220681', '1', '1', '兴隆街道', '0', '', '1', '0', '0', '10'),
('8691', '220000', '220600', '220681', '1', '1', '大湖街道', '0', '', '1', '0', '0', '10'),
('8692', '220000', '220600', '220681', '1', '1', '森工街道', '0', '', '1', '0', '0', '10'),
('8693', '220000', '220600', '220681', '1', '1', '大栗子街道', '0', '', '1', '0', '0', '10'),
('8694', '220000', '220600', '220681', '1', '1', '桦树镇', '0', '', '1', '0', '0', '10'),
('8695', '220000', '220600', '220681', '1', '1', '六道沟镇', '0', '', '1', '0', '0', '10'),
('8696', '220000', '220600', '220681', '1', '1', '苇沙河镇', '0', '', '1', '0', '0', '10'),
('8697', '220000', '220600', '220681', '1', '1', '花山镇', '0', '', '1', '0', '0', '10'),
('8698', '220000', '220600', '220681', '1', '1', '闹枝镇', '0', '', '1', '0', '0', '10'),
('8699', '220000', '220600', '220681', '1', '1', '四道沟镇', '0', '', '1', '0', '0', '10'),
('8700', '220000', '220600', '220681', '1', '1', '蚂蚁河乡', '0', '', '1', '0', '0', '10'),
('8701', '220000', '220700', '220702', '1', '1', '团结街道', '0', '', '1', '0', '0', '10'),
('8702', '220000', '220700', '220702', '1', '1', '文化街道', '0', '', '1', '0', '0', '10'),
('8703', '220000', '220700', '220702', '1', '1', '民主街道', '0', '', '1', '0', '0', '10'),
('8704', '220000', '220700', '220702', '1', '1', '临江街道', '0', '', '1', '0', '0', '10'),
('8705', '220000', '220700', '220702', '1', '1', '新区街道', '0', '', '1', '0', '0', '10'),
('8706', '220000', '220700', '220702', '1', '1', '前进街道', '0', '', '1', '0', '0', '10'),
('8707', '220000', '220700', '220702', '1', '1', '和平街道', '0', '', '1', '0', '0', '10'),
('8708', '220000', '220700', '220702', '1', '1', '工农街道', '0', '', '1', '0', '0', '10'),
('8709', '220000', '220700', '220702', '1', '1', '沿江街道', '0', '', '1', '0', '0', '10'),
('8710', '220000', '220700', '220702', '1', '1', '铁西街道', '0', '', '1', '0', '0', '10'),
('8711', '220000', '220700', '220702', '1', '1', '繁荣街道', '0', '', '1', '0', '0', '10'),
('8712', '220000', '220700', '220702', '1', '1', '建设街道', '0', '', '1', '0', '0', '10'),
('8713', '220000', '220700', '220702', '1', '1', '石化街道', '0', '', '1', '0', '0', '10'),
('8714', '220000', '220700', '220702', '1', '1', '大洼镇', '0', '', '1', '0', '0', '10'),
('8715', '220000', '220700', '220702', '1', '1', '善友镇', '0', '', '1', '0', '0', '10'),
('8716', '220000', '220700', '220702', '1', '1', '毛都站镇', '0', '', '1', '0', '0', '10'),
('8717', '220000', '220700', '220702', '1', '1', '伯都纳镇', '0', '', '1', '0', '0', '10'),
('8718', '220000', '220700', '220702', '1', '1', '新城乡', '0', '', '1', '0', '0', '10'),
('8719', '220000', '220700', '220702', '1', '1', '兴原乡', '0', '', '1', '0', '0', '10'),
('8720', '220000', '220700', '220702', '1', '1', '华侨农场', '0', '', '1', '0', '0', '10'),
('8721', '220000', '220700', '220721', '1', '1', '前郭尔罗斯镇', '0', '', '1', '0', '0', '10'),
('8722', '220000', '220700', '220721', '1', '1', '长山镇', '0', '', '1', '0', '0', '10'),
('8723', '220000', '220700', '220721', '1', '1', '海渤日戈镇', '0', '', '1', '0', '0', '10'),
('8724', '220000', '220700', '220721', '1', '1', '乌兰图嘎镇', '0', '', '1', '0', '0', '10'),
('8725', '220000', '220700', '220721', '1', '1', '查干花镇', '0', '', '1', '0', '0', '10'),
('8726', '220000', '220700', '220721', '1', '1', '王府站镇', '0', '', '1', '0', '0', '10'),
('8727', '220000', '220700', '220721', '1', '1', '八郎镇', '0', '', '1', '0', '0', '10'),
('8728', '220000', '220700', '220721', '1', '1', '哈拉毛都镇', '0', '', '1', '0', '0', '10'),
('8729', '220000', '220700', '220721', '1', '1', '宝甸乡', '0', '', '1', '0', '0', '10'),
('8730', '220000', '220700', '220721', '1', '1', '平凤乡', '0', '', '1', '0', '0', '10'),
('8731', '220000', '220700', '220721', '1', '1', '蒙古艾里乡', '0', '', '1', '0', '0', '10'),
('8732', '220000', '220700', '220721', '1', '1', '达里巴乡', '0', '', '1', '0', '0', '10'),
('8733', '220000', '220700', '220721', '1', '1', '吉拉吐乡', '0', '', '1', '0', '0', '10'),
('8734', '220000', '220700', '220721', '1', '1', '白依拉嘎乡', '0', '', '1', '0', '0', '10'),
('8735', '220000', '220700', '220721', '1', '1', '洪泉乡', '0', '', '1', '0', '0', '10'),
('8736', '220000', '220700', '220721', '1', '1', '额如乡', '0', '', '1', '0', '0', '10'),
('8737', '220000', '220700', '220721', '1', '1', '套浩太乡', '0', '', '1', '0', '0', '10'),
('8738', '220000', '220700', '220721', '1', '1', '长龙乡', '0', '', '1', '0', '0', '10'),
('8739', '220000', '220700', '220721', '1', '1', '乌兰塔拉乡', '0', '', '1', '0', '0', '10'),
('8740', '220000', '220700', '220721', '1', '1', '东三家子乡', '0', '', '1', '0', '0', '10'),
('8741', '220000', '220700', '220721', '1', '1', '浩特芒哈乡', '0', '', '1', '0', '0', '10'),
('8742', '220000', '220700', '220721', '1', '1', '乌兰敖都乡', '0', '', '1', '0', '0', '10'),
('8743', '220000', '220700', '220721', '1', '1', '红旗农场', '0', '', '1', '0', '0', '10'),
('8744', '220000', '220700', '220721', '1', '1', '红光农场', '0', '', '1', '0', '0', '10'),
('8745', '220000', '220700', '220721', '1', '1', '红星牧场', '0', '', '1', '0', '0', '10'),
('8746', '220000', '220700', '220721', '1', '1', '查干花种畜场', '0', '', '1', '0', '0', '10'),
('8747', '220000', '220700', '220722', '1', '1', '长岭镇', '0', '', '1', '0', '0', '10'),
('8748', '220000', '220700', '220722', '1', '1', '太平川镇', '0', '', '1', '0', '0', '10'),
('8749', '220000', '220700', '220722', '1', '1', '巨宝镇', '0', '', '1', '0', '0', '10'),
('8750', '220000', '220700', '220722', '1', '1', '太平山镇', '0', '', '1', '0', '0', '10'),
('8751', '220000', '220700', '220722', '1', '1', '前七号镇', '0', '', '1', '0', '0', '10'),
('8752', '220000', '220700', '220722', '1', '1', '新安镇', '0', '', '1', '0', '0', '10'),
('8753', '220000', '220700', '220722', '1', '1', '三青山镇', '0', '', '1', '0', '0', '10'),
('8754', '220000', '220700', '220722', '1', '1', '大兴镇', '0', '', '1', '0', '0', '10'),
('8755', '220000', '220700', '220722', '1', '1', '北正镇', '0', '', '1', '0', '0', '10'),
('8756', '220000', '220700', '220722', '1', '1', '流水镇', '0', '', '1', '0', '0', '10'),
('8757', '220000', '220700', '220722', '1', '1', '永久镇', '0', '', '1', '0', '0', '10'),
('8758', '220000', '220700', '220722', '1', '1', '利发盛镇', '0', '', '1', '0', '0', '10'),
('8759', '220000', '220700', '220722', '1', '1', '集体乡', '0', '', '1', '0', '0', '10'),
('8760', '220000', '220700', '220722', '1', '1', '光明乡', '0', '', '1', '0', '0', '10'),
('8761', '220000', '220700', '220722', '1', '1', '三县堡乡', '0', '', '1', '0', '0', '10'),
('8762', '220000', '220700', '220722', '1', '1', '海青乡', '0', '', '1', '0', '0', '10'),
('8763', '220000', '220700', '220722', '1', '1', '前进乡', '0', '', '1', '0', '0', '10'),
('8764', '220000', '220700', '220722', '1', '1', '东岭乡', '0', '', '1', '0', '0', '10'),
('8765', '220000', '220700', '220722', '1', '1', '腰坨子乡', '0', '', '1', '0', '0', '10'),
('8766', '220000', '220700', '220722', '1', '1', '八十八乡', '0', '', '1', '0', '0', '10'),
('8767', '220000', '220700', '220722', '1', '1', '三团乡', '0', '', '1', '0', '0', '10'),
('8768', '220000', '220700', '220722', '1', '1', '三十号乡', '0', '', '1', '0', '0', '10'),
('8769', '220000', '220700', '220722', '1', '1', '长岭种马场', '0', '', '1', '0', '0', '10'),
('8770', '220000', '220700', '220722', '1', '1', '太平川（镇）农业园区', '0', '', '1', '0', '0', '10'),
('8771', '220000', '220700', '220722', '1', '1', '北正（镇）牧业园区', '0', '', '1', '0', '0', '10'),
('8772', '220000', '220700', '220722', '1', '1', '双龙工业园区', '0', '', '1', '0', '0', '10'),
('8773', '220000', '220700', '220722', '1', '1', '长岭经济开发区', '0', '', '1', '0', '0', '10'),
('8774', '220000', '220700', '220722', '1', '1', '太平川机械林场', '0', '', '1', '0', '0', '10'),
('8775', '220000', '220700', '220722', '1', '1', '三团机械林场', '0', '', '1', '0', '0', '10'),
('8776', '220000', '220700', '220722', '1', '1', '东岭机械林场', '0', '', '1', '0', '0', '10'),
('8777', '220000', '220700', '220722', '1', '1', '十四号种畜场', '0', '', '1', '0', '0', '10'),
('8778', '220000', '220700', '220722', '1', '1', '良种繁育场', '0', '', '1', '0', '0', '10'),
('8779', '220000', '220700', '220722', '1', '1', '前七号机械林场', '0', '', '1', '0', '0', '10'),
('8780', '220000', '220700', '220723', '1', '1', '乾安镇', '0', '', '1', '0', '0', '10'),
('8781', '220000', '220700', '220723', '1', '1', '大布苏镇', '0', '', '1', '0', '0', '10'),
('8782', '220000', '220700', '220723', '1', '1', '水字镇', '0', '', '1', '0', '0', '10'),
('8783', '220000', '220700', '220723', '1', '1', '让字镇', '0', '', '1', '0', '0', '10'),
('8784', '220000', '220700', '220723', '1', '1', '所字镇', '0', '', '1', '0', '0', '10'),
('8785', '220000', '220700', '220723', '1', '1', '安字镇', '0', '', '1', '0', '0', '10'),
('8786', '220000', '220700', '220723', '1', '1', '余字乡', '0', '', '1', '0', '0', '10'),
('8787', '220000', '220700', '220723', '1', '1', '道字乡', '0', '', '1', '0', '0', '10'),
('8788', '220000', '220700', '220723', '1', '1', '严字乡', '0', '', '1', '0', '0', '10'),
('8789', '220000', '220700', '220723', '1', '1', '赞字乡', '0', '', '1', '0', '0', '10'),
('8790', '220000', '220700', '220724', '1', '1', '三岔河镇', '0', '', '1', '0', '0', '10'),
('8791', '220000', '220700', '220724', '1', '1', '长春岭镇', '0', '', '1', '0', '0', '10'),
('8792', '220000', '220700', '220724', '1', '1', '五家站镇', '0', '', '1', '0', '0', '10'),
('8793', '220000', '220700', '220724', '1', '1', '陶赖昭镇', '0', '', '1', '0', '0', '10'),
('8794', '220000', '220700', '220724', '1', '1', '蔡家沟镇', '0', '', '1', '0', '0', '10'),
('8795', '220000', '220700', '220724', '1', '1', '弓棚子镇', '0', '', '1', '0', '0', '10'),
('8796', '220000', '220700', '220724', '1', '1', '三井子镇', '0', '', '1', '0', '0', '10'),
('8797', '220000', '220700', '220724', '1', '1', '增盛镇', '0', '', '1', '0', '0', '10'),
('8798', '220000', '220700', '220724', '1', '1', '新万发镇', '0', '', '1', '0', '0', '10'),
('8799', '220000', '220700', '220724', '1', '1', '大林子镇', '0', '', '1', '0', '0', '10'),
('8800', '220000', '220700', '220724', '1', '1', '新源镇', '0', '', '1', '0', '0', '10'),
('8801', '220000', '220700', '220724', '1', '1', '三骏满族蒙古族锡伯族乡', '0', '', '1', '0', '0', '10'),
('8802', '220000', '220700', '220724', '1', '1', '永平乡', '0', '', '1', '0', '0', '10'),
('8803', '220000', '220700', '220724', '1', '1', '社里乡', '0', '', '1', '0', '0', '10'),
('8804', '220000', '220700', '220724', '1', '1', '新站乡', '0', '', '1', '0', '0', '10'),
('8805', '220000', '220700', '220724', '1', '1', '更新乡', '0', '', '1', '0', '0', '10'),
('8806', '220000', '220700', '220724', '1', '1', '伊家店乡', '0', '', '1', '0', '0', '10'),
('8807', '220000', '220700', '220724', '1', '1', '肖家乡', '0', '', '1', '0', '0', '10'),
('8808', '220000', '220700', '220724', '1', '1', '伊家店农场', '0', '', '1', '0', '0', '10'),
('8809', '220000', '220700', '220724', '1', '1', '拉林灌区管理局', '0', '', '1', '0', '0', '10'),
('8810', '220000', '220700', '220724', '1', '1', '下岱吉灌区管理局', '0', '', '1', '0', '0', '10'),
('8811', '220000', '220800', '220802', '1', '1', '海明街道', '0', '', '1', '0', '0', '10'),
('8812', '220000', '220800', '220802', '1', '1', '长庆街道', '0', '', '1', '0', '0', '10'),
('8813', '220000', '220800', '220802', '1', '1', '瑞光街道', '0', '', '1', '0', '0', '10'),
('8814', '220000', '220800', '220802', '1', '1', '明仁街道', '0', '', '1', '0', '0', '10'),
('8815', '220000', '220800', '220802', '1', '1', '铁东街道', '0', '', '1', '0', '0', '10'),
('8816', '220000', '220800', '220802', '1', '1', '城南街道', '0', '', '1', '0', '0', '10'),
('8817', '220000', '220800', '220802', '1', '1', '新立街道', '0', '', '1', '0', '0', '10'),
('8818', '220000', '220800', '220802', '1', '1', '幸福街道', '0', '', '1', '0', '0', '10'),
('8819', '220000', '220800', '220802', '1', '1', '新华街道', '0', '', '1', '0', '0', '10'),
('8820', '220000', '220800', '220802', '1', '1', '保平街道', '0', '', '1', '0', '0', '10'),
('8821', '220000', '220800', '220802', '1', '1', '白城经济开发区（省级）', '0', '', '1', '0', '0', '10'),
('8822', '220000', '220800', '220802', '1', '1', '平安镇', '0', '', '1', '0', '0', '10'),
('8823', '220000', '220800', '220802', '1', '1', '青山镇', '0', '', '1', '0', '0', '10'),
('8824', '220000', '220800', '220802', '1', '1', '林海镇', '0', '', '1', '0', '0', '10'),
('8825', '220000', '220800', '220802', '1', '1', '洮河镇', '0', '', '1', '0', '0', '10'),
('8826', '220000', '220800', '220802', '1', '1', '平台镇', '0', '', '1', '0', '0', '10'),
('8827', '220000', '220800', '220802', '1', '1', '到保镇', '0', '', '1', '0', '0', '10'),
('8828', '220000', '220800', '220802', '1', '1', '岭下镇（查干浩特旅游经济开发区）（省级）', '0', '', '1', '0', '0', '10'),
('8829', '220000', '220800', '220802', '1', '1', '东风乡', '0', '', '1', '0', '0', '10'),
('8830', '220000', '220800', '220802', '1', '1', '三合乡', '0', '', '1', '0', '0', '10'),
('8831', '220000', '220800', '220802', '1', '1', '东胜乡', '0', '', '1', '0', '0', '10'),
('8832', '220000', '220800', '220802', '1', '1', '金祥乡', '0', '', '1', '0', '0', '10'),
('8833', '220000', '220800', '220802', '1', '1', '德顺蒙古族乡', '0', '', '1', '0', '0', '10'),
('8834', '220000', '220800', '220802', '1', '1', '民营经济发展区', '0', '', '1', '0', '0', '10'),
('8835', '220000', '220800', '220802', '1', '1', '白城市工业园区', '0', '', '1', '0', '0', '10'),
('8836', '220000', '220800', '220802', '1', '1', '镇南种羊场', '0', '', '1', '0', '0', '10'),
('8837', '220000', '220800', '220821', '1', '1', '镇赉镇', '0', '', '1', '0', '0', '10'),
('8838', '220000', '220800', '220821', '1', '1', '坦途镇', '0', '', '1', '0', '0', '10'),
('8839', '220000', '220800', '220821', '1', '1', '东屏镇', '0', '', '1', '0', '0', '10'),
('8840', '220000', '220800', '220821', '1', '1', '大屯镇', '0', '', '1', '0', '0', '10'),
('8841', '220000', '220800', '220821', '1', '1', '沿江镇', '0', '', '1', '0', '0', '10'),
('8842', '220000', '220800', '220821', '1', '1', '五棵树镇', '0', '', '1', '0', '0', '10'),
('8843', '220000', '220800', '220821', '1', '1', '黑鱼泡镇', '0', '', '1', '0', '0', '10'),
('8844', '220000', '220800', '220821', '1', '1', '哈吐气蒙古族乡', '0', '', '1', '0', '0', '10'),
('8845', '220000', '220800', '220821', '1', '1', '莫莫格蒙古族乡', '0', '', '1', '0', '0', '10'),
('8846', '220000', '220800', '220821', '1', '1', '建平乡', '0', '', '1', '0', '0', '10'),
('8847', '220000', '220800', '220821', '1', '1', '嘎什根乡', '0', '', '1', '0', '0', '10'),
('8848', '220000', '220800', '220821', '1', '1', '镇赉监狱分局', '0', '', '1', '0', '0', '10'),
('8849', '220000', '220800', '220822', '1', '1', '开通镇', '0', '', '1', '0', '0', '10'),
('8850', '220000', '220800', '220822', '1', '1', '瞻榆镇', '0', '', '1', '0', '0', '10'),
('8851', '220000', '220800', '220822', '1', '1', '双岗镇', '0', '', '1', '0', '0', '10'),
('8852', '220000', '220800', '220822', '1', '1', '兴隆山镇', '0', '', '1', '0', '0', '10'),
('8853', '220000', '220800', '220822', '1', '1', '边昭镇', '0', '', '1', '0', '0', '10'),
('8854', '220000', '220800', '220822', '1', '1', '鸿兴镇', '0', '', '1', '0', '0', '10'),
('8855', '220000', '220800', '220822', '1', '1', '新华镇', '0', '', '1', '0', '0', '10'),
('8856', '220000', '220800', '220822', '1', '1', '乌兰花镇', '0', '', '1', '0', '0', '10'),
('8857', '220000', '220800', '220822', '1', '1', '新发乡', '0', '', '1', '0', '0', '10'),
('8858', '220000', '220800', '220822', '1', '1', '新兴乡', '0', '', '1', '0', '0', '10'),
('8859', '220000', '220800', '220822', '1', '1', '向海蒙古族乡', '0', '', '1', '0', '0', '10'),
('8860', '220000', '220800', '220822', '1', '1', '包拉温都蒙古族乡', '0', '', '1', '0', '0', '10'),
('8861', '220000', '220800', '220822', '1', '1', '团结乡', '0', '', '1', '0', '0', '10'),
('8862', '220000', '220800', '220822', '1', '1', '十花道乡', '0', '', '1', '0', '0', '10'),
('8863', '220000', '220800', '220822', '1', '1', '八面乡', '0', '', '1', '0', '0', '10'),
('8864', '220000', '220800', '220822', '1', '1', '苏公坨乡', '0', '', '1', '0', '0', '10'),
('8865', '220000', '220800', '220822', '1', '1', '通榆经济开发区', '0', '', '1', '0', '0', '10'),
('8866', '220000', '220800', '220881', '1', '1', '团结街道', '0', '', '1', '0', '0', '10'),
('8867', '220000', '220800', '220881', '1', '1', '富文街道', '0', '', '1', '0', '0', '10'),
('8868', '220000', '220800', '220881', '1', '1', '光明街道', '0', '', '1', '0', '0', '10'),
('8869', '220000', '220800', '220881', '1', '1', '兴隆街道', '0', '', '1', '0', '0', '10'),
('8870', '220000', '220800', '220881', '1', '1', '永康街道', '0', '', '1', '0', '0', '10'),
('8871', '220000', '220800', '220881', '1', '1', '通达街道', '0', '', '1', '0', '0', '10'),
('8872', '220000', '220800', '220881', '1', '1', '洮府街道', '0', '', '1', '0', '0', '10'),
('8873', '220000', '220800', '220881', '1', '1', '向阳街道', '0', '', '1', '0', '0', '10'),
('8874', '220000', '220800', '220881', '1', '1', '瓦房镇', '0', '', '1', '0', '0', '10'),
('8875', '220000', '220800', '220881', '1', '1', '万宝镇', '0', '', '1', '0', '0', '10'),
('8876', '220000', '220800', '220881', '1', '1', '黑水镇', '0', '', '1', '0', '0', '10'),
('8877', '220000', '220800', '220881', '1', '1', '那金镇', '0', '', '1', '0', '0', '10'),
('8878', '220000', '220800', '220881', '1', '1', '安定镇', '0', '', '1', '0', '0', '10'),
('8879', '220000', '220800', '220881', '1', '1', '胡力吐蒙古族乡', '0', '', '1', '0', '0', '10'),
('8880', '220000', '220800', '220881', '1', '1', '万宝乡', '0', '', '1', '0', '0', '10'),
('8881', '220000', '220800', '220881', '1', '1', '聚宝乡', '0', '', '1', '0', '0', '10'),
('8882', '220000', '220800', '220881', '1', '1', '东升乡', '0', '', '1', '0', '0', '10'),
('8883', '220000', '220800', '220881', '1', '1', '野马乡', '0', '', '1', '0', '0', '10'),
('8884', '220000', '220800', '220881', '1', '1', '永茂乡', '0', '', '1', '0', '0', '10'),
('8885', '220000', '220800', '220881', '1', '1', '蛟流河乡', '0', '', '1', '0', '0', '10'),
('8886', '220000', '220800', '220881', '1', '1', '大通乡', '0', '', '1', '0', '0', '10'),
('8887', '220000', '220800', '220881', '1', '1', '福顺乡', '0', '', '1', '0', '0', '10'),
('8888', '220000', '220800', '220881', '1', '1', '二龙乡', '0', '', '1', '0', '0', '10'),
('8889', '220000', '220800', '220881', '1', '1', '呼和车力蒙古族乡', '0', '', '1', '0', '0', '10'),
('8890', '220000', '220800', '220881', '1', '1', '洮南市种雏场', '0', '', '1', '0', '0', '10'),
('8891', '220000', '220800', '220881', '1', '1', '洮南市甜菜育种研究所', '0', '', '1', '0', '0', '10'),
('8892', '220000', '220800', '220882', '1', '1', '慧阳街道', '0', '', '1', '0', '0', '10'),
('8893', '220000', '220800', '220882', '1', '1', '临江街道', '0', '', '1', '0', '0', '10'),
('8894', '220000', '220800', '220882', '1', '1', '长虹街道', '0', '', '1', '0', '0', '10'),
('8895', '220000', '220800', '220882', '1', '1', '锦华街道', '0', '', '1', '0', '0', '10'),
('8896', '220000', '220800', '220882', '1', '1', '安北街道', '0', '', '1', '0', '0', '10'),
('8897', '220000', '220800', '220882', '1', '1', '大安经济开发区（省级）', '0', '', '1', '0', '0', '10'),
('8898', '220000', '220800', '220882', '1', '1', '月亮泡镇', '0', '', '1', '0', '0', '10'),
('8899', '220000', '220800', '220882', '1', '1', '安广镇', '0', '', '1', '0', '0', '10'),
('8900', '220000', '220800', '220882', '1', '1', '丰收镇', '0', '', '1', '0', '0', '10'),
('8901', '220000', '220800', '220882', '1', '1', '新平安镇', '0', '', '1', '0', '0', '10'),
('8902', '220000', '220800', '220882', '1', '1', '两家子镇', '0', '', '1', '0', '0', '10'),
('8903', '220000', '220800', '220882', '1', '1', '舍力镇', '0', '', '1', '0', '0', '10'),
('8904', '220000', '220800', '220882', '1', '1', '大岗子镇', '0', '', '1', '0', '0', '10'),
('8905', '220000', '220800', '220882', '1', '1', '叉干镇', '0', '', '1', '0', '0', '10'),
('8906', '220000', '220800', '220882', '1', '1', '龙沼镇', '0', '', '1', '0', '0', '10'),
('8907', '220000', '220800', '220882', '1', '1', '太山镇', '0', '', '1', '0', '0', '10'),
('8908', '220000', '220800', '220882', '1', '1', '烧锅镇', '0', '', '1', '0', '0', '10'),
('8909', '220000', '220800', '220882', '1', '1', '乐胜镇', '0', '', '1', '0', '0', '10'),
('8910', '220000', '220800', '220882', '1', '1', '四棵树乡', '0', '', '1', '0', '0', '10'),
('8911', '220000', '220800', '220882', '1', '1', '联合乡', '0', '', '1', '0', '0', '10'),
('8912', '220000', '220800', '220882', '1', '1', '大赉乡', '0', '', '1', '0', '0', '10'),
('8913', '220000', '220800', '220882', '1', '1', '红岗子乡', '0', '', '1', '0', '0', '10'),
('8914', '220000', '220800', '220882', '1', '1', '海坨乡', '0', '', '1', '0', '0', '10'),
('8915', '220000', '220800', '220882', '1', '1', '新艾里蒙古族乡', '0', '', '1', '0', '0', '10'),
('8916', '220000', '222400', '222401', '1', '1', '朝阳街道', '0', '', '1', '0', '0', '10'),
('8917', '220000', '222400', '222401', '1', '1', '北山街道', '0', '', '1', '0', '0', '10'),
('8918', '220000', '222400', '222401', '1', '1', '新兴街道', '0', '', '1', '0', '0', '10'),
('8919', '220000', '222400', '222401', '1', '1', '公园街道', '0', '', '1', '0', '0', '10'),
('8920', '220000', '222400', '222401', '1', '1', '河南街道', '0', '', '1', '0', '0', '10'),
('8921', '220000', '222400', '222401', '1', '1', '建工街道', '0', '', '1', '0', '0', '10'),
('8922', '220000', '222400', '222401', '1', '1', '小营镇', '0', '', '1', '0', '0', '10'),
('8923', '220000', '222400', '222401', '1', '1', '依兰镇', '0', '', '1', '0', '0', '10'),
('8924', '220000', '222400', '222401', '1', '1', '三道湾镇', '0', '', '1', '0', '0', '10'),
('8925', '220000', '222400', '222402', '1', '1', '向上街道', '0', '', '1', '0', '0', '10'),
('8926', '220000', '222400', '222402', '1', '1', '新华街道', '0', '', '1', '0', '0', '10'),
('8927', '220000', '222400', '222402', '1', '1', '月宫街道', '0', '', '1', '0', '0', '10'),
('8928', '220000', '222400', '222402', '1', '1', '月晴镇', '0', '', '1', '0', '0', '10'),
('8929', '220000', '222400', '222402', '1', '1', '石岘镇', '0', '', '1', '0', '0', '10'),
('8930', '220000', '222400', '222402', '1', '1', '长安镇', '0', '', '1', '0', '0', '10'),
('8931', '220000', '222400', '222402', '1', '1', '凉水镇', '0', '', '1', '0', '0', '10'),
('8932', '220000', '222400', '222403', '1', '1', '渤海街道', '0', '', '1', '0', '0', '10'),
('8933', '220000', '222400', '222403', '1', '1', '胜利街道', '0', '', '1', '0', '0', '10'),
('8934', '220000', '222400', '222403', '1', '1', '民主街道', '0', '', '1', '0', '0', '10'),
('8935', '220000', '222400', '222403', '1', '1', '丹江街道', '0', '', '1', '0', '0', '10'),
('8936', '220000', '222400', '222403', '1', '1', '大石头镇', '0', '', '1', '0', '0', '10'),
('8937', '220000', '222400', '222403', '1', '1', '黄泥河镇', '0', '', '1', '0', '0', '10'),
('8938', '220000', '222400', '222403', '1', '1', '官地镇', '0', '', '1', '0', '0', '10'),
('8939', '220000', '222400', '222403', '1', '1', '沙河沿镇', '0', '', '1', '0', '0', '10'),
('8940', '220000', '222400', '222403', '1', '1', '秋梨沟镇', '0', '', '1', '0', '0', '10'),
('8941', '220000', '222400', '222403', '1', '1', '额穆镇', '0', '', '1', '0', '0', '10'),
('8942', '220000', '222400', '222403', '1', '1', '贤儒镇', '0', '', '1', '0', '0', '10'),
('8943', '220000', '222400', '222403', '1', '1', '大蒲柴河镇', '0', '', '1', '0', '0', '10'),
('8944', '220000', '222400', '222403', '1', '1', '雁鸣湖镇', '0', '', '1', '0', '0', '10'),
('8945', '220000', '222400', '222403', '1', '1', '江源镇', '0', '', '1', '0', '0', '10'),
('8946', '220000', '222400', '222403', '1', '1', '江南镇', '0', '', '1', '0', '0', '10'),
('8947', '220000', '222400', '222403', '1', '1', '大桥乡', '0', '', '1', '0', '0', '10'),
('8948', '220000', '222400', '222403', '1', '1', '黑石乡', '0', '', '1', '0', '0', '10'),
('8949', '220000', '222400', '222403', '1', '1', '青沟子乡', '0', '', '1', '0', '0', '10'),
('8950', '220000', '222400', '222403', '1', '1', '翰章乡', '0', '', '1', '0', '0', '10'),
('8951', '220000', '222400', '222403', '1', '1', '红石乡', '0', '', '1', '0', '0', '10'),
('8952', '220000', '222400', '222403', '1', '1', '丹峰林业有限公司', '0', '', '1', '0', '0', '10'),
('8953', '220000', '222400', '222403', '1', '1', '黄泥河林业局', '0', '', '1', '0', '0', '10'),
('8954', '220000', '222400', '222403', '1', '1', '延边林业集团亚光有限公司', '0', '', '1', '0', '0', '10'),
('8955', '220000', '222400', '222403', '1', '1', '敦化市林业局', '0', '', '1', '0', '0', '10'),
('8956', '220000', '222400', '222404', '1', '1', '靖和街道', '0', '', '1', '0', '0', '10'),
('8957', '220000', '222400', '222404', '1', '1', '新安街道', '0', '', '1', '0', '0', '10'),
('8958', '220000', '222400', '222404', '1', '1', '河南街道', '0', '', '1', '0', '0', '10'),
('8959', '220000', '222400', '222404', '1', '1', '近海街道办事处（珲春边境经济合作区）（国', '0', '', '1', '0', '0', '10'),
('8960', '220000', '222400', '222404', '1', '1', '春化镇', '0', '', '1', '0', '0', '10'),
('8961', '220000', '222400', '222404', '1', '1', '敬信镇', '0', '', '1', '0', '0', '10'),
('8962', '220000', '222400', '222404', '1', '1', '板石镇', '0', '', '1', '0', '0', '10'),
('8963', '220000', '222400', '222404', '1', '1', '英安镇', '0', '', '1', '0', '0', '10'),
('8964', '220000', '222400', '222404', '1', '1', '马川子乡', '0', '', '1', '0', '0', '10'),
('8965', '220000', '222400', '222404', '1', '1', '杨泡满族乡', '0', '', '1', '0', '0', '10'),
('8966', '220000', '222400', '222404', '1', '1', '三家子满族乡', '0', '', '1', '0', '0', '10'),
('8967', '220000', '222400', '222404', '1', '1', '密江乡', '0', '', '1', '0', '0', '10'),
('8968', '220000', '222400', '222404', '1', '1', '哈达门乡', '0', '', '1', '0', '0', '10'),
('8969', '220000', '222400', '222404', '1', '1', '珲春林业局', '0', '', '1', '0', '0', '10'),
('8970', '220000', '222400', '222405', '1', '1', '安民街道', '0', '', '1', '0', '0', '10'),
('8971', '220000', '222400', '222405', '1', '1', '龙门街道', '0', '', '1', '0', '0', '10'),
('8972', '220000', '222400', '222405', '1', '1', '开山屯镇', '0', '', '1', '0', '0', '10'),
('8973', '220000', '222400', '222405', '1', '1', '朝阳川镇', '0', '', '1', '0', '0', '10'),
('8974', '220000', '222400', '222405', '1', '1', '老头沟镇', '0', '', '1', '0', '0', '10'),
('8975', '220000', '222400', '222405', '1', '1', '三合镇', '0', '', '1', '0', '0', '10'),
('8976', '220000', '222400', '222405', '1', '1', '东盛涌镇', '0', '', '1', '0', '0', '10'),
('8977', '220000', '222400', '222405', '1', '1', '智新镇', '0', '', '1', '0', '0', '10'),
('8978', '220000', '222400', '222405', '1', '1', '德新乡', '0', '', '1', '0', '0', '10'),
('8979', '220000', '222400', '222405', '1', '1', '白金乡', '0', '', '1', '0', '0', '10'),
('8980', '220000', '222400', '222406', '1', '1', '民慧街道', '0', '', '1', '0', '0', '10'),
('8981', '220000', '222400', '222406', '1', '1', '光明街道', '0', '', '1', '0', '0', '10'),
('8982', '220000', '222400', '222406', '1', '1', '文化街道', '0', '', '1', '0', '0', '10'),
('8983', '220000', '222400', '222406', '1', '1', '八家子镇', '0', '', '1', '0', '0', '10'),
('8984', '220000', '222400', '222406', '1', '1', '福洞镇', '0', '', '1', '0', '0', '10'),
('8985', '220000', '222400', '222406', '1', '1', '头道镇', '0', '', '1', '0', '0', '10'),
('8986', '220000', '222400', '222406', '1', '1', '西城镇', '0', '', '1', '0', '0', '10'),
('8987', '220000', '222400', '222406', '1', '1', '南坪镇', '0', '', '1', '0', '0', '10'),
('8988', '220000', '222400', '222406', '1', '1', '东城镇', '0', '', '1', '0', '0', '10'),
('8989', '220000', '222400', '222406', '1', '1', '崇善镇', '0', '', '1', '0', '0', '10'),
('8990', '220000', '222400', '222406', '1', '1', '龙城镇', '0', '', '1', '0', '0', '10'),
('8991', '220000', '222400', '222406', '1', '1', '和龙林业局', '0', '', '1', '0', '0', '10'),
('8992', '220000', '222400', '222406', '1', '1', '八家子林业局', '0', '', '1', '0', '0', '10'),
('8993', '220000', '222400', '222406', '1', '1', '和龙市林业局', '0', '', '1', '0', '0', '10'),
('8994', '220000', '222400', '222424', '1', '1', '东城街道', '0', '', '1', '0', '0', '10'),
('8995', '220000', '222400', '222424', '1', '1', '西城街道', '0', '', '1', '0', '0', '10'),
('8996', '220000', '222400', '222424', '1', '1', '汪清镇', '0', '', '1', '0', '0', '10'),
('8997', '220000', '222400', '222424', '1', '1', '大兴沟镇', '0', '', '1', '0', '0', '10'),
('8998', '220000', '222400', '222424', '1', '1', '天桥岭镇', '0', '', '1', '0', '0', '10'),
('8999', '220000', '222400', '222424', '1', '1', '罗子沟镇', '0', '', '1', '0', '0', '10'),
('9000', '220000', '222400', '222424', '1', '1', '百草沟镇', '0', '', '1', '0', '0', '10'),
('9001', '220000', '222400', '222424', '1', '1', '春阳镇', '0', '', '1', '0', '0', '10'),
('9002', '220000', '222400', '222424', '1', '1', '复兴镇', '0', '', '1', '0', '0', '10'),
('9003', '220000', '222400', '222424', '1', '1', '东光镇', '0', '', '1', '0', '0', '10'),
('9004', '220000', '222400', '222424', '1', '1', '鸡冠乡', '0', '', '1', '0', '0', '10'),
('9005', '220000', '222400', '222424', '1', '1', '汪清林业局', '0', '', '1', '0', '0', '10'),
('9006', '220000', '222400', '222424', '1', '1', '天桥岭林业局', '0', '', '1', '0', '0', '10'),
('9007', '220000', '222400', '222424', '1', '1', '大兴沟林业局', '0', '', '1', '0', '0', '10'),
('9008', '220000', '222400', '222426', '1', '1', '明月镇', '0', '', '1', '0', '0', '10'),
('9009', '220000', '222400', '222426', '1', '1', '松江镇', '0', '', '1', '0', '0', '10'),
('9010', '220000', '222400', '222426', '1', '1', '二道白河镇', '0', '', '1', '0', '0', '10');
INSERT INTO `wst_communitys` VALUES ('9011', '220000', '222400', '222426', '1', '1', '两江镇', '0', '', '1', '0', '0', '10'),
('9012', '220000', '222400', '222426', '1', '1', '石门镇', '0', '', '1', '0', '0', '10'),
('9013', '220000', '222400', '222426', '1', '1', '万宝镇', '0', '', '1', '0', '0', '10'),
('9014', '220000', '222400', '222426', '1', '1', '亮兵镇', '0', '', '1', '0', '0', '10'),
('9015', '220000', '222400', '222426', '1', '1', '新合乡', '0', '', '1', '0', '0', '10'),
('9016', '220000', '222400', '222426', '1', '1', '永庆乡', '0', '', '1', '0', '0', '10'),
('9017', '220000', '222400', '222426', '1', '1', '白河林业局', '0', '', '1', '0', '0', '10'),
('9018', '220000', '222400', '222426', '1', '1', '安图林业有限公司', '0', '', '1', '0', '0', '10'),
('9019', '220000', '222400', '222426', '1', '1', '安图县林业局', '0', '', '1', '0', '0', '10'),
('9020', '230000', '230100', '230102', '1', '1', '兆麟街道', '0', '', '1', '0', '0', '10'),
('9021', '230000', '230100', '230102', '1', '1', '新阳路街道', '0', '', '1', '0', '0', '10'),
('9022', '230000', '230100', '230102', '1', '1', '抚顺街道', '0', '', '1', '0', '0', '10'),
('9023', '230000', '230100', '230102', '1', '1', '共乐街道', '0', '', '1', '0', '0', '10'),
('9024', '230000', '230100', '230102', '1', '1', '新华街道', '0', '', '1', '0', '0', '10'),
('9025', '230000', '230100', '230102', '1', '1', '城乡路街道', '0', '', '1', '0', '0', '10'),
('9026', '230000', '230100', '230102', '1', '1', '工农街道', '0', '', '1', '0', '0', '10'),
('9027', '230000', '230100', '230102', '1', '1', '尚志街道', '0', '', '1', '0', '0', '10'),
('9028', '230000', '230100', '230102', '1', '1', '斯大林街道', '0', '', '1', '0', '0', '10'),
('9029', '230000', '230100', '230102', '1', '1', '通江街道', '0', '', '1', '0', '0', '10'),
('9030', '230000', '230100', '230102', '1', '1', '经纬街道', '0', '', '1', '0', '0', '10'),
('9031', '230000', '230100', '230102', '1', '1', '工程街道', '0', '', '1', '0', '0', '10'),
('9032', '230000', '230100', '230102', '1', '1', '安静街道', '0', '', '1', '0', '0', '10'),
('9033', '230000', '230100', '230102', '1', '1', '安和街道', '0', '', '1', '0', '0', '10'),
('9034', '230000', '230100', '230102', '1', '1', '正阳河街道', '0', '', '1', '0', '0', '10'),
('9035', '230000', '230100', '230102', '1', '1', '建国街道', '0', '', '1', '0', '0', '10'),
('9036', '230000', '230100', '230102', '1', '1', '康安街道', '0', '', '1', '0', '0', '10'),
('9037', '230000', '230100', '230102', '1', '1', '太平镇', '0', '', '1', '0', '0', '10'),
('9038', '230000', '230100', '230102', '1', '1', '新发镇', '0', '', '1', '0', '0', '10'),
('9039', '230000', '230100', '230102', '1', '1', '新农镇', '0', '', '1', '0', '0', '10'),
('9040', '230000', '230100', '230102', '1', '1', '榆树镇', '0', '', '1', '0', '0', '10'),
('9041', '230000', '230100', '230102', '1', '1', '群力乡', '0', '', '1', '0', '0', '10'),
('9042', '230000', '230100', '230102', '1', '1', '阎家岗农场', '0', '', '1', '0', '0', '10'),
('9043', '230000', '230100', '230103', '1', '1', '花园街道', '0', '', '1', '0', '0', '10'),
('9044', '230000', '230100', '230103', '1', '1', '奋斗路街道', '0', '', '1', '0', '0', '10'),
('9045', '230000', '230100', '230103', '1', '1', '革新街道', '0', '', '1', '0', '0', '10'),
('9046', '230000', '230100', '230103', '1', '1', '文化街道', '0', '', '1', '0', '0', '10'),
('9047', '230000', '230100', '230103', '1', '1', '大成街道', '0', '', '1', '0', '0', '10'),
('9048', '230000', '230100', '230103', '1', '1', '芦家街道', '0', '', '1', '0', '0', '10'),
('9049', '230000', '230100', '230103', '1', '1', '荣市街道', '0', '', '1', '0', '0', '10'),
('9050', '230000', '230100', '230103', '1', '1', '燎原街道', '0', '', '1', '0', '0', '10'),
('9051', '230000', '230100', '230103', '1', '1', '松花江街道', '0', '', '1', '0', '0', '10'),
('9052', '230000', '230100', '230103', '1', '1', '曲线街道', '0', '', '1', '0', '0', '10'),
('9053', '230000', '230100', '230103', '1', '1', '通达街道', '0', '', '1', '0', '0', '10'),
('9054', '230000', '230100', '230103', '1', '1', '七政街道', '0', '', '1', '0', '0', '10'),
('9055', '230000', '230100', '230103', '1', '1', '和兴路街道', '0', '', '1', '0', '0', '10'),
('9056', '230000', '230100', '230103', '1', '1', '哈西街道', '0', '', '1', '0', '0', '10'),
('9057', '230000', '230100', '230103', '1', '1', '保健路街道', '0', '', '1', '0', '0', '10'),
('9058', '230000', '230100', '230103', '1', '1', '先锋路街道', '0', '', '1', '0', '0', '10'),
('9059', '230000', '230100', '230103', '1', '1', '新春街道', '0', '', '1', '0', '0', '10'),
('9060', '230000', '230100', '230103', '1', '1', '王岗镇', '0', '', '1', '0', '0', '10'),
('9061', '230000', '230100', '230103', '1', '1', '红旗满族乡', '0', '', '1', '0', '0', '10'),
('9062', '230000', '230100', '230103', '1', '1', '跃进乡', '0', '', '1', '0', '0', '10'),
('9063', '230000', '230100', '230104', '1', '1', '靖宇街道', '0', '', '1', '0', '0', '10'),
('9064', '230000', '230100', '230104', '1', '1', '太古街道', '0', '', '1', '0', '0', '10'),
('9065', '230000', '230100', '230104', '1', '1', '东莱街道', '0', '', '1', '0', '0', '10'),
('9066', '230000', '230100', '230104', '1', '1', '滨江街道', '0', '', '1', '0', '0', '10'),
('9067', '230000', '230100', '230104', '1', '1', '仁里街道', '0', '', '1', '0', '0', '10'),
('9068', '230000', '230100', '230104', '1', '1', '崇俭街道', '0', '', '1', '0', '0', '10'),
('9069', '230000', '230100', '230104', '1', '1', '振江街道', '0', '', '1', '0', '0', '10'),
('9070', '230000', '230100', '230104', '1', '1', '东原街道', '0', '', '1', '0', '0', '10'),
('9071', '230000', '230100', '230104', '1', '1', '大兴街道', '0', '', '1', '0', '0', '10'),
('9072', '230000', '230100', '230104', '1', '1', '胜利街道', '0', '', '1', '0', '0', '10'),
('9073', '230000', '230100', '230104', '1', '1', '南马街道', '0', '', '1', '0', '0', '10'),
('9074', '230000', '230100', '230104', '1', '1', '民强街道', '0', '', '1', '0', '0', '10'),
('9075', '230000', '230100', '230104', '1', '1', '大有坊街道', '0', '', '1', '0', '0', '10'),
('9076', '230000', '230100', '230104', '1', '1', '南直路街道', '0', '', '1', '0', '0', '10'),
('9077', '230000', '230100', '230104', '1', '1', '化工街道', '0', '', '1', '0', '0', '10'),
('9078', '230000', '230100', '230104', '1', '1', '火车头街道', '0', '', '1', '0', '0', '10'),
('9079', '230000', '230100', '230104', '1', '1', '新一街道', '0', '', '1', '0', '0', '10'),
('9080', '230000', '230100', '230104', '1', '1', '三棵树大街街道', '0', '', '1', '0', '0', '10'),
('9081', '230000', '230100', '230104', '1', '1', '水泥路街道', '0', '', '1', '0', '0', '10'),
('9082', '230000', '230100', '230104', '1', '1', '太平大街街道', '0', '', '1', '0', '0', '10'),
('9083', '230000', '230100', '230104', '1', '1', '黎华街道', '0', '', '1', '0', '0', '10'),
('9084', '230000', '230100', '230104', '1', '1', '新乐街道', '0', '', '1', '0', '0', '10'),
('9085', '230000', '230100', '230104', '1', '1', '永源镇', '0', '', '1', '0', '0', '10'),
('9086', '230000', '230100', '230104', '1', '1', '巨源镇', '0', '', '1', '0', '0', '10'),
('9087', '230000', '230100', '230104', '1', '1', '团结镇', '0', '', '1', '0', '0', '10'),
('9088', '230000', '230100', '230104', '1', '1', '民主乡', '0', '', '1', '0', '0', '10'),
('9089', '230000', '230100', '230108', '1', '1', '兴建街道', '0', '', '1', '0', '0', '10'),
('9090', '230000', '230100', '230108', '1', '1', '保国街道', '0', '', '1', '0', '0', '10'),
('9091', '230000', '230100', '230108', '1', '1', '联盟街道', '0', '', '1', '0', '0', '10'),
('9092', '230000', '230100', '230108', '1', '1', '友协街道', '0', '', '1', '0', '0', '10'),
('9093', '230000', '230100', '230108', '1', '1', '新疆街道', '0', '', '1', '0', '0', '10'),
('9094', '230000', '230100', '230108', '1', '1', '新伟街道', '0', '', '1', '0', '0', '10'),
('9095', '230000', '230100', '230108', '1', '1', '平房镇', '0', '', '1', '0', '0', '10'),
('9096', '230000', '230100', '230108', '1', '1', '平新镇', '0', '', '1', '0', '0', '10'),
('9097', '230000', '230100', '230109', '1', '1', '三电街道', '0', '', '1', '0', '0', '10'),
('9098', '230000', '230100', '230109', '1', '1', '太阳岛街道', '0', '', '1', '0', '0', '10'),
('9099', '230000', '230100', '230109', '1', '1', '松浦街道', '0', '', '1', '0', '0', '10'),
('9100', '230000', '230100', '230109', '1', '1', '万宝街道', '0', '', '1', '0', '0', '10'),
('9101', '230000', '230100', '230109', '1', '1', '松北街道', '0', '', '1', '0', '0', '10'),
('9102', '230000', '230100', '230109', '1', '1', '对青山镇', '0', '', '1', '0', '0', '10'),
('9103', '230000', '230100', '230109', '1', '1', '乐业镇', '0', '', '1', '0', '0', '10'),
('9104', '230000', '230100', '230110', '1', '1', '香坊大街街道', '0', '', '1', '0', '0', '10'),
('9105', '230000', '230100', '230110', '1', '1', '安埠街道', '0', '', '1', '0', '0', '10'),
('9106', '230000', '230100', '230110', '1', '1', '通天街道', '0', '', '1', '0', '0', '10'),
('9107', '230000', '230100', '230110', '1', '1', '新香坊街道', '0', '', '1', '0', '0', '10'),
('9108', '230000', '230100', '230110', '1', '1', '铁东街道', '0', '', '1', '0', '0', '10'),
('9109', '230000', '230100', '230110', '1', '1', '新成街道', '0', '', '1', '0', '0', '10'),
('9110', '230000', '230100', '230110', '1', '1', '红旗街道', '0', '', '1', '0', '0', '10'),
('9111', '230000', '230100', '230110', '1', '1', '六顺街道', '0', '', '1', '0', '0', '10'),
('9112', '230000', '230100', '230110', '1', '1', '建筑街道', '0', '', '1', '0', '0', '10'),
('9113', '230000', '230100', '230110', '1', '1', '哈平路街道', '0', '', '1', '0', '0', '10'),
('9114', '230000', '230100', '230110', '1', '1', '安乐街道', '0', '', '1', '0', '0', '10'),
('9115', '230000', '230100', '230110', '1', '1', '健康路街道', '0', '', '1', '0', '0', '10'),
('9116', '230000', '230100', '230110', '1', '1', '大庆路街道', '0', '', '1', '0', '0', '10'),
('9117', '230000', '230100', '230110', '1', '1', '进乡街道', '0', '', '1', '0', '0', '10'),
('9118', '230000', '230100', '230110', '1', '1', '通乡街道', '0', '', '1', '0', '0', '10'),
('9119', '230000', '230100', '230110', '1', '1', '和平路街道', '0', '', '1', '0', '0', '10'),
('9120', '230000', '230100', '230110', '1', '1', '民生路街道', '0', '', '1', '0', '0', '10'),
('9121', '230000', '230100', '230110', '1', '1', '文政街道', '0', '', '1', '0', '0', '10'),
('9122', '230000', '230100', '230110', '1', '1', '王兆街道', '0', '', '1', '0', '0', '10'),
('9123', '230000', '230100', '230110', '1', '1', '黎明街道', '0', '', '1', '0', '0', '10'),
('9124', '230000', '230100', '230110', '1', '1', '成高子镇', '0', '', '1', '0', '0', '10'),
('9125', '230000', '230100', '230110', '1', '1', '幸福镇', '0', '', '1', '0', '0', '10'),
('9126', '230000', '230100', '230110', '1', '1', '朝阳镇', '0', '', '1', '0', '0', '10'),
('9127', '230000', '230100', '230110', '1', '1', '向阳乡', '0', '', '1', '0', '0', '10'),
('9128', '230000', '230100', '230110', '1', '1', '香坊实验农场', '0', '', '1', '0', '0', '10'),
('9129', '230000', '230100', '230111', '1', '1', '呼兰街道', '0', '', '1', '0', '0', '10'),
('9130', '230000', '230100', '230111', '1', '1', '兰河街道', '0', '', '1', '0', '0', '10'),
('9131', '230000', '230100', '230111', '1', '1', '利民街道', '0', '', '1', '0', '0', '10'),
('9132', '230000', '230100', '230111', '1', '1', '腰卜街道', '0', '', '1', '0', '0', '10'),
('9133', '230000', '230100', '230111', '1', '1', '康金镇', '0', '', '1', '0', '0', '10'),
('9134', '230000', '230100', '230111', '1', '1', '沈家镇', '0', '', '1', '0', '0', '10'),
('9135', '230000', '230100', '230111', '1', '1', '二八镇', '0', '', '1', '0', '0', '10'),
('9136', '230000', '230100', '230111', '1', '1', '石人镇', '0', '', '1', '0', '0', '10'),
('9137', '230000', '230100', '230111', '1', '1', '白奎镇', '0', '', '1', '0', '0', '10'),
('9138', '230000', '230100', '230111', '1', '1', '方台镇', '0', '', '1', '0', '0', '10'),
('9139', '230000', '230100', '230111', '1', '1', '莲花镇', '0', '', '1', '0', '0', '10'),
('9140', '230000', '230100', '230111', '1', '1', '大用镇', '0', '', '1', '0', '0', '10'),
('9141', '230000', '230100', '230111', '1', '1', '双井镇', '0', '', '1', '0', '0', '10'),
('9142', '230000', '230100', '230111', '1', '1', '长岭镇', '0', '', '1', '0', '0', '10'),
('9143', '230000', '230100', '230111', '1', '1', '杨林乡', '0', '', '1', '0', '0', '10'),
('9144', '230000', '230100', '230111', '1', '1', '许卜乡', '0', '', '1', '0', '0', '10'),
('9145', '230000', '230100', '230111', '1', '1', '孟家乡', '0', '', '1', '0', '0', '10'),
('9146', '230000', '230100', '230112', '1', '1', '和平街道', '0', '', '1', '0', '0', '10'),
('9147', '230000', '230100', '230112', '1', '1', '胜利街道', '0', '', '1', '0', '0', '10'),
('9148', '230000', '230100', '230112', '1', '1', '通城街道', '0', '', '1', '0', '0', '10'),
('9149', '230000', '230100', '230112', '1', '1', '河东街道', '0', '', '1', '0', '0', '10'),
('9150', '230000', '230100', '230112', '1', '1', '阿什河街道', '0', '', '1', '0', '0', '10'),
('9151', '230000', '230100', '230112', '1', '1', '玉泉镇', '0', '', '1', '0', '0', '10'),
('9152', '230000', '230100', '230112', '1', '1', '蜚克图镇', '0', '', '1', '0', '0', '10'),
('9153', '230000', '230100', '230112', '1', '1', '亚沟镇', '0', '', '1', '0', '0', '10'),
('9154', '230000', '230100', '230112', '1', '1', '交界镇', '0', '', '1', '0', '0', '10'),
('9155', '230000', '230100', '230112', '1', '1', '小岭镇', '0', '', '1', '0', '0', '10'),
('9156', '230000', '230100', '230112', '1', '1', '平山镇', '0', '', '1', '0', '0', '10'),
('9157', '230000', '230100', '230112', '1', '1', '松峰山镇', '0', '', '1', '0', '0', '10'),
('9158', '230000', '230100', '230112', '1', '1', '新华镇', '0', '', '1', '0', '0', '10'),
('9159', '230000', '230100', '230112', '1', '1', '双丰镇', '0', '', '1', '0', '0', '10'),
('9160', '230000', '230100', '230112', '1', '1', '杨树乡', '0', '', '1', '0', '0', '10'),
('9161', '230000', '230100', '230112', '1', '1', '舍利乡', '0', '', '1', '0', '0', '10'),
('9162', '230000', '230100', '230112', '1', '1', '料甸满族乡', '0', '', '1', '0', '0', '10'),
('9163', '230000', '230100', '230112', '1', '1', '红星乡', '0', '', '1', '0', '0', '10'),
('9164', '230000', '230100', '230112', '1', '1', '大岭乡', '0', '', '1', '0', '0', '10'),
('9165', '230000', '230100', '230123', '1', '1', '依兰镇', '0', '', '1', '0', '0', '10'),
('9166', '230000', '230100', '230123', '1', '1', '达连河镇', '0', '', '1', '0', '0', '10'),
('9167', '230000', '230100', '230123', '1', '1', '江湾镇', '0', '', '1', '0', '0', '10'),
('9168', '230000', '230100', '230123', '1', '1', '三道岗镇', '0', '', '1', '0', '0', '10'),
('9169', '230000', '230100', '230123', '1', '1', '道台桥镇', '0', '', '1', '0', '0', '10'),
('9170', '230000', '230100', '230123', '1', '1', '宏克利镇', '0', '', '1', '0', '0', '10'),
('9171', '230000', '230100', '230123', '1', '1', '团山子乡', '0', '', '1', '0', '0', '10'),
('9172', '230000', '230100', '230123', '1', '1', '愚公乡', '0', '', '1', '0', '0', '10'),
('9173', '230000', '230100', '230123', '1', '1', '迎兰朝鲜族乡', '0', '', '1', '0', '0', '10'),
('9174', '230000', '230100', '230123', '1', '1', '依兰县林业局', '0', '', '1', '0', '0', '10'),
('9175', '230000', '230100', '230123', '1', '1', '依兰农场', '0', '', '1', '0', '0', '10'),
('9176', '230000', '230100', '230123', '1', '1', '松花江农场', '0', '', '1', '0', '0', '10'),
('9177', '230000', '230100', '230123', '1', '1', '红旗良种厂', '0', '', '1', '0', '0', '10'),
('9178', '230000', '230100', '230123', '1', '1', '依兰县农委', '0', '', '1', '0', '0', '10'),
('9179', '230000', '230100', '230124', '1', '1', '方正镇', '0', '', '1', '0', '0', '10'),
('9180', '230000', '230100', '230124', '1', '1', '会发镇', '0', '', '1', '0', '0', '10'),
('9181', '230000', '230100', '230124', '1', '1', '大罗密镇', '0', '', '1', '0', '0', '10'),
('9182', '230000', '230100', '230124', '1', '1', '天门乡', '0', '', '1', '0', '0', '10'),
('9183', '230000', '230100', '230124', '1', '1', '松南乡', '0', '', '1', '0', '0', '10'),
('9184', '230000', '230100', '230124', '1', '1', '德善乡', '0', '', '1', '0', '0', '10'),
('9185', '230000', '230100', '230124', '1', '1', '宝兴乡', '0', '', '1', '0', '0', '10'),
('9186', '230000', '230100', '230124', '1', '1', '伊汉通乡', '0', '', '1', '0', '0', '10'),
('9187', '230000', '230100', '230124', '1', '1', '方正林业局', '0', '', '1', '0', '0', '10'),
('9188', '230000', '230100', '230124', '1', '1', '沙河农场', '0', '', '1', '0', '0', '10'),
('9189', '230000', '230100', '230125', '1', '1', '宾州镇', '0', '', '1', '0', '0', '10'),
('9190', '230000', '230100', '230125', '1', '1', '居仁镇', '0', '', '1', '0', '0', '10'),
('9191', '230000', '230100', '230125', '1', '1', '宾西镇', '0', '', '1', '0', '0', '10'),
('9192', '230000', '230100', '230125', '1', '1', '糖坊镇', '0', '', '1', '0', '0', '10'),
('9193', '230000', '230100', '230125', '1', '1', '宾安镇', '0', '', '1', '0', '0', '10'),
('9194', '230000', '230100', '230125', '1', '1', '新甸镇', '0', '', '1', '0', '0', '10'),
('9195', '230000', '230100', '230125', '1', '1', '胜利镇', '0', '', '1', '0', '0', '10'),
('9196', '230000', '230100', '230125', '1', '1', '宁远镇', '0', '', '1', '0', '0', '10'),
('9197', '230000', '230100', '230125', '1', '1', '摆渡镇', '0', '', '1', '0', '0', '10'),
('9198', '230000', '230100', '230125', '1', '1', '平坊镇', '0', '', '1', '0', '0', '10'),
('9199', '230000', '230100', '230125', '1', '1', '满井镇', '0', '', '1', '0', '0', '10'),
('9200', '230000', '230100', '230125', '1', '1', '常安镇', '0', '', '1', '0', '0', '10'),
('9201', '230000', '230100', '230125', '1', '1', '永和乡', '0', '', '1', '0', '0', '10'),
('9202', '230000', '230100', '230125', '1', '1', '鸟河乡', '0', '', '1', '0', '0', '10'),
('9203', '230000', '230100', '230125', '1', '1', '民和乡', '0', '', '1', '0', '0', '10'),
('9204', '230000', '230100', '230125', '1', '1', '经建乡', '0', '', '1', '0', '0', '10'),
('9205', '230000', '230100', '230125', '1', '1', '三宝乡', '0', '', '1', '0', '0', '10'),
('9206', '230000', '230100', '230126', '1', '1', '巴彦镇', '0', '', '1', '0', '0', '10'),
('9207', '230000', '230100', '230126', '1', '1', '兴隆镇', '0', '', '1', '0', '0', '10'),
('9208', '230000', '230100', '230126', '1', '1', '西集镇', '0', '', '1', '0', '0', '10'),
('9209', '230000', '230100', '230126', '1', '1', '洼兴镇', '0', '', '1', '0', '0', '10'),
('9210', '230000', '230100', '230126', '1', '1', '龙泉镇', '0', '', '1', '0', '0', '10'),
('9211', '230000', '230100', '230126', '1', '1', '巴彦港镇', '0', '', '1', '0', '0', '10'),
('9212', '230000', '230100', '230126', '1', '1', '龙庙镇', '0', '', '1', '0', '0', '10'),
('9213', '230000', '230100', '230126', '1', '1', '万发镇', '0', '', '1', '0', '0', '10'),
('9214', '230000', '230100', '230126', '1', '1', '天增镇', '0', '', '1', '0', '0', '10'),
('9215', '230000', '230100', '230126', '1', '1', '黑山镇', '0', '', '1', '0', '0', '10'),
('9216', '230000', '230100', '230126', '1', '1', '松花江乡', '0', '', '1', '0', '0', '10'),
('9217', '230000', '230100', '230126', '1', '1', '富江乡', '0', '', '1', '0', '0', '10'),
('9218', '230000', '230100', '230126', '1', '1', '华山乡', '0', '', '1', '0', '0', '10'),
('9219', '230000', '230100', '230126', '1', '1', '丰乐乡', '0', '', '1', '0', '0', '10'),
('9220', '230000', '230100', '230126', '1', '1', '德祥乡', '0', '', '1', '0', '0', '10'),
('9221', '230000', '230100', '230126', '1', '1', '红光乡', '0', '', '1', '0', '0', '10'),
('9222', '230000', '230100', '230126', '1', '1', '山后乡', '0', '', '1', '0', '0', '10'),
('9223', '230000', '230100', '230126', '1', '1', '镇东乡', '0', '', '1', '0', '0', '10'),
('9224', '230000', '230100', '230126', '1', '1', '兴隆林业局', '0', '', '1', '0', '0', '10'),
('9225', '230000', '230100', '230127', '1', '1', '木兰镇', '0', '', '1', '0', '0', '10'),
('9226', '230000', '230100', '230127', '1', '1', '东兴镇', '0', '', '1', '0', '0', '10'),
('9227', '230000', '230100', '230127', '1', '1', '大贵镇', '0', '', '1', '0', '0', '10'),
('9228', '230000', '230100', '230127', '1', '1', '利东镇', '0', '', '1', '0', '0', '10'),
('9229', '230000', '230100', '230127', '1', '1', '柳河镇', '0', '', '1', '0', '0', '10'),
('9230', '230000', '230100', '230127', '1', '1', '新民镇', '0', '', '1', '0', '0', '10'),
('9231', '230000', '230100', '230127', '1', '1', '建国乡', '0', '', '1', '0', '0', '10'),
('9232', '230000', '230100', '230127', '1', '1', '吉兴乡', '0', '', '1', '0', '0', '10'),
('9233', '230000', '230100', '230127', '1', '1', '兴隆林业局', '0', '', '1', '0', '0', '10'),
('9234', '230000', '230100', '230128', '1', '1', '通河镇', '0', '', '1', '0', '0', '10'),
('9235', '230000', '230100', '230128', '1', '1', '乌鸦泡镇', '0', '', '1', '0', '0', '10'),
('9236', '230000', '230100', '230128', '1', '1', '清河镇', '0', '', '1', '0', '0', '10'),
('9237', '230000', '230100', '230128', '1', '1', '浓河镇', '0', '', '1', '0', '0', '10'),
('9238', '230000', '230100', '230128', '1', '1', '凤山镇', '0', '', '1', '0', '0', '10'),
('9239', '230000', '230100', '230128', '1', '1', '祥顺镇', '0', '', '1', '0', '0', '10'),
('9240', '230000', '230100', '230128', '1', '1', '三站乡', '0', '', '1', '0', '0', '10'),
('9241', '230000', '230100', '230128', '1', '1', '富林乡', '0', '', '1', '0', '0', '10'),
('9242', '230000', '230100', '230128', '1', '1', '清河林业局', '0', '', '1', '0', '0', '10'),
('9243', '230000', '230100', '230128', '1', '1', '兴隆林业局', '0', '', '1', '0', '0', '10'),
('9244', '230000', '230100', '230128', '1', '1', '岔林河农场', '0', '', '1', '0', '0', '10'),
('9245', '230000', '230100', '230129', '1', '1', '延寿镇', '0', '', '1', '0', '0', '10'),
('9246', '230000', '230100', '230129', '1', '1', '六团镇', '0', '', '1', '0', '0', '10'),
('9247', '230000', '230100', '230129', '1', '1', '中和镇', '0', '', '1', '0', '0', '10'),
('9248', '230000', '230100', '230129', '1', '1', '加信镇', '0', '', '1', '0', '0', '10'),
('9249', '230000', '230100', '230129', '1', '1', '延河镇', '0', '', '1', '0', '0', '10'),
('9250', '230000', '230100', '230129', '1', '1', '安山乡', '0', '', '1', '0', '0', '10'),
('9251', '230000', '230100', '230129', '1', '1', '寿山乡', '0', '', '1', '0', '0', '10'),
('9252', '230000', '230100', '230129', '1', '1', '玉河乡', '0', '', '1', '0', '0', '10'),
('9253', '230000', '230100', '230129', '1', '1', '青川乡', '0', '', '1', '0', '0', '10'),
('9254', '230000', '230100', '230129', '1', '1', '太平川', '0', '', '1', '0', '0', '10'),
('9255', '230000', '230100', '230129', '1', '1', '庆阳农场', '0', '', '1', '0', '0', '10'),
('9256', '230000', '230100', '230182', '1', '1', '双城市街道社区管委会', '0', '', '1', '0', '0', '10'),
('9257', '230000', '230100', '230182', '1', '1', '双城镇', '0', '', '1', '0', '0', '10'),
('9258', '230000', '230100', '230182', '1', '1', '兰棱镇', '0', '', '1', '0', '0', '10'),
('9259', '230000', '230100', '230182', '1', '1', '周家镇', '0', '', '1', '0', '0', '10'),
('9260', '230000', '230100', '230182', '1', '1', '五家镇', '0', '', '1', '0', '0', '10'),
('9261', '230000', '230100', '230182', '1', '1', '韩甸镇', '0', '', '1', '0', '0', '10'),
('9262', '230000', '230100', '230182', '1', '1', '单城镇', '0', '', '1', '0', '0', '10'),
('9263', '230000', '230100', '230182', '1', '1', '东官镇', '0', '', '1', '0', '0', '10'),
('9264', '230000', '230100', '230182', '1', '1', '农丰满族锡伯族镇', '0', '', '1', '0', '0', '10'),
('9265', '230000', '230100', '230182', '1', '1', '杏山镇', '0', '', '1', '0', '0', '10'),
('9266', '230000', '230100', '230182', '1', '1', '朝阳乡', '0', '', '1', '0', '0', '10'),
('9267', '230000', '230100', '230182', '1', '1', '金城乡', '0', '', '1', '0', '0', '10'),
('9268', '230000', '230100', '230182', '1', '1', '青岭满族乡', '0', '', '1', '0', '0', '10'),
('9269', '230000', '230100', '230182', '1', '1', '联兴满族乡', '0', '', '1', '0', '0', '10'),
('9270', '230000', '230100', '230182', '1', '1', '幸福满族乡', '0', '', '1', '0', '0', '10'),
('9271', '230000', '230100', '230182', '1', '1', '新兴满族乡', '0', '', '1', '0', '0', '10'),
('9272', '230000', '230100', '230182', '1', '1', '公正满族乡', '0', '', '1', '0', '0', '10'),
('9273', '230000', '230100', '230182', '1', '1', '永胜乡', '0', '', '1', '0', '0', '10'),
('9274', '230000', '230100', '230182', '1', '1', '临江乡', '0', '', '1', '0', '0', '10'),
('9275', '230000', '230100', '230182', '1', '1', '水泉乡', '0', '', '1', '0', '0', '10'),
('9276', '230000', '230100', '230182', '1', '1', '乐群满族乡', '0', '', '1', '0', '0', '10'),
('9277', '230000', '230100', '230182', '1', '1', '团结满族乡', '0', '', '1', '0', '0', '10'),
('9278', '230000', '230100', '230182', '1', '1', '万隆乡', '0', '', '1', '0', '0', '10'),
('9279', '230000', '230100', '230182', '1', '1', '希勤满族乡', '0', '', '1', '0', '0', '10'),
('9280', '230000', '230100', '230182', '1', '1', '同心满族乡', '0', '', '1', '0', '0', '10'),
('9281', '230000', '230100', '230183', '1', '1', '尚志镇', '0', '', '1', '0', '0', '10'),
('9282', '230000', '230100', '230183', '1', '1', '一面坡镇', '0', '', '1', '0', '0', '10'),
('9283', '230000', '230100', '230183', '1', '1', '苇河镇', '0', '', '1', '0', '0', '10'),
('9284', '230000', '230100', '230183', '1', '1', '亚布力镇', '0', '', '1', '0', '0', '10'),
('9285', '230000', '230100', '230183', '1', '1', '帽儿山镇', '0', '', '1', '0', '0', '10'),
('9286', '230000', '230100', '230183', '1', '1', '亮河镇', '0', '', '1', '0', '0', '10'),
('9287', '230000', '230100', '230183', '1', '1', '庆阳镇', '0', '', '1', '0', '0', '10'),
('9288', '230000', '230100', '230183', '1', '1', '石头河子镇', '0', '', '1', '0', '0', '10'),
('9289', '230000', '230100', '230183', '1', '1', '元宝镇', '0', '', '1', '0', '0', '10'),
('9290', '230000', '230100', '230183', '1', '1', '黑龙宫镇', '0', '', '1', '0', '0', '10'),
('9291', '230000', '230100', '230183', '1', '1', '长寿乡', '0', '', '1', '0', '0', '10'),
('9292', '230000', '230100', '230183', '1', '1', '乌吉密乡', '0', '', '1', '0', '0', '10'),
('9293', '230000', '230100', '230183', '1', '1', '鱼池乡', '0', '', '1', '0', '0', '10'),
('9294', '230000', '230100', '230183', '1', '1', '珍珠山乡', '0', '', '1', '0', '0', '10'),
('9295', '230000', '230100', '230183', '1', '1', '老街基乡', '0', '', '1', '0', '0', '10'),
('9296', '230000', '230100', '230183', '1', '1', '马延乡', '0', '', '1', '0', '0', '10'),
('9297', '230000', '230100', '230183', '1', '1', '河东乡', '0', '', '1', '0', '0', '10'),
('9298', '230000', '230100', '230183', '1', '1', '苇河林业局', '0', '', '1', '0', '0', '10'),
('9299', '230000', '230100', '230183', '1', '1', '亚布力林业局', '0', '', '1', '0', '0', '10'),
('9300', '230000', '230100', '230184', '1', '1', '五常镇', '0', '', '1', '0', '0', '10'),
('9301', '230000', '230100', '230184', '1', '1', '拉林满族镇', '0', '', '1', '0', '0', '10'),
('9302', '230000', '230100', '230184', '1', '1', '山河镇', '0', '', '1', '0', '0', '10'),
('9303', '230000', '230100', '230184', '1', '1', '小山子镇', '0', '', '1', '0', '0', '10'),
('9304', '230000', '230100', '230184', '1', '1', '安家镇', '0', '', '1', '0', '0', '10'),
('9305', '230000', '230100', '230184', '1', '1', '牛家满族镇', '0', '', '1', '0', '0', '10'),
('9306', '230000', '230100', '230184', '1', '1', '杜家镇', '0', '', '1', '0', '0', '10'),
('9307', '230000', '230100', '230184', '1', '1', '背荫河镇', '0', '', '1', '0', '0', '10'),
('9308', '230000', '230100', '230184', '1', '1', '冲河镇', '0', '', '1', '0', '0', '10'),
('9309', '230000', '230100', '230184', '1', '1', '沙河子镇', '0', '', '1', '0', '0', '10'),
('9310', '230000', '230100', '230184', '1', '1', '向阳镇', '0', '', '1', '0', '0', '10'),
('9311', '230000', '230100', '230184', '1', '1', '兴盛乡', '0', '', '1', '0', '0', '10'),
('9312', '230000', '230100', '230184', '1', '1', '志广乡', '0', '', '1', '0', '0', '10'),
('9313', '230000', '230100', '230184', '1', '1', '卫国乡', '0', '', '1', '0', '0', '10'),
('9314', '230000', '230100', '230184', '1', '1', '常堡乡', '0', '', '1', '0', '0', '10'),
('9315', '230000', '230100', '230184', '1', '1', '民意乡', '0', '', '1', '0', '0', '10'),
('9316', '230000', '230100', '230184', '1', '1', '龙凤山乡', '0', '', '1', '0', '0', '10'),
('9317', '230000', '230100', '230184', '1', '1', '红旗满族乡', '0', '', '1', '0', '0', '10'),
('9318', '230000', '230100', '230184', '1', '1', '八家子乡', '0', '', '1', '0', '0', '10'),
('9319', '230000', '230100', '230184', '1', '1', '民乐朝鲜族乡', '0', '', '1', '0', '0', '10'),
('9320', '230000', '230100', '230184', '1', '1', '营城子满族乡', '0', '', '1', '0', '0', '10'),
('9321', '230000', '230100', '230184', '1', '1', '长山乡', '0', '', '1', '0', '0', '10'),
('9322', '230000', '230100', '230184', '1', '1', '兴隆乡', '0', '', '1', '0', '0', '10'),
('9323', '230000', '230100', '230184', '1', '1', '二河乡', '0', '', '1', '0', '0', '10'),
('9324', '230000', '230100', '230184', '1', '1', '山河屯林业局', '0', '', '1', '0', '0', '10'),
('9325', '230000', '230200', '230202', '1', '1', '五龙街道', '0', '', '1', '0', '0', '10'),
('9326', '230000', '230200', '230202', '1', '1', '湖滨街道', '0', '', '1', '0', '0', '10'),
('9327', '230000', '230200', '230202', '1', '1', '江安街道', '0', '', '1', '0', '0', '10'),
('9328', '230000', '230200', '230202', '1', '1', '正阳街道', '0', '', '1', '0', '0', '10'),
('9329', '230000', '230200', '230202', '1', '1', '彩虹街道', '0', '', '1', '0', '0', '10'),
('9330', '230000', '230200', '230202', '1', '1', '南航街道', '0', '', '1', '0', '0', '10'),
('9331', '230000', '230200', '230202', '1', '1', '龙沙区直辖地域', '0', '', '1', '0', '0', '10'),
('9332', '230000', '230200', '230203', '1', '1', '中华街道', '0', '', '1', '0', '0', '10'),
('9333', '230000', '230200', '230203', '1', '1', '西大桥街道', '0', '', '1', '0', '0', '10'),
('9334', '230000', '230200', '230203', '1', '1', '卜奎街道', '0', '', '1', '0', '0', '10'),
('9335', '230000', '230200', '230203', '1', '1', '建设街道', '0', '', '1', '0', '0', '10'),
('9336', '230000', '230200', '230203', '1', '1', '文化街道', '0', '', '1', '0', '0', '10'),
('9337', '230000', '230200', '230203', '1', '1', '建华区直辖地域', '0', '', '1', '0', '0', '10'),
('9338', '230000', '230200', '230204', '1', '1', '站前街道', '0', '', '1', '0', '0', '10'),
('9339', '230000', '230200', '230204', '1', '1', '南浦街道', '0', '', '1', '0', '0', '10'),
('9340', '230000', '230200', '230204', '1', '1', '通东街道', '0', '', '1', '0', '0', '10'),
('9341', '230000', '230200', '230204', '1', '1', '光荣街道', '0', '', '1', '0', '0', '10'),
('9342', '230000', '230200', '230204', '1', '1', '龙华街道', '0', '', '1', '0', '0', '10'),
('9343', '230000', '230200', '230204', '1', '1', '北局宅街道', '0', '', '1', '0', '0', '10'),
('9344', '230000', '230200', '230204', '1', '1', '东湖街道', '0', '', '1', '0', '0', '10'),
('9345', '230000', '230200', '230204', '1', '1', '扎龙乡', '0', '', '1', '0', '0', '10'),
('9346', '230000', '230200', '230204', '1', '1', '齐齐哈尔种畜场', '0', '', '1', '0', '0', '10'),
('9347', '230000', '230200', '230205', '1', '1', '新兴街道', '0', '', '1', '0', '0', '10'),
('9348', '230000', '230200', '230205', '1', '1', '新建街道', '0', '', '1', '0', '0', '10'),
('9349', '230000', '230200', '230205', '1', '1', '林机街道', '0', '', '1', '0', '0', '10'),
('9350', '230000', '230200', '230205', '1', '1', '道北街道', '0', '', '1', '0', '0', '10'),
('9351', '230000', '230200', '230205', '1', '1', '水师营满族镇', '0', '', '1', '0', '0', '10'),
('9352', '230000', '230200', '230205', '1', '1', '三间房镇', '0', '', '1', '0', '0', '10'),
('9353', '230000', '230200', '230206', '1', '1', '红岸街道', '0', '', '1', '0', '0', '10'),
('9354', '230000', '230200', '230206', '1', '1', '沿江街道', '0', '', '1', '0', '0', '10'),
('9355', '230000', '230200', '230206', '1', '1', '电力街道', '0', '', '1', '0', '0', '10'),
('9356', '230000', '230200', '230206', '1', '1', '幸福街道', '0', '', '1', '0', '0', '10'),
('9357', '230000', '230200', '230206', '1', '1', '红宝石街道', '0', '', '1', '0', '0', '10'),
('9358', '230000', '230200', '230206', '1', '1', '北兴街道', '0', '', '1', '0', '0', '10'),
('9359', '230000', '230200', '230206', '1', '1', '铁北街道', '0', '', '1', '0', '0', '10'),
('9360', '230000', '230200', '230206', '1', '1', '长青乡', '0', '', '1', '0', '0', '10'),
('9361', '230000', '230200', '230206', '1', '1', '杜尔门沁达翰尔族乡', '0', '', '1', '0', '0', '10'),
('9362', '230000', '230200', '230207', '1', '1', '东安街道', '0', '', '1', '0', '0', '10'),
('9363', '230000', '230200', '230207', '1', '1', '富强街道', '0', '', '1', '0', '0', '10'),
('9364', '230000', '230200', '230207', '1', '1', '跃进街道', '0', '', '1', '0', '0', '10'),
('9365', '230000', '230200', '230207', '1', '1', '繁荣街道', '0', '', '1', '0', '0', '10'),
('9366', '230000', '230200', '230207', '1', '1', '碾子山区直辖地域', '0', '', '1', '0', '0', '10'),
('9367', '230000', '230200', '230208', '1', '1', '梅里斯街道', '0', '', '1', '0', '0', '10'),
('9368', '230000', '230200', '230208', '1', '1', '雅尔塞镇', '0', '', '1', '0', '0', '10'),
('9369', '230000', '230200', '230208', '1', '1', '卧牛吐镇', '0', '', '1', '0', '0', '10'),
('9370', '230000', '230200', '230208', '1', '1', '达呼店镇', '0', '', '1', '0', '0', '10'),
('9371', '230000', '230200', '230208', '1', '1', '共和镇', '0', '', '1', '0', '0', '10'),
('9372', '230000', '230200', '230208', '1', '1', '莽格吐乡', '0', '', '1', '0', '0', '10'),
('9373', '230000', '230200', '230208', '1', '1', '梅里斯乡', '0', '', '1', '0', '0', '10'),
('9374', '230000', '230200', '230208', '1', '1', '哈拉海农场', '0', '', '1', '0', '0', '10'),
('9375', '230000', '230200', '230221', '1', '1', '龙江镇', '0', '', '1', '0', '0', '10'),
('9376', '230000', '230200', '230221', '1', '1', '景星镇', '0', '', '1', '0', '0', '10'),
('9377', '230000', '230200', '230221', '1', '1', '龙兴镇', '0', '', '1', '0', '0', '10'),
('9378', '230000', '230200', '230221', '1', '1', '山泉镇', '0', '', '1', '0', '0', '10'),
('9379', '230000', '230200', '230221', '1', '1', '七棵树镇', '0', '', '1', '0', '0', '10'),
('9380', '230000', '230200', '230221', '1', '1', '白山乡', '0', '', '1', '0', '0', '10'),
('9381', '230000', '230200', '230221', '1', '1', '黑岗乡', '0', '', '1', '0', '0', '10'),
('9382', '230000', '230200', '230221', '1', '1', '广厚乡', '0', '', '1', '0', '0', '10'),
('9383', '230000', '230200', '230221', '1', '1', '华民乡', '0', '', '1', '0', '0', '10'),
('9384', '230000', '230200', '230221', '1', '1', '哈拉海乡', '0', '', '1', '0', '0', '10'),
('9385', '230000', '230200', '230221', '1', '1', '杏山乡', '0', '', '1', '0', '0', '10'),
('9386', '230000', '230200', '230221', '1', '1', '头站乡', '0', '', '1', '0', '0', '10'),
('9387', '230000', '230200', '230221', '1', '1', '鲁河乡', '0', '', '1', '0', '0', '10'),
('9388', '230000', '230200', '230221', '1', '1', '济沁河乡', '0', '', '1', '0', '0', '10'),
('9389', '230000', '230200', '230223', '1', '1', '依安镇', '0', '', '1', '0', '0', '10'),
('9390', '230000', '230200', '230223', '1', '1', '依龙镇', '0', '', '1', '0', '0', '10'),
('9391', '230000', '230200', '230223', '1', '1', '双阳镇', '0', '', '1', '0', '0', '10'),
('9392', '230000', '230200', '230223', '1', '1', '三兴镇', '0', '', '1', '0', '0', '10'),
('9393', '230000', '230200', '230223', '1', '1', '中心镇', '0', '', '1', '0', '0', '10'),
('9394', '230000', '230200', '230223', '1', '1', '富饶乡', '0', '', '1', '0', '0', '10'),
('9395', '230000', '230200', '230223', '1', '1', '解放乡', '0', '', '1', '0', '0', '10'),
('9396', '230000', '230200', '230223', '1', '1', '阳春乡', '0', '', '1', '0', '0', '10'),
('9397', '230000', '230200', '230223', '1', '1', '新发乡', '0', '', '1', '0', '0', '10'),
('9398', '230000', '230200', '230223', '1', '1', '太东乡', '0', '', '1', '0', '0', '10'),
('9399', '230000', '230200', '230223', '1', '1', '上游乡', '0', '', '1', '0', '0', '10'),
('9400', '230000', '230200', '230223', '1', '1', '红星乡', '0', '', '1', '0', '0', '10'),
('9401', '230000', '230200', '230223', '1', '1', '先锋乡', '0', '', '1', '0', '0', '10'),
('9402', '230000', '230200', '230223', '1', '1', '新屯乡', '0', '', '1', '0', '0', '10'),
('9403', '230000', '230200', '230223', '1', '1', '新兴乡', '0', '', '1', '0', '0', '10'),
('9404', '230000', '230200', '230223', '1', '1', '依安农场', '0', '', '1', '0', '0', '10'),
('9405', '230000', '230200', '230223', '1', '1', '黑龙江红旗马场', '0', '', '1', '0', '0', '10'),
('9406', '230000', '230200', '230224', '1', '1', '泰来镇', '0', '', '1', '0', '0', '10'),
('9407', '230000', '230200', '230224', '1', '1', '平洋镇', '0', '', '1', '0', '0', '10'),
('9408', '230000', '230200', '230224', '1', '1', '汤池镇', '0', '', '1', '0', '0', '10'),
('9409', '230000', '230200', '230224', '1', '1', '江桥蒙古族镇', '0', '', '1', '0', '0', '10'),
('9410', '230000', '230200', '230224', '1', '1', '塔子城镇', '0', '', '1', '0', '0', '10'),
('9411', '230000', '230200', '230224', '1', '1', '大兴镇', '0', '', '1', '0', '0', '10'),
('9412', '230000', '230200', '230224', '1', '1', '和平镇', '0', '', '1', '0', '0', '10'),
('9413', '230000', '230200', '230224', '1', '1', '克利镇', '0', '', '1', '0', '0', '10'),
('9414', '230000', '230200', '230224', '1', '1', '胜利蒙古族乡', '0', '', '1', '0', '0', '10'),
('9415', '230000', '230200', '230224', '1', '1', '宁姜蒙古族乡', '0', '', '1', '0', '0', '10'),
('9416', '230000', '230200', '230224', '1', '1', '葡萄场', '0', '', '1', '0', '0', '10'),
('9417', '230000', '230200', '230224', '1', '1', '果树场', '0', '', '1', '0', '0', '10'),
('9418', '230000', '230200', '230224', '1', '1', '泰来县一苗圃', '0', '', '1', '0', '0', '10'),
('9419', '230000', '230200', '230224', '1', '1', '泰来县二苗圃', '0', '', '1', '0', '0', '10'),
('9420', '230000', '230200', '230224', '1', '1', '东方红机械林场', '0', '', '1', '0', '0', '10'),
('9421', '230000', '230200', '230224', '1', '1', '泰来农场', '0', '', '1', '0', '0', '10'),
('9422', '230000', '230200', '230224', '1', '1', '第一良种场', '0', '', '1', '0', '0', '10'),
('9423', '230000', '230200', '230224', '1', '1', '第二良种场', '0', '', '1', '0', '0', '10'),
('9424', '230000', '230200', '230224', '1', '1', '宏胜种畜场', '0', '', '1', '0', '0', '10'),
('9425', '230000', '230200', '230224', '1', '1', '二龙涛农场', '0', '', '1', '0', '0', '10'),
('9426', '230000', '230200', '230224', '1', '1', '六三监狱', '0', '', '1', '0', '0', '10'),
('9427', '230000', '230200', '230225', '1', '1', '甘南镇', '0', '', '1', '0', '0', '10'),
('9428', '230000', '230200', '230225', '1', '1', '音河镇', '0', '', '1', '0', '0', '10'),
('9429', '230000', '230200', '230225', '1', '1', '平阳镇', '0', '', '1', '0', '0', '10'),
('9430', '230000', '230200', '230225', '1', '1', '东阳镇', '0', '', '1', '0', '0', '10'),
('9431', '230000', '230200', '230225', '1', '1', '巨宝镇', '0', '', '1', '0', '0', '10'),
('9432', '230000', '230200', '230225', '1', '1', '长山乡', '0', '', '1', '0', '0', '10'),
('9433', '230000', '230200', '230225', '1', '1', '中兴乡', '0', '', '1', '0', '0', '10'),
('9434', '230000', '230200', '230225', '1', '1', '兴隆乡', '0', '', '1', '0', '0', '10'),
('9435', '230000', '230200', '230225', '1', '1', '宝山乡', '0', '', '1', '0', '0', '10'),
('9436', '230000', '230200', '230225', '1', '1', '查哈阳乡', '0', '', '1', '0', '0', '10'),
('9437', '230000', '230200', '230225', '1', '1', '查哈阳农场', '0', '', '1', '0', '0', '10'),
('9438', '230000', '230200', '230225', '1', '1', '北京市双河农场', '0', '', '1', '0', '0', '10'),
('9439', '230000', '230200', '230227', '1', '1', '富裕镇', '0', '', '1', '0', '0', '10'),
('9440', '230000', '230200', '230227', '1', '1', '富路镇', '0', '', '1', '0', '0', '10'),
('9441', '230000', '230200', '230227', '1', '1', '富海镇', '0', '', '1', '0', '0', '10'),
('9442', '230000', '230200', '230227', '1', '1', '二道湾镇', '0', '', '1', '0', '0', '10'),
('9443', '230000', '230200', '230227', '1', '1', '龙安桥镇', '0', '', '1', '0', '0', '10'),
('9444', '230000', '230200', '230227', '1', '1', '繁荣乡', '0', '', '1', '0', '0', '10'),
('9445', '230000', '230200', '230227', '1', '1', '绍文乡', '0', '', '1', '0', '0', '10'),
('9446', '230000', '230200', '230227', '1', '1', '忠厚乡', '0', '', '1', '0', '0', '10'),
('9447', '230000', '230200', '230227', '1', '1', '友谊乡', '0', '', '1', '0', '0', '10'),
('9448', '230000', '230200', '230227', '1', '1', '塔哈乡', '0', '', '1', '0', '0', '10'),
('9449', '230000', '230200', '230227', '1', '1', '富裕牧场', '0', '', '1', '0', '0', '10'),
('9450', '230000', '230200', '230227', '1', '1', '繁荣种畜场', '0', '', '1', '0', '0', '10'),
('9451', '230000', '230200', '230229', '1', '1', '克山镇', '0', '', '1', '0', '0', '10'),
('9452', '230000', '230200', '230229', '1', '1', '北兴镇', '0', '', '1', '0', '0', '10'),
('9453', '230000', '230200', '230229', '1', '1', '西城镇', '0', '', '1', '0', '0', '10'),
('9454', '230000', '230200', '230229', '1', '1', '古城镇', '0', '', '1', '0', '0', '10'),
('9455', '230000', '230200', '230229', '1', '1', '北联镇', '0', '', '1', '0', '0', '10'),
('9456', '230000', '230200', '230229', '1', '1', '西河镇', '0', '', '1', '0', '0', '10'),
('9457', '230000', '230200', '230229', '1', '1', '河南乡', '0', '', '1', '0', '0', '10'),
('9458', '230000', '230200', '230229', '1', '1', '双河乡', '0', '', '1', '0', '0', '10'),
('9459', '230000', '230200', '230229', '1', '1', '河北乡', '0', '', '1', '0', '0', '10'),
('9460', '230000', '230200', '230229', '1', '1', '古北乡', '0', '', '1', '0', '0', '10'),
('9461', '230000', '230200', '230229', '1', '1', '西联乡', '0', '', '1', '0', '0', '10'),
('9462', '230000', '230200', '230229', '1', '1', '发展乡', '0', '', '1', '0', '0', '10'),
('9463', '230000', '230200', '230229', '1', '1', '西建乡', '0', '', '1', '0', '0', '10'),
('9464', '230000', '230200', '230229', '1', '1', '向华乡', '0', '', '1', '0', '0', '10'),
('9465', '230000', '230200', '230229', '1', '1', '曙光乡', '0', '', '1', '0', '0', '10'),
('9466', '230000', '230200', '230229', '1', '1', '克山县河北林场', '0', '', '1', '0', '0', '10'),
('9467', '230000', '230200', '230229', '1', '1', '克山县涌泉林场', '0', '', '1', '0', '0', '10'),
('9468', '230000', '230200', '230229', '1', '1', '克山县北联林场', '0', '', '1', '0', '0', '10'),
('9469', '230000', '230200', '230229', '1', '1', '克山农场', '0', '', '1', '0', '0', '10'),
('9470', '230000', '230200', '230229', '1', '1', '克山县第一良种场', '0', '', '1', '0', '0', '10'),
('9471', '230000', '230200', '230229', '1', '1', '克山县第二良种场', '0', '', '1', '0', '0', '10'),
('9472', '230000', '230200', '230229', '1', '1', '克山县种畜场', '0', '', '1', '0', '0', '10'),
('9473', '230000', '230200', '230229', '1', '1', '克山县种猪场', '0', '', '1', '0', '0', '10'),
('9474', '230000', '230200', '230230', '1', '1', '克东镇', '0', '', '1', '0', '0', '10'),
('9475', '230000', '230200', '230230', '1', '1', '宝泉镇', '0', '', '1', '0', '0', '10'),
('9476', '230000', '230200', '230230', '1', '1', '乾丰镇', '0', '', '1', '0', '0', '10'),
('9477', '230000', '230200', '230230', '1', '1', '玉岗镇', '0', '', '1', '0', '0', '10'),
('9478', '230000', '230200', '230230', '1', '1', '金城乡', '0', '', '1', '0', '0', '10'),
('9479', '230000', '230200', '230230', '1', '1', '润津乡', '0', '', '1', '0', '0', '10'),
('9480', '230000', '230200', '230230', '1', '1', '昌盛乡', '0', '', '1', '0', '0', '10'),
('9481', '230000', '230200', '230230', '1', '1', '第一苗圃', '0', '', '1', '0', '0', '10'),
('9482', '230000', '230200', '230230', '1', '1', '第二苗圃', '0', '', '1', '0', '0', '10'),
('9483', '230000', '230200', '230230', '1', '1', '爱华林场', '0', '', '1', '0', '0', '10'),
('9484', '230000', '230200', '230230', '1', '1', '发展林场', '0', '', '1', '0', '0', '10'),
('9485', '230000', '230200', '230230', '1', '1', '东兴林场', '0', '', '1', '0', '0', '10'),
('9486', '230000', '230200', '230230', '1', '1', '红旗奶山羊场', '0', '', '1', '0', '0', '10'),
('9487', '230000', '230200', '230230', '1', '1', '第一良种场', '0', '', '1', '0', '0', '10'),
('9488', '230000', '230200', '230230', '1', '1', '第二良种繁殖场', '0', '', '1', '0', '0', '10'),
('9489', '230000', '230200', '230230', '1', '1', '果树繁殖场', '0', '', '1', '0', '0', '10'),
('9490', '230000', '230200', '230230', '1', '1', '种猪场', '0', '', '1', '0', '0', '10'),
('9491', '230000', '230200', '230230', '1', '1', '建业农场', '0', '', '1', '0', '0', '10'),
('9492', '230000', '230200', '230231', '1', '1', '拜泉镇', '0', '', '1', '0', '0', '10'),
('9493', '230000', '230200', '230231', '1', '1', '三道镇', '0', '', '1', '0', '0', '10'),
('9494', '230000', '230200', '230231', '1', '1', '兴农镇', '0', '', '1', '0', '0', '10'),
('9495', '230000', '230200', '230231', '1', '1', '长春镇', '0', '', '1', '0', '0', '10'),
('9496', '230000', '230200', '230231', '1', '1', '龙泉镇', '0', '', '1', '0', '0', '10'),
('9497', '230000', '230200', '230231', '1', '1', '国富镇', '0', '', '1', '0', '0', '10'),
('9498', '230000', '230200', '230231', '1', '1', '富强镇', '0', '', '1', '0', '0', '10'),
('9499', '230000', '230200', '230231', '1', '1', '新生乡', '0', '', '1', '0', '0', '10'),
('9500', '230000', '230200', '230231', '1', '1', '兴国乡', '0', '', '1', '0', '0', '10'),
('9501', '230000', '230200', '230231', '1', '1', '上升乡', '0', '', '1', '0', '0', '10'),
('9502', '230000', '230200', '230231', '1', '1', '兴华乡', '0', '', '1', '0', '0', '10'),
('9503', '230000', '230200', '230231', '1', '1', '大众乡', '0', '', '1', '0', '0', '10'),
('9504', '230000', '230200', '230231', '1', '1', '丰产乡', '0', '', '1', '0', '0', '10'),
('9505', '230000', '230200', '230231', '1', '1', '永勤乡', '0', '', '1', '0', '0', '10'),
('9506', '230000', '230200', '230231', '1', '1', '爱农乡', '0', '', '1', '0', '0', '10'),
('9507', '230000', '230200', '230231', '1', '1', '时中乡', '0', '', '1', '0', '0', '10'),
('9508', '230000', '230200', '230281', '1', '1', '讷河镇', '0', '', '1', '0', '0', '10'),
('9509', '230000', '230200', '230281', '1', '1', '拉哈镇', '0', '', '1', '0', '0', '10'),
('9510', '230000', '230200', '230281', '1', '1', '二克浅镇', '0', '', '1', '0', '0', '10'),
('9511', '230000', '230200', '230281', '1', '1', '学田镇', '0', '', '1', '0', '0', '10'),
('9512', '230000', '230200', '230281', '1', '1', '龙河镇', '0', '', '1', '0', '0', '10'),
('9513', '230000', '230200', '230281', '1', '1', '讷南镇', '0', '', '1', '0', '0', '10'),
('9514', '230000', '230200', '230281', '1', '1', '六合镇', '0', '', '1', '0', '0', '10'),
('9515', '230000', '230200', '230281', '1', '1', '长发镇', '0', '', '1', '0', '0', '10'),
('9516', '230000', '230200', '230281', '1', '1', '通南镇', '0', '', '1', '0', '0', '10'),
('9517', '230000', '230200', '230281', '1', '1', '同义镇', '0', '', '1', '0', '0', '10'),
('9518', '230000', '230200', '230281', '1', '1', '九井镇', '0', '', '1', '0', '0', '10'),
('9519', '230000', '230200', '230281', '1', '1', '老莱镇', '0', '', '1', '0', '0', '10'),
('9520', '230000', '230200', '230281', '1', '1', '孔国乡', '0', '', '1', '0', '0', '10'),
('9521', '230000', '230200', '230281', '1', '1', '和盛乡', '0', '', '1', '0', '0', '10'),
('9522', '230000', '230200', '230281', '1', '1', '同心乡', '0', '', '1', '0', '0', '10'),
('9523', '230000', '230200', '230281', '1', '1', '兴旺鄂温克族乡', '0', '', '1', '0', '0', '10'),
('9524', '230000', '230200', '230281', '1', '1', '龙河镇保安林场', '0', '', '1', '0', '0', '10'),
('9525', '230000', '230200', '230281', '1', '1', '龙河镇茂山林场', '0', '', '1', '0', '0', '10'),
('9526', '230000', '230200', '230281', '1', '1', '龙河镇国庆林场', '0', '', '1', '0', '0', '10'),
('9527', '230000', '230200', '230281', '1', '1', '学田镇富源林场', '0', '', '1', '0', '0', '10'),
('9528', '230000', '230200', '230281', '1', '1', '老莱镇宽余林场', '0', '', '1', '0', '0', '10'),
('9529', '230000', '230200', '230281', '1', '1', '新江林场', '0', '', '1', '0', '0', '10'),
('9530', '230000', '230200', '230281', '1', '1', '讷河镇一良苗圃', '0', '', '1', '0', '0', '10'),
('9531', '230000', '230200', '230281', '1', '1', '黑龙江省老莱监狱', '0', '', '1', '0', '0', '10'),
('9532', '230000', '230200', '230281', '1', '1', '六合镇黎明奶牛场', '0', '', '1', '0', '0', '10'),
('9533', '230000', '230200', '230281', '1', '1', '孔国乡进化种猪场', '0', '', '1', '0', '0', '10'),
('9534', '230000', '230200', '230281', '1', '1', '二克浅镇二里种畜场', '0', '', '1', '0', '0', '10'),
('9535', '230000', '230200', '230281', '1', '1', '龙河镇青色草原种畜场', '0', '', '1', '0', '0', '10'),
('9536', '230000', '230200', '230281', '1', '1', '第一良种场', '0', '', '1', '0', '0', '10'),
('9537', '230000', '230200', '230281', '1', '1', '第二良种场', '0', '', '1', '0', '0', '10'),
('9538', '230000', '230200', '230281', '1', '1', '第三良种场', '0', '', '1', '0', '0', '10'),
('9539', '230000', '230200', '230281', '1', '1', '第四良种场', '0', '', '1', '0', '0', '10'),
('9540', '230000', '230300', '230302', '1', '1', '向阳街道', '0', '', '1', '0', '0', '10'),
('9541', '230000', '230300', '230302', '1', '1', '南山街道', '0', '', '1', '0', '0', '10'),
('9542', '230000', '230300', '230302', '1', '1', '立新街道', '0', '', '1', '0', '0', '10'),
('9543', '230000', '230300', '230302', '1', '1', '东风街道', '0', '', '1', '0', '0', '10'),
('9544', '230000', '230300', '230302', '1', '1', '红军路街道', '0', '', '1', '0', '0', '10'),
('9545', '230000', '230300', '230302', '1', '1', '西鸡西街道', '0', '', '1', '0', '0', '10'),
('9546', '230000', '230300', '230302', '1', '1', '西山街道', '0', '', '1', '0', '0', '10'),
('9547', '230000', '230300', '230302', '1', '1', '红星乡', '0', '', '1', '0', '0', '10'),
('9548', '230000', '230300', '230302', '1', '1', '西郊乡', '0', '', '1', '0', '0', '10'),
('9549', '230000', '230300', '230303', '1', '1', '桦木林街道', '0', '', '1', '0', '0', '10'),
('9550', '230000', '230300', '230303', '1', '1', '大恒山街道', '0', '', '1', '0', '0', '10'),
('9551', '230000', '230300', '230303', '1', '1', '小恒山街道', '0', '', '1', '0', '0', '10'),
('9552', '230000', '230300', '230303', '1', '1', '二道河子街道', '0', '', '1', '0', '0', '10'),
('9553', '230000', '230300', '230303', '1', '1', '张新街道', '0', '', '1', '0', '0', '10'),
('9554', '230000', '230300', '230303', '1', '1', '奋斗街道', '0', '', '1', '0', '0', '10'),
('9555', '230000', '230300', '230303', '1', '1', '柳毛街道', '0', '', '1', '0', '0', '10'),
('9556', '230000', '230300', '230303', '1', '1', '红旗乡', '0', '', '1', '0', '0', '10'),
('9557', '230000', '230300', '230303', '1', '1', '柳毛乡', '0', '', '1', '0', '0', '10'),
('9558', '230000', '230300', '230304', '1', '1', '东兴街道', '0', '', '1', '0', '0', '10'),
('9559', '230000', '230300', '230304', '1', '1', '矿里街道', '0', '', '1', '0', '0', '10'),
('9560', '230000', '230300', '230304', '1', '1', '洗煤街道', '0', '', '1', '0', '0', '10'),
('9561', '230000', '230300', '230304', '1', '1', '大通沟街道', '0', '', '1', '0', '0', '10'),
('9562', '230000', '230300', '230304', '1', '1', '滴道河乡', '0', '', '1', '0', '0', '10'),
('9563', '230000', '230300', '230304', '1', '1', '兰岭乡', '0', '', '1', '0', '0', '10'),
('9564', '230000', '230300', '230305', '1', '1', '街里街道', '0', '', '1', '0', '0', '10'),
('9565', '230000', '230300', '230305', '1', '1', '穆棱街道', '0', '', '1', '0', '0', '10'),
('9566', '230000', '230300', '230305', '1', '1', '平岗街道', '0', '', '1', '0', '0', '10'),
('9567', '230000', '230300', '230305', '1', '1', '碱场街道', '0', '', '1', '0', '0', '10'),
('9568', '230000', '230300', '230305', '1', '1', '石磷街道', '0', '', '1', '0', '0', '10'),
('9569', '230000', '230300', '230305', '1', '1', '梨树区直辖地域', '0', '', '1', '0', '0', '10'),
('9570', '230000', '230300', '230306', '1', '1', '城子河街道', '0', '', '1', '0', '0', '10'),
('9571', '230000', '230300', '230306', '1', '1', '正阳街道', '0', '', '1', '0', '0', '10'),
('9572', '230000', '230300', '230306', '1', '1', '东海街道', '0', '', '1', '0', '0', '10'),
('9573', '230000', '230300', '230306', '1', '1', '城西街道', '0', '', '1', '0', '0', '10'),
('9574', '230000', '230300', '230306', '1', '1', '杏花街道', '0', '', '1', '0', '0', '10'),
('9575', '230000', '230300', '230306', '1', '1', '长青乡', '0', '', '1', '0', '0', '10'),
('9576', '230000', '230300', '230306', '1', '1', '永丰乡', '0', '', '1', '0', '0', '10'),
('9577', '230000', '230300', '230307', '1', '1', '麻山街道', '0', '', '1', '0', '0', '10'),
('9578', '230000', '230300', '230307', '1', '1', '麻山区直辖地域', '0', '', '1', '0', '0', '10'),
('9579', '230000', '230300', '230321', '1', '1', '鸡东镇', '0', '', '1', '0', '0', '10'),
('9580', '230000', '230300', '230321', '1', '1', '平阳镇', '0', '', '1', '0', '0', '10'),
('9581', '230000', '230300', '230321', '1', '1', '向阳镇', '0', '', '1', '0', '0', '10'),
('9582', '230000', '230300', '230321', '1', '1', '哈达镇', '0', '', '1', '0', '0', '10'),
('9583', '230000', '230300', '230321', '1', '1', '永安镇', '0', '', '1', '0', '0', '10'),
('9584', '230000', '230300', '230321', '1', '1', '永和镇', '0', '', '1', '0', '0', '10'),
('9585', '230000', '230300', '230321', '1', '1', '东海镇', '0', '', '1', '0', '0', '10'),
('9586', '230000', '230300', '230321', '1', '1', '兴农镇', '0', '', '1', '0', '0', '10'),
('9587', '230000', '230300', '230321', '1', '1', '鸡林乡', '0', '', '1', '0', '0', '10'),
('9588', '230000', '230300', '230321', '1', '1', '明德乡', '0', '', '1', '0', '0', '10'),
('9589', '230000', '230300', '230321', '1', '1', '下亮子乡', '0', '', '1', '0', '0', '10'),
('9590', '230000', '230300', '230321', '1', '1', '林业局', '0', '', '1', '0', '0', '10'),
('9591', '230000', '230300', '230321', '1', '1', '八五一零农场', '0', '', '1', '0', '0', '10'),
('9592', '230000', '230300', '230381', '1', '1', '虎林镇', '0', '', '1', '0', '0', '10'),
('9593', '230000', '230300', '230381', '1', '1', '东方红镇', '0', '', '1', '0', '0', '10'),
('9594', '230000', '230300', '230381', '1', '1', '迎春镇', '0', '', '1', '0', '0', '10'),
('9595', '230000', '230300', '230381', '1', '1', '虎头镇', '0', '', '1', '0', '0', '10'),
('9596', '230000', '230300', '230381', '1', '1', '杨岗镇', '0', '', '1', '0', '0', '10'),
('9597', '230000', '230300', '230381', '1', '1', '东风镇', '0', '', '1', '0', '0', '10'),
('9598', '230000', '230300', '230381', '1', '1', '宝东镇', '0', '', '1', '0', '0', '10'),
('9599', '230000', '230300', '230381', '1', '1', '新乐乡', '0', '', '1', '0', '0', '10'),
('9600', '230000', '230300', '230381', '1', '1', '伟光乡', '0', '', '1', '0', '0', '10'),
('9601', '230000', '230300', '230381', '1', '1', '忠诚乡', '0', '', '1', '0', '0', '10'),
('9602', '230000', '230300', '230381', '1', '1', '珍宝岛乡', '0', '', '1', '0', '0', '10'),
('9603', '230000', '230300', '230381', '1', '1', '阿北乡', '0', '', '1', '0', '0', '10'),
('9604', '230000', '230300', '230381', '1', '1', '东方红林业局', '0', '', '1', '0', '0', '10'),
('9605', '230000', '230300', '230381', '1', '1', '迎春林业局', '0', '', '1', '0', '0', '10'),
('9606', '230000', '230300', '230381', '1', '1', '八五零农场', '0', '', '1', '0', '0', '10'),
('9607', '230000', '230300', '230381', '1', '1', '八五四农场', '0', '', '1', '0', '0', '10'),
('9608', '230000', '230300', '230381', '1', '1', '八五六农场', '0', '', '1', '0', '0', '10'),
('9609', '230000', '230300', '230381', '1', '1', '八五八农场', '0', '', '1', '0', '0', '10'),
('9610', '230000', '230300', '230381', '1', '1', '庆丰农场', '0', '', '1', '0', '0', '10'),
('9611', '230000', '230300', '230381', '1', '1', '云山农场', '0', '', '1', '0', '0', '10'),
('9612', '230000', '230300', '230382', '1', '1', '中心街道', '0', '', '1', '0', '0', '10'),
('9613', '230000', '230300', '230382', '1', '1', '密山镇', '0', '', '1', '0', '0', '10'),
('9614', '230000', '230300', '230382', '1', '1', '连珠山镇', '0', '', '1', '0', '0', '10'),
('9615', '230000', '230300', '230382', '1', '1', '当壁镇', '0', '', '1', '0', '0', '10'),
('9616', '230000', '230300', '230382', '1', '1', '知一镇', '0', '', '1', '0', '0', '10'),
('9617', '230000', '230300', '230382', '1', '1', '黑台镇', '0', '', '1', '0', '0', '10'),
('9618', '230000', '230300', '230382', '1', '1', '兴凯镇', '0', '', '1', '0', '0', '10'),
('9619', '230000', '230300', '230382', '1', '1', '裴德镇', '0', '', '1', '0', '0', '10'),
('9620', '230000', '230300', '230382', '1', '1', '柳毛乡', '0', '', '1', '0', '0', '10'),
('9621', '230000', '230300', '230382', '1', '1', '杨木乡', '0', '', '1', '0', '0', '10'),
('9622', '230000', '230300', '230382', '1', '1', '兴凯湖乡', '0', '', '1', '0', '0', '10'),
('9623', '230000', '230300', '230382', '1', '1', '承紫河乡', '0', '', '1', '0', '0', '10'),
('9624', '230000', '230300', '230382', '1', '1', '白泡子乡', '0', '', '1', '0', '0', '10'),
('9625', '230000', '230300', '230382', '1', '1', '二人班乡', '0', '', '1', '0', '0', '10'),
('9626', '230000', '230300', '230382', '1', '1', '太平乡', '0', '', '1', '0', '0', '10'),
('9627', '230000', '230300', '230382', '1', '1', '和平乡', '0', '', '1', '0', '0', '10'),
('9628', '230000', '230300', '230382', '1', '1', '富源乡', '0', '', '1', '0', '0', '10'),
('9629', '230000', '230300', '230382', '1', '1', '牡丹江分局局直', '0', '', '1', '0', '0', '10'),
('9630', '230000', '230300', '230382', '1', '1', '八五五农场', '0', '', '1', '0', '0', '10'),
('9631', '230000', '230300', '230382', '1', '1', '八五七农场', '0', '', '1', '0', '0', '10'),
('9632', '230000', '230300', '230382', '1', '1', '八五一一农场', '0', '', '1', '0', '0', '10'),
('9633', '230000', '230300', '230382', '1', '1', '兴凯湖农场', '0', '', '1', '0', '0', '10'),
('9634', '230000', '230400', '230402', '1', '1', '北山街道', '0', '', '1', '0', '0', '10'),
('9635', '230000', '230400', '230402', '1', '1', '红军街道', '0', '', '1', '0', '0', '10'),
('9636', '230000', '230400', '230402', '1', '1', '光明街道', '0', '', '1', '0', '0', '10'),
('9637', '230000', '230400', '230402', '1', '1', '胜利街道', '0', '', '1', '0', '0', '10'),
('9638', '230000', '230400', '230402', '1', '1', '南翼街道', '0', '', '1', '0', '0', '10'),
('9639', '230000', '230400', '230403', '1', '1', '育才街道', '0', '', '1', '0', '0', '10'),
('9640', '230000', '230400', '230403', '1', '1', '红旗街道', '0', '', '1', '0', '0', '10'),
('9641', '230000', '230400', '230403', '1', '1', '新南街道', '0', '', '1', '0', '0', '10'),
('9642', '230000', '230400', '230403', '1', '1', '湖滨街道', '0', '', '1', '0', '0', '10'),
('9643', '230000', '230400', '230403', '1', '1', '解放街道', '0', '', '1', '0', '0', '10'),
('9644', '230000', '230400', '230403', '1', '1', '团结街道', '0', '', '1', '0', '0', '10'),
('9645', '230000', '230400', '230404', '1', '1', '铁西街道', '0', '', '1', '0', '0', '10'),
('9646', '230000', '230400', '230404', '1', '1', '铁东街道', '0', '', '1', '0', '0', '10'),
('9647', '230000', '230400', '230404', '1', '1', '六号街道', '0', '', '1', '0', '0', '10'),
('9648', '230000', '230400', '230404', '1', '1', '大陆街道', '0', '', '1', '0', '0', '10'),
('9649', '230000', '230400', '230404', '1', '1', '富力街道', '0', '', '1', '0', '0', '10'),
('9650', '230000', '230400', '230404', '1', '1', '麓林山街道', '0', '', '1', '0', '0', '10'),
('9651', '230000', '230400', '230405', '1', '1', '兴安路街道', '0', '', '1', '0', '0', '10'),
('9652', '230000', '230400', '230405', '1', '1', '兴建路街道', '0', '', '1', '0', '0', '10'),
('9653', '230000', '230400', '230405', '1', '1', '兴长路街道', '0', '', '1', '0', '0', '10'),
('9654', '230000', '230400', '230405', '1', '1', '峻德路街道', '0', '', '1', '0', '0', '10'),
('9655', '230000', '230400', '230405', '1', '1', '河东路街道', '0', '', '1', '0', '0', '10'),
('9656', '230000', '230400', '230406', '1', '1', '工人村街道', '0', '', '1', '0', '0', '10'),
('9657', '230000', '230400', '230406', '1', '1', '新一街道', '0', '', '1', '0', '0', '10'),
('9658', '230000', '230400', '230406', '1', '1', '三街街道', '0', '', '1', '0', '0', '10'),
('9659', '230000', '230400', '230406', '1', '1', '东山街道', '0', '', '1', '0', '0', '10'),
('9660', '230000', '230400', '230406', '1', '1', '新华镇', '0', '', '1', '0', '0', '10'),
('9661', '230000', '230400', '230406', '1', '1', '红旗乡', '0', '', '1', '0', '0', '10'),
('9662', '230000', '230400', '230406', '1', '1', '蔬园乡', '0', '', '1', '0', '0', '10'),
('9663', '230000', '230400', '230406', '1', '1', '东方红乡', '0', '', '1', '0', '0', '10'),
('9664', '230000', '230400', '230406', '1', '1', '鹤岗市林业局', '0', '', '1', '0', '0', '10'),
('9665', '230000', '230400', '230406', '1', '1', '新华农场', '0', '', '1', '0', '0', '10'),
('9666', '230000', '230400', '230407', '1', '1', '岭北街道', '0', '', '1', '0', '0', '10'),
('9667', '230000', '230400', '230407', '1', '1', '岭南街道', '0', '', '1', '0', '0', '10'),
('9668', '230000', '230400', '230407', '1', '1', '沟北街道', '0', '', '1', '0', '0', '10'),
('9669', '230000', '230400', '230407', '1', '1', '沟南街道', '0', '', '1', '0', '0', '10'),
('9670', '230000', '230400', '230421', '1', '1', '凤翔镇', '0', '', '1', '0', '0', '10'),
('9671', '230000', '230400', '230421', '1', '1', '鹤北镇', '0', '', '1', '0', '0', '10'),
('9672', '230000', '230400', '230421', '1', '1', '名山镇', '0', '', '1', '0', '0', '10'),
('9673', '230000', '230400', '230421', '1', '1', '团结镇', '0', '', '1', '0', '0', '10'),
('9674', '230000', '230400', '230421', '1', '1', '肇兴镇', '0', '', '1', '0', '0', '10'),
('9675', '230000', '230400', '230421', '1', '1', '东明朝鲜族乡', '0', '', '1', '0', '0', '10'),
('9676', '230000', '230400', '230421', '1', '1', '太平沟乡', '0', '', '1', '0', '0', '10'),
('9677', '230000', '230400', '230421', '1', '1', '环山乡', '0', '', '1', '0', '0', '10'),
('9678', '230000', '230400', '230421', '1', '1', '鹤北林业局', '0', '', '1', '0', '0', '10'),
('9679', '230000', '230400', '230421', '1', '1', '宝泉岭分局局直', '0', '', '1', '0', '0', '10'),
('9680', '230000', '230400', '230421', '1', '1', '江滨农场', '0', '', '1', '0', '0', '10'),
('9681', '230000', '230400', '230421', '1', '1', '军川农场', '0', '', '1', '0', '0', '10'),
('9682', '230000', '230400', '230421', '1', '1', '名山农场', '0', '', '1', '0', '0', '10'),
('9683', '230000', '230400', '230421', '1', '1', '延军农场', '0', '', '1', '0', '0', '10'),
('9684', '230000', '230400', '230421', '1', '1', '共青农场', '0', '', '1', '0', '0', '10'),
('9685', '230000', '230400', '230421', '1', '1', '宝泉岭农场', '0', '', '1', '0', '0', '10'),
('9686', '230000', '230400', '230422', '1', '1', '绥滨镇', '0', '', '1', '0', '0', '10'),
('9687', '230000', '230400', '230422', '1', '1', '绥东镇', '0', '', '1', '0', '0', '10'),
('9688', '230000', '230400', '230422', '1', '1', '忠仁镇', '0', '', '1', '0', '0', '10'),
('9689', '230000', '230400', '230422', '1', '1', '连生乡', '0', '', '1', '0', '0', '10'),
('9690', '230000', '230400', '230422', '1', '1', '北岗乡', '0', '', '1', '0', '0', '10'),
('9691', '230000', '230400', '230422', '1', '1', '富强乡', '0', '', '1', '0', '0', '10'),
('9692', '230000', '230400', '230422', '1', '1', '北山乡', '0', '', '1', '0', '0', '10'),
('9693', '230000', '230400', '230422', '1', '1', '福兴乡', '0', '', '1', '0', '0', '10'),
('9694', '230000', '230400', '230422', '1', '1', '新富乡', '0', '', '1', '0', '0', '10'),
('9695', '230000', '230400', '230422', '1', '1', '二九０农场', '0', '', '1', '0', '0', '10'),
('9696', '230000', '230400', '230422', '1', '1', '绥滨农场', '0', '', '1', '0', '0', '10'),
('9697', '230000', '230400', '230422', '1', '1', '普阳农场', '0', '', '1', '0', '0', '10'),
('9698', '230000', '230500', '230502', '1', '1', '二马路街道', '0', '', '1', '0', '0', '10'),
('9699', '230000', '230500', '230502', '1', '1', '八马路街道', '0', '', '1', '0', '0', '10'),
('9700', '230000', '230500', '230502', '1', '1', '中心站街道', '0', '', '1', '0', '0', '10'),
('9701', '230000', '230500', '230502', '1', '1', '富安街道', '0', '', '1', '0', '0', '10'),
('9702', '230000', '230500', '230502', '1', '1', '窑地街道', '0', '', '1', '0', '0', '10'),
('9703', '230000', '230500', '230502', '1', '1', '长安街道', '0', '', '1', '0', '0', '10'),
('9704', '230000', '230500', '230502', '1', '1', '铁西街道', '0', '', '1', '0', '0', '10'),
('9705', '230000', '230500', '230502', '1', '1', '安邦乡', '0', '', '1', '0', '0', '10'),
('9706', '230000', '230500', '230503', '1', '1', '中山街道', '0', '', '1', '0', '0', '10'),
('9707', '230000', '230500', '230503', '1', '1', '北山街道', '0', '', '1', '0', '0', '10'),
('9708', '230000', '230500', '230503', '1', '1', '南山街道', '0', '', '1', '0', '0', '10'),
('9709', '230000', '230500', '230503', '1', '1', '东山街道', '0', '', '1', '0', '0', '10'),
('9710', '230000', '230500', '230503', '1', '1', '中心街道', '0', '', '1', '0', '0', '10'),
('9711', '230000', '230500', '230503', '1', '1', '西山街道', '0', '', '1', '0', '0', '10'),
('9712', '230000', '230500', '230503', '1', '1', '长胜乡', '0', '', '1', '0', '0', '10'),
('9713', '230000', '230500', '230503', '1', '1', '岭东区青山旅游公司', '0', '', '1', '0', '0', '10'),
('9714', '230000', '230500', '230503', '1', '1', '岭东区岭东经营所', '0', '', '1', '0', '0', '10'),
('9715', '230000', '230500', '230505', '1', '1', '振兴中路街道', '0', '', '1', '0', '0', '10'),
('9716', '230000', '230500', '230505', '1', '1', '振兴东路街道', '0', '', '1', '0', '0', '10'),
('9717', '230000', '230500', '230505', '1', '1', '集贤街道', '0', '', '1', '0', '0', '10'),
('9718', '230000', '230500', '230505', '1', '1', '东荣街道', '0', '', '1', '0', '0', '10'),
('9719', '230000', '230500', '230505', '1', '1', '太保镇', '0', '', '1', '0', '0', '10'),
('9720', '230000', '230500', '230506', '1', '1', '红旗街道', '0', '', '1', '0', '0', '10'),
('9721', '230000', '230500', '230506', '1', '1', '跃进街道', '0', '', '1', '0', '0', '10'),
('9722', '230000', '230500', '230506', '1', '1', '东保卫街道', '0', '', '1', '0', '0', '10'),
('9723', '230000', '230500', '230506', '1', '1', '七星街道', '0', '', '1', '0', '0', '10'),
('9724', '230000', '230500', '230506', '1', '1', '双阳街道', '0', '', '1', '0', '0', '10'),
('9725', '230000', '230500', '230506', '1', '1', '新安街道', '0', '', '1', '0', '0', '10'),
('9726', '230000', '230500', '230506', '1', '1', '电厂街道', '0', '', '1', '0', '0', '10'),
('9727', '230000', '230500', '230506', '1', '1', '七星镇', '0', '', '1', '0', '0', '10'),
('9728', '230000', '230500', '230506', '1', '1', '双鸭山林业局宝山经营所', '0', '', '1', '0', '0', '10'),
('9729', '230000', '230500', '230506', '1', '1', '双鸭山林业局大叶沟林场', '0', '', '1', '0', '0', '10'),
('9730', '230000', '230500', '230506', '1', '1', '双鸭山农场', '0', '', '1', '0', '0', '10'),
('9731', '230000', '230500', '230521', '1', '1', '福利镇', '0', '', '1', '0', '0', '10'),
('9732', '230000', '230500', '230521', '1', '1', '集贤镇', '0', '', '1', '0', '0', '10'),
('9733', '230000', '230500', '230521', '1', '1', '升昌镇', '0', '', '1', '0', '0', '10'),
('9734', '230000', '230500', '230521', '1', '1', '丰乐镇', '0', '', '1', '0', '0', '10'),
('9735', '230000', '230500', '230521', '1', '1', '太平镇', '0', '', '1', '0', '0', '10'),
('9736', '230000', '230500', '230521', '1', '1', '腰屯乡', '0', '', '1', '0', '0', '10'),
('9737', '230000', '230500', '230521', '1', '1', '兴安乡', '0', '', '1', '0', '0', '10'),
('9738', '230000', '230500', '230521', '1', '1', '永安乡', '0', '', '1', '0', '0', '10'),
('9739', '230000', '230500', '230521', '1', '1', '太平林场', '0', '', '1', '0', '0', '10'),
('9740', '230000', '230500', '230521', '1', '1', '丰乐林场', '0', '', '1', '0', '0', '10'),
('9741', '230000', '230500', '230521', '1', '1', '七星林场', '0', '', '1', '0', '0', '10'),
('9742', '230000', '230500', '230521', '1', '1', '峻山林场', '0', '', '1', '0', '0', '10'),
('9743', '230000', '230500', '230521', '1', '1', '爱林林场', '0', '', '1', '0', '0', '10'),
('9744', '230000', '230500', '230521', '1', '1', '腰屯林场', '0', '', '1', '0', '0', '10'),
('9745', '230000', '230500', '230521', '1', '1', '升平煤矿', '0', '', '1', '0', '0', '10'),
('9746', '230000', '230500', '230521', '1', '1', '二九一农场', '0', '', '1', '0', '0', '10'),
('9747', '230000', '230500', '230521', '1', '1', '良种场', '0', '', '1', '0', '0', '10'),
('9748', '230000', '230500', '230521', '1', '1', '种畜场', '0', '', '1', '0', '0', '10'),
('9749', '230000', '230500', '230521', '1', '1', '果树示范场', '0', '', '1', '0', '0', '10'),
('9750', '230000', '230500', '230521', '1', '1', '黑龙江省笔架山监狱', '0', '', '1', '0', '0', '10'),
('9751', '230000', '230500', '230522', '1', '1', '友谊镇', '0', '', '1', '0', '0', '10'),
('9752', '230000', '230500', '230522', '1', '1', '兴隆镇', '0', '', '1', '0', '0', '10'),
('9753', '230000', '230500', '230522', '1', '1', '龙山镇', '0', '', '1', '0', '0', '10'),
('9754', '230000', '230500', '230522', '1', '1', '凤岗镇', '0', '', '1', '0', '0', '10'),
('9755', '230000', '230500', '230522', '1', '1', '兴盛乡', '0', '', '1', '0', '0', '10'),
('9756', '230000', '230500', '230522', '1', '1', '东建乡', '0', '', '1', '0', '0', '10'),
('9757', '230000', '230500', '230522', '1', '1', '庆丰乡', '0', '', '1', '0', '0', '10'),
('9758', '230000', '230500', '230522', '1', '1', '建设乡', '0', '', '1', '0', '0', '10'),
('9759', '230000', '230500', '230522', '1', '1', '友邻乡', '0', '', '1', '0', '0', '10'),
('9760', '230000', '230500', '230522', '1', '1', '新镇乡', '0', '', '1', '0', '0', '10'),
('9761', '230000', '230500', '230522', '1', '1', '成富朝鲜族满族乡', '0', '', '1', '0', '0', '10'),
('9762', '230000', '230500', '230522', '1', '1', '红兴隆分局局直', '0', '', '1', '0', '0', '10'),
('9763', '230000', '230500', '230522', '1', '1', '友谊农场', '0', '', '1', '0', '0', '10'),
('9764', '230000', '230500', '230523', '1', '1', '宝清镇', '0', '', '1', '0', '0', '10'),
('9765', '230000', '230500', '230523', '1', '1', '七星泡镇', '0', '', '1', '0', '0', '10'),
('9766', '230000', '230500', '230523', '1', '1', '青原镇', '0', '', '1', '0', '0', '10'),
('9767', '230000', '230500', '230523', '1', '1', '夹信子镇', '0', '', '1', '0', '0', '10'),
('9768', '230000', '230500', '230523', '1', '1', '龙头镇', '0', '', '1', '0', '0', '10'),
('9769', '230000', '230500', '230523', '1', '1', '小城子镇', '0', '', '1', '0', '0', '10'),
('9770', '230000', '230500', '230523', '1', '1', '朝阳乡', '0', '', '1', '0', '0', '10'),
('9771', '230000', '230500', '230523', '1', '1', '万金山乡', '0', '', '1', '0', '0', '10'),
('9772', '230000', '230500', '230523', '1', '1', '尖山子乡', '0', '', '1', '0', '0', '10'),
('9773', '230000', '230500', '230523', '1', '1', '七星河乡', '0', '', '1', '0', '0', '10'),
('9774', '230000', '230500', '230523', '1', '1', '双鸭山林业局上游经营所', '0', '', '1', '0', '0', '10'),
('9775', '230000', '230500', '230523', '1', '1', '双鸭山林业局南瓮泉经营所', '0', '', '1', '0', '0', '10'),
('9776', '230000', '230500', '230523', '1', '1', '双鸭山林业局七一林场', '0', '', '1', '0', '0', '10'),
('9777', '230000', '230500', '230523', '1', '1', '双鸭山林业局七星河林场', '0', '', '1', '0', '0', '10'),
('9778', '230000', '230500', '230523', '1', '1', '双鸭山林业局红旗林场', '0', '', '1', '0', '0', '10'),
('9779', '230000', '230500', '230523', '1', '1', '双鸭山林业局三岔河林场', '0', '', '1', '0', '0', '10'),
('9780', '230000', '230500', '230523', '1', '1', '双鸭山林业局青龙林场', '0', '', '1', '0', '0', '10'),
('9781', '230000', '230500', '230523', '1', '1', '双鸭山林业局宝石经营所', '0', '', '1', '0', '0', '10'),
('9782', '230000', '230500', '230523', '1', '1', '双鸭山林业局七星河金矿', '0', '', '1', '0', '0', '10'),
('9783', '230000', '230500', '230523', '1', '1', '五九七农场', '0', '', '1', '0', '0', '10'),
('9784', '230000', '230500', '230523', '1', '1', '八五二农场', '0', '', '1', '0', '0', '10'),
('9785', '230000', '230500', '230523', '1', '1', '八五三农场', '0', '', '1', '0', '0', '10'),
('9786', '230000', '230500', '230524', '1', '1', '饶河镇', '0', '', '1', '0', '0', '10'),
('9787', '230000', '230500', '230524', '1', '1', '小佳河镇', '0', '', '1', '0', '0', '10'),
('9788', '230000', '230500', '230524', '1', '1', '西丰镇', '0', '', '1', '0', '0', '10'),
('9789', '230000', '230500', '230524', '1', '1', '五林洞镇', '0', '', '1', '0', '0', '10'),
('9790', '230000', '230500', '230524', '1', '1', '西林子乡', '0', '', '1', '0', '0', '10'),
('9791', '230000', '230500', '230524', '1', '1', '四排乡', '0', '', '1', '0', '0', '10'),
('9792', '230000', '230500', '230524', '1', '1', '大佳河乡', '0', '', '1', '0', '0', '10'),
('9793', '230000', '230500', '230524', '1', '1', '山里乡', '0', '', '1', '0', '0', '10'),
('9794', '230000', '230500', '230524', '1', '1', '大通河乡', '0', '', '1', '0', '0', '10'),
('9795', '230000', '230500', '230524', '1', '1', '小佳河林场', '0', '', '1', '0', '0', '10'),
('9796', '230000', '230500', '230524', '1', '1', '威山林场', '0', '', '1', '0', '0', '10'),
('9797', '230000', '230500', '230524', '1', '1', '西丰林场', '0', '', '1', '0', '0', '10'),
('9798', '230000', '230500', '230524', '1', '1', '大牙克林场', '0', '', '1', '0', '0', '10'),
('9799', '230000', '230500', '230524', '1', '1', '石场林场', '0', '', '1', '0', '0', '10'),
('9800', '230000', '230500', '230524', '1', '1', '宝马山林场', '0', '', '1', '0', '0', '10'),
('9801', '230000', '230500', '230524', '1', '1', '大岱林场', '0', '', '1', '0', '0', '10'),
('9802', '230000', '230500', '230524', '1', '1', '永幸林场', '0', '', '1', '0', '0', '10'),
('9803', '230000', '230500', '230524', '1', '1', '奇源林场', '0', '', '1', '0', '0', '10'),
('9804', '230000', '230500', '230524', '1', '1', '芦源林场', '0', '', '1', '0', '0', '10'),
('9805', '230000', '230500', '230524', '1', '1', '五林洞林场', '0', '', '1', '0', '0', '10'),
('9806', '230000', '230500', '230524', '1', '1', '饶河农场', '0', '', '1', '0', '0', '10'),
('9807', '230000', '230500', '230524', '1', '1', '红旗岭农场', '0', '', '1', '0', '0', '10'),
('9808', '230000', '230500', '230524', '1', '1', '八五九农场', '0', '', '1', '0', '0', '10'),
('9809', '230000', '230500', '230524', '1', '1', '胜利农场', '0', '', '1', '0', '0', '10'),
('9810', '230000', '230500', '230524', '1', '1', '红卫农场', '0', '', '1', '0', '0', '10'),
('9811', '230000', '230600', '230602', '1', '1', '萨尔图街道', '0', '', '1', '0', '0', '10'),
('9812', '230000', '230600', '230602', '1', '1', '铁人街道', '0', '', '1', '0', '0', '10'),
('9813', '230000', '230600', '230602', '1', '1', '友谊街道', '0', '', '1', '0', '0', '10'),
('9814', '230000', '230600', '230602', '1', '1', '富强街道', '0', '', '1', '0', '0', '10'),
('9815', '230000', '230600', '230602', '1', '1', '拥军街道', '0', '', '1', '0', '0', '10'),
('9816', '230000', '230600', '230602', '1', '1', '会战街道', '0', '', '1', '0', '0', '10'),
('9817', '230000', '230600', '230602', '1', '1', '火炬街道', '0', '', '1', '0', '0', '10'),
('9818', '230000', '230600', '230602', '1', '1', '东风街道', '0', '', '1', '0', '0', '10'),
('9819', '230000', '230600', '230602', '1', '1', '东安街道', '0', '', '1', '0', '0', '10'),
('9820', '230000', '230600', '230603', '1', '1', '龙凤街道', '0', '', '1', '0', '0', '10'),
('9821', '230000', '230600', '230603', '1', '1', '兴化街道', '0', '', '1', '0', '0', '10');
INSERT INTO `wst_communitys` VALUES ('9822', '230000', '230600', '230603', '1', '1', '卧里屯街道', '0', '', '1', '0', '0', '10'),
('9823', '230000', '230600', '230603', '1', '1', '东光街道', '0', '', '1', '0', '0', '10'),
('9824', '230000', '230600', '230603', '1', '1', '三永街道', '0', '', '1', '0', '0', '10'),
('9825', '230000', '230600', '230603', '1', '1', '开发区黎明街道', '0', '', '1', '0', '0', '10'),
('9826', '230000', '230600', '230603', '1', '1', '龙凤镇', '0', '', '1', '0', '0', '10'),
('9827', '230000', '230600', '230603', '1', '1', '高新区农场', '0', '', '1', '0', '0', '10'),
('9828', '230000', '230600', '230604', '1', '1', '龙岗街道', '0', '', '1', '0', '0', '10'),
('9829', '230000', '230600', '230604', '1', '1', '银浪街道', '0', '', '1', '0', '0', '10'),
('9830', '230000', '230600', '230604', '1', '1', '奋斗街道', '0', '', '1', '0', '0', '10'),
('9831', '230000', '230600', '230604', '1', '1', '庆新街道', '0', '', '1', '0', '0', '10'),
('9832', '230000', '230600', '230604', '1', '1', '西宾街道', '0', '', '1', '0', '0', '10'),
('9833', '230000', '230600', '230604', '1', '1', '乘风街道', '0', '', '1', '0', '0', '10'),
('9834', '230000', '230600', '230604', '1', '1', '喇嘛甸镇', '0', '', '1', '0', '0', '10'),
('9835', '230000', '230600', '230604', '1', '1', '红骥牧场', '0', '', '1', '0', '0', '10'),
('9836', '230000', '230600', '230604', '1', '1', '星火牧场', '0', '', '1', '0', '0', '10'),
('9837', '230000', '230600', '230604', '1', '1', '银浪牧场', '0', '', '1', '0', '0', '10'),
('9838', '230000', '230600', '230605', '1', '1', '红岗街道', '0', '', '1', '0', '0', '10'),
('9839', '230000', '230600', '230605', '1', '1', '八百垧街道', '0', '', '1', '0', '0', '10'),
('9840', '230000', '230600', '230605', '1', '1', '杏南街道', '0', '', '1', '0', '0', '10'),
('9841', '230000', '230600', '230605', '1', '1', '解放街道', '0', '', '1', '0', '0', '10'),
('9842', '230000', '230600', '230605', '1', '1', '创业街道', '0', '', '1', '0', '0', '10'),
('9843', '230000', '230600', '230605', '1', '1', '杏树岗镇', '0', '', '1', '0', '0', '10'),
('9844', '230000', '230600', '230606', '1', '1', '庆葡街道', '0', '', '1', '0', '0', '10'),
('9845', '230000', '230600', '230606', '1', '1', '高台子镇街道', '0', '', '1', '0', '0', '10'),
('9846', '230000', '230600', '230606', '1', '1', '林源镇街道', '0', '', '1', '0', '0', '10'),
('9847', '230000', '230600', '230606', '1', '1', '立志街道', '0', '', '1', '0', '0', '10'),
('9848', '230000', '230600', '230606', '1', '1', '新华街道', '0', '', '1', '0', '0', '10'),
('9849', '230000', '230600', '230606', '1', '1', '大同镇街道', '0', '', '1', '0', '0', '10'),
('9850', '230000', '230600', '230606', '1', '1', '大同镇', '0', '', '1', '0', '0', '10'),
('9851', '230000', '230600', '230606', '1', '1', '高台子镇', '0', '', '1', '0', '0', '10'),
('9852', '230000', '230600', '230606', '1', '1', '太阳升镇', '0', '', '1', '0', '0', '10'),
('9853', '230000', '230600', '230606', '1', '1', '林源镇', '0', '', '1', '0', '0', '10'),
('9854', '230000', '230600', '230606', '1', '1', '祝三乡', '0', '', '1', '0', '0', '10'),
('9855', '230000', '230600', '230606', '1', '1', '老山头乡', '0', '', '1', '0', '0', '10'),
('9856', '230000', '230600', '230606', '1', '1', '八井子乡', '0', '', '1', '0', '0', '10'),
('9857', '230000', '230600', '230606', '1', '1', '双榆树乡', '0', '', '1', '0', '0', '10'),
('9858', '230000', '230600', '230606', '1', '1', '和平牧场', '0', '', '1', '0', '0', '10'),
('9859', '230000', '230600', '230621', '1', '1', '肇州镇', '0', '', '1', '0', '0', '10'),
('9860', '230000', '230600', '230621', '1', '1', '永乐镇', '0', '', '1', '0', '0', '10'),
('9861', '230000', '230600', '230621', '1', '1', '丰乐镇', '0', '', '1', '0', '0', '10'),
('9862', '230000', '230600', '230621', '1', '1', '朝阳沟镇', '0', '', '1', '0', '0', '10'),
('9863', '230000', '230600', '230621', '1', '1', '兴城镇', '0', '', '1', '0', '0', '10'),
('9864', '230000', '230600', '230621', '1', '1', '二井镇', '0', '', '1', '0', '0', '10'),
('9865', '230000', '230600', '230621', '1', '1', '双发乡', '0', '', '1', '0', '0', '10'),
('9866', '230000', '230600', '230621', '1', '1', '托古乡', '0', '', '1', '0', '0', '10'),
('9867', '230000', '230600', '230621', '1', '1', '朝阳乡', '0', '', '1', '0', '0', '10'),
('9868', '230000', '230600', '230621', '1', '1', '永胜乡', '0', '', '1', '0', '0', '10'),
('9869', '230000', '230600', '230621', '1', '1', '榆树乡', '0', '', '1', '0', '0', '10'),
('9870', '230000', '230600', '230621', '1', '1', '新福乡', '0', '', '1', '0', '0', '10'),
('9871', '230000', '230600', '230621', '1', '1', '乐园良种场', '0', '', '1', '0', '0', '10'),
('9872', '230000', '230600', '230621', '1', '1', '卫星种畜场', '0', '', '1', '0', '0', '10'),
('9873', '230000', '230600', '230622', '1', '1', '肇源镇', '0', '', '1', '0', '0', '10'),
('9874', '230000', '230600', '230622', '1', '1', '三站镇', '0', '', '1', '0', '0', '10'),
('9875', '230000', '230600', '230622', '1', '1', '二站镇', '0', '', '1', '0', '0', '10'),
('9876', '230000', '230600', '230622', '1', '1', '茂兴镇', '0', '', '1', '0', '0', '10'),
('9877', '230000', '230600', '230622', '1', '1', '古龙镇', '0', '', '1', '0', '0', '10'),
('9878', '230000', '230600', '230622', '1', '1', '新站镇', '0', '', '1', '0', '0', '10'),
('9879', '230000', '230600', '230622', '1', '1', '头台镇', '0', '', '1', '0', '0', '10'),
('9880', '230000', '230600', '230622', '1', '1', '福兴乡', '0', '', '1', '0', '0', '10'),
('9881', '230000', '230600', '230622', '1', '1', '薄荷台乡', '0', '', '1', '0', '0', '10'),
('9882', '230000', '230600', '230622', '1', '1', '和平乡', '0', '', '1', '0', '0', '10'),
('9883', '230000', '230600', '230622', '1', '1', '古恰乡', '0', '', '1', '0', '0', '10'),
('9884', '230000', '230600', '230622', '1', '1', '超等乡', '0', '', '1', '0', '0', '10'),
('9885', '230000', '230600', '230622', '1', '1', '民意乡', '0', '', '1', '0', '0', '10'),
('9886', '230000', '230600', '230622', '1', '1', '义顺乡', '0', '', '1', '0', '0', '10'),
('9887', '230000', '230600', '230622', '1', '1', '浩德乡', '0', '', '1', '0', '0', '10'),
('9888', '230000', '230600', '230622', '1', '1', '大兴乡', '0', '', '1', '0', '0', '10'),
('9889', '230000', '230600', '230622', '1', '1', '肇源农场', '0', '', '1', '0', '0', '10'),
('9890', '230000', '230600', '230622', '1', '1', '种畜场', '0', '', '1', '0', '0', '10'),
('9891', '230000', '230600', '230622', '1', '1', '茂兴湖渔场', '0', '', '1', '0', '0', '10'),
('9892', '230000', '230600', '230622', '1', '1', '新立良种繁育场', '0', '', '1', '0', '0', '10'),
('9893', '230000', '230600', '230622', '1', '1', '立陡山良种场', '0', '', '1', '0', '0', '10'),
('9894', '230000', '230600', '230622', '1', '1', '八家河渔场', '0', '', '1', '0', '0', '10'),
('9895', '230000', '230600', '230622', '1', '1', '果树示范场', '0', '', '1', '0', '0', '10'),
('9896', '230000', '230600', '230622', '1', '1', '经济作物示范场', '0', '', '1', '0', '0', '10'),
('9897', '230000', '230600', '230623', '1', '1', '林甸镇', '0', '', '1', '0', '0', '10'),
('9898', '230000', '230600', '230623', '1', '1', '红旗镇', '0', '', '1', '0', '0', '10'),
('9899', '230000', '230600', '230623', '1', '1', '东兴乡', '0', '', '1', '0', '0', '10'),
('9900', '230000', '230600', '230623', '1', '1', '宏伟乡', '0', '', '1', '0', '0', '10'),
('9901', '230000', '230600', '230623', '1', '1', '三合乡', '0', '', '1', '0', '0', '10'),
('9902', '230000', '230600', '230623', '1', '1', '花园乡', '0', '', '1', '0', '0', '10'),
('9903', '230000', '230600', '230623', '1', '1', '四合乡', '0', '', '1', '0', '0', '10'),
('9904', '230000', '230600', '230623', '1', '1', '黎明乡', '0', '', '1', '0', '0', '10'),
('9905', '230000', '230600', '230623', '1', '1', '林甸县长青林场', '0', '', '1', '0', '0', '10'),
('9906', '230000', '230600', '230623', '1', '1', '巨浪牧场', '0', '', '1', '0', '0', '10'),
('9907', '230000', '230600', '230623', '1', '1', '黑龙江省林甸县国营苇场', '0', '', '1', '0', '0', '10'),
('9908', '230000', '230600', '230623', '1', '1', '林甸县新兴马场', '0', '', '1', '0', '0', '10'),
('9909', '230000', '230600', '230624', '1', '1', '泰康镇', '0', '', '1', '0', '0', '10'),
('9910', '230000', '230600', '230624', '1', '1', '胡吉吐莫镇', '0', '', '1', '0', '0', '10'),
('9911', '230000', '230600', '230624', '1', '1', '烟筒屯镇', '0', '', '1', '0', '0', '10'),
('9912', '230000', '230600', '230624', '1', '1', '他拉哈镇', '0', '', '1', '0', '0', '10'),
('9913', '230000', '230600', '230624', '1', '1', '一心乡', '0', '', '1', '0', '0', '10'),
('9914', '230000', '230600', '230624', '1', '1', '克尔台乡', '0', '', '1', '0', '0', '10'),
('9915', '230000', '230600', '230624', '1', '1', '白音诺勒乡', '0', '', '1', '0', '0', '10'),
('9916', '230000', '230600', '230624', '1', '1', '敖林西伯乡', '0', '', '1', '0', '0', '10'),
('9917', '230000', '230600', '230624', '1', '1', '巴彦查干乡', '0', '', '1', '0', '0', '10'),
('9918', '230000', '230600', '230624', '1', '1', '腰新乡', '0', '', '1', '0', '0', '10'),
('9919', '230000', '230600', '230624', '1', '1', '江湾乡', '0', '', '1', '0', '0', '10'),
('9920', '230000', '230600', '230624', '1', '1', '绿色草原牧场', '0', '', '1', '0', '0', '10'),
('9921', '230000', '230600', '230624', '1', '1', '黑龙江省大山种羊场', '0', '', '1', '0', '0', '10'),
('9922', '230000', '230600', '230624', '1', '1', '靠山种畜场', '0', '', '1', '0', '0', '10'),
('9923', '230000', '230600', '230624', '1', '1', '对山奶牛场', '0', '', '1', '0', '0', '10'),
('9924', '230000', '230600', '230624', '1', '1', '红旗种畜场', '0', '', '1', '0', '0', '10'),
('9925', '230000', '230600', '230624', '1', '1', '连环湖渔业有限公司', '0', '', '1', '0', '0', '10'),
('9926', '230000', '230600', '230624', '1', '1', '石人沟渔业有限公司', '0', '', '1', '0', '0', '10'),
('9927', '230000', '230600', '230624', '1', '1', '齐家泡渔业有限公司', '0', '', '1', '0', '0', '10'),
('9928', '230000', '230600', '230624', '1', '1', '四家子林场', '0', '', '1', '0', '0', '10'),
('9929', '230000', '230600', '230624', '1', '1', '新店林场', '0', '', '1', '0', '0', '10'),
('9930', '230000', '230600', '230624', '1', '1', '野生饲养场', '0', '', '1', '0', '0', '10'),
('9931', '230000', '230600', '230624', '1', '1', '第一良种场', '0', '', '1', '0', '0', '10'),
('9932', '230000', '230600', '230624', '1', '1', '一心苗圃', '0', '', '1', '0', '0', '10'),
('9933', '230000', '230600', '230624', '1', '1', '一心果树场', '0', '', '1', '0', '0', '10'),
('9934', '230000', '230700', '230702', '1', '1', '旭日街道', '0', '', '1', '0', '0', '10'),
('9935', '230000', '230700', '230702', '1', '1', '红升街道', '0', '', '1', '0', '0', '10'),
('9936', '230000', '230700', '230702', '1', '1', '前进街道', '0', '', '1', '0', '0', '10'),
('9937', '230000', '230700', '230702', '1', '1', '朝阳街道', '0', '', '1', '0', '0', '10'),
('9938', '230000', '230700', '230702', '1', '1', '东升街道', '0', '', '1', '0', '0', '10'),
('9939', '230000', '230700', '230703', '1', '1', '西水街道', '0', '', '1', '0', '0', '10'),
('9940', '230000', '230700', '230703', '1', '1', '联合街道', '0', '', '1', '0', '0', '10'),
('9941', '230000', '230700', '230703', '1', '1', '东升街道', '0', '', '1', '0', '0', '10'),
('9942', '230000', '230700', '230703', '1', '1', '晨明镇', '0', '', '1', '0', '0', '10'),
('9943', '230000', '230700', '230703', '1', '1', '浩良河镇', '0', '', '1', '0', '0', '10'),
('9944', '230000', '230700', '230703', '1', '1', '迎春乡', '0', '', '1', '0', '0', '10'),
('9945', '230000', '230700', '230703', '1', '1', '三岔河林场', '0', '', '1', '0', '0', '10'),
('9946', '230000', '230700', '230703', '1', '1', '四合营林场', '0', '', '1', '0', '0', '10'),
('9947', '230000', '230700', '230703', '1', '1', '亮子河林场', '0', '', '1', '0', '0', '10'),
('9948', '230000', '230700', '230703', '1', '1', '石头河林场', '0', '', '1', '0', '0', '10'),
('9949', '230000', '230700', '230703', '1', '1', '岩石经营所', '0', '', '1', '0', '0', '10'),
('9950', '230000', '230700', '230703', '1', '1', '奋斗经营所', '0', '', '1', '0', '0', '10'),
('9951', '230000', '230700', '230703', '1', '1', '桦阳经营所', '0', '', '1', '0', '0', '10'),
('9952', '230000', '230700', '230703', '1', '1', '浩良河经营所', '0', '', '1', '0', '0', '10'),
('9953', '230000', '230700', '230703', '1', '1', '太平经营所', '0', '', '1', '0', '0', '10'),
('9954', '230000', '230700', '230703', '1', '1', '南岔经营所', '0', '', '1', '0', '0', '10'),
('9955', '230000', '230700', '230703', '1', '1', '威岭经营所', '0', '', '1', '0', '0', '10'),
('9956', '230000', '230700', '230703', '1', '1', '松青经营所', '0', '', '1', '0', '0', '10'),
('9957', '230000', '230700', '230703', '1', '1', '柳树经营所', '0', '', '1', '0', '0', '10'),
('9958', '230000', '230700', '230704', '1', '1', '友好街道', '0', '', '1', '0', '0', '10'),
('9959', '230000', '230700', '230704', '1', '1', '双子河街道', '0', '', '1', '0', '0', '10'),
('9960', '230000', '230700', '230704', '1', '1', '铁林街道', '0', '', '1', '0', '0', '10'),
('9961', '230000', '230700', '230704', '1', '1', '三合经营所', '0', '', '1', '0', '0', '10'),
('9962', '230000', '230700', '230704', '1', '1', '松园林场', '0', '', '1', '0', '0', '10'),
('9963', '230000', '230700', '230704', '1', '1', '中心经营所', '0', '', '1', '0', '0', '10'),
('9964', '230000', '230700', '230704', '1', '1', '永青经营所', '0', '', '1', '0', '0', '10'),
('9965', '230000', '230700', '230704', '1', '1', '碧云经营所', '0', '', '1', '0', '0', '10'),
('9966', '230000', '230700', '230704', '1', '1', '友谊经营所', '0', '', '1', '0', '0', '10'),
('9967', '230000', '230700', '230704', '1', '1', '青杨经营所', '0', '', '1', '0', '0', '10'),
('9968', '230000', '230700', '230704', '1', '1', '岭峰林场', '0', '', '1', '0', '0', '10'),
('9969', '230000', '230700', '230704', '1', '1', '奋斗林场', '0', '', '1', '0', '0', '10'),
('9970', '230000', '230700', '230704', '1', '1', '东卡林场', '0', '', '1', '0', '0', '10'),
('9971', '230000', '230700', '230704', '1', '1', '鸡爪河林场', '0', '', '1', '0', '0', '10'),
('9972', '230000', '230700', '230704', '1', '1', '绿源林场', '0', '', '1', '0', '0', '10'),
('9973', '230000', '230700', '230704', '1', '1', '广川经营所', '0', '', '1', '0', '0', '10'),
('9974', '230000', '230700', '230704', '1', '1', '朝阳经营所', '0', '', '1', '0', '0', '10'),
('9975', '230000', '230700', '230705', '1', '1', '西林街道', '0', '', '1', '0', '0', '10'),
('9976', '230000', '230700', '230705', '1', '1', '新兴街道', '0', '', '1', '0', '0', '10'),
('9977', '230000', '230700', '230705', '1', '1', '苔青街道', '0', '', '1', '0', '0', '10'),
('9978', '230000', '230700', '230706', '1', '1', '向阳街道', '0', '', '1', '0', '0', '10'),
('9979', '230000', '230700', '230706', '1', '1', '曙光街道', '0', '', '1', '0', '0', '10'),
('9980', '230000', '230700', '230706', '1', '1', '解放经营所', '0', '', '1', '0', '0', '10'),
('9981', '230000', '230700', '230706', '1', '1', '昆仑气林场', '0', '', '1', '0', '0', '10'),
('9982', '230000', '230700', '230706', '1', '1', '开源河林场', '0', '', '1', '0', '0', '10'),
('9983', '230000', '230700', '230706', '1', '1', '么河经营所', '0', '', '1', '0', '0', '10'),
('9984', '230000', '230700', '230706', '1', '1', '冲锋经营所', '0', '', '1', '0', '0', '10'),
('9985', '230000', '230700', '230706', '1', '1', '翠峦河经营所', '0', '', '1', '0', '0', '10'),
('9986', '230000', '230700', '230706', '1', '1', '抚育河经营所', '0', '', '1', '0', '0', '10'),
('9987', '230000', '230700', '230706', '1', '1', '尖山河经营所', '0', '', '1', '0', '0', '10'),
('9988', '230000', '230700', '230707', '1', '1', '新青街道', '0', '', '1', '0', '0', '10'),
('9989', '230000', '230700', '230707', '1', '1', '兴安街道', '0', '', '1', '0', '0', '10'),
('9990', '230000', '230700', '230707', '1', '1', '红林经营所', '0', '', '1', '0', '0', '10'),
('9991', '230000', '230700', '230707', '1', '1', '松林林场', '0', '', '1', '0', '0', '10'),
('9992', '230000', '230700', '230707', '1', '1', '泉林林场', '0', '', '1', '0', '0', '10'),
('9993', '230000', '230700', '230707', '1', '1', '水源林场', '0', '', '1', '0', '0', '10'),
('9994', '230000', '230700', '230707', '1', '1', '笑山林场', '0', '', '1', '0', '0', '10'),
('9995', '230000', '230700', '230707', '1', '1', '汤林林场', '0', '', '1', '0', '0', '10'),
('9996', '230000', '230700', '230707', '1', '1', '桦林经营所', '0', '', '1', '0', '0', '10'),
('9997', '230000', '230700', '230707', '1', '1', '青林林场', '0', '', '1', '0', '0', '10'),
('9998', '230000', '230700', '230707', '1', '1', '结源林场', '0', '', '1', '0', '0', '10'),
('9999', '230000', '230700', '230707', '1', '1', '北沟林场', '0', '', '1', '0', '0', '10'),
('10000', '230000', '230700', '230707', '1', '1', '南沟林场', '0', '', '1', '0', '0', '10'),
('10001', '230000', '230700', '230707', '1', '1', '乌拉嘎经营所', '0', '', '1', '0', '0', '10'),
('10002', '230000', '230700', '230707', '1', '1', '柳树河林场', '0', '', '1', '0', '0', '10'),
('10003', '230000', '230700', '230707', '1', '1', '北影林场', '0', '', '1', '0', '0', '10'),
('10004', '230000', '230700', '230708', '1', '1', '美溪街道', '0', '', '1', '0', '0', '10'),
('10005', '230000', '230700', '230708', '1', '1', '大西林林场', '0', '', '1', '0', '0', '10'),
('10006', '230000', '230700', '230708', '1', '1', '五道库经营所', '0', '', '1', '0', '0', '10'),
('10007', '230000', '230700', '230708', '1', '1', '缓岭经营所', '0', '', '1', '0', '0', '10'),
('10008', '230000', '230700', '230708', '1', '1', '对青山经营所', '0', '', '1', '0', '0', '10'),
('10009', '230000', '230700', '230708', '1', '1', '群峦经营所', '0', '', '1', '0', '0', '10'),
('10010', '230000', '230700', '230708', '1', '1', '兰新经营所', '0', '', '1', '0', '0', '10'),
('10011', '230000', '230700', '230708', '1', '1', '顺利河林场', '0', '', '1', '0', '0', '10'),
('10012', '230000', '230700', '230708', '1', '1', '松岭经营所', '0', '', '1', '0', '0', '10'),
('10013', '230000', '230700', '230708', '1', '1', '青山口林场', '0', '', '1', '0', '0', '10'),
('10014', '230000', '230700', '230708', '1', '1', '金沙河林场', '0', '', '1', '0', '0', '10'),
('10015', '230000', '230700', '230708', '1', '1', '桦皮羌子林场', '0', '', '1', '0', '0', '10'),
('10016', '230000', '230700', '230708', '1', '1', '碧仓库林场', '0', '', '1', '0', '0', '10'),
('10017', '230000', '230700', '230708', '1', '1', '三股流经营所', '0', '', '1', '0', '0', '10'),
('10018', '230000', '230700', '230708', '1', '1', '卧龙河林场', '0', '', '1', '0', '0', '10'),
('10019', '230000', '230700', '230709', '1', '1', '奋斗街道', '0', '', '1', '0', '0', '10'),
('10020', '230000', '230700', '230709', '1', '1', '金山街道', '0', '', '1', '0', '0', '10'),
('10021', '230000', '230700', '230709', '1', '1', '白山林场', '0', '', '1', '0', '0', '10'),
('10022', '230000', '230700', '230709', '1', '1', '丰岭林场', '0', '', '1', '0', '0', '10'),
('10023', '230000', '230700', '230709', '1', '1', '丰林林场', '0', '', '1', '0', '0', '10'),
('10024', '230000', '230700', '230709', '1', '1', '丰沟经营所', '0', '', '1', '0', '0', '10'),
('10025', '230000', '230700', '230709', '1', '1', '丰茂林场', '0', '', '1', '0', '0', '10'),
('10026', '230000', '230700', '230709', '1', '1', '横山经营所', '0', '', '1', '0', '0', '10'),
('10027', '230000', '230700', '230709', '1', '1', '丰丽林场', '0', '', '1', '0', '0', '10'),
('10028', '230000', '230700', '230709', '1', '1', '大昆仑经营所', '0', '', '1', '0', '0', '10'),
('10029', '230000', '230700', '230709', '1', '1', '小昆仑林场', '0', '', '1', '0', '0', '10'),
('10030', '230000', '230700', '230709', '1', '1', '育林经营所', '0', '', '1', '0', '0', '10'),
('10031', '230000', '230700', '230710', '1', '1', '五营街道', '0', '', '1', '0', '0', '10'),
('10032', '230000', '230700', '230710', '1', '1', '五星街道', '0', '', '1', '0', '0', '10'),
('10033', '230000', '230700', '230710', '1', '1', '翠北林场', '0', '', '1', '0', '0', '10'),
('10034', '230000', '230700', '230710', '1', '1', '前丰林场', '0', '', '1', '0', '0', '10'),
('10035', '230000', '230700', '230710', '1', '1', '永丰经营所', '0', '', '1', '0', '0', '10'),
('10036', '230000', '230700', '230710', '1', '1', '平原经营所', '0', '', '1', '0', '0', '10'),
('10037', '230000', '230700', '230710', '1', '1', '丽丰经营所', '0', '', '1', '0', '0', '10'),
('10038', '230000', '230700', '230710', '1', '1', '杨树河经营所', '0', '', '1', '0', '0', '10'),
('10039', '230000', '230700', '230710', '1', '1', '平山经营所', '0', '', '1', '0', '0', '10'),
('10040', '230000', '230700', '230710', '1', '1', '丽林经营所', '0', '', '1', '0', '0', '10'),
('10041', '230000', '230700', '230711', '1', '1', '乌马河街道', '0', '', '1', '0', '0', '10'),
('10042', '230000', '230700', '230711', '1', '1', '伊敏林场', '0', '', '1', '0', '0', '10'),
('10043', '230000', '230700', '230711', '1', '1', '伊东经营所', '0', '', '1', '0', '0', '10'),
('10044', '230000', '230700', '230711', '1', '1', '东方红经营所', '0', '', '1', '0', '0', '10'),
('10045', '230000', '230700', '230711', '1', '1', '翠岭经营所', '0', '', '1', '0', '0', '10'),
('10046', '230000', '230700', '230711', '1', '1', '河北经营所', '0', '', '1', '0', '0', '10'),
('10047', '230000', '230700', '230711', '1', '1', '青山林场', '0', '', '1', '0', '0', '10'),
('10048', '230000', '230700', '230711', '1', '1', '育苗经营所', '0', '', '1', '0', '0', '10'),
('10049', '230000', '230700', '230711', '1', '1', '安全经营所', '0', '', '1', '0', '0', '10'),
('10050', '230000', '230700', '230711', '1', '1', '伊青经营所', '0', '', '1', '0', '0', '10'),
('10051', '230000', '230700', '230711', '1', '1', '前进经营所', '0', '', '1', '0', '0', '10'),
('10052', '230000', '230700', '230711', '1', '1', '西岭林场', '0', '', '1', '0', '0', '10'),
('10053', '230000', '230700', '230711', '1', '1', '伊林经营所', '0', '', '1', '0', '0', '10'),
('10054', '230000', '230700', '230712', '1', '1', '河南街道', '0', '', '1', '0', '0', '10'),
('10055', '230000', '230700', '230712', '1', '1', '河北街道', '0', '', '1', '0', '0', '10'),
('10056', '230000', '230700', '230712', '1', '1', '日新林场', '0', '', '1', '0', '0', '10'),
('10057', '230000', '230700', '230712', '1', '1', '石林林场', '0', '', '1', '0', '0', '10'),
('10058', '230000', '230700', '230712', '1', '1', '东升林场', '0', '', '1', '0', '0', '10'),
('10059', '230000', '230700', '230712', '1', '1', '二龙山林场', '0', '', '1', '0', '0', '10'),
('10060', '230000', '230700', '230712', '1', '1', '高峰林场', '0', '', '1', '0', '0', '10'),
('10061', '230000', '230700', '230712', '1', '1', '二清河林场', '0', '', '1', '0', '0', '10'),
('10062', '230000', '230700', '230712', '1', '1', '守虎山林场', '0', '', '1', '0', '0', '10'),
('10063', '230000', '230700', '230712', '1', '1', '泉石林场', '0', '', '1', '0', '0', '10'),
('10064', '230000', '230700', '230712', '1', '1', '峻岭林场', '0', '', '1', '0', '0', '10'),
('10065', '230000', '230700', '230712', '1', '1', '育林经营所', '0', '', '1', '0', '0', '10'),
('10066', '230000', '230700', '230712', '1', '1', '团结经营所', '0', '', '1', '0', '0', '10'),
('10067', '230000', '230700', '230712', '1', '1', '磨石山经营所', '0', '', '1', '0', '0', '10'),
('10068', '230000', '230700', '230712', '1', '1', '中心苗卜', '0', '', '1', '0', '0', '10'),
('10069', '230000', '230700', '230712', '1', '1', '克林经营所', '0', '', '1', '0', '0', '10'),
('10070', '230000', '230700', '230713', '1', '1', '带岭街道', '0', '', '1', '0', '0', '10'),
('10071', '230000', '230700', '230713', '1', '1', '大青川林场', '0', '', '1', '0', '0', '10'),
('10072', '230000', '230700', '230713', '1', '1', '东方红林场', '0', '', '1', '0', '0', '10'),
('10073', '230000', '230700', '230713', '1', '1', '秀水林场', '0', '', '1', '0', '0', '10'),
('10074', '230000', '230700', '230713', '1', '1', '永翠林场', '0', '', '1', '0', '0', '10'),
('10075', '230000', '230700', '230713', '1', '1', '明月林场', '0', '', '1', '0', '0', '10'),
('10076', '230000', '230700', '230713', '1', '1', '红光林场', '0', '', '1', '0', '0', '10'),
('10077', '230000', '230700', '230713', '1', '1', '碧水林场', '0', '', '1', '0', '0', '10'),
('10078', '230000', '230700', '230713', '1', '1', '北列林场', '0', '', '1', '0', '0', '10'),
('10079', '230000', '230700', '230713', '1', '1', '南列林场', '0', '', '1', '0', '0', '10'),
('10080', '230000', '230700', '230713', '1', '1', '寒月林场', '0', '', '1', '0', '0', '10'),
('10081', '230000', '230700', '230713', '1', '1', '环山林场', '0', '', '1', '0', '0', '10'),
('10082', '230000', '230700', '230714', '1', '1', '乌伊岭街道', '0', '', '1', '0', '0', '10'),
('10083', '230000', '230700', '230714', '1', '1', '上游林场', '0', '', '1', '0', '0', '10'),
('10084', '230000', '230700', '230714', '1', '1', '美峰林场', '0', '', '1', '0', '0', '10'),
('10085', '230000', '230700', '230714', '1', '1', '翠峰林场', '0', '', '1', '0', '0', '10'),
('10086', '230000', '230700', '230714', '1', '1', '建新林场', '0', '', '1', '0', '0', '10'),
('10087', '230000', '230700', '230714', '1', '1', '移山林场', '0', '', '1', '0', '0', '10'),
('10088', '230000', '230700', '230714', '1', '1', '林海林场', '0', '', '1', '0', '0', '10'),
('10089', '230000', '230700', '230714', '1', '1', '桔源林场', '0', '', '1', '0', '0', '10'),
('10090', '230000', '230700', '230714', '1', '1', '东克林林场', '0', '', '1', '0', '0', '10'),
('10091', '230000', '230700', '230714', '1', '1', '福民林场', '0', '', '1', '0', '0', '10'),
('10092', '230000', '230700', '230714', '1', '1', '阿廷河林场', '0', '', '1', '0', '0', '10'),
('10093', '230000', '230700', '230714', '1', '1', '永胜经营所', '0', '', '1', '0', '0', '10'),
('10094', '230000', '230700', '230714', '1', '1', '前卫林场', '0', '', '1', '0', '0', '10'),
('10095', '230000', '230700', '230715', '1', '1', '红星街道', '0', '', '1', '0', '0', '10'),
('10096', '230000', '230700', '230715', '1', '1', '清水河经营所', '0', '', '1', '0', '0', '10'),
('10097', '230000', '230700', '230715', '1', '1', '五星河经营所', '0', '', '1', '0', '0', '10'),
('10098', '230000', '230700', '230715', '1', '1', '汤洪岭林场', '0', '', '1', '0', '0', '10'),
('10099', '230000', '230700', '230715', '1', '1', '汤北林场', '0', '', '1', '0', '0', '10'),
('10100', '230000', '230700', '230715', '1', '1', '霍吉河林场', '0', '', '1', '0', '0', '10'),
('10101', '230000', '230700', '230715', '1', '1', '二杨经营所', '0', '', '1', '0', '0', '10'),
('10102', '230000', '230700', '230715', '1', '1', '三杨林场', '0', '', '1', '0', '0', '10'),
('10103', '230000', '230700', '230715', '1', '1', '汤南林场', '0', '', '1', '0', '0', '10'),
('10104', '230000', '230700', '230715', '1', '1', '共青经营所', '0', '', '1', '0', '0', '10'),
('10105', '230000', '230700', '230715', '1', '1', '库斯特林场', '0', '', '1', '0', '0', '10'),
('10106', '230000', '230700', '230715', '1', '1', '二皮河经营所', '0', '', '1', '0', '0', '10'),
('10107', '230000', '230700', '230716', '1', '1', '红山街道', '0', '', '1', '0', '0', '10'),
('10108', '230000', '230700', '230716', '1', '1', '山峰林场', '0', '', '1', '0', '0', '10'),
('10109', '230000', '230700', '230716', '1', '1', '阳光林场', '0', '', '1', '0', '0', '10'),
('10110', '230000', '230700', '230716', '1', '1', '新风林场', '0', '', '1', '0', '0', '10'),
('10111', '230000', '230700', '230716', '1', '1', '卫国林场', '0', '', '1', '0', '0', '10'),
('10112', '230000', '230700', '230716', '1', '1', '查山经营所', '0', '', '1', '0', '0', '10'),
('10113', '230000', '230700', '230716', '1', '1', '长青经营所', '0', '', '1', '0', '0', '10'),
('10114', '230000', '230700', '230716', '1', '1', '青山农场', '0', '', '1', '0', '0', '10'),
('10115', '230000', '230700', '230716', '1', '1', '溪水经营所', '0', '', '1', '0', '0', '10'),
('10116', '230000', '230700', '230716', '1', '1', '蔚兰经营所', '0', '', '1', '0', '0', '10'),
('10117', '230000', '230700', '230716', '1', '1', '永绪经营所', '0', '', '1', '0', '0', '10'),
('10118', '230000', '230700', '230716', '1', '1', '美林经营所', '0', '', '1', '0', '0', '10'),
('10119', '230000', '230700', '230716', '1', '1', '红山经营所', '0', '', '1', '0', '0', '10'),
('10120', '230000', '230700', '230722', '1', '1', '朝阳镇', '0', '', '1', '0', '0', '10'),
('10121', '230000', '230700', '230722', '1', '1', '乌云镇', '0', '', '1', '0', '0', '10'),
('10122', '230000', '230700', '230722', '1', '1', '乌拉嘎镇', '0', '', '1', '0', '0', '10'),
('10123', '230000', '230700', '230722', '1', '1', '常胜乡', '0', '', '1', '0', '0', '10'),
('10124', '230000', '230700', '230722', '1', '1', '向阳乡', '0', '', '1', '0', '0', '10'),
('10125', '230000', '230700', '230722', '1', '1', '沪嘉乡', '0', '', '1', '0', '0', '10'),
('10126', '230000', '230700', '230722', '1', '1', '红光乡', '0', '', '1', '0', '0', '10'),
('10127', '230000', '230700', '230722', '1', '1', '保兴乡', '0', '', '1', '0', '0', '10'),
('10128', '230000', '230700', '230722', '1', '1', '青山乡', '0', '', '1', '0', '0', '10'),
('10129', '230000', '230700', '230722', '1', '1', '太平林场', '0', '', '1', '0', '0', '10'),
('10130', '230000', '230700', '230722', '1', '1', '红旗林场', '0', '', '1', '0', '0', '10'),
('10131', '230000', '230700', '230722', '1', '1', '清河林场', '0', '', '1', '0', '0', '10'),
('10132', '230000', '230700', '230722', '1', '1', '连江林场', '0', '', '1', '0', '0', '10'),
('10133', '230000', '230700', '230722', '1', '1', '马连林场', '0', '', '1', '0', '0', '10'),
('10134', '230000', '230700', '230722', '1', '1', '嘉荫农场', '0', '', '1', '0', '0', '10'),
('10135', '230000', '230700', '230781', '1', '1', '铁力镇', '0', '', '1', '0', '0', '10'),
('10136', '230000', '230700', '230781', '1', '1', '双丰镇', '0', '', '1', '0', '0', '10'),
('10137', '230000', '230700', '230781', '1', '1', '桃山镇', '0', '', '1', '0', '0', '10'),
('10138', '230000', '230700', '230781', '1', '1', '朗乡镇', '0', '', '1', '0', '0', '10'),
('10139', '230000', '230700', '230781', '1', '1', '年丰乡', '0', '', '1', '0', '0', '10'),
('10140', '230000', '230700', '230781', '1', '1', '工农乡', '0', '', '1', '0', '0', '10'),
('10141', '230000', '230700', '230781', '1', '1', '王杨乡', '0', '', '1', '0', '0', '10'),
('10142', '230000', '230700', '230781', '1', '1', '铁力林业局', '0', '', '1', '0', '0', '10'),
('10143', '230000', '230700', '230781', '1', '1', '双丰林业局', '0', '', '1', '0', '0', '10'),
('10144', '230000', '230700', '230781', '1', '1', '桃山林业局', '0', '', '1', '0', '0', '10'),
('10145', '230000', '230700', '230781', '1', '1', '朗乡林业局', '0', '', '1', '0', '0', '10'),
('10146', '230000', '230700', '230781', '1', '1', '铁力农场', '0', '', '1', '0', '0', '10'),
('10147', '230000', '230800', '230803', '1', '1', '西林街道', '0', '', '1', '0', '0', '10'),
('10148', '230000', '230800', '230803', '1', '1', '保卫街道', '0', '', '1', '0', '0', '10'),
('10149', '230000', '230800', '230803', '1', '1', '桥南街道', '0', '', '1', '0', '0', '10'),
('10150', '230000', '230800', '230803', '1', '1', '西南岗街道', '0', '', '1', '0', '0', '10'),
('10151', '230000', '230800', '230803', '1', '1', '建设街道', '0', '', '1', '0', '0', '10'),
('10152', '230000', '230800', '230803', '1', '1', '长安街道', '0', '', '1', '0', '0', '10'),
('10153', '230000', '230800', '230803', '1', '1', '向阳区直辖地域', '0', '', '1', '0', '0', '10'),
('10154', '230000', '230800', '230804', '1', '1', '站前街道', '0', '', '1', '0', '0', '10'),
('10155', '230000', '230800', '230804', '1', '1', '永安街道', '0', '', '1', '0', '0', '10'),
('10156', '230000', '230800', '230804', '1', '1', '奋斗街道', '0', '', '1', '0', '0', '10'),
('10157', '230000', '230800', '230804', '1', '1', '南岗街道', '0', '', '1', '0', '0', '10'),
('10158', '230000', '230800', '230804', '1', '1', '亮子河街道', '0', '', '1', '0', '0', '10'),
('10159', '230000', '230800', '230804', '1', '1', '田园街道', '0', '', '1', '0', '0', '10'),
('10160', '230000', '230800', '230805', '1', '1', '晓云街道', '0', '', '1', '0', '0', '10'),
('10161', '230000', '230800', '230805', '1', '1', '佳东街道', '0', '', '1', '0', '0', '10'),
('10162', '230000', '230800', '230805', '1', '1', '造纸街道', '0', '', '1', '0', '0', '10'),
('10163', '230000', '230800', '230805', '1', '1', '佳南街道', '0', '', '1', '0', '0', '10'),
('10164', '230000', '230800', '230805', '1', '1', '建国街道', '0', '', '1', '0', '0', '10'),
('10165', '230000', '230800', '230805', '1', '1', '松江乡', '0', '', '1', '0', '0', '10'),
('10166', '230000', '230800', '230805', '1', '1', '建国乡', '0', '', '1', '0', '0', '10'),
('10167', '230000', '230800', '230811', '1', '1', '佳西街道', '0', '', '1', '0', '0', '10'),
('10168', '230000', '230800', '230811', '1', '1', '友谊街道', '0', '', '1', '0', '0', '10'),
('10169', '230000', '230800', '230811', '1', '1', '大来镇', '0', '', '1', '0', '0', '10'),
('10170', '230000', '230800', '230811', '1', '1', '敖其镇', '0', '', '1', '0', '0', '10'),
('10171', '230000', '230800', '230811', '1', '1', '望江镇', '0', '', '1', '0', '0', '10'),
('10172', '230000', '230800', '230811', '1', '1', '长发镇', '0', '', '1', '0', '0', '10'),
('10173', '230000', '230800', '230811', '1', '1', '莲江口镇', '0', '', '1', '0', '0', '10'),
('10174', '230000', '230800', '230811', '1', '1', '长青乡', '0', '', '1', '0', '0', '10'),
('10175', '230000', '230800', '230811', '1', '1', '沿江乡', '0', '', '1', '0', '0', '10'),
('10176', '230000', '230800', '230811', '1', '1', '西格木乡', '0', '', '1', '0', '0', '10'),
('10177', '230000', '230800', '230811', '1', '1', '平安乡', '0', '', '1', '0', '0', '10'),
('10178', '230000', '230800', '230811', '1', '1', '四丰乡', '0', '', '1', '0', '0', '10'),
('10179', '230000', '230800', '230811', '1', '1', '群胜乡', '0', '', '1', '0', '0', '10'),
('10180', '230000', '230800', '230811', '1', '1', '莲江口监狱', '0', '', '1', '0', '0', '10'),
('10181', '230000', '230800', '230822', '1', '1', '驼腰子镇', '0', '', '1', '0', '0', '10'),
('10182', '230000', '230800', '230822', '1', '1', '石头河子镇', '0', '', '1', '0', '0', '10'),
('10183', '230000', '230800', '230822', '1', '1', '桦南镇', '0', '', '1', '0', '0', '10'),
('10184', '230000', '230800', '230822', '1', '1', '土龙山镇', '0', '', '1', '0', '0', '10'),
('10185', '230000', '230800', '230822', '1', '1', '孟家岗镇', '0', '', '1', '0', '0', '10'),
('10186', '230000', '230800', '230822', '1', '1', '闫家镇', '0', '', '1', '0', '0', '10'),
('10187', '230000', '230800', '230822', '1', '1', '金沙乡', '0', '', '1', '0', '0', '10'),
('10188', '230000', '230800', '230822', '1', '1', '梨树乡', '0', '', '1', '0', '0', '10'),
('10189', '230000', '230800', '230822', '1', '1', '明义乡', '0', '', '1', '0', '0', '10'),
('10190', '230000', '230800', '230822', '1', '1', '大八浪乡', '0', '', '1', '0', '0', '10'),
('10191', '230000', '230800', '230822', '1', '1', '桦南林业局', '0', '', '1', '0', '0', '10'),
('10192', '230000', '230800', '230822', '1', '1', '曙光农场', '0', '', '1', '0', '0', '10'),
('10193', '230000', '230800', '230822', '1', '1', '桦南种畜场', '0', '', '1', '0', '0', '10'),
('10194', '230000', '230800', '230826', '1', '1', '横头山镇', '0', '', '1', '0', '0', '10'),
('10195', '230000', '230800', '230826', '1', '1', '苏家店镇', '0', '', '1', '0', '0', '10'),
('10196', '230000', '230800', '230826', '1', '1', '悦来镇', '0', '', '1', '0', '0', '10'),
('10197', '230000', '230800', '230826', '1', '1', '新城镇', '0', '', '1', '0', '0', '10'),
('10198', '230000', '230800', '230826', '1', '1', '东河乡', '0', '', '1', '0', '0', '10'),
('10199', '230000', '230800', '230826', '1', '1', '梨丰乡', '0', '', '1', '0', '0', '10'),
('10200', '230000', '230800', '230826', '1', '1', '创业乡', '0', '', '1', '0', '0', '10'),
('10201', '230000', '230800', '230826', '1', '1', '星火乡', '0', '', '1', '0', '0', '10'),
('10202', '230000', '230800', '230826', '1', '1', '四马架乡', '0', '', '1', '0', '0', '10'),
('10203', '230000', '230800', '230826', '1', '1', '江川农场', '0', '', '1', '0', '0', '10'),
('10204', '230000', '230800', '230826', '1', '1', '宝山农场', '0', '', '1', '0', '0', '10'),
('10205', '230000', '230800', '230828', '1', '1', '香兰镇', '0', '', '1', '0', '0', '10'),
('10206', '230000', '230800', '230828', '1', '1', '鹤立镇', '0', '', '1', '0', '0', '10');
INSERT INTO `wst_communitys` VALUES ('10207', '230000', '230800', '230828', '1', '1', '竹帘镇', '0', '', '1', '0', '0', '10'),
('10208', '230000', '230800', '230828', '1', '1', '汤原镇', '0', '', '1', '0', '0', '10'),
('10209', '230000', '230800', '230828', '1', '1', '汤旺乡', '0', '', '1', '0', '0', '10'),
('10210', '230000', '230800', '230828', '1', '1', '胜利乡', '0', '', '1', '0', '0', '10'),
('10211', '230000', '230800', '230828', '1', '1', '吉祥乡', '0', '', '1', '0', '0', '10'),
('10212', '230000', '230800', '230828', '1', '1', '振兴乡', '0', '', '1', '0', '0', '10'),
('10213', '230000', '230800', '230828', '1', '1', '太平川乡', '0', '', '1', '0', '0', '10'),
('10214', '230000', '230800', '230828', '1', '1', '永发乡', '0', '', '1', '0', '0', '10'),
('10215', '230000', '230800', '230828', '1', '1', '鹤立林业局', '0', '', '1', '0', '0', '10'),
('10216', '230000', '230800', '230828', '1', '1', '香兰监狱', '0', '', '1', '0', '0', '10'),
('10217', '230000', '230800', '230828', '1', '1', '汤原农场', '0', '', '1', '0', '0', '10'),
('10218', '230000', '230800', '230828', '1', '1', '梧桐河农场', '0', '', '1', '0', '0', '10'),
('10219', '230000', '230800', '230833', '1', '1', '抚远镇', '0', '', '1', '0', '0', '10'),
('10220', '230000', '230800', '230833', '1', '1', '寒葱沟镇', '0', '', '1', '0', '0', '10'),
('10221', '230000', '230800', '230833', '1', '1', '浓桥镇', '0', '', '1', '0', '0', '10'),
('10222', '230000', '230800', '230833', '1', '1', '抓吉镇', '0', '', '1', '0', '0', '10'),
('10223', '230000', '230800', '230833', '1', '1', '通江乡', '0', '', '1', '0', '0', '10'),
('10224', '230000', '230800', '230833', '1', '1', '浓江乡', '0', '', '1', '0', '0', '10'),
('10225', '230000', '230800', '230833', '1', '1', '海青乡', '0', '', '1', '0', '0', '10'),
('10226', '230000', '230800', '230833', '1', '1', '别拉洪乡', '0', '', '1', '0', '0', '10'),
('10227', '230000', '230800', '230833', '1', '1', '鸭南乡', '0', '', '1', '0', '0', '10'),
('10228', '230000', '230800', '230833', '1', '1', '前哨农场', '0', '', '1', '0', '0', '10'),
('10229', '230000', '230800', '230833', '1', '1', '前锋农场', '0', '', '1', '0', '0', '10'),
('10230', '230000', '230800', '230833', '1', '1', '二道河农场', '0', '', '1', '0', '0', '10'),
('10231', '230000', '230800', '230881', '1', '1', '杏林街道', '0', '', '1', '0', '0', '10'),
('10232', '230000', '230800', '230881', '1', '1', '和兴街道', '0', '', '1', '0', '0', '10'),
('10233', '230000', '230800', '230881', '1', '1', '安康街道', '0', '', '1', '0', '0', '10'),
('10234', '230000', '230800', '230881', '1', '1', '幸福街道', '0', '', '1', '0', '0', '10'),
('10235', '230000', '230800', '230881', '1', '1', '同江镇', '0', '', '1', '0', '0', '10'),
('10236', '230000', '230800', '230881', '1', '1', '乐业镇', '0', '', '1', '0', '0', '10'),
('10237', '230000', '230800', '230881', '1', '1', '三村镇', '0', '', '1', '0', '0', '10'),
('10238', '230000', '230800', '230881', '1', '1', '临江镇', '0', '', '1', '0', '0', '10'),
('10239', '230000', '230800', '230881', '1', '1', '向阳乡', '0', '', '1', '0', '0', '10'),
('10240', '230000', '230800', '230881', '1', '1', '青河乡', '0', '', '1', '0', '0', '10'),
('10241', '230000', '230800', '230881', '1', '1', '街津口乡', '0', '', '1', '0', '0', '10'),
('10242', '230000', '230800', '230881', '1', '1', '八岔乡', '0', '', '1', '0', '0', '10'),
('10243', '230000', '230800', '230881', '1', '1', '金川乡', '0', '', '1', '0', '0', '10'),
('10244', '230000', '230800', '230881', '1', '1', '银川乡', '0', '', '1', '0', '0', '10'),
('10245', '230000', '230800', '230881', '1', '1', '街津口林场', '0', '', '1', '0', '0', '10'),
('10246', '230000', '230800', '230881', '1', '1', '鸭北林场', '0', '', '1', '0', '0', '10'),
('10247', '230000', '230800', '230881', '1', '1', '勤得利农场', '0', '', '1', '0', '0', '10'),
('10248', '230000', '230800', '230881', '1', '1', '青龙山农场', '0', '', '1', '0', '0', '10'),
('10249', '230000', '230800', '230881', '1', '1', '前进农场', '0', '', '1', '0', '0', '10'),
('10250', '230000', '230800', '230881', '1', '1', '洪河农场', '0', '', '1', '0', '0', '10'),
('10251', '230000', '230800', '230881', '1', '1', '鸭绿河农场', '0', '', '1', '0', '0', '10'),
('10252', '230000', '230800', '230881', '1', '1', '浓江农场', '0', '', '1', '0', '0', '10'),
('10253', '230000', '230800', '230881', '1', '1', '良种场', '0', '', '1', '0', '0', '10'),
('10254', '230000', '230800', '230881', '1', '1', '果树场', '0', '', '1', '0', '0', '10'),
('10255', '230000', '230800', '230881', '1', '1', '马场', '0', '', '1', '0', '0', '10'),
('10256', '230000', '230800', '230881', '1', '1', '干校', '0', '', '1', '0', '0', '10'),
('10257', '230000', '230800', '230881', '1', '1', '知青农场', '0', '', '1', '0', '0', '10'),
('10258', '230000', '230800', '230882', '1', '1', '城市街道社区委员会', '0', '', '1', '0', '0', '10'),
('10259', '230000', '230800', '230882', '1', '1', '城关街道社区建设委员会', '0', '', '1', '0', '0', '10'),
('10260', '230000', '230800', '230882', '1', '1', '长安镇', '0', '', '1', '0', '0', '10'),
('10261', '230000', '230800', '230882', '1', '1', '砚山镇', '0', '', '1', '0', '0', '10'),
('10262', '230000', '230800', '230882', '1', '1', '头林镇', '0', '', '1', '0', '0', '10'),
('10263', '230000', '230800', '230882', '1', '1', '兴隆岗镇', '0', '', '1', '0', '0', '10'),
('10264', '230000', '230800', '230882', '1', '1', '宏胜镇', '0', '', '1', '0', '0', '10'),
('10265', '230000', '230800', '230882', '1', '1', '向阳川镇', '0', '', '1', '0', '0', '10'),
('10266', '230000', '230800', '230882', '1', '1', '二龙山镇', '0', '', '1', '0', '0', '10'),
('10267', '230000', '230800', '230882', '1', '1', '上街基镇', '0', '', '1', '0', '0', '10'),
('10268', '230000', '230800', '230882', '1', '1', '锦山镇', '0', '', '1', '0', '0', '10'),
('10269', '230000', '230800', '230882', '1', '1', '大榆树镇', '0', '', '1', '0', '0', '10'),
('10270', '230000', '230800', '230882', '1', '1', '石砬山林场', '0', '', '1', '0', '0', '10'),
('10271', '230000', '230800', '230882', '1', '1', '东风岗林场', '0', '', '1', '0', '0', '10'),
('10272', '230000', '230800', '230882', '1', '1', '太东林场', '0', '', '1', '0', '0', '10'),
('10273', '230000', '230800', '230882', '1', '1', '工农林场', '0', '', '1', '0', '0', '10'),
('10274', '230000', '230800', '230882', '1', '1', '建三江分局局直', '0', '', '1', '0', '0', '10'),
('10275', '230000', '230800', '230882', '1', '1', '七星农场', '0', '', '1', '0', '0', '10'),
('10276', '230000', '230800', '230882', '1', '1', '大兴农场', '0', '', '1', '0', '0', '10'),
('10277', '230000', '230800', '230882', '1', '1', '创业农场', '0', '', '1', '0', '0', '10'),
('10278', '230000', '230800', '230882', '1', '1', '种猪场', '0', '', '1', '0', '0', '10'),
('10279', '230000', '230800', '230882', '1', '1', '种蓄场', '0', '', '1', '0', '0', '10'),
('10280', '230000', '230900', '230902', '1', '1', '兴华街道', '0', '', '1', '0', '0', '10'),
('10281', '230000', '230900', '230902', '1', '1', '新城街道', '0', '', '1', '0', '0', '10'),
('10282', '230000', '230900', '230902', '1', '1', '新立街道', '0', '', '1', '0', '0', '10'),
('10283', '230000', '230900', '230902', '1', '1', '新建街道', '0', '', '1', '0', '0', '10'),
('10284', '230000', '230900', '230902', '1', '1', '北山街道', '0', '', '1', '0', '0', '10'),
('10285', '230000', '230900', '230902', '1', '1', '河南街道', '0', '', '1', '0', '0', '10'),
('10286', '230000', '230900', '230902', '1', '1', '新合街道', '0', '', '1', '0', '0', '10'),
('10287', '230000', '230900', '230902', '1', '1', '缸窑沟街道', '0', '', '1', '0', '0', '10'),
('10288', '230000', '230900', '230902', '1', '1', '新安街道', '0', '', '1', '0', '0', '10'),
('10289', '230000', '230900', '230902', '1', '1', '越秀街道', '0', '', '1', '0', '0', '10'),
('10290', '230000', '230900', '230902', '1', '1', '红旗镇', '0', '', '1', '0', '0', '10'),
('10291', '230000', '230900', '230903', '1', '1', '桃南街道', '0', '', '1', '0', '0', '10'),
('10292', '230000', '230900', '230903', '1', '1', '桃北街道', '0', '', '1', '0', '0', '10'),
('10293', '230000', '230900', '230903', '1', '1', '桃西街道', '0', '', '1', '0', '0', '10'),
('10294', '230000', '230900', '230903', '1', '1', '兴岗街道', '0', '', '1', '0', '0', '10'),
('10295', '230000', '230900', '230903', '1', '1', '桃东街道', '0', '', '1', '0', '0', '10'),
('10296', '230000', '230900', '230903', '1', '1', '桃山街道', '0', '', '1', '0', '0', '10'),
('10297', '230000', '230900', '230903', '1', '1', '万宝河镇', '0', '', '1', '0', '0', '10'),
('10298', '230000', '230900', '230904', '1', '1', '东风街道', '0', '', '1', '0', '0', '10'),
('10299', '230000', '230900', '230904', '1', '1', '向阳街道', '0', '', '1', '0', '0', '10'),
('10300', '230000', '230900', '230904', '1', '1', '富强街道', '0', '', '1', '0', '0', '10'),
('10301', '230000', '230900', '230904', '1', '1', '新富街道', '0', '', '1', '0', '0', '10'),
('10302', '230000', '230900', '230904', '1', '1', '龙湖街道', '0', '', '1', '0', '0', '10'),
('10303', '230000', '230900', '230904', '1', '1', '茄子河镇', '0', '', '1', '0', '0', '10'),
('10304', '230000', '230900', '230904', '1', '1', '宏伟镇', '0', '', '1', '0', '0', '10'),
('10305', '230000', '230900', '230904', '1', '1', '铁山乡', '0', '', '1', '0', '0', '10'),
('10306', '230000', '230900', '230904', '1', '1', '中心河乡', '0', '', '1', '0', '0', '10'),
('10307', '230000', '230900', '230921', '1', '1', '新起街道', '0', '', '1', '0', '0', '10'),
('10308', '230000', '230900', '230921', '1', '1', '新华街道', '0', '', '1', '0', '0', '10'),
('10309', '230000', '230900', '230921', '1', '1', '元明街道', '0', '', '1', '0', '0', '10'),
('10310', '230000', '230900', '230921', '1', '1', '铁西街道', '0', '', '1', '0', '0', '10'),
('10311', '230000', '230900', '230921', '1', '1', '城西街道', '0', '', '1', '0', '0', '10'),
('10312', '230000', '230900', '230921', '1', '1', '勃利镇', '0', '', '1', '0', '0', '10'),
('10313', '230000', '230900', '230921', '1', '1', '小五站镇', '0', '', '1', '0', '0', '10'),
('10314', '230000', '230900', '230921', '1', '1', '大四站镇', '0', '', '1', '0', '0', '10'),
('10315', '230000', '230900', '230921', '1', '1', '双河镇', '0', '', '1', '0', '0', '10'),
('10316', '230000', '230900', '230921', '1', '1', '倭肯镇', '0', '', '1', '0', '0', '10'),
('10317', '230000', '230900', '230921', '1', '1', '青山乡', '0', '', '1', '0', '0', '10'),
('10318', '230000', '230900', '230921', '1', '1', '长兴乡', '0', '', '1', '0', '0', '10'),
('10319', '230000', '230900', '230921', '1', '1', '永恒乡', '0', '', '1', '0', '0', '10'),
('10320', '230000', '230900', '230921', '1', '1', '抢垦乡', '0', '', '1', '0', '0', '10'),
('10321', '230000', '230900', '230921', '1', '1', '杏树朝鲜族乡', '0', '', '1', '0', '0', '10'),
('10322', '230000', '230900', '230921', '1', '1', '吉兴朝鲜族满族乡', '0', '', '1', '0', '0', '10'),
('10323', '230000', '230900', '230921', '1', '1', '北兴农场', '0', '', '1', '0', '0', '10'),
('10324', '230000', '230900', '230921', '1', '1', '种畜场', '0', '', '1', '0', '0', '10'),
('10325', '230000', '231000', '231002', '1', '1', '新安街道', '0', '', '1', '0', '0', '10'),
('10326', '230000', '231000', '231002', '1', '1', '长安街道', '0', '', '1', '0', '0', '10'),
('10327', '230000', '231000', '231002', '1', '1', '七星街道', '0', '', '1', '0', '0', '10'),
('10328', '230000', '231000', '231002', '1', '1', '五星街道', '0', '', '1', '0', '0', '10'),
('10329', '230000', '231000', '231002', '1', '1', '兴隆镇', '0', '', '1', '0', '0', '10'),
('10330', '230000', '231000', '231003', '1', '1', '阳明街道', '0', '', '1', '0', '0', '10'),
('10331', '230000', '231000', '231003', '1', '1', '前进街道', '0', '', '1', '0', '0', '10'),
('10332', '230000', '231000', '231003', '1', '1', '新兴街道', '0', '', '1', '0', '0', '10'),
('10333', '230000', '231000', '231003', '1', '1', '桦林橡胶厂街道', '0', '', '1', '0', '0', '10'),
('10334', '230000', '231000', '231003', '1', '1', '铁岭镇', '0', '', '1', '0', '0', '10'),
('10335', '230000', '231000', '231003', '1', '1', '桦林镇', '0', '', '1', '0', '0', '10'),
('10336', '230000', '231000', '231004', '1', '1', '向阳街道', '0', '', '1', '0', '0', '10'),
('10337', '230000', '231000', '231004', '1', '1', '黄花街道', '0', '', '1', '0', '0', '10'),
('10338', '230000', '231000', '231004', '1', '1', '铁北街道', '0', '', '1', '0', '0', '10'),
('10339', '230000', '231000', '231004', '1', '1', '新华街道', '0', '', '1', '0', '0', '10'),
('10340', '230000', '231000', '231004', '1', '1', '大庆街道', '0', '', '1', '0', '0', '10'),
('10341', '230000', '231000', '231004', '1', '1', '兴平街道', '0', '', '1', '0', '0', '10'),
('10342', '230000', '231000', '231004', '1', '1', '北山街道', '0', '', '1', '0', '0', '10'),
('10343', '230000', '231000', '231004', '1', '1', '北安乡', '0', '', '1', '0', '0', '10'),
('10344', '230000', '231000', '231005', '1', '1', '先锋街道', '0', '', '1', '0', '0', '10'),
('10345', '230000', '231000', '231005', '1', '1', '火炬街道', '0', '', '1', '0', '0', '10'),
('10346', '230000', '231000', '231005', '1', '1', '立新街道', '0', '', '1', '0', '0', '10'),
('10347', '230000', '231000', '231005', '1', '1', '牡丹街道', '0', '', '1', '0', '0', '10'),
('10348', '230000', '231000', '231005', '1', '1', '江滨街道', '0', '', '1', '0', '0', '10'),
('10349', '230000', '231000', '231005', '1', '1', '沿江街道', '0', '', '1', '0', '0', '10'),
('10350', '230000', '231000', '231005', '1', '1', '温春镇', '0', '', '1', '0', '0', '10'),
('10351', '230000', '231000', '231005', '1', '1', '沿江乡', '0', '', '1', '0', '0', '10'),
('10352', '230000', '231000', '231024', '1', '1', '东宁镇', '0', '', '1', '0', '0', '10'),
('10353', '230000', '231000', '231024', '1', '1', '三岔口镇', '0', '', '1', '0', '0', '10'),
('10354', '230000', '231000', '231024', '1', '1', '大肚川镇', '0', '', '1', '0', '0', '10'),
('10355', '230000', '231000', '231024', '1', '1', '老黑山镇', '0', '', '1', '0', '0', '10'),
('10356', '230000', '231000', '231024', '1', '1', '道河镇', '0', '', '1', '0', '0', '10'),
('10357', '230000', '231000', '231024', '1', '1', '绥阳镇', '0', '', '1', '0', '0', '10'),
('10358', '230000', '231000', '231024', '1', '1', '绥阳林业局', '0', '', '1', '0', '0', '10'),
('10359', '230000', '231000', '231025', '1', '1', '林口镇', '0', '', '1', '0', '0', '10'),
('10360', '230000', '231000', '231025', '1', '1', '古城镇', '0', '', '1', '0', '0', '10'),
('10361', '230000', '231000', '231025', '1', '1', '刁翎镇', '0', '', '1', '0', '0', '10'),
('10362', '230000', '231000', '231025', '1', '1', '五林镇', '0', '', '1', '0', '0', '10'),
('10363', '230000', '231000', '231025', '1', '1', '朱家镇', '0', '', '1', '0', '0', '10'),
('10364', '230000', '231000', '231025', '1', '1', '柳树镇', '0', '', '1', '0', '0', '10'),
('10365', '230000', '231000', '231025', '1', '1', '三道通镇', '0', '', '1', '0', '0', '10'),
('10366', '230000', '231000', '231025', '1', '1', '龙爪镇', '0', '', '1', '0', '0', '10'),
('10367', '230000', '231000', '231025', '1', '1', '莲花镇', '0', '', '1', '0', '0', '10'),
('10368', '230000', '231000', '231025', '1', '1', '奎山乡', '0', '', '1', '0', '0', '10'),
('10369', '230000', '231000', '231025', '1', '1', '青山乡', '0', '', '1', '0', '0', '10'),
('10370', '230000', '231000', '231025', '1', '1', '建堂乡', '0', '', '1', '0', '0', '10'),
('10371', '230000', '231000', '231025', '1', '1', '林口林业局', '0', '', '1', '0', '0', '10'),
('10372', '230000', '231000', '231081', '1', '1', '绥芬河镇', '0', '', '1', '0', '0', '10'),
('10373', '230000', '231000', '231081', '1', '1', '阜宁镇', '0', '', '1', '0', '0', '10'),
('10374', '230000', '231000', '231083', '1', '1', '海林镇', '0', '', '1', '0', '0', '10'),
('10375', '230000', '231000', '231083', '1', '1', '长汀镇', '0', '', '1', '0', '0', '10'),
('10376', '230000', '231000', '231083', '1', '1', '横道镇', '0', '', '1', '0', '0', '10'),
('10377', '230000', '231000', '231083', '1', '1', '山市镇', '0', '', '1', '0', '0', '10'),
('10378', '230000', '231000', '231083', '1', '1', '柴河镇', '0', '', '1', '0', '0', '10'),
('10379', '230000', '231000', '231083', '1', '1', '二道镇', '0', '', '1', '0', '0', '10'),
('10380', '230000', '231000', '231083', '1', '1', '新安朝鲜族镇', '0', '', '1', '0', '0', '10'),
('10381', '230000', '231000', '231083', '1', '1', '三道镇', '0', '', '1', '0', '0', '10'),
('10382', '230000', '231000', '231083', '1', '1', '海南朝鲜族乡', '0', '', '1', '0', '0', '10'),
('10383', '230000', '231000', '231083', '1', '1', '牡林工程公司街道', '0', '', '1', '0', '0', '10'),
('10384', '230000', '231000', '231083', '1', '1', '柴河林机厂街道', '0', '', '1', '0', '0', '10'),
('10385', '230000', '231000', '231083', '1', '1', '大海林林业局', '0', '', '1', '0', '0', '10'),
('10386', '230000', '231000', '231083', '1', '1', '海林林业局', '0', '', '1', '0', '0', '10'),
('10387', '230000', '231000', '231083', '1', '1', '柴河林业局', '0', '', '1', '0', '0', '10'),
('10388', '230000', '231000', '231083', '1', '1', '海林农场', '0', '', '1', '0', '0', '10'),
('10389', '230000', '231000', '231083', '1', '1', '山市种奶牛场', '0', '', '1', '0', '0', '10'),
('10390', '230000', '231000', '231084', '1', '1', '城区街道', '0', '', '1', '0', '0', '10'),
('10391', '230000', '231000', '231084', '1', '1', '宁安镇', '0', '', '1', '0', '0', '10'),
('10392', '230000', '231000', '231084', '1', '1', '东京城镇', '0', '', '1', '0', '0', '10'),
('10393', '230000', '231000', '231084', '1', '1', '渤海镇', '0', '', '1', '0', '0', '10'),
('10394', '230000', '231000', '231084', '1', '1', '石岩镇', '0', '', '1', '0', '0', '10'),
('10395', '230000', '231000', '231084', '1', '1', '沙兰镇', '0', '', '1', '0', '0', '10'),
('10396', '230000', '231000', '231084', '1', '1', '海浪镇', '0', '', '1', '0', '0', '10'),
('10397', '230000', '231000', '231084', '1', '1', '兰岗镇', '0', '', '1', '0', '0', '10'),
('10398', '230000', '231000', '231084', '1', '1', '江南朝鲜族满族乡', '0', '', '1', '0', '0', '10'),
('10399', '230000', '231000', '231084', '1', '1', '卧龙朝鲜族乡', '0', '', '1', '0', '0', '10'),
('10400', '230000', '231000', '231084', '1', '1', '马河乡', '0', '', '1', '0', '0', '10'),
('10401', '230000', '231000', '231084', '1', '1', '镜泊乡', '0', '', '1', '0', '0', '10'),
('10402', '230000', '231000', '231084', '1', '1', '三陵乡', '0', '', '1', '0', '0', '10'),
('10403', '230000', '231000', '231084', '1', '1', '东京城林业局', '0', '', '1', '0', '0', '10'),
('10404', '230000', '231000', '231084', '1', '1', '宁安农场', '0', '', '1', '0', '0', '10'),
('10405', '230000', '231000', '231085', '1', '1', '八面通镇', '0', '', '1', '0', '0', '10'),
('10406', '230000', '231000', '231085', '1', '1', '穆棱镇', '0', '', '1', '0', '0', '10'),
('10407', '230000', '231000', '231085', '1', '1', '下城子镇', '0', '', '1', '0', '0', '10'),
('10408', '230000', '231000', '231085', '1', '1', '马桥河镇', '0', '', '1', '0', '0', '10'),
('10409', '230000', '231000', '231085', '1', '1', '兴源镇', '0', '', '1', '0', '0', '10'),
('10410', '230000', '231000', '231085', '1', '1', '磨刀石镇', '0', '', '1', '0', '0', '10'),
('10411', '230000', '231000', '231085', '1', '1', '福录乡', '0', '', '1', '0', '0', '10'),
('10412', '230000', '231000', '231085', '1', '1', '河西乡', '0', '', '1', '0', '0', '10'),
('10413', '230000', '231000', '231085', '1', '1', '共和乡', '0', '', '1', '0', '0', '10'),
('10414', '230000', '231000', '231085', '1', '1', '八面通林业局', '0', '', '1', '0', '0', '10'),
('10415', '230000', '231000', '231085', '1', '1', '穆棱林业局', '0', '', '1', '0', '0', '10'),
('10416', '230000', '231100', '231102', '1', '1', '花园街道', '0', '', '1', '0', '0', '10'),
('10417', '230000', '231100', '231102', '1', '1', '兴安街道', '0', '', '1', '0', '0', '10'),
('10418', '230000', '231100', '231102', '1', '1', '海兰街道', '0', '', '1', '0', '0', '10'),
('10419', '230000', '231100', '231102', '1', '1', '西兴街道', '0', '', '1', '0', '0', '10'),
('10420', '230000', '231100', '231102', '1', '1', '西岗子镇', '0', '', '1', '0', '0', '10'),
('10421', '230000', '231100', '231102', '1', '1', '爱辉镇', '0', '', '1', '0', '0', '10'),
('10422', '230000', '231100', '231102', '1', '1', '罕达汽镇', '0', '', '1', '0', '0', '10'),
('10423', '230000', '231100', '231102', '1', '1', '幸福乡', '0', '', '1', '0', '0', '10'),
('10424', '230000', '231100', '231102', '1', '1', '四嘉子乡', '0', '', '1', '0', '0', '10'),
('10425', '230000', '231100', '231102', '1', '1', '坤河乡', '0', '', '1', '0', '0', '10'),
('10426', '230000', '231100', '231102', '1', '1', '上马厂乡', '0', '', '1', '0', '0', '10'),
('10427', '230000', '231100', '231102', '1', '1', '张地营子乡', '0', '', '1', '0', '0', '10'),
('10428', '230000', '231100', '231102', '1', '1', '西峰山乡', '0', '', '1', '0', '0', '10'),
('10429', '230000', '231100', '231102', '1', '1', '新生乡', '0', '', '1', '0', '0', '10'),
('10430', '230000', '231100', '231102', '1', '1', '二站乡', '0', '', '1', '0', '0', '10'),
('10431', '230000', '231100', '231102', '1', '1', '宋集屯煤矿', '0', '', '1', '0', '0', '10'),
('10432', '230000', '231100', '231102', '1', '1', '西岗子煤矿', '0', '', '1', '0', '0', '10'),
('10433', '230000', '231100', '231102', '1', '1', '东方红煤矿', '0', '', '1', '0', '0', '10'),
('10434', '230000', '231100', '231102', '1', '1', '大平林场', '0', '', '1', '0', '0', '10'),
('10435', '230000', '231100', '231102', '1', '1', '七二七林场', '0', '', '1', '0', '0', '10'),
('10436', '230000', '231100', '231102', '1', '1', '望峰林场', '0', '', '1', '0', '0', '10'),
('10437', '230000', '231100', '231102', '1', '1', '卡伦山林场', '0', '', '1', '0', '0', '10'),
('10438', '230000', '231100', '231102', '1', '1', '胜山林场', '0', '', '1', '0', '0', '10'),
('10439', '230000', '231100', '231102', '1', '1', '二站林场', '0', '', '1', '0', '0', '10'),
('10440', '230000', '231100', '231102', '1', '1', '三站林场', '0', '', '1', '0', '0', '10'),
('10441', '230000', '231100', '231102', '1', '1', '大岭林场', '0', '', '1', '0', '0', '10'),
('10442', '230000', '231100', '231102', '1', '1', '桦皮窑林场', '0', '', '1', '0', '0', '10'),
('10443', '230000', '231100', '231102', '1', '1', '滨南林场', '0', '', '1', '0', '0', '10'),
('10444', '230000', '231100', '231102', '1', '1', '江防林场', '0', '', '1', '0', '0', '10'),
('10445', '230000', '231100', '231102', '1', '1', '西岗子试验林场', '0', '', '1', '0', '0', '10'),
('10446', '230000', '231100', '231102', '1', '1', '种畜场', '0', '', '1', '0', '0', '10'),
('10447', '230000', '231100', '231102', '1', '1', '第二良种场', '0', '', '1', '0', '0', '10'),
('10448', '230000', '231100', '231102', '1', '1', '第一良种场', '0', '', '1', '0', '0', '10'),
('10449', '230000', '231100', '231102', '1', '1', '大新屯储木场', '0', '', '1', '0', '0', '10'),
('10450', '230000', '231100', '231102', '1', '1', '锦河农场', '0', '', '1', '0', '0', '10'),
('10451', '230000', '231100', '231121', '1', '1', '嫩江镇', '0', '', '1', '0', '0', '10'),
('10452', '230000', '231100', '231121', '1', '1', '伊拉哈镇', '0', '', '1', '0', '0', '10'),
('10453', '230000', '231100', '231121', '1', '1', '双山镇', '0', '', '1', '0', '0', '10'),
('10454', '230000', '231100', '231121', '1', '1', '多宝山镇', '0', '', '1', '0', '0', '10'),
('10455', '230000', '231100', '231121', '1', '1', '海江镇', '0', '', '1', '0', '0', '10'),
('10456', '230000', '231100', '231121', '1', '1', '前进镇', '0', '', '1', '0', '0', '10'),
('10457', '230000', '231100', '231121', '1', '1', '长福镇', '0', '', '1', '0', '0', '10'),
('10458', '230000', '231100', '231121', '1', '1', '科洛镇', '0', '', '1', '0', '0', '10'),
('10459', '230000', '231100', '231121', '1', '1', '临江乡', '0', '', '1', '0', '0', '10'),
('10460', '230000', '231100', '231121', '1', '1', '联兴乡', '0', '', '1', '0', '0', '10'),
('10461', '230000', '231100', '231121', '1', '1', '白云乡', '0', '', '1', '0', '0', '10'),
('10462', '230000', '231100', '231121', '1', '1', '塔溪乡', '0', '', '1', '0', '0', '10'),
('10463', '230000', '231100', '231121', '1', '1', '霍龙门乡', '0', '', '1', '0', '0', '10'),
('10464', '230000', '231100', '231121', '1', '1', '多宝山铜矿', '0', '', '1', '0', '0', '10'),
('10465', '230000', '231100', '231121', '1', '1', '九三分局局直', '0', '', '1', '0', '0', '10'),
('10466', '230000', '231100', '231121', '1', '1', '鹤山农场', '0', '', '1', '0', '0', '10'),
('10467', '230000', '231100', '231121', '1', '1', '大西江农场', '0', '', '1', '0', '0', '10'),
('10468', '230000', '231100', '231121', '1', '1', '尖山农场', '0', '', '1', '0', '0', '10'),
('10469', '230000', '231100', '231121', '1', '1', '荣军农场', '0', '', '1', '0', '0', '10'),
('10470', '230000', '231100', '231121', '1', '1', '红五月农场', '0', '', '1', '0', '0', '10'),
('10471', '230000', '231100', '231121', '1', '1', '七星泡农场', '0', '', '1', '0', '0', '10'),
('10472', '230000', '231100', '231121', '1', '1', '嫩江农场', '0', '', '1', '0', '0', '10'),
('10473', '230000', '231100', '231121', '1', '1', '山河农场', '0', '', '1', '0', '0', '10'),
('10474', '230000', '231100', '231121', '1', '1', '嫩北农场', '0', '', '1', '0', '0', '10'),
('10475', '230000', '231100', '231121', '1', '1', '建边农场', '0', '', '1', '0', '0', '10'),
('10476', '230000', '231100', '231121', '1', '1', '种畜场', '0', '', '1', '0', '0', '10'),
('10477', '230000', '231100', '231121', '1', '1', '马铃薯原种繁殖场', '0', '', '1', '0', '0', '10'),
('10478', '230000', '231100', '231123', '1', '1', '奇克街道', '0', '', '1', '0', '0', '10'),
('10479', '230000', '231100', '231123', '1', '1', '边疆镇', '0', '', '1', '0', '0', '10'),
('10480', '230000', '231100', '231123', '1', '1', '逊河镇', '0', '', '1', '0', '0', '10'),
('10481', '230000', '231100', '231123', '1', '1', '干岔子乡', '0', '', '1', '0', '0', '10'),
('10482', '230000', '231100', '231123', '1', '1', '松树沟乡', '0', '', '1', '0', '0', '10'),
('10483', '230000', '231100', '231123', '1', '1', '车陆乡', '0', '', '1', '0', '0', '10'),
('10484', '230000', '231100', '231123', '1', '1', '新鄂乡', '0', '', '1', '0', '0', '10'),
('10485', '230000', '231100', '231123', '1', '1', '新兴乡', '0', '', '1', '0', '0', '10'),
('10486', '230000', '231100', '231123', '1', '1', '克林乡', '0', '', '1', '0', '0', '10'),
('10487', '230000', '231100', '231123', '1', '1', '宝山乡', '0', '', '1', '0', '0', '10'),
('10488', '230000', '231100', '231123', '1', '1', '道干林场', '0', '', '1', '0', '0', '10'),
('10489', '230000', '231100', '231123', '1', '1', '干岔子林场', '0', '', '1', '0', '0', '10'),
('10490', '230000', '231100', '231123', '1', '1', '新立林场', '0', '', '1', '0', '0', '10'),
('10491', '230000', '231100', '231123', '1', '1', '三间房林场', '0', '', '1', '0', '0', '10'),
('10492', '230000', '231100', '231123', '1', '1', '良种场', '0', '', '1', '0', '0', '10'),
('10493', '230000', '231100', '231123', '1', '1', '种畜场', '0', '', '1', '0', '0', '10'),
('10494', '230000', '231100', '231123', '1', '1', '逊克农场', '0', '', '1', '0', '0', '10'),
('10495', '230000', '231100', '231124', '1', '1', '孙吴城区街道', '0', '', '1', '0', '0', '10'),
('10496', '230000', '231100', '231124', '1', '1', '孙吴镇', '0', '', '1', '0', '0', '10'),
('10497', '230000', '231100', '231124', '1', '1', '辰清镇', '0', '', '1', '0', '0', '10'),
('10498', '230000', '231100', '231124', '1', '1', '西兴乡', '0', '', '1', '0', '0', '10'),
('10499', '230000', '231100', '231124', '1', '1', '沿江满族乡', '0', '', '1', '0', '0', '10'),
('10500', '230000', '231100', '231124', '1', '1', '腰屯乡', '0', '', '1', '0', '0', '10'),
('10501', '230000', '231100', '231124', '1', '1', '卧牛河乡', '0', '', '1', '0', '0', '10'),
('10502', '230000', '231100', '231124', '1', '1', '群山乡', '0', '', '1', '0', '0', '10'),
('10503', '230000', '231100', '231124', '1', '1', '奋斗乡', '0', '', '1', '0', '0', '10'),
('10504', '230000', '231100', '231124', '1', '1', '红旗乡', '0', '', '1', '0', '0', '10'),
('10505', '230000', '231100', '231124', '1', '1', '正阳山乡', '0', '', '1', '0', '0', '10'),
('10506', '230000', '231100', '231124', '1', '1', '清溪乡', '0', '', '1', '0', '0', '10'),
('10507', '230000', '231100', '231124', '1', '1', '前进林场', '0', '', '1', '0', '0', '10'),
('10508', '230000', '231100', '231124', '1', '1', '大河口林场', '0', '', '1', '0', '0', '10'),
('10509', '230000', '231100', '231124', '1', '1', '正阳林场', '0', '', '1', '0', '0', '10'),
('10510', '230000', '231100', '231124', '1', '1', '平山林场', '0', '', '1', '0', '0', '10'),
('10511', '230000', '231100', '231124', '1', '1', '沿江林场', '0', '', '1', '0', '0', '10'),
('10512', '230000', '231100', '231124', '1', '1', '辰清林场', '0', '', '1', '0', '0', '10'),
('10513', '230000', '231100', '231124', '1', '1', '红旗林场', '0', '', '1', '0', '0', '10'),
('10514', '230000', '231100', '231124', '1', '1', '向阳林场', '0', '', '1', '0', '0', '10'),
('10515', '230000', '231100', '231124', '1', '1', '良种场', '0', '', '1', '0', '0', '10'),
('10516', '230000', '231100', '231124', '1', '1', '种畜场', '0', '', '1', '0', '0', '10'),
('10517', '230000', '231100', '231124', '1', '1', '红色边疆农场', '0', '', '1', '0', '0', '10'),
('10518', '230000', '231100', '231181', '1', '1', '兆麟街道', '0', '', '1', '0', '0', '10'),
('10519', '230000', '231100', '231181', '1', '1', '和平街道', '0', '', '1', '0', '0', '10'),
('10520', '230000', '231100', '231181', '1', '1', '北岗街道', '0', '', '1', '0', '0', '10'),
('10521', '230000', '231100', '231181', '1', '1', '庆华街道', '0', '', '1', '0', '0', '10'),
('10522', '230000', '231100', '231181', '1', '1', '铁西街道', '0', '', '1', '0', '0', '10'),
('10523', '230000', '231100', '231181', '1', '1', '铁南街道', '0', '', '1', '0', '0', '10'),
('10524', '230000', '231100', '231181', '1', '1', '通北镇', '0', '', '1', '0', '0', '10'),
('10525', '230000', '231100', '231181', '1', '1', '赵光镇', '0', '', '1', '0', '0', '10'),
('10526', '230000', '231100', '231181', '1', '1', '海星镇', '0', '', '1', '0', '0', '10'),
('10527', '230000', '231100', '231181', '1', '1', '石泉镇', '0', '', '1', '0', '0', '10'),
('10528', '230000', '231100', '231181', '1', '1', '二井镇', '0', '', '1', '0', '0', '10'),
('10529', '230000', '231100', '231181', '1', '1', '城郊乡', '0', '', '1', '0', '0', '10'),
('10530', '230000', '231100', '231181', '1', '1', '东胜乡', '0', '', '1', '0', '0', '10'),
('10531', '230000', '231100', '231181', '1', '1', '杨家乡', '0', '', '1', '0', '0', '10'),
('10532', '230000', '231100', '231181', '1', '1', '主星乡', '0', '', '1', '0', '0', '10'),
('10533', '230000', '231100', '231181', '1', '1', '通北林业局', '0', '', '1', '0', '0', '10'),
('10534', '230000', '231100', '231181', '1', '1', '北安分局局直', '0', '', '1', '0', '0', '10'),
('10535', '230000', '231100', '231181', '1', '1', '长水河农场', '0', '', '1', '0', '0', '10'),
('10536', '230000', '231100', '231181', '1', '1', '赵光农场', '0', '', '1', '0', '0', '10'),
('10537', '230000', '231100', '231181', '1', '1', '红星农场', '0', '', '1', '0', '0', '10'),
('10538', '230000', '231100', '231181', '1', '1', '建设农场', '0', '', '1', '0', '0', '10'),
('10539', '230000', '231100', '231182', '1', '1', '青山街道', '0', '', '1', '0', '0', '10'),
('10540', '230000', '231100', '231182', '1', '1', '龙镇', '0', '', '1', '0', '0', '10'),
('10541', '230000', '231100', '231182', '1', '1', '和平镇', '0', '', '1', '0', '0', '10'),
('10542', '230000', '231100', '231182', '1', '1', '五大连池镇', '0', '', '1', '0', '0', '10'),
('10543', '230000', '231100', '231182', '1', '1', '新发乡', '0', '', '1', '0', '0', '10'),
('10544', '230000', '231100', '231182', '1', '1', '兴隆乡', '0', '', '1', '0', '0', '10'),
('10545', '230000', '231100', '231182', '1', '1', '建设乡', '0', '', '1', '0', '0', '10'),
('10546', '230000', '231100', '231182', '1', '1', '太平乡', '0', '', '1', '0', '0', '10'),
('10547', '230000', '231100', '231182', '1', '1', '双泉乡', '0', '', '1', '0', '0', '10'),
('10548', '230000', '231100', '231182', '1', '1', '团结乡', '0', '', '1', '0', '0', '10'),
('10549', '230000', '231100', '231182', '1', '1', '兴安乡', '0', '', '1', '0', '0', '10'),
('10550', '230000', '231100', '231182', '1', '1', '朝阳乡', '0', '', '1', '0', '0', '10'),
('10551', '230000', '231100', '231182', '1', '1', '花园劳教所', '0', '', '1', '0', '0', '10'),
('10552', '230000', '231100', '231182', '1', '1', '永丰监狱', '0', '', '1', '0', '0', '10'),
('10553', '230000', '231100', '231182', '1', '1', '华山监狱', '0', '', '1', '0', '0', '10'),
('10554', '230000', '231100', '231182', '1', '1', '凤凰山监狱', '0', '', '1', '0', '0', '10'),
('10555', '230000', '231100', '231182', '1', '1', '元青山林场', '0', '', '1', '0', '0', '10'),
('10556', '230000', '231100', '231182', '1', '1', '三九六林场', '0', '', '1', '0', '0', '10'),
('10557', '230000', '231100', '231182', '1', '1', '小兴安林场', '0', '', '1', '0', '0', '10'),
('10558', '230000', '231100', '231182', '1', '1', '二龙山林场', '0', '', '1', '0', '0', '10'),
('10559', '230000', '231100', '231182', '1', '1', '朝阳林场', '0', '', '1', '0', '0', '10'),
('10560', '230000', '231100', '231182', '1', '1', '引龙河林场', '0', '', '1', '0', '0', '10'),
('10561', '230000', '231100', '231182', '1', '1', '焦得布林场', '0', '', '1', '0', '0', '10'),
('10562', '230000', '231100', '231182', '1', '1', '沾河林业局', '0', '', '1', '0', '0', '10'),
('10563', '230000', '231100', '231182', '1', '1', '莲花管理委员会', '0', '', '1', '0', '0', '10'),
('10564', '230000', '231100', '231182', '1', '1', '二龙山蚕种场', '0', '', '1', '0', '0', '10'),
('10565', '230000', '231100', '231182', '1', '1', '五大连池原种场', '0', '', '1', '0', '0', '10'),
('10566', '230000', '231100', '231182', '1', '1', '畜牧场', '0', '', '1', '0', '0', '10'),
('10567', '230000', '231100', '231182', '1', '1', '第二良种场', '0', '', '1', '0', '0', '10'),
('10568', '230000', '231100', '231182', '1', '1', '龙门农场', '0', '', '1', '0', '0', '10'),
('10569', '230000', '231100', '231182', '1', '1', '襄河农场', '0', '', '1', '0', '0', '10'),
('10570', '230000', '231100', '231182', '1', '1', '龙镇农场', '0', '', '1', '0', '0', '10'),
('10571', '230000', '231100', '231182', '1', '1', '二龙山农场', '0', '', '1', '0', '0', '10'),
('10572', '230000', '231100', '231182', '1', '1', '引龙河农场', '0', '', '1', '0', '0', '10'),
('10573', '230000', '231100', '231182', '1', '1', '尾山农场', '0', '', '1', '0', '0', '10'),
('10574', '230000', '231100', '231182', '1', '1', '格球山农场', '0', '', '1', '0', '0', '10'),
('10575', '230000', '231100', '231182', '1', '1', '大庆农场', '0', '', '1', '0', '0', '10'),
('10576', '230000', '231200', '231202', '1', '1', '紫来', '0', '', '1', '0', '0', '10'),
('10577', '230000', '231200', '231202', '1', '1', '爱路', '0', '', '1', '0', '0', '10'),
('10578', '230000', '231200', '231202', '1', '1', '大有', '0', '', '1', '0', '0', '10'),
('10579', '230000', '231200', '231202', '1', '1', '吉泰', '0', '', '1', '0', '0', '10'),
('10580', '230000', '231200', '231202', '1', '1', '东兴', '0', '', '1', '0', '0', '10'),
('10581', '230000', '231200', '231202', '1', '1', '北林办事处居民委员会', '0', '', '1', '0', '0', '10'),
('10582', '230000', '231200', '231202', '1', '1', '宝山镇', '0', '', '1', '0', '0', '10'),
('10583', '230000', '231200', '231202', '1', '1', '绥胜镇', '0', '', '1', '0', '0', '10'),
('10584', '230000', '231200', '231202', '1', '1', '西长发镇', '0', '', '1', '0', '0', '10'),
('10585', '230000', '231200', '231202', '1', '1', '永安镇', '0', '', '1', '0', '0', '10'),
('10586', '230000', '231200', '231202', '1', '1', '太平川镇', '0', '', '1', '0', '0', '10'),
('10587', '230000', '231200', '231202', '1', '1', '秦家镇', '0', '', '1', '0', '0', '10'),
('10588', '230000', '231200', '231202', '1', '1', '双河镇', '0', '', '1', '0', '0', '10'),
('10589', '230000', '231200', '231202', '1', '1', '三河镇', '0', '', '1', '0', '0', '10'),
('10590', '230000', '231200', '231202', '1', '1', '四方台镇', '0', '', '1', '0', '0', '10'),
('10591', '230000', '231200', '231202', '1', '1', '津河镇', '0', '', '1', '0', '0', '10'),
('10592', '230000', '231200', '231202', '1', '1', '张维镇', '0', '', '1', '0', '0', '10'),
('10593', '230000', '231200', '231202', '1', '1', '东津镇', '0', '', '1', '0', '0', '10'),
('10594', '230000', '231200', '231202', '1', '1', '红旗乡', '0', '', '1', '0', '0', '10'),
('10595', '230000', '231200', '231202', '1', '1', '连岗乡', '0', '', '1', '0', '0', '10'),
('10596', '230000', '231200', '231202', '1', '1', '新华乡', '0', '', '1', '0', '0', '10'),
('10597', '230000', '231200', '231202', '1', '1', '兴福乡', '0', '', '1', '0', '0', '10'),
('10598', '230000', '231200', '231202', '1', '1', '东富乡', '0', '', '1', '0', '0', '10'),
('10599', '230000', '231200', '231202', '1', '1', '三井乡', '0', '', '1', '0', '0', '10'),
('10600', '230000', '231200', '231202', '1', '1', '五营乡', '0', '', '1', '0', '0', '10'),
('10601', '230000', '231200', '231202', '1', '1', '兴和乡', '0', '', '1', '0', '0', '10'),
('10602', '230000', '231200', '231221', '1', '1', '望奎镇', '0', '', '1', '0', '0', '10'),
('10603', '230000', '231200', '231221', '1', '1', '通江镇', '0', '', '1', '0', '0', '10'),
('10604', '230000', '231200', '231221', '1', '1', '卫星镇', '0', '', '1', '0', '0', '10'),
('10605', '230000', '231200', '231221', '1', '1', '海丰镇', '0', '', '1', '0', '0', '10'),
('10606', '230000', '231200', '231221', '1', '1', '莲花镇', '0', '', '1', '0', '0', '10'),
('10607', '230000', '231200', '231221', '1', '1', '惠七满族镇', '0', '', '1', '0', '0', '10'),
('10608', '230000', '231200', '231221', '1', '1', '先锋镇', '0', '', '1', '0', '0', '10'),
('10609', '230000', '231200', '231221', '1', '1', '东郊乡', '0', '', '1', '0', '0', '10'),
('10610', '230000', '231200', '231221', '1', '1', '灵山满族乡', '0', '', '1', '0', '0', '10'),
('10611', '230000', '231200', '231221', '1', '1', '后三乡', '0', '', '1', '0', '0', '10'),
('10612', '230000', '231200', '231221', '1', '1', '火箭乡', '0', '', '1', '0', '0', '10'),
('10613', '230000', '231200', '231221', '1', '1', '灯塔乡', '0', '', '1', '0', '0', '10'),
('10614', '230000', '231200', '231221', '1', '1', '东升乡', '0', '', '1', '0', '0', '10'),
('10615', '230000', '231200', '231221', '1', '1', '恭六乡', '0', '', '1', '0', '0', '10'),
('10616', '230000', '231200', '231221', '1', '1', '厢白满族乡', '0', '', '1', '0', '0', '10'),
('10617', '230000', '231200', '231221', '1', '1', '白四林场', '0', '', '1', '0', '0', '10'),
('10618', '230000', '231200', '231221', '1', '1', '种畜场', '0', '', '1', '0', '0', '10'),
('10619', '230000', '231200', '231221', '1', '1', '第一良种场', '0', '', '1', '0', '0', '10'),
('10620', '230000', '231200', '231221', '1', '1', '第二良种场', '0', '', '1', '0', '0', '10'),
('10621', '230000', '231200', '231222', '1', '1', '兰西镇', '0', '', '1', '0', '0', '10'),
('10622', '230000', '231200', '231222', '1', '1', '榆林镇', '0', '', '1', '0', '0', '10'),
('10623', '230000', '231200', '231222', '1', '1', '临江镇', '0', '', '1', '0', '0', '10'),
('10624', '230000', '231200', '231222', '1', '1', '平山镇', '0', '', '1', '0', '0', '10'),
('10625', '230000', '231200', '231222', '1', '1', '康荣乡', '0', '', '1', '0', '0', '10'),
('10626', '230000', '231200', '231222', '1', '1', '燎原乡', '0', '', '1', '0', '0', '10'),
('10627', '230000', '231200', '231222', '1', '1', '北安乡', '0', '', '1', '0', '0', '10'),
('10628', '230000', '231200', '231222', '1', '1', '长江乡', '0', '', '1', '0', '0', '10'),
('10629', '230000', '231200', '231222', '1', '1', '兰河乡', '0', '', '1', '0', '0', '10'),
('10630', '230000', '231200', '231222', '1', '1', '红星乡', '0', '', '1', '0', '0', '10'),
('10631', '230000', '231200', '231222', '1', '1', '红光乡', '0', '', '1', '0', '0', '10'),
('10632', '230000', '231200', '231222', '1', '1', '长岗乡', '0', '', '1', '0', '0', '10'),
('10633', '230000', '231200', '231222', '1', '1', '远大乡', '0', '', '1', '0', '0', '10'),
('10634', '230000', '231200', '231222', '1', '1', '星火乡', '0', '', '1', '0', '0', '10'),
('10635', '230000', '231200', '231222', '1', '1', '奋斗乡', '0', '', '1', '0', '0', '10'),
('10636', '230000', '231200', '231222', '1', '1', '第一原种场', '0', '', '1', '0', '0', '10'),
('10637', '230000', '231200', '231222', '1', '1', '第二原种场', '0', '', '1', '0', '0', '10'),
('10638', '230000', '231200', '231222', '1', '1', '肉用种羊场', '0', '', '1', '0', '0', '10'),
('10639', '230000', '231200', '231223', '1', '1', '青冈镇', '0', '', '1', '0', '0', '10'),
('10640', '230000', '231200', '231223', '1', '1', '中和镇', '0', '', '1', '0', '0', '10'),
('10641', '230000', '231200', '231223', '1', '1', '祯祥镇', '0', '', '1', '0', '0', '10'),
('10642', '230000', '231200', '231223', '1', '1', '兴华镇', '0', '', '1', '0', '0', '10'),
('10643', '230000', '231200', '231223', '1', '1', '永丰镇', '0', '', '1', '0', '0', '10'),
('10644', '230000', '231200', '231223', '1', '1', '芦河镇', '0', '', '1', '0', '0', '10'),
('10645', '230000', '231200', '231223', '1', '1', '劳动乡', '0', '', '1', '0', '0', '10'),
('10646', '230000', '231200', '231223', '1', '1', '建设乡', '0', '', '1', '0', '0', '10'),
('10647', '230000', '231200', '231223', '1', '1', '新村乡', '0', '', '1', '0', '0', '10'),
('10648', '230000', '231200', '231223', '1', '1', '昌盛乡', '0', '', '1', '0', '0', '10'),
('10649', '230000', '231200', '231223', '1', '1', '柞岗乡', '0', '', '1', '0', '0', '10'),
('10650', '230000', '231200', '231223', '1', '1', '民政乡', '0', '', '1', '0', '0', '10'),
('10651', '230000', '231200', '231223', '1', '1', '德胜乡', '0', '', '1', '0', '0', '10'),
('10652', '230000', '231200', '231223', '1', '1', '迎春乡', '0', '', '1', '0', '0', '10'),
('10653', '230000', '231200', '231223', '1', '1', '连丰乡', '0', '', '1', '0', '0', '10'),
('10654', '230000', '231200', '231223', '1', '1', '青冈县林场', '0', '', '1', '0', '0', '10'),
('10655', '230000', '231200', '231223', '1', '1', '青冈县互利营林站', '0', '', '1', '0', '0', '10'),
('10656', '230000', '231200', '231223', '1', '1', '青冈县果树场', '0', '', '1', '0', '0', '10'),
('10657', '230000', '231200', '231223', '1', '1', '青冈县种马场', '0', '', '1', '0', '0', '10'),
('10658', '230000', '231200', '231223', '1', '1', '青冈县种羊场', '0', '', '1', '0', '0', '10'),
('10659', '230000', '231200', '231223', '1', '1', '青冈县原种场', '0', '', '1', '0', '0', '10'),
('10660', '230000', '231200', '231224', '1', '1', '庆安镇', '0', '', '1', '0', '0', '10'),
('10661', '230000', '231200', '231224', '1', '1', '民乐镇', '0', '', '1', '0', '0', '10'),
('10662', '230000', '231200', '231224', '1', '1', '大罗镇', '0', '', '1', '0', '0', '10'),
('10663', '230000', '231200', '231224', '1', '1', '平安镇', '0', '', '1', '0', '0', '10'),
('10664', '230000', '231200', '231224', '1', '1', '勤劳镇', '0', '', '1', '0', '0', '10'),
('10665', '230000', '231200', '231224', '1', '1', '久胜镇', '0', '', '1', '0', '0', '10'),
('10666', '230000', '231200', '231224', '1', '1', '建民乡', '0', '', '1', '0', '0', '10'),
('10667', '230000', '231200', '231224', '1', '1', '巨宝山乡', '0', '', '1', '0', '0', '10'),
('10668', '230000', '231200', '231224', '1', '1', '新胜乡', '0', '', '1', '0', '0', '10'),
('10669', '230000', '231200', '231224', '1', '1', '丰收乡', '0', '', '1', '0', '0', '10'),
('10670', '230000', '231200', '231224', '1', '1', '发展乡', '0', '', '1', '0', '0', '10'),
('10671', '230000', '231200', '231224', '1', '1', '同乐乡', '0', '', '1', '0', '0', '10'),
('10672', '230000', '231200', '231224', '1', '1', '致富乡', '0', '', '1', '0', '0', '10'),
('10673', '230000', '231200', '231224', '1', '1', '欢胜乡', '0', '', '1', '0', '0', '10'),
('10674', '230000', '231200', '231224', '1', '1', '国有林场管理局', '0', '', '1', '0', '0', '10'),
('10675', '230000', '231200', '231224', '1', '1', '柳河林校', '0', '', '1', '0', '0', '10'),
('10676', '230000', '231200', '231224', '1', '1', '柳河农场', '0', '', '1', '0', '0', '10'),
('10677', '230000', '231200', '231225', '1', '1', '明水镇', '0', '', '1', '0', '0', '10'),
('10678', '230000', '231200', '231225', '1', '1', '兴仁镇', '0', '', '1', '0', '0', '10'),
('10679', '230000', '231200', '231225', '1', '1', '永兴镇', '0', '', '1', '0', '0', '10'),
('10680', '230000', '231200', '231225', '1', '1', '崇德镇', '0', '', '1', '0', '0', '10'),
('10681', '230000', '231200', '231225', '1', '1', '通达镇', '0', '', '1', '0', '0', '10'),
('10682', '230000', '231200', '231225', '1', '1', '双兴乡', '0', '', '1', '0', '0', '10'),
('10683', '230000', '231200', '231225', '1', '1', '永久乡', '0', '', '1', '0', '0', '10'),
('10684', '230000', '231200', '231225', '1', '1', '树人乡', '0', '', '1', '0', '0', '10'),
('10685', '230000', '231200', '231225', '1', '1', '光荣乡', '0', '', '1', '0', '0', '10'),
('10686', '230000', '231200', '231225', '1', '1', '繁荣乡', '0', '', '1', '0', '0', '10'),
('10687', '230000', '231200', '231225', '1', '1', '通泉乡', '0', '', '1', '0', '0', '10'),
('10688', '230000', '231200', '231225', '1', '1', '育林乡', '0', '', '1', '0', '0', '10'),
('10689', '230000', '231200', '231225', '1', '1', '国营林场', '0', '', '1', '0', '0', '10'),
('10690', '230000', '231200', '231225', '1', '1', '县联社马场', '0', '', '1', '0', '0', '10'),
('10691', '230000', '231200', '231225', '1', '1', '明水种畜场', '0', '', '1', '0', '0', '10'),
('10692', '230000', '231200', '231225', '1', '1', '育林畜牧场', '0', '', '1', '0', '0', '10'),
('10693', '230000', '231200', '231225', '1', '1', '国营第一良种', '0', '', '1', '0', '0', '10'),
('10694', '230000', '231200', '231225', '1', '1', '国营第二良种', '0', '', '1', '0', '0', '10'),
('10695', '230000', '231200', '231225', '1', '1', '国营第三良种', '0', '', '1', '0', '0', '10'),
('10696', '230000', '231200', '231226', '1', '1', '绥棱镇', '0', '', '1', '0', '0', '10'),
('10697', '230000', '231200', '231226', '1', '1', '上集镇', '0', '', '1', '0', '0', '10'),
('10698', '230000', '231200', '231226', '1', '1', '四海店镇', '0', '', '1', '0', '0', '10'),
('10699', '230000', '231200', '231226', '1', '1', '双岔河镇', '0', '', '1', '0', '0', '10'),
('10700', '230000', '231200', '231226', '1', '1', '靠山乡', '0', '', '1', '0', '0', '10'),
('10701', '230000', '231200', '231226', '1', '1', '后头乡', '0', '', '1', '0', '0', '10'),
('10702', '230000', '231200', '231226', '1', '1', '长山乡', '0', '', '1', '0', '0', '10'),
('10703', '230000', '231200', '231226', '1', '1', '克音河乡', '0', '', '1', '0', '0', '10'),
('10704', '230000', '231200', '231226', '1', '1', '绥中乡', '0', '', '1', '0', '0', '10'),
('10705', '230000', '231200', '231226', '1', '1', '泥尔河乡', '0', '', '1', '0', '0', '10'),
('10706', '230000', '231200', '231226', '1', '1', '阁山乡', '0', '', '1', '0', '0', '10'),
('10707', '230000', '231200', '231226', '1', '1', '阁山林场', '0', '', '1', '0', '0', '10'),
('10708', '230000', '231200', '231226', '1', '1', '四海店林场', '0', '', '1', '0', '0', '10'),
('10709', '230000', '231200', '231226', '1', '1', '三吉台林场', '0', '', '1', '0', '0', '10'),
('10710', '230000', '231200', '231226', '1', '1', '半截河林场', '0', '', '1', '0', '0', '10'),
('10711', '230000', '231200', '231226', '1', '1', '绥棱林业局', '0', '', '1', '0', '0', '10'),
('10712', '230000', '231200', '231226', '1', '1', '绥棱农场', '0', '', '1', '0', '0', '10'),
('10713', '230000', '231200', '231226', '1', '1', '种马场', '0', '', '1', '0', '0', '10'),
('10714', '230000', '231200', '231226', '1', '1', '良种场', '0', '', '1', '0', '0', '10'),
('10715', '230000', '231200', '231226', '1', '1', '奶山羊场', '0', '', '1', '0', '0', '10'),
('10716', '230000', '231200', '231281', '1', '1', '铁西街道', '0', '', '1', '0', '0', '10'),
('10717', '230000', '231200', '231281', '1', '1', '新兴街道', '0', '', '1', '0', '0', '10'),
('10718', '230000', '231200', '231281', '1', '1', '安虹街道', '0', '', '1', '0', '0', '10'),
('10719', '230000', '231200', '231281', '1', '1', '安达镇', '0', '', '1', '0', '0', '10'),
('10720', '230000', '231200', '231281', '1', '1', '任民镇', '0', '', '1', '0', '0', '10'),
('10721', '230000', '231200', '231281', '1', '1', '万宝山镇', '0', '', '1', '0', '0', '10'),
('10722', '230000', '231200', '231281', '1', '1', '昌德镇', '0', '', '1', '0', '0', '10'),
('10723', '230000', '231200', '231281', '1', '1', '升平镇', '0', '', '1', '0', '0', '10'),
('10724', '230000', '231200', '231281', '1', '1', '羊草镇', '0', '', '1', '0', '0', '10'),
('10725', '230000', '231200', '231281', '1', '1', '老虎岗镇', '0', '', '1', '0', '0', '10'),
('10726', '230000', '231200', '231281', '1', '1', '中本镇', '0', '', '1', '0', '0', '10'),
('10727', '230000', '231200', '231281', '1', '1', '太平庄镇', '0', '', '1', '0', '0', '10'),
('10728', '230000', '231200', '231281', '1', '1', '吉兴岗镇', '0', '', '1', '0', '0', '10'),
('10729', '230000', '231200', '231281', '1', '1', '火石山乡', '0', '', '1', '0', '0', '10'),
('10730', '230000', '231200', '231281', '1', '1', '卧里屯乡', '0', '', '1', '0', '0', '10'),
('10731', '230000', '231200', '231281', '1', '1', '青肯泡乡', '0', '', '1', '0', '0', '10'),
('10732', '230000', '231200', '231281', '1', '1', '先源乡', '0', '', '1', '0', '0', '10'),
('10733', '230000', '231200', '231281', '1', '1', '安达畜牧场', '0', '', '1', '0', '0', '10'),
('10734', '230000', '231200', '231281', '1', '1', '种畜场', '0', '', '1', '0', '0', '10'),
('10735', '230000', '231200', '231281', '1', '1', '原种场', '0', '', '1', '0', '0', '10'),
('10736', '230000', '231200', '231281', '1', '1', '种牛场', '0', '', '1', '0', '0', '10'),
('10737', '230000', '231200', '231281', '1', '1', '红旗泡水库管理所', '0', '', '1', '0', '0', '10'),
('10738', '230000', '231200', '231281', '1', '1', '东湖水库管理站', '0', '', '1', '0', '0', '10'),
('10739', '230000', '231200', '231282', '1', '1', '朝阳区', '0', '', '1', '0', '0', '10'),
('10740', '230000', '231200', '231282', '1', '1', '东升区', '0', '', '1', '0', '0', '10'),
('10741', '230000', '231200', '231282', '1', '1', '西园区', '0', '', '1', '0', '0', '10'),
('10742', '230000', '231200', '231282', '1', '1', '正阳区', '0', '', '1', '0', '0', '10'),
('10743', '230000', '231200', '231282', '1', '1', '肇东镇', '0', '', '1', '0', '0', '10'),
('10744', '230000', '231200', '231282', '1', '1', '昌五镇', '0', '', '1', '0', '0', '10'),
('10745', '230000', '231200', '231282', '1', '1', '宋站镇', '0', '', '1', '0', '0', '10'),
('10746', '230000', '231200', '231282', '1', '1', '五站镇', '0', '', '1', '0', '0', '10'),
('10747', '230000', '231200', '231282', '1', '1', '尚家镇', '0', '', '1', '0', '0', '10'),
('10748', '230000', '231200', '231282', '1', '1', '姜家镇', '0', '', '1', '0', '0', '10'),
('10749', '230000', '231200', '231282', '1', '1', '里木店镇', '0', '', '1', '0', '0', '10'),
('10750', '230000', '231200', '231282', '1', '1', '四站镇', '0', '', '1', '0', '0', '10'),
('10751', '230000', '231200', '231282', '1', '1', '涝洲镇', '0', '', '1', '0', '0', '10'),
('10752', '230000', '231200', '231282', '1', '1', '五里明镇', '0', '', '1', '0', '0', '10'),
('10753', '230000', '231200', '231282', '1', '1', '黎明镇', '0', '', '1', '0', '0', '10'),
('10754', '230000', '231200', '231282', '1', '1', '太平乡', '0', '', '1', '0', '0', '10'),
('10755', '230000', '231200', '231282', '1', '1', '海城乡', '0', '', '1', '0', '0', '10'),
('10756', '230000', '231200', '231282', '1', '1', '向阳乡', '0', '', '1', '0', '0', '10'),
('10757', '230000', '231200', '231282', '1', '1', '洪河乡', '0', '', '1', '0', '0', '10'),
('10758', '230000', '231200', '231282', '1', '1', '跃进乡', '0', '', '1', '0', '0', '10'),
('10759', '230000', '231200', '231282', '1', '1', '西八里乡', '0', '', '1', '0', '0', '10'),
('10760', '230000', '231200', '231282', '1', '1', '德昌乡', '0', '', '1', '0', '0', '10'),
('10761', '230000', '231200', '231282', '1', '1', '宣化乡', '0', '', '1', '0', '0', '10'),
('10762', '230000', '231200', '231282', '1', '1', '安民乡', '0', '', '1', '0', '0', '10'),
('10763', '230000', '231200', '231282', '1', '1', '明久乡', '0', '', '1', '0', '0', '10'),
('10764', '230000', '231200', '231282', '1', '1', '四方山农场', '0', '', '1', '0', '0', '10'),
('10765', '230000', '231200', '231283', '1', '1', '海伦镇', '0', '', '1', '0', '0', '10'),
('10766', '230000', '231200', '231283', '1', '1', '海北镇', '0', '', '1', '0', '0', '10'),
('10767', '230000', '231200', '231283', '1', '1', '伦河镇', '0', '', '1', '0', '0', '10'),
('10768', '230000', '231200', '231283', '1', '1', '共合镇', '0', '', '1', '0', '0', '10'),
('10769', '230000', '231200', '231283', '1', '1', '海兴镇', '0', '', '1', '0', '0', '10'),
('10770', '230000', '231200', '231283', '1', '1', '祥富镇', '0', '', '1', '0', '0', '10'),
('10771', '230000', '231200', '231283', '1', '1', '东风镇', '0', '', '1', '0', '0', '10'),
('10772', '230000', '231200', '231283', '1', '1', '前进乡', '0', '', '1', '0', '0', '10'),
('10773', '230000', '231200', '231283', '1', '1', '向荣乡', '0', '', '1', '0', '0', '10'),
('10774', '230000', '231200', '231283', '1', '1', '长发乡', '0', '', '1', '0', '0', '10'),
('10775', '230000', '231200', '231283', '1', '1', '东林乡', '0', '', '1', '0', '0', '10'),
('10776', '230000', '231200', '231283', '1', '1', '海南乡', '0', '', '1', '0', '0', '10'),
('10777', '230000', '231200', '231283', '1', '1', '共荣乡', '0', '', '1', '0', '0', '10');
INSERT INTO `wst_communitys` VALUES ('10778', '230000', '231200', '231283', '1', '1', '乐业乡', '0', '', '1', '0', '0', '10'),
('10779', '230000', '231200', '231283', '1', '1', '福民乡', '0', '', '1', '0', '0', '10'),
('10780', '230000', '231200', '231283', '1', '1', '丰山乡', '0', '', '1', '0', '0', '10'),
('10781', '230000', '231200', '231283', '1', '1', '永富乡', '0', '', '1', '0', '0', '10'),
('10782', '230000', '231200', '231283', '1', '1', '百祥乡', '0', '', '1', '0', '0', '10'),
('10783', '230000', '231200', '231283', '1', '1', '联发乡', '0', '', '1', '0', '0', '10'),
('10784', '230000', '231200', '231283', '1', '1', '永和乡', '0', '', '1', '0', '0', '10'),
('10785', '230000', '231200', '231283', '1', '1', '爱民乡', '0', '', '1', '0', '0', '10'),
('10786', '230000', '231200', '231283', '1', '1', '扎音河乡', '0', '', '1', '0', '0', '10'),
('10787', '230000', '231200', '231283', '1', '1', '双录乡', '0', '', '1', '0', '0', '10'),
('10788', '230000', '231200', '231283', '1', '1', '林场公司', '0', '', '1', '0', '0', '10'),
('10789', '230000', '231200', '231283', '1', '1', '东方红水库地区', '0', '', '1', '0', '0', '10'),
('10790', '230000', '231200', '231283', '1', '1', '海伦农场', '0', '', '1', '0', '0', '10'),
('10791', '230000', '231200', '231283', '1', '1', '红光农场', '0', '', '1', '0', '0', '10'),
('10792', '230000', '231200', '231283', '1', '1', '海伦绥化种畜场', '0', '', '1', '0', '0', '10'),
('10793', '230000', '231200', '231283', '1', '1', '海伦二粮种场', '0', '', '1', '0', '0', '10'),
('10794', '230000', '231200', '231283', '1', '1', '海伦市种畜场', '0', '', '1', '0', '0', '10'),
('10795', '230000', '232700', '232701', '1', '1', '街道东山社区', '0', '', '1', '0', '0', '10'),
('10796', '230000', '232700', '232701', '1', '1', '街道卫东社区', '0', '', '1', '0', '0', '10'),
('10797', '230000', '232700', '232701', '1', '1', '街道红旗社区', '0', '', '1', '0', '0', '10'),
('10798', '230000', '232700', '232701', '1', '1', '街道长虹社区', '0', '', '1', '0', '0', '10'),
('10799', '230000', '232700', '232701', '1', '1', '街道曙光社区', '0', '', '1', '0', '0', '10'),
('10800', '230000', '232700', '232701', '1', '1', '街道光明社区', '0', '', '1', '0', '0', '10'),
('10801', '230000', '232700', '232701', '1', '1', '加北乡', '0', '', '1', '0', '0', '10'),
('10802', '230000', '232700', '232701', '1', '1', '白桦乡', '0', '', '1', '0', '0', '10'),
('10803', '230000', '232700', '232701', '1', '1', '加格达奇林业局', '0', '', '1', '0', '0', '10'),
('10804', '230000', '232700', '232701', '1', '1', '林田农业开发区', '0', '', '1', '0', '0', '10'),
('10805', '230000', '232700', '232702', '1', '1', '小扬气镇', '0', '', '1', '0', '0', '10'),
('10806', '230000', '232700', '232702', '1', '1', '劲松镇', '0', '', '1', '0', '0', '10'),
('10807', '230000', '232700', '232702', '1', '1', '古源镇', '0', '', '1', '0', '0', '10'),
('10808', '230000', '232700', '232702', '1', '1', '松岭林业局', '0', '', '1', '0', '0', '10'),
('10809', '230000', '232700', '232703', '1', '1', '新林镇', '0', '', '1', '0', '0', '10'),
('10810', '230000', '232700', '232703', '1', '1', '翠岗镇', '0', '', '1', '0', '0', '10'),
('10811', '230000', '232700', '232703', '1', '1', '塔源镇', '0', '', '1', '0', '0', '10'),
('10812', '230000', '232700', '232703', '1', '1', '大乌苏镇', '0', '', '1', '0', '0', '10'),
('10813', '230000', '232700', '232703', '1', '1', '塔尔根镇', '0', '', '1', '0', '0', '10'),
('10814', '230000', '232700', '232703', '1', '1', '碧洲镇', '0', '', '1', '0', '0', '10'),
('10815', '230000', '232700', '232703', '1', '1', '宏图镇', '0', '', '1', '0', '0', '10'),
('10816', '230000', '232700', '232703', '1', '1', '新林林业局', '0', '', '1', '0', '0', '10'),
('10817', '230000', '232700', '232704', '1', '1', '呼中镇', '0', '', '1', '0', '0', '10'),
('10818', '230000', '232700', '232704', '1', '1', '碧水镇', '0', '', '1', '0', '0', '10'),
('10819', '230000', '232700', '232704', '1', '1', '呼源镇', '0', '', '1', '0', '0', '10'),
('10820', '230000', '232700', '232704', '1', '1', '宏伟镇', '0', '', '1', '0', '0', '10'),
('10821', '230000', '232700', '232704', '1', '1', '呼中林业局', '0', '', '1', '0', '0', '10'),
('10822', '230000', '232700', '232721', '1', '1', '呼玛镇', '0', '', '1', '0', '0', '10'),
('10823', '230000', '232700', '232721', '1', '1', '韩家园镇', '0', '', '1', '0', '0', '10'),
('10824', '230000', '232700', '232721', '1', '1', '三卡乡', '0', '', '1', '0', '0', '10'),
('10825', '230000', '232700', '232721', '1', '1', '金山乡', '0', '', '1', '0', '0', '10'),
('10826', '230000', '232700', '232721', '1', '1', '兴华乡', '0', '', '1', '0', '0', '10'),
('10827', '230000', '232700', '232721', '1', '1', '鸥浦乡', '0', '', '1', '0', '0', '10'),
('10828', '230000', '232700', '232721', '1', '1', '白银纳鄂伦春族民族乡', '0', '', '1', '0', '0', '10'),
('10829', '230000', '232700', '232721', '1', '1', '北疆乡', '0', '', '1', '0', '0', '10'),
('10830', '230000', '232700', '232721', '1', '1', '韩家园林业局', '0', '', '1', '0', '0', '10'),
('10831', '230000', '232700', '232722', '1', '1', '塔河镇', '0', '', '1', '0', '0', '10'),
('10832', '230000', '232700', '232722', '1', '1', '瓦拉干镇', '0', '', '1', '0', '0', '10'),
('10833', '230000', '232700', '232722', '1', '1', '盘古镇', '0', '', '1', '0', '0', '10'),
('10834', '230000', '232700', '232722', '1', '1', '十八站鄂伦春族民族乡', '0', '', '1', '0', '0', '10'),
('10835', '230000', '232700', '232722', '1', '1', '依西肯乡', '0', '', '1', '0', '0', '10'),
('10836', '230000', '232700', '232722', '1', '1', '开库康乡', '0', '', '1', '0', '0', '10'),
('10837', '230000', '232700', '232722', '1', '1', '十八站林业局', '0', '', '1', '0', '0', '10'),
('10838', '230000', '232700', '232722', '1', '1', '塔河林业局', '0', '', '1', '0', '0', '10'),
('10839', '230000', '232700', '232723', '1', '1', '西林吉镇', '0', '', '1', '0', '0', '10'),
('10840', '230000', '232700', '232723', '1', '1', '图强镇', '0', '', '1', '0', '0', '10'),
('10841', '230000', '232700', '232723', '1', '1', '劲涛镇', '0', '', '1', '0', '0', '10'),
('10842', '230000', '232700', '232723', '1', '1', '兴安镇', '0', '', '1', '0', '0', '10'),
('10843', '230000', '232700', '232723', '1', '1', '北极乡', '0', '', '1', '0', '0', '10'),
('10844', '230000', '232700', '232723', '1', '1', '西林吉林业局', '0', '', '1', '0', '0', '10'),
('10845', '230000', '232700', '232723', '1', '1', '图强林业局', '0', '', '1', '0', '0', '10'),
('10846', '230000', '232700', '232723', '1', '1', '阿木尔林业局', '0', '', '1', '0', '0', '10'),
('11090', '320000', '320100', '320102', '1', '1', '梅园新村街道', '0', '', '1', '0', '0', '10'),
('11091', '320000', '320100', '320102', '1', '1', '新街口街道', '0', '', '1', '0', '0', '10'),
('11092', '320000', '320100', '320102', '1', '1', '玄武门街道', '0', '', '1', '0', '0', '10'),
('11093', '320000', '320100', '320102', '1', '1', '后宰门街道', '0', '', '1', '0', '0', '10'),
('11094', '320000', '320100', '320102', '1', '1', '锁金村街道', '0', '', '1', '0', '0', '10'),
('11095', '320000', '320100', '320102', '1', '1', '红山街道', '0', '', '1', '0', '0', '10'),
('11096', '320000', '320100', '320102', '1', '1', '孝陵卫街道', '0', '', '1', '0', '0', '10'),
('11097', '320000', '320100', '320102', '1', '1', '玄武湖街道', '0', '', '1', '0', '0', '10'),
('11098', '320000', '320100', '320103', '1', '1', '五老村街道', '0', '', '1', '0', '0', '10'),
('11099', '320000', '320100', '320103', '1', '1', '淮海路街道', '0', '', '1', '0', '0', '10'),
('11100', '320000', '320100', '320103', '1', '1', '建康路街道', '0', '', '1', '0', '0', '10'),
('11101', '320000', '320100', '320103', '1', '1', '洪武路街道', '0', '', '1', '0', '0', '10'),
('11102', '320000', '320100', '320103', '1', '1', '大光路街道', '0', '', '1', '0', '0', '10'),
('11103', '320000', '320100', '320103', '1', '1', '瑞金路街道', '0', '', '1', '0', '0', '10'),
('11104', '320000', '320100', '320103', '1', '1', '苜蓿园街道', '0', '', '1', '0', '0', '10'),
('11105', '320000', '320100', '320103', '1', '1', '光华路街道', '0', '', '1', '0', '0', '10'),
('11106', '320000', '320100', '320103', '1', '1', '朝天宫街道', '0', '', '1', '0', '0', '10'),
('11107', '320000', '320100', '320103', '1', '1', '止马营街道', '0', '', '1', '0', '0', '10'),
('11108', '320000', '320100', '320104', '1', '1', '秦虹街道', '0', '', '1', '0', '0', '10'),
('11109', '320000', '320100', '320104', '1', '1', '夫子庙街道', '0', '', '1', '0', '0', '10'),
('11110', '320000', '320100', '320104', '1', '1', '红花街道', '0', '', '1', '0', '0', '10'),
('11111', '320000', '320100', '320104', '1', '1', '双塘街道', '0', '', '1', '0', '0', '10'),
('11112', '320000', '320100', '320104', '1', '1', '中华门街道', '0', '', '1', '0', '0', '10'),
('11113', '320000', '320100', '320105', '1', '1', '滨湖街道', '0', '', '1', '0', '0', '10'),
('11114', '320000', '320100', '320105', '1', '1', '沙洲街道', '0', '', '1', '0', '0', '10'),
('11115', '320000', '320100', '320105', '1', '1', '双闸街道', '0', '', '1', '0', '0', '10'),
('11116', '320000', '320100', '320105', '1', '1', '江心洲街道', '0', '', '1', '0', '0', '10'),
('11117', '320000', '320100', '320105', '1', '1', '南湖街道', '0', '', '1', '0', '0', '10'),
('11118', '320000', '320100', '320105', '1', '1', '兴隆街道', '0', '', '1', '0', '0', '10'),
('11119', '320000', '320100', '320105', '1', '1', '南苑街道', '0', '', '1', '0', '0', '10'),
('11120', '320000', '320100', '320106', '1', '1', '宁海路街道', '0', '', '1', '0', '0', '10'),
('11121', '320000', '320100', '320106', '1', '1', '华侨路街道', '0', '', '1', '0', '0', '10'),
('11122', '320000', '320100', '320106', '1', '1', '湖南路街道', '0', '', '1', '0', '0', '10'),
('11123', '320000', '320100', '320106', '1', '1', '中央门街道', '0', '', '1', '0', '0', '10'),
('11124', '320000', '320100', '320106', '1', '1', '挹江门街道', '0', '', '1', '0', '0', '10'),
('11125', '320000', '320100', '320106', '1', '1', '江东街道', '0', '', '1', '0', '0', '10'),
('11126', '320000', '320100', '320106', '1', '1', '莫愁街道', '0', '', '1', '0', '0', '10'),
('11127', '320000', '320100', '320107', '1', '1', '阅江楼街道', '0', '', '1', '0', '0', '10'),
('11128', '320000', '320100', '320107', '1', '1', '热河南路街道', '0', '', '1', '0', '0', '10'),
('11129', '320000', '320100', '320107', '1', '1', '幕府山街道', '0', '', '1', '0', '0', '10'),
('11130', '320000', '320100', '320107', '1', '1', '建宁路街道', '0', '', '1', '0', '0', '10'),
('11131', '320000', '320100', '320107', '1', '1', '宝塔桥街道', '0', '', '1', '0', '0', '10'),
('11132', '320000', '320100', '320107', '1', '1', '小市街道', '0', '', '1', '0', '0', '10'),
('11133', '320000', '320100', '320111', '1', '1', '泰山街道', '0', '', '1', '0', '0', '10'),
('11134', '320000', '320100', '320111', '1', '1', '顶山街道', '0', '', '1', '0', '0', '10'),
('11135', '320000', '320100', '320111', '1', '1', '沿江街道', '0', '', '1', '0', '0', '10'),
('11136', '320000', '320100', '320111', '1', '1', '江浦街道', '0', '', '1', '0', '0', '10'),
('11137', '320000', '320100', '320111', '1', '1', '高新花苑虚拟街道', '0', '', '1', '0', '0', '10'),
('11138', '320000', '320100', '320111', '1', '1', '桥林镇', '0', '', '1', '0', '0', '10'),
('11139', '320000', '320100', '320111', '1', '1', '永宁镇', '0', '', '1', '0', '0', '10'),
('11140', '320000', '320100', '320111', '1', '1', '汤泉镇', '0', '', '1', '0', '0', '10'),
('11141', '320000', '320100', '320111', '1', '1', '星甸镇', '0', '', '1', '0', '0', '10'),
('11142', '320000', '320100', '320111', '1', '1', '石桥镇', '0', '', '1', '0', '0', '10'),
('11143', '320000', '320100', '320111', '1', '1', '乌江镇', '0', '', '1', '0', '0', '10'),
('11144', '320000', '320100', '320111', '1', '1', '盘城镇', '0', '', '1', '0', '0', '10'),
('11145', '320000', '320100', '320111', '1', '1', '老山林场', '0', '', '1', '0', '0', '10'),
('11146', '320000', '320100', '320111', '1', '1', '汤泉农场', '0', '', '1', '0', '0', '10'),
('11147', '320000', '320100', '320111', '1', '1', '珍珠泉管委会', '0', '', '1', '0', '0', '10'),
('11148', '320000', '320100', '320113', '1', '1', '尧化街道', '0', '', '1', '0', '0', '10'),
('11149', '320000', '320100', '320113', '1', '1', '马群街道', '0', '', '1', '0', '0', '10'),
('11150', '320000', '320100', '320113', '1', '1', '迈皋桥街道', '0', '', '1', '0', '0', '10'),
('11151', '320000', '320100', '320113', '1', '1', '燕子矶街道', '0', '', '1', '0', '0', '10'),
('11152', '320000', '320100', '320113', '1', '1', '栖霞街道', '0', '', '1', '0', '0', '10'),
('11153', '320000', '320100', '320113', '1', '1', '龙潭街道', '0', '', '1', '0', '0', '10'),
('11154', '320000', '320100', '320113', '1', '1', '仙林街道', '0', '', '1', '0', '0', '10'),
('11155', '320000', '320100', '320113', '1', '1', '靖安街道', '0', '', '1', '0', '0', '10'),
('11156', '320000', '320100', '320113', '1', '1', '八卦洲街道', '0', '', '1', '0', '0', '10'),
('11157', '320000', '320100', '320113', '1', '1', '龙潭监狱', '0', '', '1', '0', '0', '10'),
('11158', '320000', '320100', '320113', '1', '1', '栖霞区技术经济开发区', '0', '', '1', '0', '0', '10'),
('11159', '320000', '320100', '320113', '1', '1', '南京龙潭物流园', '0', '', '1', '0', '0', '10'),
('11160', '320000', '320100', '320113', '1', '1', '南京市靖安三江口工业园', '0', '', '1', '0', '0', '10'),
('11161', '320000', '320100', '320113', '1', '1', '南京迈皋桥创业园', '0', '', '1', '0', '0', '10'),
('11162', '320000', '320100', '320113', '1', '1', '南京市马群科技园', '0', '', '1', '0', '0', '10'),
('11163', '320000', '320100', '320113', '1', '1', '南京仙林大学城', '0', '', '1', '0', '0', '10'),
('11164', '320000', '320100', '320113', '1', '1', '南京经济技术开发区', '0', '', '1', '0', '0', '10'),
('11165', '320000', '320100', '320114', '1', '1', '宁南街道', '0', '', '1', '0', '0', '10'),
('11166', '320000', '320100', '320114', '1', '1', '赛虹桥街道', '0', '', '1', '0', '0', '10'),
('11167', '320000', '320100', '320114', '1', '1', '雨花新村街道', '0', '', '1', '0', '0', '10'),
('11168', '320000', '320100', '320114', '1', '1', '西善桥街道', '0', '', '1', '0', '0', '10'),
('11169', '320000', '320100', '320114', '1', '1', '板桥街道', '0', '', '1', '0', '0', '10'),
('11170', '320000', '320100', '320114', '1', '1', '铁心桥街道', '0', '', '1', '0', '0', '10'),
('11171', '320000', '320100', '320114', '1', '1', '梅山街道', '0', '', '1', '0', '0', '10'),
('11172', '320000', '320100', '320114', '1', '1', '雨花经济技术开发区', '0', '', '1', '0', '0', '10'),
('11173', '320000', '320100', '320115', '1', '1', '东山街道', '0', '', '1', '0', '0', '10'),
('11174', '320000', '320100', '320115', '1', '1', '秣陵街道', '0', '', '1', '0', '0', '10'),
('11175', '320000', '320100', '320115', '1', '1', '汤山街道', '0', '', '1', '0', '0', '10'),
('11176', '320000', '320100', '320115', '1', '1', '淳化街道', '0', '', '1', '0', '0', '10'),
('11177', '320000', '320100', '320115', '1', '1', '禄口街道', '0', '', '1', '0', '0', '10'),
('11178', '320000', '320100', '320115', '1', '1', '江宁街道', '0', '', '1', '0', '0', '10'),
('11179', '320000', '320100', '320115', '1', '1', '谷里街道', '0', '', '1', '0', '0', '10'),
('11180', '320000', '320100', '320115', '1', '1', '湖熟镇', '0', '', '1', '0', '0', '10'),
('11181', '320000', '320100', '320115', '1', '1', '横溪镇', '0', '', '1', '0', '0', '10'),
('11182', '320000', '320100', '320115', '1', '1', '江宁科学园', '0', '', '1', '0', '0', '10'),
('11183', '320000', '320100', '320115', '1', '1', '青龙山林场', '0', '', '1', '0', '0', '10'),
('11184', '320000', '320100', '320115', '1', '1', '江宁开发区', '0', '', '1', '0', '0', '10'),
('11185', '320000', '320100', '320116', '1', '1', '卸甲甸街道', '0', '', '1', '0', '0', '10'),
('11186', '320000', '320100', '320116', '1', '1', '西厂门街道', '0', '', '1', '0', '0', '10'),
('11187', '320000', '320100', '320116', '1', '1', '山潘街道', '0', '', '1', '0', '0', '10'),
('11188', '320000', '320100', '320116', '1', '1', '葛塘街道', '0', '', '1', '0', '0', '10'),
('11189', '320000', '320100', '320116', '1', '1', '长芦街道', '0', '', '1', '0', '0', '10'),
('11190', '320000', '320100', '320116', '1', '1', '雄州镇', '0', '', '1', '0', '0', '10'),
('11191', '320000', '320100', '320116', '1', '1', '冶山镇', '0', '', '1', '0', '0', '10'),
('11192', '320000', '320100', '320116', '1', '1', '八百桥镇', '0', '', '1', '0', '0', '10'),
('11193', '320000', '320100', '320116', '1', '1', '横梁镇', '0', '', '1', '0', '0', '10'),
('11194', '320000', '320100', '320116', '1', '1', '东沟镇', '0', '', '1', '0', '0', '10'),
('11195', '320000', '320100', '320116', '1', '1', '龙袍镇', '0', '', '1', '0', '0', '10'),
('11196', '320000', '320100', '320116', '1', '1', '玉带镇', '0', '', '1', '0', '0', '10'),
('11197', '320000', '320100', '320116', '1', '1', '瓜埠镇', '0', '', '1', '0', '0', '10'),
('11198', '320000', '320100', '320116', '1', '1', '新集镇', '0', '', '1', '0', '0', '10'),
('11199', '320000', '320100', '320116', '1', '1', '程桥镇', '0', '', '1', '0', '0', '10'),
('11200', '320000', '320100', '320116', '1', '1', '竹镇镇', '0', '', '1', '0', '0', '10'),
('11201', '320000', '320100', '320116', '1', '1', '马集镇', '0', '', '1', '0', '0', '10'),
('11202', '320000', '320100', '320116', '1', '1', '马鞍镇', '0', '', '1', '0', '0', '10'),
('11203', '320000', '320100', '320116', '1', '1', '新篁镇', '0', '', '1', '0', '0', '10'),
('11204', '320000', '320100', '320116', '1', '1', '六合开发区', '0', '', '1', '0', '0', '10'),
('11205', '320000', '320100', '320124', '1', '1', '永阳镇', '0', '', '1', '0', '0', '10'),
('11206', '320000', '320100', '320124', '1', '1', '白马镇', '0', '', '1', '0', '0', '10'),
('11207', '320000', '320100', '320124', '1', '1', '东屏镇', '0', '', '1', '0', '0', '10'),
('11208', '320000', '320100', '320124', '1', '1', '柘塘镇', '0', '', '1', '0', '0', '10'),
('11209', '320000', '320100', '320124', '1', '1', '石湫镇', '0', '', '1', '0', '0', '10'),
('11210', '320000', '320100', '320124', '1', '1', '洪蓝镇', '0', '', '1', '0', '0', '10'),
('11211', '320000', '320100', '320124', '1', '1', '晶桥镇', '0', '', '1', '0', '0', '10'),
('11212', '320000', '320100', '320124', '1', '1', '和凤镇', '0', '', '1', '0', '0', '10'),
('11213', '320000', '320100', '320124', '1', '1', '溧水县开发区', '0', '', '1', '0', '0', '10'),
('11214', '320000', '320100', '320125', '1', '1', '淳溪镇', '0', '', '1', '0', '0', '10'),
('11215', '320000', '320100', '320125', '1', '1', '阳江镇', '0', '', '1', '0', '0', '10'),
('11216', '320000', '320100', '320125', '1', '1', '砖墙镇', '0', '', '1', '0', '0', '10'),
('11217', '320000', '320100', '320125', '1', '1', '古柏镇', '0', '', '1', '0', '0', '10'),
('11218', '320000', '320100', '320125', '1', '1', '漆桥镇', '0', '', '1', '0', '0', '10'),
('11219', '320000', '320100', '320125', '1', '1', '固城镇', '0', '', '1', '0', '0', '10'),
('11220', '320000', '320100', '320125', '1', '1', '东坝镇', '0', '', '1', '0', '0', '10'),
('11221', '320000', '320100', '320125', '1', '1', '桠溪镇', '0', '', '1', '0', '0', '10'),
('11222', '320000', '320100', '320125', '1', '1', '高淳县团结圩良种繁育场', '0', '', '1', '0', '0', '10'),
('11223', '320000', '320100', '320125', '1', '1', '高淳县茶叶实验场', '0', '', '1', '0', '0', '10'),
('11224', '320000', '320100', '320125', '1', '1', '高淳监狱', '0', '', '1', '0', '0', '10'),
('11225', '320000', '320100', '320125', '1', '1', '高淳县傅家坛林场', '0', '', '1', '0', '0', '10'),
('11226', '320000', '320200', '320202', '1', '1', '崇安寺街道', '0', '', '1', '0', '0', '10'),
('11227', '320000', '320200', '320202', '1', '1', '通江街道', '0', '', '1', '0', '0', '10'),
('11228', '320000', '320200', '320202', '1', '1', '广瑞路街道', '0', '', '1', '0', '0', '10'),
('11229', '320000', '320200', '320202', '1', '1', '上马墩街道', '0', '', '1', '0', '0', '10'),
('11230', '320000', '320200', '320202', '1', '1', '江海街道', '0', '', '1', '0', '0', '10'),
('11231', '320000', '320200', '320202', '1', '1', '广益街道', '0', '', '1', '0', '0', '10'),
('11232', '320000', '320200', '320203', '1', '1', '迎龙桥街道', '0', '', '1', '0', '0', '10'),
('11233', '320000', '320200', '320203', '1', '1', '南禅寺街道', '0', '', '1', '0', '0', '10'),
('11234', '320000', '320200', '320203', '1', '1', '清名桥街道', '0', '', '1', '0', '0', '10'),
('11235', '320000', '320200', '320203', '1', '1', '金星街道', '0', '', '1', '0', '0', '10'),
('11236', '320000', '320200', '320203', '1', '1', '金匮街道', '0', '', '1', '0', '0', '10'),
('11237', '320000', '320200', '320203', '1', '1', '扬名街道', '0', '', '1', '0', '0', '10'),
('11238', '320000', '320200', '320204', '1', '1', '黄巷街道', '0', '', '1', '0', '0', '10'),
('11239', '320000', '320200', '320204', '1', '1', '山北街道', '0', '', '1', '0', '0', '10'),
('11240', '320000', '320200', '320204', '1', '1', '北大街街道', '0', '', '1', '0', '0', '10'),
('11241', '320000', '320200', '320204', '1', '1', '惠山街道', '0', '', '1', '0', '0', '10'),
('11242', '320000', '320200', '320205', '1', '1', '东亭街道', '0', '', '1', '0', '0', '10'),
('11243', '320000', '320200', '320205', '1', '1', '安镇镇', '0', '', '1', '0', '0', '10'),
('11244', '320000', '320200', '320205', '1', '1', '羊尖镇', '0', '', '1', '0', '0', '10'),
('11245', '320000', '320200', '320205', '1', '1', '鹅湖镇', '0', '', '1', '0', '0', '10'),
('11246', '320000', '320200', '320205', '1', '1', '东北塘镇', '0', '', '1', '0', '0', '10'),
('11247', '320000', '320200', '320205', '1', '1', '锡北镇', '0', '', '1', '0', '0', '10'),
('11248', '320000', '320200', '320205', '1', '1', '东港镇', '0', '', '1', '0', '0', '10'),
('11249', '320000', '320200', '320205', '1', '1', '无锡锡山开发区', '0', '', '1', '0', '0', '10'),
('11250', '320000', '320200', '320206', '1', '1', '堰桥街道', '0', '', '1', '0', '0', '10'),
('11251', '320000', '320200', '320206', '1', '1', '长安街道', '0', '', '1', '0', '0', '10'),
('11252', '320000', '320200', '320206', '1', '1', '前洲镇', '0', '', '1', '0', '0', '10'),
('11253', '320000', '320200', '320206', '1', '1', '玉祁镇', '0', '', '1', '0', '0', '10'),
('11254', '320000', '320200', '320206', '1', '1', '洛社镇', '0', '', '1', '0', '0', '10'),
('11255', '320000', '320200', '320206', '1', '1', '钱桥镇', '0', '', '1', '0', '0', '10'),
('11256', '320000', '320200', '320206', '1', '1', '阳山镇', '0', '', '1', '0', '0', '10'),
('11257', '320000', '320200', '320206', '1', '1', '无锡惠山经济开发区', '0', '', '1', '0', '0', '10'),
('11258', '320000', '320200', '320211', '1', '1', '河埒街道', '0', '', '1', '0', '0', '10'),
('11259', '320000', '320200', '320211', '1', '1', '荣巷街道', '0', '', '1', '0', '0', '10'),
('11260', '320000', '320200', '320211', '1', '1', '蠡园街道', '0', '', '1', '0', '0', '10'),
('11261', '320000', '320200', '320211', '1', '1', '蠡湖街道', '0', '', '1', '0', '0', '10'),
('11262', '320000', '320200', '320211', '1', '1', '滨湖街道', '0', '', '1', '0', '0', '10'),
('11263', '320000', '320200', '320211', '1', '1', '华庄街道', '0', '', '1', '0', '0', '10'),
('11264', '320000', '320200', '320211', '1', '1', '太湖街道', '0', '', '1', '0', '0', '10'),
('11265', '320000', '320200', '320211', '1', '1', '雪浪街道', '0', '', '1', '0', '0', '10'),
('11266', '320000', '320200', '320211', '1', '1', '旺庄街道', '0', '', '1', '0', '0', '10'),
('11267', '320000', '320200', '320211', '1', '1', '硕放街道', '0', '', '1', '0', '0', '10'),
('11268', '320000', '320200', '320211', '1', '1', '南站街道', '0', '', '1', '0', '0', '10'),
('11269', '320000', '320200', '320211', '1', '1', '坊前街道', '0', '', '1', '0', '0', '10'),
('11270', '320000', '320200', '320211', '1', '1', '马山镇', '0', '', '1', '0', '0', '10'),
('11271', '320000', '320200', '320211', '1', '1', '胡埭镇', '0', '', '1', '0', '0', '10'),
('11272', '320000', '320200', '320211', '1', '1', '梅村镇', '0', '', '1', '0', '0', '10'),
('11273', '320000', '320200', '320211', '1', '1', '鸿山镇', '0', '', '1', '0', '0', '10'),
('11274', '320000', '320200', '320211', '1', '1', '无锡新加坡工业园', '0', '', '1', '0', '0', '10'),
('11275', '320000', '320200', '320211', '1', '1', '无锡高新技术产业开发区', '0', '', '1', '0', '0', '10'),
('11276', '320000', '320200', '320281', '1', '1', '澄江镇', '0', '', '1', '0', '0', '10'),
('11277', '320000', '320200', '320281', '1', '1', '璜土镇', '0', '', '1', '0', '0', '10'),
('11278', '320000', '320200', '320281', '1', '1', '利港镇', '0', '', '1', '0', '0', '10'),
('11279', '320000', '320200', '320281', '1', '1', '申港镇', '0', '', '1', '0', '0', '10'),
('11280', '320000', '320200', '320281', '1', '1', '夏港镇', '0', '', '1', '0', '0', '10'),
('11281', '320000', '320200', '320281', '1', '1', '月城镇', '0', '', '1', '0', '0', '10'),
('11282', '320000', '320200', '320281', '1', '1', '青阳镇', '0', '', '1', '0', '0', '10'),
('11283', '320000', '320200', '320281', '1', '1', '霞客镇', '0', '', '1', '0', '0', '10'),
('11284', '320000', '320200', '320281', '1', '1', '南闸镇', '0', '', '1', '0', '0', '10'),
('11285', '320000', '320200', '320281', '1', '1', '云亭镇', '0', '', '1', '0', '0', '10'),
('11286', '320000', '320200', '320281', '1', '1', '华士镇', '0', '', '1', '0', '0', '10'),
('11287', '320000', '320200', '320281', '1', '1', '周庄镇', '0', '', '1', '0', '0', '10'),
('11288', '320000', '320200', '320281', '1', '1', '新桥镇', '0', '', '1', '0', '0', '10'),
('11289', '320000', '320200', '320281', '1', '1', '长泾镇', '0', '', '1', '0', '0', '10'),
('11290', '320000', '320200', '320281', '1', '1', '顾山镇', '0', '', '1', '0', '0', '10'),
('11291', '320000', '320200', '320281', '1', '1', '祝塘镇', '0', '', '1', '0', '0', '10'),
('11292', '320000', '320200', '320281', '1', '1', '江阴经济开发区新城东', '0', '', '1', '0', '0', '10'),
('11293', '320000', '320200', '320281', '1', '1', '江阴经济开发区港口', '0', '', '1', '0', '0', '10'),
('11294', '320000', '320200', '320281', '1', '1', '江阴经济开发区石庄', '0', '', '1', '0', '0', '10'),
('11295', '320000', '320200', '320281', '1', '1', '江阴经济开发区靖江园区', '0', '', '1', '0', '0', '10'),
('11296', '320000', '320200', '320282', '1', '1', '宜城街道', '0', '', '1', '0', '0', '10'),
('11297', '320000', '320200', '320282', '1', '1', '屺亭街道', '0', '', '1', '0', '0', '10'),
('11298', '320000', '320200', '320282', '1', '1', '张渚镇', '0', '', '1', '0', '0', '10'),
('11299', '320000', '320200', '320282', '1', '1', '西渚镇', '0', '', '1', '0', '0', '10'),
('11300', '320000', '320200', '320282', '1', '1', '太华镇', '0', '', '1', '0', '0', '10'),
('11301', '320000', '320200', '320282', '1', '1', '徐舍镇', '0', '', '1', '0', '0', '10'),
('11302', '320000', '320200', '320282', '1', '1', '鲸塘镇', '0', '', '1', '0', '0', '10'),
('11303', '320000', '320200', '320282', '1', '1', '芳庄镇', '0', '', '1', '0', '0', '10'),
('11304', '320000', '320200', '320282', '1', '1', '官林镇', '0', '', '1', '0', '0', '10'),
('11305', '320000', '320200', '320282', '1', '1', '杨巷镇', '0', '', '1', '0', '0', '10'),
('11306', '320000', '320200', '320282', '1', '1', '新建镇', '0', '', '1', '0', '0', '10'),
('11307', '320000', '320200', '320282', '1', '1', '和桥镇', '0', '', '1', '0', '0', '10'),
('11308', '320000', '320200', '320282', '1', '1', '高塍镇', '0', '', '1', '0', '0', '10'),
('11309', '320000', '320200', '320282', '1', '1', '万石镇', '0', '', '1', '0', '0', '10'),
('11310', '320000', '320200', '320282', '1', '1', '周铁镇', '0', '', '1', '0', '0', '10'),
('11311', '320000', '320200', '320282', '1', '1', '芳桥镇', '0', '', '1', '0', '0', '10'),
('11312', '320000', '320200', '320282', '1', '1', '新庄镇', '0', '', '1', '0', '0', '10'),
('11313', '320000', '320200', '320282', '1', '1', '丁蜀镇', '0', '', '1', '0', '0', '10'),
('11314', '320000', '320200', '320282', '1', '1', '大浦镇', '0', '', '1', '0', '0', '10'),
('11315', '320000', '320200', '320282', '1', '1', '湖父镇', '0', '', '1', '0', '0', '10'),
('11316', '320000', '320200', '320282', '1', '1', '新街镇', '0', '', '1', '0', '0', '10'),
('11317', '320000', '320200', '320282', '1', '1', '环科园', '0', '', '1', '0', '0', '10'),
('11318', '320000', '320200', '320282', '1', '1', '宜兴经济开发区', '0', '', '1', '0', '0', '10'),
('11319', '320000', '320200', '320282', '1', '1', '芙蓉茶场', '0', '', '1', '0', '0', '10'),
('11320', '320000', '320200', '320282', '1', '1', '宜兴市林场', '0', '', '1', '0', '0', '10'),
('11321', '320000', '320200', '320282', '1', '1', '宜兴市大贤岭林场', '0', '', '1', '0', '0', '10'),
('11322', '320000', '320200', '320282', '1', '1', '无锡市茶叶研究所', '0', '', '1', '0', '0', '10'),
('11323', '320000', '320300', '320302', '1', '1', '黄楼街道', '0', '', '1', '0', '0', '10'),
('11324', '320000', '320300', '320302', '1', '1', '丰财街道', '0', '', '1', '0', '0', '10'),
('11325', '320000', '320300', '320302', '1', '1', '琵琶街道', '0', '', '1', '0', '0', '10'),
('11326', '320000', '320300', '320302', '1', '1', '牌楼街道', '0', '', '1', '0', '0', '10'),
('11327', '320000', '320300', '320302', '1', '1', '铜沛街道', '0', '', '1', '0', '0', '10'),
('11328', '320000', '320300', '320302', '1', '1', '环城街道', '0', '', '1', '0', '0', '10'),
('11329', '320000', '320300', '320302', '1', '1', '金山桥街道', '0', '', '1', '0', '0', '10'),
('11330', '320000', '320300', '320302', '1', '1', '东环街道', '0', '', '1', '0', '0', '10'),
('11331', '320000', '320300', '320302', '1', '1', '大黄山街道', '0', '', '1', '0', '0', '10'),
('11332', '320000', '320300', '320302', '1', '1', '大庙镇', '0', '', '1', '0', '0', '10'),
('11333', '320000', '320300', '320302', '1', '1', '大黄山镇', '0', '', '1', '0', '0', '10'),
('11334', '320000', '320300', '320303', '1', '1', '彭城街道', '0', '', '1', '0', '0', '10'),
('11335', '320000', '320300', '320303', '1', '1', '子房街道', '0', '', '1', '0', '0', '10'),
('11336', '320000', '320300', '320303', '1', '1', '黄山街道', '0', '', '1', '0', '0', '10'),
('11337', '320000', '320300', '320303', '1', '1', '骆驼山街道', '0', '', '1', '0', '0', '10'),
('11338', '320000', '320300', '320303', '1', '1', '大郭庄街道', '0', '', '1', '0', '0', '10'),
('11339', '320000', '320300', '320303', '1', '1', '翠屏山街道', '0', '', '1', '0', '0', '10'),
('11340', '320000', '320300', '320303', '1', '1', '潘塘街道', '0', '', '1', '0', '0', '10'),
('11341', '320000', '320300', '320304', '1', '1', '庞庄街道', '0', '', '1', '0', '0', '10'),
('11342', '320000', '320300', '320304', '1', '1', '利国街道', '0', '', '1', '0', '0', '10'),
('11343', '320000', '320300', '320304', '1', '1', '桃园街道', '0', '', '1', '0', '0', '10'),
('11344', '320000', '320300', '320304', '1', '1', '三河尖街道', '0', '', '1', '0', '0', '10'),
('11345', '320000', '320300', '320304', '1', '1', '垞城街道', '0', '', '1', '0', '0', '10'),
('11346', '320000', '320300', '320304', '1', '1', '义安街道', '0', '', '1', '0', '0', '10'),
('11347', '320000', '320300', '320304', '1', '1', '张集街道', '0', '', '1', '0', '0', '10'),
('11348', '320000', '320300', '320304', '1', '1', '电厂街道', '0', '', '1', '0', '0', '10'),
('11349', '320000', '320300', '320304', '1', '1', '张双楼街道', '0', '', '1', '0', '0', '10'),
('11350', '320000', '320300', '320304', '1', '1', '九里街道', '0', '', '1', '0', '0', '10'),
('11351', '320000', '320300', '320304', '1', '1', '拾屯街道', '0', '', '1', '0', '0', '10'),
('11352', '320000', '320300', '320304', '1', '1', '苏山街道', '0', '', '1', '0', '0', '10'),
('11353', '320000', '320300', '320304', '1', '1', '火花街道', '0', '', '1', '0', '0', '10'),
('11354', '320000', '320300', '320305', '1', '1', '老矿街道', '0', '', '1', '0', '0', '10'),
('11355', '320000', '320300', '320305', '1', '1', '夏桥街道', '0', '', '1', '0', '0', '10'),
('11356', '320000', '320300', '320305', '1', '1', '贾汪镇', '0', '', '1', '0', '0', '10'),
('11357', '320000', '320300', '320305', '1', '1', '青山泉镇', '0', '', '1', '0', '0', '10'),
('11358', '320000', '320300', '320305', '1', '1', '大吴镇', '0', '', '1', '0', '0', '10'),
('11359', '320000', '320300', '320305', '1', '1', '紫庄镇', '0', '', '1', '0', '0', '10'),
('11360', '320000', '320300', '320305', '1', '1', '塔山镇', '0', '', '1', '0', '0', '10'),
('11361', '320000', '320300', '320305', '1', '1', '汴塘镇', '0', '', '1', '0', '0', '10'),
('11362', '320000', '320300', '320305', '1', '1', '江庄镇', '0', '', '1', '0', '0', '10'),
('11363', '320000', '320300', '320305', '1', '1', '工业园区管委会', '0', '', '1', '0', '0', '10'),
('11364', '320000', '320300', '320305', '1', '1', '鹿庄粮棉原种场', '0', '', '1', '0', '0', '10'),
('11365', '320000', '320300', '320311', '1', '1', '王陵街道', '0', '', '1', '0', '0', '10'),
('11366', '320000', '320300', '320311', '1', '1', '永安街道', '0', '', '1', '0', '0', '10'),
('11367', '320000', '320300', '320311', '1', '1', '湖滨街道', '0', '', '1', '0', '0', '10'),
('11368', '320000', '320300', '320311', '1', '1', '段庄街道', '0', '', '1', '0', '0', '10'),
('11369', '320000', '320300', '320311', '1', '1', '翟山街道', '0', '', '1', '0', '0', '10'),
('11370', '320000', '320300', '320311', '1', '1', '奎山街道', '0', '', '1', '0', '0', '10'),
('11371', '320000', '320300', '320311', '1', '1', '和平街道', '0', '', '1', '0', '0', '10'),
('11372', '320000', '320300', '320311', '1', '1', '泰山街道', '0', '', '1', '0', '0', '10'),
('11373', '320000', '320300', '320311', '1', '1', '金山街道', '0', '', '1', '0', '0', '10'),
('11374', '320000', '320300', '320311', '1', '1', '七里沟街道', '0', '', '1', '0', '0', '10'),
('11375', '320000', '320300', '320321', '1', '1', '凤城镇', '0', '', '1', '0', '0', '10'),
('11376', '320000', '320300', '320321', '1', '1', '首羡镇', '0', '', '1', '0', '0', '10'),
('11377', '320000', '320300', '320321', '1', '1', '顺河镇', '0', '', '1', '0', '0', '10'),
('11378', '320000', '320300', '320321', '1', '1', '常店镇', '0', '', '1', '0', '0', '10'),
('11379', '320000', '320300', '320321', '1', '1', '欢口镇', '0', '', '1', '0', '0', '10'),
('11380', '320000', '320300', '320321', '1', '1', '师寨镇', '0', '', '1', '0', '0', '10'),
('11381', '320000', '320300', '320321', '1', '1', '华山镇', '0', '', '1', '0', '0', '10'),
('11382', '320000', '320300', '320321', '1', '1', '梁寨镇', '0', '', '1', '0', '0', '10'),
('11383', '320000', '320300', '320321', '1', '1', '范楼镇', '0', '', '1', '0', '0', '10'),
('11384', '320000', '320300', '320321', '1', '1', '孙楼镇', '0', '', '1', '0', '0', '10'),
('11385', '320000', '320300', '320321', '1', '1', '宋楼镇', '0', '', '1', '0', '0', '10'),
('11386', '320000', '320300', '320321', '1', '1', '大沙河镇', '0', '', '1', '0', '0', '10'),
('11387', '320000', '320300', '320321', '1', '1', '王沟镇', '0', '', '1', '0', '0', '10'),
('11388', '320000', '320300', '320321', '1', '1', '赵庄镇', '0', '', '1', '0', '0', '10'),
('11389', '320000', '320300', '320321', '1', '1', '大沙河林场', '0', '', '1', '0', '0', '10'),
('11390', '320000', '320300', '320322', '1', '1', '龙固镇', '0', '', '1', '0', '0', '10'),
('11391', '320000', '320300', '320322', '1', '1', '杨屯镇', '0', '', '1', '0', '0', '10'),
('11392', '320000', '320300', '320322', '1', '1', '大屯镇', '0', '', '1', '0', '0', '10'),
('11393', '320000', '320300', '320322', '1', '1', '沛城镇', '0', '', '1', '0', '0', '10'),
('11394', '320000', '320300', '320322', '1', '1', '胡寨镇', '0', '', '1', '0', '0', '10'),
('11395', '320000', '320300', '320322', '1', '1', '魏庙镇', '0', '', '1', '0', '0', '10'),
('11396', '320000', '320300', '320322', '1', '1', '五段镇', '0', '', '1', '0', '0', '10'),
('11397', '320000', '320300', '320322', '1', '1', '张庄镇', '0', '', '1', '0', '0', '10'),
('11398', '320000', '320300', '320322', '1', '1', '张寨镇', '0', '', '1', '0', '0', '10'),
('11399', '320000', '320300', '320322', '1', '1', '敬安镇', '0', '', '1', '0', '0', '10'),
('11400', '320000', '320300', '320322', '1', '1', '河口镇', '0', '', '1', '0', '0', '10'),
('11401', '320000', '320300', '320322', '1', '1', '栖山镇', '0', '', '1', '0', '0', '10'),
('11402', '320000', '320300', '320322', '1', '1', '鹿楼镇', '0', '', '1', '0', '0', '10'),
('11403', '320000', '320300', '320322', '1', '1', '朱寨镇', '0', '', '1', '0', '0', '10'),
('11404', '320000', '320300', '320322', '1', '1', '安国镇', '0', '', '1', '0', '0', '10'),
('11405', '320000', '320300', '320322', '1', '1', '中煤集团大屯煤电(集团)公司', '0', '', '1', '0', '0', '10'),
('11406', '320000', '320300', '320322', '1', '1', '经济开发区', '0', '', '1', '0', '0', '10'),
('11407', '320000', '320300', '320323', '1', '1', '铜山镇', '0', '', '1', '0', '0', '10'),
('11408', '320000', '320300', '320323', '1', '1', '何桥镇', '0', '', '1', '0', '0', '10'),
('11409', '320000', '320300', '320323', '1', '1', '黄集镇', '0', '', '1', '0', '0', '10'),
('11410', '320000', '320300', '320323', '1', '1', '马坡镇', '0', '', '1', '0', '0', '10'),
('11411', '320000', '320300', '320323', '1', '1', '郑集镇', '0', '', '1', '0', '0', '10'),
('11412', '320000', '320300', '320323', '1', '1', '柳新镇', '0', '', '1', '0', '0', '10'),
('11413', '320000', '320300', '320323', '1', '1', '刘集镇', '0', '', '1', '0', '0', '10'),
('11414', '320000', '320300', '320323', '1', '1', '大彭镇', '0', '', '1', '0', '0', '10'),
('11415', '320000', '320300', '320323', '1', '1', '汉王镇', '0', '', '1', '0', '0', '10'),
('11416', '320000', '320300', '320323', '1', '1', '三堡镇', '0', '', '1', '0', '0', '10'),
('11417', '320000', '320300', '320323', '1', '1', '棠张镇', '0', '', '1', '0', '0', '10'),
('11418', '320000', '320300', '320323', '1', '1', '张集镇', '0', '', '1', '0', '0', '10'),
('11419', '320000', '320300', '320323', '1', '1', '房村镇', '0', '', '1', '0', '0', '10'),
('11420', '320000', '320300', '320323', '1', '1', '伊庄镇', '0', '', '1', '0', '0', '10'),
('11421', '320000', '320300', '320323', '1', '1', '单集镇', '0', '', '1', '0', '0', '10'),
('11422', '320000', '320300', '320323', '1', '1', '徐庄镇', '0', '', '1', '0', '0', '10'),
('11423', '320000', '320300', '320323', '1', '1', '大许镇', '0', '', '1', '0', '0', '10'),
('11424', '320000', '320300', '320323', '1', '1', '茅村镇', '0', '', '1', '0', '0', '10'),
('11425', '320000', '320300', '320323', '1', '1', '柳泉镇', '0', '', '1', '0', '0', '10'),
('11426', '320000', '320300', '320323', '1', '1', '利国镇', '0', '', '1', '0', '0', '10'),
('11427', '320000', '320300', '320323', '1', '1', '国营沿湖农', '0', '', '1', '0', '0', '10'),
('11428', '320000', '320300', '320324', '1', '1', '睢城镇', '0', '', '1', '0', '0', '10'),
('11429', '320000', '320300', '320324', '1', '1', '王集镇', '0', '', '1', '0', '0', '10'),
('11430', '320000', '320300', '320324', '1', '1', '双沟镇', '0', '', '1', '0', '0', '10'),
('11431', '320000', '320300', '320324', '1', '1', '岚山镇', '0', '', '1', '0', '0', '10'),
('11432', '320000', '320300', '320324', '1', '1', '李集镇', '0', '', '1', '0', '0', '10'),
('11433', '320000', '320300', '320324', '1', '1', '桃园镇', '0', '', '1', '0', '0', '10'),
('11434', '320000', '320300', '320324', '1', '1', '官山镇', '0', '', '1', '0', '0', '10'),
('11435', '320000', '320300', '320324', '1', '1', '高作镇', '0', '', '1', '0', '0', '10'),
('11436', '320000', '320300', '320324', '1', '1', '沙集镇', '0', '', '1', '0', '0', '10'),
('11437', '320000', '320300', '320324', '1', '1', '凌城镇', '0', '', '1', '0', '0', '10'),
('11438', '320000', '320300', '320324', '1', '1', '邱集镇', '0', '', '1', '0', '0', '10'),
('11439', '320000', '320300', '320324', '1', '1', '古邳镇', '0', '', '1', '0', '0', '10'),
('11440', '320000', '320300', '320324', '1', '1', '姚集镇', '0', '', '1', '0', '0', '10'),
('11441', '320000', '320300', '320324', '1', '1', '魏集镇', '0', '', '1', '0', '0', '10'),
('11442', '320000', '320300', '320324', '1', '1', '梁集镇', '0', '', '1', '0', '0', '10'),
('11443', '320000', '320300', '320324', '1', '1', '庆安镇', '0', '', '1', '0', '0', '10'),
('11444', '320000', '320300', '320324', '1', '1', '经济开发区', '0', '', '1', '0', '0', '10'),
('11445', '320000', '320300', '320381', '1', '1', '新安镇', '0', '', '1', '0', '0', '10'),
('11446', '320000', '320300', '320381', '1', '1', '瓦窑镇', '0', '', '1', '0', '0', '10'),
('11447', '320000', '320300', '320381', '1', '1', '港头镇', '0', '', '1', '0', '0', '10'),
('11448', '320000', '320300', '320381', '1', '1', '唐店镇', '0', '', '1', '0', '0', '10'),
('11449', '320000', '320300', '320381', '1', '1', '合沟镇', '0', '', '1', '0', '0', '10'),
('11450', '320000', '320300', '320381', '1', '1', '草桥镇', '0', '', '1', '0', '0', '10'),
('11451', '320000', '320300', '320381', '1', '1', '窑湾镇', '0', '', '1', '0', '0', '10'),
('11452', '320000', '320300', '320381', '1', '1', '棋盘镇', '0', '', '1', '0', '0', '10'),
('11453', '320000', '320300', '320381', '1', '1', '新店镇', '0', '', '1', '0', '0', '10'),
('11454', '320000', '320300', '320381', '1', '1', '邵店镇', '0', '', '1', '0', '0', '10'),
('11455', '320000', '320300', '320381', '1', '1', '北沟镇', '0', '', '1', '0', '0', '10'),
('11456', '320000', '320300', '320381', '1', '1', '时集镇', '0', '', '1', '0', '0', '10'),
('11457', '320000', '320300', '320381', '1', '1', '高流镇', '0', '', '1', '0', '0', '10'),
('11458', '320000', '320300', '320381', '1', '1', '阿湖镇', '0', '', '1', '0', '0', '10'),
('11459', '320000', '320300', '320381', '1', '1', '双塘镇', '0', '', '1', '0', '0', '10'),
('11460', '320000', '320300', '320381', '1', '1', '马岭山镇', '0', '', '1', '0', '0', '10'),
('11461', '320000', '320300', '320381', '1', '1', '经济开发区', '0', '', '1', '0', '0', '10'),
('11462', '320000', '320300', '320382', '1', '1', '运河镇', '0', '', '1', '0', '0', '10'),
('11463', '320000', '320300', '320382', '1', '1', '邳城镇', '0', '', '1', '0', '0', '10'),
('11464', '320000', '320300', '320382', '1', '1', '官湖镇', '0', '', '1', '0', '0', '10'),
('11465', '320000', '320300', '320382', '1', '1', '四户镇', '0', '', '1', '0', '0', '10'),
('11466', '320000', '320300', '320382', '1', '1', '宿羊山镇', '0', '', '1', '0', '0', '10'),
('11467', '320000', '320300', '320382', '1', '1', '八义集镇', '0', '', '1', '0', '0', '10'),
('11468', '320000', '320300', '320382', '1', '1', '土山镇', '0', '', '1', '0', '0', '10'),
('11469', '320000', '320300', '320382', '1', '1', '碾庄镇', '0', '', '1', '0', '0', '10'),
('11470', '320000', '320300', '320382', '1', '1', '港上镇', '0', '', '1', '0', '0', '10'),
('11471', '320000', '320300', '320382', '1', '1', '邹庄镇', '0', '', '1', '0', '0', '10'),
('11472', '320000', '320300', '320382', '1', '1', '占城镇', '0', '', '1', '0', '0', '10'),
('11473', '320000', '320300', '320382', '1', '1', '新河镇', '0', '', '1', '0', '0', '10'),
('11474', '320000', '320300', '320382', '1', '1', '八路镇', '0', '', '1', '0', '0', '10'),
('11475', '320000', '320300', '320382', '1', '1', '炮车镇', '0', '', '1', '0', '0', '10'),
('11476', '320000', '320300', '320382', '1', '1', '铁富镇', '0', '', '1', '0', '0', '10'),
('11477', '320000', '320300', '320382', '1', '1', '岔河镇', '0', '', '1', '0', '0', '10'),
('11478', '320000', '320300', '320382', '1', '1', '戴圩镇', '0', '', '1', '0', '0', '10'),
('11479', '320000', '320300', '320382', '1', '1', '陈楼镇', '0', '', '1', '0', '0', '10'),
('11480', '320000', '320300', '320382', '1', '1', '邢楼镇', '0', '', '1', '0', '0', '10'),
('11481', '320000', '320300', '320382', '1', '1', '戴庄镇', '0', '', '1', '0', '0', '10'),
('11482', '320000', '320300', '320382', '1', '1', '车辐山镇', '0', '', '1', '0', '0', '10'),
('11483', '320000', '320300', '320382', '1', '1', '燕子埠镇', '0', '', '1', '0', '0', '10'),
('11484', '320000', '320300', '320382', '1', '1', '赵墩镇', '0', '', '1', '0', '0', '10'),
('11485', '320000', '320300', '320382', '1', '1', '议堂镇', '0', '', '1', '0', '0', '10'),
('11486', '320000', '320300', '320382', '1', '1', '邳城农场', '0', '', '1', '0', '0', '10'),
('11487', '320000', '320300', '320382', '1', '1', '张楼农场', '0', '', '1', '0', '0', '10'),
('11488', '320000', '320400', '320402', '1', '1', '雕庄街道', '0', '', '1', '0', '0', '10'),
('11489', '320000', '320400', '320402', '1', '1', '青龙街道', '0', '', '1', '0', '0', '10'),
('11490', '320000', '320400', '320402', '1', '1', '茶山街道', '0', '', '1', '0', '0', '10'),
('11491', '320000', '320400', '320402', '1', '1', '红梅街道', '0', '', '1', '0', '0', '10'),
('11492', '320000', '320400', '320402', '1', '1', '天宁街道', '0', '', '1', '0', '0', '10'),
('11493', '320000', '320400', '320402', '1', '1', '兰陵街道', '0', '', '1', '0', '0', '10'),
('11494', '320000', '320400', '320404', '1', '1', '五星街道', '0', '', '1', '0', '0', '10'),
('11495', '320000', '320400', '320404', '1', '1', '永红街道', '0', '', '1', '0', '0', '10'),
('11496', '320000', '320400', '320404', '1', '1', '北港街道', '0', '', '1', '0', '0', '10'),
('11497', '320000', '320400', '320404', '1', '1', '西林街道', '0', '', '1', '0', '0', '10'),
('11498', '320000', '320400', '320404', '1', '1', '南大街街道', '0', '', '1', '0', '0', '10'),
('11499', '320000', '320400', '320404', '1', '1', '荷花池街道', '0', '', '1', '0', '0', '10'),
('11500', '320000', '320400', '320404', '1', '1', '新闸镇', '0', '', '1', '0', '0', '10'),
('11501', '320000', '320400', '320405', '1', '1', '戚墅堰街道', '0', '', '1', '0', '0', '10'),
('11502', '320000', '320400', '320405', '1', '1', '丁堰镇', '0', '', '1', '0', '0', '10'),
('11503', '320000', '320400', '320405', '1', '1', '潞城镇', '0', '', '1', '0', '0', '10'),
('11504', '320000', '320400', '320411', '1', '1', '河海街道', '0', '', '1', '0', '0', '10'),
('11505', '320000', '320400', '320411', '1', '1', '三井街道', '0', '', '1', '0', '0', '10'),
('11506', '320000', '320400', '320411', '1', '1', '龙虎塘街道', '0', '', '1', '0', '0', '10'),
('11507', '320000', '320400', '320411', '1', '1', '春江镇', '0', '', '1', '0', '0', '10'),
('11508', '320000', '320400', '320411', '1', '1', '孟河镇', '0', '', '1', '0', '0', '10'),
('11509', '320000', '320400', '320411', '1', '1', '新桥镇', '0', '', '1', '0', '0', '10'),
('11510', '320000', '320400', '320411', '1', '1', '薛家镇', '0', '', '1', '0', '0', '10'),
('11511', '320000', '320400', '320411', '1', '1', '罗溪镇', '0', '', '1', '0', '0', '10'),
('11512', '320000', '320400', '320411', '1', '1', '西夏墅镇', '0', '', '1', '0', '0', '10'),
('11513', '320000', '320400', '320412', '1', '1', '湖塘镇', '0', '', '1', '0', '0', '10'),
('11514', '320000', '320400', '320412', '1', '1', '牛塘镇', '0', '', '1', '0', '0', '10'),
('11515', '320000', '320400', '320412', '1', '1', '洛阳镇', '0', '', '1', '0', '0', '10'),
('11516', '320000', '320400', '320412', '1', '1', '遥观镇', '0', '', '1', '0', '0', '10'),
('11517', '320000', '320400', '320412', '1', '1', '横林镇', '0', '', '1', '0', '0', '10'),
('11518', '320000', '320400', '320412', '1', '1', '横山桥镇', '0', '', '1', '0', '0', '10'),
('11519', '320000', '320400', '320412', '1', '1', '芙蓉镇', '0', '', '1', '0', '0', '10'),
('11520', '320000', '320400', '320412', '1', '1', '焦溪镇', '0', '', '1', '0', '0', '10'),
('11521', '320000', '320400', '320412', '1', '1', '郑陆镇', '0', '', '1', '0', '0', '10'),
('11522', '320000', '320400', '320412', '1', '1', '雪堰镇', '0', '', '1', '0', '0', '10'),
('11523', '320000', '320400', '320412', '1', '1', '潘家镇', '0', '', '1', '0', '0', '10'),
('11524', '320000', '320400', '320412', '1', '1', '漕桥镇', '0', '', '1', '0', '0', '10'),
('11525', '320000', '320400', '320412', '1', '1', '前黄镇', '0', '', '1', '0', '0', '10'),
('11526', '320000', '320400', '320412', '1', '1', '礼嘉镇', '0', '', '1', '0', '0', '10'),
('11527', '320000', '320400', '320412', '1', '1', '寨桥镇', '0', '', '1', '0', '0', '10'),
('11528', '320000', '320400', '320412', '1', '1', '邹区镇', '0', '', '1', '0', '0', '10'),
('11529', '320000', '320400', '320412', '1', '1', '卜弋镇', '0', '', '1', '0', '0', '10'),
('11530', '320000', '320400', '320412', '1', '1', '夏溪镇', '0', '', '1', '0', '0', '10'),
('11531', '320000', '320400', '320412', '1', '1', '嘉泽镇', '0', '', '1', '0', '0', '10'),
('11532', '320000', '320400', '320412', '1', '1', '湟里镇', '0', '', '1', '0', '0', '10'),
('11533', '320000', '320400', '320412', '1', '1', '东安镇', '0', '', '1', '0', '0', '10'),
('11534', '320000', '320400', '320412', '1', '1', '奔牛镇', '0', '', '1', '0', '0', '10'),
('11535', '320000', '320400', '320412', '1', '1', '武进经济开发区', '0', '', '1', '0', '0', '10'),
('11536', '320000', '320400', '320412', '1', '1', '运村农科良种场', '0', '', '1', '0', '0', '10'),
('11537', '320000', '320400', '320412', '1', '1', '奔牛稻麦原种场', '0', '', '1', '0', '0', '10'),
('11538', '320000', '320400', '320412', '1', '1', '郑陆良种繁育场', '0', '', '1', '0', '0', '10'),
('11539', '320000', '320400', '320412', '1', '1', '夏溪良种繁育场', '0', '', '1', '0', '0', '10'),
('11540', '320000', '320400', '320412', '1', '1', '蚕种场', '0', '', '1', '0', '0', '10'),
('11541', '320000', '320400', '320412', '1', '1', '前黄苗圃', '0', '', '1', '0', '0', '10'),
('11542', '320000', '320400', '320412', '1', '1', '水产养殖场', '0', '', '1', '0', '0', '10'),
('11543', '320000', '320400', '320412', '1', '1', '种兔场', '0', '', '1', '0', '0', '10'),
('11544', '320000', '320400', '320412', '1', '1', '横山苗圃', '0', '', '1', '0', '0', '10'),
('11545', '320000', '320400', '320412', '1', '1', '公路苗圃', '0', '', '1', '0', '0', '10'),
('11546', '320000', '320400', '320412', '1', '1', '高新区', '0', '', '1', '0', '0', '10'),
('11547', '320000', '320400', '320481', '1', '1', '溧城镇', '0', '', '1', '0', '0', '10'),
('11548', '320000', '320400', '320481', '1', '1', '埭头镇', '0', '', '1', '0', '0', '10'),
('11549', '320000', '320400', '320481', '1', '1', '上黄镇', '0', '', '1', '0', '0', '10'),
('11550', '320000', '320400', '320481', '1', '1', '戴埠镇', '0', '', '1', '0', '0', '10'),
('11551', '320000', '320400', '320481', '1', '1', '横涧镇', '0', '', '1', '0', '0', '10'),
('11552', '320000', '320400', '320481', '1', '1', '天目湖镇', '0', '', '1', '0', '0', '10'),
('11553', '320000', '320400', '320481', '1', '1', '别桥镇', '0', '', '1', '0', '0', '10'),
('11554', '320000', '320400', '320481', '1', '1', '绸缪镇', '0', '', '1', '0', '0', '10'),
('11555', '320000', '320400', '320481', '1', '1', '上兴镇', '0', '', '1', '0', '0', '10'),
('11556', '320000', '320400', '320481', '1', '1', '上沛镇', '0', '', '1', '0', '0', '10'),
('11557', '320000', '320400', '320481', '1', '1', '竹箦镇', '0', '', '1', '0', '0', '10'),
('11558', '320000', '320400', '320481', '1', '1', '后周镇', '0', '', '1', '0', '0', '10'),
('11559', '320000', '320400', '320481', '1', '1', '前马镇', '0', '', '1', '0', '0', '10'),
('11560', '320000', '320400', '320481', '1', '1', '南渡镇', '0', '', '1', '0', '0', '10'),
('11561', '320000', '320400', '320481', '1', '1', '新昌镇', '0', '', '1', '0', '0', '10'),
('11562', '320000', '320400', '320481', '1', '1', '社渚镇', '0', '', '1', '0', '0', '10'),
('11563', '320000', '320400', '320481', '1', '1', '周城镇', '0', '', '1', '0', '0', '10'),
('11564', '320000', '320400', '320481', '1', '1', '常州监狱', '0', '', '1', '0', '0', '10'),
('11565', '320000', '320400', '320481', '1', '1', '溧阳监狱', '0', '', '1', '0', '0', '10'),
('11566', '320000', '320400', '320482', '1', '1', '金城镇', '0', '', '1', '0', '0', '10'),
('11567', '320000', '320400', '320482', '1', '1', '白塔镇', '0', '', '1', '0', '0', '10'),
('11568', '320000', '320400', '320482', '1', '1', '河头镇', '0', '', '1', '0', '0', '10'),
('11569', '320000', '320400', '320482', '1', '1', '水北镇', '0', '', '1', '0', '0', '10'),
('11570', '320000', '320400', '320482', '1', '1', '儒林镇', '0', '', '1', '0', '0', '10'),
('11571', '320000', '320400', '320482', '1', '1', '尧塘镇', '0', '', '1', '0', '0', '10'),
('11572', '320000', '320400', '320482', '1', '1', '直溪镇', '0', '', '1', '0', '0', '10'),
('11573', '320000', '320400', '320482', '1', '1', '建昌镇', '0', '', '1', '0', '0', '10'),
('11574', '320000', '320400', '320482', '1', '1', '朱林镇', '0', '', '1', '0', '0', '10'),
('11575', '320000', '320400', '320482', '1', '1', '薛埠镇', '0', '', '1', '0', '0', '10'),
('11576', '320000', '320400', '320482', '1', '1', '茅麓镇', '0', '', '1', '0', '0', '10'),
('11577', '320000', '320400', '320482', '1', '1', '社头镇', '0', '', '1', '0', '0', '10'),
('11578', '320000', '320400', '320482', '1', '1', '指前镇', '0', '', '1', '0', '0', '10'),
('11579', '320000', '320400', '320482', '1', '1', '洮西镇', '0', '', '1', '0', '0', '10'),
('11580', '320000', '320400', '320482', '1', '1', '西岗镇', '0', '', '1', '0', '0', '10'),
('11581', '320000', '320400', '320482', '1', '1', '开发区', '0', '', '1', '0', '0', '10'),
('11582', '320000', '320500', '320502', '1', '1', '双塔街道', '0', '', '1', '0', '0', '10'),
('11583', '320000', '320500', '320502', '1', '1', '南门街道', '0', '', '1', '0', '0', '10'),
('11584', '320000', '320500', '320502', '1', '1', '胥江街道', '0', '', '1', '0', '0', '10'),
('11585', '320000', '320500', '320502', '1', '1', '吴门桥街道', '0', '', '1', '0', '0', '10'),
('11586', '320000', '320500', '320502', '1', '1', '葑门街道', '0', '', '1', '0', '0', '10'),
('11587', '320000', '320500', '320502', '1', '1', '友新街道', '0', '', '1', '0', '0', '10'),
('11588', '320000', '320500', '320503', '1', '1', '观前街道', '0', '', '1', '0', '0', '10'),
('11589', '320000', '320500', '320503', '1', '1', '平江路街道', '0', '', '1', '0', '0', '10'),
('11590', '320000', '320500', '320503', '1', '1', '苏锦街道', '0', '', '1', '0', '0', '10'),
('11591', '320000', '320500', '320503', '1', '1', '娄门街道', '0', '', '1', '0', '0', '10'),
('11592', '320000', '320500', '320503', '1', '1', '城北街道', '0', '', '1', '0', '0', '10'),
('11593', '320000', '320500', '320503', '1', '1', '桃花坞街道', '0', '', '1', '0', '0', '10'),
('11594', '320000', '320500', '320503', '1', '1', '娄葑镇', '0', '', '1', '0', '0', '10'),
('11595', '320000', '320500', '320503', '1', '1', '唯亭镇', '0', '', '1', '0', '0', '10'),
('11596', '320000', '320500', '320503', '1', '1', '胜浦镇', '0', '', '1', '0', '0', '10'),
('11597', '320000', '320500', '320503', '1', '1', '虚拟镇', '0', '', '1', '0', '0', '10'),
('11598', '320000', '320500', '320504', '1', '1', '石路街道', '0', '', '1', '0', '0', '10'),
('11599', '320000', '320500', '320504', '1', '1', '彩香街道', '0', '', '1', '0', '0', '10'),
('11600', '320000', '320500', '320504', '1', '1', '留园街道', '0', '', '1', '0', '0', '10'),
('11601', '320000', '320500', '320504', '1', '1', '虎丘街道', '0', '', '1', '0', '0', '10'),
('11602', '320000', '320500', '320504', '1', '1', '白洋湾街道', '0', '', '1', '0', '0', '10'),
('11603', '320000', '320500', '320505', '1', '1', '横塘街道', '0', '', '1', '0', '0', '10'),
('11604', '320000', '320500', '320505', '1', '1', '狮山街道', '0', '', '1', '0', '0', '10'),
('11605', '320000', '320500', '320505', '1', '1', '枫桥街道', '0', '', '1', '0', '0', '10'),
('11606', '320000', '320500', '320505', '1', '1', '镇湖街道', '0', '', '1', '0', '0', '10'),
('11607', '320000', '320500', '320505', '1', '1', '浒墅关镇', '0', '', '1', '0', '0', '10'),
('11608', '320000', '320500', '320505', '1', '1', '通安镇', '0', '', '1', '0', '0', '10'),
('11609', '320000', '320500', '320505', '1', '1', '东渚镇', '0', '', '1', '0', '0', '10'),
('11610', '320000', '320500', '320505', '1', '1', '高新区浒墅关开发分区', '0', '', '1', '0', '0', '10'),
('11611', '320000', '320500', '320505', '1', '1', '苏州高新区出口加工区', '0', '', '1', '0', '0', '10'),
('11612', '320000', '320500', '320505', '1', '1', '苏州高新技术创业服务中心', '0', '', '1', '0', '0', '10'),
('11613', '320000', '320500', '320505', '1', '1', '苏州高新物流中心', '0', '', '1', '0', '0', '10'),
('11614', '320000', '320500', '320505', '1', '1', '苏州科技城', '0', '', '1', '0', '0', '10'),
('11615', '320000', '320500', '320506', '1', '1', '长桥街道', '0', '', '1', '0', '0', '10'),
('11616', '320000', '320500', '320506', '1', '1', '越溪街道', '0', '', '1', '0', '0', '10'),
('11617', '320000', '320500', '320506', '1', '1', '郭巷街道', '0', '', '1', '0', '0', '10'),
('11618', '320000', '320500', '320506', '1', '1', '横泾街道', '0', '', '1', '0', '0', '10'),
('11619', '320000', '320500', '320506', '1', '1', '香山街道', '0', '', '1', '0', '0', '10'),
('11620', '320000', '320500', '320506', '1', '1', '苏苑街道', '0', '', '1', '0', '0', '10'),
('11621', '320000', '320500', '320506', '1', '1', '龙西街道', '0', '', '1', '0', '0', '10'),
('11622', '320000', '320500', '320506', '1', '1', '城南街道', '0', '', '1', '0', '0', '10'),
('11623', '320000', '320500', '320506', '1', '1', '甪直镇', '0', '', '1', '0', '0', '10'),
('11624', '320000', '320500', '320506', '1', '1', '车坊镇', '0', '', '1', '0', '0', '10'),
('11625', '320000', '320500', '320506', '1', '1', '藏书镇', '0', '', '1', '0', '0', '10'),
('11626', '320000', '320500', '320506', '1', '1', '木渎镇', '0', '', '1', '0', '0', '10'),
('11627', '320000', '320500', '320506', '1', '1', '胥口镇', '0', '', '1', '0', '0', '10'),
('11628', '320000', '320500', '320506', '1', '1', '浦庄镇', '0', '', '1', '0', '0', '10'),
('11629', '320000', '320500', '320506', '1', '1', '渡村镇', '0', '', '1', '0', '0', '10'),
('11630', '320000', '320500', '320506', '1', '1', '东山镇', '0', '', '1', '0', '0', '10'),
('11631', '320000', '320500', '320506', '1', '1', '光福镇', '0', '', '1', '0', '0', '10'),
('11632', '320000', '320500', '320506', '1', '1', '西山镇', '0', '', '1', '0', '0', '10'),
('11633', '320000', '320500', '320506', '1', '1', '江苏省太湖采石公司', '0', '', '1', '0', '0', '10'),
('11634', '320000', '320500', '320506', '1', '1', '吴中区林场', '0', '', '1', '0', '0', '10'),
('11635', '320000', '320500', '320506', '1', '1', '西山农业园区', '0', '', '1', '0', '0', '10'),
('11636', '320000', '320500', '320507', '1', '1', '元和街道', '0', '', '1', '0', '0', '10'),
('11637', '320000', '320500', '320507', '1', '1', '太平街道', '0', '', '1', '0', '0', '10'),
('11638', '320000', '320500', '320507', '1', '1', '黄桥街道', '0', '', '1', '0', '0', '10'),
('11639', '320000', '320500', '320507', '1', '1', '望亭镇', '0', '', '1', '0', '0', '10'),
('11640', '320000', '320500', '320507', '1', '1', '黄埭镇', '0', '', '1', '0', '0', '10'),
('11641', '320000', '320500', '320507', '1', '1', '渭塘镇', '0', '', '1', '0', '0', '10'),
('11642', '320000', '320500', '320507', '1', '1', '北桥镇', '0', '', '1', '0', '0', '10'),
('11643', '320000', '320500', '320507', '1', '1', '阳澄湖镇', '0', '', '1', '0', '0', '10'),
('11644', '320000', '320500', '320507', '1', '1', '开发区', '0', '', '1', '0', '0', '10'),
('11645', '320000', '320500', '320581', '1', '1', '虞山镇', '0', '', '1', '0', '0', '10'),
('11646', '320000', '320500', '320581', '1', '1', '梅李镇', '0', '', '1', '0', '0', '10'),
('11647', '320000', '320500', '320581', '1', '1', '海虞镇', '0', '', '1', '0', '0', '10'),
('11648', '320000', '320500', '320581', '1', '1', '新港镇', '0', '', '1', '0', '0', '10'),
('11649', '320000', '320500', '320581', '1', '1', '古里镇', '0', '', '1', '0', '0', '10'),
('11650', '320000', '320500', '320581', '1', '1', '沙家浜镇', '0', '', '1', '0', '0', '10'),
('11651', '320000', '320500', '320581', '1', '1', '支塘镇', '0', '', '1', '0', '0', '10'),
('11652', '320000', '320500', '320581', '1', '1', '董浜镇', '0', '', '1', '0', '0', '10'),
('11653', '320000', '320500', '320581', '1', '1', '辛庄镇', '0', '', '1', '0', '0', '10'),
('11654', '320000', '320500', '320581', '1', '1', '尚湖镇', '0', '', '1', '0', '0', '10'),
('11655', '320000', '320500', '320581', '1', '1', '虞山林场', '0', '', '1', '0', '0', '10'),
('11656', '320000', '320500', '320581', '1', '1', '常熟经济开发区', '0', '', '1', '0', '0', '10'),
('11657', '320000', '320500', '320581', '1', '1', '常熟东南开发区', '0', '', '1', '0', '0', '10'),
('11658', '320000', '320500', '320582', '1', '1', '杨舍镇', '0', '', '1', '0', '0', '10'),
('11659', '320000', '320500', '320582', '1', '1', '塘桥镇', '0', '', '1', '0', '0', '10'),
('11660', '320000', '320500', '320582', '1', '1', '金港镇', '0', '', '1', '0', '0', '10'),
('11661', '320000', '320500', '320582', '1', '1', '锦丰镇', '0', '', '1', '0', '0', '10'),
('11662', '320000', '320500', '320582', '1', '1', '乐余镇', '0', '', '1', '0', '0', '10'),
('11663', '320000', '320500', '320582', '1', '1', '凤凰镇', '0', '', '1', '0', '0', '10'),
('11664', '320000', '320500', '320582', '1', '1', '南丰镇', '0', '', '1', '0', '0', '10'),
('11665', '320000', '320500', '320582', '1', '1', '大新镇', '0', '', '1', '0', '0', '10'),
('11666', '320000', '320500', '320582', '1', '1', '常阴沙管理区', '0', '', '1', '0', '0', '10'),
('11667', '320000', '320500', '320582', '1', '1', '江苏省张家港经济技术开发区', '0', '', '1', '0', '0', '10'),
('11668', '320000', '320500', '320582', '1', '1', '张家港市沿江开发办', '0', '', '1', '0', '0', '10'),
('11669', '320000', '320500', '320582', '1', '1', '张家港保税区', '0', '', '1', '0', '0', '10'),
('11670', '320000', '320500', '320582', '1', '1', '张家港市稻麦良种场', '0', '', '1', '0', '0', '10'),
('11671', '320000', '320500', '320582', '1', '1', '张家港市畜禽良种场', '0', '', '1', '0', '0', '10'),
('11672', '320000', '320500', '320583', '1', '1', '玉山镇', '0', '', '1', '0', '0', '10'),
('11673', '320000', '320500', '320583', '1', '1', '巴城镇', '0', '', '1', '0', '0', '10'),
('11674', '320000', '320500', '320583', '1', '1', '周市镇', '0', '', '1', '0', '0', '10'),
('11675', '320000', '320500', '320583', '1', '1', '陆家镇', '0', '', '1', '0', '0', '10'),
('11676', '320000', '320500', '320583', '1', '1', '花桥镇', '0', '', '1', '0', '0', '10'),
('11677', '320000', '320500', '320583', '1', '1', '淀山湖镇', '0', '', '1', '0', '0', '10'),
('11678', '320000', '320500', '320583', '1', '1', '张浦镇', '0', '', '1', '0', '0', '10'),
('11679', '320000', '320500', '320583', '1', '1', '周庄镇', '0', '', '1', '0', '0', '10'),
('11680', '320000', '320500', '320583', '1', '1', '千灯镇', '0', '', '1', '0', '0', '10'),
('11681', '320000', '320500', '320583', '1', '1', '锦溪镇', '0', '', '1', '0', '0', '10'),
('11682', '320000', '320500', '320583', '1', '1', '开发区', '0', '', '1', '0', '0', '10'),
('11683', '320000', '320500', '320584', '1', '1', '松陵镇', '0', '', '1', '0', '0', '10'),
('11684', '320000', '320500', '320584', '1', '1', '同里镇', '0', '', '1', '0', '0', '10'),
('11685', '320000', '320500', '320584', '1', '1', '平望镇', '0', '', '1', '0', '0', '10'),
('11686', '320000', '320500', '320584', '1', '1', '盛泽镇', '0', '', '1', '0', '0', '10'),
('11687', '320000', '320500', '320584', '1', '1', '横扇镇', '0', '', '1', '0', '0', '10'),
('11688', '320000', '320500', '320584', '1', '1', '七都镇', '0', '', '1', '0', '0', '10'),
('11689', '320000', '320500', '320584', '1', '1', '震泽镇', '0', '', '1', '0', '0', '10'),
('11690', '320000', '320500', '320584', '1', '1', '桃源镇', '0', '', '1', '0', '0', '10'),
('11691', '320000', '320500', '320584', '1', '1', '汾湖镇', '0', '', '1', '0', '0', '10'),
('11692', '320000', '320500', '320584', '1', '1', '经济开发区', '0', '', '1', '0', '0', '10'),
('11693', '320000', '320500', '320584', '1', '1', '东方丝绸市场', '0', '', '1', '0', '0', '10'),
('11694', '320000', '320500', '320585', '1', '1', '城厢镇', '0', '', '1', '0', '0', '10'),
('11695', '320000', '320500', '320585', '1', '1', '沙溪镇', '0', '', '1', '0', '0', '10'),
('11696', '320000', '320500', '320585', '1', '1', '浏河镇', '0', '', '1', '0', '0', '10'),
('11697', '320000', '320500', '320585', '1', '1', '浮桥镇', '0', '', '1', '0', '0', '10'),
('11698', '320000', '320500', '320585', '1', '1', '璜泾镇', '0', '', '1', '0', '0', '10'),
('11699', '320000', '320500', '320585', '1', '1', '双凤镇', '0', '', '1', '0', '0', '10'),
('11700', '320000', '320500', '320585', '1', '1', '陆渡镇', '0', '', '1', '0', '0', '10'),
('11701', '320000', '320500', '320585', '1', '1', '经济开发区', '0', '', '1', '0', '0', '10'),
('11702', '320000', '320500', '320585', '1', '1', '港区', '0', '', '1', '0', '0', '10'),
('11703', '320000', '320600', '320602', '1', '1', '城东街道', '0', '', '1', '0', '0', '10'),
('11704', '320000', '320600', '320602', '1', '1', '和平桥街道', '0', '', '1', '0', '0', '10'),
('11705', '320000', '320600', '320602', '1', '1', '任港街道', '0', '', '1', '0', '0', '10'),
('11706', '320000', '320600', '320602', '1', '1', '新城桥街道', '0', '', '1', '0', '0', '10'),
('11707', '320000', '320600', '320602', '1', '1', '虹桥街道', '0', '', '1', '0', '0', '10'),
('11708', '320000', '320600', '320602', '1', '1', '学田街道', '0', '', '1', '0', '0', '10'),
('11709', '320000', '320600', '320602', '1', '1', '钟秀街道', '0', '', '1', '0', '0', '10'),
('11710', '320000', '320600', '320602', '1', '1', '文峰街道', '0', '', '1', '0', '0', '10'),
('11711', '320000', '320600', '320602', '1', '1', '中兴街道', '0', '', '1', '0', '0', '10'),
('11712', '320000', '320600', '320602', '1', '1', '观音山镇', '0', '', '1', '0', '0', '10'),
('11713', '320000', '320600', '320602', '1', '1', '狼山镇', '0', '', '1', '0', '0', '10'),
('11714', '320000', '320600', '320602', '1', '1', '新开镇', '0', '', '1', '0', '0', '10'),
('11715', '320000', '320600', '320602', '1', '1', '竹行镇', '0', '', '1', '0', '0', '10'),
('11716', '320000', '320600', '320602', '1', '1', '小海镇', '0', '', '1', '0', '0', '10'),
('11717', '320000', '320600', '320602', '1', '1', '江苏省国营南通农场', '0', '', '1', '0', '0', '10'),
('11718', '320000', '320600', '320602', '1', '1', '南通市富民港良种场', '0', '', '1', '0', '0', '10'),
('11719', '320000', '320600', '320602', '1', '1', '南通市富民港种畜场', '0', '', '1', '0', '0', '10'),
('11720', '320000', '320600', '320611', '1', '1', '永兴街道', '0', '', '1', '0', '0', '10'),
('11721', '320000', '320600', '320611', '1', '1', '唐闸镇街道', '0', '', '1', '0', '0', '10'),
('11722', '320000', '320600', '320611', '1', '1', '天生港镇街道', '0', '', '1', '0', '0', '10'),
('11723', '320000', '320600', '320611', '1', '1', '秦灶街道', '0', '', '1', '0', '0', '10'),
('11724', '320000', '320600', '320611', '1', '1', '陈桥乡', '0', '', '1', '0', '0', '10'),
('11725', '320000', '320600', '320611', '1', '1', '幸福乡', '0', '', '1', '0', '0', '10'),
('11726', '320000', '320600', '320611', '1', '1', '港闸开发区', '0', '', '1', '0', '0', '10'),
('11727', '320000', '320600', '320621', '1', '1', '海安镇', '0', '', '1', '0', '0', '10'),
('11728', '320000', '320600', '320621', '1', '1', '城东镇', '0', '', '1', '0', '0', '10'),
('11729', '320000', '320600', '320621', '1', '1', '曲塘镇', '0', '', '1', '0', '0', '10'),
('11730', '320000', '320600', '320621', '1', '1', '李堡镇', '0', '', '1', '0', '0', '10'),
('11731', '320000', '320600', '320621', '1', '1', '老坝港镇', '0', '', '1', '0', '0', '10'),
('11732', '320000', '320600', '320621', '1', '1', '角斜镇', '0', '', '1', '0', '0', '10'),
('11733', '320000', '320600', '320621', '1', '1', '西场镇', '0', '', '1', '0', '0', '10'),
('11734', '320000', '320600', '320621', '1', '1', '大公镇', '0', '', '1', '0', '0', '10'),
('11735', '320000', '320600', '320621', '1', '1', '孙庄镇', '0', '', '1', '0', '0', '10'),
('11736', '320000', '320600', '320621', '1', '1', '雅周镇', '0', '', '1', '0', '0', '10'),
('11737', '320000', '320600', '320621', '1', '1', '胡集镇', '0', '', '1', '0', '0', '10'),
('11738', '320000', '320600', '320621', '1', '1', '白甸镇', '0', '', '1', '0', '0', '10'),
('11739', '320000', '320600', '320621', '1', '1', '南莫镇', '0', '', '1', '0', '0', '10'),
('11740', '320000', '320600', '320621', '1', '1', '墩头镇', '0', '', '1', '0', '0', '10'),
('11741', '320000', '320600', '320621', '1', '1', '海安县农场', '0', '', '1', '0', '0', '10'),
('11742', '320000', '320600', '320623', '1', '1', '栟茶镇', '0', '', '1', '0', '0', '10'),
('11743', '320000', '320600', '320623', '1', '1', '洋口镇', '0', '', '1', '0', '0', '10'),
('11744', '320000', '320600', '320623', '1', '1', '苴镇', '0', '', '1', '0', '0', '10'),
('11745', '320000', '320600', '320623', '1', '1', '长沙镇', '0', '', '1', '0', '0', '10'),
('11746', '320000', '320600', '320623', '1', '1', '大豫镇', '0', '', '1', '0', '0', '10'),
('11747', '320000', '320600', '320623', '1', '1', '掘港镇', '0', '', '1', '0', '0', '10'),
('11748', '320000', '320600', '320623', '1', '1', '兵房镇', '0', '', '1', '0', '0', '10'),
('11749', '320000', '320600', '320623', '1', '1', '马塘镇', '0', '', '1', '0', '0', '10'),
('11750', '320000', '320600', '320623', '1', '1', '丰利镇', '0', '', '1', '0', '0', '10'),
('11751', '320000', '320600', '320623', '1', '1', '曹埠镇', '0', '', '1', '0', '0', '10'),
('11752', '320000', '320600', '320623', '1', '1', '岔河镇', '0', '', '1', '0', '0', '10'),
('11753', '320000', '320600', '320623', '1', '1', '双甸镇', '0', '', '1', '0', '0', '10'),
('11754', '320000', '320600', '320623', '1', '1', '新店镇', '0', '', '1', '0', '0', '10'),
('11755', '320000', '320600', '320623', '1', '1', '河口镇', '0', '', '1', '0', '0', '10'),
('11756', '320000', '320600', '320623', '1', '1', '袁庄镇', '0', '', '1', '0', '0', '10'),
('11757', '320000', '320600', '320681', '1', '1', '汇龙镇', '0', '', '1', '0', '0', '10'),
('11758', '320000', '320600', '320681', '1', '1', '大兴镇', '0', '', '1', '0', '0', '10'),
('11759', '320000', '320600', '320681', '1', '1', '南阳镇', '0', '', '1', '0', '0', '10'),
('11760', '320000', '320600', '320681', '1', '1', '惠丰镇', '0', '', '1', '0', '0', '10'),
('11761', '320000', '320600', '320681', '1', '1', '民主镇', '0', '', '1', '0', '0', '10'),
('11762', '320000', '320600', '320681', '1', '1', '北新镇', '0', '', '1', '0', '0', '10'),
('11763', '320000', '320600', '320681', '1', '1', '久隆镇', '0', '', '1', '0', '0', '10'),
('11764', '320000', '320600', '320681', '1', '1', '王鲍镇', '0', '', '1', '0', '0', '10'),
('11765', '320000', '320600', '320681', '1', '1', '合作镇', '0', '', '1', '0', '0', '10'),
('11766', '320000', '320600', '320681', '1', '1', '志良镇', '0', '', '1', '0', '0', '10'),
('11767', '320000', '320600', '320681', '1', '1', '吕四港镇', '0', '', '1', '0', '0', '10'),
('11768', '320000', '320600', '320681', '1', '1', '天汾镇', '0', '', '1', '0', '0', '10'),
('11769', '320000', '320600', '320681', '1', '1', '兆民镇', '0', '', '1', '0', '0', '10'),
('11770', '320000', '320600', '320681', '1', '1', '海复镇', '0', '', '1', '0', '0', '10'),
('11771', '320000', '320600', '320681', '1', '1', '少直镇', '0', '', '1', '0', '0', '10'),
('11772', '320000', '320600', '320681', '1', '1', '向阳镇', '0', '', '1', '0', '0', '10'),
('11773', '320000', '320600', '320681', '1', '1', '东元镇', '0', '', '1', '0', '0', '10'),
('11774', '320000', '320600', '320681', '1', '1', '近海镇', '0', '', '1', '0', '0', '10'),
('11775', '320000', '320600', '320681', '1', '1', '寅阳镇', '0', '', '1', '0', '0', '10'),
('11776', '320000', '320600', '320681', '1', '1', '和合镇', '0', '', '1', '0', '0', '10'),
('11777', '320000', '320600', '320681', '1', '1', '惠萍镇', '0', '', '1', '0', '0', '10'),
('11778', '320000', '320600', '320681', '1', '1', '新安镇', '0', '', '1', '0', '0', '10'),
('11779', '320000', '320600', '320681', '1', '1', '东海镇', '0', '', '1', '0', '0', '10'),
('11780', '320000', '320600', '320681', '1', '1', '启隆乡', '0', '', '1', '0', '0', '10'),
('11781', '320000', '320600', '320681', '1', '1', '启东经济开发区', '0', '', '1', '0', '0', '10'),
('11782', '320000', '320600', '320682', '1', '1', '\"如城镇', '0', '', '1', '0', '0', '10'),
('11783', '320000', '320600', '320682', '1', '1', '\"柴湾镇', '0', '', '1', '0', '0', '10'),
('11784', '320000', '320600', '320682', '1', '1', '\"雪岸镇', '0', '', '1', '0', '0', '10'),
('11785', '320000', '320600', '320682', '1', '1', '\"东陈镇', '0', '', '1', '0', '0', '10'),
('11786', '320000', '320600', '320682', '1', '1', '\"丁堰镇', '0', '', '1', '0', '0', '10'),
('11787', '320000', '320600', '320682', '1', '1', '\"白蒲镇', '0', '', '1', '0', '0', '10'),
('11788', '320000', '320600', '320682', '1', '1', '\"林梓镇', '0', '', '1', '0', '0', '10'),
('11789', '320000', '320600', '320682', '1', '1', '\"下原镇', '0', '', '1', '0', '0', '10'),
('11790', '320000', '320600', '320682', '1', '1', '\"九华镇', '0', '', '1', '0', '0', '10'),
('11791', '320000', '320600', '320682', '1', '1', '\"郭园镇', '0', '', '1', '0', '0', '10'),
('11792', '320000', '320600', '320682', '1', '1', '\"石庄镇', '0', '', '1', '0', '0', '10'),
('11793', '320000', '320600', '320682', '1', '1', '\"长江镇', '0', '', '1', '0', '0', '10'),
('11794', '320000', '320600', '320682', '1', '1', '\"吴窑镇', '0', '', '1', '0', '0', '10'),
('11795', '320000', '320600', '320682', '1', '1', '\"江安镇', '0', '', '1', '0', '0', '10'),
('11796', '320000', '320600', '320682', '1', '1', '\"高明镇', '0', '', '1', '0', '0', '10'),
('11797', '320000', '320600', '320682', '1', '1', '\"常青镇', '0', '', '1', '0', '0', '10'),
('11798', '320000', '320600', '320682', '1', '1', '\"搬经镇', '0', '', '1', '0', '0', '10'),
('11799', '320000', '320600', '320682', '1', '1', '\"磨头镇', '0', '', '1', '0', '0', '10'),
('11800', '320000', '320600', '320682', '1', '1', '\"桃园镇', '0', '', '1', '0', '0', '10'),
('11801', '320000', '320600', '320682', '1', '1', '\"袁桥镇', '0', '', '1', '0', '0', '10'),
('11802', '320000', '320600', '320682', '1', '1', '如皋市经济开发区', '0', '', '1', '0', '0', '10'),
('11803', '320000', '320600', '320682', '1', '1', '\"如皋港开发区', '0', '', '1', '0', '0', '10'),
('11804', '320000', '320600', '320682', '1', '1', '南通市粮棉原种场', '0', '', '1', '0', '0', '10'),
('11805', '320000', '320600', '320682', '1', '1', '\"如皋市蚕种场', '0', '', '1', '0', '0', '10'),
('11806', '320000', '320600', '320682', '1', '1', '\"如皋市良种场', '0', '', '1', '0', '0', '10'),
('11807', '320000', '320600', '320682', '1', '1', '如皋市棉花原种场', '0', '', '1', '0', '0', '10'),
('11808', '320000', '320600', '320682', '1', '1', '\"如皋市种猪场', '0', '', '1', '0', '0', '10'),
('11809', '320000', '320600', '320682', '1', '1', '\"如皋市农科所', '0', '', '1', '0', '0', '10'),
('11810', '320000', '320600', '320682', '1', '1', '如皋市江滨医院', '0', '', '1', '0', '0', '10'),
('11811', '320000', '320600', '320682', '1', '1', '如皋市中心沙水产养殖场', '0', '', '1', '0', '0', '10'),
('11812', '320000', '320600', '320682', '1', '1', '如皋市九华水产养殖场', '0', '', '1', '0', '0', '10'),
('11813', '320000', '320600', '320683', '1', '1', '金沙镇', '0', '', '1', '0', '0', '10'),
('11814', '320000', '320600', '320683', '1', '1', '西亭镇', '0', '', '1', '0', '0', '10'),
('11815', '320000', '320600', '320683', '1', '1', '二甲镇', '0', '', '1', '0', '0', '10'),
('11816', '320000', '320600', '320683', '1', '1', '东社镇', '0', '', '1', '0', '0', '10'),
('11817', '320000', '320600', '320683', '1', '1', '三余镇', '0', '', '1', '0', '0', '10'),
('11818', '320000', '320600', '320683', '1', '1', '北兴桥镇', '0', '', '1', '0', '0', '10'),
('11819', '320000', '320600', '320683', '1', '1', '海晏镇', '0', '', '1', '0', '0', '10'),
('11820', '320000', '320600', '320683', '1', '1', '十总镇', '0', '', '1', '0', '0', '10'),
('11821', '320000', '320600', '320683', '1', '1', '骑岸镇', '0', '', '1', '0', '0', '10'),
('11822', '320000', '320600', '320683', '1', '1', '五甲镇', '0', '', '1', '0', '0', '10'),
('11823', '320000', '320600', '320683', '1', '1', '石港镇', '0', '', '1', '0', '0', '10'),
('11824', '320000', '320600', '320683', '1', '1', '四安镇', '0', '', '1', '0', '0', '10'),
('11825', '320000', '320600', '320683', '1', '1', '刘桥镇', '0', '', '1', '0', '0', '10'),
('11826', '320000', '320600', '320683', '1', '1', '新联镇', '0', '', '1', '0', '0', '10'),
('11827', '320000', '320600', '320683', '1', '1', '平潮镇', '0', '', '1', '0', '0', '10'),
('11828', '320000', '320600', '320683', '1', '1', '平东镇', '0', '', '1', '0', '0', '10'),
('11829', '320000', '320600', '320683', '1', '1', '五接镇', '0', '', '1', '0', '0', '10'),
('11830', '320000', '320600', '320683', '1', '1', '兴仁镇', '0', '', '1', '0', '0', '10'),
('11831', '320000', '320600', '320683', '1', '1', '兴东镇', '0', '', '1', '0', '0', '10'),
('11832', '320000', '320600', '320683', '1', '1', '张芝山镇', '0', '', '1', '0', '0', '10'),
('11833', '320000', '320600', '320683', '1', '1', '川港镇', '0', '', '1', '0', '0', '10'),
('11834', '320000', '320600', '320683', '1', '1', '先锋镇', '0', '', '1', '0', '0', '10'),
('11835', '320000', '320600', '320683', '1', '1', '姜灶镇', '0', '', '1', '0', '0', '10'),
('11836', '320000', '320600', '320683', '1', '1', '通州市开发区', '0', '', '1', '0', '0', '10'),
('11837', '320000', '320600', '320683', '1', '1', '环本农场', '0', '', '1', '0', '0', '10'),
('11838', '320000', '320600', '320683', '1', '1', '通州港区管委会', '0', '', '1', '0', '0', '10'),
('11839', '320000', '320600', '320684', '1', '1', '海门镇', '0', '', '1', '0', '0', '10'),
('11840', '320000', '320600', '320684', '1', '1', '三星镇', '0', '', '1', '0', '0', '10'),
('11841', '320000', '320600', '320684', '1', '1', '天补镇', '0', '', '1', '0', '0', '10'),
('11842', '320000', '320600', '320684', '1', '1', '三和镇', '0', '', '1', '0', '0', '10'),
('11843', '320000', '320600', '320684', '1', '1', '德胜镇', '0', '', '1', '0', '0', '10'),
('11844', '320000', '320600', '320684', '1', '1', '三厂镇', '0', '', '1', '0', '0', '10'),
('11845', '320000', '320600', '320684', '1', '1', '常乐镇', '0', '', '1', '0', '0', '10'),
('11846', '320000', '320600', '320684', '1', '1', '麒麟镇', '0', '', '1', '0', '0', '10'),
('11847', '320000', '320600', '320684', '1', '1', '悦来镇', '0', '', '1', '0', '0', '10'),
('11848', '320000', '320600', '320684', '1', '1', '万年镇', '0', '', '1', '0', '0', '10'),
('11849', '320000', '320600', '320684', '1', '1', '三阳镇', '0', '', '1', '0', '0', '10'),
('11850', '320000', '320600', '320684', '1', '1', '四甲镇', '0', '', '1', '0', '0', '10'),
('11851', '320000', '320600', '320684', '1', '1', '货隆镇', '0', '', '1', '0', '0', '10'),
('11852', '320000', '320600', '320684', '1', '1', '余东镇', '0', '', '1', '0', '0', '10'),
('11853', '320000', '320600', '320684', '1', '1', '正余镇', '0', '', '1', '0', '0', '10'),
('11854', '320000', '320600', '320684', '1', '1', '包场镇', '0', '', '1', '0', '0', '10'),
('11855', '320000', '320600', '320684', '1', '1', '刘浩镇', '0', '', '1', '0', '0', '10'),
('11856', '320000', '320600', '320684', '1', '1', '东灶港镇', '0', '', '1', '0', '0', '10'),
('11857', '320000', '320600', '320684', '1', '1', '临江镇', '0', '', '1', '0', '0', '10'),
('11858', '320000', '320600', '320684', '1', '1', '王浩镇', '0', '', '1', '0', '0', '10'),
('11859', '320000', '320600', '320684', '1', '1', '树勋镇', '0', '', '1', '0', '0', '10'),
('11860', '320000', '320600', '320684', '1', '1', '海永乡', '0', '', '1', '0', '0', '10'),
('11861', '320000', '320600', '320684', '1', '1', '海门市经济技术开发区', '0', '', '1', '0', '0', '10'),
('11862', '320000', '320600', '320684', '1', '1', '海门市永隆沙农场', '0', '', '1', '0', '0', '10'),
('11863', '320000', '320600', '320684', '1', '1', '海门市大东农场', '0', '', '1', '0', '0', '10'),
('11864', '320000', '320600', '320684', '1', '1', '海门市畜禽良种场', '0', '', '1', '0', '0', '10'),
('11865', '320000', '320600', '320684', '1', '1', '海门市种羊场', '0', '', '1', '0', '0', '10'),
('11866', '320000', '320600', '320684', '1', '1', '海门市包场渔场', '0', '', '1', '0', '0', '10'),
('11867', '320000', '320600', '320684', '1', '1', '海门市长江芦荡养殖场', '0', '', '1', '0', '0', '10'),
('11868', '320000', '320600', '320684', '1', '1', '海门市沿江渔场', '0', '', '1', '0', '0', '10'),
('11869', '320000', '320600', '320684', '1', '1', '海门市三厂苗圃', '0', '', '1', '0', '0', '10'),
('11870', '320000', '320600', '320684', '1', '1', '海门市农科所', '0', '', '1', '0', '0', '10'),
('11871', '320000', '320600', '320684', '1', '1', '海门市海门盐场', '0', '', '1', '0', '0', '10'),
('11872', '320000', '320600', '320684', '1', '1', '海门市财政局芦荡管理所', '0', '', '1', '0', '0', '10'),
('11873', '320000', '320600', '320684', '1', '1', '江苏省国营江心沙农场', '0', '', '1', '0', '0', '10'),
('11874', '320000', '320700', '320703', '1', '1', '墟沟街道', '0', '', '1', '0', '0', '10'),
('11875', '320000', '320700', '320703', '1', '1', '连云街道', '0', '', '1', '0', '0', '10'),
('11876', '320000', '320700', '320703', '1', '1', '云山街道', '0', '', '1', '0', '0', '10'),
('11877', '320000', '320700', '320703', '1', '1', '板桥街道', '0', '', '1', '0', '0', '10'),
('11878', '320000', '320700', '320703', '1', '1', '连岛街道', '0', '', '1', '0', '0', '10'),
('11879', '320000', '320700', '320703', '1', '1', '中云街道', '0', '', '1', '0', '0', '10'),
('11880', '320000', '320700', '320703', '1', '1', '猴嘴街道', '0', '', '1', '0', '0', '10'),
('11881', '320000', '320700', '320703', '1', '1', '朝阳镇', '0', '', '1', '0', '0', '10'),
('11882', '320000', '320700', '320703', '1', '1', '宿城乡', '0', '', '1', '0', '0', '10'),
('11883', '320000', '320700', '320703', '1', '1', '高公岛乡', '0', '', '1', '0', '0', '10'),
('11884', '320000', '320700', '320703', '1', '1', '前三岛乡', '0', '', '1', '0', '0', '10'),
('11885', '320000', '320700', '320703', '1', '1', '连云港碱厂', '0', '', '1', '0', '0', '10'),
('11886', '320000', '320700', '320705', '1', '1', '浦东街道', '0', '', '1', '0', '0', '10'),
('11887', '320000', '320700', '320705', '1', '1', '浦西街道', '0', '', '1', '0', '0', '10'),
('11888', '320000', '320700', '320705', '1', '1', '新东街道', '0', '', '1', '0', '0', '10'),
('11889', '320000', '320700', '320705', '1', '1', '新南街道', '0', '', '1', '0', '0', '10'),
('11890', '320000', '320700', '320705', '1', '1', '路南街道', '0', '', '1', '0', '0', '10'),
('11891', '320000', '320700', '320705', '1', '1', '新海街道', '0', '', '1', '0', '0', '10'),
('11892', '320000', '320700', '320705', '1', '1', '南城镇', '0', '', '1', '0', '0', '10'),
('11893', '320000', '320700', '320705', '1', '1', '云台乡', '0', '', '1', '0', '0', '10'),
('11894', '320000', '320700', '320705', '1', '1', '花果山乡', '0', '', '1', '0', '0', '10'),
('11895', '320000', '320700', '320705', '1', '1', '宁海乡', '0', '', '1', '0', '0', '10'),
('11896', '320000', '320700', '320705', '1', '1', '云台农场', '0', '', '1', '0', '0', '10'),
('11897', '320000', '320700', '320705', '1', '1', '南云台林场', '0', '', '1', '0', '0', '10'),
('11898', '320000', '320700', '320705', '1', '1', '花果山风景区', '0', '', '1', '0', '0', '10'),
('11899', '320000', '320700', '320706', '1', '1', '海州街道', '0', '', '1', '0', '0', '10'),
('11900', '320000', '320700', '320706', '1', '1', '幸福路街道', '0', '', '1', '0', '0', '10'),
('11901', '320000', '320700', '320706', '1', '1', '朐阳街道', '0', '', '1', '0', '0', '10'),
('11902', '320000', '320700', '320706', '1', '1', '洪门街道', '0', '', '1', '0', '0', '10'),
('11903', '320000', '320700', '320706', '1', '1', '新坝镇', '0', '', '1', '0', '0', '10'),
('11904', '320000', '320700', '320706', '1', '1', '锦屏镇', '0', '', '1', '0', '0', '10'),
('11905', '320000', '320700', '320721', '1', '1', '青口镇', '0', '', '1', '0', '0', '10'),
('11906', '320000', '320700', '320721', '1', '1', '柘汪镇', '0', '', '1', '0', '0', '10'),
('11907', '320000', '320700', '320721', '1', '1', '石桥镇', '0', '', '1', '0', '0', '10'),
('11908', '320000', '320700', '320721', '1', '1', '金山镇', '0', '', '1', '0', '0', '10'),
('11909', '320000', '320700', '320721', '1', '1', '黑林镇', '0', '', '1', '0', '0', '10'),
('11910', '320000', '320700', '320721', '1', '1', '厉庄镇', '0', '', '1', '0', '0', '10'),
('11911', '320000', '320700', '320721', '1', '1', '海头镇', '0', '', '1', '0', '0', '10'),
('11912', '320000', '320700', '320721', '1', '1', '塔山镇', '0', '', '1', '0', '0', '10'),
('11913', '320000', '320700', '320721', '1', '1', '赣马镇', '0', '', '1', '0', '0', '10'),
('11914', '320000', '320700', '320721', '1', '1', '班庄镇', '0', '', '1', '0', '0', '10'),
('11915', '320000', '320700', '320721', '1', '1', '城头镇', '0', '', '1', '0', '0', '10'),
('11916', '320000', '320700', '320721', '1', '1', '门河镇', '0', '', '1', '0', '0', '10'),
('11917', '320000', '320700', '320721', '1', '1', '城西镇', '0', '', '1', '0', '0', '10'),
('11918', '320000', '320700', '320721', '1', '1', '欢墩镇', '0', '', '1', '0', '0', '10'),
('11919', '320000', '320700', '320721', '1', '1', '宋庄镇', '0', '', '1', '0', '0', '10'),
('11920', '320000', '320700', '320721', '1', '1', '沙河镇', '0', '', '1', '0', '0', '10'),
('11921', '320000', '320700', '320721', '1', '1', '墩尚镇', '0', '', '1', '0', '0', '10'),
('11922', '320000', '320700', '320721', '1', '1', '罗阳镇', '0', '', '1', '0', '0', '10'),
('11923', '320000', '320700', '320721', '1', '1', '沙河子园艺场', '0', '', '1', '0', '0', '10'),
('11924', '320000', '320700', '320721', '1', '1', '青口盐场', '0', '', '1', '0', '0', '10'),
('11925', '320000', '320700', '320721', '1', '1', '江苏省赣榆海洋经济开发区', '0', '', '1', '0', '0', '10'),
('11926', '320000', '320700', '320721', '1', '1', '江苏省赣榆经济开发区', '0', '', '1', '0', '0', '10'),
('11927', '320000', '320700', '320722', '1', '1', '牛山镇', '0', '', '1', '0', '0', '10'),
('11928', '320000', '320700', '320722', '1', '1', '白塔埠镇', '0', '', '1', '0', '0', '10'),
('11929', '320000', '320700', '320722', '1', '1', '浦南镇', '0', '', '1', '0', '0', '10'),
('11930', '320000', '320700', '320722', '1', '1', '黄川镇', '0', '', '1', '0', '0', '10'),
('11931', '320000', '320700', '320722', '1', '1', '石梁河镇', '0', '', '1', '0', '0', '10'),
('11932', '320000', '320700', '320722', '1', '1', '青湖镇', '0', '', '1', '0', '0', '10'),
('11933', '320000', '320700', '320722', '1', '1', '石榴镇', '0', '', '1', '0', '0', '10'),
('11934', '320000', '320700', '320722', '1', '1', '温泉镇', '0', '', '1', '0', '0', '10'),
('11935', '320000', '320700', '320722', '1', '1', '双店镇', '0', '', '1', '0', '0', '10'),
('11936', '320000', '320700', '320722', '1', '1', '桃林镇', '0', '', '1', '0', '0', '10'),
('11937', '320000', '320700', '320722', '1', '1', '洪庄镇', '0', '', '1', '0', '0', '10'),
('11938', '320000', '320700', '320722', '1', '1', '安峰镇', '0', '', '1', '0', '0', '10'),
('11939', '320000', '320700', '320722', '1', '1', '房山镇', '0', '', '1', '0', '0', '10'),
('11940', '320000', '320700', '320722', '1', '1', '平明镇', '0', '', '1', '0', '0', '10'),
('11941', '320000', '320700', '320722', '1', '1', '驼峰乡', '0', '', '1', '0', '0', '10'),
('11942', '320000', '320700', '320722', '1', '1', '南辰乡', '0', '', '1', '0', '0', '10'),
('11943', '320000', '320700', '320722', '1', '1', '横沟乡', '0', '', '1', '0', '0', '10'),
('11944', '320000', '320700', '320722', '1', '1', '李埝乡', '0', '', '1', '0', '0', '10'),
('11945', '320000', '320700', '320722', '1', '1', '山左口乡', '0', '', '1', '0', '0', '10'),
('11946', '320000', '320700', '320722', '1', '1', '石湖乡', '0', '', '1', '0', '0', '10'),
('11947', '320000', '320700', '320722', '1', '1', '曲阳乡', '0', '', '1', '0', '0', '10'),
('11948', '320000', '320700', '320722', '1', '1', '张湾乡', '0', '', '1', '0', '0', '10'),
('11949', '320000', '320700', '320722', '1', '1', '岗埠农场', '0', '', '1', '0', '0', '10'),
('11950', '320000', '320700', '320722', '1', '1', '江苏东海经济开发区', '0', '', '1', '0', '0', '10'),
('11951', '320000', '320700', '320723', '1', '1', '伊山镇', '0', '', '1', '0', '0', '10'),
('11952', '320000', '320700', '320723', '1', '1', '板浦镇', '0', '', '1', '0', '0', '10'),
('11953', '320000', '320700', '320723', '1', '1', '杨集镇', '0', '', '1', '0', '0', '10'),
('11954', '320000', '320700', '320723', '1', '1', '燕尾港镇', '0', '', '1', '0', '0', '10'),
('11955', '320000', '320700', '320723', '1', '1', '同兴镇', '0', '', '1', '0', '0', '10'),
('11956', '320000', '320700', '320723', '1', '1', '四队镇', '0', '', '1', '0', '0', '10'),
('11957', '320000', '320700', '320723', '1', '1', '圩丰镇', '0', '', '1', '0', '0', '10'),
('11958', '320000', '320700', '320723', '1', '1', '龙苴镇', '0', '', '1', '0', '0', '10'),
('11959', '320000', '320700', '320723', '1', '1', '伊芦乡', '0', '', '1', '0', '0', '10');
INSERT INTO `wst_communitys` VALUES ('11960', '320000', '320700', '320723', '1', '1', '鲁河乡', '0', '', '1', '0', '0', '10'),
('11961', '320000', '320700', '320723', '1', '1', '图河乡', '0', '', '1', '0', '0', '10'),
('11962', '320000', '320700', '320723', '1', '1', '沂北乡', '0', '', '1', '0', '0', '10'),
('11963', '320000', '320700', '320723', '1', '1', '下车乡', '0', '', '1', '0', '0', '10'),
('11964', '320000', '320700', '320723', '1', '1', '白蚬乡', '0', '', '1', '0', '0', '10'),
('11965', '320000', '320700', '320723', '1', '1', '东王集乡', '0', '', '1', '0', '0', '10'),
('11966', '320000', '320700', '320723', '1', '1', '侍庄乡', '0', '', '1', '0', '0', '10'),
('11967', '320000', '320700', '320723', '1', '1', '小伊乡', '0', '', '1', '0', '0', '10'),
('11968', '320000', '320700', '320723', '1', '1', '穆圩乡', '0', '', '1', '0', '0', '10'),
('11969', '320000', '320700', '320723', '1', '1', '陡沟乡', '0', '', '1', '0', '0', '10'),
('11970', '320000', '320700', '320723', '1', '1', '南岗乡', '0', '', '1', '0', '0', '10'),
('11971', '320000', '320700', '320723', '1', '1', '东辛农场', '0', '', '1', '0', '0', '10'),
('11972', '320000', '320700', '320723', '1', '1', '五图河农场', '0', '', '1', '0', '0', '10'),
('11973', '320000', '320700', '320723', '1', '1', '灌西盐场', '0', '', '1', '0', '0', '10'),
('11974', '320000', '320700', '320724', '1', '1', '新安镇', '0', '', '1', '0', '0', '10'),
('11975', '320000', '320700', '320724', '1', '1', '堆沟港镇', '0', '', '1', '0', '0', '10'),
('11976', '320000', '320700', '320724', '1', '1', '长茂镇', '0', '', '1', '0', '0', '10'),
('11977', '320000', '320700', '320724', '1', '1', '北陈集镇', '0', '', '1', '0', '0', '10'),
('11978', '320000', '320700', '320724', '1', '1', '张店镇', '0', '', '1', '0', '0', '10'),
('11979', '320000', '320700', '320724', '1', '1', '三口镇', '0', '', '1', '0', '0', '10'),
('11980', '320000', '320700', '320724', '1', '1', '孟兴庄镇', '0', '', '1', '0', '0', '10'),
('11981', '320000', '320700', '320724', '1', '1', '汤沟镇', '0', '', '1', '0', '0', '10'),
('11982', '320000', '320700', '320724', '1', '1', '百禄镇', '0', '', '1', '0', '0', '10'),
('11983', '320000', '320700', '320724', '1', '1', '五队乡', '0', '', '1', '0', '0', '10'),
('11984', '320000', '320700', '320724', '1', '1', '田楼乡', '0', '', '1', '0', '0', '10'),
('11985', '320000', '320700', '320724', '1', '1', '李集乡', '0', '', '1', '0', '0', '10'),
('11986', '320000', '320700', '320724', '1', '1', '新集乡', '0', '', '1', '0', '0', '10'),
('11987', '320000', '320700', '320724', '1', '1', '花园乡', '0', '', '1', '0', '0', '10'),
('11988', '320000', '320800', '320802', '1', '1', '北京路街道', '0', '', '1', '0', '0', '10'),
('11989', '320000', '320800', '320802', '1', '1', '长西街道', '0', '', '1', '0', '0', '10'),
('11990', '320000', '320800', '320802', '1', '1', '淮海街道', '0', '', '1', '0', '0', '10'),
('11991', '320000', '320800', '320802', '1', '1', '长东街道', '0', '', '1', '0', '0', '10'),
('11992', '320000', '320800', '320802', '1', '1', '西安路街道', '0', '', '1', '0', '0', '10'),
('11993', '320000', '320800', '320802', '1', '1', '水渡口街道', '0', '', '1', '0', '0', '10'),
('11994', '320000', '320800', '320802', '1', '1', '东湖街道', '0', '', '1', '0', '0', '10'),
('11995', '320000', '320800', '320802', '1', '1', '新港街道', '0', '', '1', '0', '0', '10'),
('11996', '320000', '320800', '320802', '1', '1', '广州路街道', '0', '', '1', '0', '0', '10'),
('11997', '320000', '320800', '320802', '1', '1', '钵池乡', '0', '', '1', '0', '0', '10'),
('11998', '320000', '320800', '320802', '1', '1', '徐杨乡', '0', '', '1', '0', '0', '10'),
('11999', '320000', '320800', '320802', '1', '1', '京沪路', '0', '', '1', '0', '0', '10'),
('12000', '320000', '320800', '320803', '1', '1', '淮城镇', '0', '', '1', '0', '0', '10'),
('12001', '320000', '320800', '320803', '1', '1', '平桥镇', '0', '', '1', '0', '0', '10'),
('12002', '320000', '320800', '320803', '1', '1', '上河镇', '0', '', '1', '0', '0', '10'),
('12003', '320000', '320800', '320803', '1', '1', '马甸镇', '0', '', '1', '0', '0', '10'),
('12004', '320000', '320800', '320803', '1', '1', '朱桥镇', '0', '', '1', '0', '0', '10'),
('12005', '320000', '320800', '320803', '1', '1', '溪河镇', '0', '', '1', '0', '0', '10'),
('12006', '320000', '320800', '320803', '1', '1', '施河镇', '0', '', '1', '0', '0', '10'),
('12007', '320000', '320800', '320803', '1', '1', '车桥镇', '0', '', '1', '0', '0', '10'),
('12008', '320000', '320800', '320803', '1', '1', '泾口镇', '0', '', '1', '0', '0', '10'),
('12009', '320000', '320800', '320803', '1', '1', '流均镇', '0', '', '1', '0', '0', '10'),
('12010', '320000', '320800', '320803', '1', '1', '博里镇', '0', '', '1', '0', '0', '10'),
('12011', '320000', '320800', '320803', '1', '1', '仇桥镇', '0', '', '1', '0', '0', '10'),
('12012', '320000', '320800', '320803', '1', '1', '复兴镇', '0', '', '1', '0', '0', '10'),
('12013', '320000', '320800', '320803', '1', '1', '苏嘴镇', '0', '', '1', '0', '0', '10'),
('12014', '320000', '320800', '320803', '1', '1', '钦工镇', '0', '', '1', '0', '0', '10'),
('12015', '320000', '320800', '320803', '1', '1', '顺河镇', '0', '', '1', '0', '0', '10'),
('12016', '320000', '320800', '320803', '1', '1', '季桥镇', '0', '', '1', '0', '0', '10'),
('12017', '320000', '320800', '320803', '1', '1', '席桥镇', '0', '', '1', '0', '0', '10'),
('12018', '320000', '320800', '320803', '1', '1', '林集镇', '0', '', '1', '0', '0', '10'),
('12019', '320000', '320800', '320803', '1', '1', '南闸镇', '0', '', '1', '0', '0', '10'),
('12020', '320000', '320800', '320803', '1', '1', '范集镇', '0', '', '1', '0', '0', '10'),
('12021', '320000', '320800', '320803', '1', '1', '建淮乡', '0', '', '1', '0', '0', '10'),
('12022', '320000', '320800', '320803', '1', '1', '茭陵乡', '0', '', '1', '0', '0', '10'),
('12023', '320000', '320800', '320803', '1', '1', '宋集乡', '0', '', '1', '0', '0', '10'),
('12024', '320000', '320800', '320803', '1', '1', '城东乡', '0', '', '1', '0', '0', '10'),
('12025', '320000', '320800', '320803', '1', '1', '南马厂乡', '0', '', '1', '0', '0', '10'),
('12026', '320000', '320800', '320803', '1', '1', '三堡乡', '0', '', '1', '0', '0', '10'),
('12027', '320000', '320800', '320803', '1', '1', '白马湖农场', '0', '', '1', '0', '0', '10'),
('12028', '320000', '320800', '320804', '1', '1', '王营镇', '0', '', '1', '0', '0', '10'),
('12029', '320000', '320800', '320804', '1', '1', '赵集镇', '0', '', '1', '0', '0', '10'),
('12030', '320000', '320800', '320804', '1', '1', '吴城镇', '0', '', '1', '0', '0', '10'),
('12031', '320000', '320800', '320804', '1', '1', '南陈集镇', '0', '', '1', '0', '0', '10'),
('12032', '320000', '320800', '320804', '1', '1', '码头镇', '0', '', '1', '0', '0', '10'),
('12033', '320000', '320800', '320804', '1', '1', '王兴镇', '0', '', '1', '0', '0', '10'),
('12034', '320000', '320800', '320804', '1', '1', '棉花庄镇', '0', '', '1', '0', '0', '10'),
('12035', '320000', '320800', '320804', '1', '1', '丁集镇', '0', '', '1', '0', '0', '10'),
('12036', '320000', '320800', '320804', '1', '1', '五里镇', '0', '', '1', '0', '0', '10'),
('12037', '320000', '320800', '320804', '1', '1', '徐溜镇', '0', '', '1', '0', '0', '10'),
('12038', '320000', '320800', '320804', '1', '1', '渔沟镇', '0', '', '1', '0', '0', '10'),
('12039', '320000', '320800', '320804', '1', '1', '吴集镇', '0', '', '1', '0', '0', '10'),
('12040', '320000', '320800', '320804', '1', '1', '西宋集镇', '0', '', '1', '0', '0', '10'),
('12041', '320000', '320800', '320804', '1', '1', '三树镇', '0', '', '1', '0', '0', '10'),
('12042', '320000', '320800', '320804', '1', '1', '韩桥乡', '0', '', '1', '0', '0', '10'),
('12043', '320000', '320800', '320804', '1', '1', '新渡乡', '0', '', '1', '0', '0', '10'),
('12044', '320000', '320800', '320804', '1', '1', '老张集乡', '0', '', '1', '0', '0', '10'),
('12045', '320000', '320800', '320804', '1', '1', '凌桥乡', '0', '', '1', '0', '0', '10'),
('12046', '320000', '320800', '320804', '1', '1', '袁集乡', '0', '', '1', '0', '0', '10'),
('12047', '320000', '320800', '320804', '1', '1', '刘老庄乡', '0', '', '1', '0', '0', '10'),
('12048', '320000', '320800', '320804', '1', '1', '古寨乡', '0', '', '1', '0', '0', '10'),
('12049', '320000', '320800', '320804', '1', '1', '工业园管理委员会', '0', '', '1', '0', '0', '10'),
('12050', '320000', '320800', '320811', '1', '1', '清江街道', '0', '', '1', '0', '0', '10'),
('12051', '320000', '320800', '320811', '1', '1', '浦楼街道', '0', '', '1', '0', '0', '10'),
('12052', '320000', '320800', '320811', '1', '1', '闸口街道', '0', '', '1', '0', '0', '10'),
('12053', '320000', '320800', '320811', '1', '1', '清安街道', '0', '', '1', '0', '0', '10'),
('12054', '320000', '320800', '320811', '1', '1', '和平镇', '0', '', '1', '0', '0', '10'),
('12055', '320000', '320800', '320811', '1', '1', '武墩镇', '0', '', '1', '0', '0', '10'),
('12056', '320000', '320800', '320811', '1', '1', '盐河镇', '0', '', '1', '0', '0', '10'),
('12057', '320000', '320800', '320811', '1', '1', '城南乡', '0', '', '1', '0', '0', '10'),
('12058', '320000', '320800', '320811', '1', '1', '黄码乡', '0', '', '1', '0', '0', '10'),
('12059', '320000', '320800', '320826', '1', '1', '涟城镇', '0', '', '1', '0', '0', '10'),
('12060', '320000', '320800', '320826', '1', '1', '高沟镇', '0', '', '1', '0', '0', '10'),
('12061', '320000', '320800', '320826', '1', '1', '唐集镇', '0', '', '1', '0', '0', '10'),
('12062', '320000', '320800', '320826', '1', '1', '保滩镇', '0', '', '1', '0', '0', '10'),
('12063', '320000', '320800', '320826', '1', '1', '大东镇', '0', '', '1', '0', '0', '10'),
('12064', '320000', '320800', '320826', '1', '1', '五港镇', '0', '', '1', '0', '0', '10'),
('12065', '320000', '320800', '320826', '1', '1', '梁岔镇', '0', '', '1', '0', '0', '10'),
('12066', '320000', '320800', '320826', '1', '1', '石湖镇', '0', '', '1', '0', '0', '10'),
('12067', '320000', '320800', '320826', '1', '1', '朱码镇', '0', '', '1', '0', '0', '10'),
('12068', '320000', '320800', '320826', '1', '1', '岔庙镇', '0', '', '1', '0', '0', '10'),
('12069', '320000', '320800', '320826', '1', '1', '东胡集镇', '0', '', '1', '0', '0', '10'),
('12070', '320000', '320800', '320826', '1', '1', '南集镇', '0', '', '1', '0', '0', '10'),
('12071', '320000', '320800', '320826', '1', '1', '义兴镇', '0', '', '1', '0', '0', '10'),
('12072', '320000', '320800', '320826', '1', '1', '成集镇', '0', '', '1', '0', '0', '10'),
('12073', '320000', '320800', '320826', '1', '1', '红窑镇', '0', '', '1', '0', '0', '10'),
('12074', '320000', '320800', '320826', '1', '1', '陈师镇', '0', '', '1', '0', '0', '10'),
('12075', '320000', '320800', '320826', '1', '1', '前进镇', '0', '', '1', '0', '0', '10'),
('12076', '320000', '320800', '320826', '1', '1', '徐集乡', '0', '', '1', '0', '0', '10'),
('12077', '320000', '320800', '320826', '1', '1', '黄营乡', '0', '', '1', '0', '0', '10'),
('12078', '320000', '320800', '320826', '1', '1', '杨口', '0', '', '1', '0', '0', '10'),
('12079', '320000', '320800', '320826', '1', '1', '方渡', '0', '', '1', '0', '0', '10'),
('12080', '320000', '320800', '320826', '1', '1', '南禄', '0', '', '1', '0', '0', '10'),
('12081', '320000', '320800', '320826', '1', '1', '小李集', '0', '', '1', '0', '0', '10'),
('12082', '320000', '320800', '320826', '1', '1', '河网', '0', '', '1', '0', '0', '10'),
('12083', '320000', '320800', '320826', '1', '1', '时码', '0', '', '1', '0', '0', '10'),
('12084', '320000', '320800', '320826', '1', '1', '北集', '0', '', '1', '0', '0', '10'),
('12085', '320000', '320800', '320826', '1', '1', '灰墩', '0', '', '1', '0', '0', '10'),
('12086', '320000', '320800', '320826', '1', '1', '余圩', '0', '', '1', '0', '0', '10'),
('12087', '320000', '320800', '320826', '1', '1', '浅集', '0', '', '1', '0', '0', '10'),
('12088', '320000', '320800', '320826', '1', '1', '蒋庵', '0', '', '1', '0', '0', '10'),
('12089', '320000', '320800', '320826', '1', '1', '经济开发新区', '0', '', '1', '0', '0', '10'),
('12090', '320000', '320800', '320826', '1', '1', '经济开发区', '0', '', '1', '0', '0', '10'),
('12091', '320000', '320800', '320829', '1', '1', '高良涧镇', '0', '', '1', '0', '0', '10'),
('12092', '320000', '320800', '320829', '1', '1', '蒋坝镇', '0', '', '1', '0', '0', '10'),
('12093', '320000', '320800', '320829', '1', '1', '仁和镇', '0', '', '1', '0', '0', '10'),
('12094', '320000', '320800', '320829', '1', '1', '岔河镇', '0', '', '1', '0', '0', '10'),
('12095', '320000', '320800', '320829', '1', '1', '西顺河镇', '0', '', '1', '0', '0', '10'),
('12096', '320000', '320800', '320829', '1', '1', '老子山镇', '0', '', '1', '0', '0', '10'),
('12097', '320000', '320800', '320829', '1', '1', '三河镇', '0', '', '1', '0', '0', '10'),
('12098', '320000', '320800', '320829', '1', '1', '朱坝镇', '0', '', '1', '0', '0', '10'),
('12099', '320000', '320800', '320829', '1', '1', '黄集镇', '0', '', '1', '0', '0', '10'),
('12100', '320000', '320800', '320829', '1', '1', '万集镇', '0', '', '1', '0', '0', '10'),
('12101', '320000', '320800', '320829', '1', '1', '东双沟镇', '0', '', '1', '0', '0', '10'),
('12102', '320000', '320800', '320829', '1', '1', '共和镇', '0', '', '1', '0', '0', '10'),
('12103', '320000', '320800', '320830', '1', '1', '盱城镇', '0', '', '1', '0', '0', '10'),
('12104', '320000', '320800', '320830', '1', '1', '马坝镇', '0', '', '1', '0', '0', '10'),
('12105', '320000', '320800', '320830', '1', '1', '官滩镇', '0', '', '1', '0', '0', '10'),
('12106', '320000', '320800', '320830', '1', '1', '旧铺镇', '0', '', '1', '0', '0', '10'),
('12107', '320000', '320800', '320830', '1', '1', '桂五镇', '0', '', '1', '0', '0', '10'),
('12108', '320000', '320800', '320830', '1', '1', '管镇镇', '0', '', '1', '0', '0', '10'),
('12109', '320000', '320800', '320830', '1', '1', '河桥镇', '0', '', '1', '0', '0', '10'),
('12110', '320000', '320800', '320830', '1', '1', '鲍集镇', '0', '', '1', '0', '0', '10'),
('12111', '320000', '320800', '320830', '1', '1', '黄花塘镇', '0', '', '1', '0', '0', '10'),
('12112', '320000', '320800', '320830', '1', '1', '明祖陵镇', '0', '', '1', '0', '0', '10'),
('12113', '320000', '320800', '320830', '1', '1', '铁佛镇', '0', '', '1', '0', '0', '10'),
('12114', '320000', '320800', '320830', '1', '1', '淮河镇', '0', '', '1', '0', '0', '10'),
('12115', '320000', '320800', '320830', '1', '1', '仇集镇', '0', '', '1', '0', '0', '10'),
('12116', '320000', '320800', '320830', '1', '1', '观音寺镇', '0', '', '1', '0', '0', '10'),
('12117', '320000', '320800', '320830', '1', '1', '维桥乡', '0', '', '1', '0', '0', '10'),
('12118', '320000', '320800', '320830', '1', '1', '穆店乡', '0', '', '1', '0', '0', '10'),
('12119', '320000', '320800', '320830', '1', '1', '王店乡', '0', '', '1', '0', '0', '10'),
('12120', '320000', '320800', '320830', '1', '1', '古桑乡', '0', '', '1', '0', '0', '10'),
('12121', '320000', '320800', '320830', '1', '1', '兴隆乡', '0', '', '1', '0', '0', '10'),
('12122', '320000', '320800', '320830', '1', '1', '三河农场', '0', '', '1', '0', '0', '10'),
('12123', '320000', '320800', '320830', '1', '1', '淮化集团', '0', '', '1', '0', '0', '10'),
('12124', '320000', '320800', '320831', '1', '1', '黎城镇', '0', '', '1', '0', '0', '10'),
('12125', '320000', '320800', '320831', '1', '1', '金南镇', '0', '', '1', '0', '0', '10'),
('12126', '320000', '320800', '320831', '1', '1', '闵桥镇', '0', '', '1', '0', '0', '10'),
('12127', '320000', '320800', '320831', '1', '1', '塔集镇', '0', '', '1', '0', '0', '10'),
('12128', '320000', '320800', '320831', '1', '1', '银集镇', '0', '', '1', '0', '0', '10'),
('12129', '320000', '320800', '320831', '1', '1', '涂沟镇', '0', '', '1', '0', '0', '10'),
('12130', '320000', '320800', '320831', '1', '1', '前锋镇', '0', '', '1', '0', '0', '10'),
('12131', '320000', '320800', '320831', '1', '1', '吕良镇', '0', '', '1', '0', '0', '10'),
('12132', '320000', '320800', '320831', '1', '1', '陈桥镇', '0', '', '1', '0', '0', '10'),
('12133', '320000', '320800', '320831', '1', '1', '金北镇', '0', '', '1', '0', '0', '10'),
('12134', '320000', '320800', '320831', '1', '1', '戴楼镇', '0', '', '1', '0', '0', '10'),
('12135', '320000', '320800', '320831', '1', '1', '宝应湖农场', '0', '', '1', '0', '0', '10'),
('12136', '320000', '320800', '320831', '1', '1', '复兴圩农场', '0', '', '1', '0', '0', '10'),
('12137', '320000', '320800', '320831', '1', '1', '粮棉原种场', '0', '', '1', '0', '0', '10'),
('12138', '320000', '320800', '320831', '1', '1', '江苏金湖经济开发区', '0', '', '1', '0', '0', '10'),
('12139', '320000', '320900', '320902', '1', '1', '五星街道', '0', '', '1', '0', '0', '10'),
('12140', '320000', '320900', '320902', '1', '1', '文峰街道', '0', '', '1', '0', '0', '10'),
('12141', '320000', '320900', '320902', '1', '1', '先锋街道', '0', '', '1', '0', '0', '10'),
('12142', '320000', '320900', '320902', '1', '1', '毓龙街道', '0', '', '1', '0', '0', '10'),
('12143', '320000', '320900', '320902', '1', '1', '张庄街道', '0', '', '1', '0', '0', '10'),
('12144', '320000', '320900', '320902', '1', '1', '黄海街道', '0', '', '1', '0', '0', '10'),
('12145', '320000', '320900', '320902', '1', '1', '新洋街道', '0', '', '1', '0', '0', '10'),
('12146', '320000', '320900', '320902', '1', '1', '大洋街道', '0', '', '1', '0', '0', '10'),
('12147', '320000', '320900', '320902', '1', '1', '南洋镇', '0', '', '1', '0', '0', '10'),
('12148', '320000', '320900', '320902', '1', '1', '亭湖区青墩镇', '0', '', '1', '0', '0', '10'),
('12149', '320000', '320900', '320902', '1', '1', '新兴镇', '0', '', '1', '0', '0', '10'),
('12150', '320000', '320900', '320902', '1', '1', '永丰镇', '0', '', '1', '0', '0', '10'),
('12151', '320000', '320900', '320902', '1', '1', '便仓镇', '0', '', '1', '0', '0', '10'),
('12152', '320000', '320900', '320902', '1', '1', '伍佑镇', '0', '', '1', '0', '0', '10'),
('12153', '320000', '320900', '320902', '1', '1', '步凤镇', '0', '', '1', '0', '0', '10'),
('12154', '320000', '320900', '320902', '1', '1', '开发区', '0', '', '1', '0', '0', '10'),
('12155', '320000', '320900', '320902', '1', '1', '市开发区', '0', '', '1', '0', '0', '10'),
('12156', '320000', '320900', '320903', '1', '1', '大纵湖镇', '0', '', '1', '0', '0', '10'),
('12157', '320000', '320900', '320903', '1', '1', '北龙港镇', '0', '', '1', '0', '0', '10'),
('12158', '320000', '320900', '320903', '1', '1', '楼王镇', '0', '', '1', '0', '0', '10'),
('12159', '320000', '320900', '320903', '1', '1', '学富镇', '0', '', '1', '0', '0', '10'),
('12160', '320000', '320900', '320903', '1', '1', '义丰镇', '0', '', '1', '0', '0', '10'),
('12161', '320000', '320900', '320903', '1', '1', '尚庄镇', '0', '', '1', '0', '0', '10'),
('12162', '320000', '320900', '320903', '1', '1', '葛武镇', '0', '', '1', '0', '0', '10'),
('12163', '320000', '320900', '320903', '1', '1', '北蒋镇', '0', '', '1', '0', '0', '10'),
('12164', '320000', '320900', '320903', '1', '1', '秦南镇', '0', '', '1', '0', '0', '10'),
('12165', '320000', '320900', '320903', '1', '1', '龙冈镇', '0', '', '1', '0', '0', '10'),
('12166', '320000', '320900', '320903', '1', '1', '潘黄镇', '0', '', '1', '0', '0', '10'),
('12167', '320000', '320900', '320903', '1', '1', '郭猛镇', '0', '', '1', '0', '0', '10'),
('12168', '320000', '320900', '320903', '1', '1', '大冈镇', '0', '', '1', '0', '0', '10'),
('12169', '320000', '320900', '320903', '1', '1', '新区街道', '0', '', '1', '0', '0', '10'),
('12170', '320000', '320900', '320921', '1', '1', '响水镇', '0', '', '1', '0', '0', '10'),
('12171', '320000', '320900', '320921', '1', '1', '陈家港镇', '0', '', '1', '0', '0', '10'),
('12172', '320000', '320900', '320921', '1', '1', '小尖镇', '0', '', '1', '0', '0', '10'),
('12173', '320000', '320900', '320921', '1', '1', '黄圩镇', '0', '', '1', '0', '0', '10'),
('12174', '320000', '320900', '320921', '1', '1', '大有镇', '0', '', '1', '0', '0', '10'),
('12175', '320000', '320900', '320921', '1', '1', '双港镇', '0', '', '1', '0', '0', '10'),
('12176', '320000', '320900', '320921', '1', '1', '南河镇', '0', '', '1', '0', '0', '10'),
('12177', '320000', '320900', '320921', '1', '1', '运河镇', '0', '', '1', '0', '0', '10'),
('12178', '320000', '320900', '320921', '1', '1', '张集乡', '0', '', '1', '0', '0', '10'),
('12179', '320000', '320900', '320921', '1', '1', '六套乡', '0', '', '1', '0', '0', '10'),
('12180', '320000', '320900', '320921', '1', '1', '七套乡', '0', '', '1', '0', '0', '10'),
('12181', '320000', '320900', '320921', '1', '1', '老舍乡', '0', '', '1', '0', '0', '10'),
('12182', '320000', '320900', '320921', '1', '1', '县开发区', '0', '', '1', '0', '0', '10'),
('12183', '320000', '320900', '320921', '1', '1', '省属黄海农场', '0', '', '1', '0', '0', '10'),
('12184', '320000', '320900', '320921', '1', '1', '省属灌东盐场', '0', '', '1', '0', '0', '10'),
('12185', '320000', '320900', '320922', '1', '1', '东坎镇', '0', '', '1', '0', '0', '10'),
('12186', '320000', '320900', '320922', '1', '1', '五汛镇', '0', '', '1', '0', '0', '10'),
('12187', '320000', '320900', '320922', '1', '1', '蔡桥镇', '0', '', '1', '0', '0', '10'),
('12188', '320000', '320900', '320922', '1', '1', '正红镇', '0', '', '1', '0', '0', '10'),
('12189', '320000', '320900', '320922', '1', '1', '通榆镇', '0', '', '1', '0', '0', '10'),
('12190', '320000', '320900', '320922', '1', '1', '界牌镇', '0', '', '1', '0', '0', '10'),
('12191', '320000', '320900', '320922', '1', '1', '八巨镇', '0', '', '1', '0', '0', '10'),
('12192', '320000', '320900', '320922', '1', '1', '八滩镇', '0', '', '1', '0', '0', '10'),
('12193', '320000', '320900', '320922', '1', '1', '滨海港镇', '0', '', '1', '0', '0', '10'),
('12194', '320000', '320900', '320922', '1', '1', '滨淮镇', '0', '', '1', '0', '0', '10'),
('12195', '320000', '320900', '320922', '1', '1', '天场乡', '0', '', '1', '0', '0', '10'),
('12196', '320000', '320900', '320922', '1', '1', '大套乡', '0', '', '1', '0', '0', '10'),
('12197', '320000', '320900', '320922', '1', '1', '陈涛乡', '0', '', '1', '0', '0', '10'),
('12198', '320000', '320900', '320922', '1', '1', '振东乡', '0', '', '1', '0', '0', '10'),
('12199', '320000', '320900', '320922', '1', '1', '樊集乡', '0', '', '1', '0', '0', '10'),
('12200', '320000', '320900', '320922', '1', '1', '滨淮农场', '0', '', '1', '0', '0', '10'),
('12201', '320000', '320900', '320922', '1', '1', '新滩盐场', '0', '', '1', '0', '0', '10'),
('12202', '320000', '320900', '320922', '1', '1', '开发区工业园', '0', '', '1', '0', '0', '10'),
('12203', '320000', '320900', '320923', '1', '1', '阜城镇', '0', '', '1', '0', '0', '10'),
('12204', '320000', '320900', '320923', '1', '1', '沟墩镇', '0', '', '1', '0', '0', '10'),
('12205', '320000', '320900', '320923', '1', '1', '吴滩镇', '0', '', '1', '0', '0', '10'),
('12206', '320000', '320900', '320923', '1', '1', '合利镇', '0', '', '1', '0', '0', '10'),
('12207', '320000', '320900', '320923', '1', '1', '陈良镇', '0', '', '1', '0', '0', '10'),
('12208', '320000', '320900', '320923', '1', '1', '施庄镇', '0', '', '1', '0', '0', '10'),
('12209', '320000', '320900', '320923', '1', '1', '三灶镇', '0', '', '1', '0', '0', '10'),
('12210', '320000', '320900', '320923', '1', '1', '郭墅镇', '0', '', '1', '0', '0', '10'),
('12211', '320000', '320900', '320923', '1', '1', '新沟镇', '0', '', '1', '0', '0', '10'),
('12212', '320000', '320900', '320923', '1', '1', '陈集镇', '0', '', '1', '0', '0', '10'),
('12213', '320000', '320900', '320923', '1', '1', '羊寨镇', '0', '', '1', '0', '0', '10'),
('12214', '320000', '320900', '320923', '1', '1', '芦蒲镇', '0', '', '1', '0', '0', '10'),
('12215', '320000', '320900', '320923', '1', '1', '硕集镇', '0', '', '1', '0', '0', '10'),
('12216', '320000', '320900', '320923', '1', '1', '板湖镇', '0', '', '1', '0', '0', '10'),
('12217', '320000', '320900', '320923', '1', '1', '东沟镇', '0', '', '1', '0', '0', '10'),
('12218', '320000', '320900', '320923', '1', '1', '益林镇', '0', '', '1', '0', '0', '10'),
('12219', '320000', '320900', '320923', '1', '1', '公兴镇', '0', '', '1', '0', '0', '10'),
('12220', '320000', '320900', '320923', '1', '1', '杨集镇', '0', '', '1', '0', '0', '10'),
('12221', '320000', '320900', '320923', '1', '1', '古河镇', '0', '', '1', '0', '0', '10'),
('12222', '320000', '320900', '320923', '1', '1', '罗桥镇', '0', '', '1', '0', '0', '10'),
('12223', '320000', '320900', '320923', '1', '1', '开发区', '0', '', '1', '0', '0', '10'),
('12224', '320000', '320900', '320923', '1', '1', '化工园区', '0', '', '1', '0', '0', '10'),
('12225', '320000', '320900', '320924', '1', '1', '合德镇', '0', '', '1', '0', '0', '10'),
('12226', '320000', '320900', '320924', '1', '1', '临海镇', '0', '', '1', '0', '0', '10'),
('12227', '320000', '320900', '320924', '1', '1', '千秋镇', '0', '', '1', '0', '0', '10'),
('12228', '320000', '320900', '320924', '1', '1', '通洋镇', '0', '', '1', '0', '0', '10'),
('12229', '320000', '320900', '320924', '1', '1', '四明镇', '0', '', '1', '0', '0', '10'),
('12230', '320000', '320900', '320924', '1', '1', '阜余镇', '0', '', '1', '0', '0', '10'),
('12231', '320000', '320900', '320924', '1', '1', '海河镇', '0', '', '1', '0', '0', '10'),
('12232', '320000', '320900', '320924', '1', '1', '陈洋镇', '0', '', '1', '0', '0', '10'),
('12233', '320000', '320900', '320924', '1', '1', '海通镇', '0', '', '1', '0', '0', '10'),
('12234', '320000', '320900', '320924', '1', '1', '兴桥镇', '0', '', '1', '0', '0', '10'),
('12235', '320000', '320900', '320924', '1', '1', '新坍镇', '0', '', '1', '0', '0', '10'),
('12236', '320000', '320900', '320924', '1', '1', '长荡镇', '0', '', '1', '0', '0', '10'),
('12237', '320000', '320900', '320924', '1', '1', '盘湾镇', '0', '', '1', '0', '0', '10'),
('12238', '320000', '320900', '320924', '1', '1', '特庸镇', '0', '', '1', '0', '0', '10'),
('12239', '320000', '320900', '320924', '1', '1', '洋马镇', '0', '', '1', '0', '0', '10'),
('12240', '320000', '320900', '320924', '1', '1', '黄尖镇', '0', '', '1', '0', '0', '10'),
('12241', '320000', '320900', '320924', '1', '1', '盐东镇', '0', '', '1', '0', '0', '10'),
('12242', '320000', '320900', '320924', '1', '1', '黄沙港镇', '0', '', '1', '0', '0', '10'),
('12243', '320000', '320900', '320924', '1', '1', '耦耕镇', '0', '', '1', '0', '0', '10'),
('12244', '320000', '320900', '320924', '1', '1', '开发区', '0', '', '1', '0', '0', '10'),
('12245', '320000', '320900', '320924', '1', '1', '淮海农场', '0', '', '1', '0', '0', '10'),
('12246', '320000', '320900', '320924', '1', '1', '临海农场', '0', '', '1', '0', '0', '10'),
('12247', '320000', '320900', '320924', '1', '1', '新洋农场', '0', '', '1', '0', '0', '10'),
('12248', '320000', '320900', '320924', '1', '1', '射阳盐场', '0', '', '1', '0', '0', '10'),
('12249', '320000', '320900', '320924', '1', '1', '农业经济开发区', '0', '', '1', '0', '0', '10'),
('12250', '320000', '320900', '320925', '1', '1', '近湖镇', '0', '', '1', '0', '0', '10'),
('12251', '320000', '320900', '320925', '1', '1', '建阳镇', '0', '', '1', '0', '0', '10'),
('12252', '320000', '320900', '320925', '1', '1', '蒋营镇', '0', '', '1', '0', '0', '10'),
('12253', '320000', '320900', '320925', '1', '1', '恒济镇', '0', '', '1', '0', '0', '10'),
('12254', '320000', '320900', '320925', '1', '1', '颜单镇', '0', '', '1', '0', '0', '10'),
('12255', '320000', '320900', '320925', '1', '1', '沿河镇', '0', '', '1', '0', '0', '10'),
('12256', '320000', '320900', '320925', '1', '1', '芦沟镇', '0', '', '1', '0', '0', '10'),
('12257', '320000', '320900', '320925', '1', '1', '庆丰镇', '0', '', '1', '0', '0', '10'),
('12258', '320000', '320900', '320925', '1', '1', '上冈镇', '0', '', '1', '0', '0', '10'),
('12259', '320000', '320900', '320925', '1', '1', '冈东镇', '0', '', '1', '0', '0', '10'),
('12260', '320000', '320900', '320925', '1', '1', '草堰口镇', '0', '', '1', '0', '0', '10'),
('12261', '320000', '320900', '320925', '1', '1', '冈西镇', '0', '', '1', '0', '0', '10'),
('12262', '320000', '320900', '320925', '1', '1', '钟庄镇', '0', '', '1', '0', '0', '10'),
('12263', '320000', '320900', '320925', '1', '1', '宝塔镇', '0', '', '1', '0', '0', '10'),
('12264', '320000', '320900', '320925', '1', '1', '高作镇', '0', '', '1', '0', '0', '10'),
('12265', '320000', '320900', '320925', '1', '1', '经济开发区', '0', '', '1', '0', '0', '10'),
('12266', '320000', '320900', '320981', '1', '1', '溱东镇', '0', '', '1', '0', '0', '10'),
('12267', '320000', '320900', '320981', '1', '1', '时堰镇', '0', '', '1', '0', '0', '10'),
('12268', '320000', '320900', '320981', '1', '1', '后港镇', '0', '', '1', '0', '0', '10'),
('12269', '320000', '320900', '320981', '1', '1', '台南镇', '0', '', '1', '0', '0', '10'),
('12270', '320000', '320900', '320981', '1', '1', '广山镇', '0', '', '1', '0', '0', '10'),
('12271', '320000', '320900', '320981', '1', '1', '廉贻镇', '0', '', '1', '0', '0', '10'),
('12272', '320000', '320900', '320981', '1', '1', '五烈镇', '0', '', '1', '0', '0', '10'),
('12273', '320000', '320900', '320981', '1', '1', '梁垛镇', '0', '', '1', '0', '0', '10'),
('12274', '320000', '320900', '320981', '1', '1', '安丰镇', '0', '', '1', '0', '0', '10'),
('12275', '320000', '320900', '320981', '1', '1', '南沈灶镇', '0', '', '1', '0', '0', '10'),
('12276', '320000', '320900', '320981', '1', '1', '富安镇', '0', '', '1', '0', '0', '10'),
('12277', '320000', '320900', '320981', '1', '1', '富东镇', '0', '', '1', '0', '0', '10'),
('12278', '320000', '320900', '320981', '1', '1', '唐洋镇', '0', '', '1', '0', '0', '10'),
('12279', '320000', '320900', '320981', '1', '1', '新街镇', '0', '', '1', '0', '0', '10'),
('12280', '320000', '320900', '320981', '1', '1', '许河镇', '0', '', '1', '0', '0', '10'),
('12281', '320000', '320900', '320981', '1', '1', '三仓镇', '0', '', '1', '0', '0', '10'),
('12282', '320000', '320900', '320981', '1', '1', '新曹镇', '0', '', '1', '0', '0', '10'),
('12283', '320000', '320900', '320981', '1', '1', '曹丿镇', '0', '', '1', '0', '0', '10'),
('12284', '320000', '320900', '320981', '1', '1', '头灶镇', '0', '', '1', '0', '0', '10'),
('12285', '320000', '320900', '320981', '1', '1', '四灶镇', '0', '', '1', '0', '0', '10'),
('12286', '320000', '320900', '320981', '1', '1', '海丰镇', '0', '', '1', '0', '0', '10'),
('12287', '320000', '320900', '320981', '1', '1', '弶港镇', '0', '', '1', '0', '0', '10'),
('12288', '320000', '320900', '320981', '1', '1', '东台镇', '0', '', '1', '0', '0', '10'),
('12289', '320000', '320900', '320981', '1', '1', '国营新曹农场', '0', '', '1', '0', '0', '10'),
('12290', '320000', '320900', '320981', '1', '1', '国营弶港农场', '0', '', '1', '0', '0', '10'),
('12291', '320000', '320900', '320981', '1', '1', '蚕种场', '0', '', '1', '0', '0', '10'),
('12292', '320000', '320900', '320981', '1', '1', '林场', '0', '', '1', '0', '0', '10'),
('12293', '320000', '320900', '320981', '1', '1', '黄海原种场', '0', '', '1', '0', '0', '10'),
('12294', '320000', '320900', '320981', '1', '1', '渔舍农场', '0', '', '1', '0', '0', '10'),
('12295', '320000', '320900', '320981', '1', '1', '种畜场', '0', '', '1', '0', '0', '10'),
('12296', '320000', '320900', '320981', '1', '1', '金东台农场', '0', '', '1', '0', '0', '10'),
('12297', '320000', '320900', '320981', '1', '1', '原种场', '0', '', '1', '0', '0', '10'),
('12298', '320000', '320900', '320981', '1', '1', '开发区', '0', '', '1', '0', '0', '10'),
('12299', '320000', '320900', '320982', '1', '1', '大中镇', '0', '', '1', '0', '0', '10'),
('12300', '320000', '320900', '320982', '1', '1', '草堰镇', '0', '', '1', '0', '0', '10'),
('12301', '320000', '320900', '320982', '1', '1', '白驹镇', '0', '', '1', '0', '0', '10'),
('12302', '320000', '320900', '320982', '1', '1', '刘庄镇', '0', '', '1', '0', '0', '10'),
('12303', '320000', '320900', '320982', '1', '1', '西团镇', '0', '', '1', '0', '0', '10'),
('12304', '320000', '320900', '320982', '1', '1', '小海镇', '0', '', '1', '0', '0', '10'),
('12305', '320000', '320900', '320982', '1', '1', '大桥镇', '0', '', '1', '0', '0', '10'),
('12306', '320000', '320900', '320982', '1', '1', '草庙镇', '0', '', '1', '0', '0', '10'),
('12307', '320000', '320900', '320982', '1', '1', '万盈镇', '0', '', '1', '0', '0', '10'),
('12308', '320000', '320900', '320982', '1', '1', '南阳镇', '0', '', '1', '0', '0', '10'),
('12309', '320000', '320900', '320982', '1', '1', '裕华镇', '0', '', '1', '0', '0', '10'),
('12310', '320000', '320900', '320982', '1', '1', '新丰镇', '0', '', '1', '0', '0', '10'),
('12311', '320000', '320900', '320982', '1', '1', '三龙镇', '0', '', '1', '0', '0', '10'),
('12312', '320000', '320900', '320982', '1', '1', '方强镇', '0', '', '1', '0', '0', '10'),
('12313', '320000', '320900', '320982', '1', '1', '大中农场', '0', '', '1', '0', '0', '10'),
('12314', '320000', '320900', '320982', '1', '1', '方强农场', '0', '', '1', '0', '0', '10'),
('12315', '320000', '320900', '320982', '1', '1', '东坝头农场', '0', '', '1', '0', '0', '10'),
('12316', '320000', '321000', '321002', '1', '1', '东关街道', '0', '', '1', '0', '0', '10'),
('12317', '320000', '321000', '321002', '1', '1', '汶河街道', '0', '', '1', '0', '0', '10'),
('12318', '320000', '321000', '321002', '1', '1', '文峰街道', '0', '', '1', '0', '0', '10'),
('12319', '320000', '321000', '321002', '1', '1', '曲江街道', '0', '', '1', '0', '0', '10'),
('12320', '320000', '321000', '321002', '1', '1', '湾头镇', '0', '', '1', '0', '0', '10'),
('12321', '320000', '321000', '321002', '1', '1', '汤汪乡', '0', '', '1', '0', '0', '10'),
('12322', '320000', '321000', '321003', '1', '1', '邗上街道', '0', '', '1', '0', '0', '10'),
('12323', '320000', '321000', '321003', '1', '1', '蒋王街道', '0', '', '1', '0', '0', '10'),
('12324', '320000', '321000', '321003', '1', '1', '汊河街道', '0', '', '1', '0', '0', '10'),
('12325', '320000', '321000', '321003', '1', '1', '公道镇', '0', '', '1', '0', '0', '10'),
('12326', '320000', '321000', '321003', '1', '1', '方巷镇', '0', '', '1', '0', '0', '10'),
('12327', '320000', '321000', '321003', '1', '1', '槐泗镇', '0', '', '1', '0', '0', '10'),
('12328', '320000', '321000', '321003', '1', '1', '瓜洲镇', '0', '', '1', '0', '0', '10'),
('12329', '320000', '321000', '321003', '1', '1', '杭集镇', '0', '', '1', '0', '0', '10'),
('12330', '320000', '321000', '321003', '1', '1', '李典镇', '0', '', '1', '0', '0', '10'),
('12331', '320000', '321000', '321003', '1', '1', '沙头镇', '0', '', '1', '0', '0', '10'),
('12332', '320000', '321000', '321003', '1', '1', '头桥镇', '0', '', '1', '0', '0', '10'),
('12333', '320000', '321000', '321003', '1', '1', '甘泉镇', '0', '', '1', '0', '0', '10'),
('12334', '320000', '321000', '321003', '1', '1', '泰安镇', '0', '', '1', '0', '0', '10'),
('12335', '320000', '321000', '321003', '1', '1', '杨庙镇', '0', '', '1', '0', '0', '10'),
('12336', '320000', '321000', '321003', '1', '1', '邗江工业园', '0', '', '1', '0', '0', '10'),
('12337', '320000', '321000', '321011', '1', '1', '双桥街道', '0', '', '1', '0', '0', '10'),
('12338', '320000', '321000', '321011', '1', '1', '梅岭街道', '0', '', '1', '0', '0', '10'),
('12339', '320000', '321000', '321011', '1', '1', '瘦西湖街道', '0', '', '1', '0', '0', '10'),
('12340', '320000', '321000', '321011', '1', '1', '扬子津街道', '0', '', '1', '0', '0', '10'),
('12341', '320000', '321000', '321011', '1', '1', '文汇街道', '0', '', '1', '0', '0', '10'),
('12342', '320000', '321000', '321011', '1', '1', '新盛街道', '0', '', '1', '0', '0', '10'),
('12343', '320000', '321000', '321011', '1', '1', '西湖镇', '0', '', '1', '0', '0', '10'),
('12344', '320000', '321000', '321011', '1', '1', '施桥镇', '0', '', '1', '0', '0', '10'),
('12345', '320000', '321000', '321011', '1', '1', '八里镇', '0', '', '1', '0', '0', '10'),
('12346', '320000', '321000', '321011', '1', '1', '平山乡', '0', '', '1', '0', '0', '10'),
('12347', '320000', '321000', '321011', '1', '1', '双桥乡', '0', '', '1', '0', '0', '10'),
('12348', '320000', '321000', '321011', '1', '1', '城北乡', '0', '', '1', '0', '0', '10'),
('12349', '320000', '321000', '321011', '1', '1', '平山茶场', '0', '', '1', '0', '0', '10'),
('12350', '320000', '321000', '321011', '1', '1', '维扬经济开发区', '0', '', '1', '0', '0', '10'),
('12351', '320000', '321000', '321023', '1', '1', '安宜镇', '0', '', '1', '0', '0', '10'),
('12352', '320000', '321000', '321023', '1', '1', '范水镇', '0', '', '1', '0', '0', '10'),
('12353', '320000', '321000', '321023', '1', '1', '夏集镇', '0', '', '1', '0', '0', '10'),
('12354', '320000', '321000', '321023', '1', '1', '柳堡镇', '0', '', '1', '0', '0', '10'),
('12355', '320000', '321000', '321023', '1', '1', '射阳湖镇', '0', '', '1', '0', '0', '10'),
('12356', '320000', '321000', '321023', '1', '1', '广洋湖镇', '0', '', '1', '0', '0', '10'),
('12357', '320000', '321000', '321023', '1', '1', '鲁垛镇', '0', '', '1', '0', '0', '10'),
('12358', '320000', '321000', '321023', '1', '1', '小官庄镇', '0', '', '1', '0', '0', '10'),
('12359', '320000', '321000', '321023', '1', '1', '望直港镇', '0', '', '1', '0', '0', '10'),
('12360', '320000', '321000', '321023', '1', '1', '曹甸镇', '0', '', '1', '0', '0', '10'),
('12361', '320000', '321000', '321023', '1', '1', '西安丰镇', '0', '', '1', '0', '0', '10'),
('12362', '320000', '321000', '321023', '1', '1', '山阳镇', '0', '', '1', '0', '0', '10'),
('12363', '320000', '321000', '321023', '1', '1', '黄塍镇', '0', '', '1', '0', '0', '10'),
('12364', '320000', '321000', '321023', '1', '1', '泾河镇', '0', '', '1', '0', '0', '10'),
('12365', '320000', '321000', '321023', '1', '1', '开发区管委会', '0', '', '1', '0', '0', '10'),
('12366', '320000', '321000', '321081', '1', '1', '真州镇', '0', '', '1', '0', '0', '10'),
('12367', '320000', '321000', '321081', '1', '1', '青山镇', '0', '', '1', '0', '0', '10'),
('12368', '320000', '321000', '321081', '1', '1', '朴席镇', '0', '', '1', '0', '0', '10'),
('12369', '320000', '321000', '321081', '1', '1', '新集镇', '0', '', '1', '0', '0', '10'),
('12370', '320000', '321000', '321081', '1', '1', '新城镇', '0', '', '1', '0', '0', '10'),
('12371', '320000', '321000', '321081', '1', '1', '马集镇', '0', '', '1', '0', '0', '10'),
('12372', '320000', '321000', '321081', '1', '1', '刘集镇', '0', '', '1', '0', '0', '10'),
('12373', '320000', '321000', '321081', '1', '1', '陈集镇', '0', '', '1', '0', '0', '10'),
('12374', '320000', '321000', '321081', '1', '1', '大仪镇', '0', '', '1', '0', '0', '10');
INSERT INTO `wst_communitys` VALUES ('12375', '320000', '321000', '321081', '1', '1', '谢集乡', '0', '', '1', '0', '0', '10'),
('12376', '320000', '321000', '321081', '1', '1', '月塘乡', '0', '', '1', '0', '0', '10'),
('12377', '320000', '321000', '321081', '1', '1', '开发区', '0', '', '1', '0', '0', '10'),
('12378', '320000', '321000', '321081', '1', '1', '原种场', '0', '', '1', '0', '0', '10'),
('12379', '320000', '321000', '321081', '1', '1', '蚕种场', '0', '', '1', '0', '0', '10'),
('12380', '320000', '321000', '321081', '1', '1', '园艺试验场', '0', '', '1', '0', '0', '10'),
('12381', '320000', '321000', '321081', '1', '1', '水产试验场', '0', '', '1', '0', '0', '10'),
('12382', '320000', '321000', '321081', '1', '1', '捺山茶场', '0', '', '1', '0', '0', '10'),
('12383', '320000', '321000', '321081', '1', '1', '蚕桑场', '0', '', '1', '0', '0', '10'),
('12384', '320000', '321000', '321081', '1', '1', '滨江', '0', '', '1', '0', '0', '10'),
('12385', '320000', '321000', '321081', '1', '1', '十二圩', '0', '', '1', '0', '0', '10'),
('12386', '320000', '321000', '321084', '1', '1', '高邮镇', '0', '', '1', '0', '0', '10'),
('12387', '320000', '321000', '321084', '1', '1', '龙虬镇', '0', '', '1', '0', '0', '10'),
('12388', '320000', '321000', '321084', '1', '1', '马棚镇', '0', '', '1', '0', '0', '10'),
('12389', '320000', '321000', '321084', '1', '1', '车逻镇', '0', '', '1', '0', '0', '10'),
('12390', '320000', '321000', '321084', '1', '1', '八桥镇', '0', '', '1', '0', '0', '10'),
('12391', '320000', '321000', '321084', '1', '1', '汉留镇', '0', '', '1', '0', '0', '10'),
('12392', '320000', '321000', '321084', '1', '1', '汤庄镇', '0', '', '1', '0', '0', '10'),
('12393', '320000', '321000', '321084', '1', '1', '卸甲镇', '0', '', '1', '0', '0', '10'),
('12394', '320000', '321000', '321084', '1', '1', '三垛镇', '0', '', '1', '0', '0', '10'),
('12395', '320000', '321000', '321084', '1', '1', '甘垛镇', '0', '', '1', '0', '0', '10'),
('12396', '320000', '321000', '321084', '1', '1', '司徒镇', '0', '', '1', '0', '0', '10'),
('12397', '320000', '321000', '321084', '1', '1', '横泾镇', '0', '', '1', '0', '0', '10'),
('12398', '320000', '321000', '321084', '1', '1', '界首镇', '0', '', '1', '0', '0', '10'),
('12399', '320000', '321000', '321084', '1', '1', '周山镇', '0', '', '1', '0', '0', '10'),
('12400', '320000', '321000', '321084', '1', '1', '周巷镇', '0', '', '1', '0', '0', '10'),
('12401', '320000', '321000', '321084', '1', '1', '临泽镇', '0', '', '1', '0', '0', '10'),
('12402', '320000', '321000', '321084', '1', '1', '送桥镇', '0', '', '1', '0', '0', '10'),
('12403', '320000', '321000', '321084', '1', '1', '郭集镇', '0', '', '1', '0', '0', '10'),
('12404', '320000', '321000', '321084', '1', '1', '天山镇', '0', '', '1', '0', '0', '10'),
('12405', '320000', '321000', '321084', '1', '1', '菱塘回族乡', '0', '', '1', '0', '0', '10'),
('12406', '320000', '321000', '321084', '1', '1', '鸭业园区', '0', '', '1', '0', '0', '10'),
('12407', '320000', '321000', '321084', '1', '1', '经济开发区', '0', '', '1', '0', '0', '10'),
('12408', '320000', '321000', '321088', '1', '1', '仙女镇', '0', '', '1', '0', '0', '10'),
('12409', '320000', '321000', '321088', '1', '1', '小纪镇', '0', '', '1', '0', '0', '10'),
('12410', '320000', '321000', '321088', '1', '1', '武坚镇', '0', '', '1', '0', '0', '10'),
('12411', '320000', '321000', '321088', '1', '1', '樊川镇', '0', '', '1', '0', '0', '10'),
('12412', '320000', '321000', '321088', '1', '1', '真武镇', '0', '', '1', '0', '0', '10'),
('12413', '320000', '321000', '321088', '1', '1', '宜陵镇', '0', '', '1', '0', '0', '10'),
('12414', '320000', '321000', '321088', '1', '1', '丁沟镇', '0', '', '1', '0', '0', '10'),
('12415', '320000', '321000', '321088', '1', '1', '郭村镇', '0', '', '1', '0', '0', '10'),
('12416', '320000', '321000', '321088', '1', '1', '邵伯镇', '0', '', '1', '0', '0', '10'),
('12417', '320000', '321000', '321088', '1', '1', '丁伙镇', '0', '', '1', '0', '0', '10'),
('12418', '320000', '321000', '321088', '1', '1', '大桥镇', '0', '', '1', '0', '0', '10'),
('12419', '320000', '321000', '321088', '1', '1', '吴桥镇', '0', '', '1', '0', '0', '10'),
('12420', '320000', '321000', '321088', '1', '1', '浦头镇', '0', '', '1', '0', '0', '10'),
('12421', '320000', '321100', '321102', '1', '1', '正东路街道', '0', '', '1', '0', '0', '10'),
('12422', '320000', '321100', '321102', '1', '1', '健康路街道', '0', '', '1', '0', '0', '10'),
('12423', '320000', '321100', '321102', '1', '1', '大市口街道', '0', '', '1', '0', '0', '10'),
('12424', '320000', '321100', '321102', '1', '1', '四牌楼街道', '0', '', '1', '0', '0', '10'),
('12425', '320000', '321100', '321102', '1', '1', '丁卯街道', '0', '', '1', '0', '0', '10'),
('12426', '320000', '321100', '321102', '1', '1', '大港街道', '0', '', '1', '0', '0', '10'),
('12427', '320000', '321100', '321102', '1', '1', '象山镇', '0', '', '1', '0', '0', '10'),
('12428', '320000', '321100', '321102', '1', '1', '谏壁镇', '0', '', '1', '0', '0', '10'),
('12429', '320000', '321100', '321102', '1', '1', '姚桥镇', '0', '', '1', '0', '0', '10'),
('12430', '320000', '321100', '321102', '1', '1', '大路镇', '0', '', '1', '0', '0', '10'),
('12431', '320000', '321100', '321102', '1', '1', '丁岗镇', '0', '', '1', '0', '0', '10'),
('12432', '320000', '321100', '321102', '1', '1', '京口科技工业园', '0', '', '1', '0', '0', '10'),
('12433', '320000', '321100', '321102', '1', '1', '江苏省共青团农场', '0', '', '1', '0', '0', '10'),
('12434', '320000', '321100', '321111', '1', '1', '宝塔路街道', '0', '', '1', '0', '0', '10'),
('12435', '320000', '321100', '321111', '1', '1', '和平路街道', '0', '', '1', '0', '0', '10'),
('12436', '320000', '321100', '321111', '1', '1', '金山街道', '0', '', '1', '0', '0', '10'),
('12437', '320000', '321100', '321111', '1', '1', '七里甸街道', '0', '', '1', '0', '0', '10'),
('12438', '320000', '321100', '321111', '1', '1', '蒋乔镇', '0', '', '1', '0', '0', '10'),
('12439', '320000', '321100', '321111', '1', '1', '民营经济管理委员会', '0', '', '1', '0', '0', '10'),
('12440', '320000', '321100', '321111', '1', '1', '润州工业园区', '0', '', '1', '0', '0', '10'),
('12441', '320000', '321100', '321112', '1', '1', '高桥镇', '0', '', '1', '0', '0', '10'),
('12442', '320000', '321100', '321112', '1', '1', '辛丰镇', '0', '', '1', '0', '0', '10'),
('12443', '320000', '321100', '321112', '1', '1', '谷阳镇', '0', '', '1', '0', '0', '10'),
('12444', '320000', '321100', '321112', '1', '1', '上党镇', '0', '', '1', '0', '0', '10'),
('12445', '320000', '321100', '321112', '1', '1', '宝堰镇', '0', '', '1', '0', '0', '10'),
('12446', '320000', '321100', '321112', '1', '1', '高资镇', '0', '', '1', '0', '0', '10'),
('12447', '320000', '321100', '321112', '1', '1', '世业镇', '0', '', '1', '0', '0', '10'),
('12448', '320000', '321100', '321112', '1', '1', '丹徒区长山林场', '0', '', '1', '0', '0', '10'),
('12449', '320000', '321100', '321181', '1', '1', '司徒镇', '0', '', '1', '0', '0', '10'),
('12450', '320000', '321100', '321181', '1', '1', '延陵镇', '0', '', '1', '0', '0', '10'),
('12451', '320000', '321100', '321181', '1', '1', '珥陵镇', '0', '', '1', '0', '0', '10'),
('12452', '320000', '321100', '321181', '1', '1', '导墅镇', '0', '', '1', '0', '0', '10'),
('12453', '320000', '321100', '321181', '1', '1', '皇塘镇', '0', '', '1', '0', '0', '10'),
('12454', '320000', '321100', '321181', '1', '1', '吕城镇', '0', '', '1', '0', '0', '10'),
('12455', '320000', '321100', '321181', '1', '1', '陵口镇', '0', '', '1', '0', '0', '10'),
('12456', '320000', '321100', '321181', '1', '1', '访仙镇', '0', '', '1', '0', '0', '10'),
('12457', '320000', '321100', '321181', '1', '1', '界牌镇', '0', '', '1', '0', '0', '10'),
('12458', '320000', '321100', '321181', '1', '1', '新桥镇', '0', '', '1', '0', '0', '10'),
('12459', '320000', '321100', '321181', '1', '1', '后巷镇', '0', '', '1', '0', '0', '10'),
('12460', '320000', '321100', '321181', '1', '1', '埤城镇', '0', '', '1', '0', '0', '10'),
('12461', '320000', '321100', '321181', '1', '1', '云阳镇', '0', '', '1', '0', '0', '10'),
('12462', '320000', '321100', '321181', '1', '1', '丹阳经济技术开发区', '0', '', '1', '0', '0', '10'),
('12463', '320000', '321100', '321181', '1', '1', '丹阳林场', '0', '', '1', '0', '0', '10'),
('12464', '320000', '321100', '321181', '1', '1', '茶叶实验场', '0', '', '1', '0', '0', '10'),
('12465', '320000', '321100', '321181', '1', '1', '江苏省练湖农场', '0', '', '1', '0', '0', '10'),
('12466', '320000', '321100', '321182', '1', '1', '三茅镇', '0', '', '1', '0', '0', '10'),
('12467', '320000', '321100', '321182', '1', '1', '新坝镇', '0', '', '1', '0', '0', '10'),
('12468', '320000', '321100', '321182', '1', '1', '油坊镇', '0', '', '1', '0', '0', '10'),
('12469', '320000', '321100', '321182', '1', '1', '八桥镇', '0', '', '1', '0', '0', '10'),
('12470', '320000', '321100', '321182', '1', '1', '西来桥镇', '0', '', '1', '0', '0', '10'),
('12471', '320000', '321100', '321182', '1', '1', '经济开发区', '0', '', '1', '0', '0', '10'),
('12472', '320000', '321100', '321182', '1', '1', '扬中市良种繁育场', '0', '', '1', '0', '0', '10'),
('12473', '320000', '321100', '321182', '1', '1', '扬中市种猪场', '0', '', '1', '0', '0', '10'),
('12474', '320000', '321100', '321182', '1', '1', '扬中市渔业社', '0', '', '1', '0', '0', '10'),
('12475', '320000', '321100', '321182', '1', '1', '雷公岛水产养殖场', '0', '', '1', '0', '0', '10'),
('12476', '320000', '321100', '321182', '1', '1', '扬中市西沙芦柳管理所', '0', '', '1', '0', '0', '10'),
('12477', '320000', '321100', '321183', '1', '1', '华阳镇', '0', '', '1', '0', '0', '10'),
('12478', '320000', '321100', '321183', '1', '1', '黄梅镇', '0', '', '1', '0', '0', '10'),
('12479', '320000', '321100', '321183', '1', '1', '下蜀镇', '0', '', '1', '0', '0', '10'),
('12480', '320000', '321100', '321183', '1', '1', '白兔镇', '0', '', '1', '0', '0', '10'),
('12481', '320000', '321100', '321183', '1', '1', '边城镇', '0', '', '1', '0', '0', '10'),
('12482', '320000', '321100', '321183', '1', '1', '茅山镇', '0', '', '1', '0', '0', '10'),
('12483', '320000', '321100', '321183', '1', '1', '后白镇', '0', '', '1', '0', '0', '10'),
('12484', '320000', '321100', '321183', '1', '1', '郭庄镇', '0', '', '1', '0', '0', '10'),
('12485', '320000', '321100', '321183', '1', '1', '天王镇', '0', '', '1', '0', '0', '10'),
('12486', '320000', '321100', '321183', '1', '1', '宝华镇', '0', '', '1', '0', '0', '10'),
('12487', '320000', '321100', '321183', '1', '1', '开发区', '0', '', '1', '0', '0', '10'),
('12488', '320000', '321100', '321183', '1', '1', '句容市东山良种场', '0', '', '1', '0', '0', '10'),
('12489', '320000', '321100', '321183', '1', '1', '句容市棉花原种场', '0', '', '1', '0', '0', '10'),
('12490', '320000', '321100', '321183', '1', '1', '句容市下蜀茶场', '0', '', '1', '0', '0', '10'),
('12491', '320000', '321100', '321183', '1', '1', '句容市林场', '0', '', '1', '0', '0', '10'),
('12492', '320000', '321100', '321183', '1', '1', '句容市赵庄林苗场', '0', '', '1', '0', '0', '10'),
('12493', '320000', '321100', '321183', '1', '1', '句容市九华茶场', '0', '', '1', '0', '0', '10'),
('12494', '320000', '321100', '321183', '1', '1', '句容市东进林场', '0', '', '1', '0', '0', '10'),
('12495', '320000', '321100', '321183', '1', '1', '句容市茅山茶场', '0', '', '1', '0', '0', '10'),
('12496', '320000', '321100', '321183', '1', '1', '句容市张庙茶场', '0', '', '1', '0', '0', '10'),
('12497', '320000', '321100', '321183', '1', '1', '句容市高庙茶场', '0', '', '1', '0', '0', '10'),
('12498', '320000', '321100', '321183', '1', '1', '句容市浮山果园', '0', '', '1', '0', '0', '10'),
('12499', '320000', '321100', '321183', '1', '1', '句容市方山茶场', '0', '', '1', '0', '0', '10'),
('12500', '320000', '321100', '321183', '1', '1', '句容市磨盘山林场', '0', '', '1', '0', '0', '10'),
('12501', '320000', '321100', '321183', '1', '1', '句容市后白良种场', '0', '', '1', '0', '0', '10'),
('12502', '320000', '321100', '321183', '1', '1', '句容市二圣种猪场', '0', '', '1', '0', '0', '10'),
('12503', '320000', '321100', '321183', '1', '1', '句容监狱', '0', '', '1', '0', '0', '10'),
('12504', '320000', '321100', '321183', '1', '1', '江苏省第一少年管教所', '0', '', '1', '0', '0', '10'),
('12505', '320000', '321100', '321183', '1', '1', '江苏省第二少年管教所', '0', '', '1', '0', '0', '10'),
('12506', '320000', '321100', '321183', '1', '1', '句东农场', '0', '', '1', '0', '0', '10'),
('12507', '320000', '321200', '321202', '1', '1', '城东街道', '0', '', '1', '0', '0', '10'),
('12508', '320000', '321200', '321202', '1', '1', '城西街道', '0', '', '1', '0', '0', '10'),
('12509', '320000', '321200', '321202', '1', '1', '城南街道', '0', '', '1', '0', '0', '10'),
('12510', '320000', '321200', '321202', '1', '1', '城中街道', '0', '', '1', '0', '0', '10'),
('12511', '320000', '321200', '321202', '1', '1', '城北街道', '0', '', '1', '0', '0', '10'),
('12512', '320000', '321200', '321202', '1', '1', '泰山街道', '0', '', '1', '0', '0', '10'),
('12513', '320000', '321200', '321202', '1', '1', '京泰路街道', '0', '', '1', '0', '0', '10'),
('12514', '320000', '321200', '321202', '1', '1', '凤凰路街道', '0', '', '1', '0', '0', '10'),
('12515', '320000', '321200', '321202', '1', '1', '农业开发区街道', '0', '', '1', '0', '0', '10'),
('12516', '320000', '321200', '321202', '1', '1', '九龙镇', '0', '', '1', '0', '0', '10'),
('12517', '320000', '321200', '321202', '1', '1', '寺巷镇', '0', '', '1', '0', '0', '10'),
('12518', '320000', '321200', '321202', '1', '1', '林场', '0', '', '1', '0', '0', '10'),
('12519', '320000', '321200', '321202', '1', '1', '水产养殖场', '0', '', '1', '0', '0', '10'),
('12520', '320000', '321200', '321202', '1', '1', '畜牧养殖试验场', '0', '', '1', '0', '0', '10'),
('12521', '320000', '321200', '321202', '1', '1', '迎春果场', '0', '', '1', '0', '0', '10'),
('12522', '320000', '321200', '321202', '1', '1', '海陵工业园区', '0', '', '1', '0', '0', '10'),
('12523', '320000', '321200', '321203', '1', '1', '口岸街道', '0', '', '1', '0', '0', '10'),
('12524', '320000', '321200', '321203', '1', '1', '刁铺街道', '0', '', '1', '0', '0', '10'),
('12525', '320000', '321200', '321203', '1', '1', '许庄街道', '0', '', '1', '0', '0', '10'),
('12526', '320000', '321200', '321203', '1', '1', '永安洲镇', '0', '', '1', '0', '0', '10'),
('12527', '320000', '321200', '321203', '1', '1', '白马镇', '0', '', '1', '0', '0', '10'),
('12528', '320000', '321200', '321203', '1', '1', '野徐镇', '0', '', '1', '0', '0', '10'),
('12529', '320000', '321200', '321203', '1', '1', '滨江工业园', '0', '', '1', '0', '0', '10'),
('12530', '320000', '321200', '321281', '1', '1', '戴窑镇', '0', '', '1', '0', '0', '10'),
('12531', '320000', '321200', '321281', '1', '1', '合陈镇', '0', '', '1', '0', '0', '10'),
('12532', '320000', '321200', '321281', '1', '1', '永丰镇', '0', '', '1', '0', '0', '10'),
('12533', '320000', '321200', '321281', '1', '1', '新垛镇', '0', '', '1', '0', '0', '10'),
('12534', '320000', '321200', '321281', '1', '1', '安丰镇', '0', '', '1', '0', '0', '10'),
('12535', '320000', '321200', '321281', '1', '1', '海南镇', '0', '', '1', '0', '0', '10'),
('12536', '320000', '321200', '321281', '1', '1', '钓鱼镇', '0', '', '1', '0', '0', '10'),
('12537', '320000', '321200', '321281', '1', '1', '大邹镇', '0', '', '1', '0', '0', '10'),
('12538', '320000', '321200', '321281', '1', '1', '沙沟镇', '0', '', '1', '0', '0', '10'),
('12539', '320000', '321200', '321281', '1', '1', '中堡镇', '0', '', '1', '0', '0', '10'),
('12540', '320000', '321200', '321281', '1', '1', '李中镇', '0', '', '1', '0', '0', '10'),
('12541', '320000', '321200', '321281', '1', '1', '西郊镇', '0', '', '1', '0', '0', '10'),
('12542', '320000', '321200', '321281', '1', '1', '临城镇', '0', '', '1', '0', '0', '10'),
('12543', '320000', '321200', '321281', '1', '1', '垛田镇', '0', '', '1', '0', '0', '10'),
('12544', '320000', '321200', '321281', '1', '1', '竹泓镇', '0', '', '1', '0', '0', '10'),
('12545', '320000', '321200', '321281', '1', '1', '沈沦镇', '0', '', '1', '0', '0', '10'),
('12546', '320000', '321200', '321281', '1', '1', '大垛镇', '0', '', '1', '0', '0', '10'),
('12547', '320000', '321200', '321281', '1', '1', '荻垛镇', '0', '', '1', '0', '0', '10'),
('12548', '320000', '321200', '321281', '1', '1', '陶庄镇', '0', '', '1', '0', '0', '10'),
('12549', '320000', '321200', '321281', '1', '1', '昌荣镇', '0', '', '1', '0', '0', '10'),
('12550', '320000', '321200', '321281', '1', '1', '茅山镇', '0', '', '1', '0', '0', '10'),
('12551', '320000', '321200', '321281', '1', '1', '周庄镇', '0', '', '1', '0', '0', '10'),
('12552', '320000', '321200', '321281', '1', '1', '陈堡镇', '0', '', '1', '0', '0', '10'),
('12553', '320000', '321200', '321281', '1', '1', '戴南镇', '0', '', '1', '0', '0', '10'),
('12554', '320000', '321200', '321281', '1', '1', '张郭镇', '0', '', '1', '0', '0', '10'),
('12555', '320000', '321200', '321281', '1', '1', '昭阳镇', '0', '', '1', '0', '0', '10'),
('12556', '320000', '321200', '321281', '1', '1', '大营镇', '0', '', '1', '0', '0', '10'),
('12557', '320000', '321200', '321281', '1', '1', '下圩镇', '0', '', '1', '0', '0', '10'),
('12558', '320000', '321200', '321281', '1', '1', '城东镇', '0', '', '1', '0', '0', '10'),
('12559', '320000', '321200', '321281', '1', '1', '老圩乡', '0', '', '1', '0', '0', '10'),
('12560', '320000', '321200', '321281', '1', '1', '周奋乡', '0', '', '1', '0', '0', '10'),
('12561', '320000', '321200', '321281', '1', '1', '缸顾乡', '0', '', '1', '0', '0', '10'),
('12562', '320000', '321200', '321281', '1', '1', '西鲍乡', '0', '', '1', '0', '0', '10'),
('12563', '320000', '321200', '321281', '1', '1', '林湖乡', '0', '', '1', '0', '0', '10'),
('12564', '320000', '321200', '321281', '1', '1', '开发区', '0', '', '1', '0', '0', '10'),
('12565', '320000', '321200', '321281', '1', '1', '良种场', '0', '', '1', '0', '0', '10'),
('12566', '320000', '321200', '321282', '1', '1', '靖城镇', '0', '', '1', '0', '0', '10'),
('12567', '320000', '321200', '321282', '1', '1', '新桥镇', '0', '', '1', '0', '0', '10'),
('12568', '320000', '321200', '321282', '1', '1', '东兴镇', '0', '', '1', '0', '0', '10'),
('12569', '320000', '321200', '321282', '1', '1', '斜桥镇', '0', '', '1', '0', '0', '10'),
('12570', '320000', '321200', '321282', '1', '1', '西来镇', '0', '', '1', '0', '0', '10'),
('12571', '320000', '321200', '321282', '1', '1', '季市镇', '0', '', '1', '0', '0', '10'),
('12572', '320000', '321200', '321282', '1', '1', '孤山镇', '0', '', '1', '0', '0', '10'),
('12573', '320000', '321200', '321282', '1', '1', '红光镇', '0', '', '1', '0', '0', '10'),
('12574', '320000', '321200', '321282', '1', '1', '生祠镇', '0', '', '1', '0', '0', '10'),
('12575', '320000', '321200', '321282', '1', '1', '马桥镇', '0', '', '1', '0', '0', '10'),
('12576', '320000', '321200', '321282', '1', '1', '城南', '0', '', '1', '0', '0', '10'),
('12577', '320000', '321200', '321282', '1', '1', '新港园区', '0', '', '1', '0', '0', '10'),
('12578', '320000', '321200', '321282', '1', '1', '城北园区', '0', '', '1', '0', '0', '10'),
('12579', '320000', '321200', '321282', '1', '1', '江阴园区', '0', '', '1', '0', '0', '10'),
('12580', '320000', '321200', '321282', '1', '1', '渔业公司', '0', '', '1', '0', '0', '10'),
('12581', '320000', '321200', '321283', '1', '1', '黄桥镇', '0', '', '1', '0', '0', '10'),
('12582', '320000', '321200', '321283', '1', '1', '分界镇', '0', '', '1', '0', '0', '10'),
('12583', '320000', '321200', '321283', '1', '1', '古溪镇', '0', '', '1', '0', '0', '10'),
('12584', '320000', '321200', '321283', '1', '1', '横垛镇', '0', '', '1', '0', '0', '10'),
('12585', '320000', '321200', '321283', '1', '1', '元竹镇', '0', '', '1', '0', '0', '10'),
('12586', '320000', '321200', '321283', '1', '1', '珊瑚镇', '0', '', '1', '0', '0', '10'),
('12587', '320000', '321200', '321283', '1', '1', '广陵镇', '0', '', '1', '0', '0', '10'),
('12588', '320000', '321200', '321283', '1', '1', '南沙镇', '0', '', '1', '0', '0', '10'),
('12589', '320000', '321200', '321283', '1', '1', '曲霞镇', '0', '', '1', '0', '0', '10'),
('12590', '320000', '321200', '321283', '1', '1', '张桥镇', '0', '', '1', '0', '0', '10'),
('12591', '320000', '321200', '321283', '1', '1', '溪桥镇', '0', '', '1', '0', '0', '10'),
('12592', '320000', '321200', '321283', '1', '1', '刘陈镇', '0', '', '1', '0', '0', '10'),
('12593', '320000', '321200', '321283', '1', '1', '河失镇', '0', '', '1', '0', '0', '10'),
('12594', '320000', '321200', '321283', '1', '1', '新街镇', '0', '', '1', '0', '0', '10'),
('12595', '320000', '321200', '321283', '1', '1', '姚王镇', '0', '', '1', '0', '0', '10'),
('12596', '320000', '321200', '321283', '1', '1', '宣堡镇', '0', '', '1', '0', '0', '10'),
('12597', '320000', '321200', '321283', '1', '1', '胡庄镇', '0', '', '1', '0', '0', '10'),
('12598', '320000', '321200', '321283', '1', '1', '马甸镇', '0', '', '1', '0', '0', '10'),
('12599', '320000', '321200', '321283', '1', '1', '泰兴镇', '0', '', '1', '0', '0', '10'),
('12600', '320000', '321200', '321283', '1', '1', '七圩镇', '0', '', '1', '0', '0', '10'),
('12601', '320000', '321200', '321283', '1', '1', '蒋华镇', '0', '', '1', '0', '0', '10'),
('12602', '320000', '321200', '321283', '1', '1', '大生镇', '0', '', '1', '0', '0', '10'),
('12603', '320000', '321200', '321283', '1', '1', '过船镇', '0', '', '1', '0', '0', '10'),
('12604', '320000', '321200', '321283', '1', '1', '根思乡', '0', '', '1', '0', '0', '10'),
('12605', '320000', '321200', '321283', '1', '1', '开发区虚拟镇', '0', '', '1', '0', '0', '10'),
('12606', '320000', '321200', '321283', '1', '1', '泰兴市农科所', '0', '', '1', '0', '0', '10'),
('12607', '320000', '321200', '321284', '1', '1', '姜堰镇', '0', '', '1', '0', '0', '10'),
('12608', '320000', '321200', '321284', '1', '1', '溱潼镇', '0', '', '1', '0', '0', '10'),
('12609', '320000', '321200', '321284', '1', '1', '蒋垛镇', '0', '', '1', '0', '0', '10'),
('12610', '320000', '321200', '321284', '1', '1', '顾高镇', '0', '', '1', '0', '0', '10'),
('12611', '320000', '321200', '321284', '1', '1', '大伦镇', '0', '', '1', '0', '0', '10'),
('12612', '320000', '321200', '321284', '1', '1', '张甸镇', '0', '', '1', '0', '0', '10'),
('12613', '320000', '321200', '321284', '1', '1', '大泗镇', '0', '', '1', '0', '0', '10'),
('12614', '320000', '321200', '321284', '1', '1', '梁徐镇', '0', '', '1', '0', '0', '10'),
('12615', '320000', '321200', '321284', '1', '1', '苏陈镇', '0', '', '1', '0', '0', '10'),
('12616', '320000', '321200', '321284', '1', '1', '桥头镇', '0', '', '1', '0', '0', '10'),
('12617', '320000', '321200', '321284', '1', '1', '淤溪镇', '0', '', '1', '0', '0', '10'),
('12618', '320000', '321200', '321284', '1', '1', '白米镇', '0', '', '1', '0', '0', '10'),
('12619', '320000', '321200', '321284', '1', '1', '娄庄镇', '0', '', '1', '0', '0', '10'),
('12620', '320000', '321200', '321284', '1', '1', '沈高镇', '0', '', '1', '0', '0', '10'),
('12621', '320000', '321200', '321284', '1', '1', '兴泰镇', '0', '', '1', '0', '0', '10'),
('12622', '320000', '321200', '321284', '1', '1', '俞垛镇', '0', '', '1', '0', '0', '10'),
('12623', '320000', '321200', '321284', '1', '1', '华港镇', '0', '', '1', '0', '0', '10'),
('12624', '320000', '321200', '321284', '1', '1', '罡杨镇', '0', '', '1', '0', '0', '10'),
('12625', '320000', '321200', '321284', '1', '1', '开发区', '0', '', '1', '0', '0', '10'),
('12626', '320000', '321200', '321284', '1', '1', '溱湖风景区', '0', '', '1', '0', '0', '10'),
('12627', '320000', '321200', '321284', '1', '1', '林场', '0', '', '1', '0', '0', '10'),
('12628', '320000', '321200', '321284', '1', '1', '种猪场', '0', '', '1', '0', '0', '10'),
('12629', '320000', '321200', '321284', '1', '1', '林业站', '0', '', '1', '0', '0', '10'),
('12630', '320000', '321200', '321284', '1', '1', '渔业社', '0', '', '1', '0', '0', '10'),
('12631', '320000', '321300', '321302', '1', '1', '幸福街道', '0', '', '1', '0', '0', '10'),
('12632', '320000', '321300', '321302', '1', '1', '项里街道', '0', '', '1', '0', '0', '10'),
('12633', '320000', '321300', '321302', '1', '1', '河滨街道', '0', '', '1', '0', '0', '10'),
('12634', '320000', '321300', '321302', '1', '1', '古城街道', '0', '', '1', '0', '0', '10'),
('12635', '320000', '321300', '321302', '1', '1', '双庄镇', '0', '', '1', '0', '0', '10'),
('12636', '320000', '321300', '321302', '1', '1', '耿车镇', '0', '', '1', '0', '0', '10'),
('12637', '320000', '321300', '321302', '1', '1', '埠子镇', '0', '', '1', '0', '0', '10'),
('12638', '320000', '321300', '321302', '1', '1', '龙河镇', '0', '', '1', '0', '0', '10'),
('12639', '320000', '321300', '321302', '1', '1', '洋北镇', '0', '', '1', '0', '0', '10'),
('12640', '320000', '321300', '321302', '1', '1', '仓集镇', '0', '', '1', '0', '0', '10'),
('12641', '320000', '321300', '321302', '1', '1', '洋河镇', '0', '', '1', '0', '0', '10'),
('12642', '320000', '321300', '321302', '1', '1', '中扬镇', '0', '', '1', '0', '0', '10'),
('12643', '320000', '321300', '321302', '1', '1', '郑楼镇', '0', '', '1', '0', '0', '10'),
('12644', '320000', '321300', '321302', '1', '1', '陈集镇', '0', '', '1', '0', '0', '10'),
('12645', '320000', '321300', '321302', '1', '1', '罗圩乡', '0', '', '1', '0', '0', '10'),
('12646', '320000', '321300', '321302', '1', '1', '南蔡乡', '0', '', '1', '0', '0', '10'),
('12647', '320000', '321300', '321302', '1', '1', '屠园乡', '0', '', '1', '0', '0', '10'),
('12648', '320000', '321300', '321302', '1', '1', '三棵树乡', '0', '', '1', '0', '0', '10'),
('12649', '320000', '321300', '321311', '1', '1', '顺河镇', '0', '', '1', '0', '0', '10'),
('12650', '320000', '321300', '321311', '1', '1', '晓店镇', '0', '', '1', '0', '0', '10'),
('12651', '320000', '321300', '321311', '1', '1', '蔡集镇', '0', '', '1', '0', '0', '10'),
('12652', '320000', '321300', '321311', '1', '1', '王官集镇', '0', '', '1', '0', '0', '10'),
('12653', '320000', '321300', '321311', '1', '1', '皂河镇', '0', '', '1', '0', '0', '10'),
('12654', '320000', '321300', '321311', '1', '1', '仰化镇', '0', '', '1', '0', '0', '10'),
('12655', '320000', '321300', '321311', '1', '1', '大兴镇', '0', '', '1', '0', '0', '10'),
('12656', '320000', '321300', '321311', '1', '1', '丁嘴镇', '0', '', '1', '0', '0', '10'),
('12657', '320000', '321300', '321311', '1', '1', '来龙镇', '0', '', '1', '0', '0', '10'),
('12658', '320000', '321300', '321311', '1', '1', '黄墩镇', '0', '', '1', '0', '0', '10'),
('12659', '320000', '321300', '321311', '1', '1', '陆集镇', '0', '', '1', '0', '0', '10'),
('12660', '320000', '321300', '321311', '1', '1', '关庙镇', '0', '', '1', '0', '0', '10'),
('12661', '320000', '321300', '321311', '1', '1', '侍岭镇', '0', '', '1', '0', '0', '10'),
('12662', '320000', '321300', '321311', '1', '1', '新庄镇', '0', '', '1', '0', '0', '10'),
('12663', '320000', '321300', '321311', '1', '1', '井头乡', '0', '', '1', '0', '0', '10'),
('12664', '320000', '321300', '321311', '1', '1', '曹集乡', '0', '', '1', '0', '0', '10'),
('12665', '320000', '321300', '321311', '1', '1', '保安乡', '0', '', '1', '0', '0', '10'),
('12666', '320000', '321300', '321311', '1', '1', '嶂山林场', '0', '', '1', '0', '0', '10'),
('12667', '320000', '321300', '321322', '1', '1', '沭城镇', '0', '', '1', '0', '0', '10'),
('12668', '320000', '321300', '321322', '1', '1', '陇集镇', '0', '', '1', '0', '0', '10'),
('12669', '320000', '321300', '321322', '1', '1', '胡集镇', '0', '', '1', '0', '0', '10'),
('12670', '320000', '321300', '321322', '1', '1', '钱集镇', '0', '', '1', '0', '0', '10'),
('12671', '320000', '321300', '321322', '1', '1', '塘沟镇', '0', '', '1', '0', '0', '10'),
('12672', '320000', '321300', '321322', '1', '1', '马厂镇', '0', '', '1', '0', '0', '10'),
('12673', '320000', '321300', '321322', '1', '1', '沂涛镇', '0', '', '1', '0', '0', '10'),
('12674', '320000', '321300', '321322', '1', '1', '庙头镇', '0', '', '1', '0', '0', '10'),
('12675', '320000', '321300', '321322', '1', '1', '韩山镇', '0', '', '1', '0', '0', '10'),
('12676', '320000', '321300', '321322', '1', '1', '华冲镇', '0', '', '1', '0', '0', '10'),
('12677', '320000', '321300', '321322', '1', '1', '桑墟镇', '0', '', '1', '0', '0', '10'),
('12678', '320000', '321300', '321322', '1', '1', '悦来镇', '0', '', '1', '0', '0', '10'),
('12679', '320000', '321300', '321322', '1', '1', '刘集镇', '0', '', '1', '0', '0', '10'),
('12680', '320000', '321300', '321322', '1', '1', '李恒镇', '0', '', '1', '0', '0', '10'),
('12681', '320000', '321300', '321322', '1', '1', '扎下镇', '0', '', '1', '0', '0', '10'),
('12682', '320000', '321300', '321322', '1', '1', '颜集镇', '0', '', '1', '0', '0', '10'),
('12683', '320000', '321300', '321322', '1', '1', '潼阳镇', '0', '', '1', '0', '0', '10'),
('12684', '320000', '321300', '321322', '1', '1', '龙庙镇', '0', '', '1', '0', '0', '10'),
('12685', '320000', '321300', '321322', '1', '1', '高墟镇', '0', '', '1', '0', '0', '10'),
('12686', '320000', '321300', '321322', '1', '1', '耿圩镇', '0', '', '1', '0', '0', '10'),
('12687', '320000', '321300', '321322', '1', '1', '汤涧镇', '0', '', '1', '0', '0', '10'),
('12688', '320000', '321300', '321322', '1', '1', '新河镇', '0', '', '1', '0', '0', '10'),
('12689', '320000', '321300', '321322', '1', '1', '贤官镇', '0', '', '1', '0', '0', '10'),
('12690', '320000', '321300', '321322', '1', '1', '吴集镇', '0', '', '1', '0', '0', '10'),
('12691', '320000', '321300', '321322', '1', '1', '湖东镇', '0', '', '1', '0', '0', '10'),
('12692', '320000', '321300', '321322', '1', '1', '青伊湖镇', '0', '', '1', '0', '0', '10'),
('12693', '320000', '321300', '321322', '1', '1', '北丁集乡', '0', '', '1', '0', '0', '10'),
('12694', '320000', '321300', '321322', '1', '1', '周集乡', '0', '', '1', '0', '0', '10'),
('12695', '320000', '321300', '321322', '1', '1', '东小店乡', '0', '', '1', '0', '0', '10'),
('12696', '320000', '321300', '321322', '1', '1', '张圩乡', '0', '', '1', '0', '0', '10'),
('12697', '320000', '321300', '321322', '1', '1', '茆圩乡', '0', '', '1', '0', '0', '10'),
('12698', '320000', '321300', '321322', '1', '1', '西圩乡', '0', '', '1', '0', '0', '10'),
('12699', '320000', '321300', '321322', '1', '1', '万匹乡', '0', '', '1', '0', '0', '10'),
('12700', '320000', '321300', '321322', '1', '1', '官墩乡', '0', '', '1', '0', '0', '10'),
('12701', '320000', '321300', '321322', '1', '1', '青伊湖农场', '0', '', '1', '0', '0', '10'),
('12702', '320000', '321300', '321323', '1', '1', '众兴镇', '0', '', '1', '0', '0', '10'),
('12703', '320000', '321300', '321323', '1', '1', '爱园镇', '0', '', '1', '0', '0', '10'),
('12704', '320000', '321300', '321323', '1', '1', '王集镇', '0', '', '1', '0', '0', '10'),
('12705', '320000', '321300', '321323', '1', '1', '裴圩镇', '0', '', '1', '0', '0', '10'),
('12706', '320000', '321300', '321323', '1', '1', '新袁镇', '0', '', '1', '0', '0', '10'),
('12707', '320000', '321300', '321323', '1', '1', '李口镇', '0', '', '1', '0', '0', '10'),
('12708', '320000', '321300', '321323', '1', '1', '临河镇', '0', '', '1', '0', '0', '10'),
('12709', '320000', '321300', '321323', '1', '1', '穿城镇', '0', '', '1', '0', '0', '10'),
('12710', '320000', '321300', '321323', '1', '1', '张家圩镇', '0', '', '1', '0', '0', '10'),
('12711', '320000', '321300', '321323', '1', '1', '高渡镇', '0', '', '1', '0', '0', '10'),
('12712', '320000', '321300', '321323', '1', '1', '卢集镇', '0', '', '1', '0', '0', '10'),
('12713', '320000', '321300', '321323', '1', '1', '庄圩乡', '0', '', '1', '0', '0', '10'),
('12714', '320000', '321300', '321323', '1', '1', '里仁乡', '0', '', '1', '0', '0', '10'),
('12715', '320000', '321300', '321323', '1', '1', '三庄乡', '0', '', '1', '0', '0', '10'),
('12716', '320000', '321300', '321323', '1', '1', '南刘集乡', '0', '', '1', '0', '0', '10'),
('12717', '320000', '321300', '321323', '1', '1', '八集乡', '0', '', '1', '0', '0', '10'),
('12718', '320000', '321300', '321323', '1', '1', '泗阳农场', '0', '', '1', '0', '0', '10'),
('12719', '320000', '321300', '321323', '1', '1', '棉花原种场', '0', '', '1', '0', '0', '10'),
('12720', '320000', '321300', '321324', '1', '1', '青阳镇', '0', '', '1', '0', '0', '10'),
('12721', '320000', '321300', '321324', '1', '1', '双沟镇', '0', '', '1', '0', '0', '10'),
('12722', '320000', '321300', '321324', '1', '1', '上塘镇', '0', '', '1', '0', '0', '10'),
('12723', '320000', '321300', '321324', '1', '1', '魏营镇', '0', '', '1', '0', '0', '10'),
('12724', '320000', '321300', '321324', '1', '1', '临淮镇', '0', '', '1', '0', '0', '10'),
('12725', '320000', '321300', '321324', '1', '1', '半城镇', '0', '', '1', '0', '0', '10'),
('12726', '320000', '321300', '321324', '1', '1', '孙园镇', '0', '', '1', '0', '0', '10'),
('12727', '320000', '321300', '321324', '1', '1', '梅花镇', '0', '', '1', '0', '0', '10'),
('12728', '320000', '321300', '321324', '1', '1', '归仁镇', '0', '', '1', '0', '0', '10'),
('12729', '320000', '321300', '321324', '1', '1', '金锁镇', '0', '', '1', '0', '0', '10'),
('12730', '320000', '321300', '321324', '1', '1', '朱湖镇', '0', '', '1', '0', '0', '10'),
('12731', '320000', '321300', '321324', '1', '1', '界集镇', '0', '', '1', '0', '0', '10'),
('12732', '320000', '321300', '321324', '1', '1', '太平镇', '0', '', '1', '0', '0', '10'),
('12733', '320000', '321300', '321324', '1', '1', '龙集镇', '0', '', '1', '0', '0', '10'),
('12734', '320000', '321300', '321324', '1', '1', '四河乡', '0', '', '1', '0', '0', '10'),
('12735', '320000', '321300', '321324', '1', '1', '峰山乡', '0', '', '1', '0', '0', '10'),
('12736', '320000', '321300', '321324', '1', '1', '天岗湖乡', '0', '', '1', '0', '0', '10'),
('12737', '320000', '321300', '321324', '1', '1', '车门乡', '0', '', '1', '0', '0', '10'),
('12738', '320000', '321300', '321324', '1', '1', '瑶沟乡', '0', '', '1', '0', '0', '10'),
('12739', '320000', '321300', '321324', '1', '1', '石集乡', '0', '', '1', '0', '0', '10'),
('12740', '320000', '321300', '321324', '1', '1', '城头乡', '0', '', '1', '0', '0', '10'),
('12741', '320000', '321300', '321324', '1', '1', '陈圩乡', '0', '', '1', '0', '0', '10'),
('12742', '320000', '321300', '321324', '1', '1', '曹庙乡', '0', '', '1', '0', '0', '10'),
('12743', '320000', '321300', '321324', '1', '1', '五里江农场', '0', '', '1', '0', '0', '10'),
('12744', '320000', '321300', '321324', '1', '1', '洪泽湖农场', '0', '', '1', '0', '0', '10'),
('12745', '330000', '330100', '330102', '1', '1', '清波街道', '0', '', '1', '0', '0', '10'),
('12746', '330000', '330100', '330102', '1', '1', '湖滨街道', '0', '', '1', '0', '0', '10'),
('12747', '330000', '330100', '330102', '1', '1', '小营街道', '0', '', '1', '0', '0', '10'),
('12748', '330000', '330100', '330102', '1', '1', '南星街道', '0', '', '1', '0', '0', '10'),
('12749', '330000', '330100', '330102', '1', '1', '紫阳街道', '0', '', '1', '0', '0', '10'),
('12750', '330000', '330100', '330102', '1', '1', '望江街道', '0', '', '1', '0', '0', '10'),
('12751', '330000', '330100', '330103', '1', '1', '长庆街道', '0', '', '1', '0', '0', '10'),
('12752', '330000', '330100', '330103', '1', '1', '武林街道', '0', '', '1', '0', '0', '10'),
('12753', '330000', '330100', '330103', '1', '1', '天水街道', '0', '', '1', '0', '0', '10'),
('12754', '330000', '330100', '330103', '1', '1', '潮鸣街道', '0', '', '1', '0', '0', '10'),
('12755', '330000', '330100', '330103', '1', '1', '朝晖街道', '0', '', '1', '0', '0', '10'),
('12756', '330000', '330100', '330103', '1', '1', '文晖街道', '0', '', '1', '0', '0', '10'),
('12757', '330000', '330100', '330103', '1', '1', '东新街道', '0', '', '1', '0', '0', '10'),
('12758', '330000', '330100', '330103', '1', '1', '石桥街道', '0', '', '1', '0', '0', '10'),
('12759', '330000', '330100', '330104', '1', '1', '凯旋街道', '0', '', '1', '0', '0', '10'),
('12760', '330000', '330100', '330104', '1', '1', '采荷街道', '0', '', '1', '0', '0', '10'),
('12761', '330000', '330100', '330104', '1', '1', '闸弄口街道', '0', '', '1', '0', '0', '10'),
('12762', '330000', '330100', '330104', '1', '1', '四季青街道', '0', '', '1', '0', '0', '10'),
('12763', '330000', '330100', '330104', '1', '1', '白杨街道', '0', '', '1', '0', '0', '10'),
('12764', '330000', '330100', '330104', '1', '1', '下沙街道', '0', '', '1', '0', '0', '10'),
('12765', '330000', '330100', '330104', '1', '1', '彭埠镇', '0', '', '1', '0', '0', '10'),
('12766', '330000', '330100', '330104', '1', '1', '笕桥镇', '0', '', '1', '0', '0', '10'),
('12767', '330000', '330100', '330104', '1', '1', '丁桥镇', '0', '', '1', '0', '0', '10'),
('12768', '330000', '330100', '330104', '1', '1', '九堡镇', '0', '', '1', '0', '0', '10'),
('12769', '330000', '330100', '330105', '1', '1', '米市巷街道', '0', '', '1', '0', '0', '10'),
('12770', '330000', '330100', '330105', '1', '1', '湖墅街道', '0', '', '1', '0', '0', '10'),
('12771', '330000', '330100', '330105', '1', '1', '小河街道', '0', '', '1', '0', '0', '10'),
('12772', '330000', '330100', '330105', '1', '1', '和睦街道', '0', '', '1', '0', '0', '10'),
('12773', '330000', '330100', '330105', '1', '1', '拱宸桥街道', '0', '', '1', '0', '0', '10'),
('12774', '330000', '330100', '330105', '1', '1', '大关街道', '0', '', '1', '0', '0', '10'),
('12775', '330000', '330100', '330105', '1', '1', '上塘街道', '0', '', '1', '0', '0', '10'),
('12776', '330000', '330100', '330105', '1', '1', '康桥镇', '0', '', '1', '0', '0', '10'),
('12777', '330000', '330100', '330105', '1', '1', '半山镇', '0', '', '1', '0', '0', '10'),
('12778', '330000', '330100', '330105', '1', '1', '祥符镇', '0', '', '1', '0', '0', '10'),
('12779', '330000', '330100', '330106', '1', '1', '北山街道', '0', '', '1', '0', '0', '10'),
('12780', '330000', '330100', '330106', '1', '1', '灵隐街道', '0', '', '1', '0', '0', '10'),
('12781', '330000', '330100', '330106', '1', '1', '西溪街道', '0', '', '1', '0', '0', '10'),
('12782', '330000', '330100', '330106', '1', '1', '翠苑街道', '0', '', '1', '0', '0', '10'),
('12783', '330000', '330100', '330106', '1', '1', '文新街道', '0', '', '1', '0', '0', '10'),
('12784', '330000', '330100', '330106', '1', '1', '古荡街道', '0', '', '1', '0', '0', '10'),
('12785', '330000', '330100', '330106', '1', '1', '西湖街道', '0', '', '1', '0', '0', '10'),
('12786', '330000', '330100', '330106', '1', '1', '留下镇', '0', '', '1', '0', '0', '10'),
('12787', '330000', '330100', '330106', '1', '1', '转塘镇', '0', '', '1', '0', '0', '10'),
('12788', '330000', '330100', '330106', '1', '1', '袁浦镇', '0', '', '1', '0', '0', '10'),
('12789', '330000', '330100', '330106', '1', '1', '龙坞镇', '0', '', '1', '0', '0', '10'),
('12790', '330000', '330100', '330106', '1', '1', '三墩镇', '0', '', '1', '0', '0', '10'),
('12791', '330000', '330100', '330106', '1', '1', '周浦乡', '0', '', '1', '0', '0', '10'),
('12792', '330000', '330100', '330106', '1', '1', '蒋村乡', '0', '', '1', '0', '0', '10'),
('12793', '330000', '330100', '330108', '1', '1', '西兴街道', '0', '', '1', '0', '0', '10'),
('12794', '330000', '330100', '330108', '1', '1', '长河街道', '0', '', '1', '0', '0', '10'),
('12795', '330000', '330100', '330108', '1', '1', '浦沿街道', '0', '', '1', '0', '0', '10'),
('12796', '330000', '330100', '330109', '1', '1', '城厢街道', '0', '', '1', '0', '0', '10'),
('12797', '330000', '330100', '330109', '1', '1', '北干街道', '0', '', '1', '0', '0', '10'),
('12798', '330000', '330100', '330109', '1', '1', '蜀山街道', '0', '', '1', '0', '0', '10'),
('12799', '330000', '330100', '330109', '1', '1', '新塘街道', '0', '', '1', '0', '0', '10'),
('12800', '330000', '330100', '330109', '1', '1', '楼塔镇', '0', '', '1', '0', '0', '10'),
('12801', '330000', '330100', '330109', '1', '1', '河上镇', '0', '', '1', '0', '0', '10'),
('12802', '330000', '330100', '330109', '1', '1', '戴村镇', '0', '', '1', '0', '0', '10'),
('12803', '330000', '330100', '330109', '1', '1', '浦阳镇', '0', '', '1', '0', '0', '10'),
('12804', '330000', '330100', '330109', '1', '1', '进化镇', '0', '', '1', '0', '0', '10'),
('12805', '330000', '330100', '330109', '1', '1', '临浦镇', '0', '', '1', '0', '0', '10'),
('12806', '330000', '330100', '330109', '1', '1', '义桥镇', '0', '', '1', '0', '0', '10'),
('12807', '330000', '330100', '330109', '1', '1', '所前镇', '0', '', '1', '0', '0', '10'),
('12808', '330000', '330100', '330109', '1', '1', '衙前镇', '0', '', '1', '0', '0', '10'),
('12809', '330000', '330100', '330109', '1', '1', '闻堰镇', '0', '', '1', '0', '0', '10'),
('12810', '330000', '330100', '330109', '1', '1', '宁围镇', '0', '', '1', '0', '0', '10'),
('12811', '330000', '330100', '330109', '1', '1', '新街镇', '0', '', '1', '0', '0', '10'),
('12812', '330000', '330100', '330109', '1', '1', '坎山镇', '0', '', '1', '0', '0', '10'),
('12813', '330000', '330100', '330109', '1', '1', '瓜沥镇', '0', '', '1', '0', '0', '10'),
('12814', '330000', '330100', '330109', '1', '1', '党山镇', '0', '', '1', '0', '0', '10'),
('12815', '330000', '330100', '330109', '1', '1', '益农镇', '0', '', '1', '0', '0', '10'),
('12816', '330000', '330100', '330109', '1', '1', '靖江镇', '0', '', '1', '0', '0', '10'),
('12817', '330000', '330100', '330109', '1', '1', '南阳镇', '0', '', '1', '0', '0', '10'),
('12818', '330000', '330100', '330109', '1', '1', '义蓬镇', '0', '', '1', '0', '0', '10'),
('12819', '330000', '330100', '330109', '1', '1', '河庄镇', '0', '', '1', '0', '0', '10'),
('12820', '330000', '330100', '330109', '1', '1', '党湾镇', '0', '', '1', '0', '0', '10'),
('12821', '330000', '330100', '330109', '1', '1', '新湾镇', '0', '', '1', '0', '0', '10'),
('12822', '330000', '330100', '330109', '1', '1', '萧山经济开发区', '0', '', '1', '0', '0', '10'),
('12823', '330000', '330100', '330109', '1', '1', '围垦区', '0', '', '1', '0', '0', '10'),
('12824', '330000', '330100', '330110', '1', '1', '临平街道', '0', '', '1', '0', '0', '10'),
('12825', '330000', '330100', '330110', '1', '1', '南苑街道', '0', '', '1', '0', '0', '10'),
('12826', '330000', '330100', '330110', '1', '1', '东湖街道', '0', '', '1', '0', '0', '10'),
('12827', '330000', '330100', '330110', '1', '1', '星桥街道', '0', '', '1', '0', '0', '10'),
('12828', '330000', '330100', '330110', '1', '1', '乔司镇', '0', '', '1', '0', '0', '10'),
('12829', '330000', '330100', '330110', '1', '1', '运河镇', '0', '', '1', '0', '0', '10'),
('12830', '330000', '330100', '330110', '1', '1', '塘栖镇', '0', '', '1', '0', '0', '10'),
('12831', '330000', '330100', '330110', '1', '1', '崇贤镇', '0', '', '1', '0', '0', '10'),
('12832', '330000', '330100', '330110', '1', '1', '仁和镇', '0', '', '1', '0', '0', '10'),
('12833', '330000', '330100', '330110', '1', '1', '良渚镇', '0', '', '1', '0', '0', '10'),
('12834', '330000', '330100', '330110', '1', '1', '闲林镇', '0', '', '1', '0', '0', '10'),
('12835', '330000', '330100', '330110', '1', '1', '仓前镇', '0', '', '1', '0', '0', '10'),
('12836', '330000', '330100', '330110', '1', '1', '余杭镇', '0', '', '1', '0', '0', '10'),
('12837', '330000', '330100', '330110', '1', '1', '径山镇', '0', '', '1', '0', '0', '10'),
('12838', '330000', '330100', '330110', '1', '1', '瓶窑镇', '0', '', '1', '0', '0', '10'),
('12839', '330000', '330100', '330110', '1', '1', '鸬鸟镇', '0', '', '1', '0', '0', '10'),
('12840', '330000', '330100', '330110', '1', '1', '百丈镇', '0', '', '1', '0', '0', '10'),
('12841', '330000', '330100', '330110', '1', '1', '黄湖镇', '0', '', '1', '0', '0', '10'),
('12842', '330000', '330100', '330110', '1', '1', '中泰乡', '0', '', '1', '0', '0', '10'),
('12843', '330000', '330100', '330122', '1', '1', '桐君街道', '0', '', '1', '0', '0', '10'),
('12844', '330000', '330100', '330122', '1', '1', '旧县街道', '0', '', '1', '0', '0', '10'),
('12845', '330000', '330100', '330122', '1', '1', '富春江镇', '0', '', '1', '0', '0', '10'),
('12846', '330000', '330100', '330122', '1', '1', '横村镇', '0', '', '1', '0', '0', '10'),
('12847', '330000', '330100', '330122', '1', '1', '凤川镇', '0', '', '1', '0', '0', '10'),
('12848', '330000', '330100', '330122', '1', '1', '分水镇', '0', '', '1', '0', '0', '10'),
('12849', '330000', '330100', '330122', '1', '1', '瑶琳镇', '0', '', '1', '0', '0', '10'),
('12850', '330000', '330100', '330122', '1', '1', '百江镇', '0', '', '1', '0', '0', '10'),
('12851', '330000', '330100', '330122', '1', '1', '江南镇', '0', '', '1', '0', '0', '10'),
('12852', '330000', '330100', '330122', '1', '1', '莪山畲族自治乡', '0', '', '1', '0', '0', '10'),
('12853', '330000', '330100', '330122', '1', '1', '钟山乡', '0', '', '1', '0', '0', '10'),
('12854', '330000', '330100', '330122', '1', '1', '新合乡', '0', '', '1', '0', '0', '10'),
('12855', '330000', '330100', '330122', '1', '1', '合村乡', '0', '', '1', '0', '0', '10'),
('12856', '330000', '330100', '330127', '1', '1', '千岛湖镇', '0', '', '1', '0', '0', '10'),
('12857', '330000', '330100', '330127', '1', '1', '文昌镇', '0', '', '1', '0', '0', '10'),
('12858', '330000', '330100', '330127', '1', '1', '石林镇', '0', '', '1', '0', '0', '10'),
('12859', '330000', '330100', '330127', '1', '1', '临岐镇', '0', '', '1', '0', '0', '10'),
('12860', '330000', '330100', '330127', '1', '1', '威坪镇', '0', '', '1', '0', '0', '10'),
('12861', '330000', '330100', '330127', '1', '1', '姜家镇', '0', '', '1', '0', '0', '10'),
('12862', '330000', '330100', '330127', '1', '1', '梓桐镇', '0', '', '1', '0', '0', '10'),
('12863', '330000', '330100', '330127', '1', '1', '汾口镇', '0', '', '1', '0', '0', '10'),
('12864', '330000', '330100', '330127', '1', '1', '中洲镇', '0', '', '1', '0', '0', '10'),
('12865', '330000', '330100', '330127', '1', '1', '大墅镇', '0', '', '1', '0', '0', '10'),
('12866', '330000', '330100', '330127', '1', '1', '枫树岭镇', '0', '', '1', '0', '0', '10'),
('12867', '330000', '330100', '330127', '1', '1', '里商乡', '0', '', '1', '0', '0', '10'),
('12868', '330000', '330100', '330127', '1', '1', '金峰乡', '0', '', '1', '0', '0', '10'),
('12869', '330000', '330100', '330127', '1', '1', '富文乡', '0', '', '1', '0', '0', '10'),
('12870', '330000', '330100', '330127', '1', '1', '左口乡', '0', '', '1', '0', '0', '10'),
('12871', '330000', '330100', '330127', '1', '1', '屏门乡', '0', '', '1', '0', '0', '10'),
('12872', '330000', '330100', '330127', '1', '1', '瑶山乡', '0', '', '1', '0', '0', '10'),
('12873', '330000', '330100', '330127', '1', '1', '王阜乡', '0', '', '1', '0', '0', '10'),
('12874', '330000', '330100', '330127', '1', '1', '宋村乡', '0', '', '1', '0', '0', '10'),
('12875', '330000', '330100', '330127', '1', '1', '鸠坑乡', '0', '', '1', '0', '0', '10'),
('12876', '330000', '330100', '330127', '1', '1', '浪川乡', '0', '', '1', '0', '0', '10'),
('12877', '330000', '330100', '330127', '1', '1', '界首乡', '0', '', '1', '0', '0', '10'),
('12878', '330000', '330100', '330127', '1', '1', '安阳乡', '0', '', '1', '0', '0', '10'),
('12879', '330000', '330100', '330182', '1', '1', '新安江街道', '0', '', '1', '0', '0', '10'),
('12880', '330000', '330100', '330182', '1', '1', '洋溪街道', '0', '', '1', '0', '0', '10'),
('12881', '330000', '330100', '330182', '1', '1', '更楼街道', '0', '', '1', '0', '0', '10'),
('12882', '330000', '330100', '330182', '1', '1', '莲花镇', '0', '', '1', '0', '0', '10'),
('12883', '330000', '330100', '330182', '1', '1', '乾潭镇', '0', '', '1', '0', '0', '10'),
('12884', '330000', '330100', '330182', '1', '1', '梅城镇', '0', '', '1', '0', '0', '10'),
('12885', '330000', '330100', '330182', '1', '1', '杨村桥镇', '0', '', '1', '0', '0', '10'),
('12886', '330000', '330100', '330182', '1', '1', '下涯镇', '0', '', '1', '0', '0', '10'),
('12887', '330000', '330100', '330182', '1', '1', '大洋镇', '0', '', '1', '0', '0', '10'),
('12888', '330000', '330100', '330182', '1', '1', '三都镇', '0', '', '1', '0', '0', '10'),
('12889', '330000', '330100', '330182', '1', '1', '寿昌镇', '0', '', '1', '0', '0', '10'),
('12890', '330000', '330100', '330182', '1', '1', '航头镇', '0', '', '1', '0', '0', '10'),
('12891', '330000', '330100', '330182', '1', '1', '大慈岩镇', '0', '', '1', '0', '0', '10'),
('12892', '330000', '330100', '330182', '1', '1', '大同镇', '0', '', '1', '0', '0', '10'),
('12893', '330000', '330100', '330182', '1', '1', '李家镇', '0', '', '1', '0', '0', '10'),
('12894', '330000', '330100', '330182', '1', '1', '钦堂乡', '0', '', '1', '0', '0', '10'),
('12895', '330000', '330100', '330183', '1', '1', '富春街道', '0', '', '1', '0', '0', '10'),
('12896', '330000', '330100', '330183', '1', '1', '春江街道', '0', '', '1', '0', '0', '10'),
('12897', '330000', '330100', '330183', '1', '1', '东洲街道', '0', '', '1', '0', '0', '10'),
('12898', '330000', '330100', '330183', '1', '1', '鹿山街道', '0', '', '1', '0', '0', '10'),
('12899', '330000', '330100', '330183', '1', '1', '万市镇', '0', '', '1', '0', '0', '10'),
('12900', '330000', '330100', '330183', '1', '1', '洞桥镇', '0', '', '1', '0', '0', '10'),
('12901', '330000', '330100', '330183', '1', '1', '新登镇', '0', '', '1', '0', '0', '10'),
('12902', '330000', '330100', '330183', '1', '1', '渌渚镇', '0', '', '1', '0', '0', '10'),
('12903', '330000', '330100', '330183', '1', '1', '胥口镇', '0', '', '1', '0', '0', '10'),
('12904', '330000', '330100', '330183', '1', '1', '永昌镇', '0', '', '1', '0', '0', '10'),
('12905', '330000', '330100', '330183', '1', '1', '大源镇', '0', '', '1', '0', '0', '10'),
('12906', '330000', '330100', '330183', '1', '1', '灵桥镇', '0', '', '1', '0', '0', '10'),
('12907', '330000', '330100', '330183', '1', '1', '里山镇', '0', '', '1', '0', '0', '10'),
('12908', '330000', '330100', '330183', '1', '1', '常绿镇', '0', '', '1', '0', '0', '10'),
('12909', '330000', '330100', '330183', '1', '1', '场口镇', '0', '', '1', '0', '0', '10'),
('12910', '330000', '330100', '330183', '1', '1', '常安镇', '0', '', '1', '0', '0', '10'),
('12911', '330000', '330100', '330183', '1', '1', '龙门镇', '0', '', '1', '0', '0', '10'),
('12912', '330000', '330100', '330183', '1', '1', '高桥镇', '0', '', '1', '0', '0', '10'),
('12913', '330000', '330100', '330183', '1', '1', '受降镇', '0', '', '1', '0', '0', '10'),
('12914', '330000', '330100', '330183', '1', '1', '新桐乡', '0', '', '1', '0', '0', '10'),
('12915', '330000', '330100', '330183', '1', '1', '上官乡', '0', '', '1', '0', '0', '10'),
('12916', '330000', '330100', '330183', '1', '1', '渔山乡', '0', '', '1', '0', '0', '10'),
('12917', '330000', '330100', '330183', '1', '1', '环山乡', '0', '', '1', '0', '0', '10'),
('12918', '330000', '330100', '330183', '1', '1', '湖源乡', '0', '', '1', '0', '0', '10'),
('12919', '330000', '330100', '330183', '1', '1', '春建乡', '0', '', '1', '0', '0', '10'),
('12920', '330000', '330100', '330185', '1', '1', '锦城街道', '0', '', '1', '0', '0', '10'),
('12921', '330000', '330100', '330185', '1', '1', '玲珑街道', '0', '', '1', '0', '0', '10'),
('12922', '330000', '330100', '330185', '1', '1', '青山湖街道', '0', '', '1', '0', '0', '10'),
('12923', '330000', '330100', '330185', '1', '1', '上甘街道', '0', '', '1', '0', '0', '10'),
('12924', '330000', '330100', '330185', '1', '1', '三口镇', '0', '', '1', '0', '0', '10'),
('12925', '330000', '330100', '330185', '1', '1', '横畈镇', '0', '', '1', '0', '0', '10'),
('12926', '330000', '330100', '330185', '1', '1', '高虹镇', '0', '', '1', '0', '0', '10'),
('12927', '330000', '330100', '330185', '1', '1', '太湖源镇', '0', '', '1', '0', '0', '10'),
('12928', '330000', '330100', '330185', '1', '1', '於潜镇', '0', '', '1', '0', '0', '10'),
('12929', '330000', '330100', '330185', '1', '1', '藻溪镇', '0', '', '1', '0', '0', '10'),
('12930', '330000', '330100', '330185', '1', '1', '太阳镇', '0', '', '1', '0', '0', '10'),
('12931', '330000', '330100', '330185', '1', '1', '潜川镇', '0', '', '1', '0', '0', '10'),
('12932', '330000', '330100', '330185', '1', '1', '昌化镇', '0', '', '1', '0', '0', '10'),
('12933', '330000', '330100', '330185', '1', '1', '河桥镇', '0', '', '1', '0', '0', '10'),
('12934', '330000', '330100', '330185', '1', '1', '龙岗镇', '0', '', '1', '0', '0', '10'),
('12935', '330000', '330100', '330185', '1', '1', '湍口镇', '0', '', '1', '0', '0', '10'),
('12936', '330000', '330100', '330185', '1', '1', '清凉峰镇', '0', '', '1', '0', '0', '10'),
('12937', '330000', '330100', '330185', '1', '1', '岛石镇', '0', '', '1', '0', '0', '10'),
('12938', '330000', '330100', '330185', '1', '1', '大峡谷镇', '0', '', '1', '0', '0', '10'),
('12939', '330000', '330100', '330185', '1', '1', '板桥乡', '0', '', '1', '0', '0', '10'),
('12940', '330000', '330100', '330185', '1', '1', '西天目乡', '0', '', '1', '0', '0', '10'),
('12941', '330000', '330100', '330185', '1', '1', '千洪乡', '0', '', '1', '0', '0', '10'),
('12942', '330000', '330100', '330185', '1', '1', '横路乡', '0', '', '1', '0', '0', '10'),
('12943', '330000', '330100', '330185', '1', '1', '乐平乡', '0', '', '1', '0', '0', '10'),
('12944', '330000', '330100', '330185', '1', '1', '马啸乡', '0', '', '1', '0', '0', '10'),
('12945', '330000', '330100', '330185', '1', '1', '新桥乡', '0', '', '1', '0', '0', '10'),
('12946', '330000', '330200', '330203', '1', '1', '南门街道', '0', '', '1', '0', '0', '10'),
('12947', '330000', '330200', '330203', '1', '1', '江厦街道', '0', '', '1', '0', '0', '10'),
('12948', '330000', '330200', '330203', '1', '1', '西门街道', '0', '', '1', '0', '0', '10'),
('12949', '330000', '330200', '330203', '1', '1', '月湖街道', '0', '', '1', '0', '0', '10'),
('12950', '330000', '330200', '330203', '1', '1', '鼓楼街道', '0', '', '1', '0', '0', '10'),
('12951', '330000', '330200', '330203', '1', '1', '白云街道', '0', '', '1', '0', '0', '10'),
('12952', '330000', '330200', '330203', '1', '1', '段塘街道', '0', '', '1', '0', '0', '10'),
('12953', '330000', '330200', '330203', '1', '1', '望春街道', '0', '', '1', '0', '0', '10'),
('12954', '330000', '330200', '330204', '1', '1', '百丈街道', '0', '', '1', '0', '0', '10'),
('12955', '330000', '330200', '330204', '1', '1', '东胜街道', '0', '', '1', '0', '0', '10'),
('12956', '330000', '330200', '330204', '1', '1', '明楼街道', '0', '', '1', '0', '0', '10'),
('12957', '330000', '330200', '330204', '1', '1', '白鹤街道', '0', '', '1', '0', '0', '10'),
('12958', '330000', '330200', '330204', '1', '1', '东柳街道', '0', '', '1', '0', '0', '10'),
('12959', '330000', '330200', '330204', '1', '1', '东郊街道', '0', '', '1', '0', '0', '10'),
('12960', '330000', '330200', '330204', '1', '1', '福明街道', '0', '', '1', '0', '0', '10'),
('12961', '330000', '330200', '330205', '1', '1', '中马街道', '0', '', '1', '0', '0', '10'),
('12962', '330000', '330200', '330205', '1', '1', '白沙街道', '0', '', '1', '0', '0', '10'),
('12963', '330000', '330200', '330205', '1', '1', '孔浦街道', '0', '', '1', '0', '0', '10'),
('12964', '330000', '330200', '330205', '1', '1', '文教街道', '0', '', '1', '0', '0', '10'),
('12965', '330000', '330200', '330205', '1', '1', '甬江街道', '0', '', '1', '0', '0', '10'),
('12966', '330000', '330200', '330205', '1', '1', '庄桥街道', '0', '', '1', '0', '0', '10'),
('12967', '330000', '330200', '330205', '1', '1', '洪塘街道', '0', '', '1', '0', '0', '10'),
('12968', '330000', '330200', '330205', '1', '1', '慈城镇', '0', '', '1', '0', '0', '10'),
('12969', '330000', '330200', '330206', '1', '1', '大榭街道', '0', '', '1', '0', '0', '10'),
('12970', '330000', '330200', '330206', '1', '1', '新碶街道', '0', '', '1', '0', '0', '10'),
('12971', '330000', '330200', '330206', '1', '1', '小港街道', '0', '', '1', '0', '0', '10'),
('12972', '330000', '330200', '330206', '1', '1', '大碶街道', '0', '', '1', '0', '0', '10'),
('12973', '330000', '330200', '330206', '1', '1', '霞浦街道', '0', '', '1', '0', '0', '10'),
('12974', '330000', '330200', '330206', '1', '1', '柴桥街道', '0', '', '1', '0', '0', '10'),
('12975', '330000', '330200', '330206', '1', '1', '白峰镇', '0', '', '1', '0', '0', '10'),
('12976', '330000', '330200', '330206', '1', '1', '春晓镇', '0', '', '1', '0', '0', '10'),
('12977', '330000', '330200', '330206', '1', '1', '梅山乡', '0', '', '1', '0', '0', '10'),
('12978', '330000', '330200', '330211', '1', '1', '招宝山街道', '0', '', '1', '0', '0', '10'),
('12979', '330000', '330200', '330211', '1', '1', '蛟川街道', '0', '', '1', '0', '0', '10'),
('12980', '330000', '330200', '330211', '1', '1', '骆驼街道', '0', '', '1', '0', '0', '10'),
('12981', '330000', '330200', '330211', '1', '1', '庄市街道', '0', '', '1', '0', '0', '10'),
('12982', '330000', '330200', '330211', '1', '1', '澥浦镇', '0', '', '1', '0', '0', '10'),
('12983', '330000', '330200', '330211', '1', '1', '九龙湖镇', '0', '', '1', '0', '0', '10'),
('12984', '330000', '330200', '330212', '1', '1', '下应街道', '0', '', '1', '0', '0', '10'),
('12985', '330000', '330200', '330212', '1', '1', '钟公庙街道', '0', '', '1', '0', '0', '10'),
('12986', '330000', '330200', '330212', '1', '1', '石碶街道', '0', '', '1', '0', '0', '10'),
('12987', '330000', '330200', '330212', '1', '1', '梅墟街道', '0', '', '1', '0', '0', '10'),
('12988', '330000', '330200', '330212', '1', '1', '瞻岐镇', '0', '', '1', '0', '0', '10'),
('12989', '330000', '330200', '330212', '1', '1', '咸祥镇', '0', '', '1', '0', '0', '10'),
('12990', '330000', '330200', '330212', '1', '1', '塘溪镇', '0', '', '1', '0', '0', '10'),
('12991', '330000', '330200', '330212', '1', '1', '东钱湖镇', '0', '', '1', '0', '0', '10'),
('12992', '330000', '330200', '330212', '1', '1', '东吴镇', '0', '', '1', '0', '0', '10'),
('12993', '330000', '330200', '330212', '1', '1', '五乡镇', '0', '', '1', '0', '0', '10'),
('12994', '330000', '330200', '330212', '1', '1', '邱隘镇', '0', '', '1', '0', '0', '10'),
('12995', '330000', '330200', '330212', '1', '1', '云龙镇', '0', '', '1', '0', '0', '10'),
('12996', '330000', '330200', '330212', '1', '1', '横溪镇', '0', '', '1', '0', '0', '10'),
('12997', '330000', '330200', '330212', '1', '1', '姜山镇', '0', '', '1', '0', '0', '10'),
('12998', '330000', '330200', '330212', '1', '1', '高桥镇', '0', '', '1', '0', '0', '10'),
('12999', '330000', '330200', '330212', '1', '1', '横街镇', '0', '', '1', '0', '0', '10'),
('13000', '330000', '330200', '330212', '1', '1', '集仕港镇', '0', '', '1', '0', '0', '10'),
('13001', '330000', '330200', '330212', '1', '1', '古林镇', '0', '', '1', '0', '0', '10'),
('13002', '330000', '330200', '330212', '1', '1', '洞桥镇', '0', '', '1', '0', '0', '10'),
('13003', '330000', '330200', '330212', '1', '1', '鄞江镇', '0', '', '1', '0', '0', '10'),
('13004', '330000', '330200', '330212', '1', '1', '章水镇', '0', '', '1', '0', '0', '10'),
('13005', '330000', '330200', '330212', '1', '1', '龙观乡', '0', '', '1', '0', '0', '10'),
('13006', '330000', '330200', '330225', '1', '1', '丹东街道', '0', '', '1', '0', '0', '10'),
('13007', '330000', '330200', '330225', '1', '1', '丹西街道', '0', '', '1', '0', '0', '10'),
('13008', '330000', '330200', '330225', '1', '1', '爵溪街道', '0', '', '1', '0', '0', '10'),
('13009', '330000', '330200', '330225', '1', '1', '石浦镇', '0', '', '1', '0', '0', '10'),
('13010', '330000', '330200', '330225', '1', '1', '西周镇', '0', '', '1', '0', '0', '10'),
('13011', '330000', '330200', '330225', '1', '1', '鹤浦镇', '0', '', '1', '0', '0', '10'),
('13012', '330000', '330200', '330225', '1', '1', '贤庠镇', '0', '', '1', '0', '0', '10'),
('13013', '330000', '330200', '330225', '1', '1', '墙头镇', '0', '', '1', '0', '0', '10'),
('13014', '330000', '330200', '330225', '1', '1', '泗洲头镇', '0', '', '1', '0', '0', '10'),
('13015', '330000', '330200', '330225', '1', '1', '定塘镇', '0', '', '1', '0', '0', '10'),
('13016', '330000', '330200', '330225', '1', '1', '涂茨镇', '0', '', '1', '0', '0', '10'),
('13017', '330000', '330200', '330225', '1', '1', '大徐镇', '0', '', '1', '0', '0', '10'),
('13018', '330000', '330200', '330225', '1', '1', '新桥镇', '0', '', '1', '0', '0', '10'),
('13019', '330000', '330200', '330225', '1', '1', '东陈乡', '0', '', '1', '0', '0', '10'),
('13020', '330000', '330200', '330225', '1', '1', '晓塘乡', '0', '', '1', '0', '0', '10'),
('13021', '330000', '330200', '330225', '1', '1', '黄避岙乡', '0', '', '1', '0', '0', '10'),
('13022', '330000', '330200', '330225', '1', '1', '茅洋乡', '0', '', '1', '0', '0', '10'),
('13023', '330000', '330200', '330225', '1', '1', '高塘岛乡', '0', '', '1', '0', '0', '10'),
('13024', '330000', '330200', '330226', '1', '1', '跃龙街道', '0', '', '1', '0', '0', '10'),
('13025', '330000', '330200', '330226', '1', '1', '桃源街道', '0', '', '1', '0', '0', '10'),
('13026', '330000', '330200', '330226', '1', '1', '梅林街道', '0', '', '1', '0', '0', '10'),
('13027', '330000', '330200', '330226', '1', '1', '桥头胡街道', '0', '', '1', '0', '0', '10'),
('13028', '330000', '330200', '330226', '1', '1', '长街镇', '0', '', '1', '0', '0', '10'),
('13029', '330000', '330200', '330226', '1', '1', '力洋镇', '0', '', '1', '0', '0', '10'),
('13030', '330000', '330200', '330226', '1', '1', '一市镇', '0', '', '1', '0', '0', '10'),
('13031', '330000', '330200', '330226', '1', '1', '岔路镇', '0', '', '1', '0', '0', '10'),
('13032', '330000', '330200', '330226', '1', '1', '前童镇', '0', '', '1', '0', '0', '10'),
('13033', '330000', '330200', '330226', '1', '1', '桑洲镇', '0', '', '1', '0', '0', '10'),
('13034', '330000', '330200', '330226', '1', '1', '黄坛镇', '0', '', '1', '0', '0', '10'),
('13035', '330000', '330200', '330226', '1', '1', '大佳何镇', '0', '', '1', '0', '0', '10'),
('13036', '330000', '330200', '330226', '1', '1', '强蛟镇', '0', '', '1', '0', '0', '10'),
('13037', '330000', '330200', '330226', '1', '1', '西店镇', '0', '', '1', '0', '0', '10'),
('13038', '330000', '330200', '330226', '1', '1', '深圳镇', '0', '', '1', '0', '0', '10'),
('13039', '330000', '330200', '330226', '1', '1', '胡陈乡', '0', '', '1', '0', '0', '10'),
('13040', '330000', '330200', '330226', '1', '1', '茶院乡', '0', '', '1', '0', '0', '10'),
('13041', '330000', '330200', '330226', '1', '1', '越溪乡', '0', '', '1', '0', '0', '10'),
('13042', '330000', '330200', '330281', '1', '1', '梨洲街道', '0', '', '1', '0', '0', '10'),
('13043', '330000', '330200', '330281', '1', '1', '凤山街道', '0', '', '1', '0', '0', '10'),
('13044', '330000', '330200', '330281', '1', '1', '兰江街道', '0', '', '1', '0', '0', '10'),
('13045', '330000', '330200', '330281', '1', '1', '阳明街道', '0', '', '1', '0', '0', '10'),
('13046', '330000', '330200', '330281', '1', '1', '低塘街道', '0', '', '1', '0', '0', '10'),
('13047', '330000', '330200', '330281', '1', '1', '朗霞街道', '0', '', '1', '0', '0', '10'),
('13048', '330000', '330200', '330281', '1', '1', '临山镇', '0', '', '1', '0', '0', '10'),
('13049', '330000', '330200', '330281', '1', '1', '黄家埠镇', '0', '', '1', '0', '0', '10'),
('13050', '330000', '330200', '330281', '1', '1', '小曹娥镇', '0', '', '1', '0', '0', '10'),
('13051', '330000', '330200', '330281', '1', '1', '泗门镇', '0', '', '1', '0', '0', '10'),
('13052', '330000', '330200', '330281', '1', '1', '马渚镇', '0', '', '1', '0', '0', '10'),
('13053', '330000', '330200', '330281', '1', '1', '牟山镇', '0', '', '1', '0', '0', '10'),
('13054', '330000', '330200', '330281', '1', '1', '丈亭镇', '0', '', '1', '0', '0', '10'),
('13055', '330000', '330200', '330281', '1', '1', '三七市镇', '0', '', '1', '0', '0', '10'),
('13056', '330000', '330200', '330281', '1', '1', '河姆渡镇', '0', '', '1', '0', '0', '10'),
('13057', '330000', '330200', '330281', '1', '1', '大隐镇', '0', '', '1', '0', '0', '10'),
('13058', '330000', '330200', '330281', '1', '1', '陆埠镇', '0', '', '1', '0', '0', '10'),
('13059', '330000', '330200', '330281', '1', '1', '梁弄镇', '0', '', '1', '0', '0', '10'),
('13060', '330000', '330200', '330281', '1', '1', '大岚镇', '0', '', '1', '0', '0', '10'),
('13061', '330000', '330200', '330281', '1', '1', '四明山镇', '0', '', '1', '0', '0', '10'),
('13062', '330000', '330200', '330281', '1', '1', '鹿亭乡', '0', '', '1', '0', '0', '10'),
('13063', '330000', '330200', '330282', '1', '1', '浒山街道', '0', '', '1', '0', '0', '10'),
('13064', '330000', '330200', '330282', '1', '1', '宗汉街道', '0', '', '1', '0', '0', '10'),
('13065', '330000', '330200', '330282', '1', '1', '坎墩街道', '0', '', '1', '0', '0', '10'),
('13066', '330000', '330200', '330282', '1', '1', '龙山镇', '0', '', '1', '0', '0', '10'),
('13067', '330000', '330200', '330282', '1', '1', '三北镇', '0', '', '1', '0', '0', '10'),
('13068', '330000', '330200', '330282', '1', '1', '范市镇', '0', '', '1', '0', '0', '10'),
('13069', '330000', '330200', '330282', '1', '1', '掌起镇', '0', '', '1', '0', '0', '10'),
('13070', '330000', '330200', '330282', '1', '1', '观海卫镇', '0', '', '1', '0', '0', '10'),
('13071', '330000', '330200', '330282', '1', '1', '附海镇', '0', '', '1', '0', '0', '10'),
('13072', '330000', '330200', '330282', '1', '1', '桥头镇', '0', '', '1', '0', '0', '10'),
('13073', '330000', '330200', '330282', '1', '1', '匡堰镇', '0', '', '1', '0', '0', '10'),
('13074', '330000', '330200', '330282', '1', '1', '逍林镇', '0', '', '1', '0', '0', '10'),
('13075', '330000', '330200', '330282', '1', '1', '新浦镇', '0', '', '1', '0', '0', '10'),
('13076', '330000', '330200', '330282', '1', '1', '胜山镇', '0', '', '1', '0', '0', '10'),
('13077', '330000', '330200', '330282', '1', '1', '横河镇', '0', '', '1', '0', '0', '10'),
('13078', '330000', '330200', '330282', '1', '1', '崇寿镇', '0', '', '1', '0', '0', '10'),
('13079', '330000', '330200', '330282', '1', '1', '庵东镇', '0', '', '1', '0', '0', '10'),
('13080', '330000', '330200', '330282', '1', '1', '天元镇', '0', '', '1', '0', '0', '10'),
('13081', '330000', '330200', '330282', '1', '1', '长河镇', '0', '', '1', '0', '0', '10'),
('13082', '330000', '330200', '330282', '1', '1', '周巷镇', '0', '', '1', '0', '0', '10'),
('13083', '330000', '330200', '330283', '1', '1', '锦屏街道', '0', '', '1', '0', '0', '10'),
('13084', '330000', '330200', '330283', '1', '1', '岳林街道', '0', '', '1', '0', '0', '10'),
('13085', '330000', '330200', '330283', '1', '1', '江口街道', '0', '', '1', '0', '0', '10'),
('13086', '330000', '330200', '330283', '1', '1', '西坞街道', '0', '', '1', '0', '0', '10'),
('13087', '330000', '330200', '330283', '1', '1', '萧王庙街道', '0', '', '1', '0', '0', '10'),
('13088', '330000', '330200', '330283', '1', '1', '溪口镇', '0', '', '1', '0', '0', '10'),
('13089', '330000', '330200', '330283', '1', '1', '尚田镇', '0', '', '1', '0', '0', '10'),
('13090', '330000', '330200', '330283', '1', '1', '莼湖镇', '0', '', '1', '0', '0', '10'),
('13091', '330000', '330200', '330283', '1', '1', '裘村镇', '0', '', '1', '0', '0', '10'),
('13092', '330000', '330200', '330283', '1', '1', '大堰镇', '0', '', '1', '0', '0', '10'),
('13093', '330000', '330200', '330283', '1', '1', '松岙镇', '0', '', '1', '0', '0', '10'),
('13094', '330000', '330300', '330302', '1', '1', '洪殿街道', '0', '', '1', '0', '0', '10'),
('13095', '330000', '330300', '330302', '1', '1', '五马街道', '0', '', '1', '0', '0', '10'),
('13096', '330000', '330300', '330302', '1', '1', '蒲鞋市街道', '0', '', '1', '0', '0', '10'),
('13097', '330000', '330300', '330302', '1', '1', '莲池街道', '0', '', '1', '0', '0', '10'),
('13098', '330000', '330300', '330302', '1', '1', '广化街道', '0', '', '1', '0', '0', '10'),
('13099', '330000', '330300', '330302', '1', '1', '水心街道', '0', '', '1', '0', '0', '10'),
('13100', '330000', '330300', '330302', '1', '1', '南浦街道', '0', '', '1', '0', '0', '10'),
('13101', '330000', '330300', '330302', '1', '1', '南门街道', '0', '', '1', '0', '0', '10'),
('13102', '330000', '330300', '330302', '1', '1', '江滨街道', '0', '', '1', '0', '0', '10'),
('13103', '330000', '330300', '330302', '1', '1', '黎明街道', '0', '', '1', '0', '0', '10'),
('13104', '330000', '330300', '330302', '1', '1', '绣山街道', '0', '', '1', '0', '0', '10'),
('13105', '330000', '330300', '330302', '1', '1', '黄龙街道', '0', '', '1', '0', '0', '10'),
('13106', '330000', '330300', '330302', '1', '1', '双屿镇', '0', '', '1', '0', '0', '10'),
('13107', '330000', '330300', '330302', '1', '1', '藤桥镇', '0', '', '1', '0', '0', '10'),
('13108', '330000', '330300', '330302', '1', '1', '临江镇', '0', '', '1', '0', '0', '10'),
('13109', '330000', '330300', '330302', '1', '1', '七都镇', '0', '', '1', '0', '0', '10'),
('13110', '330000', '330300', '330302', '1', '1', '南郊乡', '0', '', '1', '0', '0', '10'),
('13111', '330000', '330300', '330302', '1', '1', '仰义乡', '0', '', '1', '0', '0', '10'),
('13112', '330000', '330300', '330302', '1', '1', '双潮乡', '0', '', '1', '0', '0', '10'),
('13113', '330000', '330300', '330302', '1', '1', '上戍乡', '0', '', '1', '0', '0', '10'),
('13114', '330000', '330300', '330302', '1', '1', '岙底乡', '0', '', '1', '0', '0', '10'),
('13115', '330000', '330300', '330303', '1', '1', '永中街道', '0', '', '1', '0', '0', '10'),
('13116', '330000', '330300', '330303', '1', '1', '蒲州街道', '0', '', '1', '0', '0', '10'),
('13117', '330000', '330300', '330303', '1', '1', '海滨街道', '0', '', '1', '0', '0', '10'),
('13118', '330000', '330300', '330303', '1', '1', '永兴街道', '0', '', '1', '0', '0', '10'),
('13119', '330000', '330300', '330303', '1', '1', '海城街道', '0', '', '1', '0', '0', '10'),
('13120', '330000', '330300', '330303', '1', '1', '状元镇', '0', '', '1', '0', '0', '10'),
('13121', '330000', '330300', '330303', '1', '1', '瑶溪镇', '0', '', '1', '0', '0', '10'),
('13122', '330000', '330300', '330303', '1', '1', '沙城镇', '0', '', '1', '0', '0', '10'),
('13123', '330000', '330300', '330303', '1', '1', '天河镇', '0', '', '1', '0', '0', '10'),
('13124', '330000', '330300', '330303', '1', '1', '灵昆镇', '0', '', '1', '0', '0', '10'),
('13125', '330000', '330300', '330304', '1', '1', '景山街道', '0', '', '1', '0', '0', '10'),
('13126', '330000', '330300', '330304', '1', '1', '梧田街道', '0', '', '1', '0', '0', '10'),
('13127', '330000', '330300', '330304', '1', '1', '南白象街道', '0', '', '1', '0', '0', '10'),
('13128', '330000', '330300', '330304', '1', '1', '茶山街道', '0', '', '1', '0', '0', '10'),
('13129', '330000', '330300', '330304', '1', '1', '娄桥街道', '0', '', '1', '0', '0', '10'),
('13130', '330000', '330300', '330304', '1', '1', '新桥街道', '0', '', '1', '0', '0', '10'),
('13131', '330000', '330300', '330304', '1', '1', '三垟街道', '0', '', '1', '0', '0', '10'),
('13132', '330000', '330300', '330304', '1', '1', '瞿溪镇', '0', '', '1', '0', '0', '10'),
('13133', '330000', '330300', '330304', '1', '1', '郭溪镇', '0', '', '1', '0', '0', '10'),
('13134', '330000', '330300', '330304', '1', '1', '潘桥镇', '0', '', '1', '0', '0', '10'),
('13135', '330000', '330300', '330304', '1', '1', '泽雅镇', '0', '', '1', '0', '0', '10'),
('13136', '330000', '330300', '330304', '1', '1', '丽岙镇', '0', '', '1', '0', '0', '10'),
('13137', '330000', '330300', '330304', '1', '1', '仙岩镇', '0', '', '1', '0', '0', '10'),
('13138', '330000', '330300', '330322', '1', '1', '北岙镇', '0', '', '1', '0', '0', '10'),
('13139', '330000', '330300', '330322', '1', '1', '大门镇', '0', '', '1', '0', '0', '10'),
('13140', '330000', '330300', '330322', '1', '1', '东屏镇', '0', '', '1', '0', '0', '10'),
('13141', '330000', '330300', '330322', '1', '1', '元觉乡', '0', '', '1', '0', '0', '10'),
('13142', '330000', '330300', '330322', '1', '1', '霓屿乡', '0', '', '1', '0', '0', '10'),
('13143', '330000', '330300', '330322', '1', '1', '鹿西乡', '0', '', '1', '0', '0', '10'),
('13144', '330000', '330300', '330324', '1', '1', '上塘镇', '0', '', '1', '0', '0', '10'),
('13145', '330000', '330300', '330324', '1', '1', '瓯北镇', '0', '', '1', '0', '0', '10'),
('13146', '330000', '330300', '330324', '1', '1', '桥头镇', '0', '', '1', '0', '0', '10'),
('13147', '330000', '330300', '330324', '1', '1', '乌牛镇', '0', '', '1', '0', '0', '10'),
('13148', '330000', '330300', '330324', '1', '1', '桥下镇', '0', '', '1', '0', '0', '10'),
('13149', '330000', '330300', '330324', '1', '1', '大若岩镇', '0', '', '1', '0', '0', '10'),
('13150', '330000', '330300', '330324', '1', '1', '碧莲镇', '0', '', '1', '0', '0', '10'),
('13151', '330000', '330300', '330324', '1', '1', '巽宅镇', '0', '', '1', '0', '0', '10'),
('13152', '330000', '330300', '330324', '1', '1', '岩头镇', '0', '', '1', '0', '0', '10'),
('13153', '330000', '330300', '330324', '1', '1', '枫林镇', '0', '', '1', '0', '0', '10'),
('13154', '330000', '330300', '330324', '1', '1', '岩坦镇', '0', '', '1', '0', '0', '10'),
('13155', '330000', '330300', '330324', '1', '1', '沙头镇', '0', '', '1', '0', '0', '10'),
('13156', '330000', '330300', '330324', '1', '1', '西溪乡', '0', '', '1', '0', '0', '10'),
('13157', '330000', '330300', '330324', '1', '1', '徐岙乡', '0', '', '1', '0', '0', '10'),
('13158', '330000', '330300', '330324', '1', '1', '昆阳乡', '0', '', '1', '0', '0', '10'),
('13159', '330000', '330300', '330324', '1', '1', '茗岙乡', '0', '', '1', '0', '0', '10'),
('13160', '330000', '330300', '330324', '1', '1', '山坑乡', '0', '', '1', '0', '0', '10'),
('13161', '330000', '330300', '330324', '1', '1', '应坑乡', '0', '', '1', '0', '0', '10'),
('13162', '330000', '330300', '330324', '1', '1', '大岙乡', '0', '', '1', '0', '0', '10'),
('13163', '330000', '330300', '330324', '1', '1', '溪下乡', '0', '', '1', '0', '0', '10'),
('13164', '330000', '330300', '330324', '1', '1', '界坑乡', '0', '', '1', '0', '0', '10'),
('13165', '330000', '330300', '330324', '1', '1', '西岙乡', '0', '', '1', '0', '0', '10'),
('13166', '330000', '330300', '330324', '1', '1', '石染乡', '0', '', '1', '0', '0', '10'),
('13167', '330000', '330300', '330324', '1', '1', '五(氵束鸟）乡', '0', '', '1', '0', '0', '10'),
('13168', '330000', '330300', '330324', '1', '1', '表山乡', '0', '', '1', '0', '0', '10'),
('13169', '330000', '330300', '330324', '1', '1', '东皋乡', '0', '', '1', '0', '0', '10'),
('13170', '330000', '330300', '330324', '1', '1', '鹤盛乡', '0', '', '1', '0', '0', '10'),
('13171', '330000', '330300', '330324', '1', '1', '西源乡', '0', '', '1', '0', '0', '10'),
('13172', '330000', '330300', '330324', '1', '1', '岭头乡', '0', '', '1', '0', '0', '10'),
('13173', '330000', '330300', '330324', '1', '1', '溪口乡', '0', '', '1', '0', '0', '10'),
('13174', '330000', '330300', '330324', '1', '1', '鲤溪乡', '0', '', '1', '0', '0', '10'),
('13175', '330000', '330300', '330324', '1', '1', '张溪乡', '0', '', '1', '0', '0', '10'),
('13176', '330000', '330300', '330324', '1', '1', '黄南乡', '0', '', '1', '0', '0', '10'),
('13177', '330000', '330300', '330324', '1', '1', '潘坑乡', '0', '', '1', '0', '0', '10'),
('13178', '330000', '330300', '330324', '1', '1', '陡门乡', '0', '', '1', '0', '0', '10'),
('13179', '330000', '330300', '330324', '1', '1', '花坦乡', '0', '', '1', '0', '0', '10'),
('13180', '330000', '330300', '330324', '1', '1', '渠口乡', '0', '', '1', '0', '0', '10'),
('13181', '330000', '330300', '330324', '1', '1', '下寮乡', '0', '', '1', '0', '0', '10'),
('13182', '330000', '330300', '330326', '1', '1', '昆阳镇', '0', '', '1', '0', '0', '10'),
('13183', '330000', '330300', '330326', '1', '1', '鳌江镇', '0', '', '1', '0', '0', '10'),
('13184', '330000', '330300', '330326', '1', '1', '水头镇', '0', '', '1', '0', '0', '10'),
('13185', '330000', '330300', '330326', '1', '1', '萧江镇', '0', '', '1', '0', '0', '10'),
('13186', '330000', '330300', '330326', '1', '1', '麻步镇', '0', '', '1', '0', '0', '10'),
('13187', '330000', '330300', '330326', '1', '1', '腾蛟镇', '0', '', '1', '0', '0', '10'),
('13188', '330000', '330300', '330326', '1', '1', '钱仓镇', '0', '', '1', '0', '0', '10'),
('13189', '330000', '330300', '330326', '1', '1', '山门镇', '0', '', '1', '0', '0', '10'),
('13190', '330000', '330300', '330326', '1', '1', '顺溪镇', '0', '', '1', '0', '0', '10'),
('13191', '330000', '330300', '330326', '1', '1', '南雁镇', '0', '', '1', '0', '0', '10'),
('13192', '330000', '330300', '330326', '1', '1', '凤卧镇', '0', '', '1', '0', '0', '10'),
('13193', '330000', '330300', '330326', '1', '1', '鹤溪镇', '0', '', '1', '0', '0', '10'),
('13194', '330000', '330300', '330326', '1', '1', '宋桥镇', '0', '', '1', '0', '0', '10'),
('13195', '330000', '330300', '330326', '1', '1', '宋埠镇', '0', '', '1', '0', '0', '10'),
('13196', '330000', '330300', '330326', '1', '1', '榆垟镇', '0', '', '1', '0', '0', '10'),
('13197', '330000', '330300', '330326', '1', '1', '郑楼镇', '0', '', '1', '0', '0', '10'),
('13198', '330000', '330300', '330326', '1', '1', '南麂镇', '0', '', '1', '0', '0', '10'),
('13199', '330000', '330300', '330326', '1', '1', '西湾乡', '0', '', '1', '0', '0', '10'),
('13200', '330000', '330300', '330326', '1', '1', '梅溪乡', '0', '', '1', '0', '0', '10'),
('13201', '330000', '330300', '330326', '1', '1', '梅源乡', '0', '', '1', '0', '0', '10'),
('13202', '330000', '330300', '330326', '1', '1', '桃源乡', '0', '', '1', '0', '0', '10'),
('13203', '330000', '330300', '330326', '1', '1', '凤巢乡', '0', '', '1', '0', '0', '10'),
('13204', '330000', '330300', '330326', '1', '1', '龙尾乡', '0', '', '1', '0', '0', '10'),
('13205', '330000', '330300', '330326', '1', '1', '南湖乡', '0', '', '1', '0', '0', '10'),
('13206', '330000', '330300', '330326', '1', '1', '朝阳乡', '0', '', '1', '0', '0', '10'),
('13207', '330000', '330300', '330326', '1', '1', '闹村乡', '0', '', '1', '0', '0', '10'),
('13208', '330000', '330300', '330326', '1', '1', '晓坑乡', '0', '', '1', '0', '0', '10'),
('13209', '330000', '330300', '330326', '1', '1', '怀溪乡', '0', '', '1', '0', '0', '10'),
('13210', '330000', '330300', '330326', '1', '1', '青街畲族乡', '0', '', '1', '0', '0', '10'),
('13211', '330000', '330300', '330326', '1', '1', '维新乡', '0', '', '1', '0', '0', '10'),
('13212', '330000', '330300', '330326', '1', '1', '吴垟乡', '0', '', '1', '0', '0', '10'),
('13213', '330000', '330300', '330327', '1', '1', '灵溪镇', '0', '', '1', '0', '0', '10'),
('13214', '330000', '330300', '330327', '1', '1', '龙港镇', '0', '', '1', '0', '0', '10'),
('13215', '330000', '330300', '330327', '1', '1', '宜山镇', '0', '', '1', '0', '0', '10'),
('13216', '330000', '330300', '330327', '1', '1', '钱库镇', '0', '', '1', '0', '0', '10'),
('13217', '330000', '330300', '330327', '1', '1', '芦浦镇', '0', '', '1', '0', '0', '10'),
('13218', '330000', '330300', '330327', '1', '1', '望里镇', '0', '', '1', '0', '0', '10'),
('13219', '330000', '330300', '330327', '1', '1', '金乡镇', '0', '', '1', '0', '0', '10'),
('13220', '330000', '330300', '330327', '1', '1', '舥艚镇', '0', '', '1', '0', '0', '10'),
('13221', '330000', '330300', '330327', '1', '1', '炎亭镇', '0', '', '1', '0', '0', '10'),
('13222', '330000', '330300', '330327', '1', '1', '大渔镇', '0', '', '1', '0', '0', '10'),
('13223', '330000', '330300', '330327', '1', '1', '藻溪镇', '0', '', '1', '0', '0', '10'),
('13224', '330000', '330300', '330327', '1', '1', '桥墩镇', '0', '', '1', '0', '0', '10'),
('13225', '330000', '330300', '330327', '1', '1', '莒溪镇', '0', '', '1', '0', '0', '10'),
('13226', '330000', '330300', '330327', '1', '1', '观美镇', '0', '', '1', '0', '0', '10'),
('13227', '330000', '330300', '330327', '1', '1', '矾山镇', '0', '', '1', '0', '0', '10'),
('13228', '330000', '330300', '330327', '1', '1', '赤溪镇', '0', '', '1', '0', '0', '10'),
('13229', '330000', '330300', '330327', '1', '1', '马站镇', '0', '', '1', '0', '0', '10'),
('13230', '330000', '330300', '330327', '1', '1', '霞关镇', '0', '', '1', '0', '0', '10'),
('13231', '330000', '330300', '330327', '1', '1', '沿浦镇', '0', '', '1', '0', '0', '10'),
('13232', '330000', '330300', '330327', '1', '1', '南宋镇', '0', '', '1', '0', '0', '10'),
('13233', '330000', '330300', '330327', '1', '1', '云岩乡', '0', '', '1', '0', '0', '10'),
('13234', '330000', '330300', '330327', '1', '1', '仙居乡', '0', '', '1', '0', '0', '10'),
('13235', '330000', '330300', '330327', '1', '1', '新安乡', '0', '', '1', '0', '0', '10'),
('13236', '330000', '330300', '330327', '1', '1', '括山乡', '0', '', '1', '0', '0', '10'),
('13237', '330000', '330300', '330327', '1', '1', '石砰乡', '0', '', '1', '0', '0', '10'),
('13238', '330000', '330300', '330327', '1', '1', '凤池乡', '0', '', '1', '0', '0', '10'),
('13239', '330000', '330300', '330327', '1', '1', '浦亭乡', '0', '', '1', '0', '0', '10'),
('13240', '330000', '330300', '330327', '1', '1', '五凤乡', '0', '', '1', '0', '0', '10'),
('13241', '330000', '330300', '330327', '1', '1', '腾垟乡', '0', '', '1', '0', '0', '10'),
('13242', '330000', '330300', '330327', '1', '1', '昌禅乡', '0', '', '1', '0', '0', '10'),
('13243', '330000', '330300', '330327', '1', '1', '中墩乡', '0', '', '1', '0', '0', '10'),
('13244', '330000', '330300', '330327', '1', '1', '龙沙乡', '0', '', '1', '0', '0', '10'),
('13245', '330000', '330300', '330327', '1', '1', '凤阳畲族乡', '0', '', '1', '0', '0', '10'),
('13246', '330000', '330300', '330327', '1', '1', '蒲城乡', '0', '', '1', '0', '0', '10'),
('13247', '330000', '330300', '330327', '1', '1', '岱岭畲族乡', '0', '', '1', '0', '0', '10'),
('13248', '330000', '330300', '330327', '1', '1', '渔寮乡', '0', '', '1', '0', '0', '10'),
('13249', '330000', '330300', '330328', '1', '1', '大峃镇', '0', '', '1', '0', '0', '10'),
('13250', '330000', '330300', '330328', '1', '1', '百丈漈镇', '0', '', '1', '0', '0', '10'),
('13251', '330000', '330300', '330328', '1', '1', '南田镇', '0', '', '1', '0', '0', '10'),
('13252', '330000', '330300', '330328', '1', '1', '西坑畲族镇', '0', '', '1', '0', '0', '10'),
('13253', '330000', '330300', '330328', '1', '1', '黄坦镇', '0', '', '1', '0', '0', '10'),
('13254', '330000', '330300', '330328', '1', '1', '珊溪镇', '0', '', '1', '0', '0', '10'),
('13255', '330000', '330300', '330328', '1', '1', '巨屿镇', '0', '', '1', '0', '0', '10'),
('13256', '330000', '330300', '330328', '1', '1', '玉壶镇', '0', '', '1', '0', '0', '10'),
('13257', '330000', '330300', '330328', '1', '1', '樟台乡', '0', '', '1', '0', '0', '10'),
('13258', '330000', '330300', '330328', '1', '1', '金炉乡', '0', '', '1', '0', '0', '10'),
('13259', '330000', '330300', '330328', '1', '1', '龙川乡', '0', '', '1', '0', '0', '10'),
('13260', '330000', '330300', '330328', '1', '1', '里阳乡', '0', '', '1', '0', '0', '10'),
('13261', '330000', '330300', '330328', '1', '1', '二源乡', '0', '', '1', '0', '0', '10'),
('13262', '330000', '330300', '330328', '1', '1', '黄寮乡', '0', '', '1', '0', '0', '10'),
('13263', '330000', '330300', '330328', '1', '1', '十源乡', '0', '', '1', '0', '0', '10'),
('13264', '330000', '330300', '330328', '1', '1', '石垟乡', '0', '', '1', '0', '0', '10'),
('13265', '330000', '330300', '330328', '1', '1', '下垟乡', '0', '', '1', '0', '0', '10'),
('13266', '330000', '330300', '330328', '1', '1', '岭后乡', '0', '', '1', '0', '0', '10'),
('13267', '330000', '330300', '330328', '1', '1', '富岙乡', '0', '', '1', '0', '0', '10'),
('13268', '330000', '330300', '330328', '1', '1', '云湖乡', '0', '', '1', '0', '0', '10'),
('13269', '330000', '330300', '330328', '1', '1', '仰山乡', '0', '', '1', '0', '0', '10'),
('13270', '330000', '330300', '330328', '1', '1', '桂山乡', '0', '', '1', '0', '0', '10'),
('13271', '330000', '330300', '330328', '1', '1', '峃口乡', '0', '', '1', '0', '0', '10'),
('13272', '330000', '330300', '330328', '1', '1', '金垟乡', '0', '', '1', '0', '0', '10'),
('13273', '330000', '330300', '330328', '1', '1', '双桂乡', '0', '', '1', '0', '0', '10'),
('13274', '330000', '330300', '330328', '1', '1', '周山畲族乡', '0', '', '1', '0', '0', '10'),
('13275', '330000', '330300', '330328', '1', '1', '公阳乡', '0', '', '1', '0', '0', '10'),
('13276', '330000', '330300', '330328', '1', '1', '平和乡', '0', '', '1', '0', '0', '10'),
('13277', '330000', '330300', '330328', '1', '1', '周壤乡', '0', '', '1', '0', '0', '10'),
('13278', '330000', '330300', '330328', '1', '1', '上林乡', '0', '', '1', '0', '0', '10'),
('13279', '330000', '330300', '330328', '1', '1', '东溪乡', '0', '', '1', '0', '0', '10'),
('13280', '330000', '330300', '330328', '1', '1', '金星乡', '0', '', '1', '0', '0', '10'),
('13281', '330000', '330300', '330328', '1', '1', '朱雅乡', '0', '', '1', '0', '0', '10'),
('13282', '330000', '330300', '330329', '1', '1', '罗阳镇', '0', '', '1', '0', '0', '10'),
('13283', '330000', '330300', '330329', '1', '1', '司前畲族镇', '0', '', '1', '0', '0', '10'),
('13284', '330000', '330300', '330329', '1', '1', '百丈镇', '0', '', '1', '0', '0', '10'),
('13285', '330000', '330300', '330329', '1', '1', '筱村镇', '0', '', '1', '0', '0', '10'),
('13286', '330000', '330300', '330329', '1', '1', '泗溪镇', '0', '', '1', '0', '0', '10'),
('13287', '330000', '330300', '330329', '1', '1', '彭溪镇', '0', '', '1', '0', '0', '10'),
('13288', '330000', '330300', '330329', '1', '1', '雅阳镇', '0', '', '1', '0', '0', '10'),
('13289', '330000', '330300', '330329', '1', '1', '仕阳镇', '0', '', '1', '0', '0', '10'),
('13290', '330000', '330300', '330329', '1', '1', '龟湖镇', '0', '', '1', '0', '0', '10'),
('13291', '330000', '330300', '330329', '1', '1', '三魁镇', '0', '', '1', '0', '0', '10'),
('13292', '330000', '330300', '330329', '1', '1', '西旸镇', '0', '', '1', '0', '0', '10'),
('13293', '330000', '330300', '330329', '1', '1', '岭北乡', '0', '', '1', '0', '0', '10'),
('13294', '330000', '330300', '330329', '1', '1', '仙稔乡', '0', '', '1', '0', '0', '10'),
('13295', '330000', '330300', '330329', '1', '1', '南院乡', '0', '', '1', '0', '0', '10'),
('13296', '330000', '330300', '330329', '1', '1', '碑排乡', '0', '', '1', '0', '0', '10'),
('13297', '330000', '330300', '330329', '1', '1', '竹里畲族乡', '0', '', '1', '0', '0', '10'),
('13298', '330000', '330300', '330329', '1', '1', '黄桥乡', '0', '', '1', '0', '0', '10'),
('13299', '330000', '330300', '330329', '1', '1', '峰门乡', '0', '', '1', '0', '0', '10'),
('13300', '330000', '330300', '330329', '1', '1', '包垟乡', '0', '', '1', '0', '0', '10'),
('13301', '330000', '330300', '330329', '1', '1', '新浦乡', '0', '', '1', '0', '0', '10'),
('13302', '330000', '330300', '330329', '1', '1', '联云乡', '0', '', '1', '0', '0', '10'),
('13303', '330000', '330300', '330329', '1', '1', '翁山乡', '0', '', '1', '0', '0', '10'),
('13304', '330000', '330300', '330329', '1', '1', '凤垟乡', '0', '', '1', '0', '0', '10'),
('13305', '330000', '330300', '330329', '1', '1', '横坑乡', '0', '', '1', '0', '0', '10'),
('13306', '330000', '330300', '330329', '1', '1', '九峰乡', '0', '', '1', '0', '0', '10'),
('13307', '330000', '330300', '330329', '1', '1', '峰文乡', '0', '', '1', '0', '0', 