
SET FOREIGN_KEY_CHECKS=0;

-- ----------------------------
-- Table structure for `wst_areas`
-- ----------------------------
DROP TABLE IF EXISTS `wst_areas`;
CREATE TABLE `wst_areas` (
  `areaId` int(11) NOT NULL AUTO_INCREMENT,
  `parentId` int(11) NOT NULL,
  `areaName` varchar(20) DEFAULT NULL,
  `isShow` tinyint(4) DEFAULT '1',
  `areaSort` int(11) DEFAULT '0',
  `areaKey` char(255) DEFAULT NULL,
  `areaType` tinyint(4) DEFAULT '1',
  `areaFlag` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`areaId`),
  KEY `areaType` (`areaType`),
  KEY `isShow` (`isShow`,`parentId`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=659004403 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of wst_areas
-- ----------------------------
INSERT INTO `wst_areas` VALUES ('110000', '0', '北京市', '1', '110000', 'B', '0', '1'),
('120000', '0', '天津市', '1', '120000', 'T', '0', '1'),
('130000', '0', '河北省', '1', '130000', 'H', '0', '1'),
('130100', '130000', '石家庄市', '1', '130100', 'S', '1', '1'),
('130102', '130100', '长安区', '1', '130102', null, '2', '1'),
('130103', '130100', '桥东区', '1', '130103', null, '2', '1'),
('130104', '130100', '桥西区', '1', '130104', null, '2', '1'),
('130105', '130100', '新华区', '1', '130105', null, '2', '1'),
('130107', '130100', '井陉矿区', '1', '130107', null, '2', '1'),
('130108', '130100', '裕华区', '1', '130108', null, '2', '1'),
('130121', '130100', '井陉县', '1', '130121', null, '2', '1'),
('130123', '130100', '正定县', '1', '130123', null, '2', '1'),
('130124', '130100', '栾城县', '1', '130124', null, '2', '1'),
('130125', '130100', '行唐县', '1', '130125', null, '2', '1'),
('130126', '130100', '灵寿县', '1', '130126', null, '2', '1'),
('130127', '130100', '高邑县', '1', '130127', null, '2', '1'),
('130128', '130100', '深泽县', '1', '130128', null, '2', '1'),
('130129', '130100', '赞皇县', '1', '130129', null, '2', '1'),
('130130', '130100', '无极县', '1', '130130', null, '2', '1'),
('130131', '130100', '平山县', '1', '130131', null, '2', '1'),
('130132', '130100', '元氏县', '1', '130132', null, '2', '1'),
('130133', '130100', '赵县', '1', '130133', null, '2', '1'),
('130181', '130100', '辛集市', '1', '130181', null, '2', '1'),
('130182', '130100', '藁城市', '1', '130182', null, '2', '1'),
('130183', '130100', '晋州市', '1', '130183', null, '2', '1'),
('130184', '130100', '新乐市', '1', '130184', null, '2', '1'),
('130185', '130100', '鹿泉市', '1', '130185', null, '2', '1'),
('130200', '130000', '唐山市', '1', '130200', 'T', '1', '1'),
('130202', '130200', '路南区', '1', '130202', null, '2', '1'),
('130203', '130200', '路北区', '1', '130203', null, '2', '1'),
('130204', '130200', '古冶区', '1', '130204', null, '2', '1'),
('130205', '130200', '开平区', '1', '130205', null, '2', '1'),
('130207', '130200', '丰南区', '1', '130207', null, '2', '1'),
('130208', '130200', '丰润区', '1', '130208', null, '2', '1'),
('130223', '130200', '滦县', '1', '130223', null, '2', '1'),
('130224', '130200', '滦南县', '1', '130224', null, '2', '1'),
('130225', '130200', '乐亭县', '1', '130225', null, '2', '1'),
('130227', '130200', '迁西县', '1', '130227', null, '2', '1'),
('130229', '130200', '玉田县', '1', '130229', null, '2', '1'),
('130230', '130200', '唐海县', '1', '130230', null, '2', '1'),
('130281', '130200', '遵化市', '1', '130281', null, '2', '1'),
('130283', '130200', '迁安市', '1', '130283', null, '2', '1'),
('130300', '130000', '秦皇岛市', '1', '130300', 'Q', '1', '1'),
('130302', '130300', '海港区', '1', '130302', null, '2', '1'),
('130303', '130300', '山海关区', '1', '130303', null, '2', '1'),
('130304', '130300', '北戴河区', '1', '130304', null, '2', '1'),
('130321', '130300', '青龙满族自治县', '1', '130321', null, '2', '1'),
('130322', '130300', '昌黎县', '1', '130322', null, '2', '1'),
('130323', '130300', '抚宁县', '1', '130323', null, '2', '1'),
('130324', '130300', '卢龙县', '1', '130324', null, '2', '1'),
('130400', '130000', '邯郸市', '1', '130400', 'H', '1', '1'),
('130402', '130400', '邯山区', '1', '130402', null, '2', '1'),
('130403', '130400', '丛台区', '1', '130403', null, '2', '1'),
('130404', '130400', '复兴区', '1', '130404', null, '2', '1'),
('130406', '130400', '峰峰矿区', '1', '130406', null, '2', '1'),
('130421', '130400', '邯郸县', '1', '130421', null, '2', '1'),
('130423', '130400', '临漳县', '1', '130423', null, '2', '1'),
('130424', '130400', '成安县', '1', '130424', null, '2', '1'),
('130425', '130400', '大名县', '1', '130425', null, '2', '1'),
('130426', '130400', '涉县', '1', '130426', null, '2', '1'),
('130427', '130400', '磁县', '1', '130427', null, '2', '1'),
('130428', '130400', '肥乡县', '1', '130428', null, '2', '1'),
('130429', '130400', '永年县', '1', '130429', null, '2', '1'),
('130430', '130400', '邱县', '1', '130430', null, '2', '1'),
('130431', '130400', '鸡泽县', '1', '130431', null, '2', '1'),
('130432', '130400', '广平县', '1', '130432', null, '2', '1'),
('130433', '130400', '馆陶县', '1', '130433', null, '2', '1'),
('130434', '130400', '魏县', '1', '130434', null, '2', '1'),
('130435', '130400', '曲周县', '1', '130435', null, '2', '1'),
('130481', '130400', '武安市', '1', '130481', null, '2', '1'),
('130500', '130000', '邢台市', '1', '130500', 'X', '1', '1'),
('130502', '130500', '桥东区', '1', '130502', null, '2', '1'),
('130503', '130500', '桥西区', '1', '130503', null, '2', '1'),
('130521', '130500', '邢台县', '1', '130521', null, '2', '1'),
('130522', '130500', '临城县', '1', '130522', null, '2', '1');
INSERT INTO `wst_areas` VALUES ('130523', '130500', '内邱县', '1', '130523', null, '2', '1'),
('130524', '130500', '柏乡县', '1', '130524', null, '2', '1'),
('130525', '130500', '隆尧县', '1', '130525', null, '2', '1'),
('130526', '130500', '任县', '1', '130526', null, '2', '1'),
('130527', '130500', '南和县', '1', '130527', null, '2', '1'),
('130528', '130500', '宁晋县', '1', '130528', null, '2', '1'),
('130529', '130500', '巨鹿县', '1', '130529', null, '2', '1'),
('130530', '130500', '新河县', '1', '130530', null, '2', '1'),
('130531', '130500', '广宗县', '1', '130531', null, '2', '1'),
('130532', '130500', '平乡县', '1', '130532', null, '2', '1'),
('130533', '130500', '威县', '1', '130533', null, '2', '1'),
('130534', '130500', '清河县', '1', '130534', null, '2', '1'),
('130535', '130500', '临西县', '1', '130535', null, '2', '1'),
('130581', '130500', '南宫市', '1', '130581', null, '2', '1'),
('130582', '130500', '沙河市', '1', '130582', null, '2', '1'),
('130600', '130000', '保定市', '1', '130600', 'B', '1', '1'),
('130602', '130600', '新市区', '1', '130602', null, '2', '1'),
('130603', '130600', '北市区', '1', '130603', null, '2', '1'),
('130604', '130600', '南市区', '1', '130604', null, '2', '1'),
('130621', '130600', '满城县', '1', '130621', null, '2', '1'),
('130622', '130600', '清苑县', '1', '130622', null, '2', '1'),
('130623', '130600', '涞水县', '1', '130623', null, '2', '1'),
('130624', '130600', '阜平县', '1', '130624', null, '2', '1'),
('130625', '130600', '徐水县', '1', '130625', null, '2', '1'),
('130626', '130600', '定兴县', '1', '130626', null, '2', '1'),
('130627', '130600', '唐县', '1', '130627', null, '2', '1'),
('130628', '130600', '高阳县', '1', '130628', null, '2', '1'),
('130629', '130600', '容城县', '1', '130629', null, '2', '1'),
('130630', '130600', '涞源县', '1', '130630', null, '2', '1'),
('130631', '130600', '望都县', '1', '130631', null, '2', '1'),
('130632', '130600', '安新县', '1', '130632', null, '2', '1'),
('130633', '130600', '易县', '1', '130633', null, '2', '1'),
('130634', '130600', '曲阳县', '1', '130634', null, '2', '1'),
('130635', '130600', '蠡县', '1', '130635', null, '2', '1'),
('130636', '130600', '顺平县', '1', '130636', null, '2', '1'),
('130637', '130600', '博野县', '1', '130637', null, '2', '1'),
('130638', '130600', '雄县', '1', '130638', null, '2', '1'),
('130681', '130600', '涿州市', '1', '130681', null, '2', '1'),
('130682', '130600', '定州市', '1', '130682', null, '2', '1'),
('130683', '130600', '安国市', '1', '130683', null, '2', '1'),
('130684', '130600', '高碑店市', '1', '130684', null, '2', '1'),
('130700', '130000', '张家口市', '1', '130700', 'Z', '1', '1'),
('130702', '130700', '桥东区', '1', '130702', null, '2', '1'),
('130703', '130700', '桥西区', '1', '130703', null, '2', '1'),
('130705', '130700', '宣化区', '1', '130705', null, '2', '1'),
('130706', '130700', '下花园区', '1', '130706', null, '2', '1'),
('130721', '130700', '宣化县', '1', '130721', null, '2', '1'),
('130722', '130700', '张北县', '1', '130722', null, '2', '1'),
('130723', '130700', '康保县', '1', '130723', null, '2', '1'),
('130724', '130700', '沽源县', '1', '130724', null, '2', '1'),
('130725', '130700', '尚义县', '1', '130725', null, '2', '1'),
('130726', '130700', '蔚县', '1', '130726', null, '2', '1'),
('130727', '130700', '阳原县', '1', '130727', null, '2', '1'),
('130728', '130700', '怀安县', '1', '130728', null, '2', '1'),
('130729', '130700', '万全县', '1', '130729', null, '2', '1'),
('130730', '130700', '怀来县', '1', '130730', null, '2', '1'),
('130731', '130700', '涿鹿县', '1', '130731', null, '2', '1'),
('130732', '130700', '赤城县', '1', '130732', null, '2', '1'),
('130733', '130700', '崇礼县', '1', '130733', null, '2', '1'),
('130800', '130000', '承德市', '1', '130800', 'C', '1', '1'),
('130802', '130800', '双桥区', '1', '130802', null, '2', '1'),
('130803', '130800', '双滦区', '1', '130803', null, '2', '1'),
('130804', '130800', '鹰手营子矿区', '1', '130804', null, '2', '1'),
('130821', '130800', '承德县', '1', '130821', null, '2', '1'),
('130822', '130800', '兴隆县', '1', '130822', null, '2', '1'),
('130823', '130800', '平泉县', '1', '130823', null, '2', '1'),
('130824', '130800', '滦平县', '1', '130824', null, '2', '1'),
('130825', '130800', '隆化县', '1', '130825', null, '2', '1'),
('130826', '130800', '丰宁满族自治县', '1', '130826', null, '2', '1'),
('130827', '130800', '宽城满族自治县', '1', '130827', null, '2', '1'),
('130828', '130800', '围场满族蒙古族自治县', '1', '130828', null, '2', '1'),
('130900', '130000', '沧州市', '1', '130900', 'C', '1', '1'),
('130902', '130900', '新华区', '1', '130902', null, '2', '1'),
('130903', '130900', '运河区', '1', '130903', null, '2', '1'),
('130921', '130900', '沧县', '1', '130921', null, '2', '1'),
('130922', '130900', '青县', '1', '130922', null, '2', '1'),
('130923', '130900', '东光县', '1', '130923', null, '2', '1'),
('130924', '130900', '海兴县', '1', '130924', null, '2', '1'),
('130925', '130900', '盐山县', '1', '130925', null, '2', '1'),
('130926', '130900', '肃宁县', '1', '130926', null, '2', '1'),
('130927', '130900', '南皮县', '1', '130927', null, '2', '1'),
('130928', '130900', '吴桥县', '1', '130928', null, '2', '1'),
('130929', '130900', '献县', '1', '130929', null, '2', '1'),
('130930', '130900', '孟村回族自治县', '1', '130930', null, '2', '1'),
('130981', '130900', '泊头市', '1', '130981', null, '2', '1'),
('130982', '130900', '任邱市', '1', '130982', null, '2', '1'),
('130983', '130900', '黄骅市', '1', '130983', null, '2', '1'),
('130984', '130900', '河间市', '1', '130984', null, '2', '1'),
('131000', '130000', '廊坊市', '1', '131000', 'L', '1', '1'),
('131002', '131000', '安次区', '1', '131002', null, '2', '1'),
('131003', '131000', '广阳区', '1', '131003', null, '2', '1'),
('131022', '131000', '固安县', '1', '131022', null, '2', '1'),
('131023', '131000', '永清县', '1', '131023', null, '2', '1'),
('131024', '131000', '香河县', '1', '131024', null, '2', '1'),
('131025', '131000', '大城县', '1', '131025', null, '2', '1'),
('131026', '131000', '文安县', '1', '131026', null, '2', '1'),
('131028', '131000', '大厂回族自治县', '1', '131028', null, '2', '1'),
('131081', '131000', '霸州市', '1', '131081', null, '2', '1'),
('131082', '131000', '三河市', '1', '131082', null, '2', '1'),
('131100', '130000', '衡水市', '1', '131100', 'H', '1', '1'),
('131102', '131100', '桃城区', '1', '131102', null, '2', '1');
INSERT INTO `wst_areas` VALUES ('131121', '131100', '枣强县', '1', '131121', null, '2', '1'),
('131122', '131100', '武邑县', '1', '131122', null, '2', '1'),
('131123', '131100', '武强县', '1', '131123', null, '2', '1'),
('131124', '131100', '饶阳县', '1', '131124', null, '2', '1'),
('131125', '131100', '安平县', '1', '131125', null, '2', '1'),
('131126', '131100', '故城县', '1', '131126', null, '2', '1'),
('131127', '131100', '景县', '1', '131127', null, '2', '1'),
('131128', '131100', '阜城县', '1', '131128', null, '2', '1'),
('131181', '131100', '冀州市', '1', '131181', null, '2', '1'),
('131182', '131100', '深州市', '1', '131182', null, '2', '1'),
('140000', '0', '山西', '1', '140000', 'S', '0', '1'),
('140100', '140000', '太原市', '1', '140100', 'T', '1', '1'),
('140105', '140100', '小店区(人口含高新经济区)', '1', '140105', null, '2', '1'),
('140106', '140100', '迎泽区', '1', '140106', null, '2', '1'),
('140107', '140100', '杏花岭区', '1', '140107', null, '2', '1'),
('140108', '140100', '尖草坪区', '1', '140108', null, '2', '1'),
('140109', '140100', '万柏林区', '1', '140109', null, '2', '1'),
('140110', '140100', '晋源区', '1', '140110', null, '2', '1'),
('140121', '140100', '清徐县', '1', '140121', null, '2', '1'),
('140122', '140100', '阳曲县', '1', '140122', null, '2', '1'),
('140123', '140100', '娄烦县', '1', '140123', null, '2', '1'),
('140181', '140100', '古交市', '1', '140181', null, '2', '1'),
('140200', '140000', '大同市', '1', '140200', 'D', '1', '1'),
('140202', '140200', '大同市城区', '1', '140202', null, '2', '1'),
('140203', '140200', '矿区', '1', '140203', null, '2', '1'),
('140211', '140200', '南郊区', '1', '140211', null, '2', '1'),
('140212', '140200', '新荣区', '1', '140212', null, '2', '1'),
('140221', '140200', '阳高县', '1', '140221', null, '2', '1'),
('140222', '140200', '天镇县', '1', '140222', null, '2', '1'),
('140223', '140200', '广灵县', '1', '140223', null, '2', '1'),
('140224', '140200', '灵丘县', '1', '140224', null, '2', '1'),
('140225', '140200', '浑源县', '1', '140225', null, '2', '1'),
('140226', '140200', '左云县', '1', '140226', null, '2', '1'),
('140227', '140200', '大同县', '1', '140227', null, '2', '1'),
('140300', '140000', '阳泉市', '1', '140300', 'Y', '1', '1'),
('140302', '140300', '城区', '1', '140302', null, '2', '1'),
('140303', '140300', '矿区', '1', '140303', null, '2', '1'),
('140311', '140300', '郊区', '1', '140311', null, '2', '1'),
('140321', '140300', '平定县', '1', '140321', null, '2', '1'),
('140322', '140300', '盂县', '1', '140322', null, '2', '1'),
('140400', '140000', '长治市', '1', '140400', 'C', '1', '1'),
('140402', '140400', '长治市城区', '1', '140402', null, '2', '1'),
('140411', '140400', '长治市郊区', '1', '140411', null, '2', '1'),
('140421', '140400', '长治县', '1', '140421', null, '2', '1'),
('140423', '140400', '襄垣县', '1', '140423', null, '2', '1'),
('140424', '140400', '屯留县', '1', '140424', null, '2', '1'),
('140425', '140400', '平顺县', '1', '140425', null, '2', '1'),
('140426', '140400', '黎城县', '1', '140426', null, '2', '1'),
('140427', '140400', '壶关县', '1', '140427', null, '2', '1'),
('140428', '140400', '长子县', '1', '140428', null, '2', '1'),
('140429', '140400', '武乡县', '1', '140429', null, '2', '1'),
('140430', '140400', '沁县', '1', '140430', null, '2', '1'),
('140431', '140400', '沁源县', '1', '140431', null, '2', '1'),
('140481', '140400', '潞城市', '1', '140481', null, '2', '1'),
('140500', '140000', '晋城市', '1', '140500', 'J', '1', '1'),
('140502', '140500', '晋城市城区', '1', '140502', null, '2', '1'),
('140521', '140500', '沁水县', '1', '140521', null, '2', '1'),
('140522', '140500', '阳城县', '1', '140522', null, '2', '1'),
('140524', '140500', '陵川县', '1', '140524', null, '2', '1'),
('140525', '140500', '泽州县', '1', '140525', null, '2', '1'),
('140581', '140500', '高平市', '1', '140581', null, '2', '1'),
('140600', '140000', '朔州市', '1', '140600', 'S', '1', '1'),
('140602', '140600', '朔城区', '1', '140602', null, '2', '1'),
('140603', '140600', '平鲁区', '1', '140603', null, '2', '1'),
('140621', '140600', '山阴县', '1', '140621', null, '2', '1'),
('140622', '140600', '应县', '1', '140622', null, '2', '1'),
('140623', '140600', '右玉县', '1', '140623', null, '2', '1'),
('140624', '140600', '怀仁县', '1', '140624', null, '2', '1'),
('140700', '140000', '晋中市', '1', '140700', 'J', '1', '1'),
('140702', '140700', '榆次区', '1', '140702', null, '2', '1'),
('140721', '140700', '榆社县', '1', '140721', null, '2', '1'),
('140722', '140700', '左权县', '1', '140722', null, '2', '1'),
('140723', '140700', '和顺县', '1', '140723', null, '2', '1'),
('140724', '140700', '昔阳县', '1', '140724', null, '2', '1'),
('140725', '140700', '寿阳县', '1', '140725', null, '2', '1'),
('140726', '140700', '太谷县', '1', '140726', null, '2', '1'),
('140727', '140700', '祁县', '1', '140727', null, '2', '1'),
('140728', '140700', '平遥县', '1', '140728', null, '2', '1'),
('140729', '140700', '灵石县', '1', '140729', null, '2', '1'),
('140781', '140700', '介休市', '1', '140781', null, '2', '1'),
('140800', '140000', '运城市', '1', '140800', 'Y', '1', '1'),
('140802', '140800', '盐湖区', '1', '140802', null, '2', '1'),
('140821', '140800', '临猗县', '1', '140821', null, '2', '1'),
('140822', '140800', '万荣县', '1', '140822', null, '2', '1'),
('140823', '140800', '闻喜县', '1', '140823', null, '2', '1'),
('140824', '140800', '稷山县', '1', '140824', null, '2', '1'),
('140825', '140800', '新绛县', '1', '140825', null, '2', '1'),
('140826', '140800', '绛县', '1', '140826', null, '2', '1'),
('140827', '140800', '垣曲县', '1', '140827', null, '2', '1'),
('140828', '140800', '夏县', '1', '140828', null, '2', '1'),
('140829', '140800', '平陆县', '1', '140829', null, '2', '1'),
('140830', '140800', '芮城县', '1', '140830', null, '2', '1'),
('140881', '140800', '永济市', '1', '140881', null, '2', '1'),
('140882', '140800', '河津市', '1', '140882', null, '2', '1'),
('140900', '140000', '忻州市', '1', '140900', 'X', '1', '1'),
('140902', '140900', '忻府区', '1', '140902', null, '2', '1'),
('140921', '140900', '定襄县', '1', '140921', null, '2', '1'),
('140922', '140900', '五台县', '1', '140922', null, '2', '1'),
('140923', '140900', '代县', '1', '140923', null, '2', '1'),
('140924', '140900', '繁峙县', '1', '140924', null, '2', '1');
INSERT INTO `wst_areas` VALUES ('140925', '140900', '宁武县', '1', '140925', null, '2', '1'),
('140926', '140900', '静乐县', '1', '140926', null, '2', '1'),
('140927', '140900', '神池县', '1', '140927', null, '2', '1'),
('140928', '140900', '五寨县', '1', '140928', null, '2', '1'),
('140929', '140900', '岢岚县', '1', '140929', null, '2', '1'),
('140930', '140900', '河曲县', '1', '140930', null, '2', '1'),
('140931', '140900', '保德县', '1', '140931', null, '2', '1'),
('140932', '140900', '偏关县', '1', '140932', null, '2', '1'),
('140981', '140900', '原平市', '1', '140981', null, '2', '1'),
('141000', '140000', '临汾市', '1', '141000', 'L', '1', '1'),
('141002', '141000', '尧都区', '1', '141002', null, '2', '1'),
('141021', '141000', '曲沃县', '1', '141021', null, '2', '1'),
('141022', '141000', '翼城县', '1', '141022', null, '2', '1'),
('141023', '141000', '襄汾县', '1', '141023', null, '2', '1'),
('141024', '141000', '洪洞县', '1', '141024', null, '2', '1'),
('141025', '141000', '古县', '1', '141025', null, '2', '1'),
('141026', '141000', '安泽县', '1', '141026', null, '2', '1'),
('141027', '141000', '浮山县', '1', '141027', null, '2', '1'),
('141028', '141000', '吉县', '1', '141028', null, '2', '1'),
('141029', '141000', '乡宁县', '1', '141029', null, '2', '1'),
('141030', '141000', '大宁县', '1', '141030', null, '2', '1'),
('141031', '141000', '隰县', '1', '141031', null, '2', '1'),
('141032', '141000', '永和县', '1', '141032', null, '2', '1'),
('141033', '141000', '蒲县', '1', '141033', null, '2', '1'),
('141034', '141000', '汾西县', '1', '141034', null, '2', '1'),
('141081', '141000', '侯马市', '1', '141081', null, '2', '1'),
('141082', '141000', '霍州市', '1', '141082', null, '2', '1'),
('141100', '140000', '吕梁市', '1', '141100', 'L', '1', '1'),
('141102', '141100', '离石区', '1', '141102', null, '2', '1'),
('141121', '141100', '文水县', '1', '141121', null, '2', '1'),
('141122', '141100', '交城县', '1', '141122', null, '2', '1'),
('141123', '141100', '兴县', '1', '141123', null, '2', '1'),
('141124', '141100', '临县', '1', '141124', null, '2', '1'),
('141125', '141100', '柳林县', '1', '141125', null, '2', '1'),
('141126', '141100', '石楼县', '1', '141126', null, '2', '1'),
('141127', '141100', '岚县', '1', '141127', null, '2', '1'),
('141128', '141100', '方山县', '1', '141128', null, '2', '1'),
('141129', '141100', '中阳县', '1', '141129', null, '2', '1'),
('141130', '141100', '交口县', '1', '141130', null, '2', '1'),
('141181', '141100', '孝义市', '1', '141181', null, '2', '1'),
('141182', '141100', '汾阳市', '1', '141182', null, '2', '1'),
('150000', '0', '内蒙古自治区', '1', '150000', 'N', '0', '1'),
('150100', '150000', '呼和浩特市', '1', '150100', 'H', '1', '1'),
('150102', '150100', '新城区', '1', '150102', null, '2', '1'),
('150103', '150100', '回民区', '1', '150103', null, '2', '1'),
('150104', '150100', '玉泉区', '1', '150104', null, '2', '1'),
('150105', '150100', '赛罕区', '1', '150105', null, '2', '1'),
('150121', '150100', '土左旗', '1', '150121', null, '2', '1'),
('150122', '150100', '托克托县', '1', '150122', null, '2', '1'),
('150123', '150100', '和林格尔县', '1', '150123', null, '2', '1'),
('150124', '150100', '清水河县', '1', '150124', null, '2', '1'),
('150125', '150100', '武川县', '1', '150125', null, '2', '1'),
('150200', '150000', '包头市', '1', '150200', 'B', '1', '1'),
('150202', '150200', '东河区', '1', '150202', null, '2', '1'),
('150203', '150200', '昆都仑区', '1', '150203', null, '2', '1'),
('150204', '150200', '青山区', '1', '150204', null, '2', '1'),
('150205', '150200', '石拐区', '1', '150205', null, '2', '1'),
('150206', '150200', '白云鄂博矿区', '1', '150206', null, '2', '1'),
('150207', '150200', '九原区', '1', '150207', null, '2', '1'),
('150221', '150200', '土默特右旗', '1', '150221', null, '2', '1'),
('150222', '150200', '固阳县', '1', '150222', null, '2', '1'),
('150223', '150200', '达茂联合旗', '1', '150223', null, '2', '1'),
('150300', '150000', '乌海市', '1', '150300', 'W', '1', '1'),
('150301', '150300', '乌海市辖区', '1', '150301', null, '2', '1'),
('150302', '150300', '海勃湾区', '1', '150302', null, '2', '1'),
('150303', '150300', '海南区', '1', '150303', null, '2', '1'),
('150304', '150300', '乌达区', '1', '150304', null, '2', '1'),
('150400', '150000', '赤峰市', '1', '150400', 'C', '1', '1'),
('150402', '150400', '红山区', '1', '150402', null, '2', '1'),
('150403', '150400', '元宝山区', '1', '150403', null, '2', '1'),
('150404', '150400', '松山区', '1', '150404', null, '2', '1'),
('150421', '150400', '阿鲁科尔沁旗', '1', '150421', null, '2', '1'),
('150422', '150400', '巴林左旗', '1', '150422', null, '2', '1'),
('150423', '150400', '巴林右旗', '1', '150423', null, '2', '1'),
('150424', '150400', '林西县', '1', '150424', null, '2', '1'),
('150425', '150400', '克什克腾旗', '1', '150425', null, '2', '1'),
('150426', '150400', '翁牛特旗', '1', '150426', null, '2', '1'),
('150428', '150400', '喀喇沁旗', '1', '150428', null, '2', '1'),
('150429', '150400', '宁城县', '1', '150429', null, '2', '1'),
('150430', '150400', '敖汉旗', '1', '150430', null, '2', '1'),
('150500', '150000', '通辽市', '1', '150500', 'T', '1', '1'),
('150502', '150500', '科尔沁区', '1', '150502', null, '2', '1'),
('150521', '150500', '科尔沁左翼中旗', '1', '150521', null, '2', '1'),
('150522', '150500', '科左后旗', '1', '150522', null, '2', '1'),
('150523', '150500', '开鲁县', '1', '150523', null, '2', '1'),
('150524', '150500', '库伦旗', '1', '150524', null, '2', '1'),
('150525', '150500', '奈曼旗', '1', '150525', null, '2', '1'),
('150526', '150500', '扎鲁特旗', '1', '150526', null, '2', '1'),
('150581', '150500', '霍林郭勒市', '1', '150581', null, '2', '1'),
('150600', '150000', '鄂尔多斯市', '1', '150600', 'E', '1', '1'),
('150602', '150600', '东胜区', '1', '150602', null, '2', '1'),
('150621', '150600', '达拉特旗', '1', '150621', null, '2', '1'),
('150622', '150600', '准格尔旗', '1', '150622', null, '2', '1'),
('150623', '150600', '鄂托克前旗', '1', '150623', null, '2', '1'),
('150624', '150600', '鄂托克旗', '1', '150624', null, '2', '1'),
('150625', '150600', '杭锦旗', '1', '150625', null, '2', '1'),
('150626', '150600', '乌审旗', '1', '150626', null, '2', '1'),
('150627', '150600', '伊金霍洛旗', '1', '150627', null, '2', '1'),
('150700', '150000', '呼伦贝尔市', '1', '150700', 'H', '1', '1'),
('150702', '150700', '海拉尔区', '1', '150702', null, '2', '1');
INSERT INTO `wst_areas` VALUES ('150721', '150700', '阿荣旗', '1', '150721', null, '2', '1'),
('150722', '150700', '莫力达瓦达斡尔族自治旗', '1', '150722', null, '2', '1'),
('150723', '150700', '鄂伦春自治旗', '1', '150723', null, '2', '1'),
('150724', '150700', '鄂温克族自治旗', '1', '150724', null, '2', '1'),
('150725', '150700', '陈巴尔虎旗镇', '1', '150725', null, '2', '1'),
('150726', '150700', '新巴尔虎左旗', '1', '150726', null, '2', '1'),
('150727', '150700', '新巴尔虎右旗', '1', '150727', null, '2', '1'),
('150781', '150700', '满洲里市', '1', '150781', null, '2', '1'),
('150782', '150700', '牙克石市', '1', '150782', null, '2', '1'),
('150783', '150700', '扎兰屯市', '1', '150783', null, '2', '1'),
('150784', '150700', '额尔古纳市', '1', '150784', null, '2', '1'),
('150785', '150700', '根河市', '1', '150785', null, '2', '1'),
('150800', '150000', '巴彦淖尔市', '1', '150800', 'B', '1', '1'),
('150802', '150800', '临河区', '1', '150802', null, '2', '1'),
('150821', '150800', '五原县', '1', '150821', null, '2', '1'),
('150822', '150800', '磴口县', '1', '150822', null, '2', '1'),
('150823', '150800', '乌拉特前旗', '1', '150823', null, '2', '1'),
('150824', '150800', '乌拉特中旗', '1', '150824', null, '2', '1'),
('150825', '150800', '乌拉特后旗', '1', '150825', null, '2', '1'),
('150826', '150800', '杭锦后旗', '1', '150826', null, '2', '1'),
('150900', '150000', '乌兰察布市', '1', '150900', 'W', '1', '1'),
('150902', '150900', '集宁区', '1', '150902', null, '2', '1'),
('150921', '150900', '卓资县', '1', '150921', null, '2', '1'),
('150922', '150900', '化德县', '1', '150922', null, '2', '1'),
('150923', '150900', '商都县', '1', '150923', null, '2', '1'),
('150924', '150900', '兴和县', '1', '150924', null, '2', '1'),
('150925', '150900', '凉城县', '1', '150925', null, '2', '1'),
('150926', '150900', '察哈尔右翼前旗', '1', '150926', null, '2', '1'),
('150927', '150900', '察右中旗', '1', '150927', null, '2', '1'),
('150928', '150900', '察哈尔右翼后旗', '1', '150928', null, '2', '1'),
('150929', '150900', '四子王旗', '1', '150929', null, '2', '1'),
('150981', '150900', '丰镇市', '1', '150981', null, '2', '1'),
('152200', '150000', '兴安盟', '1', '152200', 'X', '1', '1'),
('152201', '152200', '乌兰浩特市', '1', '152201', null, '2', '1'),
('152202', '152200', '阿尔山市', '1', '152202', null, '2', '1'),
('152221', '152200', '科右前旗', '1', '152221', null, '2', '1'),
('152222', '152200', '科右中旗', '1', '152222', null, '2', '1'),
('152223', '152200', '扎赉特旗', '1', '152223', null, '2', '1'),
('152224', '152200', '突泉县', '1', '152224', null, '2', '1'),
('152500', '150000', '锡林郭勒盟', '1', '152500', 'X', '1', '1'),
('152501', '152500', '二连浩特市', '1', '152501', null, '2', '1'),
('152502', '152500', '锡林浩特市', '1', '152502', null, '2', '1'),
('152522', '152500', '阿巴嘎旗', '1', '152522', null, '2', '1'),
('152523', '152500', '苏尼特左旗', '1', '152523', null, '2', '1'),
('152524', '152500', '苏尼特右旗', '1', '152524', null, '2', '1'),
('152525', '152500', '东乌珠穆沁旗', '1', '152525', null, '2', '1'),
('152526', '152500', '西乌珠穆沁旗', '1', '152526', null, '2', '1'),
('152527', '152500', '太仆寺旗', '1', '152527', null, '2', '1'),
('152528', '152500', '镶黄旗', '1', '152528', null, '2', '1'),
('152529', '152500', '正镶白旗', '1', '152529', null, '2', '1'),
('152530', '152500', '正蓝旗', '1', '152530', null, '2', '1'),
('152531', '152500', '多伦县', '1', '152531', null, '2', '1'),
('152900', '150000', '阿拉善盟', '1', '152900', 'A', '1', '1'),
('152921', '152900', '阿拉善左旗', '1', '152921', null, '2', '1'),
('152922', '152900', '阿拉善右旗', '1', '152922', null, '2', '1'),
('152923', '152900', '额济纳旗', '1', '152923', null, '2', '1'),
('210000', '0', '辽宁省', '1', '210000', 'L', '0', '1'),
('210100', '210000', '沈阳市', '1', '210100', 'S', '1', '1'),
('210102', '210100', '和平区', '1', '210102', null, '2', '1'),
('210103', '210100', '沈河区', '1', '210103', null, '2', '1'),
('210104', '210100', '大东区', '1', '210104', null, '2', '1'),
('210105', '210100', '皇姑区', '1', '210105', null, '2', '1'),
('210106', '210100', '铁西区', '1', '210106', null, '2', '1'),
('210111', '210100', '苏家屯区', '1', '210111', null, '2', '1'),
('210112', '210100', '东陵区', '1', '210112', null, '2', '1'),
('210113', '210100', '新城子区', '1', '210113', null, '2', '1'),
('210114', '210100', '于洪区', '1', '210114', null, '2', '1'),
('210122', '210100', '辽中县', '1', '210122', null, '2', '1'),
('210123', '210100', '康平县', '1', '210123', null, '2', '1'),
('210124', '210100', '法库县', '1', '210124', null, '2', '1'),
('210181', '210100', '新民市', '1', '210181', null, '2', '1'),
('210200', '210000', '大连市', '1', '210200', 'D', '1', '1'),
('210202', '210200', '中山区', '1', '210202', null, '2', '1'),
('210203', '210200', '西岗区', '1', '210203', null, '2', '1'),
('210204', '210200', '沙河口区', '1', '210204', null, '2', '1'),
('210211', '210200', '甘井子区', '1', '210211', null, '2', '1'),
('210212', '210200', '旅顺口区', '1', '210212', null, '2', '1'),
('210213', '210200', '金州区', '1', '210213', null, '2', '1'),
('210224', '210200', '长海县', '1', '210224', null, '2', '1'),
('210281', '210200', '瓦房店市', '1', '210281', null, '2', '1'),
('210282', '210200', '普兰店市', '1', '210282', null, '2', '1'),
('210283', '210200', '庄河市', '1', '210283', null, '2', '1'),
('210300', '210000', '鞍山市', '1', '210300', 'A', '1', '1'),
('210302', '210300', '铁东区', '1', '210302', null, '2', '1'),
('210303', '210300', '铁西区', '1', '210303', null, '2', '1'),
('210304', '210300', '立山区', '1', '210304', null, '2', '1'),
('210311', '210300', '千山区', '1', '210311', null, '2', '1'),
('210321', '210300', '台安县', '1', '210321', null, '2', '1'),
('210323', '210300', '岫岩县', '1', '210323', null, '2', '1'),
('210381', '210300', '海城市', '1', '210381', null, '2', '1'),
('210400', '210000', '抚顺市', '1', '210400', 'F', '1', '1'),
('210402', '210400', '新抚区', '1', '210402', null, '2', '1'),
('210403', '210400', '东洲区', '1', '210403', null, '2', '1'),
('210404', '210400', '望花区', '1', '210404', null, '2', '1'),
('210411', '210400', '顺城区', '1', '210411', null, '2', '1'),
('210421', '210400', '抚顺县', '1', '210421', null, '2', '1'),
('210422', '210400', '新宾满族自治县', '1', '210422', null, '2', '1'),
('210423', '210400', '清原满族自治县', '1', '210423', null, '2', '1'),
('210500', '210000', '本溪市', '1', '210500', 'B', '1', '1'),
('210502', '210500', '平山区', '1', '210502', null, '2', '1');
INSERT INTO `wst_areas` VALUES ('210503', '210500', '溪湖区', '1', '210503', null, '2', '1'),
('210504', '210500', '明山区', '1', '210504', null, '2', '1'),
('210505', '210500', '南芬区', '1', '210505', null, '2', '1'),
('210521', '210500', '本溪满族自治县', '1', '210521', null, '2', '1'),
('210522', '210500', '桓仁满族自治县', '1', '210522', null, '2', '1'),
('210600', '210000', '丹东市', '1', '210600', 'D', '1', '1'),
('210602', '210600', '元宝区', '1', '210602', null, '2', '1'),
('210603', '210600', '振兴区', '1', '210603', null, '2', '1'),
('210604', '210600', '振安区', '1', '210604', null, '2', '1'),
('210624', '210600', '宽甸满族自治县', '1', '210624', null, '2', '1'),
('210681', '210600', '东港市', '1', '210681', null, '2', '1'),
('210682', '210600', '凤城市', '1', '210682', null, '2', '1'),
('210700', '210000', '锦州市', '1', '210700', 'J', '1', '1'),
('210702', '210700', '古塔区', '1', '210702', null, '2', '1'),
('210703', '210700', '凌河区', '1', '210703', null, '2', '1'),
('210711', '210700', '太和区', '1', '210711', null, '2', '1'),
('210726', '210700', '黑山县', '1', '210726', null, '2', '1'),
('210727', '210700', '义县', '1', '210727', null, '2', '1'),
('210781', '210700', '凌海市', '1', '210781', null, '2', '1'),
('210782', '210700', '北镇市', '1', '210782', null, '2', '1');
INSERT INTO `wst_areas` VALUES ('210800', '210000', '营口市', '1', '210800', 'Y', '1', '1'),
('210802', '210800', '站前区', '1', '210802', null, '2', '1'),
('210803', '210800', '西市区', '1', '210803', null, '2', '1'),
('210804', '210800', '鲅鱼圈区', '1', '210804', null, '2', '1'),
('210811', '210800', '老边区', '1', '210811', null, '2', '1'),
('210881', '210800', '盖州市', '1', '210881', null, '2', '1'),
('210882', '210800', '大石桥市', '1', '210882', null, '2', '1'),
('210900', '210000', '阜新市', '1', '210900', 'F', '1', '1'),
('210902', '210900', '海州区', '1', '210902', null, '2', '1'),
('210903', '210900', '新邱区', '1', '210903', null, '2', '1'),
('210904', '210900', '太平区', '1', '210904', null, '2', '1'),
('210905', '210900', '清河门区', '1', '210905', null, '2', '1'),
('210911', '210900', '细河区', '1', '210911', null, '2', '1'),
('210921', '210900', '阜新蒙古族自治县', '1', '210921', null, '2', '1'),
('210922', '210900', '彰武县', '1', '210922', null, '2', '1'),
('211000', '210000', '辽阳市', '1', '211000', 'L', '1', '1'),
('211002', '211000', '白塔区', '1', '211002', null, '2', '1'),
('211003', '211000', '文圣区', '1', '211003', null, '2', '1'),
('211004', '211000', '宏伟区', '1', '211004', null, '2', '1'),
('211005', '211000', '弓长岭区', '1', '211005', null, '2', '1'),
('211011', '211000', '太子河区', '1', '211011', null, '2', '1'),
('211021', '211000', '辽阳县', '1', '211021', null, '2', '1'),
('211081', '211000', '灯塔市', '1', '211081', null, '2', '1'),
('211100', '210000', '盘锦市', '1', '211100', 'P', '1', '1'),
('211102', '211100', '双台子区', '1', '211102', null, '2', '1'),
('211103', '211100', '兴隆台区', '1', '211103', null, '2', '1'),
('211121', '211100', '大洼县', '1', '211121', null, '2', '1'),
('211122', '211100', '盘山县', '1', '211122', null, '2', '1'),
('211200', '210000', '铁岭市', '1', '211200', 'T', '1', '1'),
('211202', '211200', '银州区', '1', '211202', null, '2', '1'),
('211204', '211200', '清河区', '1', '211204', null, '2', '1'),
('211221', '211200', '铁岭县', '1', '211221', null, '2', '1'),
('211223', '211200', '西丰县', '1', '211223', null, '2', '1'),
('211224', '211200', '昌图县', '1', '211224', null, '2', '1'),
('211281', '211200', '调兵山市', '1', '211281', null, '2', '1'),
('211282', '211200', '开原市', '1', '211282', null, '2', '1'),
('211300', '210000', '朝阳市', '1', '211300', 'C', '1', '1'),
('211302', '211300', '双塔区', '1', '211302', null, '2', '1'),
('211303', '211300', '龙城区', '1', '211303', null, '2', '1'),
('211321', '211300', '朝阳县', '1', '211321', null, '2', '1'),
('211322', '211300', '建平县', '1', '211322', null, '2', '1'),
('211324', '211300', '喀喇沁左翼蒙古族自治县', '1', '211324', null, '2', '1'),
('211381', '211300', '北票市', '1', '211381', null, '2', '1'),
('211382', '211300', '凌源市', '1', '211382', null, '2', '1'),
('211400', '210000', '葫芦岛市', '1', '211400', 'H', '1', '1'),
('211402', '211400', '连山区', '1', '211402', null, '2', '1'),
('211403', '211400', '龙港区', '1', '211403', null, '2', '1'),
('211404', '211400', '南票区', '1', '211404', null, '2', '1'),
('211421', '211400', '绥中县', '1', '211421', null, '2', '1'),
('211422', '211400', '建昌县', '1', '211422', null, '2', '1'),
('211481', '211400', '兴城市', '1', '211481', null, '2', '1'),
('220000', '0', '吉林省', '1', '220000', 'J', '0', '1'),
('220100', '220000', '长春市', '1', '220100', 'C', '1', '1'),
('220101', '220100', '长春市辖区', '1', '220101', null, '2', '1'),
('220102', '220100', '南关区', '1', '220102', null, '2', '1'),
('220103', '220100', '宽城区', '1', '220103', null, '2', '1'),
('220104', '220100', '朝阳区', '1', '220104', null, '2', '1'),
('220105', '220100', '二道区', '1', '220105', null, '2', '1'),
('220106', '220100', '绿园区', '1', '220106', null, '2', '1'),
('220112', '220100', '双阳区', '1', '220112', null, '2', '1'),
('220122', '220100', '农安县', '1', '220122', null, '2', '1'),
('220181', '220100', '九台市', '1', '220181', null, '2', '1'),
('220182', '220100', '榆树市', '1', '220182', null, '2', '1'),
('220183', '220100', '德惠市', '1', '220183', null, '2', '1'),
('220200', '220000', '吉林市', '1', '220200', 'J', '1', '1'),
('220201', '220200', '吉林市辖区', '1', '220201', null, '2', '1'),
('220202', '220200', '昌邑区', '1', '220202', null, '2', '1'),
('220203', '220200', '龙潭区', '1', '220203', null, '2', '1'),
('220204', '220200', '船营区', '1', '220204', null, '2', '1'),
('220211', '220200', '丰满区', '1', '220211', null, '2', '1'),
('220221', '220200', '永吉县', '1', '220221', null, '2', '1'),
('220281', '220200', '蛟河市', '1', '220281', null, '2', '1'),
('220282', '220200', '桦甸市', '1', '220282', null, '2', '1'),
('220283', '220200', '舒兰市', '1', '220283', null, '2', '1'),
('220284', '220200', '磐石市', '1', '220284', null, '2', '1'),
('220300', '220000', '四平市', '1', '220300', 'S', '1', '1'),
('220301', '220300', '四平市辖区', '1', '220301', null, '2', '1'),
('220302', '220300', '铁西区', '1', '220302', null, '2', '1'),
('220303', '220300', '铁东区', '1', '220303', null, '2', '1'),
('220322', '220300', '梨树县', '1', '220322', null, '2', '1');
INSERT INTO `wst_areas` VALUES ('220323', '220300', '伊通满族自治县', '1', '220323', null, '2', '1'),
('220381', '220300', '公主岭市', '1', '220381', null, '2', '1'),
('220382', '220300', '双辽市', '1', '220382', null, '2', '1'),
('220400', '220000', '辽源市', '1', '220400', 'L', '1', '1'),
('220401', '220400', '辽源市辖区', '1', '220401', null, '2', '1'),
('220402', '220400', '龙山区', '1', '220402', null, '2', '1'),
('220403', '220400', '西安区', '1', '220403', null, '2', '1'),
('220421', '220400', '东丰县', '1', '220421', null, '2', '1'),
('220422', '220400', '东辽县', '1', '220422', null, '2', '1'),
('220500', '220000', '通化市', '1', '220500', 'T', '1', '1'),
('220501', '220500', '通化市辖区', '1', '220501', null, '2', '1'),
('220502', '220500', '东昌区', '1', '220502', null, '2', '1'),
('220503', '220500', '二道江区', '1', '220503', null, '2', '1'),
('220521', '220500', '通化县', '1', '220521', null, '2', '1'),
('220523', '220500', '辉南县', '1', '220523', null, '2', '1'),
('220524', '220500', '柳河县', '1', '220524', null, '2', '1'),
('220581', '220500', '梅河口市', '1', '220581', null, '2', '1'),
('220582', '220500', '集安市', '1', '220582', null, '2', '1'),
('220600', '220000', '白山市', '1', '220600', 'B', '1', '1'),
('220601', '220600', '白山市辖区', '1', '220601', null, '2', '1'),
('220602', '220600', '八道江区', '1', '220602', null, '2', '1'),
('220604', '220600', '江源区', '1', '220604', null, '2', '1'),
('220621', '220600', '抚松县', '1', '220621', null, '2', '1'),
('220622', '220600', '靖宇县', '1', '220622', null, '2', '1'),
('220623', '220600', '长白朝鲜族自治县', '1', '220623', null, '2', '1'),
('220681', '220600', '临江市', '1', '220681', null, '2', '1'),
('220700', '220000', '松原市', '1', '220700', 'S', '1', '1'),
('220701', '220700', '松原市辖区', '1', '220701', null, '2', '1'),
('220702', '220700', '宁江区', '1', '220702', null, '2', '1'),
('220721', '220700', '前郭尔罗斯蒙古族自治县', '1', '220721', null, '2', '1'),
('220722', '220700', '长岭县', '1', '220722', null, '2', '1'),
('220723', '220700', '乾安县', '1', '220723', null, '2', '1'),
('220724', '220700', '扶余县', '1', '220724', null, '2', '1'),
('220800', '220000', '白城市', '1', '220800', 'B', '1', '1'),
('220801', '220800', '白城市辖区', '1', '220801', null, '2', '1'),
('220802', '220800', '洮北区', '1', '220802', null, '2', '1'),
('220821', '220800', '镇赉县', '1', '220821', null, '2', '1'),
('220822', '220800', '通榆县', '1', '220822', null, '2', '1'),
('220881', '220800', '洮南市', '1', '220881', null, '2', '1'),
('220882', '220800', '大安市', '1', '220882', null, '2', '1'),
('222400', '220000', '延边朝鲜族自治州', '1', '222400', 'Y', '1', '1'),
('222401', '222400', '延吉市', '1', '222401', null, '2', '1'),
('222402', '222400', '图们市', '1', '222402', null, '2', '1'),
('222403', '222400', '敦化市', '1', '222403', null, '2', '1'),
('222404', '222400', '珲春市', '1', '222404', null, '2', '1'),
('222405', '222400', '龙井市', '1', '222405', null, '2', '1'),
('222406', '222400', '和龙市', '1', '222406', null, '2', '1'),
('222424', '222400', '汪清县', '1', '222424', null, '2', '1'),
('222426', '222400', '安图县', '1', '222426', null, '2', '1'),
('230000', '0', '黑龙江省', '1', '230000', 'H', '0', '1'),
('230100', '230000', '哈尔滨市', '1', '230100', 'H', '1', '1'),
('230102', '230100', '道里区', '1', '230102', null, '2', '1'),
('230103', '230100', '南岗区', '1', '230103', null, '2', '1'),
('230104', '230100', '道外区', '1', '230104', null, '2', '1'),
('230108', '230100', '平房区', '1', '230108', null, '2', '1'),
('230109', '230100', '松北区', '1', '230109', null, '2', '1'),
('230110', '230100', '香坊区', '1', '230110', null, '2', '1'),
('230111', '230100', '呼兰区', '1', '230111', null, '2', '1'),
('230112', '230100', '阿城区', '1', '230112', null, '2', '1'),
('230123', '230100', '依兰县', '1', '230123', null, '2', '1'),
('230124', '230100', '方正县', '1', '230124', null, '2', '1'),
('230125', '230100', '宾县', '1', '230125', null, '2', '1'),
('230126', '230100', '巴彦县', '1', '230126', null, '2', '1'),
('230127', '230100', '木兰县', '1', '230127', null, '2', '1'),
('230128', '230100', '通河县', '1', '230128', null, '2', '1'),
('230129', '230100', '延寿县', '1', '230129', null, '2', '1'),
('230182', '230100', '双城市', '1', '230182', null, '2', '1'),
('230183', '230100', '尚志市', '1', '230183', null, '2', '1'),
('230184', '230100', '五常市', '1', '230184', null, '2', '1'),
('230200', '230000', '齐齐哈尔市', '1', '230200', 'Q', '1', '1'),
('230202', '230200', '龙沙区', '1', '230202', null, '2', '1'),
('230203', '230200', '建华区', '1', '230203', null, '2', '1'),
('230204', '230200', '铁锋区', '1', '230204', null, '2', '1'),
('230205', '230200', '昂昂溪区', '1', '230205', null, '2', '1'),
('230206', '230200', '富拉尔基区', '1', '230206', null, '2', '1'),
('230207', '230200', '碾子山区', '1', '230207', null, '2', '1'),
('230208', '230200', '梅里斯达斡尔族区', '1', '230208', null, '2', '1'),
('230221', '230200', '龙江县', '1', '230221', null, '2', '1'),
('230223', '230200', '依安县', '1', '230223', null, '2', '1'),
('230224', '230200', '泰来县', '1', '230224', null, '2', '1'),
('230225', '230200', '甘南县', '1', '230225', null, '2', '1'),
('230227', '230200', '富裕县', '1', '230227', null, '2', '1'),
('230229', '230200', '克山县', '1', '230229', null, '2', '1'),
('230230', '230200', '克东县', '1', '230230', null, '2', '1'),
('230231', '230200', '拜泉县', '1', '230231', null, '2', '1'),
('230281', '230200', '讷河市', '1', '230281', null, '2', '1'),
('230300', '230000', '鸡西市', '1', '230300', 'J', '1', '1'),
('230302', '230300', '鸡冠区', '1', '230302', null, '2', '1'),
('230303', '230300', '恒山区', '1', '230303', null, '2', '1'),
('230304', '230300', '滴道区', '1', '230304', null, '2', '1'),
('230305', '230300', '梨树区', '1', '230305', null, '2', '1'),
('230306', '230300', '城子河区', '1', '230306', null, '2', '1'),
('230307', '230300', '麻山区', '1', '230307', null, '2', '1'),
('230321', '230300', '鸡东县', '1', '230321', null, '2', '1'),
('230381', '230300', '虎林市', '1', '230381', null, '2', '1'),
('230382', '230300', '密山市', '1', '230382', null, '2', '1'),
('230400', '230000', '鹤岗市', '1', '230400', 'H', '1', '1'),
('230402', '230400', '向阳区', '1', '230402', null, '2', '1'),
('230403', '230400', '工农区', '1', '230403', null, '2', '1'),
('230404', '230400', '南山区', '1', '230404', null, '2', '1');
INSERT INTO `wst_areas` VALUES ('230405', '230400', '兴安区', '1', '230405', null, '2', '1'),
('230406', '230400', '东山区', '1', '230406', null, '2', '1'),
('230407', '230400', '兴山区', '1', '230407', null, '2', '1'),
('230421', '230400', '萝北县', '1', '230421', null, '2', '1'),
('230422', '230400', '绥滨县', '1', '230422', null, '2', '1'),
('230500', '230000', '双鸭山市', '1', '230500', 'S', '1', '1'),
('230502', '230500', '尖山区', '1', '230502', null, '2', '1'),
('230503', '230500', '岭东区', '1', '230503', null, '2', '1'),
('230505', '230500', '四方台区', '1', '230505', null, '2', '1'),
('230506', '230500', '宝山区', '1', '230506', null, '2', '1'),
('230521', '230500', '集贤县', '1', '230521', null, '2', '1'),
('230522', '230500', '友谊县', '1', '230522', null, '2', '1'),
('230523', '230500', '宝清县', '1', '230523', null, '2', '1'),
('230524', '230500', '饶河县', '1', '230524', null, '2', '1'),
('230600', '230000', '大庆市', '1', '230600', 'D', '1', '1'),
('230602', '230600', '萨尔图区', '1', '230602', null, '2', '1'),
('230603', '230600', '龙凤区', '1', '230603', null, '2', '1'),
('230604', '230600', '让胡路区', '1', '230604', null, '2', '1'),
('230605', '230600', '红岗区', '1', '230605', null, '2', '1'),
('230606', '230600', '大同区', '1', '230606', null, '2', '1'),
('230621', '230600', '肇州县', '1', '230621', null, '2', '1'),
('230622', '230600', '肇源县', '1', '230622', null, '2', '1'),
('230623', '230600', '林甸县', '1', '230623', null, '2', '1'),
('230624', '230600', '杜尔伯特县', '1', '230624', null, '2', '1'),
('230700', '230000', '伊春市', '1', '230700', 'Y', '1', '1'),
('230702', '230700', '伊春区', '1', '230702', null, '2', '1'),
('230703', '230700', '南岔区', '1', '230703', null, '2', '1'),
('230704', '230700', '友好区', '1', '230704', null, '2', '1'),
('230705', '230700', '西林区', '1', '230705', null, '2', '1'),
('230706', '230700', '翠峦区', '1', '230706', null, '2', '1'),
('230707', '230700', '新青区', '1', '230707', null, '2', '1'),
('230708', '230700', '美溪区', '1', '230708', null, '2', '1'),
('230709', '230700', '金山屯区', '1', '230709', null, '2', '1'),
('230710', '230700', '五营区', '1', '230710', null, '2', '1'),
('230711', '230700', '乌马河区', '1', '230711', null, '2', '1'),
('230712', '230700', '汤旺河区', '1', '230712', null, '2', '1'),
('230713', '230700', '带岭区', '1', '230713', null, '2', '1'),
('230714', '230700', '乌伊岭区', '1', '230714', null, '2', '1'),
('230715', '230700', '红星区', '1', '230715', null, '2', '1'),
('230716', '230700', '上甘岭区', '1', '230716', null, '2', '1'),
('230722', '230700', '嘉荫县', '1', '230722', null, '2', '1'),
('230781', '230700', '铁力市', '1', '230781', null, '2', '1'),
('230800', '230000', '佳木斯市', '1', '230800', 'J', '1', '1'),
('230803', '230800', '向阳区', '1', '230803', null, '2', '1'),
('230804', '230800', '前进区', '1', '230804', null, '2', '1'),
('230805', '230800', '东风区', '1', '230805', null, '2', '1'),
('230811', '230800', '郊区', '1', '230811', null, '2', '1'),
('230822', '230800', '桦南县', '1', '230822', null, '2', '1'),
('230826', '230800', '桦川县', '1', '230826', null, '2', '1'),
('230828', '230800', '汤原县', '1', '230828', null, '2', '1'),
('230833', '230800', '抚远县', '1', '230833', null, '2', '1'),
('230881', '230800', '同江市', '1', '230881', null, '2', '1'),
('230882', '230800', '富锦市', '1', '230882', null, '2', '1'),
('230900', '230000', '七台河市', '1', '230900', 'Q', '1', '1'),
('230902', '230900', '新兴区', '1', '230902', null, '2', '1'),
('230903', '230900', '桃山区', '1', '230903', null, '2', '1'),
('230904', '230900', '茄子河区', '1', '230904', null, '2', '1'),
('230921', '230900', '勃利县', '1', '230921', null, '2', '1'),
('231000', '230000', '牡丹江市', '1', '231000', 'D', '1', '1'),
('231002', '231000', '东安区', '1', '231002', null, '2', '1'),
('231003', '231000', '阳明区', '1', '231003', null, '2', '1'),
('231004', '231000', '爱民区', '1', '231004', null, '2', '1'),
('231005', '231000', '西安区', '1', '231005', null, '2', '1'),
('231024', '231000', '东宁县', '1', '231024', null, '2', '1'),
('231025', '231000', '林口县', '1', '231025', null, '2', '1'),
('231081', '231000', '绥芬河市', '1', '231081', null, '2', '1'),
('231083', '231000', '海林市', '1', '231083', null, '2', '1'),
('231084', '231000', '宁安市', '1', '231084', null, '2', '1'),
('231085', '231000', '穆棱市', '1', '231085', null, '2', '1'),
('231100', '230000', '黑河市', '1', '231100', 'H', '1', '1'),
('231102', '231100', '爱辉区', '1', '231102', null, '2', '1'),
('231121', '231100', '嫩江县', '1', '231121', null, '2', '1'),
('231123', '231100', '逊克县', '1', '231123', null, '2', '1'),
('231124', '231100', '孙吴县', '1', '231124', null, '2', '1'),
('231181', '231100', '北安市', '1', '231181', null, '2', '1'),
('231182', '231100', '五大连池市', '1', '231182', null, '2', '1'),
('231200', '230000', '绥化市', '1', '231200', 'S', '1', '1'),
('231202', '231200', '北林区', '1', '231202', null, '2', '1'),
('231221', '231200', '望奎县', '1', '231221', null, '2', '1'),
('231222', '231200', '兰西县', '1', '231222', null, '2', '1'),
('231223', '231200', '青冈县', '1', '231223', null, '2', '1'),
('231224', '231200', '庆安县', '1', '231224', null, '2', '1'),
('231225', '231200', '明水县', '1', '231225', null, '2', '1'),
('231226', '231200', '绥棱县', '1', '231226', null, '2', '1'),
('231281', '231200', '安达市', '1', '231281', null, '2', '1'),
('231282', '231200', '肇东市', '1', '231282', null, '2', '1'),
('231283', '231200', '海伦市', '1', '231283', null, '2', '1'),
('232700', '230000', '大兴安岭地区', '1', '232700', 'D', '1', '1'),
('232701', '232700', '加格达奇区', '1', '232701', null, '2', '1'),
('232702', '232700', '松岭区', '1', '232702', null, '2', '1'),
('232703', '232700', '新林区', '1', '232703', null, '2', '1'),
('232704', '232700', '呼中区', '1', '232704', null, '2', '1'),
('232721', '232700', '呼玛县', '1', '232721', null, '2', '1'),
('232722', '232700', '塔河县', '1', '232722', null, '2', '1'),
('232723', '232700', '漠河县', '1', '232723', null, '2', '1'),
('310000', '0', '上海市', '1', '310000', 'S', '0', '1'),
('320000', '0', '江苏省', '1', '320000', 'J', '0', '1'),
('320100', '320000', '南京市', '1', '320100', 'N', '1', '1'),
('320102', '320100', '玄武区', '1', '320102', null, '2', '1'),
('320103', '320100', '白下区', '1', '320103', null, '2', '1');
INSERT INTO `wst_areas` VALUES ('320104', '320100', '秦淮区', '1', '320104', null, '2', '1'),
('320105', '320100', '建邺区', '1', '320105', null, '2', '1'),
('320106', '320100', '鼓楼区', '1', '320106', null, '2', '1'),
('320107', '320100', '下关区', '1', '320107', null, '2', '1'),
('320111', '320100', '浦口区', '1', '320111', null, '2', '1'),
('320113', '320100', '栖霞区', '1', '320113', null, '2', '1'),
('320114', '320100', '雨花台区', '1', '320114', null, '2', '1'),
('320115', '320100', '江宁区', '1', '320115', null, '2', '1'),
('320116', '320100', '六合区', '1', '320116', null, '2', '1'),
('320124', '320100', '溧水县', '1', '320124', null, '2', '1'),
('320125', '320100', '高淳县', '1', '320125', null, '2', '1'),
('320200', '320000', '无锡市', '1', '320200', 'W', '1', '1'),
('320202', '320200', '崇安区', '1', '320202', null, '2', '1'),
('320203', '320200', '南长区', '1', '320203', null, '2', '1'),
('320204', '320200', '北塘区', '1', '320204', null, '2', '1'),
('320205', '320200', '锡山区', '1', '320205', null, '2', '1'),
('320206', '320200', '惠山区', '1', '320206', null, '2', '1'),
('320211', '320200', '滨湖区', '1', '320211', null, '2', '1'),
('320281', '320200', '江阴市', '1', '320281', null, '2', '1'),
('320282', '320200', '宜兴市', '1', '320282', null, '2', '1'),
('320300', '320000', '徐州市', '1', '320300', 'X', '1', '1'),
('320302', '320300', '鼓楼区', '1', '320302', null, '2', '1'),
('320303', '320300', '云龙区', '1', '320303', null, '2', '1'),
('320304', '320300', '九里区', '1', '320304', null, '2', '1'),
('320305', '320300', '贾汪区', '1', '320305', null, '2', '1'),
('320311', '320300', '泉山区', '1', '320311', null, '2', '1'),
('320321', '320300', '丰县', '1', '320321', null, '2', '1'),
('320322', '320300', '沛县', '1', '320322', null, '2', '1'),
('320323', '320300', '铜山县', '1', '320323', null, '2', '1'),
('320324', '320300', '睢宁县', '1', '320324', null, '2', '1'),
('320381', '320300', '新沂市', '1', '320381', null, '2', '1'),
('320382', '320300', '邳州市', '1', '320382', null, '2', '1'),
('320400', '320000', '常州市', '1', '320400', 'C', '1', '1'),
('320401', '320400', '常州市区', '1', '320401', null, '2', '1'),
('320402', '320400', '天宁区', '1', '320402', null, '2', '1'),
('320404', '320400', '钟楼区', '1', '320404', null, '2', '1'),
('320405', '320400', '戚墅堰区', '1', '320405', null, '2', '1'),
('320411', '320400', '新北区', '1', '320411', null, '2', '1'),
('320412', '320400', '武进区', '1', '320412', null, '2', '1'),
('320481', '320400', '溧阳市', '1', '320481', null, '2', '1'),
('320482', '320400', '金坛市', '1', '320482', null, '2', '1'),
('320500', '320000', '苏州市', '1', '320500', 'S', '1', '1'),
('320502', '320500', '沧浪区', '1', '320502', null, '2', '1'),
('320503', '320500', '平江区', '1', '320503', null, '2', '1'),
('320504', '320500', '金阊区', '1', '320504', null, '2', '1'),
('320505', '320500', '苏州高新区虎丘区', '1', '320505', null, '2', '1'),
('320506', '320500', '吴中区', '1', '320506', null, '2', '1'),
('320507', '320500', '相城区', '1', '320507', null, '2', '1'),
('320581', '320500', '常熟市', '1', '320581', null, '2', '1'),
('320582', '320500', '张家港市', '1', '320582', null, '2', '1'),
('320583', '320500', '昆山市', '1', '320583', null, '2', '1'),
('320584', '320500', '吴江市', '1', '320584', null, '2', '1'),
('320585', '320500', '太仓市', '1', '320585', null, '2', '1'),
('320600', '320000', '南通市', '1', '320600', 'N', '1', '1'),
('320602', '320600', '崇川区', '1', '320602', null, '2', '1'),
('320611', '320600', '港闸区', '1', '320611', null, '2', '1'),
('320621', '320600', '海安县', '1', '320621', null, '2', '1'),
('320623', '320600', '如东', '1', '320623', null, '2', '1'),
('320681', '320600', '启东市', '1', '320681', null, '2', '1'),
('320682', '320600', '\"如皋市', '1', '320682', null, '2', '1'),
('320683', '320600', '通州市', '1', '320683', null, '2', '1'),
('320684', '320600', '海门市', '1', '320684', null, '2', '1'),
('320700', '320000', '连云港市', '1', '320700', 'L', '1', '1'),
('320703', '320700', '连云区', '1', '320703', null, '2', '1'),
('320705', '320700', '新浦区', '1', '320705', null, '2', '1'),
('320706', '320700', '海州区', '1', '320706', null, '2', '1'),
('320721', '320700', '赣榆县', '1', '320721', null, '2', '1'),
('320722', '320700', '东海县', '1', '320722', null, '2', '1'),
('320723', '320700', '灌云县', '1', '320723', null, '2', '1'),
('320724', '320700', '灌南县', '1', '320724', null, '2', '1'),
('320800', '320000', '淮安市', '1', '320800', 'H', '1', '1'),
('320802', '320800', '清河区', '1', '320802', null, '2', '1'),
('320803', '320800', '楚州区', '1', '320803', null, '2', '1'),
('320804', '320800', '淮阴区', '1', '320804', null, '2', '1'),
('320811', '320800', '清浦区', '1', '320811', null, '2', '1'),
('320826', '320800', '涟水县', '1', '320826', null, '2', '1'),
('320829', '320800', '洪泽县', '1', '320829', null, '2', '1'),
('320830', '320800', '盱眙县', '1', '320830', null, '2', '1'),
('320831', '320800', '金湖县', '1', '320831', null, '2', '1'),
('320900', '320000', '盐城市', '1', '320900', 'Y', '1', '1'),
('320902', '320900', '亭湖区', '1', '320902', null, '2', '1'),
('320903', '320900', '盐都区', '1', '320903', null, '2', '1'),
('320921', '320900', '响水县', '1', '320921', null, '2', '1'),
('320922', '320900', '滨海县', '1', '320922', null, '2', '1'),
('320923', '320900', '阜宁县', '1', '320923', null, '2', '1'),
('320924', '320900', '射阳县', '1', '320924', null, '2', '1'),
('320925', '320900', '建湖县', '1', '320925', null, '2', '1'),
('320981', '320900', '东台市', '1', '320981', null, '2', '1'),
('320982', '320900', '大丰市', '1', '320982', null, '2', '1'),
('321000', '320000', '扬州市', '1', '321000', 'Y', '1', '1'),
('321002', '321000', '广陵区', '1', '321002', null, '2', '1'),
('321003', '321000', '邗江区', '1', '321003', null, '2', '1'),
('321011', '321000', '维扬区', '1', '321011', null, '2', '1'),
('321023', '321000', '宝应县', '1', '321023', null, '2', '1'),
('321081', '321000', '仪征市', '1', '321081', null, '2', '1'),
('321084', '321000', '高邮市', '1', '321084', null, '2', '1'),
('321088', '321000', '江都市', '1', '321088', null, '2', '1'),
('321100', '320000', '镇江市', '1', '321100', 'Z', '1', '1'),
('321101', '321100', '市区', '1', '321101', null, '2', '1'),
('321102', '321100', '京口区', '1', '321102', null, '2', '1');
INSERT INTO `wst_areas` VALUES ('321111', '321100', '润州区', '1', '321111', null, '2', '1'),
('321112', '321100', '丹徒区', '1', '321112', null, '2', '1'),
('321181', '321100', '丹阳市', '1', '321181', null, '2', '1'),
('321182', '321100', '扬中市', '1', '321182', null, '2', '1'),
('321183', '321100', '句容市', '1', '321183', null, '2', '1'),
('321200', '320000', '泰州市', '1', '321200', 'Q', '1', '1'),
('321202', '321200', '海陵区', '1', '321202', null, '2', '1'),
('321203', '321200', '高港区', '1', '321203', null, '2', '1'),
('321281', '321200', '兴化市', '1', '321281', null, '2', '1'),
('321282', '321200', '靖江市', '1', '321282', null, '2', '1'),
('321283', '321200', '泰兴市', '1', '321283', null, '2', '1'),
('321284', '321200', '姜堰市', '1', '321284', null, '2', '1'),
('321300', '320000', '宿迁市', '1', '321300', 'S', '1', '1'),
('321302', '321300', '宿城区', '1', '321302', null, '2', '1'),
('321311', '321300', '宿豫区', '1', '321311', null, '2', '1'),
('321322', '321300', '沭阳县', '1', '321322', null, '2', '1'),
('321323', '321300', '泗阳县', '1', '321323', null, '2', '1'),
('321324', '321300', '泗洪县', '1', '321324', null, '2', '1'),
('330000', '0', '浙江省', '1', '330000', 'J', '0', '1'),
('330100', '330000', '杭州市', '1', '330100', 'H', '1', '1'),
('330102', '330100', '上城区', '1', '330102', null, '2', '1'),
('330103', '330100', '下城区', '1', '330103', null, '2', '1'),
('330104', '330100', '江干区', '1', '330104', null, '2', '1'),
('330105', '330100', '拱墅区', '1', '330105', null, '2', '1'),
('330106', '330100', '西湖区', '1', '330106', null, '2', '1'),
('330108', '330100', '滨江区', '1', '330108', null, '2', '1'),
('330109', '330100', '萧山区', '1', '330109', null, '2', '1'),
('330110', '330100', '余杭区', '1', '330110', null, '2', '1'),
('330122', '330100', '桐庐县', '1', '330122', null, '2', '1'),
('330127', '330100', '淳安县', '1', '330127', null, '2', '1'),
('330182', '330100', '建德市', '1', '330182', null, '2', '1'),
('330183', '330100', '富阳市', '1', '330183', null, '2', '1'),
('330185', '330100', '临安市', '1', '330185', null, '2', '1'),
('330200', '330000', '宁波市', '1', '330200', 'N', '1', '1'),
('330203', '330200', '海曙区', '1', '330203', null, '2', '1'),
('330204', '330200', '江东区', '1', '330204', null, '2', '1'),
('330205', '330200', '江北区', '1', '330205', null, '2', '1'),
('330206', '330200', '北仑区', '1', '330206', null, '2', '1'),
('330211', '330200', '镇海区', '1', '330211', null, '2', '1'),
('330212', '330200', '鄞州区', '1', '330212', null, '2', '1'),
('330225', '330200', '象山县', '1', '330225', null, '2', '1'),
('330226', '330200', '宁海县', '1', '330226', null, '2', '1'),
('330281', '330200', '余姚市', '1', '330281', null, '2', '1'),
('330282', '330200', '慈溪市', '1', '330282', null, '2', '1'),
('330283', '330200', '奉化市', '1', '330283', null, '2', '1'),
('330300', '330000', '温州市', '1', '330300', 'W', '1', '1'),
('330302', '330300', '鹿城区', '1', '330302', null, '2', '1'),
('330303', '330300', '龙湾区', '1', '330303', null, '2', '1'),
('330304', '330300', '瓯海区', '1', '330304', null, '2', '1'),
('330322', '330300', '洞头县', '1', '330322', null, '2', '1'),
('330324', '330300', '永嘉县', '1', '330324', null, '2', '1'),
('330326', '330300', '平阳县', '1', '330326', null, '2', '1'),
('330327', '330300', '苍南县', '1', '330327', null, '2', '1'),
('330328', '330300', '文成县', '1', '330328', null, '2', '1'),
('330329', '330300', '泰顺县', '1', '330329', null, '2', '1'),
('330381', '330300', '瑞安市', '1', '330381', null, '2', '1'),
('330382', '330300', '乐清市', '1', '330382', null, '2', '1'),
('330400', '330000', '嘉兴市', '1', '330400', 'J', '1', '1'),
('330402', '330400', '南湖区', '1', '330402', null, '2', '1'),
('330411', '330400', '秀洲区', '1', '330411', null, '2', '1'),
('330421', '330400', '嘉善县', '1', '330421', null, '2', '1'),
('330424', '330400', '海盐县', '1', '330424', null, '2', '1'),
('330481', '330400', '海宁市', '1', '330481', null, '2', '1'),
('330482', '330400', '平湖市', '1', '330482', null, '2', '1'),
('330483', '330400', '桐乡市', '1', '330483', null, '2', '1'),
('330500', '330000', '湖州市', '1', '330500', 'H', '1', '1'),
('330502', '330500', '吴兴区', '1', '330502', null, '2', '1'),
('330503', '330500', '南浔区', '1', '330503', null, '2', '1'),
('330521', '330500', '德清县', '1', '330521', null, '2', '1'),
('330522', '330500', '长兴县', '1', '330522', null, '2', '1'),
('330523', '330500', '安吉县', '1', '330523', null, '2', '1'),
('330600', '330000', '绍兴市', '1', '330600', 'S', '1', '1'),
('330602', '330600', '越城区', '1', '330602', null, '2', '1'),
('330621', '330600', '绍兴县', '1', '330621', null, '2', '1'),
('330624', '330600', '新昌县', '1', '330624', null, '2', '1'),
('330681', '330600', '诸暨市', '1', '330681', null, '2', '1'),
('330682', '330600', '上虞市', '1', '330682', null, '2', '1'),
('330683', '330600', '嵊州市', '1', '330683', null, '2', '1'),
('330700', '330000', '金华市', '1', '330700', 'J', '1', '1'),
('330702', '330700', '婺城区', '1', '330702', null, '2', '1'),
('330703', '330700', '金东区', '1', '330703', null, '2', '1'),
('330723', '330700', '武义县', '1', '330723', null, '2', '1'),
('330726', '330700', '浦江县', '1', '330726', null, '2', '1'),
('330727', '330700', '磐安县', '1', '330727', null, '2', '1'),
('330781', '330700', '兰溪市', '1', '330781', null, '2', '1'),
('330782', '330700', '义乌市', '1', '330782', null, '2', '1'),
('330783', '330700', '东阳市', '1', '330783', null, '2', '1'),
('330784', '330700', '永康市', '1', '330784', null, '2', '1'),
('330800', '330000', '衢州市', '1', '330800', 'Q', '1', '1'),
('330802', '330800', '柯城区', '1', '330802', null, '2', '1'),
('330803', '330800', '衢江区', '1', '330803', null, '2', '1'),
('330822', '330800', '常山县', '1', '330822', null, '2', '1'),
('330824', '330800', '开化县', '1', '330824', null, '2', '1'),
('330825', '330800', '龙游县', '1', '330825', null, '2', '1'),
('330881', '330800', '江山市', '1', '330881', null, '2', '1'),
('330900', '330000', '舟山市', '1', '330900', 'Z', '1', '1'),
('330902', '330900', '定海区', '1', '330902', null, '2', '1'),
('330903', '330900', '普陀区', '1', '330903', null, '2', '1'),
('330921', '330900', '岱山县', '1', '330921', null, '2', '1'),
('330922', '330900', '嵊泗县', '1', '330922', null, '2', '1');
INSERT INTO `wst_areas` VALUES ('331000', '330000', '台州市', '1', '331000', 'T', '1', '1'),
('331002', '331000', '椒江区', '1', '331002', null, '2', '1'),
('331003', '331000', '黄岩区', '1', '331003', null, '2', '1'),
('331004', '331000', '路桥区', '1', '331004', null, '2', '1'),
('331021', '331000', '玉环县', '1', '331021', null, '2', '1'),
('331022', '331000', '三门县', '1', '331022', null, '2', '1'),
('331023', '331000', '天台县', '1', '331023', null, '2', '1'),
('331024', '331000', '仙居县', '1', '331024', null, '2', '1'),
('331081', '331000', '温岭市', '1', '331081', null, '2', '1'),
('331082', '331000', '临海市', '1', '331082', null, '2', '1'),
('331100', '330000', '丽水市', '1', '331100', 'L', '1', '1'),
('331102', '331100', '莲都区', '1', '331102', null, '2', '1'),
('331121', '331100', '青田县', '1', '331121', null, '2', '1'),
('331122', '331100', '缙云县', '1', '331122', null, '2', '1'),
('331123', '331100', '遂昌县', '1', '331123', null, '2', '1'),
('331124', '331100', '松阳县', '1', '331124', null, '2', '1'),
('331125', '331100', '云和县', '1', '331125', null, '2', '1'),
('331126', '331100', '庆元县', '1', '331126', null, '2', '1'),
('331127', '331100', '景宁畲族自治县', '1', '331127', null, '2', '1'),
('331181', '331100', '龙泉市', '1', '331181', null, '2', '1'),
('340000', '0', '安徽省', '1', '340000', 'A', '0', '1'),
('340100', '340000', '合肥市', '1', '340100', 'H', '1', '1'),
('340102', '340100', '瑶海区', '1', '340102', null, '2', '1'),
('340103', '340100', '庐阳区', '1', '340103', null, '2', '1'),
('340104', '340100', '蜀山区', '1', '340104', null, '2', '1'),
('340111', '340100', '包河区', '1', '340111', null, '2', '1'),
('340121', '340100', '长丰县', '1', '340121', null, '2', '1'),
('340122', '340100', '肥东县', '1', '340122', null, '2', '1'),
('340123', '340100', '肥西县', '1', '340123', null, '2', '1'),
('340200', '340000', '芜湖市', '1', '340200', 'W', '1', '1'),
('340202', '340200', '镜湖区', '1', '340202', null, '2', '1'),
('340203', '340200', '弋江区', '1', '340203', null, '2', '1'),
('340207', '340200', '鸠江区', '1', '340207', null, '2', '1'),
('340208', '340200', '三山区', '1', '340208', null, '2', '1'),
('340221', '340200', '芜湖县', '1', '340221', null, '2', '1'),
('340222', '340200', '繁昌县', '1', '340222', null, '2', '1'),
('340223', '340200', '南陵县', '1', '340223', null, '2', '1'),
('340300', '340000', '蚌埠市', '1', '340300', 'B', '1', '1'),
('340302', '340300', '龙子湖区', '1', '340302', null, '2', '1'),
('340303', '340300', '蚌山区', '1', '340303', null, '2', '1'),
('340304', '340300', '禹会区', '1', '340304', null, '2', '1'),
('340311', '340300', '淮上区', '1', '340311', null, '2', '1'),
('340321', '340300', '怀远县', '1', '340321', null, '2', '1'),
('340322', '340300', '五河县', '1', '340322', null, '2', '1'),
('340323', '340300', '固镇县', '1', '340323', null, '2', '1'),
('340400', '340000', '淮南市', '1', '340400', 'H', '1', '1'),
('340402', '340400', '大通区', '1', '340402', null, '2', '1'),
('340403', '340400', '田家庵区', '1', '340403', null, '2', '1'),
('340404', '340400', '谢家集区', '1', '340404', null, '2', '1'),
('340405', '340400', '八公山区', '1', '340405', null, '2', '1'),
('340406', '340400', '潘集区', '1', '340406', null, '2', '1'),
('340421', '340400', '凤台县', '1', '340421', null, '2', '1'),
('340500', '340000', '马鞍山市', '1', '340500', 'M', '1', '1'),
('340502', '340500', '金家庄区', '1', '340502', null, '2', '1'),
('340503', '340500', '花山区', '1', '340503', null, '2', '1'),
('340504', '340500', '雨山区', '1', '340504', null, '2', '1'),
('340521', '340500', '当涂县', '1', '340521', null, '2', '1'),
('340600', '340000', '淮北市', '1', '340600', 'H', '1', '1'),
('340602', '340600', '杜集区', '1', '340602', null, '2', '1'),
('340603', '340600', '相山区', '1', '340603', null, '2', '1'),
('340604', '340600', '烈山区', '1', '340604', null, '2', '1'),
('340621', '340600', '濉溪县', '1', '340621', null, '2', '1'),
('340700', '340000', '铜陵市', '1', '340700', 'T', '1', '1'),
('340702', '340700', '铜官山区', '1', '340702', null, '2', '1'),
('340703', '340700', '狮子山区', '1', '340703', null, '2', '1'),
('340711', '340700', '铜陵市郊区', '1', '340711', null, '2', '1'),
('340721', '340700', '铜陵县', '1', '340721', null, '2', '1'),
('340800', '340000', '安庆市', '1', '340800', 'A', '1', '1'),
('340802', '340800', '迎江区', '1', '340802', null, '2', '1'),
('340803', '340800', '大观区', '1', '340803', null, '2', '1'),
('340811', '340800', '宜秀区', '1', '340811', null, '2', '1'),
('340822', '340800', '怀宁县', '1', '340822', null, '2', '1'),
('340823', '340800', '枞阳县', '1', '340823', null, '2', '1'),
('340824', '340800', '潜山县', '1', '340824', null, '2', '1'),
('340825', '340800', '太湖县', '1', '340825', null, '2', '1'),
('340826', '340800', '宿松县', '1', '340826', null, '2', '1'),
('340827', '340800', '望江县', '1', '340827', null, '2', '1'),
('340828', '340800', '岳西县', '1', '340828', null, '2', '1'),
('340881', '340800', '桐城市', '1', '340881', null, '2', '1'),
('341000', '340000', '黄山市', '1', '341000', 'H', '1', '1'),
('341002', '341000', '屯溪区', '1', '341002', null, '2', '1'),
('341003', '341000', '黄山区', '1', '341003', null, '2', '1'),
('341004', '341000', '徽州区', '1', '341004', null, '2', '1'),
('341021', '341000', '歙县', '1', '341021', null, '2', '1'),
('341022', '341000', '休宁县', '1', '341022', null, '2', '1'),
('341023', '341000', '黟县', '1', '341023', null, '2', '1'),
('341024', '341000', '祁门县', '1', '341024', null, '2', '1'),
('341100', '340000', '滁州市', '1', '341100', 'C', '1', '1'),
('341102', '341100', '琅琊区', '1', '341102', null, '2', '1'),
('341103', '341100', '南谯区', '1', '341103', null, '2', '1'),
('341122', '341100', '来安县', '1', '341122', null, '2', '1'),
('341124', '341100', '全椒县', '1', '341124', null, '2', '1'),
('341125', '341100', '定远县', '1', '341125', null, '2', '1'),
('341126', '341100', '凤阳县', '1', '341126', null, '2', '1'),
('341181', '341100', '天长市', '1', '341181', null, '2', '1'),
('341182', '341100', '明光市', '1', '341182', null, '2', '1'),
('341200', '340000', '阜阳市', '1', '341200', 'F', '1', '1'),
('341202', '341200', '颍州区', '1', '341202', null, '2', '1'),
('341203', '341200', '颍东区', '1', '341203', null, '2', '1'),
('341204', '341200', '颍泉区', '1', '341204', null, '2', '1');
INSERT INTO `wst_areas` VALUES ('341221', '341200', '临泉县', '1', '341221', null, '2', '1'),
('341222', '341200', '太和县', '1', '341222', null, '2', '1'),
('341225', '341200', '阜南县', '1', '341225', null, '2', '1'),
('341226', '341200', '颍上县', '1', '341226', null, '2', '1'),
('341282', '341200', '界首市', '1', '341282', null, '2', '1'),
('341300', '340000', '宿州市', '1', '341300', 'S', '1', '1'),
('341302', '341300', '墉桥区', '1', '341302', null, '2', '1'),
('341321', '341300', '砀山县', '1', '341321', null, '2', '1'),
('341322', '341300', '萧县', '1', '341322', null, '2', '1'),
('341323', '341300', '灵璧县', '1', '341323', null, '2', '1'),
('341324', '341300', '泗县', '1', '341324', null, '2', '1'),
('341400', '340000', '巢湖市', '1', '341400', 'C', '1', '1'),
('341402', '341400', '居巢区', '1', '341402', null, '2', '1'),
('341421', '341400', '庐江县', '1', '341421', null, '2', '1'),
('341422', '341400', '无为县', '1', '341422', null, '2', '1'),
('341423', '341400', '含山县', '1', '341423', null, '2', '1'),
('341424', '341400', '和县', '1', '341424', null, '2', '1'),
('341500', '340000', '六安市', '1', '341500', 'L', '1', '1'),
('341502', '341500', '金安区', '1', '341502', null, '2', '1'),
('341503', '341500', '裕安区', '1', '341503', null, '2', '1'),
('341521', '341500', '寿县', '1', '341521', null, '2', '1'),
('341522', '341500', '霍邱县', '1', '341522', null, '2', '1'),
('341523', '341500', '舒城县', '1', '341523', null, '2', '1'),
('341524', '341500', '金寨县', '1', '341524', null, '2', '1'),
('341525', '341500', '霍山县', '1', '341525', null, '2', '1'),
('341600', '340000', '亳州市', '1', '341600', 'H', '1', '1'),
('341602', '341600', '谯城区', '1', '341602', null, '2', '1'),
('341621', '341600', '涡阳县', '1', '341621', null, '2', '1'),
('341622', '341600', '蒙城县', '1', '341622', null, '2', '1'),
('341623', '341600', '利辛县', '1', '341623', null, '2', '1'),
('341700', '340000', '池州市', '1', '341700', 'C', '1', '1'),
('341702', '341700', '贵池区', '1', '341702', null, '2', '1'),
('341721', '341700', '东至县', '1', '341721', null, '2', '1'),
('341722', '341700', '石台县', '1', '341722', null, '2', '1'),
('341723', '341700', '青阳县', '1', '341723', null, '2', '1'),
('341800', '340000', '宣城市', '1', '341800', 'X', '1', '1'),
('341802', '341800', '宣州区', '1', '341802', null, '2', '1'),
('341821', '341800', '郎溪县', '1', '341821', null, '2', '1'),
('341822', '341800', '广德县', '1', '341822', null, '2', '1'),
('341823', '341800', '泾县', '1', '341823', null, '2', '1'),
('341824', '341800', '绩溪县', '1', '341824', null, '2', '1'),
('341825', '341800', '旌德县', '1', '341825', null, '2', '1'),
('341881', '341800', '宁国市', '1', '341881', null, '2', '1'),
('350000', '0', '福建省', '1', '350000', 'F', '0', '1'),
('350100', '350000', '福州市', '1', '350100', 'F', '1', '1'),
('350102', '350100', '鼓楼区', '1', '350102', null, '2', '1'),
('350103', '350100', '台江区', '1', '350103', null, '2', '1'),
('350104', '350100', '仓山区', '1', '350104', null, '2', '1'),
('350105', '350100', '马尾区', '1', '350105', null, '2', '1'),
('350111', '350100', '晋安区', '1', '350111', null, '2', '1'),
('350121', '350100', '闽侯县', '1', '350121', null, '2', '1'),
('350122', '350100', '连江县', '1', '350122', null, '2', '1'),
('350123', '350100', '罗源县', '1', '350123', null, '2', '1'),
('350124', '350100', '闽清县', '1', '350124', null, '2', '1'),
('350125', '350100', '永泰县', '1', '350125', null, '2', '1'),
('350128', '350100', '平潭县', '1', '350128', null, '2', '1'),
('350181', '350100', '福清市', '1', '350181', null, '2', '1'),
('350182', '350100', '长乐市', '1', '350182', null, '2', '1'),
('350200', '350000', '厦门市', '1', '350200', 'X', '1', '1'),
('350203', '350200', '思明区', '1', '350203', null, '2', '1'),
('350205', '350200', '海沧区', '1', '350205', null, '2', '1'),
('350206', '350200', '湖里区', '1', '350206', null, '2', '1'),
('350211', '350200', '集美区', '1', '350211', null, '2', '1'),
('350212', '350200', '同安区', '1', '350212', null, '2', '1'),
('350213', '350200', '翔安区', '1', '350213', null, '2', '1'),
('350300', '350000', '莆田市', '1', '350300', 'P', '1', '1'),
('350302', '350300', '城厢区', '1', '350302', null, '2', '1'),
('350303', '350300', '涵江区', '1', '350303', null, '2', '1'),
('350304', '350300', '荔城区', '1', '350304', null, '2', '1'),
('350305', '350300', '秀屿区', '1', '350305', null, '2', '1'),
('350322', '350300', '仙游县', '1', '350322', null, '2', '1'),
('350400', '350000', '三明市', '1', '350400', 'S', '1', '1'),
('350402', '350400', '梅列区', '1', '350402', null, '2', '1'),
('350403', '350400', '三元区', '1', '350403', null, '2', '1'),
('350421', '350400', '明溪县', '1', '350421', null, '2', '1'),
('350423', '350400', '清流县', '1', '350423', null, '2', '1');
INSERT INTO `wst_areas` VALUES ('350424', '350400', '宁化县', '1', '350424', null, '2', '1'),
('350425', '350400', '大田县', '1', '350425', null, '2', '1'),
('350426', '350400', '尤溪县', '1', '350426', null, '2', '1'),
('350427', '350400', '沙县', '1', '350427', null, '2', '1'),
('350428', '350400', '将乐县', '1', '350428', null, '2', '1'),
('350429', '350400', '泰宁县', '1', '350429', null, '2', '1'),
('350430', '350400', '建宁县', '1', '350430', null, '2', '1'),
('350481', '350400', '永安市', '1', '350481', null, '2', '1'),
('350500', '350000', '泉州市', '1', '350500', 'Q', '1', '1'),
('350502', '350500', '鲤城区', '1', '350502', null, '2', '1'),
('350503', '350500', '丰泽区', '1', '350503', null, '2', '1'),
('350504', '350500', '洛江区', '1', '350504', null, '2', '1'),
('350505', '350500', '泉港区', '1', '350505', null, '2', '1'),
('350521', '350500', '惠安县', '1', '350521', null, '2', '1'),
('350524', '350500', '安溪县', '1', '350524', null, '2', '1'),
('350525', '350500', '永春县', '1', '350525', null, '2', '1'),
('350526', '350500', '德化县', '1', '350526', null, '2', '1'),
('350527', '350500', '金门县', '1', '350527', null, '2', '1'),
('350581', '350500', '石狮市', '1', '350581', null, '2', '1'),
('350582', '350500', '晋江市', '1', '350582', null, '2', '1'),
('350583', '350500', '南安市', '1', '350583', null, '2', '1'),
('350600', '350000', '漳州市', '1', '350600', 'Z', '1', '1'),
('350602', '350600', '芗城区', '1', '350602', null, '2', '1'),
('350603', '350600', '龙文区', '1', '350603', null, '2', '1'),
('350622', '350600', '云霄县', '1', '350622', null, '2', '1'),
('350623', '350600', '漳浦县', '1', '350623', null, '2', '1'),
('350624', '350600', '诏安县', '1', '350624', null, '2', '1'),
('350625', '350600', '长泰县', '1', '350625', null, '2', '1'),
('350626', '350600', '东山县', '1', '350626', null, '2', '1'),
('350627', '350600', '南靖县', '1', '350627', null, '2', '1'),
('350628', '350600', '平和县', '1', '350628', null, '2', '1'),
('350629', '350600', '华安县', '1', '350629', null, '2', '1'),
('350681', '350600', '龙海市', '1', '350681', null, '2', '1'),
('350700', '350000', '南平市', '1', '350700', 'N', '1', '1'),
('350702', '350700', '延平区', '1', '350702', null, '2', '1');
INSERT INTO `wst_areas` VALUES ('350721', '350700', '顺昌县', '1', '350721', null, '2', '1'),
('350722', '350700', '浦城县', '1', '350722', null, '2', '1'),
('350723', '350700', '光泽县', '1', '350723', null, '2', '1'),
('350724', '350700', '松溪县', '1', '350724', null, '2', '1'),
('350725', '350700', '政和县', '1', '350725', null, '2', '1'),
('350781', '350700', '邵武市', '1', '350781', null, '2', '1'),
('350782', '350700', '武夷山市', '1', '350782', null, '2', '1'),
('350783', '350700', '建瓯市', '1', '350783', null, '2', '1'),
('350784', '350700', '建阳市', '1', '350784', null, '2', '1'),
('350800', '350000', '龙岩市', '1', '350800', 'L', '1', '1'),
('350802', '350800', '新罗区', '1', '350802', null, '2', '1'),
('350821', '350800', '长汀县', '1', '350821', null, '2', '1'),
('350822', '350800', '永定县', '1', '350822', null, '2', '1'),
('350823', '350800', '上杭县', '1', '350823', null, '2', '1'),
('350824', '350800', '武平县', '1', '350824', null, '2', '1'),
('350825', '350800', '连城县', '1', '350825', null, '2', '1'),
('350881', '350800', '漳平市', '1', '350881', null, '2', '1'),
('350900', '350000', '宁德市　', '1', '350900', 'N', '1', '1'),
('350902', '350900', '蕉城区', '1', '350902', null, '2', '1'),
('350921', '350900', '霞浦县', '1', '350921', null, '2', '1'),
('350922', '350900', '古田县', '1', '350922', null, '2', '1'),
('350923', '350900', '屏南县', '1', '350923', null, '2', '1'),
('350924', '350900', '寿宁县', '1', '350924', null, '2', '1'),
('350925', '350900', '周宁县', '1', '350925', null, '2', '1'),
('350926', '350900', '柘荣县', '1', '350926', null, '2', '1'),
('350981', '350900', '福安市', '1', '350981', null, '2', '1'),
('350982', '350900', '福鼎市', '1', '350982', null, '2', '1'),
('360000', '0', '江西省', '1', '360000', 'J', '0', '1'),
('360100', '360000', '南昌市', '1', '360100', 'N', '1', '1'),
('360102', '360100', '东湖区', '1', '360102', null, '2', '1'),
('360103', '360100', '西湖区', '1', '360103', null, '2', '1'),
('360104', '360100', '青云谱区', '1', '360104', null, '2', '1'),
('360105', '360100', '湾里区', '1', '360105', null, '2', '1'),
('360111', '360100', '青山湖区', '1', '360111', null, '2', '1'),
('360121', '360100', '南昌县', '1', '360121', null, '2', '1'),
('360122', '360100', '新建县', '1', '360122', null, '2', '1'),
('360123', '360100', '安义县', '1', '360123', null, '2', '1'),
('360124', '360100', '进贤县', '1', '360124', null, '2', '1'),
('360200', '360000', '景德镇市', '1', '360200', 'J', '1', '1'),
('360202', '360200', '昌江区', '1', '360202', null, '2', '1'),
('360203', '360200', '珠山区', '1', '360203', null, '2', '1'),
('360222', '360200', '浮梁县', '1', '360222', null, '2', '1'),
('360281', '360200', '乐平市', '1', '360281', null, '2', '1'),
('360300', '360000', '萍乡市', '1', '360300', 'P', '1', '1'),
('360302', '360300', '安源区', '1', '360302', null, '2', '1'),
('360313', '360300', '湘东区', '1', '360313', null, '2', '1'),
('360321', '360300', '莲花县', '1', '360321', null, '2', '1'),
('360322', '360300', '上栗县', '1', '360322', null, '2', '1'),
('360323', '360300', '芦溪县', '1', '360323', null, '2', '1'),
('360400', '360000', '九江市', '1', '360400', 'J', '1', '1'),
('360402', '360400', '庐山区', '1', '360402', null, '2', '1'),
('360403', '360400', '浔阳区', '1', '360403', null, '2', '1'),
('360421', '360400', '九江县', '1', '360421', null, '2', '1'),
('360423', '360400', '武宁县', '1', '360423', null, '2', '1'),
('360424', '360400', '修水县', '1', '360424', null, '2', '1'),
('360425', '360400', '永修县', '1', '360425', null, '2', '1'),
('360426', '360400', '德安县', '1', '360426', null, '2', '1'),
('360427', '360400', '星子县', '1', '360427', null, '2', '1'),
('360428', '360400', '都昌县', '1', '360428', null, '2', '1'),
('360429', '360400', '湖口县', '1', '360429', null, '2', '1'),
('360430', '360400', '彭泽县', '1', '360430', null, '2', '1'),
('360481', '360400', '瑞昌市', '1', '360481', null, '2', '1'),
('360500', '360000', '新余市', '1', '360500', 'X', '1', '1'),
('360502', '360500', '渝水区', '1', '360502', null, '2', '1'),
('360521', '360500', '分宜县', '1', '360521', null, '2', '1'),
('360600', '360000', '鹰潭市', '1', '360600', 'Y', '1', '1'),
('360602', '360600', '月湖区', '1', '360602', null, '2', '1'),
('360622', '360600', '余江县', '1', '360622', null, '2', '1'),
('360681', '360600', '贵溪市', '1', '360681', null, '2', '1'),
('360700', '360000', '赣州市', '1', '360700', 'Z', '1', '1'),
('360702', '360700', '章贡区', '1', '360702', null, '2', '1'),
('360721', '360700', '赣县', '1', '360721', null, '2', '1'),
('360722', '360700', '信丰县', '1', '360722', null, '2', '1'),
('360723', '360700', '大余县', '1', '360723', null, '2', '1'),
('360724', '360700', '上犹县', '1', '360724', null, '2', '1'),
('360725', '360700', '崇义县', '1', '360725', null, '2', '1'),
('360726', '360700', '安远县', '1', '360726', null, '2', '1'),
('360727', '360700', '龙南县', '1', '360727', null, '2', '1'),
('360728', '360700', '定南县', '1', '360728', null, '2', '1'),
('360729', '360700', '全南县', '1', '360729', null, '2', '1'),
('360730', '360700', '宁都县', '1', '360730', null, '2', '1'),
('360731', '360700', '于都县', '1', '360731', null, '2', '1'),
('360732', '360700', '兴国县', '1', '360732', null, '2', '1'),
('360733', '360700', '会昌县', '1', '360733', null, '2', '1'),
('360734', '360700', '寻乌县', '1', '360734', null, '2', '1'),
('360735', '360700', '石城县', '1', '360735', null, '2', '1'),
('360781', '360700', '瑞金市', '1', '360781', null, '2', '1'),
('360782', '360700', '南康市', '1', '360782', null, '2', '1'),
('360800', '360000', '吉安市', '1', '360800', 'J', '1', '1');
INSERT INTO `wst_areas` VALUES ('360802', '360800', '吉州区', '1', '360802', null, '2', '1'),
('360803', '360800', '青原区', '1', '360803', null, '2', '1'),
('360821', '360800', '吉安县', '1', '360821', null, '2', '1'),
('360822', '360800', '吉水县', '1', '360822', null, '2', '1'),
('360823', '360800', '峡江县', '1', '360823', null, '2', '1'),
('360824', '360800', '新干县', '1', '360824', null, '2', '1'),
('360825', '360800', '永丰县', '1', '360825', null, '2', '1'),
('360826', '360800', '泰和县', '1', '360826', null, '2', '1'),
('360827', '360800', '遂川县', '1', '360827', null, '2', '1'),
('360828', '360800', '万安县', '1', '360828', null, '2', '1'),
('360829', '360800', '安福县', '1', '360829', null, '2', '1'),
('360830', '360800', '永新县', '1', '360830', null, '2', '1'),
('360881', '360800', '井冈山市', '1', '360881', null, '2', '1'),
('360900', '360000', '宜春市', '1', '360900', 'Y', '1', '1'),
('360902', '360900', '袁州区', '1', '360902', null, '2', '1'),
('360921', '360900', '奉新县', '1', '360921', null, '2', '1'),
('360922', '360900', '万载县', '1', '360922', null, '2', '1'),
('360923', '360900', '上高县', '1', '360923', null, '2', '1'),
('360924', '360900', '宜丰县', '1', '360924', null, '2', '1'),
('360925', '360900', '靖安县', '1', '360925', null, '2', '1'),
('360926', '360900', '铜鼓县', '1', '360926', null, '2', '1'),
('360981', '360900', '丰城市', '1', '360981', null, '2', '1'),
('360982', '360900', '樟树市', '1', '360982', null, '2', '1'),
('360983', '360900', '高安市', '1', '360983', null, '2', '1'),
('361000', '360000', '抚州市', '1', '361000', 'F', '1', '1'),
('361002', '361000', '临川区', '1', '361002', null, '2', '1'),
('361021', '361000', '南城县', '1', '361021', null, '2', '1'),
('361022', '361000', '黎川县', '1', '361022', null, '2', '1'),
('361023', '361000', '南丰县', '1', '361023', null, '2', '1'),
('361024', '361000', '崇仁县', '1', '361024', null, '2', '1'),
('361025', '361000', '乐安县', '1', '361025', null, '2', '1'),
('361026', '361000', '宜黄县', '1', '361026', null, '2', '1'),
('361027', '361000', '金溪县', '1', '361027', null, '2', '1'),
('361028', '361000', '资溪县', '1', '361028', null, '2', '1'),
('361029', '361000', '东乡县', '1', '361029', null, '2', '1'),
('361030', '361000', '广昌县', '1', '361030', null, '2', '1'),
('361100', '360000', '上饶市', '1', '361100', 'S', '1', '1'),
('361102', '361100', '信州区', '1', '361102', null, '2', '1'),
('361121', '361100', '上饶县', '1', '361121', null, '2', '1'),
('361122', '361100', '广丰县', '1', '361122', null, '2', '1'),
('361123', '361100', '玉山县', '1', '361123', null, '2', '1'),
('361124', '361100', '铅山县', '1', '361124', null, '2', '1'),
('361125', '361100', '横峰县', '1', '361125', null, '2', '1'),
('361126', '361100', '弋阳县', '1', '361126', null, '2', '1'),
('361127', '361100', '余干县', '1', '361127', null, '2', '1'),
('361128', '361100', '鄱阳县', '1', '361128', null, '2', '1'),
('361129', '361100', '万年县', '1', '361129', null, '2', '1'),
('361130', '361100', '婺源县', '1', '361130', null, '2', '1'),
('361181', '361100', '德兴市', '1', '361181', null, '2', '1'),
('370000', '0', '山东省', '1', '370000', 'S', '0', '1'),
('370100', '370000', '济南市', '1', '370100', 'J', '1', '1'),
('370102', '370100', '历下区', '1', '370102', null, '2', '1'),
('370103', '370100', '市中区', '1', '370103', null, '2', '1'),
('370104', '370100', '槐荫区', '1', '370104', null, '2', '1'),
('370105', '370100', '天桥区', '1', '370105', null, '2', '1'),
('370112', '370100', '历城区', '1', '370112', null, '2', '1'),
('370113', '370100', '长清区', '1', '370113', null, '2', '1'),
('370124', '370100', '平阴县', '1', '370124', null, '2', '1'),
('370125', '370100', '济阳县', '1', '370125', null, '2', '1'),
('370126', '370100', '商河县', '1', '370126', null, '2', '1'),
('370181', '370100', '章丘市', '1', '370181', null, '2', '1'),
('370200', '370000', '青岛市', '1', '370200', 'Q', '1', '1'),
('370202', '370200', '市南区', '1', '370202', null, '2', '1'),
('370203', '370200', '市北区', '1', '370203', null, '2', '1'),
('370205', '370200', '四方区', '1', '370205', null, '2', '1'),
('370211', '370200', '黄岛区', '1', '370211', null, '2', '1'),
('370212', '370200', '崂山区', '1', '370212', null, '2', '1'),
('370213', '370200', '李沧区', '1', '370213', null, '2', '1'),
('370214', '370200', '城阳区', '1', '370214', null, '2', '1'),
('370281', '370200', '胶州市', '1', '370281', null, '2', '1'),
('370282', '370200', '即墨市', '1', '370282', null, '2', '1'),
('370283', '370200', '平度市', '1', '370283', null, '2', '1'),
('370284', '370200', '胶南市', '1', '370284', null, '2', '1'),
('370285', '370200', '莱西市', '1', '370285', null, '2', '1'),
('370300', '370000', '淄博市', '1', '370300', 'Z', '1', '1'),
('370302', '370300', '淄川区', '1', '370302', null, '2', '1'),
('370303', '370300', '张店区', '1', '370303', null, '2', '1'),
('370304', '370300', '博山区', '1', '370304', null, '2', '1'),
('370305', '370300', '临淄区', '1', '370305', null, '2', '1'),
('370306', '370300', '周村区', '1', '370306', null, '2', '1'),
('370321', '370300', '桓台县', '1', '370321', null, '2', '1'),
('370322', '370300', '高青县', '1', '370322', null, '2', '1'),
('370323', '370300', '沂源县', '1', '370323', null, '2', '1'),
('370400', '370000', '枣庄市', '1', '370400', 'Z', '1', '1'),
('370402', '370400', '市中区', '1', '370402', null, '2', '1'),
('370403', '370400', '薛城区', '1', '370403', null, '2', '1'),
('370404', '370400', '峄城区', '1', '370404', null, '2', '1'),
('370405', '370400', '台儿庄区', '1', '370405', null, '2', '1'),
('370406', '370400', '山亭区', '1', '370406', null, '2', '1'),
('370481', '370400', '滕州市', '1', '370481', null, '2', '1'),
('370500', '370000', '东营市', '1', '370500', 'D', '1', '1'),
('370502', '370500', '东营区', '1', '370502', null, '2', '1'),
('370503', '370500', '河口区', '1', '370503', null, '2', '1'),
('370521', '370500', '垦利县', '1', '370521', null, '2', '1'),
('370522', '370500', '利津县', '1', '370522', null, '2', '1'),
('370523', '370500', '广饶县', '1', '370523', null, '2', '1'),
('370600', '370000', '烟台市', '1', '370600', 'Y', '1', '1'),
('370602', '370600', '芝罘区', '1', '370602', null, '2', '1'),
('370611', '370600', '福山区', '1', '370611', null, '2', '1'),
('370612', '370600', '牟平区', '1', '370612', null, '2', '1');
INSERT INTO `wst_areas` VALUES ('370613', '370600', '莱山区', '1', '370613', null, '2', '1'),
('370634', '370600', '长岛县', '1', '370634', null, '2', '1'),
('370681', '370600', '龙口市', '1', '370681', null, '2', '1'),
('370682', '370600', '莱阳市', '1', '370682', null, '2', '1'),
('370683', '370600', '莱州市', '1', '370683', null, '2', '1'),
('370684', '370600', '蓬莱市', '1', '370684', null, '2', '1'),
('370685', '370600', '招远市', '1', '370685', null, '2', '1'),
('370686', '370600', '栖霞市', '1', '370686', null, '2', '1'),
('370687', '370600', '海阳市', '1', '370687', null, '2', '1'),
('370700', '370000', '潍坊市', '1', '370700', 'W', '1', '1'),
('370702', '370700', '潍城区', '1', '370702', null, '2', '1'),
('370703', '370700', '寒亭区', '1', '370703', null, '2', '1'),
('370704', '370700', '坊子区', '1', '370704', null, '2', '1'),
('370705', '370700', '奎文区', '1', '370705', null, '2', '1'),
('370724', '370700', '临朐县', '1', '370724', null, '2', '1'),
('370725', '370700', '昌乐县', '1', '370725', null, '2', '1'),
('370781', '370700', '青州市', '1', '370781', null, '2', '1'),
('370782', '370700', '诸城市', '1', '370782', null, '2', '1'),
('370783', '370700', '寿光市', '1', '370783', null, '2', '1'),
('370784', '370700', '安丘市', '1', '370784', null, '2', '1'),
('370785', '370700', '高密市', '1', '370785', null, '2', '1'),
('370786', '370700', '昌邑市', '1', '370786', null, '2', '1'),
('370800', '370000', '济宁市', '1', '370800', 'J', '1', '1'),
('370802', '370800', '市中区', '1', '370802', null, '2', '1'),
('370811', '370800', '任城区', '1', '370811', null, '2', '1'),
('370826', '370800', '\"微山县', '1', '370826', null, '2', '1'),
('370827', '370800', '鱼台县', '1', '370827', null, '2', '1'),
('370828', '370800', '金乡县', '1', '370828', null, '2', '1'),
('370829', '370800', '嘉祥县', '1', '370829', null, '2', '1'),
('370830', '370800', '汶上县', '1', '370830', null, '2', '1'),
('370831', '370800', '泗水县', '1', '370831', null, '2', '1'),
('370832', '370800', '梁山县', '1', '370832', null, '2', '1'),
('370881', '370800', '曲阜市', '1', '370881', null, '2', '1'),
('370882', '370800', '兖州市', '1', '370882', null, '2', '1'),
('370883', '370800', '邹城市', '1', '370883', null, '2', '1'),
('370900', '370000', '泰安市', '1', '370900', 'T', '1', '1'),
('370902', '370900', '泰山区', '1', '370902', null, '2', '1'),
('370903', '370900', '岱岳区', '1', '370903', null, '2', '1'),
('370921', '370900', '宁阳县', '1', '370921', null, '2', '1'),
('370923', '370900', '东平县', '1', '370923', null, '2', '1'),
('370982', '370900', '新泰市', '1', '370982', null, '2', '1'),
('370983', '370900', '肥城市', '1', '370983', null, '2', '1'),
('371000', '370000', '威海市', '1', '371000', 'W', '1', '1'),
('371002', '371000', '环翠区', '1', '371002', null, '2', '1'),
('371081', '371000', '文登市', '1', '371081', null, '2', '1'),
('371082', '371000', '荣成市', '1', '371082', null, '2', '1'),
('371083', '371000', '乳山市', '1', '371083', null, '2', '1'),
('371100', '370000', '日照市', '1', '371100', 'R', '1', '1'),
('371102', '371100', '东港区', '1', '371102', null, '2', '1'),
('371103', '371100', '岚山区', '1', '371103', null, '2', '1'),
('371121', '371100', '五莲县', '1', '371121', null, '2', '1'),
('371122', '371100', '莒县', '1', '371122', null, '2', '1'),
('371200', '370000', '莱芜市', '1', '371200', 'L', '1', '1'),
('371202', '371200', '莱城区', '1', '371202', null, '2', '1'),
('371203', '371200', '钢城区', '1', '371203', null, '2', '1'),
('371300', '370000', '临沂市', '1', '371300', 'L', '1', '1'),
('371301', '371300', '临沂市辖区', '1', '371301', null, '2', '1'),
('371302', '371300', '兰山区', '1', '371302', null, '2', '1'),
('371311', '371300', '罗庄区', '1', '371311', null, '2', '1'),
('371312', '371300', '河东区', '1', '371312', null, '2', '1'),
('371321', '371300', '沂南县', '1', '371321', null, '2', '1'),
('371322', '371300', '郯城县', '1', '371322', null, '2', '1'),
('371323', '371300', '沂水县', '1', '371323', null, '2', '1'),
('371324', '371300', '苍山县', '1', '371324', null, '2', '1'),
('371325', '371300', '费县', '1', '371325', null, '2', '1'),
('371326', '371300', '平邑县', '1', '371326', null, '2', '1'),
('371327', '371300', '莒南县', '1', '371327', null, '2', '1'),
('371328', '371300', '蒙阴县', '1', '371328', null, '2', '1'),
('371329', '371300', '临沭县', '1', '371329', null, '2', '1'),
('371400', '370000', '德州市', '1', '371400', 'D', '1', '1'),
('371402', '371400', '德城区', '1', '371402', null, '2', '1'),
('371421', '371400', '陵县', '1', '371421', null, '2', '1'),
('371422', '371400', '宁津县', '1', '371422', null, '2', '1'),
('371423', '371400', '庆云县', '1', '371423', null, '2', '1'),
('371424', '371400', '临邑县', '1', '371424', null, '2', '1'),
('371425', '371400', '齐河县', '1', '371425', null, '2', '1'),
('371426', '371400', '平原县', '1', '371426', null, '2', '1'),
('371427', '371400', '夏津县', '1', '371427', null, '2', '1'),
('371428', '371400', '武城县', '1', '371428', null, '2', '1'),
('371481', '371400', '乐陵市', '1', '371481', null, '2', '1'),
('371482', '371400', '禹城市', '1', '371482', null, '2', '1'),
('371500', '370000', '聊城市', '1', '371500', 'L', '1', '1'),
('371502', '371500', '东昌府区', '1', '371502', null, '2', '1'),
('371521', '371500', '阳谷县', '1', '371521', null, '2', '1'),
('371522', '371500', '莘县', '1', '371522', null, '2', '1'),
('371523', '371500', '茌平县', '1', '371523', null, '2', '1'),
('371524', '371500', '东阿县', '1', '371524', null, '2', '1'),
('371525', '371500', '冠县', '1', '371525', null, '2', '1'),
('371526', '371500', '高唐县', '1', '371526', null, '2', '1'),
('371581', '371500', '临清市', '1', '371581', null, '2', '1'),
('371600', '370000', '滨州市', '1', '371600', 'B', '1', '1'),
('371602', '371600', '滨城区', '1', '371602', null, '2', '1'),
('371621', '371600', '惠民县', '1', '371621', null, '2', '1'),
('371622', '371600', '阳信县', '1', '371622', null, '2', '1'),
('371623', '371600', '无棣县', '1', '371623', null, '2', '1'),
('371624', '371600', '沾化县', '1', '371624', null, '2', '1'),
('371625', '371600', '博兴县', '1', '371625', null, '2', '1'),
('371626', '371600', '邹平县', '1', '371626', null, '2', '1'),
('371700', '370000', '菏泽市', '1', '371700', 'H', '1', '1'),
('371702', '371700', '牡丹区', '1', '371702', null, '2', '1');
INSERT INTO `wst_areas` VALUES ('371721', '371700', '曹县', '1', '371721', null, '2', '1'),
('371722', '371700', '单县', '1', '371722', null, '2', '1'),
('371723', '371700', '成武县', '1', '371723', null, '2', '1'),
('371724', '371700', '巨野县', '1', '371724', null, '2', '1'),
('371725', '371700', '郓城县', '1', '371725', null, '2', '1'),
('371726', '371700', '鄄城县', '1', '371726', null, '2', '1'),
('371727', '371700', '定陶县', '1', '371727', null, '2', '1'),
('371728', '371700', '东明县', '1', '371728', null, '2', '1'),
('410000', '0', '河南省', '1', '410000', 'H', '0', '1'),
('410100', '410000', '郑州市', '1', '410100', 'Z', '1', '1'),
('410102', '410100', '中原区', '1', '410102', null, '2', '1'),
('410103', '410100', '二七区', '1', '410103', null, '2', '1'),
('410104', '410100', '管城回族区', '1', '410104', null, '2', '1'),
('410105', '410100', '金水区', '1', '410105', null, '2', '1'),
('410106', '410100', '上街区', '1', '410106', null, '2', '1'),
('410108', '410100', '惠济区', '1', '410108', null, '2', '1'),
('410122', '410100', '中牟县', '1', '410122', null, '2', '1'),
('410181', '410100', '巩义市', '1', '410181', null, '2', '1'),
('410182', '410100', '荥阳市', '1', '410182', null, '2', '1'),
('410183', '410100', '新密市', '1', '410183', null, '2', '1'),
('410184', '410100', '新郑市', '1', '410184', null, '2', '1'),
('410185', '410100', '登封市', '1', '410185', null, '2', '1'),
('410200', '410000', '开封市', '1', '410200', 'K', '1', '1'),
('410202', '410200', '龙亭区', '1', '410202', null, '2', '1'),
('410203', '410200', '顺河区', '1', '410203', null, '2', '1'),
('410204', '410200', '鼓楼区', '1', '410204', null, '2', '1'),
('410205', '410200', '禹王台区', '1', '410205', null, '2', '1'),
('410211', '410200', '金明区', '1', '410211', null, '2', '1'),
('410221', '410200', '杞县', '1', '410221', null, '2', '1'),
('410222', '410200', '通许县', '1', '410222', null, '2', '1'),
('410223', '410200', '尉氏县', '1', '410223', null, '2', '1'),
('410224', '410200', '开封县', '1', '410224', null, '2', '1'),
('410225', '410200', '兰考县', '1', '410225', null, '2', '1'),
('410300', '410000', '洛阳市', '1', '410300', 'L', '1', '1'),
('410302', '410300', '老城区', '1', '410302', null, '2', '1'),
('410303', '410300', '西工区', '1', '410303', null, '2', '1'),
('410304', '410300', '廛河回族区', '1', '410304', null, '2', '1'),
('410305', '410300', '涧西区', '1', '410305', null, '2', '1'),
('410306', '410300', '吉利区', '1', '410306', null, '2', '1'),
('410307', '410300', '洛龙区', '1', '410307', null, '2', '1'),
('410322', '410300', '孟津县', '1', '410322', null, '2', '1'),
('410323', '410300', '新安县', '1', '410323', null, '2', '1'),
('410324', '410300', '栾川县', '1', '410324', null, '2', '1'),
('410325', '410300', '嵩县', '1', '410325', null, '2', '1'),
('410326', '410300', '汝阳县', '1', '410326', null, '2', '1'),
('410327', '410300', '宜阳县', '1', '410327', null, '2', '1'),
('410328', '410300', '洛宁县', '1', '410328', null, '2', '1'),
('410329', '410300', '伊川县', '1', '410329', null, '2', '1'),
('410381', '410300', '偃师市', '1', '410381', null, '2', '1'),
('410400', '410000', '平顶山市', '1', '410400', 'P', '1', '1'),
('410402', '410400', '新华区', '1', '410402', null, '2', '1'),
('410403', '410400', '卫东区', '1', '410403', null, '2', '1'),
('410404', '410400', '石龙区', '1', '410404', null, '2', '1'),
('410411', '410400', '湛河区', '1', '410411', null, '2', '1'),
('410421', '410400', '宝丰县', '1', '410421', null, '2', '1'),
('410422', '410400', '叶  县', '1', '410422', null, '2', '1'),
('410423', '410400', '鲁山县', '1', '410423', null, '2', '1'),
('410425', '410400', '郏  县', '1', '410425', null, '2', '1'),
('410481', '410400', '舞钢市', '1', '410481', null, '2', '1'),
('410482', '410400', '汝州市', '1', '410482', null, '2', '1'),
('410500', '410000', '安阳市', '1', '410500', 'A', '1', '1'),
('410502', '410500', '文峰区', '1', '410502', null, '2', '1'),
('410503', '410500', '北关区', '1', '410503', null, '2', '1'),
('410505', '410500', '殷都区', '1', '410505', null, '2', '1'),
('410506', '410500', '龙安区', '1', '410506', null, '2', '1'),
('410522', '410500', '安阳县', '1', '410522', null, '2', '1'),
('410523', '410500', '汤阴县', '1', '410523', null, '2', '1'),
('410526', '410500', '滑县', '1', '410526', null, '2', '1'),
('410527', '410500', '内黄县', '1', '410527', null, '2', '1'),
('410581', '410500', '林州市', '1', '410581', null, '2', '1'),
('410600', '410000', '鹤壁市', '1', '410600', 'H', '1', '1'),
('410602', '410600', '鹤山区', '1', '410602', null, '2', '1'),
('410603', '410600', '山城区', '1', '410603', null, '2', '1'),
('410611', '410600', '淇滨区', '1', '410611', null, '2', '1'),
('410621', '410600', '浚县', '1', '410621', null, '2', '1'),
('410622', '410600', '淇县', '1', '410622', null, '2', '1'),
('410700', '410000', '新乡市', '1', '410700', 'X', '1', '1'),
('410702', '410700', '红旗区', '1', '410702', null, '2', '1'),
('410703', '410700', '卫滨区', '1', '410703', null, '2', '1'),
('410704', '410700', '凤泉区', '1', '410704', null, '2', '1'),
('410711', '410700', '牧野区', '1', '410711', null, '2', '1'),
('410721', '410700', '新乡县', '1', '410721', null, '2', '1'),
('410724', '410700', '获嘉县', '1', '410724', null, '2', '1'),
('410725', '410700', '原阳县', '1', '410725', null, '2', '1'),
('410726', '410700', '延津县', '1', '410726', null, '2', '1'),
('410727', '410700', '封丘县', '1', '410727', null, '2', '1'),
('410728', '410700', '长垣县', '1', '410728', null, '2', '1'),
('410781', '410700', '卫辉市', '1', '410781', null, '2', '1'),
('410782', '410700', '辉县市', '1', '410782', null, '2', '1'),
('410800', '410000', '焦作市', '1', '410800', 'Z', '1', '1'),
('410802', '410800', '解放区', '1', '410802', null, '2', '1'),
('410803', '410800', '中站区', '1', '410803', null, '2', '1'),
('410804', '410800', '马村区', '1', '410804', null, '2', '1'),
('410811', '410800', '山阳区', '1', '410811', null, '2', '1'),
('410821', '410800', '修武县', '1', '410821', null, '2', '1'),
('410822', '410800', '博爱县', '1', '410822', null, '2', '1'),
('410823', '410800', '武陟县', '1', '410823', null, '2', '1'),
('410825', '410800', '温县', '1', '410825', null, '2', '1'),
('410881', '410800', '济源市', '1', '410881', null, '2', '1'),
('410882', '410800', '沁阳市', '1', '410882', null, '2', '1');
INSERT INTO `wst_areas` VALUES ('410883', '410800', '孟州市', '1', '410883', null, '2', '1'),
('410900', '410000', '濮阳市', '1', '410900', 'P', '1', '1'),
('410902', '410900', '华龙区', '1', '410902', null, '2', '1'),
('410922', '410900', '清丰县', '1', '410922', null, '2', '1'),
('410923', '410900', '南乐县', '1', '410923', null, '2', '1'),
('410926', '410900', '范县', '1', '410926', null, '2', '1'),
('410927', '410900', '台前县', '1', '410927', null, '2', '1'),
('410928', '410900', '濮阳县', '1', '410928', null, '2', '1'),
('411000', '410000', '许昌市', '1', '411000', 'X', '1', '1'),
('411002', '411000', '魏都区', '1', '411002', null, '2', '1'),
('411023', '411000', '许昌县', '1', '411023', null, '2', '1'),
('411024', '411000', '鄢陵县', '1', '411024', null, '2', '1'),
('411025', '411000', '襄城县', '1', '411025', null, '2', '1'),
('411081', '411000', '禹州市', '1', '411081', null, '2', '1'),
('411082', '411000', '长葛市', '1', '411082', null, '2', '1'),
('411100', '410000', '漯河市', '1', '411100', 'L', '1', '1'),
('411102', '411100', '源汇区', '1', '411102', null, '2', '1'),
('411103', '411100', '郾城区', '1', '411103', null, '2', '1'),
('411104', '411100', '召陵区', '1', '411104', null, '2', '1'),
('411121', '411100', '舞阳县', '1', '411121', null, '2', '1'),
('411122', '411100', '临颖县', '1', '411122', null, '2', '1'),
('411200', '410000', '三门峡市', '1', '411200', 'S', '1', '1'),
('411202', '411200', '湖滨区', '1', '411202', null, '2', '1'),
('411221', '411200', '渑池县', '1', '411221', null, '2', '1'),
('411222', '411200', '陕县', '1', '411222', null, '2', '1'),
('411224', '411200', '卢氏县', '1', '411224', null, '2', '1'),
('411281', '411200', '义马市', '1', '411281', null, '2', '1'),
('411282', '411200', '灵宝市', '1', '411282', null, '2', '1'),
('411300', '410000', '南阳市', '1', '411300', 'N', '1', '1'),
('411302', '411300', '宛城区', '1', '411302', null, '2', '1'),
('411303', '411300', '卧龙区', '1', '411303', null, '2', '1'),
('411321', '411300', '南召县', '1', '411321', null, '2', '1'),
('411322', '411300', '方城县', '1', '411322', null, '2', '1'),
('411323', '411300', '西峡县', '1', '411323', null, '2', '1'),
('411324', '411300', '镇平县', '1', '411324', null, '2', '1'),
('411325', '411300', '内乡县', '1', '411325', null, '2', '1'),
('411326', '411300', '淅川县', '1', '411326', null, '2', '1'),
('411327', '411300', '社旗县', '1', '411327', null, '2', '1'),
('411328', '411300', '唐河县', '1', '411328', null, '2', '1'),
('411329', '411300', '新野县', '1', '411329', null, '2', '1'),
('411330', '411300', '桐柏县', '1', '411330', null, '2', '1'),
('411381', '411300', '邓州市', '1', '411381', null, '2', '1'),
('411400', '410000', '商丘市', '1', '411400', 'S', '1', '1'),
('411402', '411400', '梁园区', '1', '411402', null, '2', '1'),
('411403', '411400', '睢阳区', '1', '411403', null, '2', '1'),
('411421', '411400', '民权县', '1', '411421', null, '2', '1'),
('411422', '411400', '睢县', '1', '411422', null, '2', '1'),
('411423', '411400', '宁陵县', '1', '411423', null, '2', '1'),
('411424', '411400', '柘城县', '1', '411424', null, '2', '1'),
('411425', '411400', '虞城县', '1', '411425', null, '2', '1'),
('411426', '411400', '夏邑县', '1', '411426', null, '2', '1'),
('411481', '411400', '永城市', '1', '411481', null, '2', '1'),
('411500', '410000', '信阳市', '1', '411500', 'X', '1', '1'),
('411502', '411500', '浉河区', '1', '411502', null, '2', '1'),
('411503', '411500', '平桥区', '1', '411503', null, '2', '1'),
('411521', '411500', '罗山县', '1', '411521', null, '2', '1'),
('411522', '411500', '光山县', '1', '411522', null, '2', '1'),
('411523', '411500', '新县', '1', '411523', null, '2', '1'),
('411524', '411500', '商城县', '1', '411524', null, '2', '1'),
('411525', '411500', '固始县', '1', '411525', null, '2', '1'),
('411526', '411500', '潢川县', '1', '411526', null, '2', '1'),
('411527', '411500', '淮滨县', '1', '411527', null, '2', '1'),
('411528', '411500', '息县', '1', '411528', null, '2', '1'),
('411600', '410000', '周口市', '1', '411600', 'Z', '1', '1'),
('411602', '411600', '川汇区', '1', '411602', null, '2', '1'),
('411621', '411600', '扶沟县', '1', '411621', null, '2', '1'),
('411622', '411600', '西华县', '1', '411622', null, '2', '1'),
('411623', '411600', '商水县', '1', '411623', null, '2', '1'),
('411624', '411600', '沈丘县', '1', '411624', null, '2', '1'),
('411625', '411600', '郸城县', '1', '411625', null, '2', '1'),
('411626', '411600', '淮阳县', '1', '411626', null, '2', '1'),
('411627', '411600', '太康县', '1', '411627', null, '2', '1'),
('411628', '411600', '鹿邑县', '1', '411628', null, '2', '1'),
('411681', '411600', '项城市', '1', '411681', null, '2', '1'),
('411700', '410000', '驻马店市', '1', '411700', 'Z', '1', '1'),
('411702', '411700', '驿城区', '1', '411702', null, '2', '1'),
('411721', '411700', '西平县', '1', '411721', null, '2', '1'),
('411722', '411700', '上蔡县', '1', '411722', null, '2', '1'),
('411723', '411700', '平舆县', '1', '411723', null, '2', '1'),
('411724', '411700', '正阳县', '1', '411724', null, '2', '1'),
('411725', '411700', '确山县', '1', '411725', null, '2', '1'),
('411726', '411700', '泌阳县', '1', '411726', null, '2', '1'),
('411727', '411700', '汝南县', '1', '411727', null, '2', '1'),
('411728', '411700', '遂平县', '1', '411728', null, '2', '1'),
('411729', '411700', '新蔡县', '1', '411729', null, '2', '1'),
('420000', '0', '湖北省', '1', '420000', 'H', '0', '1'),
('420100', '420000', '武汉市', '1', '420100', 'W', '1', '1'),
('420102', '420100', '江岸区', '1', '420102', null, '2', '1'),
('420103', '420100', '江汉区', '1', '420103', null, '2', '1'),
('420104', '420100', '硚口区', '1', '420104', null, '2', '1'),
('420105', '420100', '汉阳区', '1', '420105', null, '2', '1'),
('420106', '420100', '武昌区', '1', '420106', null, '2', '1'),
('420107', '420100', '青山区', '1', '420107', null, '2', '1'),
('420111', '420100', '洪山区', '1', '420111', null, '2', '1'),
('420112', '420100', '东西湖区', '1', '420112', null, '2', '1'),
('420113', '420100', '汉南区', '1', '420113', null, '2', '1'),
('420114', '420100', '蔡甸区', '1', '420114', null, '2', '1'),
('420115', '420100', '江夏区', '1', '420115', null, '2', '1'),
('420116', '420100', '黄陂区', '1', '420116', null, '2', '1'),
('420117', '420100', '武汉市新洲区', '1', '420117', null, '2', '1');
INSERT INTO `wst_areas` VALUES ('420200', '420000', '黄石市', '1', '420200', 'H', '1', '1'),
('420202', '420200', '黄石港区', '1', '420202', null, '2', '1'),
('420203', '420200', '西塞山区', '1', '420203', null, '2', '1'),
('420204', '420200', '下陆区', '1', '420204', null, '2', '1'),
('420205', '420200', '铁山区', '1', '420205', null, '2', '1'),
('420222', '420200', '阳新县', '1', '420222', null, '2', '1'),
('420281', '420200', '大冶市', '1', '420281', null, '2', '1'),
('420300', '420000', '十堰市', '1', '420300', 'S', '1', '1'),
('420302', '420300', '茅箭区', '1', '420302', null, '2', '1'),
('420303', '420300', '张湾区', '1', '420303', null, '2', '1'),
('420321', '420300', '郧县', '1', '420321', null, '2', '1'),
('420322', '420300', '郧西县', '1', '420322', null, '2', '1'),
('420323', '420300', '竹山县', '1', '420323', null, '2', '1'),
('420324', '420300', '竹溪县', '1', '420324', null, '2', '1'),
('420325', '420300', '房县', '1', '420325', null, '2', '1'),
('420381', '420300', '丹江口市', '1', '420381', null, '2', '1'),
('420500', '420000', '宜昌市', '1', '420500', 'Y', '1', '1'),
('420502', '420500', '西陵区', '1', '420502', null, '2', '1'),
('420503', '420500', '伍家岗区', '1', '420503', null, '2', '1'),
('420504', '420500', '点军区', '1', '420504', null, '2', '1'),
('420505', '420500', '猇亭区', '1', '420505', null, '2', '1'),
('420506', '420500', '夷陵区', '1', '420506', null, '2', '1'),
('420525', '420500', '远安县', '1', '420525', null, '2', '1'),
('420526', '420500', '兴山县', '1', '420526', null, '2', '1'),
('420527', '420500', '秭归县', '1', '420527', null, '2', '1'),
('420528', '420500', '长阳土家族自治县', '1', '420528', null, '2', '1'),
('420529', '420500', '五峰土家族自治县', '1', '420529', null, '2', '1'),
('420581', '420500', '宜都市', '1', '420581', null, '2', '1'),
('420582', '420500', '当阳市', '1', '420582', null, '2', '1'),
('420583', '420500', '枝江市', '1', '420583', null, '2', '1'),
('420600', '420000', '襄樊市', '1', '420600', 'X', '1', '1'),
('420602', '420600', '襄城区', '1', '420602', null, '2', '1'),
('420606', '420600', '樊城区', '1', '420606', null, '2', '1'),
('420607', '420600', '襄阳区', '1', '420607', null, '2', '1'),
('420624', '420600', '南漳县', '1', '420624', null, '2', '1'),
('420625', '420600', '谷城县', '1', '420625', null, '2', '1'),
('420626', '420600', '保康县', '1', '420626', null, '2', '1'),
('420682', '420600', '老河口市', '1', '420682', null, '2', '1'),
('420683', '420600', '枣阳市', '1', '420683', null, '2', '1'),
('420684', '420600', '宜城市', '1', '420684', null, '2', '1'),
('420700', '420000', '鄂州市', '1', '420700', 'E', '1', '1'),
('420702', '420700', '粱子湖区', '1', '420702', null, '2', '1'),
('420703', '420700', '华容区', '1', '420703', null, '2', '1'),
('420704', '420700', '鄂城区', '1', '420704', null, '2', '1'),
('420800', '420000', '荆门市', '1', '420800', 'X', '1', '1'),
('420802', '420800', '东宝区', '1', '420802', null, '2', '1'),
('420804', '420800', '掇刀区', '1', '420804', null, '2', '1'),
('420821', '420800', '京山县', '1', '420821', null, '2', '1'),
('420822', '420800', '沙洋县', '1', '420822', null, '2', '1'),
('420881', '420800', '钟祥市', '1', '420881', null, '2', '1'),
('420900', '420000', '孝感市', '1', '420900', 'X', '1', '1'),
('420902', '420900', '孝南区', '1', '420902', null, '2', '1'),
('420921', '420900', '孝昌县', '1', '420921', null, '2', '1'),
('420922', '420900', '大悟县', '1', '420922', null, '2', '1'),
('420923', '420900', '云梦县', '1', '420923', null, '2', '1'),
('420981', '420900', '应城市', '1', '420981', null, '2', '1'),
('420982', '420900', '安陆市', '1', '420982', null, '2', '1'),
('420984', '420900', '汉川市', '1', '420984', null, '2', '1'),
('421000', '420000', '荆州市', '1', '421000', 'J', '1', '1'),
('421002', '421000', '沙市区', '1', '421002', null, '2', '1'),
('421003', '421000', '荆州区', '1', '421003', null, '2', '1'),
('421022', '421000', '公安县', '1', '421022', null, '2', '1'),
('421023', '421000', '监利县', '1', '421023', null, '2', '1'),
('421024', '421000', '江陵县', '1', '421024', null, '2', '1'),
('421081', '421000', '石首市', '1', '421081', null, '2', '1'),
('421083', '421000', '洪湖市', '1', '421083', null, '2', '1'),
('421087', '421000', '松滋市', '1', '421087', null, '2', '1'),
('421100', '420000', '黄冈市', '1', '421100', 'H', '1', '1'),
('421102', '421100', '黄州区', '1', '421102', null, '2', '1'),
('421121', '421100', '团风县', '1', '421121', null, '2', '1'),
('421122', '421100', '红安县', '1', '421122', null, '2', '1'),
('421123', '421100', '罗田县', '1', '421123', null, '2', '1'),
('421124', '421100', '英山县', '1', '421124', null, '2', '1'),
('421125', '421100', '浠水县', '1', '421125', null, '2', '1'),
('421126', '421100', '蕲春县', '1', '421126', null, '2', '1'),
('421127', '421100', '黄梅县', '1', '421127', null, '2', '1'),
('421181', '421100', '麻城市', '1', '421181', null, '2', '1'),
('421182', '421100', '武穴市', '1', '421182', null, '2', '1'),
('421200', '420000', '咸宁市', '1', '421200', 'X', '1', '1'),
('421202', '421200', '咸安区', '1', '421202', null, '2', '1'),
('421221', '421200', '嘉鱼县', '1', '421221', null, '2', '1'),
('421222', '421200', '通城县', '1', '421222', null, '2', '1'),
('421223', '421200', '崇阳县', '1', '421223', null, '2', '1'),
('421224', '421200', '通山县', '1', '421224', null, '2', '1'),
('421281', '421200', '赤壁市', '1', '421281', null, '2', '1'),
('421300', '420000', '随州市', '1', '421300', 'S', '1', '1'),
('421302', '421300', '曾都区', '1', '421302', null, '2', '1'),
('421381', '421300', '广水市', '1', '421381', null, '2', '1'),
('422800', '420000', '恩施州', '1', '422800', 'E', '1', '1'),
('422801', '422800', '恩施市', '1', '422801', null, '2', '1'),
('422802', '422800', '利川市', '1', '422802', null, '2', '1'),
('422822', '422800', '建始县', '1', '422822', null, '2', '1'),
('422823', '422800', '巴东县', '1', '422823', null, '2', '1'),
('422825', '422800', '宣恩县', '1', '422825', null, '2', '1'),
('422826', '422800', '咸丰县', '1', '422826', null, '2', '1'),
('422827', '422800', '来凤县', '1', '422827', null, '2', '1'),
('422828', '422800', '鹤峰县', '1', '422828', null, '2', '1'),
('430000', '0', '湖南省', '1', '430000', 'H', '0', '1'),
('430100', '430000', '长沙市', '1', '430100', 'C', '1', '1'),
('430102', '430100', '芙蓉区', '1', '430102', null, '2', '1');
INSERT INTO `wst_areas` VALUES ('430103', '430100', '天心区', '1', '430103', null, '2', '1'),
('430104', '430100', '岳麓区', '1', '430104', null, '2', '1'),
('430105', '430100', '开福区', '1', '430105', null, '2', '1'),
('430111', '430100', '雨花区', '1', '430111', null, '2', '1'),
('430121', '430100', '长沙县', '1', '430121', null, '2', '1'),
('430122', '430100', '望城县', '1', '430122', null, '2', '1'),
('430124', '430100', '宁乡县', '1', '430124', null, '2', '1'),
('430181', '430100', '浏阳市', '1', '430181', null, '2', '1'),
('430200', '430000', '株洲市', '1', '430200', 'Z', '1', '1'),
('430202', '430200', '荷塘区', '1', '430202', null, '2', '1'),
('430203', '430200', '芦淞区', '1', '430203', null, '2', '1'),
('430204', '430200', '石峰区', '1', '430204', null, '2', '1'),
('430211', '430200', '天元区', '1', '430211', null, '2', '1'),
('430221', '430200', '株洲县', '1', '430221', null, '2', '1'),
('430223', '430200', '攸县', '1', '430223', null, '2', '1'),
('430224', '430200', '茶陵县', '1', '430224', null, '2', '1'),
('430225', '430200', '炎陵县', '1', '430225', null, '2', '1'),
('430281', '430200', '醴陵市', '1', '430281', null, '2', '1'),
('430300', '430000', '湘潭市', '1', '430300', 'X', '1', '1'),
('430302', '430300', '雨湖区', '1', '430302', null, '2', '1'),
('430304', '430300', '岳塘区', '1', '430304', null, '2', '1'),
('430321', '430300', '湘潭县', '1', '430321', null, '2', '1'),
('430381', '430300', '湘乡市', '1', '430381', null, '2', '1'),
('430382', '430300', '韶山市', '1', '430382', null, '2', '1'),
('430400', '430000', '衡阳市', '1', '430400', 'H', '1', '1'),
('430405', '430400', '珠晖区', '1', '430405', null, '2', '1'),
('430406', '430400', '雁峰区', '1', '430406', null, '2', '1'),
('430407', '430400', '石鼓区', '1', '430407', null, '2', '1'),
('430408', '430400', '蒸湘区', '1', '430408', null, '2', '1'),
('430412', '430400', '南岳区', '1', '430412', null, '2', '1'),
('430421', '430400', '衡阳县', '1', '430421', null, '2', '1'),
('430422', '430400', '衡南县', '1', '430422', null, '2', '1'),
('430423', '430400', '衡山县', '1', '430423', null, '2', '1'),
('430424', '430400', '衡东县', '1', '430424', null, '2', '1'),
('430426', '430400', '祁东县', '1', '430426', null, '2', '1'),
('430481', '430400', '耒阳市', '1', '430481', null, '2', '1'),
('430482', '430400', '常宁市', '1', '430482', null, '2', '1'),
('430500', '430000', '邵阳市', '1', '430500', 'S', '1', '1'),
('430502', '430500', '双清区', '1', '430502', null, '2', '1'),
('430503', '430500', '大祥区', '1', '430503', null, '2', '1'),
('430511', '430500', '北塔区', '1', '430511', null, '2', '1'),
('430521', '430500', '邵东县', '1', '430521', null, '2', '1'),
('430522', '430500', '新邵县', '1', '430522', null, '2', '1'),
('430523', '430500', '邵阳县', '1', '430523', null, '2', '1'),
('430524', '430500', '隆回县', '1', '430524', null, '2', '1'),
('430525', '430500', '洞口县', '1', '430525', null, '2', '1'),
('430527', '430500', '绥宁县', '1', '430527', null, '2', '1'),
('430528', '430500', '新宁县', '1', '430528', null, '2', '1'),
('430529', '430500', '城步苗族自治县', '1', '430529', null, '2', '1'),
('430581', '430500', '武冈市', '1', '430581', null, '2', '1'),
('430600', '430000', '岳阳市', '1', '430600', 'Y', '1', '1'),
('430602', '430600', '岳阳楼区', '1', '430602', null, '2', '1'),
('430603', '430600', '云溪区', '1', '430603', null, '2', '1'),
('430611', '430600', '君山区', '1', '430611', null, '2', '1'),
('430621', '430600', '岳阳县', '1', '430621', null, '2', '1'),
('430623', '430600', '华容县', '1', '430623', null, '2', '1'),
('430624', '430600', '湘阴县', '1', '430624', null, '2', '1'),
('430626', '430600', '平江县', '1', '430626', null, '2', '1'),
('430681', '430600', '汩罗市', '1', '430681', null, '2', '1'),
('430682', '430600', '临湘市', '1', '430682', null, '2', '1'),
('430700', '430000', '常德市', '1', '430700', 'C', '1', '1'),
('430702', '430700', '武陵区', '1', '430702', null, '2', '1'),
('430703', '430700', '鼎城区', '1', '430703', null, '2', '1'),
('430721', '430700', '安乡县', '1', '430721', null, '2', '1'),
('430722', '430700', '汉寿县', '1', '430722', null, '2', '1'),
('430723', '430700', '澧县', '1', '430723', null, '2', '1'),
('430724', '430700', '临澧县', '1', '430724', null, '2', '1'),
('430725', '430700', '桃源县', '1', '430725', null, '2', '1'),
('430726', '430700', '石门县', '1', '430726', null, '2', '1'),
('430781', '430700', '津市市', '1', '430781', null, '2', '1'),
('430800', '430000', '张家界市', '1', '430800', 'Z', '1', '1'),
('430802', '430800', '永定区', '1', '430802', null, '2', '1'),
('430811', '430800', '武陵源区', '1', '430811', null, '2', '1'),
('430821', '430800', '慈利县', '1', '430821', null, '2', '1'),
('430822', '430800', '桑植县', '1', '430822', null, '2', '1'),
('430900', '430000', '益阳市', '1', '430900', 'Y', '1', '1'),
('430902', '430900', '资阳区', '1', '430902', null, '2', '1'),
('430903', '430900', '赫山区', '1', '430903', null, '2', '1'),
('430921', '430900', '南县', '1', '430921', null, '2', '1'),
('430922', '430900', '桃江县', '1', '430922', null, '2', '1'),
('430923', '430900', '安化县', '1', '430923', null, '2', '1'),
('430981', '430900', '沅江市', '1', '430981', null, '2', '1'),
('431000', '430000', '郴州市', '1', '431000', 'C', '1', '1'),
('431002', '431000', '北湖区', '1', '431002', null, '2', '1'),
('431003', '431000', '苏仙区', '1', '431003', null, '2', '1'),
('431021', '431000', '桂阳县', '1', '431021', null, '2', '1'),
('431022', '431000', '宜章县', '1', '431022', null, '2', '1'),
('431023', '431000', '永兴县', '1', '431023', null, '2', '1'),
('431024', '431000', '嘉禾县', '1', '431024', null, '2', '1'),
('431025', '431000', '临武县', '1', '431025', null, '2', '1'),
('431026', '431000', '汝城县', '1', '431026', null, '2', '1'),
('431027', '431000', '桂东县', '1', '431027', null, '2', '1'),
('431028', '431000', '安仁县', '1', '431028', null, '2', '1'),
('431081', '431000', '资兴市', '1', '431081', null, '2', '1'),
('431100', '430000', '永州市', '1', '431100', 'Y', '1', '1'),
('431102', '431100', '零陵区', '1', '431102', null, '2', '1'),
('431103', '431100', '冷水滩区', '1', '431103', null, '2', '1'),
('431121', '431100', '祁阳县', '1', '431121', null, '2', '1'),
('431122', '431100', '东安县', '1', '431122', null, '2', '1'),
('431123', '431100', '双牌县', '1', '431123', null, '2', '1');
INSERT INTO `wst_areas` VALUES ('431124', '431100', '道县', '1', '431124', null, '2', '1'),
('431125', '431100', '江永县', '1', '431125', null, '2', '1'),
('431126', '431100', '宁远县', '1', '431126', null, '2', '1'),
('431127', '431100', '蓝山县', '1', '431127', null, '2', '1'),
('431128', '431100', '新田县', '1', '431128', null, '2', '1'),
('431129', '431100', '江华县', '1', '431129', null, '2', '1'),
('431200', '430000', '怀化市', '1', '431200', 'H', '1', '1'),
('431202', '431200', '鹤城区', '1', '431202', null, '2', '1'),
('431221', '431200', '中方县', '1', '431221', null, '2', '1'),
('431222', '431200', '沅陵县', '1', '431222', null, '2', '1'),
('431223', '431200', '辰溪县', '1', '431223', null, '2', '1'),
('431224', '431200', '溆浦县', '1', '431224', null, '2', '1'),
('431225', '431200', '会同县', '1', '431225', null, '2', '1'),
('431226', '431200', '麻阳苗族自治县', '1', '431226', null, '2', '1'),
('431227', '431200', '新晃侗族自治县', '1', '431227', null, '2', '1'),
('431228', '431200', '芷江侗族自治县', '1', '431228', null, '2', '1'),
('431229', '431200', '靖州苗族侗族县', '1', '431229', null, '2', '1'),
('431230', '431200', '通道侗族自治县', '1', '431230', null, '2', '1'),
('431281', '431200', '洪江市', '1', '431281', null, '2', '1'),
('431300', '430000', '娄底市', '1', '431300', 'L', '1', '1'),
('431302', '431300', '娄星区', '1', '431302', null, '2', '1'),
('431321', '431300', '双峰县', '1', '431321', null, '2', '1'),
('431322', '431300', '新化县', '1', '431322', null, '2', '1'),
('431381', '431300', '冷水江市', '1', '431381', null, '2', '1'),
('431382', '431300', '涟源市', '1', '431382', null, '2', '1'),
('433100', '430000', '湘西土家族苗族自治州', '1', '433100', 'X', '1', '1'),
('433101', '433100', '吉首市', '1', '433101', null, '2', '1'),
('433122', '433100', '泸溪县', '1', '433122', null, '2', '1'),
('433123', '433100', '凤凰县', '1', '433123', null, '2', '1'),
('433124', '433100', '花垣县', '1', '433124', null, '2', '1'),
('433125', '433100', '保靖县', '1', '433125', null, '2', '1'),
('433126', '433100', '古丈县', '1', '433126', null, '2', '1'),
('433127', '433100', '永顺县', '1', '433127', null, '2', '1'),
('433130', '433100', '龙山县', '1', '433130', null, '2', '1'),
('440100', '820332', '广州市', '1', '440100', 'G', '1', '1'),
('440103', '440100', '荔湾区', '1', '440103', null, '2', '1'),
('440104', '440100', '越秀区', '1', '440104', null, '2', '1'),
('440105', '440100', '海珠区', '1', '440105', null, '2', '1'),
('440106', '440100', '天河区', '1', '440106', null, '2', '1'),
('440111', '440100', '白云区', '1', '440111', null, '2', '1'),
('440112', '440100', '黄埔区', '1', '440112', null, '2', '1'),
('440113', '440100', '番禺区', '1', '440113', null, '2', '1'),
('440114', '440100', '花都区', '1', '440114', null, '2', '1'),
('440115', '440100', '南沙区', '1', '440115', null, '2', '1'),
('440116', '440100', '萝岗区', '1', '440116', null, '2', '1'),
('440183', '440100', '增城市', '1', '440183', null, '2', '1'),
('440184', '440100', '从化市', '1', '440184', null, '2', '1'),
('440200', '820332', '韶关市', '1', '440200', 'S', '1', '1'),
('440203', '440200', '武江区', '1', '440203', null, '2', '1'),
('440204', '440200', '浈江区', '1', '440204', null, '2', '1'),
('440205', '440200', '曲江区', '1', '440205', null, '2', '1'),
('440222', '440200', '始兴县', '1', '440222', null, '2', '1'),
('440224', '440200', '仁化县', '1', '440224', null, '2', '1'),
('440229', '440200', '翁源县', '1', '440229', null, '2', '1'),
('440232', '440200', '乳源瑶族自治县', '1', '440232', null, '2', '1'),
('440233', '440200', '新丰县', '1', '440233', null, '2', '1'),
('440281', '440200', '乐昌市', '1', '440281', null, '2', '1'),
('440282', '440200', '南雄市', '1', '440282', null, '2', '1'),
('440300', '820332', '深圳市', '1', '440300', 'S', '1', '1'),
('440303', '440300', '罗湖区', '1', '440303', null, '2', '1'),
('440304', '440300', '福田区', '1', '440304', null, '2', '1'),
('440305', '440300', '南山区', '1', '440305', null, '2', '1'),
('440306', '440300', '宝安区', '1', '440306', null, '2', '1'),
('440307', '440300', '龙岗区', '1', '440307', null, '2', '1'),
('440308', '440300', '盐田区', '1', '440308', null, '2', '1'),
('440400', '820332', '珠海市', '1', '440400', 'Z', '1', '1'),
('440402', '440400', '香洲区', '1', '440402', null, '2', '1'),
('440403', '440400', '斗门区', '1', '440403', null, '2', '1'),
('440404', '440400', '金湾区', '1', '440404', null, '2', '1'),
('440600', '820332', '佛山市', '1', '440600', 'F', '1', '1'),
('440604', '440600', '禅城区', '1', '440604', null, '2', '1'),
('440605', '440600', '南海区', '1', '440605', null, '2', '1'),
('440606', '440600', '顺德区', '1', '440606', null, '2', '1'),
('440607', '440600', '三水区', '1', '440607', null, '2', '1'),
('440608', '440600', '高明区', '1', '440608', null, '2', '1'),
('440700', '820332', '江门市', '1', '440700', 'J', '1', '1'),
('440703', '440700', '蓬江区', '1', '440703', null, '2', '1'),
('440704', '440700', '江海区', '1', '440704', null, '2', '1'),
('440705', '440700', '新会区', '1', '440705', null, '2', '1'),
('440781', '440700', '台山市', '1', '440781', null, '2', '1'),
('440783', '440700', '开平市', '1', '440783', null, '2', '1'),
('440784', '440700', '鹤山市', '1', '440784', null, '2', '1'),
('440785', '440700', '恩平市', '1', '440785', null, '2', '1'),
('440800', '820332', '湛江市', '1', '440800', 'Z', '1', '1'),
('440802', '440800', '湛江市赤坎区', '1', '440802', null, '2', '1'),
('440803', '440800', '湛江市霞山区', '1', '440803', null, '2', '1'),
('440804', '440800', '湛江市坡头区', '1', '440804', null, '2', '1'),
('440811', '440800', '湛江市麻章区', '1', '440811', null, '2', '1'),
('440823', '440800', '遂溪县', '1', '440823', null, '2', '1'),
('440825', '440800', '徐闻县', '1', '440825', null, '2', '1'),
('440881', '440800', '廉江市', '1', '440881', null, '2', '1'),
('440882', '440800', '雷州市', '1', '440882', null, '2', '1'),
('440883', '440800', '吴川市', '1', '440883', null, '2', '1'),
('440900', '820332', '茂名市', '1', '440900', 'M', '1', '1'),
('440902', '440900', '茂南区', '1', '440902', null, '2', '1'),
('440903', '440900', '茂港区', '1', '440903', null, '2', '1'),
('440923', '440900', '电白县', '1', '440923', null, '2', '1'),
('440981', '440900', '高州市', '1', '440981', null, '2', '1'),
('440982', '440900', '化州市', '1', '440982', null, '2', '1'),
('440983', '440900', '信宜市', '1', '440983', null, '2', '1');
INSERT INTO `wst_areas` VALUES ('441200', '820332', '肇庆市', '1', '441200', 'Z', '1', '1'),
('441202', '441200', '端州区', '1', '441202', null, '2', '1'),
('441203', '441200', '鼎湖区', '1', '441203', null, '2', '1'),
('441223', '441200', '广宁县', '1', '441223', null, '2', '1'),
('441224', '441200', '怀集县', '1', '441224', null, '2', '1'),
('441225', '441200', '封开县', '1', '441225', null, '2', '1'),
('441226', '441200', '德庆县', '1', '441226', null, '2', '1'),
('441283', '441200', '高要市', '1', '441283', null, '2', '1'),
('441284', '441200', '四会市', '1', '441284', null, '2', '1'),
('441300', '820332', '惠州市', '1', '441300', 'H', '1', '1'),
('441302', '441300', '惠城区', '1', '441302', null, '2', '1'),
('441303', '441300', '惠阳区', '1', '441303', null, '2', '1'),
('441322', '441300', '博罗县', '1', '441322', null, '2', '1'),
('441323', '441300', '惠东县', '1', '441323', null, '2', '1'),
('441324', '441300', '龙门县', '1', '441324', null, '2', '1'),
('441400', '820332', '梅州市', '1', '441400', 'M', '1', '1'),
('441402', '441400', '梅江区', '1', '441402', null, '2', '1'),
('441421', '441400', '梅县', '1', '441421', null, '2', '1'),
('441422', '441400', '大埔县', '1', '441422', null, '2', '1'),
('441423', '441400', '丰顺县', '1', '441423', null, '2', '1'),
('441424', '441400', '五华县', '1', '441424', null, '2', '1'),
('441426', '441400', '平远县', '1', '441426', null, '2', '1'),
('441427', '441400', '蕉岭县', '1', '441427', null, '2', '1'),
('441481', '441400', '兴宁市', '1', '441481', null, '2', '1'),
('441500', '820332', '汕尾市', '1', '441500', 'S', '1', '1'),
('441502', '441500', '城区', '1', '441502', null, '2', '1'),
('441521', '441500', '海丰县', '1', '441521', null, '2', '1'),
('441523', '441500', '陆河县', '1', '441523', null, '2', '1'),
('441581', '441500', '陆丰市', '1', '441581', null, '2', '1'),
('441600', '820332', '河源市', '1', '441600', 'H', '1', '1'),
('441602', '441600', '源城区', '1', '441602', null, '2', '1'),
('441621', '441600', '紫金县', '1', '441621', null, '2', '1'),
('441622', '441600', '龙川县', '1', '441622', null, '2', '1'),
('441623', '441600', '连平县', '1', '441623', null, '2', '1'),
('441624', '441600', '和平县', '1', '441624', null, '2', '1'),
('441625', '441600', '东源县', '1', '441625', null, '2', '1'),
('441700', '820332', '阳江市', '1', '441700', 'Y', '1', '1'),
('441702', '441700', '江城区', '1', '441702', null, '2', '1'),
('441721', '441700', '阳西县', '1', '441721', null, '2', '1'),
('441723', '441700', '阳东县', '1', '441723', null, '2', '1'),
('441781', '441700', '阳春市', '1', '441781', null, '2', '1'),
('441800', '820332', '清远市', '1', '441800', 'Q', '1', '1'),
('441802', '441800', '清城区', '1', '441802', null, '2', '1'),
('441821', '441800', '佛冈县', '1', '441821', null, '2', '1'),
('441823', '441800', '阳山县', '1', '441823', null, '2', '1'),
('441825', '441800', '连山县', '1', '441825', null, '2', '1'),
('441826', '441800', '连南瑶族自治县', '1', '441826', null, '2', '1'),
('441827', '441800', '清新县', '1', '441827', null, '2', '1'),
('441881', '441800', '英德市', '1', '441881', null, '2', '1'),
('441882', '441800', '连州市', '1', '441882', null, '2', '1'),
('441900', '820332', '东莞市', '1', '441900', 'D', '1', '1'),
('442000', '820332', '中山市', '1', '442000', 'Z', '1', '1'),
('445300', '820332', '云浮市', '1', '445300', 'Y', '1', '1'),
('445302', '445300', '云城区', '1', '445302', null, '2', '1'),
('445321', '445300', '新兴县', '1', '445321', null, '2', '1'),
('445322', '445300', '郁南县', '1', '445322', null, '2', '1'),
('445323', '445300', '云安县', '1', '445323', null, '2', '1'),
('445381', '445300', '罗定市', '1', '445381', null, '2', '1'),
('450000', '0', '广西壮族自治区', '1', '450000', 'G', '0', '1'),
('450100', '450000', '南宁市', '1', '450100', 'N', '1', '1'),
('450102', '450100', '兴宁区', '1', '450102', null, '2', '1'),
('450103', '450100', '青秀区', '1', '450103', null, '2', '1'),
('450105', '450100', '江南区', '1', '450105', null, '2', '1'),
('450107', '450100', '西乡塘区', '1', '450107', null, '2', '1'),
('450108', '450100', '良庆区', '1', '450108', null, '2', '1'),
('450109', '450100', '邕宁区', '1', '450109', null, '2', '1'),
('450122', '450100', '武鸣县', '1', '450122', null, '2', '1'),
('450123', '450100', '隆安县', '1', '450123', null, '2', '1'),
('450124', '450100', '马山县', '1', '450124', null, '2', '1'),
('450125', '450100', '上林县', '1', '450125', null, '2', '1'),
('450126', '450100', '宾阳县', '1', '450126', null, '2', '1'),
('450127', '450100', '横县', '1', '450127', null, '2', '1'),
('450200', '450000', '柳州市', '1', '450200', 'L', '1', '1');
INSERT INTO `wst_areas` VALUES ('450202', '450200', '城中区', '1', '450202', null, '2', '1'),
('450203', '450200', '鱼峰区', '1', '450203', null, '2', '1'),
('450204', '450200', '柳南区', '1', '450204', null, '2', '1'),
('450205', '450200', '柳北区', '1', '450205', null, '2', '1'),
('450221', '450200', '柳江县', '1', '450221', null, '2', '1'),
('450222', '450200', '柳城县', '1', '450222', null, '2', '1'),
('450223', '450200', '鹿寨县', '1', '450223', null, '2', '1'),
('450224', '450200', '融安县', '1', '450224', null, '2', '1'),
('450225', '450200', '融水苗族自治县', '1', '450225', null, '2', '1'),
('450226', '450200', '三江侗族自治县', '1', '450226', null, '2', '1'),
('450300', '450000', '桂林市', '1', '450300', 'G', '1', '1'),
('450302', '450300', '秀峰区', '1', '450302', null, '2', '1'),
('450303', '450300', '叠彩区', '1', '450303', null, '2', '1'),
('450304', '450300', '象山区', '1', '450304', null, '2', '1'),
('450305', '450300', '七星区', '1', '450305', null, '2', '1'),
('450311', '450300', '雁山区', '1', '450311', null, '2', '1'),
('450321', '450300', '阳朔县', '1', '450321', null, '2', '1'),
('450322', '450300', '临桂县', '1', '450322', null, '2', '1'),
('450323', '450300', '灵川县', '1', '450323', null, '2', '1'),
('450324', '450300', '全州县', '1', '450324', null, '2', '1'),
('450325', '450300', '兴安县', '1', '450325', null, '2', '1'),
('450326', '450300', '永福县', '1', '450326', null, '2', '1'),
('450327', '450300', '灌阳县', '1', '450327', null, '2', '1'),
('450328', '450300', '龙胜各族自治县', '1', '450328', null, '2', '1'),
('450329', '450300', '资源县', '1', '450329', null, '2', '1'),
('450330', '450300', '平乐县', '1', '450330', null, '2', '1'),
('450331', '450300', '荔浦县', '1', '450331', null, '2', '1'),
('450332', '450300', '恭城县', '1', '450332', null, '2', '1'),
('450400', '450000', '梧州市', '1', '450400', 'W', '1', '1'),
('450403', '450400', '万秀区', '1', '450403', null, '2', '1'),
('450404', '450400', '蝶山区', '1', '450404', null, '2', '1'),
('450405', '450400', '长洲区', '1', '450405', null, '2', '1'),
('450421', '450400', '苍梧县', '1', '450421', null, '2', '1'),
('450422', '450400', '藤县', '1', '450422', null, '2', '1'),
('450423', '450400', '蒙山县', '1', '450423', null, '2', '1'),
('450481', '450400', '岑溪市', '1', '450481', null, '2', '1'),
('450500', '450000', '北海市', '1', '450500', 'B', '1', '1'),
('450502', '450500', '海城区', '1', '450502', null, '2', '1'),
('450503', '450500', '银海区', '1', '450503', null, '2', '1');
INSERT INTO `wst_areas` VALUES ('450512', '450500', '铁山港区', '1', '450512', null, '2', '1'),
('450521', '450500', '合浦县', '1', '450521', null, '2', '1'),
('450600', '450000', '防城港市', '1', '450600', 'F', '1', '1'),
('450602', '450600', '港口区', '1', '450602', null, '2', '1'),
('450603', '450600', '防城区', '1', '450603', null, '2', '1'),
('450621', '450600', '上思县', '1', '450621', null, '2', '1'),
('450681', '450600', '东兴市', '1', '450681', null, '2', '1'),
('450700', '450000', '钦州市', '1', '450700', 'Q', '1', '1'),
('450702', '450700', '钦南区', '1', '450702', null, '2', '1'),
('450703', '450700', '钦北区', '1', '450703', null, '2', '1'),
('450721', '450700', '灵山县', '1', '450721', null, '2', '1'),
('450722', '450700', '浦北县', '1', '450722', null, '2', '1'),
('450800', '450000', '贵港市', '1', '450800', 'G', '1', '1'),
('450802', '450800', '港北区', '1', '450802', null, '2', '1'),
('450803', '450800', '港南区', '1', '450803', null, '2', '1'),
('450804', '450800', '覃塘区', '1', '450804', null, '2', '1'),
('450821', '450800', '平南县', '1', '450821', null, '2', '1'),
('450881', '450800', '桂平市', '1', '450881', null, '2', '1'),
('450900', '450000', '玉林市', '1', '450900', 'Y', '1', '1'),
('450902', '450900', '玉州区', '1', '450902', null, '2', '1'),
('450921', '450900', '容县', '1', '450921', null, '2', '1'),
('450922', '450900', '陆川县', '1', '450922', null, '2', '1'),
('450923', '450900', '博白县', '1', '450923', null, '2', '1'),
('450924', '450900', '兴业县', '1', '450924', null, '2', '1'),
('450981', '450900', '北流市', '1', '450981', null, '2', '1'),
('451000', '450000', '百色市', '1', '451000', 'B', '1', '1'),
('451002', '451000', '右江区', '1', '451002', null, '2', '1'),
('451021', '451000', '田阳县', '1', '451021', null, '2', '1'),
('451022', '451000', '田东县', '1', '451022', null, '2', '1'),
('451023', '451000', '平果县', '1', '451023', null, '2', '1'),
('451024', '451000', '德保县', '1', '451024', null, '2', '1'),
('451025', '451000', '靖西县', '1', '451025', null, '2', '1'),
('451026', '451000', '那坡县', '1', '451026', null, '2', '1'),
('451027', '451000', '凌云县', '1', '451027', null, '2', '1'),
('451028', '451000', '乐业县', '1', '451028', null, '2', '1'),
('451029', '451000', '田林县', '1', '451029', null, '2', '1'),
('451030', '451000', '西林县', '1', '451030', null, '2', '1'),
('451031', '451000', '隆林各族自治县', '1', '451031', null, '2', '1'),
('451100', '450000', '贺州市', '1', '451100', 'H', '1', '1'),
('451102', '451100', '八步区', '1', '451102', null, '2', '1'),
('451121', '451100', '昭平县', '1', '451121', null, '2', '1'),
('451122', '451100', '钟山县', '1', '451122', null, '2', '1'),
('451123', '451100', '富川瑶族自治县', '1', '451123', null, '2', '1'),
('451200', '450000', '河池市', '1', '451200', 'H', '1', '1'),
('451202', '451200', '金城江区', '1', '451202', null, '2', '1'),
('451221', '451200', '南丹县', '1', '451221', null, '2', '1'),
('451222', '451200', '天峨县', '1', '451222', null, '2', '1'),
('451223', '451200', '凤山县', '1', '451223', null, '2', '1'),
('451224', '451200', '东兰县', '1', '451224', null, '2', '1'),
('451225', '451200', '罗城仫佬族自治县', '1', '451225', null, '2', '1'),
('451226', '451200', '环江毛南族自治县', '1', '451226', null, '2', '1'),
('451227', '451200', '巴马瑶族自治县', '1', '451227', null, '2', '1'),
('451228', '451200', '都安瑶族自治县', '1', '451228', null, '2', '1'),
('451229', '451200', '大化瑶族自治县', '1', '451229', null, '2', '1'),
('451281', '451200', '宜州市', '1', '451281', null, '2', '1'),
('451300', '450000', '来宾市', '1', '451300', 'L', '1', '1'),
('451302', '451300', '兴宾区', '1', '451302', null, '2', '1'),
('451321', '451300', '忻城县', '1', '451321', null, '2', '1'),
('451322', '451300', '象州县', '1', '451322', null, '2', '1'),
('451323', '451300', '武宣县', '1', '451323', null, '2', '1'),
('451324', '451300', '金秀瑶族自治县', '1', '451324', null, '2', '1'),
('451381', '451300', '合山市', '1', '451381', null, '2', '1'),
('451400', '450000', '崇左市', '1', '451400', 'C', '1', '1'),
('451402', '451400', '江州区', '1', '451402', null, '2', '1'),
('451421', '451400', '扶绥县', '1', '451421', null, '2', '1'),
('451422', '451400', '宁明县', '1', '451422', null, '2', '1'),
('451423', '451400', '龙州县', '1', '451423', null, '2', '1'),
('451424', '451400', '大新县', '1', '451424', null, '2', '1'),
('451425', '451400', '天等县', '1', '451425', null, '2', '1'),
('451481', '451400', '凭祥市', '1', '451481', null, '2', '1'),
('460000', '0', '海南省', '1', '460000', 'H', '0', '1'),
('460100', '460000', '海口市', '1', '460100', 'H', '1', '1'),
('460105', '460100', '秀英区', '1', '460105', null, '2', '1'),
('460106', '460100', '龙华区', '1', '460106', null, '2', '1'),
('460107', '460100', '琼山区', '1', '460107', null, '2', '1'),
('460108', '460100', '美兰区', '1', '460108', null, '2', '1'),
('460200', '460000', '三亚市', '1', '460200', 'S', '1', '1'),
('500000', '0', '重庆市', '1', '500000', 'C', '0', '1'),
('510000', '0', '四川省', '1', '510000', 'S', '0', '1'),
('510100', '510000', '成都市', '1', '510100', 'C', '1', '1'),
('510104', '510100', '锦江区', '1', '510104', null, '2', '1'),
('510105', '510100', '青羊区', '1', '510105', null, '2', '1'),
('510106', '510100', '金牛区', '1', '510106', null, '2', '1'),
('510107', '510100', '武侯区', '1', '510107', null, '2', '1'),
('510108', '510100', '成华区', '1', '510108', null, '2', '1'),
('510112', '510100', '龙泉驿区', '1', '510112', null, '2', '1'),
('510113', '510100', '青白江区', '1', '510113', null, '2', '1'),
('510114', '510100', '新都区', '1', '510114', null, '2', '1');
INSERT INTO `wst_areas` VALUES ('510115', '510100', '温江区', '1', '510115', null, '2', '1'),
('510121', '510100', '金堂县', '1', '510121', null, '2', '1'),
('510122', '510100', '双流县', '1', '510122', null, '2', '1'),
('510124', '510100', '郫县', '1', '510124', null, '2', '1'),
('510129', '510100', '大邑县', '1', '510129', null, '2', '1'),
('510131', '510100', '蒲江县', '1', '510131', null, '2', '1'),
('510132', '510100', '新津县', '1', '510132', null, '2', '1'),
('510181', '510100', '都江堰市', '1', '510181', null, '2', '1'),
('510182', '510100', '彭州市', '1', '510182', null, '2', '1'),
('510183', '510100', '邛崃市', '1', '510183', null, '2', '1'),
('510184', '510100', '崇州市', '1', '510184', null, '2', '1'),
('510300', '510000', '自贡市', '1', '510300', 'Z', '1', '1'),
('510302', '510300', '自流井区', '1', '510302', null, '2', '1'),
('510303', '510300', '贡井区', '1', '510303', null, '2', '1'),
('510304', '510300', '大安区', '1', '510304', null, '2', '1'),
('510311', '510300', '沿滩区', '1', '510311', null, '2', '1'),
('510321', '510300', '荣县', '1', '510321', null, '2', '1'),
('510322', '510300', '富顺县', '1', '510322', null, '2', '1'),
('510400', '510000', '攀枝花市', '1', '510400', 'P', '1', '1'),
('510402', '510400', '攀枝花东区', '1', '510402', null, '2', '1'),
('510403', '510400', '西区', '1', '510403', null, '2', '1'),
('510411', '510400', '仁和区', '1', '510411', null, '2', '1'),
('510421', '510400', '米易县', '1', '510421', null, '2', '1'),
('510422', '510400', '盐边县', '1', '510422', null, '2', '1'),
('510500', '510000', '泸州市', '1', '510500', 'L', '1', '1'),
('510502', '510500', '江阳区', '1', '510502', null, '2', '1'),
('510503', '510500', '纳溪区', '1', '510503', null, '2', '1'),
('510504', '510500', '龙马潭区', '1', '510504', null, '2', '1'),
('510521', '510500', '泸县', '1', '510521', null, '2', '1'),
('510522', '510500', '合江县', '1', '510522', null, '2', '1'),
('510524', '510500', '叙永县', '1', '510524', null, '2', '1'),
('510525', '510500', '古蔺县', '1', '510525', null, '2', '1'),
('510600', '510000', '德阳市', '1', '510600', 'D', '1', '1'),
('510603', '510600', '旌阳区', '1', '510603', null, '2', '1'),
('510623', '510600', '中江县', '1', '510623', null, '2', '1'),
('510626', '510600', '罗江县', '1', '510626', null, '2', '1'),
('510681', '510600', '广汉市', '1', '510681', null, '2', '1'),
('510682', '510600', '什邡市', '1', '510682', null, '2', '1'),
('510683', '510600', '绵竹市', '1', '510683', null, '2', '1'),
('510700', '510000', '绵阳市', '1', '510700', 'M', '1', '1'),
('510703', '510700', '涪城区', '1', '510703', null, '2', '1'),
('510704', '510700', '游仙区', '1', '510704', null, '2', '1'),
('510722', '510700', '三台县', '1', '510722', null, '2', '1'),
('510723', '510700', '盐亭县', '1', '510723', null, '2', '1'),
('510724', '510700', '安县', '1', '510724', null, '2', '1'),
('510725', '510700', '梓潼县', '1', '510725', null, '2', '1'),
('510726', '510700', '北川羌族自治县', '1', '510726', null, '2', '1'),
('510727', '510700', '平武县', '1', '510727', null, '2', '1'),
('510781', '510700', '江油市', '1', '510781', null, '2', '1'),
('510800', '510000', '广元市', '1', '510800', 'G', '1', '1'),
('510802', '510800', '市中区', '1', '510802', null, '2', '1'),
('510811', '510800', '元坝区', '1', '510811', null, '2', '1'),
('510812', '510800', '朝天区', '1', '510812', null, '2', '1'),
('510821', '510800', '旺苍县', '1', '510821', null, '2', '1'),
('510822', '510800', '青川县', '1', '510822', null, '2', '1'),
('510823', '510800', '剑阁县', '1', '510823', null, '2', '1'),
('510824', '510800', '苍溪县', '1', '510824', null, '2', '1'),
('510900', '510000', '遂宁市', '1', '510900', 'S', '1', '1'),
('510903', '510900', '船山区', '1', '510903', null, '2', '1'),
('510904', '510900', '安居区', '1', '510904', null, '2', '1'),
('510921', '510900', '蓬溪县', '1', '510921', null, '2', '1'),
('510922', '510900', '射洪县', '1', '510922', null, '2', '1'),
('510923', '510900', '大英县', '1', '510923', null, '2', '1'),
('511000', '510000', '内江市', '1', '511000', 'N', '1', '1'),
('511002', '511000', '市中区', '1', '511002', null, '2', '1'),
('511011', '511000', '东兴区', '1', '511011', null, '2', '1'),
('511024', '511000', '威远县', '1', '511024', null, '2', '1'),
('511025', '511000', '资中县', '1', '511025', null, '2', '1'),
('511028', '511000', '隆昌县', '1', '511028', null, '2', '1'),
('511100', '510000', '乐山市', '1', '511100', 'L', '1', '1'),
('511102', '511100', '市中区', '1', '511102', null, '2', '1'),
('511111', '511100', '沙湾区', '1', '511111', null, '2', '1'),
('511112', '511100', '五通桥区', '1', '511112', null, '2', '1'),
('511113', '511100', '金口河区', '1', '511113', null, '2', '1'),
('511123', '511100', '犍为县', '1', '511123', null, '2', '1'),
('511124', '511100', '井研县', '1', '511124', null, '2', '1'),
('511126', '511100', '夹江县', '1', '511126', null, '2', '1'),
('511129', '511100', '沐川县', '1', '511129', null, '2', '1'),
('511132', '511100', '峨边彝族自治县', '1', '511132', null, '2', '1'),
('511133', '511100', '马边彝族自治县', '1', '511133', null, '2', '1'),
('511181', '511100', '峨眉山市', '1', '511181', null, '2', '1'),
('511300', '510000', '南充市', '1', '511300', 'N', '1', '1'),
('511302', '511300', '顺庆区', '1', '511302', null, '2', '1'),
('511303', '511300', '高坪区', '1', '511303', null, '2', '1'),
('511304', '511300', '嘉陵区', '1', '511304', null, '2', '1'),
('511321', '511300', '南部县', '1', '511321', null, '2', '1'),
('511322', '511300', '营山县', '1', '511322', null, '2', '1'),
('511323', '511300', '蓬安县', '1', '511323', null, '2', '1'),
('511324', '511300', '仪陇县', '1', '511324', null, '2', '1'),
('511325', '511300', '西充县', '1', '511325', null, '2', '1'),
('511381', '511300', '阆中市', '1', '511381', null, '2', '1'),
('511400', '510000', '眉山市', '1', '511400', 'M', '1', '1'),
('511402', '511400', '东坡区', '1', '511402', null, '2', '1'),
('511421', '511400', '仁寿县', '1', '511421', null, '2', '1'),
('511422', '511400', '彭山县', '1', '511422', null, '2', '1'),
('511423', '511400', '洪雅县', '1', '511423', null, '2', '1'),
('511424', '511400', '丹棱县', '1', '511424', null, '2', '1'),
('511425', '511400', '青神县', '1', '511425', null, '2', '1'),
('511500', '510000', '宜宾市', '1', '511500', 'Y', '1', '1'),
('511502', '511500', '翠屏区', '1', '511502', null, '2', '1');
INSERT INTO `wst_areas` VALUES ('511521', '511500', '宜宾县', '1', '511521', null, '2', '1'),
('511522', '511500', '南溪县', '1', '511522', null, '2', '1'),
('511523', '511500', '江安县', '1', '511523', null, '2', '1'),
('511524', '511500', '长宁县', '1', '511524', null, '2', '1'),
('511525', '511500', '高县', '1', '511525', null, '2', '1'),
('511526', '511500', '珙县', '1', '511526', null, '2', '1'),
('511527', '511500', '筠连县', '1', '511527', null, '2', '1'),
('511528', '511500', '兴文县', '1', '511528', null, '2', '1'),
('511529', '511500', '屏山县', '1', '511529', null, '2', '1'),
('511600', '510000', '广安市', '1', '511600', 'G', '1', '1'),
('511602', '511600', '广安区', '1', '511602', null, '2', '1'),
('511621', '511600', '岳池县', '1', '511621', null, '2', '1'),
('511622', '511600', '武胜县', '1', '511622', null, '2', '1'),
('511623', '511600', '邻水县', '1', '511623', null, '2', '1'),
('511681', '511600', '华蓥市', '1', '511681', null, '2', '1'),
('511700', '510000', '达州市', '1', '511700', 'D', '1', '1'),
('511702', '511700', '通川区', '1', '511702', null, '2', '1'),
('511721', '511700', '达县', '1', '511721', null, '2', '1'),
('511722', '511700', '宣汉县', '1', '511722', null, '2', '1'),
('511723', '511700', '开江县', '1', '511723', null, '2', '1'),
('511724', '511700', '大竹县', '1', '511724', null, '2', '1'),
('511725', '511700', '渠县', '1', '511725', null, '2', '1'),
('511781', '511700', '万源市', '1', '511781', null, '2', '1'),
('511800', '510000', '雅安市', '1', '511800', 'Y', '1', '1'),
('511802', '511800', '雨城区', '1', '511802', null, '2', '1'),
('511821', '511800', '名山县', '1', '511821', null, '2', '1'),
('511822', '511800', '荥经县', '1', '511822', null, '2', '1'),
('511823', '511800', '汉源县', '1', '511823', null, '2', '1'),
('511824', '511800', '石棉县', '1', '511824', null, '2', '1'),
('511825', '511800', '天全县', '1', '511825', null, '2', '1'),
('511826', '511800', '芦山县', '1', '511826', null, '2', '1'),
('511827', '511800', '宝兴县', '1', '511827', null, '2', '1'),
('511900', '510000', '巴中市', '1', '511900', 'B', '1', '1'),
('511902', '511900', '巴州区', '1', '511902', null, '2', '1'),
('511921', '511900', '通江县', '1', '511921', null, '2', '1'),
('511922', '511900', '南江县', '1', '511922', null, '2', '1'),
('511923', '511900', '平昌县', '1', '511923', null, '2', '1'),
('512000', '510000', '资阳市', '1', '512000', 'Z', '1', '1'),
('512002', '512000', '雁江区', '1', '512002', null, '2', '1'),
('512021', '512000', '安岳县', '1', '512021', null, '2', '1'),
('512022', '512000', '乐至县', '1', '512022', null, '2', '1'),
('512081', '512000', '简阳市', '1', '512081', null, '2', '1'),
('513200', '510000', '阿坝州', '1', '513200', 'A', '1', '1'),
('513221', '513200', '汶川县', '1', '513221', null, '2', '1'),
('513222', '513200', '理县', '1', '513222', null, '2', '1'),
('513223', '513200', '茂县', '1', '513223', null, '2', '1'),
('513224', '513200', '松潘县', '1', '513224', null, '2', '1'),
('513225', '513200', '九寨沟县', '1', '513225', null, '2', '1'),
('513226', '513200', '金川县', '1', '513226', null, '2', '1'),
('513227', '513200', '小金县', '1', '513227', null, '2', '1'),
('513228', '513200', '黑水县', '1', '513228', null, '2', '1'),
('513229', '513200', '马尔康县', '1', '513229', null, '2', '1'),
('513230', '513200', '壤塘县', '1', '513230', null, '2', '1'),
('513231', '513200', '阿坝县', '1', '513231', null, '2', '1'),
('513232', '513200', '若尔盖县', '1', '513232', null, '2', '1'),
('513233', '513200', '红原县', '1', '513233', null, '2', '1'),
('513300', '510000', '甘孜藏族自治州', '1', '513300', 'G', '1', '1'),
('513321', '513300', '康定县', '1', '513321', null, '2', '1'),
('513322', '513300', '泸定县', '1', '513322', null, '2', '1'),
('513323', '513300', '丹巴县', '1', '513323', null, '2', '1'),
('513324', '513300', '九龙县', '1', '513324', null, '2', '1'),
('513325', '513300', '雅江县', '1', '513325', null, '2', '1'),
('513326', '513300', '道孚县', '1', '513326', null, '2', '1'),
('513327', '513300', '炉霍县', '1', '513327', null, '2', '1'),
('513328', '513300', '甘孜县', '1', '513328', null, '2', '1'),
('513329', '513300', '新龙县', '1', '513329', null, '2', '1'),
('513330', '513300', '德格县', '1', '513330', null, '2', '1'),
('513331', '513300', '白玉县', '1', '513331', null, '2', '1'),
('513332', '513300', '石渠县', '1', '513332', null, '2', '1'),
('513333', '513300', '色达县', '1', '513333', null, '2', '1'),
('513334', '513300', '理塘县', '1', '513334', null, '2', '1'),
('513335', '513300', '巴塘县', '1', '513335', null, '2', '1'),
('513336', '513300', '乡城县', '1', '513336', null, '2', '1'),
('513337', '513300', '稻城县', '1', '513337', null, '2', '1'),
('513338', '513300', '得荣县', '1', '513338', null, '2', '1'),
('513400', '510000', '凉山州', '1', '513400', 'L', '1', '1'),
('513401', '513400', '西昌市', '1', '513401', null, '2', '1'),
('513422', '513400', '木里藏族自治县', '1', '513422', null, '2', '1'),
('513423', '513400', '盐源县', '1', '513423', null, '2', '1'),
('513424', '513400', '德昌', '1', '513424', null, '2', '1'),
('513425', '513400', '会理县', '1', '513425', null, '2', '1'),
('513426', '513400', '会东县', '1', '513426', null, '2', '1'),
('513427', '513400', '宁南县', '1', '513427', null, '2', '1'),
('513428', '513400', '普格县', '1', '513428', null, '2', '1'),
('513429', '513400', '布拖县', '1', '513429', null, '2', '1'),
('513430', '513400', '金阳县', '1', '513430', null, '2', '1'),
('513431', '513400', '昭觉县', '1', '513431', null, '2', '1'),
('513432', '513400', '喜德县', '1', '513432', null, '2', '1'),
('513433', '513400', '冕宁县', '1', '513433', null, '2', '1'),
('513434', '513400', '越西县', '1', '513434', null, '2', '1'),
('513435', '513400', '甘洛县', '1', '513435', null, '2', '1'),
('513436', '513400', '美姑县', '1', '513436', null, '2', '1'),
('513437', '513400', '雷波县', '1', '513437', null, '2', '1'),
('520000', '0', '贵州省', '1', '520000', 'G', '0', '1'),
('520100', '520000', '贵阳市', '1', '520100', 'G', '1', '1'),
('520102', '520100', '南明区', '1', '520102', null, '2', '1'),
('520103', '520100', '云岩区', '1', '520103', null, '2', '1'),
('520111', '520100', '花溪区', '1', '520111', null, '2', '1'),
('520112', '520100', '乌当区', '1', '520112', null, '2', '1'),
('520113', '520100', '白云区', '1', '520113', null, '2', '1');
INSERT INTO `wst_areas` VALUES ('520114', '520100', '小河区', '1', '520114', null, '2', '1'),
('520121', '520100', '开阳县', '1', '520121', null, '2', '1'),
('520122', '520100', '息烽县', '1', '520122', null, '2', '1'),
('520123', '520100', '修文县', '1', '520123', null, '2', '1'),
('520181', '520100', '清镇市', '1', '520181', null, '2', '1'),
('520200', '520000', '六盘水市', '1', '520200', 'L', '1', '1'),
('520201', '520200', '钟山区', '1', '520201', null, '2', '1'),
('520203', '520200', '六枝特区', '1', '520203', null, '2', '1'),
('520221', '520200', '水城县', '1', '520221', null, '2', '1'),
('520222', '520200', '盘县', '1', '520222', null, '2', '1'),
('520300', '520000', '遵义市', '1', '520300', 'J', '1', '1'),
('520302', '520300', '红花岗区', '1', '520302', null, '2', '1'),
('520303', '520300', '汇川区', '1', '520303', null, '2', '1'),
('520321', '520300', '遵义县', '1', '520321', null, '2', '1'),
('520322', '520300', '桐梓县', '1', '520322', null, '2', '1'),
('520323', '520300', '绥阳县', '1', '520323', null, '2', '1'),
('520324', '520300', '正安县', '1', '520324', null, '2', '1'),
('520325', '520300', '道真仡佬族苗族自治县', '1', '520325', null, '2', '1'),
('520326', '520300', '务川仡佬族苗族自治县', '1', '520326', null, '2', '1'),
('520327', '520300', '凤冈县', '1', '520327', null, '2', '1'),
('520328', '520300', '湄潭县', '1', '520328', null, '2', '1'),
('520329', '520300', '余庆县', '1', '520329', null, '2', '1'),
('520330', '520300', '习水县', '1', '520330', null, '2', '1'),
('520381', '520300', '赤水市', '1', '520381', null, '2', '1'),
('520382', '520300', '仁怀市', '1', '520382', null, '2', '1'),
('520400', '520000', '安顺市', '1', '520400', 'A', '1', '1'),
('520402', '520400', '西秀区', '1', '520402', null, '2', '1'),
('520421', '520400', '平坝县', '1', '520421', null, '2', '1'),
('520422', '520400', '普定县', '1', '520422', null, '2', '1'),
('520423', '520400', '镇宁布依族苗族自治县', '1', '520423', null, '2', '1'),
('520424', '520400', '关岭自治县', '1', '520424', null, '2', '1'),
('520425', '520400', '紫云苗族布依族自治县', '1', '520425', null, '2', '1'),
('522200', '520000', '铜仁地区', '1', '522200', 'T', '1', '1'),
('522201', '522200', '铜仁市', '1', '522201', null, '2', '1'),
('522222', '522200', '江口县', '1', '522222', null, '2', '1'),
('522223', '522200', '玉屏侗族自治县', '1', '522223', null, '2', '1'),
('522224', '522200', '石阡县', '1', '522224', null, '2', '1'),
('522225', '522200', '思南县　', '1', '522225', null, '2', '1'),
('522226', '522200', '印江土家族苗族自治县', '1', '522226', null, '2', '1'),
('522227', '522200', '德江县', '1', '522227', null, '2', '1'),
('522228', '522200', '沿河土家族自治县', '1', '522228', null, '2', '1'),
('522229', '522200', '松桃苗族自治县', '1', '522229', null, '2', '1'),
('522230', '522200', '万山特区', '1', '522230', null, '2', '1'),
('522300', '520000', '黔西南州', '1', '522300', 'Q', '1', '1'),
('522301', '522300', '兴义市', '1', '522301', null, '2', '1'),
('522322', '522300', '兴仁县', '1', '522322', null, '2', '1'),
('522323', '522300', '普安县', '1', '522323', null, '2', '1'),
('522324', '522300', '晴隆县', '1', '522324', null, '2', '1'),
('522325', '522300', '贞丰县', '1', '522325', null, '2', '1'),
('522326', '522300', '望谟县', '1', '522326', null, '2', '1'),
('522327', '522300', '册亨县', '1', '522327', null, '2', '1'),
('522328', '522300', '安龙县', '1', '522328', null, '2', '1'),
('522400', '520000', '毕节地区', '1', '522400', 'B', '1', '1'),
('522401', '522400', '毕节市', '1', '522401', null, '2', '1'),
('522422', '522400', '大方县', '1', '522422', null, '2', '1'),
('522423', '522400', '黔西县', '1', '522423', null, '2', '1'),
('522424', '522400', '金沙县', '1', '522424', null, '2', '1'),
('522425', '522400', '织金县', '1', '522425', null, '2', '1'),
('522426', '522400', '纳雍县', '1', '522426', null, '2', '1'),
('522427', '522400', '威宁彝族回族苗族自治县', '1', '522427', null, '2', '1'),
('522428', '522400', '赫章县', '1', '522428', null, '2', '1'),
('522600', '520000', '黔东南苗族侗族自治州', '1', '522600', 'Q', '1', '1'),
('522601', '522600', '凯里市', '1', '522601', null, '2', '1'),
('522622', '522600', '黄平县', '1', '522622', null, '2', '1'),
('522623', '522600', '施秉县', '1', '522623', null, '2', '1'),
('522624', '522600', '三穗县', '1', '522624', null, '2', '1'),
('522625', '522600', '镇远县', '1', '522625', null, '2', '1'),
('522626', '522600', '岑巩县', '1', '522626', null, '2', '1'),
('522627', '522600', '天柱县', '1', '522627', null, '2', '1'),
('522628', '522600', '锦屏县', '1', '522628', null, '2', '1'),
('522629', '522600', '剑河县', '1', '522629', null, '2', '1'),
('522630', '522600', '台江县', '1', '522630', null, '2', '1'),
('522631', '522600', '黎平县', '1', '522631', null, '2', '1'),
('522632', '522600', '榕江县', '1', '522632', null, '2', '1'),
('522633', '522600', '从江县', '1', '522633', null, '2', '1'),
('522634', '522600', '雷山县', '1', '522634', null, '2', '1'),
('522635', '522600', '麻江县', '1', '522635', null, '2', '1'),
('522636', '522600', '丹寨县', '1', '522636', null, '2', '1'),
('522700', '520000', '黔南布依族苗族自治州', '1', '522700', 'Q', '1', '1'),
('522701', '522700', '都匀市', '1', '522701', null, '2', '1'),
('522702', '522700', '福泉市', '1', '522702', null, '2', '1'),
('522722', '522700', '荔波县', '1', '522722', null, '2', '1'),
('522723', '522700', '贵定县', '1', '522723', null, '2', '1'),
('522725', '522700', '瓮安县', '1', '522725', null, '2', '1'),
('522726', '522700', '独山县', '1', '522726', null, '2', '1'),
('522727', '522700', '平塘县', '1', '522727', null, '2', '1'),
('522728', '522700', '罗甸县', '1', '522728', null, '2', '1'),
('522729', '522700', '长顺县', '1', '522729', null, '2', '1'),
('522730', '522700', '龙里县', '1', '522730', null, '2', '1'),
('522731', '522700', '惠水县', '1', '522731', null, '2', '1'),
('522732', '522700', '三都水族自治县', '1', '522732', null, '2', '1'),
('530000', '0', '云南省', '1', '530000', 'Y', '0', '1'),
('530100', '530000', '昆明市', '1', '530100', 'K', '1', '1'),
('530102', '530100', '五华区', '1', '530102', null, '2', '1'),
('530103', '530100', '盘龙区', '1', '530103', null, '2', '1'),
('530111', '530100', '官渡区', '1', '530111', null, '2', '1'),
('530112', '530100', '西山区', '1', '530112', null, '2', '1'),
('530113', '530100', '东川区', '1', '530113', null, '2', '1'),
('530121', '530100', '呈贡县', '1', '530121', null, '2', '1'),
('530122', '530100', '晋宁县', '1', '530122', null, '2', '1');
INSERT INTO `wst_areas` VALUES ('530124', '530100', '富民县', '1', '530124', null, '2', '1'),
('530125', '530100', '宜良县', '1', '530125', null, '2', '1'),
('530126', '530100', '石林县', '1', '530126', null, '2', '1'),
('530127', '530100', '嵩明县', '1', '530127', null, '2', '1'),
('530128', '530100', '禄劝县', '1', '530128', null, '2', '1'),
('530129', '530100', '寻甸县', '1', '530129', null, '2', '1'),
('530181', '530100', '安宁市', '1', '530181', null, '2', '1'),
('530300', '530000', '曲靖市', '1', '530300', 'Q', '1', '1'),
('530302', '530300', '麒麟区', '1', '530302', null, '2', '1'),
('530321', '530300', '马龙县', '1', '530321', null, '2', '1'),
('530322', '530300', '陆良县', '1', '530322', null, '2', '1'),
('530323', '530300', '师宗县', '1', '530323', null, '2', '1'),
('530324', '530300', '罗平县', '1', '530324', null, '2', '1'),
('530325', '530300', '富源县', '1', '530325', null, '2', '1'),
('530326', '530300', '会泽县', '1', '530326', null, '2', '1'),
('530328', '530300', '沾益县', '1', '530328', null, '2', '1'),
('530381', '530300', '宣威市', '1', '530381', null, '2', '1'),
('530400', '530000', '玉溪市', '1', '530400', 'Y', '1', '1'),
('530402', '530400', '红塔区', '1', '530402', null, '2', '1'),
('530421', '530400', '江川县', '1', '530421', null, '2', '1'),
('530422', '530400', '澄江县', '1', '530422', null, '2', '1'),
('530423', '530400', '通海县', '1', '530423', null, '2', '1'),
('530424', '530400', '华宁县', '1', '530424', null, '2', '1'),
('530425', '530400', '易门县', '1', '530425', null, '2', '1'),
('530426', '530400', '峨山县', '1', '530426', null, '2', '1'),
('530427', '530400', '新平县', '1', '530427', null, '2', '1'),
('530428', '530400', '元江县', '1', '530428', null, '2', '1'),
('530500', '530000', '保山市', '1', '530500', 'B', '1', '1'),
('530502', '530500', '隆阳区', '1', '530502', null, '2', '1'),
('530521', '530500', '施甸县', '1', '530521', null, '2', '1'),
('530522', '530500', '腾冲县', '1', '530522', null, '2', '1'),
('530523', '530500', '龙陵县', '1', '530523', null, '2', '1'),
('530524', '530500', '昌宁县', '1', '530524', null, '2', '1'),
('530600', '530000', '昭通市', '1', '530600', 'Z', '1', '1'),
('530602', '530600', '昭阳区', '1', '530602', null, '2', '1'),
('530621', '530600', '鲁甸县', '1', '530621', null, '2', '1'),
('530622', '530600', '巧家县', '1', '530622', null, '2', '1'),
('530623', '530600', '盐津县', '1', '530623', null, '2', '1'),
('530624', '530600', '大关县', '1', '530624', null, '2', '1'),
('530625', '530600', '永善县', '1', '530625', null, '2', '1'),
('530626', '530600', '绥江县', '1', '530626', null, '2', '1'),
('530627', '530600', '镇雄县', '1', '530627', null, '2', '1'),
('530628', '530600', '彝良县', '1', '530628', null, '2', '1'),
('530629', '530600', '威信县', '1', '530629', null, '2', '1'),
('530630', '530600', '水富县', '1', '530630', null, '2', '1'),
('530700', '530000', '丽江市', '1', '530700', 'L', '1', '1'),
('530702', '530700', '古城区', '1', '530702', null, '2', '1'),
('530721', '530700', '玉龙县', '1', '530721', null, '2', '1'),
('530722', '530700', '永胜县', '1', '530722', null, '2', '1'),
('530723', '530700', '华坪县', '1', '530723', null, '2', '1'),
('530724', '530700', '宁蒗县', '1', '530724', null, '2', '1'),
('530800', '530000', '思茅市', '1', '530800', 'S', '1', '1'),
('530802', '530800', '翠云区', '1', '530802', null, '2', '1'),
('530821', '530800', '普洱县', '1', '530821', null, '2', '1'),
('530822', '530800', '墨江县', '1', '530822', null, '2', '1'),
('530823', '530800', '景东县', '1', '530823', null, '2', '1'),
('530824', '530800', '景谷县', '1', '530824', null, '2', '1'),
('530825', '530800', '镇沅县', '1', '530825', null, '2', '1'),
('530826', '530800', '江城县', '1', '530826', null, '2', '1'),
('530827', '530800', '孟连县', '1', '530827', null, '2', '1'),
('530828', '530800', '澜沧县', '1', '530828', null, '2', '1'),
('530829', '530800', '西盟县', '1', '530829', null, '2', '1'),
('530900', '530000', '临沧市', '1', '530900', 'L', '1', '1'),
('530902', '530900', '临翔区', '1', '530902', null, '2', '1'),
('530921', '530900', '凤庆县', '1', '530921', null, '2', '1'),
('530922', '530900', '云县', '1', '530922', null, '2', '1'),
('530923', '530900', '永德县', '1', '530923', null, '2', '1'),
('530924', '530900', '镇康县', '1', '530924', null, '2', '1'),
('530925', '530900', '双江县', '1', '530925', null, '2', '1'),
('530926', '530900', '耿马县', '1', '530926', null, '2', '1'),
('530927', '530900', '沧源县', '1', '530927', null, '2', '1'),
('532300', '530000', '楚雄州', '1', '532300', 'C', '1', '1'),
('532301', '532300', '楚雄市', '1', '532301', null, '2', '1'),
('532322', '532300', '双柏县', '1', '532322', null, '2', '1'),
('532323', '532300', '牟定县', '1', '532323', null, '2', '1'),
('532324', '532300', '南华县', '1', '532324', null, '2', '1'),
('532325', '532300', '姚安县', '1', '532325', null, '2', '1'),
('532326', '532300', '大姚县', '1', '532326', null, '2', '1'),
('532327', '532300', '永仁县', '1', '532327', null, '2', '1'),
('532328', '532300', '元谋县', '1', '532328', null, '2', '1'),
('532329', '532300', '武定县', '1', '532329', null, '2', '1'),
('532331', '532300', '禄丰县', '1', '532331', null, '2', '1'),
('532500', '530000', '红河州', '1', '532500', 'H', '1', '1'),
('532501', '532500', '个旧市', '1', '532501', null, '2', '1'),
('532502', '532500', '开远市', '1', '532502', null, '2', '1'),
('532522', '532500', '蒙自县', '1', '532522', null, '2', '1'),
('532523', '532500', '屏边县', '1', '532523', null, '2', '1'),
('532524', '532500', '建水县', '1', '532524', null, '2', '1'),
('532525', '532500', '石屏县', '1', '532525', null, '2', '1'),
('532526', '532500', '弥勒县', '1', '532526', null, '2', '1'),
('532527', '532500', '泸西县', '1', '532527', null, '2', '1'),
('532528', '532500', '元阳县', '1', '532528', null, '2', '1'),
('532529', '532500', '红河县', '1', '532529', null, '2', '1'),
('532530', '532500', '金平县', '1', '532530', null, '2', '1'),
('532531', '532500', '绿春县', '1', '532531', null, '2', '1'),
('532532', '532500', '河口县', '1', '532532', null, '2', '1'),
('532600', '530000', '文山州', '1', '532600', 'W', '1', '1'),
('532621', '532600', '文山县', '1', '532621', null, '2', '1'),
('532622', '532600', '砚山县', '1', '532622', null, '2', '1'),
('532623', '532600', '西畴县', '1', '532623', null, '2', '1');
INSERT INTO `wst_areas` VALUES ('532624', '532600', '麻栗坡县', '1', '532624', null, '2', '1'),
('532625', '532600', '马关县', '1', '532625', null, '2', '1'),
('532626', '532600', '丘北县', '1', '532626', null, '2', '1'),
('532627', '532600', '广南县', '1', '532627', null, '2', '1'),
('532628', '532600', '富宁县', '1', '532628', null, '2', '1'),
('532800', '530000', '西双版纳州', '1', '532800', 'X', '1', '1'),
('532801', '532800', '景洪市', '1', '532801', null, '2', '1'),
('532822', '532800', '勐海县', '1', '532822', null, '2', '1'),
('532823', '532800', '勐腊县', '1', '532823', null, '2', '1'),
('532900', '530000', '大理州', '1', '532900', 'D', '1', '1'),
('532901', '532900', '大理市', '1', '532901', null, '2', '1'),
('532922', '532900', '漾濞县', '1', '532922', null, '2', '1'),
('532923', '532900', '祥云县', '1', '532923', null, '2', '1'),
('532924', '532900', '宾川县', '1', '532924', null, '2', '1'),
('532925', '532900', '弥渡县', '1', '532925', null, '2', '1'),
('532926', '532900', '南涧县', '1', '532926', null, '2', '1'),
('532927', '532900', '巍山县', '1', '532927', null, '2', '1'),
('532928', '532900', '永平县', '1', '532928', null, '2', '1'),
('532929', '532900', '云龙县', '1', '532929', null, '2', '1'),
('532930', '532900', '洱源县', '1', '532930', null, '2', '1'),
('532931', '532900', '剑川县', '1', '532931', null, '2', '1'),
('532932', '532900', '鹤庆县', '1', '532932', null, '2', '1'),
('533100', '530000', '德宏州', '1', '533100', 'D', '1', '1'),
('533102', '533100', '瑞丽市', '1', '533102', null, '2', '1'),
('533103', '533100', '潞西市', '1', '533103', null, '2', '1'),
('533122', '533100', '梁河县', '1', '533122', null, '2', '1'),
('533123', '533100', '盈江县', '1', '533123', null, '2', '1'),
('533124', '533100', '陇川县', '1', '533124', null, '2', '1'),
('533300', '530000', '怒江州', '1', '533300', 'L', '1', '1'),
('533321', '533300', '泸水县', '1', '533321', null, '2', '1'),
('533323', '533300', '福贡县', '1', '533323', null, '2', '1'),
('533324', '533300', '贡山县', '1', '533324', null, '2', '1'),
('533325', '533300', '兰坪县', '1', '533325', null, '2', '1'),
('533400', '530000', '迪庆州', '1', '533400', 'D', '1', '1'),
('533421', '533400', '香格里拉县', '1', '533421', null, '2', '1'),
('533422', '533400', '德钦县', '1', '533422', null, '2', '1'),
('533423', '533400', '维西县', '1', '533423', null, '2', '1'),
('540000', '0', '西藏自治区', '1', '540000', 'X', '0', '1'),
('540100', '540000', '拉萨市', '1', '540100', 'L', '1', '1'),
('540102', '540100', '城关区', '1', '540102', null, '2', '1'),
('540121', '540100', '林周县', '1', '540121', null, '2', '1'),
('540122', '540100', '当雄县', '1', '540122', null, '2', '1'),
('540123', '540100', '尼木县', '1', '540123', null, '2', '1'),
('540124', '540100', '曲水县', '1', '540124', null, '2', '1'),
('540125', '540100', '堆龙德庆', '1', '540125', null, '2', '1'),
('540126', '540100', '达孜县', '1', '540126', null, '2', '1'),
('540127', '540100', '墨竹工卡县', '1', '540127', null, '2', '1'),
('610000', '0', '陕西省', '1', '610000', 'S', '0', '1'),
('610100', '610000', '西安市', '1', '610100', 'X', '1', '1'),
('610102', '610100', '新城区', '1', '610102', null, '2', '1'),
('610103', '610100', '碑林区', '1', '610103', null, '2', '1'),
('610104', '610100', '莲湖区', '1', '610104', null, '2', '1'),
('610111', '610100', '灞桥区', '1', '610111', null, '2', '1'),
('610112', '610100', '未央区', '1', '610112', null, '2', '1'),
('610113', '610100', '雁塔区', '1', '610113', null, '2', '1'),
('610114', '610100', '阎良区', '1', '610114', null, '2', '1'),
('610115', '610100', '临潼区', '1', '610115', null, '2', '1'),
('610116', '610100', '长安区', '1', '610116', null, '2', '1'),
('610122', '610100', '蓝田县', '1', '610122', null, '2', '1'),
('610124', '610100', '周至县', '1', '610124', null, '2', '1'),
('610125', '610100', '户县', '1', '610125', null, '2', '1'),
('610126', '610100', '高陵县', '1', '610126', null, '2', '1'),
('610200', '610000', '铜川市', '1', '610200', 'T', '1', '1'),
('610202', '610200', '王益区', '1', '610202', null, '2', '1'),
('610203', '610200', '印台区', '1', '610203', null, '2', '1'),
('610204', '610200', '耀州区', '1', '610204', null, '2', '1'),
('610222', '610200', '宜君县', '1', '610222', null, '2', '1'),
('610300', '610000', '宝鸡市', '1', '610300', 'B', '1', '1'),
('610302', '610300', '渭滨区', '1', '610302', null, '2', '1'),
('610303', '610300', '金台区', '1', '610303', null, '2', '1'),
('610304', '610300', '陈仓区', '1', '610304', null, '2', '1'),
('610322', '610300', '凤翔县', '1', '610322', null, '2', '1'),
('610323', '610300', '岐山县', '1', '610323', null, '2', '1'),
('610324', '610300', '扶风县', '1', '610324', null, '2', '1'),
('610326', '610300', '眉县', '1', '610326', null, '2', '1'),
('610327', '610300', '陇县', '1', '610327', null, '2', '1'),
('610328', '610300', '千阳县', '1', '610328', null, '2', '1'),
('610329', '610300', '麟游县', '1', '610329', null, '2', '1'),
('610330', '610300', '凤县', '1', '610330', null, '2', '1'),
('610331', '610300', '太白县', '1', '610331', null, '2', '1'),
('610400', '610000', '咸阳市', '1', '610400', 'X', '1', '1'),
('610402', '610400', '秦都区', '1', '610402', null, '2', '1'),
('610403', '610400', '杨凌区', '1', '610403', null, '2', '1'),
('610404', '610400', '渭城区', '1', '610404', null, '2', '1'),
('610422', '610400', '三原县', '1', '610422', null, '2', '1'),
('610423', '610400', '泾阳县', '1', '610423', null, '2', '1'),
('610424', '610400', '乾县', '1', '610424', null, '2', '1'),
('610425', '610400', '礼泉县', '1', '610425', null, '2', '1'),
('610426', '610400', '永寿县', '1', '610426', null, '2', '1'),
('610427', '610400', '彬县', '1', '610427', null, '2', '1'),
('610428', '610400', '长武县', '1', '610428', null, '2', '1'),
('610429', '610400', '旬邑县', '1', '610429', null, '2', '1'),
('610430', '610400', '淳化县', '1', '610430', null, '2', '1'),
('610431', '610400', '武功县', '1', '610431', null, '2', '1'),
('610481', '610400', '兴平市', '1', '610481', null, '2', '1'),
('610500', '610000', '渭南市', '1', '610500', 'W', '1', '1');
INSERT INTO `wst_areas` VALUES ('610502', '610500', '临渭区', '1', '610502', null, '2', '1'),
('610521', '610500', '华县', '1', '610521', null, '2', '1'),
('610522', '610500', '潼关县', '1', '610522', null, '2', '1'),
('610523', '610500', '大荔县', '1', '610523', null, '2', '1'),
('610524', '610500', '合阳县', '1', '610524', null, '2', '1'),
('610525', '610500', '澄城县', '1', '610525', null, '2', '1'),
('610526', '610500', '蒲城县', '1', '610526', null, '2', '1'),
('610527', '610500', '白水县', '1', '610527', null, '2', '1'),
('610528', '610500', '富平县', '1', '610528', null, '2', '1'),
('610581', '610500', '韩城市', '1', '610581', null, '2', '1'),
('610582', '610500', '华阴市', '1', '610582', null, '2', '1'),
('610600', '610000', '延安市', '1', '610600', 'Y', '1', '1'),
('610602', '610600', '宝塔区', '1', '610602', null, '2', '1'),
('610621', '610600', '延长县', '1', '610621', null, '2', '1'),
('610622', '610600', '延川县', '1', '610622', null, '2', '1'),
('610623', '610600', '子长县', '1', '610623', null, '2', '1'),
('610624', '610600', '安塞县', '1', '610624', null, '2', '1'),
('610625', '610600', '志丹县', '1', '610625', null, '2', '1'),
('610626', '610600', '吴起县', '1', '610626', null, '2', '1'),
('610627', '610600', '甘泉县', '1', '610627', null, '2', '1'),
('610628', '610600', '富县', '1', '610628', null, '2', '1'),
('610629', '610600', '洛川县', '1', '610629', null, '2', '1'),
('610630', '610600', '宜川县', '1', '610630', null, '2', '1'),
('610631', '610600', '黄龙县', '1', '610631', null, '2', '1'),
('610632', '610600', '黄陵县', '1', '610632', null, '2', '1'),
('610700', '610000', '汉中市', '1', '610700', 'H', '1', '1'),
('610702', '610700', '汉台区', '1', '610702', null, '2', '1'),
('610721', '610700', '南郑县', '1', '610721', null, '2', '1'),
('610722', '610700', '城固县', '1', '610722', null, '2', '1'),
('610723', '610700', '洋县', '1', '610723', null, '2', '1'),
('610724', '610700', '西乡县', '1', '610724', null, '2', '1'),
('610725', '610700', '勉县', '1', '610725', null, '2', '1'),
('610726', '610700', '宁强县', '1', '610726', null, '2', '1'),
('610727', '610700', '略阳县', '1', '610727', null, '2', '1'),
('610728', '610700', '镇巴县', '1', '610728', null, '2', '1'),
('610729', '610700', '留坝县', '1', '610729', null, '2', '1'),
('610730', '610700', '佛坪县', '1', '610730', null, '2', '1'),
('610800', '610000', '榆林市', '1', '610800', 'Y', '1', '1'),
('610802', '610800', '榆阳区', '1', '610802', null, '2', '1'),
('610821', '610800', '神木县', '1', '610821', null, '2', '1'),
('610822', '610800', '府谷县', '1', '610822', null, '2', '1'),
('610823', '610800', '横山县', '1', '610823', null, '2', '1'),
('610824', '610800', '靖边县', '1', '610824', null, '2', '1'),
('610825', '610800', '定边县', '1', '610825', null, '2', '1'),
('610826', '610800', '绥德县', '1', '610826', null, '2', '1'),
('610827', '610800', '米脂县', '1', '610827', null, '2', '1'),
('610828', '610800', '佳县', '1', '610828', null, '2', '1'),
('610829', '610800', '吴堡县', '1', '610829', null, '2', '1'),
('610830', '610800', '清涧县', '1', '610830', null, '2', '1'),
('610831', '610800', '子洲县', '1', '610831', null, '2', '1'),
('610900', '610000', '安康市', '1', '610900', 'A', '1', '1'),
('610902', '610900', '汉滨区', '1', '610902', null, '2', '1'),
('610921', '610900', '汉阴县', '1', '610921', null, '2', '1'),
('610922', '610900', '石泉县', '1', '610922', null, '2', '1'),
('610923', '610900', '宁陕县', '1', '610923', null, '2', '1'),
('610924', '610900', '紫阳县', '1', '610924', null, '2', '1'),
('610925', '610900', '岚皋县', '1', '610925', null, '2', '1'),
('610926', '610900', '平利县', '1', '610926', null, '2', '1'),
('610927', '610900', '镇坪县', '1', '610927', null, '2', '1'),
('610928', '610900', '旬阳县', '1', '610928', null, '2', '1'),
('610929', '610900', '白河县', '1', '610929', null, '2', '1'),
('611000', '610000', '商洛市', '1', '611000', 'S', '1', '1'),
('611002', '611000', '商州区', '1', '611002', null, '2', '1'),
('611021', '611000', '洛南县', '1', '611021', null, '2', '1'),
('611022', '611000', '丹凤县', '1', '611022', null, '2', '1'),
('611023', '611000', '商南县', '1', '611023', null, '2', '1'),
('611024', '611000', '山阳县', '1', '611024', null, '2', '1'),
('611025', '611000', '镇安县', '1', '611025', null, '2', '1'),
('611026', '611000', '柞水县', '1', '611026', null, '2', '1'),
('620000', '0', '甘肃省', '1', '620000', 'G', '0', '1'),
('620100', '620000', '兰州市', '1', '620100', 'L', '1', '1'),
('620102', '620100', '城关区', '1', '620102', null, '2', '1'),
('620103', '620100', '七里河区', '1', '620103', null, '2', '1'),
('620104', '620100', '兰州市西固区', '1', '620104', null, '2', '1'),
('620105', '620100', '安宁区', '1', '620105', null, '2', '1'),
('620111', '620100', '红古区', '1', '620111', null, '2', '1'),
('620121', '620100', '永登县', '1', '620121', null, '2', '1'),
('620122', '620100', '皋兰县', '1', '620122', null, '2', '1'),
('620123', '620100', '榆中县', '1', '620123', null, '2', '1'),
('620200', '620000', '嘉峪关市', '1', '620200', 'J', '1', '1'),
('620201', '620200', '市辖', '1', '620201', null, '2', '1'),
('620300', '620000', '金昌市', '1', '620300', 'J', '1', '1'),
('620302', '620300', '金川区', '1', '620302', null, '2', '1'),
('620321', '620300', '永昌县', '1', '620321', null, '2', '1'),
('620400', '620000', '白银市', '1', '620400', 'B', '1', '1'),
('620402', '620400', '白银区', '1', '620402', null, '2', '1'),
('620403', '620400', '平川区', '1', '620403', null, '2', '1'),
('620421', '620400', '靖远县', '1', '620421', null, '2', '1'),
('620422', '620400', '会宁县', '1', '620422', null, '2', '1'),
('620423', '620400', '景泰县', '1', '620423', null, '2', '1'),
('620500', '620000', '天水市', '1', '620500', 'T', '1', '1'),
('620502', '620500', '秦州区', '1', '620502', null, '2', '1'),
('620503', '620500', '麦积区', '1', '620503', null, '2', '1'),
('620521', '620500', '清水县', '1', '620521', null, '2', '1'),
('620522', '620500', '秦安县', '1', '620522', null, '2', '1'),
('620523', '620500', '甘谷县', '1', '620523', null, '2', '1'),
('620524', '620500', '武山县', '1', '620524', null, '2', '1'),
('620525', '620500', '张家川县', '1', '620525', null, '2', '1'),
('620600', '620000', '武威市', '1', '620600', 'W', '1', '1'),
('620602', '620600', '凉州区', '1', '620602', null, '2', '1'),
('620621', '620600', '民勤县', '1', '620621', null, '2', '1'),
('620622', '620600', '古浪县', '1', '620622', null, '2', '1'),
('620623', '620600', '天祝县', '1', '620623', null, '2', '1'),
('620700', '620000', '张掖市', '1', '620700', 'Z', '1', '1');
INSERT INTO `wst_areas` VALUES ('620702', '620700', '甘州区', '1', '620702', null, '2', '1'),
('620721', '620700', '肃南裕固族自治县', '1', '620721', null, '2', '1'),
('620722', '620700', '民乐县', '1', '620722', null, '2', '1'),
('620723', '620700', '临泽县', '1', '620723', null, '2', '1'),
('620724', '620700', '高台县', '1', '620724', null, '2', '1'),
('620725', '620700', '山丹县', '1', '620725', null, '2', '1'),
('620800', '620000', '平凉市', '1', '620800', 'P', '1', '1'),
('620802', '620800', '崆峒区', '1', '620802', null, '2', '1'),
('620821', '620800', '泾川县', '1', '620821', null, '2', '1'),
('620822', '620800', '灵台县', '1', '620822', null, '2', '1'),
('620823', '620800', '崇信县', '1', '620823', null, '2', '1'),
('620824', '620800', '华亭县', '1', '620824', null, '2', '1'),
('620825', '620800', '庄浪县', '1', '620825', null, '2', '1'),
('620826', '620800', '静宁县', '1', '620826', null, '2', '1'),
('620900', '620000', '酒泉市', '1', '620900', 'Q', '1', '1'),
('620902', '620900', '肃州区', '1', '620902', null, '2', '1'),
('620921', '620900', '金塔县', '1', '620921', null, '2', '1'),
('620922', '620900', '瓜州县', '1', '620922', null, '2', '1'),
('620923', '620900', '肃北蒙古族自治县', '1', '620923', null, '2', '1'),
('620924', '620900', '阿克塞县', '1', '620924', null, '2', '1'),
('620981', '620900', '玉门市', '1', '620981', null, '2', '1'),
('620982', '620900', '敦煌市', '1', '620982', null, '2', '1'),
('621000', '620000', '庆阳市', '1', '621000', 'Q', '1', '1'),
('621002', '621000', '西峰区', '1', '621002', null, '2', '1'),
('621021', '621000', '庆城县', '1', '621021', null, '2', '1'),
('621022', '621000', '环县', '1', '621022', null, '2', '1'),
('621023', '621000', '华池县', '1', '621023', null, '2', '1'),
('621024', '621000', '合水县', '1', '621024', null, '2', '1'),
('621025', '621000', '正宁县', '1', '621025', null, '2', '1'),
('621026', '621000', '宁县', '1', '621026', null, '2', '1'),
('621027', '621000', '镇原县', '1', '621027', null, '2', '1'),
('621100', '620000', '定西市', '1', '621100', 'D', '1', '1'),
('621102', '621100', '安定区', '1', '621102', null, '2', '1'),
('621121', '621100', '通渭县', '1', '621121', null, '2', '1'),
('621122', '621100', '陇西县', '1', '621122', null, '2', '1'),
('621123', '621100', '渭源县', '1', '621123', null, '2', '1'),
('621124', '621100', '临洮县', '1', '621124', null, '2', '1'),
('621125', '621100', '漳县', '1', '621125', null, '2', '1'),
('621126', '621100', '岷县', '1', '621126', null, '2', '1'),
('621200', '620000', '陇南市', '1', '621200', 'L', '1', '1'),
('621202', '621200', '武都区', '1', '621202', null, '2', '1'),
('621221', '621200', '成县', '1', '621221', null, '2', '1'),
('621222', '621200', '文县', '1', '621222', null, '2', '1'),
('621223', '621200', '宕昌县', '1', '621223', null, '2', '1'),
('621224', '621200', '康县', '1', '621224', null, '2', '1'),
('621225', '621200', '西和县', '1', '621225', null, '2', '1'),
('621226', '621200', '礼县', '1', '621226', null, '2', '1'),
('621227', '621200', '徽县', '1', '621227', null, '2', '1'),
('621228', '621200', '两当县', '1', '621228', null, '2', '1'),
('622900', '620000', '临夏州', '1', '622900', 'L', '1', '1'),
('622901', '622900', '临夏市', '1', '622901', null, '2', '1'),
('622921', '622900', '临夏县', '1', '622921', null, '2', '1'),
('622922', '622900', '康乐县', '1', '622922', null, '2', '1'),
('622923', '622900', '永靖县', '1', '622923', null, '2', '1'),
('622924', '622900', '广河县', '1', '622924', null, '2', '1'),
('622925', '622900', '和政县', '1', '622925', null, '2', '1'),
('622926', '622900', '东乡族自治县', '1', '622926', null, '2', '1'),
('622927', '622900', '积石山县', '1', '622927', null, '2', '1'),
('623000', '620000', '甘南州', '1', '623000', 'G', '1', '1'),
('623001', '623000', '合作市', '1', '623001', null, '2', '1'),
('623021', '623000', '临潭县', '1', '623021', null, '2', '1'),
('623022', '623000', '卓尼县', '1', '623022', null, '2', '1'),
('623023', '623000', '舟曲县', '1', '623023', null, '2', '1'),
('623024', '623000', '迭部县', '1', '623024', null, '2', '1'),
('623025', '623000', '玛曲县', '1', '623025', null, '2', '1'),
('623026', '623000', '碌曲县', '1', '623026', null, '2', '1'),
('623027', '623000', '夏河县', '1', '623027', null, '2', '1'),
('630000', '0', '青海省', '1', '630000', 'Q', '0', '1'),
('630100', '630000', '西宁市', '1', '630100', 'X', '1', '1'),
('630102', '630100', '城东区', '1', '630102', null, '2', '1'),
('630103', '630100', '城中区', '1', '630103', null, '2', '1'),
('630104', '630100', '城西区', '1', '630104', null, '2', '1'),
('630105', '630100', '城北区', '1', '630105', null, '2', '1'),
('630121', '630100', '大通回族土族自治县', '1', '630121', null, '2', '1'),
('630122', '630100', '湟中县', '1', '630122', null, '2', '1'),
('630123', '630100', '湟源县', '1', '630123', null, '2', '1'),
('632100', '630000', '海东地区', '1', '632100', 'H', '1', '1'),
('632121', '632100', '平安县', '1', '632121', null, '2', '1'),
('632122', '632100', '民和县', '1', '632122', null, '2', '1'),
('632123', '632100', '乐都县', '1', '632123', null, '2', '1'),
('632126', '632100', '互助县', '1', '632126', null, '2', '1'),
('632127', '632100', '化隆回族自治县', '1', '632127', null, '2', '1'),
('632128', '632100', '循化县', '1', '632128', null, '2', '1'),
('632200', '630000', '海北州', '1', '632200', 'H', '1', '1'),
('632221', '632200', '门源县', '1', '632221', null, '2', '1'),
('632222', '632200', '祁连县', '1', '632222', null, '2', '1'),
('632223', '632200', '海晏县', '1', '632223', null, '2', '1'),
('632224', '632200', '刚察县', '1', '632224', null, '2', '1'),
('632300', '630000', '黄南州', '1', '632300', 'H', '1', '1'),
('632321', '632300', '同仁县', '1', '632321', null, '2', '1'),
('632322', '632300', '尖扎县', '1', '632322', null, '2', '1'),
('632323', '632300', '泽库县', '1', '632323', null, '2', '1'),
('632324', '632300', '河南县', '1', '632324', null, '2', '1'),
('632500', '630000', '海南州', '1', '632500', 'H', '1', '1'),
('632521', '632500', '共和县', '1', '632521', null, '2', '1'),
('632522', '632500', '同德县', '1', '632522', null, '2', '1'),
('632523', '632500', '贵德县', '1', '632523', null, '2', '1'),
('632524', '632500', '兴海县', '1', '632524', null, '2', '1'),
('632525', '632500', '贵南县', '1', '632525', null, '2', '1'),
('632600', '630000', '果洛州', '1', '632600', 'G', '1', '1');
INSERT INTO `wst_areas` VALUES ('632621', '632600', '玛沁县', '1', '632621', null, '2', '1'),
('632622', '632600', '班玛县', '1', '632622', null, '2', '1'),
('632623', '632600', '甘德县', '1', '632623', null, '2', '1'),
('632624', '632600', '达日县', '1', '632624', null, '2', '1'),
('632625', '632600', '久治县', '1', '632625', null, '2', '1'),
('632626', '632600', '玛多县', '1', '632626', null, '2', '1'),
('632700', '630000', '玉树州', '1', '632700', 'Y', '1', '1'),
('632721', '632700', '玉树县', '1', '632721', null, '2', '1'),
('632722', '632700', '杂多县', '1', '632722', null, '2', '1'),
('632723', '632700', '称多县', '1', '632723', null, '2', '1'),
('632724', '632700', '治多县', '1', '632724', null, '2', '1'),
('632725', '632700', '囊谦县', '1', '632725', null, '2', '1'),
('632726', '632700', '曲麻莱县', '1', '632726', null, '2', '1'),
('632800', '630000', '海西州', '1', '632800', 'H', '1', '1'),
('632801', '632800', '格尔木市', '1', '632801', null, '2', '1'),
('632802', '632800', '德令哈市', '1', '632802', null, '2', '1'),
('632821', '632800', '乌兰县', '1', '632821', null, '2', '1'),
('632822', '632800', '都兰县', '1', '632822', null, '2', '1'),
('632823', '632800', '天峻县', '1', '632823', null, '2', '1'),
('640000', '0', '宁夏回族自治区', '1', '640000', 'N', '0', '1'),
('640100', '640000', '银川市', '1', '640100', 'Y', '1', '1'),
('640104', '640100', '兴庆区', '1', '640104', null, '2', '1'),
('640105', '640100', '西夏区', '1', '640105', null, '2', '1'),
('640106', '640100', '金凤区', '1', '640106', null, '2', '1'),
('640121', '640100', '永宁县', '1', '640121', null, '2', '1'),
('640122', '640100', '贺兰县', '1', '640122', null, '2', '1'),
('640181', '640100', '灵武市', '1', '640181', null, '2', '1'),
('640200', '640000', '石嘴山市', '1', '640200', 'S', '1', '1'),
('640202', '640200', '大武口区', '1', '640202', null, '2', '1'),
('640205', '640200', '惠农区', '1', '640205', null, '2', '1'),
('640221', '640200', '平罗县', '1', '640221', null, '2', '1'),
('640300', '640000', '吴忠市', '1', '640300', 'W', '1', '1'),
('640302', '640300', '利通区', '1', '640302', null, '2', '1'),
('640323', '640300', '盐池县', '1', '640323', null, '2', '1'),
('640324', '640300', '同心县', '1', '640324', null, '2', '1'),
('640381', '640300', '青铜峡市', '1', '640381', null, '2', '1'),
('640400', '640000', '固原市', '1', '640400', 'G', '1', '1'),
('640402', '640400', '原州区', '1', '640402', null, '2', '1'),
('640422', '640400', '西吉县', '1', '640422', null, '2', '1'),
('640423', '640400', '隆德县', '1', '640423', null, '2', '1'),
('640424', '640400', '泾源县', '1', '640424', null, '2', '1'),
('640425', '640400', '彭阳县', '1', '640425', null, '2', '1'),
('640500', '640000', '中卫市', '1', '640500', 'Z', '1', '1'),
('640502', '640500', '沙坡头区', '1', '640502', null, '2', '1'),
('640521', '640500', '中宁县', '1', '640521', null, '2', '1'),
('640522', '640500', '海原县', '1', '640522', null, '2', '1'),
('650000', '0', '新疆维吾尔自治区', '1', '650000', 'J', '0', '1'),
('650100', '650000', '乌鲁木齐市', '1', '650100', 'W', '1', '1'),
('650102', '650100', '天山区', '1', '650102', null, '2', '1'),
('650103', '650100', '沙依巴克区', '1', '650103', null, '2', '1'),
('650104', '650100', '新市区', '1', '650104', null, '2', '1'),
('650105', '650100', '水磨沟区', '1', '650105', null, '2', '1'),
('650106', '650100', '头屯河区', '1', '650106', null, '2', '1'),
('650107', '650100', '达坂城区', '1', '650107', null, '2', '1'),
('650108', '650100', '东山区', '1', '650108', null, '2', '1'),
('650121', '650100', '乌鲁木齐县', '1', '650121', null, '2', '1'),
('650200', '650000', '克拉玛依市', '1', '650200', 'K', '1', '1'),
('650202', '650200', '独山子区', '1', '650202', null, '2', '1'),
('650203', '650200', '克拉玛依区', '1', '650203', null, '2', '1'),
('650204', '650200', '白碱滩区', '1', '650204', null, '2', '1'),
('650205', '650200', '乌尔禾区', '1', '650205', null, '2', '1'),
('652100', '650000', '吐鲁番地区', '1', '652100', 'T', '1', '1'),
('652101', '652100', '吐鲁番市', '1', '652101', null, '2', '1'),
('652122', '652100', '鄯善县', '1', '652122', null, '2', '1'),
('652123', '652100', '托克逊县', '1', '652123', null, '2', '1'),
('652200', '650000', '哈密地区', '1', '652200', 'H', '1', '1'),
('652201', '652200', '哈密市', '1', '652201', null, '2', '1'),
('652222', '652200', '巴里坤县', '1', '652222', null, '2', '1'),
('652223', '652200', '伊吾县', '1', '652223', null, '2', '1'),
('652300', '650000', '昌吉州', '1', '652300', 'C', '1', '1'),
('652301', '652300', '昌吉市', '1', '652301', null, '2', '1'),
('652302', '652300', '阜康市', '1', '652302', null, '2', '1'),
('652303', '652300', '米泉市', '1', '652303', null, '2', '1'),
('652323', '652300', '呼图壁县', '1', '652323', null, '2', '1'),
('652324', '652300', '玛纳斯', '1', '652324', null, '2', '1'),
('652325', '652300', '奇台县', '1', '652325', null, '2', '1'),
('652327', '652300', '吉木萨尔县', '1', '652327', null, '2', '1'),
('652328', '652300', '木垒县', '1', '652328', null, '2', '1'),
('652700', '650000', '博尔塔拉蒙古自治州', '1', '652700', 'B', '1', '1'),
('652701', '652700', '博乐市', '1', '652701', null, '2', '1'),
('652722', '652700', '精河县', '1', '652722', null, '2', '1'),
('652723', '652700', '温泉县', '1', '652723', null, '2', '1'),
('652800', '650000', '巴音郭楞蒙古自治州', '1', '652800', 'B', '1', '1'),
('652801', '652800', '库尔勒市', '1', '652801', null, '2', '1'),
('652822', '652800', '轮台县', '1', '652822', null, '2', '1'),
('652823', '652800', '尉犁县', '1', '652823', null, '2', '1'),
('652824', '652800', '若羌县', '1', '652824', null, '2', '1'),
('652825', '652800', '且末县', '1', '652825', null, '2', '1'),
('652826', '652800', '焉耆县', '1', '652826', null, '2', '1'),
('652827', '652800', '和静县', '1', '652827', null, '2', '1'),
('652828', '652800', '和硕县', '1', '652828', null, '2', '1'),
('652829', '652800', '博湖县', '1', '652829', null, '2', '1'),
('652900', '650000', '阿克苏地区', '1', '652900', 'A', '1', '1'),
('652901', '652900', '阿克苏市', '1', '652901', null, '2', '1'),
('652922', '652900', '温宿县', '1', '652922', null, '2', '1'),
('652923', '652900', '库车县', '1', '652923', null, '2', '1'),
('652924', '652900', '沙雅县', '1', '652924', null, '2', '1'),
('652925', '652900', '新和县', '1', '652925', null, '2', '1'),
('652926', '652900', '拜城县', '1', '652926', null, '2', '1'),
('652927', '652900', '乌什县', '1', '652927', null, '2', '1');
INSERT INTO `wst_areas` VALUES ('652928', '652900', '阿瓦提县', '1', '652928', null, '2', '1'),
('652929', '652900', '柯坪县', '1', '652929', null, '2', '1'),
('653000', '650000', '克州', '1', '653000', 'K', '1', '1'),
('653001', '653000', '阿图什市', '1', '653001', null, '2', '1'),
('653022', '653000', '阿克陶县', '1', '653022', null, '2', '1'),
('653023', '653000', '阿合奇县', '1', '653023', null, '2', '1'),
('653024', '653000', '乌恰县', '1', '653024', null, '2', '1'),
('653100', '650000', '喀什地区', '1', '653100', 'K', '1', '1'),
('653101', '653100', '喀什市', '1', '653101', null, '2', '1'),
('653121', '653100', '疏附县', '1', '653121', null, '2', '1'),
('653122', '653100', '疏勒县', '1', '653122', null, '2', '1'),
('653123', '653100', '英吉沙县', '1', '653123', null, '2', '1'),
('653124', '653100', '泽普县', '1', '653124', null, '2', '1'),
('653125', '653100', '莎车县', '1', '653125', null, '2', '1'),
('653126', '653100', '叶城县', '1', '653126', null, '2', '1'),
('653127', '653100', '麦盖提县', '1', '653127', null, '2', '1'),
('653128', '653100', '岳普湖县', '1', '653128', null, '2', '1'),
('653129', '653100', '伽师县', '1', '653129', null, '2', '1'),
('653130', '653100', '巴楚县', '1', '653130', null, '2', '1'),
('653131', '653100', '塔什库尔干县', '1', '653131', null, '2', '1'),
('653200', '650000', '和田地区', '1', '653200', 'H', '1', '1'),
('653201', '653200', '和田市', '1', '653201', null, '2', '1'),
('653221', '653200', '和田县', '1', '653221', null, '2', '1'),
('653222', '653200', '墨玉县', '1', '653222', null, '2', '1'),
('653223', '653200', '皮山县', '1', '653223', null, '2', '1'),
('653224', '653200', '洛浦县', '1', '653224', null, '2', '1'),
('653225', '653200', '策勒县', '1', '653225', null, '2', '1'),
('653226', '653200', '于田县', '1', '653226', null, '2', '1'),
('653227', '653200', '民丰县', '1', '653227', null, '2', '1'),
('654000', '650000', '伊犁州', '1', '654000', 'Y', '1', '1'),
('654002', '654000', '伊宁市', '1', '654002', null, '2', '1'),
('654003', '654000', '奎屯市', '1', '654003', null, '2', '1'),
('654021', '654000', '伊宁县', '1', '654021', null, '2', '1'),
('654022', '654000', '察布查尔县', '1', '654022', null, '2', '1'),
('654023', '654000', '霍城县', '1', '654023', null, '2', '1'),
('654024', '654000', '巩留县', '1', '654024', null, '2', '1'),
('654025', '654000', '新源县', '1', '654025', null, '2', '1'),
('654026', '654000', '昭苏县', '1', '654026', null, '2', '1'),
('654027', '654000', '特克斯县', '1', '654027', null, '2', '1'),
('654028', '654000', '尼勒克县', '1', '654028', null, '2', '1'),
('654200', '650000', '塔城地区', '1', '654200', 'T', '1', '1'),
('654201', '654200', '塔城市', '1', '654201', null, '2', '1'),
('654202', '654200', '乌苏市', '1', '654202', null, '2', '1'),
('654221', '654200', '额敏县', '1', '654221', null, '2', '1'),
('654223', '654200', '沙湾县', '1', '654223', null, '2', '1'),
('654224', '654200', '托里县', '1', '654224', null, '2', '1'),
('654225', '654200', '裕民县', '1', '654225', null, '2', '1'),
('654226', '654200', '和布克赛尔蒙古自治县', '1', '654226', null, '2', '1'),
('654300', '650000', '阿勒泰地区', '1', '654300', 'A', '1', '1'),
('654301', '654300', '阿勒泰市', '1', '654301', null, '2', '1'),
('654321', '654300', '布尔津县', '1', '654321', null, '2', '1'),
('654322', '654300', '富蕴县', '1', '654322', null, '2', '1'),
('654323', '654300', '福海县', '1', '654323', null, '2', '1'),
('654324', '654300', '哈巴河县', '1', '654324', null, '2', '1'),
('654325', '654300', '青河县', '1', '654325', null, '2', '1'),
('654326', '654300', '吉木乃县', '1', '654326', null, '2', '1'),
('820332', '0', '广东省', '1', '0', 'G', '0', '1'),
('820333', '820332', '潮州市', '1', '0', 'C', '1', '1'),
('820334', '820333', '湘桥区', '1', '0', '', '2', '1'),
('820335', '820334', '湘桥街道', '1', '0', '', '3', '1'),
('820341', '820334', '西湖街道', '1', '5', '', '3', '1'),
('820348', '820334', '金山街道', '1', '11', '', '3', '1'),
('820353', '820334', '太平街道', '1', '15', '', '3', '1'),
('820360', '820334', '南春街道', '1', '21', '', '3', '1'),
('820366', '820334', '西新街道', '1', '26', '', '3', '1'),
('820371', '820334', '桥东街道', '1', '30', '', '3', '1'),
('820382', '820334', '城西街道', '1', '40', '', '3', '1'),
('820402', '820334', '凤新街道', '1', '59', '', '3', '1'),
('820421', '820334', '意溪镇', '1', '77', '', '3', '1'),
('820449', '820334', '磷溪镇', '1', '104', '', '3', '1'),
('820482', '820334', '铁铺镇', '1', '136', '', '3', '1'),
('820507', '820334', '官塘镇', '1', '160', '', '3', '1'),
('820524', '820334', '红山林场', '1', '176', '', '3', '1'),
('820526', '820334', '开发区', '1', '177', '', '3', '1'),
('820528', '820333', '潮安区', '1', '178', '', '2', '1'),
('820529', '820528', '古巷镇', '1', '178', '', '3', '1'),
('820549', '820528', '登塘镇', '1', '197', '', '3', '1'),
('820579', '820528', '凤塘镇', '1', '226', '', '3', '1'),
('820611', '820528', '浮洋镇', '1', '257', '', '3', '1'),
('820651', '820528', '龙湖镇', '1', '296', '', '3', '1'),
('820668', '820528', '金石镇', '1', '312', '', '3', '1'),
('820691', '820528', '沙溪镇', '1', '334', '', '3', '1'),
('820710', '820528', '彩塘镇', '1', '352', '', '3', '1'),
('820744', '820528', '东凤镇', '1', '385', '', '3', '1'),
('820780', '820528', '江东镇', '1', '420', '', '3', '1'),
('820811', '820528', '归湖镇', '1', '450', '', '3', '1'),
('820846', '820528', '文祠镇', '1', '484', '', '3', '1'),
('820870', '820528', '凤凰镇', '1', '507', '', '3', '1'),
('820900', '820528', '赤凤镇', '1', '536', '', '3', '1'),
('820953', '820528', '庵埠镇', '1', '587', '', '3', '1'),
('820990', '820528', '万峰林场', '1', '623', '', '3', '1'),
('820997', '820528', '大坑苗圃场', '1', '629', '', '3', '1'),
('820999', '820528', '东山湖农场', '1', '630', '', '3', '1'),
('821001', '820528', '庵埠经济开发试验区', '1', '631', '', '3', '1'),
('821006', '820333', '饶平县', '1', '633', '', '2', '1'),
('821007', '821006', '黄冈镇', '1', '633', '', '3', '1'),
('821044', '821006', '上饶镇', '1', '669', '', '3', '1'),
('821069', '821006', '饶洋镇', '1', '693', '', '3', '1'),
('821096', '821006', '新丰镇', '1', '719', '', '3', '1'),
('821116', '821006', '建饶镇', '1', '738', '', '3', '1');
INSERT INTO `wst_areas` VALUES ('821132', '821006', '三饶镇', '1', '753', '', '3', '1'),
('821149', '821006', '新塘镇', '1', '769', '', '3', '1'),
('821164', '821006', '汤溪镇', '1', '783', '', '3', '1'),
('821178', '821006', '浮滨镇', '1', '796', '', '3', '1'),
('821211', '821006', '浮山镇', '1', '828', '', '3', '1'),
('821231', '821006', '东山镇', '1', '847', '', '3', '1'),
('821242', '821006', '新圩镇', '1', '857', '', '3', '1'),
('821273', '821006', '樟溪镇', '1', '887', '', '3', '1'),
('821296', '821006', '钱东镇', '1', '909', '', '3', '1'),
('821326', '821006', '高堂镇', '1', '938', '', '3', '1'),
('821340', '821006', '联饶镇', '1', '951', '', '3', '1'),
('821365', '821006', '所城镇', '1', '975', '', '3', '1'),
('821378', '821006', '大埕镇', '1', '987', '', '3', '1'),
('821386', '821006', '柘林镇', '1', '994', '', '3', '1'),
('821393', '821006', '井洲镇', '1', '1000', '', '3', '1'),
('821407', '821006', '海山镇', '1', '1013', '', '3', '1'),
('821425', '821006', '韩江林场', '1', '1030', '', '3', '1'),
('821429', '820332', '汕头市', '1', '0', 'S', '1', '1'),
('821430', '821429', '龙湖区', '1', '0', '', '2', '1'),
('821431', '821430', '金霞街道', '1', '0', '', '3', '1'),
('821445', '821430', '珠池街道', '1', '13', '', '3', '1'),
('821462', '821430', '新津街道', '1', '29', '', '3', '1'),
('821485', '821430', '鸥汀街道', '1', '51', '', '3', '1'),
('821504', '821430', '龙祥街道', '1', '69', '', '3', '1'),
('821513', '821430', '外砂镇', '1', '77', '', '3', '1'),
('821531', '821430', '新溪镇', '1', '94', '', '3', '1'),
('821548', '821429', '金平区', '1', '110', '', '2', '1'),
('821549', '821548', '石炮台街道', '1', '110', '', '3', '1'),
('821563', '821548', '金砂街道', '1', '123', '', '3', '1'),
('821574', '821548', '金厦街道', '1', '133', '', '3', '1'),
('821587', '821548', '东方街道', '1', '145', '', '3', '1'),
('821599', '821548', '大华街道', '1', '156', '', '3', '1'),
('821612', '821548', '同益街道', '1', '168', '', '3', '1'),
('821620', '821548', '光华街道', '1', '175', '', '3', '1'),
('821630', '821548', '东墩街道', '1', '184', '', '3', '1'),
('821637', '821548', '广厦街道', '1', '190', '', '3', '1'),
('821649', '821548', '海安街道', '1', '201', '', '3', '1'),
('821657', '821548', '新福街道', '1', '208', '', '3', '1'),
('821666', '821548', '乌桥街道', '1', '216', '', '3', '1'),
('821672', '821548', '岐山街道', '1', '221', '', '3', '1'),
('821683', '821548', '永祥街道', '1', '231', '', '3', '1'),
('821691', '821548', '鮀莲街道', '1', '238', '', '3', '1'),
('821708', '821548', '鮀江街道', '1', '254', '', '3', '1'),
('821726', '821548', '月浦街道', '1', '271', '', '3', '1'),
('821732', '821429', '濠江区', '1', '276', '', '2', '1'),
('821733', '821732', '达濠街道', '1', '276', '', '3', '1'),
('821744', '821732', '马窖街道', '1', '286', '', '3', '1'),
('821752', '821732', '礐石街道', '1', '293', '', '3', '1'),
('821769', '821732', '广澳街道', '1', '309', '', '3', '1'),
('821777', '821732', '滨海街道', '1', '316', '', '3', '1'),
('821787', '821732', '河浦街道', '1', '325', '', '3', '1'),
('821793', '821732', '玉新街道', '1', '330', '', '3', '1'),
('821800', '821429', '潮阳区', '1', '336', '', '2', '1'),
('821801', '821800', '文光街道', '1', '336', '', '3', '1'),
('821812', '821800', '棉北街道', '1', '346', '', '3', '1'),
('821822', '821800', '城南街道', '1', '355', '', '3', '1'),
('821837', '821800', '金浦街道', '1', '369', '', '3', '1'),
('821843', '821800', '海门镇', '1', '374', '', '3', '1'),
('821860', '821800', '河溪镇', '1', '390', '', '3', '1'),
('821873', '821800', '和平镇', '1', '402', '', '3', '1'),
('821895', '821800', '西胪镇', '1', '423', '', '3', '1'),
('821923', '821800', '关埠镇', '1', '450', '', '3', '1'),
('821954', '821800', '谷饶镇', '1', '480', '', '3', '1'),
('821982', '821800', '贵屿镇', '1', '507', '', '3', '1'),
('822010', '821800', '铜盂镇', '1', '534', '', '3', '1'),
('822039', '821800', '金灶镇', '1', '562', '', '3', '1'),
('822086', '821429', '潮南区', '1', '608', '', '2', '1'),
('822087', '822086', '峡山街道', '1', '608', '', '3', '1'),
('822124', '822086', '井都镇', '1', '644', '', '3', '1'),
('822138', '822086', '成田镇', '1', '657', '', '3', '1'),
('822154', '822086', '司马浦镇', '1', '672', '', '3', '1'),
('822174', '822086', '陈店镇', '1', '691', '', '3', '1'),
('822198', '822086', '两英镇', '1', '714', '', '3', '1'),
('822229', '822086', '仙城镇', '1', '744', '', '3', '1'),
('822242', '822086', '胪岗镇', '1', '756', '', '3', '1'),
('822257', '822086', '红场镇', '1', '770', '', '3', '1'),
('822283', '822086', '雷岭镇', '1', '795', '', '3', '1'),
('822299', '822086', '陇田镇', '1', '810', '', '3', '1'),
('822331', '821429', '澄海区', '1', '841', '', '2', '1'),
('822332', '822331', '凤翔街道', '1', '841', '', '3', '1'),
('822352', '822331', '广益街道', '1', '860', '', '3', '1'),
('822364', '822331', '澄华街道', '1', '871', '', '3', '1'),
('822375', '822331', '上华镇', '1', '881', '', '3', '1'),
('822391', '822331', '隆都镇', '1', '896', '', '3', '1'),
('822407', '822331', '莲下镇', '1', '911', '', '3', '1'),
('822438', '822331', '莲上镇', '1', '941', '', '3', '1'),
('822447', '822331', '溪南镇', '1', '949', '', '3', '1'),
('822469', '822331', '东里镇', '1', '970', '', '3', '1'),
('822491', '822331', '盐鸿镇', '1', '991', '', '3', '1'),
('822501', '822331', '莲华镇', '1', '1000', '', '3', '1'),
('822519', '821429', '南澳县', '1', '1017', '', '2', '1'),
('822520', '822519', '后宅镇', '1', '1017', '', '3', '1'),
('822539', '822519', '云澳镇', '1', '1035', '', '3', '1'),
('822548', '822519', '深澳镇', '1', '1043', '', '3', '1'),
('823430', '820332', '揭阳市', '1', '0', 'J', '1', '1'),
('823431', '823430', '榕城区', '1', '0', '', '2', '1'),
('823432', '823431', '榕华街道办事处', '1', '0', '', '3', '1'),
('823444', '823431', '新兴街道办事处', '1', '11', '', '3', '1'),
('823453', '823431', '中山街道办事处', '1', '19', '', '3', '1'),
('823458', '823431', '西马街道办事处', '1', '23', '', '3', '1');
INSERT INTO `wst_areas` VALUES ('823466', '823431', '东山街道办事处', '1', '30', '', '3', '1'),
('823497', '823431', '榕东街道办事处', '1', '60', '', '3', '1'),
('823512', '823431', '仙桥街道办事处', '1', '74', '', '3', '1'),
('823529', '823431', '梅云街道办事处', '1', '90', '', '3', '1'),
('823550', '823431', '渔湖镇', '1', '110', '', '3', '1'),
('823588', '823431', '磐东镇', '1', '147', '', '3', '1'),
('823606', '823431', '东山工业园区管理处', '1', '164', '', '3', '1'),
('823608', '823430', '揭东县', '1', '165', '', '2', '1'),
('823609', '823608', '曲溪街道办事处', '1', '165', '', '3', '1'),
('823631', '823608', '云路镇', '1', '186', '', '3', '1'),
('823653', '823608', '玉窖镇', '1', '207', '', '3', '1'),
('823665', '823608', '登岗镇', '1', '218', '', '3', '1'),
('823680', '823608', '炮台镇', '1', '232', '', '3', '1'),
('823693', '823608', '地都镇', '1', '244', '', '3', '1'),
('823718', '823608', '霖磐镇', '1', '268', '', '3', '1'),
('823731', '823608', '月城镇', '1', '280', '', '3', '1'),
('823747', '823608', '白塔镇', '1', '295', '', '3', '1'),
('823767', '823608', '龙尾镇', '1', '314', '', '3', '1'),
('823778', '823608', '桂岭镇', '1', '324', '', '3', '1'),
('823796', '823608', '锡场镇', '1', '341', '', '3', '1'),
('823809', '823608', '新亨镇', '1', '353', '', '3', '1'),
('823824', '823608', '玉湖镇', '1', '367', '', '3', '1'),
('823846', '823608', '埔田镇', '1', '388', '', '3', '1'),
('823868', '823608', '东径茶场', '1', '409', '', '3', '1'),
('823870', '823608', '坪上农场', '1', '410', '', '3', '1'),
('823872', '823608', '卅岭农场', '1', '411', '', '3', '1'),
('823874', '823430', '揭西县', '1', '412', '', '2', '1'),
('823875', '823874', '河婆街道办事处', '1', '412', '', '3', '1'),
('823911', '823874', '龙潭镇', '1', '447', '', '3', '1'),
('823928', '823874', '南山镇', '1', '463', '', '3', '1'),
('823948', '823874', '五经富镇', '1', '482', '', '3', '1'),
('823977', '823874', '京溪园镇', '1', '510', '', '3', '1'),
('823992', '823874', '灰寨镇', '1', '524', '', '3', '1'),
('824010', '823874', '塔头镇', '1', '541', '', '3', '1'),
('824026', '823874', '东园镇', '1', '556', '', '3', '1'),
('824038', '823874', '凤江镇', '1', '567', '', '3', '1'),
('824055', '823874', '棉湖镇', '1', '583', '', '3', '1'),
('824083', '823874', '金和镇', '1', '610', '', '3', '1'),
('824098', '823874', '大溪镇', '1', '624', '', '3', '1'),
('824116', '823874', '钱坑镇', '1', '641', '', '3', '1'),
('824131', '823874', '坪上镇', '1', '655', '', '3', '1'),
('824152', '823874', '五云镇', '1', '675', '', '3', '1'),
('824174', '823874', '上砂镇', '1', '696', '', '3', '1'),
('824198', '823874', '良田乡', '1', '719', '', '3', '1'),
('824210', '823874', '北山农林场', '1', '730', '', '3', '1'),
('824212', '823874', '果林场', '1', '731', '', '3', '1'),
('824214', '823874', '油桐林场', '1', '732', '', '3', '1'),
('824216', '823874', '高田农场', '1', '733', '', '3', '1'),
('824218', '823874', '河輋农场', '1', '734', '', '3', '1'),
('824220', '823874', '县苗圃场', '1', '735', '', '3', '1'),
('824222', '823430', '惠来县', '1', '736', '', '2', '1'),
('824223', '824222', '惠城镇', '1', '736', '', '3', '1'),
('824257', '824222', '华湖镇', '1', '769', '', '3', '1'),
('824276', '824222', '仙庵镇', '1', '787', '', '3', '1'),
('824298', '824222', '靖海镇', '1', '808', '', '3', '1'),
('824322', '824222', '周田镇', '1', '831', '', '3', '1'),
('824341', '824222', '前詹镇', '1', '849', '', '3', '1'),
('824363', '824222', '神泉镇', '1', '870', '', '3', '1'),
('824385', '824222', '东陇镇', '1', '891', '', '3', '1'),
('824399', '824222', '岐石镇', '1', '904', '', '3', '1'),
('824451', '824222', '溪西镇', '1', '955', '', '3', '1'),
('824473', '824222', '鳌江镇', '1', '976', '', '3', '1'),
('824491', '824222', '东港镇', '1', '993', '', '3', '1'),
('824508', '824222', '葵潭镇', '1', '1009', '', '3', '1'),
('824535', '824222', '东埔农场', '1', '1035', '', '3', '1'),
('824542', '824222', '揭阳市大南山华侨管理区', '1', '1041', '', '3', '1'),
('824563', '824222', '葵潭农场', '1', '1076', '', '3', '1'),
('824565', '824222', '青坑林场', '1', '1077', '', '3', '1'),
('824567', '824222', '南海农林场', '1', '1078', '', '3', '1'),
('824569', '823430', '普宁市', '1', '1079', '', '2', '1'),
('824570', '824569', '流沙东街道', '1', '1079', '', '3', '1'),
('824588', '824569', '流沙南街道', '1', '1096', '', '3', '1'),
('824602', '824569', '流沙西街道', '1', '1109', '', '3', '1'),
('824616', '824569', '流沙北街道', '1', '1122', '', '3', '1'),
('824629', '824569', '池尾街道', '1', '1134', '', '3', '1'),
('824651', '824569', '赤岗镇', '1', '1155', '', '3', '1'),
('824696', '824569', '洪阳镇', '1', '1199', '', '3', '1'),
('824731', '824569', '南溪镇', '1', '1233', '', '3', '1'),
('824773', '824569', '广太镇', '1', '1274', '', '3', '1'),
('824796', '824569', '麒麟镇', '1', '1296', '', '3', '1'),
('824817', '824569', '南径镇', '1', '1316', '', '3', '1'),
('824839', '824569', '占陇镇', '1', '1337', '', '3', '1'),
('824879', '824569', '军埠镇', '1', '1376', '', '3', '1'),
('824896', '824569', '下架山镇', '1', '1392', '', '3', '1'),
('824930', '824569', '大南山镇', '1', '1425', '', '3', '1'),
('824950', '824569', '高埔镇', '1', '1444', '', '3', '1'),
('824968', '824569', '云落镇', '1', '1461', '', '3', '1'),
('824988', '824569', '大坪镇', '1', '1480', '', '3', '1'),
('825002', '824569', '船埔镇', '1', '1493', '', '3', '1'),
('825032', '824569', '梅林镇', '1', '1522', '', '3', '1'),
('825070', '824569', '里湖镇', '1', '1559', '', '3', '1'),
('825096', '824569', '梅塘镇', '1', '1584', '', '3', '1'),
('825121', '824569', '燎原镇', '1', '1608', '', '3', '1'),
('825133', '824569', '后溪乡', '1', '1619', '', '3', '1'),
('825140', '824569', '大池农场', '1', '1625', '', '3', '1'),
('825149', '824569', '马鞍山农场', '1', '1633', '', '3', '1'),
('825157', '824569', '大坪农场', '1', '1640', '', '3', '1'),
('825163', '824569', '普侨区', '1', '1645', '', '3', '1'),
('825170', '824569', '三坑农场', '1', '1651', '', '3', '1'),
('825172', '824569', '乌石农场', '1', '1652', '', '3', '1'),
('825174', '824569', '科技工业园', '1', '1653', '', '3', '1'),
('825210', '820333', '枫溪区', '1', '0', '', '2', '1'),
('825211', '825210', '长德办事处', '1', '0', '', '3', '1');
INSERT INTO `wst_areas` VALUES ('825212', '825210', '路东办事处', '1', '0', '', '3', '1'),
('825213', '825210', '路西办事处', '1', '0', '', '3', '1'),
('110101001', '110101', '东华门街道', '1', '110101001', null, '3', '1'),
('110101002', '110101', '景山街道', '1', '110101002', null, '3', '1'),
('110101003', '110101', '交道口街道', '1', '110101003', null, '3', '1'),
('110101004', '110101', '安定门街道', '1', '110101004', null, '3', '1'),
('110101005', '110101', '北新桥街道', '1', '110101005', null, '3', '1'),
('110101006', '110101', '东四街道', '1', '110101006', null, '3', '1'),
('110101007', '110101', '朝阳门街道', '1', '110101007', null, '3', '1'),
('110101008', '110101', '建国门街道', '1', '110101008', null, '3', '1'),
('110101009', '110101', '东直门街道', '1', '110101009', null, '3', '1'),
('110101010', '110101', '和平里街道', '1', '110101010', null, '3', '1'),
('110102001', '110102', '西长安街街道', '1', '110102001', null, '3', '1'),
('110102003', '110102', '新街口街道', '1', '110102003', null, '3', '1'),
('110102007', '110102', '月坛街道', '1', '110102007', null, '3', '1'),
('110102009', '110102', '展览路街道', '1', '110102009', null, '3', '1'),
('110102010', '110102', '德胜街道', '1', '110102010', null, '3', '1'),
('110102011', '110102', '金融街街道', '1', '110102011', null, '3', '1'),
('110102012', '110102', '什刹海街道', '1', '110102012', null, '3', '1'),
('110103001', '110103', '前门街道', '1', '110103001', null, '3', '1'),
('110103002', '110103', '崇文门外街道', '1', '110103002', null, '3', '1'),
('110103003', '110103', '东花市街道', '1', '110103003', null, '3', '1'),
('110103004', '110103', '龙潭街道', '1', '110103004', null, '3', '1'),
('110103005', '110103', '体育馆路街道', '1', '110103005', null, '3', '1'),
('110103006', '110103', '天坛街道', '1', '110103006', null, '3', '1'),
('110103007', '110103', '永定门外街道', '1', '110103007', null, '3', '1'),
('110104001', '110104', '大栅栏街道', '1', '110104001', null, '3', '1'),
('110104002', '110104', '天桥街道', '1', '110104002', null, '3', '1'),
('110104003', '110104', '椿树街道', '1', '110104003', null, '3', '1'),
('110104004', '110104', '陶然亭街道', '1', '110104004', null, '3', '1'),
('110104005', '110104', '广安门内街道', '1', '110104005', null, '3', '1'),
('110104006', '110104', '牛街街道', '1', '110104006', null, '3', '1'),
('110104007', '110104', '白纸坊街道', '1', '110104007', null, '3', '1'),
('110104008', '110104', '广安门外街道', '1', '110104008', null, '3', '1'),
('110105001', '110105', '建外街道', '1', '110105001', null, '3', '1'),
('110105002', '110105', '朝外街道', '1', '110105002', null, '3', '1'),
('110105003', '110105', '呼家楼街道', '1', '110105003', null, '3', '1'),
('110105004', '110105', '三里屯街道', '1', '110105004', null, '3', '1'),
('110105005', '110105', '左家庄街道', '1', '110105005', null, '3', '1'),
('110105006', '110105', '香河园街道', '1', '110105006', null, '3', '1'),
('110105007', '110105', '和平街街道', '1', '110105007', null, '3', '1'),
('110105008', '110105', '安贞街道', '1', '110105008', null, '3', '1'),
('110105009', '110105', '亚运村街道', '1', '110105009', null, '3', '1'),
('110105010', '110105', '小关街道', '1', '110105010', null, '3', '1'),
('110105011', '110105', '酒仙桥街道', '1', '110105011', null, '3', '1'),
('110105012', '110105', '麦子店街道', '1', '110105012', null, '3', '1'),
('110105013', '110105', '团结湖街道', '1', '110105013', null, '3', '1'),
('110105014', '110105', '六里屯街道', '1', '110105014', null, '3', '1'),
('110105015', '110105', '八里庄街道', '1', '110105015', null, '3', '1'),
('110105016', '110105', '双井街道', '1', '110105016', null, '3', '1'),
('110105017', '110105', '劲松街道', '1', '110105017', null, '3', '1'),
('110105018', '110105', '潘家园街道', '1', '110105018', null, '3', '1'),
('110105019', '110105', '垡头街道', '1', '110105019', null, '3', '1'),
('110105021', '110105', '南磨房地区', '1', '110105021', null, '3', '1'),
('110105022', '110105', '高碑店地区', '1', '110105022', null, '3', '1'),
('110105023', '110105', '将台地区', '1', '110105023', null, '3', '1'),
('110105024', '110105', '太阳宫地区', '1', '110105024', null, '3', '1'),
('110105025', '110105', '大屯街道', '1', '110105025', null, '3', '1'),
('110105026', '110105', '望京街道', '1', '110105026', null, '3', '1'),
('110105027', '110105', '小红门地区', '1', '110105027', null, '3', '1'),
('110105028', '110105', '十八里店地区', '1', '110105028', null, '3', '1'),
('110105029', '110105', '平房地区', '1', '110105029', null, '3', '1'),
('110105030', '110105', '东风地区', '1', '110105030', null, '3', '1'),
('110105031', '110105', '奥运村地区', '1', '110105031', null, '3', '1'),
('110105032', '110105', '来广营地区', '1', '110105032', null, '3', '1'),
('110105033', '110105', '常营回族地区', '1', '110105033', null, '3', '1'),
('110105034', '110105', '三间房地区', '1', '110105034', null, '3', '1'),
('110105035', '110105', '管庄地区', '1', '110105035', null, '3', '1'),
('110105036', '110105', '金盏地区', '1', '110105036', null, '3', '1'),
('110105037', '110105', '孙河地区', '1', '110105037', null, '3', '1'),
('110105038', '110105', '崔各庄地区', '1', '110105038', null, '3', '1'),
('110105039', '110105', '东坝地区', '1', '110105039', null, '3', '1'),
('110105040', '110105', '黑庄户地区', '1', '110105040', null, '3', '1'),
('110105041', '110105', '豆各庄地区', '1', '110105041', null, '3', '1'),
('110105042', '110105', '王四营地区', '1', '110105042', null, '3', '1'),
('110105400', '110105', '首都机场街道', '1', '110105400', null, '3', '1'),
('110105501', '110105', '望京开发街道', '1', '110105501', null, '3', '1'),
('110106001', '110106', '右安门街道', '1', '110106001', null, '3', '1'),
('110106002', '110106', '太平桥街道', '1', '110106002', null, '3', '1'),
('110106003', '110106', '西罗园街道', '1', '110106003', null, '3', '1'),
('110106004', '110106', '大红门街道', '1', '110106004', null, '3', '1'),
('110106005', '110106', '南苑街道', '1', '110106005', null, '3', '1'),
('110106006', '110106', '东高地街道', '1', '110106006', null, '3', '1'),
('110106007', '110106', '东铁匠营街道', '1', '110106007', null, '3', '1'),
('110106008', '110106', '卢沟桥街道', '1', '110106008', null, '3', '1'),
('110106009', '110106', '丰台街道', '1', '110106009', null, '3', '1'),
('110106010', '110106', '新村街道', '1', '110106010', null, '3', '1'),
('110106011', '110106', '长辛店街道', '1', '110106011', null, '3', '1'),
('110106012', '110106', '云岗街道', '1', '110106012', null, '3', '1'),
('110106013', '110106', '方庄地区', '1', '110106013', null, '3', '1'),
('110106014', '110106', '宛平城地区', '1', '110106014', null, '3', '1'),
('110106015', '110106', '马家堡街道', '1', '110106015', null, '3', '1'),
('110106016', '110106', '和义街道', '1', '110106016', null, '3', '1'),
('110106100', '110106', '长辛店镇', '1', '110106100', null, '3', '1'),
('110106101', '110106', '王佐镇', '1', '110106101', null, '3', '1'),
('110106201', '110106', '卢沟桥乡', '1', '110106201', null, '3', '1'),
('110106202', '110106', '花乡', '1', '110106202', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('110106203', '110106', '南苑乡', '1', '110106203', null, '3', '1'),
('110107001', '110107', '八宝山街道', '1', '110107001', null, '3', '1'),
('110107002', '110107', '老山街道', '1', '110107002', null, '3', '1'),
('110107003', '110107', '八角街道', '1', '110107003', null, '3', '1'),
('110107004', '110107', '古城街道', '1', '110107004', null, '3', '1'),
('110107005', '110107', '苹果园街道', '1', '110107005', null, '3', '1'),
('110107006', '110107', '金顶街街道', '1', '110107006', null, '3', '1'),
('110107009', '110107', '广宁街道', '1', '110107009', null, '3', '1'),
('110107010', '110107', '五里坨街道', '1', '110107010', null, '3', '1'),
('110107011', '110107', '鲁谷社区行政事务管理中心', '1', '110107011', null, '3', '1'),
('110108001', '110108', '万寿路街道', '1', '110108001', null, '3', '1'),
('110108002', '110108', '永定路街道', '1', '110108002', null, '3', '1'),
('110108003', '110108', '羊坊店街道', '1', '110108003', null, '3', '1'),
('110108004', '110108', '甘家口街道', '1', '110108004', null, '3', '1'),
('110108005', '110108', '八里庄街道', '1', '110108005', null, '3', '1'),
('110108006', '110108', '紫竹院街道', '1', '110108006', null, '3', '1'),
('110108007', '110108', '北下关街道', '1', '110108007', null, '3', '1'),
('110108008', '110108', '北太平庄街道', '1', '110108008', null, '3', '1'),
('110108010', '110108', '学院路街道', '1', '110108010', null, '3', '1'),
('110108011', '110108', '中关村街道', '1', '110108011', null, '3', '1'),
('110108012', '110108', '海淀街道', '1', '110108012', null, '3', '1'),
('110108013', '110108', '青龙桥街道', '1', '110108013', null, '3', '1'),
('110108014', '110108', '清华园街道', '1', '110108014', null, '3', '1'),
('110108015', '110108', '燕园街道', '1', '110108015', null, '3', '1'),
('110108016', '110108', '香山街道', '1', '110108016', null, '3', '1'),
('110108017', '110108', '清河街道', '1', '110108017', null, '3', '1'),
('110108018', '110108', '花园路街道', '1', '110108018', null, '3', '1'),
('110108019', '110108', '西三旗街道', '1', '110108019', null, '3', '1'),
('110108020', '110108', '马连洼街道', '1', '110108020', null, '3', '1'),
('110108021', '110108', '田村路街道', '1', '110108021', null, '3', '1'),
('110108022', '110108', '上地街道', '1', '110108022', null, '3', '1'),
('110108023', '110108', '万柳地区', '1', '110108023', null, '3', '1'),
('110108024', '110108', '东升地区', '1', '110108024', null, '3', '1'),
('110108025', '110108', '曙光街道', '1', '110108025', null, '3', '1'),
('110108101', '110108', '温泉镇', '1', '110108101', null, '3', '1'),
('110108102', '110108', '四季青镇', '1', '110108102', null, '3', '1'),
('110108103', '110108', '西北旺镇', '1', '110108103', null, '3', '1'),
('110108104', '110108', '苏家坨镇', '1', '110108104', null, '3', '1'),
('110108105', '110108', '上庄镇', '1', '110108105', null, '3', '1'),
('110109001', '110109', '大峪街道', '1', '110109001', null, '3', '1'),
('110109002', '110109', '城子街道', '1', '110109002', null, '3', '1'),
('110109003', '110109', '东辛房街道', '1', '110109003', null, '3', '1'),
('110109004', '110109', '大台街道', '1', '110109004', null, '3', '1'),
('110109005', '110109', '王平地区', '1', '110109005', null, '3', '1'),
('110109101', '110109', '潭柘寺镇', '1', '110109101', null, '3', '1'),
('110109102', '110109', '永定镇', '1', '110109102', null, '3', '1'),
('110109103', '110109', '龙泉镇', '1', '110109103', null, '3', '1'),
('110109104', '110109', '军庄镇', '1', '110109104', null, '3', '1'),
('110109105', '110109', '雁翅镇', '1', '110109105', null, '3', '1'),
('110109106', '110109', '斋堂镇', '1', '110109106', null, '3', '1'),
('110109107', '110109', '清水镇', '1', '110109107', null, '3', '1'),
('110109108', '110109', '妙峰山镇', '1', '110109108', null, '3', '1'),
('110111001', '110111', '城关街道', '1', '110111001', null, '3', '1'),
('110111002', '110111', '新镇街道', '1', '110111002', null, '3', '1'),
('110111004', '110111', '向阳街道', '1', '110111004', null, '3', '1'),
('110111005', '110111', '东风街道', '1', '110111005', null, '3', '1'),
('110111006', '110111', '迎风街道', '1', '110111006', null, '3', '1'),
('110111007', '110111', '星城街道', '1', '110111007', null, '3', '1'),
('110111008', '110111', '良乡地区', '1', '110111008', null, '3', '1'),
('110111009', '110111', '周口店地区', '1', '110111009', null, '3', '1'),
('110111010', '110111', '琉璃河地区', '1', '110111010', null, '3', '1'),
('110111011', '110111', '拱辰街道', '1', '110111011', null, '3', '1'),
('110111012', '110111', '西潞街道', '1', '110111012', null, '3', '1'),
('110111101', '110111', '阎村镇', '1', '110111101', null, '3', '1'),
('110111103', '110111', '窦店镇', '1', '110111103', null, '3', '1'),
('110111104', '110111', '石楼镇', '1', '110111104', null, '3', '1'),
('110111105', '110111', '长阳镇', '1', '110111105', null, '3', '1'),
('110111107', '110111', '河北镇', '1', '110111107', null, '3', '1'),
('110111108', '110111', '长沟镇', '1', '110111108', null, '3', '1'),
('110111109', '110111', '大石窝镇', '1', '110111109', null, '3', '1'),
('110111110', '110111', '张坊镇', '1', '110111110', null, '3', '1'),
('110111111', '110111', '十渡镇', '1', '110111111', null, '3', '1'),
('110111112', '110111', '青龙湖镇', '1', '110111112', null, '3', '1'),
('110111115', '110111', '韩村河镇', '1', '110111115', null, '3', '1'),
('110111208', '110111', '霞云岭乡', '1', '110111208', null, '3', '1'),
('110111209', '110111', '南窖乡', '1', '110111209', null, '3', '1'),
('110111210', '110111', '佛子庄乡', '1', '110111210', null, '3', '1'),
('110111211', '110111', '大安山乡', '1', '110111211', null, '3', '1'),
('110111212', '110111', '史家营乡', '1', '110111212', null, '3', '1'),
('110111213', '110111', '蒲洼乡', '1', '110111213', null, '3', '1'),
('110112001', '110112', '中仓街道', '1', '110112001', null, '3', '1'),
('110112002', '110112', '新华街道', '1', '110112002', null, '3', '1'),
('110112003', '110112', '北苑街道', '1', '110112003', null, '3', '1'),
('110112004', '110112', '玉桥街道', '1', '110112004', null, '3', '1'),
('110112005', '110112', '永顺地区', '1', '110112005', null, '3', '1'),
('110112006', '110112', '梨园地区', '1', '110112006', null, '3', '1'),
('110112104', '110112', '宋庄镇', '1', '110112104', null, '3', '1'),
('110112105', '110112', '张家湾镇', '1', '110112105', null, '3', '1'),
('110112106', '110112', '漷县镇', '1', '110112106', null, '3', '1'),
('110112109', '110112', '马驹桥镇', '1', '110112109', null, '3', '1'),
('110112110', '110112', '西集镇', '1', '110112110', null, '3', '1'),
('110112114', '110112', '台湖镇', '1', '110112114', null, '3', '1'),
('110112117', '110112', '永乐店镇', '1', '110112117', null, '3', '1'),
('110112119', '110112', '潞城镇', '1', '110112119', null, '3', '1'),
('110112209', '110112', '于家务回族乡', '1', '110112209', null, '3', '1'),
('110113001', '110113', '胜利街道', '1', '110113001', null, '3', '1'),
('110113002', '110113', '光明街道', '1', '110113002', null, '3', '1'),
('110113003', '110113', '仁和地区', '1', '110113003', null, '3', '1'),
('110113004', '110113', '后沙峪地区', '1', '110113004', null, '3', '1'),
('110113005', '110113', '天竺地区', '1', '110113005', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('110113006', '110113', '杨镇地区', '1', '110113006', null, '3', '1'),
('110113007', '110113', '牛栏山地区', '1', '110113007', null, '3', '1'),
('110113008', '110113', '南法信地区', '1', '110113008', null, '3', '1'),
('110113009', '110113', '马坡地区', '1', '110113009', null, '3', '1'),
('110113010', '110113', '石园街道', '1', '110113010', null, '3', '1'),
('110113101', '110113', '高丽营镇', '1', '110113101', null, '3', '1'),
('110113104', '110113', '李桥镇', '1', '110113104', null, '3', '1'),
('110113105', '110113', '李遂镇', '1', '110113105', null, '3', '1'),
('110113106', '110113', '南彩镇', '1', '110113106', null, '3', '1'),
('110113108', '110113', '北务镇', '1', '110113108', null, '3', '1'),
('110113109', '110113', '大孙各庄镇', '1', '110113109', null, '3', '1'),
('110113110', '110113', '张镇', '1', '110113110', null, '3', '1'),
('110113111', '110113', '龙湾屯镇', '1', '110113111', null, '3', '1'),
('110113112', '110113', '木林镇', '1', '110113112', null, '3', '1'),
('110113113', '110113', '北小营镇', '1', '110113113', null, '3', '1'),
('110113115', '110113', '北石槽镇', '1', '110113115', null, '3', '1'),
('110113116', '110113', '赵全营镇', '1', '110113116', null, '3', '1'),
('110114001', '110114', '城北街道', '1', '110114001', null, '3', '1'),
('110114002', '110114', '南口地区', '1', '110114002', null, '3', '1'),
('110114003', '110114', '马池口地区', '1', '110114003', null, '3', '1'),
('110114004', '110114', '沙河地区', '1', '110114004', null, '3', '1'),
('110114005', '110114', '城南街道', '1', '110114005', null, '3', '1'),
('110114006', '110114', '回龙观地区', '1', '110114006', null, '3', '1'),
('110114007', '110114', '东小口地区', '1', '110114007', null, '3', '1'),
('110114104', '110114', '阳坊镇', '1', '110114104', null, '3', '1'),
('110114110', '110114', '小汤山镇', '1', '110114110', null, '3', '1'),
('110114111', '110114', '南邵镇', '1', '110114111', null, '3', '1'),
('110114112', '110114', '崔村镇', '1', '110114112', null, '3', '1'),
('110114113', '110114', '百善镇', '1', '110114113', null, '3', '1'),
('110114115', '110114', '北七家镇', '1', '110114115', null, '3', '1'),
('110114116', '110114', '兴寿镇', '1', '110114116', null, '3', '1'),
('110114117', '110114', '长陵镇', '1', '110114117', null, '3', '1'),
('110114118', '110114', '流村镇', '1', '110114118', null, '3', '1'),
('110114119', '110114', '十三陵镇', '1', '110114119', null, '3', '1'),
('110115001', '110115', '兴丰街道', '1', '110115001', null, '3', '1'),
('110115002', '110115', '林校路街道', '1', '110115002', null, '3', '1'),
('110115003', '110115', '清源街道', '1', '110115003', null, '3', '1'),
('110115004', '110115', '亦庄地区', '1', '110115004', null, '3', '1'),
('110115005', '110115', '黄村地区', '1', '110115005', null, '3', '1'),
('110115006', '110115', '旧宫地区', '1', '110115006', null, '3', '1'),
('110115007', '110115', '西红门地区', '1', '110115007', null, '3', '1'),
('110115103', '110115', '青云店镇', '1', '110115103', null, '3', '1'),
('110115104', '110115', '采育镇', '1', '110115104', null, '3', '1'),
('110115105', '110115', '安定镇', '1', '110115105', null, '3', '1'),
('110115106', '110115', '礼贤镇', '1', '110115106', null, '3', '1'),
('110115107', '110115', '榆垡镇', '1', '110115107', null, '3', '1'),
('110115108', '110115', '庞各庄镇', '1', '110115108', null, '3', '1'),
('110115109', '110115', '北臧村镇', '1', '110115109', null, '3', '1'),
('110115110', '110115', '魏善庄镇', '1', '110115110', null, '3', '1'),
('110115111', '110115', '长子营镇', '1', '110115111', null, '3', '1'),
('110115112', '110115', '瀛海镇', '1', '110115112', null, '3', '1'),
('110115403', '110115', '亦庄开发区', '1', '110115403', null, '3', '1'),
('110116001', '110116', '泉河街道', '1', '110116001', null, '3', '1'),
('110116002', '110116', '龙山街道', '1', '110116002', null, '3', '1'),
('110116003', '110116', '怀柔地区', '1', '110116003', null, '3', '1'),
('110116004', '110116', '雁栖地区', '1', '110116004', null, '3', '1'),
('110116005', '110116', '庙城地区', '1', '110116005', null, '3', '1'),
('110116102', '110116', '北房镇', '1', '110116102', null, '3', '1'),
('110116103', '110116', '杨宋镇', '1', '110116103', null, '3', '1'),
('110116105', '110116', '桥梓镇', '1', '110116105', null, '3', '1'),
('110116106', '110116', '怀北镇', '1', '110116106', null, '3', '1'),
('110116107', '110116', '汤河口镇', '1', '110116107', null, '3', '1'),
('110116108', '110116', '渤海镇', '1', '110116108', null, '3', '1'),
('110116109', '110116', '九渡河镇', '1', '110116109', null, '3', '1'),
('110116110', '110116', '琉璃庙镇', '1', '110116110', null, '3', '1'),
('110116111', '110116', '宝山镇', '1', '110116111', null, '3', '1'),
('110116211', '110116', '长哨营满族乡', '1', '110116211', null, '3', '1'),
('110116213', '110116', '喇叭沟门满族乡', '1', '110116213', null, '3', '1'),
('110117001', '110117', '滨河街道', '1', '110117001', null, '3', '1'),
('110117002', '110117', '兴谷街道', '1', '110117002', null, '3', '1'),
('110117003', '110117', '渔阳地区', '1', '110117003', null, '3', '1'),
('110117004', '110117', '峪口地区', '1', '110117004', null, '3', '1'),
('110117005', '110117', '马坊地区', '1', '110117005', null, '3', '1'),
('110117006', '110117', '金海湖地区', '1', '110117006', null, '3', '1'),
('110117101', '110117', '东高村镇', '1', '110117101', null, '3', '1'),
('110117102', '110117', '山东庄镇', '1', '110117102', null, '3', '1'),
('110117104', '110117', '南独乐河镇', '1', '110117104', null, '3', '1'),
('110117105', '110117', '大华山镇', '1', '110117105', null, '3', '1'),
('110117106', '110117', '夏各庄镇', '1', '110117106', null, '3', '1'),
('110117108', '110117', '马昌营镇', '1', '110117108', null, '3', '1'),
('110117110', '110117', '王辛庄镇', '1', '110117110', null, '3', '1'),
('110117111', '110117', '大兴庄镇', '1', '110117111', null, '3', '1'),
('110117112', '110117', '刘家店镇', '1', '110117112', null, '3', '1'),
('110117114', '110117', '镇罗营镇', '1', '110117114', null, '3', '1'),
('110117213', '110117', '黄松峪乡', '1', '110117213', null, '3', '1'),
('110117214', '110117', '熊儿寨乡', '1', '110117214', null, '3', '1'),
('110228001', '110228', '鼓楼街道', '1', '110228001', null, '3', '1'),
('110228002', '110228', '果园街道', '1', '110228002', null, '3', '1'),
('110228003', '110228', '檀营地区', '1', '110228003', null, '3', '1'),
('110228100', '110228', '密云镇', '1', '110228100', null, '3', '1'),
('110228101', '110228', '溪翁庄镇', '1', '110228101', null, '3', '1'),
('110228102', '110228', '西田各庄镇', '1', '110228102', null, '3', '1'),
('110228103', '110228', '十里堡镇', '1', '110228103', null, '3', '1'),
('110228104', '110228', '河南寨镇', '1', '110228104', null, '3', '1'),
('110228105', '110228', '巨各庄镇', '1', '110228105', null, '3', '1'),
('110228106', '110228', '穆家峪镇', '1', '110228106', null, '3', '1'),
('110228107', '110228', '太师屯镇', '1', '110228107', null, '3', '1'),
('110228108', '110228', '高岭镇', '1', '110228108', null, '3', '1'),
('110228109', '110228', '不老屯镇', '1', '110228109', null, '3', '1'),
('110228110', '110228', '冯家峪镇', '1', '110228110', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('110228111', '110228', '古北口镇', '1', '110228111', null, '3', '1'),
('110228112', '110228', '大城子镇', '1', '110228112', null, '3', '1'),
('110228113', '110228', '东邵渠镇', '1', '110228113', null, '3', '1'),
('110228114', '110228', '北庄镇', '1', '110228114', null, '3', '1'),
('110228115', '110228', '新城子镇', '1', '110228115', null, '3', '1'),
('110228116', '110228', '石城镇', '1', '110228116', null, '3', '1'),
('110229100', '110229', '延庆镇', '1', '110229100', null, '3', '1'),
('110229101', '110229', '康庄镇', '1', '110229101', null, '3', '1'),
('110229102', '110229', '八达岭镇', '1', '110229102', null, '3', '1'),
('110229103', '110229', '永宁镇', '1', '110229103', null, '3', '1'),
('110229104', '110229', '旧县镇', '1', '110229104', null, '3', '1'),
('110229105', '110229', '张山营镇', '1', '110229105', null, '3', '1'),
('110229106', '110229', '四海镇', '1', '110229106', null, '3', '1'),
('110229107', '110229', '千家店镇', '1', '110229107', null, '3', '1'),
('110229108', '110229', '沈家营镇', '1', '110229108', null, '3', '1'),
('110229109', '110229', '大榆树镇', '1', '110229109', null, '3', '1'),
('110229110', '110229', '井庄镇', '1', '110229110', null, '3', '1'),
('110229207', '110229', '大庄科乡', '1', '110229207', null, '3', '1'),
('110229209', '110229', '刘斌堡乡', '1', '110229209', null, '3', '1'),
('110229210', '110229', '香营乡', '1', '110229210', null, '3', '1'),
('110229214', '110229', '珍珠泉乡', '1', '110229214', null, '3', '1'),
('120101001', '120101', '劝业场街道', '1', '120101001', null, '3', '1'),
('120101002', '120101', '小白楼街道', '1', '120101002', null, '3', '1'),
('120101003', '120101', '体育馆街道', '1', '120101003', null, '3', '1'),
('120101004', '120101', '新兴街道', '1', '120101004', null, '3', '1'),
('120101005', '120101', '南营门社区街道', '1', '120101005', null, '3', '1'),
('120101006', '120101', '南市街道', '1', '120101006', null, '3', '1'),
('120102001', '120102', '大王庄街道', '1', '120102001', null, '3', '1'),
('120102002', '120102', '大直沽街道', '1', '120102002', null, '3', '1'),
('120102003', '120102', '中山门街道', '1', '120102003', null, '3', '1'),
('120102004', '120102', '富民路街道', '1', '120102004', null, '3', '1'),
('120102005', '120102', '二号桥街道', '1', '120102005', null, '3', '1'),
('120102006', '120102', '春华街道', '1', '120102006', null, '3', '1'),
('120102007', '120102', '唐家口街道', '1', '120102007', null, '3', '1'),
('120102008', '120102', '向阳楼街道', '1', '120102008', null, '3', '1'),
('120102009', '120102', '常州道街道', '1', '120102009', null, '3', '1'),
('120102010', '120102', '上杭路街道', '1', '120102010', null, '3', '1'),
('120102011', '120102', '东新街道', '1', '120102011', null, '3', '1'),
('120102012', '120102', '鲁山道街道', '1', '120102012', null, '3', '1'),
('120102013', '120102', '天津铁厂街道', '1', '120102013', null, '3', '1'),
('120103001', '120103', '大营门街道', '1', '120103001', null, '3', '1'),
('120103002', '120103', '下瓦房街道', '1', '120103002', null, '3', '1'),
('120103003', '120103', '桃园街道', '1', '120103003', null, '3', '1'),
('120103004', '120103', '挂甲寺街道', '1', '120103004', null, '3', '1'),
('120103005', '120103', '马场街道', '1', '120103005', null, '3', '1'),
('120103006', '120103', '越秀路街道', '1', '120103006', null, '3', '1'),
('120103007', '120103', '友谊路街道', '1', '120103007', null, '3', '1'),
('120103008', '120103', '天塔街道', '1', '120103008', null, '3', '1'),
('120103009', '120103', '尖山街道', '1', '120103009', null, '3', '1'),
('120103010', '120103', '陈塘庄街道', '1', '120103010', null, '3', '1'),
('120103011', '120103', '柳林街道', '1', '120103011', null, '3', '1'),
('120103012', '120103', '东海街道', '1', '120103012', null, '3', '1'),
('120103400', '120103', '梅江虚拟街道', '1', '120103400', null, '3', '1'),
('120104001', '120104', '长虹街道', '1', '120104001', null, '3', '1'),
('120104002', '120104', '鼓楼街道', '1', '120104002', null, '3', '1'),
('120104003', '120104', '兴南街道', '1', '120104003', null, '3', '1'),
('120104004', '120104', '广开街道', '1', '120104004', null, '3', '1'),
('120104005', '120104', '万兴街道', '1', '120104005', null, '3', '1'),
('120104006', '120104', '学府街道', '1', '120104006', null, '3', '1'),
('120104007', '120104', '向阳路街道', '1', '120104007', null, '3', '1'),
('120104008', '120104', '嘉陵道街道', '1', '120104008', null, '3', '1'),
('120104009', '120104', '王顶堤街道', '1', '120104009', null, '3', '1'),
('120104010', '120104', '水上公园街道', '1', '120104010', null, '3', '1'),
('120104011', '120104', '体育中心街道', '1', '120104011', null, '3', '1'),
('120104012', '120104', '华苑街道', '1', '120104012', null, '3', '1'),
('120105001', '120105', '光复道街道', '1', '120105001', null, '3', '1'),
('120105002', '120105', '望海楼街道', '1', '120105002', null, '3', '1'),
('120105003', '120105', '鸿顺里街道', '1', '120105003', null, '3', '1'),
('120105004', '120105', '新开河街道', '1', '120105004', null, '3', '1'),
('120105005', '120105', '铁东路街道', '1', '120105005', null, '3', '1'),
('120105006', '120105', '建昌道街道', '1', '120105006', null, '3', '1'),
('120105007', '120105', '宁园街道', '1', '120105007', null, '3', '1'),
('120105008', '120105', '王串场街道', '1', '120105008', null, '3', '1'),
('120105009', '120105', '江都路街道', '1', '120105009', null, '3', '1'),
('120105010', '120105', '月牙河街道', '1', '120105010', null, '3', '1'),
('120106001', '120106', '西于庄街道', '1', '120106001', null, '3', '1'),
('120106002', '120106', '双环村街道', '1', '120106002', null, '3', '1'),
('120106003', '120106', '咸阳北路街道', '1', '120106003', null, '3', '1'),
('120106004', '120106', '丁字沽街道', '1', '120106004', null, '3', '1'),
('120106005', '120106', '西沽街道', '1', '120106005', null, '3', '1'),
('120106006', '120106', '三条石街道', '1', '120106006', null, '3', '1'),
('120106008', '120106', '邵公庄街道', '1', '120106008', null, '3', '1'),
('120106009', '120106', '芥园街道', '1', '120106009', null, '3', '1'),
('120106010', '120106', '铃铛阁街道', '1', '120106010', null, '3', '1'),
('120106011', '120106', '大胡同街道', '1', '120106011', null, '3', '1'),
('120107001', '120107', '新村街道', '1', '120107001', null, '3', '1'),
('120107002', '120107', '解放路街道', '1', '120107002', null, '3', '1'),
('120107003', '120107', '三槐路街道', '1', '120107003', null, '3', '1'),
('120107004', '120107', '新港街道', '1', '120107004', null, '3', '1'),
('120107005', '120107', '向阳街道', '1', '120107005', null, '3', '1'),
('120107006', '120107', '杭州道街道', '1', '120107006', null, '3', '1'),
('120107007', '120107', '新河街道', '1', '120107007', null, '3', '1'),
('120107008', '120107', '大沽街道', '1', '120107008', null, '3', '1'),
('120107009', '120107', '北塘街道', '1', '120107009', null, '3', '1'),
('120107010', '120107', '渤海石油街道', '1', '120107010', null, '3', '1'),
('120107011', '120107', '胡家园街道', '1', '120107011', null, '3', '1'),
('120107100', '120107', '新城镇', '1', '120107100', null, '3', '1'),
('120107400', '120107', '开发区虚拟街道', '1', '120107400', null, '3', '1'),
('120107401', '120107', '保税区虚拟街道', '1', '120107401', null, '3', '1'),
('120108001', '120108', '汉沽街道', '1', '120108001', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('120108002', '120108', '寨上街道', '1', '120108002', null, '3', '1'),
('120108003', '120108', '河西街道', '1', '120108003', null, '3', '1'),
('120108005', '120108', '盐场街道', '1', '120108005', null, '3', '1'),
('120108100', '120108', '大田镇', '1', '120108100', null, '3', '1'),
('120108101', '120108', '杨家泊镇', '1', '120108101', null, '3', '1'),
('120108102', '120108', '茶淀镇', '1', '120108102', null, '3', '1'),
('120108103', '120108', '营城镇', '1', '120108103', null, '3', '1'),
('120108400', '120108', '开发区汉沽化工小区虚拟街道', '1', '120108400', null, '3', '1'),
('120109001', '120109', '迎宾街道', '1', '120109001', null, '3', '1'),
('120109002', '120109', '胜利街道', '1', '120109002', null, '3', '1'),
('120109003', '120109', '古林街道', '1', '120109003', null, '3', '1'),
('120109004', '120109', '海滨街道', '1', '120109004', null, '3', '1'),
('120109005', '120109', '港西街道', '1', '120109005', null, '3', '1'),
('120109100', '120109', '太平镇', '1', '120109100', null, '3', '1'),
('120109101', '120109', '小王庄镇', '1', '120109101', null, '3', '1'),
('120109102', '120109', '中塘镇', '1', '120109102', null, '3', '1'),
('120109450', '120109', '北大港农场虚拟镇', '1', '120109450', null, '3', '1'),
('120110001', '120110', '张贵庄街道', '1', '120110001', null, '3', '1'),
('120110002', '120110', '丰年村街道', '1', '120110002', null, '3', '1'),
('120110003', '120110', '万新街道', '1', '120110003', null, '3', '1'),
('120110004', '120110', '无瑕街道', '1', '120110004', null, '3', '1'),
('120110005', '120110', '新立街道', '1', '120110005', null, '3', '1'),
('120110006', '120110', '华明街道', '1', '120110006', null, '3', '1'),
('120110102', '120110', '军粮城镇', '1', '120110102', null, '3', '1'),
('120110105', '120110', '大毕庄镇', '1', '120110105', null, '3', '1'),
('120110200', '120110', '么六桥乡', '1', '120110200', null, '3', '1'),
('120110400', '120110', '开发区西区虚拟街道', '1', '120110400', null, '3', '1'),
('120110401', '120110', '保税区空港国际物流区虚拟街道', '1', '120110401', null, '3', '1'),
('120110402', '120110', '保税区空港国际物流加工区虚拟街道', '1', '120110402', null, '3', '1'),
('120110403', '120110', '东丽区开发区虚拟街道', '1', '120110403', null, '3', '1'),
('120110404', '120110', '东丽湖虚拟街道', '1', '120110404', null, '3', '1'),
('120111001', '120111', '西营门街道', '1', '120111001', null, '3', '1'),
('120111002', '120111', '李七庄街道', '1', '120111002', null, '3', '1'),
('120111100', '120111', '中北镇', '1', '120111100', null, '3', '1'),
('120111101', '120111', '杨柳青镇', '1', '120111101', null, '3', '1'),
('120111102', '120111', '辛口镇', '1', '120111102', null, '3', '1'),
('120111103', '120111', '张家窝镇', '1', '120111103', null, '3', '1'),
('120111104', '120111', '南河镇', '1', '120111104', null, '3', '1'),
('120111105', '120111', '大寺镇', '1', '120111105', null, '3', '1'),
('120111106', '120111', '王稳庄镇', '1', '120111106', null, '3', '1'),
('120111400', '120111', '开发区西青微电子小区虚拟街道', '1', '120111400', null, '3', '1'),
('120111401', '120111', '新技术产业园区虚拟街', '1', '120111401', null, '3', '1'),
('120111450', '120111', '西青区开发区虚拟街道', '1', '120111450', null, '3', '1'),
('120112100', '120112', '咸水沽镇', '1', '120112100', null, '3', '1'),
('120112101', '120112', '葛沽镇', '1', '120112101', null, '3', '1'),
('120112102', '120112', '小站镇', '1', '120112102', null, '3', '1'),
('120112103', '120112', '双港镇', '1', '120112103', null, '3', '1'),
('120112104', '120112', '辛庄镇', '1', '120112104', null, '3', '1'),
('120112106', '120112', '双桥河镇', '1', '120112106', null, '3', '1'),
('120112107', '120112', '八里台镇', '1', '120112107', null, '3', '1'),
('120112108', '120112', '北闸口镇', '1', '120112108', null, '3', '1'),
('120112400', '120112', '双林农场虚拟街', '1', '120112400', null, '3', '1'),
('120112401', '120112', '铁路十八局虚拟街', '1', '120112401', null, '3', '1'),
('120112402', '120112', '津南国家农业园区虚拟街', '1', '120112402', null, '3', '1'),
('120112403', '120112', '长青办事处虚拟街', '1', '120112403', null, '3', '1'),
('120112404', '120112', '津南开发区东区虚拟居街', '1', '120112404', null, '3', '1'),
('120112405', '120112', '津南开发区西区虚拟居街', '1', '120112405', null, '3', '1'),
('120113001', '120113', '果园新村街道', '1', '120113001', null, '3', '1'),
('120113002', '120113', '集贤里街道', '1', '120113002', null, '3', '1'),
('120113003', '120113', '普东街道', '1', '120113003', null, '3', '1'),
('120113004', '120113', '佳荣里街道', '1', '120113004', null, '3', '1'),
('120113100', '120113', '天穆镇', '1', '120113100', null, '3', '1'),
('120113101', '120113', '北仓镇', '1', '120113101', null, '3', '1'),
('120113102', '120113', '双街镇', '1', '120113102', null, '3', '1'),
('120113103', '120113', '双口镇', '1', '120113103', null, '3', '1'),
('120113104', '120113', '青光镇', '1', '120113104', null, '3', '1'),
('120113106', '120113', '宜兴埠镇', '1', '120113106', null, '3', '1'),
('120113107', '120113', '小淀镇', '1', '120113107', null, '3', '1'),
('120113108', '120113', '大张庄镇', '1', '120113108', null, '3', '1'),
('120113111', '120113', '西堤头镇', '1', '120113111', null, '3', '1'),
('120113451', '120113', '红旗农场', '1', '120113451', null, '3', '1'),
('120113452', '120113', '曙光农场', '1', '120113452', null, '3', '1'),
('120114001', '120114', '杨村街道', '1', '120114001', null, '3', '1'),
('120114002', '120114', '下朱庄街道', '1', '120114002', null, '3', '1'),
('120114003', '120114', '东蒲洼街道', '1', '120114003', null, '3', '1'),
('120114004', '120114', '黄庄街道', '1', '120114004', null, '3', '1'),
('120114005', '120114', '徐官屯街道', '1', '120114005', null, '3', '1'),
('120114006', '120114', '运河西街道', '1', '120114006', null, '3', '1'),
('120114101', '120114', '梅厂镇', '1', '120114101', null, '3', '1'),
('120114102', '120114', '大碱厂镇', '1', '120114102', null, '3', '1'),
('120114103', '120114', '崔黄口镇', '1', '120114103', null, '3', '1'),
('120114104', '120114', '大良镇', '1', '120114104', null, '3', '1'),
('120114105', '120114', '下伍旗镇', '1', '120114105', null, '3', '1'),
('120114106', '120114', '南蔡村镇', '1', '120114106', null, '3', '1'),
('120114107', '120114', '大孟庄镇', '1', '120114107', null, '3', '1'),
('120114108', '120114', '泗村店镇', '1', '120114108', null, '3', '1'),
('120114109', '120114', '河西务镇', '1', '120114109', null, '3', '1'),
('120114110', '120114', '城关镇', '1', '120114110', null, '3', '1'),
('120114111', '120114', '东马圈镇', '1', '120114111', null, '3', '1'),
('120114112', '120114', '黄花店镇', '1', '120114112', null, '3', '1'),
('120114113', '120114', '石各庄镇', '1', '120114113', null, '3', '1'),
('120114114', '120114', '王庆坨镇', '1', '120114114', null, '3', '1'),
('120114115', '120114', '汊沽港镇', '1', '120114115', null, '3', '1'),
('120114116', '120114', '河北屯镇', '1', '120114116', null, '3', '1'),
('120114117', '120114', '上马台镇', '1', '120114117', null, '3', '1'),
('120114118', '120114', '大王古庄镇', '1', '120114118', null, '3', '1'),
('120114119', '120114', '陈咀镇', '1', '120114119', null, '3', '1'),
('120114203', '120114', '豆张庄乡', '1', '120114203', null, '3', '1'),
('120114206', '120114', '曹子里乡', '1', '120114206', null, '3', '1'),
('120114207', '120114', '大黄堡乡', '1', '120114207', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('120114213', '120114', '高村乡', '1', '120114213', null, '3', '1'),
('120114214', '120114', '白古屯乡', '1', '120114214', null, '3', '1'),
('120114400', '120114', '开发区武清逸仙园小区虚拟街道', '1', '120114400', null, '3', '1'),
('120114401', '120114', '武清区开发区虚拟街道', '1', '120114401', null, '3', '1'),
('120114450', '120114', '武清农场虚拟镇', '1', '120114450', null, '3', '1'),
('120115001', '120115', '海滨街道', '1', '120115001', null, '3', '1'),
('120115002', '120115', '宝平街道', '1', '120115002', null, '3', '1'),
('120115003', '120115', '钰华街道', '1', '120115003', null, '3', '1'),
('120115101', '120115', '大口屯镇', '1', '120115101', null, '3', '1'),
('120115102', '120115', '大白庄镇', '1', '120115102', null, '3', '1'),
('120115103', '120115', '王卜庄镇', '1', '120115103', null, '3', '1'),
('120115104', '120115', '方家庄镇', '1', '120115104', null, '3', '1'),
('120115105', '120115', '林亭口镇', '1', '120115105', null, '3', '1'),
('120115106', '120115', '八门城镇', '1', '120115106', null, '3', '1'),
('120115107', '120115', '大钟庄镇', '1', '120115107', null, '3', '1'),
('120115108', '120115', '新安镇', '1', '120115108', null, '3', '1'),
('120115110', '120115', '马家店镇', '1', '120115110', null, '3', '1'),
('120115111', '120115', '霍各庄镇', '1', '120115111', null, '3', '1'),
('120115113', '120115', '新开口镇', '1', '120115113', null, '3', '1'),
('120115115', '120115', '大唐庄镇', '1', '120115115', null, '3', '1'),
('120115117', '120115', '高家庄镇', '1', '120115117', null, '3', '1'),
('120115118', '120115', '口东镇', '1', '120115118', null, '3', '1'),
('120115119', '120115', '牛道口镇', '1', '120115119', null, '3', '1'),
('120115120', '120115', '史各庄镇', '1', '120115120', null, '3', '1'),
('120115121', '120115', '郝各庄镇', '1', '120115121', null, '3', '1'),
('120115122', '120115', '周良庄镇', '1', '120115122', null, '3', '1'),
('120115204', '120115', '牛家牌乡', '1', '120115204', null, '3', '1'),
('120115207', '120115', '尔王庄乡', '1', '120115207', null, '3', '1'),
('120115210', '120115', '黄庄乡', '1', '120115210', null, '3', '1'),
('120115450', '120115', '里自沽农场虚拟镇', '1', '120115450', null, '3', '1'),
('120115451', '120115', '黄庄农场虚拟镇', '1', '120115451', null, '3', '1'),
('120115452', '120115', '大钟农场虚拟镇', '1', '120115452', null, '3', '1'),
('120115453', '120115', '天宝工业园区虚拟街', '1', '120115453', null, '3', '1'),
('120115454', '120115', '九园工业园区虚拟街', '1', '120115454', null, '3', '1'),
('120115455', '120115', '京津新城虚拟街', '1', '120115455', null, '3', '1'),
('120221100', '120221', '芦台镇', '1', '120221100', null, '3', '1'),
('120221102', '120221', '宁河镇', '1', '120221102', null, '3', '1'),
('120221103', '120221', '苗庄镇', '1', '120221103', null, '3', '1'),
('120221104', '120221', '丰台镇', '1', '120221104', null, '3', '1'),
('120221105', '120221', '岳龙镇', '1', '120221105', null, '3', '1'),
('120221106', '120221', '板桥镇', '1', '120221106', null, '3', '1'),
('120221107', '120221', '潘庄镇', '1', '120221107', null, '3', '1'),
('120221109', '120221', '造甲城镇', '1', '120221109', null, '3', '1'),
('120221110', '120221', '七里海镇', '1', '120221110', null, '3', '1'),
('120221111', '120221', '大北涧沽镇', '1', '120221111', null, '3', '1'),
('120221112', '120221', '东棘坨镇', '1', '120221112', null, '3', '1'),
('120221204', '120221', '北淮淀乡', '1', '120221204', null, '3', '1'),
('120221205', '120221', '俵口乡', '1', '120221205', null, '3', '1'),
('120221206', '120221', '廉庄子乡', '1', '120221206', null, '3', '1'),
('120221450', '120221', '潘庄农场虚拟镇', '1', '120221450', null, '3', '1'),
('120223100', '120223', '静海镇', '1', '120223100', null, '3', '1'),
('120223101', '120223', '唐官屯镇', '1', '120223101', null, '3', '1'),
('120223102', '120223', '独流镇', '1', '120223102', null, '3', '1'),
('120223103', '120223', '王口镇', '1', '120223103', null, '3', '1'),
('120223104', '120223', '台头镇', '1', '120223104', null, '3', '1'),
('120223105', '120223', '子牙镇', '1', '120223105', null, '3', '1'),
('120223106', '120223', '陈官屯镇', '1', '120223106', null, '3', '1'),
('120223107', '120223', '中旺镇', '1', '120223107', null, '3', '1'),
('120223108', '120223', '大邱庄镇', '1', '120223108', null, '3', '1'),
('120223109', '120223', '蔡公庄镇', '1', '120223109', null, '3', '1'),
('120223110', '120223', '梁头镇', '1', '120223110', null, '3', '1'),
('120223111', '120223', '团泊镇', '1', '120223111', null, '3', '1'),
('120223112', '120223', '双塘镇', '1', '120223112', null, '3', '1'),
('120223113', '120223', '大丰堆镇', '1', '120223113', null, '3', '1'),
('120223114', '120223', '沿庄镇', '1', '120223114', null, '3', '1'),
('120223115', '120223', '西翟庄镇', '1', '120223115', null, '3', '1'),
('120223200', '120223', '良王庄乡', '1', '120223200', null, '3', '1'),
('120223201', '120223', '杨成庄乡', '1', '120223201', null, '3', '1'),
('120223400', '120223', '天津静海经济开发区虚拟街', '1', '120223400', null, '3', '1'),
('120223402', '120223', '天津子牙工业园区虚拟街', '1', '120223402', null, '3', '1'),
('120223403', '120223', '中国石油天然气总公司地调一处虚拟街', '1', '120223403', null, '3', '1'),
('120225001', '120225', '文昌街道', '1', '120225001', null, '3', '1'),
('120225100', '120225', '城关镇', '1', '120225100', null, '3', '1'),
('120225101', '120225', '洇溜镇', '1', '120225101', null, '3', '1'),
('120225102', '120225', '官庄镇', '1', '120225102', null, '3', '1'),
('120225103', '120225', '马伸桥镇', '1', '120225103', null, '3', '1'),
('120225104', '120225', '下营镇', '1', '120225104', null, '3', '1'),
('120225105', '120225', '邦均镇', '1', '120225105', null, '3', '1'),
('120225106', '120225', '别山镇', '1', '120225106', null, '3', '1'),
('120225108', '120225', '尤古庄镇', '1', '120225108', null, '3', '1'),
('120225109', '120225', '上仓镇', '1', '120225109', null, '3', '1'),
('120225111', '120225', '下仓镇', '1', '120225111', null, '3', '1'),
('120225112', '120225', '罗庄子镇', '1', '120225112', null, '3', '1'),
('120225113', '120225', '白涧镇', '1', '120225113', null, '3', '1'),
('120225114', '120225', '五百户镇', '1', '120225114', null, '3', '1'),
('120225115', '120225', '侯家营镇', '1', '120225115', null, '3', '1'),
('120225116', '120225', '桑梓镇', '1', '120225116', null, '3', '1'),
('120225117', '120225', '东施古镇', '1', '120225117', null, '3', '1'),
('120225118', '120225', '下窝头镇', '1', '120225118', null, '3', '1'),
('120225119', '120225', '杨津庄镇', '1', '120225119', null, '3', '1'),
('120225120', '120225', '出头岭镇', '1', '120225120', null, '3', '1'),
('120225121', '120225', '西龙虎峪镇', '1', '120225121', null, '3', '1'),
('120225202', '120225', '穿芳峪乡', '1', '120225202', null, '3', '1'),
('120225203', '120225', '孙各庄乡', '1', '120225203', null, '3', '1'),
('120225208', '120225', '东二营乡', '1', '120225208', null, '3', '1'),
('120225210', '120225', '许家台乡', '1', '120225210', null, '3', '1'),
('120225212', '120225', '礼明庄乡', '1', '120225212', null, '3', '1'),
('120225219', '120225', '东赵各庄乡', '1', '120225219', null, '3', '1'),
('130102001', '130102', '建北街道', '1', '130102001', null, '3', '1'),
('130102002', '130102', '青园街道', '1', '130102002', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('130102003', '130102', '广安街道', '1', '130102003', null, '3', '1'),
('130102004', '130102', '育才街道', '1', '130102004', null, '3', '1'),
('130102005', '130102', '跃进街道', '1', '130102005', null, '3', '1'),
('130102007', '130102', '河东街道', '1', '130102007', null, '3', '1'),
('130102010', '130102', '长丰街道', '1', '130102010', null, '3', '1'),
('130102011', '130102', '谈固街道', '1', '130102011', null, '3', '1'),
('130102100', '130102', '西兆通镇', '1', '130102100', null, '3', '1'),
('130102101', '130102', '南村镇', '1', '130102101', null, '3', '1'),
('130102102', '130102', '高营镇', '1', '130102102', null, '3', '1'),
('130103001', '130103', '中山东路街道', '1', '130103001', null, '3', '1'),
('130103002', '130103', '彭后街道', '1', '130103002', null, '3', '1'),
('130103003', '130103', '东风街道', '1', '130103003', null, '3', '1'),
('130103004', '130103', '东华街道', '1', '130103004', null, '3', '1'),
('130103005', '130103', '休门街道', '1', '130103005', null, '3', '1'),
('130103006', '130103', '阜康街道', '1', '130103006', null, '3', '1'),
('130103007', '130103', '建安街道', '1', '130103007', null, '3', '1'),
('130103008', '130103', '胜利北街道', '1', '130103008', null, '3', '1'),
('130103009', '130103', '汇通街道', '1', '130103009', null, '3', '1'),
('130103101', '130103', '桃园镇', '1', '130103101', null, '3', '1'),
('130104001', '130104', '东里街道', '1', '130104001', null, '3', '1'),
('130104002', '130104', '中山路街道', '1', '130104002', null, '3', '1'),
('130104004', '130104', '南长街道', '1', '130104004', null, '3', '1'),
('130104005', '130104', '维明街道', '1', '130104005', null, '3', '1'),
('130104006', '130104', '裕西街道', '1', '130104006', null, '3', '1'),
('130104007', '130104', '友谊街道', '1', '130104007', null, '3', '1'),
('130104008', '130104', '红旗街道', '1', '130104008', null, '3', '1'),
('130104009', '130104', '新石街道', '1', '130104009', null, '3', '1'),
('130104010', '130104', '苑东街道', '1', '130104010', null, '3', '1'),
('130104011', '130104', '西里街道', '1', '130104011', null, '3', '1'),
('130104012', '130104', '振头街道', '1', '130104012', null, '3', '1'),
('130104201', '130104', '留营乡', '1', '130104201', null, '3', '1'),
('130105001', '130105', '革新街街道', '1', '130105001', null, '3', '1'),
('130105003', '130105', '新华路街道', '1', '130105003', null, '3', '1'),
('130105004', '130105', '宁安路街道', '1', '130105004', null, '3', '1'),
('130105005', '130105', '东焦街道', '1', '130105005', null, '3', '1'),
('130105006', '130105', '西苑街道', '1', '130105006', null, '3', '1'),
('130105007', '130105', '合作路街道', '1', '130105007', null, '3', '1'),
('130105008', '130105', '联盟路街道', '1', '130105008', null, '3', '1'),
('130105009', '130105', '石岗大街街道', '1', '130105009', null, '3', '1'),
('130105010', '130105', '五七路街道', '1', '130105010', null, '3', '1'),
('130105011', '130105', '天苑街道', '1', '130105011', null, '3', '1'),
('130105012', '130105', '北苑街道', '1', '130105012', null, '3', '1'),
('130105100', '130105', '大郭镇', '1', '130105100', null, '3', '1'),
('130105101', '130105', '赵陵铺镇', '1', '130105101', null, '3', '1'),
('130105201', '130105', '西三庄乡', '1', '130105201', null, '3', '1'),
('130105202', '130105', '杜北乡', '1', '130105202', null, '3', '1'),
('130107001', '130107', '矿市街街道', '1', '130107001', null, '3', '1'),
('130107002', '130107', '四微街道', '1', '130107002', null, '3', '1'),
('130107100', '130107', '贾庄镇', '1', '130107100', null, '3', '1'),
('130107101', '130107', '凤山镇', '1', '130107101', null, '3', '1'),
('130107200', '130107', '横涧乡', '1', '130107200', null, '3', '1'),
('130108001', '130108', '裕兴街道', '1', '130108001', null, '3', '1'),
('130108002', '130108', '裕强街道', '1', '130108002', null, '3', '1'),
('130108003', '130108', '东苑街道', '1', '130108003', null, '3', '1'),
('130108004', '130108', '建通街道', '1', '130108004', null, '3', '1'),
('130108005', '130108', '槐底街道', '1', '130108005', null, '3', '1'),
('130108006', '130108', '裕华路街道', '1', '130108006', null, '3', '1'),
('130108007', '130108', '裕东街道', '1', '130108007', null, '3', '1'),
('130108010', '130108', '长江街道办事处(高新区)', '1', '130108010', null, '3', '1'),
('130108100', '130108', '宋营镇', '1', '130108100', null, '3', '1'),
('130108101', '130108', '方村镇', '1', '130108101', null, '3', '1'),
('130121100', '130121', '微水镇', '1', '130121100', null, '3', '1'),
('130121101', '130121', '上安镇', '1', '130121101', null, '3', '1'),
('130121102', '130121', '天长镇', '1', '130121102', null, '3', '1'),
('130121103', '130121', '秀林镇', '1', '130121103', null, '3', '1'),
('130121104', '130121', '南峪镇', '1', '130121104', null, '3', '1'),
('130121105', '130121', '威州镇', '1', '130121105', null, '3', '1'),
('130121106', '130121', '小作镇', '1', '130121106', null, '3', '1'),
('130121107', '130121', '南障城镇', '1', '130121107', null, '3', '1'),
('130121108', '130121', '苍岩山镇', '1', '130121108', null, '3', '1'),
('130121109', '130121', '测鱼镇', '1', '130121109', null, '3', '1'),
('130121200', '130121', '吴家窑乡', '1', '130121200', null, '3', '1'),
('130121201', '130121', '北正乡', '1', '130121201', null, '3', '1'),
('130121202', '130121', '于家乡', '1', '130121202', null, '3', '1'),
('130121203', '130121', '孙庄乡', '1', '130121203', null, '3', '1'),
('130121204', '130121', '南陉乡', '1', '130121204', null, '3', '1'),
('130121205', '130121', '辛庄乡', '1', '130121205', null, '3', '1'),
('130121206', '130121', '南王庄乡', '1', '130121206', null, '3', '1'),
('130123100', '130123', '正定镇', '1', '130123100', null, '3', '1'),
('130123101', '130123', '诸福屯镇', '1', '130123101', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('130123102', '130123', '新城铺镇', '1', '130123102', null, '3', '1'),
('130123103', '130123', '新安镇', '1', '130123103', null, '3', '1'),
('130123200', '130123', '南牛乡', '1', '130123200', null, '3', '1'),
('130123201', '130123', '南楼乡', '1', '130123201', null, '3', '1'),
('130123202', '130123', '西平乐乡', '1', '130123202', null, '3', '1'),
('130123203', '130123', '北早现乡', '1', '130123203', null, '3', '1'),
('130123204', '130123', '曲阳桥乡', '1', '130123204', null, '3', '1'),
('130124100', '130124', '栾城镇', '1', '130124100', null, '3', '1'),
('130124101', '130124', '郄马镇', '1', '130124101', null, '3', '1'),
('130124103', '130124', '冶河镇', '1', '130124103', null, '3', '1'),
('130124104', '130124', '窦妪镇', '1', '130124104', null, '3', '1'),
('130124105', '130124', '楼底镇', '1', '130124105', null, '3', '1'),
('130124200', '130124', '南高乡', '1', '130124200', null, '3', '1'),
('130124201', '130124', '柳林屯乡', '1', '130124201', null, '3', '1'),
('130124202', '130124', '西营乡', '1', '130124202', null, '3', '1'),
('130125100', '130125', '龙州镇', '1', '130125100', null, '3', '1'),
('130125101', '130125', '南桥镇', '1', '130125101', null, '3', '1'),
('130125102', '130125', '上碑镇', '1', '130125102', null, '3', '1'),
('130125103', '130125', '口头镇', '1', '130125103', null, '3', '1'),
('130125200', '130125', '独羊岗乡', '1', '130125200', null, '3', '1'),
('130125201', '130125', '安香乡', '1', '130125201', null, '3', '1'),
('130125202', '130125', '只里乡', '1', '130125202', null, '3', '1'),
('130125203', '130125', '市同乡', '1', '130125203', null, '3', '1'),
('130125204', '130125', '翟营乡', '1', '130125204', null, '3', '1'),
('130125205', '130125', '城寨乡', '1', '130125205', null, '3', '1'),
('130125206', '130125', '上方乡', '1', '130125206', null, '3', '1'),
('130125207', '130125', '玉亭乡', '1', '130125207', null, '3', '1'),
('130125208', '130125', '北河乡', '1', '130125208', null, '3', '1'),
('130125209', '130125', '上闫庄乡', '1', '130125209', null, '3', '1'),
('130125210', '130125', '九口子乡', '1', '130125210', null, '3', '1'),
('130126100', '130126', '灵寿镇', '1', '130126100', null, '3', '1'),
('130126101', '130126', '青同镇', '1', '130126101', null, '3', '1'),
('130126102', '130126', '塔上镇', '1', '130126102', null, '3', '1'),
('130126103', '130126', '陈庄镇', '1', '130126103', null, '3', '1'),
('130126104', '130126', '慈峪镇', '1', '130126104', null, '3', '1'),
('130126105', '130126', '岔头镇', '1', '130126105', null, '3', '1'),
('130126200', '130126', '三圣院乡', '1', '130126200', null, '3', '1'),
('130126201', '130126', '北洼乡', '1', '130126201', null, '3', '1'),
('130126202', '130126', '牛城乡', '1', '130126202', null, '3', '1'),
('130126203', '130126', '狗台乡', '1', '130126203', null, '3', '1'),
('130126204', '130126', '南寨乡', '1', '130126204', null, '3', '1'),
('130126205', '130126', '南燕川乡', '1', '130126205', null, '3', '1'),
('130126206', '130126', '北谭庄乡', '1', '130126206', null, '3', '1'),
('130126207', '130126', '寨头乡', '1', '130126207', null, '3', '1'),
('130126208', '130126', '南营乡', '1', '130126208', null, '3', '1'),
('130127100', '130127', '高邑镇', '1', '130127100', null, '3', '1'),
('130127200', '130127', '大营乡', '1', '130127200', null, '3', '1'),
('130127201', '130127', '中韩乡', '1', '130127201', null, '3', '1'),
('130127202', '130127', '万城乡', '1', '130127202', null, '3', '1'),
('130127203', '130127', '西富村乡', '1', '130127203', null, '3', '1'),
('130128100', '130128', '深泽镇', '1', '130128100', null, '3', '1'),
('130128101', '130128', '铁杆镇', '1', '130128101', null, '3', '1'),
('130128200', '130128', '白庄乡', '1', '130128200', null, '3', '1'),
('130128201', '130128', '留村乡', '1', '130128201', null, '3', '1'),
('130128202', '130128', '赵八乡', '1', '130128202', null, '3', '1'),
('130128203', '130128', '桥头乡', '1', '130128203', null, '3', '1'),
('130129100', '130129', '赞皇镇', '1', '130129100', null, '3', '1'),
('130129101', '130129', '院头镇', '1', '130129101', null, '3', '1'),
('130129200', '130129', '西龙门乡', '1', '130129200', null, '3', '1'),
('130129201', '130129', '南邢郭乡', '1', '130129201', null, '3', '1'),
('130129202', '130129', '南清河乡', '1', '130129202', null, '3', '1'),
('130129203', '130129', '西阳泽乡', '1', '130129203', null, '3', '1'),
('130129204', '130129', '土门乡', '1', '130129204', null, '3', '1'),
('130129205', '130129', '黄北坪乡', '1', '130129205', null, '3', '1'),
('130129206', '130129', '嶂石岩乡', '1', '130129206', null, '3', '1'),
('130129207', '130129', '许亭乡', '1', '130129207', null, '3', '1'),
('130129208', '130129', '张楞乡', '1', '130129208', null, '3', '1'),
('130130100', '130130', '无极镇', '1', '130130100', null, '3', '1'),
('130130101', '130130', '七汲镇', '1', '130130101', null, '3', '1'),
('130130102', '130130', '张段固镇', '1', '130130102', null, '3', '1'),
('130130103', '130130', '北苏镇', '1', '130130103', null, '3', '1'),
('130130104', '130130', '郭庄镇', '1', '130130104', null, '3', '1'),
('130130105', '130130', '大陈镇', '1', '130130105', null, '3', '1'),
('130130200', '130130', '高头乡', '1', '130130200', null, '3', '1'),
('130130201', '130130', '郝庄乡', '1', '130130201', null, '3', '1'),
('130130202', '130130', '东侯坊乡', '1', '130130202', null, '3', '1'),
('130130203', '130130', '里城道乡', '1', '130130203', null, '3', '1'),
('130130204', '130130', '南流乡', '1', '130130204', null, '3', '1'),
('130131100', '130131', '平山镇', '1', '130131100', null, '3', '1'),
('130131101', '130131', '东回舍镇', '1', '130131101', null, '3', '1'),
('130131102', '130131', '温塘镇', '1', '130131102', null, '3', '1'),
('130131103', '130131', '南甸镇', '1', '130131103', null, '3', '1'),
('130131104', '130131', '岗南镇', '1', '130131104', null, '3', '1'),
('130131105', '130131', '中古月镇', '1', '130131105', null, '3', '1'),
('130131106', '130131', '下槐镇', '1', '130131106', null, '3', '1'),
('130131107', '130131', '孟家庄镇', '1', '130131107', null, '3', '1'),
('130131108', '130131', '小觉镇', '1', '130131108', null, '3', '1'),
('130131109', '130131', '蛟潭庄镇', '1', '130131109', null, '3', '1'),
('130131110', '130131', '西柏坡镇', '1', '130131110', null, '3', '1'),
('130131111', '130131', '下口镇', '1', '130131111', null, '3', '1'),
('130131200', '130131', '西大吾乡', '1', '130131200', null, '3', '1'),
('130131201', '130131', '上三汲乡', '1', '130131201', null, '3', '1'),
('130131202', '130131', '两河乡', '1', '130131202', null, '3', '1'),
('130131203', '130131', '东王坡乡', '1', '130131203', null, '3', '1'),
('130131204', '130131', '苏家庄乡', '1', '130131204', null, '3', '1'),
('130131205', '130131', '宅北乡', '1', '130131205', null, '3', '1'),
('130131207', '130131', '北冶乡', '1', '130131207', null, '3', '1'),
('130131209', '130131', '上观音堂乡', '1', '130131209', null, '3', '1'),
('130131210', '130131', '杨家桥乡', '1', '130131210', null, '3', '1'),
('130131211', '130131', '营里乡', '1', '130131211', null, '3', '1'),
('130131212', '130131', '合河口乡', '1', '130131212', null, '3', '1'),
('130132100', '130132', '槐阳镇', '1', '130132100', null, '3', '1'),
('130132101', '130132', '因村镇', '1', '130132101', null, '3', '1'),
('130132102', '130132', '南佐镇', '1', '130132102', null, '3', '1'),
('130132103', '130132', '宋曹镇', '1', '130132103', null, '3', '1'),
('130132104', '130132', '南因镇', '1', '130132104', null, '3', '1'),
('130132105', '130132', '姬村镇', '1', '130132105', null, '3', '1'),
('130132200', '130132', '马村乡', '1', '130132200', null, '3', '1'),
('130132201', '130132', '东张乡', '1', '130132201', null, '3', '1'),
('130132202', '130132', '赵同乡', '1', '130132202', null, '3', '1'),
('130132203', '130132', '北褚乡', '1', '130132203', null, '3', '1'),
('130132204', '130132', '苏村乡', '1', '130132204', null, '3', '1'),
('130132205', '130132', '苏阳乡', '1', '130132205', null, '3', '1'),
('130132206', '130132', '北正乡', '1', '130132206', null, '3', '1'),
('130132207', '130132', '前仙乡', '1', '130132207', null, '3', '1'),
('130132208', '130132', '黑水河乡', '1', '130132208', null, '3', '1'),
('130133100', '130133', '赵州镇', '1', '130133100', null, '3', '1'),
('130133101', '130133', '范庄镇', '1', '130133101', null, '3', '1'),
('130133102', '130133', '北王里镇', '1', '130133102', null, '3', '1'),
('130133103', '130133', '新寨店镇', '1', '130133103', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('130133104', '130133', '韩村镇', '1', '130133104', null, '3', '1'),
('130133105', '130133', '南柏舍镇', '1', '130133105', null, '3', '1'),
('130133106', '130133', '沙河店镇', '1', '130133106', null, '3', '1'),
('130133200', '130133', '前大章乡', '1', '130133200', null, '3', '1'),
('130133201', '130133', '谢庄乡', '1', '130133201', null, '3', '1'),
('130133202', '130133', '高村乡', '1', '130133202', null, '3', '1'),
('130133203', '130133', '王西章乡', '1', '130133203', null, '3', '1'),
('130181100', '130181', '辛集镇', '1', '130181100', null, '3', '1'),
('130181101', '130181', '旧城镇', '1', '130181101', null, '3', '1'),
('130181102', '130181', '张古庄镇', '1', '130181102', null, '3', '1'),
('130181103', '130181', '位伯镇', '1', '130181103', null, '3', '1'),
('130181104', '130181', '新垒头镇', '1', '130181104', null, '3', '1'),
('130181105', '130181', '新城镇', '1', '130181105', null, '3', '1'),
('130181106', '130181', '南智丘镇', '1', '130181106', null, '3', '1'),
('130181107', '130181', '王口镇', '1', '130181107', null, '3', '1'),
('130181200', '130181', '天宫营乡', '1', '130181200', null, '3', '1'),
('130181201', '130181', '前营乡', '1', '130181201', null, '3', '1'),
('130181202', '130181', '马庄乡', '1', '130181202', null, '3', '1'),
('130181203', '130181', '和睦井乡', '1', '130181203', null, '3', '1'),
('130181204', '130181', '田家庄乡', '1', '130181204', null, '3', '1'),
('130181205', '130181', '中里厢乡', '1', '130181205', null, '3', '1'),
('130181206', '130181', '小辛庄乡', '1', '130181206', null, '3', '1'),
('130182100', '130182', '廉州镇', '1', '130182100', null, '3', '1'),
('130182101', '130182', '兴安镇', '1', '130182101', null, '3', '1'),
('130182102', '130182', '贾市庄镇', '1', '130182102', null, '3', '1'),
('130182103', '130182', '南营镇', '1', '130182103', null, '3', '1'),
('130182104', '130182', '梅花镇', '1', '130182104', null, '3', '1'),
('130182105', '130182', '岗上镇', '1', '130182105', null, '3', '1'),
('130182106', '130182', '邱头镇', '1', '130182106', null, '3', '1'),
('130182107', '130182', '南董镇', '1', '130182107', null, '3', '1'),
('130182108', '130182', '张家庄镇', '1', '130182108', null, '3', '1'),
('130182109', '130182', '南孟镇', '1', '130182109', null, '3', '1'),
('130182110', '130182', '增村镇', '1', '130182110', null, '3', '1'),
('130182111', '130182', '小常安镇', '1', '130182111', null, '3', '1'),
('130182112', '130182', '前西关镇', '1', '130182112', null, '3', '1'),
('130182200', '130182', '九门回族乡', '1', '130182200', null, '3', '1'),
('130182500', '130182', '石家庄经济技术开发区虚拟乡', '1', '130182500', null, '3', '1'),
('130183100', '130183', '晋州镇', '1', '130183100', null, '3', '1'),
('130183101', '130183', '总十庄镇', '1', '130183101', null, '3', '1'),
('130183102', '130183', '营里镇', '1', '130183102', null, '3', '1'),
('130183103', '130183', '桃园镇', '1', '130183103', null, '3', '1'),
('130183104', '130183', '东卓宿镇', '1', '130183104', null, '3', '1'),
('130183105', '130183', '马于镇', '1', '130183105', null, '3', '1'),
('130183106', '130183', '小樵镇', '1', '130183106', null, '3', '1'),
('130183107', '130183', '槐树镇', '1', '130183107', null, '3', '1'),
('130183200', '130183', '东里庄乡', '1', '130183200', null, '3', '1'),
('130183201', '130183', '周家庄乡', '1', '130183201', null, '3', '1'),
('130184001', '130184', '长寿街道', '1', '130184001', null, '3', '1'),
('130184101', '130184', '化皮镇', '1', '130184101', null, '3', '1'),
('130184102', '130184', '承安镇', '1', '130184102', null, '3', '1'),
('130184103', '130184', '正莫镇', '1', '130184103', null, '3', '1'),
('130184104', '130184', '南大岳镇', '1', '130184104', null, '3', '1'),
('130184105', '130184', '杜固镇', '1', '130184105', null, '3', '1'),
('130184106', '130184', '邯邰镇', '1', '130184106', null, '3', '1'),
('130184107', '130184', '东王镇', '1', '130184107', null, '3', '1'),
('130184108', '130184', '马头铺镇', '1', '130184108', null, '3', '1'),
('130184200', '130184', '协神乡', '1', '130184200', null, '3', '1'),
('130184201', '130184', '木村乡', '1', '130184201', null, '3', '1'),
('130184202', '130184', '彭家庄乡', '1', '130184202', null, '3', '1'),
('130185100', '130185', '获鹿镇', '1', '130185100', null, '3', '1'),
('130185101', '130185', '铜冶镇', '1', '130185101', null, '3', '1'),
('130185102', '130185', '寺家庄镇', '1', '130185102', null, '3', '1'),
('130185103', '130185', '上庄镇', '1', '130185103', null, '3', '1'),
('130185104', '130185', '李村镇', '1', '130185104', null, '3', '1'),
('130185105', '130185', '宜安镇', '1', '130185105', null, '3', '1'),
('130185106', '130185', '黄壁庄镇', '1', '130185106', null, '3', '1'),
('130185107', '130185', '大河镇', '1', '130185107', null, '3', '1'),
('130185200', '130185', '石井乡', '1', '130185200', null, '3', '1'),
('130185201', '130185', '白鹿泉乡', '1', '130185201', null, '3', '1'),
('130185202', '130185', '上寨乡', '1', '130185202', null, '3', '1'),
('130185203', '130185', '山尹村乡', '1', '130185203', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('130185500', '130185', '高新技术产业园区虚拟乡', '1', '130185500', null, '3', '1'),
('130202001', '130202', '学院南路', '1', '130202001', null, '3', '1'),
('130202002', '130202', '友谊', '1', '130202002', null, '3', '1'),
('130202003', '130202', '广场', '1', '130202003', null, '3', '1'),
('130202004', '130202', '永红桥街道', '1', '130202004', null, '3', '1'),
('130202005', '130202', '小山街道', '1', '130202005', null, '3', '1'),
('130202006', '130202', '文北', '1', '130202006', null, '3', '1'),
('130202007', '130202', '钱营', '1', '130202007', null, '3', '1'),
('130202100', '130202', '芦台开发区海北镇', '1', '130202100', null, '3', '1'),
('130202101', '130202', '汉沽管理区汉丰镇', '1', '130202101', null, '3', '1'),
('130202200', '130202', '女织寨乡', '1', '130202200', null, '3', '1'),
('130202450', '130202', '芦台开发区街道', '1', '130202450', null, '3', '1'),
('130202451', '130202', '汉沽管理区兴农', '1', '130202451', null, '3', '1'),
('130202452', '130202', '汉沽管理区振兴街道', '1', '130202452', null, '3', '1'),
('130203001', '130203', '乔屯街道', '1', '130203001', null, '3', '1'),
('130203002', '130203', '文化路街道', '1', '130203002', null, '3', '1'),
('130203003', '130203', '钓鱼台街道', '1', '130203003', null, '3', '1'),
('130203004', '130203', '东新村街道', '1', '130203004', null, '3', '1'),
('130203005', '130203', '缸窑街道', '1', '130203005', null, '3', '1'),
('130203006', '130203', '机场路街道', '1', '130203006', null, '3', '1'),
('130203007', '130203', '河北路街道', '1', '130203007', null, '3', '1'),
('130203008', '130203', '龙东街道', '1', '130203008', null, '3', '1'),
('130203009', '130203', '大里街道', '1', '130203009', null, '3', '1'),
('130203010', '130203', '光明街道', '1', '130203010', null, '3', '1'),
('130203200', '130203', '果园乡', '1', '130203200', null, '3', '1'),
('130203450', '130203', '河北唐山高新技术产业园区', '1', '130203450', null, '3', '1'),
('130204001', '130204', '林西街道', '1', '130204001', null, '3', '1'),
('130204002', '130204', '唐家庄街道', '1', '130204002', null, '3', '1'),
('130204003', '130204', '古冶街道', '1', '130204003', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('130204004', '130204', '赵各庄街道', '1', '130204004', null, '3', '1'),
('130204005', '130204', '吕家坨街道', '1', '130204005', null, '3', '1'),
('130204006', '130204', '南范各庄街道', '1', '130204006', null, '3', '1'),
('130204200', '130204', '卑家店乡', '1', '130204200', null, '3', '1'),
('130204201', '130204', '王辇庄乡', '1', '130204201', null, '3', '1'),
('130204202', '130204', '习家套乡', '1', '130204202', null, '3', '1'),
('130204203', '130204', '大庄坨乡', '1', '130204203', null, '3', '1'),
('130204204', '130204', '范各庄乡', '1', '130204204', null, '3', '1'),
('130205001', '130205', '马家沟', '1', '130205001', null, '3', '1'),
('130205002', '130205', '开平', '1', '130205002', null, '3', '1'),
('130205003', '130205', '税务庄', '1', '130205003', null, '3', '1'),
('130205005', '130205', '陡电', '1', '130205005', null, '3', '1'),
('130205006', '130205', '荆各庄', '1', '130205006', null, '3', '1'),
('130205100', '130205', '开平镇', '1', '130205100', null, '3', '1'),
('130205101', '130205', '栗园镇', '1', '130205101', null, '3', '1'),
('130205200', '130205', '越河乡', '1', '130205200', null, '3', '1'),
('130205201', '130205', '双桥乡', '1', '130205201', null, '3', '1'),
('130205202', '130205', '郑庄子乡', '1', '130205202', null, '3', '1'),
('130205203', '130205', '洼里乡', '1', '130205203', null, '3', '1'),
('130207102', '130207', '稻地镇', '1', '130207102', null, '3', '1'),
('130207103', '130207', '小集镇', '1', '130207103', null, '3', '1'),
('130207104', '130207', '黄各庄镇', '1', '130207104', null, '3', '1'),
('130207105', '130207', '西葛镇', '1', '130207105', null, '3', '1'),
('130207106', '130207', '大新庄镇', '1', '130207106', null, '3', '1'),
('130207107', '130207', '钱营镇', '1', '130207107', null, '3', '1'),
('130207108', '130207', '唐坊镇', '1', '130207108', null, '3', '1'),
('130207109', '130207', '王兰庄镇', '1', '130207109', null, '3', '1'),
('130207110', '130207', '柳树酄镇', '1', '130207110', null, '3', '1'),
('130207111', '130207', '黑沿子镇', '1', '130207111', null, '3', '1'),
('130207112', '130207', '滨海镇', '1', '130207112', null, '3', '1'),
('130207113', '130207', '丰南镇', '1', '130207113', null, '3', '1'),
('130207114', '130207', '大齐镇', '1', '130207114', null, '3', '1'),
('130207201', '130207', '南孙庄乡', '1', '130207201', null, '3', '1'),
('130207202', '130207', '东田庄乡', '1', '130207202', null, '3', '1'),
('130207203', '130207', '尖字沽乡', '1', '130207203', null, '3', '1'),
('130207450', '130207', '河北唐山南堡经济开发区', '1', '130207450', null, '3', '1'),
('130208001', '130208', '太平路', '1', '130208001', null, '3', '1'),
('130208002', '130208', '燕山路', '1', '130208002', null, '3', '1'),
('130208003', '130208', '浭阳', '1', '130208003', null, '3', '1'),
('130208100', '130208', '丰润镇', '1', '130208100', null, '3', '1'),
('130208101', '130208', '老庄子镇', '1', '130208101', null, '3', '1'),
('130208102', '130208', '任各庄镇', '1', '130208102', null, '3', '1'),
('130208103', '130208', '左家坞镇', '1', '130208103', null, '3', '1'),
('130208104', '130208', '泉河头镇', '1', '130208104', null, '3', '1'),
('130208105', '130208', '王官营镇', '1', '130208105', null, '3', '1'),
('130208106', '130208', '火石营镇', '1', '130208106', null, '3', '1'),
('130208107', '130208', '韩城镇', '1', '130208107', null, '3', '1'),
('130208108', '130208', '岔河镇', '1', '130208108', null, '3', '1'),
('130208109', '130208', '新军屯镇', '1', '130208109', null, '3', '1'),
('130208110', '130208', '小张各庄镇', '1', '130208110', null, '3', '1'),
('130208111', '130208', '丰登坞镇', '1', '130208111', null, '3', '1'),
('130208112', '130208', '李钊庄镇', '1', '130208112', null, '3', '1'),
('130208113', '130208', '白官屯镇', '1', '130208113', null, '3', '1'),
('130208114', '130208', '石各庄镇', '1', '130208114', null, '3', '1'),
('130208115', '130208', '沙流河镇', '1', '130208115', null, '3', '1'),
('130208116', '130208', '七树庄镇', '1', '130208116', null, '3', '1'),
('130208117', '130208', '杨官林镇', '1', '130208117', null, '3', '1'),
('130208202', '130208', '姜家营乡', '1', '130208202', null, '3', '1'),
('130208205', '130208', '欢喜庄乡', '1', '130208205', null, '3', '1'),
('130208207', '130208', '银城铺乡', '1', '130208207', null, '3', '1'),
('130208208', '130208', '刘家营乡', '1', '130208208', null, '3', '1'),
('130208209', '130208', '常庄乡', '1', '130208209', null, '3', '1'),
('130223001', '130223', '城区街道', '1', '130223001', null, '3', '1'),
('130223100', '130223', '滦州镇', '1', '130223100', null, '3', '1'),
('130223101', '130223', '响堂镇', '1', '130223101', null, '3', '1'),
('130223102', '130223', '东安各庄镇', '1', '130223102', null, '3', '1'),
('130223103', '130223', '雷庄镇', '1', '130223103', null, '3', '1'),
('130223104', '130223', '茨榆坨镇', '1', '130223104', null, '3', '1'),
('130223105', '130223', '榛子镇', '1', '130223105', null, '3', '1'),
('130223106', '130223', '杨柳庄镇', '1', '130223106', null, '3', '1'),
('130223107', '130223', '油榨镇', '1', '130223107', null, '3', '1'),
('130223108', '130223', '古马镇', '1', '130223108', null, '3', '1'),
('130223109', '130223', '小马庄镇', '1', '130223109', null, '3', '1'),
('130223110', '130223', '九百户镇', '1', '130223110', null, '3', '1'),
('130223111', '130223', '王店子镇', '1', '130223111', null, '3', '1'),
('130224001', '130224', '奔城街道', '1', '130224001', null, '3', '1'),
('130224100', '130224', '奔城镇', '1', '130224100', null, '3', '1'),
('130224101', '130224', '宋道口镇', '1', '130224101', null, '3', '1'),
('130224102', '130224', '长凝镇', '1', '130224102', null, '3', '1'),
('130224103', '130224', '胡各庄镇', '1', '130224103', null, '3', '1'),
('130224104', '130224', '坨里镇', '1', '130224104', null, '3', '1'),
('130224105', '130224', '姚王庄镇', '1', '130224105', null, '3', '1'),
('130224106', '130224', '司各庄镇', '1', '130224106', null, '3', '1'),
('130224107', '130224', '安各庄镇', '1', '130224107', null, '3', '1'),
('130224108', '130224', '扒齿港镇', '1', '130224108', null, '3', '1'),
('130224109', '130224', '程庄镇', '1', '130224109', null, '3', '1'),
('130224110', '130224', '青坨营镇', '1', '130224110', null, '3', '1'),
('130224111', '130224', '柏各庄镇', '1', '130224111', null, '3', '1'),
('130224113', '130224', '柳赞镇', '1', '130224113', null, '3', '1'),
('130224114', '130224', '南堡镇', '1', '130224114', null, '3', '1'),
('130224115', '130224', '方各庄镇', '1', '130224115', null, '3', '1'),
('130224116', '130224', '东黄坨镇', '1', '130224116', null, '3', '1'),
('130224117', '130224', '马城镇', '1', '130224117', null, '3', '1'),
('130225001', '130225', '城区街道', '1', '130225001', null, '3', '1'),
('130225100', '130225', '乐亭镇', '1', '130225100', null, '3', '1'),
('130225101', '130225', '汤家河镇', '1', '130225101', null, '3', '1'),
('130225102', '130225', '胡家坨镇', '1', '130225102', null, '3', '1'),
('130225103', '130225', '王滩镇', '1', '130225103', null, '3', '1'),
('130225104', '130225', '闫各庄镇', '1', '130225104', null, '3', '1'),
('130225105', '130225', '马头营镇', '1', '130225105', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('130225106', '130225', '新寨镇', '1', '130225106', null, '3', '1'),
('130225107', '130225', '汀流河镇', '1', '130225107', null, '3', '1'),
('130225108', '130225', '姜各庄镇', '1', '130225108', null, '3', '1'),
('130225200', '130225', '毛庄乡', '1', '130225200', null, '3', '1'),
('130225201', '130225', '庞各庄乡', '1', '130225201', null, '3', '1'),
('130225202', '130225', '大相各庄乡', '1', '130225202', null, '3', '1'),
('130225203', '130225', '古河乡', '1', '130225203', null, '3', '1'),
('130225204', '130225', '中堡王庄乡', '1', '130225204', null, '3', '1'),
('130225450', '130225', '长芦大清河盐场', '1', '130225450', null, '3', '1'),
('130225451', '130225', '海港区', '1', '130225451', null, '3', '1'),
('130227001', '130227', '栗乡街道', '1', '130227001', null, '3', '1'),
('130227100', '130227', '兴城镇', '1', '130227100', null, '3', '1'),
('130227101', '130227', '金厂峪镇', '1', '130227101', null, '3', '1'),
('130227102', '130227', '洒河桥镇', '1', '130227102', null, '3', '1'),
('130227103', '130227', '太平寨镇', '1', '130227103', null, '3', '1'),
('130227104', '130227', '罗家屯镇', '1', '130227104', null, '3', '1'),
('130227105', '130227', '东荒峪镇', '1', '130227105', null, '3', '1'),
('130227106', '130227', '新集镇', '1', '130227106', null, '3', '1'),
('130227107', '130227', '三屯营镇', '1', '130227107', null, '3', '1'),
('130227108', '130227', '滦阳镇', '1', '130227108', null, '3', '1'),
('130227200', '130227', '白庙子乡', '1', '130227200', null, '3', '1'),
('130227201', '130227', '上营乡', '1', '130227201', null, '3', '1'),
('130227202', '130227', '汉儿庄乡', '1', '130227202', null, '3', '1'),
('130227203', '130227', '渔户寨乡', '1', '130227203', null, '3', '1'),
('130227204', '130227', '旧城乡', '1', '130227204', null, '3', '1'),
('130227205', '130227', '尹庄乡', '1', '130227205', null, '3', '1'),
('130227206', '130227', '东莲花院乡', '1', '130227206', null, '3', '1'),
('130227207', '130227', '新庄子乡', '1', '130227207', null, '3', '1'),
('130229100', '130229', '玉田镇', '1', '130229100', null, '3', '1'),
('130229101', '130229', '亮甲店镇', '1', '130229101', null, '3', '1'),
('130229102', '130229', '鸦鸿桥镇', '1', '130229102', null, '3', '1'),
('130229103', '130229', '窝洛沽镇', '1', '130229103', null, '3', '1'),
('130229104', '130229', '石臼窝镇', '1', '130229104', null, '3', '1'),
('130229105', '130229', '虹桥镇', '1', '130229105', null, '3', '1'),
('130229106', '130229', '散水头镇', '1', '130229106', null, '3', '1'),
('130229107', '130229', '林南仓镇', '1', '130229107', null, '3', '1'),
('130229108', '130229', '林西镇', '1', '130229108', null, '3', '1'),
('130229109', '130229', '杨家板桥镇', '1', '130229109', null, '3', '1'),
('130229110', '130229', '彩亭桥镇', '1', '130229110', null, '3', '1'),
('130229111', '130229', '孤树镇', '1', '130229111', null, '3', '1'),
('130229112', '130229', '大安镇', '1', '130229112', null, '3', '1'),
('130229113', '130229', '唐自头镇', '1', '130229113', null, '3', '1'),
('130229200', '130229', '郭家屯乡', '1', '130229200', null, '3', '1'),
('130229201', '130229', '林头屯乡', '1', '130229201', null, '3', '1'),
('130229202', '130229', '杨家套乡', '1', '130229202', null, '3', '1'),
('130229203', '130229', '潮洛窝乡', '1', '130229203', null, '3', '1'),
('130229204', '130229', '陈家铺乡', '1', '130229204', null, '3', '1'),
('130229205', '130229', '郭家桥乡', '1', '130229205', null, '3', '1'),
('130230100', '130230', '唐海镇', '1', '130230100', null, '3', '1'),
('130230401', '130230', '一农场', '1', '130230401', null, '3', '1'),
('130230403', '130230', '三农场', '1', '130230403', null, '3', '1'),
('130230404', '130230', '四农场', '1', '130230404', null, '3', '1'),
('130230405', '130230', '五农场', '1', '130230405', null, '3', '1'),
('130230406', '130230', '六农场', '1', '130230406', null, '3', '1'),
('130230407', '130230', '七农场', '1', '130230407', null, '3', '1'),
('130230408', '130230', '八农场', '1', '130230408', null, '3', '1'),
('130230409', '130230', '九农场', '1', '130230409', null, '3', '1'),
('130230410', '130230', '十农场', '1', '130230410', null, '3', '1'),
('130230411', '130230', '十一农场', '1', '130230411', null, '3', '1'),
('130230412', '130230', '八里滩养殖场', '1', '130230412', null, '3', '1'),
('130230413', '130230', '十里海养殖场', '1', '130230413', null, '3', '1'),
('130230451', '130230', '曹妃甸工业区', '1', '130230451', null, '3', '1'),
('130281001', '130281', '路南街道', '1', '130281001', null, '3', '1'),
('130281002', '130281', '路北街道', '1', '130281002', null, '3', '1'),
('130281100', '130281', '遵化镇', '1', '130281100', null, '3', '1'),
('130281101', '130281', '堡子店镇', '1', '130281101', null, '3', '1'),
('130281102', '130281', '马兰峪镇', '1', '130281102', null, '3', '1'),
('130281103', '130281', '平安城镇', '1', '130281103', null, '3', '1'),
('130281104', '130281', '东新庄镇', '1', '130281104', null, '3', '1'),
('130281105', '130281', '新店子镇', '1', '130281105', null, '3', '1'),
('130281106', '130281', '党峪镇', '1', '130281106', null, '3', '1'),
('130281107', '130281', '地北头镇', '1', '130281107', null, '3', '1'),
('130281108', '130281', '东旧寨镇', '1', '130281108', null, '3', '1'),
('130281109', '130281', '铁厂镇', '1', '130281109', null, '3', '1'),
('130281110', '130281', '苏家洼镇', '1', '130281110', null, '3', '1'),
('130281111', '130281', '建明镇', '1', '130281111', null, '3', '1'),
('130281112', '130281', '石门镇', '1', '130281112', null, '3', '1'),
('130281200', '130281', '西留村乡', '1', '130281200', null, '3', '1'),
('130281201', '130281', '崔家庄乡', '1', '130281201', null, '3', '1'),
('130281202', '130281', '兴旺寨乡', '1', '130281202', null, '3', '1'),
('130281203', '130281', '西下营满族乡', '1', '130281203', null, '3', '1'),
('130281204', '130281', '汤泉满族乡', '1', '130281204', null, '3', '1'),
('130281205', '130281', '东陵满族乡', '1', '130281205', null, '3', '1'),
('130281206', '130281', '刘备寨乡', '1', '130281206', null, '3', '1'),
('130281207', '130281', '团瓢庄乡', '1', '130281207', null, '3', '1'),
('130281208', '130281', '娘娘庄乡', '1', '130281208', null, '3', '1'),
('130281209', '130281', '西三里乡', '1', '130281209', null, '3', '1'),
('130281210', '130281', '候家寨乡', '1', '130281210', null, '3', '1'),
('130281211', '130281', '小厂乡', '1', '130281211', null, '3', '1'),
('130283100', '130283', '迁安镇', '1', '130283100', null, '3', '1'),
('130283101', '130283', '夏官营镇', '1', '130283101', null, '3', '1'),
('130283102', '130283', '杨各庄镇', '1', '130283102', null, '3', '1'),
('130283103', '130283', '建昌营镇', '1', '130283103', null, '3', '1'),
('130283104', '130283', '赵店子镇', '1', '130283104', null, '3', '1'),
('130283105', '130283', '野鸡坨镇', '1', '130283105', null, '3', '1'),
('130283106', '130283', '大崔庄镇', '1', '130283106', null, '3', '1'),
('130283107', '130283', '杨店子镇', '1', '130283107', null, '3', '1'),
('130283108', '130283', '蔡园镇', '1', '130283108', null, '3', '1'),
('130283109', '130283', '马兰庄镇', '1', '130283109', null, '3', '1'),
('130283110', '130283', '沙河驿镇', '1', '130283110', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('130283111', '130283', '木厂口镇', '1', '130283111', null, '3', '1'),
('130283200', '130283', '扣庄乡', '1', '130283200', null, '3', '1'),
('130283201', '130283', '彭店子乡', '1', '130283201', null, '3', '1'),
('130283202', '130283', '上射雁庄乡', '1', '130283202', null, '3', '1'),
('130283203', '130283', '闫家店乡', '1', '130283203', null, '3', '1'),
('130283204', '130283', '五重安乡', '1', '130283204', null, '3', '1'),
('130283205', '130283', '大五里乡', '1', '130283205', null, '3', '1'),
('130283206', '130283', '太平庄乡', '1', '130283206', null, '3', '1'),
('130302001', '130302', '文化路街道', '1', '130302001', null, '3', '1'),
('130302002', '130302', '海滨路街道', '1', '130302002', null, '3', '1'),
('130302003', '130302', '北环路街道', '1', '130302003', null, '3', '1'),
('130302004', '130302', '建设大街街道', '1', '130302004', null, '3', '1'),
('130302005', '130302', '河东街道', '1', '130302005', null, '3', '1'),
('130302006', '130302', '西港路街道', '1', '130302006', null, '3', '1'),
('130302007', '130302', '燕山大街街道', '1', '130302007', null, '3', '1'),
('130302008', '130302', '港城大街街道', '1', '130302008', null, '3', '1'),
('130302009', '130302', '东环路街道', '1', '130302009', null, '3', '1'),
('130302010', '130302', '白塔岭街道', '1', '130302010', null, '3', '1'),
('130302011', '130302', '秦皇岛经济技术开发区珠江道街道', '1', '130302011', null, '3', '1'),
('130302100', '130302', '东港镇', '1', '130302100', null, '3', '1'),
('130302101', '130302', '海港镇', '1', '130302101', null, '3', '1'),
('130302102', '130302', '西港镇', '1', '130302102', null, '3', '1'),
('130302103', '130302', '海阳镇', '1', '130302103', null, '3', '1'),
('130302104', '130302', '北港镇', '1', '130302104', null, '3', '1'),
('130302450', '130302', '秦皇岛经济技术开发区', '1', '130302450', null, '3', '1'),
('130303001', '130303', '南关街道', '1', '130303001', null, '3', '1'),
('130303002', '130303', '东街街道', '1', '130303002', null, '3', '1'),
('130303003', '130303', '西街街道', '1', '130303003', null, '3', '1'),
('130303004', '130303', '路南街道', '1', '130303004', null, '3', '1'),
('130303005', '130303', '船厂路街道', '1', '130303005', null, '3', '1'),
('130303100', '130303', '第一关镇', '1', '130303100', null, '3', '1'),
('130303101', '130303', '石河镇', '1', '130303101', null, '3', '1'),
('130303102', '130303', '孟姜镇', '1', '130303102', null, '3', '1'),
('130303200', '130303', '渤海乡', '1', '130303200', null, '3', '1'),
('130304001', '130304', '西山街道', '1', '130304001', null, '3', '1'),
('130304002', '130304', '东山街道', '1', '130304002', null, '3', '1'),
('130304100', '130304', '海滨镇', '1', '130304100', null, '3', '1'),
('130304101', '130304', '戴河镇', '1', '130304101', null, '3', '1'),
('130321100', '130321', '青龙镇', '1', '130321100', null, '3', '1'),
('130321101', '130321', '祖山镇', '1', '130321101', null, '3', '1'),
('130321102', '130321', '木头凳镇', '1', '130321102', null, '3', '1'),
('130321103', '130321', '双山子镇', '1', '130321103', null, '3', '1'),
('130321104', '130321', '马圈子镇', '1', '130321104', null, '3', '1'),
('130321105', '130321', '肖营子镇', '1', '130321105', null, '3', '1'),
('130321200', '130321', '凤凰山乡', '1', '130321200', null, '3', '1'),
('130321201', '130321', '龙王庙乡', '1', '130321201', null, '3', '1'),
('130321202', '130321', '三星口乡', '1', '130321202', null, '3', '1'),
('130321203', '130321', '干沟乡', '1', '130321203', null, '3', '1'),
('130321204', '130321', '大巫岚乡', '1', '130321204', null, '3', '1'),
('130321205', '130321', '土门子乡', '1', '130321205', null, '3', '1'),
('130321206', '130321', '大石岭乡', '1', '130321206', null, '3', '1'),
('130321207', '130321', '隔河头乡', '1', '130321207', null, '3', '1'),
('130321208', '130321', '官场乡', '1', '130321208', null, '3', '1'),
('130321209', '130321', '茨榆山乡', '1', '130321209', null, '3', '1'),
('130321210', '130321', '平方子乡', '1', '130321210', null, '3', '1'),
('130321211', '130321', '安子岭乡', '1', '130321211', null, '3', '1'),
('130321212', '130321', '朱杖子乡', '1', '130321212', null, '3', '1'),
('130321213', '130321', '草碾乡', '1', '130321213', null, '3', '1'),
('130321214', '130321', '七道河乡', '1', '130321214', null, '3', '1'),
('130321215', '130321', '八道河乡', '1', '130321215', null, '3', '1'),
('130321216', '130321', '娄杖子乡', '1', '130321216', null, '3', '1'),
('130321217', '130321', '三拨子乡', '1', '130321217', null, '3', '1'),
('130321218', '130321', '凉水河乡', '1', '130321218', null, '3', '1'),
('130322100', '130322', '昌黎镇', '1', '130322100', null, '3', '1'),
('130322101', '130322', '靖安镇', '1', '130322101', null, '3', '1'),
('130322102', '130322', '安山镇', '1', '130322102', null, '3', '1'),
('130322103', '130322', '龙家店镇', '1', '130322103', null, '3', '1'),
('130322104', '130322', '泥井镇', '1', '130322104', null, '3', '1'),
('130322105', '130322', '大蒲河镇', '1', '130322105', null, '3', '1'),
('130322106', '130322', '新集镇', '1', '130322106', null, '3', '1'),
('130322107', '130322', '刘台庄镇', '1', '130322107', null, '3', '1'),
('130322108', '130322', '茹荷镇', '1', '130322108', null, '3', '1'),
('130322109', '130322', '朱各庄镇', '1', '130322109', null, '3', '1'),
('130322201', '130322', '团林乡', '1', '130322201', null, '3', '1'),
('130322202', '130322', '葛条港乡', '1', '130322202', null, '3', '1'),
('130322203', '130322', '马坨店乡', '1', '130322203', null, '3', '1'),
('130322204', '130322', '荒佃庄乡', '1', '130322204', null, '3', '1'),
('130322206', '130322', '两山乡', '1', '130322206', null, '3', '1'),
('130322207', '130322', '十里铺乡', '1', '130322207', null, '3', '1'),
('130323100', '130323', '抚宁镇', '1', '130323100', null, '3', '1'),
('130323101', '130323', '留守营镇', '1', '130323101', null, '3', '1'),
('130323102', '130323', '榆关镇', '1', '130323102', null, '3', '1'),
('130323103', '130323', '牛头崖镇', '1', '130323103', null, '3', '1'),
('130323104', '130323', '石门寨镇', '1', '130323104', null, '3', '1'),
('130323105', '130323', '台营镇', '1', '130323105', null, '3', '1'),
('130323106', '130323', '大新寨镇', '1', '130323106', null, '3', '1'),
('130323107', '130323', '驻操营镇', '1', '130323107', null, '3', '1'),
('130323200', '130323', '茶棚乡', '1', '130323200', null, '3', '1'),
('130323201', '130323', '杜庄乡', '1', '130323201', null, '3', '1'),
('130323202', '130323', '深河乡', '1', '130323202', null, '3', '1'),
('130324100', '130324', '卢龙镇', '1', '130324100', null, '3', '1'),
('130324101', '130324', '潘庄镇', '1', '130324101', null, '3', '1'),
('130324102', '130324', '燕河营镇', '1', '130324102', null, '3', '1'),
('130324103', '130324', '双望镇', '1', '130324103', null, '3', '1'),
('130324104', '130324', '刘田各庄镇', '1', '130324104', null, '3', '1'),
('130324105', '130324', '石门镇', '1', '130324105', null, '3', '1'),
('130324200', '130324', '下寨乡', '1', '130324200', null, '3', '1'),
('130324201', '130324', '刘家营乡', '1', '130324201', null, '3', '1'),
('130324202', '130324', '陈官屯乡', '1', '130324202', null, '3', '1'),
('130324203', '130324', '印庄乡', '1', '130324203', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('130324204', '130324', '蛤泊乡', '1', '130324204', null, '3', '1'),
('130324205', '130324', '木井乡', '1', '130324205', null, '3', '1'),
('130402001', '130402', '火磨街道', '1', '130402001', null, '3', '1'),
('130402002', '130402', '陵园路街道', '1', '130402002', null, '3', '1'),
('130402003', '130402', '光明路街道', '1', '130402003', null, '3', '1'),
('130402004', '130402', '滏东街道', '1', '130402004', null, '3', '1'),
('130402005', '130402', '罗城头街道', '1', '130402005', null, '3', '1'),
('130402006', '130402', '渚河路街道', '1', '130402006', null, '3', '1'),
('130402007', '130402', '浴新南街道', '1', '130402007', null, '3', '1'),
('130402008', '130402', '农林路街道', '1', '130402008', null, '3', '1'),
('130402009', '130402', '贸东街道', '1', '130402009', null, '3', '1'),
('130402010', '130402', '贸西街道', '1', '130402010', null, '3', '1'),
('130402100', '130402', '马头镇', '1', '130402100', null, '3', '1'),
('130402101', '130402', '北张庄镇', '1', '130402101', null, '3', '1'),
('130402200', '130402', '马庄乡', '1', '130402200', null, '3', '1'),
('130403001', '130403', '丛台西街道', '1', '130403001', null, '3', '1'),
('130403002', '130403', '联纺西街道', '1', '130403002', null, '3', '1'),
('130403003', '130403', '联纺东街道', '1', '130403003', null, '3', '1'),
('130403004', '130403', '光明桥街道', '1', '130403004', null, '3', '1'),
('130403005', '130403', '丛台东街道', '1', '130403005', null, '3', '1'),
('130403006', '130403', '四季青街道', '1', '130403006', null, '3', '1'),
('130403007', '130403', '和平街道', '1', '130403007', null, '3', '1'),
('130403008', '130403', '中华街道', '1', '130403008', null, '3', '1'),
('130403009', '130403', '人民路街道', '1', '130403009', null, '3', '1'),
('130403010', '130403', '柳林桥街道', '1', '130403010', null, '3', '1'),
('130403200', '130403', '苏曹乡', '1', '130403200', null, '3', '1'),
('130404001', '130404', '胜利桥街道', '1', '130404001', null, '3', '1'),
('130404002', '130404', '百家村街道', '1', '130404002', null, '3', '1'),
('130404003', '130404', '铁路大院街道', '1', '130404003', null, '3', '1'),
('130404004', '130404', '化林路街道', '1', '130404004', null, '3', '1'),
('130404005', '130404', '庞村街道', '1', '130404005', null, '3', '1'),
('130404006', '130404', '二六七二街道', '1', '130404006', null, '3', '1'),
('130404007', '130404', '石化街道', '1', '130404007', null, '3', '1'),
('130404200', '130404', '彭家寨乡', '1', '130404200', null, '3', '1'),
('130404400', '130404', '华北冶金建设公司', '1', '130404400', null, '3', '1'),
('130406100', '130406', '临水镇', '1', '130406100', null, '3', '1'),
('130406101', '130406', '峰峰镇', '1', '130406101', null, '3', '1'),
('130406102', '130406', '新坡镇', '1', '130406102', null, '3', '1'),
('130406103', '130406', '大社镇', '1', '130406103', null, '3', '1'),
('130406104', '130406', '和村镇', '1', '130406104', null, '3', '1'),
('130406105', '130406', '义井镇', '1', '130406105', null, '3', '1'),
('130406106', '130406', '彭城镇', '1', '130406106', null, '3', '1'),
('130406107', '130406', '界城镇', '1', '130406107', null, '3', '1'),
('130406108', '130406', '大峪镇', '1', '130406108', null, '3', '1'),
('130421100', '130421', '尚璧镇', '1', '130421100', null, '3', '1'),
('130421101', '130421', '黄粱梦镇', '1', '130421101', null, '3', '1'),
('130421102', '130421', '河沙镇镇', '1', '130421102', null, '3', '1'),
('130421104', '130421', '户村镇', '1', '130421104', null, '3', '1'),
('130421200', '130421', '南堡乡', '1', '130421200', null, '3', '1'),
('130421201', '130421', '南吕固乡', '1', '130421201', null, '3', '1'),
('130421202', '130421', '兼庄乡', '1', '130421202', null, '3', '1'),
('130421203', '130421', '代召乡', '1', '130421203', null, '3', '1'),
('130421204', '130421', '康庄乡', '1', '130421204', null, '3', '1'),
('130421205', '130421', '三陵乡', '1', '130421205', null, '3', '1'),
('130423100', '130423', '临漳镇', '1', '130423100', null, '3', '1'),
('130423101', '130423', '南东坊镇', '1', '130423101', null, '3', '1'),
('130423102', '130423', '孙陶集镇', '1', '130423102', null, '3', '1'),
('130423103', '130423', '柳园镇', '1', '130423103', null, '3', '1'),
('130423104', '130423', '称勾集镇', '1', '130423104', null, '3', '1'),
('130423200', '130423', '狄邱乡', '1', '130423200', null, '3', '1'),
('130423201', '130423', '张村集乡', '1', '130423201', null, '3', '1'),
('130423202', '130423', '西羊羔乡', '1', '130423202', null, '3', '1'),
('130423203', '130423', '香菜营乡', '1', '130423203', null, '3', '1'),
('130423204', '130423', '杜村集乡', '1', '130423204', null, '3', '1'),
('130423205', '130423', '章里集乡', '1', '130423205', null, '3', '1'),
('130423206', '130423', '习文乡', '1', '130423206', null, '3', '1'),
('130423207', '130423', '砖寨营乡', '1', '130423207', null, '3', '1'),
('130423208', '130423', '柏鹤集乡', '1', '130423208', null, '3', '1'),
('130424100', '130424', '成安镇', '1', '130424100', null, '3', '1'),
('130424101', '130424', '商城镇', '1', '130424101', null, '3', '1'),
('130424102', '130424', '漳河店镇', '1', '130424102', null, '3', '1'),
('130424103', '130424', '李家疃镇', '1', '130424103', null, '3', '1'),
('130424200', '130424', '辛义乡', '1', '130424200', null, '3', '1'),
('130424201', '130424', '柏寺营乡', '1', '130424201', null, '3', '1'),
('130424202', '130424', '道东堡乡', '1', '130424202', null, '3', '1'),
('130424203', '130424', '北乡义乡', '1', '130424203', null, '3', '1'),
('130424204', '130424', '长巷乡', '1', '130424204', null, '3', '1'),
('130425100', '130425', '大名镇', '1', '130425100', null, '3', '1'),
('130425101', '130425', '杨桥镇', '1', '130425101', null, '3', '1'),
('130425102', '130425', '万堤镇', '1', '130425102', null, '3', '1'),
('130425103', '130425', '龙王庙镇', '1', '130425103', null, '3', '1'),
('130425104', '130425', '束馆镇', '1', '130425104', null, '3', '1'),
('130425105', '130425', '金滩镇', '1', '130425105', null, '3', '1'),
('130425200', '130425', '沙圪塔乡', '1', '130425200', null, '3', '1'),
('130425201', '130425', '王村乡', '1', '130425201', null, '3', '1'),
('130425202', '130425', '铺上乡', '1', '130425202', null, '3', '1'),
('130425203', '130425', '黄金堤乡', '1', '130425203', null, '3', '1'),
('130425204', '130425', '大街乡', '1', '130425204', null, '3', '1'),
('130425205', '130425', '旧治乡', '1', '130425205', null, '3', '1'),
('130425206', '130425', '西未庄乡', '1', '130425206', null, '3', '1'),
('130425207', '130425', '孙甘店乡', '1', '130425207', null, '3', '1'),
('130425208', '130425', '西付集乡', '1', '130425208', null, '3', '1'),
('130425209', '130425', '埝头乡', '1', '130425209', null, '3', '1'),
('130425210', '130425', '北峰乡', '1', '130425210', null, '3', '1'),
('130425211', '130425', '张集乡', '1', '130425211', null, '3', '1'),
('130425212', '130425', '红庙乡', '1', '130425212', null, '3', '1'),
('130425213', '130425', '营镇回族乡', '1', '130425213', null, '3', '1'),
('130426100', '130426', '涉城镇', '1', '130426100', null, '3', '1'),
('130426101', '130426', '河南店镇', '1', '130426101', null, '3', '1'),
('130426102', '130426', '索堡镇', '1', '130426102', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('130426103', '130426', '西戌镇', '1', '130426103', null, '3', '1'),
('130426104', '130426', '井店镇', '1', '130426104', null, '3', '1'),
('130426105', '130426', '更乐镇', '1', '130426105', null, '3', '1'),
('130426106', '130426', '固新镇', '1', '130426106', null, '3', '1'),
('130426107', '130426', '西达镇', '1', '130426107', null, '3', '1'),
('130426108', '130426', '偏城镇', '1', '130426108', null, '3', '1'),
('130426200', '130426', '神头乡', '1', '130426200', null, '3', '1'),
('130426201', '130426', '辽城乡', '1', '130426201', null, '3', '1'),
('130426202', '130426', '偏店乡', '1', '130426202', null, '3', '1'),
('130426203', '130426', '龙虎乡', '1', '130426203', null, '3', '1'),
('130426204', '130426', '木井乡', '1', '130426204', null, '3', '1'),
('130426205', '130426', '关防乡', '1', '130426205', null, '3', '1'),
('130426206', '130426', '合漳乡', '1', '130426206', null, '3', '1'),
('130426207', '130426', '鹿头乡', '1', '130426207', null, '3', '1'),
('130427100', '130427', '磁州镇', '1', '130427100', null, '3', '1'),
('130427101', '130427', '高臾镇', '1', '130427101', null, '3', '1'),
('130427102', '130427', '西光禄镇', '1', '130427102', null, '3', '1'),
('130427103', '130427', '讲武城镇', '1', '130427103', null, '3', '1'),
('130427104', '130427', '岳城镇', '1', '130427104', null, '3', '1'),
('130427105', '130427', '观台镇', '1', '130427105', null, '3', '1'),
('130427106', '130427', '林坦镇', '1', '130427106', null, '3', '1'),
('130427107', '130427', '白土镇', '1', '130427107', null, '3', '1'),
('130427108', '130427', '黄沙镇', '1', '130427108', null, '3', '1'),
('130427200', '130427', '路村营乡', '1', '130427200', null, '3', '1'),
('130427201', '130427', '西固义乡', '1', '130427201', null, '3', '1'),
('130427202', '130427', '辛庄营乡', '1', '130427202', null, '3', '1'),
('130427203', '130427', '花官营乡', '1', '130427203', null, '3', '1'),
('130427204', '130427', '时村营乡', '1', '130427204', null, '3', '1'),
('130427205', '130427', '南城乡', '1', '130427205', null, '3', '1'),
('130427206', '130427', '台城乡', '1', '130427206', null, '3', '1'),
('130427207', '130427', '陶泉乡', '1', '130427207', null, '3', '1'),
('130427208', '130427', '都党乡', '1', '130427208', null, '3', '1'),
('130427209', '130427', '北贾壁乡', '1', '130427209', null, '3', '1'),
('130428100', '130428', '肥乡镇', '1', '130428100', null, '3', '1'),
('130428101', '130428', '天台山镇', '1', '130428101', null, '3', '1'),
('130428200', '130428', '大西韩乡', '1', '130428200', null, '3', '1'),
('130428201', '130428', '辛安镇乡', '1', '130428201', null, '3', '1'),
('130428202', '130428', '毛演堡乡', '1', '130428202', null, '3', '1'),
('130428203', '130428', '元固乡', '1', '130428203', null, '3', '1'),
('130428204', '130428', '屯庄营乡', '1', '130428204', null, '3', '1'),
('130428205', '130428', '东漳堡乡', '1', '130428205', null, '3', '1'),
('130428206', '130428', '旧店乡', '1', '130428206', null, '3', '1'),
('130429100', '130429', '临洺关镇', '1', '130429100', null, '3', '1'),
('130429101', '130429', '大北汪镇', '1', '130429101', null, '3', '1'),
('130429102', '130429', '张西堡镇', '1', '130429102', null, '3', '1'),
('130429103', '130429', '广府镇', '1', '130429103', null, '3', '1'),
('130429104', '130429', '南沿村镇', '1', '130429104', null, '3', '1'),
('130429105', '130429', '永合会镇', '1', '130429105', null, '3', '1'),
('130429200', '130429', '西苏乡', '1', '130429200', null, '3', '1'),
('130429201', '130429', '界河店乡', '1', '130429201', null, '3', '1'),
('130429202', '130429', '刘营乡', '1', '130429202', null, '3', '1'),
('130429203', '130429', '刘汉乡', '1', '130429203', null, '3', '1'),
('130429204', '130429', '正西乡', '1', '130429204', null, '3', '1'),
('130429205', '130429', '讲武乡', '1', '130429205', null, '3', '1'),
('130429206', '130429', '曲陌乡', '1', '130429206', null, '3', '1'),
('130429207', '130429', '辛庄堡乡', '1', '130429207', null, '3', '1'),
('130429208', '130429', '小龙马乡', '1', '130429208', null, '3', '1'),
('130429209', '130429', '东杨庄乡', '1', '130429209', null, '3', '1'),
('130429210', '130429', '小西堡乡', '1', '130429210', null, '3', '1'),
('130429211', '130429', '西河庄乡', '1', '130429211', null, '3', '1'),
('130429212', '130429', '姚寨乡', '1', '130429212', null, '3', '1'),
('130429213', '130429', '西阳城乡', '1', '130429213', null, '3', '1'),
('130430100', '130430', '新马头镇', '1', '130430100', null, '3', '1'),
('130430101', '130430', '邱城镇', '1', '130430101', null, '3', '1'),
('130430200', '130430', '梁二庄乡', '1', '130430200', null, '3', '1'),
('130430201', '130430', '南辛店乡', '1', '130430201', null, '3', '1'),
('130430202', '130430', '香城固乡', '1', '130430202', null, '3', '1'),
('130430203', '130430', '古城营乡', '1', '130430203', null, '3', '1'),
('130430204', '130430', '陈村回族乡', '1', '130430204', null, '3', '1'),
('130431100', '130431', '鸡泽镇', '1', '130431100', null, '3', '1'),
('130431101', '130431', '小寨镇', '1', '130431101', null, '3', '1'),
('130431102', '130431', '双塔镇', '1', '130431102', null, '3', '1'),
('130431200', '130431', '浮图店乡', '1', '130431200', null, '3', '1'),
('130431201', '130431', '吴官营乡', '1', '130431201', null, '3', '1'),
('130431202', '130431', '风正乡', '1', '130431202', null, '3', '1'),
('130431203', '130431', '曹庄乡', '1', '130431203', null, '3', '1'),
('130432100', '130432', '广平镇', '1', '130432100', null, '3', '1'),
('130432101', '130432', '平固店镇', '1', '130432101', null, '3', '1'),
('130432200', '130432', '双庙乡', '1', '130432200', null, '3', '1'),
('130432201', '130432', '十里铺乡', '1', '130432201', null, '3', '1'),
('130432202', '130432', '南韩村乡', '1', '130432202', null, '3', '1'),
('130432203', '130432', '南阳堡乡', '1', '130432203', null, '3', '1'),
('130432204', '130432', '东张孟乡', '1', '130432204', null, '3', '1'),
('130433100', '130433', '馆陶镇', '1', '130433100', null, '3', '1'),
('130433101', '130433', '房寨镇', '1', '130433101', null, '3', '1'),
('130433102', '130433', '柴堡镇', '1', '130433102', null, '3', '1'),
('130433103', '130433', '魏僧寨镇', '1', '130433103', null, '3', '1'),
('130433200', '130433', '寿山寺乡', '1', '130433200', null, '3', '1'),
('130433201', '130433', '王桥乡', '1', '130433201', null, '3', '1'),
('130433202', '130433', '南徐村乡', '1', '130433202', null, '3', '1'),
('130433203', '130433', '路桥乡', '1', '130433203', null, '3', '1'),
('130434100', '130434', '魏城镇', '1', '130434100', null, '3', '1'),
('130434101', '130434', '德政镇', '1', '130434101', null, '3', '1'),
('130434102', '130434', '北皋镇', '1', '130434102', null, '3', '1'),
('130434103', '130434', '双井镇', '1', '130434103', null, '3', '1'),
('130434104', '130434', '牙里镇', '1', '130434104', null, '3', '1'),
('130434105', '130434', '车往镇', '1', '130434105', null, '3', '1'),
('130434106', '130434', '回隆镇', '1', '130434106', null, '3', '1'),
('130434200', '130434', '东代固乡', '1', '130434200', null, '3', '1'),
('130434201', '130434', '棘针寨乡', '1', '130434201', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('130434202', '130434', '沙口集乡', '1', '130434202', null, '3', '1'),
('130434203', '130434', '野胡拐乡', '1', '130434203', null, '3', '1'),
('130434204', '130434', '仕望集乡', '1', '130434204', null, '3', '1'),
('130434205', '130434', '前大磨乡', '1', '130434205', null, '3', '1'),
('130434206', '130434', '院堡乡', '1', '130434206', null, '3', '1'),
('130434207', '130434', '南双庙乡', '1', '130434207', null, '3', '1'),
('130434208', '130434', '大辛庄乡', '1', '130434208', null, '3', '1'),
('130434209', '130434', '大马村乡', '1', '130434209', null, '3', '1'),
('130434210', '130434', '边马乡', '1', '130434210', null, '3', '1'),
('130434211', '130434', '张二庄乡', '1', '130434211', null, '3', '1'),
('130434212', '130434', '北台头乡', '1', '130434212', null, '3', '1'),
('130434213', '130434', '泊口乡', '1', '130434213', null, '3', '1'),
('130435100', '130435', '曲周镇', '1', '130435100', null, '3', '1'),
('130435101', '130435', '安寨镇', '1', '130435101', null, '3', '1'),
('130435102', '130435', '侯村镇', '1', '130435102', null, '3', '1'),
('130435103', '130435', '河南疃镇', '1', '130435103', null, '3', '1'),
('130435200', '130435', '槐桥乡', '1', '130435200', null, '3', '1'),
('130435201', '130435', '南里岳乡', '1', '130435201', null, '3', '1'),
('130435202', '130435', '白寨乡', '1', '130435202', null, '3', '1'),
('130435203', '130435', '大河道乡', '1', '130435203', null, '3', '1'),
('130435204', '130435', '依庄乡', '1', '130435204', null, '3', '1'),
('130435205', '130435', '第四疃乡', '1', '130435205', null, '3', '1'),
('130481100', '130481', '武安镇', '1', '130481100', null, '3', '1'),
('130481101', '130481', '康二城镇', '1', '130481101', null, '3', '1'),
('130481102', '130481', '午汲镇', '1', '130481102', null, '3', '1'),
('130481103', '130481', '磁山镇', '1', '130481103', null, '3', '1'),
('130481104', '130481', '伯延镇', '1', '130481104', null, '3', '1'),
('130481105', '130481', '淑村镇', '1', '130481105', null, '3', '1'),
('130481106', '130481', '大同镇', '1', '130481106', null, '3', '1'),
('130481107', '130481', '邑城镇', '1', '130481107', null, '3', '1'),
('130481108', '130481', '矿山镇', '1', '130481108', null, '3', '1'),
('130481109', '130481', '贺进镇', '1', '130481109', null, '3', '1'),
('130481110', '130481', '阳邑镇', '1', '130481110', null, '3', '1'),
('130481111', '130481', '徘徊镇', '1', '130481111', null, '3', '1'),
('130481112', '130481', '冶陶镇', '1', '130481112', null, '3', '1'),
('130481200', '130481', '上团城乡', '1', '130481200', null, '3', '1'),
('130481201', '130481', '北安庄乡', '1', '130481201', null, '3', '1'),
('130481202', '130481', '北安乐乡', '1', '130481202', null, '3', '1'),
('130481203', '130481', '西土山乡', '1', '130481203', null, '3', '1'),
('130481204', '130481', '西寺庄乡', '1', '130481204', null, '3', '1'),
('130481205', '130481', '活水乡', '1', '130481205', null, '3', '1'),
('130481206', '130481', '石洞乡', '1', '130481206', null, '3', '1'),
('130481207', '130481', '管陶乡', '1', '130481207', null, '3', '1'),
('130481208', '130481', '马家庄乡', '1', '130481208', null, '3', '1'),
('130502001', '130502', '南长街街道', '1', '130502001', null, '3', '1'),
('130502002', '130502', '北大街街道', '1', '130502002', null, '3', '1'),
('130502003', '130502', '西大街街道', '1', '130502003', null, '3', '1'),
('130502004', '130502', '西门里街道', '1', '130502004', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('130502200', '130502', '大梁庄乡', '1', '130502200', null, '3', '1'),
('130502201', '130502', '东郭村乡', '1', '130502201', null, '3', '1'),
('130502400', '130502', '市高新技术开发区', '1', '130502400', null, '3', '1'),
('130503001', '130503', '钢铁路街道', '1', '130503001', null, '3', '1'),
('130503002', '130503', '中兴路街道', '1', '130503002', null, '3', '1'),
('130503003', '130503', '达活泉街道', '1', '130503003', null, '3', '1'),
('130503004', '130503', '张宽街道', '1', '130503004', null, '3', '1'),
('130503005', '130503', '章村街道', '1', '130503005', null, '3', '1'),
('130503200', '130503', '南大郭乡', '1', '130503200', null, '3', '1'),
('130503201', '130503', '李村乡', '1', '130503201', null, '3', '1'),
('130521001', '130521', '豫让桥街道', '1', '130521001', null, '3', '1'),
('130521100', '130521', '东汪镇', '1', '130521100', null, '3', '1'),
('130521101', '130521', '王快镇', '1', '130521101', null, '3', '1'),
('130521102', '130521', '祝村镇', '1', '130521102', null, '3', '1'),
('130521103', '130521', '晏家屯镇', '1', '130521103', null, '3', '1'),
('130521104', '130521', '南石门镇', '1', '130521104', null, '3', '1'),
('130521105', '130521', '羊范镇', '1', '130521105', null, '3', '1'),
('130521106', '130521', '皇寺镇', '1', '130521106', null, '3', '1'),
('130521107', '130521', '会宁镇', '1', '130521107', null, '3', '1'),
('130521108', '130521', '西黄村镇', '1', '130521108', null, '3', '1'),
('130521109', '130521', '路罗镇', '1', '130521109', null, '3', '1'),
('130521110', '130521', '将军墓镇', '1', '130521110', null, '3', '1'),
('130521111', '130521', '浆水镇', '1', '130521111', null, '3', '1'),
('130521112', '130521', '宋家庄镇', '1', '130521112', null, '3', '1'),
('130521200', '130521', '太子井乡', '1', '130521200', null, '3', '1'),
('130521201', '130521', '龙泉寺乡', '1', '130521201', null, '3', '1'),
('130521202', '130521', '北小庄乡', '1', '130521202', null, '3', '1'),
('130521203', '130521', '城计头乡', '1', '130521203', null, '3', '1'),
('130521204', '130521', '白岸乡', '1', '130521204', null, '3', '1'),
('130521206', '130521', '冀家村乡', '1', '130521206', null, '3', '1'),
('130522100', '130522', '临城镇', '1', '130522100', null, '3', '1'),
('130522101', '130522', '东镇镇', '1', '130522101', null, '3', '1'),
('130522102', '130522', '西竖镇', '1', '130522102', null, '3', '1'),
('130522103', '130522', '郝庄镇', '1', '130522103', null, '3', '1'),
('130522200', '130522', '黑城乡', '1', '130522200', null, '3', '1'),
('130522201', '130522', '鸭鸽营乡', '1', '130522201', null, '3', '1'),
('130522203', '130522', '石城乡', '1', '130522203', null, '3', '1'),
('130522205', '130522', '赵庄乡', '1', '130522205', null, '3', '1'),
('130523100', '130523', '内邱镇', '1', '130523100', null, '3', '1'),
('130523101', '130523', '大孟村镇', '1', '130523101', null, '3', '1'),
('130523102', '130523', '金店镇', '1', '130523102', null, '3', '1'),
('130523103', '130523', '官庄镇', '1', '130523103', null, '3', '1'),
('130523104', '130523', '柳林镇', '1', '130523104', null, '3', '1'),
('130523200', '130523', '五郭店乡', '1', '130523200', null, '3', '1'),
('130523203', '130523', '南赛乡', '1', '130523203', null, '3', '1'),
('130523204', '130523', '獐么乡', '1', '130523204', null, '3', '1'),
('130523205', '130523', '侯家庄乡', '1', '130523205', null, '3', '1'),
('130524100', '130524', '柏乡镇', '1', '130524100', null, '3', '1'),
('130524101', '130524', '固城店镇', '1', '130524101', null, '3', '1'),
('130524200', '130524', '王家庄乡', '1', '130524200', null, '3', '1'),
('130524201', '130524', '西汪乡', '1', '130524201', null, '3', '1'),
('130524202', '130524', '龙华乡', '1', '130524202', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('130524203', '130524', '内步乡', '1', '130524203', null, '3', '1'),
('130525100', '130525', '隆尧镇', '1', '130525100', null, '3', '1'),
('130525101', '130525', '魏家庄镇', '1', '130525101', null, '3', '1'),
('130525102', '130525', '尹村镇', '1', '130525102', null, '3', '1'),
('130525103', '130525', '山口镇', '1', '130525103', null, '3', '1'),
('130525104', '130525', '莲子镇', '1', '130525104', null, '3', '1'),
('130525105', '130525', '固城镇', '1', '130525105', null, '3', '1'),
('130525200', '130525', '北楼乡', '1', '130525200', null, '3', '1'),
('130525201', '130525', '东良乡', '1', '130525201', null, '3', '1'),
('130525202', '130525', '双碑乡', '1', '130525202', null, '3', '1'),
('130525203', '130525', '牛家桥乡', '1', '130525203', null, '3', '1'),
('130525204', '130525', '千户营乡', '1', '130525204', null, '3', '1'),
('130525205', '130525', '大张庄乡', '1', '130525205', null, '3', '1'),
('130525400', '130525', '柳行农场', '1', '130525400', null, '3', '1'),
('130526100', '130526', '任城镇', '1', '130526100', null, '3', '1'),
('130526101', '130526', '邢家湾镇', '1', '130526101', null, '3', '1'),
('130526102', '130526', '辛店镇', '1', '130526102', null, '3', '1'),
('130526200', '130526', '西固城乡', '1', '130526200', null, '3', '1'),
('130526201', '130526', '永福庄乡', '1', '130526201', null, '3', '1'),
('130526202', '130526', '大屯乡', '1', '130526202', null, '3', '1'),
('130526203', '130526', '天口乡', '1', '130526203', null, '3', '1'),
('130526204', '130526', '骆庄乡', '1', '130526204', null, '3', '1'),
('130527100', '130527', '和阳镇', '1', '130527100', null, '3', '1'),
('130527101', '130527', '贾宋镇', '1', '130527101', null, '3', '1'),
('130527102', '130527', '郝桥镇', '1', '130527102', null, '3', '1'),
('130527200', '130527', '东三召乡', '1', '130527200', null, '3', '1'),
('130527201', '130527', '阎里乡', '1', '130527201', null, '3', '1'),
('130527202', '130527', '河郭乡', '1', '130527202', null, '3', '1'),
('130527203', '130527', '史召乡', '1', '130527203', null, '3', '1'),
('130527204', '130527', '三思乡', '1', '130527204', null, '3', '1'),
('130528100', '130528', '凤凰镇', '1', '130528100', null, '3', '1'),
('130528101', '130528', '河渠镇', '1', '130528101', null, '3', '1'),
('130528102', '130528', '北河庄镇', '1', '130528102', null, '3', '1'),
('130528103', '130528', '耿庄桥镇', '1', '130528103', null, '3', '1'),
('130528104', '130528', '东汪镇', '1', '130528104', null, '3', '1'),
('130528105', '130528', '贾家口镇', '1', '130528105', null, '3', '1'),
('130528106', '130528', '四芝兰镇', '1', '130528106', null, '3', '1'),
('130528107', '130528', '大陆村镇', '1', '130528107', null, '3', '1'),
('130528108', '130528', '苏家庄镇', '1', '130528108', null, '3', '1'),
('130528109', '130528', '换马店镇', '1', '130528109', null, '3', '1'),
('130528200', '130528', '侯口乡', '1', '130528200', null, '3', '1'),
('130528202', '130528', '纪昌庄乡', '1', '130528202', null, '3', '1'),
('130528203', '130528', '唐邱乡', '1', '130528203', null, '3', '1'),
('130528205', '130528', '北鱼乡', '1', '130528205', null, '3', '1'),
('130528206', '130528', '徐家河乡', '1', '130528206', null, '3', '1'),
('130528207', '130528', '大曹庄乡', '1', '130528207', null, '3', '1'),
('130528400', '130528', '大曹庄管理区', '1', '130528400', null, '3', '1'),
('130529100', '130529', '巨鹿镇', '1', '130529100', null, '3', '1'),
('130529101', '130529', '王虎寨镇', '1', '130529101', null, '3', '1'),
('130529102', '130529', '西郭城镇', '1', '130529102', null, '3', '1'),
('130529103', '130529', '官亭镇', '1', '130529103', null, '3', '1'),
('130529104', '130529', '阎疃镇', '1', '130529104', null, '3', '1'),
('130529105', '130529', '小吕寨镇', '1', '130529105', null, '3', '1'),
('130529200', '130529', '堤村乡', '1', '130529200', null, '3', '1'),
('130529201', '130529', '张王疃乡', '1', '130529201', null, '3', '1'),
('130529202', '130529', '观寨乡', '1', '130529202', null, '3', '1'),
('130529203', '130529', '苏家营乡', '1', '130529203', null, '3', '1'),
('130530100', '130530', '新河镇', '1', '130530100', null, '3', '1'),
('130530101', '130530', '寻寨镇', '1', '130530101', null, '3', '1'),
('130530200', '130530', '白神首乡', '1', '130530200', null, '3', '1'),
('130530201', '130530', '荆家庄乡', '1', '130530201', null, '3', '1'),
('130530202', '130530', '西流乡', '1', '130530202', null, '3', '1'),
('130530203', '130530', '仁让里乡', '1', '130530203', null, '3', '1'),
('130531100', '130531', '广宗镇', '1', '130531100', null, '3', '1'),
('130531200', '130531', '葫芦乡', '1', '130531200', null, '3', '1'),
('130531201', '130531', '大平台乡', '1', '130531201', null, '3', '1'),
('130531202', '130531', '件只乡', '1', '130531202', null, '3', '1'),
('130531203', '130531', '核桃园乡', '1', '130531203', null, '3', '1'),
('130531204', '130531', '东召乡', '1', '130531204', null, '3', '1'),
('130531205', '130531', '北塘疃乡', '1', '130531205', null, '3', '1'),
('130531206', '130531', '冯家寨乡', '1', '130531206', null, '3', '1'),
('130532100', '130532', '丰州镇', '1', '130532100', null, '3', '1'),
('130532101', '130532', '平乡镇', '1', '130532101', null, '3', '1'),
('130532102', '130532', '河古庙镇', '1', '130532102', null, '3', '1'),
('130532200', '130532', '节固乡', '1', '130532200', null, '3', '1'),
('130532201', '130532', '油召乡', '1', '130532201', null, '3', '1'),
('130532202', '130532', '田付村乡', '1', '130532202', null, '3', '1'),
('130532203', '130532', '寻召乡', '1', '130532203', null, '3', '1'),
('130533100', '130533', '名州镇', '1', '130533100', null, '3', '1'),
('130533101', '130533', '梨元屯镇', '1', '130533101', null, '3', '1'),
('130533102', '130533', '章台镇', '1', '130533102', null, '3', '1'),
('130533103', '130533', '侯贯镇', '1', '130533103', null, '3', '1'),
('130533104', '130533', '七级镇', '1', '130533104', null, '3', '1'),
('130533200', '130533', '方家营乡', '1', '130533200', null, '3', '1'),
('130533201', '130533', '第什营乡', '1', '130533201', null, '3', '1'),
('130533202', '130533', '枣园乡', '1', '130533202', null, '3', '1'),
('130533203', '130533', '固献乡', '1', '130533203', null, '3', '1'),
('130533204', '130533', '贺钊乡', '1', '130533204', null, '3', '1'),
('130533205', '130533', '贺营乡', '1', '130533205', null, '3', '1'),
('130533206', '130533', '张营乡', '1', '130533206', null, '3', '1'),
('130533207', '130533', '常屯乡', '1', '130533207', null, '3', '1'),
('130533208', '130533', '常庄乡', '1', '130533208', null, '3', '1'),
('130533209', '130533', '高公庄乡', '1', '130533209', null, '3', '1'),
('130533210', '130533', '赵村乡', '1', '130533210', null, '3', '1'),
('130534100', '130534', '葛仙庄镇', '1', '130534100', null, '3', '1'),
('130534101', '130534', '连庄镇', '1', '130534101', null, '3', '1'),
('130534102', '130534', '油坊镇', '1', '130534102', null, '3', '1'),
('130534103', '130534', '谢炉镇', '1', '130534103', null, '3', '1'),
('130534104', '130534', '王官庄镇', '1', '130534104', null, '3', '1'),
('130534105', '130534', '坝营镇', '1', '130534105', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('130535100', '130535', '临西镇', '1', '130535100', null, '3', '1'),
('130535101', '130535', '河西镇', '1', '130535101', null, '3', '1'),
('130535102', '130535', '下堡寺镇', '1', '130535102', null, '3', '1'),
('130535103', '130535', '尖冢镇', '1', '130535103', null, '3', '1'),
('130535200', '130535', '东枣园乡', '1', '130535200', null, '3', '1'),
('130535201', '130535', '老官寨乡', '1', '130535201', null, '3', '1'),
('130535202', '130535', '吕寨乡', '1', '130535202', null, '3', '1'),
('130535203', '130535', '摇鞍镇乡', '1', '130535203', null, '3', '1'),
('130535204', '130535', '大刘庄乡', '1', '130535204', null, '3', '1'),
('130581001', '130581', '凤岗街道', '1', '130581001', null, '3', '1'),
('130581002', '130581', '南杜街道', '1', '130581002', null, '3', '1'),
('130581003', '130581', '北胡街道', '1', '130581003', null, '3', '1'),
('130581004', '130581', '西丁街道', '1', '130581004', null, '3', '1'),
('130581100', '130581', '苏村镇', '1', '130581100', null, '3', '1'),
('130581101', '130581', '大高村镇', '1', '130581101', null, '3', '1'),
('130581102', '130581', '垂杨镇', '1', '130581102', null, '3', '1'),
('130581103', '130581', '明化镇', '1', '130581103', null, '3', '1'),
('130581104', '130581', '段芦头镇', '1', '130581104', null, '3', '1'),
('130581105', '130581', '紫冢镇', '1', '130581105', null, '3', '1'),
('130581200', '130581', '大村乡', '1', '130581200', null, '3', '1'),
('130581201', '130581', '南便村乡', '1', '130581201', null, '3', '1'),
('130581202', '130581', '大屯乡', '1', '130581202', null, '3', '1'),
('130581203', '130581', '王道寨乡', '1', '130581203', null, '3', '1'),
('130581204', '130581', '薛吴村乡', '1', '130581204', null, '3', '1'),
('130582001', '130582', '褡裢街道', '1', '130582001', null, '3', '1'),
('130582002', '130582', '桥东街道', '1', '130582002', null, '3', '1'),
('130582003', '130582', '桥西街道', '1', '130582003', null, '3', '1'),
('130582004', '130582', '赞善街道', '1', '130582004', null, '3', '1'),
('130582005', '130582', '周庄街道', '1', '130582005', null, '3', '1'),
('130582100', '130582', '沙河城镇', '1', '130582100', null, '3', '1'),
('130582101', '130582', '新城镇', '1', '130582101', null, '3', '1'),
('130582102', '130582', '白塔镇', '1', '130582102', null, '3', '1'),
('130582103', '130582', '十里亭镇', '1', '130582103', null, '3', '1'),
('130582104', '130582', '綦村镇', '1', '130582104', null, '3', '1'),
('130582200', '130582', '留村乡', '1', '130582200', null, '3', '1'),
('130582201', '130582', '册井乡', '1', '130582201', null, '3', '1'),
('130582202', '130582', '刘石岗乡', '1', '130582202', null, '3', '1'),
('130582203', '130582', '柴关乡', '1', '130582203', null, '3', '1'),
('130582204', '130582', '蝉房乡', '1', '130582204', null, '3', '1'),
('130582401', '130582', '华北冶金矿山建设公司', '1', '130582401', null, '3', '1'),
('130582402', '130582', '华北冶金设备制造厂', '1', '130582402', null, '3', '1'),
('130602001', '130602', '先锋街道', '1', '130602001', null, '3', '1'),
('130602002', '130602', '新市场街道', '1', '130602002', null, '3', '1'),
('130602003', '130602', '东风街道', '1', '130602003', null, '3', '1'),
('130602004', '130602', '建南街道', '1', '130602004', null, '3', '1'),
('130602005', '130602', '韩村北路街道', '1', '130602005', null, '3', '1'),
('130602200', '130602', '颉庄乡', '1', '130602200', null, '3', '1'),
('130602201', '130602', '富昌乡', '1', '130602201', null, '3', '1'),
('130602202', '130602', '韩村乡', '1', '130602202', null, '3', '1'),
('130602203', '130602', '南奇乡', '1', '130602203', null, '3', '1'),
('130602204', '130602', '江城乡', '1', '130602204', null, '3', '1'),
('130602205', '130602', '大马坊乡', '1', '130602205', null, '3', '1'),
('130602400', '130602', '保定国家高新区', '1', '130602400', null, '3', '1'),
('130603001', '130603', '和平里街道', '1', '130603001', null, '3', '1'),
('130603002', '130603', '五四路街道', '1', '130603002', null, '3', '1'),
('130603003', '130603', '西关街道', '1', '130603003', null, '3', '1'),
('130603004', '130603', '中华路街道', '1', '130603004', null, '3', '1'),
('130603005', '130603', '东关街道', '1', '130603005', null, '3', '1'),
('130603200', '130603', '韩庄乡', '1', '130603200', null, '3', '1'),
('130603201', '130603', '东金庄乡', '1', '130603201', null, '3', '1'),
('130603202', '130603', '百楼乡', '1', '130603202', null, '3', '1'),
('130604001', '130604', '联盟街道', '1', '130604001', null, '3', '1'),
('130604002', '130604', '红星街道', '1', '130604002', null, '3', '1'),
('130604003', '130604', '裕华街道', '1', '130604003', null, '3', '1'),
('130604004', '130604', '永华街道', '1', '130604004', null, '3', '1'),
('130604005', '130604', '南关街道', '1', '130604005', null, '3', '1'),
('130604200', '130604', '杨庄乡', '1', '130604200', null, '3', '1'),
('130604201', '130604', '南大园乡', '1', '130604201', null, '3', '1'),
('130604202', '130604', '焦庄乡', '1', '130604202', null, '3', '1'),
('130604203', '130604', '五尧乡', '1', '130604203', null, '3', '1'),
('130621001', '130621', '惠阳街道', '1', '130621001', null, '3', '1'),
('130621100', '130621', '满城镇', '1', '130621100', null, '3', '1'),
('130621101', '130621', '大册营镇', '1', '130621101', null, '3', '1'),
('130621102', '130621', '神星镇', '1', '130621102', null, '3', '1'),
('130621103', '130621', '南韩村镇', '1', '130621103', null, '3', '1'),
('130621200', '130621', '方顺桥乡', '1', '130621200', null, '3', '1'),
('130621201', '130621', '于家庄乡', '1', '130621201', null, '3', '1'),
('130621202', '130621', '贤台乡', '1', '130621202', null, '3', '1'),
('130621203', '130621', '要庄乡', '1', '130621203', null, '3', '1'),
('130621204', '130621', '白龙乡', '1', '130621204', null, '3', '1'),
('130621205', '130621', '石井乡', '1', '130621205', null, '3', '1'),
('130621206', '130621', '坨南乡', '1', '130621206', null, '3', '1'),
('130621207', '130621', '刘家台乡', '1', '130621207', null, '3', '1'),
('130622100', '130622', '清苑镇', '1', '130622100', null, '3', '1'),
('130622101', '130622', '冉庄镇', '1', '130622101', null, '3', '1'),
('130622102', '130622', '阳城镇', '1', '130622102', null, '3', '1'),
('130622103', '130622', '魏村镇', '1', '130622103', null, '3', '1'),
('130622104', '130622', '温仁镇', '1', '130622104', null, '3', '1'),
('130622105', '130622', '张登镇', '1', '130622105', null, '3', '1'),
('130622106', '130622', '大庄镇', '1', '130622106', null, '3', '1'),
('130622107', '130622', '臧村镇', '1', '130622107', null, '3', '1'),
('130622200', '130622', '白团乡', '1', '130622200', null, '3', '1'),
('130622201', '130622', '北店乡', '1', '130622201', null, '3', '1'),
('130622202', '130622', '石桥乡', '1', '130622202', null, '3', '1'),
('130622203', '130622', '李庄乡', '1', '130622203', null, '3', '1'),
('130622204', '130622', '北王力乡', '1', '130622204', null, '3', '1'),
('130622205', '130622', '东吕乡', '1', '130622205', null, '3', '1'),
('130622206', '130622', '何桥乡', '1', '130622206', null, '3', '1'),
('130622207', '130622', '孙村乡', '1', '130622207', null, '3', '1'),
('130622208', '130622', '阎庄乡', '1', '130622208', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('130622209', '130622', '望亭乡', '1', '130622209', null, '3', '1'),
('130623001', '130623', '城区社区管理办公室街道', '1', '130623001', null, '3', '1'),
('130623100', '130623', '涞水镇', '1', '130623100', null, '3', '1'),
('130623101', '130623', '永阳镇', '1', '130623101', null, '3', '1'),
('130623102', '130623', '义安镇', '1', '130623102', null, '3', '1'),
('130623103', '130623', '石亭镇', '1', '130623103', null, '3', '1'),
('130623104', '130623', '赵各庄镇', '1', '130623104', null, '3', '1'),
('130623105', '130623', '九龙镇', '1', '130623105', null, '3', '1'),
('130623106', '130623', '三坡镇', '1', '130623106', null, '3', '1'),
('130623200', '130623', '明义乡', '1', '130623200', null, '3', '1'),
('130623201', '130623', '王村乡', '1', '130623201', null, '3', '1'),
('130623202', '130623', '东文山乡', '1', '130623202', null, '3', '1'),
('130623203', '130623', '娄村满族乡', '1', '130623203', null, '3', '1'),
('130623204', '130623', '宋各庄乡', '1', '130623204', null, '3', '1'),
('130623205', '130623', '其中口乡', '1', '130623205', null, '3', '1'),
('130623206', '130623', '龙门乡', '1', '130623206', null, '3', '1'),
('130623207', '130623', '胡家庄乡', '1', '130623207', null, '3', '1'),
('130624100', '130624', '阜平镇', '1', '130624100', null, '3', '1'),
('130624101', '130624', '龙泉关镇', '1', '130624101', null, '3', '1'),
('130624102', '130624', '平阳镇', '1', '130624102', null, '3', '1'),
('130624103', '130624', '城南庄镇', '1', '130624103', null, '3', '1'),
('130624200', '130624', '东下关乡', '1', '130624200', null, '3', '1'),
('130624201', '130624', '王林口乡', '1', '130624201', null, '3', '1'),
('130624202', '130624', '台峪乡', '1', '130624202', null, '3', '1'),
('130624203', '130624', '大台乡', '1', '130624203', null, '3', '1'),
('130624204', '130624', '史家寨乡', '1', '130624204', null, '3', '1'),
('130624205', '130624', '砂窝乡', '1', '130624205', null, '3', '1'),
('130624206', '130624', '吴王口乡', '1', '130624206', null, '3', '1'),
('130624207', '130624', '下庄乡', '1', '130624207', null, '3', '1'),
('130624208', '130624', '北果元乡', '1', '130624208', null, '3', '1'),
('130625100', '130625', '安肃镇', '1', '130625100', null, '3', '1'),
('130625101', '130625', '崔庄镇', '1', '130625101', null, '3', '1'),
('130625102', '130625', '大因镇', '1', '130625102', null, '3', '1'),
('130625103', '130625', '遂城镇', '1', '130625103', null, '3', '1'),
('130625104', '130625', '高林村镇', '1', '130625104', null, '3', '1'),
('130625105', '130625', '大王店镇', '1', '130625105', null, '3', '1'),
('130625106', '130625', '漕河镇', '1', '130625106', null, '3', '1'),
('130625200', '130625', '东史端乡', '1', '130625200', null, '3', '1'),
('130625201', '130625', '留村乡', '1', '130625201', null, '3', '1'),
('130625202', '130625', '正村乡', '1', '130625202', null, '3', '1'),
('130625203', '130625', '户木乡', '1', '130625203', null, '3', '1'),
('130625204', '130625', '瀑河乡', '1', '130625204', null, '3', '1'),
('130625205', '130625', '东釜山乡', '1', '130625205', null, '3', '1'),
('130625206', '130625', '义联庄乡', '1', '130625206', null, '3', '1'),
('130626100', '130626', '定兴镇', '1', '130626100', null, '3', '1'),
('130626101', '130626', '固城镇', '1', '130626101', null, '3', '1'),
('130626102', '130626', '贤寓镇', '1', '130626102', null, '3', '1'),
('130626103', '130626', '北河镇', '1', '130626103', null, '3', '1'),
('130626200', '130626', '东落堡乡', '1', '130626200', null, '3', '1'),
('130626201', '130626', '高里乡', '1', '130626201', null, '3', '1'),
('130626202', '130626', '张家庄乡', '1', '130626202', null, '3', '1'),
('130626203', '130626', '姚村乡', '1', '130626203', null, '3', '1'),
('130626204', '130626', '肖村乡', '1', '130626204', null, '3', '1'),
('130626205', '130626', '柳卓乡', '1', '130626205', null, '3', '1'),
('130626206', '130626', '杨村乡', '1', '130626206', null, '3', '1'),
('130626207', '130626', '北田乡', '1', '130626207', null, '3', '1'),
('130626208', '130626', '北南蔡乡', '1', '130626208', null, '3', '1'),
('130626209', '130626', '李郁庄乡', '1', '130626209', null, '3', '1'),
('130626210', '130626', '天宫寺乡', '1', '130626210', null, '3', '1'),
('130626211', '130626', '小朱庄乡', '1', '130626211', null, '3', '1'),
('130627100', '130627', '仁厚镇', '1', '130627100', null, '3', '1'),
('130627101', '130627', '王京镇', '1', '130627101', null, '3', '1'),
('130627102', '130627', '高昌镇', '1', '130627102', null, '3', '1'),
('130627103', '130627', '北罗镇', '1', '130627103', null, '3', '1'),
('130627104', '130627', '白合镇', '1', '130627104', null, '3', '1'),
('130627105', '130627', '军城镇', '1', '130627105', null, '3', '1'),
('130627106', '130627', '川里镇', '1', '130627106', null, '3', '1'),
('130627200', '130627', '长古城乡', '1', '130627200', null, '3', '1'),
('130627201', '130627', '都亭乡', '1', '130627201', null, '3', '1'),
('130627202', '130627', '南店头乡', '1', '130627202', null, '3', '1'),
('130627203', '130627', '北店头乡', '1', '130627203', null, '3', '1'),
('130627204', '130627', '罗庄乡', '1', '130627204', null, '3', '1'),
('130627205', '130627', '雹水乡', '1', '130627205', null, '3', '1'),
('130627206', '130627', '大洋乡', '1', '130627206', null, '3', '1'),
('130627207', '130627', '迷城乡', '1', '130627207', null, '3', '1'),
('130627208', '130627', '齐家佐乡', '1', '130627208', null, '3', '1'),
('130627209', '130627', '羊角乡', '1', '130627209', null, '3', '1'),
('130627210', '130627', '石门乡', '1', '130627210', null, '3', '1'),
('130627211', '130627', '黄石口乡', '1', '130627211', null, '3', '1'),
('130627212', '130627', '倒马关乡', '1', '130627212', null, '3', '1'),
('130628100', '130628', '高阳镇', '1', '130628100', null, '3', '1'),
('130628101', '130628', '庞口镇', '1', '130628101', null, '3', '1'),
('130628102', '130628', '西演镇', '1', '130628102', null, '3', '1'),
('130628200', '130628', '邢家南乡', '1', '130628200', null, '3', '1'),
('130628201', '130628', '晋庄乡', '1', '130628201', null, '3', '1'),
('130628202', '130628', '蒲口乡', '1', '130628202', null, '3', '1'),
('130628203', '130628', '小王果庄乡', '1', '130628203', null, '3', '1'),
('130628204', '130628', '龙化乡', '1', '130628204', null, '3', '1'),
('130628205', '130628', '庞家佐乡', '1', '130628205', null, '3', '1'),
('130629100', '130629', '容城镇', '1', '130629100', null, '3', '1'),
('130629101', '130629', '小里镇', '1', '130629101', null, '3', '1'),
('130629102', '130629', '南张镇', '1', '130629102', null, '3', '1'),
('130629103', '130629', '大河镇', '1', '130629103', null, '3', '1'),
('130629200', '130629', '八于乡', '1', '130629200', null, '3', '1'),
('130629201', '130629', '贾光乡', '1', '130629201', null, '3', '1'),
('130629202', '130629', '晾马台乡', '1', '130629202', null, '3', '1'),
('130629203', '130629', '平王乡', '1', '130629203', null, '3', '1'),
('130630100', '130630', '涞源镇', '1', '130630100', null, '3', '1'),
('130630101', '130630', '银坊镇', '1', '130630101', null, '3', '1'),
('130630102', '130630', '走马驿镇', '1', '130630102', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('130630103', '130630', '水堡镇', '1', '130630103', null, '3', '1'),
('130630104', '130630', '王安镇', '1', '130630104', null, '3', '1'),
('130630105', '130630', '杨家庄镇', '1', '130630105', null, '3', '1'),
('130630200', '130630', '下北头乡', '1', '130630200', null, '3', '1'),
('130630201', '130630', '南屯乡', '1', '130630201', null, '3', '1'),
('130630202', '130630', '马庄乡', '1', '130630202', null, '3', '1'),
('130630203', '130630', '北石佛乡', '1', '130630203', null, '3', '1'),
('130630204', '130630', '金家井乡', '1', '130630204', null, '3', '1'),
('130630205', '130630', '留家庄乡', '1', '130630205', null, '3', '1'),
('130630206', '130630', '上庄乡', '1', '130630206', null, '3', '1'),
('130630207', '130630', '东团堡乡', '1', '130630207', null, '3', '1'),
('130630208', '130630', '塔崖驿乡', '1', '130630208', null, '3', '1'),
('130630209', '130630', '乌龙沟乡', '1', '130630209', null, '3', '1'),
('130630210', '130630', '烟煤洞乡', '1', '130630210', null, '3', '1'),
('130631100', '130631', '望都镇', '1', '130631100', null, '3', '1'),
('130631101', '130631', '固店镇', '1', '130631101', null, '3', '1'),
('130631200', '130631', '寺庄乡', '1', '130631200', null, '3', '1'),
('130631201', '130631', '赵庄乡', '1', '130631201', null, '3', '1'),
('130631202', '130631', '黑堡乡', '1', '130631202', null, '3', '1'),
('130631204', '130631', '高岭乡', '1', '130631204', null, '3', '1'),
('130631205', '130631', '中韩庄乡', '1', '130631205', null, '3', '1'),
('130631206', '130631', '贾村乡', '1', '130631206', null, '3', '1'),
('130632100', '130632', '安新镇', '1', '130632100', null, '3', '1'),
('130632101', '130632', '大王镇', '1', '130632101', null, '3', '1'),
('130632102', '130632', '三台镇', '1', '130632102', null, '3', '1'),
('130632103', '130632', '端村镇', '1', '130632103', null, '3', '1'),
('130632104', '130632', '赵北口镇', '1', '130632104', null, '3', '1'),
('130632105', '130632', '同口镇', '1', '130632105', null, '3', '1'),
('130632106', '130632', '刘李庄镇', '1', '130632106', null, '3', '1'),
('130632107', '130632', '安州镇', '1', '130632107', null, '3', '1'),
('130632108', '130632', '老河头镇', '1', '130632108', null, '3', '1'),
('130632200', '130632', '圈头乡', '1', '130632200', null, '3', '1'),
('130632201', '130632', '寨里乡', '1', '130632201', null, '3', '1'),
('130632202', '130632', '芦庄乡', '1', '130632202', null, '3', '1'),
('130633100', '130633', '易州镇', '1', '130633100', null, '3', '1'),
('130633101', '130633', '梁格庄镇', '1', '130633101', null, '3', '1'),
('130633102', '130633', '西陵镇', '1', '130633102', null, '3', '1'),
('130633103', '130633', '裴山镇', '1', '130633103', null, '3', '1'),
('130633104', '130633', '塘湖镇', '1', '130633104', null, '3', '1'),
('130633105', '130633', '狼牙山镇', '1', '130633105', null, '3', '1'),
('130633106', '130633', '良岗镇', '1', '130633106', null, '3', '1'),
('130633107', '130633', '紫荆关镇', '1', '130633107', null, '3', '1'),
('130633200', '130633', '桥头乡', '1', '130633200', null, '3', '1'),
('130633201', '130633', '白马乡', '1', '130633201', null, '3', '1'),
('130633202', '130633', '流井乡', '1', '130633202', null, '3', '1'),
('130633203', '130633', '高村乡', '1', '130633203', null, '3', '1'),
('130633204', '130633', '高陌乡', '1', '130633204', null, '3', '1'),
('130633205', '130633', '大龙华乡', '1', '130633205', null, '3', '1'),
('130633206', '130633', '安格庄乡', '1', '130633206', null, '3', '1'),
('130633207', '130633', '凌云册乡', '1', '130633207', null, '3', '1'),
('130633208', '130633', '西山北乡', '1', '130633208', null, '3', '1'),
('130633209', '130633', '尉都乡', '1', '130633209', null, '3', '1'),
('130633210', '130633', '独乐乡', '1', '130633210', null, '3', '1'),
('130633211', '130633', '七峪乡', '1', '130633211', null, '3', '1'),
('130633212', '130633', '富岗乡', '1', '130633212', null, '3', '1'),
('130633213', '130633', '坡仓乡', '1', '130633213', null, '3', '1'),
('130633214', '130633', '牛岗乡', '1', '130633214', null, '3', '1'),
('130633215', '130633', '桥家河乡', '1', '130633215', null, '3', '1'),
('130633216', '130633', '甘河净乡', '1', '130633216', null, '3', '1'),
('130633217', '130633', '蔡家峪乡', '1', '130633217', null, '3', '1'),
('130633218', '130633', '南城司乡', '1', '130633218', null, '3', '1'),
('130634100', '130634', '恒州镇', '1', '130634100', null, '3', '1'),
('130634101', '130634', '灵山镇', '1', '130634101', null, '3', '1'),
('130634102', '130634', '燕赵镇', '1', '130634102', null, '3', '1'),
('130634103', '130634', '羊平镇', '1', '130634103', null, '3', '1'),
('130634200', '130634', '路庄子乡', '1', '130634200', null, '3', '1'),
('130634201', '130634', '下河乡', '1', '130634201', null, '3', '1'),
('130634202', '130634', '庄窠乡', '1', '130634202', null, '3', '1'),
('130634203', '130634', '孝墓乡', '1', '130634203', null, '3', '1'),
('130634204', '130634', '文德乡', '1', '130634204', null, '3', '1'),
('130634205', '130634', '东旺乡', '1', '130634205', null, '3', '1'),
('130634206', '130634', '晓林乡', '1', '130634206', null, '3', '1'),
('130634207', '130634', '邸村乡', '1', '130634207', null, '3', '1'),
('130634208', '130634', '产德乡', '1', '130634208', null, '3', '1'),
('130634209', '130634', '齐村乡', '1', '130634209', null, '3', '1'),
('130634210', '130634', '党城乡', '1', '130634210', null, '3', '1'),
('130634211', '130634', '郎家庄乡', '1', '130634211', null, '3', '1'),
('130634212', '130634', '范家庄乡', '1', '130634212', null, '3', '1'),
('130634213', '130634', '北台乡', '1', '130634213', null, '3', '1'),
('130635100', '130635', '蠡吾镇', '1', '130635100', null, '3', '1'),
('130635101', '130635', '留史镇', '1', '130635101', null, '3', '1'),
('130635102', '130635', '大百尺镇', '1', '130635102', null, '3', '1'),
('130635103', '130635', '辛兴镇', '1', '130635103', null, '3', '1'),
('130635104', '130635', '北郭丹镇', '1', '130635104', null, '3', '1'),
('130635105', '130635', '万安镇', '1', '130635105', null, '3', '1'),
('130635106', '130635', '桑园镇', '1', '130635106', null, '3', '1'),
('130635107', '130635', '南庄镇', '1', '130635107', null, '3', '1'),
('130635200', '130635', '小陈乡', '1', '130635200', null, '3', '1'),
('130635201', '130635', '林堡乡', '1', '130635201', null, '3', '1'),
('130635202', '130635', '北埝头乡', '1', '130635202', null, '3', '1'),
('130635203', '130635', '鲍墟乡', '1', '130635203', null, '3', '1'),
('130635204', '130635', '大曲堤乡', '1', '130635204', null, '3', '1'),
('130636100', '130636', '蒲阳镇', '1', '130636100', null, '3', '1'),
('130636101', '130636', '高于铺镇', '1', '130636101', null, '3', '1'),
('130636102', '130636', '腰山镇', '1', '130636102', null, '3', '1'),
('130636200', '130636', '蒲上乡', '1', '130636200', null, '3', '1'),
('130636201', '130636', '白云乡', '1', '130636201', null, '3', '1'),
('130636202', '130636', '河口乡', '1', '130636202', null, '3', '1'),
('130636203', '130636', '安阳乡', '1', '130636203', null, '3', '1'),
('130636204', '130636', '台鱼乡', '1', '130636204', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('130636205', '130636', '大悲乡', '1', '130636205', null, '3', '1'),
('130636206', '130636', '神南乡', '1', '130636206', null, '3', '1'),
('130637100', '130637', '博野镇', '1', '130637100', null, '3', '1'),
('130637101', '130637', '小店镇', '1', '130637101', null, '3', '1'),
('130637102', '130637', '程委镇', '1', '130637102', null, '3', '1'),
('130637200', '130637', '东墟乡', '1', '130637200', null, '3', '1'),
('130637201', '130637', '北杨村乡', '1', '130637201', null, '3', '1'),
('130637202', '130637', '城东乡', '1', '130637202', null, '3', '1'),
('130637203', '130637', '南小王乡', '1', '130637203', null, '3', '1'),
('130638100', '130638', '雄州镇', '1', '130638100', null, '3', '1'),
('130638101', '130638', '昝岗镇', '1', '130638101', null, '3', '1'),
('130638102', '130638', '大营镇', '1', '130638102', null, '3', '1'),
('130638103', '130638', '龙湾镇', '1', '130638103', null, '3', '1'),
('130638200', '130638', '北沙口乡', '1', '130638200', null, '3', '1'),
('130638201', '130638', '朱各庄乡', '1', '130638201', null, '3', '1'),
('130638202', '130638', '米家务乡', '1', '130638202', null, '3', '1'),
('130638203', '130638', '双堂乡', '1', '130638203', null, '3', '1'),
('130638204', '130638', '张岗乡', '1', '130638204', null, '3', '1'),
('130681001', '130681', '双塔街道', '1', '130681001', null, '3', '1'),
('130681002', '130681', '桃园街道', '1', '130681002', null, '3', '1'),
('130681003', '130681', '清凉寺街道', '1', '130681003', null, '3', '1'),
('130681100', '130681', '松林店镇', '1', '130681100', null, '3', '1'),
('130681101', '130681', '码头镇', '1', '130681101', null, '3', '1'),
('130681102', '130681', '东城坊镇', '1', '130681102', null, '3', '1'),
('130681103', '130681', '高官庄镇', '1', '130681103', null, '3', '1'),
('130681104', '130681', '东仙坡镇', '1', '130681104', null, '3', '1'),
('130681200', '130681', '百尺竿乡', '1', '130681200', null, '3', '1'),
('130681202', '130681', '义和庄乡', '1', '130681202', null, '3', '1'),
('130681203', '130681', '林家屯乡', '1', '130681203', null, '3', '1'),
('130681204', '130681', '孙庄乡', '1', '130681204', null, '3', '1'),
('130681205', '130681', '豆庄乡', '1', '130681205', null, '3', '1'),
('130681206', '130681', '刁窝乡', '1', '130681206', null, '3', '1'),
('130681400', '130681', '开发区管理委员会', '1', '130681400', null, '3', '1'),
('130682001', '130682', '南城区街道', '1', '130682001', null, '3', '1'),
('130682002', '130682', '北城区街道', '1', '130682002', null, '3', '1'),
('130682003', '130682', '西城区街道', '1', '130682003', null, '3', '1'),
('130682100', '130682', '留早镇', '1', '130682100', null, '3', '1'),
('130682101', '130682', '清风店镇', '1', '130682101', null, '3', '1'),
('130682102', '130682', '庞村镇', '1', '130682102', null, '3', '1'),
('130682103', '130682', '砖路镇', '1', '130682103', null, '3', '1'),
('130682104', '130682', '明月店镇', '1', '130682104', null, '3', '1'),
('130682105', '130682', '叮咛店镇', '1', '130682105', null, '3', '1'),
('130682106', '130682', '东亭镇', '1', '130682106', null, '3', '1'),
('130682107', '130682', '大辛庄镇', '1', '130682107', null, '3', '1'),
('130682108', '130682', '东旺镇', '1', '130682108', null, '3', '1'),
('130682109', '130682', '高蓬镇', '1', '130682109', null, '3', '1'),
('130682110', '130682', '邢邑镇', '1', '130682110', null, '3', '1'),
('130682111', '130682', '李亲顾镇', '1', '130682111', null, '3', '1'),
('130682112', '130682', '子位镇', '1', '130682112', null, '3', '1'),
('130682113', '130682', '开元镇', '1', '130682113', null, '3', '1'),
('130682200', '130682', '赵村乡', '1', '130682200', null, '3', '1'),
('130682202', '130682', '周村乡', '1', '130682202', null, '3', '1'),
('130682203', '130682', '东留春乡', '1', '130682203', null, '3', '1'),
('130682204', '130682', '号头庄回族乡', '1', '130682204', null, '3', '1'),
('130682205', '130682', '杨家庄乡', '1', '130682205', null, '3', '1'),
('130682206', '130682', '大鹿庄乡', '1', '130682206', null, '3', '1'),
('130682207', '130682', '息冢乡', '1', '130682207', null, '3', '1'),
('130682208', '130682', '西城乡', '1', '130682208', null, '3', '1'),
('130683001', '130683', '祁州药市街道', '1', '130683001', null, '3', '1'),
('130683100', '130683', '祁州镇', '1', '130683100', null, '3', '1'),
('130683101', '130683', '伍仁桥镇', '1', '130683101', null, '3', '1'),
('130683102', '130683', '石佛镇', '1', '130683102', null, '3', '1'),
('130683103', '130683', '郑章镇', '1', '130683103', null, '3', '1'),
('130683104', '130683', '大五女镇', '1', '130683104', null, '3', '1'),
('130683200', '130683', '明官店乡', '1', '130683200', null, '3', '1'),
('130683201', '130683', '南娄底乡', '1', '130683201', null, '3', '1'),
('130683202', '130683', '西安国城乡', '1', '130683202', null, '3', '1'),
('130683203', '130683', '西佛落乡', '1', '130683203', null, '3', '1'),
('130683204', '130683', '北段村乡', '1', '130683204', null, '3', '1'),
('130684001', '130684', '和平街道', '1', '130684001', null, '3', '1'),
('130684002', '130684', '军城街道', '1', '130684002', null, '3', '1'),
('130684003', '130684', '东盛街道', '1', '130684003', null, '3', '1'),
('130684004', '130684', '北城街道', '1', '130684004', null, '3', '1'),
('130684005', '130684', '兴华路街道', '1', '130684005', null, '3', '1'),
('130684100', '130684', '方官镇', '1', '130684100', null, '3', '1'),
('130684101', '130684', '新城镇', '1', '130684101', null, '3', '1'),
('130684102', '130684', '泗庄镇', '1', '130684102', null, '3', '1'),
('130684103', '130684', '白沟镇', '1', '130684103', null, '3', '1'),
('130684104', '130684', '辛立庄镇', '1', '130684104', null, '3', '1'),
('130684200', '130684', '肖官营乡', '1', '130684200', null, '3', '1'),
('130684201', '130684', '梁家营乡', '1', '130684201', null, '3', '1'),
('130684202', '130684', '张六庄乡', '1', '130684202', null, '3', '1'),
('130684203', '130684', '东马营乡', '1', '130684203', null, '3', '1'),
('130684204', '130684', '辛桥乡', '1', '130684204', null, '3', '1'),
('130702001', '130702', '红旗楼街道', '1', '130702001', null, '3', '1'),
('130702002', '130702', '胜利北路街道', '1', '130702002', null, '3', '1'),
('130702003', '130702', '五一路街道', '1', '130702003', null, '3', '1'),
('130702004', '130702', '花园街街道', '1', '130702004', null, '3', '1'),
('130702005', '130702', '工业路街道', '1', '130702005', null, '3', '1'),
('130702006', '130702', '南站街道', '1', '130702006', null, '3', '1'),
('130702007', '130702', '马路东街道', '1', '130702007', null, '3', '1'),
('130702100', '130702', '老鸦庄镇', '1', '130702100', null, '3', '1'),
('130702101', '130702', '姚家庄镇', '1', '130702101', null, '3', '1'),
('130703001', '130703', '新华街街道', '1', '130703001', null, '3', '1'),
('130703002', '130703', '大境门街道', '1', '130703002', null, '3', '1'),
('130703003', '130703', '明德北街街道', '1', '130703003', null, '3', '1'),
('130703004', '130703', '明德南街街道', '1', '130703004', null, '3', '1'),
('130703005', '130703', '堡子里街道', '1', '130703005', null, '3', '1'),
('130703006', '130703', '南营坊街道', '1', '130703006', null, '3', '1'),
('130703007', '130703', '工人新村街道', '1', '130703007', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('130703100', '130703', '东窑子镇', '1', '130703100', null, '3', '1'),
('130703101', '130703', '沈家屯镇', '1', '130703101', null, '3', '1'),
('130705001', '130705', '天泰寺街道', '1', '130705001', null, '3', '1'),
('130705002', '130705', '皇城街道', '1', '130705002', null, '3', '1'),
('130705003', '130705', '南关街道', '1', '130705003', null, '3', '1'),
('130705004', '130705', '南大街街道', '1', '130705004', null, '3', '1'),
('130705005', '130705', '大北街街道', '1', '130705005', null, '3', '1'),
('130705006', '130705', '工业街街道', '1', '130705006', null, '3', '1'),
('130705007', '130705', '建国街街道', '1', '130705007', null, '3', '1'),
('130705100', '130705', '庞家堡镇', '1', '130705100', null, '3', '1'),
('130705200', '130705', '河子西乡', '1', '130705200', null, '3', '1'),
('130705201', '130705', '春光乡', '1', '130705201', null, '3', '1'),
('130705202', '130705', '侯家庙乡', '1', '130705202', null, '3', '1'),
('130706001', '130706', '城镇街道', '1', '130706001', null, '3', '1'),
('130706002', '130706', '煤矿街道', '1', '130706002', null, '3', '1'),
('130706200', '130706', '花园乡', '1', '130706200', null, '3', '1'),
('130706201', '130706', '辛庄子乡', '1', '130706201', null, '3', '1'),
('130706202', '130706', '定方水乡', '1', '130706202', null, '3', '1'),
('130706203', '130706', '段家堡乡', '1', '130706203', null, '3', '1'),
('130721100', '130721', '洋河南镇', '1', '130721100', null, '3', '1'),
('130721101', '130721', '深井镇', '1', '130721101', null, '3', '1'),
('130721102', '130721', '崞村镇', '1', '130721102', null, '3', '1'),
('130721103', '130721', '沙岭子镇', '1', '130721103', null, '3', '1'),
('130721104', '130721', '姚家房镇', '1', '130721104', null, '3', '1'),
('130721105', '130721', '大仓盖镇', '1', '130721105', null, '3', '1'),
('130721106', '130721', '贾家营镇', '1', '130721106', null, '3', '1'),
('130721107', '130721', '顾家营镇', '1', '130721107', null, '3', '1'),
('130721108', '130721', '赵川镇', '1', '130721108', null, '3', '1'),
('130721200', '130721', '王家湾乡', '1', '130721200', null, '3', '1'),
('130721201', '130721', '塔儿村乡', '1', '130721201', null, '3', '1'),
('130721202', '130721', '江家屯乡', '1', '130721202', null, '3', '1'),
('130721203', '130721', '东望山乡', '1', '130721203', null, '3', '1'),
('130721204', '130721', '李家堡乡', '1', '130721204', null, '3', '1'),
('130722100', '130722', '张北镇', '1', '130722100', null, '3', '1'),
('130722101', '130722', '公会镇', '1', '130722101', null, '3', '1'),
('130722102', '130722', '二台镇', '1', '130722102', null, '3', '1'),
('130722103', '130722', '大囫囵镇', '1', '130722103', null, '3', '1'),
('130722200', '130722', '台路沟乡', '1', '130722200', null, '3', '1'),
('130722201', '130722', '油篓沟乡', '1', '130722201', null, '3', '1'),
('130722202', '130722', '馒头营乡', '1', '130722202', null, '3', '1'),
('130722203', '130722', '二泉井乡', '1', '130722203', null, '3', '1'),
('130722204', '130722', '单晶河乡', '1', '130722204', null, '3', '1'),
('130722205', '130722', '大河乡', '1', '130722205', null, '3', '1'),
('130722206', '130722', '海流图乡', '1', '130722206', null, '3', '1'),
('130722207', '130722', '两面井乡', '1', '130722207', null, '3', '1'),
('130722208', '130722', '大西湾乡', '1', '130722208', null, '3', '1'),
('130722209', '130722', '郝家营乡', '1', '130722209', null, '3', '1'),
('130722210', '130722', '白庙滩乡', '1', '130722210', null, '3', '1'),
('130722211', '130722', '小二台乡', '1', '130722211', null, '3', '1'),
('130722212', '130722', '战海乡', '1', '130722212', null, '3', '1'),
('130722213', '130722', '三号乡', '1', '130722213', null, '3', '1'),
('130722214', '130722', '沙沟乡', '1', '130722214', null, '3', '1'),
('130722215', '130722', '宇宙营乡', '1', '130722215', null, '3', '1'),
('130722500', '130722', '察北虚拟乡', '1', '130722500', null, '3', '1'),
('130723100', '130723', '康保镇', '1', '130723100', null, '3', '1'),
('130723101', '130723', '张纪镇', '1', '130723101', null, '3', '1'),
('130723102', '130723', '土城子镇', '1', '130723102', null, '3', '1'),
('130723103', '130723', '邓油坊镇', '1', '130723103', null, '3', '1'),
('130723104', '130723', '李家地镇', '1', '130723104', null, '3', '1'),
('130723105', '130723', '照阳河镇', '1', '130723105', null, '3', '1'),
('130723106', '130723', '屯垦镇', '1', '130723106', null, '3', '1'),
('130723200', '130723', '阎油房乡', '1', '130723200', null, '3', '1'),
('130723201', '130723', '丹清河乡', '1', '130723201', null, '3', '1'),
('130723202', '130723', '哈必嘎乡', '1', '130723202', null, '3', '1'),
('130723203', '130723', '二号卜乡', '1', '130723203', null, '3', '1'),
('130723204', '130723', '芦家营乡', '1', '130723204', null, '3', '1'),
('130723205', '130723', '忠义乡', '1', '130723205', null, '3', '1'),
('130723206', '130723', '处长地乡', '1', '130723206', null, '3', '1'),
('130723207', '130723', '满德堂乡', '1', '130723207', null, '3', '1'),
('130723500', '130723', '康保牧场虚拟乡', '1', '130723500', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('130724100', '130724', '平定堡镇', '1', '130724100', null, '3', '1'),
('130724101', '130724', '小厂镇', '1', '130724101', null, '3', '1'),
('130724102', '130724', '黄盖淖镇', '1', '130724102', null, '3', '1'),
('130724103', '130724', '九连城镇', '1', '130724103', null, '3', '1'),
('130724200', '130724', '高山堡乡', '1', '130724200', null, '3', '1'),
('130724201', '130724', '小河子乡', '1', '130724201', null, '3', '1'),
('130724202', '130724', '二道渠乡', '1', '130724202', null, '3', '1'),
('130724203', '130724', '大二号回族乡', '1', '130724203', null, '3', '1'),
('130724204', '130724', '闪电河乡', '1', '130724204', null, '3', '1'),
('130724205', '130724', '长梁乡', '1', '130724205', null, '3', '1'),
('130724206', '130724', '丰源店乡', '1', '130724206', null, '3', '1'),
('130724207', '130724', '西辛营乡', '1', '130724207', null, '3', '1'),
('130724208', '130724', '莲花滩乡', '1', '130724208', null, '3', '1'),
('130724209', '130724', '白土窑乡', '1', '130724209', null, '3', '1'),
('130724501', '130724', '榆树沟虚拟乡', '1', '130724501', null, '3', '1'),
('130724502', '130724', '沙埌子虚拟乡', '1', '130724502', null, '3', '1'),
('130724503', '130724', '小城子虚拟乡', '1', '130724503', null, '3', '1'),
('130724504', '130724', '东大门虚拟乡', '1', '130724504', null, '3', '1'),
('130725100', '130725', '南壕堑镇', '1', '130725100', null, '3', '1'),
('130725101', '130725', '大青沟镇', '1', '130725101', null, '3', '1'),
('130725102', '130725', '八道沟镇', '1', '130725102', null, '3', '1'),
('130725103', '130725', '红土梁镇', '1', '130725103', null, '3', '1'),
('130725104', '130725', '小蒜沟镇', '1', '130725104', null, '3', '1'),
('130725105', '130725', '三工地镇', '1', '130725105', null, '3', '1'),
('130725200', '130725', '大营盘乡', '1', '130725200', null, '3', '1'),
('130725201', '130725', '大苏计乡', '1', '130725201', null, '3', '1'),
('130725202', '130725', '石井乡', '1', '130725202', null, '3', '1'),
('130725204', '130725', '炕塄乡', '1', '130725204', null, '3', '1'),
('130725205', '130725', '七甲乡', '1', '130725205', null, '3', '1'),
('130725206', '130725', '套里庄乡', '1', '130725206', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('130725207', '130725', '甲石河乡', '1', '130725207', null, '3', '1'),
('130725208', '130725', '下马圈乡', '1', '130725208', null, '3', '1'),
('130726100', '130726', '蔚州镇', '1', '130726100', null, '3', '1'),
('130726101', '130726', '代王城镇', '1', '130726101', null, '3', '1'),
('130726102', '130726', '西合营镇', '1', '130726102', null, '3', '1'),
('130726103', '130726', '吉家庄镇', '1', '130726103', null, '3', '1'),
('130726104', '130726', '白乐镇', '1', '130726104', null, '3', '1'),
('130726105', '130726', '暖泉镇', '1', '130726105', null, '3', '1'),
('130726106', '130726', '南留庄镇', '1', '130726106', null, '3', '1'),
('130726107', '130726', '北水泉镇', '1', '130726107', null, '3', '1'),
('130726108', '130726', '桃花镇', '1', '130726108', null, '3', '1'),
('130726109', '130726', '阳眷镇', '1', '130726109', null, '3', '1'),
('130726110', '130726', '宋家庄镇', '1', '130726110', null, '3', '1'),
('130726200', '130726', '下宫村乡', '1', '130726200', null, '3', '1'),
('130726202', '130726', '南杨庄乡', '1', '130726202', null, '3', '1'),
('130726203', '130726', '柏树乡', '1', '130726203', null, '3', '1'),
('130726204', '130726', '常宁乡', '1', '130726204', null, '3', '1'),
('130726205', '130726', '涌泉庄乡', '1', '130726205', null, '3', '1'),
('130726206', '130726', '杨庄窠乡', '1', '130726206', null, '3', '1'),
('130726207', '130726', '南岭庄乡', '1', '130726207', null, '3', '1'),
('130726208', '130726', '陈家洼乡', '1', '130726208', null, '3', '1'),
('130726209', '130726', '黄梅乡', '1', '130726209', null, '3', '1'),
('130726210', '130726', '白草村乡', '1', '130726210', null, '3', '1'),
('130726211', '130726', '草沟堡乡', '1', '130726211', null, '3', '1'),
('130727100', '130727', '西城镇', '1', '130727100', null, '3', '1'),
('130727101', '130727', '东城镇', '1', '130727101', null, '3', '1'),
('130727102', '130727', '化稍营镇', '1', '130727102', null, '3', '1'),
('130727103', '130727', '揣骨疃镇', '1', '130727103', null, '3', '1'),
('130727104', '130727', '东井集镇', '1', '130727104', null, '3', '1'),
('130727200', '130727', '要家庄乡', '1', '130727200', null, '3', '1'),
('130727201', '130727', '东坊城堡乡', '1', '130727201', null, '3', '1'),
('130727202', '130727', '井儿沟乡', '1', '130727202', null, '3', '1'),
('130727203', '130727', '三马坊乡', '1', '130727203', null, '3', '1'),
('130727204', '130727', '高墙乡', '1', '130727204', null, '3', '1'),
('130727205', '130727', '大田洼乡', '1', '130727205', null, '3', '1'),
('130727206', '130727', '辛堡乡', '1', '130727206', null, '3', '1'),
('130727207', '130727', '马圈堡乡', '1', '130727207', null, '3', '1'),
('130727208', '130727', '浮图讲乡', '1', '130727208', null, '3', '1'),
('130728100', '130728', '柴沟堡镇', '1', '130728100', null, '3', '1'),
('130728101', '130728', '左卫镇', '1', '130728101', null, '3', '1'),
('130728102', '130728', '头百户镇', '1', '130728102', null, '3', '1'),
('130728103', '130728', '怀安城镇', '1', '130728103', null, '3', '1'),
('130728200', '130728', '渡口堡乡', '1', '130728200', null, '3', '1'),
('130728201', '130728', '第六屯乡', '1', '130728201', null, '3', '1'),
('130728202', '130728', '西湾堡乡', '1', '130728202', null, '3', '1'),
('130728203', '130728', '西沙城乡', '1', '130728203', null, '3', '1'),
('130728204', '130728', '太平庄乡', '1', '130728204', null, '3', '1'),
('130728205', '130728', '王虎屯乡', '1', '130728205', null, '3', '1'),
('130728206', '130728', '第三堡乡', '1', '130728206', null, '3', '1'),
('130729100', '130729', '孔家庄镇', '1', '130729100', null, '3', '1'),
('130729101', '130729', '万全镇', '1', '130729101', null, '3', '1'),
('130729102', '130729', '洗马林镇', '1', '130729102', null, '3', '1'),
('130729103', '130729', '郭磊庄镇', '1', '130729103', null, '3', '1'),
('130729200', '130729', '膳房堡乡', '1', '130729200', null, '3', '1'),
('130729201', '130729', '北新屯乡', '1', '130729201', null, '3', '1'),
('130729202', '130729', '宣平堡乡', '1', '130729202', null, '3', '1'),
('130729203', '130729', '高庙堡乡', '1', '130729203', null, '3', '1'),
('130729204', '130729', '旧堡乡', '1', '130729204', null, '3', '1'),
('130729205', '130729', '安家堡乡', '1', '130729205', null, '3', '1'),
('130729206', '130729', '北沙城乡', '1', '130729206', null, '3', '1'),
('130730100', '130730', '沙城镇', '1', '130730100', null, '3', '1'),
('130730101', '130730', '北辛堡镇', '1', '130730101', null, '3', '1'),
('130730102', '130730', '新保安镇', '1', '130730102', null, '3', '1'),
('130730103', '130730', '东花园镇', '1', '130730103', null, '3', '1'),
('130730104', '130730', '官厅镇', '1', '130730104', null, '3', '1'),
('130730105', '130730', '桑园镇', '1', '130730105', null, '3', '1'),
('130730106', '130730', '存瑞镇', '1', '130730106', null, '3', '1'),
('130730107', '130730', '土木镇', '1', '130730107', null, '3', '1'),
('130730108', '130730', '大黄庄镇', '1', '130730108', null, '3', '1'),
('130730109', '130730', '西八里镇', '1', '130730109', null, '3', '1'),
('130730110', '130730', '小南辛堡镇', '1', '130730110', null, '3', '1'),
('130730200', '130730', '狼山乡', '1', '130730200', null, '3', '1'),
('130730203', '130730', '鸡鸣驿乡', '1', '130730203', null, '3', '1'),
('130730205', '130730', '东八里乡', '1', '130730205', null, '3', '1'),
('130730207', '130730', '瑞云观乡', '1', '130730207', null, '3', '1'),
('130730208', '130730', '孙庄子乡', '1', '130730208', null, '3', '1'),
('130730210', '130730', '王家楼回族乡', '1', '130730210', null, '3', '1'),
('130731100', '130731', '涿鹿镇', '1', '130731100', null, '3', '1'),
('130731101', '130731', '张家堡镇', '1', '130731101', null, '3', '1'),
('130731102', '130731', '武家沟镇', '1', '130731102', null, '3', '1'),
('130731103', '130731', '五堡镇', '1', '130731103', null, '3', '1'),
('130731104', '130731', '保岱镇', '1', '130731104', null, '3', '1'),
('130731105', '130731', '矾山镇', '1', '130731105', null, '3', '1'),
('130731106', '130731', '大堡镇', '1', '130731106', null, '3', '1'),
('130731107', '130731', '河东镇', '1', '130731107', null, '3', '1'),
('130731200', '130731', '东小庄乡', '1', '130731200', null, '3', '1'),
('130731201', '130731', '栾庄乡', '1', '130731201', null, '3', '1'),
('130731202', '130731', '温泉屯乡', '1', '130731202', null, '3', '1'),
('130731203', '130731', '辉耀乡', '1', '130731203', null, '3', '1'),
('130731204', '130731', '黑山寺乡', '1', '130731204', null, '3', '1'),
('130731205', '130731', '卧佛寺乡', '1', '130731205', null, '3', '1'),
('130731206', '130731', '谢家堡乡', '1', '130731206', null, '3', '1'),
('130731207', '130731', '大河南乡', '1', '130731207', null, '3', '1'),
('130731208', '130731', '蟒石口乡', '1', '130731208', null, '3', '1'),
('130732100', '130732', '赤城镇', '1', '130732100', null, '3', '1'),
('130732101', '130732', '田家窑镇', '1', '130732101', null, '3', '1'),
('130732102', '130732', '龙关镇', '1', '130732102', null, '3', '1'),
('130732103', '130732', '雕鄂镇', '1', '130732103', null, '3', '1'),
('130732104', '130732', '独石口镇', '1', '130732104', null, '3', '1'),
('130732105', '130732', '白草镇', '1', '130732105', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('130732106', '130732', '龙门所镇', '1', '130732106', null, '3', '1'),
('130732107', '130732', '后城镇', '1', '130732107', null, '3', '1'),
('130732108', '130732', '东卯镇', '1', '130732108', null, '3', '1'),
('130732200', '130732', '炮梁乡', '1', '130732200', null, '3', '1'),
('130732201', '130732', '大海陀乡', '1', '130732201', null, '3', '1'),
('130732202', '130732', '镇宁堡乡', '1', '130732202', null, '3', '1'),
('130732203', '130732', '马营乡', '1', '130732203', null, '3', '1'),
('130732204', '130732', '云州乡', '1', '130732204', null, '3', '1'),
('130732205', '130732', '三道川乡', '1', '130732205', null, '3', '1'),
('130732206', '130732', '东万口乡', '1', '130732206', null, '3', '1'),
('130732207', '130732', '茨营子乡', '1', '130732207', null, '3', '1'),
('130732208', '130732', '样田乡', '1', '130732208', null, '3', '1'),
('130733001', '130733', '西湾子街道办', '1', '130733001', null, '3', '1'),
('130733100', '130733', '西湾子镇', '1', '130733100', null, '3', '1'),
('130733101', '130733', '高家营镇', '1', '130733101', null, '3', '1'),
('130733200', '130733', '四台嘴乡', '1', '130733200', null, '3', '1'),
('130733201', '130733', '红旗营乡', '1', '130733201', null, '3', '1'),
('130733202', '130733', '石窑子乡', '1', '130733202', null, '3', '1'),
('130733203', '130733', '驿马图乡', '1', '130733203', null, '3', '1'),
('130733204', '130733', '石嘴子乡', '1', '130733204', null, '3', '1'),
('130733205', '130733', '狮子沟乡', '1', '130733205', null, '3', '1'),
('130733206', '130733', '清三营乡', '1', '130733206', null, '3', '1'),
('130733207', '130733', '白旗乡', '1', '130733207', null, '3', '1'),
('130802001', '130802', '西大街街道', '1', '130802001', null, '3', '1'),
('130802002', '130802', '头道牌楼街道', '1', '130802002', null, '3', '1'),
('130802003', '130802', '潘家沟街道', '1', '130802003', null, '3', '1'),
('130802004', '130802', '中华路街道', '1', '130802004', null, '3', '1'),
('130802005', '130802', '新华路街道', '1', '130802005', null, '3', '1'),
('130802006', '130802', '石洞子沟街道', '1', '130802006', null, '3', '1'),
('130802007', '130802', '桥东街道', '1', '130802007', null, '3', '1'),
('130802100', '130802', '水泉沟镇', '1', '130802100', null, '3', '1'),
('130802101', '130802', '狮子沟镇', '1', '130802101', null, '3', '1'),
('130802102', '130802', '牛圈子沟镇', '1', '130802102', null, '3', '1'),
('130802103', '130802', '大石庙镇', '1', '130802103', null, '3', '1'),
('130802104', '130802', '冯营子镇', '1', '130802104', null, '3', '1'),
('130803001', '130803', '双塔山街道', '1', '130803001', null, '3', '1'),
('130803002', '130803', '滦河街道', '1', '130803002', null, '3', '1'),
('130803100', '130803', '双塔山镇', '1', '130803100', null, '3', '1'),
('130803101', '130803', '滦河镇', '1', '130803101', null, '3', '1'),
('130803102', '130803', '大庙镇', '1', '130803102', null, '3', '1'),
('130803103', '130803', '偏桥子镇', '1', '130803103', null, '3', '1'),
('130804100', '130804', '鹰手营子镇', '1', '130804100', null, '3', '1'),
('130804101', '130804', '北马圈子镇', '1', '130804101', null, '3', '1'),
('130804102', '130804', '寿王坟镇', '1', '130804102', null, '3', '1'),
('130804103', '130804', '汪家庄镇', '1', '130804103', null, '3', '1'),
('130821100', '130821', '下板城镇', '1', '130821100', null, '3', '1'),
('130821101', '130821', '上板城镇', '1', '130821101', null, '3', '1'),
('130821102', '130821', '甲山镇', '1', '130821102', null, '3', '1'),
('130821103', '130821', '六沟镇', '1', '130821103', null, '3', '1'),
('130821104', '130821', '三沟镇', '1', '130821104', null, '3', '1'),
('130821105', '130821', '头沟镇', '1', '130821105', null, '3', '1'),
('130821106', '130821', '高寺台镇', '1', '130821106', null, '3', '1'),
('130821107', '130821', '双峰寺镇', '1', '130821107', null, '3', '1'),
('130821200', '130821', '东小白旗乡', '1', '130821200', null, '3', '1'),
('130821201', '130821', '鞍匠乡', '1', '130821201', null, '3', '1'),
('130821202', '130821', '刘杖子乡', '1', '130821202', null, '3', '1'),
('130821203', '130821', '新杖子乡', '1', '130821203', null, '3', '1'),
('130821204', '130821', '孟家院乡', '1', '130821204', null, '3', '1'),
('130821205', '130821', '大营子乡', '1', '130821205', null, '3', '1'),
('130821206', '130821', '八家乡', '1', '130821206', null, '3', '1'),
('130821207', '130821', '上谷乡', '1', '130821207', null, '3', '1'),
('130821208', '130821', '满杖子乡', '1', '130821208', null, '3', '1'),
('130821209', '130821', '石灰窑乡', '1', '130821209', null, '3', '1'),
('130821210', '130821', '五道河乡', '1', '130821210', null, '3', '1'),
('130821211', '130821', '岔沟乡', '1', '130821211', null, '3', '1'),
('130821212', '130821', '岗子满族乡', '1', '130821212', null, '3', '1'),
('130821213', '130821', '磴上乡', '1', '130821213', null, '3', '1'),
('130821214', '130821', '两家满族乡', '1', '130821214', null, '3', '1'),
('130821215', '130821', '三家乡', '1', '130821215', null, '3', '1'),
('130821216', '130821', '仓子乡', '1', '130821216', null, '3', '1'),
('130822100', '130822', '兴隆镇', '1', '130822100', null, '3', '1'),
('130822101', '130822', '半壁山镇', '1', '130822101', null, '3', '1'),
('130822102', '130822', '挂兰峪镇', '1', '130822102', null, '3', '1'),
('130822103', '130822', '青松岭镇', '1', '130822103', null, '3', '1'),
('130822104', '130822', '六道河镇', '1', '130822104', null, '3', '1'),
('130822105', '130822', '平安堡镇', '1', '130822105', null, '3', '1'),
('130822106', '130822', '北营房镇', '1', '130822106', null, '3', '1'),
('130822200', '130822', '南天门满族乡', '1', '130822200', null, '3', '1'),
('130822201', '130822', '孤山子乡', '1', '130822201', null, '3', '1'),
('130822202', '130822', '八卦岭满族乡', '1', '130822202', null, '3', '1'),
('130822203', '130822', '陡子峪乡', '1', '130822203', null, '3', '1'),
('130822204', '130822', '上石洞乡', '1', '130822204', null, '3', '1'),
('130822205', '130822', '北水泉乡', '1', '130822205', null, '3', '1'),
('130822206', '130822', '李家营乡', '1', '130822206', null, '3', '1'),
('130822207', '130822', '大杖子乡', '1', '130822207', null, '3', '1'),
('130822208', '130822', '蘑菇峪乡', '1', '130822208', null, '3', '1'),
('130822209', '130822', '三道河乡', '1', '130822209', null, '3', '1'),
('130822210', '130822', '蓝旗营乡', '1', '130822210', null, '3', '1'),
('130822211', '130822', '安子岭乡', '1', '130822211', null, '3', '1'),
('130822212', '130822', '大水泉乡', '1', '130822212', null, '3', '1'),
('130823100', '130823', '平泉镇', '1', '130823100', null, '3', '1'),
('130823101', '130823', '黄土梁子镇', '1', '130823101', null, '3', '1'),
('130823102', '130823', '榆树林子镇', '1', '130823102', null, '3', '1'),
('130823103', '130823', '杨树岭镇', '1', '130823103', null, '3', '1'),
('130823104', '130823', '七沟镇', '1', '130823104', null, '3', '1'),
('130823105', '130823', '小寺沟镇', '1', '130823105', null, '3', '1'),
('130823106', '130823', '党坝镇', '1', '130823106', null, '3', '1'),
('130823107', '130823', '卧龙镇', '1', '130823107', null, '3', '1'),
('130823108', '130823', '南五十家子镇', '1', '130823108', null, '3', '1'),
('130823200', '130823', '王土房乡', '1', '130823200', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('130823202', '130823', '柳溪满族乡', '1', '130823202', null, '3', '1'),
('130823203', '130823', '七家岱满族乡', '1', '130823203', null, '3', '1'),
('130823204', '130823', '平房满族蒙古族乡', '1', '130823204', null, '3', '1'),
('130823205', '130823', '蒙和乌苏蒙古族乡', '1', '130823205', null, '3', '1'),
('130823206', '130823', '茅兰沟满族蒙古族乡', '1', '130823206', null, '3', '1'),
('130823207', '130823', '台头山乡', '1', '130823207', null, '3', '1'),
('130823209', '130823', '松树台乡', '1', '130823209', null, '3', '1'),
('130823210', '130823', '道虎沟乡', '1', '130823210', null, '3', '1'),
('130823212', '130823', '郭杖子满族乡', '1', '130823212', null, '3', '1'),
('130824100', '130824', '滦平镇', '1', '130824100', null, '3', '1'),
('130824101', '130824', '长山峪镇', '1', '130824101', null, '3', '1'),
('130824102', '130824', '红旗镇', '1', '130824102', null, '3', '1'),
('130824103', '130824', '金沟屯镇', '1', '130824103', null, '3', '1'),
('130824104', '130824', '虎什哈镇', '1', '130824104', null, '3', '1'),
('130824105', '130824', '巴克什营镇', '1', '130824105', null, '3', '1'),
('130824106', '130824', '张百湾镇', '1', '130824106', null, '3', '1'),
('130824200', '130824', '平坊满族乡', '1', '130824200', null, '3', '1'),
('130824201', '130824', '安纯沟门满族乡', '1', '130824201', null, '3', '1'),
('130824202', '130824', '西地满族乡', '1', '130824202', null, '3', '1'),
('130824203', '130824', '陈栅子乡', '1', '130824203', null, '3', '1'),
('130824204', '130824', '付营子乡', '1', '130824204', null, '3', '1'),
('130824205', '130824', '小营满族乡', '1', '130824205', null, '3', '1'),
('130824206', '130824', '西沟满族乡', '1', '130824206', null, '3', '1'),
('130824207', '130824', '邓厂满族乡', '1', '130824207', null, '3', '1'),
('130824208', '130824', '五道营子满族乡', '1', '130824208', null, '3', '1'),
('130824209', '130824', '马营子满族乡', '1', '130824209', null, '3', '1'),
('130824210', '130824', '付家店满族乡', '1', '130824210', null, '3', '1'),
('130824211', '130824', '火斗山乡', '1', '130824211', null, '3', '1'),
('130824212', '130824', '两间房乡', '1', '130824212', null, '3', '1'),
('130824213', '130824', '涝洼乡', '1', '130824213', null, '3', '1'),
('130824214', '130824', '大屯满族乡', '1', '130824214', null, '3', '1'),
('130825100', '130825', '隆化镇', '1', '130825100', null, '3', '1'),
('130825101', '130825', '韩麻营镇', '1', '130825101', null, '3', '1'),
('130825102', '130825', '中关镇', '1', '130825102', null, '3', '1'),
('130825103', '130825', '七家镇', '1', '130825103', null, '3', '1'),
('130825104', '130825', '汤头沟镇', '1', '130825104', null, '3', '1'),
('130825105', '130825', '张三营镇', '1', '130825105', null, '3', '1'),
('130825106', '130825', '唐三营镇', '1', '130825106', null, '3', '1'),
('130825107', '130825', '蓝旗镇', '1', '130825107', null, '3', '1'),
('130825108', '130825', '步古沟镇', '1', '130825108', null, '3', '1'),
('130825109', '130825', '郭家屯镇', '1', '130825109', null, '3', '1'),
('130825200', '130825', '荒地乡', '1', '130825200', null, '3', '1'),
('130825201', '130825', '章吉营乡', '1', '130825201', null, '3', '1'),
('130825202', '130825', '茅荆坝乡', '1', '130825202', null, '3', '1'),
('130825203', '130825', '尹家营满族乡', '1', '130825203', null, '3', '1'),
('130825204', '130825', '庙子沟蒙古族满族乡', '1', '130825204', null, '3', '1'),
('130825205', '130825', '偏坡营满族乡', '1', '130825205', null, '3', '1'),
('130825206', '130825', '山湾乡', '1', '130825206', null, '3', '1'),
('130825207', '130825', '八达营蒙古族乡', '1', '130825207', null, '3', '1'),
('130825208', '130825', '太平庄满族乡', '1', '130825208', null, '3', '1'),
('130825209', '130825', '旧屯满族乡', '1', '130825209', null, '3', '1'),
('130825210', '130825', '西阿超满族蒙古族乡', '1', '130825210', null, '3', '1'),
('130825211', '130825', '白虎沟满族蒙古族乡', '1', '130825211', null, '3', '1'),
('130825212', '130825', '碱房乡', '1', '130825212', null, '3', '1'),
('130825213', '130825', '韩家店乡', '1', '130825213', null, '3', '1'),
('130825214', '130825', '湾沟门乡', '1', '130825214', null, '3', '1'),
('130826100', '130826', '大阁镇', '1', '130826100', null, '3', '1'),
('130826101', '130826', '大滩镇', '1', '130826101', null, '3', '1'),
('130826102', '130826', '鱼儿山镇', '1', '130826102', null, '3', '1'),
('130826103', '130826', '土城镇', '1', '130826103', null, '3', '1'),
('130826104', '130826', '黄旗镇', '1', '130826104', null, '3', '1'),
('130826105', '130826', '凤山镇', '1', '130826105', null, '3', '1'),
('130826106', '130826', '波罗诺镇', '1', '130826106', null, '3', '1'),
('130826107', '130826', '黑山咀镇', '1', '130826107', null, '3', '1'),
('130826108', '130826', '天桥镇', '1', '130826108', null, '3', '1'),
('130826200', '130826', '万胜永乡', '1', '130826200', null, '3', '1'),
('130826201', '130826', '四岔口乡', '1', '130826201', null, '3', '1'),
('130826202', '130826', '苏家店乡', '1', '130826202', null, '3', '1'),
('130826203', '130826', '外沟门乡', '1', '130826203', null, '3', '1'),
('130826204', '130826', '草原乡', '1', '130826204', null, '3', '1'),
('130826205', '130826', '窟窿山乡', '1', '130826205', null, '3', '1'),
('130826206', '130826', '小坝子乡', '1', '130826206', null, '3', '1'),
('130826207', '130826', '五道营乡', '1', '130826207', null, '3', '1'),
('130826208', '130826', '南关蒙古族乡', '1', '130826208', null, '3', '1'),
('130826209', '130826', '选将营乡', '1', '130826209', null, '3', '1'),
('130826210', '130826', '西官营乡', '1', '130826210', null, '3', '1'),
('130826211', '130826', '王营乡', '1', '130826211', null, '3', '1'),
('130826212', '130826', '北头营乡', '1', '130826212', null, '3', '1'),
('130826213', '130826', '胡麻营乡', '1', '130826213', null, '3', '1'),
('130826214', '130826', '石人沟乡', '1', '130826214', null, '3', '1'),
('130826215', '130826', '汤河乡', '1', '130826215', null, '3', '1'),
('130826216', '130826', '杨木栅子乡', '1', '130826216', null, '3', '1'),
('130827100', '130827', '宽城镇', '1', '130827100', null, '3', '1'),
('130827101', '130827', '龙须门镇', '1', '130827101', null, '3', '1'),
('130827102', '130827', '峪耳崖镇', '1', '130827102', null, '3', '1'),
('130827103', '130827', '板城镇', '1', '130827103', null, '3', '1'),
('130827104', '130827', '汤道河镇', '1', '130827104', null, '3', '1'),
('130827200', '130827', '化皮溜子乡', '1', '130827200', null, '3', '1'),
('130827201', '130827', '塌山乡', '1', '130827201', null, '3', '1'),
('130827202', '130827', '饽罗台乡', '1', '130827202', null, '3', '1'),
('130827203', '130827', '孟子岭乡', '1', '130827203', null, '3', '1'),
('130827204', '130827', '独石沟乡', '1', '130827204', null, '3', '1'),
('130827205', '130827', '碾子峪乡', '1', '130827205', null, '3', '1'),
('130827206', '130827', '东大地乡', '1', '130827206', null, '3', '1'),
('130827207', '130827', '铧尖乡', '1', '130827207', null, '3', '1'),
('130827208', '130827', '东黄花川乡', '1', '130827208', null, '3', '1'),
('130827209', '130827', '亮甲台乡', '1', '130827209', null, '3', '1'),
('130827210', '130827', '苇子沟乡', '1', '130827210', null, '3', '1'),
('130827211', '130827', '大字沟门乡', '1', '130827211', null, '3', '1'),
('130827212', '130827', '大石柱子乡', '1', '130827212', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('130828100', '130828', '围场镇', '1', '130828100', null, '3', '1'),
('130828101', '130828', '四合永镇', '1', '130828101', null, '3', '1'),
('130828102', '130828', '克勒沟镇', '1', '130828102', null, '3', '1'),
('130828103', '130828', '棋盘山镇', '1', '130828103', null, '3', '1'),
('130828104', '130828', '半截塔镇', '1', '130828104', null, '3', '1'),
('130828105', '130828', '朝阳地镇', '1', '130828105', null, '3', '1'),
('130828106', '130828', '朝阳湾镇', '1', '130828106', null, '3', '1'),
('130828200', '130828', '道坝子乡', '1', '130828200', null, '3', '1'),
('130828201', '130828', '龙头山乡', '1', '130828201', null, '3', '1'),
('130828202', '130828', '腰站乡', '1', '130828202', null, '3', '1'),
('130828203', '130828', '黄土坎乡', '1', '130828203', null, '3', '1'),
('130828204', '130828', '四道沟乡', '1', '130828204', null, '3', '1'),
('130828205', '130828', '兰旗卡伦乡', '1', '130828205', null, '3', '1'),
('130828206', '130828', '银窝沟乡', '1', '130828206', null, '3', '1'),
('130828207', '130828', '新地乡', '1', '130828207', null, '3', '1'),
('130828208', '130828', '广发永乡', '1', '130828208', null, '3', '1'),
('130828209', '130828', '育太和乡', '1', '130828209', null, '3', '1'),
('130828210', '130828', '郭家湾乡', '1', '130828210', null, '3', '1'),
('130828211', '130828', '杨家湾乡', '1', '130828211', null, '3', '1'),
('130828212', '130828', '大唤起乡', '1', '130828212', null, '3', '1'),
('130828213', '130828', '哈里哈乡', '1', '130828213', null, '3', '1'),
('130828214', '130828', '新拨乡', '1', '130828214', null, '3', '1'),
('130828215', '130828', '张家湾乡', '1', '130828215', null, '3', '1'),
('130828216', '130828', '宝元栈乡', '1', '130828216', null, '3', '1'),
('130828217', '130828', '山湾子乡', '1', '130828217', null, '3', '1'),
('130828218', '130828', '三义永乡', '1', '130828218', null, '3', '1'),
('130828219', '130828', '姜家店乡', '1', '130828219', null, '3', '1'),
('130828220', '130828', '下伙房乡', '1', '130828220', null, '3', '1'),
('130828221', '130828', '燕格柏乡', '1', '130828221', null, '3', '1'),
('130828222', '130828', '牌楼乡', '1', '130828222', null, '3', '1'),
('130828223', '130828', '城子乡', '1', '130828223', null, '3', '1'),
('130828224', '130828', '老窝铺乡', '1', '130828224', null, '3', '1'),
('130828225', '130828', '御道口乡', '1', '130828225', null, '3', '1'),
('130828226', '130828', '石桌子乡', '1', '130828226', null, '3', '1'),
('130828227', '130828', '大头山乡', '1', '130828227', null, '3', '1'),
('130828228', '130828', '南山嘴乡', '1', '130828228', null, '3', '1'),
('130828229', '130828', '西龙头乡', '1', '130828229', null, '3', '1'),
('130828450', '130828', '塞罕坝机械林场虚拟镇', '1', '130828450', null, '3', '1'),
('130828500', '130828', '国营御道口牧场虚拟乡', '1', '130828500', null, '3', '1'),
('130902001', '130902', '建设北街街道', '1', '130902001', null, '3', '1'),
('130902002', '130902', '车站街道', '1', '130902002', null, '3', '1'),
('130902003', '130902', '南大街街道', '1', '130902003', null, '3', '1'),
('130902004', '130902', '东环街道', '1', '130902004', null, '3', '1'),
('130902005', '130902', '道东街道', '1', '130902005', null, '3', '1'),
('130902200', '130902', '小赵庄乡', '1', '130902200', null, '3', '1'),
('130902400', '130902', '沧州开发区', '1', '130902400', null, '3', '1'),
('130903001', '130903', '水月寺街道', '1', '130903001', null, '3', '1'),
('130903002', '130903', '南环中路街道', '1', '130903002', null, '3', '1'),
('130903003', '130903', '南湖街道', '1', '130903003', null, '3', '1'),
('130903004', '130903', '市场街道', '1', '130903004', null, '3', '1'),
('130903005', '130903', '西环中街街道', '1', '130903005', null, '3', '1'),
('130903006', '130903', '公园街道', '1', '130903006', null, '3', '1'),
('130903100', '130903', '小王庄镇', '1', '130903100', null, '3', '1'),
('130903200', '130903', '南陈屯乡', '1', '130903200', null, '3', '1'),
('130921100', '130921', '旧州镇', '1', '130921100', null, '3', '1'),
('130921101', '130921', '兴济镇', '1', '130921101', null, '3', '1'),
('130921102', '130921', '杜生镇', '1', '130921102', null, '3', '1'),
('130921103', '130921', '崔尔庄镇', '1', '130921103', null, '3', '1'),
('130921200', '130921', '薛官屯乡', '1', '130921200', null, '3', '1'),
('130921201', '130921', '捷地回族乡', '1', '130921201', null, '3', '1'),
('130921202', '130921', '张官屯乡', '1', '130921202', null, '3', '1'),
('130921203', '130921', '李天木回族乡', '1', '130921203', null, '3', '1'),
('130921204', '130921', '风化店乡', '1', '130921204', null, '3', '1'),
('130921205', '130921', '姚官屯乡', '1', '130921205', null, '3', '1'),
('130921206', '130921', '杜林回族乡', '1', '130921206', null, '3', '1'),
('130921207', '130921', '汪家铺乡', '1', '130921207', null, '3', '1'),
('130921208', '130921', '刘家庙乡', '1', '130921208', null, '3', '1'),
('130921209', '130921', '仵龙堂乡', '1', '130921209', null, '3', '1'),
('130921210', '130921', '大官厅乡', '1', '130921210', null, '3', '1'),
('130921211', '130921', '高川乡', '1', '130921211', null, '3', '1'),
('130921212', '130921', '黄递铺乡', '1', '130921212', null, '3', '1'),
('130921213', '130921', '大褚村回族乡', '1', '130921213', null, '3', '1'),
('130921214', '130921', '纸房头乡', '1', '130921214', null, '3', '1'),
('130922100', '130922', '清州镇', '1', '130922100', null, '3', '1'),
('130922101', '130922', '金牛镇', '1', '130922101', null, '3', '1'),
('130922102', '130922', '新兴镇', '1', '130922102', null, '3', '1'),
('130922103', '130922', '流河镇', '1', '130922103', null, '3', '1'),
('130922104', '130922', '木门店镇', '1', '130922104', null, '3', '1'),
('130922105', '130922', '马厂镇', '1', '130922105', null, '3', '1'),
('130922200', '130922', '上伍乡', '1', '130922200', null, '3', '1'),
('130922201', '130922', '曹寺乡', '1', '130922201', null, '3', '1'),
('130922202', '130922', '盘古乡', '1', '130922202', null, '3', '1'),
('130922203', '130922', '陈嘴乡', '1', '130922203', null, '3', '1'),
('130922400', '130922', '农场虚拟乡', '1', '130922400', null, '3', '1'),
('130923100', '130923', '东光镇', '1', '130923100', null, '3', '1'),
('130923101', '130923', '连镇镇', '1', '130923101', null, '3', '1'),
('130923102', '130923', '找王镇', '1', '130923102', null, '3', '1'),
('130923103', '130923', '秦村镇', '1', '130923103', null, '3', '1'),
('130923104', '130923', '灯明寺镇', '1', '130923104', null, '3', '1'),
('130923105', '130923', '南霞口镇', '1', '130923105', null, '3', '1'),
('130923106', '130923', '大单镇', '1', '130923106', null, '3', '1'),
('130923200', '130923', '龙王李乡', '1', '130923200', null, '3', '1'),
('130923201', '130923', '于桥乡', '1', '130923201', null, '3', '1'),
('130924100', '130924', '苏基镇', '1', '130924100', null, '3', '1'),
('130924101', '130924', '辛集镇', '1', '130924101', null, '3', '1'),
('130924102', '130924', '高湾镇', '1', '130924102', null, '3', '1'),
('130924200', '130924', '赵毛陶乡', '1', '130924200', null, '3', '1'),
('130924201', '130924', '香坊乡', '1', '130924201', null, '3', '1'),
('130924202', '130924', '小山乡', '1', '130924202', null, '3', '1'),
('130924203', '130924', '张会亭乡', '1', '130924203', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('130924400', '130924', '海兴县农场', '1', '130924400', null, '3', '1'),
('130924401', '130924', '青先农场', '1', '130924401', null, '3', '1'),
('130924402', '130924', '青锋农场', '1', '130924402', null, '3', '1'),
('130925100', '130925', '盐山镇', '1', '130925100', null, '3', '1'),
('130925101', '130925', '望树镇', '1', '130925101', null, '3', '1'),
('130925102', '130925', '庆云镇', '1', '130925102', null, '3', '1'),
('130925103', '130925', '韩集镇', '1', '130925103', null, '3', '1'),
('130925104', '130925', '千童镇', '1', '130925104', null, '3', '1'),
('130925105', '130925', '圣佛镇', '1', '130925105', null, '3', '1'),
('130925200', '130925', '边务乡', '1', '130925200', null, '3', '1'),
('130925201', '130925', '小营乡', '1', '130925201', null, '3', '1'),
('130925202', '130925', '杨集乡', '1', '130925202', null, '3', '1'),
('130925203', '130925', '孟店乡', '1', '130925203', null, '3', '1'),
('130925204', '130925', '常庄乡', '1', '130925204', null, '3', '1'),
('130925205', '130925', '小庄乡', '1', '130925205', null, '3', '1'),
('130926100', '130926', '肃宁镇', '1', '130926100', null, '3', '1'),
('130926101', '130926', '梁家村镇', '1', '130926101', null, '3', '1'),
('130926102', '130926', '窝北镇', '1', '130926102', null, '3', '1'),
('130926103', '130926', '尚村镇', '1', '130926103', null, '3', '1'),
('130926104', '130926', '万里镇', '1', '130926104', null, '3', '1'),
('130926201', '130926', '师素乡', '1', '130926201', null, '3', '1'),
('130926203', '130926', '河北留善寺乡', '1', '130926203', null, '3', '1'),
('130926204', '130926', '付家佐乡', '1', '130926204', null, '3', '1'),
('130926205', '130926', '邵庄乡', '1', '130926205', null, '3', '1'),
('130927100', '130927', '南皮镇', '1', '130927100', null, '3', '1'),
('130927101', '130927', '冯家口镇', '1', '130927101', null, '3', '1'),
('130927102', '130927', '寨子镇', '1', '130927102', null, '3', '1'),
('130927103', '130927', '鲍官屯镇', '1', '130927103', null, '3', '1'),
('130927104', '130927', '王寺镇', '1', '130927104', null, '3', '1'),
('130927105', '130927', '乌马营镇', '1', '130927105', null, '3', '1'),
('130927200', '130927', '大浪淀乡', '1', '130927200', null, '3', '1'),
('130927201', '130927', '刘八里乡', '1', '130927201', null, '3', '1'),
('130927202', '130927', '潞灌乡', '1', '130927202', null, '3', '1'),
('130928100', '130928', '桑园镇', '1', '130928100', null, '3', '1'),
('130928101', '130928', '铁城镇', '1', '130928101', null, '3', '1'),
('130928102', '130928', '于集镇', '1', '130928102', null, '3', '1'),
('130928103', '130928', '梁集镇', '1', '130928103', null, '3', '1'),
('130928104', '130928', '安陵镇', '1', '130928104', null, '3', '1'),
('130928200', '130928', '曹家洼乡', '1', '130928200', null, '3', '1'),
('130928201', '130928', '宋门乡', '1', '130928201', null, '3', '1'),
('130928202', '130928', '杨家寺乡', '1', '130928202', null, '3', '1'),
('130928203', '130928', '沟店铺乡', '1', '130928203', null, '3', '1'),
('130928204', '130928', '何庄乡', '1', '130928204', null, '3', '1'),
('130929100', '130929', '乐寿镇', '1', '130929100', null, '3', '1'),
('130929101', '130929', '淮镇镇', '1', '130929101', null, '3', '1'),
('130929102', '130929', '郭庄镇', '1', '130929102', null, '3', '1'),
('130929103', '130929', '河城街镇', '1', '130929103', null, '3', '1'),
('130929200', '130929', '韩村乡', '1', '130929200', null, '3', '1'),
('130929201', '130929', '陌南乡', '1', '130929201', null, '3', '1'),
('130929204', '130929', '陈庄乡', '1', '130929204', null, '3', '1'),
('130929205', '130929', '徐留高乡', '1', '130929205', null, '3', '1'),
('130929206', '130929', '商林乡', '1', '130929206', null, '3', '1'),
('130929207', '130929', '段村乡', '1', '130929207', null, '3', '1'),
('130929209', '130929', '张村乡', '1', '130929209', null, '3', '1'),
('130929210', '130929', '临河乡', '1', '130929210', null, '3', '1'),
('130929211', '130929', '小平王乡', '1', '130929211', null, '3', '1'),
('130929212', '130929', '十五级乡', '1', '130929212', null, '3', '1'),
('130929213', '130929', '垒头乡', '1', '130929213', null, '3', '1'),
('130929214', '130929', '南河头乡', '1', '130929214', null, '3', '1'),
('130929215', '130929', '西城乡', '1', '130929215', null, '3', '1'),
('130929216', '130929', '本斋回族乡', '1', '130929216', null, '3', '1'),
('130929400', '130929', '农场', '1', '130929400', null, '3', '1'),
('130930100', '130930', '孟村镇', '1', '130930100', null, '3', '1'),
('130930101', '130930', '新县镇', '1', '130930101', null, '3', '1'),
('130930102', '130930', '辛店镇', '1', '130930102', null, '3', '1'),
('130930103', '130930', '高寨镇', '1', '130930103', null, '3', '1'),
('130930200', '130930', '宋庄子乡', '1', '130930200', null, '3', '1'),
('130930201', '130930', '牛进庄乡', '1', '130930201', null, '3', '1'),
('130981001', '130981', '解放街道', '1', '130981001', null, '3', '1'),
('130981002', '130981', '河东街道', '1', '130981002', null, '3', '1'),
('130981003', '130981', '古楼街道', '1', '130981003', null, '3', '1'),
('130981100', '130981', '泊镇', '1', '130981100', null, '3', '1'),
('130981101', '130981', '交河镇', '1', '130981101', null, '3', '1'),
('130981102', '130981', '齐桥镇', '1', '130981102', null, '3', '1'),
('130981103', '130981', '寺门村镇', '1', '130981103', null, '3', '1'),
('130981104', '130981', '郝村镇', '1', '130981104', null, '3', '1'),
('130981105', '130981', '富镇镇', '1', '130981105', null, '3', '1'),
('130981106', '130981', '文庙镇', '1', '130981106', null, '3', '1'),
('130981107', '130981', '洼里王镇', '1', '130981107', null, '3', '1'),
('130981201', '130981', '王武庄乡', '1', '130981201', null, '3', '1'),
('130981202', '130981', '营子乡', '1', '130981202', null, '3', '1'),
('130981203', '130981', '四营乡', '1', '130981203', null, '3', '1'),
('130981204', '130981', '西辛店乡', '1', '130981204', null, '3', '1'),
('130982001', '130982', '新华路街道', '1', '130982001', null, '3', '1'),
('130982002', '130982', '西环路街道', '1', '130982002', null, '3', '1'),
('130982003', '130982', '永丰路街道', '1', '130982003', null, '3', '1'),
('130982100', '130982', '出岸镇', '1', '130982100', null, '3', '1'),
('130982101', '130982', '石门桥镇', '1', '130982101', null, '3', '1'),
('130982102', '130982', '吕公堡镇', '1', '130982102', null, '3', '1'),
('130982103', '130982', '长丰镇', '1', '130982103', null, '3', '1'),
('130982104', '130982', '莫州镇', '1', '130982104', null, '3', '1'),
('130982105', '130982', '苟各庄镇', '1', '130982105', null, '3', '1'),
('130982106', '130982', '梁召镇', '1', '130982106', null, '3', '1'),
('130982107', '130982', '辛中驿镇', '1', '130982107', null, '3', '1'),
('130982202', '130982', '麻家坞乡', '1', '130982202', null, '3', '1'),
('130982203', '130982', '议论堡乡', '1', '130982203', null, '3', '1'),
('130982204', '130982', '青塔乡', '1', '130982204', null, '3', '1'),
('130982205', '130982', '北辛庄乡', '1', '130982205', null, '3', '1'),
('130982206', '130982', '七间房乡', '1', '130982206', null, '3', '1'),
('130982207', '130982', '北汉乡', '1', '130982207', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('130982208', '130982', '于村乡', '1', '130982208', null, '3', '1'),
('130982400', '130982', '华北石油管理局虚拟街道', '1', '130982400', null, '3', '1'),
('130982500', '130982', '开发区管理委员会', '1', '130982500', null, '3', '1'),
('130983001', '130983', '骅东街道', '1', '130983001', null, '3', '1'),
('130983002', '130983', '骅中街道', '1', '130983002', null, '3', '1'),
('130983003', '130983', '骅西街道', '1', '130983003', null, '3', '1'),
('130983100', '130983', '黄骅镇', '1', '130983100', null, '3', '1'),
('130983101', '130983', '南排河镇', '1', '130983101', null, '3', '1'),
('130983102', '130983', '吕桥镇', '1', '130983102', null, '3', '1'),
('130983103', '130983', '旧城镇', '1', '130983103', null, '3', '1'),
('130983200', '130983', '羊二庄回族乡', '1', '130983200', null, '3', '1'),
('130983202', '130983', '常郭乡', '1', '130983202', null, '3', '1'),
('130983203', '130983', '滕庄子乡', '1', '130983203', null, '3', '1'),
('130983204', '130983', '官庄乡', '1', '130983204', null, '3', '1'),
('130983205', '130983', '齐家务乡', '1', '130983205', null, '3', '1'),
('130983206', '130983', '港城开发区新村乡', '1', '130983206', null, '3', '1'),
('130983207', '130983', '羊三木乡', '1', '130983207', null, '3', '1'),
('130983400', '130983', '南大港管理区虚拟乡', '1', '130983400', null, '3', '1'),
('130983401', '130983', '国营中捷农场虚拟乡', '1', '130983401', null, '3', '1'),
('130983402', '130983', '黄骅港开发区虚拟乡', '1', '130983402', null, '3', '1'),
('130983403', '130983', '临港化工园区', '1', '130983403', null, '3', '1'),
('130984100', '130984', '瀛州镇', '1', '130984100', null, '3', '1'),
('130984101', '130984', '米各庄镇', '1', '130984101', null, '3', '1'),
('130984102', '130984', '景和镇', '1', '130984102', null, '3', '1'),
('130984103', '130984', '卧佛堂镇', '1', '130984103', null, '3', '1'),
('130984104', '130984', '束城镇', '1', '130984104', null, '3', '1'),
('130984105', '130984', '留古寺镇', '1', '130984105', null, '3', '1'),
('130984106', '130984', '沙河桥镇', '1', '130984106', null, '3', '1'),
('130984200', '130984', '故仙乡', '1', '130984200', null, '3', '1'),
('130984201', '130984', '黎民居乡', '1', '130984201', null, '3', '1'),
('130984202', '130984', '兴村乡', '1', '130984202', null, '3', '1'),
('130984203', '130984', '沙洼乡', '1', '130984203', null, '3', '1'),
('130984204', '130984', '西九吉乡', '1', '130984204', null, '3', '1'),
('130984205', '130984', '北石槽乡', '1', '130984205', null, '3', '1'),
('130984207', '130984', '诗经村乡', '1', '130984207', null, '3', '1'),
('130984208', '130984', '郭家村乡', '1', '130984208', null, '3', '1'),
('130984209', '130984', '时村乡', '1', '130984209', null, '3', '1'),
('130984210', '130984', '行别营乡', '1', '130984210', null, '3', '1'),
('130984211', '130984', '尊祖庄乡', '1', '130984211', null, '3', '1'),
('130984212', '130984', '龙华店乡', '1', '130984212', null, '3', '1'),
('130984213', '130984', '果子洼乡', '1', '130984213', null, '3', '1'),
('131002001', '131002', '银河南路街道', '1', '131002001', null, '3', '1'),
('131002002', '131002', '光明西道街道', '1', '131002002', null, '3', '1'),
('131002100', '131002', '落垡镇', '1', '131002100', null, '3', '1'),
('131002101', '131002', '码头镇', '1', '131002101', null, '3', '1'),
('131002102', '131002', '葛渔城镇', '1', '131002102', null, '3', '1'),
('131002103', '131002', '东沽港镇', '1', '131002103', null, '3', '1'),
('131002200', '131002', '杨税务乡', '1', '131002200', null, '3', '1'),
('131002201', '131002', '仇庄乡', '1', '131002201', null, '3', '1'),
('131002202', '131002', '调河头乡', '1', '131002202', null, '3', '1'),
('131002203', '131002', '北史家务乡', '1', '131002203', null, '3', '1'),
('131003001', '131003', '银河北路街道', '1', '131003001', null, '3', '1'),
('131003002', '131003', '爱民东道街道', '1', '131003002', null, '3', '1'),
('131003003', '131003', '解放道街道', '1', '131003003', null, '3', '1'),
('131003004', '131003', '新开路街道', '1', '131003004', null, '3', '1'),
('131003100', '131003', '南尖塔镇', '1', '131003100', null, '3', '1'),
('131003101', '131003', '万庄镇', '1', '131003101', null, '3', '1'),
('131003102', '131003', '九州镇', '1', '131003102', null, '3', '1'),
('131003200', '131003', '北旺乡', '1', '131003200', null, '3', '1'),
('131003450', '131003', '廊坊经济技术开发区', '1', '131003450', null, '3', '1'),
('131003500', '131003', '新世纪步行街管理委员会', '1', '131003500', null, '3', '1'),
('131022100', '131022', '固安镇', '1', '131022100', null, '3', '1'),
('131022101', '131022', '宫村镇', '1', '131022101', null, '3', '1'),
('131022102', '131022', '柳泉镇', '1', '131022102', null, '3', '1'),
('131022103', '131022', '牛驼镇', '1', '131022103', null, '3', '1'),
('131022104', '131022', '马庄镇', '1', '131022104', null, '3', '1'),
('131022200', '131022', '东湾乡', '1', '131022200', null, '3', '1'),
('131022201', '131022', '彭村乡', '1', '131022201', null, '3', '1'),
('131022202', '131022', '渠沟乡', '1', '131022202', null, '3', '1'),
('131022203', '131022', '礼让店乡', '1', '131022203', null, '3', '1'),
('131023001', '131023', '街道', '1', '131023001', null, '3', '1'),
('131023100', '131023', '永清镇', '1', '131023100', null, '3', '1'),
('131023101', '131023', '韩村镇', '1', '131023101', null, '3', '1'),
('131023102', '131023', '后奕镇', '1', '131023102', null, '3', '1'),
('131023103', '131023', '别古庄镇', '1', '131023103', null, '3', '1'),
('131023104', '131023', '里澜城镇', '1', '131023104', null, '3', '1'),
('131023200', '131023', '管家务回族乡', '1', '131023200', null, '3', '1'),
('131023201', '131023', '曹家务乡', '1', '131023201', null, '3', '1'),
('131023202', '131023', '龙虎庄乡', '1', '131023202', null, '3', '1'),
('131023203', '131023', '刘街乡', '1', '131023203', null, '3', '1'),
('131023204', '131023', '三圣口乡', '1', '131023204', null, '3', '1'),
('131024100', '131024', '淑阳镇', '1', '131024100', null, '3', '1'),
('131024101', '131024', '蒋辛屯镇', '1', '131024101', null, '3', '1'),
('131024102', '131024', '渠口镇', '1', '131024102', null, '3', '1'),
('131024103', '131024', '安头屯镇', '1', '131024103', null, '3', '1'),
('131024104', '131024', '安平镇', '1', '131024104', null, '3', '1'),
('131024105', '131024', '刘宋镇', '1', '131024105', null, '3', '1'),
('131024106', '131024', '五百户镇', '1', '131024106', null, '3', '1'),
('131024200', '131024', '钱旺乡', '1', '131024200', null, '3', '1'),
('131024201', '131024', '钳屯乡', '1', '131024201', null, '3', '1'),
('131024500', '131024', '香河开发区', '1', '131024500', null, '3', '1'),
('131025100', '131025', '平舒镇', '1', '131025100', null, '3', '1'),
('131025101', '131025', '旺村镇', '1', '131025101', null, '3', '1'),
('131025102', '131025', '大尚屯镇', '1', '131025102', null, '3', '1'),
('131025103', '131025', '南赵扶镇', '1', '131025103', null, '3', '1'),
('131025104', '131025', '留各庄镇', '1', '131025104', null, '3', '1'),
('131025105', '131025', '权村镇', '1', '131025105', null, '3', '1'),
('131025106', '131025', '里坦镇', '1', '131025106', null, '3', '1'),
('131025200', '131025', '北位乡', '1', '131025200', null, '3', '1'),
('131025201', '131025', '大广安乡', '1', '131025201', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('131025202', '131025', '臧屯乡', '1', '131025202', null, '3', '1'),
('131025400', '131025', '摩配园区管委会', '1', '131025400', null, '3', '1'),
('131026100', '131026', '文安镇', '1', '131026100', null, '3', '1'),
('131026101', '131026', '新镇镇', '1', '131026101', null, '3', '1'),
('131026102', '131026', '苏桥镇', '1', '131026102', null, '3', '1'),
('131026103', '131026', '大柳河镇', '1', '131026103', null, '3', '1'),
('131026104', '131026', '左各庄镇', '1', '131026104', null, '3', '1'),
('131026105', '131026', '滩里镇', '1', '131026105', null, '3', '1'),
('131026106', '131026', '史各庄镇', '1', '131026106', null, '3', '1'),
('131026107', '131026', '赵各庄镇', '1', '131026107', null, '3', '1'),
('131026108', '131026', '兴隆宫镇', '1', '131026108', null, '3', '1'),
('131026109', '131026', '大留镇镇', '1', '131026109', null, '3', '1'),
('131026110', '131026', '孙氏镇', '1', '131026110', null, '3', '1'),
('131026111', '131026', '德归镇', '1', '131026111', null, '3', '1'),
('131026200', '131026', '大围河回族满族乡', '1', '131026200', null, '3', '1'),
('131028100', '131028', '大厂镇', '1', '131028100', null, '3', '1'),
('131028101', '131028', '夏垫镇', '1', '131028101', null, '3', '1'),
('131028102', '131028', '祁各庄镇', '1', '131028102', null, '3', '1'),
('131028201', '131028', '邵府乡', '1', '131028201', null, '3', '1'),
('131028202', '131028', '陈府乡', '1', '131028202', null, '3', '1'),
('131028400', '131028', '工业园区', '1', '131028400', null, '3', '1'),
('131081100', '131081', '霸州镇', '1', '131081100', null, '3', '1'),
('131081101', '131081', '南孟镇', '1', '131081101', null, '3', '1'),
('131081102', '131081', '信安镇', '1', '131081102', null, '3', '1'),
('131081103', '131081', '堂二里镇', '1', '131081103', null, '3', '1'),
('131081104', '131081', '煎茶铺镇', '1', '131081104', null, '3', '1'),
('131081105', '131081', '胜芳镇', '1', '131081105', null, '3', '1'),
('131081106', '131081', '杨芬港镇', '1', '131081106', null, '3', '1'),
('131081200', '131081', '岔河集乡', '1', '131081200', null, '3', '1'),
('131081201', '131081', '康仙庄乡', '1', '131081201', null, '3', '1'),
('131081202', '131081', '东杨庄乡', '1', '131081202', null, '3', '1'),
('131081203', '131081', '王庄子乡', '1', '131081203', null, '3', '1'),
('131081204', '131081', '东段乡', '1', '131081204', null, '3', '1'),
('131081450', '131081', '霸州经济技术开发区', '1', '131081450', null, '3', '1'),
('131082001', '131082', '南城街道', '1', '131082001', null, '3', '1'),
('131082002', '131082', '北城街道', '1', '131082002', null, '3', '1'),
('131082100', '131082', '泃阳镇', '1', '131082100', null, '3', '1'),
('131082101', '131082', '李旗庄镇', '1', '131082101', null, '3', '1'),
('131082102', '131082', '杨庄镇', '1', '131082102', null, '3', '1'),
('131082103', '131082', '皇庄镇', '1', '131082103', null, '3', '1'),
('131082104', '131082', '新集镇', '1', '131082104', null, '3', '1'),
('131082105', '131082', '段甲岭镇', '1', '131082105', null, '3', '1'),
('131082106', '131082', '黄土庄镇', '1', '131082106', null, '3', '1'),
('131082107', '131082', '高楼镇', '1', '131082107', null, '3', '1'),
('131082108', '131082', '齐心庄镇', '1', '131082108', null, '3', '1'),
('131082109', '131082', '燕郊镇', '1', '131082109', null, '3', '1'),
('131082450', '131082', '燕郊经济技术开发区', '1', '131082450', null, '3', '1'),
('131082451', '131082', '三河市农业高新技术园区', '1', '131082451', null, '3', '1'),
('131102001', '131102', '河西街道', '1', '131102001', null, '3', '1'),
('131102002', '131102', '河东街道', '1', '131102002', null, '3', '1'),
('131102003', '131102', '路北街道', '1', '131102003', null, '3', '1'),
('131102004', '131102', '中华街道', '1', '131102004', null, '3', '1'),
('131102100', '131102', '郑家河沿镇', '1', '131102100', null, '3', '1'),
('131102101', '131102', '赵家圈镇', '1', '131102101', null, '3', '1'),
('131102200', '131102', '何家庄乡', '1', '131102200', null, '3', '1'),
('131102201', '131102', '大麻森乡', '1', '131102201', null, '3', '1'),
('131102202', '131102', '邓家庄乡', '1', '131102202', null, '3', '1'),
('131102203', '131102', '彭杜村乡', '1', '131102203', null, '3', '1'),
('131102400', '131102', '衡水高新技术产业开发区', '1', '131102400', null, '3', '1'),
('131102401', '131102', '衡水湖自然保护区管理处', '1', '131102401', null, '3', '1'),
('131121100', '131121', '枣强镇', '1', '131121100', null, '3', '1'),
('131121101', '131121', '恩察镇', '1', '131121101', null, '3', '1'),
('131121102', '131121', '大营镇', '1', '131121102', null, '3', '1'),
('131121103', '131121', '嘉会镇', '1', '131121103', null, '3', '1'),
('131121104', '131121', '马屯镇', '1', '131121104', null, '3', '1'),
('131121105', '131121', '肖张镇', '1', '131121105', null, '3', '1'),
('131121200', '131121', '张秀屯乡', '1', '131121200', null, '3', '1'),
('131121201', '131121', '新屯乡', '1', '131121201', null, '3', '1'),
('131121202', '131121', '王均乡', '1', '131121202', null, '3', '1'),
('131121203', '131121', '唐林乡', '1', '131121203', null, '3', '1'),
('131121204', '131121', '王常乡', '1', '131121204', null, '3', '1'),
('131122100', '131122', '武邑镇', '1', '131122100', null, '3', '1'),
('131122101', '131122', '清凉店镇', '1', '131122101', null, '3', '1'),
('131122102', '131122', '审坡镇', '1', '131122102', null, '3', '1'),
('131122103', '131122', '赵桥镇', '1', '131122103', null, '3', '1'),
('131122104', '131122', '韩庄镇', '1', '131122104', null, '3', '1'),
('131122105', '131122', '肖桥头镇', '1', '131122105', null, '3', '1'),
('131122200', '131122', '龙店乡', '1', '131122200', null, '3', '1'),
('131122201', '131122', '圈头乡', '1', '131122201', null, '3', '1'),
('131122203', '131122', '大紫塔乡', '1', '131122203', null, '3', '1'),
('131123100', '131123', '武强镇', '1', '131123100', null, '3', '1'),
('131123101', '131123', '街关镇', '1', '131123101', null, '3', '1'),
('131123200', '131123', '豆村乡', '1', '131123200', null, '3', '1'),
('131123201', '131123', '北代乡', '1', '131123201', null, '3', '1'),
('131123202', '131123', '孙庄乡', '1', '131123202', null, '3', '1'),
('131123203', '131123', '周家窝乡', '1', '131123203', null, '3', '1'),
('131124100', '131124', '饶阳镇', '1', '131124100', null, '3', '1'),
('131124101', '131124', '大尹村镇', '1', '131124101', null, '3', '1'),
('131124102', '131124', '五公镇', '1', '131124102', null, '3', '1'),
('131124200', '131124', '王同岳乡', '1', '131124200', null, '3', '1'),
('131124201', '131124', '大官亭乡', '1', '131124201', null, '3', '1'),
('131124202', '131124', '留楚乡', '1', '131124202', null, '3', '1'),
('131124203', '131124', '东里满乡', '1', '131124203', null, '3', '1'),
('131125100', '131125', '安平镇', '1', '131125100', null, '3', '1'),
('131125101', '131125', '马店镇', '1', '131125101', null, '3', '1'),
('131125102', '131125', '南王庄镇', '1', '131125102', null, '3', '1'),
('131125200', '131125', '大何庄乡', '1', '131125200', null, '3', '1'),
('131125201', '131125', '程油子乡', '1', '131125201', null, '3', '1'),
('131125202', '131125', '西两洼乡', '1', '131125202', null, '3', '1'),
('131125203', '131125', '大子文乡', '1', '131125203', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('131125204', '131125', '东黄城乡', '1', '131125204', null, '3', '1'),
('131126100', '131126', '郑口镇', '1', '131126100', null, '3', '1'),
('131126101', '131126', '夏庄镇', '1', '131126101', null, '3', '1'),
('131126102', '131126', '青罕镇', '1', '131126102', null, '3', '1'),
('131126103', '131126', '故城镇', '1', '131126103', null, '3', '1'),
('131126104', '131126', '武官寨镇', '1', '131126104', null, '3', '1'),
('131126105', '131126', '饶阳店镇', '1', '131126105', null, '3', '1'),
('131126106', '131126', '军屯镇', '1', '131126106', null, '3', '1'),
('131126107', '131126', '建国镇', '1', '131126107', null, '3', '1'),
('131126108', '131126', '西半屯镇', '1', '131126108', null, '3', '1'),
('131126200', '131126', '辛庄乡', '1', '131126200', null, '3', '1'),
('131126201', '131126', '里老乡', '1', '131126201', null, '3', '1'),
('131126202', '131126', '房庄乡', '1', '131126202', null, '3', '1'),
('131126203', '131126', '三朗乡', '1', '131126203', null, '3', '1'),
('131127100', '131127', '景州镇', '1', '131127100', null, '3', '1'),
('131127101', '131127', '龙华镇', '1', '131127101', null, '3', '1'),
('131127102', '131127', '广川镇', '1', '131127102', null, '3', '1'),
('131127103', '131127', '王瞳镇', '1', '131127103', null, '3', '1'),
('131127104', '131127', '洚河流镇', '1', '131127104', null, '3', '1'),
('131127105', '131127', '安陵镇', '1', '131127105', null, '3', '1'),
('131127106', '131127', '杜桥镇', '1', '131127106', null, '3', '1'),
('131127107', '131127', '王谦寺镇', '1', '131127107', null, '3', '1'),
('131127108', '131127', '北留智镇', '1', '131127108', null, '3', '1'),
('131127109', '131127', '留智庙镇', '1', '131127109', null, '3', '1'),
('131127200', '131127', '刘集乡', '1', '131127200', null, '3', '1'),
('131127201', '131127', '连镇乡', '1', '131127201', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('131127202', '131127', '梁集乡', '1', '131127202', null, '3', '1'),
('131127203', '131127', '温城乡', '1', '131127203', null, '3', '1'),
('131127204', '131127', '后留名府乡', '1', '131127204', null, '3', '1'),
('131127205', '131127', '青兰乡', '1', '131127205', null, '3', '1'),
('131128100', '131128', '阜城镇', '1', '131128100', null, '3', '1'),
('131128101', '131128', '古城镇', '1', '131128101', null, '3', '1'),
('131128102', '131128', '码头镇', '1', '131128102', null, '3', '1'),
('131128103', '131128', '霞口镇', '1', '131128103', null, '3', '1'),
('131128104', '131128', '崔家庙镇', '1', '131128104', null, '3', '1'),
('131128200', '131128', '漫河乡', '1', '131128200', null, '3', '1'),
('131128201', '131128', '建桥乡', '1', '131128201', null, '3', '1'),
('131128202', '131128', '蒋坊乡', '1', '131128202', null, '3', '1'),
('131128203', '131128', '大白乡', '1', '131128203', null, '3', '1'),
('131128204', '131128', '王集乡', '1', '131128204', null, '3', '1'),
('131181100', '131181', '冀州镇', '1', '131181100', null, '3', '1'),
('131181101', '131181', '魏屯镇', '1', '131181101', null, '3', '1'),
('131181102', '131181', '官道李镇', '1', '131181102', null, '3', '1'),
('131181103', '131181', '南午村镇', '1', '131181103', null, '3', '1'),
('131181104', '131181', '周村镇', '1', '131181104', null, '3', '1'),
('131181105', '131181', '码头李镇', '1', '131181105', null, '3', '1'),
('131181106', '131181', '西王镇', '1', '131181106', null, '3', '1'),
('131181200', '131181', '门庄乡', '1', '131181200', null, '3', '1'),
('131181201', '131181', '徐家庄乡', '1', '131181201', null, '3', '1'),
('131181202', '131181', '北漳淮乡', '1', '131181202', null, '3', '1'),
('131181203', '131181', '小寨乡', '1', '131181203', null, '3', '1'),
('131182100', '131182', '唐奉镇', '1', '131182100', null, '3', '1'),
('131182101', '131182', '深州镇', '1', '131182101', null, '3', '1'),
('131182102', '131182', '辰时镇', '1', '131182102', null, '3', '1'),
('131182103', '131182', '榆科镇', '1', '131182103', null, '3', '1'),
('131182104', '131182', '魏桥镇', '1', '131182104', null, '3', '1'),
('131182105', '131182', '大堤镇', '1', '131182105', null, '3', '1'),
('131182106', '131182', '前磨头镇', '1', '131182106', null, '3', '1'),
('131182107', '131182', '王家井镇', '1', '131182107', null, '3', '1'),
('131182108', '131182', '护驾迟镇', '1', '131182108', null, '3', '1'),
('131182200', '131182', '兵曹乡', '1', '131182200', null, '3', '1'),
('131182201', '131182', '穆村乡', '1', '131182201', null, '3', '1'),
('131182202', '131182', '东安庄乡', '1', '131182202', null, '3', '1'),
('131182203', '131182', '北溪村乡', '1', '131182203', null, '3', '1'),
('131182204', '131182', '大冯营乡', '1', '131182204', null, '3', '1'),
('131182206', '131182', '乔屯乡', '1', '131182206', null, '3', '1'),
('131182207', '131182', '太古庄乡', '1', '131182207', null, '3', '1'),
('131182208', '131182', '大屯乡', '1', '131182208', null, '3', '1'),
('131182400', '131182', '河北省深州监狱', '1', '131182400', null, '3', '1'),
('140105001', '140105', '坞城街道', '1', '140105001', null, '3', '1'),
('140105002', '140105', '营盘街道', '1', '140105002', null, '3', '1'),
('140105003', '140105', '北营街道', '1', '140105003', null, '3', '1'),
('140105004', '140105', '平阳路街道', '1', '140105004', null, '3', '1'),
('140105005', '140105', '黄陵街道', '1', '140105005', null, '3', '1'),
('140105006', '140105', '小店街道', '1', '140105006', null, '3', '1'),
('140105100', '140105', '北格镇', '1', '140105100', null, '3', '1'),
('140105200', '140105', '西温庄乡', '1', '140105200', null, '3', '1'),
('140105201', '140105', '刘家堡乡', '1', '140105201', null, '3', '1'),
('140105401', '140105', '太原高新技术产业开发区', '1', '140105401', null, '3', '1'),
('140105501', '140105', '太原经济技术开发区', '1', '140105501', null, '3', '1'),
('140106001', '140106', '柳巷街道', '1', '140106001', null, '3', '1'),
('140106002', '140106', '文庙街道', '1', '140106002', null, '3', '1'),
('140106003', '140106', '庙前街道', '1', '140106003', null, '3', '1'),
('140106004', '140106', '迎泽街道', '1', '140106004', null, '3', '1'),
('140106005', '140106', '桥东街道', '1', '140106005', null, '3', '1'),
('140106006', '140106', '老军营街道', '1', '140106006', null, '3', '1'),
('140106100', '140106', '郝庄镇', '1', '140106100', null, '3', '1'),
('140106401', '140106', '民营区', '1', '140106401', null, '3', '1'),
('140107001', '140107', '巨轮街道', '1', '140107001', null, '3', '1'),
('140107002', '140107', '三桥街道', '1', '140107002', null, '3', '1'),
('140107003', '140107', '鼓楼街道', '1', '140107003', null, '3', '1'),
('140107004', '140107', '杏花岭街道', '1', '140107004', null, '3', '1'),
('140107005', '140107', '坝陵桥街道', '1', '140107005', null, '3', '1'),
('140107006', '140107', '大东关街道', '1', '140107006', null, '3', '1'),
('140107007', '140107', '职工新街街道', '1', '140107007', null, '3', '1'),
('140107008', '140107', '敦化坊街道', '1', '140107008', null, '3', '1'),
('140107009', '140107', '涧河街道', '1', '140107009', null, '3', '1'),
('140107010', '140107', '杨家峪街道', '1', '140107010', null, '3', '1'),
('140107200', '140107', '中涧河乡', '1', '140107200', null, '3', '1'),
('140107201', '140107', '小返乡', '1', '140107201', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('140107401', '140107', '民营区', '1', '140107401', null, '3', '1'),
('140108001', '140108', '尖草坪街道', '1', '140108001', null, '3', '1'),
('140108002', '140108', '光社街道', '1', '140108002', null, '3', '1'),
('140108003', '140108', '上兰街道', '1', '140108003', null, '3', '1'),
('140108004', '140108', '南寨街道', '1', '140108004', null, '3', '1'),
('140108005', '140108', '迎新街道', '1', '140108005', null, '3', '1'),
('140108006', '140108', '古城街道', '1', '140108006', null, '3', '1'),
('140108007', '140108', '汇丰街道', '1', '140108007', null, '3', '1'),
('140108008', '140108', '柴村街道', '1', '140108008', null, '3', '1'),
('140108009', '140108', '新城街道', '1', '140108009', null, '3', '1'),
('140108100', '140108', '向阳镇', '1', '140108100', null, '3', '1'),
('140108101', '140108', '阳曲镇', '1', '140108101', null, '3', '1'),
('140108200', '140108', '马头水乡', '1', '140108200', null, '3', '1'),
('140108201', '140108', '柏板乡', '1', '140108201', null, '3', '1'),
('140108202', '140108', '西焉乡', '1', '140108202', null, '3', '1'),
('140109001', '140109', '千峰街道', '1', '140109001', null, '3', '1'),
('140109002', '140109', '下元街道', '1', '140109002', null, '3', '1'),
('140109003', '140109', '和平街道', '1', '140109003', null, '3', '1'),
('140109004', '140109', '兴华街道', '1', '140109004', null, '3', '1'),
('140109005', '140109', '万柏林街道', '1', '140109005', null, '3', '1'),
('140109006', '140109', '杜儿坪街道', '1', '140109006', null, '3', '1'),
('140109007', '140109', '白家庄街道', '1', '140109007', null, '3', '1'),
('140109008', '140109', '南寒街道', '1', '140109008', null, '3', '1'),
('140109009', '140109', '东社街道', '1', '140109009', null, '3', '1'),
('140109010', '140109', '化客头街道', '1', '140109010', null, '3', '1'),
('140109011', '140109', '小井峪街道', '1', '140109011', null, '3', '1'),
('140109012', '140109', '西铭街道', '1', '140109012', null, '3', '1'),
('140109013', '140109', '长风街道', '1', '140109013', null, '3', '1'),
('140109014', '140109', '神堂沟街道', '1', '140109014', null, '3', '1'),
('140109200', '140109', '王封乡', '1', '140109200', null, '3', '1'),
('140110001', '140110', '义井街道', '1', '140110001', null, '3', '1'),
('140110002', '140110', '罗城街道', '1', '140110002', null, '3', '1'),
('140110003', '140110', '晋源街道', '1', '140110003', null, '3', '1'),
('140110100', '140110', '金胜镇', '1', '140110100', null, '3', '1'),
('140110101', '140110', '晋祠镇', '1', '140110101', null, '3', '1'),
('140110102', '140110', '姚村镇', '1', '140110102', null, '3', '1'),
('140121100', '140121', '清源镇', '1', '140121100', null, '3', '1'),
('140121101', '140121', '徐沟镇', '1', '140121101', null, '3', '1'),
('140121102', '140121', '东于镇', '1', '140121102', null, '3', '1'),
('140121103', '140121', '孟封镇', '1', '140121103', null, '3', '1'),
('140121200', '140121', '马峪乡', '1', '140121200', null, '3', '1'),
('140121201', '140121', '柳杜乡', '1', '140121201', null, '3', '1'),
('140121202', '140121', '西谷乡', '1', '140121202', null, '3', '1'),
('140121203', '140121', '王答乡', '1', '140121203', null, '3', '1'),
('140121204', '140121', '集义乡', '1', '140121204', null, '3', '1'),
('140122100', '140122', '黄寨镇', '1', '140122100', null, '3', '1'),
('140122101', '140122', '大盂镇', '1', '140122101', null, '3', '1'),
('140122102', '140122', '东黄水镇', '1', '140122102', null, '3', '1'),
('140122103', '140122', '泥屯镇', '1', '140122103', null, '3', '1'),
('140122104', '140122', '阳曲县社区建设管理办公室', '1', '140122104', null, '3', '1'),
('140122200', '140122', '高村乡', '1', '140122200', null, '3', '1'),
('140122201', '140122', '侯村乡', '1', '140122201', null, '3', '1'),
('140122202', '140122', '凌井店乡', '1', '140122202', null, '3', '1'),
('140122203', '140122', '西凌井乡', '1', '140122203', null, '3', '1'),
('140122204', '140122', '北小店乡', '1', '140122204', null, '3', '1'),
('140122205', '140122', '杨兴乡', '1', '140122205', null, '3', '1'),
('140123100', '140123', '娄烦镇', '1', '140123100', null, '3', '1'),
('140123101', '140123', '静游镇', '1', '140123101', null, '3', '1'),
('140123102', '140123', '杜交曲镇', '1', '140123102', null, '3', '1'),
('140123200', '140123', '庙湾乡', '1', '140123200', null, '3', '1'),
('140123201', '140123', '马家庄乡', '1', '140123201', null, '3', '1'),
('140123202', '140123', '盖家庄乡', '1', '140123202', null, '3', '1'),
('140123203', '140123', '米峪镇乡', '1', '140123203', null, '3', '1'),
('140123204', '140123', '天池店乡', '1', '140123204', null, '3', '1'),
('140181001', '140181', '东曲街道', '1', '140181001', null, '3', '1'),
('140181002', '140181', '西曲街道', '1', '140181002', null, '3', '1'),
('140181003', '140181', '桃园街道', '1', '140181003', null, '3', '1'),
('140181004', '140181', '屯兰街道', '1', '140181004', null, '3', '1'),
('140181100', '140181', '河口镇', '1', '140181100', null, '3', '1'),
('140181101', '140181', '镇城底镇', '1', '140181101', null, '3', '1'),
('140181102', '140181', '马兰镇', '1', '140181102', null, '3', '1'),
('140181200', '140181', '阁上乡', '1', '140181200', null, '3', '1'),
('140181201', '140181', '加乐泉乡', '1', '140181201', null, '3', '1'),
('140181202', '140181', '梭峪乡', '1', '140181202', null, '3', '1'),
('140181203', '140181', '岔口乡', '1', '140181203', null, '3', '1'),
('140181204', '140181', '常安乡', '1', '140181204', null, '3', '1'),
('140181205', '140181', '原相乡', '1', '140181205', null, '3', '1'),
('140181206', '140181', '邢家社乡', '1', '140181206', null, '3', '1'),
('140202001', '140202', '南关街道', '1', '140202001', null, '3', '1'),
('140202002', '140202', '北关街道', '1', '140202002', null, '3', '1'),
('140202003', '140202', '东街街道', '1', '140202003', null, '3', '1'),
('140202004', '140202', '西街街道', '1', '140202004', null, '3', '1'),
('140202005', '140202', '南街街道', '1', '140202005', null, '3', '1'),
('140202006', '140202', '北街街道', '1', '140202006', null, '3', '1'),
('140202007', '140202', '新建南路街道', '1', '140202007', null, '3', '1'),
('140202008', '140202', '新建北路街道', '1', '140202008', null, '3', '1'),
('140202009', '140202', '大庆路街道', '1', '140202009', null, '3', '1'),
('140202010', '140202', '新华街街道', '1', '140202010', null, '3', '1'),
('140202011', '140202', '西花园街道', '1', '140202011', null, '3', '1'),
('140202012', '140202', '老平旺街道', '1', '140202012', null, '3', '1'),
('140202013', '140202', '向阳里街道', '1', '140202013', null, '3', '1'),
('140202014', '140202', '振华街街道', '1', '140202014', null, '3', '1'),
('140203001', '140203', '新胜街道', '1', '140203001', null, '3', '1'),
('140203002', '140203', '新平旺街道', '1', '140203002', null, '3', '1'),
('140203003', '140203', '煤峪口街道', '1', '140203003', null, '3', '1'),
('140203004', '140203', '永定庄街道', '1', '140203004', null, '3', '1'),
('140203005', '140203', '同家梁街道', '1', '140203005', null, '3', '1'),
('140203006', '140203', '四老沟街道', '1', '140203006', null, '3', '1'),
('140203007', '140203', '忻州窑街道', '1', '140203007', null, '3', '1'),
('140203008', '140203', '白洞街道', '1', '140203008', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('140203009', '140203', '雁崖街道', '1', '140203009', null, '3', '1'),
('140203010', '140203', '挖金湾街道', '1', '140203010', null, '3', '1'),
('140203011', '140203', '晋华宫街道', '1', '140203011', null, '3', '1'),
('140203012', '140203', '马脊梁街道', '1', '140203012', null, '3', '1'),
('140203013', '140203', '大斗沟街道', '1', '140203013', null, '3', '1'),
('140203014', '140203', '王村街道', '1', '140203014', null, '3', '1'),
('140203015', '140203', '姜家湾街道', '1', '140203015', null, '3', '1'),
('140203016', '140203', '新泉路街道', '1', '140203016', null, '3', '1'),
('140203017', '140203', '民胜街道', '1', '140203017', null, '3', '1'),
('140203018', '140203', '口泉街道', '1', '140203018', null, '3', '1'),
('140203019', '140203', '马口街道', '1', '140203019', null, '3', '1'),
('140203020', '140203', '燕子山街道', '1', '140203020', null, '3', '1'),
('140203021', '140203', '杏儿沟街道', '1', '140203021', null, '3', '1'),
('140203022', '140203', '青磁窑街道', '1', '140203022', null, '3', '1'),
('140203023', '140203', '平泉路街道', '1', '140203023', null, '3', '1'),
('140203024', '140203', '四台沟街道', '1', '140203024', null, '3', '1'),
('140211100', '140211', '古店镇', '1', '140211100', null, '3', '1'),
('140211101', '140211', '高山镇', '1', '140211101', null, '3', '1'),
('140211102', '140211', '云冈镇', '1', '140211102', null, '3', '1'),
('140211200', '140211', '口泉乡', '1', '140211200', null, '3', '1'),
('140211201', '140211', '新旺乡', '1', '140211201', null, '3', '1'),
('140211202', '140211', '水泊寺乡', '1', '140211202', null, '3', '1'),
('140211205', '140211', '马军营乡', '1', '140211205', null, '3', '1'),
('140211206', '140211', '西韩岭乡', '1', '140211206', null, '3', '1'),
('140211207', '140211', '平旺乡', '1', '140211207', null, '3', '1'),
('140211210', '140211', '鸦儿崖乡', '1', '140211210', null, '3', '1'),
('140212001', '140212', '新荣区社区服务管理中心', '1', '140212001', null, '3', '1'),
('140212100', '140212', '新荣镇', '1', '140212100', null, '3', '1'),
('140212200', '140212', '破鲁堡乡', '1', '140212200', null, '3', '1'),
('140212202', '140212', '郭家窑乡', '1', '140212202', null, '3', '1'),
('140212203', '140212', '花元屯乡', '1', '140212203', null, '3', '1'),
('140212206', '140212', '西村乡', '1', '140212206', null, '3', '1'),
('140212207', '140212', '上深涧乡', '1', '140212207', null, '3', '1'),
('140212209', '140212', '堡子湾乡', '1', '140212209', null, '3', '1'),
('140221100', '140221', '龙泉镇', '1', '140221100', null, '3', '1'),
('140221101', '140221', '罗文皂镇', '1', '140221101', null, '3', '1'),
('140221102', '140221', '大白登镇', '1', '140221102', null, '3', '1'),
('140221103', '140221', '王官屯镇', '1', '140221103', null, '3', '1'),
('140221104', '140221', '古城镇', '1', '140221104', null, '3', '1'),
('140221105', '140221', '东小村镇', '1', '140221105', null, '3', '1'),
('140221106', '140221', '友宰镇', '1', '140221106', null, '3', '1'),
('140221201', '140221', '长城乡', '1', '140221201', null, '3', '1'),
('140221202', '140221', '北徐屯乡', '1', '140221202', null, '3', '1'),
('140221204', '140221', '狮子屯乡', '1', '140221204', null, '3', '1'),
('140221209', '140221', '下深井乡', '1', '140221209', null, '3', '1'),
('140221211', '140221', '马家皂乡', '1', '140221211', null, '3', '1'),
('140221212', '140221', '鳌石乡', '1', '140221212', null, '3', '1'),
('140222100', '140222', '玉泉镇', '1', '140222100', null, '3', '1'),
('140222101', '140222', '谷前堡镇', '1', '140222101', null, '3', '1'),
('140222102', '140222', '米薪关镇', '1', '140222102', null, '3', '1'),
('140222103', '140222', '逯家湾镇', '1', '140222103', null, '3', '1'),
('140222104', '140222', '新平镇', '1', '140222104', null, '3', '1'),
('140222200', '140222', '卅里铺乡', '1', '140222200', null, '3', '1'),
('140222202', '140222', '南河堡乡', '1', '140222202', null, '3', '1'),
('140222204', '140222', '贾家屯乡', '1', '140222204', null, '3', '1'),
('140222206', '140222', '赵家沟乡', '1', '140222206', null, '3', '1'),
('140222208', '140222', '南高崖乡', '1', '140222208', null, '3', '1'),
('140222209', '140222', '张西河乡', '1', '140222209', null, '3', '1'),
('140223100', '140223', '壶泉镇', '1', '140223100', null, '3', '1'),
('140223101', '140223', '南村镇', '1', '140223101', null, '3', '1'),
('140223200', '140223', '斗泉乡', '1', '140223200', null, '3', '1'),
('140223202', '140223', '蕉山乡', '1', '140223202', null, '3', '1'),
('140223203', '140223', '加斗乡', '1', '140223203', null, '3', '1'),
('140223206', '140223', '宜兴乡', '1', '140223206', null, '3', '1'),
('140223207', '140223', '作疃乡', '1', '140223207', null, '3', '1'),
('140223209', '140223', '梁庄乡', '1', '140223209', null, '3', '1'),
('140223211', '140223', '望狐乡', '1', '140223211', null, '3', '1'),
('140224100', '140224', '武灵镇', '1', '140224100', null, '3', '1'),
('140224101', '140224', '东河南镇', '1', '140224101', null, '3', '1'),
('140224102', '140224', '上寨镇', '1', '140224102', null, '3', '1'),
('140224200', '140224', '落水河乡', '1', '140224200', null, '3', '1'),
('140224203', '140224', '史庄乡', '1', '140224203', null, '3', '1'),
('140224205', '140224', '赵北乡', '1', '140224205', null, '3', '1'),
('140224206', '140224', '石家田乡', '1', '140224206', null, '3', '1'),
('140224207', '140224', '柳科乡', '1', '140224207', null, '3', '1'),
('140224208', '140224', '白崖台乡', '1', '140224208', null, '3', '1'),
('140224210', '140224', '红石塄乡', '1', '140224210', null, '3', '1'),
('140224212', '140224', '下关乡', '1', '140224212', null, '3', '1'),
('140224213', '140224', '独峪乡', '1', '140224213', null, '3', '1'),
('140225100', '140225', '永安镇', '1', '140225100', null, '3', '1'),
('140225101', '140225', '西坊城镇', '1', '140225101', null, '3', '1'),
('140225102', '140225', '蔡村镇', '1', '140225102', null, '3', '1'),
('140225103', '140225', '沙圪坨镇', '1', '140225103', null, '3', '1'),
('140225104', '140225', '王庄堡镇', '1', '140225104', null, '3', '1'),
('140225105', '140225', '大磁窑镇', '1', '140225105', null, '3', '1'),
('140225201', '140225', '东坊城乡', '1', '140225201', null, '3', '1'),
('140225203', '140225', '裴村乡', '1', '140225203', null, '3', '1'),
('140225204', '140225', '驼峰乡', '1', '140225204', null, '3', '1'),
('140225205', '140225', '西留村乡', '1', '140225205', null, '3', '1'),
('140225206', '140225', '下韩村乡', '1', '140225206', null, '3', '1'),
('140225208', '140225', '南榆林乡', '1', '140225208', null, '3', '1'),
('140225210', '140225', '吴城乡', '1', '140225210', null, '3', '1'),
('140225212', '140225', '黄花滩乡', '1', '140225212', null, '3', '1'),
('140225213', '140225', '大仁庄乡', '1', '140225213', null, '3', '1'),
('140225215', '140225', '千佛岭乡', '1', '140225215', null, '3', '1'),
('140225218', '140225', '官儿乡', '1', '140225218', null, '3', '1'),
('140225220', '140225', '青磁窑乡', '1', '140225220', null, '3', '1'),
('140226100', '140226', '云兴镇', '1', '140226100', null, '3', '1'),
('140226101', '140226', '鹊儿山镇', '1', '140226101', null, '3', '1'),
('140226102', '140226', '店湾镇', '1', '140226102', null, '3', '1'),
('140226200', '140226', '管家堡乡', '1', '140226200', null, '3', '1'),
('140226201', '140226', '张家场乡', '1', '140226201', null, '3', '1'),
('140226205', '140226', '三屯乡', '1', '140226205', null, '3', '1'),
('140226206', '140226', '马道头乡', '1', '140226206', null, '3', '1'),
('140226207', '140226', '小京庄乡', '1', '140226207', null, '3', '1'),
('140226209', '140226', '水窑乡', '1', '140226209', null, '3', '1'),
('140227001', '140227', '湖东街道', '1', '140227001', null, '3', '1'),
('140227002', '140227', '东街街道', '1', '140227002', null, '3', '1'),
('140227003', '140227', '西街街道', '1', '140227003', null, '3', '1'),
('140227100', '140227', '西坪镇', '1', '140227100', null, '3', '1'),
('140227101', '140227', '倍加造镇', '1', '140227101', null, '3', '1'),
('140227102', '140227', '周士庄镇', '1', '140227102', null, '3', '1'),
('140227201', '140227', '吉家庄乡', '1', '140227201', null, '3', '1'),
('140227202', '140227', '峰峪乡', '1', '140227202', null, '3', '1'),
('140227204', '140227', '杜庄乡', '1', '140227204', null, '3', '1'),
('140227205', '140227', '党留庄乡', '1', '140227205', null, '3', '1'),
('140227207', '140227', '瓜园乡', '1', '140227207', null, '3', '1'),
('140227209', '140227', '巨乐乡', '1', '140227209', null, '3', '1'),
('140227211', '140227', '许堡乡', '1', '140227211', null, '3', '1'),
('140227400', '140227', '经济技术开发区', '1', '140227400', null, '3', '1'),
('140302001', '140302', '上站街道', '1', '140302001', null, '3', '1'),
('140302002', '140302', '下站街道', '1', '140302002', null, '3', '1'),
('140302003', '140302', '北大街街道', '1', '140302003', null, '3', '1'),
('140302004', '140302', '南山路街道', '1', '140302004', null, '3', '1'),
('140302005', '140302', '义井街道', '1', '140302005', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('140302006', '140302', '坡底街道', '1', '140302006', null, '3', '1'),
('140303001', '140303', '平潭街街道', '1', '140303001', null, '3', '1'),
('140303002', '140303', '桥头街道', '1', '140303002', null, '3', '1'),
('140303003', '140303', '蔡洼街道', '1', '140303003', null, '3', '1'),
('140303004', '140303', '赛鱼街道', '1', '140303004', null, '3', '1'),
('140303005', '140303', '沙坪街道', '1', '140303005', null, '3', '1'),
('140303006', '140303', '贵石沟街道', '1', '140303006', null, '3', '1'),
('140311100', '140311', '荫营镇', '1', '140311100', null, '3', '1'),
('140311101', '140311', '河底镇', '1', '140311101', null, '3', '1'),
('140311102', '140311', '义井镇', '1', '140311102', null, '3', '1'),
('140311103', '140311', '平坦镇', '1', '140311103', null, '3', '1'),
('140311200', '140311', '西南舁乡', '1', '140311200', null, '3', '1'),
('140311201', '140311', '杨家庄乡', '1', '140311201', null, '3', '1'),
('140311202', '140311', '李家庄乡', '1', '140311202', null, '3', '1'),
('140311203', '140311', '旧街乡', '1', '140311203', null, '3', '1'),
('140311450', '140311', '开发区', '1', '140311450', null, '3', '1'),
('140321100', '140321', '冠山镇', '1', '140321100', null, '3', '1'),
('140321101', '140321', '冶西镇', '1', '140321101', null, '3', '1'),
('140321102', '140321', '锁簧镇', '1', '140321102', null, '3', '1'),
('140321103', '140321', '张庄镇', '1', '140321103', null, '3', '1'),
('140321104', '140321', '东回镇', '1', '140321104', null, '3', '1'),
('140321105', '140321', '柏井镇', '1', '140321105', null, '3', '1'),
('140321106', '140321', '娘子关镇', '1', '140321106', null, '3', '1'),
('140321107', '140321', '巨城镇', '1', '140321107', null, '3', '1'),
('140321200', '140321', '石门口乡', '1', '140321200', null, '3', '1'),
('140321201', '140321', '岔口乡', '1', '140321201', null, '3', '1'),
('140322100', '140322', '秀水镇', '1', '140322100', null, '3', '1'),
('140322101', '140322', '孙家庄镇', '1', '140322101', null, '3', '1'),
('140322102', '140322', '路家村镇', '1', '140322102', null, '3', '1'),
('140322103', '140322', '南娄镇', '1', '140322103', null, '3', '1'),
('140322104', '140322', '牛村镇', '1', '140322104', null, '3', '1'),
('140322105', '140322', '长池镇', '1', '140322105', null, '3', '1'),
('140322106', '140322', '上社镇', '1', '140322106', null, '3', '1'),
('140322107', '140322', '西烟镇', '1', '140322107', null, '3', '1'),
('140322200', '140322', '仙人乡', '1', '140322200', null, '3', '1'),
('140322201', '140322', '北下庄乡', '1', '140322201', null, '3', '1'),
('140322202', '140322', '下社乡', '1', '140322202', null, '3', '1'),
('140322203', '140322', '梁家寨乡', '1', '140322203', null, '3', '1'),
('140322204', '140322', '西潘乡', '1', '140322204', null, '3', '1'),
('140322205', '140322', '东梁乡', '1', '140322205', null, '3', '1'),
('140402001', '140402', '东街街道', '1', '140402001', null, '3', '1'),
('140402002', '140402', '西街街道', '1', '140402002', null, '3', '1'),
('140402003', '140402', '英雄南路街道', '1', '140402003', null, '3', '1'),
('140402004', '140402', '英雄中路街道', '1', '140402004', null, '3', '1'),
('140402005', '140402', '紫金路街道', '1', '140402005', null, '3', '1'),
('140402006', '140402', '太东街道', '1', '140402006', null, '3', '1'),
('140402007', '140402', '太西街道', '1', '140402007', null, '3', '1'),
('140402008', '140402', '延安南路街道', '1', '140402008', null, '3', '1'),
('140402009', '140402', '常青街道', '1', '140402009', null, '3', '1'),
('140402010', '140402', '五马街道', '1', '140402010', null, '3', '1'),
('140402400', '140402', '长治市高新技术开发区', '1', '140402400', null, '3', '1'),
('140411001', '140411', '长北街道', '1', '140411001', null, '3', '1'),
('140411002', '140411', '故县街道', '1', '140411002', null, '3', '1'),
('140411100', '140411', '老顶山镇', '1', '140411100', null, '3', '1'),
('140411101', '140411', '堠北庄镇', '1', '140411101', null, '3', '1'),
('140411102', '140411', '大辛庄镇', '1', '140411102', null, '3', '1'),
('140411103', '140411', '马厂镇', '1', '140411103', null, '3', '1'),
('140411104', '140411', '黄碾镇', '1', '140411104', null, '3', '1'),
('140411200', '140411', '西白兔乡', '1', '140411200', null, '3', '1'),
('140421100', '140421', '韩店镇', '1', '140421100', null, '3', '1'),
('140421101', '140421', '苏店镇', '1', '140421101', null, '3', '1'),
('140421102', '140421', '荫城镇', '1', '140421102', null, '3', '1'),
('140421103', '140421', '西火镇', '1', '140421103', null, '3', '1'),
('140421104', '140421', '八义镇', '1', '140421104', null, '3', '1'),
('140421105', '140421', '贾掌镇', '1', '140421105', null, '3', '1'),
('140421200', '140421', '郝家庄乡', '1', '140421200', null, '3', '1'),
('140421201', '140421', '西池乡', '1', '140421201', null, '3', '1'),
('140421202', '140421', '北呈乡', '1', '140421202', null, '3', '1'),
('140421203', '140421', '东和乡', '1', '140421203', null, '3', '1'),
('140421204', '140421', '南宋乡', '1', '140421204', null, '3', '1'),
('140423100', '140423', '古韩镇', '1', '140423100', null, '3', '1'),
('140423101', '140423', '王桥镇', '1', '140423101', null, '3', '1'),
('140423102', '140423', '侯堡镇', '1', '140423102', null, '3', '1'),
('140423103', '140423', '夏店镇', '1', '140423103', null, '3', '1'),
('140423104', '140423', '虎（音si）亭镇', '1', '140423104', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('140423105', '140423', '西营镇', '1', '140423105', null, '3', '1'),
('140423106', '140423', '王村镇', '1', '140423106', null, '3', '1'),
('140423107', '140423', '下良镇', '1', '140423107', null, '3', '1'),
('140423200', '140423', '善福乡', '1', '140423200', null, '3', '1'),
('140423201', '140423', '北底乡', '1', '140423201', null, '3', '1'),
('140423202', '140423', '上马乡', '1', '140423202', null, '3', '1'),
('140424100', '140424', '麟绛镇', '1', '140424100', null, '3', '1'),
('140424101', '140424', '上村镇', '1', '140424101', null, '3', '1'),
('140424102', '140424', '渔泽镇', '1', '140424102', null, '3', '1'),
('140424103', '140424', '余吾镇', '1', '140424103', null, '3', '1'),
('140424104', '140424', '吾元镇', '1', '140424104', null, '3', '1'),
('140424105', '140424', '张店镇', '1', '140424105', null, '3', '1'),
('140424106', '140424', '丰宜镇', '1', '140424106', null, '3', '1'),
('140424200', '140424', '李高乡', '1', '140424200', null, '3', '1'),
('140424201', '140424', '路村乡', '1', '140424201', null, '3', '1'),
('140424202', '140424', '河神庙乡', '1', '140424202', null, '3', '1'),
('140424203', '140424', '西贾乡', '1', '140424203', null, '3', '1'),
('140424400', '140424', '西流寨开发区', '1', '140424400', null, '3', '1'),
('140424401', '140424', '康庄工业园区', '1', '140424401', null, '3', '1'),
('140424402', '140424', '上莲开发区', '1', '140424402', null, '3', '1'),
('140425100', '140425', '青羊镇', '1', '140425100', null, '3', '1'),
('140425101', '140425', '龙溪镇', '1', '140425101', null, '3', '1'),
('140425102', '140425', '石城镇', '1', '140425102', null, '3', '1'),
('140425103', '140425', '苗庄镇', '1', '140425103', null, '3', '1'),
('140425104', '140425', '杏城镇', '1', '140425104', null, '3', '1'),
('140425200', '140425', '西沟乡', '1', '140425200', null, '3', '1'),
('140425201', '140425', '东寺头乡', '1', '140425201', null, '3', '1'),
('140425202', '140425', '虹梯关乡', '1', '140425202', null, '3', '1'),
('140425203', '140425', '阳高乡', '1', '140425203', null, '3', '1'),
('140425204', '140425', '北耽车乡', '1', '140425204', null, '3', '1'),
('140425205', '140425', '中五井乡', '1', '140425205', null, '3', '1'),
('140425206', '140425', '北社乡', '1', '140425206', null, '3', '1'),
('140426100', '140426', '黎侯镇', '1', '140426100', null, '3', '1'),
('140426101', '140426', '东阳关镇', '1', '140426101', null, '3', '1'),
('140426102', '140426', '上遥镇', '1', '140426102', null, '3', '1'),
('140426103', '140426', '西井镇', '1', '140426103', null, '3', '1'),
('140426104', '140426', '黄崖洞镇', '1', '140426104', null, '3', '1'),
('140426200', '140426', '西仵乡', '1', '140426200', null, '3', '1'),
('140426201', '140426', '停河铺乡', '1', '140426201', null, '3', '1'),
('140426202', '140426', '程家山乡', '1', '140426202', null, '3', '1'),
('140426203', '140426', '洪井乡', '1', '140426203', null, '3', '1'),
('140427100', '140427', '龙泉镇', '1', '140427100', null, '3', '1'),
('140427101', '140427', '百尺镇', '1', '140427101', null, '3', '1'),
('140427102', '140427', '店上镇', '1', '140427102', null, '3', '1'),
('140427103', '140427', '晋庄镇', '1', '140427103', null, '3', '1'),
('140427104', '140427', '树掌镇', '1', '140427104', null, '3', '1'),
('140427200', '140427', '集店乡', '1', '140427200', null, '3', '1'),
('140427201', '140427', '黄山乡', '1', '140427201', null, '3', '1'),
('140427202', '140427', '东井岭乡', '1', '140427202', null, '3', '1'),
('140427203', '140427', '石坡乡', '1', '140427203', null, '3', '1'),
('140427204', '140427', '五龙山乡', '1', '140427204', null, '3', '1'),
('140427205', '140427', '鹅屋乡', '1', '140427205', null, '3', '1'),
('140427206', '140427', '桥上乡', '1', '140427206', null, '3', '1'),
('140427400', '140427', '常平经济开发区', '1', '140427400', null, '3', '1'),
('140428100', '140428', '丹朱镇', '1', '140428100', null, '3', '1'),
('140428101', '140428', '鲍店镇', '1', '140428101', null, '3', '1'),
('140428102', '140428', '石哲镇', '1', '140428102', null, '3', '1'),
('140428103', '140428', '大堡头镇', '1', '140428103', null, '3', '1'),
('140428104', '140428', '慈林镇', '1', '140428104', null, '3', '1'),
('140428105', '140428', '色头镇', '1', '140428105', null, '3', '1'),
('140428106', '140428', '南漳镇', '1', '140428106', null, '3', '1'),
('140428200', '140428', '岚水乡', '1', '140428200', null, '3', '1'),
('140428201', '140428', '碾张乡', '1', '140428201', null, '3', '1'),
('140428202', '140428', '常张乡', '1', '140428202', null, '3', '1'),
('140428203', '140428', '南陈乡', '1', '140428203', null, '3', '1'),
('140428204', '140428', '宋村乡', '1', '140428204', null, '3', '1'),
('140429100', '140429', '丰州镇', '1', '140429100', null, '3', '1'),
('140429101', '140429', '洪水镇', '1', '140429101', null, '3', '1'),
('140429102', '140429', '蟠龙镇', '1', '140429102', null, '3', '1'),
('140429103', '140429', '监漳镇', '1', '140429103', null, '3', '1'),
('140429104', '140429', '故城镇', '1', '140429104', null, '3', '1'),
('140429200', '140429', '墨镫乡', '1', '140429200', null, '3', '1'),
('140429201', '140429', '韩北乡', '1', '140429201', null, '3', '1'),
('140429202', '140429', '大有乡', '1', '140429202', null, '3', '1'),
('140429203', '140429', '贾豁乡', '1', '140429203', null, '3', '1'),
('140429204', '140429', '故县乡', '1', '140429204', null, '3', '1'),
('140429205', '140429', '上司乡', '1', '140429205', null, '3', '1'),
('140429206', '140429', '石北乡', '1', '140429206', null, '3', '1'),
('140429207', '140429', '涌泉乡', '1', '140429207', null, '3', '1'),
('140429208', '140429', '分水岭乡', '1', '140429208', null, '3', '1'),
('140430100', '140430', '定昌镇', '1', '140430100', null, '3', '1'),
('140430101', '140430', '郭村镇', '1', '140430101', null, '3', '1'),
('140430102', '140430', '故县镇', '1', '140430102', null, '3', '1'),
('140430103', '140430', '新店镇', '1', '140430103', null, '3', '1'),
('140430104', '140430', '漳源镇', '1', '140430104', null, '3', '1'),
('140430105', '140430', '册村镇', '1', '140430105', null, '3', '1'),
('140430200', '140430', '段柳乡', '1', '140430200', null, '3', '1'),
('140430201', '140430', '松村乡', '1', '140430201', null, '3', '1'),
('140430202', '140430', '次村乡', '1', '140430202', null, '3', '1'),
('140430203', '140430', '牛寺乡', '1', '140430203', null, '3', '1'),
('140430204', '140430', '南里乡', '1', '140430204', null, '3', '1'),
('140430205', '140430', '南泉乡', '1', '140430205', null, '3', '1'),
('140430206', '140430', '杨安乡', '1', '140430206', null, '3', '1'),
('140431100', '140431', '沁河镇', '1', '140431100', null, '3', '1'),
('140431101', '140431', '郭道镇', '1', '140431101', null, '3', '1'),
('140431102', '140431', '灵空山镇', '1', '140431102', null, '3', '1'),
('140431103', '140431', '王和镇', '1', '140431103', null, '3', '1'),
('140431104', '140431', '李元镇', '1', '140431104', null, '3', '1'),
('140431200', '140431', '中峪乡', '1', '140431200', null, '3', '1'),
('140431201', '140431', '法中乡', '1', '140431201', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('140431202', '140431', '交口乡', '1', '140431202', null, '3', '1'),
('140431203', '140431', '聪子峪乡', '1', '140431203', null, '3', '1'),
('140431204', '140431', '韩洪乡', '1', '140431204', null, '3', '1'),
('140431205', '140431', '官滩乡', '1', '140431205', null, '3', '1'),
('140431206', '140431', '景凤乡', '1', '140431206', null, '3', '1'),
('140431207', '140431', '赤石桥乡', '1', '140431207', null, '3', '1'),
('140431208', '140431', '王陶乡', '1', '140431208', null, '3', '1'),
('140481001', '140481', '潞华', '1', '140481001', null, '3', '1'),
('140481002', '140481', '成家川', '1', '140481002', null, '3', '1'),
('140481100', '140481', '店上镇', '1', '140481100', null, '3', '1'),
('140481101', '140481', '微子镇', '1', '140481101', null, '3', '1'),
('140481102', '140481', '辛安泉镇', '1', '140481102', null, '3', '1'),
('140481103', '140481', '翟店镇', '1', '140481103', null, '3', '1'),
('140481200', '140481', '合室乡', '1', '140481200', null, '3', '1'),
('140481201', '140481', '黄牛蹄乡', '1', '140481201', null, '3', '1'),
('140481202', '140481', '史回乡', '1', '140481202', null, '3', '1'),
('140502001', '140502', '东街街道', '1', '140502001', null, '3', '1'),
('140502002', '140502', '西街街道', '1', '140502002', null, '3', '1'),
('140502003', '140502', '南街街道', '1', '140502003', null, '3', '1'),
('140502004', '140502', '北街街道', '1', '140502004', null, '3', '1'),
('140502005', '140502', '矿区街道', '1', '140502005', null, '3', '1'),
('140502006', '140502', '钟家庄街道', '1', '140502006', null, '3', '1'),
('140502007', '140502', '西上庄街道', '1', '140502007', null, '3', '1'),
('140502100', '140502', '北石店镇', '1', '140502100', null, '3', '1'),
('140521100', '140521', '龙港镇', '1', '140521100', null, '3', '1'),
('140521101', '140521', '中村镇', '1', '140521101', null, '3', '1'),
('140521102', '140521', '郑庄镇', '1', '140521102', null, '3', '1'),
('140521103', '140521', '端氏镇', '1', '140521103', null, '3', '1'),
('140521104', '140521', '嘉峰镇', '1', '140521104', null, '3', '1'),
('140521105', '140521', '郑村镇', '1', '140521105', null, '3', '1'),
('140521106', '140521', '柿庄镇', '1', '140521106', null, '3', '1'),
('140521200', '140521', '樊村河乡', '1', '140521200', null, '3', '1'),
('140521201', '140521', '土沃乡', '1', '140521201', null, '3', '1'),
('140521202', '140521', '张村乡', '1', '140521202', null, '3', '1'),
('140521203', '140521', '苏庄乡', '1', '140521203', null, '3', '1'),
('140521204', '140521', '胡底乡', '1', '140521204', null, '3', '1'),
('140521205', '140521', '固县乡', '1', '140521205', null, '3', '1'),
('140521206', '140521', '十里乡', '1', '140521206', null, '3', '1'),
('140522001', '140522', '东城街道', '1', '140522001', null, '3', '1'),
('140522100', '140522', '凤城镇', '1', '140522100', null, '3', '1'),
('140522101', '140522', '北留镇', '1', '140522101', null, '3', '1'),
('140522102', '140522', '润城镇', '1', '140522102', null, '3', '1'),
('140522103', '140522', '町店镇', '1', '140522103', null, '3', '1'),
('140522104', '140522', '芹池镇', '1', '140522104', null, '3', '1'),
('140522105', '140522', '次营镇', '1', '140522105', null, '3', '1'),
('140522106', '140522', '横河镇', '1', '140522106', null, '3', '1'),
('140522107', '140522', '河北镇', '1', '140522107', null, '3', '1'),
('140522108', '140522', '蟒河镇', '1', '140522108', null, '3', '1'),
('140522109', '140522', '东冶镇', '1', '140522109', null, '3', '1'),
('140522200', '140522', '白桑乡', '1', '140522200', null, '3', '1'),
('140522201', '140522', '寺头乡', '1', '140522201', null, '3', '1'),
('140522202', '140522', '西河乡', '1', '140522202', null, '3', '1'),
('140522203', '140522', '演礼乡', '1', '140522203', null, '3', '1'),
('140522204', '140522', '固隆乡', '1', '140522204', null, '3', '1'),
('140522205', '140522', '董封乡', '1', '140522205', null, '3', '1'),
('140522206', '140522', '驾岭乡', '1', '140522206', null, '3', '1'),
('140524100', '140524', '崇文镇', '1', '140524100', null, '3', '1'),
('140524101', '140524', '礼义镇', '1', '140524101', null, '3', '1'),
('140524102', '140524', '附城镇', '1', '140524102', null, '3', '1'),
('140524103', '140524', '西河底镇', '1', '140524103', null, '3', '1'),
('140524104', '140524', '平城镇', '1', '140524104', null, '3', '1'),
('140524105', '140524', '杨村镇', '1', '140524105', null, '3', '1'),
('140524106', '140524', '潞城镇', '1', '140524106', null, '3', '1'),
('140524204', '140524', '夺火乡', '1', '140524204', null, '3', '1'),
('140524206', '140524', '马圪当乡', '1', '140524206', null, '3', '1'),
('140524207', '140524', '古郊乡', '1', '140524207', null, '3', '1'),
('140524209', '140524', '六泉乡', '1', '140524209', null, '3', '1'),
('140524212', '140524', '秦家庄乡', '1', '140524212', null, '3', '1'),
('140525100', '140525', '南村镇', '1', '140525100', null, '3', '1'),
('140525101', '140525', '下村镇', '1', '140525101', null, '3', '1'),
('140525102', '140525', '大东沟镇', '1', '140525102', null, '3', '1'),
('140525103', '140525', '周村镇', '1', '140525103', null, '3', '1'),
('140525104', '140525', '犁川镇', '1', '140525104', null, '3', '1'),
('140525105', '140525', '晋庙铺镇', '1', '140525105', null, '3', '1'),
('140525106', '140525', '金村镇', '1', '140525106', null, '3', '1'),
('140525107', '140525', '高都镇', '1', '140525107', null, '3', '1'),
('140525108', '140525', '巴公镇', '1', '140525108', null, '3', '1'),
('140525109', '140525', '大阳镇', '1', '140525109', null, '3', '1'),
('140525110', '140525', '山河镇', '1', '140525110', null, '3', '1'),
('140525111', '140525', '大箕镇', '1', '140525111', null, '3', '1'),
('140525112', '140525', '柳树口镇', '1', '140525112', null, '3', '1'),
('140525113', '140525', '北义城镇', '1', '140525113', null, '3', '1'),
('140525200', '140525', '川底乡', '1', '140525200', null, '3', '1'),
('140525201', '140525', '李寨乡', '1', '140525201', null, '3', '1'),
('140525202', '140525', '南岭乡', '1', '140525202', null, '3', '1'),
('140581001', '140581', '北城街道', '1', '140581001', null, '3', '1'),
('140581002', '140581', '东城街道', '1', '140581002', null, '3', '1'),
('140581003', '140581', '南城街道', '1', '140581003', null, '3', '1'),
('140581101', '140581', '米山镇', '1', '140581101', null, '3', '1'),
('140581102', '140581', '三甲镇', '1', '140581102', null, '3', '1'),
('140581103', '140581', '神农镇', '1', '140581103', null, '3', '1'),
('140581104', '140581', '陈区镇', '1', '140581104', null, '3', '1'),
('140581105', '140581', '北诗镇', '1', '140581105', null, '3', '1'),
('140581106', '140581', '河西镇', '1', '140581106', null, '3', '1'),
('140581107', '140581', '马村镇', '1', '140581107', null, '3', '1'),
('140581108', '140581', '野川镇', '1', '140581108', null, '3', '1'),
('140581109', '140581', '寺庄镇', '1', '140581109', null, '3', '1'),
('140581201', '140581', '建宁乡', '1', '140581201', null, '3', '1'),
('140581202', '140581', '石末乡', '1', '140581202', null, '3', '1'),
('140581203', '140581', '原村乡', '1', '140581203', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('140581204', '140581', '永录乡', '1', '140581204', null, '3', '1'),
('140602001', '140602', '朔城区北城街道', '1', '140602001', null, '3', '1'),
('140602002', '140602', '朔城区南城街道', '1', '140602002', null, '3', '1'),
('140602003', '140602', '朔城区神头街道', '1', '140602003', null, '3', '1'),
('140602004', '140602', '朔城区北旺庄街道', '1', '140602004', null, '3', '1'),
('140602100', '140602', '朔城区神头镇', '1', '140602100', null, '3', '1'),
('140602101', '140602', '朔城区利民镇', '1', '140602101', null, '3', '1'),
('140602200', '140602', '朔城区下团堡乡', '1', '140602200', null, '3', '1'),
('140602201', '140602', '朔城区小平易乡', '1', '140602201', null, '3', '1'),
('140602202', '140602', '朔城区滋润乡', '1', '140602202', null, '3', '1'),
('140602203', '140602', '朔城区福善庄乡', '1', '140602203', null, '3', '1'),
('140602204', '140602', '朔城区南榆林乡', '1', '140602204', null, '3', '1'),
('140602205', '140602', '朔城区贾庄乡', '1', '140602205', null, '3', '1'),
('140602206', '140602', '朔城区沙塄河乡', '1', '140602206', null, '3', '1'),
('140602207', '140602', '朔城区窑子头乡', '1', '140602207', null, '3', '1'),
('140602208', '140602', '朔城区张蔡庄乡', '1', '140602208', null, '3', '1'),
('140602400', '140602', '朔州市开发区管委会', '1', '140602400', null, '3', '1'),
('140603100', '140603', '平鲁区井坪镇', '1', '140603100', null, '3', '1'),
('140603101', '140603', '平鲁区凤凰城镇', '1', '140603101', null, '3', '1'),
('140603200', '140603', '平鲁区白堂乡', '1', '140603200', null, '3', '1'),
('140603201', '140603', '平鲁区陶村乡', '1', '140603201', null, '3', '1'),
('140603202', '140603', '平鲁区下水头乡', '1', '140603202', null, '3', '1'),
('140603203', '140603', '平鲁区双碾乡', '1', '140603203', null, '3', '1'),
('140603204', '140603', '平鲁区阻虎乡', '1', '140603204', null, '3', '1'),
('140603205', '140603', '平鲁区高石庄乡', '1', '140603205', null, '3', '1'),
('140603206', '140603', '平鲁区西水界乡', '1', '140603206', null, '3', '1'),
('140603207', '140603', '平鲁区下面高乡', '1', '140603207', null, '3', '1'),
('140603208', '140603', '平鲁区下木角乡', '1', '140603208', null, '3', '1'),
('140603209', '140603', '平鲁区向阳堡乡', '1', '140603209', null, '3', '1'),
('140603210', '140603', '平鲁区榆岭乡', '1', '140603210', null, '3', '1'),
('140621001', '140621', '东城管委会', '1', '140621001', null, '3', '1'),
('140621002', '140621', '西城管委会', '1', '140621002', null, '3', '1'),
('140621100', '140621', '玉井镇', '1', '140621100', null, '3', '1'),
('140621101', '140621', '北周庄镇', '1', '140621101', null, '3', '1'),
('140621102', '140621', '古城镇', '1', '140621102', null, '3', '1'),
('140621200', '140621', '吴马营乡', '1', '140621200', null, '3', '1'),
('140621201', '140621', '马营乡', '1', '140621201', null, '3', '1'),
('140621202', '140621', '下喇叭乡', '1', '140621202', null, '3', '1'),
('140621203', '140621', '合盛堡乡', '1', '140621203', null, '3', '1'),
('140621204', '140621', '岱岳乡', '1', '140621204', null, '3', '1'),
('140621205', '140621', '安荣乡', '1', '140621205', null, '3', '1'),
('140621206', '140621', '薛OO乡', '1', '140621206', null, '3', '1'),
('140621207', '140621', '后所乡', '1', '140621207', null, '3', '1'),
('140621208', '140621', '张家庄乡', '1', '140621208', null, '3', '1'),
('140621209', '140621', '马营庄乡', '1', '140621209', null, '3', '1'),
('140622100', '140622', '金城镇', '1', '140622100', null, '3', '1'),
('140622101', '140622', '南河种镇', '1', '140622101', null, '3', '1'),
('140622102', '140622', '下社镇', '1', '140622102', null, '3', '1'),
('140622200', '140622', '镇子梁乡', '1', '140622200', null, '3', '1'),
('140622201', '140622', '义井乡', '1', '140622201', null, '3', '1'),
('140622202', '140622', '藏寨乡', '1', '140622202', null, '3', '1'),
('140622203', '140622', '大黄巍乡', '1', '140622203', null, '3', '1'),
('140622204', '140622', '杏寨乡', '1', '140622204', null, '3', '1'),
('140622205', '140622', '下马峪乡', '1', '140622205', null, '3', '1'),
('140622206', '140622', '南泉乡', '1', '140622206', null, '3', '1'),
('140622207', '140622', '大临河乡', '1', '140622207', null, '3', '1'),
('140622208', '140622', '白马石乡', '1', '140622208', null, '3', '1'),
('140623100', '140623', '新城镇', '1', '140623100', null, '3', '1'),
('140623101', '140623', '右卫镇', '1', '140623101', null, '3', '1'),
('140623102', '140623', '威远镇', '1', '140623102', null, '3', '1'),
('140623103', '140623', '元堡子镇', '1', '140623103', null, '3', '1'),
('140623200', '140623', '牛心堡乡', '1', '140623200', null, '3', '1'),
('140623201', '140623', '白头里乡', '1', '140623201', null, '3', '1'),
('140623202', '140623', '高家堡乡', '1', '140623202', null, '3', '1'),
('140623203', '140623', '丁家窑乡', '1', '140623203', null, '3', '1'),
('140623204', '140623', '杨千河乡', '1', '140623204', null, '3', '1'),
('140623205', '140623', '李达窑乡', '1', '140623205', null, '3', '1'),
('140624100', '140624', '云中镇', '1', '140624100', null, '3', '1'),
('140624101', '140624', '吴家窑镇', '1', '140624101', null, '3', '1'),
('140624102', '140624', '金沙滩镇', '1', '140624102', null, '3', '1'),
('140624103', '140624', '毛家皂镇', '1', '140624103', null, '3', '1'),
('140624200', '140624', '何家堡乡', '1', '140624200', null, '3', '1'),
('140624201', '140624', '新家园乡', '1', '140624201', null, '3', '1'),
('140624202', '140624', '亲和乡', '1', '140624202', null, '3', '1'),
('140624203', '140624', '海北头乡', '1', '140624203', null, '3', '1'),
('140624204', '140624', '马辛庄乡', '1', '140624204', null, '3', '1'),
('140624205', '140624', '河头乡', '1', '140624205', null, '3', '1'),
('140624500', '140624', '金沙滩农牧场', '1', '140624500', null, '3', '1'),
('140624501', '140624', '金沙滩林场', '1', '140624501', null, '3', '1'),
('140702001', '140702', '北关街道', '1', '140702001', null, '3', '1'),
('140702002', '140702', '锦纶街道', '1', '140702002', null, '3', '1'),
('140702003', '140702', '新华街道', '1', '140702003', null, '3', '1'),
('140702004', '140702', '西南街道', '1', '140702004', null, '3', '1'),
('140702005', '140702', '路西街道', '1', '140702005', null, '3', '1'),
('140702006', '140702', '经纬街道', '1', '140702006', null, '3', '1'),
('140702007', '140702', '安宁街道', '1', '140702007', null, '3', '1'),
('140702008', '140702', '新建街道', '1', '140702008', null, '3', '1'),
('140702009', '140702', '晋华街道', '1', '140702009', null, '3', '1'),
('140702100', '140702', '乌金山镇', '1', '140702100', null, '3', '1'),
('140702101', '140702', '东阳镇', '1', '140702101', null, '3', '1'),
('140702102', '140702', '什贴镇', '1', '140702102', null, '3', '1'),
('140702103', '140702', '长凝镇', '1', '140702103', null, '3', '1'),
('140702104', '140702', '北田镇', '1', '140702104', null, '3', '1'),
('140702105', '140702', '修文镇', '1', '140702105', null, '3', '1'),
('140702200', '140702', '郭家堡乡', '1', '140702200', null, '3', '1'),
('140702201', '140702', '张庆乡', '1', '140702201', null, '3', '1'),
('140702202', '140702', '庄子乡', '1', '140702202', null, '3', '1'),
('140702203', '140702', '东赵乡', '1', '140702203', null, '3', '1'),
('140702400', '140702', '晋中经济开发区', '1', '140702400', null, '3', '1'),
('140721001', '140721', '城区街道管理委员会', '1', '140721001', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('140721100', '140721', '箕城镇', '1', '140721100', null, '3', '1'),
('140721101', '140721', '云竹镇', '1', '140721101', null, '3', '1'),
('140721102', '140721', '郝北镇', '1', '140721102', null, '3', '1'),
('140721103', '140721', '社城镇', '1', '140721103', null, '3', '1'),
('140721200', '140721', '河峪乡', '1', '140721200', null, '3', '1'),
('140721201', '140721', '北寨乡', '1', '140721201', null, '3', '1'),
('140721202', '140721', '西马乡', '1', '140721202', null, '3', '1'),
('140721203', '140721', '岚峪乡', '1', '140721203', null, '3', '1'),
('140721204', '140721', '讲堂乡', '1', '140721204', null, '3', '1'),
('140722001', '140722', '县城街道社区管理委员会', '1', '140722001', null, '3', '1'),
('140722100', '140722', '辽阳镇', '1', '140722100', null, '3', '1'),
('140722101', '140722', '桐峪镇', '1', '140722101', null, '3', '1'),
('140722102', '140722', '麻田镇', '1', '140722102', null, '3', '1'),
('140722103', '140722', '芹泉镇', '1', '140722103', null, '3', '1'),
('140722104', '140722', '拐儿镇', '1', '140722104', null, '3', '1'),
('140722200', '140722', '寒王乡', '1', '140722200', null, '3', '1'),
('140722201', '140722', '石匣乡', '1', '140722201', null, '3', '1'),
('140722202', '140722', '龙泉乡', '1', '140722202', null, '3', '1'),
('140722203', '140722', '粟城乡', '1', '140722203', null, '3', '1'),
('140722204', '140722', '羊角乡', '1', '140722204', null, '3', '1'),
('140723100', '140723', '义兴镇', '1', '140723100', null, '3', '1'),
('140723101', '140723', '李阳镇', '1', '140723101', null, '3', '1'),
('140723102', '140723', '松烟镇', '1', '140723102', null, '3', '1'),
('140723103', '140723', '青城镇', '1', '140723103', null, '3', '1'),
('140723104', '140723', '横岭镇', '1', '140723104', null, '3', '1'),
('140723200', '140723', '喂马乡', '1', '140723200', null, '3', '1'),
('140723201', '140723', '平松乡', '1', '140723201', null, '3', '1'),
('140723202', '140723', '牛川乡', '1', '140723202', null, '3', '1'),
('140723203', '140723', '马坊乡', '1', '140723203', null, '3', '1'),
('140723204', '140723', '阳光占乡', '1', '140723204', null, '3', '1'),
('140724100', '140724', '乐平镇', '1', '140724100', null, '3', '1'),
('140724101', '140724', '皋落镇', '1', '140724101', null, '3', '1'),
('140724102', '140724', '冶头镇', '1', '140724102', null, '3', '1'),
('140724103', '140724', '沾尚镇', '1', '140724103', null, '3', '1'),
('140724104', '140724', '大寨镇', '1', '140724104', null, '3', '1'),
('140724200', '140724', '李家庄乡', '1', '140724200', null, '3', '1'),
('140724201', '140724', '界都乡', '1', '140724201', null, '3', '1'),
('140724202', '140724', '三都乡', '1', '140724202', null, '3', '1'),
('140724203', '140724', '赵壁乡', '1', '140724203', null, '3', '1'),
('140724204', '140724', '孔氏乡', '1', '140724204', null, '3', '1'),
('140724205', '140724', '阎庄乡', '1', '140724205', null, '3', '1'),
('140724206', '140724', '西寨乡', '1', '140724206', null, '3', '1'),
('140725100', '140725', '朝阳镇', '1', '140725100', null, '3', '1'),
('140725101', '140725', '南燕竹镇', '1', '140725101', null, '3', '1'),
('140725102', '140725', '宗艾镇', '1', '140725102', null, '3', '1'),
('140725103', '140725', '平头镇', '1', '140725103', null, '3', '1'),
('140725104', '140725', '松塔镇', '1', '140725104', null, '3', '1'),
('140725105', '140725', '西洛镇', '1', '140725105', null, '3', '1'),
('140725106', '140725', '尹灵芝镇', '1', '140725106', null, '3', '1'),
('140725200', '140725', '平舒乡', '1', '140725200', null, '3', '1'),
('140725201', '140725', '解愁乡', '1', '140725201', null, '3', '1'),
('140725202', '140725', '温家庄乡', '1', '140725202', null, '3', '1'),
('140725203', '140725', '景尚乡', '1', '140725203', null, '3', '1'),
('140725204', '140725', '上湖乡', '1', '140725204', null, '3', '1'),
('140725205', '140725', '羊头崖乡', '1', '140725205', null, '3', '1'),
('140725206', '140725', '马首乡', '1', '140725206', null, '3', '1'),
('140726100', '140726', '明星镇', '1', '140726100', null, '3', '1'),
('140726101', '140726', '胡村镇', '1', '140726101', null, '3', '1'),
('140726102', '140726', '范村镇', '1', '140726102', null, '3', '1'),
('140726200', '140726', '侯城乡', '1', '140726200', null, '3', '1'),
('140726201', '140726', '北汪乡', '1', '140726201', null, '3', '1'),
('140726202', '140726', '水秀乡', '1', '140726202', null, '3', '1'),
('140726203', '140726', '阳邑乡', '1', '140726203', null, '3', '1'),
('140726204', '140726', '小白乡', '1', '140726204', null, '3', '1'),
('140726205', '140726', '任村乡', '1', '140726205', null, '3', '1'),
('140727100', '140727', '昭馀镇', '1', '140727100', null, '3', '1'),
('140727101', '140727', '东观镇', '1', '140727101', null, '3', '1'),
('140727102', '140727', '古县镇', '1', '140727102', null, '3', '1'),
('140727103', '140727', '贾令镇', '1', '140727103', null, '3', '1'),
('140727104', '140727', '城赵镇', '1', '140727104', null, '3', '1'),
('140727105', '140727', '来远镇', '1', '140727105', null, '3', '1'),
('140727200', '140727', '西六支乡', '1', '140727200', null, '3', '1'),
('140727201', '140727', '峪口乡', '1', '140727201', null, '3', '1'),
('140728100', '140728', '古陶镇', '1', '140728100', null, '3', '1'),
('140728101', '140728', '段村镇', '1', '140728101', null, '3', '1'),
('140728102', '140728', '东泉镇', '1', '140728102', null, '3', '1'),
('140728103', '140728', '洪善镇', '1', '140728103', null, '3', '1'),
('140728104', '140728', '宁固镇', '1', '140728104', null, '3', '1'),
('140728200', '140728', '南政乡', '1', '140728200', null, '3', '1'),
('140728201', '140728', '中都乡', '1', '140728201', null, '3', '1'),
('140728202', '140728', '岳壁乡', '1', '140728202', null, '3', '1'),
('140728203', '140728', '卜宜乡', '1', '140728203', null, '3', '1'),
('140728204', '140728', '孟山乡', '1', '140728204', null, '3', '1'),
('140728205', '140728', '朱坑乡', '1', '140728205', null, '3', '1'),
('140728206', '140728', '襄垣乡', '1', '140728206', null, '3', '1'),
('140728207', '140728', '杜家庄乡', '1', '140728207', null, '3', '1'),
('140728208', '140728', '香乐乡', '1', '140728208', null, '3', '1'),
('140729100', '140729', '翠峰镇', '1', '140729100', null, '3', '1'),
('140729101', '140729', '静升镇', '1', '140729101', null, '3', '1'),
('140729102', '140729', '两渡镇', '1', '140729102', null, '3', '1'),
('140729103', '140729', '夏门镇', '1', '140729103', null, '3', '1'),
('140729104', '140729', '南关镇', '1', '140729104', null, '3', '1'),
('140729105', '140729', '段纯镇', '1', '140729105', null, '3', '1'),
('140729200', '140729', '马和乡', '1', '140729200', null, '3', '1'),
('140729201', '140729', '英武乡', '1', '140729201', null, '3', '1'),
('140729202', '140729', '王禹乡', '1', '140729202', null, '3', '1'),
('140729203', '140729', '坛镇乡', '1', '140729203', null, '3', '1'),
('140729204', '140729', '梁家焉乡', '1', '140729204', null, '3', '1'),
('140729205', '140729', '交口乡', '1', '140729205', null, '3', '1'),
('140781001', '140781', '北关街道', '1', '140781001', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('140781002', '140781', '西关街道', '1', '140781002', null, '3', '1'),
('140781003', '140781', '东南街道', '1', '140781003', null, '3', '1'),
('140781004', '140781', '西南街道', '1', '140781004', null, '3', '1'),
('140781005', '140781', '北坛街道', '1', '140781005', null, '3', '1'),
('140781100', '140781', '义安镇', '1', '140781100', null, '3', '1'),
('140781101', '140781', '张兰镇', '1', '140781101', null, '3', '1'),
('140781102', '140781', '连福镇', '1', '140781102', null, '3', '1'),
('140781103', '140781', '洪山镇', '1', '140781103', null, '3', '1'),
('140781104', '140781', '龙凤镇', '1', '140781104', null, '3', '1'),
('140781105', '140781', '绵山镇', '1', '140781105', null, '3', '1'),
('140781106', '140781', '义棠镇', '1', '140781106', null, '3', '1'),
('140781200', '140781', '城关乡', '1', '140781200', null, '3', '1'),
('140781201', '140781', '宋古乡', '1', '140781201', null, '3', '1'),
('140781202', '140781', '三佳乡', '1', '140781202', null, '3', '1'),
('140781400', '140781', '山西省种羊场', '1', '140781400', null, '3', '1'),
('140802001', '140802', '中城街道', '1', '140802001', null, '3', '1'),
('140802002', '140802', '东城街道', '1', '140802002', null, '3', '1'),
('140802003', '140802', '西城街道', '1', '140802003', null, '3', '1'),
('140802004', '140802', '南城街道', '1', '140802004', null, '3', '1'),
('140802005', '140802', '北城街道', '1', '140802005', null, '3', '1'),
('140802006', '140802', '安邑街道', '1', '140802006', null, '3', '1'),
('140802007', '140802', '大渠街道', '1', '140802007', null, '3', '1'),
('140802008', '140802', '姚孟街道', '1', '140802008', null, '3', '1'),
('140802100', '140802', '解州镇政府', '1', '140802100', null, '3', '1'),
('140802101', '140802', '龙居镇政府', '1', '140802101', null, '3', '1'),
('140802102', '140802', '北相镇政府', '1', '140802102', null, '3', '1'),
('140802103', '140802', '泓芝驿镇政府', '1', '140802103', null, '3', '1'),
('140802104', '140802', '三路里镇政府', '1', '140802104', null, '3', '1'),
('140802105', '140802', '陶村镇政府', '1', '140802105', null, '3', '1'),
('140802106', '140802', '东郭镇政府', '1', '140802106', null, '3', '1'),
('140802200', '140802', '席张乡政府', '1', '140802200', null, '3', '1'),
('140802201', '140802', '金井乡政府', '1', '140802201', null, '3', '1'),
('140802202', '140802', '王范乡政府', '1', '140802202', null, '3', '1'),
('140802203', '140802', '冯村乡政府', '1', '140802203', null, '3', '1'),
('140802204', '140802', '上郭乡政府', '1', '140802204', null, '3', '1'),
('140802205', '140802', '上王乡政府', '1', '140802205', null, '3', '1'),
('140802400', '140802', '禹都经济技术开发区', '1', '140802400', null, '3', '1'),
('140821100', '140821', '猗氏镇', '1', '140821100', null, '3', '1'),
('140821101', '140821', '嵋阳镇', '1', '140821101', null, '3', '1'),
('140821102', '140821', '临晋镇', '1', '140821102', null, '3', '1'),
('140821103', '140821', '七级镇', '1', '140821103', null, '3', '1'),
('140821104', '140821', '东张镇', '1', '140821104', null, '3', '1'),
('140821105', '140821', '孙吉镇', '1', '140821105', null, '3', '1'),
('140821106', '140821', '三管镇', '1', '140821106', null, '3', '1'),
('140821107', '140821', '耽子镇', '1', '140821107', null, '3', '1'),
('140821200', '140821', '楚候乡', '1', '140821200', null, '3', '1'),
('140821201', '140821', '庙上乡', '1', '140821201', null, '3', '1'),
('140821202', '140821', '角杯乡', '1', '140821202', null, '3', '1'),
('140821203', '140821', '北辛乡', '1', '140821203', null, '3', '1'),
('140821204', '140821', '北景乡', '1', '140821204', null, '3', '1'),
('140821400', '140821', '牛杜工贸区', '1', '140821400', null, '3', '1'),
('140821401', '140821', '卓里工贸区', '1', '140821401', null, '3', '1'),
('140821402', '140821', '闫家庄工贸区', '1', '140821402', null, '3', '1'),
('140822100', '140822', '解店镇', '1', '140822100', null, '3', '1'),
('140822101', '140822', '通化镇', '1', '140822101', null, '3', '1'),
('140822102', '140822', '汉薛镇', '1', '140822102', null, '3', '1'),
('140822103', '140822', '荣河镇', '1', '140822103', null, '3', '1'),
('140822200', '140822', '万泉乡', '1', '140822200', null, '3', '1'),
('140822201', '140822', '里望乡', '1', '140822201', null, '3', '1'),
('140822202', '140822', '西村乡', '1', '140822202', null, '3', '1'),
('140822203', '140822', '南张乡', '1', '140822203', null, '3', '1'),
('140822204', '140822', '高村乡', '1', '140822204', null, '3', '1'),
('140822205', '140822', '皇甫乡', '1', '140822205', null, '3', '1'),
('140822206', '140822', '贾村乡', '1', '140822206', null, '3', '1'),
('140822207', '140822', '王显乡', '1', '140822207', null, '3', '1'),
('140822208', '140822', '光华乡', '1', '140822208', null, '3', '1'),
('140822209', '140822', '裴庄乡', '1', '140822209', null, '3', '1'),
('140823100', '140823', '桐城镇', '1', '140823100', null, '3', '1'),
('140823101', '140823', '郭家庄镇', '1', '140823101', null, '3', '1'),
('140823102', '140823', '凹底镇', '1', '140823102', null, '3', '1'),
('140823103', '140823', '薛店镇', '1', '140823103', null, '3', '1'),
('140823104', '140823', '东镇镇', '1', '140823104', null, '3', '1'),
('140823105', '140823', '礼元镇', '1', '140823105', null, '3', '1'),
('140823106', '140823', '河底镇', '1', '140823106', null, '3', '1'),
('140823200', '140823', '神柏乡', '1', '140823200', null, '3', '1'),
('140823201', '140823', '阳隅乡', '1', '140823201', null, '3', '1'),
('140823202', '140823', '侯村乡', '1', '140823202', null, '3', '1'),
('140823203', '140823', '裴社乡', '1', '140823203', null, '3', '1'),
('140823204', '140823', '后宫乡', '1', '140823204', null, '3', '1'),
('140823205', '140823', '石门乡', '1', '140823205', null, '3', '1'),
('140824100', '140824', '稷峰镇', '1', '140824100', null, '3', '1'),
('140824101', '140824', '西社镇', '1', '140824101', null, '3', '1'),
('140824102', '140824', '化峪镇', '1', '140824102', null, '3', '1'),
('140824103', '140824', '翟店镇', '1', '140824103', null, '3', '1'),
('140824104', '140824', '清河镇', '1', '140824104', null, '3', '1'),
('140824200', '140824', '蔡村乡', '1', '140824200', null, '3', '1'),
('140824201', '140824', '太阳乡', '1', '140824201', null, '3', '1'),
('140825100', '140825', '龙兴镇', '1', '140825100', null, '3', '1'),
('140825101', '140825', '三泉镇', '1', '140825101', null, '3', '1'),
('140825102', '140825', '泽掌镇', '1', '140825102', null, '3', '1'),
('140825103', '140825', '北张镇', '1', '140825103', null, '3', '1'),
('140825104', '140825', '横桥镇', '1', '140825104', null, '3', '1'),
('140825105', '140825', '万安镇', '1', '140825105', null, '3', '1'),
('140825106', '140825', '阳王镇', '1', '140825106', null, '3', '1'),
('140825200', '140825', '古交乡', '1', '140825200', null, '3', '1'),
('140826100', '140826', '古绛镇', '1', '140826100', null, '3', '1'),
('140826101', '140826', '横水镇', '1', '140826101', null, '3', '1'),
('140826102', '140826', '陈村镇', '1', '140826102', null, '3', '1'),
('140826103', '140826', '卫庄镇', '1', '140826103', null, '3', '1'),
('140826104', '140826', '么里镇', '1', '140826104', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('140826105', '140826', '南樊镇', '1', '140826105', null, '3', '1'),
('140826106', '140826', '安峪镇', '1', '140826106', null, '3', '1'),
('140826107', '140826', '大交镇', '1', '140826107', null, '3', '1'),
('140826200', '140826', '郝庄乡', '1', '140826200', null, '3', '1'),
('140826201', '140826', '冷口乡', '1', '140826201', null, '3', '1'),
('140827100', '140827', '新城镇', '1', '140827100', null, '3', '1'),
('140827101', '140827', '历山镇', '1', '140827101', null, '3', '1'),
('140827102', '140827', '古城镇', '1', '140827102', null, '3', '1'),
('140827103', '140827', '王茅镇', '1', '140827103', null, '3', '1'),
('140827104', '140827', '毛家镇', '1', '140827104', null, '3', '1'),
('140827200', '140827', '蒲掌乡', '1', '140827200', null, '3', '1'),
('140827201', '140827', '英言乡', '1', '140827201', null, '3', '1'),
('140827202', '140827', '解峪乡', '1', '140827202', null, '3', '1'),
('140827203', '140827', '华峰乡', '1', '140827203', null, '3', '1'),
('140827204', '140827', '长直乡', '1', '140827204', null, '3', '1'),
('140827205', '140827', '皋落乡', '1', '140827205', null, '3', '1'),
('140828100', '140828', '瑶峰镇', '1', '140828100', null, '3', '1'),
('140828101', '140828', '庙前镇', '1', '140828101', null, '3', '1'),
('140828102', '140828', '裴介镇', '1', '140828102', null, '3', '1'),
('140828103', '140828', '水头镇', '1', '140828103', null, '3', '1'),
('140828104', '140828', '埝掌镇', '1', '140828104', null, '3', '1'),
('140828105', '140828', '泗交镇', '1', '140828105', null, '3', '1'),
('140828200', '140828', '尉郭乡', '1', '140828200', null, '3', '1'),
('140828201', '140828', '禹王乡', '1', '140828201', null, '3', '1'),
('140828202', '140828', '胡张乡', '1', '140828202', null, '3', '1'),
('140828203', '140828', '南大里乡', '1', '140828203', null, '3', '1'),
('140828204', '140828', '祁家河乡', '1', '140828204', null, '3', '1'),
('140829100', '140829', '圣人涧镇', '1', '140829100', null, '3', '1'),
('140829101', '140829', '常乐镇', '1', '140829101', null, '3', '1'),
('140829102', '140829', '张店镇', '1', '140829102', null, '3', '1'),
('140829103', '140829', '张村镇', '1', '140829103', null, '3', '1'),
('140829104', '140829', '曹川镇', '1', '140829104', null, '3', '1'),
('140829105', '140829', '三门镇', '1', '140829105', null, '3', '1'),
('140829200', '140829', '洪池乡', '1', '140829200', null, '3', '1'),
('140829201', '140829', '杜马乡', '1', '140829201', null, '3', '1'),
('140829202', '140829', '部官乡', '1', '140829202', null, '3', '1'),
('140829203', '140829', '坡底乡', '1', '140829203', null, '3', '1'),
('140830100', '140830', '古巍镇', '1', '140830100', null, '3', '1'),
('140830101', '140830', '风陵渡镇', '1', '140830101', null, '3', '1'),
('140830102', '140830', '陌南镇', '1', '140830102', null, '3', '1'),
('140830103', '140830', '西陌镇', '1', '140830103', null, '3', '1'),
('140830104', '140830', '永乐镇', '1', '140830104', null, '3', '1'),
('140830105', '140830', '大王镇', '1', '140830105', null, '3', '1'),
('140830106', '140830', '阳城镇', '1', '140830106', null, '3', '1'),
('140830200', '140830', '东垆乡', '1', '140830200', null, '3', '1'),
('140830201', '140830', '南卫乡', '1', '140830201', null, '3', '1'),
('140830202', '140830', '学张乡', '1', '140830202', null, '3', '1'),
('140881001', '140881', '城西街道', '1', '140881001', null, '3', '1'),
('140881002', '140881', '城北街道', '1', '140881002', null, '3', '1'),
('140881003', '140881', '城东街道', '1', '140881003', null, '3', '1'),
('140881100', '140881', '于乡镇', '1', '140881100', null, '3', '1'),
('140881101', '140881', '卿头镇', '1', '140881101', null, '3', '1'),
('140881102', '140881', '开张镇', '1', '140881102', null, '3', '1'),
('140881103', '140881', '栲栳镇', '1', '140881103', null, '3', '1'),
('140881104', '140881', '蒲州镇', '1', '140881104', null, '3', '1'),
('140881105', '140881', '韩阳镇', '1', '140881105', null, '3', '1'),
('140881106', '140881', '张营镇', '1', '140881106', null, '3', '1'),
('140881400', '140881', '农场虚拟区', '1', '140881400', null, '3', '1'),
('140882001', '140882', '城区街道', '1', '140882001', null, '3', '1'),
('140882002', '140882', '清涧街道', '1', '140882002', null, '3', '1'),
('140882100', '140882', '樊村镇', '1', '140882100', null, '3', '1'),
('140882101', '140882', '僧楼镇', '1', '140882101', null, '3', '1'),
('140882200', '140882', '小梁乡', '1', '140882200', null, '3', '1'),
('140882201', '140882', '柴家乡', '1', '140882201', null, '3', '1'),
('140882202', '140882', '赵家庄乡', '1', '140882202', null, '3', '1'),
('140882203', '140882', '下化乡', '1', '140882203', null, '3', '1'),
('140882204', '140882', '阳村乡', '1', '140882204', null, '3', '1'),
('140882400', '140882', '山西铝厂虚拟镇', '1', '140882400', null, '3', '1'),
('140902001', '140902', '南城街道', '1', '140902001', null, '3', '1'),
('140902002', '140902', '长征街街道', '1', '140902002', null, '3', '1'),
('140902003', '140902', '新建路街道', '1', '140902003', null, '3', '1'),
('140902100', '140902', '播明镇', '1', '140902100', null, '3', '1'),
('140902101', '140902', '奇村镇', '1', '140902101', null, '3', '1'),
('140902102', '140902', '三交镇', '1', '140902102', null, '3', '1'),
('140902103', '140902', '庄磨镇', '1', '140902103', null, '3', '1'),
('140902104', '140902', '豆罗镇', '1', '140902104', null, '3', '1'),
('140902105', '140902', '董村镇', '1', '140902105', null, '3', '1'),
('140902200', '140902', '曹张乡', '1', '140902200', null, '3', '1'),
('140902201', '140902', '高城乡', '1', '140902201', null, '3', '1'),
('140902202', '140902', '秦城乡', '1', '140902202', null, '3', '1'),
('140902203', '140902', '解原乡', '1', '140902203', null, '3', '1'),
('140902204', '140902', '合索乡', '1', '140902204', null, '3', '1'),
('140902205', '140902', '阳坡乡', '1', '140902205', null, '3', '1'),
('140902206', '140902', '兰村乡', '1', '140902206', null, '3', '1'),
('140902207', '140902', '紫岩乡', '1', '140902207', null, '3', '1'),
('140902208', '140902', '西张乡', '1', '140902208', null, '3', '1'),
('140902209', '140902', '东楼乡', '1', '140902209', null, '3', '1'),
('140902210', '140902', '北义井乡', '1', '140902210', null, '3', '1'),
('140921100', '140921', '晋昌镇', '1', '140921100', null, '3', '1'),
('140921101', '140921', '河边镇', '1', '140921101', null, '3', '1'),
('140921102', '140921', '宏道镇', '1', '140921102', null, '3', '1'),
('140921200', '140921', '杨芳乡', '1', '140921200', null, '3', '1'),
('140921201', '140921', '南王乡', '1', '140921201', null, '3', '1'),
('140921202', '140921', '蒋村乡', '1', '140921202', null, '3', '1'),
('140921203', '140921', '神山乡', '1', '140921203', null, '3', '1'),
('140921204', '140921', '季庄乡', '1', '140921204', null, '3', '1'),
('140921205', '140921', '受录乡', '1', '140921205', null, '3', '1'),
('140922100', '140922', '台城镇', '1', '140922100', null, '3', '1'),
('140922101', '140922', '台怀镇', '1', '140922101', null, '3', '1'),
('140922102', '140922', '耿镇镇', '1', '140922102', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('140922103', '140922', '豆村镇', '1', '140922103', null, '3', '1'),
('140922104', '140922', '白家庄镇', '1', '140922104', null, '3', '1'),
('140922105', '140922', '东冶镇', '1', '140922105', null, '3', '1'),
('140922200', '140922', '沟南乡', '1', '140922200', null, '3', '1'),
('140922201', '140922', '东雷乡', '1', '140922201', null, '3', '1'),
('140922202', '140922', '高洪口乡', '1', '140922202', null, '3', '1'),
('140922203', '140922', '门限石乡', '1', '140922203', null, '3', '1'),
('140922204', '140922', '陈家庄乡', '1', '140922204', null, '3', '1'),
('140922205', '140922', '建安乡', '1', '140922205', null, '3', '1'),
('140922206', '140922', '神西乡', '1', '140922206', null, '3', '1'),
('140922207', '140922', '蒋坊乡', '1', '140922207', null, '3', '1'),
('140922208', '140922', '灵境乡', '1', '140922208', null, '3', '1'),
('140922209', '140922', '阳白乡', '1', '140922209', null, '3', '1'),
('140922210', '140922', '茹村乡', '1', '140922210', null, '3', '1'),
('140922211', '140922', '石咀乡', '1', '140922211', null, '3', '1'),
('140922212', '140922', '金岗库乡', '1', '140922212', null, '3', '1'),
('140923100', '140923', '上馆镇', '1', '140923100', null, '3', '1'),
('140923101', '140923', '阳明堡镇', '1', '140923101', null, '3', '1'),
('140923102', '140923', '峨口镇', '1', '140923102', null, '3', '1'),
('140923103', '140923', '聂营镇', '1', '140923103', null, '3', '1'),
('140923104', '140923', '枣林镇', '1', '140923104', null, '3', '1'),
('140923105', '140923', '滩上镇', '1', '140923105', null, '3', '1'),
('140923200', '140923', '新高乡', '1', '140923200', null, '3', '1'),
('140923201', '140923', '峪口乡', '1', '140923201', null, '3', '1'),
('140923202', '140923', '磨坊乡', '1', '140923202', null, '3', '1'),
('140923203', '140923', '胡峪乡', '1', '140923203', null, '3', '1'),
('140923204', '140923', '雁门关乡', '1', '140923204', null, '3', '1'),
('140924100', '140924', '繁城镇', '1', '140924100', null, '3', '1'),
('140924101', '140924', '砂河镇', '1', '140924101', null, '3', '1'),
('140924102', '140924', '大营镇', '1', '140924102', null, '3', '1'),
('140924200', '140924', '下茹越乡', '1', '140924200', null, '3', '1'),
('140924201', '140924', '杏园乡', '1', '140924201', null, '3', '1'),
('140924202', '140924', '光裕堡乡', '1', '140924202', null, '3', '1'),
('140924203', '140924', '集义庄乡', '1', '140924203', null, '3', '1'),
('140924204', '140924', '东山乡', '1', '140924204', null, '3', '1'),
('140924205', '140924', '金山铺乡', '1', '140924205', null, '3', '1'),
('140924206', '140924', '柏家庄乡', '1', '140924206', null, '3', '1'),
('140924207', '140924', '横涧乡', '1', '140924207', null, '3', '1'),
('140924208', '140924', '神堂堡乡', '1', '140924208', null, '3', '1'),
('140924209', '140924', '岩头乡', '1', '140924209', null, '3', '1'),
('140925001', '140925', '街道', '1', '140925001', null, '3', '1'),
('140925100', '140925', '凤凰镇', '1', '140925100', null, '3', '1'),
('140925101', '140925', '阳方口镇', '1', '140925101', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('140925102', '140925', '东寨镇', '1', '140925102', null, '3', '1'),
('140925103', '140925', '石家庄镇', '1', '140925103', null, '3', '1'),
('140925200', '140925', '薛家洼乡', '1', '140925200', null, '3', '1'),
('140925201', '140925', '余庄乡', '1', '140925201', null, '3', '1'),
('140925202', '140925', '涔山乡', '1', '140925202', null, '3', '1'),
('140925203', '140925', '化北屯乡', '1', '140925203', null, '3', '1'),
('140925204', '140925', '西马坊乡', '1', '140925204', null, '3', '1'),
('140925205', '140925', '新堡乡', '1', '140925205', null, '3', '1'),
('140925206', '140925', '迭台寺乡', '1', '140925206', null, '3', '1'),
('140925207', '140925', '圪廖乡', '1', '140925207', null, '3', '1'),
('140925208', '140925', '怀道乡', '1', '140925208', null, '3', '1'),
('140925209', '140925', '东马坊乡', '1', '140925209', null, '3', '1'),
('140925400', '140925', '阳方口煤矿生活区', '1', '140925400', null, '3', '1'),
('140926100', '140926', '鹅城镇', '1', '140926100', null, '3', '1'),
('140926101', '140926', '杜家村镇', '1', '140926101', null, '3', '1'),
('140926102', '140926', '康家会镇', '1', '140926102', null, '3', '1'),
('140926103', '140926', '丰润镇', '1', '140926103', null, '3', '1'),
('140926201', '140926', '堂尔上乡', '1', '140926201', null, '3', '1'),
('140926202', '140926', '中庄乡', '1', '140926202', null, '3', '1'),
('140926203', '140926', '双路乡', '1', '140926203', null, '3', '1'),
('140926204', '140926', '段家寨乡', '1', '140926204', null, '3', '1'),
('140926205', '140926', '辛村乡', '1', '140926205', null, '3', '1'),
('140926206', '140926', '王村乡', '1', '140926206', null, '3', '1'),
('140926207', '140926', '神峪沟乡', '1', '140926207', null, '3', '1'),
('140926208', '140926', '娘子神乡', '1', '140926208', null, '3', '1'),
('140926209', '140926', '娑婆乡', '1', '140926209', null, '3', '1'),
('140926210', '140926', '赤泥洼乡', '1', '140926210', null, '3', '1'),
('140927100', '140927', '龙泉镇', '1', '140927100', null, '3', '1'),
('140927101', '140927', '义井镇', '1', '140927101', null, '3', '1'),
('140927102', '140927', '八角镇', '1', '140927102', null, '3', '1'),
('140927200', '140927', '东湖乡', '1', '140927200', null, '3', '1'),
('140927201', '140927', '太平庄乡', '1', '140927201', null, '3', '1'),
('140927202', '140927', '虎北乡', '1', '140927202', null, '3', '1'),
('140927203', '140927', '贺职乡', '1', '140927203', null, '3', '1'),
('140927204', '140927', '长畛乡', '1', '140927204', null, '3', '1'),
('140927205', '140927', '烈堡乡', '1', '140927205', null, '3', '1'),
('140927206', '140927', '大严备乡', '1', '140927206', null, '3', '1'),
('140928100', '140928', '砚城镇', '1', '140928100', null, '3', '1'),
('140928101', '140928', '小河头镇', '1', '140928101', null, '3', '1'),
('140928102', '140928', '三岔镇', '1', '140928102', null, '3', '1'),
('140928200', '140928', '前所乡', '1', '140928200', null, '3', '1'),
('140928201', '140928', '李家坪乡', '1', '140928201', null, '3', '1'),
('140928202', '140928', '孙家坪乡', '1', '140928202', null, '3', '1'),
('140928203', '140928', '梁家坪乡', '1', '140928203', null, '3', '1'),
('140928204', '140928', '胡会乡', '1', '140928204', null, '3', '1'),
('140928205', '140928', '新寨乡', '1', '140928205', null, '3', '1'),
('140928206', '140928', '韩家楼乡', '1', '140928206', null, '3', '1'),
('140928207', '140928', '东秀庄乡', '1', '140928207', null, '3', '1'),
('140928208', '140928', '杏岭子乡', '1', '140928208', null, '3', '1'),
('140929100', '140929', '岚漪镇', '1', '140929100', null, '3', '1'),
('140929101', '140929', '三井镇', '1', '140929101', null, '3', '1'),
('140929200', '140929', '神堂坪乡', '1', '140929200', null, '3', '1'),
('140929201', '140929', '高家会乡', '1', '140929201', null, '3', '1'),
('140929202', '140929', '李家沟乡', '1', '140929202', null, '3', '1'),
('140929203', '140929', '水峪贯乡', '1', '140929203', null, '3', '1'),
('140929204', '140929', '西豹峪乡', '1', '140929204', null, '3', '1'),
('140929205', '140929', '温泉乡', '1', '140929205', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('140929206', '140929', '阳坪乡', '1', '140929206', null, '3', '1'),
('140929207', '140929', '大涧乡', '1', '140929207', null, '3', '1'),
('140929208', '140929', '宋家沟乡', '1', '140929208', null, '3', '1'),
('140929209', '140929', '王家岔乡', '1', '140929209', null, '3', '1'),
('140930100', '140930', '文笔镇', '1', '140930100', null, '3', '1'),
('140930101', '140930', '楼子营镇', '1', '140930101', null, '3', '1'),
('140930102', '140930', '刘家塔镇', '1', '140930102', null, '3', '1'),
('140930103', '140930', '巡镇镇', '1', '140930103', null, '3', '1'),
('140930200', '140930', '鹿固乡', '1', '140930200', null, '3', '1'),
('140930201', '140930', '前川乡', '1', '140930201', null, '3', '1'),
('140930202', '140930', '单寨乡', '1', '140930202', null, '3', '1'),
('140930203', '140930', '土沟乡', '1', '140930203', null, '3', '1'),
('140930204', '140930', '旧县乡', '1', '140930204', null, '3', '1'),
('140930205', '140930', '沙坪乡', '1', '140930205', null, '3', '1'),
('140930206', '140930', '社梁乡', '1', '140930206', null, '3', '1'),
('140930207', '140930', '沙泉乡', '1', '140930207', null, '3', '1'),
('140930208', '140930', '赵家沟乡', '1', '140930208', null, '3', '1'),
('140931100', '140931', '东关镇', '1', '140931100', null, '3', '1'),
('140931101', '140931', '义门镇', '1', '140931101', null, '3', '1'),
('140931102', '140931', '桥头镇', '1', '140931102', null, '3', '1'),
('140931103', '140931', '杨家湾镇', '1', '140931103', null, '3', '1'),
('140931200', '140931', '腰庄乡', '1', '140931200', null, '3', '1'),
('140931201', '140931', '韩家川乡', '1', '140931201', null, '3', '1'),
('140931202', '140931', '林遮峪乡', '1', '140931202', null, '3', '1'),
('140931203', '140931', '冯家川乡', '1', '140931203', null, '3', '1'),
('140931204', '140931', '土崖塔乡', '1', '140931204', null, '3', '1'),
('140931205', '140931', '孙家沟乡', '1', '140931205', null, '3', '1'),
('140931206', '140931', '窑洼乡', '1', '140931206', null, '3', '1'),
('140931207', '140931', '尧圪台乡', '1', '140931207', null, '3', '1'),
('140931208', '140931', '南河沟乡', '1', '140931208', null, '3', '1'),
('140932100', '140932', '新关镇', '1', '140932100', null, '3', '1'),
('140932101', '140932', '天峰坪镇', '1', '140932101', null, '3', '1'),
('140932102', '140932', '老营镇', '1', '140932102', null, '3', '1'),
('140932103', '140932', '万家寨镇', '1', '140932103', null, '3', '1'),
('140932200', '140932', '窑头乡', '1', '140932200', null, '3', '1'),
('140932201', '140932', '楼沟乡', '1', '140932201', null, '3', '1'),
('140932202', '140932', '尚峪乡', '1', '140932202', null, '3', '1'),
('140932203', '140932', '南堡子乡', '1', '140932203', null, '3', '1'),
('140932204', '140932', '水泉乡', '1', '140932204', null, '3', '1'),
('140932205', '140932', '陈家营乡', '1', '140932205', null, '3', '1'),
('140981001', '140981', '北城街道', '1', '140981001', null, '3', '1'),
('140981002', '140981', '南城街道', '1', '140981002', null, '3', '1'),
('140981100', '140981', '东社镇', '1', '140981100', null, '3', '1'),
('140981101', '140981', '苏龙口镇', '1', '140981101', null, '3', '1'),
('140981102', '140981', '崞阳镇', '1', '140981102', null, '3', '1'),
('140981103', '140981', '大牛店镇', '1', '140981103', null, '3', '1'),
('140981104', '140981', '闫庄镇', '1', '140981104', null, '3', '1'),
('140981105', '140981', '长梁沟镇', '1', '140981105', null, '3', '1'),
('140981106', '140981', '轩岗镇', '1', '140981106', null, '3', '1'),
('140981200', '140981', '新原乡', '1', '140981200', null, '3', '1'),
('140981201', '140981', '南白乡', '1', '140981201', null, '3', '1'),
('140981202', '140981', '子干乡', '1', '140981202', null, '3', '1'),
('140981203', '140981', '中阳乡', '1', '140981203', null, '3', '1'),
('140981204', '140981', '沿沟乡', '1', '140981204', null, '3', '1'),
('140981205', '140981', '大林乡', '1', '140981205', null, '3', '1'),
('140981206', '140981', '西镇乡', '1', '140981206', null, '3', '1'),
('140981207', '140981', '解村乡', '1', '140981207', null, '3', '1'),
('140981208', '140981', '王家庄乡', '1', '140981208', null, '3', '1'),
('140981209', '140981', '楼板寨乡', '1', '140981209', null, '3', '1'),
('140981210', '140981', '段家堡乡', '1', '140981210', null, '3', '1'),
('140981400', '140981', '山西鲁能晋北铝业工矿区', '1', '140981400', null, '3', '1'),
('140981401', '140981', '原平市石豹沟煤矿工矿区', '1', '140981401', null, '3', '1'),
('140981402', '140981', '同煤集团轩岗煤电有限公司工矿区', '1', '140981402', null, '3', '1'),
('141002001', '141002', '解放路街道', '1', '141002001', null, '3', '1'),
('141002002', '141002', '鼓楼西街街道', '1', '141002002', null, '3', '1'),
('141002003', '141002', '水塔街街道', '1', '141002003', null, '3', '1'),
('141002004', '141002', '南街街道', '1', '141002004', null, '3', '1'),
('141002005', '141002', '乡贤街街道', '1', '141002005', null, '3', '1'),
('141002006', '141002', '辛寺街街道', '1', '141002006', null, '3', '1'),
('141002007', '141002', '铁路东街道', '1', '141002007', null, '3', '1'),
('141002008', '141002', '车站街街道', '1', '141002008', null, '3', '1'),
('141002009', '141002', '汾河街道', '1', '141002009', null, '3', '1'),
('141002100', '141002', '屯里镇', '1', '141002100', null, '3', '1'),
('141002101', '141002', '乔李镇', '1', '141002101', null, '3', '1'),
('141002102', '141002', '大阳镇', '1', '141002102', null, '3', '1'),
('141002103', '141002', '县底镇', '1', '141002103', null, '3', '1'),
('141002104', '141002', '刘村镇', '1', '141002104', null, '3', '1'),
('141002105', '141002', '金殿镇', '1', '141002105', null, '3', '1'),
('141002106', '141002', '吴村镇', '1', '141002106', null, '3', '1'),
('141002107', '141002', '土门镇', '1', '141002107', null, '3', '1'),
('141002108', '141002', '魏村镇', '1', '141002108', null, '3', '1'),
('141002109', '141002', '尧庙镇', '1', '141002109', null, '3', '1'),
('141002200', '141002', '段店乡', '1', '141002200', null, '3', '1'),
('141002201', '141002', '贾得乡', '1', '141002201', null, '3', '1'),
('141002202', '141002', '贺家庄乡', '1', '141002202', null, '3', '1'),
('141002203', '141002', '一平垣乡', '1', '141002203', null, '3', '1'),
('141002204', '141002', '枕头乡', '1', '141002204', null, '3', '1'),
('141002205', '141002', '河底乡', '1', '141002205', null, '3', '1'),
('141002400', '141002', '滨河办事处(临汾经济开发区)', '1', '141002400', null, '3', '1'),
('141021100', '141021', '乐昌镇', '1', '141021100', null, '3', '1'),
('141021101', '141021', '史村镇', '1', '141021101', null, '3', '1'),
('141021102', '141021', '曲村镇', '1', '141021102', null, '3', '1'),
('141021103', '141021', '高显镇', '1', '141021103', null, '3', '1'),
('141021104', '141021', '里村镇', '1', '141021104', null, '3', '1'),
('141021200', '141021', '北董乡', '1', '141021200', null, '3', '1'),
('141021201', '141021', '杨谈乡', '1', '141021201', null, '3', '1'),
('141022100', '141022', '唐兴镇', '1', '141022100', null, '3', '1'),
('141022101', '141022', '南梁镇', '1', '141022101', null, '3', '1'),
('141022102', '141022', '里寨镇', '1', '141022102', null, '3', '1'),
('141022103', '141022', '隆化镇', '1', '141022103', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('141022104', '141022', '桥上镇', '1', '141022104', null, '3', '1'),
('141022105', '141022', '西闫镇', '1', '141022105', null, '3', '1'),
('141022200', '141022', '中卫乡', '1', '141022200', null, '3', '1'),
('141022201', '141022', '南唐乡', '1', '141022201', null, '3', '1'),
('141022202', '141022', '王庄乡', '1', '141022202', null, '3', '1'),
('141022203', '141022', '浇底乡', '1', '141022203', null, '3', '1'),
('141023100', '141023', '新城镇', '1', '141023100', null, '3', '1'),
('141023101', '141023', '赵康镇', '1', '141023101', null, '3', '1'),
('141023102', '141023', '汾城镇', '1', '141023102', null, '3', '1'),
('141023103', '141023', '南贾镇', '1', '141023103', null, '3', '1'),
('141023104', '141023', '古城镇', '1', '141023104', null, '3', '1'),
('141023105', '141023', '襄陵镇', '1', '141023105', null, '3', '1'),
('141023106', '141023', '邓庄镇', '1', '141023106', null, '3', '1'),
('141023200', '141023', '陶寺乡', '1', '141023200', null, '3', '1'),
('141023201', '141023', '永固乡', '1', '141023201', null, '3', '1'),
('141023202', '141023', '景毛乡', '1', '141023202', null, '3', '1'),
('141023203', '141023', '西贾乡', '1', '141023203', null, '3', '1'),
('141023204', '141023', '南辛店乡', '1', '141023204', null, '3', '1'),
('141023205', '141023', '大邓乡', '1', '141023205', null, '3', '1'),
('141024100', '141024', '大槐树镇', '1', '141024100', null, '3', '1'),
('141024101', '141024', '甘亭镇', '1', '141024101', null, '3', '1'),
('141024102', '141024', '曲亭镇', '1', '141024102', null, '3', '1'),
('141024103', '141024', '苏堡镇', '1', '141024103', null, '3', '1'),
('141024104', '141024', '广胜寺镇', '1', '141024104', null, '3', '1'),
('141024105', '141024', '明姜镇', '1', '141024105', null, '3', '1'),
('141024106', '141024', '赵城镇', '1', '141024106', null, '3', '1'),
('141024107', '141024', '万安镇', '1', '141024107', null, '3', '1'),
('141024108', '141024', '刘家垣镇', '1', '141024108', null, '3', '1'),
('141024200', '141024', '淹底乡', '1', '141024200', null, '3', '1'),
('141024201', '141024', '兴唐寺乡', '1', '141024201', null, '3', '1'),
('141024202', '141024', '堤村乡', '1', '141024202', null, '3', '1'),
('141024203', '141024', '辛村乡', '1', '141024203', null, '3', '1'),
('141024204', '141024', '龙马乡', '1', '141024204', null, '3', '1'),
('141024205', '141024', '山头乡', '1', '141024205', null, '3', '1'),
('141024206', '141024', '左木乡', '1', '141024206', null, '3', '1'),
('141025100', '141025', '岳阳镇', '1', '141025100', null, '3', '1'),
('141025101', '141025', '北平镇', '1', '141025101', null, '3', '1'),
('141025102', '141025', '古阳镇', '1', '141025102', null, '3', '1'),
('141025103', '141025', '旧县镇', '1', '141025103', null, '3', '1'),
('141025200', '141025', '石壁乡', '1', '141025200', null, '3', '1'),
('141025201', '141025', '永乐乡', '1', '141025201', null, '3', '1'),
('141025202', '141025', '南垣乡', '1', '141025202', null, '3', '1'),
('141026100', '141026', '府城镇', '1', '141026100', null, '3', '1'),
('141026101', '141026', '和川镇', '1', '141026101', null, '3', '1'),
('141026102', '141026', '唐城镇', '1', '141026102', null, '3', '1'),
('141026103', '141026', '冀氏镇', '1', '141026103', null, '3', '1'),
('141026200', '141026', '马必乡', '1', '141026200', null, '3', '1'),
('141026201', '141026', '杜村乡', '1', '141026201', null, '3', '1'),
('141026202', '141026', '良马乡', '1', '141026202', null, '3', '1'),
('141027100', '141027', '天坛镇', '1', '141027100', null, '3', '1'),
('141027101', '141027', '响水河镇', '1', '141027101', null, '3', '1'),
('141027200', '141027', '张庄乡', '1', '141027200', null, '3', '1'),
('141027201', '141027', '东张乡', '1', '141027201', null, '3', '1'),
('141027202', '141027', '槐埝乡', '1', '141027202', null, '3', '1'),
('141027203', '141027', '北王乡', '1', '141027203', null, '3', '1'),
('141027204', '141027', '北韩乡', '1', '141027204', null, '3', '1'),
('141027205', '141027', '米家垣乡', '1', '141027205', null, '3', '1'),
('141027206', '141027', '寨圪塔乡', '1', '141027206', null, '3', '1'),
('141028100', '141028', '吉昌镇', '1', '141028100', null, '3', '1'),
('141028101', '141028', '屯里镇', '1', '141028101', null, '3', '1'),
('141028102', '141028', '壶口镇', '1', '141028102', null, '3', '1'),
('141028200', '141028', '车城乡', '1', '141028200', null, '3', '1'),
('141028201', '141028', '文城乡', '1', '141028201', null, '3', '1'),
('141028202', '141028', '东城乡', '1', '141028202', null, '3', '1'),
('141028203', '141028', '柏山寺乡', '1', '141028203', null, '3', '1'),
('141028204', '141028', '中垛乡', '1', '141028204', null, '3', '1'),
('141029100', '141029', '昌宁镇', '1', '141029100', null, '3', '1'),
('141029101', '141029', '光华镇', '1', '141029101', null, '3', '1'),
('141029102', '141029', '台头镇', '1', '141029102', null, '3', '1'),
('141029103', '141029', '管头镇', '1', '141029103', null, '3', '1'),
('141029104', '141029', '西坡镇', '1', '141029104', null, '3', '1'),
('141029200', '141029', '双鹤乡', '1', '141029200', null, '3', '1'),
('141029201', '141029', '关王庙乡', '1', '141029201', null, '3', '1'),
('141029202', '141029', '尉庄乡', '1', '141029202', null, '3', '1'),
('141029203', '141029', '西交口乡', '1', '141029203', null, '3', '1'),
('141029204', '141029', '枣岭乡', '1', '141029204', null, '3', '1'),
('141030100', '141030', '昕水镇', '1', '141030100', null, '3', '1'),
('141030101', '141030', '曲峨镇', '1', '141030101', null, '3', '1'),
('141030200', '141030', '三多乡', '1', '141030200', null, '3', '1'),
('141030201', '141030', '太德乡', '1', '141030201', null, '3', '1'),
('141030202', '141030', '徐家垛乡', '1', '141030202', null, '3', '1'),
('141030203', '141030', '太古乡', '1', '141030203', null, '3', '1'),
('141031100', '141031', '龙泉镇', '1', '141031100', null, '3', '1'),
('141031101', '141031', '午城镇', '1', '141031101', null, '3', '1'),
('141031102', '141031', '黄土镇', '1', '141031102', null, '3', '1'),
('141031200', '141031', '阳头升乡', '1', '141031200', null, '3', '1'),
('141031201', '141031', '寨子乡', '1', '141031201', null, '3', '1'),
('141031202', '141031', '陡坡乡', '1', '141031202', null, '3', '1'),
('141031203', '141031', '下李乡', '1', '141031203', null, '3', '1'),
('141031204', '141031', '城南乡', '1', '141031204', null, '3', '1'),
('141032100', '141032', '芝河镇', '1', '141032100', null, '3', '1'),
('141032101', '141032', '桑壁镇', '1', '141032101', null, '3', '1'),
('141032200', '141032', '阁底乡', '1', '141032200', null, '3', '1'),
('141032201', '141032', '南庄乡', '1', '141032201', null, '3', '1'),
('141032202', '141032', '打石腰乡', '1', '141032202', null, '3', '1'),
('141032203', '141032', '坡头乡', '1', '141032203', null, '3', '1'),
('141032204', '141032', '交口乡', '1', '141032204', null, '3', '1'),
('141033100', '141033', '蒲城镇', '1', '141033100', null, '3', '1'),
('141033101', '141033', '薛关镇', '1', '141033101', null, '3', '1'),
('141033102', '141033', '黑龙关镇', '1', '141033102', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('141033103', '141033', '克城镇', '1', '141033103', null, '3', '1'),
('141033200', '141033', '山中乡', '1', '141033200', null, '3', '1'),
('141033201', '141033', '古县乡', '1', '141033201', null, '3', '1'),
('141033202', '141033', '红道乡', '1', '141033202', null, '3', '1'),
('141033203', '141033', '乔家湾乡', '1', '141033203', null, '3', '1'),
('141033204', '141033', '太林乡', '1', '141033204', null, '3', '1'),
('141034100', '141034', '永安镇', '1', '141034100', null, '3', '1'),
('141034101', '141034', '对竹镇', '1', '141034101', null, '3', '1'),
('141034102', '141034', '勍香镇', '1', '141034102', null, '3', '1'),
('141034103', '141034', '和平镇', '1', '141034103', null, '3', '1'),
('141034104', '141034', '僧念镇', '1', '141034104', null, '3', '1'),
('141034200', '141034', '佃坪乡', '1', '141034200', null, '3', '1'),
('141034201', '141034', '团柏乡', '1', '141034201', null, '3', '1'),
('141034202', '141034', '邢家要乡', '1', '141034202', null, '3', '1'),
('141081001', '141081', '路东街道', '1', '141081001', null, '3', '1'),
('141081002', '141081', '路西街道', '1', '141081002', null, '3', '1'),
('141081003', '141081', '浍滨街道', '1', '141081003', null, '3', '1'),
('141081004', '141081', '上马街道', '1', '141081004', null, '3', '1'),
('141081005', '141081', '张村街道', '1', '141081005', null, '3', '1'),
('141081200', '141081', '新田乡', '1', '141081200', null, '3', '1'),
('141081201', '141081', '高村乡', '1', '141081201', null, '3', '1'),
('141081202', '141081', '凤城乡', '1', '141081202', null, '3', '1'),
('141082001', '141082', '鼓楼街道', '1', '141082001', null, '3', '1'),
('141082002', '141082', '北环路街道', '1', '141082002', null, '3', '1'),
('141082003', '141082', '南环路街道', '1', '141082003', null, '3', '1'),
('141082004', '141082', '开元街道办事', '1', '141082004', null, '3', '1'),
('141082005', '141082', '退沙街道', '1', '141082005', null, '3', '1'),
('141082100', '141082', '白龙镇', '1', '141082100', null, '3', '1'),
('141082101', '141082', '辛置镇', '1', '141082101', null, '3', '1'),
('141082102', '141082', '大张镇', '1', '141082102', null, '3', '1'),
('141082103', '141082', '李曹镇', '1', '141082103', null, '3', '1'),
('141082200', '141082', '陶唐峪乡', '1', '141082200', null, '3', '1'),
('141082201', '141082', '三教乡', '1', '141082201', null, '3', '1'),
('141082202', '141082', '师庄乡', '1', '141082202', null, '3', '1'),
('141102001', '141102', '滨河街道', '1', '141102001', null, '3', '1'),
('141102002', '141102', '凤山街道', '1', '141102002', null, '3', '1'),
('141102003', '141102', '莲花池街道', '1', '141102003', null, '3', '1'),
('141102004', '141102', '城北街道', '1', '141102004', null, '3', '1'),
('141102005', '141102', '田家会街道', '1', '141102005', null, '3', '1'),
('141102006', '141102', '交口街道', '1', '141102006', null, '3', '1'),
('141102007', '141102', '西属巴街道', '1', '141102007', null, '3', '1'),
('141102100', '141102', '吴城镇', '1', '141102100', null, '3', '1'),
('141102101', '141102', '信义镇', '1', '141102101', null, '3', '1'),
('141102200', '141102', '红眼川乡', '1', '141102200', null, '3', '1'),
('141102201', '141102', '枣林乡', '1', '141102201', null, '3', '1'),
('141102202', '141102', '坪头乡', '1', '141102202', null, '3', '1'),
('141121100', '141121', '凤城镇', '1', '141121100', null, '3', '1'),
('141121101', '141121', '开栅镇', '1', '141121101', null, '3', '1'),
('141121102', '141121', '南庄镇', '1', '141121102', null, '3', '1'),
('141121103', '141121', '南安镇', '1', '141121103', null, '3', '1'),
('141121104', '141121', '刘胡兰镇', '1', '141121104', null, '3', '1'),
('141121105', '141121', '下曲镇', '1', '141121105', null, '3', '1'),
('141121106', '141121', '孝义镇', '1', '141121106', null, '3', '1'),
('141121200', '141121', '南武乡', '1', '141121200', null, '3', '1'),
('141121201', '141121', '西城乡', '1', '141121201', null, '3', '1'),
('141121202', '141121', '北张乡', '1', '141121202', null, '3', '1'),
('141121203', '141121', '马西乡', '1', '141121203', null, '3', '1'),
('141121204', '141121', '西槽头乡', '1', '141121204', null, '3', '1'),
('141122100', '141122', '天宁镇', '1', '141122100', null, '3', '1'),
('141122101', '141122', '夏家营镇', '1', '141122101', null, '3', '1'),
('141122102', '141122', '西营镇', '1', '141122102', null, '3', '1'),
('141122103', '141122', '水峪贯镇', '1', '141122103', null, '3', '1'),
('141122104', '141122', '西社镇', '1', '141122104', null, '3', '1'),
('141122105', '141122', '庞泉沟镇', '1', '141122105', null, '3', '1'),
('141122200', '141122', '洪相乡', '1', '141122200', null, '3', '1'),
('141122201', '141122', '岭底乡', '1', '141122201', null, '3', '1'),
('141122202', '141122', '东坡底乡', '1', '141122202', null, '3', '1'),
('141122203', '141122', '会立乡', '1', '141122203', null, '3', '1'),
('141123100', '141123', '蔚汾镇', '1', '141123100', null, '3', '1'),
('141123101', '141123', '魏家滩镇', '1', '141123101', null, '3', '1'),
('141123102', '141123', '瓦塘镇', '1', '141123102', null, '3', '1'),
('141123103', '141123', '康宁镇', '1', '141123103', null, '3', '1'),
('141123104', '141123', '高家村镇', '1', '141123104', null, '3', '1'),
('141123105', '141123', '罗峪口镇', '1', '141123105', null, '3', '1'),
('141123106', '141123', '蔡家会镇', '1', '141123106', null, '3', '1'),
('141123200', '141123', '交楼申乡', '1', '141123200', null, '3', '1'),
('141123201', '141123', '恶虎滩乡', '1', '141123201', null, '3', '1'),
('141123202', '141123', '东会乡', '1', '141123202', null, '3', '1'),
('141123203', '141123', '固贤乡', '1', '141123203', null, '3', '1'),
('141123204', '141123', '奥家湾乡', '1', '141123204', null, '3', '1'),
('141123205', '141123', '蔡家崖乡', '1', '141123205', null, '3', '1'),
('141123206', '141123', '贺家会乡', '1', '141123206', null, '3', '1'),
('141123207', '141123', '孟家坪乡', '1', '141123207', null, '3', '1'),
('141123208', '141123', '赵家坪乡', '1', '141123208', null, '3', '1'),
('141123209', '141123', '圪垯上乡', '1', '141123209', null, '3', '1'),
('141124100', '141124', '临泉镇', '1', '141124100', null, '3', '1'),
('141124101', '141124', '白文镇', '1', '141124101', null, '3', '1'),
('141124102', '141124', '城庄镇', '1', '141124102', null, '3', '1'),
('141124103', '141124', '兔坂镇', '1', '141124103', null, '3', '1'),
('141124104', '141124', '克虎镇', '1', '141124104', null, '3', '1'),
('141124105', '141124', '三交镇', '1', '141124105', null, '3', '1'),
('141124106', '141124', '湍水头镇', '1', '141124106', null, '3', '1'),
('141124107', '141124', '林家坪镇', '1', '141124107', null, '3', '1'),
('141124108', '141124', '招贤镇', '1', '141124108', null, '3', '1'),
('141124109', '141124', '碛口镇', '1', '141124109', null, '3', '1'),
('141124110', '141124', '刘家会镇', '1', '141124110', null, '3', '1'),
('141124111', '141124', '丛罗峪镇', '1', '141124111', null, '3', '1'),
('141124112', '141124', '曲峪镇', '1', '141124112', null, '3', '1'),
('141124200', '141124', '木瓜坪乡', '1', '141124200', null, '3', '1'),
('141124201', '141124', '安业乡', '1', '141124201', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('141124202', '141124', '玉坪乡', '1', '141124202', null, '3', '1'),
('141124203', '141124', '青凉寺乡', '1', '141124203', null, '3', '1'),
('141124204', '141124', '石白头乡', '1', '141124204', null, '3', '1'),
('141124205', '141124', '雷家碛乡', '1', '141124205', null, '3', '1'),
('141124206', '141124', '第八堡乡', '1', '141124206', null, '3', '1'),
('141124207', '141124', '大禹乡', '1', '141124207', null, '3', '1'),
('141124208', '141124', '车赶乡', '1', '141124208', null, '3', '1'),
('141124209', '141124', '安家庄乡', '1', '141124209', null, '3', '1'),
('141125100', '141125', '柳林镇', '1', '141125100', null, '3', '1'),
('141125101', '141125', '穆村镇', '1', '141125101', null, '3', '1'),
('141125102', '141125', '薛村镇', '1', '141125102', null, '3', '1'),
('141125103', '141125', '庄上镇', '1', '141125103', null, '3', '1'),
('141125104', '141125', '留誉镇', '1', '141125104', null, '3', '1'),
('141125105', '141125', '三交镇', '1', '141125105', null, '3', '1'),
('141125106', '141125', '成家庄镇', '1', '141125106', null, '3', '1'),
('141125107', '141125', '孟门镇', '1', '141125107', null, '3', '1'),
('141125200', '141125', '李家湾乡', '1', '141125200', null, '3', '1'),
('141125201', '141125', '贾家垣乡', '1', '141125201', null, '3', '1'),
('141125202', '141125', '陈家湾乡', '1', '141125202', null, '3', '1'),
('141125203', '141125', '金家庄乡', '1', '141125203', null, '3', '1'),
('141125204', '141125', '高家沟乡', '1', '141125204', null, '3', '1'),
('141125205', '141125', '石西乡', '1', '141125205', null, '3', '1'),
('141125206', '141125', '王家沟乡', '1', '141125206', null, '3', '1'),
('141126100', '141126', '灵泉镇', '1', '141126100', null, '3', '1'),
('141126101', '141126', '罗村镇', '1', '141126101', null, '3', '1'),
('141126102', '141126', '义牒镇', '1', '141126102', null, '3', '1'),
('141126103', '141126', '小蒜镇', '1', '141126103', null, '3', '1'),
('141126200', '141126', '龙交乡', '1', '141126200', null, '3', '1'),
('141126201', '141126', '和合乡', '1', '141126201', null, '3', '1'),
('141126202', '141126', '前山乡', '1', '141126202', null, '3', '1'),
('141126203', '141126', '曹家垣乡', '1', '141126203', null, '3', '1'),
('141126204', '141126', '裴沟乡', '1', '141126204', null, '3', '1'),
('141127100', '141127', '东村镇', '1', '141127100', null, '3', '1'),
('141127101', '141127', '岚城镇', '1', '141127101', null, '3', '1'),
('141127102', '141127', '普明镇', '1', '141127102', null, '3', '1'),
('141127103', '141127', '界河口镇', '1', '141127103', null, '3', '1'),
('141127200', '141127', '土峪乡', '1', '141127200', null, '3', '1'),
('141127201', '141127', '上明乡', '1', '141127201', null, '3', '1'),
('141127202', '141127', '王狮乡', '1', '141127202', null, '3', '1'),
('141127203', '141127', '梁家庄乡', '1', '141127203', null, '3', '1'),
('141127204', '141127', '顺会乡', '1', '141127204', null, '3', '1'),
('141127205', '141127', '河口乡', '1', '141127205', null, '3', '1'),
('141127206', '141127', '社科乡', '1', '141127206', null, '3', '1'),
('141127207', '141127', '大蛇头乡', '1', '141127207', null, '3', '1'),
('141128100', '141128', '圪洞镇', '1', '141128100', null, '3', '1'),
('141128101', '141128', '马坊镇', '1', '141128101', null, '3', '1'),
('141128102', '141128', '峪口镇', '1', '141128102', null, '3', '1'),
('141128103', '141128', '大武镇', '1', '141128103', null, '3', '1'),
('141128104', '141128', '北武当镇', '1', '141128104', null, '3', '1'),
('141128200', '141128', '积翠乡', '1', '141128200', null, '3', '1'),
('141128201', '141128', '麻地会乡', '1', '141128201', null, '3', '1'),
('141129100', '141129', '宁乡镇', '1', '141129100', null, '3', '1'),
('141129101', '141129', '金罗镇', '1', '141129101', null, '3', '1'),
('141129102', '141129', '枝柯镇', '1', '141129102', null, '3', '1'),
('141129103', '141129', '武家庄镇', '1', '141129103', null, '3', '1'),
('141129104', '141129', '暖泉镇', '1', '141129104', null, '3', '1'),
('141129200', '141129', '张子山乡', '1', '141129200', null, '3', '1'),
('141129201', '141129', '下枣林乡', '1', '141129201', null, '3', '1'),
('141130100', '141130', '水头镇', '1', '141130100', null, '3', '1'),
('141130101', '141130', '康城镇', '1', '141130101', null, '3', '1'),
('141130102', '141130', '双池镇', '1', '141130102', null, '3', '1'),
('141130103', '141130', '桃红坡镇', '1', '141130103', null, '3', '1'),
('141130200', '141130', '石口乡', '1', '141130200', null, '3', '1'),
('141130201', '141130', '回龙乡', '1', '141130201', null, '3', '1'),
('141130202', '141130', '温泉乡', '1', '141130202', null, '3', '1'),
('141181001', '141181', '新义街道', '1', '141181001', null, '3', '1'),
('141181002', '141181', '中阳楼街道', '1', '141181002', null, '3', '1'),
('141181003', '141181', '振兴街道', '1', '141181003', null, '3', '1'),
('141181004', '141181', '东许街道', '1', '141181004', null, '3', '1'),
('141181100', '141181', '兑镇镇', '1', '141181100', null, '3', '1'),
('141181101', '141181', '阳泉曲镇', '1', '141181101', null, '3', '1'),
('141181102', '141181', '下堡镇', '1', '141181102', null, '3', '1'),
('141181103', '141181', '西辛庄镇', '1', '141181103', null, '3', '1'),
('141181104', '141181', '高阳镇', '1', '141181104', null, '3', '1'),
('141181105', '141181', '梧桐镇', '1', '141181105', null, '3', '1'),
('141181106', '141181', '柱濮镇', '1', '141181106', null, '3', '1'),
('141181200', '141181', '大孝堡乡', '1', '141181200', null, '3', '1'),
('141181201', '141181', '下栅乡', '1', '141181201', null, '3', '1'),
('141181202', '141181', '驿马乡', '1', '141181202', null, '3', '1'),
('141181203', '141181', '南阳乡', '1', '141181203', null, '3', '1'),
('141181204', '141181', '杜村乡', '1', '141181204', null, '3', '1'),
('141182001', '141182', '文峰街道', '1', '141182001', null, '3', '1'),
('141182002', '141182', '太和桥街道', '1', '141182002', null, '3', '1'),
('141182100', '141182', '贾家庄镇', '1', '141182100', null, '3', '1'),
('141182101', '141182', '杏花村镇', '1', '141182101', null, '3', '1'),
('141182102', '141182', '冀村镇', '1', '141182102', null, '3', '1'),
('141182103', '141182', '肖家庄镇', '1', '141182103', null, '3', '1'),
('141182104', '141182', '演武镇', '1', '141182104', null, '3', '1'),
('141182105', '141182', '三泉镇', '1', '141182105', null, '3', '1'),
('141182106', '141182', '石庄镇', '1', '141182106', null, '3', '1'),
('141182107', '141182', '杨家庄镇', '1', '141182107', null, '3', '1'),
('141182108', '141182', '峪道河镇', '1', '141182108', null, '3', '1'),
('141182200', '141182', '西河乡', '1', '141182200', null, '3', '1'),
('141182201', '141182', '阳城乡', '1', '141182201', null, '3', '1'),
('141182202', '141182', '栗家庄乡', '1', '141182202', null, '3', '1'),
('150102001', '150102', '海拉尔东路街道', '1', '150102001', null, '3', '1'),
('150102002', '150102', '锡林路', '1', '150102002', null, '3', '1'),
('150102003', '150102', '中山东路街道', '1', '150102003', null, '3', '1'),
('150102004', '150102', '东街街道', '1', '150102004', null, '3', '1'),
('150102005', '150102', '西街街道', '1', '150102005', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('150102006', '150102', '东风路街道', '1', '150102006', null, '3', '1'),
('150102007', '150102', '迎新路街道', '1', '150102007', null, '3', '1'),
('150102100', '150102', '毫沁营镇', '1', '150102100', null, '3', '1'),
('150102101', '150102', '保合少镇', '1', '150102101', null, '3', '1'),
('150102400', '150102', '新城区鸿盛高科技园区', '1', '150102400', null, '3', '1'),
('150103001', '150103', '新华西路', '1', '150103001', null, '3', '1'),
('150103002', '150103', '中山西路', '1', '150103002', null, '3', '1'),
('150103003', '150103', '光明路', '1', '150103003', null, '3', '1'),
('150103004', '150103', '海拉尔西路', '1', '150103004', null, '3', '1'),
('150103005', '150103', '环河街', '1', '150103005', null, '3', '1'),
('150103006', '150103', '通道街', '1', '150103006', null, '3', '1'),
('150103007', '150103', '钢铁路', '1', '150103007', null, '3', '1'),
('150103100', '150103', '攸攸板镇', '1', '150103100', null, '3', '1'),
('150104001', '150104', '小召前街', '1', '150104001', null, '3', '1'),
('150104002', '150104', '兴隆巷', '1', '150104002', null, '3', '1'),
('150104003', '150104', '长和廊', '1', '150104003', null, '3', '1'),
('150104004', '150104', '石东路', '1', '150104004', null, '3', '1'),
('150104005', '150104', '大南街', '1', '150104005', null, '3', '1'),
('150104006', '150104', '鄂尔多斯路', '1', '150104006', null, '3', '1'),
('150104007', '150104', '西菜园', '1', '150104007', null, '3', '1'),
('150104100', '150104', '小黑河镇', '1', '150104100', null, '3', '1'),
('150105001', '150105', '人民路街道', '1', '150105001', null, '3', '1'),
('150105002', '150105', '大学西路街道', '1', '150105002', null, '3', '1'),
('150105003', '150105', '乌兰察布路街道', '1', '150105003', null, '3', '1'),
('150105004', '150105', '大学东路街道', '1', '150105004', null, '3', '1'),
('150105005', '150105', '中专路街道', '1', '150105005', null, '3', '1'),
('150105100', '150105', '巧报镇', '1', '150105100', null, '3', '1'),
('150105101', '150105', '榆林镇', '1', '150105101', null, '3', '1'),
('150105102', '150105', '巴彦镇', '1', '150105102', null, '3', '1'),
('150105103', '150105', '黄合少镇', '1', '150105103', null, '3', '1'),
('150105104', '150105', '金河镇', '1', '150105104', null, '3', '1'),
('150105201', '150105', '西把栅乡', '1', '150105201', null, '3', '1'),
('150105400', '150105', '金桥经济技术开发区', '1', '150105400', null, '3', '1'),
('150121100', '150121', '察素齐镇', '1', '150121100', null, '3', '1'),
('150121101', '150121', '毕克齐镇', '1', '150121101', null, '3', '1'),
('150121102', '150121', '善岱镇', '1', '150121102', null, '3', '1'),
('150121103', '150121', '台阁牧镇', '1', '150121103', null, '3', '1'),
('150121104', '150121', '白庙子镇', '1', '150121104', null, '3', '1'),
('150121203', '150121', '沙尔沁乡', '1', '150121203', null, '3', '1'),
('150121207', '150121', '北什轴乡', '1', '150121207', null, '3', '1'),
('150121208', '150121', '塔布赛乡', '1', '150121208', null, '3', '1'),
('150121212', '150121', '只几梁乡', '1', '150121212', null, '3', '1'),
('150121400', '150121', '呼和浩特经济技术开发区金川区', '1', '150121400', null, '3', '1'),
('150121401', '150121', '呼和浩特金山经济技术开发区', '1', '150121401', null, '3', '1'),
('150122100', '150122', '双河镇', '1', '150122100', null, '3', '1'),
('150122101', '150122', '新营子镇', '1', '150122101', null, '3', '1'),
('150122102', '150122', '五申镇', '1', '150122102', null, '3', '1'),
('150122103', '150122', '伍什家镇', '1', '150122103', null, '3', '1'),
('150122104', '150122', '古城镇', '1', '150122104', null, '3', '1'),
('150123100', '150123', '城关镇', '1', '150123100', null, '3', '1'),
('150123101', '150123', '盛乐镇', '1', '150123101', null, '3', '1'),
('150123102', '150123', '新店子镇', '1', '150123102', null, '3', '1'),
('150123203', '150123', '舍必崖乡', '1', '150123203', null, '3', '1'),
('150123205', '150123', '大红城乡', '1', '150123205', null, '3', '1'),
('150123206', '150123', '羊群沟乡', '1', '150123206', null, '3', '1'),
('150123207', '150123', '黑老夭乡', '1', '150123207', null, '3', '1'),
('150123400', '150123', '盛乐经济工业园区', '1', '150123400', null, '3', '1'),
('150124100', '150124', '城关镇', '1', '150124100', null, '3', '1'),
('150124101', '150124', '宏河镇', '1', '150124101', null, '3', '1'),
('150124102', '150124', '喇嘛湾镇', '1', '150124102', null, '3', '1'),
('150124200', '150124', '窑沟乡', '1', '150124200', null, '3', '1'),
('150124201', '150124', '北堡乡', '1', '150124201', null, '3', '1'),
('150124202', '150124', '韮菜庄乡', '1', '150124202', null, '3', '1'),
('150125100', '150125', '可镇', '1', '150125100', null, '3', '1'),
('150125101', '150125', '哈乐镇', '1', '150125101', null, '3', '1'),
('150125102', '150125', '西乌兰不浪镇', '1', '150125102', null, '3', '1'),
('150125200', '150125', '大青山乡', '1', '150125200', null, '3', '1'),
('150125205', '150125', '上秃亥乡', '1', '150125205', null, '3', '1'),
('150125207', '150125', '德胜沟乡', '1', '150125207', null, '3', '1'),
('150125211', '150125', '二份子乡', '1', '150125211', null, '3', '1'),
('150125213', '150125', '哈拉合少乡', '1', '150125213', null, '3', '1'),
('150125400', '150125', '工业园区', '1', '150125400', null, '3', '1'),
('150202001', '150202', '和平街道', '1', '150202001', null, '3', '1'),
('150202002', '150202', '财神庙街道', '1', '150202002', null, '3', '1'),
('150202003', '150202', '西脑包街道', '1', '150202003', null, '3', '1'),
('150202004', '150202', '南门外街道', '1', '150202004', null, '3', '1'),
('150202005', '150202', '南圪洞街道', '1', '150202005', null, '3', '1'),
('150202006', '150202', '东站街道', '1', '150202006', null, '3', '1'),
('150202007', '150202', '回民街道', '1', '150202007', null, '3', '1'),
('150202008', '150202', '二里半街道', '1', '150202008', null, '3', '1'),
('150202009', '150202', '河东街道', '1', '150202009', null, '3', '1'),
('150202010', '150202', '铁西街道', '1', '150202010', null, '3', '1'),
('150202011', '150202', '东兴街道', '1', '150202011', null, '3', '1'),
('150202012', '150202', '杨圪楞街道', '1', '150202012', null, '3', '1'),
('150202100', '150202', '河东镇', '1', '150202100', null, '3', '1'),
('150203001', '150203', '少先路街道', '1', '150203001', null, '3', '1'),
('150203002', '150203', '张家营子街道', '1', '150203002', null, '3', '1'),
('150203003', '150203', '沼潭街道', '1', '150203003', null, '3', '1'),
('150203004', '150203', '林荫路街道', '1', '150203004', null, '3', '1'),
('150203005', '150203', '友谊大街街道', '1', '150203005', null, '3', '1'),
('150203006', '150203', '阿尔丁大街街道', '1', '150203006', null, '3', '1'),
('150203007', '150203', '团结大街街道', '1', '150203007', null, '3', '1'),
('150203008', '150203', '鞍山道街道', '1', '150203008', null, '3', '1'),
('150203009', '150203', '前进道街道', '1', '150203009', null, '3', '1'),
('150203010', '150203', '市府东路街道', '1', '150203010', null, '3', '1'),
('150203011', '150203', '白云路街道', '1', '150203011', null, '3', '1'),
('150203012', '150203', '黄河西路街道', '1', '150203012', null, '3', '1'),
('150203013', '150203', '昆工路街道', '1', '150203013', null, '3', '1'),
('150203100', '150203', '昆河镇', '1', '150203100', null, '3', '1'),
('150203400', '150203', '包钢厂区虚拟', '1', '150203400', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('150204001', '150204', '先锋道街道', '1', '150204001', null, '3', '1'),
('150204002', '150204', '幸福路街道', '1', '150204002', null, '3', '1'),
('150204003', '150204', '万青路街道', '1', '150204003', null, '3', '1'),
('150204004', '150204', '富强路街道', '1', '150204004', null, '3', '1'),
('150204005', '150204', '科学路街道', '1', '150204005', null, '3', '1'),
('150204006', '150204', '青山路街道', '1', '150204006', null, '3', '1'),
('150204007', '150204', '自由路街道', '1', '150204007', null, '3', '1'),
('150204008', '150204', '乌素图街道', '1', '150204008', null, '3', '1'),
('150204100', '150204', '青福镇', '1', '150204100', null, '3', '1'),
('150204103', '150204', '万水泉镇', '1', '150204103', null, '3', '1'),
('150204400', '150204', '包头稀土高新区新建区虚拟', '1', '150204400', null, '3', '1'),
('150205001', '150205', '石拐街道', '1', '150205001', null, '3', '1'),
('150205002', '150205', '大发街道', '1', '150205002', null, '3', '1'),
('150205003', '150205', '大磁街道', '1', '150205003', null, '3', '1'),
('150205004', '150205', '五当沟街道', '1', '150205004', null, '3', '1'),
('150205005', '150205', '白狐沟街道', '1', '150205005', null, '3', '1'),
('150205101', '150205', '五当召镇', '1', '150205101', null, '3', '1'),
('150206001', '150206', '矿山路街道', '1', '150206001', null, '3', '1'),
('150206002', '150206', '通阳道街道', '1', '150206002', null, '3', '1'),
('150207001', '150207', '沙河街道', '1', '150207001', null, '3', '1'),
('150207103', '150207', '麻池镇', '1', '150207103', null, '3', '1'),
('150207105', '150207', '哈林格尔镇', '1', '150207105', null, '3', '1'),
('150207108', '150207', '沙尔沁镇', '1', '150207108', null, '3', '1'),
('150207109', '150207', '兴胜镇', '1', '150207109', null, '3', '1'),
('150207110', '150207', '哈业胡同镇', '1', '150207110', null, '3', '1'),
('150207202', '150207', '阿嘎如泰苏木乡', '1', '150207202', null, '3', '1'),
('150207500', '150207', '包头市国营青年农场', '1', '150207500', null, '3', '1'),
('150207501', '150207', '包头市奶业公司', '1', '150207501', null, '3', '1'),
('150221104', '150221', '萨拉齐镇', '1', '150221104', null, '3', '1'),
('150221105', '150221', '双龙镇', '1', '150221105', null, '3', '1'),
('150221106', '150221', '美岱召镇', '1', '150221106', null, '3', '1'),
('150221107', '150221', '沟门镇', '1', '150221107', null, '3', '1'),
('150221108', '150221', '将军尧镇', '1', '150221108', null, '3', '1'),
('150221213', '150221', '海子乡', '1', '150221213', null, '3', '1'),
('150221214', '150221', '明沙淖乡', '1', '150221214', null, '3', '1'),
('150221215', '150221', '苏波盖乡', '1', '150221215', null, '3', '1'),
('150221500', '150221', '九峰山生态管理委员会', '1', '150221500', null, '3', '1'),
('150222102', '150222', '金山镇', '1', '150222102', null, '3', '1'),
('150222103', '150222', '西斗铺镇', '1', '150222103', null, '3', '1'),
('150222104', '150222', '下湿壕镇', '1', '150222104', null, '3', '1'),
('150222105', '150222', '银号镇', '1', '150222105', null, '3', '1'),
('150222106', '150222', '怀朔镇', '1', '150222106', null, '3', '1'),
('150222107', '150222', '兴顺西镇', '1', '150222107', null, '3', '1'),
('150223102', '150223', '满都拉镇', '1', '150223102', null, '3', '1'),
('150223103', '150223', '希拉穆仁镇', '1', '150223103', null, '3', '1'),
('150223104', '150223', '百灵庙镇', '1', '150223104', null, '3', '1'),
('150223105', '150223', '石宝镇', '1', '150223105', null, '3', '1'),
('150223106', '150223', '乌克忽洞镇', '1', '150223106', null, '3', '1'),
('150223107', '150223', '明安镇', '1', '150223107', null, '3', '1'),
('150223108', '150223', '巴音花镇', '1', '150223108', null, '3', '1'),
('150223213', '150223', '达尔罕苏木乡', '1', '150223213', null, '3', '1'),
('150302001', '150302', '凤凰岭街道', '1', '150302001', null, '3', '1'),
('150302002', '150302', '海北街道', '1', '150302002', null, '3', '1'),
('150302003', '150302', '新华街道', '1', '150302003', null, '3', '1'),
('150302004', '150302', '新华西街道', '1', '150302004', null, '3', '1'),
('150302005', '150302', '卡布其街道', '1', '150302005', null, '3', '1'),
('150302007', '150302', '滨河街道', '1', '150302007', null, '3', '1'),
('150302101', '150302', '千里山镇', '1', '150302101', null, '3', '1'),
('150303001', '150303', '拉僧仲街道', '1', '150303001', null, '3', '1'),
('150303002', '150303', '西卓子山街道', '1', '150303002', null, '3', '1'),
('150303102', '150303', '公乌素镇', '1', '150303102', null, '3', '1'),
('150303103', '150303', '拉僧庙镇', '1', '150303103', null, '3', '1'),
('150303104', '150303', '巴音陶亥镇', '1', '150303104', null, '3', '1'),
('150304002', '150304', '三道坎街道', '1', '150304002', null, '3', '1'),
('150304003', '150304', '五虎山街道', '1', '150304003', null, '3', '1'),
('150304008', '150304', '新达街道', '1', '150304008', null, '3', '1'),
('150304009', '150304', '巴音赛街道', '1', '150304009', null, '3', '1'),
('150304010', '150304', '梁家沟街道', '1', '150304010', null, '3', '1'),
('150304011', '150304', '苏海图街道', '1', '150304011', null, '3', '1'),
('150304012', '150304', '滨海街道', '1', '150304012', null, '3', '1'),
('150304101', '150304', '乌兰淖尔镇', '1', '150304101', null, '3', '1'),
('150402001', '150402', '西屯街道', '1', '150402001', null, '3', '1'),
('150402002', '150402', '三中街街道', '1', '150402002', null, '3', '1'),
('150402003', '150402', '永巨街道', '1', '150402003', null, '3', '1'),
('150402004', '150402', '东城街道', '1', '150402004', null, '3', '1'),
('150402005', '150402', '南新街街道', '1', '150402005', null, '3', '1'),
('150402006', '150402', '站前街道', '1', '150402006', null, '3', '1'),
('150402007', '150402', '铁南街道', '1', '150402007', null, '3', '1'),
('150402008', '150402', '长青街道', '1', '150402008', null, '3', '1'),
('150402009', '150402', '哈达街道', '1', '150402009', null, '3', '1'),
('150402100', '150402', '红庙子镇', '1', '150402100', null, '3', '1'),
('150402102', '150402', '文钟镇', '1', '150402102', null, '3', '1'),
('150403001', '150403', '西露天街道', '1', '150403001', null, '3', '1'),
('150403002', '150403', '平庄城区街道', '1', '150403002', null, '3', '1'),
('150403100', '150403', '风水沟镇', '1', '150403100', null, '3', '1'),
('150403101', '150403', '元宝山镇', '1', '150403101', null, '3', '1'),
('150403102', '150403', '美丽河镇', '1', '150403102', null, '3', '1'),
('150403103', '150403', '平庄镇', '1', '150403103', null, '3', '1'),
('150403104', '150403', '五家镇', '1', '150403104', null, '3', '1'),
('150404001', '150404', '振兴街道', '1', '150404001', null, '3', '1'),
('150404002', '150404', '向阳街道', '1', '150404002', null, '3', '1'),
('150404003', '150404', '松州街道', '1', '150404003', null, '3', '1'),
('150404004', '150404', '铁东街道', '1', '150404004', null, '3', '1'),
('150404005', '150404', '玉龙街道', '1', '150404005', null, '3', '1'),
('150404006', '150404', '富河街道', '1', '150404006', null, '3', '1'),
('150404007', '150404', '兴安街道', '1', '150404007', null, '3', '1'),
('150404008', '150404', '全宁街道', '1', '150404008', null, '3', '1'),
('150404100', '150404', '穆家营子镇', '1', '150404100', null, '3', '1'),
('150404101', '150404', '初头朗镇', '1', '150404101', null, '3', '1'),
('150404102', '150404', '大庙镇', '1', '150404102', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('150404103', '150404', '王府镇', '1', '150404103', null, '3', '1'),
('150404104', '150404', '老府镇', '1', '150404104', null, '3', '1'),
('150404105', '150404', '哈拉道口镇', '1', '150404105', null, '3', '1'),
('150404106', '150404', '上官地镇', '1', '150404106', null, '3', '1'),
('150404107', '150404', '安庆镇', '1', '150404107', null, '3', '1'),
('150404108', '150404', '太平地镇', '1', '150404108', null, '3', '1'),
('150404200', '150404', '当铺地满族乡', '1', '150404200', null, '3', '1'),
('150404201', '150404', '夏家店乡', '1', '150404201', null, '3', '1'),
('150404202', '150404', '城子乡', '1', '150404202', null, '3', '1'),
('150404203', '150404', '大夫营子乡', '1', '150404203', null, '3', '1'),
('150404204', '150404', '岗子乡', '1', '150404204', null, '3', '1'),
('150421001', '150421', '天山', '1', '150421001', null, '3', '1'),
('150421100', '150421', '天山镇', '1', '150421100', null, '3', '1'),
('150421101', '150421', '天山口镇', '1', '150421101', null, '3', '1'),
('150421102', '150421', '双胜镇', '1', '150421102', null, '3', '1'),
('150421103', '150421', '坤都镇', '1', '150421103', null, '3', '1'),
('150421104', '150421', '巴彦花镇', '1', '150421104', null, '3', '1'),
('150421105', '150421', '绍根镇', '1', '150421105', null, '3', '1'),
('150421200', '150421', '新民乡', '1', '150421200', null, '3', '1'),
('150421201', '150421', '先锋乡', '1', '150421201', null, '3', '1'),
('150421202', '150421', '罕苏木苏木乡', '1', '150421202', null, '3', '1'),
('150421203', '150421', '赛汉塔拉苏木乡', '1', '150421203', null, '3', '1'),
('150421204', '150421', '巴拉奇如德苏木乡', '1', '150421204', null, '3', '1'),
('150422001', '150422', '林东西城街道', '1', '150422001', null, '3', '1'),
('150422002', '150422', '林东东城街道', '1', '150422002', null, '3', '1'),
('150422100', '150422', '林东镇', '1', '150422100', null, '3', '1'),
('150422101', '150422', '隆昌镇', '1', '150422101', null, '3', '1'),
('150422102', '150422', '十三敖包镇', '1', '150422102', null, '3', '1'),
('150422103', '150422', '碧流台镇', '1', '150422103', null, '3', '1'),
('150422104', '150422', '富河镇', '1', '150422104', null, '3', '1'),
('150422105', '150422', '白音诺尔镇', '1', '150422105', null, '3', '1'),
('150422106', '150422', '哈拉哈达镇', '1', '150422106', null, '3', '1'),
('150422200', '150422', '查干哈达苏木乡', '1', '150422200', null, '3', '1'),
('150422201', '150422', '乌兰达坝苏木乡', '1', '150422201', null, '3', '1'),
('150423100', '150423', '大板镇', '1', '150423100', null, '3', '1'),
('150423101', '150423', '索博日嘎镇', '1', '150423101', null, '3', '1'),
('150423102', '150423', '宝日勿苏镇', '1', '150423102', null, '3', '1'),
('150423103', '150423', '查干诺尔镇', '1', '150423103', null, '3', '1'),
('150423104', '150423', '查干沐沦镇', '1', '150423104', null, '3', '1'),
('150423200', '150423', '西拉沐沦苏木乡', '1', '150423200', null, '3', '1'),
('150423201', '150423', '巴彦塔拉苏木乡', '1', '150423201', null, '3', '1'),
('150423202', '150423', '幸福之路苏木乡', '1', '150423202', null, '3', '1'),
('150424001', '150424', '林西街道', '1', '150424001', null, '3', '1'),
('150424100', '150424', '林西镇', '1', '150424100', null, '3', '1'),
('150424101', '150424', '新城子镇', '1', '150424101', null, '3', '1'),
('150424102', '150424', '新林镇', '1', '150424102', null, '3', '1'),
('150424103', '150424', '五十家子镇', '1', '150424103', null, '3', '1'),
('150424104', '150424', '官地镇', '1', '150424104', null, '3', '1'),
('150424105', '150424', '大井镇', '1', '150424105', null, '3', '1'),
('150424106', '150424', '统部镇', '1', '150424106', null, '3', '1'),
('150424200', '150424', '大营子乡', '1', '150424200', null, '3', '1'),
('150425100', '150425', '经棚镇', '1', '150425100', null, '3', '1'),
('150425101', '150425', '宇宙地镇', '1', '150425101', null, '3', '1'),
('150425102', '150425', '土城子镇', '1', '150425102', null, '3', '1'),
('150425103', '150425', '同兴镇', '1', '150425103', null, '3', '1'),
('150425104', '150425', '万合永镇', '1', '150425104', null, '3', '1'),
('150425105', '150425', '芝瑞镇', '1', '150425105', null, '3', '1'),
('150425106', '150425', '达来诺日镇', '1', '150425106', null, '3', '1'),
('150425200', '150425', '新开地乡', '1', '150425200', null, '3', '1'),
('150425201', '150425', '红山子乡', '1', '150425201', null, '3', '1'),
('150425202', '150425', '达日罕乌拉苏木乡', '1', '150425202', null, '3', '1'),
('150425203', '150425', '巴彦查干苏木乡', '1', '150425203', null, '3', '1'),
('150426100', '150426', '乌丹镇', '1', '150426100', null, '3', '1'),
('150426101', '150426', '乌敦套海镇', '1', '150426101', null, '3', '1'),
('150426102', '150426', '五分地镇', '1', '150426102', null, '3', '1'),
('150426103', '150426', '桥头镇', '1', '150426103', null, '3', '1'),
('150426104', '150426', '广德公镇', '1', '150426104', null, '3', '1'),
('150426105', '150426', '梧桐花镇', '1', '150426105', null, '3', '1'),
('150426106', '150426', '海日苏镇', '1', '150426106', null, '3', '1'),
('150426107', '150426', '亿合公镇', '1', '150426107', null, '3', '1'),
('150426200', '150426', '解放营子乡', '1', '150426200', null, '3', '1'),
('150426201', '150426', '阿什罕苏木乡', '1', '150426201', null, '3', '1'),
('150426202', '150426', '白音他拉苏木乡', '1', '150426202', null, '3', '1'),
('150426203', '150426', '白音套海苏木乡', '1', '150426203', null, '3', '1'),
('150428100', '150428', '锦山镇', '1', '150428100', null, '3', '1'),
('150428101', '150428', '美林镇', '1', '150428101', null, '3', '1'),
('150428102', '150428', '王爷府镇', '1', '150428102', null, '3', '1'),
('150428103', '150428', '小牛群镇', '1', '150428103', null, '3', '1'),
('150428104', '150428', '牛家营子镇', '1', '150428104', null, '3', '1'),
('150428105', '150428', '乃林镇', '1', '150428105', null, '3', '1'),
('150428106', '150428', '西桥镇', '1', '150428106', null, '3', '1'),
('150428200', '150428', '十家满族乡', '1', '150428200', null, '3', '1'),
('150428400', '150428', '乃林果树农场', '1', '150428400', null, '3', '1'),
('150428401', '150428', '马鞍山羊场', '1', '150428401', null, '3', '1'),
('150429100', '150429', '天义镇政府', '1', '150429100', null, '3', '1'),
('150429101', '150429', '小城子镇政府', '1', '150429101', null, '3', '1'),
('150429102', '150429', '大城子镇政府', '1', '150429102', null, '3', '1'),
('150429103', '150429', '八里罕镇政府', '1', '150429103', null, '3', '1'),
('150429104', '150429', '黑里河镇政府', '1', '150429104', null, '3', '1'),
('150429105', '150429', '甸子镇政府', '1', '150429105', null, '3', '1'),
('150429106', '150429', '大双庙镇政府', '1', '150429106', null, '3', '1'),
('150429107', '150429', '汐子镇政府', '1', '150429107', null, '3', '1'),
('150429108', '150429', '大明镇政府', '1', '150429108', null, '3', '1'),
('150429109', '150429', '忙农镇政府', '1', '150429109', null, '3', '1'),
('150429200', '150429', '三座店乡政府', '1', '150429200', null, '3', '1'),
('150429201', '150429', '必斯营子乡政府', '1', '150429201', null, '3', '1'),
('150429202', '150429', '五化乡政府', '1', '150429202', null, '3', '1'),
('150430100', '150430', '新惠镇', '1', '150430100', null, '3', '1'),
('150430101', '150430', '四家子镇', '1', '150430101', null, '3', '1'),
('150430102', '150430', '长胜镇', '1', '150430102', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('150430103', '150430', '贝子府镇', '1', '150430103', null, '3', '1'),
('150430104', '150430', '四道湾子镇', '1', '150430104', null, '3', '1'),
('150430105', '150430', '下洼镇', '1', '150430105', null, '3', '1'),
('150430106', '150430', '金厂沟梁镇', '1', '150430106', null, '3', '1'),
('150430200', '150430', '宝国吐乡', '1', '150430200', null, '3', '1'),
('150430201', '150430', '牛古吐乡', '1', '150430201', null, '3', '1'),
('150430202', '150430', '木头营子乡', '1', '150430202', null, '3', '1'),
('150430203', '150430', '古鲁板蒿乡', '1', '150430203', null, '3', '1'),
('150430204', '150430', '丰收乡', '1', '150430204', null, '3', '1'),
('150430205', '150430', '玛尼罕乡', '1', '150430205', null, '3', '1'),
('150430206', '150430', '萨力巴乡', '1', '150430206', null, '3', '1'),
('150430207', '150430', '敖润苏莫苏木乡', '1', '150430207', null, '3', '1'),
('150502001', '150502', '科尔沁街道', '1', '150502001', null, '3', '1'),
('150502002', '150502', '西门街道', '1', '150502002', null, '3', '1'),
('150502003', '150502', '永清街道', '1', '150502003', null, '3', '1'),
('150502004', '150502', '明仁街道', '1', '150502004', null, '3', '1'),
('150502005', '150502', '施介街道', '1', '150502005', null, '3', '1'),
('150502006', '150502', '清真街道', '1', '150502006', null, '3', '1'),
('150502007', '150502', '东郊街道', '1', '150502007', null, '3', '1'),
('150502008', '150502', '铁路街道', '1', '150502008', null, '3', '1'),
('150502009', '150502', '红星街道', '1', '150502009', null, '3', '1'),
('150502010', '150502', '霍林街道', '1', '150502010', null, '3', '1'),
('150502011', '150502', '建国街道', '1', '150502011', null, '3', '1'),
('150502020', '150502', '河西街道', '1', '150502020', null, '3', '1'),
('150502021', '150502', '电厂街道', '1', '150502021', null, '3', '1'),
('150502100', '150502', '大林镇', '1', '150502100', null, '3', '1'),
('150502101', '150502', '钱家店镇', '1', '150502101', null, '3', '1'),
('150502102', '150502', '余粮堡镇', '1', '150502102', null, '3', '1'),
('150502103', '150502', '木里图镇', '1', '150502103', null, '3', '1'),
('150502104', '150502', '丰田镇', '1', '150502104', null, '3', '1'),
('150502105', '150502', '清河镇', '1', '150502105', null, '3', '1'),
('150502106', '150502', '育新镇', '1', '150502106', null, '3', '1'),
('150502107', '150502', '庆和镇', '1', '150502107', null, '3', '1'),
('150502108', '150502', '敖力布皋镇', '1', '150502108', null, '3', '1'),
('150502130', '150502', '辽河镇', '1', '150502130', null, '3', '1'),
('150502200', '150502', '莫力庙苏木乡', '1', '150502200', null, '3', '1'),
('150502400', '150502', '哲南农场', '1', '150502400', null, '3', '1'),
('150502401', '150502', '三义堂农场', '1', '150502401', null, '3', '1'),
('150502402', '150502', '高林屯种畜场', '1', '150502402', null, '3', '1'),
('150502403', '150502', '胡力海原种繁殖场', '1', '150502403', null, '3', '1'),
('150502404', '150502', '莫力庙羊场', '1', '150502404', null, '3', '1'),
('150502405', '150502', '半截店牧场', '1', '150502405', null, '3', '1'),
('150521100', '150521', '保康镇', '1', '150521100', null, '3', '1'),
('150521101', '150521', '宝龙山镇', '1', '150521101', null, '3', '1'),
('150521102', '150521', '舍伯吐镇', '1', '150521102', null, '3', '1'),
('150521103', '150521', '巴彦塔拉镇', '1', '150521103', null, '3', '1'),
('150521104', '150521', '门达镇', '1', '150521104', null, '3', '1'),
('150521105', '150521', '架玛吐镇', '1', '150521105', null, '3', '1'),
('150521106', '150521', '腰林毛都镇', '1', '150521106', null, '3', '1'),
('150521107', '150521', '希伯花镇', '1', '150521107', null, '3', '1'),
('150521108', '150521', '花吐古拉镇', '1', '150521108', null, '3', '1'),
('150521109', '150521', '代力吉镇', '1', '150521109', null, '3', '1'),
('150521110', '150521', '努日木镇', '1', '150521110', null, '3', '1'),
('150521200', '150521', '花胡硕苏木乡', '1', '150521200', null, '3', '1'),
('150521201', '150521', '协代苏木乡', '1', '150521201', null, '3', '1'),
('150521202', '150521', '白兴吐苏木乡', '1', '150521202', null, '3', '1'),
('150521203', '150521', '图布信苏木乡', '1', '150521203', null, '3', '1'),
('150521400', '150521', '东苏林场', '1', '150521400', null, '3', '1'),
('150522100', '150522', '甘旗卡镇', '1', '150522100', null, '3', '1'),
('150522101', '150522', '吉尔嘎朗镇', '1', '150522101', null, '3', '1'),
('150522102', '150522', '金宝屯镇', '1', '150522102', null, '3', '1'),
('150522103', '150522', '常胜镇', '1', '150522103', null, '3', '1'),
('150522104', '150522', '查日苏镇', '1', '150522104', null, '3', '1'),
('150522105', '150522', '双胜镇', '1', '150522105', null, '3', '1'),
('150522106', '150522', '阿古拉镇', '1', '150522106', null, '3', '1'),
('150522107', '150522', '朝鲁吐镇', '1', '150522107', null, '3', '1'),
('150522108', '150522', '努古斯台镇', '1', '150522108', null, '3', '1'),
('150522109', '150522', '海鲁吐镇', '1', '150522109', null, '3', '1'),
('150522200', '150522', '阿都沁苏木乡', '1', '150522200', null, '3', '1'),
('150522201', '150522', '茂道吐苏木乡', '1', '150522201', null, '3', '1'),
('150522400', '150522', '胜利农场', '1', '150522400', null, '3', '1'),
('150522401', '150522', '孟根达坝牧场', '1', '150522401', null, '3', '1'),
('150522402', '150522', '查金台牧场', '1', '150522402', null, '3', '1'),
('150522403', '150522', '原种场', '1', '150522403', null, '3', '1'),
('150522404', '150522', '大青沟管理局', '1', '150522404', null, '3', '1'),
('150522405', '150522', '哈日乌苏种畜场', '1', '150522405', null, '3', '1'),
('150522406', '150522', '乌兰敖道渔场', '1', '150522406', null, '3', '1'),
('150522407', '150522', '金宝屯林场', '1', '150522407', null, '3', '1'),
('150522408', '150522', '朝鲁吐林场', '1', '150522408', null, '3', '1'),
('150522409', '150522', '茂道吐林场', '1', '150522409', null, '3', '1'),
('150522410', '150522', '伊胡塔林场', '1', '150522410', null, '3', '1'),
('150522411', '150522', '乌旦塔拉林场', '1', '150522411', null, '3', '1'),
('150523100', '150523', '开鲁镇', '1', '150523100', null, '3', '1'),
('150523101', '150523', '大榆树镇', '1', '150523101', null, '3', '1'),
('150523102', '150523', '黑龙坝镇', '1', '150523102', null, '3', '1'),
('150523103', '150523', '麦新镇', '1', '150523103', null, '3', '1'),
('150523104', '150523', '义和塔拉镇', '1', '150523104', null, '3', '1'),
('150523105', '150523', '建华镇', '1', '150523105', null, '3', '1'),
('150523106', '150523', '小街基镇', '1', '150523106', null, '3', '1'),
('150523107', '150523', '东风镇', '1', '150523107', null, '3', '1'),
('150523108', '150523', '吉日嘎郎吐镇', '1', '150523108', null, '3', '1'),
('150523109', '150523', '东来镇', '1', '150523109', null, '3', '1'),
('150523400', '150523', '清河牧场', '1', '150523400', null, '3', '1'),
('150523401', '150523', '辽河农场', '1', '150523401', null, '3', '1'),
('150523402', '150523', '保安农场', '1', '150523402', null, '3', '1'),
('150524100', '150524', '库伦镇', '1', '150524100', null, '3', '1'),
('150524101', '150524', '扣河子镇', '1', '150524101', null, '3', '1'),
('150524102', '150524', '白音花镇', '1', '150524102', null, '3', '1'),
('150524103', '150524', '六家子镇', '1', '150524103', null, '3', '1'),
('150524104', '150524', '额勒顺镇', '1', '150524104', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('150524200', '150524', '茫汗苏木乡', '1', '150524200', null, '3', '1'),
('150525100', '150525', '大沁他拉镇', '1', '150525100', null, '3', '1'),
('150525101', '150525', '八仙筒镇', '1', '150525101', null, '3', '1'),
('150525102', '150525', '青龙山镇', '1', '150525102', null, '3', '1'),
('150525103', '150525', '新镇', '1', '150525103', null, '3', '1'),
('150525104', '150525', '治安镇', '1', '150525104', null, '3', '1'),
('150525105', '150525', '东明镇', '1', '150525105', null, '3', '1'),
('150525106', '150525', '土城子镇', '1', '150525106', null, '3', '1'),
('150525107', '150525', '义隆永镇', '1', '150525107', null, '3', '1'),
('150525200', '150525', '固日班花苏木乡', '1', '150525200', null, '3', '1'),
('150525201', '150525', '苇莲苏苏木乡', '1', '150525201', null, '3', '1'),
('150525202', '150525', '明仁苏木乡', '1', '150525202', null, '3', '1'),
('150525203', '150525', '黄花塔拉苏木乡', '1', '150525203', null, '3', '1'),
('150525400', '150525', '国有六号农场', '1', '150525400', null, '3', '1'),
('150526100', '150526', '鲁北镇', '1', '150526100', null, '3', '1'),
('150526101', '150526', '黄花山镇', '1', '150526101', null, '3', '1'),
('150526102', '150526', '嘎亥图镇', '1', '150526102', null, '3', '1'),
('150526103', '150526', '巨日合镇', '1', '150526103', null, '3', '1'),
('150526104', '150526', '巴雅尔图胡硕镇', '1', '150526104', null, '3', '1'),
('150526105', '150526', '香山镇', '1', '150526105', null, '3', '1'),
('150526106', '150526', '阿日昆都冷镇', '1', '150526106', null, '3', '1'),
('150526200', '150526', '巴彦塔拉苏木乡', '1', '150526200', null, '3', '1'),
('150526201', '150526', '乌力吉木仁苏木乡', '1', '150526201', null, '3', '1'),
('150526202', '150526', '道老杜苏木乡', '1', '150526202', null, '3', '1'),
('150526203', '150526', '格日朝鲁苏木乡', '1', '150526203', null, '3', '1'),
('150526400', '150526', '乌额格其牧场', '1', '150526400', null, '3', '1'),
('150526401', '150526', '香山农场', '1', '150526401', null, '3', '1'),
('150526402', '150526', '乌日根塔拉农场', '1', '150526402', null, '3', '1'),
('150526403', '150526', '嘎达苏种畜场', '1', '150526403', null, '3', '1'),
('150581001', '150581', '珠斯花街道', '1', '150581001', null, '3', '1'),
('150581002', '150581', '莫斯台街道', '1', '150581002', null, '3', '1'),
('150581003', '150581', '宝日呼吉尔街道', '1', '150581003', null, '3', '1'),
('150581004', '150581', '沙尔呼热街道', '1', '150581004', null, '3', '1'),
('150581005', '150581', '达来胡硕街道', '1', '150581005', null, '3', '1'),
('150581400', '150581', '东蒙农牧业有限责任公司', '1', '150581400', null, '3', '1'),
('150602001', '150602', '交通街道', '1', '150602001', null, '3', '1'),
('150602002', '150602', '公园街道', '1', '150602002', null, '3', '1'),
('150602003', '150602', '林荫街道', '1', '150602003', null, '3', '1'),
('150602004', '150602', '建设街道', '1', '150602004', null, '3', '1'),
('150602005', '150602', '富兴街道', '1', '150602005', null, '3', '1'),
('150602006', '150602', '天骄街道', '1', '150602006', null, '3', '1'),
('150602007', '150602', '哈巴格希街道', '1', '150602007', null, '3', '1'),
('150602008', '150602', '诃额伦街道', '1', '150602008', null, '3', '1'),
('150602009', '150602', '巴音孟克街道', '1', '150602009', null, '3', '1'),
('150602100', '150602', '泊尔江海子镇', '1', '150602100', null, '3', '1'),
('150602101', '150602', '罕台镇', '1', '150602101', null, '3', '1'),
('150602102', '150602', '塔拉壕镇', '1', '150602102', null, '3', '1'),
('150621100', '150621', '树林召镇', '1', '150621100', null, '3', '1'),
('150621101', '150621', '吉格斯太镇', '1', '150621101', null, '3', '1'),
('150621102', '150621', '白泥井镇', '1', '150621102', null, '3', '1'),
('150621103', '150621', '王爱召镇', '1', '150621103', null, '3', '1'),
('150621104', '150621', '昭君镇', '1', '150621104', null, '3', '1'),
('150621105', '150621', '恩格贝镇', '1', '150621105', null, '3', '1'),
('150621106', '150621', '中和西镇', '1', '150621106', null, '3', '1'),
('150621200', '150621', '展旦召苏木乡', '1', '150621200', null, '3', '1'),
('150622100', '150622', '薛家湾镇', '1', '150622100', null, '3', '1'),
('150622101', '150622', '沙圪堵镇', '1', '150622101', null, '3', '1'),
('150622102', '150622', '大路镇', '1', '150622102', null, '3', '1'),
('150622103', '150622', '纳日松镇', '1', '150622103', null, '3', '1'),
('150622104', '150622', '龙口镇', '1', '150622104', null, '3', '1'),
('150622105', '150622', '准格尔召镇', '1', '150622105', null, '3', '1'),
('150622200', '150622', '暖水乡', '1', '150622200', null, '3', '1'),
('150622201', '150622', '十二连城乡', '1', '150622201', null, '3', '1'),
('150622202', '150622', '布尔陶亥苏木乡', '1', '150622202', null, '3', '1'),
('150623100', '150623', '敖勒召其镇', '1', '150623100', null, '3', '1'),
('150623101', '150623', '上海庙镇', '1', '150623101', null, '3', '1'),
('150623102', '150623', '城川镇', '1', '150623102', null, '3', '1'),
('150623103', '150623', '昂素镇', '1', '150623103', null, '3', '1'),
('150623400', '150623', '上海庙经济开发区', '1', '150623400', null, '3', '1'),
('150624100', '150624', '乌兰镇', '1', '150624100', null, '3', '1'),
('150624101', '150624', '棋盘井镇', '1', '150624101', null, '3', '1'),
('150624102', '150624', '蒙西镇', '1', '150624102', null, '3', '1'),
('150624103', '150624', '木凯淖尔镇', '1', '150624103', null, '3', '1'),
('150624200', '150624', '苏米图苏木乡', '1', '150624200', null, '3', '1'),
('150624201', '150624', '阿尔巴斯苏木乡', '1', '150624201', null, '3', '1'),
('150624400', '150624', '鄂托克旗赛乌素草籽场', '1', '150624400', null, '3', '1'),
('150624401', '150624', '内蒙古白绒山羊种羊场', '1', '150624401', null, '3', '1'),
('150625100', '150625', '锡尼镇', '1', '150625100', null, '3', '1'),
('150625101', '150625', '巴拉贡镇', '1', '150625101', null, '3', '1'),
('150625102', '150625', '吉日嘎朗图镇', '1', '150625102', null, '3', '1'),
('150625103', '150625', '独贵塔拉镇', '1', '150625103', null, '3', '1'),
('150625104', '150625', '呼和木都镇', '1', '150625104', null, '3', '1'),
('150625200', '150625', '杭锦淖尔乡', '1', '150625200', null, '3', '1'),
('150625201', '150625', '伊和乌素苏木乡', '1', '150625201', null, '3', '1'),
('150625400', '150625', '哈拉淖农场', '1', '150625400', null, '3', '1'),
('150626100', '150626', '嘎鲁图镇', '1', '150626100', null, '3', '1'),
('150626101', '150626', '乌审召镇', '1', '150626101', null, '3', '1'),
('150626102', '150626', '图克镇', '1', '150626102', null, '3', '1'),
('150626103', '150626', '乌兰陶勒盖镇', '1', '150626103', null, '3', '1'),
('150626104', '150626', '无定河镇', '1', '150626104', null, '3', '1'),
('150626200', '150626', '苏力德苏木乡', '1', '150626200', null, '3', '1'),
('150626400', '150626', '种羊场', '1', '150626400', null, '3', '1'),
('150626401', '150626', '五个林场', '1', '150626401', null, '3', '1'),
('150627100', '150627', '阿勒腾席热镇', '1', '150627100', null, '3', '1'),
('150627101', '150627', '札萨克镇', '1', '150627101', null, '3', '1'),
('150627102', '150627', '乌兰木伦镇', '1', '150627102', null, '3', '1'),
('150627103', '150627', '纳林陶亥镇', '1', '150627103', null, '3', '1'),
('150627104', '150627', '苏布尔嘎镇', '1', '150627104', null, '3', '1'),
('150627105', '150627', '红庆河镇', '1', '150627105', null, '3', '1'),
('150627106', '150627', '伊金霍洛镇', '1', '150627106', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('150702001', '150702', '正阳', '1', '150702001', null, '3', '1'),
('150702002', '150702', '健康街道', '1', '150702002', null, '3', '1'),
('150702003', '150702', '靠山街道', '1', '150702003', null, '3', '1'),
('150702004', '150702', '胜利街道', '1', '150702004', null, '3', '1'),
('150702005', '150702', '呼伦街道', '1', '150702005', null, '3', '1'),
('150702006', '150702', '奋斗街道', '1', '150702006', null, '3', '1'),
('150702007', '150702', '建设街道', '1', '150702007', null, '3', '1'),
('150702100', '150702', '哈克镇', '1', '150702100', null, '3', '1'),
('150702400', '150702', '谢尔塔拉种牛场', '1', '150702400', null, '3', '1'),
('150702401', '150702', '哈克牧业有限公司', '1', '150702401', null, '3', '1'),
('150721100', '150721', '那吉镇', '1', '150721100', null, '3', '1'),
('150721101', '150721', '六合镇', '1', '150721101', null, '3', '1'),
('150721102', '150721', '亚东镇', '1', '150721102', null, '3', '1'),
('150721103', '150721', '霍尔奇镇', '1', '150721103', null, '3', '1'),
('150721104', '150721', '向阳峪镇', '1', '150721104', null, '3', '1'),
('150721200', '150721', '得力其鄂温克民族乡', '1', '150721200', null, '3', '1'),
('150721201', '150721', '查巴奇鄂温克民族乡', '1', '150721201', null, '3', '1'),
('150721202', '150721', '音河达斡尔鄂温克民族乡', '1', '150721202', null, '3', '1'),
('150721203', '150721', '新发朝鲜民族乡', '1', '150721203', null, '3', '1'),
('150721400', '150721', '那吉屯农场', '1', '150721400', null, '3', '1'),
('150721401', '150721', '格尼河农场', '1', '150721401', null, '3', '1'),
('150721402', '150721', '阿荣旗林业局', '1', '150721402', null, '3', '1'),
('150722100', '150722', '尼尔基镇', '1', '150722100', null, '3', '1'),
('150722101', '150722', '红彦镇', '1', '150722101', null, '3', '1'),
('150722102', '150722', '宝山镇', '1', '150722102', null, '3', '1'),
('150722103', '150722', '哈达阳镇', '1', '150722103', null, '3', '1'),
('150722104', '150722', '阿尔拉镇', '1', '150722104', null, '3', '1'),
('150722106', '150722', '西瓦尔图镇', '1', '150722106', null, '3', '1'),
('150722108', '150722', '腾克镇', '1', '150722108', null, '3', '1'),
('150722110', '150722', '塔温敖宝镇', '1', '150722110', null, '3', '1'),
('150722200', '150722', '巴彦鄂温克民族乡', '1', '150722200', null, '3', '1'),
('150722203', '150722', '杜拉尔鄂温克民族乡', '1', '150722203', null, '3', '1'),
('150722400', '150722', '国营甘河农场', '1', '150722400', null, '3', '1'),
('150722401', '150722', '国营巴彦农场', '1', '150722401', null, '3', '1'),
('150722402', '150722', '国营欧肯河农场', '1', '150722402', null, '3', '1'),
('150722403', '150722', '国营东方红农场', '1', '150722403', null, '3', '1'),
('150723100', '150723', '阿里河镇', '1', '150723100', null, '3', '1'),
('150723101', '150723', '大杨树镇', '1', '150723101', null, '3', '1'),
('150723102', '150723', '甘河镇', '1', '150723102', null, '3', '1'),
('150723103', '150723', '托扎敏镇', '1', '150723103', null, '3', '1'),
('150723104', '150723', '诺敏镇', '1', '150723104', null, '3', '1'),
('150723105', '150723', '乌鲁布铁镇', '1', '150723105', null, '3', '1'),
('150723200', '150723', '古里乡', '1', '150723200', null, '3', '1'),
('150723400', '150723', '大兴安岭管理局诺敏河农场', '1', '150723400', null, '3', '1'),
('150723401', '150723', '大兴安岭农场宜里农场', '1', '150723401', null, '3', '1'),
('150723402', '150723', '大兴安岭农场管理局扎赉河农场', '1', '150723402', null, '3', '1'),
('150723403', '150723', '大兴安岭农场管理局古里农场', '1', '150723403', null, '3', '1'),
('150723404', '150723', '加格达奇区', '1', '150723404', null, '3', '1'),
('150723405', '150723', '松岭地区', '1', '150723405', null, '3', '1'),
('150723406', '150723', '大杨树林业局', '1', '150723406', null, '3', '1'),
('150723407', '150723', '甘河林业局', '1', '150723407', null, '3', '1'),
('150723408', '150723', '克一河林业局', '1', '150723408', null, '3', '1'),
('150723409', '150723', '吉文林业局', '1', '150723409', null, '3', '1'),
('150723410', '150723', '阿里河林业局', '1', '150723410', null, '3', '1'),
('150723411', '150723', '大兴安岭农工商联合公司', '1', '150723411', null, '3', '1'),
('150723412', '150723', '大兴安岭农场管理局东方红农场', '1', '150723412', null, '3', '1'),
('150723413', '150723', '大兴安岭农场管理局欧肯河农场', '1', '150723413', null, '3', '1'),
('150723414', '150723', '大兴安岭林管局毕拉河林业局', '1', '150723414', null, '3', '1'),
('150723415', '150723', '大兴安岭林管局伊图里河林业局', '1', '150723415', null, '3', '1'),
('150723416', '150723', '大兴安岭林管局库都尔林业局', '1', '150723416', null, '3', '1'),
('150723417', '150723', '大兴安岭林管局乌尔其汗林业局', '1', '150723417', null, '3', '1'),
('150724100', '150724', '巴彦托海镇', '1', '150724100', null, '3', '1'),
('150724101', '150724', '巴雁镇', '1', '150724101', null, '3', '1'),
('150724102', '150724', '伊敏河镇', '1', '150724102', null, '3', '1'),
('150724103', '150724', '锡尼河镇', '1', '150724103', null, '3', '1'),
('150724200', '150724', '巴彦塔拉达斡尔民族乡', '1', '150724200', null, '3', '1'),
('150724201', '150724', '伊敏苏木乡', '1', '150724201', null, '3', '1'),
('150724202', '150724', '辉苏木乡', '1', '150724202', null, '3', '1'),
('150724400', '150724', '巴彦托海经济开发区', '1', '150724400', null, '3', '1'),
('150724401', '150724', '伊敏河高载能工业园区', '1', '150724401', null, '3', '1'),
('150724402', '150724', '大雁马铃薯高新技术示范园区', '1', '150724402', null, '3', '1'),
('150725100', '150725', '陈旗巴彦库仁镇', '1', '150725100', null, '3', '1'),
('150725101', '150725', '陈旗宝日希勒镇', '1', '150725101', null, '3', '1'),
('150725102', '150725', '陈旗呼和诺尔镇', '1', '150725102', null, '3', '1'),
('150725200', '150725', '陈旗乌珠尔苏木乡', '1', '150725200', null, '3', '1'),
('150725201', '150725', '陈旗鄂温克民族苏木乡', '1', '150725201', null, '3', '1'),
('150725400', '150725', '陈旗国营哈达图农牧场', '1', '150725400', null, '3', '1'),
('150725401', '150725', '陈旗国营浩特陶海农牧场', '1', '150725401', null, '3', '1'),
('150725402', '150725', '陈旗国营特泥河农牧场', '1', '150725402', null, '3', '1'),
('150726100', '150726', '阿木古郎镇', '1', '150726100', null, '3', '1'),
('150726101', '150726', '嵯岗镇', '1', '150726101', null, '3', '1'),
('150726200', '150726', '乌布尔宝力格苏木乡', '1', '150726200', null, '3', '1'),
('150726201', '150726', '吉布胡郎图苏木乡', '1', '150726201', null, '3', '1'),
('150726202', '150726', '新宝力格苏木乡', '1', '150726202', null, '3', '1'),
('150726400', '150726', '嵯岗镇双娃牧场', '1', '150726400', null, '3', '1'),
('150727100', '150727', '阿拉坦额莫勒镇', '1', '150727100', null, '3', '1'),
('150727101', '150727', '阿日哈沙特镇', '1', '150727101', null, '3', '1'),
('150727102', '150727', '新巴尔虎右旗呼伦镇', '1', '150727102', null, '3', '1'),
('150727200', '150727', '贝尔苏木乡', '1', '150727200', null, '3', '1'),
('150727201', '150727', '克尔伦苏木乡', '1', '150727201', null, '3', '1'),
('150727400', '150727', '敖尔金牧场', '1', '150727400', null, '3', '1'),
('150781001', '150781', '东山街道', '1', '150781001', null, '3', '1'),
('150781002', '150781', '道南街道', '1', '150781002', null, '3', '1'),
('150781003', '150781', '道北街道', '1', '150781003', null, '3', '1'),
('150781004', '150781', '兴华街道', '1', '150781004', null, '3', '1'),
('150781005', '150781', '满洲里市第一', '1', '150781005', null, '3', '1'),
('150781006', '150781', '满洲里市第二', '1', '150781006', null, '3', '1'),
('150781007', '150781', '满洲里市第三', '1', '150781007', null, '3', '1'),
('150781008', '150781', '满洲里市第四', '1', '150781008', null, '3', '1'),
('150781009', '150781', '满洲里市第五', '1', '150781009', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('150781010', '150781', '满洲里市灵泉街道', '1', '150781010', null, '3', '1'),
('150781011', '150781', '新开河街道', '1', '150781011', null, '3', '1'),
('150781400', '150781', '满洲里市互市贸易区', '1', '150781400', null, '3', '1'),
('150781401', '150781', '满洲里市经济合作区', '1', '150781401', null, '3', '1'),
('150781402', '150781', '满洲里市东湖区', '1', '150781402', null, '3', '1'),
('150781403', '150781', '满洲里市扎煤公司', '1', '150781403', null, '3', '1'),
('150781404', '150781', '扎赉诺尔矿区', '1', '150781404', null, '3', '1'),
('150782001', '150782', '胜利街道', '1', '150782001', null, '3', '1'),
('150782002', '150782', '红旗街道', '1', '150782002', null, '3', '1'),
('150782003', '150782', '新工街道', '1', '150782003', null, '3', '1'),
('150782004', '150782', '永兴街道', '1', '150782004', null, '3', '1'),
('150782005', '150782', '建设街道', '1', '150782005', null, '3', '1'),
('150782006', '150782', '暖泉街道', '1', '150782006', null, '3', '1'),
('150782007', '150782', '牧原街道', '1', '150782007', null, '3', '1'),
('150782100', '150782', '免渡河镇', '1', '150782100', null, '3', '1'),
('150782101', '150782', '博克图镇', '1', '150782101', null, '3', '1'),
('150782102', '150782', '绰源镇', '1', '150782102', null, '3', '1'),
('150782103', '150782', '乌尔其汉镇', '1', '150782103', null, '3', '1'),
('150782104', '150782', '库都尔镇', '1', '150782104', null, '3', '1'),
('150782105', '150782', '图里河镇', '1', '150782105', null, '3', '1'),
('150782400', '150782', '莫拐农场', '1', '150782400', null, '3', '1'),
('150782401', '150782', '牙克石农场', '1', '150782401', null, '3', '1'),
('150782402', '150782', '免渡河农场', '1', '150782402', null, '3', '1'),
('150783001', '150783', '兴华街道', '1', '150783001', null, '3', '1'),
('150783002', '150783', '正阳街道', '1', '150783002', null, '3', '1'),
('150783003', '150783', '繁荣街道', '1', '150783003', null, '3', '1'),
('150783004', '150783', '向阳街道', '1', '150783004', null, '3', '1'),
('150783005', '150783', '高台子街道', '1', '150783005', null, '3', '1'),
('150783006', '150783', '铁东街道', '1', '150783006', null, '3', '1'),
('150783007', '150783', '河西街道', '1', '150783007', null, '3', '1'),
('150783100', '150783', '磨菇气镇', '1', '150783100', null, '3', '1'),
('150783101', '150783', '洼堤镇', '1', '150783101', null, '3', '1'),
('150783102', '150783', '卧牛河镇', '1', '150783102', null, '3', '1'),
('150783103', '150783', '成吉思汗镇', '1', '150783103', null, '3', '1'),
('150783104', '150783', '大河湾镇', '1', '150783104', null, '3', '1'),
('150783105', '150783', '浩饶山镇', '1', '150783105', null, '3', '1'),
('150783200', '150783', '达斡尔民族乡', '1', '150783200', null, '3', '1'),
('150783201', '150783', '南木鄂伦春民族乡', '1', '150783201', null, '3', '1'),
('150783202', '150783', '萨马街鄂温克民族乡', '1', '150783202', null, '3', '1'),
('150783400', '150783', '大河湾农场', '1', '150783400', null, '3', '1'),
('150783401', '150783', '绰尔河农场', '1', '150783401', null, '3', '1'),
('150783402', '150783', '扎兰屯马场', '1', '150783402', null, '3', '1'),
('150783403', '150783', '成吉思汗监狱农场', '1', '150783403', null, '3', '1'),
('150783404', '150783', '公安部后勤供应处农场', '1', '150783404', null, '3', '1'),
('150783405', '150783', '南木林业局', '1', '150783405', null, '3', '1'),
('150783406', '150783', '柴河林业局', '1', '150783406', null, '3', '1'),
('150783407', '150783', '扎兰屯市林业局', '1', '150783407', null, '3', '1'),
('150783408', '150783', '市原种场', '1', '150783408', null, '3', '1'),
('150784001', '150784', '拉布达林街道', '1', '150784001', null, '3', '1'),
('150784002', '150784', '上库力街道', '1', '150784002', null, '3', '1'),
('150784100', '150784', '莫尔道嘎镇', '1', '150784100', null, '3', '1'),
('150784101', '150784', '黑山头镇', '1', '150784101', null, '3', '1'),
('150784200', '150784', '三河回族乡', '1', '150784200', null, '3', '1'),
('150784201', '150784', '室韦俄罗斯族民族乡', '1', '150784201', null, '3', '1'),
('150784400', '150784', '海拉尔农垦集团有限公司拉布大林农场分公司', '1', '150784400', null, '3', '1'),
('150784401', '150784', '三河金騋农牧有限责任公司', '1', '150784401', null, '3', '1'),
('150784402', '150784', '海拉尔农垦集团有限责任公司上库力农场分公', '1', '150784402', null, '3', '1'),
('150784403', '150784', '海拉尔农垦集团有限责任公司苏沁牧场分公司', '1', '150784403', null, '3', '1'),
('150784404', '150784', '海拉尔农垦集团有限责任公司恩和牧场分公司', '1', '150784404', null, '3', '1'),
('150784405', '150784', '室韦牧场', '1', '150784405', null, '3', '1'),
('150785001', '150785', '河东街道', '1', '150785001', null, '3', '1'),
('150785002', '150785', '河西街道', '1', '150785002', null, '3', '1'),
('150785003', '150785', '森工路街道', '1', '150785003', null, '3', '1'),
('150785101', '150785', '金河镇', '1', '150785101', null, '3', '1'),
('150785102', '150785', '阿龙山镇', '1', '150785102', null, '3', '1'),
('150785103', '150785', '满归镇', '1', '150785103', null, '3', '1'),
('150785200', '150785', '敖鲁古雅乡', '1', '150785200', null, '3', '1'),
('150802001', '150802', '团结', '1', '150802001', null, '3', '1'),
('150802002', '150802', '车站', '1', '150802002', null, '3', '1'),
('150802003', '150802', '先锋', '1', '150802003', null, '3', '1'),
('150802004', '150802', '解放', '1', '150802004', null, '3', '1'),
('150802005', '150802', '新华', '1', '150802005', null, '3', '1'),
('150802006', '150802', '东环', '1', '150802006', null, '3', '1'),
('150802007', '150802', '铁南', '1', '150802007', null, '3', '1'),
('150802008', '150802', '西环路', '1', '150802008', null, '3', '1'),
('150802009', '150802', '北环', '1', '150802009', null, '3', '1'),
('150802010', '150802', '曙光', '1', '150802010', null, '3', '1'),
('150802100', '150802', '狼山镇', '1', '150802100', null, '3', '1'),
('150802101', '150802', '新华镇', '1', '150802101', null, '3', '1'),
('150802102', '150802', '干召庙镇', '1', '150802102', null, '3', '1'),
('150802103', '150802', '乌兰图克镇', '1', '150802103', null, '3', '1'),
('150802104', '150802', '双河镇', '1', '150802104', null, '3', '1'),
('150802105', '150802', '城关镇', '1', '150802105', null, '3', '1'),
('150802106', '150802', '白脑包镇', '1', '150802106', null, '3', '1'),
('150802400', '150802', '狼山农场', '1', '150802400', null, '3', '1'),
('150802401', '150802', '临河农场', '1', '150802401', null, '3', '1'),
('150821100', '150821', '隆兴昌镇', '1', '150821100', null, '3', '1'),
('150821101', '150821', '塔尔湖镇', '1', '150821101', null, '3', '1'),
('150821102', '150821', '套海镇', '1', '150821102', null, '3', '1'),
('150821103', '150821', '新公中镇', '1', '150821103', null, '3', '1'),
('150821104', '150821', '天吉太镇', '1', '150821104', null, '3', '1'),
('150821105', '150821', '胜丰镇', '1', '150821105', null, '3', '1'),
('150821106', '150821', '银定图镇', '1', '150821106', null, '3', '1'),
('150821400', '150821', '巴盟国营建丰农场', '1', '150821400', null, '3', '1'),
('150821401', '150821', '内蒙古东土城劳动教养管理所', '1', '150821401', null, '3', '1'),
('150822100', '150822', '巴彦高勒镇', '1', '150822100', null, '3', '1'),
('150822101', '150822', '隆盛合镇', '1', '150822101', null, '3', '1'),
('150822102', '150822', '渡口镇', '1', '150822102', null, '3', '1'),
('150822200', '150822', '沙金套海苏木乡', '1', '150822200', null, '3', '1'),
('150822400', '150822', '乌兰布和农场', '1', '150822400', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('150822401', '150822', '巴彦套海农场', '1', '150822401', null, '3', '1'),
('150822402', '150822', '哈腾套海农场', '1', '150822402', null, '3', '1'),
('150822403', '150822', '包尔盖农场', '1', '150822403', null, '3', '1'),
('150822404', '150822', '纳林套海农场', '1', '150822404', null, '3', '1'),
('150822405', '150822', '沙漠林业实验中心', '1', '150822405', null, '3', '1'),
('150823100', '150823', '乌拉山镇', '1', '150823100', null, '3', '1'),
('150823101', '150823', '白彦花镇', '1', '150823101', null, '3', '1'),
('150823102', '150823', '先锋镇', '1', '150823102', null, '3', '1'),
('150823103', '150823', '新安镇', '1', '150823103', null, '3', '1'),
('150823104', '150823', '西小召镇', '1', '150823104', null, '3', '1'),
('150823105', '150823', '大佘太镇', '1', '150823105', null, '3', '1'),
('150823106', '150823', '明安镇', '1', '150823106', null, '3', '1'),
('150823107', '150823', '小佘太镇', '1', '150823107', null, '3', '1'),
('150823200', '150823', '额尔登布拉格苏木乡', '1', '150823200', null, '3', '1'),
('150823400', '150823', '巴彦淖尔市中滩农场', '1', '150823400', null, '3', '1'),
('150823401', '150823', '巴彦淖尔市西山咀农场', '1', '150823401', null, '3', '1'),
('150823402', '150823', '巴彦淖尔市新安农场', '1', '150823402', null, '3', '1'),
('150823403', '150823', '巴彦淖尔市苏独仑农场', '1', '150823403', null, '3', '1'),
('150823404', '150823', '巴彦淖尔市大佘太牧场', '1', '150823404', null, '3', '1'),
('150823405', '150823', '巴彦淖尔市乌梁素海渔场', '1', '150823405', null, '3', '1'),
('150824100', '150824', '海流图镇', '1', '150824100', null, '3', '1'),
('150824101', '150824', '乌加河镇', '1', '150824101', null, '3', '1'),
('150824102', '150824', '德岭山镇', '1', '150824102', null, '3', '1'),
('150824103', '150824', '石哈河镇', '1', '150824103', null, '3', '1'),
('150824200', '150824', '呼鲁斯太苏木乡', '1', '150824200', null, '3', '1'),
('150824201', '150824', '川井苏木乡', '1', '150824201', null, '3', '1'),
('150824202', '150824', '巴音乌兰苏木乡', '1', '150824202', null, '3', '1'),
('150824203', '150824', '新忽热苏木乡', '1', '150824203', null, '3', '1'),
('150824400', '150824', '牧羊海牧场', '1', '150824400', null, '3', '1'),
('150824401', '150824', '同和太种畜场', '1', '150824401', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('150824402', '150824', '巴盟乌北林场', '1', '150824402', null, '3', '1'),
('150825100', '150825', '巴音宝力格镇', '1', '150825100', null, '3', '1'),
('150825101', '150825', '呼和温都尔镇', '1', '150825101', null, '3', '1'),
('150825102', '150825', '潮格温都尔镇', '1', '150825102', null, '3', '1'),
('150825200', '150825', '获各琦苏木乡', '1', '150825200', null, '3', '1'),
('150825201', '150825', '巴音前达门苏木乡', '1', '150825201', null, '3', '1'),
('150826100', '150826', '陕坝镇', '1', '150826100', null, '3', '1'),
('150826101', '150826', '头道桥镇', '1', '150826101', null, '3', '1'),
('150826102', '150826', '二道桥镇', '1', '150826102', null, '3', '1'),
('150826103', '150826', '三道桥镇', '1', '150826103', null, '3', '1'),
('150826104', '150826', '蛮会镇', '1', '150826104', null, '3', '1'),
('150826105', '150826', '团结镇', '1', '150826105', null, '3', '1'),
('150826106', '150826', '双庙镇', '1', '150826106', null, '3', '1'),
('150826107', '150826', '沙海镇', '1', '150826107', null, '3', '1'),
('150826400', '150826', '巴市太阳庙农场', '1', '150826400', null, '3', '1'),
('150902001', '150902', '新体路街道', '1', '150902001', null, '3', '1'),
('150902002', '150902', '桥东街道', '1', '150902002', null, '3', '1'),
('150902003', '150902', '前进路街道', '1', '150902003', null, '3', '1'),
('150902004', '150902', '常青街道', '1', '150902004', null, '3', '1'),
('150902005', '150902', '虎山街道', '1', '150902005', null, '3', '1'),
('150902006', '150902', '桥西街道', '1', '150902006', null, '3', '1'),
('150902007', '150902', '新华街街道', '1', '150902007', null, '3', '1'),
('150902008', '150902', '泉山街道', '1', '150902008', null, '3', '1'),
('150902105', '150902', '白海子镇', '1', '150902105', null, '3', '1'),
('150902205', '150902', '马莲渠乡', '1', '150902205', null, '3', '1'),
('150921106', '150921', '卓资山镇', '1', '150921106', null, '3', '1'),
('150921107', '150921', '旗下营镇', '1', '150921107', null, '3', '1'),
('150921108', '150921', '十八台镇', '1', '150921108', null, '3', '1'),
('150921109', '150921', '巴音锡勒镇', '1', '150921109', null, '3', '1'),
('150921110', '150921', '梨花镇', '1', '150921110', null, '3', '1'),
('150921210', '150921', '大榆树乡', '1', '150921210', null, '3', '1'),
('150921211', '150921', '红召乡', '1', '150921211', null, '3', '1'),
('150922103', '150922', '长顺镇', '1', '150922103', null, '3', '1'),
('150922104', '150922', '朝阳镇', '1', '150922104', null, '3', '1'),
('150922105', '150922', '七号镇', '1', '150922105', null, '3', '1'),
('150922300', '150922', '德包图乡', '1', '150922300', null, '3', '1'),
('150922301', '150922', '公腊胡洞乡', '1', '150922301', null, '3', '1'),
('150923101', '150923', '七台镇', '1', '150923101', null, '3', '1'),
('150923102', '150923', '十八顷镇', '1', '150923102', null, '3', '1'),
('150923103', '150923', '大黑沙土镇', '1', '150923103', null, '3', '1'),
('150923104', '150923', '西井子镇', '1', '150923104', null, '3', '1'),
('150923105', '150923', '屯垦队镇', '1', '150923105', null, '3', '1'),
('150923106', '150923', '小海子镇', '1', '150923106', null, '3', '1'),
('150923300', '150923', '大库伦乡', '1', '150923300', null, '3', '1'),
('150923301', '150923', '卯都乡', '1', '150923301', null, '3', '1'),
('150923302', '150923', '玻璃忽镜乡', '1', '150923302', null, '3', '1'),
('150924106', '150924', '城关镇', '1', '150924106', null, '3', '1'),
('150924107', '150924', '张皋镇', '1', '150924107', null, '3', '1'),
('150924108', '150924', '赛乌素镇', '1', '150924108', null, '3', '1'),
('150924109', '150924', '鄂尔栋镇', '1', '150924109', null, '3', '1'),
('150924110', '150924', '店子镇', '1', '150924110', null, '3', '1'),
('150924209', '150924', '大库联乡', '1', '150924209', null, '3', '1'),
('150924210', '150924', '民族团结乡', '1', '150924210', null, '3', '1'),
('150924400', '150924', '南部矿区管委会', '1', '150924400', null, '3', '1'),
('150925103', '150925', '岱海镇', '1', '150925103', null, '3', '1'),
('150925104', '150925', '六苏木镇', '1', '150925104', null, '3', '1'),
('150925105', '150925', '麦胡图镇', '1', '150925105', null, '3', '1'),
('150925106', '150925', '永兴镇', '1', '150925106', null, '3', '1'),
('150925107', '150925', '蛮汉镇', '1', '150925107', null, '3', '1'),
('150925218', '150925', '天成乡', '1', '150925218', null, '3', '1'),
('150925219', '150925', '曹碾满族乡', '1', '150925219', null, '3', '1'),
('150925400', '150925', '岱海循环工业发展区', '1', '150925400', null, '3', '1'),
('150925401', '150925', '蛮汉山林场', '1', '150925401', null, '3', '1'),
('150925402', '150925', '岱海林场', '1', '150925402', null, '3', '1'),
('150926105', '150926', '土贵乌拉镇', '1', '150926105', null, '3', '1'),
('150926106', '150926', '平地泉镇', '1', '150926106', null, '3', '1'),
('150926107', '150926', '玫瑰营镇', '1', '150926107', null, '3', '1'),
('150926108', '150926', '巴音塔拉镇', '1', '150926108', null, '3', '1'),
('150926209', '150926', '乌拉哈乌拉乡', '1', '150926209', null, '3', '1'),
('150926210', '150926', '黄茂营乡', '1', '150926210', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('150926211', '150926', '三岔口乡', '1', '150926211', null, '3', '1'),
('150926500', '150926', '移民区管委会', '1', '150926500', null, '3', '1'),
('150927103', '150927', '科布尔镇', '1', '150927103', null, '3', '1'),
('150927104', '150927', '铁沙盖镇', '1', '150927104', null, '3', '1'),
('150927105', '150927', '黄羊城镇', '1', '150927105', null, '3', '1'),
('150927106', '150927', '广益隆镇', '1', '150927106', null, '3', '1'),
('150927107', '150927', '乌素图镇', '1', '150927107', null, '3', '1'),
('150927216', '150927', '大滩乡', '1', '150927216', null, '3', '1'),
('150927217', '150927', '宏盘乡', '1', '150927217', null, '3', '1'),
('150927218', '150927', '巴音乡', '1', '150927218', null, '3', '1'),
('150927219', '150927', '库联苏木乡', '1', '150927219', null, '3', '1'),
('150927220', '150927', '乌兰哈页苏木乡', '1', '150927220', null, '3', '1'),
('150928105', '150928', '白音察干镇', '1', '150928105', null, '3', '1'),
('150928106', '150928', '察哈尔右翼后旗土牧尔台镇', '1', '150928106', null, '3', '1'),
('150928107', '150928', '察哈尔右翼后旗红格尔图镇', '1', '150928107', null, '3', '1'),
('150928108', '150928', '察哈尔右翼后旗贲红镇', '1', '150928108', null, '3', '1'),
('150928209', '150928', '察哈尔右翼后旗当郎忽洞苏木乡', '1', '150928209', null, '3', '1'),
('150928210', '150928', '察哈尔右翼后旗乌兰哈达苏木乡', '1', '150928210', null, '3', '1'),
('150928211', '150928', '察哈尔右翼后旗锡勒乡', '1', '150928211', null, '3', '1'),
('150929101', '150929', '四子王旗乌兰花镇', '1', '150929101', null, '3', '1'),
('150929102', '150929', '四子王旗吉生太镇', '1', '150929102', null, '3', '1'),
('150929103', '150929', '四子王旗库伦图镇', '1', '150929103', null, '3', '1'),
('150929104', '150929', '四子王旗供济堂镇', '1', '150929104', null, '3', '1'),
('150929105', '150929', '四子王旗白音朝克图镇', '1', '150929105', null, '3', '1'),
('150929225', '150929', '四子王旗红格尔苏木乡', '1', '150929225', null, '3', '1'),
('150929226', '150929', '四子王旗江岸苏木乡', '1', '150929226', null, '3', '1'),
('150929227', '150929', '四子王旗查干补力格苏木乡', '1', '150929227', null, '3', '1'),
('150929228', '150929', '四子王旗脑木更苏木乡', '1', '150929228', null, '3', '1'),
('150929229', '150929', '四子王旗东八号乡', '1', '150929229', null, '3', '1'),
('150929230', '150929', '四子王旗忽鸡图乡', '1', '150929230', null, '3', '1'),
('150929400', '150929', '四子王旗乌兰牧场', '1', '150929400', null, '3', '1'),
('150981005', '150981', '新城区街道', '1', '150981005', null, '3', '1'),
('150981006', '150981', '旧城区街道', '1', '150981006', null, '3', '1'),
('150981007', '150981', '北城区街道', '1', '150981007', null, '3', '1'),
('150981008', '150981', '工业区街道', '1', '150981008', null, '3', '1'),
('150981009', '150981', '南城区街道', '1', '150981009', null, '3', '1'),
('150981107', '150981', '隆盛庄镇', '1', '150981107', null, '3', '1'),
('150981108', '150981', '黑土台镇', '1', '150981108', null, '3', '1'),
('150981109', '150981', '红砂坝镇', '1', '150981109', null, '3', '1'),
('150981110', '150981', '巨宝庄镇', '1', '150981110', null, '3', '1'),
('150981111', '150981', '三义泉镇', '1', '150981111', null, '3', '1'),
('150981207', '150981', '浑源窑乡', '1', '150981207', null, '3', '1'),
('150981208', '150981', '官屯堡乡', '1', '150981208', null, '3', '1'),
('152201001', '152201', '爱国街道', '1', '152201001', null, '3', '1'),
('152201002', '152201', '和平街道', '1', '152201002', null, '3', '1'),
('152201003', '152201', '兴安街道', '1', '152201003', null, '3', '1'),
('152201004', '152201', '胜利街道', '1', '152201004', null, '3', '1'),
('152201005', '152201', '铁西街道', '1', '152201005', null, '3', '1'),
('152201006', '152201', '都林街道', '1', '152201006', null, '3', '1'),
('152201007', '152201', '五一街道', '1', '152201007', null, '3', '1'),
('152201008', '152201', '永联街道', '1', '152201008', null, '3', '1'),
('152201100', '152201', '乌兰哈达镇', '1', '152201100', null, '3', '1'),
('152201101', '152201', '居力很镇', '1', '152201101', null, '3', '1'),
('152201400', '152201', '乌兰哈达原种场', '1', '152201400', null, '3', '1'),
('152202001', '152202', '林海街道', '1', '152202001', null, '3', '1'),
('152202002', '152202', '新城街道', '1', '152202002', null, '3', '1'),
('152202003', '152202', '温泉街道', '1', '152202003', null, '3', '1'),
('152202100', '152202', '天池镇', '1', '152202100', null, '3', '1'),
('152202101', '152202', '白狼镇', '1', '152202101', null, '3', '1'),
('152202102', '152202', '五岔沟镇', '1', '152202102', null, '3', '1'),
('152221100', '152221', '科尔沁镇', '1', '152221100', null, '3', '1'),
('152221101', '152221', '索伦镇', '1', '152221101', null, '3', '1'),
('152221102', '152221', '德佰斯镇', '1', '152221102', null, '3', '1'),
('152221103', '152221', '大石寨镇', '1', '152221103', null, '3', '1'),
('152221104', '152221', '归流河镇', '1', '152221104', null, '3', '1'),
('152221105', '152221', '葛根庙镇', '1', '152221105', null, '3', '1'),
('152221106', '152221', '察尔森镇', '1', '152221106', null, '3', '1'),
('152221107', '152221', '额尔格图镇', '1', '152221107', null, '3', '1'),
('152221200', '152221', '满族屯满族乡', '1', '152221200', null, '3', '1'),
('152221201', '152221', '乌兰毛都苏木乡', '1', '152221201', null, '3', '1'),
('152221202', '152221', '阿力得尔苏木乡', '1', '152221202', null, '3', '1'),
('152221400', '152221', '跃进马场', '1', '152221400', null, '3', '1'),
('152221401', '152221', '索伦牧场', '1', '152221401', null, '3', '1'),
('152221402', '152221', '呼和马场', '1', '152221402', null, '3', '1'),
('152221403', '152221', '阿力得尔牧场', '1', '152221403', null, '3', '1'),
('152221404', '152221', '公主陵牧场', '1', '152221404', null, '3', '1'),
('152221405', '152221', '绿水种畜场', '1', '152221405', null, '3', '1'),
('152221500', '152221', '前旗驻乌兰浩特市虚拟区域', '1', '152221500', null, '3', '1'),
('152222100', '152222', '巴彦呼舒镇', '1', '152222100', null, '3', '1'),
('152222101', '152222', '巴仁哲里木镇', '1', '152222101', null, '3', '1'),
('152222102', '152222', '吐列毛都镇', '1', '152222102', null, '3', '1'),
('152222103', '152222', '杜尔基镇', '1', '152222103', null, '3', '1'),
('152222104', '152222', '高力板镇', '1', '152222104', null, '3', '1'),
('152222105', '152222', '好腰苏木镇', '1', '152222105', null, '3', '1'),
('152222200', '152222', '代钦塔拉苏木乡', '1', '152222200', null, '3', '1'),
('152222201', '152222', '新佳木苏木乡', '1', '152222201', null, '3', '1'),
('152222400', '152222', '布敦化牧场', '1', '152222400', null, '3', '1'),
('152222401', '152222', '吐列毛杜农场', '1', '152222401', null, '3', '1'),
('152222402', '152222', '铅矿管理区', '1', '152222402', null, '3', '1'),
('152222403', '152222', '铜矿管理区', '1', '152222403', null, '3', '1'),
('152222404', '152222', '红星林场', '1', '152222404', null, '3', '1'),
('152222405', '152222', '杜尔基林场', '1', '152222405', null, '3', '1'),
('152222406', '152222', '义和塔拉林场', '1', '152222406', null, '3', '1'),
('152222407', '152222', '代钦塔拉林场', '1', '152222407', null, '3', '1'),
('152222408', '152222', '好腰苏木林场', '1', '152222408', null, '3', '1'),
('152222409', '152222', '哈日努拉防火站', '1', '152222409', null, '3', '1'),
('152222410', '152222', '种畜场', '1', '152222410', null, '3', '1'),
('152222411', '152222', '良种繁殖场', '1', '152222411', null, '3', '1'),
('152222412', '152222', '草籽繁殖场', '1', '152222412', null, '3', '1'),
('152223100', '152223', '音德尔镇', '1', '152223100', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('152223101', '152223', '新林镇', '1', '152223101', null, '3', '1'),
('152223102', '152223', '巴彦高勒镇', '1', '152223102', null, '3', '1'),
('152223103', '152223', '胡尔勒镇', '1', '152223103', null, '3', '1'),
('152223104', '152223', '阿尔本格勒镇', '1', '152223104', null, '3', '1'),
('152223105', '152223', '巴达尔胡镇', '1', '152223105', null, '3', '1'),
('152223106', '152223', '图牧吉镇', '1', '152223106', null, '3', '1'),
('152223200', '152223', '好力保乡', '1', '152223200', null, '3', '1'),
('152223201', '152223', '巴彦乌兰苏木乡', '1', '152223201', null, '3', '1'),
('152223400', '152223', '图牧吉劳管所', '1', '152223400', null, '3', '1'),
('152223401', '152223', '内蒙劳改局东部分局', '1', '152223401', null, '3', '1'),
('152223402', '152223', '种畜场', '1', '152223402', null, '3', '1'),
('152223403', '152223', '八一牧场', '1', '152223403', null, '3', '1'),
('152223404', '152223', '巴达尔胡农场', '1', '152223404', null, '3', '1'),
('152224100', '152224', '突泉镇', '1', '152224100', null, '3', '1'),
('152224101', '152224', '六户镇', '1', '152224101', null, '3', '1'),
('152224102', '152224', '东杜尔基镇', '1', '152224102', null, '3', '1'),
('152224103', '152224', '永安镇', '1', '152224103', null, '3', '1'),
('152224104', '152224', '水泉镇', '1', '152224104', null, '3', '1'),
('152224105', '152224', '宝石镇', '1', '152224105', null, '3', '1'),
('152224400', '152224', '东杜尔基国营农场', '1', '152224400', null, '3', '1'),
('152224401', '152224', '东杜尔基良种场', '1', '152224401', null, '3', '1'),
('152224402', '152224', '莲花山铜矿', '1', '152224402', null, '3', '1'),
('152501001', '152501', '乌兰街道', '1', '152501001', null, '3', '1'),
('152501002', '152501', '锡林街道', '1', '152501002', null, '3', '1'),
('152501003', '152501', '东城街道', '1', '152501003', null, '3', '1'),
('152501200', '152501', '格日勒敖都苏木乡', '1', '152501200', null, '3', '1'),
('152501400', '152501', '赛乌苏科技园区', '1', '152501400', null, '3', '1'),
('152502001', '152502', '希日塔拉街道', '1', '152502001', null, '3', '1'),
('152502002', '152502', '宝力根街道', '1', '152502002', null, '3', '1'),
('152502003', '152502', '杭盖街道', '1', '152502003', null, '3', '1'),
('152502004', '152502', '楚古兰街道', '1', '152502004', null, '3', '1'),
('152502005', '152502', '额尔敦街道', '1', '152502005', null, '3', '1'),
('152502006', '152502', '南郊街道', '1', '152502006', null, '3', '1'),
('152502100', '152502', '阿尔善宝拉格镇', '1', '152502100', null, '3', '1'),
('152502200', '152502', '宝力根苏木乡乡', '1', '152502200', null, '3', '1'),
('152502201', '152502', '朝克乌拉苏木乡乡', '1', '152502201', null, '3', '1'),
('152502400', '152502', '巴彦锡勒', '1', '152502400', null, '3', '1'),
('152502401', '152502', '白音库伦牧场', '1', '152502401', null, '3', '1'),
('152502402', '152502', '贝力克牧场', '1', '152502402', null, '3', '1'),
('152502403', '152502', '毛登牧场', '1', '152502403', null, '3', '1'),
('152522100', '152522', '别力古台镇', '1', '152522100', null, '3', '1'),
('152522101', '152522', '洪格尔高勒镇', '1', '152522101', null, '3', '1'),
('152522102', '152522', '查干淖尔镇', '1', '152522102', null, '3', '1'),
('152522200', '152522', '那仁宝拉格苏木乡', '1', '152522200', null, '3', '1'),
('152522201', '152522', '伊和高勒苏木乡乡', '1', '152522201', null, '3', '1'),
('152522202', '152522', '吉尔嘎郎图苏木乡', '1', '152522202', null, '3', '1'),
('152522400', '152522', '玛尼图煤矿', '1', '152522400', null, '3', '1'),
('152523100', '152523', '满都拉图镇', '1', '152523100', null, '3', '1'),
('152523101', '152523', '查干敖包中心镇', '1', '152523101', null, '3', '1'),
('152523102', '152523', '巴彦淖尔镇', '1', '152523102', null, '3', '1'),
('152523200', '152523', '巴彦乌拉苏木乡', '1', '152523200', null, '3', '1'),
('152523201', '152523', '赛罕高毕苏木乡', '1', '152523201', null, '3', '1'),
('152523400', '152523', '恩格尔河灌区', '1', '152523400', null, '3', '1'),
('152524100', '152524', '赛汉塔拉镇', '1', '152524100', null, '3', '1'),
('152524101', '152524', '朱日和镇', '1', '152524101', null, '3', '1'),
('152524102', '152524', '乌日根塔拉镇', '1', '152524102', null, '3', '1'),
('152524200', '152524', '桑宝力格苏木乡', '1', '152524200', null, '3', '1'),
('152524201', '152524', '额仁淖尔苏木乡', '1', '152524201', null, '3', '1'),
('152524202', '152524', '赛罕乌力吉苏木乡', '1', '152524202', null, '3', '1'),
('152525100', '152525', '乌里雅斯太镇', '1', '152525100', null, '3', '1'),
('152525101', '152525', '道特淖尔镇', '1', '152525101', null, '3', '1'),
('152525102', '152525', '嘎达布其镇', '1', '152525102', null, '3', '1'),
('152525103', '152525', '满都胡宝拉格镇', '1', '152525103', null, '3', '1'),
('152525104', '152525', '额吉淖尔镇', '1', '152525104', null, '3', '1'),
('152525105', '152525', '巴音胡硕镇', '1', '152525105', null, '3', '1'),
('152525200', '152525', '呼热图淖尔苏木乡', '1', '152525200', null, '3', '1'),
('152525201', '152525', '萨麦苏木乡', '1', '152525201', null, '3', '1'),
('152525400', '152525', '哈拉盖图农牧场', '1', '152525400', null, '3', '1'),
('152525401', '152525', '贺斯格乌拉农牧场', '1', '152525401', null, '3', '1'),
('152525402', '152525', '乌拉盖牧场', '1', '152525402', null, '3', '1'),
('152525403', '152525', '水库农牧业经营公司场', '1', '152525403', null, '3', '1'),
('152526100', '152526', '巴拉嘎尔高勒镇', '1', '152526100', null, '3', '1'),
('152526101', '152526', '巴彦花镇', '1', '152526101', null, '3', '1'),
('152526102', '152526', '吉仁高勒镇', '1', '152526102', null, '3', '1'),
('152526103', '152526', '浩勒图高勒镇', '1', '152526103', null, '3', '1'),
('152526104', '152526', '高日罕镇', '1', '152526104', null, '3', '1'),
('152526200', '152526', '巴彦胡舒苏木乡', '1', '152526200', null, '3', '1'),
('152526400', '152526', '林业总场', '1', '152526400', null, '3', '1'),
('152527100', '152527', '宝昌镇', '1', '152527100', null, '3', '1'),
('152527101', '152527', '千斤沟镇', '1', '152527101', null, '3', '1'),
('152527102', '152527', '红旗镇', '1', '152527102', null, '3', '1'),
('152527103', '152527', '骆驼山镇', '1', '152527103', null, '3', '1'),
('152527200', '152527', '幸福乡', '1', '152527200', null, '3', '1'),
('152527201', '152527', '贡宝拉格苏木乡', '1', '152527201', null, '3', '1'),
('152527400', '152527', '万寿滩良种场', '1', '152527400', null, '3', '1'),
('152528100', '152528', '新宝拉格镇', '1', '152528100', null, '3', '1'),
('152528101', '152528', '巴彦塔拉镇', '1', '152528101', null, '3', '1'),
('152528200', '152528', '翁贡乌拉苏木乡', '1', '152528200', null, '3', '1'),
('152529100', '152529', '明安图镇', '1', '152529100', null, '3', '1'),
('152529101', '152529', '星耀镇', '1', '152529101', null, '3', '1'),
('152529200', '152529', '伊和淖尔苏木乡', '1', '152529200', null, '3', '1'),
('152529201', '152529', '乌兰查布苏木乡', '1', '152529201', null, '3', '1'),
('152529400', '152529', '额里图种畜场', '1', '152529400', null, '3', '1'),
('152529401', '152529', '哲日根图林场', '1', '152529401', null, '3', '1'),
('152530100', '152530', '上都镇', '1', '152530100', null, '3', '1'),
('152530101', '152530', '桑根达来镇', '1', '152530101', null, '3', '1'),
('152530102', '152530', '哈毕日嘎镇', '1', '152530102', null, '3', '1'),
('152530200', '152530', '宝绍岱苏木乡', '1', '152530200', null, '3', '1'),
('152530201', '152530', '那日图苏木乡', '1', '152530201', null, '3', '1'),
('152530202', '152530', '赛音胡都嘎苏木乡', '1', '152530202', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('152530400', '152530', '五一种畜场总场', '1', '152530400', null, '3', '1'),
('152530401', '152530', '黑城子示范区', '1', '152530401', null, '3', '1'),
('152531100', '152531', '大北沟镇', '1', '152531100', null, '3', '1'),
('152531101', '152531', '多伦淖尔镇', '1', '152531101', null, '3', '1'),
('152531200', '152531', '大河口乡', '1', '152531200', null, '3', '1'),
('152531201', '152531', '蔡木山乡', '1', '152531201', null, '3', '1'),
('152921102', '152921', '温都尔勒图镇', '1', '152921102', null, '3', '1'),
('152921104', '152921', '乌斯太镇', '1', '152921104', null, '3', '1'),
('152921105', '152921', '巴润别立镇', '1', '152921105', null, '3', '1'),
('152921110', '152921', '巴彦浩特镇', '1', '152921110', null, '3', '1'),
('152921111', '152921', '嘉尔嘎勒赛汉镇', '1', '152921111', null, '3', '1'),
('152921112', '152921', '吉兰泰镇', '1', '152921112', null, '3', '1'),
('152921113', '152921', '宗别立镇', '1', '152921113', null, '3', '1'),
('152921114', '152921', '敖伦布拉格镇', '1', '152921114', null, '3', '1'),
('152921203', '152921', '巴彦木仁苏木乡', '1', '152921203', null, '3', '1'),
('152921211', '152921', '腾格里苏木乡', '1', '152921211', null, '3', '1'),
('152921213', '152921', '乌力吉苏木乡', '1', '152921213', null, '3', '1'),
('152921214', '152921', '巴彦诺尔公苏木乡', '1', '152921214', null, '3', '1'),
('152921215', '152921', '额尔克哈什哈苏木乡', '1', '152921215', null, '3', '1'),
('152922103', '152922', '额肯呼都格镇', '1', '152922103', null, '3', '1'),
('152922104', '152922', '雅布赖镇', '1', '152922104', null, '3', '1'),
('152922105', '152922', '阿拉腾敖包镇', '1', '152922105', null, '3', '1'),
('152922211', '152922', '孟根布拉格苏木乡', '1', '152922211', null, '3', '1'),
('152922212', '152922', '阿拉腾朝克苏木乡', '1', '152922212', null, '3', '1'),
('152923100', '152923', '达来呼布镇', '1', '152923100', null, '3', '1'),
('152923101', '152923', '额济纳旗东风镇', '1', '152923101', null, '3', '1'),
('152923200', '152923', '额济纳旗赛汉陶来苏木乡', '1', '152923200', null, '3', '1'),
('152923201', '152923', '额济纳旗马鬃山苏木乡', '1', '152923201', null, '3', '1'),
('152923202', '152923', '额济纳旗苏泊淖尔苏木乡', '1', '152923202', null, '3', '1'),
('152923400', '152923', '额济纳旗巴彦陶来农场', '1', '152923400', null, '3', '1'),
('210102001', '210102', '砂山街道', '1', '210102001', null, '3', '1'),
('210102002', '210102', '新华街道', '1', '210102002', null, '3', '1'),
('210102006', '210102', '吴淞街道', '1', '210102006', null, '3', '1'),
('210102007', '210102', '西塔街道', '1', '210102007', null, '3', '1'),
('210102009', '210102', '北道口街道', '1', '210102009', null, '3', '1'),
('210102011', '210102', '遂川街道', '1', '210102011', null, '3', '1'),
('210102013', '210102', '八经街道', '1', '210102013', null, '3', '1'),
('210102016', '210102', '马路湾街道', '1', '210102016', null, '3', '1'),
('210102017', '210102', '集贤街道', '1', '210102017', null, '3', '1'),
('210102018', '210102', '新兴街道', '1', '210102018', null, '3', '1'),
('210102019', '210102', '南湖街道', '1', '210102019', null, '3', '1'),
('210102021', '210102', '长白街道', '1', '210102021', null, '3', '1'),
('210102022', '210102', '太原街街道', '1', '210102022', null, '3', '1'),
('210102023', '210102', '北市场街道', '1', '210102023', null, '3', '1'),
('210102025', '210102', '南市场街道', '1', '210102025', null, '3', '1'),
('210102026', '210102', '中山街道', '1', '210102026', null, '3', '1'),
('210102027', '210102', '沈水湾街道', '1', '210102027', null, '3', '1'),
('210103004', '210103', '大西街道', '1', '210103004', null, '3', '1'),
('210103005', '210103', '滨河街道', '1', '210103005', null, '3', '1'),
('210103006', '210103', '万莲街道', '1', '210103006', null, '3', '1'),
('210103010', '210103', '大南街道', '1', '210103010', null, '3', '1'),
('210103011', '210103', '山东庙街道', '1', '210103011', null, '3', '1'),
('210103013', '210103', '朱剪炉街道', '1', '210103013', null, '3', '1'),
('210103014', '210103', '新北站街道', '1', '210103014', null, '3', '1'),
('210103015', '210103', '风雨坛街道', '1', '210103015', null, '3', '1'),
('210103017', '210103', '皇城街道', '1', '210103017', null, '3', '1'),
('210103018', '210103', '五里河街道', '1', '210103018', null, '3', '1'),
('210104001', '210104', '小北街道', '1', '210104001', null, '3', '1'),
('210104002', '210104', '大北街道', '1', '210104002', null, '3', '1'),
('210104003', '210104', '万泉街道', '1', '210104003', null, '3', '1'),
('210104004', '210104', '洮昌街道', '1', '210104004', null, '3', '1'),
('210104006', '210104', '文官街道', '1', '210104006', null, '3', '1'),
('210104007', '210104', '二台子街道', '1', '210104007', null, '3', '1'),
('210104008', '210104', '津桥街道', '1', '210104008', null, '3', '1'),
('210104009', '210104', '东站街道', '1', '210104009', null, '3', '1'),
('210104010', '210104', '辽沈街道', '1', '210104010', null, '3', '1'),
('210104011', '210104', '珠林街道', '1', '210104011', null, '3', '1'),
('210104012', '210104', '长安街道', '1', '210104012', null, '3', '1'),
('210104014', '210104', '新东街道', '1', '210104014', null, '3', '1'),
('210104015', '210104', '东塔街道', '1', '210104015', null, '3', '1'),
('210105001', '210105', '三台子街道', '1', '210105001', null, '3', '1'),
('210105002', '210105', '陵北街道', '1', '210105002', null, '3', '1'),
('210105003', '210105', '辽河街道', '1', '210105003', null, '3', '1'),
('210105004', '210105', '黑龙江街道', '1', '210105004', null, '3', '1'),
('210105005', '210105', '泰山街道', '1', '210105005', null, '3', '1'),
('210105006', '210105', '祟山街道', '1', '210105006', null, '3', '1'),
('210105007', '210105', '长江街道', '1', '210105007', null, '3', '1'),
('210105008', '210105', '黄河街道', '1', '210105008', null, '3', '1'),
('210105009', '210105', '昆山街道', '1', '210105009', null, '3', '1'),
('210105010', '210105', '亚明街道', '1', '210105010', null, '3', '1'),
('210105011', '210105', '克俭街道', '1', '210105011', null, '3', '1'),
('210105012', '210105', '三洞桥街道', '1', '210105012', null, '3', '1'),
('210105013', '210105', '华山街道', '1', '210105013', null, '3', '1'),
('210105014', '210105', '寿泉街道', '1', '210105014', null, '3', '1'),
('210105015', '210105', '塔湾街道', '1', '210105015', null, '3', '1'),
('210105016', '210105', '怒江街道', '1', '210105016', null, '3', '1'),
('210105017', '210105', '明廉街道', '1', '210105017', null, '3', '1'),
('210105018', '210105', '向工街道', '1', '210105018', null, '3', '1'),
('210105019', '210105', '新乐街道', '1', '210105019', null, '3', '1'),
('210105020', '210105', '太平街道', '1', '210105020', null, '3', '1'),
('210106001', '210106', '卫工街道', '1', '210106001', null, '3', '1'),
('210106003', '210106', '工人村街道', '1', '210106003', null, '3', '1'),
('210106005', '210106', '七路街道', '1', '210106005', null, '3', '1'),
('210106007', '210106', '启工街道', '1', '210106007', null, '3', '1'),
('210106013', '210106', '笃工街道', '1', '210106013', null, '3', '1'),
('210106015', '210106', '兴华街道', '1', '210106015', null, '3', '1'),
('210106018', '210106', '兴工街道', '1', '210106018', null, '3', '1'),
('210106019', '210106', '霁虹街道', '1', '210106019', null, '3', '1'),
('210106020', '210106', '凌空街道', '1', '210106020', null, '3', '1'),
('210106021', '210106', '轻重工街道', '1', '210106021', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('210106022', '210106', '艳粉路官街道', '1', '210106022', null, '3', '1'),
('210106023', '210106', '兴齐保工街道', '1', '210106023', null, '3', '1'),
('210106024', '210106', '齐贤兴顺街道', '1', '210106024', null, '3', '1'),
('210106025', '210106', '云峰贵和街道', '1', '210106025', null, '3', '1'),
('210111001', '210111', '解放街道', '1', '210111001', null, '3', '1'),
('210111002', '210111', '铁友街道', '1', '210111002', null, '3', '1'),
('210111003', '210111', '民主街道', '1', '210111003', null, '3', '1'),
('210111004', '210111', '临湖街道', '1', '210111004', null, '3', '1'),
('210111005', '210111', '中兴街道', '1', '210111005', null, '3', '1'),
('210111006', '210111', '湖西街道', '1', '210111006', null, '3', '1'),
('210111007', '210111', '城郊街道', '1', '210111007', null, '3', '1'),
('210111101', '210111', '八一镇', '1', '210111101', null, '3', '1'),
('210111102', '210111', '红菱堡镇', '1', '210111102', null, '3', '1'),
('210111103', '210111', '林盛堡镇', '1', '210111103', null, '3', '1'),
('210111104', '210111', '沙河铺镇', '1', '210111104', null, '3', '1'),
('210111105', '210111', '十里河镇', '1', '210111105', null, '3', '1'),
('210111106', '210111', '陈相屯镇', '1', '210111106', null, '3', '1'),
('210111107', '210111', '姚千户屯镇', '1', '210111107', null, '3', '1'),
('210111203', '210111', '王纲堡乡', '1', '210111203', null, '3', '1'),
('210111204', '210111', '永乐乡', '1', '210111204', null, '3', '1'),
('210111205', '210111', '大沟乡', '1', '210111205', null, '3', '1'),
('210111206', '210111', '白清寨乡', '1', '210111206', null, '3', '1'),
('210111207', '210111', '佟沟乡', '1', '210111207', null, '3', '1'),
('210111401', '210111', '市浑河农场', '1', '210111401', null, '3', '1'),
('210111402', '210111', '沈阳塔山农业科技发展有限公司', '1', '210111402', null, '3', '1'),
('210111404', '210111', '区示范农场', '1', '210111404', null, '3', '1'),
('210111405', '210111', '省稻作研究所', '1', '210111405', null, '3', '1'),
('210111406', '210111', '区塔山林场', '1', '210111406', null, '3', '1'),
('210112001', '210112', '南塔街道', '1', '210112001', null, '3', '1'),
('210112002', '210112', '泉园街道', '1', '210112002', null, '3', '1'),
('210112003', '210112', '丰乐街道', '1', '210112003', null, '3', '1'),
('210112004', '210112', '马官桥街道', '1', '210112004', null, '3', '1'),
('210112006', '210112', '东陵街道', '1', '210112006', null, '3', '1'),
('210112007', '210112', '英达街道', '1', '210112007', null, '3', '1'),
('210112008', '210112', '前进街道', '1', '210112008', null, '3', '1'),
('210112009', '210112', '东湖街道（浑南新区）', '1', '210112009', null, '3', '1'),
('210112010', '210112', '五三街道（浑南新区）', '1', '210112010', null, '3', '1'),
('210112012', '210112', '浑河站东街道', '1', '210112012', null, '3', '1'),
('210112013', '210112', '浑河站西街道', '1', '210112013', null, '3', '1'),
('210112014', '210112', '高坎街道（棋盘山开发区）', '1', '210112014', null, '3', '1'),
('210112015', '210112', '满堂街道（棋盘山）', '1', '210112015', null, '3', '1'),
('210112102', '210112', '深井子镇', '1', '210112102', null, '3', '1'),
('210112103', '210112', '祝家屯镇', '1', '210112103', null, '3', '1'),
('210112104', '210112', '白塔堡镇', '1', '210112104', null, '3', '1'),
('210112106', '210112', '桃仙镇', '1', '210112106', null, '3', '1'),
('210112109', '210112', '李相镇', '1', '210112109', null, '3', '1'),
('210112206', '210112', '王滨沟乡', '1', '210112206', null, '3', '1'),
('210113001', '210113', '新城子街道', '1', '210113001', null, '3', '1'),
('210113002', '210113', '清水台街道', '1', '210113002', null, '3', '1'),
('210113003', '210113', '辉山街道（农业高新区）', '1', '210113003', null, '3', '1'),
('210113101', '210113', '道义镇', '1', '210113101', null, '3', '1'),
('210113102', '210113', '兴隆台锡伯族镇', '1', '210113102', null, '3', '1'),
('210113103', '210113', '清水台镇', '1', '210113103', null, '3', '1'),
('210113104', '210113', '蒲河镇', '1', '210113104', null, '3', '1'),
('210113105', '210113', '虎石台镇', '1', '210113105', null, '3', '1'),
('210113106', '210113', '财落镇', '1', '210113106', null, '3', '1'),
('210113201', '210113', '新城子乡', '1', '210113201', null, '3', '1'),
('210113202', '210113', '黄家锡伯族乡', '1', '210113202', null, '3', '1'),
('210113203', '210113', '石佛寺朝鲜族锡伯族乡', '1', '210113203', null, '3', '1'),
('210113204', '210113', '尹家乡', '1', '210113204', null, '3', '1'),
('210113206', '210113', '马刚乡', '1', '210113206', null, '3', '1'),
('210113401', '210113', '青年农场', '1', '210113401', null, '3', '1'),
('210113402', '210113', '前进农场', '1', '210113402', null, '3', '1'),
('210113403', '210113', '育新农场', '1', '210113403', null, '3', '1'),
('210113404', '210113', '新城子区马刚林场', '1', '210113404', null, '3', '1'),
('210113405', '210113', '新城子区示范农场', '1', '210113405', null, '3', '1'),
('210113406', '210113', '新城子区种畜场', '1', '210113406', null, '3', '1'),
('210114001', '210114', '迎宾路街道', '1', '210114001', null, '3', '1'),
('210114002', '210114', '北塔街道', '1', '210114002', null, '3', '1'),
('210114003', '210114', '陵西街道', '1', '210114003', null, '3', '1'),
('210114005', '210114', '于洪街道', '1', '210114005', null, '3', '1'),
('210114006', '210114', '杨士街道', '1', '210114006', null, '3', '1'),
('210114007', '210114', '北陵街道', '1', '210114007', null, '3', '1'),
('210114008', '210114', '陵东街道', '1', '210114008', null, '3', '1'),
('210114009', '210114', '沙岭街道', '1', '210114009', null, '3', '1'),
('210114101', '210114', '平罗镇', '1', '210114101', null, '3', '1'),
('210114102', '210114', '马三家子镇', '1', '210114102', null, '3', '1'),
('210114104', '210114', '大潘镇', '1', '210114104', null, '3', '1'),
('210114105', '210114', '造化镇', '1', '210114105', null, '3', '1'),
('210114106', '210114', '翟家镇', '1', '210114106', null, '3', '1'),
('210114107', '210114', '彰驿站镇', '1', '210114107', null, '3', '1'),
('210114108', '210114', '高花镇', '1', '210114108', null, '3', '1'),
('210114207', '210114', '大兴朝鲜族乡', '1', '210114207', null, '3', '1'),
('210114209', '210114', '大青中朝友谊乡', '1', '210114209', null, '3', '1'),
('210114213', '210114', '光辉乡', '1', '210114213', null, '3', '1'),
('210114401', '210114', '马三家劳动教养院', '1', '210114401', null, '3', '1'),
('210114402', '210114', '光辉农场', '1', '210114402', null, '3', '1'),
('210114403', '210114', '北陵农场', '1', '210114403', null, '3', '1'),
('210114404', '210114', '监狱城', '1', '210114404', null, '3', '1'),
('210122100', '210122', '辽中镇', '1', '210122100', null, '3', '1'),
('210122101', '210122', '于家房镇', '1', '210122101', null, '3', '1'),
('210122102', '210122', '朱家房镇', '1', '210122102', null, '3', '1'),
('210122103', '210122', '冷子堡镇', '1', '210122103', null, '3', '1'),
('210122104', '210122', '刘二堡镇', '1', '210122104', null, '3', '1'),
('210122105', '210122', '茨榆坨镇', '1', '210122105', null, '3', '1'),
('210122106', '210122', '新民屯镇', '1', '210122106', null, '3', '1'),
('210122107', '210122', '满都户镇', '1', '210122107', null, '3', '1'),
('210122108', '210122', '杨士岗镇', '1', '210122108', null, '3', '1'),
('210122109', '210122', '肖寨门镇', '1', '210122109', null, '3', '1'),
('210122110', '210122', '长滩镇', '1', '210122110', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('210122111', '210122', '四方台镇', '1', '210122111', null, '3', '1'),
('210122201', '210122', '城郊乡', '1', '210122201', null, '3', '1'),
('210122202', '210122', '六间房乡', '1', '210122202', null, '3', '1'),
('210122204', '210122', '养士堡乡', '1', '210122204', null, '3', '1'),
('210122205', '210122', '潘家堡乡', '1', '210122205', null, '3', '1'),
('210122206', '210122', '老观坨乡', '1', '210122206', null, '3', '1'),
('210122208', '210122', '老大房乡', '1', '210122208', null, '3', '1'),
('210122209', '210122', '大黑岗子乡', '1', '210122209', null, '3', '1'),
('210122210', '210122', '牛心坨乡', '1', '210122210', null, '3', '1'),
('210122401', '210122', '四方台子农场', '1', '210122401', null, '3', '1'),
('210123100', '210123', '康平镇', '1', '210123100', null, '3', '1'),
('210123101', '210123', '小城子镇', '1', '210123101', null, '3', '1'),
('210123102', '210123', '张强镇', '1', '210123102', null, '3', '1'),
('210123103', '210123', '方家屯镇', '1', '210123103', null, '3', '1'),
('210123104', '210123', '东关屯镇', '1', '210123104', null, '3', '1'),
('210123105', '210123', '郝官屯镇', '1', '210123105', null, '3', '1'),
('210123106', '210123', '二牛所口镇', '1', '210123106', null, '3', '1'),
('210123203', '210123', '北四家子乡', '1', '210123203', null, '3', '1'),
('210123204', '210123', '两家子乡', '1', '210123204', null, '3', '1'),
('210123205', '210123', '山东屯乡', '1', '210123205', null, '3', '1'),
('210123206', '210123', '海洲窝堡乡', '1', '210123206', null, '3', '1'),
('210123208', '210123', '沙金台蒙古族满族乡', '1', '210123208', null, '3', '1'),
('210123209', '210123', '柳树屯蒙古族满族乡', '1', '210123209', null, '3', '1'),
('210123210', '210123', '西关屯蒙古族满族乡', '1', '210123210', null, '3', '1'),
('210123211', '210123', '东升满族蒙古族乡', '1', '210123211', null, '3', '1'),
('210123403', '210123', '辽宁省康平监狱', '1', '210123403', null, '3', '1'),
('210123404', '210123', '三台子畜牧场', '1', '210123404', null, '3', '1'),
('210124100', '210124', '法库镇', '1', '210124100', null, '3', '1'),
('210124101', '210124', '大孤家子镇', '1', '210124101', null, '3', '1'),
('210124102', '210124', '三面船镇', '1', '210124102', null, '3', '1'),
('210124103', '210124', '秀水河子镇', '1', '210124103', null, '3', '1'),
('210124104', '210124', '叶茂台镇', '1', '210124104', null, '3', '1'),
('210124105', '210124', '登仕堡子镇', '1', '210124105', null, '3', '1'),
('210124106', '210124', '柏家沟镇', '1', '210124106', null, '3', '1'),
('210124107', '210124', '丁家房镇', '1', '210124107', null, '3', '1'),
('210124201', '210124', '慈恩寺乡', '1', '210124201', null, '3', '1'),
('210124202', '210124', '孟家乡', '1', '210124202', null, '3', '1'),
('210124203', '210124', '和平乡', '1', '210124203', null, '3', '1'),
('210124204', '210124', '十间房乡', '1', '210124204', null, '3', '1'),
('210124205', '210124', '冯贝堡乡', '1', '210124205', null, '3', '1'),
('210124206', '210124', '依牛堡子乡', '1', '210124206', null, '3', '1'),
('210124207', '210124', '五台子乡', '1', '210124207', null, '3', '1'),
('210124208', '210124', '四家子蒙古族乡', '1', '210124208', null, '3', '1'),
('210124209', '210124', '双台子乡', '1', '210124209', null, '3', '1'),
('210124210', '210124', '卧牛石乡', '1', '210124210', null, '3', '1'),
('210124211', '210124', '包家屯乡', '1', '210124211', null, '3', '1'),
('210181001', '210181', '东城街道', '1', '210181001', null, '3', '1'),
('210181002', '210181', '辽滨街道', '1', '210181002', null, '3', '1'),
('210181003', '210181', '西城街道', '1', '210181003', null, '3', '1'),
('210181004', '210181', '新柳街道', '1', '210181004', null, '3', '1'),
('210181005', '210181', '新城街道', '1', '210181005', null, '3', '1'),
('210181101', '210181', '大红旗镇', '1', '210181101', null, '3', '1'),
('210181102', '210181', '梁山镇', '1', '210181102', null, '3', '1'),
('210181103', '210181', '公主屯镇', '1', '210181103', null, '3', '1'),
('210181104', '210181', '兴隆镇', '1', '210181104', null, '3', '1'),
('210181105', '210181', '前当堡镇', '1', '210181105', null, '3', '1'),
('210181106', '210181', '大民屯镇', '1', '210181106', null, '3', '1'),
('210181107', '210181', '大柳屯镇', '1', '210181107', null, '3', '1'),
('210181108', '210181', '兴隆堡镇', '1', '210181108', null, '3', '1'),
('210181109', '210181', '胡台镇', '1', '210181109', null, '3', '1'),
('210181110', '210181', '法哈牛镇', '1', '210181110', null, '3', '1'),
('210181111', '210181', '柳河沟镇', '1', '210181111', null, '3', '1'),
('210181202', '210181', '高台子乡', '1', '210181202', null, '3', '1'),
('210181204', '210181', '金五台子乡', '1', '210181204', null, '3', '1'),
('210181205', '210181', '红旗乡', '1', '210181205', null, '3', '1'),
('210181206', '210181', '卢家屯乡', '1', '210181206', null, '3', '1'),
('210181207', '210181', '姚堡乡', '1', '210181207', null, '3', '1'),
('210181208', '210181', '周坨子乡', '1', '210181208', null, '3', '1'),
('210181209', '210181', '于家窝堡乡', '1', '210181209', null, '3', '1'),
('210181210', '210181', '新农乡', '1', '210181210', null, '3', '1'),
('210181211', '210181', '东蛇山子乡', '1', '210181211', null, '3', '1'),
('210181212', '210181', '陶家屯乡', '1', '210181212', null, '3', '1'),
('210181213', '210181', '罗家房乡', '1', '210181213', null, '3', '1'),
('210181214', '210181', '三道岗子乡', '1', '210181214', null, '3', '1'),
('210181216', '210181', '张家屯乡', '1', '210181216', null, '3', '1'),
('210202001', '210202', '海军广场街道', '1', '210202001', null, '3', '1'),
('210202003', '210202', '桂林街道', '1', '210202003', null, '3', '1'),
('210202005', '210202', '人民路街道', '1', '210202005', null, '3', '1'),
('210202008', '210202', '青泥洼桥街道', '1', '210202008', null, '3', '1'),
('210202009', '210202', '昆明街道', '1', '210202009', null, '3', '1'),
('210202010', '210202', '葵英街道', '1', '210202010', null, '3', '1'),
('210202011', '210202', '桃源街道', '1', '210202011', null, '3', '1'),
('210202012', '210202', '老虎滩街道', '1', '210202012', null, '3', '1'),
('210203001', '210203', '香炉礁街道', '1', '210203001', null, '3', '1'),
('210203002', '210203', '站北街道', '1', '210203002', null, '3', '1'),
('210203004', '210203', '日新街道', '1', '210203004', null, '3', '1'),
('210203005', '210203', '北京街道', '1', '210203005', null, '3', '1'),
('210203010', '210203', '八一路街道', '1', '210203010', null, '3', '1'),
('210203011', '210203', '人民广场街道', '1', '210203011', null, '3', '1'),
('210203013', '210203', '白云街道', '1', '210203013', null, '3', '1'),
('210204002', '210204', '中山公园街道', '1', '210204002', null, '3', '1'),
('210204004', '210204', '白山路街道', '1', '210204004', null, '3', '1'),
('210204005', '210204', '兴工街道', '1', '210204005', null, '3', '1'),
('210204006', '210204', '春柳街道', '1', '210204006', null, '3', '1'),
('210204008', '210204', '马栏街道', '1', '210204008', null, '3', '1'),
('210204009', '210204', '南沙河口街道', '1', '210204009', null, '3', '1'),
('210204010', '210204', '黑石礁街道', '1', '210204010', null, '3', '1'),
('210204011', '210204', '李家街道', '1', '210204011', null, '3', '1'),
('210204017', '210204', '星海湾街道', '1', '210204017', null, '3', '1'),
('210211001', '210211', '周水子街道', '1', '210211001', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('210211002', '210211', '椒金山街道', '1', '210211002', null, '3', '1'),
('210211004', '210211', '甘井子街道', '1', '210211004', null, '3', '1'),
('210211006', '210211', '南关岭街道', '1', '210211006', null, '3', '1'),
('210211007', '210211', '泡崖街道', '1', '210211007', null, '3', '1'),
('210211008', '210211', '中华路街道', '1', '210211008', null, '3', '1'),
('210211009', '210211', '兴华街道', '1', '210211009', null, '3', '1'),
('210211010', '210211', '机场街道', '1', '210211010', null, '3', '1'),
('210211014', '210211', '辛寨子街道', '1', '210211014', null, '3', '1'),
('210211015', '210211', '红旗街道', '1', '210211015', null, '3', '1'),
('210211016', '210211', '凌水街道', '1', '210211016', null, '3', '1'),
('210211017', '210211', '大连湾街道', '1', '210211017', null, '3', '1'),
('210211018', '210211', '泉水街道', '1', '210211018', null, '3', '1'),
('210211101', '210211', '革镇堡镇', '1', '210211101', null, '3', '1'),
('210211102', '210211', '营城子镇', '1', '210211102', null, '3', '1'),
('210211400', '210211', '大连华侨果树农场', '1', '210211400', null, '3', '1'),
('210211401', '210211', '大连华侨兴达实业公司', '1', '210211401', null, '3', '1'),
('210211402', '210211', '大连华侨鑫山企业公司', '1', '210211402', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('210211403', '210211', '大连南关岭农场', '1', '210211403', null, '3', '1'),
('210212001', '210212', '登峰街道', '1', '210212001', null, '3', '1'),
('210212002', '210212', '市场街道', '1', '210212002', null, '3', '1'),
('210212003', '210212', '得胜街道', '1', '210212003', null, '3', '1'),
('210212004', '210212', '光荣街道', '1', '210212004', null, '3', '1'),
('210212005', '210212', '水师营街道', '1', '210212005', null, '3', '1'),
('210212006', '210212', '龙王塘街道', '1', '210212006', null, '3', '1'),
('210212007', '210212', '铁山街道', '1', '210212007', null, '3', '1'),
('210212008', '210212', '江西街道', '1', '210212008', null, '3', '1'),
('210212009', '210212', '双岛湾街道', '1', '210212009', null, '3', '1'),
('210212010', '210212', '三涧堡街道', '1', '210212010', null, '3', '1'),
('210212011', '210212', '长城街道', '1', '210212011', null, '3', '1'),
('210212012', '210212', '龙头街道', '1', '210212012', null, '3', '1'),
('210212013', '210212', '北海街道', '1', '210212013', null, '3', '1'),
('210212400', '210212', '旅顺开发区', '1', '210212400', null, '3', '1'),
('210212401', '210212', '大连奶牛场', '1', '210212401', null, '3', '1'),
('210213001', '210213', '拥政街道', '1', '210213001', null, '3', '1'),
('210213002', '210213', '友谊街道', '1', '210213002', null, '3', '1'),
('210213003', '210213', '光明街道', '1', '210213003', null, '3', '1'),
('210213004', '210213', '马桥子街道', '1', '210213004', null, '3', '1'),
('210213005', '210213', '海青岛街道', '1', '210213005', null, '3', '1'),
('210213006', '210213', '大孤山街道', '1', '210213006', null, '3', '1'),
('210213007', '210213', '中长街道', '1', '210213007', null, '3', '1'),
('210213008', '210213', '站前街道', '1', '210213008', null, '3', '1'),
('210213009', '210213', '先进街道', '1', '210213009', null, '3', '1'),
('210213011', '210213', '董家沟街道', '1', '210213011', null, '3', '1'),
('210213012', '210213', '金满街道', '1', '210213012', null, '3', '1'),
('210213013', '210213', '湾里街道', '1', '210213013', null, '3', '1'),
('210213101', '210213', '大李家镇', '1', '210213101', null, '3', '1'),
('210213102', '210213', '得胜镇', '1', '210213102', null, '3', '1'),
('210213103', '210213', '华家屯镇', '1', '210213103', null, '3', '1'),
('210213105', '210213', '二十里堡镇', '1', '210213105', null, '3', '1'),
('210213106', '210213', '三十里堡镇', '1', '210213106', null, '3', '1'),
('210213107', '210213', '亮甲店镇', '1', '210213107', null, '3', '1'),
('210213108', '210213', '登沙河镇', '1', '210213108', null, '3', '1'),
('210213109', '210213', '杏树屯镇', '1', '210213109', null, '3', '1'),
('210213110', '210213', '石河满族镇', '1', '210213110', null, '3', '1'),
('210213111', '210213', '大魏家镇', '1', '210213111', null, '3', '1'),
('210213112', '210213', '向应镇', '1', '210213112', null, '3', '1'),
('210213202', '210213', '七顶山满族乡', '1', '210213202', null, '3', '1'),
('210224100', '210224', '大长山岛镇', '1', '210224100', null, '3', '1'),
('210224101', '210224', '獐子岛镇', '1', '210224101', null, '3', '1'),
('210224201', '210224', '小长山乡', '1', '210224201', null, '3', '1'),
('210224202', '210224', '广鹿乡', '1', '210224202', null, '3', '1'),
('210224203', '210224', '海洋乡', '1', '210224203', null, '3', '1'),
('210281001', '210281', '新华', '1', '210281001', null, '3', '1'),
('210281002', '210281', '文兰', '1', '210281002', null, '3', '1'),
('210281003', '210281', '岭东', '1', '210281003', null, '3', '1'),
('210281004', '210281', '共济', '1', '210281004', null, '3', '1'),
('210281005', '210281', '铁东', '1', '210281005', null, '3', '1'),
('210281006', '210281', '祝华', '1', '210281006', null, '3', '1'),
('210281007', '210281', '岗店', '1', '210281007', null, '3', '1'),
('210281008', '210281', '太阳街道', '1', '210281008', null, '3', '1'),
('210281009', '210281', '长兴岛', '1', '210281009', null, '3', '1'),
('210281101', '210281', '复州城镇', '1', '210281101', null, '3', '1'),
('210281102', '210281', '复州湾镇', '1', '210281102', null, '3', '1'),
('210281103', '210281', '松树镇', '1', '210281103', null, '3', '1'),
('210281105', '210281', '得利寺镇', '1', '210281105', null, '3', '1'),
('210281106', '210281', '万家岭镇', '1', '210281106', null, '3', '1'),
('210281107', '210281', '许屯镇', '1', '210281107', null, '3', '1'),
('210281108', '210281', '永宁镇', '1', '210281108', null, '3', '1'),
('210281109', '210281', '谢屯镇', '1', '210281109', null, '3', '1'),
('210281110', '210281', '炮台镇', '1', '210281110', null, '3', '1'),
('210281111', '210281', '李店镇', '1', '210281111', null, '3', '1'),
('210281112', '210281', '老虎屯镇', '1', '210281112', null, '3', '1'),
('210281113', '210281', '东岗镇', '1', '210281113', null, '3', '1'),
('210281115', '210281', '李官镇', '1', '210281115', null, '3', '1'),
('210281116', '210281', '仙浴湾镇', '1', '210281116', null, '3', '1'),
('210281201', '210281', '赵屯乡', '1', '210281201', null, '3', '1'),
('210281203', '210281', '土城乡', '1', '210281203', null, '3', '1'),
('210281204', '210281', '阎店乡', '1', '210281204', null, '3', '1'),
('210281205', '210281', '西杨乡', '1', '210281205', null, '3', '1'),
('210281206', '210281', '驼山乡', '1', '210281206', null, '3', '1'),
('210281208', '210281', '三台满族乡', '1', '210281208', null, '3', '1'),
('210281209', '210281', '交流岛乡', '1', '210281209', null, '3', '1'),
('210281210', '210281', '泡崖乡', '1', '210281210', null, '3', '1'),
('210281212', '210281', '杨家满族乡', '1', '210281212', null, '3', '1'),
('210282001', '210282', '丰荣街道', '1', '210282001', null, '3', '1'),
('210282002', '210282', '铁西街道', '1', '210282002', null, '3', '1'),
('210282003', '210282', '太平街道', '1', '210282003', null, '3', '1'),
('210282004', '210282', '南山街道', '1', '210282004', null, '3', '1'),
('210282101', '210282', '皮口镇', '1', '210282101', null, '3', '1'),
('210282102', '210282', '城子坦镇', '1', '210282102', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('210282104', '210282', '大刘家镇', '1', '210282104', null, '3', '1'),
('210282105', '210282', '杨树房镇', '1', '210282105', null, '3', '1'),
('210282106', '210282', '双塔镇', '1', '210282106', null, '3', '1'),
('210282107', '210282', '安波镇', '1', '210282107', null, '3', '1'),
('210282108', '210282', '四平镇', '1', '210282108', null, '3', '1'),
('210282109', '210282', '沙包镇', '1', '210282109', null, '3', '1'),
('210282110', '210282', '瓦窝镇', '1', '210282110', null, '3', '1'),
('210282111', '210282', '元台镇', '1', '210282111', null, '3', '1'),
('210282113', '210282', '大谭镇', '1', '210282113', null, '3', '1'),
('210282114', '210282', '夹河庙镇', '1', '210282114', null, '3', '1'),
('210282116', '210282', '莲山镇', '1', '210282116', null, '3', '1'),
('210282117', '210282', '星台镇', '1', '210282117', null, '3', '1'),
('210282206', '210282', '墨盘乡', '1', '210282206', null, '3', '1'),
('210282208', '210282', '同益乡', '1', '210282208', null, '3', '1'),
('210282209', '210282', '乐甲满族乡', '1', '210282209', null, '3', '1'),
('210283001', '210283', '城关街道', '1', '210283001', null, '3', '1'),
('210283002', '210283', '新华街道', '1', '210283002', null, '3', '1'),
('210283003', '210283', '兴达街道', '1', '210283003', null, '3', '1'),
('210283004', '210283', '昌盛街道', '1', '210283004', null, '3', '1'),
('210283101', '210283', '青堆镇', '1', '210283101', null, '3', '1'),
('210283102', '210283', '徐岭镇', '1', '210283102', null, '3', '1'),
('210283104', '210283', '黑岛镇', '1', '210283104', null, '3', '1'),
('210283105', '210283', '栗子房镇', '1', '210283105', null, '3', '1'),
('210283107', '210283', '大营镇', '1', '210283107', null, '3', '1'),
('210283108', '210283', '塔岭满族镇', '1', '210283108', null, '3', '1'),
('210283109', '210283', '仙人洞镇', '1', '210283109', null, '3', '1'),
('210283110', '210283', '蓉花山镇', '1', '210283110', null, '3', '1'),
('210283111', '210283', '长岭镇', '1', '210283111', null, '3', '1'),
('210283112', '210283', '荷花山镇', '1', '210283112', null, '3', '1'),
('210283113', '210283', '城山镇', '1', '210283113', null, '3', '1'),
('210283114', '210283', '光明山镇', '1', '210283114', null, '3', '1'),
('210283115', '210283', '大郑镇', '1', '210283115', null, '3', '1'),
('210283117', '210283', '明阳镇', '1', '210283117', null, '3', '1'),
('210283118', '210283', '吴炉镇', '1', '210283118', null, '3', '1'),
('210283120', '210283', '王家镇', '1', '210283120', null, '3', '1'),
('210283204', '210283', '鞍子山乡', '1', '210283204', null, '3', '1'),
('210283208', '210283', '太平岭满族乡', '1', '210283208', null, '3', '1'),
('210283209', '210283', '步云山乡', '1', '210283209', null, '3', '1'),
('210283211', '210283', '桂云花满族乡', '1', '210283211', null, '3', '1'),
('210283214', '210283', '兰店乡', '1', '210283214', null, '3', '1'),
('210283216', '210283', '石城乡', '1', '210283216', null, '3', '1'),
('210302001', '210302', '长甸', '1', '210302001', null, '3', '1'),
('210302002', '210302', '解放', '1', '210302002', null, '3', '1'),
('210302003', '210302', '山南', '1', '210302003', null, '3', '1'),
('210302004', '210302', '园林', '1', '210302004', null, '3', '1'),
('210302005', '210302', '胜利', '1', '210302005', null, '3', '1'),
('210302006', '210302', '站前', '1', '210302006', null, '3', '1'),
('210302007', '210302', '钢城', '1', '210302007', null, '3', '1'),
('210302008', '210302', '和平', '1', '210302008', null, '3', '1'),
('210302009', '210302', '对炉', '1', '210302009', null, '3', '1'),
('210302010', '210302', '东长甸', '1', '210302010', null, '3', '1'),
('210302011', '210302', '湖南', '1', '210302011', null, '3', '1'),
('210302012', '210302', '常青', '1', '210302012', null, '3', '1'),
('210302013', '210302', '新兴', '1', '210302013', null, '3', '1'),
('210303001', '210303', '启明街道', '1', '210303001', null, '3', '1'),
('210303002', '210303', '繁荣街道', '1', '210303002', null, '3', '1'),
('210303003', '210303', '八家子街道', '1', '210303003', null, '3', '1'),
('210303004', '210303', '兴盛街道', '1', '210303004', null, '3', '1'),
('210303005', '210303', '共和街道', '1', '210303005', null, '3', '1'),
('210303006', '210303', '永乐街道', '1', '210303006', null, '3', '1'),
('210303007', '210303', '北陶官街道', '1', '210303007', null, '3', '1'),
('210303008', '210303', '南华街道', '1', '210303008', null, '3', '1'),
('210303009', '210303', '大陆街道', '1', '210303009', null, '3', '1'),
('210303010', '210303', '新陶官街道', '1', '210303010', null, '3', '1'),
('210304001', '210304', '友好', '1', '210304001', null, '3', '1'),
('210304004', '210304', '双山', '1', '210304004', null, '3', '1'),
('210304006', '210304', '立山', '1', '210304006', null, '3', '1'),
('210304008', '210304', '曙光', '1', '210304008', null, '3', '1'),
('210304009', '210304', '灵山', '1', '210304009', null, '3', '1'),
('210304013', '210304', '深南', '1', '210304013', null, '3', '1'),
('210304014', '210304', '深北', '1', '210304014', null, '3', '1'),
('210304015', '210304', '沙河', '1', '210304015', null, '3', '1'),
('210304100', '210304', '沙河镇', '1', '210304100', null, '3', '1'),
('210311001', '210311', '旧堡街道', '1', '210311001', null, '3', '1'),
('210311002', '210311', '大孤山街道', '1', '210311002', null, '3', '1'),
('210311101', '210311', '东鞍山镇', '1', '210311101', null, '3', '1'),
('210311102', '210311', '唐家房镇', '1', '210311102', null, '3', '1'),
('210311103', '210311', '大孤山镇', '1', '210311103', null, '3', '1'),
('210311104', '210311', '千山镇', '1', '210311104', null, '3', '1'),
('210311105', '210311', '齐大山镇', '1', '210311105', null, '3', '1'),
('210311106', '210311', '达道湾镇', '1', '210311106', null, '3', '1'),
('210311107', '210311', '宁远镇', '1', '210311107', null, '3', '1'),
('210311108', '210311', '汤岗子镇', '1', '210311108', null, '3', '1'),
('210311401', '210311', '鞍山高新区', '1', '210311401', null, '3', '1'),
('210311402', '210311', '千山风景区管理委员会', '1', '210311402', null, '3', '1'),
('210321100', '210321', '台安镇', '1', '210321100', null, '3', '1'),
('210321101', '210321', '西佛镇', '1', '210321101', null, '3', '1'),
('210321102', '210321', '新开河镇', '1', '210321102', null, '3', '1'),
('210321103', '210321', '黄沙坨镇', '1', '210321103', null, '3', '1'),
('210321104', '210321', '高力房镇', '1', '210321104', null, '3', '1'),
('210321105', '210321', '桑林镇', '1', '210321105', null, '3', '1'),
('210321106', '210321', '富家镇', '1', '210321106', null, '3', '1'),
('210321107', '210321', '达牛镇', '1', '210321107', null, '3', '1'),
('210321109', '210321', '韭菜台镇', '1', '210321109', null, '3', '1'),
('210321110', '210321', '新台镇', '1', '210321110', null, '3', '1'),
('210321111', '210321', '桓洞镇', '1', '210321111', null, '3', '1'),
('210321400', '210321', '新华农场', '1', '210321400', null, '3', '1'),
('210321401', '210321', '洪家农牧场', '1', '210321401', null, '3', '1'),
('210321402', '210321', '西平林场', '1', '210321402', null, '3', '1'),
('210323100', '210323', '岫岩镇', '1', '210323100', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('210323101', '210323', '三家子镇', '1', '210323101', null, '3', '1'),
('210323102', '210323', '石庙子镇', '1', '210323102', null, '3', '1'),
('210323103', '210323', '黄花甸镇', '1', '210323103', null, '3', '1'),
('210323104', '210323', '大营子镇', '1', '210323104', null, '3', '1'),
('210323105', '210323', '苏子沟镇', '1', '210323105', null, '3', '1'),
('210323106', '210323', '偏岭镇', '1', '210323106', null, '3', '1'),
('210323107', '210323', '哈达碑镇', '1', '210323107', null, '3', '1'),
('210323108', '210323', '新甸镇', '1', '210323108', null, '3', '1'),
('210323109', '210323', '洋河镇', '1', '210323109', null, '3', '1'),
('210323111', '210323', '杨家堡镇', '1', '210323111', null, '3', '1'),
('210323112', '210323', '汤沟镇', '1', '210323112', null, '3', '1'),
('210323113', '210323', '石灰窑镇', '1', '210323113', null, '3', '1'),
('210323114', '210323', '前营子镇', '1', '210323114', null, '3', '1'),
('210323115', '210323', '龙潭镇', '1', '210323115', null, '3', '1'),
('210323201', '210323', '牧牛乡', '1', '210323201', null, '3', '1'),
('210323202', '210323', '韭菜沟乡', '1', '210323202', null, '3', '1'),
('210323204', '210323', '大房身乡', '1', '210323204', null, '3', '1'),
('210323205', '210323', '朝阳乡', '1', '210323205', null, '3', '1'),
('210323206', '210323', '红旗营子乡', '1', '210323206', null, '3', '1'),
('210323211', '210323', '岭沟乡', '1', '210323211', null, '3', '1'),
('210323212', '210323', '哨子河乡', '1', '210323212', null, '3', '1'),
('210381001', '210381', '海州街道', '1', '210381001', null, '3', '1'),
('210381002', '210381', '兴海街道', '1', '210381002', null, '3', '1'),
('210381003', '210381', '响堂街道', '1', '210381003', null, '3', '1'),
('210381004', '210381', '东四街道', '1', '210381004', null, '3', '1'),
('210381101', '210381', '孤山镇', '1', '210381101', null, '3', '1'),
('210381102', '210381', '岔沟镇', '1', '210381102', null, '3', '1'),
('210381103', '210381', '接文镇', '1', '210381103', null, '3', '1'),
('210381104', '210381', '析木镇', '1', '210381104', null, '3', '1'),
('210381105', '210381', '马风镇', '1', '210381105', null, '3', '1'),
('210381107', '210381', '牌楼镇', '1', '210381107', null, '3', '1'),
('210381108', '210381', '八里镇', '1', '210381108', null, '3', '1'),
('210381109', '210381', '毛祁镇', '1', '210381109', null, '3', '1'),
('210381110', '210381', '英落镇', '1', '210381110', null, '3', '1'),
('210381111', '210381', '感王镇', '1', '210381111', null, '3', '1'),
('210381112', '210381', '西柳镇', '1', '210381112', null, '3', '1'),
('210381113', '210381', '中小镇', '1', '210381113', null, '3', '1'),
('210381114', '210381', '王石镇', '1', '210381114', null, '3', '1'),
('210381115', '210381', '南台镇', '1', '210381115', null, '3', '1'),
('210381116', '210381', '甘泉镇', '1', '210381116', null, '3', '1'),
('210381117', '210381', '大屯镇', '1', '210381117', null, '3', '1'),
('210381118', '210381', '腾鳌镇', '1', '210381118', null, '3', '1'),
('210381120', '210381', '东四方台温泉管理区', '1', '210381120', null, '3', '1'),
('210381121', '210381', '耿庄镇', '1', '210381121', null, '3', '1'),
('210381123', '210381', '牛庄镇', '1', '210381123', null, '3', '1'),
('210381124', '210381', '西四镇', '1', '210381124', null, '3', '1'),
('210381125', '210381', '望台镇', '1', '210381125', null, '3', '1'),
('210381126', '210381', '温香镇', '1', '210381126', null, '3', '1'),
('210381127', '210381', '高坨镇', '1', '210381127', null, '3', '1'),
('210381400', '210381', '海城经济开发区', '1', '210381400', null, '3', '1'),
('210402001', '210402', '站前街道', '1', '210402001', null, '3', '1'),
('210402003', '210402', '东公园街道', '1', '210402003', null, '3', '1'),
('210402005', '210402', '福民街道', '1', '210402005', null, '3', '1'),
('210402007', '210402', '新抚街道', '1', '210402007', null, '3', '1'),
('210402009', '210402', '榆林街道', '1', '210402009', null, '3', '1'),
('210402011', '210402', '永安台街道', '1', '210402011', null, '3', '1'),
('210402013', '210402', '千金街道', '1', '210402013', null, '3', '1'),
('210402015', '210402', '南阳街道', '1', '210402015', null, '3', '1'),
('210403002', '210403', '东洲街道', '1', '210403002', null, '3', '1'),
('210403003', '210403', '张甸街道', '1', '210403003', null, '3', '1'),
('210403004', '210403', '搭连街道', '1', '210403004', null, '3', '1'),
('210403005', '210403', '龙凤街道', '1', '210403005', null, '3', '1'),
('210403006', '210403', '新屯街道', '1', '210403006', null, '3', '1'),
('210403007', '210403', '万新街道', '1', '210403007', null, '3', '1'),
('210403008', '210403', '老虎台街道', '1', '210403008', null, '3', '1'),
('210403009', '210403', '平山街道', '1', '210403009', null, '3', '1'),
('210403010', '210403', '南花园街道', '1', '210403010', null, '3', '1'),
('210403011', '210403', '刘山街道', '1', '210403011', null, '3', '1'),
('210403012', '210403', '章党街道', '1', '210403012', null, '3', '1'),
('210403201', '210403', '千金乡', '1', '210403201', null, '3', '1'),
('210403202', '210403', '碾盘乡', '1', '210403202', null, '3', '1'),
('210404001', '210404', '田屯街道', '1', '210404001', null, '3', '1'),
('210404002', '210404', '工农街道', '1', '210404002', null, '3', '1'),
('210404003', '210404', '建设街道', '1', '210404003', null, '3', '1'),
('210404004', '210404', '和平街道', '1', '210404004', null, '3', '1'),
('210404005', '210404', '光明街道', '1', '210404005', null, '3', '1'),
('210404006', '210404', '朴屯街道', '1', '210404006', null, '3', '1'),
('210404007', '210404', '演武街道', '1', '210404007', null, '3', '1'),
('210404008', '210404', '五老屯街道', '1', '210404008', null, '3', '1'),
('210404009', '210404', '古城子街道', '1', '210404009', null, '3', '1'),
('210404010', '210404', '新民街道', '1', '210404010', null, '3', '1'),
('210404011', '210404', '李石街道', '1', '210404011', null, '3', '1'),
('210404101', '210404', '塔峪镇', '1', '210404101', null, '3', '1'),
('210411001', '210411', '河东街道', '1', '210411001', null, '3', '1'),
('210411002', '210411', '长春街道', '1', '210411002', null, '3', '1'),
('210411003', '210411', '葛布街道', '1', '210411003', null, '3', '1'),
('210411004', '210411', '将军堡街道', '1', '210411004', null, '3', '1'),
('210411005', '210411', '新华街道', '1', '210411005', null, '3', '1'),
('210411007', '210411', '抚顺城街道', '1', '210411007', null, '3', '1'),
('210411102', '210411', '前甸镇', '1', '210411102', null, '3', '1'),
('210411201', '210411', '河北乡', '1', '210411201', null, '3', '1'),
('210411205', '210411', '会元乡', '1', '210411205', null, '3', '1'),
('210421101', '210421', '石文镇', '1', '210421101', null, '3', '1'),
('210421102', '210421', '后安镇', '1', '210421102', null, '3', '1'),
('210421103', '210421', '章党镇', '1', '210421103', null, '3', '1'),
('210421104', '210421', '哈达镇', '1', '210421104', null, '3', '1'),
('210421204', '210421', '马圈子乡', '1', '210421204', null, '3', '1'),
('210421205', '210421', '上马乡', '1', '210421205', null, '3', '1'),
('210421207', '210421', '救兵乡', '1', '210421207', null, '3', '1'),
('210421209', '210421', '峡河乡', '1', '210421209', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('210421211', '210421', '海浪乡', '1', '210421211', null, '3', '1'),
('210421212', '210421', '拉古满族乡', '1', '210421212', null, '3', '1'),
('210421215', '210421', '兰山乡', '1', '210421215', null, '3', '1'),
('210421216', '210421', '汤图满族乡', '1', '210421216', null, '3', '1'),
('210422100', '210422', '新宾镇', '1', '210422100', null, '3', '1'),
('210422101', '210422', '旺清门镇', '1', '210422101', null, '3', '1'),
('210422102', '210422', '永陵镇', '1', '210422102', null, '3', '1'),
('210422103', '210422', '平顶山镇', '1', '210422103', null, '3', '1'),
('210422104', '210422', '大四平镇', '1', '210422104', null, '3', '1'),
('210422105', '210422', '苇子峪镇', '1', '210422105', null, '3', '1'),
('210422106', '210422', '木奇镇', '1', '210422106', null, '3', '1'),
('210422108', '210422', '上夹河镇', '1', '210422108', null, '3', '1'),
('210422109', '210422', '南杂木镇', '1', '210422109', null, '3', '1'),
('210422202', '210422', '红升乡', '1', '210422202', null, '3', '1'),
('210422203', '210422', '响水河子乡', '1', '210422203', null, '3', '1'),
('210422204', '210422', '红庙子乡', '1', '210422204', null, '3', '1'),
('210422205', '210422', '北四平乡', '1', '210422205', null, '3', '1'),
('210422207', '210422', '榆树乡', '1', '210422207', null, '3', '1'),
('210422208', '210422', '下夹河乡', '1', '210422208', null, '3', '1'),
('210423100', '210423', '清原镇', '1', '210423100', null, '3', '1'),
('210423101', '210423', '红透山镇', '1', '210423101', null, '3', '1'),
('210423103', '210423', '草市镇', '1', '210423103', null, '3', '1'),
('210423104', '210423', '英额门镇', '1', '210423104', null, '3', '1'),
('210423105', '210423', '南口前镇', '1', '210423105', null, '3', '1'),
('210423106', '210423', '南山城镇', '1', '210423106', null, '3', '1'),
('210423107', '210423', '湾甸子镇', '1', '210423107', null, '3', '1'),
('210423108', '210423', '大孤家镇', '1', '210423108', null, '3', '1'),
('210423109', '210423', '夏家堡镇', '1', '210423109', null, '3', '1'),
('210423203', '210423', '土口子乡', '1', '210423203', null, '3', '1'),
('210423204', '210423', '北三家乡', '1', '210423204', null, '3', '1'),
('210423206', '210423', '敖家堡乡', '1', '210423206', null, '3', '1'),
('210423207', '210423', '大苏河乡', '1', '210423207', null, '3', '1'),
('210423208', '210423', '枸乃甸乡', '1', '210423208', null, '3', '1'),
('210502001', '210502', '南地街道', '1', '210502001', null, '3', '1'),
('210502002', '210502', '工人街道', '1', '210502002', null, '3', '1'),
('210502003', '210502', '平山街道', '1', '210502003', null, '3', '1'),
('210502004', '210502', '东明街道', '1', '210502004', null, '3', '1'),
('210502005', '210502', '崔东街道', '1', '210502005', null, '3', '1'),
('210502007', '210502', '站前街道', '1', '210502007', null, '3', '1'),
('210502008', '210502', '千金街道', '1', '210502008', null, '3', '1'),
('210502010', '210502', '北台街道', '1', '210502010', null, '3', '1'),
('210502101', '210502', '桥头镇', '1', '210502101', null, '3', '1'),
('210503001', '210503', '河东街道', '1', '210503001', null, '3', '1'),
('210503003', '210503', '河西街道', '1', '210503003', null, '3', '1'),
('210503005', '210503', '彩屯街道', '1', '210503005', null, '3', '1'),
('210503006', '210503', '竖井街道', '1', '210503006', null, '3', '1'),
('210503007', '210503', '彩北街道', '1', '210503007', null, '3', '1'),
('210503009', '210503', '东风街道', '1', '210503009', null, '3', '1'),
('210503101', '210503', '火连寨镇', '1', '210503101', null, '3', '1'),
('210503102', '210503', '歪头山镇', '1', '210503102', null, '3', '1'),
('210503104', '210503', '石桥子镇', '1', '210503104', null, '3', '1'),
('210503201', '210503', '张其寨乡', '1', '210503201', null, '3', '1'),
('210504001', '210504', '金山街道', '1', '210504001', null, '3', '1'),
('210504002', '210504', '北地街道', '1', '210504002', null, '3', '1'),
('210504004', '210504', '高峪街道', '1', '210504004', null, '3', '1'),
('210504005', '210504', '明山街道', '1', '210504005', null, '3', '1'),
('210504007', '210504', '东兴街道', '1', '210504007', null, '3', '1'),
('210504008', '210504', '新明街道', '1', '210504008', null, '3', '1'),
('210504009', '210504', '牛心台街道', '1', '210504009', null, '3', '1'),
('210504010', '210504', '卧龙街道', '1', '210504010', null, '3', '1'),
('210504101', '210504', '高台子镇', '1', '210504101', null, '3', '1'),
('210505001', '210505', '南芬街道', '1', '210505001', null, '3', '1'),
('210505002', '210505', '铁山街道', '1', '210505002', null, '3', '1'),
('210505003', '210505', '郭家街道', '1', '210505003', null, '3', '1'),
('210505101', '210505', '下马塘镇', '1', '210505101', null, '3', '1'),
('210505202', '210505', '思山岭满族乡', '1', '210505202', null, '3', '1'),
('210521001', '210521', '观音阁街道', '1', '210521001', null, '3', '1'),
('210521100', '210521', '小市镇', '1', '210521100', null, '3', '1'),
('210521101', '210521', '草河掌镇', '1', '210521101', null, '3', '1'),
('210521102', '210521', '草河城镇', '1', '210521102', null, '3', '1'),
('210521103', '210521', '草河口镇', '1', '210521103', null, '3', '1'),
('210521104', '210521', '连山关镇', '1', '210521104', null, '3', '1'),
('210521106', '210521', '清河城镇', '1', '210521106', null, '3', '1'),
('210521109', '210521', '田师傅镇', '1', '210521109', null, '3', '1'),
('210521110', '210521', '南甸镇', '1', '210521110', null, '3', '1'),
('210521111', '210521', '碱厂镇', '1', '210521111', null, '3', '1'),
('210521112', '210521', '高官镇', '1', '210521112', null, '3', '1'),
('210521202', '210521', '东营房乡', '1', '210521202', null, '3', '1'),
('210522001', '210522', '江城街道', '1', '210522001', null, '3', '1'),
('210522100', '210522', '桓仁镇', '1', '210522100', null, '3', '1'),
('210522101', '210522', '普乐堡镇', '1', '210522101', null, '3', '1'),
('210522102', '210522', '二棚甸子镇', '1', '210522102', null, '3', '1'),
('210522103', '210522', '沙尖子镇', '1', '210522103', null, '3', '1'),
('210522104', '210522', '五里甸子镇', '1', '210522104', null, '3', '1'),
('210522108', '210522', '八里甸子镇', '1', '210522108', null, '3', '1'),
('210522110', '210522', '华来镇', '1', '210522110', null, '3', '1'),
('210522111', '210522', '古城镇', '1', '210522111', null, '3', '1'),
('210522201', '210522', '雅河朝鲜族乡', '1', '210522201', null, '3', '1'),
('210522202', '210522', '向阳乡', '1', '210522202', null, '3', '1'),
('210522206', '210522', '黑沟乡', '1', '210522206', null, '3', '1'),
('210522208', '210522', '北甸子乡', '1', '210522208', null, '3', '1'),
('210602001', '210602', '六道口街道', '1', '210602001', null, '3', '1'),
('210602002', '210602', '七道街道', '1', '210602002', null, '3', '1'),
('210602003', '210602', '八道街道', '1', '210602003', null, '3', '1'),
('210602004', '210602', '九道街道', '1', '210602004', null, '3', '1'),
('210602005', '210602', '广济街道', '1', '210602005', null, '3', '1'),
('210602006', '210602', '兴东街道', '1', '210602006', null, '3', '1'),
('210602101', '210602', '金山镇', '1', '210602101', null, '3', '1'),
('210603001', '210603', '头道桥街道', '1', '210603001', null, '3', '1'),
('210603002', '210603', '站前街道', '1', '210603002', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('210603003', '210603', '临江街道', '1', '210603003', null, '3', '1'),
('210603004', '210603', '六道街道', '1', '210603004', null, '3', '1'),
('210603005', '210603', '帽盔山街道', '1', '210603005', null, '3', '1'),
('210603006', '210603', '纤维街道', '1', '210603006', null, '3', '1'),
('210603007', '210603', '永昌街道', '1', '210603007', null, '3', '1'),
('210603008', '210603', '花园街道', '1', '210603008', null, '3', '1'),
('210603101', '210603', '浪头镇', '1', '210603101', null, '3', '1'),
('210603102', '210603', '安民镇', '1', '210603102', null, '3', '1'),
('210604001', '210604', '鸭绿江街道', '1', '210604001', null, '3', '1'),
('210604003', '210604', '金矿街道', '1', '210604003', null, '3', '1'),
('210604004', '210604', '珍珠街道', '1', '210604004', null, '3', '1'),
('210604005', '210604', '太平湾街道', '1', '210604005', null, '3', '1'),
('210604102', '210604', '同兴镇', '1', '210604102', null, '3', '1'),
('210604104', '210604', '五龙背镇', '1', '210604104', null, '3', '1'),
('210604105', '210604', '楼房镇', '1', '210604105', null, '3', '1'),
('210604106', '210604', '九连城镇', '1', '210604106', null, '3', '1'),
('210604107', '210604', '汤山城镇', '1', '210604107', null, '3', '1'),
('210624100', '210624', '宽甸镇', '1', '210624100', null, '3', '1'),
('210624101', '210624', '灌水镇', '1', '210624101', null, '3', '1'),
('210624102', '210624', '硼海镇', '1', '210624102', null, '3', '1'),
('210624103', '210624', '红石镇', '1', '210624103', null, '3', '1'),
('210624104', '210624', '毛甸子镇', '1', '210624104', null, '3', '1'),
('210624105', '210624', '长甸镇', '1', '210624105', null, '3', '1'),
('210624106', '210624', '永甸镇', '1', '210624106', null, '3', '1'),
('210624108', '210624', '太平哨镇', '1', '210624108', null, '3', '1'),
('210624109', '210624', '青山沟镇', '1', '210624109', null, '3', '1'),
('210624110', '210624', '牛毛坞镇', '1', '210624110', null, '3', '1'),
('210624111', '210624', '大川头镇', '1', '210624111', null, '3', '1'),
('210624112', '210624', '青椅山镇', '1', '210624112', null, '3', '1'),
('210624113', '210624', '杨木川镇', '1', '210624113', null, '3', '1'),
('210624114', '210624', '虎山镇', '1', '210624114', null, '3', '1'),
('210624115', '210624', '振江镇', '1', '210624115', null, '3', '1'),
('210624116', '210624', '步达远镇', '1', '210624116', null, '3', '1'),
('210624117', '210624', '大西岔镇', '1', '210624117', null, '3', '1'),
('210624118', '210624', '八河川镇', '1', '210624118', null, '3', '1'),
('210624119', '210624', '双山子镇', '1', '210624119', null, '3', '1'),
('210624201', '210624', '石湖沟乡', '1', '210624201', null, '3', '1'),
('210624206', '210624', '古楼子乡', '1', '210624206', null, '3', '1'),
('210624212', '210624', '下露河朝鲜族乡', '1', '210624212', null, '3', '1'),
('210681001', '210681', '大东街道', '1', '210681001', null, '3', '1'),
('210681002', '210681', '新兴街道', '1', '210681002', null, '3', '1'),
('210681003', '210681', '新城街道', '1', '210681003', null, '3', '1'),
('210681101', '210681', '孤山镇', '1', '210681101', null, '3', '1'),
('210681103', '210681', '汤池镇', '1', '210681103', null, '3', '1'),
('210681104', '210681', '前阳镇', '1', '210681104', null, '3', '1'),
('210681105', '210681', '长安镇', '1', '210681105', null, '3', '1'),
('210681106', '210681', '十字街镇', '1', '210681106', null, '3', '1'),
('210681107', '210681', '长山镇', '1', '210681107', null, '3', '1'),
('210681108', '210681', '北井子镇', '1', '210681108', null, '3', '1'),
('210681109', '210681', '椅圈镇', '1', '210681109', null, '3', '1'),
('210681110', '210681', '黄土坎镇', '1', '210681110', null, '3', '1'),
('210681113', '210681', '马家店镇', '1', '210681113', null, '3', '1'),
('210681114', '210681', '龙王庙满族锡伯族镇', '1', '210681114', null, '3', '1'),
('210681115', '210681', '小甸子镇', '1', '210681115', null, '3', '1'),
('210681117', '210681', '菩萨庙镇', '1', '210681117', null, '3', '1'),
('210681118', '210681', '黑沟镇', '1', '210681118', null, '3', '1'),
('210681119', '210681', '新农镇', '1', '210681119', null, '3', '1'),
('210681206', '210681', '合隆乡', '1', '210681206', null, '3', '1'),
('210681401', '210681', '示范农场', '1', '210681401', null, '3', '1'),
('210681402', '210681', '黄土坎农场', '1', '210681402', null, '3', '1'),
('210681403', '210681', '海洋红农场', '1', '210681403', null, '3', '1'),
('210681404', '210681', '兴隆农场', '1', '210681404', null, '3', '1'),
('210681405', '210681', '五四农场', '1', '210681405', null, '3', '1'),
('210682001', '210682', '凤凰城街道', '1', '210682001', null, '3', '1'),
('210682002', '210682', '凤山街道', '1', '210682002', null, '3', '1'),
('210682003', '210682', '草河街道', '1', '210682003', null, '3', '1'),
('210682101', '210682', '宝山镇', '1', '210682101', null, '3', '1'),
('210682102', '210682', '白旗镇', '1', '210682102', null, '3', '1'),
('210682103', '210682', '沙里寨镇', '1', '210682103', null, '3', '1'),
('210682104', '210682', '红旗镇', '1', '210682104', null, '3', '1'),
('210682105', '210682', '蓝旗镇', '1', '210682105', null, '3', '1'),
('210682107', '210682', '边门镇', '1', '210682107', null, '3', '1'),
('210682109', '210682', '大堡蒙古族镇', '1', '210682109', null, '3', '1'),
('210682110', '210682', '东汤镇', '1', '210682110', null, '3', '1'),
('210682111', '210682', '石城镇', '1', '210682111', null, '3', '1'),
('210682112', '210682', '大兴镇', '1', '210682112', null, '3', '1'),
('210682113', '210682', '爱阳镇', '1', '210682113', null, '3', '1'),
('210682114', '210682', '赛马镇', '1', '210682114', null, '3', '1'),
('210682115', '210682', '弟兄山镇', '1', '210682115', null, '3', '1'),
('210682116', '210682', '鸡冠山镇', '1', '210682116', null, '3', '1'),
('210682117', '210682', '刘家河镇', '1', '210682117', null, '3', '1'),
('210682118', '210682', '通远堡镇', '1', '210682118', null, '3', '1'),
('210682119', '210682', '四门子镇', '1', '210682119', null, '3', '1'),
('210682120', '210682', '青城子镇', '1', '210682120', null, '3', '1'),
('210702001', '210702', '天安街道', '1', '210702001', null, '3', '1'),
('210702002', '210702', '石油街道', '1', '210702002', null, '3', '1'),
('210702003', '210702', '北街街道', '1', '210702003', null, '3', '1'),
('210702004', '210702', '敬业街道', '1', '210702004', null, '3', '1'),
('210702005', '210702', '保安街道', '1', '210702005', null, '3', '1'),
('210702006', '210702', '南街街道', '1', '210702006', null, '3', '1'),
('210702007', '210702', '饶阳街道', '1', '210702007', null, '3', '1'),
('210702008', '210702', '站前街道', '1', '210702008', null, '3', '1'),
('210702009', '210702', '士英街道', '1', '210702009', null, '3', '1'),
('210703001', '210703', '正大街道', '1', '210703001', null, '3', '1'),
('210703002', '210703', '石桥子街道', '1', '210703002', null, '3', '1'),
('210703003', '210703', '龙江街道', '1', '210703003', null, '3', '1'),
('210703004', '210703', '榴花街道', '1', '210703004', null, '3', '1'),
('210703005', '210703', '铁新街道', '1', '210703005', null, '3', '1'),
('210703006', '210703', '凌安街道', '1', '210703006', null, '3', '1'),
('210703007', '210703', '菊园街道', '1', '210703007', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('210703008', '210703', '康宁街道', '1', '210703008', null, '3', '1'),
('210703009', '210703', '锦铁街道', '1', '210703009', null, '3', '1'),
('210703010', '210703', '马家街道', '1', '210703010', null, '3', '1'),
('210703011', '210703', '百股街道', '1', '210703011', null, '3', '1'),
('210703402', '210703', '锦州北山农工商总公司', '1', '210703402', null, '3', '1'),
('210711001', '210711', '太和街道', '1', '210711001', null, '3', '1'),
('210711002', '210711', '兴隆街道', '1', '210711002', null, '3', '1'),
('210711003', '210711', '汤河子街道', '1', '210711003', null, '3', '1'),
('210711004', '210711', '凌西街道', '1', '210711004', null, '3', '1'),
('210711006', '210711', '凌南街道', '1', '210711006', null, '3', '1'),
('210711007', '210711', '大薛街道', '1', '210711007', null, '3', '1'),
('210711070', '210711', '王家街道', '1', '210711070', null, '3', '1'),
('210711071', '210711', '天桥街道', '1', '210711071', null, '3', '1'),
('210711072', '210711', '杏山街道', '1', '210711072', null, '3', '1'),
('210711202', '210711', '女儿河乡', '1', '210711202', null, '3', '1'),
('210711203', '210711', '钟屯乡', '1', '210711203', null, '3', '1'),
('210711204', '210711', '营盘乡', '1', '210711204', null, '3', '1'),
('210711205', '210711', '新民乡', '1', '210711205', null, '3', '1'),
('210711401', '210711', '锦州市果树农场', '1', '210711401', null, '3', '1'),
('210726100', '210726', '黑山镇', '1', '210726100', null, '3', '1'),
('210726101', '210726', '芳山镇', '1', '210726101', null, '3', '1'),
('210726102', '210726', '白厂门镇', '1', '210726102', null, '3', '1'),
('210726103', '210726', '常兴镇', '1', '210726103', null, '3', '1'),
('210726104', '210726', '姜屯镇', '1', '210726104', null, '3', '1'),
('210726105', '210726', '励家镇', '1', '210726105', null, '3', '1'),
('210726106', '210726', '绕阳河镇', '1', '210726106', null, '3', '1'),
('210726107', '210726', '半拉门镇', '1', '210726107', null, '3', '1'),
('210726108', '210726', '无梁殿镇', '1', '210726108', null, '3', '1'),
('210726109', '210726', '胡家镇', '1', '210726109', null, '3', '1'),
('210726110', '210726', '新立屯镇', '1', '210726110', null, '3', '1'),
('210726111', '210726', '八道壕镇', '1', '210726111', null, '3', '1'),
('210726112', '210726', '大虎山镇', '1', '210726112', null, '3', '1'),
('210726113', '210726', '四家子镇', '1', '210726113', null, '3', '1'),
('210726114', '210726', '新兴镇', '1', '210726114', null, '3', '1'),
('210726116', '210726', '太和镇', '1', '210726116', null, '3', '1'),
('210726201', '210726', '英城子乡', '1', '210726201', null, '3', '1'),
('210726208', '210726', '镇安乡', '1', '210726208', null, '3', '1'),
('210726209', '210726', '段家乡', '1', '210726209', null, '3', '1'),
('210726210', '210726', '大兴乡', '1', '210726210', null, '3', '1'),
('210726212', '210726', '薛屯乡', '1', '210726212', null, '3', '1'),
('210726400', '210726', '辽宁省锦州市小东种畜场', '1', '210726400', null, '3', '1'),
('210727100', '210727', '义州镇', '1', '210727100', null, '3', '1'),
('210727101', '210727', '刘龙台镇', '1', '210727101', null, '3', '1'),
('210727102', '210727', '七里河镇', '1', '210727102', null, '3', '1'),
('210727103', '210727', '大榆树堡镇', '1', '210727103', null, '3', '1'),
('210727104', '210727', '稍户营子镇', '1', '210727104', null, '3', '1'),
('210727105', '210727', '九道岭镇', '1', '210727105', null, '3', '1'),
('210727106', '210727', '高台子镇', '1', '210727106', null, '3', '1'),
('210727108', '210727', '瓦子峪镇', '1', '210727108', null, '3', '1'),
('210727201', '210727', '城关满族乡', '1', '210727201', null, '3', '1'),
('210727202', '210727', '头道河满族乡', '1', '210727202', null, '3', '1'),
('210727203', '210727', '地藏寺满族乡', '1', '210727203', null, '3', '1'),
('210727204', '210727', '留龙沟满族乡', '1', '210727204', null, '3', '1'),
('210727205', '210727', '大定堡满族乡', '1', '210727205', null, '3', '1'),
('210727206', '210727', '前杨乡', '1', '210727206', null, '3', '1'),
('210727207', '210727', '白庙子乡', '1', '210727207', null, '3', '1'),
('210727208', '210727', '聚粮屯乡', '1', '210727208', null, '3', '1'),
('210727209', '210727', '张家堡乡', '1', '210727209', null, '3', '1'),
('210727215', '210727', '头台满族乡', '1', '210727215', null, '3', '1'),
('210781001', '210781', '大凌河街道', '1', '210781001', null, '3', '1'),
('210781002', '210781', '金城街道', '1', '210781002', null, '3', '1'),
('210781101', '210781', '石山镇', '1', '210781101', null, '3', '1'),
('210781102', '210781', '余积镇', '1', '210781102', null, '3', '1'),
('210781103', '210781', '双羊镇', '1', '210781103', null, '3', '1'),
('210781104', '210781', '班吉塔镇', '1', '210781104', null, '3', '1'),
('210781105', '210781', '沈家台镇', '1', '210781105', null, '3', '1'),
('210781106', '210781', '三台子镇', '1', '210781106', null, '3', '1'),
('210781107', '210781', '右卫满族镇', '1', '210781107', null, '3', '1'),
('210781108', '210781', '阎家镇', '1', '210781108', null, '3', '1'),
('210781109', '210781', '新庄子镇', '1', '210781109', null, '3', '1'),
('210781110', '210781', '娘娘宫镇', '1', '210781110', null, '3', '1'),
('210781112', '210781', '翠岩镇', '1', '210781112', null, '3', '1'),
('210781170', '210781', '松山镇', '1', '210781170', null, '3', '1'),
('210781202', '210781', '大业乡', '1', '210781202', null, '3', '1'),
('210781204', '210781', '西八千乡', '1', '210781204', null, '3', '1'),
('210781205', '210781', '建业乡', '1', '210781205', null, '3', '1'),
('210781210', '210781', '温滴楼满族乡', '1', '210781210', null, '3', '1'),
('210781212', '210781', '板石沟乡', '1', '210781212', null, '3', '1'),
('210781214', '210781', '白台子乡', '1', '210781214', null, '3', '1'),
('210781217', '210781', '谢屯乡', '1', '210781217', null, '3', '1'),
('210781219', '210781', '安屯乡', '1', '210781219', null, '3', '1'),
('210781401', '210781', '辽宁省金城原种场', '1', '210781401', null, '3', '1'),
('210781405', '210781', '大有农场', '1', '210781405', null, '3', '1'),
('210782004', '210782', '北镇街道', '1', '210782004', null, '3', '1'),
('210782005', '210782', '观音阁街道', '1', '210782005', null, '3', '1'),
('210782101', '210782', '大市镇', '1', '210782101', null, '3', '1'),
('210782102', '210782', '罗罗堡镇', '1', '210782102', null, '3', '1'),
('210782103', '210782', '常兴店镇', '1', '210782103', null, '3', '1'),
('210782104', '210782', '正安镇', '1', '210782104', null, '3', '1'),
('210782105', '210782', '闾阳镇', '1', '210782105', null, '3', '1'),
('210782106', '210782', '中安镇', '1', '210782106', null, '3', '1'),
('210782107', '210782', '廖屯镇', '1', '210782107', null, '3', '1'),
('210782109', '210782', '赵屯镇', '1', '210782109', null, '3', '1'),
('210782110', '210782', '青堆子镇', '1', '210782110', null, '3', '1'),
('210782111', '210782', '高山子镇', '1', '210782111', null, '3', '1'),
('210782112', '210782', '沟帮子镇', '1', '210782112', null, '3', '1'),
('210782201', '210782', '富屯乡', '1', '210782201', null, '3', '1'),
('210782203', '210782', '鲍家乡', '1', '210782203', null, '3', '1'),
('210782206', '210782', '大屯乡', '1', '210782206', null, '3', '1'),
('210782208', '210782', '吴家乡', '1', '210782208', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('210782209', '210782', '柳家乡', '1', '210782209', null, '3', '1'),
('210782211', '210782', '广宁乡', '1', '210782211', null, '3', '1'),
('210782403', '210782', '新立农场', '1', '210782403', null, '3', '1'),
('210802001', '210802', '八田地街道', '1', '210802001', null, '3', '1'),
('210802002', '210802', '建丰街道', '1', '210802002', null, '3', '1'),
('210802003', '210802', '建设街道', '1', '210802003', null, '3', '1'),
('210802004', '210802', '跃进街道', '1', '210802004', null, '3', '1'),
('210802005', '210802', '东风街道', '1', '210802005', null, '3', '1'),
('210802006', '210802', '新兴街道', '1', '210802006', null, '3', '1'),
('210802007', '210802', '新建街道', '1', '210802007', null, '3', '1'),
('210803001', '210803', '胜利街道', '1', '210803001', null, '3', '1'),
('210803002', '210803', '清华街道', '1', '210803002', null, '3', '1'),
('210803003', '210803', '滨海街道', '1', '210803003', null, '3', '1'),
('210803004', '210803', '得胜街道', '1', '210803004', null, '3', '1'),
('210803005', '210803', '五台子街道', '1', '210803005', null, '3', '1'),
('210803006', '210803', '渔市街道', '1', '210803006', null, '3', '1'),
('210803007', '210803', '河北街道', '1', '210803007', null, '3', '1'),
('210804001', '210804', '红海街道', '1', '210804001', null, '3', '1'),
('210804002', '210804', '海星街道', '1', '210804002', null, '3', '1'),
('210804003', '210804', '望海街道', '1', '210804003', null, '3', '1'),
('210804004', '210804', '海东街道', '1', '210804004', null, '3', '1'),
('210804100', '210804', '熊岳镇', '1', '210804100', null, '3', '1'),
('210804101', '210804', '芦屯镇', '1', '210804101', null, '3', '1'),
('210804102', '210804', '红旗满族镇', '1', '210804102', null, '3', '1'),
('210811001', '210811', '老边街道', '1', '210811001', null, '3', '1'),
('210811002', '210811', '城东街道', '1', '210811002', null, '3', '1'),
('210811101', '210811', '路南镇', '1', '210811101', null, '3', '1'),
('210811102', '210811', '柳树镇', '1', '210811102', null, '3', '1'),
('210811103', '210811', '边城镇', '1', '210811103', null, '3', '1'),
('210811104', '210811', '二道镇', '1', '210811104', null, '3', '1'),
('210881001', '210881', '鼓楼街道', '1', '210881001', null, '3', '1'),
('210881002', '210881', '西城街道', '1', '210881002', null, '3', '1'),
('210881003', '210881', '东城街道', '1', '210881003', null, '3', '1'),
('210881004', '210881', '太阳升街道', '1', '210881004', null, '3', '1'),
('210881005', '210881', '团山街道', '1', '210881005', null, '3', '1'),
('210881006', '210881', '西海街道', '1', '210881006', null, '3', '1'),
('210881102', '210881', '高屯镇', '1', '210881102', null, '3', '1'),
('210881105', '210881', '沙岗镇', '1', '210881105', null, '3', '1'),
('210881108', '210881', '九垅地镇', '1', '210881108', null, '3', '1'),
('210881109', '210881', '九寨镇', '1', '210881109', null, '3', '1'),
('210881110', '210881', '万福镇', '1', '210881110', null, '3', '1'),
('210881111', '210881', '卧龙泉镇', '1', '210881111', null, '3', '1'),
('210881112', '210881', '青石岭镇', '1', '210881112', null, '3', '1'),
('210881113', '210881', '暖泉镇', '1', '210881113', null, '3', '1'),
('210881115', '210881', '归州满族镇', '1', '210881115', null, '3', '1'),
('210881116', '210881', '榜式堡镇', '1', '210881116', null, '3', '1'),
('210881117', '210881', '团甸镇', '1', '210881117', null, '3', '1'),
('210881118', '210881', '双台镇', '1', '210881118', null, '3', '1'),
('210881119', '210881', '杨运镇', '1', '210881119', null, '3', '1'),
('210881120', '210881', '徐屯镇', '1', '210881120', null, '3', '1'),
('210881121', '210881', '什字街镇', '1', '210881121', null, '3', '1'),
('210881122', '210881', '矿洞沟镇', '1', '210881122', null, '3', '1'),
('210881123', '210881', '陈屯镇', '1', '210881123', null, '3', '1'),
('210881124', '210881', '梁屯镇', '1', '210881124', null, '3', '1'),
('210881216', '210881', '小石棚乡', '1', '210881216', null, '3', '1'),
('210881217', '210881', '果园乡', '1', '210881217', null, '3', '1'),
('210881218', '210881', '二台乡', '1', '210881218', null, '3', '1'),
('210882001', '210882', '石桥街道', '1', '210882001', null, '3', '1'),
('210882002', '210882', '青花街道', '1', '210882002', null, '3', '1'),
('210882003', '210882', '金桥街道', '1', '210882003', null, '3', '1'),
('210882004', '210882', '钢都街道', '1', '210882004', null, '3', '1'),
('210882005', '210882', '南楼街道', '1', '210882005', null, '3', '1'),
('210882101', '210882', '水源镇', '1', '210882101', null, '3', '1'),
('210882102', '210882', '沟沿镇', '1', '210882102', null, '3', '1'),
('210882103', '210882', '石佛镇', '1', '210882103', null, '3', '1'),
('210882104', '210882', '高坎镇', '1', '210882104', null, '3', '1'),
('210882105', '210882', '旗口镇', '1', '210882105', null, '3', '1'),
('210882106', '210882', '虎庄镇', '1', '210882106', null, '3', '1'),
('210882107', '210882', '官屯镇', '1', '210882107', null, '3', '1'),
('210882112', '210882', '博洛铺镇', '1', '210882112', null, '3', '1'),
('210882113', '210882', '永安镇', '1', '210882113', null, '3', '1'),
('210882114', '210882', '汤池镇', '1', '210882114', null, '3', '1'),
('210882115', '210882', '建一镇', '1', '210882115', null, '3', '1'),
('210882116', '210882', '黄土岭镇', '1', '210882116', null, '3', '1'),
('210882117', '210882', '周家镇', '1', '210882117', null, '3', '1'),
('210902002', '210902', '新兴街道', '1', '210902002', null, '3', '1'),
('210902003', '210902', '和平街道', '1', '210902003', null, '3', '1'),
('210902004', '210902', '西山街道', '1', '210902004', null, '3', '1'),
('210902005', '210902', '河北街道', '1', '210902005', null, '3', '1'),
('210902006', '210902', '站前街道', '1', '210902006', null, '3', '1'),
('210902007', '210902', '西阜新街道', '1', '210902007', null, '3', '1'),
('210902008', '210902', '五龙街道', '1', '210902008', null, '3', '1'),
('210902009', '210902', '平安西部街道', '1', '210902009', null, '3', '1'),
('210902010', '210902', '工人村街道', '1', '210902010', null, '3', '1'),
('210902011', '210902', '东梁街道', '1', '210902011', null, '3', '1'),
('210902101', '210902', '韩家店镇', '1', '210902101', null, '3', '1'),
('210903001', '210903', '街基街道', '1', '210903001', null, '3', '1'),
('210903002', '210903', '中部街道', '1', '210903002', null, '3', '1'),
('210903003', '210903', '北部街道', '1', '210903003', null, '3', '1'),
('210903004', '210903', '南部街道', '1', '210903004', null, '3', '1'),
('210903101', '210903', '长营子蒙古族镇', '1', '210903101', null, '3', '1'),
('210904001', '210904', '红树街道', '1', '210904001', null, '3', '1'),
('210904002', '210904', '煤海街道', '1', '210904002', null, '3', '1'),
('210904003', '210904', '高德街道', '1', '210904003', null, '3', '1'),
('210904004', '210904', '孙家湾街道', '1', '210904004', null, '3', '1'),
('210904005', '210904', '城南街道', '1', '210904005', null, '3', '1'),
('210904101', '210904', '水泉镇', '1', '210904101', null, '3', '1'),
('210905001', '210905', '清河街道', '1', '210905001', null, '3', '1'),
('210905002', '210905', '六台街道', '1', '210905002', null, '3', '1'),
('210905003', '210905', '艾友街道', '1', '210905003', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('210905004', '210905', '新北街道', '1', '210905004', null, '3', '1'),
('210905101', '210905', '河西镇', '1', '210905101', null, '3', '1'),
('210905102', '210905', '乌龙坝镇', '1', '210905102', null, '3', '1'),
('210911001', '210911', '西苑街道', '1', '210911001', null, '3', '1'),
('210911002', '210911', '北苑街道', '1', '210911002', null, '3', '1'),
('210911003', '210911', '东苑街道', '1', '210911003', null, '3', '1'),
('210911004', '210911', '学院街道', '1', '210911004', null, '3', '1'),
('210911005', '210911', '中苑街道', '1', '210911005', null, '3', '1'),
('210911006', '210911', '华东街道', '1', '210911006', null, '3', '1'),
('210911102', '210911', '四合镇', '1', '210911102', null, '3', '1'),
('210921100', '210921', '阜新镇', '1', '210921100', null, '3', '1'),
('210921102', '210921', '东梁镇', '1', '210921102', null, '3', '1'),
('210921103', '210921', '佛寺镇', '1', '210921103', null, '3', '1'),
('210921104', '210921', '伊吗图镇', '1', '210921104', null, '3', '1'),
('210921105', '210921', '旧庙镇', '1', '210921105', null, '3', '1'),
('210921106', '210921', '务欢池镇', '1', '210921106', null, '3', '1'),
('210921107', '210921', '建设镇', '1', '210921107', null, '3', '1'),
('210921108', '210921', '大巴镇', '1', '210921108', null, '3', '1'),
('210921109', '210921', '泡子镇', '1', '210921109', null, '3', '1'),
('210921110', '210921', '十家子镇', '1', '210921110', null, '3', '1'),
('210921111', '210921', '王府镇', '1', '210921111', null, '3', '1'),
('210921112', '210921', '于寺镇', '1', '210921112', null, '3', '1'),
('210921113', '210921', '富荣镇', '1', '210921113', null, '3', '1'),
('210921114', '210921', '新民镇', '1', '210921114', null, '3', '1'),
('210921115', '210921', '福兴地镇', '1', '210921115', null, '3', '1'),
('210921116', '210921', '平安地镇', '1', '210921116', null, '3', '1'),
('210921117', '210921', '沙拉镇', '1', '210921117', null, '3', '1'),
('210921118', '210921', '大固本镇', '1', '210921118', null, '3', '1'),
('210921119', '210921', '大五家子镇', '1', '210921119', null, '3', '1'),
('210921120', '210921', '大板镇', '1', '210921120', null, '3', '1'),
('210921201', '210921', '蜘蛛山乡', '1', '210921201', null, '3', '1'),
('210921203', '210921', '卧凤沟乡', '1', '210921203', null, '3', '1'),
('210921204', '210921', '八家子乡', '1', '210921204', null, '3', '1'),
('210921205', '210921', '哈达户稍乡', '1', '210921205', null, '3', '1'),
('210921207', '210921', '塔营子乡', '1', '210921207', null, '3', '1'),
('210921208', '210921', '扎兰营子乡', '1', '210921208', null, '3', '1'),
('210921210', '210921', '招束沟乡', '1', '210921210', null, '3', '1'),
('210921211', '210921', '苍土乡', '1', '210921211', null, '3', '1'),
('210921214', '210921', '老河土乡', '1', '210921214', null, '3', '1'),
('210921215', '210921', '七家子乡', '1', '210921215', null, '3', '1'),
('210921217', '210921', '红帽子乡', '1', '210921217', null, '3', '1'),
('210921218', '210921', '紫都台乡', '1', '210921218', null, '3', '1'),
('210921219', '210921', '化石戈乡', '1', '210921219', null, '3', '1'),
('210921220', '210921', '太平乡', '1', '210921220', null, '3', '1'),
('210921222', '210921', '国华乡', '1', '210921222', null, '3', '1'),
('210921401', '210921', '泡子', '1', '210921401', null, '3', '1'),
('210922100', '210922', '彰武镇', '1', '210922100', null, '3', '1'),
('210922101', '210922', '哈尔套镇', '1', '210922101', null, '3', '1'),
('210922102', '210922', '章古台镇', '1', '210922102', null, '3', '1'),
('210922103', '210922', '五峰镇', '1', '210922103', null, '3', '1'),
('210922104', '210922', '冯家镇', '1', '210922104', null, '3', '1'),
('210922105', '210922', '后新秋镇', '1', '210922105', null, '3', '1'),
('210922106', '210922', '东六家子镇', '1', '210922106', null, '3', '1'),
('210922107', '210922', '阿尔乡镇', '1', '210922107', null, '3', '1'),
('210922201', '210922', '苇子沟蒙古族乡', '1', '210922201', null, '3', '1'),
('210922202', '210922', '二道河子蒙古族乡', '1', '210922202', null, '3', '1'),
('210922203', '210922', '西六家子蒙古族满族乡', '1', '210922203', null, '3', '1'),
('210922204', '210922', '两家子乡', '1', '210922204', null, '3', '1'),
('210922205', '210922', '双庙乡', '1', '210922205', null, '3', '1'),
('210922206', '210922', '平安乡', '1', '210922206', null, '3', '1'),
('210922207', '210922', '满堂红乡', '1', '210922207', null, '3', '1'),
('210922208', '210922', '四堡子乡', '1', '210922208', null, '3', '1'),
('210922209', '210922', '丰田乡', '1', '210922209', null, '3', '1'),
('210922210', '210922', '大德乡', '1', '210922210', null, '3', '1'),
('210922211', '210922', '大冷蒙古族乡', '1', '210922211', null, '3', '1'),
('210922212', '210922', '前福兴地乡', '1', '210922212', null, '3', '1'),
('210922213', '210922', '兴隆堡乡', '1', '210922213', null, '3', '1'),
('210922214', '210922', '兴隆山乡', '1', '210922214', null, '3', '1'),
('210922215', '210922', '大四家子乡', '1', '210922215', null, '3', '1'),
('210922216', '210922', '四合城乡', '1', '210922216', null, '3', '1'),
('211002001', '211002', '星火街道', '1', '211002001', null, '3', '1'),
('211002002', '211002', '胜利街道', '1', '211002002', null, '3', '1'),
('211002003', '211002', '跃进街道', '1', '211002003', null, '3', '1'),
('211002005', '211002', '卫国路街道', '1', '211002005', null, '3', '1'),
('211002006', '211002', '站前街道', '1', '211002006', null, '3', '1'),
('211002009', '211002', '铁西街道', '1', '211002009', null, '3', '1'),
('211003001', '211003', '武圣街道', '1', '211003001', null, '3', '1'),
('211003002', '211003', '文圣街道', '1', '211003002', null, '3', '1'),
('211003003', '211003', '襄平街道', '1', '211003003', null, '3', '1'),
('211003004', '211003', '庆阳街道', '1', '211003004', null, '3', '1'),
('211003005', '211003', '南门街道', '1', '211003005', null, '3', '1'),
('211003007', '211003', '东兴街道', '1', '211003007', null, '3', '1'),
('211004001', '211004', '工农街道', '1', '211004001', null, '3', '1'),
('211004002', '211004', '光华街道', '1', '211004002', null, '3', '1'),
('211004003', '211004', '新村街道', '1', '211004003', null, '3', '1'),
('211004004', '211004', '长征街道', '1', '211004004', null, '3', '1'),
('211004101', '211004', '曙光镇', '1', '211004101', null, '3', '1'),
('211005001', '211005', '苏家街道', '1', '211005001', null, '3', '1'),
('211005002', '211005', '团山街道', '1', '211005002', null, '3', '1'),
('211005003', '211005', '安平街道', '1', '211005003', null, '3', '1'),
('211005101', '211005', '汤河镇', '1', '211005101', null, '3', '1'),
('211005201', '211005', '安平乡', '1', '211005201', null, '3', '1'),
('211011001', '211011', '新华街道', '1', '211011001', null, '3', '1'),
('211011002', '211011', '望水台街道', '1', '211011002', null, '3', '1'),
('211011101', '211011', '祁家镇', '1', '211011101', null, '3', '1'),
('211011202', '211011', '东京陵乡', '1', '211011202', null, '3', '1'),
('211011204', '211011', '东宁卫乡', '1', '211011204', null, '3', '1'),
('211021100', '211021', '首山镇', '1', '211021100', null, '3', '1'),
('211021101', '211021', '刘二堡镇', '1', '211021101', null, '3', '1'),
('211021102', '211021', '小屯镇', '1', '211021102', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('211021103', '211021', '小北河镇', '1', '211021103', null, '3', '1'),
('211021104', '211021', '黄泥洼镇', '1', '211021104', null, '3', '1'),
('211021105', '211021', '沙岭镇', '1', '211021105', null, '3', '1'),
('211021106', '211021', '唐马寨镇', '1', '211021106', null, '3', '1'),
('211021107', '211021', '穆家镇', '1', '211021107', null, '3', '1'),
('211021108', '211021', '柳壕镇', '1', '211021108', null, '3', '1'),
('211021109', '211021', '兰家镇', '1', '211021109', null, '3', '1'),
('211021110', '211021', '河栏镇', '1', '211021110', null, '3', '1'),
('211021111', '211021', '隆昌镇', '1', '211021111', null, '3', '1'),
('211021112', '211021', '八会镇', '1', '211021112', null, '3', '1'),
('211021113', '211021', '寒岭镇', '1', '211021113', null, '3', '1'),
('211021201', '211021', '下达河乡', '1', '211021201', null, '3', '1'),
('211021202', '211021', '吉洞峪满族乡', '1', '211021202', null, '3', '1'),
('211021206', '211021', '甜水满族乡', '1', '211021206', null, '3', '1'),
('211081001', '211081', '烟台街道', '1', '211081001', null, '3', '1'),
('211081002', '211081', '万宝桥街道', '1', '211081002', null, '3', '1'),
('211081003', '211081', '古城子街道', '1', '211081003', null, '3', '1'),
('211081101', '211081', '佟二堡镇', '1', '211081101', null, '3', '1'),
('211081102', '211081', '铧子镇', '1', '211081102', null, '3', '1'),
('211081103', '211081', '张台子镇', '1', '211081103', null, '3', '1'),
('211081104', '211081', '西大窑镇', '1', '211081104', null, '3', '1'),
('211081105', '211081', '沈旦堡镇', '1', '211081105', null, '3', '1'),
('211081106', '211081', '西马峰镇', '1', '211081106', null, '3', '1'),
('211081107', '211081', '柳条寨镇', '1', '211081107', null, '3', '1'),
('211081108', '211081', '柳河子镇', '1', '211081108', null, '3', '1'),
('211081109', '211081', '罗大台镇', '1', '211081109', null, '3', '1'),
('211081110', '211081', '王家镇', '1', '211081110', null, '3', '1'),
('211081111', '211081', '大河南镇', '1', '211081111', null, '3', '1'),
('211081114', '211081', '五星镇', '1', '211081114', null, '3', '1'),
('211081205', '211081', '鸡冠山乡', '1', '211081205', null, '3', '1'),
('211102001', '211102', '东风街道', '1', '211102001', null, '3', '1'),
('211102002', '211102', '胜利街道', '1', '211102002', null, '3', '1'),
('211102003', '211102', '建设街道', '1', '211102003', null, '3', '1'),
('211102004', '211102', '红旗街道', '1', '211102004', null, '3', '1'),
('211102005', '211102', '辽河街道', '1', '211102005', null, '3', '1'),
('211102006', '211102', '石油街道', '1', '211102006', null, '3', '1'),
('211102007', '211102', '化工街道', '1', '211102007', null, '3', '1'),
('211102008', '211102', '铁东街道', '1', '211102008', null, '3', '1'),
('211102009', '211102', '双盛街道', '1', '211102009', null, '3', '1'),
('211103001', '211103', '振兴街道', '1', '211103001', null, '3', '1'),
('211103002', '211103', '兴隆街道', '1', '211103002', null, '3', '1'),
('211103003', '211103', '渤海街道', '1', '211103003', null, '3', '1'),
('211103004', '211103', '新工街道', '1', '211103004', null, '3', '1'),
('211103005', '211103', '于楼街道', '1', '211103005', null, '3', '1'),
('211103006', '211103', '友谊街道', '1', '211103006', null, '3', '1'),
('211103007', '211103', '曙光街道', '1', '211103007', null, '3', '1'),
('211103008', '211103', '欢喜街道', '1', '211103008', null, '3', '1'),
('211103009', '211103', '平安街道', '1', '211103009', null, '3', '1'),
('211103010', '211103', '新生街道', '1', '211103010', null, '3', '1'),
('211103011', '211103', '红村街道', '1', '211103011', null, '3', '1'),
('211103012', '211103', '高升街道', '1', '211103012', null, '3', '1'),
('211103013', '211103', '沈采街道', '1', '211103013', null, '3', '1'),
('211103014', '211103', '锦采街道', '1', '211103014', null, '3', '1'),
('211103015', '211103', '茨采街道', '1', '211103015', null, '3', '1'),
('211103016', '211103', '创新街道', '1', '211103016', null, '3', '1'),
('211103017', '211103', '兴盛街道', '1', '211103017', null, '3', '1'),
('211103018', '211103', '兴海街道', '1', '211103018', null, '3', '1'),
('211121100', '211121', '大洼镇', '1', '211121100', null, '3', '1'),
('211121101', '211121', '田庄台镇', '1', '211121101', null, '3', '1'),
('211121102', '211121', '二界沟镇', '1', '211121102', null, '3', '1'),
('211121103', '211121', '东风镇', '1', '211121103', null, '3', '1'),
('211121104', '211121', '新开镇', '1', '211121104', null, '3', '1'),
('211121105', '211121', '田家镇', '1', '211121105', null, '3', '1'),
('211121106', '211121', '清水镇', '1', '211121106', null, '3', '1'),
('211121107', '211121', '新兴镇', '1', '211121107', null, '3', '1'),
('211121108', '211121', '西安镇', '1', '211121108', null, '3', '1'),
('211121109', '211121', '新立镇', '1', '211121109', null, '3', '1'),
('211121201', '211121', '王家乡', '1', '211121201', null, '3', '1'),
('211121202', '211121', '唐家乡', '1', '211121202', null, '3', '1'),
('211121205', '211121', '荣兴乡', '1', '211121205', null, '3', '1'),
('211121207', '211121', '平安乡', '1', '211121207', null, '3', '1'),
('211121210', '211121', '赵圈河乡', '1', '211121210', null, '3', '1'),
('211121400', '211121', '辽滨开发区', '1', '211121400', null, '3', '1'),
('211122101', '211122', '沙岭镇', '1', '211122101', null, '3', '1'),
('211122102', '211122', '高升镇', '1', '211122102', null, '3', '1'),
('211122103', '211122', '胡家镇', '1', '211122103', null, '3', '1'),
('211122104', '211122', '石新镇', '1', '211122104', null, '3', '1'),
('211122105', '211122', '东郭镇', '1', '211122105', null, '3', '1'),
('211122106', '211122', '羊圈子镇', '1', '211122106', null, '3', '1'),
('211122107', '211122', '古城子镇', '1', '211122107', null, '3', '1'),
('211122108', '211122', '坝墙子镇', '1', '211122108', null, '3', '1'),
('211122109', '211122', '太平镇', '1', '211122109', null, '3', '1'),
('211122203', '211122', '陈家乡', '1', '211122203', null, '3', '1'),
('211122205', '211122', '吴家乡', '1', '211122205', null, '3', '1'),
('211122206', '211122', '陆家乡', '1', '211122206', null, '3', '1'),
('211122207', '211122', '甜水乡', '1', '211122207', null, '3', '1'),
('211122208', '211122', '大荒乡', '1', '211122208', null, '3', '1'),
('211122400', '211122', '盘山县林场', '1', '211122400', null, '3', '1'),
('211202001', '211202', '红旗街道', '1', '211202001', null, '3', '1'),
('211202002', '211202', '工人街道', '1', '211202002', null, '3', '1'),
('211202003', '211202', '铁西街道', '1', '211202003', null, '3', '1'),
('211202004', '211202', '铜钟街道', '1', '211202004', null, '3', '1'),
('211202005', '211202', '柴河街道', '1', '211202005', null, '3', '1'),
('211202006', '211202', '岭东街道', '1', '211202006', null, '3', '1'),
('211202201', '211202', '龙山乡', '1', '211202201', null, '3', '1'),
('211202401', '211202', '铁岭经济开发区', '1', '211202401', null, '3', '1'),
('211204001', '211204', '红旗街道', '1', '211204001', null, '3', '1'),
('211204002', '211204', '向阳街道', '1', '211204002', null, '3', '1'),
('211204101', '211204', '张相镇', '1', '211204101', null, '3', '1'),
('211204202', '211204', '杨木林子乡', '1', '211204202', null, '3', '1'),
('211204203', '211204', '聂家满族乡', '1', '211204203', null, '3', '1'),
('211221101', '211221', '新台子镇', '1', '211221101', null, '3', '1'),
('211221102', '211221', '阿吉镇', '1', '211221102', null, '3', '1'),
('211221103', '211221', '平顶堡镇', '1', '211221103', null, '3', '1'),
('211221104', '211221', '大甸子镇', '1', '211221104', null, '3', '1'),
('211221105', '211221', '凡河镇', '1', '211221105', null, '3', '1'),
('211221106', '211221', '腰堡镇', '1', '211221106', null, '3', '1'),
('211221107', '211221', '镇西堡镇', '1', '211221107', null, '3', '1'),
('211221201', '211221', '蔡牛乡', '1', '211221201', null, '3', '1'),
('211221203', '211221', '双井子乡', '1', '211221203', null, '3', '1'),
('211221204', '211221', '熊官屯乡', '1', '211221204', null, '3', '1'),
('211221205', '211221', '李千户乡', '1', '211221205', null, '3', '1'),
('211221206', '211221', '横道河子乡', '1', '211221206', null, '3', '1'),
('211221208', '211221', '鸡冠山乡', '1', '211221208', null, '3', '1'),
('211221209', '211221', '白旗寨满族乡', '1', '211221209', null, '3', '1'),
('211221401', '211221', '种畜场', '1', '211221401', null, '3', '1'),
('211223100', '211223', '西丰镇', '1', '211223100', null, '3', '1'),
('211223101', '211223', '平岗镇', '1', '211223101', null, '3', '1'),
('211223102', '211223', '郜家店镇', '1', '211223102', null, '3', '1'),
('211223103', '211223', '凉泉镇', '1', '211223103', null, '3', '1'),
('211223104', '211223', '振兴镇', '1', '211223104', null, '3', '1'),
('211223105', '211223', '安民镇', '1', '211223105', null, '3', '1'),
('211223106', '211223', '天德镇', '1', '211223106', null, '3', '1'),
('211223107', '211223', '房木镇', '1', '211223107', null, '3', '1'),
('211223201', '211223', '陶然乡', '1', '211223201', null, '3', '1'),
('211223203', '211223', '柏榆乡', '1', '211223203', null, '3', '1'),
('211223204', '211223', '德兴乡', '1', '211223204', null, '3', '1'),
('211223205', '211223', '钓鱼乡', '1', '211223205', null, '3', '1'),
('211223206', '211223', '明德乡', '1', '211223206', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('211223209', '211223', '成平满族乡', '1', '211223209', null, '3', '1'),
('211223211', '211223', '和隆满族乡', '1', '211223211', null, '3', '1'),
('211223212', '211223', '营厂乡', '1', '211223212', null, '3', '1'),
('211223213', '211223', '金星乡', '1', '211223213', null, '3', '1'),
('211223214', '211223', '更刻乡', '1', '211223214', null, '3', '1'),
('211224100', '211224', '昌图镇', '1', '211224100', null, '3', '1'),
('211224101', '211224', '老城镇', '1', '211224101', null, '3', '1'),
('211224102', '211224', '八面城镇', '1', '211224102', null, '3', '1'),
('211224103', '211224', '三江口镇', '1', '211224103', null, '3', '1'),
('211224104', '211224', '金家镇', '1', '211224104', null, '3', '1'),
('211224105', '211224', '宝力镇', '1', '211224105', null, '3', '1'),
('211224106', '211224', '泉头满族镇', '1', '211224106', null, '3', '1'),
('211224107', '211224', '双庙子镇', '1', '211224107', null, '3', '1'),
('211224108', '211224', '亮中桥镇', '1', '211224108', null, '3', '1'),
('211224109', '211224', '马仲河镇', '1', '211224109', null, '3', '1'),
('211224110', '211224', '毛家店镇', '1', '211224110', null, '3', '1'),
('211224111', '211224', '老四平镇', '1', '211224111', null, '3', '1'),
('211224112', '211224', '大洼镇', '1', '211224112', null, '3', '1'),
('211224113', '211224', '头道镇', '1', '211224113', null, '3', '1'),
('211224114', '211224', '此路树镇', '1', '211224114', null, '3', '1'),
('211224115', '211224', '付家镇', '1', '211224115', null, '3', '1'),
('211224117', '211224', '四合镇', '1', '211224117', null, '3', '1'),
('211224118', '211224', '朝阳镇', '1', '211224118', null, '3', '1'),
('211224119', '211224', '古榆树镇', '1', '211224119', null, '3', '1'),
('211224120', '211224', '七家子镇', '1', '211224120', null, '3', '1'),
('211224121', '211224', '东嘎镇', '1', '211224121', null, '3', '1'),
('211224122', '211224', '四面城镇', '1', '211224122', null, '3', '1'),
('211224123', '211224', '前双井子镇', '1', '211224123', null, '3', '1'),
('211224204', '211224', '大兴乡', '1', '211224204', null, '3', '1'),
('211224205', '211224', '十八家子乡', '1', '211224205', null, '3', '1'),
('211224207', '211224', '通江口乡', '1', '211224207', null, '3', '1'),
('211224208', '211224', '大四家子乡', '1', '211224208', null, '3', '1'),
('211224209', '211224', '后窑乡', '1', '211224209', null, '3', '1'),
('211224211', '211224', '长发乡', '1', '211224211', null, '3', '1'),
('211224212', '211224', '太平乡', '1', '211224212', null, '3', '1'),
('211224213', '211224', '下二台乡', '1', '211224213', null, '3', '1'),
('211224216', '211224', '平安堡乡', '1', '211224216', null, '3', '1'),
('211224217', '211224', '曲家店乡', '1', '211224217', null, '3', '1'),
('211224401', '211224', '三江口农场', '1', '211224401', null, '3', '1'),
('211224402', '211224', '宝力农场', '1', '211224402', null, '3', '1'),
('211224403', '211224', '新乡农场', '1', '211224403', null, '3', '1'),
('211224404', '211224', '付家林场', '1', '211224404', null, '3', '1'),
('211224405', '211224', '忙牛马场', '1', '211224405', null, '3', '1'),
('211224406', '211224', '两家子农场', '1', '211224406', null, '3', '1'),
('211281001', '211281', '兀术街道', '1', '211281001', null, '3', '1'),
('211281002', '211281', '调兵山街道', '1', '211281002', null, '3', '1'),
('211281102', '211281', '晓明镇', '1', '211281102', null, '3', '1'),
('211281103', '211281', '大明镇', '1', '211281103', null, '3', '1'),
('211281105', '211281', '晓南镇', '1', '211281105', null, '3', '1'),
('211282001', '211282', '新城街道', '1', '211282001', null, '3', '1'),
('211282002', '211282', '老城街道', '1', '211282002', null, '3', '1'),
('211282003', '211282', '兴开街道', '1', '211282003', null, '3', '1'),
('211282102', '211282', '威远堡镇', '1', '211282102', null, '3', '1'),
('211282103', '211282', '庆云堡镇', '1', '211282103', null, '3', '1'),
('211282104', '211282', '中固镇', '1', '211282104', null, '3', '1'),
('211282105', '211282', '八棵树镇', '1', '211282105', null, '3', '1'),
('211282106', '211282', '金沟子镇', '1', '211282106', null, '3', '1'),
('211282107', '211282', '八宝镇', '1', '211282107', null, '3', '1'),
('211282108', '211282', '业民镇', '1', '211282108', null, '3', '1'),
('211282109', '211282', '莲花镇', '1', '211282109', null, '3', '1'),
('211282110', '211282', '靠山镇', '1', '211282110', null, '3', '1'),
('211282201', '211282', '城东乡', '1', '211282201', null, '3', '1'),
('211282206', '211282', '三家子乡', '1', '211282206', null, '3', '1'),
('211282207', '211282', '马家寨乡', '1', '211282207', null, '3', '1'),
('211282210', '211282', '上肥地乡', '1', '211282210', null, '3', '1'),
('211282211', '211282', '下肥地乡', '1', '211282211', null, '3', '1'),
('211282212', '211282', '黄旗寨乡', '1', '211282212', null, '3', '1'),
('211282213', '211282', '松山堡乡', '1', '211282213', null, '3', '1'),
('211282216', '211282', '李家台乡', '1', '211282216', null, '3', '1'),
('211282217', '211282', '林丰乡', '1', '211282217', null, '3', '1'),
('211302001', '211302', '南塔街道', '1', '211302001', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('211302002', '211302', '北塔街道', '1', '211302002', null, '3', '1'),
('211302003', '211302', '前进街道', '1', '211302003', null, '3', '1'),
('211302004', '211302', '凌河街道', '1', '211302004', null, '3', '1'),
('211302005', '211302', '光明街道', '1', '211302005', null, '3', '1'),
('211302006', '211302', '凌凤街道', '1', '211302006', null, '3', '1'),
('211302007', '211302', '龙山街道', '1', '211302007', null, '3', '1'),
('211302008', '211302', '站南街道', '1', '211302008', null, '3', '1'),
('211302009', '211302', '红旗街道', '1', '211302009', null, '3', '1'),
('211302010', '211302', '燕北街道', '1', '211302010', null, '3', '1'),
('211302100', '211302', '桃花吐镇', '1', '211302100', null, '3', '1'),
('211302101', '211302', '他拉皋镇', '1', '211302101', null, '3', '1'),
('211302205', '211302', '长宝营子乡', '1', '211302205', null, '3', '1'),
('211302206', '211302', '孙家湾乡', '1', '211302206', null, '3', '1'),
('211303001', '211303', '向阳街道', '1', '211303001', null, '3', '1'),
('211303002', '211303', '半拉山街道', '1', '211303002', null, '3', '1'),
('211303003', '211303', '马山街道', '1', '211303003', null, '3', '1'),
('211303004', '211303', '新华街道', '1', '211303004', null, '3', '1'),
('211303005', '211303', '海龙街道', '1', '211303005', null, '3', '1'),
('211303070', '211303', '开发区龙泉街道', '1', '211303070', null, '3', '1'),
('211303101', '211303', '七道泉子镇', '1', '211303101', null, '3', '1'),
('211303102', '211303', '西大营子镇', '1', '211303102', null, '3', '1'),
('211303103', '211303', '召都巴镇', '1', '211303103', null, '3', '1'),
('211303105', '211303', '大平房镇', '1', '211303105', null, '3', '1'),
('211303201', '211303', '边杖子乡', '1', '211303201', null, '3', '1'),
('211303203', '211303', '联合乡', '1', '211303203', null, '3', '1'),
('211321102', '211321', '波罗赤镇', '1', '211321102', null, '3', '1'),
('211321103', '211321', '木头城子镇', '1', '211321103', null, '3', '1'),
('211321104', '211321', '二十家子镇', '1', '211321104', null, '3', '1'),
('211321105', '211321', '羊山镇', '1', '211321105', null, '3', '1'),
('211321106', '211321', '六家子镇', '1', '211321106', null, '3', '1'),
('211321107', '211321', '瓦房子镇', '1', '211321107', null, '3', '1'),
('211321108', '211321', '大庙镇', '1', '211321108', null, '3', '1'),
('211321109', '211321', '柳城镇', '1', '211321109', null, '3', '1'),
('211321204', '211321', '南双庙乡', '1', '211321204', null, '3', '1'),
('211321206', '211321', '古山子乡', '1', '211321206', null, '3', '1'),
('211321211', '211321', '西五家子乡', '1', '211321211', null, '3', '1'),
('211321212', '211321', '北沟门子乡', '1', '211321212', null, '3', '1'),
('211321213', '211321', '杨树湾乡', '1', '211321213', null, '3', '1'),
('211321214', '211321', '东大道乡', '1', '211321214', null, '3', '1'),
('211321215', '211321', '乌兰河硕蒙古族乡', '1', '211321215', null, '3', '1'),
('211321216', '211321', '台子乡', '1', '211321216', null, '3', '1'),
('211321218', '211321', '胜利乡', '1', '211321218', null, '3', '1'),
('211321220', '211321', '东大屯乡', '1', '211321220', null, '3', '1'),
('211321221', '211321', '松岭门乡', '1', '211321221', null, '3', '1'),
('211321222', '211321', '根德营子乡', '1', '211321222', null, '3', '1'),
('211321224', '211321', '西营子乡', '1', '211321224', null, '3', '1'),
('211321225', '211321', '七道岭乡', '1', '211321225', null, '3', '1'),
('211321228', '211321', '北四家子乡', '1', '211321228', null, '3', '1'),
('211321230', '211321', '王营子乡', '1', '211321230', null, '3', '1'),
('211321231', '211321', '黑牛营子乡', '1', '211321231', null, '3', '1'),
('211321232', '211321', '尚志乡', '1', '211321232', null, '3', '1'),
('211321233', '211321', '长在营子乡', '1', '211321233', null, '3', '1'),
('211321400', '211321', '国营贾家店农场', '1', '211321400', null, '3', '1'),
('211322001', '211322', '叶柏寿街道', '1', '211322001', null, '3', '1'),
('211322002', '211322', '红山街道', '1', '211322002', null, '3', '1'),
('211322003', '211322', '铁南街道', '1', '211322003', null, '3', '1'),
('211322004', '211322', '万寿街道', '1', '211322004', null, '3', '1'),
('211322005', '211322', '富山街道', '1', '211322005', null, '3', '1'),
('211322101', '211322', '朱碌科镇', '1', '211322101', null, '3', '1'),
('211322102', '211322', '建平镇', '1', '211322102', null, '3', '1'),
('211322103', '211322', '黑水镇', '1', '211322103', null, '3', '1'),
('211322104', '211322', '喀喇沁镇', '1', '211322104', null, '3', '1'),
('211322105', '211322', '北二十家子镇', '1', '211322105', null, '3', '1'),
('211322106', '211322', '沙海镇', '1', '211322106', null, '3', '1'),
('211322108', '211322', '哈拉道口镇', '1', '211322108', null, '3', '1'),
('211322109', '211322', '榆树林子镇', '1', '211322109', null, '3', '1'),
('211322110', '211322', '老官地镇', '1', '211322110', null, '3', '1'),
('211322111', '211322', '深井镇', '1', '211322111', null, '3', '1'),
('211322112', '211322', '奎德素镇', '1', '211322112', null, '3', '1'),
('211322113', '211322', '小塘镇', '1', '211322113', null, '3', '1'),
('211322114', '211322', '马场镇', '1', '211322114', null, '3', '1'),
('211322115', '211322', '昌隆镇', '1', '211322115', null, '3', '1'),
('211322117', '211322', '张家营子镇', '1', '211322117', null, '3', '1'),
('211322205', '211322', '青松岭乡', '1', '211322205', null, '3', '1'),
('211322206', '211322', '杨树岭乡', '1', '211322206', null, '3', '1'),
('211322209', '211322', '罗福沟乡', '1', '211322209', null, '3', '1'),
('211322211', '211322', '烧锅营子乡', '1', '211322211', null, '3', '1'),
('211322213', '211322', '太平庄乡', '1', '211322213', null, '3', '1'),
('211322214', '211322', '白山乡', '1', '211322214', null, '3', '1'),
('211322218', '211322', '三家蒙古族乡', '1', '211322218', null, '3', '1'),
('211322220', '211322', '义成功乡', '1', '211322220', null, '3', '1'),
('211322221', '211322', '青峰山乡', '1', '211322221', null, '3', '1'),
('211322400', '211322', '八家国营农场', '1', '211322400', null, '3', '1'),
('211322401', '211322', '热水国营畜牧农场', '1', '211322401', null, '3', '1'),
('211324100', '211324', '大城子镇', '1', '211324100', null, '3', '1'),
('211324101', '211324', '南公营子镇', '1', '211324101', null, '3', '1'),
('211324102', '211324', '山嘴子镇', '1', '211324102', null, '3', '1'),
('211324103', '211324', '南哨镇', '1', '211324103', null, '3', '1'),
('211324104', '211324', '公营子镇', '1', '211324104', null, '3', '1'),
('211324105', '211324', '白塔子镇', '1', '211324105', null, '3', '1'),
('211324106', '211324', '中三家镇', '1', '211324106', null, '3', '1'),
('211324107', '211324', '老爷庙镇', '1', '211324107', null, '3', '1'),
('211324108', '211324', '六官营子镇', '1', '211324108', null, '3', '1'),
('211324109', '211324', '平房子镇', '1', '211324109', null, '3', '1'),
('211324203', '211324', '十二德堡乡', '1', '211324203', null, '3', '1'),
('211324204', '211324', '尤杖子乡', '1', '211324204', null, '3', '1'),
('211324205', '211324', '东哨乡', '1', '211324205', null, '3', '1'),
('211324206', '211324', '羊角沟乡', '1', '211324206', null, '3', '1'),
('211324207', '211324', '草场乡', '1', '211324207', null, '3', '1'),
('211324210', '211324', '坤都营子乡', '1', '211324210', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('211324211', '211324', '大营子乡', '1', '211324211', null, '3', '1'),
('211324212', '211324', '兴隆庄乡', '1', '211324212', null, '3', '1'),
('211324213', '211324', '甘招乡', '1', '211324213', null, '3', '1'),
('211324214', '211324', '卧虎沟乡', '1', '211324214', null, '3', '1'),
('211324215', '211324', '水泉乡', '1', '211324215', null, '3', '1'),
('211324400', '211324', '国营官大海农场', '1', '211324400', null, '3', '1'),
('211381001', '211381', '城关街道', '1', '211381001', null, '3', '1'),
('211381002', '211381', '南山街道', '1', '211381002', null, '3', '1'),
('211381003', '211381', '冠山街道', '1', '211381003', null, '3', '1'),
('211381004', '211381', '桥北街道', '1', '211381004', null, '3', '1'),
('211381005', '211381', '三宝街道', '1', '211381005', null, '3', '1'),
('211381006', '211381', '台吉街道', '1', '211381006', null, '3', '1'),
('211381008', '211381', '双河街道', '1', '211381008', null, '3', '1'),
('211381101', '211381', '西官营镇', '1', '211381101', null, '3', '1'),
('211381102', '211381', '大板镇', '1', '211381102', null, '3', '1'),
('211381103', '211381', '上园镇', '1', '211381103', null, '3', '1'),
('211381104', '211381', '宝国老镇', '1', '211381104', null, '3', '1'),
('211381105', '211381', '黑城子镇', '1', '211381105', null, '3', '1'),
('211381107', '211381', '五间房镇', '1', '211381107', null, '3', '1'),
('211381108', '211381', '台吉镇', '1', '211381108', null, '3', '1'),
('211381201', '211381', '长皋乡', '1', '211381201', null, '3', '1'),
('211381202', '211381', '常河营乡', '1', '211381202', null, '3', '1'),
('211381203', '211381', '小塔子乡', '1', '211381203', null, '3', '1'),
('211381204', '211381', '马友营蒙古族乡', '1', '211381204', null, '3', '1'),
('211381205', '211381', '蒙古营乡', '1', '211381205', null, '3', '1'),
('211381206', '211381', '泉巨永乡', '1', '211381206', null, '3', '1'),
('211381207', '211381', '大三家乡', '1', '211381207', null, '3', '1'),
('211381208', '211381', '东官营乡', '1', '211381208', null, '3', '1'),
('211381210', '211381', '龙潭乡', '1', '211381210', null, '3', '1'),
('211381212', '211381', '哈尔脑乡', '1', '211381212', null, '3', '1'),
('211381213', '211381', '南八家子乡', '1', '211381213', null, '3', '1'),
('211381214', '211381', '章吉营乡', '1', '211381214', null, '3', '1'),
('211381215', '211381', '三宝营乡', '1', '211381215', null, '3', '1'),
('211381216', '211381', '巴图营乡', '1', '211381216', null, '3', '1'),
('211381218', '211381', '台吉营乡', '1', '211381218', null, '3', '1'),
('211381219', '211381', '北塔子乡', '1', '211381219', null, '3', '1'),
('211381220', '211381', '娄家店乡', '1', '211381220', null, '3', '1'),
('211381221', '211381', '北四家乡', '1', '211381221', null, '3', '1'),
('211381223', '211381', '凉水河蒙古族乡', '1', '211381223', null, '3', '1'),
('211381228', '211381', '三宝乡', '1', '211381228', null, '3', '1'),
('211381270', '211381', '下府经济开发区', '1', '211381270', null, '3', '1'),
('211381271', '211381', '大黑山特别行政管理区', '1', '211381271', null, '3', '1'),
('211381400', '211381', '兴顺德国营农场', '1', '211381400', null, '3', '1'),
('211382001', '211382', '东城街道', '1', '211382001', null, '3', '1'),
('211382002', '211382', '北街街道', '1', '211382002', null, '3', '1'),
('211382003', '211382', '南街街道', '1', '211382003', null, '3', '1'),
('211382004', '211382', '红山街道', '1', '211382004', null, '3', '1'),
('211382006', '211382', '热水汤街道', '1', '211382006', null, '3', '1'),
('211382007', '211382', '工业园区街道', '1', '211382007', null, '3', '1'),
('211382101', '211382', '万元店镇', '1', '211382101', null, '3', '1'),
('211382102', '211382', '宋杖子镇', '1', '211382102', null, '3', '1'),
('211382103', '211382', '三十家子镇', '1', '211382103', null, '3', '1'),
('211382104', '211382', '杨杖子镇', '1', '211382104', null, '3', '1'),
('211382105', '211382', '刀尔登镇', '1', '211382105', null, '3', '1'),
('211382106', '211382', '松岭子镇', '1', '211382106', null, '3', '1'),
('211382107', '211382', '四官营子镇', '1', '211382107', null, '3', '1'),
('211382108', '211382', '沟门子镇', '1', '211382108', null, '3', '1'),
('211382109', '211382', '凌北镇', '1', '211382109', null, '3', '1'),
('211382110', '211382', '小城子镇', '1', '211382110', null, '3', '1'),
('211382111', '211382', '四合当镇', '1', '211382111', null, '3', '1'),
('211382112', '211382', '城关镇', '1', '211382112', null, '3', '1'),
('211382113', '211382', '乌兰白镇', '1', '211382113', null, '3', '1'),
('211382204', '211382', '大王杖子乡', '1', '211382204', null, '3', '1'),
('211382205', '211382', '刘杖子乡', '1', '211382205', null, '3', '1'),
('211382206', '211382', '前进乡', '1', '211382206', null, '3', '1'),
('211382207', '211382', '大河北乡', '1', '211382207', null, '3', '1'),
('211382208', '211382', '三道河子乡', '1', '211382208', null, '3', '1'),
('211382209', '211382', '牛营子乡', '1', '211382209', null, '3', '1'),
('211382210', '211382', '北炉乡', '1', '211382210', null, '3', '1'),
('211382211', '211382', '瓦房店乡', '1', '211382211', null, '3', '1'),
('211382217', '211382', '三家子乡', '1', '211382217', null, '3', '1'),
('211382219', '211382', '佛爷洞乡', '1', '211382219', null, '3', '1'),
('211382220', '211382', '河坎子乡', '1', '211382220', null, '3', '1'),
('211402001', '211402', '连山街道', '1', '211402001', null, '3', '1'),
('211402002', '211402', '站前街道', '1', '211402002', null, '3', '1'),
('211402003', '211402', '渤海街道', '1', '211402003', null, '3', '1'),
('211402004', '211402', '兴工街道', '1', '211402004', null, '3', '1'),
('211402005', '211402', '石油街道', '1', '211402005', null, '3', '1'),
('211402006', '211402', '化工街道', '1', '211402006', null, '3', '1'),
('211402007', '211402', '化机街道', '1', '211402007', null, '3', '1'),
('211402008', '211402', '水泥街道', '1', '211402008', null, '3', '1'),
('211402010', '211402', '杨家杖子街道', '1', '211402010', null, '3', '1'),
('211402011', '211402', '锦郊街道', '1', '211402011', null, '3', '1'),
('211402102', '211402', '虹螺岘镇', '1', '211402102', null, '3', '1'),
('211402103', '211402', '高桥镇', '1', '211402103', null, '3', '1'),
('211402104', '211402', '钢屯镇', '1', '211402104', null, '3', '1'),
('211402105', '211402', '寺儿堡镇', '1', '211402105', null, '3', '1'),
('211402106', '211402', '新台门蒙古族镇', '1', '211402106', null, '3', '1'),
('211402107', '211402', '金星镇', '1', '211402107', null, '3', '1'),
('211402108', '211402', '台集屯镇', '1', '211402108', null, '3', '1'),
('211402201', '211402', '沙河营乡', '1', '211402201', null, '3', '1'),
('211402202', '211402', '孤竹营子乡', '1', '211402202', null, '3', '1'),
('211402203', '211402', '白马石乡', '1', '211402203', null, '3', '1'),
('211402205', '211402', '山神庙子乡', '1', '211402205', null, '3', '1'),
('211402206', '211402', '塔山乡', '1', '211402206', null, '3', '1'),
('211402209', '211402', '张相公屯乡', '1', '211402209', null, '3', '1'),
('211402210', '211402', '杨郊乡', '1', '211402210', null, '3', '1'),
('211402212', '211402', '大兴乡', '1', '211402212', null, '3', '1'),
('211403001', '211403', '葫芦岛街道', '1', '211403001', null, '3', '1'),
('211403002', '211403', '东街道', '1', '211403002', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('211403003', '211403', '西街道', '1', '211403003', null, '3', '1'),
('211403004', '211403', '望海寺街道', '1', '211403004', null, '3', '1'),
('211403005', '211403', '龙湾街道', '1', '211403005', null, '3', '1'),
('211403006', '211403', '滨海街道', '1', '211403006', null, '3', '1'),
('211403007', '211403', '双龙街道', '1', '211403007', null, '3', '1'),
('211403008', '211403', '玉皇街道', '1', '211403008', null, '3', '1'),
('211403009', '211403', '连湾街道', '1', '211403009', null, '3', '1'),
('211403010', '211403', '北港街道', '1', '211403010', null, '3', '1'),
('211403103', '211403', '双树镇', '1', '211403103', null, '3', '1'),
('211403400', '211403', '葫芦岛经济开发区', '1', '211403400', null, '3', '1'),
('211403401', '211403', '葫芦岛市专利技术园区', '1', '211403401', null, '3', '1'),
('211404001', '211404', '赵家屯街道', '1', '211404001', null, '3', '1'),
('211404002', '211404', '沙锅屯街道', '1', '211404002', null, '3', '1'),
('211404003', '211404', '邱皮沟街道', '1', '211404003', null, '3', '1'),
('211404005', '211404', '苇子沟街道', '1', '211404005', null, '3', '1'),
('211404006', '211404', '三家子街道', '1', '211404006', null, '3', '1'),
('211404007', '211404', '小凌河街道', '1', '211404007', null, '3', '1'),
('211404008', '211404', '九龙街道', '1', '211404008', null, '3', '1'),
('211404101', '211404', '缸窑岭镇', '1', '211404101', null, '3', '1'),
('211404102', '211404', '暖池塘镇', '1', '211404102', null, '3', '1'),
('211404201', '211404', '沙锅屯乡', '1', '211404201', null, '3', '1'),
('211404203', '211404', '黄土坎乡', '1', '211404203', null, '3', '1'),
('211404400', '211404', '乌金塘水库', '1', '211404400', null, '3', '1'),
('211421100', '211421', '绥中镇', '1', '211421100', null, '3', '1'),
('211421101', '211421', '西甸子镇', '1', '211421101', null, '3', '1'),
('211421102', '211421', '宽帮满族镇', '1', '211421102', null, '3', '1'),
('211421103', '211421', '大王庙满族镇', '1', '211421103', null, '3', '1'),
('211421104', '211421', '万家镇', '1', '211421104', null, '3', '1'),
('211421105', '211421', '前所镇', '1', '211421105', null, '3', '1'),
('211421106', '211421', '高岭镇', '1', '211421106', null, '3', '1'),
('211421107', '211421', '前卫镇', '1', '211421107', null, '3', '1'),
('211421108', '211421', '荒地满族镇', '1', '211421108', null, '3', '1'),
('211421109', '211421', '塔山屯镇', '1', '211421109', null, '3', '1'),
('211421113', '211421', '高台镇', '1', '211421113', null, '3', '1'),
('211421114', '211421', '王宝镇', '1', '211421114', null, '3', '1'),
('211421115', '211421', '沙河镇', '1', '211421115', null, '3', '1'),
('211421116', '211421', '小庄子镇', '1', '211421116', null, '3', '1'),
('211421201', '211421', '西平坡满族乡', '1', '211421201', null, '3', '1'),
('211421202', '211421', '葛家满族乡', '1', '211421202', null, '3', '1'),
('211421204', '211421', '高甸子满族乡', '1', '211421204', null, '3', '1'),
('211421206', '211421', '范家满族乡', '1', '211421206', null, '3', '1'),
('211421207', '211421', '明水满族乡', '1', '211421207', null, '3', '1'),
('211421208', '211421', '秋子沟乡', '1', '211421208', null, '3', '1'),
('211421210', '211421', '加碑岩乡', '1', '211421210', null, '3', '1'),
('211421211', '211421', '永安堡乡', '1', '211421211', null, '3', '1'),
('211421212', '211421', '李家堡乡', '1', '211421212', null, '3', '1'),
('211421214', '211421', '网户满族乡', '1', '211421214', null, '3', '1'),
('211421217', '211421', '城郊乡', '1', '211421217', null, '3', '1'),
('211421400', '211421', '大台山果树农场', '1', '211421400', null, '3', '1'),
('211421401', '211421', '前所果树农场', '1', '211421401', null, '3', '1'),
('211422100', '211422', '建昌镇', '1', '211422100', null, '3', '1'),
('211422101', '211422', '八家子镇', '1', '211422101', null, '3', '1'),
('211422102', '211422', '喇嘛洞镇', '1', '211422102', null, '3', '1'),
('211422103', '211422', '药王庙镇', '1', '211422103', null, '3', '1'),
('211422104', '211422', '汤神庙镇', '1', '211422104', null, '3', '1'),
('211422105', '211422', '玲珑塔镇', '1', '211422105', null, '3', '1'),
('211422106', '211422', '大屯镇', '1', '211422106', null, '3', '1'),
('211422201', '211422', '牛亡牛营子乡', '1', '211422201', null, '3', '1'),
('211422203', '211422', '素珠营子乡', '1', '211422203', null, '3', '1'),
('211422204', '211422', '石佛乡', '1', '211422204', null, '3', '1'),
('211422206', '211422', '王宝营子乡', '1', '211422206', null, '3', '1'),
('211422207', '211422', '老达杖子乡', '1', '211422207', null, '3', '1'),
('211422208', '211422', '要路沟乡', '1', '211422208', null, '3', '1'),
('211422209', '211422', '魏家岭乡', '1', '211422209', null, '3', '1'),
('211422210', '211422', '西碱厂乡', '1', '211422210', null, '3', '1'),
('211422211', '211422', '头道营子乡', '1', '211422211', null, '3', '1'),
('211422212', '211422', '新开岭乡', '1', '211422212', null, '3', '1'),
('211422213', '211422', '贺杖子乡', '1', '211422213', null, '3', '1'),
('211422214', '211422', '养马甸子乡', '1', '211422214', null, '3', '1'),
('211422215', '211422', '和尚房子乡', '1', '211422215', null, '3', '1'),
('211422218', '211422', '杨树湾子乡', '1', '211422218', null, '3', '1'),
('211422219', '211422', '黑山科乡', '1', '211422219', null, '3', '1'),
('211422220', '211422', '雷家店乡', '1', '211422220', null, '3', '1'),
('211422222', '211422', '小德营子乡', '1', '211422222', null, '3', '1'),
('211422223', '211422', '二道湾子蒙古族乡', '1', '211422223', null, '3', '1'),
('211422224', '211422', '巴什罕乡', '1', '211422224', null, '3', '1'),
('211422225', '211422', '娘娘庙乡', '1', '211422225', null, '3', '1'),
('211422226', '211422', '谷杖子乡', '1', '211422226', null, '3', '1'),
('211481001', '211481', '古城街道', '1', '211481001', null, '3', '1'),
('211481002', '211481', '宁远街道', '1', '211481002', null, '3', '1'),
('211481003', '211481', '城东街道', '1', '211481003', null, '3', '1'),
('211481004', '211481', '温泉街道', '1', '211481004', null, '3', '1'),
('211481005', '211481', '钓鱼台街道', '1', '211481005', null, '3', '1'),
('211481006', '211481', '华山街道', '1', '211481006', null, '3', '1'),
('211481007', '211481', '四家屯街道', '1', '211481007', null, '3', '1'),
('211481101', '211481', '曹庄镇', '1', '211481101', null, '3', '1'),
('211481103', '211481', '沙后所满族镇', '1', '211481103', null, '3', '1'),
('211481104', '211481', '东辛庄满族镇', '1', '211481104', null, '3', '1'),
('211481105', '211481', '郭家满族镇', '1', '211481105', null, '3', '1'),
('211481201', '211481', '羊安满族乡', '1', '211481201', null, '3', '1'),
('211481203', '211481', '元台子满族乡', '1', '211481203', null, '3', '1'),
('211481204', '211481', '白塔满族乡', '1', '211481204', null, '3', '1'),
('211481206', '211481', '望海满族乡', '1', '211481206', null, '3', '1'),
('211481207', '211481', '刘台子满族乡', '1', '211481207', null, '3', '1'),
('211481208', '211481', '大寨满族乡', '1', '211481208', null, '3', '1'),
('211481209', '211481', '南大山满族乡', '1', '211481209', null, '3', '1'),
('211481210', '211481', '围屏满族乡', '1', '211481210', null, '3', '1'),
('211481211', '211481', '高家岭满族乡', '1', '211481211', null, '3', '1'),
('211481212', '211481', '碱厂满族乡', '1', '211481212', null, '3', '1'),
('211481213', '211481', '三道沟满族乡', '1', '211481213', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('211481214', '211481', '红崖子满族乡', '1', '211481214', null, '3', '1'),
('211481215', '211481', '旧门满族乡', '1', '211481215', null, '3', '1'),
('211481216', '211481', '药王满族乡', '1', '211481216', null, '3', '1'),
('211481218', '211481', '海滨满族乡', '1', '211481218', null, '3', '1'),
('211481219', '211481', '菊花岛乡', '1', '211481219', null, '3', '1'),
('220102001', '220102', '南岭街道', '1', '220102001', null, '3', '1'),
('220102002', '220102', '自强街道', '1', '220102002', null, '3', '1'),
('220102003', '220102', '民康街道', '1', '220102003', null, '3', '1'),
('220102004', '220102', '新春街道', '1', '220102004', null, '3', '1'),
('220102005', '220102', '长通街道', '1', '220102005', null, '3', '1'),
('220102006', '220102', '全安街道', '1', '220102006', null, '3', '1'),
('220102007', '220102', '曙光街道', '1', '220102007', null, '3', '1'),
('220102008', '220102', '永吉街道', '1', '220102008', null, '3', '1'),
('220102009', '220102', '桃源街道', '1', '220102009', null, '3', '1'),
('220102010', '220102', '鸿城街道', '1', '220102010', null, '3', '1'),
('220102070', '220102', '临河街道办事处（长春经济技术开发区）（国', '1', '220102070', null, '3', '1'),
('220102071', '220102', '永兴街道办事处（净月潭旅游经济开发区）（', '1', '220102071', null, '3', '1'),
('220102072', '220102', '净月街道办事处（净月潭旅游经济开发区）（', '1', '220102072', null, '3', '1'),
('220102170', '220102', '新立城镇（净月潭旅游经济开发区）（省级）', '1', '220102170', null, '3', '1'),
('220102171', '220102', '新湖镇（净月潭旅游经济开发区）（省级）', '1', '220102171', null, '3', '1'),
('220102172', '220102', '玉潭镇（净月潭旅游经济开发区）（省级）', '1', '220102172', null, '3', '1'),
('220102200', '220102', '幸福乡', '1', '220102200', null, '3', '1'),
('220103001', '220103', '新发街道', '1', '220103001', null, '3', '1'),
('220103002', '220103', '站前街道', '1', '220103002', null, '3', '1'),
('220103003', '220103', '南广街道', '1', '220103003', null, '3', '1'),
('220103004', '220103', '东广街道', '1', '220103004', null, '3', '1'),
('220103005', '220103', '群英街道', '1', '220103005', null, '3', '1'),
('220103006', '220103', '兴业街道', '1', '220103006', null, '3', '1'),
('220103007', '220103', '凯旋街道', '1', '220103007', null, '3', '1'),
('220103008', '220103', '团山街道', '1', '220103008', null, '3', '1'),
('220103009', '220103', '柳影街道', '1', '220103009', null, '3', '1'),
('220103100', '220103', '兰家镇', '1', '220103100', null, '3', '1'),
('220103101', '220103', '米沙子镇', '1', '220103101', null, '3', '1'),
('220103102', '220103', '万宝镇', '1', '220103102', null, '3', '1'),
('220103170', '220103', '兴隆山镇（长春经济技术开发区）（国家级）', '1', '220103170', null, '3', '1'),
('220103171', '220103', '合隆镇（合隆经济开发区）（省级）', '1', '220103171', null, '3', '1'),
('220103200', '220103', '奋进乡', '1', '220103200', null, '3', '1'),
('220103400', '220103', '兴业农场', '1', '220103400', null, '3', '1'),
('220104001', '220104', '南站街道', '1', '220104001', null, '3', '1'),
('220104002', '220104', '桂林街道', '1', '220104002', null, '3', '1'),
('220104003', '220104', '南湖街道', '1', '220104003', null, '3', '1'),
('220104004', '220104', '永昌街道', '1', '220104004', null, '3', '1'),
('220104005', '220104', '重庆街道', '1', '220104005', null, '3', '1'),
('220104006', '220104', '清和街道', '1', '220104006', null, '3', '1'),
('220104007', '220104', '红旗街道', '1', '220104007', null, '3', '1'),
('220104008', '220104', '湖西街道', '1', '220104008', null, '3', '1'),
('220104009', '220104', '富锋街道', '1', '220104009', null, '3', '1'),
('220104100', '220104', '乐山镇', '1', '220104100', null, '3', '1'),
('220104101', '220104', '永春镇', '1', '220104101', null, '3', '1'),
('220104270', '220104', '双德乡（长春高新技术产业开发区）（国家级', '1', '220104270', null, '3', '1'),
('220105001', '220105', '东盛街道', '1', '220105001', null, '3', '1'),
('220105002', '220105', '吉林街道', '1', '220105002', null, '3', '1'),
('220105003', '220105', '荣光街道', '1', '220105003', null, '3', '1'),
('220105004', '220105', '东站街道', '1', '220105004', null, '3', '1'),
('220105005', '220105', '远达街道', '1', '220105005', null, '3', '1'),
('220105006', '220105', '八里堡街道', '1', '220105006', null, '3', '1'),
('220105070', '220105', '东方广场街道办事处（长春经济技术开发区）', '1', '220105070', null, '3', '1'),
('220105100', '220105', '英俊镇', '1', '220105100', null, '3', '1'),
('220105101', '220105', '劝农山镇', '1', '220105101', null, '3', '1'),
('220105102', '220105', '泉眼镇', '1', '220105102', null, '3', '1'),
('220105170', '220105', '龙嘉镇（东湖生态经济开发区）（省级）', '1', '220105170', null, '3', '1'),
('220105171', '220105', '卡伦湖镇（东湖生态经济开发区）（省级）', '1', '220105171', null, '3', '1'),
('220105172', '220105', '东湖镇（东湖生态经济开发区）（省级）', '1', '220105172', null, '3', '1'),
('220105200', '220105', '四家乡', '1', '220105200', null, '3', '1'),
('220106001', '220106', '正阳街道', '1', '220106001', null, '3', '1'),
('220106002', '220106', '普阳街道', '1', '220106002', null, '3', '1'),
('220106003', '220106', '春城街道', '1', '220106003', null, '3', '1'),
('220106004', '220106', '铁西街道', '1', '220106004', null, '3', '1'),
('220106005', '220106', '青年街道', '1', '220106005', null, '3', '1'),
('220106070', '220106', '锦程街道办事处（长春汽车产业开发区）（省', '1', '220106070', null, '3', '1'),
('220106071', '220106', '东风街道办事处（长春汽车产业开发区）（省', '1', '220106071', null, '3', '1'),
('220106100', '220106', '合心镇', '1', '220106100', null, '3', '1'),
('220106101', '220106', '西新镇', '1', '220106101', null, '3', '1'),
('220106102', '220106', '城西镇', '1', '220106102', null, '3', '1'),
('220106170', '220106', '长春汽车产业开发区（省级）', '1', '220106170', null, '3', '1'),
('220106171', '220106', '绿园经济开发区（省级）', '1', '220106171', null, '3', '1'),
('220112001', '220112', '云山街道', '1', '220112001', null, '3', '1'),
('220112002', '220112', '平湖街道', '1', '220112002', null, '3', '1'),
('220112003', '220112', '奢岭街道', '1', '220112003', null, '3', '1'),
('220112004', '220112', '山河街道', '1', '220112004', null, '3', '1'),
('220112100', '220112', '齐家镇', '1', '220112100', null, '3', '1'),
('220112101', '220112', '太平镇', '1', '220112101', null, '3', '1'),
('220112102', '220112', '鹿乡镇', '1', '220112102', null, '3', '1'),
('220112270', '220112', '双营乡（梅花鹿产业经济开发区）（省级）', '1', '220112270', null, '3', '1'),
('220122100', '220122', '农安镇', '1', '220122100', null, '3', '1'),
('220122101', '220122', '伏龙泉镇', '1', '220122101', null, '3', '1'),
('220122102', '220122', '哈拉海镇', '1', '220122102', null, '3', '1'),
('220122103', '220122', '靠山镇', '1', '220122103', null, '3', '1'),
('220122104', '220122', '开安镇', '1', '220122104', null, '3', '1'),
('220122105', '220122', '烧锅镇', '1', '220122105', null, '3', '1'),
('220122106', '220122', '高家店镇', '1', '220122106', null, '3', '1'),
('220122107', '220122', '华家镇', '1', '220122107', null, '3', '1'),
('220122108', '220122', '三盛玉镇', '1', '220122108', null, '3', '1'),
('220122109', '220122', '巴吉垒镇', '1', '220122109', null, '3', '1'),
('220122200', '220122', '前岗乡', '1', '220122200', null, '3', '1'),
('220122201', '220122', '龙王乡', '1', '220122201', null, '3', '1'),
('220122202', '220122', '三岗乡', '1', '220122202', null, '3', '1'),
('220122203', '220122', '万顺乡', '1', '220122203', null, '3', '1'),
('220122204', '220122', '杨树林乡', '1', '220122204', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('220122205', '220122', '永安乡', '1', '220122205', null, '3', '1'),
('220122206', '220122', '青山口乡', '1', '220122206', null, '3', '1'),
('220122207', '220122', '黄鱼圈乡', '1', '220122207', null, '3', '1'),
('220122208', '220122', '新农乡', '1', '220122208', null, '3', '1'),
('220122209', '220122', '万金塔乡', '1', '220122209', null, '3', '1'),
('220122210', '220122', '小城子乡', '1', '220122210', null, '3', '1'),
('220122400', '220122', '洼中高农场', '1', '220122400', null, '3', '1'),
('220181001', '220181', '九台街道', '1', '220181001', null, '3', '1'),
('220181002', '220181', '营城街道', '1', '220181002', null, '3', '1'),
('220181003', '220181', '九郊街道', '1', '220181003', null, '3', '1'),
('220181100', '220181', '沐石河镇', '1', '220181100', null, '3', '1'),
('220181101', '220181', '城子街镇', '1', '220181101', null, '3', '1'),
('220181102', '220181', '其塔木镇', '1', '220181102', null, '3', '1'),
('220181103', '220181', '上河湾镇', '1', '220181103', null, '3', '1'),
('220181104', '220181', '西营城镇', '1', '220181104', null, '3', '1'),
('220181105', '220181', '土们岭镇', '1', '220181105', null, '3', '1'),
('220181106', '220181', '苇子沟镇', '1', '220181106', null, '3', '1'),
('220181107', '220181', '兴隆镇', '1', '220181107', null, '3', '1'),
('220181108', '220181', '纪家镇', '1', '220181108', null, '3', '1'),
('220181109', '220181', '波泥河镇', '1', '220181109', null, '3', '1'),
('220181200', '220181', '胡家回族乡', '1', '220181200', null, '3', '1'),
('220181201', '220181', '莽卡满族乡', '1', '220181201', null, '3', '1'),
('220182001', '220182', '华昌街道', '1', '220182001', null, '3', '1'),
('220182002', '220182', '正阳街道', '1', '220182002', null, '3', '1'),
('220182003', '220182', '培英街道', '1', '220182003', null, '3', '1'),
('220182004', '220182', '城郊街道', '1', '220182004', null, '3', '1'),
('220182100', '220182', '五棵树镇', '1', '220182100', null, '3', '1'),
('220182101', '220182', '弓棚镇', '1', '220182101', null, '3', '1'),
('220182102', '220182', '闵家镇', '1', '220182102', null, '3', '1'),
('220182103', '220182', '大坡镇', '1', '220182103', null, '3', '1'),
('220182104', '220182', '黑林镇', '1', '220182104', null, '3', '1'),
('220182105', '220182', '土桥镇', '1', '220182105', null, '3', '1'),
('220182106', '220182', '新立镇', '1', '220182106', null, '3', '1'),
('220182107', '220182', '大岭镇', '1', '220182107', null, '3', '1'),
('220182108', '220182', '向阳镇', '1', '220182108', null, '3', '1'),
('220182109', '220182', '泗河镇', '1', '220182109', null, '3', '1'),
('220182110', '220182', '八号镇', '1', '220182110', null, '3', '1'),
('220182111', '220182', '刘家镇', '1', '220182111', null, '3', '1'),
('220182112', '220182', '秀水镇', '1', '220182112', null, '3', '1'),
('220182113', '220182', '保寿镇', '1', '220182113', null, '3', '1'),
('220182114', '220182', '新庄镇', '1', '220182114', null, '3', '1'),
('220182200', '220182', '育民乡', '1', '220182200', null, '3', '1'),
('220182201', '220182', '红星乡', '1', '220182201', null, '3', '1'),
('220182202', '220182', '太安乡', '1', '220182202', null, '3', '1'),
('220182203', '220182', '先峰乡', '1', '220182203', null, '3', '1'),
('220182204', '220182', '青山乡', '1', '220182204', null, '3', '1'),
('220182205', '220182', '延和朝鲜族乡', '1', '220182205', null, '3', '1'),
('220182206', '220182', '恩育乡', '1', '220182206', null, '3', '1'),
('220182207', '220182', '城发乡', '1', '220182207', null, '3', '1'),
('220182208', '220182', '环城乡', '1', '220182208', null, '3', '1'),
('220183001', '220183', '胜利街道', '1', '220183001', null, '3', '1'),
('220183002', '220183', '建设街道', '1', '220183002', null, '3', '1'),
('220183003', '220183', '惠发街道', '1', '220183003', null, '3', '1'),
('220183004', '220183', '夏家店街道', '1', '220183004', null, '3', '1'),
('220183100', '220183', '大青嘴镇', '1', '220183100', null, '3', '1'),
('220183101', '220183', '郭家镇', '1', '220183101', null, '3', '1'),
('220183102', '220183', '松花江镇', '1', '220183102', null, '3', '1'),
('220183103', '220183', '达家沟镇', '1', '220183103', null, '3', '1'),
('220183104', '220183', '大房身镇', '1', '220183104', null, '3', '1'),
('220183105', '220183', '岔路口镇', '1', '220183105', null, '3', '1'),
('220183106', '220183', '朱城子镇', '1', '220183106', null, '3', '1'),
('220183107', '220183', '布海镇', '1', '220183107', null, '3', '1'),
('220183108', '220183', '天台镇', '1', '220183108', null, '3', '1'),
('220183109', '220183', '菜园子镇', '1', '220183109', null, '3', '1'),
('220183200', '220183', '同太乡', '1', '220183200', null, '3', '1'),
('220183201', '220183', '边岗乡', '1', '220183201', null, '3', '1'),
('220183202', '220183', '五台乡', '1', '220183202', null, '3', '1'),
('220183203', '220183', '朝阳乡', '1', '220183203', null, '3', '1'),
('220202001', '220202', '兴华街道', '1', '220202001', null, '3', '1'),
('220202002', '220202', '文庙街道', '1', '220202002', null, '3', '1'),
('220202003', '220202', '东局子街道', '1', '220202003', null, '3', '1'),
('220202004', '220202', '新地号街道', '1', '220202004', null, '3', '1'),
('220202005', '220202', '延安街道', '1', '220202005', null, '3', '1'),
('220202006', '220202', '站前街道', '1', '220202006', null, '3', '1'),
('220202007', '220202', '民主街道', '1', '220202007', null, '3', '1'),
('220202008', '220202', '莲花街道', '1', '220202008', null, '3', '1'),
('220202009', '220202', '通江街道', '1', '220202009', null, '3', '1'),
('220202010', '220202', '哈达湾街道', '1', '220202010', null, '3', '1'),
('220202011', '220202', '新建街道', '1', '220202011', null, '3', '1'),
('220202012', '220202', '延江街道', '1', '220202012', null, '3', '1'),
('220202013', '220202', '双吉街道', '1', '220202013', null, '3', '1'),
('220202070', '220202', '九站街道办事处(吉林经济技术开发区)（省', '1', '220202070', null, '3', '1'),
('220202071', '220202', '吉林东市商贸示范区（省级）', '1', '220202071', null, '3', '1'),
('220202100', '220202', '孤店子镇', '1', '220202100', null, '3', '1'),
('220202101', '220202', '桦皮厂镇', '1', '220202101', null, '3', '1'),
('220202102', '220202', '左家镇', '1', '220202102', null, '3', '1'),
('220202200', '220202', '两家子满族乡', '1', '220202200', null, '3', '1'),
('220202201', '220202', '土城子满族朝鲜族乡', '1', '220202201', null, '3', '1'),
('220202400', '220202', '吉林哈达湾工业开发区', '1', '220202400', null, '3', '1'),
('220202401', '220202', '吉林市昌邑区幸福经济管理区', '1', '220202401', null, '3', '1'),
('220203001', '220203', '龙华街道', '1', '220203001', null, '3', '1'),
('220203002', '220203', '湘潭街道', '1', '220203002', null, '3', '1'),
('220203003', '220203', '铁东街道', '1', '220203003', null, '3', '1'),
('220203004', '220203', '泡子沿街道', '1', '220203004', null, '3', '1'),
('220203005', '220203', '龙潭街道', '1', '220203005', null, '3', '1'),
('220203006', '220203', '新吉林街道', '1', '220203006', null, '3', '1'),
('220203007', '220203', '山前街道', '1', '220203007', null, '3', '1'),
('220203008', '220203', '新安街道', '1', '220203008', null, '3', '1'),
('220203009', '220203', '遵义街道', '1', '220203009', null, '3', '1'),
('220203010', '220203', '榆树街道', '1', '220203010', null, '3', '1'),
('220203011', '220203', '靠山街道', '1', '220203011', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('220203012', '220203', '东城街道', '1', '220203012', null, '3', '1'),
('220203013', '220203', '承德街道', '1', '220203013', null, '3', '1'),
('220203070', '220203', '吉林龙潭经济开发区（省级）', '1', '220203070', null, '3', '1'),
('220203100', '220203', '乌拉街镇', '1', '220203100', null, '3', '1'),
('220203101', '220203', '缸窑镇', '1', '220203101', null, '3', '1'),
('220203102', '220203', '江密峰镇', '1', '220203102', null, '3', '1'),
('220203103', '220203', '大口钦镇', '1', '220203103', null, '3', '1'),
('220203200', '220203', '江北乡', '1', '220203200', null, '3', '1'),
('220203201', '220203', '金珠乡', '1', '220203201', null, '3', '1'),
('220204001', '220204', '德胜街道', '1', '220204001', null, '3', '1'),
('220204002', '220204', '南京街道', '1', '220204002', null, '3', '1'),
('220204003', '220204', '大东街道', '1', '220204003', null, '3', '1'),
('220204004', '220204', '青岛街道', '1', '220204004', null, '3', '1'),
('220204005', '220204', '向阳街道', '1', '220204005', null, '3', '1'),
('220204006', '220204', '北极街道', '1', '220204006', null, '3', '1'),
('220204007', '220204', '致和街道', '1', '220204007', null, '3', '1'),
('220204008', '220204', '长春路街道', '1', '220204008', null, '3', '1'),
('220204009', '220204', '临江街道', '1', '220204009', null, '3', '1'),
('220204010', '220204', '北山街道', '1', '220204010', null, '3', '1'),
('220204011', '220204', '黄旗屯街道', '1', '220204011', null, '3', '1'),
('220204100', '220204', '大绥河镇', '1', '220204100', null, '3', '1'),
('220204101', '220204', '搜登站镇', '1', '220204101', null, '3', '1'),
('220204102', '220204', '越北镇', '1', '220204102', null, '3', '1'),
('220204200', '220204', '欢喜乡', '1', '220204200', null, '3', '1'),
('220211001', '220211', '泰山街道', '1', '220211001', null, '3', '1'),
('220211002', '220211', '江南街道', '1', '220211002', null, '3', '1'),
('220211003', '220211', '石井街道', '1', '220211003', null, '3', '1'),
('220211004', '220211', '沿丰街道', '1', '220211004', null, '3', '1'),
('220211005', '220211', '丰满街道', '1', '220211005', null, '3', '1'),
('220211070', '220211', '高新开发区街道办事处（吉林高新技术产业开', '1', '220211070', null, '3', '1'),
('220211071', '220211', '红旗街道办事处（丰满经济开发区）（省级）', '1', '220211071', null, '3', '1'),
('220211100', '220211', '旺起镇', '1', '220211100', null, '3', '1'),
('220211200', '220211', '江南乡', '1', '220211200', null, '3', '1'),
('220211201', '220211', '前二道乡', '1', '220211201', null, '3', '1'),
('220211270', '220211', '小白山乡（丰满经济开发区）（省级）', '1', '220211270', null, '3', '1'),
('220211400', '220211', '朱雀山风景区', '1', '220211400', null, '3', '1'),
('220221100', '220221', '口前镇', '1', '220221100', null, '3', '1'),
('220221101', '220221', '双河镇', '1', '220221101', null, '3', '1'),
('220221102', '220221', '西阳镇', '1', '220221102', null, '3', '1'),
('220221103', '220221', '北大湖镇', '1', '220221103', null, '3', '1'),
('220221104', '220221', '一拉溪镇', '1', '220221104', null, '3', '1'),
('220221170', '220221', '岔路河镇（岔路河特色农业经济开发区）（省', '1', '220221170', null, '3', '1'),
('220221171', '220221', '万昌镇（岔路河特色农业经济开发区）（省级', '1', '220221171', null, '3', '1'),
('220221172', '220221', '永吉经济开发区（省级）', '1', '220221172', null, '3', '1'),
('220221200', '220221', '金家乡', '1', '220221200', null, '3', '1'),
('220221201', '220221', '黄榆乡', '1', '220221201', null, '3', '1'),
('220281001', '220281', '民主街道', '1', '220281001', null, '3', '1'),
('220281002', '220281', '长安街道', '1', '220281002', null, '3', '1'),
('220281003', '220281', '河南街道', '1', '220281003', null, '3', '1'),
('220281004', '220281', '奶子山街道', '1', '220281004', null, '3', '1'),
('220281005', '220281', '拉法街道', '1', '220281005', null, '3', '1'),
('220281006', '220281', '河北街道', '1', '220281006', null, '3', '1'),
('220281007', '220281', '新农街道', '1', '220281007', null, '3', '1'),
('220281100', '220281', '新站镇', '1', '220281100', null, '3', '1'),
('220281101', '220281', '天岗镇', '1', '220281101', null, '3', '1'),
('220281102', '220281', '白石山镇', '1', '220281102', null, '3', '1'),
('220281103', '220281', '漂河镇', '1', '220281103', null, '3', '1'),
('220281104', '220281', '黄松甸镇', '1', '220281104', null, '3', '1'),
('220281105', '220281', '天北镇', '1', '220281105', null, '3', '1'),
('220281106', '220281', '松江镇', '1', '220281106', null, '3', '1'),
('220281107', '220281', '庆岭镇', '1', '220281107', null, '3', '1'),
('220281200', '220281', '乌林朝鲜族乡', '1', '220281200', null, '3', '1'),
('220281201', '220281', '前进乡', '1', '220281201', null, '3', '1'),
('220282001', '220282', '明桦街道', '1', '220282001', null, '3', '1'),
('220282002', '220282', '永吉街道', '1', '220282002', null, '3', '1'),
('220282003', '220282', '胜利街道', '1', '220282003', null, '3', '1'),
('220282004', '220282', '新华街道', '1', '220282004', null, '3', '1'),
('220282005', '220282', '启新街道', '1', '220282005', null, '3', '1'),
('220282070', '220282', '桦甸经济开发区（省级）', '1', '220282070', null, '3', '1'),
('220282100', '220282', '夹皮沟镇', '1', '220282100', null, '3', '1'),
('220282101', '220282', '二道甸子镇', '1', '220282101', null, '3', '1'),
('220282102', '220282', '红石砬子镇', '1', '220282102', null, '3', '1'),
('220282103', '220282', '八道河子镇', '1', '220282103', null, '3', '1'),
('220282104', '220282', '常山镇', '1', '220282104', null, '3', '1'),
('220282200', '220282', '桦郊乡', '1', '220282200', null, '3', '1'),
('220282201', '220282', '横道河子乡', '1', '220282201', null, '3', '1'),
('220282202', '220282', '金沙乡', '1', '220282202', null, '3', '1'),
('220282203', '220282', '桦树林子乡', '1', '220282203', null, '3', '1'),
('220282204', '220282', '公吉乡', '1', '220282204', null, '3', '1'),
('220282205', '220282', '苏密沟乡', '1', '220282205', null, '3', '1'),
('220283001', '220283', '北城街道', '1', '220283001', null, '3', '1'),
('220283002', '220283', '南城街道', '1', '220283002', null, '3', '1'),
('220283003', '220283', '环城街道', '1', '220283003', null, '3', '1'),
('220283004', '220283', '吉舒街道', '1', '220283004', null, '3', '1'),
('220283005', '220283', '铁东街道', '1', '220283005', null, '3', '1'),
('220283100', '220283', '法特镇', '1', '220283100', null, '3', '1'),
('220283101', '220283', '白旗镇', '1', '220283101', null, '3', '1'),
('220283102', '220283', '溪河镇', '1', '220283102', null, '3', '1'),
('220283103', '220283', '朝阳镇', '1', '220283103', null, '3', '1'),
('220283104', '220283', '小城镇', '1', '220283104', null, '3', '1'),
('220283105', '220283', '上营镇', '1', '220283105', null, '3', '1'),
('220283106', '220283', '水曲柳镇', '1', '220283106', null, '3', '1'),
('220283107', '220283', '平安镇', '1', '220283107', null, '3', '1'),
('220283108', '220283', '金马镇', '1', '220283108', null, '3', '1'),
('220283109', '220283', '开原镇', '1', '220283109', null, '3', '1'),
('220283200', '220283', '莲花乡', '1', '220283200', null, '3', '1'),
('220283201', '220283', '亮甲山乡', '1', '220283201', null, '3', '1'),
('220283202', '220283', '新安乡', '1', '220283202', null, '3', '1'),
('220283203', '220283', '七里乡', '1', '220283203', null, '3', '1'),
('220283204', '220283', '天德乡', '1', '220283204', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('220284001', '220284', '福安街道', '1', '220284001', null, '3', '1'),
('220284002', '220284', '东宁街道', '1', '220284002', null, '3', '1'),
('220284003', '220284', '河南街道', '1', '220284003', null, '3', '1'),
('220284070', '220284', '磐石经济开发区（省级）', '1', '220284070', null, '3', '1'),
('220284100', '220284', '烟筒山镇', '1', '220284100', null, '3', '1'),
('220284101', '220284', '红旗岭镇', '1', '220284101', null, '3', '1'),
('220284102', '220284', '明城镇', '1', '220284102', null, '3', '1'),
('220284103', '220284', '石嘴镇', '1', '220284103', null, '3', '1'),
('220284104', '220284', '驿马镇', '1', '220284104', null, '3', '1'),
('220284105', '220284', '牛心镇', '1', '220284105', null, '3', '1'),
('220284106', '220284', '呼兰镇', '1', '220284106', null, '3', '1'),
('220284107', '220284', '吉昌镇', '1', '220284107', null, '3', '1'),
('220284108', '220284', '松山镇', '1', '220284108', null, '3', '1'),
('220284109', '220284', '黑石镇', '1', '220284109', null, '3', '1'),
('220284110', '220284', '朝阳山镇', '1', '220284110', null, '3', '1'),
('220284111', '220284', '富太镇', '1', '220284111', null, '3', '1'),
('220284112', '220284', '取柴河镇', '1', '220284112', null, '3', '1'),
('220284200', '220284', '宝山乡', '1', '220284200', null, '3', '1'),
('220302001', '220302', '仁兴街道', '1', '220302001', null, '3', '1'),
('220302002', '220302', '英雄街道', '1', '220302002', null, '3', '1'),
('220302003', '220302', '站前街道', '1', '220302003', null, '3', '1'),
('220302004', '220302', '北沟街道', '1', '220302004', null, '3', '1'),
('220302005', '220302', '地直街道', '1', '220302005', null, '3', '1'),
('220302070', '220302', '红嘴高新技术开发区（省级）', '1', '220302070', null, '3', '1'),
('220302200', '220302', '平西乡', '1', '220302200', null, '3', '1'),
('220303001', '220303', '平东街道', '1', '220303001', null, '3', '1'),
('220303002', '220303', '北市场街道', '1', '220303002', null, '3', '1'),
('220303003', '220303', '七马路街道', '1', '220303003', null, '3', '1'),
('220303004', '220303', '四马路街道', '1', '220303004', null, '3', '1'),
('220303005', '220303', '解放街道', '1', '220303005', null, '3', '1'),
('220303006', '220303', '北门街道', '1', '220303006', null, '3', '1'),
('220303007', '220303', '黄土坑街道', '1', '220303007', null, '3', '1'),
('220303008', '220303', '平南街道', '1', '220303008', null, '3', '1'),
('220303100', '220303', '山门镇', '1', '220303100', null, '3', '1'),
('220303101', '220303', '石岭镇', '1', '220303101', null, '3', '1'),
('220303102', '220303', '叶赫满族镇', '1', '220303102', null, '3', '1'),
('220303170', '220303', '四平经济开发区（省级）', '1', '220303170', null, '3', '1'),
('220303200', '220303', '城东乡', '1', '220303200', null, '3', '1'),
('220322100', '220322', '梨树镇', '1', '220322100', null, '3', '1'),
('220322101', '220322', '郭家店镇', '1', '220322101', null, '3', '1'),
('220322102', '220322', '榆树台镇', '1', '220322102', null, '3', '1'),
('220322103', '220322', '孤家子镇（四平辽河农垦管理区）', '1', '220322103', null, '3', '1'),
('220322104', '220322', '小城子镇', '1', '220322104', null, '3', '1'),
('220322105', '220322', '喇嘛甸镇', '1', '220322105', null, '3', '1'),
('220322106', '220322', '蔡家镇', '1', '220322106', null, '3', '1'),
('220322107', '220322', '刘家馆子镇', '1', '220322107', null, '3', '1'),
('220322108', '220322', '十家堡镇', '1', '220322108', null, '3', '1'),
('220322109', '220322', '孟家岭镇', '1', '220322109', null, '3', '1'),
('220322110', '220322', '万发镇', '1', '220322110', null, '3', '1'),
('220322111', '220322', '东河镇', '1', '220322111', null, '3', '1'),
('220322112', '220322', '沈洋镇', '1', '220322112', null, '3', '1'),
('220322113', '220322', '林海镇', '1', '220322113', null, '3', '1'),
('220322114', '220322', '小宽镇', '1', '220322114', null, '3', '1'),
('220322200', '220322', '白山乡', '1', '220322200', null, '3', '1'),
('220322201', '220322', '泉眼岭乡', '1', '220322201', null, '3', '1'),
('220322202', '220322', '胜利乡', '1', '220322202', null, '3', '1'),
('220322203', '220322', '四棵树乡', '1', '220322203', null, '3', '1'),
('220322204', '220322', '双河乡', '1', '220322204', null, '3', '1'),
('220322205', '220322', '金山乡', '1', '220322205', null, '3', '1'),
('220322400', '220322', '国营梨树农场（四平辽河农垦管理区）', '1', '220322400', null, '3', '1'),
('220322401', '220322', '梨树经济开发区', '1', '220322401', null, '3', '1'),
('220323100', '220323', '伊通镇', '1', '220323100', null, '3', '1'),
('220323101', '220323', '二道镇', '1', '220323101', null, '3', '1'),
('220323102', '220323', '伊丹镇', '1', '220323102', null, '3', '1'),
('220323103', '220323', '马鞍镇', '1', '220323103', null, '3', '1'),
('220323104', '220323', '景台镇', '1', '220323104', null, '3', '1'),
('220323105', '220323', '靠山镇', '1', '220323105', null, '3', '1'),
('220323106', '220323', '大孤山镇', '1', '220323106', null, '3', '1'),
('220323107', '220323', '小孤山镇', '1', '220323107', null, '3', '1'),
('220323108', '220323', '营城子镇', '1', '220323108', null, '3', '1'),
('220323109', '220323', '西苇镇', '1', '220323109', null, '3', '1'),
('220323110', '220323', '河源镇', '1', '220323110', null, '3', '1'),
('220323111', '220323', '黄岭子镇', '1', '220323111', null, '3', '1'),
('220323200', '220323', '新兴乡', '1', '220323200', null, '3', '1'),
('220323201', '220323', '莫里乡', '1', '220323201', null, '3', '1'),
('220323202', '220323', '三道乡', '1', '220323202', null, '3', '1'),
('220323400', '220323', '伊通经济开发区', '1', '220323400', null, '3', '1'),
('220381001', '220381', '河南街道', '1', '220381001', null, '3', '1'),
('220381002', '220381', '河北街道', '1', '220381002', null, '3', '1'),
('220381003', '220381', '东三街道', '1', '220381003', null, '3', '1'),
('220381004', '220381', '岭东街道', '1', '220381004', null, '3', '1'),
('220381005', '220381', '铁北街道', '1', '220381005', null, '3', '1'),
('220381006', '220381', '岭西街道', '1', '220381006', null, '3', '1'),
('220381007', '220381', '刘房子街道', '1', '220381007', null, '3', '1'),
('220381008', '220381', '南崴子街道', '1', '220381008', null, '3', '1'),
('220381009', '220381', '环岭街道', '1', '220381009', null, '3', '1'),
('220381010', '220381', '苇子沟街道', '1', '220381010', null, '3', '1'),
('220381100', '220381', '二十家子镇', '1', '220381100', null, '3', '1'),
('220381101', '220381', '黑林子镇', '1', '220381101', null, '3', '1'),
('220381102', '220381', '陶家屯镇', '1', '220381102', null, '3', '1'),
('220381103', '220381', '范家屯镇', '1', '220381103', null, '3', '1'),
('220381104', '220381', '响水镇', '1', '220381104', null, '3', '1'),
('220381105', '220381', '大岭镇', '1', '220381105', null, '3', '1'),
('220381106', '220381', '怀德镇', '1', '220381106', null, '3', '1'),
('220381107', '220381', '双城堡镇', '1', '220381107', null, '3', '1'),
('220381108', '220381', '双龙镇', '1', '220381108', null, '3', '1'),
('220381109', '220381', '杨大城子镇', '1', '220381109', null, '3', '1'),
('220381110', '220381', '毛城子镇', '1', '220381110', null, '3', '1'),
('220381111', '220381', '玻璃城子镇', '1', '220381111', null, '3', '1'),
('220381112', '220381', '朝阳坡镇', '1', '220381112', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('220381113', '220381', '大榆树镇', '1', '220381113', null, '3', '1'),
('220381114', '220381', '秦家屯镇', '1', '220381114', null, '3', '1'),
('220381115', '220381', '八屋镇', '1', '220381115', null, '3', '1'),
('220381116', '220381', '十屋镇', '1', '220381116', null, '3', '1'),
('220381117', '220381', '桑树台镇', '1', '220381117', null, '3', '1'),
('220381200', '220381', '龙山乡', '1', '220381200', null, '3', '1'),
('220381201', '220381', '永发乡', '1', '220381201', null, '3', '1'),
('220382001', '220382', '郑家屯街道', '1', '220382001', null, '3', '1'),
('220382002', '220382', '辽西街道', '1', '220382002', null, '3', '1'),
('220382003', '220382', '辽南街道', '1', '220382003', null, '3', '1'),
('220382004', '220382', '辽北街道', '1', '220382004', null, '3', '1'),
('220382005', '220382', '辽东街道', '1', '220382005', null, '3', '1'),
('220382006', '220382', '红旗街道', '1', '220382006', null, '3', '1'),
('220382100', '220382', '茂林镇', '1', '220382100', null, '3', '1'),
('220382101', '220382', '双山镇', '1', '220382101', null, '3', '1'),
('220382102', '220382', '卧虎镇', '1', '220382102', null, '3', '1'),
('220382103', '220382', '服先镇', '1', '220382103', null, '3', '1'),
('220382104', '220382', '王奔镇', '1', '220382104', null, '3', '1'),
('220382105', '220382', '玻璃山镇', '1', '220382105', null, '3', '1'),
('220382106', '220382', '兴隆镇', '1', '220382106', null, '3', '1'),
('220382107', '220382', '东明镇', '1', '220382107', null, '3', '1'),
('220382200', '220382', '那木乡', '1', '220382200', null, '3', '1'),
('220382201', '220382', '柳条乡', '1', '220382201', null, '3', '1'),
('220382202', '220382', '新立乡', '1', '220382202', null, '3', '1'),
('220382203', '220382', '永加乡', '1', '220382203', null, '3', '1'),
('220382400', '220382', '双辽农场（四平辽河农垦管理区）', '1', '220382400', null, '3', '1'),
('220382401', '220382', '双辽种羊场（四平辽河农垦管理区）', '1', '220382401', null, '3', '1'),
('220382402', '220382', '双辽经济开发区', '1', '220382402', null, '3', '1'),
('220402001', '220402', '南康街道', '1', '220402001', null, '3', '1'),
('220402002', '220402', '北寿街道', '1', '220402002', null, '3', '1'),
('220402003', '220402', '东吉街道', '1', '220402003', null, '3', '1'),
('220402004', '220402', '西宁街道', '1', '220402004', null, '3', '1'),
('220402005', '220402', '站前街道', '1', '220402005', null, '3', '1'),
('220402006', '220402', '新兴街道', '1', '220402006', null, '3', '1'),
('220402007', '220402', '福镇街道', '1', '220402007', null, '3', '1'),
('220402008', '220402', '向阳街道', '1', '220402008', null, '3', '1'),
('220402070', '220402', '辽源民营经济开发区（省级）', '1', '220402070', null, '3', '1'),
('220402100', '220402', '寿山镇', '1', '220402100', null, '3', '1'),
('220402200', '220402', '工农乡', '1', '220402200', null, '3', '1'),
('220403001', '220403', '仙城街道', '1', '220403001', null, '3', '1'),
('220403002', '220403', '太安街道', '1', '220403002', null, '3', '1'),
('220403003', '220403', '东山街道', '1', '220403003', null, '3', '1'),
('220403004', '220403', '安家街道', '1', '220403004', null, '3', '1'),
('220403005', '220403', '先锋街道', '1', '220403005', null, '3', '1'),
('220403006', '220403', '富国街道', '1', '220403006', null, '3', '1'),
('220403200', '220403', '灯塔乡', '1', '220403200', null, '3', '1'),
('220421100', '220421', '东丰镇', '1', '220421100', null, '3', '1'),
('220421101', '220421', '大阳镇', '1', '220421101', null, '3', '1'),
('220421102', '220421', '横道河镇', '1', '220421102', null, '3', '1'),
('220421103', '220421', '那丹伯镇', '1', '220421103', null, '3', '1'),
('220421104', '220421', '猴石镇', '1', '220421104', null, '3', '1'),
('220421105', '220421', '杨木林镇', '1', '220421105', null, '3', '1'),
('220421106', '220421', '小四平镇', '1', '220421106', null, '3', '1'),
('220421107', '220421', '黄河镇', '1', '220421107', null, '3', '1'),
('220421108', '220421', '拉拉河镇', '1', '220421108', null, '3', '1'),
('220421109', '220421', '沙河镇', '1', '220421109', null, '3', '1'),
('220421110', '220421', '南屯基镇', '1', '220421110', null, '3', '1'),
('220421111', '220421', '大兴镇', '1', '220421111', null, '3', '1'),
('220421200', '220421', '三合满族朝鲜族乡', '1', '220421200', null, '3', '1'),
('220421201', '220421', '二龙山乡', '1', '220421201', null, '3', '1'),
('220422100', '220422', '白泉镇', '1', '220422100', null, '3', '1'),
('220422101', '220422', '渭津镇', '1', '220422101', null, '3', '1'),
('220422102', '220422', '安石镇', '1', '220422102', null, '3', '1'),
('220422103', '220422', '辽河源镇', '1', '220422103', null, '3', '1'),
('220422104', '220422', '泉太镇', '1', '220422104', null, '3', '1'),
('220422105', '220422', '建安镇', '1', '220422105', null, '3', '1'),
('220422106', '220422', '安恕镇', '1', '220422106', null, '3', '1'),
('220422107', '220422', '平岗镇', '1', '220422107', null, '3', '1'),
('220422108', '220422', '云顶镇', '1', '220422108', null, '3', '1'),
('220422200', '220422', '凌云乡', '1', '220422200', null, '3', '1'),
('220422201', '220422', '甲山乡', '1', '220422201', null, '3', '1'),
('220422202', '220422', '足民乡', '1', '220422202', null, '3', '1'),
('220422203', '220422', '金洲乡', '1', '220422203', null, '3', '1'),
('220502001', '220502', '东昌街道', '1', '220502001', null, '3', '1'),
('220502002', '220502', '民主街道', '1', '220502002', null, '3', '1'),
('220502003', '220502', '老站街道', '1', '220502003', null, '3', '1'),
('220502004', '220502', '团结街道', '1', '220502004', null, '3', '1'),
('220502005', '220502', '新站街道', '1', '220502005', null, '3', '1'),
('220502006', '220502', '光明街道', '1', '220502006', null, '3', '1'),
('220502007', '220502', '龙泉街道', '1', '220502007', null, '3', '1'),
('220502100', '220502', '金厂镇', '1', '220502100', null, '3', '1'),
('220502200', '220502', '环通乡', '1', '220502200', null, '3', '1'),
('220502201', '220502', '江东乡', '1', '220502201', null, '3', '1'),
('220502400', '220502', '通化市经济开发区管委会', '1', '220502400', null, '3', '1'),
('220503001', '220503', '桃园街道', '1', '220503001', null, '3', '1'),
('220503002', '220503', '东通化街道', '1', '220503002', null, '3', '1'),
('220503100', '220503', '鸭园镇', '1', '220503100', null, '3', '1'),
('220503101', '220503', '铁厂镇', '1', '220503101', null, '3', '1'),
('220503102', '220503', '五道江镇', '1', '220503102', null, '3', '1'),
('220503200', '220503', '二道江乡', '1', '220503200', null, '3', '1'),
('220521100', '220521', '快大茂镇', '1', '220521100', null, '3', '1'),
('220521101', '220521', '二密镇', '1', '220521101', null, '3', '1'),
('220521102', '220521', '果松镇', '1', '220521102', null, '3', '1'),
('220521103', '220521', '石湖镇', '1', '220521103', null, '3', '1'),
('220521104', '220521', '大安镇', '1', '220521104', null, '3', '1'),
('220521105', '220521', '光华镇', '1', '220521105', null, '3', '1'),
('220521106', '220521', '兴林镇', '1', '220521106', null, '3', '1'),
('220521107', '220521', '英额布镇', '1', '220521107', null, '3', '1'),
('220521108', '220521', '三棵榆树镇', '1', '220521108', null, '3', '1'),
('220521109', '220521', '江甸镇', '1', '220521109', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('220521200', '220521', '富江乡', '1', '220521200', null, '3', '1'),
('220521201', '220521', '四棚乡', '1', '220521201', null, '3', '1'),
('220521202', '220521', '东来乡', '1', '220521202', null, '3', '1'),
('220521203', '220521', '大泉源满族朝鲜族乡', '1', '220521203', null, '3', '1'),
('220521204', '220521', '金斗朝鲜族满族乡', '1', '220521204', null, '3', '1'),
('220521400', '220521', '通化县工业集中区', '1', '220521400', null, '3', '1'),
('220521401', '220521', '东宝新村', '1', '220521401', null, '3', '1'),
('220523100', '220523', '朝阳镇', '1', '220523100', null, '3', '1'),
('220523101', '220523', '辉南镇', '1', '220523101', null, '3', '1'),
('220523102', '220523', '样子哨镇', '1', '220523102', null, '3', '1'),
('220523103', '220523', '杉松岗镇', '1', '220523103', null, '3', '1'),
('220523104', '220523', '石道河镇', '1', '220523104', null, '3', '1'),
('220523105', '220523', '辉发城镇', '1', '220523105', null, '3', '1'),
('220523106', '220523', '抚民镇', '1', '220523106', null, '3', '1'),
('220523107', '220523', '金川镇', '1', '220523107', null, '3', '1'),
('220523108', '220523', '团林镇', '1', '220523108', null, '3', '1'),
('220523109', '220523', '庆阳镇', '1', '220523109', null, '3', '1'),
('220523200', '220523', '楼街朝鲜族乡', '1', '220523200', null, '3', '1'),
('220524100', '220524', '柳河镇', '1', '220524100', null, '3', '1'),
('220524101', '220524', '三源浦朝鲜族镇', '1', '220524101', null, '3', '1'),
('220524102', '220524', '五道沟镇', '1', '220524102', null, '3', '1'),
('220524103', '220524', '驼腰岭镇', '1', '220524103', null, '3', '1'),
('220524104', '220524', '孤山子镇', '1', '220524104', null, '3', '1'),
('220524105', '220524', '圣水河子镇', '1', '220524105', null, '3', '1'),
('220524106', '220524', '罗通山镇', '1', '220524106', null, '3', '1'),
('220524107', '220524', '安口镇', '1', '220524107', null, '3', '1'),
('220524108', '220524', '向阳镇', '1', '220524108', null, '3', '1'),
('220524109', '220524', '红石镇', '1', '220524109', null, '3', '1'),
('220524110', '220524', '凉水河子镇', '1', '220524110', null, '3', '1'),
('220524111', '220524', '亨通镇', '1', '220524111', null, '3', '1'),
('220524200', '220524', '柳南乡', '1', '220524200', null, '3', '1'),
('220524201', '220524', '时家店乡', '1', '220524201', null, '3', '1'),
('220524202', '220524', '姜家店朝鲜族乡', '1', '220524202', null, '3', '1'),
('220581001', '220581', '新华街道', '1', '220581001', null, '3', '1'),
('220581002', '220581', '光明街道', '1', '220581002', null, '3', '1'),
('220581070', '220581', '和平街道办事处（梅河口市经济贸易开发区）', '1', '220581070', null, '3', '1'),
('220581071', '220581', '解放街道办事处（梅河口市经济贸易开发区）', '1', '220581071', null, '3', '1'),
('220581072', '220581', '福民街道办事处（梅河口市经济贸易开发区）', '1', '220581072', null, '3', '1'),
('220581100', '220581', '山城镇', '1', '220581100', null, '3', '1'),
('220581101', '220581', '红梅镇', '1', '220581101', null, '3', '1'),
('220581102', '220581', '海龙镇', '1', '220581102', null, '3', '1'),
('220581103', '220581', '新合镇', '1', '220581103', null, '3', '1'),
('220581104', '220581', '曙光镇', '1', '220581104', null, '3', '1'),
('220581105', '220581', '中和镇', '1', '220581105', null, '3', '1'),
('220581106', '220581', '黑山头镇', '1', '220581106', null, '3', '1'),
('220581107', '220581', '水道镇', '1', '220581107', null, '3', '1'),
('220581108', '220581', '进化镇', '1', '220581108', null, '3', '1'),
('220581109', '220581', '一座营镇', '1', '220581109', null, '3', '1'),
('220581110', '220581', '康大营镇', '1', '220581110', null, '3', '1'),
('220581111', '220581', '牛心顶镇', '1', '220581111', null, '3', '1'),
('220581200', '220581', '杏岭乡', '1', '220581200', null, '3', '1'),
('220581201', '220581', '李炉乡', '1', '220581201', null, '3', '1'),
('220581202', '220581', '湾龙乡', '1', '220581202', null, '3', '1'),
('220581203', '220581', '双兴乡', '1', '220581203', null, '3', '1'),
('220581204', '220581', '兴华乡', '1', '220581204', null, '3', '1'),
('220581205', '220581', '小杨满族朝鲜族乡', '1', '220581205', null, '3', '1'),
('220581206', '220581', '吉乐乡', '1', '220581206', null, '3', '1'),
('220582001', '220582', '团结街道', '1', '220582001', null, '3', '1'),
('220582002', '220582', '黎明街道', '1', '220582002', null, '3', '1'),
('220582003', '220582', '通胜街道', '1', '220582003', null, '3', '1'),
('220582100', '220582', '青石镇', '1', '220582100', null, '3', '1'),
('220582101', '220582', '榆林镇', '1', '220582101', null, '3', '1'),
('220582102', '220582', '花甸镇', '1', '220582102', null, '3', '1'),
('220582103', '220582', '头道镇', '1', '220582103', null, '3', '1'),
('220582104', '220582', '清河镇', '1', '220582104', null, '3', '1'),
('220582105', '220582', '台上镇', '1', '220582105', null, '3', '1'),
('220582106', '220582', '财源镇', '1', '220582106', null, '3', '1'),
('220582107', '220582', '大路镇', '1', '220582107', null, '3', '1'),
('220582108', '220582', '太王镇', '1', '220582108', null, '3', '1'),
('220582200', '220582', '麻线乡', '1', '220582200', null, '3', '1'),
('220582201', '220582', '凉水朝鲜族乡', '1', '220582201', null, '3', '1'),
('220602001', '220602', '新建街道', '1', '220602001', null, '3', '1'),
('220602002', '220602', '通沟街道', '1', '220602002', null, '3', '1'),
('220602003', '220602', '东兴街道', '1', '220602003', null, '3', '1'),
('220602004', '220602', '红旗街道', '1', '220602004', null, '3', '1'),
('220602005', '220602', '城南街道', '1', '220602005', null, '3', '1'),
('220602006', '220602', '江北街道', '1', '220602006', null, '3', '1'),
('220602007', '220602', '河口街道', '1', '220602007', null, '3', '1'),
('220602008', '220602', '板石街道', '1', '220602008', null, '3', '1'),
('220602100', '220602', '七道江镇', '1', '220602100', null, '3', '1'),
('220602101', '220602', '六道江镇', '1', '220602101', null, '3', '1'),
('220602102', '220602', '红土崖镇', '1', '220602102', null, '3', '1'),
('220602103', '220602', '三道沟镇', '1', '220602103', null, '3', '1'),
('220604100', '220604', '孙家堡子镇', '1', '220604100', null, '3', '1'),
('220604101', '220604', '三岔子镇', '1', '220604101', null, '3', '1'),
('220604102', '220604', '湾沟镇', '1', '220604102', null, '3', '1'),
('220604103', '220604', '松树镇', '1', '220604103', null, '3', '1'),
('220604104', '220604', '砟子镇', '1', '220604104', null, '3', '1'),
('220604105', '220604', '石人镇', '1', '220604105', null, '3', '1'),
('220604106', '220604', '大阳岔镇', '1', '220604106', null, '3', '1'),
('220604107', '220604', '大石人镇', '1', '220604107', null, '3', '1'),
('220621100', '220621', '抚松镇', '1', '220621100', null, '3', '1'),
('220621101', '220621', '松江河镇', '1', '220621101', null, '3', '1'),
('220621102', '220621', '泉阳镇', '1', '220621102', null, '3', '1'),
('220621103', '220621', '露水河镇', '1', '220621103', null, '3', '1'),
('220621104', '220621', '仙人桥镇', '1', '220621104', null, '3', '1'),
('220621105', '220621', '万良镇', '1', '220621105', null, '3', '1'),
('220621106', '220621', '新屯子镇', '1', '220621106', null, '3', '1'),
('220621107', '220621', '东岗镇', '1', '220621107', null, '3', '1'),
('220621108', '220621', '漫江镇', '1', '220621108', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('220621109', '220621', '北岗镇', '1', '220621109', null, '3', '1'),
('220621110', '220621', '兴参镇', '1', '220621110', null, '3', '1'),
('220621200', '220621', '兴隆乡', '1', '220621200', null, '3', '1'),
('220621201', '220621', '抽水乡', '1', '220621201', null, '3', '1'),
('220621202', '220621', '沿江乡', '1', '220621202', null, '3', '1'),
('220622100', '220622', '靖宇镇', '1', '220622100', null, '3', '1'),
('220622101', '220622', '三道湖镇', '1', '220622101', null, '3', '1'),
('220622102', '220622', '龙泉镇', '1', '220622102', null, '3', '1'),
('220622103', '220622', '那尔轰镇', '1', '220622103', null, '3', '1'),
('220622104', '220622', '花园口镇', '1', '220622104', null, '3', '1'),
('220622105', '220622', '景山镇', '1', '220622105', null, '3', '1'),
('220622200', '220622', '赤松乡', '1', '220622200', null, '3', '1'),
('220622201', '220622', '蒙江乡', '1', '220622201', null, '3', '1'),
('220623100', '220623', '长白镇', '1', '220623100', null, '3', '1'),
('220623101', '220623', '八道沟镇', '1', '220623101', null, '3', '1'),
('220623102', '220623', '十四道沟镇', '1', '220623102', null, '3', '1'),
('220623103', '220623', '马鹿沟镇', '1', '220623103', null, '3', '1'),
('220623104', '220623', '宝泉山镇', '1', '220623104', null, '3', '1'),
('220623105', '220623', '新房子镇', '1', '220623105', null, '3', '1'),
('220623200', '220623', '金华乡', '1', '220623200', null, '3', '1'),
('220623201', '220623', '十二道沟乡', '1', '220623201', null, '3', '1'),
('220623270', '220623', '长白县南坡旅游开发区（长白山保护开发区管', '1', '220623270', null, '3', '1'),
('220681001', '220681', '建国街道', '1', '220681001', null, '3', '1'),
('220681002', '220681', '新市街道', '1', '220681002', null, '3', '1'),
('220681003', '220681', '兴隆街道', '1', '220681003', null, '3', '1'),
('220681004', '220681', '大湖街道', '1', '220681004', null, '3', '1'),
('220681005', '220681', '森工街道', '1', '220681005', null, '3', '1'),
('220681006', '220681', '大栗子街道', '1', '220681006', null, '3', '1'),
('220681100', '220681', '桦树镇', '1', '220681100', null, '3', '1'),
('220681101', '220681', '六道沟镇', '1', '220681101', null, '3', '1'),
('220681102', '220681', '苇沙河镇', '1', '220681102', null, '3', '1'),
('220681103', '220681', '花山镇', '1', '220681103', null, '3', '1'),
('220681104', '220681', '闹枝镇', '1', '220681104', null, '3', '1'),
('220681105', '220681', '四道沟镇', '1', '220681105', null, '3', '1'),
('220681200', '220681', '蚂蚁河乡', '1', '220681200', null, '3', '1'),
('220702001', '220702', '团结街道', '1', '220702001', null, '3', '1'),
('220702002', '220702', '文化街道', '1', '220702002', null, '3', '1'),
('220702003', '220702', '民主街道', '1', '220702003', null, '3', '1'),
('220702004', '220702', '临江街道', '1', '220702004', null, '3', '1'),
('220702005', '220702', '新区街道', '1', '220702005', null, '3', '1'),
('220702006', '220702', '前进街道', '1', '220702006', null, '3', '1'),
('220702007', '220702', '和平街道', '1', '220702007', null, '3', '1'),
('220702008', '220702', '工农街道', '1', '220702008', null, '3', '1'),
('220702009', '220702', '沿江街道', '1', '220702009', null, '3', '1'),
('220702010', '220702', '铁西街道', '1', '220702010', null, '3', '1'),
('220702011', '220702', '繁荣街道', '1', '220702011', null, '3', '1'),
('220702012', '220702', '建设街道', '1', '220702012', null, '3', '1'),
('220702013', '220702', '石化街道', '1', '220702013', null, '3', '1'),
('220702100', '220702', '大洼镇', '1', '220702100', null, '3', '1'),
('220702101', '220702', '善友镇', '1', '220702101', null, '3', '1'),
('220702102', '220702', '毛都站镇', '1', '220702102', null, '3', '1'),
('220702103', '220702', '伯都纳镇', '1', '220702103', null, '3', '1'),
('220702200', '220702', '新城乡', '1', '220702200', null, '3', '1'),
('220702201', '220702', '兴原乡', '1', '220702201', null, '3', '1'),
('220702400', '220702', '华侨农场', '1', '220702400', null, '3', '1'),
('220721100', '220721', '前郭尔罗斯镇', '1', '220721100', null, '3', '1'),
('220721101', '220721', '长山镇', '1', '220721101', null, '3', '1'),
('220721102', '220721', '海渤日戈镇', '1', '220721102', null, '3', '1'),
('220721103', '220721', '乌兰图嘎镇', '1', '220721103', null, '3', '1'),
('220721104', '220721', '查干花镇', '1', '220721104', null, '3', '1'),
('220721105', '220721', '王府站镇', '1', '220721105', null, '3', '1'),
('220721106', '220721', '八郎镇', '1', '220721106', null, '3', '1'),
('220721107', '220721', '哈拉毛都镇', '1', '220721107', null, '3', '1'),
('220721200', '220721', '宝甸乡', '1', '220721200', null, '3', '1'),
('220721201', '220721', '平凤乡', '1', '220721201', null, '3', '1'),
('220721202', '220721', '蒙古艾里乡', '1', '220721202', null, '3', '1'),
('220721203', '220721', '达里巴乡', '1', '220721203', null, '3', '1'),
('220721204', '220721', '吉拉吐乡', '1', '220721204', null, '3', '1'),
('220721205', '220721', '白依拉嘎乡', '1', '220721205', null, '3', '1'),
('220721206', '220721', '洪泉乡', '1', '220721206', null, '3', '1'),
('220721207', '220721', '额如乡', '1', '220721207', null, '3', '1'),
('220721208', '220721', '套浩太乡', '1', '220721208', null, '3', '1'),
('220721209', '220721', '长龙乡', '1', '220721209', null, '3', '1'),
('220721210', '220721', '乌兰塔拉乡', '1', '220721210', null, '3', '1'),
('220721211', '220721', '东三家子乡', '1', '220721211', null, '3', '1'),
('220721212', '220721', '浩特芒哈乡', '1', '220721212', null, '3', '1'),
('220721213', '220721', '乌兰敖都乡', '1', '220721213', null, '3', '1'),
('220721400', '220721', '红旗农场', '1', '220721400', null, '3', '1'),
('220721401', '220721', '红光农场', '1', '220721401', null, '3', '1'),
('220721402', '220721', '红星牧场', '1', '220721402', null, '3', '1'),
('220721403', '220721', '查干花种畜场', '1', '220721403', null, '3', '1'),
('220722100', '220722', '长岭镇', '1', '220722100', null, '3', '1'),
('220722101', '220722', '太平川镇', '1', '220722101', null, '3', '1'),
('220722102', '220722', '巨宝镇', '1', '220722102', null, '3', '1'),
('220722103', '220722', '太平山镇', '1', '220722103', null, '3', '1'),
('220722104', '220722', '前七号镇', '1', '220722104', null, '3', '1'),
('220722105', '220722', '新安镇', '1', '220722105', null, '3', '1'),
('220722106', '220722', '三青山镇', '1', '220722106', null, '3', '1'),
('220722107', '220722', '大兴镇', '1', '220722107', null, '3', '1'),
('220722108', '220722', '北正镇', '1', '220722108', null, '3', '1'),
('220722109', '220722', '流水镇', '1', '220722109', null, '3', '1'),
('220722110', '220722', '永久镇', '1', '220722110', null, '3', '1'),
('220722111', '220722', '利发盛镇', '1', '220722111', null, '3', '1'),
('220722200', '220722', '集体乡', '1', '220722200', null, '3', '1'),
('220722201', '220722', '光明乡', '1', '220722201', null, '3', '1'),
('220722202', '220722', '三县堡乡', '1', '220722202', null, '3', '1'),
('220722203', '220722', '海青乡', '1', '220722203', null, '3', '1'),
('220722204', '220722', '前进乡', '1', '220722204', null, '3', '1'),
('220722205', '220722', '东岭乡', '1', '220722205', null, '3', '1'),
('220722206', '220722', '腰坨子乡', '1', '220722206', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('220722207', '220722', '八十八乡', '1', '220722207', null, '3', '1'),
('220722208', '220722', '三团乡', '1', '220722208', null, '3', '1'),
('220722209', '220722', '三十号乡', '1', '220722209', null, '3', '1'),
('220722400', '220722', '长岭种马场', '1', '220722400', null, '3', '1'),
('220722401', '220722', '太平川（镇）农业园区', '1', '220722401', null, '3', '1'),
('220722402', '220722', '北正（镇）牧业园区', '1', '220722402', null, '3', '1'),
('220722403', '220722', '双龙工业园区', '1', '220722403', null, '3', '1'),
('220722404', '220722', '长岭经济开发区', '1', '220722404', null, '3', '1'),
('220722405', '220722', '太平川机械林场', '1', '220722405', null, '3', '1'),
('220722406', '220722', '三团机械林场', '1', '220722406', null, '3', '1'),
('220722407', '220722', '东岭机械林场', '1', '220722407', null, '3', '1'),
('220722408', '220722', '十四号种畜场', '1', '220722408', null, '3', '1'),
('220722409', '220722', '良种繁育场', '1', '220722409', null, '3', '1'),
('220722410', '220722', '前七号机械林场', '1', '220722410', null, '3', '1'),
('220723100', '220723', '乾安镇', '1', '220723100', null, '3', '1'),
('220723101', '220723', '大布苏镇', '1', '220723101', null, '3', '1'),
('220723102', '220723', '水字镇', '1', '220723102', null, '3', '1'),
('220723103', '220723', '让字镇', '1', '220723103', null, '3', '1'),
('220723104', '220723', '所字镇', '1', '220723104', null, '3', '1'),
('220723105', '220723', '安字镇', '1', '220723105', null, '3', '1'),
('220723200', '220723', '余字乡', '1', '220723200', null, '3', '1'),
('220723201', '220723', '道字乡', '1', '220723201', null, '3', '1'),
('220723202', '220723', '严字乡', '1', '220723202', null, '3', '1'),
('220723203', '220723', '赞字乡', '1', '220723203', null, '3', '1'),
('220724100', '220724', '三岔河镇', '1', '220724100', null, '3', '1'),
('220724101', '220724', '长春岭镇', '1', '220724101', null, '3', '1'),
('220724102', '220724', '五家站镇', '1', '220724102', null, '3', '1'),
('220724103', '220724', '陶赖昭镇', '1', '220724103', null, '3', '1'),
('220724104', '220724', '蔡家沟镇', '1', '220724104', null, '3', '1'),
('220724105', '220724', '弓棚子镇', '1', '220724105', null, '3', '1'),
('220724106', '220724', '三井子镇', '1', '220724106', null, '3', '1'),
('220724107', '220724', '增盛镇', '1', '220724107', null, '3', '1'),
('220724108', '220724', '新万发镇', '1', '220724108', null, '3', '1'),
('220724109', '220724', '大林子镇', '1', '220724109', null, '3', '1'),
('220724110', '220724', '新源镇', '1', '220724110', null, '3', '1'),
('220724200', '220724', '三骏满族蒙古族锡伯族乡', '1', '220724200', null, '3', '1'),
('220724201', '220724', '永平乡', '1', '220724201', null, '3', '1'),
('220724202', '220724', '社里乡', '1', '220724202', null, '3', '1'),
('220724203', '220724', '新站乡', '1', '220724203', null, '3', '1'),
('220724204', '220724', '更新乡', '1', '220724204', null, '3', '1'),
('220724205', '220724', '伊家店乡', '1', '220724205', null, '3', '1'),
('220724206', '220724', '肖家乡', '1', '220724206', null, '3', '1'),
('220724400', '220724', '伊家店农场', '1', '220724400', null, '3', '1'),
('220724401', '220724', '拉林灌区管理局', '1', '220724401', null, '3', '1'),
('220724402', '220724', '下岱吉灌区管理局', '1', '220724402', null, '3', '1'),
('220802001', '220802', '海明街道', '1', '220802001', null, '3', '1'),
('220802002', '220802', '长庆街道', '1', '220802002', null, '3', '1'),
('220802003', '220802', '瑞光街道', '1', '220802003', null, '3', '1'),
('220802004', '220802', '明仁街道', '1', '220802004', null, '3', '1'),
('220802005', '220802', '铁东街道', '1', '220802005', null, '3', '1'),
('220802006', '220802', '城南街道', '1', '220802006', null, '3', '1'),
('220802007', '220802', '新立街道', '1', '220802007', null, '3', '1'),
('220802008', '220802', '幸福街道', '1', '220802008', null, '3', '1'),
('220802009', '220802', '新华街道', '1', '220802009', null, '3', '1'),
('220802010', '220802', '保平街道', '1', '220802010', null, '3', '1'),
('220802070', '220802', '白城经济开发区（省级）', '1', '220802070', null, '3', '1'),
('220802100', '220802', '平安镇', '1', '220802100', null, '3', '1'),
('220802101', '220802', '青山镇', '1', '220802101', null, '3', '1'),
('220802102', '220802', '林海镇', '1', '220802102', null, '3', '1'),
('220802103', '220802', '洮河镇', '1', '220802103', null, '3', '1'),
('220802104', '220802', '平台镇', '1', '220802104', null, '3', '1'),
('220802105', '220802', '到保镇', '1', '220802105', null, '3', '1'),
('220802170', '220802', '岭下镇（查干浩特旅游经济开发区）（省级）', '1', '220802170', null, '3', '1'),
('220802200', '220802', '东风乡', '1', '220802200', null, '3', '1'),
('220802201', '220802', '三合乡', '1', '220802201', null, '3', '1'),
('220802202', '220802', '东胜乡', '1', '220802202', null, '3', '1'),
('220802203', '220802', '金祥乡', '1', '220802203', null, '3', '1'),
('220802204', '220802', '德顺蒙古族乡', '1', '220802204', null, '3', '1'),
('220802400', '220802', '民营经济发展区', '1', '220802400', null, '3', '1'),
('220802401', '220802', '白城市工业园区', '1', '220802401', null, '3', '1'),
('220802402', '220802', '镇南种羊场', '1', '220802402', null, '3', '1'),
('220821100', '220821', '镇赉镇', '1', '220821100', null, '3', '1'),
('220821101', '220821', '坦途镇', '1', '220821101', null, '3', '1'),
('220821102', '220821', '东屏镇', '1', '220821102', null, '3', '1'),
('220821103', '220821', '大屯镇', '1', '220821103', null, '3', '1'),
('220821104', '220821', '沿江镇', '1', '220821104', null, '3', '1'),
('220821105', '220821', '五棵树镇', '1', '220821105', null, '3', '1'),
('220821106', '220821', '黑鱼泡镇', '1', '220821106', null, '3', '1'),
('220821200', '220821', '哈吐气蒙古族乡', '1', '220821200', null, '3', '1'),
('220821201', '220821', '莫莫格蒙古族乡', '1', '220821201', null, '3', '1'),
('220821202', '220821', '建平乡', '1', '220821202', null, '3', '1'),
('220821203', '220821', '嘎什根乡', '1', '220821203', null, '3', '1'),
('220821400', '220821', '镇赉监狱分局', '1', '220821400', null, '3', '1'),
('220822100', '220822', '开通镇', '1', '220822100', null, '3', '1'),
('220822101', '220822', '瞻榆镇', '1', '220822101', null, '3', '1'),
('220822102', '220822', '双岗镇', '1', '220822102', null, '3', '1'),
('220822103', '220822', '兴隆山镇', '1', '220822103', null, '3', '1'),
('220822104', '220822', '边昭镇', '1', '220822104', null, '3', '1'),
('220822105', '220822', '鸿兴镇', '1', '220822105', null, '3', '1'),
('220822106', '220822', '新华镇', '1', '220822106', null, '3', '1'),
('220822107', '220822', '乌兰花镇', '1', '220822107', null, '3', '1'),
('220822200', '220822', '新发乡', '1', '220822200', null, '3', '1'),
('220822201', '220822', '新兴乡', '1', '220822201', null, '3', '1'),
('220822202', '220822', '向海蒙古族乡', '1', '220822202', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('220822203', '220822', '包拉温都蒙古族乡', '1', '220822203', null, '3', '1'),
('220822204', '220822', '团结乡', '1', '220822204', null, '3', '1'),
('220822205', '220822', '十花道乡', '1', '220822205', null, '3', '1'),
('220822206', '220822', '八面乡', '1', '220822206', null, '3', '1'),
('220822207', '220822', '苏公坨乡', '1', '220822207', null, '3', '1'),
('220822400', '220822', '通榆经济开发区', '1', '220822400', null, '3', '1'),
('220881001', '220881', '团结街道', '1', '220881001', null, '3', '1'),
('220881002', '220881', '富文街道', '1', '220881002', null, '3', '1'),
('220881003', '220881', '光明街道', '1', '220881003', null, '3', '1'),
('220881004', '220881', '兴隆街道', '1', '220881004', null, '3', '1'),
('220881005', '220881', '永康街道', '1', '220881005', null, '3', '1'),
('220881006', '220881', '通达街道', '1', '220881006', null, '3', '1'),
('220881007', '220881', '洮府街道', '1', '220881007', null, '3', '1'),
('220881008', '220881', '向阳街道', '1', '220881008', null, '3', '1'),
('220881100', '220881', '瓦房镇', '1', '220881100', null, '3', '1'),
('220881101', '220881', '万宝镇', '1', '220881101', null, '3', '1'),
('220881102', '220881', '黑水镇', '1', '220881102', null, '3', '1'),
('220881103', '220881', '那金镇', '1', '220881103', null, '3', '1'),
('220881104', '220881', '安定镇', '1', '220881104', null, '3', '1'),
('220881200', '220881', '胡力吐蒙古族乡', '1', '220881200', null, '3', '1'),
('220881201', '220881', '万宝乡', '1', '220881201', null, '3', '1'),
('220881202', '220881', '聚宝乡', '1', '220881202', null, '3', '1'),
('220881203', '220881', '东升乡', '1', '220881203', null, '3', '1'),
('220881204', '220881', '野马乡', '1', '220881204', null, '3', '1'),
('220881205', '220881', '永茂乡', '1', '220881205', null, '3', '1'),
('220881206', '220881', '蛟流河乡', '1', '220881206', null, '3', '1'),
('220881207', '220881', '大通乡', '1', '220881207', null, '3', '1'),
('220881208', '220881', '福顺乡', '1', '220881208', null, '3', '1'),
('220881209', '220881', '二龙乡', '1', '220881209', null, '3', '1'),
('220881210', '220881', '呼和车力蒙古族乡', '1', '220881210', null, '3', '1'),
('220881400', '220881', '洮南市种雏场', '1', '220881400', null, '3', '1'),
('220881401', '220881', '洮南市甜菜育种研究所', '1', '220881401', null, '3', '1'),
('220882001', '220882', '慧阳街道', '1', '220882001', null, '3', '1'),
('220882002', '220882', '临江街道', '1', '220882002', null, '3', '1'),
('220882003', '220882', '长虹街道', '1', '220882003', null, '3', '1'),
('220882004', '220882', '锦华街道', '1', '220882004', null, '3', '1'),
('220882005', '220882', '安北街道', '1', '220882005', null, '3', '1'),
('220882070', '220882', '大安经济开发区（省级）', '1', '220882070', null, '3', '1'),
('220882100', '220882', '月亮泡镇', '1', '220882100', null, '3', '1'),
('220882101', '220882', '安广镇', '1', '220882101', null, '3', '1'),
('220882102', '220882', '丰收镇', '1', '220882102', null, '3', '1'),
('220882103', '220882', '新平安镇', '1', '220882103', null, '3', '1'),
('220882104', '220882', '两家子镇', '1', '220882104', null, '3', '1'),
('220882105', '220882', '舍力镇', '1', '220882105', null, '3', '1'),
('220882106', '220882', '大岗子镇', '1', '220882106', null, '3', '1'),
('220882107', '220882', '叉干镇', '1', '220882107', null, '3', '1'),
('220882108', '220882', '龙沼镇', '1', '220882108', null, '3', '1'),
('220882109', '220882', '太山镇', '1', '220882109', null, '3', '1'),
('220882110', '220882', '烧锅镇', '1', '220882110', null, '3', '1'),
('220882111', '220882', '乐胜镇', '1', '220882111', null, '3', '1'),
('220882200', '220882', '四棵树乡', '1', '220882200', null, '3', '1'),
('220882201', '220882', '联合乡', '1', '220882201', null, '3', '1'),
('220882202', '220882', '大赉乡', '1', '220882202', null, '3', '1'),
('220882203', '220882', '红岗子乡', '1', '220882203', null, '3', '1'),
('220882204', '220882', '海坨乡', '1', '220882204', null, '3', '1'),
('220882205', '220882', '新艾里蒙古族乡', '1', '220882205', null, '3', '1'),
('222401001', '222401', '朝阳街道', '1', '222401001', null, '3', '1'),
('222401002', '222401', '北山街道', '1', '222401002', null, '3', '1'),
('222401003', '222401', '新兴街道', '1', '222401003', null, '3', '1'),
('222401004', '222401', '公园街道', '1', '222401004', null, '3', '1'),
('222401005', '222401', '河南街道', '1', '222401005', null, '3', '1'),
('222401006', '222401', '建工街道', '1', '222401006', null, '3', '1'),
('222401100', '222401', '小营镇', '1', '222401100', null, '3', '1'),
('222401101', '222401', '依兰镇', '1', '222401101', null, '3', '1'),
('222401102', '222401', '三道湾镇', '1', '222401102', null, '3', '1'),
('222402001', '222402', '向上街道', '1', '222402001', null, '3', '1'),
('222402002', '222402', '新华街道', '1', '222402002', null, '3', '1'),
('222402003', '222402', '月宫街道', '1', '222402003', null, '3', '1'),
('222402100', '222402', '月晴镇', '1', '222402100', null, '3', '1'),
('222402101', '222402', '石岘镇', '1', '222402101', null, '3', '1'),
('222402102', '222402', '长安镇', '1', '222402102', null, '3', '1'),
('222402103', '222402', '凉水镇', '1', '222402103', null, '3', '1'),
('222403001', '222403', '渤海街道', '1', '222403001', null, '3', '1'),
('222403002', '222403', '胜利街道', '1', '222403002', null, '3', '1'),
('222403003', '222403', '民主街道', '1', '222403003', null, '3', '1'),
('222403004', '222403', '丹江街道', '1', '222403004', null, '3', '1'),
('222403100', '222403', '大石头镇', '1', '222403100', null, '3', '1'),
('222403101', '222403', '黄泥河镇', '1', '222403101', null, '3', '1'),
('222403102', '222403', '官地镇', '1', '222403102', null, '3', '1'),
('222403103', '222403', '沙河沿镇', '1', '222403103', null, '3', '1'),
('222403104', '222403', '秋梨沟镇', '1', '222403104', null, '3', '1'),
('222403105', '222403', '额穆镇', '1', '222403105', null, '3', '1'),
('222403106', '222403', '贤儒镇', '1', '222403106', null, '3', '1'),
('222403107', '222403', '大蒲柴河镇', '1', '222403107', null, '3', '1'),
('222403108', '222403', '雁鸣湖镇', '1', '222403108', null, '3', '1'),
('222403109', '222403', '江源镇', '1', '222403109', null, '3', '1'),
('222403110', '222403', '江南镇', '1', '222403110', null, '3', '1'),
('222403200', '222403', '大桥乡', '1', '222403200', null, '3', '1'),
('222403201', '222403', '黑石乡', '1', '222403201', null, '3', '1'),
('222403202', '222403', '青沟子乡', '1', '222403202', null, '3', '1'),
('222403203', '222403', '翰章乡', '1', '222403203', null, '3', '1'),
('222403204', '222403', '红石乡', '1', '222403204', null, '3', '1'),
('222403400', '222403', '丹峰林业有限公司', '1', '222403400', null, '3', '1'),
('222403401', '222403', '黄泥河林业局', '1', '222403401', null, '3', '1'),
('222403402', '222403', '延边林业集团亚光有限公司', '1', '222403402', null, '3', '1'),
('222403403', '222403', '敦化市林业局', '1', '222403403', null, '3', '1'),
('222404001', '222404', '靖和街道', '1', '222404001', null, '3', '1'),
('222404002', '222404', '新安街道', '1', '222404002', null, '3', '1'),
('222404003', '222404', '河南街道', '1', '222404003', null, '3', '1'),
('222404070', '222404', '近海街道办事处（珲春边境经济合作区）（国', '1', '222404070', null, '3', '1'),
('222404100', '222404', '春化镇', '1', '222404100', null, '3', '1'),
('222404101', '222404', '敬信镇', '1', '222404101', null, '3', '1'),
('222404102', '222404', '板石镇', '1', '222404102', null, '3', '1'),
('222404103', '222404', '英安镇', '1', '222404103', null, '3', '1'),
('222404200', '222404', '马川子乡', '1', '222404200', null, '3', '1'),
('222404201', '222404', '杨泡满族乡', '1', '222404201', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('222404202', '222404', '三家子满族乡', '1', '222404202', null, '3', '1'),
('222404203', '222404', '密江乡', '1', '222404203', null, '3', '1'),
('222404204', '222404', '哈达门乡', '1', '222404204', null, '3', '1'),
('222404400', '222404', '珲春林业局', '1', '222404400', null, '3', '1'),
('222405001', '222405', '安民街道', '1', '222405001', null, '3', '1'),
('222405002', '222405', '龙门街道', '1', '222405002', null, '3', '1'),
('222405100', '222405', '开山屯镇', '1', '222405100', null, '3', '1'),
('222405101', '222405', '朝阳川镇', '1', '222405101', null, '3', '1'),
('222405102', '222405', '老头沟镇', '1', '222405102', null, '3', '1'),
('222405103', '222405', '三合镇', '1', '222405103', null, '3', '1'),
('222405104', '222405', '东盛涌镇', '1', '222405104', null, '3', '1'),
('222405105', '222405', '智新镇', '1', '222405105', null, '3', '1'),
('222405200', '222405', '德新乡', '1', '222405200', null, '3', '1'),
('222405201', '222405', '白金乡', '1', '222405201', null, '3', '1'),
('222406001', '222406', '民慧街道', '1', '222406001', null, '3', '1'),
('222406002', '222406', '光明街道', '1', '222406002', null, '3', '1'),
('222406003', '222406', '文化街道', '1', '222406003', null, '3', '1'),
('222406100', '222406', '八家子镇', '1', '222406100', null, '3', '1'),
('222406101', '222406', '福洞镇', '1', '222406101', null, '3', '1'),
('222406102', '222406', '头道镇', '1', '222406102', null, '3', '1'),
('222406103', '222406', '西城镇', '1', '222406103', null, '3', '1'),
('222406104', '222406', '南坪镇', '1', '222406104', null, '3', '1'),
('222406105', '222406', '东城镇', '1', '222406105', null, '3', '1'),
('222406106', '222406', '崇善镇', '1', '222406106', null, '3', '1'),
('222406107', '222406', '龙城镇', '1', '222406107', null, '3', '1'),
('222406400', '222406', '和龙林业局', '1', '222406400', null, '3', '1'),
('222406401', '222406', '八家子林业局', '1', '222406401', null, '3', '1'),
('222406402', '222406', '和龙市林业局', '1', '222406402', null, '3', '1'),
('222424001', '222424', '东城街道', '1', '222424001', null, '3', '1'),
('222424002', '222424', '西城街道', '1', '222424002', null, '3', '1'),
('222424100', '222424', '汪清镇', '1', '222424100', null, '3', '1'),
('222424101', '222424', '大兴沟镇', '1', '222424101', null, '3', '1'),
('222424102', '222424', '天桥岭镇', '1', '222424102', null, '3', '1'),
('222424103', '222424', '罗子沟镇', '1', '222424103', null, '3', '1'),
('222424104', '222424', '百草沟镇', '1', '222424104', null, '3', '1'),
('222424105', '222424', '春阳镇', '1', '222424105', null, '3', '1'),
('222424106', '222424', '复兴镇', '1', '222424106', null, '3', '1'),
('222424107', '222424', '东光镇', '1', '222424107', null, '3', '1'),
('222424200', '222424', '鸡冠乡', '1', '222424200', null, '3', '1'),
('222424400', '222424', '汪清林业局', '1', '222424400', null, '3', '1'),
('222424401', '222424', '天桥岭林业局', '1', '222424401', null, '3', '1'),
('222424402', '222424', '大兴沟林业局', '1', '222424402', null, '3', '1'),
('222426100', '222426', '明月镇', '1', '222426100', null, '3', '1'),
('222426101', '222426', '松江镇', '1', '222426101', null, '3', '1'),
('222426102', '222426', '二道白河镇', '1', '222426102', null, '3', '1'),
('222426103', '222426', '两江镇', '1', '222426103', null, '3', '1'),
('222426104', '222426', '石门镇', '1', '222426104', null, '3', '1'),
('222426105', '222426', '万宝镇', '1', '222426105', null, '3', '1'),
('222426106', '222426', '亮兵镇', '1', '222426106', null, '3', '1'),
('222426200', '222426', '新合乡', '1', '222426200', null, '3', '1'),
('222426201', '222426', '永庆乡', '1', '222426201', null, '3', '1'),
('222426400', '222426', '白河林业局', '1', '222426400', null, '3', '1'),
('222426401', '222426', '安图林业有限公司', '1', '222426401', null, '3', '1'),
('222426402', '222426', '安图县林业局', '1', '222426402', null, '3', '1'),
('230102001', '230102', '兆麟街道', '1', '230102001', null, '3', '1'),
('230102002', '230102', '新阳路街道', '1', '230102002', null, '3', '1'),
('230102003', '230102', '抚顺街道', '1', '230102003', null, '3', '1'),
('230102004', '230102', '共乐街道', '1', '230102004', null, '3', '1'),
('230102005', '230102', '新华街道', '1', '230102005', null, '3', '1'),
('230102006', '230102', '城乡路街道', '1', '230102006', null, '3', '1'),
('230102007', '230102', '工农街道', '1', '230102007', null, '3', '1'),
('230102008', '230102', '尚志街道', '1', '230102008', null, '3', '1'),
('230102009', '230102', '斯大林街道', '1', '230102009', null, '3', '1'),
('230102010', '230102', '通江街道', '1', '230102010', null, '3', '1'),
('230102011', '230102', '经纬街道', '1', '230102011', null, '3', '1'),
('230102012', '230102', '工程街道', '1', '230102012', null, '3', '1'),
('230102013', '230102', '安静街道', '1', '230102013', null, '3', '1'),
('230102014', '230102', '安和街道', '1', '230102014', null, '3', '1'),
('230102015', '230102', '正阳河街道', '1', '230102015', null, '3', '1'),
('230102016', '230102', '建国街道', '1', '230102016', null, '3', '1'),
('230102017', '230102', '康安街道', '1', '230102017', null, '3', '1'),
('230102101', '230102', '太平镇', '1', '230102101', null, '3', '1'),
('230102102', '230102', '新发镇', '1', '230102102', null, '3', '1'),
('230102103', '230102', '新农镇', '1', '230102103', null, '3', '1'),
('230102104', '230102', '榆树镇', '1', '230102104', null, '3', '1'),
('230102200', '230102', '群力乡', '1', '230102200', null, '3', '1'),
('230102500', '230102', '阎家岗农场', '1', '230102500', null, '3', '1'),
('230103001', '230103', '花园街道', '1', '230103001', null, '3', '1'),
('230103002', '230103', '奋斗路街道', '1', '230103002', null, '3', '1'),
('230103003', '230103', '革新街道', '1', '230103003', null, '3', '1'),
('230103004', '230103', '文化街道', '1', '230103004', null, '3', '1'),
('230103005', '230103', '大成街道', '1', '230103005', null, '3', '1'),
('230103006', '230103', '芦家街道', '1', '230103006', null, '3', '1'),
('230103007', '230103', '荣市街道', '1', '230103007', null, '3', '1'),
('230103009', '230103', '燎原街道', '1', '230103009', null, '3', '1'),
('230103010', '230103', '松花江街道', '1', '230103010', null, '3', '1'),
('230103011', '230103', '曲线街道', '1', '230103011', null, '3', '1'),
('230103012', '230103', '通达街道', '1', '230103012', null, '3', '1'),
('230103013', '230103', '七政街道', '1', '230103013', null, '3', '1'),
('230103015', '230103', '和兴路街道', '1', '230103015', null, '3', '1'),
('230103016', '230103', '哈西街道', '1', '230103016', null, '3', '1'),
('230103017', '230103', '保健路街道', '1', '230103017', null, '3', '1'),
('230103018', '230103', '先锋路街道', '1', '230103018', null, '3', '1'),
('230103019', '230103', '新春街道', '1', '230103019', null, '3', '1'),
('230103101', '230103', '王岗镇', '1', '230103101', null, '3', '1'),
('230103201', '230103', '红旗满族乡', '1', '230103201', null, '3', '1'),
('230103202', '230103', '跃进乡', '1', '230103202', null, '3', '1'),
('230104001', '230104', '靖宇街道', '1', '230104001', null, '3', '1'),
('230104002', '230104', '太古街道', '1', '230104002', null, '3', '1'),
('230104003', '230104', '东莱街道', '1', '230104003', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('230104004', '230104', '滨江街道', '1', '230104004', null, '3', '1'),
('230104005', '230104', '仁里街道', '1', '230104005', null, '3', '1'),
('230104007', '230104', '崇俭街道', '1', '230104007', null, '3', '1'),
('230104008', '230104', '振江街道', '1', '230104008', null, '3', '1'),
('230104009', '230104', '东原街道', '1', '230104009', null, '3', '1'),
('230104010', '230104', '大兴街道', '1', '230104010', null, '3', '1'),
('230104011', '230104', '胜利街道', '1', '230104011', null, '3', '1'),
('230104012', '230104', '南马街道', '1', '230104012', null, '3', '1'),
('230104021', '230104', '民强街道', '1', '230104021', null, '3', '1'),
('230104022', '230104', '大有坊街道', '1', '230104022', null, '3', '1'),
('230104023', '230104', '南直路街道', '1', '230104023', null, '3', '1'),
('230104024', '230104', '化工街道', '1', '230104024', null, '3', '1'),
('230104025', '230104', '火车头街道', '1', '230104025', null, '3', '1'),
('230104026', '230104', '新一街道', '1', '230104026', null, '3', '1'),
('230104027', '230104', '三棵树大街街道', '1', '230104027', null, '3', '1'),
('230104028', '230104', '水泥路街道', '1', '230104028', null, '3', '1'),
('230104029', '230104', '太平大街街道', '1', '230104029', null, '3', '1'),
('230104030', '230104', '黎华街道', '1', '230104030', null, '3', '1'),
('230104031', '230104', '新乐街道', '1', '230104031', null, '3', '1'),
('230104102', '230104', '永源镇', '1', '230104102', null, '3', '1'),
('230104109', '230104', '巨源镇', '1', '230104109', null, '3', '1'),
('230104111', '230104', '团结镇', '1', '230104111', null, '3', '1'),
('230104200', '230104', '民主乡', '1', '230104200', null, '3', '1'),
('230108001', '230108', '兴建街道', '1', '230108001', null, '3', '1'),
('230108002', '230108', '保国街道', '1', '230108002', null, '3', '1'),
('230108003', '230108', '联盟街道', '1', '230108003', null, '3', '1'),
('230108004', '230108', '友协街道', '1', '230108004', null, '3', '1'),
('230108005', '230108', '新疆街道', '1', '230108005', null, '3', '1'),
('230108006', '230108', '新伟街道', '1', '230108006', null, '3', '1'),
('230108101', '230108', '平房镇', '1', '230108101', null, '3', '1'),
('230108102', '230108', '平新镇', '1', '230108102', null, '3', '1'),
('230109001', '230109', '三电街道', '1', '230109001', null, '3', '1'),
('230109002', '230109', '太阳岛街道', '1', '230109002', null, '3', '1'),
('230109003', '230109', '松浦街道', '1', '230109003', null, '3', '1'),
('230109004', '230109', '万宝街道', '1', '230109004', null, '3', '1'),
('230109005', '230109', '松北街道', '1', '230109005', null, '3', '1'),
('230109101', '230109', '对青山镇', '1', '230109101', null, '3', '1'),
('230109102', '230109', '乐业镇', '1', '230109102', null, '3', '1'),
('230110001', '230110', '香坊大街街道', '1', '230110001', null, '3', '1'),
('230110002', '230110', '安埠街道', '1', '230110002', null, '3', '1'),
('230110003', '230110', '通天街道', '1', '230110003', null, '3', '1'),
('230110004', '230110', '新香坊街道', '1', '230110004', null, '3', '1'),
('230110005', '230110', '铁东街道', '1', '230110005', null, '3', '1'),
('230110006', '230110', '新成街道', '1', '230110006', null, '3', '1'),
('230110007', '230110', '红旗街道', '1', '230110007', null, '3', '1'),
('230110008', '230110', '六顺街道', '1', '230110008', null, '3', '1'),
('230110009', '230110', '建筑街道', '1', '230110009', null, '3', '1'),
('230110010', '230110', '哈平路街道', '1', '230110010', null, '3', '1'),
('230110011', '230110', '安乐街道', '1', '230110011', null, '3', '1'),
('230110012', '230110', '健康路街道', '1', '230110012', null, '3', '1'),
('230110013', '230110', '大庆路街道', '1', '230110013', null, '3', '1'),
('230110014', '230110', '进乡街道', '1', '230110014', null, '3', '1'),
('230110015', '230110', '通乡街道', '1', '230110015', null, '3', '1'),
('230110016', '230110', '和平路街道', '1', '230110016', null, '3', '1'),
('230110017', '230110', '民生路街道', '1', '230110017', null, '3', '1'),
('230110018', '230110', '文政街道', '1', '230110018', null, '3', '1'),
('230110019', '230110', '王兆街道', '1', '230110019', null, '3', '1'),
('230110020', '230110', '黎明街道', '1', '230110020', null, '3', '1'),
('230110101', '230110', '成高子镇', '1', '230110101', null, '3', '1'),
('230110102', '230110', '幸福镇', '1', '230110102', null, '3', '1'),
('230110103', '230110', '朝阳镇', '1', '230110103', null, '3', '1'),
('230110201', '230110', '向阳乡', '1', '230110201', null, '3', '1'),
('230110500', '230110', '香坊实验农场', '1', '230110500', null, '3', '1'),
('230111001', '230111', '呼兰街道', '1', '230111001', null, '3', '1'),
('230111002', '230111', '兰河街道', '1', '230111002', null, '3', '1'),
('230111003', '230111', '利民街道', '1', '230111003', null, '3', '1'),
('230111004', '230111', '腰卜街道', '1', '230111004', null, '3', '1'),
('230111101', '230111', '康金镇', '1', '230111101', null, '3', '1'),
('230111104', '230111', '沈家镇', '1', '230111104', null, '3', '1'),
('230111105', '230111', '二八镇', '1', '230111105', null, '3', '1'),
('230111106', '230111', '石人镇', '1', '230111106', null, '3', '1'),
('230111107', '230111', '白奎镇', '1', '230111107', null, '3', '1'),
('230111109', '230111', '方台镇', '1', '230111109', null, '3', '1'),
('230111110', '230111', '莲花镇', '1', '230111110', null, '3', '1'),
('230111111', '230111', '大用镇', '1', '230111111', null, '3', '1'),
('230111112', '230111', '双井镇', '1', '230111112', null, '3', '1'),
('230111113', '230111', '长岭镇', '1', '230111113', null, '3', '1'),
('230111201', '230111', '杨林乡', '1', '230111201', null, '3', '1'),
('230111203', '230111', '许卜乡', '1', '230111203', null, '3', '1'),
('230111205', '230111', '孟家乡', '1', '230111205', null, '3', '1'),
('230112001', '230112', '和平街道', '1', '230112001', null, '3', '1'),
('230112002', '230112', '胜利街道', '1', '230112002', null, '3', '1'),
('230112003', '230112', '通城街道', '1', '230112003', null, '3', '1'),
('230112004', '230112', '河东街道', '1', '230112004', null, '3', '1'),
('230112005', '230112', '阿什河街道', '1', '230112005', null, '3', '1'),
('230112101', '230112', '玉泉镇', '1', '230112101', null, '3', '1'),
('230112103', '230112', '蜚克图镇', '1', '230112103', null, '3', '1'),
('230112104', '230112', '亚沟镇', '1', '230112104', null, '3', '1'),
('230112105', '230112', '交界镇', '1', '230112105', null, '3', '1'),
('230112106', '230112', '小岭镇', '1', '230112106', null, '3', '1'),
('230112107', '230112', '平山镇', '1', '230112107', null, '3', '1'),
('230112108', '230112', '松峰山镇', '1', '230112108', null, '3', '1'),
('230112110', '230112', '新华镇', '1', '230112110', null, '3', '1'),
('230112111', '230112', '双丰镇', '1', '230112111', null, '3', '1'),
('230112202', '230112', '杨树乡', '1', '230112202', null, '3', '1'),
('230112204', '230112', '舍利乡', '1', '230112204', null, '3', '1'),
('230112205', '230112', '料甸满族乡', '1', '230112205', null, '3', '1'),
('230112206', '230112', '红星乡', '1', '230112206', null, '3', '1'),
('230112207', '230112', '大岭乡', '1', '230112207', null, '3', '1'),
('230123100', '230123', '依兰镇', '1', '230123100', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('230123101', '230123', '达连河镇', '1', '230123101', null, '3', '1'),
('230123102', '230123', '江湾镇', '1', '230123102', null, '3', '1'),
('230123103', '230123', '三道岗镇', '1', '230123103', null, '3', '1'),
('230123104', '230123', '道台桥镇', '1', '230123104', null, '3', '1'),
('230123105', '230123', '宏克利镇', '1', '230123105', null, '3', '1'),
('230123200', '230123', '团山子乡', '1', '230123200', null, '3', '1'),
('230123201', '230123', '愚公乡', '1', '230123201', null, '3', '1'),
('230123202', '230123', '迎兰朝鲜族乡', '1', '230123202', null, '3', '1'),
('230123400', '230123', '依兰县林业局', '1', '230123400', null, '3', '1'),
('230123500', '230123', '依兰农场', '1', '230123500', null, '3', '1'),
('230123501', '230123', '松花江农场', '1', '230123501', null, '3', '1'),
('230123580', '230123', '红旗良种厂', '1', '230123580', null, '3', '1'),
('230123581', '230123', '依兰县农委', '1', '230123581', null, '3', '1'),
('230124100', '230124', '方正镇', '1', '230124100', null, '3', '1'),
('230124101', '230124', '会发镇', '1', '230124101', null, '3', '1'),
('230124102', '230124', '大罗密镇', '1', '230124102', null, '3', '1'),
('230124200', '230124', '天门乡', '1', '230124200', null, '3', '1'),
('230124201', '230124', '松南乡', '1', '230124201', null, '3', '1'),
('230124202', '230124', '德善乡', '1', '230124202', null, '3', '1'),
('230124204', '230124', '宝兴乡', '1', '230124204', null, '3', '1'),
('230124205', '230124', '伊汉通乡', '1', '230124205', null, '3', '1'),
('230124400', '230124', '方正林业局', '1', '230124400', null, '3', '1'),
('230124500', '230124', '沙河农场', '1', '230124500', null, '3', '1'),
('230125100', '230125', '宾州镇', '1', '230125100', null, '3', '1'),
('230125101', '230125', '居仁镇', '1', '230125101', null, '3', '1'),
('230125102', '230125', '宾西镇', '1', '230125102', null, '3', '1'),
('230125103', '230125', '糖坊镇', '1', '230125103', null, '3', '1'),
('230125104', '230125', '宾安镇', '1', '230125104', null, '3', '1'),
('230125105', '230125', '新甸镇', '1', '230125105', null, '3', '1'),
('230125106', '230125', '胜利镇', '1', '230125106', null, '3', '1'),
('230125107', '230125', '宁远镇', '1', '230125107', null, '3', '1'),
('230125109', '230125', '摆渡镇', '1', '230125109', null, '3', '1'),
('230125110', '230125', '平坊镇', '1', '230125110', null, '3', '1'),
('230125111', '230125', '满井镇', '1', '230125111', null, '3', '1'),
('230125112', '230125', '常安镇', '1', '230125112', null, '3', '1'),
('230125201', '230125', '永和乡', '1', '230125201', null, '3', '1'),
('230125203', '230125', '鸟河乡', '1', '230125203', null, '3', '1'),
('230125204', '230125', '民和乡', '1', '230125204', null, '3', '1'),
('230125205', '230125', '经建乡', '1', '230125205', null, '3', '1'),
('230125210', '230125', '三宝乡', '1', '230125210', null, '3', '1'),
('230126100', '230126', '巴彦镇', '1', '230126100', null, '3', '1'),
('230126101', '230126', '兴隆镇', '1', '230126101', null, '3', '1'),
('230126102', '230126', '西集镇', '1', '230126102', null, '3', '1'),
('230126103', '230126', '洼兴镇', '1', '230126103', null, '3', '1'),
('230126104', '230126', '龙泉镇', '1', '230126104', null, '3', '1'),
('230126105', '230126', '巴彦港镇', '1', '230126105', null, '3', '1'),
('230126106', '230126', '龙庙镇', '1', '230126106', null, '3', '1'),
('230126107', '230126', '万发镇', '1', '230126107', null, '3', '1'),
('230126108', '230126', '天增镇', '1', '230126108', null, '3', '1'),
('230126110', '230126', '黑山镇', '1', '230126110', null, '3', '1'),
('230126200', '230126', '松花江乡', '1', '230126200', null, '3', '1'),
('230126202', '230126', '富江乡', '1', '230126202', null, '3', '1'),
('230126204', '230126', '华山乡', '1', '230126204', null, '3', '1'),
('230126205', '230126', '丰乐乡', '1', '230126205', null, '3', '1'),
('230126209', '230126', '德祥乡', '1', '230126209', null, '3', '1'),
('230126210', '230126', '红光乡', '1', '230126210', null, '3', '1'),
('230126212', '230126', '山后乡', '1', '230126212', null, '3', '1'),
('230126214', '230126', '镇东乡', '1', '230126214', null, '3', '1'),
('230126400', '230126', '兴隆林业局', '1', '230126400', null, '3', '1'),
('230127100', '230127', '木兰镇', '1', '230127100', null, '3', '1'),
('230127101', '230127', '东兴镇', '1', '230127101', null, '3', '1'),
('230127102', '230127', '大贵镇', '1', '230127102', null, '3', '1'),
('230127103', '230127', '利东镇', '1', '230127103', null, '3', '1'),
('230127104', '230127', '柳河镇', '1', '230127104', null, '3', '1'),
('230127105', '230127', '新民镇', '1', '230127105', null, '3', '1'),
('230127200', '230127', '建国乡', '1', '230127200', null, '3', '1'),
('230127203', '230127', '吉兴乡', '1', '230127203', null, '3', '1'),
('230127400', '230127', '兴隆林业局', '1', '230127400', null, '3', '1'),
('230128100', '230128', '通河镇', '1', '230128100', null, '3', '1'),
('230128101', '230128', '乌鸦泡镇', '1', '230128101', null, '3', '1'),
('230128102', '230128', '清河镇', '1', '230128102', null, '3', '1'),
('230128103', '230128', '浓河镇', '1', '230128103', null, '3', '1'),
('230128104', '230128', '凤山镇', '1', '230128104', null, '3', '1'),
('230128105', '230128', '祥顺镇', '1', '230128105', null, '3', '1'),
('230128201', '230128', '三站乡', '1', '230128201', null, '3', '1'),
('230128202', '230128', '富林乡', '1', '230128202', null, '3', '1'),
('230128400', '230128', '清河林业局', '1', '230128400', null, '3', '1'),
('230128401', '230128', '兴隆林业局', '1', '230128401', null, '3', '1'),
('230128500', '230128', '岔林河农场', '1', '230128500', null, '3', '1'),
('230129100', '230129', '延寿镇', '1', '230129100', null, '3', '1'),
('230129101', '230129', '六团镇', '1', '230129101', null, '3', '1'),
('230129102', '230129', '中和镇', '1', '230129102', null, '3', '1'),
('230129103', '230129', '加信镇', '1', '230129103', null, '3', '1'),
('230129104', '230129', '延河镇', '1', '230129104', null, '3', '1'),
('230129204', '230129', '安山乡', '1', '230129204', null, '3', '1'),
('230129205', '230129', '寿山乡', '1', '230129205', null, '3', '1'),
('230129206', '230129', '玉河乡', '1', '230129206', null, '3', '1'),
('230129209', '230129', '青川乡', '1', '230129209', null, '3', '1'),
('230129400', '230129', '太平川', '1', '230129400', null, '3', '1'),
('230129500', '230129', '庆阳农场', '1', '230129500', null, '3', '1'),
('230182001', '230182', '双城市街道社区管委会', '1', '230182001', null, '3', '1'),
('230182100', '230182', '双城镇', '1', '230182100', null, '3', '1'),
('230182101', '230182', '兰棱镇', '1', '230182101', null, '3', '1'),
('230182102', '230182', '周家镇', '1', '230182102', null, '3', '1'),
('230182103', '230182', '五家镇', '1', '230182103', null, '3', '1'),
('230182104', '230182', '韩甸镇', '1', '230182104', null, '3', '1'),
('230182105', '230182', '单城镇', '1', '230182105', null, '3', '1'),
('230182106', '230182', '东官镇', '1', '230182106', null, '3', '1'),
('230182107', '230182', '农丰满族锡伯族镇', '1', '230182107', null, '3', '1'),
('230182108', '230182', '杏山镇', '1', '230182108', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('230182200', '230182', '朝阳乡', '1', '230182200', null, '3', '1'),
('230182201', '230182', '金城乡', '1', '230182201', null, '3', '1'),
('230182203', '230182', '青岭满族乡', '1', '230182203', null, '3', '1'),
('230182204', '230182', '联兴满族乡', '1', '230182204', null, '3', '1'),
('230182205', '230182', '幸福满族乡', '1', '230182205', null, '3', '1'),
('230182206', '230182', '新兴满族乡', '1', '230182206', null, '3', '1'),
('230182207', '230182', '公正满族乡', '1', '230182207', null, '3', '1'),
('230182208', '230182', '永胜乡', '1', '230182208', null, '3', '1'),
('230182209', '230182', '临江乡', '1', '230182209', null, '3', '1'),
('230182210', '230182', '水泉乡', '1', '230182210', null, '3', '1'),
('230182211', '230182', '乐群满族乡', '1', '230182211', null, '3', '1'),
('230182213', '230182', '团结满族乡', '1', '230182213', null, '3', '1'),
('230182214', '230182', '万隆乡', '1', '230182214', null, '3', '1'),
('230182216', '230182', '希勤满族乡', '1', '230182216', null, '3', '1'),
('230182217', '230182', '同心满族乡', '1', '230182217', null, '3', '1'),
('230183100', '230183', '尚志镇', '1', '230183100', null, '3', '1'),
('230183101', '230183', '一面坡镇', '1', '230183101', null, '3', '1'),
('230183102', '230183', '苇河镇', '1', '230183102', null, '3', '1'),
('230183103', '230183', '亚布力镇', '1', '230183103', null, '3', '1'),
('230183104', '230183', '帽儿山镇', '1', '230183104', null, '3', '1'),
('230183105', '230183', '亮河镇', '1', '230183105', null, '3', '1'),
('230183106', '230183', '庆阳镇', '1', '230183106', null, '3', '1'),
('230183107', '230183', '石头河子镇', '1', '230183107', null, '3', '1'),
('230183108', '230183', '元宝镇', '1', '230183108', null, '3', '1'),
('230183109', '230183', '黑龙宫镇', '1', '230183109', null, '3', '1'),
('230183202', '230183', '长寿乡', '1', '230183202', null, '3', '1'),
('230183204', '230183', '乌吉密乡', '1', '230183204', null, '3', '1'),
('230183206', '230183', '鱼池乡', '1', '230183206', null, '3', '1'),
('230183207', '230183', '珍珠山乡', '1', '230183207', null, '3', '1'),
('230183208', '230183', '老街基乡', '1', '230183208', null, '3', '1'),
('230183209', '230183', '马延乡', '1', '230183209', null, '3', '1'),
('230183211', '230183', '河东乡', '1', '230183211', null, '3', '1'),
('230183400', '230183', '苇河林业局', '1', '230183400', null, '3', '1'),
('230183401', '230183', '亚布力林业局', '1', '230183401', null, '3', '1'),
('230184100', '230184', '五常镇', '1', '230184100', null, '3', '1'),
('230184101', '230184', '拉林满族镇', '1', '230184101', null, '3', '1'),
('230184102', '230184', '山河镇', '1', '230184102', null, '3', '1'),
('230184103', '230184', '小山子镇', '1', '230184103', null, '3', '1'),
('230184104', '230184', '安家镇', '1', '230184104', null, '3', '1'),
('230184105', '230184', '牛家满族镇', '1', '230184105', null, '3', '1'),
('230184106', '230184', '杜家镇', '1', '230184106', null, '3', '1'),
('230184107', '230184', '背荫河镇', '1', '230184107', null, '3', '1'),
('230184108', '230184', '冲河镇', '1', '230184108', null, '3', '1'),
('230184109', '230184', '沙河子镇', '1', '230184109', null, '3', '1'),
('230184110', '230184', '向阳镇', '1', '230184110', null, '3', '1'),
('230184200', '230184', '兴盛乡', '1', '230184200', null, '3', '1'),
('230184201', '230184', '志广乡', '1', '230184201', null, '3', '1'),
('230184202', '230184', '卫国乡', '1', '230184202', null, '3', '1'),
('230184203', '230184', '常堡乡', '1', '230184203', null, '3', '1'),
('230184206', '230184', '民意乡', '1', '230184206', null, '3', '1'),
('230184207', '230184', '龙凤山乡', '1', '230184207', null, '3', '1'),
('230184209', '230184', '红旗满族乡', '1', '230184209', null, '3', '1'),
('230184210', '230184', '八家子乡', '1', '230184210', null, '3', '1'),
('230184211', '230184', '民乐朝鲜族乡', '1', '230184211', null, '3', '1'),
('230184212', '230184', '营城子满族乡', '1', '230184212', null, '3', '1'),
('230184214', '230184', '长山乡', '1', '230184214', null, '3', '1'),
('230184215', '230184', '兴隆乡', '1', '230184215', null, '3', '1'),
('230184216', '230184', '二河乡', '1', '230184216', null, '3', '1'),
('230184400', '230184', '山河屯林业局', '1', '230184400', null, '3', '1'),
('230202001', '230202', '五龙街道', '1', '230202001', null, '3', '1'),
('230202002', '230202', '湖滨街道', '1', '230202002', null, '3', '1'),
('230202003', '230202', '江安街道', '1', '230202003', null, '3', '1'),
('230202004', '230202', '正阳街道', '1', '230202004', null, '3', '1'),
('230202005', '230202', '彩虹街道', '1', '230202005', null, '3', '1'),
('230202006', '230202', '南航街道', '1', '230202006', null, '3', '1'),
('230202198', '230202', '龙沙区直辖地域', '1', '230202198', null, '3', '1'),
('230203003', '230203', '中华街道', '1', '230203003', null, '3', '1'),
('230203004', '230203', '西大桥街道', '1', '230203004', null, '3', '1'),
('230203005', '230203', '卜奎街道', '1', '230203005', null, '3', '1'),
('230203006', '230203', '建设街道', '1', '230203006', null, '3', '1'),
('230203007', '230203', '文化街道', '1', '230203007', null, '3', '1'),
('230203198', '230203', '建华区直辖地域', '1', '230203198', null, '3', '1'),
('230204001', '230204', '站前街道', '1', '230204001', null, '3', '1'),
('230204002', '230204', '南浦街道', '1', '230204002', null, '3', '1'),
('230204003', '230204', '通东街道', '1', '230204003', null, '3', '1'),
('230204004', '230204', '光荣街道', '1', '230204004', null, '3', '1'),
('230204005', '230204', '龙华街道', '1', '230204005', null, '3', '1'),
('230204006', '230204', '北局宅街道', '1', '230204006', null, '3', '1'),
('230204008', '230204', '东湖街道', '1', '230204008', null, '3', '1'),
('230204200', '230204', '扎龙乡', '1', '230204200', null, '3', '1'),
('230204580', '230204', '齐齐哈尔种畜场', '1', '230204580', null, '3', '1'),
('230205001', '230205', '新兴街道', '1', '230205001', null, '3', '1'),
('230205002', '230205', '新建街道', '1', '230205002', null, '3', '1'),
('230205005', '230205', '林机街道', '1', '230205005', null, '3', '1'),
('230205006', '230205', '道北街道', '1', '230205006', null, '3', '1'),
('230205100', '230205', '水师营满族镇', '1', '230205100', null, '3', '1'),
('230205102', '230205', '三间房镇', '1', '230205102', null, '3', '1'),
('230206001', '230206', '红岸街道', '1', '230206001', null, '3', '1'),
('230206003', '230206', '沿江街道', '1', '230206003', null, '3', '1'),
('230206004', '230206', '电力街道', '1', '230206004', null, '3', '1'),
('230206005', '230206', '幸福街道', '1', '230206005', null, '3', '1'),
('230206006', '230206', '红宝石街道', '1', '230206006', null, '3', '1'),
('230206007', '230206', '北兴街道', '1', '230206007', null, '3', '1'),
('230206008', '230206', '铁北街道', '1', '230206008', null, '3', '1'),
('230206200', '230206', '长青乡', '1', '230206200', null, '3', '1'),
('230206202', '230206', '杜尔门沁达翰尔族乡', '1', '230206202', null, '3', '1'),
('230207001', '230207', '东安街道', '1', '230207001', null, '3', '1'),
('230207002', '230207', '富强街道', '1', '230207002', null, '3', '1'),
('230207003', '230207', '跃进街道', '1', '230207003', null, '3', '1'),
('230207004', '230207', '繁荣街道', '1', '230207004', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('230207198', '230207', '碾子山区直辖地域', '1', '230207198', null, '3', '1'),
('230208001', '230208', '梅里斯街道', '1', '230208001', null, '3', '1'),
('230208101', '230208', '雅尔塞镇', '1', '230208101', null, '3', '1'),
('230208102', '230208', '卧牛吐镇', '1', '230208102', null, '3', '1'),
('230208103', '230208', '达呼店镇', '1', '230208103', null, '3', '1'),
('230208104', '230208', '共和镇', '1', '230208104', null, '3', '1'),
('230208200', '230208', '莽格吐乡', '1', '230208200', null, '3', '1'),
('230208201', '230208', '梅里斯乡', '1', '230208201', null, '3', '1'),
('230208501', '230208', '哈拉海农场', '1', '230208501', null, '3', '1'),
('230221100', '230221', '龙江镇', '1', '230221100', null, '3', '1'),
('230221101', '230221', '景星镇', '1', '230221101', null, '3', '1'),
('230221102', '230221', '龙兴镇', '1', '230221102', null, '3', '1'),
('230221103', '230221', '山泉镇', '1', '230221103', null, '3', '1'),
('230221104', '230221', '七棵树镇', '1', '230221104', null, '3', '1'),
('230221200', '230221', '白山乡', '1', '230221200', null, '3', '1'),
('230221201', '230221', '黑岗乡', '1', '230221201', null, '3', '1'),
('230221202', '230221', '广厚乡', '1', '230221202', null, '3', '1'),
('230221203', '230221', '华民乡', '1', '230221203', null, '3', '1'),
('230221204', '230221', '哈拉海乡', '1', '230221204', null, '3', '1'),
('230221211', '230221', '杏山乡', '1', '230221211', null, '3', '1'),
('230221214', '230221', '头站乡', '1', '230221214', null, '3', '1'),
('230221215', '230221', '鲁河乡', '1', '230221215', null, '3', '1'),
('230221217', '230221', '济沁河乡', '1', '230221217', null, '3', '1'),
('230223100', '230223', '依安镇', '1', '230223100', null, '3', '1'),
('230223101', '230223', '依龙镇', '1', '230223101', null, '3', '1'),
('230223102', '230223', '双阳镇', '1', '230223102', null, '3', '1'),
('230223103', '230223', '三兴镇', '1', '230223103', null, '3', '1'),
('230223104', '230223', '中心镇', '1', '230223104', null, '3', '1'),
('230223200', '230223', '富饶乡', '1', '230223200', null, '3', '1'),
('230223201', '230223', '解放乡', '1', '230223201', null, '3', '1'),
('230223202', '230223', '阳春乡', '1', '230223202', null, '3', '1'),
('230223203', '230223', '新发乡', '1', '230223203', null, '3', '1'),
('230223204', '230223', '太东乡', '1', '230223204', null, '3', '1'),
('230223205', '230223', '上游乡', '1', '230223205', null, '3', '1'),
('230223206', '230223', '红星乡', '1', '230223206', null, '3', '1'),
('230223207', '230223', '先锋乡', '1', '230223207', null, '3', '1'),
('230223208', '230223', '新屯乡', '1', '230223208', null, '3', '1'),
('230223210', '230223', '新兴乡', '1', '230223210', null, '3', '1'),
('230223500', '230223', '依安农场', '1', '230223500', null, '3', '1'),
('230223580', '230223', '黑龙江红旗马场', '1', '230223580', null, '3', '1'),
('230224100', '230224', '泰来镇', '1', '230224100', null, '3', '1'),
('230224101', '230224', '平洋镇', '1', '230224101', null, '3', '1'),
('230224102', '230224', '汤池镇', '1', '230224102', null, '3', '1'),
('230224103', '230224', '江桥蒙古族镇', '1', '230224103', null, '3', '1'),
('230224104', '230224', '塔子城镇', '1', '230224104', null, '3', '1'),
('230224105', '230224', '大兴镇', '1', '230224105', null, '3', '1'),
('230224106', '230224', '和平镇', '1', '230224106', null, '3', '1'),
('230224107', '230224', '克利镇', '1', '230224107', null, '3', '1'),
('230224200', '230224', '胜利蒙古族乡', '1', '230224200', null, '3', '1'),
('230224209', '230224', '宁姜蒙古族乡', '1', '230224209', null, '3', '1'),
('230224400', '230224', '葡萄场', '1', '230224400', null, '3', '1'),
('230224401', '230224', '果树场', '1', '230224401', null, '3', '1'),
('230224402', '230224', '泰来县一苗圃', '1', '230224402', null, '3', '1'),
('230224403', '230224', '泰来县二苗圃', '1', '230224403', null, '3', '1'),
('230224404', '230224', '东方红机械林场', '1', '230224404', null, '3', '1'),
('230224500', '230224', '泰来农场', '1', '230224500', null, '3', '1'),
('230224580', '230224', '第一良种场', '1', '230224580', null, '3', '1'),
('230224581', '230224', '第二良种场', '1', '230224581', null, '3', '1'),
('230224582', '230224', '宏胜种畜场', '1', '230224582', null, '3', '1'),
('230224583', '230224', '二龙涛农场', '1', '230224583', null, '3', '1'),
('230224584', '230224', '六三监狱', '1', '230224584', null, '3', '1'),
('230225100', '230225', '甘南镇', '1', '230225100', null, '3', '1'),
('230225101', '230225', '音河镇', '1', '230225101', null, '3', '1'),
('230225102', '230225', '平阳镇', '1', '230225102', null, '3', '1'),
('230225103', '230225', '东阳镇', '1', '230225103', null, '3', '1'),
('230225104', '230225', '巨宝镇', '1', '230225104', null, '3', '1'),
('230225201', '230225', '长山乡', '1', '230225201', null, '3', '1'),
('230225202', '230225', '中兴乡', '1', '230225202', null, '3', '1'),
('230225203', '230225', '兴隆乡', '1', '230225203', null, '3', '1'),
('230225204', '230225', '宝山乡', '1', '230225204', null, '3', '1'),
('230225206', '230225', '查哈阳乡', '1', '230225206', null, '3', '1'),
('230225500', '230225', '查哈阳农场', '1', '230225500', null, '3', '1'),
('230225580', '230225', '北京市双河农场', '1', '230225580', null, '3', '1'),
('230227100', '230227', '富裕镇', '1', '230227100', null, '3', '1'),
('230227101', '230227', '富路镇', '1', '230227101', null, '3', '1'),
('230227102', '230227', '富海镇', '1', '230227102', null, '3', '1'),
('230227103', '230227', '二道湾镇', '1', '230227103', null, '3', '1'),
('230227104', '230227', '龙安桥镇', '1', '230227104', null, '3', '1'),
('230227200', '230227', '繁荣乡', '1', '230227200', null, '3', '1'),
('230227201', '230227', '绍文乡', '1', '230227201', null, '3', '1'),
('230227202', '230227', '忠厚乡', '1', '230227202', null, '3', '1'),
('230227203', '230227', '友谊乡', '1', '230227203', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('230227204', '230227', '塔哈乡', '1', '230227204', null, '3', '1'),
('230227500', '230227', '富裕牧场', '1', '230227500', null, '3', '1'),
('230227580', '230227', '繁荣种畜场', '1', '230227580', null, '3', '1'),
('230229100', '230229', '克山镇', '1', '230229100', null, '3', '1'),
('230229101', '230229', '北兴镇', '1', '230229101', null, '3', '1'),
('230229102', '230229', '西城镇', '1', '230229102', null, '3', '1'),
('230229103', '230229', '古城镇', '1', '230229103', null, '3', '1'),
('230229104', '230229', '北联镇', '1', '230229104', null, '3', '1'),
('230229105', '230229', '西河镇', '1', '230229105', null, '3', '1'),
('230229200', '230229', '河南乡', '1', '230229200', null, '3', '1'),
('230229201', '230229', '双河乡', '1', '230229201', null, '3', '1'),
('230229203', '230229', '河北乡', '1', '230229203', null, '3', '1'),
('230229204', '230229', '古北乡', '1', '230229204', null, '3', '1'),
('230229205', '230229', '西联乡', '1', '230229205', null, '3', '1'),
('230229206', '230229', '发展乡', '1', '230229206', null, '3', '1'),
('230229207', '230229', '西建乡', '1', '230229207', null, '3', '1'),
('230229208', '230229', '向华乡', '1', '230229208', null, '3', '1'),
('230229210', '230229', '曙光乡', '1', '230229210', null, '3', '1'),
('230229400', '230229', '克山县河北林场', '1', '230229400', null, '3', '1'),
('230229401', '230229', '克山县涌泉林场', '1', '230229401', null, '3', '1'),
('230229402', '230229', '克山县北联林场', '1', '230229402', null, '3', '1'),
('230229500', '230229', '克山农场', '1', '230229500', null, '3', '1'),
('230229580', '230229', '克山县第一良种场', '1', '230229580', null, '3', '1'),
('230229581', '230229', '克山县第二良种场', '1', '230229581', null, '3', '1'),
('230229582', '230229', '克山县种畜场', '1', '230229582', null, '3', '1'),
('230229583', '230229', '克山县种猪场', '1', '230229583', null, '3', '1'),
('230230100', '230230', '克东镇', '1', '230230100', null, '3', '1'),
('230230101', '230230', '宝泉镇', '1', '230230101', null, '3', '1'),
('230230102', '230230', '乾丰镇', '1', '230230102', null, '3', '1'),
('230230103', '230230', '玉岗镇', '1', '230230103', null, '3', '1'),
('230230200', '230230', '金城乡', '1', '230230200', null, '3', '1'),
('230230202', '230230', '润津乡', '1', '230230202', null, '3', '1'),
('230230204', '230230', '昌盛乡', '1', '230230204', null, '3', '1'),
('230230400', '230230', '第一苗圃', '1', '230230400', null, '3', '1'),
('230230401', '230230', '第二苗圃', '1', '230230401', null, '3', '1'),
('230230402', '230230', '爱华林场', '1', '230230402', null, '3', '1'),
('230230403', '230230', '发展林场', '1', '230230403', null, '3', '1'),
('230230404', '230230', '东兴林场', '1', '230230404', null, '3', '1'),
('230230580', '230230', '红旗奶山羊场', '1', '230230580', null, '3', '1'),
('230230581', '230230', '第一良种场', '1', '230230581', null, '3', '1'),
('230230582', '230230', '第二良种繁殖场', '1', '230230582', null, '3', '1'),
('230230583', '230230', '果树繁殖场', '1', '230230583', null, '3', '1'),
('230230584', '230230', '种猪场', '1', '230230584', null, '3', '1'),
('230230585', '230230', '建业农场', '1', '230230585', null, '3', '1'),
('230231100', '230231', '拜泉镇', '1', '230231100', null, '3', '1'),
('230231101', '230231', '三道镇', '1', '230231101', null, '3', '1'),
('230231102', '230231', '兴农镇', '1', '230231102', null, '3', '1'),
('230231103', '230231', '长春镇', '1', '230231103', null, '3', '1'),
('230231104', '230231', '龙泉镇', '1', '230231104', null, '3', '1'),
('230231105', '230231', '国富镇', '1', '230231105', null, '3', '1'),
('230231106', '230231', '富强镇', '1', '230231106', null, '3', '1'),
('230231200', '230231', '新生乡', '1', '230231200', null, '3', '1'),
('230231201', '230231', '兴国乡', '1', '230231201', null, '3', '1'),
('230231203', '230231', '上升乡', '1', '230231203', null, '3', '1'),
('230231204', '230231', '兴华乡', '1', '230231204', null, '3', '1'),
('230231206', '230231', '大众乡', '1', '230231206', null, '3', '1'),
('230231209', '230231', '丰产乡', '1', '230231209', null, '3', '1'),
('230231210', '230231', '永勤乡', '1', '230231210', null, '3', '1'),
('230231212', '230231', '爱农乡', '1', '230231212', null, '3', '1'),
('230231214', '230231', '时中乡', '1', '230231214', null, '3', '1'),
('230281100', '230281', '讷河镇', '1', '230281100', null, '3', '1'),
('230281101', '230281', '拉哈镇', '1', '230281101', null, '3', '1'),
('230281102', '230281', '二克浅镇', '1', '230281102', null, '3', '1'),
('230281103', '230281', '学田镇', '1', '230281103', null, '3', '1'),
('230281104', '230281', '龙河镇', '1', '230281104', null, '3', '1'),
('230281105', '230281', '讷南镇', '1', '230281105', null, '3', '1'),
('230281106', '230281', '六合镇', '1', '230281106', null, '3', '1'),
('230281107', '230281', '长发镇', '1', '230281107', null, '3', '1'),
('230281108', '230281', '通南镇', '1', '230281108', null, '3', '1'),
('230281109', '230281', '同义镇', '1', '230281109', null, '3', '1'),
('230281110', '230281', '九井镇', '1', '230281110', null, '3', '1'),
('230281111', '230281', '老莱镇', '1', '230281111', null, '3', '1'),
('230281201', '230281', '孔国乡', '1', '230281201', null, '3', '1'),
('230281207', '230281', '和盛乡', '1', '230281207', null, '3', '1'),
('230281208', '230281', '同心乡', '1', '230281208', null, '3', '1'),
('230281210', '230281', '兴旺鄂温克族乡', '1', '230281210', null, '3', '1'),
('230281400', '230281', '龙河镇保安林场', '1', '230281400', null, '3', '1'),
('230281401', '230281', '龙河镇茂山林场', '1', '230281401', null, '3', '1'),
('230281402', '230281', '龙河镇国庆林场', '1', '230281402', null, '3', '1'),
('230281403', '230281', '学田镇富源林场', '1', '230281403', null, '3', '1'),
('230281404', '230281', '老莱镇宽余林场', '1', '230281404', null, '3', '1'),
('230281405', '230281', '新江林场', '1', '230281405', null, '3', '1'),
('230281406', '230281', '讷河镇一良苗圃', '1', '230281406', null, '3', '1'),
('230281580', '230281', '黑龙江省老莱监狱', '1', '230281580', null, '3', '1'),
('230281581', '230281', '六合镇黎明奶牛场', '1', '230281581', null, '3', '1'),
('230281582', '230281', '孔国乡进化种猪场', '1', '230281582', null, '3', '1'),
('230281583', '230281', '二克浅镇二里种畜场', '1', '230281583', null, '3', '1'),
('230281584', '230281', '龙河镇青色草原种畜场', '1', '230281584', null, '3', '1'),
('230281585', '230281', '第一良种场', '1', '230281585', null, '3', '1'),
('230281586', '230281', '第二良种场', '1', '230281586', null, '3', '1'),
('230281587', '230281', '第三良种场', '1', '230281587', null, '3', '1'),
('230281588', '230281', '第四良种场', '1', '230281588', null, '3', '1'),
('230302001', '230302', '向阳街道', '1', '230302001', null, '3', '1'),
('230302002', '230302', '南山街道', '1', '230302002', null, '3', '1'),
('230302003', '230302', '立新街道', '1', '230302003', null, '3', '1'),
('230302004', '230302', '东风街道', '1', '230302004', null, '3', '1'),
('230302005', '230302', '红军路街道', '1', '230302005', null, '3', '1'),
('230302006', '230302', '西鸡西街道', '1', '230302006', null, '3', '1'),
('230302007', '230302', '西山街道', '1', '230302007', null, '3', '1'),
('230302200', '230302', '红星乡', '1', '230302200', null, '3', '1'),
('230302201', '230302', '西郊乡', '1', '230302201', null, '3', '1'),
('230303001', '230303', '桦木林街道', '1', '230303001', null, '3', '1'),
('230303002', '230303', '大恒山街道', '1', '230303002', null, '3', '1'),
('230303003', '230303', '小恒山街道', '1', '230303003', null, '3', '1'),
('230303004', '230303', '二道河子街道', '1', '230303004', null, '3', '1'),
('230303005', '230303', '张新街道', '1', '230303005', null, '3', '1'),
('230303006', '230303', '奋斗街道', '1', '230303006', null, '3', '1'),
('230303007', '230303', '柳毛街道', '1', '230303007', null, '3', '1'),
('230303200', '230303', '红旗乡', '1', '230303200', null, '3', '1'),
('230303201', '230303', '柳毛乡', '1', '230303201', null, '3', '1'),
('230304001', '230304', '东兴街道', '1', '230304001', null, '3', '1'),
('230304002', '230304', '矿里街道', '1', '230304002', null, '3', '1'),
('230304003', '230304', '洗煤街道', '1', '230304003', null, '3', '1'),
('230304004', '230304', '大通沟街道', '1', '230304004', null, '3', '1'),
('230304200', '230304', '滴道河乡', '1', '230304200', null, '3', '1'),
('230304201', '230304', '兰岭乡', '1', '230304201', null, '3', '1'),
('230305001', '230305', '街里街道', '1', '230305001', null, '3', '1'),
('230305002', '230305', '穆棱街道', '1', '230305002', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('230305003', '230305', '平岗街道', '1', '230305003', null, '3', '1'),
('230305004', '230305', '碱场街道', '1', '230305004', null, '3', '1'),
('230305005', '230305', '石磷街道', '1', '230305005', null, '3', '1'),
('230305198', '230305', '梨树区直辖地域', '1', '230305198', null, '3', '1'),
('230306001', '230306', '城子河街道', '1', '230306001', null, '3', '1'),
('230306002', '230306', '正阳街道', '1', '230306002', null, '3', '1'),
('230306003', '230306', '东海街道', '1', '230306003', null, '3', '1'),
('230306004', '230306', '城西街道', '1', '230306004', null, '3', '1'),
('230306005', '230306', '杏花街道', '1', '230306005', null, '3', '1'),
('230306200', '230306', '长青乡', '1', '230306200', null, '3', '1'),
('230306201', '230306', '永丰乡', '1', '230306201', null, '3', '1'),
('230307001', '230307', '麻山街道', '1', '230307001', null, '3', '1'),
('230307198', '230307', '麻山区直辖地域', '1', '230307198', null, '3', '1'),
('230321100', '230321', '鸡东镇', '1', '230321100', null, '3', '1'),
('230321101', '230321', '平阳镇', '1', '230321101', null, '3', '1'),
('230321102', '230321', '向阳镇', '1', '230321102', null, '3', '1'),
('230321103', '230321', '哈达镇', '1', '230321103', null, '3', '1'),
('230321104', '230321', '永安镇', '1', '230321104', null, '3', '1'),
('230321105', '230321', '永和镇', '1', '230321105', null, '3', '1'),
('230321106', '230321', '东海镇', '1', '230321106', null, '3', '1'),
('230321107', '230321', '兴农镇', '1', '230321107', null, '3', '1'),
('230321200', '230321', '鸡林乡', '1', '230321200', null, '3', '1'),
('230321205', '230321', '明德乡', '1', '230321205', null, '3', '1'),
('230321206', '230321', '下亮子乡', '1', '230321206', null, '3', '1'),
('230321400', '230321', '林业局', '1', '230321400', null, '3', '1'),
('230321500', '230321', '八五一零农场', '1', '230321500', null, '3', '1'),
('230381100', '230381', '虎林镇', '1', '230381100', null, '3', '1'),
('230381101', '230381', '东方红镇', '1', '230381101', null, '3', '1'),
('230381102', '230381', '迎春镇', '1', '230381102', null, '3', '1'),
('230381103', '230381', '虎头镇', '1', '230381103', null, '3', '1'),
('230381104', '230381', '杨岗镇', '1', '230381104', null, '3', '1'),
('230381105', '230381', '东风镇', '1', '230381105', null, '3', '1'),
('230381106', '230381', '宝东镇', '1', '230381106', null, '3', '1'),
('230381203', '230381', '新乐乡', '1', '230381203', null, '3', '1'),
('230381204', '230381', '伟光乡', '1', '230381204', null, '3', '1'),
('230381205', '230381', '忠诚乡', '1', '230381205', null, '3', '1'),
('230381206', '230381', '珍宝岛乡', '1', '230381206', null, '3', '1'),
('230381207', '230381', '阿北乡', '1', '230381207', null, '3', '1'),
('230381400', '230381', '东方红林业局', '1', '230381400', null, '3', '1'),
('230381401', '230381', '迎春林业局', '1', '230381401', null, '3', '1'),
('230381500', '230381', '八五零农场', '1', '230381500', null, '3', '1'),
('230381501', '230381', '八五四农场', '1', '230381501', null, '3', '1'),
('230381502', '230381', '八五六农场', '1', '230381502', null, '3', '1'),
('230381503', '230381', '八五八农场', '1', '230381503', null, '3', '1'),
('230381504', '230381', '庆丰农场', '1', '230381504', null, '3', '1'),
('230381505', '230381', '云山农场', '1', '230381505', null, '3', '1'),
('230382001', '230382', '中心街道', '1', '230382001', null, '3', '1'),
('230382100', '230382', '密山镇', '1', '230382100', null, '3', '1'),
('230382101', '230382', '连珠山镇', '1', '230382101', null, '3', '1'),
('230382102', '230382', '当壁镇', '1', '230382102', null, '3', '1'),
('230382103', '230382', '知一镇', '1', '230382103', null, '3', '1'),
('230382104', '230382', '黑台镇', '1', '230382104', null, '3', '1'),
('230382105', '230382', '兴凯镇', '1', '230382105', null, '3', '1'),
('230382106', '230382', '裴德镇', '1', '230382106', null, '3', '1'),
('230382200', '230382', '柳毛乡', '1', '230382200', null, '3', '1'),
('230382201', '230382', '杨木乡', '1', '230382201', null, '3', '1'),
('230382202', '230382', '兴凯湖乡', '1', '230382202', null, '3', '1'),
('230382203', '230382', '承紫河乡', '1', '230382203', null, '3', '1'),
('230382204', '230382', '白泡子乡', '1', '230382204', null, '3', '1'),
('230382206', '230382', '二人班乡', '1', '230382206', null, '3', '1'),
('230382208', '230382', '太平乡', '1', '230382208', null, '3', '1'),
('230382210', '230382', '和平乡', '1', '230382210', null, '3', '1'),
('230382212', '230382', '富源乡', '1', '230382212', null, '3', '1'),
('230382501', '230382', '牡丹江分局局直', '1', '230382501', null, '3', '1'),
('230382502', '230382', '八五五农场', '1', '230382502', null, '3', '1'),
('230382503', '230382', '八五七农场', '1', '230382503', null, '3', '1'),
('230382504', '230382', '八五一一农场', '1', '230382504', null, '3', '1'),
('230382505', '230382', '兴凯湖农场', '1', '230382505', null, '3', '1'),
('230402001', '230402', '北山街道', '1', '230402001', null, '3', '1'),
('230402002', '230402', '红军街道', '1', '230402002', null, '3', '1'),
('230402003', '230402', '光明街道', '1', '230402003', null, '3', '1'),
('230402004', '230402', '胜利街道', '1', '230402004', null, '3', '1'),
('230402005', '230402', '南翼街道', '1', '230402005', null, '3', '1'),
('230403001', '230403', '育才街道', '1', '230403001', null, '3', '1'),
('230403002', '230403', '红旗街道', '1', '230403002', null, '3', '1'),
('230403003', '230403', '新南街道', '1', '230403003', null, '3', '1'),
('230403004', '230403', '湖滨街道', '1', '230403004', null, '3', '1'),
('230403005', '230403', '解放街道', '1', '230403005', null, '3', '1'),
('230403006', '230403', '团结街道', '1', '230403006', null, '3', '1'),
('230404001', '230404', '铁西街道', '1', '230404001', null, '3', '1'),
('230404002', '230404', '铁东街道', '1', '230404002', null, '3', '1'),
('230404003', '230404', '六号街道', '1', '230404003', null, '3', '1'),
('230404004', '230404', '大陆街道', '1', '230404004', null, '3', '1'),
('230404005', '230404', '富力街道', '1', '230404005', null, '3', '1'),
('230404006', '230404', '麓林山街道', '1', '230404006', null, '3', '1'),
('230405001', '230405', '兴安路街道', '1', '230405001', null, '3', '1'),
('230405002', '230405', '兴建路街道', '1', '230405002', null, '3', '1'),
('230405003', '230405', '兴长路街道', '1', '230405003', null, '3', '1'),
('230405004', '230405', '峻德路街道', '1', '230405004', null, '3', '1'),
('230405005', '230405', '河东路街道', '1', '230405005', null, '3', '1'),
('230406001', '230406', '工人村街道', '1', '230406001', null, '3', '1'),
('230406002', '230406', '新一街道', '1', '230406002', null, '3', '1'),
('230406003', '230406', '三街街道', '1', '230406003', null, '3', '1'),
('230406004', '230406', '东山街道', '1', '230406004', null, '3', '1'),
('230406100', '230406', '新华镇', '1', '230406100', null, '3', '1'),
('230406200', '230406', '红旗乡', '1', '230406200', null, '3', '1'),
('230406201', '230406', '蔬园乡', '1', '230406201', null, '3', '1'),
('230406202', '230406', '东方红乡', '1', '230406202', null, '3', '1'),
('230406400', '230406', '鹤岗市林业局', '1', '230406400', null, '3', '1'),
('230406500', '230406', '新华农场', '1', '230406500', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('230407001', '230407', '岭北街道', '1', '230407001', null, '3', '1'),
('230407002', '230407', '岭南街道', '1', '230407002', null, '3', '1'),
('230407003', '230407', '沟北街道', '1', '230407003', null, '3', '1'),
('230407004', '230407', '沟南街道', '1', '230407004', null, '3', '1'),
('230421100', '230421', '凤翔镇', '1', '230421100', null, '3', '1'),
('230421101', '230421', '鹤北镇', '1', '230421101', null, '3', '1'),
('230421102', '230421', '名山镇', '1', '230421102', null, '3', '1'),
('230421103', '230421', '团结镇', '1', '230421103', null, '3', '1'),
('230421104', '230421', '肇兴镇', '1', '230421104', null, '3', '1'),
('230421200', '230421', '东明朝鲜族乡', '1', '230421200', null, '3', '1'),
('230421203', '230421', '太平沟乡', '1', '230421203', null, '3', '1'),
('230421204', '230421', '环山乡', '1', '230421204', null, '3', '1'),
('230421401', '230421', '鹤北林业局', '1', '230421401', null, '3', '1'),
('230421500', '230421', '宝泉岭分局局直', '1', '230421500', null, '3', '1'),
('230421501', '230421', '江滨农场', '1', '230421501', null, '3', '1'),
('230421502', '230421', '军川农场', '1', '230421502', null, '3', '1'),
('230421503', '230421', '名山农场', '1', '230421503', null, '3', '1'),
('230421504', '230421', '延军农场', '1', '230421504', null, '3', '1'),
('230421505', '230421', '共青农场', '1', '230421505', null, '3', '1'),
('230421506', '230421', '宝泉岭农场', '1', '230421506', null, '3', '1'),
('230422100', '230422', '绥滨镇', '1', '230422100', null, '3', '1'),
('230422101', '230422', '绥东镇', '1', '230422101', null, '3', '1'),
('230422102', '230422', '忠仁镇', '1', '230422102', null, '3', '1'),
('230422200', '230422', '连生乡', '1', '230422200', null, '3', '1'),
('230422201', '230422', '北岗乡', '1', '230422201', null, '3', '1'),
('230422202', '230422', '富强乡', '1', '230422202', null, '3', '1'),
('230422203', '230422', '北山乡', '1', '230422203', null, '3', '1'),
('230422204', '230422', '福兴乡', '1', '230422204', null, '3', '1'),
('230422205', '230422', '新富乡', '1', '230422205', null, '3', '1'),
('230422500', '230422', '二九０农场', '1', '230422500', null, '3', '1'),
('230422501', '230422', '绥滨农场', '1', '230422501', null, '3', '1'),
('230422503', '230422', '普阳农场', '1', '230422503', null, '3', '1'),
('230502001', '230502', '二马路街道', '1', '230502001', null, '3', '1'),
('230502002', '230502', '八马路街道', '1', '230502002', null, '3', '1'),
('230502003', '230502', '中心站街道', '1', '230502003', null, '3', '1'),
('230502004', '230502', '富安街道', '1', '230502004', null, '3', '1'),
('230502005', '230502', '窑地街道', '1', '230502005', null, '3', '1'),
('230502006', '230502', '长安街道', '1', '230502006', null, '3', '1'),
('230502007', '230502', '铁西街道', '1', '230502007', null, '3', '1'),
('230502200', '230502', '安邦乡', '1', '230502200', null, '3', '1'),
('230503001', '230503', '中山街道', '1', '230503001', null, '3', '1'),
('230503002', '230503', '北山街道', '1', '230503002', null, '3', '1'),
('230503003', '230503', '南山街道', '1', '230503003', null, '3', '1'),
('230503004', '230503', '东山街道', '1', '230503004', null, '3', '1'),
('230503005', '230503', '中心街道', '1', '230503005', null, '3', '1'),
('230503006', '230503', '西山街道', '1', '230503006', null, '3', '1'),
('230503200', '230503', '长胜乡', '1', '230503200', null, '3', '1'),
('230503400', '230503', '岭东区青山旅游公司', '1', '230503400', null, '3', '1'),
('230503401', '230503', '岭东区岭东经营所', '1', '230503401', null, '3', '1'),
('230505001', '230505', '振兴中路街道', '1', '230505001', null, '3', '1'),
('230505002', '230505', '振兴东路街道', '1', '230505002', null, '3', '1'),
('230505004', '230505', '集贤街道', '1', '230505004', null, '3', '1'),
('230505005', '230505', '东荣街道', '1', '230505005', null, '3', '1'),
('230505101', '230505', '太保镇', '1', '230505101', null, '3', '1'),
('230506001', '230506', '红旗街道', '1', '230506001', null, '3', '1'),
('230506002', '230506', '跃进街道', '1', '230506002', null, '3', '1'),
('230506003', '230506', '东保卫街道', '1', '230506003', null, '3', '1'),
('230506004', '230506', '七星街道', '1', '230506004', null, '3', '1'),
('230506005', '230506', '双阳街道', '1', '230506005', null, '3', '1'),
('230506006', '230506', '新安街道', '1', '230506006', null, '3', '1'),
('230506007', '230506', '电厂街道', '1', '230506007', null, '3', '1'),
('230506101', '230506', '七星镇', '1', '230506101', null, '3', '1'),
('230506401', '230506', '双鸭山林业局宝山经营所', '1', '230506401', null, '3', '1'),
('230506402', '230506', '双鸭山林业局大叶沟林场', '1', '230506402', null, '3', '1'),
('230506500', '230506', '双鸭山农场', '1', '230506500', null, '3', '1'),
('230521100', '230521', '福利镇', '1', '230521100', null, '3', '1'),
('230521101', '230521', '集贤镇', '1', '230521101', null, '3', '1'),
('230521102', '230521', '升昌镇', '1', '230521102', null, '3', '1'),
('230521103', '230521', '丰乐镇', '1', '230521103', null, '3', '1'),
('230521104', '230521', '太平镇', '1', '230521104', null, '3', '1'),
('230521201', '230521', '腰屯乡', '1', '230521201', null, '3', '1'),
('230521202', '230521', '兴安乡', '1', '230521202', null, '3', '1'),
('230521204', '230521', '永安乡', '1', '230521204', null, '3', '1'),
('230521401', '230521', '太平林场', '1', '230521401', null, '3', '1'),
('230521402', '230521', '丰乐林场', '1', '230521402', null, '3', '1'),
('230521403', '230521', '七星林场', '1', '230521403', null, '3', '1'),
('230521404', '230521', '峻山林场', '1', '230521404', null, '3', '1'),
('230521405', '230521', '爱林林场', '1', '230521405', null, '3', '1'),
('230521406', '230521', '腰屯林场', '1', '230521406', null, '3', '1'),
('230521407', '230521', '升平煤矿', '1', '230521407', null, '3', '1'),
('230521500', '230521', '二九一农场', '1', '230521500', null, '3', '1'),
('230521501', '230521', '良种场', '1', '230521501', null, '3', '1'),
('230521502', '230521', '种畜场', '1', '230521502', null, '3', '1'),
('230521503', '230521', '果树示范场', '1', '230521503', null, '3', '1'),
('230521580', '230521', '黑龙江省笔架山监狱', '1', '230521580', null, '3', '1'),
('230522100', '230522', '友谊镇', '1', '230522100', null, '3', '1'),
('230522101', '230522', '兴隆镇', '1', '230522101', null, '3', '1'),
('230522102', '230522', '龙山镇', '1', '230522102', null, '3', '1'),
('230522103', '230522', '凤岗镇', '1', '230522103', null, '3', '1'),
('230522200', '230522', '兴盛乡', '1', '230522200', null, '3', '1'),
('230522201', '230522', '东建乡', '1', '230522201', null, '3', '1'),
('230522202', '230522', '庆丰乡', '1', '230522202', null, '3', '1'),
('230522203', '230522', '建设乡', '1', '230522203', null, '3', '1'),
('230522204', '230522', '友邻乡', '1', '230522204', null, '3', '1'),
('230522205', '230522', '新镇乡', '1', '230522205', null, '3', '1'),
('230522206', '230522', '成富朝鲜族满族乡', '1', '230522206', null, '3', '1'),
('230522501', '230522', '红兴隆分局局直', '1', '230522501', null, '3', '1'),
('230522502', '230522', '友谊农场', '1', '230522502', null, '3', '1'),
('230523100', '230523', '宝清镇', '1', '230523100', null, '3', '1'),
('230523101', '230523', '七星泡镇', '1', '230523101', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('230523102', '230523', '青原镇', '1', '230523102', null, '3', '1'),
('230523103', '230523', '夹信子镇', '1', '230523103', null, '3', '1'),
('230523104', '230523', '龙头镇', '1', '230523104', null, '3', '1'),
('230523105', '230523', '小城子镇', '1', '230523105', null, '3', '1'),
('230523202', '230523', '朝阳乡', '1', '230523202', null, '3', '1'),
('230523203', '230523', '万金山乡', '1', '230523203', null, '3', '1'),
('230523204', '230523', '尖山子乡', '1', '230523204', null, '3', '1'),
('230523209', '230523', '七星河乡', '1', '230523209', null, '3', '1'),
('230523400', '230523', '双鸭山林业局上游经营所', '1', '230523400', null, '3', '1'),
('230523401', '230523', '双鸭山林业局南瓮泉经营所', '1', '230523401', null, '3', '1'),
('230523402', '230523', '双鸭山林业局七一林场', '1', '230523402', null, '3', '1'),
('230523403', '230523', '双鸭山林业局七星河林场', '1', '230523403', null, '3', '1'),
('230523404', '230523', '双鸭山林业局红旗林场', '1', '230523404', null, '3', '1'),
('230523405', '230523', '双鸭山林业局三岔河林场', '1', '230523405', null, '3', '1'),
('230523406', '230523', '双鸭山林业局青龙林场', '1', '230523406', null, '3', '1'),
('230523407', '230523', '双鸭山林业局宝石经营所', '1', '230523407', null, '3', '1'),
('230523408', '230523', '双鸭山林业局七星河金矿', '1', '230523408', null, '3', '1'),
('230523500', '230523', '五九七农场', '1', '230523500', null, '3', '1'),
('230523501', '230523', '八五二农场', '1', '230523501', null, '3', '1'),
('230523502', '230523', '八五三农场', '1', '230523502', null, '3', '1'),
('230524100', '230524', '饶河镇', '1', '230524100', null, '3', '1'),
('230524101', '230524', '小佳河镇', '1', '230524101', null, '3', '1'),
('230524102', '230524', '西丰镇', '1', '230524102', null, '3', '1'),
('230524103', '230524', '五林洞镇', '1', '230524103', null, '3', '1'),
('230524200', '230524', '西林子乡', '1', '230524200', null, '3', '1'),
('230524201', '230524', '四排乡', '1', '230524201', null, '3', '1'),
('230524203', '230524', '大佳河乡', '1', '230524203', null, '3', '1'),
('230524204', '230524', '山里乡', '1', '230524204', null, '3', '1'),
('230524207', '230524', '大通河乡', '1', '230524207', null, '3', '1'),
('230524400', '230524', '小佳河林场', '1', '230524400', null, '3', '1'),
('230524401', '230524', '威山林场', '1', '230524401', null, '3', '1'),
('230524402', '230524', '西丰林场', '1', '230524402', null, '3', '1'),
('230524403', '230524', '大牙克林场', '1', '230524403', null, '3', '1'),
('230524404', '230524', '石场林场', '1', '230524404', null, '3', '1'),
('230524405', '230524', '宝马山林场', '1', '230524405', null, '3', '1'),
('230524406', '230524', '大岱林场', '1', '230524406', null, '3', '1'),
('230524407', '230524', '永幸林场', '1', '230524407', null, '3', '1'),
('230524408', '230524', '奇源林场', '1', '230524408', null, '3', '1'),
('230524409', '230524', '芦源林场', '1', '230524409', null, '3', '1'),
('230524410', '230524', '五林洞林场', '1', '230524410', null, '3', '1'),
('230524500', '230524', '饶河农场', '1', '230524500', null, '3', '1'),
('230524501', '230524', '红旗岭农场', '1', '230524501', null, '3', '1'),
('230524502', '230524', '八五九农场', '1', '230524502', null, '3', '1'),
('230524503', '230524', '胜利农场', '1', '230524503', null, '3', '1'),
('230524504', '230524', '红卫农场', '1', '230524504', null, '3', '1'),
('230602001', '230602', '萨尔图街道', '1', '230602001', null, '3', '1'),
('230602005', '230602', '铁人街道', '1', '230602005', null, '3', '1'),
('230602006', '230602', '友谊街道', '1', '230602006', null, '3', '1'),
('230602007', '230602', '富强街道', '1', '230602007', null, '3', '1'),
('230602008', '230602', '拥军街道', '1', '230602008', null, '3', '1'),
('230602009', '230602', '会战街道', '1', '230602009', null, '3', '1'),
('230602010', '230602', '火炬街道', '1', '230602010', null, '3', '1'),
('230602011', '230602', '东风街道', '1', '230602011', null, '3', '1'),
('230602012', '230602', '东安街道', '1', '230602012', null, '3', '1'),
('230603001', '230603', '龙凤街道', '1', '230603001', null, '3', '1'),
('230603002', '230603', '兴化街道', '1', '230603002', null, '3', '1'),
('230603007', '230603', '卧里屯街道', '1', '230603007', null, '3', '1'),
('230603008', '230603', '东光街道', '1', '230603008', null, '3', '1'),
('230603009', '230603', '三永街道', '1', '230603009', null, '3', '1'),
('230603010', '230603', '开发区黎明街道', '1', '230603010', null, '3', '1'),
('230603100', '230603', '龙凤镇', '1', '230603100', null, '3', '1'),
('230603580', '230603', '高新区农场', '1', '230603580', null, '3', '1'),
('230604001', '230604', '龙岗街道', '1', '230604001', null, '3', '1'),
('230604002', '230604', '银浪街道', '1', '230604002', null, '3', '1'),
('230604004', '230604', '奋斗街道', '1', '230604004', null, '3', '1'),
('230604005', '230604', '庆新街道', '1', '230604005', null, '3', '1'),
('230604007', '230604', '西宾街道', '1', '230604007', null, '3', '1'),
('230604009', '230604', '乘风街道', '1', '230604009', null, '3', '1'),
('230604101', '230604', '喇嘛甸镇', '1', '230604101', null, '3', '1'),
('230604580', '230604', '红骥牧场', '1', '230604580', null, '3', '1'),
('230604581', '230604', '星火牧场', '1', '230604581', null, '3', '1'),
('230604582', '230604', '银浪牧场', '1', '230604582', null, '3', '1'),
('230605001', '230605', '红岗街道', '1', '230605001', null, '3', '1'),
('230605004', '230605', '八百垧街道', '1', '230605004', null, '3', '1'),
('230605005', '230605', '杏南街道', '1', '230605005', null, '3', '1'),
('230605006', '230605', '解放街道', '1', '230605006', null, '3', '1'),
('230605007', '230605', '创业街道', '1', '230605007', null, '3', '1'),
('230605100', '230605', '杏树岗镇', '1', '230605100', null, '3', '1'),
('230606001', '230606', '庆葡街道', '1', '230606001', null, '3', '1'),
('230606002', '230606', '高台子镇街道', '1', '230606002', null, '3', '1'),
('230606004', '230606', '林源镇街道', '1', '230606004', null, '3', '1'),
('230606005', '230606', '立志街道', '1', '230606005', null, '3', '1'),
('230606006', '230606', '新华街道', '1', '230606006', null, '3', '1'),
('230606007', '230606', '大同镇街道', '1', '230606007', null, '3', '1'),
('230606100', '230606', '大同镇', '1', '230606100', null, '3', '1'),
('230606101', '230606', '高台子镇', '1', '230606101', null, '3', '1'),
('230606102', '230606', '太阳升镇', '1', '230606102', null, '3', '1'),
('230606103', '230606', '林源镇', '1', '230606103', null, '3', '1'),
('230606200', '230606', '祝三乡', '1', '230606200', null, '3', '1'),
('230606203', '230606', '老山头乡', '1', '230606203', null, '3', '1'),
('230606205', '230606', '八井子乡', '1', '230606205', null, '3', '1'),
('230606206', '230606', '双榆树乡', '1', '230606206', null, '3', '1'),
('230606500', '230606', '和平牧场', '1', '230606500', null, '3', '1'),
('230621100', '230621', '肇州镇', '1', '230621100', null, '3', '1'),
('230621101', '230621', '永乐镇', '1', '230621101', null, '3', '1'),
('230621102', '230621', '丰乐镇', '1', '230621102', null, '3', '1'),
('230621103', '230621', '朝阳沟镇', '1', '230621103', null, '3', '1'),
('230621104', '230621', '兴城镇', '1', '230621104', null, '3', '1'),
('230621105', '230621', '二井镇', '1', '230621105', null, '3', '1'),
('230621202', '230621', '双发乡', '1', '230621202', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('230621203', '230621', '托古乡', '1', '230621203', null, '3', '1'),
('230621205', '230621', '朝阳乡', '1', '230621205', null, '3', '1'),
('230621206', '230621', '永胜乡', '1', '230621206', null, '3', '1'),
('230621208', '230621', '榆树乡', '1', '230621208', null, '3', '1'),
('230621211', '230621', '新福乡', '1', '230621211', null, '3', '1'),
('230621580', '230621', '乐园良种场', '1', '230621580', null, '3', '1'),
('230621581', '230621', '卫星种畜场', '1', '230621581', null, '3', '1'),
('230622100', '230622', '肇源镇', '1', '230622100', null, '3', '1'),
('230622101', '230622', '三站镇', '1', '230622101', null, '3', '1'),
('230622102', '230622', '二站镇', '1', '230622102', null, '3', '1'),
('230622103', '230622', '茂兴镇', '1', '230622103', null, '3', '1'),
('230622104', '230622', '古龙镇', '1', '230622104', null, '3', '1'),
('230622105', '230622', '新站镇', '1', '230622105', null, '3', '1'),
('230622106', '230622', '头台镇', '1', '230622106', null, '3', '1'),
('230622200', '230622', '福兴乡', '1', '230622200', null, '3', '1'),
('230622201', '230622', '薄荷台乡', '1', '230622201', null, '3', '1'),
('230622203', '230622', '和平乡', '1', '230622203', null, '3', '1'),
('230622206', '230622', '古恰乡', '1', '230622206', null, '3', '1'),
('230622207', '230622', '超等乡', '1', '230622207', null, '3', '1'),
('230622208', '230622', '民意乡', '1', '230622208', null, '3', '1'),
('230622210', '230622', '义顺乡', '1', '230622210', null, '3', '1'),
('230622211', '230622', '浩德乡', '1', '230622211', null, '3', '1'),
('230622212', '230622', '大兴乡', '1', '230622212', null, '3', '1'),
('230622500', '230622', '肇源农场', '1', '230622500', null, '3', '1'),
('230622581', '230622', '种畜场', '1', '230622581', null, '3', '1'),
('230622582', '230622', '茂兴湖渔场', '1', '230622582', null, '3', '1'),
('230622583', '230622', '新立良种繁育场', '1', '230622583', null, '3', '1'),
('230622584', '230622', '立陡山良种场', '1', '230622584', null, '3', '1'),
('230622585', '230622', '八家河渔场', '1', '230622585', null, '3', '1'),
('230622586', '230622', '果树示范场', '1', '230622586', null, '3', '1'),
('230622587', '230622', '经济作物示范场', '1', '230622587', null, '3', '1'),
('230623100', '230623', '林甸镇', '1', '230623100', null, '3', '1'),
('230623101', '230623', '红旗镇', '1', '230623101', null, '3', '1'),
('230623200', '230623', '东兴乡', '1', '230623200', null, '3', '1'),
('230623201', '230623', '宏伟乡', '1', '230623201', null, '3', '1'),
('230623202', '230623', '三合乡', '1', '230623202', null, '3', '1'),
('230623203', '230623', '花园乡', '1', '230623203', null, '3', '1'),
('230623204', '230623', '四合乡', '1', '230623204', null, '3', '1'),
('230623205', '230623', '黎明乡', '1', '230623205', null, '3', '1'),
('230623400', '230623', '林甸县长青林场', '1', '230623400', null, '3', '1'),
('230623500', '230623', '巨浪牧场', '1', '230623500', null, '3', '1'),
('230623581', '230623', '黑龙江省林甸县国营苇场', '1', '230623581', null, '3', '1'),
('230623582', '230623', '林甸县新兴马场', '1', '230623582', null, '3', '1'),
('230624100', '230624', '泰康镇', '1', '230624100', null, '3', '1'),
('230624101', '230624', '胡吉吐莫镇', '1', '230624101', null, '3', '1'),
('230624102', '230624', '烟筒屯镇', '1', '230624102', null, '3', '1'),
('230624103', '230624', '他拉哈镇', '1', '230624103', null, '3', '1'),
('230624200', '230624', '一心乡', '1', '230624200', null, '3', '1'),
('230624201', '230624', '克尔台乡', '1', '230624201', null, '3', '1'),
('230624202', '230624', '白音诺勒乡', '1', '230624202', null, '3', '1'),
('230624203', '230624', '敖林西伯乡', '1', '230624203', null, '3', '1'),
('230624204', '230624', '巴彦查干乡', '1', '230624204', null, '3', '1'),
('230624205', '230624', '腰新乡', '1', '230624205', null, '3', '1'),
('230624206', '230624', '江湾乡', '1', '230624206', null, '3', '1'),
('230624500', '230624', '绿色草原牧场', '1', '230624500', null, '3', '1'),
('230624581', '230624', '黑龙江省大山种羊场', '1', '230624581', null, '3', '1'),
('230624582', '230624', '靠山种畜场', '1', '230624582', null, '3', '1'),
('230624583', '230624', '对山奶牛场', '1', '230624583', null, '3', '1'),
('230624584', '230624', '红旗种畜场', '1', '230624584', null, '3', '1'),
('230624585', '230624', '连环湖渔业有限公司', '1', '230624585', null, '3', '1'),
('230624586', '230624', '石人沟渔业有限公司', '1', '230624586', null, '3', '1'),
('230624587', '230624', '齐家泡渔业有限公司', '1', '230624587', null, '3', '1'),
('230624588', '230624', '四家子林场', '1', '230624588', null, '3', '1'),
('230624589', '230624', '新店林场', '1', '230624589', null, '3', '1'),
('230624590', '230624', '野生饲养场', '1', '230624590', null, '3', '1'),
('230624591', '230624', '第一良种场', '1', '230624591', null, '3', '1'),
('230624592', '230624', '一心苗圃', '1', '230624592', null, '3', '1'),
('230624593', '230624', '一心果树场', '1', '230624593', null, '3', '1'),
('230702001', '230702', '旭日街道', '1', '230702001', null, '3', '1'),
('230702004', '230702', '红升街道', '1', '230702004', null, '3', '1'),
('230702006', '230702', '前进街道', '1', '230702006', null, '3', '1'),
('230702007', '230702', '朝阳街道', '1', '230702007', null, '3', '1'),
('230702008', '230702', '东升街道', '1', '230702008', null, '3', '1'),
('230703002', '230703', '西水街道', '1', '230703002', null, '3', '1'),
('230703004', '230703', '联合街道', '1', '230703004', null, '3', '1'),
('230703005', '230703', '东升街道', '1', '230703005', null, '3', '1'),
('230703101', '230703', '晨明镇', '1', '230703101', null, '3', '1'),
('230703102', '230703', '浩良河镇', '1', '230703102', null, '3', '1'),
('230703200', '230703', '迎春乡', '1', '230703200', null, '3', '1'),
('230703400', '230703', '三岔河林场', '1', '230703400', null, '3', '1'),
('230703401', '230703', '四合营林场', '1', '230703401', null, '3', '1'),
('230703402', '230703', '亮子河林场', '1', '230703402', null, '3', '1'),
('230703403', '230703', '石头河林场', '1', '230703403', null, '3', '1'),
('230703405', '230703', '岩石经营所', '1', '230703405', null, '3', '1'),
('230703406', '230703', '奋斗经营所', '1', '230703406', null, '3', '1'),
('230703407', '230703', '桦阳经营所', '1', '230703407', null, '3', '1'),
('230703408', '230703', '浩良河经营所', '1', '230703408', null, '3', '1'),
('230703409', '230703', '太平经营所', '1', '230703409', null, '3', '1'),
('230703410', '230703', '南岔经营所', '1', '230703410', null, '3', '1'),
('230703411', '230703', '威岭经营所', '1', '230703411', null, '3', '1'),
('230703413', '230703', '松青经营所', '1', '230703413', null, '3', '1'),
('230703414', '230703', '柳树经营所', '1', '230703414', null, '3', '1'),
('230704001', '230704', '友好街道', '1', '230704001', null, '3', '1'),
('230704003', '230704', '双子河街道', '1', '230704003', null, '3', '1'),
('230704004', '230704', '铁林街道', '1', '230704004', null, '3', '1'),
('230704400', '230704', '三合经营所', '1', '230704400', null, '3', '1'),
('230704401', '230704', '松园林场', '1', '230704401', null, '3', '1'),
('230704402', '230704', '中心经营所', '1', '230704402', null, '3', '1'),
('230704403', '230704', '永青经营所', '1', '230704403', null, '3', '1'),
('230704404', '230704', '碧云经营所', '1', '230704404', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('230704405', '230704', '友谊经营所', '1', '230704405', null, '3', '1'),
('230704406', '230704', '青杨经营所', '1', '230704406', null, '3', '1'),
('230704407', '230704', '岭峰林场', '1', '230704407', null, '3', '1'),
('230704408', '230704', '奋斗林场', '1', '230704408', null, '3', '1'),
('230704409', '230704', '东卡林场', '1', '230704409', null, '3', '1'),
('230704410', '230704', '鸡爪河林场', '1', '230704410', null, '3', '1'),
('230704411', '230704', '绿源林场', '1', '230704411', null, '3', '1'),
('230704412', '230704', '广川经营所', '1', '230704412', null, '3', '1'),
('230704413', '230704', '朝阳经营所', '1', '230704413', null, '3', '1'),
('230705001', '230705', '西林街道', '1', '230705001', null, '3', '1'),
('230705003', '230705', '新兴街道', '1', '230705003', null, '3', '1'),
('230705005', '230705', '苔青街道', '1', '230705005', null, '3', '1'),
('230706001', '230706', '向阳街道', '1', '230706001', null, '3', '1'),
('230706002', '230706', '曙光街道', '1', '230706002', null, '3', '1'),
('230706400', '230706', '解放经营所', '1', '230706400', null, '3', '1'),
('230706401', '230706', '昆仑气林场', '1', '230706401', null, '3', '1'),
('230706402', '230706', '开源河林场', '1', '230706402', null, '3', '1'),
('230706403', '230706', '么河经营所', '1', '230706403', null, '3', '1'),
('230706404', '230706', '冲锋经营所', '1', '230706404', null, '3', '1'),
('230706405', '230706', '翠峦河经营所', '1', '230706405', null, '3', '1'),
('230706406', '230706', '抚育河经营所', '1', '230706406', null, '3', '1'),
('230706407', '230706', '尖山河经营所', '1', '230706407', null, '3', '1'),
('230707001', '230707', '新青街道', '1', '230707001', null, '3', '1'),
('230707003', '230707', '兴安街道', '1', '230707003', null, '3', '1'),
('230707400', '230707', '红林经营所', '1', '230707400', null, '3', '1'),
('230707401', '230707', '松林林场', '1', '230707401', null, '3', '1'),
('230707402', '230707', '泉林林场', '1', '230707402', null, '3', '1'),
('230707404', '230707', '水源林场', '1', '230707404', null, '3', '1'),
('230707405', '230707', '笑山林场', '1', '230707405', null, '3', '1'),
('230707406', '230707', '汤林林场', '1', '230707406', null, '3', '1'),
('230707407', '230707', '桦林经营所', '1', '230707407', null, '3', '1'),
('230707408', '230707', '青林林场', '1', '230707408', null, '3', '1'),
('230707409', '230707', '结源林场', '1', '230707409', null, '3', '1'),
('230707410', '230707', '北沟林场', '1', '230707410', null, '3', '1'),
('230707411', '230707', '南沟林场', '1', '230707411', null, '3', '1'),
('230707412', '230707', '乌拉嘎经营所', '1', '230707412', null, '3', '1'),
('230707413', '230707', '柳树河林场', '1', '230707413', null, '3', '1'),
('230707414', '230707', '北影林场', '1', '230707414', null, '3', '1'),
('230708001', '230708', '美溪街道', '1', '230708001', null, '3', '1'),
('230708400', '230708', '大西林林场', '1', '230708400', null, '3', '1'),
('230708401', '230708', '五道库经营所', '1', '230708401', null, '3', '1'),
('230708402', '230708', '缓岭经营所', '1', '230708402', null, '3', '1'),
('230708403', '230708', '对青山经营所', '1', '230708403', null, '3', '1'),
('230708404', '230708', '群峦经营所', '1', '230708404', null, '3', '1'),
('230708405', '230708', '兰新经营所', '1', '230708405', null, '3', '1'),
('230708406', '230708', '顺利河林场', '1', '230708406', null, '3', '1'),
('230708407', '230708', '松岭经营所', '1', '230708407', null, '3', '1'),
('230708408', '230708', '青山口林场', '1', '230708408', null, '3', '1'),
('230708409', '230708', '金沙河林场', '1', '230708409', null, '3', '1'),
('230708410', '230708', '桦皮羌子林场', '1', '230708410', null, '3', '1'),
('230708411', '230708', '碧仓库林场', '1', '230708411', null, '3', '1'),
('230708412', '230708', '三股流经营所', '1', '230708412', null, '3', '1'),
('230708413', '230708', '卧龙河林场', '1', '230708413', null, '3', '1'),
('230709002', '230709', '奋斗街道', '1', '230709002', null, '3', '1'),
('230709003', '230709', '金山街道', '1', '230709003', null, '3', '1'),
('230709401', '230709', '白山林场', '1', '230709401', null, '3', '1'),
('230709402', '230709', '丰岭林场', '1', '230709402', null, '3', '1'),
('230709403', '230709', '丰林林场', '1', '230709403', null, '3', '1'),
('230709404', '230709', '丰沟经营所', '1', '230709404', null, '3', '1'),
('230709405', '230709', '丰茂林场', '1', '230709405', null, '3', '1'),
('230709406', '230709', '横山经营所', '1', '230709406', null, '3', '1'),
('230709407', '230709', '丰丽林场', '1', '230709407', null, '3', '1'),
('230709408', '230709', '大昆仑经营所', '1', '230709408', null, '3', '1'),
('230709409', '230709', '小昆仑林场', '1', '230709409', null, '3', '1'),
('230709410', '230709', '育林经营所', '1', '230709410', null, '3', '1'),
('230710001', '230710', '五营街道', '1', '230710001', null, '3', '1'),
('230710011', '230710', '五星街道', '1', '230710011', null, '3', '1'),
('230710400', '230710', '翠北林场', '1', '230710400', null, '3', '1'),
('230710401', '230710', '前丰林场', '1', '230710401', null, '3', '1'),
('230710402', '230710', '永丰经营所', '1', '230710402', null, '3', '1'),
('230710403', '230710', '平原经营所', '1', '230710403', null, '3', '1'),
('230710404', '230710', '丽丰经营所', '1', '230710404', null, '3', '1'),
('230710405', '230710', '杨树河经营所', '1', '230710405', null, '3', '1'),
('230710406', '230710', '平山经营所', '1', '230710406', null, '3', '1'),
('230710407', '230710', '丽林经营所', '1', '230710407', null, '3', '1'),
('230711001', '230711', '乌马河街道', '1', '230711001', null, '3', '1'),
('230711400', '230711', '伊敏林场', '1', '230711400', null, '3', '1'),
('230711401', '230711', '伊东经营所', '1', '230711401', null, '3', '1'),
('230711402', '230711', '东方红经营所', '1', '230711402', null, '3', '1'),
('230711403', '230711', '翠岭经营所', '1', '230711403', null, '3', '1'),
('230711404', '230711', '河北经营所', '1', '230711404', null, '3', '1'),
('230711405', '230711', '青山林场', '1', '230711405', null, '3', '1'),
('230711406', '230711', '育苗经营所', '1', '230711406', null, '3', '1'),
('230711407', '230711', '安全经营所', '1', '230711407', null, '3', '1'),
('230711408', '230711', '伊青经营所', '1', '230711408', null, '3', '1'),
('230711409', '230711', '前进经营所', '1', '230711409', null, '3', '1'),
('230711410', '230711', '西岭林场', '1', '230711410', null, '3', '1'),
('230711411', '230711', '伊林经营所', '1', '230711411', null, '3', '1'),
('230712001', '230712', '河南街道', '1', '230712001', null, '3', '1'),
('230712002', '230712', '河北街道', '1', '230712002', null, '3', '1'),
('230712400', '230712', '日新林场', '1', '230712400', null, '3', '1'),
('230712401', '230712', '石林林场', '1', '230712401', null, '3', '1'),
('230712402', '230712', '东升林场', '1', '230712402', null, '3', '1'),
('230712403', '230712', '二龙山林场', '1', '230712403', null, '3', '1'),
('230712404', '230712', '高峰林场', '1', '230712404', null, '3', '1'),
('230712405', '230712', '二清河林场', '1', '230712405', null, '3', '1'),
('230712406', '230712', '守虎山林场', '1', '230712406', null, '3', '1'),
('230712407', '230712', '泉石林场', '1', '230712407', null, '3', '1'),
('230712408', '230712', '峻岭林场', '1', '230712408', null, '3', '1'),
('230712409', '230712', '育林经营所', '1', '230712409', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('230712410', '230712', '团结经营所', '1', '230712410', null, '3', '1'),
('230712411', '230712', '磨石山经营所', '1', '230712411', null, '3', '1'),
('230712412', '230712', '中心苗卜', '1', '230712412', null, '3', '1'),
('230712413', '230712', '克林经营所', '1', '230712413', null, '3', '1'),
('230713001', '230713', '带岭街道', '1', '230713001', null, '3', '1'),
('230713400', '230713', '大青川林场', '1', '230713400', null, '3', '1'),
('230713401', '230713', '东方红林场', '1', '230713401', null, '3', '1'),
('230713402', '230713', '秀水林场', '1', '230713402', null, '3', '1'),
('230713403', '230713', '永翠林场', '1', '230713403', null, '3', '1'),
('230713404', '230713', '明月林场', '1', '230713404', null, '3', '1'),
('230713405', '230713', '红光林场', '1', '230713405', null, '3', '1'),
('230713406', '230713', '碧水林场', '1', '230713406', null, '3', '1'),
('230713407', '230713', '北列林场', '1', '230713407', null, '3', '1'),
('230713408', '230713', '南列林场', '1', '230713408', null, '3', '1'),
('230713409', '230713', '寒月林场', '1', '230713409', null, '3', '1'),
('230713410', '230713', '环山林场', '1', '230713410', null, '3', '1'),
('230714001', '230714', '乌伊岭街道', '1', '230714001', null, '3', '1'),
('230714400', '230714', '上游林场', '1', '230714400', null, '3', '1'),
('230714401', '230714', '美峰林场', '1', '230714401', null, '3', '1'),
('230714402', '230714', '翠峰林场', '1', '230714402', null, '3', '1'),
('230714403', '230714', '建新林场', '1', '230714403', null, '3', '1'),
('230714404', '230714', '移山林场', '1', '230714404', null, '3', '1'),
('230714405', '230714', '林海林场', '1', '230714405', null, '3', '1'),
('230714406', '230714', '桔源林场', '1', '230714406', null, '3', '1'),
('230714407', '230714', '东克林林场', '1', '230714407', null, '3', '1'),
('230714408', '230714', '福民林场', '1', '230714408', null, '3', '1'),
('230714409', '230714', '阿廷河林场', '1', '230714409', null, '3', '1'),
('230714410', '230714', '永胜经营所', '1', '230714410', null, '3', '1'),
('230714411', '230714', '前卫林场', '1', '230714411', null, '3', '1'),
('230715001', '230715', '红星街道', '1', '230715001', null, '3', '1'),
('230715400', '230715', '清水河经营所', '1', '230715400', null, '3', '1'),
('230715401', '230715', '五星河经营所', '1', '230715401', null, '3', '1'),
('230715402', '230715', '汤洪岭林场', '1', '230715402', null, '3', '1'),
('230715403', '230715', '汤北林场', '1', '230715403', null, '3', '1'),
('230715404', '230715', '霍吉河林场', '1', '230715404', null, '3', '1'),
('230715405', '230715', '二杨经营所', '1', '230715405', null, '3', '1'),
('230715406', '230715', '三杨林场', '1', '230715406', null, '3', '1'),
('230715407', '230715', '汤南林场', '1', '230715407', null, '3', '1'),
('230715408', '230715', '共青经营所', '1', '230715408', null, '3', '1'),
('230715409', '230715', '库斯特林场', '1', '230715409', null, '3', '1'),
('230715410', '230715', '二皮河经营所', '1', '230715410', null, '3', '1'),
('230716001', '230716', '红山街道', '1', '230716001', null, '3', '1'),
('230716400', '230716', '山峰林场', '1', '230716400', null, '3', '1'),
('230716401', '230716', '阳光林场', '1', '230716401', null, '3', '1'),
('230716402', '230716', '新风林场', '1', '230716402', null, '3', '1'),
('230716403', '230716', '卫国林场', '1', '230716403', null, '3', '1'),
('230716404', '230716', '查山经营所', '1', '230716404', null, '3', '1'),
('230716405', '230716', '长青经营所', '1', '230716405', null, '3', '1'),
('230716406', '230716', '青山农场', '1', '230716406', null, '3', '1'),
('230716407', '230716', '溪水经营所', '1', '230716407', null, '3', '1'),
('230716408', '230716', '蔚兰经营所', '1', '230716408', null, '3', '1'),
('230716409', '230716', '永绪经营所', '1', '230716409', null, '3', '1'),
('230716410', '230716', '美林经营所', '1', '230716410', null, '3', '1'),
('230716411', '230716', '红山经营所', '1', '230716411', null, '3', '1'),
('230722100', '230722', '朝阳镇', '1', '230722100', null, '3', '1'),
('230722101', '230722', '乌云镇', '1', '230722101', null, '3', '1'),
('230722102', '230722', '乌拉嘎镇', '1', '230722102', null, '3', '1'),
('230722200', '230722', '常胜乡', '1', '230722200', null, '3', '1'),
('230722201', '230722', '向阳乡', '1', '230722201', null, '3', '1'),
('230722202', '230722', '沪嘉乡', '1', '230722202', null, '3', '1'),
('230722203', '230722', '红光乡', '1', '230722203', null, '3', '1'),
('230722204', '230722', '保兴乡', '1', '230722204', null, '3', '1'),
('230722205', '230722', '青山乡', '1', '230722205', null, '3', '1'),
('230722400', '230722', '太平林场', '1', '230722400', null, '3', '1'),
('230722401', '230722', '红旗林场', '1', '230722401', null, '3', '1'),
('230722402', '230722', '清河林场', '1', '230722402', null, '3', '1'),
('230722403', '230722', '连江林场', '1', '230722403', null, '3', '1'),
('230722404', '230722', '马连林场', '1', '230722404', null, '3', '1'),
('230722500', '230722', '嘉荫农场', '1', '230722500', null, '3', '1'),
('230781100', '230781', '铁力镇', '1', '230781100', null, '3', '1'),
('230781101', '230781', '双丰镇', '1', '230781101', null, '3', '1'),
('230781102', '230781', '桃山镇', '1', '230781102', null, '3', '1'),
('230781104', '230781', '朗乡镇', '1', '230781104', null, '3', '1'),
('230781200', '230781', '年丰乡', '1', '230781200', null, '3', '1'),
('230781201', '230781', '工农乡', '1', '230781201', null, '3', '1'),
('230781202', '230781', '王杨乡', '1', '230781202', null, '3', '1'),
('230781400', '230781', '铁力林业局', '1', '230781400', null, '3', '1'),
('230781401', '230781', '双丰林业局', '1', '230781401', null, '3', '1'),
('230781402', '230781', '桃山林业局', '1', '230781402', null, '3', '1'),
('230781403', '230781', '朗乡林业局', '1', '230781403', null, '3', '1'),
('230781500', '230781', '铁力农场', '1', '230781500', null, '3', '1'),
('230803001', '230803', '西林街道', '1', '230803001', null, '3', '1'),
('230803002', '230803', '保卫街道', '1', '230803002', null, '3', '1'),
('230803003', '230803', '桥南街道', '1', '230803003', null, '3', '1'),
('230803004', '230803', '西南岗街道', '1', '230803004', null, '3', '1'),
('230803005', '230803', '建设街道', '1', '230803005', null, '3', '1'),
('230803006', '230803', '长安街道', '1', '230803006', null, '3', '1'),
('230803198', '230803', '向阳区直辖地域', '1', '230803198', null, '3', '1'),
('230804001', '230804', '站前街道', '1', '230804001', null, '3', '1'),
('230804002', '230804', '永安街道', '1', '230804002', null, '3', '1'),
('230804003', '230804', '奋斗街道', '1', '230804003', null, '3', '1'),
('230804004', '230804', '南岗街道', '1', '230804004', null, '3', '1'),
('230804005', '230804', '亮子河街道', '1', '230804005', null, '3', '1'),
('230804006', '230804', '田园街道', '1', '230804006', null, '3', '1'),
('230805001', '230805', '晓云街道', '1', '230805001', null, '3', '1'),
('230805002', '230805', '佳东街道', '1', '230805002', null, '3', '1'),
('230805003', '230805', '造纸街道', '1', '230805003', null, '3', '1'),
('230805004', '230805', '佳南街道', '1', '230805004', null, '3', '1'),
('230805005', '230805', '建国街道', '1', '230805005', null, '3', '1'),
('230805200', '230805', '松江乡', '1', '230805200', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('230805201', '230805', '建国乡', '1', '230805201', null, '3', '1'),
('230811001', '230811', '佳西街道', '1', '230811001', null, '3', '1'),
('230811002', '230811', '友谊街道', '1', '230811002', null, '3', '1'),
('230811101', '230811', '大来镇', '1', '230811101', null, '3', '1'),
('230811102', '230811', '敖其镇', '1', '230811102', null, '3', '1'),
('230811103', '230811', '望江镇', '1', '230811103', null, '3', '1'),
('230811104', '230811', '长发镇', '1', '230811104', null, '3', '1'),
('230811105', '230811', '莲江口镇', '1', '230811105', null, '3', '1'),
('230811200', '230811', '长青乡', '1', '230811200', null, '3', '1'),
('230811201', '230811', '沿江乡', '1', '230811201', null, '3', '1'),
('230811202', '230811', '西格木乡', '1', '230811202', null, '3', '1'),
('230811208', '230811', '平安乡', '1', '230811208', null, '3', '1'),
('230811210', '230811', '四丰乡', '1', '230811210', null, '3', '1'),
('230811211', '230811', '群胜乡', '1', '230811211', null, '3', '1'),
('230811580', '230811', '莲江口监狱', '1', '230811580', null, '3', '1'),
('230822103', '230822', '驼腰子镇', '1', '230822103', null, '3', '1'),
('230822104', '230822', '石头河子镇', '1', '230822104', null, '3', '1'),
('230822106', '230822', '桦南镇', '1', '230822106', null, '3', '1'),
('230822107', '230822', '土龙山镇', '1', '230822107', null, '3', '1'),
('230822108', '230822', '孟家岗镇', '1', '230822108', null, '3', '1'),
('230822109', '230822', '闫家镇', '1', '230822109', null, '3', '1'),
('230822205', '230822', '金沙乡', '1', '230822205', null, '3', '1'),
('230822213', '230822', '梨树乡', '1', '230822213', null, '3', '1'),
('230822214', '230822', '明义乡', '1', '230822214', null, '3', '1'),
('230822215', '230822', '大八浪乡', '1', '230822215', null, '3', '1'),
('230822400', '230822', '桦南林业局', '1', '230822400', null, '3', '1'),
('230822500', '230822', '曙光农场', '1', '230822500', null, '3', '1'),
('230822580', '230822', '桦南种畜场', '1', '230822580', null, '3', '1'),
('230826101', '230826', '横头山镇', '1', '230826101', null, '3', '1'),
('230826103', '230826', '苏家店镇', '1', '230826103', null, '3', '1'),
('230826104', '230826', '悦来镇', '1', '230826104', null, '3', '1'),
('230826105', '230826', '新城镇', '1', '230826105', null, '3', '1'),
('230826201', '230826', '东河乡', '1', '230826201', null, '3', '1'),
('230826202', '230826', '梨丰乡', '1', '230826202', null, '3', '1'),
('230826205', '230826', '创业乡', '1', '230826205', null, '3', '1'),
('230826207', '230826', '星火乡', '1', '230826207', null, '3', '1'),
('230826208', '230826', '四马架乡', '1', '230826208', null, '3', '1'),
('230826500', '230826', '江川农场', '1', '230826500', null, '3', '1'),
('230826501', '230826', '宝山农场', '1', '230826501', null, '3', '1'),
('230828101', '230828', '香兰镇', '1', '230828101', null, '3', '1'),
('230828102', '230828', '鹤立镇', '1', '230828102', null, '3', '1'),
('230828103', '230828', '竹帘镇', '1', '230828103', null, '3', '1'),
('230828104', '230828', '汤原镇', '1', '230828104', null, '3', '1'),
('230828201', '230828', '汤旺乡', '1', '230828201', null, '3', '1'),
('230828203', '230828', '胜利乡', '1', '230828203', null, '3', '1'),
('230828208', '230828', '吉祥乡', '1', '230828208', null, '3', '1'),
('230828209', '230828', '振兴乡', '1', '230828209', null, '3', '1'),
('230828210', '230828', '太平川乡', '1', '230828210', null, '3', '1'),
('230828211', '230828', '永发乡', '1', '230828211', null, '3', '1'),
('230828400', '230828', '鹤立林业局', '1', '230828400', null, '3', '1'),
('230828401', '230828', '香兰监狱', '1', '230828401', null, '3', '1'),
('230828500', '230828', '汤原农场', '1', '230828500', null, '3', '1'),
('230828501', '230828', '梧桐河农场', '1', '230828501', null, '3', '1'),
('230833100', '230833', '抚远镇', '1', '230833100', null, '3', '1'),
('230833101', '230833', '寒葱沟镇', '1', '230833101', null, '3', '1'),
('230833102', '230833', '浓桥镇', '1', '230833102', null, '3', '1'),
('230833103', '230833', '抓吉镇', '1', '230833103', null, '3', '1'),
('230833200', '230833', '通江乡', '1', '230833200', null, '3', '1'),
('230833201', '230833', '浓江乡', '1', '230833201', null, '3', '1'),
('230833202', '230833', '海青乡', '1', '230833202', null, '3', '1'),
('230833203', '230833', '别拉洪乡', '1', '230833203', null, '3', '1'),
('230833204', '230833', '鸭南乡', '1', '230833204', null, '3', '1'),
('230833500', '230833', '前哨农场', '1', '230833500', null, '3', '1'),
('230833501', '230833', '前锋农场', '1', '230833501', null, '3', '1'),
('230833502', '230833', '二道河农场', '1', '230833502', null, '3', '1'),
('230881003', '230881', '杏林街道', '1', '230881003', null, '3', '1'),
('230881004', '230881', '和兴街道', '1', '230881004', null, '3', '1'),
('230881005', '230881', '安康街道', '1', '230881005', null, '3', '1'),
('230881006', '230881', '幸福街道', '1', '230881006', null, '3', '1'),
('230881100', '230881', '同江镇', '1', '230881100', null, '3', '1'),
('230881101', '230881', '乐业镇', '1', '230881101', null, '3', '1'),
('230881102', '230881', '三村镇', '1', '230881102', null, '3', '1'),
('230881103', '230881', '临江镇', '1', '230881103', null, '3', '1'),
('230881201', '230881', '向阳乡', '1', '230881201', null, '3', '1'),
('230881203', '230881', '青河乡', '1', '230881203', null, '3', '1'),
('230881204', '230881', '街津口乡', '1', '230881204', null, '3', '1'),
('230881205', '230881', '八岔乡', '1', '230881205', null, '3', '1'),
('230881206', '230881', '金川乡', '1', '230881206', null, '3', '1'),
('230881207', '230881', '银川乡', '1', '230881207', null, '3', '1'),
('230881400', '230881', '街津口林场', '1', '230881400', null, '3', '1'),
('230881401', '230881', '鸭北林场', '1', '230881401', null, '3', '1'),
('230881500', '230881', '勤得利农场', '1', '230881500', null, '3', '1'),
('230881501', '230881', '青龙山农场', '1', '230881501', null, '3', '1'),
('230881502', '230881', '前进农场', '1', '230881502', null, '3', '1'),
('230881503', '230881', '洪河农场', '1', '230881503', null, '3', '1'),
('230881504', '230881', '鸭绿河农场', '1', '230881504', null, '3', '1'),
('230881505', '230881', '浓江农场', '1', '230881505', null, '3', '1'),
('230881580', '230881', '良种场', '1', '230881580', null, '3', '1'),
('230881581', '230881', '果树场', '1', '230881581', null, '3', '1'),
('230881582', '230881', '马场', '1', '230881582', null, '3', '1'),
('230881583', '230881', '干校', '1', '230881583', null, '3', '1'),
('230881584', '230881', '知青农场', '1', '230881584', null, '3', '1'),
('230882001', '230882', '城市街道社区委员会', '1', '230882001', null, '3', '1'),
('230882002', '230882', '城关街道社区建设委员会', '1', '230882002', null, '3', '1'),
('230882103', '230882', '长安镇', '1', '230882103', null, '3', '1'),
('230882106', '230882', '砚山镇', '1', '230882106', null, '3', '1'),
('230882107', '230882', '头林镇', '1', '230882107', null, '3', '1'),
('230882108', '230882', '兴隆岗镇', '1', '230882108', null, '3', '1'),
('230882109', '230882', '宏胜镇', '1', '230882109', null, '3', '1'),
('230882110', '230882', '向阳川镇', '1', '230882110', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('230882111', '230882', '二龙山镇', '1', '230882111', null, '3', '1'),
('230882112', '230882', '上街基镇', '1', '230882112', null, '3', '1'),
('230882113', '230882', '锦山镇', '1', '230882113', null, '3', '1'),
('230882114', '230882', '大榆树镇', '1', '230882114', null, '3', '1'),
('230882400', '230882', '石砬山林场', '1', '230882400', null, '3', '1'),
('230882401', '230882', '东风岗林场', '1', '230882401', null, '3', '1'),
('230882402', '230882', '太东林场', '1', '230882402', null, '3', '1'),
('230882403', '230882', '工农林场', '1', '230882403', null, '3', '1'),
('230882500', '230882', '建三江分局局直', '1', '230882500', null, '3', '1'),
('230882501', '230882', '七星农场', '1', '230882501', null, '3', '1'),
('230882502', '230882', '大兴农场', '1', '230882502', null, '3', '1'),
('230882503', '230882', '创业农场', '1', '230882503', null, '3', '1'),
('230882580', '230882', '种猪场', '1', '230882580', null, '3', '1'),
('230882581', '230882', '种蓄场', '1', '230882581', null, '3', '1'),
('230902001', '230902', '兴华街道', '1', '230902001', null, '3', '1'),
('230902002', '230902', '新城街道', '1', '230902002', null, '3', '1'),
('230902003', '230902', '新立街道', '1', '230902003', null, '3', '1'),
('230902004', '230902', '新建街道', '1', '230902004', null, '3', '1'),
('230902005', '230902', '北山街道', '1', '230902005', null, '3', '1'),
('230902006', '230902', '河南街道', '1', '230902006', null, '3', '1'),
('230902007', '230902', '新合街道', '1', '230902007', null, '3', '1'),
('230902008', '230902', '缸窑沟街道', '1', '230902008', null, '3', '1'),
('230902009', '230902', '新安街道', '1', '230902009', null, '3', '1'),
('230902010', '230902', '越秀街道', '1', '230902010', null, '3', '1'),
('230902100', '230902', '红旗镇', '1', '230902100', null, '3', '1'),
('230903001', '230903', '桃南街道', '1', '230903001', null, '3', '1'),
('230903002', '230903', '桃北街道', '1', '230903002', null, '3', '1'),
('230903003', '230903', '桃西街道', '1', '230903003', null, '3', '1'),
('230903004', '230903', '兴岗街道', '1', '230903004', null, '3', '1'),
('230903005', '230903', '桃东街道', '1', '230903005', null, '3', '1'),
('230903006', '230903', '桃山街道', '1', '230903006', null, '3', '1'),
('230903100', '230903', '万宝河镇', '1', '230903100', null, '3', '1'),
('230904001', '230904', '东风街道', '1', '230904001', null, '3', '1'),
('230904002', '230904', '向阳街道', '1', '230904002', null, '3', '1'),
('230904003', '230904', '富强街道', '1', '230904003', null, '3', '1'),
('230904004', '230904', '新富街道', '1', '230904004', null, '3', '1'),
('230904005', '230904', '龙湖街道', '1', '230904005', null, '3', '1'),
('230904100', '230904', '茄子河镇', '1', '230904100', null, '3', '1'),
('230904101', '230904', '宏伟镇', '1', '230904101', null, '3', '1'),
('230904200', '230904', '铁山乡', '1', '230904200', null, '3', '1'),
('230904201', '230904', '中心河乡', '1', '230904201', null, '3', '1'),
('230921001', '230921', '新起街道', '1', '230921001', null, '3', '1'),
('230921002', '230921', '新华街道', '1', '230921002', null, '3', '1'),
('230921003', '230921', '元明街道', '1', '230921003', null, '3', '1'),
('230921004', '230921', '铁西街道', '1', '230921004', null, '3', '1'),
('230921005', '230921', '城西街道', '1', '230921005', null, '3', '1'),
('230921100', '230921', '勃利镇', '1', '230921100', null, '3', '1'),
('230921101', '230921', '小五站镇', '1', '230921101', null, '3', '1'),
('230921102', '230921', '大四站镇', '1', '230921102', null, '3', '1'),
('230921103', '230921', '双河镇', '1', '230921103', null, '3', '1'),
('230921104', '230921', '倭肯镇', '1', '230921104', null, '3', '1'),
('230921200', '230921', '青山乡', '1', '230921200', null, '3', '1'),
('230921201', '230921', '长兴乡', '1', '230921201', null, '3', '1'),
('230921202', '230921', '永恒乡', '1', '230921202', null, '3', '1'),
('230921203', '230921', '抢垦乡', '1', '230921203', null, '3', '1'),
('230921204', '230921', '杏树朝鲜族乡', '1', '230921204', null, '3', '1'),
('230921205', '230921', '吉兴朝鲜族满族乡', '1', '230921205', null, '3', '1'),
('230921500', '230921', '北兴农场', '1', '230921500', null, '3', '1'),
('230921580', '230921', '种畜场', '1', '230921580', null, '3', '1'),
('231002001', '231002', '新安街道', '1', '231002001', null, '3', '1'),
('231002002', '231002', '长安街道', '1', '231002002', null, '3', '1'),
('231002003', '231002', '七星街道', '1', '231002003', null, '3', '1'),
('231002004', '231002', '五星街道', '1', '231002004', null, '3', '1'),
('231002100', '231002', '兴隆镇', '1', '231002100', null, '3', '1'),
('231003001', '231003', '阳明街道', '1', '231003001', null, '3', '1'),
('231003002', '231003', '前进街道', '1', '231003002', null, '3', '1'),
('231003003', '231003', '新兴街道', '1', '231003003', null, '3', '1'),
('231003004', '231003', '桦林橡胶厂街道', '1', '231003004', null, '3', '1'),
('231003100', '231003', '铁岭镇', '1', '231003100', null, '3', '1'),
('231003101', '231003', '桦林镇', '1', '231003101', null, '3', '1'),
('231004001', '231004', '向阳街道', '1', '231004001', null, '3', '1'),
('231004002', '231004', '黄花街道', '1', '231004002', null, '3', '1'),
('231004003', '231004', '铁北街道', '1', '231004003', null, '3', '1'),
('231004004', '231004', '新华街道', '1', '231004004', null, '3', '1'),
('231004005', '231004', '大庆街道', '1', '231004005', null, '3', '1'),
('231004006', '231004', '兴平街道', '1', '231004006', null, '3', '1'),
('231004007', '231004', '北山街道', '1', '231004007', null, '3', '1'),
('231004201', '231004', '北安乡', '1', '231004201', null, '3', '1'),
('231005001', '231005', '先锋街道', '1', '231005001', null, '3', '1'),
('231005002', '231005', '火炬街道', '1', '231005002', null, '3', '1'),
('231005003', '231005', '立新街道', '1', '231005003', null, '3', '1'),
('231005004', '231005', '牡丹街道', '1', '231005004', null, '3', '1'),
('231005005', '231005', '江滨街道', '1', '231005005', null, '3', '1'),
('231005006', '231005', '沿江街道', '1', '231005006', null, '3', '1'),
('231005100', '231005', '温春镇', '1', '231005100', null, '3', '1'),
('231005200', '231005', '沿江乡', '1', '231005200', null, '3', '1'),
('231024100', '231024', '东宁镇', '1', '231024100', null, '3', '1'),
('231024101', '231024', '三岔口镇', '1', '231024101', null, '3', '1'),
('231024102', '231024', '大肚川镇', '1', '231024102', null, '3', '1'),
('231024103', '231024', '老黑山镇', '1', '231024103', null, '3', '1'),
('231024104', '231024', '道河镇', '1', '231024104', null, '3', '1'),
('231024105', '231024', '绥阳镇', '1', '231024105', null, '3', '1'),
('231024400', '231024', '绥阳林业局', '1', '231024400', null, '3', '1'),
('231025100', '231025', '林口镇', '1', '231025100', null, '3', '1'),
('231025101', '231025', '古城镇', '1', '231025101', null, '3', '1'),
('231025102', '231025', '刁翎镇', '1', '231025102', null, '3', '1'),
('231025103', '231025', '五林镇', '1', '231025103', null, '3', '1'),
('231025104', '231025', '朱家镇', '1', '231025104', null, '3', '1'),
('231025105', '231025', '柳树镇', '1', '231025105', null, '3', '1'),
('231025106', '231025', '三道通镇', '1', '231025106', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('231025107', '231025', '龙爪镇', '1', '231025107', null, '3', '1'),
('231025108', '231025', '莲花镇', '1', '231025108', null, '3', '1'),
('231025200', '231025', '奎山乡', '1', '231025200', null, '3', '1'),
('231025201', '231025', '青山乡', '1', '231025201', null, '3', '1'),
('231025202', '231025', '建堂乡', '1', '231025202', null, '3', '1'),
('231025400', '231025', '林口林业局', '1', '231025400', null, '3', '1'),
('231081100', '231081', '绥芬河镇', '1', '231081100', null, '3', '1'),
('231081101', '231081', '阜宁镇', '1', '231081101', null, '3', '1'),
('231083100', '231083', '海林镇', '1', '231083100', null, '3', '1'),
('231083101', '231083', '长汀镇', '1', '231083101', null, '3', '1'),
('231083102', '231083', '横道镇', '1', '231083102', null, '3', '1'),
('231083103', '231083', '山市镇', '1', '231083103', null, '3', '1'),
('231083104', '231083', '柴河镇', '1', '231083104', null, '3', '1'),
('231083105', '231083', '二道镇', '1', '231083105', null, '3', '1'),
('231083106', '231083', '新安朝鲜族镇', '1', '231083106', null, '3', '1'),
('231083107', '231083', '三道镇', '1', '231083107', null, '3', '1'),
('231083201', '231083', '海南朝鲜族乡', '1', '231083201', null, '3', '1'),
('231083400', '231083', '牡林工程公司街道', '1', '231083400', null, '3', '1'),
('231083401', '231083', '柴河林机厂街道', '1', '231083401', null, '3', '1'),
('231083402', '231083', '大海林林业局', '1', '231083402', null, '3', '1'),
('231083403', '231083', '海林林业局', '1', '231083403', null, '3', '1'),
('231083404', '231083', '柴河林业局', '1', '231083404', null, '3', '1'),
('231083500', '231083', '海林农场', '1', '231083500', null, '3', '1'),
('231083580', '231083', '山市种奶牛场', '1', '231083580', null, '3', '1'),
('231084001', '231084', '城区街道', '1', '231084001', null, '3', '1'),
('231084100', '231084', '宁安镇', '1', '231084100', null, '3', '1'),
('231084101', '231084', '东京城镇', '1', '231084101', null, '3', '1'),
('231084102', '231084', '渤海镇', '1', '231084102', null, '3', '1'),
('231084103', '231084', '石岩镇', '1', '231084103', null, '3', '1'),
('231084104', '231084', '沙兰镇', '1', '231084104', null, '3', '1'),
('231084105', '231084', '海浪镇', '1', '231084105', null, '3', '1'),
('231084106', '231084', '兰岗镇', '1', '231084106', null, '3', '1'),
('231084202', '231084', '江南朝鲜族满族乡', '1', '231084202', null, '3', '1'),
('231084206', '231084', '卧龙朝鲜族乡', '1', '231084206', null, '3', '1'),
('231084208', '231084', '马河乡', '1', '231084208', null, '3', '1'),
('231084210', '231084', '镜泊乡', '1', '231084210', null, '3', '1'),
('231084211', '231084', '三陵乡', '1', '231084211', null, '3', '1'),
('231084400', '231084', '东京城林业局', '1', '231084400', null, '3', '1'),
('231084500', '231084', '宁安农场', '1', '231084500', null, '3', '1'),
('231085100', '231085', '八面通镇', '1', '231085100', null, '3', '1'),
('231085101', '231085', '穆棱镇', '1', '231085101', null, '3', '1'),
('231085102', '231085', '下城子镇', '1', '231085102', null, '3', '1'),
('231085103', '231085', '马桥河镇', '1', '231085103', null, '3', '1'),
('231085104', '231085', '兴源镇', '1', '231085104', null, '3', '1'),
('231085105', '231085', '磨刀石镇', '1', '231085105', null, '3', '1'),
('231085200', '231085', '福录乡', '1', '231085200', null, '3', '1'),
('231085201', '231085', '河西乡', '1', '231085201', null, '3', '1'),
('231085202', '231085', '共和乡', '1', '231085202', null, '3', '1'),
('231085400', '231085', '八面通林业局', '1', '231085400', null, '3', '1'),
('231085401', '231085', '穆棱林业局', '1', '231085401', null, '3', '1'),
('231102001', '231102', '花园街道', '1', '231102001', null, '3', '1'),
('231102002', '231102', '兴安街道', '1', '231102002', null, '3', '1'),
('231102003', '231102', '海兰街道', '1', '231102003', null, '3', '1'),
('231102004', '231102', '西兴街道', '1', '231102004', null, '3', '1'),
('231102101', '231102', '西岗子镇', '1', '231102101', null, '3', '1'),
('231102102', '231102', '爱辉镇', '1', '231102102', null, '3', '1'),
('231102103', '231102', '罕达汽镇', '1', '231102103', null, '3', '1'),
('231102200', '231102', '幸福乡', '1', '231102200', null, '3', '1'),
('231102201', '231102', '四嘉子乡', '1', '231102201', null, '3', '1'),
('231102202', '231102', '坤河乡', '1', '231102202', null, '3', '1'),
('231102203', '231102', '上马厂乡', '1', '231102203', null, '3', '1'),
('231102204', '231102', '张地营子乡', '1', '231102204', null, '3', '1'),
('231102205', '231102', '西峰山乡', '1', '231102205', null, '3', '1'),
('231102206', '231102', '新生乡', '1', '231102206', null, '3', '1'),
('231102207', '231102', '二站乡', '1', '231102207', null, '3', '1'),
('231102400', '231102', '宋集屯煤矿', '1', '231102400', null, '3', '1'),
('231102401', '231102', '西岗子煤矿', '1', '231102401', null, '3', '1'),
('231102402', '231102', '东方红煤矿', '1', '231102402', null, '3', '1'),
('231102407', '231102', '大平林场', '1', '231102407', null, '3', '1'),
('231102408', '231102', '七二七林场', '1', '231102408', null, '3', '1'),
('231102409', '231102', '望峰林场', '1', '231102409', null, '3', '1'),
('231102410', '231102', '卡伦山林场', '1', '231102410', null, '3', '1'),
('231102411', '231102', '胜山林场', '1', '231102411', null, '3', '1'),
('231102412', '231102', '二站林场', '1', '231102412', null, '3', '1'),
('231102413', '231102', '三站林场', '1', '231102413', null, '3', '1'),
('231102414', '231102', '大岭林场', '1', '231102414', null, '3', '1'),
('231102415', '231102', '桦皮窑林场', '1', '231102415', null, '3', '1'),
('231102416', '231102', '滨南林场', '1', '231102416', null, '3', '1'),
('231102417', '231102', '江防林场', '1', '231102417', null, '3', '1'),
('231102421', '231102', '西岗子试验林场', '1', '231102421', null, '3', '1'),
('231102422', '231102', '种畜场', '1', '231102422', null, '3', '1'),
('231102423', '231102', '第二良种场', '1', '231102423', null, '3', '1'),
('231102424', '231102', '第一良种场', '1', '231102424', null, '3', '1'),
('231102425', '231102', '大新屯储木场', '1', '231102425', null, '3', '1'),
('231102500', '231102', '锦河农场', '1', '231102500', null, '3', '1'),
('231121100', '231121', '嫩江镇', '1', '231121100', null, '3', '1'),
('231121101', '231121', '伊拉哈镇', '1', '231121101', null, '3', '1'),
('231121102', '231121', '双山镇', '1', '231121102', null, '3', '1'),
('231121103', '231121', '多宝山镇', '1', '231121103', null, '3', '1'),
('231121104', '231121', '海江镇', '1', '231121104', null, '3', '1'),
('231121105', '231121', '前进镇', '1', '231121105', null, '3', '1'),
('231121106', '231121', '长福镇', '1', '231121106', null, '3', '1'),
('231121107', '231121', '科洛镇', '1', '231121107', null, '3', '1'),
('231121202', '231121', '临江乡', '1', '231121202', null, '3', '1'),
('231121206', '231121', '联兴乡', '1', '231121206', null, '3', '1'),
('231121207', '231121', '白云乡', '1', '231121207', null, '3', '1'),
('231121208', '231121', '塔溪乡', '1', '231121208', null, '3', '1'),
('231121210', '231121', '霍龙门乡', '1', '231121210', null, '3', '1'),
('231121400', '231121', '多宝山铜矿', '1', '231121400', null, '3', '1'),
('231121500', '231121', '九三分局局直', '1', '231121500', null, '3', '1'),
('231121501', '231121', '鹤山农场', '1', '231121501', null, '3', '1'),
('231121502', '231121', '大西江农场', '1', '231121502', null, '3', '1'),
('231121503', '231121', '尖山农场', '1', '231121503', null, '3', '1'),
('231121504', '231121', '荣军农场', '1', '231121504', null, '3', '1'),
('231121505', '231121', '红五月农场', '1', '231121505', null, '3', '1'),
('231121506', '231121', '七星泡农场', '1', '231121506', null, '3', '1'),
('231121507', '231121', '嫩江农场', '1', '231121507', null, '3', '1'),
('231121508', '231121', '山河农场', '1', '231121508', null, '3', '1'),
('231121509', '231121', '嫩北农场', '1', '231121509', null, '3', '1'),
('231121510', '231121', '建边农场', '1', '231121510', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('231121580', '231121', '种畜场', '1', '231121580', null, '3', '1'),
('231121581', '231121', '马铃薯原种繁殖场', '1', '231121581', null, '3', '1'),
('231123001', '231123', '奇克街道', '1', '231123001', null, '3', '1'),
('231123100', '231123', '边疆镇', '1', '231123100', null, '3', '1'),
('231123101', '231123', '逊河镇', '1', '231123101', null, '3', '1'),
('231123201', '231123', '干岔子乡', '1', '231123201', null, '3', '1'),
('231123202', '231123', '松树沟乡', '1', '231123202', null, '3', '1'),
('231123203', '231123', '车陆乡', '1', '231123203', null, '3', '1'),
('231123204', '231123', '新鄂乡', '1', '231123204', null, '3', '1'),
('231123205', '231123', '新兴乡', '1', '231123205', null, '3', '1'),
('231123206', '231123', '克林乡', '1', '231123206', null, '3', '1'),
('231123207', '231123', '宝山乡', '1', '231123207', null, '3', '1'),
('231123402', '231123', '道干林场', '1', '231123402', null, '3', '1'),
('231123403', '231123', '干岔子林场', '1', '231123403', null, '3', '1'),
('231123404', '231123', '新立林场', '1', '231123404', null, '3', '1'),
('231123405', '231123', '三间房林场', '1', '231123405', null, '3', '1'),
('231123406', '231123', '良种场', '1', '231123406', null, '3', '1'),
('231123407', '231123', '种畜场', '1', '231123407', null, '3', '1'),
('231123500', '231123', '逊克农场', '1', '231123500', null, '3', '1'),
('231124001', '231124', '孙吴城区街道', '1', '231124001', null, '3', '1'),
('231124100', '231124', '孙吴镇', '1', '231124100', null, '3', '1'),
('231124101', '231124', '辰清镇', '1', '231124101', null, '3', '1'),
('231124201', '231124', '西兴乡', '1', '231124201', null, '3', '1'),
('231124202', '231124', '沿江满族乡', '1', '231124202', null, '3', '1'),
('231124203', '231124', '腰屯乡', '1', '231124203', null, '3', '1'),
('231124204', '231124', '卧牛河乡', '1', '231124204', null, '3', '1'),
('231124205', '231124', '群山乡', '1', '231124205', null, '3', '1'),
('231124206', '231124', '奋斗乡', '1', '231124206', null, '3', '1'),
('231124207', '231124', '红旗乡', '1', '231124207', null, '3', '1'),
('231124208', '231124', '正阳山乡', '1', '231124208', null, '3', '1'),
('231124210', '231124', '清溪乡', '1', '231124210', null, '3', '1'),
('231124402', '231124', '前进林场', '1', '231124402', null, '3', '1'),
('231124403', '231124', '大河口林场', '1', '231124403', null, '3', '1'),
('231124404', '231124', '正阳林场', '1', '231124404', null, '3', '1'),
('231124405', '231124', '平山林场', '1', '231124405', null, '3', '1'),
('231124406', '231124', '沿江林场', '1', '231124406', null, '3', '1'),
('231124407', '231124', '辰清林场', '1', '231124407', null, '3', '1'),
('231124408', '231124', '红旗林场', '1', '231124408', null, '3', '1'),
('231124409', '231124', '向阳林场', '1', '231124409', null, '3', '1'),
('231124410', '231124', '良种场', '1', '231124410', null, '3', '1'),
('231124411', '231124', '种畜场', '1', '231124411', null, '3', '1'),
('231124500', '231124', '红色边疆农场', '1', '231124500', null, '3', '1'),
('231181001', '231181', '兆麟街道', '1', '231181001', null, '3', '1'),
('231181002', '231181', '和平街道', '1', '231181002', null, '3', '1'),
('231181003', '231181', '北岗街道', '1', '231181003', null, '3', '1'),
('231181004', '231181', '庆华街道', '1', '231181004', null, '3', '1'),
('231181005', '231181', '铁西街道', '1', '231181005', null, '3', '1'),
('231181006', '231181', '铁南街道', '1', '231181006', null, '3', '1'),
('231181101', '231181', '通北镇', '1', '231181101', null, '3', '1'),
('231181102', '231181', '赵光镇', '1', '231181102', null, '3', '1'),
('231181103', '231181', '海星镇', '1', '231181103', null, '3', '1'),
('231181104', '231181', '石泉镇', '1', '231181104', null, '3', '1'),
('231181105', '231181', '二井镇', '1', '231181105', null, '3', '1'),
('231181200', '231181', '城郊乡', '1', '231181200', null, '3', '1'),
('231181201', '231181', '东胜乡', '1', '231181201', null, '3', '1'),
('231181203', '231181', '杨家乡', '1', '231181203', null, '3', '1'),
('231181207', '231181', '主星乡', '1', '231181207', null, '3', '1'),
('231181400', '231181', '通北林业局', '1', '231181400', null, '3', '1'),
('231181500', '231181', '北安分局局直', '1', '231181500', null, '3', '1'),
('231181501', '231181', '长水河农场', '1', '231181501', null, '3', '1'),
('231181502', '231181', '赵光农场', '1', '231181502', null, '3', '1'),
('231181503', '231181', '红星农场', '1', '231181503', null, '3', '1'),
('231181504', '231181', '建设农场', '1', '231181504', null, '3', '1'),
('231182001', '231182', '青山街道', '1', '231182001', null, '3', '1'),
('231182101', '231182', '龙镇', '1', '231182101', null, '3', '1'),
('231182102', '231182', '和平镇', '1', '231182102', null, '3', '1'),
('231182103', '231182', '五大连池镇', '1', '231182103', null, '3', '1'),
('231182201', '231182', '新发乡', '1', '231182201', null, '3', '1'),
('231182202', '231182', '兴隆乡', '1', '231182202', null, '3', '1'),
('231182203', '231182', '建设乡', '1', '231182203', null, '3', '1'),
('231182205', '231182', '太平乡', '1', '231182205', null, '3', '1'),
('231182206', '231182', '双泉乡', '1', '231182206', null, '3', '1'),
('231182207', '231182', '团结乡', '1', '231182207', null, '3', '1'),
('231182208', '231182', '兴安乡', '1', '231182208', null, '3', '1'),
('231182210', '231182', '朝阳乡', '1', '231182210', null, '3', '1'),
('231182400', '231182', '花园劳教所', '1', '231182400', null, '3', '1'),
('231182401', '231182', '永丰监狱', '1', '231182401', null, '3', '1'),
('231182402', '231182', '华山监狱', '1', '231182402', null, '3', '1'),
('231182403', '231182', '凤凰山监狱', '1', '231182403', null, '3', '1'),
('231182406', '231182', '元青山林场', '1', '231182406', null, '3', '1'),
('231182407', '231182', '三九六林场', '1', '231182407', null, '3', '1'),
('231182408', '231182', '小兴安林场', '1', '231182408', null, '3', '1'),
('231182409', '231182', '二龙山林场', '1', '231182409', null, '3', '1'),
('231182410', '231182', '朝阳林场', '1', '231182410', null, '3', '1'),
('231182411', '231182', '引龙河林场', '1', '231182411', null, '3', '1'),
('231182412', '231182', '焦得布林场', '1', '231182412', null, '3', '1'),
('231182417', '231182', '沾河林业局', '1', '231182417', null, '3', '1'),
('231182418', '231182', '莲花管理委员会', '1', '231182418', null, '3', '1'),
('231182427', '231182', '二龙山蚕种场', '1', '231182427', null, '3', '1'),
('231182428', '231182', '五大连池原种场', '1', '231182428', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('231182429', '231182', '畜牧场', '1', '231182429', null, '3', '1'),
('231182430', '231182', '第二良种场', '1', '231182430', null, '3', '1'),
('231182501', '231182', '龙门农场', '1', '231182501', null, '3', '1'),
('231182502', '231182', '襄河农场', '1', '231182502', null, '3', '1'),
('231182503', '231182', '龙镇农场', '1', '231182503', null, '3', '1'),
('231182504', '231182', '二龙山农场', '1', '231182504', null, '3', '1'),
('231182505', '231182', '引龙河农场', '1', '231182505', null, '3', '1'),
('231182506', '231182', '尾山农场', '1', '231182506', null, '3', '1'),
('231182507', '231182', '格球山农场', '1', '231182507', null, '3', '1'),
('231182580', '231182', '大庆农场', '1', '231182580', null, '3', '1'),
('231202001', '231202', '紫来', '1', '231202001', null, '3', '1'),
('231202002', '231202', '爱路', '1', '231202002', null, '3', '1'),
('231202003', '231202', '大有', '1', '231202003', null, '3', '1'),
('231202004', '231202', '吉泰', '1', '231202004', null, '3', '1'),
('231202005', '231202', '东兴', '1', '231202005', null, '3', '1'),
('231202006', '231202', '北林办事处居民委员会', '1', '231202006', null, '3', '1'),
('231202101', '231202', '宝山镇', '1', '231202101', null, '3', '1'),
('231202102', '231202', '绥胜镇', '1', '231202102', null, '3', '1'),
('231202103', '231202', '西长发镇', '1', '231202103', null, '3', '1'),
('231202104', '231202', '永安镇', '1', '231202104', null, '3', '1'),
('231202105', '231202', '太平川镇', '1', '231202105', null, '3', '1'),
('231202106', '231202', '秦家镇', '1', '231202106', null, '3', '1'),
('231202107', '231202', '双河镇', '1', '231202107', null, '3', '1'),
('231202108', '231202', '三河镇', '1', '231202108', null, '3', '1'),
('231202109', '231202', '四方台镇', '1', '231202109', null, '3', '1'),
('231202110', '231202', '津河镇', '1', '231202110', null, '3', '1'),
('231202111', '231202', '张维镇', '1', '231202111', null, '3', '1'),
('231202113', '231202', '东津镇', '1', '231202113', null, '3', '1'),
('231202201', '231202', '红旗乡', '1', '231202201', null, '3', '1'),
('231202202', '231202', '连岗乡', '1', '231202202', null, '3', '1'),
('231202203', '231202', '新华乡', '1', '231202203', null, '3', '1'),
('231202204', '231202', '兴福乡', '1', '231202204', null, '3', '1'),
('231202205', '231202', '东富乡', '1', '231202205', null, '3', '1'),
('231202209', '231202', '三井乡', '1', '231202209', null, '3', '1'),
('231202212', '231202', '五营乡', '1', '231202212', null, '3', '1'),
('231202213', '231202', '兴和乡', '1', '231202213', null, '3', '1'),
('231221100', '231221', '望奎镇', '1', '231221100', null, '3', '1'),
('231221101', '231221', '通江镇', '1', '231221101', null, '3', '1'),
('231221102', '231221', '卫星镇', '1', '231221102', null, '3', '1'),
('231221103', '231221', '海丰镇', '1', '231221103', null, '3', '1'),
('231221104', '231221', '莲花镇', '1', '231221104', null, '3', '1'),
('231221105', '231221', '惠七满族镇', '1', '231221105', null, '3', '1'),
('231221106', '231221', '先锋镇', '1', '231221106', null, '3', '1'),
('231221201', '231221', '东郊乡', '1', '231221201', null, '3', '1'),
('231221202', '231221', '灵山满族乡', '1', '231221202', null, '3', '1'),
('231221203', '231221', '后三乡', '1', '231221203', null, '3', '1'),
('231221206', '231221', '火箭乡', '1', '231221206', null, '3', '1'),
('231221207', '231221', '灯塔乡', '1', '231221207', null, '3', '1'),
('231221209', '231221', '东升乡', '1', '231221209', null, '3', '1'),
('231221210', '231221', '恭六乡', '1', '231221210', null, '3', '1'),
('231221211', '231221', '厢白满族乡', '1', '231221211', null, '3', '1'),
('231221400', '231221', '白四林场', '1', '231221400', null, '3', '1'),
('231221580', '231221', '种畜场', '1', '231221580', null, '3', '1'),
('231221581', '231221', '第一良种场', '1', '231221581', null, '3', '1'),
('231221582', '231221', '第二良种场', '1', '231221582', null, '3', '1'),
('231222101', '231222', '兰西镇', '1', '231222101', null, '3', '1'),
('231222102', '231222', '榆林镇', '1', '231222102', null, '3', '1'),
('231222103', '231222', '临江镇', '1', '231222103', null, '3', '1'),
('231222104', '231222', '平山镇', '1', '231222104', null, '3', '1'),
('231222200', '231222', '康荣乡', '1', '231222200', null, '3', '1'),
('231222201', '231222', '燎原乡', '1', '231222201', null, '3', '1'),
('231222202', '231222', '北安乡', '1', '231222202', null, '3', '1'),
('231222203', '231222', '长江乡', '1', '231222203', null, '3', '1'),
('231222204', '231222', '兰河乡', '1', '231222204', null, '3', '1'),
('231222205', '231222', '红星乡', '1', '231222205', null, '3', '1'),
('231222206', '231222', '红光乡', '1', '231222206', null, '3', '1'),
('231222207', '231222', '长岗乡', '1', '231222207', null, '3', '1'),
('231222209', '231222', '远大乡', '1', '231222209', null, '3', '1'),
('231222210', '231222', '星火乡', '1', '231222210', null, '3', '1'),
('231222211', '231222', '奋斗乡', '1', '231222211', null, '3', '1'),
('231222580', '231222', '第一原种场', '1', '231222580', null, '3', '1'),
('231222581', '231222', '第二原种场', '1', '231222581', null, '3', '1'),
('231222582', '231222', '肉用种羊场', '1', '231222582', null, '3', '1'),
('231223100', '231223', '青冈镇', '1', '231223100', null, '3', '1'),
('231223101', '231223', '中和镇', '1', '231223101', null, '3', '1'),
('231223102', '231223', '祯祥镇', '1', '231223102', null, '3', '1'),
('231223103', '231223', '兴华镇', '1', '231223103', null, '3', '1'),
('231223104', '231223', '永丰镇', '1', '231223104', null, '3', '1'),
('231223105', '231223', '芦河镇', '1', '231223105', null, '3', '1'),
('231223201', '231223', '劳动乡', '1', '231223201', null, '3', '1'),
('231223202', '231223', '建设乡', '1', '231223202', null, '3', '1'),
('231223203', '231223', '新村乡', '1', '231223203', null, '3', '1'),
('231223206', '231223', '昌盛乡', '1', '231223206', null, '3', '1'),
('231223207', '231223', '柞岗乡', '1', '231223207', null, '3', '1'),
('231223208', '231223', '民政乡', '1', '231223208', null, '3', '1'),
('231223209', '231223', '德胜乡', '1', '231223209', null, '3', '1'),
('231223211', '231223', '迎春乡', '1', '231223211', null, '3', '1'),
('231223212', '231223', '连丰乡', '1', '231223212', null, '3', '1'),
('231223400', '231223', '青冈县林场', '1', '231223400', null, '3', '1'),
('231223401', '231223', '青冈县互利营林站', '1', '231223401', null, '3', '1'),
('231223402', '231223', '青冈县果树场', '1', '231223402', null, '3', '1'),
('231223580', '231223', '青冈县种马场', '1', '231223580', null, '3', '1'),
('231223581', '231223', '青冈县种羊场', '1', '231223581', null, '3', '1'),
('231223582', '231223', '青冈县原种场', '1', '231223582', null, '3', '1'),
('231224101', '231224', '庆安镇', '1', '231224101', null, '3', '1'),
('231224102', '231224', '民乐镇', '1', '231224102', null, '3', '1'),
('231224103', '231224', '大罗镇', '1', '231224103', null, '3', '1'),
('231224104', '231224', '平安镇', '1', '231224104', null, '3', '1'),
('231224105', '231224', '勤劳镇', '1', '231224105', null, '3', '1'),
('231224106', '231224', '久胜镇', '1', '231224106', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('231224201', '231224', '建民乡', '1', '231224201', null, '3', '1'),
('231224202', '231224', '巨宝山乡', '1', '231224202', null, '3', '1'),
('231224204', '231224', '新胜乡', '1', '231224204', null, '3', '1'),
('231224206', '231224', '丰收乡', '1', '231224206', null, '3', '1'),
('231224208', '231224', '发展乡', '1', '231224208', null, '3', '1'),
('231224209', '231224', '同乐乡', '1', '231224209', null, '3', '1'),
('231224210', '231224', '致富乡', '1', '231224210', null, '3', '1'),
('231224211', '231224', '欢胜乡', '1', '231224211', null, '3', '1'),
('231224400', '231224', '国有林场管理局', '1', '231224400', null, '3', '1'),
('231224401', '231224', '柳河林校', '1', '231224401', null, '3', '1'),
('231224500', '231224', '柳河农场', '1', '231224500', null, '3', '1'),
('231225100', '231225', '明水镇', '1', '231225100', null, '3', '1'),
('231225101', '231225', '兴仁镇', '1', '231225101', null, '3', '1'),
('231225102', '231225', '永兴镇', '1', '231225102', null, '3', '1'),
('231225103', '231225', '崇德镇', '1', '231225103', null, '3', '1'),
('231225104', '231225', '通达镇', '1', '231225104', null, '3', '1'),
('231225201', '231225', '双兴乡', '1', '231225201', null, '3', '1'),
('231225203', '231225', '永久乡', '1', '231225203', null, '3', '1'),
('231225204', '231225', '树人乡', '1', '231225204', null, '3', '1'),
('231225205', '231225', '光荣乡', '1', '231225205', null, '3', '1'),
('231225206', '231225', '繁荣乡', '1', '231225206', null, '3', '1'),
('231225207', '231225', '通泉乡', '1', '231225207', null, '3', '1'),
('231225208', '231225', '育林乡', '1', '231225208', null, '3', '1'),
('231225400', '231225', '国营林场', '1', '231225400', null, '3', '1'),
('231225580', '231225', '县联社马场', '1', '231225580', null, '3', '1'),
('231225581', '231225', '明水种畜场', '1', '231225581', null, '3', '1'),
('231225582', '231225', '育林畜牧场', '1', '231225582', null, '3', '1'),
('231225583', '231225', '国营第一良种', '1', '231225583', null, '3', '1'),
('231225584', '231225', '国营第二良种', '1', '231225584', null, '3', '1'),
('231225585', '231225', '国营第三良种', '1', '231225585', null, '3', '1'),
('231226100', '231226', '绥棱镇', '1', '231226100', null, '3', '1'),
('231226101', '231226', '上集镇', '1', '231226101', null, '3', '1'),
('231226102', '231226', '四海店镇', '1', '231226102', null, '3', '1'),
('231226103', '231226', '双岔河镇', '1', '231226103', null, '3', '1'),
('231226200', '231226', '靠山乡', '1', '231226200', null, '3', '1'),
('231226201', '231226', '后头乡', '1', '231226201', null, '3', '1'),
('231226203', '231226', '长山乡', '1', '231226203', null, '3', '1'),
('231226205', '231226', '克音河乡', '1', '231226205', null, '3', '1'),
('231226206', '231226', '绥中乡', '1', '231226206', null, '3', '1'),
('231226207', '231226', '泥尔河乡', '1', '231226207', null, '3', '1'),
('231226210', '231226', '阁山乡', '1', '231226210', null, '3', '1'),
('231226400', '231226', '阁山林场', '1', '231226400', null, '3', '1'),
('231226401', '231226', '四海店林场', '1', '231226401', null, '3', '1'),
('231226402', '231226', '三吉台林场', '1', '231226402', null, '3', '1'),
('231226403', '231226', '半截河林场', '1', '231226403', null, '3', '1'),
('231226404', '231226', '绥棱林业局', '1', '231226404', null, '3', '1'),
('231226500', '231226', '绥棱农场', '1', '231226500', null, '3', '1'),
('231226580', '231226', '种马场', '1', '231226580', null, '3', '1'),
('231226581', '231226', '良种场', '1', '231226581', null, '3', '1'),
('231226582', '231226', '奶山羊场', '1', '231226582', null, '3', '1'),
('231281001', '231281', '铁西街道', '1', '231281001', null, '3', '1'),
('231281002', '231281', '新兴街道', '1', '231281002', null, '3', '1'),
('231281003', '231281', '安虹街道', '1', '231281003', null, '3', '1'),
('231281100', '231281', '安达镇', '1', '231281100', null, '3', '1'),
('231281101', '231281', '任民镇', '1', '231281101', null, '3', '1'),
('231281103', '231281', '万宝山镇', '1', '231281103', null, '3', '1'),
('231281104', '231281', '昌德镇', '1', '231281104', null, '3', '1'),
('231281105', '231281', '升平镇', '1', '231281105', null, '3', '1'),
('231281106', '231281', '羊草镇', '1', '231281106', null, '3', '1'),
('231281107', '231281', '老虎岗镇', '1', '231281107', null, '3', '1'),
('231281108', '231281', '中本镇', '1', '231281108', null, '3', '1'),
('231281109', '231281', '太平庄镇', '1', '231281109', null, '3', '1'),
('231281110', '231281', '吉兴岗镇', '1', '231281110', null, '3', '1'),
('231281202', '231281', '火石山乡', '1', '231281202', null, '3', '1'),
('231281204', '231281', '卧里屯乡', '1', '231281204', null, '3', '1'),
('231281205', '231281', '青肯泡乡', '1', '231281205', null, '3', '1'),
('231281209', '231281', '先源乡', '1', '231281209', null, '3', '1'),
('231281500', '231281', '安达畜牧场', '1', '231281500', null, '3', '1'),
('231281580', '231281', '种畜场', '1', '231281580', null, '3', '1'),
('231281581', '231281', '原种场', '1', '231281581', null, '3', '1'),
('231281582', '231281', '种牛场', '1', '231281582', null, '3', '1'),
('231281583', '231281', '红旗泡水库管理所', '1', '231281583', null, '3', '1'),
('231281584', '231281', '东湖水库管理站', '1', '231281584', null, '3', '1'),
('231282001', '231282', '朝阳区', '1', '231282001', null, '3', '1'),
('231282002', '231282', '东升区', '1', '231282002', null, '3', '1'),
('231282003', '231282', '西园区', '1', '231282003', null, '3', '1'),
('231282004', '231282', '正阳区', '1', '231282004', null, '3', '1'),
('231282100', '231282', '肇东镇', '1', '231282100', null, '3', '1'),
('231282101', '231282', '昌五镇', '1', '231282101', null, '3', '1'),
('231282102', '231282', '宋站镇', '1', '231282102', null, '3', '1'),
('231282103', '231282', '五站镇', '1', '231282103', null, '3', '1'),
('231282104', '231282', '尚家镇', '1', '231282104', null, '3', '1'),
('231282105', '231282', '姜家镇', '1', '231282105', null, '3', '1'),
('231282106', '231282', '里木店镇', '1', '231282106', null, '3', '1'),
('231282107', '231282', '四站镇', '1', '231282107', null, '3', '1'),
('231282108', '231282', '涝洲镇', '1', '231282108', null, '3', '1'),
('231282109', '231282', '五里明镇', '1', '231282109', null, '3', '1'),
('231282110', '231282', '黎明镇', '1', '231282110', null, '3', '1'),
('231282201', '231282', '太平乡', '1', '231282201', null, '3', '1'),
('231282203', '231282', '海城乡', '1', '231282203', null, '3', '1'),
('231282204', '231282', '向阳乡', '1', '231282204', null, '3', '1'),
('231282205', '231282', '洪河乡', '1', '231282205', null, '3', '1'),
('231282206', '231282', '跃进乡', '1', '231282206', null, '3', '1'),
('231282211', '231282', '西八里乡', '1', '231282211', null, '3', '1'),
('231282212', '231282', '德昌乡', '1', '231282212', null, '3', '1'),
('231282213', '231282', '宣化乡', '1', '231282213', null, '3', '1'),
('231282214', '231282', '安民乡', '1', '231282214', null, '3', '1'),
('231282215', '231282', '明久乡', '1', '231282215', null, '3', '1'),
('231282500', '231282', '四方山农场', '1', '231282500', null, '3', '1'),
('231283100', '231283', '海伦镇', '1', '231283100', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('231283101', '231283', '海北镇', '1', '231283101', null, '3', '1'),
('231283102', '231283', '伦河镇', '1', '231283102', null, '3', '1'),
('231283103', '231283', '共合镇', '1', '231283103', null, '3', '1'),
('231283104', '231283', '海兴镇', '1', '231283104', null, '3', '1'),
('231283105', '231283', '祥富镇', '1', '231283105', null, '3', '1'),
('231283106', '231283', '东风镇', '1', '231283106', null, '3', '1'),
('231283202', '231283', '前进乡', '1', '231283202', null, '3', '1'),
('231283203', '231283', '向荣乡', '1', '231283203', null, '3', '1'),
('231283204', '231283', '长发乡', '1', '231283204', null, '3', '1'),
('231283205', '231283', '东林乡', '1', '231283205', null, '3', '1'),
('231283208', '231283', '海南乡', '1', '231283208', null, '3', '1'),
('231283209', '231283', '共荣乡', '1', '231283209', null, '3', '1'),
('231283210', '231283', '乐业乡', '1', '231283210', null, '3', '1'),
('231283211', '231283', '福民乡', '1', '231283211', null, '3', '1'),
('231283212', '231283', '丰山乡', '1', '231283212', null, '3', '1'),
('231283213', '231283', '永富乡', '1', '231283213', null, '3', '1'),
('231283215', '231283', '百祥乡', '1', '231283215', null, '3', '1'),
('231283216', '231283', '联发乡', '1', '231283216', null, '3', '1'),
('231283217', '231283', '永和乡', '1', '231283217', null, '3', '1'),
('231283218', '231283', '爱民乡', '1', '231283218', null, '3', '1'),
('231283220', '231283', '扎音河乡', '1', '231283220', null, '3', '1'),
('231283221', '231283', '双录乡', '1', '231283221', null, '3', '1'),
('231283400', '231283', '林场公司', '1', '231283400', null, '3', '1'),
('231283401', '231283', '东方红水库地区', '1', '231283401', null, '3', '1'),
('231283500', '231283', '海伦农场', '1', '231283500', null, '3', '1'),
('231283501', '231283', '红光农场', '1', '231283501', null, '3', '1'),
('231283580', '231283', '海伦绥化种畜场', '1', '231283580', null, '3', '1'),
('231283581', '231283', '海伦二粮种场', '1', '231283581', null, '3', '1'),
('231283582', '231283', '海伦市种畜场', '1', '231283582', null, '3', '1'),
('232701001', '232701', '街道东山社区', '1', '232701001', null, '3', '1'),
('232701002', '232701', '街道卫东社区', '1', '232701002', null, '3', '1'),
('232701003', '232701', '街道红旗社区', '1', '232701003', null, '3', '1'),
('232701004', '232701', '街道长虹社区', '1', '232701004', null, '3', '1'),
('232701005', '232701', '街道曙光社区', '1', '232701005', null, '3', '1'),
('232701006', '232701', '街道光明社区', '1', '232701006', null, '3', '1'),
('232701200', '232701', '加北乡', '1', '232701200', null, '3', '1'),
('232701201', '232701', '白桦乡', '1', '232701201', null, '3', '1'),
('232701400', '232701', '加格达奇林业局', '1', '232701400', null, '3', '1'),
('232701401', '232701', '林田农业开发区', '1', '232701401', null, '3', '1'),
('232702100', '232702', '小扬气镇', '1', '232702100', null, '3', '1'),
('232702101', '232702', '劲松镇', '1', '232702101', null, '3', '1'),
('232702102', '232702', '古源镇', '1', '232702102', null, '3', '1'),
('232702400', '232702', '松岭林业局', '1', '232702400', null, '3', '1'),
('232703100', '232703', '新林镇', '1', '232703100', null, '3', '1'),
('232703101', '232703', '翠岗镇', '1', '232703101', null, '3', '1'),
('232703102', '232703', '塔源镇', '1', '232703102', null, '3', '1'),
('232703103', '232703', '大乌苏镇', '1', '232703103', null, '3', '1'),
('232703104', '232703', '塔尔根镇', '1', '232703104', null, '3', '1'),
('232703105', '232703', '碧洲镇', '1', '232703105', null, '3', '1'),
('232703106', '232703', '宏图镇', '1', '232703106', null, '3', '1'),
('232703400', '232703', '新林林业局', '1', '232703400', null, '3', '1'),
('232704100', '232704', '呼中镇', '1', '232704100', null, '3', '1'),
('232704101', '232704', '碧水镇', '1', '232704101', null, '3', '1'),
('232704102', '232704', '呼源镇', '1', '232704102', null, '3', '1'),
('232704103', '232704', '宏伟镇', '1', '232704103', null, '3', '1'),
('232704400', '232704', '呼中林业局', '1', '232704400', null, '3', '1'),
('232721100', '232721', '呼玛镇', '1', '232721100', null, '3', '1'),
('232721101', '232721', '韩家园镇', '1', '232721101', null, '3', '1'),
('232721200', '232721', '三卡乡', '1', '232721200', null, '3', '1'),
('232721201', '232721', '金山乡', '1', '232721201', null, '3', '1'),
('232721202', '232721', '兴华乡', '1', '232721202', null, '3', '1'),
('232721203', '232721', '鸥浦乡', '1', '232721203', null, '3', '1'),
('232721204', '232721', '白银纳鄂伦春族民族乡', '1', '232721204', null, '3', '1'),
('232721205', '232721', '北疆乡', '1', '232721205', null, '3', '1'),
('232721400', '232721', '韩家园林业局', '1', '232721400', null, '3', '1'),
('232722100', '232722', '塔河镇', '1', '232722100', null, '3', '1'),
('232722101', '232722', '瓦拉干镇', '1', '232722101', null, '3', '1'),
('232722102', '232722', '盘古镇', '1', '232722102', null, '3', '1'),
('232722200', '232722', '十八站鄂伦春族民族乡', '1', '232722200', null, '3', '1'),
('232722201', '232722', '依西肯乡', '1', '232722201', null, '3', '1'),
('232722202', '232722', '开库康乡', '1', '232722202', null, '3', '1'),
('232722400', '232722', '十八站林业局', '1', '232722400', null, '3', '1'),
('232722401', '232722', '塔河林业局', '1', '232722401', null, '3', '1'),
('232723100', '232723', '西林吉镇', '1', '232723100', null, '3', '1'),
('232723101', '232723', '图强镇', '1', '232723101', null, '3', '1'),
('232723102', '232723', '劲涛镇', '1', '232723102', null, '3', '1'),
('232723103', '232723', '兴安镇', '1', '232723103', null, '3', '1'),
('232723200', '232723', '北极乡', '1', '232723200', null, '3', '1'),
('232723400', '232723', '西林吉林业局', '1', '232723400', null, '3', '1'),
('232723401', '232723', '图强林业局', '1', '232723401', null, '3', '1'),
('232723402', '232723', '阿木尔林业局', '1', '232723402', null, '3', '1'),
('310101002', '310101', '南京东路街道', '1', '310101002', null, '3', '1'),
('310101006', '310101', '金陵东路街道', '1', '310101006', null, '3', '1'),
('310101013', '310101', '外滩街道', '1', '310101013', null, '3', '1'),
('310101014', '310101', '人民广场街道', '1', '310101014', null, '3', '1'),
('310101015', '310101', '半淞园路街道', '1', '310101015', null, '3', '1'),
('310101016', '310101', '董家渡街道', '1', '310101016', null, '3', '1'),
('310101017', '310101', '小东门街道', '1', '310101017', null, '3', '1'),
('310101018', '310101', '豫园街道', '1', '310101018', null, '3', '1'),
('310101019', '310101', '老西门街道', '1', '310101019', null, '3', '1'),
('310103001', '310103', '五里桥街道', '1', '310103001', null, '3', '1'),
('310103002', '310103', '打浦桥街道', '1', '310103002', null, '3', '1'),
('310103008', '310103', '淮海中路街道', '1', '310103008', null, '3', '1'),
('310103009', '310103', '瑞金二路街道', '1', '310103009', null, '3', '1'),
('310104003', '310104', '天平路街道', '1', '310104003', null, '3', '1'),
('310104004', '310104', '湖南路街道', '1', '310104004', null, '3', '1'),
('310104007', '310104', '斜土路街道', '1', '310104007', null, '3', '1'),
('310104008', '310104', '枫林路街道', '1', '310104008', null, '3', '1'),
('310104010', '310104', '长桥街道', '1', '310104010', null, '3', '1'),
('310104011', '310104', '田林街道', '1', '310104011', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('310104012', '310104', '虹梅路街道', '1', '310104012', null, '3', '1'),
('310104013', '310104', '康健新村街道', '1', '310104013', null, '3', '1'),
('310104014', '310104', '徐家汇街道', '1', '310104014', null, '3', '1'),
('310104015', '310104', '凌云路街道', '1', '310104015', null, '3', '1'),
('310104016', '310104', '龙华街道', '1', '310104016', null, '3', '1'),
('310104017', '310104', '漕河泾街道', '1', '310104017', null, '3', '1'),
('310104103', '310104', '华泾镇', '1', '310104103', null, '3', '1'),
('310104501', '310104', '漕河泾新兴技术开发区', '1', '310104501', null, '3', '1'),
('310105001', '310105', '华阳路街道', '1', '310105001', null, '3', '1'),
('310105002', '310105', '江苏路街道', '1', '310105002', null, '3', '1'),
('310105004', '310105', '新华路街道', '1', '310105004', null, '3', '1'),
('310105005', '310105', '周家桥街道', '1', '310105005', null, '3', '1'),
('310105006', '310105', '天山路街道', '1', '310105006', null, '3', '1'),
('310105008', '310105', '仙霞新村街道', '1', '310105008', null, '3', '1'),
('310105009', '310105', '虹桥街道', '1', '310105009', null, '3', '1'),
('310105010', '310105', '程家桥街道', '1', '310105010', null, '3', '1'),
('310105011', '310105', '北新泾街道', '1', '310105011', null, '3', '1'),
('310105102', '310105', '新泾镇', '1', '310105102', null, '3', '1'),
('310106006', '310106', '江宁路街道', '1', '310106006', null, '3', '1'),
('310106011', '310106', '石门二路街道', '1', '310106011', null, '3', '1'),
('310106012', '310106', '南京西路街道', '1', '310106012', null, '3', '1'),
('310106013', '310106', '静安寺街道', '1', '310106013', null, '3', '1'),
('310106014', '310106', '曹家渡街道', '1', '310106014', null, '3', '1'),
('310107005', '310107', '曹杨新村街道', '1', '310107005', null, '3', '1'),
('310107014', '310107', '长风新村街道', '1', '310107014', null, '3', '1'),
('310107015', '310107', '长寿路街道', '1', '310107015', null, '3', '1'),
('310107016', '310107', '甘泉路街道', '1', '310107016', null, '3', '1'),
('310107017', '310107', '石泉路街道', '1', '310107017', null, '3', '1'),
('310107020', '310107', '宜川路街道', '1', '310107020', null, '3', '1'),
('310107101', '310107', '真如镇', '1', '310107101', null, '3', '1'),
('310107102', '310107', '长征镇', '1', '310107102', null, '3', '1'),
('310107103', '310107', '桃浦镇', '1', '310107103', null, '3', '1'),
('310108001', '310108', '天目西路街道', '1', '310108001', null, '3', '1'),
('310108006', '310108', '北站街道', '1', '310108006', null, '3', '1'),
('310108007', '310108', '宝山路街道', '1', '310108007', null, '3', '1'),
('310108012', '310108', '共和新路街道', '1', '310108012', null, '3', '1'),
('310108013', '310108', '大宁路街道', '1', '310108013', null, '3', '1'),
('310108014', '310108', '彭浦新村街道', '1', '310108014', null, '3', '1'),
('310108015', '310108', '临汾路街道', '1', '310108015', null, '3', '1'),
('310108016', '310108', '芷江西路街道', '1', '310108016', null, '3', '1'),
('310108101', '310108', '彭浦镇', '1', '310108101', null, '3', '1'),
('310109002', '310109', '乍浦路街道', '1', '310109002', null, '3', '1'),
('310109008', '310109', '新港路街道', '1', '310109008', null, '3', '1'),
('310109009', '310109', '欧阳路街道', '1', '310109009', null, '3', '1'),
('310109010', '310109', '曲阳路街道', '1', '310109010', null, '3', '1'),
('310109011', '310109', '广中路街道', '1', '310109011', null, '3', '1'),
('310109014', '310109', '嘉兴路街道', '1', '310109014', null, '3', '1'),
('310109016', '310109', '凉城新村街道', '1', '310109016', null, '3', '1'),
('310109017', '310109', '四川北路街道', '1', '310109017', null, '3', '1'),
('310109018', '310109', '提篮桥街道', '1', '310109018', null, '3', '1'),
('310109101', '310109', '江湾镇', '1', '310109101', null, '3', '1'),
('310110001', '310110', '定海路街道', '1', '310110001', null, '3', '1'),
('310110006', '310110', '平凉路街道', '1', '310110006', null, '3', '1'),
('310110008', '310110', '江浦路街道', '1', '310110008', null, '3', '1'),
('310110009', '310110', '四平路街道', '1', '310110009', null, '3', '1'),
('310110012', '310110', '控江路街道', '1', '310110012', null, '3', '1'),
('310110013', '310110', '长白新村街道', '1', '310110013', null, '3', '1'),
('310110015', '310110', '延吉新村街道', '1', '310110015', null, '3', '1'),
('310110016', '310110', '殷行街道', '1', '310110016', null, '3', '1'),
('310110018', '310110', '大桥街道', '1', '310110018', null, '3', '1'),
('310110019', '310110', '五角场街道', '1', '310110019', null, '3', '1'),
('310110020', '310110', '新江湾城街道', '1', '310110020', null, '3', '1'),
('310110101', '310110', '五角场镇', '1', '310110101', null, '3', '1'),
('310112001', '310112', '江川路街道', '1', '310112001', null, '3', '1'),
('310112005', '310112', '龙柏街道', '1', '310112005', null, '3', '1'),
('310112006', '310112', '古美街道', '1', '310112006', null, '3', '1'),
('310112101', '310112', '莘庄镇', '1', '310112101', null, '3', '1'),
('310112102', '310112', '七宝镇', '1', '310112102', null, '3', '1'),
('310112103', '310112', '颛桥镇', '1', '310112103', null, '3', '1'),
('310112106', '310112', '华漕镇', '1', '310112106', null, '3', '1'),
('310112107', '310112', '虹桥镇', '1', '310112107', null, '3', '1'),
('310112108', '310112', '梅陇镇', '1', '310112108', null, '3', '1'),
('310112110', '310112', '吴泾镇', '1', '310112110', null, '3', '1'),
('310112112', '310112', '马桥镇', '1', '310112112', null, '3', '1'),
('310112114', '310112', '浦江镇', '1', '310112114', null, '3', '1'),
('310112501', '310112', '莘庄工业区', '1', '310112501', null, '3', '1'),
('310113003', '310113', '友谊路街道', '1', '310113003', null, '3', '1'),
('310113007', '310113', '吴淞街道', '1', '310113007', null, '3', '1'),
('310113008', '310113', '张庙街道', '1', '310113008', null, '3', '1'),
('310113101', '310113', '罗店镇', '1', '310113101', null, '3', '1'),
('310113102', '310113', '大场镇', '1', '310113102', null, '3', '1'),
('310113103', '310113', '杨行镇', '1', '310113103', null, '3', '1'),
('310113104', '310113', '月浦镇', '1', '310113104', null, '3', '1'),
('310113106', '310113', '罗泾镇', '1', '310113106', null, '3', '1'),
('310113109', '310113', '顾村镇', '1', '310113109', null, '3', '1'),
('310113111', '310113', '高境镇', '1', '310113111', null, '3', '1'),
('310113112', '310113', '庙行镇', '1', '310113112', null, '3', '1'),
('310113113', '310113', '淞南镇', '1', '310113113', null, '3', '1'),
('310113501', '310113', '宝山城市工业园区', '1', '310113501', null, '3', '1'),
('310114001', '310114', '新成路街道', '1', '310114001', null, '3', '1'),
('310114002', '310114', '真新新村街道', '1', '310114002', null, '3', '1'),
('310114003', '310114', '菊园新区', '1', '310114003', null, '3', '1'),
('310114004', '310114', '嘉定镇街道', '1', '310114004', null, '3', '1'),
('310114102', '310114', '南翔镇', '1', '310114102', null, '3', '1'),
('310114103', '310114', '安亭镇', '1', '310114103', null, '3', '1'),
('310114106', '310114', '马陆镇', '1', '310114106', null, '3', '1'),
('310114109', '310114', '徐行镇', '1', '310114109', null, '3', '1'),
('310114111', '310114', '华亭镇', '1', '310114111', null, '3', '1'),
('310114114', '310114', '外冈镇', '1', '310114114', null, '3', '1'),
('310114117', '310114', '黄渡镇', '1', '310114117', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('310114118', '310114', '江桥镇', '1', '310114118', null, '3', '1'),
('310114501', '310114', '嘉定工业区', '1', '310114501', null, '3', '1'),
('310115004', '310115', '潍坊新村街道', '1', '310115004', null, '3', '1'),
('310115005', '310115', '陆家嘴街道', '1', '310115005', null, '3', '1'),
('310115007', '310115', '周家渡街道', '1', '310115007', null, '3', '1'),
('310115008', '310115', '塘桥街道', '1', '310115008', null, '3', '1'),
('310115009', '310115', '上钢新村街道', '1', '310115009', null, '3', '1'),
('310115010', '310115', '南码头路街道', '1', '310115010', null, '3', '1'),
('310115011', '310115', '沪东新村街道', '1', '310115011', null, '3', '1'),
('310115012', '310115', '金杨新村街道', '1', '310115012', null, '3', '1'),
('310115013', '310115', '洋泾街道', '1', '310115013', null, '3', '1'),
('310115014', '310115', '浦兴路街道', '1', '310115014', null, '3', '1'),
('310115015', '310115', '东明路街道', '1', '310115015', null, '3', '1'),
('310115016', '310115', '花木街道', '1', '310115016', null, '3', '1'),
('310115103', '310115', '川沙新镇', '1', '310115103', null, '3', '1'),
('310115104', '310115', '高桥镇', '1', '310115104', null, '3', '1'),
('310115105', '310115', '北蔡镇', '1', '310115105', null, '3', '1'),
('310115110', '310115', '合庆镇', '1', '310115110', null, '3', '1'),
('310115114', '310115', '唐镇', '1', '310115114', null, '3', '1'),
('310115117', '310115', '曹路镇', '1', '310115117', null, '3', '1'),
('310115120', '310115', '金桥镇', '1', '310115120', null, '3', '1'),
('310115121', '310115', '高行镇', '1', '310115121', null, '3', '1'),
('310115123', '310115', '高东镇', '1', '310115123', null, '3', '1'),
('310115125', '310115', '张江镇', '1', '310115125', null, '3', '1'),
('310115130', '310115', '三林镇', '1', '310115130', null, '3', '1'),
('310115501', '310115', '外高桥保税区', '1', '310115501', null, '3', '1'),
('310115502', '310115', '金桥出口加工区', '1', '310115502', null, '3', '1'),
('310116001', '310116', '石化街道', '1', '310116001', null, '3', '1'),
('310116101', '310116', '朱泾镇', '1', '310116101', null, '3', '1'),
('310116102', '310116', '枫泾镇', '1', '310116102', null, '3', '1'),
('310116103', '310116', '张堰镇', '1', '310116103', null, '3', '1'),
('310116104', '310116', '亭林镇', '1', '310116104', null, '3', '1'),
('310116105', '310116', '吕巷镇', '1', '310116105', null, '3', '1'),
('310116107', '310116', '廊下镇', '1', '310116107', null, '3', '1'),
('310116109', '310116', '金山卫镇', '1', '310116109', null, '3', '1'),
('310116112', '310116', '漕泾镇', '1', '310116112', null, '3', '1'),
('310116113', '310116', '山阳镇', '1', '310116113', null, '3', '1'),
('310117001', '310117', '岳阳街道', '1', '310117001', null, '3', '1'),
('310117002', '310117', '永丰街道', '1', '310117002', null, '3', '1'),
('310117003', '310117', '方松街道', '1', '310117003', null, '3', '1'),
('310117004', '310117', '中山街道', '1', '310117004', null, '3', '1'),
('310117102', '310117', '泗泾镇', '1', '310117102', null, '3', '1'),
('310117103', '310117', '佘山镇', '1', '310117103', null, '3', '1'),
('310117104', '310117', '车墩镇', '1', '310117104', null, '3', '1'),
('310117105', '310117', '新桥镇', '1', '310117105', null, '3', '1'),
('310117106', '310117', '洞泾镇', '1', '310117106', null, '3', '1'),
('310117107', '310117', '九亭镇', '1', '310117107', null, '3', '1'),
('310117109', '310117', '泖港镇', '1', '310117109', null, '3', '1'),
('310117116', '310117', '石湖荡镇', '1', '310117116', null, '3', '1'),
('310117117', '310117', '新浜镇', '1', '310117117', null, '3', '1'),
('310117120', '310117', '叶榭镇', '1', '310117120', null, '3', '1'),
('310117501', '310117', '松江工业区', '1', '310117501', null, '3', '1'),
('310117504', '310117', '佘山度假区', '1', '310117504', null, '3', '1'),
('310117505', '310117', '五厍农业园区', '1', '310117505', null, '3', '1'),
('310117506', '310117', '上海松江科技园区', '1', '310117506', null, '3', '1'),
('310117507', '310117', '上海松江出口加工区', '1', '310117507', null, '3', '1'),
('310118001', '310118', '夏阳街道', '1', '310118001', null, '3', '1'),
('310118002', '310118', '盈浦街道', '1', '310118002', null, '3', '1'),
('310118003', '310118', '香花桥街道', '1', '310118003', null, '3', '1'),
('310118102', '310118', '朱家角镇', '1', '310118102', null, '3', '1'),
('310118103', '310118', '练塘镇', '1', '310118103', null, '3', '1'),
('310118104', '310118', '金泽镇', '1', '310118104', null, '3', '1'),
('310118105', '310118', '赵巷镇', '1', '310118105', null, '3', '1'),
('310118106', '310118', '徐泾镇', '1', '310118106', null, '3', '1'),
('310118107', '310118', '华新镇', '1', '310118107', null, '3', '1'),
('310118109', '310118', '重固镇', '1', '310118109', null, '3', '1'),
('310118110', '310118', '白鹤镇', '1', '310118110', null, '3', '1'),
('310119101', '310119', '惠南镇', '1', '310119101', null, '3', '1'),
('310119102', '310119', '周浦镇', '1', '310119102', null, '3', '1'),
('310119103', '310119', '新场镇', '1', '310119103', null, '3', '1'),
('310119104', '310119', '大团镇', '1', '310119104', null, '3', '1'),
('310119106', '310119', '芦潮港镇', '1', '310119106', null, '3', '1'),
('310119109', '310119', '康桥镇', '1', '310119109', null, '3', '1'),
('310119110', '310119', '航头镇', '1', '310119110', null, '3', '1'),
('310119111', '310119', '六灶镇', '1', '310119111', null, '3', '1'),
('310119112', '310119', '祝桥镇', '1', '310119112', null, '3', '1'),
('310119114', '310119', '泥城镇', '1', '310119114', null, '3', '1'),
('310119115', '310119', '宣桥镇', '1', '310119115', null, '3', '1'),
('310119121', '310119', '书院镇', '1', '310119121', null, '3', '1'),
('310119122', '310119', '万祥镇', '1', '310119122', null, '3', '1'),
('310119124', '310119', '老港镇', '1', '310119124', null, '3', '1'),
('310119401', '310119', '芦潮港农场', '1', '310119401', null, '3', '1'),
('310119402', '310119', '东海农场', '1', '310119402', null, '3', '1'),
('310119403', '310119', '朝阳农场', '1', '310119403', null, '3', '1'),
('310120101', '310120', '南桥镇', '1', '310120101', null, '3', '1'),
('310120102', '310120', '奉城镇', '1', '310120102', null, '3', '1'),
('310120104', '310120', '庄行镇', '1', '310120104', null, '3', '1'),
('310120106', '310120', '金汇镇', '1', '310120106', null, '3', '1'),
('310120109', '310120', '四团镇', '1', '310120109', null, '3', '1'),
('310120111', '310120', '青村镇', '1', '310120111', null, '3', '1'),
('310120118', '310120', '柘林镇', '1', '310120118', null, '3', '1'),
('310120123', '310120', '海湾镇', '1', '310120123', null, '3', '1'),
('310120501', '310120', '上海工业综合开发区', '1', '310120501', null, '3', '1'),
('310120502', '310120', '上海化学工业区奉贤分区', '1', '310120502', null, '3', '1'),
('310120503', '310120', '海湾旅游区', '1', '310120503', null, '3', '1'),
('310120504', '310120', '奉贤区现代农业园区', '1', '310120504', null, '3', '1'),
('310120505', '310120', '上海海港综合经济开发区', '1', '310120505', null, '3', '1'),
('310230101', '310230', '城桥镇', '1', '310230101', null, '3', '1'),
('310230102', '310230', '堡镇', '1', '310230102', null, '3', '1'),
('310230103', '310230', '新河镇', '1', '310230103', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('310230104', '310230', '庙镇', '1', '310230104', null, '3', '1'),
('310230106', '310230', '竖新镇', '1', '310230106', null, '3', '1'),
('310230107', '310230', '向化镇', '1', '310230107', null, '3', '1'),
('310230109', '310230', '三星镇', '1', '310230109', null, '3', '1'),
('310230113', '310230', '港沿镇', '1', '310230113', null, '3', '1'),
('310230114', '310230', '中兴镇', '1', '310230114', null, '3', '1'),
('310230115', '310230', '陈家镇', '1', '310230115', null, '3', '1'),
('310230116', '310230', '绿华镇', '1', '310230116', null, '3', '1'),
('310230118', '310230', '港西镇', '1', '310230118', null, '3', '1'),
('310230119', '310230', '建设镇', '1', '310230119', null, '3', '1'),
('310230201', '310230', '新村乡', '1', '310230201', null, '3', '1'),
('310230202', '310230', '长兴乡', '1', '310230202', null, '3', '1'),
('310230203', '310230', '横沙乡', '1', '310230203', null, '3', '1'),
('310230401', '310230', '跃进农场', '1', '310230401', null, '3', '1'),
('310230402', '310230', '新海农场', '1', '310230402', null, '3', '1'),
('310230403', '310230', '红星农场', '1', '310230403', null, '3', '1'),
('310230404', '310230', '长征农场', '1', '310230404', null, '3', '1'),
('310230405', '310230', '东风农场', '1', '310230405', null, '3', '1'),
('310230406', '310230', '长江农场', '1', '310230406', null, '3', '1'),
('310230407', '310230', '前进农场', '1', '310230407', null, '3', '1'),
('310230408', '310230', '前哨农场', '1', '310230408', null, '3', '1'),
('310230409', '310230', '前卫农场', '1', '310230409', null, '3', '1'),
('310230410', '310230', '东平林场', '1', '310230410', null, '3', '1'),
('310230501', '310230', '上实现代农业园区', '1', '310230501', null, '3', '1'),
('320102002', '320102', '梅园新村街道', '1', '320102002', null, '3', '1'),
('320102003', '320102', '新街口街道', '1', '320102003', null, '3', '1'),
('320102005', '320102', '玄武门街道', '1', '320102005', null, '3', '1'),
('320102006', '320102', '后宰门街道', '1', '320102006', null, '3', '1'),
('320102007', '320102', '锁金村街道', '1', '320102007', null, '3', '1'),
('320102008', '320102', '红山街道', '1', '320102008', null, '3', '1'),
('320102009', '320102', '孝陵卫街道', '1', '320102009', null, '3', '1'),
('320102010', '320102', '玄武湖街道', '1', '320102010', null, '3', '1'),
('320103001', '320103', '五老村街道', '1', '320103001', null, '3', '1'),
('320103002', '320103', '淮海路街道', '1', '320103002', null, '3', '1'),
('320103003', '320103', '建康路街道', '1', '320103003', null, '3', '1'),
('320103004', '320103', '洪武路街道', '1', '320103004', null, '3', '1'),
('320103005', '320103', '大光路街道', '1', '320103005', null, '3', '1'),
('320103006', '320103', '瑞金路街道', '1', '320103006', null, '3', '1'),
('320103007', '320103', '苜蓿园街道', '1', '320103007', null, '3', '1'),
('320103008', '320103', '光华路街道', '1', '320103008', null, '3', '1'),
('320103009', '320103', '朝天宫街道', '1', '320103009', null, '3', '1'),
('320103010', '320103', '止马营街道', '1', '320103010', null, '3', '1'),
('320104001', '320104', '秦虹街道', '1', '320104001', null, '3', '1'),
('320104002', '320104', '夫子庙街道', '1', '320104002', null, '3', '1'),
('320104003', '320104', '红花街道', '1', '320104003', null, '3', '1'),
('320104004', '320104', '双塘街道', '1', '320104004', null, '3', '1'),
('320104005', '320104', '中华门街道', '1', '320104005', null, '3', '1'),
('320105001', '320105', '滨湖街道', '1', '320105001', null, '3', '1'),
('320105002', '320105', '沙洲街道', '1', '320105002', null, '3', '1'),
('320105003', '320105', '双闸街道', '1', '320105003', null, '3', '1'),
('320105004', '320105', '江心洲街道', '1', '320105004', null, '3', '1'),
('320105005', '320105', '南湖街道', '1', '320105005', null, '3', '1'),
('320105006', '320105', '兴隆街道', '1', '320105006', null, '3', '1'),
('320105007', '320105', '南苑街道', '1', '320105007', null, '3', '1'),
('320106001', '320106', '宁海路街道', '1', '320106001', null, '3', '1'),
('320106002', '320106', '华侨路街道', '1', '320106002', null, '3', '1'),
('320106003', '320106', '湖南路街道', '1', '320106003', null, '3', '1'),
('320106004', '320106', '中央门街道', '1', '320106004', null, '3', '1'),
('320106005', '320106', '挹江门街道', '1', '320106005', null, '3', '1'),
('320106006', '320106', '江东街道', '1', '320106006', null, '3', '1'),
('320106007', '320106', '莫愁街道', '1', '320106007', null, '3', '1'),
('320107001', '320107', '阅江楼街道', '1', '320107001', null, '3', '1'),
('320107002', '320107', '热河南路街道', '1', '320107002', null, '3', '1'),
('320107003', '320107', '幕府山街道', '1', '320107003', null, '3', '1'),
('320107004', '320107', '建宁路街道', '1', '320107004', null, '3', '1'),
('320107005', '320107', '宝塔桥街道', '1', '320107005', null, '3', '1'),
('320107006', '320107', '小市街道', '1', '320107006', null, '3', '1'),
('320111001', '320111', '泰山街道', '1', '320111001', null, '3', '1'),
('320111002', '320111', '顶山街道', '1', '320111002', null, '3', '1'),
('320111003', '320111', '沿江街道', '1', '320111003', null, '3', '1'),
('320111004', '320111', '江浦街道', '1', '320111004', null, '3', '1'),
('320111050', '320111', '高新花苑虚拟街道', '1', '320111050', null, '3', '1'),
('320111101', '320111', '桥林镇', '1', '320111101', null, '3', '1'),
('320111102', '320111', '永宁镇', '1', '320111102', null, '3', '1'),
('320111103', '320111', '汤泉镇', '1', '320111103', null, '3', '1'),
('320111104', '320111', '星甸镇', '1', '320111104', null, '3', '1'),
('320111105', '320111', '石桥镇', '1', '320111105', null, '3', '1'),
('320111106', '320111', '乌江镇', '1', '320111106', null, '3', '1'),
('320111107', '320111', '盘城镇', '1', '320111107', null, '3', '1'),
('320111400', '320111', '老山林场', '1', '320111400', null, '3', '1'),
('320111401', '320111', '汤泉农场', '1', '320111401', null, '3', '1'),
('320111402', '320111', '珍珠泉管委会', '1', '320111402', null, '3', '1'),
('320113001', '320113', '尧化街道', '1', '320113001', null, '3', '1'),
('320113002', '320113', '马群街道', '1', '320113002', null, '3', '1'),
('320113003', '320113', '迈皋桥街道', '1', '320113003', null, '3', '1'),
('320113004', '320113', '燕子矶街道', '1', '320113004', null, '3', '1'),
('320113005', '320113', '栖霞街道', '1', '320113005', null, '3', '1'),
('320113006', '320113', '龙潭街道', '1', '320113006', null, '3', '1'),
('320113007', '320113', '仙林街道', '1', '320113007', null, '3', '1'),
('320113008', '320113', '靖安街道', '1', '320113008', null, '3', '1'),
('320113009', '320113', '八卦洲街道', '1', '320113009', null, '3', '1'),
('320113400', '320113', '龙潭监狱', '1', '320113400', null, '3', '1'),
('320113401', '320113', '栖霞区技术经济开发区', '1', '320113401', null, '3', '1'),
('320113402', '320113', '南京龙潭物流园', '1', '320113402', null, '3', '1'),
('320113403', '320113', '南京市靖安三江口工业园', '1', '320113403', null, '3', '1'),
('320113404', '320113', '南京迈皋桥创业园', '1', '320113404', null, '3', '1'),
('320113405', '320113', '南京市马群科技园', '1', '320113405', null, '3', '1'),
('320113406', '320113', '南京仙林大学城', '1', '320113406', null, '3', '1'),
('320113450', '320113', '南京经济技术开发区', '1', '320113450', null, '3', '1'),
('320114001', '320114', '宁南街道', '1', '320114001', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('320114002', '320114', '赛虹桥街道', '1', '320114002', null, '3', '1'),
('320114003', '320114', '雨花新村街道', '1', '320114003', null, '3', '1'),
('320114004', '320114', '西善桥街道', '1', '320114004', null, '3', '1'),
('320114005', '320114', '板桥街道', '1', '320114005', null, '3', '1'),
('320114006', '320114', '铁心桥街道', '1', '320114006', null, '3', '1'),
('320114007', '320114', '梅山街道', '1', '320114007', null, '3', '1'),
('320114400', '320114', '雨花经济技术开发区', '1', '320114400', null, '3', '1'),
('320115001', '320115', '东山街道', '1', '320115001', null, '3', '1'),
('320115002', '320115', '秣陵街道', '1', '320115002', null, '3', '1'),
('320115003', '320115', '汤山街道', '1', '320115003', null, '3', '1'),
('320115004', '320115', '淳化街道', '1', '320115004', null, '3', '1'),
('320115005', '320115', '禄口街道', '1', '320115005', null, '3', '1'),
('320115006', '320115', '江宁街道', '1', '320115006', null, '3', '1'),
('320115007', '320115', '谷里街道', '1', '320115007', null, '3', '1'),
('320115100', '320115', '湖熟镇', '1', '320115100', null, '3', '1'),
('320115101', '320115', '横溪镇', '1', '320115101', null, '3', '1'),
('320115400', '320115', '江宁科学园', '1', '320115400', null, '3', '1'),
('320115401', '320115', '青龙山林场', '1', '320115401', null, '3', '1'),
('320115450', '320115', '江宁开发区', '1', '320115450', null, '3', '1'),
('320116001', '320116', '卸甲甸街道', '1', '320116001', null, '3', '1'),
('320116002', '320116', '西厂门街道', '1', '320116002', null, '3', '1'),
('320116003', '320116', '山潘街道', '1', '320116003', null, '3', '1'),
('320116004', '320116', '葛塘街道', '1', '320116004', null, '3', '1'),
('320116005', '320116', '长芦街道', '1', '320116005', null, '3', '1'),
('320116100', '320116', '雄州镇', '1', '320116100', null, '3', '1'),
('320116101', '320116', '冶山镇', '1', '320116101', null, '3', '1'),
('320116102', '320116', '八百桥镇', '1', '320116102', null, '3', '1'),
('320116103', '320116', '横梁镇', '1', '320116103', null, '3', '1'),
('320116104', '320116', '东沟镇', '1', '320116104', null, '3', '1'),
('320116105', '320116', '龙袍镇', '1', '320116105', null, '3', '1'),
('320116106', '320116', '玉带镇', '1', '320116106', null, '3', '1'),
('320116107', '320116', '瓜埠镇', '1', '320116107', null, '3', '1'),
('320116108', '320116', '新集镇', '1', '320116108', null, '3', '1'),
('320116109', '320116', '程桥镇', '1', '320116109', null, '3', '1'),
('320116110', '320116', '竹镇镇', '1', '320116110', null, '3', '1'),
('320116111', '320116', '马集镇', '1', '320116111', null, '3', '1'),
('320116112', '320116', '马鞍镇', '1', '320116112', null, '3', '1'),
('320116113', '320116', '新篁镇', '1', '320116113', null, '3', '1'),
('320116400', '320116', '六合开发区', '1', '320116400', null, '3', '1'),
('320124100', '320124', '永阳镇', '1', '320124100', null, '3', '1'),
('320124101', '320124', '白马镇', '1', '320124101', null, '3', '1'),
('320124102', '320124', '东屏镇', '1', '320124102', null, '3', '1'),
('320124103', '320124', '柘塘镇', '1', '320124103', null, '3', '1'),
('320124104', '320124', '石湫镇', '1', '320124104', null, '3', '1'),
('320124105', '320124', '洪蓝镇', '1', '320124105', null, '3', '1'),
('320124106', '320124', '晶桥镇', '1', '320124106', null, '3', '1'),
('320124107', '320124', '和凤镇', '1', '320124107', null, '3', '1'),
('320124400', '320124', '溧水县开发区', '1', '320124400', null, '3', '1'),
('320125100', '320125', '淳溪镇', '1', '320125100', null, '3', '1'),
('320125101', '320125', '阳江镇', '1', '320125101', null, '3', '1'),
('320125102', '320125', '砖墙镇', '1', '320125102', null, '3', '1'),
('320125103', '320125', '古柏镇', '1', '320125103', null, '3', '1'),
('320125104', '320125', '漆桥镇', '1', '320125104', null, '3', '1'),
('320125105', '320125', '固城镇', '1', '320125105', null, '3', '1'),
('320125106', '320125', '东坝镇', '1', '320125106', null, '3', '1'),
('320125108', '320125', '桠溪镇', '1', '320125108', null, '3', '1'),
('320125400', '320125', '高淳县团结圩良种繁育场', '1', '320125400', null, '3', '1'),
('320125401', '320125', '高淳县茶叶实验场', '1', '320125401', null, '3', '1'),
('320125402', '320125', '高淳监狱', '1', '320125402', null, '3', '1'),
('320125403', '320125', '高淳县傅家坛林场', '1', '320125403', null, '3', '1'),
('320202001', '320202', '崇安寺街道', '1', '320202001', null, '3', '1'),
('320202002', '320202', '通江街道', '1', '320202002', null, '3', '1'),
('320202003', '320202', '广瑞路街道', '1', '320202003', null, '3', '1'),
('320202004', '320202', '上马墩街道', '1', '320202004', null, '3', '1'),
('320202005', '320202', '江海街道', '1', '320202005', null, '3', '1'),
('320202006', '320202', '广益街道', '1', '320202006', null, '3', '1'),
('320203001', '320203', '迎龙桥街道', '1', '320203001', null, '3', '1'),
('320203002', '320203', '南禅寺街道', '1', '320203002', null, '3', '1'),
('320203003', '320203', '清名桥街道', '1', '320203003', null, '3', '1'),
('320203004', '320203', '金星街道', '1', '320203004', null, '3', '1'),
('320203005', '320203', '金匮街道', '1', '320203005', null, '3', '1'),
('320203006', '320203', '扬名街道', '1', '320203006', null, '3', '1'),
('320204001', '320204', '黄巷街道', '1', '320204001', null, '3', '1'),
('320204002', '320204', '山北街道', '1', '320204002', null, '3', '1'),
('320204003', '320204', '北大街街道', '1', '320204003', null, '3', '1'),
('320204004', '320204', '惠山街道', '1', '320204004', null, '3', '1'),
('320205001', '320205', '东亭街道', '1', '320205001', null, '3', '1'),
('320205101', '320205', '安镇镇', '1', '320205101', null, '3', '1'),
('320205102', '320205', '羊尖镇', '1', '320205102', null, '3', '1'),
('320205103', '320205', '鹅湖镇', '1', '320205103', null, '3', '1'),
('320205104', '320205', '东北塘镇', '1', '320205104', null, '3', '1'),
('320205105', '320205', '锡北镇', '1', '320205105', null, '3', '1'),
('320205106', '320205', '东港镇', '1', '320205106', null, '3', '1'),
('320205400', '320205', '无锡锡山开发区', '1', '320205400', null, '3', '1'),
('320206001', '320206', '堰桥街道', '1', '320206001', null, '3', '1'),
('320206002', '320206', '长安街道', '1', '320206002', null, '3', '1'),
('320206101', '320206', '前洲镇', '1', '320206101', null, '3', '1'),
('320206102', '320206', '玉祁镇', '1', '320206102', null, '3', '1'),
('320206103', '320206', '洛社镇', '1', '320206103', null, '3', '1'),
('320206104', '320206', '钱桥镇', '1', '320206104', null, '3', '1'),
('320206105', '320206', '阳山镇', '1', '320206105', null, '3', '1'),
('320206400', '320206', '无锡惠山经济开发区', '1', '320206400', null, '3', '1'),
('320211001', '320211', '河埒街道', '1', '320211001', null, '3', '1'),
('320211002', '320211', '荣巷街道', '1', '320211002', null, '3', '1'),
('320211003', '320211', '蠡园街道', '1', '320211003', null, '3', '1'),
('320211004', '320211', '蠡湖街道', '1', '320211004', null, '3', '1'),
('320211005', '320211', '滨湖街道', '1', '320211005', null, '3', '1'),
('320211006', '320211', '华庄街道', '1', '320211006', null, '3', '1'),
('320211007', '320211', '太湖街道', '1', '320211007', null, '3', '1'),
('320211008', '320211', '雪浪街道', '1', '320211008', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('320211050', '320211', '旺庄街道', '1', '320211050', null, '3', '1'),
('320211051', '320211', '硕放街道', '1', '320211051', null, '3', '1'),
('320211052', '320211', '南站街道', '1', '320211052', null, '3', '1'),
('320211053', '320211', '坊前街道', '1', '320211053', null, '3', '1'),
('320211103', '320211', '马山镇', '1', '320211103', null, '3', '1'),
('320211104', '320211', '胡埭镇', '1', '320211104', null, '3', '1'),
('320211152', '320211', '梅村镇', '1', '320211152', null, '3', '1'),
('320211153', '320211', '鸿山镇', '1', '320211153', null, '3', '1'),
('320211450', '320211', '无锡新加坡工业园', '1', '320211450', null, '3', '1'),
('320211451', '320211', '无锡高新技术产业开发区', '1', '320211451', null, '3', '1'),
('320281100', '320281', '澄江镇', '1', '320281100', null, '3', '1'),
('320281101', '320281', '璜土镇', '1', '320281101', null, '3', '1'),
('320281102', '320281', '利港镇', '1', '320281102', null, '3', '1'),
('320281103', '320281', '申港镇', '1', '320281103', null, '3', '1'),
('320281104', '320281', '夏港镇', '1', '320281104', null, '3', '1'),
('320281105', '320281', '月城镇', '1', '320281105', null, '3', '1'),
('320281106', '320281', '青阳镇', '1', '320281106', null, '3', '1'),
('320281107', '320281', '霞客镇', '1', '320281107', null, '3', '1'),
('320281108', '320281', '南闸镇', '1', '320281108', null, '3', '1'),
('320281109', '320281', '云亭镇', '1', '320281109', null, '3', '1'),
('320281110', '320281', '华士镇', '1', '320281110', null, '3', '1'),
('320281111', '320281', '周庄镇', '1', '320281111', null, '3', '1'),
('320281112', '320281', '新桥镇', '1', '320281112', null, '3', '1'),
('320281113', '320281', '长泾镇', '1', '320281113', null, '3', '1'),
('320281114', '320281', '顾山镇', '1', '320281114', null, '3', '1'),
('320281115', '320281', '祝塘镇', '1', '320281115', null, '3', '1'),
('320281400', '320281', '江阴经济开发区新城东', '1', '320281400', null, '3', '1'),
('320281401', '320281', '江阴经济开发区港口', '1', '320281401', null, '3', '1'),
('320281402', '320281', '江阴经济开发区石庄', '1', '320281402', null, '3', '1'),
('320281403', '320281', '江阴经济开发区靖江园区', '1', '320281403', null, '3', '1'),
('320282001', '320282', '宜城街道', '1', '320282001', null, '3', '1'),
('320282002', '320282', '屺亭街道', '1', '320282002', null, '3', '1'),
('320282101', '320282', '张渚镇', '1', '320282101', null, '3', '1'),
('320282102', '320282', '西渚镇', '1', '320282102', null, '3', '1'),
('320282103', '320282', '太华镇', '1', '320282103', null, '3', '1'),
('320282104', '320282', '徐舍镇', '1', '320282104', null, '3', '1'),
('320282105', '320282', '鲸塘镇', '1', '320282105', null, '3', '1'),
('320282106', '320282', '芳庄镇', '1', '320282106', null, '3', '1'),
('320282107', '320282', '官林镇', '1', '320282107', null, '3', '1'),
('320282108', '320282', '杨巷镇', '1', '320282108', null, '3', '1'),
('320282109', '320282', '新建镇', '1', '320282109', null, '3', '1'),
('320282110', '320282', '和桥镇', '1', '320282110', null, '3', '1'),
('320282111', '320282', '高塍镇', '1', '320282111', null, '3', '1'),
('320282113', '320282', '万石镇', '1', '320282113', null, '3', '1'),
('320282114', '320282', '周铁镇', '1', '320282114', null, '3', '1'),
('320282115', '320282', '芳桥镇', '1', '320282115', null, '3', '1'),
('320282116', '320282', '新庄镇', '1', '320282116', null, '3', '1'),
('320282117', '320282', '丁蜀镇', '1', '320282117', null, '3', '1'),
('320282118', '320282', '大浦镇', '1', '320282118', null, '3', '1'),
('320282119', '320282', '湖父镇', '1', '320282119', null, '3', '1'),
('320282120', '320282', '新街镇', '1', '320282120', null, '3', '1'),
('320282400', '320282', '环科园', '1', '320282400', null, '3', '1'),
('320282401', '320282', '宜兴经济开发区', '1', '320282401', null, '3', '1'),
('320282402', '320282', '芙蓉茶场', '1', '320282402', null, '3', '1'),
('320282403', '320282', '宜兴市林场', '1', '320282403', null, '3', '1'),
('320282404', '320282', '宜兴市大贤岭林场', '1', '320282404', null, '3', '1'),
('320282405', '320282', '无锡市茶叶研究所', '1', '320282405', null, '3', '1'),
('320302001', '320302', '黄楼街道', '1', '320302001', null, '3', '1'),
('320302002', '320302', '丰财街道', '1', '320302002', null, '3', '1'),
('320302003', '320302', '琵琶街道', '1', '320302003', null, '3', '1'),
('320302004', '320302', '牌楼街道', '1', '320302004', null, '3', '1'),
('320302005', '320302', '铜沛街道', '1', '320302005', null, '3', '1'),
('320302006', '320302', '环城街道', '1', '320302006', null, '3', '1'),
('320302051', '320302', '金山桥街道', '1', '320302051', null, '3', '1'),
('320302052', '320302', '东环街道', '1', '320302052', null, '3', '1'),
('320302053', '320302', '大黄山街道', '1', '320302053', null, '3', '1'),
('320302151', '320302', '大庙镇', '1', '320302151', null, '3', '1'),
('320302152', '320302', '大黄山镇', '1', '320302152', null, '3', '1'),
('320303001', '320303', '彭城街道', '1', '320303001', null, '3', '1'),
('320303005', '320303', '子房街道', '1', '320303005', null, '3', '1'),
('320303007', '320303', '黄山街道', '1', '320303007', null, '3', '1'),
('320303008', '320303', '骆驼山街道', '1', '320303008', null, '3', '1'),
('320303010', '320303', '大郭庄街道', '1', '320303010', null, '3', '1'),
('320303011', '320303', '翠屏山街道', '1', '320303011', null, '3', '1'),
('320303012', '320303', '潘塘街道', '1', '320303012', null, '3', '1'),
('320304001', '320304', '庞庄街道', '1', '320304001', null, '3', '1'),
('320304003', '320304', '利国街道', '1', '320304003', null, '3', '1'),
('320304004', '320304', '桃园街道', '1', '320304004', null, '3', '1'),
('320304005', '320304', '三河尖街道', '1', '320304005', null, '3', '1'),
('320304006', '320304', '垞城街道', '1', '320304006', null, '3', '1'),
('320304007', '320304', '义安街道', '1', '320304007', null, '3', '1'),
('320304008', '320304', '张集街道', '1', '320304008', null, '3', '1'),
('320304009', '320304', '电厂街道', '1', '320304009', null, '3', '1'),
('320304010', '320304', '张双楼街道', '1', '320304010', null, '3', '1'),
('320304011', '320304', '九里街道', '1', '320304011', null, '3', '1'),
('320304012', '320304', '拾屯街道', '1', '320304012', null, '3', '1'),
('320304013', '320304', '苏山街道', '1', '320304013', null, '3', '1'),
('320304014', '320304', '火花街道', '1', '320304014', null, '3', '1'),
('320305001', '320305', '老矿街道', '1', '320305001', null, '3', '1'),
('320305002', '320305', '夏桥街道', '1', '320305002', null, '3', '1'),
('320305101', '320305', '贾汪镇', '1', '320305101', null, '3', '1'),
('320305102', '320305', '青山泉镇', '1', '320305102', null, '3', '1'),
('320305103', '320305', '大吴镇', '1', '320305103', null, '3', '1'),
('320305104', '320305', '紫庄镇', '1', '320305104', null, '3', '1'),
('320305105', '320305', '塔山镇', '1', '320305105', null, '3', '1'),
('320305106', '320305', '汴塘镇', '1', '320305106', null, '3', '1'),
('320305107', '320305', '江庄镇', '1', '320305107', null, '3', '1'),
('320305401', '320305', '工业园区管委会', '1', '320305401', null, '3', '1'),
('320305402', '320305', '鹿庄粮棉原种场', '1', '320305402', null, '3', '1'),
('320311001', '320311', '王陵街道', '1', '320311001', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('320311003', '320311', '永安街道', '1', '320311003', null, '3', '1'),
('320311004', '320311', '湖滨街道', '1', '320311004', null, '3', '1'),
('320311005', '320311', '段庄街道', '1', '320311005', null, '3', '1'),
('320311006', '320311', '翟山街道', '1', '320311006', null, '3', '1'),
('320311007', '320311', '奎山街道', '1', '320311007', null, '3', '1'),
('320311008', '320311', '和平街道', '1', '320311008', null, '3', '1'),
('320311011', '320311', '泰山街道', '1', '320311011', null, '3', '1'),
('320311012', '320311', '金山街道', '1', '320311012', null, '3', '1'),
('320311014', '320311', '七里沟街道', '1', '320311014', null, '3', '1'),
('320321101', '320321', '凤城镇', '1', '320321101', null, '3', '1'),
('320321102', '320321', '首羡镇', '1', '320321102', null, '3', '1'),
('320321103', '320321', '顺河镇', '1', '320321103', null, '3', '1'),
('320321104', '320321', '常店镇', '1', '320321104', null, '3', '1'),
('320321105', '320321', '欢口镇', '1', '320321105', null, '3', '1'),
('320321106', '320321', '师寨镇', '1', '320321106', null, '3', '1'),
('320321107', '320321', '华山镇', '1', '320321107', null, '3', '1'),
('320321108', '320321', '梁寨镇', '1', '320321108', null, '3', '1'),
('320321109', '320321', '范楼镇', '1', '320321109', null, '3', '1'),
('320321110', '320321', '孙楼镇', '1', '320321110', null, '3', '1'),
('320321111', '320321', '宋楼镇', '1', '320321111', null, '3', '1'),
('320321112', '320321', '大沙河镇', '1', '320321112', null, '3', '1'),
('320321113', '320321', '王沟镇', '1', '320321113', null, '3', '1'),
('320321114', '320321', '赵庄镇', '1', '320321114', null, '3', '1'),
('320321401', '320321', '大沙河林场', '1', '320321401', null, '3', '1'),
('320322101', '320322', '龙固镇', '1', '320322101', null, '3', '1'),
('320322102', '320322', '杨屯镇', '1', '320322102', null, '3', '1'),
('320322103', '320322', '大屯镇', '1', '320322103', null, '3', '1'),
('320322104', '320322', '沛城镇', '1', '320322104', null, '3', '1'),
('320322105', '320322', '胡寨镇', '1', '320322105', null, '3', '1'),
('320322106', '320322', '魏庙镇', '1', '320322106', null, '3', '1'),
('320322107', '320322', '五段镇', '1', '320322107', null, '3', '1'),
('320322108', '320322', '张庄镇', '1', '320322108', null, '3', '1'),
('320322109', '320322', '张寨镇', '1', '320322109', null, '3', '1'),
('320322110', '320322', '敬安镇', '1', '320322110', null, '3', '1'),
('320322111', '320322', '河口镇', '1', '320322111', null, '3', '1'),
('320322112', '320322', '栖山镇', '1', '320322112', null, '3', '1'),
('320322113', '320322', '鹿楼镇', '1', '320322113', null, '3', '1'),
('320322114', '320322', '朱寨镇', '1', '320322114', null, '3', '1'),
('320322115', '320322', '安国镇', '1', '320322115', null, '3', '1'),
('320322403', '320322', '中煤集团大屯煤电(集团)公司', '1', '320322403', null, '3', '1'),
('320322451', '320322', '经济开发区', '1', '320322451', null, '3', '1'),
('320323101', '320323', '铜山镇', '1', '320323101', null, '3', '1'),
('320323102', '320323', '何桥镇', '1', '320323102', null, '3', '1'),
('320323103', '320323', '黄集镇', '1', '320323103', null, '3', '1'),
('320323104', '320323', '马坡镇', '1', '320323104', null, '3', '1'),
('320323105', '320323', '郑集镇', '1', '320323105', null, '3', '1'),
('320323106', '320323', '柳新镇', '1', '320323106', null, '3', '1'),
('320323107', '320323', '刘集镇', '1', '320323107', null, '3', '1'),
('320323108', '320323', '大彭镇', '1', '320323108', null, '3', '1'),
('320323109', '320323', '汉王镇', '1', '320323109', null, '3', '1'),
('320323110', '320323', '三堡镇', '1', '320323110', null, '3', '1'),
('320323111', '320323', '棠张镇', '1', '320323111', null, '3', '1'),
('320323112', '320323', '张集镇', '1', '320323112', null, '3', '1'),
('320323113', '320323', '房村镇', '1', '320323113', null, '3', '1'),
('320323114', '320323', '伊庄镇', '1', '320323114', null, '3', '1'),
('320323115', '320323', '单集镇', '1', '320323115', null, '3', '1'),
('320323117', '320323', '徐庄镇', '1', '320323117', null, '3', '1'),
('320323118', '320323', '大许镇', '1', '320323118', null, '3', '1'),
('320323119', '320323', '茅村镇', '1', '320323119', null, '3', '1'),
('320323120', '320323', '柳泉镇', '1', '320323120', null, '3', '1'),
('320323121', '320323', '利国镇', '1', '320323121', null, '3', '1'),
('320323401', '320323', '国营沿湖农', '1', '320323401', null, '3', '1'),
('320324101', '320324', '睢城镇', '1', '320324101', null, '3', '1'),
('320324102', '320324', '王集镇', '1', '320324102', null, '3', '1'),
('320324103', '320324', '双沟镇', '1', '320324103', null, '3', '1'),
('320324104', '320324', '岚山镇', '1', '320324104', null, '3', '1'),
('320324105', '320324', '李集镇', '1', '320324105', null, '3', '1'),
('320324106', '320324', '桃园镇', '1', '320324106', null, '3', '1'),
('320324107', '320324', '官山镇', '1', '320324107', null, '3', '1'),
('320324108', '320324', '高作镇', '1', '320324108', null, '3', '1'),
('320324109', '320324', '沙集镇', '1', '320324109', null, '3', '1'),
('320324110', '320324', '凌城镇', '1', '320324110', null, '3', '1'),
('320324111', '320324', '邱集镇', '1', '320324111', null, '3', '1'),
('320324112', '320324', '古邳镇', '1', '320324112', null, '3', '1'),
('320324113', '320324', '姚集镇', '1', '320324113', null, '3', '1'),
('320324114', '320324', '魏集镇', '1', '320324114', null, '3', '1'),
('320324115', '320324', '梁集镇', '1', '320324115', null, '3', '1'),
('320324116', '320324', '庆安镇', '1', '320324116', null, '3', '1'),
('320324451', '320324', '经济开发区', '1', '320324451', null, '3', '1'),
('320381101', '320381', '新安镇', '1', '320381101', null, '3', '1'),
('320381102', '320381', '瓦窑镇', '1', '320381102', null, '3', '1'),
('320381103', '320381', '港头镇', '1', '320381103', null, '3', '1'),
('320381104', '320381', '唐店镇', '1', '320381104', null, '3', '1'),
('320381105', '320381', '合沟镇', '1', '320381105', null, '3', '1'),
('320381106', '320381', '草桥镇', '1', '320381106', null, '3', '1'),
('320381107', '320381', '窑湾镇', '1', '320381107', null, '3', '1'),
('320381108', '320381', '棋盘镇', '1', '320381108', null, '3', '1'),
('320381110', '320381', '新店镇', '1', '320381110', null, '3', '1'),
('320381111', '320381', '邵店镇', '1', '320381111', null, '3', '1'),
('320381112', '320381', '北沟镇', '1', '320381112', null, '3', '1'),
('320381113', '320381', '时集镇', '1', '320381113', null, '3', '1'),
('320381114', '320381', '高流镇', '1', '320381114', null, '3', '1'),
('320381115', '320381', '阿湖镇', '1', '320381115', null, '3', '1'),
('320381116', '320381', '双塘镇', '1', '320381116', null, '3', '1'),
('320381117', '320381', '马岭山镇', '1', '320381117', null, '3', '1'),
('320381451', '320381', '经济开发区', '1', '320381451', null, '3', '1'),
('320382101', '320382', '运河镇', '1', '320382101', null, '3', '1'),
('320382102', '320382', '邳城镇', '1', '320382102', null, '3', '1'),
('320382103', '320382', '官湖镇', '1', '320382103', null, '3', '1'),
('320382104', '320382', '四户镇', '1', '320382104', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('320382105', '320382', '宿羊山镇', '1', '320382105', null, '3', '1'),
('320382106', '320382', '八义集镇', '1', '320382106', null, '3', '1'),
('320382107', '320382', '土山镇', '1', '320382107', null, '3', '1'),
('320382108', '320382', '碾庄镇', '1', '320382108', null, '3', '1'),
('320382109', '320382', '港上镇', '1', '320382109', null, '3', '1'),
('320382110', '320382', '邹庄镇', '1', '320382110', null, '3', '1'),
('320382111', '320382', '占城镇', '1', '320382111', null, '3', '1'),
('320382112', '320382', '新河镇', '1', '320382112', null, '3', '1'),
('320382113', '320382', '八路镇', '1', '320382113', null, '3', '1'),
('320382114', '320382', '炮车镇', '1', '320382114', null, '3', '1'),
('320382115', '320382', '铁富镇', '1', '320382115', null, '3', '1'),
('320382116', '320382', '岔河镇', '1', '320382116', null, '3', '1'),
('320382117', '320382', '戴圩镇', '1', '320382117', null, '3', '1'),
('320382118', '320382', '陈楼镇', '1', '320382118', null, '3', '1'),
('320382119', '320382', '邢楼镇', '1', '320382119', null, '3', '1'),
('320382120', '320382', '戴庄镇', '1', '320382120', null, '3', '1'),
('320382121', '320382', '车辐山镇', '1', '320382121', null, '3', '1'),
('320382122', '320382', '燕子埠镇', '1', '320382122', null, '3', '1'),
('320382123', '320382', '赵墩镇', '1', '320382123', null, '3', '1'),
('320382124', '320382', '议堂镇', '1', '320382124', null, '3', '1'),
('320382401', '320382', '邳城农场', '1', '320382401', null, '3', '1'),
('320382402', '320382', '张楼农场', '1', '320382402', null, '3', '1'),
('320402001', '320402', '雕庄街道', '1', '320402001', null, '3', '1'),
('320402002', '320402', '青龙街道', '1', '320402002', null, '3', '1'),
('320402003', '320402', '茶山街道', '1', '320402003', null, '3', '1'),
('320402004', '320402', '红梅街道', '1', '320402004', null, '3', '1'),
('320402005', '320402', '天宁街道', '1', '320402005', null, '3', '1'),
('320402006', '320402', '兰陵街道', '1', '320402006', null, '3', '1'),
('320404001', '320404', '五星街道', '1', '320404001', null, '3', '1'),
('320404002', '320404', '永红街道', '1', '320404002', null, '3', '1'),
('320404003', '320404', '北港街道', '1', '320404003', null, '3', '1'),
('320404004', '320404', '西林街道', '1', '320404004', null, '3', '1'),
('320404005', '320404', '南大街街道', '1', '320404005', null, '3', '1'),
('320404006', '320404', '荷花池街道', '1', '320404006', null, '3', '1'),
('320404100', '320404', '新闸镇', '1', '320404100', null, '3', '1'),
('320405001', '320405', '戚墅堰街道', '1', '320405001', null, '3', '1'),
('320405100', '320405', '丁堰镇', '1', '320405100', null, '3', '1'),
('320405101', '320405', '潞城镇', '1', '320405101', null, '3', '1'),
('320411001', '320411', '河海街道', '1', '320411001', null, '3', '1'),
('320411002', '320411', '三井街道', '1', '320411002', null, '3', '1'),
('320411003', '320411', '龙虎塘街道', '1', '320411003', null, '3', '1'),
('320411100', '320411', '春江镇', '1', '320411100', null, '3', '1'),
('320411101', '320411', '孟河镇', '1', '320411101', null, '3', '1'),
('320411102', '320411', '新桥镇', '1', '320411102', null, '3', '1'),
('320411103', '320411', '薛家镇', '1', '320411103', null, '3', '1'),
('320411104', '320411', '罗溪镇', '1', '320411104', null, '3', '1'),
('320411105', '320411', '西夏墅镇', '1', '320411105', null, '3', '1'),
('320412100', '320412', '湖塘镇', '1', '320412100', null, '3', '1'),
('320412102', '320412', '牛塘镇', '1', '320412102', null, '3', '1'),
('320412103', '320412', '洛阳镇', '1', '320412103', null, '3', '1'),
('320412104', '320412', '遥观镇', '1', '320412104', null, '3', '1'),
('320412105', '320412', '横林镇', '1', '320412105', null, '3', '1'),
('320412106', '320412', '横山桥镇', '1', '320412106', null, '3', '1'),
('320412107', '320412', '芙蓉镇', '1', '320412107', null, '3', '1'),
('320412108', '320412', '焦溪镇', '1', '320412108', null, '3', '1'),
('320412109', '320412', '郑陆镇', '1', '320412109', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('320412110', '320412', '雪堰镇', '1', '320412110', null, '3', '1'),
('320412111', '320412', '潘家镇', '1', '320412111', null, '3', '1'),
('320412112', '320412', '漕桥镇', '1', '320412112', null, '3', '1'),
('320412113', '320412', '前黄镇', '1', '320412113', null, '3', '1'),
('320412114', '320412', '礼嘉镇', '1', '320412114', null, '3', '1'),
('320412115', '320412', '寨桥镇', '1', '320412115', null, '3', '1'),
('320412116', '320412', '邹区镇', '1', '320412116', null, '3', '1'),
('320412117', '320412', '卜弋镇', '1', '320412117', null, '3', '1'),
('320412118', '320412', '夏溪镇', '1', '320412118', null, '3', '1'),
('320412119', '320412', '嘉泽镇', '1', '320412119', null, '3', '1'),
('320412120', '320412', '湟里镇', '1', '320412120', null, '3', '1'),
('320412121', '320412', '东安镇', '1', '320412121', null, '3', '1'),
('320412122', '320412', '奔牛镇', '1', '320412122', null, '3', '1'),
('320412400', '320412', '武进经济开发区', '1', '320412400', null, '3', '1'),
('320412401', '320412', '运村农科良种场', '1', '320412401', null, '3', '1'),
('320412402', '320412', '奔牛稻麦原种场', '1', '320412402', null, '3', '1'),
('320412403', '320412', '郑陆良种繁育场', '1', '320412403', null, '3', '1'),
('320412404', '320412', '夏溪良种繁育场', '1', '320412404', null, '3', '1'),
('320412405', '320412', '蚕种场', '1', '320412405', null, '3', '1'),
('320412406', '320412', '前黄苗圃', '1', '320412406', null, '3', '1'),
('320412407', '320412', '水产养殖场', '1', '320412407', null, '3', '1'),
('320412408', '320412', '种兔场', '1', '320412408', null, '3', '1'),
('320412409', '320412', '横山苗圃', '1', '320412409', null, '3', '1'),
('320412410', '320412', '公路苗圃', '1', '320412410', null, '3', '1'),
('320412411', '320412', '高新区', '1', '320412411', null, '3', '1'),
('320481100', '320481', '溧城镇', '1', '320481100', null, '3', '1'),
('320481101', '320481', '埭头镇', '1', '320481101', null, '3', '1'),
('320481102', '320481', '上黄镇', '1', '320481102', null, '3', '1'),
('320481103', '320481', '戴埠镇', '1', '320481103', null, '3', '1'),
('320481104', '320481', '横涧镇', '1', '320481104', null, '3', '1'),
('320481106', '320481', '天目湖镇', '1', '320481106', null, '3', '1'),
('320481107', '320481', '别桥镇', '1', '320481107', null, '3', '1'),
('320481108', '320481', '绸缪镇', '1', '320481108', null, '3', '1'),
('320481109', '320481', '上兴镇', '1', '320481109', null, '3', '1'),
('320481110', '320481', '上沛镇', '1', '320481110', null, '3', '1'),
('320481111', '320481', '竹箦镇', '1', '320481111', null, '3', '1'),
('320481112', '320481', '后周镇', '1', '320481112', null, '3', '1'),
('320481113', '320481', '前马镇', '1', '320481113', null, '3', '1'),
('320481114', '320481', '南渡镇', '1', '320481114', null, '3', '1'),
('320481115', '320481', '新昌镇', '1', '320481115', null, '3', '1'),
('320481116', '320481', '社渚镇', '1', '320481116', null, '3', '1'),
('320481117', '320481', '周城镇', '1', '320481117', null, '3', '1'),
('320481400', '320481', '常州监狱', '1', '320481400', null, '3', '1'),
('320481401', '320481', '溧阳监狱', '1', '320481401', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('320482100', '320482', '金城镇', '1', '320482100', null, '3', '1'),
('320482101', '320482', '白塔镇', '1', '320482101', null, '3', '1'),
('320482102', '320482', '河头镇', '1', '320482102', null, '3', '1'),
('320482103', '320482', '水北镇', '1', '320482103', null, '3', '1'),
('320482104', '320482', '儒林镇', '1', '320482104', null, '3', '1'),
('320482105', '320482', '尧塘镇', '1', '320482105', null, '3', '1'),
('320482106', '320482', '直溪镇', '1', '320482106', null, '3', '1'),
('320482107', '320482', '建昌镇', '1', '320482107', null, '3', '1'),
('320482108', '320482', '朱林镇', '1', '320482108', null, '3', '1'),
('320482109', '320482', '薛埠镇', '1', '320482109', null, '3', '1'),
('320482110', '320482', '茅麓镇', '1', '320482110', null, '3', '1'),
('320482111', '320482', '社头镇', '1', '320482111', null, '3', '1'),
('320482112', '320482', '指前镇', '1', '320482112', null, '3', '1'),
('320482113', '320482', '洮西镇', '1', '320482113', null, '3', '1'),
('320482114', '320482', '西岗镇', '1', '320482114', null, '3', '1'),
('320482400', '320482', '开发区', '1', '320482400', null, '3', '1'),
('320502001', '320502', '双塔街道', '1', '320502001', null, '3', '1'),
('320502002', '320502', '南门街道', '1', '320502002', null, '3', '1'),
('320502003', '320502', '胥江街道', '1', '320502003', null, '3', '1'),
('320502004', '320502', '吴门桥街道', '1', '320502004', null, '3', '1'),
('320502005', '320502', '葑门街道', '1', '320502005', null, '3', '1'),
('320502006', '320502', '友新街道', '1', '320502006', null, '3', '1'),
('320503001', '320503', '观前街道', '1', '320503001', null, '3', '1'),
('320503002', '320503', '平江路街道', '1', '320503002', null, '3', '1'),
('320503003', '320503', '苏锦街道', '1', '320503003', null, '3', '1'),
('320503004', '320503', '娄门街道', '1', '320503004', null, '3', '1'),
('320503005', '320503', '城北街道', '1', '320503005', null, '3', '1'),
('320503006', '320503', '桃花坞街道', '1', '320503006', null, '3', '1'),
('320503150', '320503', '娄葑镇', '1', '320503150', null, '3', '1'),
('320503152', '320503', '唯亭镇', '1', '320503152', null, '3', '1'),
('320503153', '320503', '胜浦镇', '1', '320503153', null, '3', '1'),
('320503199', '320503', '虚拟镇', '1', '320503199', null, '3', '1'),
('320504001', '320504', '石路街道', '1', '320504001', null, '3', '1'),
('320504002', '320504', '彩香街道', '1', '320504002', null, '3', '1'),
('320504003', '320504', '留园街道', '1', '320504003', null, '3', '1'),
('320504004', '320504', '虎丘街道', '1', '320504004', null, '3', '1'),
('320504005', '320504', '白洋湾街道', '1', '320504005', null, '3', '1'),
('320505001', '320505', '横塘街道', '1', '320505001', null, '3', '1'),
('320505002', '320505', '狮山街道', '1', '320505002', null, '3', '1'),
('320505003', '320505', '枫桥街道', '1', '320505003', null, '3', '1'),
('320505004', '320505', '镇湖街道', '1', '320505004', null, '3', '1'),
('320505100', '320505', '浒墅关镇', '1', '320505100', null, '3', '1'),
('320505101', '320505', '通安镇', '1', '320505101', null, '3', '1'),
('320505102', '320505', '东渚镇', '1', '320505102', null, '3', '1'),
('320505400', '320505', '高新区浒墅关开发分区', '1', '320505400', null, '3', '1'),
('320505403', '320505', '苏州高新区出口加工区', '1', '320505403', null, '3', '1'),
('320505405', '320505', '苏州高新技术创业服务中心', '1', '320505405', null, '3', '1'),
('320505406', '320505', '苏州高新物流中心', '1', '320505406', null, '3', '1'),
('320505407', '320505', '苏州科技城', '1', '320505407', null, '3', '1'),
('320506001', '320506', '长桥街道', '1', '320506001', null, '3', '1'),
('320506003', '320506', '越溪街道', '1', '320506003', null, '3', '1'),
('320506004', '320506', '郭巷街道', '1', '320506004', null, '3', '1'),
('320506005', '320506', '横泾街道', '1', '320506005', null, '3', '1'),
('320506006', '320506', '香山街道', '1', '320506006', null, '3', '1'),
('320506007', '320506', '苏苑街道', '1', '320506007', null, '3', '1'),
('320506008', '320506', '龙西街道', '1', '320506008', null, '3', '1'),
('320506009', '320506', '城南街道', '1', '320506009', null, '3', '1'),
('320506100', '320506', '甪直镇', '1', '320506100', null, '3', '1'),
('320506101', '320506', '车坊镇', '1', '320506101', null, '3', '1'),
('320506102', '320506', '藏书镇', '1', '320506102', null, '3', '1'),
('320506103', '320506', '木渎镇', '1', '320506103', null, '3', '1'),
('320506104', '320506', '胥口镇', '1', '320506104', null, '3', '1'),
('320506105', '320506', '浦庄镇', '1', '320506105', null, '3', '1'),
('320506106', '320506', '渡村镇', '1', '320506106', null, '3', '1'),
('320506107', '320506', '东山镇', '1', '320506107', null, '3', '1'),
('320506108', '320506', '光福镇', '1', '320506108', null, '3', '1'),
('320506109', '320506', '西山镇', '1', '320506109', null, '3', '1'),
('320506400', '320506', '江苏省太湖采石公司', '1', '320506400', null, '3', '1'),
('320506401', '320506', '吴中区林场', '1', '320506401', null, '3', '1'),
('320506402', '320506', '西山农业园区', '1', '320506402', null, '3', '1'),
('320507001', '320507', '元和街道', '1', '320507001', null, '3', '1'),
('320507002', '320507', '太平街道', '1', '320507002', null, '3', '1'),
('320507003', '320507', '黄桥街道', '1', '320507003', null, '3', '1'),
('320507100', '320507', '望亭镇', '1', '320507100', null, '3', '1'),
('320507102', '320507', '黄埭镇', '1', '320507102', null, '3', '1'),
('320507105', '320507', '渭塘镇', '1', '320507105', null, '3', '1'),
('320507106', '320507', '北桥镇', '1', '320507106', null, '3', '1'),
('320507109', '320507', '阳澄湖镇', '1', '320507109', null, '3', '1'),
('320507400', '320507', '开发区', '1', '320507400', null, '3', '1'),
('320581100', '320581', '虞山镇', '1', '320581100', null, '3', '1'),
('320581101', '320581', '梅李镇', '1', '320581101', null, '3', '1'),
('320581102', '320581', '海虞镇', '1', '320581102', null, '3', '1'),
('320581103', '320581', '新港镇', '1', '320581103', null, '3', '1'),
('320581104', '320581', '古里镇', '1', '320581104', null, '3', '1'),
('320581105', '320581', '沙家浜镇', '1', '320581105', null, '3', '1'),
('320581106', '320581', '支塘镇', '1', '320581106', null, '3', '1'),
('320581107', '320581', '董浜镇', '1', '320581107', null, '3', '1'),
('320581110', '320581', '辛庄镇', '1', '320581110', null, '3', '1'),
('320581111', '320581', '尚湖镇', '1', '320581111', null, '3', '1'),
('320581400', '320581', '虞山林场', '1', '320581400', null, '3', '1'),
('320581401', '320581', '常熟经济开发区', '1', '320581401', null, '3', '1'),
('320581402', '320581', '常熟东南开发区', '1', '320581402', null, '3', '1'),
('320582100', '320582', '杨舍镇', '1', '320582100', null, '3', '1'),
('320582101', '320582', '塘桥镇', '1', '320582101', null, '3', '1'),
('320582102', '320582', '金港镇', '1', '320582102', null, '3', '1'),
('320582103', '320582', '锦丰镇', '1', '320582103', null, '3', '1'),
('320582104', '320582', '乐余镇', '1', '320582104', null, '3', '1'),
('320582105', '320582', '凤凰镇', '1', '320582105', null, '3', '1'),
('320582106', '320582', '南丰镇', '1', '320582106', null, '3', '1'),
('320582107', '320582', '大新镇', '1', '320582107', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('320582400', '320582', '常阴沙管理区', '1', '320582400', null, '3', '1'),
('320582401', '320582', '江苏省张家港经济技术开发区', '1', '320582401', null, '3', '1'),
('320582402', '320582', '张家港市沿江开发办', '1', '320582402', null, '3', '1'),
('320582403', '320582', '张家港保税区', '1', '320582403', null, '3', '1'),
('320582404', '320582', '张家港市稻麦良种场', '1', '320582404', null, '3', '1'),
('320582405', '320582', '张家港市畜禽良种场', '1', '320582405', null, '3', '1'),
('320583100', '320583', '玉山镇', '1', '320583100', null, '3', '1'),
('320583101', '320583', '巴城镇', '1', '320583101', null, '3', '1'),
('320583102', '320583', '周市镇', '1', '320583102', null, '3', '1'),
('320583103', '320583', '陆家镇', '1', '320583103', null, '3', '1'),
('320583104', '320583', '花桥镇', '1', '320583104', null, '3', '1'),
('320583105', '320583', '淀山湖镇', '1', '320583105', null, '3', '1'),
('320583106', '320583', '张浦镇', '1', '320583106', null, '3', '1'),
('320583107', '320583', '周庄镇', '1', '320583107', null, '3', '1'),
('320583108', '320583', '千灯镇', '1', '320583108', null, '3', '1'),
('320583109', '320583', '锦溪镇', '1', '320583109', null, '3', '1'),
('320583400', '320583', '开发区', '1', '320583400', null, '3', '1'),
('320584100', '320584', '松陵镇', '1', '320584100', null, '3', '1'),
('320584101', '320584', '同里镇', '1', '320584101', null, '3', '1'),
('320584104', '320584', '平望镇', '1', '320584104', null, '3', '1'),
('320584105', '320584', '盛泽镇', '1', '320584105', null, '3', '1'),
('320584106', '320584', '横扇镇', '1', '320584106', null, '3', '1'),
('320584107', '320584', '七都镇', '1', '320584107', null, '3', '1'),
('320584108', '320584', '震泽镇', '1', '320584108', null, '3', '1'),
('320584109', '320584', '桃源镇', '1', '320584109', null, '3', '1'),
('320584110', '320584', '汾湖镇', '1', '320584110', null, '3', '1'),
('320584400', '320584', '经济开发区', '1', '320584400', null, '3', '1'),
('320584401', '320584', '东方丝绸市场', '1', '320584401', null, '3', '1'),
('320585100', '320585', '城厢镇', '1', '320585100', null, '3', '1'),
('320585101', '320585', '沙溪镇', '1', '320585101', null, '3', '1'),
('320585102', '320585', '浏河镇', '1', '320585102', null, '3', '1'),
('320585103', '320585', '浮桥镇', '1', '320585103', null, '3', '1'),
('320585104', '320585', '璜泾镇', '1', '320585104', null, '3', '1'),
('320585105', '320585', '双凤镇', '1', '320585105', null, '3', '1'),
('320585106', '320585', '陆渡镇', '1', '320585106', null, '3', '1'),
('320585400', '320585', '经济开发区', '1', '320585400', null, '3', '1'),
('320585401', '320585', '港区', '1', '320585401', null, '3', '1'),
('320602001', '320602', '城东街道', '1', '320602001', null, '3', '1'),
('320602002', '320602', '和平桥街道', '1', '320602002', null, '3', '1'),
('320602003', '320602', '任港街道', '1', '320602003', null, '3', '1'),
('320602004', '320602', '新城桥街道', '1', '320602004', null, '3', '1'),
('320602005', '320602', '虹桥街道', '1', '320602005', null, '3', '1'),
('320602006', '320602', '学田街道', '1', '320602006', null, '3', '1'),
('320602007', '320602', '钟秀街道', '1', '320602007', null, '3', '1'),
('320602008', '320602', '文峰街道', '1', '320602008', null, '3', '1'),
('320602050', '320602', '中兴街道', '1', '320602050', null, '3', '1'),
('320602100', '320602', '观音山镇', '1', '320602100', null, '3', '1'),
('320602101', '320602', '狼山镇', '1', '320602101', null, '3', '1'),
('320602150', '320602', '新开镇', '1', '320602150', null, '3', '1'),
('320602151', '320602', '竹行镇', '1', '320602151', null, '3', '1'),
('320602152', '320602', '小海镇', '1', '320602152', null, '3', '1'),
('320602450', '320602', '江苏省国营南通农场', '1', '320602450', null, '3', '1'),
('320602451', '320602', '南通市富民港良种场', '1', '320602451', null, '3', '1'),
('320602452', '320602', '南通市富民港种畜场', '1', '320602452', null, '3', '1'),
('320611001', '320611', '永兴街道', '1', '320611001', null, '3', '1'),
('320611002', '320611', '唐闸镇街道', '1', '320611002', null, '3', '1'),
('320611003', '320611', '天生港镇街道', '1', '320611003', null, '3', '1'),
('320611004', '320611', '秦灶街道', '1', '320611004', null, '3', '1'),
('320611202', '320611', '陈桥乡', '1', '320611202', null, '3', '1'),
('320611203', '320611', '幸福乡', '1', '320611203', null, '3', '1'),
('320611400', '320611', '港闸开发区', '1', '320611400', null, '3', '1'),
('320621100', '320621', '海安镇', '1', '320621100', null, '3', '1'),
('320621101', '320621', '城东镇', '1', '320621101', null, '3', '1'),
('320621102', '320621', '曲塘镇', '1', '320621102', null, '3', '1'),
('320621103', '320621', '李堡镇', '1', '320621103', null, '3', '1'),
('320621104', '320621', '老坝港镇', '1', '320621104', null, '3', '1'),
('320621105', '320621', '角斜镇', '1', '320621105', null, '3', '1'),
('320621106', '320621', '西场镇', '1', '320621106', null, '3', '1'),
('320621107', '320621', '大公镇', '1', '320621107', null, '3', '1'),
('320621108', '320621', '孙庄镇', '1', '320621108', null, '3', '1'),
('320621109', '320621', '雅周镇', '1', '320621109', null, '3', '1'),
('320621110', '320621', '胡集镇', '1', '320621110', null, '3', '1'),
('320621111', '320621', '白甸镇', '1', '320621111', null, '3', '1'),
('320621112', '320621', '南莫镇', '1', '320621112', null, '3', '1'),
('320621113', '320621', '墩头镇', '1', '320621113', null, '3', '1'),
('320621400', '320621', '海安县农场', '1', '320621400', null, '3', '1'),
('320623100', '320623', '栟茶镇', '1', '320623100', null, '3', '1'),
('320623101', '320623', '洋口镇', '1', '320623101', null, '3', '1'),
('320623102', '320623', '苴镇', '1', '320623102', null, '3', '1'),
('320623103', '320623', '长沙镇', '1', '320623103', null, '3', '1'),
('320623104', '320623', '大豫镇', '1', '320623104', null, '3', '1'),
('320623105', '320623', '掘港镇', '1', '320623105', null, '3', '1'),
('320623106', '320623', '兵房镇', '1', '320623106', null, '3', '1'),
('320623107', '320623', '马塘镇', '1', '320623107', null, '3', '1'),
('320623108', '320623', '丰利镇', '1', '320623108', null, '3', '1'),
('320623109', '320623', '曹埠镇', '1', '320623109', null, '3', '1'),
('320623110', '320623', '岔河镇', '1', '320623110', null, '3', '1'),
('320623111', '320623', '双甸镇', '1', '320623111', null, '3', '1'),
('320623112', '320623', '新店镇', '1', '320623112', null, '3', '1'),
('320623113', '320623', '河口镇', '1', '320623113', null, '3', '1'),
('320623114', '320623', '袁庄镇', '1', '320623114', null, '3', '1'),
('320681100', '320681', '汇龙镇', '1', '320681100', null, '3', '1'),
('320681101', '320681', '大兴镇', '1', '320681101', null, '3', '1'),
('320681102', '320681', '南阳镇', '1', '320681102', null, '3', '1'),
('320681103', '320681', '惠丰镇', '1', '320681103', null, '3', '1'),
('320681104', '320681', '民主镇', '1', '320681104', null, '3', '1'),
('320681105', '320681', '北新镇', '1', '320681105', null, '3', '1'),
('320681106', '320681', '久隆镇', '1', '320681106', null, '3', '1'),
('320681107', '320681', '王鲍镇', '1', '320681107', null, '3', '1'),
('320681108', '320681', '合作镇', '1', '320681108', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('320681109', '320681', '志良镇', '1', '320681109', null, '3', '1'),
('320681110', '320681', '吕四港镇', '1', '320681110', null, '3', '1'),
('320681111', '320681', '天汾镇', '1', '320681111', null, '3', '1'),
('320681112', '320681', '兆民镇', '1', '320681112', null, '3', '1'),
('320681113', '320681', '海复镇', '1', '320681113', null, '3', '1'),
('320681114', '320681', '少直镇', '1', '320681114', null, '3', '1'),
('320681115', '320681', '向阳镇', '1', '320681115', null, '3', '1'),
('320681116', '320681', '东元镇', '1', '320681116', null, '3', '1'),
('320681117', '320681', '近海镇', '1', '320681117', null, '3', '1'),
('320681118', '320681', '寅阳镇', '1', '320681118', null, '3', '1'),
('320681119', '320681', '和合镇', '1', '320681119', null, '3', '1'),
('320681120', '320681', '惠萍镇', '1', '320681120', null, '3', '1'),
('320681121', '320681', '新安镇', '1', '320681121', null, '3', '1'),
('320681122', '320681', '东海镇', '1', '320681122', null, '3', '1'),
('320681200', '320681', '启隆乡', '1', '320681200', null, '3', '1'),
('320681400', '320681', '启东经济开发区', '1', '320681400', null, '3', '1'),
('320682100', '320682', '\"如城镇', '1', '320682100', null, '3', '1'),
('320682101', '320682', '\"柴湾镇', '1', '320682101', null, '3', '1'),
('320682102', '320682', '\"雪岸镇', '1', '320682102', null, '3', '1'),
('320682103', '320682', '\"东陈镇', '1', '320682103', null, '3', '1'),
('320682104', '320682', '\"丁堰镇', '1', '320682104', null, '3', '1'),
('320682105', '320682', '\"白蒲镇', '1', '320682105', null, '3', '1'),
('320682106', '320682', '\"林梓镇', '1', '320682106', null, '3', '1'),
('320682107', '320682', '\"下原镇', '1', '320682107', null, '3', '1'),
('320682108', '320682', '\"九华镇', '1', '320682108', null, '3', '1'),
('320682109', '320682', '\"郭园镇', '1', '320682109', null, '3', '1'),
('320682110', '320682', '\"石庄镇', '1', '320682110', null, '3', '1'),
('320682111', '320682', '\"长江镇', '1', '320682111', null, '3', '1'),
('320682112', '320682', '\"吴窑镇', '1', '320682112', null, '3', '1'),
('320682113', '320682', '\"江安镇', '1', '320682113', null, '3', '1'),
('320682114', '320682', '\"高明镇', '1', '320682114', null, '3', '1'),
('320682115', '320682', '\"常青镇', '1', '320682115', null, '3', '1'),
('320682116', '320682', '\"搬经镇', '1', '320682116', null, '3', '1'),
('320682117', '320682', '\"磨头镇', '1', '320682117', null, '3', '1'),
('320682118', '320682', '\"桃园镇', '1', '320682118', null, '3', '1'),
('320682119', '320682', '\"袁桥镇', '1', '320682119', null, '3', '1'),
('320682400', '320682', '如皋市经济开发区', '1', '320682400', null, '3', '1'),
('320682401', '320682', '\"如皋港开发区', '1', '320682401', null, '3', '1'),
('320682402', '320682', '南通市粮棉原种场', '1', '320682402', null, '3', '1'),
('320682403', '320682', '\"如皋市蚕种场', '1', '320682403', null, '3', '1'),
('320682404', '320682', '\"如皋市良种场', '1', '320682404', null, '3', '1'),
('320682405', '320682', '如皋市棉花原种场', '1', '320682405', null, '3', '1'),
('320682406', '320682', '\"如皋市种猪场', '1', '320682406', null, '3', '1'),
('320682407', '320682', '\"如皋市农科所', '1', '320682407', null, '3', '1'),
('320682408', '320682', '如皋市江滨医院', '1', '320682408', null, '3', '1'),
('320682409', '320682', '如皋市中心沙水产养殖场', '1', '320682409', null, '3', '1'),
('320682410', '320682', '如皋市九华水产养殖场', '1', '320682410', null, '3', '1'),
('320683100', '320683', '金沙镇', '1', '320683100', null, '3', '1'),
('320683101', '320683', '西亭镇', '1', '320683101', null, '3', '1'),
('320683102', '320683', '二甲镇', '1', '320683102', null, '3', '1'),
('320683103', '320683', '东社镇', '1', '320683103', null, '3', '1'),
('320683104', '320683', '三余镇', '1', '320683104', null, '3', '1'),
('320683105', '320683', '北兴桥镇', '1', '320683105', null, '3', '1'),
('320683106', '320683', '海晏镇', '1', '320683106', null, '3', '1'),
('320683107', '320683', '十总镇', '1', '320683107', null, '3', '1'),
('320683108', '320683', '骑岸镇', '1', '320683108', null, '3', '1'),
('320683109', '320683', '五甲镇', '1', '320683109', null, '3', '1'),
('320683110', '320683', '石港镇', '1', '320683110', null, '3', '1'),
('320683111', '320683', '四安镇', '1', '320683111', null, '3', '1'),
('320683112', '320683', '刘桥镇', '1', '320683112', null, '3', '1'),
('320683113', '320683', '新联镇', '1', '320683113', null, '3', '1'),
('320683114', '320683', '平潮镇', '1', '320683114', null, '3', '1'),
('320683115', '320683', '平东镇', '1', '320683115', null, '3', '1'),
('320683116', '320683', '五接镇', '1', '320683116', null, '3', '1'),
('320683117', '320683', '兴仁镇', '1', '320683117', null, '3', '1'),
('320683118', '320683', '兴东镇', '1', '320683118', null, '3', '1'),
('320683119', '320683', '张芝山镇', '1', '320683119', null, '3', '1'),
('320683120', '320683', '川港镇', '1', '320683120', null, '3', '1'),
('320683121', '320683', '先锋镇', '1', '320683121', null, '3', '1'),
('320683122', '320683', '姜灶镇', '1', '320683122', null, '3', '1'),
('320683400', '320683', '通州市开发区', '1', '320683400', null, '3', '1'),
('320683401', '320683', '环本农场', '1', '320683401', null, '3', '1'),
('320683403', '320683', '通州港区管委会', '1', '320683403', null, '3', '1'),
('320684100', '320684', '海门镇', '1', '320684100', null, '3', '1'),
('320684101', '320684', '三星镇', '1', '320684101', null, '3', '1'),
('320684102', '320684', '天补镇', '1', '320684102', null, '3', '1'),
('320684103', '320684', '三和镇', '1', '320684103', null, '3', '1'),
('320684104', '320684', '德胜镇', '1', '320684104', null, '3', '1'),
('320684105', '320684', '三厂镇', '1', '320684105', null, '3', '1'),
('320684106', '320684', '常乐镇', '1', '320684106', null, '3', '1'),
('320684107', '320684', '麒麟镇', '1', '320684107', null, '3', '1'),
('320684108', '320684', '悦来镇', '1', '320684108', null, '3', '1'),
('320684109', '320684', '万年镇', '1', '320684109', null, '3', '1'),
('320684110', '320684', '三阳镇', '1', '320684110', null, '3', '1'),
('320684111', '320684', '四甲镇', '1', '320684111', null, '3', '1'),
('320684112', '320684', '货隆镇', '1', '320684112', null, '3', '1'),
('320684113', '320684', '余东镇', '1', '320684113', null, '3', '1'),
('320684114', '320684', '正余镇', '1', '320684114', null, '3', '1'),
('320684115', '320684', '包场镇', '1', '320684115', null, '3', '1'),
('320684116', '320684', '刘浩镇', '1', '320684116', null, '3', '1'),
('320684117', '320684', '东灶港镇', '1', '320684117', null, '3', '1'),
('320684118', '320684', '临江镇', '1', '320684118', null, '3', '1'),
('320684119', '320684', '王浩镇', '1', '320684119', null, '3', '1'),
('320684120', '320684', '树勋镇', '1', '320684120', null, '3', '1'),
('320684200', '320684', '海永乡', '1', '320684200', null, '3', '1'),
('320684400', '320684', '海门市经济技术开发区', '1', '320684400', null, '3', '1'),
('320684401', '320684', '海门市永隆沙农场', '1', '320684401', null, '3', '1'),
('320684403', '320684', '海门市大东农场', '1', '320684403', null, '3', '1'),
('320684404', '320684', '海门市畜禽良种场', '1', '320684404', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('320684405', '320684', '海门市种羊场', '1', '320684405', null, '3', '1'),
('320684406', '320684', '海门市包场渔场', '1', '320684406', null, '3', '1'),
('320684407', '320684', '海门市长江芦荡养殖场', '1', '320684407', null, '3', '1'),
('320684408', '320684', '海门市沿江渔场', '1', '320684408', null, '3', '1'),
('320684409', '320684', '海门市三厂苗圃', '1', '320684409', null, '3', '1'),
('320684410', '320684', '海门市农科所', '1', '320684410', null, '3', '1'),
('320684411', '320684', '海门市海门盐场', '1', '320684411', null, '3', '1'),
('320684412', '320684', '海门市财政局芦荡管理所', '1', '320684412', null, '3', '1'),
('320684413', '320684', '江苏省国营江心沙农场', '1', '320684413', null, '3', '1'),
('320703001', '320703', '墟沟街道', '1', '320703001', null, '3', '1'),
('320703003', '320703', '连云街道', '1', '320703003', null, '3', '1'),
('320703004', '320703', '云山街道', '1', '320703004', null, '3', '1'),
('320703005', '320703', '板桥街道', '1', '320703005', null, '3', '1'),
('320703006', '320703', '连岛街道', '1', '320703006', null, '3', '1'),
('320703050', '320703', '中云街道', '1', '320703050', null, '3', '1'),
('320703051', '320703', '猴嘴街道', '1', '320703051', null, '3', '1'),
('320703150', '320703', '朝阳镇', '1', '320703150', null, '3', '1'),
('320703201', '320703', '宿城乡', '1', '320703201', null, '3', '1'),
('320703202', '320703', '高公岛乡', '1', '320703202', null, '3', '1'),
('320703203', '320703', '前三岛乡', '1', '320703203', null, '3', '1'),
('320703400', '320703', '连云港碱厂', '1', '320703400', null, '3', '1'),
('320705001', '320705', '浦东街道', '1', '320705001', null, '3', '1'),
('320705002', '320705', '浦西街道', '1', '320705002', null, '3', '1'),
('320705003', '320705', '新东街道', '1', '320705003', null, '3', '1'),
('320705004', '320705', '新南街道', '1', '320705004', null, '3', '1'),
('320705005', '320705', '路南街道', '1', '320705005', null, '3', '1'),
('320705006', '320705', '新海街道', '1', '320705006', null, '3', '1'),
('320705100', '320705', '南城镇', '1', '320705100', null, '3', '1'),
('320705200', '320705', '云台乡', '1', '320705200', null, '3', '1'),
('320705201', '320705', '花果山乡', '1', '320705201', null, '3', '1'),
('320705202', '320705', '宁海乡', '1', '320705202', null, '3', '1'),
('320705400', '320705', '云台农场', '1', '320705400', null, '3', '1'),
('320705401', '320705', '南云台林场', '1', '320705401', null, '3', '1'),
('320705402', '320705', '花果山风景区', '1', '320705402', null, '3', '1'),
('320706001', '320706', '海州街道', '1', '320706001', null, '3', '1'),
('320706002', '320706', '幸福路街道', '1', '320706002', null, '3', '1'),
('320706003', '320706', '朐阳街道', '1', '320706003', null, '3', '1'),
('320706004', '320706', '洪门街道', '1', '320706004', null, '3', '1'),
('320706100', '320706', '新坝镇', '1', '320706100', null, '3', '1'),
('320706101', '320706', '锦屏镇', '1', '320706101', null, '3', '1'),
('320721100', '320721', '青口镇', '1', '320721100', null, '3', '1'),
('320721101', '320721', '柘汪镇', '1', '320721101', null, '3', '1'),
('320721102', '320721', '石桥镇', '1', '320721102', null, '3', '1'),
('320721103', '320721', '金山镇', '1', '320721103', null, '3', '1'),
('320721104', '320721', '黑林镇', '1', '320721104', null, '3', '1'),
('320721105', '320721', '厉庄镇', '1', '320721105', null, '3', '1'),
('320721106', '320721', '海头镇', '1', '320721106', null, '3', '1'),
('320721107', '320721', '塔山镇', '1', '320721107', null, '3', '1'),
('320721108', '320721', '赣马镇', '1', '320721108', null, '3', '1'),
('320721109', '320721', '班庄镇', '1', '320721109', null, '3', '1'),
('320721110', '320721', '城头镇', '1', '320721110', null, '3', '1'),
('320721111', '320721', '门河镇', '1', '320721111', null, '3', '1'),
('320721112', '320721', '城西镇', '1', '320721112', null, '3', '1'),
('320721113', '320721', '欢墩镇', '1', '320721113', null, '3', '1'),
('320721114', '320721', '宋庄镇', '1', '320721114', null, '3', '1'),
('320721115', '320721', '沙河镇', '1', '320721115', null, '3', '1'),
('320721116', '320721', '墩尚镇', '1', '320721116', null, '3', '1'),
('320721117', '320721', '罗阳镇', '1', '320721117', null, '3', '1'),
('320721400', '320721', '沙河子园艺场', '1', '320721400', null, '3', '1'),
('320721401', '320721', '青口盐场', '1', '320721401', null, '3', '1'),
('320721402', '320721', '江苏省赣榆海洋经济开发区', '1', '320721402', null, '3', '1'),
('320721403', '320721', '江苏省赣榆经济开发区', '1', '320721403', null, '3', '1'),
('320722100', '320722', '牛山镇', '1', '320722100', null, '3', '1'),
('320722101', '320722', '白塔埠镇', '1', '320722101', null, '3', '1'),
('320722102', '320722', '浦南镇', '1', '320722102', null, '3', '1'),
('320722103', '320722', '黄川镇', '1', '320722103', null, '3', '1'),
('320722104', '320722', '石梁河镇', '1', '320722104', null, '3', '1'),
('320722105', '320722', '青湖镇', '1', '320722105', null, '3', '1'),
('320722106', '320722', '石榴镇', '1', '320722106', null, '3', '1'),
('320722107', '320722', '温泉镇', '1', '320722107', null, '3', '1'),
('320722108', '320722', '双店镇', '1', '320722108', null, '3', '1'),
('320722109', '320722', '桃林镇', '1', '320722109', null, '3', '1'),
('320722110', '320722', '洪庄镇', '1', '320722110', null, '3', '1'),
('320722111', '320722', '安峰镇', '1', '320722111', null, '3', '1'),
('320722112', '320722', '房山镇', '1', '320722112', null, '3', '1'),
('320722113', '320722', '平明镇', '1', '320722113', null, '3', '1'),
('320722200', '320722', '驼峰乡', '1', '320722200', null, '3', '1'),
('320722201', '320722', '南辰乡', '1', '320722201', null, '3', '1'),
('320722202', '320722', '横沟乡', '1', '320722202', null, '3', '1'),
('320722203', '320722', '李埝乡', '1', '320722203', null, '3', '1'),
('320722204', '320722', '山左口乡', '1', '320722204', null, '3', '1'),
('320722205', '320722', '石湖乡', '1', '320722205', null, '3', '1'),
('320722206', '320722', '曲阳乡', '1', '320722206', null, '3', '1'),
('320722207', '320722', '张湾乡', '1', '320722207', null, '3', '1'),
('320722400', '320722', '岗埠农场', '1', '320722400', null, '3', '1'),
('320722401', '320722', '江苏东海经济开发区', '1', '320722401', null, '3', '1'),
('320723100', '320723', '伊山镇', '1', '320723100', null, '3', '1'),
('320723101', '320723', '板浦镇', '1', '320723101', null, '3', '1'),
('320723102', '320723', '杨集镇', '1', '320723102', null, '3', '1'),
('320723103', '320723', '燕尾港镇', '1', '320723103', null, '3', '1'),
('320723104', '320723', '同兴镇', '1', '320723104', null, '3', '1'),
('320723105', '320723', '四队镇', '1', '320723105', null, '3', '1'),
('320723106', '320723', '圩丰镇', '1', '320723106', null, '3', '1'),
('320723107', '320723', '龙苴镇', '1', '320723107', null, '3', '1'),
('320723201', '320723', '伊芦乡', '1', '320723201', null, '3', '1'),
('320723202', '320723', '鲁河乡', '1', '320723202', null, '3', '1'),
('320723203', '320723', '图河乡', '1', '320723203', null, '3', '1'),
('320723204', '320723', '沂北乡', '1', '320723204', null, '3', '1'),
('320723205', '320723', '下车乡', '1', '320723205', null, '3', '1'),
('320723206', '320723', '白蚬乡', '1', '320723206', null, '3', '1'),
('320723207', '320723', '东王集乡', '1', '320723207', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('320723208', '320723', '侍庄乡', '1', '320723208', null, '3', '1'),
('320723209', '320723', '小伊乡', '1', '320723209', null, '3', '1'),
('320723210', '320723', '穆圩乡', '1', '320723210', null, '3', '1'),
('320723211', '320723', '陡沟乡', '1', '320723211', null, '3', '1'),
('320723212', '320723', '南岗乡', '1', '320723212', null, '3', '1'),
('320723400', '320723', '东辛农场', '1', '320723400', null, '3', '1'),
('320723401', '320723', '五图河农场', '1', '320723401', null, '3', '1'),
('320723402', '320723', '灌西盐场', '1', '320723402', null, '3', '1'),
('320724100', '320724', '新安镇', '1', '320724100', null, '3', '1'),
('320724101', '320724', '堆沟港镇', '1', '320724101', null, '3', '1'),
('320724102', '320724', '长茂镇', '1', '320724102', null, '3', '1'),
('320724103', '320724', '北陈集镇', '1', '320724103', null, '3', '1'),
('320724104', '320724', '张店镇', '1', '320724104', null, '3', '1'),
('320724105', '320724', '三口镇', '1', '320724105', null, '3', '1'),
('320724106', '320724', '孟兴庄镇', '1', '320724106', null, '3', '1'),
('320724107', '320724', '汤沟镇', '1', '320724107', null, '3', '1'),
('320724108', '320724', '百禄镇', '1', '320724108', null, '3', '1'),
('320724200', '320724', '五队乡', '1', '320724200', null, '3', '1'),
('320724201', '320724', '田楼乡', '1', '320724201', null, '3', '1'),
('320724204', '320724', '李集乡', '1', '320724204', null, '3', '1'),
('320724206', '320724', '新集乡', '1', '320724206', null, '3', '1'),
('320724207', '320724', '花园乡', '1', '320724207', null, '3', '1'),
('320802001', '320802', '北京路街道', '1', '320802001', null, '3', '1'),
('320802002', '320802', '长西街道', '1', '320802002', null, '3', '1'),
('320802003', '320802', '淮海街道', '1', '320802003', null, '3', '1'),
('320802004', '320802', '长东街道', '1', '320802004', null, '3', '1'),
('320802005', '320802', '西安路街道', '1', '320802005', null, '3', '1'),
('320802006', '320802', '水渡口街道', '1', '320802006', null, '3', '1'),
('320802050', '320802', '东湖街道', '1', '320802050', null, '3', '1'),
('320802051', '320802', '新港街道', '1', '320802051', null, '3', '1'),
('320802052', '320802', '广州路街道', '1', '320802052', null, '3', '1'),
('320802350', '320802', '钵池乡', '1', '320802350', null, '3', '1'),
('320802351', '320802', '徐杨乡', '1', '320802351', null, '3', '1'),
('320802400', '320802', '京沪路', '1', '320802400', null, '3', '1'),
('320803100', '320803', '淮城镇', '1', '320803100', null, '3', '1'),
('320803101', '320803', '平桥镇', '1', '320803101', null, '3', '1'),
('320803102', '320803', '上河镇', '1', '320803102', null, '3', '1'),
('320803103', '320803', '马甸镇', '1', '320803103', null, '3', '1'),
('320803104', '320803', '朱桥镇', '1', '320803104', null, '3', '1'),
('320803105', '320803', '溪河镇', '1', '320803105', null, '3', '1'),
('320803106', '320803', '施河镇', '1', '320803106', null, '3', '1'),
('320803107', '320803', '车桥镇', '1', '320803107', null, '3', '1'),
('320803108', '320803', '泾口镇', '1', '320803108', null, '3', '1'),
('320803109', '320803', '流均镇', '1', '320803109', null, '3', '1'),
('320803110', '320803', '博里镇', '1', '320803110', null, '3', '1'),
('320803111', '320803', '仇桥镇', '1', '320803111', null, '3', '1'),
('320803112', '320803', '复兴镇', '1', '320803112', null, '3', '1'),
('320803113', '320803', '苏嘴镇', '1', '320803113', null, '3', '1'),
('320803114', '320803', '钦工镇', '1', '320803114', null, '3', '1'),
('320803115', '320803', '顺河镇', '1', '320803115', null, '3', '1'),
('320803116', '320803', '季桥镇', '1', '320803116', null, '3', '1'),
('320803117', '320803', '席桥镇', '1', '320803117', null, '3', '1'),
('320803118', '320803', '林集镇', '1', '320803118', null, '3', '1'),
('320803119', '320803', '南闸镇', '1', '320803119', null, '3', '1'),
('320803120', '320803', '范集镇', '1', '320803120', null, '3', '1'),
('320803200', '320803', '建淮乡', '1', '320803200', null, '3', '1'),
('320803201', '320803', '茭陵乡', '1', '320803201', null, '3', '1'),
('320803202', '320803', '宋集乡', '1', '320803202', null, '3', '1'),
('320803203', '320803', '城东乡', '1', '320803203', null, '3', '1'),
('320803204', '320803', '南马厂乡', '1', '320803204', null, '3', '1'),
('320803205', '320803', '三堡乡', '1', '320803205', null, '3', '1'),
('320803400', '320803', '白马湖农场', '1', '320803400', null, '3', '1'),
('320804100', '320804', '王营镇', '1', '320804100', null, '3', '1'),
('320804101', '320804', '赵集镇', '1', '320804101', null, '3', '1'),
('320804102', '320804', '吴城镇', '1', '320804102', null, '3', '1'),
('320804103', '320804', '南陈集镇', '1', '320804103', null, '3', '1'),
('320804104', '320804', '码头镇', '1', '320804104', null, '3', '1'),
('320804105', '320804', '王兴镇', '1', '320804105', null, '3', '1'),
('320804106', '320804', '棉花庄镇', '1', '320804106', null, '3', '1'),
('320804107', '320804', '丁集镇', '1', '320804107', null, '3', '1'),
('320804108', '320804', '五里镇', '1', '320804108', null, '3', '1'),
('320804109', '320804', '徐溜镇', '1', '320804109', null, '3', '1'),
('320804110', '320804', '渔沟镇', '1', '320804110', null, '3', '1'),
('320804111', '320804', '吴集镇', '1', '320804111', null, '3', '1'),
('320804112', '320804', '西宋集镇', '1', '320804112', null, '3', '1'),
('320804113', '320804', '三树镇', '1', '320804113', null, '3', '1'),
('320804200', '320804', '韩桥乡', '1', '320804200', null, '3', '1'),
('320804201', '320804', '新渡乡', '1', '320804201', null, '3', '1'),
('320804202', '320804', '老张集乡', '1', '320804202', null, '3', '1'),
('320804203', '320804', '凌桥乡', '1', '320804203', null, '3', '1'),
('320804204', '320804', '袁集乡', '1', '320804204', null, '3', '1'),
('320804205', '320804', '刘老庄乡', '1', '320804205', null, '3', '1'),
('320804206', '320804', '古寨乡', '1', '320804206', null, '3', '1'),
('320804400', '320804', '工业园管理委员会', '1', '320804400', null, '3', '1'),
('320811001', '320811', '清江街道', '1', '320811001', null, '3', '1'),
('320811002', '320811', '浦楼街道', '1', '320811002', null, '3', '1'),
('320811003', '320811', '闸口街道', '1', '320811003', null, '3', '1'),
('320811004', '320811', '清安街道', '1', '320811004', null, '3', '1'),
('320811100', '320811', '和平镇', '1', '320811100', null, '3', '1'),
('320811101', '320811', '武墩镇', '1', '320811101', null, '3', '1'),
('320811102', '320811', '盐河镇', '1', '320811102', null, '3', '1'),
('320811200', '320811', '城南乡', '1', '320811200', null, '3', '1'),
('320811201', '320811', '黄码乡', '1', '320811201', null, '3', '1'),
('320826100', '320826', '涟城镇', '1', '320826100', null, '3', '1'),
('320826101', '320826', '高沟镇', '1', '320826101', null, '3', '1'),
('320826102', '320826', '唐集镇', '1', '320826102', null, '3', '1'),
('320826103', '320826', '保滩镇', '1', '320826103', null, '3', '1'),
('320826104', '320826', '大东镇', '1', '320826104', null, '3', '1'),
('320826105', '320826', '五港镇', '1', '320826105', null, '3', '1'),
('320826106', '320826', '梁岔镇', '1', '320826106', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('320826107', '320826', '石湖镇', '1', '320826107', null, '3', '1'),
('320826108', '320826', '朱码镇', '1', '320826108', null, '3', '1'),
('320826109', '320826', '岔庙镇', '1', '320826109', null, '3', '1'),
('320826110', '320826', '东胡集镇', '1', '320826110', null, '3', '1'),
('320826111', '320826', '南集镇', '1', '320826111', null, '3', '1'),
('320826112', '320826', '义兴镇', '1', '320826112', null, '3', '1'),
('320826113', '320826', '成集镇', '1', '320826113', null, '3', '1'),
('320826114', '320826', '红窑镇', '1', '320826114', null, '3', '1'),
('320826115', '320826', '陈师镇', '1', '320826115', null, '3', '1'),
('320826116', '320826', '前进镇', '1', '320826116', null, '3', '1'),
('320826200', '320826', '徐集乡', '1', '320826200', null, '3', '1'),
('320826201', '320826', '黄营乡', '1', '320826201', null, '3', '1'),
('320826400', '320826', '杨口', '1', '320826400', null, '3', '1'),
('320826401', '320826', '方渡', '1', '320826401', null, '3', '1'),
('320826402', '320826', '南禄', '1', '320826402', null, '3', '1'),
('320826403', '320826', '小李集', '1', '320826403', null, '3', '1'),
('320826404', '320826', '河网', '1', '320826404', null, '3', '1'),
('320826405', '320826', '时码', '1', '320826405', null, '3', '1'),
('320826406', '320826', '北集', '1', '320826406', null, '3', '1'),
('320826407', '320826', '灰墩', '1', '320826407', null, '3', '1'),
('320826408', '320826', '余圩', '1', '320826408', null, '3', '1'),
('320826409', '320826', '浅集', '1', '320826409', null, '3', '1'),
('320826410', '320826', '蒋庵', '1', '320826410', null, '3', '1'),
('320826411', '320826', '经济开发新区', '1', '320826411', null, '3', '1'),
('320826412', '320826', '经济开发区', '1', '320826412', null, '3', '1'),
('320829100', '320829', '高良涧镇', '1', '320829100', null, '3', '1'),
('320829101', '320829', '蒋坝镇', '1', '320829101', null, '3', '1'),
('320829102', '320829', '仁和镇', '1', '320829102', null, '3', '1'),
('320829103', '320829', '岔河镇', '1', '320829103', null, '3', '1'),
('320829104', '320829', '西顺河镇', '1', '320829104', null, '3', '1'),
('320829105', '320829', '老子山镇', '1', '320829105', null, '3', '1'),
('320829106', '320829', '三河镇', '1', '320829106', null, '3', '1'),
('320829107', '320829', '朱坝镇', '1', '320829107', null, '3', '1'),
('320829108', '320829', '黄集镇', '1', '320829108', null, '3', '1'),
('320829109', '320829', '万集镇', '1', '320829109', null, '3', '1'),
('320829110', '320829', '东双沟镇', '1', '320829110', null, '3', '1'),
('320829111', '320829', '共和镇', '1', '320829111', null, '3', '1'),
('320830100', '320830', '盱城镇', '1', '320830100', null, '3', '1'),
('320830101', '320830', '马坝镇', '1', '320830101', null, '3', '1'),
('320830102', '320830', '官滩镇', '1', '320830102', null, '3', '1'),
('320830103', '320830', '旧铺镇', '1', '320830103', null, '3', '1'),
('320830104', '320830', '桂五镇', '1', '320830104', null, '3', '1'),
('320830105', '320830', '管镇镇', '1', '320830105', null, '3', '1'),
('320830106', '320830', '河桥镇', '1', '320830106', null, '3', '1'),
('320830107', '320830', '鲍集镇', '1', '320830107', null, '3', '1'),
('320830108', '320830', '黄花塘镇', '1', '320830108', null, '3', '1'),
('320830109', '320830', '明祖陵镇', '1', '320830109', null, '3', '1'),
('320830110', '320830', '铁佛镇', '1', '320830110', null, '3', '1'),
('320830111', '320830', '淮河镇', '1', '320830111', null, '3', '1'),
('320830112', '320830', '仇集镇', '1', '320830112', null, '3', '1'),
('320830113', '320830', '观音寺镇', '1', '320830113', null, '3', '1'),
('320830200', '320830', '维桥乡', '1', '320830200', null, '3', '1'),
('320830201', '320830', '穆店乡', '1', '320830201', null, '3', '1'),
('320830202', '320830', '王店乡', '1', '320830202', null, '3', '1'),
('320830203', '320830', '古桑乡', '1', '320830203', null, '3', '1'),
('320830204', '320830', '兴隆乡', '1', '320830204', null, '3', '1'),
('320830400', '320830', '三河农场', '1', '320830400', null, '3', '1'),
('320830401', '320830', '淮化集团', '1', '320830401', null, '3', '1'),
('320831100', '320831', '黎城镇', '1', '320831100', null, '3', '1'),
('320831101', '320831', '金南镇', '1', '320831101', null, '3', '1'),
('320831102', '320831', '闵桥镇', '1', '320831102', null, '3', '1'),
('320831103', '320831', '塔集镇', '1', '320831103', null, '3', '1'),
('320831104', '320831', '银集镇', '1', '320831104', null, '3', '1'),
('320831105', '320831', '涂沟镇', '1', '320831105', null, '3', '1'),
('320831106', '320831', '前锋镇', '1', '320831106', null, '3', '1'),
('320831107', '320831', '吕良镇', '1', '320831107', null, '3', '1'),
('320831108', '320831', '陈桥镇', '1', '320831108', null, '3', '1'),
('320831109', '320831', '金北镇', '1', '320831109', null, '3', '1'),
('320831110', '320831', '戴楼镇', '1', '320831110', null, '3', '1'),
('320831400', '320831', '宝应湖农场', '1', '320831400', null, '3', '1'),
('320831401', '320831', '复兴圩农场', '1', '320831401', null, '3', '1'),
('320831402', '320831', '粮棉原种场', '1', '320831402', null, '3', '1'),
('320831403', '320831', '江苏金湖经济开发区', '1', '320831403', null, '3', '1'),
('320902001', '320902', '五星街道', '1', '320902001', null, '3', '1'),
('320902002', '320902', '文峰街道', '1', '320902002', null, '3', '1'),
('320902003', '320902', '先锋街道', '1', '320902003', null, '3', '1'),
('320902004', '320902', '毓龙街道', '1', '320902004', null, '3', '1'),
('320902005', '320902', '张庄街道', '1', '320902005', null, '3', '1'),
('320902006', '320902', '黄海街道', '1', '320902006', null, '3', '1'),
('320902007', '320902', '新洋街道', '1', '320902007', null, '3', '1'),
('320902008', '320902', '大洋街道', '1', '320902008', null, '3', '1'),
('320902100', '320902', '南洋镇', '1', '320902100', null, '3', '1'),
('320902101', '320902', '亭湖区青墩镇', '1', '320902101', null, '3', '1'),
('320902102', '320902', '新兴镇', '1', '320902102', null, '3', '1'),
('320902103', '320902', '永丰镇', '1', '320902103', null, '3', '1'),
('320902104', '320902', '便仓镇', '1', '320902104', null, '3', '1'),
('320902105', '320902', '伍佑镇', '1', '320902105', null, '3', '1'),
('320902106', '320902', '步凤镇', '1', '320902106', null, '3', '1'),
('320902400', '320902', '开发区', '1', '320902400', null, '3', '1'),
('320902401', '320902', '市开发区', '1', '320902401', null, '3', '1'),
('320903100', '320903', '大纵湖镇', '1', '320903100', null, '3', '1'),
('320903101', '320903', '北龙港镇', '1', '320903101', null, '3', '1'),
('320903102', '320903', '楼王镇', '1', '320903102', null, '3', '1'),
('320903103', '320903', '学富镇', '1', '320903103', null, '3', '1'),
('320903104', '320903', '义丰镇', '1', '320903104', null, '3', '1'),
('320903105', '320903', '尚庄镇', '1', '320903105', null, '3', '1'),
('320903106', '320903', '葛武镇', '1', '320903106', null, '3', '1'),
('320903107', '320903', '北蒋镇', '1', '320903107', null, '3', '1'),
('320903108', '320903', '秦南镇', '1', '320903108', null, '3', '1'),
('320903109', '320903', '龙冈镇', '1', '320903109', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('320903110', '320903', '潘黄镇', '1', '320903110', null, '3', '1'),
('320903111', '320903', '郭猛镇', '1', '320903111', null, '3', '1'),
('320903112', '320903', '大冈镇', '1', '320903112', null, '3', '1'),
('320903550', '320903', '新区街道', '1', '320903550', null, '3', '1'),
('320921100', '320921', '响水镇', '1', '320921100', null, '3', '1'),
('320921101', '320921', '陈家港镇', '1', '320921101', null, '3', '1'),
('320921102', '320921', '小尖镇', '1', '320921102', null, '3', '1'),
('320921103', '320921', '黄圩镇', '1', '320921103', null, '3', '1'),
('320921104', '320921', '大有镇', '1', '320921104', null, '3', '1'),
('320921105', '320921', '双港镇', '1', '320921105', null, '3', '1'),
('320921106', '320921', '南河镇', '1', '320921106', null, '3', '1'),
('320921107', '320921', '运河镇', '1', '320921107', null, '3', '1'),
('320921200', '320921', '张集乡', '1', '320921200', null, '3', '1'),
('320921201', '320921', '六套乡', '1', '320921201', null, '3', '1'),
('320921202', '320921', '七套乡', '1', '320921202', null, '3', '1'),
('320921203', '320921', '老舍乡', '1', '320921203', null, '3', '1'),
('320921400', '320921', '县开发区', '1', '320921400', null, '3', '1'),
('320921401', '320921', '省属黄海农场', '1', '320921401', null, '3', '1'),
('320921402', '320921', '省属灌东盐场', '1', '320921402', null, '3', '1'),
('320922100', '320922', '东坎镇', '1', '320922100', null, '3', '1'),
('320922101', '320922', '五汛镇', '1', '320922101', null, '3', '1'),
('320922102', '320922', '蔡桥镇', '1', '320922102', null, '3', '1'),
('320922103', '320922', '正红镇', '1', '320922103', null, '3', '1'),
('320922104', '320922', '通榆镇', '1', '320922104', null, '3', '1'),
('320922105', '320922', '界牌镇', '1', '320922105', null, '3', '1'),
('320922106', '320922', '八巨镇', '1', '320922106', null, '3', '1'),
('320922107', '320922', '八滩镇', '1', '320922107', null, '3', '1'),
('320922108', '320922', '滨海港镇', '1', '320922108', null, '3', '1'),
('320922109', '320922', '滨淮镇', '1', '320922109', null, '3', '1'),
('320922200', '320922', '天场乡', '1', '320922200', null, '3', '1'),
('320922201', '320922', '大套乡', '1', '320922201', null, '3', '1'),
('320922202', '320922', '陈涛乡', '1', '320922202', null, '3', '1'),
('320922203', '320922', '振东乡', '1', '320922203', null, '3', '1'),
('320922204', '320922', '樊集乡', '1', '320922204', null, '3', '1'),
('320922400', '320922', '滨淮农场', '1', '320922400', null, '3', '1'),
('320922401', '320922', '新滩盐场', '1', '320922401', null, '3', '1'),
('320922402', '320922', '开发区工业园', '1', '320922402', null, '3', '1'),
('320923100', '320923', '阜城镇', '1', '320923100', null, '3', '1'),
('320923101', '320923', '沟墩镇', '1', '320923101', null, '3', '1'),
('320923102', '320923', '吴滩镇', '1', '320923102', null, '3', '1'),
('320923103', '320923', '合利镇', '1', '320923103', null, '3', '1'),
('320923104', '320923', '陈良镇', '1', '320923104', null, '3', '1'),
('320923105', '320923', '施庄镇', '1', '320923105', null, '3', '1'),
('320923106', '320923', '三灶镇', '1', '320923106', null, '3', '1'),
('320923107', '320923', '郭墅镇', '1', '320923107', null, '3', '1'),
('320923108', '320923', '新沟镇', '1', '320923108', null, '3', '1'),
('320923109', '320923', '陈集镇', '1', '320923109', null, '3', '1'),
('320923110', '320923', '羊寨镇', '1', '320923110', null, '3', '1'),
('320923111', '320923', '芦蒲镇', '1', '320923111', null, '3', '1'),
('320923112', '320923', '硕集镇', '1', '320923112', null, '3', '1'),
('320923113', '320923', '板湖镇', '1', '320923113', null, '3', '1'),
('320923114', '320923', '东沟镇', '1', '320923114', null, '3', '1'),
('320923115', '320923', '益林镇', '1', '320923115', null, '3', '1'),
('320923116', '320923', '公兴镇', '1', '320923116', null, '3', '1'),
('320923117', '320923', '杨集镇', '1', '320923117', null, '3', '1'),
('320923118', '320923', '古河镇', '1', '320923118', null, '3', '1'),
('320923119', '320923', '罗桥镇', '1', '320923119', null, '3', '1'),
('320923400', '320923', '开发区', '1', '320923400', null, '3', '1'),
('320923401', '320923', '化工园区', '1', '320923401', null, '3', '1'),
('320924100', '320924', '合德镇', '1', '320924100', null, '3', '1'),
('320924101', '320924', '临海镇', '1', '320924101', null, '3', '1'),
('320924102', '320924', '千秋镇', '1', '320924102', null, '3', '1'),
('320924103', '320924', '通洋镇', '1', '320924103', null, '3', '1'),
('320924104', '320924', '四明镇', '1', '320924104', null, '3', '1'),
('320924105', '320924', '阜余镇', '1', '320924105', null, '3', '1'),
('320924106', '320924', '海河镇', '1', '320924106', null, '3', '1'),
('320924107', '320924', '陈洋镇', '1', '320924107', null, '3', '1'),
('320924108', '320924', '海通镇', '1', '320924108', null, '3', '1'),
('320924109', '320924', '兴桥镇', '1', '320924109', null, '3', '1'),
('320924110', '320924', '新坍镇', '1', '320924110', null, '3', '1'),
('320924111', '320924', '长荡镇', '1', '320924111', null, '3', '1'),
('320924112', '320924', '盘湾镇', '1', '320924112', null, '3', '1'),
('320924113', '320924', '特庸镇', '1', '320924113', null, '3', '1'),
('320924114', '320924', '洋马镇', '1', '320924114', null, '3', '1'),
('320924115', '320924', '黄尖镇', '1', '320924115', null, '3', '1'),
('320924116', '320924', '盐东镇', '1', '320924116', null, '3', '1'),
('320924117', '320924', '黄沙港镇', '1', '320924117', null, '3', '1'),
('320924118', '320924', '耦耕镇', '1', '320924118', null, '3', '1'),
('320924400', '320924', '开发区', '1', '320924400', null, '3', '1'),
('320924401', '320924', '淮海农场', '1', '320924401', null, '3', '1'),
('320924402', '320924', '临海农场', '1', '320924402', null, '3', '1'),
('320924403', '320924', '新洋农场', '1', '320924403', null, '3', '1'),
('320924404', '320924', '射阳盐场', '1', '320924404', null, '3', '1'),
('320924405', '320924', '农业经济开发区', '1', '320924405', null, '3', '1'),
('320925100', '320925', '近湖镇', '1', '320925100', null, '3', '1'),
('320925101', '320925', '建阳镇', '1', '320925101', null, '3', '1'),
('320925102', '320925', '蒋营镇', '1', '320925102', null, '3', '1'),
('320925103', '320925', '恒济镇', '1', '320925103', null, '3', '1'),
('320925104', '320925', '颜单镇', '1', '320925104', null, '3', '1'),
('320925105', '320925', '沿河镇', '1', '320925105', null, '3', '1'),
('320925106', '320925', '芦沟镇', '1', '320925106', null, '3', '1'),
('320925107', '320925', '庆丰镇', '1', '320925107', null, '3', '1'),
('320925108', '320925', '上冈镇', '1', '320925108', null, '3', '1'),
('320925109', '320925', '冈东镇', '1', '320925109', null, '3', '1'),
('320925110', '320925', '草堰口镇', '1', '320925110', null, '3', '1'),
('320925111', '320925', '冈西镇', '1', '320925111', null, '3', '1'),
('320925112', '320925', '钟庄镇', '1', '320925112', null, '3', '1'),
('320925113', '320925', '宝塔镇', '1', '320925113', null, '3', '1'),
('320925114', '320925', '高作镇', '1', '320925114', null, '3', '1'),
('320925400', '320925', '经济开发区', '1', '320925400', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('320981100', '320981', '溱东镇', '1', '320981100', null, '3', '1'),
('320981101', '320981', '时堰镇', '1', '320981101', null, '3', '1'),
('320981102', '320981', '后港镇', '1', '320981102', null, '3', '1'),
('320981103', '320981', '台南镇', '1', '320981103', null, '3', '1'),
('320981104', '320981', '广山镇', '1', '320981104', null, '3', '1'),
('320981105', '320981', '廉贻镇', '1', '320981105', null, '3', '1'),
('320981106', '320981', '五烈镇', '1', '320981106', null, '3', '1'),
('320981107', '320981', '梁垛镇', '1', '320981107', null, '3', '1'),
('320981108', '320981', '安丰镇', '1', '320981108', null, '3', '1'),
('320981109', '320981', '南沈灶镇', '1', '320981109', null, '3', '1'),
('320981110', '320981', '富安镇', '1', '320981110', null, '3', '1'),
('320981111', '320981', '富东镇', '1', '320981111', null, '3', '1'),
('320981112', '320981', '唐洋镇', '1', '320981112', null, '3', '1'),
('320981113', '320981', '新街镇', '1', '320981113', null, '3', '1'),
('320981114', '320981', '许河镇', '1', '320981114', null, '3', '1'),
('320981115', '320981', '三仓镇', '1', '320981115', null, '3', '1'),
('320981116', '320981', '新曹镇', '1', '320981116', null, '3', '1'),
('320981117', '320981', '曹丿镇', '1', '320981117', null, '3', '1'),
('320981118', '320981', '头灶镇', '1', '320981118', null, '3', '1'),
('320981119', '320981', '四灶镇', '1', '320981119', null, '3', '1'),
('320981120', '320981', '海丰镇', '1', '320981120', null, '3', '1'),
('320981121', '320981', '弶港镇', '1', '320981121', null, '3', '1'),
('320981122', '320981', '东台镇', '1', '320981122', null, '3', '1'),
('320981400', '320981', '国营新曹农场', '1', '320981400', null, '3', '1'),
('320981401', '320981', '国营弶港农场', '1', '320981401', null, '3', '1'),
('320981402', '320981', '蚕种场', '1', '320981402', null, '3', '1'),
('320981403', '320981', '林场', '1', '320981403', null, '3', '1'),
('320981404', '320981', '黄海原种场', '1', '320981404', null, '3', '1'),
('320981405', '320981', '渔舍农场', '1', '320981405', null, '3', '1'),
('320981406', '320981', '种畜场', '1', '320981406', null, '3', '1'),
('320981407', '320981', '金东台农场', '1', '320981407', null, '3', '1'),
('320981408', '320981', '原种场', '1', '320981408', null, '3', '1'),
('320981409', '320981', '开发区', '1', '320981409', null, '3', '1'),
('320982100', '320982', '大中镇', '1', '320982100', null, '3', '1'),
('320982101', '320982', '草堰镇', '1', '320982101', null, '3', '1'),
('320982102', '320982', '白驹镇', '1', '320982102', null, '3', '1'),
('320982103', '320982', '刘庄镇', '1', '320982103', null, '3', '1'),
('320982104', '320982', '西团镇', '1', '320982104', null, '3', '1'),
('320982105', '320982', '小海镇', '1', '320982105', null, '3', '1'),
('320982106', '320982', '大桥镇', '1', '320982106', null, '3', '1'),
('320982107', '320982', '草庙镇', '1', '320982107', null, '3', '1'),
('320982108', '320982', '万盈镇', '1', '320982108', null, '3', '1'),
('320982109', '320982', '南阳镇', '1', '320982109', null, '3', '1'),
('320982110', '320982', '裕华镇', '1', '320982110', null, '3', '1'),
('320982111', '320982', '新丰镇', '1', '320982111', null, '3', '1'),
('320982112', '320982', '三龙镇', '1', '320982112', null, '3', '1'),
('320982113', '320982', '方强镇', '1', '320982113', null, '3', '1'),
('320982400', '320982', '大中农场', '1', '320982400', null, '3', '1'),
('320982401', '320982', '方强农场', '1', '320982401', null, '3', '1'),
('320982402', '320982', '东坝头农场', '1', '320982402', null, '3', '1'),
('321002001', '321002', '东关街道', '1', '321002001', null, '3', '1'),
('321002002', '321002', '汶河街道', '1', '321002002', null, '3', '1'),
('321002003', '321002', '文峰街道', '1', '321002003', null, '3', '1'),
('321002004', '321002', '曲江街道', '1', '321002004', null, '3', '1'),
('321002100', '321002', '湾头镇', '1', '321002100', null, '3', '1'),
('321002200', '321002', '汤汪乡', '1', '321002200', null, '3', '1'),
('321003001', '321003', '邗上街道', '1', '321003001', null, '3', '1'),
('321003002', '321003', '蒋王街道', '1', '321003002', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('321003003', '321003', '汊河街道', '1', '321003003', null, '3', '1'),
('321003100', '321003', '公道镇', '1', '321003100', null, '3', '1'),
('321003101', '321003', '方巷镇', '1', '321003101', null, '3', '1'),
('321003102', '321003', '槐泗镇', '1', '321003102', null, '3', '1'),
('321003103', '321003', '瓜洲镇', '1', '321003103', null, '3', '1'),
('321003104', '321003', '杭集镇', '1', '321003104', null, '3', '1'),
('321003105', '321003', '李典镇', '1', '321003105', null, '3', '1'),
('321003106', '321003', '沙头镇', '1', '321003106', null, '3', '1'),
('321003107', '321003', '头桥镇', '1', '321003107', null, '3', '1'),
('321003108', '321003', '甘泉镇', '1', '321003108', null, '3', '1'),
('321003109', '321003', '泰安镇', '1', '321003109', null, '3', '1'),
('321003110', '321003', '杨庙镇', '1', '321003110', null, '3', '1'),
('321003450', '321003', '邗江工业园', '1', '321003450', null, '3', '1'),
('321011001', '321011', '双桥街道', '1', '321011001', null, '3', '1'),
('321011002', '321011', '梅岭街道', '1', '321011002', null, '3', '1'),
('321011003', '321011', '瘦西湖街道', '1', '321011003', null, '3', '1'),
('321011050', '321011', '扬子津街道', '1', '321011050', null, '3', '1'),
('321011051', '321011', '文汇街道', '1', '321011051', null, '3', '1'),
('321011060', '321011', '新盛街道', '1', '321011060', null, '3', '1'),
('321011100', '321011', '西湖镇', '1', '321011100', null, '3', '1'),
('321011150', '321011', '施桥镇', '1', '321011150', null, '3', '1'),
('321011151', '321011', '八里镇', '1', '321011151', null, '3', '1'),
('321011200', '321011', '平山乡', '1', '321011200', null, '3', '1'),
('321011201', '321011', '双桥乡', '1', '321011201', null, '3', '1'),
('321011202', '321011', '城北乡', '1', '321011202', null, '3', '1'),
('321011400', '321011', '平山茶场', '1', '321011400', null, '3', '1'),
('321011401', '321011', '维扬经济开发区', '1', '321011401', null, '3', '1'),
('321023100', '321023', '安宜镇', '1', '321023100', null, '3', '1'),
('321023101', '321023', '范水镇', '1', '321023101', null, '3', '1'),
('321023102', '321023', '夏集镇', '1', '321023102', null, '3', '1'),
('321023103', '321023', '柳堡镇', '1', '321023103', null, '3', '1'),
('321023104', '321023', '射阳湖镇', '1', '321023104', null, '3', '1'),
('321023105', '321023', '广洋湖镇', '1', '321023105', null, '3', '1'),
('321023106', '321023', '鲁垛镇', '1', '321023106', null, '3', '1'),
('321023107', '321023', '小官庄镇', '1', '321023107', null, '3', '1'),
('321023108', '321023', '望直港镇', '1', '321023108', null, '3', '1'),
('321023109', '321023', '曹甸镇', '1', '321023109', null, '3', '1'),
('321023110', '321023', '西安丰镇', '1', '321023110', null, '3', '1'),
('321023111', '321023', '山阳镇', '1', '321023111', null, '3', '1'),
('321023112', '321023', '黄塍镇', '1', '321023112', null, '3', '1'),
('321023113', '321023', '泾河镇', '1', '321023113', null, '3', '1'),
('321023400', '321023', '开发区管委会', '1', '321023400', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('321081100', '321081', '真州镇', '1', '321081100', null, '3', '1'),
('321081101', '321081', '青山镇', '1', '321081101', null, '3', '1'),
('321081102', '321081', '朴席镇', '1', '321081102', null, '3', '1'),
('321081103', '321081', '新集镇', '1', '321081103', null, '3', '1'),
('321081104', '321081', '新城镇', '1', '321081104', null, '3', '1'),
('321081105', '321081', '马集镇', '1', '321081105', null, '3', '1'),
('321081106', '321081', '刘集镇', '1', '321081106', null, '3', '1'),
('321081107', '321081', '陈集镇', '1', '321081107', null, '3', '1'),
('321081108', '321081', '大仪镇', '1', '321081108', null, '3', '1'),
('321081200', '321081', '谢集乡', '1', '321081200', null, '3', '1'),
('321081201', '321081', '月塘乡', '1', '321081201', null, '3', '1'),
('321081400', '321081', '开发区', '1', '321081400', null, '3', '1'),
('321081401', '321081', '原种场', '1', '321081401', null, '3', '1'),
('321081402', '321081', '蚕种场', '1', '321081402', null, '3', '1'),
('321081403', '321081', '园艺试验场', '1', '321081403', null, '3', '1'),
('321081404', '321081', '水产试验场', '1', '321081404', null, '3', '1'),
('321081405', '321081', '捺山茶场', '1', '321081405', null, '3', '1'),
('321081406', '321081', '蚕桑场', '1', '321081406', null, '3', '1'),
('321081450', '321081', '滨江', '1', '321081450', null, '3', '1'),
('321081451', '321081', '十二圩', '1', '321081451', null, '3', '1'),
('321084100', '321084', '高邮镇', '1', '321084100', null, '3', '1'),
('321084101', '321084', '龙虬镇', '1', '321084101', null, '3', '1'),
('321084102', '321084', '马棚镇', '1', '321084102', null, '3', '1'),
('321084103', '321084', '车逻镇', '1', '321084103', null, '3', '1'),
('321084104', '321084', '八桥镇', '1', '321084104', null, '3', '1'),
('321084105', '321084', '汉留镇', '1', '321084105', null, '3', '1'),
('321084106', '321084', '汤庄镇', '1', '321084106', null, '3', '1'),
('321084107', '321084', '卸甲镇', '1', '321084107', null, '3', '1'),
('321084108', '321084', '三垛镇', '1', '321084108', null, '3', '1'),
('321084109', '321084', '甘垛镇', '1', '321084109', null, '3', '1'),
('321084110', '321084', '司徒镇', '1', '321084110', null, '3', '1'),
('321084111', '321084', '横泾镇', '1', '321084111', null, '3', '1'),
('321084112', '321084', '界首镇', '1', '321084112', null, '3', '1'),
('321084113', '321084', '周山镇', '1', '321084113', null, '3', '1'),
('321084114', '321084', '周巷镇', '1', '321084114', null, '3', '1'),
('321084115', '321084', '临泽镇', '1', '321084115', null, '3', '1'),
('321084116', '321084', '送桥镇', '1', '321084116', null, '3', '1'),
('321084117', '321084', '郭集镇', '1', '321084117', null, '3', '1'),
('321084118', '321084', '天山镇', '1', '321084118', null, '3', '1'),
('321084200', '321084', '菱塘回族乡', '1', '321084200', null, '3', '1'),
('321084401', '321084', '鸭业园区', '1', '321084401', null, '3', '1'),
('321084406', '321084', '经济开发区', '1', '321084406', null, '3', '1'),
('321088100', '321088', '仙女镇', '1', '321088100', null, '3', '1'),
('321088101', '321088', '小纪镇', '1', '321088101', null, '3', '1'),
('321088103', '321088', '武坚镇', '1', '321088103', null, '3', '1'),
('321088106', '321088', '樊川镇', '1', '321088106', null, '3', '1'),
('321088108', '321088', '真武镇', '1', '321088108', null, '3', '1'),
('321088109', '321088', '宜陵镇', '1', '321088109', null, '3', '1'),
('321088110', '321088', '丁沟镇', '1', '321088110', null, '3', '1'),
('321088112', '321088', '郭村镇', '1', '321088112', null, '3', '1'),
('321088114', '321088', '邵伯镇', '1', '321088114', null, '3', '1'),
('321088116', '321088', '丁伙镇', '1', '321088116', null, '3', '1'),
('321088118', '321088', '大桥镇', '1', '321088118', null, '3', '1'),
('321088119', '321088', '吴桥镇', '1', '321088119', null, '3', '1'),
('321088120', '321088', '浦头镇', '1', '321088120', null, '3', '1'),
('321102001', '321102', '正东路街道', '1', '321102001', null, '3', '1'),
('321102002', '321102', '健康路街道', '1', '321102002', null, '3', '1'),
('321102003', '321102', '大市口街道', '1', '321102003', null, '3', '1'),
('321102004', '321102', '四牌楼街道', '1', '321102004', null, '3', '1'),
('321102050', '321102', '丁卯街道', '1', '321102050', null, '3', '1'),
('321102051', '321102', '大港街道', '1', '321102051', null, '3', '1'),
('321102100', '321102', '象山镇', '1', '321102100', null, '3', '1'),
('321102101', '321102', '谏壁镇', '1', '321102101', null, '3', '1'),
('321102150', '321102', '姚桥镇', '1', '321102150', null, '3', '1'),
('321102151', '321102', '大路镇', '1', '321102151', null, '3', '1'),
('321102152', '321102', '丁岗镇', '1', '321102152', null, '3', '1'),
('321102400', '321102', '京口科技工业园', '1', '321102400', null, '3', '1'),
('321102401', '321102', '江苏省共青团农场', '1', '321102401', null, '3', '1'),
('321111001', '321111', '宝塔路街道', '1', '321111001', null, '3', '1'),
('321111002', '321111', '和平路街道', '1', '321111002', null, '3', '1'),
('321111003', '321111', '金山街道', '1', '321111003', null, '3', '1'),
('321111004', '321111', '七里甸街道', '1', '321111004', null, '3', '1'),
('321111100', '321111', '蒋乔镇', '1', '321111100', null, '3', '1'),
('321111400', '321111', '民营经济管理委员会', '1', '321111400', null, '3', '1'),
('321111401', '321111', '润州工业园区', '1', '321111401', null, '3', '1'),
('321112100', '321112', '高桥镇', '1', '321112100', null, '3', '1'),
('321112101', '321112', '辛丰镇', '1', '321112101', null, '3', '1'),
('321112102', '321112', '谷阳镇', '1', '321112102', null, '3', '1'),
('321112103', '321112', '上党镇', '1', '321112103', null, '3', '1'),
('321112104', '321112', '宝堰镇', '1', '321112104', null, '3', '1'),
('321112105', '321112', '高资镇', '1', '321112105', null, '3', '1'),
('321112106', '321112', '世业镇', '1', '321112106', null, '3', '1'),
('321112400', '321112', '丹徒区长山林场', '1', '321112400', null, '3', '1'),
('321181100', '321181', '司徒镇', '1', '321181100', null, '3', '1'),
('321181101', '321181', '延陵镇', '1', '321181101', null, '3', '1'),
('321181102', '321181', '珥陵镇', '1', '321181102', null, '3', '1'),
('321181103', '321181', '导墅镇', '1', '321181103', null, '3', '1'),
('321181104', '321181', '皇塘镇', '1', '321181104', null, '3', '1'),
('321181105', '321181', '吕城镇', '1', '321181105', null, '3', '1'),
('321181106', '321181', '陵口镇', '1', '321181106', null, '3', '1'),
('321181107', '321181', '访仙镇', '1', '321181107', null, '3', '1'),
('321181108', '321181', '界牌镇', '1', '321181108', null, '3', '1'),
('321181109', '321181', '新桥镇', '1', '321181109', null, '3', '1'),
('321181110', '321181', '后巷镇', '1', '321181110', null, '3', '1'),
('321181111', '321181', '埤城镇', '1', '321181111', null, '3', '1'),
('321181112', '321181', '云阳镇', '1', '321181112', null, '3', '1'),
('321181400', '321181', '丹阳经济技术开发区', '1', '321181400', null, '3', '1'),
('321181401', '321181', '丹阳林场', '1', '321181401', null, '3', '1'),
('321181402', '321181', '茶叶实验场', '1', '321181402', null, '3', '1'),
('321181403', '321181', '江苏省练湖农场', '1', '321181403', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('321182100', '321182', '三茅镇', '1', '321182100', null, '3', '1'),
('321182101', '321182', '新坝镇', '1', '321182101', null, '3', '1'),
('321182103', '321182', '油坊镇', '1', '321182103', null, '3', '1'),
('321182104', '321182', '八桥镇', '1', '321182104', null, '3', '1'),
('321182105', '321182', '西来桥镇', '1', '321182105', null, '3', '1'),
('321182400', '321182', '经济开发区', '1', '321182400', null, '3', '1'),
('321182401', '321182', '扬中市良种繁育场', '1', '321182401', null, '3', '1'),
('321182402', '321182', '扬中市种猪场', '1', '321182402', null, '3', '1'),
('321182403', '321182', '扬中市渔业社', '1', '321182403', null, '3', '1'),
('321182404', '321182', '雷公岛水产养殖场', '1', '321182404', null, '3', '1'),
('321182405', '321182', '扬中市西沙芦柳管理所', '1', '321182405', null, '3', '1'),
('321183100', '321183', '华阳镇', '1', '321183100', null, '3', '1'),
('321183101', '321183', '黄梅镇', '1', '321183101', null, '3', '1'),
('321183102', '321183', '下蜀镇', '1', '321183102', null, '3', '1'),
('321183103', '321183', '白兔镇', '1', '321183103', null, '3', '1'),
('321183104', '321183', '边城镇', '1', '321183104', null, '3', '1'),
('321183105', '321183', '茅山镇', '1', '321183105', null, '3', '1'),
('321183106', '321183', '后白镇', '1', '321183106', null, '3', '1'),
('321183107', '321183', '郭庄镇', '1', '321183107', null, '3', '1'),
('321183108', '321183', '天王镇', '1', '321183108', null, '3', '1'),
('321183109', '321183', '宝华镇', '1', '321183109', null, '3', '1'),
('321183400', '321183', '开发区', '1', '321183400', null, '3', '1'),
('321183401', '321183', '句容市东山良种场', '1', '321183401', null, '3', '1'),
('321183402', '321183', '句容市棉花原种场', '1', '321183402', null, '3', '1'),
('321183403', '321183', '句容市下蜀茶场', '1', '321183403', null, '3', '1'),
('321183404', '321183', '句容市林场', '1', '321183404', null, '3', '1'),
('321183405', '321183', '句容市赵庄林苗场', '1', '321183405', null, '3', '1'),
('321183406', '321183', '句容市九华茶场', '1', '321183406', null, '3', '1'),
('321183407', '321183', '句容市东进林场', '1', '321183407', null, '3', '1'),
('321183408', '321183', '句容市茅山茶场', '1', '321183408', null, '3', '1'),
('321183409', '321183', '句容市张庙茶场', '1', '321183409', null, '3', '1'),
('321183410', '321183', '句容市高庙茶场', '1', '321183410', null, '3', '1'),
('321183411', '321183', '句容市浮山果园', '1', '321183411', null, '3', '1'),
('321183412', '321183', '句容市方山茶场', '1', '321183412', null, '3', '1'),
('321183413', '321183', '句容市磨盘山林场', '1', '321183413', null, '3', '1'),
('321183414', '321183', '句容市后白良种场', '1', '321183414', null, '3', '1'),
('321183415', '321183', '句容市二圣种猪场', '1', '321183415', null, '3', '1'),
('321183416', '321183', '句容监狱', '1', '321183416', null, '3', '1'),
('321183417', '321183', '江苏省第一少年管教所', '1', '321183417', null, '3', '1'),
('321183418', '321183', '江苏省第二少年管教所', '1', '321183418', null, '3', '1'),
('321183428', '321183', '句东农场', '1', '321183428', null, '3', '1'),
('321202001', '321202', '城东街道', '1', '321202001', null, '3', '1'),
('321202002', '321202', '城西街道', '1', '321202002', null, '3', '1'),
('321202003', '321202', '城南街道', '1', '321202003', null, '3', '1'),
('321202004', '321202', '城中街道', '1', '321202004', null, '3', '1'),
('321202005', '321202', '城北街道', '1', '321202005', null, '3', '1'),
('321202006', '321202', '泰山街道', '1', '321202006', null, '3', '1'),
('321202007', '321202', '京泰路街道', '1', '321202007', null, '3', '1'),
('321202008', '321202', '凤凰路街道', '1', '321202008', null, '3', '1'),
('321202050', '321202', '农业开发区街道', '1', '321202050', null, '3', '1'),
('321202100', '321202', '九龙镇', '1', '321202100', null, '3', '1'),
('321202150', '321202', '寺巷镇', '1', '321202150', null, '3', '1'),
('321202402', '321202', '林场', '1', '321202402', null, '3', '1'),
('321202403', '321202', '水产养殖场', '1', '321202403', null, '3', '1'),
('321202404', '321202', '畜牧养殖试验场', '1', '321202404', null, '3', '1'),
('321202405', '321202', '迎春果场', '1', '321202405', null, '3', '1'),
('321202406', '321202', '海陵工业园区', '1', '321202406', null, '3', '1'),
('321203001', '321203', '口岸街道', '1', '321203001', null, '3', '1'),
('321203002', '321203', '刁铺街道', '1', '321203002', null, '3', '1'),
('321203003', '321203', '许庄街道', '1', '321203003', null, '3', '1'),
('321203100', '321203', '永安洲镇', '1', '321203100', null, '3', '1'),
('321203101', '321203', '白马镇', '1', '321203101', null, '3', '1'),
('321203102', '321203', '野徐镇', '1', '321203102', null, '3', '1'),
('321203450', '321203', '滨江工业园', '1', '321203450', null, '3', '1'),
('321281100', '321281', '戴窑镇', '1', '321281100', null, '3', '1'),
('321281101', '321281', '合陈镇', '1', '321281101', null, '3', '1'),
('321281102', '321281', '永丰镇', '1', '321281102', null, '3', '1'),
('321281103', '321281', '新垛镇', '1', '321281103', null, '3', '1'),
('321281104', '321281', '安丰镇', '1', '321281104', null, '3', '1'),
('321281105', '321281', '海南镇', '1', '321281105', null, '3', '1'),
('321281106', '321281', '钓鱼镇', '1', '321281106', null, '3', '1'),
('321281107', '321281', '大邹镇', '1', '321281107', null, '3', '1'),
('321281108', '321281', '沙沟镇', '1', '321281108', null, '3', '1'),
('321281109', '321281', '中堡镇', '1', '321281109', null, '3', '1'),
('321281110', '321281', '李中镇', '1', '321281110', null, '3', '1'),
('321281111', '321281', '西郊镇', '1', '321281111', null, '3', '1'),
('321281112', '321281', '临城镇', '1', '321281112', null, '3', '1'),
('321281113', '321281', '垛田镇', '1', '321281113', null, '3', '1'),
('321281114', '321281', '竹泓镇', '1', '321281114', null, '3', '1'),
('321281115', '321281', '沈沦镇', '1', '321281115', null, '3', '1'),
('321281116', '321281', '大垛镇', '1', '321281116', null, '3', '1'),
('321281117', '321281', '荻垛镇', '1', '321281117', null, '3', '1'),
('321281118', '321281', '陶庄镇', '1', '321281118', null, '3', '1'),
('321281119', '321281', '昌荣镇', '1', '321281119', null, '3', '1'),
('321281120', '321281', '茅山镇', '1', '321281120', null, '3', '1'),
('321281121', '321281', '周庄镇', '1', '321281121', null, '3', '1'),
('321281122', '321281', '陈堡镇', '1', '321281122', null, '3', '1'),
('321281123', '321281', '戴南镇', '1', '321281123', null, '3', '1'),
('321281124', '321281', '张郭镇', '1', '321281124', null, '3', '1'),
('321281125', '321281', '昭阳镇', '1', '321281125', null, '3', '1'),
('321281126', '321281', '大营镇', '1', '321281126', null, '3', '1'),
('321281127', '321281', '下圩镇', '1', '321281127', null, '3', '1'),
('321281128', '321281', '城东镇', '1', '321281128', null, '3', '1'),
('321281200', '321281', '老圩乡', '1', '321281200', null, '3', '1'),
('321281201', '321281', '周奋乡', '1', '321281201', null, '3', '1'),
('321281202', '321281', '缸顾乡', '1', '321281202', null, '3', '1'),
('321281203', '321281', '西鲍乡', '1', '321281203', null, '3', '1'),
('321281204', '321281', '林湖乡', '1', '321281204', null, '3', '1'),
('321281450', '321281', '开发区', '1', '321281450', null, '3', '1'),
('321281451', '321281', '良种场', '1', '321281451', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('321282100', '321282', '靖城镇', '1', '321282100', null, '3', '1'),
('321282101', '321282', '新桥镇', '1', '321282101', null, '3', '1'),
('321282102', '321282', '东兴镇', '1', '321282102', null, '3', '1'),
('321282103', '321282', '斜桥镇', '1', '321282103', null, '3', '1'),
('321282104', '321282', '西来镇', '1', '321282104', null, '3', '1'),
('321282105', '321282', '季市镇', '1', '321282105', null, '3', '1'),
('321282106', '321282', '孤山镇', '1', '321282106', null, '3', '1'),
('321282107', '321282', '红光镇', '1', '321282107', null, '3', '1'),
('321282108', '321282', '生祠镇', '1', '321282108', null, '3', '1'),
('321282109', '321282', '马桥镇', '1', '321282109', null, '3', '1'),
('321282401', '321282', '城南', '1', '321282401', null, '3', '1'),
('321282402', '321282', '新港园区', '1', '321282402', null, '3', '1'),
('321282403', '321282', '城北园区', '1', '321282403', null, '3', '1'),
('321282404', '321282', '江阴园区', '1', '321282404', null, '3', '1'),
('321282405', '321282', '渔业公司', '1', '321282405', null, '3', '1'),
('321283100', '321283', '黄桥镇', '1', '321283100', null, '3', '1'),
('321283101', '321283', '分界镇', '1', '321283101', null, '3', '1'),
('321283102', '321283', '古溪镇', '1', '321283102', null, '3', '1'),
('321283103', '321283', '横垛镇', '1', '321283103', null, '3', '1'),
('321283104', '321283', '元竹镇', '1', '321283104', null, '3', '1'),
('321283105', '321283', '珊瑚镇', '1', '321283105', null, '3', '1'),
('321283106', '321283', '广陵镇', '1', '321283106', null, '3', '1'),
('321283107', '321283', '南沙镇', '1', '321283107', null, '3', '1'),
('321283108', '321283', '曲霞镇', '1', '321283108', null, '3', '1'),
('321283109', '321283', '张桥镇', '1', '321283109', null, '3', '1'),
('321283110', '321283', '溪桥镇', '1', '321283110', null, '3', '1'),
('321283111', '321283', '刘陈镇', '1', '321283111', null, '3', '1'),
('321283112', '321283', '河失镇', '1', '321283112', null, '3', '1'),
('321283113', '321283', '新街镇', '1', '321283113', null, '3', '1'),
('321283114', '321283', '姚王镇', '1', '321283114', null, '3', '1'),
('321283115', '321283', '宣堡镇', '1', '321283115', null, '3', '1'),
('321283116', '321283', '胡庄镇', '1', '321283116', null, '3', '1'),
('321283117', '321283', '马甸镇', '1', '321283117', null, '3', '1'),
('321283118', '321283', '泰兴镇', '1', '321283118', null, '3', '1'),
('321283119', '321283', '七圩镇', '1', '321283119', null, '3', '1'),
('321283120', '321283', '蒋华镇', '1', '321283120', null, '3', '1'),
('321283121', '321283', '大生镇', '1', '321283121', null, '3', '1'),
('321283122', '321283', '过船镇', '1', '321283122', null, '3', '1'),
('321283200', '321283', '根思乡', '1', '321283200', null, '3', '1'),
('321283400', '321283', '开发区虚拟镇', '1', '321283400', null, '3', '1'),
('321283401', '321283', '泰兴市农科所', '1', '321283401', null, '3', '1'),
('321284100', '321284', '姜堰镇', '1', '321284100', null, '3', '1'),
('321284101', '321284', '溱潼镇', '1', '321284101', null, '3', '1'),
('321284102', '321284', '蒋垛镇', '1', '321284102', null, '3', '1'),
('321284103', '321284', '顾高镇', '1', '321284103', null, '3', '1'),
('321284104', '321284', '大伦镇', '1', '321284104', null, '3', '1'),
('321284105', '321284', '张甸镇', '1', '321284105', null, '3', '1'),
('321284106', '321284', '大泗镇', '1', '321284106', null, '3', '1'),
('321284107', '321284', '梁徐镇', '1', '321284107', null, '3', '1'),
('321284108', '321284', '苏陈镇', '1', '321284108', null, '3', '1'),
('321284109', '321284', '桥头镇', '1', '321284109', null, '3', '1'),
('321284110', '321284', '淤溪镇', '1', '321284110', null, '3', '1'),
('321284111', '321284', '白米镇', '1', '321284111', null, '3', '1'),
('321284112', '321284', '娄庄镇', '1', '321284112', null, '3', '1'),
('321284113', '321284', '沈高镇', '1', '321284113', null, '3', '1'),
('321284114', '321284', '兴泰镇', '1', '321284114', null, '3', '1'),
('321284115', '321284', '俞垛镇', '1', '321284115', null, '3', '1'),
('321284116', '321284', '华港镇', '1', '321284116', null, '3', '1'),
('321284117', '321284', '罡杨镇', '1', '321284117', null, '3', '1'),
('321284400', '321284', '开发区', '1', '321284400', null, '3', '1'),
('321284401', '321284', '溱湖风景区', '1', '321284401', null, '3', '1'),
('321284403', '321284', '林场', '1', '321284403', null, '3', '1'),
('321284404', '321284', '种猪场', '1', '321284404', null, '3', '1'),
('321284405', '321284', '林业站', '1', '321284405', null, '3', '1'),
('321284406', '321284', '渔业社', '1', '321284406', null, '3', '1'),
('321302001', '321302', '幸福街道', '1', '321302001', null, '3', '1'),
('321302002', '321302', '项里街道', '1', '321302002', null, '3', '1'),
('321302003', '321302', '河滨街道', '1', '321302003', null, '3', '1'),
('321302004', '321302', '古城街道', '1', '321302004', null, '3', '1'),
('321302100', '321302', '双庄镇', '1', '321302100', null, '3', '1'),
('321302101', '321302', '耿车镇', '1', '321302101', null, '3', '1'),
('321302102', '321302', '埠子镇', '1', '321302102', null, '3', '1'),
('321302103', '321302', '龙河镇', '1', '321302103', null, '3', '1'),
('321302104', '321302', '洋北镇', '1', '321302104', null, '3', '1'),
('321302105', '321302', '仓集镇', '1', '321302105', null, '3', '1'),
('321302106', '321302', '洋河镇', '1', '321302106', null, '3', '1'),
('321302107', '321302', '中扬镇', '1', '321302107', null, '3', '1'),
('321302108', '321302', '郑楼镇', '1', '321302108', null, '3', '1'),
('321302109', '321302', '陈集镇', '1', '321302109', null, '3', '1'),
('321302201', '321302', '罗圩乡', '1', '321302201', null, '3', '1'),
('321302202', '321302', '南蔡乡', '1', '321302202', null, '3', '1'),
('321302203', '321302', '屠园乡', '1', '321302203', null, '3', '1'),
('321302350', '321302', '三棵树乡', '1', '321302350', null, '3', '1'),
('321311100', '321311', '顺河镇', '1', '321311100', null, '3', '1'),
('321311101', '321311', '晓店镇', '1', '321311101', null, '3', '1'),
('321311102', '321311', '蔡集镇', '1', '321311102', null, '3', '1'),
('321311103', '321311', '王官集镇', '1', '321311103', null, '3', '1'),
('321311104', '321311', '皂河镇', '1', '321311104', null, '3', '1'),
('321311105', '321311', '仰化镇', '1', '321311105', null, '3', '1'),
('321311106', '321311', '大兴镇', '1', '321311106', null, '3', '1'),
('321311107', '321311', '丁嘴镇', '1', '321311107', null, '3', '1'),
('321311108', '321311', '来龙镇', '1', '321311108', null, '3', '1'),
('321311109', '321311', '黄墩镇', '1', '321311109', null, '3', '1'),
('321311110', '321311', '陆集镇', '1', '321311110', null, '3', '1'),
('321311111', '321311', '关庙镇', '1', '321311111', null, '3', '1'),
('321311112', '321311', '侍岭镇', '1', '321311112', null, '3', '1'),
('321311113', '321311', '新庄镇', '1', '321311113', null, '3', '1'),
('321311200', '321311', '井头乡', '1', '321311200', null, '3', '1'),
('321311201', '321311', '曹集乡', '1', '321311201', null, '3', '1'),
('321311202', '321311', '保安乡', '1', '321311202', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('321311500', '321311', '嶂山林场', '1', '321311500', null, '3', '1'),
('321322100', '321322', '沭城镇', '1', '321322100', null, '3', '1'),
('321322101', '321322', '陇集镇', '1', '321322101', null, '3', '1'),
('321322102', '321322', '胡集镇', '1', '321322102', null, '3', '1'),
('321322103', '321322', '钱集镇', '1', '321322103', null, '3', '1'),
('321322104', '321322', '塘沟镇', '1', '321322104', null, '3', '1'),
('321322105', '321322', '马厂镇', '1', '321322105', null, '3', '1'),
('321322106', '321322', '沂涛镇', '1', '321322106', null, '3', '1'),
('321322107', '321322', '庙头镇', '1', '321322107', null, '3', '1'),
('321322108', '321322', '韩山镇', '1', '321322108', null, '3', '1'),
('321322109', '321322', '华冲镇', '1', '321322109', null, '3', '1'),
('321322110', '321322', '桑墟镇', '1', '321322110', null, '3', '1'),
('321322111', '321322', '悦来镇', '1', '321322111', null, '3', '1'),
('321322112', '321322', '刘集镇', '1', '321322112', null, '3', '1'),
('321322114', '321322', '李恒镇', '1', '321322114', null, '3', '1'),
('321322115', '321322', '扎下镇', '1', '321322115', null, '3', '1'),
('321322116', '321322', '颜集镇', '1', '321322116', null, '3', '1'),
('321322117', '321322', '潼阳镇', '1', '321322117', null, '3', '1'),
('321322118', '321322', '龙庙镇', '1', '321322118', null, '3', '1'),
('321322119', '321322', '高墟镇', '1', '321322119', null, '3', '1'),
('321322120', '321322', '耿圩镇', '1', '321322120', null, '3', '1'),
('321322122', '321322', '汤涧镇', '1', '321322122', null, '3', '1'),
('321322124', '321322', '新河镇', '1', '321322124', null, '3', '1'),
('321322125', '321322', '贤官镇', '1', '321322125', null, '3', '1'),
('321322126', '321322', '吴集镇', '1', '321322126', null, '3', '1'),
('321322127', '321322', '湖东镇', '1', '321322127', null, '3', '1'),
('321322128', '321322', '青伊湖镇', '1', '321322128', null, '3', '1'),
('321322200', '321322', '北丁集乡', '1', '321322200', null, '3', '1'),
('321322201', '321322', '周集乡', '1', '321322201', null, '3', '1'),
('321322202', '321322', '东小店乡', '1', '321322202', null, '3', '1'),
('321322203', '321322', '张圩乡', '1', '321322203', null, '3', '1'),
('321322204', '321322', '茆圩乡', '1', '321322204', null, '3', '1'),
('321322205', '321322', '西圩乡', '1', '321322205', null, '3', '1'),
('321322206', '321322', '万匹乡', '1', '321322206', null, '3', '1'),
('321322207', '321322', '官墩乡', '1', '321322207', null, '3', '1'),
('321322400', '321322', '青伊湖农场', '1', '321322400', null, '3', '1'),
('321323100', '321323', '众兴镇', '1', '321323100', null, '3', '1'),
('321323101', '321323', '爱园镇', '1', '321323101', null, '3', '1'),
('321323102', '321323', '王集镇', '1', '321323102', null, '3', '1'),
('321323103', '321323', '裴圩镇', '1', '321323103', null, '3', '1'),
('321323104', '321323', '新袁镇', '1', '321323104', null, '3', '1'),
('321323105', '321323', '李口镇', '1', '321323105', null, '3', '1'),
('321323106', '321323', '临河镇', '1', '321323106', null, '3', '1'),
('321323107', '321323', '穿城镇', '1', '321323107', null, '3', '1'),
('321323108', '321323', '张家圩镇', '1', '321323108', null, '3', '1'),
('321323109', '321323', '高渡镇', '1', '321323109', null, '3', '1'),
('321323110', '321323', '卢集镇', '1', '321323110', null, '3', '1'),
('321323200', '321323', '庄圩乡', '1', '321323200', null, '3', '1'),
('321323201', '321323', '里仁乡', '1', '321323201', null, '3', '1'),
('321323202', '321323', '三庄乡', '1', '321323202', null, '3', '1'),
('321323203', '321323', '南刘集乡', '1', '321323203', null, '3', '1'),
('321323204', '321323', '八集乡', '1', '321323204', null, '3', '1'),
('321323400', '321323', '泗阳农场', '1', '321323400', null, '3', '1'),
('321323401', '321323', '棉花原种场', '1', '321323401', null, '3', '1'),
('321324100', '321324', '青阳镇', '1', '321324100', null, '3', '1'),
('321324101', '321324', '双沟镇', '1', '321324101', null, '3', '1'),
('321324102', '321324', '上塘镇', '1', '321324102', null, '3', '1'),
('321324103', '321324', '魏营镇', '1', '321324103', null, '3', '1'),
('321324104', '321324', '临淮镇', '1', '321324104', null, '3', '1'),
('321324105', '321324', '半城镇', '1', '321324105', null, '3', '1'),
('321324106', '321324', '孙园镇', '1', '321324106', null, '3', '1'),
('321324107', '321324', '梅花镇', '1', '321324107', null, '3', '1'),
('321324108', '321324', '归仁镇', '1', '321324108', null, '3', '1'),
('321324109', '321324', '金锁镇', '1', '321324109', null, '3', '1'),
('321324110', '321324', '朱湖镇', '1', '321324110', null, '3', '1'),
('321324111', '321324', '界集镇', '1', '321324111', null, '3', '1'),
('321324112', '321324', '太平镇', '1', '321324112', null, '3', '1'),
('321324113', '321324', '龙集镇', '1', '321324113', null, '3', '1'),
('321324200', '321324', '四河乡', '1', '321324200', null, '3', '1'),
('321324201', '321324', '峰山乡', '1', '321324201', null, '3', '1'),
('321324202', '321324', '天岗湖乡', '1', '321324202', null, '3', '1'),
('321324203', '321324', '车门乡', '1', '321324203', null, '3', '1'),
('321324204', '321324', '瑶沟乡', '1', '321324204', null, '3', '1'),
('321324205', '321324', '石集乡', '1', '321324205', null, '3', '1'),
('321324206', '321324', '城头乡', '1', '321324206', null, '3', '1'),
('321324207', '321324', '陈圩乡', '1', '321324207', null, '3', '1'),
('321324208', '321324', '曹庙乡', '1', '321324208', null, '3', '1'),
('321324400', '321324', '五里江农场', '1', '321324400', null, '3', '1'),
('321324401', '321324', '洪泽湖农场', '1', '321324401', null, '3', '1'),
('330102001', '330102', '清波街道', '1', '330102001', null, '3', '1'),
('330102003', '330102', '湖滨街道', '1', '330102003', null, '3', '1'),
('330102004', '330102', '小营街道', '1', '330102004', null, '3', '1'),
('330102008', '330102', '南星街道', '1', '330102008', null, '3', '1'),
('330102009', '330102', '紫阳街道', '1', '330102009', null, '3', '1'),
('330102010', '330102', '望江街道', '1', '330102010', null, '3', '1'),
('330103001', '330103', '长庆街道', '1', '330103001', null, '3', '1'),
('330103002', '330103', '武林街道', '1', '330103002', null, '3', '1'),
('330103003', '330103', '天水街道', '1', '330103003', null, '3', '1'),
('330103005', '330103', '潮鸣街道', '1', '330103005', null, '3', '1'),
('330103006', '330103', '朝晖街道', '1', '330103006', null, '3', '1'),
('330103007', '330103', '文晖街道', '1', '330103007', null, '3', '1'),
('330103008', '330103', '东新街道', '1', '330103008', null, '3', '1'),
('330103009', '330103', '石桥街道', '1', '330103009', null, '3', '1'),
('330104005', '330104', '凯旋街道', '1', '330104005', null, '3', '1'),
('330104006', '330104', '采荷街道', '1', '330104006', null, '3', '1'),
('330104007', '330104', '闸弄口街道', '1', '330104007', null, '3', '1'),
('330104008', '330104', '四季青街道', '1', '330104008', null, '3', '1'),
('330104009', '330104', '白杨街道', '1', '330104009', null, '3', '1'),
('330104010', '330104', '下沙街道', '1', '330104010', null, '3', '1'),
('330104102', '330104', '彭埠镇', '1', '330104102', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('330104103', '330104', '笕桥镇', '1', '330104103', null, '3', '1'),
('330104104', '330104', '丁桥镇', '1', '330104104', null, '3', '1'),
('330104105', '330104', '九堡镇', '1', '330104105', null, '3', '1'),
('330105001', '330105', '米市巷街道', '1', '330105001', null, '3', '1'),
('330105002', '330105', '湖墅街道', '1', '330105002', null, '3', '1'),
('330105003', '330105', '小河街道', '1', '330105003', null, '3', '1'),
('330105004', '330105', '和睦街道', '1', '330105004', null, '3', '1'),
('330105005', '330105', '拱宸桥街道', '1', '330105005', null, '3', '1'),
('330105007', '330105', '大关街道', '1', '330105007', null, '3', '1'),
('330105008', '330105', '上塘街道', '1', '330105008', null, '3', '1'),
('330105102', '330105', '康桥镇', '1', '330105102', null, '3', '1'),
('330105103', '330105', '半山镇', '1', '330105103', null, '3', '1'),
('330105104', '330105', '祥符镇', '1', '330105104', null, '3', '1'),
('330106002', '330106', '北山街道', '1', '330106002', null, '3', '1'),
('330106003', '330106', '灵隐街道', '1', '330106003', null, '3', '1'),
('330106004', '330106', '西溪街道', '1', '330106004', null, '3', '1'),
('330106005', '330106', '翠苑街道', '1', '330106005', null, '3', '1'),
('330106006', '330106', '文新街道', '1', '330106006', null, '3', '1'),
('330106007', '330106', '古荡街道', '1', '330106007', null, '3', '1'),
('330106008', '330106', '西湖街道', '1', '330106008', null, '3', '1'),
('330106103', '330106', '留下镇', '1', '330106103', null, '3', '1'),
('330106104', '330106', '转塘镇', '1', '330106104', null, '3', '1'),
('330106105', '330106', '袁浦镇', '1', '330106105', null, '3', '1'),
('330106106', '330106', '龙坞镇', '1', '330106106', null, '3', '1'),
('330106109', '330106', '三墩镇', '1', '330106109', null, '3', '1'),
('330106202', '330106', '周浦乡', '1', '330106202', null, '3', '1'),
('330106203', '330106', '蒋村乡', '1', '330106203', null, '3', '1'),
('330108001', '330108', '西兴街道', '1', '330108001', null, '3', '1'),
('330108002', '330108', '长河街道', '1', '330108002', null, '3', '1'),
('330108003', '330108', '浦沿街道', '1', '330108003', null, '3', '1'),
('330109001', '330109', '城厢街道', '1', '330109001', null, '3', '1'),
('330109002', '330109', '北干街道', '1', '330109002', null, '3', '1'),
('330109003', '330109', '蜀山街道', '1', '330109003', null, '3', '1'),
('330109004', '330109', '新塘街道', '1', '330109004', null, '3', '1'),
('330109100', '330109', '楼塔镇', '1', '330109100', null, '3', '1'),
('330109101', '330109', '河上镇', '1', '330109101', null, '3', '1'),
('330109102', '330109', '戴村镇', '1', '330109102', null, '3', '1'),
('330109103', '330109', '浦阳镇', '1', '330109103', null, '3', '1'),
('330109104', '330109', '进化镇', '1', '330109104', null, '3', '1'),
('330109105', '330109', '临浦镇', '1', '330109105', null, '3', '1'),
('330109106', '330109', '义桥镇', '1', '330109106', null, '3', '1'),
('330109107', '330109', '所前镇', '1', '330109107', null, '3', '1'),
('330109108', '330109', '衙前镇', '1', '330109108', null, '3', '1'),
('330109109', '330109', '闻堰镇', '1', '330109109', null, '3', '1'),
('330109110', '330109', '宁围镇', '1', '330109110', null, '3', '1'),
('330109111', '330109', '新街镇', '1', '330109111', null, '3', '1'),
('330109112', '330109', '坎山镇', '1', '330109112', null, '3', '1'),
('330109113', '330109', '瓜沥镇', '1', '330109113', null, '3', '1'),
('330109114', '330109', '党山镇', '1', '330109114', null, '3', '1'),
('330109115', '330109', '益农镇', '1', '330109115', null, '3', '1'),
('330109116', '330109', '靖江镇', '1', '330109116', null, '3', '1'),
('330109117', '330109', '南阳镇', '1', '330109117', null, '3', '1'),
('330109118', '330109', '义蓬镇', '1', '330109118', null, '3', '1'),
('330109119', '330109', '河庄镇', '1', '330109119', null, '3', '1'),
('330109120', '330109', '党湾镇', '1', '330109120', null, '3', '1'),
('330109121', '330109', '新湾镇', '1', '330109121', null, '3', '1'),
('330109401', '330109', '萧山经济开发区', '1', '330109401', null, '3', '1'),
('330109501', '330109', '围垦区', '1', '330109501', null, '3', '1'),
('330110001', '330110', '临平街道', '1', '330110001', null, '3', '1'),
('330110002', '330110', '南苑街道', '1', '330110002', null, '3', '1'),
('330110003', '330110', '东湖街道', '1', '330110003', null, '3', '1'),
('330110004', '330110', '星桥街道', '1', '330110004', null, '3', '1'),
('330110100', '330110', '乔司镇', '1', '330110100', null, '3', '1'),
('330110101', '330110', '运河镇', '1', '330110101', null, '3', '1'),
('330110102', '330110', '塘栖镇', '1', '330110102', null, '3', '1'),
('330110103', '330110', '崇贤镇', '1', '330110103', null, '3', '1'),
('330110104', '330110', '仁和镇', '1', '330110104', null, '3', '1'),
('330110105', '330110', '良渚镇', '1', '330110105', null, '3', '1'),
('330110106', '330110', '闲林镇', '1', '330110106', null, '3', '1'),
('330110107', '330110', '仓前镇', '1', '330110107', null, '3', '1'),
('330110108', '330110', '余杭镇', '1', '330110108', null, '3', '1'),
('330110109', '330110', '径山镇', '1', '330110109', null, '3', '1'),
('330110110', '330110', '瓶窑镇', '1', '330110110', null, '3', '1'),
('330110111', '330110', '鸬鸟镇', '1', '330110111', null, '3', '1'),
('330110112', '330110', '百丈镇', '1', '330110112', null, '3', '1'),
('330110113', '330110', '黄湖镇', '1', '330110113', null, '3', '1'),
('330110200', '330110', '中泰乡', '1', '330110200', null, '3', '1'),
('330122001', '330122', '桐君街道', '1', '330122001', null, '3', '1'),
('330122002', '330122', '旧县街道', '1', '330122002', null, '3', '1'),
('330122101', '330122', '富春江镇', '1', '330122101', null, '3', '1'),
('330122102', '330122', '横村镇', '1', '330122102', null, '3', '1'),
('330122107', '330122', '凤川镇', '1', '330122107', null, '3', '1'),
('330122109', '330122', '分水镇', '1', '330122109', null, '3', '1'),
('330122110', '330122', '瑶琳镇', '1', '330122110', null, '3', '1'),
('330122112', '330122', '百江镇', '1', '330122112', null, '3', '1'),
('330122113', '330122', '江南镇', '1', '330122113', null, '3', '1'),
('330122201', '330122', '莪山畲族自治乡', '1', '330122201', null, '3', '1'),
('330122202', '330122', '钟山乡', '1', '330122202', null, '3', '1'),
('330122204', '330122', '新合乡', '1', '330122204', null, '3', '1'),
('330122210', '330122', '合村乡', '1', '330122210', null, '3', '1'),
('330127100', '330127', '千岛湖镇', '1', '330127100', null, '3', '1'),
('330127101', '330127', '文昌镇', '1', '330127101', null, '3', '1'),
('330127102', '330127', '石林镇', '1', '330127102', null, '3', '1'),
('330127103', '330127', '临岐镇', '1', '330127103', null, '3', '1'),
('330127104', '330127', '威坪镇', '1', '330127104', null, '3', '1'),
('330127106', '330127', '姜家镇', '1', '330127106', null, '3', '1'),
('330127107', '330127', '梓桐镇', '1', '330127107', null, '3', '1'),
('330127108', '330127', '汾口镇', '1', '330127108', null, '3', '1'),
('330127109', '330127', '中洲镇', '1', '330127109', null, '3', '1'),
('330127110', '330127', '大墅镇', '1', '330127110', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('330127111', '330127', '枫树岭镇', '1', '330127111', null, '3', '1'),
('330127200', '330127', '里商乡', '1', '330127200', null, '3', '1'),
('330127201', '330127', '金峰乡', '1', '330127201', null, '3', '1'),
('330127202', '330127', '富文乡', '1', '330127202', null, '3', '1'),
('330127203', '330127', '左口乡', '1', '330127203', null, '3', '1'),
('330127205', '330127', '屏门乡', '1', '330127205', null, '3', '1'),
('330127206', '330127', '瑶山乡', '1', '330127206', null, '3', '1'),
('330127208', '330127', '王阜乡', '1', '330127208', null, '3', '1'),
('330127210', '330127', '宋村乡', '1', '330127210', null, '3', '1'),
('330127211', '330127', '鸠坑乡', '1', '330127211', null, '3', '1'),
('330127212', '330127', '浪川乡', '1', '330127212', null, '3', '1'),
('330127214', '330127', '界首乡', '1', '330127214', null, '3', '1'),
('330127216', '330127', '安阳乡', '1', '330127216', null, '3', '1'),
('330182001', '330182', '新安江街道', '1', '330182001', null, '3', '1'),
('330182002', '330182', '洋溪街道', '1', '330182002', null, '3', '1'),
('330182003', '330182', '更楼街道', '1', '330182003', null, '3', '1'),
('330182101', '330182', '莲花镇', '1', '330182101', null, '3', '1'),
('330182102', '330182', '乾潭镇', '1', '330182102', null, '3', '1'),
('330182104', '330182', '梅城镇', '1', '330182104', null, '3', '1'),
('330182105', '330182', '杨村桥镇', '1', '330182105', null, '3', '1'),
('330182106', '330182', '下涯镇', '1', '330182106', null, '3', '1'),
('330182107', '330182', '大洋镇', '1', '330182107', null, '3', '1'),
('330182108', '330182', '三都镇', '1', '330182108', null, '3', '1'),
('330182109', '330182', '寿昌镇', '1', '330182109', null, '3', '1'),
('330182110', '330182', '航头镇', '1', '330182110', null, '3', '1'),
('330182111', '330182', '大慈岩镇', '1', '330182111', null, '3', '1'),
('330182112', '330182', '大同镇', '1', '330182112', null, '3', '1'),
('330182113', '330182', '李家镇', '1', '330182113', null, '3', '1'),
('330182202', '330182', '钦堂乡', '1', '330182202', null, '3', '1'),
('330183001', '330183', '富春街道', '1', '330183001', null, '3', '1'),
('330183002', '330183', '春江街道', '1', '330183002', null, '3', '1'),
('330183003', '330183', '东洲街道', '1', '330183003', null, '3', '1'),
('330183004', '330183', '鹿山街道', '1', '330183004', null, '3', '1'),
('330183100', '330183', '万市镇', '1', '330183100', null, '3', '1'),
('330183101', '330183', '洞桥镇', '1', '330183101', null, '3', '1'),
('330183102', '330183', '新登镇', '1', '330183102', null, '3', '1'),
('330183103', '330183', '渌渚镇', '1', '330183103', null, '3', '1'),
('330183104', '330183', '胥口镇', '1', '330183104', null, '3', '1'),
('330183105', '330183', '永昌镇', '1', '330183105', null, '3', '1'),
('330183106', '330183', '大源镇', '1', '330183106', null, '3', '1'),
('330183107', '330183', '灵桥镇', '1', '330183107', null, '3', '1'),
('330183108', '330183', '里山镇', '1', '330183108', null, '3', '1'),
('330183109', '330183', '常绿镇', '1', '330183109', null, '3', '1'),
('330183110', '330183', '场口镇', '1', '330183110', null, '3', '1'),
('330183111', '330183', '常安镇', '1', '330183111', null, '3', '1'),
('330183112', '330183', '龙门镇', '1', '330183112', null, '3', '1'),
('330183113', '330183', '高桥镇', '1', '330183113', null, '3', '1'),
('330183114', '330183', '受降镇', '1', '330183114', null, '3', '1'),
('330183200', '330183', '新桐乡', '1', '330183200', null, '3', '1'),
('330183201', '330183', '上官乡', '1', '330183201', null, '3', '1'),
('330183202', '330183', '渔山乡', '1', '330183202', null, '3', '1'),
('330183204', '330183', '环山乡', '1', '330183204', null, '3', '1'),
('330183205', '330183', '湖源乡', '1', '330183205', null, '3', '1'),
('330183206', '330183', '春建乡', '1', '330183206', null, '3', '1'),
('330185001', '330185', '锦城街道', '1', '330185001', null, '3', '1'),
('330185002', '330185', '玲珑街道', '1', '330185002', null, '3', '1'),
('330185003', '330185', '青山湖街道', '1', '330185003', null, '3', '1'),
('330185004', '330185', '上甘街道', '1', '330185004', null, '3', '1'),
('330185100', '330185', '三口镇', '1', '330185100', null, '3', '1'),
('330185101', '330185', '横畈镇', '1', '330185101', null, '3', '1'),
('330185102', '330185', '高虹镇', '1', '330185102', null, '3', '1'),
('330185103', '330185', '太湖源镇', '1', '330185103', null, '3', '1'),
('330185104', '330185', '於潜镇', '1', '330185104', null, '3', '1'),
('330185105', '330185', '藻溪镇', '1', '330185105', null, '3', '1'),
('330185106', '330185', '太阳镇', '1', '330185106', null, '3', '1'),
('330185107', '330185', '潜川镇', '1', '330185107', null, '3', '1'),
('330185108', '330185', '昌化镇', '1', '330185108', null, '3', '1'),
('330185109', '330185', '河桥镇', '1', '330185109', null, '3', '1'),
('330185110', '330185', '龙岗镇', '1', '330185110', null, '3', '1'),
('330185111', '330185', '湍口镇', '1', '330185111', null, '3', '1'),
('330185112', '330185', '清凉峰镇', '1', '330185112', null, '3', '1'),
('330185113', '330185', '岛石镇', '1', '330185113', null, '3', '1'),
('330185114', '330185', '大峡谷镇', '1', '330185114', null, '3', '1'),
('330185200', '330185', '板桥乡', '1', '330185200', null, '3', '1'),
('330185201', '330185', '西天目乡', '1', '330185201', null, '3', '1'),
('330185202', '330185', '千洪乡', '1', '330185202', null, '3', '1'),
('330185203', '330185', '横路乡', '1', '330185203', null, '3', '1'),
('330185204', '330185', '乐平乡', '1', '330185204', null, '3', '1'),
('330185205', '330185', '马啸乡', '1', '330185205', null, '3', '1'),
('330185206', '330185', '新桥乡', '1', '330185206', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('330203001', '330203', '南门街道', '1', '330203001', null, '3', '1'),
('330203002', '330203', '江厦街道', '1', '330203002', null, '3', '1'),
('330203003', '330203', '西门街道', '1', '330203003', null, '3', '1'),
('330203004', '330203', '月湖街道', '1', '330203004', null, '3', '1'),
('330203005', '330203', '鼓楼街道', '1', '330203005', null, '3', '1'),
('330203006', '330203', '白云街道', '1', '330203006', null, '3', '1'),
('330203007', '330203', '段塘街道', '1', '330203007', null, '3', '1'),
('330203008', '330203', '望春街道', '1', '330203008', null, '3', '1'),
('330204001', '330204', '百丈街道', '1', '330204001', null, '3', '1'),
('330204002', '330204', '东胜街道', '1', '330204002', null, '3', '1'),
('330204003', '330204', '明楼街道', '1', '330204003', null, '3', '1'),
('330204004', '330204', '白鹤街道', '1', '330204004', null, '3', '1'),
('330204005', '330204', '东柳街道', '1', '330204005', null, '3', '1'),
('330204006', '330204', '东郊街道', '1', '330204006', null, '3', '1'),
('330204007', '330204', '福明街道', '1', '330204007', null, '3', '1'),
('330205001', '330205', '中马街道', '1', '330205001', null, '3', '1'),
('330205002', '330205', '白沙街道', '1', '330205002', null, '3', '1'),
('330205003', '330205', '孔浦街道', '1', '330205003', null, '3', '1'),
('330205004', '330205', '文教街道', '1', '330205004', null, '3', '1'),
('330205005', '330205', '甬江街道', '1', '330205005', null, '3', '1'),
('330205006', '330205', '庄桥街道', '1', '330205006', null, '3', '1'),
('330205007', '330205', '洪塘街道', '1', '330205007', null, '3', '1'),
('330205103', '330205', '慈城镇', '1', '330205103', null, '3', '1'),
('330206001', '330206', '大榭街道', '1', '330206001', null, '3', '1'),
('330206002', '330206', '新碶街道', '1', '330206002', null, '3', '1'),
('330206003', '330206', '小港街道', '1', '330206003', null, '3', '1'),
('330206004', '330206', '大碶街道', '1', '330206004', null, '3', '1'),
('330206005', '330206', '霞浦街道', '1', '330206005', null, '3', '1'),
('330206006', '330206', '柴桥街道', '1', '330206006', null, '3', '1'),
('330206105', '330206', '白峰镇', '1', '330206105', null, '3', '1'),
('330206107', '330206', '春晓镇', '1', '330206107', null, '3', '1'),
('330206201', '330206', '梅山乡', '1', '330206201', null, '3', '1'),
('330211001', '330211', '招宝山街道', '1', '330211001', null, '3', '1'),
('330211002', '330211', '蛟川街道', '1', '330211002', null, '3', '1'),
('330211003', '330211', '骆驼街道', '1', '330211003', null, '3', '1'),
('330211004', '330211', '庄市街道', '1', '330211004', null, '3', '1'),
('330211100', '330211', '澥浦镇', '1', '330211100', null, '3', '1'),
('330211101', '330211', '九龙湖镇', '1', '330211101', null, '3', '1'),
('330212001', '330212', '下应街道', '1', '330212001', null, '3', '1'),
('330212002', '330212', '钟公庙街道', '1', '330212002', null, '3', '1'),
('330212003', '330212', '石碶街道', '1', '330212003', null, '3', '1'),
('330212004', '330212', '梅墟街道', '1', '330212004', null, '3', '1'),
('330212100', '330212', '瞻岐镇', '1', '330212100', null, '3', '1'),
('330212101', '330212', '咸祥镇', '1', '330212101', null, '3', '1'),
('330212102', '330212', '塘溪镇', '1', '330212102', null, '3', '1'),
('330212103', '330212', '东钱湖镇', '1', '330212103', null, '3', '1'),
('330212104', '330212', '东吴镇', '1', '330212104', null, '3', '1'),
('330212105', '330212', '五乡镇', '1', '330212105', null, '3', '1'),
('330212106', '330212', '邱隘镇', '1', '330212106', null, '3', '1'),
('330212108', '330212', '云龙镇', '1', '330212108', null, '3', '1'),
('330212109', '330212', '横溪镇', '1', '330212109', null, '3', '1'),
('330212110', '330212', '姜山镇', '1', '330212110', null, '3', '1'),
('330212113', '330212', '高桥镇', '1', '330212113', null, '3', '1'),
('330212114', '330212', '横街镇', '1', '330212114', null, '3', '1'),
('330212115', '330212', '集仕港镇', '1', '330212115', null, '3', '1'),
('330212116', '330212', '古林镇', '1', '330212116', null, '3', '1'),
('330212118', '330212', '洞桥镇', '1', '330212118', null, '3', '1'),
('330212119', '330212', '鄞江镇', '1', '330212119', null, '3', '1'),
('330212120', '330212', '章水镇', '1', '330212120', null, '3', '1'),
('330212200', '330212', '龙观乡', '1', '330212200', null, '3', '1'),
('330225001', '330225', '丹东街道', '1', '330225001', null, '3', '1'),
('330225002', '330225', '丹西街道', '1', '330225002', null, '3', '1'),
('330225003', '330225', '爵溪街道', '1', '330225003', null, '3', '1'),
('330225101', '330225', '石浦镇', '1', '330225101', null, '3', '1'),
('330225102', '330225', '西周镇', '1', '330225102', null, '3', '1'),
('330225103', '330225', '鹤浦镇', '1', '330225103', null, '3', '1'),
('330225104', '330225', '贤庠镇', '1', '330225104', null, '3', '1'),
('330225105', '330225', '墙头镇', '1', '330225105', null, '3', '1'),
('330225106', '330225', '泗洲头镇', '1', '330225106', null, '3', '1'),
('330225107', '330225', '定塘镇', '1', '330225107', null, '3', '1'),
('330225108', '330225', '涂茨镇', '1', '330225108', null, '3', '1'),
('330225109', '330225', '大徐镇', '1', '330225109', null, '3', '1'),
('330225110', '330225', '新桥镇', '1', '330225110', null, '3', '1'),
('330225200', '330225', '东陈乡', '1', '330225200', null, '3', '1'),
('330225201', '330225', '晓塘乡', '1', '330225201', null, '3', '1'),
('330225202', '330225', '黄避岙乡', '1', '330225202', null, '3', '1'),
('330225203', '330225', '茅洋乡', '1', '330225203', null, '3', '1'),
('330225204', '330225', '高塘岛乡', '1', '330225204', null, '3', '1'),
('330226001', '330226', '跃龙街道', '1', '330226001', null, '3', '1'),
('330226002', '330226', '桃源街道', '1', '330226002', null, '3', '1'),
('330226003', '330226', '梅林街道', '1', '330226003', null, '3', '1'),
('330226004', '330226', '桥头胡街道', '1', '330226004', null, '3', '1'),
('330226101', '330226', '长街镇', '1', '330226101', null, '3', '1'),
('330226102', '330226', '力洋镇', '1', '330226102', null, '3', '1'),
('330226104', '330226', '一市镇', '1', '330226104', null, '3', '1'),
('330226105', '330226', '岔路镇', '1', '330226105', null, '3', '1'),
('330226106', '330226', '前童镇', '1', '330226106', null, '3', '1'),
('330226107', '330226', '桑洲镇', '1', '330226107', null, '3', '1'),
('330226108', '330226', '黄坛镇', '1', '330226108', null, '3', '1'),
('330226109', '330226', '大佳何镇', '1', '330226109', null, '3', '1'),
('330226110', '330226', '强蛟镇', '1', '330226110', null, '3', '1'),
('330226111', '330226', '西店镇', '1', '330226111', null, '3', '1'),
('330226112', '330226', '深圳镇', '1', '330226112', null, '3', '1'),
('330226200', '330226', '胡陈乡', '1', '330226200', null, '3', '1'),
('330226201', '330226', '茶院乡', '1', '330226201', null, '3', '1'),
('330226202', '330226', '越溪乡', '1', '330226202', null, '3', '1'),
('330281001', '330281', '梨洲街道', '1', '330281001', null, '3', '1'),
('330281002', '330281', '凤山街道', '1', '330281002', null, '3', '1'),
('330281003', '330281', '兰江街道', '1', '330281003', null, '3', '1'),
('330281004', '330281', '阳明街道', '1', '330281004', null, '3', '1'),
('330281005', '330281', '低塘街道', '1', '330281005', null, '3', '1'),
('330281006', '330281', '朗霞街道', '1', '330281006', null, '3', '1'),
('330281100', '330281', '临山镇', '1', '330281100', null, '3', '1'),
('330281101', '330281', '黄家埠镇', '1', '330281101', null, '3', '1'),
('330281102', '330281', '小曹娥镇', '1', '330281102', null, '3', '1'),
('330281103', '330281', '泗门镇', '1', '330281103', null, '3', '1'),
('330281106', '330281', '马渚镇', '1', '330281106', null, '3', '1'),
('330281108', '330281', '牟山镇', '1', '330281108', null, '3', '1'),
('330281109', '330281', '丈亭镇', '1', '330281109', null, '3', '1'),
('330281110', '330281', '三七市镇', '1', '330281110', null, '3', '1'),
('330281111', '330281', '河姆渡镇', '1', '330281111', null, '3', '1'),
('330281112', '330281', '大隐镇', '1', '330281112', null, '3', '1'),
('330281113', '330281', '陆埠镇', '1', '330281113', null, '3', '1'),
('330281114', '330281', '梁弄镇', '1', '330281114', null, '3', '1'),
('330281115', '330281', '大岚镇', '1', '330281115', null, '3', '1'),
('330281116', '330281', '四明山镇', '1', '330281116', null, '3', '1'),
('330281201', '330281', '鹿亭乡', '1', '330281201', null, '3', '1'),
('330282001', '330282', '浒山街道', '1', '330282001', null, '3', '1'),
('330282002', '330282', '宗汉街道', '1', '330282002', null, '3', '1'),
('330282003', '330282', '坎墩街道', '1', '330282003', null, '3', '1');
INSERT INTO `wst_areas` VALUES ('330282101', '330282', '龙山镇', '1', '330282101', null, '3', '1'),
('330282102', '330282', '三北镇', '1', '330282102', null, '3', '1'),
('330282103', '330282', '范市镇', '1', '330282103', null, '3', '1'),
('330282104', '330282', '掌起镇', '1', '330282104', null, '3', '1'),
('330282107', '330282', '观海卫镇', '1', '330282107', null, '3', '1'),
('330282108', '330282', '附海镇', '1', '330282108', null, '3', '1'),
('330282109', '330282', '桥头镇', '1', '330282109', null, '3', '1'),
('330282110', '330282', '匡堰镇', '1', '330282110', null, '3', '1'),
('330282111', '330282', '逍林镇', '1', '330282111', null, '3', '1'),
('330282112', '330282', '新浦镇', '1', '330282112', null, '3', '1'),
('330282113', '330282', '胜山镇', '1', '330282113', null, '3', '1'),
('330282114', '330282', '横河镇', '1', '330282114', null, '3', '1'),
('330282116', '330282', '崇寿镇', '1', '330282116', null, '3', '1'),
('330282118', '330282', '庵东镇', '1', '330282118', null, '3', '1'),
('330282119', '330282', '天元镇', '1', '330282119', null, '3', '1'),
('330282120', '330282