SET FOREIGN_KEY_CHECKS=0;

DROP TABLE IF EXISTS `wst_goods`;
CREATE TABLE `wst_goods` (
  `goodsId` int(11) NOT NULL AUTO_INCREMENT,
  `goodsSn` varchar(20) NOT NULL,
  `goodsName` varchar(50) NOT NULL,
  `goodsImg` varchar(150) NOT NULL,
  `goodsThums` varchar(150) NOT NULL,
  `brandId` int(11) DEFAULT NULL,
  `shopId` int(11) NOT NULL,
  `marketPrice` decimal(11,2) NOT NULL DEFAULT '0.00',
  `shopPrice` decimal(11,2) NOT NULL DEFAULT '0.00',
  `goodsStock` int(11) NOT NULL DEFAULT '0',
  `saleCount` int(11) DEFAULT '0',
  `isBook` tinyint(4) NOT NULL DEFAULT '0',
  `bookQuantity` int(11) NOT NULL DEFAULT '0',
  `warnStock` int(11) NOT NULL DEFAULT '0',
  `goodsUnit` char(10) NOT NULL,
  `goodsSpec` text,
  `isSale` tinyint(4) NOT NULL DEFAULT '1',
  `isBest` tinyint(4) DEFAULT '1',
  `isHot` tinyint(4) DEFAULT '1',
  `isRecomm` tinyint(4) DEFAULT '1',
  `isNew` tinyint(4) DEFAULT '1',
  `isAdminBest` tinyint(4) DEFAULT '0',
  `isAdminRecom` tinyint(4) DEFAULT '0',
  `recommDesc` varchar(255) DEFAULT NULL,
  `goodsCatId1` int(11) NOT NULL,
  `goodsCatId2` int(11) NOT NULL,
  `goodsCatId3` int(11) NOT NULL,
  `shopCatId1` int(11) NOT NULL,
  `shopCatId2` int(11) NOT NULL,
  `goodsDesc` text NOT NULL,
  `isShopRecomm` tinyint(4) NOT NULL DEFAULT '0',
  `isIndexRecomm` tinyint(4) NOT NULL DEFAULT '0',
  `isActivityRecomm` tinyint(4) NOT NULL DEFAULT '0',
  `isInnerRecomm` tinyint(4) NOT NULL DEFAULT '0',
  `goodsStatus` tinyint(4) NOT NULL DEFAULT '0',
  `saleTime` datetime DEFAULT NULL,
  `attrCatId` int(11) DEFAULT '0',
  `goodsKeywords` varchar(200) DEFAULT NULL,
  `goodsFlag` tinyint(4) NOT NULL DEFAULT '1',
  `statusRemarks` varchar(255) DEFAULT NULL,
  `createTime` datetime NOT NULL,
  `isDistribut` int(11) DEFAULT '0',
  `commission` int(11) DEFAULT '0',
  PRIMARY KEY (`goodsId`),
  KEY `shopId` (`shopId`) USING BTREE,
  KEY `goodsStatus` (`goodsStatus`,`goodsFlag`,`isSale`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=255 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of wst_goods
-- ----------------------------
INSERT INTO `wst_goods` VALUES ('2', '0001', 'wstmall墨西哥牛油果8个 7天内发货 8个装', 'Upload/goods/2015-05/55641875b7501.jpg', 'Upload/goods/2015-05/55641875b7501.jpg', null, '4', '40.00', '36.00', '497', '0', '0', '0', '0', '组', '8粒/组（8个装）', '1', '1', '1', '1', '1', '0', '0', null, '47', '61', '76', '9', '13', '&lt;p&gt;\n	这里省略描述一万字\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150526/20150526065325_58122.jpg&quot; alt=&quot;&quot; /&gt; \n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-08 11:14:28', '0', '0'),
('3', '223655', '进口 美国新奇士Sunkist 脐橙 6粒', 'Upload/goods/2015-05/554c2c1a6a4b9.jpg', 'Upload/goods/2015-05/554c2c1a6a4b9.jpg', '0', '4', '40.00', '40.00', '300', '0', '0', '0', '0', '箱', '1箱6粒', '1', '1', '1', '1', '1', '1', '1', null, '47', '61', '72', '7', '8', '蜜柚&lt;img src=&quot;/product/wstmall/Public/plugins/kindeditor/attached/image/20150508/20150508032414_33455.jpg&quot; alt=&quot;&quot; /&gt;', '0', '0', '0', '0', '1', null, '1', '', '1', null, '2015-05-08 11:24:27', '0', '0'),
('4', '00001', '特色菜 半成品菜肴BCP-22 糖醋排条225g', 'Upload/goods/2015-05/556b10094ea52.jpg', 'Upload/goods/2015-05/556b10094ea52.jpg', '23', '4', '20.00', '13.00', '133', '0', '0', '0', '0', '盒', '225克', '1', '1', '1', '1', '1', '0', '0', null, '47', '63', '318', '9', '13', '&lt;p&gt;\n	测试商品 请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150531/20150531134405_46326.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-15 10:49:19', '0', '0'),
('5', '0003', 'wstmal鲜果蔬 越南新鲜青芒果 5斤装 好吃的', 'Upload/goods/2015-05/5563ef4681396.jpg', 'Upload/goods/2015-05/5563ef4681396.jpg', '0', '4', '55.00', '50.00', '300', '0', '0', '0', '0', '箱', '一箱为5斤', '1', '1', '1', '1', '1', '1', '0', null, '47', '61', '250', '7', '10', '&lt;span style=&quot;color:#E53333;font-size:16px;&quot;&gt;&lt;strong&gt;&amp;nbsp; 温馨提示&lt;/strong&gt;&lt;/span&gt;&lt;br /&gt;\n&lt;p&gt;\n	&lt;strong&gt;&lt;span style=&quot;font-size:16px;&quot;&gt;配送说明：为了保障生鲜水果产品的最优质量，WSTMALL所有生鲜水果均使用顺丰速运进行配送。发货重量保证足斤实量，标称重量均不含包装物的重量，但因运输途中水分蒸发等客观原因，&lt;/span&gt;&lt;/strong&gt;&lt;span style=&quot;color:#E53333;font-size:16px;&quot;&gt;&lt;strong&gt;到货重量可能有所减少，此情况敬请谅解&lt;/strong&gt;&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#E53333;font-size:16px;&quot;&gt;&lt;strong&gt;&lt;br /&gt;\n&lt;/strong&gt;&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#E53333;font-size:16px;&quot;&gt;&lt;strong&gt;&lt;img src=&quot;/product/wstmall/Upload/image/20150526/20150526035750_75003.jpg&quot; alt=&quot;&quot; /&gt;&lt;br /&gt;\n&lt;/strong&gt;&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '1', '', '1', null, '2015-05-26 11:59:39', '0', '0'),
('6', '0003', '台湾金钻凤梨2粒/组（约2.5kg-3.2kg）', 'Upload/goods/2015-05/5563f3941bd95.jpg', 'Upload/goods/2015-05/5563f3941bd95.jpg', null, '4', '95.00', '56.00', '5214', '0', '0', '0', '0', '箱', '2粒/组（约2.5kg-3.2kg）', '1', '1', '1', '1', '1', '1', '0', null, '47', '61', '76', '9', '17', '&lt;p&gt;\n	&lt;strong&gt;&lt;span style=&quot;background-color:#E53333;font-size:18px;&quot;&gt;wstmall测试商品，勿下单&lt;/span&gt;&lt;/strong&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150526/20150526041510_85357.png&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-26 12:16:25', '0', '0'),
('7', '543512', 'wstmall汇绿鲜果蔬 限量发售泰国金枕榴莲带壳', 'Upload/goods/2015-05/55641f039eb22.jpg', 'Upload/goods/2015-05/55641f039eb22.jpg', null, '4', '200.00', '150.00', '300', '0', '0', '0', '0', '组', '4-5.5斤为一组', '1', '1', '1', '1', '1', '0', '0', null, '47', '61', '72', '9', '15', '&lt;p&gt;\n	商品不是用来下单的，大家请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150526/20150526072309_74931.jpg&quot; alt=&quot;&quot; /&gt;&lt;img src=&quot;/product/wstmall/Upload/image/20150526/20150526072320_32582.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-26 15:23:25', '0', '0'),
('8', '345352', 'wstmall 进口水果 菲律宾菠萝 2只装 新鲜', 'Upload/goods/2015-05/55642c4d7b1b5.jpg', 'Upload/goods/2015-05/55642c4d7b1b5.jpg', null, '4', '345.00', '123.00', '1234234', '0', '0', '0', '0', '箱', '2只装', '1', '1', '1', '1', '1', '1', '0', null, '47', '61', '250', '9', '14', '&lt;p&gt;\n	&lt;span style=&quot;color:#666666;font-family:Arial, Verdana, 宋体;font-size:16px;background-color:#F5F5F5;&quot;&gt;wstmall 所售商品均经过严格的供应商资质审查、商品审查、入库全检、出货全检流程。由于部分商品存在厂家更换包装、不同批次、不同生产日期、不同生产工厂等情况，导致商品实物与图片存在微小差异，因此请您以收到的商品实物为准，同时我们会尽量做到及时更新，由此给您带来不便敬请谅解，谢谢！&lt;/span&gt; \n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#666666;font-family:Arial, Verdana, 宋体;font-size:16px;background-color:#F5F5F5;&quot;&gt;&lt;br /&gt;\n&lt;/span&gt; \n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#666666;font-family:Arial, Verdana, 宋体;font-size:16px;background-color:#F5F5F5;&quot;&gt;&lt;img src=&quot;/product/wstmall/Upload/image/20150526/20150526073032_88912.jpg&quot; alt=&quot;&quot; /&gt;&lt;br /&gt;\n&lt;/span&gt; \n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-26 15:30:53', '0', '0'),
('9', '34456', 'wstmall 阳光金果奇异果果王6粒装', 'Upload/goods/2015-05/5564222d7c7fd.jpg', 'Upload/goods/2015-05/5564222d7c7fd.jpg', null, '4', '566.00', '425.00', '50000', '0', '0', '0', '0', '箱', '6粒装', '1', '1', '1', '1', '1', '0', '0', null, '47', '61', '249', '7', '10', '&lt;p&gt;\n	&lt;span style=&quot;color:#666666;font-family:Arial, Verdana, 宋体;font-size:12px;background-color:#F5F5F5;&quot;&gt;wstmall 所售商品均经过严格的供应商资质审查、商品审查、入库全检、出货全检流程。由于部分商品存在厂家更换包装、不同批次、不同生产日期、不同生产工厂等情况，导致商品实物与图片存在微小差异，因此请您以收到的商品实物为准，同时我们会尽量做到及时更新，由此给您带来不便敬请谅解，谢谢！&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#666666;font-family:Arial, Verdana, 宋体;font-size:12px;background-color:#F5F5F5;&quot;&gt;&lt;br /&gt;\n&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#666666;font-family:Arial, Verdana, 宋体;font-size:12px;background-color:#F5F5F5;&quot;&gt;&lt;img src=&quot;/product/wstmall/Upload/image/20150526/20150526073618_87041.png&quot; alt=&quot;&quot; /&gt;&lt;br /&gt;\n&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-26 15:36:21', '0', '0'),
('10', '346456', '贪吃虎 进口水果 美国新奇士橙 15只装 新鲜爽口', 'Upload/goods/2015-05/556425c1bdb76.jpg', 'Upload/goods/2015-05/556425c1bdb76.jpg', null, '4', '234.00', '132.00', '12311312', '0', '0', '0', '0', '15只装', '15只装', '1', '1', '1', '1', '1', '0', '0', null, '47', '61', '72', '7', '10', '&lt;p&gt;\n	&lt;span style=&quot;font-size:18px;&quot;&gt;wstmall&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-size:18px;line-height:1.5;&quot;&gt;所售商品均经过严格的供应商资质审查、商品审查、入库全检、出货全检流程。由于部分商品存在厂家更换包装、不同批次、不同生产日期、不同生产工厂等情况，导致商品实物与图片存在微小差异，因此请您以收到的商品实物为准，同时我们会尽量做到及时更新，由此给您带来不便敬请谅解，谢谢！&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;font-size:12px;line-height:1.5;&quot;&gt;&lt;img src=&quot;/product/wstmall/Upload/image/20150526/20150526075220_70592.jpg&quot; alt=&quot;&quot; /&gt;&lt;br /&gt;\n&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;font-size:12px;line-height:1.5;&quot;&gt;&lt;br /&gt;\n&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-26 15:52:46', '0', '0'),
('11', '34234', 'wstmall 测试商品 牛肉', 'Upload/goods/2015-05/5564342e87634.jpg', 'Upload/goods/2015-05/5564342e87634.jpg', null, '11', '45.00', '39.00', '500', '0', '0', '0', '0', '千克', '千克', '1', '1', '1', '1', '1', '0', '0', null, '47', '64', '326', '19', '20', '&lt;p&gt;\n	&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n		牛肉是全世界人都爱吃的食品，中国人消费的肉类食品之一，仅次于猪肉，牛肉蛋白质含量高，而脂肪含量低，所以味道鲜美，受人喜爱，享有“肉中骄子”的美称。\n	&lt;/p&gt;\n	&lt;div style=&quot;margin:0px auto;padding:0px;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n		&amp;nbsp;\n	&lt;/div&gt;\n	&lt;div style=&quot;margin:0px auto;padding:0px;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n		牛肉含有丰富的蛋白质，氨基酸组成等比猪肉更接近人体需要，能提高机体抗病能力，对生长发育及手术后、病后调养的人在补充失血和修复组织等方面特别适宜。寒冬食牛肉，有暖胃作用，为寒冬补益佳品。中医认为：牛肉有补中益气、滋养脾胃、强健筋骨、化痰息风、止渴止涎的功能。适用于中气下陷、气短体虚，筋骨酸软和贫血久病及面黄目眩之人食用。\n	&lt;/div&gt;\n	&lt;div style=&quot;margin:0px auto;padding:0px;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n		&amp;nbsp;\n	&lt;/div&gt;\n	&lt;div style=&quot;margin:0px auto;padding:0px;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n		牛肉的功效\n	&lt;/div&gt;\n	&lt;div style=&quot;margin:0px auto;padding:0px;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n		补脾胃、益气血、强筋骨、消水肿 。\n	&lt;/div&gt;\n	&lt;div style=&quot;margin:0px auto;padding:0px;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n		虚损羸瘦、消渴、脾弱不运、痞积、水肿、腰膝酸软。\n	&lt;/div&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150526/20150526085320_65675.jpg&quot; alt=&quot;&quot; /&gt; \n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-26 16:53:25', '0', '0'),
('12', '4522356', 'wstmall测试商品 清远鸡（光鸡）', 'Upload/goods/2015-05/5564355c4fcce.jpg', 'Upload/goods/2015-05/5564355c4fcce.jpg', null, '11', '34.00', '32.00', '1234', '0', '0', '0', '0', '千克', '千克', '1', '1', '1', '1', '1', '0', '0', null, '47', '64', '326', '19', '20', '&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	清远麻鸡\n&lt;/p&gt;\n&lt;div style=&quot;margin:0px auto;padding:0px;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	原产于广东省清远县（现清远市）。因母鸡背侧羽毛有细小黑色斑点，故称麻鸡。它以体型小、皮下和肌间脂肪发达、皮薄骨软而著名，素为我国活鸡出口的小型肉用名产鸡之一。\n&lt;/div&gt;\n&lt;div style=&quot;margin:0px auto;padding:0px;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	&amp;nbsp;\n&lt;/div&gt;\n&lt;div style=&quot;margin:0px auto;padding:0px;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	清远麻鸡以肉用品质优良而驰名，《中国家禽品种志》27个优质品种之一，也是家禽行业著名品种。\n&lt;/div&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150526/20150526085712_33988.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-26 16:57:15', '0', '0'),
('13', '345235', 'wstmall 测试商品 猪筒骨', 'Upload/goods/2015-05/556435a901b68.jpg', 'Upload/goods/2015-05/556435a901b68.jpg', null, '11', '123.00', '99.00', '123', '0', '0', '0', '0', '千克', '千克', '1', '1', '1', '1', '1', '0', '0', null, '47', '64', '327', '19', '22', '&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	猪筒骨：&lt;br /&gt;\n&amp;nbsp;&amp;nbsp;&amp;nbsp; 中间有洞，可以容纳骨髓的大骨头。比较好的筒骨，应该是后腿的腿骨，因为这里的骨头比较粗。骨中的骨髓含有很多骨胶元，除了可以美容，还可以促进伤口愈合，增强体质。猪筒骨骨中的骨髓含有很多骨胶元，除了可以美容，还可以促进伤口愈合，增强体质。\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	食疗作用：&lt;br /&gt;\n&amp;nbsp;&amp;nbsp;&amp;nbsp; 提高免疫力,养颜护肤。\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	选购技巧：&lt;br /&gt;\n&amp;nbsp;&amp;nbsp;&amp;nbsp; 比较好的筒骨，应该是后腿的腿骨，因为这里的骨头比较粗。\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	&lt;br /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-26 16:59:32', '0', '0'),
('14', '3453245', 'wstmall 测试商品 猪前腿上肉', 'Upload/goods/2015-05/556436339ad9a.jpg', 'Upload/goods/2015-05/556436339ad9a.jpg', null, '11', '344.00', '234.00', '1234', '0', '0', '0', '0', '千克', '千克', '1', '1', '1', '1', '1', '0', '1', null, '47', '64', '326', '19', '20', '&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	猪前腿上肉&lt;br /&gt;\n&amp;nbsp;&amp;nbsp;&amp;nbsp; 猪前腿〈猪手〉四周的肉，叫前上肉。含蛋白质丰富,含有的必需氮基酸全面、数量多，而且比例恰当，接近于人体的蛋白质，容易消化吸收。\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	食用功效&lt;br /&gt;\n&amp;nbsp;&amp;nbsp;&amp;nbsp; 有补虚强身，滋阴润燥、丰肌泽肤的作用。\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150526/20150526090124_45060.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-26 17:01:30', '0', '0'),
('15', '2342', 'wstmall 测试商品 冰鲜红立鱼', 'Upload/goods/2015-05/556439094a571.jpg', 'Upload/goods/2015-05/556439094a571.jpg', null, '11', '522.00', '400.00', '2000', '0', '0', '0', '0', '千克', '千克', '1', '1', '1', '1', '1', '1', '1', null, '47', '65', '288', '19', '24', '&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	红立鱼，又叫立鱼、立花、立仔、板立、长旗。正式名称是二长棘鲷，产于我国南海和东海南部、主要产地在北部湾及雷州半岛。\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	暖温性底层鱼类。体长130～230毫米。栖息于近海水深20～70米的沙泥底水域。为南海经济鱼类。\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	红立鱼含多种人体必需氨基酸，刺少，非常适合蒸制食用。蒸制后，鱼肉爽滑鲜嫩，是过节餐桌不可多得的一道大餐。\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-26 17:13:37', '0', '0'),
('16', '234234', 'wstmall 测试商品 冰鲜鸡全翅', 'Upload/goods/2015-05/5564397599f61.jpg', 'Upload/goods/2015-05/5564397599f61.jpg', null, '11', '25.00', '20.00', '0', '0', '0', '0', '0', '千克', '千克', '1', '1', '1', '1', '1', '1', '0', null, '47', '64', '326', '19', '20', '&lt;p&gt;\n	&lt;span style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:18px;font-weight:bold;line-height:40px;background-color:#FFFFFF;&quot;&gt;冰鲜鸡全翅&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:18px;font-weight:bold;line-height:40px;background-color:#FFFFFF;&quot;&gt;&lt;br /&gt;\n&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:18px;font-weight:bold;line-height:40px;background-color:#FFFFFF;&quot;&gt;&lt;img src=&quot;/product/wstmall/Upload/image/20150526/20150526091517_84847.jpg&quot; alt=&quot;&quot; /&gt;&lt;br /&gt;\n&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-26 17:15:20', '0', '0'),
('17', '23424', 'wstmall 测试商品 皇上皇金冠腊肠400克', 'Upload/goods/2015-05/55643a2615f00.jpg', 'Upload/goods/2015-05/55643a2615f00.jpg', null, '11', '100.00', '50.00', '3000', '0', '0', '0', '0', '袋', '400克每袋', '1', '1', '1', '1', '1', '1', '0', null, '47', '64', '326', '19', '20', '&lt;p&gt;\n	&lt;span style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:18px;font-weight:bold;line-height:40px;background-color:#FFFFFF;&quot;&gt;皇上皇金冠二八腊肠400克&lt;span style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:18px;font-weight:bold;line-height:40px;background-color:#FFFFFF;&quot;&gt;皇上皇金冠二八腊肠400克&lt;span style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:18px;font-weight:bold;line-height:40px;background-color:#FFFFFF;&quot;&gt;皇上皇金冠二八腊肠400克&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:18px;font-weight:bold;line-height:40px;background-color:#FFFFFF;&quot;&gt;&lt;span style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:18px;font-weight:bold;line-height:40px;background-color:#FFFFFF;&quot;&gt;&lt;br /&gt;\n&lt;/span&gt;&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:18px;font-weight:bold;line-height:40px;background-color:#FFFFFF;&quot;&gt;&lt;span style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:18px;font-weight:bold;line-height:40px;background-color:#FFFFFF;&quot;&gt;&lt;img src=&quot;/product/wstmall/Upload/image/20150526/20150526091815_69131.jpg&quot; alt=&quot;&quot; /&gt;&lt;/span&gt;&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-26 17:18:18', '0', '0'),
('18', '234234', 'wstmall 测试商品 肥羊肉片1000g', 'Upload/goods/2015-05/55643adeb9ba2.jpg', 'Upload/goods/2015-05/55643adeb9ba2.jpg', null, '11', '250.00', '200.00', '100213423', '0', '0', '0', '0', '千克', '千克', '1', '1', '1', '1', '1', '1', '1', null, '47', '64', '326', '19', '20', '&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	&amp;nbsp;&amp;nbsp;羊肉既能御风寒，又可补身体，对一般风寒咳嗽、慢性气管炎、虚寒哮喘、肾亏阳痿、腹部冷痛、体虚怕冷、腰膝酸软、面黄肌瘦、气血两亏、病后或产后身体虚亏等一切虚状均有治疗和补益效果，最适宜于冬季食用，故被称为冬令补品，深受人们欢迎。由于羊肉有一股令人讨厌的羊膻怪味，故被一部分人所冷落。其实，一公斤羊肉若能放入10克甘草和适量料酒、生姜一起烹调，即能够去其膻气而又可保持其羊肉风味。\n&lt;/p&gt;\n&lt;div style=&quot;margin:0px auto;padding:0px;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	&amp;nbsp;\n&lt;/div&gt;\n&lt;div style=&quot;margin:0px auto;padding:0px;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	&amp;nbsp;\n&lt;/div&gt;\n&lt;div style=&quot;margin:0px auto;padding:0px;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	营养分析：\n&lt;/div&gt;\n&lt;div style=&quot;margin:0px auto;padding:0px;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	&amp;nbsp; &amp;nbsp; &amp;nbsp;羊肉鲜嫩，营养价值高，凡肾阳不足、腰膝酸软、腹中冷痛、虚劳不足者皆可用它作食疗品。羊肉营养丰富，对肺结核、气管炎、哮喘、贫血、产后气血两虚、腹部冷痛、体虚畏寒、营养不良、腰膝酸软,阳痿早泄以及一切虚寒病症均有很大裨益；具有补肾壮阳、补虚温中等作用，男士适合经常食用。\n&lt;/div&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-26 17:20:49', '0', '0'),
('19', '315314', 'wstmall 测试商品  瘦肉', 'Upload/goods/2015-05/55643b6b72f07.jpg', 'Upload/goods/2015-05/55643b6b72f07.jpg', null, '11', '50.00', '35.00', '5000', '0', '0', '0', '0', '千克', '千克', '1', '1', '1', '1', '1', '1', '1', null, '47', '64', '326', '19', '20', '&lt;span style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;line-height:18px;background-color:#FFFFFF;&quot;&gt;瘦肉&lt;/span&gt;&lt;br /&gt;\n&lt;span style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;line-height:18px;background-color:#FFFFFF;&quot;&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp; &amp;nbsp;瘦肉一般人说的瘦肉指猪，牛等家畜身上富含蛋白质的肉。&lt;/span&gt;&lt;br /&gt;\n&lt;span style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;line-height:18px;background-color:#FFFFFF;&quot;&gt;功效&lt;/span&gt;&lt;br /&gt;\n&lt;span style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;line-height:18px;background-color:#FFFFFF;&quot;&gt;&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp; &amp;nbsp;补肾养血、滋阴润燥&amp;nbsp;&lt;/span&gt;&lt;br /&gt;\n&lt;span style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;line-height:18px;background-color:#FFFFFF;&quot;&gt;热病伤津、消渴羸瘦、肾虚体弱、产后血虚、燥咳、便秘、补虚、滋阴、润燥、滋肝阴，润肌肤、利二便、止消渴&lt;/span&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-26 17:23:13', '0', '0'),
('20', '353523', 'wstmall 测试商品 冰鲜龙头鱼', 'Upload/goods/2015-05/556442e5a585a.jpg', 'Upload/goods/2015-05/556442e5a585a.jpg', null, '4', '60.00', '42.00', '20000', '0', '0', '0', '0', '斤', '斤', '1', '1', '1', '1', '1', '0', '1', null, '47', '65', '288', '28', '29', '&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	龙头鱼富含蛋白质，具有维持钾钠平衡；消除水肿。提高免疫力。调低血压 ，缓冲贫血，有利于生长发育。富含胆固醇，维持细胞的稳定性，\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	增加血管壁柔韧性。维持正常性功能，增加免疫力。富含镁，提高精子的活力，增强男性生育能力。有助于调节人的心脏活动，降低血压，\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	预防心脏病。调节神经和肌肉活动、增强耐久力。\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	钙是骨骼发育的基本原料，直接影响身高；调节酶的活性；参与神经、肌肉的活动和神经递质的释放；调节激素的分泌；调节心律、降低心\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	血管的通透性；控制炎症和水肿；维持酸碱平衡等。富含钾，具有有助于维持神经健康、心跳规律正常，可以预防中风，并协助肌肉正常收\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	缩。具有降血压作用。富含磷，具有构成骨骼和牙齿，促进成长及身体组织器官的修复，供给能量与活力，参与酸碱平衡的调节。富含钠，\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	调节渗透压，维持酸碱平衡。维持血压正常。增强肌肉兴奋。\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	适宜人群：适宜消瘦，免疫力低，记忆力下降贫血，水肿等症状的人群，生长发育停滞的儿童。中风、冠心病和糖尿病患者。出现肌肉无力、\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	抽筋、记忆力衰退、神经错乱、抑郁症、幻觉、心悸等症状的人群。厌食、偏食；不易入睡、易惊醒；易感冒；头发稀疏；智力发育迟缓；\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	学步、出牙晚或出牙不整齐；阵发性腹痛腹泻；X或O型腿；鸡胸的少年儿童。抽筋乏力；关节疼；头晕；贫血及产前高血压综合征；水肿及\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	乳汁分泌不足的孕妇及哺乳期妇女。骨痛；牙齿松动、脱落；驼背、食欲减退、消化道溃疡多梦、失眠、烦躁、易怒的老年人。甲状腺功能\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	亢进的人。高温、重体力劳动、经常出汗的人需要注意补充钠。\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-26 17:55:22', '0', '0'),
('21', '14123', 'wstmall 测试商品 冰鲜鸡爪', 'Upload/goods/2015-05/5564433ac11dc.jpg', 'Upload/goods/2015-05/5564433ac11dc.jpg', null, '4', '34.00', '25.00', '5000', '0', '0', '0', '0', '斤', '斤', '1', '1', '1', '1', '1', '0', '0', null, '47', '66', '319', '9', '15', '&lt;p class=&quot;MsoNormal&quot; style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	&lt;span class=&quot;headline-content&quot;&gt;&lt;b&gt;&lt;span style=&quot;font-size:12pt;font-family:宋体;&quot;&gt;泡椒凤爪&lt;/span&gt;&lt;/b&gt;&lt;/span&gt;&lt;span style=&quot;font-family:宋体;&quot;&gt;是近年来最为流行的&lt;/span&gt;小吃之一。以麻辣有滋、皮韧肉香而著称。泡椒凤爪既能登大雅之堂，也为普通老百姓所喜爱。此款美食具有开胃生津、促进血液循环的功效。制作过程比较讲究，这样才能使泡椒的劲辣味道沁入凤爪中。正宗的泡椒凤爪丰满洁白，咀嚼时骨肉生香，具有很强的催味功效。&lt;span&gt;&lt;/span&gt;\n&lt;/p&gt;\n&lt;p class=&quot;MsoNormal&quot; style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	&lt;span class=&quot;headline-content&quot;&gt;&lt;b&gt;&lt;span style=&quot;font-size:12pt;font-family:宋体;&quot;&gt;制作方法：&lt;/span&gt;&lt;/b&gt;&lt;/span&gt;&lt;span class=&quot;headline-content&quot;&gt;&lt;b&gt;&lt;span style=&quot;font-size:12pt;&quot;&gt;&lt;/span&gt;&lt;/b&gt;&lt;/span&gt;\n&lt;/p&gt;\n&lt;p class=&quot;MsoNormal&quot; align=&quot;left&quot; style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;text-indent:22.5pt;&quot;&gt;\n	&lt;span style=&quot;font-family:宋体;&quot;&gt;凤爪洗净去指甲对半切开。先在开水里氽过去腥气。换水，在水中放入葱姜片，黄酒，花椒，八角和适量盐，将凤爪放入，上火烧开，中小火闷煮&lt;/span&gt;&lt;span style=&quot;font-family:Arial;&quot;&gt;15-20&lt;/span&gt;&lt;span style=&quot;font-family:宋体;&quot;&gt;分钟。喜欢脆的就&lt;/span&gt;&lt;span style=&quot;font-family:Arial;&quot;&gt;15&lt;/span&gt;&lt;span style=&quot;font-family:宋体;&quot;&gt;分钟，喜欢口感软些的就&lt;/span&gt;&lt;span style=&quot;font-family:Arial;&quot;&gt;20&lt;/span&gt;&lt;span style=&quot;font-family:宋体;&quot;&gt;分钟。&lt;/span&gt;&lt;span style=&quot;font-family:Arial;&quot;&gt;&lt;/span&gt;\n&lt;/p&gt;\n&lt;p class=&quot;MsoNormal&quot; align=&quot;left&quot; style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;text-indent:22.5pt;&quot;&gt;\n	&lt;span style=&quot;font-family:宋体;&quot;&gt;准备一个够大的带盖冰箱盛器，将一瓶泡山椒里的液体全部倒入，也就一点点，放入部分泡椒，喜辣的多放，放大约&lt;/span&gt;&lt;span style=&quot;font-family:Arial;&quot;&gt;1/5&lt;/span&gt;&lt;span style=&quot;font-family:宋体;&quot;&gt;。加饮用水至盛器的一半，加入白醋，白糖，盐，料酒调味。&lt;/span&gt;&lt;span style=&quot;font-family:Arial;&quot;&gt;&amp;nbsp;&lt;/span&gt;&lt;span style=&quot;font-family:宋体;&quot;&gt;味道要足，按个人喜好偏酸偏甜自己掌握，但要够咸，否则不入味。放些花椒和一个八角，几个厚姜片，有助于去腥提味。&lt;/span&gt;&lt;span style=&quot;font-family:Arial;&quot;&gt;&lt;/span&gt;\n&lt;/p&gt;\n&lt;p class=&quot;MsoNormal&quot; align=&quot;left&quot; style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;text-indent:22.5pt;&quot;&gt;\n	&lt;span style=&quot;font-family:宋体;&quot;&gt;凤爪出锅后投入凉水中冷透，可以多过几遍水去油。然后放入对好的泡椒水里，要能够被汁液浸透。盖上盖子，放入冰箱。泡两天后拿出来挑出凤抓和泡椒就可以了！&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-26 17:56:57', '0', '0'),
('22', '345235', 'wstmall 测试商品 冰鲜鱿鱼', 'Upload/goods/2015-05/5564441acf878.jpg', 'Upload/goods/2015-05/5564441acf878.jpg', null, '4', '234.00', '231.00', '2132134', '0', '0', '0', '0', '千克', '千克', '1', '1', '1', '1', '1', '0', '0', null, '47', '66', '319', '28', '29', '&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	鱿鱼&lt;br /&gt;\n&amp;nbsp;&amp;nbsp;&amp;nbsp; 鱿鱼属软体动物类，是乌贼的一种。目前市场看到的鱿鱼有两种：一种是躯干部较肥大的鱿鱼，它的名称叫“枪乌贼”；一种是躯干部细长的鱿鱼，它的名称叫“柔鱼”，小的柔鱼俗名叫“小管仔”。\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	功效&lt;br /&gt;\n&amp;nbsp;&amp;nbsp;&amp;nbsp; 益气壮志, 通妇女月经, 入肝补血, 入肾可滋水强志, 滋阴养胃, 补虚润肤。\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150526/20150526100008_84465.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-26 18:00:11', '0', '0'),
('23', '34535', 'wstmall 测试商品 冰鲜鲈鱼', 'Upload/goods/2015-05/556448ac442c6.jpg', 'Upload/goods/2015-05/556448ac442c6.jpg', null, '4', '234.00', '123.00', '123234', '0', '0', '0', '0', '千克', '千克', '1', '1', '1', '1', '1', '0', '0', null, '47', '65', '288', '28', '29', '&lt;strong&gt;\n&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	鲈鱼&lt;br /&gt;\n&amp;nbsp;&amp;nbsp;&amp;nbsp; 鲈鱼肉质白嫩、清香，没有腥味，肉为蒜瓣形，最宜清蒸、红烧或炖汤。尤其是秋末冬初，成熟的鲈鱼特别肥美，鱼体内积累的营养物质也最丰富，所以是吃鱼的最好时令。\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	鲈鱼的功效&lt;br /&gt;\n&amp;nbsp;&amp;nbsp;&amp;nbsp; 健脾,补气,益肾,安胎,补血。\n&lt;/p&gt;\n&lt;/strong&gt;\n&lt;p&gt;\n	&lt;strong&gt;&lt;br /&gt;\n&lt;/strong&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;strong&gt;&lt;br /&gt;\n&lt;/strong&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;strong&gt;&lt;/strong&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-26 18:02:10', '0', '0'),
('24', '6546', 'wstmall测试商品 冰鲜深海金鲳鱼约500g', 'Upload/goods/2015-05/556444c931a82.jpg', 'Upload/goods/2015-05/556444c931a82.jpg', null, '4', '2422.00', '1233.00', '0', '0', '0', '0', '0', '千克', '千克', '1', '1', '1', '1', '1', '0', '0', null, '47', '65', '292', '28', '29', '&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	金鲳鱼&lt;br /&gt;\n&amp;nbsp;&amp;nbsp;&amp;nbsp; 金鲳鱼，又叫平鱼。是一种身体扁平的海鱼，因其刺少肉嫩，故很受人们喜爱，它富含高蛋白、不饱和脂肪酸和多种微量元素。\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	功效&lt;br /&gt;\n&amp;nbsp;&amp;nbsp;&amp;nbsp; 益气养血, 补胃益精, 滑利关节, 柔筋利骨。\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150526/20150526100545_57518.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-26 18:05:23', '0', '0'),
('25', '345234', 'wstmall 测试商品 大闸蟹', 'Upload/goods/2015-05/556445fe8e57d.jpg', 'Upload/goods/2015-05/556445fe8e57d.jpg', null, '4', '123.00', '100.00', '554313', '0', '0', '0', '0', '只', '', '1', '1', '1', '1', '1', '0', '0', null, '47', '65', '290', '28', '30', '&lt;p&gt;\n	&lt;span style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:18px;font-weight:bold;line-height:40px;background-color:#FFFFFF;&quot;&gt;大闸蟹&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:18px;font-weight:bold;line-height:40px;background-color:#FFFFFF;&quot;&gt;\n	&lt;p style=&quot;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n		中华绒螯蟹又称河蟹、毛蟹、清水蟹、大闸蟹或螃蟹，味道鲜美，营养丰富。\n	&lt;/p&gt;\n	&lt;div style=&quot;margin:0px auto;padding:0px;color:#404040;font-family:宋体, Verdana, Arial;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n		&amp;nbsp;\n	&lt;/div&gt;\n&lt;img src=&quot;/product/wstmall/Upload/image/20150526/20150526100818_71751.jpg&quot; alt=&quot;&quot; /&gt;&lt;br /&gt;\n&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-26 18:08:21', '0', '0'),
('26', '2342', 'wstmall 测试商品 花蛤', 'Upload/goods/2015-05/556446e328d34.jpg', 'Upload/goods/2015-05/556446e328d34.jpg', null, '4', '54.00', '45.00', '5000', '0', '0', '0', '0', '千克', '千克', '1', '1', '1', '1', '1', '0', '0', null, '47', '65', '288', '28', '30', '食疗功效&lt;br /&gt;\n&lt;br /&gt;\n花蛤肉味鲜美、营养丰富，蛋白质含量高，氨基酸的种类组成及配比合理； 脂肪含量低，不饱和脂肪酸较高，易被人体消化吸收，还有各种维生素和药用成分。含钙、镁、铁、锌等多种人体必需的微量元素，可作为人类的营养、绿色食品，深受消费者的青睐。蛤肉以及贝类软体动物中，含一种具有降低血清胆固醇作用的代尔太7—胆固醇和24—亚甲基胆固醇，它们兼有抑制胆固醇在肝脏合成和加速排泄胆固醇的独特作用，从而使体内胆固醇下降。它们的功效比常用的降胆固醇的药物谷固醇更强。人们在食用蛤肉和贝类食物后，常有一种清爽宜人的感觉，这对解除一些烦恼症状无疑是有益的。中医认为，蛤肉有滋阴明目、软坚、化痰之功效，有的贝类还有益精润脏的作用。所有人都可以吃。高胆固醇、高血脂体质的人以及患有甲状腺肿大、支气管炎、胃病等疾病的人尤为适合。&lt;br /&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-26 18:12:52', '0', '0'),
('27', '293874', 'KDT170心相印厨房纸巾70抽吸油去污 吸水锁水', 'Upload/goods/2015-05/55647ca720f9e.jpg', 'Upload/goods/2015-05/55647ca720f9e.jpg', null, '14', '23.00', '19.00', '123345', '0', '0', '0', '0', '提', '4提12包', '1', '1', '1', '1', '1', '1', '0', null, '48', '74', '262', '32', '39', '&lt;h1 style=&quot;color:#333333;text-indent:0px;font-family:微软雅黑;font-size:16px;font-style:normal;background-color:#FFFFFF;&quot;&gt;\n	KDT170心相印厨房纸巾70抽吸油去污 吸水锁水抽纸4提套装\n&lt;/h1&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#E53333;&quot;&gt;测试商品，请勿下单&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150526/20150526140202_57724.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-26 22:02:42', '0', '0'),
('28', '3947829', '奥妙净蓝全效无磷洗衣粉500g/汰渍全效洗衣粉', 'Upload/goods/2015-05/556480e66c840.jpg', 'Upload/goods/2015-05/556480e66c840.jpg', null, '14', '15.00', '12.50', '9003', '0', '0', '0', '0', '包', '', '1', '1', '1', '1', '1', '1', '0', null, '48', '258', '329', '34', '41', '&lt;p&gt;\n	测试商品 请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150526/20150526141901_86734.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-26 22:19:27', '0', '0'),
('29', '3598', 'wstmall测试商品 汰渍 净白去渍无磷洗衣粉', 'Upload/goods/2015-05/5564818910da2.jpg', 'Upload/goods/2015-05/5564818910da2.jpg', null, '14', '25.00', '20.00', '123242', '0', '0', '0', '0', '包', '', '1', '1', '1', '1', '1', '0', '0', null, '48', '258', '329', '34', '41', '&lt;p&gt;\n	wstmall测试商品\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150526/20150526142311_19107.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-26 22:23:30', '0', '0'),
('30', '347294', '奥妙洗衣粉净500g*3袋', 'Upload/goods/2015-05/55648222cc241.jpg', 'Upload/goods/2015-05/55648222cc241.jpg', null, '14', '30.00', '27.00', '239473', '0', '0', '0', '0', '组', '3袋为一组', '1', '1', '1', '1', '1', '1', '0', null, '48', '258', '329', '34', '41', '&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;strong&gt;&lt;span style=&quot;color:#E53333;font-size:16px;&quot;&gt;wstmall测试商品，请勿下单&lt;/span&gt;&lt;/strong&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150526/20150526142518_93795.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-26 22:25:42', '0', '0'),
('31', '2347982', '洗衣氧颗粒浓缩型600g+多功能洗涤氧颗粒600g', 'Upload/goods/2015-05/556485b17d4cb.jpg', 'Upload/goods/2015-05/556485b17d4cb.jpg', null, '14', '24.00', '21.00', '24234', '0', '0', '0', '0', '组', '2包为一组', '1', '1', '1', '1', '1', '0', '0', null, '48', '258', '329', '34', '41', '&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;strong&gt;&lt;span style=&quot;color:#E53333;font-size:16px;&quot;&gt;wstmall测试商品，请勿下单&lt;/span&gt;&lt;/strong&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150526/20150526144047_49784.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-26 22:41:14', '0', '0'),
('32', '345345', '得宝纸巾软抽餐巾纸组合套装4提抽纸共12包', 'Upload/goods/2015-05/55648d1d30566.jpg', 'Upload/goods/2015-05/55648d1d30566.jpg', null, '14', '88.00', '77.00', '234789', '0', '0', '0', '0', '组', '4提抽纸共12包', '1', '1', '1', '1', '1', '1', '0', null, '48', '74', '262', '32', '39', '&lt;p&gt;\n	4提抽纸共12包\n&lt;/p&gt;\n&lt;p&gt;\n	测试商品 请勿下单&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150526/20150526151135_88373.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-26 23:11:37', '0', '0'),
('33', '2347982', '维达卷纸3提蓝色经典卷筒纸家用大卷纸200g', 'Upload/goods/2015-05/55648dc7335f0.jpg', 'Upload/goods/2015-05/55648dc7335f0.jpg', null, '14', '220.00', '198.00', '234879', '0', '0', '0', '0', '箱', '整箱', '1', '1', '1', '1', '1', '0', '0', null, '48', '74', '262', '32', '39', '&lt;p&gt;\n	wstmall测试商品，卷纸\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	请勿下单\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-26 23:15:19', '0', '0'),
('34', '294387', '维达卷筒纸蓝色经典卫生纸家庭装卷纸柔韧140g*3', 'Upload/goods/2015-05/55648f06c76e2.jpg', 'Upload/goods/2015-05/55648f06c76e2.jpg', null, '14', '98.00', '92.00', '234928', '0', '0', '0', '0', '组', '3提为一组', '1', '1', '1', '1', '1', '1', '0', null, '48', '74', '262', '32', '39', '&lt;p&gt;\n	&lt;span style=&quot;color:#E53333;font-size:16px;&quot;&gt;wstmall测试商品&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150526/20150526152022_21285.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-26 23:20:45', '0', '0'),
('35', '234979', '泉林本色纸巾 不漂白原浆面巾纸卫生纸 14*240', 'Upload/goods/2015-05/55649029417c3.jpg', 'Upload/goods/2015-05/55649029417c3.jpg', null, '14', '65.00', '58.90', '87689', '0', '0', '0', '0', '箱', '“买20卷加送四卷，加量不加价” 泉林本色是国内唯一食品级安全用纸 真正无添加 可以吃的纸', '1', '1', '1', '1', '1', '0', '0', null, '48', '74', '262', '32', '39', '&lt;p&gt;\n	&lt;span style=&quot;font-size:16px;&quot;&gt;测试商品 请勿下单&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150526/20150526152551_15660.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-26 23:26:12', '0', '0'),
('36', '329874', '维达蓝色经典140g卫生卷纸共20卷 卷筒卫生纸', 'Upload/goods/2015-05/55649c4137436.jpg', 'Upload/goods/2015-05/55649c4137436.jpg', null, '14', '89.00', '69.00', '3248', '0', '0', '0', '0', '组', '20卷为一组', '1', '1', '1', '1', '1', '1', '0', null, '48', '74', '262', '32', '39', '&lt;p&gt;\n	wstmall测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150526/20150526161704_71372.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 00:17:21', '0', '0'),
('37', '3749', '维达150抽家用纸巾餐巾纸 抽纸巾 加厚 15包', 'Upload/goods/2015-05/55649d4fc27fc.jpg', 'Upload/goods/2015-05/55649d4fc27fc.jpg', null, '14', '78.00', '69.00', '58943', '0', '0', '0', '0', '组', '15包一组', '1', '1', '1', '1', '1', '1', '0', null, '48', '74', '75', '32', '40', '&lt;p&gt;\n	wstmall测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150526/20150526162119_90595.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 00:21:23', '0', '0'),
('38', '34789', '心相印特柔纸巾三层140g卷筒卫生纸卷纸 五提/组', 'Upload/goods/2015-05/55649dcd962a0.jpg', 'Upload/goods/2015-05/55649dcd962a0.jpg', null, '14', '150.00', '138.00', '237489', '0', '0', '0', '0', '组', '五提/组', '1', '1', '1', '1', '1', '0', '0', null, '48', '74', '262', '32', '39', '&lt;p&gt;\n	&lt;span style=&quot;color:#E53333;&quot;&gt;wstmall测试商品，请勿下单&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#E53333;&quot;&gt;&lt;/span&gt;&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#E53333;&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150526/20150526162331_10164.jpg&quot; /&gt;&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 00:23:33', '0', '0'),
('39', '23794', 'B1-0284超威洁厕精1+1洁厕500g2瓶', 'Upload/goods/2015-05/5564a125c1e50.jpg', 'Upload/goods/2015-05/5564a125c1e50.jpg', null, '14', '26.00', '19.00', '2348', '0', '0', '0', '0', '组', '2瓶一组', '1', '1', '1', '1', '1', '0', '0', null, '48', '258', '274', '31', '38', '&lt;p&gt;\n	wstmall测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150526/20150526163005_26619.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 00:30:07', '0', '0'),
('40', '237894', '迪可浓洁厕宝马桶自动清洁剂（2个装）2*50g', 'Upload/goods/2015-05/55649fe956459.jpg', 'Upload/goods/2015-05/55649fe956459.jpg', null, '14', '56.00', '47.00', '34923', '0', '0', '0', '0', '包', '2个为一包', '1', '1', '1', '1', '1', '1', '0', null, '48', '258', '274', '31', '38', '&lt;p&gt;\n	wstmall测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150526/20150526163229_89010.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 00:32:32', '0', '0'),
('41', '3249', 'wstmall测试商品 洁厕灵', 'Upload/goods/2015-05/5564a40b42496.jpg', 'Upload/goods/2015-05/5564a40b42496.jpg', null, '14', '19.00', '15.00', '23422', '0', '0', '0', '0', '瓶', '', '1', '1', '1', '0', '1', '0', '0', null, '48', '258', '274', '31', '38', '&lt;p style=&quot;color:#666666;text-indent:0px;&quot;&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p style=&quot;color:#666666;text-indent:0px;&quot;&gt;\n	&lt;span style=&quot;color:#666666;font-family:SimSun;font-size:16px;&quot;&gt;品名：加多洁洁厕灵&lt;/span&gt;\n&lt;/p&gt;\n&lt;p style=&quot;color:#666666;text-indent:0px;&quot;&gt;\n	&lt;span style=&quot;color:#666666;font-family:SimSun;font-size:16px;&quot;&gt;品牌：加多洁&lt;/span&gt;\n&lt;/p&gt;\n&lt;p style=&quot;color:#666666;text-indent:0px;&quot;&gt;\n	&lt;span style=&quot;color:#666666;font-family:SimSun;font-size:16px;&quot;&gt;产地：湖北&lt;/span&gt;\n&lt;/p&gt;\n&lt;p style=&quot;color:#666666;text-indent:0px;&quot;&gt;\n	&lt;span style=&quot;color:#666666;font-family:SimSun;font-size:16px;&quot;&gt;生产厂商：湖北铭高商贸有限公司&lt;/span&gt;\n&lt;/p&gt;\n&lt;p style=&quot;color:#666666;text-indent:0px;&quot;&gt;\n	&lt;span style=&quot;color:#666666;font-family:SimSun;font-size:16px;&quot;&gt;净含量： 500ml/瓶&lt;/span&gt;\n&lt;/p&gt;\n&lt;p style=&quot;color:#666666;text-indent:0px;&quot;&gt;\n	&lt;span style=&quot;color:#666666;font-family:SimSun;font-size:16px;&quot;&gt;生产日期：近期&lt;/span&gt;\n&lt;/p&gt;\n&lt;p style=&quot;color:#666666;text-indent:0px;&quot;&gt;\n	&lt;span style=&quot;color:#666666;font-family:SimSun;font-size:16px;&quot;&gt;保质期：3年&lt;/span&gt;\n&lt;/p&gt;\n&lt;p style=&quot;color:#666666;text-indent:0px;&quot;&gt;\n	&lt;br /&gt;\n&amp;nbsp;\n&lt;/p&gt;\n&lt;p style=&quot;color:#666666;text-indent:0px;&quot;&gt;\n	&amp;nbsp;&lt;span style=&quot;color:#666666;font-family:SimSun;font-size:16px;&quot;&gt;强力去污：添加强力去垢因子，轻松去除尿渍、污渍等。&lt;br /&gt;\n快速除菌：高效杀菌成分，快速清除隐藏在厕盆内的细菌。&lt;br /&gt;\n清香辟味：气味清香，迅速辟味。&lt;br /&gt;\n压力喷嘴：方便将液体挤射到难以清洗的暗沟，清洁更轻松&lt;/span&gt;\n&lt;/p&gt;\n&lt;p style=&quot;color:#666666;text-indent:0px;&quot;&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p style=&quot;color:#666666;text-indent:0px;&quot;&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p align=&quot;left&quot; style=&quot;color:#666666;text-indent:0px;&quot;&gt;\n	&lt;span style=&quot;color:#666666;font-family:SimSun;font-size:16px;&quot;&gt;将洁厕液挤射到厕盆内壁四周及边缘暗沟，10分钟后冲水即净，对顽固污渍可适当延长时间或用刷子轻刷。&lt;/span&gt;\n&lt;/p&gt;\n&lt;p style=&quot;color:#666666;text-indent:0px;&quot;&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p style=&quot;color:#666666;text-indent:0px;&quot;&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p align=&quot;left&quot; style=&quot;color:#666666;text-indent:0px;&quot;&gt;\n	&lt;span style=&quot;color:#666666;font-family:SimSun;font-size:16px;&quot;&gt;1、勿让儿童接触；&lt;br /&gt;\n2、勿与漂白剂等化学品混用；&lt;br /&gt;\n3、避免清洁液接触皮肤或眼部，触及后即用清水冲洗。&lt;br /&gt;\n4、勿用于金属表面和非陶瓷器具。&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 00:40:55', '0', '0'),
('42', '237948', '威猛先生 强效洁厕液双包装 优惠套装 去污 500', 'Upload/goods/2015-05/5564a29f169b7.jpg', 'Upload/goods/2015-05/5564a29f169b7.jpg', null, '14', '234.00', '123.00', '234', '0', '0', '0', '0', '组', '2瓶一组', '1', '1', '1', '1', '1', '0', '0', null, '48', '258', '274', '31', '45', '&lt;div style=&quot;margin:0px;padding:0px;color:#404040;&quot;&gt;\n	商品特色：\n&lt;/div&gt;\n&lt;div style=&quot;margin:0px;padding:0px;color:#404040;&quot;&gt;\n	采用欧洲先进技术，彻底清洁，且不伤马桶表面，有效去除异味，用后留下清新气味。\n&lt;/div&gt;\n&lt;div style=&quot;margin:0px;padding:0px;color:#404040;&quot;&gt;\n	第一款会变色的洁厕液！洁厕液溶解污垢后，酸碱中和，洁厕液从绿变蓝。\n&lt;/div&gt;\n&lt;div style=&quot;margin:0px;padding:0px;color:#404040;&quot;&gt;\n	适用范围：\n&lt;/div&gt;\n&lt;div style=&quot;margin:0px;padding:0px;color:#404040;&quot;&gt;\n	座式或者蹲式马桶。\n&lt;/div&gt;\n&lt;div style=&quot;margin:0px;padding:0px;color:#404040;&quot;&gt;\n	使用方法：\n&lt;/div&gt;\n&lt;div style=&quot;margin:0px;padding:0px;color:#404040;&quot;&gt;\n	翻起厕盆盖。\n&lt;/div&gt;\n&lt;div style=&quot;margin:0px;padding:0px;color:#404040;&quot;&gt;\n	倾倒瓶身，使液体充满瓶颈。\n&lt;/div&gt;\n&lt;div style=&quot;margin:0px;padding:0px;color:#404040;&quot;&gt;\n	沿水位线轻刷厕盆，用水冲净。\n&lt;/div&gt;\n&lt;div style=&quot;margin:0px;padding:0px;color:#404040;&quot;&gt;\n	如需对付顽固污垢，轻刷厕盆后，可静待片刻再用水冲净。\n&lt;/div&gt;\n&lt;div style=&quot;margin:0px;padding:0px;color:#404040;&quot;&gt;\n	定期使用可保持您的厕盆清洁卫生，防止顽垢形成。\n&lt;/div&gt;\n&lt;div style=&quot;margin:0px;padding:0px;color:#404040;&quot;&gt;\n	注意事项：\n&lt;/div&gt;\n&lt;div style=&quot;margin:0px;padding:0px;color:#404040;&quot;&gt;\n	请勿接触眼睛。\n&lt;/div&gt;\n&lt;div style=&quot;margin:0px;padding:0px;color:#404040;&quot;&gt;\n	请勿吞食。\n&lt;/div&gt;\n&lt;div style=&quot;margin:0px;padding:0px;color:#404040;&quot;&gt;\n	请放置在儿童和宠物不易接触的地方。\n&lt;/div&gt;\n&lt;div style=&quot;margin:0px;padding:0px;color:#404040;&quot;&gt;\n	切勿与漂白剂或者其他化学品一同使用，以免产生有害气体。\n&lt;/div&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 00:43:57', '0', '0'),
('43', '4535', '七度香 清香型（消正） 铁观音 250g书型硬盒装', 'Upload/goods/2015-05/556529ba1430c.jpg', 'Upload/goods/2015-05/556529ba1430c.jpg', null, '18', '234.00', '114.00', '24235', '0', '0', '0', '0', '克', '采摘季节：春茶\n香型：清香型\n工艺：袋泡茶\n茶叶等级：二级\n产地：安溪祥华\n规格：7.8g*32泡\n保质期：18个月\n储藏方法：阴凉干燥', '1', '1', '1', '1', '1', '1', '0', null, '49', '80', '303', '52', '53', '&lt;p&gt;\n	wstmall 测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150527/20150527022049_79636.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 10:21:10', '0', '0'),
('44', '45335', '正品八马 安溪铁观音 浓香型 特级赛珍珠1000', 'Upload/goods/2015-05/55652b3d68f16.jpg', 'Upload/goods/2015-05/55652b3d68f16.jpg', null, '18', '344.00', '233.00', '24335', '0', '0', '0', '0', '包', '采摘季节：春茶\n香型：浓香型\n工艺：袋泡茶\n功效：消肉食，逐风痰，泄热，解毒，生津，止渴。\n茶叶等级：特级\n产地：福建安溪\n规格：8.35克/泡×15泡/盒×2盒 礼盒规格：32*32*8.5\n保质期：24个月\n储藏方法：防潮湿，防异味，避光直射', '1', '1', '1', '1', '1', '1', '0', null, '49', '80', '303', '52', '53', '&lt;p&gt;\n	WSTMALL测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150527/20150527022710_93237.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 10:27:48', '0', '0'),
('45', 'HS546464', '新疆哈密瓜', 'Upload/goods/2015-05/55652d139de45.jpg', 'Upload/goods/2015-05/55652d139de45.jpg', null, '4', '30.00', '20.00', '1000', '0', '0', '0', '0', 'Kg', '件', '0', '1', '1', '1', '1', '0', '0', null, '47', '61', '76', '7', '8', '商品描述', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 10:34:02', '0', '0'),
('46', '3516354', '正品八马 安溪铁观音 清香型 特级韵香 250g', 'Upload/goods/2015-05/55652d25a41b7.jpg', 'Upload/goods/2015-05/55652d25a41b7.jpg', null, '18', '500.00', '250.00', '35436546', '0', '0', '0', '0', '盒', '采摘季节：春茶\n香型：清香型\n工艺：袋泡茶\n功效：提神消疲，降脂减肥，清热解暑，醒酒敌烟，抗衰老抗辐射\n茶叶等级：特级\n产地：福建安溪\n规格：8.35g*30泡 礼盒32cm*22cm*8.2cm\n保质期：18个月\n储藏方法：防潮湿，防异味，避光直射', '1', '1', '1', '1', '1', '1', '0', null, '49', '80', '303', '52', '53', '&lt;p&gt;\n	wstmall测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150527/20150527023540_32730.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 10:35:47', '0', '0'),
('47', '359783', '正宗安溪铁观音 清香型特级QGY1296-250g', 'Upload/goods/2015-05/55652db0d98c7.jpg', 'Upload/goods/2015-05/55652db0d98c7.jpg', null, '18', '633.00', '522.00', '537464', '0', '0', '0', '0', '盒', '配料：安溪铁观音\n采摘季节：春茶\n香型：清香型\n工艺：袋泡茶\n功效：消肉食，逐风痰，泄热，解毒，生津，止渴。\n茶叶等级：特级\n产地：福建省安溪县\n规格：33x11x6.5cm 7.8g/泡x32泡\n保质期：18个月', '1', '1', '1', '1', '1', '1', '0', null, '49', '80', '303', '52', '53', '&lt;p&gt;\n	测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150527/20150527023942_44266.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 10:37:39', '0', '0'),
('48', '23498723', '五十五年老茶师精制 最传统最地道的铁观音', 'Upload/goods/2015-05/55652e10dc119.jpg', 'Upload/goods/2015-05/55652e10dc119.jpg', null, '18', '345.00', '345.00', '24235255', '0', '0', '0', '0', '盒', '配料：安溪铁观音\n采摘季节：春茶\n香型：清香型\n工艺：袋泡茶\n功效：提神消疲，降脂减肥，生津止渴\n茶叶等级：特级', '1', '1', '1', '1', '1', '0', '0', null, '49', '80', '303', '52', '53', '&lt;p&gt;\n	wstmall测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150527/20150527023924_65464.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 10:39:01', '0', '0'),
('49', '234235', '正宗安溪铁观音 清香型特级469g 典藏礼盒', 'Upload/goods/2015-05/5565309d7b672.jpg', 'Upload/goods/2015-05/5565309d7b672.jpg', null, '18', '435.00', '345.00', '345456', '0', '0', '0', '0', '盒', '采摘季节：春茶\n香型：清香型\n工艺：袋泡茶\n茶叶等级：特级\n产地：福建省安溪感德\n规格：15泡/罐\n保质期：18个月', '1', '1', '1', '1', '1', '0', '0', null, '49', '80', '303', '52', '53', '&lt;p&gt;\n	wstmall测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150527/20150527025006_15369.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 10:50:10', '0', '0'),
('50', '534435', '世博第一名茶 八马力荐巅峰制作 商政礼品茶', 'Upload/goods/2015-05/55653369c81f3.jpg', 'Upload/goods/2015-05/55653369c81f3.jpg', null, '18', '566.00', '455.00', '235345', '0', '0', '0', '0', '盒', '采摘季节：春茶\n香型：浓香型\n工艺：袋泡茶\n功效：提神消疲，降脂减肥，清热解暑，醒酒敌烟，抗衰老抗辐射\n茶叶等级：特级\n食品生产许可证：闽卫食证字（2007）第350524008273号\n产地：福建安溪\n规格：125克/罐×2罐 礼盒规格：30cm×21cm\n保质期：18个月', '1', '1', '1', '1', '1', '0', '0', null, '49', '80', '303', '52', '53', '&lt;p&gt;\n	wstmall测试商品，请勿上架\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150527/20150527030203_36573.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 11:02:06', '0', '0'),
('51', '30945390', '安溪铁观音 韵香型（炭焙） 特级 234g 禅悦竹', 'Upload/goods/2015-05/55653554971db.jpg', 'Upload/goods/2015-05/55653554971db.jpg', null, '18', '455.00', '422.00', '375465', '0', '0', '0', '0', '盒', '采摘季节：秋茶\n香型：韵香型\n工艺：袋泡茶\n功效：提神消疲，降脂减肥，清热解暑，醒酒敌烟，抗衰老抗辐射\n茶叶等级：特级\n食品生产许可证：QS3502 1401 0650\n产地：安溪\n规格：7.8g/包*30包\n保质期：36个月', '1', '1', '1', '1', '1', '0', '0', null, '49', '80', '303', '52', '53', '&lt;p&gt;\n	wstmall 测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150527/20150527031023_22804.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 11:10:28', '0', '0'),
('52', '3536', '52°泸州老窖醇香2A 500ml*4', 'Upload/goods/2015-05/55653991385af.jpg', 'Upload/goods/2015-05/55653991385af.jpg', null, '19', '342.00', '234.00', '435345', '0', '0', '0', '0', '箱', '4瓶为一箱', '1', '1', '1', '1', '1', '0', '0', null, '49', '78', '293', '54', '61', '&lt;p&gt;\n	&lt;span style=&quot;color:#666666;font-family:Arial, Helvetica, sans-serif, 宋体;font-size:12px;line-height:24px;background-color:#FFFFFF;&quot;&gt;根据新修订的《商标法》及国家工商总局最新文件要求，2014年5月1日之后不得将“驰名商标”字样用于商品宣传，wstmall依法对商品图片中含“驰名商标”字样做马赛克处理；同时，涉及厂家正在按照新规定逐步更换包装，在此期间，我们将对新旧包装货品随机发货，请以实际收到的货物为准。&lt;/span&gt; \n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#666666;font-family:Arial, Helvetica, sans-serif, 宋体;font-size:12px;line-height:24px;background-color:#FFFFFF;&quot;&gt;&lt;br /&gt;\n&lt;/span&gt; \n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#666666;font-family:Arial, Helvetica, sans-serif, 宋体;font-size:12px;line-height:24px;background-color:#FFFFFF;&quot;&gt;&lt;img src=&quot;/product/wstmall/Upload/image/20150527/20150527032840_33219.jpg&quot; alt=&quot;&quot; /&gt;&lt;br /&gt;\n&lt;/span&gt; \n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 11:28:43', '0', '0'),
('53', '4646456', '爱洛依丝酒类联盟 阿根廷原瓶进口红酒 维特红葡萄酒', 'Upload/goods/2015-05/55653e240b326.jpg', 'Upload/goods/2015-05/55653e240b326.jpg', null, '19', '123.00', '89.00', '345345', '0', '0', '0', '0', '瓶', '瓶', '1', '1', '1', '1', '1', '0', '0', null, '49', '78', '294', '55', '62', '&lt;p&gt;\n	wstmall测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150527/20150527034737_22137.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 11:47:40', '0', '0'),
('54', '342535', '张裕干红酿酒师系列巴狄多奇美乐红酒葡萄酒整箱', 'Upload/goods/2015-05/55653f2249b3d.jpg', 'Upload/goods/2015-05/55653f2249b3d.jpg', null, '19', '566.00', '366.00', '3453563', '0', '0', '0', '0', '箱', '6瓶一箱', '1', '1', '1', '1', '1', '1', '0', null, '49', '78', '294', '55', '64', '&lt;p&gt;\n	wstmall测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150527/20150527035247_51141.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 11:52:49', '0', '0'),
('55', '345354', '拉菲传说波尔多AOC干红葡萄酒 瓶装红酒 法国原装', 'Upload/goods/2015-05/55653ff51c0a3.jpg', 'Upload/goods/2015-05/55653ff51c0a3.jpg', null, '19', '345.00', '234.00', '23425', '0', '0', '0', '0', '瓶', '', '1', '1', '1', '1', '1', '0', '0', null, '49', '78', '294', '55', '62', '&lt;p&gt;\n	wstmall测试商品 请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150527/20150527035508_32510.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 11:55:10', '0', '0'),
('56', '6846541', '长城葡萄酒 中粮长城黑标解百纳干红葡萄酒 长城解百', 'Upload/goods/2015-05/556540f9b9d83.jpg', 'Upload/goods/2015-05/556540f9b9d83.jpg', null, '19', '123.00', '89.00', '35325', '0', '0', '0', '0', '瓶', '储藏方法：避光卧放保质期：3650 天食品添加剂：焦亚硫酸钾品牌: Great Wall/长城系列: 长城黑标干红套装规格: 单支', '1', '1', '1', '1', '1', '1', '0', null, '49', '78', '294', '55', '64', '&lt;p&gt;\n	wstmall测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150527/20150527035956_53077.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 12:00:08', '0', '0'),
('57', '345234', '长城葡萄酒 中粮长城特制宝石解百纳干红 750ml', 'Upload/goods/2015-05/55654198066e7.jpg', 'Upload/goods/2015-05/55654198066e7.jpg', null, '19', '455.00', '432.00', '23435', '0', '0', '0', '0', '瓶', '保质期：3650 天食品添加剂：焦亚硫酸钾品牌: Great Wall/长城系列: 长城特制宝石解百纳套装规格: 单支', '1', '1', '1', '1', '1', '1', '0', null, '49', '78', '294', '55', '64', '&lt;p&gt;\n	wstmall测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150527/20150527040229_68375.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 12:02:44', '0', '0'),
('58', '684564', '长城干红葡萄酒 特酿三年解百纳红酒750ml*6支', 'Upload/goods/2015-05/556542738dc8f.jpg', 'Upload/goods/2015-05/556542738dc8f.jpg', null, '19', '566.00', '411.00', '85321', '0', '0', '0', '0', '箱', '储藏方法：避光、卧放保质期：3650 天食品添加剂：焦亚硫酸钾品牌: Great Wall/长城系列: 特酿3年解百纳干红套装规格: 整箱', '1', '1', '1', '1', '1', '0', '0', null, '49', '78', '294', '55', '64', '&lt;p&gt;\n	wstmall测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150527/20150527040604_98645.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 12:06:06', '0', '0'),
('59', '354654', '正品拉菲红酒 法国原瓶进口拉菲珍藏波尔多干红葡萄酒', 'Upload/goods/2015-05/5565431b14689.jpg', 'Upload/goods/2015-05/5565431b14689.jpg', null, '19', '233.00', '133.00', '5345345', '0', '0', '0', '0', '箱', '2瓶一箱', '1', '1', '1', '1', '1', '1', '0', null, '49', '78', '294', '55', '62', '&lt;p&gt;\n	wstmall测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150527/20150527040848_71528.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 12:08:50', '0', '0'),
('60', '234234', '楼兰蜜语新疆特产零食小吃大枣红枣和田枣500g玉枣', 'Upload/goods/2015-05/55656eaf4c368.jpg', 'Upload/goods/2015-05/55656eaf4c368.jpg', null, '22', '42.00', '38.00', '234224', '0', '0', '0', '0', '包', '500g', '1', '1', '1', '1', '1', '1', '0', null, '50', '219', '226', '76', '77', '&lt;p style=&quot;color:#3F3F3F;font-family:simsun;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	规格：500g/袋\n&lt;/p&gt;\n&lt;p style=&quot;color:#3F3F3F;font-family:simsun;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	产地：新疆维吾尔自治区和田地区&lt;img src=&quot;/product/wstmall/Upload/image/20150527/20150527071518_35812.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;\n&lt;p style=&quot;color:#3F3F3F;font-family:simsun;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	功能：休闲零食&amp;nbsp;\n&lt;/p&gt;\n&lt;p style=&quot;color:#3F3F3F;font-family:simsun;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	食用方法：开袋即食\n&lt;/p&gt;\n&lt;p style=&quot;color:#3F3F3F;font-family:simsun;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	贮存方法：常温、密封保存\n&lt;/p&gt;\n&lt;p style=&quot;color:#3F3F3F;font-family:simsun;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	适用人群：老少、男女皆宜\n&lt;/p&gt;\n&lt;p style=&quot;color:#3F3F3F;font-family:simsun;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p style=&quot;color:#3F3F3F;font-family:simsun;font-size:12px;background-color:#FFFFFF;&quot;&gt;\n	&lt;br /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 15:15:35', '0', '0'),
('61', '234234', '良品铺子 若羌灰枣415g 新疆一级正宗红枣 皮薄', 'Upload/goods/2015-05/556570158edfd.jpg', 'Upload/goods/2015-05/556570158edfd.jpg', null, '22', '35.00', '30.00', '345345', '0', '0', '0', '0', '包', '', '1', '1', '1', '1', '1', '0', '0', null, '50', '219', '226', '76', '77', '&lt;h1 style=&quot;font-size:16px;font-family:\'microsoft yahei\';background-color:#FFFFFF;&quot;&gt;\n	良品铺子 若羌灰枣415g 新疆一级正宗红枣 皮薄核小\n&lt;/h1&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150527/20150527072039_39624.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 15:20:42', '0', '0'),
('62', '235345', '西域良品 若羌灰枣特级红枣500g 新疆枣子干', 'Upload/goods/2015-05/556570f099cf0.jpg', 'Upload/goods/2015-05/556570f099cf0.jpg', null, '22', '56.00', '50.00', '235345', '0', '0', '0', '0', '包', '', '1', '1', '1', '1', '1', '1', '0', null, '50', '219', '226', '76', '77', '&lt;h1 style=&quot;font-size:16px;font-family:\'microsoft yahei\';background-color:#FFFFFF;&quot;&gt;\n	&amp;nbsp;西域良品 若羌灰枣特级红枣500g 新疆枣子 干果零食\n&lt;/h1&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150527/20150527072501_44552.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 15:25:04', '0', '0'),
('63', '34523', '双汇火腿肠Q趣孜然味火腿肠85g 特产零食品香肠', 'Upload/goods/2015-05/556572b570dcf.jpg', 'Upload/goods/2015-05/556572b570dcf.jpg', null, '22', '23.00', '18.00', '234252', '0', '0', '0', '0', '包', '规格：85g/支\n产地：河南\n保质期：90天', '1', '1', '1', '1', '1', '0', '0', null, '50', '223', '330', '75', '81', '&lt;h1 style=&quot;font-size:16px;font-family:\'microsoft yahei\';background-color:#FFFFFF;&quot;&gt;\n	双汇火腿肠Q趣孜然味火腿肠85g 特产零食品香肠 小吃\n&lt;/h1&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150527/20150527073159_54890.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 15:32:05', '0', '0'),
('64', '234234', '双汇火腿肠王中王骨香风味30g*9支肉类零食香肠小', 'Upload/goods/2015-05/55657483bf521.jpg', 'Upload/goods/2015-05/55657483bf521.jpg', null, '22', '23.00', '21.00', '234234', '0', '0', '0', '0', '袋', '规格：30g*9支/袋', '1', '1', '1', '1', '1', '1', '0', null, '50', '223', '330', '75', '81', '&lt;p style=&quot;color:#404040;font-family:tahoma, arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;&quot;&gt;\n	规格：30g*9支/袋\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:tahoma, arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;&quot;&gt;\n	产地：中国大陆\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:tahoma, arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;&quot;&gt;\n	保质期：180天\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:tahoma, arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;&quot;&gt;\n	新老包装随机发货\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:tahoma, arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;&quot;&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p style=&quot;color:#404040;font-family:tahoma, arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;&quot;&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150527/20150527073942_46153.png&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 15:39:58', '0', '0'),
('65', '34535', '统一100 红烧牛肉面 103g*5包/袋 方便面', 'Upload/goods/2015-05/5565762b886fa.jpg', 'Upload/goods/2015-05/5565762b886fa.jpg', null, '22', '31.00', '23.00', '2345235', '0', '0', '0', '0', '包', '', '1', '1', '1', '1', '1', '1', '0', null, '50', '223', '232', '75', '81', '&lt;p&gt;\n	wstmall测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150527/20150527074756_24930.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 15:47:59', '0', '0'),
('66', '324234', '新加坡进口方便面 KOKA原味干捞快熟面85g*5', 'Upload/goods/2015-05/5565771503f78.jpg', 'Upload/goods/2015-05/5565771503f78.jpg', null, '22', '34.00', '23.00', '234234', '0', '0', '0', '0', '85g/袋*5小包', '规格：85g/袋*5小包\n\n产地：新加坡\n\n保质期：365天', '1', '1', '1', '1', '1', '1', '0', null, '50', '223', '232', '75', '82', '&lt;p&gt;\n	85g/袋*5小包\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150527/20150527075122_11947.png&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 15:51:24', '0', '0'),
('67', '2323423', '新加坡进口方便面 KOKA可口辣味星洲面85g*5', 'Upload/goods/2015-05/556579f34fbf9.jpg', 'Upload/goods/2015-05/556579f34fbf9.jpg', null, '22', '52.00', '45.00', '5622455', '0', '0', '0', '0', '包', '规格：85g/袋*5小包\n产地：新加坡\n保质期：365天', '1', '1', '1', '1', '1', '1', '0', null, '50', '223', '232', '75', '82', '&lt;table border=&quot;0&quot; cellpadding=&quot;0&quot; cellspacing=&quot;0&quot; width=&quot;750&quot; style=&quot;margin:0px;padding:0px;border-collapse:separate;color:#404040;font-family:tahoma, arial, 宋体, sans-serif;font-size:14px;background-color:#FFFFFF;&quot; class=&quot;ke-zeroborder&quot;&gt;\n	&lt;tbody&gt;\n		&lt;tr&gt;\n			&lt;td&gt;\n				&lt;p&gt;\n					规格：85g/袋*5小包\n				&lt;/p&gt;\n				&lt;p&gt;\n					产地：新加坡\n				&lt;/p&gt;\n				&lt;p&gt;\n					保质期：365天\n				&lt;/p&gt;\n				&lt;p&gt;\n					&amp;nbsp;&lt;img src=&quot;/product/wstmall/Upload/image/20150527/20150527080310_10271.jpg&quot; alt=&quot;&quot; /&gt;\n				&lt;/p&gt;\n			&lt;/td&gt;\n		&lt;/tr&gt;\n	&lt;/tbody&gt;\n&lt;/table&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 16:03:12', '0', '0'),
('68', '5465463', '幸运谷 团圆礼盒B款 干货礼盒 大枣 桂圆 核桃', 'Upload/goods/2015-05/55657baeb432b.jpg', 'Upload/goods/2015-05/55657baeb432b.jpg', null, '22', '234.00', '123.00', '124234', '0', '0', '0', '0', '盒', '食品保质期：12个月种类：桂圆国家：中国大陆进口/国产：国产净重(g)：2500', '1', '1', '1', '1', '1', '0', '0', null, '50', '219', '228', '76', '78', '&lt;p&gt;\n	食品保质期：12个月种类：桂圆国家：中国大陆进口/国产：国产净重(g)：2500\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150527/20150527081053_15009.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 16:10:59', '0', '0'),
('69', '2342', '闽龙达 大三元桂圆 500g/袋', 'Upload/goods/2015-05/556589e1c8fec.jpg', 'Upload/goods/2015-05/556589e1c8fec.jpg', null, '22', '45.00', '25.00', '5896221', '0', '0', '0', '0', '包', '规格参数\n食品保质期：365种类：桂圆国家：中国大陆进口/国产：国产净重(g)：500包装方式：袋装', '1', '1', '1', '1', '1', '1', '0', null, '50', '219', '225', '76', '79', '规格参数\n食品保质期：365种类：桂圆国家：中国大陆进口/国产：国产净重(g)：500包装方式：袋装', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 17:11:39', '0', '0'),
('70', '535345', '豪雄 福建桂圆肉 350g/袋', 'Upload/goods/2015-05/55658aa5c47cf.jpg', 'Upload/goods/2015-05/55658aa5c47cf.jpg', null, '22', '23.00', '21.00', '123213123', '0', '0', '0', '0', '包', '食品保质期：270种类：桂圆肉国家：中国大陆进口/国产：国产净重(g)：350', '1', '1', '1', '1', '1', '0', '0', null, '50', '219', '225', '76', '79', '&lt;p&gt;\n	食品保质期：270种类：桂圆肉国家：中国大陆进口/国产：国产净重(g)：350\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150527/20150527091402_35631.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 17:14:04', '0', '0'),
('71', '23425235', '山珍礼盒 744g 黑木耳 香菇 银耳 猴头菇', 'Upload/goods/2015-05/55658bbe19e29.jpg', 'Upload/goods/2015-05/55658bbe19e29.jpg', null, '22', '34.00', '23.00', '42335', '0', '0', '0', '0', '盒', '食品保质期：12个月种类：猴头菇国家：中国大陆进口/国产：国产净重(g)：744包装方式：礼盒', '1', '1', '1', '1', '1', '1', '0', null, '50', '219', '225', '76', '79', '食品保质期：12个月种类：猴头菇国家：中国大陆进口/国产：国产净重(g)：744包装方式：礼盒', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 17:18:48', '0', '0'),
('72', '234324', '百瑞源 宁夏枸杞500g', 'Upload/goods/2015-05/55658c7c032e7.jpg', 'Upload/goods/2015-05/55658c7c032e7.jpg', null, '22', '96.00', '52.00', '958658', '0', '0', '0', '0', '包', '净重(g)：500是否为有机食品：非有机国别：中国大陆食品保质期：365', '1', '1', '1', '1', '1', '1', '0', null, '50', '219', '224', '76', '79', '&lt;p&gt;\n	净重(g)：500是否为有机食品：非有机国别：中国大陆食品保质期：365\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150527/20150527092158_60276.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 17:22:03', '0', '0'),
('73', '2347923', '韩束红石榴化妆品套装 春夏补水保湿控油爽肤水乳液美', 'Upload/goods/2015-05/5565bff6050d5.jpg', 'Upload/goods/2015-05/5565bff6050d5.jpg', null, '26', '235.00', '200.00', '23492384', '0', '0', '0', '0', '套', '上市时间: 2009年颜色分类: 基础护肤套组 眼部护肤套组 夏季护肤套组 红石榴六件套(滋润)功效: 补水 保湿 控油 收缩毛孔 抗氧化 滋润 清洁毛孔规格类型: 正常规格品牌: Kans/韩束面部护理套装: 红石榴完美套装适合肤质: 任何肤质产地: 中国保质期: 5年', '1', '1', '1', '1', '1', '1', '0', null, '51', '167', '331', '88', '96', '&lt;p&gt;\n	wstmall测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150527/20150527130705_15748.gif&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 21:07:13', '0', '0'),
('74', '23748927', '墨菊化妆品套装五件套 爽肤水乳液春夏补水保湿护肤化', 'Upload/goods/2015-05/5565c3ab246ef.png', 'Upload/goods/2015-05/5565c3ab246ef.png', null, '26', '245.00', '210.00', '234923', '0', '0', '0', '0', '套', '', '1', '1', '1', '1', '1', '0', '0', null, '51', '167', '331', '88', '97', '&lt;p&gt;\n	wstmall测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150527/20150527131731_26353.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 21:17:34', '0', '0'),
('75', '234324', '红石榴化妆品套装 夏季补水保湿控油爽肤水乳液士护肤', 'Upload/goods/2015-05/5565c4634bb60.jpg', 'Upload/goods/2015-05/5565c4634bb60.jpg', null, '26', '345.00', '324.00', '2132424', '0', '0', '0', '0', '套', '', '1', '1', '1', '1', '1', '1', '0', null, '51', '167', '331', '88', '96', '&lt;p&gt;\n	wstmall测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150527/20150527132014_53275.gif&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 21:20:42', '0', '0'),
('76', '3324', '植美村bb霜化妆品套装正品玫瑰白皙去黄深层补水保湿', 'Upload/goods/2015-05/5565c52fbcdce.jpg', 'Upload/goods/2015-05/5565c52fbcdce.jpg', null, '26', '322.00', '233.00', '32423535', '0', '0', '0', '0', '套', '', '1', '1', '1', '1', '1', '1', '0', null, '51', '167', '331', '88', '96', '&lt;p&gt;\n	wstmall测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150527/20150527132335_39204.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 21:23:50', '0', '0'),
('77', '2342432', '韩后化妆品套装正品雪玲珑套装美白祛黄补水保湿面部', 'Upload/goods/2015-05/5565c5f6e2fa2.jpg', 'Upload/goods/2015-05/5565c5f6e2fa2.jpg', null, '26', '300.00', '278.00', '232432', '0', '0', '0', '0', '套', '', '1', '1', '1', '1', '1', '1', '0', null, '51', '167', '331', '88', '96', '&lt;p&gt;\n	wstmall测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150527/20150527132749_77810.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 21:28:01', '0', '0'),
('78', '3534534', '瑾泉化妆品正品套装护肤品套装女新活净白补水保湿白皙', 'Upload/goods/2015-05/5565c70e138da.jpg', 'Upload/goods/2015-05/5565c70e138da.jpg', null, '26', '456.00', '345.00', '2147483647', '0', '0', '0', '0', '套', '', '1', '1', '1', '1', '1', '0', '0', null, '51', '167', '331', '88', '96', '&lt;p&gt;\n	wstmall测试商品， 请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150527/20150527133149_74789.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 21:31:52', '0', '0'),
('79', '398473294', '美肤宝自然白套装化妆品护肤女士国货正品美白补水防晒', 'Upload/goods/2015-05/5565c7d90b5a5.jpg', 'Upload/goods/2015-05/5565c7d90b5a5.jpg', null, '26', '378.00', '299.00', '293482384', '0', '0', '0', '0', '套', '', '1', '1', '1', '1', '1', '0', '0', null, '51', '167', '331', '88', '96', '&lt;p&gt;\n	wstmall测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150527/20150527133456_45282.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 21:35:12', '0', '0'),
('80', '2374932', '兰可欣红石榴女士化妆品护肤套装 美白补水提亮保湿', 'Upload/goods/2015-05/5565c8a4ebde6.jpg', 'Upload/goods/2015-05/5565c8a4ebde6.jpg', null, '26', '234.00', '211.00', '324345', '0', '0', '0', '0', '套', '', '1', '1', '1', '1', '1', '1', '0', null, '51', '167', '331', '88', '96', '&lt;p&gt;\n	wstmall测试商品 请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150527/20150527133901_25801.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 21:39:04', '0', '0'),
('81', '2384792', '丝蓓绮洗护套装奢耀柔艳洗发水护发素套装 补水资生堂', 'Upload/goods/2015-05/5565cbbebc44f.jpg', 'Upload/goods/2015-05/5565cbbebc44f.jpg', null, '26', '134.00', '119.00', '124234', '0', '0', '0', '0', '套', '', '1', '1', '1', '1', '1', '1', '0', null, '51', '164', '184', '90', '93', '&lt;p&gt;\n	沐浴套装，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150527/20150527135155_68823.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 21:52:38', '0', '0'),
('82', '237498', 'COCO沐浴露洗发水护发素身体乳套装全身美白补水润', 'Upload/goods/2015-05/5565cca839a3b.jpg', 'Upload/goods/2015-05/5565cca839a3b.jpg', null, '26', '234.00', '213.00', '2423423', '0', '0', '0', '0', '套', '', '1', '1', '1', '1', '1', '0', '0', null, '51', '164', '184', '90', '93', '&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	wstmall测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150527/20150527135542_95827.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 21:56:01', '0', '0'),
('83', '77979', '霸王女士防脱洗发水套装1200ml 防脱发掉发断发', 'Upload/goods/2015-05/5565ce1f1eb14.jpg', 'Upload/goods/2015-05/5565ce1f1eb14.jpg', null, '26', '134.00', '112.00', '4324234', '0', '0', '0', '0', '套', '', '1', '1', '1', '1', '1', '0', '0', null, '51', '164', '184', '90', '93', '&lt;p&gt;\n	&lt;strong&gt;&lt;span style=&quot;font-size:24px;&quot;&gt;wstmall测试商品&lt;/span&gt;&lt;/strong&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150527/20150527140233_51127.jpg&quot; /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 22:03:05', '0', '0'),
('84', '3522234', '韩国进口ks爱敬kerasys东洋顺滑洗发水护发素', 'Upload/goods/2015-05/5565cf60af461.jpg', 'Upload/goods/2015-05/5565cf60af461.jpg', null, '26', '324.00', '234.00', '0', '0', '0', '0', '0', '套', '', '1', '1', '1', '1', '1', '0', '0', null, '51', '164', '184', '90', '93', '&lt;h3&gt;\n	wstmall测试商品，请勿下单\n&lt;/h3&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150527/20150527140726_62830.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 22:08:28', '0', '0'),
('85', '35345', '洗发水护发素套装 正品 优妮 深层修复滋养洗发露', 'Upload/goods/2015-05/5565d037c631b.jpg', 'Upload/goods/2015-05/5565d037c631b.jpg', null, '26', '50.00', '45.00', '2344', '0', '0', '0', '0', '套', '', '1', '1', '1', '1', '1', '0', '0', null, '51', '164', '184', '90', '93', '&lt;p&gt;\n	wstmall测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150527/20150527141208_30165.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 22:12:15', '0', '0'),
('86', '234324', '洗发水护发素套装 深层修复原装正品共3瓶增250m', 'Upload/goods/2015-05/5565d106dc0ae.jpg', 'Upload/goods/2015-05/5565d106dc0ae.jpg', null, '26', '345.00', '245.00', '6878689', '0', '0', '0', '0', '套', '', '1', '1', '1', '1', '1', '1', '0', null, '51', '164', '184', '90', '93', '&lt;p&gt;\n	&lt;span style=&quot;font-size:18px;&quot;&gt;wstmall洗浴套装，商品测试&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150527/20150527141417_73978.jpg&quot; /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 22:14:41', '0', '0'),
('87', '233454', '正品拉芳COCO香水洗发水+护发素+沐浴露 洗护套', 'Upload/goods/2015-05/5565d1e7a5082.jpg', 'Upload/goods/2015-05/5565d1e7a5082.jpg', null, '26', '87.00', '78.00', '324325', '0', '0', '0', '0', '套', '', '1', '1', '1', '1', '1', '0', '0', null, '51', '164', '184', '90', '93', '&lt;ul id=&quot;J_AttrUL&quot; style=&quot;color:#404040;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	&lt;li style=&quot;color:#666666;vertical-align:top;&quot;&gt;\n		功效:&amp;nbsp;柔软顺滑&amp;nbsp;去屑止痒&amp;nbsp;深层修复&amp;nbsp;深度清洁&amp;nbsp;滋润营养&amp;nbsp;脆弱开叉护理&amp;nbsp;丰盈蓬松&amp;nbsp;改善毛躁&amp;nbsp;改善头痒&amp;nbsp;强韧防断发&amp;nbsp;控油&amp;nbsp;头皮舒缓&amp;nbsp;滋润&amp;nbsp;补水\n	&lt;/li&gt;\n	&lt;li id=&quot;J_attrBrandName&quot; style=&quot;color:#666666;vertical-align:top;&quot;&gt;\n		品牌:&amp;nbsp;拉芳\n	&lt;/li&gt;\n	&lt;li style=&quot;color:#666666;vertical-align:top;&quot;&gt;\n		型号:&amp;nbsp;COCO香氛洗发水护发素沐浴露套装\n	&lt;/li&gt;\n	&lt;li style=&quot;color:#666666;vertical-align:top;&quot;&gt;\n		是否量贩装:&amp;nbsp;是\n	&lt;/li&gt;\n	&lt;li style=&quot;color:#666666;vertical-align:top;&quot;&gt;\n		净含量:&amp;nbsp;其他\n	&lt;/li&gt;\n	&lt;li style=&quot;color:#666666;vertical-align:top;&quot;&gt;\n		适用对象:&amp;nbsp;通用\n	&lt;/li&gt;\n	&lt;li style=&quot;color:#666666;vertical-align:top;&quot;&gt;\n		规格类型:&amp;nbsp;套装\n	&lt;/li&gt;\n	&lt;li style=&quot;color:#666666;vertical-align:top;&quot;&gt;\n		件数:&amp;nbsp;3件\n	&lt;/li&gt;\n	&lt;li style=&quot;color:#666666;vertical-align:top;&quot;&gt;\n		保质期:&amp;nbsp;3年\n	&lt;/li&gt;\n	&lt;li style=&quot;color:#666666;vertical-align:top;&quot;&gt;\n		产地:&amp;nbsp;中国大陆\n	&lt;/li&gt;\n	&lt;li style=&quot;color:#666666;vertical-align:top;&quot;&gt;\n		适用发质:&amp;nbsp;所有发质\n	&lt;/li&gt;\n	&lt;li style=&quot;color:#666666;vertical-align:top;&quot;&gt;\n		是否进口:&amp;nbsp;国产\n	&lt;/li&gt;\n	&lt;li style=&quot;color:#666666;vertical-align:top;&quot;&gt;\n	&lt;/li&gt;\n&lt;/ul&gt;\n&lt;ul style=&quot;color:#404040;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n&lt;/ul&gt;\n&lt;ul style=&quot;color:#404040;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n&lt;/ul&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 22:18:14', '0', '0'),
('88', '87687', '资生堂日本原装进口丝蓓绮奢华光艳洗发水220ml*', 'Upload/goods/2015-05/5565d2a7b6145.jpg', 'Upload/goods/2015-05/5565d2a7b6145.jpg', null, '26', '89.00', '76.00', '569008', '0', '0', '0', '0', '套', '', '1', '1', '1', '1', '1', '1', '0', null, '51', '164', '184', '90', '93', '&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;font-size:18px;&quot;&gt;wstmall测试商品，请勿下单&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150527/20150527142118_69570.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 22:21:34', '0', '0'),
('89', '32253', '风味猪肉脯自然片200g 靖江特产 休闲零食', 'Upload/goods/2015-05/5565e0d8e9641.jpg', 'Upload/goods/2015-05/5565e0d8e9641.jpg', null, '30', '34.00', '23.00', '34235345', '0', '0', '0', '0', '包', '200克每包', '1', '1', '0', '1', '1', '1', '0', null, '52', '190', '205', '98', '106', '&lt;p&gt;\n	wstmall测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150527/20150527152216_79172.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 23:22:19', '0', '0'),
('90', '3579284', '百草味 白芝麻猪肉脯180g 靖江特产零食独立小包', 'Upload/goods/2015-05/5565e20c175b5.jpg', 'Upload/goods/2015-05/5565e20c175b5.jpg', null, '30', '34.00', '25.00', '243424', '0', '0', '0', '0', '包', '', '1', '1', '1', '1', '1', '1', '0', null, '52', '190', '205', '98', '106', '&lt;p&gt;\n	&lt;em&gt;&lt;span style=&quot;font-size:16px;&quot;&gt;wstmall测试商品，请勿下单&lt;/span&gt;&lt;/em&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;em&gt;&lt;span style=&quot;font-size:16px;&quot;&gt;&lt;/span&gt;&lt;/em&gt;&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;em&gt;&lt;span style=&quot;font-size:16px;&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150527/20150527152716_33571.jpg&quot; /&gt;&lt;/span&gt;&lt;/em&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;em&gt;&lt;/em&gt;&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;em&gt;&lt;/em&gt;&amp;nbsp;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 23:27:18', '0', '0'),
('91', '354', '良品铺子 麻辣灯影牛肉丝250g重庆特产休闲零食', 'Upload/goods/2015-05/5565e2eca30d7.jpg', 'Upload/goods/2015-05/5565e2eca30d7.jpg', null, '30', '34.00', '24.00', '2435354', '0', '0', '0', '0', '包', '', '1', '1', '1', '1', '1', '1', '0', null, '52', '190', '205', '98', '106', '&lt;p&gt;\n	&lt;strong&gt;&lt;span style=&quot;font-size:18px;&quot;&gt;wstmall测试商品&lt;/span&gt;&lt;/strong&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150527/20150527153117_59023.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 23:31:28', '0', '0'),
('92', '354', '良品铺子 麻辣灯影牛肉丝250g重庆特产休闲零食', 'Upload/goods/2015-05/5565e2eca30d7.jpg', 'Upload/goods/2015-05/5565e2eca30d7.jpg', null, '30', '34.00', '24.00', '2435354', '0', '0', '0', '0', '包', '', '0', '1', '1', '1', '1', '0', '0', null, '52', '190', '205', '98', '106', '&lt;p&gt;\n	&lt;strong&gt;&lt;span style=&quot;font-size:18px;&quot;&gt;wstmall测试商品&lt;/span&gt;&lt;/strong&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150527/20150527153117_59023.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 23:31:32', '0', '0'),
('93', '354', '良品铺子 麻辣灯影牛肉丝250g重庆特产休闲零食', 'Upload/goods/2015-05/5565e2eca30d7.jpg', 'Upload/goods/2015-05/5565e2eca30d7.jpg', null, '30', '34.00', '24.00', '2435354', '0', '0', '0', '0', '包', '', '0', '1', '1', '1', '1', '1', '0', null, '52', '190', '205', '98', '106', '&lt;p&gt;\n	&lt;strong&gt;&lt;span style=&quot;font-size:18px;&quot;&gt;wstmall测试商品&lt;/span&gt;&lt;/strong&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150527/20150527153117_59023.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 23:31:34', '0', '0'),
('94', '86788', '姚太太 香辣鸭脖子200g 独立小包装卤味熟食鸭肉', 'Upload/goods/2015-05/5565e478a8ab7.jpg', 'Upload/goods/2015-05/5565e478a8ab7.jpg', '0', '30', '89.00', '67.00', '3424', '0', '0', '0', '0', '78', '', '1', '1', '1', '1', '1', '1', '0', null, '52', '190', '208', '98', '106', '&lt;p&gt;\n	&lt;strong&gt;&lt;span style=&quot;font-size:18px;&quot;&gt;wstmall测试商品&lt;/span&gt;&lt;/strong&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150527/20150527154106_36152.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 23:42:00', '0', '0'),
('95', '86898', '萨啦咪卤制 焗盐双翅66g 休闲零食温州特产美味', 'Upload/goods/2015-05/5565e680acb2f.jpg', 'Upload/goods/2015-05/5565e680acb2f.jpg', '0', '30', '65.00', '45.00', '8767856', '0', '0', '0', '0', '78', '', '1', '1', '1', '1', '1', '1', '0', null, '52', '190', '208', '98', '106', '&lt;p&gt;\n	测试商品 请勿下载\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150527/20150527154646_57543.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 23:46:51', '0', '0'),
('96', '8678', '香巴佬 香酥鸭腿35g/袋 鸭腿 乡巴佬 温州风味', 'Upload/goods/2015-05/5565e757750a7.jpg', 'Upload/goods/2015-05/5565e757750a7.jpg', '10', '30', '67.00', '56.00', '674675', '0', '0', '0', '0', '789', '', '1', '1', '1', '1', '1', '1', '0', null, '52', '190', '208', '98', '105', '&lt;p&gt;\n	wstmall 测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150527/20150527154937_22172.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 23:49:59', '0', '0'),
('97', '7565', '绿盛百卤坊酱鸭舌50g/袋 鸭舌 鸭舌头 原味鸭舌', 'Upload/goods/2015-05/5565e7f76cd33.jpg', 'Upload/goods/2015-05/5565e7f76cd33.jpg', '13', '30', '56.00', '45.00', '76565', '0', '0', '0', '0', '6', '', '1', '1', '1', '1', '1', '1', '0', null, '52', '190', '208', '98', '106', '&lt;p&gt;\n	wstmall测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150527/20150527155242_52695.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 23:52:52', '0', '0'),
('98', '75674', '黄胜记猪肉松150g 厦门特产肉干休闲美味小吃零食', 'Upload/goods/2015-05/5565e8bea28ad.jpg', 'Upload/goods/2015-05/5565e8bea28ad.jpg', '9', '30', '23.00', '12.00', '2324', '0', '0', '0', '0', '34', '', '1', '1', '1', '1', '1', '1', '0', null, '52', '190', '207', '98', '104', '&lt;p&gt;\n	测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150527/20150527155532_43925.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 23:55:36', '0', '0'),
('99', '32523', '徽记川辣子蚕豆202g麻辣味四川特产下酒菜休闲零食', 'Upload/goods/2015-05/5565e9a9b6768.jpg', 'Upload/goods/2015-05/5565e9a9b6768.jpg', '0', '30', '123.00', '67.00', '2342354', '0', '0', '0', '0', '23', '', '1', '1', '1', '1', '1', '1', '0', null, '52', '189', '199', '98', '104', '&lt;p&gt;\n	测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150527/20150527155939_97478.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-27 23:59:59', '0', '0'),
('100', 'A001', '情侣对戒', 'Upload/goods/2015-05/5566ae4c3264c.jpg', 'Upload/goods/2015-05/5566ae4c3264c.jpg', '17', '10', '0.00', '0.00', '0', '0', '0', '0', '0', '阿萨德', '阿萨的', '0', '1', '1', '1', '1', '0', '0', null, '51', '166', '176', '107', '108', '阿萨德阿萨的', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-28 13:57:58', '0', '0'),
('101', '23424', '马齿苋(长寿菜)', 'Upload/goods/2015-05/556ad57b1b3c2.jpg', 'Upload/goods/2015-05/556ad57b1b3c2.jpg', '0', '12', '5.00', '4.00', '1234', '0', '0', '0', '0', '千克', '包装规格：250g/盒', '1', '1', '1', '1', '1', '0', '0', null, '47', '62', '254', '112', '115', '&lt;h4 style=&quot;color:#666666;font-family:宋体, Verdana, Arial;&quot;&gt;\n	&lt;span style=&quot;font-size:small;&quot;&gt;&lt;strong&gt;&lt;span style=&quot;color:#FF0000;&quot;&gt;有机马齿苋在生产种植过程中绝不适用农药、化肥、生产调节剂及有毒有害化学合成的物质，而是遵循自然规律和生态学原理；从而使人食用以后无有毒有害物质，在人体内的有毒有害物质的累加效应的产生，使人身体更健康、更快乐，这是普通马齿苋无法达到的作用。本商品是真正的有机蔬菜，由专业有机认证机构认证，可登陆“中国食品农产品认证信息系统”输入我们的证书号查询&lt;/span&gt;&lt;/strong&gt;&lt;/span&gt;\n&lt;/h4&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-31 17:35:33', '0', '0'),
('102', '3535435', '有机莴笋500g', 'Upload/goods/2015-05/556ad7bf2ad0e.jpg', 'Upload/goods/2015-05/556ad7bf2ad0e.jpg', '20', '12', '20.00', '17.00', '12313', '0', '0', '0', '0', '千克', '包装规格：500g/袋', '1', '1', '1', '1', '1', '0', '0', null, '47', '62', '254', '112', '115', '&lt;p style=&quot;color:#666666;font-family:宋体, Verdana, Arial;&quot;&gt;\n	&lt;strong&gt;&amp;nbsp;&lt;span style=&quot;font-size:small;&quot;&gt;营养价值&lt;/span&gt;&lt;/strong&gt;\n&lt;/p&gt;\n&lt;p style=&quot;color:#666666;font-family:宋体, Verdana, Arial;&quot;&gt;\n	&lt;strong&gt;&lt;span style=&quot;font-size:small;&quot;&gt;&lt;br /&gt;\n&lt;/span&gt;&lt;/strong&gt;&lt;span style=&quot;font-size:small;&quot;&gt;1、开通疏利、消积下气：莴苣味道清新且略带苦味，可刺激消化酶分泌，增进食欲。其乳状浆液，可增强胃液、消化腺的分泌和胆汁的分泌，从而促进各消化器官的功能，对消化功能减弱、消化道中酸性降低和便秘的病人尤其有利；&lt;/span&gt;\n&lt;/p&gt;\n&lt;p style=&quot;color:#666666;font-family:宋体, Verdana, Arial;&quot;&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p style=&quot;color:#666666;font-family:宋体, Verdana, Arial;&quot;&gt;\n	&lt;span style=&quot;font-size:small;&quot;&gt;2、利尿通乳：莴苣钾含量大大高于钠含量，有利于体内的水电解质平衡，促进排尿和&lt;/span&gt;&lt;span style=&quot;font-size:small;&quot;&gt;乳汁的分泌。对高血压、水肿、心脏病人有一定的食疗作用；&lt;/span&gt;\n&lt;/p&gt;\n&lt;p style=&quot;color:#666666;font-family:宋体, Verdana, Arial;&quot;&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p style=&quot;color:#666666;font-family:宋体, Verdana, Arial;&quot;&gt;\n	&lt;span style=&quot;font-size:small;&quot;&gt;3、强壮机体、防癌抗癌：莴苣含有多种维生素和矿物质，具有调节神经系统功能的作用，其所含有机化含物中富含人体可吸收的铁元素，对有缺铁性贫血病人十分有利。莴苣的热水提取物对某些癌细胞有很高的抑制率，故又可用来防癌抗癌；&lt;/span&gt;\n&lt;/p&gt;\n&lt;p style=&quot;color:#666666;font-family:宋体, Verdana, Arial;&quot;&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p style=&quot;color:#666666;font-family:宋体, Verdana, Arial;&quot;&gt;\n	&lt;span style=&quot;font-size:small;&quot;&gt;4、宽肠通便：莴苣含有大量植物纤维素，能促进肠壁蠕动，通利消化道，帮助大便排泄，可用于治疗各种便秘。&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-31 17:52:18', '0', '0'),
('103', '384782', '黑冰有机无花果热销中（1斤装）', 'Upload/goods/2015-05/556ada2a6686f.jpg', 'Upload/goods/2015-05/556ada2a6686f.jpg', '19', '12', '60.00', '58.00', '24322', '0', '0', '0', '0', '千克', '1斤装 盒装', '1', '1', '1', '1', '1', '0', '0', null, '47', '62', '254', '112', '115', '商品详情：\n黑冰有机无花果\n规格：1斤装/盒\n价格：58元/斤\n特色：黑冰牌有机无花果属于有机食品，源自黑冰有机农场，无化学农药、无化肥，无添加剂，口感自然清香；\n功效：中医认为无花果性质平和，味甘，能够健胃，清肠，消肿解毒，可以用来治疗肠炎，痢疾，便秘，痔疮，喉痛及痈疮疥癣等。', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-31 17:54:32', '0', '0'),
('104', '398472', '有机菠菜(250g/盒)', 'Upload/goods/2015-05/556adbbcd341d.jpg', 'Upload/goods/2015-05/556adbbcd341d.jpg', '20', '12', '24.00', '23.00', '53453', '0', '0', '0', '0', '盒', '250g/盒', '1', '1', '1', '1', '1', '0', '0', null, '47', '62', '254', '112', '115', '菠菜营养成分极其丰富，菠菜叶含锌56～68毫克/公斤(干重)，叶酸1.22微克/克，氨基酸和叶黄素、β-胡萝卜素、新-β-胡萝卜素B、新-β-胡萝卜;菠菜素U等类胡萝卜素、还含α-菠菜甾醇、胆甾醇以及甾醇酯和甾醇甙、万寿菊素、菠叶素，和一种青紫色萤光物质2-乙酰基-3-对羟基苯丙烯酰基内消旋酒石酸;根含菠菜皂甙A和B每100克含水分91.8克，蛋白质2.4克，脂肪0.5克，碳水化合物3.1克，粗纤维0.7克，灰分1.5克，胡萝卜素 3.87毫克，维生素B10.04毫克，维生素B20.13毫克，尼克酸0.6毫克，维生素C 39毫克，钙72毫克，磷53毫克，铁1.8毫克，钾502毫克，钠98.6毫克，镁34.3毫克，氯200毫克。热量 (24.00千卡) ·维生素B6 (0.30毫克) · ·脂肪 (0.30克) ·泛酸 (0.20毫克) · ·叶酸 (110.00微克) ·膳食纤维 (1.70克) ·维生素A (487.00微克) · ·硫胺素 (0.04毫克) ·核黄素 (0.11毫克) ·尼克酸 (0.60毫克) 维生素E (1.74毫克) ·锌 (0.85毫克) ·硒 (0.97微克) ·铜 (0.10毫克) ·锰 (0.66毫克) 钾 (311.00毫克)\n \n1、 通肠导便、防治痔疮：菠菜含有大量的植物粗纤维，具有促进肠道蠕动的作用，利于排便，且能促进胰腺分泌，帮助消化。对于痔疮、慢性胰腺炎、便秘、肛裂等病症有治疗作用 　　\n2、 促进生长发育、增强抗病能力：菠菜中所含的胡萝卜素，在人体内转变成维生素A，能维护正常视力和上皮细胞的健康，增加预防传染病的能力，促进儿童生长发育。\n3、保障营养、增进健康：菠菜中含有丰富的胡萝卜素、维生素C、钙、磷及一定量的铁、维生素E等有益成分，能供给人体多种营养物质；其所含铁质，对缺铁性贫血有较好的辅助治疗作用 　　\n4、促进人体新陈代谢：菠菜中所含微量元素物质，能促进人体新陈代谢，增进身体健康。大量食用菠菜，可降低中风的危险 　　\n5． 清洁皮肤、抗衰老：菠菜提取物具有促进培养细胞增殖的作用，既抗衰老又能增强青春活力。中国民间以菠菜捣烂取汁，每周洗脸数次，连续使用一段时间，可清洁皮肤毛孔，减少皱纹及色素斑，保持皮肤光洁。', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-31 18:01:01', '0', '0'),
('105', '35345', '有机西兰花(400g/盒)', 'Upload/goods/2015-05/556adc06211b7.jpg', 'Upload/goods/2015-05/556adc06211b7.jpg', '20', '12', '23.00', '20.00', '234235', '0', '0', '0', '0', '盒', '400g/盒', '1', '1', '1', '1', '1', '0', '0', null, '47', '62', '254', '112', '115', '有机西兰花在生产种植过程中绝不适用农药、化肥、生产调节剂及有毒有害化学合成的物质，而是遵循自然规律和生态学原理；从而使人食用以后无有毒有害物质，在人体内的有毒有害物质的累加效应的产生，使人身体更健康、更快乐，这是普通西兰花无法达到的作用。本商品是真正的有机蔬菜，由专业有机认证机构认证，可登陆“中国食品农产品认证信息系统”输入我们的证书号查询', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-31 18:02:36', '0', '0'),
('106', '34539', '一号农场 有机新鲜蔬菜套餐 蔬菜1.8KG单次卡', 'Upload/goods/2015-05/556add323cd84.jpg', 'Upload/goods/2015-05/556add323cd84.jpg', '21', '12', '100.00', '85.00', '353498', '0', '0', '0', '0', '千克', '', '1', '1', '1', '1', '1', '0', '0', null, '47', '62', '254', '112', '115', '&lt;p&gt;\n	友情提醒：因为是体验特惠套餐，每个ID，每个地址，每个手机限购1次哦！！\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150531/20150531100916_97525.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-31 18:07:30', '0', '0'),
('107', '33948739', '礼品卡 1088C套餐 现摘配送 全程冷链四点半前', 'Upload/goods/2015-05/556adeb90abba.jpg', 'Upload/goods/2015-05/556adeb90abba.jpg', '21', '12', '2000.00', '1088.00', '866767', '0', '0', '0', '0', '千克', '每次8份，一共6次', '1', '1', '1', '1', '1', '0', '0', null, '47', '62', '253', '112', '115', '&lt;p&gt;\n	201310161012234526\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150531/20150531101358_99964.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-31 18:14:28', '0', '0'),
('108', '374928', '家鲜 西兰花 凌晨采购 全程冷链', 'Upload/goods/2015-05/556adfc15c22b.jpg', 'Upload/goods/2015-05/556adfc15c22b.jpg', '22', '12', '234.00', '123.00', '242342', '0', '0', '0', '0', '克', '约500g/份', '1', '1', '1', '1', '1', '0', '0', null, '47', '62', '255', '112', '114', '&lt;p&gt;\n	&lt;a class=&quot;on li_gwSelect_b&quot;&gt;约500g/份&lt;/a&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;a class=&quot;on li_gwSelect_b&quot;&gt;&lt;br /&gt;\n&lt;/a&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;a class=&quot;on li_gwSelect_b&quot;&gt;&lt;img src=&quot;/product/wstmall/Upload/image/20150531/20150531101838_76030.jpg&quot; alt=&quot;&quot; /&gt;&lt;br /&gt;\n&lt;/a&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-31 18:18:40', '0', '0'),
('109', '453454', '私房菜现做现卖BCP-29 鱼香肉丝225g', 'Upload/goods/2015-05/556b086948b12.jpg', 'Upload/goods/2015-05/556b086948b12.jpg', '23', '12', '35.00', '31.00', '23422423', '0', '0', '0', '0', '包', '225克每包', '1', '1', '1', '1', '1', '0', '0', null, '47', '63', '318', '124', '125', '&lt;p&gt;\n	新雅食品\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150531/20150531131231_29855.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-31 21:12:32', '0', '0'),
('110', '325435', '可乐鸡中翅', 'Upload/goods/2015-05/556b09c99ee67.jpg', 'Upload/goods/2015-05/556b09c99ee67.jpg', '24', '12', '24.00', '20.00', '42334', '0', '0', '0', '0', '包', '200克每包', '1', '1', '1', '1', '1', '0', '0', null, '47', '63', '318', '124', '125', '测试商品，请勿下单', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-31 21:18:00', '0', '0'),
('111', '345353', '新雅半成品BCP-34盐焗鸡翅225g/盒 无穷美', 'Upload/goods/2015-05/556b0a573e8a9.jpg', 'Upload/goods/2015-05/556b0a573e8a9.jpg', '23', '12', '34.00', '29.00', '3523423', '0', '0', '0', '0', '盒', '225g/盒', '1', '1', '1', '1', '1', '0', '0', null, '47', '63', '318', '124', '125', '&lt;p&gt;\n	测试商品 请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150531/20150531132018_26169.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-31 21:20:34', '0', '0'),
('112', '23324', 'BCP-28冷冻半成品菜家常豆腐225克/盒', 'Upload/goods/2015-05/556b0b0fbb724.jpg', 'Upload/goods/2015-05/556b0b0fbb724.jpg', '23', '12', '35.00', '32.00', '324234', '0', '0', '0', '0', '盒', '225克/盒', '1', '1', '1', '1', '1', '0', '0', null, '47', '63', '318', '124', '125', '新雅食品\n\n测试商品，请勿下单', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-31 21:24:16', '0', '0'),
('113', '2234', '冷冻半成品菜BCP-12 蚝油牛肉 就餐必点招牌菜', 'Upload/goods/2015-05/556b0bf3850b6.jpg', 'Upload/goods/2015-05/556b0bf3850b6.jpg', '23', '12', '45.00', '42.00', '234234', '0', '0', '0', '0', '盒', '225g/盒', '1', '1', '1', '1', '1', '0', '0', null, '47', '63', '318', '124', '125', '&lt;p&gt;\n	新雅食品\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150531/20150531132655_31464.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-31 21:27:12', '0', '0'),
('114', '4535', '冷冻半成品BCP-08 黑椒牛排  225g/盒', 'Upload/goods/2015-05/556b0f081380a.jpg', 'Upload/goods/2015-05/556b0f081380a.jpg', '23', '12', '67.00', '45.00', '343453', '0', '0', '0', '0', '盒', ' 225g/盒', '1', '1', '1', '1', '1', '0', '0', null, '47', '63', '318', '124', '125', '&lt;p&gt;\n	测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150531/20150531133911_50275.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-31 21:39:24', '0', '0'),
('115', '32424', '粤菜馆 BCP-28冷冻半成品菜家常豆腐225g', 'Upload/goods/2015-05/556b0f55de11a.jpg', 'Upload/goods/2015-05/556b0f55de11a.jpg', '23', '12', '56.00', '45.00', '35345', '0', '0', '0', '0', '盒', '225g/盒', '1', '1', '1', '1', '1', '0', '0', null, '47', '63', '318', '124', '125', '&lt;p&gt;\n	新雅食品\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150531/20150531134119_12727.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-31 21:41:21', '0', '0'),
('116', '234223', '十头鲍鱼仔（每只配粉丝、蒜蓉次日12点发货外围不送', 'Upload/goods/2015-05/556b10c8c0b33.jpg', 'Upload/goods/2015-05/556b10c8c0b33.jpg', '21', '4', '36.00', '23.00', '300', '0', '0', '0', '0', '225克一盒', '', '1', '1', '1', '1', '1', '0', '0', null, '47', '65', '288', '28', '30', '&lt;p&gt;\n	测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150531/20150531134818_53390.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '2', '', '1', null, '2015-05-31 21:48:20', '0', '0'),
('117', '35354', '北极贝拼三文鱼（超新鲜刺身三文鱼净肉150g', 'Upload/goods/2015-05/556b11d28f92f.jpg', 'Upload/goods/2015-05/556b11d28f92f.jpg', '24', '4', '657.00', '650.00', '300', '0', '0', '0', '0', '盒', '190克/盒', '1', '1', '1', '1', '1', '0', '0', null, '47', '65', '288', '28', '29', '测试商品，请勿下单', '0', '0', '0', '0', '1', null, '2', '', '1', null, '2015-05-31 21:53:49', '0', '0'),
('118', '35353', 'FINE FOOD 烟熏三文鱼切片 150G/袋', 'Upload/goods/2015-05/556b13a826385.jpg', 'Upload/goods/2015-05/556b13a826385.jpg', '24', '13', '34.00', '23.00', '23353', '0', '0', '0', '0', '袋', '150G/袋', '1', '1', '1', '1', '1', '0', '0', null, '47', '66', '332', '127', '128', '&lt;p&gt;\n	测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150531/20150531140018_93097.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-31 22:00:29', '0', '0'),
('119', '86834', 'FINE FOOD 裹面包屑凤尾虾 460G', 'Upload/goods/2015-05/556b14281d098.jpg', 'Upload/goods/2015-05/556b14281d098.jpg', '19', '13', '34.00', '23.00', '325324', '0', '0', '0', '0', '盒', ' 460G/盒', '1', '1', '1', '1', '1', '0', '0', null, '47', '66', '332', '127', '128', '测试商品，请勿下单', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-31 22:01:51', '0', '0'),
('120', '353545', 'SF定海针粒冻虾仁 200-300 250G/袋', 'Upload/goods/2015-05/556b14668ae61.jpg', 'Upload/goods/2015-05/556b14668ae61.jpg', '19', '13', '56.00', '45.00', '2342353', '0', '0', '0', '0', '袋', '250G/袋', '1', '1', '1', '1', '1', '0', '0', null, '47', '66', '332', '127', '128', '&lt;p&gt;\n	测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;font-family:Tahoma, \'microsoft yahei\';font-size:20px;font-weight:bold;line-height:28px;background-color:#FFFFFF;&quot;&gt;SF定海针粒冻虾仁 200-300 250G/袋&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150531/20150531140255_47878.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-31 22:02:57', '0', '0'),
('121', '3535', '扇贝 8-9枚 375G/袋', 'Upload/goods/2015-05/556b1c2d47fe2.jpg', 'Upload/goods/2015-05/556b1c2d47fe2.jpg', '19', '13', '35.00', '27.00', '323235', '0', '0', '0', '0', '袋', '【品名】：扇贝 8-9枚 375G/袋\n【品牌】：新海宝\n【净含量】：375G\n【原产地】：福建福州\n【配料】：扇贝\n【生产日期】：见包装\n【保质期限】：≤-18℃18个月', '1', '1', '1', '1', '1', '0', '0', null, '47', '66', '332', '127', '128', '【品名】：扇贝 8-9枚 375G/袋\n【品牌】：新海宝\n【净含量】：375G\n【原产地】：福建福州\n【配料】：扇贝\n【生产日期】：见包装\n【保质期限】：≤-18℃18个月', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-31 22:37:35', '0', '0'),
('122', '334534', 'SF东海大黄鱼200-300G 500G', 'Upload/goods/2015-05/556b1cca6fcc9.jpg', 'Upload/goods/2015-05/556b1cca6fcc9.jpg', '19', '13', '56.00', '53.00', '34535345', '0', '0', '0', '0', '袋', '', '1', '1', '1', '1', '1', '0', '0', null, '47', '66', '332', '127', '128', 'SF东海大黄鱼200-300G 500G', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-31 22:39:06', '0', '0'),
('123', '23543534', 'SF 定海针水晶虾仁抽肠 70/100 750G', 'Upload/goods/2015-05/556b1d2981c09.jpg', 'Upload/goods/2015-05/556b1d2981c09.jpg', '19', '13', '67.00', '34.00', '23325435', '0', '0', '0', '0', '袋', '【品名】SF 定海针水晶虾仁抽肠 70/100 750G\n【品牌】定海针\n【配料】海洋捕捞虾、水、食品添加剂\n【贮存条件】冷藏\n【净含量】750G', '1', '1', '1', '1', '1', '0', '0', null, '47', '66', '332', '127', '128', '&lt;strong&gt;&lt;span&gt;【品名】SF 定海针水晶虾仁抽肠 70/100 750G&lt;br /&gt;\n【品牌】定海针&lt;br /&gt;\n【配料】海洋捕捞虾、水、食品添加剂&lt;br /&gt;\n【贮存条件】冷藏&lt;br /&gt;\n【净含量】750G&lt;/span&gt;&lt;/strong&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-31 22:40:37', '0', '0'),
('124', '543346456', '新雅粤菜馆 冷冻半成品私房菜BCP-09 三鲜汤3', 'Upload/goods/2015-05/556b1d96836e7.jpg', 'Upload/goods/2015-05/556b1d96836e7.jpg', '19', '13', '45.00', '34.00', '65464', '0', '0', '0', '0', '袋', '', '1', '1', '1', '1', '1', '0', '0', null, '47', '71', '320', '127', '128', '新雅粤菜馆 冷冻半成品私房菜BCP-09 三鲜汤300g 当天16点之前提交的订单，当天发货', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-31 22:42:05', '0', '0'),
('125', '45336', '新雅BCP-18酸汤肥牛225g 酒店半成品肉类私', 'Upload/goods/2015-05/556b1dd367c42.jpg', 'Upload/goods/2015-05/556b1dd367c42.jpg', '19', '13', '56.00', '34.00', '23425', '0', '0', '0', '0', '盘', '', '1', '1', '1', '1', '1', '0', '0', null, '47', '71', '320', '127', '128', '&lt;span style=&quot;color:#333333;font-family:Tahoma, \'microsoft yahei\';font-size:20px;font-weight:bold;line-height:28px;background-color:#FFFFFF;&quot;&gt;新雅BCP-18酸汤肥牛225g 酒店半成品肉类私房菜 微波速食方便炒菜&lt;/span&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-31 22:42:56', '0', '0'),
('126', '353543', '菜根香特制 八宝甜饭（真空袋装）450G', 'Upload/goods/2015-05/556b1f8ec2136.jpg', 'Upload/goods/2015-05/556b1f8ec2136.jpg', '19', '11', '56.00', '34.00', '5346', '0', '0', '0', '0', '袋', '450G', '1', '1', '1', '1', '1', '0', '0', null, '47', '71', '320', '18', '25', '&lt;span style=&quot;color:#333333;font-family:Tahoma, \'microsoft yahei\';font-size:20px;font-weight:bold;line-height:28px;background-color:#FFFFFF;&quot;&gt;菜根香特制 八宝甜饭（真空袋装）450G&lt;/span&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-31 22:50:25', '0', '0'),
('127', '64564', '常温熟食SS-02 香卤牛肉250g方便菜卤味', 'Upload/goods/2015-05/556b1fc88604e.jpg', 'Upload/goods/2015-05/556b1fc88604e.jpg', '19', '11', '34.00', '23.00', '24234', '0', '0', '0', '0', '盘', '', '1', '1', '1', '1', '1', '0', '0', null, '47', '71', '320', '18', '25', '常温熟食SS-02 香卤牛肉250g方便菜卤味', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-31 22:51:14', '0', '0'),
('128', '453635', '新雅大厨YL-03 常温腊味广式腊肠特色私房菜42', 'Upload/goods/2015-05/556b200b476d6.jpg', 'Upload/goods/2015-05/556b200b476d6.jpg', '19', '11', '34.00', '30.00', '3453636', '0', '0', '0', '0', '千克', '', '1', '1', '1', '1', '1', '0', '0', null, '47', '71', '320', '18', '25', '新雅大厨YL-03 常温腊味广式腊肠特色私房菜425g ', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-31 22:52:28', '0', '0'),
('129', '354664', '新雅大厨YL-04 常温腊味腊青鱼干250g 真空', 'Upload/goods/2015-05/556b2046d3c6d.jpg', 'Upload/goods/2015-05/556b2046d3c6d.jpg', '19', '11', '67.00', '45.00', '43634', '0', '0', '0', '0', '千克', '', '1', '1', '1', '1', '1', '0', '0', null, '47', '71', '320', '18', '25', '新雅大厨YL-04 常温腊味腊青鱼干250g 真空包装 方便菜 ', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-31 22:53:21', '0', '0'),
('130', '45426546', '万家鲜 320g富贵人家鲜肉粽', 'Upload/goods/2015-05/556b207b3d959.jpg', 'Upload/goods/2015-05/556b207b3d959.jpg', '19', '11', '9.00', '8.00', '0', '0', '0', '0', '0', '个', '320g', '1', '1', '1', '1', '1', '0', '0', null, '47', '71', '320', '18', '25', '万家鲜 320g富贵人家鲜肉粽', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-31 22:54:17', '0', '0'),
('131', '463554', '常温熟食SS-07 秘制酱鸭450g 真空卤味方便', 'Upload/goods/2015-05/556b20c74da42.jpg', 'Upload/goods/2015-05/556b20c74da42.jpg', '19', '11', '78.00', '65.00', '345264', '0', '0', '0', '0', '千克', '', '1', '1', '1', '1', '1', '0', '0', null, '47', '71', '320', '18', '25', '&lt;p&gt;\n	&lt;span style=&quot;color:#333333;font-family:Tahoma, \'microsoft yahei\';font-size:20px;font-weight:bold;line-height:28px;background-color:#FFFFFF;&quot;&gt;常温熟食SS-07 秘制酱鸭450g 真空卤味方便菜&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;font-family:Tahoma, \'microsoft yahei\';font-size:20px;font-weight:bold;line-height:28px;background-color:#FFFFFF;&quot;&gt;&lt;br /&gt;\n&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;font-family:Tahoma, \'microsoft yahei\';font-size:20px;font-weight:bold;line-height:28px;background-color:#FFFFFF;&quot;&gt;&lt;img src=&quot;/product/wstmall/Upload/image/20150531/20150531145555_75374.jpg&quot; alt=&quot;&quot; /&gt;&lt;br /&gt;\n&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-05-31 22:55:57', '0', '0'),
('132', '373924', '日本进口 昭和SHOWA 手套（M号绿色）', 'Upload/goods/2015-06/556baca5abd97.jpg', 'Upload/goods/2015-06/556baca5abd97.jpg', '0', '15', '45.00', '34.00', '234532', '0', '0', '0', '0', '双', '', '1', '1', '1', '1', '1', '0', '0', null, '48', '259', '281', '130', '144', '日本进口 昭和SHOWA 手套（M号绿色）', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 08:52:38', '0', '0'),
('133', '3534534', '日本进口 斯凯达 DBD5 立体垃圾桶5升', 'Upload/goods/2015-06/556bad657d757.jpg', 'Upload/goods/2015-06/556bad657d757.jpg', '0', '15', '56.00', '34.00', '23534534', '0', '0', '0', '0', '只', '', '1', '1', '1', '1', '1', '0', '0', null, '48', '259', '281', '130', '145', '&lt;p&gt;\n	&lt;span style=&quot;color:#333333;font-family:Tahoma, \'microsoft yahei\';font-size:20px;font-weight:bold;line-height:28px;background-color:#FFFFFF;&quot;&gt;日本进口 斯凯达 DBD5 立体垃圾桶5升 Hello Kitty－Basic 0181&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;font-family:Tahoma, \'microsoft yahei\';font-size:20px;font-weight:bold;line-height:28px;background-color:#FFFFFF;&quot;&gt;&lt;br /&gt;\n&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;font-family:Tahoma, \'microsoft yahei\';font-size:20px;font-weight:bold;line-height:28px;background-color:#FFFFFF;&quot;&gt;&lt;br /&gt;\n&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;font-family:Tahoma, \'microsoft yahei\';font-size:20px;font-weight:bold;line-height:28px;background-color:#FFFFFF;&quot;&gt;&lt;img src=&quot;/product/wstmall/Upload/image/20150601/20150601005532_19772.jpg&quot; alt=&quot;&quot; /&gt;&lt;br /&gt;\n&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 08:55:48', '0', '0'),
('134', '53453', '日本COGIT 儿童款小熊/小兔竹炭鞋撑 从小识左', 'Upload/goods/2015-06/556badd5e0688.jpg', 'Upload/goods/2015-06/556badd5e0688.jpg', '0', '15', '56.00', '45.00', '2343253', '0', '0', '0', '0', '个', '', '1', '1', '1', '1', '1', '0', '0', null, '48', '259', '280', '130', '144', '日本COGIT 儿童款小熊/小兔竹炭鞋撑 从小识左右', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 08:57:32', '0', '0'),
('135', '3424434', '日本COGIT 血型竹炭除湿消臭靴撑（四款可选）', 'Upload/goods/2015-06/556bae1378d17.jpg', 'Upload/goods/2015-06/556bae1378d17.jpg', '0', '15', '45.00', '34.00', '453453', '0', '0', '0', '0', '个', '', '1', '1', '1', '1', '1', '0', '0', null, '48', '259', '279', '130', '144', '　【商品名称】：日本COGIT 血型竹炭除湿消臭靴撑（四款可选）　　【品　　牌】：COGIT　　【商品编码】：7420053　　【货　　号】：46837卡通狮/46838卡通兔/46836卡通猴/46835长颈鹿　　【商品颜色】：粉色卡通兔(AB型)、橙色卡通狮(O型)、蓝色卡通猴(B型)、黄色长颈鹿(A型)　　【产　　地】：中国 　　日本专柜价：1260日元(约合人民币101元) ', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 08:58:28', '0', '0'),
('136', '45345', '台湾正品热销 Bone 心形狗骨头 3.5mm情侣', 'Upload/goods/2015-06/556bb082eb7fc.jpg', 'Upload/goods/2015-06/556bb082eb7fc.jpg', '0', '15', '46.00', '34.00', '325343', '0', '0', '0', '0', '个', '', '1', '1', '1', '1', '1', '0', '0', null, '48', '259', '279', '130', '146', '台湾正品热销 Bone 心形狗骨头 3.5mm情侣耳机分享器 分线器', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 09:09:10', '0', '0'),
('137', '553534', '日本白元 一年冰箱冷冻室脱臭剂（可用1年）50g', 'Upload/goods/2015-06/556bb0f5e6236.jpg', 'Upload/goods/2015-06/556bb0f5e6236.jpg', '0', '15', '56.00', '54.00', '3345345', '0', '0', '0', '0', '盒', '', '1', '1', '1', '1', '1', '0', '0', null, '48', '259', '280', '130', '144', '日本白元 一年冰箱冷冻室脱臭剂（可用1年）50g', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 09:10:28', '0', '0'),
('138', '3535345', '妙管家固體芳香劑120g', 'Upload/goods/2015-06/556bb1152b173.jpg', 'Upload/goods/2015-06/556bb1152b173.jpg', '0', '15', '86.00', '56.00', '5345345', '0', '0', '0', '0', '盒', '', '1', '1', '1', '1', '1', '0', '0', null, '48', '259', '281', '130', '144', '妙管家固體芳香劑120g', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 09:11:10', '0', '0'),
('139', '345354', '日本白元 一年冰箱冷藏室脱臭剂（可用1年）80g', 'Upload/goods/2015-06/556bb15544f3c.jpg', 'Upload/goods/2015-06/556bb15544f3c.jpg', '0', '15', '3453.00', '3242.00', '343242', '0', '0', '0', '0', '盒', '', '1', '1', '1', '1', '1', '0', '0', null, '48', '259', '279', '130', '146', '日本白元 一年冰箱冷藏室脱臭剂（可用1年）80g', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 09:12:22', '0', '0'),
('140', '354353', '乐宜美加厚11丝真空压缩袋 11件套送手泵收纳袋', 'Upload/goods/2015-06/556bb41b13390.jpg', 'Upload/goods/2015-06/556bb41b13390.jpg', '25', '15', '67.00', '59.00', '2332', '0', '0', '0', '0', '盒', ' 11件套', '1', '1', '1', '1', '1', '0', '0', null, '48', '260', '287', '131', '139', '&lt;p&gt;\n	&amp;nbsp;11件套\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150601/20150601012427_58007.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 09:24:42', '0', '0'),
('141', '3535435', '好雅 真空收纳袋压缩袋整理密封袋 7件套赠抽气泵', 'Upload/goods/2015-06/556bbd2085b1f.jpg', 'Upload/goods/2015-06/556bbd2085b1f.jpg', '26', '15', '45.00', '42.00', '42342', '0', '0', '0', '0', '盒', '规格： 特大号2个 大号2个 中号2个', '1', '1', '1', '1', '1', '0', '0', null, '48', '260', '284', '131', '141', '好雅 真空收纳袋压缩袋整理密封袋 7件套赠抽气泵', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 10:03:00', '0', '0'),
('142', '35345', '太力抗菌真空压缩袋棉被衣物收纳袋彩盒装带双泵', 'Upload/goods/2015-06/556bbf15bbcb9.jpg', 'Upload/goods/2015-06/556bbf15bbcb9.jpg', '26', '15', '56.00', '45.00', '353453', '0', '0', '0', '0', '盒', '真空压缩袋彩盒装10件套(2大+2中+3小+2手卷+1手动双泵)', '1', '1', '1', '1', '1', '0', '0', null, '48', '260', '287', '131', '142', '真空压缩袋彩盒装10件套(2大+2中+3小+2手卷+1手动双泵)', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 10:11:23', '0', '0'),
('143', '日5573495', '乐宜美大号真空压缩袋70*100cm 2只装', 'Upload/goods/2015-06/556bc612a2298.jpg', 'Upload/goods/2015-06/556bc612a2298.jpg', '25', '15', '67.00', '54.00', '32534', '0', '0', '0', '0', '只', ' 2只装', '1', '1', '1', '1', '1', '0', '0', null, '48', '260', '287', '131', '143', ' 2只装\n乐宜美大号真空压缩袋70*100cm 2只装', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 10:41:16', '0', '0'),
('144', '435345', '太力真空压缩袋羽绒服衣物收纳袋2个装送小香包 中号', 'Upload/goods/2015-06/556bcb77ab0aa.jpg', 'Upload/goods/2015-06/556bcb77ab0aa.jpg', '25', '15', '56.00', '43.00', '25345', '0', '0', '0', '0', '个', '规格： 60*70㎝(2个)', '1', '1', '1', '1', '1', '0', '0', null, '48', '260', '287', '131', '139', '&lt;p&gt;\n	wstmall测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150601/20150601030346_54623.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 11:04:36', '0', '0'),
('145', '53543', '飞达三和 多用储物盒收纳箱药箱多用杂物箱 颜色随机', 'Upload/goods/2015-06/556bcc1b10cf6.jpg', 'Upload/goods/2015-06/556bcc1b10cf6.jpg', '25', '15', '45.00', '42.00', '343', '0', '0', '0', '0', '个', '', '1', '1', '1', '1', '1', '0', '0', null, '48', '260', '284', '131', '142', '飞达三和 多用储物盒收纳箱药箱多用杂物箱 颜色随机', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 11:06:33', '0', '0'),
('146', '33453', '双艺家居 韩式盖式十五格分类收纳盒收纳箱 颜色随机', 'Upload/goods/2015-06/556bcc75af177.jpg', 'Upload/goods/2015-06/556bcc75af177.jpg', '25', '15', '45.00', '43.00', '34353', '0', '0', '0', '0', '个', '', '1', '1', '1', '1', '1', '0', '0', null, '48', '260', '284', '131', '142', '双艺家居 韩式盖式十五格分类收纳盒收纳箱 颜色随机', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 11:08:10', '0', '0'),
('147', '234534', '塑风尚梅花形密封塑料盘干零食盘糖果盒JL-5244', 'Upload/goods/2015-06/556bccdb42dd7.jpg', 'Upload/goods/2015-06/556bccdb42dd7.jpg', '25', '15', '67.00', '45.00', '344534', '0', '0', '0', '0', '个', '', '1', '1', '1', '1', '1', '0', '0', null, '48', '260', '284', '131', '142', '塑风尚梅花形密封塑料盘干零食盘糖果盒JL-5244', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 11:09:53', '0', '0'),
('148', '345345', '日本原装进口 山洋 大头棉棒110支 筒装', 'Upload/goods/2015-06/556bcdd4a7bff.jpg', 'Upload/goods/2015-06/556bcdd4a7bff.jpg', '25', '15', '4.00', '3.00', '2334', '0', '0', '0', '0', '盒', '', '1', '1', '1', '1', '1', '0', '0', null, '48', '261', '270', '129', '135', '&lt;p&gt;\n	wstmall测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150601/20150601031422_31860.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 11:14:28', '0', '0'),
('149', '34334', '日本山洋 国产良品 安心棉棒 200支 筒装', 'Upload/goods/2015-06/556bced541fe4.jpg', 'Upload/goods/2015-06/556bced541fe4.jpg', '25', '15', '5.00', '3.00', '3243', '0', '0', '0', '0', '筒', '200支/筒', '1', '1', '1', '1', '1', '0', '0', null, '48', '261', '271', '129', '135', '&lt;p&gt;\n	wstmall测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;br /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img src=&quot;/product/wstmall/Upload/image/20150601/20150601031845_55725.jpg&quot; alt=&quot;&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 11:18:47', '0', '0'),
('150', '4353', '日本山洋 湿性棉棒50支 独立包装', 'Upload/goods/2015-06/556bcf47b9c30.jpg', 'Upload/goods/2015-06/556bcf47b9c30.jpg', '25', '15', '8.00', '6.00', '53534', '0', '0', '0', '0', '包', '50支', '1', '1', '1', '1', '1', '0', '0', null, '48', '261', '271', '129', '135', '&lt;p&gt;\n	&lt;span style=&quot;color:#333333;font-family:Tahoma, \'microsoft yahei\';font-size:20px;font-weight:bold;line-height:28px;background-color:#FFFFFF;&quot;&gt;日本山洋 湿性棉棒50支 独立包装&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;font-family:Tahoma, \'microsoft yahei\';font-size:20px;font-weight:bold;line-height:28px;background-color:#FFFFFF;&quot;&gt;&lt;br /&gt;\n&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;font-family:Tahoma, \'microsoft yahei\';font-size:20px;font-weight:bold;line-height:28px;background-color:#FFFFFF;&quot;&gt;&lt;img src=&quot;/product/wstmall/Upload/image/20150601/20150601032017_35235.jpg&quot; alt=&quot;&quot; /&gt;&lt;br /&gt;\n&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 11:20:18', '0', '0'),
('151', '44535', '日本山洋 国产良品 挖耳勺棉棒100支 独立包装', 'Upload/goods/2015-06/556bcf9b074d1.jpg', 'Upload/goods/2015-06/556bcf9b074d1.jpg', '25', '15', '9.00', '7.00', '35345', '0', '0', '0', '0', '袋', '100支', '1', '1', '1', '1', '1', '0', '0', null, '48', '261', '271', '129', '135', '100支，测试商品，请勿下单', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 11:21:41', '0', '0'),
('152', '53453', 'HS黑色垃圾袋80*100cm 10只*2卷', 'Upload/goods/2015-06/556bd01365c44.jpg', 'Upload/goods/2015-06/556bd01365c44.jpg', '27', '15', '12.00', '11.00', '12324', '0', '0', '0', '0', '卷', '', '1', '1', '1', '1', '1', '0', '0', null, '48', '261', '268', '129', '137', 'HS黑色垃圾袋80*100cm 10只*2卷', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 11:23:31', '0', '0'),
('153', '5345345', '新天力炫彩纸杯（柔版印刷）240ml （100只装', 'Upload/goods/2015-06/556bd088905cb.jpg', 'Upload/goods/2015-06/556bd088905cb.jpg', '28', '15', '21.00', '19.00', '235345', '0', '0', '0', '0', '袋', '100只装', '1', '1', '1', '1', '1', '0', '0', null, '48', '261', '270', '129', '136', '测试商品，请勿下单', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 11:25:44', '0', '0'),
('154', '35335', '新天力晶莹航旅杯250ml （60只装）', 'Upload/goods/2015-06/556bd1007f005.jpg', 'Upload/goods/2015-06/556bd1007f005.jpg', '28', '15', '23.00', '21.00', '4234243', '0', '0', '0', '0', '袋', '', '1', '1', '1', '1', '1', '0', '0', null, '48', '261', '269', '129', '136', '&lt;p&gt;\n	&lt;span style=&quot;color:#333333;font-family:Tahoma, \'microsoft yahei\';font-size:20px;font-weight:bold;line-height:28px;background-color:#FFFFFF;&quot;&gt;新天力晶莹航旅杯250ml （60只装）&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;font-family:Tahoma, \'microsoft yahei\';font-size:20px;font-weight:bold;line-height:28px;background-color:#FFFFFF;&quot;&gt;测试商品，请勿下单&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;font-family:Tahoma, \'microsoft yahei\';font-size:20px;font-weight:bold;line-height:28px;background-color:#FFFFFF;&quot;&gt;&lt;img src=&quot;/product/wstmall/Upload/image/20150601/20150601032649_54571.jpg&quot; alt=&quot;&quot; /&gt;&lt;br /&gt;\n&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 11:26:58', '0', '0'),
('155', '34535', '龙士达鞋套', 'Upload/goods/2015-06/556bd12a99d94.jpg', 'Upload/goods/2015-06/556bd12a99d94.jpg', '28', '15', '34.00', '23.00', '2342', '0', '0', '0', '0', '袋', '', '1', '1', '1', '1', '1', '0', '0', null, '48', '261', '272', '129', '134', '&lt;p&gt;\n	&lt;span style=&quot;color:#333333;font-family:Tahoma, \'microsoft yahei\';font-size:20px;font-weight:bold;line-height:28px;background-color:#FFFFFF;&quot;&gt;龙士达鞋套&lt;span style=&quot;color:#333333;font-family:Tahoma, \'microsoft yahei\';font-size:20px;font-weight:bold;line-height:28px;background-color:#FFFFFF;&quot;&gt;龙士达鞋套&lt;/span&gt;&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;font-family:Tahoma, \'microsoft yahei\';font-size:20px;font-weight:bold;line-height:28px;background-color:#FFFFFF;&quot;&gt;&lt;br /&gt;\n&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;font-family:Tahoma, \'microsoft yahei\';font-size:20px;font-weight:bold;line-height:28px;background-color:#FFFFFF;&quot;&gt;&lt;img src=&quot;/product/wstmall/Upload/image/20150601/20150601032811_45474.gif&quot; alt=&quot;&quot; /&gt;&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 11:28:13', '0', '0'),
('156', '23424', '雀巢全家营养甜奶粉 300g', 'Upload/goods/2015-06/556be798974c1.jpg', 'Upload/goods/2015-06/556be798974c1.jpg', '29', '20', '25.00', '23.00', '23433', '0', '0', '0', '0', '包', '300g', '1', '1', '1', '1', '1', '0', '0', null, '49', '82', '300', '147', '148', '&lt;p&gt;\n	wstmall 测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601050426_96544.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 13:04:29', '0', '0'),
('157', '2342234', '雀巢全脂奶粉400G', 'Upload/goods/2015-06/556be7fa1961d.jpg', 'Upload/goods/2015-06/556be7fa1961d.jpg', '29', '20', '35.00', '34.00', '3234', '0', '0', '0', '0', '包', '400g', '1', '1', '1', '1', '1', '0', '0', null, '49', '82', '301', '147', '148', '&lt;p&gt;\n	测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601050553_69087.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 13:05:55', '0', '0'),
('158', '543455', '雀巢 全脂 奶粉 听装 900g', 'Upload/goods/2015-06/556bf94fb0d31.jpg', 'Upload/goods/2015-06/556bf94fb0d31.jpg', '29', '20', '564.00', '345.00', '293472984', '0', '0', '0', '0', '听', ' 900g/听', '1', '1', '1', '1', '1', '0', '0', null, '49', '82', '300', '147', '148', '&lt;p&gt;\n	雀巢咖啡，wstmall测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601062026_13361.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 14:20:28', '0', '0'),
('159', '345324', '雀巢 中老年 奶粉 营养奶粉 850g/罐', 'Upload/goods/2015-06/556bf9fa39c55.jpg', 'Upload/goods/2015-06/556bf9fa39c55.jpg', '29', '20', '456.00', '342.00', '3453', '0', '0', '0', '0', '罐', '850g/罐', '1', '1', '1', '1', '1', '0', '0', null, '49', '82', '301', '147', '148', '&lt;p&gt;\n	wstmall测试商品请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601062209_84023.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 14:22:10', '0', '0'),
('160', '23534', '雀巢健心中老年奶粉 900g', 'Upload/goods/2015-06/556c12e77f4d1.jpg', 'Upload/goods/2015-06/556c12e77f4d1.jpg', '29', '20', '234.00', '232.00', '235435', '0', '0', '0', '0', '罐', '900g', '1', '1', '1', '1', '1', '0', '0', null, '49', '82', '301', '155', '156', '&lt;p&gt;\n	雀巢奶粉 请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601080921_36087.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 16:09:34', '0', '0'),
('161', '35345', '伊利 中老年 奶粉 900g', 'Upload/goods/2015-06/556c1478e6a92.jpg', 'Upload/goods/2015-06/556c1478e6a92.jpg', '30', '20', '67.00', '65.00', '543535', '0', '0', '0', '0', '罐', '900g', '1', '1', '1', '1', '1', '0', '0', null, '49', '82', '305', '155', '156', '&lt;p&gt;\n	伊利奶粉，伊利奶粉\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601081538_82704.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 16:15:39', '0', '0'),
('162', '5345345', '伊利 女士 营养奶粉 (方便装) 400g', 'Upload/goods/2015-06/556c150e5366a.jpg', 'Upload/goods/2015-06/556c150e5366a.jpg', '30', '20', '46.00', '42.00', '435345', '0', '0', '0', '0', '袋', '400g', '1', '1', '1', '1', '1', '0', '0', null, '49', '82', '301', '155', '156', '&lt;p&gt;\n	伊利奶粉，伊利奶粉\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601081812_74948.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 16:18:14', '0', '0'),
('163', '345646', '雀巢全家营养甜奶粉 300g', 'Upload/goods/2015-06/556c158dd3c75.jpg', 'Upload/goods/2015-06/556c158dd3c75.jpg', '30', '20', '234.00', '231.00', '24324', '0', '0', '0', '0', '袋', '300g', '1', '1', '1', '1', '1', '0', '0', null, '49', '82', '305', '155', '156', '&lt;p&gt;\n	伊利奶粉\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601082004_64071.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 16:20:13', '0', '0'),
('164', '345345445', '红牛维生素功能饮料250ml', 'Upload/goods/2015-06/556c178551085.jpg', 'Upload/goods/2015-06/556c178551085.jpg', '31', '20', '6.00', '5.00', '3454354', '0', '0', '0', '0', '罐', '250ml', '1', '1', '1', '1', '1', '0', '0', null, '49', '81', '313', '151', '152', '&lt;p&gt;\n	红牛功能饮料\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601082833_25493.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 16:28:36', '0', '0'),
('165', '324872', '佳得乐橙味运动饮料600ml', 'Upload/goods/2015-06/556c17c8a116a.jpg', 'Upload/goods/2015-06/556c17c8a116a.jpg', '32', '20', '7.00', '4.00', '34543', '0', '0', '0', '0', '瓶', '600ml', '1', '1', '1', '1', '1', '0', '0', null, '49', '81', '304', '151', '154', '&lt;p&gt;\n	测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601082948_66288.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 16:29:50', '0', '0'),
('166', '9457395', '美年达橙味汽水330ml 罐装', 'Upload/goods/2015-06/556c184e97298.jpg', 'Upload/goods/2015-06/556c184e97298.jpg', '33', '20', '7.00', '4.00', '345345', '0', '0', '0', '0', '罐', '330ml', '1', '1', '1', '1', '1', '0', '0', null, '49', '81', '316', '151', '153', '&lt;p&gt;\n	么么哒。。。\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601083150_72034.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 16:31:54', '0', '0'),
('167', '234924', '芬达橙味汽水330ml 罐装', 'Upload/goods/2015-06/556c18c22109e.jpg', 'Upload/goods/2015-06/556c18c22109e.jpg', '34', '20', '6.00', '4.00', '235345', '0', '0', '0', '0', '罐', '330ml', '1', '1', '1', '1', '1', '0', '0', null, '49', '81', '316', '151', '153', '&lt;p&gt;\n	芬达饮料\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601083337_41755.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 16:33:39', '0', '0'),
('168', '34535', '康师傅掌中包冰红茶250ml', 'Upload/goods/2015-06/556c1956bd0cf.jpg', 'Upload/goods/2015-06/556c1956bd0cf.jpg', '35', '20', '5.00', '3.00', '3543523', '0', '0', '0', '0', '瓶', '250ml', '1', '1', '1', '1', '1', '0', '0', null, '49', '81', '304', '151', '154', '&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;康师傅掌中包冰红茶250ml&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;康师傅掌中包冰红茶250ml&lt;/span&gt;&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;康师傅掌中包冰红茶250ml&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601083622_87489.jpg&quot; /&gt;&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 16:36:31', '0', '0'),
('169', '23435', '康师傅冰红茶1L', 'Upload/goods/2015-06/556c19ce46b97.jpg', 'Upload/goods/2015-06/556c19ce46b97.jpg', '35', '20', '12.00', '10.00', '353453', '0', '0', '0', '0', '瓶', '1L', '1', '1', '1', '1', '1', '0', '0', null, '49', '81', '304', '151', '154', '&lt;p&gt;\n	康师傅冰红茶\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601083823_40278.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 16:38:26', '0', '0'),
('170', '234934', '康师傅冰红茶550ml', 'Upload/goods/2015-06/556c1a1362f29.jpg', 'Upload/goods/2015-06/556c1a1362f29.jpg', '35', '20', '10.00', '8.00', '4353', '0', '0', '0', '0', '瓶', '550ml', '1', '1', '1', '1', '1', '0', '0', null, '49', '81', '304', '151', '153', '&lt;p&gt;\n	康师傅冰红茶\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601083934_83959.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 16:39:36', '0', '0'),
('171', '3534535', '美汁源果粒橙1.25L', 'Upload/goods/2015-06/556c1ab6e390b.jpg', 'Upload/goods/2015-06/556c1ab6e390b.jpg', '36', '20', '9.00', '5.00', '54435345', '0', '0', '0', '0', '瓶', '1.25L', '1', '1', '1', '1', '1', '0', '0', null, '49', '81', '304', '151', '153', '&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;美汁源果粒橙1.25L&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;美汁源果粒橙1.25L&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;美汁源果粒橙1.25L&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601084207_17671.jpg&quot; /&gt;&lt;/span&gt;&lt;/span&gt;&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 16:42:17', '0', '0'),
('172', '3493845', '太古纯正方糖454G', 'Upload/goods/2015-06/556c1d20dc9bc.jpg', 'Upload/goods/2015-06/556c1d20dc9bc.jpg', '37', '20', '15.00', '13.00', '3242334', '0', '0', '0', '0', '盒', '454g', '1', '1', '1', '1', '1', '0', '0', null, '49', '79', '302', '147', '149', '&lt;p&gt;\n	太古咖啡伴侣。。。\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601085234_42255.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 16:52:36', '0', '0'),
('173', '354345', '雀巢 1+2原味咖啡 15克x42条装 630克', 'Upload/goods/2015-06/556c1d680fc6b.jpg', 'Upload/goods/2015-06/556c1d680fc6b.jpg', '29', '20', '45.00', '35.00', '35345', '0', '0', '0', '0', '盒', '15克x42条', '1', '1', '1', '1', '1', '0', '0', null, '49', '79', '308', '147', '148', '&lt;p&gt;\n	雀巢速溶咖啡\n&lt;/p&gt;\n&lt;p&gt;\n	wstmall测试商品请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601085415_74720.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 16:54:18', '0', '0'),
('174', '53535', '麦斯威尔 原味 咖啡 42条装', 'Upload/goods/2015-06/556c1e0d685c1.jpg', 'Upload/goods/2015-06/556c1e0d685c1.jpg', '38', '20', '53.00', '51.00', '23425', '0', '0', '0', '0', '盒', '42条装', '1', '1', '1', '1', '1', '0', '0', null, '49', '79', '299', '147', '148', '&lt;p&gt;\n	42条装 咖啡\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601085624_38336.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 16:56:32', '0', '0'),
('175', '23252', '可比可拿铁咖啡24*21.25G', 'Upload/goods/2015-06/556c1ea35883d.jpg', 'Upload/goods/2015-06/556c1ea35883d.jpg', '39', '20', '56.00', '50.00', '353453', '0', '0', '0', '0', '盒', '24*21.25G', '1', '1', '1', '1', '1', '0', '0', null, '49', '79', '298', '147', '148', '&lt;p&gt;\n	24*21.25G 卡比克拿铁咖啡\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601085905_63047.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 16:59:15', '0', '0'),
('176', '234242', '可比可摩卡咖啡24*24.25G', 'Upload/goods/2015-06/556c1f1c4faae.jpg', 'Upload/goods/2015-06/556c1f1c4faae.jpg', '39', '20', '67.00', '55.00', '234234', '0', '0', '0', '0', '盒', '24*24.25G', '1', '1', '1', '1', '1', '0', '0', null, '49', '79', '298', '147', '148', '&lt;p&gt;\n	24*24.25G24*24.25G\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601090052_63709.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 17:01:04', '0', '0'),
('177', '5353453', '日本进口AGF maxim马克西姆速溶咖啡180g', 'Upload/goods/2015-06/556c1ff672852.jpg', 'Upload/goods/2015-06/556c1ff672852.jpg', '29', '20', '345.00', '234.00', '234234', '0', '0', '0', '0', '罐', '180g', '1', '1', '1', '1', '1', '0', '0', null, '49', '79', '298', '147', '148', '&lt;p&gt;\n	速溶咖啡\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601090510_20261.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 17:05:12', '0', '0'),
('178', '353543', '摩卡家庭套装15G*42', 'Upload/goods/2015-06/556c20c39ed91.jpg', 'Upload/goods/2015-06/556c20c39ed91.jpg', '40', '20', '35.00', '34.00', '2342342', '0', '0', '0', '0', '盒', '15G*42', '1', '1', '1', '1', '1', '0', '0', null, '49', '79', '299', '147', '148', '&lt;p&gt;\n	摩卡咖啡\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601090759_17803.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 17:08:01', '0', '0'),
('179', '354335', '雀巢咖啡1+2原味 100*15g', 'Upload/goods/2015-06/556c211be5457.jpg', 'Upload/goods/2015-06/556c211be5457.jpg', '29', '20', '35.00', '32.00', '35345', '0', '0', '0', '0', '盒', ' 100*15g', '1', '1', '1', '1', '1', '0', '0', null, '49', '79', '308', '147', '148', '&lt;p&gt;\n	雀巢咖啡\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601090910_64689.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 17:09:21', '0', '0'),
('180', '335345', '金龙鱼黄金比例食用调和油5000ml', 'Upload/goods/2015-06/556c24e57b479.jpg', 'Upload/goods/2015-06/556c24e57b479.jpg', '44', '23', '65.00', '55.00', '3434535', '0', '0', '0', '0', '瓶', '5000ml', '1', '1', '1', '1', '1', '0', '0', null, '50', '220', '242', '157', '161', '&lt;p&gt;\n	5000ml金龙鱼油\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601092749_32142.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 17:27:50', '0', '0'),
('181', '4535345', '金龙鱼精炼一级大豆油1800ml', 'Upload/goods/2015-06/556c25bb80825.jpg', 'Upload/goods/2015-06/556c25bb80825.jpg', '44', '23', '32.00', '23.00', '23423', '0', '0', '0', '0', '瓶', '1800ml', '1', '1', '1', '1', '1', '0', '0', null, '50', '220', '242', '157', '161', '&lt;p&gt;\n	金龙鱼油\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601092905_30335.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 17:29:08', '0', '0'),
('182', '372494', '福临门非转基因纯正玉米油4L', 'Upload/goods/2015-06/556c26d6cc7c0.jpg', 'Upload/goods/2015-06/556c26d6cc7c0.jpg', '41', '23', '65.00', '54.00', '34535', '0', '0', '0', '0', '瓶', '4L', '1', '1', '1', '1', '1', '0', '0', null, '50', '220', '244', '157', '161', '&lt;p&gt;\n	福临门\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601093346_82182.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 17:33:54', '0', '0'),
('183', '32432534', '鲁花5S压榨一级花生油5L（非转）送酱油', 'Upload/goods/2015-06/556c27b4d9fc0.jpg', 'Upload/goods/2015-06/556c27b4d9fc0.jpg', '42', '23', '150.00', '140.00', '34935', '0', '0', '0', '0', '瓶', '5L', '1', '1', '1', '1', '1', '0', '0', null, '50', '220', '245', '157', '162', '&lt;p&gt;\n	鲁花花生油\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601093754_85769.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 17:38:00', '0', '0'),
('184', '35435345', '多力5珍宝葵花籽非转基因调和油5L', 'Upload/goods/2015-06/556c284f4565c.jpg', 'Upload/goods/2015-06/556c284f4565c.jpg', '43', '23', '65.00', '60.00', '3545', '0', '0', '0', '0', '瓶', '5L', '1', '1', '1', '1', '1', '0', '0', null, '50', '220', '242', '157', '161', '&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;多力5珍宝葵花籽非转基因调和油5L&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601094005_84674.jpg&quot; /&gt;&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 17:40:07', '0', '0'),
('185', '34534345', '多力mighty 橄榄葵花油2.5L 食用油 非转', 'Upload/goods/2015-06/556c28d145513.jpg', 'Upload/goods/2015-06/556c28d145513.jpg', '43', '23', '345.00', '232.00', '3244353', '0', '0', '0', '0', '瓶', '2.5L', '1', '1', '1', '1', '1', '0', '0', null, '50', '220', '242', '157', '161', '&lt;p&gt;\n	多力调和油\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601094224_81238.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 17:42:28', '0', '0'),
('186', '353543', '福临门非转基因葵花籽油5L/桶+900ml/瓶', 'Upload/goods/2015-06/556c293daa031.jpg', 'Upload/goods/2015-06/556c293daa031.jpg', '41', '23', '234.00', '123.00', '2342', '0', '0', '0', '0', '瓶', '5L/桶+900ml/瓶', '1', '1', '1', '1', '1', '0', '0', null, '50', '220', '242', '157', '161', '&lt;p&gt;\n	福临门调和油\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601094414_98165.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 17:44:20', '0', '0'),
('187', '343535', '金龙鱼深海调和油1800ml（非转）', 'Upload/goods/2015-06/556c2a1f246dc.jpg', 'Upload/goods/2015-06/556c2a1f246dc.jpg', '44', '23', '78.00', '56.00', '345345', '0', '0', '0', '0', '瓶', '1800ml', '1', '1', '1', '1', '1', '0', '0', null, '50', '220', '242', '157', '161', '&lt;p&gt;\n	金龙鱼花生油&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601094753_92295.jpg&quot; /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 17:47:56', '0', '0'),
('188', '239427', '真真老老真传礼盒 1.28kg', 'Upload/goods/2015-06/556c2c2790f4d.jpg', 'Upload/goods/2015-06/556c2c2790f4d.jpg', '45', '23', '78.00', '68.00', '2532445', '0', '0', '0', '0', '盒', '1.28kg', '1', '1', '1', '1', '1', '0', '0', null, '50', '223', '333', '160', '168', '&lt;p&gt;\n	真真老老粽子\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601100028_65055.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 18:00:36', '0', '0'),
('189', '3454', '五芳斋 丰年五芳礼盒粽子（100g*24）', 'Upload/goods/2015-06/556c2dd2d7f1f.jpg', 'Upload/goods/2015-06/556c2dd2d7f1f.jpg', '46', '23', '234.00', '190.00', '234324', '0', '0', '0', '0', '盒', '100g*24', '1', '1', '1', '1', '1', '0', '0', null, '50', '223', '333', '160', '169', '&lt;p&gt;\n	100g*24\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601100352_86451.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 18:03:53', '0', '0'),
('190', '45345435', '银鹭 椰果 八宝粥 360g*8瓶/箱', 'Upload/goods/2015-06/556c2e7f4dac9.jpg', 'Upload/goods/2015-06/556c2e7f4dac9.jpg', '47', '23', '32.00', '28.00', '324234', '0', '0', '0', '0', '箱', '360g*8瓶/箱', '1', '1', '1', '1', '1', '0', '0', null, '50', '223', '235', '160', '169', '&lt;p&gt;\n	360g*8瓶/箱\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601100747_53448.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 18:08:44', '0', '0'),
('191', '3423', '2014年新米 常金东北小粒王10kg', 'Upload/goods/2015-06/556c4699eb9c6.jpg', 'Upload/goods/2015-06/556c4699eb9c6.jpg', '44', '23', '78.00', '69.00', '534535', '0', '0', '0', '0', '包', '10kg', '1', '1', '1', '1', '1', '0', '0', null, '50', '221', '229', '158', '163', '&lt;p&gt;\n	2014年新米 常金东北小粒王10kg\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601114945_28374.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 19:49:47', '0', '0'),
('192', '54345', '福临门赋香稻5KG', 'Upload/goods/2015-06/556c46fd65d9b.jpg', 'Upload/goods/2015-06/556c46fd65d9b.jpg', '41', '23', '67.00', '46.00', '23434', '0', '0', '0', '0', '包', '5kg', '1', '1', '1', '1', '1', '0', '0', null, '50', '221', '229', '158', '163', '&lt;p&gt;\n	福临门大米\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601115058_41429.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 19:51:01', '0', '0'),
('193', '4535', '福兴米业富大院 五常一品稻花香大米 绿色食品500', 'Upload/goods/2015-06/556c473ede734.jpg', 'Upload/goods/2015-06/556c473ede734.jpg', '41', '23', '4.00', '3.00', '3453453', '0', '0', '0', '0', '斤', '500g', '1', '1', '1', '1', '1', '0', '0', null, '50', '221', '229', '158', '163', '&lt;p&gt;\n	大米\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601115207_99252.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 19:52:14', '0', '0'),
('194', '354345', '福临门五常稻花香米 大米5kg', 'Upload/goods/2015-06/556c479108a32.jpg', 'Upload/goods/2015-06/556c479108a32.jpg', '41', '23', '46.00', '40.00', '345345', '0', '0', '0', '0', '包', '5kg', '1', '1', '1', '1', '1', '0', '0', null, '50', '221', '229', '158', '163', '&lt;p&gt;\n	福临门大米\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601115327_86552.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 19:53:41', '0', '0'),
('195', '234234', '常金真的好 软玉粳米 10kg', 'Upload/goods/2015-06/556c47d7c191f.jpg', 'Upload/goods/2015-06/556c47d7c191f.jpg', '41', '23', '78.00', '76.00', '345435', '0', '0', '0', '0', '包', '10kg', '1', '1', '1', '1', '1', '0', '0', null, '50', '221', '229', '158', '163', '&lt;p&gt;\n	常金大米，真的好\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601115442_53816.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 19:54:45', '0', '0'),
('196', '345345', '大山第一村 北纬30°神奇大米 米宝宝 老人小孩营', 'Upload/goods/2015-06/556c48551076a.jpg', 'Upload/goods/2015-06/556c48551076a.jpg', '41', '23', '45.00', '40.00', '35345', '0', '0', '0', '0', '包', '500g', '1', '1', '1', '1', '1', '0', '0', null, '50', '221', '229', '158', '163', '&lt;p&gt;\n	大米\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601115554_94353.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 19:56:06', '0', '0'),
('197', '43544', 'wstmall测试商品 金龙鱼原香稻10KG', 'Upload/goods/2015-06/556c4876e8ef2.jpg', 'Upload/goods/2015-06/556c4876e8ef2.jpg', '44', '23', '89.00', '57.00', '345345', '0', '0', '0', '0', '包', '10kg', '1', '1', '1', '1', '1', '0', '0', null, '50', '221', '229', '158', '163', '&lt;p&gt;\n	金龙鱼大米\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601115717_28432.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 19:57:32', '0', '0'),
('198', '3454365', 'wstmall测试商品 金龙鱼软香稻10KG', 'Upload/goods/2015-06/556c48c34bb35.jpg', 'Upload/goods/2015-06/556c48c34bb35.jpg', '44', '23', '56.00', '35.00', '234232', '0', '0', '0', '0', '袋', '10kg', '1', '1', '1', '1', '1', '0', '0', null, '50', '221', '229', '158', '163', '&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;金龙鱼软香稻10KG&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601115834_15355.jpg&quot; /&gt;&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 19:58:35', '0', '0'),
('199', '426546', 'wstmall 金龙鱼 敦化黄大豆 400g/袋', 'Upload/goods/2015-06/556c4967e6d9b.jpg', 'Upload/goods/2015-06/556c4967e6d9b.jpg', '44', '23', '8.00', '7.00', '343543', '0', '0', '0', '0', '袋', '400g/袋', '1', '1', '1', '1', '1', '0', '0', null, '50', '222', '240', '159', '164', '&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601120125_73555.jpg&quot; /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	金龙鱼杂粮\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 20:01:33', '0', '0'),
('200', '35433', 'wstmall 金龙鱼 宝清红小豆 400g/袋', 'Upload/goods/2015-06/556c49be4f838.jpg', 'Upload/goods/2015-06/556c49be4f838.jpg', '44', '23', '32.00', '23.00', '23423', '0', '0', '0', '0', '袋', '400g', '1', '1', '1', '1', '1', '0', '0', null, '50', '222', '240', '159', '164', '&lt;p&gt;\n	金龙鱼杂粮\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601120251_42321.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 20:02:54', '0', '0'),
('201', '3534535', '金龙鱼 九种杂粮精品礼盒3600克', 'Upload/goods/2015-06/556c4a0e0d504.jpg', 'Upload/goods/2015-06/556c4a0e0d504.jpg', '44', '23', '100.00', '90.00', '55443', '0', '0', '0', '0', '袋', '3600克', '1', '1', '1', '1', '1', '0', '0', null, '50', '222', '240', '159', '164', '&lt;p&gt;\n	杂粮\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601120406_25147.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 20:04:17', '0', '0'),
('202', '453543', 'FF 五谷杂粮礼盒4KG', 'Upload/goods/2015-06/556c4a50146d6.jpg', 'Upload/goods/2015-06/556c4a50146d6.jpg', '44', '23', '100.00', '92.00', '0', '0', '0', '0', '0', '袋', '4000g', '1', '1', '1', '1', '1', '0', '0', null, '50', '222', '238', '159', '165', '&lt;p&gt;\n	五谷杂粮\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601120514_71597.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 20:05:16', '0', '0'),
('203', '345436', 'wstmall 测试商品 巴马杂粮礼盒', 'Upload/goods/2015-06/556c4a97a6acb.jpg', 'Upload/goods/2015-06/556c4a97a6acb.jpg', '44', '23', '300.00', '275.00', '34242', '0', '0', '0', '0', '盒', '', '1', '1', '1', '1', '1', '0', '0', null, '50', '222', '241', '159', '166', '&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;巴马杂粮礼盒&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601120637_11708.jpg&quot; /&gt;&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 20:06:39', '0', '0'),
('204', '234323', 'wstmall 测试商品 FOOD 血糯米 1KG', 'Upload/goods/2015-06/556c4f8bc0843.jpg', 'Upload/goods/2015-06/556c4f8bc0843.jpg', '46', '23', '40.00', '35.00', '234234', '0', '0', '0', '0', '袋', '500g', '1', '1', '1', '1', '1', '0', '0', null, '50', '222', '238', '159', '164', '&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;FINE FOOD 血糯米 1KG&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601122753_46817.jpg&quot; /&gt;&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 20:28:06', '0', '0'),
('205', '34535345', 'wstmall测试商品 农家有机黄豆 500G', 'Upload/goods/2015-06/556c4ff97aefe.jpg', 'Upload/goods/2015-06/556c4ff97aefe.jpg', '46', '23', '10.00', '8.00', '34335', '0', '0', '0', '0', '袋', '500g', '1', '1', '1', '1', '1', '0', '0', null, '50', '222', '240', '159', '166', '&lt;p&gt;\n	测试商品\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601122933_38795.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 20:29:37', '0', '0'),
('206', '23432543', '新货 有机黄小米 小米 有机五谷杂粮500G', 'Upload/goods/2015-06/556c506a901e2.jpg', 'Upload/goods/2015-06/556c506a901e2.jpg', '47', '23', '34.00', '32.00', '234324', '0', '0', '0', '0', '袋', '500g', '1', '1', '1', '1', '1', '0', '0', null, '50', '222', '237', '159', '164', '&lt;p&gt;\n	健康小米\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601123115_96184.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 20:31:17', '0', '0'),
('207', '242342', 'Walch/威露士恩兔女性护理液200mlx2私处', 'Upload/goods/2015-06/556c526987406.jpg', 'Upload/goods/2015-06/556c526987406.jpg', '48', '27', '56.00', '45.00', '234243', '0', '0', '0', '0', '瓶', '200mlx2', '1', '1', '1', '1', '1', '0', '0', null, '51', '166', '178', '170', '171', '&lt;p&gt;\n	200mlx2\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601124013_10195.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 20:40:14', '0', '0'),
('208', '3242423', '娇妍美白沐浴露220ml 滋润洁阴辟除异味 正品', 'Upload/goods/2015-06/556c536def0bc.jpg', 'Upload/goods/2015-06/556c536def0bc.jpg', '49', '27', '45.00', '34.00', '234234', '0', '0', '0', '0', '瓶', '220ml', '1', '1', '1', '1', '1', '0', '0', null, '51', '166', '178', '170', '171', '妍妍护理洗浴&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601124423_66532.jpg&quot; /&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 20:44:28', '0', '0'),
('209', '324234', '女性私处护理产品 私处凝胶套盒 养巢护宫凝胶 滋阴', 'Upload/goods/2015-06/556c54628c075.jpg', 'Upload/goods/2015-06/556c54628c075.jpg', '50', '27', '456.00', '345.00', '234234', '0', '0', '0', '0', '瓶', '', '1', '1', '1', '1', '1', '0', '0', null, '51', '166', '178', '170', '171', '&lt;p&gt;\n	巴黎小站\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601124819_17712.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 20:48:21', '0', '0'),
('210', '34523453', '娇妍女性护理液220ml*迷迭香私处护理液200m', 'Upload/goods/2015-06/556c54f4676d5.jpg', 'Upload/goods/2015-06/556c54f4676d5.jpg', '49', '27', '89.00', '78.00', '24324', '0', '0', '0', '0', '瓶', '220ml', '1', '1', '1', '1', '1', '0', '0', null, '51', '166', '178', '170', '171', '&lt;p&gt;\n	妍妍护理\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601125057_54071.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 20:51:01', '0', '0'),
('211', '3435', '施巴烫染修护洗发露400ml+施巴女性护理液200', 'Upload/goods/2015-06/556c56760116c.jpg', 'Upload/goods/2015-06/556c56760116c.jpg', '51', '27', '56.00', '45.00', '343', '0', '0', '0', '0', '瓶', '施巴烫染修护洗发露400ml+施巴女性护理液200', '1', '1', '1', '1', '1', '0', '0', null, '51', '166', '178', '170', '171', '&lt;p&gt;\n	施巴&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601125706_84547.jpg&quot; /&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 20:57:09', '0', '0'),
('212', '23424', '飞少女私处洗液止痒清爽泡沫护理液2瓶+卫生湿巾2包', 'Upload/goods/2015-06/556c572e8228b.jpg', 'Upload/goods/2015-06/556c572e8228b.jpg', '52', '27', '34.00', '23.00', '234242', '0', '0', '0', '0', '包', '清爽泡沫护理液2瓶+卫生湿巾2包', '1', '1', '1', '1', '1', '0', '0', null, '51', '166', '178', '170', '171', '&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601130010_80392.jpg&quot; /&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 21:00:28', '0', '0'),
('213', '234324', '娇妍女性护理液pH4弱酸性220ml+女士私处美白', 'Upload/goods/2015-06/556c57dc28fd3.jpg', 'Upload/goods/2015-06/556c57dc28fd3.jpg', '49', '27', '54.00', '41.00', '4553453', '0', '0', '0', '0', '瓶', '女性护理液pH4弱酸性220ml+女士私处美白沐浴露', '1', '1', '1', '1', '1', '0', '0', null, '51', '166', '178', '170', '171', '妍妍\n&lt;h1 style=&quot;color:#000000;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	娇妍女性护理液pH4弱酸性220ml+女士私处美白沐浴露\n&lt;/h1&gt;\n&lt;p style=&quot;color:#000000;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p style=&quot;color:#000000;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601130306_49932.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 21:03:22', '0', '0'),
('214', '345354', '西妮280ml女士私处护理液*女士专用湿巾1盒止痒', 'Upload/goods/2015-06/556c590d0877c.jpg', 'Upload/goods/2015-06/556c590d0877c.jpg', '53', '27', '56.00', '45.00', '34234234', '0', '0', '0', '0', '瓶', '280ml', '1', '1', '1', '1', '1', '0', '0', null, '51', '166', '178', '170', '171', '&lt;h1 style=&quot;color:#000000;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	西妮280ml女士私处护理液*女士专用湿巾1盒止痒杀菌抑菌除垢消炎\n&lt;/h1&gt;\n&lt;p style=&quot;color:#000000;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p style=&quot;color:#000000;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601130810_72056.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 21:08:12', '0', '0'),
('215', '2423423', 'BEELY嫩红素乳晕嫩红霜下体嫩白淡化唇色纹粉嫩化', 'Upload/goods/2015-06/556c5d0988c78.jpg', 'Upload/goods/2015-06/556c5d0988c78.jpg', '54', '27', '134.00', '115.00', '343434', '0', '0', '0', '0', '套', '', '1', '1', '1', '1', '1', '0', '0', null, '51', '165', '172', '172', '173', '&lt;p&gt;\n	beely\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601132537_73630.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 21:25:38', '0', '0'),
('216', '354355', 'Veet/薇婷香氛凝萃沐浴专用脱毛膏套装135ml', 'Upload/goods/2015-06/556c5dbfa8124.jpg', 'Upload/goods/2015-06/556c5dbfa8124.jpg', '55', '27', '342.00', '230.00', '43422424', '0', '0', '0', '0', '套', '香氛凝萃沐浴专用脱毛膏套装135ml+沐浴腋下专用100ml', '1', '1', '1', '1', '1', '0', '0', null, '51', '165', '172', '172', '173', '&lt;h1 style=&quot;color:#000000;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	Veet/薇婷香氛凝萃沐浴专用脱毛膏套装135ml+沐浴腋下专用100ml\n&lt;/h1&gt;\n&lt;p style=&quot;color:#000000;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p style=&quot;color:#000000;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601132809_67752.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 21:28:21', '0', '0'),
('217', '234235', 'Veet薇婷 滑丽 敏感肌 脱毛膏 套装 安全快速', 'Upload/goods/2015-06/556c5e3b90bd9.jpg', 'Upload/goods/2015-06/556c5e3b90bd9.jpg', '55', '27', '234.00', '231.00', '32423', '0', '0', '0', '0', '套', '', '1', '1', '1', '1', '1', '0', '0', null, '51', '165', '172', '172', '173', '&lt;p&gt;\n	进口美护\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601133018_17083.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 21:30:19', '0', '0'),
('218', '43534', '嘉媚乐 玫瑰精华全身美白滋润保湿身体护理套装 淡香', 'Upload/goods/2015-06/556c5eadad3e3.jpg', 'Upload/goods/2015-06/556c5eadad3e3.jpg', '54', '27', '28.00', '23.00', '0', '0', '0', '0', '0', '套', '', '1', '1', '1', '1', '1', '0', '0', null, '51', '165', '172', '172', '173', '&lt;p&gt;\n	进口美护\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601133156_27308.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 21:32:06', '0', '0'),
('219', '4234324', '番茄派足盐植物萃取泡脚足浴盐20袋套装', 'Upload/goods/2015-06/556c5f309c7d6.jpg', 'Upload/goods/2015-06/556c5f309c7d6.jpg', '56', '27', '342.00', '234.00', '234234', '0', '0', '0', '0', '套', '20袋', '1', '1', '1', '1', '1', '0', '0', null, '51', '165', '172', '172', '173', '&lt;p&gt;\n	番茄派\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;h1 style=&quot;color:#000000;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	番茄派足盐植物萃取泡脚足浴盐20袋套装\n&lt;/h1&gt;\n&lt;p style=&quot;color:#000000;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601133422_84693.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 21:34:25', '0', '0'),
('220', '345345', '欧丽丝纤体乳2件套 瘦腿霜瘦身霜减肥霜膏减肥贴燃脂', 'Upload/goods/2015-06/556c5ffaa793c.jpg', 'Upload/goods/2015-06/556c5ffaa793c.jpg', '57', '27', '45.00', '43.00', '42342', '0', '0', '0', '0', '套', '', '1', '1', '1', '1', '1', '0', '0', null, '51', '165', '172', '172', '173', '&lt;h1 style=&quot;color:#000000;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	欧丽丝纤体乳2件套 瘦腿霜瘦身霜减肥霜膏减肥贴燃脂肪产品\n&lt;/h1&gt;\n&lt;p style=&quot;color:#000000;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p style=&quot;color:#000000;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601133730_95635.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 21:37:32', '0', '0'),
('221', '3435435', '玫瑰皙白清洁滋养三件套装 手工皂精油浴球沐浴膏', 'Upload/goods/2015-06/556c608dc79f9.jpg', 'Upload/goods/2015-06/556c608dc79f9.jpg', '58', '27', '90.00', '87.00', '678987', '0', '0', '0', '0', '套', '', '1', '1', '1', '1', '1', '0', '0', null, '51', '165', '172', '172', '173', '&lt;h1 style=&quot;color:#000000;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	玫瑰皙白清洁滋养三件套装 手工皂精油浴球沐浴膏\n&lt;/h1&gt;\n&lt;p style=&quot;color:#000000;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601134005_39682.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 21:40:07', '0', '0'),
('222', '3453535', 'Rewiwax蕾沃斯正品腋窝手足部护理套装玫瑰脱毛', 'Upload/goods/2015-06/556c610bd789a.jpg', 'Upload/goods/2015-06/556c610bd789a.jpg', '59', '27', '45.00', '34.00', '3242342', '0', '0', '0', '0', '套', '', '1', '1', '1', '1', '1', '0', '0', null, '51', '165', '172', '172', '173', '&lt;h1 style=&quot;color:#000000;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	Rewiwax蕾沃斯正品腋窝手足部护理套装玫瑰脱毛膏套装\n&lt;/h1&gt;\n&lt;p style=&quot;color:#000000;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p style=&quot;color:#000000;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601134203_85747.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 21:42:05', '0', '0'),
('223', '234234', '天喔香脆腰果瓶装 565g', 'Upload/goods/2015-06/556c6516a0bf0.jpg', 'Upload/goods/2015-06/556c6516a0bf0.jpg', '0', '31', '100.00', '85.00', '353453', '0', '0', '0', '0', '罐', '565g', '1', '1', '1', '1', '1', '0', '0', null, '52', '189', '199', '174', '178', '&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;天喔香脆腰果瓶装 565g&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601135952_92968.jpg&quot; /&gt;&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 21:59:54', '0', '0'),
('224', '4345345', 'wstmall 测试商品 天喔小核桃仁纸罐200g', 'Upload/goods/2015-06/556c65863b5af.jpg', 'Upload/goods/2015-06/556c65863b5af.jpg', '0', '31', '90.00', '75.00', '34242', '0', '0', '0', '0', '罐', '200g', '1', '1', '1', '1', '1', '0', '0', null, '52', '189', '201', '174', '176', '&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;天喔小核桃仁纸罐 200g&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601140117_29835.jpg&quot; /&gt;&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 22:01:28', '0', '0'),
('225', '234523', 'wstmall 测试商品天喔自然开开心果 500g', 'Upload/goods/2015-06/556c65e44c216.jpg', 'Upload/goods/2015-06/556c65e44c216.jpg', '0', '31', '45.00', '34.00', '234234', '0', '0', '0', '0', '罐', '500g', '1', '1', '1', '1', '1', '0', '0', null, '52', '189', '199', '174', '175', '&lt;p&gt;\n	测试商品\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601140252_26130.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 22:03:05', '0', '0'),
('226', '23425345', 'wstmall 测试商品 华味亨甘草西瓜子200g', 'Upload/goods/2015-06/556c663d5e8ef.jpg', 'Upload/goods/2015-06/556c663d5e8ef.jpg', '0', '31', '56.00', '45.00', '3453535', '0', '0', '0', '0', '袋', '200g', '1', '1', '1', '1', '1', '0', '0', null, '52', '190', '207', '174', '177', '&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;华味亨甘草西瓜子 200g&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601140438_70737.jpg&quot; /&gt;&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 22:04:41', '0', '0'),
('227', '234234', 'wstmall 测试商品 阿甘正馔巴旦木仁160g', 'Upload/goods/2015-06/556c6721093f2.jpg', 'Upload/goods/2015-06/556c6721093f2.jpg', '0', '31', '34.00', '32.00', '324243', '0', '0', '0', '0', '袋', '160g', '1', '1', '1', '1', '1', '0', '0', null, '52', '189', '199', '174', '175', '&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;阿甘正馔巴旦木仁 160g*1罐装&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601140812_89282.jpg&quot; /&gt;&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 22:08:21', '0', '0'),
('228', '342342', '百味林 坚果炒货零食扁桃仁 500g/散装', 'Upload/goods/2015-06/556c67678e5c8.jpg', 'Upload/goods/2015-06/556c67678e5c8.jpg', '0', '31', '50.00', '45.00', '578565', '0', '0', '0', '0', '袋', '500g', '1', '1', '1', '1', '1', '0', '0', null, '52', '189', '199', '174', '175', '&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;百味林 坚果炒货零食扁桃仁 500g/散装&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601140920_65423.jpg&quot; /&gt;&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 22:09:23', '0', '0'),
('229', '5345345', '百味林 休闲零食怪味花生 500g/散装', 'Upload/goods/2015-06/556c67a971f98.jpg', 'Upload/goods/2015-06/556c67a971f98.jpg', '0', '31', '45.00', '34.00', '232423', '0', '0', '0', '0', '袋', '500g', '1', '1', '1', '1', '1', '0', '0', null, '52', '189', '202', '174', '175', '&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;百味林 休闲零食怪味花生 500g/散装&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601141024_28613.jpg&quot; /&gt;&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 22:10:25', '0', '0'),
('230', '23425', 'wstmall 测试商品 华味亨开心果 180g', 'Upload/goods/2015-06/556c67f443e32.jpg', 'Upload/goods/2015-06/556c67f443e32.jpg', '0', '31', '23.00', '18.00', '3242423', '0', '0', '0', '0', '包', '180g', '1', '1', '1', '1', '1', '0', '0', null, '52', '189', '199', '174', '175', '&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;华味亨开心果 180g&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601141143_68881.jpg&quot; /&gt;&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 22:11:51', '0', '0'),
('231', '3223425', '瑞特斯波德德国进口巧克力 饼干牛奶巧克力 100g', 'Upload/goods/2015-06/556c692e6ff33.jpg', 'Upload/goods/2015-06/556c692e6ff33.jpg', '0', '31', '23.00', '21.00', '353442', '0', '0', '0', '0', '袋', '100g', '1', '1', '1', '1', '1', '0', '0', null, '52', '192', '218', '179', '180', '&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;瑞特斯波德德国进口巧克力 饼干夹心牛奶巧克力 100g/袋装&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601141656_34966.jpg&quot; /&gt;&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 22:17:04', '0', '0'),
('232', '23423534', '瑞特斯波德迷你七彩什锦巧克力 150g/袋装', 'Upload/goods/2015-06/556c697ab2cd6.jpg', 'Upload/goods/2015-06/556c697ab2cd6.jpg', '0', '31', '34.00', '32.00', '3242242', '0', '0', '0', '0', '袋', '150g', '1', '1', '1', '1', '1', '0', '0', null, '52', '192', '214', '179', '180', '&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;瑞特斯波德迷你七彩什锦巧克力 150g/袋装&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601141821_72649.jpg&quot; /&gt;&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 22:18:36', '0', '0'),
('233', '35345345', '瑞特斯波德全榛子黑巧克力100G', 'Upload/goods/2015-06/556c69dbef41f.jpg', 'Upload/goods/2015-06/556c69dbef41f.jpg', '0', '31', '45.00', '35.00', '23424', '0', '0', '0', '0', '袋', '100g', '1', '1', '1', '1', '1', '0', '0', null, '52', '192', '217', '179', '180', '&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;瑞特斯波德全榛子黑巧克力100G&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601141950_30343.jpg&quot; /&gt;&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 22:19:58', '0', '0'),
('234', '3294782', '瑞特斯波德全榛子白巧克力100G', 'Upload/goods/2015-06/556c6a3697d2e.jpg', 'Upload/goods/2015-06/556c6a3697d2e.jpg', '0', '31', '345.00', '234.00', '234325346', '0', '0', '0', '0', '袋', '100g', '1', '1', '1', '1', '1', '0', '0', null, '52', '192', '218', '179', '181', '&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;瑞特斯波德全榛子白巧克力100G&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601142144_78381.jpg&quot; /&gt;&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 22:21:49', '0', '0'),
('235', '35345', 'wstmall大山 原味脆皮花生 150G', 'Upload/goods/2015-06/556c6aa22f4be.jpg', 'Upload/goods/2015-06/556c6aa22f4be.jpg', '0', '31', '46.00', '34.00', '23425', '0', '0', '0', '0', '袋', '150g', '1', '1', '1', '1', '1', '0', '0', null, '52', '192', '214', '179', '181', '&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;大山 原味脆皮花生 150G&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601142301_43840.jpg&quot; /&gt;&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 22:23:09', '0', '0'),
('236', '2342565', 'wstmall测试商品费列罗钻石装巧克力礼盒 T2', 'Upload/goods/2015-06/556c6af924140.jpg', 'Upload/goods/2015-06/556c6af924140.jpg', '0', '31', '123.00', '100.00', '3243252', '0', '0', '0', '0', '盒', '24粒装 300g', '1', '1', '1', '1', '1', '0', '0', null, '52', '192', '216', '179', '180', '&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;24粒装 300g&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601142438_32409.jpg&quot; /&gt;&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 22:25:44', '0', '0'),
('237', '345345', '阿尔卑斯原味牛奶软糖138g袋装', 'Upload/goods/2015-06/556c6b829ea54.jpg', 'Upload/goods/2015-06/556c6b829ea54.jpg', '0', '31', '24.00', '20.00', '2342342', '0', '0', '0', '0', '包', '138g/袋', '1', '1', '1', '1', '1', '0', '0', null, '52', '192', '214', '179', '180', '&lt;p&gt;\n	阿尔卑斯原味牛奶软糖138g袋装\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601142706_90985.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 22:27:09', '0', '0'),
('238', '23452455', 'wstmall 测试商品 都乐香蕉脆片90G', 'Upload/goods/2015-06/556c6bd8ca1e9.jpg', 'Upload/goods/2015-06/556c6bd8ca1e9.jpg', '0', '31', '255.00', '233.00', '24242', '0', '0', '0', '0', '包', '90g', '1', '1', '1', '1', '1', '0', '0', null, '52', '192', '214', '179', '181', '&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;都乐香蕉脆片90G&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601142825_72155.jpg&quot; /&gt;&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 22:28:38', '0', '0'),
('239', '3432235', 'wstmall 测试商品奥利奥金装香草慕斯味饼干', 'Upload/goods/2015-06/556c6c9bb54b4.jpg', 'Upload/goods/2015-06/556c6c9bb54b4.jpg', '0', '31', '68.00', '45.00', '2342524', '0', '0', '0', '0', '盒', '', '1', '1', '1', '1', '1', '0', '0', null, '52', '193', '197', '179', '182', '&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;奥利奥金装香草慕斯味饼干 318g&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601143202_31651.jpg&quot; /&gt;&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 22:32:08', '0', '0'),
('240', '423522', '新加坡进口 明治动物乐园饼干70g', 'Upload/goods/2015-06/556c6d1fda908.jpg', 'Upload/goods/2015-06/556c6d1fda908.jpg', '0', '31', '15.00', '13.00', '24324141', '0', '0', '0', '0', '盒', '70g', '1', '1', '1', '1', '1', '0', '0', null, '52', '193', '197', '179', '183', '&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;新加坡进口 明治动物乐园饼干70g&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601143340_77574.jpg&quot; /&gt;&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 22:33:43', '0', '0'),
('241', '3252352', 'wstmall 测试 韩国进口 乐天杰克饼300g', 'Upload/goods/2015-06/556c6d896b188.jpg', 'Upload/goods/2015-06/556c6d896b188.jpg', '0', '31', '34.00', '23.00', '2342414', '0', '0', '0', '0', '盒', '300g', '1', '1', '1', '1', '1', '0', '0', null, '52', '193', '197', '179', '183', '&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;韩国进口 乐天杰克饼干 300g&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601143528_46134.jpg&quot; /&gt;&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 22:35:35', '0', '0'),
('242', '22525', '马来西亚进口 滨司大嘴猴披萨酥巧克力豆味90g', 'Upload/goods/2015-06/556c6dccb83ef.jpg', 'Upload/goods/2015-06/556c6dccb83ef.jpg', '0', '31', '56.00', '45.00', '2424314', '0', '0', '0', '0', '盒', '90g', '1', '1', '1', '1', '1', '0', '0', null, '52', '193', '197', '179', '180', '&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;马来西亚进口 滨司大嘴猴披萨酥巧克力豆味90g&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601143639_99939.jpg&quot; /&gt;&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 22:36:42', '0', '0'),
('243', '324223', 'wstmall测试商品丹麦蓝罐曲奇礼盒 125G', 'Upload/goods/2015-06/556c6e1b7385a.jpg', 'Upload/goods/2015-06/556c6e1b7385a.jpg', '0', '31', '34.00', '23.00', '2147483647', '0', '0', '0', '0', '盒', '125g', '1', '1', '1', '1', '1', '0', '0', null, '52', '193', '197', '179', '183', '&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;丹麦蓝罐曲奇礼盒 125G&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601143758_73918.jpg&quot; /&gt;&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 22:38:09', '0', '0'),
('244', '32324', '露依饼干 120G 草莓果酱', 'Upload/goods/2015-06/556c6ee763052.jpg', 'Upload/goods/2015-06/556c6ee763052.jpg', '0', '31', '34.00', '32.00', '243322', '0', '0', '0', '0', '包', '120g', '1', '1', '1', '1', '1', '0', '0', null, '52', '193', '195', '179', '183', '&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;露依饼干 120G 草莓果酱&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;/span&gt;&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601144120_37498.jpg&quot; /&gt;&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 22:41:25', '0', '0'),
('245', '31312', 'wstmall测试商品 谷优优选饼干礼盒', 'Upload/goods/2015-06/556c6f571349d.jpg', 'Upload/goods/2015-06/556c6f571349d.jpg', '0', '31', '56.00', '45.00', '23423425', '0', '0', '0', '0', '盒', '', '1', '1', '1', '1', '1', '0', '0', null, '52', '193', '196', '179', '183', '&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;谷优优选饼干礼盒&lt;/span&gt;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;span style=&quot;color:#333333;background-color:#FFFFFF;&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601144304_61067.jpg&quot; /&gt;&lt;/span&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 22:43:20', '0', '0'),
('246', '23543623', '日本 东京香蕉TOKYO BANANA长颈鹿麒麟香', 'Upload/goods/2015-06/556c6fa20a689.jpg', 'Upload/goods/2015-06/556c6fa20a689.jpg', '0', '31', '56.00', '34.00', '234233', '0', '0', '0', '0', '盒', '8枚', '1', '1', '1', '1', '1', '0', '0', null, '52', '193', '197', '179', '183', '&lt;p style=&quot;color:#666666;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	东京香蕉TOKYO BANANA长颈鹿麒麟香蕉蛋糕8枚&lt;br /&gt;\n【商品品牌】：日本东京香蕉TOKYO BANANA长颈鹿麒麟香蕉蛋糕8枚&lt;br /&gt;\n【保质期限】：保质期短7天务必注意&lt;br /&gt;\n【商品规格】：8枚/盒&lt;br /&gt;\n【商品产地】：日本&lt;br /&gt;\n【食用方法】：直接食用&lt;br /&gt;\n【保存方法】：请避免高温潮湿、直射日光，常温保存。\n&lt;/p&gt;\n&lt;p style=&quot;color:#666666;text-indent:0px;background-color:#FFFFFF;&quot;&gt;\n	&lt;br /&gt;\n此食品赏味期限只有7天，较短，即食，不能接受者慎拍！\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 22:44:47', '0', '0'),
('247', '234792', '养养 yumyum冬荫功面 酸辣虾味浓汤面 70g', 'Upload/goods/2015-06/556c72a1e9539.jpg', 'Upload/goods/2015-06/556c72a1e9539.jpg', '0', '31', '21.00', '18.00', '47866', '0', '0', '0', '0', '包', '70g', '1', '1', '1', '1', '1', '0', '0', null, '52', '191', '211', '179', '182', '&lt;h1 class=&quot;mh&quot; id=&quot;productMainName&quot; style=&quot;color:#333333;text-indent:0px;font-family:&amp;quot;microsoft yahei&amp;quot;;font-size:16px;font-style:normal;background-color:#FFFFFF;&quot;&gt;\n	养养 yumyum冬荫功面 酸辣虾味浓汤面 70g*5 泰国进口\n&lt;/h1&gt;\n&lt;p class=&quot;mh&quot; style=&quot;color:#333333;text-indent:0px;font-family:&amp;quot;microsoft yahei&amp;quot;;font-size:16px;font-style:normal;background-color:#FFFFFF;&quot;&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601145735_84163.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 22:57:39', '0', '0'),
('248', '78576', 'KOKA可口牌 鸡汤面（非油炸拉面）85g*4 新', 'Upload/goods/2015-06/556c731d48b11.jpg', 'Upload/goods/2015-06/556c731d48b11.jpg', '0', '31', '34.00', '32.00', '23435345', '0', '0', '0', '0', '包', '85g*4 ', '1', '1', '1', '1', '1', '0', '0', null, '52', '191', '210', '179', '182', '&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	测试商品，请勿下单\n&lt;/p&gt;\n&lt;p&gt;\n	&amp;nbsp;\n&lt;/p&gt;\n&lt;p&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601145917_52118.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 22:59:19', '0', '0'),
('249', '23479325', '可口 方便面 套餐多口味85g*10包 多口味泡面', 'Upload/goods/2015-06/556c736e4d85b.jpg', 'Upload/goods/2015-06/556c736e4d85b.jpg', '0', '31', '40.00', '37.00', '243242352', '0', '0', '0', '0', '袋', '10包', '1', '1', '1', '1', '1', '0', '0', null, '52', '191', '211', '179', '182', '&lt;h1 class=&quot;mh&quot; id=&quot;productMainName&quot; style=&quot;color:#333333;text-indent:0px;font-family:&amp;quot;microsoft yahei&amp;quot;;font-size:16px;font-style:normal;background-color:#FFFFFF;&quot;&gt;\n	可口 方便面 套餐多口味85g*10包 多口味泡面10包\n&lt;/h1&gt;\n&lt;p class=&quot;mh&quot; style=&quot;color:#333333;text-indent:0px;font-family:&amp;quot;microsoft yahei&amp;quot;;font-size:16px;font-style:normal;background-color:#FFFFFF;&quot;&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601150037_36130.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 23:00:38', '0', '0'),
('250', '434543253', '可口 KOKA鸡汤味泡面 非油炸面条340g 新加', 'Upload/goods/2015-06/556c741432478.jpg', 'Upload/goods/2015-06/556c741432478.jpg', '0', '31', '45.00', '40.00', '242432', '0', '0', '0', '0', '包', '340g', '1', '1', '1', '1', '1', '0', '0', null, '52', '191', '210', '179', '182', '&lt;h1 class=&quot;mh&quot; id=&quot;productMainName&quot; style=&quot;color:#333333;text-indent:0px;font-family:&amp;quot;microsoft yahei&amp;quot;;font-size:16px;font-style:normal;background-color:#FFFFFF;&quot;&gt;\n	可口 KOKA鸡汤味泡面 非油炸面条340g 新加坡进口食品\n&lt;/h1&gt;\n&lt;p class=&quot;mh&quot; style=&quot;color:#333333;text-indent:0px;font-family:&amp;quot;microsoft yahei&amp;quot;;font-size:16px;font-style:normal;background-color:#FFFFFF;&quot;&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601150318_71844.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 23:03:28', '0', '0'),
('251', '2345354', '可口 KOKA香辣芝麻汤味快熟面 非油炸4*85g', 'Upload/goods/2015-06/556c74750dc5b.jpg', 'Upload/goods/2015-06/556c74750dc5b.jpg', '0', '31', '45.00', '41.00', '3252352', '0', '0', '0', '0', '包', '4*85', '1', '1', '1', '1', '1', '0', '0', null, '52', '191', '211', '179', '182', '&lt;h1 class=&quot;mh&quot; id=&quot;productMainName&quot; style=&quot;color:#333333;text-indent:0px;font-family:&amp;quot;microsoft yahei&amp;quot;;font-size:16px;font-style:normal;background-color:#FFFFFF;&quot;&gt;\n	可口 KOKA香辣芝麻汤味快熟面 非油炸4*85g&lt;span class=&quot;Apple-converted-space&quot;&gt;&amp;nbsp;&lt;/span&gt;\n&lt;/h1&gt;\n&lt;h1 class=&quot;mh&quot; style=&quot;color:#333333;text-indent:0px;font-family:&amp;quot;microsoft yahei&amp;quot;;font-size:16px;font-style:normal;background-color:#FFFFFF;&quot;&gt;\n	&lt;span class=&quot;Apple-converted-space&quot;&gt;&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601150513_12812.jpg&quot; /&gt;&lt;/span&gt;\n&lt;/h1&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 23:05:21', '0', '0'),
('252', '234928342', 'wstmall测试商品 东远 金枪鱼罐头 蔬菜味', 'Upload/goods/2015-06/556c74f22044b.jpg', 'Upload/goods/2015-06/556c74f22044b.jpg', '0', '31', '45.00', '40.00', '2342342', '0', '0', '0', '0', '罐', '100g', '1', '1', '1', '1', '1', '0', '0', null, '52', '191', '211', '179', '182', '&lt;h1 class=&quot;mh&quot; id=&quot;productMainName&quot; style=&quot;color:#333333;text-indent:0px;font-family:&amp;quot;microsoft yahei&amp;quot;;font-size:16px;font-style:normal;background-color:#FFFFFF;&quot;&gt;\n	东远 金枪鱼罐头 蔬菜味 100g 韩国进口\n&lt;/h1&gt;\n&lt;p class=&quot;mh&quot; style=&quot;color:#333333;text-indent:0px;font-family:&amp;quot;microsoft yahei&amp;quot;;font-size:16px;font-style:normal;background-color:#FFFFFF;&quot;&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601150700_65818.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 23:07:12', '0', '0'),
('253', '3453636', '可口 KOKA 星洲叻沙 快熟面 油炸辣味 90g', 'Upload/goods/2015-06/556c758961ee6.jpg', 'Upload/goods/2015-06/556c758961ee6.jpg', '0', '31', '34.00', '23.00', '341241', '0', '0', '0', '0', '筒', '90g', '1', '1', '1', '1', '1', '0', '0', null, '52', '191', '211', '179', '182', '&lt;h1 class=&quot;mh&quot; id=&quot;productMainName&quot; style=&quot;color:#333333;text-indent:0px;font-family:&amp;quot;microsoft yahei&amp;quot;;font-size:16px;font-style:normal;background-color:#FFFFFF;&quot;&gt;\n	可口 KOKA 星洲叻沙 快熟面 油炸辣味 90g 新加坡进口\n&lt;/h1&gt;\n&lt;p class=&quot;mh&quot; style=&quot;color:#333333;text-indent:0px;font-family:&amp;quot;microsoft yahei&amp;quot;;font-size:16px;font-style:normal;background-color:#FFFFFF;&quot;&gt;\n	&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601150937_29220.jpg&quot; /&gt;\n&lt;/p&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 23:09:41', '0', '0'),
('254', '23523', '可口 /KOKA 新加坡进口方便面 多口味12袋装', 'Upload/goods/2015-06/556c75d780e62.jpg', 'Upload/goods/2015-06/556c75d780e62.jpg', '0', '31', '45.00', '41.90', '5523423', '0', '0', '0', '0', '包', '12袋装', '1', '1', '1', '1', '1', '0', '0', null, '52', '191', '211', '179', '182', '&lt;table class=&quot;wst-form&quot;&gt;\n	&lt;tbody&gt;\n		&lt;tr&gt;\n			&lt;td&gt;\n				&lt;p&gt;\n					测试商品，请勿下单\n				&lt;/p&gt;\n				&lt;p&gt;\n					&amp;nbsp;\n				&lt;/p&gt;\n				&lt;p&gt;\n					&lt;img alt=&quot;&quot; src=&quot;/product/wstmall/Upload/image/20150601/20150601151136_36320.jpg&quot; /&gt;\n				&lt;/p&gt;\n			&lt;/td&gt;\n		&lt;/tr&gt;\n		&lt;tr&gt;\n			&lt;th width=&quot;120&quot;&gt;\n				&lt;span&gt;&lt;/span&gt;\n			&lt;/th&gt;\n			&lt;td&gt;\n				&lt;p&gt;\n					&amp;nbsp;\n				&lt;/p&gt;\n				&lt;p&gt;\n					&amp;nbsp;\n				&lt;/p&gt;\n				&lt;p&gt;\n					&amp;nbsp;\n				&lt;/p&gt;\n			&lt;/td&gt;\n		&lt;/tr&gt;\n	&lt;/tbody&gt;\n&lt;/table&gt;', '0', '0', '0', '0', '1', null, '0', null, '1', null, '2015-06-01 23:11:40', '0', '0');
