/**
	[OECRM] (C)2012~2099 OEdev.Net Inc.
	This is NOT a freeware, use is subject to license terms
	$Id: ajax.js 2014-05-04 OEdev $ 
*/

/**
 * 根据部门ID获取对应的系统用户
 * @param:: string $departArgId 部门元素ID
 * @param:: string $selname 系统用户元素ID
 * @param:: tinyint $child 是否包含子部门
 * @param:: tinyint $text 内容提示
*/
function ajaxSelectDepartAdmin(departArgId, selname, child, text) {
	if (typeof(child) == 'undefined') {child = 1;}
	if (typeof(text) == 'undefined') {text = '=请选择=';}
	var departid = $('#'+departArgId).val();
	if (departid == '') {
		alert('请选择部门');
		return false;
	}
	var option_html = "";
	//DATA
	$.getJSON("index.php?m=admin&c=admins&a=departadmin&departid="+departid+"&child="+child+"&r="+get_rndnum(8),
		function(data){
			$.each(data, function(entryIndex, obj){
				option_html = option_html + "<option value='"+obj.adminid+"'>"+obj.lastname+"</option>";
			});
			//HTML
			var result = '';
			result = "<select name='"+selname+"' id='"+selname+"'>";
			result += "<option value='0'>"+text+"</option>";
			if (option_html != '') {
				result += option_html;
			}
			result += "</select>";
			$('#json_'+selname).html(result);

		}
	);
}

/**
 * 根据客户ID获取对应的联系人列表
 * @param:: string $argId 客户元素ID
 * @param:: string $selname 系统用户元素ID
 * @param:: tinyint $text 内容提示
*/
function ajaxSelectCustContact(argId, selname, inid, text) {
	if (typeof(text) == 'undefined') {text = '=请选择=';}
	var custid = $('#'+argId).val();
	if (custid > 0) {
		var option_html = "";
		//DATA
		$.getJSON("index.php?m=admin&c=contact&a=jsoncontact&custid="+custid+"&r="+get_rndnum(8),
			function(data){
				$.each(data, function(entryIndex, obj){
					option_html += "<option value='"+obj.contactid+"'";
					if (obj.contactid == inid) {
						option_html += " selected";
					}
					option_html += ">"+obj.lastname+"</option>";
				});
				//HTML
				var result = '';
				result = "<select name='"+selname+"' id='"+selname+"'>";
				result += "<option value='0'>"+text+"</option>";
				if (option_html != '') {
					result += option_html;
				}
				result += "</select>";
				$('#json_'+selname).html(result);
			}
		);
	}
	else {
		result = "<select name='"+selname+"' id='"+selname+"'>";
		result += "<option value='0'>"+text+"</option>";
		result += "</select>";
		$('#json_'+selname).html(result);
	}
}

/**
 * 获取我的下属 select
 * @param:: string $selname SELECT名称
 * @param:: int $inid 当前用户ID
 * @param:: tinyint $text 内容提示
*/
function ajaxSelectSubAdmin(selname, inid, text) {
	if (typeof(text) == 'undefined') {text = '=全部=';}
	var option_html = "";
	//DATA
	$.getJSON("index.php?m=admin&c=admins&a=jsonsubadmin&r="+get_rndnum(8),
		function(data){
			$.each(data, function(entryIndex, obj){
				option_html += "<option value='"+obj.adminid+"'";
				if (obj.adminid == inid) {
					option_html += " selected";
				}
				option_html += ">"+obj.lastname+"-"+obj.rolename+"</option>";
			});
			//HTML
			var result = '';
			result = "<select name='"+selname+"' id='"+selname+"'>";
			result += "<option value='0'>"+text+"</option>";
			if (option_html != '') {
				result += option_html;
			}
			result += "</select>";
			$('#json_'+selname).html(result);
		}
	);
}

