/**
 * [OEmarry] (C)2010-2099 OEMARRY.COM Inc.
 * Email：service@phpcoo.com，phpcoo@qq.com
 * This is NOT a freeware, use is subject to license terms
 * $ Last update 2015-08-05 by OEdev $
*/
var oeClass = {
	create: function() {
		return function() {
			this.initialize.apply(this, arguments);
		}
	}
}
Object.extend = function(destination, source) {
	for (var property in source) {
		destination[property] = source[property];
	}
	return destination;
}
var TransformView = oeClass.create();

TransformView.prototype = {
	initialize: function(container, slider, parameter, count, options) {
		if (parameter <= 0 || count <= 0) return;
		var oContainer = document.getElementById(container),
			oSlider = document.getElementById(slider),
			oThis = this;
		this.Index = 0;
		this._timer = null;
		this._slider = oSlider;
		this._parameter = parameter;
		this._count = count || 0;
		this._target = 0;
		this.SetOptions(options);
		this.Up = !! this.options.Up;
		this.Step = Math.abs(this.options.Step);
		this.Time = Math.abs(this.options.Time);
		this.Auto = !! this.options.Auto;
		this.Pause = Math.abs(this.options.Pause);
		this.onStart = this.options.onStart;
		this.onFinish = this.options.onFinish;
		oContainer.style.overflow = "hidden";
		oContainer.style.position = "relative";
		oSlider.style.position = "absolute";
		oSlider.style.top = oSlider.style.left = 0;
	},
	SetOptions: function(options) {
		this.options = {
			Up: true,
			Step: 5,
			Time: 10,
			Auto: true,
			Pause: Math.round(Math.random() * (1800 + 1) + 1800),
			onStart: function() {},
			onFinish: function() {}
		};
		Object.extend(this.options, options || {});
	},
	Start: function() {
		if (this.Index < 0) {
			this.Index = this._count - 1;
		} else if (this.Index >= this._count) {
			this.Index = 0;
		}
		this._target = -1 * this._parameter * this.Index;
		this.onStart();
		this.Move();
	},
	Move: function() {
		clearTimeout(this._timer);
		var oThis = this,
			style = this.Up ? "top" : "left",
			iNow = parseInt(this._slider.style[style]) || 0,
			iStep = this.GetStep(this._target, iNow);
		if (iStep != 0) {
			this._slider.style[style] = (iNow + iStep) + "px";
			this._timer = setTimeout(function() {
				oThis.Move();
			}, this.Time);
		} else {
			this._slider.style[style] = this._target + "px";
			this.onFinish();
			if (this.Auto) {
				this._timer = setTimeout(function() {
					oThis.Index++;
					oThis.Start();
				}, this.Pause);
			}
		}
	},
	GetStep: function(iTarget, iNow) {
		var iStep = (iTarget - iNow) / this.Step;
		if (iStep == 0) return 0;
		if (Math.abs(iStep) < 1) return (iStep > 0 ? 1 : -1);
		return iStep;
	},
	Stop: function(iTarget, iNow) {
		clearTimeout(this._timer);
		this._slider.style[this.Up ? "top" : "left"] = this._target + "px";
	}
};

function Each(list, fun) {
	for (var i = 0, len = list.length; i < len; i++) {
		fun(list[i], i);
	}
};

function oePicSlide(TDiv, TImg, TNum, TW, TC, TRun) {
	//var objs2 = $("#"+TNum).getElementsByTagName("li");
	var objs2 = $("#"+TNum+" li");
	var tv2 = new TransformView(TDiv, TImg, TW, TC, {
		onStart: function() {
			Each(objs2, function(o, i) {
				o.className = tv2.Index == i ? "on" : "";
			})
		},
		Up: TRun
	});
	tv2.Start();
	Each(objs2, function(o, i) {
		o.onmouseover = function() {
			o.className = "on";
			tv2.Auto = false;
			tv2.Index = i;
			tv2.Start();
		}
		o.onmouseout = function() {
			o.className = "";
			tv2.Auto = true;
			tv2.Start();
		}
	});
}