<?php
/**
 * Copyright (C) OEmarry All rights reserved.
 * <E-Mail：phpcoo@qq.com>
 * Url http://www.phpcoo.com
 *     http://www.oemarry.com
 * Update 2017.05.25
 */
header("Content-type: text/html; charset=utf-8");
@set_time_limit(0);
@error_reporting(E_ALL & ~ E_NOTICE);
define('BASE_ROOT', dirname(__FILE__).'/');
require_once(BASE_ROOT."source/core/oephp/Application.php");
require_once(BASE_ROOT."source/core/oephp/oemarry.init.php");
$upgrade_title = "OEmarryV1.3.R60818 to OEmarryV1.4.R70526";
$upgrade_version = "OEmarryV1.4.R70526";
echo("<html>\n");
echo("<head>\n");
echo("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=".OEMARRY_CHARSET."\" />\n");
echo("<title>".$upgrade_title."升级程序</title>\n");
echo("<style>body{padding:20px;text-align:center;font-size:14px; color:#333;}p{line-height:25px;}</style>");
echo("</head>\n");
echo("<body>\n");
$action = XRequest::getArgs('action');

if(empty($action)){
	echo("
		<p>本程序用于升级 ".$upgrade_title."</p>
		<p><a href='upgrade.php?action=upgrade'>请点执行升级</a></p>
	");
}

elseif ($action == 'upgrade'){
	echo("
		<p>本程序用于升级 ".$upgrade_title."</p>
		<p><font color='red'>数据表升级，请稍等......</font></p>
	");

	//更新
	update_payment_sdk();

	#升级完成
	echo("<p><font color='green'>恭喜你，数据表升级成功！<br /><a href='upgrade.php'>返回升级页面</a>  <a href='upgrade.php?action=del'>删除升级文件</a></p>");
}

elseif ($action == 'del') {
    OE::loadUtil('file');
    XFile::delFile('upgrade.php');
	echo("<font color=red>升级文件删除成功</font>");
}

/*------------------------------- update Begin --------------------------*/

//payment_sdk
function update_payment_sdk() {
	$table = "payment_sdk";
	$sql = "SELECT * FROM ".DB_PREFIX.$table." WHERE `sdkname`='depositpay'";
	$rows = OE::$obj->fetch_first($sql);
	if (empty($rows)) {
		$addon_array = array(
			'sdkid'=>999,
			'title'=>'余额支付',
			'intro'=>'余额支付',
			'sdkname'=>'depositpay',
			'type'=>'PC',
			'orders'=>'100',
		);
		OE::$obj->insert(DB_PREFIX.$table, $addon_array);
		unset($addon_array);
	}
	unset($sql, $rows);

	echo "<font color='blue'>[".$table."]表更新成功</font><br />";
}

/*------------------------------- update End --------------------------*/


/*-------------------------------- 数据表操作函数 Start ---------------------------------*/
/**
 * 更新数据表字段
 * @param:: string $table 表名 不带前缀
 * @param:: string $field 字段名
 * @param:: string $sql SQL语句
 * @return:: null
*/
function run_altertable($table, $field, $sql){
    if (!empty($field) && !empty($sql)) {
        $alter_action = 0;
		if (strtoupper(substr($sql, 0, 9)) == 'ADD INDEX') {
			$alter_action = 4;
		} 
		elseif (strtoupper(substr($sql, 0, 3)) == 'ADD') {
			$alter_action = 1;
		}
        elseif (strtoupper(substr($sql, 0, 6)) == 'CHANGE') {
            $alter_action = 2;
		} 
        elseif (strtoupper(substr($sql, 0, 4)) == 'DROP') {
            $alter_action = 3;
		}
        
        //创建字段
		if ($alter_action == 1) {
			//不存在字段才创建
            if (false === check_exist_field($table, $field)) {
                OE::$obj->alter_table(DB_PREFIX.$table, $sql);
			}
		} 
        //修改字段
        elseif ($alter_action == 2) {
			//存在字段才修改
            if (true === check_exist_field($table, $field)) {
                OE::$obj->alter_table(DB_PREFIX.$table, $sql);
			}
		} 
        //删除字段
        elseif ($alter_action == 3) {
			//存在字段才删除
            if (true === check_exist_field($table, $field)) {
                OE::$obj->alter_table(DB_PREFIX.$table, $sql);
            }
		}
		//创建索引
		elseif ($alter_action  == 4) {
			//存在字段才执行建索引
            if (true === check_exist_field($table, $field)) {
                OE::$obj->alter_table(DB_PREFIX.$table, $sql);
			}
		}
	}
}

/**
 * 判断数据表是否含有某个字段
 * @param:: string $table 表名 不带前缀
 * @param:: string $field 字段名
 * @return:: bool true/false
*/
function check_exist_field($table, $field){
	$array_column = array();
	$columns = get_table_columns($table);
	$i = 0;
	if (!empty($columns)) {
        foreach($columns as $key=>$value){
            if (empty($array_column)) {
                $array_column = array(
                    $i=>$key
                );
            }
            else {
                $array_column = array_merge($array_column, array($i=>$key));
            }
			$i++;
		}
        if (in_array($field, $array_column)) {
            return true;
        }
        else {
            return false;
        }
	}
    else {
		//die($table."Not exists!");
	}
}

/**
 * 获取某个数据表所有字段名
 * @param:: string $table 数据表名 不带前缀
 * @return:: array
*/
function get_table_columns($table) {
    $tablecolumns = array();
	if (OE::$obj->version() > '4.1') {
		$query = OE::$obj->query("SHOW FULL COLUMNS FROM ".DB_PREFIX."{$table}", 'SILENT');
	} 
    else {
		$query = OE::$obj->query("SHOW COLUMNS FROM ".DB_PREFIX."{$table}", 'SILENT');
	}
	while ($field = @OE::$obj->fetch_array($query)) {
		$tablecolumns[$field['Field']] = $field;
	}
	return $tablecolumns;
}

/**
 * 检测是否含有数据表
 * @param:: string $table 表名 不带前缀
 * @return:: bool true/false
*/
function check_exist_table($table) {
	$status = false;
    $status = OE::$obj->table_exist($table);
	return $status;
}
/*-------------------------------- 数据表操作函数 End ---------------------------------*/
echo("</body>\n");
echo("</html>");
?>