CREATE TABLE IF NOT EXISTS xercms_archives (
  `id` int(10) NOT NULL auto_increment,
  `uid` int(10) NOT NULL default '0',
  `title` varchar(60) NOT NULL default '',
  `column` int(8) NOT NULL default '0',
  `area` int(8) NOT NULL default '0',
  `lang` int(8) NOT NULL default '0',
  `icon` tinyint(1) NOT NULL default '0', 
  `image` varchar(255) NOT NULL default '',
  `flag` tinyint(1) unsigned NOT NULL default '0',
  `model` tinyint(3) NOT NULL default '0', 
  `special` int(8) NOT NULL default '0',
  `ctime` int(10) NOT NULL default '0',
  `mtime` int(10) NOT NULL default '0',
  `state` tinyint(1) unsigned NOT NULL default '0',
  `comment` tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY (`id`),
  INDEX(`column`),
  INDEX(`area`),
  INDEX(`lang`),
  INDEX(`uid`),
  INDEX(`flag`),
  INDEX(`model`),
  INDEX(`special`),
  INDEX(`state`) 
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_archive_search (
  `name` varchar(100) NOT NULL default '',
  `time` int(8) unsigned NOT NULL default '0',
  `ip` varchar(32) NOT NULL default '',
  `status` tinyint(1) unsigned NOT NULL default '0', 
  `count` int(8) unsigned NOT NULL default '1',
  INDEX (`name`),
  INDEX (`status`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_count (
  `id` int(10) unsigned NOT NULL auto_increment,
  `hits` int(8) unsigned NOT NULL default '0',
  `flower` int(8) unsigned NOT NULL default '0',
  `egg` int(8) unsigned NOT NULL default '0',
  `score` int(8) unsigned NOT NULL default '0',
  `fav` int(10) unsigned NOT NULL DEFAULT '0', 
  `comments` int(10) unsigned NOT NULL DEFAULT '0', 
  PRIMARY KEY  (id)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS `xercms_data_article` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `note` varchar(300) DEFAULT '',
  `author` varchar(300) DEFAULT '',
  `resource` varchar(300) DEFAULT '',
  `content` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `xercms_comment_article` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `aid` int(10) unsigned NOT NULL DEFAULT '0',
  `say` varchar(400) NOT NULL DEFAULT '',
  `ip` varchar(32) NOT NULL DEFAULT '',
  `ctime` int(10) unsigned NOT NULL DEFAULT '0',
  `stamp` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `xercms_data_product` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `pics` varchar(300) DEFAULT '',
  `price` int(10) DEFAULT '0',
  `note` varchar(300) DEFAULT '',
  `intro` text,
  `params` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

CREATE TABLE IF NOT EXISTS `xercms_comment_product` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uid` int(10) unsigned NOT NULL DEFAULT '0',
  `aid` int(10) unsigned NOT NULL DEFAULT '0',
  `say` varchar(400) NOT NULL DEFAULT '',
  `ip` varchar(32) NOT NULL DEFAULT '',
  `ctime` int(10) unsigned NOT NULL DEFAULT '0',
  `stamp` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `aid` (`aid`),
  KEY `uid` (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;