CREATE TABLE IF NOT EXISTS xercms_domain_list (
  `id` int(8) unsigned NOT NULL auto_increment,
  `domain` varchar(100) NOT NULL DEFAULT '',
  `time` int(8) unsigned NOT NULL default '0', 
  `uid` int(8) unsigned NOT NULL default '0',
  `params` varchar(200) NOT NULL DEFAULT '',  
  PRIMARY KEY  (`id`), 
  INDEX(`domain`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_auth_error (
  `ip` varchar(32) NOT NULL DEFAULT '',
  `time` int(8) unsigned NOT NULL default '0', 
  `total` int(8) unsigned NOT NULL default '0', 
  INDEX(`ip`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_form_model (
  `fid` int(8) unsigned NOT NULL auto_increment,
  `name` varchar(50) NOT NULL DEFAULT '',
  `sname` varchar(20) NOT NULL DEFAULT '',
  `note` varchar(32) NOT NULL DEFAULT '',
  `limit`  int(10) unsigned NOT NULL default '0', 
  `stime`  int(10) unsigned NOT NULL default '0', 
  `etime`  int(10) unsigned NOT NULL default '0', 
  `uid`  int(10) unsigned NOT NULL default '0',
  `time` int(10) unsigned NOT NULL default '0', 
  `ip` varchar(32) NOT NULL DEFAULT '',
  `state` TINYINT(1) unsigned NOT NULL default '1',
  `access` text,
  `struct` text,
  PRIMARY KEY  (`fid`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_form_count (
  `fid` int(10) unsigned NOT NULL default '0',
  `number`  int(10) unsigned NOT NULL default '0',
  `uid`  int(10) unsigned NOT NULL default '0',
  `time` int(10) unsigned NOT NULL default '0', 
  INDEX (`fid`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_form_submit (
  `sid`   int(10) unsigned NOT NULL auto_increment,
  `fid` int(10) unsigned NOT NULL default '0',
  `uid`  int(10) unsigned NOT NULL default '0',
  `ip` varchar(32) NOT NULL DEFAULT '',
  `time` int(10) unsigned NOT NULL default '0', 
  `state`  tinyint(1) unsigned NOT NULL default '0',
  PRIMARY KEY  (`sid`),
  INDEX (`fid`),
  INDEX (`uid`),
  INDEX (`state`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_form_data (
  `sid` int(10) unsigned NOT NULL default '0',
  `txt` text, 
  INDEX(`sid`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_form_track (
  `sid`  int(10) unsigned NOT NULL default '0',
  `uid`  int(10) unsigned NOT NULL default '0',
  `time` int(10) unsigned NOT NULL default '0', 
  `ip`   varchar(32) NOT NULL DEFAULT '', 
  `msg`  varchar(500)  NOT NULL default '',  
  INDEX(sid)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_shop_cart (
  `id`   int(10) unsigned NOT NULL auto_increment,
  `uid`  int(10) unsigned NOT NULL default '0',
  `arc`  int(10) unsigned NOT NULL default '0', 
  `time` int(10) unsigned NOT NULL default '0', 
  `num`  int(10) unsigned NOT NULL default '0',
  `note` varchar(100) NOT NULL DEFAULT '', 
  PRIMARY KEY  (`id`), 
  INDEX(`arc`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_shortcut_archive (
  `uid`  int(10) unsigned NOT NULL default '0',
  `mid`  int(10) unsigned NOT NULL default '0', 
  `cid`  int(10) unsigned NOT NULL default '0', 
  `time` int(10) unsigned NOT NULL default '0',  
  INDEX(`uid`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_shop_activity (
  `aid`   int(10) unsigned NOT NULL  auto_increment,
  `stime`   int(10) unsigned NOT NULL default '0', 
  `etime` int(10) unsigned NOT NULL default '0', 
  `limit` int(10) unsigned NOT NULL default '0', 
  `groups` varchar(200) NOT NULL DEFAULT '', 
  PRIMARY KEY  (`aid`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_shop_archive (
  `aid`   int(10) unsigned NOT NULL default '0',
  `mid`   int(10) unsigned NOT NULL default '0', 
  `price` int(10) NOT NULL default '0', 
  `number` int(10) NOT NULL default '0',  
  `activity` int(10) unsigned NOT NULL default '0',
  INDEX(`aid`), 
  INDEX(`mid`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_shop_trade (
  `tid`   int(10) unsigned NOT NULL auto_increment,
  `uid`   int(10) unsigned NOT NULL default '0',
  `ip`    varchar(32) NOT NULL DEFAULT '', 
  `stime` int(10) unsigned NOT NULL default '0', 
  `etime` int(10) unsigned NOT NULL default '0',  
  `state` tinyint(1) NOT NULL default '0',
  `express` varchar(32) NOT NULL DEFAULT '',  
  `receiver` int(10) unsigned NOT NULL default '0',  
  `money`  int(10) unsigned NOT NULL default '0',  
  PRIMARY KEY  (`tid`), 
  INDEX(`uid`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_shop_order (
  `tid`    int(10) unsigned NOT NULL,
  `arc`    int(10) unsigned NOT NULL default '0',
  `price`  int(10) unsigned NOT NULL default '0',
  `number` int(10) unsigned NOT NULL default '0',
  `note`   varchar(100) NOT NULL DEFAULT '',  
  INDEX(`tid`),
  INDEX(`arc`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_shop_day (
  `arc`   int(10) unsigned NOT NULL,
  `day`   int(5) unsigned NOT NULL, 
  `sales` int(10) unsigned NOT NULL, 
  INDEX(`arc`),
  INDEX(`day`)
)  engine=MyISAM default charset = utf8;


CREATE TABLE IF NOT EXISTS xercms_shop_week (
  `arc`   int(10) unsigned NOT NULL,
  `week`  int(5) unsigned NOT NULL, 
  `sales` int(10) unsigned NOT NULL, 
  INDEX(`arc`),
  INDEX(`week`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_shop_month (
  `arc`   int(10) unsigned NOT NULL,
  `month` int(5) unsigned NOT NULL, 
  `sales` int(10) unsigned NOT NULL, 
  INDEX(`arc`),
  INDEX(`month`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_shop_receiving (
  `id`   int(10) unsigned NOT NULL auto_increment,
  `uid`  int(10) unsigned NOT NULL default '0',
  `name` varchar(200) NOT NULL DEFAULT '', 
  `zipcode` varchar(32) NOT NULL DEFAULT '', 
  `tel` int(10) unsigned NOT NULL default '0', 
  `address` varchar(200) NOT NULL DEFAULT '',  
  PRIMARY KEY  (`id`), 
  INDEX(`uid`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_vote (
  `id` int(10) unsigned NOT NULL auto_increment,
  `title` varchar(100) NOT NULL DEFAULT '',
  `groups` varchar(200) NOT NULL DEFAULT '', 
  `ctime` int(8) unsigned NOT NULL default '0', 
  `stime` int(8) unsigned NOT NULL default '0', 
  `etime` int(8) unsigned NOT NULL default '0', 
  `state` tinyint(1) NOT NULL default '0',
  `uid` int(8) unsigned NOT NULL default '0',
  `limit` int(8) unsigned NOT NULL default '0', 
  `number` int(8) unsigned NOT NULL default '0',
  `over` int(8) NOT NULL default '0', 
  `detail` text,
  PRIMARY KEY  (`id`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_vote_count (
  `vid` int(10) unsigned NOT NULL,
  `oid` int(10) unsigned NOT NULL,
  `total` int(10) unsigned NOT NULL default '0',
  INDEX(`vid`),
  INDEX(`oid`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_vote_log (
  `uid` int(10) unsigned NOT NULL,
  `time` int(8) unsigned NOT NULL,
  `ip` varchar(100) NOT NULL DEFAULT '',
  `vid` int(10) unsigned NOT NULL,
  `oid` int(10) unsigned NOT NULL,
  INDEX(`vid`),
  INDEX(`uid`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_vote_options (
  `oid` int(10) unsigned NOT NULL auto_increment,
  `vid` int(10) unsigned NOT NULL,
  `text` varchar(500) NOT NULL DEFAULT '',  
  INDEX(`vid`),
  INDEX(`oid`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_log_deduct (
  `uid` int(10) unsigned NOT NULL default '0',
  `time` int(10) unsigned NOT NULL default '0', 
  `cat` tinyint(1) NOT NULL default '0',
  `id` int(10) NOT NULL default '0',
  INDEX(`uid`),  
  INDEX(`cat`),
  INDEX(`id`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_control (
  `id` int(8) unsigned NOT NULL auto_increment,
  `parent` int(8) unsigned NOT NULL default '0',
  `title` varchar(100) NOT NULL DEFAULT '', 
  `url` varchar(255) NOT NULL DEFAULT '',
  `disabled` tinyint(1) NOT NULL default '0', 
  `extra` varchar(100) NOT NULL DEFAULT '', 
  PRIMARY KEY  (`id`), 
  INDEX(`disabled`),
  INDEX(`parent`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_shortcut (
  `id` int(10) unsigned NOT NULL auto_increment,
  `uid` int(10) unsigned NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `url` varchar(100) NOT NULL default '',
  `time` int(10) NOT NULL default '0',
  PRIMARY KEY (`id`),
  INDEX(`uid`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_select_data (
  `id` int(8) unsigned NOT NULL auto_increment,
  `title` varchar(200) NOT NULL DEFAULT '',
  `uid` int(10) unsigned NOT NULL default '0',
  `time` int(10) unsigned NOT NULL default '0', 
  `sql` varchar(500) NOT NULL DEFAULT '',
  `format` tinyint(1) NOT NULL default '0',
  `outer` tinyint(1) NOT NULL default '0', 
  `state` tinyint(1) NOT NULL default '0', 
  `expire` int(10) NOT NULL default '0', 
  `template` text, 
  PRIMARY KEY  (`id`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_payment (
  `pid` int(8) unsigned NOT NULL auto_increment,
  `state` tinyint(3) unsigned NOT NULL default '0',
  `uid` int(10) unsigned NOT NULL default '0',
  `time` int(10) unsigned NOT NULL default '0', 
  `ename` varchar(50) NOT NULL default '',
  `logo` varchar(255) NOT NULL default '',
  `name` varchar(30) NOT NULL default '',
  `partner` varchar(255) NOT NULL default '',
  `key` varchar(255) NOT NULL default '',
  `mail` varchar(255) NOT NULL default '',
  `notify` varchar(255) NOT NULL default '',
  `return` varchar(255) NOT NULL default '',
  `submit` varchar(255) NOT NULL default '', 
  `des` varchar(300) NOT NULL default '',
  `extra` TEXT,
  PRIMARY KEY  (pid),
  INDEX(`state`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_consume_class (
  `id` int(10) unsigned NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  `des` varchar(200) NOT NULL default '',
  PRIMARY KEY  (id)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_funds_record (
  `idstr` varchar(50) NOT NULL default '',
  `uid` int(10) unsigned NOT NULL default '0',
  `date` int(10) unsigned NOT NULL default '0',  
  `time` int(10) unsigned NOT NULL default '0', 
  `cid` TINYINT(3) unsigned NOT NULL default '0',
  `value` FLOAT NOT NULL default '0',
  `over` FLOAT unsigned NOT NULL default '0', 
  `state` TINYINT(3) unsigned NOT NULL default '0',
  `class` TINYINT(3) unsigned NOT NULL default '0',
  `ftime` int(10) unsigned NOT NULL default '0', 
  INDEX(`idstr`),
  INDEX(`uid`),
  INDEX(`date`),
  INDEX(`cid`),
  INDEX(`state`),
  INDEX(`class`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_funds_detail (
  `idstr` varchar(50) NOT NULL default '',
  `note` varchar(255) NOT NULL default '',
  `data` TEXT,
  INDEX(`idstr`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_error_ips (
  `ip` varchar(32) NOT NULL default '', 
  `time` int(10) unsigned NOT NULL default '0',
  `num` tinyint(3) unsigned NOT NULL default '0',
  INDEX(ip)
)  engine=MEMORY default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_error_login (
  `uid`  int(10) unsigned NOT NULL default '0',
  `time` int(10) unsigned NOT NULL default '0',
  `num` tinyint(3) unsigned NOT NULL default '0',
  INDEX(uid)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_slides (
  `id`    int(8) unsigned NOT NULL auto_increment,
  `uid`   int(10) unsigned NOT NULL default '0',
  `ctime` int(10) unsigned NOT NULL default '0',
  `mtime` int(10) unsigned NOT NULL default '0',
  `sign`  varchar(10) NOT NULL default '',
  `img`   varchar(255) NOT NULL default '',
  `url` varchar(100) NOT NULL default '',
  `title` varchar(100) NOT NULL default '',
  `extra` varchar(255) NOT NULL default '',
  PRIMARY KEY  (id),
  INDEX(sign),
  INDEX(uid)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_plugin
(
     `id`        int(8) unsigned NOT NULL auto_increment,
     `name`      varchar(100) NOT NULL default '',
     `developer` varchar(255) NOT NULL default '',
     `language`  varchar(100) NOT NULL default 'zh-cn',
     `pid`       varchar(100) NOT NULL default '',  
     `logo`      varchar(255) NOT NULL default 'http://www.xercms.com/Assets/images/logo.png',
     `des`       text,
     `link`      varchar(255) NOT NULL default 'http://www.xercms.com/',
     `contact`   varchar(100) NOT NULL default '',  
     `state`     SMALLINT NOT NULL default '0',
     `version`   varchar(100) NOT NULL default '1.0.0',
     `admin`     varchar(100) NOT NULL default 'admin',
     `time`      INT(10) NOT NULL default '0', 
     PRIMARY KEY  (id),
	 UNIQUE(pid)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_embed_template 
(
     `id`     int(8) unsigned NOT NULL auto_increment,
     `pid`    varchar(100) NOT NULL default '',  
     `name`   varchar(100) NOT NULL default '',
     `class`  varchar(100) NOT NULL default '',
     `file`   varchar(100) NOT NULL default '',
     `method` varchar(100) NOT NULL default '',
     `static` SMALLINT NOT NULL default '0',
     PRIMARY KEY  (id),
	 INDEX(name)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_hook_module 
(
     `id`     int(8) unsigned NOT NULL auto_increment,
     `pid`    varchar(100) NOT NULL default '', 
     `type`   int(8) NOT NULL default '0',
     `module` varchar(100) NOT NULL default '',
     `enter`  varchar(100) NOT NULL default '', 
     `action` varchar(100) NOT NULL default '', 
     `class`  varchar(100) NOT NULL default '',
     `file`   varchar(100) NOT NULL default '',
     `method` varchar(100) NOT NULL default '',
     `order` int(8) NOT NULL default '0',
     `static` SMALLINT NOT NULL default '0',
     PRIMARY KEY  (id),
	 INDEX(`module`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_modules (
  `id` int(8) unsigned NOT NULL auto_increment,
  `name` varchar(50) NOT NULL default '',
  `path` varchar(50) NOT NULL default '',
  `internal` tinyint(1) unsigned NOT NULL default '0',
  `state` tinyint(1) unsigned NOT NULL default '1',
  `time` int(10) unsigned NOT NULL default '0',
  `developer` varchar(100) NOT NULL default '',
  PRIMARY KEY  (id)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_announce (
  `id` int(8) unsigned NOT NULL auto_increment,
  `uid` int(10) unsigned NOT NULL default '0',
  `title` varchar(255) NOT NULL default '',
  `time` int(10) unsigned NOT NULL default '0',
  `hits` int(8) unsigned NOT NULL default '0',
  `rely` int(8) unsigned NOT NULL default '0',
  `detail` text,
  PRIMARY KEY  (id)
) engine = MyISAM DEFAULT charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_fav (
  `id` bigint unsigned NOT NULL auto_increment,
  `uid` int(10) unsigned NOT NULL default '0',
  `time` int(10) unsigned NOT NULL default '0',
  `title` varchar(100) NOT NULL default '',
  `url` varchar(255) NOT NULL default '', 
  PRIMARY KEY  (id),
  INDEX(uid),
  INDEX(url)
) engine = MyISAM DEFAULT charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_fav_detail (
  `id` bigint unsigned NOT NULL default '0',
  `uid` int(10) unsigned NOT NULL default '0',
  `title` varchar(200) NOT NULL default '',
  `url` varchar(255) NOT NULL default '',
  INDEX(id),
  INDEX(url)
) engine = MyISAM DEFAULT charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_collect_rule (
  `id` int(8) unsigned NOT NULL auto_increment,
  `model` int(8) unsigned NOT NULL default '0',
  `time` int(10) unsigned NOT NULL default '0',
  `title` varchar(255) NOT NULL default '',
  `base` varchar(255) NOT NULL default '',
  `data` text,
  PRIMARY KEY  (id),
  INDEX(model)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_collect_data (
  `id` int(8) unsigned NOT NULL auto_increment,
  `model` int(2) unsigned NOT NULL default '0',
  `time` int(1) unsigned NOT NULL default '0',
  `title` varchar(255) NOT NULL default '',
  `url` varchar(255) NOT NULL default '',
  `data` text,
  PRIMARY KEY  (id)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_config_upload (
  `id` int(8) unsigned NOT NULL auto_increment,
  `developer` tinyint(1) unsigned NOT NULL default '0',
  `internal` tinyint(1) unsigned NOT NULL default '0',
  `local` tinyint(1) unsigned NOT NULL default '1',
  `path` varchar(255) NOT NULL default '',
  `ftpmode` tinyint(1) unsigned NOT NULL default '0',
  `ftpuser` varchar(20) NOT NULL default '',
  `ftppass` varchar(255) NOT NULL default '',
  `note` varchar(255) NOT NULL default '',
  `maxsize` int(8) unsigned NOT NULL default '0',
  `host` varchar(255) NOT NULL default '',
  `ext` varchar(255) NOT NULL default '',
  PRIMARY KEY  (id),
  INDEX(`developer`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_config (
  `id` int(8) unsigned NOT NULL auto_increment,
  `file` varchar(100) NOT NULL default '',
  `developer` tinyint(1) unsigned NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `tag` varchar(20) NOT NULL default '',
  `note` varchar(255) NOT NULL default '',
  `format` tinyint(1) unsigned NOT NULL default '0',
  `content` text,
  PRIMARY KEY  (id),
  INDEX(`developer`),
  INDEX(`file`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_extend (
  `id` int(8) unsigned NOT NULL auto_increment,
  `name` varchar(100) NOT NULL default '',
  `table` varchar(100) NOT NULL default '',
  `uid` int(8) unsigned NOT NULL default '0',
  `developer` int(1) unsigned NOT NULL default '0',
  `time` int(10) unsigned NOT NULL default '0',
  `define` text,  
  PRIMARY KEY  (id),
  INDEX (`uid`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_extend_display (
  `id` int(8) unsigned NOT NULL auto_increment,
  `name` varchar(30) NOT NULL default '',
  `des` varchar(255) NOT NULL default '',
  PRIMARY KEY  (id)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_extend_type (
  `id` int(8) unsigned NOT NULL auto_increment,
  `name` varchar(30) NOT NULL default '',
  `des` varchar(255) NOT NULL default '',
  PRIMARY KEY  (id)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_extend_downloadgroup (
  `id` int(8) unsigned NOT NULL auto_increment,
  `name` varchar(30) NOT NULL default '',
  `des` varchar(255) NOT NULL default '',
  PRIMARY KEY  (id)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_extend_downloadtype (
  `id` int(8) unsigned NOT NULL auto_increment,
  `name` varchar(30) NOT NULL default '',
  `des` varchar(255) NOT NULL default '',
  PRIMARY KEY  (id)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_extend_softlang (
  `id` int(8) unsigned NOT NULL auto_increment,
  `name` varchar(30) NOT NULL default '',
  `des` varchar(255) NOT NULL default '',
  PRIMARY KEY  (id)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_extend_safe (
  `id` int(8) unsigned NOT NULL auto_increment,
  `name` varchar(30) NOT NULL default '',
  `des` varchar(255) NOT NULL default '',
  PRIMARY KEY  (id)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_extend_license (
  `id` int(8) unsigned NOT NULL auto_increment,
  `name` varchar(30) NOT NULL default '',
  `des` varchar(255) NOT NULL default '',
  PRIMARY KEY  (id)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_extend_source (
  `id` int(8) unsigned NOT NULL auto_increment,
  `name` varchar(30) NOT NULL default '',
  `des` varchar(255) NOT NULL default '',
  PRIMARY KEY  (id)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_extend_platform (
  `id` int(8) unsigned NOT NULL auto_increment,
  `name` varchar(30) NOT NULL default '',
  `des` varchar(255) NOT NULL default '',
  PRIMARY KEY  (id)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_extend_video (
  `id` int(8) unsigned NOT NULL auto_increment,
  `name` varchar(30) NOT NULL default '',
  `des` varchar(255) NOT NULL default '',
  PRIMARY KEY  (id)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_extend_letter (
  `id` int(8) unsigned NOT NULL auto_increment,
  `name` varchar(30) NOT NULL default '',
  `des` varchar(255) NOT NULL default '',
  PRIMARY KEY  (id)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_extend_language (
  `id` int(8) unsigned NOT NULL auto_increment,
  `name` varchar(30) NOT NULL default '',
  `des` varchar(255) NOT NULL default '',
  PRIMARY KEY  (id)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_extend_year (
  `id` int(8) unsigned NOT NULL auto_increment,
  `name` varchar(30) NOT NULL default '',
  `des` varchar(255) NOT NULL default '',
  PRIMARY KEY  (id)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_extend_area (
  `id` int(8) unsigned NOT NULL auto_increment,
  `name` varchar(30) NOT NULL default '',
  `des` varchar(255) NOT NULL default '',
  PRIMARY KEY  (id)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_extend_flag (
  `id` int(8) unsigned NOT NULL auto_increment,
  `name` varchar(30) NOT NULL default '',
  `des` varchar(255) NOT NULL default '',
  PRIMARY KEY  (id)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_extend_zodiac (
  `id` int(8) unsigned NOT NULL auto_increment,
  `name` varchar(30) NOT NULL default '',
  `des` varchar(255) NOT NULL default '',
  PRIMARY KEY  (id)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_extend_sex (
  `id` int(8) unsigned NOT NULL auto_increment,
  `name` varchar(30) NOT NULL default '',
  `des` varchar(255) NOT NULL default '',
  PRIMARY KEY  (id)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_extend_blood (
  `id` int(8) unsigned NOT NULL auto_increment,
  `name` varchar(30) NOT NULL default '',
  `des` varchar(255) NOT NULL default '',
  PRIMARY KEY  (id)
)  engine=MyISAM default charset = utf8;


CREATE TABLE IF NOT EXISTS xercms_column (
  `id` int(8) unsigned NOT NULL auto_increment,
  `mode` int(8) unsigned NOT NULL default '0',
  `parent` int(8) NOT NULL default '0',
  `name` varchar(100)  NOT NULL default '',
  `icon` varchar(50)  NOT NULL default '',
  `keyword` varchar(100)  NOT NULL default '',
  `admin` varchar(255)  NOT NULL default '',
  `des` varchar(255)  NOT NULL default '',
  `template` varchar(255)  NOT NULL default '',
  `url` varchar(255)  NOT NULL default '', 
  `display` tinyint(1) unsigned NOT NULL default '1', 
  `model` int(8) NOT NULL default '0',
  `son` int(8) NOT NULL default '0',
  `extra` text,
  PRIMARY KEY  (id),
  INDEX (`mode`),
  INDEX (`parent`),
  INDEX(`display`)
)  engine=MyISAM default charset = utf8;


CREATE TABLE IF NOT EXISTS xercms_model (
  `id` int(8) unsigned NOT NULL auto_increment,
  `uid` int(8) unsigned NOT NULL default '0',
  `time` int(10) unsigned NOT NULL default '0',
  `name` varchar(100)  NOT NULL default '',
  `separate` TINYINT(1) unsigned NOT NULL default '0',
  `category` TINYINT(1) unsigned NOT NULL default '0',
  `des` varchar(255)  NOT NULL default '',
  `table` varchar(30)  NOT NULL default '',
  `state` TINYINT(1) unsigned NOT NULL default '1',
  `struct` text,
  `template` text,
  PRIMARY KEY  (`id`),
  UNIQUE  (`table`),
  INDEX (`uid`)
)  engine=MyISAM  AUTO_INCREMENT = 100 default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_relate (
  `id` int(8) unsigned NOT NULL auto_increment,
  `model` int(10) NOT NULL default '0',
  `aid` int(10) NOT NULL default '0',
  `rid` int(10) NOT NULL default '0',
  PRIMARY KEY  (id),
  INDEX ( `model` ),
  INDEX ( `aid` ),
  INDEX ( `rid` )
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_nav (
  `id` int(8) unsigned NOT NULL auto_increment,
  `order` int(8) NOT NULL default '0',
  `name` varchar(80) NOT NULL default '',
  `url` varchar(255) NOT NULL default '',
  `parent` int(8) unsigned NOT NULL default '0',
  `son` int(8) unsigned NOT NULL default '0',
  `color` char(6) NOT NULL default '',
  `target` varchar(10) NOT NULL default '',
  `display` tinyint(1) unsigned NOT NULL default '1',
  `extra` varchar(255) NOT NULL default '',
  PRIMARY KEY  (id),
  INDEX (parent)
)  engine=MyISAM default charset = utf8;


CREATE TABLE IF NOT EXISTS xercms_links (
  `id` smallint(6) unsigned NOT NULL auto_increment,
  `group` int(8) unsigned NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `url` varchar(255) NOT NULL default '',
  `title` varchar(255) NOT NULL default '',
  `logo` varchar(255) NOT NULL default '',
  `time` int(10) unsigned NOT NULL default '0',
  `hits` mediumint(8) NOT NULL default '0',
  PRIMARY KEY  (id),
  INDEX (`group`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_guestbook (
  `id` smallint(6) unsigned NOT NULL auto_increment,
  `type` int(10) unsigned NOT NULL default '0',
  `uid` int(10) unsigned NOT NULL default '0',
  `name` varchar(100) NOT NULL default '',
  `email` varchar(100) NOT NULL default '',
  `qq` varchar(100) NOT NULL default '',
  `msn` varchar(100) NOT NULL default '',
  `tel` varchar(100) NOT NULL default '',
  `content` varchar(255) NOT NULL default '',
  `ip` varchar(16) NOT NULL default '',
  `time` int(10) unsigned NOT NULL default '0',
  `state` int(1) NOT NULL default '0',
  INDEX ( `type` ),
  INDEX ( `uid` ),
  INDEX ( `ip` ),
  INDEX ( `state` ),
  PRIMARY KEY  (id)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_ads (
  `id` int(8) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL default '',
  `group` int(8) NOT NULL DEFAULT '0',
  `time` int(10) NOT NULL DEFAULT '0',
  `note` varchar(255) NOT NULL default '',
  `stime` int(10) NOT NULL DEFAULT '0',
  `etime` int(10) NOT NULL DEFAULT '0',
  `content` text,
  PRIMARY KEY  (id)
)  engine=MyISAM default charset = utf8;
