CREATE TABLE IF NOT EXISTS xercms_forum_board (
  `bid` int(8) unsigned NOT NULL auto_increment,
  `parent` int(8) NOT NULL default '0',
  `son` int(8) NOT NULL default '0',
  `icon` varchar(100)  NOT NULL default '',
  `name` varchar(100)  NOT NULL default '',
  `keyword` varchar(100)  NOT NULL default '',
  `des` varchar(255)  NOT NULL default '',
  `admin` varchar(255)  NOT NULL default '',
  `template` varchar(255)  NOT NULL default '',
  `topic` int(10) NOT NULL default '0',
  `posts` int(10) NOT NULL default '0',
  `display` tinyint(1) unsigned NOT NULL default '1', 
  `outer` tinyint(1) NOT NULL default '0',
  `urlpath` varchar(100)  NOT NULL default '',
  `model` varchar(100)  NOT NULL default '',
  `tid` int(10) unsigned NOT NULL default '0',
  `pid` int(10) unsigned NOT NULL default '0',
  `detail` text,
  PRIMARY KEY  (`bid`),
  INDEX (`parent`),
  INDEX(`display`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_forum_search (
  `name` varchar(100) NOT NULL default '',
  `time` int(8) unsigned NOT NULL default '0',
  `ip` varchar(32) NOT NULL default '',
  `status` tinyint(1) unsigned NOT NULL default '0', 
  `count` int(8) unsigned NOT NULL default '1',
  INDEX (`name`),
  INDEX (`status`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_board_setting (
  `bid` int(8) unsigned NOT NULL auto_increment,
  `access` text,
  `credit` text, 
  `audit` SMALLINT NOT NULL DEFAULT '0',
  `order` varchar(10)  NOT NULL default '',
  `by` varchar(30)  NOT NULL default '',
  `number` SMALLINT NOT NULL default '0',
  `showrely` int(10) NOT NULL default '0',
  `resttime` int(10) NOT NULL default '0',
  `mustcat` SMALLINT NOT NULL DEFAULT '0',
  `opencat` SMALLINT NOT NULL DEFAULT '0', 
  `cats` varchar(255)  NOT NULL default '',
  PRIMARY KEY  (`bid`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_forum_moderator (
  `id` int(8) unsigned NOT NULL auto_increment,
  `bid`  int(10) unsigned NOT NULL default '0',
  `admin`  int(10) unsigned NOT NULL default '0', 
  `uid`  int(10) unsigned NOT NULL default '0',
  `time` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  INDEX  (`admin`),
  INDEX  (`bid`),
  INDEX  (`uid`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_forum_comment (
  `id` bigint(8) unsigned NOT NULL auto_increment,
  `state` smallint(1) unsigned NOT NULL default '0',
  `tid`  int(10) unsigned NOT NULL,
  `credit`  tinyint(3) unsigned NOT NULL default '0',
  `number`  int(8) NOT NULL default '0',
  `pid`  int(10) unsigned NOT NULL default '0',
  `uid`  int(10) unsigned NOT NULL default '0',
  `time` int(10) unsigned NOT NULL default '0',
  `say`  varchar(300)  NOT NULL default '',
  PRIMARY KEY  (`id`),
  INDEX  (`tid`),
  INDEX  (`pid`)
)  engine=MyISAM default charset = utf8;


CREATE TABLE IF NOT EXISTS xercms_topic_category (
  `id` int(8) unsigned NOT NULL auto_increment,
  `name`  varchar(100)  NOT NULL default '',
  PRIMARY KEY  (`id`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_topic_tags (
  `tid` int(10) unsigned NOT NULL,
  `tag` int(10) unsigned NOT NULL,
  `hits` int(10) unsigned NOT NULL,
  INDEX (`tid`),
  INDEX (`tag`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_tags_name (
  `tag` int(10) unsigned NOT NULL,
  `name` int(10) unsigned NOT NULL,
  INDEX (`tag`),
  INDEX (`name`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_forum_topic (
  `tid` int(10) unsigned NOT NULL auto_increment,
  `bid` int(8) unsigned NOT NULL default '0',
  `uid` int(8) unsigned NOT NULL default '0',
  `category` int(8) unsigned NOT NULL default '0', 
  `state` tinyint(1) NOT NULL default '0',
  `subject` varchar(100)  NOT NULL default '',
  `published` int(10) NOT NULL default '0',
  `edittime` int(10) NOT NULL default '0',
  `displayorder` int(2) unsigned NOT NULL default '0',
  `stamp` tinyint(3) unsigned NOT NULL default '0',
  `bold` tinyint(1) unsigned NOT NULL default '0',
  `color` tinyint(3) unsigned NOT NULL default '0',
  `digest` tinyint(1) unsigned NOT NULL default '0', 	
  `private` tinyint(1) unsigned NOT NULL default '0', 
  `limit` tinyint(1) unsigned NOT NULL default '0', 
  `model` int(3) NOT NULL default '0',
  INDEX (`tid`,`bid`),
  INDEX (`category`),
  INDEX (`state`),
  INDEX (`digest`),
  INDEX(`model`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_topic_data (
  `tid` int(10) unsigned NOT NULL default '0',
  `content` mediumtext,
  INDEX(`tid`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_topic_count (
  `tid` int(10) unsigned NOT NULL default '0',
  `pid` int(10) NOT NULL default '0',
  `hits` int(10) NOT NULL default '0',
  `rely` int(10) NOT NULL default '0',
  `flower` int(10) NOT NULL default '0',
  `egg` int(10) NOT NULL default '0',
  `favorites` int(10) NOT NULL default '0',
  `score` int(10) NOT NULL default '0',
  PRIMARY KEY  (`tid`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_forum_posts (
  `pid` int(10) unsigned NOT NULL auto_increment,
  `tid` int(8) unsigned NOT NULL default '0',
  `uid` int(10) unsigned NOT NULL default '0',
  `state` int(8) NOT NULL default '0',
  `published` int(10) NOT NULL default '0',
  `edittime` int(10) NOT NULL default '0',
  `displayorder` int(8) unsigned NOT NULL default '0', 
  `flower` int(8) NOT NULL default '0',
  `egg` int(8) NOT NULL default '0',
  `content` mediumtext,
  PRIMARY KEY  (`pid`),
  INDEX (`state`),
  INDEX(`tid`),
  INDEX(`uid`)
)  engine=MyISAM default charset = utf8;