CREATE TABLE IF NOT EXISTS xercms_member_upfiles (
  `id` int(8) unsigned NOT NULL auto_increment,
  `type` int(1) unsigned NOT NULL default '0',/*1,图片，2附件*/
  `uid` int(8) unsigned NOT NULL default '0',
  `time` int(10) unsigned NOT NULL default '0',
  `ip` varchar(32)  NOT NULL default '',
  `name` varchar(100)  NOT NULL default '',
  `url` varchar(100)  NOT NULL default '',
  `size` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (id),
  INDEX (`type`),
  INDEX (`uid`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_member_profile (
  `uid` int(8) NOT NULL auto_increment,
  `nick` varchar(50) NOT NULL default '',
  `letter` int(2) NOT NULL default '0',
  `ename` varchar(100) NOT NULL default '',
  `zodiac` int(10) NOT NULL default '0',
  `birthday` int(10) NOT NULL default '0',
  `sex` int(1) NOT NULL default '0',
  `blood` int(2) unsigned NOT NULL default '0',
  `area` int(8) unsigned NOT NULL default '0',
  `height` int(3) unsigned NOT NULL default '0',
  `weight` int(3) unsigned NOT NULL default '0',
  `avatar` varchar(100) NOT NULL default '',
  `job` varchar(100) NOT NULL default '',
  `sign` varchar(255) NOT NULL default '',
  `mobilephone` varchar(20) NOT NULL default '',
  `qq` varchar(20) NOT NULL default '',
  `telephone` varchar(50) NOT NULL default '',
  `email` varchar(50) NOT NULL default '',
  `address` varchar(255) NOT NULL default '',
  `address2` varchar(255) NOT NULL default '', 
  `group` int(8) NOT NULL default '0',
  PRIMARY KEY  (`uid`),
  INDEX(`group`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_member (
  `uid` int(8) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL default '',
  `pass` varchar(32) NOT NULL default '',
  `type` smallint(3) unsigned NOT NULL default '0',
  PRIMARY KEY  (`uid`),
  INDEX(`type`),
  UNIQUE KEY (`name`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_member_payment (
  `id` int(8) NOT NULL auto_increment,
  `name` varchar(30) NOT NULL default '',
  `handler` varchar(30) NOT NULL default '',
  `logo` varchar(255) NOT NULL default '',
  `state` tinyint(10) unsigned NOT NULL default '1',  
  `uid` int(10) unsigned NOT NULL default '0',
  `time` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_member_session (
  `uid` int(8) NOT NULL auto_increment,
  `ip` varchar(15) NOT NULL default '0',
  `time` int(10) NOT NULL default '0',
  `key` varchar(32) NOT NULL default '',
  PRIMARY KEY  (`uid`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_member_doing (
  `uid` int(10) unsigned NOT NULL default '0',
  `time` int(10) unsigned NOT NULL default '0',
  `content` varchar(400) NOT NULL default '',
  INDEX(uid)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_member_count (
  `uid` int(10) unsigned NOT NULL default '0',
  `upload` bigint unsigned  NOT NULL default '0',
  `topic` int(8) unsigned  NOT NULL default '0',
  `posts` int(8) unsigned  NOT NULL default '0',
  `fans` int(10) unsigned  NOT NULL default '0',
  `friends` int(10) unsigned  NOT NULL default '0',
  `message` int(8) unsigned  NOT NULL default '0',
  `unread` int(8) unsigned  NOT NULL default '0',
  `creditstips` text,
  PRIMARY KEY  (`uid`)
) engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_credit_order (
  `number` int NOT NULL auto_increment,
  `uid` int(10) unsigned NOT NULL default '0',
  `way` int(10) unsigned NOT NULL default '0',
  `money` int(10) unsigned NOT NULL default '0',
  `state` tinyint(10) unsigned NOT NULL default '0',/*0,待支付 1 支付成功,2 支付等待，2支付失败*/
  `time` int(8) unsigned  NOT NULL default '0',
  `outer` varchar(128) NOT NULL default '0', 
  PRIMARY KEY  (`number`),
  INDEX  (`uid`)
) engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_order_credit (
  `number` int(10) NOT NULL default '0',
  `des` text,
  INDEX  (`number`)
) engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_lang_template (
  `id` int(10) unsigned NOT NULL default '0',
  `pid` tinyint(1) NOT NULL default '0',
  `key` varchar(30) NOT NULL default '0',
  `text` varchar(400) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  INDEX(`pid`),
  INDEX(`key`)
) engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_lang_pack (
  `id` tinyint(3) unsigned NOT NULL default '0',
  `name` varchar(255) NOT NULL default '0',
  `des`  varchar(400) NOT NULL default '0',
  PRIMARY KEY  (`id`)
) engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_credits_change (
  `uid` int(10) unsigned NOT NULL default '0',
  `op` tinyint(1) NOT NULL default '0',
  `value` int(8) NOT NULL default '0',
  `creditid` tinyint(3) NOT NULL default '0',
  `eid` int(10) unsigned NOT NULL default '0',
  `time` int(10) NOT NULL default '0',
  PRIMARY KEY  (`uid`)
) engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_credits_explain (
  `eid` int(10) unsigned NOT NULL default '0',
  `text`  varchar(400) NOT NULL default '0',
  PRIMARY KEY  (`eid`)
) engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_member_friend (
  `uid` int(8) NOT NULL auto_increment,
  `fid` int(8) NOT NULL default '0',
  `time` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`uid`),
  INDEX(`fid`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_member_message (
  `id` int(8) NOT NULL auto_increment,
  `uid` int(8) NOT NULL,
  `send` int(8) NOT NULL default '0',
  `title` varchar(32) NOT NULL default '',
  `content` text,
  `time` int(10) unsigned NOT NULL default '0',
  `state` tinyint(2) NOT NULL default '0',
  PRIMARY KEY  (`id`),
  INDEX(`uid`),
  INDEX(`send`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_member_verify (
  `uid` int(8) NOT NULL auto_increment,
  `mailstatus` smallint(1) not null default '0',
  `mail_verify_time` int(10) not null default '0',
  PRIMARY KEY  (`uid`),
  INDEX(`mailstatus`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_verify_code 
(
  `uid` int(8) NOT NULL default '0',
  `str` varchar(32) not null default '0',
  `expired` int(10) not null default '0',
  INDEX(`uid`),
  INDEX(`str`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_member_setting (
  `uid` int(8) unsigned NOT NULL default '0',
  `content` MEDIUMTEXT,
  PRIMARY KEY  (`uid`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_member_credits (
  `uid` int(8) NOT NULL auto_increment,
  `credit1` int(10) unsigned NOT NULL default '0',
  `credit2` int(10) unsigned NOT NULL default '0',
  `credit3` int(10) unsigned NOT NULL default '0',
  `credit4` int(10) unsigned NOT NULL default '0',
  `credit5` int(10) unsigned NOT NULL default '0',
  `credit6` int(10) unsigned NOT NULL default '0',
  PRIMARY KEY  (`uid`)
)  engine=MyISAM default charset = utf8;


CREATE TABLE IF NOT EXISTS xercms_member_group (
  `id` int(8) NOT NULL auto_increment,
  `name` varchar(50) NOT NULL default '',
  `note` varchar(255) NOT NULL default '', 
  `top` int(8) NOT NULL default '0',
  `attr` varchar(20) NOT NULL default 'profile',
  PRIMARY KEY  (`id`),
  INDEX(top),
  INDEX(attr),
  UNIQUE KEY (name)
)  engine=MyISAM default charset = utf8;
