CREATE TABLE IF NOT EXISTS xercms_special (
  `id` int(10) unsigned NOT NULL auto_increment,
  `class` int(10) NOT NULL default '0',
  `uid` int(10) NOT NULL default '0',
  `title` varchar(60) NOT NULL default '',
  `color` varchar(6) NOT NULL default '',
  `path` varchar(60) NOT NULL default '',
  `note` varchar(100) NOT NULL default '',
  `tags` varchar(100) NOT NULL default '',
  `image` varchar(255) NOT NULL default '',
  `letter` tinyint(1) unsigned NOT NULL default '0',
  `flag` tinyint(1) unsigned NOT NULL default '0',
  `model` tinyint(3) unsigned NOT NULL default '0', 
  `editor` varchar(100) NOT NULL default '',
  `ctime` int(10) unsigned NOT NULL default '0',
  `state` tinyint(1) unsigned NOT NULL default '0',
  `comment` tinyint(1) unsigned NOT NULL default '0',
  `summary` text,
  `template` varchar(255) NOT NULL default '',
  PRIMARY KEY (`id`),
  INDEX(`uid`),
  INDEX(`flag`),
  INDEX(`state`) 
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_special_activity (
  `sid` int(10) NOT NULL default '0',
  `stime` int(10) NOT NULL default '0',
  `etime` int(10) NOT NULL default '0', 
  `limit` int(10) NOT NULL default '0',  
  `number` int(10) NOT NULL default '0',  
  `max` int(10) NOT NULL default '0',
  `credit` int(10) NOT NULL default '0',  
  `val` int(10) NOT NULL default '0', 
  `script` varchar(200) NOT NULL default '',
  INDEX (`sid`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_activity_member (
  `sid` int(10) NOT NULL default '0',
  `uid` int(10) NOT NULL default '0',
  `time` int(10) NOT NULL default '0', 
  INDEX (`sid`),
  INDEX(`uid`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_special_class (
  `id` int(10) NOT NULL auto_increment,
  `name` varchar(80) NOT NULL default '',
  `parent` int(10) NOT NULL default '0',
  PRIMARY KEY(`id`),
  INDEX(`parent`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_special_count (
  `sid` int(10) unsigned NOT NULL default '0',
  `fav` int(8) unsigned NOT NULL default '0',
  `hits` int(8) unsigned NOT NULL default '0',
  `flower` int(8) unsigned NOT NULL default '0',
  `egg` int(8) unsigned NOT NULL default '0',
  `comment` int(8) unsigned NOT NULL default '0', 
  INDEX (`sid`)
)  engine=MyISAM default charset = utf8;

CREATE TABLE IF NOT EXISTS xercms_special_comment(
  `sid` int(10) unsigned NOT NULL default '0',
  `uid` int(10) unsigned NOT NULL default '0',
  `say` varchar(400) NOT NULL default '',
  `ip` varchar(32) NOT NULL default '',
  `flower` int(10) unsigned NOT NULL default '0',
  `egg` int(10) unsigned NOT NULL default '0',
  `ctime` int(10) unsigned NOT NULL default '0',
  `stamp` tinyint(1) NOT NULL default '0',
  INDEX ( `stamp` ),
  INDEX ( `sid` )
)  engine=MyISAM default charset = utf8;