<?php
/**
 * @name     XERCMS
 * @author   Arno <XerCMS@163.com> [QQ:1328013]
 * @version  1.0.0
 * @link     http://www.XerCMS.com　
 */

define('VERSION', '1.1.6');

function __autoload($name) {
     if(class_exists($name))
	     return;
     X::import(strtolower($name));
}

class X
{
     public static $XERCMS; 
     public static $CONFIG;
     public static $CACHES;
     public static $INCLUDE;
     public static $compiler = NULL;
	public static $G;
	
     public static function import($file,$PATH = 'SYS') {
		switch($PATH) {
		     case 'SYS':
			     $file = INC.'Library/XerCMS_'.$file.'.php';
			break;
		     case 'libs':
			     $file = DIR.'libs/'.$file.'.php';
			break;
		     case 'utils':
			     $file = INC.'Utils/XerCMS_'.$file.'.php';
			break;
		     case null:break;
			default :
			     $file = $PATH.$file;
			break;
		}
		if (isset(self::$INCLUDE[$file])) {
		     return self::$INCLUDE[$file];
		}
		self::$INCLUDE[$file] = include($file);
		return self::$INCLUDE[$file];
     }  
	 	 
	public static function data($name) {
	     if (isset(self::$XERCMS['DATA'][$name])) {
		     return self::$XERCMS['DATA'][$name];
		}
		self::$XERCMS['DATA'][$name] = include(INC.'Data/'.$name.'.php');
	     return self::$XERCMS['DATA'][$name];
	}
	
     public static function Init() {
	     PHP_VERSION < 4 && exit('This version in not supported!');
		  
          $ROOT = explode('/',strtr(__file__,'\\','/'));array_splice($ROOT,-2);
          define('XERCMS',implode('/',$ROOT).'/');
          
          define('INC', XERCMS.'XerCMS/');
		define('LIB', INC.'Library/');
	      //ini_set('log_errors', 'On'); 
          //ini_set('error_log',  INC.'logs/'.date('Ymd').'.log');
          
	     self::$CONFIG = self::data('kernel');       
          date_default_timezone_set(isset(self::$CONFIG['timezone']) ? self::$CONFIG['timezone'] : @date_default_timezone_get());  
          
          register_shutdown_function(array('error','shutdown')); 
          set_exception_handler(array('error','exception')); 
          set_error_handler(array('error','syserror'));

          X::$G['runtime'] = microtime();
          X::$G['version'] = VERSION;

          X::$G['time'] = $_SERVER['REQUEST_TIME'];
	     self::import('base','utils');
          
          X::$G['ip'] = safeIp();//print_r($_SERVER);
          
		if(self::$CONFIG['urlmode'] == 'rewrite') {
		     URI::parse();
		     X::$G['delimiter'] = '';
		} else {
		     X::$G['delimiter'] = '?';		
		}
          
          if(isset(self::$CONFIG['domains']) && self::$CONFIG['domains'] == 'open') {
               domains();
          }         
		
          X::$CONFIG['state'] == 'close' && close();
          //ob_start('buffer');
		safe();
          if(!isset($_SESSION)) {
               session_save_path(INC.'Session');
               session_start();
          }
		
          X::$G['request'] = $_SERVER['REQUEST_URI'];
          X::$G['format'] = isset($_GET['format']) && $_GET['format'] == 'json' ? 'json' : 'html';
          X::$G['agent'] = strtolower($_SERVER['HTTP_USER_AGENT']);
          
          if(isset($_GET['mobile']) || strpos(X::$G['agent'],'mobile') !== false || strpos(X::$G['agent'],'phone') !== false) {
               define('MOBILE',true);    
          } else define('MOBILE',false);
          
 		define('URLPATH', X::$G['urlpath']);
          X::$G = array_merge(X::data('globals'),X::$G);
	     member();
          X::$G['time'] = $_SERVER['REQUEST_TIME'];
     }
  
     public static function check($str) {
          if(preg_match('/[^0-9a-z\_]/i',$str) || isset($str{32})) {
			header('Location: /');
			exit;
	     }	
	}
	
     public static function load($tpl = '') {     
		$G = &X::$G;X::$G['enter'] = g('e');X::$G['enter'] = empty(X::$G['enter']) ? 'index' : X::$G['enter'];
          self::check(X::$G['enter']);
		if(isset($tpl{1})) {
               hooks(1,0);
		     include(tpl($tpl));
               hooks(5,0);
		} else if(isset($_GET['m'])) {   
		     X::$G['module'] = g('m');self::check(X::$G['module']);
               if (!X::$G['CYK'] && !in_array(X::$G['module'],self::$CONFIG['modules'])) {
                    showtips('module_noexists',X::$G['urlpath']);
               }   
               define('DIR',INC.'Modules/'.X::$G['module'].'/');
               X::$G['action']  = (string)g('a','XerCMS');self::check(X::$G['a']); 
               hooks(1,1); 
               include(DIR.X::$G['enter'].'.php');
			$XM = 'XerCMS_MODULE_'.X::$G['enter'];
               if(class_exists($XM,false)) {			                         
                    $Xer = new $XM();//print_r($Xer);exit;
				hooks(2,1);
				if(method_exists($Xer,X::$G['action']))
				     $Xer->$G['action']();
               }	
               hooks(5,1);                
		} else if(isset($_GET['p'])) {
               $plugin = (string)g('p');self::check($plugin);            
               define('DIR',INC.'Plugins/'.$plugin.'/');X::$G['module'] = &$plugin;
               X::$G['action']  = (string)g('a','XerCMS');self::check(X::$G['a']); 
               hooks(1,2);	
               include(DIR.X::$G['enter'].'.php');
               hooks(5,2);
		} else if(isset($_GET['s'])) {
		     X::$G['service'] = (string)g('s');self::check(X::$G['service']);
			X::$G['action']  = (string)g('a','xercms');self::check(X::$G['a']);//print_r(X::$G);exit;
               define('DIR',INC.'Services/'.X::$G['service'].'/');
               X::$G['module'] = &X::$G['service'];
               hooks(1,3);
			self::import(X::$G['enter'].'.php',DIR);
			$SN = 'Service_'.X::$G['service'].'_'.X::$G['enter'];
               if(class_exists($SN,false)) {
                    $Xer = new $SN();//print_r($Xer);exit;
				//$Xer->Init();
                    hooks(2,3);
				if(method_exists($Xer,X::$G['action']))
				     $Xer->$G['action']();
               }
               hooks(5,3);
		} else {
               X::$G['module'] = 'home';X::$G['enter'] = '';
               hooks(1,5);
               include(tpl('common/xercms.htm'));
               hooks(5,5);               
		}
          exit;
     }
}

class DbError extends Exception{}
class TpError extends Exception{}
?>