<?php
/**
 * @name     XERCMS
 * @author   Arno <XerCMS@163.com> [QQ:1328013]
 * @version  1.0.0
 * @link     http://www.XerCMS.com
 */

!defined('XERCMS') && exit('Access Denied');

include_once(dirname(__file__).'/model/XerCMS_swop.php');

class archive extends swop
{
     var $models;
     var $uid = 0;
	var $struct = array('id' => array('type'=>'int','default'=>null),
	                'column' => array('type'=>'int','default'=>0), 
	                  'area' => array('type'=>'int','default'=>0), 
	                  'lang' => array('type'=>'int','default'=>0),                      
			       'title' => array('type'=>'text','default'=>'','range'=>array(1,60)), 
			        'icon' => array('type'=>'int','default'=>null),
			       'ctime' => array('type'=>'int','default'=>0), 
			       'mtime' => array('type'=>'int','default'=>0), 
				  'image' => array('type'=>'text','default'=>'','range'=>array(1,255)), 
				   'flag' => array('type'=>'int','default'=>0),
				  'state' => array('type'=>'int','default'=>0),                        
				 'comment'=> array('type'=>'int','default'=>0));
	var $model = null;
     var $arcData = null;
	var $admin = false;
	var $error = '';
	

     function loadModel($id) {
	     $models = ini('archives/models');
		if(isset($models[$id])) {
		    $this->model = ini('archives/model/'.$models[$id]['table']);
		    return true;
		} else return false;
     }

     
	function unaudited($page = 1,$number = 30) {
          return DB::fetch_all('SELECT a.*,m.name,b.table FROM xercms_archives a 
               LEFT JOIN xercms_member m on m.uid = a.uid 
			LEFT JOIN xercms_model b on b.id = a.model 
			WHERE a.state = 0 ORDER BY a.mtime DESC LIMIT '.(($page -1)*$number).','.$number);	
	}
  
  
     function lists($page = 1,$number = 30,$column = 0,$title = null,$model = null,$state = null,$uid = 0) {
	     $where = array();
		if($column > 0) $where[] = 'a.column = \''.(int)$column.'\'';
		if(!empty($title)) $where[] = 'a.title like \'%'.$title.'%\'';	
		if(!empty($model)) $where[] = 'a.model = \''.(int)$model.'\'';	
		if(!empty($uid)) $where[] = 'a.uid = \''.(int)$uid.'\'';
		if($state !== null) $where[] = 'a.state = \''.(int)$state.'\'';	
          if(count($where) > 0) {
		   $where = ' WHERE '.implode(' AND ',$where);
		} else $where = '';	
          return DB::fetch_all('SELECT a.*,m.name,b.table,c.name as cname FROM xercms_archives a 
               LEFT JOIN xercms_member m on m.uid = a.uid 
			LEFT JOIN xercms_model b on b.id = a.model
			LEFT JOIN xercms_column c on c.id = a.column
			'.$where.' ORDER BY a.mtime DESC LIMIT '.(($page - 1)*$number).','.$number);	
	}
	
	function select($id) {
		if(empty($id)) {
               $this->arcData = $this->defaults();
			return $this->arcData;
		}
		if(isset($this->model['category']) && $this->model['category'] == 1) {
			$this->arcData = DB::result('SELECT * FROM xercms_archives a 
			LEFT JOIN xercms_data_'.$this->model['table'].' b ON b.id = a.id
			LEFT JOIN xercms_count c ON c.id = a.id 
			LEFT JOIN xercms_shop_archive s ON s.aid = a.id WHERE '.(empty($this->uid) ? '' : 'a.uid = \''.$this->uid.'\' AND ').' a.id = \''.$id.'\'');
		} else {
			$this->arcData = DB::result('SELECT * FROM xercms_archives a
			LEFT JOIN xercms_data_'.$this->model['table'].' b ON b.id = a.id
			LEFT JOIN xercms_count c ON c.id = a.id WHERE '.(empty($this->uid) ? '' : 'a.uid = \''.$this->uid.'\' AND ').' a.id = \''.$id.'\'');
		}
		if(empty($this->arcData)){
			$this->arcData = $this->defaults();
		}
		return  $this->arcData;
  	}
    
	function dedata() {
		return $this->decode($this->model['struct'],$this->arcData);
	}
  
	function defaults() {
		$data = array();
		foreach($this->model['struct'] as $k=>$v) {
			if(isset($v['name'])) {
				$data[$v['name']] = $v['type'] == 'json' ? array() : $v['default'];
	    		}
	  	}
		foreach($this->struct as $k=>$v) {
			$data[$k] = $v['default'];
		}
		return  $data;
	}


  
	function setState($ids,$val = 1) {
     	$ids = $this->safeIds($ids);
     	if(empty($ids)) {
	   		return;
		}
		if($this->admin) {DB::query('UPDATE xercms_archives SET state = '.$val.' WHERE id  in ('.$ids.')');} else {
			if(!empty($this->uid)) {
				DB::query('UPDATE xercms_archives SET state = '.$val.' WHERE id  in ('.$ids.') AND uid = '.$this->uid);
			}
		}
    
	}
  
	function safeIds($str) {
     	$str = explode(',',$str);
		foreach($str as $k=>$v) {$str[$k] = (int)$v;}
		return implode(',',$str);
  	}
  
  	function delete($ids) {
     	$ids = $this->safeIds($ids);
     	if(empty($ids)) {
			return;
		}
		//exit('SELECT a.id,m.table FROM xercms_archives a LEFT JOIN xercms_model m ON m.id = a.model WHERE a.id in ('.$ids.')');
    		$data = DB::fetch_all('SELECT a.id,m.table FROM xercms_archives a LEFT JOIN xercms_model m ON m.id = a.model WHERE a.id in ('.$ids.')');
    		$dels = array();
    		foreach($data as $v) {
          	if(!empty($v['table'])){
				$dels[$v['table']][] = $v['id'];	
	    		}	
    		}
    		foreach($dels as $k=>$v) {
			DB::query('DELETE FROM xercms_data_'.$k.' WHERE id in ('.implode(',',$v).')');
			DB::query('DELETE FROM xercms_comment_'.$k.' WHERE aid in ('.implode(',',$v).')');
    		}
    		DB::query('DELETE FROM xercms_archives WHERE id in('.$ids.')');
    		DB::query('DELETE FROM xercms_count WHERE id in ('.$ids.')');   
	}
  
    function shopUpdate($price,$number,$aid = 0,$mid = 0,$new = false) {
		if($new) {
			DB::insert('xercms_shop_archive',array('aid'=>$aid,'mid'=>$mid,'number'=>$number,'price'=>$price));
		} else DB::update('xercms_shop_archive',array('number'=>$number,'price'=>$price),array('aid'=>$aid,'mid'=>$mid));
	}
	
	function insert($base,$data) {
     	$base = $this->check($base,'base');  
		unset($base['id']);$base['ctime'] = $base['mtime'] = X::$G['time'];
		if(!$this->admin) {
	     	unset($base['flag']);
	 	}
	 
	 
	 	if(empty($base['title'])) {
	     	$this->error = '标题不能为空';return;
	 	}
	 	$base['model'] = $this->model['id'];
	 	$base = $this->safe($base,$this->struct);
	 	$base['uid'] = X::$G['uid'];
          if(isset($base['image']{5})) {
               $base['icon'] = 1;
          } else $base['icon'] = 0;  
	 	$id = DB::insert('xercms_archives',$base);
	 	$data = $this->check($data);

	 	$data = $this->encode($this->model['struct'],$data);

	 	$data = $this->safe($data,$this->model['struct']); 
	 	$data['id'] = $id;
	 
      	DB::insert('xercms_data_'.$this->model['table'],$data);
	 	DB::insert('xercms_count',array('id'=>$id));
		if(isset($this->model['category']) && $this->model['category'] == 1) {
			$shop = p('shop');
			$price  = isset($shop['price']) ? (int)$shop['price'] : 0;
			$number = isset($shop['number']) ? (int)$shop['number'] : 0;
			$this->shopUpdate($price,$number,$id,$this->model['id'],true);
		}
		return $id;
  	}
  
    	function safe($data,$struct) {
      	foreach($struct as $k=>$v) {
			if(isset($data[$k])) {
		        	if($v['type'] == 'int') {
			       	$data[$k] = (int)$data[$k];
                      	if($data[$k] < $v['range'][0]) {
                           	$data[$k] = $v['range'][0];
                     	} else if (isset($v['range'][1]) && $data[$k] > $v['range'][1]) {
                           	$data[$k] = $v['range'][1];
                      	}
			   	} else if ($v['type'] == 'float') {
			       	$data[$k] = (float)$data[$k];
                      	if($data[$k] < $v['range'][0]) {
                           	$data[$k] = $v['range'][0];
                      	} else if (isset($v['range'][1]) && $data[$k] > $v['range'][1]) {
                           	$data[$k] = $v['range'][1];
                      	}
			   	} else if ($v['type'] == 'html') {
                    	$max = isset($v['range'][1]) ? $v['range'][1] : $v['range'][0];
                    	if(strlen($data[$k]) > $max) {
                         	$data[$k] = mb_substr($data[$k],0,$max);
                    	}               
			     	$data[$k] = html($data[$k]);

			   	} else{
                    	$max = isset($v['range'][1]) ? $v['range'][1] : $v['range'][0];
                    	if(strlen($data[$k]) > $max) {
                         	$data[$k] = mb_substr($data[$k],0,$max);
                    	}     
			      	$data[$k] = htmlchars($data[$k]);
			   	}
			}
		}
		return $data;
	}
    
	function access($uid) {
        	if($this->admin) {
	       	return true;
	   	} else {
	       	if(empty(X::$G['uid'])  || $uid != X::$G['uid']) {
		     	return false;
		  	} else return true;
	   
	   	}
    	}
    
    	function update($id,$base,$data) {
		if(empty(X::$G['uid'])) {
			return false;
	 	}
	
      	$base = $this->check($base,'base');
      
	 	unset($base['id'],$base['model'],$base['ctime']);$base['ctime'] = $base['mtime'] = X::$G['time'];
	 	if(!$this->admin) {
	     	unset($base['flag']);
	 	}
	 
	 
	 	if(empty($base['title'])) {
	     	$this->error = '标题不能为空';return;
	 	}
          
     	if($this->arcData == null) {
	   		$this->arcData = $this->select($id); 
		}          
	 	$base = $this->safe($base,$this->struct);
	 	$base = $this->contrast($id,$base);$base['mtime'] = X::$G['time'];
          if(isset($base['image']{5})) {
               $base['icon'] = 1;
          } else $base['icon'] = 0;  
	 	if(count($base)) {
	 		DB::update('xercms_archives',$base,array('id'=>$id));
	 	}
	 	$data = $this->check($data);
      	$data = $this->filter($data);

	 	if(!$this->access($this->arcData['uid'])) {
	    		$this->error = '权限不够，无法操作。';return;
	 	} 
	 	$data = $this->encode($this->model['struct'],$data);

	 	$data = $this->safe($data,$this->model['struct']); 
	 	$data = $this->contrast($id,$data);
      	if(count($data)) {DB::update('xercms_data_'.$this->model['table'],$data,array('id'=>$id));}
		if(isset($this->model['category']) && $this->model['category'] == 1) {
			$shop = p('shop');
			$price  = isset($shop['price']) ? (int)$shop['price'] : 0;
			$number = isset($shop['number']) ? (int)$shop['number'] : 0;
			$this->shopUpdate($price,$number,$id,$this->model['id'],false);
		}
  	} 
  
	function filter($data) {
		foreach($this->model['struct'] as $k=>$v) {
		     if(!$v['editable']) {
			      unset($data[$k]);
			}
		}
		return $data;
	}
  
	function check($data,$table = '') {
      	$ndata = array();
     	switch($table) {
	     	case 'base':
		    		$ndata = array();
		    		foreach($this->struct as $k=>$v) {
		        		if(isset($data[$k])) {
			       		$ndata[$k] = $data[$k];
			   		}
		    		}
		    
			break;
	     	default:
		    		$ndata = array();	
      			foreach($this->model['struct'] as $k=>$v) {
		        		if(isset($data[$k])) {
			       		$ndata[$k] = $data[$k];
			   		} else {
			      		if($v['required']) {
				 			$ndata[$k] = $v['default'];
				 		}
			   		}
	  			}
			break;	
	 	}
	 	return $ndata;
  	}
  
	function contrast($id,$ndata) {
		foreach($ndata as $k=>$v) {
			if($v == $this->arcData[$k] ) {
				unset($ndata[$k]);
	  		}
		}
		return $ndata;
  	}
}
?>