<?php
/**
 * @name     XERCMS
 * @author   Arno <XerCMS@163.com> [QQ:1328013]
 * @version  1.0.0
 * @link     http://www.XerCMS.com　
 */

!defined('XERCMS') && exit('Access Denied');

class resource
{
     private $temp      = '';
     public  $table     = '';
     private $update    = '';
     private $fields    = '*';	
     private $where     = '';	 
     private $left  = '';
     private $right = '';	
     private $order = '';	 	 
     private $limit     = ' LIMIT 30';	
     private $result    = NULL;
	 
     function table($name) {
	 	$this->table = $name; 
		return $this;
	}

	function istable($str) {
	     if(isset($str{30}) || preg_match('/([^0-9a-z\.\_])/i',$str)) {
		     throw new DbError('Error Table!');
		} else return $str;
	}
	 
	function isfield($str) {
	     if(isset($str{30}) || preg_match('/([^0-9a-z\.\_])/i',$str)) {
		     throw new DbError('Error Field!');
		} else return $str;
	}
	 
	function isVal($str) {
	     if(strpos($str,'\'') === false)
		     return $str;
		$str = explode('\\\'',$str);
		foreach($str as $k=>$v) {
		     if(strpos($v,'\'') !== false)
			     $str[$k] = implode('&#39;',explode('\'',$v));
		}
		return implode('\\\'',$str);
	}
	 
	function limit($str) {
	     if(isset($str{30}) || preg_match('/([^0-9 \,])/i',$str))
		     return;
	     $this->limit = ' LIMIT '.$str;
		return $this;
	}
	 
	function field($arr) {
          if(is_string($arr))
		     $arr = explode(',',$arr);
		$this->temp = array();
	 	foreach($arr as $v) {
	 	  	$this->temp[] = $this->isfield($v);
	 	}
          $this->fields = implode(',',$this->temp);
		return $this;
	}
	 
	function clear() {
	     $this->fields    = '*';
	     $this->where     = '';
	     $this->update    = '';
	     $this->left  = '';
	     $this->right = '';
		$this->order = '';
	     $this->limit     = ' LIMIT 30'; 
		 $this->table     = isset($this->defaultTable) ? $this->defaultTable : $this->table;
	}

	function left() {
	     $args = func_get_args();
		if(count($args) < 2)
		     return;
		$this->left .= ' LEFT JOIN '.$this->istable($args[0]);unset($args[0]);
		$this->left .= implode(' AND ',$args);
		return $this;		  
	}
	 
	function right() {
	     $args = func_get_args();
		if(count($args) < 2)
		     return;
		$this->left .= ' RIGHT JOIN '.$this->istable($args[0]);unset($args[0]);
		$this->left .= implode(' AND ',$args);
		return $this;		  
	} 
	 
	function inner() {
	     $args = func_get_args();
		if(count($args) < 2)
		     return;
		$this->left .= ' INNER JOIN '.$this->istable($args[0]);unset($args[0]);
		$this->left .= implode(' AND ',$args);
		return $this;		  
	}	 
	 
	function where($arr) {
	     if(is_array($arr)) {
          	$this->temp = array();
	 	  	foreach($arr as $k=>$v) {
	 	 	  	$this->temp[] = '`'.$this->isfield($k).'` = \''.$this->isVal($v).'\'';
	 	  	}	
		  	$this->where = empty($this->temp) ? '' : ' WHERE '.implode(' AND ',$this->temp);
          } else $this->where = empty($arr) ? '' : ' WHERE '.$arr;	  
		return $this;		  
	}
	 
	function delete($arr = array(),$ret = true) {
	     if(!empty($arr)) {
	      	if(is_array($arr)) {
          	 	$this->temp = array(); 
	 	  	 	foreach($arr as $k=>$v) {
	 	 	 	  	$this->temp[] = '`'.$this->isfield($k).'` = \''.$this->isVal($v).'\'';
	 	 	 	}
			 	$this->where = empty($this->temp) ? '' : ' WHERE '.implode(' AND ',$this->temp);
          	} else $this->where = $arr;	
		}
	 	DB::query('DELETE FROM '.$this->table.$this->where);
		$this->clear();
	 	return $ret ? DB::affected_rows() : 0;	 
	}
	 
	function update($arr,$ret = true) {
          $this->temp = array();
          //print_r($arr);
	 	foreach($arr as $k=>$v) {
	 	 	$this->temp[] = '`'.$this->isfield($k).'` = \''.$v.'\'';
	 	}	 
		if(empty($this->temp))
		     return;
		//exit('UPDATE '.$this->table.' SET '.implode(',',$this->temp).$this->where);
	 	DB::query('UPDATE '.$this->table.' SET '.implode(',',$this->temp).$this->where);
		$this->clear();
	 	return $ret ? DB::affected_rows() : 0;	 
	}
	 
	function insert($arr,$ret = true) {
	 	foreach($arr as $k=>$v) {
	 	 	$data[] = '`'.$this->isfield($k).'` = \''.$this->isVal($v).'\'';
	 	}
	 	DB::query('INSERT INTO '.$this->table.' SET '.implode(',',$data));
		$this->clear();
	 	return $ret ? DB::lastid() : 0;	 
	}
	 
	function select($ret = 1) {
	     if($ret === 1) {   
		  	$this->result =  DB::result('SELECT '.$this->fields.' FROM '.$this->table.$this->left.$this->right.$this->inner.$this->where.$this->limit);
		} else {
	 	     $this->result =  DB::fetch_all('SELECT '.$this->fields.' FROM '.$this->table.$this->left.$this->right.$this->inner.$this->where.$this->limit);
		}
		$this->clear();
		return $this->result;
	}
}
?>