<?php
/**
 * @name     XERCMS
 * @author   Arno <XerCMS@163.com> [QQ:1328013]
 * @version  1.0.0
 * @link     http://www.XerCMS.com　
 */

!defined('XERCMS') && exit('Access Denied');

class Valid
{
     var $error = array();
     
     function setError($tips) {
          $this->error[] = $tips;
     }
     
     function getError($format = 'html') {
          switch($format) {
               case 'json':
                    return json_encode($this->error);
               break;
               default:
                    return implode('<br/>',$this->error);
               break;
          }         
     }
     
     function isNumber($str) {
          return is_numeric((string)$str);
     }
     
     function isMail($str) {
          if(isset($str{5}) && strpos($str,'.') !== false) {
               $str = explode('.',$str);
               if(count($str) == 2 && strpos($str[0],'@') !== false) {
                    return true;
               }
          }
          return false;
     }
     
     function isDomain($str) {
          $str = trim($str);
          if(isset($str{2}) && strpos($str,'.') !== false) {
               $pos = strpos($str,'.');
               if($pos !== 0 && $pos !== strlen($str)) {
                    return true;
               }
          }
          return false;
     }
     
     function isIp($val) {
          if(strpos($val,':') === false) {
               $val = explode('.',$val);
               if(count($val) != 4)
                    return false;                    
               foreach($val as $v) {
                    if($v < 0 || $v > 255) {
                         return false;
                    }
               }
               return true;               
          } else {
               return preg_match('([^0-9a-zA-Z\:\/]+)',$val) ? false : true;
          }
     }  	 
}
?>