<?php
/**
 * @name     XERCMS
 * @author   Arno <XerCMS@163.com> [QQ:1328013]
 * @version  1.0.0
 * @link     http://www.XerCMS.com　
 */

!defined('XERCMS') && exit('Access Denied');

include_once(dirname(__file__).'/imagecreatefrombmp.php');
class image
{
     var $config;
     var $source;
	var $file;
	var $formats = array(1,2,3,6);
	var $format;
	var $images;
    var $info;
	
	function __contruct() {
	     @ini_set('memory_limit', '128M');
	}
	
	function handle($file) {
          if(empty($this->config['thumbs']))
               return;
		$this->info =  getimagesize($file);
		//$this->format = exif_imagetype($file);
		if(!$this->info || !in_array($this->info[2],$this->formats)) {
		     return;
		}
		$this->file = $file;
	     foreach($this->config['thumbs'] as $v){
	         $this->thumb($v['width'],$v['height'],$v['cut'],$v['quality']);    
	     }
		return $this->images;
	}
	
	function Init($params) {
	     $this->config = $params;
	}
	
	function ext($file) {
	     $file = explode('.',$file);
		return $file[count($file) - 1];	
	}
	
	function create() {
	     $this->source = null;
	     switch($this->format) {
			case IMAGETYPE_JPEG:
			     $this->source = imagecreatefromjpeg($this->file);
			break;
			case IMAGETYPE_JPEG:
			     $this->source = imagecreatefromjpeg($this->file);
			break;
			case IMAGETYPE_GIF:
			     $this->source = imagecreatefromgif($this->file);
			break;
			case IMAGETYPE_PNG:
			     $this->source = imagecreatefrompng($this->file);
				//imagesavealpha($this->source, true);
			break;
			case IMAGETYPE_BMP:
			     $this->source = imagecreatefrombmp($this->file);
			break;			
	     }
		
	}
	
	function save($quality) {
	     switch($this->format) {
			case IMAGETYPE_JPEG:
			     imagejpeg($this->img,$this->dst,$quality);
			break;
			case IMAGETYPE_BMP:
			     imagejpeg($this->img,$this->dst,$quality);
			break;
			case IMAGETYPE_GIF:
			     imagegif($this->img,$this->dst);
			break;
			case IMAGETYPE_PNG:
			     imagepng($this->img,$this->dst,ceil($quality/100));
			break;		
	     }
		$this->images[] = $this->dst;
	}
	
     function thumb($width,$height,$cut = 'no',$quality = '75') {
        $info = &$this->info;
		if(!$info) return;
		$this->create();
		if($this->source == null) return;
		$ratio = $info[0]/$info[1];
		
		$nWidth = $info[0];$nHeight = $info[2];
		if ($info[0] > $width) {
		     $nWidth = $width;
			$nHeight = $nWidth/$ratio;//exit($ratio.'=');
			if($nHeight > $height && $cut == 'yes') {
			     $nHeight = $height;
			}
		} else if($info[1] > $height) {
		     $nWidth = $info[0];
		     if ($cut == 'yes'){
			     $nHeight = $height;
			} else $nHeight = $info[1];
		}
		$nWidth = (int)$nWidth;$nHeight = (int)$nHeight;
		//print_r($nWidth.'|'.$nHeight);exit();
		$this->dst = strtr($this->file,array('.'=>'!'.$width.'x'.$height.'.'));
		$this->img = imagecreatetruecolor($nWidth,$nHeight);
		/*From the Internet*/
          if(($info[2] == IMAGETYPE_GIF) || ($info[2] == IMAGETYPE_PNG)) { 
               $transparent = imagecolortransparent($this->source); 
               if ($transparent >= 0) {
                    $color = imagecolorsforindex($this->source, $transparent); 
                    $transparent = imagecolorallocate($this->img, $color['red'], $color['green'], $color['blue']); 
                    imagefill($this->img, 0, 0, $transparent); 
                    imagecolortransparent($this->img, $transparent); 
               } elseif ($info[2] == IMAGETYPE_PNG) { 
                    imagealphablending($this->img, false); 
                    $color = imagecolorallocatealpha($this->img, 0, 0, 0, 127); 
                    imagefill($this->img, 0, 0, $color); 
                    imagesavealpha($this->img, true); 
               } 
          }
		imagecopyresampled($this->img,$this->source,0,0,0,0,$nWidth,$nHeight,$info[0],$info[1]);
		$this->save($quality);
		imagedestroy($this->img);
		$this->source = null;
     }
}
?>